/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Control','./library','sap/ui/core/library','sap/ui/core/ResizeHandler','sap/ui/core/RenderManager','./SplitterRenderer',"sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/layout/SplitterLayoutData"],function(C,l,c,R,a,S,L,q,b){"use strict";var O=c.Orientation;var r=16;var d=C.extend("sap.ui.layout.Splitter",{metadata:{library:"sap.ui.layout",properties:{orientation:{type:"sap.ui.core.Orientation",group:"Behavior",defaultValue:O.Horizontal},width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:'100%'},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:'100%'}},defaultAggregation:"contentAreas",aggregations:{contentAreas:{type:"sap.ui.core.Control",multiple:true,singularName:"contentArea"}},events:{resize:{parameters:{id:{type:"string"},oldSizes:{type:"int[]"},newSizes:{type:"int[]"}}}},designtime:"sap/ui/layout/designtime/Splitter.designtime"}});var o=sap.ui.getCore().getLibraryResourceBundle("sap.ui.layout");d.prototype.init=function(){this._needsInvalidation=false;this._liveResize=true;this._keyboardEnabled=true;this._bHorizontal=true;this._calculatedSizes=[];this._move={};this._resizeTimeout=null;this._resizeCallback=this._delayedResize.bind(this);this._resizeHandlerId=null;this._autoResize=true;this.enableAutoResize();this._boundBarMoveEnd=this._onBarMoveEnd.bind(this);this._boundBarMove=this._onBarMove.bind(this);this._switchOrientation();this._bRtl=sap.ui.getCore().getConfiguration().getRTL();this._keyListeners={increase:this._onKeyboardResize.bind(this,"inc",20),decrease:this._onKeyboardResize.bind(this,"dec",20),increaseMore:this._onKeyboardResize.bind(this,"incMore",20),decreaseMore:this._onKeyboardResize.bind(this,"decMore",20),max:this._onKeyboardResize.bind(this,"max",20),min:this._onKeyboardResize.bind(this,"min",20)};this._enableKeyboardListeners();this._bUseIconForSeparator=true;};d.prototype.exit=function(){this.disableAutoResize();delete this._resizeCallback;delete this._boundBarMoveEnd;delete this._boundBarMove;delete this._$SplitterOverlay;delete this._$SplitterOverlayBar;};d.prototype.triggerResize=function(g){if(g){this._resize();}else{this._delayedResize();}};d.prototype.getCalculatedSizes=function(){return this._calculatedSizes;};d.prototype.enableAutoResize=function(t){if(t&&!this._autoResize){return;}this._autoResize=true;var g=this;sap.ui.getCore().attachInit(function(){g._resizeHandlerId=R.register(g,g._resizeCallback);});this._delayedResize();};d.prototype.disableAutoResize=function(t){R.deregister(this._resizeHandlerId);if(!t){this._autoResize=false;}};d.prototype.enableLiveResize=function(){this._liveResize=true;this.$().toggleClass("sapUiLoSplitterAnimated",false);};d.prototype.disableLiveResize=function(){this._liveResize=false;this.$().toggleClass("sapUiLoSplitterAnimated",true);};d.prototype.enableKeyboardSupport=function(){var B=this.$().find(".sapUiLoSplitterBar");B.attr("tabindex","0");this._enableKeyboardListeners();};d.prototype.disableKeyboardSupport=function(){var B=this.$().find(".sapUiLoSplitterBar");B.attr("tabindex","-1");this._disableKeyboardListeners();};d.prototype.onBeforeRendering=function(){this._switchOrientation();};d.prototype.onAfterRendering=function(){this._$SplitterOverlay=this.$("overlay");this._$SplitterOverlayBar=this.$("overlayBar");this._$SplitterOverlay.detach();this._resize();};d.prototype.onLayoutDataChange=function(){this._delayedResize();};d.prototype.ontouchstart=function(j){if(this._ignoreTouch){return;}var i=this.getId();if(!j.target.id||j.target.id.indexOf(i+"-splitbar")!=0){return;}if(!j.changedTouches||!j.changedTouches[0]){return;}this._ignoreMouse=true;this._onBarMoveStart(j.changedTouches[0],true);};d.prototype.onmousedown=function(j){if(this._ignoreMouse){return;}var i=this.getId();if(!j.target.id||j.target.id.indexOf(i+"-splitbar")!=0){return;}this._ignoreTouch=true;this._onBarMoveStart(j);};d.prototype._onBarMoveStart=function(j,t){var I=this.getId();this.disableAutoResize(true);var p=j[this._moveCord];var B=parseInt(j.target.id.substr((I+"-splitbar-").length));var $=q(j.target);var m=this.getCalculatedSizes();var g=this._bHorizontal?$.innerWidth():$.innerHeight();var h=this._getContentAreas();var k=h[B].getLayoutData();var n=h[B+1].getLayoutData();if(!k.getResizable()||!n.getResizable()){e(t);return;}var s=0-g;for(var i=0;i<=B;++i){s+=m[i]+g;}this._move={start:p,relStart:s,barNum:B,bar:q(j.target),c1Size:m[B],c1MinSize:k?parseInt(k.getMinSize()):0,c2Size:m[B+1],c2MinSize:n?parseInt(n.getMinSize()):0};if(t){document.addEventListener("touchend",this._boundBarMoveEnd);document.addEventListener("touchmove",this._boundBarMove);}else{document.addEventListener("mouseup",this._boundBarMoveEnd);document.addEventListener("mousemove",this._boundBarMove);}this._$SplitterOverlay.css("display","block");this._$SplitterOverlay.appendTo(this.getDomRef());this._$SplitterOverlayBar.css(this._sizeDirNot,"");this._move["bar"].css("visibility","hidden");this._onBarMove(j);};d.prototype._onBarMove=function(j){if(j.preventDefault){j.preventDefault();}var E=j;if(j.changedTouches&&j.changedTouches[0]){E=j.changedTouches[0];}var p=E[this._moveCord];var D=(p-this._move.start);if(this.getOrientation()==O.Horizontal&&this._bRtl){D=-D;}var g=this._move.c1Size+D;var h=this._move.c2Size-D;var i=(g>=0&&h>=0&&g>=this._move.c1MinSize&&h>=this._move.c2MinSize);if(i){this._$SplitterOverlayBar.css(this._sizeDir,this._move.relStart+D);if(this._liveResize){var m=(this._move["start"]-E[this._moveCord]);if(this.getOrientation()==O.Horizontal&&this._bRtl){m=-m;}this._resizeContents(this._move["barNum"],-m,false);}}};d.prototype._onBarMoveEnd=function(j){this._ignoreMouse=false;this._ignoreTouch=false;var E=j;if(j.changedTouches&&j.changedTouches[0]){E=j.changedTouches[0];}var p=E[this._moveCord];var m=this._move["start"]-p;if(this.getOrientation()==O.Horizontal&&this._bRtl){m=-m;}this._resizeContents(this._move["barNum"],-m,true);this._move["bar"].css("visibility","");this._$SplitterOverlay.css("display","");document.removeEventListener("mouseup",this._boundBarMoveEnd);document.removeEventListener("mousemove",this._boundBarMove);document.removeEventListener("touchend",this._boundBarMoveEnd);document.removeEventListener("touchmove",this._boundBarMove);this.enableAutoResize(true);if(this._move.bar){this._move.bar.focus();}};d.prototype._resizeContents=function(i,p,F){if(isNaN(p)){L.warning("Splitter: Received invalid resizing values - resize aborted.");return;}var g=this._getContentAreas();var h=g[i].getLayoutData();var j=g[i+1].getLayoutData();var s=h.getSize();var k=j.getSize();var $=this.$("content-"+i);var m=this.$("content-"+(i+1));var n=this._move.c1Size+p;var N=this._move.c2Size-p;var M=parseInt(h.getMinSize());var t=parseInt(j.getMinSize());var D;if(n<M){D=M-n;p+=D;n=M;N-=D;}else if(N<t){D=t-N;p-=D;N=t;n-=D;}if(F){if(s==="auto"&&k!=="auto"){j.setSize(N+"px");}else if(s!=="auto"&&k==="auto"){h.setSize(n+"px");}else{h.setSize(n+"px");j.setSize(N+"px");}}else{$.css(this._sizeType,n+"px");m.css(this._sizeType,N+"px");}};d.prototype._delayedResize=function(D){if(D===undefined){D=0;}if(this.getDomRef()){clearTimeout(this._resizeTimeout);setTimeout(this["_resize"].bind(this),D);}};d.prototype._resizeBars=function(g){var i,B;var $=this.$();for(i=0;i<g.length-1;++i){B=this.$("splitbar-"+i);B.css(this._sizeTypeNot,"");}for(i=0;i<g.length-1;++i){B=this.$("splitbar-"+i);var s=this._bHorizontal?$.height():$.width();B.css(this._sizeType,"");B.css(this._sizeTypeNot,s+"px");}};d.prototype._resize=function(){var D=this.getDomRef();if(!D||a.getPreserveAreaRef().contains(D)){return;}var i=0,B;var g=this._getContentAreas();this._resizeBars(g);var h=this.getCalculatedSizes();this._recalculateSizes();var n=this.getCalculatedSizes();var s=false;for(i=0;i<n.length;++i){if(n[i]!==0){s=true;break;}}if(!s){this._delayedResize(100);return;}var j=true;for(i=0;i<g.length;++i){var $=this.$("content-"+i);var k=g[i];$.css(this._sizeType,n[i]+"px");$.css(this._sizeTypeNot,"");var m=k.getLayoutData();var p=m&&m.getResizable();if(i>0){var t=p&&j;B=this.$("splitbar-"+(i-1));B.toggleClass("sapUiLoSplitterNoResize",!t);B.attr("tabindex",t&&this._keyboardEnabled?"0":"-1");}j=p;}this._resizeBars(g);if(_(h,n)){this.fireResize({oldSizes:h,newSizes:n});}};d.prototype._calculateAvailableContentSize=function(s){var i=0;var $=this.$();var F=this._bHorizontal?$.innerWidth():$.innerHeight();var A=0;var h=false;for(i=0;i<s.length;++i){var g=s[i];if(g.indexOf("%")>-1){A++;}if(s[i]=="auto"){h=true;}}A+=h?1:0;if(this.getOrientation()===O.Horizontal){F-=A;}var j=s.length-1;var k=0;for(i=0;i<j;++i){k+=this._bHorizontal?this.$("splitbar-"+i).innerWidth():this.$("splitbar-"+i).innerHeight();}return Math.max(0,F-k);};d.prototype._recalculateSizes=function(){var i,s,g,h,j;var k=[];var m=this._getContentAreas();for(i=0;i<m.length;++i){g=m[i].getLayoutData();s=g?g.getSize():"auto";k.push(s);}this._calculatedSizes=[];var A=this._calculateAvailableContentSize(k);var n=[];var p=[];var P=[];var t=A;for(i=0;i<k.length;++i){s=k[i];var u;if(s.indexOf("rem")>-1){u=parseFloat(s)*r;t-=u;this._calculatedSizes[i]=u;}else if(s.indexOf("px")>-1){u=parseInt(s);t-=u;this._calculatedSizes[i]=u;}else if(s.indexOf("%")>-1){P.push(i);}else if(k[i]=="auto"){g=m[i].getLayoutData();if(g&&parseInt(g.getMinSize())!=0){p.push(i);}else{n.push(i);}}else{L.error("Illegal size value: "+k[i]);}}var w=false;if(t<0){w=true;t=0;}var v=P.length;for(i=0;i<v;++i){j=P[i];h=Math.floor((parseFloat(k[j])/100)*A);this._calculatedSizes[j]=h;t-=h;}A=t;if(A<0){w=true;A=0;}h=Math.floor(A/(p.length+n.length),0);var x=p.length;for(i=0;i<x;++i){j=p[i];var M=parseInt(m[j].getLayoutData().getMinSize());if(M>h){this._calculatedSizes[j]=M;A-=M;}else{this._calculatedSizes[j]=h;A-=h;}}if(A<0){w=true;A=0;}t=A;var y=n.length;h=Math.floor(A/y,0);for(i=0;i<y;++i){j=n[i];this._calculatedSizes[j]=h;t-=h;}if(w){L.info("[Splitter] The set sizes and minimal sizes of the splitter contents are bigger "+"than the available space in the UI.");}};d.prototype._switchOrientation=function(){this._bHorizontal=this.getOrientation()===O.Horizontal;if(this._bHorizontal){this._sizeDirNot="top";this._sizeTypeNot="height";this._sizeType="width";this._moveCord="pageX";if(this._bRtl){this._sizeDir="right";}else{this._sizeDir="left";}}else{this._moveCord="pageY";this._sizeType="height";this._sizeTypeNot="width";this._sizeDir="top";this._sizeDirNot="left";}var t=this.$();t.toggleClass("sapUiLoSplitterH",this._bHorizontal);t.toggleClass("sapUiLoSplitterV",!this._bHorizontal);};d.prototype._onKeyboardResize=function(t,s,E){var B=this.getId()+"-splitbar-";if(!E||!E.target||!E.target.id||E.target.id.indexOf(B)!==0){return;}var i=999999;var g=parseInt(E.target.id.substr(B.length));var m=this.getCalculatedSizes();this._move.c1Size=m[g];this._move.c2Size=m[g+1];var h=0;switch(t){case"inc":h=s;break;case"incMore":h=s*10;break;case"dec":h=0-s;break;case"decMore":h=0-s*10;break;case"max":h=i;break;case"min":h=0-i;break;default:L.warn("[Splitter] Invalid keyboard resize type");break;}this._resizeContents(g,h,true);};d.prototype._enableKeyboardListeners=function(){this.onsapright=this._keyListeners.increase;this.onsapdown=this._keyListeners.increase;this.onsapleft=this._keyListeners.decrease;this.onsapup=this._keyListeners.decrease;this.onsappageup=this._keyListeners.decreaseMore;this.onsappagedown=this._keyListeners.increaseMore;this.onsapend=this._keyListeners.max;this.onsaphome=this._keyListeners.min;this._keyboardEnabled=true;};d.prototype._disableKeyboardListeners=function(){delete this.onsapincreasemodifiers;delete this.onsapdecreasemodifiers;delete this.onsapendmodifiers;delete this.onsaphomemodifiers;this._keyboardEnabled=false;};d.prototype._getText=function(k,A){return(o?o.getText(k,A):k);};function _(s,g){if(s===g){return false;}if(!s||!g||s.length===undefined||g.length===undefined){return true;}if(s.length!=g.length){return true;}for(var i=0;i<s.length;++i){if(s[i]!==g[i]){return true;}}return false;}function e(t){var p=function(E){E.preventDefault();};var A=null;A=function(){document.removeEventListener("touchend",A);document.removeEventListener("touchmove",p);document.removeEventListener("mouseup",A);document.removeEventListener("mousemove",p);};if(t){this._ignoreMouse=true;document.addEventListener("touchend",A);document.addEventListener("touchmove",p);}else{document.addEventListener("mouseup",A);document.addEventListener("mousemove",p);}}function f(g){var h=g.getLayoutData();if(h&&(!h.getResizable||!h.getSize||!h.getMinSize)){L.warning("Content \""+g.getId()+"\" for the Splitter contained wrong LayoutData. "+"The LayoutData has been replaced with default values.");h=null;}if(!h){g.setLayoutData(new b());}}d.prototype.invalidate=function(g){var F=(g&&this.indexOfContentArea(g)!=-1)||(g&&g instanceof sap.ui.core.CustomData&&g.getWriteToDom())||(g===undefined);if(F||this._needsInvalidation){this._needsInvalidation=false;C.prototype.invalidate.apply(this,arguments);}};d.prototype.setOrientation=function(s){var v=this.setProperty("orientation",s,true);this._switchOrientation();this._delayedResize();this.$().find(".sapUiLoSplitterBar").attr("aria-orientation",this._bHorizontal?"vertical":"horizontal");return v;};d.prototype.setWidth=function(w){this.setProperty("width",w,true);this.$().css("width",this.getProperty("width"));return this;};d.prototype.setHeight=function(h){this.setProperty("height",h,true);this.$().css("height",this.getProperty("height"));return this;};d.prototype.addContentArea=function(g){this._needsInvalidation=true;f(g);return this.addAggregation("contentAreas",g);};d.prototype.removeContentArea=function(g){this._needsInvalidation=true;return this.removeAggregation("contentAreas",g);};d.prototype.removeAllContentArea=function(){this._needsInvalidation=true;return this.removeAllAggregation("contentAreas");};d.prototype.destroyContentArea=function(){this._needsInvalidation=true;return this.destroyAggregation("contentAreas");};d.prototype.insertContentArea=function(g,i){this._needsInvalidation=true;f(g);return this.insertAggregation("contentAreas",g,i);};d.prototype._getContentAreas=function(){return this.getContentAreas();};return d;});
