/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/model/Filter','sap/ui/model/TreeBinding','sap/ui/model/odata/v2/ODataTreeBinding','sap/ui/model/ChangeReason','sap/ui/model/TreeBindingUtils',"sap/base/util/uid","sap/base/Log","sap/base/assert","sap/ui/thirdparty/jquery","sap/base/util/isEmptyObject"],function(F,T,O,C,c,u,L,d,q,e){"use strict";var f=function(){if(!(this instanceof T)||this._bIsAdapted){return;}for(var a in f.prototype){if(f.prototype.hasOwnProperty(a)){this[a]=f.prototype[a];}}this.mParameters=this.mParameters||{};this._iPageSize=0;this._aNodes=this._aNodes||[];this._aNodeCache=[];this._aCollapsed=this._aCollapsed||[];this._aExpanded=this._aExpanded||[];this._aRemoved=[];this._aAdded=[];this._aNodeChanges=[];this._aAllChangedNodes=[];this._mSubtreeHandles={};this._iLowestServerLevel=null;this._aExpandedAfterSelectAll=this._aExpandedAfterSelectAll||[];this._mSelected=this._mSelected||{};this._mDeselected=this._mDeselected||{};this._bSelectAll=false;this._iLengthDelta=0;if(this.mParameters.collapseRecursive===undefined){this.bCollapseRecursive=true;}else{this.bCollapseRecursive=!!this.mParameters.collapseRecursive;}this._bIsAdapted=true;this._bReadOnly=true;this._aPendingRequests=[];this._aPendingChildrenRequests=[];this._aPendingSubtreeRequests=[];};f.prototype.setNumberOfExpandedLevels=function(l){this.resetData();O.prototype.setNumberOfExpandedLevels.apply(this,arguments);};f.prototype.getContexts=function(s,l,t,r){if(this.isInitial()){return[];}s=s||0;l=l||this.oModel.iSizeLimit;t=t||0;this._iPageSize=l;this._iThreshold=t;if(this._aNodes.length==0&&!this.isLengthFinal()){this._loadData(s,l,t);}var R=[];var n=this._retrieveNodeSection(s,l);this._aNodeCache=[];var S;var a=0;var b=0;var g={};for(var i=0;i<n.length;i++){var N=n[i];this._aNodeCache[s+i]=N&&N.context?N:undefined;R.push(N.context);if(!N.context){if(N.serverIndex!=undefined){if(S==undefined){S=N.serverIndex;}b=N.serverIndex;}else if(N.positionInParent!=undefined){var p=N.parent;g[p.key]=g[p.key]||[];g[p.key].push(N);}}}a=1+Math.max(b-(S||0),0);if(S!=undefined&&a){this._loadData(S,a,t);}for(var m in g){var o=this._calculateRequestParameters(g[m]);this._loadChildren(g[m][0].parent,o.skip,o.top);}if(r){return n;}else{return R;}};f.prototype._calculateRequestParameters=function(m){var p=m[0].parent;var M=m[0].positionInParent;var a=Math.min(M+Math.max(this._iThreshold,m.length),p.children.length);for(var i=M;i<a;i++){var o=p.children[i];if(o){break;}}return{skip:M,top:i-M};};f.prototype._retrieveNodeSection=function(s,l){return this._bReadOnly?this._indexRetrieveNodeSection(s,l):this._mapRetrieveNodeSection(s,l);};f.prototype._mapRetrieveNodeSection=function(s,l){var n=-1;var N=[];this._map(function(o,r,i,I,p){n++;if(n>=s){if(!o){if(i=="serverIndex"){o={serverIndex:I};}else if(i=="positionInParent"){o={positionInParent:I,parent:p};}}N.push(o);}if(N.length>=l){r.broken=true;}});return N;};f.prototype._indexRetrieveNodeSection=function(s,l){var i,n=[],N,o;for(i=s;i<s+l;i++){N=this.getNodeInfoByRowIndex(i);if(N.index!==undefined&&N.index<this._aNodes.length){o=this._aNodes[N.index];if(!o){o={serverIndex:N.index};}}else if(N.parent){o=N.parent.children[N.childIndex];if(!o){o={parent:N.parent,positionInParent:N.childIndex};}}if(o){n.push(o);o=null;}}return n;};f.prototype.getNodes=function(s,l,t){var n=this.getContexts(s,l,t,true);return n;};f.prototype._map=function(m){var r={broken:false};var a=function(n){if(n.addedSubtrees.length>0&&!n.nodeState.collapsed){for(var j=0;j<n.addedSubtrees.length;j++){var s=n.addedSubtrees[j];t(n,s);if(r.broken){return;}}}};var t=function(n,s){var S=s._getSubtree();if(s){if(Array.isArray(S)){if(s._oSubtreeRoot){g(S,s._oSubtreeRoot.serverIndex,s._oSubtreeRoot,s._oSubtreeRoot.originalLevel||0,n.level+1);}else{g(S,null,null,0,n.level+1);}}else{s._oSubtreeRoot.level=n.level+1;b(s._oSubtreeRoot,false,s._oNewParentNode,-1,s._oSubtreeRoot);}}};var b=function(n,I,p,P,o){if(!I){if(!n.nodeState.removed||o==n){m(n,r,"positionInParent",P,p);if(r.broken){return;}}}a(n);if(r.broken){return;}if(n&&n.children&&n.nodeState.expanded){for(var i=0;i<n.children.length;i++){var h=n.children[i];if(h&&!h.nodeState.removed&&!h.nodeState.reinserted){h.level=n.level+1;}if(h&&!h.nodeState.removed){b(h,false,n,i,o);}else if(!h){m(h,r,"positionInParent",i,n);}if(r.broken){return;}}}};var g=function(h,s,I,S,n){for(var i=0;i<h.length;i++){var N=h[i];if(N&&N.nodeState&&N.nodeState.removed&&N!=I){if(!N.initiallyCollapsed){i+=N.magnitude;}continue;}if(N&&S>=0&&n>=0){N.level=N.originalLevel||0;var l=(N.level-S)||0;N.level=n+l||0;}if(s===null){m(N,r,"newNode");}else{m(N,r,"serverIndex",s+i);}if(r.broken){return;}if(N&&N.nodeState){if(!N.initiallyCollapsed&&N.nodeState.collapsed){i+=N.magnitude;}else{if(N.initiallyCollapsed&&N.nodeState.expanded){b(N,true);if(r.broken){return;}}else if(!N.initiallyCollapsed&&N.nodeState.expanded){a(N);}}}if(r.broken){return;}}};g(this._aNodes,0,null);};f.prototype._loadData=function(s,t,i){var a=this;this.fireDataRequested();return this._requestServerIndexNodes(s,t,i).then(function(r){a._addServerIndexNodes(r.oData,r.iSkip);a._fireChange({reason:C.Change});a.fireDataReceived({data:r.oData});},function(E){var A=E.statusCode===0;if(!A){a._aNodes=[];a._bLengthFinal=true;a._fireChange({reason:C.Change});}a.fireDataReceived();});};f.prototype._restoreServerIndexNodes=function(s,t,i){var a=this;return this._requestServerIndexNodes(s,t,0,i).then(function(r){a._addServerIndexNodes(r.oData,r.iSkip);return r;});};f.prototype._addServerIndexNodes=function(D,s){var E,k,I,i,t=function(n,b){if(!n.isDeepOne&&!n.initiallyCollapsed&&n.serverIndex<I&&n.serverIndex+n.magnitude>=I){return true;}};if(!this._bLengthFinal){var a=D.__count?parseInt(D.__count):0;this._aNodes[a-1]=undefined;this._bLengthFinal=true;}if(D.results&&D.results.length>0){for(i=0;i<D.results.length;i++){E=D.results[i];k=this.oModel.getKey(E);I=s+i;var m=E[this.oTreeProperties["hierarchy-node-descendant-count-for"]];if(m<0){m=0;L.error("The entry data with key '"+k+"' under binding path '"+this.getPath()+"' has a negative 'hierarchy-node-descendant-count-for' which isn't allowed.");}var n=this._aNodes[I]=this._aNodes[I]||{key:k,context:this.oModel.getContext("/"+k),magnitude:m,level:E[this.oTreeProperties["hierarchy-level-for"]],originalLevel:E[this.oTreeProperties["hierarchy-level-for"]],initiallyCollapsed:E[this.oTreeProperties["hierarchy-drill-state-for"]]==="collapsed",nodeState:{isLeaf:E[this.oTreeProperties["hierarchy-drill-state-for"]]==="leaf",expanded:E[this.oTreeProperties["hierarchy-drill-state-for"]]==="expanded",collapsed:E[this.oTreeProperties["hierarchy-drill-state-for"]]==="collapsed",selected:this._mSelected[k]?this._mSelected[k].nodeState.selected:false},children:[],addedSubtrees:[],serverIndex:I,parent:null,isDeepOne:false};if(this._iLowestServerLevel===null){this._iLowestServerLevel=n.level;}else{this._iLowestServerLevel=Math.min(this._iLowestServerLevel,n.level);}if(this._bSelectAll){if(!this._aExpandedAfterSelectAll.some(t)){this.setNodeSelection(n,true);}}}}};f.prototype._requestServerIndexNodes=function(s,t,g,I){return new Promise(function(r,h){var R={iSkip:s,iTop:t+(g||0),iThreshold:g};this._aPendingRequests.sort(function(a,b){return a.iSkip-b.iSkip;});for(var i=0;i<this._aPendingRequests.length;i++){if(c._determineRequestDelta(R,this._aPendingRequests[i])===false){return;}}s=R.iSkip;t=R.iTop;function _(D){var a=this._aPendingRequests.indexOf(R);this._aPendingRequests.splice(a,1);r({oData:D,iSkip:s,iTop:t});}function j(E){var a=this._aPendingRequests.indexOf(R);this._aPendingRequests.splice(a,1);h(E);}var U=["$skip="+s,"$top="+t];if(!this._bLengthFinal||I){U.push("$inlinecount=allpages");}if(this.sCustomParams){U.push(this.sCustomParams);}var l=new F(this.oTreeProperties["hierarchy-level-for"],"LE",this.getNumberOfExpandedLevels());var k=[l];if(this.aApplicationFilters){k=k.concat(this.aApplicationFilters);}var A=this.oModel.resolve(this.getPath(),this.getContext());if(A){R.oRequestHandle=this.oModel.read(A,{urlParameters:U,filters:[new F({filters:k,and:true})],sorters:this.aSorters||[],success:_.bind(this),error:j.bind(this),groupId:this.sRefreshGroupId?this.sRefreshGroupId:this.sGroupId});this._aPendingRequests.push(R);}}.bind(this));};f.prototype._propagateMagnitudeChange=function(p,D){while(p!=null&&(p.initiallyCollapsed||p.isDeepOne)){p.magnitude+=D;if(!p.nodeState.expanded){return;}p=p.parent;}};f.prototype._getInitialMagnitude=function(n){var D=0,o;if(n.isDeepOne){return 0;}if(n.children){for(var i=0;i<n.children.length;i++){o=n.children[i];D+=o.magnitude+1;}}return n.magnitude-D;};f.prototype._loadChildren=function(p,s,t){var a=this;this.fireDataRequested();this._requestChildren(p,s,t).then(function(r){a._addChildNodes(r.oData,p,r.iSkip);a._fireChange({reason:C.Change});a.fireDataReceived({data:r.oData});},function(E){var A=E.statusCode===0;if(!A){if(p.childCount===undefined){p.children=[];p.childCount=0;a._fireChange({reason:C.Change});}}a.fireDataReceived();});};f.prototype._restoreChildren=function(p,s,t){var a=this,P=p.context.getProperty(this.oTreeProperties["hierarchy-node-for"]);return this._requestChildren(p,s,t,true).then(function(r){var n;a._map(function(N,R){if(N&&N.context.getProperty(a.oTreeProperties["hierarchy-node-for"])===P){n=N;R.broken=true;}});if(n){a._addChildNodes(r.oData,n,r.iSkip);a.expand(n,true);}return r;});};f.prototype._addChildNodes=function(D,p,s){if(p.childCount==undefined&&D&&D.__count){var a=D.__count?parseInt(D.__count):0;p.childCount=a;p.children[a-1]=undefined;if(p.nodeState.expanded){this._propagateMagnitudeChange(p,a);}else{p.magnitude=a;}this._cleanTreeStateMaps();}if(D.results&&D.results.length>0){for(var i=0;i<D.results.length;i++){var E=D.results[i];this._createChildNode(E,p,s+i);}}};f.prototype._createChildNode=function(E,p,P){var k=this.oModel.getKey(E);var i;if(p.containingServerIndex!==undefined){i=p.containingServerIndex;}else{i=p.serverIndex;}var n=p.children[P]=p.children[P]||{key:k,context:this.oModel.getContext("/"+k),magnitude:0,level:p.level+1,originalLevel:p.level+1,initiallyCollapsed:E[this.oTreeProperties["hierarchy-drill-state-for"]]==="collapsed",nodeState:{isLeaf:E[this.oTreeProperties["hierarchy-drill-state-for"]]==="leaf",expanded:E[this.oTreeProperties["hierarchy-drill-state-for"]]==="expanded",collapsed:E[this.oTreeProperties["hierarchy-drill-state-for"]]==="collapsed",selected:this._mSelected[k]?this._mSelected[k].nodeState.selected:false},positionInParent:P,children:[],addedSubtrees:[],parent:p,originalParent:p,isDeepOne:true,containingServerIndex:i};if(this._bSelectAll&&this._aExpandedAfterSelectAll.indexOf(p)===-1){this.setNodeSelection(n,true);}return n;};f.prototype._requestChildren=function(p,s,t,I){return new Promise(function(r,g){var R={sParent:p.key,iSkip:s,iTop:t};this._aPendingChildrenRequests.sort(function(a,b){return a.iSkip-b.iSkip;});for(var i=0;i<this._aPendingChildrenRequests.length;i++){var P=this._aPendingChildrenRequests[i];if(P.sParent===R.sParent){if(c._determineRequestDelta(R,P)===false){return;}}}s=R.iSkip;t=R.iTop;function _(D){var a=this._aPendingChildrenRequests.indexOf(R);this._aPendingChildrenRequests.splice(a,1);r({oData:D,iSkip:s,iTop:t});}function h(E){var a=this._aPendingChildrenRequests.indexOf(R);this._aPendingChildrenRequests.splice(a,1);g(E);}var U=["$skip="+s,"$top="+t];if(p.childCount==undefined||I){U.push("$inlinecount=allpages");}if(this.sCustomParams){U.push(this.sCustomParams);}var l=new F(this.oTreeProperties["hierarchy-parent-node-for"],"EQ",p.context.getProperty(this.oTreeProperties["hierarchy-node-for"]));var j=[l];if(this.aApplicationFilters){j=j.concat(this.aApplicationFilters);}var A=this.oModel.resolve(this.getPath(),this.getContext());if(A){R.oRequestHandle=this.oModel.read(A,{urlParameters:U,filters:[new F({filters:j,and:true})],sorters:this.aSorters||[],success:_.bind(this),error:h.bind(this),groupId:this.sRefreshGroupId?this.sRefreshGroupId:this.sGroupId});this._aPendingChildrenRequests.push(R);}}.bind(this));};f.prototype._loadSubTree=function(p,l){var t=this;var m;if(p.serverIndex!==undefined&&!p.initiallyCollapsed){var M=[];var s;var S=p.serverIndex+1;var a=S+p.magnitude;for(var i=S;i<a;i++){if(this._aNodes[i]===undefined){if(!s){s={iSkip:i,iTop:1};M.push(s);}else{s.iTop++;}}else{s=null;}}if(M.length){m=Promise.all(M.map(function(o){return t._loadData(o.iSkip,o.iTop);}));}}if(!m){m=Promise.resolve();}return m.then(function(){t.fireDataRequested();return t._requestSubTree(p,l).then(function(r){t._addSubTree(r.oData,p);t.fireDataReceived({data:r.oData});},function(E){L.warning("ODataTreeBindingFlat: Error during subtree request",E.message);t.fireDataReceived();});});};f.prototype._addSubTree=function(D,s){if(D.results&&D.results.length>0){var n,p,E,N,P,a=[],m={},i,j,k;if(s.serverIndex!==undefined&&!s.initiallyCollapsed){a=this._aNodes.slice(s.serverIndex,s.serverIndex+s.magnitude+1);}else{a.push(s);}for(j=a.length-1;j>=0;j--){N=a[j];if(N.nodeState.isLeaf){continue;}if(N.initiallyCollapsed||N.isDeepOne){N.childCount=undefined;if(N.magnitude&&N.nodeState.expanded){this._propagateMagnitudeChange(N.parent,-N.magnitude);}N.magnitude=0;}m[N.context.getProperty(this.oTreeProperties["hierarchy-node-for"])]=N;}for(i=0;i<D.results.length;i++){E=D.results[i];n=E[this.oTreeProperties["hierarchy-node-for"]];if(m[n]){continue;}p=E[this.oTreeProperties["hierarchy-parent-node-for"]];P=m[p];if(P.childCount===undefined){P.childCount=0;}N=P.children[P.childCount];if(N){a.push(N);if(N.childCount){N.childCount=undefined;if(N.initiallyCollapsed||N.isDeepOne){N.magnitude=0;}}}else{N=this._createChildNode(E,P,P.childCount);if(N.nodeState.expanded){this._aExpanded.push(N);this._sortNodes(this._aExpanded);}}P.childCount++;if(P.nodeState.expanded){this._propagateMagnitudeChange(P,1);}else{P.magnitude++;}if(!N.nodeState.isLeaf){m[n]=N;}}for(k=a.length-1;k>=0;k--){N=a[k];if(!N.nodeState.expanded&&!N.nodeState.isLeaf){this.expand(N,true);}}}};f.prototype._requestSubTree=function(p,l){return new Promise(function(r,a){var R={sParent:p.key,iLevel:l};for(var i=0;i<this._aPendingSubtreeRequests.length;i++){var P=this._aPendingSubtreeRequests[i];if(P.sParent===R.sParent&&P.iLevel===R.iLevel){return;}}function _(D){var h=this._aPendingSubtreeRequests.indexOf(R);this._aPendingSubtreeRequests.splice(h,1);r({oData:D,sParent:R.sParent,iLevel:R.iLevel});}function b(E){var h=this._aPendingSubtreeRequests.indexOf(R);this._aPendingSubtreeRequests.splice(h,1);a(E);}var U=[];if(this.sCustomParams){U.push(this.sCustomParams);}var n=new F(this.oTreeProperties["hierarchy-node-for"],"EQ",p.context.getProperty(this.oTreeProperties["hierarchy-node-for"]));var o=new F(this.oTreeProperties["hierarchy-level-for"],"LE",l);var g=[n,o];if(this.aApplicationFilters){g=g.concat(this.aApplicationFilters);}var A=this.oModel.resolve(this.getPath(),this.getContext());if(A){R.oRequestHandle=this.oModel.read(A,{urlParameters:U,filters:[new F({filters:g,and:true})],sorters:this.aSorters||[],success:_.bind(this),error:b.bind(this),groupId:this.sRefreshGroupId?this.sRefreshGroupId:this.sGroupId});this._aPendingSubtreeRequests.push(R);}}.bind(this));};f.prototype.findNode=function(r){return this._bReadOnly?this._indexFindNode(r):this._mapFindNode(r);};f.prototype._mapFindNode=function(r){if(this.isInitial()){return;}var o=this._aNodeCache[r];if(o){return o;}var n=-1;this._map(function(N,R,i,I,p){n++;if(n===r){o=N;R.broken=true;}});return o;};f.prototype._indexFindNode=function(r){if(this.isInitial()){return;}var n=this._aNodeCache[r];if(n){return n;}var N=this.getNodeInfoByRowIndex(r),n;if(N.parent){n=N.parent.children[N.childIndex];}else{n=this._aNodes[N.index];}this._aNodeCache[r]=n;return n;};f.prototype.toggleIndex=function(r){var t=this.findNode(r);d(t!=undefined,"toggleIndex("+r+"): Node not found!");if(t){if(t.nodeState.expanded){this.collapse(t);}else{this.expand(t);}}};f.prototype.expand=function(r,s){var t=r;if(typeof r!=="object"){t=this.findNode(r);d(t!=undefined,"expand("+r+"): Node not found!");}if(t.nodeState.expanded){return;}t.nodeState.expanded=true;t.nodeState.collapsed=false;var i=this._aCollapsed.indexOf(t);if(i!=-1){this._aCollapsed.splice(i,1);}this._aExpanded.push(t);this._sortNodes(this._aExpanded);if(t.serverIndex!==undefined){this._aNodeChanges[t.serverIndex]=true;}if(this._bSelectAll){this._aExpandedAfterSelectAll.push(t);}if(t.initiallyCollapsed&&t.childCount==undefined){this._loadChildren(t,0,this._iPageSize);}else{this._propagateMagnitudeChange(t.parent,t.magnitude);}this._cleanTreeStateMaps();this._aNodeCache=[];if(!s){this._fireChange({reason:C.Expand});}};f.prototype.expandToLevel=function(l){this.setNumberOfExpandedLevels(l);};f.prototype.expandNodeToLevel=function(i,l,s){if(!this._bReadOnly){return Promise.reject(new Error("ODataTreeBindingFlat: expandNodeToLevel is not supported while there are pending changes in the hierarchy"));}var S=this.findNode(i);return this._loadSubTree(S,l).then(function(){if(!s){this._fireChange({reason:C.Expand});}}.bind(this));};f.prototype.collapse=function(r,s){var t=r;if(typeof r!=="object"){t=this.findNode(r);d(t!=undefined,"expand("+r+"): Node not found!");}if(t.nodeState.collapsed){return;}t.nodeState.expanded=false;t.nodeState.collapsed=true;var i=this._aExpanded.indexOf(t);if(i!=-1){this._aExpanded.splice(i,1);}if(this._bSelectAll){i=this._aExpandedAfterSelectAll.indexOf(t);if(i!==-1){this._aExpandedAfterSelectAll.splice(i,1);}}this._aCollapsed.push(t);this._sortNodes(this._aCollapsed);if(t.isDeepOne){this._propagateMagnitudeChange(t.parent,t.magnitude*-1);}if(t.serverIndex!==undefined){this._aNodeChanges[t.serverIndex]=true;}this._cleanUpSelection();this._cleanTreeStateMaps();this._aNodeCache=[];if(!s){this._fireChange({reason:C.Collapse});}};f.prototype.collapseToLevel=function(l){if(this.bCollapseRecursive){for(var k in this._mSelected){var s=this._mSelected[k];if(s.level>l){this.setNodeSelection(s,false);}}}this.setNumberOfExpandedLevels(l);};f.prototype._getInvisibleSelectedNodes=function(){var a=[];var i=true;var b=function(n,B){if(n.nodeState.collapsed||(n.nodeState.removed&&!n.nodeState.reinserted)){i=false;B.broken=true;}};for(var k in this._mSelected){var s=this._mSelected[k];i=true;this._up(s,b,false);if(!i){a.push(s);}}return a;};f.prototype._cleanUpSelection=function(b){var i=this._getInvisibleSelectedNodes();i.forEach(function(s){if(s.key==this._sLeadSelectionKey){this._sLeadSelectionKey=null;}if(this.bCollapseRecursive||b){this.setNodeSelection(s,false);}}.bind(this));};f.prototype._isInSubtree=function(a,o){var i=false;var b=function(n,B){if(n==a){B.broken=true;i=true;}};this._up(o,b,false);return i;};f.prototype._up=function(n,U,o){var r={broken:false};var p=this._getParent(n,o);if(p){this._structuralUp(p,U,r,o);}else{this._flatUp(n,U,r,true);}};f.prototype._structuralUp=function(n,U,b,o){var p=n;do{U(p,b);if(b.broken){return;}n=p;p=this._getParent(p);}while(p);this._flatUp(n,U,b);};f.prototype._flatUp=function(n,U,b,I){var s=n.serverIndex,i=I?s-1:s,o,p;for(;i>=0;i--){if(this._aNodeChanges[i]){o=this._aNodes[i];if(o.initiallyCollapsed){continue;}if(o.serverIndex+o.magnitude>=s){U(o,b);if(b.broken){return;}p=this._getParent(o);if(p){this._structuralUp(p,U,b);return;}}else{continue;}}}};f.prototype._getParent=function(n,o){return o?n.originalParent:n.parent;};f.prototype._cleanTreeStateMaps=function(){this._iLengthDelta=this._bReadOnly?this._indexCleanTreeStateMaps():this._mapCleanTreeStateMaps();};f.prototype._indexCleanTreeStateMaps=function(){return this._calcIndexDelta(this._aNodes.length);};f.prototype._mapCleanTreeStateMaps=function(){var a=this._aCollapsed.concat(this._aRemoved).concat(this._aExpanded).concat(this._aAdded),v=true,V,D=0,b=function(n,B){if(n.nodeState.collapsed||(n.nodeState.removed&&!n.nodeState.reinserted)){v=false;B.broken=true;}},s={};var g=[[0,1],[-1,0]];a.forEach(function(n){if(s[n.key]){return;}else{s[n.key]=true;}if(n.nodeState.added){if(!n.nodeState.removed||n.nodeState.reinserted){v=true;this._up(n,b,false);if(v){D++;}}}else{if(n.nodeState.collapsed||n.nodeState.expanded||n.nodeState.removed){v=true;this._up(n,b,false);if(v){if(n.nodeState.removed&&!n.nodeState.reinserted){if(n.isDeepOne||n.initiallyCollapsed){D-=1;}else{D-=(n.magnitude+1);}}else{if(n.nodeState.collapsed&&n.serverIndex!==undefined&&!n.initiallyCollapsed){D-=n.magnitude;}if(n.nodeState.expanded&&(n.isDeepOne||n.initiallyCollapsed)){D+=n.children.length;}}}if(n.nodeState.reinserted){V=v;v=true;this._up(n,b,true);var i=(g[v|0][V|0]);if(!!i){if(n.isDeepOne){D+=i*1;}else{if(n.initiallyCollapsed){D+=i;}else{D+=i*(1+n.magnitude);}}}}}}}.bind(this));return D;};f.prototype.isLengthFinal=function(){return this._bLengthFinal;};f.prototype.getLength=function(){return this._aNodes.length+this._iLengthDelta;};f.prototype.getContextByIndex=function(r){if(this.isInitial()){return;}var n=this.findNode(r);return n&&n.context;};f.prototype.getNodeByIndex=function(r){if(this.isInitial()){return;}var n=this.findNode(r);return n;};f.prototype.isExpanded=function(r){var n=this.findNode(r);return n&&n.nodeState.expanded;};f.prototype.hasChildren=function(o){if(!o){return false;}var n=this._findNodeByContext(o);var N=n&&n.node;return!(N&&N.nodeState.isLeaf);};f.prototype.nodeHasChildren=function(n){return!(n&&n.nodeState.isLeaf);};f.prototype.setNodeSelection=function(n,i){d(n,"Node must be defined!");n.nodeState.selected=i;if(i){delete this._mDeselected[n.key];this._mSelected[n.key]=n;}else{delete this._mSelected[n.key];this._mDeselected[n.key]=n;if(n.key===this._sLeadSelectionKey){this._sLeadSelectionKey=null;}}};f.prototype.isIndexSelected=function(r){var n=this.findNode(r);return n&&n.nodeState?n.nodeState.selected:false;};f.prototype.isIndexSelectable=function(r){var n=this.findNode(r);return!!n;};f.prototype._clearSelection=function(){return this._bReadOnly?this._indexClearSelection():this._mapClearSelection();};f.prototype._indexClearSelection=function(){var o=-1,a=[],s,n,r;this._bSelectAll=false;this._aExpandedAfterSelectAll=[];for(s in this._mSelected){n=this._mSelected[s];this.setNodeSelection(n,false);r=this.getRowIndexByNode(n);a.push(r);if(this._sLeadSelectionKey==s){o=r;}}return{rowIndices:a,oldIndex:o,leadIndex:-1};};f.prototype._mapClearSelection=function(){var n=-1;var o=-1;var m=0;var a=[];this._bSelectAll=false;this._aExpandedAfterSelectAll=[];for(var k in this._mSelected){if(k){m++;}}this._map(function(N,r,i,I,p){n++;if(N&&N.nodeState.selected){this.setNodeSelection(N,false);a.push(n);if(this._sLeadSelectionKey==N.key){o=n;}if(a.length==m){r.broken=true;}}}.bind(this));return{rowIndices:a,oldIndex:o,leadIndex:-1};};f.prototype.setSelectedIndex=function(r){var n=this.findNode(r);if(n){var o=this._clearSelection();var i=o.rowIndices.indexOf(r);if(i>=0){o.rowIndices.splice(i,1);}else{o.rowIndices.push(r);}o.leadKey=n.key;o.leadIndex=r;this.setNodeSelection(n,true);this._publishSelectionChanges(o);}else{L.warning("ODataTreeBindingFlat: The selection of index '"+r+"' was ignored. Please make sure to only select rows, for which data has been fetched to the client.");}};f.prototype.getSelectedIndex=function(){return this._bReadOnly?this._indexGetSelectedIndex():this._mapGetSelectedIndex();};f.prototype._indexGetSelectedIndex=function(){if(!this._sLeadSelectionKey||e(this._mSelected)){return-1;}var s=this._mSelected[this._sLeadSelectionKey];if(s){return this.getRowIndexByNode(s);}else{return-1;}};f.prototype._mapGetSelectedIndex=function(){if(!this._sLeadSelectionKey||e(this._mSelected)){return-1;}var n=-1;this._map(function(N,r){n++;if(N){if(N.key===this._sLeadSelectionKey){r.broken=true;}}}.bind(this));return n;};f.prototype.getSelectedIndices=function(){return this._bReadOnly?this._indexGetSelectedIndices():this._mapGetSelectedIndices();};f.prototype._indexGetSelectedIndices=function(){var n=this._getSelectedNodesInfo();return n.map(function(N){return N.rowIndex;});};f.prototype._mapGetSelectedIndices=function(){var r=[];if(e(this._mSelected)){return r;}var n=-1;this._map(function(N){n++;if(N){if(N.nodeState&&N.nodeState.selected){r.push(n);}}});return r;};f.prototype.getSelectedNodesCount=function(){var s;if(this._bSelectAll){if(this._bReadOnly){var r=[],n=0,k;this._aExpandedAfterSelectAll.sort(function(a,b){var A=this._getRelatedServerIndex(a);var B=this._getRelatedServerIndex(b);d(A!=undefined,"getSelectedNodesCount: (containing) Server-Index not found for node 'a'");d(B!=undefined,"getSelectedNodesCount: (containing) Server-Index not found node 'b'");if(A==B&&a.isDeepOne&&b.isDeepOne){return a.originalLevel-b.originalLevel;}return A-B;}.bind(this));var l=-1,N,g,i;for(i=0;i<this._aExpandedAfterSelectAll.length;i++){N=this._aExpandedAfterSelectAll[i];g=this._getRelatedServerIndex(N);if(g<=l&&!N.initiallyCollapsed){continue;}if(N.initiallyCollapsed){l=g;}else{l=g+N.magnitude;}r.push(N);n+=N.magnitude;}var h=function(N,b){if(r.indexOf(N)!==-1){n--;b.broken=true;}};for(k in this._mSelected){this._up(this._mSelected[k],h,true);}var I;var j=function(N,b){if(N.nodeState.collapsed||(N.nodeState.removed&&!N.nodeState.reinserted)||r.indexOf(N)!==-1){I=false;b.broken=true;}};for(k in this._mDeselected){I=true;this._up(this._mDeselected[k],j,true);if(I){n++;}}s=this.getLength()-n;}else{s=0;this._map(function(N,R,a,b,p){var P;if(N){if(N.nodeState.selected){s++;}}else if(N===undefined&&a==="serverIndex"){var o=true;for(var i=b-1;i>=0;i--){if(this._aNodeChanges[i]){P=this._aNodes[i];if(P.serverIndex+P.magnitude>=b&&this._aExpandedAfterSelectAll.indexOf(P)!==-1){o=false;break;}}}if(o){s++;}}}.bind(this));}}else{var m=this._getInvisibleSelectedNodes();s=Math.max(Object.keys(this._mSelected).length-m.length,0);}return s;};f.prototype.getSelectedContexts=function(){return this._bReadOnly?this._indexGetSelectedContexts():this._mapGetSelectedContexts();};f.prototype._indexGetSelectedContexts=function(){var n=this._getSelectedNodesInfo();return n.map(function(N){return N.node.context;});};f.prototype._mapGetSelectedContexts=function(){var r=[];if(e(this._mSelected)){return r;}var m=function(n){if(n){if(n.nodeState.selected&&!n.isArtificial){r.push(n.context);}}};this._map(m);return r;};f.prototype.setSelectionInterval=function(a,t){var m=this._clearSelection();var s=this._setSelectionInterval(a,t,true);var I={};var r=[];var b;for(var i=0;i<m.rowIndices.length;i++){b=m.rowIndices[i];I[b]=true;}for(i=0;i<s.rowIndices.length;i++){b=s.rowIndices[i];if(I[b]){delete I[b];}else{I[b]=true;}}for(b in I){if(I[b]){r.push(parseInt(b));}}this._publishSelectionChanges({rowIndices:r,oldIndex:m.oldIndex,leadIndex:s.leadIndex,leadKey:s.leadKey});};f.prototype._setSelectionInterval=function(i,t,s){return this._bReadOnly?this._indexSetSelectionInterval(i,t,s):this._mapSetSelectionInterval(i,t,s);};f.prototype._indexSetSelectionInterval=function(a,t,s){var n=Math.min(a,t),N=Math.max(a,t),b=[],g=[],o,h,i,p;s=!!s;for(i=n;i<=N;i++){h=this.findNode(i);if(h){if(h.nodeState.selected!==s){g.push(i);}if(h.key===this._sLeadSelectionKey){o=i;}this.setNodeSelection(h,s);b.push(h);}}p={rowIndices:g,oldIndex:o,leadIndex:o&&!s?-1:undefined};if(b.length>0&&s){p.leadKey=b[b.length-1].key;p.leadIndex=N;}return p;};f.prototype._mapSetSelectionInterval=function(i,t,s){var n=Math.min(i,t);var N=Math.max(i,t);var a=[];var b=[];var g=Math.abs(N-n)+1;var o;var h=-1;var m=function(j,r,I,k,P){h++;if(j){if(h>=n&&h<=N){if(j.nodeState.selected!==!!s){b.push(h);}if(j.key===this._sLeadSelectionKey){o=h;}this.setNodeSelection(j,!!s);a.push(j);if(a.length===g){r.broken=true;}}}}.bind(this);this._map(m);var p={rowIndices:b,oldIndex:o,leadIndex:o&&!s?-1:undefined};if(a.length>0&&s){var l=a[a.length-1];p.leadKey=l.key;p.leadIndex=N;}return p;};f.prototype.addSelectionInterval=function(i,t){var p=this._setSelectionInterval(i,t,true);this._publishSelectionChanges(p);};f.prototype.removeSelectionInterval=function(i,t){var p=this._setSelectionInterval(i,t,false);this._publishSelectionChanges(p);};f.prototype.selectAll=function(){this._bReadOnly?this._indexSelectAll():this._mapSelectAll();};f.prototype._indexSelectAll=function(){this._bSelectAll=true;this._aExpandedAfterSelectAll=[];var p={rowIndices:[],oldIndex:-1,selectAll:true};var l=this.getLength(),i,n;for(i=0;i<l;i++){n=this.findNode(i);if(n&&!n.isArtificial){if(n.key===this._sLeadSelectionKey){p.oldIndex=i;}if(!n.nodeState.selected){p.rowIndices.push(i);}this.setNodeSelection(n,true);p.leadKey=n.key;p.leadIndex=i;}}this._publishSelectionChanges(p);};f.prototype._mapSelectAll=function(){this._bSelectAll=true;this._aExpandedAfterSelectAll=[];var p={rowIndices:[],oldIndex:-1,selectAll:true};var n=-1;this._map(function(N){if(!N||!N.isArtificial){n++;}if(N){if(N.key===this._sLeadSelectionKey){p.oldIndex=n;}if(N){if(!N.isArtificial&&!N.nodeState.selected){p.rowIndices.push(n);}this.setNodeSelection(N,true);p.leadKey=N.key;p.leadIndex=n;}}}.bind(this));this._publishSelectionChanges(p);};f.prototype.clearSelection=function(s){var o=this._clearSelection();if(!s){this._publishSelectionChanges(o);}};f.prototype._publishSelectionChanges=function(p){p.oldIndex=p.oldIndex||this.getSelectedIndex();p.rowIndices.sort(function(a,b){return a-b;});if(p.leadIndex>=0&&p.leadKey){this._sLeadSelectionKey=p.leadKey;}else if(p.leadIndex===-1){this._sLeadSelectionKey=undefined;}else{p.leadIndex=p.oldIndex;}if(p.rowIndices.length>0||(p.leadIndex!=undefined&&p.leadIndex!==-1)){this.fireSelectionChanged(p);}};f.prototype.setCollapseRecursive=function(b){this.bCollapseRecursive=!!b;};f.prototype.resetData=function(){O.prototype.resetData.apply(this,arguments);this._aNodes=[];this._aNodeCache=[];this._aCollapsed=[];this._aExpanded=[];this._aExpandedAfterSelectAll=[];this._mSelected={};this._mDeselected={};this._aAdded=[];this._aRemoved=[];this._aNodeChanges=[];this._aAllChangedNodes=[];this._bLengthFinal=false;this._iLowestServerLevel=null;this._bSelectAll=false;this._bReadOnly=true;this._iLengthDelta=0;};f.prototype._findNodeByContext=function(o){for(var i in this._aNodeCache){if(this._aNodeCache[i]&&this._aNodeCache[i].context==o){return{node:this._aNodeCache[i],index:parseInt(i)};}}var n=-1;var N;this._map(function(a,r,I,b,p){n++;if(a){if(a.context===o){N=a;r.broken=true;}}});return{node:N,index:n};};f.prototype._getCorrectChangeGroup=function(k){if(!k){k=this.oModel.resolve(this.getPath(),this.getContext());}return this.oModel._resolveGroup(k).groupId;};f.prototype.createEntry=function(p){var a=this.oModel.resolve(this.getPath(),this.getContext());var n;if(a){p=p||{};p.groupId=this._getCorrectChangeGroup(a);p.refreshAfterChange=false;n=this.oModel.createEntry(a,p);}else{L.warning("ODataTreeBindingFlat: createEntry failed, as the binding path could not be resolved.");}return n;};f.prototype.submitChanges=function(p){p=p||{};var a=this.oModel.resolve(this.getPath(),this.getContext()),o=this._optimizeChanges();if(!a){L.warning("ODataTreeBindingFlat: submitChanges failed, because the binding-path could not be resolved.");return;}p.groupId=this._getCorrectChangeGroup(a);var b=p.success||function(){};var g=p.error||function(){};var r=false;p.success=function(D){b(D);var s=false;if(D.__batchResponses&&D.__batchResponses[0]&&D.__batchResponses[0].__changeResponses&&D.__batchResponses[0].__changeResponses.length>0){var h=D.__batchResponses[0].__changeResponses;for(var i=0;i<h.length;i++){var R=h[i];var S=parseInt(R.statusCode);if(S<200||S>299){s=true;break;}}if(s){}else if(this._bRestoreTreeStateAfterChange&&!r&&(!this.aApplicationFilters||this.aApplicationFilters.length===0)){this._restoreTreeState(o).catch(function(j){L.error("ODataTreeBindingFlat - "+j.message,j.stack);this._refresh(true);}.bind(this));}else{this._refresh(true);}}else{L.warning("ODataTreeBindingFlat.submitChanges - success: Batch-request response does not contain change response.");}}.bind(this);p.error=function(E){g(E);};this._generateSubmitData(o,function(h){L.error("ODataTreeBindingFlat - Tree state restoration request failed. "+h.message,h.stack);r=true;});this.oModel.submitChanges(p);};f.prototype._generateSubmitData=function(o,r){var R=o.removed,a=o.creationCancelled,A=o.added,m=o.moved,t=this;function s(n){d(n.context,"Node does not have a context.");var p=n.parent.context.getProperty(t.oTreeProperties["hierarchy-node-for"]);t.oModel.setProperty(t.oTreeProperties["hierarchy-parent-node-for"],p,n.context);}var b={groupId:this._getCorrectChangeGroup(),error:r};A.forEach(s);m.forEach(function(n){s(n);if(this._bRestoreTreeStateAfterChange&&(!this.aApplicationFilters||this.aApplicationFilters.length===0)){this._generatePreorderPositionRequest(n,b);this._generateSiblingsPositionRequest(n,b);}}.bind(this));R.forEach(function(n){this._generateDeleteRequest(n);L.debug("ODataTreeBindingFlat: DELETE "+n.key);}.bind(this));a.forEach(function(n){this._generateDeleteRequest(n);}.bind(this));};f.prototype._generatePreorderPositionRequest=function(n,p){var g,k,K,U,s,a,b=[],S=this.aSorters||[],i;if(p){g=p.groupId||this.sGroupId;s=p.success;a=p.error;}if(this.aApplicationFilters){b=b.concat(this.aApplicationFilters);}for(i=this._aTreeKeyProperties.length-1;i>=0;i--){k=this._aTreeKeyProperties[i];if(!K){K=k;}else{K+=","+k;}b.push(new F(k,"EQ",n.context.getProperty(k)));}b.push(new F(this.oTreeProperties["hierarchy-level-for"],"LE",this.getNumberOfExpandedLevels()));U=q.extend({},this.mParameters);U.select=K+","+this.oTreeProperties["hierarchy-node-for"]+","+this.oTreeProperties["hierarchy-node-descendant-count-for"]+","+this.oTreeProperties["hierarchy-drill-state-for"]+","+this.oTreeProperties["hierarchy-preorder-rank-for"];var A=this.oModel.resolve(this.getPath(),this.getContext());if(A){this.oModel.read(A,{urlParameters:this.oModel.createCustomParams(U),filters:[new F({filters:b,and:true})],sorters:S,groupId:g,success:s,error:a});}};f.prototype._generateSiblingsPositionRequest=function(n,p){var g,U,s,a;if(p){g=p.groupId||this.sGroupId;s=p.success;a=p.error;}U=q.extend({},this.mParameters);U.select=this.oTreeProperties["hierarchy-sibling-rank-for"];this.oModel.read(n.context.getPath(),{urlParameters:this.oModel.createCustomParams(U),groupId:g,success:s,error:a});};f.prototype._nodeIsOnTopLevel=function(n){if(n&&n.serverIndex>=0){var p=n.parent==null;if(p){if(n.originalLevel==this._iLowestServerLevel){return true;}else{return false;}}}else{L.warning("ODataTreeBindingFlat.nodeIsOnTopLevel: Node is not defined or not a server-indexed node.");}};f.prototype._generateDeleteRequest=function(n){var o=n.context;if(n.nodeState.added){this.oModel.deleteCreatedEntry(o);}else{var D=this.oModel.remove(o.getPath(),{groupId:this._getCorrectChangeGroup(),refreshAfterChange:false});return D;}};f.prototype._filterChangeForServerSections=function(o){var a={};a.removed=o.removed.filter(function(r){return!r.isDeepOne;});a.added=o.added.filter(function(A){return!A.isDeepOne;});o.moved.forEach(function(m){if(!m.newIsDeepOne){a.added.push(m);}if(!m.isDeepOne){a.removed.push(m);}});return a;};f.prototype._filterChangesForDeepSections=function(o){var m={};o.removed.forEach(function(r){var p;if(r.isDeepOne){p=r.parent;if(!m[p.key]){m[p.key]={added:[],removed:[]};}m[p.key].removed.push(r);}});o.added.forEach(function(a){var p;if(a.isDeepOne){p=a.parent;if(!m[p.key]){m[p.key]={added:[],removed:[]};}m[p.key].added.push(a);}});o.moved.forEach(function(M){var p;if(M.newIsDeepOne){p=M.parent;if(!m[p.key]){m[p.key]={added:[],removed:[]};}m[p.key].added.push(M);}if(M.isDeepOne){p=M.originalParent;if(!m[p.key]){m[p.key]={added:[],removed:[]};}m[p.key].removed.push(M);}});return m;};f.prototype._optimizeOptimizedChanges=function(o){var A,t=this;A=o.added.slice();A.sort(function(a,b){var I=a.newIsDeepOne!==undefined?a.newIsDeepOne:a.isDeepOne,g=b.newIsDeepOne!==undefined?b.newIsDeepOne:b.isDeepOne;if(I&&g){return 0;}if(I){return 1;}if(g){return-1;}return a.context.getProperty(t.oTreeProperties["hierarchy-preorder-rank-for"])-b.context.getProperty(t.oTreeProperties["hierarchy-preorder-rank-for"]);});var i=-1;A=A.filter(function(n,a){if(n.newIsDeepOne!==undefined?n.newIsDeepOne:n.isDeepOne){return true;}if(a<=i){return false;}var m=n.context.getProperty(t.oTreeProperties["hierarchy-node-descendant-count-for"]);if(m){i=a+m;}return true;});return{added:A,removed:o.removed,moved:o.moved};};f.prototype._updateNodeInfoAfterSave=function(n){var i=n.context.getProperty(this.oTreeProperties["hierarchy-preorder-rank-for"])===undefined;if(n.isDeepOne===undefined){n.isDeepOne=i;}else{n.newIsDeepOne=i;}var I=n.context.getProperty(this.oTreeProperties["hierarchy-drill-state-for"])==="collapsed";if(n.initiallyCollapsed===undefined){n.initiallyCollapsed=I;}else{n.newInitiallyCollapsed=I;}};f.prototype._requestExtraInfoForAddedNodes=function(a){var P=[],t=this;a.forEach(function(n){var p=new Promise(function(r,b){t._generatePreorderPositionRequest(n,{success:r,error:b});});P.push(p);});P=P.map(function(p){return p.then(function(r){return{responseData:r};},function(E){return{error:E};});});return Promise.all(P).then(function(D){var A=0;D.forEach(function(o){if(o.error){if(o.error.statusCode===0){A++;}else{throw new Error("Tree state restoration request failed. Complete or partial tree state might get lost. Error: "+(o.error.message.value||o.error.message));}}});return A===0;});};f.prototype._restoreTreeState=function(o){var t=this;this._abortPendingRequest();o=o||{creationCancelled:[],added:[],removed:[],moved:[]};this.fireDataRequested();return this._requestExtraInfoForAddedNodes(o.added).then(function(n){if(n){return t._executeRestoreTreeState(o).then(function(D){if(D){t._fireChange({reason:C.Change});t.fireDataReceived({data:D});return D;}});}});};f.prototype._executeRestoreTreeState=function(o){var a,s,S,D,b,m,p,i,j,k,l,g,h,t=this;o.added.forEach(this._updateNodeInfoAfterSave.bind(this));o.moved.forEach(this._updateNodeInfoAfterSave.bind(this));p=[];S=this._collectServerSections(this._aNodes);o=this._optimizeOptimizedChanges(o);g=this._filterChangeForServerSections(o);this._adaptSections(S,g);for(i=0;i<S.length;i++){s=S[i];p.push(this._restoreServerIndexNodes(s.iSkip,s.iTop,i===0));}var n=this._collectDeepNodes();h=this._filterChangesForDeepSections(o);for(j=0;j<n.length;j++){D=n[j];if(h){g=h[D.oParentNode.key];if(g){this._adaptSections(D.aChildSections,g,{indexName:"positionInParent",ignoreMagnitude:true});}}for(k=0;k<D.aChildSections.length;k++){b=D.aChildSections[k];p.push(this._restoreChildren(D.oParentNode,b.iSkip,b.iTop));}}m={};for(l=0;l<this._aCollapsed.length;l++){m[this._aCollapsed[l].key]=true;}a=this._aCollapsed.length;this.resetData(true);function r(){if(a>0){t._map(function(N,R){if(N&&m[N.key]){t.collapse(N,true);a--;if(a===0){R.broken=true;}}});}}p=p.map(function(v){return v.then(function(R){return{responseData:R};},function(E){return{error:E};});});return Promise.all(p).then(function(v){var A=0;v.forEach(function(w){if(w.error){if(w.error.statusCode===0){A++;}else{throw new Error("Tree state restoration request failed. Complete or partial tree state might get lost. Error: "+(w.error.message.value||w.error.message));}}});if(A<v.length){r();return v;}});};f.prototype._collectServerSections=function(n){var s=[];var S;for(var i=0;i<n.length;i++){if(n[i]!==undefined){if(!S){S={iSkip:i,iTop:1};s.push(S);}else{S.iTop++;}}else{S=null;}}return s;};f.prototype._adaptSections=function(s,o,g){var r=o.removed||[],A=o.added||[],I=(g&&g.indexName)||"serverIndex",N,S,h,R,p,t=0,M,P,v,w,x,y,z,B=0,D,E,G=[];for(var l=A.length-1;l>=0;l--){N=A[l];if(N.newIsDeepOne!==undefined?N.newIsDeepOne:N.isDeepOne){E=this.oTreeProperties["hierarchy-sibling-rank-for"];}else{E=this.oTreeProperties["hierarchy-preorder-rank-for"];if(N.newInitiallyCollapsed!==undefined?!N.newInitiallyCollapsed:!N.initiallyCollapsed){M=N.context.getProperty(this.oTreeProperties["hierarchy-node-descendant-count-for"]);}}P=N.context.getProperty(E);if(P===undefined){L.warning("ODataTreeBindingFlat","Missing "+E+" value for node "+N.key);break;}G.push({position:P,magnitude:M||0,assignedToSection:false});}for(var i=0;i<s.length;i++){S=s[i];z=B;v=w;w=0;D=0;for(var j=r.length-1;j>=0;j--){N=r[j];P=N[I];if(P>=S.iSkip&&P<=S.iSkip+S.iTop){if(I==="serverIndex"){t++;}M=(g&&g.ignoreMagnitude)?0:this._getInitialMagnitude(N);p=(1+M);R=(S.iSkip+S.iTop)-P-p;if(R>0){D-=p;}else{D-=(S.iSkip+S.iTop)-P;if(R<0){w=P+p;}}z-=p;}}if(S.iSkip<=v){x=S.iSkip-v;D+=x;if(S.iTop+D<0){w=v;}}S.iSkip+=B;S.iTop+=D;if(S.iTop>0){B=0;D=0;for(var k=0;k<G.length;k++){h=G[k];P=h.position;y=(g&&g.ignoreMagnitude)?1:h.magnitude+1;if(P>=S.iSkip&&P<=S.iSkip+S.iTop){D+=y;G[k].assignedToSection=true;}else if(P<S.iSkip){B+=y;}}S.iSkip+=B;S.iTop+=D;S.iTop+=t;}if(S.iTop<=0){s.splice(i,1);i--;}B=z;}for(var m=0;m<G.length;m++){h=G[m];y=(g&&g.ignoreMagnitude)?1:h.magnitude+1;if(!h.assignedToSection){s.push({iSkip:h.position,iTop:y});}}s.sort(function(a,b){return a.iSkip-b.iSkip;});for(var n=0;n<s.length;n++){if(n+1<s.length){S=s[n];var H=s[n+1];if(S.iSkip+S.iTop===H.iSkip){S.iTop+=H.iTop;s.splice(n+1,1);n--;}}}};f.prototype._optimizeChanges=function(){var r=[],g=[],A=[],m=[];var I=false;var h=function(N,b){if(N.nodeState.removed&&!N.nodeState.reinserted){I=true;b.broken=true;}};var p=[];var t=function(N){if((N.isDeepOne||N.serverIndex>=0)&&p.indexOf(N)==-1){p.push(N);}if(N.nodeState.added){g.push(N);}};this._aAllChangedNodes.forEach(function(N){I=false;this._up(N,h,false);if(I){t(N);}else{if(N.nodeState.removed&&!N.nodeState.reinserted){t(N);}else if(N.nodeState.added){A.push(N);}else{m.push(N);}}}.bind(this));p.sort(function(a,b){var j=this._getRelatedServerIndex(a);var B=this._getRelatedServerIndex(b);d(j!=undefined,"_generateSubmitData: (containing) Server-Index not found for node 'a'");d(B!=undefined,"_generateSubmitData: (containing) Server-Index not found node 'b'");if(j==B&&a.isDeepOne&&b.isDeepOne){if(a.parent===b.parent){return a.positionInParent-b.positionInParent;}else{return a.originalLevel-b.originalLevel;}}return j-B;}.bind(this));var n=function(D){var b=false;this._up(D,function(P,B){if(P.nodeState.removed&&!P.nodeState.reinserted){b=true;B.broken=true;}},true);return b;}.bind(this);for(var i=0;i<p.length;i++){var D=p[i];if(!n(D)){r.push(D);}}return{removed:r,creationCancelled:g,added:A,moved:m};};f.prototype._collectDeepNodes=function(){var D=[],t=this;this._map(function(n){if(n&&n.nodeState.expanded&&((n.initiallyCollapsed||n.isDeepOne))){D.push({oParentNode:n,aChildSections:t._collectServerSections(n.children)});}});return D;};f.prototype._trackChangedNode=function(n){if(this._aAllChangedNodes.indexOf(n)==-1){this._aAllChangedNodes.push(n);}};f.prototype.addContexts=function(p,v){var n=this._findNodeByContext(p),N=n.node,m=this.getModel(),o,a;d(p&&v,"ODataTreeBinding.addContexts() was called with incomplete arguments!");if(N){this._bReadOnly=false;if(N.nodeState&&N.nodeState.isLeaf){N.nodeState.isLeaf=false;N.nodeState.collapsed=true;}if(!Array.isArray(v)){if(v instanceof sap.ui.model.Context){v=[v];}else{L.warning("ODataTreeBinding.addContexts(): The child node argument is not of type sap.ui.model.Context.");}}var b=function(g){return function(){return[g];};};v=v.slice();v.reverse();for(var j=0;j<v.length;j++){var a=v[j];if(!a||!(a instanceof sap.ui.model.Context)){L.warning("ODataTreeBindingFlat.addContexts(): no valid child context given!");return;}var o=this._mSubtreeHandles[a.getPath()];this._ensureHierarchyNodeIDForContext(a);if(o&&o._isRemovedSubtree){L.info("ODataTreeBindingFlat.addContexts(): Existing context added '"+a.getPath()+"'");o._oNewParentNode=N;o._oSubtreeRoot.nodeState.reinserted=true;o._oSubtreeRoot.originalParent=o._oSubtreeRoot.originalParent||o._oSubtreeRoot.parent;o._oSubtreeRoot.parent=N;o._oSubtreeRoot.containingSubtreeHandle=o;a=o.getContext();this._trackChangedNode(o._oSubtreeRoot);this._mSubtreeHandles[a.getPath()];}else{L.info("ODataTreeBindingFlat.addContexts(): Newly created context added.");this._ensureHierarchyNodeIDForContext(a);var g={context:a,key:m.getKey(a),parent:N,nodeState:{isLeaf:true,collapsed:false,expanded:false,selected:false,added:true},addedSubtrees:[],children:[],magnitude:0};this._trackChangedNode(g);this._aAdded.push(g);o={_getSubtree:b(g),_oSubtreeRoot:null,_oNewParentNode:N};}o._iContainingServerIndex=N.serverIndex||N.containingServerIndex;N.addedSubtrees.unshift(o);if(N.serverIndex!==undefined){this._aNodeChanges[N.serverIndex]=true;}}this._aNodeCache=[];this._cleanTreeStateMaps();this._fireChange({reason:C.Add});}else{L.warning("The given parent context could not be found in the tree. No new sub-nodes were added!");}};f.prototype._ensureHierarchyNodeIDForContext=function(o){if(o){var n=o.getProperty(this.oTreeProperties["hierarchy-node-for"]);if(o.bCreated&&!n){this.oModel.setProperty(this.oTreeProperties["hierarchy-node-for"],u(),o);}}};f.prototype.removeContext=function(o){var t=this;var n=this._findNodeByContext(o);var N=n.node;var i=n.index;if(N){this._bReadOnly=false;N.nodeState.removed=true;this._aRemoved.push(N);this._trackChangedNode(N);if(N.serverIndex!==undefined){this._aNodeChanges[N.serverIndex]=true;}if(N.containingSubtreeHandle&&N.parent!=null){var a=N.parent.addedSubtrees.indexOf(N.containingSubtreeHandle);if(a!=-1){N.parent.addedSubtrees.splice(a,1);N.nodeState.reinserted=false;N.parent=null;}}this._aNodeCache=[];this.setNodeSelection(N,false);this._cleanUpSelection(true);this._cleanTreeStateMaps();this._fireChange({reason:C.Remove});this._mSubtreeHandles[o.getPath()]={_removedFromVisualIndex:i,_isRemovedSubtree:true,_oSubtreeRoot:N,_getSubtree:function(){if(N.serverIndex!=undefined&&!N.initiallyCollapsed){return t._aNodes.slice(N.serverIndex,N.serverIndex+N.magnitude+1);}else{return N;}},getContext:function(){return o;},_restore:function(){N.nodeState.removed=false;var b=t._aRemoved.indexOf(N);if(b!=-1){t._aRemoved.splice(b,1);}this._aNodeCache=[];t._cleanTreeStateMaps();t._fireChange({reason:C.Add});}};return o;}else{L.warning("ODataTreeBinding.removeContexts(): The given context is not part of the tree. Was it removed already?");}};f.prototype._getRelatedServerIndex=function(n){if(n.serverIndex===undefined){return n.containingServerIndex;}else{return n.serverIndex;}};f.prototype.getNodeInfoByRowIndex=function(r){var i=0,E=0,n,t,v=-1;while(i<this._aCollapsed.length||E<this._aExpanded.length){if(this._aCollapsed[i]&&this._aExpanded[E]){if(this._getRelatedServerIndex(this._aCollapsed[i])>this._getRelatedServerIndex(this._aExpanded[E])){n=this._aExpanded[E];E++;t=false;}else{n=this._aCollapsed[i];i++;t=true;}}else if(this._aCollapsed[i]){n=this._aCollapsed[i];i++;t=true;}else{n=this._aExpanded[E];E++;t=false;}if(r<=this._getRelatedServerIndex(n)){break;}if(t){if(!n.isDeepOne&&!n.initiallyCollapsed&&n.serverIndex>v){r+=n.magnitude;v=n.serverIndex+n.magnitude;}}else{if(n.serverIndex>v){if(!n.isDeepOne&&n.initiallyCollapsed){r-=n.magnitude;}if(r<=n.serverIndex){return this._calcDirectIndex(n,r+n.magnitude-n.serverIndex-1);}}}}return{index:r};};f.prototype._calcDirectIndex=function(n,a){var i,m,o;for(i=0;i<n.children.length;i++){o=n.children[i];if(a===0){return{parent:n,childIndex:i};}m=o?o.magnitude:0;a--;if(!o||o.nodeState.collapsed){continue;}if(a<m){return this._calcDirectIndex(o,a);}else{a-=m;}}};f.prototype.getRowIndexByNode=function(n){var D=0;var o;var i;if(n.isDeepOne){while(n.parent){D+=n.positionInParent+1;for(i=0;i<n.positionInParent;i++){o=n.parent.children[i];if(o&&o.nodeState.expanded){D+=o.magnitude;}}n=n.parent;}}return this._calcIndexDelta(n.serverIndex)+n.serverIndex+D;};f.prototype._getSelectedNodesInfo=function(){var n=[];if(e(this._mSelected)){return n;}var i=true;var a=function(N,b){if(N.nodeState.collapsed||(N.nodeState.removed&&!N.nodeState.reinserted)){i=false;b.broken=true;}};for(var k in this._mSelected){var s=this._mSelected[k];i=true;this._up(s,a,false);if(i){n.push({node:s,rowIndex:this.getRowIndexByNode(s)});}}n.sort(function(N,o){return N.rowIndex-o.rowIndex;});return n;};f.prototype._calcIndexDelta=function(E){var m={};this._aCollapsed.forEach(function(n){if(n.serverIndex>=0&&n.serverIndex<E&&!n.isDeepOne&&!n.initiallyCollapsed){m[n.serverIndex]=n.magnitude;}});var l=0;var a=0;for(var i=0;i<this._aCollapsed.length;i++){var o=this._aCollapsed[i];if(this._getRelatedServerIndex(o)>=E){break;}if(!o.isDeepOne){if(o.serverIndex>=l&&!o.initiallyCollapsed){a-=o.magnitude;l=o.serverIndex+o.magnitude;}else{}}else{}}var b=0;var I=function(n){var h=false;var k=n.serverIndex||n.containingServerIndex;for(var j in m){if(k>j&&k<j+m[j]){h=true;break;}}return h;};for(i=0;i<this._aExpanded.length;i++){var g=this._aExpanded[i];if(this._getRelatedServerIndex(g)>=E){break;}if(g.isDeepOne){var p=g.parent;var y=false;while(p){if(p.nodeState.collapsed){y=true;break;}p=p.parent;}var h=I(g);if(!y&&!h){b+=g.children.length;}}else if(g.initiallyCollapsed){var h=I(g);if(!h){b+=g.children.length;}}}return b+a;};f.prototype._sortNodes=function(n){var s=function(a,b){var A=this._getRelatedServerIndex(a);var B=this._getRelatedServerIndex(b);return A-B;}.bind(this);n.sort(s);};f.prototype._abortPendingRequest=function(){O.prototype._abortPendingRequest.apply(this,arguments);var i,j;for(i=this._aPendingRequests.length-1;i>=0;i--){this._aPendingRequests[i].oRequestHandle.abort();}this._aPendingRequests=[];for(j=this._aPendingChildrenRequests.length-1;j>=0;j--){this._aPendingChildrenRequests[j].oRequestHandle.abort();}this._aPendingChildrenRequests=[];};f.prototype.attachSelectionChanged=function(D,a,l){this.attachEvent("selectionChanged",D,a,l);return this;};f.prototype.detachSelectionChanged=function(a,l){this.detachEvent("selectionChanged",a,l);return this;};f.prototype.fireSelectionChanged=function(p){this.fireEvent("selectionChanged",p);return this;};f.prototype.getRootContexts=function(){};f.prototype.getNodeContexts=function(){};return f;},true);
