/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/model/Sorter','sap/ui/model/FilterProcessor','sap/ui/core/format/DateFormat',"sap/base/Log","sap/base/assert","sap/ui/thirdparty/jquery","sap/base/security/encodeURL","sap/ui/core/CalendarType"],function(S,F,D,L,a,q,e,C){"use strict";var r=/^([-+]?)0*(\d+)(\.\d+|)$/,b=/\.$/,c=/0+$/;var O=function(){};O.createSortParams=function(o){var t;if(!o||o.length==0){return;}t="$orderby=";for(var i=0;i<o.length;i++){var u=o[i];if(u instanceof S){t+=u.sPath;t+=u.bDescending?"%20desc":"%20asc";t+=",";}else{L.error("Trying to use "+u+" as a Sorter, but it is a "+typeof u);}}t=t.slice(0,-1);return t;};function d(o){if(o&&typeof o.convert==="function"){o=o.convert();}return o;}O.createFilterParams=function(v,M,E){var o;if(Array.isArray(v)){v=v.map(d);o=F.groupFilters(v);}else{o=d(v);}if(!o){return;}return"$filter="+this._createFilterParams(o,M,E);};O._createFilterParams=function(v,M,E){var t=this,o=Array.isArray(v)?F.groupFilters(v):v;function u(o,i){o=d(o);if(o.aFilters){return w(o,i);}return t._createFilterSegment(o.sPath,M,E,o.sOperator,o.oValue1,o.oValue2,o.bCaseSensitive);}function w(x,y){var z=x.aFilters,A=!!x.bAnd,B="";if(z.length===0){return A?"true":"false";}if(z.length===1){if(z[0]._bMultiFilter){return u(z[0]);}return u(z[0],true);}if(!y){B+="(";}B+=u(z[0]);for(var i=1;i<z.length;i++){B+=A?"%20and%20":"%20or%20";B+=u(z[i]);}if(!y){B+=")";}return B;}if(!o){return;}return u(o,true);};O._createUrlParamsArray=function(P){var u,t=q.type(P),i;if(t==="array"){return P;}u=[];if(t==="object"){i=this._encodeURLParameters(P);if(i){u.push(i);}}else if(t==="string"){if(P){u.push(P);}}return u;};O._encodeURLParameters=function(P){if(!P){return"";}var u=[];q.each(P,function(i,v){if(q.type(v)==="string"){v=encodeURIComponent(v);}i=i.startsWith('$')?i:encodeURIComponent(i);u.push(i+"="+v);});return u.join("&");};O.setOrigin=function(i,P){var o,t,u;if(!i||!P||i.indexOf(";mo")>0){return i;}if(typeof P=="string"){o=P;}else{o=P.alias;if(!o){t=P.system;u=P.client;if(!t||!u){L.warning("ODataUtils.setOrigin: No Client or System ID given for Origin");return i;}o="sid("+t+"."+u+")";}}var U=i.split("?");var B=U[0];var v=U[1]?"?"+U[1]:"";var T="";if(B[B.length-1]==="/"){B=B.substring(0,B.length-1);T="/";}var w=/(\/[^\/]+)$/g;var x=/(;o=[^\/;]+)/g;var y=B.match(w)[0];var z=y.match(x);var A=z?z[0]:null;if(A){if(P.force){var E=y.replace(A,";o="+o);B=B.replace(y,E);return B+T+v;}return i;}B=B+";o="+o+T;return B+v;};O.setAnnotationOrigin=function(A,P){var i;var o=A.indexOf("/Annotations(");var H=P&&P.preOriginBaseUri?P.preOriginBaseUri.indexOf(".xsodata"):-1;if(o===-1){o=A.indexOf("/Annotations%28");}if(o>=0){if(A.indexOf("/$value",o)===-1){L.warning("ODataUtils.setAnnotationOrigin: Annotation url is missing $value segment.");i=A;}else{var t=A.substring(0,o);var u=A.substring(o,A.length);var v=O.setOrigin(t,P);i=v+u;}}else if(H>=0){i=O.setOrigin(A,P);}else{i=A.replace(P.preOriginBaseUri,P.postOriginBaseUri);}return i;};O._resolveMultiFilter=function(M,o,E){var t=this,u=M.aFilters,v="";if(u){v+="(";q.each(u,function(i,w){if(w._bMultiFilter){v+=t._resolveMultiFilter(w,o,E);}else if(w.sPath){v+=t._createFilterSegment(w.sPath,o,E,w.sOperator,w.oValue1,w.oValue2,"",w.bCaseSensitive);}if(i<(u.length-1)){if(M.bAnd){v+="%20and%20";}else{v+="%20or%20";}}});v+=")";}return v;};O._createFilterSegment=function(P,M,E,o,v,V,i){var t,T;if(i===undefined){i=true;}if(E){t=M._getPropertyMetadata(E,P);T=t&&t.type;a(t,"PropertyType for property "+P+" of EntityType "+E.name+" not found!");}if(T){v=this.formatValue(v,T,i);V=(V!=null)?this.formatValue(V,T,i):null;}else{a(null,"Type for filter property could not be found in metadata!");}if(v){v=e(String(v));}if(V){V=e(String(V));}if(!i&&T==="Edm.String"){P="toupper("+P+")";}switch(o){case"EQ":case"NE":case"GT":case"GE":case"LT":case"LE":return P+"%20"+o.toLowerCase()+"%20"+v;case"BT":return"("+P+"%20ge%20"+v+"%20and%20"+P+"%20le%20"+V+")";case"NB":return"not%20("+P+"%20ge%20"+v+"%20and%20"+P+"%20le%20"+V+")";case"Contains":return"substringof("+v+","+P+")";case"NotContains":return"not%20substringof("+v+","+P+")";case"StartsWith":return"startswith("+P+","+v+")";case"NotStartsWith":return"not%20startswith("+P+","+v+")";case"EndsWith":return"endswith("+P+","+v+")";case"NotEndsWith":return"not%20endswith("+P+","+v+")";default:L.error("ODataUtils :: Unknown filter operator "+o);return"true";}};O.formatValue=function(v,t,i){if(i===undefined){i=true;}if(!this.oDateTimeFormat){this.oDateTimeFormat=D.getDateInstance({pattern:"'datetime'''yyyy-MM-dd'T'HH:mm:ss''",calendarType:C.Gregorian});this.oDateTimeFormatMs=D.getDateInstance({pattern:"'datetime'''yyyy-MM-dd'T'HH:mm:ss.SSS''",calendarType:C.Gregorian});this.oDateTimeOffsetFormat=D.getDateInstance({pattern:"'datetimeoffset'''yyyy-MM-dd'T'HH:mm:ss'Z'''",calendarType:C.Gregorian});this.oTimeFormat=D.getTimeInstance({pattern:"'time''PT'HH'H'mm'M'ss'S'''",calendarType:C.Gregorian});}if(v===null||v===undefined){return"null";}var V;switch(t){case"Edm.String":v=i?v:v.toUpperCase();V="'"+String(v).replace(/'/g,"''")+"'";break;case"Edm.Time":if(typeof v==="object"){V=this.oTimeFormat.format(new Date(v.ms),true);}else{V="time'"+v+"'";}break;case"Edm.DateTime":var o=new Date(v);if(o.getMilliseconds()>0){V=this.oDateTimeFormatMs.format(o,true);}else{V=this.oDateTimeFormat.format(o,true);}break;case"Edm.DateTimeOffset":var o=new Date(v);V=this.oDateTimeOffsetFormat.format(o,true);break;case"Edm.Guid":V="guid'"+v+"'";break;case"Edm.Decimal":V=v+"m";break;case"Edm.Int64":V=v+"l";break;case"Edm.Double":V=v+"d";break;case"Edm.Float":case"Edm.Single":V=v+"f";break;case"Edm.Binary":V="binary'"+v+"'";break;default:V=String(v);break;}return V;};function s(v,V){if(v===V){return 0;}if(v===null||V===null||v===undefined||V===undefined){return NaN;}return v>V?1:-1;}function p(v){var M;if(typeof v!=="string"){return undefined;}M=r.exec(v);if(!M){return undefined;}return{sign:M[1]==="-"?-1:1,integerLength:M[2].length,abs:M[2]+M[3].replace(c,"").replace(b,"")};}function f(v,V){var o,i,R;if(v===V){return 0;}o=p(v);i=p(V);if(!o||!i){return NaN;}if(o.sign!==i.sign){return o.sign>i.sign?1:-1;}R=s(o.integerLength,i.integerLength)||s(o.abs,i.abs);return o.sign*R;}var g=/^PT(\d\d)H(\d\d)M(\d\d)S$/;function h(v){if(typeof v==="string"&&g.test(v)){v=parseInt(RegExp.$1)*3600000+parseInt(RegExp.$2)*60000+parseInt(RegExp.$3)*1000;}if(v instanceof Date){return v.getTime();}if(v&&v.__edmType==="Edm.Time"){return v.ms;}return v;}O.compare=function(v,V,A){return A?f(v,V):s(h(v),h(V));};O.getComparator=function(E){switch(E){case"Edm.Date":case"Edm.DateTime":case"Edm.DateTimeOffset":case"Edm.Time":return O.compare;case"Edm.Decimal":case"Edm.Int64":return f;default:return s;}};var j=/([(=,])('.*?')([,)])/g,k=/[MLDF](?=[,)](?:[^']*'[^']*')*[^']*$)/g,l=/([(=,])(X')/g,n=function(v,i,o,t){return i+encodeURIComponent(decodeURIComponent(o))+t;},N=function(v){return v.toLowerCase();},m=function(v,i){return i+"binary'";};O._normalizeKey=function(K){return K.replace(j,n).replace(k,N).replace(l,m);};return O;},true);
