/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/thirdparty/URI','sap/ui/model/BindingMode','sap/ui/model/Context','sap/ui/model/Model','sap/ui/model/odata/v2/ODataAnnotations','sap/ui/model/odata/ODataUtils','sap/ui/model/odata/CountMode','sap/ui/model/odata/UpdateMethod','sap/ui/model/odata/OperationMode','sap/ui/model/odata/MessageScope','./ODataContextBinding','./ODataListBinding','sap/ui/model/odata/ODataMetadata','sap/ui/model/odata/ODataPropertyBinding','./ODataTreeBinding','sap/ui/model/FilterProcessor','sap/ui/model/odata/ODataMetaModel','sap/ui/core/message/MessageParser','sap/ui/model/odata/ODataMessageParser','sap/ui/thirdparty/datajs',"sap/base/Log","sap/base/assert","sap/base/util/uid","sap/base/util/UriParameters","sap/base/util/deepEqual","sap/base/util/merge","sap/base/security/encodeURL","sap/ui/thirdparty/jquery","sap/base/util/isPlainObject","sap/base/util/each","sap/base/util/isEmptyObject"],function(U,B,C,M,O,a,b,c,d,e,f,g,h,l,m,F,o,p,q,r,L,s,u,t,v,w,x,Q,y,z,A){"use strict";var D=M.extend("sap.ui.model.odata.v2.ODataModel",{constructor:function(S,P){M.apply(this,arguments);var i,j,H,T,W,k,n,R,G,I,J,K,N,V,X,Y,Z,$,_,a1,b1,c1,d1,e1,f1,g1,h1,i1,j1=this;if(typeof(S)==="object"){P=S;S=P.serviceUrl;}if(P){i=P.user;j=P.password;H=P.headers;T=P.tokenHandling;W=P.withCredentials;k=P.maxDataServiceVersion;n=P.useBatch;R=P.refreshAfterChange;G=P.annotationURI;I=P.loadAnnotationsJoined;N=P.defaultBindingMode;J=P.defaultCountMode;K=P.preliminaryContext;V=P.defaultOperationMode;X=P.metadataNamespaces;Y=P.serviceUrlParams;Z=P.metadataUrlParams;$=P.json;_=P.messageParser;a1=P.skipMetadataAnnotationParsing;b1=P.defaultUpdateMethod;c1=P.disableHeadRequestForToken;d1=P.sequentializeRequests;e1=P.disableSoftStateHeader;f1=P.bindableResponseHeaders;g1=P.warmupUrl;h1=P.canonicalRequests;i1=P.tokenHandlingForGet;}this.mPathCache={};this.mInvalidatedPaths={};this.bCanonicalRequests=!!h1;this.bTokenHandlingForGet=!!i1;this.sMessageScope=e.RequestedObjects;this.sWarmupUrl=g1;this.bWarmup=!!g1;this.mSupportedBindingModes={"OneWay":true,"OneTime":true,"TwoWay":true};this.mUnsupportedFilterOperators={"Any":true,"All":true};this.sDefaultBindingMode=N||B.OneWay;this.bIsMessageScopeSupported=false;this.iPendingDeferredRequests=0;this.bJSON=$!==false;this.aPendingRequestHandles=[];this.aCallAfterUpdate=[];this.mRequests={};this.mDeferredRequests={};this.mChangedEntities={};this.mChangeHandles={};this.mDeferredGroups={};this.mLaunderingState={};this.sDefaultUpdateMethod=b1||c.Merge;this.bTokenHandling=T!==false;this.bWithCredentials=W===true;this.bUseBatch=n!==false;this.bRefreshAfterChange=R!==false;this.sMaxDataServiceVersion=k;this.bLoadAnnotationsJoined=I!==false;this.sAnnotationURI=G;this.sDefaultCountMode=J||b.Request;this.sDefaultOperationMode=V||d.Default;this.sMetadataLoadEvent=null;this.oMetadataFailedEvent=null;this.sRefreshGroupId=undefined;this.bIncludeInCurrentBatch=false;this.bSkipMetadataAnnotationParsing=!!a1;this.bDisableHeadRequestForToken=!!c1;this.bSequentializeRequests=!!d1;this.bDisableSoftStateHeader=!!e1;this.aBindableResponseHeaders=f1?f1:null;this.bPreliminaryContext=K||false;this.mMetadataUrlParams=Z||{};if(_){_.setProcessor(this);}this.oMessageParser=_;this.sDefaultChangeGroup="changes";this.setDeferredGroups([this.sDefaultChangeGroup]);this.setChangeGroups({"*":{groupId:this.sDefaultChangeGroup}});this.oData={};this.oMetadata=null;this.oAnnotations=null;this.aUrlParams=[];this.pSequentialRequestCompleted=Promise.resolve();this.pReadyForRequest=Promise.resolve();this.sServiceUrl=S;var k1=S.split("?");if(k1.length>1){this.sServiceUrl=k1[0];if(k1[1]){this.aUrlParams.push(k1[1]);}}this.sServiceUrl=this.sServiceUrl.replace(/\/$/,"");this.sUser=i;this.sPassword=j;if(sap.ui.getCore().getConfiguration().getStatistics()){this.aUrlParams.push("sap-statistics=true");}this.oHeaders={};this.setHeaders(H);if(!this.bDisableSoftStateHeader){this.oHeaders["sap-contextid-accept"]="header";this.mCustomHeaders["sap-contextid-accept"]="header";}var l1=this._getServerUrl();var m1=this.sWarmupUrl||this._createMetadataUrl("/$metadata");this.oSharedServerData=D._getSharedData("server",l1);this.oSharedServiceData=D._getSharedData("service",this.sServiceUrl);this.oSharedMetaData=D._getSharedData("meta",m1);this.bUseCache=this._cacheSupported(m1);if(!this.oSharedMetaData.oMetadata||this.oSharedMetaData.oMetadata.bFailed){this.oMetadata=new h(m1,{async:true,cacheKey:this.bUseCache?m1:undefined,user:this.sUser,password:this.sPassword,headers:this.mCustomHeaders,namespaces:X,withCredentials:this.bWithCredentials});if(!this.bWarmup){this.oSharedMetaData.oMetadata=this.oMetadata;}}else{this.oMetadata=this.oSharedMetaData.oMetadata;}this.oAnnotations=new O(this.oMetadata,{source:this.sAnnotationURI,skipMetadata:this.bSkipMetadataAnnotationParsing,headers:this.mCustomHeaders,combineEvents:true,cacheKey:this._getAnnotationCacheKey(m1),useCache:this.bUseCache});if(!this.bDisableSoftStateHeader){delete this.mCustomHeaders["sap-contextid-accept"];}this.oAnnotations.attachAllFailed(this.onAnnotationsFailed,this);this.oAnnotations.attachSomeLoaded(this.onAnnotationsLoaded,this);this.pAnnotationsLoaded=this.oAnnotations.loaded();if(Y){this.aUrlParams=this.aUrlParams.concat(a._createUrlParamsArray(Y));}this.onMetadataFailed=function(n1){j1.fireMetadataFailed(n1.getParameters());};if(!this.oMetadata.isLoaded()){this.oMetadata.attachFailed(this.onMetadataFailed);}this.oMetadata.loaded().then(function(){j1._initializeMetadata();});if(this.bJSON){if(this.sMaxDataServiceVersion==="3.0"){this.oHeaders["Accept"]="application/json;odata=fullmetadata";}else{this.oHeaders["Accept"]="application/json";}}else{this.oHeaders["Accept"]="application/atom+xml,application/atomsvc+xml,application/xml";}if(this.bTokenHandling){if(this.oSharedServiceData.securityToken){this.oHeaders["x-csrf-token"]=this.oSharedServiceData.securityToken;}else if(this.oSharedServerData.securityToken){this.oSharedServiceData.securityToken=this.oSharedServerData.securityToken;this.oHeaders["x-csrf-token"]=this.oSharedServiceData.securityToken;}}this.oHeaders["Accept-Language"]=sap.ui.getCore().getConfiguration().getLanguageTag();this.oHeaders["DataServiceVersion"]="2.0";this.oHeaders["MaxDataServiceVersion"]="2.0";if(this.sMaxDataServiceVersion){this.oHeaders["MaxDataServiceVersion"]=this.sMaxDataServiceVersion;}},metadata:{publicMethods:["read","create","update","remove","submitChanges","getServiceMetadata","metadataLoaded","hasPendingChanges","getPendingChanges","refresh","refreshMetadata","resetChanges","setDefaultCountMode","setDefaultBindingMode","getDefaultBindingMode","getDefaultCountMode","setProperty","getSecurityToken","refreshSecurityToken","setHeaders","getHeaders","setUseBatch","setDeferredBatchGroups","getDeferredBatchGroups","setChangeBatchGroups","getChangeBatchGroups"]}});D.M_EVENTS={MetadataLoaded:"metadataLoaded",MetadataFailed:"metadataFailed",AnnotationsLoaded:"annotationsLoaded",AnnotationsFailed:"annotationsFailed",BatchRequestFailed:"batchRequestFailed",BatchRequestSent:"batchRequestSent",BatchRequestCompleted:"batchRequestCompleted"};D.prototype.attachBatchRequestFailed=function(i,j,k){this.attachEvent("batchRequestFailed",i,j,k);return this;};D.prototype.detachBatchRequestFailed=function(i,j){this.detachEvent("batchRequestFailed",i,j);return this;};D.prototype.fireBatchRequestFailed=function(P){this.fireEvent("batchRequestFailed",P);return this;};D.prototype.attachBatchRequestSent=function(i,j,k){this.attachEvent("batchRequestSent",i,j,k);return this;};D.prototype.detachBatchRequestSent=function(i,j){this.detachEvent("batchRequestSent",i,j);return this;};D.prototype.fireBatchRequestSent=function(P){this.fireEvent("batchRequestSent",P);return this;};D.prototype.attachBatchRequestCompleted=function(i,j,k){this.attachEvent("batchRequestCompleted",i,j,k);return this;};D.prototype.detachBatchRequestCompleted=function(i,j){this.detachEvent("batchRequestCompleted",i,j);return this;};D.prototype.fireBatchRequestCompleted=function(P){this.fireEvent("batchRequestCompleted",P);return this;};D.mSharedData={server:{},service:{},meta:{}};D._getSharedData=function(S,k){var i=this.mSharedData[S][k];if(!i){i={};this.mSharedData[S][k]=i;}return i;};D.prototype._initializeMetadata=function(){if(this.bDestroyed){return;}this.bIsMessageScopeSupported=this.oMetadata._isMessageScopeSupported();var i=function(){this.fireMetadataLoaded({metadata:this.oMetadata});L.debug(this+" - metadataloaded fired");}.bind(this);this.initialize();if(this.bLoadAnnotationsJoined){this.oAnnotations.loaded().then(i,this.fireMetadataFailed.bind(this));}else{i();}};D.prototype.refreshMetadata=function(){if(this.oMetadata&&this.oMetadata.refresh){return this.oMetadata.refresh();}};D.prototype.fireAnnotationsLoaded=function(P){this.fireEvent("annotationsLoaded",P);return this;};D.prototype.attachAnnotationsLoaded=function(i,j,k){this.attachEvent("annotationsLoaded",i,j,k);return this;};D.prototype.detachAnnotationsLoaded=function(i,j){this.detachEvent("annotationsLoaded",i,j);return this;};D.prototype.fireAnnotationsFailed=function(P){this.fireEvent("annotationsFailed",P);L.debug(this+" - annotationsfailed fired");return this;};D.prototype.attachAnnotationsFailed=function(i,j,k){this.attachEvent("annotationsFailed",i,j,k);return this;};D.prototype.detachAnnotationsFailed=function(i,j){this.detachEvent("annotationsFailed",i,j);return this;};D.prototype.fireMetadataLoaded=function(P){this.fireEvent("metadataLoaded",P);return this;};D.prototype.attachMetadataLoaded=function(i,j,k){this.attachEvent("metadataLoaded",i,j,k);return this;};D.prototype.detachMetadataLoaded=function(i,j){this.detachEvent("metadataLoaded",i,j);return this;};D.prototype.fireMetadataFailed=function(P){this.fireEvent("metadataFailed",P);return this;};D.prototype.attachMetadataFailed=function(i,j,k){this.attachEvent("metadataFailed",i,j,k);return this;};D.prototype.detachMetadataFailed=function(i,j){this.detachEvent("metadataFailed",i,j);return this;};D.prototype._createEventInfo=function(R,k,n){var G={};G.url=R.requestUri;G.method=R.method;G.async=R.async;G.headers=R.headers;if(n){G.requests=[];for(var i=0;i<n.length;i++){var H={};if(Array.isArray(n[i])){var I=n[i];for(var j=0;j<I.length;j++){var R=I[j].request;var J=n[i][j].response;H={};H.url=R.requestUri;H.method=R.method;H.headers=R.headers;if(J){H.response={};if(R._aborted){H.success=false;H.response.statusCode=0;H.response.statusText="abort";}else{H.success=true;if(J.message){H.response.message=J.message;J=J.response;H.response.responseText=J.body;H.success=false;}H.response.headers=J.headers;H.response.statusCode=J.statusCode;H.response.statusText=J.statusText;}}G.requests.push(H);}}else{var R=n[i].request;var J=n[i].response;H.url=R.requestUri;H.method=R.method;H.headers=R.headers;if(J){H.response={};if(R._aborted){H.success=false;H.response.statusCode=0;H.response.statusText="abort";}else{H.success=true;if(J.message){H.response.message=J.message;J=J.response;H.response.responseText=J.body;H.success=false;}H.response.headers=J.headers;H.response.statusCode=J.statusCode;H.response.statusText=J.statusText;}}G.requests.push(H);}}}if(k){G.response={};G.success=true;if(k.message){G.response.message=k.message;G.success=false;}if(k.response){k=k.response;}if(k&&k.statusCode!=undefined){G.response.headers=k.headers;G.response.statusCode=k.statusCode;G.response.statusText=k.statusText;G.response.responseText=k.body!==undefined?k.body:k.responseText;}}G.ID=R.requestID;return G;};D.prototype._createRequestID=function(){var R;R=u();return R;};D.prototype._getServerUrl=function(){var S,i;S=new U(this.sServiceUrl).absoluteTo(document.baseURI);i=new U("/").absoluteTo(S).toString();return i;};D.prototype._createMetadataUrl=function(i){if(i.indexOf(this.sServiceUrl)==-1){if(!i.startsWith("/")){i="/"+i;}i=this.sServiceUrl+i;}var j=t.fromURL(i||window.location.href);var k=Object.assign({},this.mMetadataUrlParams);Array.from(j.keys()).forEach(function(K){k[K]=j.get(K);});var n=a._createUrlParamsArray(k);var G=i.split("?");if(G.length>1){i=G[0];}return this._addUrlParams(i,n);};D.prototype._addUrlParams=function(i,j){var k=[];if(this.aUrlParams){k=k.concat(this.aUrlParams);}if(j){k=k.concat(j);}if(k&&k.length>0){i+="?"+k.join("&");}return i;};D.prototype._createRequestUrl=function(P,i,j,k){return this._createRequestUrlWithNormalizedPath(this._normalizePath(P,i),j,k);};D.prototype._createRequestUrlWithNormalizedPath=function(n,i,j){var k="";if(!j){k=this.sServiceUrl+n;}else{k=n.substr(n.indexOf('/')+1);}return this._addUrlParams(k,i);};D.prototype._importData=function(j,k,R,P,n,K,G){var H=this,I,J,N,S;P=P||"";K=K||"";if(j.results&&Array.isArray(j.results)){I=[];z(j.results,function(i,$){var K=H._getKey($);K=H._importData($,k,R,P.substr(0,P.lastIndexOf("/")),n,K);if(K){I.push(K);}});return I;}else{if(K){P="/"+K;n+=K.substr(K.indexOf("("));}else{K=this._getKey(j);}if(!K){return K;}N=this._getEntity(K);S=N;if(!N||(N.__metadata&&N.__metadata.invalid)){if(!S){S=j;}N=j;K=this._addEntity(N);}if(this.aBindableResponseHeaders){var T={};for(var V in R.headers){var W=V.toLowerCase();if(this.aBindableResponseHeaders.indexOf(W)>-1){T[W]=R.headers[V];}}if(!A(T)){if(!j.__metadata){j.__metadata={};}j.__metadata.headers=T;}}z(j,function(i,$){if($&&($.__metadata&&$.__metadata.uri||$.results)&&!$.__deferred){var _=P+"/"+i;var a1=n+"/"+i;J=H._importData($,k,R,_,a1);if(Array.isArray(J)){N[i]={__list:J};}else{if(S[i]&&S[i].__ref){if(S[i].__ref!==J){H.mInvalidatedPaths[P.substr(P.lastIndexOf("("))+"/"+i]="/"+J;}}N[i]={__ref:J};}}else if(!$||!$.__deferred){if(S[i]&&$===null){H.mInvalidatedPaths[P.substr(P.lastIndexOf("("))+"/"+i]=null;}N[i]=$;}});var X={};X[K]=N;if(this.hasContext("/"+K)&&this.getContext("/"+K).isPreliminary()){var Y=this.getContext("/"+K);Y.setUpdated(true);Y.setPreliminary(false);}this._updateChangedEntities(X);k[K]=true;P=P||'/'+K;n=n||P;var Z=this.resolveFromCache(n);if(Z==="/"+K||(Z&&Z.split("/").length>2)){this._writePathCache(Z,"/"+K,G);}this._writePathCache(P,"/"+K,G);this._writePathCache(n,"/"+K,G,true);return K;}};D.prototype._writePathCache=function(P,i,j,k){var n,G,H,I,S,J;if(P&&i){if(!this.mPathCache[P]){this.mPathCache[P]={};}if(!j&&P.lastIndexOf("/")===0){i=P;}this.mPathCache[P].canonicalPath=i;if(k){S=P.split("/");for(J=3;J<S.length;J+=1){H=S.slice(0,J).join("/");I=this.mPathCache[H];if(I){n=I.canonicalPath+P.slice(H.length);G=this.mPathCache[n];if(G){G.canonicalPath=i;}}}}}};D.prototype._removeReferences=function(j){var k=this,n;if(!j){return j;}if(j.results){n=[];z(j.results,function(i,G){n.push(k._removeReferences(G));});return n;}else{z(j,function(P,i){if(i){if(i["__ref"]||i["__list"]){delete j[P];}}});return j;}};D.prototype._restoreReferences=function(j,V){var k=this,K,n,R;function G(K){var n=V[K];if(!n){n=k._getObject("/"+K);s(n,"ODataModel inconsistent: "+K+" not found!");if(n){n=w({},n);V[K]=n;k._restoreReferences(n,V);}}return n;}if(!V){V={};}z(j,function(P,H){if(H){if(H.__ref){K=H.__ref;n=G(K);if(n){j[P]=n;}delete H.__ref;}else if(H.__list){R=[];z(H.__list,function(i,K){n=G(K);if(n){R.push(n);}});delete H.__list;H.results=R;}}});return j;};D.prototype.removeData=function(){this.oData={};};D.prototype.initialize=function(){var i=this.getBindings();i.forEach(function(j){j.initialize();});};D.prototype.invalidate=function(i){var j;for(var k in this.oData){j=this.oData[k];if(!i||i(k,j)){j.__metadata.invalid=true;}}};D.prototype.invalidateEntry=function(i){var j;if(typeof i==="string"){if(i.indexOf("/")===0){j=this._getObject(i);}else{j=this.oData[i];}}else if(i instanceof C){j=this._getObject(i.getPath());}if(j&&j.__metadata){j.__metadata.invalid=true;}};D.prototype.invalidateEntityType=function(i){var j;for(var k in this.oData){j=this.oData[k];if(j.__metadata.type===i){j.__metadata.invalid=true;}}};D.prototype.refresh=function(i,R,G){if(typeof i==="string"){G=i;i=false;R=false;}if(R){this.removeData();}this._refresh(i,G);};D.prototype._refresh=function(i,G,j,k){var n=this.getBindings();this.sRefreshGroupId=G;n.forEach(function(H){H._refresh(i,j,k);});this.sRefreshGroupId=undefined;};D.prototype.checkUpdate=function(i,j,k,n){if(j){if(!this.sUpdateTimer){this.sUpdateTimer=setTimeout(function(){this.checkUpdate(i,false,k);}.bind(this),0);}return;}if(this.sUpdateTimer){clearTimeout(this.sUpdateTimer);this.sUpdateTimer=null;}var G=this.getBindings();G.forEach(function(H){if(!n||this.isMetaModelPath(H.getPath())){H.checkUpdate(i,k);}}.bind(this));this._processAfterUpdate();};D.prototype.checkDataState=function(i){var j=this.getBindings();j.forEach(function(k){if(k.checkDataState){k.checkDataState(i);}});};D.prototype.bindProperty=function(P,i,j){var k=new l(this,P,i,j);return k;};D.prototype.bindList=function(P,i,S,j,k){var n=new g(this,P,i,S,j,k);return n;};D.prototype.bindTree=function(P,i,j,k,S){var n=new m(this,P,i,j,k,S);return n;};D.prototype.createBindingContext=function(P,i,j,k,R){var n,G,N,H,I,J=this,K;if(i!==null&&typeof i==="object"&&!(i instanceof sap.ui.model.Context)){R=k;k=j;j=i;i=undefined;}if(typeof i=="function"){R=j;k=i;j=undefined;i=undefined;}if(typeof i=="boolean"){R=i;k=undefined;j=undefined;i=undefined;}if(typeof j=="function"){R=k;k=j;j=undefined;}if(typeof j=="boolean"){R=j;k=undefined;j=undefined;}if(typeof k=="boolean"){R=k;k=undefined;}if(j){K=j.canonicalRequest;}K=this._isCanonicalRequestNeeded(K);n=this.resolve(P,i,K);if(!n&&K){n=this.resolve(P,i);}I=this.resolveDeep(P,i);if(!n){if(k){k(null);}return null;}if(R===undefined){R=this._isReloadNeeded(n,j);}if(!R){G=this.resolve(P,i,true);if(G){N=this.getContext(G,I);}else{N=null;}if(k){k(N);}return N;}function S(Y){var Z=Y?J._getKey(Y):null,$=!(P===""||P.indexOf("/")>0),_=null,a1,b1;N=null;if(Z){N=J.getContext('/'+Z,I);_={__ref:Z};}if(i&&V&&$){a1=i.getPath();a1=a1.substr(1);b1=J._getEntity(a1);if(b1){b1[P]=_;}}k(N);}function T(Y){var Z;if(Y.statusCode=='404'&&i&&V){var $=i.getPath();$=$.substr(1);Z=J._getEntity($);if(Z){Z[P]={__ref:null};}}k(null);}if(k){var V=!P.startsWith("/");if(n){var W=[],X=this.createCustomParams(j);if(X){W.push(X);}if(j&&(j.batchGroupId||j.groupId)){H=j.groupId||j.batchGroupId;}this.read(P,{groupId:H,urlParameters:W,success:S,error:T,context:i,canonicalRequest:K});}else{k(null);}}if(j&&j.createPreliminaryContext){n=this.resolve(P,i,K);if(!n&&K){n=this.resolve(P,i);}N=this.getContext(n,I);return N;}};D.prototype._updateContext=function(i,P){if(!P.startsWith("/")){throw new Error("Path "+P+" must start with a / ");}i.sPath=P;this.mContexts[P]=i;};D.prototype._splitEntries=function(i){return i.replace(/\s/g,"").split(',').map(function(j){return j.split("/");});};D.prototype._filterOwnSelect=function(S,i){var j,k;if(!i){return[];}k=i.map(function(P){return P.name;});j=S.filter(function(n){return n.length===1;}).map(function(n){return n[0];});if(S.length===0||j.indexOf("*")!==-1||j.indexOf("**")!==-1){return k;}else{return j.filter(function(n){return k.indexOf(n)!==-1;});}};D.prototype._filterOwnExpand=function(i,S){return i.map(function(j){return j[0];}).filter(function(V,I,j){return j.indexOf(V)===I;}).filter(function(V){return S.length===0||S.some(function(j){return j.indexOf(V)===0||j.indexOf("**")===0;});});};D.prototype._filterSelectByNavProp=function(i,n){return i.filter(function(S){return S[0]===n;}).map(function(S){return S.length>1?S.slice(1):["**"];});};D.prototype._filterExpandByNavProp=function(i,n){return i.filter(function(S){return S.length>1&&S[0]===n;}).map(function(S){return S.slice(1);});};D.prototype._isReloadNeeded=function(P,k){var n=this,G=this.oMetadata,H,I=this._getObject(P),J=[],S=[];if(!this.oMetadata.isLoaded()){return true;}H=this.oMetadata._getEntityTypeByPath(P);if(this._isCreatedEntity(I)){return false;}function K(H,I,S,J){var N,R,T,V,W,X,Y,Z,$;if(!H){return false;}if(I===null){return false;}if(!I){return true;}if(I.__metadata&&I.__metadata.invalid){return true;}N=n._filterOwnSelect(S,H.property);for(var i=0;i<N.length;i++){$=N[i];if(I[$]===undefined){return true;}}R=n._filterOwnExpand(J,S);for(var i=0;i<R.length;i++){Z=R[i];T=I[Z];if(T===null){continue;}if(T===undefined||T.__deferred){return true;}V=G._getEntityTypeByNavProperty(H,Z);X=n._filterSelectByNavProp(S,Z);Y=n._filterExpandByNavProp(J,Z);if(T.__ref){W=n._getEntity(T.__ref);if(K(V,W,X,Y)){return true;}}if(T.__list){for(var j=0;j<T.__list.length;j++){W=n._getEntity(T.__list[j]);if(K(V,W,X,Y)){return true;}}}}return false;}if(k){if(k.select){S=this._splitEntries(k.select);}if(k.expand){J=this._splitEntries(k.expand);}}return K(H,I,S,J);};D.prototype.createCustomParams=function(P){var i=[],j,S={expand:true,select:true};for(var n in P){if(n in S){i.push("$"+n+"="+x(P[n]));}if(n==="custom"){j=P[n];for(n in j){if(n.indexOf("$")===0){L.warning(this+" - Trying to set OData parameter '"+n+"' as custom query option!");}else if(typeof j[n]==='string'){i.push(n+"="+x(j[n]));}else{i.push(n);}}}}return i.join("&");};D.prototype.bindContext=function(P,i,j){var k=new f(this,P,i,j);return k;};D.prototype.setDefaultCountMode=function(i){this.sDefaultCountMode=i;};D.prototype.getDefaultCountMode=function(){return this.sDefaultCountMode;};D.prototype._addEntity=function(i){var k=this._getKey(i);this.oData[k]=i;return k;};D.prototype._removeEntity=function(k){k=k&&a._normalizeKey(k);delete this.oData[k];delete this.mChangedEntities[k];delete this.mContexts["/"+k];};D.prototype._getEntity=function(k){var i=this.oData[k];if(!i){k=k&&a._normalizeKey(k);i=this.oData[k];}return i;};D.prototype._getKey=function(V){var k,i;if(V instanceof C){k=V.getPath().substr(1);}else if(V&&V.__metadata&&V.__metadata.uri){i=V.__metadata.uri;k=i.substr(i.lastIndexOf("/")+1);}else if(typeof V==='string'){k=V.substr(V.lastIndexOf("/")+1);}if(!this.oData[k]){k=k&&a._normalizeKey(k);}return k;};D.prototype.getKey=function(V){return this._getKey(V);};D.prototype.createKey=function(j,k){var n=this.oMetadata._getEntityTypeByPath(j),K=j,G=this,N,P;s(n,"Could not find entity type of collection \""+j+"\" in service metadata!");K+="(";if(n.key.propertyRef.length===1){N=n.key.propertyRef[0].name;s(N in k,"Key property \""+N+"\" is missing in object!");P=this.oMetadata._getPropertyMetadata(n,N);K+=encodeURIComponent(a.formatValue(k[N],P.type));}else{z(n.key.propertyRef,function(i,H){if(i>0){K+=",";}N=H.name;s(N in k,"Key property \""+N+"\" is missing in object!");P=G.oMetadata._getPropertyMetadata(n,N);K+=N;K+="=";K+=encodeURIComponent(a.formatValue(k[N],P.type));});}K+=")";return K;};D.prototype.getProperty=function(P,i,I){var V=this._getObject(P,i);if(!I){return V;}if(!y(V)){return V;}V=w({},V);if(I===true){return this._restoreReferences(V);}else{return this._removeReferences(V);}};D.prototype.getObject=function(P,n,G){if(y(n)){G=n;n=undefined;}var H=this,R=this.resolve(P,n),V=this._getObject(R),I=this.oMetadata._getEntityTypeByPath(R),J=[],S=[];if(!I||!y(V)||!V.__metadata||!V.__metadata.uri){return V;}if(!G||!(G.select||G.expand)){return w({},V);}function K(I,V,S,J){var N,T,W,X,Y,Z,$,_,a1,b1,c1,d1,e1;if(!V){return undefined;}if(!I){return undefined;}W=H._filterOwnSelect(S,I.property);T={};for(var i=0;i<W.length;i++){d1=W[i];if(V[d1]!==undefined){T[d1]=V[d1];}else{L.fatal("No data loaded for select property: "+d1+" of entry: "+H.getKey(V));return undefined;}}if(V.__metadata){T.__metadata=V.__metadata;}N=H._filterOwnExpand(J,S);for(var i=0;i<N.length;i++){c1=N[i];Y=V[c1];Z=H.oMetadata._getEntityTypeByNavProperty(I,c1);a1=H._filterSelectByNavProp(S,c1);b1=H._filterExpandByNavProp(J,c1);if(Y&&Y.__ref){_=H._getObject("/"+Y.__ref);$=K(Z,_,a1,b1);if($!==undefined){T[c1]=$;}else{L.fatal("No data loaded for expand property: "+c1+" of entry: "+H.getKey($));return undefined;}}if(Y&&Y.__list){e1=[];for(var j=0;j<Y.__list.length;j++){_=H._getObject("/"+Y.__list[j]);$=K(Z,_,a1,b1);if($!==undefined){e1.push($);}else{L.fatal("No data loaded for expand property: "+c1+" of entry: "+H.getKey($));return undefined;}}T[c1]=e1;}}X=H._filterOwnSelect(S,I.navigationProperty);for(var k=0;k<X.length;k++){c1=X[k];if(N.indexOf(c1)===-1){var f1=T.__metadata.uri+"/"+c1;T[c1]={__deferred:{uri:f1}};}}return T;}if(G.select){S=this._splitEntries(G.select);}if(G.expand){J=this._splitEntries(G.expand);}V=K(I,V,S,J);return V;};D.prototype._getObject=function(P,i,j){var n=this.isLegacySyntax()?this.oData:null,k,G,R,S,H,I,J,K,N;R=this.resolve(P,i,this.bCanonicalRequests);if(!R&&this.bCanonicalRequests){R=this.resolve(P,i);}if(!R){return n;}if(this._isMetadataPath(R)){if(this.oMetadata&&this.oMetadata.isLoaded()){if(this.isMetaModelPath(R)){S=R.indexOf('/##');N=this.getMetaModel();if(!this.bMetaModelLoaded){return null;}H=R.substr(0,S);I=R.substr(S+3);J=N.getMetaContext(H);n=N.getProperty(I,J);}else{n=this.oMetadata._getAnnotation(R);}}}else{if(R==="/"){return this.oData;}var T=R.split("/"),V=0;K=T[1];T.splice(0,2);k=this.mChangedEntities[K];G=this._getEntity(K);n=j?G:k||G;while(n&&T[V]){var W=k&&k.hasOwnProperty(T[V]);k=k&&k[T[V]];G=G&&G[T[V]];n=j||!W?G:k;if(n){if(n.__ref){k=this.mChangedEntities[n.__ref];G=this._getEntity(n.__ref);n=j?G:k||G;}else if(n.__list){n=n.__list;}else if(n.__deferred){n=undefined;}}V++;}}if(y(k)){n=j?G:w({},G,k);}return n;};D.prototype.updateSecurityToken=function(){if(this.bTokenHandling){if(!this.oSharedServiceData.securityToken){this.refreshSecurityToken();}if(this.bTokenHandling){this.oHeaders["x-csrf-token"]=this.oSharedServiceData.securityToken;}}};D.prototype.resetSecurityToken=function(){delete this.oSharedServiceData.securityToken;delete this.oHeaders["x-csrf-token"];delete this.pSecurityToken;};D.prototype.getSecurityToken=function(){var T=this.oSharedServiceData.securityToken;if(!T){this.refreshSecurityToken();T=this.oSharedServiceData.securityToken;}return T;};D.prototype.securityTokenAvailable=function(){if(!this.pSecurityToken){if(this.oSharedServiceData.securityToken){this.pSecurityToken=Promise.resolve(this.oSharedServiceData.securityToken);}else{this.pSecurityToken=new Promise(function(i,j){this.refreshSecurityToken(function(){i(this.oSharedServiceData.securityToken);}.bind(this),function(){j();},true);}.bind(this));}}return this.pSecurityToken;};D.prototype.refreshSecurityToken=function(S,i,j){var T;var k=this;var n=this._createRequestUrlWithNormalizedPath("/");var G={abort:function(){this.request.abort();}};function H(N,R){if(R){T=k._getHeader("x-csrf-token",R.headers);k._setSessionContextIdHeader(k._getHeader("sap-contextid",R.headers));if(T){k.oSharedServerData.securityToken=T;k.oSharedServiceData.securityToken=T;k.pSecurityToken=Promise.resolve(T);k.oHeaders["x-csrf-token"]=T;}else{k.resetSecurityToken();k.bTokenHandling=false;}}if(S){S(N,R);}}function I(N){k.resetSecurityToken();k.bTokenHandling=false;k._handleError(N);if(i){i(N);}}function J(N){G.request=K("GET",I);}function K(R,i){var N=k._createRequest(n,"",R,k._getHeaders(undefined,true),null,null,!!j);N.headers["x-csrf-token"]="Fetch";return k._request(N,H,i,undefined,undefined,k.getServiceMetadata());}if(this.bDisableHeadRequestForToken){G.request=K("GET",I);}else{G.request=K("HEAD",J);}return G;};D.prototype._submitRequest=function(R,S,j){var k=this,H,n,G,I,J;I=new Promise(function(i,X){J=i;});function K(i,X){if(S){S(i,X);}J();}function N(i){if(k.bTokenHandling&&i.response){var X=k._getHeader("x-csrf-token",i.response.headers);if(!R.bTokenReset&&i.response.statusCode=='403'&&X&&X.toLowerCase()==="required"){k.resetSecurityToken();R.bTokenReset=true;T();return;}}if(j){j(i);}J();}function P(R){if(k.bTokenHandling&&(R.method!=="GET"||k.bTokenHandlingForGet)){k.pReadyForRequest=k.securityTokenAvailable();}return k.pReadyForRequest;}function T(){if(k.bTokenHandling){delete R.headers["x-csrf-token"];}P(R).then(function(i){if(k.bTokenHandling&&(R.method!=="GET"||k.bTokenHandlingForGet)){R.headers["x-csrf-token"]=i;}W();},function(){W();});}function V(X,R,Y){var Z,$=R.eventInfo.requests;if($){z($,function(i,R){if(Array.isArray(R)){R.forEach(function(R){z(R.parts,function(i,_){Z=k._createEventInfo(R.request,_.fnError);k["fireRequest"+X](Z);});});}else{if(R.parts){z(R.parts,function(i,_){Z=k._createEventInfo(R.request,_.fnError);k["fireRequest"+X](Z);});}else{Z=k._createEventInfo(R.request,R.fnError);k["fireRequest"+X](Z);}}});if(R.eventInfo.batch){Z=k._createEventInfo(R,Y,$);k["fireBatchRequest"+X](Z);}}}function W(){if(k.sSessionContextId){R.headers["sap-contextid"]=k.sSessionContextId;}n=k._request(R,K,N,H,undefined,k.getServiceMetadata());if(R.eventInfo){V("Sent",R,null);delete R.eventInfo;}if(G){n.abort();}}H=k._getODataHandler(R.requestUri);if(this.bSequentializeRequests){this.pSequentialRequestCompleted.then(function(){T();});this.pSequentialRequestCompleted=I;}else{T();}return{abort:function(){if(n){n.abort();}G=true;}};};D.prototype._setSessionContextIdHeader=function(S){if(S){this.sSessionContextId=S;}};D.prototype._submitSingleRequest=function(R){var j=this,k,n={},G={},H={};function I(K,N){if(K===undefined&&N.statusCode===200){J({message:"Response did not contain a valid OData result",response:N});return;}function P(K,N){for(var i=0;i<R.parts.length;i++){if(R.parts[i].request._aborted){j._processAborted(R.parts[i].request,N);}else if(R.parts[i].fnSuccess){R.parts[i].fnSuccess(K,N);}}if(R.request.requestUri.indexOf("$count")===-1){j.checkUpdate(false,false,G);if(R.bRefreshAfterChange){j._refresh(false,undefined,n,H);}}}j._processSuccess(R.request,N,P,G,n,H);j._invalidatePathCache();j._setSessionContextIdHeader(j._getHeader("sap-contextid",N.headers));}function J(K){if(K.message=="Request aborted"){for(var i=0;i<R.parts.length;i++){j._processAborted(R.parts[i].request,K);}}else{for(var i=0;i<R.parts.length;i++){j._processError(R.parts[i].request,K,R.parts[i].fnError);}}j._processAfterUpdate();}R.request.eventInfo={requests:R.parts,batch:false};k=this._submitRequest(R.request,I,J);return k;};D.prototype._submitBatchRequest=function(k,R,S,n){var G=this,H={},I={},J={};function K(j,X,Y){for(var i=0;i<j.parts.length;i++){if(Y||j.parts[i].request._aborted){G._processAborted(j.parts[i].request,X);}else if(X.message){G._processError(j.parts[i].request,X,j.parts[i].fnError);}else{G._processSuccess(j.parts[i].request,X,j.parts[i].fnSuccess,I,H,J);}}}function N(X,Y){if(X===undefined&&Y.statusCode===200){P({message:"Response did not contain a valid OData batch result",response:Y});return;}var Z,$,_,a1=X.__batchResponses;if(a1){var i,j;for(i=0;i<a1.length;i++){Z=a1[i];if(Array.isArray(R[i])){if(Z.message){for(j=0;j<R[i].length;j++){$=R[i][j];K($,Z);$.response=Z;}}else{_=Z.__changeResponses;for(j=0;j<_.length;j++){var b1=_[j];$=R[i][j];K($,b1);$.response=b1;}}}else{$=R[i];K($,Z);$.response=Z;}}G._invalidatePathCache();G.checkUpdate(false,false,I);}G._processSuccess(k,Y,S,I,H,J,true,R);G._setSessionContextIdHeader(G._getHeader("sap-contextid",Y.headers));}function P(j){var X=j.message=="Request aborted";z(R,function(i,Y){if(Array.isArray(Y)){Y.forEach(function(Y){K(Y,j,X);});}else{K(Y,j,X);}});G._processAfterUpdate();if(X){G._processAborted(k,j,true);}else{G._processError(k,j,n,true,R);}}k.eventInfo={requests:R,batch:true};var T=this._submitRequest(k,N,P);function V(j){var n;for(var i=0;i<j.parts.length;i++){n=j.parts[i].fnError;if(!j.parts[i].request._aborted&&n){n(E);}}}var W={abort:function(j){z(R,function(i,X){if(Array.isArray(X)){X.forEach(function(X){V(X);});}else{V(X);}});if(n&&!j){n(E);}T.abort();}};return W;};D.prototype._invalidatePathCache=function(){var i=this,I;if(Object.keys(this.mInvalidatedPaths).length>0){Object.keys(this.mPathCache).forEach(function(k){for(var j in i.mInvalidatedPaths){I=k.indexOf(j);if(I>-1){if(I+j.length!==k.length){var n=k.substr(I+j.length);i.mPathCache[k].canonicalPath=i.mInvalidatedPaths[j]===null?null:i.mInvalidatedPaths[j]+n;}else{i.mPathCache[k].canonicalPath=i.mInvalidatedPaths[j];}}}});}this.mInvalidatedPaths={};};D.prototype._createBatchRequest=function(i){var j,R,k={},P={},n=true;P.__batchRequests=i;for(var I in i){if(i[I]&&i[I].__changeRequests||i[I]&&i[I].headers&&!i[I].headers['sap-cancel-on-close']){n=false;break;}}j=this.sServiceUrl+"/$batch";if(this.aUrlParams.length>0){j+="?"+this.aUrlParams.join("&");}Q.extend(k,this.mCustomHeaders,this.oHeaders);k["Accept"]="multipart/mixed";delete k["Content-Type"];k['sap-cancel-on-close']=n;R={headers:k,requestUri:j,method:"POST",data:P,user:this.sUser,password:this.sPassword,async:true};R.withCredentials=this.bWithCredentials;return R;};D.prototype.abortInternalRequest=function(G,P){var R=this.mRequests;var j,k;if(P){j=P.requestKey;k=P.path;}if(G in this.mDeferredGroups){R=this.mDeferredRequests;}var n=function(I){for(var i=0;i<I.parts.length;i++){I.parts[i].requestHandle.abort();}};var H=R[G];if(H){if(j in H.map){n(H.map[j]);}else if(k){z(H.map,function(j,i){if(j.indexOf(k)>=0){n(i);}});}else if(G&&!P){z(H.map,function(K,i){n(i);});}}};D.prototype._pushToRequestQueue=function(R,G,i,j,S,k,n,H){var I=R[G],J=j.key?j.key:j.method+":"+j.requestUri;if(this.bWarmup){return;}if(!I){I={};I.map={};I.requests=[];R[G]=I;}if(J in I.map&&(j.key||j.method==='GET')){var K=I.map[J];var N=K.request;j.deepPath=N.deepPath;if(this.sMessageScope===e.BusinessObject){j.headers["sap-message-scope"]=N.headers["sap-message-scope"];}if(K.bRefreshAfterChange===undefined){K.bRefreshAfterChange=H;}if(!j.key){K.parts.push({request:j,fnSuccess:S,fnError:k,requestHandle:n});}if(j.method==="GET"){delete N.data;}else{N.method=j.method;N.headers=j.headers;N.data=j.data;N.requestUri=j.requestUri;if(j.method==="PUT"){delete N.headers["x-http-method"];}if(N._aborted){delete N._aborted;}}}else{var K={request:j,bRefreshAfterChange:H,parts:[{request:j,fnSuccess:S,fnError:k,requestHandle:n}]};if(j.method==="GET"){I.requests.push(K);}else{if(!I.changes){I.changes={};}var P=I.changes[i];if(!P){P=[];I.changes[i]=P;}K.changeSetId=i;P.push(K);}I.map[J]=K;}};D.prototype._collectChangedEntities=function(G,j,k){var n=this;if(G.changes){z(G.changes,function(H,I){for(var i=0;i<I.length;i++){if(I[i].bRefreshAfterChange){var R=I[i].request,P="/"+R.requestUri.split("?")[0],J,K;if(R.method==="POST"||R.method==="DELETE"){var N=n.oMetadata._getEntityTypeByPath(P);if(N){k[N.entityType]=true;}}else{J=n._getObject(P);if(J){K=n._getKey(J);}else if(P.lastIndexOf("/")===0){K=n._getKey(P);}if(K){j[K]=true;}}}}});}};D.prototype._processRequestQueue=function(R,G,S,j){var k=this,P,n=[];function H(J,W){for(var i=0;i<J.parts.length;i++){var K=J.parts[i];if(K.request._aborted){k._processAborted(J.request,null);J.parts.splice(i,1);i--;}else if(W){K.request._handle=W;W.iRelevantRequests++;}}}function I(){return{iRelevantRequests:0,oRequestHandle:{},abort:function(){this.iRelevantRequests--;if(this.iRelevantRequests===0&&this.oRequestHandle){this.oRequestHandle.abort(true);if(S){S({},undefined);}}}};}if(this.bUseBatch){z(R,function(i,J){if(i===G||!G){var K={},N={};k._collectChangedEntities(J,K,N);if(Object.keys(K).length||Object.keys(N).length){k.bIncludeInCurrentBatch=true;k._refresh(false,i,K,N);k.bIncludeInCurrentBatch=false;}}});z(R,function(J,K){if(J===G||!G){var N=[],T=[],V,W;var X=I();if(K.changes){z(K.changes,function($,_){V={__changeRequests:[]};W=[];for(var i=0;i<_.length;i++){P='/'+k.getKey(_[i].request.data);k.increaseLaundering(P,_[i].request.data);H(_[i],X);if(_[i].parts.length>0){k.removeInternalMetadata(_[i].request.data);V.__changeRequests.push(_[i].request);W.push(_[i]);}}if(V.__changeRequests&&V.__changeRequests.length>0){N.push(V);T.push(W);}});}if(K.requests){var Y=K.requests;for(var i=0;i<Y.length;i++){H(Y[i],X);if(Y[i].parts.length>0){N.push(Y[i].request);T.push(Y[i]);}}}if(N.length>0){var Z=k._createBatchRequest(N);X.oRequestHandle=k._submitBatchRequest(Z,T,S,j);n.push(X.oRequestHandle);}delete R[J];}});}else{z(R,function(J,K){if(J===G||!G){if(K.changes){z(K.changes,function(T,V){for(var i=0;i<V.length;i++){var W=I();P='/'+k.getKey(V[i].request.data);k.increaseLaundering(P,V[i].request.data);H(V[i],W);if(V[i].parts.length>0){k.removeInternalMetadata(V[i].request.data);W.oRequestHandle=k._submitSingleRequest(V[i]);n.push(W.oRequestHandle);}}});}if(K.requests){var N=K.requests;for(var i=0;i<N.length;i++){var W=I();H(N[i],W);if(N[i].parts.length>0){W.oRequestHandle=k._submitSingleRequest(N[i]);n.push(W.oRequestHandle);}}}delete R[J];}});}this.checkDataState(this.mLaunderingState);return n.length==1?n[0]:n;};D.prototype._processRequestQueueAsync=function(R){var i=this;if(!this.pCallAsync){this.pCallAsync=this.oMetadata.loaded().then(function(){return Promise.resolve().then(function(){i._processRequestQueue(R);i.pCallAsync=undefined;});});}};D.prototype._processSuccess=function(R,i,S,G,j,k,n,H){var I=i.data,J,K,N,P,T,V,W,X={},Y={},Z=this;if(!n){K=!(i.statusCode===204||i.statusCode==='204');N=R.requestUri;P=N.replace(this.sServiceUrl,"");if(!P.startsWith('/')){P='/'+P;}var $=this._normalizePath(P);var _=this.oMetadata._getEntityTypeByPath($);var a1=_?!_.isFunction:true;P=this._normalizePath(P,undefined,a1);this.decreaseLaundering(P,R.data);this._decreaseDeferredRequestCount(R);if(K&&I===undefined&&i){this._parseResponse(i,R);L.fatal(this+" - No data was retrieved by service: '"+i.requestUri+"'");Z.fireRequestCompleted({url:i.requestUri,type:"GET",async:i.async,info:"Accept headers:"+this.oHeaders["Accept"],infoObject:{acceptHeaders:this.oHeaders["Accept"]},success:false});return false;}if(I&&!I.__metadata&&I.results&&!Array.isArray(I.results)){I=I.results;}if(!i._imported&&I&&(Array.isArray(I)||typeof I=='object')){J=w({},I);if(R.key||R.created){Z._importData(J,X,i,undefined,undefined,undefined,_&&_.isFunction);}else{Z._importData(J,X,i,P,R.deepPath,undefined,_&&_.isFunction);}i._imported=true;}V=this._getEntity(R.key);if(X&&V&&V.__metadata.created&&V.__metadata.created.functionImport){var b1=[];var c1=V["$result"];if(c1&&c1.__list){z(X,function(e1){b1.push(e1);});c1.__list=b1;}else if(c1&&c1.__ref){z(X,function(e1){c1.__ref=e1;});}}if(!K){T=P.split("/");if(T[1]){Y[T[1]]=R;var d1={};d1[T[1]]=R.data;this._updateChangedEntities(d1);}if(R.method==="DELETE"&&T[2]!=="$links"){this._removeEntity(T[1]);}}if(K&&R.method==="POST"){W=this.oMetadata._getEntityTypeByPath(P);if(W){k[W.entityType]=true;}if(R.key){if(R.created){var e1=this._getKey(I);var f1=this.getContext("/"+R.key);f1.bCreated=false;this._updateContext(f1,'/'+e1);f1.setUpdated(true);this.callAfterUpdate(function(){f1.setUpdated(false);});V=this._getEntity(e1);if(V){delete V.__metadata.created;}}this._removeEntity(R.key);}}this._parseResponse(i,R,X,Y);Q.extend(G,X);Q.extend(j,Y);this._updateETag(R,i);}if(S){S(I,i);}var g1=this._createEventInfo(R,i,H);if(n){this.fireBatchRequestCompleted(g1);}else{this.fireRequestCompleted(g1);}return true;};D.prototype._processError=function(R,i,j,k,n){var P,G=this._handleError(i,R);if(!k){P='/'+this.getKey(R.data);this.decreaseLaundering(P,R.data);this._decreaseDeferredRequestCount(R);}if(j){j(G);}var H=this._createEventInfo(R,G,n);if(k){this.fireBatchRequestCompleted(H);this.fireBatchRequestFailed(H);}else{this.fireRequestCompleted(H);this.fireRequestFailed(H);}};var E={message:"Request aborted",statusCode:0,statusText:"abort",headers:{},responseText:""};D.prototype._processAborted=function(R,i,j){var P;if(!j){P='/'+this.getKey(R.data);this.decreaseLaundering(P,R.data);this._decreaseDeferredRequestCount(R);}if(i){var k=this._createEventInfo(R,E);k.success=false;if(j){this.fireBatchRequestCompleted(k);}else{this.fireRequestCompleted(k);}}};D.prototype._processAfterUpdate=function(){var j=this.aCallAfterUpdate;this.aCallAfterUpdate=[];for(var i=0;i<j.length;i++){j[i]();}};D.prototype._processChange=function(k,i,j,G){var P,H,I,J,K,N,R,S,T,V,W,X=this;if(G&&this.mChangedEntities[k]&&this.mChangedEntities[k].__metadata){this.mChangedEntities[k].__metadata.deepPath=G;}else if(!G&&this.mChangedEntities[k]&&this.mChangedEntities[k].__metadata&&this.mChangedEntities[k].__metadata.deepPath){G=this.mChangedEntities[k].__metadata.deepPath;}H=this.oMetadata._getEntityTypeByPath(k);if(!j){j="MERGE";}P=w({},this._getObject('/'+k,true),i);if(i.__metadata&&i.__metadata.created){J=i.__metadata.created.method?i.__metadata.created.method:"POST";k=i.__metadata.created.key;R=true;I=i.__metadata.created;if(i.__metadata.created.functionImport){I.urlParameters=this._createFunctionImportParameters(i.__metadata.created.key,J,P);P=undefined;}else{delete P.__metadata['uri'];}}else if(j==="MERGE"){J="MERGE";W=this._getEntity(k);}else{J="PUT";}if(P&&P.__metadata){for(var n in P.__metadata){if(n!=='type'&&n!=='uri'&&n!=='etag'&&n!=='content_type'&&n!=='media_src'){delete P.__metadata[n];}}}if(P&&H){var Y=this.oMetadata._getNavigationPropertyNames(H);Y.forEach(function(_){delete P[_];});}if(J==="MERGE"&&H&&W){z(P,function(_,a1){if(_!=='__metadata'){if(v(W[_],a1)&&!X.isLaundering('/'+k+'/'+_)){delete P[_];}}});var Z="/"+k,$;z(P,function(_,a1){if(_!=='__metadata'){$=X.getProperty(Z+"/"+_+"/#@sap:unit");if($){if(P[$]===undefined){P[$]=W[$];}}}});}P=this._removeReferences(P);T=I&&I.urlParameters?a._createUrlParamsArray(I.urlParameters):undefined;S=I?this._getHeaders(I.headers):this._getHeaders();K=I&&I.eTag?I.eTag:this.getETag(P);N=this._createRequestUrl('/'+k,null,T,this.bUseBatch);V=this._createRequest(N,G,J,S,P,K,undefined,true);if(R){V.created=true;}if(this.bUseBatch){V.requestUri=V.requestUri.replace(this.sServiceUrl+'/','');}return V;};D.prototype._resolveGroup=function(k){var i,j,P,G,n,H;j=this.oMetadata._getEntityTypeByPath(k);H=this._getObject('/'+k);if(H){P=H.__metadata.created;if(P){return{groupId:P.groupId,changeSetId:P.changeSetId};}}if(this.mChangeGroups[j.name]){i=this.mChangeGroups[j.name];G=i.groupId;n=i.single?u():i.changeSetId;}else if(this.mChangeGroups['*']){i=this.mChangeGroups['*'];G=i.groupId;n=i.single?u():i.changeSetId;}return{groupId:G,changeSetId:n};};D.prototype._updateETag=function(R,i){var j,k,n;j=R.requestUri.replace(this.sServiceUrl+'/','');if(!j.startsWith("/")){j="/"+j;}k=this._getObject(j.split("?")[0]);n=this._getHeader("etag",i.headers);if(k&&k.__metadata&&n){k.__metadata.etag=n;}};D.prototype._handleError=function(i,R){var P={},T;var j="The following problem occurred: "+i.message;P.message=i.message;if(i.response){this._parseResponse(i.response,R);if(this.bTokenHandling){T=this._getHeader("x-csrf-token",i.response.headers);if(i.response.statusCode=='403'&&T&&T.toLowerCase()==="required"){this.resetSecurityToken();}}j+=i.response.statusCode+","+i.response.statusText+","+i.response.body;P.statusCode=i.response.statusCode;P.statusText=i.response.statusText;P.headers=i.response.headers;P.responseText=i.response.body;}L.fatal(j);return P;};D.prototype.getData=function(P,i,I){return this.getProperty(P,i,I);};D.prototype._getODataHandler=function(i){if(i.indexOf("$batch")>-1){return r.batchHandler;}else if(i.indexOf("$count")>-1){return undefined;}else if(this.bJSON){return r.jsonHandler;}else{return r.atomHandler;}};D.prototype.getETag=function(P,i,j){if(typeof P=="object"){j=P;P="";}return this._getETag(P,i,j);};D.prototype._getETag=function(P,i,j){if(!j||!j.__metadata){j=this._getObject(P,i);}if(j&&j.__metadata){return j.__metadata.etag;}return null;};D.prototype.forceEntityUpdate=function(k){var i=this.mChangedEntities[k];if(i&&i.__metadata){i.__metadata.etag='*';}else{L.error(this+" - Entity with key "+k+" does not exist or has no change");}};D.prototype._createRequest=function(i,j,k,H,n,G,I,R){I=I!==false;if(G&&k!=="GET"){H["If-Match"]=G;}if(!H["Content-Type"]&&k!=="DELETE"&&k!=="GET"){if(this.bJSON){H["Content-Type"]="application/json";}else{H["Content-Type"]="application/atom+xml";}}if(i.indexOf("$count")>-1){H["Accept"]="text/plain, */*;q=0.5";}if(k==="MERGE"&&!this.bUseBatch){H["x-http-method"]="MERGE";k="POST";}if(this.sMessageScope===e.BusinessObject){s(this.bIsMessageScopeSupported,"MessageScope 'BusinessObject' is not supported by the service");H["sap-message-scope"]=this.sMessageScope;}var J={headers:H,requestUri:i,method:k,user:this.sUser,password:this.sPassword,async:I,deepPath:j,refresh:R};if(n){J.data=n;}if(this.bWithCredentials){J.withCredentials=this.bWithCredentials;}J.requestID=this._createRequestID();return J;};D.prototype._processRequest=function(P,i,j){var R,k,n=false,G=this;if(this.bWarmup){return{abort:function(){}};}if(j){this.iPendingDeferredRequests++;}R={abort:function(){if(j&&!n){G.iPendingDeferredRequests--;}if(!n&&i){i(E);}if(k){k._aborted=true;if(k._handle){k._handle.abort();}}n=true;}};this.oMetadata.loaded().then(function(){k=P(R);k.deferred=!!j;G._processRequestQueueAsync(G.mRequests);if(n){R.abort();}});return R;};D.prototype.update=function(P,i,j){var S,k,R,n,G,H,I,J,K,N,T,V,W,X,Y,Z=this,$,_,a1;if(j){J=j.groupId||j.batchGroupId;K=j.changeSetId;G=j.context;S=j.success;k=j.error;H=j.eTag;T=j.headers;N=j.urlParameters;X=j.refreshAfterChange;a1=j.canonicalRequest;if(j.merge!==undefined){V=j.merge?"MERGE":"PUT";}}a1=this._isCanonicalRequestNeeded(a1);Y=J in Z.mDeferredGroups;X=this._getRefreshAfterChange(X,J);I=a._createUrlParamsArray(N);T=this._getHeaders(T);V=V?V:this.sDefaultUpdateMethod;H=H||this._getETag(P,G,i);$=this._normalizePath(P,G,a1);_=this.resolveDeep(P,G);return this._processRequest(function(b1){n=Z._createRequestUrlWithNormalizedPath($,I,Z.bUseBatch);R=Z._createRequest(n,_,V,T,i,H);W=Z.mRequests;if(Y){W=Z.mDeferredRequests;}Z._pushToRequestQueue(W,J,K,R,S,k,b1,X);return R;},k,Y);};D.prototype.create=function(P,i,j){var R,k,n,G,S,H,I,J,K,N,T,V,W,X,Y,Z,$=this,_,a1,b1;if(j){G=j.context;I=j.urlParameters;S=j.success;H=j.error;V=j.groupId||j.batchGroupId;X=j.changeSetId;T=j.eTag;K=j.headers;Y=j.refreshAfterChange;b1=j.canonicalRequest;}b1=this._isCanonicalRequestNeeded(b1);Y=this._getRefreshAfterChange(Y,V);N=a._createUrlParamsArray(I);K=this._getHeaders(K);W="POST";Z=V in $.mDeferredGroups;_=$._normalizePath(P,G,b1);a1=this.resolveDeep(P,G);return this._processRequest(function(c1){k=$._createRequestUrlWithNormalizedPath(_,N,$.bUseBatch);R=$._createRequest(k,a1,W,K,i,T);R.created=true;n=$.oMetadata._getEntityTypeByPath(_);R.entityTypes={};if(n){R.entityTypes[n.entityType]=true;}J=$.mRequests;if(Z){J=$.mDeferredRequests;}$._pushToRequestQueue(J,V,X,R,S,H,c1,Y);return R;},H,Z);};D.prototype.remove=function(P,i){var j,k,S,n,R,G,H,I,J,K,N,T,V,W,X,Y,Z=this,$,_,a1=this.bCanonicalRequests;if(i){H=i.groupId||i.batchGroupId;I=i.changeSetId;j=i.context;S=i.success;n=i.error;J=i.eTag;T=i.headers;N=i.urlParameters;K=i.refreshAfterChange;a1=i.canonicalRequest;}a1=this._isCanonicalRequestNeeded(a1);K=this._getRefreshAfterChange(K,H);V=a._createUrlParamsArray(N);T=this._getHeaders(T);W="DELETE";J=J||this._getETag(P,j);Y=H in Z.mDeferredGroups;$=this._normalizePath(P,j,a1);_=this.resolveDeep(P,j);function b1(c1,d1){k=G.substr(G.lastIndexOf('/')+1);if(k.indexOf('?')!==-1){k=k.substr(0,k.indexOf('?'));}Z._removeEntity(k);if(S){S(c1,d1);}}return this._processRequest(function(c1){G=Z._createRequestUrlWithNormalizedPath($,V,Z.bUseBatch);R=Z._createRequest(G,_,W,T,undefined,J);X=Z.mRequests;if(Y){X=Z.mDeferredRequests;}Z._pushToRequestQueue(X,H,I,R,b1,n,c1,K);return R;},n,Y);};D.prototype.callFunction=function(i,P){var R,j,k,n,G,H,S,I,J="GET",K,N,T,V,W=this,X,Y,Z,$,_,a1,b1,c1={};if(P){K=P.groupId||P.batchGroupId;N=P.changeSetId;J=P.method?P.method:J;G=Object.assign({},P.urlParameters);V=P.eTag;S=P.success;I=P.error;T=P.headers;b1=P.refreshAfterChange;}b1=this._getRefreshAfterChange(b1,K);if(!i.startsWith("/")){L.fatal(this+" callFunction: path '"+i+"' must be absolute!");return;}T=this._getHeaders(T);_=new Promise(function(d1,e1){Z=d1;$=e1;});a1=this._processRequest(function(d1){k=W.oMetadata._getFunctionImportMetadata(i,J);s(k,W+": Function "+i+" not found in the metadata !");if(!k){$();return;}var e1=k.entitySet||k.entitySetPath;if(e1){c1.$result={__list:[]};if(k.returnType&&k.returnType.indexOf("Collection")==-1){c1.$result={__ref:{}};}}if(k.parameter!=null){z(k.parameter,function(f1,g1){c1[g1.name]=W._createPropertyValue(g1.type);if(G&&G[g1.name]!==undefined){c1[g1.name]=G[g1.name];G[g1.name]=a.formatValue(G[g1.name],g1.type);}else{L.warning(W+" - No value for parameter '"+g1.name+"' found!'");}});}X=i.substring(1)+"('"+u()+"')";c1.__metadata={uri:W.sServiceUrl+'/'+X,created:{key:i.substring(1),success:S,error:I,headers:T,method:J,groupId:K,changeSetId:N,eTag:V,functionImport:true}};X=W._addEntity(c1);Y=W.getContext("/"+X);W._writePathCache("/"+X,"/"+X);Z(Y);H=a._createUrlParamsArray(G);j=W._createRequestUrlWithNormalizedPath(i,H,W.bUseBatch);R=W._createRequest(j,W.resolveDeep(i,Y),J,T,undefined,V);R.key=X;n=W.mRequests;if(K in W.mDeferredGroups){n=W.mDeferredRequests;}W._pushToRequestQueue(n,K,N,R,S,I,d1,b1);return R;},I);a1.contextCreated=function(){return _;};return a1;};D.prototype._createFunctionImportParameters=function(i,j,P){var k=Q.extend(true,{},P);delete k.__metadata;delete k["$result"];var n=this.oMetadata._getFunctionImportMetadata(i,j);s(n,this+": Function "+i+" not found in the metadata !");if(!n){return;}if(n.parameter!=null){z(n.parameter,function(I,G){if(k&&k[G.name]!==undefined){k[G.name]=a.formatValue(k[G.name],G.type);}});}return k;};D.prototype.read=function(P,i){var j,k,n,G,H,I,N,J,R,K,S,T,V,W,X,Y,Z,$,_,a1,b1,c1,d1,e1=this;if(i){a1=i._refresh;W=i.canonicalRequest;X=i.context;Y=i.error;Z=i.filters;$=i.groupId||i.batchGroupId;_=i.headers;b1=i.sorters;c1=i.success;d1=i.urlParameters;}W=this._isCanonicalRequestNeeded(W);if(this.sRefreshGroupId){$=this.sRefreshGroupId;}V=a._createUrlParamsArray(d1);_=this._getHeaders(_,true);I="GET";n=this._getETag(P,X);var f1={abort:function(){if(R){R._aborted=true;}}};var g1=P;var h1=P.indexOf("$count");if(h1!==-1){g1=P.substring(0,h1-1);}J=this._normalizePath(g1,X,W);N=this._normalizePath(P,X,W);j=this.resolveDeep(P,X);function i1(j1){S=a.createSortParams(b1);if(S){V.push(S);}k=e1.oMetadata._getEntityTypeByPath(J);G=F.groupFilters(Z);H=a.createFilterParams(G,e1.oMetadata,k);if(H){V.push(H);}T=e1._createRequestUrlWithNormalizedPath(N,V,e1.bUseBatch);R=e1._createRequest(T,j,I,_,null,n,undefined,a1);K=e1.mRequests;if($ in e1.mDeferredGroups){K=e1.mDeferredRequests;}e1._pushToRequestQueue(K,$,null,R,c1,Y,j1,false);return R;}if(this.bUseBatch&&this.bIncludeInCurrentBatch){R=i1(f1);return f1;}else{return this._processRequest(i1,Y);}};D.prototype.getServiceMetadata=function(){if(this.oMetadata&&this.oMetadata.isLoaded()){return this.oMetadata.getServiceMetadata();}};D.prototype.metadataLoaded=function(){var i=this.oMetadata.loaded();if(this.bLoadAnnotationsJoined){var j=function(){return i;};return this.pAnnotationsLoaded.then(j,j);}else{return i;}};D.prototype.annotationsLoaded=function(){return this.pAnnotationsLoaded;};D.prototype.isMetadataLoadingFailed=function(){return this.oMetadata.isFailed();};D.prototype.getServiceAnnotations=function(){var i=this.oAnnotations.getData();return A(i)?null:i;};D.prototype.onAnnotationsFailed=function(i){this.fireAnnotationsFailed(i.getParameters());};D.prototype.onAnnotationsLoaded=function(i){this.fireAnnotationsLoaded(i.getParameters());};D.prototype.addAnnotationUrl=function(i){var j=[].concat(i),k=[],n=[],G=[],H=this;j.forEach(function(I){var J=I.indexOf("$metadata");if(J>=0){I=H._createMetadataUrl(I);k.push(I);}else{n.push(I);}});return this.oMetadata._addUrl(k).then(function(P){return Promise.all(P.map(function(I){G=G.concat(I.entitySets);return H.oAnnotations.addSource({type:"xml",data:I["metadataString"]});}));}).then(function(){return H.oAnnotations.addSource(n);}).then(function(P){return{annotations:H.oAnnotations.getData(),entitySets:G};});};D.prototype.addAnnotationXML=function(X,S){return this.oAnnotations.addSource({type:"xml",data:X});};D.prototype.submitChanges=function(P){var R,G,j,S,k,n,H,I=false,J,K,N=this.bRefreshAfterChange,T,V=this;if(P){G=P.groupId||P.batchGroupId;S=P.success;k=P.error;if(P.merge!==undefined){J=P.merge?"MERGE":"PUT";}}if(G&&!this.mDeferredGroups[G]){L.fatal(this+" submitChanges: \""+G+"\" is not a deferred group!");}K=w({},V.mChangedEntities);this.oMetadata.loaded().then(function(){z(K,function(_,a1){j=V._resolveGroup(_);if(j.groupId===G||!G){R=V._processChange(_,a1,J||V.sDefaultUpdateMethod);R.key=_;T=a1.__metadata&&a1.__metadata.created?a1.__metadata.created:{};var n={abort:function(){R._aborted=true;}};if(j.groupId in V.mDeferredGroups){V._pushToRequestQueue(V.mDeferredRequests,j.groupId,j.changeSetId,R,T.success,T.error,n,N);}}});var W,X,Y,Z,$,i;for(W in V.mDeferredRequests){Y=V.mDeferredRequests[W];for(X in Y.changes){Z=Y.changes[X];for(i=Z.length-1;i>=0;i--){$=Z[i];if($.bRefreshAfterChange===undefined){$.bRefreshAfterChange=N;}}}}H=V._processRequestQueue(V.mDeferredRequests,G,S,k);if(I){n.abort();}if(Array.isArray(H)&&H.length==0&&S){S({},undefined);}});n={abort:function(){if(H){if(Array.isArray(H)){H.forEach(function(n){n.abort();});}else{H.abort();}}else{I=true;}}};return n;};D.prototype._updateChangedEntities=function(i){var j=this,R,k,n;function G(H,I,J){z(I,function(K){var N=J+'/'+K;if(y(I[K])&&y(H[K])){G(H[K],I[K],N);if(A(I[K])){delete I[K];}}else if(v(I[K],H[K])&&!j.isLaundering(N)){delete I[K];if(J===R){k=j.oMetadata._getEntityTypeByPath(R);n=k&&j.oMetadata._getNavPropertyRefInfo(k,K);if(n&&I[n.name]){H[n.name]=I[n.name];delete I[n.name];}}}});}z(i,function(K,H){if(K in j.mChangedEntities){var I=j._getObject('/'+K,null,true);var J=j._getObject('/'+K);w(I,H);R='/'+K;var N=j.removeInternalMetadata(J).deepPath;G(I,J,R);if(A(J)){delete j.mChangedEntities[K];j.abortInternalRequest(j._resolveGroup(K).groupId,{requestKey:K});}else{j.mChangedEntities[K]=J;J.__metadata={deepPath:N};Q.extend(J.__metadata,I.__metadata);}}});};D.prototype.resetChanges=function(P,j){var k=this,n,G={},H,I;if(j){if(P){P.forEach(function(i){k.oMetadata.loaded().then(function(){z(k.mDeferredGroups,function(J){k.abortInternalRequest(J,{path:i.substring(1)});});});});}else{this.oMetadata.loaded().then(function(){z(k.mDeferredGroups,function(i){k.abortInternalRequest(i);});});}}if(P){z(P,function(J,K){k.getEntityByPath(K,null,G);if(G&&G.propertyPath!==undefined){n=G.propertyPath.split("/");var N=G.key;H=k.mChangedEntities[N];for(var i=0;i<n.length-1;i++){if(H.hasOwnProperty(n[i])){H=H[n[i]];}else{H=undefined;}}if(H){delete H[n[n.length-1]];}if(k.mChangedEntities[N]){I=k.mChangedEntities[N].__metadata;delete k.mChangedEntities[N].__metadata;if(A(k.mChangedEntities[N])||!G.propertyPath){k.oMetadata.loaded().then(function(){k.abortInternalRequest(k._resolveGroup(N).groupId,{requestKey:N});});delete k.mChangedEntities[N];sap.ui.getCore().getMessageManager().removeMessages(k.getMessagesByEntity(N,true));}else{k.mChangedEntities[N].__metadata=I;}}else{L.warning(k+" - resetChanges: "+K+" is not changed");}}});}else{z(this.mChangedEntities,function(K,i){k.oMetadata.loaded().then(function(){k.abortInternalRequest(k._resolveGroup(K).groupId,{requestKey:K});});delete k.mChangedEntities[K];sap.ui.getCore().getMessageManager().removeMessages(k.getMessagesByEntity(K,true));});}this.checkUpdate(true);return this.oMetadata.loaded();};D.prototype.setProperty=function(P,V,j,k){var n,G,R,H,I,J,K,N,S,T,W,X,Y={},Z={},$,_,a1,b1=false,c1=this,d1,e1,f1,g1,h1,i1,j1;function k1(m1,n1){z(n1,function(S){if(y(n1[S])&&y(m1[S])){k1(m1[S],n1[S]);if(A(n1[S])){delete n1[S];}}else if(v(n1[S],m1[S])){delete n1[S];}});}K=this.resolve(P,j);j1=this.resolveDeep(P,j);J=this.getEntityByPath(K,null,Z);if(!J){return false;}G=K.substring(K.lastIndexOf("/")+1);S=Z.key;I=this._getObject('/'+S,null,true);n=this._getObject(P,j,true);if(!this.mChangedEntities[S]){X=J.__metadata;J={};J.__metadata=Object.assign({},X);if(Z.propertyPath.length>0){var l1=j1.lastIndexOf(Z.propertyPath);J.__metadata.deepPath=j1.substring(0,l1-1);}this.mChangedEntities[S]=J;}_=this.mChangedEntities[S];N=Z.propertyPath.split("/");for(var i=0;i<N.length-1;i++){if(!_.hasOwnProperty(N[i])){_[N[i]]={};}_=_[N[i]];}b1=I.__metadata.created&&I.__metadata.created.functionImport;_[G]=V;e1=this.oMetadata._getEntityTypeByPath(Z.key);f1=e1&&this.oMetadata._getNavPropertyRefInfo(e1,G);g1=f1&&I[f1.name]&&I[f1.name].__ref;if(g1&&f1.keys.length===1){if(V===null){i1=null;}else{h1={};f1.keys.forEach(function(m1){h1[m1]=J[m1]!==undefined?J[m1]:I[m1];});h1[f1.keys[0]]=V;i1=this.createKey(f1.entitySet,h1);}_[f1.name]={__ref:i1};}if(v(V,n)&&!this.isLaundering('/'+S)&&!b1){X=this.mChangedEntities[S].__metadata;d1=X&&X.created;delete this.mChangedEntities[S].__metadata;if(!d1){k1(I,this.mChangedEntities[S]);}if(A(this.mChangedEntities[S])){delete this.mChangedEntities[S];Y[S]=true;this.checkUpdate(false,k,Y);c1.oMetadata.loaded().then(function(){c1.abortInternalRequest(c1._resolveGroup(S).groupId,{requestKey:S});});return true;}this.mChangedEntities[S].__metadata=X;}T=this._resolveGroup(S);R=this.mRequests;if(T.groupId in this.mDeferredGroups){R=this.mDeferredRequests;H=this._processChange(S,{__metadata:J.__metadata},this.sDefaultUpdateMethod);}else{H=this._processChange(S,this._getObject('/'+S),this.sDefaultUpdateMethod);}H.key=S;$=_.__metadata&&_.__metadata.created?_.__metadata.created:{};a1=this._getRefreshAfterChange(undefined,T.groupId);this.oMetadata.loaded().then(function(){W={abort:function(){H._aborted=true;}};c1._pushToRequestQueue(R,T.groupId,T.changeSetId,H,$.success,$.error,W,a1);c1._processRequestQueueAsync(c1.mRequests);});Y[S]=true;this.checkUpdate(false,k,Y);return true;};D.prototype._isHeaderPrivate=function(H){switch(H.toLowerCase()){case"accept":case"accept-language":case"maxdataserviceversion":case"dataserviceversion":return true;case"x-csrf-token":return this.bTokenHandling;case"sap-contextid-accept":case"sap-contextid":return!this.bDisableSoftStateHeader;default:return false;}};D.prototype.setHeaders=function(H){var i={},j=this;this.mCustomHeaders={};if(H){z(H,function(k,n){if(j._isHeaderPrivate(k)){L.warning(this+" - modifying private header: '"+k+"' not allowed!");}else{i[k]=n;}});this.mCustomHeaders=i;}if(this.oAnnotations){this.oAnnotations.setHeaders(this.mCustomHeaders);}};D.prototype._getHeaders=function(H,i){var j={},k=this;if(H){z(H,function(n,G){if(k._isHeaderPrivate(n)){L.warning(this+" - modifying private header: '"+n+"' not allowed!");}else{j[n]=G;}});}return Q.extend({'sap-cancel-on-close':!!i},this.mCustomHeaders,j,this.oHeaders);};D.prototype.getHeaders=function(){return Q.extend({},this.mCustomHeaders,this.oHeaders);};D.prototype._getHeader=function(H,i){var j;for(j in i){if(j.toLowerCase()===H.toLowerCase()){return i[j];}}return null;};D.prototype.hasPendingChanges=function(i){var j=!A(this.mChangedEntities);if(i){j=j||this.iPendingDeferredRequests>0;}return j;};D.prototype.hasPendingRequests=function(){return this.aPendingRequestHandles.length>0;};D.prototype.getPendingChanges=function(){return w({},this.mChangedEntities);};D.prototype.updateBindings=function(i){this.checkUpdate(i);};D.prototype.setTokenHandlingEnabled=function(T){this.bTokenHandling=T;};D.prototype.setUseBatch=function(i){this.bUseBatch=i;};D.prototype.formatValue=function(V,T){return a.formatValue(V,T);};D.prototype.deleteCreatedEntry=function(i){var j=this,k,G;if(i){var k=i.getPath().substr(1);G=this._resolveGroup(k).groupId;j.oMetadata.loaded().then(function(){j.abortInternalRequest(G,{requestKey:k});});j._removeEntity(k);sap.ui.getCore().getMessageManager().removeMessages(this.getMessagesByEntity(i.getPath(),true));}};D.prototype.createEntry=function(P,j){var S,k,R,n,G,H,K,I,J,N,T,V,W,X,Y,Z={},$,_="POST",a1=this,b1,c1,d1;if(j){Y=j.properties;J=j.groupId||j.batchGroupId;N=j.changeSetId;H=j.context;S=j.success;k=j.error;$=j.created;G=j.eTag;W=j.headers;V=j.urlParameters;T=j.refreshAfterChange;d1=j.canonicalRequest;}d1=this._isCanonicalRequestNeeded(d1);W=W||{};T=this._getRefreshAfterChange(T,J);J=J?J:this.sDefaultChangeGroup;I=a._createUrlParamsArray(V);var e1={abort:function(){if(R){R._aborted=true;}}};if(!P.startsWith("/")&&!H){P="/"+P;}c1=a1._normalizePath(P,H,d1);b1=a1.resolveDeep(P,H);function f1(){var g1;var h1=a1.oMetadata._getEntityTypeByPath(c1);if(!h1){s(h1,"No Metadata for collection "+c1+" found");return undefined;}if(typeof Y==="object"&&!Array.isArray(Y)){Z=w({},Y);}else{for(var i=0;i<h1.property.length;i++){var i1=h1.property[i];var j1=(Y?Y.indexOf(i1.name):-1)>-1;if(!Y||j1){Z[i1.name]=a1._createPropertyValue(i1.type);if(j1){Y.splice(Y.indexOf(i1.name),1);}}}if(Y){s(Y.length===0,"No metadata for the following properties found: "+Y.join(","));}}var k1=a1.oMetadata._getEntitySetByType(h1);var l1="('"+u()+"')";K=k1.name+l1;if(b1&&a1.oMetadata._isCollection(b1)){b1=b1+l1;}Z.__metadata={type:""+h1.entityType,uri:a1.sServiceUrl+'/'+K,created:{key:c1.substring(1),success:S,error:k,headers:W,urlParameters:V,groupId:J,changeSetId:N,eTag:G},deepPath:b1};K=a1._addEntity(w({},Z));a1.mChangedEntities[K]=Z;n=a1._createRequestUrlWithNormalizedPath(c1,I,a1.bUseBatch);R=a1._createRequest(n,b1,_,W,Z,G);g1=a1.getContext("/"+K,b1);g1.bCreated=true;R.key=K;R.created=true;X=a1.mRequests;if(J in a1.mDeferredGroups){X=a1.mDeferredRequests;}a1.oMetadata.loaded().then(function(){a1._pushToRequestQueue(X,J,N,R,S,k,e1,T);a1._processRequestQueueAsync(a1.mRequests);});return g1;}if($){this.oMetadata.loaded().then(function(){$(f1());});}else if(this.oMetadata.isLoaded()){return f1();}else{L.error("Tried to use createEntry without created-callback, before metadata is available!");}};D.prototype._isCreatedEntity=function(i){return!!(i&&i.__metadata&&i.__metadata.created);};D.prototype._createPropertyValue=function(T){var j=this.oMetadata._splitName(T);var n=j.namespace;var k=j.name;if(n.toUpperCase()!=='EDM'){var G={};var H=this.oMetadata._getObjectMetadata("complexType",k,n);s(H,"Complex type "+T+" not found in the metadata !");for(var i=0;i<H.property.length;i++){var P=H.property[i];G[P.name]=this._createPropertyValue(P.type);}return G;}else{return this._getDefaultPropertyValue(k,n);}};D.prototype._getDefaultPropertyValue=function(T,n){return undefined;};D.prototype._normalizePath=function(P,i,j){if(P&&P.indexOf('?')!==-1){P=P.substr(0,P.indexOf('?'));}if(!i&&!P.startsWith("/")){L.fatal(this+" path "+P+" must be absolute if no Context is set");}return this.resolve(P,i,j)||this.resolve(P,i);};D.prototype.getRefreshAfterChange=function(){return this.bRefreshAfterChange;};D.prototype.setRefreshAfterChange=function(R){this.bRefreshAfterChange=R;};D.prototype.isList=function(P,i){P=this.resolve(P,i);return P&&P.substr(P.lastIndexOf("/")).indexOf("(")===-1;};D.prototype._isMetadataPath=function(P){var i=false;if(P&&P.indexOf('/#')>-1){i=true;}return i;};D.prototype.isMetaModelPath=function(P){return P.indexOf("##")==0||P.indexOf("/##")>-1;};D.prototype._request=function(R,S,i,H,j,k){var n;if(this.bDestroyed){return{abort:function(){}};}var G=this;function I(J){return function(){if(G.aPendingRequestHandles){var K=G.aPendingRequestHandles.indexOf(n);if(K>-1){G.aPendingRequestHandles.splice(K,1);}}if(!(n&&n.bSuppressErrorHandlerCall)){J.apply(this,arguments);}};}n=r.request(R,I(S||r.defaultSuccess),I(i||r.defaultError),H,j,k);if(R.async!==false){this.aPendingRequestHandles.push(n);}return n;};D.prototype.destroy=function(){this.bDestroyed=true;M.prototype.destroy.apply(this,arguments);if(this.aPendingRequestHandles){for(var i=this.aPendingRequestHandles.length-1;i>=0;i--){var R=this.aPendingRequestHandles[i];if(R&&R.abort){R.bSuppressErrorHandlerCall=true;R.abort();}}delete this.aPendingRequestHandles;}if(this.sMetadataLoadEvent){clearTimeout(this.sMetadataLoadEvent);}if(this.oMetadataFailedEvent){clearTimeout(this.oMetadataFailedEvent);}if(this.oMetadata){this.oMetadata.detachFailed(this.onMetadataFailed);if(!this.oMetadata.isLoaded()&&!this.oMetadata.hasListeners("loaded")){this.oMetadata.destroy();delete this.oSharedMetaData.oMetadata;}delete this.oMetadata;delete this.pMetadataLoaded;}if(this.oMetaModel){this.oMetaModel.destroy();delete this.oMetaModel;}if(this.oAnnotations){this.oAnnotations.detachSomeLoaded(this.onAnnotationsLoaded);this.oAnnotations.detachAllFailed(this.onAnnotationsFailed);this.oAnnotations.destroy();delete this.oAnnotations;delete this.pAnnotationsLoaded;}};D.prototype.setDeferredBatchGroups=function(G){this.setDeferredGroups(G);};D.prototype.setDeferredGroups=function(G){var i=this;this.mDeferredGroups={};z(G,function(I,j){i.mDeferredGroups[j]=j;});};D.prototype.getDeferredBatchGroups=function(){return this.getDeferredGroups();};D.prototype.getDeferredGroups=function(){return Object.keys(this.mDeferredGroups);};D.prototype.setChangeBatchGroups=function(G){z(G,function(i,j){j.groupId=j.batchGroupId;});this.setChangeGroups(G);};D.prototype.setChangeGroups=function(G){this.mChangeGroups=G;};D.prototype.getChangeBatchGroups=function(){return this.getChangeGroups();};D.prototype.getChangeGroups=function(){return this.mChangeGroups;};D.prototype.setMessageParser=function(P){if(!(P instanceof p)){L.error("Given MessageParser is not of type sap.ui.core.message.MessageParser");return this;}P.setProcessor(this);this.oMessageParser=P;return this;};D.prototype._parseResponse=function(R,i,G,j){try{if(!this.oMessageParser){this.oMessageParser=new q(this.sServiceUrl,this.oMetadata);this.oMessageParser.setProcessor(this);}this.oMessageParser.parse(R,i,G,j,this.bIsMessageScopeSupported);}catch(k){L.error("Error parsing OData messages: "+k);}};D.prototype.callAfterUpdate=function(i){this.aCallAfterUpdate.push(i);};D.prototype.getMetaModel=function(){var i=this;if(!this.oMetaModel){this.oMetaModel=new o(this.oMetadata,this.oAnnotations,{addAnnotationUrl:this.addAnnotationUrl.bind(this),annotationsLoadedPromise:this.pAnnotationsLoaded});this.oMetaModel.loaded().then(function(){i.bMetaModelLoaded=true;i.checkUpdate(false,false,null,true);},function(j){var k=j.message,n;if(!k&&j.xmlDoc&&j.xmlDoc.parseError){k=j.xmlDoc.parseError.reason;n=j.xmlDoc.parseError.srcText;}L.error("error in ODataMetaModel.loaded(): "+k,n,"sap.ui.model.odata.v2.ODataModel");});}return this.oMetaModel;};D.prototype.getOriginalProperty=function(P,i){return this._getObject(P,i,true);};D.prototype.getEntityByPath=function(P,i,j){var R=M.prototype.resolve.call(this,P,i);if(!R){return null;}var k=R.split("/"),n=null,G=[];while(k.length>0){var H=k.join("/"),I=this._getObject(H);if(y(I)){var K=this._getKey(I);if(K){n=I;break;}}G.unshift(k.pop());}if(n){j.propertyPath=G.join("/");j.key=K;return n;}return null;};D.prototype.resolveFromCache=function(P){if(!this.mPathCache){return undefined;}var S,i="",j,n,I;j=this.mPathCache[P]?this.mPathCache[P].canonicalPath:undefined;if(P&&j!==P){S=j||P;if(!j){I=S.lastIndexOf("/");i=S.substr(I);S=S.substr(0,I);}n=this.resolveFromCache(S);if(n&&n!==S){j=n+i;}}return j;};D.prototype.resolve=function(P,i,j){var R=M.prototype.resolve.call(this,P,i);if(R&&!this._isMetadataPath(R)&&j){var k=this.resolveFromCache(R);if(!k){k=this.oMetadata._calculateCanonicalPath(R);k=this.resolveFromCache(k)||k;}this._writePathCache(R,k);return k;}return R;};D.prototype.resolveDeep=function(P,i){var R=M.prototype.resolve.call(this,P,i);if(P&&!P.startsWith("/")){R=i?i.sDeepPath+'/'+P:R;}if(P===""){R=i?i.sDeepPath:R;}return R;};D.prototype.isLaundering=function(P,i){var R=this.resolve(P,i);return(R in this.mLaunderingState)&&this.mLaunderingState[R]>0;};D.prototype.increaseLaundering=function(P,i){if(!i){return;}for(var n in i){if(n==="__metadata"){continue;}var j=i[n];if(y(j)){this.increaseLaundering(P+"/"+n,j);}else{var T=P+"/"+n;if(!(T in this.mLaunderingState)){this.mLaunderingState[T]=0;}this.mLaunderingState[T]++;}}if(!(P in this.mLaunderingState)){this.mLaunderingState[P]=0;}this.mLaunderingState[P]++;};D.prototype.decreaseLaundering=function(P,i){if(!i){return;}for(var n in i){if(n==="__metadata"){continue;}var j=i[n],T=P+"/"+n;if(y(j)){this.decreaseLaundering(T,j);}else{if(T in this.mLaunderingState){this.mLaunderingState[T]--;if(this.mLaunderingState[T]===0){delete this.mLaunderingState[T];}}}}this.mLaunderingState[P]--;if(this.mLaunderingState[P]===0){delete this.mLaunderingState[P];}};D.prototype._getRefreshAfterChange=function(R,G){if(R===undefined&&!(G in this.mDeferredGroups)){return this.bRefreshAfterChange;}return R;};D.prototype.getMessagesByEntity=function(j,k){var n=j,G=[],P;function H(G){var I=[];for(var i=0;i<G.length;i++){if(!k||(k&&!G[i].persistent)){I.push(G[i]);}}return I;}if(!n.startsWith('/')){n='/'+n;}if(this.mMessages){for(P in this.mMessages){if(typeof n=="string"&&n.length>0&&P.startsWith(n)){G=G.concat(H(this.mMessages[P]));}}return G;}return null;};D.prototype._cacheSupported=function(i){var j=/\/~[\w\-]+~[A-Z0-9]?/;var k=[i];if(this.sAnnotationURI){if(!Array.isArray(this.sAnnotationURI)){this.sAnnotationURI=[this.sAnnotationURI];}k=k.concat(this.sAnnotationURI);}k=k.filter(function(n){return n.indexOf("sap-context-token")===-1;});k=k.filter(function(n){return!j.test(n);});return k.length===0?true:false;};D.prototype._getAnnotationCacheKey=function(i){var j;if(this.bUseCache){if(!this.bSkipMetadataAnnotationParsing){j=i+"#annotations";}if(this.sAnnotationURI){if(!Array.isArray(this.sAnnotationURI)){this.sAnnotationURI=[this.sAnnotationURI];}this.sAnnotationURI=this.sAnnotationURI.map(function(k){return k+"#annotations";});j=this.bSkipMetadataAnnotationParsing?this.sAnnotationURI.join("_"):j+"_"+this.sAnnotationURI.join("_");}}return j;};D.prototype.canonicalRequestsEnabled=function(){return this.bCanonicalRequests;};D.prototype._decreaseDeferredRequestCount=function(R){if(R.deferred){this.iPendingDeferredRequests--;}};D.prototype.enableCanonicalRequests=function(i){this.bCanonicalRequests=!!i;};D.prototype.setMessageScope=function(i){this.sMessageScope=i;};D.prototype.messageScopeSupported=function(){var i=this;return this.metadataLoaded().then(function(){return i.bIsMessageScopeSupported;});};D.prototype.getContext=function(P,i){var j=M.prototype.getContext.apply(this,arguments);if(i){j.sDeepPath=i;}else if(!i&&!j.sDeepPath){j.sDeepPath=P;}return j;};D.prototype.hasContext=function(P){return this.mContexts[P];};D.prototype.removeInternalMetadata=function(i){var j,k,K,V;if(i&&i.__metadata){j=i.__metadata.created;k=i.__metadata.deepPath;delete i.__metadata.created;delete i.__metadata.deepPath;}for(K in i){V=i[K];if(Array.isArray(V)){V.forEach(D.prototype.removeInternalMetadata);}else if(typeof V==="object"){D.prototype.removeInternalMetadata(V);}}return{created:j,deepPath:k};};D.prototype._isCanonicalRequestNeeded=function(i){if(i!==undefined){return!!i;}else{return!!this.bCanonicalRequests;}};return D;});
