/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./ValueListType","./lib/_Helper","sap/base/assert","sap/base/Log","sap/base/util/ObjectPath","sap/ui/base/SyncPromise","sap/ui/model/BindingMode","sap/ui/model/ChangeReason","sap/ui/model/ClientListBinding","sap/ui/model/Context","sap/ui/model/ContextBinding","sap/ui/model/MetaModel","sap/ui/model/PropertyBinding","sap/ui/model/odata/OperationMode","sap/ui/model/odata/type/Boolean","sap/ui/model/odata/type/Byte","sap/ui/model/odata/type/Date","sap/ui/model/odata/type/DateTimeOffset","sap/ui/model/odata/type/Decimal","sap/ui/model/odata/type/Double","sap/ui/model/odata/type/Guid","sap/ui/model/odata/type/Int16","sap/ui/model/odata/type/Int32","sap/ui/model/odata/type/Int64","sap/ui/model/odata/type/Raw","sap/ui/model/odata/type/SByte","sap/ui/model/odata/type/Single","sap/ui/model/odata/type/Stream","sap/ui/model/odata/type/String","sap/ui/model/odata/type/TimeOfDay","sap/ui/thirdparty/jquery","sap/ui/thirdparty/URI"],function(V,_,a,L,O,S,B,C,b,c,d,M,P,f,g,h,E,D,k,l,G,I,m,p,R,q,r,s,t,T,Q,U){"use strict";var u,v=new Map(),w=L.Level.DEBUG,x=/^-?\d+$/,y,z,A="sap.ui.model.odata.v4.ODataMetaModel",F,H=/\(.*\)$/,J=new R(),K=new Map(),N={messageChange:true},W={"Edm.Boolean":{Type:g},"Edm.Byte":{Type:h},"Edm.Date":{Type:E},"Edm.DateTimeOffset":{constraints:{"$Precision":"precision"},Type:D},"Edm.Decimal":{constraints:{"@Org.OData.Validation.V1.Minimum/$Decimal":"minimum","@Org.OData.Validation.V1.Minimum@Org.OData.Validation.V1.Exclusive":"minimumExclusive","@Org.OData.Validation.V1.Maximum/$Decimal":"maximum","@Org.OData.Validation.V1.Maximum@Org.OData.Validation.V1.Exclusive":"maximumExclusive","$Precision":"precision","$Scale":"scale"},Type:k},"Edm.Double":{Type:l},"Edm.Guid":{Type:G},"Edm.Int16":{Type:I},"Edm.Int32":{Type:m},"Edm.Int64":{Type:p},"Edm.SByte":{Type:q},"Edm.Single":{Type:r},"Edm.Stream":{Type:s},"Edm.String":{constraints:{"@com.sap.vocabularies.Common.v1.IsDigitSequence":"isDigitSequence","$MaxLength":"maxLength"},Type:t},"Edm.TimeOfDay":{constraints:{"$Precision":"precision"},Type:T}},X={},Y="@com.sap.vocabularies.Common.v1.ValueList",Z="@com.sap.vocabularies.Common.v1.ValueListMapping",$="@com.sap.vocabularies.Common.v1.ValueListReferences",a1="@com.sap.vocabularies.Common.v1.ValueListWithFixedValues",b1=L.Level.WARNING;function c1(o,e,i,j){var n,l1=o.mSchema2MetadataUrl[e];if(!l1){l1=o.mSchema2MetadataUrl[e]={};l1[i]=false;}else if(!(i in l1)){n=Object.keys(l1)[0];if(l1[n]){i1(o,"A schema cannot span more than one document: "+e+" - expected reference URI "+n+" but instead saw "+i,j);}l1[i]=false;}}function d1(o,e,i,j){var n,l1,m1,n1;function o1(p1){var q1,r1;if(!(i in p1)){j(b1,l1," does not contain ",i);return;}j(w,"Including ",i," from ",l1);for(r1 in p1){if(r1[0]!=="$"&&j1(r1)===i){q1=p1[r1];e[r1]=q1;h1(q1,e.$Annotations);}}}if(i in e){return e[i];}n1=o.mSchema2MetadataUrl[i];if(n1){m1=Object.keys(n1);if(m1.length>1){i1(o,"A schema cannot span more than one document: "+"schema is referenced by following URLs: "+m1.join(", "),i);}l1=m1[0];n1[l1]=true;j(w,"Namespace ",i," found in $Include of ",l1);n=o.mMetadataUrl2Promise[l1];if(!n){j(w,"Reading ",l1);n=o.mMetadataUrl2Promise[l1]=S.resolve(o.oRequestor.read(l1)).then(o.validate.bind(o,l1));}n=n.then(o1);if(i in e){return e[i];}e[i]=n;return n;}}function e1(e,i){if(e===i){return"";}if(e.indexOf(i)===0&&e[i.length]==="#"&&e.indexOf("@",i.length)<0){return e.slice(i.length+1);}}function f1(e){var i=e1(e,Z);return i!==undefined?i:e1(e,Y);}function g1(n,o){return o.some(function(e){return n==="$ReturnType"?e.$ReturnType:e.$Parameter&&e.$Parameter.some(function(i){return i.$Name===n;});});}function h1(o,e,i){var j;function n(l1,m1){var n1;for(n1 in m1){if(i||!(n1 in l1)){l1[n1]=m1[n1];}}}for(j in o.$Annotations){if(!(j in e)){e[j]={};}n(e[j],o.$Annotations[j]);}delete o.$Annotations;}function i1(o,e,i){var j=new Error(i+": "+e);o.oModel.reportError(e,A,j);throw j;}function j1(e){return e.slice(0,e.lastIndexOf(".")+1);}y=d.extend("sap.ui.model.odata.v4.ODataMetaContextBinding",{constructor:function(o,e,i){a(!i||i.getModel()===o,"oContext must belong to this model");d.call(this,o,e,i);},initialize:function(){var e=this.oModel.createBindingContext(this.sPath,this.oContext);this.bInitial=false;if(e!==this.oElementContext){this.oElementContext=e;this._fireChange();}},setContext:function(o){a(!o||o.getModel()===this.oModel,"oContext must belong to this model");if(o!==this.oContext){this.oContext=o;if(!this.bInitial){this.initialize();}}}});z=b.extend("sap.ui.model.odata.v4.ODataMetaListBinding",{constructor:function(){b.apply(this,arguments);},_fireFilter:function(){},_fireSort:function(){},checkUpdate:function(e){var i=this.oList.length;this.update();if(e||this.oList.length!==i){this._fireChange({reason:C.Change});}},fetchContexts:function(){var i,e=this.oModel.resolve(this.sPath,this.oContext),j=this;if(!e){return S.resolve([]);}i=e.slice(-1)==="@";if(!i&&!e.endsWith("/")){e+="/";}return this.oModel.fetchObject(e).then(function(o){if(!o){return[];}if(i){e=e.slice(0,-1);}return Object.keys(o).filter(function(n){return n[0]!=="$"&&i!==(n[0]!=="@");}).map(function(n){return new c(j.oModel,e+n);});});},getContexts:function(i,e){this.iCurrentStart=i||0;this.iCurrentLength=Math.min(e||Infinity,this.iLength-this.iCurrentStart,this.oModel.iSizeLimit);return this.getCurrentContexts();},getCurrentContexts:function(){var e=[],i,n=this.iCurrentStart+this.iCurrentLength;for(i=this.iCurrentStart;i<n;i+=1){e.push(this.oList[this.aIndices[i]]);}if(this.oList.dataRequested){e.dataRequested=true;}return e;},setContexts:function(e){this.oList=e;this.updateIndices();this.applyFilter();this.applySort();this.iLength=this._getLength();},update:function(){var e=[],o=this.fetchContexts(),i=this;if(o.isFulfilled()){e=o.getResult();}else{o.then(function(e){i.setContexts(e);i._fireChange({reason:C.Change});});e.dataRequested=true;}this.setContexts(e);}});F=P.extend("sap.ui.model.odata.v4.ODataMetaPropertyBinding",{constructor:function(){P.apply(this,arguments);this.vValue=undefined;},checkUpdate:function(e,i){var o,j=this;function n(l1){if(e||l1!==j.vValue){j.vValue=l1;j._fireChange({reason:i||C.Change});}return l1;}o=this.oModel.fetchObject(this.sPath,this.oContext,this.mParameters).then(n);if(this.mParameters&&this.mParameters.$$valueAsPromise&&o.isPending()){n(o.unwrap());}},getValue:function(){return this.vValue;},setContext:function(o){if(this.oContext!=o){this.oContext=o;if(this.bRelative){this.checkUpdate(false,C.Context);}}},setValue:function(){throw new Error("Unsupported operation: ODataMetaPropertyBinding#setValue");}});var k1=M.extend("sap.ui.model.odata.v4.ODataMetaModel",{constructor:function(o,e,i,j,n){M.call(this);this.aAnnotationUris=i&&!Array.isArray(i)?[i]:i;this.sDefaultBindingMode=B.OneTime;this.mETags={};this.dLastModified=new Date(0);this.oMetadataPromise=null;this.oModel=j;this.mMetadataUrl2Promise={};this.oRequestor=o;this.mSchema2MetadataUrl={};this.mSupportedBindingModes={"OneTime":true,"OneWay":true};this.bSupportReferences=n!==false;this.mUnsupportedFilterOperators={"All":true,"Any":true};this.sUrl=e;}});k1.prototype.$$valueAsPromise=true;k1.prototype._mergeAnnotations=function(e,j){var n=this;this.validate(this.sUrl,e);e.$Annotations={};Object.keys(e).forEach(function(i){if(e[i].$kind==="Schema"){c1(n,i,n.sUrl);h1(e[i],e.$Annotations);}});j.forEach(function(o,i){var l1,m1;n.validate(n.aAnnotationUris[i],o);for(m1 in o){if(m1[0]!=="$"){if(m1 in e){i1(n,"A schema cannot span more than one document: "+m1,n.aAnnotationUris[i]);}l1=o[m1];e[m1]=l1;if(l1.$kind==="Schema"){c1(n,m1,n.aAnnotationUris[i]);h1(l1,e.$Annotations,true);}}}});};k1.prototype.attachEvent=function(e){if(!(e in N)){throw new Error("Unsupported event '"+e+"': v4.ODataMetaModel#attachEvent");}return M.prototype.attachEvent.apply(this,arguments);};k1.prototype.bindContext=function(e,o){return new y(this,e,o);};k1.prototype.bindList=function(e,o,i,j){return new z(this,e,o,i,j);};k1.prototype.bindProperty=function(e,o,i){return new F(this,e,o,i);};k1.prototype.bindTree=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#bindTree");};k1.prototype.fetchCanonicalPath=function(o){return this.fetchUpdateData("",o).then(function(e){if(!e.editUrl){throw new Error(o.getPath()+": No canonical path for transient entity");}if(e.propertyPath){throw new Error("Context "+o.getPath()+" does not point to an entity. It should be "+e.entityPath);}return"/"+e.editUrl;});};k1.prototype.fetchData=function(){return this.fetchEntityContainer().then(function(e){return JSON.parse(JSON.stringify(e));});};k1.prototype.fetchEntityContainer=function(e){var i,j=this;if(!this.oMetadataPromise){i=[S.resolve(this.oRequestor.read(this.sUrl,false,e))];if(this.aAnnotationUris){this.aAnnotationUris.forEach(function(n){i.push(S.resolve(j.oRequestor.read(n,true,e)));});}if(!e){this.oMetadataPromise=S.all(i).then(function(n){var o=n[0];j._mergeAnnotations(o,n.slice(1));return o;});}}return this.oMetadataPromise;};k1.prototype.fetchObject=function(j,n,l1){var m1=this.resolve(j,n),n1=this;if(!m1){L.error("Invalid relative path w/o context",j,A);return S.resolve(null);}return this.fetchEntityContainer().then(function(o1){var p1,q1=false,r1,s1,t1=true,u1,v1,w1,x1=o1;function y1(e,i,o){var H1,I1,J1,K1="";i=i||e;o=o||"";if(p1){u1=J1=x1.filter(B1);if(J1.length!==1){return D1(b1,"Expected a single overload, but found "+J1.length);}if(p1!==X){K1=J1[0].$Parameter[0].$isCollection?"Collection("+p1+")":p1;}I1=w1+"("+K1+")"+o;if(o1.$Annotations[I1]){if(i==="@"){x1=o1.$Annotations[I1];H1=o1.$Annotations[w1+o];if(H1){x1=Object.assign({},H1,x1);}return false;}if(o1.$Annotations[I1][i]){w1=I1;x1=o1;return true;}}}w1+=o;x1=o1;return true;}function z1(i,j){var o,H1=i.indexOf("@",2);if(H1>-1){return D1(b1,"Unsupported path after ",i.slice(0,H1));}i=i.slice(2);o=i[0]==="."?O.get(i.slice(1),l1.scope):l1&&O.get(i,l1.scope)||(i==="requestCurrencyCodes"||i==="requestUnitsOfMeasure"?n1[i].bind(n1):O.get(i));if(typeof o!=="function"){return D1(b1,i," is not a function but: "+o);}try{x1=o(x1,{$$valueAsPromise:l1&&l1.$$valueAsPromise,context:new c(n1,j),schemaChildName:v1,overload:u1.length===1?u1[0]:undefined});}catch(e){D1(b1,"Error calling ",i,": ",e);}return true;}function A1(e,o){var i;if(e==="$ReturnType"){if(o.$ReturnType){x1=o.$ReturnType;return true;}}else if(e&&o.$Parameter){i=o.$Parameter.filter(function(H1){return H1.$Name===e;});if(i.length){x1=i[0];return true;}}return false;}function B1(o){return!o.$IsBound&&p1===X||o.$IsBound&&p1===o.$Parameter[0].$Type;}function C1(o){return o&&typeof o.then==="function";}function D1(i){var e;if(L.isLoggable(i,A)){e=Array.isArray(r1)?r1.join("/"):r1;L[i===w?"debug":"warning"](Array.prototype.slice.call(arguments,1).join("")+(e?" at /"+e:""),m1,A);}if(i===b1){x1=undefined;}return false;}function E1(e,i){var o;function H1(){r1=r1||w1&&i&&w1+"/"+i;return D1.apply(this,arguments);}p1=x1&&x1.$Type;if(n1.bSupportReferences&&!(e in o1)){o=j1(e);x1=d1(n1,o1,o,H1);}if(e in o1){w1=s1=v1=e;x1=u1=o1[v1];if(!C1(x1)){return true;}}if(C1(x1)&&x1.isPending()){return H1(w,"Waiting for ",o);}return H1(b1,"Unknown qualified name ",e);}function F1(e,i,o){var H1,I1;if(e==="$Annotations"){return D1(b1,"Invalid segment: $Annotations");}if(x1!==o1&&typeof x1==="object"&&e in x1){if(e[0]==="$"||x.test(e)){t1=false;}}else{H1=e.indexOf("@@");if(H1<0){if(e.length>11&&e.slice(-11)==="@sapui.name"){H1=e.length-11;}else{H1=e.indexOf("@");}}if(H1>0){if(!F1(e.slice(0,H1),i,o)){return false;}e=e.slice(H1);I1=true;}if(typeof x1==="string"&&!(I1&&(e==="@sapui.name"||e[1]==="@"))&&!G1(x1,o.slice(0,i))){return false;}if(t1){if(e[0]==="$"&&e!=="$ReturnType"||x.test(e)){t1=false;}else{if(I1){}else if(e[0]!=="@"&&e.indexOf(".")>0){return E1(e);}else if(x1&&"$Type"in x1){if(!E1(x1.$Type,"$Type")){return false;}}else if(x1&&"$Action"in x1){if(!E1(x1.$Action,"$Action")){return false;}p1=X;}else if(x1&&"$Function"in x1){if(!E1(x1.$Function,"$Function")){return false;}p1=X;}else if(!i){w1=s1=v1=v1||o1.$EntityContainer;x1=u1=u1||o1[v1];if(Array.isArray(x1)&&A1(e,x1[0])){return true;}if(e&&e[0]!=="@"&&!(e in u1)){return D1(b1,"Unknown child ",e," of ",v1);}}if(Array.isArray(x1)){if(e.startsWith("@$ui5.overload@")){e=e.slice(14);I1=true;}if(I1){if(e[1]!=="@"&&!y1(e)){return false;}}else{if(e!==o[i]&&g1(e,x1)){s1=e;return y1(e,o[i].slice(e.length),"/"+s1);}if(p1){x1=x1.filter(B1);}if(e==="@$ui5.overload"){return true;}if(x1.length!==1){return D1(b1,"Expected a single overload, but found "+x1.length);}if(A1(e,x1[0])){return true;}x1=x1[0].$ReturnType;w1+="/0/$ReturnType";if(x1){if(e==="value"&&!(o1[x1.$Type]&&o1[x1.$Type].value)){s1=undefined;return true;}if(!E1(x1.$Type,"$Type")){return false;}}if(!e){return true;}}}}}if(!e){return i+1>=o.length||D1(b1,"Invalid empty segment");}if(e[0]==="@"){if(e==="@sapui.name"){x1=s1;if(x1===undefined){D1(b1,"Unsupported path before @sapui.name");}else if(i+1<o.length){D1(b1,"Unsupported path after @sapui.name");}return false;}if(e[1]==="@"){if(i+1<o.length){return D1(b1,"Unsupported path after ",e);}return z1(e,[""].concat(o.slice(0,i),o[i].slice(0,H1)).join("/"));}}if(!x1||typeof x1!=="object"){x1=undefined;return!q1&&D1(w,"Invalid segment: ",e);}if(t1&&e[0]==="@"){x1=o1.$Annotations[w1]||{};t1=false;}else if(e==="$"&&i+1<o.length){return D1(b1,"Unsupported path after $");}}if(e!=="@"&&e!=="$"){if(e[0]==="@"){q1=true;}s1=t1||e[0]==="@"?e:undefined;w1=t1?w1+"/"+e:undefined;x1=x1[e];}return true;}function G1(e,i){var o;if(r1){return D1(b1,"Invalid recursion");}r1=i;q1=false;t1=true;x1=o1;o=e.split("/").every(F1);r1=undefined;return o;}if(!G1(m1.slice(1))&&C1(x1)){x1=x1.then(function(){return n1.fetchObject(j,n,l1);});}return x1;});};k1.prototype.fetchUI5Type=function(e){var o=this.getMetaContext(e),i=this;if(e.endsWith("/$count")){u=u||new p();return S.resolve(u);}return this.fetchObject(undefined,o).catch(function(){}).then(function(j){var n=J,l1;if(!j){L.warning("No metadata for path '"+e+"', using "+n.getName(),undefined,A);return n;}if(j["$ui5.type"]){return j["$ui5.type"];}if(j.$isCollection){L.warning("Unsupported collection type, using "+n.getName(),e,A);}else{l1=W[j.$Type];if(l1){n=new l1.Type(undefined,i.getConstraints(j,o.getPath()));}else{L.warning("Unsupported type '"+j.$Type+"', using "+n.getName(),e,A);}}j["$ui5.type"]=n;return n;});};k1.prototype.fetchUpdateData=function(e,o){var j=o.getModel(),n=j.resolve(e,o),l1=this;function m1(i){var n1=new Error(n+": "+i);j.reportError(i,A,n1);throw n1;}return this.fetchObject(this.getMetaPath(n)).then(function(){return l1.fetchEntityContainer();}).then(function(n1){var o1,p1=n1[n1.$EntityContainer],q1,r1,s1,t1,u1,v1,w1,x1=false,y1;function z1(D1){var i=D1.indexOf("(");return i>=0?D1.slice(i):"";}function A1(i){o1.push({path:u1,prefix:i,type:y1});}function B1(D1){var i=D1.indexOf("(");return i>=0?D1.slice(0,i):D1;}function C1(i){if(i.includes("($uid=")){A1(B1(i));}else{o1.push(i);}}w1=n.slice(1).split("/");t1=w1.shift();u1="/"+t1;q1=u1;s1=decodeURIComponent(B1(t1));r1=p1[s1];if(!r1){m1("Not an entity set: "+s1);}y1=n1[r1.$Type];e="";v1="";o1=[];C1(t1);w1.forEach(function(i){var D1,E1;u1+="/"+i;if(x.test(i)){A1(o1.pop());q1+="/"+i;}else{E1=decodeURIComponent(B1(i));v1=_.buildPath(v1,E1);D1=y1[E1];if(!D1){m1("Not a (navigation) property: "+E1);}y1=n1[D1.$Type];if(D1.$kind==="NavigationProperty"){if(r1.$NavigationPropertyBinding&&v1 in r1.$NavigationPropertyBinding){s1=r1.$NavigationPropertyBinding[v1];r1=p1[s1];v1="";o1=[encodeURIComponent(s1)+z1(i)];if(!D1.$isCollection){A1(o1.pop());}}else{C1(i);}q1=u1;e="";}else{e=_.buildPath(e,i);}}});return S.all(o1.map(function(i){if(typeof i==="string"){return i;}return o.fetchValue(i.path).then(function(D1){var E1;if(!D1){m1("No instance to calculate key predicate at "+i.path);}if(_.hasPrivateAnnotation(D1,"transient")){x1=true;return undefined;}E1=_.getPrivateAnnotation(D1,"predicate");if(!E1){m1("No key predicate known at "+i.path);}return i.prefix+E1;},function(D1){m1(D1.message+" at "+i.path);});})).then(function(i){return{editUrl:x1?undefined:i.join("/"),entityPath:q1,propertyPath:e};});});};k1.prototype.fetchValueListMappings=function(o,n,e){var i=this,j=o.getMetaModel();return j.fetchEntityContainer().then(function(l1){var m1,n1=l1.$Annotations,o1={},p1=i===j,q1;q1=Object.keys(n1).filter(function(r1){if(_.namespace(r1)===n){if(typeof e==="string"?r1===e:i.getObject("/"+r1)===e){return true;}if(!p1){throw new Error("Unexpected annotation target '"+r1+"' with namespace of data service in "+o.sServiceUrl);}}return false;});if(!q1.length){throw new Error("No annotation '"+Y.slice(1)+"' in "+o.sServiceUrl);}m1=n1[q1[0]];Object.keys(m1).forEach(function(r1){var s1=f1(r1);if(s1!==undefined){o1[s1]=m1[r1];["CollectionRoot","SearchSupported"].forEach(function(t1){if(t1 in m1[r1]){throw new Error("Property '"+t1+"' is not allowed in annotation '"+r1.slice(1)+"' for target '"+q1[0]+"' in "+o.sServiceUrl);}});}else if(!p1){throw new Error("Unexpected annotation '"+r1.slice(1)+"' for target '"+q1[0]+"' with namespace of data service in "+o.sServiceUrl);}});return o1;});};k1.prototype.fetchValueListType=function(e){var o=this.getMetaContext(e),i=this;return this.fetchObject(undefined,o).then(function(j){var n,l1;if(!j){throw new Error("No metadata for "+e);}n=i.getObject("@",o);if(n[a1]){return V.Fixed;}for(l1 in n){if(e1(l1,$)!==undefined||e1(l1,Z)!==undefined){return V.Standard;}if(e1(l1,Y)!==undefined){return n[l1].SearchSupported===false?V.Fixed:V.Standard;}}return V.None;});};k1.prototype.getAbsoluteServiceUrl=function(e){var i=new U(this.sUrl).absoluteTo(document.baseURI).pathname().toString();return new U(e).absoluteTo(i).filename("").toString();};k1.prototype.getAdapterFactoryModulePath=function(){return"sap/ui/mdc/experimental/adapter/odata/v4/ODataAdapterFactory";};k1.prototype.getConstraints=function(o,e){var i,j,n,l1=W[o.$Type];function m1(n1,o1){if(o1!==undefined){j=j||{};j[n1]=o1;}}if(l1){n=l1.constraints;for(i in n){m1(n[i],i[0]==="@"?this.getObject(e+i):o[i]);}if(o.$Nullable===false){m1("nullable",false);}}return j;};k1.prototype.getData=_.createGetMethod("fetchData");k1.prototype.getETags=function(){return this.mETags;};k1.prototype.getLastModified=function(){return this.dLastModified;};k1.prototype.getMetaContext=function(e){return new c(this,this.getMetaPath(e));};k1.prototype.getMetaPath=function(e){return _.getMetaPath(e);};k1.prototype.getObject=_.createGetMethod("fetchObject");k1.prototype.getOrCreateSharedModel=function(e,i,j){var n,o;e=this.getAbsoluteServiceUrl(e);n=!!j+e;o=K.get(n);if(!o){o=new this.oModel.constructor({autoExpandSelect:j,groupId:i,httpHeaders:this.oModel.getHttpHeaders(),operationMode:f.Server,serviceUrl:e,synchronizationMode:"None"});o.setDefaultBindingMode(B.OneWay);K.set(n,o);}return o;};k1.prototype.getOriginalProperty=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#getOriginalProperty");};k1.prototype.getProperty=k1.prototype.getObject;k1.prototype.getReducedPath=function(e,n){var i,o,l1,m1=n.split("/").length,n1=e.split("/"),o1=this;o=n1.map(function(p1,j){return j<m1||p1[0]==="#"||p1[0]==="@"||x.test(p1)?{}:o1.getObject(o1.getMetaPath(n1.slice(0,j+1).join("/")))||{};});if(!o[n1.length-1].$isCollection){for(i=n1.length-2;i>=m1;i-=1){l1=x.test(n1[i+1])?i+2:i+1;if(l1<n1.length&&o[i].$Partner===n1[l1]&&!o[l1].$isCollection&&o[l1].$Partner===n1[i].replace(H,"")){o.splice(i,l1-i+1);n1.splice(i,l1-i+1);}else if(o[i].$isCollection){break;}}}return n1.join("/");};k1.prototype.getUI5Type=_.createGetMethod("fetchUI5Type",true);k1.prototype.getUnitOrCurrencyPath=function(e){var i=this.getObject("@",this.getMetaContext(e)),o=i&&(i["@Org.OData.Measures.V1.Unit"]||i["@Org.OData.Measures.V1.ISOCurrency"]);return o&&o.$Path;};k1.prototype.getValueListType=_.createGetMethod("fetchValueListType",true);k1.prototype.isList=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#isList");};k1.prototype.refresh=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#refresh");};k1.prototype.requestCodeList=function(e,i,o){var j=this.fetchEntityContainer().getResult(),n=j[j.$EntityContainer],l1=this;if(o&&o.context){if(o.context.getModel()!==this||o.context.getPath()!=="/"){throw new Error("Unsupported context: "+o.context);}}if(i!==undefined&&i!==n){throw new Error("Unsupported raw value: "+i);}return this.requestObject("/@com.sap.vocabularies.CodeList.v1."+e).then(function(m1){var n1,o1,p1,q1,r1;if(!m1){return null;}n1=l1.getAbsoluteServiceUrl(m1.Url)+"#"+m1.CollectionPath;q1=v.get(n1);if(q1){return q1;}p1=l1.getOrCreateSharedModel(m1.Url,"$direct");o1=p1.getMetaModel();r1="/"+m1.CollectionPath+"/";q1=o1.requestObject(r1).then(function(s1){var t1=r1+"@Org.OData.Core.V1.AlternateKeys",u1=o1.getObject(t1),v1,w1=E1(s1.$Key),x1=r1+w1+"@com.sap.vocabularies.Common.v1.",y1,z1,A1=r1+w1+"@com.sap.vocabularies.CodeList.v1.StandardCode/$Path",B1,C1;function D1(F1,G1){var H1=G1.getProperty(w1),I1={Text:G1.getProperty(C1),UnitSpecificScale:G1.getProperty(z1)};if(B1){I1.StandardCode=G1.getProperty(B1);}if(I1.UnitSpecificScale===null){L.error("Ignoring customizing w/o unit-specific scale for code "+H1+" from "+m1.CollectionPath,m1.Url,A);}else{F1[H1]=I1;}return F1;}function E1(F1){var G1;if(F1&&F1.length===1){G1=F1[0];}else{throw new Error("Single key expected: "+r1);}return typeof G1==="string"?G1:G1[Object.keys(G1)[0]];}if(u1){if(u1.length!==1){throw new Error("Single alternative expected: "+t1);}else if(u1[0].Key.length!==1){throw new Error("Single key expected: "+t1+"/0/Key");}w1=u1[0].Key[0].Name.$PropertyPath;}z1=o1.getObject(x1+"UnitSpecificScale/$Path");C1=o1.getObject(x1+"Text/$Path");y1=[w1,z1,C1];B1=o1.getObject(A1);if(B1){y1.push(B1);}v1=p1.bindList("/"+m1.CollectionPath,null,null,null,{$select:y1});return v1.requestContexts(0,Infinity).then(function(F1){if(!F1.length){L.error("Customizing empty for ",p1.sServiceUrl+m1.CollectionPath,A);}return F1.reduce(D1,{});}).finally(function(){v1.destroy();});});v.set(n1,q1);return q1;});};k1.prototype.requestCurrencyCodes=function(e,o){return this.requestCodeList("CurrencyCodes",e,o);};k1.prototype.requestData=_.createRequestMethod("fetchData");k1.prototype.requestObject=_.createRequestMethod("fetchObject");k1.prototype.requestUI5Type=_.createRequestMethod("fetchUI5Type");k1.prototype.requestUnitsOfMeasure=function(e,o){return this.requestCodeList("UnitsOfMeasure",e,o);};k1.prototype.requestValueListInfo=function(e,i){var j=this.getMetaPath(e),n=j.slice(0,j.lastIndexOf("/")),o=n.slice(n.lastIndexOf("/")+1),l1=this;if(!o.includes(".")){o=undefined;}return Promise.all([o||this.requestObject(n+"/@sapui.name"),this.requestObject(j),this.requestObject(j+"@"),this.requestObject(j+a1)]).then(function(m1){var n1=m1[2],o1=m1[3],p1={},q1=_.namespace(m1[0]),r1=m1[1],s1={};function t1(u1,v1,w1,x1){if(o1!==undefined&&"SearchSupported"in u1){throw new Error("Must not set 'SearchSupported' in annotation "+"'com.sap.vocabularies.Common.v1.ValueList' and annotation "+"'com.sap.vocabularies.Common.v1.ValueListWithFixedValues'");}if("CollectionRoot"in u1){x1=l1.getOrCreateSharedModel(u1.CollectionRoot,undefined,i);if(s1[v1]&&s1[v1].$model===x1){p1[v1]=undefined;}}if(p1[v1]){throw new Error("Annotations '"+Y.slice(1)+"' with identical qualifier '"+v1+"' for property "+e+" in "+p1[v1]+" and "+w1);}p1[v1]=w1;u1=Q.extend(true,{$model:x1},u1);delete u1.CollectionRoot;delete u1.SearchSupported;s1[v1]=u1;}if(!r1){throw new Error("No metadata for "+e);}return Promise.all(Object.keys(n1).filter(function(u1){return e1(u1,$)!==undefined;}).map(function(u1){var v1=n1[u1];return Promise.all(v1.map(function(w1){var x1=l1.getOrCreateSharedModel(w1,undefined,i);return l1.fetchValueListMappings(x1,q1,r1.$Name?o+"/"+r1.$Name:r1).then(function(y1){Object.keys(y1).forEach(function(z1){t1(y1[z1],z1,w1,x1);});});}));})).then(function(){var u1;Object.keys(n1).filter(function(v1){return f1(v1)!==undefined;}).forEach(function(v1){t1(n1[v1],f1(v1),l1.sUrl,l1.oModel);});u1=Object.keys(s1);if(!u1.length){throw new Error("No annotation '"+$.slice(1)+"' for "+e);}if(o1){if(u1.length>1){throw new Error("Annotation '"+a1.slice(1)+"' but multiple '"+Y.slice(1)+"' for property "+e);}return{"":s1[u1[0]]};}return s1;});});};k1.prototype.requestValueListType=_.createRequestMethod("fetchValueListType");k1.prototype.resolve=function(e,o){var i,j;if(!e){return o?o.getPath():undefined;}j=e[0];if(j==="/"){return e;}if(!o){return undefined;}if(j==="."){if(e[1]!=="/"){throw new Error("Unsupported relative path: "+e);}e=e.slice(2);}i=o.getPath();return j==="@"||i.slice(-1)==="/"?i+e:i+"/"+e;};k1.prototype.setLegacySyntax=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#setLegacySyntax");};k1.prototype.toString=function(){return A+": "+this.sUrl;};k1.prototype.validate=function(e,j){var i,n,o,l1,m1,n1;if(!this.bSupportReferences){return j;}for(n1 in j.$Reference){m1=j.$Reference[n1];n1=new U(n1).absoluteTo(this.sUrl).toString();if("$IncludeAnnotations"in m1){i1(this,"Unsupported IncludeAnnotations",e);}for(i in m1.$Include){l1=m1.$Include[i];if(l1 in j){i1(this,"A schema cannot span more than one document: "+l1+" - is both included and defined",e);}c1(this,l1,n1,e);}}o=j.$LastModified?new Date(j.$LastModified):null;this.mETags[e]=j.$ETag?j.$ETag:o;n=j.$Date?new Date(j.$Date):new Date();o=o||n;if(this.dLastModified<o){this.dLastModified=o;}delete j.$Date;delete j.$ETag;delete j.$LastModified;return j;};return k1;});
