/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./ODataContextBinding","./ODataListBinding","./ODataMetaModel","./ODataPropertyBinding","./SubmitMode","./lib/_GroupLock","./lib/_Helper","./lib/_MetadataRequestor","./lib/_Parser","./lib/_Requestor","sap/base/assert","sap/base/Log","sap/ui/base/SyncPromise","sap/ui/core/library","sap/ui/core/message/Message","sap/ui/model/BindingMode","sap/ui/model/Context","sap/ui/model/Model","sap/ui/model/odata/OperationMode","sap/ui/thirdparty/jquery","sap/ui/thirdparty/URI"],function(O,a,b,c,S,_,d,e,f,g,h,L,i,j,M,B,k,l,m,q,U){"use strict";var r=/^\w+$/,C="sap.ui.model.odata.v4.ODataModel",E=["$count","$expand","$filter","$levels","$orderby","$search","$select"],n=/^(\$auto(\.\w+)?|\$direct|\w+)$/,o=j.MessageType,p=[undefined,o.Success,o.Information,o.Warning,o.Error],s={messageChange:true,sessionTimeout:true},t={annotationURI:true,autoExpandSelect:true,earlyRequests:true,groupId:true,groupProperties:true,httpHeaders:true,odataVersion:true,operationMode:true,serviceUrl:true,supportReferences:true,synchronizationMode:true,updateGroupId:true},u=["$apply","$count","$expand","$filter","$orderby","$search","$select"],v=/^[ -~]+$/;var w=l.extend("sap.ui.model.odata.v4.ODataModel",{constructor:function(P){var G,x,y=sap.ui.getCore().getConfiguration().getLanguageTag(),z,A,D,F,H=this;l.apply(this);if(!P||P.synchronizationMode!=="None"){throw new Error("Synchronization mode must be 'None'");}z=P.odataVersion||"4.0";this.sODataVersion=z;if(z!=="4.0"&&z!=="2.0"){throw new Error("Unsupported value for parameter odataVersion: "+z);}for(A in P){if(!(A in t)){throw new Error("Unsupported parameter: "+A);}}D=P.serviceUrl;if(!D){throw new Error("Missing service root URL");}F=new U(D);if(F.path()[F.path().length-1]!=="/"){throw new Error("Service root URL must end with '/'");}if(P.operationMode&&P.operationMode!==m.Server){throw new Error("Unsupported operation mode: "+P.operationMode);}this.sOperationMode=P.operationMode;this.mUriParameters=this.buildQueryOptions(F.query(true),false,true);this.sServiceUrl=F.query("").toString();this.sGroupId=P.groupId;if(this.sGroupId===undefined){this.sGroupId="$auto";}if(this.sGroupId!=="$auto"&&this.sGroupId!=="$direct"){throw new Error("Group ID must be '$auto' or '$direct'");}this.checkGroupId(P.updateGroupId,false,"Invalid update group ID: ");this.sUpdateGroupId=P.updateGroupId||this.getGroupId();this.mGroupProperties={};for(G in P.groupProperties){H.checkGroupId(G,true);x=P.groupProperties[G];if(typeof x!=="object"||Object.keys(x).length!==1||!(x.submit in S)){throw new Error("Group '"+G+"' has invalid properties: '"+x+"'");}}this.mGroupProperties=q.extend({"$auto":{submit:S.Auto},"$direct":{submit:S.Direct}},P.groupProperties);if(P.autoExpandSelect!==undefined&&typeof P.autoExpandSelect!=="boolean"){throw new Error("Value for autoExpandSelect must be true or false");}this.bAutoExpandSelect=P.autoExpandSelect===true;this.mHeaders={"Accept-Language":y};this.mMetadataHeaders={"Accept-Language":y};this.oMetaModel=new b(e.create(this.mMetadataHeaders,z,this.mUriParameters),this.sServiceUrl+"$metadata",P.annotationURI,this,P.supportReferences);this.oRequestor=g.create(this.sServiceUrl,{fetchEntityContainer:this.oMetaModel.fetchEntityContainer.bind(this.oMetaModel),fetchMetadata:this.oMetaModel.fetchObject.bind(this.oMetaModel),fireSessionTimeout:function(){H.fireEvent("sessionTimeout");},getGroupProperty:this.getGroupProperty.bind(this),onCreateGroup:function(G){if(H.isAutoGroup(G)){sap.ui.getCore().addPrerenderingTask(H._submitBatch.bind(H,G,true));}},reportBoundMessages:this.reportBoundMessages.bind(this),reportUnboundMessages:this.reportUnboundMessages.bind(this)},this.mHeaders,this.mUriParameters,z);this.changeHttpHeaders(P.httpHeaders);if(P.earlyRequests){this.oMetaModel.fetchEntityContainer(true);this.initializeSecurityToken();}this.aAllBindings=[];this.sDefaultBindingMode=B.TwoWay;this.mSupportedBindingModes={OneTime:true,OneWay:true,TwoWay:true};}});w.prototype._submitBatch=function(G,x){var y=this;return this.oRequestor.submitBatch(G).catch(function(z){y.reportError("$batch failed",C,z);if(!x){throw z;}});};w.prototype.attachEvent=function(x){if(!(x in s)){throw new Error("Unsupported event '"+x+"': v4.ODataModel#attachEvent");}return l.prototype.attachEvent.apply(this,arguments);};w.prototype.attachSessionTimeout=function(F,x){return this.attachEvent("sessionTimeout",F,x);};w.prototype.bindContext=function(P,x,y){return new O(this,P,x,y);};w.prototype.bindingCreated=function(x){this.aAllBindings.push(x);};w.prototype.bindingDestroyed=function(x){var I=this.aAllBindings.indexOf(x);if(I<0){throw new Error("Unknown "+x);}this.aAllBindings.splice(I,1);};w.prototype.bindList=function(P,x,y,F,z){return new a(this,P,x,y,F,z);};w.prototype.bindProperty=function(P,x,y){return new c(this,P,x,y);};w.prototype.bindTree=function(){throw new Error("Unsupported operation: v4.ODataModel#bindTree");};w.prototype.buildQueryOptions=function(P,x,y){var z,T=q.extend(true,{},P);function A(D,F,G){var H,I,J,V=D[F];if(!x||G.indexOf(F)<0){throw new Error("System query option "+F+" is not supported");}if((F==="$expand"||F==="$select")&&typeof V==="string"){V=f.parseSystemQueryOption(F+"="+V)[F];D[F]=V;}if(F==="$expand"){for(J in V){I=V[J];if(I===null||typeof I!=="object"){I=V[J]={};}for(H in I){A(I,H,E);}}}else if(F==="$count"){if(typeof V==="boolean"){if(!V){delete D.$count;}}else{switch(typeof V==="string"&&V.toLowerCase()){case"false":delete D.$count;break;case"true":D.$count=true;break;default:throw new Error("Invalid value for $count: "+V);}}}}if(P){for(z in P){if(z.indexOf("$$")===0){delete T[z];}else if(z[0]==="@"){throw new Error("Parameter "+z+" is not supported");}else if(z[0]==="$"){A(T,z,u);}else if(!y&&z.indexOf("sap-")===0){throw new Error("Custom query option "+z+" is not supported");}}}return T;};w.prototype.changeHttpHeaders=function(H){var x,y,z={},A,K;this.oRequestor.checkHeaderNames(H);for(K in H){y=K.toLowerCase();A=H[K];if(z[y]){throw new Error("Duplicate header "+K);}else if(!(typeof A==="string"&&v.test(A)||A===undefined)){throw new Error("Unsupported value for header '"+K+"': "+A);}else{if(y==="x-csrf-token"){K="X-CSRF-Token";}z[y]={key:K,value:A};}}this.oRequestor.checkForOpenRequests();for(K in this.mHeaders){y=K.toLowerCase();x=z[y];if(x){delete this.mHeaders[K];delete this.mMetadataHeaders[K];if(x.value!==undefined){this.mHeaders[x.key]=x.value;this.mMetadataHeaders[x.key]=x.value;}delete z[y];}}for(K in z){x=z[K];if(x.value!==undefined){this.mHeaders[x.key]=x.value;if(K!=="x-csrf-token"){this.mMetadataHeaders[x.key]=x.value;}}}};w.prototype.checkBatchGroupId=function(G){this.checkGroupId(G);if(this.isDirectGroup(G)){throw new Error("Group ID does not use batch requests: "+G);}};w.prototype.checkGroupId=function(G,A,x){if(!A&&G===undefined||typeof G==="string"&&(A?r:n).test(G)){return;}throw new Error((x||"Invalid group ID: ")+G);};w.prototype.createBindingContext=function(P,x){var D,y,z,R,A;function F(z){var G=z.indexOf("."),H=z.indexOf("/");return G>0&&(H<0||G<H);}if(arguments.length>2){throw new Error("Only the parameters sPath and oContext are supported");}if(x&&x.getBinding){throw new Error("Unsupported type: oContext must be of type sap.ui.model.Context, "+"but was sap.ui.model.odata.v4.Context");}R=this.resolve(P,x);if(R===undefined){throw new Error("Cannot create binding context from relative path '"+P+"' without context");}A=R.indexOf('#');if(A>=0){D=R.slice(0,A);z=R.slice(A+1);if(z[0]==="#"){z=z.slice(1);}else if(D.length>1&&z[0]!=="@"&&F(z)){return new k(this,R);}if(z[0]==="/"){z="."+z;}y=this.oMetaModel.getMetaContext(D);return this.oMetaModel.createBindingContext(z,y);}return new k(this,R);};w.prototype.destroy=function(){this.oMetaModel.destroy();this.oRequestor.destroy();this.mHeaders=undefined;this.mMetadataHeaders=undefined;return l.prototype.destroy.apply(this,arguments);};w.prototype.destroyBindingContext=function(){throw new Error("Unsupported operation: v4.ODataModel#destroyBindingContext");};w.prototype.detachSessionTimeout=function(F,x){return this.detachEvent("sessionTimeout",F,x);};w.prototype.getAllBindings=function(){return this.aAllBindings;};w.prototype.getContext=function(){throw new Error("Unsupported operation: v4.ODataModel#getContext");};w.prototype.getDependentBindings=function(P){return this.aAllBindings.filter(function(x){var y=x.getContext();return x.isRelative()&&(y===P||y&&y.getBinding&&y.getBinding()===P);});};w.prototype.getGroupId=function(){return this.sGroupId;};w.prototype.getGroupProperty=function(G,P){switch(P){case"submit":if(G.startsWith("$auto.")){return S.Auto;}return this.mGroupProperties[G]?this.mGroupProperties[G].submit:S.API;default:throw new Error("Unsupported group property: '"+P+"'");}};w.prototype.getHttpHeaders=function(){var H=Object.assign({},this.mHeaders);delete H["SAP-ContextId"];if(H["X-CSRF-Token"]===null){delete H["X-CSRF-Token"];}return H;};w.prototype.getMetaModel=function(){return this.oMetaModel;};w.prototype.getObject=function(){throw new Error("Unsupported operation: v4.ODataModel#getObject");};w.prototype.getODataVersion=function(){return this.sODataVersion;};w.prototype.getOriginalProperty=function(){throw new Error("Unsupported operation: v4.ODataModel#getOriginalProperty");};w.prototype.getProperty=function(){throw new Error("Unsupported operation: v4.ODataModel#getProperty");};w.prototype.getUpdateGroupId=function(){return this.sUpdateGroupId;};w.prototype.hasPendingChanges=function(G){if(G!==undefined){this.checkBatchGroupId(G);if(this.isAutoGroup(G)&&this.oRequestor.hasPendingChanges("$parked."+G)){return true;}}return this.oRequestor.hasPendingChanges(G);};w.prototype.initializeSecurityToken=function(){this.oRequestor.refreshSecurityToken().catch(function(){});};w.prototype.isAutoGroup=function(G){return this.getGroupProperty(G,"submit")===S.Auto;};w.prototype.isDirectGroup=function(G){return this.getGroupProperty(G,"submit")===S.Direct;};w.prototype.isList=function(){throw new Error("Unsupported operation: v4.ODataModel#isList");};w.prototype.lockGroup=function(G,x,y,z){return this.oRequestor.lockGroup(G,x,y,z);};w.prototype.refresh=function(G){this.checkGroupId(G);this.getBindings().forEach(function(x){if(x.isRoot()){x.refresh(x.isSuspended()?undefined:G);}});};w.prototype.reportBoundMessages=function(R,P,x){var D="/"+R,N=[],y=[],z=this;Object.keys(P).forEach(function(A){P[A].forEach(function(F){var T=d.buildPath(D,A,F.target);N.push(new M({code:F.code,descriptionUrl:F.longtextUrl||undefined,message:F.message,persistent:F.transition,processor:z,target:T,technical:F.technical,technicalDetails:d.createTechnicalDetails(F),type:p[F.numericSeverity]||o.None}));});});(x||[""]).forEach(function(A){var F=d.buildPath(D,A);Object.keys(z.mMessages||{}).forEach(function(G){if(G===F||G.startsWith(F+"/")||G.startsWith(F+"(")){y=y.concat(z.mMessages[G].filter(function(H){return!H.persistent;}));}});});if(N.length||y.length){this.fireMessageChange({newMessages:N,oldMessages:y});}};w.prototype.reportError=function(x,R,y){var z=[],D,A,F=[];function G(H,N,T){var I={code:H.code,message:H.message,numericSeverity:N,technical:T||H.technical,"@$ui5.originalMessage":H};Object.keys(H).forEach(function(P){if(P[0]==='@'){if(P.endsWith(".numericSeverity")){I.numericSeverity=H[P];}else if(P.endsWith(".longtextUrl")&&y.requestUrl&&A){I.longtextUrl=d.makeAbsolute(H[P],y.requestUrl);}}});if(typeof H.target!=="string"){F.push(I);}else if(H.target[0]==="$"||!A){I.message=H.target+": "+I.message;F.push(I);}else{I.target=H.target;I.transition=true;z.push(I);}}if(y.canceled==="noDebugLog"){return;}D=y.stack||y.message;if(D.indexOf(y.message)<0){D=y.message+"\n"+y.stack;}if(y.canceled){L.debug(x,D,R);return;}L.error(x,D,R);if(y.$reported){return;}y.$reported=true;if(y.error){A=y.resourcePath&&y.resourcePath.split("?")[0];G(y.error,4,true);if(y.error.details){y.error.details.forEach(function(H){G(H);});}if(z.length){this.reportBoundMessages(A,{"":z},[]);}}else{G(y,4,true);}this.reportUnboundMessages(A,F);};w.prototype.reportUnboundMessages=function(R,x){var y=this;if(x&&x.length){this.fireMessageChange({newMessages:x.map(function(z){var A=z.longtextUrl;return new M({code:z.code,descriptionUrl:A&&R?d.makeAbsolute(A,y.sServiceUrl+R):undefined,message:z.message,persistent:true,processor:y,target:"",technical:z.technical,technicalDetails:d.createTechnicalDetails(z),type:p[z.numericSeverity]||o.None});})});}};w.prototype.requestCanonicalPath=function(x){h(x.getModel()===this,"oEntityContext must belong to this model");return x.requestCanonicalPath();};w.prototype.resetChanges=function(G){G=G||this.sUpdateGroupId;this.checkBatchGroupId(G);if(this.isAutoGroup(G)){this.oRequestor.cancelChanges("$parked."+G);}this.oRequestor.cancelChanges(G);this.aAllBindings.forEach(function(x){if(G===x.getUpdateGroupId()){x.resetInvalidDataState();}});};w.prototype.resolve=function(P,x){var R;if(P&&P[0]==="/"){R=P;}else if(x){R=x.getPath();if(P){if(R.slice(-1)!=="/"){R+="/";}R+=P;}}if(R&&R!=="/"&&R[R.length-1]==="/"&&R.indexOf("#")<0){R=R.slice(0,R.length-1);}return R;};w.prototype.setLegacySyntax=function(){throw new Error("Unsupported operation: v4.ODataModel#setLegacySyntax");};w.prototype.submitBatch=function(G){var x=this;this.checkBatchGroupId(G);if(this.isAutoGroup(G)){this.oRequestor.relocateAll("$parked."+G,G);}else{this.oRequestor.addChangeSet(G);}return new Promise(function(y){sap.ui.getCore().addPrerenderingTask(function(){y(x._submitBatch(G));});});};w.prototype.toString=function(){return C+": "+this.sServiceUrl;};w.prototype.withUnresolvedBindings=function(x,P){return this.getAllBindings().filter(function(y){return y.isRelative()&&!y.getContext();}).some(function(y){return y[x](P);});};return w;});
