/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/Log","sap/base/util/isEmptyObject","sap/base/util/merge","sap/base/util/uid","sap/ui/thirdparty/URI"],function(L,a,m,u,U){"use strict";var r=/&/g,c="sap.ui.model.odata.v4.lib._Helper",b=/\=/g,d=/%29/g,f=/%28/g,g=/%27/g,h=/#/g,_,j=/\([^/]*|\/-?\d+/g,k=/\+/g,l=/'/g;_={addByPath:function(M,p,i){if(i){if(!M[p]){M[p]=[i];}else if(M[p].indexOf(i)<0){M[p].push(i);}}},addChildrenWithAncestor:function(C,A,e){if(A.length){C.forEach(function(p){var s;if(A.indexOf(p)>=0){e[p]=true;return;}s=p.split("/");s.pop();while(s.length){if(A.indexOf(s.join("/"))>=0){e[p]=true;break;}s.pop();}});}},addToSelect:function(q,s){q.$select=q.$select||[];s.forEach(function(p){if(q.$select.indexOf(p)<0){q.$select.push(p);}});},buildPath:function(){var i,p="",s;for(i=0;i<arguments.length;i+=1){s=arguments[i];if(s||s===0){if(p&&p!=="/"&&s[0]!=="("){p+="/";}p+=s;}}return p;},buildQuery:function(p){var K,q;if(!p){return"";}K=Object.keys(p);if(K.length===0){return"";}q=[];K.forEach(function(s){var v=p[s];if(Array.isArray(v)){v.forEach(function(i){q.push(_.encodePair(s,i));});}else{q.push(_.encodePair(s,v));}});return"?"+q.join("&");},clone:function clone(v){return v===undefined||v===Infinity||v===-Infinity||v!==v?v:JSON.parse(JSON.stringify(v));},createError:function(i,M,R,s){var B=i.responseText,C=i.getResponseHeader("Content-Type"),o=new Error(M+": "+i.status+" "+i.statusText);o.status=i.status;o.statusText=i.statusText;o.requestUrl=R;o.resourcePath=s;if(i.status===0){o.message="Network error";return o;}if(C){C=C.split(";")[0];}if(i.status===412){o.isConcurrentModification=true;}if(C==="application/json"){try{o.error=JSON.parse(B).error;o.message=o.error.message;if(typeof o.message==="object"){o.message=o.error.message.value;}}catch(e){L.warning(e.toString(),B,c);}}else if(C==="text/plain"){o.message=B;}return o;},createGetMethod:function(F,t){return function(){var s=this[F].apply(this,arguments);if(s.isFulfilled()){return s.getResult();}else if(t){if(s.isRejected()){s.caught();throw s.getResult();}else{throw new Error("Result pending");}}};},createRequestMethod:function(F){return function(){return Promise.resolve(this[F].apply(this,arguments));};},createTechnicalDetails:function(M){var C,o=M["@$ui5.originalMessage"]||M,t={};if(!(o instanceof Error)){Object.defineProperty(t,"originalMessage",{enumerable:true,get:function(){if(!C){C=_.publicClone(o);}return C;}});}return t;},deletePrivateAnnotation:function(o,A){var p=o["@$ui5._"];if(p){delete p[A];}},drillDown:function(D,p){return p.reduce(function(D,s){return(D&&s in D)?D[s]:undefined;},D);},encode:function(p,e){var E=encodeURI(p).replace(r,"%26").replace(h,"%23").replace(k,"%2B");if(e){E=E.replace(b,"%3D");}return E;},encodePair:function(K,v){return _.encode(K,true)+"="+_.encode(v,false);},fireChange:function(C,p,v){var e=C[p],i;if(e){for(i=0;i<e.length;i+=1){e[i].onChange(v);}}},fireChanges:function(C,p,v,R){Object.keys(v).forEach(function(P){var s=_.buildPath(p,P),V=v[P];if(V&&typeof V==="object"){_.fireChanges(C,s,V,R);}else{_.fireChange(C,s,R?undefined:V);}});_.fireChange(C,p,R?undefined:v);},formatLiteral:function(v,t){if(v===undefined){throw new Error("Illegal value: undefined");}if(v===null){return"null";}switch(t){case"Edm.Binary":return"binary'"+v+"'";case"Edm.Boolean":case"Edm.Byte":case"Edm.Double":case"Edm.Int16":case"Edm.Int32":case"Edm.SByte":case"Edm.Single":return String(v);case"Edm.Date":case"Edm.DateTimeOffset":case"Edm.Decimal":case"Edm.Guid":case"Edm.Int64":case"Edm.TimeOfDay":return v;case"Edm.Duration":return"duration'"+v+"'";case"Edm.String":return"'"+v.replace(l,"''")+"'";default:throw new Error("Unsupported type: "+t);}},getKeyFilter:function(i,M,t){var F=[],K,e=_.getKeyProperties(i,M,t);if(!e){return undefined;}for(K in e){F.push(K+" eq "+e[K]);}return F.join(" and ");},getKeyPredicate:function(i,M,t){var K=[],e=_.getKeyProperties(i,M,t,true);if(!e){return undefined;}K=Object.keys(e).map(function(A,I,n){var v=encodeURIComponent(e[A]);return n.length===1?v:encodeURIComponent(A)+"="+v;});return"("+K.join(",")+")";},getKeyProperties:function(i,M,t,R){var F,K={};F=t[M].$Key.some(function(v){var s,e,p,P,T,V;if(typeof v==="string"){s=e=v;}else{s=Object.keys(v)[0];e=v[s];if(!R){s=e;}}p=e.split("/");V=_.drillDown(i,p);if(V===undefined){return true;}P=p.pop();T=t[_.buildPath(M,p.join("/"))];V=_.formatLiteral(V,T[P].$Type);K[s]=V;});return F?undefined:K;},getMetaPath:function(p){return p.replace(j,"");},getPrivateAnnotation:function(o,A){var p=o["@$ui5._"];return p&&p[A];},getQueryOptionsForPath:function(q,p){p=p[0]==="("?_.getMetaPath(p).slice(1):_.getMetaPath("/"+p).slice(1);if(p){p.split("/").some(function(s){q=q&&q.$expand&&q.$expand[s];if(!q||q===true){q={};return true;}});}return q||{};},getRelativePath:function(p,B){if(!p.startsWith(B)){return undefined;}p=p.slice(B.length);if(p){if(p[0]==="/"){return p.slice(1);}if(p[0]!=="("){return undefined;}}return p;},hasPrivateAnnotation:function(o,A){var p=o["@$ui5._"];return p?A in p:false;},intersectQueryOptions:function(C,p,F,R,n,P){var e=[],E={},o,s,S={};function q(t,M){var v=M.split("/");return v.every(function(w,i){return i===0&&t||F(R+"/"+v.slice(0,i+1).join("/")).getResult().$kind==="Property";});}if(p.indexOf("")>=0){throw new Error("Unsupported empty navigation property path");}if(C&&C.$select&&C.$select.indexOf("*")<0){_.addChildrenWithAncestor(p,C.$select,S);_.addChildrenWithAncestor(C.$select,p,S);s=Object.keys(S).filter(q.bind(null,true));}else{s=p.filter(q.bind(null,false));}if(C&&C.$expand){e=Object.keys(C.$expand);e.forEach(function(N){var i,M=R+"/"+N,t=_.buildPath(P,N),v={},w;_.addChildrenWithAncestor([N],p,v);if(!a(v)){if(F(M).getResult().$isCollection){n[t]=true;}E[N]=C.$expand[N];return;}w=_.stripPathPrefix(N,p);if(w.length){if(F(M).getResult().$isCollection){throw new Error("Unsupported collection-valued navigation property "+M);}i=_.intersectQueryOptions(C.$expand[N]||{},w,F,R+"/"+N,n,t);if(i){E[N]=i;}}});}if(!s.length&&a(E)){return null;}if(!s.length){s=Object.keys(E).slice(0,1);}o=Object.assign({},C,{$select:s});if(a(E)){delete o.$expand;}else{o.$expand=E;}return o;},isSafeInteger:function(n){if(typeof n!=="number"||!isFinite(n)){return false;}n=Math.abs(n);return n<=9007199254740991&&Math.floor(n)===n;},makeAbsolute:function(s,B){return new U(s).absoluteTo(B).toString().replace(g,"'").replace(f,"(").replace(d,")");},merge:m,mergeQueryOptions:function(q,o,F){var R;function s(p,v){if(v&&(!q||q[p]!==v)){if(!R){R=q?_.clone(q):{};}R[p]=v;}}s("$orderby",o);s("$filter",F);return R||q;},namespace:function(n){var i=n.indexOf("/");if(i>=0){n=n.slice(0,i);}i=n.lastIndexOf(".");return i<0?"":n.slice(0,i);},parseLiteral:function(s,t,p){function e(n){if(!isFinite(n)){throw new Error(p+": Not a valid "+t+" literal: "+s);}return n;}if(s==="null"){return null;}switch(t){case"Edm.Boolean":return s==="true";case"Edm.Byte":case"Edm.Int16":case"Edm.Int32":case"Edm.SByte":return e(parseInt(s));case"Edm.Date":case"Edm.DateTimeOffset":case"Edm.Decimal":case"Edm.Guid":case"Edm.Int64":case"Edm.TimeOfDay":return s;case"Edm.Double":case"Edm.Single":return s==="INF"||s==="-INF"||s==="NaN"?s:e(parseFloat(s));default:throw new Error(p+": Unsupported type: "+t);}},publicClone:function(v){var C=_.clone(v);if(C){delete C["@$ui5._"];}return C;},removeByPath:function(M,p,i){var I=M[p],e;if(I){e=I.indexOf(i);if(e>=0){if(I.length===1){delete M[p];}else{I.splice(e,1);}}}},resolveIfMatchHeader:function(H){var i=H&&H["If-Match"];if(i&&typeof i==="object"){i=i["@odata.etag"];H=Object.assign({},H);if(i===undefined){delete H["If-Match"];}else{H["If-Match"]=i;}}return H;},selectKeyProperties:function(q,t){if(t&&t.$Key){_.addToSelect(q,t.$Key.map(function(K){if(typeof K==="object"){return K[Object.keys(K)[0]];}return K;}));}},setPrivateAnnotation:function(o,A,v){var p=o["@$ui5._"];if(!p){p=o["@$ui5._"]={};}p[A]=v;},stripPathPrefix:function(p,P){var s=p+"/";if(p===""){return P;}return P.filter(function(e){return e===p||e.startsWith(s);}).map(function(e){return e.slice(s.length);});},toArray:function(e){if(e===undefined||e===null){return[];}if(Array.isArray(e)){return e;}return[e];},uid:u,updateExisting:function(C,p,o,n){if(!n){return;}Object.keys(o).forEach(function(P){var s=_.buildPath(p,P),O=o[P],N;if(P in n||P[0]==="#"){N=n[P];if(N&&typeof N==="object"){if(Array.isArray(N)){o[P]=N;}else if(O){_.updateExisting(C,s,O,N);}else{o[P]=N;_.fireChanges(C,s,N,false);}}else if(O&&typeof O==="object"){o[P]=N;_.fireChanges(C,s,O,true);}else{o[P]=N;if(O!==N){_.fireChange(C,s,N);}}}});Object.keys(n).filter(function(P){return P[0]==="#";}).filter(function(A){return!(A in o);}).forEach(function(N){var v=n[N],P=_.buildPath(p,N);o[N]=v;_.fireChanges(C,P,v,false);});},updateSelected:function(C,p,o,n,s){var P;function e(q,S,t){var v=q.split("/");v.every(function(w,I){var x=S[w],T=t[w];if(x&&typeof x==="object"){t[w]=T||{};}else if(T&&typeof T==="object"){t[w]=x;_.fireChanges(C,_.buildPath(p,v.slice(0,I+1).join("/")),T,true);return false;}else if(T!==x){t[w]=x;if(I===v.length-1){_.fireChange(C,_.buildPath(p,q),x);}return false;}else if(!T){return false;}t=t[w];S=x;return true;});}function i(O,q){Object.keys(O).forEach(function(t){var v,V;if(t==="@$ui5._"){return;}v=_.buildPath(q,t);V=O[t];if(V!==null&&typeof V==="object"){i(V,v);}else{s.push(v);}});}if(!s||s.indexOf("*")>=0){s=[];i(n);}else{s=s.concat("@odata.etag");}s.forEach(function(q){e(q,n,o);});P=_.getPrivateAnnotation(n,"predicate");if(P){_.setPrivateAnnotation(o,"predicate",P);}},updateTransientPaths:function(M,t,p){var P;for(P in M){if(P.includes(t)){M[P.replace(t,p)]=M[P];delete M[P];}}},wrapChildQueryOptions:function(B,C,e,F){var E="",i,M=C.split("/"),p,P=B,q={},Q=q;if(C===""){return e;}for(i=0;i<M.length;i+=1){P=_.buildPath(P,M[i]);E=_.buildPath(E,M[i]);p=F(P).getResult();if(p.$kind==="NavigationProperty"){Q.$expand={};Q=Q.$expand[E]=(i===M.length-1)?e:{};_.selectKeyProperties(Q,F(P+"/").getResult());E="";}else if(p.$kind!=="Property"){return undefined;}}if(p.$kind==="Property"){if(Object.keys(e).length>0){L.error("Failed to enhance query options for auto-$expand/$select as the"+" child binding has query options, but its path '"+C+"' points to a structural property",JSON.stringify(e),c);return undefined;}_.addToSelect(Q,[E]);}if("$apply"in e){L.debug("Cannot wrap $apply into $expand: "+C,JSON.stringify(e),c);return undefined;}return q;}};return _;},false);
