/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./_Helper","./_Parser","sap/ui/core/CalendarType","sap/ui/core/format/DateFormat","sap/ui/model/odata/ODataUtils","sap/ui/thirdparty/jquery"],function(_,a,C,D,O,q){"use strict";var r=/^\/Date\((-?\d+)\)\/$/,d,b=/^\/Date\((-?\d+)(?:([-+])(\d\d)(\d\d))?\)\/$/,o,p={},c=/\+/g,e=/^([^(]+)(\(.+\))$/,f=/\//g,g=/^PT(?:(?:(\d+)H)?(?:(\d+)M)?(?:(\d+)(\.\d+)?S)?)$/i,t;function h(){}h.prototype.mFinalHeaders={"Content-Type":"application/json;charset=UTF-8"};h.prototype.mPredefinedPartHeaders={"Accept":"application/json"};h.prototype.mPredefinedRequestHeaders={"Accept":"application/json","MaxDataServiceVersion":"2.0","DataServiceVersion":"2.0","X-CSRF-Token":"Fetch"};h.prototype.mReservedHeaders={accept:true,"content-id":true,"content-transfer-encoding":true,"content-type":true,dataserviceversion:true,"if-match":true,"if-none-match":true,maxdataserviceversion:true,"sap-contextid":true,"x-http-method":true};h.prototype.convertBinary=function(v){return v.replace(c,"-").replace(f,"_");};h.prototype.convertDate=function(v){var i,m=r.exec(v);if(!m){throw new Error("Not a valid Edm.DateTime value '"+v+"'");}i=new Date(parseInt(m[1]));if(Number(m[1]%(24*60*60*1000))!==0){throw new Error("Cannot convert Edm.DateTime value '"+v+"' to Edm.Date because it contains a time of day");}return d.format(i);};h.prototype.convertDateTimeOffset=function(v,P){var m=b.exec(v),s,i,k,l,n="yyyy-MM-dd'T'HH:mm:ss",u=P.$Precision,T;if(!m){throw new Error("Not a valid Edm.DateTimeOffset value '"+v+"'");}T=parseInt(m[1]);i=parseInt(m[3]);k=parseInt(m[4]);if(!m[2]||i===0&&k===0){s="Z";}else{l=m[2]==="-"?-1:1;T+=l*(i*60*60*1000+k*60*1000);s=m[2]+m[3]+":"+m[4];}if(u>0){n+="."+"".padEnd(u,"S");}if(!p[n]){p[n]=D.getDateTimeInstance({calendarType:C.Gregorian,pattern:n,UTC:true});}return p[n].format(new Date(T))+s;};h.prototype.convertDoubleSingle=function(v){switch(v){case"NaN":case"INF":case"-INF":return v;default:return parseFloat(v);}};h.prototype.convertFilter=function(F,m){var i=a.parseFilter(F),k=this;function l(L,u){var M,T=s(u);if(T.$Type!=="Edm.String"){M=_.parseLiteral(L.value,T.$Type,T.path);L.value=k.formatPropertyAsLiteral(M,T);}}function n(N,M){throw new Error("Cannot convert filter to V2, "+M+" at "+N.at+": "+F);}function s(N){var P;if(N.type){return{$Type:N.type};}if(N.id==="PATH"){P=k.oModelInterface.fetchMetadata(m+"/"+N.value).getResult();if(!P){throw new Error("Invalid filter path: "+N.value);}return{path:N.value,$Type:P.$Type,$v2Type:P.$v2Type};}return s(N.parameters[0]);}function v(N){if(N){if(N.id==="VALUE"&&N.ambiguous){n(N,"ambiguous type for the literal");}v(N.left);v(N.right);if(N.parameters){if(N.value==="contains"){N.value="substringof";N.parameters.push(N.parameters.shift());}N.parameters.forEach(v);}if(N.left&&N.right){if(N.left.id==="VALUE"){if(N.right.id==="VALUE"){n(N,"saw literals on both sides of '"+N.id+"'");}l(N.left,N.right);}else if(N.right.id==="VALUE"){l(N.right,N.left);}}}}v(i);return a.buildFilterString(i);};h.prototype.convertKeyPredicate=function(v,P){var E=this.fetchTypeForPath(_.getMetaPath(P)).getResult(),k=a.parseKeyPredicate(decodeURIComponent(v)),i=this;function l(s,V){var m=E[s];if(m.$Type!=="Edm.String"){V=i.formatPropertyAsLiteral(_.parseLiteral(V,m.$Type,P),m);}return encodeURIComponent(V);}if(""in k){return"("+l(E.$Key[0],k[""])+")";}return"("+E.$Key.map(function(s){return encodeURIComponent(s)+"="+l(s,k[s]);}).join(",")+")";};h.prototype.convertResourcePath=function(R){var I=R.indexOf("?"),Q="",s,S=-1,k=this;if(I>0){Q=R.slice(I);R=R.slice(0,I);}s=R.split("/");return s.map(function(l,i){var m=e.exec(l);S+=l.length+1;if(m){l=m[1]+k.convertKeyPredicate(m[2],"/"+R.slice(0,S));}return l;}).join("/")+Q;};h.prototype.convertTimeOfDay=function(v){var i,m=g.exec(v),T;if(!m){throw new Error("Not a valid Edm.Time value '"+v+"'");}T=Date.UTC(1970,0,1,m[1]||0,m[2]||0,m[3]||0);i=new Date(T);return t.format(i)+(m[4]||"");};h.prototype.convertNonPrimitive=function(i){var P,T,s,v,k=this;if(Array.isArray(i.results)){i.results.forEach(function(I){k.convertNonPrimitive(I);});return i.results;}if(!i.__metadata||!i.__metadata.type){throw new Error("Cannot convert structured value without type information in "+"__metadata.type: "+JSON.stringify(i));}s=i.__metadata.type;T=k.getTypeForName(s);delete i.__metadata;for(P in i){v=i[P];if(v===null){continue;}if(typeof v==="object"){if(v.__deferred){delete i[P];}else{i[P]=this.convertNonPrimitive(v);}continue;}i[P]=this.convertPrimitive(v,T[P],s,P);}return i;};h.prototype.convertPrimitive=function(v,P,T,s){switch(P&&P.$Type){case"Edm.Binary":return this.convertBinary(v);case"Edm.Date":return this.convertDate(v);case"Edm.DateTimeOffset":return this.convertDateTimeOffset(v,P);case"Edm.Boolean":case"Edm.Byte":case"Edm.Decimal":case"Edm.Guid":case"Edm.Int16":case"Edm.Int32":case"Edm.Int64":case"Edm.SByte":case"Edm.String":return v;case"Edm.Double":case"Edm.Single":return this.convertDoubleSingle(v);case"Edm.TimeOfDay":return this.convertTimeOfDay(v);default:throw new Error("Type '"+(P&&P.$Type)+"' of property '"+s+"' in type '"+T+"' is unknown; cannot convert value: "+v);}};h.prototype.doCheckVersionHeader=function(G,R,v){var s=G("DataServiceVersion"),i=!s&&G("OData-Version");if(i){throw new Error("Expected 'DataServiceVersion' header with value '1.0' or '2.0' but "+"received 'OData-Version' header with value '"+i+"' in response for "+this.sServiceUrl+R);}if(!s){return;}s=s.split(";")[0];if(s==="1.0"||s==="2.0"){return;}throw new Error("Expected 'DataServiceVersion' header with value '1.0' or '2.0' but "+"received value '"+s+"' in response for "+this.sServiceUrl+R);};h.prototype.doConvertResponse=function(R,m){var i,I,k,P,l,n=this;R=R.d;I=Array.isArray(R.results);if(!I&&!R.__metadata){k=Object.keys(R);i=R[k[0]];if(k.length===1){if(i===null){return{value:null};}else if(typeof i!=="object"){return{value:this.convertPrimitive(i,this.oModelInterface.fetchMetadata(m).getResult(),m,k[0])};}else if(i.__metadata){R=i;}}}if(I&&!R.results.length){P=[];}else if(I&&!R.results[0].__metadata){l=this.oModelInterface.fetchMetadata(m).getResult();P=R.results.map(function(v){return n.convertPrimitive(v,l,m,"");});}else{P=this.convertNonPrimitive(R);}if(I){P={value:P};if(R.__count){P["@odata.count"]=R.__count;}if(R.__next){P["@odata.nextLink"]=R.__next;}}return P;};h.prototype.doConvertSystemQueryOptions=function(m,Q,R,i,s){var S,k={},l=this;function n(v,E){if(!Array.isArray(v)){v=v.split(",");}v.forEach(function(w){var I=w.indexOf("/");if(I>=0&&w.indexOf(".")<0){w=w.slice(0,I);}k[_.buildPath(E,w)]=true;});}function u(E,v,P){if(!v||typeof v!=="object"){throw new Error("$expand must be a valid object");}Object.keys(v).forEach(function(w){var A=_.buildPath(P,w),x=v[w];E.push(A);if(typeof x==="object"){Object.keys(x).forEach(function(y){switch(y){case"$expand":u(E,x.$expand,A);break;case"$select":n(x.$select,A);break;default:throw new Error("Unsupported query option in $expand: "+y);}});}if(!x.$select){k[A+"/*"]=true;}});return E;}Object.keys(Q).forEach(function(N){var I=N[0]==='$',v=Q[N];if(i&&I){return;}switch(N){case"$count":N="$inlinecount";v=v?"allpages":"none";break;case"$expand":v=u([],v,"");v=(s?v.sort():v).join(",");break;case"$orderby":break;case"$select":n(v);return;case"$filter":v=l.convertFilter(v,m);break;default:if(I){throw new Error("Unsupported system query option: "+N);}}R(N,v);});S=Object.keys(k);if(S.length>0){if(!Q.$select){S.push("*");}R("$select",(s?S.sort():S).join(","));}};h.prototype.formatPropertyAsLiteral=function(v,P){function i(k,V){var l=k.parse(V);if(!l){throw new Error("Not a valid "+P.$Type+" value: "+V);}return l;}if(v===null){return"null";}switch(P.$Type){case"Edm.Boolean":case"Edm.Byte":case"Edm.Decimal":case"Edm.Double":case"Edm.Guid":case"Edm.Int16":case"Edm.Int32":case"Edm.Int64":case"Edm.SByte":case"Edm.Single":case"Edm.String":break;case"Edm.Date":v=i(d,v);break;case"Edm.DateTimeOffset":v=i(o,v);break;case"Edm.TimeOfDay":v={__edmType:"Edm.Time",ms:i(t,v).getTime()};break;default:throw new Error("Type '"+P.$Type+"' in the key predicate is not supported");}return O.formatValue(v,P.$v2Type||P.$Type);};h.prototype.getPathAndAddQueryOptions=function(P,i,m,Q,E){var n,T,k=this;P=P.slice(1,-5);if(i.$IsBound){P=P.slice(P.lastIndexOf(".")+1);if(typeof E==="function"){E=E();}T=this.getTypeForName(i.$Parameter[0].$Type);T.$Key.forEach(function(n){Q[n]=k.formatPropertyAsLiteral(E[n],T[n]);});}if(i.$Parameter){i.$Parameter.forEach(function(l){n=l.$Name;if(n in m){if(l.$isCollection){throw new Error("Unsupported collection-valued parameter: "+n);}Q[n]=k.formatPropertyAsLiteral(m[n],l);delete m[n];}});}for(n in m){delete m[n];}if(i.$v2HttpMethod){m["X-HTTP-Method"]=i.$v2HttpMethod;}return P;};h.prototype.getTypeForName=function(n){var T;this.mTypesByName=this.mTypesByName||{};T=this.mTypesByName[n];if(!T){T=this.mTypesByName[n]=this.oModelInterface.fetchMetadata("/"+n).getResult();}return T;};h.prototype.isActionBodyOptional=function(){return true;};h.prototype.isChangeSetOptional=function(){return false;};h.prototype.ready=function(){return this.oModelInterface.fetchEntityContainer().then(function(){});};function j(R){q.extend(R,h.prototype);R.oModelInterface.reportBoundMessages=function(){};R.oModelInterface.reportUnboundMessages=function(){};}j._setDateTimeFormatter=function(){d=D.getDateInstance({calendarType:C.Gregorian,pattern:"yyyy-MM-dd",UTC:true});o=D.getDateTimeInstance({calendarType:C.Gregorian,pattern:"yyyy-MM-dd'T'HH:mm:ss.SSSZ"});t=D.getTimeInstance({calendarType:C.Gregorian,pattern:"HH:mm:ss",UTC:true});};j._setDateTimeFormatter();return j;},false);
