/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/model/SimpleType','sap/ui/model/FormatException','sap/ui/model/ParseException','sap/ui/model/ValidateException',"sap/ui/thirdparty/jquery"],function(S,F,P,V,q){"use strict";var a=S.extend("sap.ui.model.type.String",{constructor:function(){S.apply(this,arguments);this.sName="String";if(this.oConstraints.search&&typeof this.oConstraints.search=="string"){this.oConstraints.search=new RegExp(this.oConstraints.search);}}});a.prototype.formatValue=function(v,i){if(v==undefined||v==null){return null;}switch(this.getPrimitiveType(i)){case"string":case"any":return v;case"int":var r=parseInt(v);if(isNaN(r)){throw new F(v+" is not a valid int value");}return r;case"float":var R=parseFloat(v);if(isNaN(R)){throw new F(v+" is not a valid float value");}return R;case"boolean":if(v.toLowerCase()=="true"||v=="X"){return true;}if(v.toLowerCase()=="false"||v==""){return false;}throw new F(v+" is not a valid boolean value");default:throw new F("Don't know how to format String to "+i);}};a.prototype.parseValue=function(v,i){switch(this.getPrimitiveType(i)){case"string":return v;case"boolean":case"int":case"float":return v.toString();default:throw new P("Don't know how to parse String from "+i);}};a.prototype.validateValue=function(v){if(this.oConstraints){var b=sap.ui.getCore().getLibraryResourceBundle(),c=[],m=[];q.each(this.oConstraints,function(n,C){switch(n){case"maxLength":if(v.length>C){c.push("maxLength");m.push(b.getText("String.MaxLength",[C]));}break;case"minLength":if(v.length<C){c.push("minLength");m.push(b.getText("String.MinLength",[C]));}break;case"startsWith":if(!(typeof C=="string"&&C.length>0&&v.startsWith(C))){c.push("startsWith");m.push(b.getText("String.StartsWith",[C]));}break;case"startsWithIgnoreCase":if(!((typeof C=="string"&&C!=""?v.toLowerCase().startsWith(C.toLowerCase()):false))){c.push("startsWithIgnoreCase");m.push(b.getText("String.StartsWith",[C]));}break;case"endsWith":if(!(typeof C=="string"&&C.length>0&&v.endsWith(C))){c.push("endsWith");m.push(b.getText("String.EndsWith",[C]));}break;case"endsWithIgnoreCase":if(!((typeof C=="string"&&C!=""?v.toLowerCase().endsWith(C.toLowerCase()):false))){c.push("endsWithIgnoreCase");m.push(b.getText("String.EndsWith",[C]));}break;case"contains":if(v.indexOf(C)==-1){c.push("contains");m.push(b.getText("String.Contains",[C]));}break;case"equals":if(v!=C){c.push("equals");m.push(b.getText("String.Equals",[C]));}break;case"search":if(v.search(C)==-1){c.push("search");m.push(b.getText("String.Search",[C]));}break;}});if(c.length>0){throw new V(this.combineMessages(m),c);}}};return a;});
