//@ui5-bundle sap/ui/rta/library-preload.js
/*
 * ! OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/rta/api/startKeyUserAdaptation',["sap/ui/rta/RuntimeAuthoring","sap/ui/base/ManagedObject","sap/ui/fl/write/api/FeaturesAPI","sap/base/Log"],function(R,M,F,L){"use strict";return function(p){if(!(p.rootControl instanceof M)){return Promise.reject(new Error("An invalid root control was passed"));}return F.isKeyUser().then(function(i){if(!i){throw new Error("Key user rights are not available");}Object.assign(p,{flexSettings:{developerMode:false,layer:"CUSTOMER"},validateAppVersion:true});var r=new R(p);r.attachEvent('stop',function(){r.destroy();});return r.start();}).catch(function(e){L.error("UI Adaptation could not be started",e.message);throw e;});};});
/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/rta/Client',["sap/ui/base/ManagedObject","sap/ui/core/postmessage/Bus","sap/base/util/uid","sap/base/util/merge","sap/ui/rta/util/ServiceEventBus","sap/ui/thirdparty/URI"],function(M,P,u,m,S,U){"use strict";var C='sap.ui.rta.service.receiver';var a='pending';var b='accepted';var c='declined';
var d=M.extend("sap.ui.rta.Client",{
metadata:{library:"sap.ui.rta",properties:{window:"object",origin:"string"}},
_bInit:false,
constructor:function(){M.apply(this,arguments);if(!this.getWindow()){throw new TypeError("sap.ui.rta.Client: window parameter is required");}if(!this.getOrigin()){throw new TypeError("sap.ui.rta.Client: origin parameter is required");}this._oPostMessageBus=P.getInstance();this._sStatus=a;this._mPendingRequests={};this._aRequestQueue=[];this._oServiceEventBus=null;this._mEventHandlerIds={};this._oPostMessageBus.subscribeOnce(C,P.event.READY,function(e){if(!this._isValidMessage(e)){return;}this._oPostMessageBus.subscribeOnce(C,P.event.ACCEPTED,function(e){if(!this._isValidMessage(e)){return;}this._sStatus=b;var r=this._aRequestQueue.slice();this._aRequestQueue=[];r.forEach(this._sendRequest,this);this._oPostMessageBus.subscribe(C,'getService',this._receiverMethods,this);this._oPostMessageBus.subscribe(C,'callMethod',this._receiverMethods,this);this._oPostMessageBus.subscribe(C,'subscribe',this._receiverMethods,this);this._oPostMessageBus.subscribe(C,'unsubscribe',this._receiverMethods,this);this._oPostMessageBus.subscribe(C,'event',this._receiverEvents,this);},this);this._oPostMessageBus.subscribeOnce(C,P.event.DECLINED,function(e){if(!this._isValidMessage(e)){return;}this._sStatus=c;var r=this._aRequestQueue.slice();this._aRequestQueue=[];r.forEach(function(R){R.reject(new Error('sap.ui.rta.Client.getService(): connection to RuntimeAuthoring instance has been refused'));});},this);this._oPostMessageBus.publish({target:this.getWindow(),origin:this.getOrigin(),channelId:C,eventId:P.event.CONNECT,data:sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta").getText("SERVICE_NAME")});},this);this._bInit=true;}
});
d.prototype.destroy=function(){this._oPostMessageBus.unsubscribe(C,'getService',this._receiverMethods,this);this._oPostMessageBus.unsubscribe(C,'callMethod',this._receiverMethods,this);this._oPostMessageBus.unsubscribe(C,'subscribe',this._receiverMethods,this);this._oPostMessageBus.unsubscribe(C,'unsubscribe',this._receiverMethods,this);this._oPostMessageBus.unsubscribe(C,'event',this._receiverEvents,this);M.prototype.destroy.apply(this,arguments);};
d.prototype.getService=function(s){if(typeof s!=="string"){throw new TypeError('sap.ui.rta.Client.getService(): invalid service name specified');}return this._sendRequest(this._createRequest({target:this.getWindow(),origin:this.getOrigin(),channelId:C,eventId:'getService',data:{arguments:[s]}}));};
d.prototype._createRequest=function(p){var r=u();var R={id:r,request:{target:p.target,origin:p.origin,channelId:C,eventId:p.eventId,data:{id:r,type:'request',body:p.data}}};R.promise=new Promise(function(f,e){R.resolve=f;R.reject=e;});return R;};
d.prototype._sendRequest=function(r){switch(this._sStatus){case b:this._mPendingRequests[r.id]=r;this._oPostMessageBus.publish(r.request);break;case a:this._aRequestQueue.push(r);break;case c:r.reject(new Error('sap.ui.rta.Client.getService(): connection to RuntimeAuthoring instance has been refused'));break;}return r.promise;};
d.prototype._isValidMessage=function(e){return this.getWindow()===e.source&&this.getOrigin()===e.origin;};
d.prototype._receiverMethods=function(e){if(!this._isValidMessage(e)){return;}var D=e.data;if(D.type!=='response'){return;}var r=this._mPendingRequests[D.id];switch(e.eventId){case'getService':var s=r.request.data.body.arguments[0];var f=D.body.methods||[];var E=D.body.events;var g=m(f.reduce(function(R,h){R[h]=function(){return this._sendRequest(this._createRequest({target:e.source,origin:e.origin,channelId:C,eventId:'callMethod',data:{service:s,method:h,arguments:Array.prototype.slice.call(arguments)}}));}.bind(this);return R;}.bind(this),{}),D.body.properties);if(Array.isArray(E)&&E.length>0){if(!this._oServiceEventBus){this._oServiceEventBus=new S();}m(g,{attachEvent:function(h,i,o){if(typeof(h)!=="string"||!h){throw new TypeError("sap.ui.rta.Client: sEventName must be a non-empty string when calling attachEvent() for a service");}if(typeof i!=="function"){throw new TypeError("sap.ui.rta.Client: fnFunction must be a function when calling attachEvent() for a service");}var j=this._oServiceEventBus.getChannel(s);var k=!j||!j.hasListeners(h);this._oServiceEventBus.subscribe(s,h,i,o);if(k){this._sendRequest(this._createRequest({target:e.source,origin:e.origin,channelId:C,eventId:'subscribe',data:{service:s,event:h}})).then(function(R){this._mEventHandlerIds[s+','+h]=R.id;this._checkIfEventAlive(s,h);}.bind(this));}}.bind(this),detachEvent:function(h,i,o){if(typeof(h)!=="string"||!h){throw new TypeError("sap.ui.rta.Client: sEventName must be a non-empty string when calling detachEvent() for a service");}if(typeof i!=="function"){throw new TypeError("sap.ui.rta.Client: fnFunction must be a function when calling detachEvent() for a service");}this._oServiceEventBus.unsubscribe(s,h,i,o);this._checkIfEventAlive(s,h);}.bind(this),attachEventOnce:function(h,i,o){function O(){g.detachEvent(h,O);i.apply(o,arguments);}g.attachEvent(h,O);}});}r.resolve(g);delete this._mPendingRequests[D.id];break;case'callMethod':if(D.status==='success'){r.resolve(D.body);}else{r.reject(D.body);}delete this._mPendingRequests[D.id];break;case'subscribe':case'unsubscribe':r.resolve(D.body);delete this._mPendingRequests[D.id];break;}};
d.prototype._checkIfEventAlive=function(s,e){var E=this._oServiceEventBus.getChannel(s);var f=this._mEventHandlerIds[s+','+e];if((!E||!E.hasListeners(e))&&f){this._sendRequest(this._createRequest({target:this.getWindow(),origin:this.getOrigin(),channelId:C,eventId:'unsubscribe',data:{service:s,event:e,id:f}}));}};
d.prototype._receiverEvents=function(e){if(!this._isValidMessage(e)){return;}var r=e.data.body;this._oServiceEventBus.publish(r.service,r.event,r.data);};
d.prototype.setWindow=function(v){if(this._bInit){throw new TypeError("sap.ui.rta.Client: Window parameter cannot be changed at runtime; recreate instance of the Client.");}if(!v){throw new TypeError("sap.ui.rta.Client: Window parameter is required");}if(v===window){throw new TypeError("sap.ui.rta.Client: Window object has to be different from the one where Client is running");}this.setProperty('window',v);return this;};
d.prototype.setOrigin=function(v){if(this._bInit){throw new TypeError("sap.ui.rta.Client: Cannot change origin parameter at runtime; recreate instance of the Client.");}if(!v){throw new TypeError("sap.ui.rta.Client: Origin parameter is required");}if(typeof v!=='string'){throw new TypeError("sap.ui.rta.Client: Origin parameter has to be a string");}if(new U(v).origin()!==v){throw new TypeError("sap.ui.rta.Client: Origin string is invalid");}this.setProperty('origin',v);return this;};
return d;});
sap.ui.predefine('sap/ui/rta/RuntimeAuthoring',["sap/ui/thirdparty/jquery","sap/ui/base/ManagedObject","sap/ui/rta/toolbar/Fiori","sap/ui/rta/toolbar/Standalone","sap/ui/rta/toolbar/Personalization","sap/ui/dt/DesignTime","sap/ui/dt/Overlay","sap/ui/rta/command/Stack","sap/ui/rta/command/CommandFactory","sap/ui/rta/command/LREPSerializer","sap/ui/rta/plugin/Rename","sap/ui/rta/plugin/DragDrop","sap/ui/rta/plugin/RTAElementMover","sap/ui/rta/plugin/CutPaste","sap/ui/rta/plugin/Remove","sap/ui/rta/plugin/CreateContainer","sap/ui/rta/plugin/additionalElements/AdditionalElementsPlugin","sap/ui/rta/plugin/additionalElements/AddElementsDialog","sap/ui/rta/plugin/additionalElements/AdditionalElementsAnalyzer","sap/ui/rta/plugin/Combine","sap/ui/rta/plugin/Split","sap/ui/rta/plugin/Selection","sap/ui/rta/plugin/Settings","sap/ui/rta/plugin/Stretch","sap/ui/rta/plugin/ControlVariant","sap/ui/dt/plugin/ToolHooks","sap/ui/dt/plugin/ContextMenu","sap/ui/dt/plugin/TabHandling","sap/ui/rta/Utils","sap/ui/dt/Util","sap/ui/dt/ElementUtil","sap/ui/fl/Utils","sap/ui/fl/LayerUtils","sap/ui/fl/write/api/FeaturesAPI","sap/ui/fl/write/api/PersistenceWriteAPI","sap/m/MessageBox","sap/m/MessageToast","sap/ui/rta/util/PopupManager","sap/ui/core/BusyIndicator","sap/ui/dt/DOMUtil","sap/ui/rta/util/StylesLoader","sap/ui/rta/appVariant/Feature","sap/ui/Device","sap/ui/rta/service/index","sap/ui/rta/util/ServiceEventBus","sap/ui/dt/OverlayRegistry","sap/base/strings/capitalize","sap/base/util/UriParameters","sap/ui/performance/Measurement","sap/base/Log","sap/ui/events/KeyCodes","sap/ui/rta/util/validateFlexEnabled"],function(q,M,F,S,P,D,O,C,a,L,R,b,c,d,e,f,A,g,h,i,j,k,l,m,n,T,o,p,U,r,E,s,t,u,v,w,x,y,B,z,G,H,I,J,K,N,Q,V,W,X,Y,Z){"use strict";var $="STARTING";var _="STARTED";var a1="STOPPED";var b1="FAILED";var c1="SERVICE_STARTING";var d1="SERVICE_STARTED";var e1="SERVICE_FAILED";
var f1=M.extend("sap.ui.rta.RuntimeAuthoring",{
metadata:{library:"sap.ui.rta",associations:{rootControl:{type:"sap.ui.base.ManagedObject"}},properties:{customFieldUrl:"string",showCreateCustomField:"boolean",showToolbars:{type:"boolean",defaultValue:true},triggeredFromDialog:{type:"boolean",defaultValue:false},showWindowUnloadDialog:{type:"boolean",defaultValue:true},commandStack:{type:"any"},plugins:{type:"any",defaultValue:{}},flexSettings:{type:"object",defaultValue:{layer:"CUSTOMER",developerMode:true}},mode:{type:"string",defaultValue:"adaptation"},metadataScope:{type:"string",defaultValue:"default"},validateAppVersion:{type:"boolean",defaultValue:false}},events:{start:{parameters:{editablePluginsCount:{type:"int"}}},stop:{},failed:{},selectionChange:{parameters:{selection:{type:"sap.ui.dt.Overlay[]"}}},modeChanged:{},undoRedoStackModified:{}}},
_sAppTitle:null,
_dependents:null,
_sStatus:a1,
constructor:function(){M.apply(this,arguments);this._dependents={};this._mServices={};this._mCustomServicesDictinary={};this.iEditableOverlaysCount=0;this.addDependent(new y(),'popupManager');if(this.getShowToolbars()){this.getPopupManager().attachOpen(this.onPopupOpen,this);this.getPopupManager().attachClose(this.onPopupClose,this);}if(window.parent!==window){this.startService('receiver');}if(sap.ui.version.includes("-SNAPSHOT")){this.attachStart(Z.bind(null,this));}},
_RESTART:{NOT_NEEDED:"no restart",VIA_HASH:"without max layer",RELOAD_PAGE:"reload"}
});
f1.prototype.getDefaultPlugins=function(){if(!this._mDefaultPlugins){var j1=new a({flexSettings:this.getFlexSettings()});this._mDefaultPlugins={};this._mDefaultPlugins["selection"]=new k({commandFactory:j1,multiSelectionRequiredPlugins:[i.getMetadata().getName(),e.getMetadata().getName()],elementEditableChange:this._onElementEditableChange.bind(this)});var k1=new c({commandFactory:j1});this._mDefaultPlugins["dragDrop"]=new b({elementMover:k1,commandFactory:j1,dragStarted:this._handleStopCutPaste.bind(this)});this._mDefaultPlugins["rename"]=new R({commandFactory:j1,editable:this._handleStopCutPaste.bind(this)});this._mDefaultPlugins["additionalElements"]=new A({commandFactory:j1,analyzer:h,dialog:new g()});this._mDefaultPlugins["createContainer"]=new f({commandFactory:j1});this._mDefaultPlugins["remove"]=new e({commandFactory:j1});this._mDefaultPlugins["cutPaste"]=new d({elementMover:k1,commandFactory:j1});this._mDefaultPlugins["settings"]=new l({commandFactory:j1});this._mDefaultPlugins["combine"]=new i({commandFactory:j1});this._mDefaultPlugins["split"]=new j({commandFactory:j1});this._mDefaultPlugins["contextMenu"]=new o();this._mDefaultPlugins["tabHandling"]=new p();this._mDefaultPlugins["stretch"]=new m();this._mDefaultPlugins["controlVariant"]=new n({commandFactory:j1});this._mDefaultPlugins["toolHooks"]=new T();}return q.extend({},this._mDefaultPlugins);};
f1.prototype.addDependent=function(j1,k1,l1){l1=typeof l1==='undefined'?true:!!l1;if(!(k1 in this._dependents)){if(k1&&l1){this['get'+Q(k1,0)]=this.getDependent.bind(this,k1);}this._dependents[k1||j1.getId()]=j1;}else{throw r.createError("RuntimeAuthoring#addDependent",r.printf("Can't add dependency with same key '{0}'",k1),"sap.ui.rta");}};
f1.prototype.getDependent=function(j1){return this._dependents[j1];};
f1.prototype.getDependents=function(){return this._dependents;};
f1.prototype.removeDependent=function(j1){delete this._dependents[j1];};
f1.prototype._destroyDefaultPlugins=function(j1){for(var k1 in this._mDefaultPlugins){var l1=this._mDefaultPlugins[k1];if(l1&&!l1.bIsDestroyed){if(!j1||j1[k1]!==l1){l1.destroy();}}}if(!j1){this._mDefaultPlugins=null;}};
f1.prototype.onPopupOpen=function(j1){if(j1.getParameters()instanceof sap.m.Dialog&&this.getToolbar()instanceof F){this.getToolbar().setColor("contrast");}this.getToolbar().bringToFront();};
f1.prototype.onPopupClose=function(j1){if(j1.getParameters()instanceof sap.m.Dialog){this.getToolbar().setColor();}};
f1.prototype.setPlugins=function(j1){if(this._oDesignTime){throw new Error('Cannot replace plugins: runtime authoring already started');}this.setProperty("plugins",j1);};
f1.prototype.setFlexSettings=function(j1){var k1=V.fromQuery(window.location.search);var l1=k1.get("sap-ui-layer");j1=q.extend({},this.getFlexSettings(),j1);if(l1){j1.layer=l1.toUpperCase();}if(j1.scenario||j1.baseId){var m1=s.buildLrepRootNamespace(j1.baseId,j1.scenario,j1.projectId);j1.rootNamespace=m1;j1.namespace=m1+"changes/";}U.setRtaStyleClassName(j1.layer);this.setProperty("flexSettings",j1);};
f1.prototype.getLayer=function(){return this.getFlexSettings().layer;};
f1.prototype.getRootControlInstance=function(){if(!this._oRootControl){this._oRootControl=E.getElementInstance(this.getRootControl());}return this._oRootControl;};
f1.prototype._getTextResources=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");};
f1.prototype.start=function(){this._sStatus=$;var j1;var k1;var l1=this.getRootControlInstance();if(!this._oDesignTime){if(!l1){k1=new Error("Root control not found");X.error(k1);return Promise.reject(k1);}if(this.getValidateAppVersion()&&!s.isCorrectAppVersionFormat(s.getAppVersionFromManifest(s.getAppComponentForControl(l1).getManifest()))){k1=this._getTextResources().getText("MSG_INCORRECT_APP_VERSION_ERROR");X.error(k1);return Promise.reject(k1);}return this._handleHigherLayerChangesOnStart().then(function(m1){if(m1){return Promise.reject("Reload triggered");}if(!this.getPlugins()||!Object.keys(this.getPlugins()).length){this.setPlugins(this.getDefaultPlugins());}this._destroyDefaultPlugins(this.getPlugins());Object.keys(this.getPlugins()).forEach(function(p1){if(this.getPlugins()[p1].attachElementModified){this.getPlugins()[p1].attachElementModified(this._handleElementModified,this);}}.bind(this));if(this.getPlugins()["settings"]){this.getPlugins()["settings"].setCommandStack(this.getCommandStack());}this._oSerializer=new L({commandStack:this.getCommandStack(),rootControl:this.getRootControl()});var n1=Object.keys(this.getPlugins());var o1=n1.map(function(p1){return this.getPlugins()[p1];},this);j1=new Promise(function(p1,q1){W.start("rta.dt.startup","Measurement of RTA: DesignTime start up");this._oDesignTime=new D({scope:this.getMetadataScope(),plugins:o1});this._oDesignTime.addRootElement(this._oRootControl);q(O.getOverlayContainer()).addClass("sapUiRta");if(this.getLayer()==="USER"){q(O.getOverlayContainer()).addClass("sapUiRtaPersonalize");}else{q("body").addClass("sapUiRtaMode");}this._oDesignTime.getSelectionManager().attachChange(function(r1){this.fireSelectionChange({selection:r1.getParameter("selection")});},this);this._oDesignTime.attachEventOnce("synced",function(){p1();W.end("rta.dt.startup","Measurement of RTA: DesignTime start up");},this);this._oDesignTime.attachEventOnce("syncFailed",function(r1){q1(r1.getParameter("error"));});}.bind(this));this._oldUnloadHandler=window.onbeforeunload;window.onbeforeunload=this._onUnload.bind(this);}.bind(this)).then(function(){var m1={selector:this.getRootControlInstance(),layer:this.getLayer()};return v.getResetAndPublishInfo(m1).then(function(n1){this.bInitialResetEnabled=n1.isResetEnabled;this.bInitialPublishEnabled=n1.isPublishEnabled;}.bind(this));}.bind(this)).then(function(){if(this.getShowToolbars()){return this._getPublishAndAppVariantSupportVisibility().then(function(m1){var n1=m1[0];var o1=m1[1];this._createToolsMenu(n1,o1);}.bind(this));}}.bind(this)).then(function(){this._onStackModified();}.bind(this)).then(function(){G.loadStyles('InPageStyles').then(function(m1){var n1=m1.replace(/%scrollWidth%/g,z.getScrollbarWidth()+'px');z.insertStyles(n1,O.getOverlayContainer().get(0));});}).then(function(){return j1;}).then(function(){this.getPopupManager().setRta(this);if(this.getShowToolbars()){return this.getToolbar().show();}}.bind(this)).then(function(){if(I.browser.name==="ff"){q(document).on('contextmenu',g1);}}).then(function(){this.fnKeyDown=this._onKeyDown.bind(this);q(document).on("keydown",this.fnKeyDown);var m1=N.getOverlay(this.getRootControl());this._$RootControl=m1.getAssociatedDomRef();if(this._$RootControl){this._$RootControl.addClass("sapUiRtaRoot");}}.bind(this)).then(function(){this._sStatus=_;this.fireStart({editablePluginsCount:this.iEditableOverlaysCount});}.bind(this)).catch(function(k1){if(k1!=="Reload triggered"){this._sStatus=b1;this.fireFailed(k1);}if(k1){this.destroy();return Promise.reject(k1);}}.bind(this));}};
function g1(){return false;}
f1.prototype._getPublishAndAppVariantSupportVisibility=function(){return u.isPublishAvailable().then(function(j1){var k1=H.isPlatFormEnabled(this.getRootControlInstance(),this.getLayer(),this._oSerializer);return[j1,j1&&k1];}.bind(this));};
var h1=function(j1){B.hide();var k1="";if(j1.messages&&Array.isArray(j1.messages)&&j1.messages.length>0){k1=j1.messages.reduce(function(n1,o1){return n1.concat(o1.severity==="Error"?o1.text+"\n":"");},k1);}if(!k1){k1=j1.stack||j1.message||j1.status||j1;}var l1=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");X.error("Failed to transfer runtime adaptation changes to layered repository",k1);var m1=l1.getText("MSG_LREP_TRANSFER_ERROR")+"\n"+l1.getText("MSG_ERROR_REASON",k1);w.error(m1,{styleClass:U.getRtaStyleClassName()});};
f1.prototype.setCommandStack=function(j1){var k1=this.getProperty("commandStack");if(k1){k1.detachModified(this._onStackModified,this);}if(this._oInternalCommandStack){this._oInternalCommandStack.destroy();delete this._oInternalCommandStack;}var l1=this.setProperty("commandStack",j1);if(j1){j1.attachModified(this._onStackModified,this);}if(this.getPlugins()&&this.getPlugins()["settings"]){this.getPlugins()["settings"].setCommandStack(j1);}return l1;};
f1.prototype.getCommandStack=function(){var j1=this.getProperty("commandStack");if(!j1){j1=new C();this._oInternalCommandStack=j1;this.setCommandStack(j1);}return j1;};
f1.prototype._onStackModified=function(){var j1=this.getCommandStack();var k1=j1.canUndo();var l1=j1.canRedo();if(this.getShowToolbars()){this.getToolbar().setUndoRedoEnabled(k1,l1);this.getToolbar().setPublishEnabled(this.bInitialPublishEnabled||k1);this.getToolbar().setRestoreEnabled(this.bInitialResetEnabled||k1);}this.fireUndoRedoStackModified();};
f1.prototype._closeToolbar=function(){if(this.getShowToolbars()&&this.getToolbar){return this.getToolbar().hide();}};
f1.prototype.getSelection=function(){if(this._oDesignTime){return this._oDesignTime.getSelectionManager().get();}return[];};
f1.prototype.stop=function(j1,k1){return((k1)?Promise.resolve(this._RESTART.NOT_NEEDED):this._handleReloadOnExit()).then(function(l1){return((j1)?Promise.resolve():this._serializeToLrep(this)).then(this._closeToolbar.bind(this)).then(function(){this.fireStop();if(l1!==this._RESTART.NOT_NEEDED){this._removeMaxLayerParameter();if(l1===this._RESTART.RELOAD_PAGE){this._reloadPage();}}}.bind(this));}.bind(this)).catch(h1).then(function(){this._sStatus=a1;q("body").removeClass("sapUiRtaMode");}.bind(this));};
f1.prototype.restore=function(){this._onRestore();};
f1.prototype.transport=function(){return this._onTransport();};
f1.prototype.undo=function(){return this._onUndo();};
f1.prototype.redo=function(){return this._onRedo();};
f1.prototype.canUndo=function(){return this.getCommandStack().canUndo();};
f1.prototype.canRedo=function(){return this.getCommandStack().canRedo();};
f1.prototype._onKeyDown=function(j1){var k1=I.os.macintosh;var l1=O.getOverlayContainer().get(0).contains(document.activeElement);var m1=this.getShowToolbars()&&this.getToolbar().getDomRef().contains(document.activeElement);var n1=false;q(".sapUiDtContextMenu").each(function(r1,s1){if(s1.contains(document.activeElement)){n1=true;}});var o1=document.body===document.activeElement;var p1=q(document.activeElement).parents('.sapUiRtaEditableField').length>0;if((l1||m1||n1||o1)&&!p1){var q1=k1?j1.metaKey:j1.ctrlKey;if(j1.keyCode===Y.Z&&j1.shiftKey===false&&j1.altKey===false&&q1===true){this._onUndo().then(j1.stopPropagation.bind(j1));}else if(((k1&&j1.keyCode===Y.Z&&j1.shiftKey===true)||(!k1&&j1.keyCode===Y.Y&&j1.shiftKey===false))&&j1.altKey===false&&q1===true){this._onRedo().then(j1.stopPropagation.bind(j1));}}};
f1.prototype._onUnload=function(){var j1=this.getCommandStack();var k1=j1.canUndo()||j1.canRedo();if(k1&&this.getShowWindowUnloadDialog()){var l1=this._getTextResources().getText("MSG_UNSAVED_CHANGES");return l1;}window.onbeforeunload=this._oldUnloadHandler;};
f1.prototype._serializeToLrep=function(){if(!this._bReloadNeeded){return this._oSerializer.needsReload().then(function(j1){this._bReloadNeeded=j1;return this._oSerializer.saveCommands();}.bind(this));}return this._oSerializer.saveCommands();};
f1.prototype._onUndo=function(){this._handleStopCutPaste();return this.getCommandStack().undo();};
f1.prototype._onRedo=function(){this._handleStopCutPaste();return this.getCommandStack().redo();};
f1.prototype._createToolsMenu=function(j1,k1){if(!this.getDependent('toolbar')){var l1;if(this.getLayer()==="USER"){l1=P;}else if(U.getFiori2Renderer()){l1=F;}else{l1=S;}if(this.getLayer()==="USER"){this.addDependent(new l1({textResources:this._getTextResources(),exit:this.stop.bind(this,false,true),restore:this._onRestore.bind(this)}),'toolbar');}else{this.addDependent(new l1({modeSwitcher:this.getMode(),publishVisible:j1,textResources:this._getTextResources(),exit:this.stop.bind(this,false,false),transport:this._onTransport.bind(this),restore:this._onRestore.bind(this),undo:this._onUndo.bind(this),redo:this._onRedo.bind(this),modeChange:this._onModeChange.bind(this),manageApps:H.onGetOverview.bind(null,true,this.getLayer()),appVariantOverview:this._onGetAppVariantOverview.bind(this),saveAs:H.onSaveAs.bind(null,true,true,this.getLayer(),null)}),'toolbar');}this.getToolbar().setPublishEnabled(this.bInitialPublishEnabled);this.getToolbar().setRestoreEnabled(this.bInitialResetEnabled);var m1;if(k1){this.getToolbar().getControl('saveAs').setVisible(k1);m1=H.isOverviewExtended();if(m1){this.getToolbar().getControl('appVariantOverview').setVisible(k1);}else{this.getToolbar().getControl('manageApps').setVisible(k1);}H.isManifestSupported().then(function(n1){if(m1){this.getToolbar().getControl('appVariantOverview').setEnabled(n1);}else{this.getToolbar().getControl('manageApps').setEnabled(n1);}this.getToolbar().getControl('saveAs').setEnabled(n1);}.bind(this));}}};
f1.prototype._onGetAppVariantOverview=function(j1){var k1=j1.getParameter("item");var l1=k1.getId()==='keyUser';return H.onGetOverview(l1,this.getLayer());};
f1.prototype.destroy=function(){q.map(this._dependents,function(j1,k1){this.removeDependent(k1);j1.destroy(true);}.bind(this));Object.keys(this._mServices).forEach(function(j1){this.stopService(j1);},this);if(this._oDesignTime){this._oDesignTime.destroy();this._oDesignTime=null;q(document).off("keydown",this.fnKeyDown);this._destroyDefaultPlugins();this.setPlugins(null);}if(this._$RootControl){this._$RootControl.removeClass("sapUiRtaRoot");}this.setCommandStack(null);if(this._oServiceEventBus){this._oServiceEventBus.destroy();}if(I.browser.name==="ff"){q(document).off("contextmenu",g1);}window.onbeforeunload=this._oldUnloadHandler;M.prototype.destroy.apply(this,arguments);};
f1.prototype._onTransport=function(){this._handleStopCutPaste();B.show(500);return this._serializeToLrep().then(function(){B.hide();var j1=s.isApplicationVariant(this._oRootControl)&&!s.isVariantByStartupParameter(this._oRootControl);return((j1)?H.getAppVariantDescriptor(this._oRootControl):Promise.resolve()).then(function(k1){var l1=[];if(k1){l1.push(k1);}return v.publish({selector:this.getRootControlInstance(),styleClass:U.getRtaStyleClassName(),layer:this.getLayer(),appVariantDescriptors:l1}).then(function(m1){if(m1!=="Error"&&m1!=="Cancel"){this._showMessageToast("MSG_TRANSPORT_SUCCESS");if(this.getShowToolbars()){var n1={selector:this.getRootControlInstance(),layer:this.getLayer()};v.getResetAndPublishInfo(n1).then(function(o1){this.getToolbar().setPublishEnabled(o1.isPublishEnabled);this.getToolbar().setRestoreEnabled(o1.isResetEnabled);}.bind(this));}}}.bind(this));}.bind(this));}.bind(this))['catch'](h1);};
f1.prototype._deleteChanges=function(){var j1=this.getRootControlInstance();var k1=s.getAppComponentForControl(j1);return v.reset({selector:k1,layer:this.getLayer(),generator:"Change.createInitialFileContent"}).then(function(){this._reloadPage();}.bind(this)).catch(function(l1){return U._showMessageBox(w.Icon.ERROR,"HEADER_RESTORE_FAILED","MSG_RESTORE_FAILED",l1);});};
f1.prototype._reloadPage=function(){window.location.reload();};
f1.prototype._showMessageToast=function(j1){var k1=this._getTextResources().getText(j1);x.show(k1);};
f1.needsRestart=function(j1){var k1=!!window.sessionStorage.getItem("sap.ui.rta.restart."+j1);return k1;};
f1.enableRestart=function(j1){window.sessionStorage.setItem("sap.ui.rta.restart."+j1,true);};
f1.disableRestart=function(j1){window.sessionStorage.removeItem("sap.ui.rta.restart."+j1);};
f1.prototype._onRestore=function(){var j1=this.getLayer()==="USER"?this._getTextResources().getText("FORM_PERS_RESET_MESSAGE_PERSONALIZATION"):this._getTextResources().getText("FORM_PERS_RESET_MESSAGE");var k1=this.getLayer()==="USER"?this._getTextResources().getText("BTN_RESTORE"):this._getTextResources().getText("FORM_PERS_RESET_TITLE");var l1=function(m1){if(m1==="OK"){f1.enableRestart(this.getLayer());this._deleteChanges();this.getCommandStack().removeAllCommands();}}.bind(this);this._handleStopCutPaste();w.confirm(j1,{icon:w.Icon.WARNING,title:k1,onClose:l1,styleClass:U.getRtaStyleClassName()});};
f1.prototype._scheduleRenameOnCreatedContainer=function(j1,k1){var l1=function(p1){var q1=this.getPlugins()["createContainer"].getCreatedContainerId(j1,p1.getElement().getId());var r1=N.getOverlay(q1);r1.setSelected(true);this.getPlugins()["rename"].startEdit(r1);};var m1=function(p1){var q1=p1.getSource();if(q1.getGeometry()&&q1.getGeometry().visible){l1.call(this,q1);q1.detachEvent('geometryChanged',m1,this);}};var n1=function(p1){if(!p1.getGeometry()||!p1.getGeometry().visible){p1.attachEvent('geometryChanged',m1,this);}else{l1.call(this,p1);}};var o1=function(p1){var q1=p1.getParameter("elementOverlay");if(q1.getElement().getId()===k1){this._oDesignTime.detachEvent("elementOverlayCreated",o1,this);if(q1.isRendered()){n1.call(this,q1);}else{q1.attachEventOnce('afterRendering',function(p1){n1.call(this,p1.getSource());},this);}}};this._oDesignTime.attachEvent("elementOverlayCreated",o1,this);};
f1.prototype._handleElementModified=function(j1){this._handleStopCutPaste();var k1=j1.getParameter("action");var l1=j1.getParameter("newControlId");var m1=j1.getParameter("command");if(m1 instanceof sap.ui.rta.command.BaseCommand){if(k1&&l1){this._scheduleRenameOnCreatedContainer(k1,l1);}return this.getCommandStack().pushAndExecute(m1).catch(function(n1){if(n1&&n1.message&&n1.message.indexOf("The following Change cannot be applied because of a dependency")>-1){U._showMessageBox(w.Icon.ERROR,"HEADER_DEPENDENCY_ERROR","MSG_DEPENDENCY_ERROR",n1);}X.error("sap.ui.rta: "+n1.message);});}return Promise.resolve();};
f1.prototype._onElementEditableChange=function(j1){var k1=j1.getParameter("editable");if(k1){this.iEditableOverlaysCount+=1;}else{this.iEditableOverlaysCount-=1;}};
f1.prototype._handleStopCutPaste=function(){if(this.getPlugins()["cutPaste"]){this.getPlugins()["cutPaste"].stopCutAndPaste();}};
f1.prototype._buildNavigationArguments=function(j1){return{target:{semanticObject:j1.semanticObject,action:j1.action,context:j1.contextRaw},params:j1.params,appSpecificRoute:j1.appSpecificRoute,writeHistory:false};};
f1.prototype._hasMaxLayerParameter=function(j1){var k1=this.getLayer();return j1.params&&j1.params[t.FL_MAX_LAYER_PARAM]&&j1.params[t.FL_MAX_LAYER_PARAM][0]===k1;};
f1.prototype._reloadWithoutHigherLayerChangesOnStart=function(j1,k1){var l1=this.getLayer();if(!this._hasMaxLayerParameter(j1)){if(!j1.params){j1.params={};}j1.params[t.FL_MAX_LAYER_PARAM]=[l1];f1.enableRestart(l1);k1.toExternal(this._buildNavigationArguments(j1));return Promise.resolve(true);}};
f1.prototype._removeMaxLayerParameter=function(){if(s.getUshellContainer()&&this.getLayer()!=="USER"){var j1=s.getUshellContainer().getService("CrossApplicationNavigation");var k1=s.getParsedURLHash();if(j1.toExternal&&k1){if(this._hasMaxLayerParameter(k1)){delete k1.params[t.FL_MAX_LAYER_PARAM];j1.toExternal(this._buildNavigationArguments(k1));}}}};
f1.prototype._handleReloadWithoutHigherLayerChangesMessageBoxOnStart=function(){var j1=this.getLayer();var k1=j1==="CUSTOMER"?"MSG_PERSONALIZATION_EXISTS":"MSG_HIGHER_LAYER_CHANGES_EXIST";return U._showMessageBox(w.Icon.INFORMATION,"HEADER_PERSONALIZATION_EXISTS",k1);};
f1.prototype._handleReloadMessageBox=function(j1){return U._showMessageBox(w.Icon.INFORMATION,"HEADER_RELOAD_NEEDED",j1,undefined,"BUTTON_RELOAD_NEEDED");};
f1.prototype._handleHigherLayerChangesOnStart=function(){var j1=s.getUshellContainer();if(j1&&this.getLayer()!=="USER"){var k1=s.getParsedURLHash();return v.hasHigherLayerChanges({selector:this.getRootControlInstance(),ignoreMaxLayerParameter:false}).then(function(l1){if(l1){return this._handleReloadWithoutHigherLayerChangesMessageBoxOnStart().then(function(){var m1=j1.getService("CrossApplicationNavigation");if(m1.toExternal&&k1){return this._reloadWithoutHigherLayerChangesOnStart(k1,m1);}}.bind(this));}}.bind(this));}return Promise.resolve(false);};
f1.prototype._handleReloadOnExit=function(){return Promise.all([(!this._bReloadNeeded)?this._oSerializer.needsReload():Promise.resolve(this._bReloadNeeded),v.hasHigherLayerChanges({selector:this.getRootControlInstance(),ignoreMaxLayerParameter:true})]).then(function(j1){var k1=j1[0];var l1=j1[1];if(k1||l1){var m1=this._RESTART.RELOAD_PAGE;var n1;var o1;if(l1){var p1=this.getLayer();n1=p1==="CUSTOMER"?"MSG_RELOAD_WITH_PERSONALIZATION":"MSG_RELOAD_WITH_ALL_CHANGES";o1=s.getUshellContainer();if(!k1&&o1){m1=this._RESTART.VIA_HASH;}}else if(k1){n1="MSG_RELOAD_NEEDED";}return this._handleReloadMessageBox(n1).then(function(){return m1;});}return this._RESTART.NOT_NEEDED;}.bind(this));};
f1.prototype._onModeChange=function(j1){this.setMode(j1.getParameter("item").getKey());};
f1.prototype.setMode=function(j1){if(this.getProperty('mode')!==j1){var k1=this.getShowToolbars()&&this.getToolbar().getControl('modeSwitcher');var l1=j1==='adaptation';if(k1){k1.setSelectedButton(k1.getItems().filter(function(m1){return m1.getKey()===j1;}).pop().getId());}this._oDesignTime.setEnabled(l1);this.getPlugins()['tabHandling'][l1?'removeTabIndex':'restoreTabIndex']();this.setProperty('mode',j1);this.fireModeChanged({mode:j1});}};
f1.prototype.setMetadataScope=function(j1){if(this._oDesignTime){X.error("sap.ui.rta: Failed to set metadata scope on RTA instance after RTA is started");return;}this.setProperty('metadataScope',j1);};
function i1(j1){if(J.hasOwnProperty(j1)){return J[j1].replace(/\./g,'/');}}
f1.prototype.startService=function(j1){if(this._sStatus!==_){return new Promise(function(m1,n1){this.attachEventOnce('start',m1);this.attachEventOnce('failed',n1);}.bind(this)).then(function(){return this.startService(j1);}.bind(this),function(){return Promise.reject(r.createError("RuntimeAuthoring#startService",r.printf("Can't start the service '{0}' while RTA has been failed during a startup",j1),"sap.ui.rta"));});}var k1=i1(j1);var l1;if(!k1){return Promise.reject(r.createError("RuntimeAuthoring#startService",r.printf("Unknown service. Can't find any registered service by name '{0}'",j1),"sap.ui.rta"));}l1=this._mServices[j1];if(l1){switch(l1.status){case d1:{return Promise.resolve(l1.exports);}case c1:{return l1.initPromise;}case e1:{return l1.initPromise;}default:{return Promise.reject(r.createError("RuntimeAuthoring#startService",r.printf("Unknown service status. Service name = '{0}'",j1),"sap.ui.rta"));}}}else{this._mServices[j1]=l1={status:c1,location:k1,initPromise:new Promise(function(m1,n1){sap.ui.require([k1],function(o1){l1.factory=o1;if(!this._oServiceEventBus){this._oServiceEventBus=new K();}r.wrapIntoPromise(o1)(this,this._oServiceEventBus.publish.bind(this._oServiceEventBus,j1)).then(function(p1){if(this.bIsDestroyed){throw r.createError("RuntimeAuthoring#startService",r.printf("RuntimeAuthoring instance is destroyed while initialising the service '{0}'",j1),"sap.ui.rta");}if(!q.isPlainObject(p1)){throw r.createError("RuntimeAuthoring#startService",r.printf("Invalid service format. Service should return simple javascript object after initialisation. Service name = '{0}'",j1),"sap.ui.rta");}l1.service=p1;l1.exports={};if(Array.isArray(p1.events)&&p1.events.length>0){q.extend(l1.exports,{attachEvent:this._oServiceEventBus.subscribe.bind(this._oServiceEventBus,j1),detachEvent:this._oServiceEventBus.unsubscribe.bind(this._oServiceEventBus,j1),attachEventOnce:this._oServiceEventBus.subscribeOnce.bind(this._oServiceEventBus,j1)});}var q1=p1.exports||{};q.extend(l1.exports,Object.keys(q1).reduce(function(r1,s1){var t1=q1[s1];r1[s1]=typeof t1==="function"?r.waitForSynced(this._oDesignTime,t1):t1;return r1;}.bind(this),{}));l1.status=d1;m1(Object.freeze(l1.exports));}.bind(this)).catch(n1);}.bind(this),function(o1){l1.status=e1;n1(r.propagateError(o1,"RuntimeAuthoring#startService",r.printf("Can't load service '{0}' by its name: {1}",j1,k1),"sap.ui.rta"));});}.bind(this)).catch(function(m1){l1.status=e1;return Promise.reject(r.propagateError(m1,"RuntimeAuthoring#startService",r.printf("Error during service '{0}' initialisation.",j1),"sap.ui.rta"));})};return l1.initPromise;}};
f1.prototype.stopService=function(j1){var k1=this._mServices[j1];if(k1){if(k1.status===d1){if(typeof k1.service.destroy==="function"){k1.service.destroy();}}delete this._mServices[j1];}else{throw r.createError("RuntimeAuthoring#stopService",r.printf("Can't destroy service: unable to find service with name '{0}'",j1),"sap.ui.rta");}};
f1.prototype.getService=function(j1){return this.startService(j1);};
return f1;},true);
sap.ui.predefine('sap/ui/rta/Utils',["sap/ui/thirdparty/jquery","sap/ui/fl/Utils","sap/ui/fl/LayerUtils","sap/ui/fl/registry/Settings","sap/ui/dt/OverlayUtil","sap/ui/dt/DOMUtil","sap/m/MessageBox","sap/ui/rta/util/BindingsExtractor","sap/base/Log"],function(q,F,a,S,O,D,M,B,L){"use strict";var U={};U.RESOLVED_PROMISE=Promise.resolve(true);U._sFocusableOverlayClass=".sapUiDtOverlaySelectable";U._sRtaStyleClassName='';
U.getRtaStyleClassName=function(){return U._sRtaStyleClassName;};
U.setRtaStyleClassName=function(l){if(l==="USER"){U._sRtaStyleClassName="";}else if(a.getLayerIndex(l)>-1){U._sRtaStyleClassName="sapUiRTABorder";}};
U.isExtensibilityEnabledInSystem=function(c){var C=F.getComponentClassName(c);if(!C||C===""){return Promise.resolve(false);}return S.getInstance(C).then(function(s){if(s.isModelS){return s.isModelS();}return false;});};
U.isServiceUpToDate=function(c){return this.isExtensibilityEnabledInSystem(c).then(function(e){if(e){return new Promise(function(r,R){sap.ui.require(["sap/ui/fl/fieldExt/Access"],function(A){var m=c.getModel();if(m){var s=A.isServiceOutdated(m.sServiceUrl);if(s){A.setServiceValid(m.sServiceUrl);sap.ui.getCore().getEventBus().publish("sap.ui.core.UnrecoverableClientStateCorruption","RequestReload",{});return R();}}return r();});});}});};
U.isCustomFieldAvailable=function(c){return this.isExtensibilityEnabledInSystem(c).then(function(s){if(!s||!c.getModel()){return false;}return new Promise(function(r,R){sap.ui.require(["sap/ui/fl/fieldExt/Access"],function(A){var b=c.getModel().sServiceUrl;var e=this.getBoundEntityType(c).name;var d;try{d=A.getBusinessContexts(b,e);}catch(E){L.error("exception occured in sap.ui.fl.fieldExt.Access.getBusinessContexts",E);r(false);}return Promise.resolve(d).then(function(o){if(o&&Array.isArray(o.BusinessContexts)&&o.BusinessContexts.length>0){o.EntityType=e;return r(o);}return r(false);}).catch(function(E){if(E){if(Array.isArray(E.errorMessages)){for(var i=0;i<E.errorMessages.length;i++){L.error(E.errorMessages[i].text);}}}return r(false);});}.bind(this),R);}.bind(this));}.bind(this));};
U.openRemoveConfirmationDialog=function(e,t){var T=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");var s;return new Promise(function(r){s=T.getText("CTX_REMOVE_TITLE");var d={messageText:t,titleText:s,icon:"sap-icon://question-mark",removeText:T.getText("BTN_FREP_REMOVE"),cancelText:T.getText("BTN_FREP_CANCEL")};var m=new sap.ui.model.json.JSONModel();m.setData(d);var f;var c=function(){if(f){f.close();f.destroy();f=null;}};var o={removeField:function(){c();r(true);},closeDialog:function(){c();r(false);}};if(!f){f=sap.ui.xmlfragment("sap.ui.rta.view.RemoveElementDialog",o);f.setModel(m);}f.addStyleClass(U.getRtaStyleClassName());f.open();});};
U.isOverlaySelectable=function(o){return o.isSelectable()&&D.isVisible(o.getDomRef());};
U.getPropertyValue=function(e,p){var m=e.getMetadata().getPropertyLikeSetting(p);var P=m._sGetter;return e[P]();};
U.getOverlayInstanceForDom=function(d){var i=q(d).attr("id");if(i){return sap.ui.getCore().byId(i);}};
U.getFocusedOverlay=function(){if(document.activeElement){var e=sap.ui.getCore().byId(document.activeElement.id);if(e instanceof sap.ui.dt.ElementOverlay){return e;}}};
U.getFocusableParentOverlay=function(o){if(!o){return undefined;}var f=o.getParentElementOverlay();while(f&&!f.getSelectable()){f=f.getParentElementOverlay();}return f;};
U.getFirstFocusableDescendantOverlay=function(o){return O.getFirstDescendantByCondition(o,this.isOverlaySelectable);};
U.getLastFocusableDescendantOverlay=function(o){return O.getLastDescendantByCondition(o,this.isOverlaySelectable);};
U.getNextFocusableSiblingOverlay=function(o){var N=true;var n=O.getNextSiblingOverlay(o);while(n&&!this.isOverlaySelectable(n)){n=O.getNextSiblingOverlay(n);}if(!n){n=this._findSiblingOverlay(o,N);}return n;};
U.getPreviousFocusableSiblingOverlay=function(o){var P=false;var p=O.getPreviousSiblingOverlay(o);while(p&&!this.isOverlaySelectable(p)){p=O.getPreviousSiblingOverlay(p);}if(!p){p=this._findSiblingOverlay(o,P);}return p;};
U._findSiblingOverlay=function(o,n){var p=o.getParentElementOverlay();if(p){var s=n?O.getNextSiblingOverlay(p):O.getPreviousSiblingOverlay(p);if(!s){return this._findSiblingOverlay(p,n);}var d=n?this.getFirstFocusableDescendantOverlay(s):this.getLastFocusableDescendantOverlay(s);return d;}return undefined;};
U.getIndex=function(p,c,A,g){var i;if(g&&typeof g==="function"){i=g(p,c);}else{var m=p.getMetadata();var o=m.getAggregation(A);var G=o._sGetter;var C=p[G]();if(Array.isArray(C)&&c){i=C.indexOf(c)+1;}else{i=0;}}return i;};
U.createFieldLabelId=function(p,e,b){return(p.getId()+"_"+e+"_"+b).replace("/","_");};
U.getBoundEntityType=function(e,m){m||(m=e.getModel());var b=e.getBindingContext();if(b){return U.getEntityTypeByPath(m,b.getPath())||{};}return{};};
U.openNewWindow=function(u){window.open(u,"_blank");};
U.getElementBindingPaths=function(e){var p={};if(e.mBindingInfos){for(var i in e.mBindingInfos){var P=e.mBindingInfos[i].parts[0].path?e.mBindingInfos[i].parts[0].path:"";P=P.split("/")[P.split("/").length-1];p[P]={valueProperty:i};}}return p;};
U.getFiori2Renderer=function(){var c=F.getUshellContainer()||{};return typeof c.getRenderer==="function"?c.getRenderer("fiori2"):undefined;};
U.getEntityTypeByPath=function(m,p){return m.oMetadata&&m.oMetadata._getEntityTypeByPath(p);};
U.extendWith=function(d,s,c){if(!(typeof c==="function")){throw new Error('In order to use extendWith() utility function fnCustomizer should be provided!');}for(var b in s){if(s.hasOwnProperty(b)){if(c(d[b],s[b],b,d,s)){d[b]=s[b];}}}};
U.isElementInViewport=function(d){if(d instanceof q){d=d.get(0);}var r=d.getBoundingClientRect();return(r.top>=0&&r.left>=0&&r.bottom<=(window.innerHeight||document.documentElement.clientHeight)&&r.right<=(window.innerWidth||document.documentElement.clientWidth));};
U._showMessageBox=function(m,t,s,e,A){var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");var b=r.getText(s,e?[e.message||e]:undefined);var T=r.getText(t);var v=A?r.getText(A):M.Action.OK;return new Promise(function(c){M.show(b,{icon:m,title:T,onClose:c,actions:v,styleClass:U.getRtaStyleClassName()});});};
U.checkSourceTargetBindingCompatibility=function(s,t,m){m=m||s.getModel();var b=B.collectBindingPaths(s,m);var c;var T;if(b.bindingPaths.length===0){return true;}c=B.getBindingContextPath(s);T=B.getBindingContextPath(t);if(c===T){return true;}return false;};
U.doIfAllControlsAreAvailable=function(c,C){if(c.every(function(o){return o&&!o._bIsBeingDestroyed;})){return C();}};
return U;},true);
sap.ui.predefine('sap/ui/rta/appVariant/AppVariantDialog',["sap/m/Button","sap/m/Dialog","sap/m/DialogRenderer","sap/m/GenericTile","sap/m/ImageContent","sap/m/Input","sap/m/Label","sap/m/SelectDialog","sap/m/StandardListItem","sap/m/TextArea","sap/m/TileContent","sap/m/VBox","sap/ui/core/Title","sap/ui/layout/form/SimpleForm","sap/ui/model/Filter","sap/ui/model/json/JSONModel","sap/ui/rta/Utils","sap/ui/layout/form/ResponsiveGridLayout"],function(B,D,a,G,I,b,L,S,c,T,d,V,e,f,F,J,R){"use strict";var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");var o;var t;var g;var s;var h;var i;var j;var k;var l;var m;var n;var C;var p;
function _(){o=new G("tile",{header:"{/title}",subheader:"{/subtitle}",ariaLabel:r.getText("APP_VARIANT_TILE_ARIA_LABEL"),tileContent:[new d({content:[new I({src:"{/icon}"})]})]}).addStyleClass("sapUiMediumMarginBegin").addStyleClass("sapUiTinyMarginTop").addStyleClass("sapUiTinyMarginBottom");}
function q(E){var z=E.getParameter("value");var H=new F("name",sap.ui.model.FilterOperator.Contains,z);var K=E.getSource().getBinding("items");K.filter([H]);}
function u(E){var z=E.getParameter("selectedContexts");if(z&&z.length){z.forEach(function(H){var K=H.getObject().name;l.setValue(K);C.setProperty("/icon",H.getObject().icon);});}E.getSource().getBinding("items").filter([]);}
function v(){if(!n){n=new S("selectDialog",{noDataText:r.getText("APP_VARIANT_ICON_NO_DATA"),title:r.getText("APP_VARIANT_ICON_SELECT_ICON"),search:function(E){q(E);},confirm:function(E){u(E);},cancel:function(E){u(E);}});}n.addStyleClass(R.getRtaStyleClassName());n.bindAggregation("items",{path:"/icons",template:new c({title:"{name}",description:"",icon:"{icon}",iconDensityAware:false,iconInset:false,type:"Active"})});var U=sap.ui.core.IconPool.getIconNames();var z=[];U.forEach(function(N){z.push({icon:sap.ui.core.IconPool.getIconInfo(N).uri,name:N.toLowerCase()});});p.setProperty("/icons",z);n.setModel(p);n.getBinding("items").filter([]);n.open();}
function w(){t=new L({required:true,text:r.getText("APP_DIALOG_TITLE_TEXT"),textAlign:"Left"});g=new b("titleInput",{value:"{/title}",valueLiveUpdate:true,placeholder:r.getText("SAVE_AS_DIALOG_PLACEHOLDER_TITLE_TEXT"),liveChange:function(){var z=sap.ui.getCore().byId("saveButton");if(this.getValue()===""){this.setValueState(sap.ui.core.ValueState.Error);z.setEnabled(false);}else{this.setValueState(sap.ui.core.ValueState.None);z.setEnabled(true);}}});s=new L({text:r.getText("APP_DIALOG_SUB_TITLE_TEXT"),textAlign:"Left"});h=new b({value:"{/subtitle}",valueLiveUpdate:true});i=new L({text:r.getText("APP_DIALOG_DESCRIPTION_TEXT"),textAlign:"Left"});j=new T({rows:4});k=new L({text:r.getText("APP_DIALOG_ICON_TEXT"),textAlign:"Left"});l=new b("selectInput",{showValueHelp:true,liveChange:function(E){v(E);},valueHelpRequest:function(E){v(E);},value:"{/iconname}",valueLiveUpdate:true});}
function x(){m=new f({editable:true,layout:"ResponsiveGridLayout",labelSpanXL:4,labelSpanL:4,labelSpanM:4,labelSpanS:4,adjustLabelSpan:false,emptySpanXL:0,emptySpanL:0,emptySpanM:0,emptySpanS:0,columnsXL:2,columnsL:2,columnsM:2,singleContainerFullSize:false,content:[new e("title1"),t,g,s,h,k,l,i,j,new e("title2"),o]});return m;}
function y(){var z=new V({items:[x()]}).addStyleClass("sapUISmallMargin");return z;}
var A=D.extend("sap.ui.rta.appVariant.AppVariantDialog",{
metadata:{library:"sap.ui.rta",events:{create:{},cancel:{}}},
init:function(){D.prototype.init.apply(this);this.setTitle(r.getText("CREATE_APP_VARIANT_DIALOG_TITLE"));this.setContentWidth("620px");this.setContentHeight("250px");C=new J({title:null,subtitle:null,icon:" ",iconname:null});p=new J({icons:null});sap.ui.getCore().setModel(C);_();w();this.addContent(y());this._createButtons();this.addStyleClass(R.getRtaStyleClassName());},
onAfterRendering:function(){document.getElementById('title1').style.height="0px";document.getElementById('title2').style.height="0px";document.getElementById('tile').style.float="left";},
_onCreate:function(){var z=g.getValue()||" ";var E=h.getValue()||" ";var H=j.getValue()||" ";var K=l.getValue()?sap.ui.core.IconPool.getIconInfo(l.getValue()).uri:" ";this.fireCreate({title:z,subTitle:E,description:H,icon:K});this.close();this.destroy();},
_createButtons:function(){this.addButton(new B("saveButton",{text:r.getText("APP_VARIANT_DIALOG_SAVE"),tooltip:r.getText("TOOLTIP_APP_VARIANT_DIALOG_SAVE"),enabled:false,press:function(){this._onCreate();}.bind(this)}));this.addButton(new B({text:r.getText("SAVE_AS_APP_VARIANT_DIALOG_CANCEL"),tooltip:r.getText("TOOLTIP_SAVE_AS_APP_VARIANT_DIALOG_CANCEL"),press:function(){this.fireCancel();this.close();this.destroy();}.bind(this)}));},
destroy:function(){if(C){C.destroy();}D.prototype.destroy.apply(this,arguments);},
renderer:a.render
});
return A;},true);
sap.ui.predefine('sap/ui/rta/appVariant/AppVariantManager',["sap/ui/base/ManagedObject","sap/ui/rta/appVariant/AppVariantDialog","sap/ui/rta/appVariant/AppVariantUtils","sap/ui/rta/appVariant/Feature","sap/ui/rta/appVariant/S4HanaCloudBackend"],function(M,A,a,R,S){"use strict";
var b=M.extend("sap.ui.rta.appVariant.AppVariantManager",{metadata:{library:"sap.ui.rta",properties:{rootControl:{type:"sap.ui.core.Control"},commandSerializer:{type:"object"},layer:{type:"string"}}}});
b.prototype._openDialog=function(c,C){var d=new A("appVariantDialog");d.attachCreate(c);d.attachCancel(C);d.attachAfterClose(function(){this.destroy();});d.open();return d;};
b.prototype._prepareAppVariantData=function(d,p){return{idRunningApp:d["sap.app"].id,title:p.title,subTitle:p.subTitle,description:p.description,icon:p.icon,inbounds:d["sap.app"].crossNavigation&&d["sap.app"].crossNavigation.inbounds?d["sap.app"].crossNavigation.inbounds:null};};
b.prototype.createAllInlineChanges=function(o){var s=a.getId(o.idRunningApp);var c=[];var p;p=a.getInlinePropertyChange("title",o.title);c.push(a.createInlineChange(p,"appdescr_app_setTitle",this.getRootControl()));p=a.getInlinePropertyChange("subtitle",o.subTitle);c.push(a.createInlineChange(p,"appdescr_app_setSubTitle",this.getRootControl()));p=a.getInlinePropertyChange("description",o.description);c.push(a.createInlineChange(p,"appdescr_app_setDescription",this.getRootControl()));p=a.getInlineChangeInputIcon(o.icon);c.push(a.createInlineChange(p,"appdescr_ui_setIcon",this.getRootControl()));var i=a.getInboundInfo(o.inbounds);var C=i.currentRunningInbound;var d=i.addNewInboundRequired;if(C==="customer.savedAsAppVariant"&&d){p=a.getInlineChangeCreateInbound(C);c.push(a.createInlineChange(p,"appdescr_app_addNewInbound",this.getRootControl()));}p=a.getInlineChangeForInboundPropertySaveAs(C,s);c.push(a.createInlineChange(p,"appdescr_app_changeInbound",this.getRootControl()));p=a.getInlineChangeRemoveInbounds(C);c.push(a.createInlineChange(p,"appdescr_app_removeAllInboundsExceptOne",this.getRootControl()));p=a.getInlineChangesForInboundProperties(C,o.idRunningApp,"title",o.title);c.push(a.createInlineChange(p,"appdescr_app_changeInbound",this.getRootControl()));p=a.getInlineChangesForInboundProperties(C,o.idRunningApp,"subTitle",o.subTitle);c.push(a.createInlineChange(p,"appdescr_app_changeInbound",this.getRootControl()));p=a.getInlineChangesForInboundProperties(C,o.idRunningApp,"icon",o.icon);c.push(a.createInlineChange(p,"appdescr_app_changeInbound",this.getRootControl()));return Promise.all(c);};
b.prototype.createAppVariant=function(s){var p={id:s,layer:this.getLayer()};return a.createAppVariant(this.getRootControl(),p);};
b.prototype.deleteAppVariant=function(s){return a.deleteAppVariant({appId:s});};
b.prototype.processSaveAsDialog=function(d,s){return new Promise(function(r,c){var C=function(o){var p=o.getParameters();var e=this._prepareAppVariantData(d,p);r(e);}.bind(this);var f=function(){if(!s){return R.onGetOverview(true,this.getLayer());}c();}.bind(this);return this._openDialog(C,f);}.bind(this));};
b.prototype._clearRTACommandStack=function(){return this.getCommandSerializer().clearCommandStack();};
b.prototype.clearRTACommandStack=function(c){var C=this.getCommandSerializer().getCommandStack();if(c&&C.getAllExecutedCommands().length){return this._clearRTACommandStack();}return Promise.resolve();};
b.prototype.triggerCatalogPublishing=function(s,r,c){var t=c?a.triggerCatalogAssignment:a.triggerCatalogUnAssignment;return t(s,r).catch(function(e){var m=c?"MSG_CATALOG_ASSIGNMENT_FAILED":"MSG_DELETE_APP_VARIANT_FAILED";return a.catchErrorDialog(e,m,s);});};
b.prototype.notifyKeyUserWhenPublishingIsReady=function(i,s,c){var o=new S();return o.notifyFlpCustomizingIsReady(i,c).catch(function(e){var m=c?"MSG_TILE_CREATION_FAILED":"MSG_DELETE_APP_VARIANT_FAILED";if(!c&&e.error==="locked"){m="MSG_CATALOGS_LOCKED";}return a.catchErrorDialog(e,m,s);});};
b.prototype.showSuccessMessage=function(s){return a.showRelevantDialog(s,true);};
return b;},true);
sap.ui.predefine('sap/ui/rta/appVariant/AppVariantOverviewDialog',["sap/ui/core/ComponentContainer","sap/m/Dialog","sap/m/DialogRenderer","sap/ui/rta/appVariant/manageApps/webapp/Component","sap/ui/rta/Utils"],function(C,D,a,M,R){"use strict";
var A=D.extend("sap.ui.rta.appVariant.AppVariantOverviewDialog",{
metadata:{properties:{idRunningApp:"string",isOverviewForKeyUser:{type:"boolean"},layer:"string"},events:{cancel:{}}},
constructor:function(){D.prototype.constructor.apply(this,arguments);this._oTextResources=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");this.oManageAppsComponent=new M("sap.ui.rta.appVariant.manageApps",{idRunningApp:this.getIdRunningApp(),isOverviewForKeyUser:this.getIsOverviewForKeyUser(),layer:this.getLayer()});this.oManageAppsComponentContainer=new C({component:this.oManageAppsComponent});this.addContent(this.oManageAppsComponentContainer);this._createButton();this.setContentWidth("1000px");this.setContentHeight("450px");this.setHorizontalScrolling(false);this.setTitle(this._oTextResources.getText("APP_VARIANT_OVERVIEW_DIALOG_TITLE"));this.addStyleClass(R.getRtaStyleClassName());},
destroy:function(){D.prototype.destroy.apply(this,arguments);},
renderer:a.render
});
A.prototype._createButton=function(){this.addButton(new sap.m.Button({text:this._oTextResources.getText("APP_VARIANT_DIALOG_CLOSE"),press:function(){this.close();this.fireCancel();}.bind(this)}));};
return A;},true);
sap.ui.predefine('sap/ui/rta/appVariant/AppVariantUtils',["sap/ui/fl/Utils","sap/m/MessageBox","sap/ui/rta/Utils","sap/ui/fl/descriptorRelated/internal/Utils","sap/ui/core/BusyIndicator","sap/base/util/uid","sap/base/Log","sap/ui/fl/write/api/PersistenceWriteAPI","sap/ui/fl/write/api/ChangesWriteAPI"],function(F,M,R,D,B,u,L,P,C){"use strict";var A={};var H=56;A._newAppVariantId=null;
A.getManifirstSupport=function(r){var s='/sap/bc/ui2/app_index/ui5_app_mani_first_supported/?id='+r;return D.sendRequest(s,'GET');};
A.isStandAloneApp=function(){if(sap.ushell_abap){return false;}return true;};
A.getNewAppVariantId=function(){return A._newAppVariantId;};
A.setNewAppVariantId=function(n){A._newAppVariantId=n;};
A.trimIdIfRequired=function(i){if(i.length>H){var I=i.split('.');var t;var g=I[I.length-1].length;var G=I.pop();t=I.join(".");if(t.length>g){t=t.substring(0,t.length-g);}else{return i.substr(0,H);}if(t[t.length-1]==='.'){t=t+G;}else{t=t+"."+G;}return this.trimIdIfRequired(t);}return i;};
A.getId=function(b){var c;var i=b.split('.');if(i[0]!=="customer"){i[0]="customer."+i[0];}var r=false;var a=/^id.*/i;i.forEach(function(s,d,e){if(s.match(a)){s=s.replace(a,u().replace(/-/g,"_"));e[d]=s;r=true;}});c=i.join(".");if(!r){c=c+"."+u().replace(/-/g,"_");}c=this.trimIdIfRequired(c);this.setNewAppVariantId(c);return c;};
A.createAppVariant=function(r,p){p.version="1.0.0";return P.saveAs(Object.assign({selector:r},p));};
A.getInlineChangeInput=function(v,c){return{type:"XTIT",maxLength:50,comment:c,value:{"":v}};};
A.getInlinePropertyChange=function(p,s){var c="New "+p+" entered by a key user via RTA tool";return this.getInlineChangeInput(s,c);};
A.getInlineChangeInputIcon=function(i){return{icon:i};};
A.getInlineChangeRemoveInbounds=function(i){return{inboundId:i};};
A.getInboundInfo=function(i){var I={};if(!i){I.currentRunningInbound="customer.savedAsAppVariant";I.addNewInboundRequired=true;return I;}var p=F.getParsedURLHash();var a=Object.keys(i);var b=[];a.forEach(function(s){if((i[s].action===p.action)&&(i[s].semanticObject===p.semanticObject)){b.push(s);}});switch(b.length){case 0:I.currentRunningInbound="customer.savedAsAppVariant";I.addNewInboundRequired=true;break;case 1:I.currentRunningInbound=b[0];I.addNewInboundRequired=false;break;default:I=undefined;break;}return I;};
A.getInboundPropertiesKey=function(a,c,p){return a+"_sap.app.crossNavigation.inbounds."+c+"."+p;};
A.getInlineChangesForInboundProperties=function(c,r,p,s){var o={inboundId:c,entityPropertyChange:{propertyPath:p,operation:"UPSERT",propertyValue:{}},texts:{}};if(p==="title"||p==="subTitle"){var k=this.getInboundPropertiesKey(r,c,p);o.entityPropertyChange.propertyValue="{{"+k+"}}";o.texts[k]=this.getInlinePropertyChange(p,s);}else if(p==="icon"){o.entityPropertyChange.propertyValue=s;}return o;};
A.getInlineChangeForInboundPropertySaveAs=function(c,a){return{inboundId:c,entityPropertyChange:{propertyPath:"signature/parameters/sap-appvar-id",operation:"UPSERT",propertyValue:{required:true,filter:{value:a,format:"plain"},launcherValue:{value:a}}}};};
A.getInlineChangeCreateInbound=function(c){var p=F.getParsedURLHash();var o={inbound:{}};o.inbound[c]={semanticObject:p.semanticObject,action:p.action};return o;};
A.createInlineChange=function(c,i,r){var o={changeType:i,content:c};if(o.content.texts){o.texts=o.content.texts;delete o.content.texts;}return C.create({changeSpecificData:o,selector:r});};
A.addChangesToPersistence=function(a,r){a.forEach(function(c){return P.add({change:c,selector:r});});return Promise.resolve();};
A.removeChangesFromPersistence=function(a,r){return Promise.resolve().then(function(){a.forEach(function(c){P.remove({change:c,selector:r});});});};
A.getTransportInput=function(p,n,N,t){return{getPackage:function(){return p;},getNamespace:function(){return n;},getId:function(){return N;},getDefinition:function(){return{fileType:t};}};};
A.triggerCatalogAssignment=function(a,r){var s='/sap/bc/lrep/appdescr_variants/'+a+'?action=assignCatalogs&assignFromAppId='+r;return D.sendRequest(s,'POST');};
A.triggerCatalogUnAssignment=function(a){var r='/sap/bc/lrep/appdescr_variants/'+a+'?action=unassignCatalogs';return D.sendRequest(r,'POST');};
A.isS4HanaCloud=function(s){return s.isAtoEnabled()&&s.isAtoAvailable();};
A.copyId=function(i){var t=document.createElement("textarea");t.value=i;document.body.appendChild(t);t.select();document.execCommand('copy');document.body.removeChild(t);return true;};
A.getTextResources=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");};
A.getText=function(m,t){var T=this.getTextResources();return t?T.getText(m,t):T.getText(m);};
A._getErrorMessageText=function(e){var E;if(e.messages&&e.messages.length){E=e.messages.map(function(e){return e.text;}).join("\n");}else if(e.iamAppId){E="IAM App Id: "+e.iamAppId;}else{E=e.stack||e.message||e.status||e;}return E;};
A.buildErrorInfo=function(m,e,a){var E=this._getErrorMessageText(e);var s=A.getText(m)+"\n\n";if(a){s+=A.getText("MSG_APP_VARIANT_ID",a)+"\n";}s+=A.getText("MSG_TECHNICAL_ERROR",E);L.error("App variant error: ",E);return{text:s,appVariantId:a,error:true};};
A.buildSuccessInfo=function(a,s,i){var S=i?"CLOUD":"ON_PREMISE";var o=s?"":"_OVERVIEW_LIST";var t=i?undefined:a;var m=A.getText("SAVE_APP_VARIANT_SUCCESS_MESSAGE")+"\n\n";m+=A.getText("SAVE_APP_VARIANT_SUCCESS_S4HANA_"+S+"_MESSAGE"+o,t);return{text:m,appVariantId:a,copyId:!i};};
A.buildFinalSuccessInfoS4HANACloud=function(){var m=A.getText("MSG_SAVE_APP_VARIANT_NEW_TILE_AVAILABLE");return{text:m};};
A.buildDeleteSuccessMessage=function(a){var m=A.getText("DELETE_APP_VARIANT_SUCCESS_MESSAGE",a);return{text:m};};
A.showRelevantDialog=function(i,s){B.hide();var t;var r;var o;var c;var a=[];if(s){t=this.getText("SAVE_APP_VARIANT_SUCCESS_MESSAGE_TITLE");r=this.getText("SAVE_APP_VARIANT_OK_TEXT");}else{t=this.getText("HEADER_SAVE_APP_VARIANT_FAILED");r=this.getText("SAVE_APP_VARIANT_CLOSE_TEXT");}if(i&&i.copyId){c=this.getText("SAVE_APP_VARIANT_COPY_ID_TEXT");a.push(c);}else if(i&&i.deleteAppVariant){t=this.getText("DELETE_APP_VARIANT_INFO_MESSAGE_TITLE");o=this.getText("DELETE_APP_VARIANT_OK_TEXT");a.push(o);r=this.getText("DELETE_APP_VARIANT_CLOSE_TEXT");}a.push(r);return new Promise(function(b,d){var f=function(e){if(e===c){A.copyId(i.appVariantId);}if(s){b();}else if(i.overviewDialog){b(false);}else if(i.deleteAppVariant&&e===o){b();}else if(i.deleteAppVariant&&e===r){d(i.deleteAppVariant);}else if(i.error){d(i.error);}else{b();}};M.show(i.text,{icon:(s||i.deleteAppVariant)?M.Icon.INFORMATION:M.Icon.ERROR,onClose:f,title:t,actions:a,styleClass:R.getRtaStyleClassName()});});};
A.closeOverviewDialog=function(){sap.ui.getCore().getEventBus().publish("sap.ui.rta.appVariant.manageApps.controller.ManageApps","navigate");};
A.navigateToFLPHomepage=function(){var a=sap.ushell.services.AppConfiguration.getCurrentApplication();var c=a.componentHandle.getInstance();if(c){var U=F.getUshellContainer();var o=U&&U.getService("CrossApplicationNavigation");if(o&&o.toExternal){o.toExternal({target:{shellHash:"#"}},c);}}return Promise.resolve();};
A.deleteAppVariant=function(s){B.hide();return P.deleteAppVariant({selector:s});};
A.handleBeforeUnloadEvent=function(){var m=A.getText("MSG_DO_NOT_CLOSE_BROWSER");return m;};
A.showMessage=function(m){var s=A.getText(m);var i={text:s,copyId:false};return A.showRelevantDialog(i,true);};
A.catchErrorDialog=function(e,m,i){B.hide();var E=A.buildErrorInfo(m,e,i);return A.showRelevantDialog(E,false);};
return A;},true);
sap.ui.predefine('sap/ui/rta/appVariant/Feature',["sap/ui/fl/Utils","sap/ui/rta/appVariant/AppVariantUtils","sap/ui/core/BusyIndicator","sap/base/util/UriParameters","sap/ui/fl/registry/Settings","sap/ui/fl/descriptorRelated/api/DescriptorVariantFactory","sap/base/util/merge"],function(F,A,B,U,S,D,m){"use strict";var a;var o;var r;var c;var _;var g=function(){return F.getAppDescriptor(r);};var G=function(){return S.getInstance();};var s=function(){window.onbeforeunload=_;};var t=function(e,h){return o.triggerCatalogPublishing(e,h,true);};var T=function(e){return o.triggerCatalogPublishing(e,null,false);};var R=function(i,C){if(a){A.closeOverviewDialog();return this.onGetOverview(true,C);}else if(!a&&i){B.hide();return this.onGetOverview(true,C);}return Promise.resolve();};var f=function(e,i,C){return e?A.navigateToFLPHomepage():R.call(this,!i,C);};var b=function(e,h){if(e&&e.response&&e.response.IAMId){return o.notifyKeyUserWhenPublishingIsReady(e.response.IAMId,h,true);}return Promise.resolve();};var d=function(e,h){if(e&&e.response&&e.response.IAMId&&e.response.inProgress){return o.notifyKeyUserWhenPublishingIsReady(e.response.IAMId,h,false);}return Promise.resolve();};sap.ui.getCore().getEventBus().subscribe("sap.ui.rta.appVariant.manageApps.controller.ManageApps","navigate",function(){if(a){a.destroy();a=null;}});return{onGetOverview:function(e,l){var h=g();return new Promise(function(i){var C=function(){A.closeOverviewDialog();};sap.ui.require(["sap/ui/rta/appVariant/AppVariantOverviewDialog"],function(j){if(!a){a=new j({idRunningApp:h["sap.app"].id,isOverviewForKeyUser:e,layer:l});}a.attachCancel(C);a.oPopup.attachOpened(function(){i(a);});a.open();});});},isOverviewExtended:function(){var u=U.fromQuery(window.location.search);var M=u.get("sap-ui-xx-app-variant-overview-extended");if(!M){return false;}return M.toLowerCase()==='true';},isManifestSupported:function(){var e=g();return A.getManifirstSupport(e["sap.app"].id).then(function(h){return h.response;}).catch(function(E){var h=A.buildErrorInfo("MSG_APP_VARIANT_FEATURE_FAILED",E);h.overviewDialog=true;return A.showRelevantDialog(h,false);});},isPlatFormEnabled:function(e,C,l){r=e;c=l;var h=g();if(h["sap.app"]&&h["sap.app"].id){if(F.getUshellContainer()&&!A.isStandAloneApp()&&C==="CUSTOMER"){var i;if(h["sap.app"].crossNavigation&&h["sap.app"].crossNavigation.inbounds){i=A.getInboundInfo(h["sap.app"].crossNavigation.inbounds);}else{i=A.getInboundInfo();}if(i){return true;}}}return false;},getAppVariantDescriptor:function(e){r=e;var h=g();if(h["sap.app"]&&h["sap.app"].id){return D.loadAppVariant(h["sap.app"].id,false);}return Promise.resolve(false);},onSaveAs:function(e,C,h,i){var I;var j=[];var k;var l=g();if(i&&i["sap.app"].id===l["sap.app"].id){C=true;l=m({},i);i=null;}return new Promise(function(n){var p=function(){return o.processSaveAsDialog(l,e);};var q=function(H){B.show();return o.createAllInlineChanges(H);};var u=function(H){j=H.slice();return A.addChangesToPersistence(H,r);};var v=function(){var H=A.getNewAppVariantId();return o.createAppVariant(H).catch(function(J){var M=J.messageKey;if(!M){M="MSG_SAVE_APP_VARIANT_FAILED";}if(J.saveAsFailed){A.removeChangesFromPersistence(j,r);}return A.catchErrorDialog(J,M,H);});};var w=function(H){k=null;k=m({},H.response);return o.clearRTACommandStack(C);};var x=function(){var H=F.getUshellContainer();if(H&&C){H.setDirtyFlag(false);}};var y=function(H){x();I=A.isS4HanaCloud(H);var J=A.buildSuccessInfo(k.id,e,I);return o.showSuccessMessage(J);};var z=function(){var H=A.buildFinalSuccessInfoS4HANACloud();return o.showSuccessMessage(H);};var E=function(){B.show();if(I){return t(k.id,k.reference).then(function(H){B.hide();return f.call(this,e,null,h).then(function(){e=false;return b(H,k.id).then(z);});}.bind(this));}B.hide();return f.call(this,e,I,h);};sap.ui.require(["sap/ui/rta/appVariant/AppVariantManager"],function(H){if(!o){o=new H({rootControl:r,commandSerializer:c,layer:h});}return p().then(q).then(u).then(v).then(w).then(G).then(y).then(E.bind(this)).then(n).catch(function(J){if(!J){return false;}return f.call(this,null,I,h).then(n);}.bind(this));}.bind(this));}.bind(this));},onDeleteFromOverviewDialog:function(e,C,h){var i;return new Promise(function(j){sap.ui.require(["sap/ui/rta/appVariant/AppVariantManager"],function(k){if(!o){o=new k({rootControl:r,commandSerializer:c,layer:h});}var l=function(){return o.deleteAppVariant(e).catch(function(E){var M=E.messageKey;if(!M){M="MSG_DELETE_APP_VARIANT_FAILED";}return A.catchErrorDialog(E,M,e);});};var n=function(){A.closeOverviewDialog();var v=A.buildDeleteSuccessMessage(e);return o.showSuccessMessage(v);};var p=function(){var M=C?"MSG_DO_NOT_CLOSE_BROWSER_CURRENTLY_ADAPTING":"MSG_DO_NOT_CLOSE_BROWSER";_=window.onbeforeunload;window.onbeforeunload=A.handleBeforeUnloadEvent;return A.showMessage(M);};var q=function(v){i=A.isS4HanaCloud(v);if(i){return p().then(function(){return T(e);}).then(function(w){return R.call(this,null,h).then(function(){return d(w,e);});}.bind(this));}B.show();return Promise.resolve();};var u=function(){if(i){s();}B.hide();return R.call(this,null,i,h).then(j);};if(C){A.closeOverviewDialog();A.navigateToFLPHomepage();}return G().then(q.bind(this)).then(l).then(n).then(u.bind(this)).catch(function(){return f.call(this,null,i,h).then(j);}.bind(this));}.bind(this));}.bind(this));}};});
sap.ui.predefine('sap/ui/rta/appVariant/S4HanaCloudBackend',["sap/ui/base/ManagedObject","sap/ui/model/odata/v2/ODataModel","sap/base/Log"],function(M,O,L){"use strict";var m;
var S=M.extend("sap.ui.rta.appVariant.S4HanaCloudBackend",{constructor:function(){M.apply(this,arguments);}});
S.prototype.notifyFlpCustomizingIsReady=function(i,a,c,b){var t=this;return new Promise(function(r,d){function e(n){return!isNaN(parseFloat(n))&&isFinite(n);}var f=e(c)?c:2500;var R=e(b)?b:-1;function g(){if(R===0){r({iamAppId:i,customizingIsReady:false});return;}else if(R>0){R=R-1;}this.checkCatalogCustomizingIsReady(i,a).then(function(I){if(I){r({iamAppId:i,customizingIsReady:true});}else{setTimeout(g.bind(t),f);}}).catch(function(E){var T=a?"creation":"deletion";L.error("Catalog publishing failed for app variant "+T+". AppVarStatus is "+E.message);d({iamAppId:i,error:E.message});});}setTimeout(g.bind(t),f);});};
S._isAppReady=function(a,A){var c=a.data.results;if(!Array.isArray(c)){throw new Error(a.requestUri+" returned unexpected result: "+a);}var i=c.every(function(C){return C.ActualStatus===1;});var I=c.every(function(C){return C.ActualStatus===2;});var e=c.some(function(C){return C.ActualStatus===5;});var b=c.some(function(C){return C.ActualStatus===4;});if(e||b){var t=e?"error":"locked";throw new Error(t);}return A?I:i;};
S._getODataModel=function(){if(!m){m=new Promise(function(r,a){var o=new O("/sap/opu/odata/sap/APS_IAM_APP_SRV");o.attachMetadataFailed(function(e){a(e);m=null;});o.metadataLoaded().then(function(){r(o);});});}return m;};
S._readODataModel=function(o,i){return new Promise(function(r,a){var s=function(d,R){r(R);};var f=function(e){a(e);};return o.read("/aps_iam_app_ddl('"+i+"')/to_BusinessCatalogAssignment",{success:s,error:f});});};
S.prototype.checkCatalogCustomizingIsReady=function(i,a){return S._getODataModel().then(function(o){return S._readODataModel(o,i);}).then(function(A){return S._isAppReady(A,a);});};
return S;});
sap.ui.predefine('sap/ui/rta/appVariant/Utils',["sap/ui/fl/LrepConnector","sap/ui/rta/appVariant/AppVariantUtils","sap/ui/fl/registry/Settings","sap/base/i18n/ResourceBundle"],function(L,A,S,R){"use strict";var U={};var m=sap.ui.require.toUrl("sap/ui/rta/appVariant/manageApps/")+"webapp";var i=R.create({url:m+"/i18n/i18n.properties"});
U.sendRequest=function(r,o){var l=L.createConnector();return l.send(r,o);};
U._checkNavigationSupported=function(n){var N=sap.ushell.Container.getService("CrossApplicationNavigation");return N.getLinks(n);};
U._checkAppType=function(o,a){if(o&&a){return i.getText("MAA_ORIGINAL_TYPE");}else if(a){return i.getText("MAA_APP_VARIANT_TYPE");}else if(o){return i.getText("MAA_ORIGINAL_TYPE");}return undefined;};
U._calculateCurrentStatus=function(a,s){var n=A.getNewAppVariantId();if(s==='R'){return i.getText("MAA_OPERATION_IN_PROGRESS");}else if(n===a){A.setNewAppVariantId(null);if(s!=='E'){return i.getText("MAA_NEW_APP_VARIANT");}}};
U._checkMenuItemOptions=function(p,a){var o={};if(p.isKeyUser){if(p.isOriginal){o.delAppVarButtonEnabled=false;o.delAppVarButtonVisibility=false;return o;}if(p.appVarStatus==='U'||p.appVarStatus==='E'||p.appVarStatus==='R'){o.saveAsButtonEnabled=false;}if(a){if(p.isS4HanaCloud){o.delAppVarButtonEnabled=true;o.delAppVarButtonVisibility=true;}else{o.delAppVarButtonEnabled=false;o.delAppVarButtonVisibility=true;}}else{o.delAppVarButtonVisibility=true;if(p.appVarStatus==='R'){o.delAppVarButtonEnabled=false;}else{o.delAppVarButtonEnabled=true;}}}else{o.delAppVarButtonEnabled=false;o.delAppVarButtonVisibility=false;}return o;};
U._getNavigationInfo=function(p){var n={};var s=p.startWith.semanticObject;var a=p.startWith.action;var P=p.startWith.parameters;var N={semanticObject:s,action:a,params:P};return this._checkNavigationSupported(N).then(function(r){var d;if(r.length&&p.isKeyUser){n.adaptUIButtonEnabled=true;if(p.appVarStatus==='R'||p.appVarStatus==='U'||p.appVarStatus==='E'){n.adaptUIButtonEnabled=false;}}else{n.adaptUIButtonEnabled=false;}d=this._checkMenuItemOptions(p,n.adaptUIButtonEnabled);n.semanticObject=s;n.action=a;if(P){Object.keys(P).forEach(function(b){if(P[b].value){P[b]=P[b].value;}});n.params=P;}n=Object.assign({},n,d);return n;}.bind(this));};
U._prepareAppVariantAttributes=function(a){return{appId:a.appId,title:a.title||'',subTitle:a.subTitle||'',description:a.description||'',icon:a.iconUrl||'',iconText:a.iconText,isOriginal:a.isOriginal,isAppVariant:a.isAppVariant,descriptorUrl:a.descriptorUrl,appVarStatus:a.appVarStatus};};
U.getAppVariantOverviewAttributes=function(a,k){var o;var I=a.iconUrl;if(I&&sap.ui.core.IconPool.isIconURI(I)){a.iconText=I.split('//')[1];}o=this._prepareAppVariantAttributes(a);o.isKeyUser=k;o.typeOfApp=this._checkAppType(a.isOriginal,a.isAppVariant);o.currentStatus=this._calculateCurrentStatus(a.appId,a.appVarStatus);var b;return S.getInstance().then(function(s){b=A.isS4HanaCloud(s);o.isS4HanaCloud=b;var p={isKeyUser:k,isOriginal:a.isOriginal,isS4HanaCloud:b,appVarStatus:a.appVarStatus};if(a.hasStartableIntent){p.startWith=a.startWith;return this._getNavigationInfo(p).then(function(n){o=Object.assign({},o,n);return o;});}o.adaptUIButtonEnabled=false;var d=this._checkMenuItemOptions(p,false);o=Object.assign({},o,d);return Promise.resolve(o);}.bind(this));};
U.getAppVariantOverview=function(r,k){var l=k?'CUSTOMER*':'VENDOR';var s='/sap/bc/lrep/app_variant_overview/?sap.app/id='+r+'&layer='+l;return this.sendRequest(s,'GET').then(function(o){var a=[];var b;if(o.response&&o.response.items){b=o.response.items;}else{return Promise.resolve([]);}b.forEach(function(c){if(!c.isDescriptorVariant){a.push(this.getAppVariantOverviewAttributes(c,k));}},this);return Promise.all(a).then(function(c){return c;});}.bind(this));};
U.getDescriptor=function(d){return this.sendRequest(d,'GET').then(function(r){return r.response;});};
return U;},true);
sap.ui.predefine('sap/ui/rta/appVariant/manageApps/webapp/Component',["sap/ui/core/UIComponent"],function(U){"use strict";var _;var a;var b;return U.extend("sap.ui.rta.appVariant.manageApps.webapp.Component",{metadata:{manifest:"json",library:"sap.ui.rta",version:"0.9",properties:{idRunningApp:"string",isOverviewForKeyUser:{type:"boolean"},layer:"string"}},constructor:function(){_=arguments[1].idRunningApp;a=arguments[1].isOverviewForKeyUser;b=arguments[1].layer;U.prototype.constructor.apply(this,arguments);},init:function(){this.setIdRunningApp(_);this.setIsOverviewForKeyUser(a);this.setLayer(b);U.prototype.init.apply(this,arguments);}});});
sap.ui.predefine('sap/ui/rta/appVariant/manageApps/webapp/controller/ManageApps.controller',["sap/ui/core/mvc/Controller","sap/ui/rta/appVariant/manageApps/webapp/model/models","sap/ui/rta/appVariant/Utils","sap/m/MessageBox","sap/ui/rta/Utils","sap/ui/rta/appVariant/Feature","sap/ui/rta/RuntimeAuthoring","sap/ui/core/BusyIndicator","sap/ui/rta/appVariant/AppVariantUtils","sap/base/i18n/ResourceBundle"],function(C,M,A,a,R,b,c,B,d,e){"use strict";var _;var f;var g;var m;var i;return C.extend("sap.ui.rta.appVariant.manageApps.webapp.controller.ManageApps",{onInit:function(){_=this.getOwnerComponent().getIdRunningApp();f=this.getOwnerComponent().getIsOverviewForKeyUser();g=this.getOwnerComponent().getLayer();if(!i){this._createResourceBundle();}B.show();return A.getAppVariantOverview(_,f).then(function(h){B.hide();if(h.length){return this._arrangeOverviewDataAndBindToModel(h).then(function(h){return this._highlightNewCreatedAppVariant(h);}.bind(this));}d.closeOverviewDialog();return this._showMessageWhenNoAppVariantsExist();}.bind(this))["catch"](function(E){d.closeOverviewDialog();var o=d.buildErrorInfo("MSG_MANAGE_APPS_FAILED",E);o.overviewDialog=true;B.hide();return d.showRelevantDialog(o,false);});},_createResourceBundle:function(){m=sap.ui.require.toUrl("sap/ui/rta/appVariant/manageApps/")+"webapp";i=e.create({url:m+"/i18n/i18n.properties"});},_showMessageWhenNoAppVariantsExist:function(){return R._showMessageBox(a.Icon.INFORMATION,"TITLE_APP_VARIANT_OVERVIEW_SAP_DEVELOPER","MSG_APP_VARIANT_OVERVIEW_SAP_DEVELOPER");},_highlightNewCreatedAppVariant:function(h){var t=this.byId("Table1");h.forEach(function(o,j){if(o.currentStatus===i.getText("MAA_NEW_APP_VARIANT")||o.currentStatus===i.getText("MAA_OPERATION_IN_PROGRESS")){if(t.getItems().length>=j){t.getItems()[j].focus();}}});return Promise.resolve();},_arrangeOverviewDataAndBindToModel:function(h){var j=h.filter(function(p){return p.appId===_;});var o=j[0];if(o&&o.appVarStatus!=="R"){o.currentStatus=i.getText("MAA_CURRENTLY_ADAPTING");}h=h.filter(function(p){return p.appId!==_;});h.unshift(o);var r=h.filter(function(p){return p.isOriginal;});var k=r[0];h=h.filter(function(p){return!p.isOriginal;});h.unshift(k);var l={appVariants:h};var n=M.createModel(l);this.getView().setModel(n);return Promise.resolve(h);},formatRowHighlight:function(v){if(v===i.getText("MAA_CURRENTLY_ADAPTING")){return"Success";}else if(v===i.getText("MAA_NEW_APP_VARIANT")){return"Information";}else if(v===i.getText("MAA_OPERATION_IN_PROGRESS")){return"Warning";}return"None";},formatDelButtonTooltip:function(D,I){if(!D&&!I){return i.getText("TOOLTIP_DELETE_APP_VAR");}return undefined;},getModelProperty:function(s,h){return this.getView().getModel().getProperty(s,h);},onMenuAction:function(E){var I=E.getParameter("item");var s="";while(I instanceof sap.m.MenuItem){s=I.getText()+" > "+s;I=I.getParent();}s=s.substr(0,s.lastIndexOf(" > "));if(!i){this._createResourceBundle();}if(s===i.getText("MAA_DIALOG_ADAPT_UI")){return this.handleUiAdaptation(E);}else if(s===i.getText("MAA_DIALOG_COPY_ID")){return this.copyId(E);}else if(s===i.getText("MAA_DIALOG_DELETE_APPVAR")){return this.deleteAppVariant(E);}else if(s===i.getText("MAA_DIALOG_SAVE_AS_APP")){return this.saveAsAppVariant(E);}return undefined;},handleUiAdaptation:function(E){var n=sap.ushell.Container.getService("CrossApplicationNavigation");var s=this.getModelProperty("semanticObject",E.getSource().getBindingContext());var h=this.getModelProperty("action",E.getSource().getBindingContext());var p=this.getModelProperty("params",E.getSource().getBindingContext());var N;if(s&&h&&p){N={target:{semanticObject:s,action:h},params:p,writeHistory:false};c.enableRestart("CUSTOMER");n.toExternal(N);d.closeOverviewDialog();return true;}return false;},saveAsAppVariant:function(E){d.closeOverviewDialog();var D=this.getModelProperty("descriptorUrl",E.getSource().getBindingContext());B.show();return A.getDescriptor(D).then(function(o){B.hide();return b.onSaveAs(false,false,g,o);});},copyId:function(E){var s=this.getModelProperty("appId",E.getSource().getBindingContext());d.copyId(s);},deleteAppVariant:function(E){var I={};if(!i){this._createResourceBundle();}var s=i.getText("MSG_APP_VARIANT_DELETE_CONFIRMATION");I.text=s;I.deleteAppVariant=true;var h=this.getModelProperty("appId",E.getSource().getBindingContext());var j=this.getModelProperty("currentStatus",E.getSource().getBindingContext());var k=j===i.getText("MAA_CURRENTLY_ADAPTING");return d.showRelevantDialog(I).then(function(){return b.onDeleteFromOverviewDialog(h,k,g);}).catch(function(){return true;});}});});
sap.ui.predefine('sap/ui/rta/appVariant/manageApps/webapp/model/models',["sap/ui/model/json/JSONModel"],function(J){"use strict";return{createModel:function(d){var m=new J(d);m.setDefaultBindingMode("OneWay");return m;}};});
sap.ui.predefine('sap/ui/rta/command/AddODataProperty',["sap/ui/rta/command/FlexCommand"],function(F){"use strict";
var A=F.extend("sap.ui.rta.command.AddODataProperty",{metadata:{library:"sap.ui.rta",properties:{index:{type:"int"},newControlId:{type:"string"},bindingString:{type:"string"},entityType:{type:"string"},parentId:{type:"string"},oDataServiceVersion:{type:"string"},oDataServiceUri:{type:"string"},propertyName:{type:"string"}}}});
A.prototype._getChangeSpecificData=function(){return{changeType:this.getChangeType(),index:this.getIndex(),newControlId:this.getNewControlId(),bindingPath:this.getBindingString(),parentId:this.getParentId(),oDataServiceVersion:this.getODataServiceVersion(),oDataInformation:{oDataServiceUri:this.getODataServiceUri(),propertyName:this.getPropertyName(),entityType:this.getEntityType()}};};
return A;},true);
sap.ui.predefine('sap/ui/rta/command/AddXML',["sap/ui/rta/command/FlexCommand"],function(F){"use strict";
var A=F.extend("sap.ui.rta.command.AddXML",{metadata:{library:"sap.ui.rta",properties:{fragment:{type:"string"},fragmentPath:{type:"string"},targetAggregation:{type:"string"},index:{type:"int"},changeType:{type:"string",defaultValue:"addXML"}},associations:{},events:{}}});
A.prototype.bindProperty=function(n,b){if(n==="fragment"){return this.setFragment(b.bindingString);}return F.prototype.bindProperty.apply(this,arguments);};
A.prototype._getChangeSpecificData=function(){var s={changeType:this.getChangeType(),fragmentPath:this.getFragmentPath(),targetAggregation:this.getTargetAggregation(),index:this.getIndex()};return s;};
A.prototype._applyChange=function(c){var m={};m[c.getModuleName()]=this.getFragment();sap.ui.require.preload(m);return F.prototype._applyChange.apply(this,arguments);};
return A;},true);
sap.ui.predefine('sap/ui/rta/command/AppDescriptorCommand',["sap/ui/rta/command/BaseCommand","sap/ui/fl/descriptorRelated/api/DescriptorInlineChangeFactory","sap/ui/fl/descriptorRelated/api/DescriptorChangeFactory"],function(B,D,a){"use strict";
var A=B.extend("sap.ui.rta.command.AppDescriptor",{metadata:{library:"sap.ui.rta",properties:{reference:{type:"string"},appComponent:{type:"object"},layer:{type:"string"},changeType:{type:"string"},parameters:{type:"object"},texts:{type:"object"}},events:{}}});
A.prototype.needsReload=true;
A.prototype.prepare=function(f){this.setLayer(f.layer);return true;};
A.prototype.getPreparedChange=function(){return this._oPreparedChange;};
A.prototype.createAndStoreChange=function(){return D.createDescriptorInlineChange(this.getChangeType(),this.getParameters(),this.getTexts()).then(function(o){return new a().createNew(this.getReference(),o,this.getLayer(),this.getAppComponent());}.bind(this)).then(function(o){var c=o.store();this._oPreparedChange=c;}.bind(this));};
return A;},true);
sap.ui.predefine('sap/ui/rta/command/BaseCommand',["sap/ui/base/ManagedObject"],function(M){"use strict";
var B=M.extend("sap.ui.rta.command.BaseCommand",{metadata:{library:"sap.ui.rta",properties:{name:{type:"string"},runtimeOnly:{type:"boolean"}},associations:{element:{type:"sap.ui.core.Element"}},events:{}}});
B.prototype.getElement=function(){var i=this.getAssociation("element");return sap.ui.getCore().byId(i);};
B.prototype.prepare=function(){return true;};
B.prototype.execute=function(){return Promise.resolve();};
B.prototype.getVariantChange=function(){return this._oVariantChange;};
B.prototype.undo=function(){return Promise.resolve();};
B.prototype.isEnabled=function(){return true;};
return B;},true);
sap.ui.predefine('sap/ui/rta/command/BindProperty',["sap/ui/rta/command/FlexCommand"],function(F){"use strict";
var B=F.extend("sap.ui.rta.command.BindProperty",{metadata:{library:"sap.ui.rta",properties:{propertyName:{type:"string"},newBinding:{type:"string"},changeType:{type:"string",defaultValue:"propertyBindingChange"}},associations:{},events:{}}});
B.prototype.bindProperty=function(n,b){if(n==="newBinding"){return this.setNewBinding(b.bindingString);}return F.prototype.bindProperty.apply(this,arguments);};
B.prototype._getChangeSpecificData=function(){var e=this.getElement();var s={changeType:this.getChangeType(),selector:{id:e.getId(),type:e.getMetadata().getName()},content:{property:this.getPropertyName(),newBinding:this.getNewBinding()}};return s;};
return B;},true);
sap.ui.predefine('sap/ui/rta/command/Combine',["sap/ui/rta/command/FlexCommand"],function(F){"use strict";
var C=F.extend("sap.ui.rta.command.Combine",{metadata:{library:"sap.ui.rta",properties:{source:{type:"any"},combineElements:{type:"any[]"}},associations:{},events:{}}});
C.prototype._getChangeSpecificData=function(){var f=[];this.getCombineElements().forEach(function(o){f.push(o.getId());});var s={changeType:this.getChangeType(),sourceControlId:this.getSource().getId(),combineElementIds:f};return s;};
return C;},true);
sap.ui.predefine('sap/ui/rta/command/CommandFactory',["sap/ui/base/ManagedObject","sap/ui/dt/ElementUtil","sap/ui/dt/OverlayRegistry","sap/ui/fl/Utils","sap/ui/dt/Util","sap/base/util/merge"],function(M,E,O,F,D,m){"use strict";
function e(z){var B=E.getAggregationInformation(z.getElement());if(B.elementId){var A=O.getOverlay(B.elementId);var P=A.getParentElementOverlay();var G=P?!!E.getAggregationInformation(P.getElement()).templateId:false;if(G){throw D.createError("CommandFactory#evaluateTemplateBinding","Multiple template bindings are not supported","sap.ui.rta");}var T=E.extractTemplateId(B);if(T){return{templateSelector:B.elementId,originalSelector:T,content:{boundAggregation:B.aggregation}};}}return undefined;}
function g(z,I){var A=(typeof z==="string")?sap.ui.getCore().byId(z):z;var B=O.getOverlay(A);if(B){var G=E.getAggregationInformation(A);if(typeof I==="number"){G.stack[0].index=I;}return E.extractTemplateId(G);}return A.getId();}
function a(z){if(!z){throw new Error("adjustment for template failed");}}
function c(z,A,B){var G;var J=false;if(typeof(B)==="string"){G=B;}else{G=B&&B.changeType;J=B&&B.jsOnly;}if(!G){return false;}A.setChangeType(G);A.setJsOnly(J);return true;}
function b(z,S,A){var B={changeType:"addXML"};if(A){jQuery.extend(B,A.getAction("addXML",z));}return B;}
function d(S){S.element=sap.ui.getCore().byId(g(S.element));a(S.element);}
function f(z,S,A){var N=S.element||sap.ui.getCore().byId(S.element.id);var B=A.getActionDataFromAggregations("createContainer",N)[0];return B;}
function h(S){S.element=sap.ui.getCore().byId(g(S.element));a(S.element);S.parentId=g(S.parentId);a(S.parentId);}
function i(z,S,A){var B=S.movedElements[0].element||sap.ui.getCore().byId(S.movedElements[0].id);var G=A.getAction("move",B);if(!G&&A.getMetadata().getName()==="sap.ui.dt.ElementDesignTimeMetadata"){G=A.getActionDataFromAggregations("move",z).filter(function(H){return H.aggregation===S.source.aggregation;})[0];}return G;}
function j(S){var T=S.movedElements.map(function(z){var A=sap.ui.getCore().byId(g(z.element,z.sourceIndex));a(A);return A;});S.movedElements.forEach(function(z,A){z.element=T[A];});S.element=sap.ui.getCore().byId(g(S.element));a(S.element);S.source.parent=sap.ui.getCore().byId(g(S.source.parent));a(S.source.parent);S.target.parent=sap.ui.getCore().byId(g(S.target.parent));a(S.target.parent);}
function k(z,S,A){var R=S.renamedElement;var B=A.getAction("rename",R);return B;}
function l(S){S.element=sap.ui.getCore().byId(g(S.element));a(S.element);S.renamedElement=sap.ui.getCore().byId(g(S.renamedElement));a(S.renamedElement);}
function n(z,S,A){var R=S.removedElement;if(!R){R=z;}else if(!(R instanceof M)){throw new Error("No valid 'removedElement' found");}var B=A.getAction("remove",R);return B;}
function o(S){S.element=sap.ui.getCore().byId(g(S.element));a(S.element);S.removedElement=sap.ui.getCore().byId(g(S.removedElement));a(S.removedElement);}
function p(z,S,A){var B=S.source;var G=A.getAction("combine",B);return G;}
function q(S){S.element=sap.ui.getCore().byId(g(S.element));a(S.element);S.source=sap.ui.getCore().byId(g(S.source));a(S.source);var T=S.combineElements.map(function(z){z=sap.ui.getCore().byId(g(z));a(z);return z;});S.combineElements=T;}
function r(z,S,A){var B=S.source;var G=A.getAction("split",B);return G;}
function s(S){S.element=sap.ui.getCore().byId(g(S.element));a(S.element);S.parentElement=sap.ui.getCore().byId(g(S.parentElement));a(S.parentElement);S.source=sap.ui.getCore().byId(g(S.source));a(S.source);}
function t(z,S,A){var N=S.element;var B=A.getAction("addODataProperty",N);return B;}
function u(S){S.element=sap.ui.getCore().byId(g(S.element));a(S.element);S.parentId=g(S.parentId);a(S.parentId);}
function v(z,S,A){var R=S.element;var B=A.getAction("reveal",R);return B;}
function w(S){S.element=sap.ui.getCore().byId(g(S.element));a(S.element);if(S.revealedElementId){S.revealedElementId=g(S.revealedElementId);a(S.revealedElementId);}if(S.directParent){S.directParent=sap.ui.getCore().byId(g(S.directParent));a(S.directParent);}}
function x(z,S,A){var B=A.getAction("add",S.element);if(B&&B.custom&&typeof B.custom.getItems==="function"){var G={changeOnRelevantContainer:S.changeOnRelevantContainer,changeType:S.changeType};delete S["changeOnRelevantContainer"];return G;}}
var C={composite:{clazz:'sap.ui.rta.command.CompositeCommand',noSelector:true},property:{clazz:'sap.ui.rta.command.Property',adjustForBinding:d},bindProperty:{clazz:'sap.ui.rta.command.BindProperty'},addXML:{clazz:'sap.ui.rta.command.AddXML',configure:b,adjustForBinding:d},createContainer:{clazz:'sap.ui.rta.command.CreateContainer',configure:f,adjustForBinding:h},move:{clazz:'sap.ui.rta.command.Move',configure:i,adjustForBinding:j},remove:{clazz:'sap.ui.rta.command.Remove',configure:n,adjustForBinding:o},rename:{clazz:'sap.ui.rta.command.Rename',configure:k,adjustForBinding:l},addODataProperty:{clazz:'sap.ui.rta.command.AddODataProperty',configure:t,adjustForBinding:u},reveal:{clazz:'sap.ui.rta.command.Reveal',configure:v,adjustForBinding:w},customAdd:{clazz:'sap.ui.rta.command.CustomAdd',configure:x},combine:{clazz:'sap.ui.rta.command.Combine',configure:p,adjustForBinding:q},split:{clazz:'sap.ui.rta.command.Split',configure:r,adjustForBinding:s},"switch":{clazz:'sap.ui.rta.command.ControlVariantSwitch'},duplicate:{clazz:'sap.ui.rta.command.ControlVariantDuplicate'},setTitle:{clazz:'sap.ui.rta.command.ControlVariantSetTitle'},configure:{clazz:'sap.ui.rta.command.ControlVariantConfigure'},settings:{clazz:'sap.ui.rta.command.Settings'},addLibrary:{clazz:'sap.ui.rta.command.appDescriptor.AddLibrary',noSelector:true},appDescriptor:{clazz:'sap.ui.rta.command.AppDescriptorCommand',noSelector:true}};
function _(z,A,S,B,G,V){A=A[0].toLowerCase()+A.slice(1);var H=C[A];var I=G;if(!H){return Promise.reject(D.createError("CommandFactory#_getCommandFor","Command '"+A+"' doesn't exist, check typing","sap.ui.rta"));}return new Promise(function(R){var J=H.clazz;sap.ui.require([J.replace(/\./g,"/")],function(K){R(K);});}).then(function(J){var K=z instanceof M;if(!H.noSelector){S=Object.assign({},S,!K&&{selector:z});}S=Object.assign({},S,{element:K?z:undefined,name:A});var L;if(H.configure){L=H.configure(z,S,B);}var N;if(K){N=O.getOverlay(z);}if(L&&L.changeOnRelevantContainer){Object.assign(S,{element:N.getRelevantContainer()});z=S.element;N=O.getOverlay(z);}var T;if(N&&z.sParentAggregationName){T=e(N);}if(T){if(H.adjustForBinding){H.adjustForBinding(S);}I=m(T,I);}var P=new J(S);var Q=true;if(H.configure){Q=c(z,P,L);}if(Q){return Promise.resolve().then(function(){return P.prepare(I,V);}).then(function(R){if(R){return P;}});}P.destroy();return undefined;});}
var y=M.extend("sap.ui.rta.command.CommandFactory",{metadata:{library:"sap.ui.rta",properties:{flexSettings:{type:"object"}},associations:{},events:{}}});
y.prototype.init=function(){this.setProperty("flexSettings",{layer:"CUSTOMER",developerMode:true});};
y.prototype.setFlexSettings=function(z){this.setProperty("flexSettings",jQuery.extend(this.getFlexSettings(),z));};
y.prototype.getCommandFor=function(z,A,S,B,V){return _(z,A,S,B,this.getFlexSettings(),V);};
y.getCommandFor=function(z,A,S,B,G){if(!G){G={layer:"CUSTOMER",developerMode:true};}if(G.scenario||G.baseId){var L=F.buildLrepRootNamespace(G.baseId,G.scenario,G.projectId);G.rootNamespace=L;G.namespace=L+"changes/";}return _(z,A,S,B,G);};
return y;},true);
sap.ui.predefine('sap/ui/rta/command/CompositeCommand',["sap/ui/rta/command/BaseCommand","sap/ui/fl/Utils"],function(B,F){"use strict";
var C=B.extend("sap.ui.rta.command.CompositeCommand",{metadata:{library:"sap.ui.rta",properties:{},aggregations:{commands:{type:"sap.ui.rta.command.BaseCommand",multiple:true}},events:{}}});
C.prototype.execute=function(){var p=[];this._forEachCommand(function(c){p.push(c.execute.bind(c));});return F.execPromiseQueueSequentially(p,true).catch(function(e){var c=this.getCommands();c.forEach(function(o){if(o instanceof sap.ui.rta.command.FlexCommand){if(!o._aRecordedUndo){this.removeCommand(o);}}}.bind(this));return this.undo().then(function(){return Promise.reject(e);});}.bind(this));};
C.prototype.undo=function(){var p=[];this._forEachCommandInReverseOrder(function(c){p.push(c.undo.bind(c));});return F.execPromiseQueueSequentially(p);};
C.prototype._forEachCommand=function(d){var c=this.getCommands();c.forEach(d,this);};
C.prototype._forEachCommandInReverseOrder=function(d){var c=this.getCommands();for(var i=c.length-1;i>=0;i--){d.call(this,c[i]);}};
C.prototype._addCompositeIdToChange=function(c){if(c.getPreparedChange&&c.getPreparedChange()){var o=c.getPreparedChange().getDefinition();if(!o.support.compositeCommand){if(!this._sCompositeId){this._sCompositeId=F.createDefaultFileName("composite");}o.support.compositeCommand=this._sCompositeId;}}};
C.prototype.addCommand=function(c,s){this._addCompositeIdToChange(c);return this.addAggregation("commands",c,s);};
C.prototype.insertCommand=function(c,i,s){this._addCompositeIdToChange(c);return this.insertAggregation("commands",c,i,s);};
return C;},true);
sap.ui.predefine('sap/ui/rta/command/ControlVariantConfigure',["sap/ui/rta/command/BaseCommand","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/Utils"],function(B,J,f){"use strict";
var C=B.extend("sap.ui.rta.command.ControlVariantConfigure",{metadata:{library:"sap.ui.rta",properties:{control:{type:"any"},changes:{type:"array"}},associations:{},events:{}}});
C.prototype.prepare=function(F){this.sLayer=F.layer;return true;};
C.prototype.getPreparedChange=function(){if(!this._aPreparedChanges){return undefined;}return this._aPreparedChanges;};
C.prototype.execute=function(){var v=this.getControl();this.oAppComponent=f.getAppComponentForControl(v);this.oModel=this.oAppComponent.getModel(f.VARIANT_MODEL_NAME);this.sVariantManagementReference=J.getSelector(v,this.oAppComponent).id;this._aPreparedChanges=[];this.getChanges().forEach(function(c){c.appComponent=this.oAppComponent;this._aPreparedChanges.push(this.oModel.setVariantProperties(this.sVariantManagementReference,c,true));}.bind(this));return Promise.resolve().then(function(){this.oModel.checkUpdate(true);}.bind(this));};
C.prototype.undo=function(){var p;this.getChanges().forEach(function(c,i){p={};Object.keys(c).forEach(function(P){var o="original"+P.charAt(0).toUpperCase()+P.substr(1);if(P==="visible"){p[P]=true;}else if(c[o]){p[P]=c[o];p[o]=c[P];}else if(P.indexOf("original")===-1){p[P]=c[P];}});p.change=this._aPreparedChanges[i];this.oModel.setVariantProperties(this.sVariantManagementReference,p,false);}.bind(this));return Promise.resolve().then(function(){this.oModel.checkUpdate(true);this._aPreparedChanges=null;}.bind(this));};
return C;},true);
sap.ui.predefine('sap/ui/rta/command/ControlVariantDuplicate',["sap/ui/rta/command/BaseCommand","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/Utils"],function(B,J,f){"use strict";
var C=B.extend("sap.ui.rta.command.ControlVariantDuplicate",{metadata:{library:"sap.ui.rta",properties:{sourceVariantReference:{type:"string"},newVariantReference:{type:"string"},newVariantTitle:{type:"string"}},associations:{},events:{}}});
C.prototype.prepare=function(F){this.sLayer=F.layer;return true;};
C.prototype.getPreparedChange=function(){if(!this._aPreparedChanges){return undefined;}return this._aPreparedChanges;};
C.prototype.execute=function(){var v=this.getElement();var s=this.getSourceVariantReference();var n=this.getNewVariantReference();this.oAppComponent=f.getAppComponentForControl(v);if(!n){n=f.createDefaultFileName();this.setNewVariantReference(n);}this.sVariantManagementReference=J.getSelector(v,this.oAppComponent).id;this.oModel=this.oAppComponent.getModel(f.VARIANT_MODEL_NAME);var p={variantManagementReference:this.sVariantManagementReference,appComponent:this.oAppComponent,layer:this.sLayer,newVariantReference:n,sourceVariantReference:s,title:this.getNewVariantTitle()};return this.oModel.copyVariant(p).then(function(c){this._oVariantChange=c[0];this._aPreparedChanges=c;}.bind(this));};
C.prototype.undo=function(){if(this._oVariantChange){var p={variant:this._oVariantChange,sourceVariantReference:this.getSourceVariantReference(),variantManagementReference:this.sVariantManagementReference,component:this.oAppComponent};return this.oModel.removeVariant(p).then(function(){this._oVariantChange=null;this._aPreparedChanges=null;}.bind(this));}return Promise.resolve();};
return C;},true);
sap.ui.predefine('sap/ui/rta/command/ControlVariantSetTitle',["sap/ui/rta/command/BaseCommand","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/Utils"],function(B,J,f){"use strict";
var C=B.extend("sap.ui.rta.command.ControlVariantSetTitle",{metadata:{library:"sap.ui.rta",properties:{oldText:{type:"string"},newText:{type:"string"}},associations:{},events:{}}});
C.prototype.prepare=function(F){this.sLayer=F.layer;return true;};
C.prototype.getPreparedChange=function(){this._oPreparedChange=this.getVariantChange();if(!this._oPreparedChange){return undefined;}return this._oPreparedChange;};
C.prototype.execute=function(){var v=this.getElement();var V=v.getTitle().getBinding("text");this.oAppComponent=f.getAppComponentForControl(v);this.oModel=this.oAppComponent.getModel(f.VARIANT_MODEL_NAME);this.sVariantManagementReference=J.getSelector(v,this.oAppComponent).id;this.sCurrentVariant=this.oModel.getCurrentVariantReference(this.sVariantManagementReference);var c=this.oModel.getVariantProperty(this.sCurrentVariant,"title");this.setOldText(c);var p={appComponent:this.oAppComponent,variantReference:this.sCurrentVariant,changeType:"setTitle",title:this.getNewText(),layer:this.sLayer};return Promise.resolve(this.oModel.setVariantProperties(this.sVariantManagementReference,p,true)).then(function(o){this._oVariantChange=o;V.checkUpdate(true);}.bind(this));};
C.prototype.undo=function(){var v=this.getElement().getTitle().getBinding("text");var p={variantReference:this.sCurrentVariant,changeType:"setTitle",title:this.getOldText(),change:this._oVariantChange};return Promise.resolve(this.oModel.setVariantProperties(this.sVariantManagementReference,p,false)).then(function(c){this._oVariantChange=c;v.checkUpdate(true);}.bind(this));};
return C;},true);
sap.ui.predefine('sap/ui/rta/command/ControlVariantSwitch',["sap/ui/rta/command/BaseCommand","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/Utils"],function(B,J,f){"use strict";
var C=B.extend("sap.ui.rta.command.ControlVariantSwitch",{metadata:{library:"sap.ui.rta",properties:{targetVariantReference:{type:"string"},sourceVariantReference:{type:"string"}},associations:{},events:{}}});
C.prototype._getAppComponent=function(){var e=this.getElement();return e?f.getAppComponentForControl(e):this.getSelector().appComponent;};
C.prototype.execute=function(){var e=this.getElement();var a=this._getAppComponent();var n=this.getTargetVariantReference();this.oModel=a.getModel(f.VARIANT_MODEL_NAME);this.sVariantManagementReference=J.getSelector(e,a).id;return this._updateModelVariant(n,a);};
C.prototype.undo=function(){var o=this.getSourceVariantReference();var a=this._getAppComponent();return this._updateModelVariant(o,a);};
C.prototype._updateModelVariant=function(v,a){if(this.getTargetVariantReference()!==this.getSourceVariantReference()){return Promise.resolve(this.oModel.updateCurrentVariant(this.sVariantManagementReference,v,a));}return Promise.resolve();};
return C;},true);
sap.ui.predefine('sap/ui/rta/command/CreateContainer',["sap/ui/rta/command/FlexCommand"],function(F){"use strict";
var C=F.extend("sap.ui.rta.command.CreateContainer",{metadata:{library:"sap.ui.rta",properties:{index:{type:"int"},newControlId:{type:"string"},label:{type:"string"},parentId:{type:"string"}},associations:{},events:{}}});
C.prototype._getChangeSpecificData=function(){var s={changeType:this.getChangeType(),index:this.getIndex(),newControlId:this.getNewControlId(),newLabel:this.getLabel(),parentId:this.getParentId()};return s;};
return C;},true);
sap.ui.predefine('sap/ui/rta/command/CustomAdd',["sap/ui/rta/command/FlexCommand"],function(F){"use strict";
var C=F.extend("sap.ui.rta.command.CustomAdd",{metadata:{library:"sap.ui.rta",properties:{index:{type:"int"},addElementInfo:{type:"object"},aggregationName:{type:"string"},customItemId:{type:"string"}}}});
C.prototype._getChangeSpecificData=function(){var s={customItemId:this.getCustomItemId(),changeType:this.getChangeType(),index:this.getIndex(),addElementInfo:this.getAddElementInfo(),aggregationName:this.getAggregationName()};return s;};
return C;},true);
sap.ui.predefine('sap/ui/rta/command/FlexCommand',["sap/ui/rta/command/BaseCommand","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/Utils","sap/base/Log","sap/base/util/merge","sap/ui/fl/write/api/ChangesWriteAPI"],function(B,J,f,L,m,C){"use strict";
var F=B.extend("sap.ui.rta.command.FlexCommand",{metadata:{library:"sap.ui.rta",properties:{changeType:{type:"string"},jsOnly:{type:"boolean"},selector:{type:"object"}},associations:{},events:{}}});
F.prototype.getElementId=function(){var e=this.getElement();return e?e.getId():this.getSelector().id;};
F.prototype.getAppComponent=function(){var e=this.getElement();return e?f.getAppComponentForControl(e):this.getSelector().appComponent;};
F.prototype.prepare=function(a,v){var s;if(!this.getSelector()&&a&&a.templateSelector){s={id:a.templateSelector,appComponent:this.getAppComponent(),controlType:f.getControlType(sap.ui.getCore().byId(a.templateSelector))};this.setSelector(s);}else if(!this.getSelector()&&this.getElement()){s={id:this.getElement().getId(),appComponent:this.getAppComponent(),controlType:f.getControlType(this.getElement())};this.setSelector(s);}return this._createChange(a,v).then(function(c){this._oPreparedChange=c;return true;}.bind(this)).catch(function(e){L.error(e.message||e.name);return false;});};
F.prototype.getPreparedChange=function(){return this._oPreparedChange;};
F.prototype.execute=function(){var c=this.getPreparedChange();return this._applyChange(c);};
F.prototype._getChangeSpecificData=function(){return{changeType:this.getChangeType(),selector:{id:this.getElementId()}};};
F.prototype._createChange=function(a,v){return this._createChangeFromData(this._getChangeSpecificData(),a,v);};
F.prototype._createChangeFromData=function(c,a,v){if(a){c=m({},c,a);}c.jsOnly=this.getJsOnly();var M=this.getAppComponent().getModel(f.VARIANT_MODEL_NAME);var V;if(M&&v){V=M.getCurrentVariantReference(v);}var b={variantManagementReference:v,variantReference:V};if(V){c=Object.assign({},c,b);}return C.create({changeSpecificData:c,selector:this._validateControlForChange(a)}).then(function(o){if(a&&a.originalSelector){o.addDependentControl(a.originalSelector,"originalSelector",{modifier:J,appComponent:this.getAppComponent()});o.getDefinition().selector=Object.assign(o.getDefinition().selector,J.getSelector(this.getSelector().id,this.getSelector().appComponent));o.setContent(Object.assign({},o.getContent(),a.content));}return o;}.bind(this));};
F.prototype.undo=function(){var c=this.getElement()||J.bySelector(this.getSelector());var o=this.getPreparedChange();return C.revert({change:o,element:c});};
F.prototype._applyChange=function(c){var o=c.change||c;var a=this.getAppComponent();var s=J.bySelector(o.getSelector(),a);var p={modifier:J,appComponent:a,view:f.getViewForControl(s)};return C.apply(Object.assign({change:o,element:s},p)).then(function(r){if(!r.success){return Promise.reject(r.error);}});};
F.prototype._validateControlForChange=function(a){if(a&&a.originalSelector&&a.content&&a.content.boundAggregation){return{id:a.originalSelector,appComponent:this.getAppComponent(),controlType:f.getControlType(sap.ui.getCore().byId(a.originalSelector))};}return this.getElement()||this.getSelector();};
return F;},true);
sap.ui.predefine('sap/ui/rta/command/LREPSerializer',["sap/ui/base/ManagedObject","sap/ui/rta/command/FlexCommand","sap/ui/rta/command/AppDescriptorCommand","sap/ui/fl/Utils","sap/ui/fl/Change","sap/ui/fl/registry/Settings","sap/ui/dt/ElementUtil","sap/base/Log","sap/ui/fl/write/api/PersistenceWriteAPI"],function(M,F,A,a,C,S,E,L,P){"use strict";
var b=M.extend("sap.ui.rta.command.LREPSerializer",{metadata:{library:"sap.ui.rta",associations:{rootControl:{type:"sap.ui.core.Control"}},properties:{commandStack:{type:"object"}},aggregations:{}}});
function g(r){return E.getElementInstance(r);}
b.prototype._lastPromise=Promise.resolve();
b.prototype.setCommandStack=function(c){if(this.getCommandStack()){this.getCommandStack().removeCommandExecutionHandler(this._fnHandleCommandExecuted);}this.setProperty("commandStack",c);c.addCommandExecutionHandler(this._fnHandleCommandExecuted);};
b.prototype.init=function(){this._fnHandleCommandExecuted=this.handleCommandExecuted.bind(this);};
b.prototype.exit=function(){this.getCommandStack().removeCommandExecutionHandler(this._fnHandleCommandExecuted);};
b.prototype._isPersistedChange=function(p){return!!this.getCommandStack()._aPersistedChanges&&this.getCommandStack()._aPersistedChanges.indexOf(p.getId())!==-1;};
b.prototype.handleCommandExecuted=function(e){return(function(e){var p=e;this._lastPromise=this._lastPromise.catch(function(){}).then(function(){var c=this.getCommandStack().getSubCommands(p.command);if(p.undo){c.forEach(function(o){if(!(o instanceof F||o instanceof A)||o.getRuntimeOnly()){return;}var f=o.getPreparedChange();var h=o.getAppComponent();if(h){P.remove({change:f,selector:h});}});}else{var d=[];c.forEach(function(o){if(o.getRuntimeOnly()){return;}if(o instanceof F){var f=o.getAppComponent();if(f){var h=o.getPreparedChange();if(h.getState()===C.states.DELETED){h.setState(C.states.NEW);}if(!this._isPersistedChange(h)){P.add({change:o.getPreparedChange(),selector:f});}}}else if(o instanceof A){d.push(o.createAndStoreChange());}}.bind(this));return Promise.all(d);}}.bind(this));return this._lastPromise;}.bind(this))(e);};
b.prototype.needsReload=function(){this._lastPromise=this._lastPromise.catch(function(){}).then(function(){var c=this.getCommandStack().getAllExecutedCommands();return c.some(function(o){return!!o.needsReload;});}.bind(this));return this._lastPromise;};
b.prototype.saveCommands=function(){this._lastPromise=this._lastPromise.catch(function(){}).then(function(){var r=g(this.getRootControl());if(!r){throw new Error("Can't save commands without root control instance!");}return P.save({selector:r,skipUpdateCache:false});}.bind(this)).then(function(){L.info("UI adaptation successfully transfered changes to layered repository");this.getCommandStack().removeAllCommands();}.bind(this));return this._lastPromise;};
b.prototype._triggerUndoChanges=function(){var c=this.getCommandStack();var p=[];var d=c.getAllExecutedCommands();d.forEach(function(o){p.push(o.undo.bind(o));});p=p.reverse();return a.execPromiseQueueSequentially(p,false,true);};
b.prototype.clearCommandStack=function(){var c=this.getCommandStack();c.detachCommandExecuted(this.handleCommandExecuted.bind(this));return this._triggerUndoChanges().then(function(){c.removeAllCommands();c.attachCommandExecuted(this.handleCommandExecuted.bind(this));return true;}.bind(this));};
return b;},true);
sap.ui.predefine('sap/ui/rta/command/Move',["sap/ui/rta/command/FlexCommand"],function(F){"use strict";
var M=F.extend("sap.ui.rta.command.Move",{metadata:{library:"sap.ui.rta",properties:{movedElements:{type:"any[]"},target:{type:"any"},source:{type:"any"}},associations:{},events:{}}});
M.prototype._getChangeSpecificData=function(){var s=this.getSource();var t=this.getTarget();if(s.parent){s.id=s.parent.getId();delete s.parent;}if(t.parent){t.id=t.parent.getId();delete t.parent;}var S={changeType:this.getChangeType(),source:s,target:t,movedElements:[]};this.getMovedElements().forEach(function(m){S.movedElements.push({id:m.id||(m.element&&m.element.getId()),sourceIndex:m.sourceIndex,targetIndex:m.targetIndex});});return S;};
return M;},true);
sap.ui.predefine('sap/ui/rta/command/Property',["sap/ui/rta/command/FlexCommand"],function(F){"use strict";
var P=F.extend("sap.ui.rta.command.Property",{metadata:{library:"sap.ui.rta",properties:{propertyName:{type:"string"},newValue:{type:"any"},semanticMeaning:{type:"string"},changeType:{type:"string",defaultValue:"propertyChange"}},associations:{},events:{}}});
P.prototype._getChangeSpecificData=function(){var e=this.getElement();return{changeType:this.getChangeType(),selector:{id:e.getId(),type:e.getMetadata().getName()},content:{property:this.getPropertyName(),newValue:this.getNewValue(),semantic:this.getSemanticMeaning()}};};
return P;},true);
sap.ui.predefine('sap/ui/rta/command/Remove',["sap/ui/rta/command/FlexCommand"],function(F){"use strict";
var R=F.extend("sap.ui.rta.command.Remove",{metadata:{library:"sap.ui.rta",properties:{removedElement:{type:"any"}},associations:{},events:{}}});
R.prototype._getChangeSpecificData=function(){var e=this.getRemovedElement()||this.getElement();var s={changeType:this.getChangeType(),removedElement:{id:e.getId()}};return s;};
return R;},true);
sap.ui.predefine('sap/ui/rta/command/Rename',["sap/ui/rta/command/FlexCommand"],function(F){"use strict";
var R=F.extend("sap.ui.rta.command.Rename",{metadata:{library:"sap.ui.rta",properties:{renamedElement:{type:"object"},newValue:{type:"string",defaultValue:"new text"}},associations:{},events:{}}});
R.prototype._getChangeSpecificData=function(){var s={changeType:this.getChangeType(),selector:{id:this.getElement().getId()},renamedElement:{id:this.getRenamedElement().getId()},value:this.getNewValue()};return s;};
return R;},true);
sap.ui.predefine('sap/ui/rta/command/Reveal',["sap/ui/rta/command/FlexCommand"],function(F){"use strict";
var R=F.extend("sap.ui.rta.command.Reveal",{metadata:{library:"sap.ui.rta",properties:{revealedElementId:{type:"string"},directParent:"object"}}});
R.prototype._getChangeSpecificData=function(){var s={changeType:this.getChangeType()};if(this.getRevealedElementId()){s.revealedElementId=this.getRevealedElementId();}return s;};
return R;},true);
sap.ui.predefine('sap/ui/rta/command/Settings',["sap/ui/rta/command/FlexCommand"],function(F){"use strict";
var S=F.extend("sap.ui.rta.command.Settings",{metadata:{library:"sap.ui.rta",properties:{content:{type:"any"}},associations:{},events:{}}});
S.prototype._getChangeSpecificData=function(){var s={changeType:this.getChangeType(),content:this.getContent()};return s;};
S.prototype.execute=function(){if(this.getElement()){return F.prototype.execute.apply(this,arguments);}return Promise.resolve();};
S.prototype.undo=function(){if(this.getElement()){return F.prototype.undo.apply(this,arguments);}return Promise.resolve();};
return S;},true);
sap.ui.predefine('sap/ui/rta/command/Split',["sap/ui/rta/command/FlexCommand"],function(F){"use strict";
var S=F.extend("sap.ui.rta.command.Split",{metadata:{library:"sap.ui.rta",properties:{newElementIds:{type:"string[]"},source:{type:"any"},parentElement:{type:"any"}},associations:{},events:{}}});
S.prototype._getChangeSpecificData=function(){var s={newElementIds:this.getNewElementIds(),sourceControlId:this.getSource().getId(),changeType:this.getChangeType(),parentId:this.getParentElement().getId()};return s;};
return S;},true);
sap.ui.predefine('sap/ui/rta/command/Stack',["sap/ui/base/ManagedObject","sap/ui/fl/Utils","sap/ui/rta/command/Settings","sap/ui/rta/command/CompositeCommand","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/write/api/PersistenceWriteAPI"],function(M,F,S,C,J,P){"use strict";
var a=M.extend("sap.ui.rta.command.Stack",{metadata:{library:"sap.ui.rta",properties:{},aggregations:{commands:{type:"sap.ui.rta.command.BaseCommand",multiple:true}},events:{modified:{},commandExecuted:{parameters:{command:{type:"object"},undo:{type:"boolean"}}}}}});
a.initializeWithChanges=function(c,f){var s=new a();s._aPersistedChanges=f;var m={};if(f&&f.length>0){var o=F.getComponentForControl(c);var A=sap.ui.fl.Utils.getAppDescriptor(o)["sap.app"].id;var p={oComponent:o,appName:A,selector:c,invalidateCache:false};return P._getUIChanges(p).then(function(b){var d={};b.forEach(function(e){d[e.getDefinition().fileName]=e;});f.forEach(function(e){var g=d[e];var h=g.getSelector();var i=new S({selector:h,changeType:g.getDefinition().changeType,element:J.bySelector(h,o)});i._oPreparedChange=g;if(g.getUndoOperations()){i._aRecordedUndo=g.getUndoOperations();g.resetUndoOperations();}var j=g.getDefinition().support.compositeCommand;if(j){if(!m[j]){m[j]=new C();s.pushExecutedCommand(m[j]);}m[j].addCommand(i);}else{s.pushExecutedCommand(i);}});return s;});}return Promise.resolve(s);};
a.prototype.addCommandExecutionHandler=function(h){this._aCommandExecutionHandler.push(h);};
a.prototype.removeCommandExecutionHandler=function(h){var i=this._aCommandExecutionHandler.indexOf(h);if(i>-1){this._aCommandExecutionHandler.splice(i,1);}};
a.prototype.init=function(){this._aCommandExecutionHandler=[];this._toBeExecuted=-1;this._oLastCommand=Promise.resolve();};
a.prototype._waitForCommandExecutionHandler=function(p){return Promise.all(this._aCommandExecutionHandler.map(function(h){return h(p);}));};
a.prototype._getCommandToBeExecuted=function(){return this.getCommands()[this._toBeExecuted];};
a.prototype.pushExecutedCommand=function(c){this.push(c,true);};
a.prototype.push=function(c,e){if(this._bUndoneCommands){this._bUndoneCommands=false;while(this._toBeExecuted>-1){this.pop();}}this.insertCommand(c,0);if(!e){this._toBeExecuted++;}this.fireModified();};
a.prototype.top=function(){return this.getCommands()[0];};
a.prototype.pop=function(){if(this._toBeExecuted>-1){this._toBeExecuted--;}return this.removeCommand(0);};
a.prototype.removeCommand=function(o,s){var r=this.removeAggregation("commands",o,s);this.fireModified();return r;};
a.prototype.removeAllCommands=function(s){var c=this.removeAllAggregation("commands",s);this._toBeExecuted=-1;this.fireModified();return c;};
a.prototype.isEmpty=function(){return this.getCommands().length===0;};
a.prototype.execute=function(){this._oLastCommand=this._oLastCommand.catch(function(){}).then(function(){var c=this._getCommandToBeExecuted();if(c){return c.execute().then(function(){this._toBeExecuted--;var p={command:c,undo:false};this.fireCommandExecuted(p);this.fireModified();return this._waitForCommandExecutionHandler(p);}.bind(this)).catch(function(e){e=e||new Error("Executing of the change failed.");e.index=this._toBeExecuted;e.command=this.removeCommand(this._toBeExecuted);this._toBeExecuted--;return Promise.reject(e);}.bind(this));}}.bind(this));return this._oLastCommand;};
a.prototype._unExecute=function(){if(this.canUndo()){this._bUndoneCommands=true;this._toBeExecuted++;var c=this._getCommandToBeExecuted();if(c){return c.undo().then(function(){var p={command:c,undo:true};this.fireCommandExecuted(p);this.fireModified();return this._waitForCommandExecutionHandler(p);}.bind(this));}return Promise.resolve();}return Promise.resolve();};
a.prototype.canUndo=function(){return(this._toBeExecuted+1)<this.getCommands().length;};
a.prototype.undo=function(){return this._unExecute();};
a.prototype.canRedo=function(){return!!this._getCommandToBeExecuted();};
a.prototype.redo=function(){return this.execute();};
a.prototype.pushAndExecute=function(c){this.push(c);return this.execute();};
a.prototype.getAllExecutedCommands=function(){var A=[];var c=this.getCommands();for(var i=c.length-1;i>this._toBeExecuted;i--){var s=this.getSubCommands(c[i]);A=A.concat(s);}return A;};
a.prototype.getSubCommands=function(c){var b=[];if(c.getCommands){c.getCommands().forEach(function(s){var d=this.getSubCommands(s);b=b.concat(d);},this);}else{b.push(c);}return b;};
return a;},true);
sap.ui.predefine('sap/ui/rta/command/appDescriptor/AddLibrary',["sap/ui/rta/command/AppDescriptorCommand"],function(A){"use strict";
var a=A.extend("sap.ui.rta.command.appDescriptor.AddLibrary",{metadata:{library:"sap.ui.rta",events:{}}});
a.prototype.init=function(){this.setChangeType("appdescr_ui5_addLibraries");};
a.prototype.execute=function(){var p=[];if(this.getParameters().libraries){var l=Object.keys(this.getParameters().libraries);l.forEach(function(L){p.push(sap.ui.getCore().loadLibrary(L,true));});}return Promise.all(p);};
return a;},true);
sap.ui.predefine('sap/ui/rta/enablement/elementActionTest',["sap/ui/core/UIComponent","sap/ui/core/ComponentContainer","sap/ui/core/mvc/XMLView","sap/ui/rta/command/CommandFactory","sap/ui/dt/DesignTime","sap/ui/dt/DesignTimeStatus","sap/ui/dt/OverlayRegistry","sap/ui/fl/ChangePersistence","sap/ui/model/Model","sap/ui/fl/registry/Settings","sap/ui/fl/write/api/PersistenceWriteAPI","sap/ui/fl/Cache","sap/ui/thirdparty/sinon-4","sap/ui/fl/library"],function(U,C,X,a,D,b,O,c,M,S,P,d,s){"use strict";var e=function(m,o){if(e._only&&(m.indexOf(e._only)<0)){return;}if(typeof o.xmlView==="string"){o.xmlView={viewContent:o.xmlView};}var f=s.sandbox.create();o.before=o.before||function(){};o.after=o.after||function(){};QUnit.module(m,function(){QUnit.test("When using the 'controlEnablingCheck' function to test if your control is ready for UI adaptation at runtime",function(n){n.ok(o.afterAction,"then you implement a function to check if your action has been successful: See the afterAction parameter.");n.ok(o.afterUndo,"then you implement a function to check if the undo has been successful: See the afterUndo parameter.");n.ok(o.afterRedo,"then you implement a function to check if the redo has been successful: See the afterRedo parameter.");n.ok(o.xmlView,"then you provide an XML view to test on: See the.xmlView parameter.");var x=new DOMParser().parseFromString(o.xmlView.viewContent,"application/xml").documentElement;n.ok(x.tagName.match("View$"),"then you use the sap.ui.core.mvc View tag as the first tag in your view");n.ok(o.action,"then you provide an action: See the action parameter.");n.ok(o.action.name,"then you provide an action name: See the action.name parameter.");n.ok(o.action.controlId||o.action.control,"then you provide the control or control's id to operate the action on: See the action.controlId.");});});var g="sap.ui.rta.control.enabling.comp";var h=false;var A=true;var i=U.extend(g,{metadata:{manifest:{"sap.app":{id:g,type:"application"},getEntry:function(){return{type:"application"};}}},createContent:function(){var v=Object.assign({},o.xmlView);v.id=this.createId("view");if(v.async===undefined){v.async=this.getComponentData().async;}var V=new X(v);return V;}});function j(n){this.oUiComponent=new i({id:"comp",componentData:{async:n}});this.oUiComponentContainer=new C({component:this.oUiComponent});this.oUiComponentContainer.placeAt(o.placeAt||"qunit-fixture");this.oView=this.oUiComponent.getRootControl();if(o.model instanceof M){this.oView.setModel(o.model);}sap.ui.getCore().applyChanges();return Promise.all([this.oView.loaded(),o.model&&o.model.getMetaModel()&&o.model.getMetaModel().loaded()]);}function k(n){if(typeof o.action.control==="function"){this.oControl=o.action.control(this.oView);}else{this.oControl=this.oView.byId(o.action.controlId);}return this.oControl.getMetadata().loadDesignTime(this.oControl).then(function(){var p;if(o.action.parameter){if(typeof o.action.parameter==="function"){p=o.action.parameter(this.oView);}else{p=o.action.parameter;}}else{p={};}sap.ui.getCore().applyChanges();return new Promise(function(r){this.oDesignTime=new D({rootElements:[this.oView]});this.oDesignTime.attachEventOnce("synced",function(){this.oControlOverlay=O.getOverlay(this.oControl);var q=new a({flexSettings:{layer:o.layer||"CUSTOMER"}});var E=this.oControlOverlay.getDesignTimeMetadata();if(o.action.name==="move"){var t=O.getOverlay(p.movedElements[0].element);var R=t.getRelevantContainer();this.oControl=R;E=t.getParentAggregationOverlay().getDesignTimeMetadata();}else if(o.action.name==="addODataProperty"){var u=E.getActionDataFromAggregations("addODataProperty",this.oControl);n.equal(u.length,1,"there should be only one aggregation with the possibility to do addODataProperty action");var v=this.oControlOverlay.getAggregationOverlay(u[0].aggregation);E=v.getDesignTimeMetadata();}q.getCommandFor(this.oControl,o.action.name,p,E).then(function(w){this.oCommand=w;n.ok(w,"then the registration for action to change type, the registration for change and control type to change handler is available and "+o.action.name+" is a valid action");r();}.bind(this)).catch(function(w){throw new Error(w);});}.bind(this));}.bind(this));}.bind(this));}function l(n){var p=n.getPreparedChange();if(n.getAppComponent){P.remove({change:p,selector:n.getAppComponent()});}}if(!o.jsOnly){QUnit.module(m+" on async views",{before:function(n){this.hookContext={};return o.before.call(this.hookContext,n);},after:function(n){return o.after.call(this.hookContext,n);},beforeEach:function(){f.stub(S,"getInstance").resolves({_oSettings:{}});},afterEach:function(){this.oUiComponentContainer.destroy();this.oDesignTime.destroy();this.oCommand.destroy();f.restore();}},function(){QUnit.test("When applying the change directly on the XMLView",function(n){var p=[];f.stub(c.prototype,"getChangesForComponent").resolves(p);f.stub(c.prototype,"getCacheKey").resolves("etag-123");return j.call(this,h).then(function(){return k.call(this,n);}.bind(this)).then(function(){var q=this.oCommand.getPreparedChange();p.push(q);this.oUiComponentContainer.destroy();return j.call(this,A);}.bind(this)).then(function(q){var v=q[0];return o.afterAction(this.oUiComponent,v,n);}.bind(this));});QUnit.test("When executing on XML and reverting the change in JS (e.g. variant switch)",function(n){var p=[];f.stub(c.prototype,"getChangesForComponent").resolves(p);f.stub(c.prototype,"getCacheKey").resolves("etag-123");return j.call(this,h).then(function(){return k.call(this,n);}.bind(this)).then(function(){var q=this.oCommand.getPreparedChange();p.push(q);this.oUiComponentContainer.destroy();return j.call(this,A);}.bind(this)).then(function(){return this.oCommand.undo();}.bind(this)).then(function(){return l(this.oCommand);}.bind(this)).then(function(){sap.ui.getCore().applyChanges();o.afterUndo(this.oUiComponent,this.oView,n);}.bind(this));});QUnit.test("When executing on XML, reverting the change in JS (e.g. variant switch) and applying again",function(n){var p=[];f.stub(c.prototype,"getChangesForComponent").resolves(p);f.stub(c.prototype,"getCacheKey").resolves("etag-123");return j.call(this,h).then(function(){return k.call(this,n);}.bind(this)).then(function(){var q=this.oCommand.getPreparedChange();p.push(q);this.oUiComponentContainer.destroy();return j.call(this,A);}.bind(this)).then(function(){return this.oCommand.undo();}.bind(this)).then(function(){return l(this.oCommand);}.bind(this)).then(function(){return this.oCommand.execute();}.bind(this)).then(function(){sap.ui.getCore().applyChanges();o.afterRedo(this.oUiComponent,this.oView,n);}.bind(this));});});}QUnit.module(m,{before:function(n){this.hookContext={};return o.before.call(this.hookContext,n);},after:function(n){return o.after.call(this.hookContext,n);},beforeEach:function(n){f.stub(c.prototype,"getChangesForComponent").returns(Promise.resolve([]));f.stub(c.prototype,"getCacheKey").returns(d.NOTAG);f.stub(S,"getInstance").returns(Promise.resolve({_oSettings:{}}));return j.call(this,h).then(function(){return k.call(this,n);}.bind(this));},afterEach:function(){this.oDesignTime.destroy();this.oUiComponentContainer.destroy();this.oCommand.destroy();f.restore();}},function(){QUnit.test("When executing the underlying command on the control at runtime",function(n){return this.oCommand.execute().then(function(){return this.oDesignTime.getStatus()!==b.SYNCED?(new Promise(function(r){this.oDesignTime.attachEventOnce("synced",r);}.bind(this))):Promise.resolve();}.bind(this)).then(function(){sap.ui.getCore().applyChanges();return o.afterAction(this.oUiComponent,this.oView,n);}.bind(this));});QUnit.test("When executing and undoing the command",function(n){return this.oCommand.execute().then(function(){return this.oDesignTime.getStatus()!==b.SYNCED?(new Promise(function(r){this.oDesignTime.attachEventOnce("synced",r);}.bind(this))):Promise.resolve();}.bind(this)).then(this.oCommand.undo.bind(this.oCommand)).then(function(){return l(this.oCommand);}.bind(this)).then(function(){sap.ui.getCore().applyChanges();return o.afterUndo(this.oUiComponent,this.oView,n);}.bind(this));});QUnit.test("When executing, undoing and redoing the command",function(n){return this.oCommand.execute().then(function(){return this.oDesignTime.getStatus()!==b.SYNCED?(new Promise(function(r){this.oDesignTime.attachEventOnce("synced",r);}.bind(this))):Promise.resolve();}.bind(this)).then(this.oCommand.undo.bind(this.oCommand)).then(function(){return l(this.oCommand);}.bind(this)).then(this.oCommand.execute.bind(this.oCommand)).then(function(){sap.ui.getCore().applyChanges();return o.afterRedo(this.oUiComponent,this.oView,n);}.bind(this));});});};
e.skip=function(){};
e.only=function(m){e._only=m;};
return e;});
sap.ui.predefine('sap/ui/rta/library',["sap/ui/core/Core","sap/ui/core/library","sap/m/library","sap/ui/fl/library","sap/ui/dt/library"],function(){"use strict";sap.ui.getCore().initLibrary({name:"sap.ui.rta",version:"1.71.16",dependencies:["sap.ui.core","sap.m","sap.ui.fl","sap.ui.dt"],types:[],interfaces:[],controls:[],elements:[]});return sap.ui.rta;});
sap.ui.predefine('sap/ui/rta/plugin/Combine',["sap/ui/rta/plugin/Plugin","sap/ui/rta/Utils","sap/ui/dt/Util"],function(P,U,D){"use strict";
var C=P.extend("sap.ui.rta.plugin.Combine",{metadata:{library:"sap.ui.rta",properties:{},associations:{},events:{}}});
C.prototype._isEditable=function(o){var c=this.getAction(o);if(!o.isRoot()&&c&&c.changeType&&c.changeOnRelevantContainer){var r=o.getRelevantContainer();return this.hasChangeHandler(c.changeType,r).then(function(h){return h&&this.hasStableId(o)&&this._checkRelevantContainerStableID(c,o);}.bind(this));}return false;};
C.prototype._checkForSameRelevantContainer=function(e){var r=[];for(var i=0,n=e.length;i<n;i++){r[i]=e[i].getRelevantContainer();var c=this.getAction(e[i]);if(!c||!c.changeType){return false;}if(i>0){if((r[0]!==r[i])||(this.getAction(e[0]).changeType!==c.changeType)){return false;}}}return true;};
C.prototype._checkBindingCompatibilityOfControls=function(c,m){return c.every(function(s){return c.every(function(t){return s!==t?U.checkSourceTargetBindingCompatibility(s,t,m):true;});});};
C.prototype.isAvailable=function(e){if(e.length<=1){return false;}return(e.every(function(E){return this._isEditableByPlugin(E);},this)&&this._checkForSameRelevantContainer(e));};
C.prototype.isEnabled=function(e){if(!this.isAvailable(e)||e.length<=1){return false;}var c=e.map(function(E){return E.getElement();});var a=e.every(function(E){var A=this.getAction(E);if(!A){return false;}if(typeof A.isEnabled!=="undefined"){if(typeof A.isEnabled==="function"){return A.isEnabled(c);}return A.isEnabled;}return true;},this);if(a){var d=c[0]&&c[0].getModel();return this._checkBindingCompatibilityOfControls(c,d);}return a;};
C.prototype.handleCombine=function(e,c){var o;var E=e.map(function(a){if(a.getElement().getId()===c.getId()){o=a;}return a.getElement();});var d=o.getDesignTimeMetadata();var v=this.getVariantManagementReference(o);return this.getCommandFactory().getCommandFor(c,"combine",{source:c,combineElements:E},d,v).then(function(a){this.fireElementModified({command:a});}.bind(this)).catch(function(m){throw D.createError("Combine#handleCombine",m,"sap.ui.rta");});};
C.prototype.getMenuItems=function(e){return this._getMenuItems(e,{pluginId:"CTX_GROUP_FIELDS",rank:90,icon:"sap-icon://combine"});};
C.prototype.getActionName=function(){return"combine";};
C.prototype.handler=function(e,p){this.handleCombine(e,p.contextElement);};
return C;},true);
sap.ui.predefine('sap/ui/rta/plugin/ControlVariant',["sap/ui/rta/plugin/Plugin","sap/ui/rta/plugin/RenameHandler","sap/ui/rta/Utils","sap/ui/dt/ElementOverlay","sap/ui/dt/OverlayRegistry","sap/ui/dt/OverlayUtil","sap/ui/dt/Util","sap/ui/fl/Utils","sap/ui/fl/variants/VariantManagement","sap/ui/base/ManagedObject","sap/m/delegate/ValueStateMessage","sap/ui/rta/command/CompositeCommand","sap/base/Log"],function(P,R,U,E,O,a,D,f,V,M,b,C,L){"use strict";E.prototype._variantManagement=undefined;
E.prototype.getVariantManagement=function(){return this._variantManagement;};
E.prototype.setVariantManagement=function(k){this._variantManagement=k;};
E.prototype.hasVariantManagement=function(){return!!this._variantManagement;};
var c=P.extend("sap.ui.rta.plugin.ControlVariant",{metadata:{library:"sap.ui.rta",properties:{oldValue:"string",variantManagementControlOverlay:{type:"any"}},associations:{},events:{}}});
c.prototype.registerElementOverlay=function(o){var d=o.getElement();var v;P.prototype.registerElementOverlay.apply(this,arguments);if(d instanceof V){var A=d.getFor();var e;var g=f.getAppComponentForControl(d);var s=d.getId();v=g.getLocalId(s)||s;if(!A||(Array.isArray(A)&&A.length===0)){o.setVariantManagement(v);return;}e=!Array.isArray(A)?[A]:A;e.forEach(function(h){var i=h instanceof M?h:sap.ui.getCore().byId(h);var j=O.getOverlay(i);this._propagateVariantManagement(j,v);}.bind(this));o.attachEvent("editableChange",R._manageClickEvent,this);}else if(!o.getVariantManagement()){v=this._getVariantManagementFromParent(o);if(v){o.setVariantManagement(v);o.attachEvent("editableChange",R._manageClickEvent,this);}}};
c.prototype._isPersonalizationMode=function(){return this.getCommandFactory().getFlexSettings().layer==="USER";};
c.prototype._propagateVariantManagement=function(p,v){var e=[];p.setVariantManagement(v);e=a.getAllChildOverlays(p);e.forEach(function(o){e=e.concat(this._propagateVariantManagement(o,v));}.bind(this));return e;};
c.prototype._getVariantManagementFromParent=function(o){var v=o.getVariantManagement();if(!v&&o.getParentElementOverlay()){return this._getVariantManagementFromParent(o.getParentElementOverlay());}return v;};
c.prototype.deregisterElementOverlay=function(o){o.detachEvent("editableChange",R._manageClickEvent,this);o.detachBrowserEvent("click",R._onClick,this);this.removeFromPluginsList(o);P.prototype.deregisterElementOverlay.apply(this,arguments);};
c.prototype._getVariantModel=function(e){var A=f.getAppComponentForControl(e);return A?A.getModel(f.VARIANT_MODEL_NAME):undefined;};
c.prototype._isEditable=function(o){if(this._isPersonalizationMode()){return false;}return this._isVariantManagementControl(o)&&this.hasStableId(o);};
c.prototype._isVariantManagementControl=function(o){var e=o.getElement();var A=e.getAssociation("for");return!!(A&&e instanceof V);};
c.prototype.isVariantSwitchAvailable=function(e){return this._isVariantManagementControl(e);};
c.prototype.isVariantSwitchEnabled=function(e){var o=e[0];var v=[];if(this._isVariantManagementControl(o)){var d=o.getElement();var s=o.getVariantManagement?o.getVariantManagement():undefined;if(!s){return false;}var m=this._getVariantModel(d);if(m){v=m.getData()[s].variants.reduce(function(r,h){if(h.visible){return r.concat(h);}return r;},[]);}var g=v.length>1;return g;}return false;};
c.prototype.setDesignTime=function(d){R._setDesignTime.call(this,d);};
c.prototype.isRenameAvailable=function(e){return this._isVariantManagementControl(e);};
c.prototype.isRenameEnabled=function(e){return this._isVariantManagementControl(e[0]);};
c.prototype.isVariantDuplicateAvailable=function(e){return this._isVariantManagementControl(e);};
c.prototype.isVariantDuplicateEnabled=function(e){var o=e[0];var v=o.getVariantManagement?o.getVariantManagement():undefined;if(!v||!this._isVariantManagementControl(o)){return false;}return true;};
c.prototype.isVariantConfigureAvailable=function(e){return this._isVariantManagementControl(e);};
c.prototype.isVariantConfigureEnabled=function(e){return this._isVariantManagementControl(e[0]);};
c.prototype.switchVariant=function(t,n,s){var d=t.getDesignTimeMetadata();var T=t.getElement();this.getCommandFactory().getCommandFor(T,"switch",{targetVariantReference:n,sourceVariantReference:s},d).then(function(S){this.fireElementModified({command:S});}.bind(this)).catch(function(m){throw D.createError("ControlVariant#switchVariant",m,"sap.ui.rta");});};
c.prototype.renameVariant=function(e){var o=e[0];this.setVariantManagementControlOverlay(o);this.startEdit(o);};
c.prototype.startEdit=function(v){var o=v.getElement();var d=v.getDesignTimeMetadata().getData().variantRenameDomRef;var e=o.getTitle();var p=e.getText();var h=R.startEdit.bind(this,{overlay:v,domRef:d,pluginMethodName:"plugin.ControlVariant.startEdit"});if(v._triggerDuplicate){var s=this._getVariantTitleForCopy(p,v.getVariantManagement(),this._getVariantModel(o).getData());o.getTitle().setText(s);v.attachEventOnce("geometryChanged",function(){h();},this);}else{h();}};
c.prototype.stopEdit=function(r){if(this._oEditedOverlay._triggerDuplicate){this._oEditedOverlay.getElementInstance().getTitle().getBinding("text").refresh(true);if(!this._oEditedOverlay.hasStyleClass("sapUiRtaErrorBg")){delete this._oEditedOverlay._triggerDuplicate;}}R._stopEdit.call(this,r,"plugin.ControlVariant.stopEdit");};
c.prototype._createDuplicateCommand=function(p){return this.getCommandFactory().getCommandFor(p.element,"duplicate",{sourceVariantReference:p.currentVariantReference,newVariantTitle:p.newVariantTitle},p.designTimeMetadata,p.variantManagementReference);};
c.prototype._emitLabelChangeEvent=function(){var t=R._getCurrentEditableFieldText.call(this);var o=this._oEditedOverlay;var d=o.getDesignTimeMetadata();var r=o.getElement();var m=this._getVariantModel(r);var e;var v=o.getVariantManagement();var T=this.getOldValue()!==t;var n=T||o._triggerDuplicate;var i=n?m._getVariantTitleCount(t,v):0;var g=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");var s=m.getCurrentVariantReference(v);o.removeStyleClass("sapUiRtaErrorBg");if(this._oValueStateMessage){this._oValueStateMessage.getPopup().attachEventOnce("closed",function(){r.$().css("z-index",1);this._oValueStateMessage.destroy();delete this._oValueStateMessage;},this);this._oValueStateMessage.close();}if(t==='\xa0'){e="BLANK_ERROR_TEXT";}else if(i>0){e="DUPLICATE_ERROR_TEXT";}else if(n){return this._createSetTitleCommand({text:t,element:r,designTimeMetadata:d,variantManagementReference:v}).then(function(S){if(o._triggerDuplicate){return this._createDuplicateCommand({currentVariantReference:s,designTimeMetadata:d,variantManagementReference:v,element:r,newVariantTitle:this.getOldValue()}).then(function(j){return new C({commands:[j]});}).then(function(j){return T?j.addCommand(S):j;});}return S;}.bind(this)).then(function(j){this.fireElementModified({command:j});}.bind(this)).catch(function(j){throw D.createError("ControlVariant#_emitLabelChangeEvent",j,"sap.ui.rta");});}else{L.info("Control Variant title unchanged");return Promise.resolve();}if(e){var h=g.getText(e);this._prepareOverlayForValueState(o,h);o.addStyleClass("sapUiRtaErrorBg");return Promise.resolve(U._showMessageBox("ERROR","BLANK_DUPLICATE_TITLE_TEXT",e).then(function(){var j=function(){this._oValueStateMessage=new b(o);this._oValueStateMessage.getPopup().attachEventOnce("opened",function(k){k.getSource()._deactivateFocusHandle();});this._oValueStateMessage.open();this.startEdit(o);}.bind(this);return j;}.bind(this)));}};
c.prototype._getVariantTitleForCopy=function(s,v,d){var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.fl");var e=r.getText("VARIANT_COPY_SINGLE_TEXT").replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g,"\\$&").replace("\\{0\\}","(.*)");var g=r.getText("VARIANT_COPY_MULTIPLE_TEXT").replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g,"\\$&").replace("\\{0\\}","(.*)").replace("\\{1\\}","([0-9]+)");var h=new RegExp(e+"+");var i=new RegExp(g);var t;var I=g.lastIndexOf("(.*)")>g.lastIndexOf("([0-9]+)")?1:2;var j=(I===1)?2:1;var T=0;if(i.test(s)){t=i.exec(s)[j];}else{t=h.test(s)?h.exec(s)[1]:s;}var k=[];d[v].variants.forEach(function(o){if(o.visible){k=i.test(o.title)?i.exec(o.title):h.exec(o.title);if(!k){return;}if(k.length===3&&t===k[j]&&T<=parseInt(k[I])){T=k[I]?(parseInt(k[I])+1):T;}else if(k.length===2&&t===k[1]){T=T===0?1:T;}}});return T>0?r.getText("VARIANT_COPY_MULTIPLE_TEXT",[t,T]):r.getText("VARIANT_COPY_SINGLE_TEXT",[t]);};
c.prototype._createSetTitleCommand=function(p){this._$oEditableControlDomRef.text(p.text);return this.getCommandFactory().getCommandFor(p.element,"setTitle",{newText:p.text},p.designTimeMetadata,p.variantManagementReference).catch(function(m){L.error("Error during rename : ",m);});};
c.prototype._prepareOverlayForValueState=function(o,v){o.getValueState=function(){return"Error";};o.getValueStateText=function(){return v;};o.getDomRefForValueStateMessage=function(){return this.$();};};
c.prototype.configureVariants=function(e){var o=e[0];var v=o.getElement();var s=o.getVariantManagement();var m=this._getVariantModel(v);var d=o.getDesignTimeMetadata();m.manageVariants(v,s,this.getCommandFactory().getFlexSettings().layer,U.getRtaStyleClassName()).then(function(g){return this.getCommandFactory().getCommandFor(v,"configure",{control:v,changes:g},d,s);}.bind(this)).then(function(g){this.fireElementModified({command:g});}.bind(this)).catch(function(g){throw D.createError("ControlVariant#configureVariants",g,"sap.ui.rta");});};
c.prototype.getMenuItems=function(e){var o=e[0];var m=[];if(this.isRenameAvailable(o)){m.push({id:"CTX_VARIANT_SET_TITLE",text:sap.ui.getCore().getLibraryResourceBundle('sap.ui.rta').getText('CTX_RENAME'),handler:this.renameVariant.bind(this),enabled:this.isRenameEnabled.bind(this),rank:210,icon:"sap-icon://edit"});}if(this.isVariantDuplicateAvailable(o)){m.push({id:"CTX_VARIANT_DUPLICATE",text:sap.ui.getCore().getLibraryResourceBundle('sap.ui.rta').getText('CTX_VARIANT_DUPLICATE'),handler:function(e){e[0]._triggerDuplicate=true;this.renameVariant(e);}.bind(this),enabled:this.isVariantDuplicateEnabled.bind(this),rank:220,icon:"sap-icon://duplicate"});}if(this.isVariantConfigureAvailable(o)){m.push({id:"CTX_VARIANT_MANAGE",text:sap.ui.getCore().getLibraryResourceBundle('sap.ui.rta').getText('CTX_VARIANT_MANAGE'),handler:this.configureVariants.bind(this),enabled:this.isVariantConfigureEnabled.bind(this),startSection:true,rank:230,icon:"sap-icon://action-settings"});}if(this.isVariantSwitchAvailable(o)){var d=this._getVariantModel(o.getElement());var s=o.getVariantManagement();var S=d.getData()[s].variants.reduce(function(r,v){if(v.visible){var g=d.getData()[s].currentVariant===v.key;var i={id:v.key,text:v.title,icon:g?"sap-icon://accept":"blank",enabled:!g};return r.concat(i);}return r;},[]);m.push({id:"CTX_VARIANT_SWITCH_SUBMENU",text:sap.ui.getCore().getLibraryResourceBundle('sap.ui.rta').getText('CTX_VARIANT_SWITCH'),handler:function(e,p){var g=p.eventItem.data();var t=e[0];var n=g.key;var h=d.getData()[s].currentVariant;return this.switchVariant(t,n,h);}.bind(this),enabled:this.isVariantSwitchEnabled.bind(this),submenu:S,rank:240,icon:"sap-icon://switch-views"});}return m;};
return c;},true);
sap.ui.predefine('sap/ui/rta/plugin/CreateContainer',["sap/ui/rta/plugin/Plugin","sap/ui/fl/Utils","sap/ui/rta/Utils","sap/ui/dt/Util","sap/base/util/uid"],function(P,F,R,D,u){"use strict";
var C=P.extend("sap.ui.rta.plugin.CreateContainer",{metadata:{library:"sap.ui.rta",properties:{},associations:{},events:{}}});
C.prototype._isEditable=function(o){return Promise.all([this._isEditableCheck(o,true),this._isEditableCheck(o,false)]).then(function(p){return{asSibling:p[0],asChild:p[1]};});};
C.prototype._isEditableCheck=function(o,O){var p=this._getParentOverlay(O,o);var a;if(!p||!p.getParentElementOverlay()){return Promise.resolve(false);}if(O){a=o.getParentAggregationOverlay().getAggregationName();}return this.checkAggregationsOnSelf(p,"createContainer",a).then(function(e){if(e){var b=F.getViewForControl(p.getElement());return this.hasStableId(o)&&F.checkControlId(b);}return false;}.bind(this));};
C.prototype._getParentOverlay=function(s,o){var p;if(s){p=o.getParentElementOverlay();}else{p=o;}return p;};
C.prototype.getCreateAction=function(s,o){var p=this._getParentOverlay(s,o);var d=p.getDesignTimeMetadata();var a=d.getActionDataFromAggregations("createContainer",o.getElement());return a[0];};
C.prototype.isAvailable=function(s,e){return this._isEditableByPlugin(e[0],s);};
C.prototype.isEnabled=function(s,e){var E=e[0];var a=this.getCreateAction(s,E);if(!a){return false;}if(a.isEnabled&&typeof a.isEnabled==="function"){var i=a.isEnabled;var p=this._getParentOverlay(s,E);return i(p.getElement());}return true;};
C.prototype.getCreatedContainerId=function(a,n){var i=n;if(a.getCreatedContainerId&&typeof a.getCreatedContainerId==="function"){var m=a.getCreatedContainerId;i=m(n);}return i;};
C.prototype._determineIndex=function(p,s,a,g){return R.getIndex(p,s,a,g);};
C.prototype._getText=function(a,e,d,t){if(!a){return t;}var A=d.getAggregationDescription(a.aggregation,e);if(!A){return t;}var c=A.singular;var T=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");return T.getText(t,c);};
C.prototype.getCreateContainerText=function(s,o){var a=this.getCreateAction(s,o);var p=this._getParentOverlay(s,o);var d=p.getDesignTimeMetadata();var e=p.getElement();var t="CTX_CREATE_CONTAINER";return this._getText(a,e,d,t);};
C.prototype._getContainerTitle=function(a,e,d){var t="TITLE_CREATE_CONTAINER";return this._getText(a,e,d,t);};
C.prototype.handleCreate=function(s,o){var a=this.getCreateAction(s,o);var p=this._getParentOverlay(s,o);var b=p.getElement();var d=p.getDesignTimeMetadata();var v=F.getViewForControl(b);var S;if(s){S=o.getElement();}var n=v.createId(u());var g=d.getAggregation(a.aggregation).getIndex;var i=this._determineIndex(b,S,a.aggregation,g);var V=this.getVariantManagementReference(p);return this.getCommandFactory().getCommandFor(b,"createContainer",{newControlId:n,label:this._getContainerTitle(a,b,d),index:i,parentId:b.getId()},d,V).then(function(c){this.fireElementModified({command:c,action:a,newControlId:n});}.bind(this)).catch(function(m){throw D.createError("CreateContainer#handleCreate",m,"sap.ui.rta");});};
C.prototype.getMenuItems=function(e){var o=true;var p="CTX_CREATE_SIBLING_CONTAINER";var r=40;var m=[];for(var i=0;i<2;i++){if(this.isAvailable(o,e)){var M=this.getCreateContainerText.bind(this,o);m.push({id:p,text:M,handler:this.handler.bind(this,o),enabled:this.isEnabled.bind(this,o),icon:"sap-icon://add-folder",rank:r,group:"Add"});}o=false;p="CTX_CREATE_CHILD_CONTAINER";r=50;}return m;};
C.prototype.getActionName=function(){return"createContainer";};
C.prototype.handler=function(o,e){this.handleCreate(o,e[0]);};
return C;},true);
sap.ui.predefine('sap/ui/rta/plugin/CutPaste',["sap/ui/dt/plugin/CutPaste","sap/ui/dt/Util","sap/ui/rta/plugin/Plugin","sap/ui/rta/plugin/RTAElementMover","sap/ui/rta/Utils"],function(C,D,P,R,U){"use strict";
var a=C.extend("sap.ui.rta.plugin.CutPaste",{metadata:{library:"sap.ui.rta",properties:{commandFactory:{type:"object",multiple:false}},events:{dragStarted:{},elementModified:{command:{type:"sap.ui.rta.command.BaseCommand"}}}}});
U.extendWith(a.prototype,P.prototype,function(d,s,p){return p!=="getMetadata";});
a.prototype.init=function(){C.prototype.init.apply(this,arguments);this.setElementMover(new R({commandFactory:this.getCommandFactory()}));};
a.prototype._isEditable=function(o,p){return this.getElementMover().isEditable(o,p.onRegistration).then(function(e){if(e){return true;}return this._isPasteEditable(o);}.bind(this));};
a.prototype._isPasteEditable=function(o){var e=this.getElementMover();if(!this.hasStableId(o)){return Promise.resolve(false);}return e.isMoveAvailableOnRelevantContainer(o).then(function(m){if(!m){return false;}return U.doIfAllControlsAreAvailable([o],function(){return e.isMoveAvailableForChildren(o);});});};
a.prototype.isAvailable=function(e){return e.every(function(E){return E.getMovable();});};
a.prototype.registerElementOverlay=function(){C.prototype.registerElementOverlay.apply(this,arguments);P.prototype.registerElementOverlay.apply(this,arguments);};
a.prototype.deregisterElementOverlay=function(){C.prototype.deregisterElementOverlay.apply(this,arguments);P.prototype.removeFromPluginsList.apply(this,arguments);};
a.prototype.paste=function(t){this._executePaste(t);D.waitForSynced(this.getDesignTime())().then(function(){return this.getElementMover().buildMoveCommand();}.bind(this)).then(function(m){this.fireElementModified({command:m});this.stopCutAndPaste();}.bind(this)).catch(function(m){throw D.createError("CutPaste#paste",m,"sap.ui.rta");});};
a.prototype.cut=function(o){return C.prototype.cut.apply(this,arguments).then(function(){o.setSelected(false);});};
a.prototype.getMenuItems=function(e){var m=[];var c={id:'CTX_CUT',text:sap.ui.getCore().getLibraryResourceBundle('sap.ui.rta').getText('CTX_CUT'),handler:function(e){return this.cut(e[0]);}.bind(this),enabled:function(e){return e.length===1;},rank:70,icon:"sap-icon://scissors"};var p={id:'CTX_PASTE',text:sap.ui.getCore().getLibraryResourceBundle('sap.ui.rta').getText('CTX_PASTE'),handler:function(e){return this.paste(e[0]);}.bind(this),enabled:function(e){return this.isElementPasteable(e[0]);}.bind(this),rank:80,icon:"sap-icon://paste"};if(this.isAvailable(e)){m.push(c,p);return m;}return this._isPasteEditable(e[0]).then(function(b){if(b){m.push(p);}return m;});};
return a;},true);
sap.ui.predefine('sap/ui/rta/plugin/DragDrop',["sap/ui/dt/plugin/ControlDragDrop","sap/ui/dt/Util","sap/ui/rta/plugin/RTAElementMover","sap/ui/rta/plugin/Plugin","sap/ui/rta/Utils"],function(C,D,R,P,U){"use strict";
var a=C.extend("sap.ui.rta.plugin.DragDrop",{metadata:{library:"sap.ui.rta",properties:{commandFactory:{type:"object",multiple:false}},events:{dragStarted:{},elementModified:{command:{type:"sap.ui.rta.command.BaseCommand"}}}}});
U.extendWith(a.prototype,P.prototype,function(d,s,p){return p!=="getMetadata";});
a.prototype.init=function(){C.prototype.init.apply(this,arguments);this.setElementMover(new R({commandFactory:this.getCommandFactory()}));};
a.prototype.setCommandFactory=function(c){this.setProperty("commandFactory",c);this.getElementMover().setCommandFactory(c);};
a.prototype._isEditable=function(o,p){return this.getElementMover().isEditable(o,p.onRegistration);};
a.prototype.registerElementOverlay=function(){C.prototype.registerElementOverlay.apply(this,arguments);P.prototype.registerElementOverlay.apply(this,arguments);};
a.prototype.deregisterElementOverlay=function(){C.prototype.deregisterElementOverlay.apply(this,arguments);P.prototype.removeFromPluginsList.apply(this,arguments);};
a.prototype.onDragStart=function(o){this.fireDragStarted();C.prototype.onDragStart.apply(this,arguments);this.getSelectedOverlays().forEach(function(o){o.setSelected(false);});o.$().addClass("sapUiRtaOverlayPlaceholder");};
a.prototype.onDragEnd=function(o){this.getElementMover().buildMoveCommand().then(function(c){this.fireElementModified({command:c});o.$().removeClass("sapUiRtaOverlayPlaceholder");o.setSelected(true);o.focus();C.prototype.onDragEnd.apply(this,arguments);}.bind(this)).catch(function(e){throw D.propagateError(e,"DragDrop#onDragEnd","Error accured during onDragEnd execution","sap.ui.rta.plugin");});};
a.prototype.onMovableChange=function(){C.prototype.onMovableChange.apply(this,arguments);};
return a;},true);
sap.ui.predefine('sap/ui/rta/plugin/EasyAdd',["sap/ui/rta/plugin/additionalElements/AdditionalElementsPlugin","sap/ui/dt/OverlayRegistry","sap/m/Button","sap/ui/thirdparty/jquery"],function(A,O,B,q){"use strict";
var E=A.extend("sap.ui.rta.plugin.EasyAdd",{metadata:{library:"sap.ui.rta",properties:{},associations:{},events:{}}});
E.prototype.registerElementOverlay=function(o){var c=o.getElement();if(c.getMetadata().getName()==="sap.uxap.ObjectPageSection"&&this.hasStableId(o)){o.addStyleClass("sapUiRtaPersAdd");c.addStyleClass("sapUiRtaMarginBottom");}else if(c.getMetadata().getName()==="sap.uxap.ObjectPageLayout"&&this.hasStableId(o)){o.addStyleClass("sapUiRtaPersAddTop");c.$("sectionsContainer").addClass("sapUiRtaPaddingTop");}var a=function(d,o,i){var C;if(d){C=o.getDesignTimeMetadata().getName().plural;}else{C=o.getDesignTimeMetadata().getAggregation("sections").childNames.plural();}this.clearCachedElements();this.showAvailableElements(d,[o],i,C);}.bind(this);var f=function(o,d,S,C,i){var e=function(h){var o=O.getOverlay(h.currentTarget.id.replace("-AddButton",""));a(S,o,i);h.stopPropagation();};var g=typeof C==="function"?C():C;this._addButton(o,e,d,g,S);}.bind(this);if(o.hasStyleClass("sapUiRtaPersAdd")){var b=o.hasStyleClass("sapUiRtaPersAdd")&&o.$().children(".sapUiRtaPersAddIconOuter").length<=0;if(b){f(o,o.$(),true,o.getDesignTimeMetadata().getName().singular);}}else if(o.hasStyleClass("sapUiRtaPersAddTop")){if(o.getAggregationOverlay("sections").$().children(".sapUiRtaPersAddIconOuter").length<=0){var s=o.getAggregationOverlay("sections").$();f(o,s,false,o.getDesignTimeMetadata().getAggregation("sections").childNames.singular,0);}}A.prototype.registerElementOverlay.apply(this,arguments);};
E.prototype.deregisterElementOverlay=function(o){var c=o.getElement();if(o._oAddButton){o._oAddButton.destroy();}if(c.getMetadata().getName()==="sap.uxap.ObjectPageSection"){o.removeStyleClass("sapUiRtaPersAdd");c.removeStyleClass("sapUiRtaMarginBottom");}else if(c.getMetadata().getName()==="sap.uxap.ObjectPageLayout"){o.removeStyleClass("sapUiRtaPersAddTop");c.$("sectionsContainer").removeClass("sapUiRtaPaddingTop");}};
E.prototype._isEditable=function(o){return A.prototype._isEditable.apply(this,arguments).then(function(i){if(o._oAddButton){var I=o.hasStyleClass("sapUiRtaPersAddTop");var s=I?"asChild":"asSibling";o._oAddButton.setEnabled(i[s]);if(I){var l=o.getElement();l.attachEventOnce("onAfterRenderingDOMReady",function(){l.$("sectionsContainer").addClass("sapUiRtaPaddingTop");});}}return i;});};
E.prototype._addButton=function(o,c,a,C,b){var i=o.getEditableByPlugins().indexOf(this._retrievePluginName(b))>-1;var t=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");var I=o.getId()+"-AddButton";var h=q("<div class='sapUiRtaPersAddIconOuter' draggable='true' tabindex='-1'> </div>");o._oAddButton=new B(I,{text:t.getText("CTX_ADD_ELEMENTS",C),icon:"sap-icon://add",enabled:i}).placeAt(h.get(0)).attachBrowserEvent('click',c).attachBrowserEvent('tap',c);a.append(h);h[0].addEventListener("mouseover",function(e){e.stopPropagation();var o=e.fromElement?O.getOverlay(e.fromElement.id):null;if(o&&o.getMetadata().getName()==="sap.ui.dt.ElementOverlay"){var p=o.getParentElementOverlay();p.removeStyleClass("sapUiRtaOverlayHover");}});h[0].addEventListener("mouseleave",function(e){e.stopPropagation();var o=e.toElement?O.getOverlay(e.toElement.id):null;if(o&&o.getMetadata().getName()==="sap.ui.dt.ElementOverlay"){var p=o.getParentElementOverlay();if(p.getMovable()){p.addStyleClass("sapUiRtaOverlayHover");}}});h[0].addEventListener("click",function(e){e.stopPropagation();});h[0].addEventListener("contextmenu",function(e){e.stopPropagation();e.preventDefault();});h[0].addEventListener("dragstart",function(e){e.stopPropagation();e.preventDefault();});};
return E;},true);
sap.ui.predefine('sap/ui/rta/plugin/EasyRemove',["sap/ui/rta/plugin/Remove","sap/m/Button","sap/ui/thirdparty/jquery"],function(R,B,q){"use strict";
var E=R.extend("sap.ui.rta.plugin.EasyRemove",{metadata:{library:"sap.ui.rta",properties:{},associations:{},events:{}}});
E.prototype.registerElementOverlay=function(o){var c=o.getElement();if(c.getMetadata().getName()==="sap.uxap.ObjectPageSection"&&this.hasStableId(o)){o.addStyleClass("sapUiRtaPersDelete");}if(o.hasStyleClass("sapUiRtaPersDelete")&&o.$().children(".sapUiRtaPersDeleteClick").length<=0){var a=function(o){this.handler([o]);}.bind(this);var d=this._addButton(o);d.attachBrowserEvent("contextmenu",function(e){e.stopPropagation();e.preventDefault();});var O=function(e){var o=sap.ui.getCore().byId(e.currentTarget.id.replace("-DeleteIcon",""));a(o);e.stopPropagation();e.preventDefault();};d.attachBrowserEvent("click",O).attachBrowserEvent("tap",O);}R.prototype.registerElementOverlay.apply(this,arguments);};
E.prototype._isEditable=function(o){if(o._oDeleteButton){o._oDeleteButton.setEnabled(this.isEnabled([o]));}return R.prototype._isEditable.apply(this,arguments);};
E.prototype._addButton=function(o){var e=this.isEnabled([o]);var i=o.getId()+"-DeleteIcon";var h=q("<div class='sapUiRtaPersDeleteClick' draggable='true'> </div>");var H=q("<div class='sapUiRtaPersDeleteIconOuter'> </div>");o._oDeleteButton=new B(i,{icon:"sap-icon://less",tooltip:sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta").getText("CTX_REMOVE"),enabled:e}).placeAt(H.get(0));h.append(H);o.$().append(h);h[0].addEventListener("dragstart",function(a){a.stopPropagation();a.preventDefault();});return o._oDeleteButton;};
E.prototype.deregisterElementOverlay=function(o){var c=o.getElement();if(c.getMetadata().getName()==="sap.uxap.ObjectPageSection"){o.removeStyleClass("sapUiRtaPersDelete");if(o._oDeleteButton){o._oDeleteButton.destroy();}}};
return E;},true);
sap.ui.predefine('sap/ui/rta/plugin/Plugin',["sap/ui/dt/Plugin","sap/ui/fl/registry/ChangeRegistry","sap/ui/dt/OverlayRegistry","sap/ui/dt/OverlayUtil","sap/ui/dt/ElementOverlay","sap/ui/fl/changeHandler/JsControlTreeModifier","sap/ui/rta/util/hasStableId"],function(P,C,O,a,E,J,h){"use strict";
var B=P.extend("sap.ui.rta.plugin.Plugin",{metadata:{"abstract":true,library:"sap.ui.rta",properties:{commandFactory:{type:"object",multiple:false}},events:{elementModified:{command:{type:"sap.ui.rta.command.BaseCommand"}}}}});
B.prototype._isEditable=function(){};
B.prototype.executeWhenVisible=function(e,c){var g=function(o){if(o.getSource().getGeometry()&&o.getSource().getGeometry().visible){e.detachEvent('geometryChanged',g,this);c();}};if(!e.getGeometry()||!e.getGeometry().visible){e.attachEvent('geometryChanged',g,this);}else{c();}};
var _=function(e){var p=e.getParameters();var r;var o=e.getSource();if(p.type==="propertyChanged"&&p.name==="visible"){r=this._getRelevantOverlays(o);if(p.value===true){this.executeWhenVisible(o,function(){this.evaluateEditable(r,{onRegistration:false});}.bind(this));}else{this.evaluateEditable(r,{onRegistration:false});}}else if(p.type==="afterRendering"){if(this.getDesignTime().getStatus()==='synced'){this.evaluateEditable([o],{onRegistration:false});}else{this.getDesignTime().attachEventOnce("synced",function(){this.evaluateEditable([o],{onRegistration:false});},this);}}else if(p.type==="insertAggregation"||p.type==="removeAggregation"){r=this._getRelevantOverlays(o,p.name);this.evaluateEditable(r,{onRegistration:false});}else if(p.type==="addOrSetAggregation"){if(this.getDesignTime().getStatus()==='synced'){r=this._getRelevantOverlays(o,p.name);this.evaluateEditable(r,{onRegistration:false});}else{this.getDesignTime().attachEventOnce("synced",function(){r=this._getRelevantOverlays(o,p.name);this.evaluateEditable(r,{onRegistration:false});},this);}}};
B.prototype._getRelevantOverlays=function(o,A){var b=o.getRelevantOverlays();if(b.length===0){var r=a.findAllOverlaysInContainer(o);if(A){var c=o.getAggregationOverlay(A);var d=c?c.getChildren():[];d=d.filter(function(e){return r.indexOf(e)===-1;});r=r.concat(d);}o.setRelevantOverlays(r);return r;}return b;};
B.prototype.evaluateEditable=function(o,p){var b=[];if(!p.onRegistration&&this.getDesignTime()&&this.getDesignTime().getBusyPlugins().length){return;}this.setProcessingStatus(true);o.forEach(function(c){var e=c.getElement()&&c.getDesignTimeMetadata()&&!c.getDesignTimeMetadata().markedAsNotAdaptable()&&this._isEditable(c,p);if(e&&typeof e.then==="function"){e.then(function(v){this._handleModifyPluginList(c,v);}.bind(this));b.push(e);}else{this._handleModifyPluginList(c,e);}}.bind(this));if(b.length){Promise.all(b).then(function(){this.setProcessingStatus(false);}.bind(this)).catch(function(){this.setProcessingStatus(false);}.bind(this));}else{this.setProcessingStatus(false);}};
B.prototype._handleModifyPluginList=function(o,e){if(e!==undefined&&e!==null){if(typeof e==="boolean"){this._modifyPluginList(o,e);}else{this._modifyPluginList(o,e.asChild,false);this._modifyPluginList(o,e.asSibling,true);}}};
B.prototype._modifyPluginList=function(o,i,b){if(i){this.addToPluginsList(o,b);}else{this.removeFromPluginsList(o,b);}};
B.prototype._retrievePluginName=function(s){var n=this.getMetadata().getName();if(s!==undefined){n+=s?".asSibling":".asChild";}return n;};
B.prototype._isEditableByPlugin=function(o,s){var p=this._retrievePluginName(s);var b=o.getEditableByPlugins();return b.indexOf(p)>-1;};
B.prototype.registerElementOverlay=function(o){this.executeWhenVisible(o,function(){this.evaluateEditable([o],{onRegistration:true});o.attachElementModified(_,this);}.bind(this));};
B.prototype.deregisterElementOverlay=function(o){this.removeFromPluginsList(o);this.removeFromPluginsList(o,true);this.removeFromPluginsList(o,false);o.detachElementModified(_,this);};
B.prototype.hasStableId=function(o){return h(o);};
B.prototype.getVariantManagementReference=function(o){var v;if(o.getVariantManagement){v=o.getVariantManagement();}return v;};
B.prototype.checkAggregationsOnSelf=function(o,A,p){var d=o.getDesignTimeMetadata();var e=o.getElement();var b=d.getActionDataFromAggregations(A,o.getElement());var c=b.filter(function(g){if(g&&p){return g.aggregation===p;}return true;})[0];var s=c?c.changeType:null;var f=c&&c.changeOnRelevantContainer;if(f){e=o.getRelevantContainer();var r=O.getOverlay(e);if(!this.hasStableId(r)){return Promise.resolve(false);}}if(s){return this.hasChangeHandler(s,e).then(function(H){return H;});}return Promise.resolve(false);};
B.prototype.removeFromPluginsList=function(o,s){var n=this._retrievePluginName(s);o.removeEditableByPlugin(n);if(!o.getEditableByPlugins().length){o.setEditable(false);}};
B.prototype.addToPluginsList=function(o,s){var n=this._retrievePluginName(s);var p=o.getEditableByPlugins();if(p.indexOf(n)===-1){o.addEditableByPlugin(n);o.setEditable(true);}};
B.prototype.hasChangeHandler=function(c,e){return this._getChangeHandler(c,e).then(function(o){return!!o;});};
B.prototype._getChangeHandler=function(c,e,s){if(!s){s=e.getMetadata().getName();}var l=this.getCommandFactory().getFlexSettings().layer;return C.getInstance().getChangeHandler(c,s,e,J,l);};
B.prototype.isAvailable=function(e){return e.every(function(o){return this._isEditableByPlugin(o);},this);};
B.prototype._checkRelevantContainerStableID=function(A,e){if(A.changeOnRelevantContainer){var r=e.getRelevantContainer();var R=O.getOverlay(r);if(!this.hasStableId(R)){return false;}}return true;};
return B;},true);
sap.ui.predefine('sap/ui/rta/plugin/RTAElementMover',["sap/ui/dt/plugin/ElementMover","sap/ui/dt/OverlayUtil","sap/ui/rta/Utils","sap/ui/rta/command/CommandFactory","sap/ui/rta/plugin/Plugin","sap/ui/dt/OverlayRegistry","sap/ui/dt/MetadataPropagationUtil"],function(E,O,U,C,P,a,M){"use strict";
var R=E.extend("sap.ui.rta.plugin.RTAElementMover",{metadata:{library:"sap.ui.rta",properties:{commandFactory:{type:"any",defaultValue:C},movableTypes:{type:"string[]",defaultValue:["sap.ui.core.Element"]}},associations:{},events:{}}});
R.prototype.init=function(){this.oBasePlugin=new P({commandFactory:this.getCommandFactory()});};
R.prototype.exit=function(){this.oBasePlugin.destroy();};
R.prototype.setCommandFactory=function(o){this.setProperty("commandFactory",o);this.oBasePlugin.setCommandFactory(o);};
R.prototype.isEditable=function(o,b){var e=o.getElement();if(!this.isMovableType(e)){return Promise.resolve(false);}return this.checkMovable(o,b).then(function(m){o.setMovable(m);return m;});};
function i(o,b){var d=o.getDesignTimeMetadata();var p=o.getParentElementOverlay();if(!d||!p){return Promise.resolve(false);}var r=o.getRelevantContainer();var e=a.getOverlay(r);if(!e){return Promise.resolve(false);}return this.isMoveAvailableOnRelevantContainer(o).then(function(v){if(v){v=this.oBasePlugin.hasStableId(o)&&this.oBasePlugin.hasStableId(p)&&this.oBasePlugin.hasStableId(e);}return v;}.bind(this)).then(function(v){if(v){return c.call(this,o,e,b);}return v;}.bind(this));}
function c(o,r,b){var d=O.findAllUniqueAggregationOverlaysInContainer(o,r);var v=d.map(function(A){return this.checkTargetZone(A,o,b).then(function(V){return V?A:undefined;});}.bind(this));return Promise.all(v).then(function(V){V=V.filter(function(f){return!!f;});if(V.length<1){return false;}else if(V.length===1){var e=V[0].getChildren().filter(function(f){var g=f.getElement();return(g&&g.getVisible()&&g.getParent());});return e.length>1;}return true;});}
function h(A,e,r){var o=A.getDesignTimeMetadata();var m=o.getAction("move",e);if(!m){return Promise.resolve(false);}return this.oBasePlugin.hasChangeHandler(m.changeType,r);}
E.prototype._getMoveAction=function(o){var p;var b=o.getParentAggregationOverlay();if(b){p=b.getDesignTimeMetadata();}return p?p.getAction("move",o.getElement()):undefined;};
E.prototype.isMovableType=function(){return true;};
R.prototype.checkMovable=function(o,b){return i.call(this,o,b);};
R.prototype.checkTargetZone=function(A,o,b){var m=o||this.getMovedOverlay();return E.prototype.checkTargetZone.call(this,A,m,b).then(function(t){if(!t){return false;}var d=m.getElement();var T=A.getParent();var e=m.getRelevantContainer();if(!d||!T){return false;}var f=T.getElement();var g=A.getDesignTimeMetadata();var v=M.getRelevantContainerForPropagation(g.getData(),d);v=v||f;if(!e||!v||!this.oBasePlugin.hasStableId(T)||e!==v){return false;}if(m.getParent().getElement()!==f){if(!U.checkSourceTargetBindingCompatibility(d,f)){return false;}}return h.call(this,A,d,v);}.bind(this));};
R.prototype.isMoveAvailableOnRelevantContainer=function(o){var b;var m=this._getMoveAction(o);if(m&&m.changeType){b=o.getRelevantContainer();var r=a.getOverlay(b);if(!this.oBasePlugin.hasStableId(r)){return Promise.resolve(false);}return this.oBasePlugin.hasChangeHandler(m.changeType,b);}return Promise.resolve(false);};
R.prototype.isMoveAvailableForChildren=function(o){var d=o.getDesignTimeMetadata();var A=d.getAggregationNamesWithAction("move");var b=[];A.forEach(function(e){var f=o.getAggregationOverlay(e);if(f){var g=f.getChildren();var j=g.map(this.checkMovable.bind(this));b=b.concat(j);}else{b.push(Promise.resolve(false));}}.bind(this));return Promise.all(b).then(function(m){return m.some(function(e){return e;});});};
R.prototype.buildMoveCommand=function(){var m=this.getMovedOverlay();var p=m.getParentAggregationOverlay();var o=m.getElement();var s=this._getSource();var r=m.getRelevantContainer();var t=O.getParentInformation(m);var S=s.index;var T=t.index;var b=this._compareSourceAndTarget(s,t);if(b){return Promise.resolve();}delete s.index;delete t.index;var v=this.oBasePlugin.getVariantManagementReference(m);return this.getCommandFactory().getCommandFor(r,"Move",{movedElements:[{element:o,sourceIndex:S,targetIndex:T}],source:s,target:t},p.getDesignTimeMetadata(),v);};
return R;},true);
sap.ui.predefine('sap/ui/rta/plugin/Remove',["sap/ui/rta/plugin/Plugin","sap/ui/rta/Utils","sap/ui/rta/command/CompositeCommand","sap/ui/dt/OverlayRegistry","sap/ui/events/KeyCodes","sap/base/Log"],function(P,U,C,O,K,L){"use strict";
var R=P.extend("sap.ui.rta.plugin.Remove",{metadata:{library:"sap.ui.rta",properties:{},associations:{},events:{}}});
R.prototype.registerElementOverlay=function(o){if(this.isEnabled([o])){o.attachBrowserEvent("keydown",this._onKeyDown,this);}P.prototype.registerElementOverlay.apply(this,arguments);};
R.prototype._isEditable=function(e){var E=e.getElement();var r=this.getAction(e);if(r&&r.changeType){if(r.changeOnRelevantContainer){E=e.getRelevantContainer();}return this.hasChangeHandler(r.changeType,E).then(function(h){return h&&this._checkRelevantContainerStableID(r,e)&&this.hasStableId(e);}.bind(this));}return false;};
R.prototype.isEnabled=function(e){var E=e[0];var a=this.getAction(E);var i=false;if(!a){return i;}if(typeof a.isEnabled!=="undefined"){if(typeof a.isEnabled==="function"){i=a.isEnabled(E.getElement());}else{i=a.isEnabled;}}else{i=true;}return i&&this._canBeRemovedFromAggregation(e);};
R.prototype._canBeRemovedFromAggregation=function(e){var o=e[0];var E=o.getElement();var p=E.getParent();if(!p){return false;}var a=p.getAggregation(E.sParentAggregationName);if(!Array.isArray(a)){return true;}if(a.length===1){return false;}var n=e.length;var i=a.filter(function(E){var b=O.getOverlay(E);return!(b&&b.getElementVisibility());});return!(i.length===(a.length-n));};
R.prototype._getConfirmationText=function(o){var a=this.getAction(o);if(a&&a.getConfirmationText){return a.getConfirmationText(o.getElement());}};
R.prototype.deregisterElementOverlay=function(o){if(this.isEnabled([o])){o.detachBrowserEvent("keydown",this._onKeyDown,this);}P.prototype.deregisterElementOverlay.apply(this,arguments);};
R.prototype._onKeyDown=function(e){if(e.keyCode===K.DELETE){e.stopPropagation();this.removeElement();}};
R.prototype.removeElement=function(e){var t=e||this.getSelectedOverlays();t=t.filter(function(E){return this.isEnabled([E]);},this);if(t.length>0){this.handler(t);}};
R.prototype._getRemoveCommand=function(r,d,v){return this.getCommandFactory().getCommandFor(r,"Remove",{removedElement:r},d,v);};
R.prototype._fireElementModified=function(c){if(c.getCommands().length){this.fireElementModified({command:c});}};
R.prototype.handler=function(e){var p=[];var c=new C();function s(o){o.setSelected(true);setTimeout(function(){o.focus();},0);}var n=R._getElementToFocus(e);e.forEach(function(o){var r=o.getElement();var d=o.getDesignTimeMetadata();var v=this.getVariantManagementReference(o);var a=this._getConfirmationText(o);p.push(Promise.resolve().then(function(){if(a){return U.openRemoveConfirmationDialog(r,a);}return true;}).then(function(b){if(!b){throw Error("Cancelled");}return this._getRemoveCommand(r,d,v);}.bind(this)).then(function(b){c.addCommand(b);}).catch(function(E){if(E&&E.message==="Cancelled"){if(e.length===1){n=o;}}else{throw E;}}));o.setSelected(false);},this);if(p.length){return Promise.all(p).then(function(){s(n);this._fireElementModified(c);}.bind(this)).catch(function(E){L.error("Error during remove: ",E);});}};
R._getElementToFocus=function(s){var n;if(s.length===1){var o=s[0];var S=o.getParent().getAggregation(o.sParentAggregationName);if(S.length>1){var i=S.indexOf(o);var c=S.slice(i+1);if(i!==0){c=c.concat(S.slice(0,i).reverse());}n=c.filter(function(a){return a.getElement().getVisible();}).shift();}}if(!n){n=O.getOverlay(s[0].getRelevantContainer());}return n;};
R.prototype.getMenuItems=function(e){return this._getMenuItems(e,{pluginId:"CTX_REMOVE",rank:60,icon:"sap-icon://less"});};
R.prototype.getActionName=function(){return"remove";};
return R;},true);
sap.ui.predefine('sap/ui/rta/plugin/Rename',["sap/ui/rta/plugin/Plugin","sap/ui/rta/plugin/RenameHandler","sap/base/Log"],function(P,R,L){"use strict";
var a=P.extend("sap.ui.rta.plugin.Rename",{metadata:{library:"sap.ui.rta",properties:{oldValue:"string"},associations:{},events:{editable:{},nonEditable:{}}}});
a.prototype.exit=function(){P.prototype.exit.apply(this,arguments);this.setBusy(false);R._exit.call(this);};
a.prototype.setDesignTime=function(d){R._setDesignTime.call(this,d);};
a.prototype.startEdit=function(o){var e=o.getElement();var d=o.getDesignTimeMetadata();var D=d.getAction("rename",e).domRef;R.startEdit.call(this,{overlay:o,domRef:D,pluginMethodName:"plugin.Rename.startEdit"});};
a.prototype.stopEdit=function(r){R._stopEdit.call(this,r,"plugin.Rename.stopEdit");};
a.prototype.handler=function(e){this.startEdit(e[0]);};
a.prototype.isRenameAvailable=function(o){return this._isEditableByPlugin(o);};
a.prototype.isRenameEnabled=function(o){return this.isEnabled(o);};
a.prototype.isEnabled=function(e){if(e.length>1){return false;}var o=e[0];var i=true;var A=this.getAction(o);if(!A){i=false;}if(i&&typeof A.isEnabled!=="undefined"){if(typeof A.isEnabled==="function"){i=A.isEnabled(o.getElement());}else{i=A.isEnabled;}}if(i){var d=o.getDesignTimeMetadata();if(!d.getAssociatedDomRef(o.getElement(),A.domRef)){i=false;}}return i;};
a.prototype.registerElementOverlay=function(o){o.attachEvent("editableChange",R._manageClickEvent,this);P.prototype.registerElementOverlay.apply(this,arguments);};
a.prototype._isEditable=function(o){var e=o.getElement();var r=this.getAction(o);if(r&&r.changeType){if(r.changeOnRelevantContainer){e=o.getRelevantContainer();}return this.hasChangeHandler(r.changeType,e).then(function(h){return h&&this._checkRelevantContainerStableID(r,o)&&this.hasStableId(o);}.bind(this));}return false;};
a.prototype.deregisterElementOverlay=function(o){o.detachEvent("editableChange",R._manageClickEvent,this);o.detachBrowserEvent("click",R._onClick,this);this.removeFromPluginsList(o);};
a.prototype._emitLabelChangeEvent=function(){var t=R._getCurrentEditableFieldText.call(this);if(this.getOldValue()!==t){this._$oEditableControlDomRef.text(t);return Promise.resolve(this._oEditedOverlay).then(function(e){var r=e.getElement();var d=e.getDesignTimeMetadata();var v=this.getVariantManagementReference(e);return this.getCommandFactory().getCommandFor(r,"rename",{renamedElement:r,newValue:t},d,v);}.bind(this)).then(function(r){this.fireElementModified({command:r});}.bind(this)).catch(function(e){L.error("Error during rename : ",e);});}return Promise.resolve();};
a.prototype.getMenuItems=function(e){return this._getMenuItems(e,{pluginId:"CTX_RENAME",rank:10,icon:"sap-icon://edit"});};
a.prototype.getActionName=function(){return"rename";};
return a;},true);
sap.ui.predefine('sap/ui/rta/plugin/RenameHandler',["sap/ui/thirdparty/jquery","sap/ui/rta/plugin/Plugin","sap/ui/dt/Overlay","sap/ui/dt/ElementUtil","sap/ui/dt/OverlayRegistry","sap/ui/rta/Utils","sap/ui/dt/DOMUtil","sap/ui/events/KeyCodes"],function(q,P,O,E,a,U,D,K){"use strict";var R={_manageClickEvent:function(e){var o=e.getSource?e.getSource():e;if(o.isSelected()&&this.isRenameAvailable(o)&&this.isRenameEnabled([o])){o.attachBrowserEvent("click",R._onClick,this);}else{o.detachBrowserEvent("click",R._onClick,this);}},startEdit:function(p){this.setBusy(true);this._oEditedOverlay=p.overlay;var e=p.overlay.getElement();var d=this._oEditedOverlay.getDesignTimeMetadata();var v=d.getAssociatedDomRef(e,p.domRef);if(!U.isElementInViewport(v)){v.get(0).scrollIntoView();}this._$oEditableControlDomRef=q(v);var w=0;var o=a.getOverlay(v instanceof q?v.get(0).id:v.id);if(!o){o=this._oEditedOverlay;var _=q(E.getDomRef(e));var b=this._$oEditableControlDomRef.parent();var c=parseInt(_.outerWidth());if(!isNaN(c)){var i=parseInt(this._$oEditableControlDomRef.outerWidth());var f=parseInt(b.outerWidth());w=c-i;if(w<0&&f){if(b.get(0).id!==_.get(0).id&&b.children(":visible").length===1&&b.children(":visible").get(0).id===this._$oEditableControlDomRef.get(0).id&&c>f){w=c-f;}else{w=0;}}}}var g=q("<div class='sapUiRtaEditableField'></div>").css({"white-space":"nowrap",overflow:"hidden",width:"calc(100% - ("+w+"px))"}).appendTo(o.$());this._$editableField=q("<div contentEditable='true'></div>").appendTo(g);if(this._$oEditableControlDomRef.text()===""){this._$oEditableControlDomRef.text("_?_");this._$editableField.text("");}else{this._$editableField.text(this._$oEditableControlDomRef.text());}this.setOldValue(R._getCurrentEditableFieldText.call(this));D.copyComputedStyle(this._$oEditableControlDomRef,this._$editableField);this._$editableField.children().remove();this._$editableField.css('visibility','hidden');this._$editableField.css({"-moz-user-modify":"read-write","-webkit-user-modify":"read-write","-ms-user-modify":"read-write","user-modify":"read-write","text-overflow":"clip","white-space":"nowrap"});if(sap.ui.Device.browser.name==="ed"&&e.getMetadata().getName()==="sap.ui.fl.variants.VariantManagement"){this._$editableField.css({"line-height":"normal"});}O.getMutationObserver().ignoreOnce({target:this._$oEditableControlDomRef.get(0)});this._$editableField.one("focus",R._onEditableFieldFocus.bind(this));this._$editableField.on("blur",R._onEditableFieldBlur.bind(this));this._$editableField.on("keydown",R._onEditableFieldKeydown.bind(this));this._$editableField.on("dragstart",R._stopPropagation.bind(this));this._$editableField.on("drag",R._stopPropagation.bind(this));this._$editableField.on("dragend",R._stopPropagation.bind(this));this._$editableField.on("click",R._stopPropagation.bind(this));this._$editableField.on("mousedown",R._stopPropagation.bind(this));setTimeout(function(){this._$oEditableControlDomRef.css("visibility","hidden");g.offset({left:this._$oEditableControlDomRef.offset().left});this._$editableField.offset({left:this._$oEditableControlDomRef.offset().left});this._$editableField.offset({top:this._$oEditableControlDomRef.offset().top});this._$editableField.css('visibility','');this._$editableField.focus();p.overlay.setSelected(true);sap.ui.getCore().getEventBus().publish('sap.ui.rta',p.pluginMethodName,{overlay:p.overlay,editableField:this._$editableField});}.bind(this),0);},_setDesignTime:function(d){this._aSelection=[];var o=this.getDesignTime();if(o){o.getSelectionManager().detachChange(R._onDesignTimeSelectionChange,this);}P.prototype.setDesignTime.apply(this,arguments);if(d){d.getSelectionManager().attachChange(R._onDesignTimeSelectionChange,this);this._aSelection=this.getSelectedOverlays();}},_onDesignTimeSelectionChange:function(e){var s=e.getParameter("selection");this._aSelection.forEach(R._manageClickEvent,this);s.forEach(R._manageClickEvent,this);this._aSelection=s;},_stopPropagation:function(e){e.stopPropagation();},_preventDefault:function(e){e.preventDefault();},_onEditableFieldFocus:function(e){var b=e.target;var r=document.createRange();r.selectNodeContents(b);var s=window.getSelection();s.removeAllRanges();s.addRange(r);},_stopEdit:function(r,p){var o;this.setBusy(false);if(this._$oEditableControlDomRef.text()==="_?_"){this._$oEditableControlDomRef.text("");}this._oEditedOverlay.$().find(".sapUiRtaEditableField").remove();O.getMutationObserver().ignoreOnce({target:this._$oEditableControlDomRef.get(0)});this._$oEditableControlDomRef.css("visibility","visible");if(r){o=this._oEditedOverlay;o.setSelected(true);o.focus();}delete this._$editableField;delete this._$oEditableControlDomRef;delete this._oEditedOverlay;delete this._bBlurOrKeyDownStarted;sap.ui.getCore().getEventBus().publish('sap.ui.rta',p,{overlay:o});},_onEditableFieldBlur:function(){return R._handlePostRename.call(this,false);},_handlePostRename:function(r,e){if(!this._bBlurOrKeyDownStarted){this._bBlurOrKeyDownStarted=true;if(e){R._preventDefault.call(this,e);R._stopPropagation.call(this,e);}return this._emitLabelChangeEvent().then(function(f){this.stopEdit(r);if(typeof f==="function"){f();}}.bind(this));}return Promise.resolve();},_onEditableFieldKeydown:function(e){switch(e.keyCode){case K.ENTER:return R._handlePostRename.call(this,true,e);case K.ESCAPE:this.stopEdit(true);R._preventDefault.call(this,e);break;case K.DELETE:R._stopPropagation.call(this,e);break;default:}return Promise.resolve();},_getCurrentEditableFieldText:function(){var t=this._$editableField.text().trim();return t===""?'\xa0':t;},_onClick:function(e){var o=sap.ui.getCore().byId(e.currentTarget.id);if(this.isRenameEnabled([o])&&!e.metaKey&&!e.ctrlKey){this.startEdit(o);R._preventDefault.call(this,e);}},_exit:function(){if(this._$oEditableControlDomRef){this.stopEdit(false);}}};return R;},true);
sap.ui.predefine('sap/ui/rta/plugin/Selection',["sap/ui/rta/plugin/Plugin","sap/ui/rta/Utils","sap/ui/dt/OverlayRegistry","sap/ui/events/KeyCodes","sap/ui/dt/Overlay","sap/base/util/restricted/_intersection","sap/ui/Device"],function(P,U,O,K,a,_,D){"use strict";
var S=P.extend("sap.ui.rta.plugin.Selection",{metadata:{library:"sap.ui.rta",properties:{multiSelectionRequiredPlugins:{type:"string[]"}},associations:{},events:{elementEditableChange:{parameters:{editable:{type:"boolean"}}}}}});
S.prototype.init=function(){this._multiSelectionValidator=this._multiSelectionValidator.bind(this);P.prototype.init.apply(this,arguments);};
S.prototype._checkDeveloperMode=function(o,f){if(f){var g=this.getCommandFactory().getFlexSettings().developerMode;if(g&&this.hasStableId(o)){o.setEditable(true);o.setSelectable(true);this.fireElementEditableChange({editable:true});return true;}}return false;};
S.prototype.registerElementOverlay=function(o){var f=o.getDesignTimeMetadata();if(!f.markedAsNotAdaptable()&&!this._checkDeveloperMode(o,f)){o.attachEditableChange(this._onEditableChange,this);this._adaptSelectable(o);}o.attachBrowserEvent("click",this._selectOverlay,this);o.attachBrowserEvent("contextmenu",this._selectOverlay,this);o.attachBrowserEvent("keydown",this._onKeyDown,this);o.attachBrowserEvent("mousedown",this._onMouseDown,this);o.attachBrowserEvent("mouseover",this._onMouseover,this);o.attachBrowserEvent("mouseleave",this._onMouseleave,this);};
S.prototype._onEditableChange=function(E){var o=E.getSource();this._adaptSelectable(o);};
S.prototype._adaptSelectable=function(o){var s=o.getEditable();if(o.getSelectable()!==s){o.setSelectable(s);if(!s){this._removePreviousHover();}this.fireElementEditableChange({editable:s});}};
S.prototype.deregisterElementOverlay=function(o){o.detachBrowserEvent("click",this._selectOverlay,this);o.detachBrowserEvent("contextmenu",this._selectOverlay,this);o.detachBrowserEvent("keydown",this._onKeyDown,this);o.detachBrowserEvent("mousedown",this._onMouseDown,this);o.detachBrowserEvent("mouseover",this._onMouseover,this);o.detachBrowserEvent("mouseleave",this._onMouseleave,this);o.detachEditableChange(this._onEditableChange,this);};
S.prototype._setFocusOnOverlay=function(o,E){if(o&&o.getSelectable()){o.focus();E.stopPropagation();}};
S.prototype._onKeyDown=function(E){var o=U.getFocusedOverlay();if(E.keyCode===K.ENTER){this._selectOverlay(E);}else if(E.keyCode===K.ARROW_UP&&E.shiftKey===false&&E.altKey===false){if(o){var p=U.getFocusableParentOverlay(o);this._setFocusOnOverlay(p,E);E.preventDefault();}}else if(E.keyCode===K.ARROW_DOWN&&E.shiftKey===false&&E.altKey===false){if(o){var f=U.getFirstFocusableDescendantOverlay(o);this._setFocusOnOverlay(f,E);E.preventDefault();}}else if(E.keyCode===K.ARROW_LEFT&&E.shiftKey===false&&E.altKey===false){if(o){var g=U.getPreviousFocusableSiblingOverlay(o);this._setFocusOnOverlay(g,E);E.preventDefault();}}else if(E.keyCode===K.ARROW_RIGHT&&E.shiftKey===false&&E.altKey===false){if(o){var n=U.getNextFocusableSiblingOverlay(o);this._setFocusOnOverlay(n,E);E.preventDefault();}}};
S.prototype._selectOverlay=function(E){var o=O.getOverlay(E.currentTarget.id);var m=E.metaKey||E.ctrlKey;var C=E.type==="contextmenu";if(o&&o.getSelectable()){if(o.isSelected()){if(!C){this.getDesignTime().getSelectionManager().remove(o);}}else if(m){this.getDesignTime().getSelectionManager().add(o);}else{this.getDesignTime().getSelectionManager().set(o);}E.preventDefault();E.stopPropagation();}};
S.prototype._onMouseDown=function(E){if(D.browser.name==="ie"){var t=O.getOverlay(E.target.id);var T=jQuery(E.target).hasClass("sapUiDtOverlayScrollContainer");var o=O.getOverlay(E.currentTarget.id);if(o&&(T||t instanceof a)){if(o.getSelectable()){o.focus();E.stopPropagation();}else{o.getDomRef().blur();}}}};
S.prototype._onMouseover=function(E){var o=O.getOverlay(E.currentTarget.id);if(o.isSelectable()){if(o!==this._oHoverTarget){this._removePreviousHover();this._oHoverTarget=o;o.addStyleClass("sapUiRtaOverlayHover");}E.preventDefault();E.stopPropagation();}};
S.prototype._onMouseleave=function(E){var o=O.getOverlay(E.currentTarget.id);if(o.isSelectable()){this._removePreviousHover();E.preventDefault();E.stopPropagation();}};
S.prototype._removePreviousHover=function(){if(this._oHoverTarget){this._oHoverTarget.removeStyleClass("sapUiRtaOverlayHover");}delete this._oHoverTarget;};
S.prototype.setDesignTime=function(){if(this.getDesignTime()){this.getDesignTime().getSelectionManager().removeValidator(this._multiSelectionValidator);}P.prototype.setDesignTime.apply(this,arguments);if(this.getDesignTime()){this.getDesignTime().getSelectionManager().addValidator(this._multiSelectionValidator);}};
S.prototype._multiSelectionValidator=function(E){return(E.length===1||(b(E,this.getMultiSelectionRequiredPlugins())&&c(E)&&(d(E)||e(E))));};
function b(E,m){var s=m.slice();E.forEach(function(o){s=_(s,o.getEditableByPlugins());});return s.length>0;}
function c(E){return E.every(function(o){return o.getRelevantContainer()===E[0].getRelevantContainer();});}
function d(E){return E.every(function(o){return o.getParentElementOverlay()===E[0].getParentElementOverlay();});}
function e(E){return E.every(function(o){return o.getElement().getMetadata().getName()===E[0].getElement().getMetadata().getName();});}
return S;},true);
sap.ui.predefine('sap/ui/rta/plugin/Settings',["sap/ui/rta/plugin/Plugin","sap/ui/rta/Utils","sap/ui/dt/Util","sap/base/Log"],function(P,U,D,B){"use strict";
var S=P.extend("sap.ui.rta.plugin.Settings",{metadata:{library:"sap.ui.rta",properties:{commandStack:{type:"any"}},associations:{},events:{}}});
S.prototype._isEditable=function(o){var s=this.getAction(o);if(s){if(s.handler){return this.hasStableId(o);}var h=Object.keys(s).some(function(a){var b=s[a];return b.handler&&this._checkRelevantContainerStableID(b,o);}.bind(this));if(h){return this.hasStableId(o);}}return false;};
S.prototype.isEnabled=function(e){var E=e[0];var a=this.getAction(E);if(!a){return false;}if(typeof a.isEnabled!=="undefined"){if(typeof a.isEnabled==="function"){return a.isEnabled(E.getElement());}return a.isEnabled;}return true;};
S.prototype._getUnsavedChanges=function(i,c){var e;var u=this.getCommandStack().getAllExecutedCommands().filter(function(C){e=C.getElementId&&C.getElementId()||C.getElement&&C.getElement().getId();if(e===i&&c.indexOf(C.getChangeType())>=0){return true;}}).map(function(C){return C.getPreparedChange();});return u;};
S.prototype._handleFlexChangeCommand=function(c,s,C){var m=c.changeSpecificData;var v;var a=c.selectorElement||c.selectorControl;var b;var o;if(a.controlType){b=a.controlType;}else{o=a;}return this._getChangeHandler(m.changeType,o,b).then(function(d){if(s[0].getVariantManagement&&d&&d.revertChange){v=s[0].getVariantManagement();}return this.getCommandFactory().getCommandFor(a,"settings",m,undefined,v);}.bind(this)).then(function(d){return C.addCommand(d);});};
S.prototype._handleAppDescriptorChangeCommand=function(c,e,C){var m=c.changeSpecificData;var o=c.appComponent;var M=o.getManifest();var r=M["sap.app"].id;return this.getCommandFactory().getCommandFor(e,"appDescriptor",{reference:r,appComponent:o,changeType:m.appDescriptorChangeType,parameters:m.content.parameters,texts:m.content.texts}).then(function(a){return C.addCommand(a);});};
S.prototype._handleCompositeCommand=function(e,E,c){var C;return this.getCommandFactory().getCommandFor(E,"composite").then(function(_){C=_;}).then(function(){return c.map(function(m){var a=m.changeSpecificData;if(a.changeType){return this._handleFlexChangeCommand(m,e,C);}else if(a.appDescriptorChangeType){return this._handleAppDescriptorChangeCommand(m,E,C);}},this);}.bind(this)).then(function(p){return Promise.all(p);}).then(function(){if(C.getCommands().length>0){this.fireElementModified({command:C});}}.bind(this));};
S.prototype.handler=function(e,p){p=p||{};var E=e[0].getElement();var h=p.fnHandler;if(!h){h=e[0].getDesignTimeMetadata().getAction("settings").handler;if(!h){throw new Error("Handler not found for settings action");}}p.getUnsavedChanges=this._getUnsavedChanges.bind(this);p.styleClass=U.getRtaStyleClassName();return h(E,p).then(function(c){if(c.length>0){return this._handleCompositeCommand(e,E,c);}}.bind(this)).catch(function(v){throw D.propagateError(v,"Settings#handler","Error occured during handler execution","sap.ui.rta.plugin");});};
S.prototype.getMenuItems=function(e){var E=e[0];var s=this.getAction(E);var r=110;var p="CTX_SETTINGS";if(s){if(s.handler&&this._checkRelevantContainerStableID(s,E)){return this._getMenuItems([E],{pluginId:p,rank:r,icon:this._getActionIcon(s)});}var m=[];var a=Object.keys(s);var A=0;a.forEach(function(b){var o=s[b];var c=this.getActionText(E,o,o.name);if(o.handler&&this._checkRelevantContainerStableID(o,E)){m.push({id:p+A,text:c,icon:this._getActionIcon(o),enabled:(typeof o.isEnabled==='function'&&(function(e){return o.isEnabled(e[0].getElement());})||o.isEnabled),handler:function(h,e,d){d=d||{};d.fnHandler=h;return this.handler(e,d);}.bind(this,o.handler),rank:r+A});A++;}else{B.warning("Handler not found for settings action '"+c+"' or relevant container has no stable id");}},this);return m;}return[];};
S.prototype._getActionIcon=function(s){var d="sap-icon://key-user-settings";var a=s.icon;if(!a){return d;}if(typeof a!=="string"){B.error("Icon setting for settingsAction should be a string");return d;}return a;};
S.prototype.getActionName=function(){return"settings";};
return S;},true);
sap.ui.predefine('sap/ui/rta/plugin/Split',["sap/ui/rta/plugin/Plugin","sap/ui/dt/Util","sap/ui/fl/Utils","sap/base/util/uid"],function(P,D,F,u){"use strict";
var S=P.extend("sap.ui.rta.plugin.Split",{metadata:{library:"sap.ui.rta",properties:{},associations:{},events:{}}});
S.prototype._isEditable=function(o){var s=this.getAction(o);if(s&&s.changeType&&s.changeOnRelevantContainer){var r=o.getRelevantContainer();return this.hasChangeHandler(s.changeType,r).then(function(h){return h&&this.hasStableId(o)&&this._checkRelevantContainerStableID(s,o);}.bind(this));}return false;};
S.prototype.isAvailable=function(e){if(e.length!==1){return false;}var E=e[0];if(!this._isEditableByPlugin(E)){return false;}var s=this.getAction(E);var o=E.getElement();if(s&&s.getControlsCount(o)<=1){return false;}return true;};
S.prototype.isEnabled=function(e){var E=e[0];var a=this.getAction(E);if(!a||!this.isAvailable(e)){return false;}var A=true;if(typeof a.isEnabled!=="undefined"){if(typeof a.isEnabled==="function"){A=a.isEnabled(E.getElement());}else{A=a.isEnabled;}}return A;};
S.prototype.handleSplit=function(e){var s=e.getElement();var p=s.getParent();var d=e.getDesignTimeMetadata();var E=this.getAction(e).getControlsCount(s);var v=F.getViewForControl(s);var n=[];for(var i=0;i<E;i++){n.push(v.createId(u()));}var o=this.getAction(e);var V=this.getVariantManagementReference(e,o);return this.getCommandFactory().getCommandFor(s,"split",{newElementIds:n,source:s,parentElement:p},d,V).then(function(a){this.fireElementModified({command:a});}.bind(this)).catch(function(a){throw D.propagateError(a,"Split#handleSplit","Error occured during handleSplit execution","sap.ui.rta.plugin");});};
S.prototype.getMenuItems=function(e){return this._getMenuItems(e,{pluginId:"CTX_UNGROUP_FIELDS",rank:100,icon:"sap-icon://split"});};
S.prototype.getActionName=function(){return"split";};
S.prototype.handler=function(e){this.handleSplit(e[0]);};
return S;},true);
sap.ui.predefine('sap/ui/rta/plugin/Stretch',["sap/ui/rta/plugin/Plugin","sap/ui/dt/OverlayRegistry","sap/ui/dt/OverlayUtil","sap/base/util/includes","sap/base/util/restricted/_debounce"],function(P,O,a,b,_){"use strict";
var S=P.extend("sap.ui.rta.plugin.Stretch",{metadata:{library:"sap.ui.rta",properties:{},associations:{stretchCandidates:{type:"sap.ui.core.Control",multiple:true}},events:{}}});
S.STRETCHSTYLECLASS="sapUiRtaStretchPaddingTop";
S.prototype.setDesignTime=function(d){P.prototype.setDesignTime.apply(this,arguments);if(d){d.attachEventOnce("synced",this._onDTSynced,this);}};
S.prototype.exit=function(){if(this.getDesignTime()){this.getDesignTime().detachEvent("elementOverlayAdded",this._onElementOverlayChanged);this.getDesignTime().detachEvent("elementOverlayMoved",this._onElementOverlayChanged);this.getDesignTime().detachEvent("elementPropertyChanged",this._onElementPropertyChanged);this.getDesignTime().detachEvent("elementOverlayEditableChanged",this._onElementOverlayEditableChanged);this.getDesignTime().detachEvent("elementOverlayDestroyed",this._onElementOverlayDestroyed);}};
S.prototype.addStretchCandidate=function(o){var e=o.getElement();if(!b(this.getStretchCandidates(),e.getId())){this.addAssociation("stretchCandidates",e);}};
S.prototype.removeStretchCandidate=function(o){this.removeAssociation("stretchCandidates",o.getElement());this._toggleStyleClass(o,false);};
S.prototype.registerElementOverlay=function(o){this._checkParentAndAddToStretchCandidates(o);o.attachElementModified(this._onElementModified,this);P.prototype.registerElementOverlay.apply(this,arguments);};
S.prototype.deregisterElementOverlay=function(o){this._toggleStyleClass(o,false);};
S.prototype._isEditable=function(){return false;};
S.prototype._onDTSynced=function(){this._setStyleClassForAllStretchCandidates();this.getDesignTime().attachEvent("elementOverlayAdded",this._onElementOverlayChanged,this);this.getDesignTime().attachEvent("elementOverlayMoved",this._onElementOverlayChanged,this);this.getDesignTime().attachEvent("elementPropertyChanged",this._onElementPropertyChanged,this);this.getDesignTime().attachEvent("elementOverlayEditableChanged",this._onElementOverlayEditableChanged,this);this.getDesignTime().attachEvent("elementOverlayDestroyed",this._onElementOverlayDestroyed,this);};
S.prototype._onElementModified=function(e){if(this.getDesignTime().getBusyPlugins().length){return;}var p=e.getParameters();var o=e.getSource();if(p.type==="afterRendering"){if(!this.fnDebounced){this.fnDebounced=_(function(){this._setStyleClassForAllStretchCandidates(this._getNewStretchCandidates(this._aOverlaysCollected));this._aOverlaysCollected=[];this.fnDebounced=undefined;}.bind(this),16);}if(!this._aOverlaysCollected){this._aOverlaysCollected=[];}if(!b(this._aOverlaysCollected,o)){this._aOverlaysCollected.push(o);this.fnDebounced();}}};
S.prototype._onElementOverlayDestroyed=function(e){if(this.getDesignTime().getBusyPlugins().length){return;}var n=[];var p=e.getParameters().elementOverlay.getParentElementOverlay();if(p&&!p._bIsBeingDestroyed){var r=this._getRelevantOverlays(p).filter(function(o){return o.getElement();});n=this._getNewStretchCandidates(r);}this._setStyleClassForAllStretchCandidates(n);};
S.prototype._onElementOverlayEditableChanged=function(e){var o=O.getOverlay(e.getParameters().id);if(this.getDesignTime().getBusyPlugins().length||!o){return;}var c=this._getRelevantOverlaysOnEditableChange(o);this._setStyleClassForAllStretchCandidates(c);};
S.prototype._onElementPropertyChanged=function(e){var o=O.getOverlay(e.getParameters().id);if(this.getDesignTime().getBusyPlugins().length||!o){return;}var r=this._getRelevantOverlays(o);var d=_(function(){if(!this.bIsDestroyed&&!o.bIsDestroyed){var n=this._getNewStretchCandidates(r).concat(this._getRelevantOverlaysOnEditableChange(o));n=n.filter(function(i,p,A){return A.indexOf(i)===p;});this._setStyleClassForAllStretchCandidates(n);}}.bind(this));r.forEach(function(o){o.attachEventOnce("geometryChanged",d);});};
S.prototype._onElementOverlayChanged=function(e){var o=O.getOverlay(e.getParameters().id);if(this.getDesignTime().getBusyPlugins().length||!o){return;}var r=this._getRelevantOverlays(o);var n=this._getNewStretchCandidates(r);this._setStyleClassForAllStretchCandidates(n);};
S.prototype._getRelevantOverlaysOnEditableChange=function(o){var r=b(this.getStretchCandidates(),o.getElement().getId())?[o.getElement().getId()]:[];var p=o.getParentAggregationOverlay();if(!p){return r;}var c=p.getChildren();c.splice(c.indexOf(o),1);var A=c.some(function(o){return o.getEditable()&&o.getGeometry();});if(A){return r;}return r.concat(this._getRelevantParents(o));};
S.prototype._getRelevantParents=function(o){var r=[];for(var i=0;i<25;i++){o=o.getParentElementOverlay();if(!o){return r;}if(!b(this.getStretchCandidates(),o.getElement().getId())){return r;}r.push(o.getElement().getId());}};
S.prototype._getNewStretchCandidates=function(o){var n=[];o.forEach(function(c){if(this._reevaluateStretching(c)){n.push(c.getElement().getId());}},this);return n;};
S.prototype._reevaluateStretching=function(o){if(!o.bIsDestroyed){var e=o.getAssociatedDomRef();if(e){var i=e.hasClass(S.STRETCHSTYLECLASS);var s=this._childrenAreSameSize(o,undefined,i);if(i&&!s){this.removeStretchCandidate(o);}else if(!i&&s){this.addStretchCandidate(o);return true;}}}};
S.prototype._checkParentAndAddToStretchCandidates=function(o){var p=o.getParentElementOverlay();var $=p&&p.getAssociatedDomRef();if($){if(this._startAtSamePosition(p,o)){if(this._childrenAreSameSize(p)){this.addStretchCandidate(p);}}}};
S.prototype._startAtSamePosition=function(p,o){if(p&&p.getGeometry()&&o.getGeometry()){if(p.getGeometry().position.top===o.getGeometry().position.top&&p.getGeometry().position.left===o.getGeometry().position.left){return true;}}};
S.prototype._childrenAreSameSize=function(r,c,i){var p=r.getGeometry();if(!p){return false;}var h=p.size.height;if(i){h-=parseInt(r.getElement().$().css("padding-top"));}var d=Math.round(p.size.width)*Math.round(h);c=c||a.getAllChildOverlays(r);var C=c.map(function(f){return f.getGeometry();});var o=a.getGeometry(C);if(!o){return false;}var e=Math.round(o.size.width)*Math.round(o.size.height);return e===d;};
S.prototype._atLeastOneDescendantEditable=function(r,c){var A=c.some(function(o){return o.getEditable()&&o.getGeometry();});if(A){return true;}var C=[];c.forEach(function(o){C=C.concat(a.getAllChildOverlays(o));});if(!C.length>0){return false;}if(this._childrenAreSameSize(r,C)){return this._atLeastOneDescendantEditable(r,C);}};
S.prototype._setStyleClassForAllStretchCandidates=function(s){if(!Array.isArray(s)){s=this.getStretchCandidates();}s.forEach(function(e){var o=O.getOverlay(e);var c=a.getAllChildOverlays(o);var A=this._atLeastOneDescendantEditable(o,c);var d=o.getEditable()&&A;this._toggleStyleClass(o,d);},this);};
S.prototype._toggleStyleClass=function(o,A){var e=o.getAssociatedDomRef();if(e){if(A){e.addClass(S.STRETCHSTYLECLASS);}else{e.removeClass(S.STRETCHSTYLECLASS);}}};
return S;},true);
sap.ui.predefine('sap/ui/rta/plugin/additionalElements/AddElementsDialog',["sap/ui/base/ManagedObject","sap/m/Label","sap/m/Dialog","sap/ui/model/json/JSONModel","sap/m/SearchField","sap/m/Button","sap/m/ButtonType","sap/m/Toolbar","sap/m/ToolbarSpacer","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/m/List","sap/m/CustomListItem","sap/m/ScrollContainer","sap/ui/model/Sorter","sap/base/Log","sap/m/VBox","sap/ui/rta/Utils","sap/m/library","sap/ui/layout/VerticalLayout","sap/m/Text"],function(M,L,D,J,S,B,a,T,b,F,c,d,e,f,g,h,V,U,m,i,j){"use strict";var k=m.ListType;var l=m.LabelDesign;
var A=M.extend("sap.ui.rta.plugin.additionalElements.AddElementsDialog",{metadata:{library:"sap.ui.rta",properties:{customFieldEnabled:{type:"boolean",defaultValue:false},businessContextVisible:{type:"boolean",defaultValue:false},title:{type:"string"}},events:{opened:{},openCustomField:{}}}});
A.prototype.init=function(){this._oTextResources=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");this._bAscendingSortOrder=false;this._oDialog=new D().addStyleClass("sapUIRtaFieldRepositoryDialog");this._oDialog.addStyleClass(U.getRtaStyleClassName());this._oDialog.removeStyleClass("sapUiPopupWithPadding");this._oDialog.setModel(new J({elements:[]}));var C=this._createContent();var n=this._createButtons();C.forEach(function(o){this._oDialog.addContent(o);},this);n.forEach(function(o){this._oDialog.addButton(o);},this);this._oDialog.setInitialFocus(this._oInput);};
A.prototype.exit=function(){this._oDialog.destroy();};
A.prototype._createContent=function(){this._oInput=new S({width:"100%",liveChange:[this._updateModelFilter,this]});var r=new B({text:"",icon:"sap-icon://sort",press:[this._resortList,this]});this._oCustomFieldButton=new B({text:"",icon:"sap-icon://add",tooltip:this._oTextResources.getText("BTN_FREP_CCF"),enabled:this.getCustomFieldEnabled(),press:[this._redirectToCustomFieldCreation,this]});this._oToolbarSpacer1=new b();this.oInputFields=new T({content:[this._oInput,r,this._oToolbarSpacer1,this._oCustomFieldButton]});this._oBCContainer=new i({visible:this.getBusinessContextVisible(),content:[new j({text:this._oTextResources.getText("BUSINESS_CONTEXT_TITLE")})]}).addStyleClass("sapUIRtaBusinessContextContainer");var o=new L({design:l.Standard,tooltip:"{tooltip}",text:{parts:[{path:"label"},{path:"referencedComplexPropertyName"},{path:"duplicateComplexName"}],formatter:function(t,R,u){if(u&&R){t+=" ("+R+")";}return t;}}});var n=new L({text:{parts:[{path:"originalLabel"}],formatter:function(O){if(O){return this._oTextResources.getText("LBL_FREP",O);}return"";}.bind(this)},visible:{parts:[{path:"originalLabel"}],formatter:function(O){if(O){return true;}return false;}}});var v=new V();v.addItem(o);v.addItem(n);var s=new g("label",this._bAscendingSortOrder);this._oList=new d({mode:"MultiSelect",includeItemInSelection:true,growing:true,growingScrollToLoad:true}).setNoDataText(this._oTextResources.getText("MSG_NO_FIELDS",this._oTextResources.getText("MULTIPLE_CONTROL_NAME").toLowerCase()));var p=new e({type:k.Active,selected:"{selected}",content:[v]});this._oList.bindItems({path:"/elements",template:p,sorter:s,key:function(C){switch(C.getProperty("type")){case"invisible":return C.getProperty("elementId");case"odata":return C.getProperty("name");case"custom":return C.getProperty("key");default:h.error("sap.ui.rta.plugin.additionalElements.AddElementsDialog#_createContent: unsupported data type");}}});var q=new f({content:this._oList,vertical:true,horizontal:false}).addStyleClass("sapUIRtaCCDialogScrollContainer");return[this.oInputFields,this._oBCContainer,q];};
A.prototype._createButtons=function(){this._oOKButton=new B({text:this._oTextResources.getText("BTN_FREP_OK"),press:[this._submitDialog,this],type:a.Emphasized});var C=new B({text:this._oTextResources.getText("BTN_FREP_CANCEL"),press:[this._cancelDialog,this]});return[this._oOKButton,C];};
A.prototype._submitDialog=function(){this._oDialog.close();this._fnResolve();};
A.prototype._cancelDialog=function(){this._oList.removeSelections();this._oDialog.close();this._fnReject();};
A.prototype.setElements=function(E){this._oDialog.getModel().setProperty("/elements",E);};
A.prototype.getElements=function(){return this._oDialog.getModel().getProperty("/elements");};
A.prototype.getSelectedElements=function(){return this._oDialog.getModel().getObject("/elements").filter(function(E){return E.selected;});};
A.prototype.open=function(){return new Promise(function(r,n){this._fnResolve=r;this._fnReject=n;this._oDialog.attachAfterOpen(function(){this.fireOpened();}.bind(this));this._oDialog.open();}.bind(this));};
A.prototype._resortList=function(){this._bAscendingSortOrder=!this._bAscendingSortOrder;var o=this._oList.getBinding("items");var s=[];s.push(new g("label",this._bAscendingSortOrder));o.sort(s);};
A.prototype._updateModelFilter=function(E){var v=E.getParameter("newValue");var o=this._oList.getBinding("items");if((typeof v)==="string"){var n=new F("label",c.Contains,v);var O=new F("originalLabel",c.Contains,v);var r=new F("referencedComplexPropertyName",c.Contains,v);var p=new F("duplicateComplexName",c.EQ,true);var C=new F({filters:[r,p],and:true});var q=new F({filters:[n,O,C],and:false});o.filter([q]);}else{o.filter([]);}};
A.prototype._redirectToCustomFieldCreation=function(){this.fireOpenCustomField();this._oDialog.close();};
A.prototype.setTitle=function(t){M.prototype.setProperty.call(this,"title",t,true);this._oDialog.setTitle(t);};
A.prototype.setCustomFieldEnabled=function(C){this.setProperty("customFieldEnabled",C,true);this._oCustomFieldButton.setEnabled(this.getProperty("customFieldEnabled"));};
A.prototype._setBusinessContextVisible=function(n){this.setProperty("businessContextVisible",n,true);this._oBCContainer.setVisible(this.getProperty("businessContextVisible"));};
A.prototype.getList=function(){return this._oList;};
A.prototype.addBusinessContext=function(n){this._removeBusinessContexts();var o=new j({text:this._oTextResources.getText("MSG_NO_BUSINESS_CONTEXTS")});if(n&&n.length>0){n.forEach(function(C){o=new j({text:C.BusinessContextDescription});this._oBCContainer.addContent(o);},this);}else{this._oBCContainer.addContent(o);}this._setBusinessContextVisible(true);};
A.prototype._removeBusinessContexts=function(){var n;var o=this._oBCContainer.getContent().length;for(n=0;n<o;n++){this._oBCContainer.removeContent(1);}};
return A;},true);
sap.ui.predefine('sap/ui/rta/plugin/additionalElements/AdditionalElementsAnalyzer',["sap/ui/thirdparty/jquery","sap/ui/dt/ElementUtil","sap/ui/rta/Utils","sap/base/Log","sap/ui/rta/util/BindingsExtractor"],function(q,E,R,L,B){"use strict";
function _(P,j){var u=q.extend({},P);u.entityName=j.name;var v=P["com.sap.vocabularies.Common.v1.Label"];u.fieldLabel=v&&v.String;var Q=P["com.sap.vocabularies.Common.v1.QuickInfo"];u.quickInfo=Q&&Q.String;var H=P["com.sap.vocabularies.UI.v1.Hidden"];u.hidden=H&&H.Bool==="true";if(!u.hidden){var F=P["com.sap.vocabularies.Common.v1.FieldControl"];if(F){u.hidden=F.EnumMember==="com.sap.vocabularies.Common.v1.FieldControlType/Hidden";}}return u;}
function a(P){if(P&&P.type){if(P.type.toLowerCase().indexOf("edm")!==0){return true;}}return false;}
function b(O,M,j){return O.reduce(function(u,P){var v=_(P,j);if(a(v)){var C=M.getODataComplexType(v.type);if(C){v=C.property.map(function(w){w=_(w,j);w.bindingPath=v.name+"/"+w.name;w.referencedComplexPropertyName=v.fieldLabel||v.name;return w;});}}else{v.bindingPath=P.name;}return u.concat(v);},[]);}
function c(O,j,u){return O.filter(function(P){return!P.hidden;}).filter(function(P){var F=P["com.sap.vocabularies.Common.v1.FieldControl"];var v=F&&F.Path;if(v){var w=j.getBinding(u)instanceof sap.ui.model.ListBinding;if(w){return true;}var x=j.getBindingContext().getProperty(v);return x!==0;}return true;});}
function d(j,u){if(!j){return false;}var v=j.getBindingInfo(u);var P=v&&v.path;if(!P){return false;}if(P.indexOf(">")>-1){P=P.split(">").pop();}return P.indexOf("/")===0;}
function e(j,u,v){var w;if(u){w=j.getBindingInfo(v);if(typeof w.model==="string"&&w.model!==""){w=undefined;}}else{w=j.getBindingContext();}return w;}
function f(j,u){var v=d(j,u);var w=e(j,v,u);if(w){return v?w.path:w.getPath();}}
function g(P,C){C.type="custom";if(C.id){C.itemId=P+"--"+C.id;C.key=C.itemId;}return C;}
function h(j,u){var M=j.getModel();var D={property:[],navigationProperty:[],navigationEntityNames:[]};if(M){var v=M.getMetadata().getName();if(v==="sap.ui.model.odata.ODataModel"||v==="sap.ui.model.odata.v2.ODataModel"){var w=M.getMetaModel();return w.loaded().then(function(){var x=f(j,u);if(x){var y=w.getMetaContext(x);var O=y.getObject();var z=j.getMetadata().getAggregation();if(z){var C=j.getBindingInfo(z.name);var T=C&&C.template;if(T){var P=j.getBindingPath(z.name);var F=w.getODataAssociationEnd(O,P);var G=F&&F.type;if(G){var H=w.getODataEntityType(G);O=H;}}}D.property=O.property||[];D.property=b(D.property,w,O);D.property=c(D.property,j,u);if(O.navigationProperty){D.navigationProperty=O.navigationProperty;O.navigationProperty.forEach(function(N){var G=(w.getODataAssociationEnd(O,N.name)&&w.getODataAssociationEnd(O,N.name).type);var H=w.getODataEntityType(G);if(H&&H.name){if(D.navigationEntityNames.indexOf(H.name)===-1){D.navigationEntityNames.push(H.name);}}});}}return D;});}}return Promise.resolve(D);}
function i(O){return{selected:false,label:O.fieldLabel||O.name,referencedComplexPropertyName:O.referencedComplexPropertyName?O.referencedComplexPropertyName:"",duplicateComplexName:O.duplicateComplexName?O.duplicateComplexName:false,tooltip:O.quickInfo||O.fieldLabel,originalLabel:"",type:"odata",entityType:O.entityName,name:O.name,bindingPath:O.bindingPath};}
function k(D){var j=D.element;var u=D.action;var v=D.bindingPathCollection;return{selected:false,label:j.fieldLabel||E.getLabelForElement(j,u.getLabel),tooltip:j.quickInfo||j.name||E.getLabelForElement(j,u.getLabel),referencedComplexPropertyName:j.referencedComplexPropertyName?j.referencedComplexPropertyName:"",duplicateComplexName:j.duplicateComplexName?j.duplicateComplexName:false,bindingPaths:v.bindingPaths,originalLabel:j.renamedLabel&&j.fieldLabel!==j.originalLabel?j.originalLabel:"",type:"invisible",elementId:j.getId()};}
function l(j,u,v){if(u&&u!==j){var w=R.getEntityTypeByPath(j.getModel(),f(j,v));return E.findAllSiblingsInContainer(j,u).filter(function(S){var P=f(S,v);if(P){return R.getEntityTypeByPath(S.getModel(),P)===w;}return false;});}return[j];}
function m(O){O.forEach(function(u,v,O){if(u["duplicateComplexName"]!==true){for(var j=v+1;j<O.length-1;j++){if(u.fieldLabel===O[j].fieldLabel){u["duplicateComplexName"]=true;O[j]["duplicateComplexName"]=true;}}}});return O;}
function n(I,O){return O.some(function(D){return D.fieldLabel===I.fieldLabel;});}
function o(j){return Array.isArray(j)&&j.length>0;}
function p(j,N,u,v){var w=o(j)&&j.some(function(P){var y=P.trim().replace(/^\//gi,'').split('/');if(y.length>1){return N.indexOf(y.shift())!==-1;}});var x=v.some(function(C){C=C.match(/^\/?([A-Za-z0-9_]+)/)[0];return(u.indexOf(C)>=0);});return w||x;}
function r(j,O){return O.filter(function(D){return j.indexOf(D.bindingPath)!==-1;}).pop();}
function s(I,O){I.originalLabel=O.fieldLabel||O.label;I.quickInfo=O.quickInfo||O.tooltip;I.name=O.name;if(I.fieldLabel!==I.originalLabel){I.renamedLabel=true;}if(O.referencedComplexPropertyName){I.referencedComplexPropertyName=O.referencedComplexPropertyName;}}
function t(I,O,N,j,u){var v=u.bindingPaths;var w=u.bindingContextPaths;var x;return(!o(v)||p(v,N,j,w)||((x=r(v,O))&&(s(I,x)||true)));}
var A={enhanceInvisibleElements:function(j,u){var M=j.getModel();var v=u.reveal;var w=u.addODataProperty;var C=u.custom;var D=j.getMetadata().getAggregation();var x=D?D.name:u.aggregation;return Promise.resolve().then(function(){return h(j,x);}).then(function(y){var O=y.property;var z=y.navigationProperty.map(function(N){return N.name;});var F=y.navigationEntityNames;O=m(O);var G=[];var I=v.elements||[];I.forEach(function(H){var J=H.element;var K=H.action;var N=true;var P={};J.fieldLabel=E.getLabelForElement(J,K.getLabel);if(w){if(f(j,x)===f(J,x)){P=B.collectBindingPaths(J,M);J.duplicateComplexName=n(J,O);if(O.length>0){N=t(J,O,z,F,P);}}else if(B.getBindings(J,M).length>0){N=false;}}if(C&&N){C.items.forEach(function(Q){g(j.getParent().getId(),Q);if(Q.itemId===J.getId()){s(J,Q);}});}if(N){G.push({element:J,action:K,bindingPathCollection:P});}});return G;}).then(function(y){return y.map(k);});},getUnboundODataProperties:function(j,u){var D=j.getMetadata().getAggregation();var v=D?D.name:u.action.aggregation;var M=j.getModel();return Promise.resolve().then(function(){return h(j,v);}).then(function(w){var O=w.property;var x=l(j,u.relevantContainer,v);var y=[];x.forEach(function(j){y=y.concat(B.getBindings(j,M));});var F=u.action.filter?u.action.filter:function(){return true;};O=O.filter(function(z){var H=false;if(y){H=y.some(function(C){return(q.isPlainObject(C)?C.parts[0].path:!!C.getPath&&C.getPath())===z.bindingPath;});}return!H&&F(u.relevantContainer,z);});O=m(O);return O;}).then(function(U){return U.map(i);});},getCustomAddItems:function(j,u){return new Promise(function(v){if(Array.isArray(u.items)){v(u.items.map(g.bind(null,j.getParent().getId())).filter(function(C){if(!C.id){L.error("CustomAdd item with label "+C.label+" does not contain an 'id' property","sap.ui.rta.plugin.AdditionalElementsAnalyzer#showAvailableElements");return false;}return!E.getElementInstance(C.itemId);}));}else{v();}});},getFilteredItemsList:function(j){var C=2;if(j[C]){var I=j[0].map(function(u){return u.elementId;});j[C]=j[C].filter(function(u){return!u.itemId||I.indexOf(u.itemId)===-1;});}return j.reduce(function(u,v){return u.concat(v);},[]);}};return A;});
sap.ui.predefine('sap/ui/rta/plugin/additionalElements/AdditionalElementsPlugin',["sap/ui/thirdparty/jquery","sap/ui/rta/plugin/Plugin","sap/ui/dt/ElementUtil","sap/ui/dt/OverlayRegistry","sap/ui/rta/Utils","sap/ui/fl/Utils","sap/ui/dt/Util","sap/ui/core/StashedControlSupport","sap/ui/dt/ElementDesignTimeMetadata","sap/base/Log"],function(q,P,E,O,U,F,D,S,a,L){"use strict";
function _(s,o){var p;var r=o.getRelevantContainer(!s);var R=O.getOverlay(r);if(s){p=o.getParentElementOverlay();}else{p=o;}return{relevantContainerOverlay:R,parentOverlay:p,relevantContainer:r,parent:p&&p.getElement()};}
function b(p,C){return C.sParentAggregationName;}
function c(p,s){var o=p.getElement();if(!o){return[];}var i=E.getAggregation(o,s).filter(function(C){var l=O.getOverlay(C);if(!this.hasStableId(l)){return false;}var r=p.getRelevantContainer(true);var R=O.getOverlay(r);var m=p;var n=false;do{n=!m.getElementVisibility();if(n){break;}if(m===R){break;}else{m=m.getParentElementOverlay();}}while(m);if(n){return true;}return l.getElementVisibility()===false;},this);var k=S.getStashedControls(o.getId());return i.concat(k);}
var d=true;var e=false;
function f(r,m,p,s,C){var n=[];var i;var k;if(m.addODataProperty||m.custom){var l=m.aggregation;var o=m[m.addODataProperty?"addODataProperty":"custom"].designTimeMetadata;i=o.getAggregationDescription(l,p);if(i){k=s?i.singular:i.plural;n.push(k);}}if(m.reveal){m.reveal.controlTypeNames.forEach(function(i){k=s?i.singular:i.plural;n.push(k);});}var N=n.reduce(function(u,v){if(u.indexOf(v)===-1){u.push(v);}return u;},[]);var t=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");if(N.length===1){k=N[0];}else if(C){k=C;}else{k=t.getText("MULTIPLE_CONTROL_NAME");}return t.getText(r,[k]);}
function g(){return{designTimeMetadata:new a({data:{name:{singular:function(){return sap.ui.getCore().getLibraryResourceBundle("sap.uxap").getText("SECTION_CONTROL_NAME");},plural:function(){return sap.ui.getCore().getLibraryResourceBundle("sap.uxap").getText("SECTION_CONTROL_NAME_PLURAL");}},actions:{reveal:{changeType:"unstashControl",getAggregationName:b}}}}),action:{changeType:"unstashControl",getAggregationName:b}};}
function h(m,r){var R;m.reveal.elements.some(function(i){if(i.element.getId()===r.getId()){R=i;return false;}});return R;}
var A=P.extend("sap.ui.rta.plugin.additionalElements.AdditionalElementsPlugin",{
metadata:{library:"sap.ui.rta",properties:{analyzer:"object",dialog:"object",commandFactory:"object"},associations:{},events:{}},
getContextMenuTitle:function(o,i){var p=_(o,i);var m=this._getActionsOrUndef(o,i);return f("CTX_ADD_ELEMENTS",m,p.parent,d);},
isAvailable:function(o,i){return i.every(function(k){return this._isEditableByPlugin(k,o);},this);},
isEnabled:function(o,i){if(i.length>1){return false;}var k=i[0];var p;var I;if(o){p=k.getParentElementOverlay();if(p){I=true;}else{I=false;}}else{var m=this._getActionsOrUndef(o,k);if(m.reveal&&m.reveal.elements.length===0&&!m.addODataProperty){I=false;}else{I=true;}}var C=this.getCachedElements(o);var l=C&&C.length>0;I=I&&(l||this.getDialog().getCustomFieldEnabled());return I;},
registerElementOverlay:function(o){var m=o.getElement().getModel();if(m){var M=m.getMetaModel();if(M&&M.loaded){M.loaded().then(function(){this.evaluateEditable([o],{onRegistration:true});}.bind(this));}}P.prototype.registerElementOverlay.apply(this,arguments);},
_getRevealActions:function(s,o){var p=_(s,o);var i=[p.parentOverlay];if(p.relevantContainer!==p.parent){i=E.findAllSiblingsInContainer(p.parent,p.relevantContainer).map(function(m){return O.getOverlay(m);}).filter(function(o){return o;});}var k;if(s){var l=o.getParentAggregationOverlay();k=l?[o.getParentAggregationOverlay().getAggregationName()]:[];}else{k=p.parentOverlay.getAggregationOverlays().filter(function(m){return!m.getDesignTimeMetadata().isIgnored(p.parent);}).map(function(m){return m.getAggregationName();});}return k.reduce(function(m,n){return m.then(function(r){return this._getRevealActionFromAggregations(i,r,n);}.bind(this));}.bind(this),Promise.resolve({}));},
_getRevealActionFromAggregations:function(p,i,s){var I=p.reduce(function(k,l){return l?k.concat(c.call(this,l,s)):k;}.bind(this),[]);var o={elements:[],controlTypeNames:[]};var r=I.reduce(function(k,l){return k.then(function(R){return this._invisibleToReveal(R,l);}.bind(this));}.bind(this),Promise.resolve(o));return r.then(function(R){if(R.elements.length>0){i[s]={reveal:R};}return i;});},
_invisibleToReveal:function(r,i){return Promise.resolve().then(function(){var t=i.getMetadata().getName();var o;var R;var k=false;var H=Promise.resolve();if(t==="sap.ui.core._StashedControl"){var s=g();o=s.designTimeMetadata;R=s.action;k=true;}else{var l=O.getOverlay(i);if(l){o=l.getDesignTimeMetadata();R=o&&o.getAction("reveal",i);if(R&&R.changeType){var m=i;if(R.changeOnRelevantContainer){m=l.getRelevantContainer();}H=this.hasChangeHandler(R.changeType,m).then(function(n){if(n){if(R.changeOnRelevantContainer){var p=_(true,l);k=this.hasStableId(p.relevantContainerOverlay)&&this.hasStableId(p.parentOverlay);}else{k=true;}if(!R.getAggregationName){R.getAggregationName=b;}}}.bind(this));}}}return H.then(function(){if(k){r.elements.push({element:i,designTimeMetadata:o,action:R});var n=o.getName(i);if(n){r.controlTypeNames.push(n);}}return r;});}.bind(this));},
_getAddODataPropertyActions:function(s,o){var p=_(s,o);var i=p.parentOverlay&&p.parentOverlay.getDesignTimeMetadata();var k=i&&i.getActionDataFromAggregations("addODataProperty",p.parent)||[];function l(m){return Promise.resolve().then(function(){if(m){var C=m.changeOnRelevantContainer?p.relevantContainer:p.parent;var n=O.getOverlay(C);if(m.changeType&&this.hasStableId(n)){return this.hasChangeHandler(m.changeType,C).then(function(H){if(H){return{aggregationName:m.aggregation,addODataProperty:{designTimeMetadata:i,action:m}};}});}}}.bind(this));}return k.reduce(function(m,n){return m.then(function(r){return l.call(this,n).then(function(t){if(t){r[t.aggregationName]={addODataProperty:t.addODataProperty};}return r;});}.bind(this));}.bind(this),Promise.resolve({}));},
_getCustomAddActions:function(s,o){var p=_(s,o);var i=p.parentOverlay&&p.parentOverlay.getDesignTimeMetadata();var k=i&&i.getActionDataFromAggregations("add",p.parent,undefined,"custom")||[];function l(m){return Promise.resolve().then(function(){if(m){var C=p.parent;var n=O.getOverlay(C);if(typeof m.getItems==="function"&&this.hasStableId(n)){var I=m.getItems(C);if(Array.isArray(I)){var r=[];I.forEach(function(t){if(t.changeSpecificData.changeOnRelevantContainer){C=p.relevantContainer;}if(t.changeSpecificData.changeType){r.push(this.hasChangeHandler(t.changeSpecificData.changeType,C));}}.bind(this));return Promise.all(r).then(function(H){if(I.length===H.length&&H.indexOf(false)===-1){return{aggregationName:m.aggregation,custom:{designTimeMetadata:i,action:m,items:I}};}});}}}}.bind(this));}return k.reduce(function(m,n){return m.then(function(r){return l.call(this,n).then(function(t){if(t){r[t.aggregationName]={custom:t.custom};}return r;});}.bind(this));}.bind(this),Promise.resolve({}));},
_getActions:function(s,o,i){return new Promise(function(r,k){var l=s?"asSibling":"asChild";if(!i&&o._mAddActions){return r(o._mAddActions[l]);}var R=this._getRevealActions(s,o);var m=this._getAddODataPropertyActions(s,o);var C=this._getCustomAddActions(s,o);return Promise.all([R,m,C]).then(function(n){var p=q.extend(true,n[0],n[1],n[2]);var t=Object.keys(p);if(t.length===0){p={};}else if(t.length>1){L.error("reveal or addODataProperty action defined for more than 1 aggregation, that is not yet possible");}if(t.length>0){var u=t[0];p[u].aggregation=u;p=p[u];}o._mAddActions=o._mAddActions||{asSibling:{},asChild:{}};o._mAddActions[l]=p;r(p);}).catch(function(v){k(v);});}.bind(this));},
_getActionsOrUndef:function(s,o){var i=s?"asSibling":"asChild";return o._mAddActions&&o._mAddActions[i];},
_checkIfCreateFunctionIsAvailable:function(C){return!C||(C&&C.content&&C.content.createFunction);},
showAvailableElements:function(o,i,I,C){var k=i[0];var p=_(o,k);var s=o&&k.getElement();var m;return this._getActions(o,k).then(function(l){m=l;}).then(function(){return this.getAllElements(o,i,I,C);}.bind(this)).then(function(l){this.getDialog().setElements(l);return this.getDialog().open().then(function(){return this._createCommands(p,s,m,I);}.bind(this)).catch(function(n){if(n instanceof Error){throw n;}});}.bind(this)).catch(function(l){if(l instanceof Error){throw l;}else{L.info("Service not up to date, skipping add dialog","sap.ui.rta");}});},
_setDialogTitle:function(m,p,C){var s=f("HEADER_ADDITIONAL_ELEMENTS",m,p,e,C);this.getDialog().setTitle(s);if(C){this.getDialog()._oList.setNoDataText(this.getDialog()._oTextResources.getText("MSG_NO_FIELDS",C.toLowerCase()));}},
_onOpenCustomField:function(){var u=F.getUshellContainer();var C=u.getService("CrossApplicationNavigation");var H=(C&&C.hrefForExternal({target:{semanticObject:"CustomField",action:"develop"},params:{businessContexts:this._oCurrentFieldExtInfo.BusinessContexts.map(function(B){return B.BusinessContext;}),serviceName:this._oCurrentFieldExtInfo.ServiceName,serviceVersion:this._oCurrentFieldExtInfo.ServiceVersion,entityType:this._oCurrentFieldExtInfo.EntityType}}));U.openNewWindow(H);},
_createCommands:function(p,s,m,i){var k=this.getDialog().getSelectedElements();k.sort(function(o,l){if(o.label>l.label){return-1;}if(o.label<l.label){return 1;}return 0;});if(k.length>0){return this.getCommandFactory().getCommandFor(p.parent,"composite").then(function(C){var o=Promise.resolve();k.forEach(function(l){switch(l.type){case"invisible":o=o.then(this._createCommandsForInvisibleElement.bind(this,C,l,p,s,m,i));break;case"odata":o=o.then(this._createCommandsForODataElement.bind(this,C,l,p,s,m,i));break;case"custom":o=o.then(this._createCommandsForCustomElement.bind(this,C,l,p,s,m,i));break;default:L.error("Can't create command for untreated element.type "+l.type);}},this);return o.then(function(){return C;});}.bind(this)).then(function(C){this.fireElementModified({command:C});}.bind(this)).catch(function(M){throw D.propagateError(M,"AdditionalElementsPlugin#_createCommands","Error occured during _createCommands execution","sap.ui.rta.plugin");});}return Promise.resolve();},
_createCommandsForInvisibleElement:function(C,s,p,o,m,i){return this._createRevealCommandForInvisible(s,m,p).then(function(r){C.addCommand(r);return this._createMoveCommandForInvisible(s,m,p,o,i);}.bind(this)).then(function(M){if(M){C.addCommand(M);}else{L.warning("No move action configured for "+p.parent.getMetadata().getName()+", aggregation: "+m.aggregation,"sap.ui.rta");}return C;});},
_waitForChangeHandlerSettings:function(o){if(o.changeHandlerSettings instanceof Promise){return o.changeHandlerSettings.then(function(s){o.changeHandlerSettings=s;return o.changeHandlerSettings;});}return Promise.resolve(o.changeHandlerSettings);},
_createCommandsForODataElement:function(C,s,p,o,m,i){var k=p.parentOverlay.getAggregationOverlay(m.aggregation);var l=k.getDesignTimeMetadata();return this._waitForChangeHandlerSettings(m.addODataProperty.action).then(function(n){var r=n&&n.content&&n.content.requiredLibraries;if(r){return this._createCommandForAddLibrary(p,m,r,l).then(function(t){C.addCommand(t);});}}.bind(this)).then(this._createCommandForOData.bind(this,s,m,p,o,i)).then(function(n){C.addCommand(n);return C;});},
_createCommandForOData:function(s,m,p,o,i){var k=p.parentOverlay.getAggregationOverlay(m.aggregation);var l=k.getDesignTimeMetadata();var n=m.addODataProperty.action;return this._waitForChangeHandlerSettings(n).then(function(C){var v;var r=C&&C.key&&C.key.oDataServiceVersion;var R=p.parent;if(n.changeOnRelevantContainer){R=p.relevantContainer;}var t=U.getIndex(p.parent,o,m.aggregation,l.getData().getIndex);return this._getChangeHandler(n.changeType,R).then(function(u){if(p.parentOverlay.getVariantManagement&&u&&u.revertChange){v=p.parentOverlay.getVariantManagement();}var M=F.getAppComponentForControl(p.parent).getManifest();var w=F.getODataServiceUriFromManifest(M);return this.getCommandFactory().getCommandFor(p.parent,"addODataProperty",{newControlId:U.createFieldLabelId(R,s.entityType,s.bindingPath),index:i!==undefined?i:t,bindingString:s.bindingPath,entityType:s.entityType,parentId:p.parent.getId(),oDataServiceVersion:r,oDataServiceUri:w,propertyName:s.name},l,v);}.bind(this));}.bind(this));},
_createCommandForAddLibrary:function(p,m,r,o){var C=F.getAppComponentForControl(p.relevantContainer);var M=C.getManifest();var R=M["sap.app"].id;return this.getCommandFactory().getCommandFor(p.publicParent,"addLibrary",{reference:R,parameters:{libraries:r},appComponent:C},o);},
_createRevealCommandForInvisible:function(s,m,p){var r=E.getElementInstance(s.elementId);var R=O.getOverlay(r);var i=h(m,r);var o=i.designTimeMetadata;var k=i.action;if(!R){var l=j(r,p,R);R=O.getOverlay(l);}var v;if(R){v=this.getVariantManagementReference(R);}if(k.changeOnRelevantContainer){return this.getCommandFactory().getCommandFor(r,"reveal",{revealedElementId:r.getId(),directParent:p.parent},o,v);}return this.getCommandFactory().getCommandFor(r,"reveal",{},o,v);},
_createMoveCommandForInvisible:function(s,m,p,o,i){var r=E.getElementInstance(s.elementId);var R=O.getOverlay(r);var k;if(R){k=R.getParentAggregationOverlay().getAggregationName();}else{var l=h(m,r);k=l.action.getAggregationName(p.parent,r);}var n=j(r,p,R);var t=p.parent;var u=U.getIndex(p.parent,o,k);var v=U.getIndex(n,r,k)-1;u=i!==undefined?i:E.adjustIndexForMove(n,t,v,u);if(u!==v||p.parent!==r.getParent()){var w=O.getOverlay(r)?O.getOverlay(r).getParentAggregationOverlay():p.relevantContainerOverlay;var x=w.getDesignTimeMetadata();var M=x.getAction("move",r);var V;if(M){V=this.getVariantManagementReference(O.getOverlay(r));}return this.getCommandFactory().getCommandFor(p.relevantContainer,"move",{movedElements:[{element:r,sourceIndex:v,targetIndex:u}],source:{parent:n,aggregation:k},target:{parent:t,aggregation:k}},x,V);}return Promise.resolve();},
_createCommandsForCustomElement:function(C,s,p,o,m,i){var k=p.parent;var l=p.parentOverlay.getAggregationOverlay(m.aggregation).getDesignTimeMetadata();var n=Object.assign({changeOnRelevantContainer:s.changeSpecificData.changeOnRelevantContainer,aggregationName:m.aggregation,changeType:s.changeSpecificData.changeType,addElementInfo:s.changeSpecificData.content,index:i||U.getIndex(p.parent,o,m.aggregation)},s.itemId&&{customItemId:s.itemId});var v;if(p.relevantContainerOverlay){v=this.getVariantManagementReference(p.relevantContainerOverlay);}return this.getCommandFactory().getCommandFor(k,"customAdd",n,l,v).then(function(r){if(r){C.addCommand(r);}return C;});},
_isEditable:function(o){return Promise.all([this._isEditableCheck(o,true),this._isEditableCheck(o,false)]).then(function(p){return{asSibling:p[0],asChild:p[1]};}).catch(function(v){L.error(v);});},
_isEditableCheck:function(o,i){return new Promise(function(r,k){var l=false;var p=_(i,o);if(!p.relevantContainerOverlay){return r(false);}this._getActions(i,o,true).then(function(m){return U.doIfAllControlsAreAvailable([o,p.parentOverlay],function(){if(m.addODataProperty){var n=m.addODataProperty.action;l=n&&n.aggregation===o.getParentAggregationOverlay().getAggregationName();}if(!l&&m.reveal){l=true;}if(!l&&m.custom){l=true;}return Promise.resolve(l).then(function(l){if(!l&&!i){return this.checkAggregationsOnSelf(p.parentOverlay,"addODataProperty");}return l;}.bind(this)).then(function(l){if(l){l=this.hasStableId(o)&&this.hasStableId(p.parentOverlay);}return l;}.bind(this));}.bind(this));}.bind(this)).then(function(l){r(l);}).catch(function(v){k(v);});}.bind(this));},
getAllElements:function(o,i,I,C){var k=i[0];var p=_(o,k);var m;var l=[];var n=this.getCachedElements(o);if(n){return n;}return this._getActions(o,k).then(function(r){m=r;var s=Promise.resolve([]);if(m.addODataProperty){m.addODataProperty.relevantContainer=k.getRelevantContainer(!o);s=this._waitForChangeHandlerSettings(m.addODataProperty.action).then(function(t){return this._checkIfCreateFunctionIsAvailable(t)?this.getAnalyzer().getUnboundODataProperties(p.parent,m.addODataProperty):[];}.bind(this));}l.push(m.reveal?this.getAnalyzer().enhanceInvisibleElements(p.parent,m):Promise.resolve([]),s,m.custom?this.getAnalyzer().getCustomAddItems(p.parent,m.custom,m.aggregation):Promise.resolve([]));if(m.aggregation||C){this._setDialogTitle(m,p.parent,C);}}.bind(this)).then(function(){if(m.addODataProperty){return U.isServiceUpToDate(p.parent);}}).then(function(){if(m.addODataProperty){return U.isExtensibilityEnabledInSystem(p.parent);}this.getDialog()._oCustomFieldButton.setVisible(false);}.bind(this)).then(function(r){if(m.addODataProperty){this.getDialog()._oCustomFieldButton.setVisible(r);this.getDialog().setCustomFieldEnabled(false);return U.isCustomFieldAvailable(p.parent);}}.bind(this)).then(function(r){if(r){this._oCurrentFieldExtInfo=r;this.getDialog().setCustomFieldEnabled(true);this.getDialog().addBusinessContext(this._oCurrentFieldExtInfo.BusinessContexts);this.getDialog().detachEvent('openCustomField',this._onOpenCustomField,this);this.getDialog().attachEvent('openCustomField',null,this._onOpenCustomField,this);}}.bind(this)).then(this._combineAnalyzerResults.bind(this,l)).then(function(r){this.setCachedElements(r,o);return r;}.bind(this)).catch(function(r){throw r;});},
getMenuItems:function(k){var o=true;var p="CTX_ADD_ELEMENTS_AS_SIBLING";var r=20;var I="sap-icon://add";var m=[];this.clearCachedElements();return Promise.all([this.getAllElements(true,k),this.getAllElements(false,k)]).then(function(){for(var i=0;i<2;i++){if(this.isAvailable(o,k)){var M=this.getContextMenuTitle.bind(this,o);m.push({id:p,text:M,handler:function(o,k){return this.showAvailableElements(o,k);}.bind(this,o),enabled:this.isEnabled.bind(this,o),rank:r,icon:I,group:"Add"});}o=false;p="CTX_ADD_ELEMENTS_AS_CHILD";r=30;}return m;}.bind(this));},
_combineAnalyzerResults:function(p){return Promise.all(p).then(function(i){return this.getAnalyzer().getFilteredItemsList(i);}.bind(this));},
clearCachedElements:function(){this._aCachedElements=undefined;},
setCachedElements:function(i,o){this._aCachedElements=this._aCachedElements||{};this._aCachedElements[o?"asSibling":"asChild"]=i;},
getCachedElements:function(o){if(!this._aCachedElements){return undefined;}return this._aCachedElements[o?"asSibling":"asChild"];}
});
function j(r,p,R){var o;if(R){o=R.getParentElementOverlay().getElement();}if(!o&&r.sParentId){o=sap.ui.getCore().byId(r.sParentId);}else if(!o){o=p.parent;}return o;}
return A;});
sap.ui.predefine('sap/ui/rta/service/Action',["sap/ui/dt/OverlayRegistry","sap/ui/dt/Util","sap/base/util/restricted/_castArray","sap/base/util/restricted/_pick"],function(O,D,_,a){"use strict";return function(r){function i(v,o){return typeof v==='function'?v(o):v;}function g(E){var m=r._oDesignTime.getPlugins().map(function(p){return p.getMenuItems(E);});return Promise.all(m).then(function(M){return M.reduce(function(R,M){return M?R.concat(M):R;},[]).map(function(c){return Object.assign({},c,{enabled:i(c.enabled,E),text:i(c.text,E[0])});});});}function b(c){var C=_(c);var E=C.map(function(s){var o=O.getOverlay(s);if(!o){throw new Error(D.printf('Control with id="{0}" is not under the one of root elements or ignored.',s));}return o;});return g(E).then(function(m){return m.map(function(M){return a(M,['id','icon','rank','group','enabled','text']);});});}function e(c,A){var C=_(c);var E=C.map(function(s){var o=O.getOverlay(s);if(!o){throw new Error(D.printf('Control with id="{0}" is not under the one of root elements or ignored.',s));}return o;});return g(E).then(function(d){var m=d.filter(function(m){return m.id===A;}).pop();if(!m){throw new Error('No action found by specified ID');}else{return m.handler(E,{});}});}return{exports:{get:b,execute:e}};};});
sap.ui.predefine('sap/ui/rta/service/ControllerExtension',["sap/ui/dt/Util","sap/ui/dt/OverlayRegistry","sap/ui/fl/Utils","sap/ui/fl/write/api/ChangesWriteAPI","sap/ui/fl/write/api/PersistenceWriteAPI","sap/ui/thirdparty/jquery"],function(D,O,F,C,P,q){"use strict";return function(r){function m(p){return new Promise(function(a,b){var u;q.ajax({url:u=sap.ui.require.toUrl(p)+".js",async:true,success:function(d){a(d);},error:function(x,t,e){var E=new Error("resource "+p+" could not be loaded from "+u+". Check for 'file not found' or parse errors. Reason: "+e);E.status=t;E.error=e;E.statusCode=x.status;b(e);},dataType:"text"});});}return{exports:{add:function(c,v){var f=r.getFlexSettings();if(!f.developerMode){throw D.createError("service.ControllerExtension#add","code extensions can only be created in developer mode","sap.ui.rta");}if(!c){throw D.createError("service.ControllerExtension#add","can't create controller extension without codeRef","sap.ui.rta");}if(!c.endsWith(".js")){throw D.createError("service.ControllerExtension#add","codeRef has to end with 'js'");}var V=sap.ui.getCore().byId(v);var a=F.getAppComponentForControl(V);var s=V.getControllerName&&V.getControllerName()||V.getController()&&V.getController().getMetadata().getName();var o={content:{codeRef:c},selector:{controllerName:s},changeType:"codeExt",namespace:f.namespace,developerMode:f.developerMode,scenario:f.scenario};var p=C.create({changeSpecificData:o,selector:a});P.add({change:p,selector:a});return p.getDefinition();},getTemplate:function(v){var V=O.getOverlay(v);if(!V){throw D.createError("service.ControllerExtension#getTemplate","no overlay found for the given view ID","sap.ui.rta");}var c=V.getDesignTimeMetadata().getControllerExtensionTemplate();return m(c+"-dbg").catch(function(){return m(c);});}}};};});
sap.ui.predefine('sap/ui/rta/service/Outline',["sap/ui/dt/OverlayRegistry","sap/ui/dt/ElementOverlay","sap/ui/dt/AggregationOverlay","sap/ui/dt/Util","sap/base/util/deepEqual","sap/base/util/merge","sap/base/util/restricted/_omit","sap/ui/thirdparty/jquery"],function(O,E,A,D,d,m,_,q){"use strict";return function(r,p){var o={};o._getOutline=function(i,a){var R;if(!a&&D.isInteger(i)){a=i;i=undefined;}var I=[];if(!i){I=r._oDesignTime.getRootElements().map(function(s){return O.getOverlay(s);});}else{var P=O.getOverlay(i);if(!P){throw D.createError("services.Outline#get","Cannot find element with id= "+i+". A valid or empty value for the initial element id should be provided.","sap.ui.rta");}I.push(P);}R=I.map(function(b){return this._getChildrenNodes(b,a);},this);return R;};o._getChildrenNodes=function(a,i,P){var v=D.isInteger(i);if(a.getShouldBeDestroyed()){return{};}var b=this._getNodeProperties(a,P)||{};var c=a.getChildren();if((!v||(v&&i>0))&&c.length>0&&!q.isEmptyObject(b)){i=v?i-1:i;b.elements=c.map(function(C){return this._getChildrenNodes(C,i,C.getParent());},this).filter(function(C){return!q.isEmptyObject(C);});}return b;};o._getNodeProperties=function(a,P){var b;var s;var t;var v;var i=false;var e=a.getElement();var I=e.getId();var c=e.getMetadata().getName();var f=a.getDesignTimeMetadata();var g=f.getData();var h=f.getLabel(e);var j=(g.palette&&g.palette.icons&&g.palette.icons.svg||undefined);if(a instanceof E){t="element";i=a.getEditable();b=f.getName(e);v=a.isVisible();}else{t="aggregation";s=a.getAggregationName();b=P.getAggregation(s)?P.getDesignTimeMetadata().getAggregationDescription(s,e):undefined;}var k=Object.assign({id:I,technicalName:s||c,editable:i,type:t},h!==I&&h!==undefined&&{instanceName:h},b&&b.singular&&{name:b.singular},j!==undefined&&{icon:j},typeof v==="boolean"&&{visible:v});return k;};o._removeDuplicate=function(R,a){return R.filter(function(u){return!d(a,u,Infinity);});};o._updatesHandler=function(e){var P=e.getParameters();if(this.sStatus==="initial"){this.aUpdates=[];}var R=m({},P);var s=R.id?O.getOverlay(R.id).getElement().getId():undefined;var t=R.targetId?O.getOverlay(R.targetId).getElement().getId():undefined;switch(e.getId()){case"elementOverlayCreated":if(P.elementOverlay.isRoot()){var a=P.elementOverlay.getElement().getId();R.element=o._getOutline(a)[0];R.type="new";break;}return;case"elementOverlayAdded":R.element=o._getOutline(s)[0];R.targetId=t;R.type="new";break;case"elementOverlayMoved":R.element=o._getOutline(s,0)[0];R.targetId=t;R.type="move";break;case"elementOverlayDestroyed":var b=R.elementOverlay.getParentAggregationOverlay();if((b instanceof A&&!b._bIsBeingDestroyed)||R.elementOverlay.isRoot()){R.element={};R.element.id=R.elementOverlay.getElement()?R.elementOverlay.getElement().getId():R.elementOverlay.getAssociation("element");R.type="destroy";break;}return;case"elementOverlayEditableChanged":R.element={id:s,editable:R.editable};R.type="editableChange";break;case"elementPropertyChanged":R.element=o._getOutline(s,0)[0];R.type="elementPropertyChange";break;}R=_(R,["elementOverlay","editable","target","id","elementId"]);this.aUpdates=o._removeDuplicate(this.aUpdates,R);this.aUpdates.push(R);if(this.sStatus==="initial"){setTimeout(function(){if(Array.isArray(this.aUpdates)&&this.aUpdates.length>0){this.sStatus="initial";p("update",this.aUpdates);}}.bind(o),200);}this.sStatus="processing";};o.destroy=function(){r._oDesignTime.detachEvent("elementOverlayCreated",this._updatesHandler,this);r._oDesignTime.detachEvent("elementOverlayAdded",this._updatesHandler,this);r._oDesignTime.detachEvent("elementOverlayMoved",this._updatesHandler,this);r._oDesignTime.detachEvent("elementOverlayDestroyed",this._updatesHandler,this);r._oDesignTime.detachEvent("elementPropertyChanged",this._updatesHandler,this);r._oDesignTime.detachEvent("elementOverlayEditableChanged",this._updatesHandler,this);delete this.aUpdates;delete this.sStatus;};o.aUpdates=[];o.sStatus="initial";r._oDesignTime.attachEvent("elementOverlayCreated",o._updatesHandler,o);r._oDesignTime.attachEvent("elementOverlayAdded",o._updatesHandler,o);r._oDesignTime.attachEvent("elementOverlayMoved",o._updatesHandler,o);r._oDesignTime.attachEvent("elementOverlayDestroyed",o._updatesHandler,o);r._oDesignTime.attachEvent("elementPropertyChanged",o._updatesHandler,o);r._oDesignTime.attachEvent("elementOverlayEditableChanged",o._updatesHandler,o);return{events:["update"],exports:{get:o._getOutline.bind(o)},destroy:o.destroy.bind(o)};};});
sap.ui.predefine('sap/ui/rta/service/Property',["sap/ui/dt/OverlayRegistry","sap/ui/dt/Util","sap/base/util/merge","sap/base/util/restricted/_omit"],function(O,D,m,_){"use strict";var a="[NOT SERIALIZABLE]";
function i(p,I,P){if(Object(p)!==p){return true;}if(typeof p==="function"){return false;}if(typeof p==="object"){if(Array.isArray(p)){return p.every(i);}else if(p instanceof Map){var M={};p.forEach(function(V,k){M[k]=V;});if(P){P[I]=M;}p=M;}return Object.keys(p).every(function(k){return i(p[k],k,p);});}return false;}
function v(p){return i(p)?p:a;}
return function(){var p={};p._getDesignTimeProperties=function(c){var o=O.getOverlay(c);if(!o){return D.createError("service.Property#get","A valid control id was not passed","sap.ui.rta");}var e=o.getElement();var M=e.getMetadata().getAllProperties();var d=o.getDesignTimeMetadata();var b=m({},d.getData());var f=b.properties||{};var g=b.annotations||{};var l=b.getLabel;return Promise.all([p._getConsolidatedAnnotations(g,e),p._getConsolidatedProperties(f||{},M,e),p._getResolvedFunction(l,e),p._getResolvedLinks(b.links,e)]).then(function(P){return Object.assign({},P[0]&&!jQuery.isEmptyObject(P[0])&&{annotations:P[0]},P[1]&&{properties:P[1]},P[2]&&{label:v(P[2])},b.name&&{name:d.getName(e)},!jQuery.isEmptyObject(P[3])&&{links:P[3]});});};p._getConsolidatedProperties=function(d,M,e){var f=Object.keys(M).reduce(function(F,k){F[k]={value:v(e.getProperty(k)),virtual:false,type:M[k].type,name:M[k].name,ignore:false,group:M[k].group,deprecated:M[k].deprecated,defaultValue:M[k].defaultValue,visibility:M[k].visibility};var b=p._getBindingInfo(k,e);Object.assign(F[k],b&&{binding:b});return F;},{});return p._getResolvedFunction(d,e).then(function(b){return Promise.all(Object.keys(b).map(function(k){return p._getResolvedFunction(b[k].ignore,e).then(function(I){if(typeof I!=="boolean"){throw D.createError("services.Property#get","Invalid ignore property value found in designtime for element with id "+e.getId()+" .","sap.ui.rta");}var r={};if(!f[k]){if(b[k].virtual===true){r=p._getEvaluatedVirtualProperty(b,k,e,I);}else{r[k]={value:v(_(b[k],"ignore")),virtual:false,ignore:I};}}else{r[k]={ignore:I};}return r;});}));}).then(function(F){return F.reduce(function(c,o){return m(c,o);},f);});};p._getEvaluatedVirtualProperty=function(d,P,e,I){var E={};E[P]={value:v(d[P].get(e)),virtual:true,type:d[P].type,name:d[P].name,group:d[P].group,ignore:I};var b=p._getBindingInfo(P,e);return p._getResolvedFunction(d[P].possibleValues,e).then(function(c){Object.assign(E[P],b&&{binding:b},c&&{possibleValues:v(c)},typeof d[P].nullable==="boolean"&&{nullable:d[P].nullable});return E;});};p._getConsolidatedAnnotations=function(d,e){return Promise.all(Object.keys(d).map(function(k){return p._getResolvedFunction(d[k].ignore,e).then(function(I){var f={};if(typeof I!=="boolean"&&typeof I!=="undefined"){throw D.createError("services.Property#get","Invalid ignore property value found in designtime for element with id "+e.getId()+" .","sap.ui.rta");}d[k].ignore=I;if(!I){f[k]=Object.assign({},d[k]);return p._getResolvedLinks(f[k].links,e).then(function(l){if(!jQuery.isEmptyObject(l)){f[k].links=l;}return f;});}});})).then(function(f){return f.reduce(function(c,F){return Object.assign(c,F);},{});});};p._getResolvedLinks=function(l,e){var t=[];var r=Object.assign({},l);Object.keys(r).forEach(function(L){if(Array.isArray(r[L])){r[L].forEach(function(o){t.push(D.wrapIntoPromise(function(){if(typeof o.text==="function"){return o.text(e);}})(o).then(function(s){o.text=v(s||o.text);}));});}});return Promise.all(t).then(function(){return r;});};p._getBindingInfo=function(k,e){var P=e.getBindingInfo(k);if(!P){return;}return m({},P.parts&&{parts:P.parts},P.binding&&{bindingValues:{values:P.binding.getValue()}},P.binding&&P.binding.getOriginalValue&&{bindingValues:{originalValues:P.binding.getOriginalValue()}},P.bindingString&&{bindingString:P.bindingString});};p._getResolvedFunction=function(P,e){return D.wrapIntoPromise(function(){return typeof P==="function"?(P(e)||false):(P||false);})(P,e);};return{exports:{get:p._getDesignTimeProperties.bind(p)}};};});
sap.ui.predefine('sap/ui/rta/service/Receiver',["sap/ui/core/postmessage/Bus","sap/ui/dt/Util","sap/base/util/uid"],function(P,D,u){"use strict";var C='sap.ui.rta.service.receiver';var p;return function(r){var e={};var R=function(E){var d=E.data;var m=d.body;switch(E.eventId){case"getService":var s=m.arguments[0];r.getService(s).then(function(S){var a={};var M=[];Object.keys(S).forEach(function(k){if(typeof S[k]==='function'){if(!/^(at|de)tach/.test(k)){M.push(k);}}else{a[k]=S[k];}});p.publish({target:E.source,origin:E.origin,channelId:C,eventId:"getService",data:{id:d.id,type:"response",body:{methods:M,properties:a,events:r._mServices[s].service.events}}});});break;case'callMethod':r.getService(m.service).then(function(S){S[m.method].apply(null,m.arguments).then(function(v){p.publish({target:E.source,origin:E.origin,channelId:C,eventId:'callMethod',data:{type:'response',status:'success',id:d.id,body:v}});});}).catch(function(v){var o=D.propagateError(v,"service.Receiver",D.printf("Can't execute method {0} of service {1} due unexpected error.",m.method,m.service),"sap.ui.rta");p.publish({target:E.source,origin:E.origin,channelId:C,eventId:"callMethod",data:{type:"response",status:"error",id:d.id,body:o.toString()}});});break;case'subscribe':r.getService(m.service).then(function(S){var h=function(v){p.publish({target:E.source,origin:E.origin,channelId:C,eventId:'event',data:{body:{service:m.service,event:m.event,data:v}}});};var H=u();e[H]=h;S.attachEvent(m.event,h);p.publish({target:E.source,origin:E.origin,channelId:C,eventId:'subscribe',data:{type:'response',status:'success',id:d.id,body:{id:H}}});});break;case'unsubscribe':r.getService(m.service).then(function(S){S.detachEvent(m.event,e[m.id]);delete e[m.id];p.publish({target:E.source,origin:E.origin,channelId:C,eventId:'unsubscribe',data:{type:'response',status:'success',id:d.id}});});break;}};p=P.getInstance();p.publish({channelId:C,eventId:P.event.READY});p.subscribe(C,"getService",R);p.subscribe(C,"callMethod",R);p.subscribe(C,"subscribe",R);p.subscribe(C,"unsubscribe",R);return{destroy:function(){if(p){p.unsubscribe(C,"getService",R);p.unsubscribe(C,"callMethod",R);p.unsubscribe(C,"subscribe",R);p.unsubscribe(C,"unsubscribe",R);}}};};});
sap.ui.predefine('sap/ui/rta/service/Selection',function(){"use strict";return function(r,p){var s=r._oDesignTime.getSelectionManager();function g(e){return e.map(function(E){return E.getElement().getId();});}s.attachEvent("change",function(e){p("change",g(e.getParameter("selection")));});return{events:["change"],exports:{get:function(){return g(s.get());},set:s.set.bind(s),add:s.add.bind(s),remove:s.remove.bind(s),reset:s.reset.bind(s)}};};});
sap.ui.predefine('sap/ui/rta/service/index',function(){"use strict";return Object.freeze({selection:'sap.ui.rta.service.Selection',receiver:'sap.ui.rta.service.Receiver',controllerExtension:'sap.ui.rta.service.ControllerExtension',outline:'sap.ui.rta.service.Outline',action:'sap.ui.rta.service.Action',property:'sap.ui.rta.service.Property'});});
sap.ui.predefine('sap/ui/rta/toolbar/Adaptation',["sap/m/ToolbarSpacer","sap/m/Button","sap/m/SegmentedButton","sap/m/SegmentedButtonItem","sap/m/MenuButton","sap/m/MenuItem","sap/m/Menu","sap/m/HBox","sap/m/OverflowToolbar","sap/m/OverflowToolbarLayoutData","sap/ui/Device","sap/m/FlexItemData","./Base"],function(T,B,S,a,M,b,c,H,O,d,D,F,e){"use strict";
var A=e.extend("sap.ui.rta.toolbar.Adaptation",{
renderer:"sap.ui.rta.toolbar.AdaptationRenderer",
animation:true,
metadata:{events:{undo:{},redo:{},exit:{},restore:{},transport:{},modeChange:{},manageApps:{},appVariantOverview:{},saveAs:{}},properties:{publishVisible:{type:"boolean",defaultValue:false},modeSwitcher:{type:"string",defaultValue:"adaptation"}}}
});
A.modes={MOBILE:"sapUiRtaToolbarMobile",TABLET:"sapUiRtaToolbarTablet",DESKTOP:"sapUiRtaToolbarDesktop"};var f="sapUiRtaToolbar";
A.prototype.init=function(){D.media.attachHandler(this._onSizeChanged,this,f);e.prototype.init.apply(this,arguments);};
A.prototype.onAfterRendering=function(){if(!D.media.hasRangeSet(f)){D.media.initRangeSet(f,[600,900],"px",[A.modes.MOBILE,A.modes.TABLET,A.modes.DESKTOP]);}this._onSizeChanged(D.media.getCurrentRange(f));e.prototype.onAfterRendering.apply(this,arguments);};
A.prototype.exit=function(){D.media.detachHandler(this._onSizeChanged,this,f);e.prototype.exit.apply(this,arguments);};
A.prototype._onSizeChanged=function(p){function s(C,j,t){var k=C.filter(function(l){return l.getLayoutData()&&l.getLayoutData().getPriority()===j;});k.forEach(function(l){l.getLayoutData().setPriority(t);});}var m=p.name;this.sMode=m;var o=this.getControl("exit");var h=this.getControl("overflowToolbar").getContent();var i=false;switch(m){case A.modes.MOBILE:i=false;o.setIcon("sap-icon://decline");o.setText("");s(h,"Low","AlwaysOverflow");r.call(this,i);this._setWidthOfHBoxes(false);break;case A.modes.TABLET:i=false;o.setIcon("");o.setText(this.getTextResources().getText("BTN_EXIT"));s(h,"Low","AlwaysOverflow");r.call(this,i);this._setWidthOfHBoxes(false);break;case A.modes.DESKTOP:i=true;o.setIcon("");o.setText(this.getTextResources().getText("BTN_EXIT"));s(h,"AlwaysOverflow","Low");r.call(this,i);this._setWidthOfHBoxes(true);break;default:}};
function g(C){var o=this.getItems();if(C){var w=this.getControl("modeSwitcher").$().outerWidth();var h=w&&Math.floor(w/2);if(!h){o[1].setWidth("50%");}else{o[1].setWidth("calc(50% + "+h+"px)");}}else{o[1].setWidth("100%");}}
function r(s){var m=this.getControl("manageApps");var o=this.getControl("appVariantOverview");if(s){m.setIcon("sap-icon://dimension");m.setText("");o.setIcon("sap-icon://dimension");o.setText("");}else{m.setIcon("");m.setText(this.getTextResources().getText("BTN_MANAGE_APPS_TXT"));o.setIcon("");o.setText(this.getTextResources().getText("BTN_MANAGE_APPS_TXT"));}}
A.prototype._setWidthOfHBoxes=function(C){if(C){var m=this.getControl("modeSwitcher").getDomRef();if(!m){this._oDelegate={onAfterRendering:function(){g.call(this,C);this.getControl("modeSwitcher").removeEventDelegate(this._oDelegate,this);}};this.getControl("modeSwitcher").addEventDelegate(this._oDelegate,this);g.call(this,C);}else{g.call(this,C);}}else{g.call(this,C);}};
A.prototype.getControl=function(n){return this._mControls[n];};
A.prototype.buildControls=function(){this._mControls={};return[new H({alignItems:"Center",layoutData:new F({baseSize:"0",growFactor:1,minWidth:"0"})}),new H({alignItems:"Center",items:[this._mControls["overflowToolbar"]=new O({content:[this._mControls["modeSwitcher"]=new S({width:"auto",selectedKey:this.getModeSwitcher(),items:[new a({text:this.getTextResources().getText("BTN_ADAPTATION"),tooltip:this.getTextResources().getText("BTN_ADAPTATION"),width:"auto",key:"adaptation"}),new a({text:this.getTextResources().getText("BTN_NAVIGATION"),tooltip:this.getTextResources().getText("BTN_NAVIGATION"),width:"auto",key:"navigation"})],selectionChange:this.eventHandler.bind(this,"ModeChange"),layoutData:new d({priority:"High"})}),new T(),this._mControls["undo"]=new B({type:"Transparent",icon:"sap-icon://undo",enabled:false,tooltip:this.getTextResources().getText("BTN_UNDO"),press:this.eventHandler.bind(this,"Undo"),layoutData:new d({priority:"NeverOverflow"})}),this._mControls["redo"]=new B({type:"Transparent",icon:"sap-icon://redo",iconFirst:false,enabled:false,tooltip:this.getTextResources().getText("BTN_REDO"),press:this.eventHandler.bind(this,"Redo"),layoutData:new d({priority:"NeverOverflow"})}),this._mControls["manageApps"]=new B({type:"Transparent",icon:"sap-icon://dimension",enabled:false,visible:false,tooltip:this.getTextResources().getText("BTN_MANAGE_APPS_TXT"),press:this.eventHandler.bind(this,"ManageApps"),layoutData:new d({priority:"Low"})}),this._mControls["appVariantOverview"]=new M({type:"Transparent",icon:"sap-icon://dimension",enabled:false,visible:false,tooltip:this.getTextResources().getText("BTN_MANAGE_APPS_TXT"),menu:new c({itemSelected:this.eventHandler.bind(this,"AppVariantOverview"),items:[new b("keyUser",{text:this.getTextResources().getText("MENU_ITEM_KEY_USER")}),new b("developer",{text:this.getTextResources().getText("MENU_ITEM_SAP_DEVELOPER")})]}),layoutData:new d({priority:"Low"})}),this._mControls["restore"]=new B({type:"Transparent",text:this.getTextResources().getText("BTN_RESTORE"),visible:true,enabled:false,tooltip:this.getTextResources().getText("BTN_RESTORE"),press:this.eventHandler.bind(this,"Restore"),layoutData:new d({priority:"Low"})}),this._mControls["publish"]=new B({type:"Transparent",enabled:false,visible:this.getPublishVisible(),text:this.getTextResources().getText("BTN_PUBLISH"),tooltip:this.getTextResources().getText("BTN_PUBLISH"),press:this.eventHandler.bind(this,"Transport"),layoutData:new d({priority:"Low"})}),this._mControls["saveAs"]=new B({type:"Transparent",text:this.getTextResources().getText("BTN_SAVE_AS"),enabled:false,visible:false,tooltip:this.getTextResources().getText("TOOLTIP_SAVE_AS"),press:this.eventHandler.bind(this,"SaveAs"),layoutData:new d({priority:"Low"})})],layoutData:new F({growFactor:1,minWidth:"0"})}),this._mControls["exit"]=new B({type:"Transparent",text:this.getTextResources().getText("BTN_EXIT"),tooltip:this.getTextResources().getText("BTN_EXIT"),press:this.eventHandler.bind(this,"Exit"),icon:"sap-icon://decline"})],layoutData:new F({growFactor:0})})];};
A.prototype.setUndoRedoEnabled=function(C,h){this.getControl("undo").setEnabled(C);this.getControl("redo").setEnabled(h);};
A.prototype.setPublishEnabled=function(E){this.getControl("publish").setEnabled(E);};
A.prototype.setRestoreEnabled=function(E){this.getControl("restore").setEnabled(E);};
A.prototype.show=function(){return e.prototype.show.apply(this,arguments);};
A.prototype.hide=function(){return e.prototype.hide.apply(this,arguments);};
return A;},true);
sap.ui.predefine('sap/ui/rta/toolbar/AdaptationRenderer',['./BaseRenderer'],function(B){"use strict";
var A=B.extend('sap.ui.rta.toolbar.AdaptationRenderer');
A.render=function(r,c){r.addClass('sapUiRtaToolbarAdaptation');B.render(r,c);};
return A;});
sap.ui.predefine('sap/ui/rta/toolbar/Base',["sap/m/HBox","sap/ui/rta/util/Animation","sap/ui/dt/util/ZIndexManager"],function(H,A,Z){"use strict";
var B=H.extend("sap.ui.rta.toolbar.Base",{
metadata:{library:"sap.ui.rta",properties:{color:{type:"string",defaultValue:"default"},zIndex:{type:"int"},textResources:"object"}},
constructor:function(){H.apply(this,arguments);this.setAlignItems("Center");this.setVisible(false);this.placeToContainer();this.buildContent();},
type:null,
animation:false
});
B.prototype.init=function(){H.prototype.init.apply(this,arguments);};
B.prototype.onBeforeRendering=function(){H.prototype.onBeforeRendering.apply(this,arguments);};
B.prototype.onAfterRendering=function(){H.prototype.onAfterRendering.apply(this,arguments);};
B.prototype.eventHandler=function(e,E){this['fire'+e](E.getParameters());};
B.prototype.buildControls=function(){return[];};
B.prototype.placeToContainer=function(){this.placeAt(sap.ui.getCore().getStaticAreaRef());};
B.prototype.buildContent=function(){this.buildControls().forEach(this.addItem,this);};
B.prototype.show=function(){return new Promise(function(r){var d={onAfterRendering:function(){this.removeEventDelegate(d);r();}};this.addEventDelegate(d,this);this.bringToFront();this.setVisible(true);}.bind(this)).then(function(){return this.animation?A.waitTransition(this.$(),this.addStyleClass.bind(this,'is_visible')):Promise.resolve();}.bind(this)).then(function(){this.focus();}.bind(this));};
B.prototype.hide=function(){return(this.animation?A.waitTransition(this.$(),this.removeStyleClass.bind(this,'is_visible')):Promise.resolve()).then(function(){this.setVisible(false);}.bind(this));};
B.prototype.getControl=function(n){return this.getAggregation('items').filter(function(c){return c.data('name')===n;}).pop();};
B.prototype.bringToFront=function(){this.setZIndex(Z.getNextZIndex());};
B.prototype.setUndoRedoEnabled=function(){};
B.prototype.setPublishEnabled=function(){};
B.prototype.setRestoreEnabled=function(){};
return B;},true);
sap.ui.predefine('sap/ui/rta/toolbar/BaseRenderer',["sap/ui/core/Renderer","sap/m/HBoxRenderer"],function(R,H){"use strict";var B=R.extend.call(H,'sap.ui.rta.toolbar.BaseRenderer');
B.render=function(r,c){r.addClass('sapUiRtaToolbar');r.addClass("color_"+c.getColor());c.type&&r.addClass("type_"+c.type);var z=c.getZIndex();z&&r.addStyle("z-index",z);H.render(r,c);};
return B;});
sap.ui.predefine('sap/ui/rta/toolbar/Fiori',["sap/m/Image","./Adaptation","../Utils","sap/base/Log"],function(I,A,U,L){"use strict";var F='sapUiRtaFioriHeaderInvisible';
var a=A.extend("sap.ui.rta.toolbar.Fiori",{
renderer:'sap.ui.rta.toolbar.AdaptationRenderer',
type:'fiori'
});
a.prototype.init=function(){A.prototype.init.apply(this,arguments);this._oRenderer=U.getFiori2Renderer();this._oFioriHeader=this._oRenderer.getRootControl().getOUnifiedShell().getHeader();};
a.prototype.show=function(){this._oFioriHeader.addStyleClass(F);return A.prototype.show.apply(this,arguments);};
a.prototype.buildControls=function(){var c=A.prototype.buildControls.apply(this,arguments);var l=this._oFioriHeader.getLogo();if(this._oFioriHeader.getShowLogo()&&l){var $=this._oFioriHeader.$().find('#shell-header-icon');var w;var h;if($.length){w=$.width();h=$.height();this._checkLogoSize($,w,h);}c[0].addItem(this._mControls["logo"]=new I({src:l,width:w?w+'px':w,height:h?h+'px':h}));}return c;};
a.prototype.hide=function(){return A.prototype.hide.apply(this,arguments).then(function(){this._oFioriHeader.removeStyleClass(F);}.bind(this));};
a.prototype._checkLogoSize=function($,w,h){var n=$.get(0).naturalWidth;var N=$.get(0).naturalHeight;if(w!==n||h!==N){L.error(["sap.ui.rta: please check Fiori Launchpad logo, expected size is",w+"x"+h+",","but actual is "+n+"x"+N].join(' '));}};
a.prototype.destroy=function(){this._oFioriHeader.removeStyleClass(F);delete this._oRenderer;delete this._oFioriHeader;A.prototype.destroy.apply(this,arguments);};
return a;},true);
sap.ui.predefine('sap/ui/rta/toolbar/Personalization',["./Base","sap/m/Button"],function(B,a){"use strict";
var P=B.extend("sap.ui.rta.toolbar.Personalization",{
renderer:'sap.ui.rta.toolbar.BaseRenderer',
type:'personalization',
metadata:{events:{exit:{},restore:{}}},
constructor:function(){B.apply(this,arguments);this.setJustifyContent("End");}
});
P.prototype.buildControls=function(){var c=[new a({type:"Transparent",text:this.getTextResources().getText("BTN_RESTORE"),tooltip:this.getTextResources().getText("BTN_RESTORE"),visible:true,press:this.eventHandler.bind(this,'Restore')}).data('name','restore'),new a({type:"Emphasized",text:this.getTextResources().getText("BTN_DONE"),tooltip:this.getTextResources().getText("BTN_DONE_TOOLTIP"),press:this.eventHandler.bind(this,'Exit')}).data('name','exit')];return c;};
P.prototype.setUndoRedoEnabled=function(){};
P.prototype.setPublishEnabled=function(){};
P.prototype.setRestoreEnabled=function(e){this.getControl('restore').setEnabled(e);};
return P;},true);
sap.ui.predefine('sap/ui/rta/toolbar/Standalone',["./Adaptation"],function(A){"use strict";
var S=A.extend("sap.ui.rta.toolbar.Standalone",{
renderer:'sap.ui.rta.toolbar.AdaptationRenderer',
type:'standalone'
});
return S;},true);
sap.ui.predefine('sap/ui/rta/util/Animation',["sap/ui/thirdparty/jquery"],function(q){"use strict";var m={};
m.waitTransition=function($,c){if(!($ instanceof q)){throw new Error('$element should be wrapped into jQuery object');}if(!q.isFunction(c)){throw new Error('fnCallback should be a function');}return new Promise(function(r){$.one('transitionend',r);var t;var a=function(T){if(!t){t=T;}if(T!==t){c();}else{window.requestAnimationFrame(a);}};window.requestAnimationFrame(a);});};
return m;},true);
sap.ui.predefine('sap/ui/rta/util/BindingsExtractor',["sap/ui/dt/ElementUtil","sap/base/util/isPlainObject","sap/ui/thirdparty/jquery"],function(E,a,q){"use strict";
function c(o,m){var B={bindingPaths:[],bindingContextPaths:[]};var A=o.sParentAggregationName;var p=o.getParent();var k=g(o,m);if(p){var D=p.getMetadata().getAggregation();if(D){var P=E.getAggregation(p,A).indexOf(o);var s=D.name;var n=p.getBindingInfo(s);var t=n&&n.template;if(t){var T=t.getMetadata().getAggregation();if(T){var r=T.name;var u=E.getAggregation(t,r)[P];k=k.concat(g(u,null,true));}}}}for(var i=0,l=k.length;i<l;i++){if(k[i].getPath){var v=k[i].getPath();if(v&&B.bindingPaths.indexOf(v)===-1){B.bindingPaths.push(v);}}if(k[i].getContext&&k[i].getContext()&&k[i].getContext().getPath){var w=k[i].getContext().getPath();if(w&&B.bindingContextPaths.indexOf(w)===-1){B.bindingContextPaths.push(w);}}if(a(k[i])){if(B.bindingPaths.indexOf(k[i].parts[0].path)===-1){B.bindingPaths.push(k[i].parts[0].path);}}}return B;}
function g(o,p,t,A){var B=(t?h(o):e(o,p));var i=A?[A]:Object.keys(o.getMetadata().getAllAggregations());i.forEach(function(s){B=B.concat(b(o,p,t,s));});return B;}
function b(o,p,t,A){var B=[];var i=o.getBindingInfo(A);var T=i&&i.template;var k=T?[T]:E.getAggregation(o,A);k.forEach(function(C){if(C.getMetadata){B=B.concat(T||t?h(C):e(C,p),g(C,p,T||t));}});return B;}
function f(B,p){var i=[];var m=B.getMetadata().getName();if(m==="sap.ui.model.CompositeBinding"){B.getBindings().forEach(function(B){i=i.concat(f(B,p));});}else if((m==="sap.ui.model.odata.ODataPropertyBinding"||m==="sap.ui.model.odata.v2.ODataPropertyBinding"||m==="sap.ui.model.odata.v4.ODataPropertyBinding"||m==="sap.ui.model.json.JSONPropertyBinding"||m==="sap.ui.model.json.XMLPropertyBinding"||m==="sap.ui.model.resource.ResourcePropertyBinding")&&B.getModel()===p&&B.isRelative()&&q.isFunction(B.getPath)&&B.getPath()){i.push(B);}return i;}
function d(B){var i=[];var p=B.parts;p.forEach(function(P){i.push({parts:[P]});});return i;}
function e(o,p){var P=Object.keys(o.getMetadata().getAllProperties());return P.filter(o.getBinding.bind(o)).reduce(function(B,s){return B.concat(f(o.getBinding(s),p));},[]);}
function h(o){var p=Object.keys(o.getMetadata().getAllProperties());return p.filter(function(P){return P in o.mBindingInfos;}).reduce(function(B,P){return B.concat(d(o.mBindingInfos[P]));},[]);}
function j(o){if(o.getBindingContext()&&o.getBindingContext().getPath){return o.getBindingContext().getPath();}return undefined;}
return{getBindings:g,collectBindingPaths:c,flattenBindings:f,getBindingsFromProperties:e,getBindingContextPath:j};},true);
sap.ui.predefine('sap/ui/rta/util/PopupManager',["sap/ui/thirdparty/jquery","sap/ui/base/ManagedObject","sap/m/InstanceManager","sap/ui/dt/Overlay","sap/ui/fl/Utils","sap/ui/core/Component","sap/ui/core/ComponentContainer","sap/ui/core/Element","sap/ui/dt/util/ZIndexManager","sap/m/Dialog","sap/m/Popover","sap/base/util/restricted/_curry"],function(q,M,I,O,f,C,a,E,Z,D,P,_){"use strict";var F={add:"_activateFocusHandle",remove:"_deactivateFocusHandle"};
var b=M.extend("sap.ui.rta.util.PopupManager",{metadata:{properties:{rta:"any"},associations:{autoCloseAreas:{type:"sap.ui.core.Control",multiple:true,singularName:"autoCloseArea"}},events:{open:{parameters:{oControl:{type:"sap.ui.core.Control"}}},close:{parameters:{oControl:{type:"sap.ui.core.Control"}}}},library:"sap.ui.rta"}});
b.prototype.init=function(){this._oModalState=new Map();this._aPopupFilters=[this._isSupportedPopup.bind(this),this._isPopupAdaptable.bind(this)];this._aPopupFilters.forEach(function(c){Z.addPopupFilter(c);});};
b.prototype._overrideInstanceFunctions=function(){this._applyPopupAttributes({method:this._createPopupOverlays,setModal:true,bringToTop:true});this._overrideAddPopupInstance();this._overrideRemovePopupInstance();};
b.prototype.getCategorizedOpenPopups=function(){var o;var c;o=I.getOpenDialogs();var d=this._getValidatedPopups(o);c=I.getOpenPopovers();var e=this._getValidatedPopups(c);var g={aDialogs:d.relevant,aPopovers:e.relevant,aAllSupportedPopups:d.allSupported.concat(e.allSupported)};return g;};
b.prototype._getValidatedPopups=function(o){var A=[];o=o.filter(function(p){if(this._isPopupAdaptable(p)){A.push(p);return true;}else if(p instanceof D){A.push(p);}}.bind(this));return{relevant:o,allSupported:A};};
b.prototype._isComponentInsidePopup=function(p){return q.isArray(p.getContent())?p.getContent().some(function(c){if(c instanceof a){return this.oRtaRootAppComponent===this._getAppComponentForControl(C.get(c.getComponent()));}}.bind(this)):false;};
b.prototype._isSupportedPopup=function(p){return(p instanceof D||p instanceof P);};
b.prototype.setRta=function(r){if(r&&r._oDesignTime){this.setProperty("rta",r);var R=r.getRootControlInstance();this.oRtaRootAppComponent=this._getAppComponentForControl(R);var m=this._onModeChange.bind(this);r.attachModeChanged(m);this._overrideInstanceFunctions();}};
b.prototype._onModeChange=function(e){var n=e.getParameters().mode;var A=function(m,p){if(m==='navigation'){p.oPopup[this._getFocusEventName("add")]();}else{p.oPopup[this._getFocusEventName("remove")]();if(this.getRta().getShowToolbars()){this.getRta().getToolbar().bringToFront();}}};n==='navigation'?this._applyPatchesToOpenPopups(_(A)(n)):this._removePatchesToOpenPopups(_(A)(n));};
b.prototype._applyPatchesToOpenPopups=function(e){this._applyPopupAttributes({method:e,focus:true,setModal:false});};
b.prototype._removePatchesToOpenPopups=function(e){this._applyPopupAttributes({method:e,setModal:true});};
b.prototype._getFocusEventName=function(o){return F[o];};
b.prototype._overrideAddPopupInstance=function(){this._fnOriginalAddDialogInstance=I.addDialogInstance;I.addDialogInstance=this._overrideAddFunctions(this._fnOriginalAddDialogInstance);this._fnOriginalAddPopoverInstance=I.addPopoverInstance;I.addPopoverInstance=this._overrideAddFunctions(this._fnOriginalAddPopoverInstance);};
b.prototype._overrideAddFunctions=function(o){return function(p){var v=o.apply(I,arguments);if(this._isSupportedPopup(p)){if(this._isPopupAdaptable(p)&&this.getRta()._oDesignTime){p.attachAfterOpen(this._createPopupOverlays,this);this._setModal(true,p);this.fireOpen(p);}else if(!(p instanceof P)){this._setModal(true,p);}}return v;}.bind(this);};
b.prototype._setModal=function(s,p){var o=this._oModalState.get(p.oPopup);if(typeof o!=="boolean"&&s&&this.getRta().getMode()==='adaptation'){this._oModalState.set(p.oPopup,p.oPopup.getModal());p.oPopup.setModal(true);}else if(typeof o==="boolean"&&s===false){p.oPopup.setModal(o);this._oModalState.delete(p.oPopup);}};
b.prototype._applyPopupAttributes=function(p){var r=this.getCategorizedOpenPopups();["aDialogs","aPopovers"].forEach(function(k){if(r[k].length>0){if(p.focus){if(r[k][0].oPopup.oContent){r[k][0].oPopup.oContent.focus();}}r[k].forEach(function(o){p.method.call(this,o);}.bind(this));}}.bind(this));r.aAllSupportedPopups.forEach(this._setModal.bind(this,p.setModal));};
b.prototype._applyPopupPatch=function(p){var o=O.getOverlayContainer();var c=p.oPopup;var A=[c.oContent.getDomRef(),o.get(0)].concat(this.getAutoCloseAreas());if(this.getRta().getShowToolbars()){var r=this.getRta().getToolbar();var v=!!r.getVisible();if(!v){this.getRta().attachEventOnce("start",function(){A.push(r.getDomRef());});}else{A.push(r.getDomRef());}}c.setAutoCloseAreas(A);if(!this.fnOriginalPopupOnAfterRendering){this.fnOriginalPopupOnAfterRendering=c.onAfterRendering;}c.onAfterRendering=function(){var d=this.fnOriginalPopupOnAfterRendering.apply(c,arguments);c[this._getFocusEventName("remove")]();return d;}.bind(this);if(this.getRta().getMode()==='adaptation'){c[this._getFocusEventName("remove")]();}};
b.prototype._overrideRemovePopupInstance=function(){this._fnOriginalRemoveDialogInstance=I.removeDialogInstance;I.removeDialogInstance=this._overrideRemoveFunctions(this._fnOriginalRemoveDialogInstance);this._fnOriginalRemovePopoverInstance=I.removePopoverInstance;I.removePopoverInstance=this._overrideRemoveFunctions(this._fnOriginalRemovePopoverInstance);};
b.prototype._overrideRemoveFunctions=function(o){return function(p){var v=o.apply(I,arguments);if(this._isSupportedPopup(p)){if(this._isPopupAdaptable(p,false)&&this.getRta()._oDesignTime){this.getRta()._oDesignTime.removeRootElement(p);}this._oModalState.delete(p.oPopup);this.fireClose(p);}return v;}.bind(this);};
b.prototype._getAppComponentForControl=function(c){var o;var A;if(c instanceof C){o=c;}else{o=this._getComponentForControl(c);}if(o){A=f.getAppComponentForControl(o);}return A;};
b.prototype._getComponentForControl=function(c){var o;var r;var p;if(c){o=C.getOwnerComponentFor(c);if(!o&&typeof c.getParent==="function"&&c.getParent()instanceof E){p=c.getParent();}else if(o){p=o;}if(p){r=this._getComponentForControl(p);}}return r||o;};
b.prototype._createPopupOverlays=function(e){if(!e){return;}var p=(e instanceof E)?e:e.getSource();if(this.getRta()._oDesignTime.getRootElements().indexOf(p.getId())===-1&&!this._isComponentInsidePopup(p)){this.getRta()._oDesignTime.addRootElement(p);}p.detachAfterOpen(this._createPopupOverlays,this);this._applyPopupPatch(p);};
b.prototype._restoreInstanceFunctions=function(){if(this._fnOriginalAddDialogInstance){I.addDialogInstance=this._fnOriginalAddDialogInstance;}if(this._fnOriginalRemoveDialogInstance){I.removeDialogInstance=this._fnOriginalRemoveDialogInstance;}if(this._fnOriginalAddPopoverInstance){I.addPopoverInstance=this._fnOriginalAddPopoverInstance;}if(this._fnOriginalRemovePopoverInstance){I.removePopoverInstance=this._fnOriginalRemovePopoverInstance;}this._applyPatchesToOpenPopups(this._removePopupPatch);};
b.prototype._removePopupPatch=function(p){var o=p.oPopup;o[this._getFocusEventName("add")]();if(this.fnOriginalPopupOnAfterRendering){o.onAfterRendering=this.fnOriginalPopupOnAfterRendering;}};
b.prototype._isPopupAdaptable=function(p){if(p.isPopupAdaptationAllowed&&!p.isPopupAdaptationAllowed()){return false;}var o=this._getAppComponentForControl(p);return this.oRtaRootAppComponent===o||this._isComponentInsidePopup(p);};
b.prototype.exit=function(){this._restoreInstanceFunctions();delete this._oModalState;this._aPopupFilters.forEach(function(c){Z.removePopupFilter(c);});};
return b;},true);
sap.ui.predefine('sap/ui/rta/util/ServiceEventBus',["sap/ui/core/EventBus"],function(E){"use strict";
var S=E.extend("sap.ui.rta.util.ServiceEventBus");
S.prototype._callListener=function(c,l,C,e,d){c.call(l,d);};
S.prototype.getChannel=function(c){return this._mChannels[c];};
return S;});
sap.ui.predefine('sap/ui/rta/util/StylesLoader',["sap/ui/thirdparty/jquery"],function(q){"use strict";var m={};
m.loadStyles=function(f){return q.get(sap.ui.require.toUrl(('sap.ui.rta.assets.'+f).replace(/\./g,"/"))+'.css').then(function(d){if(sap.ui.getCore().getConfiguration().getRTL()){return d.replace(/right/g,'left');}return d;});};
return m;},true);
sap.ui.predefine('sap/ui/rta/util/UrlParser',[],function(){"use strict";var m={};
m.getParam=function(p){return m.getParams()[p];};
m.getParams=function(){return document.location.search.replace(/^\?/,'').split('&').reduce(function(p,P){var a=P.split('=');var v=a[1];switch(v){case'true':v=true;break;case'false':v=false;break;}p[a[0]]=v;return p;},{});};
return m;},true);
sap.ui.predefine('sap/ui/rta/util/hasStableId',["sap/ui/fl/Utils","sap/ui/dt/ElementUtil","sap/base/util/isPlainObject"],function(F,E,i){"use strict";
function a(c){var p=c.sParentAggregationName;var P=c.getParent();if(P&&p){var b=P.getBindingInfo(p);if(b){if(b.template&&c instanceof b.template.getMetadata().getClass()){return b.template;}return false;}return a(P);}return false;}
return function hasStableId(e){if(!e||e._bIsBeingDestroyed){return false;}if(typeof e.data("hasStableId")!=="boolean"){var s=e.getDesignTimeMetadata().getStableElements(e);var u=false;if(s.length>0){if(a(e.getElement())){u=s.some(function(S){var c;var A;var u=false;if(i(S)){c=S.id;A=S.appComponent;}else{c=S;}u=!F.checkControlId(c,A);if(u){var C=E.getElementInstance(c);if(E.getElementInstance(c)){var l=E.getAggregationInformation(C);u=!F.checkControlId(E.extractTemplateId(l),A);}}return u;});}else{u=s.some(function(S){var c=S.id||S;return!F.checkControlId(c,S.appComponent);});}}e.data("hasStableId",!u);}return e.data("hasStableId");};});
sap.ui.predefine('sap/ui/rta/util/showMessageBox',["sap/m/MessageBox","sap/ui/layout/HorizontalLayout","sap/m/Link","sap/m/Text"],function(M,H,L,T){"use strict";var l="\\[(.*?)\\]\\((.*?)\\)";
function h(m){var r=g(m);return Array.isArray(r)&&r.length>0;}
function a(t){var r=new RegExp("^"+l+"$");return Array.isArray(r.exec(t));}
function e(s){var m=new RegExp(l).exec(s);return{text:m[1],href:m[2]};}
function g(m){var r=new RegExp(l,"g");return m.match(r);}
function c(s){var o=new H({allowWrapping:true,content:s.map(function(S){if(a(S)){var m=e(S);return new L({text:m.text,href:m.href,target:"_blank",emphasized:true,wrapping:true});}return new T({text:S,renderWhitespace:true});})});o.addStyleClass("sapUiRtaMessageBox");return o;}
function b(m){var s=[m];var d=g(m);d.forEach(function(f){var i=0;while(i<s.length){var S=s[i];if(a(S)){i++;}else{var p=S.split(f);var I=[];p.forEach(function(P,j,o){I.push(P);if(j!==o.length-1){I.push(f);}});s.splice.apply(s,[i,1].concat(I));i+=I.length;}}});return s;}
return function showMessageBox(m,o){var v;if(h(m)){var s=b(m);v=c(s);}else{v=m;}M.show(v,o);};});
sap.ui.predefine('sap/ui/rta/util/validateFlexEnabled',["sap/ui/fl/Utils","sap/m/MessageBox","sap/base/util/ObjectPath","sap/ui/rta/util/validateStableIds","sap/ui/rta/util/showMessageBox","sap/base/Log","sap/ui/rta/Utils"],function(F,M,O,v,s,L,U){"use strict";
function i(c){var m=c.getManifest();return(O.get(["sap.app","id"],m)!=="sap.ui.documentation.sdk"&&!O.get(["sap.ovp"],m));}
return function(r){if("QUnit"in window||(window.frameElement&&window.frameElement.getAttribute("id")==="OpaFrame")){return;}var c=F.getAppComponentForControl(r.getRootControlInstance());if(c&&i(c)){var m=c.getManifest();var f=O.get(["sap.ui5","flexEnabled"],m);if(typeof f!=="boolean"){s(r._getTextResources().getText("MSG_NO_FLEX_ENABLED_FLAG"),{icon:M.Icon.WARNING,title:r._getTextResources().getText("HEADER_WARNING"),styleClass:U.getRtaStyleClassName()});}else{var u=v(r._oDesignTime.getElementOverlays(),c);if(u.length){u.forEach(function(e){L.error("Control ID was generated dynamically by SAPUI5. To support SAPUI5 flexibility, a stable control ID is needed to assign the changes to.",e.getElement().getId());});s(r._getTextResources().getText("MSG_UNSTABLE_ID_FOUND"),{icon:M.Icon.ERROR,title:r._getTextResources().getText("HEADER_ERROR"),styleClass:U.getRtaStyleClassName()});}}}};});
sap.ui.predefine('sap/ui/rta/util/validateStableIds',["sap/base/util/ObjectPath","sap/ui/rta/util/hasStableId","sap/ui/core/mvc/View","sap/ui/core/Fragment","sap/ui/dt/OverlayUtil","sap/base/util/isPlainObject"],function(O,h,V,F,a,b){"use strict";
function c(C){var m=C.getManifest();return O.get(["sap.ui.generic.app"],m);}
function g(C){var m=C.getManifest();var v=O.get(["sap.ui5","extends","extensions","sap.ui.viewExtensions"],m);var e=[];if(b(v)){Object.keys(v).forEach(function(s){if(s.startsWith("sap.suite.ui.generic.template")){var f=v[s];Object.keys(f).forEach(function(i){e.push(f[i]);});}});}return e;}
function d(e,E){var f=[];for(var i=0,l=E.length;i<l;i++){var o=E[i];var j=o.getElement();var I=e.some(function(v){var C=O.get(v.className);var s;var k;if(j instanceof V){k=j.getViewName();s=v.viewName;}else if(j instanceof F){k=j.getFragmentName();}else{return false;}return(j instanceof C&&k===s);});if(I){f.push(o);if(f.length===e.length){break;}}}var r=[];f.forEach(function(o){a.iterateOverlayElementTree(o,function(o){r.push(o);});});return r;}
return function(e,C){var r=[];var R=e.slice(0);if(c(C)){var E=g(C);R=(E.length?d(E,R):[]);}r=R.filter(function(o){return(!o.getDesignTimeMetadata().markedAsNotAdaptable()&&!h(o));});return r;};});
sap.ui.require.preload({
	"sap/ui/rta/appVariant/manageApps/webapp/manifest.json":'{"_version":"1.12.0","sap.app":{"id":"sap.ui.rta.appVariant.manageApps","type":"application","i18n":"i18n/i18n.properties","applicationVersion":{"version":"1.0.0"},"title":"{{appTitle}}","description":"{{appDescription}}","resources":"resources.json","ach":"ach","sourceTemplate":{"id":"ui5template.basicSAPUI5ApplicationProject","version":"1.40.12"}},"sap.ui":{"technology":"UI5","icons":{"icon":"","favIcon":"","phone":"","phone@2":"","tablet":"","tablet@2":""},"deviceTypes":{"desktop":true,"tablet":true,"phone":true}},"sap.ui5":{"rootView":{"viewName":"sap.ui.rta.appVariant.manageApps.webapp.view.ManageApps","type":"XML","async":true},"dependencies":{"minUI5Version":"1.30.0","libs":{"sap.ui.core":{},"sap.m":{},"sap.ui.layout":{},"sap.ui.rta":{}}},"contentDensities":{"compact":true,"cozy":true},"models":{"i18n":{"type":"sap.ui.model.resource.ResourceModel","settings":{"bundleName":"sap.ui.rta.appVariant.manageApps.webapp.i18n.i18n"}}},"resources":{"css":[{"uri":"css/style.css"}]}}}',
	"sap/ui/rta/appVariant/manageApps/webapp/view/ManageApps.view.xml":'<mvc:View controllerName="sap.ui.rta.appVariant.manageApps.webapp.controller.ManageApps" xmlns:mvc="sap.ui.core.mvc" xmlns:core="sap.ui.core" xmlns="sap.m"><Table id="Table1" showNoData="false" inset="false" growing="true" growingThreshold="500" sticky="ColumnHeaders" items="{/appVariants}"><columns><Column width="8rem" hAlign="Left"><Text text="{i18n&gt;MAA_DIALOG_APP_TYPE}"/></Column><Column width="4rem" minScreenWidth="tablet" demandPopin="true" popinDisplay="Inline" hAlign="Left"><core:InvisibleText text="{i18n&gt;MAA_DIALOG_ICON}"/></Column><Column minScreenWidth="tablet" demandPopin="true" popinDisplay="Inline" hAlign="Left"><Text text="{i18n&gt;MAA_DIALOG_TITLE}"/></Column><Column minScreenWidth="tablet" demandPopin="true" popinDisplay="Inline" hAlign="Left"><Text text="{i18n&gt;MAA_DIALOG_DESCRIPTION}"/></Column><Column width="8rem" minScreenWidth="Desktop" demandPopin="true" popinDisplay="Inline" hAlign="End"><core:InvisibleText text="{i18n&gt;MAA_DIALOG_ACTIONS}"/></Column></columns><items><ColumnListItem highlight="{path:\'currentStatus\',formatter:\'.formatRowHighlight\'}"><cells><ObjectIdentifier title="{typeOfApp}" text="{currentStatus}"/><core:Icon src="{icon}" tooltip="{iconText}" class="sapUiListTableIconSize"/><ObjectIdentifier title="{title}" text="{subTitle}"/><Text text="{description}"/><MenuButton text="{i18n&gt;MAA_DIALOG_ACTIONS}"><menu><Menu itemSelected="onMenuAction"><items><MenuItem text="{i18n&gt;MAA_DIALOG_ADAPT_UI}" enabled="{adaptUIButtonEnabled}" icon="sap-icon://wrench" visible="{isKeyUser}"/><MenuItem text="{i18n&gt;MAA_DIALOG_COPY_ID}" tooltip="{i18n&gt;TOOLTIP_MAA_DIALOG_COPY_ID}" icon="sap-icon://copy"/><MenuItem text="{i18n&gt;MAA_DIALOG_DELETE_APPVAR}" enabled="{delAppVarButtonEnabled}" visible="{delAppVarButtonVisibility}" tooltip="{parts:[{path:\'delAppVarButtonEnabled\'},{path:\'isS4HanaCloud\'}],formatter:\'.formatDelButtonTooltip\'}" icon="sap-icon://delete"/><MenuItem text="{i18n&gt;MAA_DIALOG_SAVE_AS_APP}" enabled="{saveAsButtonEnabled}" tooltip="{i18n&gt;TOOLTIP_MAA_DIALOG_SAVE_AS_APP}" icon="sap-icon://save" visible="{isKeyUser}"/></items></Menu></menu></MenuButton></cells></ColumnListItem></items></Table></mvc:View>',
	"sap/ui/rta/manifest.json":'{"_version":"1.9.0","sap.app":{"id":"sap.ui.rta","type":"library","embeds":["appVariant/manageApps/webapp"],"applicationVersion":{"version":"1.71.16"},"title":"SAPUI5 library with RTA controls.","description":"SAPUI5 library with RTA controls.","ach":"CA-UI5-FL-RTA","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.71","libs":{"sap.ui.core":{"minVersion":"1.71.16"},"sap.ui.layout":{"minVersion":"1.71.16"},"sap.m":{"minVersion":"1.71.16"},"sap.ui.fl":{"minVersion":"1.71.16"},"sap.ui.dt":{"minVersion":"1.71.16"}}},"library":{"i18n":"messagebundle.properties","content":{"controls":[],"elements":[],"types":[],"interfaces":[]}}}}',
	"sap/ui/rta/view/RemoveElementDialog.fragment.xml":'<core:FragmentDefinition xmlns:core="sap.ui.core" xmlns:commons="sap.ui.commons" xmlns:layout="sap.ui.layout" xmlns:sap.m="sap.m"><sap.m:Dialog class="sapUiRtaConfirmationDialog" verticalScrolling="false" title="{/titleText}" icon="{/icon}"><layout:VerticalLayout width="100%"><commons:TextView class="sapUiRtaConfirmationDialogText" text="{/messageText}"/></layout:VerticalLayout><sap.m:beginButton><sap.m:Button class="sapUiRtaConfirmationDialogRemoveButton" text="{/removeText}" press="removeField"/></sap.m:beginButton><sap.m:endButton><sap.m:Button class="sapUiRtaConfirmationDialogCancelButton" text="{/cancelText}" press="closeDialog"/></sap.m:endButton></sap.m:Dialog></core:FragmentDefinition>',
	"sap/ui/rta/appVariant/manageApps/webapp/index.js":function(){sap.ui.require(["sap/m/Shell","sap/ui/core/ComponentContainer"],function(S,C){"use strict";sap.ui.getCore().attachInit(function(){new S({app:new C({height:"100%",name:"sap.ui.rta.appVariant.manageApps",settings:{id:"sap.ui.rta.appVariant.manageApps"}})}).placeAt("content");});});
}
},"sap/ui/rta/library-preload"
);
//# sourceMappingURL=library-preload.js.map