/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/m/ToolbarSpacer","sap/m/Button","sap/m/SegmentedButton","sap/m/SegmentedButtonItem","sap/m/MenuButton","sap/m/MenuItem","sap/m/Menu","sap/m/HBox","sap/m/OverflowToolbar","sap/m/OverflowToolbarLayoutData","sap/ui/Device","sap/m/FlexItemData","./Base"],function(T,B,S,a,M,b,c,H,O,d,D,F,e){"use strict";var A=e.extend("sap.ui.rta.toolbar.Adaptation",{renderer:"sap.ui.rta.toolbar.AdaptationRenderer",animation:true,metadata:{events:{undo:{},redo:{},exit:{},restore:{},transport:{},modeChange:{},manageApps:{},appVariantOverview:{},saveAs:{}},properties:{publishVisible:{type:"boolean",defaultValue:false},modeSwitcher:{type:"string",defaultValue:"adaptation"}}}});A.modes={MOBILE:"sapUiRtaToolbarMobile",TABLET:"sapUiRtaToolbarTablet",DESKTOP:"sapUiRtaToolbarDesktop"};var f="sapUiRtaToolbar";A.prototype.init=function(){D.media.attachHandler(this._onSizeChanged,this,f);e.prototype.init.apply(this,arguments);};A.prototype.onAfterRendering=function(){if(!D.media.hasRangeSet(f)){D.media.initRangeSet(f,[600,900],"px",[A.modes.MOBILE,A.modes.TABLET,A.modes.DESKTOP]);}this._onSizeChanged(D.media.getCurrentRange(f));e.prototype.onAfterRendering.apply(this,arguments);};A.prototype.exit=function(){D.media.detachHandler(this._onSizeChanged,this,f);e.prototype.exit.apply(this,arguments);};A.prototype._onSizeChanged=function(p){function s(C,j,t){var k=C.filter(function(l){return l.getLayoutData()&&l.getLayoutData().getPriority()===j;});k.forEach(function(l){l.getLayoutData().setPriority(t);});}var m=p.name;this.sMode=m;var o=this.getControl("exit");var h=this.getControl("overflowToolbar").getContent();var i=false;switch(m){case A.modes.MOBILE:i=false;o.setIcon("sap-icon://decline");o.setText("");s(h,"Low","AlwaysOverflow");r.call(this,i);this._setWidthOfHBoxes(false);break;case A.modes.TABLET:i=false;o.setIcon("");o.setText(this.getTextResources().getText("BTN_EXIT"));s(h,"Low","AlwaysOverflow");r.call(this,i);this._setWidthOfHBoxes(false);break;case A.modes.DESKTOP:i=true;o.setIcon("");o.setText(this.getTextResources().getText("BTN_EXIT"));s(h,"AlwaysOverflow","Low");r.call(this,i);this._setWidthOfHBoxes(true);break;default:}};function g(C){var o=this.getItems();if(C){var w=this.getControl("modeSwitcher").$().outerWidth();var h=w&&Math.floor(w/2);if(!h){o[1].setWidth("50%");}else{o[1].setWidth("calc(50% + "+h+"px)");}}else{o[1].setWidth("100%");}}function r(s){var m=this.getControl("manageApps");var o=this.getControl("appVariantOverview");if(s){m.setIcon("sap-icon://dimension");m.setText("");o.setIcon("sap-icon://dimension");o.setText("");}else{m.setIcon("");m.setText(this.getTextResources().getText("BTN_MANAGE_APPS_TXT"));o.setIcon("");o.setText(this.getTextResources().getText("BTN_MANAGE_APPS_TXT"));}}A.prototype._setWidthOfHBoxes=function(C){if(C){var m=this.getControl("modeSwitcher").getDomRef();if(!m){this._oDelegate={onAfterRendering:function(){g.call(this,C);this.getControl("modeSwitcher").removeEventDelegate(this._oDelegate,this);}};this.getControl("modeSwitcher").addEventDelegate(this._oDelegate,this);g.call(this,C);}else{g.call(this,C);}}else{g.call(this,C);}};A.prototype.getControl=function(n){return this._mControls[n];};A.prototype.buildControls=function(){this._mControls={};return[new H({alignItems:"Center",layoutData:new F({baseSize:"0",growFactor:1,minWidth:"0"})}),new H({alignItems:"Center",items:[this._mControls["overflowToolbar"]=new O({content:[this._mControls["modeSwitcher"]=new S({width:"auto",selectedKey:this.getModeSwitcher(),items:[new a({text:this.getTextResources().getText("BTN_ADAPTATION"),tooltip:this.getTextResources().getText("BTN_ADAPTATION"),width:"auto",key:"adaptation"}),new a({text:this.getTextResources().getText("BTN_NAVIGATION"),tooltip:this.getTextResources().getText("BTN_NAVIGATION"),width:"auto",key:"navigation"})],selectionChange:this.eventHandler.bind(this,"ModeChange"),layoutData:new d({priority:"High"})}),new T(),this._mControls["undo"]=new B({type:"Transparent",icon:"sap-icon://undo",enabled:false,tooltip:this.getTextResources().getText("BTN_UNDO"),press:this.eventHandler.bind(this,"Undo"),layoutData:new d({priority:"NeverOverflow"})}),this._mControls["redo"]=new B({type:"Transparent",icon:"sap-icon://redo",iconFirst:false,enabled:false,tooltip:this.getTextResources().getText("BTN_REDO"),press:this.eventHandler.bind(this,"Redo"),layoutData:new d({priority:"NeverOverflow"})}),this._mControls["manageApps"]=new B({type:"Transparent",icon:"sap-icon://dimension",enabled:false,visible:false,tooltip:this.getTextResources().getText("BTN_MANAGE_APPS_TXT"),press:this.eventHandler.bind(this,"ManageApps"),layoutData:new d({priority:"Low"})}),this._mControls["appVariantOverview"]=new M({type:"Transparent",icon:"sap-icon://dimension",enabled:false,visible:false,tooltip:this.getTextResources().getText("BTN_MANAGE_APPS_TXT"),menu:new c({itemSelected:this.eventHandler.bind(this,"AppVariantOverview"),items:[new b("keyUser",{text:this.getTextResources().getText("MENU_ITEM_KEY_USER")}),new b("developer",{text:this.getTextResources().getText("MENU_ITEM_SAP_DEVELOPER")})]}),layoutData:new d({priority:"Low"})}),this._mControls["restore"]=new B({type:"Transparent",text:this.getTextResources().getText("BTN_RESTORE"),visible:true,enabled:false,tooltip:this.getTextResources().getText("BTN_RESTORE"),press:this.eventHandler.bind(this,"Restore"),layoutData:new d({priority:"Low"})}),this._mControls["publish"]=new B({type:"Transparent",enabled:false,visible:this.getPublishVisible(),text:this.getTextResources().getText("BTN_PUBLISH"),tooltip:this.getTextResources().getText("BTN_PUBLISH"),press:this.eventHandler.bind(this,"Transport"),layoutData:new d({priority:"Low"})}),this._mControls["saveAs"]=new B({type:"Transparent",text:this.getTextResources().getText("BTN_SAVE_AS"),enabled:false,visible:false,tooltip:this.getTextResources().getText("TOOLTIP_SAVE_AS"),press:this.eventHandler.bind(this,"SaveAs"),layoutData:new d({priority:"Low"})})],layoutData:new F({growFactor:1,minWidth:"0"})}),this._mControls["exit"]=new B({type:"Transparent",text:this.getTextResources().getText("BTN_EXIT"),tooltip:this.getTextResources().getText("BTN_EXIT"),press:this.eventHandler.bind(this,"Exit"),icon:"sap-icon://decline"})],layoutData:new F({growFactor:0})})];};A.prototype.setUndoRedoEnabled=function(C,h){this.getControl("undo").setEnabled(C);this.getControl("redo").setEnabled(h);};A.prototype.setPublishEnabled=function(E){this.getControl("publish").setEnabled(E);};A.prototype.setRestoreEnabled=function(E){this.getControl("restore").setEnabled(E);};A.prototype.show=function(){return e.prototype.show.apply(this,arguments);};A.prototype.hide=function(){return e.prototype.hide.apply(this,arguments);};return A;},true);
