/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./calendar/CalendarUtils','./Calendar','./calendar/DatesRow','./calendar/MonthPicker','./calendar/YearPicker','./calendar/YearRangePicker','./calendar/CalendarDate','./library','sap/ui/Device',"./CalendarDateIntervalRenderer","sap/base/util/deepEqual","sap/ui/core/Popup","sap/base/Log","sap/ui/thirdparty/jquery","./DateRange"],function(C,a,D,M,Y,b,c,l,d,e,f,P,L,q,g){"use strict";var h=sap.ui.core.CalendarType;var j=a.extend("sap.ui.unified.CalendarDateInterval",{metadata:{library:"sap.ui.unified",properties:{startDate:{type:"object",group:"Data"},days:{type:"int",group:"Appearance",defaultValue:7},showDayNamesLine:{type:"boolean",group:"Appearance",defaultValue:true},pickerPopup:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{calendarPicker:{type:"sap.ui.unified.Calendar",multiple:false,visibility:"hidden"}},designtime:"sap/ui/unified/designtime/CalendarDateInterval.designtime"}});j.prototype.init=function(){a.prototype.init.apply(this,arguments);this._iDaysMonthHead=35;};j.prototype.onBeforeRendering=function(){a.prototype.onBeforeRendering.apply(this,arguments);this._bPoupupMode=this.getPickerPopup();};j.prototype._initilizeMonthPicker=function(){this.setAggregation("monthPicker",this._createMonthPicker());};j.prototype._initilizeYearPicker=function(){this.setAggregation("yearPicker",this._createYearPicker());};j.prototype._initilizeYearRangePicker=function(){this.setAggregation("yearRangePicker",this._createYearRangePicker());};j.prototype.setPickerPopup=function(p){this.setProperty("pickerPopup",p,true);var H=this.getAggregation("header"),m,y;if(p){if(this.getAggregation("monthPicker")){this.getAggregation("monthPicker").destroy();}if(this.getAggregation("yearPicker")){this.getAggregation("yearPicker").destroy();}H.setVisibleButton2(false);H.detachEvent("pressButton2",this._handleButton2,this);this._setHeaderText(this._getFocusedDate(true));}else{if(!this.getAggregation("monthPicker")){this.setAggregation("monthPicker",this._createMonthPicker());}if(!this.getAggregation("yearPicker")){this.setAggregation("yearPicker",this._createYearPicker());}m=this.getAggregation("monthPicker");y=this.getAggregation("yearPicker");m.setColumns(0);m.setMonths(6);y.setColumns(0);y.setYears(6);y._oMinDate.setYear(this._oMinDate.getYear());y._oMaxDate.setYear(this._oMaxDate.getYear());H.setVisibleButton2(true);H.detachEvent("pressButton2",this._handleButton2,this);H.attachEvent("pressButton2",this._handleButton2,this);}return this;};j.prototype._createMonthPicker=function(){var m=new M(this.getId()+"--MP");m.attachEvent("select",this._selectMonth,this);m._bNoThemeChange=true;m.setColumns(0);m.setMonths(3);m.attachEvent("pageChange",_,this);return m;};j.prototype._createYearPicker=function(){var y=new Y(this.getId()+"--YP");y.attachEvent("select",this._selectYear,this);y.setColumns(0);y.setYears(3);y.attachEvent("pageChange",k,this);return y;};j.prototype._createYearRangePicker=function(){var y=new b(this.getId()+"--YRP");y.attachEvent("select",this._selectYearRange,this);y.setPrimaryCalendarType(this.getPrimaryCalendarType());y.setYears(6);y.setRangeSize(this.getAggregation("yearPicker").getYears());return y;};j.prototype._adjustYearRangeDisplay=function(){var y=this.getAggregation("yearRangePicker");if(!this._getSucessorsPickerPopup()){switch(this.getPrimaryCalendarType()){case h.Gregorian:y.setColumns(3);y.setYears(3);break;default:y.setColumns(2);y.setYears(2);}}else{a.prototype._adjustYearRangeDisplay.call(this,arguments);}};j.prototype._getCalendarPicker=function(){var o=this.getAggregation("calendarPicker");if(!o){o=new a(this.getId()+"--Cal");o.setPopupMode(true);o.attachEvent("select",this._handleCalendarPickerDateSelect,this);o.attachEvent("cancel",function(E){this._closeCalendarPicker();var i=this.getAggregation("header").getDomRef("B1");if(i){i.focus();}},this);this.setAggregation("calendarPicker",o);}return o;};j.prototype._setAriaRole=function(r){var o=this.getAggregation("month")[0];o._setAriaRole(r);o.invalidate();return this;};j.prototype._handleButton1=function(E){if(this.getPickerPopup()){this._showCalendarPicker();}else{if(this._iMode!=1){this._showMonthPicker();}else{this._hideMonthPicker();}}};j.prototype._setHeaderText=function(o){var t=a.prototype._setHeaderText.apply(this,arguments);var T,A=t.sAriaLabel,H=this.getAggregation("header");var i=this._getLocaleData();var E=c.fromLocalJSDate(new Date(o.toLocalJSDate().getTime()+(this._getDays()-1)*24*60*60*1000),this.getPrimaryCalendarType());E.setDate(1);var s=i.getIntervalPattern().replace("{0}","").replace("{1}","");var m=this._oYearFormat.format(E.toUTCJSDate(),true);var n=t.sMonth;if(this.getPickerPopup()){if(i.oLocale.sLanguage.toLowerCase()==="ja"||i.oLocale.sLanguage.toLowerCase()==="zh"){if(m!=t.sYear){n=n.replace(s,s+m+" ");A=A.replace(s,s+m+" ");}T=t.sYear+" "+n;A=t.sYear+" "+A;}else{if(m!=t.sYear){n=n.replace(s," "+t.sYear+s);A=A.replace(s," "+t.sYear+s);}T=n+" "+m;A=A+" "+m;}H.setTextButton1(T,true);H.setAriaLabelButton1(A);}};j.prototype._showCalendarPicker=function(){var s=this.getStartDate(),o=this._getCalendarPicker(),S=new g(),E=new Date(s.getTime());E.setDate(E.getDate()+this._getDays()-1);S.setStartDate(s);S.setEndDate(E);o.displayDate(this._getFocusedDate().toLocalJSDate());o.removeAllSelectedDates();o.addSelectedDate(S);o.setMinDate(this.getMinDate());o.setMaxDate(this.getMaxDate());this._openPickerPopup(o);this._showOverlay();};j.prototype._handleCalendarPickerDateSelect=function(E){var o=this._getCalendarPicker(),s=o.getSelectedDates()[0].getStartDate(),n=new c.fromLocalJSDate(s);this._setStartDate(n);this._setFocusedDate(n);this._closeCalendarPicker();};j.prototype._closeCalendarPicker=function(s){if(this._oPopup&&this._oPopup.isOpen()){this._oPopup.close();}this._hideOverlay();if(!s){this._renderMonth();var m=this.getAggregation("month");for(var i=0;i<m.length;i++){var o=m[i];q(o._oItemNavigation.getItemDomRefs()[o._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}this.getAggregation("calendarPicker")._closedPickers();};j.prototype._getDaysLarge=function(){return 10;};j.prototype._createMonth=function(i){var m=new D(i);return m;};j.prototype.setStartDate=function(s){C._checkJSDateObject(s);if(f(this.getStartDate(),s)){return this;}var y=s.getFullYear();C._checkYearInValidRange(y);var o=c.fromLocalJSDate(s,this.getPrimaryCalendarType());if(C._isOutside(o,this._oMinDate,this._oMaxDate)){throw new Error("Date must be in valid range (minDate and maxDate); "+this);}var m=this.getMinDate();if(m&&s.getTime()<m.getTime()){L.warning("startDate < minDate -> minDate as startDate set",this);s=new Date(m.getTime());}var i=this.getMaxDate();if(i&&s.getTime()>i.getTime()){L.warning("startDate > maxDate -> maxDate as startDate set",this);s=new Date(i.getTime());}this.setProperty("startDate",s,true);o=c.fromLocalJSDate(s,this.getPrimaryCalendarType());this._oStartDate=o;var n=this.getAggregation("month")[0];n.setStartDate(s);this._updateHeader(o);var p=this._getFocusedDate(true).toLocalJSDate();if(!n.checkDateFocusable(p)){this._setFocusedDate(o);n.displayDate(s);}return this;};j.prototype.getStartDate=function(){return this.getProperty("startDate");};j.prototype.setDays=function(i){var y=this.getAggregation("yearRangePicker");this.setProperty("days",i,true);i=this._getDays();var o=this.getAggregation("month")[0];o.setDays(i);if(!this.getPickerPopup()){var m=this.getAggregation("monthPicker");var n=Math.ceil(i/3);if(n>12){n=12;}m.setMonths(n);var p=this.getAggregation("yearPicker");var r=Math.floor(i/2);if(r>20){r=20;}p.setYears(r);y.setRangeSize(r);}var s=this._getStartDate();this._updateHeader(s);if(this.getDomRef()){if(i>this._getDaysLarge()){this.$().addClass("sapUiCalIntLarge");}else{this.$().removeClass("sapUiCalIntLarge");}if(i>this._iDaysMonthHead){this.$().addClass("sapUiCalIntHead");}else{this.$().removeClass("sapUiCalIntHead");}}return this;};j.prototype._getDays=function(){var i=this.getDays();if(d.system.phone&&i>8){return 8;}else{return i;}};j.prototype.setShowDayNamesLine=function(s){this.setProperty("showDayNamesLine",s,true);var o=this.getAggregation("month")[0];o.setShowDayNamesLine(s);return this;};j.prototype._getShowMonthHeader=function(){var i=this._getDays();if(i>this._iDaysMonthHead){return true;}else{return false;}};j.prototype._getFocusedDate=function(F){if(!this._oFocusedDate||F){this._oFocusedDate=null;a.prototype._getFocusedDate.apply(this,arguments);var s=this.getStartDate();var o=this.getAggregation("month")[0];if(!s){this._setStartDate(this._oFocusedDate,false,true);}else if(!o.checkDateFocusable(this._oFocusedDate.toLocalJSDate())){this._oFocusedDate=c.fromLocalJSDate(s,this.getPrimaryCalendarType());}}return this._oFocusedDate;};j.prototype.setMonths=function(m){if(m==1){return this.setProperty("months",m,false);}else{throw new Error("Property months not supported "+this);}};j.prototype.setFirstDayOfWeek=function(F){if(F==-1){return this.setProperty("firstDayOfWeek",F,false);}else{throw new Error("Property firstDayOfWeek not supported "+this);}};j.prototype.focusDate=function(o){var i=this.getAggregation("month")[0];if(!i.checkDateFocusable(o)){this._focusDateExtend(c.fromLocalJSDate(o,this.getPrimaryCalendarType()),true,true);}a.prototype.focusDate.apply(this,arguments);return this;};j.prototype._focusOnShiftTab=function(){var H=this.getAggregation("header");if(this.getPickerPopup()&&H.getDomRef("B1")){H.getDomRef("B1").focus();}else if(!this.getPickerPopup()&&H.getDomRef("B2")){H.getDomRef("B2").focus();}};j.prototype.onsapescape=function(E){if(this.getPickerPopup()){this._closeCalendarPicker();this.fireCancel();}else{if(this._iMode===0){this.fireCancel();}this._closedPickers();}this._updateHeadersButtons();this._setHeaderText(this._getFocusedDate());};j.prototype._focusDateExtend=function(o,O,n){if(O){var i=this._getFocusedDate();var m=this._getStartDate();var p=C._daysBetween(i,m);var N=new c(o,this.getPrimaryCalendarType());N.setDate(N.getDate()-p);this._setStartDate(N,false,true);if(!n){return true;}}return false;};j.prototype._setMinMaxDateExtend=function(o){if(this._oStartDate){if(this._oStartDate.isBefore(this._oMinDate)){L.warning("start date < minDate -> minDate will be start date",this);this._setStartDate(new c(this._oMinDate,this.getPrimaryCalendarType()),true,true);}else{var E=new c(this._oStartDate);E.setDate(E.getDate()+this._getDays()-1);if(E.isAfter(this._oMaxDate)){L.warning("end date > maxDate -> start date will be changed",this);var s=new c(this._oMaxDate);s.setDate(s.getDate()-this._getDays()+1);this._setStartDate(s,true,true);}}}};j.prototype._togglePrevNext=function(o,i){if(this._iMode>1||(this._iMode==1&&this.getPickerPopup())){return a.prototype._togglePrevNext.apply(this,arguments);}var y=this._oMaxDate.getYear();var m=this._oMinDate.getYear();var n=this._oMaxDate.getMonth();var p=this._oMinDate.getMonth();var r=this._oMinDate.getDate();var s=this._oMaxDate.getDate();var H=this.getAggregation("header");var t=this._getDays();var u;var S;var E;var v;var w;if(this._iMode==1&&!i){var x=this.getAggregation("monthPicker");var z=x.getMonths();var A=x.getStartMonth();var B=A+z-1;u=o.getYear();if(A==0||(u==m&&A<=p)){H.setEnabledPrevious(false);}else{H.setEnabledPrevious(true);}if(B>10||(u==y&&B>=n)){H.setEnabledNext(false);}else{H.setEnabledNext(true);}return;}S=this._getStartDate();E=new c(S,this.getPrimaryCalendarType());E.setDate(E.getDate()+t-1);if(C._isOutside(o,S,E)){S=new c(o,this.getPrimaryCalendarType());E=new c(S,this.getPrimaryCalendarType());E.setDate(E.getDate()+t-1);}u=S.getYear();v=S.getMonth();w=S.getDate();if(u<m||(u==m&&(!i||v<p||(v==p&&w<=r)))){H.setEnabledPrevious(false);}else{H.setEnabledPrevious(true);}u=E.getYear();v=E.getMonth();w=E.getDate();if(u>y||(u==y&&(!i||v>n||(v==n&&w>=s)))){H.setEnabledNext(false);}else{H.setEnabledNext(true);}};j.prototype._shiftStartFocusDates=function(s,F,i){s.setDate(s.getDate()+i);F.setDate(F.getDate()+i);this._setFocusedDate(F);this._setStartDate(s,true);};j.prototype._handlePrevious=function(E){var F=new c(this._getFocusedDate(),this.getPrimaryCalendarType()),m,s,i;switch(this._iMode){case 0:s=new c(this._getStartDate(),this.getPrimaryCalendarType());i=this._getDays();this._shiftStartFocusDates(s,F,(i*-1));break;case 1:if(!this.getPickerPopup()){m=this.getAggregation("monthPicker");if(m.getMonths()<12){m.previousPage();this._togglePrevNext(F);}else{F.setYear(F.getYear()-1);var n=this._focusDateExtend(F,true,false);this._setFocusedDate(F);this._updateHeader(F);this._setDisabledMonths(F.getYear());if(n){this.fireStartDateChange();}}}break;case 2:if(!this.getPickerPopup()){this.getAggregation("yearPicker").previousPage();k.call(this);}break;case 3:if(!this.getPickerPopup()){this.getAggregation("yearRangePicker").previousPage();k.call(this);}break;}};j.prototype._handleNext=function(E){var F=new c(this._getFocusedDate(),this.getPrimaryCalendarType()),m,s,i;switch(this._iMode){case 0:s=new c(this._getStartDate(),this.getPrimaryCalendarType());i=this._getDays();this._shiftStartFocusDates(s,F,i);break;case 1:if(!this.getPickerPopup()){m=this.getAggregation("monthPicker");if(m.getMonths()<12){m.nextPage();this._togglePrevNext(F);}else{F.setYear(F.getYear()+1);var n=this._focusDateExtend(F,true,false);this._setFocusedDate(F);this._updateHeader(F);this._setDisabledMonths(F.getYear());if(n){this.fireStartDateChange();}}}break;case 2:if(!this.getPickerPopup()){this.getAggregation("yearPicker").nextPage();k.call(this);}break;case 3:if(!this.getPickerPopup()){this.getAggregation("yearRangePicker").nextPage();k.call(this);}break;}};j.prototype._getDisplayedMonths=function(o){var m=[];var i=o.getMonth();var n=this._getDays();m.push(i);if(n>this._getDaysLarge()){var E=new c(o,this.getPrimaryCalendarType());E.setDate(E.getDate()+n-1);var p=E.getMonth();while(i!=p){i=(i+1)%12;m.push(i);}}return m;};j.prototype._getDisplayedSecondaryMonths=function(p,s){var i=this._getDays();var S=new c(this._getStartDate(),s);var m=S.getMonth();var E=new c(S,this.getPrimaryCalendarType());E.setDate(E.getDate()+i-1);E=new c(E,s);var n=E.getMonth();return{start:m,end:n};};j.prototype._openPickerPopup=function(p){if(!this._oPopup){this._oPopup=new P();this._oPopup.setAutoClose(true);this._oPopup.setAutoCloseAreas([this.getDomRef()]);this._oPopup.setDurations(0,0);this._oPopup._oCalendar=this;this._oPopup.attachClosed(function(){this._closeCalendarPicker(true);},this);this._oPopup.onsapescape=function(E){this._oCalendar.onsapescape(E);};}this._oPopup.setContent(p);var H=this.getAggregation("header");var i=P.Dock;this._oPopup.open(0,i.CenterTop,i.CenterTop,H,null,"flipfit",true);};j.prototype._getMaxDateAlignedToMinDate=function(m,o){var n=new c(m,this.getPrimaryCalendarType());if(n.isBefore(o)){n=new c(o);n.setDate(n.getDate()+this._getDays()-1);}return n;};j.prototype._getStartDateAlignedToMinAndMaxDate=function(m,o,s){var n=new c(s,this.getPrimaryCalendarType());if(n.isBefore(o)){n=new c(o,this.getPrimaryCalendarType());}else if(n.isAfter(m)){n=m;}return n;};j.prototype._calculateStartDate=function(m,o,s){var n=new c(m,this.getPrimaryCalendarType());n.setDate(n.getDate()-this._getDays()+1);n=this._getMaxDateAlignedToMinDate(n,o);s=this._getStartDateAlignedToMinAndMaxDate(n,o,s);return s;};j.prototype._setStartDate=function(s,S,n){s=this._calculateStartDate(this._oMaxDate,this._oMinDate,s);var o=s.toLocalJSDate();this.setProperty("startDate",o,true);this._oStartDate=s;var i=this.getAggregation("month")[0];i.setStartDate(o);this._updateHeader(s);if(S){var m=this._getFocusedDate().toLocalJSDate();if(!i.checkDateFocusable(m)){this._setFocusedDate(s);i.setDate(o);}else{i.setDate(m);}}if(!n){this.fireStartDateChange();}};j.prototype._getStartDate=function(){if(!this._oStartDate){this._oStartDate=this._getFocusedDate();}return this._oStartDate;};function _(E){var F=new c(this._getFocusedDate(),this.getPrimaryCalendarType());this._togglePrevNext(F);}function k(E){this._togglePrevNexYearPicker();this._updateHeadersYearPrimaryText(this._getYearString());}return j;});
