/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Control','sap/ui/Device','sap/ui/core/LocaleData','sap/ui/unified/calendar/CalendarUtils','sap/ui/core/date/UniversalDate','./library','sap/ui/core/InvisibleText','sap/ui/core/format/DateFormat','sap/ui/core/ResizeHandler','sap/ui/core/Locale',"./CalendarRowRenderer","sap/ui/dom/containsOrEquals","sap/ui/thirdparty/jquery","sap/ui/unified/CalendarAppointment"],function(C,D,L,a,U,l,I,b,R,c,d,e,q,f){"use strict";var g=l.CalendarDayType;var h=l.CalendarAppointmentVisualization;var G=l.GroupAppointmentsMode;var m=l.CalendarIntervalType;var n=C.extend("sap.ui.unified.CalendarRow",{metadata:{library:"sap.ui.unified",properties:{startDate:{type:"object",group:"Data"},intervals:{type:"int",group:"Appearance",defaultValue:12},intervalType:{type:"sap.ui.unified.CalendarIntervalType",group:"Appearance",defaultValue:m.Hour},showSubIntervals:{type:"boolean",group:"Appearance",defaultValue:false},showIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},showEmptyIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},nonWorkingDays:{type:"int[]",group:"Misc",defaultValue:null},nonWorkingHours:{type:"int[]",group:"Misc",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},checkResize:{type:"boolean",group:"Behavior",defaultValue:true},updateCurrentTime:{type:"boolean",group:"Behavior",defaultValue:true},groupAppointmentsMode:{type:"sap.ui.unified.GroupAppointmentsMode",group:"Appearance",defaultValue:G.Collapsed},appointmentsReducedHeight:{type:"boolean",group:"Appearance",defaultValue:false},appointmentsVisualization:{type:"sap.ui.unified.CalendarAppointmentVisualization",group:"Appearance",defaultValue:h.Standard}},aggregations:{appointments:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"appointment"},intervalHeaders:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"intervalHeader"},groupAppointments:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"groupAppointment",visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{parameters:{appointment:{type:"sap.ui.unified.CalendarAppointment"},appointments:{type:"sap.ui.unified.CalendarAppointment[]"},multiSelect:{type:"boolean"},domRefId:{type:"string"}}},startDateChange:{},leaveRow:{parameters:{type:{type:"string"}}},intervalSelect:{parameters:{startDate:{type:"object"},endDate:{type:"object"},subInterval:{type:"boolean"}}}}}});n.prototype.init=function(){this._bRTL=sap.ui.getCore().getConfiguration().getRTL();this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");this._oFormatAria=b.getDateTimeInstance({pattern:"EEEE dd/MM/YYYY 'at' HH:mm:ss a"});this._iHoursMinDelta=1;this._iDaysMinDelta=30;this._iMonthsMinDelta=720;this._aVisibleAppointments=[];this._aVisibleIntervalHeaders=[];this.setStartDate(new Date());this._resizeProxy=q.proxy(this.handleResize,this);this.aSelectedAppointments=[];this._fnCustomSortedAppointments=undefined;};n.prototype.exit=function(){if(this._sResizeListener){R.deregister(this._sResizeListener);this._sResizeListener=undefined;}if(this._sUpdateCurrentTime){clearTimeout(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}this._fnCustomSortedAppointments=undefined;};n.prototype.onBeforeRendering=function(){r.call(this);u.call(this);y.call(this);if(this._sUpdateCurrentTime){clearTimeout(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}};n.prototype.onAfterRendering=function(){z.call(this);this.updateCurrentTimeVisualization();if(this.getCheckResize()&&!this._sResizeListener){this._sResizeListener=R.register(this,this._resizeProxy);}};n.prototype.onThemeChanged=function(j){if(this.getDomRef()){for(var i=0;i<this._aVisibleAppointments.length;i++){var k=this._aVisibleAppointments[i];k.level=-1;}this.handleResize(j);}};n.prototype.invalidate=function(O){if(O&&O instanceof f){var j=false;for(var i=0;i<this._aVisibleAppointments.length;i++){if(this._aVisibleAppointments[i].appointment==O){j=true;break;}}if(j){this._aVisibleAppointments=[];}this._updateSelectedAppointmentsArray(O);}C.prototype.invalidate.apply(this,arguments);};n.prototype.setStartDate=function(S){if(!S){S=new Date();}a._checkJSDateObject(S);var Y=S.getFullYear();a._checkYearInValidRange(Y);this.setProperty("startDate",S);return this;};n.prototype._getStartDate=function(){if(!this._oUTCStartDate){this._oUTCStartDate=a._createUniversalUTCDate(this.getStartDate(),undefined,true);}return this._oUTCStartDate;};n.prototype.setIntervalType=function(i){this.setProperty("intervalType",i);this._aVisibleAppointments=[];return this;};n.prototype.setGroupAppointmentsMode=function(i){this.setProperty("groupAppointmentsMode",i);this._aVisibleAppointments=[];return this;};n.prototype.setAppointmentsReducedHeight=function(i){this.setProperty("appointmentsReducedHeight",i);this._aVisibleAppointments=[];return this;};n.prototype._getAppointmentReducedHeight=function(i){var j=false;if(!D.system.phone&&this.getAppointmentsReducedHeight()&&!i.getText()){j=true;}return j;};n.prototype.onfocusin=function(j){if(q(j.target).hasClass("sapUiCalendarApp")){H.call(this,j.target.id);}else{var V=this._getVisibleAppointments();var k=false;var O;for(var i=0;i<V.length;i++){O=V[i].appointment;if(e(O.getDomRef(),j.target)){k=true;O.focus();break;}}if(!k){O=this.getFocusedAppointment();if(O){O.focus();}}}};n.prototype.applyFocusInfo=function(i){if(this._sFocusedAppointmentId){this.getFocusedAppointment().focus();}return this;};n.prototype.onsapleft=function(i){if(q(i.target).hasClass("sapUiCalendarApp")){J.call(this,this._bRTL,1);}i.preventDefault();i.stopPropagation();};n.prototype.onsapright=function(i){if(q(i.target).hasClass("sapUiCalendarApp")){J.call(this,!this._bRTL,1);}i.preventDefault();i.stopPropagation();};n.prototype.onsapup=function(i){this.fireLeaveRow({type:i.type});};n.prototype.onsapdown=function(i){this.fireLeaveRow({type:i.type});};n.prototype.onsaphome=function(i){K.call(this,i);i.preventDefault();i.stopPropagation();};n.prototype.onsapend=function(i){K.call(this,i);i.preventDefault();i.stopPropagation();};n.prototype.onsapselect=function(j){var V=this._getVisibleAppointments();for(var i=0;i<V.length;i++){var k=V[i].appointment;if(e(k.getDomRef(),j.target)){A.call(this,k,!(j.ctrlKey||j.metaKey));break;}}j.stopPropagation();j.preventDefault();};n.prototype.ontap=function(i){var j=this.$("Apps").children(".sapUiCalendarRowAppsInt");var k=0;var O=false;for(k=0;k<j.length;k++){var P=j[k];if(!this._isOneMonthsRowOnSmallSizes()&&e(P,i.target)){O=true;break;}}if(O){M.call(this,k,i.target);}else{this.onsapselect(i);}};n.prototype.onsapselectmodifiers=function(i){this.onsapselect(i);};n.prototype.handleResize=function(i){if(i&&i.size&&i.size.width<=0){return this;}var $=this.$("DummyApp");$.css("display","");z.call(this);return this;};n.prototype.updateCurrentTimeVisualization=function(){var $=this.$("Now");var i=a._createUniversalUTCDate(new Date(),undefined,true);var j=this.getIntervals();var k=this.getIntervalType();var S=this._getStartDate();var O=S.getTime();var P=this._oUTCEndDate;var Q=P.getTime();this._sUpdateCurrentTime=undefined;if(i.getTime()<=Q&&i.getTime()>=O){var T=w.call(this,k,j,S,P,O,i);var V=0;if(this._bRTL){$.css("right",T+"%");}else{$.css("left",T+"%");}$.css("display","");if(this.getUpdateCurrentTime()){switch(k){case m.Hour:V=60000;break;case m.Day:case m.Week:case m.OneMonth:V=1800000;break;default:V=-1;break;}if(V>0){this._sUpdateCurrentTime=setTimeout(this.updateCurrentTimeVisualization.bind(this),V);}}}else{$.css("display","none");}return this;};n.prototype.getFocusedAppointment=function(){var j=this._getAppointmentsSorted();var k=this.getAggregation("groupAppointments",[]);var O;var i=0;for(i=0;i<k.length;i++){if(k[i].getId()==this._sFocusedAppointmentId){O=k[i];break;}}if(!O){for(i=0;i<j.length;i++){if(j[i].getId()==this._sFocusedAppointmentId){O=j[i];break;}}}return O;};n.prototype.focusAppointment=function(i){if(!i||!(i instanceof f)){throw new Error("Appointment must be a CalendarAppointment; "+this);}var j=i.getId();if(this._sFocusedAppointmentId!=j){H.call(this,j);}else{i.focus();}return this;};n.prototype.focusNearestAppointment=function(j){a._checkJSDateObject(j);var k=this._getAppointmentsSorted();var O;var P;var Q;for(var i=0;i<k.length;i++){O=k[i];if(O.getStartDate()>j){if(i>0){P=k[i-1];}else{P=O;}break;}}if(O){if(P&&Math.abs(O.getStartDate()-j)>=Math.abs(P.getStartDate()-j)){Q=P;}else{Q=O;}this.focusAppointment(Q);}return this;};n.prototype._getVisibleAppointments=function(){return this._aVisibleAppointments;};n.prototype._getVisibleIntervalHeaders=function(){return this._aVisibleIntervalHeaders;};n.prototype._getNonWorkingDays=function(){var j=this.getNonWorkingDays();if(!j){var k=p.call(this);var W=k.getWeekendStart();var O=k.getWeekendEnd();j=[];for(var i=0;i<=6;i++){if((W<=O&&i>=W&&i<=O)||(W>O&&(i>=W||i<=O))){j.push(i);}}}else if(!Array.isArray(j)){j=[];}return j;};n.prototype._isOneMonthsRowOnSmallSizes=function(){return this.getIntervalType()===m.OneMonth&&this.getIntervals()===1;};n.prototype._getAppointmentsSorted=function(){var i=this.getAppointments(),j=N;i.sort(this._fnCustomSortedAppointments?this._fnCustomSortedAppointments:j);return i;};n.prototype._setCustomAppointmentsSorterCallback=function(S){this._fnCustomSortedAppointments=S;this.invalidate();};n.prototype._calculateAppoitnmentVisualCue=function(i){if(_(this,i)){return{appTimeUnitsDifRowStart:0,appTimeUnitsDifRowEnd:0};}var j=i.getStartDate(),k=i.getEndDate(),O=new U(j.getFullYear(),j.getMonth(),j.getDate(),j.getHours(),j.getMinutes()),P=new U(k.getFullYear(),k.getMonth(),k.getDate(),k.getHours(),k.getMinutes()),Q=this.getIntervalType(),T=this.getStartDate(),S=Q==="Hour"?new U(T.getFullYear(),T.getMonth(),T.getDate(),T.getHours()):new U(T.getFullYear(),T.getMonth(),T.getDate()),V=this.getIntervals(),W;switch(Q){case"Hour":W=new U(T.getFullYear(),T.getMonth(),T.getDate(),T.getHours()+V);break;case"Day":case"Week":case"One Month":W=new U(T.getFullYear(),T.getMonth(),T.getDate()+V);break;case"Month":W=new U(T.getFullYear(),T.getMonth()+V,T.getDate());break;default:break;}return{appTimeUnitsDifRowStart:S.getTime()-O.getTime(),appTimeUnitsDifRowEnd:P.getTime()-W.getTime()};};n.prototype._updateSelectedAppointmentsArray=function(i){if(i.getSelected()){if(this.aSelectedAppointments.indexOf(i.getId())===-1){this.aSelectedAppointments.push(i.getId());}}else{this.aSelectedAppointments=this.aSelectedAppointments.filter(function(j){return j!==i.getId();});}};function _(j,k){var O=j.getAggregation("groupAppointments",[]);var i;for(i=0;i<O.length;++i){if(k===O[i]){return true;}}return false;}function o(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;}function p(){if(!this._oLocaleData){var i=o.call(this);var j=new c(i);this._oLocaleData=L.getInstance(j);}return this._oLocaleData;}function r(){var S=this.getStartDate();var i;var j=this.getIntervals();var k=this.getIntervalType();this._oUTCStartDate=s.call(this,S);switch(k){case m.Hour:i=new U(this._oUTCStartDate.getTime());i.setUTCHours(i.getUTCHours()+j);this._iMinDelta=this._iHoursMinDelta;break;case m.Day:case m.Week:case m.OneMonth:i=new U(this._oUTCStartDate.getTime());i.setUTCDate(i.getUTCDate()+j);this._iMinDelta=this._iDaysMinDelta;break;case m.Month:i=new U(this._oUTCStartDate.getTime());i.setUTCMonth(i.getUTCMonth()+j);this._iMinDelta=this._iMonthsMinDelta;break;default:throw new Error("Unknown IntervalType: "+k+"; "+this);}i.setUTCMilliseconds(-1);this._iRowSize=i.getTime()-this._oUTCStartDate.getTime();this._iIntervalSize=Math.floor(this._iRowSize/j);this._oUTCEndDate=i;}function s(i){var j=this.getIntervalType();var k=a._createUniversalUTCDate(i,undefined,true);switch(j){case m.Hour:k.setUTCMinutes(0);k.setUTCSeconds(0);k.setUTCMilliseconds(0);break;case m.Day:case m.Week:case m.OneMonth:k.setUTCHours(0);k.setUTCMinutes(0);k.setUTCSeconds(0);k.setUTCMilliseconds(0);break;case m.Month:k.setUTCDate(1);k.setUTCHours(0);k.setUTCMinutes(0);k.setUTCSeconds(0);k.setUTCMilliseconds(0);break;default:throw new Error("Unknown IntervalType: "+j+"; "+this);}return k;}function t(){return D.system.phone||(this.getGroupAppointmentsMode()===G.Collapsed);}function u(){var O=this._getAppointmentsSorted();var P;var Q;var S;var T=this.getIntervals();var V=this.getIntervalType();var W=this._getStartDate();var X=W.getTime();var Y=this._oUTCEndDate;var Z=Y.getTime();var $=[];var a1=false;var i=0;var j=0;var b1=t.call(this);this.destroyAggregation("groupAppointments",true);for(i=0;i<O.length;i++){P=O[i];var c1=a._createUniversalUTCDate(P.getStartDate(),undefined,true);var d1=c1.getTime();c1.setUTCSeconds(0);c1.setUTCMilliseconds(0);var e1=P.getEndDate()?a._createUniversalUTCDate(P.getEndDate(),undefined,true):a._createUniversalUTCDate(new Date(864000000000000),undefined,true);var f1=e1.getTime();e1.setUTCSeconds(0);e1.setUTCMilliseconds(0);var g1=false;if(c1.getTime()<X&&e1.getTime()>=X){c1=new U(X);g1=true;}if(e1.getTime()>Z&&c1.getTime()<=Z){e1=new U(Z);g1=true;}var h1=c1.getUTCHours()*60+c1.getUTCMinutes();c1.setUTCMinutes(c1.getUTCMinutes()-(h1%this._iMinDelta));var i1=(e1.getTime()-c1.getTime())/60000;if(g1&&i1==0){continue;}var j1=0;var k1=0;var l1=-1;Q=undefined;S=undefined;if(c1&&c1.getTime()<=Z&&e1&&e1.getTime()>=X&&d1<f1){if(b1&&(V==m.Month)&&((e1.getTime()-c1.getTime())<604800000)){Q=v.call(this,c1,P,V,T,W,Y,X,$);var m1=a._createUniversalUTCDate(Q.getEndDate(),undefined,true);if(e1.getTime()>m1.getTime()){S=v.call(this,e1,P,V,T,W,Y,X,$);}}j1=w.call(this,V,T,W,Y,X,c1);k1=x.call(this,V,T,W,Y,X,e1);if(Q){Q._iBegin=j1;Q._iEnd=k1;Q._iLevel=l1;if(S){S._iBegin=j1;S._iEnd=k1;S._iLevel=l1;}continue;}$.push({appointment:P,begin:j1,end:k1,calculatedEnd:k1,level:l1});if(this._sFocusedAppointmentId&&this._sFocusedAppointmentId==P.getId()){a1=true;}}}var n1=this.getAggregation("groupAppointments",[]);if(n1.length>0){for(i=0;i<$.length;i++){P=$[i];if(P.appointment._aAppointments&&P.appointment._aAppointments.length<=1){Q=P.appointment;var o1=false;if(Q._aAppointments.length==0){o1=true;}else{for(j=0;j<$.length;j++){if($[j].appointment==Q._aAppointments[0]){o1=true;break;}}}if(!o1){for(j=0;j<n1.length;j++){S=n1[j];if(Q!=S){for(var k=0;k<S._aAppointments.length;k++){if(Q._aAppointments[0]==S._aAppointments[k]){S._aAppointments.splice(k,1);if(S._aAppointments.length==1){this.removeAggregation("groupAppointments",S);S.destroy();n1=this.getAggregation("groupAppointments",[]);}else{S.setProperty("title",S._aAppointments.length,true);}break;}}}}P.begin=Q._iBegin;P.end=Q._iEnd;P.calculatedEnd=Q._iEnd;P.level=Q._iLevel;P.appointment=Q._aAppointments[0];}else{$.splice(i,1);i--;}this.removeAggregation("groupAppointments",Q);Q.destroy();n1=this.getAggregation("groupAppointments",[]);}}}if(!a1){if($.length>0){this._sFocusedAppointmentId=$[0].appointment.getId();}else{this._sFocusedAppointmentId=undefined;}}this._aVisibleAppointments=$;return this._aVisibleAppointments;}function v(i,k,O,P,S,Q,T,V){var W=this.getAggregation("groupAppointments",[]);var X;var Y=p.call(this);var Z=Y.getFirstDayOfWeek();var $=i.getUTCDay();var a1=new U(i.getTime());a1.setUTCHours(0);a1.setUTCMinutes(0);a1.setUTCSeconds(0);a1.setUTCMilliseconds(0);if(Z<=$){a1.setDate(a1.getDate()-($-Z));}else{a1.setDate(a1.getDate()-(7-$-Z));}for(var j=0;j<W.length;j++){X=W[j];var b1=a._createUniversalUTCDate(X.getStartDate(),undefined,true);if(b1.getTime()==a1.getTime()){break;}X=undefined;}if(!X){var c1=new U(a1.getTime());c1.setDate(c1.getDate()+7);c1.setMilliseconds(-1);X=new f(this.getId()+"-Group"+W.length,{type:k.getType(),startDate:a._createLocalDate(new Date(a1.getTime()),true),endDate:a._createLocalDate(new Date(c1.getTime()),true)});X._aAppointments=[];this.addAggregation("groupAppointments",X,true);var d1=w.call(this,O,P,S,Q,T,a1);var e1=x.call(this,O,P,S,Q,T,c1);V.push({appointment:X,begin:d1,end:e1,calculatedEnd:e1,level:-1});}X._aAppointments.push(k);if(X.getType()!=g.None&&X.getType()!=k.getType()){X.setType(g.None);}X.setProperty("title",X._aAppointments.length,true);return X;}function w(i,j,S,k,O,P){var Q=0;if(i!=m.Month){Q=100*(P.getTime()-O)/this._iRowSize;}else{var T=new U(P.getTime());T.setUTCDate(1);T.setUTCHours(0);T.setUTCMinutes(0);T.setUTCSeconds(0);T.setUTCMilliseconds(0);var V=new U(T.getTime());V.setUTCMonth(V.getUTCMonth()+1);V.setMilliseconds(-1);var W=V.getTime()-T.getTime();var X=(T.getUTCFullYear()-S.getUTCFullYear())*12+T.getUTCMonth()-S.getUTCMonth();Q=(100*X/j)+(100*(P.getTime()-T.getTime())/W)/j;}if(Q<0){Q=0;}Q=Math.round(Q*100000)/100000;return Q;}function x(i,j,S,k,O,P){var Q=0;if(i!=m.Month){Q=100-(100*(P.getTime()-O)/this._iRowSize);}else{var T=new U(P.getTime());T.setUTCDate(1);T.setUTCHours(0);T.setUTCMinutes(0);T.setUTCSeconds(0);T.setUTCMilliseconds(0);var V=new U(T.getTime());V.setUTCMonth(V.getUTCMonth()+1);V.setMilliseconds(-1);var W=V.getTime()-T.getTime();var X=(T.getUTCFullYear()-S.getUTCFullYear())*12+T.getUTCMonth()-S.getUTCMonth();Q=100-((100*X/j)+(100*(P.getTime()-T.getTime())/W)/j);}if(Q<0){Q=0;}Q=Math.round(Q*100000)/100000;return Q;}function y(){var V=[];if(this.getShowIntervalHeaders()){var k=this.getIntervalHeaders();var O;var P=this.getIntervals();var Q=this.getIntervalType();var S=this._getStartDate();var T=S.getTime();var W=this._oUTCEndDate;var X=W.getTime();var i=0;var j=0;for(i=0;i<k.length;i++){O=k[i];var Y=a._createUniversalUTCDate(O.getStartDate(),undefined,true);Y.setUTCSeconds(0);Y.setUTCMilliseconds(0);var Z=O.getEndDate()?a._createUniversalUTCDate(O.getEndDate(),undefined,true):a._createUniversalUTCDate(new Date(864000000000000),undefined,true);Z.setUTCSeconds(0);Z.setUTCMilliseconds(0);if(Y&&Y.getTime()<=X&&Z&&Z.getTime()>=T){var $=new U(S.getTime());var a1=new U(S.getTime());a1.setUTCMinutes(a1.getUTCMinutes()-1);var b1=-1;var c1=-1;for(j=0;j<P;j++){switch(Q){case m.Hour:a1.setUTCHours(a1.getUTCHours()+1);if(j>0){$.setUTCHours($.getUTCHours()+1);}break;case m.Day:case m.Week:case m.OneMonth:a1.setUTCDate(a1.getUTCDate()+1);if(j>0){$.setUTCDate($.getUTCDate()+1);}break;case m.Month:a1.setUTCDate(1);a1.setUTCMonth(a1.getUTCMonth()+2);a1.setUTCDate(0);if(j>0){$.setUTCMonth($.getUTCMonth()+1);}break;default:throw new Error("Unknown IntervalType: "+Q+"; "+this);}if(Y&&Y.getTime()<=$.getTime()&&Z&&Z.getTime()>=a1.getTime()){if(b1<0){b1=j;}c1=j;}}if(b1>=0){V.push({interval:b1,appointment:O,last:c1});}}}}this._aVisibleIntervalHeaders=V;return this._aVisibleIntervalHeaders;}function z(){if(this._isOneMonthsRowOnSmallSizes()){return;}var $=this.$("Apps");var k=$.innerWidth();if(k<=0){return;}var O=this.$("DummyApp");var P=O.outerHeight(true);if(P<=0){return;}var Q=O.outerWidth();var S=Q/k*100;var T=Math.ceil(1000*S)/1000;var V;var W;var X=0;var Y=0;var i=0;var Z=!D.system.phone&&this.getAppointmentsReducedHeight();if(this.getShowIntervalHeaders()&&(this.getShowEmptyIntervalHeaders()||this._getVisibleIntervalHeaders().length>0)){X=q(this.$("AppsInt0").children(".sapUiCalendarRowAppsIntHead")[0]).outerHeight(true);}for(i=0;i<this._aVisibleAppointments.length;i++){V=this._aVisibleAppointments[i];W=V.appointment.$();var a1=Math.floor(1000*(100-V.calculatedEnd-V.begin))/1000;var b1=false;if(a1<T){V.end=100-V.begin-S;if(V.end<0){V.end=0;}V.level=-1;b1=true;W.addClass("sapUiCalendarAppSmall");}else if(W.hasClass("sapUiCalendarAppSmall")){V.end=V.calculatedEnd;b1=true;W.removeClass("sapUiCalendarAppSmall");}if(b1){if(this._bRTL){W.css("left",V.end+"%");}else{W.css("right",V.end+"%");}}}for(i=0;i<this._aVisibleAppointments.length;i++){V=this._aVisibleAppointments[i];W=V.appointment.$();var c1={};var d1=Z&&!this._getAppointmentReducedHeight(V.appointment);if(V.level<0){for(var j=0;j<this._aVisibleAppointments.length;j++){var e1=this._aVisibleAppointments[j];if(V!=e1&&V.begin<(Math.floor(1000*(100-e1.end))/1000)&&(Math.floor(1000*(100-V.end))/1000)>e1.begin&&e1.level>=0){if(c1[e1.level]){c1[e1.level]++;}else{c1[e1.level]=1;}if(Z&&!this._getAppointmentReducedHeight(e1.appointment)){if(c1[e1.level+1]){c1[e1.level+1]++;}else{c1[e1.level+1]=1;}}}}V.level=0;while(c1[V.level]||(d1&&c1[V.level+1])){V.level++;}W.attr("data-sap-level",V.level);}W.css("top",(P*V.level+X)+"px");var f1=V.level;if(d1){f1++;}if(Y<f1){Y=f1;}}Y++;P=P*Y+X;if(!this.getHeight()){$.outerHeight(P);}else{var g1=this.$("Apps").children(".sapUiCalendarRowAppsInt");for(i=0;i<g1.length;i++){var h1=q(g1[i]);h1.outerHeight(P);}}O.css("display","none");}function A(j,k){var i=0;var O;var P;var Q;var S;var T=I.getStaticId("sap.ui.unified","APPOINTMENT_SELECTED");if(k){var V=this.getAppointments();var W=this.getAggregation("groupAppointments",[]);q.merge(V,W);for(i=0;i<V.length;i++){O=V[i];if(O.getId()!==j.getId()&&O.getSelected()){O.setProperty("selected",false,true);O.$().removeClass("sapUiCalendarAppSel");for(var i=0;i<this.aSelectedAppointments.length;i++){if(this.aSelectedAppointments[i]!==O.getId()){this.aSelectedAppointments.splice(i);}}P=O.$().attr("aria-labelledby");Q=P?P.replace(T,""):"";O.$().attr("aria-labelledby",Q);}}}S=j.$().attr("aria-labelledby")+" "+T;Q=j.$().attr("aria-labelledby").replace(T,"").trim();if(j.getSelected()){j.setProperty("selected",false,true);j.$().removeClass("sapUiCalendarAppSel");j.$().attr("aria-labelledby",Q);E(this,k);}else{j.setProperty("selected",true,true);j.$().addClass("sapUiCalendarAppSel");j.$().attr("aria-labelledby",S);E(this,k);}this._updateSelectedAppointmentsArray(j);if(j._aAppointments){for(i=0;i<j._aAppointments.length;i++){O=j._aAppointments[i];O.setProperty("selected",true,true);S=O.$().attr("aria-labelledby")+" "+T;O.$().attr("aria-labelledby",S);}this.fireSelect({appointments:j._aAppointments,multiSelect:!k,domRefId:j.getId()});}else{this.fireSelect({appointment:j,multiSelect:!k,domRefId:j.getId()});}}function B(i){var P=this._getPlanningCalendar();if(P){P["_onRow"+i]();}}n.prototype._getPlanningCalendar=function(){var P=this;while(P.getParent()!==null){if(P.getMetadata().getName()==="sap.m.PlanningCalendar"){return P;}P=P.getParent();}};function E(i,j){if(j){B.call(i,"DeselectAppointment");}}function F(k){var O=this.getAggregation("groupAppointments",[]);var P;var Q=false;for(var i=0;i<O.length;i++){var S=O[i]._aAppointments;for(var j=0;j<S.length;j++){if(S[j].getId()==k){P=O[i];Q=true;break;}}if(Q){break;}}return P;}function H(j){if(this._sFocusedAppointmentId!=j){var k=this._getAppointmentsSorted();var V=this._aVisibleAppointments;var O;var i=0;O=F.call(this,j);if(O){j=O.getId();O=undefined;}for(i=0;i<V.length;i++){if(V[i].appointment.getId()==j){O=V[i].appointment;break;}}if(O){var $=this.getFocusedAppointment().$();var P=O.$();this._sFocusedAppointmentId=O.getId();$.attr("tabindex","-1");P.attr("tabindex","0");P.focus();}else{for(i=0;i<k.length;i++){if(k[i].getId()==j){O=k[i];break;}}if(O){this._sFocusedAppointmentId=O.getId();var Q=s.call(this,O.getStartDate());this.setStartDate(a._createLocalDate(Q,true));if(!e(this.getDomRef(),document.activeElement)){setTimeout(function(){this.getFocusedAppointment().focus();}.bind(this),0);}this.fireStartDateChange();}}}}function J(j,S){var k=this._sFocusedAppointmentId;var O=this._getAppointmentsSorted();var P=this.getAggregation("groupAppointments",[]);var Q;var T=0;var i=0;for(i=0;i<P.length;i++){if(P[i].getId()==k){var V=P[i]._aAppointments;if(j){k=V[V.length-1].getId();}else{k=V[0].getId();}break;}}for(i=0;i<O.length;i++){if(O[i].getId()==k){T=i;break;}}if(j){T=T+S;}else{T=T-S;}if(T<0){T=0;}else if(T>=O.length){T=O.length-1;}Q=O[T];H.call(this,Q.getId());}function K(j){var k=this._getAppointmentsSorted();var O;var S=new U(this._getStartDate());var P=new U(this._oUTCEndDate);var Q=this.getIntervalType();var T;var V;S.setUTCHours(0);P.setUTCHours(0);P.setUTCMinutes(0);P.setUTCSeconds(0);switch(Q){case m.Hour:P.setUTCDate(P.getUTCDate()+1);P.setUTCMilliseconds(-1);break;case m.Day:case m.Week:case m.OneMonth:S.setUTCDate(1);P.setUTCMonth(P.getUTCMonth()+1);P.setUTCDate(1);P.setUTCMilliseconds(-1);break;case m.Month:S.setUTCMonth(0);S.setUTCDate(1);P.setUTCFullYear(P.getUTCFullYear()+1);P.setUTCMonth(1);P.setUTCDate(1);P.setUTCMilliseconds(-1);break;default:throw new Error("Unknown IntervalType: "+Q+"; "+this);}var W=a._createLocalDate(S,true);var X=a._createLocalDate(P,true);for(var i=0;i<k.length;i++){if(k[i].getStartDate()>=W&&k[i].getStartDate()<=X){O=k[i];T=O.getId();if(j.type=="saphome"){break;}}else if(k[i].getStartDate()>X){break;}}V=F.call(this,T);if(V){O=V;T=O.getId();}if(T&&T!=this._sFocusedAppointmentId){H.call(this,T);}else if(j._bPlanningCalendar&&O){O.focus();}else{this.fireLeaveRow({type:j.type});}}function M(i,j){var k=this.getIntervalType();var S=this._getStartDate();var O=new U(S.getTime());var P;var Q=false;var T=0;var V=0;if(q(j).hasClass("sapUiCalendarRowAppsSubInt")){Q=true;var W=q(q(j).parent()).children(".sapUiCalendarRowAppsSubInt");V=W.length;for(T=0;T<V;T++){var X=W[T];if(X==j){break;}}}switch(k){case m.Hour:O.setUTCHours(O.getUTCHours()+i);if(Q){O.setUTCMinutes(O.getUTCMinutes()+T*60/V);P=new U(O.getTime());P.setUTCMinutes(P.getUTCMinutes()+60/V);}else{P=new U(O.getTime());P.setUTCHours(P.getUTCHours()+1);}break;case m.Day:case m.Week:case m.OneMonth:O.setUTCDate(O.getUTCDate()+i);if(Q){O.setUTCHours(O.getUTCHours()+T*24/V);P=new U(O.getTime());P.setUTCHours(P.getUTCHours()+24/V);}else{P=new U(O.getTime());P.setUTCDate(P.getUTCDate()+1);}break;case m.Month:O.setUTCMonth(O.getUTCMonth()+i);if(Q){O.setUTCDate(O.getUTCDate()+T);P=new U(O.getTime());P.setUTCDate(P.getUTCDate()+1);}else{P=new U(O.getTime());P.setUTCMonth(P.getUTCMonth()+1);}break;default:throw new Error("Unknown IntervalType: "+k+"; "+this);}P.setUTCMilliseconds(P.getUTCMilliseconds()-1);O=a._createLocalDate(O,true);P=a._createLocalDate(P,true);this.fireIntervalSelect({startDate:O,endDate:P,subInterval:Q});}function N(i,j){var k=i.getStartDate()-j.getStartDate();if(k==0){k=j.getEndDate()-i.getEndDate();}return k;}return n;});
