/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/thirdparty/jquery','sap/ui/core/Control','sap/ui/core/ResizeHandler','./library','./DataSetSimpleViewRenderer','sap/base/Log',"sap/ui/model/ChangeReason"],function(q,C,R,l,D,L,a){"use strict";var b=C.extend("sap.ui.ux3.DataSetSimpleView",{metadata:{interfaces:["sap.ui.ux3.DataSetView"],library:"sap.ui.ux3",properties:{floating:{type:"boolean",group:"Misc",defaultValue:true},name:{type:"string",group:"Misc",defaultValue:"Name of this View"},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconHovered:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconSelected:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},responsive:{type:"boolean",group:"Misc",defaultValue:false},itemMinWidth:{type:"int",group:"Misc",defaultValue:0},initialItemCount:{type:"int",group:"Appearance",defaultValue:0},reloadItemCount:{type:"int",group:"Appearance",defaultValue:0},scrollArea:{type:"any",group:"Appearance",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null}},aggregations:{template:{type:"sap.ui.core.Control",multiple:false}}}});b.prototype.init=function(){this._oDataSet=this.getParent();this.items=[];this._bRendered=false;if(this.getInitialItemCount()>0&&this.getReloadItemCount()<=0){this.setReloadItemCount(this.getInitialItemCount());}this._bUsePagination=false;};b.prototype.exit=function(){if(this.sResizeListenerId){R.deregister(this.sResizeListenerId);this.sResizeListenerId=null;}};b.prototype.handleSelection=function(e){var d=this.getParent();var i=d.getItems(),s=d.getSelectedIndices();if(s.length>1){this._clearTextSelection();}q.each(i,function(c,f){if(d.isSelectedIndex(c)){f.$().addClass("sapUiUx3DSSVSelected");}else{f.$().removeClass("sapUiUx3DSSVSelected");}});};b.prototype._clearTextSelection=function(){if(window.getSelection){if(window.getSelection().empty){window.getSelection().empty();}else if(window.getSelection().removeAllRanges){window.getSelection().removeAllRanges();}}else if(document.selection&&document.selection.empty){try{document.selection.empty();}catch(e){}}};b.prototype.isItemSelected=function(i){var I=this.items.indexOf(i);if(I==-1){return false;}return this.getParent().isSelectedIndex(I);};b.prototype.initView=function(I){this.getParent().attachSelectionChanged(this.handleSelection,this);this.items=this.items.concat(I);for(var i=0;i<I.length;i++){var t=this.getTemplate().clone();I[i].setAggregation('_template',t,true);}};b.prototype.updateView=function(d){var i;if(!this.getDomRef()){for(i=0;i<d.length;i++){if(d[i].type==="delete"){d[i].item.destroy();}}return;}var r=sap.ui.getCore().createRenderManager(),c=this.items.length;for(i=0;i<d.length;i++){var I=d[i].item;var e=d[i].index;if(d[i].type==="insert"){var t=this.getTemplate().clone();I.setAggregation('_template',t,true);if(i==d.length-1&&c==0){var o={onAfterRendering:function(){this.calculateItemCounts();this.getParent().updateItems(a.Change);t.removeDelegate(o);}};t.addDelegate(o,false,this);}this.getRenderer().renderItem(r,this,I);r.flush(this.$()[0],false,e);this.items.splice(e,0,I);}else{this.items.splice(e,1);I.$().remove();I.destroy();}}if(d.length>0&&this.getFloating()&&this.getResponsive()){this._computeWidths(true);}r.destroy();};b.prototype.exitView=function(I){this.getParent().detachSelectionChanged(this.handleSelection,this);for(var i=0;i<I.length;i++){I[i].destroyAggregation("_template",true);}this.items=[];};b.prototype.initScrollArea=function(){var $=this.getScrollArea(),t=this;var s=function(e){t.getParent().updateItems(a.Change);};if(typeof $==='string'){$=q(document.getElementById($));}if(!$){$=this.$();}else if($.is('html')){$=q(document);}if(!this._bUsePagination){$.off('scroll',s);}else{$.on('scroll',s);}};b.prototype.checkScrollItems=function(){if(!this._bRendered){return;}var B=this.getParent().mBindingInfos["items"],$=this.getScrollArea(),o=B.binding,p=this.getParent(),A=0,f,s,c,S;if(p.getItems().length===o.getLength()){return A;}if(typeof $==='string'){$=q(document.getElementById($));}if(!$){$=this.$();}if(!$||$.length==0){return A;}s=$[0];c=s.clientHeight;S=s.scrollHeight;if($.is('html')){$=q(document);}if(c==S){f=c+this._iScrollTrigger;}else{f=c+this._iScrollTrigger+$.scrollTop();}if(f>0){var n=Math.floor(f/this._iRowHeight)*this._iItemsPerRow;var i=p.getItems().length;n=Math.ceil(n/this._iItemsPerRow)*this._iItemsPerRow;A=n-i;}return A;};b.prototype.getItemCount=function(){if(this._bUsePagination){var i=this.getParent().getItems().length,A=this.checkScrollItems();if(i==0){i+=this.getInitialItemCount();}else{i+=A;}return i;}else{return null;}};b.prototype.setInitialItemCount=function(v){this.setProperty("initialItemCount",v);this._bUsePagination=(v!=0);return this;};b.prototype.onBeforeRendering=function(){if(this.sResizeListenerId){R.deregister(this.sResizeListenerId);this.sResizeListenerId=null;}};b.prototype.onAfterRendering=function(){this._bRendered=true;this.initScrollArea();if((this.getFloating()&&this.getResponsive())||this._bUsePagination){this._height=-1;this._itemsPerRow=-1;this.onresize();this.sResizeListenerId=R.register(this.getDomRef(),q.proxy(this.onresize,this));}};b.prototype.onThemeChanged=function(){if(this._bRendered){this.calculateItemCounts();this.getParent().updateItems(a.Change);}};b.prototype.onresize=function(){if(!this.getDomRef()){if(this.sResizeListenerId){R.deregister(this.sResizeListenerId);this.sResizeListenerId=null;}return;}if(this.getFloating()&&this.getResponsive()){this._computeWidths();}if(this._bUsePagination&&this.items.length>0){this.calculateItemCounts();this.getParent().updateItems(a.Change);}};b.prototype.setTemplate=function(t){this.setAggregation("template",t,true);if(this.getParent()){this.getParent().updateItems();}return this;};b.prototype.calculateItemCounts=function(){if(this.getDomRef()&&sap.ui.getCore().isThemeApplied()){var $=this.$(),c=$.children().first();this._iItemsPerRow=Math.floor($.outerWidth(true)/c.outerWidth(true));this._iNewRows=Math.ceil(this.getReloadItemCount()/this._iItemsPerRow);this._iNewItems=this._iItemsPerRow*this._iNewRows;this._iRowHeight=c.outerHeight(true);this._iScrollTrigger=this._iNewRows*this._iRowHeight;}};b.prototype._computeWidths=function(i){var t=this.$();var I=Math.floor(t.width()/this.getItemMinWidth());var c=Math.floor(100/I);if(t.width()*c/100<this.getItemMinWidth()){I--;c=Math.floor(100/I);}if(i||this._height!=t.height()||this._itemsPerRow!=I){var d=-1;var e=this.getParent().getItems();var f,w;for(var j=0;j<e.length;j++){if(d==-1||d+1>I){d=0;f=100-(I*c);}var w=c;if(f>0){w++;f--;}e[j].$().css("width",w+"%");d++;}this._height=t.height();this._itemsPerRow=I;}};b.prototype.setScrollArea=function(s,S){if(typeof s!=='string'&&!(s instanceof q)){L.error('You can only pass a string (ID of scroll area DOM) or a jQuery object as scrollarea');}this.setProperty('scrollArea',s,S);return this;};return b;});
