//@ui5-bundle sap/uxap/library-preload.js
/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/uxap/AnchorBar',["sap/ui/thirdparty/jquery","sap/m/Button","sap/m/MenuButton","sap/m/library","sap/m/Toolbar","sap/ui/core/IconPool","sap/ui/core/Item","sap/ui/core/ResizeHandler","sap/ui/core/delegate/ScrollEnablement","sap/ui/layout/HorizontalLayout","sap/ui/Device","sap/ui/core/CustomData","sap/ui/core/Control","./HierarchicalSelect","./library","sap/uxap/AnchorBarRenderer","sap/base/Log","sap/ui/events/KeyCodes","sap/ui/events/F6Navigation"],function(q,B,M,m,T,I,a,R,S,H,D,C,b,c,l,A,L,K,F){"use strict";var d=m.SelectType;
var e=T.extend("sap.uxap.AnchorBar",{metadata:{library:"sap.uxap",properties:{showPopover:{type:"boolean",defaultValue:true},upperCase:{type:"boolean",defaultValue:false},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance"}},associations:{selectedButton:{type:"sap.m.Button",multiple:false}},aggregations:{_select:{type:"sap.uxap.HierarchicalSelect",multiple:false,visibility:"hidden"},_scrollArrowLeft:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_scrollArrowRight:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}}}});
e.prototype.init=function(){if(T.prototype.init){T.prototype.init.call(this);}this.addStyleClass("sapUxAPAnchorBar");this._oPressHandlers={};this._oSectionInfo={};this._oScroller=null;this._sSelectedKey=null;this._bRtl=sap.ui.getCore().getConfiguration().getRTL();this._bRtlScenario=this._bRtl&&!D.browser.msie;this._bHasButtonsBar=D.system.tablet||D.system.desktop;this.oLibraryResourceBundleOP=sap.ui.getCore().getLibraryResourceBundle("sap.uxap");this._oSelect=this._getHierarchicalSelect();if(this._bHasButtonsBar){this._oScroller=new S(this,this.getId()+"-scroll",{horizontal:true,vertical:false,nonTouchScrolling:true});this._iREMSize=0;this._iTolerance=0;this._iOffset=0;this._sResizeListenerId=undefined;}this.setDesign("Transparent");};
e.SCROLL_STEP=250;e.SCROLL_DURATION=500;e.DOM_CALC_DELAY=200;
e.prototype.setSelectedButton=function(o){var p=this.getSelectedButton(),P,s=this._oSelect.getItems(),h=s.length>0;if(typeof o==="string"){o=sap.ui.getCore().byId(o);}if(o){if(o.getId()===p){return this;}var f=o.data("sectionId");this._sSelectedKey=f;if(f&&h){this._oSelect.setSelectedKey(f);}if(this._bHasButtonsBar){P=sap.ui.getCore().byId(p);this._toggleSelectionStyleClass(P,false);this._toggleSelectionStyleClass(o,true);if(f){this.scrollToSection(f,e.SCROLL_DURATION);}this._setAnchorButtonsTabFocusValues(o);}this.setAssociation("selectedButton",o,true);}return this;};
e.prototype.setShowPopover=function(v,s){if(this.getShowPopover()===v){return this;}return this.setProperty("showPopover",v,true);};
e.prototype.setBackgroundDesign=function(s){var f=this.getBackgroundDesign(),$=this.$(),g="sapUxAPAnchorBar";if(f===s){return this;}this.setProperty("backgroundDesign",s,true);if($.length){$.removeClass(g+f);$.addClass(g+s);}return this;};
e.prototype.getSelectedSection=function(){var s=this.getSelectedButton();if(s&&(typeof(s)==="string")){s=sap.ui.getCore().byId(s);}if(s&&(s instanceof B)&&s.data("sectionId")){return sap.ui.getCore().byId(s.data("sectionId"));}return null;};
e.prototype.onBeforeRendering=function(){var s=this.getBackgroundDesign();if(this._bHasButtonsBar){this._iREMSize=parseInt(q("body").css("font-size"));this._iTolerance=this._iREMSize*1;this._iOffset=this._iREMSize*3;}if(T.prototype.onBeforeRendering){T.prototype.onBeforeRendering.call(this);}var f=this.getContent()||[],u=this.getUpperCase();this._oSelect.removeAllItems();this._oSelect.setUpperCase(u);this.toggleStyleClass("sapUxAPAnchorBarUpperCase",u);if(s){this.addStyleClass("sapUxAPAnchorBar"+s);}f.forEach(function(o){this._createSelectItem(o);},this);if(f.length>0&&this._sSelectedKey){this._oSelect.setSelectedKey(this._sSelectedKey);}};
e.prototype.addContent=function(o,i){o.addStyleClass("sapUxAPAnchorBarButton");o.removeAllAriaDescribedBy();if(this._bHasButtonsBar&&(o.data("secondLevel")===true||o.data("secondLevel")==="true")){o.attachPress(this._handleDirectScroll,this);}return this.addAggregation("content",o,i);};
e.prototype._createSelectItem=function(o){var i=o.data("secondLevel")===true||o.data("secondLevel")==="true";if(o.getText().trim()!=""&&(!i||o.data("bTitleVisible")===true)){var p=new a({key:o.data("sectionId"),text:o.getText(),customData:[new C({key:"secondLevel",value:o.data("secondLevel")})]});this._oSelect.addItem(p);}if(i){this.removeContent(o);o.destroy();}};
e.prototype._decorateSubMenuButtons=function(E){var f=E.getSource().getContent();f.forEach(function(o){o.$().attr("aria-controls",o.data("sectionId"));});};
e.prototype._toggleSelectionStyleClass=function(o,f){if(o){o.toggleStyleClass("sapUxAPAnchorBarButtonSelected",f);if(o instanceof M){o._getButtonControl().$().attr("aria-checked",f);}else{o.$().attr("aria-checked",f);}}};
e.prototype._handleDirectScroll=function(E){this._requestScrollToSection(E.getSource().data("sectionId"));};
e.prototype._requestScrollToSection=function(r){var o=sap.ui.getCore().byId(r),f=o.getParent();if(this.getParent()instanceof l.ObjectPageLayout){var n=r;if(o instanceof l.ObjectPageSubSection&&f instanceof l.ObjectPageSection){n=f.getId();}this.getParent().setDirectScrollingToSection(n);this.getParent().scrollToSection(o.getId(),null,0,true);}if(o instanceof l.ObjectPageSubSection&&f instanceof l.ObjectPageSection){f.setAssociation("selectedSubSection",o,true);}};
e.prototype._onSelectChange=function(E){var s=E.getParameter("selectedItem"),o;o=sap.ui.getCore().byId(s.getKey());if(o){this._requestScrollToSection(o.getId());}else{L.error("AnchorBar :: cannot find corresponding section",s.getKey());}};
e.prototype._getHierarchicalSelect=function(){if(!this.getAggregation('_select')){this.setAggregation('_select',new c({width:"100%",icon:"sap-icon://slim-arrow-down",tooltip:this.oLibraryResourceBundleOP.getText("ANCHOR_BAR_OVERFLOW"),change:q.proxy(this._onSelectChange,this)}));}return this.getAggregation('_select');};
e.prototype._createScrollArrow=function(f){var s,i,g,h,o,t=this,j=this.oLibraryResourceBundleOP.getText("TOOLTIP_OP_SCROLL_LEFT_ARROW"),k=this.oLibraryResourceBundleOP.getText("TOOLTIP_OP_SCROLL_RIGHT_ARROW");if(f){s=this.getId()+"-arrowScrollLeft";i="slim-arrow-left";g="anchorBarArrowLeft";h=this._bRtl?k:j;}else{s=this.getId()+"-arrowScrollRight";i="slim-arrow-right";g="anchorBarArrowRight";h=this._bRtl?j:k;}o=new B(s,{icon:I.getIconURI(i),type:"Transparent",press:function(E){E.preventDefault();t._handleScrollButtonTap(f);},tooltip:h});o.addEventDelegate({onAfterRendering:function(){if(sap.ui.getCore().getConfiguration().getTheme()!="sap_hcb"){this.$().attr("tabindex",-1);}},onThemeChanged:function(){if(sap.ui.getCore().getConfiguration().getTheme()=="sap_hcb"){this.$().removeAttr("tabindex");}else{this.$().attr("tabindex",-1);}}},o);return new H({content:[o]}).addStyleClass("anchorBarArrow").addStyleClass(g);};
e.prototype._getScrollArrowLeft=function(){var s=this.getAggregation("_scrollArrowLeft");if(s){return s;}else{s=this._createScrollArrow(true);this.setAggregation("_scrollArrowLeft",s);return s;}};
e.prototype._getScrollArrowRight=function(){var s=this.getAggregation("_scrollArrowRight");if(s){return s;}else{s=this._createScrollArrow(false);this.setAggregation("_scrollArrowRight",s);return s;}};
e.prototype._applyHierarchicalSelectMode=function(){if(this._sHierarchicalSelectMode===A._AnchorBarHierarchicalSelectMode.Icon){this.$().find(".sapUxAPAnchorBarScrollContainer").show();this._oSelect.setWidth("auto");this._oSelect.setAutoAdjustWidth(true);this._oSelect.setType(d.IconOnly);this._computeBarSectionsInfo();}else{this.$().find(".sapUxAPAnchorBarScrollContainer").hide();this._oSelect.setWidth("100%");this._oSelect.setAutoAdjustWidth(false);this._oSelect.setType(d.Default);}this.$().toggleClass("sapUxAPAnchorBarOverflow",this._sHierarchicalSelectMode===A._AnchorBarHierarchicalSelectMode.Icon);};
e.prototype._adjustSize=function(){var o=D.media.getCurrentRange(D.media.RANGESETS.SAP_STANDARD,this._getWidth(this)),n=l.Utilities.isPhoneScenario(o)?A._AnchorBarHierarchicalSelectMode.Text:A._AnchorBarHierarchicalSelectMode.Icon;if(n!==this._sHierarchicalSelectMode){this._sHierarchicalSelectMode=n;this._applyHierarchicalSelectMode();}if(this._sHierarchicalSelectMode===A._AnchorBarHierarchicalSelectMode.Icon){if(this._iMaxPosition<0){return;}var $=this.$(),f=$.find(".sapUxAPAnchorBarScrollContainer"),N,g,i;i=f.width();if(this._bRtlScenario){if(D.browser.firefox){g=Math.abs(f.scrollLeft())+i<(this._iMaxPosition-this._iTolerance);N=Math.abs(f.scrollLeft())>=this._iTolerance;}else{g=Math.abs(f.scrollLeft())>=this._iTolerance;N=Math.abs(f.scrollLeft())+i<(this._iMaxPosition-this._iTolerance);}}else{g=f.scrollLeft()+i<(this._iMaxPosition-this._iTolerance);N=f.scrollLeft()>=this._iTolerance;}L.debug("AnchorBar :: scrolled at "+f.scrollLeft(),"scrollBegin ["+(N?"true":"false")+"] scrollEnd ["+(g?"true":"false")+"]");$.toggleClass("sapUxAPAnchorBarScrollLeft",N);$.toggleClass("sapUxAPAnchorBarScrollRight",g);}};
e.prototype._handleScrollButtonTap=function(s){var i=((!this._bRtlScenario&&s)||(this._bRtlScenario&&!s))?-1:1;this._oScroller.scrollTo(this._iMaxPosition*i,0,e.SCROLL_DURATION*3);};
e.prototype.scrollToSection=function(i,f){if(this._bHasButtonsBar){var o=D.media.getCurrentRange(D.media.RANGESETS.SAP_STANDARD,this._getWidth(this)),f=f||e.SCROLL_DURATION,s;if(!l.Utilities.isPhoneScenario(o)&&this._oSectionInfo[i]){if(this._bRtlScenario&&D.browser.firefox){s=this._oSectionInfo[i].scrollLeft+this._iOffset;}else{s=this._oSectionInfo[i].scrollLeft-this._iOffset;if(s<0){s=0;}}L.debug("AnchorBar :: scrolling to section "+i+" of "+s);if(this._sCurrentScrollId!=i){this._sCurrentScrollId=i;if(this._iCurrentScrollTimeout){clearTimeout(this._iCurrentScrollTimeout);q(document.getElementById(this.getId()+"-scroll")).parent().stop(true,false);}this._iCurrentScrollTimeout=setTimeout(function(){this._sCurrentScrollId=undefined;this._iCurrentScrollTimeout=undefined;}.bind(this),f);this._oScroller.scrollTo(s,0,f);}}else{L.debug("AnchorBar :: no need to scroll to "+i);}}};
e.prototype.getScrollDelegate=function(){return this._oScroller;};
e.PAGEUP_AND_PAGEDOWN_JUMP_SIZE=5;
e.prototype.onsapright=function(E){E.preventDefault();var n;var f=this.getContent();f.forEach(function(o,i){if(E.target.id.indexOf(o.getId())>-1){n=i+1;return;}});if(n&&f[n]){f[n].focus();}else if(f[f.length-1]){f[f.length-1].focus();}};
e.prototype.onsapleft=function(E){E.preventDefault();var n;var f=this.getContent();f.forEach(function(o,i){if(E.target.id.indexOf(o.getId())>-1){n=i-1;return;}});if(n&&f[n]){f[n].focus();}else if(f[0]){f[0].focus();}};
e.prototype.onsapdown=function(E){E.preventDefault();};
e.prototype.onsapup=function(E){E.preventDefault();};
e.prototype.onsaphome=function(E){E.preventDefault();var f=this.getContent();f[0].focus();};
e.prototype.onsapend=function(E){E.preventDefault();var f=this.getContent();f[f.length-1].focus();};
e.prototype.onsappageup=function(E){this._handlePageUp(E);};
e.prototype.onsappagedown=function(E){this._handlePageDown(E);};
e.prototype._handlePageUp=function(E){E.preventDefault();var n;var f=this.getContent();f.forEach(function(o,i){if(E.target.id.indexOf(o.getId())>-1){n=i-(e.PAGEUP_AND_PAGEDOWN_JUMP_SIZE+1);return;}});if(n&&f[n]){f[n].focus();}else if(f[0]){f[0].focus();}};
e.prototype._handlePageDown=function(E){E.preventDefault();var n;var f=this.getContent();f.forEach(function(o,i){if(E.target.id.indexOf(o.getId())>-1){n=i+e.PAGEUP_AND_PAGEDOWN_JUMP_SIZE+1;return;}});if(n&&f[n]){f[n].focus();}else if(f[f.length-1]){f[f.length-1].focus();}};
e.prototype._setAnchorButtonsTabFocusValues=function(s){var f=this.getContent()||[],$,g='0',n='-1',t="tabIndex";f.forEach(function(o){$=o.getAggregation("_button")?o.getAggregation("_button").$():o.$();if(o.sId===(s&&s.sId)){$.attr(t,g);}else{$.attr(t,n);}});};
e.prototype.onsapskipforward=function(E){this._handleGroupNavigation(E,false);};
e.prototype._handleGroupNavigation=function(E,s){var o=q.Event("keydown"),f={},O=this.getParent(),u=O.getUseIconTabBar(),g=O.getSelectedSection(),h=O._getVisibleSections(),i=[this.getDomRef()],j=[];if(u){j=sap.ui.getCore().byId(g).getSubSections().map(function(k){return k.$().attr("tabindex",-1)[0];});i=i.concat(j);}else{h.forEach(function(k){j=k.getSubSections().map(function(n){return n.$().attr("tabindex",-1)[0];});i=i.concat(j);});}f.scope=i;E.preventDefault();this.$().focus();o.target=E.target;o.keyCode=K.F6;o.key="F6";o.shiftKey=s;F.handleF6GroupNavigation(o,f);};
e.prototype.onAfterRendering=function(){var s,h=this._getHeadeTitleAriaLabelText();if(T.prototype.onAfterRendering){T.prototype.onAfterRendering.call(this);}s=sap.ui.getCore().byId(this.getSelectedButton());this._setAnchorButtonsTabFocusValues(s);this._iMaxPosition=-1;this._sResizeListenerId=R.register(this,q.proxy(this._adjustSize,this));this.$().find(".sapUxAPAnchorBarScrollContainer").scroll(q.proxy(this._onScroll,this));if(h){this.$().attr("aria-label",h);}if(s){this.setSelectedButton(s);}if(this._bHasButtonsBar){setTimeout(function(){if(this._sHierarchicalSelectMode===A._AnchorBarHierarchicalSelectMode.Icon){this._computeBarSectionsInfo();}this._adjustSize();}.bind(this),e.DOM_CALC_DELAY);}};
e.prototype._onScroll=function(){if(!this._iCurrentSizeCheckTimeout){this._iCurrentSizeCheckTimeout=setTimeout(function(){this._iCurrentSizeCheckTimeout=undefined;this._adjustSize();}.bind(this),e.SCROLL_DURATION);}};
e.prototype._computeBarSectionsInfo=function(){this._iMaxPosition=0;var f=this.getContent()||[];f.forEach(this._computeNextSectionInfo,this);if(this._bRtlScenario&&(D.browser.webkit||D.browser.firefox)){f.forEach(this._adjustNextSectionInfo,this);this._oScroller.scrollTo(this._iMaxPosition,0,0);}};
e.prototype._computeNextSectionInfo=function(o){var f=o.isA("sap.m.MenuButton")?o._getButtonControl():o,s=o.hasStyleClass("sapUxAPAnchorBarButtonSelected");if(o.data("bHasSubMenu")){f.$().attr("aria-haspopup","true");}f.$().attr("aria-controls",o.data("sectionId")).attr("aria-checked",s);var w=o.$().outerWidth(true);this._oSectionInfo[o.data("sectionId")]={scrollLeft:this._iMaxPosition,width:w};this._iMaxPosition+=w;};
e.prototype._adjustNextSectionInfo=function(o){var s=this._oSectionInfo[o.data("sectionId")];if(D.browser.firefox){s.scrollLeft=-s.scrollLeft;}else{s.scrollLeft=this._iMaxPosition-s.scrollLeft-s.width;}};
e.prototype._resetControl=function(){this.destroyAggregation('content',true);return this;};
e.prototype._getHeadeTitleAriaLabelText=function(){var o=this.getParent();if(o.isA("sap.uxap.ObjectPageLayout")){return o._getAriaLabelText("NAVTOOLBAR");}return null;};
e.prototype.enhanceAccessibilityState=function(E,f){var o=this.getContent(),i=o.indexOf(E);if(i!==-1){f.role="menuitemradio";f.roledescription=this.oLibraryResourceBundleOP.getText("ANCHOR_BAR_MENUITEM");f.setsize=o.length;f.posinset=i+1;}};
e.prototype.exit=function(){if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}if(this.oLibraryResourceBundleOP){this.oLibraryResourceBundleOP=null;}};
e.prototype._getWidth=function(o){var f=o.getDomRef();return!(o instanceof b)?0:(f&&f.offsetWidth)||0;};
return e;});
sap.ui.predefine('sap/uxap/AnchorBarRenderer',["sap/m/ToolbarRenderer","sap/ui/core/Renderer","sap/m/BarInPageEnabler","./library"],function(T,R,B,l){"use strict";var A=R.extend(T);var _=A._AnchorBarHierarchicalSelectMode={Icon:"icon",Text:"text"};
A.renderBarContent=function(r,t){if(t._bHasButtonsBar){r.renderControl(t._getScrollArrowLeft());r.write("<div");r.writeAttributeEscaped("id",t.getId()+"-scrollContainer");r.writeAttributeEscaped("aria-label",sap.ui.getCore().getLibraryResourceBundle("sap.uxap").getText("ANCHOR_BAR_LABEL"));r.addClass("sapUxAPAnchorBarScrollContainer");r.writeClasses();r.write(">");r.write("<div");r.writeAttributeEscaped("id",t.getId()+"-scroll");r.writeAttributeEscaped("role","menubar");r.write(">");A.renderBarItems(r,t);r.write("</div>");r.write("</div>");r.renderControl(t._getScrollArrowRight());}B.addChildClassTo(t._oSelect,t);r.renderControl(t._oSelect);};
A.renderBarItems=function(r,t){var s=t.getSelectedButton();t.getContent().forEach(function(c){B.addChildClassTo(c,t);if(c.getId()===s){c.addStyleClass("sapUxAPAnchorBarButtonSelected");}r.renderControl(c);});};
A.decorateRootElement=function(r,t){T.decorateRootElement.apply(this,arguments);if(t._sHierarchicalSelectMode===_.Icon){r.addClass("sapUxAPAnchorBarOverflow");}};
return A;},true);
sap.ui.predefine('sap/uxap/BlockBase',["sap/ui/thirdparty/jquery","sap/ui/core/Control","sap/ui/core/CustomData","sap/ui/core/mvc/View","./BlockBaseMetadata","sap/ui/model/Context","sap/ui/Device","sap/ui/layout/form/ColumnLayout","./library","sap/ui/core/Component","sap/ui/layout/library","sap/base/Log"],function(q,C,a,b,B,c,D,d,l,e,f,L){"use strict";var S=f.form.SimpleFormLayout;var g=l.BlockBaseFormAdjustment;
var h=C.extend("sap.uxap.BlockBase",{
metadata:{designtime:"sap/uxap/designtime/BlockBase.designtime",library:"sap.uxap",properties:{"mode":{type:"string",group:"Appearance"},"visible":{type:"boolean",group:"Appearance",defaultValue:true},"columnLayout":{type:"sap.uxap.BlockBaseColumnLayout",group:"Behavior",defaultValue:"auto"},"formAdjustment":{type:"sap.uxap.BlockBaseFormAdjustment",group:"Behavior",defaultValue:g.BlockColumns},"showSubSectionMore":{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"mappings",aggregations:{"mappings":{type:"sap.uxap.ModelMapping",multiple:true,singularName:"mapping"},"_views":{type:"sap.ui.core.Control",multiple:true,singularName:"view",visibility:"hidden"}},associations:{"selectedView":{type:"sap.ui.core.Control",multiple:false}},events:{"viewInit":{parameters:{view:{type:"sap.ui.core.mvc.View"}}}},views:{}},
renderer:"sap.uxap.BlockBaseRenderer"
},B);
h.prototype.init=function(){if(!this.getMetadata().hasViews()){this.getMetadata().setView("defaultXML",{viewName:this.getMetadata().getName(),type:"XML"});}this._oMappingApplied={};this._bLazyLoading=false;this._bConnected=false;this._oUpdatedModels={};this._oParentObjectPageSubSection=null;};
h.prototype.onBeforeRendering=function(){var p;this._applyMapping();if(!this.getMode()||this.getMode()===""){if(this.getMetadata().getView("defaultXML")){this.setMode("defaultXML");}else{L.error("BlockBase ::: there is no mode defined for rendering "+this.getMetadata().getName()+". You can either set a default mode on the block metadata or set the mode property before rendering the block.");}}this._applyFormAdjustment();p=this._getObjectPageLayout();this._bLazyLoading=p&&(p.getEnableLazyLoading()||p.getUseIconTabBar());};
h.prototype.onAfterRendering=function(){var p=this._getObjectPageLayout();if(p){p._requestAdjustLayout();}};
h.prototype.setParent=function(p,A,s){C.prototype.setParent.call(this,p,A,s);if(p instanceof l.ObjectPageSubSection){this._bLazyLoading=true;this._oParentObjectPageSubSection=p;}};
h.prototype.setModel=function(m,n){this._applyMapping(n);return C.prototype.setModel.call(this,m,n);};
h.prototype._applyMapping=function(){if(this._shouldLazyLoad()){L.debug("BlockBase ::: Ignoring the _applyMapping as the block is not connected");}else{this.getMappings().forEach(function(m,i){var M,o,I=m.getInternalModelName(),E=m.getExternalPath(),s=m.getExternalModelName(),p;if(E){if(I==""||E==""){throw new Error("BlockBase :: incorrect mapping, one of the modelMapping property is empty");}M=this.getModel(s);if(!M){return;}p=M.resolve(E,this.getBindingContext(s));o=this.getBindingContext(I);if(!this._isMappingApplied(I)||(this.getModel(I)!==this.getModel(s))||(o&&(o.getPath()!==p))){L.info("BlockBase :: mapping external model "+s+" to "+I);this._oMappingApplied[I]=true;C.prototype.setModel.call(this,M,I);this.setBindingContext(new c(M,p),I);}}},this);}};
h.prototype._isMappingApplied=function(i){return this.getModel(i)&&this._oMappingApplied[i];};
h.prototype.propagateProperties=function(n){if(this._shouldLazyLoad()&&!this._oUpdatedModels.hasOwnProperty(n)){this._oUpdatedModels[n]=true;}else{this._applyMapping(n);}return C.prototype.propagateProperties.call(this,n);};
h.prototype.getSupportedModes=function(){var s=q.extend({},this.getMetadata().getViews());for(var k in s){s[k]=k;}return s;};
h.prototype.setMode=function(m){m=this._validateMode(m);if(this.getMode()!==m){this.setProperty("mode",m,false);if(!this._shouldLazyLoad()){this._initView(m);}}return this;};
h.prototype.setColumnLayout=function(s){if(this._oParentObjectPageSubSection){this._oParentObjectPageSubSection.invalidate();}this.setProperty("columnLayout",s);};
h.prototype.clone=function(){var A=-1,s=this.getAssociation("selectedView"),v=this.getAggregation("_views")||[];if(s){v.forEach(function(V,i){if(V.getId()===s){A=i;}return A<0;});}var n=C.prototype.clone.call(this);if(A>=0){n.setAssociation("selectedView",n.getAggregation("_views")[A]);}return n;};
h.prototype._validateMode=function(m){this.validateProperty("mode",m);if(!this.getMetadata().getView(m)){var s=this.getMetadata()._sClassName||this.getId();if(this.getMetadata().getView("defaultXML")){L.warning("BlockBase :: no view defined for block "+s+" for mode "+m+", loading defaultXML instead");m="defaultXML";}else{throw new Error("BlockBase :: no view defined for block "+s+" for mode "+m);}}return m;};
h.prototype._getSelectedViewContent=function(){var v=null,s,V;s=this.getAssociation("selectedView");V=this.getAggregation("_views");if(V){for(var i=0;!v&&i<V.length;i++){if(V[i].getId()===s){v=V[i];}}}return v;};
h.prototype.createView=function(p,m){var o,i;i=function(){p.id=this.getId()+"-"+m;return b.create(p);}.bind(this);o=e.getOwnerComponentFor(this);if(o){return o.runAsOwner(i);}else{return i();}};
h.prototype._afterViewInstantiated=function(v,m){var o=v.getController();if(v){if(o){o.oParentBlock=this;}v.addCustomData(new a({"key":"layoutMode","value":m}));this.addAggregation("_views",v);this.fireEvent("viewInit",{view:v});this.setAssociation("selectedView",v);this._notifyForLoadingInMode(o,v,m);}else{throw new Error("BlockBase :: no view defined in metadata.views for mode "+m);}};
h.prototype._notifyForLoadingInMode=function(o,v,m){if(o&&typeof o.onParentBlockModeChange==="function"){o.onParentBlockModeChange(m);}else{L.info("BlockBase ::: could not notify "+v.sViewName+" of loading in mode "+m+": missing controller onParentBlockModeChange method");}};
h.prototype._initView=function(m){var v,V=this.getAggregation("_views")||[];V.forEach(function(o){if(o.data("layoutMode")===m){v=o;}});if(v){this.setAssociation("selectedView",v);this._notifyForLoadingInMode(v.getController(),v,m);return;}this._initNewView(m);};
h.prototype._initNewView=function(m){var v=this._getSelectedViewContent(),p=this.getMetadata().getView(m);if(!v||p.viewName!=v.getViewName()){v=this.createView(p,m).then(function(V){this._afterViewInstantiated(V,m);}.bind(this));}};
h.FORM_ADUSTMENT_OFFSET=16;h._FORM_ADJUSTMENT_CONST={labelSpan:{L:12},emptySpan:{L:0},columns:{XL:1,L:1,M:1}};h._PARENT_GRID_SIZE=12;
h.prototype._computeFormAdjustmentFields=function(v,F,p){if(v&&F&&p){return F===g.BlockColumns?q.extend({},h._FORM_ADJUSTMENT_CONST,{columns:p}):h._FORM_ADJUSTMENT_CONST;}};
h.prototype._applyFormAdjustment=function(){var F=this.getFormAdjustment(),v=this._getSelectedViewContent(),p=this._oParentObjectPageSubSection,o,i,j;if(F&&(F!==g.None)&&v&&p){var P=p._oLayoutConfig;v.getContent().forEach(function(I){if(I.getMetadata().getName()==="sap.ui.layout.form.SimpleForm"){I.setLayout(S.ColumnLayout);if(!o){o=this._computeFormAdjustmentFields(v,F,P);}j=I.getAggregation("form").getLayout();j._iBreakPointTablet-=h.FORM_ADUSTMENT_OFFSET;j._iBreakPointDesktop-=h.FORM_ADUSTMENT_OFFSET;j._iBreakPointLargeDesktop-=h.FORM_ADUSTMENT_OFFSET;I.setLabelSpanL(o.labelSpan.L);I.setEmptySpanL(o.emptySpan.L);this._applyFormAdjustmentFields(o,I);I.setWidth("100%");}else if(I.getMetadata().getName()==="sap.ui.layout.form.Form"){j=I.getLayout();if(j&&j.getMetadata().getName()==="sap.ui.layout.form.ColumnLayout"){i=j;}else{i=new d();I.setLayout(i);}if(!o){o=this._computeFormAdjustmentFields(v,F,P);}i._iBreakPointTablet-=h.FORM_ADUSTMENT_OFFSET;i._iBreakPointDesktop-=h.FORM_ADUSTMENT_OFFSET;i._iBreakPointLargeDesktop-=h.FORM_ADUSTMENT_OFFSET;i.setLabelCellsLarge(o.labelSpan.L);i.setEmptyCellsLarge(o.emptySpan.L);this._applyFormAdjustmentFields(o,i);I.setWidth("100%");}},this);}};
h.prototype._applyFormAdjustmentFields=function(F,o){o.setColumnsXL(F.columns.XL);o.setColumnsL(F.columns.L);o.setColumnsM(F.columns.M);};
h.prototype._getObjectPageLayout=function(){return l.Utilities.getClosestOPL(this);};
h.prototype.setVisible=function(v,s){var p=this._getObjectPageLayout();this.setProperty("visible",v,s);p&&p._requestAdjustLayoutAndUxRules();return this;};
h.prototype.setShowSubSectionMore=function(v,i){if(v!=this.getShowSubSectionMore()){this.setProperty("showSubSectionMore",v,true);if(this._oParentObjectPageSubSection){this._oParentObjectPageSubSection.refreshSeeMoreVisibility();}}return this;};
h.prototype.connectToModels=function(){if(!this._bConnected){L.debug("BlockBase :: Connecting block to the UI5 model tree");this._bConnected=true;if(this._bLazyLoading){var m=this.getMode();m&&this._initView(m);}this.invalidate();}};
h.prototype._allowPropagationToLoadedViews=function(A){if(!this._bConnected){return;}this.mSkipPropagation._views=!A;};
h.prototype.updateBindingContext=function(s,i,m,u){if(!this._shouldLazyLoad()){return C.prototype.updateBindingContext.call(this,s,i,m,u);}else{L.debug("BlockBase ::: Ignoring the updateBindingContext as the block is not visible for now in the ObjectPageLayout");}};
h.prototype.updateBindings=function(u,m){if(!this._shouldLazyLoad()){return C.prototype.updateBindings.call(this,u,m);}else{L.debug("BlockBase ::: Ignoring the updateBindingContext as the block is not visible for now in the ObjectPageLayout");}};
h.prototype._shouldLazyLoad=function(){return!!this._oParentObjectPageSubSection&&this._bLazyLoading&&!this._bConnected;};
return h;});
sap.ui.predefine('sap/uxap/BlockBaseMetadata',["sap/ui/thirdparty/jquery","sap/ui/core/ElementMetadata","sap/base/Log"],function(q,E,L){"use strict";var B=function(c,C){E.apply(this,arguments);this._mViews=C.metadata.views||{};};B.prototype=Object.create(E.prototype);
B.prototype.applySettings=function(c){var r=c.hasOwnProperty("renderer")?(c.renderer||""):undefined;E.prototype.applySettings.call(this,c);if(r==null){this._sRendererName=null;}};
B.prototype.getRendererName=function(){if(!this._sBlockRenderer){this._sBlockRenderer=this._resolveRendererName();L.debug("BlockBaseMetadata :: "+this.getName()+" is renderer with "+this._sBlockRenderer);}return this._sBlockRenderer;};
B.prototype._resolveRendererName=function(){var c=E.prototype.getRendererName.call(this);if(c==null){var p=this.getParent();if(p){c=B.prototype._resolveRendererName.apply(p);}else{throw new Error("BlockBaseMetadata :: no renderer found for "+this.getName());}}return c;};
B.prototype.getView=function(v){return this._mViews[v];};
B.prototype.getViews=function(){return this._mViews;};
B.prototype.setView=function(v,V){this._mViews[v]=V;return this;};
B.prototype.hasViews=function(){return!q.isEmptyObject(this._mViews);};
return B;},true);
sap.ui.predefine('sap/uxap/BlockBaseRenderer',function(){"use strict";var B={};
B.render=function(r,c){if(!c.getVisible()){return;}r.write("<div");r.writeControlData(c);if(c._getSelectedViewContent()){r.addClass('sapUxAPBlockBase');r.addClass("sapUxAPBlockBase"+c.getMode());}else{var C=c.getMetadata().getName().split(".").pop();r.addClass(C+c.getMode());}r.writeClasses();r.write(">");if(c._getSelectedViewContent()){r.renderControl(c._getSelectedViewContent());}r.write("</div>");};
return B;},true);
sap.ui.predefine('sap/uxap/BreadCrumbs',["sap/m/Link","sap/m/Select","sap/ui/core/Control","sap/ui/core/ResizeHandler","sap/ui/core/delegate/ItemNavigation","sap/ui/core/Item","sap/ui/core/Icon","sap/ui/Device","./library","sap/ui/core/InvisibleText","./BreadCrumbsRenderer","sap/ui/thirdparty/jquery"],function(L,S,C,R,I,a,b,D,l,c,B,q){"use strict";
var d=C.extend("sap.uxap.BreadCrumbs",{metadata:{library:"sap.uxap",properties:{showCurrentLocation:{type:"boolean",group:"Behavior",defaultValue:true}},defaultAggregation:"links",aggregations:{links:{type:"sap.m.Link",multiple:true,singularName:"link"},currentLocation:{type:"sap.m.Text",multiple:false},_tubeIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_overflowSelect:{type:"sap.m.Select",multiple:false,visibility:"hidden"}}}});
d.PAGEUP_AND_PAGEDOWN_JUMP_SIZE=5;
d.prototype.init=function(){this._iREMSize=parseInt(q("body").css("font-size"));this._iContainerMaxHeight=this._iREMSize*2;};
d.prototype.onBeforeRendering=function(){this._bOnPhone=D.system.phone;this._resetControl();};
d.prototype.onAfterRendering=function(){this._handleInitialModeSelection();};
d.prototype._handleInitialModeSelection=function(){if(this._bOnPhone){this._setSelectVisible(true);return this;}this._configureKeyboardHandling();if(!this._iContainerHeight){this._iContainerHeight=this.$().outerHeight();}if(this._iContainerHeight>this._iContainerMaxHeight){this._toggleOverflowMode(true);return this;}this._sResizeListenerId=R.register(this,this._handleScreenResize.bind(this));return this;};
d.prototype._toggleOverflowMode=function(u){if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);}this._setSelectVisible(u);this._setBreadcrumbsVisible(!u);this._sResizeListenerId=R.register(this,this._handleScreenResize.bind(this));return this;};
d.prototype._getTubeIcon=function(){if(!this.getAggregation("_tubeIcon")){this.setAggregation("_tubeIcon",new b({"src":"sap-icon://slim-arrow-right","color":"#bfbfbf","size":"1rem","useIconTooltip":false}).addStyleClass("sapUxAPTubeIcon"));}return this.getAggregation("_tubeIcon");};
d.prototype._getOverflowSelect=function(){var o,s;if(!this.getAggregation("_overflowSelect")){s=this.getLinks().reverse()||[];s.unshift(this.getCurrentLocation());o=new S({items:s.map(this._createSelectItem),autoAdjustWidth:true});o.attachChange(this._overflowSelectChangeHandler);this.setAggregation("_overflowSelect",o);}return this.getAggregation("_overflowSelect");};
d.prototype._createSelectItem=function(i){return new a({key:i.getId(),text:i.getText()});};
d.prototype._overflowSelectChangeHandler=function(e){var s=e.getParameter("selectedItem").getKey(),o=sap.ui.getCore().byId(s),f,g;if(o instanceof L){f=o.getHref();o.firePress();if(f){g=o.getTarget();if(g){window.open(f,g);}else{window.location.href=f;}}}return this;};
d.prototype._handleScreenResize=function(e){var s=this._shouldOverflow(),u=this._getUsingOverflowSelect();if(s&&!u){this._toggleOverflowMode(true);}else if(!s&&u){this._toggleOverflowMode(false);}return this;};
d.prototype._shouldOverflow=function(){var $=this._getBreadcrumbsAsJQueryObject(),s,u=this._getUsingOverflowSelect();if(u){this._setBreadcrumbsVisible(true);}$.addClass("sapUxAPInvisible");s=$.outerHeight()>this._iContainerMaxHeight;$.removeClass("sapUxAPInvisible");if(u){this._setBreadcrumbsVisible(false);}return s;};
d.prototype._getBreadcrumbsAsJQueryObject=function(){if(!this._$breadcrumbs){this._$breadcurmbs=this.$("breadcrumbs");}return this._$breadcurmbs;};
d.prototype._getOverflowSelectAsJQueryObject=function(){if(!this._$select){this._$select=this.$("select");}return this._$select;};
d.prototype._setBreadcrumbsVisible=function(v){var $=this.$(),e=this._getBreadcrumbsAsJQueryObject(),f="sapUxAPFullWidth",s="sapUiHidden";if(v){e.removeClass(s);$.removeClass(f);}else{e.addClass(s);$.addClass(f);}return $;};
d.prototype._setSelectVisible=function(v){var $=this._getOverflowSelectAsJQueryObject(),s="sapUiHidden";if(v){$.removeClass(s);}else{$.addClass(s);}return this;};
d.prototype._resetControl=function(){this._iContainerHeight=null;this._$select=null;this._$breadcrumbs=null;this.setAggregation("_overflowSelect",null,true);if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);}return this;};
d.prototype._getAriaLabelledBy=function(){if(!this._oAriaLabelledBy){d.prototype._oAriaLabelledBy=new c({text:sap.ui.getCore().getLibraryResourceBundle("sap.uxap").getText("BREADCRUMB_TRAIL_LABEL")}).toStatic();}return this._oAriaLabelledBy;};
d.prototype._getItemNavigation=function(){if(!this._ItemNavigation){this._ItemNavigation=new I();}return this._ItemNavigation;};
d.prototype._getItemsToNavigate=function(){var i=this.getLinks(),o=this.getCurrentLocation(),s=this.getShowCurrentLocation();if(s&&o){i.push(o);}return i;};
d.prototype._configureKeyboardHandling=function(){var i=this._getItemNavigation(),h=this._getBreadcrumbsAsJQueryObject()[0],s=-1,e=this._getItemsToNavigate(),n=[];e.forEach(function(o){o.$().attr("tabindex","-1");n.push(o.getDomRef());});this.addDelegate(i);i.setCycling(false);i.setRootDomRef(h);i.setItemDomRefs(n);i.setSelectedIndex(s);this._getBreadcrumbsAsJQueryObject().attr("tabindex","-1");e[0].$().attr("tabindex","0");return this;};
d.prototype.onsappageup=function(e){this._handlePageKeys(e,false);};
d.prototype.onsappagedown=function(e){this._handlePageKeys(e,true);};
d.prototype._handlePageKeys=function(e,m){var n,f=this._getItemsToNavigate(),E=0,i=m?f.length-1:0;e.preventDefault();f.some(function(o,g){if(o.getId()===e.target.id){E=g;return true;}});if(m){n=E+d.PAGEUP_AND_PAGEDOWN_JUMP_SIZE;}else{n=E-d.PAGEUP_AND_PAGEDOWN_JUMP_SIZE;}if(n&&f[n]){f[n].focus();}else if(f[i]){f[i].focus();}};
d.prototype._getUsingOverflowSelect=function(){return!this._getOverflowSelectAsJQueryObject().hasClass("sapUiHidden");};
d.prototype.exit=function(){if(this._ItemNavigation){this.removeDelegate(this._ItemNavigation);this._ItemNavigation.destroy();this._ItemNavigation=null;}this._resetControl();};
return d;});
sap.ui.predefine('sap/uxap/BreadCrumbsRenderer',function(){"use strict";var B={};
B.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapUxAPBreadCrumbs");r.writeClasses();r.writeAttribute("role","navigation");r.writeAttributeEscaped("aria-labelledby",c._getAriaLabelledBy().getId());r.write(">");this._renderOverflowSelect(r,c);if(!c._bOnPhone){this._renderBreadcrumbTrail(r,c);}r.write("</div>");};
B._renderBreadcrumbTrail=function(r,c){var l=c.getLinks(),C=c.getCurrentLocation(),t=c._getTubeIcon(),s=c.getShowCurrentLocation();r.write("<ul id='"+c.getId()+"-breadcrumbs'");r.write(">");l.forEach(function(L){r.write("<li>");r.renderControl(L);r.renderControl(t);r.write("</li>");});if(s){r.write("<li>");r.renderControl(C);r.write("</li>");}r.write("</ul>");};
B._renderOverflowSelect=function(r,c){var t=c._getTubeIcon();r.write("<div id='"+c.getId()+"-select'");r.addClass("sapUiHidden");r.writeClasses();r.write(">");r.write('<span class="sapUxAPBreadCrumbsDots">...</span>');r.renderControl(t);r.renderControl(c._getOverflowSelect());r.write("</div>");};
return B;},true);
sap.ui.predefine('sap/uxap/HierarchicalSelect',["sap/m/Select","sap/ui/Device","sap/ui/thirdparty/jquery","./library","./HierarchicalSelectRenderer","sap/ui/thirdparty/jqueryui/jquery-ui-position"],function(S,D,q,l,H){"use strict";
var a=S.extend("sap.uxap.HierarchicalSelect",{metadata:{library:"sap.uxap",properties:{upperCase:{type:"boolean",group:"Appearance",defaultValue:false}}}});
a.POPOVER_MIN_WIDTH_REM=11;
a.prototype.onAfterRendering=function(){S.prototype.onAfterRendering.apply(this,arguments);};
a.prototype.onAfterRenderingPicker=function(){S.prototype.onAfterRenderingPicker.call(this);var i=this.getItems()||[];i.forEach(function(I){var c=(I.data("secondLevel")===true)?"sapUxAPHierarchicalSelectSecondLevel":"sapUxAPHierarchicalSelectFirstLevel";I.$().addClass(c);},this);};
a.prototype.setUpperCase=function(v,s){this.setProperty("upperCase",v,s);this.toggleStyleClass("sapUxAPHierarchicalSelectUpperCase",v);var p=this.getAggregation("picker");if(p){p.toggleStyleClass("sapMSltPickerFirstLevelUpperCase",v);if(!s){p.invalidate();}}return this;};
a.prototype.onsapenter=S.prototype.onsapspace;["onsapup","onsappageup","onsappagedown","onsaphome","onsapend"].forEach(function(n){a.prototype[n]=function(e){S.prototype[n].call(this,e);e.stopPropagation();};});
a.prototype._createDialog=function(){var d=S.prototype._createDialog.call(this),c=d.getCustomHeader();if(c){c.addStyleClass("sapUxAPHierarchicalSelect");}return d;};
a.prototype._decoratePopover=function(p){S.prototype._decoratePopover.call(this,p);p._adaptPositionParams=function(){this._marginTop=0;this._marginLeft=0;this._marginRight=0;this._marginBottom=0;this._arrowOffset=0;this._offsets=["0 0","0 0","0 0","0 0"];this._myPositions=["end bottom","end center","end top","begin center"];this._atPositions=["end top","end center","end bottom","begin center"];};if(D.system.tablet||D.system.desktop){var r=q.position.scrollbarWidth();if(r>0){p.setOffsetX(r);}}};
a.prototype._onAfterRenderingPopover=function(){var p=this.getPicker(),P=p.getDomRef("cont"),m=P.style.minWidth;if(m.endsWith("rem")){m=m.substring(0,m.length-3);var M=parseFloat(m);if(M<a.POPOVER_MIN_WIDTH_REM&&P){P.style.minWidth=a.POPOVER_MIN_WIDTH_REM+"rem";}}};
return a;});
sap.ui.predefine('sap/uxap/HierarchicalSelectRenderer',["sap/m/SelectRenderer","sap/ui/core/Renderer"],function(S,R){"use strict";var H=R.extend(S);H.apiVersion=2;
H.addClass=function(r){r.class("sapUxAPHierarchicalSelect");};
return H;},true);
sap.ui.predefine('sap/uxap/LazyLoading',["sap/ui/thirdparty/jquery","sap/ui/Device","sap/ui/base/Metadata","./ObjectPageSubSection","./library","sap/base/Log"],function(q,D,M,O,l,L){"use strict";var a=M.createClass("sap.uxap._helpers.LazyLoading",{constructor:function(o){this._oObjectPageLayout=o;this._$html=q("html");this._iPreviousScrollTop=0;this._iScrollProgress=0;this._iPreviousScrollTimestamp=0;this._sLazyLoadingTimer=null;this._oPrevSubSectionsInView={};this.setLazyLoadingParameters();}});
a.prototype.setLazyLoadingParameters=function(){this.LAZY_LOADING_DELAY=200;this.LAZY_LOADING_EXTRA_PAGE_SIZE=0.5;this.LAZY_LOADING_EXTRA_SUBSECTION=this.LAZY_LOADING_DELAY*5;if(this._isPhone()){this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD={"FirstRendering":1,"ScrollToSection":1};}else if(this._isTablet()){this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD={"FirstRendering":2,"ScrollToSection":1};}else if(this._isTabletSize()){this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD={"FirstRendering":2,"ScrollToSection":2};}else{this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD={"FirstRendering":3,"ScrollToSection":3};}this.LAZY_LOADING_FAST_SCROLLING_THRESHOLD=5;};
a.prototype._triggerVisibleSubSectionsEvents=function(){this._oPrevSubSectionsInView={};this._oObjectPageLayout._requestAdjustLayout(true);this.doLazyLoading();};
a.prototype.lazyLoadDuringScroll=function(i,s,t,p){var P,d,f=false;if(i){if(this._sLazyLoadingTimer){clearTimeout(this._sLazyLoadingTimer);}this._sLazyLoadingTimer=null;this.doLazyLoading();return;}this._iScrollProgress=s-this._iPreviousScrollTop;P=Math.round(Math.abs(this._iScrollProgress)/p*100);if(P>=this.LAZY_LOADING_FAST_SCROLLING_THRESHOLD){f=true;}this._iPreviousScrollTop=s;this._iPreviousScrollTimestamp=t||0;d=(s===0)?0:this.LAZY_LOADING_DELAY;if(f&&this._sLazyLoadingTimer){L.debug("ObjectPageLayout :: lazyLoading","delayed by "+d+" ms because of fast scroll");clearTimeout(this._sLazyLoadingTimer);this._sLazyLoadingTimer=null;}if(!this._sLazyLoadingTimer){this._sLazyLoadingTimer=setTimeout(this.doLazyLoading.bind(this),d);}};
a.prototype.doLazyLoading=function(){var h=this._oObjectPageLayout._getHeightRelatedParameters(),i=this._oObjectPageLayout.getUseIconTabBar(),s=sap.ui.getCore().byId(this._oObjectPageLayout.getSelectedSection()),S=this._oObjectPageLayout._oSectionInfo,b,c,p,d=this._iPreviousScrollTop>=(h.iHeaderContentHeight),e,E=-1,o={},f={},t,g,j;p=(h.iScreenHeight-(d?h.iAnchorBarHeight:0)-(d?h.iHeaderTitleHeightStickied:0));b=h.iScrollTop;t=Date.now()-this._iPreviousScrollTimestamp;g=(t<(this.LAZY_LOADING_DELAY/2))&&(Math.abs(this._iScrollProgress)>5);if(g){if(this._iScrollProgress>=0){j=Math.round(Math.min(this._iScrollProgress*20,p/2));}else{j=-1*Math.round(Math.min(Math.abs(this._iScrollProgress)*20,p/2));}b+=j;L.debug("ObjectPageLayout :: lazyLoading","Visible page shifted from : "+j);}c=b+p;b+=16;q.each(S,q.proxy(function(I,k){if(!k.isSection&&k.sectionReference.getParent()&&k.sectionReference.getParent().getVisible()){if(i&&s&&s.indexOfSubSection(k.sectionReference)<0){return;}if(k.positionTop<=c&&b<k.positionBottom-1){f[I]=I;if(!k.loaded){o[I]=I;}}else if(!k.loaded&&k.positionTop>c&&k.positionTop<c+p*this.LAZY_LOADING_EXTRA_PAGE_SIZE&&(E==-1||k.positionTop<E)){E=k.positionTop;e=I;}}},this));if(E!=-1&&q.isEmptyObject(o)){L.debug("ObjectPageLayout :: lazyLoading","extra section added : "+e);o[e]=e;}q.each(o,q.proxy(function(k,m){L.debug("ObjectPageLayout :: lazyLoading","connecting "+m);sap.ui.getCore().byId(m).connectToModels();S[m].loaded=true;},this));q.each(f,q.proxy(function(k,m){if(!this._oPrevSubSectionsInView[k]){L.debug("ObjectPageLayout :: lazyLoading","subSectionEnteredViewPort "+m);this._oObjectPageLayout.fireEvent("subSectionEnteredViewPort",{subSection:sap.ui.getCore().byId(m)});}},this));this._oPrevSubSectionsInView=f;if(g){this._sLazyLoadingTimer=setTimeout(this.doLazyLoading.bind(this),this.LAZY_LOADING_DELAY);}else{if(E){this._sLazyLoadingTimer=setTimeout(this.doLazyLoading.bind(this),this.LAZY_LOADING_EXTRA_SUBSECTION);}else{this._sLazyLoadingTimer=null;}}};
a.prototype.getSubsectionsToPreload=function(A,i){var s,t;if(i){s=this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD.ScrollToSection;t=false;}else{s=this.NUMBER_OF_SUBSECTIONS_TO_PRELOAD.FirstRendering;t=true;}var S=[];A.some(function(o){if(!t&&i){t=o.getId()==i;}if(t&&o instanceof O){if(o.getVisible()&&o._getInternalVisible()){S.push(o);s--;}}return s<=0;});return S;};
a.prototype.destroy=function(){if(this._sLazyLoadingTimer){clearTimeout(this._sLazyLoadingTimer);}};
a.prototype._isPhone=function(){return l.Utilities.isPhoneScenario(this._oObjectPageLayout._getCurrentMediaContainerRange());};
a.prototype._isTablet=function(){return D.system.tablet;};
a.prototype._isTabletSize=function(){return l.Utilities.isTabletScenario(this._oObjectPageLayout._getCurrentMediaContainerRange());};
return a;},false);
sap.ui.predefine('sap/uxap/ModelMapping',["sap/ui/core/Element","./library"],function(E,l){"use strict";
var M=E.extend("sap.uxap.ModelMapping",{metadata:{library:"sap.uxap",properties:{externalModelName:{type:"string",group:"Misc",defaultValue:null},internalModelName:{type:"string",group:"Misc",defaultValue:"Model"},externalPath:{type:"string",group:"Misc",defaultValue:null}}}});
return M;});
sap.ui.predefine('sap/uxap/ObjectImageHelper',["sap/ui/base/ManagedObject","sap/ui/core/Icon","sap/ui/core/IconPool","sap/m/Image"],function(M,I,a,b){"use strict";var O=function(){};
O.createObjectImage=function(h){var o,s=h.getObjectImageURI();if(s.indexOf("sap-icon://")===0){o=new I();o.addStyleClass("sapUxAPObjectPageHeaderObjectImageIcon");}else{o=new b({densityAware:h.getObjectImageDensityAware(),alt:M.escapeSettingsValue(h.getObjectImageAlt()),decorative:false,mode:"Background",backgroundSize:"contain",backgroundPosition:"center"});o.addStyleClass("sapUxAPObjectPageHeaderObjectImage");}o.setSrc(s);if(h.getObjectImageAlt()){o.setTooltip(h.getObjectImageAlt());}return o;};
O.createPlaceholder=function(){return a.createControlByURI({src:a.getIconURI("picture"),visible:true});};
O._renderImageAndPlaceholder=function(r,o){var h=o.oHeader,c=o.oObjectImage,p=o.oPlaceholder,i=o.bIsObjectIconAlwaysVisible,A=o.bAddSubContainer,B=o.sBaseClass,s=!(h.getObjectImageShape()||h.getShowPlaceholder()),d=(c instanceof I);if(h.getObjectImageURI()||h.getShowPlaceholder()){r.write("<span ");r.addClass(B);r.addClass('sapUxAPObjectPageHeaderObjectImage-'+h.getObjectImageShape());if(i){r.addClass('sapUxAPObjectPageHeaderObjectImageForce');}r.writeClasses();r.write(">");if(A){r.write("<span class='sapUxAPObjectPageHeaderObjectImageContainerSub'>");}if(d){r.write("<div");r.addClass("sapUxAPObjectPageHeaderObjectImage");r.addClass("sapUxAPObjectPageHeaderPlaceholder");r.writeClasses();r.write(">");}r.renderControl(c);O._renderPlaceholder(r,p,s);if(d){r.write("</div>");}if(A){r.write("</span>");}r.write("</span>");}};
O._renderPlaceholder=function(r,p,v){r.write("<div");r.addClass('sapUxAPObjectPageHeaderPlaceholder');r.addClass('sapUxAPObjectPageHeaderObjectImage');if(!v){r.addClass('sapUxAPHidePlaceholder');}r.writeClasses();r.write(">");r.renderControl(p);r.write("</div>");};
return O;},false);
sap.ui.predefine('sap/uxap/ObjectPageAccessibleLandmarkInfo',['sap/ui/core/Element','./library'],function(E,l){"use strict";
var O=E.extend("sap.uxap.ObjectPageAccessibleLandmarkInfo",{metadata:{library:"sap.uxap",properties:{rootRole:{type:"sap.ui.core.AccessibleLandmarkRole",defaultValue:"Main"},rootLabel:{type:"string",defaultValue:null},contentRole:{type:"sap.ui.core.AccessibleLandmarkRole",defaultValue:"None"},contentLabel:{type:"string",defaultValue:null},navigationRole:{type:"sap.ui.core.AccessibleLandmarkRole",defaultValue:"Navigation"},navigationLabel:{type:"string",defaultValue:null},headerRole:{type:"sap.ui.core.AccessibleLandmarkRole",defaultValue:"Banner"},headerLabel:{type:"string",defaultValue:null},footerRole:{type:"sap.ui.core.AccessibleLandmarkRole",defaultValue:"Region"},footerLabel:{type:"string",defaultValue:null}}}});
return O;});
sap.ui.predefine('sap/uxap/ObjectPageDynamicHeaderContent',['./library',"./ObjectPageDynamicHeaderContentRenderer","sap/base/Log"],function(l,O,L){"use strict";try{sap.ui.getCore().loadLibrary("sap.f");}catch(e){L.error("The control 'sap.uxap.ObjectPageDynamicHeaderContent' needs library 'sap.f'.");throw(e);}var D=sap.ui.requireSync("sap/f/DynamicPageHeader");
var a=D.extend("sap.uxap.ObjectPageDynamicHeaderContent",{metadata:{interfaces:["sap.uxap.IHeaderContent"],library:"sap.uxap"}});
a.createInstance=function(c,v,C,p,s){return new a({content:c,visible:v,pinnable:p,id:s});};
a.prototype.supportsPinUnpin=function(){return true;};
a.prototype.supportsChildPageDesign=function(){return false;};
a.prototype.supportsAlwaysExpanded=function(){return false;};
a.prototype.setContentDesign=function(d){};
return a;});
sap.ui.predefine('sap/uxap/ObjectPageDynamicHeaderContentRenderer',['sap/ui/core/Renderer','sap/f/DynamicPageHeaderRenderer'],function(R,D){"use strict";var O=R.extend(D);return O;},true);
sap.ui.predefine('sap/uxap/ObjectPageDynamicHeaderTitle',['./library','sap/uxap/ObjectPageDynamicHeaderContent',"./ObjectPageDynamicHeaderTitleRenderer","sap/base/Log"],function(l,O,a,L){"use strict";try{sap.ui.getCore().loadLibrary("sap.f");}catch(e){L.error("The control 'sap.uxap.ObjectPageDynamicHeaderTitle' needs library 'sap.f'.");throw(e);}var D=sap.ui.requireSync("sap/f/DynamicPageTitle");
var b=D.extend("sap.uxap.ObjectPageDynamicHeaderTitle",{metadata:{interfaces:["sap.uxap.IHeaderTitle"],library:"sap.uxap"}});
b.prototype.isDynamic=function(){return true;};
b.prototype.getCompatibleHeaderContentClass=function(){return O;};
b.prototype.supportsToggleHeaderOnTitleClick=function(){return true;};
b.prototype.supportsTitleInHeaderContent=function(){return false;};
b.prototype.supportsAdaptLayoutForDomElement=function(){return false;};
b.prototype.supportsBackgroundDesign=function(){return true;};
b.KNOWN_HEADING_CONTROL_CLASS_NAMES=["sap.m.Title","sap.m.Text","sap.m.FormattedText","sap.m.Label"];
b.prototype.getTitleText=function(){var h=this.getHeading(),c=h&&h.getMetadata().getName();if(b.KNOWN_HEADING_CONTROL_CLASS_NAMES.indexOf(c)>-1){return h.getText();}};
b.prototype.getHeaderDesign=function(){return l.ObjectPageHeaderDesign.Light;};
b.prototype.snap=function(u){this._toggleState(false,u);this._updateARIAState(false);};
b.prototype.unSnap=function(u){this._toggleState(true,u);this._updateARIAState(true);};
b.prototype._adaptLayoutForDomElement=function($,E){};
return b;});
sap.ui.predefine('sap/uxap/ObjectPageDynamicHeaderTitleRenderer',['sap/ui/core/Renderer','sap/f/DynamicPageTitleRenderer'],function(R,D){"use strict";var O=R.extend(D);return O;},true);
sap.ui.predefine('sap/uxap/ObjectPageHeader',["sap/ui/thirdparty/jquery","sap/ui/core/Control","sap/ui/core/IconPool","sap/ui/core/CustomData","sap/ui/Device","sap/m/Breadcrumbs","./ObjectPageHeaderActionButton","sap/ui/core/ResizeHandler","sap/m/Button","sap/m/ActionSheet","./ObjectImageHelper","./ObjectPageHeaderContent","./library","sap/m/library","./ObjectPageHeaderRenderer"],function(q,C,I,a,D,B,O,R,b,A,c,d,l,m,e){"use strict";var f=l.Importance;var g=m.ButtonType;var P=m.PlacementType;var h=l.ObjectPageHeaderDesign;var j=l.ObjectPageHeaderPictureShape;
function k(i){return typeof i==="function";}
var n=C.extend("sap.uxap.ObjectPageHeader",{metadata:{library:"sap.uxap",interfaces:["sap.uxap.IHeaderTitle"],properties:{objectImageURI:{type:"string",defaultValue:null},objectImageAlt:{type:"string",defaultValue:''},objectImageDensityAware:{type:"boolean",defaultValue:false},objectTitle:{type:"string",defaultValue:null},objectSubtitle:{type:"string",defaultValue:null},objectImageShape:{type:"sap.uxap.ObjectPageHeaderPictureShape",defaultValue:j.Square},isObjectIconAlwaysVisible:{type:"boolean",defaultValue:false},isObjectTitleAlwaysVisible:{type:"boolean",defaultValue:true},isObjectSubtitleAlwaysVisible:{type:"boolean",defaultValue:true},isActionAreaAlwaysVisible:{type:"boolean",defaultValue:true},headerDesign:{type:"sap.uxap.ObjectPageHeaderDesign",defaultValue:h.Light},showTitleSelector:{type:"boolean",group:"Misc",defaultValue:false},markFavorite:{type:"boolean",group:"Misc",defaultValue:false},markFlagged:{type:"boolean",group:"Misc",defaultValue:false},showMarkers:{type:"boolean",group:"Misc",defaultValue:false},markLocked:{type:"boolean",group:"Misc",defaultValue:false},showPlaceholder:{type:"boolean",group:"Misc",defaultValue:false},markChanges:{type:"boolean",group:"Misc",defaultValue:false}},defaultAggregation:"actions",aggregations:{_breadCrumbs:{type:"sap.m.Breadcrumbs",multiple:false,visibility:"hidden"},breadcrumbs:{type:"sap.m.Breadcrumbs",multiple:false,singularName:"breadcrumb"},breadCrumbsLinks:{type:"sap.m.Link",multiple:true,singularName:"breadCrumbLink"},_overflowButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_expandButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_objectImage:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_placeholder:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_lockIconCont:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_lockIcon:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_titleArrowIconCont:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_titleArrowIcon:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_favIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_flagIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_overflowActionSheet:{type:"sap.m.ActionSheet",multiple:false,visibility:"hidden"},_changesIconCont:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_changesIcon:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_sideContentBtn:{type:"sap.m.Button",multiple:false,visibility:"hidden"},navigationBar:{type:"sap.m.Bar",multiple:false},actions:{type:"sap.ui.core.Control",multiple:true,singularName:"action"},sideContentButton:{type:"sap.m.Button",multiple:false},titleSelectorTooltip:{type:"sap.ui.core.TooltipBase",altTypes:["string"],multiple:false}},events:{titleSelectorPress:{parameters:{domRef:{type:"string"}}},markLockedPress:{parameters:{domRef:{type:"string"}}},markChangesPress:{parameters:{domRef:{type:"string"}}}},designtime:"sap/uxap/designtime/ObjectPageHeader.designtime"}});
n.prototype._iAvailablePercentageForActions=0.3;
n.prototype.init=function(){this._bFirstRendering=true;if(!this.oLibraryResourceBundle){this.oLibraryResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");}if(!this.oLibraryResourceBundleOP){this.oLibraryResourceBundleOP=sap.ui.getCore().getLibraryResourceBundle("sap.uxap");}this._oOverflowActionSheet=this._lazyLoadInternalAggregation("_overflowActionSheet",true);this._oOverflowButton=this._lazyLoadInternalAggregation("_overflowButton",true).attachPress(this._handleOverflowButtonPress,this);this._oExpandButton=this._lazyLoadInternalAggregation("_expandButton",true);this._oActionSheetButtonMap={};this._oFlagIcon=this._lazyLoadInternalAggregation("_flagIcon",true);this._oFavIcon=this._lazyLoadInternalAggregation("_favIcon",true);this._oTitleArrowIcon=this._lazyLoadInternalAggregation("_titleArrowIcon",true).attachPress(this._handleArrowPress,this);this._oTitleArrowIconCont=this._lazyLoadInternalAggregation("_titleArrowIconCont",true).attachPress(this._handleArrowPress,this);this._oLockIcon=this._lazyLoadInternalAggregation("_lockIcon",true).attachPress(this._handleLockPress,this);this._oLockIconCont=this._lazyLoadInternalAggregation("_lockIconCont",true).attachPress(this._handleLockPress,this);this._oChangesIcon=this._lazyLoadInternalAggregation("_changesIcon",true).attachPress(this._handleChangesPress,this);this._oChangesIconCont=this._lazyLoadInternalAggregation("_changesIconCont",true).attachPress(this._handleChangesPress,this);};
n.getMetadata().forwardAggregation("breadCrumbsLinks",{getter:function(){return this._lazyLoadInternalAggregation("_breadCrumbs");},aggregation:"links"});
n.prototype._handleOverflowButtonPress=function(E){this._oOverflowActionSheet.openBy(this._oOverflowButton);};
n.prototype._handleArrowPress=function(E){this.fireTitleSelectorPress({domRef:E.getSource().getDomRef()});};
n.prototype._handleLockPress=function(E){this.fireMarkLockedPress({domRef:E.getSource().getDomRef()});};
n.prototype._handleChangesPress=function(E){this.fireMarkChangesPress({domRef:E.getSource().getDomRef()});};
n._internalAggregationFactory={"_objectImage":c.createObjectImage,"_placeholder":c.createPlaceholder,"_overflowActionSheet":function(){return new A({placement:P.Bottom});},"_lockIconCont":function(i){return this._getButton(i,"sap-icon://private","lock-cont",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_LOCK_MARK_VALUE"));},"_breadCrumbs":function(i){return new B({links:i.getAggregation("breadCrumbLinks")});},"_lockIcon":function(i){return this._getButton(i,"sap-icon://private","lock",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_LOCK_MARK_VALUE"));},"_titleArrowIconCont":function(i){return this._getButton(i,"sap-icon://slim-arrow-down","titleArrow-cont",i.oLibraryResourceBundleOP.getText("OP_SELECT_ARROW_TOOLTIP"));},"_titleArrowIcon":function(i){return this._getButton(i,"sap-icon://slim-arrow-down","titleArrow",i.oLibraryResourceBundleOP.getText("OP_SELECT_ARROW_TOOLTIP"));},"_favIcon":function(i){return this._getIcon(i,"favorite",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_FAVORITE_MARK_VALUE"));},"_flagIcon":function(i){return this._getIcon(i,"flag",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_FLAG_MARK_VALUE"));},"_overflowButton":function(i){return this._getButton(i,"sap-icon://overflow","overflow",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_OVERFLOW_BTN"));},"_expandButton":function(i){return this._getButton(i,"sap-icon://slim-arrow-down","expand",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_EXPAND_HEADER_BTN"));},"_changesIconCont":function(i){return this._getButton(i,"sap-icon://user-edit","changes-cont",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_CHANGES_MARK_VALUE"));},"_changesIcon":function(i){return this._getButton(i,"sap-icon://user-edit","changes",i.oLibraryResourceBundleOP.getText("TOOLTIP_OP_CHANGES_MARK_VALUE"));},_getIcon:function(i,t,T){return I.createControlByURI({id:this._getParentAugmentedId(i,t),tooltip:T,src:I.getIconURI(t),visible:false});},_getButton:function(i,t,u,T){return new b({id:this._getParentAugmentedId(i,u),tooltip:T,icon:t,type:g.Transparent});},_getParentAugmentedId:function(i,t){return i.getId()+"-"+t;}};
n.prototype._lazyLoadInternalAggregation=function(i,S){if(!this.getAggregation(i)){this.setAggregation(i,n._internalAggregationFactory[i](this),S);}return this.getAggregation(i);};
n.prototype._applyActionProperty=function(i,t){var u=t[0];if(this.getProperty(i)!==u){t.unshift(i);this.setProperty.apply(this,t);if(!this._bFirstRendering){this._notifyParentOfChanges();}}return this;};
n.prototype._applyObjectImageProperty=function(i,t){var u=t[0];if(this.getProperty(i)!==u){t.unshift(i);this.setProperty.apply(this,t);this._destroyObjectImage();if(!this._bFirstRendering){this._notifyParentOfChanges(true);}}return this;};
n.prototype._setAggregationTooltip=function(i,t){var u=this.getAggregation(i);if(u){u.setTooltip(t);}return this;};
n.prototype._setTitleSelectorTooltip=function(t){if(t===null||t===undefined){t=this.oLibraryResourceBundleOP.getText("OP_SELECT_ARROW_TOOLTIP");}this._setAggregationTooltip("_titleArrowIcon",t);this._setAggregationTooltip("_titleArrowIconCont",t);return this;};
n.prototype.setHeaderDesign=function(H){this.setProperty("headerDesign",H);if(this.getParent()){this.getParent().invalidate();}return this;};
n.prototype.setObjectTitle=function(N){var i=this.getParent(),t=this.getProperty("objectTitle"),u=t!==N;this._applyActionProperty("objectTitle",Array.prototype.slice.call(arguments));i&&k(i._updateAriaLabels)&&i._updateAriaLabels();if(u&&this.mEventRegistry["_titleChange"]){this.fireEvent("_titleChange",{"id":this.getId(),"name":"objectTitle","oldValue":t,"newValue":N});}return this;};
var p=["objectSubtitle","showTitleSelector","markLocked","markFavorite","markFlagged","showMarkers","showPlaceholder","markChanges"],o=["objectImageURI","objectImageAlt","objectImageDensityAware","objectImageShape"];var G=function(i){var t="set"+i.charAt(0).toUpperCase()+i.slice(1);n.prototype[t]=function(){var u=Array.prototype.slice.call(arguments);this._applyActionProperty.call(this,i,u);return this;};};var r=function(i){var t="set"+i.charAt(0).toUpperCase()+i.slice(1);n.prototype[t]=function(){var u=Array.prototype.slice.call(arguments);this._applyObjectImageProperty.call(this,i,u);return this;};};var s=function(i,S,t){var u="set"+i.charAt(0).toUpperCase()+i.slice(1);S[u]=function(){var v=Array.prototype.slice.call(arguments);v.unshift(i);t.setProperty.apply(t,v);return this.setProperty.apply(this,v);};};p.forEach(G);o.forEach(r);
n.prototype._destroyObjectImage=function(){var i="_objectImage",t=this.getAggregation(i);if(t){t.destroy();this.setAggregation(i,null);}};
n.prototype.onBeforeRendering=function(){var S=this.getSideContentButton(),t=this;if(S&&!S.getTooltip()){S.setTooltip(this.oLibraryResourceBundleOP.getText("TOOLTIP_OP_SHOW_SIDE_CONTENT"));}var i=this.getActions()||[];this._oOverflowActionSheet.removeAllButtons();this._resetActionSheetMap();if(i.length>1||this._hasOneButtonShowText(i)){i.forEach(function(u){if(u instanceof b&&!(u instanceof O)){u._bInternalVisible=u.getVisible();u._getInternalVisible=function(){return this._bInternalVisible;};u._setInternalVisible=function(V,w){this.$().toggle(V);if(V!=this._bInternalVisible){this._bInternalVisible=V;if(w){this.invalidate();}}};u.setVisible=function(V){u._setInternalVisible(V,true);b.prototype.setVisible.call(this,V);};u.onAfterRendering=function(){if(!this._getInternalVisible()){this.$().hide();}t._resizeIdentifierLineContainer();};}if(u instanceof b&&u.getVisible()){var v=this._createActionSheetButton(u);this._oActionSheetButtonMap[u.getId()]=v;this._oOverflowActionSheet.addButton(v);s("text",u,v);s("icon",u,v);s("enabled",u,v);}},this);}this._oTitleArrowIcon.setVisible(this.getShowTitleSelector());this._oFavIcon.setVisible(this.getMarkFavorite());this._oFlagIcon.setVisible(this.getMarkFlagged());this._attachDetachActionButtonsHandler(false);if(this._iResizeId){R.deregister(this._iResizeId);this._iResizeId=null;}this._bFirstRendering=false;};
n.prototype._resetActionSheetMap=function(){Object.keys(this._oActionSheetButtonMap).forEach(function(i){this._oActionSheetButtonMap[i].destroy();}.bind(this));this._oActionSheetButtonMap={};};
n.prototype._createActionSheetButton=function(i){return new b({press:q.proxy(this._onSeeMoreContentSelect,this),enabled:i.getEnabled(),text:i.getText(),icon:i.getIcon(),tooltip:i.getTooltip(),customData:new a({key:"originalId",value:i.getId()})});};
n.prototype._handleImageNotFoundError=function(){var i=this._lazyLoadInternalAggregation("_objectImage"),t=this.getParent(),$=t?t.$():this.$();if(this.getShowPlaceholder()){$.find(".sapMImg.sapUxAPObjectPageHeaderObjectImage").hide();$.find(".sapUxAPObjectPageHeaderPlaceholder").removeClass("sapUxAPHidePlaceholder");}else{i.addStyleClass("sapMNoImg");}};
n.prototype._clearImageNotFoundHandler=function(){this._lazyLoadInternalAggregation("_objectImage").$().off("error");};
n.prototype.onAfterRendering=function(){var $=this._lazyLoadInternalAggregation("_objectImage").$();this._adaptLayout();this._clearImageNotFoundHandler();$.error(this._handleImageNotFoundError.bind(this));if(!this.getObjectImageURI()){this._handleImageNotFoundError();}if(!this._iResizeId){this._iResizeId=R.register(this,this._onHeaderResize.bind(this));}this._attachDetachActionButtonsHandler(true);};
n.prototype._onHeaderResize=function(E){this._adaptLayout();if(this.getParent()&&typeof this.getParent()._onUpdateHeaderTitleSize==="function"){this.getParent()._onUpdateHeaderTitleSize(E);}};
n.prototype._attachDetachActionButtonsHandler=function(i){var t=this.getActions()||[];if(t.length<1){return;}t.forEach(function(u){if(u instanceof b){var v=this._oActionSheetButtonMap[u.getId()];if(i){u.attachEvent("_change",this._adaptLayout,this);if(v){v.attachEvent("_change",this._adaptOverflow,this);}}else{u.detachEvent("_change",this._adaptLayout,this);if(v){v.detachEvent("_change",this._adaptOverflow,this);}}}},this);};
n.prototype._onSeeMoreContentSelect=function(E){var i=E.getSource(),t=sap.ui.getCore().byId(i.data("originalId"));if(t.firePress){t.firePress({overflowButtonId:this._oOverflowButton.getId(),bInOverflow:true});}this._oOverflowActionSheet.close();};
n._actionImportanceMap={"Low":3,"Medium":2,"High":1};
n._sortActionsByImportance=function(i,t){var u=(i instanceof O)?i.getImportance():f.High,v=(t instanceof O)?t.getImportance():f.High,w=n._actionImportanceMap[u]-n._actionImportanceMap[v];if(w===0){return i.position-t.position;}return w;};
n.prototype._hasOneButtonShowText=function(i){var t=false;if(i.length!==1){return t;}if(i[0]instanceof O){t=(!i[0].getHideText()&&i[0].getText()!="");}else if(i[0]instanceof b){t=(i[0].getText()!="");}return t;};
n.prototype._adaptLayout=function(E){this._adaptLayoutForDomElement(null,E);};
n.prototype._adaptLayoutForDomElement=function($,E){var i=this._findById($,"identifierLine"),t=i.width(),u=this._getActionsWidth(),v=u/t,w=this._iAvailablePercentageForActions*t,x=this._oOverflowButton.$(),y=this._findById($,"actions"),z=y.find(".sapMBtn").not(".sapUxAPObjectPageHeaderExpandButton");if(t===0){return;}if(v>this._iAvailablePercentageForActions){this._adaptActions(w);}else if(E&&E.getSource()instanceof O){E.getSource()._setInternalVisible(true);}if(D.system.phone){this.getActions().forEach(function(F){if(F instanceof b){F.$().css("visibility","visible");}});}if(z.filter(":visible").length===z.length){x.hide();}this._adaptObjectPageHeaderIndentifierLine($);};
n.prototype._adaptLayoutDelayed=function(){if(this._adaptLayoutTimeout){clearTimeout(this._adaptLayoutTimeout);}this._adaptLayoutTimeout=setTimeout(function(){this._adaptLayoutTimeout=null;this._adaptLayout();}.bind(this),0);};
n.prototype._adaptObjectPageHeaderIndentifierLine=function($){var i=this._findById($,"identifierLine"),t=i.find(".sapUxAPObjectPageHeaderIdentifierTitle"),u=this._findById($,"subtitle"),v=this._findById($,"innerTitle"),S,T,w=null,x=this.$().parents().hasClass('sapUiSizeCompact')?7:3;this._adaptObjectPageHeaderTitle(t);if(u.length){if(u.hasClass("sapOPHSubtitleBlock")){w=i.get(0).style.height;i.css("height",i.height());u.removeClass("sapOPHSubtitleBlock");}S=u.outerHeight()+u.position().top;T=v.outerHeight()+v.position().top;if(Math.abs(S-T)>x){u.addClass("sapOPHSubtitleBlock");}if(w!==null){i.get(0).style.height=w;}}this._resizeIdentifierLineContainer($);};
n.prototype._resizeIdentifierLineContainer=function($){var i=this._findById($,"identifierLineContainer"),t=this._findById($,"actions"),u=this._findById($,"identifierLine"),v=u.width(),w=$?$.find(".sapUxAPObjectPageHeaderObjectImageContainer"):this.$().find(".sapUxAPObjectPageHeaderObjectImageContainer"),x=t.width()+w.width();i.width((0.95-(x/v))*100+"%");};
n.prototype._adaptObjectPageHeaderTitle=function($){var t=$.width(),T=$.find(".sapUxAPObjectPageHeaderTitleText"),u=T.length,v;for(var i=0;i<u;i++){v=q(T.get(i));v.toggleClass("sapUxAPObjectPageHeaderTitleTextRestrictedWidth",false);if(v.width()>t){v.toggleClass("sapUxAPObjectPageHeaderTitleTextRestrictedWidth",true);}}};
n.prototype._adaptActions=function(t){var M=l.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange())||D.system.phone,$=this._oOverflowButton.$(),v=$.show().width(),u=this.getActions(),w=u.length,x;for(var i=0;i<w;i++){u[i].position=i;}u.sort(n._sortActionsByImportance);u.forEach(function(y){x=this._oActionSheetButtonMap[y.getId()];if(x){v+=y.$().width();if(t>v&&!M){this._setActionButtonVisibility(y,true);$.hide();}else{this._setActionButtonVisibility(y,false);$.show();}}},this);};
n.prototype._adaptOverflow=function(){var i=this._oOverflowActionSheet.getButtons();var H=i.some(function(t){return t.getVisible();});this._oOverflowButton.$().toggle(H);};
n.prototype._setActionButtonVisibility=function(i,v){var t=this._oActionSheetButtonMap[i.getId()];if(t){if(i.getVisible()){i._setInternalVisible(v);t.setVisible(!v);}else{t.setVisible(false);}}};
n.prototype._getActionsWidth=function(){var w=0;this.getActions().forEach(function(i){if(i instanceof b){i.$().show();if(D.system.phone){i.$().css("visibility","hidden");}w+=i.$().outerWidth(true);}});return w;};
n.prototype._findById=function($,i){var E;if(!i){return null;}if($){i=this.getId()+'-'+i;E="#"+i.replace(/(:|\.)/g,'\\$1');return $.find(E);}return this.$(i);};
n.prototype._getBreadcrumbsAggregation=function(){var i=this.getBreadcrumbs(),t=this._lazyLoadInternalAggregation('_breadCrumbs',true);return i||((t&&t.getLinks().length)?t:null);};
n.prototype._notifyParentOfChanges=function(i){var t=this.getParent();if(t&&typeof t._headerTitleChangeHandler==="function"){t._headerTitleChangeHandler(i);}};
n.prototype.setTitleSelectorTooltip=function(t){this._setTitleSelectorTooltip(t);this.setAggregation("titleSelectorTooltip",t,true);return this;};
n.prototype.destroyTitleSelectorTooltip=function(){this._setTitleSelectorTooltip(null);this.destroyAggregation("titleSelectorTooltip",true);return this;};
n.prototype.exit=function(){this._clearImageNotFoundHandler();if(this._iResizeId){R.deregister(this._iResizeId);this._iResizeId=null;}this._resetActionSheetMap();};
n.prototype.setNavigationBar=function(i){this.setAggregation("navigationBar",i);if(i&&this.mEventRegistry["_adaptableContentChange"]){this.fireEvent("_adaptableContentChange",{"parent":this,"adaptableContent":i});}return this;};
n.prototype._getAdaptableContent=function(){return this.getNavigationBar();};
n.prototype.isDynamic=function(){return false;};
n.prototype.getCompatibleHeaderContentClass=function(){return d;};
n.prototype.supportsToggleHeaderOnTitleClick=function(){return false;};
n.prototype.supportsTitleInHeaderContent=function(){return true;};
n.prototype.supportsAdaptLayoutForDomElement=function(){return true;};
n.prototype.supportsBackgroundDesign=function(){return false;};
n.prototype.getTitleText=function(){return this.getObjectTitle();};
n.prototype.snap=function(){this._adaptLayout();};
n.prototype.unSnap=function(){this._adaptLayout();};
n.prototype._toggleExpandButton=function(t){};
n.prototype._setShowExpandButton=function(v){};
n.prototype._focusExpandButton=function(){};
n.prototype._toggleFocusableState=function(F){};
return n;});
sap.ui.predefine('sap/uxap/ObjectPageHeaderActionButton',["sap/m/Button","./library","./ObjectPageHeaderActionButtonRenderer"],function(B,l,O){"use strict";
var a=B.extend("sap.uxap.ObjectPageHeaderActionButton",{metadata:{interfaces:["sap.m.IOverflowToolbarContent"],library:"sap.uxap",properties:{hideText:{type:"boolean",defaultValue:true},hideIcon:{type:"boolean",defaultValue:false},importance:{type:"sap.uxap.Importance",group:"Behavior",defaultValue:l.Importance.High}},designtime:"sap/uxap/designtime/ObjectPageHeaderActionButton.designtime"}});
a.prototype.init=function(){this._bInternalVisible=this.getVisible();};
a.prototype.onAfterRendering=function(){if(!this._getInternalVisible()){this.$().hide();}};
a.prototype.applySettings=function(s,S){if(B.prototype.applySettings){B.prototype.applySettings.call(this,s,S);}this.toggleStyleClass("sapUxAPObjectPageHeaderActionButtonHideText",this.getHideText());this.toggleStyleClass("sapUxAPObjectPageHeaderActionButtonHideIcon",this.getHideIcon());};
a.prototype.setHideText=function(v,i){this.toggleStyleClass("sapUxAPObjectPageHeaderActionButtonHideText",v);return this.setProperty("hideText",v,i);};
a.prototype.setHideIcon=function(v,i){this.toggleStyleClass("sapUxAPObjectPageHeaderActionButtonHideIcon",v);return this.setProperty("hideIcon",v,i);};
a.prototype._setInternalVisible=function(v,i){this.$().toggle(v);if(v!=this._bInternalVisible){this._bInternalVisible=v;if(i){this.invalidate();}}};
a.prototype.setVisible=function(v){var r=B.prototype.setVisible.apply(this,arguments);if(this.getParent()&&typeof this.getParent()._adaptLayoutDelayed==="function"){this.getParent()._adaptLayoutDelayed();}return r;};
a.prototype._getInternalVisible=function(){return this._bInternalVisible;};
a.prototype.getOverflowToolbarConfig=function(){var c={canOverflow:true,propsUnrelatedToSize:["importance"],getCustomImportance:function(){return this.getImportance();}.bind(this)};c.onBeforeEnterOverflow=function(A){A.toggleStyleClass("sapUxAPObjectPageHeaderActionButtonHideText",false,true);A.toggleStyleClass("sapUxAPObjectPageHeaderActionButtonHideIcon",false,true);};c.onAfterExitOverflow=function(A){A.toggleStyleClass("sapUxAPObjectPageHeaderActionButtonHideText",A.getHideText(),true);A.toggleStyleClass("sapUxAPObjectPageHeaderActionButtonHideIcon",A.getHideIcon(),true);};return c;};
return a;});
sap.ui.predefine('sap/uxap/ObjectPageHeaderActionButtonRenderer',["sap/m/ButtonRenderer","sap/ui/core/Renderer"],function(B,R){"use strict";var O=R.extend(B);return O;},true);
sap.ui.predefine('sap/uxap/ObjectPageHeaderContent',["sap/ui/core/Control","./library","sap/m/Button","./ObjectImageHelper","./ObjectPageHeaderContentRenderer"],function(C,l,B,O,a){"use strict";var b=l.ObjectPageHeaderDesign;
var c=C.extend("sap.uxap.ObjectPageHeaderContent",{metadata:{library:"sap.uxap",interfaces:["sap.uxap.IHeaderContent"],properties:{contentDesign:{type:"sap.uxap.ObjectPageHeaderDesign",group:"Misc",defaultValue:b.Light}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},_editHeaderButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_objectImage:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_placeholder:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}}}});
c.prototype.onBeforeRendering=function(){var p=this.getParent(),e=this.getAggregation("_editHeaderButton");if(e){return;}if(p&&(p instanceof l.ObjectPageLayout)&&p.getShowEditHeaderButton()){e=this._getInternalBtnAggregation("_editHeaderButton","EDIT_HEADER","-editHeaderBtn","Transparent");e.attachPress(this._handleEditHeaderButtonPress,this);}};
c.prototype.exit=function(){var e=this.getAggregation("_editHeaderButton");if(e){e.detachPress(this._handleEditHeaderButtonPress,this);}};
c.prototype._handleEditHeaderButtonPress=function(e){this.getParent().fireEditHeaderButtonPress();};
c.prototype._getInternalBtnAggregation=function(A,s,d,e){if(!this.getAggregation(A)){var o=new B({text:sap.ui.getCore().getLibraryResourceBundle("sap.uxap").getText(s),type:e,id:this.getId()+d});this.setAggregation(A,o);}return this.getAggregation(A);};
c.prototype._getObjectImage=function(){if(!this.getAggregation("_objectImage")){var p=this.getParent(),h=p&&p.getHeaderTitle&&p.getHeaderTitle(),o=h&&O.createObjectImage(h);if(o){this.setAggregation("_objectImage",o,true);}}return this.getAggregation("_objectImage");};
c.prototype._destroyObjectImage=function(s){var o=this.getAggregation("_objectImage");if(o){o.destroy();this.getAggregation("_objectImage",null,s);}};
c.prototype._getPlaceholder=function(){if(!this.getAggregation("_placeholder")){var p=this.getParent(),h=p&&p.getHeaderTitle&&p.getHeaderTitle(),s=h.getShowPlaceholder();var P=s&&O.createPlaceholder();if(P){this.setAggregation("_placeholder",P,true);}}return this.getAggregation("_placeholder");};
c.prototype._getLayoutDataForControl=function(o){var L=o.getLayoutData();if(!L){return;}else if(L instanceof l.ObjectPageHeaderLayoutData){return L;}else if(L.getMetadata().getName()=="sap.ui.core.VariantLayoutData"){var d=L.getMultipleLayoutData();for(var i=0;i<d.length;i++){var e=d[i];if(e instanceof l.ObjectPageHeaderLayoutData){return e;}}}};
c.createInstance=function(d,v,s,p,S){return new c({content:d,visible:v,contentDesign:s,id:S});};
c.prototype.supportsPinUnpin=function(){return false;};
c.prototype.supportsChildPageDesign=function(){return true;};
c.prototype.supportsAlwaysExpanded=function(){return true;};
c.prototype._toggleCollapseButton=function(t){};
c.prototype._setShowCollapseButton=function(v){};
c.prototype._focusCollapseButton=function(){};
c.prototype._focusPinButton=function(){};
return c;});
sap.ui.predefine('sap/uxap/ObjectPageHeaderContentRenderer',["./ObjectPageHeaderRenderer","./ObjectImageHelper"],function(O,a){"use strict";var b={};
b.render=function(r,c){var p=c.getParent(),P=p&&p.isA("sap.uxap.ObjectPageLayout"),h=(p&&P)?p.getHeaderTitle():undefined,R=(p&&P)?(p.isA("sap.uxap.ObjectPageLayout")&&p.getShowTitleInHeaderContent()):false,d=P&&p.getShowEditHeaderButton()&&c.getContent()&&c.getContent().length>0;if(d){r.write("<div ");r.writeControlData(c);r.addClass("sapUxAPObjectPageHeaderContentFlexBox");r.addClass("sapUxAPObjectPageHeaderContentDesign-"+c.getContentDesign());if(h){r.addClass('sapUxAPObjectPageContentObjectImage-'+h.getObjectImageShape());}r.writeClasses();r.write(">");}r.write("<div ");if(d){r.addClass("sapUxAPObjectPageHeaderContentCellLeft");}else{r.writeControlData(c);r.addClass("sapUxAPObjectPageHeaderContentDesign-"+c.getContentDesign());if(h){r.addClass('sapUxAPObjectPageContentObjectImage-'+h.getObjectImageShape());}}r.addClass("sapContrastPlus");r.addClass("ui-helper-clearfix");r.addClass("sapUxAPObjectPageHeaderContent");if(!c.getVisible()){r.addClass("sapUxAPObjectPageHeaderContentHidden");}r.writeClasses();r.write(">");if(P&&p.getIsChildPage()){r.write("<div");r.addClass('sapUxAPObjectChildPage');r.writeClasses();r.write("></div>");}if(R){this._renderTitleImage(r,c,h);if(c.getContent().length==0){r.write("<span class=\"sapUxAPObjectPageHeaderContentItem\">");this._renderTitle(r,h);r.write("</span>");}}c.getContent().forEach(function(i,I){this._renderHeaderContentItem(i,I,r,R,h,c);},this);r.write("</div>");if(d){this._renderEditButton(r,c);r.write("</div>");}};
b._renderHeaderContentItem=function(h,i,r,R,t,c){var H=false,d=false,l=c._getLayoutDataForControl(h),I=i===0;if(l){H=l.getShowSeparatorBefore();d=l.getShowSeparatorAfter();r.write("<span ");r.addClass("sapUxAPObjectPageHeaderWidthContainer");r.addClass("sapUxAPObjectPageHeaderContentItem");r.addStyle("width",l.getWidth());r.writeStyles();if(d||H){r.addClass("sapUxAPObjectPageHeaderSeparatorContainer");}if(!l.getVisibleL()){r.addClass("sapUxAPObjectPageHeaderLayoutHiddenL");}if(!l.getVisibleM()){r.addClass("sapUxAPObjectPageHeaderLayoutHiddenM");}if(!l.getVisibleS()){r.addClass("sapUxAPObjectPageHeaderLayoutHiddenS");}r.writeClasses();r.write(">");if(H){r.write("<span class=\"sapUxAPObjectPageHeaderSeparatorBefore\"></span>");}if(I&&R){this._renderTitle(r,t);}}else{if(I&&R){r.write("<span class=\"sapUxAPObjectPageHeaderContentItem\">");this._renderTitle(r,t);}else{h.addStyleClass("sapUxAPObjectPageHeaderContentItem");}}r.renderControl(h);if(d){r.write("<span class=\"sapUxAPObjectPageHeaderSeparatorAfter\"></span>");}if(l||(I&&R)){r.write("</span>");}};
b._renderTitleImage=function(r,c,h){a._renderImageAndPlaceholder(r,{oHeader:h,oObjectImage:c._getObjectImage(),oPlaceholder:c._getPlaceholder(),bIsObjectIconAlwaysVisible:false,bAddSubContainer:false,sBaseClass:'sapUxAPObjectPageHeaderContentImageContainer'});};
b._renderTitle=function(r,h){O._renderObjectPageTitle(r,h,true);};
b._renderEditButton=function(r,h){r.write("<div class=\"sapUxAPObjectPageHeaderContentCellRight\">");r.renderControl(h.getAggregation("_editHeaderButton"));r.write("</div>");};
return b;},true);
sap.ui.predefine('sap/uxap/ObjectPageHeaderLayoutData',["sap/ui/core/LayoutData","./library"],function(L,l){"use strict";
var O=L.extend("sap.uxap.ObjectPageHeaderLayoutData",{metadata:{library:"sap.uxap",properties:{visibleS:{type:"boolean",group:"Misc",defaultValue:true},visibleM:{type:"boolean",group:"Misc",defaultValue:true},visibleL:{type:"boolean",group:"Misc",defaultValue:true},showSeparatorBefore:{type:"boolean",group:"Misc",defaultValue:false},showSeparatorAfter:{type:"boolean",group:"Misc",defaultValue:false},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:'auto'}}}});
return O;});
sap.ui.predefine('sap/uxap/ObjectPageHeaderRenderer',["./ObjectImageHelper","sap/ui/Device"],function(O,D){"use strict";var a={};
a.render=function(r,c){var n=c.getNavigationBar(),t=(c.getIsObjectIconAlwaysVisible()||c.getIsObjectTitleAlwaysVisible()||c.getIsObjectSubtitleAlwaysVisible()||c.getIsActionAreaAlwaysVisible()),p=c.getParent(),e=c.getAggregation("_expandButton"),o=c._lazyLoadInternalAggregation("_objectImage",true),P,I=D.system.desktop,b=p&&p.isA("sap.uxap.ObjectPageLayout")&&((p.getHeaderContent()&&p.getHeaderContent().length>0&&p.getShowHeaderContent())||(p.getShowHeaderContent()&&p.getShowTitleInHeaderContent()));r.write("<div");r.writeControlData(c);r.addClass('sapUxAPObjectPageHeader');r.addClass('sapUxAPObjectPageHeaderDesign-'+c.getHeaderDesign());r.writeClasses();r.write(">");if(n){r.write("<div");r.addClass('sapUxAPObjectPageHeaderNavigation');r.writeClasses();r.write(">");r.renderControl(n);r.write("</div>");}r.write("<div");r.writeAttributeEscaped("id",c.getId()+"-identifierLine");r.addClass('sapUxAPObjectPageHeaderIdentifier');if(t){r.addClass('sapUxAPObjectPageHeaderIdentifierForce');}r.writeClasses();r.write(">");if(p&&p.isA("sap.uxap.ObjectPageLayout")&&p.getIsChildPage()){r.write("<div");r.addClass('sapUxAPObjectChildPage');r.writeClasses();r.write("></div>");}if(c.getShowPlaceholder()){P=c._lazyLoadInternalAggregation("_placeholder",true);}O._renderImageAndPlaceholder(r,{oHeader:c,oObjectImage:o,oPlaceholder:P,bIsObjectIconAlwaysVisible:c.getIsObjectIconAlwaysVisible(),bAddSubContainer:true,sBaseClass:'sapUxAPObjectPageHeaderObjectImageContainer'});r.write("<span ");r.writeAttributeEscaped("id",c.getId()+"-identifierLineContainer");r.addClass('sapUxAPObjectPageHeaderIdentifierContainer');r.writeClasses();r.write(">");this._renderObjectPageTitle(r,c);r.write("</span>");r.write("<span");r.writeAttributeEscaped("id",c.getId()+"-actions");r.addClass('sapUxAPObjectPageHeaderIdentifierActions');if(c.getIsActionAreaAlwaysVisible()){r.addClass('sapUxAPObjectPageHeaderIdentifierActionsForce');}r.writeClasses();r.write(">");if(I&&b){e.addStyleClass("sapUxAPObjectPageHeaderExpandButton");r.renderControl(e);}var A=c.getActions();for(var i=0;i<A.length;i++){var d=A[i];r.renderControl(d);}var f=c.getAggregation("_overflowButton");r.renderControl(f);this._renderSideContentBtn(r,c);r.write("</span>");r.write("</div>");r.write("</div>");};
a._renderObjectPageTitle=function(r,c,t){var o=c.getObjectTitle(),m=(c.getShowMarkers()&&(c.getMarkFavorite()||c.getMarkFlagged())),b=c._getBreadcrumbsAggregation(),T=c.getTooltip_Text(),i=t?"-content":"";if(!t&&b){r.renderControl(b);}r.write("<h2");r.addClass('sapUxAPObjectPageHeaderIdentifierTitle');if(c.getIsObjectTitleAlwaysVisible()){r.addClass('sapUxAPObjectPageHeaderIdentifierTitleForce');}if(t){r.addClass('sapUxAPObjectPageHeaderIdentifierTitleInContent');}if(c.getShowTitleSelector()){r.addClass('sapUxAPObjectPageHeaderTitleFollowArrow');}r.writeClasses();r.writeAttributeEscaped("id",c.getId()+"-title"+i);r.write(">");r.write("<span");r.addClass("sapUxAPObjectPageHeaderTitleText");r.addClass("sapUxAPObjectPageHeaderTitleTextWrappable");r.writeClasses();r.writeAttributeEscaped("id",c.getId()+"-innerTitle"+i);if(T){r.writeAttributeEscaped("title",T);}r.write(">");if(m||c.getShowTitleSelector()||c.getMarkLocked()||c.getMarkChanges()){var s=o.substr(o.lastIndexOf(" ")+1);var d=o.substr(0,o.lastIndexOf(" ")+1);if(s.length===1){s=o;d='';}r.writeEscaped(d);r.write("</span>");r.write("<span");r.addClass('sapUxAPObjectPageHeaderNowrapMarkers');if(c.getMarkLocked()||c.getMarkChanges()){r.addClass('sapUxAPObjectPageHeaderMarks');}r.writeClasses();r.write(">");r.write("<span");r.addClass("sapUxAPObjectPageHeaderTitleText");r.writeClasses();r.write(">");r.writeEscaped(s);r.write("</span>");this._renderMarkers(r,c);if(c.getMarkLocked()){this._renderLock(r,c,t);}else if(c.getMarkChanges()){this._renderMarkChanges(r,c,t);}this._renderSelectTitleArrow(r,c,t);r.write("</span>");}else{r.writeEscaped(o);r.write("</span>");}r.write("</h2>");r.write("<span");r.addClass('sapUxAPObjectPageHeaderIdentifierDescription');if(c.getIsObjectSubtitleAlwaysVisible()&&c.getObjectSubtitle()){r.addClass('sapUxAPObjectPageHeaderIdentifierDescriptionForce');}if(t){r.addClass('sapUxAPObjectPageHeaderIdentifierSubTitleInContent');}r.writeClasses();r.writeAttributeEscaped("id",c.getId()+"-subtitle"+i);r.write(">");r.writeEscaped(c.getObjectSubtitle());r.write("</span>");};
a._renderSelectTitleArrow=function(r,c,t){if(c.getShowTitleSelector()){r.write("<span");r.addClass("sapUxAPObjectPageHeaderTitleArrow");r.writeClasses();r.write(">");if(t){r.renderControl(c._oTitleArrowIconCont);}else{r.renderControl(c._oTitleArrowIcon);}r.write("</span>");}};
a._renderSideContentBtn=function(r,c){var s=c.getSideContentButton();if(s){r.write("<span");r.addClass("sapUxAPObjectPageHeaderSideContentBtn");r.writeClasses();r.write(">");r.write("<span");r.addClass("sapUxAPObjectPageHeaderSeparator");r.writeClasses();r.write("></span>");r.renderControl(s);r.write("</span>");}};
a._renderMarkChanges=function(r,c,t){r.write("<span");r.addClass("sapUxAPObjectPageHeaderChangesBtn");r.addClass("sapUiSizeCompact");r.writeClasses();r.write(">");if(t){r.renderControl(c._oChangesIconCont);}else{r.renderControl(c._oChangesIcon);}r.write("</span>");};
a._renderLock=function(r,c,t){r.write("<span");r.addClass("sapUxAPObjectPageHeaderLockBtn");r.addClass("sapUiSizeCompact");r.writeClasses();r.write(">");if(t){r.renderControl(c._oLockIconCont);}else{r.renderControl(c._oLockIcon);}r.write("</span>");};
a._renderMarkers=function(r,c){var I=[];if(c.getShowMarkers()){I.push(c._oFavIcon);I.push(c._oFlagIcon);this._renderMarkersAria(r,c);r.write("<span");r.addClass("sapMObjStatusMarker");r.writeClasses();r.writeAttributeEscaped("id",c.getId()+"-markers");r.writeAttributeEscaped("aria-describedby",c.getId()+"-markers-aria");r.write(">");for(var i=0;i<I.length;i++){r.renderControl(I[i]);}r.write("</span>");}};
a._renderMarkersAria=function(r,c){var A="";if(c.getMarkFlagged()){A+=(c.oLibraryResourceBundle.getText("ARIA_FLAG_MARK_VALUE")+" ");}if(c.getMarkFavorite()){A+=(c.oLibraryResourceBundle.getText("ARIA_FAVORITE_MARK_VALUE")+" ");}if(A!==""){r.write("<div");r.writeAttributeEscaped("id",c.getId()+"-markers-aria");r.writeAttribute("aria-hidden","false");r.addClass("sapUiHidden");r.writeClasses();r.write(">");r.writeEscaped(A);r.write("</div>");}};
return a;},true);
sap.ui.predefine('sap/uxap/ObjectPageLayout',["sap/ui/thirdparty/jquery","sap/ui/base/ManagedObjectObserver","sap/ui/core/ResizeHandler","sap/ui/core/Configuration","sap/ui/core/Control","sap/ui/Device","sap/ui/core/delegate/ScrollEnablement","./ObjectPageSectionBase","./ObjectPageSection","./ObjectPageSubSection","./ObjectPageHeaderContent","./LazyLoading","./ObjectPageLayoutABHelper","./ThrottledTaskHelper","sap/m/ScrollBar","sap/ui/core/library","./library","./ObjectPageLayoutRenderer","sap/base/Log","sap/ui/dom/getScrollbarSize","sap/base/assert","sap/ui/events/KeyCodes"],function(q,M,R,C,a,D,S,O,b,c,d,L,A,T,e,f,l,g,h,i,j,K){"use strict";var k=f.TitleLevel;var m=f.AccessibleLandmarkRole;var n=l.ObjectPageSubSectionLayout;
var o=a.extend("sap.uxap.ObjectPageLayout",{metadata:{library:"sap.uxap",properties:{showAnchorBar:{type:"boolean",defaultValue:true},showAnchorBarPopover:{type:"boolean",defaultValue:true},upperCaseAnchorBar:{type:"boolean",defaultValue:true},backgroundDesignAnchorBar:{type:"sap.m.BackgroundDesign",group:"Appearance"},height:{type:"sap.ui.core.CSSSize",defaultValue:"100%"},enableLazyLoading:{type:"boolean",defaultValue:false},subSectionLayout:{type:"sap.uxap.ObjectPageSubSectionLayout",defaultValue:n.TitleOnTop},sectionTitleLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:k.Auto},useIconTabBar:{type:"boolean",group:"Misc",defaultValue:false},showHeaderContent:{type:"boolean",group:"Misc",defaultValue:true},useTwoColumnsForLargeScreen:{type:"boolean",group:"Appearance",defaultValue:false},showTitleInHeaderContent:{type:"boolean",group:"Appearance",defaultValue:false},showOnlyHighImportance:{type:"boolean",group:"Behavior",defaultValue:false},isChildPage:{type:"boolean",group:"Appearance",defaultValue:false},alwaysShowContentHeader:{type:"boolean",group:"Behavior",defaultValue:false},headerContentPinnable:{type:"boolean",group:"Behavior",defaultValue:true},toggleHeaderOnTitleClick:{type:"boolean",group:"Behavior",defaultValue:true},preserveHeaderStateOnScroll:{type:"boolean",group:"Behavior",defaultValue:false},showEditHeaderButton:{type:"boolean",group:"Behavior",defaultValue:false},flexEnabled:{type:"boolean",group:"Misc",defaultValue:false},showFooter:{type:"boolean",group:"Behavior",defaultValue:false}},associations:{selectedSection:{type:"sap.uxap.ObjectPageSection",multiple:false}},defaultAggregation:"sections",aggregations:{sections:{type:"sap.uxap.ObjectPageSection",multiple:true,singularName:"section"},headerTitle:{type:"sap.uxap.IHeaderTitle",multiple:false},headerContent:{type:"sap.ui.core.Control",multiple:true,singularName:"headerContent"},footer:{type:"sap.m.IBar",multiple:false},landmarkInfo:{type:"sap.uxap.ObjectPageAccessibleLandmarkInfo",multiple:false},_anchorBar:{type:"sap.uxap.AnchorBar",multiple:false,visibility:"hidden"},_iconTabBar:{type:"sap.m.IconTabBar",multiple:false,visibility:"hidden"},_headerContent:{type:"sap.uxap.IHeaderContent",multiple:false,visibility:"hidden"},_customScrollBar:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{toggleAnchorBar:{parameters:{fixed:{type:"boolean"}}},editHeaderButtonPress:{},navigate:{parameters:{section:{type:"sap.uxap.ObjectPageSection"},subSection:{type:"sap.uxap.ObjectPageSubSection"}}}},dnd:{draggable:false,droppable:true},designtime:"sap/uxap/designtime/ObjectPageLayout.designtime"}});
o.HEADER_CALC_DELAY=350;o.DOM_CALC_DELAY=200;o.MAX_SNAP_POSITION_OFFSET=20;o.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE=0.6;o.TITLE_LEVEL_AS_ARRAY=Object.keys(k);o.EVENTS={TITLE_PRESS:"_titlePress",TITLE_MOUSE_OVER:"_titleMouseOver",TITLE_MOUSE_OUT:"_titleMouseOut",PIN_UNPIN_PRESS:"_pinUnpinPress",VISUAL_INDICATOR_MOUSE_OVER:"_visualIndicatorMouseOver",VISUAL_INDICATOR_MOUSE_OUT:"_visualIndicatorMouseOut",HEADER_VISUAL_INDICATOR_PRESS:"_headerVisualIndicatorPress",TITLE_VISUAL_INDICATOR_PRESS:"_titleVisualIndicatorPress"};o.BREAK_POINTS={TABLET:1024,PHONE:600};o.MEDIA={PHONE:"sapUxAPObjectPageLayout-Std-Phone",TABLET:"sapUxAPObjectPageLayout-Std-Tablet",DESKTOP:"sapUxAPObjectPageLayout-Std-Desktop"};o.DYNAMIC_HEADERS_MEDIA={PHONE:"sapFDynamicPage-Std-Phone",TABLET:"sapFDynamicPage-Std-Tablet",DESKTOP:"sapFDynamicPage-Std-Desktop"};o.DIV="div";o.HEADER="header";o.FOOTER="section";o.SHOW_FOOTER_CLASS_NAME="sapUxAPObjectPageFloatingFooterShow";o.HIDE_FOOTER_CLASS_NAME="sapUxAPObjectPageFloatingFooterHide";
o._getNextTitleLevelEntry=function(t){var r=o.TITLE_LEVEL_AS_ARRAY.indexOf(t),s=r!==-1,H=s&&(r!==o.TITLE_LEVEL_AS_ARRAY.length-1);if(!s){return k.Auto;}return o.TITLE_LEVEL_AS_ARRAY[H?r+1:r];};
o._getLibraryResourceBundle=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.uxap");};
o.prototype.init=function(){this.oCore=sap.ui.getCore();this._bFirstRendering=true;this._bDomReady=false;this._bPinned=false;this._bStickyAnchorBar=false;this._bHeaderInTitleArea=false;this._bHeaderExpanded=true;this._bHeaderBiggerThanAllowedHeight=false;this._bDelayDOMBasedCalculations=true;this._iStoredScrollTop=0;this._oStoredScrolledSubSectionInfo={};this._bAllContentFitsContainer=false;this._bIsFooterAanimationGoing=false;this._bInternalAnchorBarVisible=true;this._$footerWrapper=[];this._$opWrapper=[];this._$anchorBar=[];this._$titleArea=[];this._$stickyAnchorBar=[];this._$headerContent=[];this._$stickyHeaderContent=[];this._bMobileScenario=false;this._oSectionInfo={};this._aSectionBases=[];this._sScrolledSectionId="";this._iScrollToSectionDuration=600;this._$spacer=[];this.iHeaderContentHeight=0;this.iStickyHeaderContentHeight=0;this.iHeaderTitleHeight=0;this.iHeaderTitleHeightStickied=0;this.iAnchorBarHeight=0;this.iFooterHeight=0;this.iTotalHeaderSize=0;this._iREMSize=parseInt(q("body").css("font-size"));this._iOffset=parseInt(0.25*this._iREMSize);this._iResizeId=null;this._iAfterRenderingDomReadyTimeout=null;this._oABHelper=new A(this);this._initializeScroller();};
o.prototype.onBeforeRendering=function(){var H,P;this._deregisterScreenSizeListener();if(this._oLazyLoading){this._oLazyLoading.destroy();}this._oLazyLoading=new L(this);this._deregisterCustomEvents();if(!this.getVisible()){return;}if(!this.getSelectedSection()){this._bHeaderExpanded=true;}this._bMobileScenario=l.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange());this._bTabletScenario=l.Utilities.isTabletScenario(this._getCurrentMediaContainerRange());if(this._checkAlwaysShowContentHeader()){this._bHeaderExpanded=true;}this._bHeaderInTitleArea=this._shouldPreserveHeaderInTitleArea();this._createHeaderContent();this._getHeaderContent().setContentDesign(this._getHeaderDesign());this._oABHelper._getAnchorBar().setProperty("upperCase",this.getUpperCaseAnchorBar(),true);this._storeScrollLocation();this._applyUxRules();this._getCustomScrollBar().setScrollPosition(0);if(!q.isEmptyObject(this._oSectionInfo)&&this._bFirstRendering){this._preloadSectionsOnBeforeFirstRendering();this._bFirstRendering=false;}this._bStickyAnchorBar=false;this._handleExpandButtonPressEventLifeCycle(false);this._attachTitlePressHandler();H=this._getHeaderContent();if(H&&H.supportsPinUnpin()){P=this.getHeaderContentPinnable()&&!this.getPreserveHeaderStateOnScroll();this._getHeaderContent().setPinnable(P);if(P){this._attachPinPressHandler();}}this._attachVisualIndicatorsPressHandlers(this._handleDynamicTitlePress,this);this._attachVisualIndicatorMouseOverHandlers(this._addHoverClass,this._removeHoverClass,this);this._attachTitleMouseOverHandlers(this._addHoverClass,this._removeHoverClass,this);if(this.getFooter()&&this._bIsFooterAanimationGoing){this._onToggleFooterAnimationEnd(this.getFooter());}};
o.prototype.setBackgroundDesignAnchorBar=function(B){var s=this.getBackgroundDesignAnchorBar(),r="sapUxAPObjectPageNavigation";if(s===B){return this;}this.setProperty("backgroundDesignAnchorBar",B,true);this._oABHelper._getAnchorBar().setBackgroundDesign(B);if(p(this._$anchorBar)){this._$anchorBar.removeClass(r+s);this._$anchorBar.addClass(r+B);}if(p(this._$stickyAnchorBar)){this._$stickyAnchorBar.removeClass(r+s);this._$stickyAnchorBar.addClass(r+B);}return this;};
o.prototype.setToggleHeaderOnTitleClick=function(t){var r=this.getHeaderTitle(),v=this.setProperty("toggleHeaderOnTitleClick",t,true);if(!r||!r.supportsToggleHeaderOnTitleClick()){h.warning("Setting toggleHeaderOnTitleClick will not take effect as it is not supported in the ObjectPageHeader, read the API Doc for more information",this);return v;}t=this.getProperty("toggleHeaderOnTitleClick");this._updateToggleHeaderVisualIndicators();this._updateTitleVisualState();return v;};
o.prototype._attachTitlePressHandler=function(){var t=this.getHeaderTitle();if(p(t)&&!this._bAlreadyAttachedTitlePressHandler){t.attachEvent(o.EVENTS.TITLE_PRESS,this._handleDynamicTitlePress,this);this._bAlreadyAttachedTitlePressHandler=true;}};
o.prototype._toggleHeaderVisibility=function(s){var H=this._getHeaderContent();if(p(H)){H.$().toggleClass("sapUxAPObjectPageHeaderContentHidden",!s);}};
o.prototype._snapHeader=function(r){var I,H=this._getHeaderContent();if(H&&H.supportsPinUnpin()&&this._bPinned){this._unPin();H.getAggregation("_pinButton").setPressed(false);r=true;}this._toggleHeaderTitle(false,true);this._toggleHeaderVisibility(r);this._moveAnchorBarToTitleArea();if(r){this._moveHeaderToContentArea();this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();this._adjustHeaderHeights();this._requestAdjustLayout(true);I=(this._$opWrapper.scrollTop()<=(this._getSnapPosition()+1));if(I){this._scrollTo(this._getSnapPosition()+1);}return;}this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();this._adjustHeaderHeights();this._requestAdjustLayout();};
o.prototype._expandHeader=function(r){this._toggleHeaderTitle(true,true);this._toggleHeaderVisibility(true);if(r){this._moveAnchorBarToTitleArea();this._moveHeaderToTitleArea();this._bHeaderExpanded=true;this._updateToggleHeaderVisualIndicators();this._adjustHeaderHeights();this._requestAdjustLayout();return;}this._moveAnchorBarToContentArea();this._moveHeaderToContentArea();this._scrollTo(0,0,0);this._bHeaderExpanded=true;this._updateToggleHeaderVisualIndicators();};
o.prototype._handleDynamicTitlePress=function(){if(!this.getToggleHeaderOnTitleClick()||!this._hasVisibleDynamicTitleAndHeader()){return;}var E=!this._bHeaderExpanded,I,r,s;if(E){I=(this._$opWrapper.scrollTop()<=(this._getSnapPosition()+1));r=!this._headerBiggerThanAllowedToBeExpandedInTitleArea()&&(this._shouldPreserveHeaderInTitleArea()||!I);this._expandHeader(r);if(!r){this._scrollTo(0,0);}}else{s=!this._shouldPreserveHeaderInTitleArea()&&(!this._bAllContentFitsContainer||this._headerBiggerThanAllowedToBeExpandedInTitleArea());this._snapHeader(s);}this.getHeaderTitle()._getFocusSpan().$().focus();};
o.prototype._attachPinPressHandler=function(){var H=this._getHeaderContent();if(p(H)&&!this._bAlreadyAttachedPinPressHandler){H.attachEvent(o.EVENTS.PIN_UNPIN_PRESS,this._onPinUnpinButtonPress,this);this._bAlreadyAttachedPinPressHandler=true;}};
o.prototype._handleExpandButtonPressEventLifeCycle=function(r){var H=this.getHeaderTitle(),s=this._hasDynamicTitle(),E;if(H&&!s){E=H.getAggregation("_expandButton");if(E){E[r?"attachPress":"detachPress"](this._handleExpandButtonPress,this);}}};
o.prototype._adjustSelectedSectionByUXRules=function(){var s=this.oCore.byId(this.getSelectedSection()),v=s&&this._sectionCanBeRenderedByUXRules(s);if(!v){if(this._oFirstVisibleSection){s=this._oFirstVisibleSection;this.setAssociation("selectedSection",s.getId(),true);}else{this.setAssociation("selectedSection",null,true);return;}}};
o.prototype._sectionCanBeRenderedByUXRules=function(s){var r=s.getBindingInfo("subSections");if((!s||!s.getVisible()||!s._getInternalVisible())&&!r){return false;}var t=this._aSectionBases.map(function(u){return u.getId();});return(t.indexOf(s.getId())>-1);};
o.prototype._getSectionsToRender=function(){this._adjustSelectedSectionByUXRules();var s=this.oCore.byId(this.getSelectedSection());if(this.getUseIconTabBar()&&s){return[s];}else{return this.getSections();}};
o.prototype._preloadSectionsOnBeforeFirstRendering=function(){var t=this._getSectionsToPreloadOnBeforeFirstRendering();this._connectModelsForSections(t);if(this.getEnableLazyLoading()){t.forEach(function(s){this.fireEvent("subSectionPreload",{subSection:s});},this);}};
o.prototype._getSectionsToPreloadOnBeforeFirstRendering=function(){var s,r,I;if(!this.getEnableLazyLoading()){return this._getSectionsToRender();}if(this.getUseIconTabBar()){return this._oLazyLoading.getSubsectionsToPreload(this._grepCurrentTabSectionBases());}this._adjustSelectedSectionByUXRules();r=this.oCore.byId(this.getSelectedSection());if(!r||(r===this._oFirstVisibleSection)){return this._oLazyLoading.getSubsectionsToPreload(this._aSectionBases);}I=this.indexOfSection(r);var F=function(t){var u=t.isA("sap.uxap.ObjectPageSection")?t:t.getParent();return this.indexOfSection(u)>=I;}.bind(this);s=this._aSectionBases.filter(F);return this._oLazyLoading.getSubsectionsToPreload(s);};
o.prototype._grepCurrentTabSectionBases=function(){var F=[],s,r;this._adjustSelectedSectionByUXRules();s=this.oCore.byId(this.getSelectedSection());if(s){var t=s.getId();this._aSectionBases.forEach(function(u){r=u.getParent();if(r&&r.getId()===t){F.push(u);}});}return F;};
o.prototype.onAfterRendering=function(){var H=this._getHeaderContent(),F=this.getFooter(),s,w=this._getWidth(this);this._iResizeId=R.register(this,this._onUpdateScreenSize.bind(this));this._ensureCorrectParentHeight();this._cacheDomElements();if(this._hasDynamicTitle()){this.addStyleClass("sapUxAPObjectPageHasDynamicTitle");}if(w>0){this._updateMedia(w,o.MEDIA);}this._$opWrapper.on("scroll.OPL",this._onScroll.bind(this));if(this._bDomReady&&this.$().parents(":hidden").length===0){this._onAfterRenderingDomReady();}else{if(this._iAfterRenderingDomReadyTimeout){clearTimeout(this._iAfterRenderingDomReadyTimeout);}this._iAfterRenderingDomReadyTimeout=setTimeout(this._onAfterRenderingDomReady.bind(this),this._getDOMCalculationDelay());}if(H&&H.supportsPinUnpin()){this.$().toggleClass("sapUxAPObjectPageLayoutHeaderPinnable",H.getPinnable());}if(F){s=o._getLibraryResourceBundle().getText("FOOTER_ARIA_LABEL");F.$().attr("aria-label",s);}this._handleExpandButtonPressEventLifeCycle(true);};
o.prototype._onAfterRenderingDomReady=function(){var s,r,t;if(this._bIsBeingDestroyed){return;}this._adjustSelectedSectionByUXRules();s=this.getSelectedSection();r=this.oCore.byId(s);this._iAfterRenderingDomReadyTimeout=null;this._bDomReady=true;this._adjustHeaderHeights();this._initAnchorBarScroll();if(s){if(this.getUseIconTabBar()){this._setSelectedSectionId(s);this._setCurrentTabSection(r);this._bAllContentFitsContainer=this._hasSingleVisibleFullscreenSubSection(r);}else{this.scrollToSection(s,0);}}this._toggleScrolling(!this._bAllContentFitsContainer);if(D.system.desktop){this._$opWrapper.on("scroll.OPL",this.onWrapperScroll.bind(this));}this._registerOnContentResize();this.getHeaderTitle()&&this._shiftHeaderTitle();this.getFooter()&&this._shiftFooter();this._setSectionsFocusValues();if(this._preserveHeaderStateOnScroll()){this._overridePreserveHeaderStateOnScroll();}if(!this._bHeaderExpanded){t=!this._shouldPreserveHeaderInTitleArea()&&!this._bAllContentFitsContainer;this._snapHeader(t);}this._restoreScrollPosition();this.oCore.getEventBus().publish("sap.ui","ControlForPersonalizationRendered",this);this._updateMedia(this._getWidth(this),o.MEDIA);if(this._hasDynamicTitle()){this._updateMedia(this._getWidth(this),o.DYNAMIC_HEADERS_MEDIA);}this._updateToggleHeaderVisualIndicators();this._updateTitleVisualState();this.fireEvent("onAfterRenderingDOMReady");};
o.prototype._toggleScrolling=function(E){if(this._$opWrapper.length){this._$opWrapper.get(0).style.overflowY=E?"auto":"hidden";}};
o.prototype._shiftFooter=function(){var $=this.$("footerWrapper"),s=this._calculateShiftOffset();$.css(s.sStyleAttribute,s.iMarginalsOffset+"px");};
o.prototype._calculateShiftOffset=function(){var H=0,s=this.oCore.getConfiguration().getRTL()?"left":"right",r=this._hasVerticalScrollBar(),t=this._iOffset,u;if(D.system.desktop){u=i().width;H=u;if(!r){H=0;t+=u;}}return{"sStyleAttribute":s,"iActionsOffset":t,"iMarginalsOffset":H};};
o.prototype._getDOMCalculationDelay=function(){return this._bDelayDOMBasedCalculations?o.HEADER_CALC_DELAY:0;};
o.prototype.exit=function(){if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}this._deregisterScreenSizeListener();if(this._iContentResizeId){R.deregister(this._iContentResizeId);}if(this._iAfterRenderingDomReadyTimeout){clearTimeout(this._iAfterRenderingDomReadyTimeout);}if(this._oObserver){this._oObserver.disconnect();this._oObserver=null;}this._deregisterCustomEvents();this._oFirstVisibleSection=null;this._oFirstVisibleSubSection=null;};
o.prototype._getCustomScrollBar=function(){if(!this.getAggregation("_customScrollBar")){var v=new e(this.getId()+"-vertSB",{scrollPosition:0,scroll:this.onCustomScrollerScroll.bind(this),visible:false});this.setAggregation("_customScrollBar",v,true);}return this.getAggregation("_customScrollBar");};
o.prototype.onWrapperScroll=function(E){var s=Math.max(E.target.scrollTop,0);if(this._getCustomScrollBar()){if(this.allowCustomScroll===true){this.allowCustomScroll=false;return;}this.allowInnerDiv=true;this._getCustomScrollBar().setScrollPosition(s);}};
o.prototype.onCustomScrollerScroll=function(E){var s=Math.max(this._getCustomScrollBar().getScrollPosition(),0);if(this.allowInnerDiv===true){this.allowInnerDiv=false;return;}this.allowCustomScroll=true;q(this._$opWrapper).scrollTop(s);};
o.prototype.setShowOnlyHighImportance=function(v){var r=this.getShowOnlyHighImportance();if(r!==v){this.setProperty("showOnlyHighImportance",v,true);this.getSections().forEach(function(s){s._updateImportance();});}return this;};
o.prototype.setIsHeaderContentAlwaysExpanded=function(v){var r=this.getAlwaysShowContentHeader();var s=(D.system.phone||D.system.tablet);if(r!==v){this.setProperty("alwaysShowContentHeader",v,s);}return this;};
o.prototype.setShowEditHeaderButton=function(v){var r=this.getShowEditHeaderButton(),H=this.getAggregation("_headerContent");if(r!==v){this.setProperty("showEditHeaderButton",v,true);H&&H.invalidate();}return this;};
o.prototype._initializeScroller=function(){if(this._oScroller){return;}this._oScroller=new S(this,this.getId()+"-scroll",{horizontal:false,vertical:true});};
o.prototype.setSelectedSection=function(I){var v,s;if(I instanceof O){I=I.getId();}else if(I!=null&&typeof I!=="string"){j(false,"setSelectedSection(): sId must be a string, an instance of sap.uxap.ObjectPageSection or null");return this;}if(I===this.getSelectedSection()){return this;}if(I===null){this.setAssociation("selectedSection",null,true);this._expandHeader(this._bHeaderInTitleArea);this._requestAdjustLayoutAndUxRules(true);return this;}this.scrollToSection(I);v=b._getClosestSection(I);s=(v instanceof b)?v.getId():v;return this.setAssociation("selectedSection",s,true);};
o.prototype._ensureCorrectParentHeight=function(){if(this._bCorrectParentHeightIsSet){return;}if(this.getParent().getHeight&&["","auto"].indexOf(this.getParent().getHeight())!==-1){this.$().parent().css("height","100%");}this._bCorrectParentHeightIsSet=true;};
o.prototype._cacheDomElements=function(){this._$footerWrapper=q(document.getElementById(this.getId()+"-footerWrapper"));this._$titleArea=q(document.getElementById(this.getId()+"-headerTitle"));this._$anchorBar=q(document.getElementById(this.getId()+"-anchorBar"));this._$stickyAnchorBar=q(document.getElementById(this.getId()+"-stickyAnchorBar"));this._$opWrapper=q(document.getElementById(this.getId()+"-opwrapper"));this._$spacer=q(document.getElementById(this.getId()+"-spacer"));this._$headerContent=q(document.getElementById(this.getId()+"-headerContent"));this._$stickyHeaderContent=q(document.getElementById(this.getId()+"-stickyHeaderContent"));this._$contentContainer=q(document.getElementById(this.getId()+"-scroll"));this._$sectionsContainer=q(document.getElementById(this.getId()+"-sectionsContainer"));this._oScroller._$Container=this._$opWrapper;this._bDomElementsCached=true;};
o.prototype._handleExpandButtonPress=function(E){this._expandHeader(true);};
o.prototype._toggleHeaderTitle=function(E,u){var H=this.getHeaderTitle();this._$titleArea.toggleClass("sapUxAPObjectPageHeaderStickied",!E);this._$titleArea.toggleClass("sapUxAPObjectPageHeaderSnappedTitleOnMobile",this._hasDynamicTitleWithSnappedTitleOnMobile()&&!E);if(E){H&&H.unSnap(u);}else{H&&H.snap(u);}};
o.prototype._moveHeaderToTitleArea=function(){this._$headerContent.children().appendTo(this._$stickyHeaderContent);this._bHeaderInTitleArea=true;this._bSupressModifyOnScrollOnce=true;};
o.prototype._moveHeaderToContentArea=function(){if(this._bHeaderInTitleArea){this._$headerContent.append(this._$stickyHeaderContent.children());this._$stickyHeaderContent.children().remove();this._bHeaderInTitleArea=false;}};
o.prototype._updateNavigation=function(){if(this.getShowAnchorBar()){this._oABHelper._buildAnchorBar();}};
o.prototype._applyUxRules=function(I){var s,r,v,V,t,u,U,F,w,x,y,z,B={},E;s=this.getSections()||[];V=0;u=this.getShowAnchorBar();U=this.getUseIconTabBar();E=s.length<=1;F=null;this._cleanMemory();s.forEach(function(G){if(!G.getVisible()){return true;}this._registerSectionBaseInfo(G);r=G.getSubSections()||[];v=0;w=null;r.forEach(function(H){if(!H.getVisible()){return true;}this._registerSectionBaseInfo(H);t=H.getVisibleBlocksCount();if(t===0){H._setInternalVisible(false,I);h.info("ObjectPageLayout :: noVisibleBlock UX rule matched","subSection "+H.getTitle()+" forced to hidden");}else{H._setInternalVisible(true,I);B[H.getId()]=true;v++;if(!w){w=H;}if(this._shouldApplySectionTitleLevel(H)){H._setInternalTitleLevel(this._determineSectionBaseInternalTitleLevel(H));}}},this);if(v==0){G._setInternalVisible(false,I);h.info("ObjectPageLayout :: noVisibleSubSection UX rule matched","section "+G.getTitle()+" forced to hidden");}else{G._setInternalVisible(true,I);B[G.getId()]=true;if(!F){F=G;z=v;}if(this.getSubSectionLayout()===n.TitleOnTop&&v===1&&w.getTitle().trim()!==""){h.info("ObjectPageLayout :: TitleOnTop.sectionGetSingleSubSectionTitle UX rule matched","section "+G.getTitle()+" is taking its single subsection title "+w.getTitle());G._setInternalTitle(w.getTitle(),I);B[w.getId()]=false;w._setBorrowedTitleDomId(G.getId()+"-title");}else{G._setInternalTitle("",I);}if(v===1&&!w.getTitle().trim()){w._setBorrowedTitleDomId(G.getId()+"-title");}if(this._shouldApplySectionTitleLevel(G)){G._setInternalTitleLevel(this._determineSectionBaseInternalTitleLevel(G));}V++;}if(U){B[G.getId()]=E;}},this);if(V<=1){u=false;h.info("ObjectPageLayout :: notEnoughVisibleSection UX rule matched","anchorBar forced to hidden");}else if(F&&u){x=true;B[F.getId()]=false;h.info("ObjectPageLayout :: firstSectionTitleHidden UX rule matched","section "+F.getTitle()+" title forced to hidden");}Object.keys(B).forEach(function(G){this.oCore.byId(G)._setInternalTitleVisible(B[G],I);}.bind(this));if(u){this._oABHelper._buildAnchorBar();}this._setInternalAnchorBarVisible(u,I);this._oFirstVisibleSection=F;this._oFirstVisibleSubSection=this._getFirstVisibleSubSection(F);this._bAllContentFitsContainer=(V===1)&&(v===1)&&this._oFirstVisibleSubSection.hasStyleClass(c.FIT_CONTAINER_CLASS);if(x&&(z===1)){y=this.getAggregation("_anchorBar").getContent();if(y.length){this._oFirstVisibleSubSection._setBorrowedTitleDomId(y[0].getId()+"-content");}}};
o.prototype.setUseIconTabBar=function(v){var r=this.getUseIconTabBar();if(v!=r){this._applyUxRules();}this.setProperty("useIconTabBar",v);return this;};
o.prototype._setCurrentTabSection=function(s,I){if(!s){return;}var r;if(s instanceof sap.uxap.ObjectPageSubSection){r=s;s=s.getParent();}else{r=this._getFirstVisibleSubSection(s);}if(this._oCurrentTabSection!==s){this._renderSection(s);this._oCurrentTabSection=s;}this._oCurrentTabSubSection=r;};
o.prototype._renderSection=function(s){var $=this.$().find(".sapUxAPObjectPageContainer"),r;if(s&&$.length){r=this.oCore.createRenderManager();this.getSections().forEach(function(t){if((t.getId()===s.getId())){r.renderControl(s);}else{r.cleanupControlWithoutRendering(t);}});r.flush($[0]);r.destroy();}};
o.prototype.setShowAnchorBarPopover=function(v,s){var r=this.getProperty("showAnchorBarPopover"),v=this.validateProperty("showAnchorBarPopover",v),t=this.getSelectedSection();if(v===r){return this;}this._oABHelper._getAnchorBar().setShowPopover(v);this._oABHelper._buildAnchorBar();this._setSelectedSectionId(t);return this.setProperty("showAnchorBarPopover",v,true);};
o.prototype._getInternalAnchorBarVisible=function(){return this._bInternalAnchorBarVisible;};
o.prototype._setInternalAnchorBarVisible=function(v,I){if(v!=this._bInternalAnchorBarVisible){this._bInternalAnchorBarVisible=v;if(I===true){this.invalidate();}}};
o.prototype.setUpperCaseAnchorBar=function(v){this._oABHelper._getAnchorBar().setProperty("upperCase",v);return this.setProperty("upperCaseAnchorBar",v,true);};
o.prototype._requestAdjustLayout=function(I){if(!this._oLayoutTask){this._oLayoutTask=new T(this._updateScreenHeightSectionBasesAndSpacer,o.DOM_CALC_DELAY,this);}if(!I){h.debug("ObjectPageLayout :: _requestAdjustLayout","delayed by "+o.DOM_CALC_DELAY+" ms because of dom modifications");}return this._oLayoutTask.reSchedule(I,{}).catch(function(r){});};
o.prototype._requestAdjustLayoutAndUxRules=function(I){this._setSectionInfoIsDirty(true);if(!this._oUxRulesTask){this._oUxRulesTask=new T(this._adjustLayoutAndUxRules,o.DOM_CALC_DELAY,this);}if(!I){h.debug("ObjectPageLayout :: _requestAdjustLayoutAndUxRules","delayed by "+o.DOM_CALC_DELAY+" ms because of dom modifications");}return this._oUxRulesTask.reSchedule(I,{}).catch(function(r){});};
o.prototype._adjustLayoutAndUxRules=function(){var s,r;h.debug("ObjectPageLayout :: _requestAdjustLayout","refreshing ux rules");this._applyUxRules(true);this._adjustSelectedSectionByUXRules();s=this.getSelectedSection();r=this.oCore.byId(s);if(r){this._setSelectedSectionId(s);if(this.getUseIconTabBar()){this._setCurrentTabSection(r);}this._requestAdjustLayout(true).then(function(t){if(t){this._oLazyLoading.doLazyLoading();}this._adjustSelectedSectionByUXRules();s=this.getSelectedSection();if(!this._isClosestScrolledSection(s)||this._oScroller._$Container.is(":animated")){this.scrollToSection(s,null,0,false,true);}}.bind(this));}};
o.prototype._isClosestScrolledSection=function(s){var r=this._$opWrapper.length>0?this._$opWrapper.scrollTop():0,P=this.iScreenHeight,t=this._getClosestScrolledSectionId(r,P);return t&&(s===t);};
o.prototype._setSelectedSectionId=function(s){var r=this.getAggregation("_anchorBar"),t=s&&this._oSectionInfo[s];if(!t){return;}if(r&&t.buttonId){r.setSelectedButton(t.buttonId);this.setAssociation("selectedSection",s,true);}};
o.prototype.isFirstRendering=function(){return this._bFirstRendering;};
o.prototype._cleanMemory=function(){var r=this.getAggregation("_anchorBar");if(r){r._resetControl();}this._oSectionInfo={};this._aSectionBases=[];};
o.prototype._registerSectionBaseInfo=function(s){this._oSectionInfo[s.getId()]={$dom:[],positionTop:0,positionTopMobile:0,buttonId:"",isSection:(s instanceof b),sectionReference:s};this._aSectionBases.push(s);};
o.prototype._triggerVisibleSubSectionsEvents=function(){this._bDelayDOMBasedCalculations=false;if(this.getEnableLazyLoading()&&this._oLazyLoading){this._oLazyLoading._triggerVisibleSubSectionsEvents();}};
o.prototype.scrollToSection=function(I,r,s,t,u){var v=this.oCore.byId(I),w;if(!this.getDomRef()){h.warning("scrollToSection can only be used after the ObjectPage is rendered",this);return;}if(!v){h.warning("scrollToSection aborted: unknown section",I,this);return;}if(!this._oSectionInfo[I]){h.warning("scrollToSection aborted: section is hidden by UX rules",I,this);return;}if(this.bIsDestroyed){h.debug("ObjectPageLayout :: scrollToSection","scrolling canceled as page is being destroyed");return;}if(this.getUseIconTabBar()){var x=b._getClosestSection(v);var W=this._bAllContentFitsContainer,F;this._bAllContentFitsContainer=this._hasSingleVisibleFullscreenSubSection(x);this._toggleScrolling(!this._bAllContentFitsContainer);F=this._bAllContentFitsContainer!==W;if(F&&!this._bHeaderExpanded){this._snapHeader(!this._bAllContentFitsContainer);this._bSupressModifyOnScrollOnce=true;}if(this._oCurrentTabSection){this._oCurrentTabSection._allowPropagationToLoadedViews(false);}x._allowPropagationToLoadedViews(true);this._setCurrentTabSection(v);this.getAggregation("_anchorBar").setSelectedButton(this._oSectionInfo[x.getId()].buttonId);this.setAssociation("selectedSection",x.getId(),true);}if(t){this.fireNavigate({section:b._getClosestSection(v),subSection:v instanceof c?v:v.getSubSections()[0]});}if(this._bHeaderInTitleArea&&!this._shouldPreserveHeaderInTitleArea()&&!this._bAllContentFitsContainer){this._moveHeaderToContentArea();this._toggleHeaderTitle(false);this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();}s=s||0;v._expandSection();this._requestAdjustLayout(true);r=this._computeScrollDuration(r,v);var y=this._computeScrollPosition(v);if(this._sCurrentScrollId!=I||u){this._sCurrentScrollId=I;if(this._iCurrentScrollTimeout){clearTimeout(this._iCurrentScrollTimeout);if(this._$contentContainer){this._$contentContainer.parent().stop(true,false);}}if(this._bDomElementsCached){this._iCurrentScrollTimeout=setTimeout(function(){this._sCurrentScrollId=undefined;this._iCurrentScrollTimeout=undefined;}.bind(this),r);}this._preloadSectionsOnBeforeScroll(v);this.getHeaderTitle()&&this._shiftHeaderTitle();y+=s;if(!this._bStickyAnchorBar&&this._shouldSnapHeaderOnScroll(y)){w=this._getSnapPosition();this._scrollTo(w,0);if(w===0){this._toggleHeader(true);}}this._scrollTo(y,r);}};
o.prototype._hasSingleVisibleFullscreenSubSection=function(s){var v=s.getSubSections().filter(function(r){return r.getVisible()&&r._getInternalVisible()&&(r.getBlocks().length>0);});return(v.length===1)&&v[0].hasStyleClass(c.FIT_CONTAINER_CLASS);};
o.prototype._computeScrollDuration=function(r,t){var s=parseInt(r);s=s>=0?s:this._iScrollToSectionDuration;if(this.getUseIconTabBar()&&((t instanceof b)||this._isFirstVisibleSectionBase(t))&&this._bStickyAnchorBar){s=0;}return s;};
o.prototype._computeScrollPosition=function(t){var F=t&&(t instanceof b),I=t.getId(),s=this._bMobileScenario||F?this._oSectionInfo[I].positionTopMobile:this._oSectionInfo[I].positionTop,E=!this._bStickyAnchorBar;if(E&&this._isFirstVisibleSectionBase(t)){s=0;}return s;};
o.prototype._preloadSectionsOnBeforeScroll=function(t){var I=t.getId(),r;if(!this.getEnableLazyLoading()&&this.getUseIconTabBar()){r=(t instanceof b)?t:t.getParent();this._connectModelsForSections([r]);}if(this.getEnableLazyLoading()){var s=this.getUseIconTabBar()?this._grepCurrentTabSectionBases():this._aSectionBases;r=this._oLazyLoading.getSubsectionsToPreload(s,I);if(D.system.desktop){setTimeout(function(){this._connectModelsForSections(r);}.bind(this),50);}else{this._connectModelsForSections(r);}r.forEach(function(u){this.fireEvent("subSectionEnteredViewPort",{subSection:u});},this);}};
o.prototype.getScrollingSectionId=function(){return this._sScrolledSectionId;};
o.prototype.setDirectScrollingToSection=function(s){this.sDirectSectionId=s;};
o.prototype.getDirectScrollingToSection=function(){return this.sDirectSectionId;};
o.prototype.clearDirectScrollingToSection=function(){this.sDirectSectionId=null;};
o.prototype._scrollTo=function(y,t){if(this._oScroller&&this._bDomReady&&!this._bSuppressScroll){h.debug("ObjectPageLayout :: scrolling to "+y);if((t===0)&&this._shouldSnapHeaderOnScroll(y)){this._toggleHeader(true);}this._oScroller.scrollTo(0,y,t);}return this;};
o.prototype._scrollBelowCollapseVisualIndicator=function(){var H=this._getHeaderContent(),$,r,v,s;if(!p(H)||!p(this._$opWrapper)){return;}$=H._getCollapseButton().getDomRef();r=$.getBoundingClientRect().height;v=this._$opWrapper[0].getBoundingClientRect().height;s=$.offsetTop+r-v;this._scrollTo(s);};
o.prototype._updateMedia=function(w,r){var u=function(s){Object.keys(r).forEach(function(t){var v=r[t],E=s===v;this.toggleStyleClass(v,E);},this);}.bind(this),B=o.BREAK_POINTS;if(w<=B.PHONE){u(r.PHONE);}else if(w<=B.TABLET){u(r.TABLET);}else{u(r.DESKTOP);}};
o.prototype._updateScreenHeightSectionBasesAndSpacer=function(){var r,s,t,P,u,v,w=!this._bHeaderExpanded,I,x,y,z=this.getDomRef(),U=this.getUseIconTabBar();if(!z||!this._bDomReady){return false;}h.debug("ObjectPageLayout :: _updateScreenHeightSectionBasesAndSpacer","re-evaluating dom positions");this.iScreenHeight=this._getDOMRefHeight(z);if(this.iScreenHeight===0){return;}this.iFooterHeight=this._getFooterHeight();var B=-1;this._aSectionBases.forEach(function(E){var F=this._oSectionInfo[E.getId()],$=E.$(),G,H=false;if(!F||!$.length){return;}if(!F.isSection){B++;}F.$dom=$;var J=$.position().top;F.positionTop=Math.ceil(J);if(F.isSection){G=E.$("header");}else{G=E.$("headerTitle");}H=G.length===0;if(!H){F.positionTopMobile=Math.ceil(G.position().top)+G.outerHeight();}else{F.positionTopMobile=F.positionTop;}if(!this._bStickyAnchorBar&&!this._bHeaderInTitleArea){F.positionTopMobile-=this.iAnchorBarHeight;F.positionTop-=this.iAnchorBarHeight;}F.sectionReference.toggleStyleClass("sapUxAPObjectPageSubSectionPromoted",H);if(this._bMobileScenario){var N=this.oCore.byId(E.getId()).getParent();if(N instanceof b&&N._getIsHidden()){return;}if(u){this._oSectionInfo[u].positionBottom=F.positionTop;}u=E.getId();s=E;}else{if(F.isSection){if(u){this._oSectionInfo[u].positionBottom=F.positionTop;if(P){this._oSectionInfo[P].positionBottom=F.positionTop;}}u=E.getId();P=null;}else{if(P){this._oSectionInfo[P].positionBottom=F.positionTop;}P=E.getId();s=E;}}if(!F.isSection){x=U||(E.getParent()===this._oFirstVisibleSection);I=x&&(B===0);y=E.hasStyleClass(c.FIT_CONTAINER_CLASS);E._setHeight(this._computeSubSectionHeight(I,y,F.positionTop));}},this);if(s){r=this._computeLastVisibleHeight(s);if(this._bMobileScenario&&u){this._oSectionInfo[u].positionBottom=this._oSectionInfo[u].positionTop+r;}else{if(P){this._oSectionInfo[P].positionBottom=this._oSectionInfo[P].positionTop+r;}if(u&&P){this._oSectionInfo[u].positionBottom=this._oSectionInfo[P].positionTop+r;}}v=this._bStickyAnchorBar||(B>0)||this._checkContentBottomRequiresSnap(s);if(this._bAllContentFitsContainer){v=false;}if(v&&!this._shouldPreserveHeaderInTitleArea()){w=true;}t=this._computeSpacerHeight(s,r,v,w);this._$spacer.height(t+"px");h.debug("ObjectPageLayout :: bottom spacer is now "+t+"px");}this._updateCustomScrollerHeight(w);this._setSectionInfoIsDirty(false);return true;};
o.prototype._computeSubSectionHeight=function(F,r,s){var t,u;if(!r){return"";}var I=(this._bAllContentFitsContainer)?this._bHeaderExpanded:F;t=this._getSectionsContainerHeight(!I);if(this._bAllContentFitsContainer){u=(s-this.iHeaderContentHeight)+this.iFooterHeight;t-=u;}return t+"px";};
o.prototype._updateCustomScrollerHeight=function(r){if(D.system.desktop&&this.getAggregation("_customScrollBar")){var s=this._computeScrollableContentSize(r);s+=this._getStickyAreaHeight(r);this._getCustomScrollBar().setContentSize(s+"px");var t=(s>Math.ceil(this.iScreenHeight)),v=(t!==this._getCustomScrollBar().getVisible());if(v){this._getCustomScrollBar().setVisible(t);this.getHeaderTitle()&&this._shiftHeaderTitle();}}};
o.prototype._computeScrollableContentSize=function(s){var r=0;if(this._$contentContainer&&this._$contentContainer.length){r=this._$contentContainer[0].scrollHeight;}if(!this._bStickyAnchorBar&&s){r-=this.iAnchorBarHeight;}if(this._bStickyAnchorBar&&!s){r+=this.iAnchorBarHeight;}return r;};
o.prototype._computeLastVisibleHeight=function(r){var I=this._bStickyAnchorBar||this._bHeaderInTitleArea;var s=this._getSectionPositionTop(r,I);return this._$spacer.position().top-s;};
o.prototype._getStickyAreaHeight=function(I){if(I){return this.iHeaderTitleHeightStickied+this.iAnchorBarHeight;}return this.iHeaderTitleHeight;};
o.prototype._getScrollableViewportHeight=function(I){return this.getDomRef().getBoundingClientRect().height-this._getStickyAreaHeight(I);};
o.prototype._getSectionsContainerHeight=function(I){var s=this._getScrollableViewportHeight(I);if(!I){s-=(this.iHeaderContentHeight+this.iAnchorBarHeight);}return s;};
o.prototype._getSectionPositionTop=function(s,r){var P=s.$().position().top;if(!this._bStickyAnchorBar&&!this._bHeaderInTitleArea&&r){P-=this.iAnchorBarHeight;}return P;};
o.prototype._getSectionPositionBottom=function(s,r){var P=this._oSectionInfo[s.getId()].positionBottom;if(!r){P+=this.iAnchorBarHeight;}return P;};
o.prototype._determineSectionBaseInternalTitleLevel=function(s){var r=this.getSectionTitleLevel(),I=s instanceof b;if(r===k.Auto){return I?k.H3:k.H4;}return I?r:o._getNextTitleLevelEntry(r);};
o.prototype._shouldApplySectionTitleLevel=function(s){return s.getTitleLevel()===k.Auto;};
o.prototype._checkContentBottomRequiresSnap=function(s){var r=false;return this._getSectionPositionBottom(s,r)>(this._getScrollableViewportHeight(r)+this._getSnapPosition());};
o.prototype._computeSpacerHeight=function(r,s,t,u){var v,w;w=this._getScrollableViewportHeight(u);if(!t){s=this._getSectionPositionBottom(r,false);}if(s<w){v=w-s;if(this._bMobileScenario){v+=(this._oSectionInfo[r.getId()].positionTopMobile-this._oSectionInfo[r.getId()].positionTop);}}else{v=0;}if((this.iFooterHeight>v)){v+=this.iFooterHeight;}return v;};
o.prototype._isFirstVisibleSectionBase=function(s){var r,t,F,u=this.getSelectedSection(),U=this.getUseIconTabBar();if(!s||!s.getParent()){return;}r=s.getId();if(U&&(r===u)){return true;}if(U&&(s.getParent().getId()===u)){t=sap.ui.getCore().byId(u);F=this._getFirstVisibleSubSection(t);return F&&(F.getId()===r);}if(this._oFirstVisibleSection&&this._oFirstVisibleSubSection){return r===this._oFirstVisibleSection.getId()||r===this._oFirstVisibleSubSection.getId();}return false;};
o.prototype._getFirstVisibleSubSection=function(s){if(!s){return;}var F;this._aSectionBases.every(function(r){if(r.getParent()&&(r.getParent().getId()===s.getId())){F=r;return false;}return true;});return F;};
o.prototype._initAnchorBarScroll=function(){var s=this.oCore.byId(this.getSelectedSection()),r;this._requestAdjustLayout(true);r=s?this._computeScrollPosition(s):0;this._sScrolledSectionId="";this._sCurrentScrollId="";this._onScroll({target:{scrollTop:r}},true);};
o.prototype._setAsCurrentSection=function(s){var r,t,u;if(this._sScrolledSectionId===s){return;}h.debug("ObjectPageLayout :: current section is "+s);this._sScrolledSectionId=s;r=this.getAggregation("_anchorBar");if(r&&this._getInternalAnchorBarVisible()){t=this.oCore.byId(s);u=t&&t instanceof c&&(t.getTitle().trim()===""||!t._getInternalTitleVisible()||t.getParent()._getIsHidden());if(u){s=t.getParent().getId();h.debug("ObjectPageLayout :: current section is a subSection with an empty or hidden title, selecting parent "+s);}if(t&&this._oSectionInfo[s]){r.setSelectedButton(this._oSectionInfo[s].buttonId);this.setAssociation("selectedSection",b._getClosestSection(s).getId(),true);this._setSectionsFocusValues(s);}}};
o.prototype._registerOnContentResize=function(){var $=this._$contentContainer.length&&this._$contentContainer[0];if(!$){return;}if(this._iContentResizeId){R.deregister(this._iContentResizeId);}this._iContentResizeId=R.register($,this._onUpdateContentSize.bind(this));};
o.prototype._onUpdateContentSize=function(E){var s;if(this._preserveHeaderStateOnScroll()){this._overridePreserveHeaderStateOnScroll();}this._adjustHeaderHeights();this._requestAdjustLayout().then(function(){s=this._$opWrapper.scrollTop();this._updateSelectionOnScroll(s);}.bind(this));};
o.prototype._onUpdateScreenSize=function(E){var t=this.getHeaderTitle(),H=this._getHeaderContent(),r=E.size.width,s=E.size.height,u=E.oldSize.height,v=(s!==u),w,I=H&&H.supportsAlwaysExpanded()&&this.getAlwaysShowContentHeader();if(E.size.height===0||E.size.width===0){h.info("ObjectPageLayout :: not triggering calculations if height or width is 0");return;}if(!this._bDomReady){h.info("ObjectPageLayout :: cannot _onUpdateScreenSize before dom is ready");return;}this._oLazyLoading.setLazyLoadingParameters();setTimeout(function(){this._bMobileScenario=l.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange());this._bTabletScenario=l.Utilities.isTabletScenario(this._getCurrentMediaContainerRange());if(I&&(this._bHeaderInTitleArea!=this._checkAlwaysShowContentHeader())){this.invalidate();}if(this._bHeaderInTitleArea&&this._headerBiggerThanAllowedToBeExpandedInTitleArea()){this._expandHeader(false);this._scrollTo(0,0);}if(t&&t.isDynamic()){t._onResize(r);this._updateMedia(r,o.DYNAMIC_HEADERS_MEDIA);}this._updateMedia(r,o.MEDIA);this._adjustHeaderHeights();this._requestAdjustLayout(true);if(this.getFooter()&&this.getShowFooter()){this._shiftFooter();}w=this.getSelectedSection();if((u===0)&&v&&!this._isClosestScrolledSection(w)){this.scrollToSection(w,0);}this._scrollTo(this._$opWrapper.scrollTop(),0);if((u===0)&&v&&this.getEnableLazyLoading()&&this._oLazyLoading&&!this._bDelayDOMBasedCalculations){this._oLazyLoading.doLazyLoading();}}.bind(this),this._getDOMCalculationDelay());};
o.prototype._onUpdateHeaderTitleSize=function(E){if(E.size.height===0||E.size.width===0){h.info("ObjectPageLayout :: not triggering calculations if height or width is 0");return;}if(!this._bDomReady){h.info("ObjectPageLayout :: cannot _onUpdateTitleSize before dom is ready");return;}this._adjustHeaderHeights();this._requestAdjustLayout();};
o.prototype._shouldSnapHeaderOnScroll=function(s){return(s>0)&&(s>=this._getSnapPosition())&&!this._shouldPreserveHeaderInTitleArea();};
o.prototype._getScrollableContentLength=function(){return this._$contentContainer.length?this._getDOMRefHeight(this._$contentContainer[0]):0;};
o.prototype._isContentScrolledToBottom=function(){return this._oLastScrollState.iScrollableContentLength<=(this._oLastScrollState.iScrollTop+this._oLastScrollState.iScrollableViewportHeight);};
o.prototype._isContentLengthDecreased=function(P){if(P){return((P.iScrollableContentLength>this._oLastScrollState.iScrollableContentLength)&&(P.iSpacerHeight===this._oLastScrollState.iSpacerHeight));}};
o.prototype._canReachScrollTop=function(r,E){var s;E=E||0;s=this._oLastScrollState.iScrollableContentLength+E-this._oLastScrollState.iScrollableViewportHeight;return s>=r;};
o.prototype._deregisterCustomEvents=function(){if(this._$opWrapper.length){this._$opWrapper.off(".OPL");}};
o.prototype._deregisterScreenSizeListener=function(){if(this._iResizeId){R.deregister(this._iResizeId);this._iResizeId=null;}};
o.prototype._onScroll=function(E,I){var s=Math.max(Math.ceil(E.target.scrollTop),0),$=this._$opWrapper.length&&this._$opWrapper[0],r=this._$spacer.length&&this._$spacer[0],t=r.offsetHeight,P,H=this.getHeaderTitle(),u=this._shouldSnapHeaderOnScroll(s),v=this._shouldPreserveHeaderInTitleArea(),w=false,x=this._oLastScrollState;this._oLastScrollState={iScrollTop:s,iScrollableContentLength:Math.ceil(this._getScrollableContentLength()),iScrollableViewportHeight:$.offsetHeight,iSpacerHeight:t};if(this._bSupressModifyOnScrollOnce){this._bSupressModifyOnScrollOnce=false;return;}if(!$||!r){return;}P=this.iScreenHeight;if(P===0){return;}if(this._getSectionInfoIsDirty()){return;}if(x&&this._isContentScrolledToBottom()&&this._isContentLengthDecreased(x)){var y=x.iScrollableContentLength-this._oLastScrollState.iScrollableContentLength;if(!this._canReachScrollTop(x.iScrollTop)&&this._canReachScrollTop(x.iScrollTop,y)){var N=t+y;this._$spacer.height(N+"px");this._scrollTo(x.iScrollTop);return;}}if(u&&!v){P-=(this.iAnchorBarHeight+this.iHeaderTitleHeightStickied);}if(this._bHeaderInTitleArea&&!v){this._moveHeaderToContentArea();this._toggleHeaderTitle(false);this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();this._requestAdjustLayout();}if(!v&&((H&&this.getShowHeaderContent())||this.getShowAnchorBar())){this._toggleHeader(u,!!(E&&E.type==="scroll"));}if(!v){this._adjustHeaderTitleBackgroundPosition(s);}h.debug("ObjectPageLayout :: lazy loading : Scrolling at "+s,"----------------------------------------");this._updateSelectionOnScroll(s);if(this.getEnableLazyLoading()){this._oLazyLoading.lazyLoadDuringScroll(I,s,E.timeStamp,P);}if(H&&H.supportsTitleInHeaderContent()&&this.getShowHeaderContent()&&this.getShowTitleInHeaderContent()&&H.getShowTitleSelector()){if(s===0){q(document.getElementById(this.getId()+"-scroll")).css("z-index","1000");w=false;}else if(!w){w=true;q(document.getElementById(this.getId()+"-scroll")).css("z-index","0");}}};
o.prototype._updateSelectionOnScroll=function(s){var P=this.iScreenHeight,r,t;if(P===0){return;}r=this._getClosestScrolledSectionId(s,P);t=this._getClosestScrolledSectionId(s,P,true);if(r){var u=this.getDirectScrollingToSection();if(r!==this._sScrolledSectionId){h.debug("ObjectPageLayout :: closest id "+r,"----------------------------------------");var u=this.getDirectScrollingToSection();if(u&&u!==r){return;}this.clearDirectScrollingToSection();this._setAsCurrentSection(r);}else if(r===this.getDirectScrollingToSection()){this.clearDirectScrollingToSection();}if(t!==this._sScrolledSubSectionId){this._sScrolledSubSectionId=t;this.fireEvent("_sectionChange",{section:this.oCore.byId(r),subSection:this.oCore.byId(t)});}}};
o.prototype._getSnapPosition=function(){var s=this.iHeaderContentHeight,t=this.iHeaderTitleHeightStickied-this.iHeaderTitleHeight;if(t<o.MAX_SNAP_POSITION_OFFSET){s-=t;}return s;};
o.prototype._getClosestScrolledSectionId=function(s,P,r){r=!!r;s=Math.ceil(s);var t=s+P,u,v=r||this._bMobileScenario;q.each(this._oSectionInfo,function(I,w){var x,y,z,B,E,F=this.getSelectedSection();x=this.oCore.byId(I);if(!x){return;}y=x.getParent();z=y instanceof b&&y._getIsHidden();if(this.getUseIconTabBar()&&F){E=this.oCore.byId(F);if(!E){return;}if(w.isSection&&w.sectionReference!=E){return true;}if(!w.isSection&&E.indexOfSubSection(w.sectionReference)<0){return true;}}if(w.isSection||(v&&!z)){if(!u&&(w.sectionReference._getInternalVisible()===true)){B=this._getFirstVisibleSubSection(w.sectionReference);if(w.isSection&&r&&B){u=B.getId();}else{u=I;}}if(w.isSection&&r){return true;}if(w.positionTop<=t&&s<=w.positionBottom){if(w.positionTop<=s&&w.positionBottom>s){u=I;return false;}}}}.bind(this));return u;};
o.prototype._toggleHeader=function(s,u){var H;if(s===this._bStickyAnchorBar){return;}H=this.getHeaderTitle();if(!this._shouldPreserveHeaderInTitleArea()&&!this._bHeaderInTitleArea){this._toggleHeaderTitle(!s,u);}if(!this._bStickyAnchorBar&&s){this._restoreFocusAfter(this._moveAnchorBarToTitleArea);H&&H.snap();this._bHeaderExpanded=false;this._adjustHeaderHeights();this._updateToggleHeaderVisualIndicators();}else if(this._bStickyAnchorBar&&!s){this._restoreFocusAfter(this._moveAnchorBarToContentArea);H&&H.unSnap();this._bHeaderExpanded=true;this._adjustHeaderHeights();this._updateToggleHeaderVisualIndicators();}};
o.prototype._restoreFocusAfter=function(r){var s=this.oCore.byId(this.oCore.getCurrentFocusedControlId());r.call(this);if(D.system.phone!==true){if(!this.oCore.byId(this.oCore.getCurrentFocusedControlId())){s&&s.$().focus();}}return this;};
o.prototype._moveAnchorBarToTitleArea=function(){this._$anchorBar.children().appendTo(this._$stickyAnchorBar);this._toggleHeaderStyleRules(true);if(this.iHeaderTitleHeight!=this.iHeaderTitleHeightStickied){this._adjustHeaderBackgroundSize();}return this;};
o.prototype._moveAnchorBarToContentArea=function(){if(!this._shouldPreserveHeaderInTitleArea()){var s=this._$opWrapper.scrollTop();this._$anchorBar.css("height","auto").append(this._$stickyAnchorBar.children());this._$opWrapper.scrollTop(s);this._toggleHeaderStyleRules(false);}return this;};
o.prototype._toggleHeaderStyleRules=function(s){s=!!s;var v=s?"hidden":"inherit";this._bStickyAnchorBar=s;this._$headerContent.css("overflow",v);this._$headerContent.toggleClass("sapContrastPlus",!s);this._$headerContent.toggleClass("sapUxAPObjectPageHeaderDetailsHidden",s);this._$anchorBar.css("visibility",v);if(p(this._$stickyAnchorBar)){this._$stickyAnchorBar.attr("aria-hidden",!s);}this.fireToggleAnchorBar({fixed:s});if(!s&&!this.iAnchorBarHeight){this._requestAdjustLayout();}};
o.prototype.getScrollDelegate=function(){return this._oScroller;};
o.prototype.setHeaderTitle=function(H,s){if(H&&typeof H.addEventDelegate==="function"){H.addEventDelegate({onAfterRendering:this._adjustHeaderHeights.bind(this)});}this.setAggregation("headerTitle",H,s);this._oObserver&&this._oObserver.disconnect();this._oObserver=new M(this._onModifyHeaderTitle.bind(this));this._oObserver.observe(H,{aggregations:["headerTitle"],properties:["backgroundDesign"]});if(H){this._createHeaderContent();}return this;};
o.prototype._onModifyHeaderTitle=function(r){var H=this.getAggregation("_headerContent");H&&r.current&&H.setBackgroundDesign(r.current);};
o.prototype.invalidate=function(r){if(this.getUseIconTabBar()&&r&&(r instanceof b)&&!r.isActive()&&this._oSectionInfo[r.getId()]){return;}if(this._iAfterRenderingDomReadyTimeout){clearTimeout(this._iAfterRenderingDomReadyTimeout);}a.prototype.invalidate.apply(this,arguments);};
o.prototype._createHeaderContent=function(){var H=this.getHeaderTitle(),s=H&&H.supportsBackgroundDesign()&&H.getBackgroundDesign(),r=this.getAggregation("_headerContent"),t,N;var u=H?H.getCompatibleHeaderContentClass():d;if(!(r instanceof u)){t=this.getAggregation("_headerContent");if(t){t.destroy();}N=u.createInstance(this.getAggregation("headerContent"),this.getShowHeaderContent(),this._getHeaderDesign(),this.getHeaderContentPinnable(),this.getId()+"-OPHeaderContent");s&&N.setBackgroundDesign(s);this.setAggregation("_headerContent",N,true);}};
o.prototype._adjustHeaderBackgroundSize=function(){var H=this.getHeaderTitle();if(H&&H.getHeaderDesign()=="Dark"){if(!this._shouldPreserveHeaderInTitleArea()){this.iTotalHeaderSize=this.iHeaderTitleHeight+this.iHeaderContentHeight;this._$headerContent.css("background-size","100% "+this.iTotalHeaderSize+"px");}else{this.iTotalHeaderSize=this.iHeaderTitleHeight-this._$stickyAnchorBar.height();this._$stickyHeaderContent.css("background-size","100% "+this.iTotalHeaderSize+"px");}H.$().css("background-size","100% "+this.iTotalHeaderSize+"px");this._adjustHeaderTitleBackgroundPosition(0);}};
o.prototype._adjustHeaderTitleBackgroundPosition=function(s){var H=this.getHeaderTitle();if(H&&H.getHeaderDesign()=="Dark"){if(this._bStickyAnchorBar){H.$().css("background-position","0px "+((this.iTotalHeaderSize-this.iHeaderTitleHeightStickied)*-1)+"px");}else{if(this._shouldPreserveHeaderInTitleArea()){H.$().css("background-position","0px 0px");}else{H.$().css("background-position","0px "+(this.iHeaderTitleHeight+this.iHeaderContentHeight-this.iTotalHeaderSize-s)+"px");}}}};
o.prototype._adjustHeaderHeights=function(){var t=this.getHeaderTitle(),P=true;if(t&&!t.supportsAdaptLayoutForDomElement()){P=false;}if(this._$titleArea.length>0){this.iHeaderContentHeight=this._$headerContent.length?Math.ceil(this._getDOMRefHeight(this._$headerContent[0])):0;this.iStickyHeaderContentHeight=this._$stickyHeaderContent.height();this.iAnchorBarHeight=this._bStickyAnchorBar?this._$stickyAnchorBar.outerHeight():this._$anchorBar.outerHeight();if(!this._bHeaderExpanded){this.iHeaderTitleHeightStickied=this._$titleArea.height()-this.iAnchorBarHeight;this.iHeaderTitleHeight=this._obtainExpandedTitleHeight(P);}else{this.iHeaderTitleHeight=this._$titleArea.is(":visible")?this._$titleArea.height():0;this.iHeaderTitleHeightStickied=this._obtainSnappedTitleHeight(P);}this._adjustHeaderBackgroundSize();h.info("ObjectPageLayout :: adjustHeaderHeight","headerTitleHeight: "+this.iHeaderTitleHeight+" - headerTitleStickiedHeight: "+this.iHeaderTitleHeightStickied+" - headerContentHeight: "+this.iHeaderContentHeight);}else{h.debug("ObjectPageLayout :: adjustHeaderHeight","skipped as the objectPageLayout is being rendered");}};
o.prototype._appendTitleCloneToDOM=function(E){var $=this.getHeaderTitle().$(),r=$.clone();r.css({left:"-10000px",top:"-10000px",width:$.width()+"px",position:"absolute"});r.toggleClass("sapUxAPObjectPageHeaderStickied",E);r.appendTo(this._$titleArea.parent());if(E){this.getHeaderTitle()&&this.getHeaderTitle()._adaptLayoutForDomElement(r);}return r;};
o.prototype._obtainSnappedTitleHeight=function(v){var t=this.getHeaderTitle(),$,H;if(!t){return 0;}if(v){$=this._appendTitleCloneToDOM(true);H=$.height();$.remove();}else if(t.snap){H=this._obtainTitleHeightViaStateChange(true);}return H;};
o.prototype._obtainExpandedTitleHeight=function(v){var t=this.getHeaderTitle(),$,H;if(!t){return 0;}if(v){$=this._appendTitleCloneToDOM(false);H=$.is(":visible")?$.height()-this.iAnchorBarHeight:0;$.remove();}else if(t.unSnap){H=this._obtainTitleHeightViaStateChange(false);}return H;};
o.prototype._obtainTitleHeightViaStateChange=function(s){var t=this.getHeaderTitle(),H,r=this._$sectionsContainer.height(),u,v=(s)?t.snap:t.unSnap,w=(s)?t.unSnap:t.snap;v.call(t,false);H=t.$().outerHeight();w.call(t,false);u=this._$sectionsContainer.height();this._adjustSpacerHeightUponUnsnapping(r,u);return H;};
o.prototype._adjustSpacerHeightUponUnsnapping=function(s,r){var t;if(s!=r){t=this._$spacer.height()-(r-s);this._$spacer.height(t);}};
o.prototype._getHeaderDesign=function(){var H=this.getHeaderTitle(),s=l.ObjectPageHeaderDesign.Light;if(H!=null){s=H.getHeaderDesign();}return s;};
o.prototype._getVisibleSections=function(){return this.getSections().filter(function(s){return s.getVisible()&&s._getInternalVisible();});};
o.prototype._setSectionsFocusValues=function(s){var r=this._getVisibleSections()||[],$,F='0',N='-1',t="tabindex",u,v=r[0];r.forEach(function(w){$=w.$();if(s===w.sId){$.attr(t,F);u=w;w._setSubSectionsFocusValues();}else{$.attr(t,N);w._disableSubSectionsFocus();}});if(!u&&r.length>0){v.$().attr(t,F);v._setSubSectionsFocusValues();u=v;}return u;};
o.prototype.setShowHeaderContent=function(s){var r=this.getShowHeaderContent(),H;if(r!==s){if(r&&this._bHeaderInTitleArea&&!this._shouldPreserveHeaderInTitleArea()){this._moveHeaderToContentArea();this._toggleHeaderTitle(false);}this.setProperty("showHeaderContent",s);H=this._getHeaderContent();if(H){H.setProperty("visible",s);}}return this;};
o.prototype._headerTitleChangeHandler=function(I){var r;if(!this.getShowTitleInHeaderContent()){return;}if(I){this._getHeaderContent()._destroyObjectImage(true);}r=this.oCore.createRenderManager();this.getRenderer()._rerenderHeaderContentArea(r,this);this._getHeaderContent().invalidate();r.destroy();};
o.prototype.getHeaderContent=function(){if(!this._getHeaderContent()){return this.getAggregation("headerContent",[]);}return this._getHeaderContent().getAggregation("content",[]);};
o.prototype.insertHeaderContent=function(r,I,s){if(!this._getHeaderContent()){return this.insertAggregation("headerContent",r,I,s);}return this._getHeaderContent().insertAggregation("content",r,I,s);};
o.prototype.addHeaderContent=function(r,s){if(!this._getHeaderContent()){return this.addAggregation("headerContent",r,s);}return this._getHeaderContent().addAggregation("content",r,s);};
o.prototype.removeAllHeaderContent=function(s){if(!this._getHeaderContent()){return this.removeAllAggregation("headerContent",s);}return this._getHeaderContent().removeAllAggregation("content",s);};
o.prototype.removeHeaderContent=function(r,s){if(!this._getHeaderContent()){return this.removeAggregation("headerContent",r,s);}return this._getHeaderContent().removeAggregation("content",r,s);};
o.prototype.destroyHeaderContent=function(s){if(!this._getHeaderContent()){return this.destroyAggregation("headerContent",s);}return this._getHeaderContent().destroyAggregation("content",s);};
o.prototype.indexOfHeaderContent=function(r){if(!this._getHeaderContent()){return this.indexOfAggregation("headerContent",r);}return this._getHeaderContent().indexOfAggregation("content",r);};
o.prototype._getHeaderContent=function(){return this.getAggregation("_headerContent");};
o.prototype._connectModelsForSections=function(s){s=s||[];s.forEach(function(r){r.connectToModels();});};
o.prototype._getHeightRelatedParameters=function(){return{iHeaderContentHeight:this.iHeaderContentHeight,iScreenHeight:this.iScreenHeight,iAnchorBarHeight:this.iAnchorBarHeight,iHeaderTitleHeightStickied:this.iHeaderTitleHeightStickied,iStickyHeaderContentHeight:this.iStickyHeaderContentHeight,iScrollTop:this._$opWrapper.scrollTop()};};
o.prototype._hasVerticalScrollBar=function(){return(this._getCustomScrollBar().getVisible()===true);};
o.prototype._shiftHeaderTitle=function(){var s=this._calculateShiftOffset(),r=s.sStyleAttribute,P=s.iMarginalsOffset;this.$().find(".sapUxAPObjectPageHeaderTitle").css("padding-"+r,P+"px");};
o.prototype._isFirstSection=function(s){var r=this._getVisibleSections();if(s===r[0]){return true;}return false;};
o.prototype._isValidStoredSubSectionInfo=function(){var s=this.getSelectedSection(),r=this.oCore.byId(s),t;if(!r||!this._oStoredScrolledSubSectionInfo){return false;}t=this.oCore.byId(this._oStoredScrolledSubSectionInfo.sSubSectionId);return t&&this._sectionCanBeRenderedByUXRules(t)&&(r.indexOfSubSection(t)>=0);};
o.prototype._restoreScrollPosition=function(){var v=this._isValidStoredSubSectionInfo(),r;if(v){r=this._computeScrollPosition(this.oCore.byId(this._oStoredScrolledSubSectionInfo.sSubSectionId))+this._oStoredScrolledSubSectionInfo.iOffset;this._scrollTo(r,0);}else{this.scrollToSection(this.getSelectedSection(),0);}};
o.prototype._storeScrollLocation=function(){if(!this.getDomRef()||!this._bDomReady||!this._oScroller){return;}var s=this._oScroller.getScrollTop(),r=this._getClosestScrolledSectionId(this._oScroller.getScrollTop(),this.iScreenHeight,true),t;if(r){t=s-this._computeScrollPosition(this.oCore.byId(r));}this._iStoredScrollTop=s;this._oStoredScrolledSubSectionInfo={sSubSectionId:r,iOffset:t};this._oCurrentTabSection=null;};
o.prototype.onkeyup=function(E){var F,r;if(E.which===K.TAB){F=this.oCore.getCurrentFocusedControlId();r=F&&this.oCore.byId(F);if(r&&this._isFirstSection(r)){this._scrollTo(0,0);}}};
o.prototype.setShowFooter=function(s){var r=this.setProperty("showFooter",s,true);this._toggleFooter(s);return r;};
o.prototype._toggleFooter=function(s){var u,F=this.getFooter();if(!p(F)||!p(this._$footerWrapper)){return;}u=this.oCore.getConfiguration().getAnimationMode()!==C.AnimationMode.none;if(u){this._toggleFooterAnimation(s,F);}else{this._$footerWrapper.toggleClass("sapUiHidden",!s);}this._requestAdjustLayout();};
o.prototype._toggleFooterAnimation=function(s,F){this._$footerWrapper.bind("webkitAnimationEnd animationend",this._onToggleFooterAnimationEnd.bind(this,F));this._bIsFooterAanimationGoing=true;if(s){this._$footerWrapper.removeClass("sapUiHidden");}F.toggleStyleClass(o.SHOW_FOOTER_CLASS_NAME,s);F.toggleStyleClass(o.HIDE_FOOTER_CLASS_NAME,!s);};
o.prototype._onToggleFooterAnimationEnd=function(F){this._$footerWrapper.unbind("webkitAnimationEnd animationend");if(F.hasStyleClass(o.HIDE_FOOTER_CLASS_NAME)){this._$footerWrapper.addClass("sapUiHidden");F.removeStyleClass(o.HIDE_FOOTER_CLASS_NAME);}else{F.removeStyleClass(o.SHOW_FOOTER_CLASS_NAME);}this._bIsFooterAanimationGoing=false;};
o.prototype.clone=function(){var r,H,s;Object.keys(this.mAggregations).forEach(this._cloneProxiedAggregations,this);r=a.prototype.clone.apply(this,arguments);H=this._getHeaderContent();s=r._getHeaderContent();if(s){s.destroy();}if(H){r.setAggregation("_headerContent",H.clone(),true);}return r;};
o.prototype._cloneProxiedAggregations=function(s){var r=this.mAggregations[s];if(Array.isArray(r)&&r.length===0){r=this["get"+s.charAt(0).toUpperCase()+s.slice(1)]();}this.mAggregations[s]=r;};
o.prototype._shouldPreserveHeaderInTitleArea=function(){return this._bPinned||this._preserveHeaderStateOnScroll()||this._checkAlwaysShowContentHeader();};
o.prototype._checkAlwaysShowContentHeader=function(){return!this._hasDynamicTitle()&&!this._bMobileScenario&&!this._bTabletScenario&&this.getShowHeaderContent()&&this.getAlwaysShowContentHeader();};
o.prototype._shouldOverridePreserveHeaderStateOnScroll=function(){return!D.system.desktop&&this._headerBiggerThanAllowedToBeFixed();};
o.prototype._headerBiggerThanAllowedToBeFixed=function(){var r=this._getOwnHeight();return this._getEntireHeaderHeight()>o.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE*r;};
o.prototype._headerBiggerThanAllowedToBeExpandedInTitleArea=function(){return this._getEntireHeaderHeight()>=this._getOwnHeight();};
o.prototype._getOwnHeight=function(){return this._getHeight(this);};
o.prototype._getHeight=function(r){return!(r instanceof a)?0:r.$().outerHeight()||0;};
o.prototype._getEntireHeaderHeight=function(){var t=0,H=0,r=this.getHeaderTitle(),s=this._getHeaderContent();if(p(r)){t=r.$().outerHeight();}if(p(s)){H=s.$().outerHeight();}return t+H;};
o.prototype._onPinUnpinButtonPress=function(){if(this._bPinned){this._unPin();}else{this._pin();this._restorePinButtonFocus();}};
o.prototype._restorePinButtonFocus=function(){var H=this._getHeaderContent();if(p(H)&&H.supportsPinUnpin()){H._focusPinButton();}};
o.prototype._pin=function(){var $=this.$();if(this._bPinned){return;}this._bPinned=true;this._toggleHeaderTitle(true);this._moveAnchorBarToTitleArea();this._moveHeaderToTitleArea();this._adjustHeaderHeights();this._requestAdjustLayout();this._togglePinButtonARIAState(this._bPinned);this._updateToggleHeaderVisualIndicators();if(p($)){$.addClass("sapUxAPObjectPageLayoutHeaderPinned");}};
o.prototype._unPin=function(){var $=this.$();if(!this._bPinned){return;}this._bPinned=false;this._updateToggleHeaderVisualIndicators();this._togglePinButtonARIAState(this._bPinned);if(p($)){$.removeClass("sapUxAPObjectPageLayoutHeaderPinned");}};
o.prototype._togglePinButtonARIAState=function(P){var H=this._getHeaderContent();if(p(H)&&H.supportsPinUnpin()){H._updateARIAPinButtonState(P);}};
o.prototype._preserveHeaderStateOnScroll=function(){return this._hasDynamicTitle()&&this.getPreserveHeaderStateOnScroll()&&!this._bHeaderBiggerThanAllowedHeight;};
o.prototype._overridePreserveHeaderStateOnScroll=function(){if(!this._shouldOverridePreserveHeaderStateOnScroll()){this._bHeaderBiggerThanAllowedHeight=false;return;}this._bHeaderBiggerThanAllowedHeight=true;if(this._bHeaderExpanded){this._moveAnchorBarToContentArea();this._moveHeaderToContentArea(true);}else{this._snapHeader(true);}this._adjustHeaderHeights();this._requestAdjustLayout();};
o.prototype._hasDynamicTitle=function(){var t=this.getHeaderTitle();return t&&t.isDynamic();};
o.prototype._attachVisualIndicatorsPressHandlers=function(P,r){var t=this.getHeaderTitle(),H=this._getHeaderContent();if(p(t)&&!this._bAlreadyAttachedTitleIndicatorPressHandler){t.attachEvent(o.EVENTS.TITLE_VISUAL_INDICATOR_PRESS,function(){P.call(r);if(this._headerBiggerThanAllowedToBeExpandedInTitleArea()){this._scrollBelowCollapseVisualIndicator();}this._focusCollapseVisualIndicator();},this);this._bAlreadyAttachedTitleIndicatorPressHandler=true;}if(p(H)&&!this._bAlreadyAttachedHeaderIndicatorPressHandler){H.attachEvent(o.EVENTS.HEADER_VISUAL_INDICATOR_PRESS,function(){P.call(r);this._focusExpandVisualIndicator();},this);this._bAlreadyAttachedHeaderIndicatorPressHandler=true;}};
o.prototype._hasVisibleDynamicTitleAndHeader=function(){var t=this.getHeaderTitle(),H=this.getHeaderContent();return p(t)&&t.isDynamic()&&t.getVisible()&&p(H)&&H.length>0;};
o.prototype._hasDynamicTitleWithSnappedTitleOnMobile=function(){var t=this.getHeaderTitle();return p(t)&&t.isDynamic()&&!!t.getSnappedTitleOnMobile()&&D.system.phone;};
o.prototype._updateToggleHeaderVisualIndicators=function(){var H,r,E,s=this._hasVisibleDynamicTitleAndHeader();if(!this.getToggleHeaderOnTitleClick()||!s){r=false;E=false;}else{H=this._bHeaderExpanded;r=H;E=!H&&!this._hasDynamicTitleWithSnappedTitleOnMobile();}this._toggleCollapseVisualIndicator(r);this._toggleExpandVisualIndicator(E);};
o.prototype._updateTitleVisualState=function(){var t=this.getHeaderTitle(),r=this._hasVisibleDynamicTitleAndHeader()&&this.getToggleHeaderOnTitleClick()&&!this._hasDynamicTitleWithSnappedTitleOnMobile();this.$().toggleClass("sapUxAPObjectPageLayoutTitleClickEnabled",r);if(p(t)){t._toggleFocusableState(r);}};
o.prototype._focusCollapseVisualIndicator=function(){var r=this._getHeaderContent();if(p(r)){r._focusCollapseButton();}};
o.prototype._focusExpandVisualIndicator=function(){var r=this.getHeaderTitle();if(p(r)){r._focusExpandButton();}};
o.prototype._toggleExpandVisualIndicator=function(t){var r=this.getHeaderTitle();if(p(r)){r._toggleExpandButton(t);}};
o.prototype._toggleCollapseVisualIndicator=function(t){var r=this._getHeaderContent();if(p(r)){r._toggleCollapseButton(t);}};
o.prototype._attachVisualIndicatorMouseOverHandlers=function(r,s,t){var H=this._getHeaderContent();if(p(H)&&!this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler){H.attachEvent(o.EVENTS.VISUAL_INDICATOR_MOUSE_OVER,r,t);H.attachEvent(o.EVENTS.VISUAL_INDICATOR_MOUSE_OUT,s,t);this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler=true;}};
o.prototype._attachTitleMouseOverHandlers=function(r,s,t){var u=this.getHeaderTitle();if(p(u)&&!this._bAlreadyAttachedTitleMouseOverOutHandler){u.attachEvent(o.EVENTS.TITLE_MOUSE_OVER,r,t);u.attachEvent(o.EVENTS.TITLE_MOUSE_OUT,s,t);this._bAlreadyAttachedTitleMouseOverOutHandler=true;}};
o.prototype._suppressScroll=function(){this._bSuppressScroll=true;};
o.prototype._resumeScroll=function(){this._bSuppressScroll=false;if(this._iStoredScrollTop){this._scrollTo(this._iStoredScrollTop,0);}else{this._onScroll({target:{scrollTop:this._$opWrapper.scrollTop()}});}};
o.prototype._addHoverClass=function(){var $=this.$();if($){$.addClass("sapUxAPObjectPageLayoutTitleForceHovered");}};
o.prototype._removeHoverClass=function(){var $=this.$();if($){$.removeClass("sapUxAPObjectPageLayoutTitleForceHovered");}};
o.prototype._getHeight=function(r){return!(r instanceof a)?0:r.$().outerHeight()||0;};
o.prototype._getWidth=function(r){var s=r.getDomRef();return!(r instanceof a)?0:(s&&s.offsetWidth)||0;};
o.prototype._getSectionInfoIsDirty=function(){return this.bSectionInfoIsDirty;};
o.prototype._setSectionInfoIsDirty=function(r){this.bSectionInfoIsDirty=r;};
o.prototype._getAriaLabelText=function(E){var H=this.getHeaderTitle(),t=H?H.getTitleText():null,s;if(H&&t){s=t+" "+o._getLibraryResourceBundle().getText(E+"_ARIA_LABEL_WITH_TITLE");}else{s=o._getLibraryResourceBundle().getText(E+"_ARIA_LABEL_WITHOUT_TITLE");}return s;};
o.prototype._getFooterHeight=function(){if(this.getFooter()&&this.getShowFooter()){return this._getDOMRefHeight(this.$("footerWrapper").get(0));}return 0;};
o.prototype._getDOMRefHeight=function(r){return r.parentElement?r.getBoundingClientRect().height:0;};
o.prototype._updateAriaLabels=function(){var r=this.getLandmarkInfo(),s=this._getAriaLabelText("ROOT"),H=this._getAriaLabelText("HEADER"),N=this._getAriaLabelText("NAVIGATION"),t=this._getAriaLabelText("NAVTOOLBAR"),u=r&&r.getHeaderLabel(),v=r&&r.getRootLabel(),w=r&&r.getNavigationLabel();if(!v){this.$().attr("aria-label",s);}if(!u){this.$("headerTitle").attr("aria-label",H);}if(!w){this.$("anchorBar").attr("aria-label",N);this.$("stickyAnchorBar").attr("aria-label",N);}this.$("anchBar").attr("aria-label",t);};
o.prototype._formatLandmarkInfo=function(r,P){if(r){var s=r["get"+P+"Role"]()||"",t=r["get"+P+"Label"]()||"";if(s===m.None){s='';}return{role:s.toLowerCase(),label:t};}return{};};
o.prototype._getHeaderTag=function(r){if(r&&r.getHeaderRole()!==m.None){return o.DIV;}return o.HEADER;};
o.prototype._getFooterTag=function(r){if(r&&r.getFooterRole()!==m.None){return o.DIV;}return o.FOOTER;};
function p(v){if(arguments.length===1){return Array.isArray(v)?v.length>0:!!v;}return Array.prototype.slice.call(arguments).every(function(r){return p(r);});}
return o;});
sap.ui.predefine('sap/uxap/ObjectPageLayoutABHelper',["sap/ui/thirdparty/jquery","sap/ui/base/Metadata","sap/ui/core/Core","sap/ui/core/CustomData","sap/ui/core/Configuration","sap/ui/base/ManagedObjectObserver","./AnchorBar","sap/m/Button","sap/m/MenuButton","sap/m/Menu","sap/m/MenuItem","sap/ui/core/IconPool"],function(q,M,C,a,b,c,A,B,d,e,f,I){"use strict";var S=[b.AnimationMode.full,b.AnimationMode.basic];var g=M.createClass("sap.uxap._helpers.AB",{constructor:function(o){this._oObjectPageLayout=o;this._iScrollDuration=o._iScrollToSectionDuration;this._iFocusMoveDelay=this._iScrollDuration-100;this._oObserver=new c(this._proxyStateChanges.bind(this));this._aMenusWithAttachPressHandler=[];}});
g.prototype.getObjectPageLayout=function(){return this._oObjectPageLayout;};
g.prototype._proxyStateChanges=function(o){var O=o.object,i=this._findExistingClone(O),p=o.name,v=o.current,s="set"+h(p);if(i){i[s].call(i,v);}};
g.prototype._findExistingClone=function(o){var i,s=o.getId()+"-__clone",j=this._getAnchorBar(),k=j.getContent();k.some(function(l){if(l.getId().indexOf(s)===0){i=l;return true;}});return i;};
g.prototype._getAnchorBar=function(){var o=this.getObjectPageLayout(),i=o.getAggregation("_anchorBar");if(!i){i=new A({id:o.getId()+"-anchBar",showPopover:o.getShowAnchorBarPopover(),backgroundDesign:o.getBackgroundDesignAnchorBar()});this.getObjectPageLayout().setAggregation("_anchorBar",i,true);}return i;};
g.prototype._buildAnchorBar=function(){var s=this.getObjectPageLayout().getSections()||[],o=this._getAnchorBar(),p=q.proxy(o._handleDirectScroll,o),i,j,m,k;if(o&&this.getObjectPageLayout().getShowAnchorBar()){o._resetControl();this._oObserver.disconnect();s.forEach(function(l){if(!l.getVisible()||!l._getInternalVisible()){return;}var n,r=l.getSubSections()||[];n=this._buildAnchorBarButton(l,true);if(n){o.addContent(n);if(n instanceof d){var t=new e({}),R=sap.ui.getCore().getLibraryResourceBundle("sap.uxap");n.enhanceAccessibilityState=function(E,u){var v=o.getContent(),w=v.indexOf(E.getParent());if(w!==-1){u.role="menuitemradio";u.roledescription=R.getText("ANCHOR_BAR_MENUITEM");u.setsize=v.length;u.posinset=w+1;}};t._setCustomEnhanceAccStateFunction(function(E,u){u.controls=E.data("sectionId");});n.setMenu(t);}r.forEach(function(u){if(!u.getVisible()||!u._getInternalVisible()){return;}var v=this._buildAnchorBarButton(u,false);if(v){o.addContent(v);}if(n instanceof d){k=u.getCustomAnchorBarButton();if(k){i=k.getText();j=k.getIcon();}else{i=u._getInternalTitle()||u.getTitle();j='';}m=new f({"text":i,"icon":j});m.addCustomData(new a({key:"sectionId",value:u.getId()}));m.attachPress(p);n.getMenu().addItem(m);}},this);}},this);}};
g.prototype._moveFocusOnSection=function(s){var o=s.data(),i=sap.ui.getCore().byId(o.sectionId),O=this.getObjectPageLayout(),j=i.isA("sap.uxap.ObjectPageSubSection"),k=(i&&!O.getUseIconTabBar())||(O.getUseIconTabBar()&&j),F=this._iFocusMoveDelay;if(k&&this._isScrollAnimationEnabled()){setTimeout(i.$()["focus"].bind(i.$()),F);}else if(k){i.$().focus();}if(O.getUseIconTabBar()&&j){var D={"onAfterRendering":function(){this.removeEventDelegate(D);setTimeout(this.$()["focus"].bind(this.$()),F);}.bind(i)};i.addEventDelegate(D);}};
g.prototype._isScrollAnimationEnabled=function(){return S.indexOf(C.getConfiguration().getAnimationMode())>=0;};
g.prototype._instantiateAnchorBarButton=function(i,s,j){var o=i?new d({type:"Transparent",buttonMode:"Split",useDefaultActionOnly:true,ariaDescribedBy:s,id:j}):new B({ariaDescribedBy:s,id:j});return o;};
g.prototype._buildAnchorBarButton=function(s,i){var o=null,O=this.getObjectPageLayout(),j,k=this._getAnchorBar(),l,H,v,m=s.getAggregation("subSections"),p=q.proxy(k._handleDirectScroll,k);if(s.getVisible()&&s._getInternalVisible()){j=s.getCustomAnchorBarButton();if(!j){l=k.getId()+"-"+s.getId()+"-anchor";if(i){if(m&&m.length>1){v=m.filter(function(n){return n.getVisible()&&n._getInternalVisible();}).length;}}H=i&&v>1&&k.getShowPopover();if(H){o=this._instantiateAnchorBarButton(true,s,l);o.attachDefaultAction(p);o._getButtonControl().attachPress(function(){this.getParent().focus();});o._getButtonControl().attachArrowPress(function(){var n=o._getButtonControl();if(this._aMenusWithAttachPressHandler[n.getId()]){return;}o.getMenu().attachItemSelected(function(E){this._moveFocusOnSection(E.getParameter("item"));},this);this._aMenusWithAttachPressHandler[n.getId()]=true;},this);o.addCustomData(new a({key:"bHasSubMenu",value:true}));}else{o=this._instantiateAnchorBarButton(false,s,l);o.attachPress(function(E){this._moveFocusOnSection(E.getSource());},this);o.attachPress(p);}var t=(s._getInternalTitle()!="")?s._getInternalTitle():s.getTitle();o.setText(t);}else{o=j.clone();o.attachPress(function(E){this._moveFocusOnSection(E.getSource());},this);o.attachPress(p);this._oObserver.observe(j,{properties:true});}O._oSectionInfo[s.getId()].buttonId=o.getId();o.addCustomData(new a({key:"sectionId",value:s.getId()}));o.addCustomData(new a({key:"bTitleVisible",value:s._getInternalTitleVisible()}));if(!i){o.addCustomData(new a({key:"secondLevel",value:true}));}}return o;};
function h(n){return n.substring(0,1).toUpperCase()+n.substring(1);}
return g;},false);
sap.ui.predefine('sap/uxap/ObjectPageLayoutRenderer',["sap/ui/Device"],function(D){"use strict";var O={};
O.render=function(r,c){var s,h=c.getHeaderTitle(),a=null,R=sap.uxap.ObjectPageLayout._getLibraryResourceBundle(),i=c.getHeaderContent()&&c.getHeaderContent().length>0&&c.getShowHeaderContent(),I=c.getShowTitleInHeaderContent()&&c.getShowHeaderContent(),b=i||I,u=c.getUseIconTabBar(),t=c.getToggleHeaderOnTitleClick()&&c.getHeaderTitle()&&c.getHeaderTitle().supportsToggleHeaderOnTitleClick(),d=c._getAriaLabelText("ROOT"),H=c._getAriaLabelText("HEADER"),n=c._getAriaLabelText("NAVIGATION"),B=c.getBackgroundDesignAnchorBar(),l=c.getLandmarkInfo(),e=c._getHeaderTag(l),f=c._getFooterTag(l),g=l&&l.getHeaderRole(),j=l&&l.getHeaderLabel(),k=l&&l.getRootRole(),m=l&&l.getRootLabel(),N=l&&l.getNavigationRole(),o=l&&l.getNavigationLabel();if(c.getShowAnchorBar()&&c._getInternalAnchorBarVisible()){a=c.getAggregation("_anchorBar");}r.write("<div");r.writeControlData(c);if(!k){r.writeAttribute("role","main");}r.writeAttribute("aria-roledescription",R.getText("ROOT_ROLE_DESCRIPTION"));if(!m){r.writeAttributeEscaped("aria-label",d);}r.addClass("sapUxAPObjectPageLayout");if(t){r.addClass("sapUxAPObjectPageLayoutTitleClickEnabled");}r.writeClasses();r.addStyle("height",c.getHeight());r.writeStyles();r.writeAccessibilityState(c,c._formatLandmarkInfo(l,"Root"));r.write(">");if(D.system.desktop){r.renderControl(c._getCustomScrollBar());}r.write("<"+e+" ");if(!g){r.writeAttribute("role","banner");}r.writeAttribute("aria-roledescription",R.getText("HEADER_ROLE_DESCRIPTION"));if(!j){r.writeAttributeEscaped("aria-label",H);}r.writeAttributeEscaped("id",c.getId()+"-headerTitle");r.writeAttribute("data-sap-ui-customfastnavgroup",true);r.addClass("sapUxAPObjectPageHeaderTitle");r.addClass("sapContrastPlus");r.writeClasses();r.writeAccessibilityState(c,c._formatLandmarkInfo(l,"Header"));r.write(">");if(h){r.renderControl(h);}this._renderHeaderContentDOM(r,c,b&&c._bHeaderInTitleArea,"-stickyHeaderContent");r.write("<div ");r.writeAttributeEscaped("id",c.getId()+"-stickyAnchorBar");if(!N){r.writeAttribute("role","navigation");}r.writeAttribute("aria-roledescription",R.getText("NAVIGATION_ROLE_DESCRIPTION"));if(!o){r.writeAttributeEscaped("aria-label",n);}if(!c._bHeaderInTitleArea){r.writeAttribute("aria-hidden","true");}r.addClass("sapUxAPObjectPageStickyAnchorBar");r.addClass("sapUxAPObjectPageNavigation");r.addClass("ui-helper-clearfix");if(B){r.addClass("sapUxAPObjectPageNavigation"+B);}r.writeClasses();r.writeAccessibilityState(c,c._formatLandmarkInfo(l,"Navigation"));r.write(">");this._renderAnchorBar(r,c,a,c._bHeaderInTitleArea);r.write("</div>");r.write("</"+e+">");r.write("<div ");r.writeAttributeEscaped("id",c.getId()+"-opwrapper");r.addClass("sapUxAPObjectPageWrapper");if(h&&(!h.supportsTitleInHeaderContent()||!(c.getShowTitleInHeaderContent()&&h.getShowTitleSelector()))){r.addClass("sapUxAPObjectPageWrapperTransform");}r.writeClasses();r.write(">");r.write("<div ");r.writeAttributeEscaped("id",c.getId()+"-scroll");r.addClass("sapUxAPObjectPageScroll");r.writeClasses();r.write(">");this._renderHeaderContentDOM(r,c,b&&!c._bHeaderInTitleArea,"-headerContent",true);r.write("<section ");r.writeAttributeEscaped("id",c.getId()+"-anchorBar");if(!N){r.writeAttribute("role","navigation");}r.writeAttribute("aria-roledescription",R.getText("NAVIGATION_ROLE_DESCRIPTION"));if(!o){r.writeAttributeEscaped("aria-label",n);}r.addClass("sapUxAPObjectPageNavigation");r.addClass("ui-helper-clearfix");r.addClass("sapContrastPlus");if(B){r.addClass("sapUxAPObjectPageNavigation"+B);}r.writeClasses();r.writeAccessibilityState(c,c._formatLandmarkInfo(l,"Navigation"));r.write(">");this._renderAnchorBar(r,c,a,!c._bHeaderInTitleArea);r.write("</section>");r.write("<section");r.addClass("sapUxAPObjectPageContainer");r.writeAttributeEscaped("id",c.getId()+"-sectionsContainer");r.addClass("ui-helper-clearfix");if(!a){r.addClass("sapUxAPObjectPageContainerNoBar");}r.writeClasses();r.writeAccessibilityState(c,c._formatLandmarkInfo(l,"Content"));r.write(">");s=c._getSectionsToRender();if(Array.isArray(s)){s.forEach(function(S){r.renderControl(S);if(u){c._oCurrentTabSection=S;}});}r.write("</section>");this.renderFooterContent(r,c);r.write("<div");r.writeAttributeEscaped("id",c.getId()+"-spacer");r.write("></div>");r.write("</div>");r.write("</div>");this._renderFooterContentInternal(r,c,f,l,R);r.write("</div>");};
O._renderAnchorBar=function(r,c,a,R){var s=c.getAggregation("sections"),h;if(R){h=c._getHeaderContent();if(c.getIsChildPage()&&h&&h.supportsChildPageDesign()){r.write("<div ");r.writeAttributeEscaped("id",c.getId()+"-childPageBar");if(Array.isArray(s)&&s.length>1){r.addClass('sapUxAPObjectChildPage');}r.writeClasses();r.write("></div>");}if(a){r.renderControl(a);}}};
O._renderHeaderContentDOM=function(r,c,R,i,a){r.write("<header ");r.writeAttributeEscaped("id",c.getId()+i);r.addClass("ui-helper-clearfix");r.addClass("sapUxAPObjectPageHeaderDetails");r.addClass("sapUxAPObjectPageHeaderDetailsDesign-"+c._getHeaderDesign());if(a){r.addClass("sapContrastPlus");}r.writeClasses();r.writeAttribute("data-sap-ui-customfastnavgroup",true);r.write(">");if(R){this.renderHeaderContent(r,c);}r.write("</header>");};
O.renderHeaderContent=function(r,c){r.renderControl(c._getHeaderContent());};
O.renderFooterContent=function(r,c){};
O._renderFooterContentInternal=function(r,o,f,l,R){var F=o.getFooter(),b=l&&l.getFooterRole();if(!F){return;}r.write("<"+f);r.writeAttributeEscaped("id",o.getId()+"-footerWrapper");r.addClass("sapUxAPObjectPageFooter sapMFooter-CTX sapContrast sapContrastPlus");if(!o.getShowFooter()){r.addClass("sapUiHidden");}r.writeClasses();if(!b){r.writeAttribute("role","region");}r.writeAttribute("aria-roledescription",R.getText("FOOTER_ROLE_DESCRIPTION"));r.writeAccessibilityState(o,o._formatLandmarkInfo(l,"Footer"));r.write(">");F.addStyleClass("sapUxAPObjectPageFloatingFooter");r.renderControl(F);r.write("</"+f+">");};
O._rerenderHeaderContentArea=function(r,c){var h=c._bHeaderInTitleArea?"stickyHeaderContent":"headerContent",$;this.renderHeaderContent(r,c);$=c.$(h)[0];if($){r.flush($);}};
return O;},true);
sap.ui.predefine('sap/uxap/ObjectPageLazyLoader',['./library','sap/ui/core/Element','sap/ui/core/StashedControlSupport',"sap/base/assert"],function(l,E,S,a){"use strict";
var L=E.extend("sap.uxap.ObjectPageLazyLoader",{metadata:{library:"sap.uxap",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}},defaultAggregation:"content"}});
S.mixInto(L);
L.prototype.setParent=function(p){if(!(p===null||p instanceof sap.uxap.ObjectPageSubSection)){a(false,"setParent(): oParent must be an instance of sap.uxap.ObjectPageSubSection or null");}return E.prototype.setParent.apply(this,arguments);};
return L;});
sap.ui.predefine('sap/uxap/ObjectPageSection',["sap/ui/core/InvisibleText","./ObjectPageSectionBase","sap/ui/Device","sap/m/Button","sap/ui/core/StashedControlSupport","./ObjectPageSubSection","./library","sap/m/library","./ObjectPageSectionRenderer"],function(I,O,D,B,S,a,l,m,b){"use strict";var c=m.ButtonType;
var d=O.extend("sap.uxap.ObjectPageSection",{metadata:{library:"sap.uxap",properties:{showTitle:{type:"boolean",group:"Appearance",defaultValue:true},titleUppercase:{type:"boolean",group:"Appearance",defaultValue:true}},defaultAggregation:"subSections",aggregations:{subSections:{type:"sap.uxap.ObjectPageSubSection",multiple:true,singularName:"subSection"},ariaLabelledBy:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"},_showHideAllButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_showHideButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},associations:{selectedSubSection:{type:"sap.uxap.ObjectPageSubSection",multiple:false}},designtime:"sap/uxap/designtime/ObjectPageSection.designtime"}});
d.MEDIA_RANGE=D.media.RANGESETS.SAP_STANDARD;
d._getClosestSection=function(s){var o=(typeof s==="string"&&sap.ui.getCore().byId(s))||s;return(o instanceof a)?o.getParent():o;};
d._getLibraryResourceBundle=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.uxap");};
d.prototype._expandSection=function(){O.prototype._expandSection.call(this)._updateShowHideAllButton(!this._thereAreHiddenSubSections());};
d.prototype.init=function(){O.prototype.init.call(this);this._sContainerSelector=".sapUxAPObjectPageSectionContainer";};
d.prototype.exit=function(){this._detachMediaContainerWidthChange(this._updateImportance,this);};
d.prototype.setTitle=function(v){O.prototype.setTitle.call(this,v);var A=this.getAggregation("ariaLabelledBy"),s=d._getLibraryResourceBundle().getText("SECTION_CONTROL_NAME");if(A){sap.ui.getCore().byId(A.getId()).setText(v+" "+s);}return this;};
d.prototype._getImportanceLevelToHide=function(C){var o=this._getObjectPageLayout(),M=C||this._getCurrentMediaContainerRange(),s=o&&o.getShowOnlyHighImportance();return this._determineTheLowestLevelOfImportanceToShow(M.name,s);};
d.prototype._updateImportance=function(C){var o=this._getObjectPageLayout(),i=this._getImportanceLevelToHide(C);this.getSubSections().forEach(function(s){s._applyImportanceRules(i);});this._applyImportanceRules(i);this._updateShowHideAllButton(false);if(o&&this.getDomRef()){o._requestAdjustLayout();}};
d.prototype._determineTheLowestLevelOfImportanceToShow=function(M,s){if(s||M==="Phone"){return l.Importance.High;}if(M==="Tablet"){return l.Importance.Medium;}return l.Importance.Low;};
d.prototype.connectToModels=function(){this.getSubSections().forEach(function(s){s.connectToModels();});};
d.prototype._allowPropagationToLoadedViews=function(A){this.getSubSections().forEach(function(s){s._allowPropagationToLoadedViews(A);});};
d.prototype.onBeforeRendering=function(){var A="ariaLabelledBy";if(!this.getAggregation(A)){this.setAggregation(A,this._getAriaLabelledBy(),true);}this._detachMediaContainerWidthChange(this._updateImportance,this);this._updateImportance();};
d.prototype.onAfterRendering=function(){this._attachMediaContainerWidthChange(this._updateImportance,this);};
d.prototype._getAriaLabelledBy=function(){var L="",t=this._getTitle();if(t){L+=t+" ";}L+=d._getLibraryResourceBundle().getText("SECTION_CONTROL_NAME");return new I({text:L}).toStatic();};
d.prototype._isTitleVisible=function(){return this.getShowTitle()&&this._getInternalTitleVisible();};
d.prototype._setSubSectionsFocusValues=function(){var s=this.getSubSections()||[],L=this.getSelectedSubSection(),p;if(s.length===0){return this;}if(s.length===1){s[0]._setToFocusable(false);return this;}s.forEach(function(o){if(L===o.sId){o._setToFocusable(true);p=true;}else{o._setToFocusable(false);}});if(!p){s[0]._setToFocusable(true);}return this;};
d.prototype._disableSubSectionsFocus=function(){var s=this.getSubSections()||[];s.forEach(function(o){o._setToFocusable(false);});return this;};
d.prototype._thereAreHiddenSubSections=function(){return this.getSubSections().some(function(s){return s._getIsHidden();});};
d.prototype._updateShowHideSubSections=function(h){this.getSubSections().forEach(function(s){if(h&&s._shouldBeHidden()){s._updateShowHideState(true);}else if(!h){s._updateShowHideState(false);}});};
d.prototype._getShouldDisplayShowHideAllButton=function(){return this.getSubSections().some(function(s){return s._shouldBeHidden();});};
d.prototype._showHideContentAllContent=function(){var s=this._thereAreHiddenSubSections();if(this._getIsHidden()&&s){this._updateShowHideState(false);}this._updateShowHideSubSections(!s);this._updateShowHideAllButton(s);};
d.prototype._updateShowHideState=function(h){this._updateShowHideButton(h);this._getShowHideAllButton().setVisible(this._getShouldDisplayShowHideAllButton());return O.prototype._updateShowHideState.call(this,h);};
d.prototype._updateShowHideAllButton=function(h){this._getShowHideAllButton().setVisible(this._getShouldDisplayShowHideAllButton()).setText(this._getShowHideAllButtonText(h));};
d.prototype._getShowHideAllButton=function(){if(!this.getAggregation("_showHideAllButton")){this.setAggregation("_showHideAllButton",new B({visible:this._getShouldDisplayShowHideAllButton(),text:this._getShowHideAllButtonText(!this._thereAreHiddenSubSections()),press:this._showHideContentAllContent.bind(this),type:c.Transparent}).addStyleClass("sapUxAPSectionShowHideButton"),true);}return this.getAggregation("_showHideAllButton");};
d.prototype._getShowHideButtonText=function(h){return d._getLibraryResourceBundle().getText(h?"HIDE":"SHOW");};
d.prototype._getShowHideAllButtonText=function(h){return d._getLibraryResourceBundle().getText(h?"HIDE_ALL":"SHOW_ALL");};
d.prototype._updateShowHideButton=function(h){this._getShowHideButton().setVisible(this._shouldBeHidden()).setText(this._getShowHideButtonText(!h));};
d.prototype._getShowHideButton=function(){if(!this.getAggregation("_showHideButton")){this.setAggregation("_showHideButton",new B({visible:this._shouldBeHidden(),text:this._getShowHideButtonText(!this._getIsHidden()),press:this._showHideContent.bind(this),type:c.Transparent}).addStyleClass("sapUxAPSectionShowHideButton"),true);}return this.getAggregation("_showHideButton");};
S.mixInto(d);return d;});
sap.ui.predefine('sap/uxap/ObjectPageSectionBase',["sap/ui/thirdparty/jquery","sap/ui/core/Control","sap/ui/core/library","./library","sap/base/Log","sap/ui/events/KeyCodes","sap/ui/dom/jquery/Focusable"],function(q,C,c,l,L,K){"use strict";var T=c.TitleLevel;
var O=C.extend("sap.uxap.ObjectPageSectionBase",{metadata:{"abstract":true,library:"sap.uxap",properties:{title:{type:"string",group:"Appearance",defaultValue:null},titleLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:T.Auto},visible:{type:"boolean",group:"Appearance",defaultValue:true},importance:{type:"sap.uxap.Importance",group:"Behavior",defaultValue:l.Importance.High}},aggregations:{customAnchorBarButton:{type:"sap.m.Button",multiple:false}}}});
O.prototype.init=function(){this._bInternalVisible=true;this._bInternalTitleVisible=true;this._sInternalTitle="";this._sInternalTitleLevel=T.Auto;this._isHidden=false;this._bRtl=sap.ui.getCore().getConfiguration().getRTL();};
O.prototype.onAfterRendering=function(){if(this._getObjectPageLayout()){this._getObjectPageLayout()._requestAdjustLayout().catch(function(){L.debug("ObjectPageSectionBase :: cannot adjustLayout",this);});this._getObjectPageLayout()._setSectionsFocusValues();}};
O.prototype.setCustomAnchorBarButton=function(b){var r=this.setAggregation("customAnchorBarButton",b,true);if(this._getObjectPageLayout()){this._getObjectPageLayout()._updateNavigation();}return r;};
O.prototype._setInternalVisible=function(v,i){if(v!=this._bInternalVisible){this._bInternalVisible=v;if(i){this.invalidate();}}};
O.prototype._getInternalVisible=function(){return this._bInternalVisible;};
O.prototype._setInternalTitleVisible=function(v,i){if(v!=this._bInternalTitleVisible){this._bInternalTitleVisible=v;if(i){this.invalidate();}}};
O.prototype._getInternalTitleVisible=function(){return this._bInternalTitleVisible;};
O.prototype._setInternalTitle=function(v,i){if(v!=this._sInternalTitle){this._sInternalTitle=v;if(i){this.invalidate();}}};
O.prototype._getTitle=function(){return this._getInternalTitle()||this.getTitle();};
O.prototype._getInternalTitle=function(){return this._sInternalTitle;};
O.prototype._getARIALevel=function(){return this._getTitleLevel().slice(-1);};
O.prototype._getTitleLevel=function(){var t=this.getTitleLevel();return(t===T.Auto)?this._getInternalTitleLevel():t;};
O.prototype._setInternalTitleLevel=function(t){this._sInternalTitleLevel=t;};
O.prototype._getInternalTitleLevel=function(){return this._sInternalTitleLevel;};
O.prototype._getObjectPageLayout=function(){return l.Utilities.getClosestOPL(this);};
O.prototype._notifyObjectPageLayout=function(){if(this._getObjectPageLayout()&&this._getObjectPageLayout().$().length){this._getObjectPageLayout()._requestAdjustLayoutAndUxRules();}};
["addAggregation","insertAggregation","removeAllAggregation","removeAggregation","destroyAggregation"].forEach(function(m){O.prototype[m]=function(a,o,i,s){if(["addAggregation","removeAggregation"].indexOf(m)>-1){s=i;}if(["removeAllAggregation","destroyAggregation"].indexOf(m)>-1){s=o;}var r=C.prototype[m].apply(this,arguments);if(s!==true){this._notifyObjectPageLayout();}return r;};});
O.prototype.setVisible=function(v,s){if(this.getVisible()===v){return this;}if(!this._getObjectPageLayout()){return this.setProperty("visible",v,s);}this.setProperty("visible",v,true);this._notifyObjectPageLayout();this.invalidate();return this;};
O.prototype.setTitle=function(v,s){this.setProperty("title",v,s);this._notifyObjectPageLayout();return this;};
O.prototype._shouldBeHidden=function(){return O._importanceMap[this.getImportance()]>O._importanceMap[this._sCurrentLowestImportanceLevelToShow];};
O._importanceMap={"Low":3,"Medium":2,"High":1};
O.prototype._updateShowHideState=function(h){var o=this._getObjectPageLayout();this._isHidden=h;this.$().children(this._sContainerSelector).toggle(!h);if(o){o._requestAdjustLayout();}return this;};
O.prototype._getIsHidden=function(){return this._isHidden;};
O.prototype._expandSection=function(){return this._updateShowHideState(false);};
O.prototype._showHideContent=function(){return this._updateShowHideState(!this._getIsHidden());};
O.prototype._applyImportanceRules=function(s){this._sCurrentLowestImportanceLevelToShow=s;if(this.getDomRef()){this._updateShowHideState(this._shouldBeHidden());}else{this._isHidden=this._shouldBeHidden();}};
O.PAGEUP_AND_PAGEDOWN_JUMP_SIZE=5;
O.prototype.onkeydown=function(e){if(e.keyCode===K.SPACE&&e.srcControl.isA("sap.uxap.ObjectPageSection")){e.preventDefault();}if(e.keyCode===K.F7){var s=this.getSubSections(),f=s[0],o;if(s.length===1){o=f._oLastFocusedControlF7;if(o){o.$().focus();}else{f.$().firstFocusableDomRef().focus();}}else{if(f.getActions().length){f.getActions()[0].$().focus();}}}};
O.prototype.onsapdown=function(e){this._handleFocusing(e,e.currentTarget.nextSibling);};
O.prototype._handleFocusing=function(e,E){var s;if(this._targetIsCorrect(e)&&E){s=q(e.currentTarget).parent().children();e.preventDefault();E.focus();if(s.length>1){this._scrollParent(q(E).attr("id"));}}};
O.prototype._targetIsCorrect=function(e){return e.srcControl===this;};
O.prototype.onsapright=function(e){var m=this._bRtl?"onsapup":"onsapdown";this[m](e);};
O.prototype.onsapup=function(e){this._handleFocusing(e,e.currentTarget.previousSibling);};
O.prototype.onsapleft=function(e){var m=this._bRtl?"onsapdown":"onsapup";this[m](e);};
O.prototype.onsaphome=function(e){this._handleFocusing(e,e.currentTarget.parentElement.firstChild);};
O.prototype.onsapend=function(e){this._handleFocusing(e,e.currentTarget.parentElement.lastChild);};
O.prototype.onsappageup=function(e){if(!this._targetIsCorrect(e)){return;}e.preventDefault();var n;var s=q(e.currentTarget).parent().children();var f;s.each(function(S,o){if(q(o).attr("id")===e.currentTarget.id){n=S-(O.PAGEUP_AND_PAGEDOWN_JUMP_SIZE+1);return;}});if(n&&s[n]){s[n].focus();f=q(s[n]).attr("id");}else if(s[0]){s[0].focus();f=q(s[0]).attr("id");}if(s.length>1){this._scrollParent(f);}};
O.prototype.onsappagedown=function(e){if(!this._targetIsCorrect(e)){return;}e.preventDefault();var n;var s=q(e.currentTarget).parent().children();var f;s.each(function(S,o){if(q(o).attr("id")===e.currentTarget.id){n=S+O.PAGEUP_AND_PAGEDOWN_JUMP_SIZE+1;return;}});if(n&&s[n]){s[n].focus();f=q(s[n]).attr("id");}else if(s[s.length-1]){s[s.length-1].focus();f=q(s[s.length-1]).attr("id");}if(s.length>1){this._scrollParent(f);}};
O.prototype._scrollParent=function(i){if(this._getObjectPageLayout()){this._getObjectPageLayout().scrollToSection(i,0,10);}};
return O;});
sap.ui.predefine('sap/uxap/ObjectPageSectionRenderer',function(){"use strict";var O={};
O.render=function(r,c){var t,T,a=sap.ui.getCore().getConfiguration().getAccessibility(),l=c.getAggregation("ariaLabelledBy");if(!c.getVisible()||!c._getInternalVisible()){return;}t=c._getTitle();T=c._isTitleVisible();r.write("<section ");r.addClass("sapUxAPObjectPageSection");if(!T){r.addClass("sapUxAPObjectPageSectionNoTitle");}r.writeClasses();r.writeAttribute("role","region");if(a&&l){r.writeAttribute("aria-labelledby",l.getId());}r.writeControlData(c);r.write(">");r.write("<div");r.writeAttribute("role","heading");r.writeAttribute("aria-level",c._getARIALevel());r.writeAttributeEscaped("id",c.getId()+"-header");r.addClass("sapUxAPObjectPageSectionHeader");r.addClass(T?"":"sapUxAPObjectPageSectionHeaderHidden");r.writeClasses();r.write(">");r.write("<div");r.writeAttributeEscaped("id",c.getId()+"-title");r.addClass("sapUxAPObjectPageSectionTitle");if(c.getTitleUppercase()){r.addClass("sapUxAPObjectPageSectionTitleUppercase");}r.writeClasses();r.write(">");r.writeEscaped(t);r.write("</div>");if(T){r.renderControl(c._getShowHideAllButton());r.renderControl(c._getShowHideButton());}r.write("</div>");r.write("<div");r.addClass("sapUxAPObjectPageSectionContainer");r.writeClasses();if(c._isHidden){r.addStyle("display","none");}r.writeStyles();r.write(">");c.getSubSections().forEach(r.renderControl,r);r.write("</div>");r.write("</section>");};
return O;},true);
sap.ui.predefine('sap/uxap/ObjectPageSubSection',["sap/ui/thirdparty/jquery","sap/ui/layout/Grid","sap/ui/layout/GridData","./ObjectPageSectionBase","./ObjectPageLazyLoader","./BlockBase","sap/m/Button","sap/ui/Device","sap/ui/core/StashedControlSupport","sap/ui/base/ManagedObjectObserver","sap/m/TitlePropagationSupport","./library","sap/m/library","./ObjectPageSubSectionRenderer","sap/base/Log","sap/ui/base/DataType","sap/ui/events/KeyCodes","sap/ui/dom/jquery/Focusable"],function(q,G,a,O,b,B,c,D,S,d,T,l,m,e,f,g,K){"use strict";var h=m.ButtonType;var i=l.ObjectPageSubSectionMode;var j=l.ObjectPageSubSectionLayout;
var k=O.extend("sap.uxap.ObjectPageSubSection",{metadata:{library:"sap.uxap",properties:{mode:{type:"sap.uxap.ObjectPageSubSectionMode",group:"Appearance",defaultValue:i.Collapsed},titleUppercase:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"blocks",aggregations:{_grid:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},blocks:{type:"sap.ui.core.Control",multiple:true,singularName:"block"},moreBlocks:{type:"sap.ui.core.Control",multiple:true,singularName:"moreBlock"},actions:{type:"sap.ui.core.Control",multiple:true,singularName:"action"}},designtime:"sap/uxap/designtime/ObjectPageSubSection.designtime"}});
T.call(k.prototype,"blocks",function(){return this._getTitleDomId();});k.FIT_CONTAINER_CLASS="sapUxAPObjectPageSubSectionFitContainer";
k._getLibraryResourceBundle=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.uxap");};
k.prototype.init=function(){O.prototype.init.call(this);this._bRenderedFirstTime=false;this._aAggregationProxy={blocks:[],moreBlocks:[]};this._$spacer=[];this._sContainerSelector=".sapUxAPBlockContainer";this._sMoreContainerSelector=".sapUxAPSubSectionSeeMoreContainer";this._oObserver=new d(k.prototype._observeChanges.bind(this));this._oObserver.observe(this,{aggregations:["actions"]});this._switchSubSectionMode(this.getMode());this._initTitlePropagationSupport();this._sBorrowedTitleDomId=false;this._height="";};
k.prototype._getHeight=function(){return this._height;};
k.prototype._setHeight=function(v){var t,o;if(this._height===v){return;}t=g.getType("sap.ui.core.CSSSize");if(!t.isValid(v)){throw new Error("\""+v+"\" is of type "+typeof v+", expected "+t.getName()+" for property \"_height\" of "+this);}this._height=v;o=this.getDomRef();if(o){o.style.height=v;}};
k.prototype._getTitleDomId=function(){if(this._sBorrowedTitleDomId){return this._sBorrowedTitleDomId;}if(!this.getTitle().trim()){return false;}if(this._getInternalTitleVisible()){return this.getId()+"-headerTitle";}return false;};
k.prototype._setBorrowedTitleDomId=function(I){this._sBorrowedTitleDomId=I;};
k.prototype._expandSection=function(){O.prototype._expandSection.call(this);var p=this.getParent();p&&typeof p._expandSection==="function"&&p._expandSection();return this;};
k.prototype._getGrid=function(){if(!this.getAggregation("_grid")){this.setAggregation("_grid",new G({id:this.getId()+"-innerGrid",defaultSpan:"XL12 L12 M12 S12",hSpacing:1,vSpacing:1,width:"100%",containerQuery:true}),true);}return this.getAggregation("_grid");};
k.prototype._hasVisibleActions=function(){var A=this.getActions()||[];if(A.length===0){return false;}return A.filter(function(o){return o.getVisible();}).length>0;};
k.prototype._observeChanges=function(C){var o=C.object,s=C.name,M=C.mutation,n=C.child,H;if(o===this){if(s==="actions"){if(M==="insert"){this._observeAction(n);}else if(M==="remove"){this._unobserveAction(n);}}}else if(s==="visible"){H=this._getInternalTitleVisible()&&this.getTitle().trim()!=="";if(!H){this.$("header").toggleClass("sapUiHidden",!this._hasVisibleActions());}}};
k.prototype._observeAction=function(C){this._oObserver.observe(C,{properties:["visible"]});};
k.prototype._unobserveAction=function(C){this._oObserver.unobserve(C,{properties:["visible"]});};
["addStyleClass","toggleStyleClass","removeStyleClass"].forEach(function(M){k.prototype[M]=function(s,n){if(s===k.FIT_CONTAINER_CLASS){this._notifyObjectPageLayout();}return O.prototype[M].apply(this,arguments);};});
k.prototype._unStashControls=function(){S.getStashedControls(this.getId()).forEach(function(C){C.setStashed(false);});};
k.prototype.connectToModels=function(){var n=this.getBlocks()||[],M=this.getMoreBlocks()||[],C=this.getMode();this._unStashControls();n.forEach(function(o){if(o instanceof B){if(!o.getMode()){o.setMode(C);}o.connectToModels();}});if(M.length>0&&C===i.Expanded){M.forEach(function(o){if(o instanceof B){if(!o.getMode()){o.setMode(C);}o.connectToModels();}});}};
k.prototype._allowPropagationToLoadedViews=function(A){var n=this.getBlocks()||[],M=this.getMoreBlocks()||[];n.forEach(function(o){if(o instanceof B){o._allowPropagationToLoadedViews(A);}});M.forEach(function(o){if(o instanceof B){o._allowPropagationToLoadedViews(A);}});};
k.prototype.clone=function(){Object.keys(this._aAggregationProxy).forEach(function(A){var o=this.mAggregations[A];if(!o||o.length===0){this.mAggregations[A]=this._aAggregationProxy[A];}},this);return O.prototype.clone.apply(this,arguments);};
k.prototype._cleanProxiedAggregations=function(){var p=this._aAggregationProxy;Object.keys(p).forEach(function(s){p[s].forEach(function(o){o.destroy();});});};
k.prototype.exit=function(){if(this._oSeeMoreButton){this._oSeeMoreButton.destroy();this._oSeeMoreButton=null;}this._cleanProxiedAggregations();if(O.prototype.exit){O.prototype.exit.call(this);}};
k.prototype.onAfterRendering=function(){var o=this._getObjectPageLayout();if(O.prototype.onAfterRendering){O.prototype.onAfterRendering.call(this);}if(!o){return;}this._$spacer=q(document.getElementById(o.getId()+"-spacer"));};
k.prototype.onBeforeRendering=function(){var o=this._getObjectPageLayout();if(!o){return;}if(O.prototype.onBeforeRendering){O.prototype.onBeforeRendering.call(this);}this._setAggregationProxy();this._getGrid().removeAllContent();this._applyLayout(o);this.refreshSeeMoreVisibility();};
k.prototype._applyLayout=function(L){var v,o=this._getGrid(),C=this.getMode(),s=L.getSubSectionLayout(),n=this._calculateLayoutConfiguration(s,L),p=this.getBlocks(),A=p.concat(this.getMoreBlocks());this._oLayoutConfig=n;this._resetLayoutData(A);if(C===i.Expanded){v=A;}else{v=p;}this._calcBlockColumnLayout(v,this._oLayoutConfig);try{v.forEach(function(r){this._setBlockMode(r,C);o.addAggregation("content",r,true);},this);}catch(E){f.error("ObjectPageSubSection :: error while building layout "+s+": "+E);}return this;};
k.prototype._calculateLayoutConfiguration=function(L,o){var n={M:2,L:3,XL:4},p=n.L,E=n.XL,t=(L===j.TitleOnLeft),u=o.getUseTwoColumnsForLargeScreen();if(t){p-=1;E-=1;}if(u){p-=1;}n.L=p;n.XL=E;return n;};
k.prototype.refreshSeeMoreVisibility=function(){var s=this._getSeeMoreButton(),$=s.$(),n=this.$();this._bBlockHasMore=!!this.getMoreBlocks().length;if(!this._bBlockHasMore){this._bBlockHasMore=this.getBlocks().some(function(o){if(o instanceof B&&o.getVisible()&&o.getShowSubSectionMore()){return true;}});}if(n.length){n.toggleClass("sapUxAPObjectPageSubSectionWithSeeMore",this._bBlockHasMore);}this.toggleStyleClass("sapUxAPObjectPageSubSectionWithSeeMore",this._bBlockHasMore);if($.length){$.toggleClass("sapUxAPSubSectionSeeMoreButtonVisible",this._bBlockHasMore);}s.toggleStyleClass("sapUxAPSubSectionSeeMoreButtonVisible",this._bBlockHasMore);return this._bBlockHasMore;};
k.prototype.setMode=function(M){if(this.getMode()!==M){this._switchSubSectionMode(M);if(this._bRenderedFirstTime){this.rerender();}}return this;};
k.prototype.onkeydown=function(E){if(E.keyCode===K.SPACE&&E.srcControl.isA("sap.uxap.ObjectPageSubSection")){E.preventDefault();}if(E.keyCode===K.F7){E.stopPropagation();var t=sap.ui.getCore().byId(E.target.id);if(t instanceof k){this._handleSubSectionF7();}else{this._handleInteractiveElF7();this._oLastFocusedControlF7=t;}}};
k.prototype._handleInteractiveElF7=function(){if(this.getParent().getSubSections().length>1){this.$().focus();}else{this.getParent().$().focus();}};
k.prototype._handleSubSectionF7=function(E){if(this._oLastFocusedControlF7){this._oLastFocusedControlF7.$().focus();}else{this.$().firstFocusableDomRef().focus();}};
k.prototype._calcBlockColumnLayout=function(n,C){var o=12,v,M,L,X,p;M={iRemaining:C.M,iColumnConfig:C.M};L={iRemaining:C.L,iColumnConfig:C.L};X={iRemaining:C.XL,iColumnConfig:C.XL};p=[X,L,M];v=n.filter(function(r){return r.getVisible&&r.getVisible();});v.forEach(function(r,I){p.forEach(function(s){s.iCalculatedSize=this._calculateBlockSize(r,s.iRemaining,v,I,s.iColumnConfig);},this);r.setLayoutData(new a(r.getId()+"-layoutData",{spanS:o,spanM:M.iCalculatedSize*(o/M.iColumnConfig),spanL:L.iCalculatedSize*(o/L.iColumnConfig),spanXL:X.iCalculatedSize*(o/X.iColumnConfig),linebreakM:(I>0&&M.iRemaining===M.iColumnConfig),linebreakL:(I>0&&L.iRemaining===L.iColumnConfig),linebreakXL:(I>0&&X.iRemaining===X.iColumnConfig)}));p.forEach(function(s){s.iRemaining-=s.iCalculatedSize;if(s.iRemaining<1){s.iRemaining=s.iColumnConfig;}});},this);return v;};
k.prototype._calculateBlockSize=function(o,r,v,C,M){var n,F=M,p;if(!this._hasAutoLayout(o)){return Math.min(M,parseInt(o.getColumnLayout()));}for(p=1;p<=F;p++){n=this._calcLayout(v[C+p]);if(n<r){r-=n;}else{break;}}return r;};
k.prototype._calcLayout=function(o){var L=1;if(!o){L=0;}else if(o instanceof B&&o.getColumnLayout()!="auto"){L=parseInt(o.getColumnLayout());}return L;};
k.prototype._hasAutoLayout=function(o){return!(o instanceof B)||o.getColumnLayout()=="auto";};
k.prototype._setAggregationProxy=function(){if(this._bRenderedFirstTime){return;}q.each(this._aAggregationProxy,q.proxy(function(A,v){this._setAggregation(A,this.removeAllAggregation(A,true),true);},this));this._bRenderedFirstTime=true;};
k.prototype.hasProxy=function(A){return this._bRenderedFirstTime&&this._aAggregationProxy.hasOwnProperty(A);};
k.prototype._getAggregation=function(A){return this._aAggregationProxy[A];};
k.prototype._setAggregation=function(A,v,s){this._aAggregationProxy[A]=v;if(s!==true){this._notifyObjectPageLayout();this.invalidate();}return this._aAggregationProxy[A];};
k.prototype.addAggregation=function(A,o,s){var n;if(o instanceof b){o.getContent().forEach(function(C){this.addAggregation(A,C,true);},this);o.removeAllContent();o.destroy();this.invalidate();return this;}if(this.hasProxy(A)){n=this._getAggregation(A);n.push(o);this._setAggregation(A,n,s);if(o instanceof B||o instanceof b){o.setParent(this);}return this;}return O.prototype.addAggregation.apply(this,arguments);};
k.prototype.insertBlock=function(o,I){f.warning("ObjectPageSubSection :: usage of insertBlock is not supported - addBlock is performed instead.");return this.addAggregation("blocks",o);};
k.prototype.insertMoreBlock=function(o,I){f.warning("ObjectPageSubSection :: usage of insertMoreBlock is not supported - addMoreBlock is performed instead.");return this.addAggregation("moreBlocks",o);};
k.prototype.removeAllAggregation=function(A,s){var I;if(this.hasProxy(A)){I=this._getAggregation(A);this._setAggregation(A,[],s);return I.slice();}return O.prototype.removeAllAggregation.apply(this,arguments);};
k.prototype.removeAggregation=function(A,o){var r=false,I;if(this.hasProxy(A)){I=this._getAggregation(A);I.forEach(function(n,p){if(n.getId()===o.getId()){I.splice(p,1);this._setAggregation(A,I);r=true;}return!r;},this);return(r?o:null);}return O.prototype.removeAggregation.apply(this,arguments);};
k.prototype.indexOfAggregation=function(A,o){var I=-1;if(this.hasProxy(A)){this._getAggregation(A).some(function(n,p){if(n.getId()===o.getId()){I=p;return true;}},this);return I;}return O.prototype.indexOfAggregation.apply(this,arguments);};
k.prototype.getAggregation=function(A){if(this.hasProxy(A)){return this._getAggregation(A);}return O.prototype.getAggregation.apply(this,arguments);};
k.prototype.destroyAggregation=function(A){if(this.hasProxy(A)){this._getAggregation(A).forEach(function(o){o.destroy();});this._setAggregation(A,[]);return this;}return O.prototype.destroyAggregation.apply(this,arguments);};
k.prototype._getSeeMoreButton=function(){if(!this._oSeeMoreButton){this._oSeeMoreButton=new c(this.getId()+"--seeMore",{type:h.Transparent,iconFirst:false,ariaLabelledBy:this.getId()}).addStyleClass("sapUxAPSubSectionSeeMoreButton").attachPress(this._seeMoreLessControlPressHandler,this);}return this._oSeeMoreButton;};
k.prototype._seeMoreLessControlPressHandler=function(E){var C=this.getMode(),t,M=this.getMoreBlocks()||[];if(C===i.Expanded){t=i.Collapsed;}else{t=i.Expanded;M.forEach(function(o){if(o instanceof B){o.setMode(C);o.connectToModels();}},this);}this._switchSubSectionMode(t);if(this._$spacer.length>0){this._$spacer.height(this._$spacer.height()+this.$().height());}this.rerender();};
k.prototype._switchSubSectionMode=function(s){s=this.validateProperty("mode",s);if(s===i.Collapsed){this.setProperty("mode",i.Collapsed,true);this._getSeeMoreButton().setText(k._getLibraryResourceBundle().getText("SEE_MORE"));}else{this.setProperty("mode",i.Expanded,true);this._getSeeMoreButton().setText(k._getLibraryResourceBundle().getText("SEE_LESS"));}};
k.prototype._setBlockMode=function(o,M){if(o instanceof B){o.setMode(M);}else{f.debug("ObjectPageSubSection :: cannot propagate mode "+M+" to "+o.getMetadata().getName());}};
k.prototype._setToFocusable=function(F){var s='0',n='-1',t="tabindex";if(F){this.$().attr(t,s);}else{this.$().attr(t,n);}return this;};
k.prototype._getUseTitleOnTheLeft=function(){var o=this._getObjectPageLayout();return o&&(o.getSubSectionLayout()===j.TitleOnLeft);};
k.prototype._resetLayoutData=function(n){n.forEach(function(o){if(o.getLayoutData()){o.destroyLayoutData();}},this);};
k.prototype._updateShowHideState=function(H){this.$().children(this._sMoreContainerSelector).toggle(!H);return O.prototype._updateShowHideState.call(this,H);};
k.prototype.getVisibleBlocksCount=function(){var v=S.getStashedControls(this.getId()).length;(this.getBlocks()||[]).forEach(function(o){if(o.getVisible&&!o.getVisible()){return true;}v++;});(this.getMoreBlocks()||[]).forEach(function(M){if(M.getVisible&&!M.getVisible()){return true;}v++;});return v;};
return k;});
sap.ui.predefine('sap/uxap/ObjectPageSubSectionRenderer',function(){"use strict";var O={};
O.render=function(r,c){var a,h,H,b,u,d,A=sap.ui.getCore().getConfiguration().getAccessibility();if(!c.getVisible()||!c._getInternalVisible()){return;}a=c.getActions()||[];b=a.length>0;h=(c._getInternalTitleVisible()&&(c.getTitle().trim()!==""));H=h||b;d=c._hasVisibleActions();r.write("<div ");r.writeAttribute("role","region");r.writeControlData(c);if(c._getHeight()){r.writeAttribute("style","height:"+c._getHeight()+";");}if(c._bBlockHasMore){r.addClass("sapUxAPObjectPageSubSectionWithSeeMore");}r.addClass("sapUxAPObjectPageSubSection");r.addClass("ui-helper-clearfix");r.writeClasses();if(A){if(h){r.writeAttributeEscaped("aria-labelledby",c.getId()+"-headerTitle");}else{r.writeAttribute("aria-label",sap.uxap.ObjectPageSubSection._getLibraryResourceBundle().getText("SUBSECTION_CONTROL_NAME"));}}r.write(">");if(H){r.write("<div");r.addClass("sapUxAPObjectPageSubSectionHeader");if(!h&&!d){r.addClass("sapUiHidden");}u=c._getUseTitleOnTheLeft();if(u){r.addClass("titleOnLeftLayout");}r.writeAttributeEscaped("id",c.getId()+"-header");r.writeClasses();r.write(">");r.write("<div");if(h){r.writeAttribute("role","heading");r.writeAttribute("aria-level",c._getARIALevel());}r.addClass('sapUxAPObjectPageSubSectionHeaderTitle');if(c.getTitleUppercase()){r.addClass("sapUxAPObjectPageSubSectionHeaderTitleUppercase");}r.writeAttributeEscaped("id",c.getId()+"-headerTitle");r.writeClasses();r.writeAttribute("data-sap-ui-customfastnavgroup",true);r.write(">");if(h){r.writeEscaped(c.getTitle());}r.write("</div>");if(b){r.write("<div");r.addClass('sapUxAPObjectPageSubSectionHeaderActions');r.writeClasses();r.writeAttribute("data-sap-ui-customfastnavgroup",true);r.write(">");a.forEach(r.renderControl,r);r.write("</div>");}r.write("</div>");}r.write("<div");r.addClass("ui-helper-clearfix");r.addClass("sapUxAPBlockContainer");r.writeClasses();if(c._isHidden){r.addStyle("display","none");}r.writeStyles();r.write(">");r.renderControl(c._getGrid());r.write("</div>");r.write("<div");r.addClass("sapUxAPSubSectionSeeMoreContainer");r.writeClasses();if(c._isHidden){r.addStyle("display","none");}r.writeStyles();r.write(">");r.renderControl(c._getSeeMoreButton());r.write("</div>");r.write("</div>");};
return O;},true);
sap.ui.predefine('sap/uxap/ThrottledTaskHelper',["sap/ui/thirdparty/jquery",'sap/ui/base/Object'],function(q,B){"use strict";
var T=B.extend("ThrottledTask",{
constructor:function(t,d,c){this._fnTask=t;this._iDelay=d;this._oContext=c;this._oPromise=null;this._fnResolvePromise=null;this._fnRejectPromise=null;this._iTimer=null;this._oTaskOptions=null;},
reSchedule:function(i,t){var r=this._getPromise();if(this._iTimer){clearTimeout(this._iTimer);this._iTimer=null;}this._oTaskOptions=this._mergeOptions(this._oTaskOptions||{},t);if(i){var s=this._fnTask.call(this._oContext,this._oTaskOptions);this._completePromise(s);return r;}this._iTimer=setTimeout(function(){if(this._oPromise){var s=this._fnTask.call(this._oContext,this._oTaskOptions);this._completePromise(s);}}.bind(this),this._iDelay);return r;},
_getPromise:function(){if(!this._oPromise){this._oPromise=new window.Promise(function(r,a){this._fnResolvePromise=r;this._fnRejectPromise=a;}.bind(this));}return this._oPromise;},
_completePromise:function(s){var c=(s)?this._fnResolvePromise:this._fnRejectPromise;c();this._oPromise=null;this._fnResolvePromise=null;this._fnRejectPromise=null;this._oTaskOptions=null;},
_mergeOptions:function(o,n){var m=q.extend({},o,n);q.each(m,function(k){m[k]=o[k]||n[k];});return m;}
});
return T;});
sap.ui.predefine('sap/uxap/changeHandler/MoveObjectPageSection',["sap/ui/fl/changeHandler/MoveControls","sap/ui/thirdparty/jquery"],function(M,q){"use strict";var a=q.extend({},M);
a.applyChange=function(c,C,p){var j=p.modifier.targets==="jsControlTree";if(j){C._suppressScroll();}var r=M.applyChange.call(this,c,C,p);if(j){C.attachEventOnce("onAfterRenderingDOMReady",function(){C._resumeScroll(false);});}return r;};
a.revertChange=function(c,C,p){var j=p.modifier.targets==="jsControlTree";if(j){C._suppressScroll();}var r=M.revertChange.call(this,c,C,p);if(j){C.attachEventOnce("onAfterRenderingDOMReady",function(){C._resumeScroll(false);});}return r;};
return a;},true);
sap.ui.predefine('sap/uxap/changeHandler/RenameObjectPageSection',["sap/ui/fl/Utils","sap/base/Log","sap/ui/fl/changeHandler/BaseRename"],function(U,L,B){"use strict";var r={propertyName:"title",changePropertyName:"newText",translationTextType:"XGRP"};var R=B.createRenameChangeHandler(r);
R._getControlForRename=function(c,m){var s=m.getAggregation(c,"subSections");if(s&&s.length===1&&m.getProperty(s[0],"title")&&m.getProperty(m.getParent(c),"subSectionLayout")==="TitleOnTop"){return s[0];}return c;};
R._getSetterMethodName=function(v,p,m){return U.isBinding(v)?"setPropertyBinding":"setProperty";};
R.applyChange=function(c,C,p){var m=p.modifier;var P=r.propertyName;var o=c.getDefinition();var t=o.texts[r.changePropertyName];var v=t.value;var a=R._getControlForRename(C,m);if(typeof v==="string"&&v.trim()===""){throw new Error("Change cannot be applied as ObjectPageSubSection's title cannot be empty: ["+o.layer+"]"+o.namespace+"/"+o.fileName+"."+o.fileType);}if(o.texts&&t&&typeof(v)==="string"){c.setRevertData(m.getProperty(a,P));var M=R._getSetterMethodName(v);m[M](a,P,v);return true;}else{L.error("Change does not contain sufficient information to be applied: ["+o.layer+"]"+o.namespace+"/"+o.fileName+"."+o.fileType);}};
R.revertChange=function(c,C,p){var o=c.getRevertData();if(typeof(o)==="string"){var m=p.modifier;var a=R._getControlForRename(C,m);var P=r.propertyName;var M=R._getSetterMethodName(o);m[M](a,P,o);c.resetRevertData();return true;}else{L.error("Change doesn't contain sufficient information to be reverted. Most Likely the Change didn't go through applyChange.");}};
return R;},true);
sap.ui.predefine('sap/uxap/component/Component',["sap/uxap/library","sap/ui/core/UIComponent","sap/ui/core/library","sap/base/Log","sap/ui/core/Component"],function(l,U,c,L){"use strict";var V=c.mvc.ViewType;var O=l.ObjectPageConfigurationMode;
var C=U.extend("sap.uxap.component.Component",{
metadata:{},
init:function(){this._oModel=null;this._oViewConfig={viewData:{component:this}};switch(this.oComponentData.mode){case O.JsonURL:this._oModel=new U(this.oComponentData.jsonConfigurationURL);this._oViewConfig.viewName="sap.uxap.component.ObjectPageLayoutUXDrivenFactory";this._oViewConfig.type=V.XML;break;case O.JsonModel:this._oViewConfig.viewName="sap.uxap.component.ObjectPageLayoutUXDrivenFactory";this._oViewConfig.type=V.XML;break;default:L.error("UxAPComponent :: missing bootstrap information. Expecting one of the following: JsonURL, JsonModel and FacetsAnnotation");}U.prototype.init.call(this);},
createContent:function(){var o;this._oView=sap.ui.view(this._oViewConfig);if(this._oModel){o=this._oView.getController();if(o&&o.connectToComponent){o.connectToComponent(this._oModel);}this._oView.setModel(this._oModel,"objectPageLayoutMetadata");}return this._oView;},
propagateProperties:function(n){if(this.oComponentData.mode===O.JsonModel){var o=this._oView.getController();if(o&&o.connectToComponent){o.connectToComponent(this.getModel("objectPageLayoutMetadata"));}}return U.prototype.propagateProperties.apply(this,arguments);},
destroy:function(){if(this._oView){this._oView.destroy();this._oView=null;}if(this._oModel){this._oModel.destroy();this._oModel=null;}if(U.prototype.destroy){U.prototype.destroy.call(this);}}
});
return C;});
sap.ui.predefine('sap/uxap/component/ObjectPageComponentContainer',['sap/ui/core/ComponentContainer',"sap/base/Log",'sap/ui/core/Component'],function(C,L){"use strict";
var O=C.extend("sap.uxap.component.ObjectPageComponentContainer",{
metadata:{properties:{"jsonConfigurationURL":{type:"string",group:"Behavior"},"mode":{type:"sap.uxap.ObjectPageConfigurationMode",group:"Behavior"}}},
init:function(){this.setPropagateModel(true);this.setName("sap.uxap.component");},
onBeforeRendering:function(){this._oComponent=sap.ui.component("sap.uxap");if(!this._oComponent){this._oComponent=sap.ui.component({name:this.getName(),url:this.getUrl(),componentData:{jsonConfigurationURL:this.getJsonConfigurationURL(),mode:this.getMode()}});this.setComponent(this._oComponent,true);}if(C.prototype.onBeforeRendering){C.prototype.onBeforeRendering.call(this);}},
getObjectPageLayoutInstance:function(){var o=null;if(this._oComponent&&this._oComponent._oView){o=this._oComponent._oView.byId("ObjectPageLayout");}else{L.error("ObjectPageComponentContainer :: cannot find children ObjectPageLayout, has it been rendered already?");}return o;},
renderer:"sap.ui.core.ComponentContainerRenderer"
});
return O;});
sap.ui.predefine('sap/uxap/component/ObjectPageLayoutUXDrivenFactory.controller',["jquery.sap.global","sap/ui/model/BindingMode","sap/ui/model/Context","sap/ui/base/ManagedObject","sap/ui/core/mvc/Controller","sap/base/Log","sap/base/util/ObjectPath","sap/ui/thirdparty/jquery"],function(q,B,C,M,a,L,O,Q){"use strict";return a.extend("sap.uxap.component.ObjectPageLayoutUXDrivenFactory",{connectToComponent:function(m){var h=Q.isEmptyObject(m.getData());m.setDefaultBindingMode(B.OneWay);var H=Q.proxy(function(){if(h){m.detachRequestCompleted(H);}var o=new C(m,"/headerTitle"),b=this.getView().byId("ObjectPageLayout");if(o.getProperty("")){try{this._oHeader=this.controlFactory(b.getId(),o);b.setHeaderTitle(this._oHeader);}catch(e){L.error("ObjectPageLayoutFactory :: error in header creation from config: "+e);}}},this);if(h){m.attachRequestCompleted(H);}else{H();}},controlFactory:function(p,b){var c=b.getProperty(""),o,d,e;try{d=sap.ui.requireSync(c.Type.replace(/\./g,"/"));e=d.getMetadata();Q.each(e._mAllEvents,Q.proxy(function(s,f){if(typeof c[s]=="string"){c[s]=this.convertEventHandler(c[s]);}},this));o=M.create(c);Q.each(e._mAllProperties,Q.proxy(function(P,f){if(c[P]){o.bindProperty(P,"objectPageLayoutMetadata>"+b.getPath()+"/"+P);}},this));}catch(E){L.error("ObjectPageLayoutFactory :: error in control creation from config: "+E);}return o;},convertEventHandler:function(s){var n=window,N=s.split('.');try{Q.each(N,function(i,b){n=n[b];});}catch(e){L.error("ObjectPageLayoutFactory :: undefined event handler: "+s+". Did you forget to require its static class?");n=undefined;}return n;}});},true);
sap.ui.predefine('sap/uxap/flexibility/ObjectPageDynamicHeaderTitle.flexibility',["sap/m/changeHandler/CombineButtons","sap/m/changeHandler/SplitMenuButton","sap/f/changeHandler/MoveDynamicPageTitleActions"],function(C,S,M){"use strict";return{"hideControl":"default","unhideControl":"default","combineButtons":{"changeHandler":C,"layers":{"CUSTOMER":false}},"splitMenuButton":{"changeHandler":S,"layers":{"CUSTOMER":false}},"moveActions":{"changeHandler":M},"moveControls":"default"};},true);
sap.ui.predefine('sap/uxap/flexibility/ObjectPageHeader.flexibility',["sap/m/changeHandler/CombineButtons","sap/m/changeHandler/SplitMenuButton"],function(C,S){"use strict";return{"combineButtons":{"changeHandler":C,"layers":{"CUSTOMER":false}},"moveControls":"default","splitMenuButton":{"changeHandler":S,"layers":{"CUSTOMER":false}}};},true);
sap.ui.predefine('sap/uxap/flexibility/ObjectPageHeaderActionButton.flexibility',["sap/ui/fl/changeHandler/BaseRename"],function(B){"use strict";return{"hideControl":"default","rename":B.createRenameChangeHandler({propertyName:"text",translationTextType:"XBUT"}),"unhideControl":"default"};},false);
sap.ui.predefine('sap/uxap/flexibility/ObjectPageLayout.flexibility',['sap/uxap/changeHandler/MoveObjectPageSection'],function(M){"use strict";return{"moveControls":{"changeHandler":M,"layers":{"USER":true}}};},true);
sap.ui.predefine('sap/uxap/flexibility/ObjectPageSection.flexibility',['sap/uxap/changeHandler/RenameObjectPageSection'],function(R){"use strict";return{"rename":R,"moveControls":"default","hideControl":{"changeHandler":"default","layers":{"USER":true}},"unhideControl":{"changeHandler":"default","layers":{"USER":true}},"stashControl":{"changeHandler":"default","layers":{"USER":true}},"unstashControl":{"changeHandler":"default","layers":{"USER":true}}};},true);
sap.ui.predefine('sap/uxap/flexibility/ObjectPageSubSection.flexibility',["sap/m/changeHandler/CombineButtons","sap/m/changeHandler/SplitMenuButton","sap/ui/fl/changeHandler/BaseRename"],function(C,S,B){"use strict";return{"hideControl":"default","unhideControl":"default","rename":B.createRenameChangeHandler({propertyName:"title",translationTextType:"XGRP"}),"combineButtons":{"changeHandler":C,"layers":{"CUSTOMER":false}},"moveControls":"default","splitMenuButton":{"changeHandler":S,"layers":{"CUSTOMER":false}}};},true);
sap.ui.predefine('sap/uxap/library',["sap/ui/core/Core","sap/ui/base/DataType","sap/ui/Device","sap/ui/core/library","sap/m/library","sap/ui/layout/library"],function(C,D,a){"use strict";sap.ui.getCore().initLibrary({name:"sap.uxap",dependencies:["sap.ui.core","sap.m","sap.ui.layout"],designtime:"sap/uxap/designtime/library.designtime",types:["sap.uxap.BlockBaseColumnLayout","sap.uxap.BlockBaseFormAdjustment","sap.uxap.Importance","sap.uxap.ObjectPageConfigurationMode","sap.uxap.ObjectPageHeaderDesign","sap.uxap.ObjectPageHeaderPictureShape","sap.uxap.ObjectPageSubSectionLayout","sap.uxap.ObjectPageSubSectionMode"],interfaces:["sap.uxap.IHeaderTitle","sap.uxap.IHeaderContent"],controls:["sap.uxap.AnchorBar","sap.uxap.BlockBase","sap.uxap.BreadCrumbs","sap.uxap.HierarchicalSelect","sap.uxap.ObjectPageHeader","sap.uxap.ObjectPageDynamicHeaderTitle","sap.uxap.ObjectPageDynamicHeaderContent","sap.uxap.ObjectPageHeaderActionButton","sap.uxap.ObjectPageHeaderContent","sap.uxap.ObjectPageLayout","sap.uxap.ObjectPageSection","sap.uxap.ObjectPageSectionBase","sap.uxap.ObjectPageSubSection"],elements:["sap.uxap.ModelMapping","sap.uxap.ObjectPageAccessibleLandmarkInfo","sap.uxap.ObjectPageHeaderLayoutData","sap.uxap.ObjectPageLazyLoader"],version:"1.71.16",extensions:{flChangeHandlers:{"sap.uxap.ObjectPageHeader":"sap/uxap/flexibility/ObjectPageHeader","sap.uxap.ObjectPageLayout":"sap/uxap/flexibility/ObjectPageLayout","sap.uxap.ObjectPageSection":"sap/uxap/flexibility/ObjectPageSection","sap.uxap.ObjectPageSubSection":"sap/uxap/flexibility/ObjectPageSubSection","sap.uxap.ObjectPageDynamicHeaderTitle":"sap/uxap/flexibility/ObjectPageDynamicHeaderTitle","sap.uxap.ObjectPageHeaderActionButton":"sap/uxap/flexibility/ObjectPageHeaderActionButton","sap.ui.core._StashedControl":{"unstashControl":{"changeHandler":"default","layers":{"USER":true}},"stashControl":{"changeHandler":"default","layers":{"USER":true}}}},"sap.ui.support":{publicRules:true}}});sap.uxap.BlockBaseColumnLayout=D.createType('sap.uxap.BlockBaseColumnLayout',{isValid:function(v){return/^(auto|[1-4]{1})$/.test(v);}},D.getType('string'));sap.uxap.BlockBaseFormAdjustment={BlockColumns:"BlockColumns",OneColumn:"OneColumn",None:"None"};sap.uxap.ObjectPageConfigurationMode={JsonURL:"JsonURL",JsonModel:"JsonModel"};sap.uxap.ObjectPageHeaderDesign={Light:"Light",Dark:"Dark"};sap.uxap.ObjectPageHeaderPictureShape={Circle:"Circle",Square:"Square"};sap.uxap.ObjectPageSubSectionLayout={TitleOnTop:"TitleOnTop",TitleOnLeft:"TitleOnLeft"};sap.uxap.ObjectPageSubSectionMode={Collapsed:"Collapsed",Expanded:"Expanded"};sap.uxap.Importance={Low:"Low",Medium:"Medium",High:"High"};sap.uxap.Utilities={getClosestOPL:function(c){while(c&&!(c instanceof sap.uxap.ObjectPageLayout)){c=c.getParent();}return c;},isPhoneScenario:function(r){if(a.system.phone){return true;}return sap.uxap.Utilities._isCurrentMediaSize("Phone",r);},isTabletScenario:function(r){return sap.uxap.Utilities._isCurrentMediaSize("Tablet",r);},_isCurrentMediaSize:function(m,r){return r&&r.name===m;}};return sap.uxap;});
sap.ui.require.preload({
	"sap/uxap/component/ObjectPageLayoutUXDrivenFactory.view.xml":'<core:View xmlns:core="sap.ui.core" xmlns="sap.uxap" height="100%" controllerName="sap.uxap.component.ObjectPageLayoutUXDrivenFactory"><ObjectPageLayout id="ObjectPageLayout" subSectionLayout="{objectPageLayoutMetadata&gt;/subSectionLayout}" showAnchorBar="{objectPageLayoutMetadata&gt;/showAnchorBar}" height="{objectPageLayoutMetadata&gt;/height}" enableLazyLoading="{objectPageLayoutMetadata&gt;/enableLazyLoading}" sections="{objectPageLayoutMetadata&gt;/sections}" headerContent="{path:\'objectPageLayoutMetadata&gt;/headerContent\',factory:\'.controlFactory\'}" showAnchorBarPopover="{objectPageLayoutMetadata&gt;/showAnchorBarPopover}" upperCaseAnchorBar="{objectPageLayoutMetadata&gt;/upperCaseAnchorBar}" useIconTabBar="{objectPageLayoutMetadata&gt;/useIconTabBar}" showHeaderContent="{objectPageLayoutMetadata&gt;/showHeaderContent}" useTwoColumnsForLargeScreen="{objectPageLayoutMetadata&gt;/useTwoColumnsForLargeScreen}" showTitleInHeaderContent="{objectPageLayoutMetadata&gt;/showTitleInHeaderContent}" showOnlyHighImportance="{objectPageLayoutMetadata&gt;/showOnlyHighImportance}" isChildPage="{objectPageLayoutMetadata&gt;/isChildPage}" alwaysShowContentHeader="{objectPageLayoutMetadata&gt;/alwaysShowContentHeader}" showEditHeaderButton="{objectPageLayoutMetadata&gt;/showEditHeaderButton}"><sections><ObjectPageSection id="ObjectPageSection" title="{objectPageLayoutMetadata&gt;title}" importance="{objectPageLayoutMetadata&gt;importance}" showTitle="{objectPageLayoutMetadata&gt;showTitle}" subSections="{objectPageLayoutMetadata&gt;subSections}" visible="{objectPageLayoutMetadata&gt;visible}"><subSections><ObjectPageSubSection id="ObjectPageSubSection" title="{objectPageLayoutMetadata&gt;title}" visible="{objectPageLayoutMetadata&gt;visible}" mode="{objectPageLayoutMetadata&gt;mode}" importance="{objectPageLayoutMetadata&gt;importance}" actions="{path:\'objectPageLayoutMetadata&gt;actions\',factory:\'.controlFactory\'}" blocks="{path:\'objectPageLayoutMetadata&gt;blocks\',factory:\'.controlFactory\'}" moreBlocks="{path:\'objectPageLayoutMetadata&gt;moreBlocks\',factory:\'.controlFactory\'}"/></subSections></ObjectPageSection></sections></ObjectPageLayout></core:View>',
	"sap/uxap/manifest.json":'{"_version":"1.9.0","sap.app":{"id":"sap.uxap","type":"library","embeds":["component"],"applicationVersion":{"version":"1.71.16"},"title":"SAP UxAP","description":"SAP UxAP","ach":"CA-UI5-CTR","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.71","libs":{"sap.ui.core":{"minVersion":"1.71.16"},"sap.m":{"minVersion":"1.71.16"},"sap.ui.layout":{"minVersion":"1.71.16"},"sap.f":{"minVersion":"1.71.16","lazy":true}}},"library":{"i18n":"messagebundle.properties","content":{"controls":["sap.uxap.AnchorBar","sap.uxap.BlockBase","sap.uxap.BreadCrumbs","sap.uxap.HierarchicalSelect","sap.uxap.ObjectPageHeader","sap.uxap.ObjectPageDynamicHeaderTitle","sap.uxap.ObjectPageDynamicHeaderContent","sap.uxap.ObjectPageHeaderActionButton","sap.uxap.ObjectPageHeaderContent","sap.uxap.ObjectPageLayout","sap.uxap.ObjectPageSection","sap.uxap.ObjectPageSectionBase","sap.uxap.ObjectPageSubSection"],"elements":["sap.uxap.ModelMapping","sap.uxap.ObjectPageAccessibleLandmarkInfo","sap.uxap.ObjectPageHeaderLayoutData","sap.uxap.ObjectPageLazyLoader"],"types":["sap.uxap.BlockBaseColumnLayout","sap.uxap.BlockBaseFormAdjustment","sap.uxap.Importance","sap.uxap.ObjectPageConfigurationMode","sap.uxap.ObjectPageHeaderDesign","sap.uxap.ObjectPageHeaderPictureShape","sap.uxap.ObjectPageSubSectionLayout","sap.uxap.ObjectPageSubSectionMode"],"interfaces":["sap.uxap.IHeaderTitle","sap.uxap.IHeaderContent"]}}}}'
},"sap/uxap/library-preload"
);
//# sourceMappingURL=library-preload.js.map