//@ui5-bundle sap-ui-integration-editor.js
/*
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/m/ColorPaletteRenderer',['sap/ui/Device'],function(D){"use strict";var C={apiVersion:2};var l=sap.ui.getCore().getLibraryResourceBundle("sap.m");
C.render=function(r,c){r.openStart("div",c);r.class("sapMColorPalette");r.openEnd();if(c._getShowDefaultColorButton()){this.renderDefaultColorButton(r,c);this.renderSeparator(r);}this.renderSwatches(r,c);if(c._getShowMoreColorsButton()){this.renderSeparator(r);this.renderMoreColorsButton(r,c);if(D.system.phone){this.renderSeparator(r);}}if(c._getShowRecentColorsSection()){if(!c._getShowMoreColorsButton()||!D.system.phone){this.renderSeparator(r);}this.renderRecentColorsSection(r,c);if(D.system.phone){this.renderSeparator(r);}}r.close("div");};
C.renderSwatches=function(r,c){var s=c.getColors();r.openStart("div",c.getId()+"-swatchCont-paletteColor");r.class("sapMColorPaletteContent");r.accessibilityState(c,{"role":"region","label":l.getText("COLOR_PALETTE_SWATCH_CONTAINER_TITLE")});r.openEnd();s.forEach(function(a,i){this.renderSquare(r,c,a,i,false);},this);r.close("div");};
C.renderSquare=function(r,c,s,i,I){var n=c._ColorsHelper.getNamedColor(s),a=(n===undefined)?l.getText("COLOR_PALETTE_PREDEFINED_COLOR_CUSTOM"):l.getText("COLOR_PALETTE_PREDEFINED_COLOR_"+n.toUpperCase()),b=I?l.getText("COLOR_PALETTE_RECENT_COLOR",[i+1,a]):l.getText("COLOR_PALETTE_PREDEFINED_COLOR",[i+1,a]);r.openStart("div");r.class("sapMColorPaletteSquare");if(I&&s===""){r.class("sapMRecentColorSquareDisabled");}r.attr("data-sap-ui-color",s);r.attr("tabindex","-1");r.attr("title",b);r.accessibilityState(c,{"role":"button","label":b});r.openEnd();r.openStart("div");r.style("background-color",s);r.openEnd();r.close("div");r.close("div");};
C.renderSeparator=function(r){r.openStart("div");r.class("sapMColorPaletteSeparator");r.openEnd();r.voidStart("hr");r.voidEnd();r.close("div");};
C.renderDefaultColorButton=function(r,c){r.renderControl(c._getDefaultColorButton());};
C.renderMoreColorsButton=function(r,c){r.renderControl(c._getMoreColorsButton());};
C.renderRecentColorsSection=function(r,c){var s,R=c._getRecentColors(),a=5,b=l.getText("COLOR_PALETTE_SWATCH_RECENT_COLOR_CONTAINER_TITLE");r.openStart("div",c.getId()+"-swatchCont-recentColors");r.class("sapMColorPaletteContent");r.attr("role","region");r.attr("aria-label",b);r.openEnd();for(var i=0;i<a;i++){if(R[i]){s=R[i];}else{s="";}this.renderSquare(r,c,s,i,true);}r.close("div");};
return C;},true);
sap.ui.predefine('sap/m/ComboBox',['./ComboBoxTextField','./ComboBoxBase','./List','./library','sap/ui/Device','sap/ui/core/Item','./StandardListItem','./ComboBoxRenderer','sap/ui/base/ManagedObjectObserver',"sap/ui/dom/containsOrEquals","sap/m/inputUtils/scrollToItem","sap/m/inputUtils/inputsDefaultFilter","sap/ui/events/KeyCodes","./Toolbar","sap/base/assert","sap/base/security/encodeXML","sap/ui/core/Core","sap/base/Log","sap/ui/dom/jquery/control"],function(C,a,L,l,D,I,S,b,M,c,s,d,K,T,f,g,h,j,q){"use strict";var k=l.ListType;var m=l.ListMode;
var n=a.extend("sap.m.ComboBox",{metadata:{library:"sap.m",designtime:"sap/m/designtime/ComboBox.designtime",properties:{selectedKey:{type:"string",group:"Data",defaultValue:""},selectedItemId:{type:"string",group:"Misc",defaultValue:""},filterSecondaryValues:{type:"boolean",group:"Misc",defaultValue:false}},associations:{selectedItem:{type:"sap.ui.core.Item",multiple:false}},events:{change:{parameters:{value:{type:"string"},itemPressed:{type:"boolean"}}},selectionChange:{parameters:{selectedItem:{type:"sap.ui.core.Item"}}}},dnd:{draggable:false,droppable:true}}});
function H(e,i){if(!i){return;}var r=e.getFocusDomRef(),t=e._getSelectionRange().start,u=r.value.substring(0,r.selectionStart),v=e._shouldResetSelectionStart(i),w=e.getSelectedItem(),G=i.isA("sap.ui.core.SeparatorItem"),x=e.getListItem(i);e.handleListItemsVisualFocus(x);e.setSelection(i);if(i!==w&&!G){e.updateDomValue(i.getText());e.fireSelectionChange({selectedItem:i});i=e.getSelectedItem();x=e.getListItem(i);if(v){t=0;}e.selectText(t,r.value.length);e._bIsLastFocusedItemHeader=false;}if(G){e.setSelectedItem(null);e.fireSelectionChange({selectedItem:null});e.updateDomValue(u);e._bIsLastFocusedItemHeader=true;e._getGroupHeaderInvisibleText().setText(e._oRb.getText("LIST_ITEM_GROUP_HEADER")+" "+i.getText());}if(e.isOpen()){e.removeStyleClass("sapMFocus");e._getList().addStyleClass("sapMListFocus");}else{e.addStyleClass("sapMFocus");}s(x,e.getPicker());}
function o(i,e){if(document.activeElement===this.getFocusDomRef()){this.selectText(i,e);}}
function p(i){var e=this.getSelectedItem(),r=this.getListItem(e),t=e&&r&&r.getDomRef(),u=t&&t.offsetTop,v=t&&t.offsetHeight,P=this.getPicker(),w=P.getDomRef("cont"),x=w.clientHeight;if(e&&((u+v)>(x))){if(!i){this._getList().$().css("visibility","hidden");}else{w.scrollTop=u-v/2;this._getList().$().css("visibility","visible");}}}
n.prototype._getSelectedItemText=function(i){i=i||this.getSelectedItem();if(!i){i=this.getDefaultSelectedItem();}if(i){return i.getText();}return"";};
n.prototype.setSelectedIndex=function(i,_){var e;_=_||this.getItems();i=(i>_.length-1)?_.length-1:Math.max(0,i);e=_[i];if(e){this.setSelection(e);}};
n.prototype.revertSelection=function(){var P,e=this.getPickerTextField();this.setSelectedItem(this._oSelectedItemBeforeOpen);this.setValue(this._sValueBeforeOpen);if(this.getSelectedItem()===null){P=this._sValueBeforeOpen;}else{P=this._oSelectedItemBeforeOpen.getText();}e&&e.setValue(P);};
n.prototype.filterItems=function(O){var e,i=this.getItems(),F=[],r=[],t=O.properties.indexOf("additionalText")>-1,u=this.fnFilter||d,G=[],v=false;this._oFirstItemTextMatched=null;i.forEach(function(w){if(w.isA("sap.ui.core.SeparatorItem")){G.push({header:w,visible:false});v=true;e=this.getListItem(w);e&&e.setVisible(false);return;}var x=u.call(this,O.value,w,t);if(x&&v&&G.length){G[G.length-1].visible=true;v=false;}if(x){r.push(w);F.push(w);}}.bind(this));i.forEach(function(w){if(w.isA("sap.ui.core.SeparatorItem")){return;}var x=F.indexOf(w)>-1;var y=r.indexOf(w)>-1;if(!this._oFirstItemTextMatched&&y){this._oFirstItemTextMatched=w;}e=this.getListItem(w);e&&e.setVisible(x);},this);G.forEach(function(w){if(w.visible){e=this.getListItem(w.header);e&&e.setVisible(true);}}.bind(this));return F;};
n.prototype._filterStartsWithItems=function(i,e){var r=i.toLowerCase();var t=this.getItems(),F=t.filter(function(u){return u[e]&&u[e]().toLowerCase().startsWith(r);});return F;};
n.prototype._getFilters=function(){return this.getFilterSecondaryValues()?["text","additionalText"]:["text"];};
n.prototype.getNextFocusableItem=function(e){var A=this.getSelectableItems(),i=this.getNonSeparatorSelectableItems(A),F=this.hasStyleClass("sapMFocus"),r=this.getSelectedItem()||this._getItemByListItem(this._oLastFocusedListItem),t=this.getFormattedTextFocused(),N;if((F&&this.isOpen())||t){N=A[0];}else if(F&&!this.getValueStateLinks().length){N=i[i.indexOf(r)+(e?1:-1)];}else{N=A[A.indexOf(r)+(e?1:-1)];}if(t||(!t&&r===A[0]&&!e&&this.getValueStateLinks().length)){this.setProperty("formattedTextFocused",!t);}return N;};
n.prototype.getNonSeparatorSelectableItems=function(i){return i.filter(function(e){return!e.isA("sap.ui.core.SeparatorItem");});};
n.prototype._itemsTextStartsWithTypedValue=function(i,t){if(!i||typeof t!="string"||t==""){return false;}return i.getText().toLowerCase().startsWith(t.toLowerCase());};
n.prototype._shouldResetSelectionStart=function(i){var e=this.getFocusDomRef(),r=this._getSelectionRange(),t=r.start!==r.end,u=e.value.substring(0,r.start),v=this._itemsTextStartsWithTypedValue(i,u);return!(v&&(t||this._bIsLastFocusedItemHeader));};
n.prototype._getSelectionRange=function(){var e=this.getFocusDomRef(),v=this.getValue(),i=e.selectionStart,r=e.selectionEnd,R={start:i,end:r};if(!(D.browser.msie||D.browser.edge)){return R;}if(this._bIsLastFocusedItemHeader){R.start=v.length;R.end=v.length;}return R;};
n.prototype.handleListItemsVisualFocus=function(e){if(this._oLastFocusedListItem){this._oLastFocusedListItem.removeStyleClass("sapMLIBFocused");this._oLastFocusedListItem=null;}else if(this.isOpen()&&this.getFocusDomRef()){this.getFocusDomRef().setAttribute("aria-activedescendant",e.getId());}if(e){this._oLastFocusedListItem=e;e.addStyleClass("sapMLIBFocused");}};
n.prototype.setSelection=function(i){var e=this._getList(),r=this._getSuggestionsPopover(),t,u;this.setAssociation("selectedItem",i);this._setPropertyProtected("selectedItemId",(i instanceof I)?i.getId():i,true);if(typeof i==="string"){i=h.byId(i);}if(e){t=this.getListItem(i);if(t){e.setSelectedItem(t,true);}else{e.removeSelections(true);}}u=i?i.getKey():"";this._setPropertyProtected("selectedKey",u);if(r){r._iPopupListSelectedIndex=this.getItems().indexOf(i);}};
n.prototype.isSelectionSynchronized=function(){var i=this.getSelectedItem();return this.getSelectedKey()===(i&&i.getKey());};
n.prototype._mapItemToListItem=function(i){var e,r,t,A;var R=this.getRenderer();if(!i){return null;}A=(i.getAdditionalText&&this.getShowSecondaryValues())?i.getAdditionalText():"";r=R.CSS_CLASS_COMBOBOXBASE+"Item";t=(this.isItemSelected(i))?r+"Selected":"";if(i.isA("sap.ui.core.SeparatorItem")){e=this._mapSeparatorItemToGroupHeader(i,R);}else{e=new S({type:k.Active,info:A,visible:i.getEnabled()}).addStyleClass(r+" "+t);}e.setTitle(i.getText());this.setSelectable(i,i.getEnabled());e.setTooltip(i.getTooltip());i.data(R.CSS_CLASS_COMBOBOXBASE+"ListItem",e);i.getCustomData().forEach(function(u){e.addCustomData(u.clone());});this._oItemObserver.observe(i,{properties:["text","additionalText","enabled","tooltip"]});return e;};
n.prototype._forwardItemProperties=function(P){var i=P.object,e=i.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"ListItem"),r={text:"title",enabled:"visible",tooltip:"tooltip"},A,t,u;if(Object.keys(r).indexOf(P.name)>-1){t=r[P.name];u="set"+t.charAt(0).toUpperCase()+t.slice(1);e[u](P.current);}if(P.name==="additionalText"){A=this.getShowSecondaryValues()?P.current:"";e.setInfo(A);}};
n.prototype.isItemSelected=function(i){return i&&(i.getId()===this.getAssociation("selectedItem"));};
n.prototype.setAssociation=function(A,i,e){var r=this._getList();if(r&&(A==="selectedItem")){if(!(i instanceof I)){i=this.findItem("id",i);}r.setSelectedItem(this.getListItem(i),true);}return a.prototype.setAssociation.apply(this,arguments);};
n.prototype.removeAllAssociation=function(A,e){var i=this._getList();if(i&&(A==="selectedItem")){L.prototype.removeAllAssociation.apply(i,arguments);}return a.prototype.removeAllAssociation.apply(this,arguments);};
n.prototype.init=function(){this._oRb=h.getLibraryResourceBundle("sap.m");a.prototype.init.apply(this,arguments);this.bOpenValueStateMessage=true;this._sValueBeforeOpen="";this._sInputValueBeforeOpen="";this._oSelectedItemBeforeOpen=null;this._oFirstItemTextMatched=null;this.bIsFocused=false;if(D.system.phone){this.attachEvent("_change",this.onPropertyChange,this);}this._oLastFocusedListItem=null;this._bIsLastFocusedItemHeader=null;this._oItemObserver=new M(this._forwardItemProperties.bind(this));};
n.prototype.onBeforeRendering=function(){a.prototype.onBeforeRendering.apply(this,arguments);var e=this.getSelectedItem(),i=this._getList(),r=e&&this.getListItem(e),F=this.getProperty("formattedTextFocused"),t=this.getPicker()&&this.getPicker().getCustomHeader(),P=(D.browser.msie&&t&&t.getFormattedText)?t.getFormattedText():t;this.synchronizeSelection();if(!this.getOpen()&&document.activeElement===this.getFocusDomRef()){this.addStyleClass("sapMFocus");}if(F){P.addStyleClass("sapMPseudoFocus");i.removeStyleClass("sapMListFocus");r.removeStyleClass("sapMLIBFocused");this.removeStyleClass("sapMFocus");}else if(P){P.removeStyleClass("sapMPseudoFocus");}};
n.prototype._fillList=function(){var e=this._getList(),r,t,u,i,v;if(!e){return;}if(this._oLastFocusedListItem){v=this._getItemByListItem(this._oLastFocusedListItem);}e.destroyItems();r=this.getItems();if(this._sInputValueBeforeOpen){r=this.filterItems({properties:this._getFilters(),value:this._sInputValueBeforeOpen});}for(i=0,u=r.length;i<u;i++){t=this._mapItemToListItem(r[i]);e.addAggregation("items",t,true);}if(v){this._oLastFocusedListItem=this.getListItem(v);}};
n.prototype.exit=function(){a.prototype.exit.apply(this,arguments);this._oRb=null;this._oSelectedItemBeforeOpen=null;this._oFirstItemTextMatched=null;this._oLastFocusedListItem=null;if(this._oSuggestionPopover){if(this._oPickerCustomHeader){this._oPickerCustomHeader.destroy();this._oPickerCustomHeader=null;}this._oSuggestionPopover.destroy();this._oSuggestionPopover=null;}if(this._oItemObserver){this._oItemObserver.disconnect();this._oItemObserver=null;}};
n.prototype.onBeforeRenderingPicker=function(){var O=this["onBeforeRendering"+this.getPickerType()];O&&O.call(this);};
n.prototype.onBeforeRenderingDropdown=function(){var P=this.getPicker(),w=(this.$().outerWidth()/parseFloat(l.BaseFontSize))+"rem";if(P){P.setContentMinWidth(w);}};
n.prototype.onBeforeRenderingList=function(){if(this.bProcessingLoadItemsEvent){var e=this._getList(),F=this.getFocusDomRef();if(e){e.setBusy(true);}if(F){F.setAttribute("aria-busy","true");}}};
n.prototype.onAfterRenderingPicker=function(){var O=this["onAfterRendering"+this.getPickerType()];O&&O.call(this);p.call(this,false);};
n.prototype.onAfterRenderingList=function(){var e=this.getSelectedItem(),i=this.getListItem(e);if(this.bProcessingLoadItemsEvent&&(this.getItems().length===0)){return;}var r=this._getList(),F=this.getFocusDomRef();this.highlightList(this._sInputValueBeforeOpen);if(e){r.setSelectedItem(i);this.handleListItemsVisualFocus(i);}if(r){r.setBusy(false);}if(F){F.removeAttribute("aria-busy");}};
n.prototype.oninput=function(e){a.prototype.oninput.apply(this,arguments);this.syncPickerContent();if(e.isMarked("invalid")){return;}this.loadItems(function(){this.handleInputValidation(e,this.isComposingCharacter());},{name:"input",busyIndicator:false});if(this.bProcessingLoadItemsEvent&&(this.getPickerType()==="Dropdown")){this.open();}if(this._oLastFocusedListItem){this._oLastFocusedListItem.removeStyleClass("sapMLIBFocused");this._oLastFocusedListItem=null;}this.setFormattedTextFocused(false);this.addStyleClass("sapMFocus");this._getList().removeStyleClass("sapMListFocus");if(this._getItemsShownWithFilter()){this.toggleIconPressedStyle(true);}};
n.prototype.handleInputValidation=function(e,i){var v,r,F,t,u,w=this.getSelectedItem(),V=e.target.value,E=V==="",x=e.srcControl,y=(this.getPickerType()==="Dropdown"),z=this.getListItem(w);if(E&&!this.bOpenedByKeyboardOrButton&&!this.isPickerDialog()){v=this.getItems();}else{v=this.filterItems({properties:this._getFilters(),value:V});}F=v[0];t=v.some(function(A){return A.getKey()===this.getSelectedKey();},this);r=this.intersectItems(this._filterStartsWithItems(V,'getText'),v);u=!E&&F&&F.getEnabled();if(F&&this.getSelectedKey()&&!t){this.setSelection(null);}if(u&&x&&x._bDoTypeAhead){this.handleTypeAhead(x,v,V,i);}else if(u&&V===r[0].getText()){this.setSelection(r[0]);}else{this.setSelection(null);}if(w!==this.getSelectedItem()){this.fireSelectionChange({selectedItem:this.getSelectedItem()});z=this.getListItem(this.getSelectedItem());}this._sInputValueBeforeOpen=V;if(this.isOpen()){setTimeout(function(){this.highlightList(V);}.bind(this));}if(F){if(E&&!this.bOpenedByKeyboardOrButton){this.close();}else if(y){this.open();s(z,this.getPicker());}}else if(this.isOpen()){if(y&&!this.bOpenedByKeyboardOrButton){this.close();}}else{this.clearFilter();}};
n.prototype.handleTypeAhead=function(i,e,v,r){var t=this.intersectItems(this._filterStartsWithItems(v,'getText'),e);var u=this.getFilterSecondaryValues();var w=D.system.desktop;var x=this.intersectItems(this._filterStartsWithItems(v,'getAdditionalText'),e);if(u&&!t[0]&&x[0]){!r&&i.updateDomValue(x[0].getAdditionalText());this.setSelection(x[0]);}else if(t[0]){!r&&i.updateDomValue(t[0].getText());this.setSelection(t[0]);}if(w){o.call(i,v.length,i.getValue().length);}else{setTimeout(o.bind(i,v.length,i.getValue().length),0);}this.addStyleClass("sapMFocus");this._getList().removeStyleClass("sapMListFocus");};
n.prototype.onSelectionChange=function(e){var i=this._getItemByListItem(e.getParameter("listItem")),P=this.getChangeEventParams(),r=(i!==this.getSelectedItem());this.updateDomValue(i.getText());this.setSelection(i);this.fireSelectionChange({selectedItem:this.getSelectedItem()});if(r){P.itemPressed=true;this.onChange(null,P);}};
n.prototype.onItemPress=function(e){var i=e.getParameter("listItem"),t=i.getTitle(),P=this.getChangeEventParams(),r=(i!==this.getListItem(this.getSelectedItem()));if(i.isA("sap.m.GroupHeaderListItem")){return;}this.handleListItemsVisualFocus(i);this.updateDomValue(t);if(!r){P.itemPressed=true;this.onChange(null,P);}this._setPropertyProtected("value",t,true);if(this.getPickerType()==="Dropdown"&&!this.isPlatformTablet()){this.selectText.bind(this,this.getValue().length,this.getValue().length);}this.close();};
n.prototype.onBeforeOpen=function(){a.prototype.onBeforeOpen.apply(this,arguments);var P=this["onBeforeOpen"+this.getPickerType()],e=this.getFocusDomRef();this.setProperty("open",true);if(this.hasLoadItemsEventListeners()&&!this.bProcessingLoadItemsEvent){this.loadItems();}if(e){e.setAttribute("aria-controls",this.getPicker().getId());}this.addContent();P&&P.call(this);};
n.prototype.onBeforeOpenDialog=function(){var P=this.getPickerTextField();this._oSelectedItemBeforeOpen=this.getSelectedItem();this._sValueBeforeOpen=this.getValue();if(this.getSelectedItem()){this.filterItems({properties:this._getFilters(),value:""});}P.setValue(this._sValueBeforeOpen);};
n.prototype.onAfterOpen=function(){var i=this.getSelectedItem(),e=this._getSelectionRange(),t=this.isPlatformTablet();this.closeValueStateMessage();p.call(this,true);if(!t&&i&&e.start===e.end&&e.start>1){setTimeout(function(){this.selectText(0,e.end);}.bind(this),0);}};
n.prototype.onBeforeClose=function(){a.prototype.onBeforeClose.apply(this,arguments);var e=this.getFocusDomRef();this.setProperty("open",false);this.setProperty("formattedTextFocused",false);if(e){e.removeAttribute("aria-controls");}this.toggleIconPressedStyle(false);};
n.prototype.onAfterClose=function(){this.clearFilter();this._sInputValueBeforeOpen="";if(this.isPickerDialog()){a.prototype.closeValueStateMessage.apply(this,arguments);}};
n.prototype.onItemChange=function(e){var i=this.getAssociation("selectedItem"),N=e.getParameter("newValue"),P=e.getParameter("name");if(i===e.getParameter("id")){switch(P){case"text":if(!this.isBound("value")){this.setValue(N);}break;case"key":if(!this.isBound("selectedKey")){this.setSelectedKey(N);}break;}}};
n.prototype.onkeydown=function(e){var i=e.srcControl;a.prototype.onkeydown.apply(i,arguments);if(!i.getEnabled()||!i.getEditable()){return;}var r=K;i._bDoTypeAhead=!D.os.android&&(e.which!==r.BACKSPACE)&&(e.which!==r.DELETE);};
n.prototype.oncut=function(e){var i=e.srcControl;a.prototype.oncut.apply(i,arguments);i._bDoTypeAhead=false;};
n.prototype.onsapenter=function(e){var i=e.srcControl,r=i.getSelectedItem();if(r&&this.getFilterSecondaryValues()){i.updateDomValue(r.getText());}a.prototype.onsapenter.apply(i,arguments);if(!i.getEnabled()||!i.getEditable()){return;}if(i.isOpen()&&!this.isComposingCharacter()){i.close();}};
n.prototype.onsapdown=function(e){var i=e.srcControl;if(!i.getEnabled()||!i.getEditable()){return;}this.syncPickerContent();e.setMarked();e.preventDefault();this.loadItems(function r(){H.call(this,i,this.getNextFocusableItem(true));});};
n.prototype.onsapup=function(e){var i=e.srcControl;if(!i.getEnabled()||!i.getEditable()){return;}this.syncPickerContent();e.setMarked();e.preventDefault();this.loadItems(function r(){H.call(this,i,this.getNextFocusableItem(false));});};
n.prototype.onsaphome=function(e){var i=e.srcControl;if(!i.getEnabled()||!i.getEditable()){return;}this.syncPickerContent();e.setMarked();if(this.getValueStateLinks().length){this.setProperty("formattedTextFocused",true);}e.preventDefault();this.loadItems(function r(){var F=this.getSelectableItems()[0];H.call(this,i,F);});};
n.prototype.onsapend=function(e){var i=e.srcControl;if(!i.getEnabled()||!i.getEditable()){return;}this.syncPickerContent();e.setMarked();e.preventDefault();if(this.getValueStateLinks().length&&this.getFormattedTextFocused()){this.setProperty("formattedTextFocused",false);}this.loadItems(function t(){var r=this.findLastEnabledItem(this.getSelectableItems());H.call(this,i,r);});};
n.prototype.onsappagedown=function(e){var i=e.srcControl;if(!i.getEnabled()||!i.getEditable()){return;}this.syncPickerContent();e.setMarked();e.preventDefault();if(this.getValueStateLinks().length&&this.getFormattedTextFocused()){this.setProperty("formattedTextFocused",false);}this.loadItems(function(){var r=this.getNonSeparatorSelectableItems(this.getSelectableItems()),t=r.indexOf(this.getSelectedItem())+10,u;t=(t>r.length-1)?r.length-1:Math.max(0,t);u=r[t];H.call(this,i,u);});};
n.prototype.onsappageup=function(e){var i=e.srcControl;if(!i.getEnabled()||!i.getEditable()){return;}this.syncPickerContent();e.setMarked();e.preventDefault();this.loadItems(function(){var r=this.getNonSeparatorSelectableItems(this.getSelectableItems()),t=r.indexOf(this.getSelectedItem())-10,u;t=(t>r.length-1)?r.length-1:Math.max(0,t);u=r[t];H.call(this,i,u);});};
n.prototype.onsapshow=function(e){var i,r,E=this.getEditable(),t;a.prototype.onsapshow.apply(this,arguments);this.syncPickerContent();if(!this.getValue()&&E){i=this.getSelectableItems();r=this.getNonSeparatorSelectableItems(i)[0];if(r){t=this.getListItem(r);if(this.isOpen()){this.removeStyleClass("sapMFocus");this._getList().addStyleClass("sapMListFocus");this.handleListItemsVisualFocus(t);}else{this.addStyleClass("sapMFocus");}this.setSelection(r);this.updateDomValue(r.getText());this.fireSelectionChange({selectedItem:r});setTimeout(function(){this.selectText(0,r.getText().length);}.bind(this),0);}}};
n.prototype.onsaphide=n.prototype.onsapshow;
n.prototype.ontap=function(e){var i=this.getFocusDomRef(),A="aria-activedescendant";this.addStyleClass("sapMFocus");if(this.getFormattedTextFocused()){this.setFormattedTextFocused(false);}else if((this.getOpen()&&this._getList().hasStyleClass("sapMListFocus"))||this._oLastFocusedListItem){this._getList().removeStyleClass("sapMListFocus");this._oLastFocusedListItem.removeStyleClass("sapMLIBFocused");this._oLastFocusedListItem=null;i.removeAttribute(A);}};
n.prototype.onfocusin=function(e){var i=this.getPickerType()==="Dropdown";if(this._bIsBeingDestroyed){return;}if(e.target===this.getOpenArea()){this.bOpenValueStateMessage=false;if(i&&!this.isPlatformTablet()){this.focus();}}else{if(i){setTimeout(function(){if(document.activeElement===this.getFocusDomRef()&&!this.bIsFocused&&!this.bFocusoutDueRendering&&!this.getSelectedText()){this.selectText(0,this.getValue().length);}this.bIsFocused=true;}.bind(this),0);}if(!this.isOpen()&&this.bOpenValueStateMessage&&this.shouldValueStateMessageBeOpened()){this.openValueStateMessage();}this.bOpenValueStateMessage=true;}if(this.getEnabled()&&(!this.isOpen()||!this.getSelectedItem()||!this._getList().hasStyleClass("sapMListFocus"))){this.addStyleClass("sapMFocus");}};
n.prototype.onsapfocusleave=function(e){this.bIsFocused=false;var t,P,r,F,i=this.getSelectedItem();if(i&&this.getFilterSecondaryValues()){this.updateDomValue(i.getText());}a.prototype.onsapfocusleave.apply(this,arguments);if(this.isPickerDialog()){return;}P=this.getPicker();if(!e.relatedControlId||!P){return;}t=this.isPlatformTablet();r=h.byId(e.relatedControlId);F=r&&r.getFocusDomRef();if(c(P.getFocusDomRef(),F)&&!t&&!this.getFormattedTextFocused()){this.focus();}};
n.prototype.synchronizeSelection=function(){if(this.isSelectionSynchronized()){return;}var e=this.getSelectedKey(),i=this.getItemByKey(""+e);if(i&&(e!=="")){this.setAssociation("selectedItem",i,true);this._setPropertyProtected("selectedItemId",i.getId(),true);this.setValue(i.getText());this._sValue=this.getValue();}};
n.prototype.configPicker=function(P){var r=this.getRenderer(),e=r.CSS_CLASS_COMBOBOXBASE;P.setHorizontalScrolling(false).addStyleClass(e+"Picker").addStyleClass(e+"Picker-CTX").attachBeforeOpen(this.onBeforeOpen,this).attachAfterOpen(this.onAfterOpen,this).attachBeforeClose(this.onBeforeClose,this).attachAfterClose(this.onAfterClose,this).addEventDelegate({onBeforeRendering:this.onBeforeRenderingPicker,onAfterRendering:this.onAfterRenderingPicker},this);};
n.prototype._configureList=function(e){var r=this.getRenderer();if(!e){return;}e.setMode(m.SingleSelectMaster).addStyleClass(r.CSS_CLASS_COMBOBOXBASE+"List").addStyleClass(r.CSS_CLASS_COMBOBOX+"List");e.attachSelectionChange(this.onSelectionChange,this).attachItemPress(this.onItemPress,this);e.addEventDelegate({onBeforeRendering:this.onBeforeRenderingList,onAfterRendering:this.onAfterRenderingList},this);};
n.prototype.destroyItems=function(){this.destroyAggregation("items");if(this._getList()){this._getList().destroyItems();}return this;};
n.prototype.getDefaultSelectedItem=function(){return null;};
n.prototype.getChangeEventParams=function(){return{itemPressed:false};};
n.prototype.clearSelection=function(){this.setSelection(null);};
n.prototype.selectText=function(i,e){a.prototype.selectText.apply(this,arguments);this.textSelectionStart=i;this.textSelectionEnd=e;return this;};
n.prototype.removeAllItems=function(){var i=a.prototype.removeAllItems.apply(this,arguments);this._fillList();return i;};
n.prototype.clone=function(i){var e=a.prototype.clone.apply(this,arguments),r=this._getList();if(!this.isBound("items")&&r){e.syncPickerContent();e.setSelectedIndex(this.indexOfItem(this.getSelectedItem()));}return e;};
n.prototype.open=function(){this.syncPickerContent();var e=this._getList();a.prototype.open.call(this);if(this.getSelectedItem()){e.addStyleClass("sapMListFocus");this.removeStyleClass("sapMFocus");}return this;};
n.prototype.syncPickerContent=function(){var P,e=this.getPicker(),i=this.getInputForwardableProperties();if(!e){var r,G;e=this.createPicker(this.getPickerType());P=this.getPickerTextField();this._fillList();if(P){i.forEach(function(t){t=t.charAt(0).toUpperCase()+t.slice(1);r="set"+t;G="get"+t;if(P[r]){P[r](this[G]());}},this);}this._getSuggestionsPopover().updateValueState(this.getValueState(),this.getValueStateText(),this.getShowValueStateMessage());}this.synchronizeSelection();return e;};
n.prototype.findAggregatedObjects=function(){var e=this._getList();if(e){return L.prototype.findAggregatedObjects.apply(e,arguments);}return[];};
n.prototype.setSelectedItem=function(i){if(typeof i==="string"){this.setAssociation("selectedItem",i,true);i=h.byId(i);}if(!(i instanceof I)&&i!==null){return this;}if(!i){i=this.getDefaultSelectedItem();}this.setSelection(i);this.setValue(this._getSelectedItemText(i));return this;};
n.prototype.setSelectedItemId=function(i){i=this.validateProperty("selectedItemId",i);if(!i){i=this.getDefaultSelectedItem();}this.setSelection(i);i=this.getSelectedItem();this.setValue(this._getSelectedItemText(i));return this;};
n.prototype.setSelectedKey=function(e){e=this.validateProperty("selectedKey",e);var i=(e===""),r=this.isBound("selectedKey")&&this.isBound("value")&&this.getBindingInfo("selectedKey").skipModelUpdate;if(i){this.setSelection(null);if(!r){this.setValue("");}return this;}var t=this.getItemByKey(e);if(t){this.setSelection(t);if(!r){this.setValue(this._getSelectedItemText(t));}return this;}this._sValue=this.getValue();return this._setPropertyProtected("selectedKey",e);};
n.prototype._setPropertyProtected=function(P,v,i){try{return this.setProperty(P,v,i);}catch(e){j.warning("setSelectedKey update failed due to exception. Loggable in support mode log",null,null,function(){return{exception:e};});}};
n.prototype.getSelectedItem=function(){var v=this.getAssociation("selectedItem");return(v===null)?null:h.byId(v)||null;};
n.prototype.removeItem=function(i){i=a.prototype.removeItem.apply(this,arguments);var e;if(this._getList()){this._getList().removeItem(i&&this.getListItem(i));}if(this.isBound("items")&&!this.bItemsUpdated){return i;}var v=this.getValue();if(this.getItems().length===0){this.clearSelection();}else if(this.isItemSelected(i)){e=this.getDefaultSelectedItem();this.setSelection(e);this.setValue(v);}return i;};
n.prototype._modifyPopupInput=function(i){a.prototype._modifyPopupInput.apply(this,arguments);i.addEventDelegate({onsapenter:function(){var t=i.getValue();this.updateDomValue(t);this.onChange();if(t){this.updateDomValue(t);this.onChange();this.close();}}},this);return i;};
n.prototype.applyShowItemsFilters=function(){var P,e;this.syncPickerContent();P=this.getPicker();e=function(){P.detachBeforeOpen(e,this);P=null;this.filterItems({value:this.getValue()||"_",properties:this._getFilters()});};P.attachBeforeOpen(e,this);};
n.prototype.showItems=function(F){var e,i=Array.prototype.slice.call(arguments),r=this.fnFilter,t=function(){this.setFilterFunction(F||function(){return true;});e=this.filterItems({value:this.getValue()||"_",properties:this._getFilters()});this.setFilterFunction(r);if(e&&e.length){a.prototype.showItems.apply(this,i);}}.bind(this);this.attachLoadItems(t);this.loadItems(t);};
n.prototype._getFormattedValueStateText=function(){if(this.isOpen()){return this._getSuggestionsPopover()._getValueStateHeader().getFormattedText();}else{return C.prototype.getFormattedValueStateText.call(this);}};
return n;});
sap.ui.predefine('sap/m/ComboBoxBase',['./Dialog','./ComboBoxTextField','./Input','./GroupHeaderListItem','./SuggestionsPopover','sap/ui/core/SeparatorItem','sap/ui/core/InvisibleText','sap/base/Log','./library','sap/ui/Device','sap/ui/core/library','./ComboBoxBaseRenderer',"sap/ui/dom/containsOrEquals","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery","sap/base/security/encodeXML","sap/base/strings/escapeRegExp","sap/m/inputUtils/highlightDOMElements"],function(D,C,I,G,S,a,b,L,l,c,d,e,f,K,q,g,h,j){"use strict";var k=l.ListType;var P=l.PlacementType;var m=["value","enabled","name","placeholder","editable","textAlign","textDirection","valueState","valueStateText"];
var n=C.extend("sap.m.ComboBoxBase",{metadata:{library:"sap.m","abstract":true,defaultAggregation:"items",properties:{showSecondaryValues:{type:"boolean",group:"Misc",defaultValue:false},formattedTextFocused:{type:"boolean",defaultValue:false,hidden:true},open:{type:"boolean",defaultValue:false,hidden:true}},aggregations:{items:{type:"sap.ui.core.Item",multiple:true,singularName:"item",bindable:"bindable"},picker:{type:"sap.ui.core.PopupInterface",multiple:false,visibility:"hidden"}},events:{loadItems:{}},dnd:{draggable:false,droppable:true}}});
n.prototype.oncompositionstart=function(){this._bIsComposingCharacter=true;};
n.prototype.oncompositionend=function(E){this._bIsComposingCharacter=false;this._sComposition=E.target.value;if(!c.browser.edge&&!c.browser.firefox){C.prototype.handleInput.apply(this,arguments);this.handleInputValidation(E,this.isComposingCharacter());}};
n.prototype.isComposingCharacter=function(){return this._bIsComposingCharacter;};
n.prototype.updateItems=function(r){this.bItemsUpdated=false;this.destroyItems();this.updateAggregation("items");this.bItemsUpdated=true;if(this.hasLoadItemsEventListeners()){this.onItemsLoaded();}};
n.prototype.setFilterFunction=function(F){if(F===null||F===undefined){this.fnFilter=null;return this;}if(typeof(F)!=="function"){L.warning("Passed filter is not a function and the default implementation will be used");}else{this.fnFilter=F;}return this;};
n.prototype.highlightList=function(v){var i=[];i=this._getList().$().find('.sapMSLIInfo, .sapMSLITitleOnly');j(i,v);};
n.prototype._modifyPopupInput=function(i){this.setTextFieldHandler(i);return i;};
n.prototype.setTextFieldHandler=function(t){var i=this,T=t._handleEvent;t._handleEvent=function(E){T.apply(this,arguments);if(/keydown|sapdown|sapup|saphome|sapend|sappagedown|sappageup|input/.test(E.type)){i._handleEvent(E);}};};
n.prototype.refreshItems=function(){this.bItemsUpdated=false;this.refreshAggregation("items");};
n.prototype.loadItems=function(i,o){var p=typeof i==="function";if(this.hasLoadItemsEventListeners()&&(this.getItems().length===0)){this._bOnItemsLoadedScheduled=false;if(p){o=q.extend({action:i,busyIndicator:true,busyIndicatorDelay:300},o);this.aMessageQueue.push(o);if((this.iLoadItemsEventInitialProcessingTimeoutID===-1)&&(o.busyIndicator)){this.iLoadItemsEventInitialProcessingTimeoutID=setTimeout(function r(){this.setInternalBusyIndicatorDelay(0);this.setInternalBusyIndicator(true);}.bind(this),o.busyIndicatorDelay);}}if(!this.bProcessingLoadItemsEvent){this.bProcessingLoadItemsEvent=true;this.fireLoadItems();}}else if(p){i.call(this);}};
n.prototype.onItemsLoaded=function(){this.bProcessingLoadItemsEvent=false;clearTimeout(this.iLoadItemsEventInitialProcessingTimeoutID);if(this.bInitialBusyIndicatorState!==this.getBusy()){this.setInternalBusyIndicator(this.bInitialBusyIndicatorState);}if(this.iInitialBusyIndicatorDelay!==this.getBusyIndicatorDelay()){this.setInternalBusyIndicatorDelay(this.iInitialBusyIndicatorDelay);}for(var i=0,o,N,p;i<this.aMessageQueue.length;i++){o=this.aMessageQueue.shift();i--;p=(i+1)===this.aMessageQueue.length;N=p?null:this.aMessageQueue[i+1];if(typeof o.action==="function"){if((o.name==="input")&&!p&&(N.name==="input")){continue;}o.action.call(this);}}};
n.prototype.hasLoadItemsEventListeners=function(){return this.hasListeners("loadItems");};
n.prototype._scheduleOnItemsLoadedOnce=function(){if(!this._bOnItemsLoadedScheduled&&!this.isBound("items")&&this.hasLoadItemsEventListeners()&&this.bProcessingLoadItemsEvent){this._bOnItemsLoadedScheduled=true;setTimeout(this.onItemsLoaded.bind(this),0);}};
n.prototype.getPickerInvisibleTextId=function(){return b.getStaticId("sap.m","COMBOBOX_AVAILABLE_OPTIONS");};
n.prototype._getGroupHeaderInvisibleText=function(){if(!this._oGroupHeaderInvisibleText){this._oGroupHeaderInvisibleText=new b();this._oGroupHeaderInvisibleText.toStatic();}return this._oGroupHeaderInvisibleText;};
n.prototype._getItemByListItem=function(o){return this._getItemBy(o,"ListItem");};
n.prototype._getItemBy=function(o,s){s=this.getRenderer().CSS_CLASS_COMBOBOXBASE+s;for(var i=0,p=this.getItems(),r=p.length;i<r;i++){if(p[i].data(s)===o){return p[i];}}return null;};
n.prototype._isListInSuggestMode=function(){return this._getList().getItems().some(function(o){return!o.getVisible()&&this._getItemByListItem(o).getEnabled();},this);};
n.prototype.getListItem=function(i){return i?i.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"ListItem"):null;};
n.prototype.getSelectable=function(i){return i._bSelectable;};
n.prototype._setItemsShownWithFilter=function(v){this._bItemsShownWithFilter=v;};
n.prototype._getItemsShownWithFilter=function(){return this._bItemsShownWithFilter;};
n.prototype.init=function(){C.prototype.init.apply(this,arguments);this.setPickerType(c.system.phone?"Dialog":"Dropdown");this._setItemsShownWithFilter(false);this.bItemsUpdated=false;this.bOpenedByKeyboardOrButton=false;this._bShouldClosePicker=false;this._oPickerValueStateText=null;this.bProcessingLoadItemsEvent=false;this.iLoadItemsEventInitialProcessingTimeoutID=-1;this.aMessageQueue=[];this.bInitialBusyIndicatorState=this.getBusy();this.iInitialBusyIndicatorDelay=this.getBusyIndicatorDelay();this._bOnItemsLoadedScheduled=false;this._bDoTypeAhead=true;this.getIcon().addEventDelegate({onmousedown:function(E){this._bShouldClosePicker=this.isOpen();}},this);this.getIcon().attachPress(this._handlePopupOpenAndItemsLoad.bind(this,true));this._sComposition="";this.fnFilter=null;};
n.prototype.onBeforeRendering=function(){var s=this.getOpen(),v=s?this._getSuggestionsPopover()._getValueStateHeader().getText():null,V=s?this._getSuggestionsPopover()._getValueStateHeader().getValueState():null;C.prototype.onBeforeRendering.apply(this,arguments);if(s&&((this.getValueStateText()&&v!==this.getValueStateText())||(this.getValueState()!==V)||this.getFormattedValueStateText())){this._updateSuggestionsPopoverValueState();}};
n.prototype._handlePopupOpenAndItemsLoad=function(o){var p;if(!this.getEnabled()||!this.getEditable()){return;}if(o&&this._getItemsShownWithFilter()){this._bShouldClosePicker=false;this.toggleIconPressedStyle(true);this.bOpenedByKeyboardOrButton=false;this.clearFilter();this._setItemsShownWithFilter(false);return;}if(this._bShouldClosePicker){this._bShouldClosePicker=false;this.close();return;}this.loadItems();this.bOpenedByKeyboardOrButton=o;if(this.isPlatformTablet()){this.syncPickerContent();p=this.getPicker();p.setInitialFocus(p);}this.open();};
n.prototype.exit=function(){C.prototype.exit.apply(this,arguments);if(this._getList()){this._getList().destroy();this._oList=null;}if(this._getGroupHeaderInvisibleText()){this._getGroupHeaderInvisibleText().destroy();this._oGroupHeaderInvisibleText=null;}clearTimeout(this.iLoadItemsEventInitialProcessingTimeoutID);this.aMessageQueue=null;this.fnFilter=null;};
n.prototype.onsapshow=function(E){if(!this.getEnabled()||!this.getEditable()){return;}E.setMarked();if(E.keyCode===K.F4){this.onF4(E);}if(this._getItemsShownWithFilter()){this.loadItems(this._handlePopupOpenAndItemsLoad.bind(this,true));return;}if(this.isOpen()){this.close();return;}this.selectText(0,this.getValue().length);this.loadItems();this.bOpenedByKeyboardOrButton=true;this.open();};
n.prototype.onF4=function(E){E.preventDefault();};
n.prototype.onsapescape=function(E){if(this.getEnabled()&&this.getEditable()&&this.isOpen()){E.setMarked();E.preventDefault();this.close();}else{C.prototype.onsapescape.apply(this,arguments);}};
n.prototype.onsaphide=n.prototype.onsapshow;
n.prototype.onsapfocusleave=function(E){if(!E.relatedControlId){C.prototype.onsapfocusleave.apply(this,arguments);return;}var r=sap.ui.getCore().byId(E.relatedControlId);if(r===this){return;}var p=this.getPicker(),F=r&&r.getFocusDomRef();if(p&&f(p.getFocusDomRef(),F)){return;}C.prototype.onsapfocusleave.apply(this,arguments);};
n.prototype.getPopupAnchorDomRef=function(){return this.getDomRef();};
n.prototype.addContent=function(p){};
n.prototype.getList=function(){L.warning("[Warning]:","You are attempting to use deprecated method 'getList()', please refer to SAP note 2746748.",this);return this._getList();};
n.prototype._getList=function(){if(this.bIsDestroyed){return null;}return this._oList;};
n.prototype.setPickerType=function(p){this._sPickerType=p;};
n.prototype.getPickerType=function(){return this._sPickerType;};
n.prototype._updateSuggestionsPopoverValueState=function(){var s=this._getSuggestionsPopover();if(!s){return;}var v=this.getValueState(),N=this.getValueState()!==s._getValueStateHeader().getValueState(),o=this.getFormattedValueStateText(),V=this.getValueStateText(),i=o||N;if(s.isOpen()&&!i){this.setFormattedValueStateText(s._getValueStateHeader().getFormattedText());}s.updateValueState(v,(o||V),this.getShowValueStateMessage());};
n.prototype.shouldValueStateMessageBeOpened=function(){var s=C.prototype.shouldValueStateMessageBeOpened.apply(this,arguments);return(s&&!this.isOpen());};
n.prototype.onPropertyChange=function(o,i){var N=o.getParameter("newValue"),p=o.getParameter("name"),M="set"+p.charAt(0).toUpperCase()+p.slice(1),r=(i&&i.srcControl)||this.getPickerTextField();if(this.getInputForwardableProperties().indexOf(p)>-1&&r&&(typeof r[M]==="function")){r[M](N);}};
n.prototype.getInputForwardableProperties=function(){return m;};
n.prototype.isPickerDialog=function(){return this.getPickerType()==="Dialog";};
n.prototype.isPlatformTablet=function(){var N=!c.system.combi,t=c.system.tablet&&N;return t;};
n.prototype.createPickerTextField=function(){var i=new I({width:"100%",showValueStateMessage:false});return i;};
n.prototype.getDropdownSettings=function(){return{showArrow:false,placement:P.VerticalPreferredBottom,offsetX:0,offsetY:0,bounce:false,ariaLabelledBy:this.getPickerInvisibleTextId()||undefined};};
n.prototype._configureList=function(){};
n.prototype.createPicker=function(p){var o=this.getAggregation("picker");if(o){return o;}this._oSuggestionPopover=this._createSuggestionsPopover();o=this._oSuggestionPopover._oPopover;this.setAggregation("picker",o,true);this.configPicker(o);return o;};
n.prototype.configPicker=function(p){};
n.prototype._hasShowSelectedButton=function(){return false;};
n.prototype._createSuggestionsPopover=function(){var u=this.isPickerDialog(),s;s=new S(this);if(u){var i=this.createPickerTextField();s._oPopupInput=this._modifyPopupInput(i);}s._createSuggestionPopup({showSelectedButton:this._hasShowSelectedButton()});s._createSuggestionPopupContent(false);this.forwardEventHandlersToSuggPopover(s);this._oList=s._oList;this._configureList(this._oList);return s;};
n.prototype.forwardEventHandlersToSuggPopover=function(s){s.setOkPressHandler(this._handleOkPress.bind(this));s.setCancelPressHandler(this._handleCancelPress.bind(this));s.setInputLabels(this.getLabels.bind(this));};
n.prototype._handleOkPress=function(){var t=this,T=t.getPickerTextField();t.updateDomValue(T.getValue());t.onChange();t.close();};
n.prototype._handleCancelPress=function(){this.close();this.revertSelection();};
n.prototype.setSelectable=function(i,s){if(this.indexOfItem(i)<0){return;}i._bSelectable=s;var o=this.getListItem(i);if(o){o.setVisible(s);}};
n.prototype.onBeforeOpen=function(){this._updateSuggestionsPopoverValueState();if(!this._getItemsShownWithFilter()){this.toggleIconPressedStyle(true);}};
n.prototype.onBeforeClose=function(){this.bOpenedByKeyboardOrButton=false;this._setItemsShownWithFilter(false);this._updateSuggestionsPopoverValueState();};
n.prototype.getPicker=function(){var p=this.getAggregation("picker");if(p&&!p.bIsDestroyed&&!this.bIsDestroyed){return p;}return null;};
n.prototype._getSuggestionsPopover=function(){return this._oSuggestionPopover;};
n.prototype.getValueStateLinks=function(){var H=this.getPicker()&&this.getPicker().getCustomHeader()&&typeof this.getPicker().getCustomHeader().getFormattedText==="function",F=H&&this.getPicker().getCustomHeader().getFormattedText(),v=F&&F.getControls();return v||[];};
n.prototype.getPickerTextField=function(){var p=this.getPicker(),s=p&&p.getSubHeader();return s&&s.getContent()[0]||null;};
n.prototype.getPickerTitle=function(){var p=this.getPicker(),H=p&&p.getCustomHeader();if(this.isPickerDialog()&&H){return H.getContentMiddle()[0];}return null;};
n.prototype.revertSelection=function(){};
n.prototype.hasContent=function(){return this.getItems().length>0;};
n.prototype.syncPickerContent=function(){};
n.prototype.findFirstEnabledItem=function(o){o=o||this.getItems();for(var i=0;i<o.length;i++){if(o[i].getEnabled()){return o[i];}}return null;};
n.prototype.findLastEnabledItem=function(i){i=i||this.getItems();return this.findFirstEnabledItem(i.reverse());};
n.prototype.open=function(){var p=this.getPicker();if(p){p.open();}return this;};
n.prototype.getVisibleItems=function(){for(var i=0,o,p=this.getItems(),v=[];i<p.length;i++){o=this.getListItem(p[i]);if(o&&o.getVisible()){v.push(p[i]);}}return v;};
n.prototype.isItemSelected=function(){};
n.prototype.getKeys=function(o){o=o||this.getItems();for(var i=0,p=[];i<o.length;i++){p[i]=o[i].getKey();}return p;};
n.prototype.getSelectableItems=function(){return this.getEnabledItems(this.getVisibleItems());};
n.prototype.findItem=function(p,v){var M="get"+p.charAt(0).toUpperCase()+p.slice(1);for(var i=0,o=this.getItems();i<o.length;i++){if(o[i][M]()===v){return o[i];}}return null;};
n.prototype.getItemByText=function(t){return this.findItem("text",t);};
n.prototype.clearFilter=function(){this.getItems().forEach(function(i){var o=this.getListItem(i);if(o){o.setVisible(i.getEnabled()&&this.getSelectable(i));}},this);};
n.prototype.onItemChange=function(o){};
n.prototype.clearSelection=function(){};
n.prototype.setInternalBusyIndicator=function(B){this.bInitialBusyIndicatorState=this.getBusy();return this.setBusy.apply(this,arguments);};
n.prototype.setInternalBusyIndicatorDelay=function(i){this.iInitialBusyIndicatorDelay=this.getBusyIndicatorDelay();return this.setBusyIndicatorDelay.apply(this,arguments);};
n.prototype.addItem=function(i){this.addAggregation("items",i);if(i){i.attachEvent("_change",this.onItemChange,this);}if(this._getList()){this._getList().addItem(this._mapItemToListItem(i));}return this;};
n.prototype.insertItem=function(i,o){this.insertAggregation("items",i,o,true);if(i){i.attachEvent("_change",this.onItemChange,this);}if(this._getList()){this._getList().insertItem(this._mapItemToListItem(i),o);}this._scheduleOnItemsLoadedOnce();return this;};
n.prototype.getItemAt=function(i){return this.getItems()[+i]||null;};
n.prototype.getFirstItem=function(){return this.getItems()[0]||null;};
n.prototype.getLastItem=function(){var i=this.getItems();return i[i.length-1]||null;};
n.prototype.getEnabledItems=function(i){i=i||this.getItems();return i.filter(function(o){return o.getEnabled();});};
n.prototype.getItemByKey=function(s){return this.findItem("key",s);};
n.prototype.addItemGroup=function(o,H,s){H=H||new a({text:o.text||o.key});this.addAggregation("items",H,s);if(this._getList()&&H.isA("sap.ui.core.SeparatorItem")){this._getList().addItem(this._mapItemToListItem(H));}return H;};
n.prototype._mapSeparatorItemToGroupHeader=function(s){var o=new G({title:s.getText(),ariaLabelledBy:this._getGroupHeaderInvisibleText().getId(),type:k.Inactive});o.addStyleClass(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"NonInteractiveItem");return o;};
n.prototype.isOpen=function(){var p=this.getPicker();return!!(p&&p.isOpen());};
n.prototype.close=function(){var p=this.getPicker();if(p){p.close();}return this;};
n.prototype.removeItem=function(i){i=this.removeAggregation("items",i);if(i){i.detachEvent("_change",this.onItemChange,this);}return i;};
n.prototype.removeAllItems=function(){var o=this.removeAllAggregation("items");this.clearSelection();for(var i=0;i<o.length;i++){o[i].detachEvent("_change",this.onItemChange,this);}return o;};
n.prototype.intersectItems=function(i,o){return i.filter(function(p){return o.map(function(O){return O.getId();}).indexOf(p.getId())!==-1;});};
n.prototype.showItems=function(F){var i=this.fnFilter,o=function(){if(!this.getItems().length){return;}this.detachLoadItems(o);this.setFilterFunction(F||function(){return true;});this.applyShowItemsFilters();this._handlePopupOpenAndItemsLoad(false);this.setFilterFunction(i);}.bind(this);if(!this.getEnabled()||!this.getEditable()){return;}this._setItemsShownWithFilter(true);this.attachLoadItems(o);this.loadItems(o);};
n.prototype.applyShowItemsFilters=function(){};
return n;});
sap.ui.predefine('sap/m/ComboBoxBaseRenderer',['./ComboBoxTextFieldRenderer','sap/ui/core/Renderer','sap/ui/core/Core'],function(C,R,a){"use strict";var b=R.extend(C);b.apiVersion=2;b.CSS_CLASS_COMBOBOXBASE="sapMComboBoxBase";
b.getAccessibilityState=function(c){var A=C.getAccessibilityState.call(this,c),l=c._getList();if(l){A.controls=l.getId();}return A;};
b.addOuterClasses=function(r,c){C.addOuterClasses.apply(this,arguments);var d=b.CSS_CLASS_COMBOBOXBASE;r.class(d);if(!c.getEnabled()){r.class(d+"Disabled");}if(!c.getEditable()){r.class(d+"Readonly");}};
b.addButtonClasses=function(r,c){C.addButtonClasses.apply(this,arguments);r.class(b.CSS_CLASS_COMBOBOXBASE+"Arrow");};
return b;},true);
sap.ui.predefine('sap/m/ComboBoxRenderer',['./ComboBoxBaseRenderer','sap/ui/core/Renderer','sap/ui/Device'],function(C,R){"use strict";var a=R.extend(C);a.apiVersion=2;a.CSS_CLASS_COMBOBOX="sapMComboBox";
a.addOuterClasses=function(r,c){C.addOuterClasses.apply(this,arguments);r.class(a.CSS_CLASS_COMBOBOX);};
a.addInnerClasses=function(r,c){C.addInnerClasses.apply(this,arguments);r.class(a.CSS_CLASS_COMBOBOX+"Inner");};
a.addButtonClasses=function(r,c){C.addButtonClasses.apply(this,arguments);r.class(a.CSS_CLASS_COMBOBOX+"Arrow");};
a.addPlaceholderClasses=function(r,c){C.addPlaceholderClasses.apply(this,arguments);r.class(a.CSS_CLASS_COMBOBOX+"Placeholder");};
a.writeInnerAttributes=function(r,c){var s=c.getSelectedItem(),S=s&&c.getListItem(s),o=c.isOpen(),f=c.getProperty("formattedTextFocused");C.writeInnerAttributes.apply(this,arguments);r.attr("aria-expanded",o);if(f){r.attr("aria-activedescendant",c._getFormattedValueStateText().getId());}else if(o&&S&&S.hasStyleClass("sapMLIBFocused")&&c.getFocusDomRef()===document.activeElement){r.attr("aria-activedescendant",S.getId());}};
return a;},true);
sap.ui.predefine('sap/m/ComboBoxTextField',['./InputBase','./library','sap/ui/core/InvisibleText','sap/ui/core/library','sap/ui/Device','sap/ui/core/LabelEnablement',"./ComboBoxTextFieldRenderer"],function(I,l,a,c,D,L,C){"use strict";
var b=I.extend("sap.m.ComboBoxTextField",{metadata:{library:"sap.m",properties:{maxWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},showButton:{type:"boolean",group:"Appearance",defaultValue:true}}}});
var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");
b.prototype.init=function(){I.prototype.init.apply(this,arguments);this.addEndIcon({id:this.getId()+"-arrow",src:"sap-icon://slim-arrow-down",noTabStop:true,alt:r.getText("COMBOBOX_BUTTON"),decorative:false});};
b.prototype.getIcon=function(){return this.getAggregation("_endIcon")[0];};
b.prototype.toggleIconPressedStyle=function(s){this.toggleStyleClass(I.ICON_PRESSED_CSS_CLASS,s);};
b.prototype.onBeforeRendering=function(){I.prototype.onBeforeRendering.apply(this,arguments);var R=L.getReferencingLabels(this)||[],i=this.getIcon();i.setVisible(this.getShowButton());R.forEach(function(s){if(i.getAriaLabelledBy().indexOf(s)===-1){i.addAssociation("ariaLabelledBy",s,true);}},this);if(!this.oInvisibleText&&D.browser.msie){this.oInvisibleText=new a(this.getId()+'-describedby',{text:r.getText("ACC_CTR_TYPE_COMBO")}).toStatic();}};
b.prototype.getOpenArea=function(){var d=this.getIcon().getDomRef();return d?d.parentNode:d;};
b.prototype.onsapenter=function(e){I.prototype.onsapenter.apply(this,arguments);if(!this.getEnabled()||!this.getEditable()){return;}this._bCheckDomValue&&e.setMarked();var v=this.getValue(),V=v.length;this.setValue(v);this.selectText(V,V);};
b.prototype.getValue=function(){var d=this.getFocusDomRef();if(d){return d.value;}return this.getProperty("value");};
b.prototype.getDomRefForValueStateMessage=function(){return this.getDomRef();};
b.prototype.getAccessibilityInfo=function(){var i=I.prototype.getAccessibilityInfo.apply(this,arguments);i.type=r.getText("ACC_CTR_TYPE_COMBO");return i;};
b.prototype.exit=function(){I.prototype.exit.apply(this,arguments);if(this.oInvisibleText){this.oInvisibleText.destroy();this.oInvisibleText=null;}};
return b;});
sap.ui.predefine('sap/m/ComboBoxTextFieldRenderer',['./InputBaseRenderer','sap/ui/core/Renderer','sap/ui/core/LabelEnablement','sap/ui/Device'],function(I,R,L,D){"use strict";var C=R.extend(I);C.apiVersion=2;C.CSS_CLASS_COMBOBOXTEXTFIELD="sapMComboBoxTextField";
C.writeInnerAttributes=function(r,c){r.attr("role","combobox");r.attr("aria-haspopup","listbox");r.attr("aria-autocomplete","both");r.attr("aria-expanded","false");r.attr("autocomplete","off");r.attr("autocorrect","off");r.attr("autocapitalize","off");r.attr("type","text");};
C.getAriaRole=function(){};
C.getAriaDescribedBy=function(c){var a=I.getAriaDescribedBy.apply(this,arguments);if(D.browser.msie){return(a||"")+" "+c.oInvisibleText.getId();}return a;};
C.addOuterStyles=function(r,c){r.style("max-width",c.getMaxWidth());};
return C;},true);
sap.ui.predefine('sap/m/DatePickerRenderer',['sap/ui/core/Renderer','./InputBaseRenderer','sap/ui/core/library'],function(R,I,c){"use strict";var D=R.extend(I);D.apiVersion=2;
D.writeInnerValue=function(r,d){if(d._bValid){r.attr("value",d._formatValue(d.getDateValue()));}else{r.attr("value",d.getValue());}};
D.writeInnerAttributes=function(r,d){r.attr("type","text");if(d._bMobile){r.attr("readonly","readonly");}};
D.getAriaRole=function(d){return"combobox";};
D.getAccessibilityState=function(d){var a=I.getAccessibilityState.apply(this,arguments);a["roledescription"]=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_DATEINPUT");a["autocomplete"]="none";a["haspopup"]=c.aria.HasPopup.Grid.toLowerCase();a["expanded"]=false;a["disabled"]=null;if(d._bMobile&&d.getEnabled()&&d.getEditable()){a["readonly"]=false;}return a;};
return D;},true);
sap.ui.predefine('sap/m/DateTimeField',['sap/ui/model/type/Date','sap/ui/model/odata/type/ODataType','sap/ui/model/odata/type/DateTimeBase','./InputBase','sap/ui/core/LocaleData','sap/ui/core/library','sap/ui/core/format/DateFormat','./DateTimeFieldRenderer',"sap/base/util/deepEqual","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/cursorPos"],function(S,O,D,I,L,c,a,b,d,f,q){"use strict";var C=c.CalendarType;
var g=I.extend("sap.m.DateTimeField",{metadata:{"abstract":true,library:"sap.m",properties:{displayFormat:{type:"string",group:"Appearance",defaultValue:null},valueFormat:{type:"string",group:"Data",defaultValue:null},dateValue:{type:"object",group:"Data",defaultValue:null},initialFocusedDateValue:{type:"object",group:"Data",defaultValue:null}}}});
g.prototype.setValue=function(v){v=this.validateProperty("value",v);var o=this.getValue();if(v===o){return this;}else{this.setLastValue(v);}this.setProperty("value",v);this._bValid=true;var e;if(v){e=this._parseValue(v);if(!e||e.getTime()<this._oMinDate.getTime()||e.getTime()>this._oMaxDate.getTime()){this._bValid=false;f.warning("Value can not be converted to a valid date",this);}}this.setProperty("dateValue",e);if(this.getDomRef()){var s;if(e){s=this._formatValue(e);}else{s=v;}if(this._$input.val()!==s){this._$input.val(s);this._curpos=this._$input.cursorPos();}}return this;};
g.prototype.setDateValue=function(o){if(!this._isValidDate(o)){throw new Error("Date must be a JavaScript date object; "+this);}if(d(this.getDateValue(),o)){return this;}o=this._dateValidation(o);var v=this._formatValue(o,true);if(v!==this.getValue()){this.setLastValue(v);}this.setProperty("value",v);if(this.getDomRef()){var s=this._formatValue(o);if(this._$input.val()!==s){this._$input.val(s);this._curpos=this._$input.cursorPos();}}return this;};
g.prototype.setValueFormat=function(v){this.setProperty("valueFormat",v,true);var V=this.getValue();if(V){this._handleDateValidation(this._parseValue(V));}return this;};
g.prototype.setDisplayFormat=function(s){this.setProperty("displayFormat",s,true);this.updateDomValue(this._formatValue(this.getDateValue()));this._updateDomPlaceholder(this._getPlaceholder());return this;};
g.prototype.getDisplayFormatType=function(){return null;};
g.prototype._dateValidation=function(o){this._bValid=true;this.setProperty("dateValue",o);return o;};
g.prototype._handleDateValidation=function(o){this._bValid=true;this.setProperty("dateValue",o);};
g.prototype._getPlaceholder=function(){var p=this.getPlaceholder();if(!p){p=this._getDisplayFormatPattern();if(!p){p=this._getDefaultDisplayStyle();}if(this._checkStyle(p)){p=this._getLocaleBasedPattern(p);}}return p;};
g.prototype._getLocaleBasedPattern=function(p){return L.getInstance(sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale()).getDatePattern(p);};
g.prototype._parseValue=function(v,h){var B=this.getBinding("value"),o=B&&B.getType&&B.getType(),F,i,j;if(o&&this._isSupportedBindingType(o)){try{j=o.parseValue(v,"string");if(typeof(j)==="string"&&o instanceof D){j=D.prototype.parseValue.call(o,v,"string");}F=o.oFormatOptions;if(F&&F.source&&F.source.pattern=="timestamp"){j=new Date(j);}else if(F&&F.source&&typeof F.source.pattern==="string"){j=o.oInputFormat.parse(v);}}catch(e){}if(j&&((o.oFormatOptions&&this._isFormatOptionsUTC(o.oFormatOptions))||(o.oConstraints&&o.oConstraints.isDateOnly))){i=new Date(j.getUTCFullYear(),j.getUTCMonth(),j.getUTCDate(),j.getUTCHours(),j.getUTCMinutes(),j.getUTCSeconds(),j.getUTCMilliseconds());i.setFullYear(j.getUTCFullYear());j=i;}return j;}return this._getFormatter(h).parse(v);};
g.prototype._formatValue=function(o,v){if(!o){return"";}var B=this.getBinding("value"),e=B&&B.getType&&B.getType(),F,h;if(e&&this._isSupportedBindingType(e)){if((e.oFormatOptions&&e.oFormatOptions.UTC)||(e.oConstraints&&e.oConstraints.isDateOnly)){h=new Date(Date.UTC(o.getFullYear(),o.getMonth(),o.getDate(),o.getHours(),o.getMinutes(),o.getSeconds(),o.getMilliseconds()));h.setUTCFullYear(o.getFullYear());o=h;}F=e.oFormatOptions;if(F&&F.source&&F.source.pattern=="timestamp"){o=o.getTime();}else if(e.oOutputFormat){return e.oOutputFormat.format(o);}return e.formatValue(o,"string");}return this._getFormatter(!v).format(o);};
g.prototype._isSupportedBindingType=function(B){return B.isA(["sap.ui.model.type.Date","sap.ui.model.odata.type.DateTime","sap.ui.model.odata.type.DateTimeOffset"]);};
g.prototype._isFormatOptionsUTC=function(B){return(B.UTC||(B.source&&B.source.UTC));};
g.prototype._getDefaultDisplayStyle=function(){return"medium";};
g.prototype._getDefaultValueStyle=function(){return"short";};
g.prototype._getFormatter=function(e){var p=this._getBoundValueTypePattern(),r=false,F,B=this.getBinding("value"),s;if(B&&B.oType&&B.oType.oOutputFormat){r=!!B.oType.oOutputFormat.oFormatOptions.relative;s=B.oType.oOutputFormat.oFormatOptions.calendarType;}if(!p){if(e){p=(this.getDisplayFormat()||this._getDefaultDisplayStyle());s=this.getDisplayFormatType();}else{p=(this.getValueFormat()||this._getDefaultValueStyle());s=C.Gregorian;}}if(!s){s=sap.ui.getCore().getConfiguration().getCalendarType();}if(e){if(p===this._sUsedDisplayPattern&&s===this._sUsedDisplayCalendarType){F=this._oDisplayFormat;}}else{if(p===this._sUsedValuePattern&&s===this._sUsedValueCalendarType){F=this._oValueFormat;}}if(F){return F;}return this._getFormatterInstance(F,p,r,s,e);};
g.prototype._getFormatterInstance=function(F,p,r,s,e){if(this._checkStyle(p)){F=this._getFormatInstance({style:p,strictParsing:true,relative:r,calendarType:s},e);}else{F=this._getFormatInstance({pattern:p,strictParsing:true,relative:r,calendarType:s},e);}if(e){this._sUsedDisplayPattern=p;this._sUsedDisplayCalendarType=s;this._oDisplayFormat=F;}else{this._sUsedValuePattern=p;this._sUsedValueCalendarType=s;this._oValueFormat=F;}return F;};
g.prototype._getFormatInstance=function(A,e){return a.getInstance(A);};
g.prototype._checkStyle=function(p){return(p==="short"||p==="medium"||p==="long"||p==="full");};
g.prototype._getDisplayFormatPattern=function(){var p=this._getBoundValueTypePattern();if(p){return p;}p=this.getDisplayFormat();if(this._checkStyle(p)){p=this._getLocaleBasedPattern(p);}return p;};
g.prototype._getBoundValueTypePattern=function(){var B=this.getBinding("value"),o=B&&B.getType&&B.getType();if(o instanceof S){return o.getOutputPattern();}if(o instanceof O&&o.oFormat){return o.oFormat.oFormatOptions.pattern;}return undefined;};
g.prototype._isValidDate=function(o){return!o||Object.prototype.toString.call(o)==="[object Date]";};
g.prototype._updateDomPlaceholder=function(v){if(this.getDomRef()){this._$input.attr("placeholder",v);}};
return g;});
sap.ui.predefine('sap/m/DateTimeFieldRenderer',['sap/ui/core/Renderer','./InputBaseRenderer'],function(R,I){"use strict";var D=R.extend(I);D.apiVersion=2;return D;},true);
sap.ui.predefine('sap/m/DateTimePickerRenderer',['sap/ui/core/Renderer','./DatePickerRenderer','./InputBaseRenderer','sap/ui/core/library'],function(R,D,I,c){"use strict";var a=R.extend(D);a.apiVersion=2;
a.getDescribedByAnnouncement=function(d){var b=I.getDescribedByAnnouncement.apply(this,arguments);return sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("DATETIMEPICKER_TYPE")+" "+b;};
a.getAccessibilityState=function(d){var A=D.getAccessibilityState.apply(this,arguments);A["haspopup"]=c.aria.HasPopup.Dialog.toLowerCase();return A;};
return a;},true);
sap.ui.predefine('sap/m/Input',['./InputBase','./Popover','sap/ui/core/Item','./ColumnListItem','./GroupHeaderListItem','./StandardListItem','sap/ui/core/SeparatorItem','./List','./Table','./library','sap/ui/core/IconPool','sap/ui/Device','sap/ui/core/Control','./SuggestionsPopover','./Toolbar','./ToolbarSpacer','./Button',"sap/ui/dom/containsOrEquals","sap/base/assert","sap/base/util/deepEqual","sap/m/inputUtils/wordStartsWithValue","sap/m/inputUtils/inputsDefaultFilter","sap/m/inputUtils/highlightDOMElements","./InputRenderer","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/selectText"],function(I,P,a,C,G,S,b,L,T,l,c,D,d,e,f,g,B,h,j,k,w,m,n,o,q){"use strict";var p=l.ListType;var r=l.InputTextFormatMode;var s=l.InputType;var t=l.ListMode;var u=l.ListSeparators;
var v=I.extend("sap.m.Input",{metadata:{library:"sap.m",properties:{type:{type:"sap.m.InputType",group:"Data",defaultValue:s.Text},maxLength:{type:"int",group:"Behavior",defaultValue:0},dateFormat:{type:"string",group:"Misc",defaultValue:'YYYY-MM-dd',deprecated:true},showValueHelp:{type:"boolean",group:"Behavior",defaultValue:false},valueHelpIconSrc:{type:"sap.ui.core.URI",group:"Behavior",defaultValue:"sap-icon://value-help"},showSuggestion:{type:"boolean",group:"Behavior",defaultValue:false},valueHelpOnly:{type:"boolean",group:"Behavior",defaultValue:false},filterSuggests:{type:"boolean",group:"Behavior",defaultValue:true},maxSuggestionWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},startSuggestion:{type:"int",group:"Behavior",defaultValue:1},showTableSuggestionValueHelp:{type:"boolean",group:"Behavior",defaultValue:true},description:{type:"string",group:"Misc",defaultValue:null},fieldWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:'50%'},valueLiveUpdate:{type:"boolean",group:"Behavior",defaultValue:false},selectedKey:{type:"string",group:"Data",defaultValue:""},textFormatMode:{type:"sap.m.InputTextFormatMode",group:"Misc",defaultValue:r.Value},textFormatter:{type:"any",group:"Misc",defaultValue:""},suggestionRowValidator:{type:"any",group:"Misc",defaultValue:""},enableSuggestionsHighlighting:{type:"boolean",group:"Behavior",defaultValue:true},autocomplete:{type:"boolean",group:"Behavior",defaultValue:true}},defaultAggregation:"suggestionItems",aggregations:{suggestionItems:{type:"sap.ui.core.Item",multiple:true,singularName:"suggestionItem"},suggestionColumns:{type:"sap.m.Column",multiple:true,singularName:"suggestionColumn",bindable:"bindable",forwarding:{getter:"_getSuggestionsTable",aggregation:"columns"}},suggestionRows:{type:"sap.m.ColumnListItem",altTypes:["sap.m.GroupHeaderListItem"],multiple:true,singularName:"suggestionRow",bindable:"bindable",forwarding:{getter:"_getSuggestionsTable",aggregation:"items"}},_suggestionPopup:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_valueHelpIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},associations:{selectedItem:{type:"sap.ui.core.Item",multiple:false},selectedRow:{type:"sap.m.ColumnListItem",multiple:false}},events:{liveChange:{parameters:{value:{type:"string"},escPressed:{type:"boolean"},previousValue:{type:"string"}}},valueHelpRequest:{parameters:{fromSuggestions:{type:"boolean"}}},suggest:{parameters:{suggestValue:{type:"string"},suggestionColumns:{type:"sap.m.ListBase"}}},suggestionItemSelected:{parameters:{selectedItem:{type:"sap.ui.core.Item"},selectedRow:{type:"sap.m.ColumnListItem"}}},submit:{parameters:{value:{type:"string"}}}},designtime:"sap/m/designtime/Input.designtime"}});
c.insertFontFaceStyle();
v._DEFAULTFILTER_TABULAR=function(V,x){var y=x.getCells(),i=0;for(;i<y.length;i++){if(y[i].getText){if(w(y[i].getText(),V)){return true;}}}return false;};
v._DEFAULTRESULT_TABULAR=function(x){var y=x.getCells(),i=0;for(;i<y.length;i++){if(y[i].getText){return y[i].getText();}}return"";};
v.prototype.init=function(){I.prototype.init.call(this);this._fnFilter=m;this._bFullScreen=D.system.phone;this._iSetCount=0;this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");};
v.prototype.exit=function(){I.prototype.exit.call(this);this._deregisterEvents();this.cancelPendingSuggest();if(this._iRefreshListTimeout){clearTimeout(this._iRefreshListTimeout);this._iRefreshListTimeout=null;}if(this._oSuggestionTable){this._oSuggestionTable.destroy();this._oSuggestionTable=null;}if(this._oSuggPopover){this._oSuggPopover.destroy();this._oSuggPopover=null;}if(this._oShowMoreButton){this._oShowMoreButton.destroy();this._oShowMoreButton=null;}if(this._oButtonToolbar){this._oButtonToolbar.destroy();this._oButtonToolbar=null;}this.$().off("click");};
v.prototype.onBeforeRendering=function(){var i=this.getSelectedKey(),x=this.getShowValueHelp()&&this.getEnabled()&&this.getEditable(),E=this.getAggregation("_endIcon")||[],y=E[0],z,A=this._isSuggestionsPopoverOpen(),V=A?this._oSuggPopover._getValueStateHeader().getText():null,F=A?this._oSuggPopover._getValueStateHeader().getValueState():"";I.prototype.onBeforeRendering.call(this);this._deregisterEvents();if(i){this.setSelectedKey(i);}if(this.getShowSuggestion()){this._oSuggPopover._bAutocompleteEnabled=this.getAutocomplete();if(this.getShowTableSuggestionValueHelp()){this._addShowMoreButton();}else{this._removeShowMoreButton();}z=this._oSuggPopover._oPopupInput;if(z){z.setType(this.getType());}}if(x){y=this._getValueHelpIcon();y.setProperty("visible",true,true);}else if(y){y.setProperty("visible",false,true);}if(!this.getWidth()){this.setProperty("width","100%",true);}if(this._oSuggPopover){this._oSuggPopover._resetTypeAhead();}if(A&&((this.getValueStateText()&&V!==this.getValueStateText())||(this.getValueState()!==F)||(this.getFormattedValueStateText()))){this._updateSuggestionsPopoverValueState();}};
v.prototype._getDisplayText=function(i){var x=this.getTextFormatter();if(x){return x(i);}var y=i.getText(),K=i.getKey(),z=this.getTextFormatMode();switch(z){case r.Key:return K;case r.ValueKey:return y+' ('+K+')';case r.KeyValue:return'('+K+') '+y;default:return y;}};
v.prototype._onValueUpdated=function(i){if(this._bSelectingItem||i===this._sSelectedValue){return;}var K=this.getSelectedKey(),H;if(K===''){return;}if(this._hasTabularSuggestions()){H=this._oSuggestionTable&&!!this._oSuggestionTable.getSelectedItem();}else{H=this._oSuggPopover._oList&&!!this._oSuggPopover._oList.getSelectedItem();}if(H){return;}this.setProperty("selectedKey",'',true);this.setAssociation("selectedRow",null,true);this.setAssociation("selectedItem",null,true);this.fireSuggestionItemSelected({selectedItem:null,selectedRow:null});};
v.prototype._updateSelectionFromList=function(){if(this._oSuggPopover._iPopupListSelectedIndex<0){return false;}var i=this._oSuggPopover._oList.getSelectedItem();if(i){if(this._hasTabularSuggestions()){this.setSelectionRow(i,true);}else{this.setSelectionItem(i._oItem,true);}}return true;};
v.prototype.setSelectionItem=function(i,x){this._bSelectingItem=true;if(!i){this.setAssociation("selectedItem",null,true);this.setValue('');return;}this._oSuggPopover._iPopupListSelectedIndex=-1;var y=this._iSetCount,N;this.setAssociation("selectedItem",i,true);this.setProperty("selectedKey",i.getKey(),true);if(x){this.fireSuggestionItemSelected({selectedItem:i});}if(y!==this._iSetCount){N=this.getValue();}else{N=this._getDisplayText(i);}this._sSelectedValue=N;this.updateInputField(N);if(this.bIsDestroyed){return;}if(!(this.isMobileDevice()&&this instanceof sap.m.MultiInput)){this._closeSuggestionPopup();}this._bSelectingItem=false;};
v.prototype.addSuggestionRowGroup=function(i,H,x){H=H||new G({title:i.text||i.key});this.addAggregation("suggestionRows",H,x);return H;};
v.prototype.addSuggestionItemGroup=function(i,H,x){H=H||new b({text:i.text||i.key});this.addAggregation("suggestionItems",H,x);return H;};
v.prototype.setSelectedItem=function(i){if(typeof i==="string"){i=sap.ui.getCore().byId(i);}if(i!==null&&!(i instanceof a)){return this;}this.setSelectionItem(i);return this;};
v.prototype.setSelectedKey=function(K){K=this.validateProperty("selectedKey",K);this.setProperty("selectedKey",K,true);if(this._hasTabularSuggestions()){return this;}if(!K){this.setSelectionItem();return this;}var i=this.getSuggestionItemByKey(K);this.setSelectionItem(i);return this;};
v.prototype.getSuggestionItemByKey=function(K){var x=this.getSuggestionItems()||[],y,i;for(i=0;i<x.length;i++){y=x[i];if(y.getKey()===K){return y;}}};
v.prototype._getFormattedValueStateText=function(){var i=this._isSuggestionsPopoverOpen(),V=i?this._oSuggPopover._getValueStateHeader().getFormattedText():null;if(i&&V){return V;}else{return I.prototype.getFormattedValueStateText.call(this);}};
v.prototype.setSelectionRow=function(i,x){if(!i){this.setAssociation("selectedRow",null,true);return;}this._oSuggPopover._iPopupListSelectedIndex=-1;this._bSelectingItem=true;var y,z=this.getSuggestionRowValidator();if(z){y=z(i);if(!(y instanceof a)){y=null;}}var A=this._iSetCount,K="",N;this.setAssociation("selectedRow",i,true);if(y){K=y.getKey();}this.setProperty("selectedKey",K,true);if(x){this.fireSuggestionItemSelected({selectedRow:i});}if(A!==this._iSetCount){N=this.getValue();}else{if(y){N=this._getDisplayText(y);}else{N=this._fnRowResultFilter?this._fnRowResultFilter(i):e._DEFAULTRESULT_TABULAR(i);}}this._sSelectedValue=N;this.updateInputField(N);if(this.bIsDestroyed){return;}if(!(this.isMobileDevice()&&this instanceof sap.m.MultiInput&&this._isMultiLineMode)){this._closeSuggestionPopup();}this._bSelectingItem=false;};
v.prototype.setSelectedRow=function(i){if(typeof i==="string"){i=sap.ui.getCore().byId(i);}if(i!==null&&!(i instanceof C)){return this;}this.setSelectionRow(i);return this;};
v.prototype._getValueHelpIcon=function(){var i=this,E=this.getAggregation("_endIcon")||[],x=this.getValueHelpIconSrc(),V=E[0];if(!V){V=this.addEndIcon({id:this.getId()+"-vhi",src:x,useIconTooltip:false,alt:this._oRb.getText("INPUT_VALUEHELP_BUTTON"),decorative:false,noTabStop:true,press:function(y){if(!i.getValueHelpOnly()){var z=this.getParent(),$;if(D.support.touch){$=z.$('inner');$.attr('readonly','readonly');z.focus();$.removeAttr('readonly');}else{z.focus();}i.bValueHelpRequested=true;i._fireValueHelpRequest(false);}}});}else if(V.getSrc()!==x){V.setSrc(x);}return V;};
v.prototype._fireValueHelpRequest=function(F){var i="";if(this.getShowSuggestion()&&this._oSuggPopover){i=this._oSuggPopover._sTypedInValue||"";}else{i=this.getDOMValue();}this.fireValueHelpRequest({fromSuggestions:F,_userInputValue:i});};
v.prototype._fireValueHelpRequestForValueHelpOnly=function(){if(this.getEnabled()&&this.getEditable()&&this.getShowValueHelp()&&this.getValueHelpOnly()){if(D.system.phone){this.focus();}this._fireValueHelpRequest(false);}};
v.prototype.ontap=function(E){I.prototype.ontap.call(this,E);if(this.isValueHelpOnlyOpener(E.target)){this._fireValueHelpRequestForValueHelpOnly();}if(this.isMobileDevice()&&this.getEditable()&&this.getEnabled()&&this.getShowSuggestion()&&this._oSuggPopover&&E.target.id!=this.getId()+"-vhi"){this._openSuggestionsPopover();}};
v.prototype.setFilterFunction=function(F){if(F===null||F===undefined){this._fnFilter=m;return this;}j(typeof(F)==="function","Input.setFilterFunction: first argument fnFilter must be a function on "+this);this._fnFilter=F;return this;};
v.prototype.setRowResultFunction=function(F){var i;if(F===null||F===undefined){this._fnRowResultFilter=e._DEFAULTRESULT_TABULAR;return this;}j(typeof(F)==="function","Input.setRowResultFunction: first argument fnFilter must be a function on "+this);this._fnRowResultFilter=F;i=this.getSelectedRow();if(i){this.setSelectedRow(i);}return this;};
v.prototype.closeSuggestions=function(){this._closeSuggestionPopup();};
v.prototype._doSelect=function(i,E){if(D.support.touch){return;}var x=this._$input[0];if(x){var R=this._$input;x.focus();R.selectText(i?i:0,E?E:R.val().length);}return this;};
v.prototype._isIncrementalType=function(){var i=this.getType();if(i==="Number"||i==="Date"||i==="Datetime"||i==="Month"||i==="Time"||i==="Week"){return true;}return false;};
v.prototype.onsapescape=function(E){var i;if(this._isSuggestionsPopoverOpen()){E.originalEvent._sapui_handledByControl=true;this._oSuggPopover._iPopupListSelectedIndex=-1;this._closeSuggestionPopup();if(this._sBeforeSuggest!==undefined){if(this._sBeforeSuggest!==this.getValue()){i=this.getLastValue();this.setValue(this._sBeforeSuggest);this.setLastValue(i);}this._sBeforeSuggest=undefined;}return;}if(this.getValueLiveUpdate()){this.setProperty("value",this.getLastValue(),true);}if(I.prototype.onsapescape){I.prototype.onsapescape.apply(this,arguments);}};
v.prototype.onsapenter=function(E){this.cancelPendingSuggest();if(this._isSuggestionsPopoverOpen()){if(!this._updateSelectionFromList()&&!this.isComposingCharacter()){this._closeSuggestionPopup();}}if(I.prototype.onsapenter){I.prototype.onsapenter.apply(this,arguments);}if(this.getEnabled()&&this.getEditable()&&!(this.getValueHelpOnly()&&this.getShowValueHelp())){this.fireSubmit({value:this.getValue()});}};
v.prototype.onsapfocusleave=function(E){var i=this._oSuggPopover,x=i&&i._oPopover,F=E.relatedControlId&&sap.ui.getCore().byId(E.relatedControlId),y=F&&F.getFocusDomRef(),H=i&&i._sProposedItemText&&this.getAutocomplete(),z=x&&y&&h(x.getDomRef(),y);if(x instanceof P){if(z&&!i.bMessageValueStateActive){this._bPopupHasFocus=true;if(D.system.desktop&&k(x.getFocusDomRef(),y)||F.isA("sap.m.GroupHeaderListItem")){this.focus();}}else{if(this.getDOMValue()===this._sSelectedSuggViaKeyboard){this._sSelectedSuggViaKeyboard=null;}}}if(!z&&!H){I.prototype.onsapfocusleave.apply(this,arguments);}this.bValueHelpRequested=false;};
v.prototype.onmousedown=function(E){if(this._isSuggestionsPopoverOpen()){E.stopPropagation();}};
v.prototype._deregisterEvents=function(){if(this._oSuggPopover){this._oSuggPopover._deregisterResize();}if(this.isMobileDevice()&&this._oSuggPopover&&this._oSuggPopover._oPopover){this.$().off("click");}};
v.prototype.updateSuggestionItems=function(){this._bSuspendInvalidate=true;this.updateAggregation("suggestionItems");this._synchronizeSuggestions();this._bSuspendInvalidate=false;return this;};
v.prototype.invalidate=function(){if(!this._bSuspendInvalidate){d.prototype.invalidate.apply(this,arguments);}};
v.prototype.cancelPendingSuggest=function(){if(this._iSuggestDelay){clearTimeout(this._iSuggestDelay);this._iSuggestDelay=null;}};
v.prototype._triggerSuggest=function(V){this.cancelPendingSuggest();this._bShouldRefreshListItems=true;if(!V){V="";}if(V.length>=this.getStartSuggestion()){this._iSuggestDelay=setTimeout(function(){if(this._sPrevSuggValue!==V){this._bBindingUpdated=false;this.fireSuggest({suggestValue:V});if(!this._bBindingUpdated){this._refreshItemsDelayed();}this._sPrevSuggValue=V;}}.bind(this),300);}else if(this.isMobileDevice()){if(this._oSuggPopover._oList instanceof T){this._oSuggPopover._oList.addStyleClass("sapMInputSuggestionTableHidden");}else if(this._oSuggPopover._oList&&this._oSuggPopover._oList.destroyItems){this._oSuggPopover._oList.destroyItems();}}else if(this._isSuggestionsPopoverOpen()){setTimeout(function(){var N=this.getDOMValue()||'';if(N<this.getStartSuggestion()){this._oSuggPopover._iPopupListSelectedIndex=-1;this._closeSuggestionPopup();}}.bind(this),0);}};
(function(){
v.prototype.setShowSuggestion=function(V){this.setProperty("showSuggestion",V,true);if(V){this._oSuggPopover=this._getSuggestionsPopover();this._oSuggPopover._iPopupListSelectedIndex=-1;if(!this._oSuggPopover._oPopover){this._createSuggestionsPopoverPopup();this._synchronizeSuggestions();this._createSuggestionPopupContent();}}else{if(this._oSuggPopover){this._oSuggPopover._destroySuggestionPopup();this._oSuggPopover._iPopupListSelectedIndex=-1;this._oButtonToolbar=null;this._oShowMoreButton=null;}}return this;};
v.prototype._shouldTriggerSuggest=function(){return!this._bPopupHasFocus&&!this.getStartSuggestion()&&!this.getValue()&&this.getShowSuggestion();};
v.prototype.setShowTableSuggestionValueHelp=function(V){this.setProperty("showTableSuggestionValueHelp",V,true);if(!(this._oSuggPopover&&this._oSuggPopover._oPopover)){return this;}if(V){this._addShowMoreButton();}else{this._removeShowMoreButton();}return this;};
v.prototype.onchange=function(E){if(this.getShowValueHelp()||this.getShowSuggestion()){return;}this.onChange(E);};
v.prototype.oninput=function(E){I.prototype.oninput.call(this,E);if(E.isMarked("invalid")){return;}var V=this.getDOMValue(),i,x,y;if(this.getValueLiveUpdate()){this.setProperty("value",V,true);this._onValueUpdated(V);}this.fireLiveChange({value:V,newValue:V});this.addStyleClass("sapMFocus");if(this.getShowSuggestion()&&!this.isMobileDevice()){i=this._getSuggestionsPopover();x=i._oList;this._triggerSuggest(V);if(x&&!i.bMessageValueStateActive){y=x.getSelectedItem();x.removeStyleClass("sapMListFocus");y&&y.removeStyleClass("sapMLIBFocused");}else if(i.bMessageValueStateActive&&document.activeElement.tagName!=="A"){i._getValueStateHeader().removeStyleClass("sapMPseudoFocus");}}};
v.prototype.getValue=function(){return this.getDomRef("inner")&&this._$input?this.getDOMValue():this.getProperty("value");};
v.prototype._refreshItemsDelayed=function(){clearTimeout(this._iRefreshListTimeout);this._iRefreshListTimeout=setTimeout(function(){if(this._oSuggPopover){this._refreshListItems();}}.bind(this),0);};
v.prototype._filterListItems=function(x,y){var i,z,A,E=[],H=[],F=this.getFilterSuggests(),J=false;for(i=0;i<x.length;i++){A=x[i];if(x[i].isA("sap.ui.core.SeparatorItem")){z=new G({id:A.getId()+"-ghli",title:x[i].getText()});E.push({header:z,visible:false});this._configureListItem(A,z);H.push(z);}else if(!F||this._fnFilter(y,A)){z=new S({title:A.getText(),info:A.getAdditionalText&&A.getAdditionalText()});if(!J&&(this._oSuggPopover._sProposedItemText===x[i].getText())){z.setSelected(true);J=true;}if(E.length){E[E.length-1].visible=true;}this._configureListItem(A,z);H.push(z);}}E.forEach(function(K){K.header.setVisible(K.visible);});return{hitItems:H,groups:E};};
v.prototype._filterTabularItems=function(x,y){var i,z,F=this.getFilterSuggests(),H=[],A=[],E=false;for(i=0;i<x.length;i++){if(x[i].isA("sap.m.GroupHeaderListItem")){A.push({header:x[i],visible:false});}else{z=!F||this._fnFilter(y,x[i]);x[i].setVisible(z);z&&H.push(x[i]);if(!E&&z&&this._oSuggPopover._sProposedItemText===this._fnRowResultFilter(x[i])){x[i].setSelected(true);E=true;}if(A.length&&z){A[A.length-1].visible=true;}}}A.forEach(function(J){J.header.setVisible(J.visible);});this._getSuggestionsTable().invalidate();return{hitItems:H,groups:A};};
v.prototype._clearSuggestionPopupItems=function(){if(!this._oSuggPopover._oList){return;}if(this._oSuggPopover._oList instanceof T){this._oSuggPopover._oList.removeSelections(true);}else{this._oSuggPopover._oList.destroyItems();}};
v.prototype._hideSuggestionPopup=function(){var i=this._oSuggPopover._oPopover;function x(){if(D.browser.internet_explorer){var F=this.getFocusInfo();this.setDOMValue(this._oSuggPopover._sTypedInValue);this.applyFocusInfo(F);}else{this.setDOMValue(this._oSuggPopover._sTypedInValue);}}if(!this.isMobileDevice()){if(this._isSuggestionsPopoverOpen()){this._sCloseTimer=setTimeout(function(){if(this._oSuggPopover){this._oSuggPopover._iPopupListSelectedIndex=-1;}this.cancelPendingSuggest();if(this._oSuggPopover._sTypedInValue){x.call(this);}this._oSuggPopover._oProposedItem=null;i.close();}.bind(this),0);}}else if(this._hasTabularSuggestions()&&this._oSuggPopover._oList){this._oSuggPopover._oList.addStyleClass("sapMInputSuggestionTableHidden");}this.$("SuggDescr").text("");this.$("inner").removeAttr("aria-activedescendant");};
v.prototype._openSuggestionPopup=function(O){if(!this.isMobileDevice()){if(this._sCloseTimer){clearTimeout(this._sCloseTimer);this._sCloseTimer=null;}if(!this._isSuggestionsPopoverOpen()&&!this._sOpenTimer&&O!==false){this._sOpenTimer=setTimeout(function(){this._sOpenTimer=null;this._oSuggPopover&&this._openSuggestionsPopover();}.bind(this),0);}}};
v.prototype._getFilteredSuggestionItems=function(i){var F,x=this.getSuggestionItems(),y=this.getSuggestionRows();if(this._hasTabularSuggestions()){if(this.isMobileDevice()&&this._oSuggPopover._oList){this._oSuggPopover._oList.removeStyleClass("sapMInputSuggestionTableHidden");}F=this._filterTabularItems(y,i);}else{F=this._filterListItems(x,i);}return F;};
v.prototype._fillSimpleSuggestionPopupItems=function(F){var i,H=F.hitItems,x=F.groups,y=H.length,z=y;if(!this._hasTabularSuggestions()){for(i=0;i<y;i++){this._oSuggPopover._oList.addItem(H[i]);}z-=x.length;}return z;};
v.prototype._applySuggestionAcc=function(N){var A="",R=this._oRb;if(N===1){A=R.getText("INPUT_SUGGESTIONS_ONE_HIT");}else if(N>1){A=R.getText("INPUT_SUGGESTIONS_MORE_HITS",N);}else{A=R.getText("INPUT_SUGGESTIONS_NO_HIT");}this.$("SuggDescr").text(A);};
v.prototype._refreshListItems=function(){var i=this.getShowSuggestion(),x=this._oSuggPopover._sTypedInValue||this.getDOMValue()||"",F,y;this._oSuggPopover._iPopupListSelectedIndex=-1;if(!i||!this._bShouldRefreshListItems||!this.getDomRef()||(!this.isMobileDevice()&&!this.$().hasClass("sapMInputFocused"))){return null;}this._clearSuggestionPopupItems();if(x.length<this.getStartSuggestion()){this._hideSuggestionPopup();return false;}F=this._getFilteredSuggestionItems(x);y=this._fillSimpleSuggestionPopupItems(F);if(y>0){this._openSuggestionPopup(this.getValue().length>=this.getStartSuggestion());}else{this._hideSuggestionPopup();}this._applySuggestionAcc(y);};
v.prototype._configureListItem=function(i,x){var y=p.Active;if(!i.getEnabled()||x.isA("sap.m.GroupHeaderListItem")){y=p.Inactive;}x.setType(y);x._oItem=i;x.addEventDelegate({ontouchstart:function(E){(E.originalEvent||E)._sapui_cancelAutoClose=true;}});return x;};
v.prototype.addSuggestionItem=function(i){this.addAggregation("suggestionItems",i,true);if(!this._oSuggPopover){this._getSuggestionsPopover();}this._synchronizeSuggestions();this._createSuggestionPopupContent();return this;};
v.prototype.insertSuggestionItem=function(i,x){this.insertAggregation("suggestionItems",x,i,true);if(!this._oSuggPopover){this._getSuggestionsPopover();}this._synchronizeSuggestions();this._createSuggestionPopupContent();return this;};
v.prototype.removeSuggestionItem=function(i){var x=this.removeAggregation("suggestionItems",i,true);this._synchronizeSuggestions();return x;};
v.prototype.removeAllSuggestionItems=function(){var i=this.removeAllAggregation("suggestionItems",true);this._synchronizeSuggestions();return i;};
v.prototype.destroySuggestionItems=function(){this.destroyAggregation("suggestionItems",true);this._synchronizeSuggestions();return this;};
v.prototype.addSuggestionRow=function(i){i.setType(p.Active);this.addAggregation("suggestionRows",i);this._synchronizeSuggestions();this._createSuggestionPopupContent(true);return this;};
v.prototype.insertSuggestionRow=function(i,x){i.setType(p.Active);this.insertAggregation("suggestionRows",i,x);this._synchronizeSuggestions();this._createSuggestionPopupContent(true);return this;};
v.prototype.removeSuggestionRow=function(i){var x=this.removeAggregation("suggestionRows",i);this._synchronizeSuggestions();return x;};
v.prototype.removeAllSuggestionRows=function(){var i=this.removeAllAggregation("suggestionRows");this._synchronizeSuggestions();return i;};
v.prototype.destroySuggestionRows=function(){this.destroyAggregation("suggestionRows");this._synchronizeSuggestions();return this;};
v.prototype.bindAggregation=function(){if(arguments[0]==="suggestionRows"||arguments[0]==="suggestionColumns"||arguments[0]==="suggestionItems"){this._createSuggestionPopupContent(arguments[0]==="suggestionRows"||arguments[0]==="suggestionColumns");this._bBindingUpdated=true;}return I.prototype.bindAggregation.apply(this,arguments);};
v.prototype._closeSuggestionPopup=function(){if(this._isSuggestionsPopoverOpen()){this.cancelPendingSuggest();this._oSuggPopover._oPopover.close();if(!this.isMobileDevice()&&this.$().hasClass("sapMInputFocused")){this.openValueStateMessage();}this.$("SuggDescr").text("");this.$("inner").removeAttr("aria-activedescendant");this._sPrevSuggValue=null;}};
v.prototype._synchronizeSuggestions=function(){if(document.activeElement===this.getFocusDomRef()){this._bShouldRefreshListItems=true;this._refreshItemsDelayed();}if(!this.getDomRef()||this._isSuggestionsPopoverOpen()){return;}this._synchronizeSelection();};
v.prototype._synchronizeSelection=function(){var i=this.getSelectedKey();if(!i){return;}if(this.getValue()&&!this.getSelectedItem()&&!this.getSelectedRow()){return;}this.setSelectedKey(i);};
})();
v.prototype.onfocusin=function(E){I.prototype.onfocusin.apply(this,arguments);this.addStyleClass("sapMInputFocused");if(!this.isMobileDevice()&&this._isSuggestionsPopoverOpen()){this.closeValueStateMessage();}if(this._shouldTriggerSuggest()){this._triggerSuggest(this.getValue());}this._bPopupHasFocus=undefined;this._sPrevSuggValue=null;};
v.prototype.oncompositionend=function(E){I.prototype.oncompositionend.apply(this,arguments);if(this._oSuggPopover&&!D.browser.edge&&!D.browser.firefox){this._oSuggPopover._handleTypeAhead();}};
v.prototype.onsapshow=function(E){if(!this.getEnabled()||!this.getEditable()||!this.getShowValueHelp()){return;}this.bValueHelpRequested=true;this._fireValueHelpRequest(false);E.preventDefault();E.stopPropagation();};
v.prototype.onsaphide=v.prototype.onsapshow;
v.prototype.onsapselect=function(E){this._fireValueHelpRequestForValueHelpOnly();};
v.prototype.onfocusout=function(E){I.prototype.onfocusout.apply(this,arguments);this.removeStyleClass("sapMInputFocused");this.$("SuggDescr").text("");};
v.prototype._hasTabularSuggestions=function(){return!!(this.getAggregation("suggestionColumns")&&this.getAggregation("suggestionColumns").length);};
v.prototype._getSuggestionsTable=function(){if(this._bIsBeingDestroyed){return this._oSuggestionTable;}if(!this._oSuggestionTable){this._oSuggestionTable=new T(this.getId()+"-popup-table",{mode:t.SingleSelectMaster,showNoData:false,showSeparators:u.None,width:"100%",enableBusyIndicator:false,rememberSelections:false,itemPress:function(E){if(D.system.desktop){this.focus();}this._oSuggPopover._bSuggestionItemTapped=true;var i=E.getParameter("listItem");this.setSelectionRow(i,true);}.bind(this),sticky:[l.Sticky.ColumnHeaders]});this._oSuggestionTable.addEventDelegate({onAfterRendering:function(){var i,x;if(!this.getEnableSuggestionsHighlighting()){return;}i=this._oSuggestionTable.$().find('tbody .sapMLabel');x=(this._sTypedInValue||this.getValue()).toLowerCase();n(i,x);}.bind(this)});if(this.isMobileDevice()){this._oSuggestionTable.addStyleClass("sapMInputSuggestionTableHidden");}this._oSuggestionTable.updateItems=function(){T.prototype.updateItems.apply(this,arguments);this._refreshItemsDelayed();return this;};}return this._oSuggestionTable;};
v.prototype.clone=function(){var i=d.prototype.clone.apply(this,arguments);i.setRowResultFunction(this._fnRowResultFilter);i.setValue(this.getValue());return i;};
v.prototype.setValue=function(V){this._iSetCount++;I.prototype.setValue.call(this,V);this._onValueUpdated(V);return this;};
v.prototype.setDOMValue=function(i){this._$input.val(i);};
v.prototype.getDOMValue=function(){return this._$input.val();};
v.prototype.updateInputField=function(N){if(this._isSuggestionsPopoverOpen()&&this.isMobileDevice()){this._oSuggPopover._oPopupInput.setValue(N);this._oSuggPopover._oPopupInput._doSelect();}else{N=this._getInputValue(N);this.setDOMValue(N);this.onChange(null,null,N);}};
v.prototype.getAccessibilityInfo=function(){var i=I.prototype.getAccessibilityInfo.apply(this,arguments);i.description=((i.description||"")+" "+this.getDescription()).trim();return i;};
v.prototype.preventChangeOnFocusLeave=function(E){return this.bFocusoutDueRendering||this.bValueHelpRequested;};
v.prototype._getShowMoreButton=function(){return this._oShowMoreButton||(this._oShowMoreButton=new B({text:this._oRb.getText("INPUT_SUGGESTIONS_SHOW_ALL"),press:this._getShowMoreButtonPress.bind(this)}));};
v.prototype._getShowMoreButtonPress=function(){var i;if(this.getShowTableSuggestionValueHelp()){if(this._oSuggPopover._sTypedInValue){i=this._oSuggPopover._sTypedInValue;this.updateDomValue(i);this._oSuggPopover._resetTypeAhead();this._oSuggPopover._sTypedInValue=i;}this._fireValueHelpRequest(true);this._oSuggPopover._iPopupListSelectedIndex=-1;this._closeSuggestionPopup();}};
v.prototype._addShowMoreButton=function(i){var x=this._oSuggPopover&&this._oSuggPopover._oPopover;if(!x||!i&&!this._hasTabularSuggestions()){return;}if(x.isA("sap.m.Dialog")){var y=this._getShowMoreButton();x.setEndButton(y);}else{var z=this._getButtonToolbar();x.setFooter(z);}};
v.prototype._removeShowMoreButton=function(){var i=this._oSuggPopover&&this._oSuggPopover._oPopover;if(!i||!this._hasTabularSuggestions()){return;}if(i.isA("sap.m.Dialog")){i.setEndButton(null);}else{i.setFooter(null);}};
v.prototype._getButtonToolbar=function(){var i=this._getShowMoreButton();return this._oButtonToolbar||(this._oButtonToolbar=new f({content:[new g(),i]}));};
v.prototype._hasShowSelectedButton=function(){return false;};
v.prototype._createSuggestionPopupContent=function(i){if(this._bIsBeingDestroyed||this._getSuggestionsPopover()._oList){return;}this._oSuggPopover._createSuggestionPopupContent(i);if(!this._hasTabularSuggestions()&&!i){this._oSuggPopover._oList.attachItemPress(function(E){if(D.system.desktop){this.focus();}var x=E.getParameter("listItem");if(!x.isA("sap.m.GroupHeaderListItem")){this._oSuggPopover._bSuggestionItemTapped=true;this.setSelectionItem(x._oItem,true);}},this);}else{if(this._fnFilter===m){this._fnFilter=v._DEFAULTFILTER_TABULAR;}if(!this._fnRowResultFilter){this._fnRowResultFilter=v._DEFAULTRESULT_TABULAR;}if(this.getShowTableSuggestionValueHelp()){this._addShowMoreButton(i);}}};
v.prototype._createPopupInput=function(){var i=new v(this.getId()+"-popup-input",{width:"100%",valueLiveUpdate:true,showValueStateMessage:false,valueState:this.getValueState(),showValueHelp:this.getShowValueHelp(),valueHelpRequest:function(E){this.fireValueHelpRequest({fromSuggestions:true});this._oSuggPopover._iPopupListSelectedIndex=-1;this._closeSuggestionPopup();}.bind(this),liveChange:function(E){var V=E.getParameter("newValue");this.setDOMValue(this._getInputValue(this._oSuggPopover._oPopupInput.getValue()));this._triggerSuggest(V);this.fireLiveChange({value:V,newValue:V});}.bind(this)});return i;};
v.prototype._modifyPopupInput=function(i){i.addEventDelegate({onsapenter:function(){if(this.getAutocomplete()){this._oSuggPopover._finalizeAutocomplete();}this._closeSuggestionPopup();}},this);return i;};
v.prototype.forwardEventHandlersToSuggPopover=function(i){i.setOkPressHandler(this._closeSuggestionPopup.bind(this));i.setCancelPressHandler(this._closeSuggestionPopup.bind(this));};
v.prototype._getSuggestionsPopover=function(){if(!this._oSuggPopover){var i=this._oSuggPopover=new e(this);if(this.isMobileDevice()){var x=this._createPopupInput();i._oPopupInput=this._modifyPopupInput(x);}this._oSuggPopover.setInputLabels(this.getLabels.bind(this));this._createSuggestionsPopoverPopup();this.forwardEventHandlersToSuggPopover(i);i._bAutocompleteEnabled=this.getAutocomplete();i.attachEvent(e.M_EVENTS.SELECTION_CHANGE,function(E){var N=E.getParameter("newValue");this.setDOMValue(N);this._sSelectedSuggViaKeyboard=N;this._doSelect();},this);if(this.getShowTableSuggestionValueHelp()){this._addShowMoreButton();}}return this._oSuggPopover;};
v.prototype._createSuggestionsPopoverPopup=function(){if(!this._oSuggPopover){return;}var i=this._oSuggPopover;var x;i._createSuggestionPopup({showSelectedButton:this._hasShowSelectedButton()});x=i._oPopover;x.attachBeforeOpen(function(){this._updateSuggestionsPopoverValueState();},this);x.attachBeforeClose(function(){this._updateSuggestionsPopoverValueState();},this);if(this.isMobileDevice()){x.attachBeforeClose(function(){this.setDOMValue(this._getInputValue(i._oPopupInput.getValue()));this.onChange();},this).attachAfterClose(function(){var y=i._oList;if(!y){return;}if(T&&!(y instanceof T)){y.destroyItems();}else{y.removeSelections(true);}}).attachAfterOpen(function(){this._triggerSuggest(this.getValue());this._refreshListItems();},this).attachBeforeOpen(function(){i._oPopupInput.setPlaceholder(this.getPlaceholder());i._oPopupInput.setMaxLength(this.getMaxLength());i._oPopupInput.setValue(this.getValue());},this);}else{x.attachAfterClose(function(){this._updateSelectionFromList();var y=i._oList,z=y.getSelectedItem();if(!y){return;}if(y instanceof T){z&&z.removeStyleClass("sapMLIBFocused");y.removeSelections(true);}else{y.destroyItems();}i._deregisterResize();},this).attachBeforeOpen(function(){i._sPopoverContentWidth=this.getMaxSuggestionWidth();i._bEnableHighlighting=this.getEnableSuggestionsHighlighting();i._bAutocompleteEnabled=this.getAutocomplete();i._bIsInputIncrementalType=this._isIncrementalType();this._sBeforeSuggest=this.getValue();i._resizePopup();i._registerResize();},this);}this.setAggregation("_suggestionPopup",x);this._oSuggestionPopup=x;};
v.prototype.showItems=function(F){var i,x,y=this._fnFilter;if(!this.getEnabled()||!this.getEditable()){return;}this.setFilterFunction(F||function(){return true;});this._clearSuggestionPopupItems();i=this._getFilteredSuggestionItems(this.getDOMValue());x=this._fillSimpleSuggestionPopupItems(i);if(x>0){this._openSuggestionPopup();}else{this._hideSuggestionPopup();}this._applySuggestionAcc(x);this.setFilterFunction(y);};
v.prototype.shouldValueStateMessageBeOpened=function(){var i=I.prototype.shouldValueStateMessageBeOpened.apply(this,arguments);if(!i||this._isSuggestionsPopoverOpen()){return false;}return true;};
v.prototype._isSuggestionsPopoverOpen=function(){return this._oSuggPopover&&this._oSuggPopover.isOpen();};
v.prototype.isMobileDevice=function(){return D.system.phone;};
v.prototype._openSuggestionsPopover=function(){this.closeValueStateMessage();this._updateSuggestionsPopoverValueState();this._oSuggPopover._oPopover.open();};
v.prototype._updateSuggestionsPopoverValueState=function(){var i=this._oSuggPopover,V=this.getValueState(),N=this.getValueState()!==i._getValueStateHeader().getValueState(),x=this.getFormattedValueStateText(),y=this.getValueStateText();if(!i){return;}if(this._isSuggestionsPopoverOpen()&&!x&&!N){this.setFormattedValueStateText(this._oSuggPopover._getValueStateHeader().getFormattedText());}i.updateValueState(V,(x||y),this.getShowValueStateMessage());if(this.isMobileDevice()){i._oPopupInput.setValueState(V);}};
v.prototype.setShowValueHelp=function(i){this.setProperty("showValueHelp",i);if(this._oSuggPopover&&this._oSuggPopover._oPopupInput){this._oSuggPopover._oPopupInput.setShowValueHelp(i);}return this;};
v.prototype.isValueHelpOnlyOpener=function(i){return true;};
return v;});
sap.ui.predefine('sap/m/InputBase',['./library','sap/ui/core/Control','sap/ui/core/EnabledPropagator','sap/ui/core/IconPool','./delegate/ValueStateMessage','sap/ui/core/message/MessageMixin','sap/ui/core/library','sap/ui/Device','./InputBaseRenderer','sap/base/Log',"sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/cursorPos","sap/ui/dom/jquery/getSelectedText","sap/ui/dom/jquery/selectText"],function(l,C,E,I,V,M,c,D,a,b,K,q){"use strict";var T=c.TextDirection;var d=c.TextAlign;var f=c.ValueState;
var g=C.extend("sap.m.InputBase",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.m",properties:{value:{type:"string",group:"Data",defaultValue:null,bindable:"bindable"},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true},valueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:f.None},name:{type:"string",group:"Misc",defaultValue:null},placeholder:{type:"string",group:"Misc",defaultValue:null},editable:{type:"boolean",group:"Behavior",defaultValue:true},valueStateText:{type:"string",group:"Misc",defaultValue:null},showValueStateMessage:{type:"boolean",group:"Misc",defaultValue:true},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:d.Initial},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit},required:{type:"boolean",group:"Misc",defaultValue:false}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{change:{parameters:{value:{type:"string"}}}},aggregations:{formattedValueStateText:{type:"sap.m.FormattedText",multiple:false,defaultValue:null},_invisibleFormattedValueStateText:{type:"sap.m.FormattedText",multiple:false,visibility:"hidden",defaultValue:null},_endIcon:{type:"sap.ui.core.Icon",multiple:true,visibility:"hidden"},_beginIcon:{type:"sap.ui.core.Icon",multiple:true,visibility:"hidden"}},designtime:"sap/m/designtime/InputBase.designtime"}});
E.call(g.prototype);I.insertFontFaceStyle();M.call(g.prototype);g.ICON_PRESSED_CSS_CLASS="sapMInputBaseIconPressed";g.ICON_CSS_CLASS="sapMInputBaseIcon";g.prototype.bShowLabelAsPlaceholder=!D.support.input.placeholder;
g.prototype.handleInput=function(e){if(this._bIgnoreNextInput||this._bIgnoreNextInputNonASCII){this._bIgnoreNextInput=false;this._bIgnoreNextInputNonASCII=false;e.setMarked("invalid");return;}this._bIgnoreNextInput=false;this._bIgnoreNextInputNonASCII=false;if(!this.getEditable()){e.setMarked("invalid");return;}if(document.activeElement!==e.target&&D.browser.msie&&this.getValue()===this.getLastValue()){e.setMarked("invalid");return;}this._bCheckDomValue=true;};
g.prototype._getPlaceholder=function(){return this.getPlaceholder()||"";};
g.prototype._getInputValue=function(v){v=(v===undefined)?this.$("inner").val()||"":v.toString();if(this.getMaxLength&&this.getMaxLength()>0){v=v.substring(0,this.getMaxLength());}return v;};
g.prototype._getInputElementTagName=function(){if(!this._sInputTagElementName){this._sInputTagElementName=this._$input&&this._$input.get(0)&&this._$input.get(0).tagName;}return this._sInputTagElementName;};
g.prototype.init=function(){this.setLastValue("");this.bRenderingPhase=false;this._oValueStateMessage=new V(this);this._bIsComposingCharacter=false;this.fnCloseValueStateOnClick=function(){this.closeValueStateMessage();};};
g.prototype.oncompositionstart=function(){this._bIsComposingCharacter=true;};
g.prototype.oncompositionend=function(e){this._bIsComposingCharacter=false;if(!D.browser.edge&&!D.browser.firefox){this.handleInput(e);}};
g.prototype.isComposingCharacter=function(){return this._bIsComposingCharacter;};
g.prototype.onBeforeRendering=function(){var F=this.getFormattedValueStateText();var o=F&&F.getHtmlText();var e=this.getAggregation("_invisibleFormattedValueStateText");var h=e&&e.getHtmlText();if(D.browser.msie&&D.browser.version>9&&!/^[\x00-\x7F]*$/.test(this.getValue())){this._bIgnoreNextInputNonASCII=true;this._oDomRefBeforeRendering=this.getDomRef();}if(this._bCheckDomValue&&!this.bRenderingPhase){this._sDomValue=this._getInputValue();}if(F&&o!==h){e&&e.destroy();this.setAggregation("_invisibleFormattedValueStateText",F.clone());}this.bRenderingPhase=true;};
g.prototype.onAfterRendering=function(){var v=this.getValueState();var i=this.getFocusDomRef()===document.activeElement;var e=v===f.None;if(this._bCheckDomValue&&this._sDomValue!==this._getInputValue()){this.$("inner").val(this._sDomValue);}this.$("message").text(this.getValueStateText());this._bIgnoreNextInputNonASCII=this._bIgnoreNextInputNonASCII&&this._oDomRefBeforeRendering!==this.getDomRef();this._bCheckDomValue=false;this.bRenderingPhase=false;if(i){this[e?"closeValueStateMessage":"openValueStateMessage"]();}if(this.getAggregation("_invisibleFormattedValueStateText")){this.getAggregation("_invisibleFormattedValueStateText").getControls().forEach(function(o){o.getDomRef()&&o.getDomRef().setAttribute("tabindex",-1);});}};
g.prototype.exit=function(){if(this._oValueStateMessage){this._oValueStateMessage.destroy();}this._oValueStateMessage=null;this._oDomRefBeforeRendering=null;};
g.prototype.ontouchstart=function(e){e.setMarked();};
g.prototype.onfocusin=function(e){this._bIgnoreNextInput=!this.bShowLabelAsPlaceholder&&D.browser.msie&&D.browser.version>9&&!!this.getPlaceholder()&&!this._getInputValue()&&this._getInputElementTagName()==="INPUT";this.addStyleClass("sapMFocus");this.openValueStateMessage();};
g.prototype.onfocusout=function(e){this.removeStyleClass("sapMFocus");if(!this._bClickOnValueStateLink(e)){this.closeValueStateMessage();}};
g.prototype.onsapfocusleave=function(e){if(!this.preventChangeOnFocusLeave(e)){this.onChange(e);}};
g.prototype.preventChangeOnFocusLeave=function(e){return this.bFocusoutDueRendering;};
g.prototype.getChangeEventParams=function(){return{};};
g.prototype.ontap=function(e){return;};
g.prototype.onChange=function(e,p,n){p=p||this.getChangeEventParams();if(!this.getEditable()||!this.getEnabled()){return;}var v=this._getInputValue(n);if(v!==this.getLastValue()){this.setValue(v);v=this.getValue();this.setLastValue(v);this.fireChangeEvent(v,p);return true;}else{this._bCheckDomValue=false;}};
g.prototype.fireChangeEvent=function(v,p){var o=q.extend({value:v,newValue:v},p);this.fireChange(o);};
g.prototype.onValueRevertedByEscape=function(v,p){this.fireEvent("liveChange",{value:v,escPressed:true,previousValue:p,newValue:v});};
g.prototype.onsapenter=function(e){if((D.browser.safari||D.browser.msie)&&this.isComposingCharacter()){e.setMarked("invalid");return;}this.onChange(e);};
g.prototype.onsapescape=function(e){var v=this._getInputValue();if(v!==this.getLastValue()){e.setMarked();e.preventDefault();this.updateDomValue(this.getLastValue());this.onValueRevertedByEscape(this.getLastValue(),v);}};
g.prototype.oninput=function(e){this.handleInput(e);};
g.prototype.onkeydown=function(e){if(this.getDomRef("inner").getAttribute("readonly")&&e.keyCode==K.BACKSPACE){e.preventDefault();}};
g.prototype.oncut=function(e){};
g.prototype.selectText=function(s,S){this.$("inner").selectText(s,S);return this;};
g.prototype.getSelectedText=function(){return this.$("inner").getSelectedText();};
g.prototype.setProperty=function(p,v,s){if(p=="value"){this._bCheckDomValue=false;}return C.prototype.setProperty.apply(this,arguments);};
g.prototype.getFocusInfo=function(){var F=C.prototype.getFocusInfo.call(this),o=this.getFocusDomRef();q.extend(F,{cursorPos:0,selectionStart:0,selectionEnd:0});if(o){F.cursorPos=q(o).cursorPos();try{F.selectionStart=o.selectionStart;F.selectionEnd=o.selectionEnd;}catch(e){}}return F;};
g.prototype.applyFocusInfo=function(F){C.prototype.applyFocusInfo.call(this,F);this.$("inner").cursorPos(F.cursorPos);this.selectText(F.selectionStart,F.selectionEnd);return this;};
g.prototype.updateDomValue=function(v){var i=this.getFocusDomRef();if(!this.isActive()){return this;}v=this._getInputValue(v);if(this._getInputValue()===v){return this;}this._bCheckDomValue=true;if(this._bPreferUserInteraction){this.handleInputValueConcurrency(v);}else{i.value=v;}return this;};
g.prototype._aValueStateLinks=function(){if(this.getFormattedValueStateText()&&this.getFormattedValueStateText().getHtmlText()&&this.getFormattedValueStateText().getControls().length){return this.getFormattedValueStateText().getControls();}else{return[];}};
g.prototype._bClickOnValueStateLink=function(e){var v=this._aValueStateLinks();return v.some(function(L){return e.relatedTarget===L.getDomRef();});};
g.prototype._attachValueStateLinkPress=function(){this._aValueStateLinks().forEach(function(L){L.attachPress(this.fnCloseValueStateOnClick,this);},this);};
g.prototype._detachValueStateLinkPress=function(){this._aValueStateLinks().forEach(function(L){L.detachPress(this.fnCloseValueStateOnClick,this);},this);};
g.prototype.handleInputValueConcurrency=function(v){var i=this.getFocusDomRef(),s=i&&this._getInputValue(),e=this.getProperty("value"),h=document.activeElement===i,B=this.isBound("value")&&this.getBindingInfo("value").skipModelUpdate;if(h&&B&&s&&(e!==s)){return this;}i.value=v;if(h&&B&&!s){i.select();}};
g.prototype._setPreferUserInteraction=function(p){this._bPreferUserInteraction=p;};
g.prototype.closeValueStateMessage=function(){setTimeout(function(){if(this._oValueStateMessage){this._detachValueStateLinkPress();this._oValueStateMessage.close();}}.bind(this),0);};
g.prototype.getDomRefForValueStateMessage=function(){return this.getDomRef("content");};
g.prototype.getPopupAnchorDomRef=function(){return this.getDomRef();};
g.prototype.iOpenMessagePopupDuration=0;
g.prototype.getValueStateMessageId=function(){return this.getId()+"-message";};
g.prototype.getLabels=function(){var L=this.getAriaLabelledBy().map(function(s){return sap.ui.getCore().byId(s);});var o=sap.ui.require("sap/ui/core/LabelEnablement");if(o){L=L.concat(o.getReferencingLabels(this).map(function(s){return sap.ui.getCore().byId(s);}));}return L;};
g.prototype.openValueStateMessage=function(){if(this._oValueStateMessage&&this.shouldValueStateMessageBeOpened()){setTimeout(function(){if(!this.bIsDestroyed){this._detachValueStateLinkPress();this._attachValueStateLinkPress();this._oValueStateMessage.open();}}.bind(this),0);}};
g.prototype.shouldValueStateMessageBeOpened=function(){return(this.getValueState()!==f.None)&&this.getEditable()&&this.getEnabled()&&this.getShowValueStateMessage();};
g.prototype._calculateIconsSpace=function(){var e=this.getAggregation("_endIcon")||[],B=this.getAggregation("_beginIcon")||[],i=e.concat(B),h;return i.reduce(function(A,o){h=o&&o.getDomRef()?o.getDomRef().offsetWidth:0;return A+h;},0);};
g.prototype.setValue=function(v){v=this.validateProperty("value",v);v=this._getInputValue(v);this.updateDomValue(v);if(v!==this.getProperty("value")){this.setLastValue(v);}this.setProperty("value",v,true);return this;};
g.prototype.getFocusDomRef=function(){return this.getDomRef("inner");};
g.prototype.getIdForLabel=function(){return this.getId()+"-inner";};
g.prototype.getAccessibilityInfo=function(){var r=this.getRequired()?'Required':'',R=this.getRenderer();return{role:R.getAriaRole(this),type:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_INPUT"),description:[this.getValue()||"",R.getLabelledByAnnouncement(this),R.getDescribedByAnnouncement(this),r].join(" ").trim(),focusable:this.getEnabled(),enabled:this.getEnabled(),editable:this.getEnabled()&&this.getEditable()};};
g.prototype._addIcon=function(i,o){if(["begin","end"].indexOf(i)===-1){b.error('icon position is not "begin", neither "end", please check again the passed setting');return null;}var e=I.createControlByURI(o).addStyleClass(g.ICON_CSS_CLASS);this.addAggregation("_"+i+"Icon",e);return e;};
g.prototype.addBeginIcon=function(i){return this._addIcon("begin",i);};
g.prototype.addEndIcon=function(i){return this._addIcon("end",i);};
Object.defineProperty(g.prototype,"_$input",{get:function(){return this.$("inner");}});
g.prototype.setLastValue=function(v){this._lastValue=v;return this;};
g.prototype.getLastValue=function(){return this._lastValue;};
return g;});
sap.ui.predefine('sap/m/InputBaseRenderer',['sap/ui/core/Renderer','sap/ui/core/Core','sap/ui/core/library','sap/ui/core/ValueStateSupport','sap/ui/core/LabelEnablement','sap/ui/Device'],function(R,C,c,V,L,D){"use strict";var T=c.TextDirection;var a=c.ValueState;var I={apiVersion:2};
I.render=function(r,o){var v=o.getValueState(),t=o.getTextDirection(),s=R.getTextAlign(o.getTextAlign(),t),A=sap.ui.getCore().getConfiguration().getAccessibility(),b=o.getAggregation("_beginIcon")||[],e=o.getAggregation("_endIcon")||[],d,f;r.openStart("div",o);this.addOuterStyles(r,o);this.addControlWidth(r,o);r.class("sapMInputBase");this.addPaddingClass(r,o);this.addCursorClass(r,o);this.addOuterClasses(r,o);if(!o.getEnabled()){r.class("sapMInputBaseDisabled");}if(!o.getEditable()){r.class("sapMInputBaseReadonly");}if(v!==a.None&&o.getEditable()&&o.getEnabled()){r.class("sapMInputBaseState");}if(b.length){d=b.filter(function(i){return i.getVisible();});d.length&&r.class("sapMInputBaseHasBeginIcons");}if(e.length){f=e.filter(function(i){return i.getVisible();});f.length&&r.class("sapMInputBaseHasEndIcons");}this.writeOuterAttributes(r,o);var g=o.getTooltip_AsString();if(g){r.attr("title",g);}r.openEnd();r.openStart("div",o.getId()+"-content");r.class("sapMInputBaseContentWrapper");if(!o.getEnabled()){r.class("sapMInputBaseDisabledWrapper");}else if(!o.getEditable()){r.class("sapMInputBaseReadonlyWrapper");}if(v!==a.None&&o.getEditable()&&o.getEnabled()){this.addValueStateClasses(r,o);}this.addWrapperStyles(r,o);r.openEnd();if(b.length){this.writeIcons(r,b);}this.prependInnerContent(r,o);this.openInputTag(r,o);if(o.getName()){r.attr("name",o.getName());}if(!o.bShowLabelAsPlaceholder&&o._getPlaceholder()){r.attr("placeholder",o._getPlaceholder());}if(o.getMaxLength&&o.getMaxLength()>0){r.attr("maxlength",o.getMaxLength());}if(!o.getEnabled()){r.attr("disabled","disabled");}else if(!o.getEditable()){r.attr("readonly","readonly");}if(t!=T.Inherit){r.attr("dir",t.toLowerCase());}this.writeInnerValue(r,o);if(A){this.writeAccessibilityState(r,o);}if(D.browser.mozilla){if(g){r.attr("x-moz-errormessage",g);}else{r.attr("x-moz-errormessage"," ");}}this.writeInnerAttributes(r,o);r.class("sapMInputBaseInner");this.addInnerClasses(r,o);r.style("text-align",s);this.addInnerStyles(r,o);this.endInputTag(r,o);this.writeInnerContent(r,o);this.closeInputTag(r,o);if(e.length){this.writeIcons(r,e);}r.close("div");this.writeDecorations(r,o);if(A){this.renderAriaLabelledBy(r,o);this.renderAriaDescribedBy(r,o);this.renderValueStateAccDom(r,o);}r.close("div");};
I.getAriaRole=function(o){return"textbox";};
I.getAriaLabelledBy=function(o){if(this.getLabelledByAnnouncement(o)){return o.getId()+"-labelledby";}};
I.getLabelledByAnnouncement=function(o){return"";};
I.renderAriaLabelledBy=function(r,o){var A=this.getLabelledByAnnouncement(o);if(A){r.openStart("span",o.getId()+"-labelledby").attr("aria-hidden","true").class("sapUiInvisibleText").openEnd().text(A.trim()).close("span");}};
I.getAriaDescribedBy=function(o){if(this.getDescribedByAnnouncement(o)){return o.getId()+"-describedby";}};
I.getDescribedByAnnouncement=function(o){return"";};
I.renderAriaDescribedBy=function(r,o){var A=this.getDescribedByAnnouncement(o);if(A){r.openStart("span",o.getId()+"-describedby").attr("aria-hidden","true").class("sapUiInvisibleText").openEnd().text(A.trim()).close("span");}};
I.renderValueStateAccDom=function(r,o){var v=o.getValueState();if(v===a.None||!o.getEditable()||!o.getEnabled()){return;}var s=document.activeElement!==o.getFocusDomRef()||v===a.Error;var A=o.getValueStateMessageId()+"-sr";var f=o.getAggregation("_invisibleFormattedValueStateText");var b=C.getLibraryResourceBundle("sap.m").getText("INPUTBASE_VALUE_STATE_"+v.toUpperCase());r.openStart("div",A).class("sapUiPseudoInvisibleText");if(s){r.attr("aria-live","assertive");}r.attr("aria-atomic","true").openEnd().text(b).text(" ");if(f){r.renderControl(f);}else{r.text(o.getValueStateText()||V.getAdditionalText(o));}r.close("div");};
I.getAccessibilityState=function(o){var A=this.getAriaLabelledBy(o),s=this.getAriaDescribedBy(o),r=this.getAriaRole(o),v=o.getValueStateMessageId()+"-sr",m={};if(r){m.role=r;}if(o.getValueState()===a.Error&&o.getEditable()&&o.getEnabled()){m.invalid=true;m.errormessage=v;}else if(o.getValueState()!==a.None&&o.getEditable()&&o.getEnabled()){s=s?v+" "+s:v;}if(A){m.labelledby={value:A.trim(),append:true};}if(s){m.describedby={value:s.trim(),append:true};}m.disabled=null;m.readonly=null;return m;};
I.writeAccessibilityState=function(r,o){r.accessibilityState(o,this.getAccessibilityState(o));};
I.openInputTag=function(r,o){r.voidStart("input",o.getId()+"-"+this.getInnerSuffix());};
I.endInputTag=function(r,o){r.voidEnd();};
I.writeInnerValue=function(r,o){r.attr("value",o.getValue());};
I.addCursorClass=function(r,o){};
I.addPaddingClass=function(r,o){r.class("sapMInputBaseHeightMargin");};
I.addOuterStyles=function(r,o){};
I.addControlWidth=function(r,o){if(!o.getProperty('width')){r.class("sapMInputBaseNoWidth");}r.style("width",o.getWidth());};
I.addOuterClasses=function(r,o){};
I.writeOuterAttributes=function(r,o){};
I.addInnerStyles=function(r,o){};
I.addWrapperStyles=function(r,o){r.style("width","100%");};
I.addInnerClasses=function(r,o){};
I.writeInnerAttributes=function(r,o){};
I.prependInnerContent=function(r,o){};
I.writeInnerContent=function(r,o){};
I.writeIcons=function(r,i){r.openStart("div").attr("tabindex","-1").class("sapMInputBaseIconContainer").openEnd();i.forEach(r.renderControl,r);r.close("div");};
I.writeDecorations=function(r,o){};
I.closeInputTag=function(r,o){};
I.addPlaceholderStyles=function(r,o){};
I.addPlaceholderClasses=function(r,o){};
I.addValueStateClasses=function(r,o){r.class("sapMInputBaseContentWrapperState");r.class("sapMInputBaseContentWrapper"+o.getValueState());};
I.getInnerSuffix=function(){return"inner";};
return I;},true);
sap.ui.predefine('sap/m/InputRenderer',['sap/ui/core/InvisibleText','sap/ui/core/Renderer','./InputBaseRenderer','sap/m/library'],function(I,R,a,l){"use strict";var b=l.InputType;var c=R.extend(a);c.apiVersion=2;
c.addOuterClasses=function(r,C){r.class("sapMInput");if(C.getDescription()){r.class("sapMInputWithDescription");}};
c.writeInnerAttributes=function(r,C){var s=C.getShowSuggestion();r.attr("type",C.getType().toLowerCase());if(C.getType()==b.Number){r.attr("step","any");}if(C.getType()==b.Number&&sap.ui.getCore().getConfiguration().getRTL()){r.attr("dir","ltr").style("text-align","right");}if(s){r.attr("aria-haspopup","listbox");}if(s||C.getShowValueStateMessage()){r.attr("autocomplete","off");}if((!C.getEnabled()&&C.getType()=="Password")||(C.getShowSuggestion()&&C.isMobileDevice())||(C.getValueHelpOnly()&&C.getEnabled()&&C.getEditable()&&C.getShowValueHelp())){r.attr("readonly","readonly");}};
c.addInnerClasses=function(r,C){};
c.writeDescription=function(r,C){r.openStart("div").class("sapMInputDescriptionWrapper").style("width","calc(100% - "+C.getFieldWidth()+")").openEnd();r.openStart("span",C.getId()+"-descr").class("sapMInputDescriptionText").openEnd().text(C.getDescription()).close("span");r.close("div");};
c.writeDecorations=function(r,C){if(C.getDescription()){this.writeDescription(r,C);}if(sap.ui.getCore().getConfiguration().getAccessibility()){if(C.getShowSuggestion()&&C.getEnabled()&&C.getEditable()){r.openStart("span",C.getId()+"-SuggDescr").class("sapUiPseudoInvisibleText").attr("role","status").attr("aria-live","polite").openEnd().close("span");}}};
c.addWrapperStyles=function(r,C){r.style("width",C.getDescription()?C.getFieldWidth():"100%");};
c.getAriaLabelledBy=function(C){var d=a.getAriaLabelledBy.call(this,C)||"";if(C.getDescription()){d=d+" "+C.getId()+"-descr";}return d;};
c.getAriaDescribedBy=function(C){var A=a.getAriaDescribedBy.apply(this,arguments);function d(s){A=A?A+" "+s:s;}if(C.getShowValueHelp()&&C.getEnabled()&&C.getEditable()){d(I.getStaticId("sap.m","INPUT_VALUEHELP"));if(C.getValueHelpOnly()){d(I.getStaticId("sap.m","INPUT_DISABLED"));}}return A;};
c.getAriaRole=function(C){return"";};
c.getAccessibilityState=function(C){var A=a.getAccessibilityState.apply(this,arguments);return A;};
return c;},true);
sap.ui.predefine('sap/m/MenuItem',['./library','sap/ui/core/Item','sap/ui/base/ManagedObjectObserver'],function(l,I,M){"use strict";
var a=I.extend("sap.m.MenuItem",{metadata:{library:"sap.m",properties:{icon:{type:"string",group:"Appearance",defaultValue:null},visible:{type:"boolean",group:"Appearance",defaultValue:true},startsSection:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.MenuItem",multiple:true,singularName:"item",bindable:"bindable"}},events:{press:{},propertyChanged:{parameters:{propertyKey:{type:"string"},propertyValue:{type:"any"}}},aggregationChanged:{parameters:{aggregationName:{type:"String"},methodName:{type:"String"},methodParams:{type:"Object"}}}}}});
a.UNIFIED_MENU_ITEMS_ID_SUFFIX='-unifiedmenu';
a.prototype.exit=function(){if(this._sVisualChild){this._sVisualChild=null;}if(this._sVisualParent){this._sVisualParent=null;}if(this._sVisualControl){this._sVisualControl=null;}};
a.prototype.setProperty=function(p,P){I.prototype.setProperty.apply(this,arguments);this.fireEvent("propertyChanged",{propertyKey:p,propertyValue:P});};
a.prototype.setAggregation=function(A,o,s){I.prototype.setAggregation.apply(this,arguments);this.fireEvent("aggregationChanged",{aggregationName:A,methodName:"set",methodParams:{item:o}});return this;};
a.prototype.addAggregation=function(A,o,s){var v=this._getVisualControl(),V;I.prototype.addAggregation.apply(this,arguments);if(A==='customData'&&v){V=sap.ui.getCore().byId(v);this._addCustomData(V,o);}this.fireEvent("aggregationChanged",{aggregationName:A,methodName:"add",methodParams:{item:o}});return this;};
a.prototype.insertAggregation=function(A,o,i,s){var v=this._getVisualControl(),V;I.prototype.insertAggregation.apply(this,arguments);if(A==='customData'&&v){V=sap.ui.getCore().byId(v);V.insertCustomData(o.clone(a.UNIFIED_MENU_ITEMS_ID_SUFFIX),i);this._observeCustomDataChanges(o);}this.fireEvent("aggregationChanged",{aggregationName:A,methodName:"insert",methodParams:{item:o,index:i}});return this;};
a.prototype.removeAggregation=function(A,o,s){var O=I.prototype.removeAggregation.apply(this,arguments);if(A==="customData"){if(this.getCustomData().length===1){this._disconnectAndDestroyCustomDataObserver();}else if(o&&this._oCustomDataObserver){this._oCustomDataObserver.unobserve(o,{properties:["value"]});}}this.fireEvent("aggregationChanged",{aggregationName:A,methodName:"remove",methodParams:{item:O}});return O;};
a.prototype.removeAllAggregation=function(A,s){var o=I.prototype.removeAllAggregation.apply(this,arguments);if(A==='customData'){this._disconnectAndDestroyCustomDataObserver();}this.fireEvent("aggregationChanged",{aggregationName:A,methodName:"removeall",methodParams:{items:o}});return o;};
a.prototype.destroyAggregation=function(A,s){if(A==='customData'){this._disconnectAndDestroyCustomDataObserver();}this.fireEvent("aggregationChanged",{aggregationName:A,methodName:"destroy"});return I.prototype.destroyAggregation.apply(this,arguments);};
a.prototype.destroy=function(){var v=sap.ui.getCore().byId(this._getVisualControl());if(v){v.destroy();}return I.prototype.destroy.apply(this,arguments);};
a.prototype._addCustomData=function(v,c){v.addCustomData(c.clone(a.UNIFIED_MENU_ITEMS_ID_SUFFIX,undefined,{bCloneChildren:false,bCloneBindings:true}));this._observeCustomDataChanges(c);};
a.prototype._observeCustomDataChanges=function(c){this._getCustomDataObserver().observe(c,{properties:["value"]});};
a.prototype._customDataObserverCallbackFunction=function(c){sap.ui.getCore().byId(c.object.getId()+"-"+a.UNIFIED_MENU_ITEMS_ID_SUFFIX).setValue(c.current);};
a.prototype._getCustomDataObserver=function(){if(!this._oCustomDataObserver){this._oCustomDataObserver=new M(this._customDataObserverCallbackFunction);}return this._oCustomDataObserver;};
a.prototype._disconnectAndDestroyCustomDataObserver=function(){if(this._oCustomDataObserver){this._oCustomDataObserver.disconnect();this._oCustomDataObserver.destroy();this._oCustomDataObserver=null;}};
a.prototype._setVisualChild=function(c){this._setInternalRef(c,"_sVisualChild");};
a.prototype._setVisualParent=function(c){this._setInternalRef(c,"_sVisualParent");};
a.prototype._setVisualControl=function(c){this._setInternalRef(c,"_sVisualControl");};
a.prototype._setInternalRef=function(c,i){if(!c||typeof c==="string"){this[i]=c;}else if(c.getId){this[i]=c.getId();}};
a.prototype._getVisualChild=function(){return this._sVisualChild;};
a.prototype._getVisualParent=function(){return this._sVisualParent;};
a.prototype._getVisualControl=function(){return this._sVisualControl;};
return a;});
sap.ui.predefine('sap/m/MenuListItem',['./ListItemBase','./library','sap/ui/core/IconPool','sap/ui/core/library','./MenuListItemRenderer'],function(L,l,I,c,M){"use strict";var T=c.TextDirection;
var a=L.extend("sap.m.MenuListItem",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Misc",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconDensityAware:{type:"boolean",group:"Misc",defaultValue:true},titleTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit},startsSection:{type:"boolean",group:"Behavior",defaultValue:false}},associations:{menuItem:{type:"sap.m.MenuItem",multiple:false}}}});
a.prototype.exit=function(){if(this._image){this._image.destroy();}if(this._imageRightArrow){this._imageRightArrow.destroy();}L.prototype.exit.apply(this,arguments);};
a.prototype._getImage=function(i,s,S,b){var o=this._image;if(o){o.setSrc(S);if(o instanceof sap.m.Image){o.setDensityAware(b);}}else{o=I.createControlByURI({id:i,src:S,densityAware:b,useIconTooltip:false},sap.m.Image).setParent(this,null,true);}if(o instanceof sap.m.Image){o.addStyleClass(s,true);}else{o.addStyleClass(s+"Icon",true);}this._image=o;return this._image;};
a.prototype._getIconArrowRight=function(){if(!this._imageRightArrow){this._imageRightArrow=I.createControlByURI({id:this.getId()+"-arrowRight",src:"sap-icon://slim-arrow-right",useIconTooltip:false},sap.m.Image).setParent(this,null,true);this._imageRightArrow.addStyleClass("sapMMenuLIArrowRightIcon",true);}return this._imageRightArrow;};
a.prototype._hasSubItems=function(){return!!(this.getMenuItem()&&sap.ui.getCore().byId(this.getMenuItem()).getItems().length);};
return a;});
sap.ui.predefine('sap/m/MenuListItemRenderer',['./ListItemBaseRenderer','sap/ui/core/Renderer','sap/m/library','sap/ui/core/library'],function(L,R,l,c){"use strict";var T=c.TextDirection;var a=l.ListType;var M=R.extend(L);M.apiVersion=2;
M.openItemTag=function(r,o){if(o.getStartsSection()){r.openStart("li");r.attr("role","separator");r.class("sapUiMnuDiv");r.openEnd();r.openStart("div");r.class("sapUiMnuDivL");r.openEnd();r.close("div");r.voidStart("hr").voidEnd();r.openStart("div");r.class("sapUiMnuDivR");r.openEnd();r.close("div");r.close("li");}L.openItemTag(r,o);};
M.renderLIAttributes=function(r,o){r.class("sapMSLI");if(o.getIcon()){r.class("sapMSLIIcon");}if(o.getType()==a.Detail||o.getType()==a.DetailAndActive){r.class("sapMSLIDetail");}if(o._hasSubItems()){r.class("sapMMenuLIHasChildren");}};
M.renderLIContent=function(r,o){var t=o.getTitleTextDirection();if(o.getIcon()){r.renderControl(o._getImage((o.getId()+"-img"),"sapMMenuLIImgThumb",o.getIcon(),o.getIconDensityAware()));}r.openStart("div");r.class("sapMSLIDiv");r.class("sapMSLITitleDiv");r.openEnd();if(o._bNoFlex){r.openStart("div");r.class("sapMLIBNoFlex");r.openEnd();}r.openStart("div");r.class("sapMSLITitleOnly");if(t!==T.Inherit){r.attr("dir",t.toLowerCase());}r.openEnd();r.text(o.getTitle());r.close("div");if(o._bNoFlex){r.close('div');}r.close("div");if(o._hasSubItems()){r.renderControl(o._getIconArrowRight());}};
return M;},true);
sap.ui.predefine('sap/m/MultiComboBox',['./InputBase','./ComboBoxTextField','./ComboBoxBase','./Tokenizer','./Token','./List','./StandardListItem','./Popover','./GroupHeaderListItem','./library','sap/ui/core/EnabledPropagator','sap/ui/core/IconPool','sap/ui/core/library','sap/ui/Device','sap/ui/core/Item','sap/ui/core/SeparatorItem','sap/ui/core/ResizeHandler','./MultiComboBoxRenderer',"sap/ui/dom/containsOrEquals","sap/m/inputUtils/completeTextSelected","sap/m/inputUtils/inputsDefaultFilter","sap/ui/events/KeyCodes","sap/base/util/deepEqual","sap/base/assert","sap/base/Log","sap/ui/core/Core",'sap/ui/core/InvisibleText',"sap/ui/thirdparty/jquery","sap/ui/dom/jquery/cursorPos","sap/ui/dom/jquery/control"],function(I,C,a,T,b,L,S,P,G,l,E,c,d,D,e,f,R,M,g,h,j,K,k,m,n,o,p,q){"use strict";var r=l.ListType;var s=l.ListMode;var V=d.ValueState;var O=d.OpenState;var t=l.TokenizerRenderMode;
var u=a.extend("sap.m.MultiComboBox",{metadata:{library:"sap.m",designtime:"sap/m/designtime/MultiComboBox.designtime",properties:{selectedKeys:{type:"string[]",group:"Data",defaultValue:[]},hasSelection:{type:"boolean",visibility:"hidden",defaultValue:false}},associations:{selectedItems:{type:"sap.ui.core.Item",multiple:true,singularName:"selectedItem"}},aggregations:{tokenizer:{type:"sap.m.Tokenizer",multiple:false,visibility:"hidden"}},events:{selectionChange:{parameters:{changedItem:{type:"sap.ui.core.Item"},selected:{type:"boolean"}}},selectionFinish:{parameters:{selectedItems:{type:"sap.ui.core.Item[]"}}}},dnd:{draggable:false,droppable:true}}});
c.insertFontFaceStyle();E.apply(u.prototype,[true]);
u.prototype.clone=function(i){var v=a.prototype.clone.apply(this,arguments),w=this._getList();if(w){v.syncPickerContent();}return v;};
u.prototype.open=function(){if(!this.isOpen()){this._bPickerIsOpening=true;}this.syncPickerContent();return a.prototype.open.apply(this,arguments);};
u.prototype.onsapend=function(i){if(i.isMarked("forwardFocusToParent")){this.focus();}};
u.prototype.onsaphome=function(i){if(!this.getFocusDomRef().selectionStart){T.prototype.onsaphome.apply(this.getAggregation("tokenizer"),arguments);}i.setMarked();};
u.prototype.onsapdown=function(i){if(!this.getEnabled()||!this.getEditable()){return;}i.setMarked();i.preventDefault();this.syncPickerContent();var v=this.getSelectableItems();var w=v[0];var x=this;if(w&&this.isOpen()&&this.getValueStateLinks().length){this._handleFormattedTextNav();return;}else if(w&&this.isOpen()){setTimeout(function(){x.getListItem(w).focus();},0);return;}if(this.isFocusInTokenizer()){return;}this._oTraversalItem=this._getNextTraversalItem();if(this._oTraversalItem&&!this.isComposingCharacter()){this.updateDomValue(this._oTraversalItem.getText());this.selectText(0,this.getValue().length);}};
u.prototype.onsapup=function(i){if(!this.getEnabled()||!this.getEditable()){return;}i.setMarked();i.preventDefault();this.syncPickerContent();if(this.isFocusInTokenizer()){return;}this._oTraversalItem=this._getPreviousTraversalItem();if(this._oTraversalItem){this.updateDomValue(this._oTraversalItem.getText());this.selectText(0,this.getValue().length);}};
u.prototype.isFocusInTokenizer=function(){return q.contains(this.getAggregation("tokenizer").getFocusDomRef(),document.activeElement);};
u.prototype.onsapshow=function(i){this._handleItemToFocus();a.prototype.onsapshow.apply(this,arguments);};
u.prototype._handlePopupOpenAndItemsLoad=function(){this._handleItemToFocus();a.prototype._handlePopupOpenAndItemsLoad.apply(this,arguments);};
u.prototype._valueStateNavDelegate=function(v,F,i){var w=this;this.oValueStateNavDelegate={};this.oValueStateNavDelegate.onsapdown=function(){w.getListItem(w.getSelectableItems()[0]).focus();};this.oValueStateNavDelegate.onsapup=function(){w.getFocusDomRef().focus();};this.oValueStateNavDelegate.onsapend=function(x){x.preventDefault();var y=w.getSelectableItems();w.getListItem(w.getSelectableItems()[y.length-1]).focus();};this.oValueStateNavDelegate.onfocusout=function(x){v.removeStyleClass("sapMFocusable");if(!v.getDomRef().contains(x.relatedTarget)){i.forEach(function(y){y.getDomRef().setAttribute("tabindex","-1");});}if(D.browser.msie){F.removeStyleClass("sapMPseudoFocus");}};return this.oValueStateNavDelegate;};
u.prototype._closePickerDelegate={onsaptabnext:function(){if(D.browser.msie){this.getPicker().getCustomHeader().getFormattedText().removeStyleClass("sapMPseudoFocus");}this.close();setTimeout(function(){this.closeValueStateMessage();}.bind(this),0);}};u.prototype._formattedTextLinksNav={onsapup:function(){this.focus();},onsapdown:function(){this.getSelectableItems()[0].focus();}};
u.prototype._handleFormattedTextNav=function(){var i=this.getPicker().getCustomHeader(),v=this.getValueStateLinks(),F=i.getFormattedText(),w=this.oValueStateNavDelegate||this._valueStateNavDelegate(i,F,v),x=v?v[v.length-1]:null,y=v?v[0]:null;if(!v.length||i.getDomRef()===document.activeElement){return;}i.getDomRef().setAttribute("tabindex","-1");i.addDelegate(w);i.addStyleClass("sapMFocusable");i.focus();if(D.browser.msie){F.addStyleClass("sapMPseudoFocus");}v.forEach(function(z){z.getDomRef().setAttribute("tabindex","0");z.addDelegate(this._formattedTextLinksNav,this);},this);this.oMoveFocusBackToVSHeader=!this.oMoveFocusBackToVSHeader?{onsaptabprevious:function(z){z.preventDefault();i.focus();i.addStyleClass("sapMFocusable");}}:this.oMoveFocusBackToVSHeader;x.addDelegate(this._closePickerDelegate,this);y.addDelegate(this.oMoveFocusBackToVSHeader,this);};
u.prototype.onsaphide=u.prototype.onsapshow;
u.prototype._selectItemByKey=function(v){var w,x,y,i,z,A,B=this.isOpen();if(!this.getEnabled()||!this.getEditable()){return;}if(v){v.setMarked();}w=this._getUnselectedItems(B?"":this.getValue());for(i=0;i<w.length;i++){A=!(w[i].getKey()===undefined||w[i].getKey()===null)&&!w[i].isA("sap.ui.core.SeparatorItem");if(w[i].getText().toUpperCase()===this.getValue().toUpperCase()&&A){y=w[i];z=true;break;}}if(z){x={item:y,id:y.getId(),key:y.getKey(),fireChangeEvent:true,fireFinishEvent:true,suppressInvalidate:true,listItemUpdated:false};this._bPreventValueRemove=false;if(this.getValue()===""||(typeof this.getValue()==="string"&&y.getText().toLowerCase().startsWith(this.getValue().toLowerCase()))){if(this.getListItem(y).isSelected()){this.setValue('');}else{this.setSelection(x);}}}else{this._bPreventValueRemove=true;}if(v){this.close();}};
u.prototype.onsapenter=function(i){var v=this.getAggregation("tokenizer");I.prototype.onsapenter.apply(this,arguments);this._showAlreadySelectedVisualEffect();if(this.getValue()){this._selectItemByKey(i);}if(!this.getEditable()&&v.getHiddenTokensCount()&&i.target===this.getFocusDomRef()){v._togglePopup(v.getTokensPopup());}};
u.prototype.onsaptabnext=function(i){var v=this.getValue();if(v){var w=this._getUnselectedItemsStartingText(v);if(w.length===1){this._selectItemByKey(i);}else{this._showWrongValueVisualEffect();}}};
u.prototype.onsaptabprevious=u.prototype.onsaptabnext;
u.prototype.onsapfocusleave=function(i){var v=this.isPlatformTablet(),w=o.byId(i.relatedControlId),F=w&&w.getFocusDomRef(),x=this.getValue(),y=this.getPicker(),z=this.getAggregation("tokenizer");if(!this._bPickerIsOpening&&(!y||!y.getFocusDomRef()||!F||!q.contains(y.getFocusDomRef(),F))){this.setValue(null);if(x){this.fireChangeEvent("",{value:x});}if(!q.contains(this.getDomRef(),document.activeElement)){z.setRenderMode(t.Narrow);}}if(y&&F){if(k(y.getFocusDomRef(),F)&&!v&&!this.isPickerDialog()){this.focus();}}};
u.prototype.onfocusin=function(i){var v=this.getPicker();var w=false;var x=v&&v.getFocusDomRef();var y=(v&&v.oPopup.getOpenState())||O.CLOSED;var z=y===O.CLOSING||y===O.CLOSED;var A=this.getPickerType()==="Dropdown";var B=this.getAggregation("tokenizer");if(A){w=x&&q.contains(x,i.relatedTarget);}if(this.getEditable()&&i.target===this.getDomRef("inner")){B.setRenderMode(t.Loose);}if(i.target===this.getFocusDomRef()){B.hasOneTruncatedToken()&&B.setFirstTokenTruncated(false);this.getEnabled()&&this.addStyleClass("sapMFocus");!z&&w&&this.handleInputValidation(i,false);}if(i.target===this.getOpenArea()&&A&&!this.isPlatformTablet()){this.focus();}if(!this.isOpen()&&this.shouldValueStateMessageBeOpened()){this.openValueStateMessage();}};
u.prototype._handleItemTap=function(i){var v=q(i.target).control(0);if(!v.isA("sap.m.CheckBox")&&!v.isA("sap.m.GroupHeaderListItem")){this._bCheckBoxClicked=false;}};
u.prototype._handleItemPress=function(i){if(this.isOpen()&&this._isListInSuggestMode()&&this.getPicker().oPopup.getOpenState()!==O.CLOSING){this.clearFilter();var v=this._getLastSelectedItem();if(v){this.getListItem(v).focus();}}};
u.prototype._handleSelectionLiveChange=function(i){var v=i.getParameter("listItem");var w=i.getParameter("selected");var N=this._getItemByListItem(v);var x=this.isPickerDialog()?this.getPickerTextField():this;if(v.getType()==="Inactive"){return;}m(N,"The corresponding mapped item was not found on "+this);if(!N){return;}var y={item:N,id:N.getId(),key:N.getKey(),fireChangeEvent:true,suppressInvalidate:true,listItemUpdated:true};if(w){this.fireChangeEvent(N.getText());this.setSelection(y);}else{this.fireChangeEvent(N.getText());this.removeSelection(y);}if(this._bCheckBoxClicked){x.setValue(this._sOldInput);if(this.isOpen()&&this.getPicker().oPopup.getOpenState()!==O.CLOSING){v.focus();}}else{this._bCheckBoxClicked=true;this.setValue("");this.close();}};
u.prototype.onkeydown=function(i){var v=this.getEditable(),w=this.getAggregation("tokenizer"),x=w.getTokens().length;a.prototype.onkeydown.apply(this,arguments);if(!this.getEnabled()){return;}if((i.ctrlKey||i.metaKey)&&i.which===K.I&&x){i.preventDefault();if(v){this._togglePopover();}else{this._handleIndicatorPress();}return;}this._bIsPasteEvent=(i.ctrlKey||i.metaKey)&&(i.which===K.V);if(this.getValue().length===0&&(i.ctrlKey||i.metaKey)&&(i.which===K.A)&&this._hasTokens()){w.focus();w.selectAllTokens(true);i.preventDefault();}if(this.isPickerDialog()){this._sOldValue=this.getPickerTextField().getValue();this._iOldCursorPos=q(this.getFocusDomRef()).cursorPos();}this._bDoTypeAhead=!D.os.android&&(i.which!==K.BACKSPACE)&&(i.which!==K.DELETE);};
u.prototype.oninput=function(i){a.prototype.oninput.apply(this,arguments);var v=i.srcControl,w=this.isPickerDialog(),x=w?this.getPickerTextField():this,y=x.getValueState();if(y===V.Error&&this._bAlreadySelected){x.setValueState(this._sInitialValueState);x.setValueStateText(this._sInitialValueStateText);this._bAlreadySelected=false;}if(!this.getEnabled()||!this.getEditable()){return;}this.syncPickerContent();this.handleInputValidation(i,this.isComposingCharacter());if(this._bIsPasteEvent){v.updateDomValue(this._sOldValue||i.target.value||"");return;}if(this.isOpen()){setTimeout(this.highlightList.bind(this,this._sOldInput));}if(this._getItemsShownWithFilter()){this.toggleIconPressedStyle(true);}};
u.prototype.filterItems=function(i){var F=this.fnFilter?this.fnFilter:j;var v=[];var w=false;var x=[];i.items.forEach(function(y){if(y.isA("sap.ui.core.SeparatorItem")){x.push({separator:y});this.getListItem(y).setVisible(false);w=true;return;}var z=!!F(i.value,y);if(i.value===""){z=true;if(!this.bOpenedByKeyboardOrButton&&!this.isPickerDialog()){return;}}if(w&&z){this.getListItem(x[x.length-1].separator).setVisible(true);}var A=this.getListItem(y);if(A){A.setVisible(z);z&&v.push(y);}},this);return v;};
u.prototype.onkeyup=function(i){if(!this.getEnabled()||!this.getEditable()){return;}this._sOldValue=this.getValue();this._iOldCursorPos=q(this.getFocusDomRef()).cursorPos();};
u.prototype._showWrongValueVisualEffect=function(){var i=this._getSuggestionsPopover();var v=this._sInitialValueStateText;var w=this._sInitialValueState;var x=v||this._oRbC.getText("VALUE_STATE_ERROR");var y=this;if(w===V.Error){return;}if(i){i.updateValueState(V.Error,x,true);setTimeout(i.updateValueState.bind(i,y.getValueState(),x,true),1000);}if(!this.isPickerDialog()){this.setValueState(V.Error);this.setValueStateText(this.getValueStateText()||x);setTimeout(this["setValueState"].bind(this,w||V.Error),1000);}this._syncInputWidth(this.getAggregation("tokenizer"));};
u.prototype._showAlreadySelectedVisualEffect=function(){var A=this._oRbM.getText("VALUE_STATE_ERROR_ALREADY_SELECTED");if(!this.getValue()){return;}var i=!!this.getSelectedItems().filter(function(v){return v.getText().toLowerCase()===this.getValue().toLowerCase();},this).length;var N=this.getItems().filter(function(v){return v.getText().toLowerCase()===this.getValue().toLowerCase();},this).length;if(i){this._sInitialValueState=this.getValueState();this._sInitialValueStateText=this.getValueStateText();this.setValueStateText(A);this._bAlreadySelected=true;this.setValueState("Error");return;}else if(N){return;}else{this._showWrongValueVisualEffect();}};
u.prototype._hasShowSelectedButton=function(){return true;};
u.prototype.forwardEventHandlersToSuggPopover=function(i){a.prototype.forwardEventHandlersToSuggPopover.apply(this,arguments);i.setShowSelectedPressHandler(this._filterSelectedItems.bind(this));};
u.prototype.configPicker=function(i){var v=this.getRenderer(),w=v.CSS_CLASS_MULTICOMBOBOX;i.setHorizontalScrolling(false).addStyleClass(v.CSS_CLASS_COMBOBOXBASE+"Picker").addStyleClass(w+"Picker").addStyleClass(w+"Picker-CTX").attachBeforeOpen(this.onBeforeOpen,this).attachAfterOpen(this.onAfterOpen,this).attachBeforeClose(this.onBeforeClose,this).attachAfterClose(this.onAfterClose,this).addEventDelegate({onBeforeRendering:this.onBeforeRenderingPicker,onAfterRendering:this.onAfterRenderingPicker},this);};
u.prototype._configureList=function(i){if(!i){return;}i.setMode(s.MultiSelect);i.setIncludeItemInSelection(true);i.attachBrowserEvent("tap",this._handleItemTap,this).attachSelectionChange(this._handleSelectionLiveChange,this).attachItemPress(this._handleItemPress,this);i.addEventDelegate({onAfterRendering:this.onAfterRenderingList,onfocusin:this.onFocusinList},this);};
u.prototype._modifyPopupInput=function(i){a.prototype._modifyPopupInput.apply(this,arguments);i.attachSubmit(function(v){var w=i.getValue();if(w){this.setValue(w);this._selectItemByKey();this.setValue(this._sOldInput);this.close();}}.bind(this));i.addEventDelegate({onfocusout:this._handleInputFocusOut},this);return i;};
u.prototype.onBeforeRendering=function(){a.prototype.onBeforeRendering.apply(this,arguments);this._bInitialSelectedKeysSettersCompleted=true;this.getAggregation("tokenizer").setEnabled(this.getEnabled());if(this._getList()){this.syncPickerContent(true);}this._deregisterResizeHandler();this._synchronizeSelectedItemAndKey();this.setProperty("hasSelection",!!this.getSelectedItems().length,true);if(!this._bAlreadySelected){this._sInitialValueStateText=this.getValueStateText();}if(this.getValueState()!==V.Error){this._sInitialValueState=this.getValueState();}};
u.prototype.syncPickerContent=function(F){var i,v,w=this.getPicker();if(!w){w=this.createPicker(this.getPickerType());this._updateSuggestionsPopoverValueState();F=true;}if(F){v=this._getList();i=this.getEditable()?this.getItems():this.getSelectedItems();this._synchronizeSelectedItemAndKey();v.destroyItems();this._clearTokenizer();this._fillList(i);if(v.getItemNavigation()){this._iFocusedIndex=v.getItemNavigation().getFocusedIndex();}}return w;};
u.prototype._registerResizeHandler=function(){m(!this._iResizeHandlerId,"Resize handler already registered");this._iResizeHandlerId=R.register(this,this._onResize.bind(this));};
u.prototype._deregisterResizeHandler=function(){if(this._iResizeHandlerId){R.deregister(this._iResizeHandlerId);this._iResizeHandlerId=null;}};
u.prototype._onResize=function(){var i=this.getAggregation("tokenizer");i.setMaxWidth(this._calculateSpaceForTokenizer());this._syncInputWidth(i);this._handleNMoreAccessibility();};
u.prototype.onBeforeRenderingPicker=function(){var i=this["_onBeforeRendering"+this.getPickerType()];if(i){i.call(this);}};
u.prototype.onAfterRenderingPicker=function(){var i=this["_onAfterRendering"+this.getPickerType()];if(i){i.call(this);}};
u.prototype.onBeforeOpen=function(){a.prototype.onBeforeOpen.apply(this,arguments);var i=this["_onBeforeOpen"+this.getPickerType()];this._resetCurrentItem();this.addContent();this._aInitiallySelectedItems=this.getSelectedItems();this._synchronizeSelectedItemAndKey();if(i){i.call(this);}};
u.prototype.onAfterOpen=function(){var i=this.getFocusDomRef(),v=this.getValueStateLinks();i&&this.getFocusDomRef().setAttribute("aria-expanded","true");this._bPickerIsOpening=false;if(!this.isPlatformTablet()){this.getPicker().setInitialFocus(this);}v.forEach(function(w){w.addDelegate({onAfterRendering:function(){if(this.getFocusDomRef()){this.getFocusDomRef().setAttribute("tabindex","-1");}}},w);});this.closeValueStateMessage();};
u.prototype.onBeforeClose=function(){a.prototype.onBeforeClose.apply(this,arguments);};
u.prototype.onAfterClose=function(){var U=!q.contains(this.getDomRef(),document.activeElement)||this.isPickerDialog(),i=this.getFocusDomRef();i&&this.getFocusDomRef().setAttribute("aria-expanded","false");this.toggleIconPressedStyle(false);this.clearFilter();!this.isComposingCharacter()&&!this._bPreventValueRemove&&this.setValue("");this._sOldValue="";this._sOldInput="";this._getSuggestionsPopover()._sTypedInValue="";if(this.isPickerDialog()){this.getPickerTextField().setValue("");this.getFilterSelectedButton()&&this.getFilterSelectedButton().setPressed(false);}this.fireSelectionFinish({selectedItems:this.getSelectedItems()});this.getAggregation("tokenizer").setRenderMode(U?t.Narrow:t.Loose);if(this.getValueState()==V.Error&&document.activeElement===this.getFocusDomRef()){this.selectText(0,this.getValue().length);}};
u.prototype._onBeforeOpenDialog=function(){};
u.prototype._onBeforeOpenDropdown=function(){var i=this.getPicker(),v=this.getDomRef(),w;if(v&&i){w=(v.offsetWidth/parseFloat(l.BaseFontSize))+"rem";i.setContentMinWidth(w);}};
u.prototype.getFilterSelectedButton=function(){return this._getSuggestionsPopover().getFilterSelectedButton();};
u.prototype._filterSelectedItems=function(i,F){var v=i.oSource,w,x,y=this.getPickerTextField()?this.getPickerTextField().getValue():"",z=(v&&v.getPressed&&v.getPressed())||F,A=this.getVisibleItems(),B=this.getItems(),H=this.getSelectedItems(),J=null;if(z){A.forEach(function(N){x=H.indexOf(N)>-1?true:false;w=this.getListItem(N);if(!w){return;}if(w.isA("sap.m.GroupHeaderListItem")){w.setVisible(false);J=w;}else{w.setVisible(x);if(x&&J){J.setVisible(true);}}},this);}else{this.filterItems({value:y,items:B});}};
u.prototype.revertSelection=function(){this.setSelectedItems(this._aInitiallySelectedItems);};
u.prototype.setSelection=function(i){var v=this._getList();if(i.item&&this.isItemSelected(i.item)){return;}if(!i.item){return;}if(!i.listItemUpdated&&this.getListItem(i.item)&&v){v.setSelectedItem(this.getListItem(i.item),true);}var w=new b({key:i.key});w.setText(i.item.getText());i.item.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Token",w);this.getAggregation("tokenizer").addToken(w);this.$().toggleClass("sapMMultiComboBoxHasToken",this._hasTokens());this.setValue('');this.addAssociation("selectedItems",i.item,i.suppressInvalidate);var x=this.getSelectedKeys();var y=this.getKeys([i.item])[0];if(y===""||x.indexOf(y)===-1){x.push(y);this.setProperty("selectedKeys",x,i.suppressInvalidate);}if(i.fireChangeEvent){this.fireSelectionChange({changedItem:i.item,selected:true});}if(i.fireFinishEvent){if(!this.isOpen()){this.fireSelectionFinish({selectedItems:this.getSelectedItems()});}}};
u.prototype.removeSelection=function(i){if(i.item&&!this.isItemSelected(i.item)){return;}if(!i.item){return;}this.removeAssociation("selectedItems",i.item,i.suppressInvalidate);var v=this.getSelectedKeys();var w=v.indexOf(i.item.getKey());v.splice(w,1);this.setProperty("selectedKeys",v,i.suppressInvalidate);if(!i.listItemUpdated&&this.getListItem(i.item)){var x=this.getListItem(i.item);this._getList().setSelectedItem(x,false);}if(!i.tokenUpdated){var y=this._getTokenByItem(i.item);i.item.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Token",null);this.getAggregation("tokenizer").removeToken(y);}this.$().toggleClass("sapMMultiComboBoxHasToken",this._hasTokens());if(i.fireChangeEvent){this.fireSelectionChange({changedItem:i.item,selected:false});}if(i.fireFinishEvent){if(!this.isOpen()){this.fireSelectionFinish({selectedItems:this.getSelectedItems()});}}};
u.prototype._synchronizeSelectedItemAndKey=function(){var v=this.getSelectedKeys();var w=this.getKeys(this.getSelectedItems());if(!v.length){n.info("Info: _synchronizeSelectedItemAndKey() the MultiComboBox control does not contain any item on ",this);return;}for(var i=0,x=null,y=null,z=v.length;i<z;i++){x=v[i];if(w.indexOf(x)>-1){continue;}y=this.getItemByKey(""+x);if(y){this.setSelection({item:y,id:y.getId(),key:y.getKey(),fireChangeEvent:false,suppressInvalidate:true,listItemUpdated:false});}}};
u.prototype._getTokenByItem=function(i){return i?i.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Token"):null;};
u.prototype.updateItems=function(i){var v=function(z){return z&&z.getKey&&z.getKey();},w,x=this.getSelectedItems().map(v),y=this.getSelectedKeys();var U=a.prototype.updateItems.apply(this,arguments);x=this.getSelectedItems().map(v).filter(function(z){return x.indexOf(z)>-1;});w=y.concat(x);this.setSelectedKeys(w);return U;};
u.prototype._getSelectedItemsOf=function(v){for(var i=0,w=v.length,x=[];i<w;i++){if(this.getListItem(v[i]).isSelected()){x.push(v[i]);}}return x;};
u.prototype._getLastSelectedItem=function(){var i=this.getAggregation("tokenizer").getTokens();var v=i.length?i[i.length-1]:null;if(!v){return null;}return this._getItemByToken(v);};
u.prototype._getFocusedListItem=function(){if(!document.activeElement){return null;}var F=o.byId(document.activeElement.id);if(this._getList()&&g(this._getList().getFocusDomRef(),F.getFocusDomRef())){return F;}return null;};
u.prototype._getFocusedItem=function(){var i=this._getFocusedListItem();return this._getItemByListItem(i);};
u.prototype._hasTokens=function(){return this.getAggregation("tokenizer").getTokens().length>0;};
u.prototype._getCurrentItem=function(){if(!this._oCurrentItem){return this._getFocusedItem();}return this._oCurrentItem;};
u.prototype._setCurrentItem=function(i){this._oCurrentItem=i;};
u.prototype._resetCurrentItem=function(){this._oCurrentItem=null;};
u.prototype._decorateListItem=function(i){i.addDelegate({onkeyup:function(v){var w=null;if(v.which==K.SPACE&&this.isOpen()&&this._isListInSuggestMode()){this.open();w=this._getLastSelectedItem();if(w){this.getListItem(w).focus();}return;}},onkeydown:function(v){var w=null,x=null;if(v.shiftKey&&v.which==K.ARROW_DOWN){x=this._getCurrentItem();w=this._getNextVisibleItemOf(x);}if(v.shiftKey&&v.which==K.ARROW_UP){x=this._getCurrentItem();w=this._getPreviousVisibleItemOf(x);}if(v.shiftKey&&v.which===K.SPACE){x=this._getCurrentItem();this._selectPreviousItemsOf(x);}if(w&&w!==x){if(this.getListItem(x).isSelected()){this.setSelection({item:w,id:w.getId(),key:w.getKey(),fireChangeEvent:true,suppressInvalidate:true});this._setCurrentItem(w);}else{this.removeSelection({item:w,id:w.getId(),key:w.getKey(),fireChangeEvent:true,suppressInvalidate:true});this._setCurrentItem(w);}return;}this._resetCurrentItem();if((v.ctrlKey||v.metaKey)&&v.which==K.A){v.setMarked();v.preventDefault();var y=this.getSelectableItems();var z=this._getSelectedItemsOf(y);if(z.length!==y.length){y.forEach(function(w){this.setSelection({item:w,id:w.getId(),key:w.getKey(),fireChangeEvent:true,suppressInvalidate:true,listItemUpdated:false});},this);}else{y.forEach(function(w){this.removeSelection({item:w,id:w.getId(),key:w.getKey(),fireChangeEvent:true,suppressInvalidate:true,listItemUpdated:false});},this);}}}},true,this);i.addEventDelegate({onsapbackspace:function(v){v.preventDefault();},onsapshow:function(v){v.setMarked();if(this.isOpen()){this.close();return;}if(this.hasContent()){this.open();}},onsaphide:function(v){this.onsapshow(v);},onsapenter:function(v){v.setMarked();this.close();},onsaphome:function(v){v.setMarked();v.preventDefault();if(this.getValueStateLinks().length){this._handleFormattedTextNav();v.stopPropagation(true);return;}var w=this.getSelectableItems();var x=w[0];this.getListItem(x).focus();},onsapend:function(v){v.setMarked();v.preventDefault();var w=this.getSelectableItems();var x=w[w.length-1];this.getListItem(x).focus();},onsapup:function(v){v.setMarked();v.preventDefault();var w=this.getSelectableItems();var x=w[0];var y=q(document.activeElement).control()[0];if(y===this.getListItem(x)&&this.getValueStateLinks().length){this._handleFormattedTextNav();v.stopPropagation(true);return;}else if(y===this.getListItem(x)){this.focus();v.stopPropagation(true);}},onfocusin:function(v){this.addStyleClass(this.getRenderer().CSS_CLASS_MULTICOMBOBOX+"Focused");},onfocusout:function(v){this.removeStyleClass(this.getRenderer().CSS_CLASS_MULTICOMBOBOX+"Focused");},onsapfocusleave:function(v){var w=this.getAggregation("picker");var x=o.byId(v.relatedControlId);if(w&&x&&k(w.getFocusDomRef(),x.getFocusDomRef())){if(v.srcControl){v.srcControl.focus();}}}},this);if(D.support.touch){i.addEventDelegate({ontouchstart:function(v){v.setMark("cancelAutoClose");}});}};
u.prototype._handleInputFocusOut=function(){var i=this.isPickerDialog()?this.getPickerTextField():this,U=this._sOldInput||this._sOldValue||"";i.updateDomValue(U);this._bIsPasteEvent=null;};
u.prototype.onItemChange=function(i){var v=a.prototype.onItemChange.apply(this,arguments);this._forwardItemInfoToToken(i);return v;};
u.prototype._forwardItemInfoToToken=function(i){var v=i.getSource(),w=i.getParameters(),x=this._getTokenByItem(v);if(!x){return;}if(w.name==="enabled"){x.setVisible(w.newValue);}else if(x.getMetadata().hasProperty(w.name)){x.setProperty(w.name,w.newValue,false);}};
u.prototype._handleIndicatorPress=function(){var i,v=this.getAggregation("tokenizer");if(this.getEditable()){this.syncPickerContent();this._filterSelectedItems({},true);this.focus();i=this.getPicker();i.open();}else{v._togglePopup(v.getTokensPopup());}if(this.isPickerDialog()){this.getFilterSelectedButton().setPressed(true);this.bOpenedByKeyboardOrButton=true;}};
u.prototype._togglePopover=function(){var i=this.getPicker();if(!i){i=this.syncPickerContent(true);}if(i.isOpen()){i.close();}else{i.open();}};
u.prototype._createTokenizer=function(){var i=new T({renderMode:t.Narrow}).attachTokenDelete(this._handleTokenDelete,this);i.getTokensPopup().attachAfterOpen(function(){if(i.hasOneTruncatedToken()){i.setFirstTokenTruncated(false);}}).attachAfterClose(function(){var v=i.getTokens();if(v.length===1&&!v[0].getTruncated()){i.setFirstTokenTruncated(true);}});i.addEventDelegate({onAfterRendering:this._onAfterRenderingTokenizer},this);return i;};
u.prototype._onAfterRenderingTokenizer=function(){var i=this.getAggregation("tokenizer");if(this.getEditable()){i.addStyleClass("sapMTokenizerIndicatorDisabled");}else{i.removeStyleClass("sapMTokenizerIndicatorDisabled");}setTimeout(this._syncInputWidth.bind(this,i),0);setTimeout(this._handleNMoreAccessibility.bind(this),0);setTimeout(i["scrollToEnd"].bind(i),0);};
u.prototype._handleTokenDelete=function(i){var v=i.getParameter("tokens");var w=this.getSelectedItems();this._removeSelection(v);if(w.length!==this.getSelectableItems()){!this.isPickerDialog()&&!this.isFocusInTokenizer()&&this.focus();this.fireChangeEvent("");this.setProperty("hasSelection",!!this.getSelectedItems().length);}};
u.prototype._removeSelection=function(i){var v=this.getAggregation("tokenizer");i.forEach(function(w){var x=(w&&this._getItemByToken(w));if(x&&this.isItemSelected(x)){this.removeSelection({item:x,id:x.getId(),key:x.getKey(),tokenUpdated:true,fireChangeEvent:true,fireFinishEvent:true,suppressInvalidate:true});w.destroy();if(this.getSelectedItems().length>0){var i=v.getTokens();i[i.length-1].focus();}else{this.focus();}}},this);};
u.prototype.onAfterRenderingList=function(){var i=this._getList();var v=document.activeElement===this.getFocusDomRef();if(this.getEditable()&&!v&&i&&i.getItems()[this._iFocusedIndex]){i.getItems()[this._iFocusedIndex].focus();this._iFocusedIndex=null;}};
u.prototype.onFocusinList=function(){if(this._bListItemNavigationInvalidated&&this._getList().getItemNavigation()){this._getList().getItemNavigation().setSelectedIndex(this._iInitialItemFocus);this._bListItemNavigationInvalidated=false;}};
u.prototype.onAfterRendering=function(){var i=this.getAggregation("tokenizer");a.prototype.onAfterRendering.apply(this,arguments);this._registerResizeHandler();setTimeout(function(){i.setMaxWidth(this._calculateSpaceForTokenizer());}.bind(this),0);};
u.prototype.onfocusout=function(i){this.isOpen()&&this._handleInputFocusOut();this.removeStyleClass("sapMFocus");if(this.getValueState()===V.Error&&this.getValueStateText()===this._oRbM.getText("VALUE_STATE_ERROR_ALREADY_SELECTED")){this.setValueState(this._sInitialValueState);this.setValueStateText(this._sInitialValueStateText);}a.prototype.onfocusout.apply(this,arguments);};
u.prototype.onpaste=function(i){var v;if(window.clipboardData){v=window.clipboardData.getData("Text");}else{v=i.originalEvent.clipboardData.getData('text/plain');}var w=v.split(/\r\n|\r|\n/g);if(w&&w.length>0){this.getSelectableItems().forEach(function(x){if(w.indexOf(x.getText())>-1){this.setSelection({item:x,id:x.getId(),key:x.getKey(),fireChangeEvent:true,fireFinishEvent:true,suppressInvalidate:true,listItemUpdated:false});}},this);}};
u.prototype.onsapbackspace=function(i){var v=this.getAggregation("tokenizer");var w=v.getTokens();var x=w.filter(function(y){return y.getSelected();});if(!this.getEnabled()||!this.getEditable()){i.preventDefault();return;}if(this.getCursorPosition()>0||this.getValue().length>0){return;}if(x.length>0){this._removeAllTokens();return;}if(document.activeElement===this.getFocusDomRef()){w[w.length-1]&&w[w.length-1].focus();}i.preventDefault();};
u.prototype._removeAllTokens=function(){var i=this.getAggregation("tokenizer");var v=i.getTokens().filter(function(w){return w.getSelected();});if(!v.length){return;}this._removeSelection(v);this.fireChangeEvent("");this.invalidate();};
u.prototype.onsapdelete=u.prototype.onsapbackspace;
u.prototype.onsapnext=function(i){var v=this.getAggregation("tokenizer");if(i.isMarked()){return;}var F=q(document.activeElement).control()[0];if(!F){return;}if(F===v||v.$().find(F.$()).length>0&&this.getEditable()){this.focus();}};
u.prototype.onsapprevious=function(i){if(this.getCursorPosition()===0&&!h(this.getFocusDomRef())){if(i.srcControl===this){T.prototype.onsapprevious.apply(this.getAggregation("tokenizer"),arguments);}}};
u.prototype.onclick=function(i){var v=this.getEditable(),w=this.getEnabled(),N=i.target.className.indexOf("sapMTokenizerIndicator")>-1,x=this.getAggregation("tokenizer"),y=i.target.className.indexOf("sapMToken")>-1&&this.getAggregation("tokenizer").hasOneTruncatedToken();if(v&&w&&(N||y)){i.preventDefault();this._handleIndicatorPress();x.setFirstTokenTruncated(false);}};
u.prototype.ontap=function(i){a.prototype.ontap.apply(this,arguments);var v=this.getOpenArea();if(!this.getEnabled()||!this.getEditable()){return;}i.setMarked();if(this.isPickerDialog()&&v.contains(i.target)){this.open();}};
u.prototype.getOpenArea=function(){if(this.isPickerDialog()){return this.getDomRef();}else{return a.prototype.getOpenArea.apply(this,arguments);}};
u.prototype._getItemsStartingWithPerTerm=function(i,v){var w=[],x=v?this.getEnabledItems():this.getSelectableItems(),F=this.fnFilter?this.fnFilter:j;x.forEach(function(y){if(F(i,y)){w.push(y);}},this);return w;};
u.prototype._getItemsStartingWith=function(i,v){var w=[],x=v?this.getEnabledItems():this.getSelectableItems();x.forEach(function(y){if(typeof i==="string"&&i!==""&&y.getText().toLowerCase().startsWith(i.toLowerCase())){w.push(y);}},this);return w;};
u.prototype._getUnselectedItemsStartingText=function(i){var v=[];this._getUnselectedItems().forEach(function(w){if(typeof i==="string"&&i!==""&&w.getText().toLowerCase().startsWith(i.toLowerCase())){v.push(w);}},this);return v;};
u.prototype.getCursorPosition=function(){return this._$input.cursorPos();};
u.prototype._selectPreviousItemsOf=function(i){var v;do{v=true;var w=this._getPreviousVisibleItemOf(i);if(w){var x=this.getListItem(w);if(x){v=this.getListItem(w).getSelected();}}this.setSelection({item:i,id:i.getId(),key:i.getKey(),fireChangeEvent:true,suppressInvalidate:true});i=w;}while(!v);};
u.prototype._getNextVisibleItemOf=function(i){var v=this.getSelectableItems();var w=v.indexOf(i)+1;if(w<=0||w>v.length-1){return null;}return v[w];};
u.prototype._getPreviousVisibleItemOf=function(i){var v=this.getSelectableItems();var w=v.indexOf(i)-1;if(w<0){return null;}return v[w];};
u.prototype._getNextUnselectedItemOf=function(i){var v=this._getUnselectedItems();var w=v.indexOf(i)+1;if(w<=0||w>v.length-1){return null;}return v[w];};
u.prototype._getPreviousUnselectedItemOf=function(i){var v=this._getUnselectedItems();var w=v.indexOf(i)-1;if(w<0){return null;}return v[w];};
u.prototype._getNextTraversalItem=function(){var v=this.getValue();var i=v?this._getItemsStartingWithPerTerm(v):[];var w=this._getUnselectedItems();if(i.indexOf(this._oTraversalItem)>-1&&this._oTraversalItem.getText()===this.getValue()){return this._getNextUnselectedItemOf(this._oTraversalItem);}if(i.length&&i[0].getText()===this.getValue()){return this._getNextUnselectedItemOf(i[0]);}return i.length?i[0]:w[0];};
u.prototype._getPreviousTraversalItem=function(){var v=this.getValue();var i=v?this._getItemsStartingWithPerTerm(v):[];if(i.indexOf(this._oTraversalItem)>-1&&this._oTraversalItem.getText()===this.getValue()){return this._getPreviousUnselectedItemOf(this._oTraversalItem);}if(i.length&&i[i.length-1].getText()===this.getValue()){return this._getPreviousUnselectedItemOf(i[i.length-1]);}if(i.length){return i[i.length-1];}else{var w=this._getUnselectedItems();if(w.length>0){return w[w.length-1];}else{return null;}}};
u.prototype.setSelectedItems=function(i){this.removeAllSelectedItems();if(!i||!i.length){return this;}if(!Array.isArray(i)){n.warning("Warning: setSelectedItems() has to be an array of sap.ui.core.Item instances or of valid sap.ui.core.Item IDs",this);return this;}i.forEach(function(v){if(!(v instanceof e)&&(typeof v!=="string")){n.warning("Warning: setSelectedItems() has to be an array of sap.ui.core.Item instances or of valid sap.ui.core.Item IDs",this);return;}if(typeof v==="string"){v=o.byId(v);}this.setSelection({item:v?v:null,id:v?v.getId():"",key:v?v.getKey():"",suppressInvalidate:true});},this);return this;};
u.prototype.addSelectedItem=function(i){if(!i){return this;}if(typeof i==="string"){i=o.byId(i);}this.setSelection({item:i?i:null,id:i?i.getId():"",key:i?i.getKey():"",fireChangeEvent:false,suppressInvalidate:true});return this;};
u.prototype.removeSelectedItem=function(i){if(!i){return null;}if(typeof i==="string"){i=o.byId(i);}if(!this.isItemSelected(i)){return null;}this.removeSelection({item:i,id:i.getId(),key:i.getKey(),fireChangeEvent:false,suppressInvalidate:true});return i;};
u.prototype.removeAllSelectedItems=function(){var i=[];var v=this.getAssociation("selectedItems",[]);v.forEach(function(w){var x=this.removeSelectedItem(w);if(x){i.push(x.getId());}},this);return i;};
u.prototype.removeSelectedKeys=function(i){var v,w=[];if(!i||!i.length||!Array.isArray(i)){return w;}i.forEach(function(x){v=this.getItemByKey(x);if(v){this.removeSelection({item:v?v:null,id:v?v.getId():"",key:v?v.getKey():"",fireChangeEvent:false,suppressInvalidate:true});w.push(v);}},this);return w;};
u.prototype.setSelectedKeys=function(i){if(this._bInitialSelectedKeysSettersCompleted){this.setProperty("selectedKeys",[],true);this.removeAllSelectedItems();}this.addSelectedKeys(i);this._bInitialSelectedKeysSettersCompleted=true;return this;};
u.prototype.addSelectedKeys=function(i){var v,w=[];i=this.validateProperty("selectedKeys",i);i.forEach(function(x){var y=this.getItemByKey(x);if(y){this.addSelectedItem(y);}else if(x!=null){w.push(x);}},this);if(w.length>0){v=this.getProperty("selectedKeys").filter(function(x){return w.indexOf(x)===-1;});w=v.concat(w);this.setProperty("selectedKeys",w,true);}return this;};
u.prototype._getUnselectedItems=function(){var i=q(this.getSelectableItems()).not(this.getSelectedItems()).get();if(!this.isOpen()){return i.filter(function(v){return!v.isA("sap.ui.core.SeparatorItem");});}return i;};
u.prototype.getSelectedItems=function(){var i=[],v=this.getAssociation("selectedItems")||[];v.forEach(function(w){var x=o.byId(w);if(x){i.push(x);}},this);return i;};
u.prototype.getWidth=function(){return this.getProperty("width")||"100%";};
u.prototype.setEditable=function(i){var v=this._getList(),w=this.getAggregation("tokenizer");a.prototype.setEditable.apply(this,arguments);w.setEditable(i);if(v){this.syncPickerContent(true);this._updatePopoverBasedOnEditMode(i);}return this;};
u.prototype._updatePopoverBasedOnEditMode=function(i){var v=this._getList(),w=this._getSuggestionsPopover();if(!v){return;}if(i){w.addContent(v);}};
u.prototype._mapItemToListItem=function(i){var v,w,x,A;var y=this.getRenderer();if(!i){return null;}A=(i.getAdditionalText&&this.getShowSecondaryValues())?i.getAdditionalText():"";if(i.isA("sap.ui.core.SeparatorItem")){v=this._mapSeparatorItemToGroupHeader(i,y);i.data(y.CSS_CLASS_COMBOBOXBASE+"ListItem",v);this._decorateListItem(v);return v;}w=y.CSS_CLASS_MULTICOMBOBOX+"Item";x=(this.isItemSelected(i))?w+"Selected":"";v=new S({type:r.Active,visible:i.getEnabled()}).addStyleClass(w+" "+x);v.setTooltip(i.getTooltip());i.data(y.CSS_CLASS_COMBOBOXBASE+"ListItem",v);v.setTitle(i.getText());v.setInfo(A);if(x){var z=new b({key:i.getKey()});z.setText(i.getText());i.data(y.CSS_CLASS_COMBOBOXBASE+"Token",z);this.getAggregation("tokenizer").addToken(z,true);}this.setSelectable(i,i.getEnabled());this._decorateListItem(v);return v;};
u.prototype.setSelectable=function(i,v){a.prototype.setSelectable.call(this,i,v);var w=this._getTokenByItem(i);if(w){w.setVisible(v);}};
u.prototype._fillList=function(v){if(!v){return null;}if(!this._oListItemEnterEventDelegate){this._oListItemEnterEventDelegate={onsapenter:function(y){if(y.srcControl.isSelected()){y.setMarked();}}};}for(var i=0,w,x=v.length;i<x;i++){w=this._mapItemToListItem(v[i]);w.removeEventDelegate(this._oListItemEnterEventDelegate);w.addDelegate(this._oListItemEnterEventDelegate,true,this,true);this._getList().addAggregation("items",w,true);if(this.isItemSelected(v[i])){this._getList().setSelectedItem(w,true);}}};
u.prototype.handleInputValidation=function(i,v){var w=i.target.value,x=this._sOldInput&&this._sOldInput.length>w.length,y=this.isValueValid(w),z,A,B;var F=i.srcControl;if(!y&&w!==""&&!v){this._handleFieldValidationState(F);return;}B=this._getItemsStartingWith(w,true);if(!v||this._bIsPasteEvent){this._handleTypeAhead(w,B,F);}z=this.getEnabledItems();if(this.isPickerDialog()){A=this.getFilterSelectedButton();if(A!=null&&A.getPressed()){A.setPressed(false);}}if(x){z=this.getItems();}this.filterItems({value:w,items:z});this._sOldInput=w;if((!this.getValue()||!y)&&!this.bOpenedByKeyboardOrButton&&!this.isPickerDialog()){this.close();}else{this.open();}};
u.prototype.isValueValid=function(v){var i=this._getItemsStartingWith(v,true);var w=this._getItemsStartingWithPerTerm(v,true);return i.length||w.length;};
u.prototype._handleTypeAhead=function(v,i,w){var x=this.getSelectedItems();var y=i.filter(function(z){if(z.isA("sap.ui.core.SeparatorItem")){return false;}return x.indexOf(z)===-1;});if(this._bDoTypeAhead&&y.length){w.updateDomValue(y[0].getText());if(document.activeElement===w.getFocusDomRef()){w.selectText(v.length,w.getValue().length);}}};
u.prototype._handleFieldValidationState=function(i){if(this._sOldInput&&this.isValueValid(this._sOldInput)){i.updateDomValue(this._sOldInput);}else if(this._sOldValue&&this.isValueValid(this._sOldValue)){i.updateDomValue(this._sOldValue);}else{i.updateDomValue("");}if(this._iOldCursorPos){q(i.getFocusDomRef()).cursorPos(this._iOldCursorPos);}this._showWrongValueVisualEffect();};
u.prototype.init=function(){this._oRb=o.getLibraryResourceBundle("sap.m");a.prototype.init.apply(this,arguments);this._bInitialSelectedKeysSettersCompleted=false;this._bListItemNavigationInvalidated=false;this._iInitialItemFocus=-1;this._bCheckBoxClicked=true;this._bPreventValueRemove=false;this._oTokenizer=this._createTokenizer();this.setAggregation("tokenizer",this._oTokenizer);this._aInitiallySelectedItems=[];this._oRbM=o.getLibraryResourceBundle("sap.m");this._oRbC=o.getLibraryResourceBundle("sap.ui.core");this._fillList();};
u.prototype.clearSelection=function(){this.removeAllSelectedItems();};
u.prototype.insertItem=function(i,v){this.insertAggregation("items",i,v,true);if(i){i.attachEvent("_change",this.onItemChange,this);}if(this._getList()){this._getList().insertItem(this._mapItemToListItem(i),v);}return this;};
u.prototype.removeItem=function(i){i=this.removeAggregation("items",i);if(this._getList()){this._getList().removeItem(i&&this.getListItem(i));}this.removeSelection({item:i,id:i?i.getId():"",key:i?i.getKey():"",fireChangeEvent:false,suppressInvalidate:true,listItemUpdated:true});return i;};
u.prototype.isItemSelected=function(i){return this.getSelectedItems().indexOf(i)>-1;};
u.prototype._clearTokenizer=function(){this.getAggregation("tokenizer").destroyTokens();};
u.prototype.exit=function(){var i=["_oSuggestionPopover","_oToggleButton","_oPickerCustomHeader","_oCustomHeaderToolbar","_oPickerCloseButton"],v=this;a.prototype.exit.apply(this,arguments);this._deregisterResizeHandler();i.forEach(function(w){if(v[w]){v[w].destroy();v[w]=null;}});this._sInitialValueState=null;};
u.prototype.destroyItems=function(){this.destroyAggregation("items");this.setProperty("selectedKeys",[],true);if(this._getList()){this._getList().destroyItems();}this.getAggregation("tokenizer").destroyTokens();return this;};
u.prototype.removeAllItems=function(){var i=this.removeAllAggregation("items");this.removeAllSelectedItems();if(this._getList()){this._getList().removeAllItems();}return i;};
u.prototype._getItemByToken=function(i){return this._getItemBy(i,"Token");};
u.prototype._getItemByValue=function(v){return this.getSelectableItems().find(function(i){return i.getText().toLowerCase()===v.toLowerCase();});};
u.prototype._handleItemToFocus=function(){if(this.isOpen()){return;}this.syncPickerContent();var i,v,w=o.byId(document.activeElement.id),x=this.getSelectedItems(),y=this.getSelectableItems(),z=this._getList(),A=z&&z.getItemNavigation(),B=this.getValue(),F=this.getPicker();if(w&&w.isA("sap.m.Token")){v=this._getItemByToken(w);}else if(B){v=this._getItemByValue(B);}if(!v){v=x.length?this._getItemByListItem(this._getList().getSelectedItems()[0]):y[0];}i=y.indexOf(v);if(A){A.setSelectedIndex(i);}else{this._bListItemNavigationInvalidated=true;this._iInitialItemFocus=i;}F.setInitialFocus(z);};
u.prototype.getAccessibilityInfo=function(){var i=this.getSelectedItems().map(function(w){return w.getText();}).join(" ");var v=a.prototype.getAccessibilityInfo.apply(this,arguments);v.type=o.getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_MULTICOMBO");v.description=((v.description||"")+" "+i).trim();return v;};
u.prototype._calculateSpaceForTokenizer=function(){if(this.getDomRef()){var i,v=this.getDomRef().offsetWidth,w=this._calculateIconsSpace(),x=this.$().find(".sapMInputBaseInner"),y=["min-width","padding-right","padding-left"],z=y.reduce(function(A,B){return A+(parseInt(x.css(B))||0);},0);i=v-(w+z);i=i<0?0:i;return i+"px";}else{return null;}};
u.prototype._syncInputWidth=function(i){var F=this.getDomRef('inner'),v,w;if(!F||(i&&!i.getDomRef())){return;}w=parseFloat(i.getDomRef().getBoundingClientRect().width.toFixed(2));v=this._calculateIconsSpace();F.style.width='calc(100% - '+parseFloat(v+w)+"px)";};
u.prototype._handleNMoreAccessibility=function(){var i=p.getStaticId("sap.m","MULTICOMBOBOX_OPEN_NMORE_POPOVER"),v=this.getAggregation("tokenizer"),F=this.getFocusDomRef(),A=(F&&F.getAttribute("aria-labelledby")),w=A?A.split(" "):[],N=w.indexOf(i),x=this.getEnabled(),y=!this.getEditable()&&v&&v.getHiddenTokensCount();if(y&&N===-1){w.push(i);x&&this.getFocusDomRef().setAttribute("aria-keyshortcuts","Enter");}else if(N!==-1&&!y){w.splice(N,1);this.getFocusDomRef().removeAttribute("aria-keyshortcuts");}if(F&&w.length){F.setAttribute("aria-labelledby",w.join(" ").trim());}};
u.prototype.applyShowItemsFilters=function(){this.syncPickerContent();this.filterItems({value:this.getValue()||"_",items:this.getItems()});};
u.prototype.showItems=function(F){var H=true,i=this.fnFilter;if(typeof F==="function"){this.syncPickerContent();this.setFilterFunction(F||function(){return true;});H=this.filterItems({value:this.getValue()||"_",items:this.getItems()}).length>0;this.setFilterFunction(i);}if(H){a.prototype.showItems.apply(this,arguments);}};
return u;});
sap.ui.predefine('sap/m/MultiComboBoxRenderer',['./ComboBoxBaseRenderer','./ComboBoxTextFieldRenderer','sap/ui/core/Renderer','sap/ui/core/Core'],function(C,a,R,b){"use strict";var M=R.extend(C);M.apiVersion=2;M.CSS_CLASS_MULTICOMBOBOX="sapMMultiComboBox";
M.addOuterClasses=function(r,c){C.addOuterClasses.apply(this,arguments);r.class(M.CSS_CLASS_MULTICOMBOBOX);if(c.getProperty("hasSelection")){r.class("sapMMultiComboBoxHasToken");}};
M.getAriaDescribedBy=function(c){var A=a.getAriaDescribedBy.apply(this,arguments),t=c.getAggregation("tokenizer"),i=t&&t.getTokensInfoId();return(A||"")+" "+i;};
M.getAccessibilityState=function(c){var A=C.getAccessibilityState.apply(this,arguments),r=b.getLibraryResourceBundle("sap.m");A.roledescription=r.getText("MULTICOMBOBOX_ARIA_ROLE_DESCRIPTION");return A;};
M.prependInnerContent=function(r,c){r.renderControl(c.getAggregation("tokenizer"));};
return M;},true);
sap.ui.predefine('sap/m/MultiInput',['./Input','./Tokenizer','./Token','./library','sap/ui/core/EnabledPropagator','sap/ui/base/ManagedObjectMetadata','sap/ui/base/ManagedObjectObserver','sap/ui/Device','./Popover','./List','./Title','./Bar','./Toolbar','./StandardListItem','sap/ui/core/ResizeHandler','sap/ui/core/IconPool','./MultiInputRenderer',"sap/ui/dom/containsOrEquals","sap/m/inputUtils/completeTextSelected","sap/ui/events/KeyCodes",'sap/ui/core/InvisibleText',"sap/ui/thirdparty/jquery","sap/ui/dom/jquery/cursorPos","sap/ui/dom/jquery/control"],function(I,T,a,l,E,M,b,D,P,L,c,B,d,S,R,f,g,h,j,K,k,q){"use strict";var m=l.TokenizerRenderMode;
var n=I.extend("sap.m.MultiInput",{metadata:{library:"sap.m",designtime:"sap/m/designtime/MultiInput.designtime",properties:{enableMultiLineMode:{type:"boolean",group:"Behavior",defaultValue:false},maxTokens:{type:"int",group:"Behavior"}},aggregations:{tokens:{type:"sap.m.Token",multiple:true,singularName:"token"},tokenizer:{type:"sap.m.Tokenizer",multiple:false,visibility:"hidden"}},events:{tokenChange:{parameters:{type:{type:"string"},token:{type:"sap.m.Token"},tokens:{type:"sap.m.Token[]"},addedTokens:{type:"sap.m.Token[]"},removedTokens:{type:"sap.m.Token[]"}}},tokenUpdate:{allowPreventDefault:true,parameters:{type:{type:"string"},addedTokens:{type:"sap.m.Token[]"},removedTokens:{type:"sap.m.Token[]"}}}},dnd:{draggable:false,droppable:true}}});
E.apply(n.prototype,[true]);var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");
n.prototype.init=function(){var t=this;this._bShowListWithTokens=false;I.prototype.init.call(this);this._bIsValidating=false;var o=new T({renderMode:m.Narrow,tokenDelete:this._tokenDelete.bind(this)});o.updateTokens=function(){this.destroyTokens();this.updateAggregation("tokens");};this.setAggregation("tokenizer",o);o.getTokensPopup().setInitialFocus(this).attachBeforeOpen(this._onBeforeOpenTokensPicker.bind(this)).attachAfterClose(this._onAfterCloseTokensPicker.bind(this));this.setAggregation("tokenizer",o);this._oTokenizerObserver=new b(function(C){var s=C.mutation;var e=C.child;switch(s){case"insert":this.fireTokenChange({type:sap.m.Tokenizer.TokenChangeType.Added,token:e,tokens:[e],removedTokens:[]});break;case"remove":var i=C.object.getTokens().length?sap.m.Tokenizer.TokenChangeType.Removed:sap.m.Tokenizer.TokenChangeType.RemovedAll;this.fireTokenChange({type:i,token:e,removedTokens:[e]});break;default:break;}this.invalidate();}.bind(this));this._oTokenizerObserver.observe(o,{aggregations:["tokens"]});this._bShowListWithTokens=false;this._bIsValidating=false;o.addEventDelegate({onThemeChanged:this._handleInnerVisibility.bind(this),onAfterRendering:function(){if(this.isMobileDevice()&&this.getEditable()){o.addStyleClass("sapMTokenizerIndicatorDisabled");}else{o.removeStyleClass("sapMTokenizerIndicatorDisabled");}this._syncInputWidth(o);this._handleInnerVisibility();this._handleNMoreAccessibility();this._registerTokenizerResizeHandler();}.bind(this)},this);this._aTokenValidators=[];this.setShowValueHelp(true);this.setShowSuggestion(true);this._getSuggestionsPopoverInstance()._oPopover.attachBeforeOpen(function(){if(t.isMobileDevice()!==true){return;}var e=o._getTokensList();o._fillTokensList(e);this.addContent(e);t._manageListsVisibility(!!o.getTokens().length);});this.attachSuggestionItemSelected(this._onSuggestionItemSelected,this);this.attachLiveChange(this._onLiveChange,this);this.attachValueHelpRequest(this._onValueHelpRequested,this);this._getValueHelpIcon().setProperty("visible",true,true);this._onResize=this._onResize.bind(this);};
n.prototype.exit=function(){this._deregisterResizeHandler();this._deregisterTokenizerResizeHandler();this._oTokenizerObserver.disconnect();this._oTokenizerObserver.destroy();this._oTokenizerObserver=null;I.prototype.exit.call(this);};
n.prototype.onAfterRendering=function(){var t=this.getAggregation("tokenizer");this._bTokenIsValidated=false;t.setMaxWidth(this._calculateSpaceForTokenizer());t.scrollToEnd();this._registerResizeHandler();I.prototype.onAfterRendering.apply(this,arguments);};
n.prototype._tokenDelete=function(e){this._deleteTokens(e.getParameter("tokens"),e.getParameters());};
n.prototype._deleteTokens=function(e,o){var t=this.getAggregation("tokenizer");var i=0;var p=o.keyCode===K.BACKSPACE;var s=e[e.length-1];var F=e[0];i=this.getTokens().indexOf(p?F:s);t.focusToken(i,o,function(){this.focus();}.bind(this));this.fireTokenUpdate({type:T.TokenUpdateType.Removed,addedTokens:[],removedTokens:e});e.forEach(function(u){u.destroy();},this);};
n.prototype._handleInnerVisibility=function(){var H=!!this.getAggregation("tokenizer").getHiddenTokensCount();this._setValueVisible(!H);};
n.prototype.oninput=function(e){this.setProperty("selectedKey",'',true);I.prototype.oninput.call(this,e);if(e.isMarked("invalid")||!this.getEditable()){return;}this._setValueVisible(true);this._manageListsVisibility(false);this.getAggregation("tokenizer").getTokensPopup().close();};
n.prototype._registerResizeHandler=function(){if(!this._iResizeHandlerId){this._iResizeHandlerId=R.register(this,this._onResize);}};
n.prototype._deregisterResizeHandler=function(){if(this._iResizeHandlerId){R.deregister(this._iResizeHandlerId);this._iResizeHandlerId=null;}};
n.prototype._registerTokenizerResizeHandler=function(){if(!this._iTokenizerResizeHandler){this._iTokenizerResizeHandler=R.register(this.getAggregation("tokenizer"),this._onResize);}};
n.prototype._deregisterTokenizerResizeHandler=function(){if(this._iTokenizerResizeHandler){R.deregister(this._iTokenizerResizeHandler);this._iTokenizerResizeHandler=null;}};
n.prototype._onResize=function(){this.getAggregation("tokenizer").setMaxWidth(this._calculateSpaceForTokenizer());};
n.prototype._onSuggestionItemSelected=function(e){var t=this.getAggregation("tokenizer"),i=null,o=null,O=t.getTokens().length;if(this.getMaxTokens()&&O>=this.getMaxTokens()||this._bValueHelpOpen){return;}if(this._hasTabularSuggestions()){i=e.getParameter("selectedRow");}else{i=e.getParameter("selectedItem");if(i){o=new a({text:i.getText(),key:i.getKey()});}}if(i&&!this._bTokenIsAdded){var p=this.getValue();this.addValidateToken({text:p,token:o,suggestionObject:i,validationCallback:this._validationCallback.bind(this,O)});}if(this.isMobileDevice()){var N=t.getTokens().length;if(O<N){this.setValue("");}if(this._getSuggestionsList()instanceof sap.m.Table){this._getSuggestionsList().addStyleClass("sapMInputSuggestionTableHidden");}else{this._getSuggestionsList().destroyItems();}var s=this.getAggregation("tokenizer").getScrollDelegate();if(s){s.scrollTo(0,0,0);}this._getSuggestionsPopoverInstance()._oPopupInput.focus();}this._bTokenIsAdded=false;};
n.prototype._onValueHelpRequested=function(){this._bValueHelpOpen=true;};
n.prototype._onLiveChange=function(e){var C=this.getAggregation("tokenizer").getTokens().every(function(t){return t.getSelected();});if(!C){return;}this.removeAllTokens();};
n.prototype._setValueVisible=function(v){var V=v?"1":"0";this.$("inner").css("opacity",V);};
n.prototype.onmousedown=function(e){if(e.target==this.getDomRef('content')){e.preventDefault();e.stopPropagation();}};
n.prototype.openMultiLine=function(){};
n.prototype.closeMultiLine=function(){};
n.prototype.showItems=function(){I.prototype.showItems.apply(this,arguments);this._manageListsVisibility(false);};
n.prototype.onBeforeRendering=function(){var t=this.getAggregation("tokenizer");var o=t._getTokensList();I.prototype.onBeforeRendering.apply(this,arguments);this._hideTokensOverLimit();t.setEnabled(this.getEnabled());t._fillTokensList(o);};
n.prototype._hideTokensOverLimit=function(){if(!this.getMaxTokens()){return;}this.getTokens().forEach(function(t,i){if(i>=this.getMaxTokens()){return t.setVisible(false);}return t.setVisible(true);},this);};
n.prototype.onsapnext=function(e){var t=this.getAggregation("tokenizer");if(e.isMarked()){return;}var F=q(document.activeElement).control()[0];if(!F){return;}if(t===F||t.$().find(F.$()).length>0){t.scrollToEnd();this.$().find("input").trigger("focus");}};
n.prototype.onsapbackspace=function(e){var v=this.getValue();var i=this.getFocusDomRef()===document.activeElement;var t=this.getTokens();var o=t[t.length-1];if(v===""&&i&&o&&e.srcControl===this){var A=t.filter(function(p){return p.getSelected();}).length===t.length;if(A){return this._deleteTokens(t,{keyCode:K.BACKSPACE});}o.focus();e.preventDefault();}};
n.prototype.onsapdelete=function(e){if(!this.getEditable()){return;}if(this.getValue()&&!j(this.getFocusDomRef())){return;}if(e.isMarked("forwardFocusToParent")){this.focus();}};
n.prototype.onkeydown=function(e){var t=this.getAggregation("tokenizer");if(!this.getEnabled()){return;}if(e.which===K.TAB){t.selectAllTokens(false);}if((e.ctrlKey||e.metaKey)&&e.which===K.A&&t.getTokens().length>0){t.focus();t.selectAllTokens(true);e.preventDefault();}if((e.ctrlKey||e.metaKey)&&(e.which===K.C||e.which===K.INSERT)){t._copy();}if(((e.ctrlKey||e.metaKey)&&e.which===K.X)||(e.shiftKey&&e.which===K.DELETE)){if(this.getEditable()){t._cut();}else{t._copy();}}if((e.ctrlKey||e.metaKey)&&e.which===K.I&&t.getTokens().length){t._togglePopup(t.getTokensPopup());e.preventDefault();}};
n.prototype.onpaste=function(e){var o,i,s,A=[];if(this.getValueHelpOnly()){return;}if(window.clipboardData){o=window.clipboardData.getData("Text");}else{o=e.originalEvent.clipboardData.getData('text/plain');}s=o.split(/\r\n|\r|\n/g);if(s.length<=1){return;}setTimeout(function(){if(s){if(this.fireEvent("_validateOnPaste",{texts:s},true)){var p="";for(i=0;i<s.length;i++){if(s[i]){var t=this._convertTextToToken(s[i],true);if(this._addUniqueToken(t)){A.push(t);}else{p=s[i];}}}this.updateDomValue(p);if(A.length>0){this.fireTokenUpdate({addedTokens:A,removedTokens:[],type:T.TokenUpdateType.Added});this.fireTokenChange({addedTokens:A,removedTokens:[],type:T.TokenChangeType.TokensChanged});}}if(A.length){this.cancelPendingSuggest();}}}.bind(this),0);};
n.prototype._validationCallback=function(o,v){var N=this.getAggregation("tokenizer").getTokens().length;var s=this._getSuggestionsPopoverInstance();this._bIsValidating=false;if(v){this.setValue("");this._bTokenIsValidated=true;if(this.isMobileDevice()&&s&&s._oPopupInput&&(o<N)){s._oPopupInput.setValue("");}}};
n.prototype.onsapprevious=function(e){if(this._getIsSuggestionPopupOpen()){return;}if(this._$input.cursorPos()===0){if(e.srcControl===this){T.prototype.onsapprevious.apply(this.getAggregation("tokenizer"),arguments);}}if(e.keyCode===K.ARROW_UP){e.preventDefault();}};
n.prototype.onsaphome=function(e){if(!this.getFocusDomRef().selectionStart){T.prototype.onsaphome.apply(this.getAggregation("tokenizer"),arguments);}};
n.prototype.onsapend=function(e){if(e.isMarked("forwardFocusToParent")){this.focus();}};
n.prototype.onsapenter=function(e){if(I.prototype.onsapenter){I.prototype.onsapenter.apply(this,arguments);}var v=true,t=this.getAggregation("tokenizer");if(this._getIsSuggestionPopupOpen()){if(this._hasTabularSuggestions()){v=!this._oSuggestionTable.getSelectedItem();}else{v=!this._getSuggestionsList().getSelectedItem();}}if(v){this._validateCurrentText();}if(e&&e.setMarked&&this._bTokenIsValidated){e.setMarked();}if(!this.getEditable()&&t.getHiddenTokensCount()&&e.target===this.getFocusDomRef()){t._togglePopup(t.getTokensPopup());}this.focus();};
n.prototype.onsapfocusleave=function(e){var p=this._getSuggestionsPopoverPopup(),t=this.getAggregation("tokenizer"),s=t.getTokensPopup(),N=false,i=false,o=this.getDomRef()&&h(this.getDomRef(),document.activeElement),u,F;if(p&&p.isA("sap.m.Popover")){if(e.relatedControlId){u=sap.ui.getCore().byId(e.relatedControlId).getFocusDomRef();N=h(p.getFocusDomRef(),u);i=h(t.getFocusDomRef(),u);if(s){F=h(s.getFocusDomRef(),u);}}}I.prototype.onsapfocusleave.apply(this,arguments);if(this._bIsValidating||this._bValueHelpOpen){return;}if(!this.isMobileDevice()&&!N&&e.relatedControlId!==this.getId()&&!i){this._validateCurrentText(true);}if(!this.isMobileDevice()&&this.getEditable()){if(o||N){return;}}if(!F&&!i){s.isOpen()&&!this.isMobileDevice()&&t._togglePopup(s);t.setRenderMode(m.Narrow);}this._handleInnerVisibility();};
n.prototype.ontap=function(e){var t=this.getAggregation("tokenizer");if(document.activeElement===this._$input[0]||document.activeElement===t.getDomRef()){t.selectAllTokens(false);}if(e&&e.isMarked("tokenDeletePress")){return;}I.prototype.ontap.apply(this,arguments);};
n.prototype.onfocusin=function(e){var t=this.getAggregation("tokenizer");this._deregisterTokenizerResizeHandler();this._bValueHelpOpen=false;if(e.target===this.getFocusDomRef()){I.prototype.onfocusin.apply(this,arguments);if(t.hasOneTruncatedToken()){t.getTokens()[0].setSelected(false);!this.isMobileDevice()&&t.setFirstTokenTruncated(false);}}if(!this.isMobileDevice()&&this.getEditable()&&e.target===this.getDomRef("inner")&&!(this._getIsSuggestionPopupOpen())){t.setRenderMode(m.Loose);this._setValueVisible(true);}this._registerResizeHandler();};
n.prototype.onsapescape=function(e){var t=this.getAggregation("tokenizer"),p=t.getTokensPopup();this.getAggregation("tokenizer").selectAllTokens(false);this.selectText(0,0);if(p.isOpen()){t._togglePopup(p);}I.prototype.onsapescape.apply(this,arguments);};
n.prototype._getIsSuggestionPopupOpen=function(){var s=this._getSuggestionsPopoverInstance(),o=this._getSuggestionsPopoverPopup();return s&&o&&o.isOpen();};
n.prototype.setEditable=function(e){var t=this.getAggregation("tokenizer");e=this.validateProperty("editable",e);if(e===this.getEditable()){return this;}if(I.prototype.setEditable){I.prototype.setEditable.apply(this,arguments);}t.setEditable(e);return this;};
n.prototype._findItem=function(t,e,o,G){if(!t){return;}if(!(e&&e.length)){return;}t=t.toLowerCase();var p=e.length;for(var i=0;i<p;i++){var s=e[i];var u=G(s);if(!u){continue;}u=u.toLowerCase();if(u===t){return s;}if(!o&&u.indexOf(t)===0){return s;}}};
n.prototype._getSuggestionItem=function(t,e){var o=null;var p=null;if(this._hasTabularSuggestions()){o=this.getSuggestionRows();p=this._findItem(t,o,e,function(s){var u=s.getCells();var v=null;if(u){var i;for(i=0;i<u.length;i++){if(u[i].getText){v=u[i].getText();break;}}}return v;});}else{o=this.getSuggestionItems();p=this._findItem(t,o,e,function(p){return p.getText();});}return p;};
n.prototype.clone=function(){var C;this.detachSuggestionItemSelected(this._onSuggestionItemSelected,this);this.detachLiveChange(this._onLiveChange,this);this.detachValueHelpRequest(this._onValueHelpRequested,this);C=I.prototype.clone.apply(this,arguments);this.attachSuggestionItemSelected(this._onSuggestionItemSelected,this);this.attachLiveChange(this._onLiveChange,this);this.attachValueHelpRequest(this._onValueHelpRequested,this);return C;};
n.getMetadata().forwardAggregation("tokens",{getter:function(){return this.getAggregation("tokenizer");},aggregation:"tokens",forwardBinding:true});
n.prototype.getPopupAnchorDomRef=function(){return this.getDomRef("content");};
n.prototype.setTokens=function(t){if(!Array.isArray(t)){return;}this.removeAllTokens();t.forEach(function(o){M.addAPIParentInfoBegin(o,this,"tokens");},this);t.forEach(function(o){this.addToken(o);},this);t.forEach(function(o){M.addAPIParentInfoEnd(o);},this);this.fireTokenChange({type:sap.m.Tokenizer.TokenChangeType.TokensChanged,addedTokens:t,removedTokens:[]});return this;};
n.TokenChangeType={Added:"added",Removed:"removed",RemovedAll:"removedAll",TokensChanged:"tokensChanged"};n.WaitForAsyncValidation="sap.m.MultiInput.WaitForAsyncValidation";n.prototype.getDomRefForValueStateMessage=n.prototype.getPopupAnchorDomRef;
n.prototype.updateInputField=function(N){I.prototype.updateInputField.call(this,N);var s=this._getSuggestionsPopoverInstance();this.setDOMValue('');if(s._oPopupInput){s._oPopupInput.setDOMValue('');}};
n.prototype.onChange=function(e,p,N){p=p||this.getChangeEventParams();if(!this.getEditable()||!this.getEnabled()){return;}var v=this._getInputValue(N);if(v===this.getLastValue()){this._bCheckDomValue=false;return;}if(!this._bTokenIsValidated){this.setValue(v);v=this.getValue();this.setLastValue(v);}this.fireChangeEvent(v,p);return true;};
n.prototype.getAccessibilityInfo=function(){var t=this.getTokens().map(function(o){return o.getText();}).join(" ");var i=I.prototype.getAccessibilityInfo.apply(this,arguments);i.type=r.getText("ACC_CTR_TYPE_MULTIINPUT");i.description=((i.description||"")+" "+t).trim();return i;};
n.prototype._modifyPopupInput=function(p){var t=this;p.addEventDelegate({oninput:t._manageListsVisibility.bind(t,false),onsapenter:function(e){if(p.getValue()){t._closeSuggestionPopup();}t._validateCurrentText();t._setValueVisible(false);t.onChange(e,null,p.getValue());}});return p;};
n.prototype._hasShowSelectedButton=function(){return true;};
n.prototype.forwardEventHandlersToSuggPopover=function(s){I.prototype.forwardEventHandlersToSuggPopover.apply(this,arguments);s.setShowSelectedPressHandler(this._handleShowSelectedPress.bind(this));};
n.prototype._handleShowSelectedPress=function(e){this._bShowListWithTokens=e.getSource().getPressed();this._manageListsVisibility(this._bShowListWithTokens);};
n.prototype._onBeforeOpenTokensPicker=function(){var t=this.getAggregation("tokenizer"),p=t.getTokensPopup(),o=this.getDomRef(),e=this.getEditable(),C,i;this._setValueVisible(false);this._manageListsVisibility(true);if(o&&p){C=parseInt(p.getContentWidth());i=o.offsetWidth>C?o.offsetWidth:C;i=((t.getTokens().length===1)||!e)?"auto":(i/parseFloat(l.BaseFontSize))+"rem";p.setContentWidth(i);}};
n.prototype._onAfterCloseTokensPicker=function(){if(document.activeElement!==this.getDomRef("inner")){this.getAggregation("tokenizer").setRenderMode(m.Narrow);}};
n.prototype.getDialogTitle=function(){var p=this._getSuggestionsPopoverPopup(),H=p&&p.getCustomHeader();if(H){return H.getContentMiddle()[0];}return null;};
n.prototype._updatePickerHeaderTitle=function(){var o,e;e=this.getLabels();if(e.length){o=e[0];if(o&&(typeof o.getText==="function")){this.getDialogTitle().setText(o.getText());}}else{this.getDialogTitle().setText(r.getText("COMBOBOX_PICKER_TITLE"));}};
n.prototype._getSuggestionsList=function(){var s=this._getSuggestionsPopoverInstance();return s&&s._oList;};
n.prototype._getSuggestionsPopoverInstance=function(){return this._oSuggPopover;};
n.prototype._getSuggestionsPopoverPopup=function(){return this._oSuggestionPopup;};
n.prototype._manageListsVisibility=function(s){if(!this.isMobileDevice()){return;}this.getAggregation("tokenizer")._getTokensList().setVisible(s);this._getSuggestionsList()&&this._getSuggestionsList().setVisible(!s);this._getSuggestionsPopover().getFilterSelectedButton().setPressed(s);};
n.prototype._handleNMoreAccessibility=function(){var i=k.getStaticId("sap.m","MULTICOMBOBOX_OPEN_NMORE_POPOVER"),F=this.getFocusDomRef(),A=(F&&F.getAttribute("aria-labelledby")),e=A?A.split(" "):[],N=e.indexOf(i),o=this.getEnabled(),p=!this.getEditable()&&this.getAggregation("tokenizer").getHiddenTokensCount();if(p&&N===-1){e.push(i);o&&this.getFocusDomRef().setAttribute("aria-keyshortcuts","Enter");}else if(N!==-1&&!p){e.splice(N,1);this.getFocusDomRef().removeAttribute("aria-keyshortcuts");}if(F&&e.length){F.setAttribute("aria-labelledby",e.join(" ").trim());}};
n.prototype._calculateSpaceForTokenizer=function(){var o=this.getDomRef();if(o){var s,e=this.$().find(".sapMInputDescriptionWrapper"),i=this.$().find(".sapMInputBaseInner"),C=o.offsetWidth||0,p=e.width()||0,t=this._calculateIconsSpace(),u=["min-width","padding-right","padding-left"],v=u.reduce(function(A,w){return A+(parseInt(i.css(w))||0);},0);s=C-(t+v+p);s=s<0?0:s;return s+"px";}else{return null;}};
n.prototype._syncInputWidth=function(t){var F=this.getDomRef('inner'),s,i;if(!F||(t&&!t.getDomRef())){return;}s=this._calculateIconsSpace();i=Math.ceil(t.getDomRef().getBoundingClientRect().width);F.style.width='calc(100% - '+Math.floor(s+i)+"px";};
n.prototype.isValueHelpOnlyOpener=function(t){return[this._$input[0],this._getValueHelpIcon().getDomRef()].indexOf(t)>-1;};
n.prototype._shouldTriggerSuggest=function(){var s=I.prototype._shouldTriggerSuggest.apply(this,arguments);return s&&!this._bShowListWithTokens;};
n.prototype.addValidator=function(v){if(typeof(v)==="function"){this._aTokenValidators.push(v);}};
n.prototype.removeValidator=function(v){var i=this._aTokenValidators.indexOf(v);if(i!==-1){this._aTokenValidators.splice(i,1);}};
n.prototype.removeAllValidators=function(){this._aTokenValidators=[];};
n.prototype.getValidators=function(){return this._aTokenValidators;};
n.prototype.addValidateToken=function(p,v){var t=this._validateToken(p,v),A=this._addUniqueToken(t,p.validationCallback);if(A){this.fireTokenUpdate({addedTokens:[t],removedTokens:[],type:T.TokenUpdateType.Added});this.fireTokenChange({addedTokens:[t],removedTokens:[],type:T.TokenChangeType.TokensChanged});}};
n.prototype._validateToken=function(p,v){var t=p.token,V=p.validationCallback,s=p.suggestionObject,e=t&&t.getText(),o=e?e:p.text,u;v=v?v:this._aTokenValidators;u=v.length;if(!u){if(!t&&V){V(false);}return t;}for(var i=0;i<u;i++){t=v[i]({text:o,suggestedToken:t,suggestionObject:s,asyncCallback:this._getAsyncValidationCallback(v,i,o,s,V)});if(!t){if(V){V(false);}return null;}if(t===n.WaitForAsyncValidation){return null;}}return t;};
n.prototype._addUniqueToken=function(t,v){if(!t){return false;}var e=!this._tokenExists(t);e&&this.addToken(t);if(v){v(e);}return e;};
n.prototype._tokenExists=function(t){var o=this.getTokens(),e=o.length,s=t&&t.getKey();if(!s){return false;}for(var i=0;i<e;i++){if(o[i].getKey()===s){return true;}}return false;};
n.prototype._convertTextToToken=function(t,C){var o=this.getAggregation("tokenizer"),O=o.getTokens().length,e=this._configureTokenOptions(t,false,C),v=e.text,i=e.item,p=e.token;if(!v){return null;}return this._validateToken({text:v,token:p,suggestionObject:i,validationCallback:this._validationCallback.bind(this,O)});};
n.prototype._validateCurrentText=function(e){var t=this.getAggregation("tokenizer"),o=t.getTokens().length,O=this._configureTokenOptions(this.getValue(),e),v=O.text,i=O.item,p=O.token;if(!v){return null;}if(i){this._bTokenIsAdded=true;}if(!this.getMaxTokens()||this.getTokens().length<this.getMaxTokens()){this._bIsValidating=true;this.addValidateToken({text:v,token:p,suggestionObject:i,validationCallback:this._validationCallback.bind(this,o)});}};
n.prototype._configureTokenOptions=function(v,e,p){var i,t;if(v&&this.getEditable()){v=v.trim();}if(v&&(e||p||this._getIsSuggestionPopupOpen())){if(this._hasTabularSuggestions()){i=this._oSuggestionTable.getSelectedItem();}else{i=this._getSuggestionItem(v,e);}}if(i&&i.getText&&i.getKey){t=new a({text:i.getText(),key:i.getKey()});}return{text:v,item:i,token:t};};
n.prototype._getAsyncValidationCallback=function(v,V,i,s,e){var t=this;return function(o){if(o){o=t.addValidateToken({text:i,token:o,suggestionObject:s,validationCallback:e},v.slice(V+1));}else{e&&e(false);}};};
return n;});
sap.ui.predefine('sap/m/MultiInputRenderer',['./InputRenderer','sap/ui/core/Renderer',"sap/ui/core/Core"],function(I,R,C){"use strict";var M=R.extend(I);M.apiVersion=2;
M.prependInnerContent=function(r,c){r.renderControl(c.getAggregation("tokenizer"));};
M.addOuterClasses=function(r,c){I.addOuterClasses.apply(this,arguments);r.class("sapMMultiInput");if(c.getTokens().length>0){r.class("sapMMultiInputHasTokens");}};
M.getAriaDescribedBy=function(c){var a=I.getAriaDescribedBy.apply(this,arguments),i=c.getAggregation("tokenizer")&&c.getAggregation("tokenizer").getTokensInfoId();if(a){a=a+" "+i;}else{a=i;}return a;};
M.getAccessibilityState=function(c){var a=I.getAccessibilityState.apply(this,arguments),r=C.getLibraryResourceBundle("sap.m");a.roledescription=r.getText("MULTIINPUT_ARIA_ROLE_DESCRIPTION");return a;};
return M;},true);
sap.ui.predefine('sap/m/NavContainer',['./library','sap/ui/core/Control','sap/ui/core/RenderManager','sap/ui/Device','./NavContainerRenderer',"sap/ui/thirdparty/jquery","sap/base/Log","sap/ui/dom/jquery/Focusable"],function(a,C,R,D,N,q,L){"use strict";
var b=C.extend("sap.m.NavContainer",{metadata:{library:"sap.m",properties:{autoFocus:{type:"boolean",group:"Behavior",defaultValue:true},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},visible:{type:"boolean",group:"Appearance",defaultValue:true},defaultTransitionName:{type:"string",group:"Appearance",defaultValue:"slide"}},defaultAggregation:"pages",aggregations:{pages:{type:"sap.ui.core.Control",multiple:true,singularName:"page"}},associations:{initialPage:{type:"sap.ui.core.Control",multiple:false}},events:{navigate:{allowPreventDefault:true,parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},afterNavigate:{parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}}}}});
var u=sap.ui.getCore().getConfiguration().getAnimation(),g=function(d){return u?d:0;},h=function(c){return!!(c&&c.getParent());},s=function(p,d){if(h(p)){p.$().css({'-webkit-animation-direction':d,'animation-direction':d});}};b.TransitionDirection={BACK:"back",TO:"to"};
b.prototype.init=function(){this._pageStack=[];this._aQueue=[];this._mVisitedPages={};this._mFocusObject={};this._iTransitionsCompleted=0;this._bNeverRendered=true;this._bNavigating=false;this._bRenderingInProgress=false;};
b.prototype.exit=function(){this._mFocusObject=null;};
b.prototype.onBeforeRendering=function(){var p=this.getCurrentPage();if(this._bNeverRendered&&p){var c=p.getId();if(!this._mVisitedPages[c]){this._mVisitedPages[c]=true;var n={from:null,fromId:null,to:p,toId:c,firstTime:true,isTo:false,isBack:false,isBackToPage:false,isBackToTop:false,direction:"initial"};var e=q.Event("BeforeFirstShow",n);e.srcControl=this;e.data=this._oToDataBeforeRendering||{};e.backData={};p._handleEvent(e);e=q.Event("BeforeShow",n);e.srcControl=this;e.data=this._oToDataBeforeRendering||{};e.backData={};p._handleEvent(e);}}};
b.prototype.onAfterRendering=function(){var p=this.getCurrentPage(),f,n,c,e;if(this._bNeverRendered&&p){this._bNeverRendered=false;delete this._bNeverRendered;c=p.getId();if(!this._isInsideAPopup()&&this.getAutoFocus()){f=b._applyAutoFocusTo(c);if(f){this._mFocusObject[c]=f;}}n={from:null,fromId:null,to:p,toId:c,firstTime:true,isTo:false,isBack:false,isBackToTop:false,isBackToPage:false,direction:"initial"};e=q.Event("AfterShow",n);e.srcControl=this;e.data=this._oToDataBeforeRendering||{};e.backData={};p._handleEvent(e);}};
b.prototype._getActualInitialPage=function(){var p=this.getInitialPage();if(p){var c=sap.ui.getCore().byId(p);if(c){return c;}else{L.error("NavContainer: control with ID '"+p+"' was set as 'initialPage' but was not found as a DIRECT child of this NavContainer (number of current children: "+this.getPages().length+").");}}var d=this.getPages();return(d.length>0?d[0]:null);};
b.prototype.getPage=function(p){var P=this.getPages();for(var i=0;i<P.length;i++){if(P[i]&&(P[i].getId()==p)){return P[i];}}return null;};
b.prototype._ensurePageStackInitialized=function(d){if(this._pageStack.length===0){var p=this._getActualInitialPage();if(p){this._pageStack.push({id:p.getId(),isInitial:true,data:d||{}});}}return this._pageStack;};
b.prototype.getCurrentPage=function(){var c=this._ensurePageStackInitialized();if(c.length>=1){return this.getPage(c[c.length-1].id);}else{L.warning(this+": page stack is empty but should have been initialized - application failed to provide a page to display");return undefined;}};
b.prototype.getPreviousPage=function(){var c=this._ensurePageStackInitialized();if(c.length>1){return this.getPage(c[c.length-2].id);}else if(c.length==1){return undefined;}else{L.warning(this+": page stack is empty but should have been initialized - application failed to provide a page to display");}};
b.prototype.currentPageIsTopPage=function(){var c=this._ensurePageStackInitialized();return(c.length===1);};
b.prototype.insertPreviousPage=function(p,t,d){var c=this._ensurePageStackInitialized();if(this._pageStack.length>0){var i=c.length-1;var e={id:p,transition:t,data:d};if(i===0){e.isInitial=true;delete c[c.length-1].isInitial;}c.splice(i,0,e);}else{L.warning(this+": insertPreviousPage called with empty page stack; ignoring");}return this;};
b._applyAutoFocusTo=function(i){var f=q(document.getElementById(i)).firstFocusableDomRef();if(f){f.focus();}return f;};
b.prototype._applyAutoFocus=function(n){var p=n.toId,d,c=n.isBack||n.isBackToPage||n.isBackToTop;if(!n.bFocusInsideFromPage){return;}if(c){d=this._mFocusObject!=null?this._mFocusObject[p]:null;if(d){d.focus();}else{b._applyAutoFocusTo(p);}}else if(n.isTo){b._applyAutoFocusTo(p);}};
b.prototype._afterTransitionCallback=function(n,d,B){var e=q.Event("AfterShow",n);e.data=d||{};e.backData=B||{};e.srcControl=this;n.to._handleEvent(e);e=q.Event("AfterHide",n);e.srcControl=this;n.from._handleEvent(e);this._iTransitionsCompleted++;this._bNavigating=false;if(this.getAutoFocus()){this._applyAutoFocus(n);}this.fireAfterNavigate(n);L.info(this+": _afterTransitionCallback called, to: "+n.toId);if(n.to.hasStyleClass("sapMNavItemHidden")){L.warning(this.toString()+": target page '"+n.toId+"' still has CSS class 'sapMNavItemHidden' after transition. This should not be the case, please check the preceding log statements.");n.to.removeStyleClass("sapMNavItemHidden");}this._dequeueNavigation();};
b.prototype._dequeueNavigation=function(){var n=this._aQueue.shift();if(typeof n==="function"){n();}};
b.prototype._isInPageStack=function(p){return this._pageStack.some(function(P){return P.id===p;});};
b.prototype._safeBackToPage=function(p,t,d,T){var c;if(!this.getPage(p)){return this;}c=this.getCurrentPage();if(c&&c.getId()===p){return this;}if(this._isInPageStack(p)){return this.backToPage(p,d,T);}else{d=d||{};d.safeBackToPage=true;return this.to(p,t,d,T);}};
b.prototype._isFocusInControl=function(c){return q(document.activeElement).closest(c.$()).length>0;};
b.prototype.to=function(p,t,d,T,f){if(p instanceof C){p=p.getId();}if(typeof(t)!=="string"){T=d;d=t;}t=t||this.getDefaultTransitionName();T=T||{};d=d||{};var F={id:p,transition:t,data:d};this._ensurePageStackInitialized(d);if(this._bNavigating){L.info(this.toString()+": Cannot navigate to page "+p+" because another navigation is already in progress. - navigation will be executed after the previous one");this._aQueue.push(q.proxy(function(){this.to(p,t,d,T,true);},this));return this;}if(this._bNeverRendered){this._oToDataBeforeRendering=d;}var o=this.getCurrentPage();if(o&&(o.getId()===p)){L.warning(this.toString()+": Cannot navigate to page "+p+" because this is the current page.");if(f){this._dequeueNavigation();}if(this._pageStack.length===1){this._pageStack[0].transition=F.transition;}return this;}var c=this.getPage(p);if(c){if(!o){L.warning("Navigation triggered to page with ID '"+p+"', but the current page is not known/aggregated by "+this);return this;}var n={from:o,fromId:o.getId(),to:c,toId:p,firstTime:!this._mVisitedPages[p],isTo:true,isBack:false,isBackToTop:false,isBackToPage:false,direction:"to",bFocusInsideFromPage:this._isFocusInControl(o)};if(n.bFocusInsideFromPage){this._mFocusObject[o.getId()]=document.activeElement;}var e=this.fireNavigate(n);if(e){a.closeKeyboard();var E=q.Event("BeforeHide",n);E.srcControl=this;o._handleEvent(E);if(!this._mVisitedPages[p]){E=q.Event("BeforeFirstShow",n);E.srcControl=this;E.data=d||{};E.backData={};c._handleEvent(E);}E=q.Event("BeforeShow",n);E.srcControl=this;E.data=d||{};E.backData={};c._handleEvent(E);this._pageStack.push(F);L.info(this.toString()+": navigating to page '"+p+"': "+c.toString());this._mVisitedPages[p]=true;if(!this.getDomRef()){L.info("'Hidden' 'to' navigation in not-rendered NavContainer "+this.toString());if(this._bRenderingInProgress){setTimeout(this.invalidate.bind(this),0);}return this;}var i;if(!(i=c.getDomRef())||i.parentNode!=this.getDomRef()||R.isPreservedContent(i)){c.addStyleClass("sapMNavItemRendering");L.debug("Rendering 'to' page '"+c.toString()+"' for 'to' navigation");var r=sap.ui.getCore().createRenderManager();r.render(c,this.getDomRef());r.destroy();c.addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemRendering");}var j=b.transitions[t]||b.transitions["slide"];var k=this._iTransitionsCompleted;var l=this;window.setTimeout(function(){if(l&&(l._iTransitionsCompleted<k+1)){L.warning("Transition '"+t+"' 'to' was triggered five seconds ago, but has not yet invoked the end-of-transition callback.");}},g(5000));this._bNavigating=true;var m=(d.safeBackToPage||T.safeBackToPage)?"back":"to";this._cacheTransitionInfo(t,m);j[m].call(this,o,c,q.proxy(function(){this._afterTransitionCallback(n,d);},this),T);}else{L.info("Navigation to page with ID '"+p+"' has been aborted by the application");}}else{L.warning("Navigation triggered to page with ID '"+p+"', but this page is not known/aggregated by "+this);}return this;};
b.prototype.back=function(c,t){this._backTo("back",c,t);return this;};
b.prototype.backToPage=function(p,c,t){this._backTo("backToPage",c,t,p);return this;};
b.prototype.backToTop=function(c,t){this._backTo("backToTop",c,t);return this;};
b.prototype._backTo=function(t,c,T,r){if(this._bNavigating){L.warning(this.toString()+": Cannot navigate back because another navigation is already in progress. - navigation will be executed after the previous one");this._aQueue.push(q.proxy(function(){this._backTo(t,c,T,r);},this));return this;}if(this._pageStack.length<=1){if(this._pageStack.length===1&&!this._pageStack[0].isInitial){throw new Error("Initial page not found on the stack. How did this happen?");}this._aQueue=[];return this;}else{if(r instanceof C){r=r.getId();}var f=this._pageStack[this._pageStack.length-1];var d=f.transition;var F=this.getPage(f.id);var o;var e;if(t==="backToTop"){o=this._getActualInitialPage();e=null;}else if(t==="backToPage"){var i=this._findClosestPreviousPageInfo(r);if(!i){L.error(this.toString()+": Cannot navigate backToPage('"+r+"') because target page was not found among the previous pages.");return this;}o=sap.ui.getCore().byId(i.id);if(!o){L.error(this.toString()+": Cannot navigate backToPage('"+r+"') because target page does not exist anymore.");return this;}e=i.data;}else{o=this.getPreviousPage();e=this._pageStack[this._pageStack.length-2].data;}if(!o){L.error("NavContainer back navigation: target page is not defined or not aggregated by this NavContainer. Aborting navigation.");return;}var j=o.getId();c=c||{};T=T||{};var n={from:F,fromId:F.getId(),to:o,toId:j,firstTime:!this._mVisitedPages[j],isTo:false,isBack:(t==="back"),isBackToPage:(t==="backToPage"),isBackToTop:(t==="backToTop"),direction:t,bFocusInsideFromPage:this._isFocusInControl(F)};var k=this.fireNavigate(n);if(k){a.closeKeyboard();var E=q.Event("BeforeHide",n);E.srcControl=this;F._handleEvent(E);if(!this._mVisitedPages[j]){E=q.Event("BeforeFirstShow",n);E.srcControl=this;E.backData=c||{};E.data={};o._handleEvent(E);}E=q.Event("BeforeShow",n);E.srcControl=this;E.backData=c||{};E.data=e||{};o._handleEvent(E);this._pageStack.pop();L.info(this.toString()+": navigating back to page "+o.toString());this._mVisitedPages[j]=true;if(t==="backToTop"){this._pageStack=[];L.info(this.toString()+": navigating back to top");this.getCurrentPage();}else if(t==="backToPage"){var p=[],l;while(this._pageStack[this._pageStack.length-1].id!==r){l=this._pageStack.pop();p.push(l.id);}L.info(this.toString()+": navigating back to specific page "+o.toString()+" across the pages: "+p.join(", "));}if(!this.getDomRef()){L.info("'Hidden' back navigation in not-rendered NavContainer "+this.toString());return this;}var m=b.transitions[d]||b.transitions["slide"];var v=this._iTransitionsCompleted;var w=this;window.setTimeout(function(){if(w&&(w._iTransitionsCompleted<v+1)){L.warning("Transition '"+d+"' 'back' was triggered five seconds ago, but has not yet invoked the end-of-transition callback.");}},g(5000));this._bNavigating=true;var x;if(!(x=o.getDomRef())||x.parentNode!=this.getDomRef()||R.isPreservedContent(x)){o.addStyleClass("sapMNavItemRendering");L.debug("Rendering 'to' page '"+o.toString()+"' for back navigation");var y=sap.ui.getCore().createRenderManager();var z=this.$().children().index(F.getDomRef());y.renderControl(o);y.flush(this.getDomRef(),false,z);y.destroy();o.addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemRendering");}if(F.getId()===o.getId()){L.info("Transition is skipped when navigating back to the same page instance"+o.toString());this._afterTransitionCallback(n,e,c);return this;}this._cacheTransitionInfo(d,b.TransitionDirection.BACK);m.back.call(this,F,o,q.proxy(function(){this._afterTransitionCallback(n,e,c);},this),T);}}return this;};
b.prototype._findClosestPreviousPageInfo=function(r){for(var i=this._pageStack.length-2;i>=0;i--){var c=this._pageStack[i];if(c.id===r){return c;}}return null;};
b.prototype._cacheTransitionInfo=function(t,T){this._sTransitionName=t;this._sTransitionDirection=T;};
b.prototype._fadeTransition=function(f,t,c){this.oFromPage=f;this.oToPage=t;this.fCallback=c;this._fadeOutAnimation();};
b.prototype._fadeOutAnimation=function(){var t=this,f=this.oFromPage,T=this.oToPage;T.addStyleClass("sapMNavItemTransparent");if(this._sTransitionName==="slide"){if(this._sTransitionDirection===b.TransitionDirection.TO){T.addStyleClass("sapMNavItemSlideLeft");f.addStyleClass("sapMNavItemSlideRight");}else{T.addStyleClass("sapMNavItemSlideRight");f.addStyleClass("sapMNavItemSlideLeft");}}T.removeStyleClass("sapMNavItemHidden");f.addStyleClass("sapMNavItemOpaque");window.setTimeout(function(){f.$().on("webkitTransitionEnd transitionend",t._fadeOutAnimationEnd.bind(t));t.bTransition1EndPending=true;f.addStyleClass("sapMNavItemFading").removeStyleClass("sapMNavItemOpaque").addStyleClass("sapMNavItemTransparent");window.setTimeout(function(){if(t.bTransition1EndPending){t._fadeOutAnimationEnd();}},g(150));},g(10));};
b.prototype._fadeOutAnimationEnd=function(e){var f=this.oFromPage;if(e&&e.originalEvent&&e.originalEvent.propertyName!=="opacity"){return;}this.bTransition1EndPending=false;q(f.$()).off("webkitTransitionEnd transitionend");f.removeStyleClass("sapMNavItemSlideLeft").removeStyleClass("sapMNavItemSlideRight");this._fadeInAnimation();};
b.prototype._fadeInAnimation=function(){var t=this,T=this.oToPage;window.setTimeout(function(){T.$().on("webkitTransitionEnd transitionend",t._fadeInAnimationEnd.bind(t));t.bTransition2EndPending=true;T.addStyleClass("sapMNavItemFading").removeStyleClass("sapMNavItemTransparent").addStyleClass("sapMNavItemOpaque");window.setTimeout(function(){if(t.bTransition2EndPending){t._fadeInAnimationEnd();}},g(150));},g(10));};
b.prototype._fadeInAnimationEnd=function(e){var t=this.oToPage,f=this.oFromPage;if(e&&e.originalEvent&&e.originalEvent.propertyName!=="opacity"){return;}this.bTransition2EndPending=false;if(h(f)){f.addStyleClass("sapMNavItemHidden");f.removeStyleClass("sapMNavItemFading").removeStyleClass("sapMNavItemTransparent");}q(t.$()).off("webkitTransitionEnd transitionend");if(h(t)){t.removeStyleClass("sapMNavItemFading").removeStyleClass("sapMNavItemOpaque").removeStyleClass("sapMNavItemSlideLeft").removeStyleClass("sapMNavItemSlideRight");}this.fCallback();};
b.prototype._baseSlideAnimation=function(f,t,c){var F=false,T=true,i=this._sTransitionDirection===b.TransitionDirection.BACK,A=i?"reverse":"normal",d=i?"sapMNavItemSlideCenterToLeft":"sapMNavItemSlideRightToCenter",e=!i?"sapMNavItemSlideCenterToLeft":"sapMNavItemSlideRightToCenter",j=function(){q(this).off("webkitAnimationEnd animationend");if(!F){return(F=true);}T=false;s(t,"");s(f,"");if(h(t)){t.removeStyleClass(d);}if(h(f)){f.removeStyleClass(e).addStyleClass("sapMNavItemHidden");}c();};f.$().on("webkitAnimationEnd animationend",j);t.$().on("webkitAnimationEnd animationend",j);s(t,A);s(f,A);f.addStyleClass(e);t.addStyleClass(d).removeStyleClass("sapMNavItemHidden");window.setTimeout(function(){if(T){F=true;j.apply(f.$().add(t.$()));}},g(400));};
b.transitions=b.transitions||{};b.transitions["show"]={to:function(f,t,c){t.removeStyleClass("sapMNavItemHidden");f&&f.addStyleClass("sapMNavItemHidden");c();},back:function(f,t,c){t.removeStyleClass("sapMNavItemHidden");f&&f.addStyleClass("sapMNavItemHidden");c();}};b.transitions["baseSlide"]={to:b.prototype._baseSlideAnimation,back:b.prototype._baseSlideAnimation};b.transitions["slide"]={to:b.prototype._fadeTransition,back:b.prototype._fadeTransition};b.transitions["fade"]={to:b.prototype._fadeTransition,back:b.prototype._fadeTransition};b.transitions["flip"]={to:function(f,t,c){var d=this;window.setTimeout(function(){d.$().addClass("sapMNavFlip");t.addStyleClass("sapMNavItemFlipNext");t.removeStyleClass("sapMNavItemHidden");window.setTimeout(function(){var o=false;var T=true;var A=null;A=function(){q(this).off("webkitTransitionEnd transitionend");if(!o){o=true;}else{T=false;if(h(t)){t.removeStyleClass("sapMNavItemFlipping");}if(h(f)){f.removeStyleClass("sapMNavItemFlipping").addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemFlipPrevious");}d.$().removeClass("sapMNavFlip");c();}};f.$().on("webkitTransitionEnd transitionend",A);t.$().on("webkitTransitionEnd transitionend",A);t.addStyleClass("sapMNavItemFlipping").removeStyleClass("sapMNavItemFlipNext");f.addStyleClass("sapMNavItemFlipping").addStyleClass("sapMNavItemFlipPrevious");window.setTimeout(function(){if(T){o=true;A.apply(f.$().add(t.$()));}},g(600));},g(60));},0);},back:function(f,t,c){var d=this;d.$().addClass("sapMNavFlip");t.addStyleClass("sapMNavItemFlipPrevious");t.removeStyleClass("sapMNavItemHidden");window.setTimeout(function(){var o=false;var T=true;var A=null;A=function(){q(this).off("webkitTransitionEnd transitionend");if(!o){o=true;}else{T=false;if(h(t)){t.removeStyleClass("sapMNavItemFlipping");}if(h(f)){f.removeStyleClass("sapMNavItemFlipping").addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemFlipNext");}d.$().removeClass("sapMNavFlip");c();}};f.$().on("webkitTransitionEnd transitionend",A);t.$().on("webkitTransitionEnd transitionend",A);t.addStyleClass("sapMNavItemFlipping").removeStyleClass("sapMNavItemFlipPrevious");f.addStyleClass("sapMNavItemFlipping").addStyleClass("sapMNavItemFlipNext");window.setTimeout(function(){if(T){o=true;A.apply(f.$().add(t.$()));}},g(600));},g(60));}};b.transitions["door"]={to:function(f,t,c){var d=this;window.setTimeout(function(){d.$().addClass("sapMNavDoor");t.addStyleClass("sapMNavItemDoorInNext");t.removeStyleClass("sapMNavItemHidden");window.setTimeout(function(){var o=false;var T=true;var A=null;A=function(){q(this).off("webkitAnimationEnd animationend");if(!o){o=true;}else{T=false;if(h(t)){t.removeStyleClass("sapMNavItemDooring").removeStyleClass("sapMNavItemDoorInNext");}if(h(f)){f.removeStyleClass("sapMNavItemDooring").addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemDoorInPrevious");}d.$().removeClass("sapMNavDoor");c();}};f.$().on("webkitAnimationEnd animationend",A);t.$().on("webkitAnimationEnd animationend",A);t.addStyleClass("sapMNavItemDooring");f.addStyleClass("sapMNavItemDooring").addStyleClass("sapMNavItemDoorInPrevious");window.setTimeout(function(){if(T){o=true;A.apply(f.$().add(t.$()));}},g(1000));},g(60));},0);},back:function(f,t,c){var d=this;d.$().addClass("sapMNavDoor");t.addStyleClass("sapMNavItemDoorOutNext");t.removeStyleClass("sapMNavItemHidden");window.setTimeout(function(){var o=false;var T=true;var A=null;A=function(){q(this).off("webkitAnimationEnd animationend");if(!o){o=true;}else{T=false;if(h(t)){t.removeStyleClass("sapMNavItemDooring").removeStyleClass("sapMNavItemDoorOutNext");}if(h(f)){f.removeStyleClass("sapMNavItemDooring").addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemDoorOutPrevious");}d.$().removeClass("sapMNavDoor");c();}};f.$().on("webkitAnimationEnd animationend",A);t.$().on("webkitAnimationEnd animationend",A);t.addStyleClass("sapMNavItemDooring");f.addStyleClass("sapMNavItemDooring").addStyleClass("sapMNavItemDoorOutPrevious");window.setTimeout(function(){if(T){o=true;A.apply(f.$().add(t.$()));}},g(1000));},g(60));}};
b.prototype.addCustomTransition=function(n,t,B){if(b.transitions[n]){L.warning("Transition with name "+n+" already exists in "+this+". It is now being replaced by custom transition.");}b.transitions[n]={to:t,back:B};return this;};
b.addCustomTransition=b.prototype.addCustomTransition;b.prototype.forceInvalidation=b.prototype.invalidate;
b.prototype.invalidate=function(S){if(S==this){}else if(!S){this.forceInvalidation();}else if(S instanceof C){var I=false,p=this.getPages(),l=p.length;for(var i=0;i<l;i++){if(p[i]===S){I=true;break;}}if((!I||S===this.getCurrentPage())&&!this._isInsideAPopup()){this.forceInvalidation();}}else{this.forceInvalidation();}};
b.prototype._isInsideAPopup=function(){var S;S=function(c){if(!c){return false;}if(c.getMetadata().isInstanceOf("sap.ui.core.PopupInterface")){return true;}return S(c.getParent());};return S(this);};
b.prototype.removePage=function(p){var P;if(typeof(p)=="number"){P=this.getPages()[p];}else if(typeof(p)=="string"){P=sap.ui.getCore().byId(p);}else{P=p;}P=this.removeAggregation("pages",P,P!==this.getCurrentPage());this._onPageRemoved(P);return P;};
b.prototype._onPageRemoved=function(p){if(!p){return;}p.$().remove();p.removeStyleClass("sapMNavItemHidden");p.removeStyleClass("sapMNavItem");var S=this._ensurePageStackInitialized();this._pageStack=S.filter(function(P){return p.getId()!==P.id;});};
b.prototype.removeAllPages=function(){var p=this.removeAllAggregation("pages");for(var i=0;i<p.length;i++){this._onPageRemoved(p[i]);}return p;};
b.prototype.addPage=function(p){var P=this.getPages();if(P.indexOf(p)>-1){return this;}this.addAggregation("pages",p,true);p.addStyleClass("sapMNavItem");var i=P.length;if(i===0&&this.getPages().length===1){this._fireAdaptableContentChange(p);if(this.getDomRef()){this._ensurePageStackInitialized();this.rerender();}}return this;};
b.prototype.insertPage=function(p,i){var P=this.getPages().length;this.insertAggregation("pages",p,i,true);p.addStyleClass("sapMNavItem");if(P===0&&this.getPages().length===1){this._fireAdaptableContentChange(p);if(this.getDomRef()){this._ensurePageStackInitialized();this.rerender();}}return this;};
b.prototype._getAdaptableContent=function(){return this.getCurrentPage();};
b.prototype._fireAdaptableContentChange=function(p){if(p&&this.mEventRegistry["_adaptableContentChange"]){this.fireEvent("_adaptableContentChange",{"parent":this,"adaptableContent":p});}};
return b;});
sap.ui.predefine('sap/m/NavContainerRenderer',["sap/ui/core/InvisibleRenderer"],function(I){"use strict";var N={apiVersion:2};
N.render=function(r,c){c._bRenderingInProgress=true;if(!c.getVisible()){I.render(r,c,"div");return false;}var h=c.getHeight(),t=c.getTooltip_AsString(),C=c.getCurrentPage();r.openStart("div",c);r.class("sapMNav");r.style("width",c.getWidth());if(h&&h!="100%"){r.style("height",h);}if(this.renderAttributes){this.renderAttributes(r,c);}if(t){r.attr("title",t);}r.openEnd();if(this.renderBeforeContent){this.renderBeforeContent(r,c);}c.getPages().forEach(function(p){if(p===C){C.removeStyleClass("sapMNavItemHidden");r.renderControl(C);}else{r.cleanupControlWithoutRendering(p);}});r.close("div");c._bRenderingInProgress=false;};
return N;},true);
sap.ui.predefine('sap/m/Page',["./library","sap/ui/core/Control","sap/ui/core/delegate/ScrollEnablement","sap/m/Title","sap/m/Button","sap/m/Bar",'sap/m/TitleAlignmentMixin',"sap/ui/core/ContextMenuSupport","sap/ui/core/util/ResponsivePaddingsEnablement","sap/ui/core/library","sap/ui/Device","sap/ui/core/Element","./TitlePropagationSupport","./PageRenderer","sap/ui/thirdparty/jquery"],function(l,C,S,T,B,a,b,c,R,d,D,E,e,P,q){"use strict";var A=d.AccessibleLandmarkRole;var f=l.ButtonType;var g=l.PageBackgroundDesign;var h=d.TitleLevel;var i=l.TitleAlignment;var j="div";var H="header";var F="footer";
var k=C.extend("sap.m.Page",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Data",defaultValue:null},titleLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:h.Auto},showNavButton:{type:"boolean",group:"Appearance",defaultValue:false},showHeader:{type:"boolean",group:"Appearance",defaultValue:true},showSubHeader:{type:"boolean",group:"Appearance",defaultValue:true},navButtonText:{type:"string",group:"Misc",defaultValue:null,deprecated:true},navButtonTooltip:{type:"string",group:"Misc",defaultValue:null},enableScrolling:{type:"boolean",group:"Behavior",defaultValue:true},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null,deprecated:true},backgroundDesign:{type:"sap.m.PageBackgroundDesign",group:"Appearance",defaultValue:g.Standard},navButtonType:{type:"sap.m.ButtonType",group:"Appearance",defaultValue:f.Back,deprecated:true},showFooter:{type:"boolean",group:"Appearance",defaultValue:true},contentOnlyBusy:{type:"boolean",group:"Appearance",defaultValue:false},floatingFooter:{type:"boolean",group:"Appearance",defaultValue:false},titleAlignment:{type:"sap.m.TitleAlignment",group:"Misc",defaultValue:i.Auto}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},customHeader:{type:"sap.m.IBar",multiple:false},footer:{type:"sap.m.IBar",multiple:false},subHeader:{type:"sap.m.IBar",multiple:false},headerContent:{type:"sap.ui.core.Control",multiple:true,singularName:"headerContent",forwarding:{getter:"_getInternalHeader",aggregation:"contentRight"}},landmarkInfo:{type:"sap.m.PageAccessibleLandmarkInfo",multiple:false},_internalHeader:{type:"sap.m.IBar",multiple:false,visibility:"hidden"}},events:{navButtonTap:{deprecated:true},navButtonPress:{}},dnd:{draggable:false,droppable:true},designtime:"sap/m/designtime/Page.designtime"}});
c.apply(k.prototype);R.call(k.prototype,{header:{suffix:"intHeader"},subHeader:{selector:".sapMPageSubHeader .sapMIBar"},content:{suffix:"cont"},footer:{selector:".sapMPageFooter:not(.sapMPageFloatingFooter) .sapMIBar"},floatingFooter:{selector:".sapMPageFloatingFooter.sapMPageFooter"}});e.call(k.prototype,"content",function(){return this._headerTitle?this._headerTitle.getId():false;});k.FOOTER_ANIMATION_DURATION=350;
k.prototype.init=function(){this._initTitlePropagationSupport();this._initResponsivePaddingsEnablement();};
k.prototype._hasScrolling=function(){return this.getEnableScrolling();};
k.prototype.onBeforeRendering=function(){if(this._oScroller&&!this._hasScrolling()){this._oScroller.destroy();this._oScroller=null;}else if(this._hasScrolling()&&!this._oScroller){this._oScroller=new S(this,null,{scrollContainerId:this.getId()+"-cont",horizontal:false,vertical:true});}if(this._headerTitle){this._headerTitle.setLevel(this.getTitleLevel());}this._ensureNavButton();};
k.prototype.onAfterRendering=function(){this.$().toggleClass("sapMPageBusyCoversAll",!this.getContentOnlyBusy());this._sBusySection=this.getContentOnlyBusy()?'cont':null;};
k.prototype.exit=function(){if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}if(this._headerTitle){this._headerTitle.destroy();this._headerTitle=null;}if(this._navBtn){this._navBtn.destroy();this._navBtn=null;}if(this._appIcon){this._appIcon.destroy();this._appIcon=null;}};
k.prototype.setBackgroundDesign=function(s){var m=this.getBackgroundDesign();this.setProperty("backgroundDesign",s,true);this.$().removeClass("sapMPageBg"+m).addClass("sapMPageBg"+this.getBackgroundDesign());return this;};
k.prototype.setTitle=function(t){var w=!this._headerTitle;this._headerTitle=this._headerTitle||new T(this.getId()+"-title",{level:this.getTitleLevel()});this._headerTitle.setText(t);if(w){this._updateHeaderContent(this._headerTitle,"middle",0);}this.setProperty("title",t,true);return this;};
k.prototype._ensureNavButton=function(){if(!this.getShowNavButton()){return;}var s=this.getNavButtonTooltip()||sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("PAGE_NAVBUTTON_TEXT");if(!this._navBtn){this._navBtn=new B(this.getId()+"-navButton",{press:function(){this.fireNavButtonPress();this.fireNavButtonTap();}.bind(this)});}this._navBtn.setType(this.getNavButtonType());this._navBtn.setTooltip(s);};
k.prototype.setShowNavButton=function(s){var o=!!this.getShowNavButton();if(s===o){return this;}this.setProperty("showNavButton",s,true);if(s){this._ensureNavButton();if(this._appIcon){this._updateHeaderContent(this._appIcon,"left",-1);}this._updateHeaderContent(this._navBtn,"left",0);}else if(this._navBtn){this._updateHeaderContent(this._navBtn,"left",-1);}return this;};
k.prototype.setShowFooter=function(s){if(this.getDomRef()){(s)?this.$().addClass("sapMPageWithFooter"):this.$().removeClass("sapMPageWithFooter");}var $=q(this.getDomRef()).find(".sapMPageFooter").last(),u=sap.ui.getCore().getConfiguration().getAnimation();if(!this.getFloatingFooter()){this.setProperty("showFooter",s);return this;}this.setProperty("showFooter",s,true);$.removeClass("sapUiHidden");$.toggleClass("sapMPageFooterControlShow",s);$.toggleClass("sapMPageFooterControlHide",!s);if(s){return this;}if(u){setTimeout(function(){$.toggleClass("sapUiHidden",!s);},k.FOOTER_ANIMATION_DURATION);}else{$.toggleClass("sapUiHidden",!s);}return this;};
k.prototype._updateHeaderContent=function(o,s,m){var I=this._getInternalHeader();if(I){switch(s){case"left":if(m==-1){if(I.getContentLeft()){I.removeContentLeft(o);}}else{if(I.indexOfContentLeft(o)!=m){I.insertContentLeft(o,m);I.invalidate();}}break;case"middle":if(m==-1){if(I.getContentMiddle()){I.removeContentMiddle(o);}}else{if(I.indexOfContentMiddle(o)!=m){I.insertContentMiddle(o,m);I.invalidate();}}break;case"right":if(m==-1){if(I.getContentRight()){I.removeContentRight(o);}}else{if(I.indexOfContentRight(o)!=m){I.insertContentRight(o,m);I.invalidate();}}break;default:break;}}};
k.prototype._getInternalHeader=function(){var I=this.getAggregation("_internalHeader");if(!I){this.setAggregation("_internalHeader",new a(this.getId()+"-intHeader"),true);I=this.getAggregation("_internalHeader");this._setupBarTitleAlignment(I,this.getId()+"_internalHeader");if(this.getShowNavButton()&&this._navBtn){this._updateHeaderContent(this._navBtn,"left",0);}if(this.getTitle()&&this._headerTitle){this._updateHeaderContent(this._headerTitle,"middle",0);}}return I;};
k.prototype._getAnyHeader=function(){var o=this.getCustomHeader();if(o){return o.addStyleClass("sapMPageHeader");}return this._getInternalHeader().addStyleClass("sapMPageHeader");};
k.prototype.getScrollDelegate=function(){return this._oScroller;};
k.prototype._formatLandmarkInfo=function(L,p){if(L){var r=L["get"+p+"Role"]()||"",s=L["get"+p+"Label"]()||"";if(r===A.None){r='';}return{role:r.toLowerCase(),label:s};}return{};};
k.prototype._getHeaderTag=function(L){if(L&&L.getHeaderRole()!==A.None){return j;}return H;};
k.prototype._getSubHeaderTag=function(L){if(L&&L.getSubHeaderRole()!==A.None){return j;}return H;};
k.prototype._getFooterTag=function(L){if(L&&L.getFooterRole()!==A.None){return j;}return F;};
k.prototype.scrollTo=function(y,t){if(this._oScroller){this._oScroller.scrollTo(0,y,t);}return this;};
k.prototype.scrollToElement=function(o,t,O){if(o instanceof E){o=o.getDomRef();}if(this._oScroller){this._oScroller.scrollToElement(o,t,O);}return this;};
k.prototype.setCustomHeader=function(o){this.setAggregation("customHeader",o);this.toggleStyleClass("sapFShellBar-CTX",o&&o.isA("sap.f.ShellBar"));if(o&&this.mEventRegistry["_adaptableContentChange"]){this.fireEvent("_adaptableContentChange",{"parent":this,"adaptableContent":o});}return this;};
k.prototype._getAdaptableContent=function(){return this._getAnyHeader();};
b.mixInto(k.prototype);return k;});
sap.ui.predefine('sap/m/PageRenderer',["sap/m/library","sap/ui/Device"],function(a,D){"use strict";var P={apiVersion:2};
P.render=function(r,p){var h=null,f=p.getFooter(),s=p.getShowFooter(),S=null,l=this._isLightHeader(p),L=p.getLandmarkInfo();if(p.getShowHeader()){h=p._getAnyHeader();}if(p.getShowSubHeader()){S=p.getSubHeader();}r.openStart("div",p).class("sapMPage").class("sapMPageBg"+p.getBackgroundDesign());if(h){r.class("sapMPageWithHeader");}if(S){r.class("sapMPageWithSubHeader");}if(f&&s){r.class("sapMPageWithFooter");}if(!p.getContentOnlyBusy()){r.class("sapMPageBusyCoversAll");}if(p.getFloatingFooter()){r.class("sapMPageWithFloatingFooter");}r.accessibilityState(p,p._formatLandmarkInfo(L,"Root"));r.openEnd();if(h){this.renderHeader(r,p,h,L,l);}if(S){this.renderSubHeader(r,p,S,L,l);}this.renderChildControls(r,p,L);if(f){this.renderFooter(r,p,f,L);}r.close("div");};
P.renderBarControl=function(r,p,b,o){if(!b){return;}b._applyContextClassFor(o.context.toLowerCase());b.addStyleClass(o.styleClass||"");r.renderControl(b);};
P.renderHeader=function(r,p,h,l,L){var H=p._getHeaderTag(l);r.openStart(H).class("sapMPageHeader").accessibilityState(p,p._formatLandmarkInfo(l,"Header")).openEnd();this.renderBarControl(r,p,h,{context:"header",styleClass:L?"":"sapContrastPlus"});r.close(H);};
P.renderSubHeader=function(r,p,s,l,L){var S=p._getSubHeaderTag(l);r.openStart(S).class("sapMPageSubHeader").accessibilityState(p,p._formatLandmarkInfo(l,"SubHeader"));if(s.getDesign()==a.ToolbarDesign.Info){r.class("sapMPageSubHeaderInfoBar");}r.openEnd();this.renderBarControl(r,p,s,{context:"subHeader",styleClass:L?"":"sapContrastPlus"});r.close(S);};
P.renderChildControls=function(r,p,L){r.openStart("section",p.getId()+"-cont");r.accessibilityState(p,p._formatLandmarkInfo(L,"Content"));if(D.browser.firefox){r.attr("tabindex","-1");}if(p.getEnableScrolling()){r.class("sapMPageEnableScrolling");}r.openEnd();var c=p.getContent();var l=c.length;for(var i=0;i<l;i++){r.renderControl(c[i]);}r.close("section");};
P.renderFooter=function(r,p,f,l){var F=p._getFooterTag(l);r.openStart(F).class("sapMPageFooter");if(!p.getShowFooter()){r.class("sapUiHidden");}if(p.getFloatingFooter()){r.class("sapMPageFloatingFooter");}r.accessibilityState(p,p._formatLandmarkInfo(l,"Footer")).openEnd();this.renderBarControl(r,p,f,{context:"footer"});r.close(F);};
P._isLightHeader=function(p){var c=p,o=p.getParent(),s,C;while(o){s=(o&&o.getMetadata().getName())||"";C=c.getMetadata().getName();if(((s==="sap.m.Popover"||s==="sap.m.Dialog")&&C==="sap.m.NavContainer")||((s==="sap.ui.comp.smartvariants.SmartVariantManagement"||s==="sap.ui.comp.smartvariants.SmartVariantManagementUi2"||s==="sap.ui.comp.variants.VariantManagement"||s==="sap.ui.fl.variants.VariantManagement")&&C==="sap.m.ResponsivePopover")){return true;}if(o&&["sap.m.SplitApp","sap.m.SplitContainer"].indexOf(s)>-1&&C==="sap.m.NavContainer"&&/\-Master$/.test(c.getId())){return true;}c=o;o=c.getParent();}return false;};
return P;},true);
sap.ui.predefine('sap/m/ResponsivePopover',['./Dialog','./Popover','./library','./TitleAlignmentMixin','sap/ui/core/Control','sap/ui/core/IconPool','sap/ui/Device','./ResponsivePopoverRenderer','./Toolbar','./ToolbarSpacer','./Button',"sap/ui/thirdparty/jquery"],function(D,P,l,T,C,I,a,R,b,c,B,q){"use strict";var d=l.DialogType;var e=l.PlacementType;var f=l.TitleAlignment;
var g=C.extend("sap.m.ResponsivePopover",{metadata:{library:"sap.m",properties:{placement:{type:"sap.m.PlacementType",group:"Misc",defaultValue:e.Right},showHeader:{type:"boolean",group:"Misc",defaultValue:true},title:{type:"string",group:"Misc",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},modal:{type:"boolean",group:"Misc",defaultValue:null},offsetX:{type:"int",group:"Misc",defaultValue:null},offsetY:{type:"int",group:"Misc",defaultValue:null},showArrow:{type:"boolean",group:"Appearance",defaultValue:true},contentWidth:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},contentHeight:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},horizontalScrolling:{type:"boolean",group:"Misc",defaultValue:true},verticalScrolling:{type:"boolean",group:"Misc",defaultValue:true},showCloseButton:{type:"boolean",group:"Misc",defaultValue:true},resizable:{type:"boolean",group:"Dimension",defaultValue:false},titleAlignment:{type:"sap.m.TitleAlignment",group:"Misc",defaultValue:f.Auto}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},customHeader:{type:"sap.m.IBar",multiple:false},subHeader:{type:"sap.m.IBar",multiple:false},beginButton:{type:"sap.m.Button",multiple:false},endButton:{type:"sap.m.Button",multiple:false},_popup:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{initialFocus:{type:"sap.ui.core.Control",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"}},events:{beforeOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},afterOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},beforeClose:{parameters:{openBy:{type:"sap.ui.core.Control"},origin:{type:"sap.m.Button"}}},afterClose:{parameters:{openBy:{type:"sap.ui.core.Control"},origin:{type:"sap.m.Button"}}}}}});
g.prototype.init=function(){var t=this;this._bAppendedToUIArea=false;var s={resizable:t.getResizable(),titleAlignment:t.getTitleAlignment(),beforeOpen:function(E){t.fireBeforeOpen({openBy:E.getParameter('openBy')});},afterOpen:function(E){t.fireAfterOpen({openBy:E.getParameter('openBy')});},beforeClose:function(E){t.fireBeforeClose({openBy:E.getParameter('openBy'),origin:E.getParameter('origin')});},afterClose:function(E){t.fireAfterClose({openBy:E.getParameter('openBy'),origin:E.getParameter('origin')});}};if(a.system.phone){this._aNotSupportedProperties=["placement","modal","offsetX","offsetY","showCloseButton"];s.stretch=true;s.type=d.Standard;this._oControl=new D(this.getId()+"-dialog",s);}else{this._aNotSupportedProperties=["icon","showCloseButton"];this._oControl=new P(this.getId()+"-popover",s);}this.setAggregation("_popup",this._oControl);this._oControl.addStyleClass("sapMResponsivePopover");this._oDelegate={onBeforeRendering:function(){var S=this.getShowCloseButton(),h=this._oControl._getAnyHeader(),n,p,r;if(!S||!a.system.phone){this._removeCloseButton(h);return;}if(!this._bContentChanged){return;}this._bContentChanged=false;if(h){this._insertCloseButton(h);}else{n=this._getSingleNavContent();if(!n){return;}p=n.getCurrentPage();r=this._getRealPage(p);if(r&&(h=r._getAnyHeader())){this._insertCloseButton(h);}n.attachEvent("navigate",this._fnOnNavigate,this);}}};this._oPageDelegate={onAfterShow:function(){var r=t._getRealPage(this),h;if(r&&(h=r._getAnyHeader())){t._insertCloseButton(h);}}};this._fnOnNavigate=function(E){var p=E.getParameter("to");if(p){p.addEventDelegate(this._oPageDelegate,p);}};this._oControl.addEventDelegate(this._oDelegate,this);this._oControl._removeChild=function(o,A,S){var p,i;if((A==="content")&&(o instanceof sap.m.NavContainer)){p=o.getPages();for(i=0;i<p.length;i++){p[i].removeEventDelegate(t._oPageDelegate);}o.detachEvent("navigate",t._fnOnNavigate,t);}C.prototype._removeChild.apply(this,arguments);};};
g.prototype.openBy=function(p){if(!this._bAppendedToUIArea&&!this.getParent()){var s=sap.ui.getCore().getStaticAreaRef();s=sap.ui.getCore().getUIArea(s);s.addContent(this,true);this._bAppendedToUIArea=true;}if(a.system.phone){return this._oControl.open();}else{return this._oControl.openBy(p);}};
g.prototype.exit=function(){if(this._oCloseButton){this._oCloseButton.destroy();this._oCloseButton=null;}if(this._oControl){this._oControl.removeEventDelegate(this._oDelegate);this._oControl.destroy();this._oControl=null;}};
g.prototype._getCloseButton=function(){if(!this._oCloseButton){var t=this;this._oCloseButton=new B(this.getId()+"-closeButton",{icon:I.getIconURI("decline"),press:function(){t._oControl._oCloseTrigger=this;t.close();}});}return this._oCloseButton;};
g.prototype.addContent=function(o){this._bContentChanged=true;this.addAggregation("content",o);return this;};
g.prototype.clone=function(){var o=C.prototype.clone.apply(this,arguments),h=this.getAggregation('_popup').getContent();for(var i=0;i<h.length;i++){o.addContent(h[i].clone());}return o;};
g.prototype._getSingleNavContent=function(){var h=this.getContent();while(h.length===1&&h[0]instanceof sap.ui.core.mvc.View){h=h[0].getContent();}if(h.length===1&&h[0]instanceof sap.m.NavContainer){return h[0];}else{return null;}};
g.prototype._getRealPage=function(p){var r=p,h;while(r){if(r instanceof sap.m.Page){return r;}if(r instanceof sap.ui.core.mvc.View){h=r.getContent();if(h.length===1){r=h[0];continue;}}r=null;}return r;};
g.prototype._insertCloseButton=function(h){var o=this._getCloseButton(),i;if(h&&h.addContentRight){i=h.getAggregation("contentRight",[]).length;h.insertAggregation("contentRight",o,i);}};
g.prototype._removeCloseButton=function(h){var o=this._getCloseButton();if(h){h.removeAggregation("contentRight",o);}};
g.prototype._firstLetterUpperCase=function(v){return v.charAt(0).toUpperCase()+v.slice(1);};
g.prototype._lastIndexOfUpperCaseLetter=function(v){var i,s;for(i=v.length-1;i>=0;i--){s=v.charAt(i);if(s===s.toUpperCase()){return i;}}return-1;};
g.prototype._oldSetProperty=g.prototype.setProperty;
g.prototype.setProperty=function(p,v,s){this._oldSetProperty(p,v,true);var S="set"+this._firstLetterUpperCase(p);if(this._aNotSupportedProperties.indexOf(p)===-1&&S in this._oControl){this._oControl[S](v);}return this;};
g.prototype._oldSetModel=g.prototype.setModel;
g.prototype.setModel=function(m,n){this._oControl.setModel(m,n);return this._oldSetModel(m,n);};
g.prototype._createButtonFooter=function(){if(this._oFooter){return this._oFooter;}this._oFooter=new b(this.getId()+"-footer",{content:[new c()]});return this._oFooter;};
g.prototype._getButtonFooter=function(){return a.system.phone?this._oControl._getToolbar():this._oControl.getFooter();};
g.prototype._getPopup=function(){return this._oControl.oPopup;};
g.prototype._setButton=function(p,o){if(this._oControl instanceof P){var G="get"+this._firstLetterUpperCase(p)+"Button",O=this[G](),F=this._createButtonFooter(),s="_o"+this._firstLetterUpperCase(p)+"Button",i=(p.toLowerCase()==="begin"?0:1),h=(p.toLowerCase()==="begin"?"getEndButton":"getBeginButton");if(O){F.removeContent(O);}if(o){if(!F.getParent()){this._oControl.setFooter(F);}F.insertContent(o,i+1);}else{var j=this[h]();if(!j){F.destroy();this._oFooter=null;}}this[s]=o;return this;}else{var A=p.toLowerCase()+"Button";return this.setAggregation(A,o);}};
g.prototype._getButton=function(p){if(this._oControl instanceof P){var s="_o"+this._firstLetterUpperCase(p)+"Button";return this[s];}else{var G="get"+this._firstLetterUpperCase(p)+"Button";return this._oControl[G]();}};
g.prototype.setBeginButton=function(o){this._oControl.setBeginButton(o);return this._setButton("begin",o);};
g.prototype.setEndButton=function(o){this._oControl.setEndButton(o);return this._setButton("end",o);};
g.prototype.setShowCloseButton=function(s){var h=this._oControl._getAnyHeader();if(s){this._insertCloseButton(h);}else{this._removeCloseButton(h);}this.setProperty("showCloseButton",s,true);return this;};
g.prototype.getBeginButton=function(){return this._getButton("begin");};
g.prototype.getEndButton=function(){return this._getButton("end");};
["bindAggregation","validateAggregation","setAggregation","getAggregation","indexOfAggregation","insertAggregation","addAggregation","removeAggregation","removeAllAggregation","destroyAggregation","setAssociation","getAssociation","addAssociation","removeAssociation","removeAllAssociation"].forEach(function(n){g.prototype[n]=function(){var L=this._lastIndexOfUpperCaseLetter(n),m,r;if(typeof arguments[0]==="string"){if(L!==-1){m=n.substring(0,L)+this._firstLetterUpperCase(arguments[0]);if(this._oControl&&this._oControl[m]){r=this._oControl[m].apply(this._oControl,Array.prototype.slice.call(arguments,1));return r===this._oControl?this:r;}else{return C.prototype[n].apply(this,arguments);}}}r=this._oControl[n].apply(this._oControl,arguments);return r===this._oControl?this:r;};});["invalidate","close","isOpen","addStyleClass","removeStyleClass","toggleStyleClass","hasStyleClass","getDomRef","setBusy","getBusy","setBusyIndicatorDelay","getBusyIndicatorDelay","addEventDelegate","removeEventDelegate","_setAriaModal","_setAriaRoleApplication"].forEach(function(n){g.prototype[n]=function(){if(this._oControl&&this._oControl[n]){if(n==="invalidate"&&arguments[0]===this._oControl){return C.prototype.invalidate.apply(this,arguments);}var r=this._oControl[n].apply(this._oControl,arguments);return r===this._oControl?this:r;}};});
g.prototype._applyContextualSettings=function(){C.prototype._applyContextualSettings.call(this);};
return g;});
sap.ui.predefine('sap/m/ResponsivePopoverRenderer',[],function(){"use strict";var R={apiVersion:2};
R.render=function(r,c){};
return R;},true);
sap.ui.predefine('sap/m/SegmentedButton',['./library','./Button','sap/ui/core/Control','sap/ui/core/EnabledPropagator','sap/ui/core/delegate/ItemNavigation','sap/ui/core/ResizeHandler','sap/ui/core/ListItem','sap/ui/core/IconPool','./SegmentedButtonRenderer'],function(l,B,C,E,I,R,L,a,S){"use strict";
var c=C.extend("sap.m.SegmentedButton",{metadata:{interfaces:["sap.ui.core.IFormContent","sap.m.IOverflowToolbarContent"],library:"sap.m",designtime:"sap/m/designtime/SegmentedButton.designtime",publicMethods:["createButton"],properties:{width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true},selectedKey:{type:"string",group:"Data",defaultValue:"",bindable:"bindable"}},defaultAggregation:"buttons",aggregations:{buttons:{type:"sap.m.Button",multiple:true,singularName:"button"},items:{type:"sap.m.SegmentedButtonItem",multiple:true,singularName:"item",bindable:"bindable"},_select:{type:"sap.m.Select",multiple:false,visibility:"hidden"}},associations:{selectedButton:{deprecated:true,type:"sap.m.Button",multiple:false},selectedItem:{type:"sap.m.SegmentedButtonItem",multiple:false},ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{select:{deprecated:true,parameters:{button:{type:"sap.m.Button"},id:{type:"string"},key:{type:"string"}}},selectionChange:{parameters:{item:{type:"sap.m.SegmentedButtonItem"}}}},dnd:{draggable:true,droppable:false}}});
E.call(c.prototype);
c.prototype.init=function(){this._aWidths=[];this._oItemNavigation=new I();this._oItemNavigation.setCycling(false);this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"]});this.addDelegate(this._oItemNavigation);this.removeButton=function(b){var r=c.prototype.removeButton.call(this,b);this.setSelectedButton(this.getButtons()[0]);this._fireChangeEvent();return r;};};
c.prototype.onBeforeRendering=function(){var b=this._getVisibleButtons();this._bCustomButtonWidth=b.some(function(o){return o.getWidth();});if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}this.setSelectedKey(this.getProperty("selectedKey"));if(!this.getSelectedButton()){this._selectDefaultButton();}};
c.prototype.onAfterRendering=function(){var b=this._getVisibleButtons(),p;if(!this._sResizeListenerId){p=this.getDomRef().parentNode;if(p){this._sResizeListenerId=R.register(p,this._handleContainerResize.bind(this));}}this._setItemNavigation();this._aWidths=this._getRenderedButtonWidths(b);this._updateWidth();};
c.prototype._handleContainerResize=function(){var b=this._getVisibleButtons();this._clearAutoWidthAppliedToControl();this._aWidths=this._getRenderedButtonWidths(b);this._updateWidth();};
c.prototype._clearAutoWidthAppliedToControl=function(){var b=this._getVisibleButtons(),d=b.length,o,i=0;if(!this.getWidth()){this.$().css("width","");}while(i<d){o=b[i];if(!o.getWidth()){o.$().css("width","");}i++;}};
c.prototype._getRenderedButtonWidths=function(b){return b.map(function(o){var d=o.getDomRef();return d&&d.getBoundingClientRect?d.getBoundingClientRect().width:o.$().outerWidth();});};
c.prototype._getButtonWidth=function(b){var d=b.length,w,n=0,s=0,e=0,p,P,i=0;if(this._bCustomButtonWidth){while(i<d){w=b[i].getWidth();if(w){if(w.indexOf("%")!==-1){s+=parseInt(w.slice(0,-1));}else{e+=parseInt(w.slice(0,-2));}}else{n++;}i++;}if(n===0){return false;}p=(100-s)/n;P=(e/n);if(p<0){p=0;}if(P<0){P=0;}if(P>0){return"calc("+p+"% - "+P+"px)";}else{return p+"%";}}else{return(100/d)+"%";}};
c.prototype._updateWidth=function(){if(this.$().length===0||this.hasStyleClass("sapMSegmentedButtonNoAutoWidth")){return;}var s=this.getWidth(),b=this._getVisibleButtons(),d=b.length,m=(this._aWidths.length>0)?Math.max.apply(Math,this._aWidths):0,e=(100/d),p=this.$().parent().innerWidth(),w=this._getButtonWidth(b),f,o,i;if(!s){if((m*d)>p){this.addStyleClass("sapMSegBFit");}else if(m>0){this.$().width((m*d)+1);this.removeStyleClass("sapMSegBFit");}i=0;while(i<d){o=b[i];o.$().css("width",o.getWidth()?o.getWidth():w);i++;}}else if(s&&!this._bCustomButtonWidth){i=0;while(i<d){b[i].$().css("width",e+"%");i++;}}f=this.$().width();if(this._previousWidth!==undefined&&f!==this._previousWidth&&!this._bInOverflow){this.fireEvent("_containerWidthChanged");}this._previousWidth=f;};
c.prototype.exit=function(){if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}this._bCustomButtonWidth=null;this._aWidths=null;};
c.prototype._setItemNavigation=function(){var b,d=this.getDomRef();if(d){this._oItemNavigation.setRootDomRef(d);b=this.$().find(".sapMSegBBtn:not(.sapMSegBBtnDis)");this._oItemNavigation.setItemDomRefs(b);this._focusSelectedButton();}};
c.prototype.getOverflowToolbarConfig=function(){return{canOverflow:true,listenForEvents:["select"],autoCloseEvents:["select"],propsUnrelatedToSize:["enabled","selectedKey"],invalidationEvents:["_containerWidthChanged"],onBeforeEnterOverflow:this._onBeforeEnterOverflow,onAfterExitOverflow:this._onAfterExitOverflow};};
c.prototype._onBeforeEnterOverflow=function(o){o._toSelectMode();};
c.prototype._onAfterExitOverflow=function(o){if(o._bForcedSelectMode){o._toSelectMode();}else{o._toNormalMode();}};
c.prototype.getFormDoNotAdjustWidth=function(){return true;};
c.prototype.createButton=function(t,u,e,T){var b=new B();if(t!==null){b.setText(t);}if(u!==null){b.setIcon(u);}if(e||e===undefined){b.setEnabled(true);}else{b.setEnabled(false);}if(T){b.setTextDirection(T);}this.addButton(b);return b;};
(function(){
c.prototype.addButton=function(b){if(b){p(b,this);this.addAggregation('buttons',b);this._syncSelect();this._fireChangeEvent();}return this;};
c.prototype.insertButton=function(b,i){if(b){p(b,this);this.insertAggregation('buttons',b,i);this._syncSelect();this._fireChangeEvent();}return this;};
function p(b,P){b.attachPress(function(e){P._buttonPressed(e);});b.attachEvent("_change",P._syncSelect,P);b.attachEvent("_change",P._fireChangeEvent,P);var o=B.prototype.setEnabled;b.setEnabled=function(e){b.$().toggleClass("sapMSegBBtnDis",!e).toggleClass("sapMFocusable",e);o.apply(b,arguments);};b.setVisible=function(v){B.prototype.setVisible.apply(this,arguments);P.invalidate();};}
})();
c.prototype.getSelectedKey=function(){var b=this.getButtons(),d=this.getItems(),s=this.getSelectedButton(),i=0;if(d.length>0){for(;i<b.length;i++){if(b[i]&&b[i].getId()===s){this.setProperty("selectedKey",d[i].getKey(),true);return d[i].getKey();}}}return"";};
c.prototype.setSelectedKey=function(k){var b=this.getButtons(),d=this.getItems(),i=0;if(!k){this.setProperty("selectedKey",k,true);return this;}if(d.length>0&&b.length>0){for(;i<d.length;i++){if(d[i]&&d[i].getKey()===k){this.setSelectedItem(d[i]);break;}}}this.setProperty("selectedKey",k,true);return this;};
c.prototype.removeButton=function(b){var r=this.removeAggregation("buttons",b);if(r){delete r.setEnabled;r.detachEvent("_change",this._syncSelect,this);r.detachEvent("_change",this._fireChangeEvent,this);this._syncSelect();}return r;};
c.prototype.removeAllButtons=function(){var b=this.getButtons();if(b){for(var i=0;i<b.length;i++){var o=b[i];if(o){delete o.setEnabled;this.removeAggregation("buttons",o);o.detachEvent("_change",this._syncSelect,this);o.detachEvent("_change",this._fireChangeEvent,this);}}this._syncSelect();}return b;};
c.prototype.addItem=function(i){this.addAggregation("items",i);this.addButton(i.oButton);return this;};
c.prototype.removeItem=function(i){var r;if(i!==null&&i!==undefined){r=this.removeAggregation("items",i);this.removeButton(i.oButton);}if(i&&i instanceof sap.m.SegmentedButtonItem&&this.getSelectedButton()===i.oButton.getId()){this.setSelectedKey("");this.setSelectedButton("");this.setSelectedItem("");}this.setSelectedItem(this.getItems()[0]);return r;};
c.prototype.insertItem=function(i,b){this.insertAggregation("items",i,b);this.insertButton(i.oButton,b);return this;};
c.prototype.removeAllItems=function(s){var r=this.removeAllAggregation("items",s);this.removeAllButtons();this.setSelectedKey("");this.setSelectedButton("");this.setSelectedItem("");return r;};
c.prototype._buttonPressed=function(e){var b=e.getSource(),i;if(this.getSelectedButton()!==b.getId()){this.getButtons().forEach(function(o){o.$().removeClass("sapMSegBBtnSel");o.$().attr("aria-checked",false);});i=this.getItems().filter(function(o){return o.oButton===b;})[0];b.$().addClass("sapMSegBBtnSel");b.$().attr("aria-checked",true);this.setAssociation('selectedButton',b,true);this.setProperty("selectedKey",this.getSelectedKey(),true);this.setAssociation('selectedItem',i,true);this.fireSelectionChange({item:i});this.fireSelect({button:b,id:b.getId(),key:this.getSelectedKey()});}};
c.prototype._selectDefaultButton=function(){var b=this._getVisibleButtons();if(b.length>0){this.setAssociation('selectedButton',b[0],true);if(this.getItems().length>0){this.setAssociation('selectedItem',this.getItems()[0],true);}}};
c.prototype.setSelectedButton=function(b){var s=this.getSelectedButton(),d=this.getButtons();this.setAssociation("selectedButton",b);if(s!==this.getSelectedButton()){if(!this.getSelectedButton()&&d.length>1){this._selectDefaultButton();}this._focusSelectedButton();}this._syncSelect();return this;};
c.prototype.setSelectedItem=function(i){var o=typeof i==="string"&&i!==""?sap.ui.getCore().byId(i):i,b=o instanceof sap.m.SegmentedButtonItem,v=b?o.oButton:i;this.setAssociation("selectedItem",i,true);this.setSelectedButton(v);return this;};
c.prototype._focusSelectedButton=function(){var b=this.getButtons(),s=this.getSelectedButton(),i=0;for(;i<b.length;i++){if(b[i]&&b[i].getId()===s){this._oItemNavigation&&this._oItemNavigation.setFocusedIndex(i);break;}}};
c.prototype.onsappagedown=function(e){this._oItemNavigation.onsapend(e);};
c.prototype.onsappageup=function(e){this._oItemNavigation.onsaphome(e);};
c.prototype.onsapspace=function(e){e.preventDefault();};
c.prototype._lazyLoadSelectForm=function(){var s=this.getAggregation("_select");if(!s){jQuery.sap.require("sap.m.Select");var b=sap.ui.require("sap/m/Select");s=new b(this.getId()+"-select");s.attachChange(this._selectChangeHandler,this);s.addStyleClass("sapMSegBSelectWrapper");this.setAggregation("_select",s,true);}};
c.prototype._selectChangeHandler=function(e){var s=e.getParameter("selectedItem"),n=parseInt(s.getKey()),b=this.getButtons()[n],d=b.getId();b.firePress();this.setSelectedButton(d);};
c.prototype._fireChangeEvent=function(){this.fireEvent("_change");};
c.prototype._syncSelect=function(){var k=0,s=0,b,d,o=this.getAggregation("_select");if(!o){return;}o.destroyItems();this._getVisibleButtons().forEach(function(e){b=e.getText();d=e.getIcon();o.addItem(new L({key:k.toString(),icon:d?d:"",text:b?b:e.getTooltip_AsString(),enabled:e.getEnabled()}));if(e.getId()===this.getSelectedButton()){s=k;}k++;},this);o.setSelectedKey(s.toString());};
c.prototype._toSelectMode=function(){this._bInOverflow=true;this.addStyleClass("sapMSegBSelectWrapper");this._lazyLoadSelectForm();this._syncSelect();this._syncAriaAssociations();};
c.prototype._toNormalMode=function(){delete this._bInOverflow;this.removeStyleClass("sapMSegBSelectWrapper");};
c.prototype._syncAriaAssociations=function(){var s=this.getAggregation("_select");this.getAriaLabelledBy().forEach(function(o){if(s.getAriaLabelledBy().indexOf(o)===-1){s.addAriaLabelledBy(o);}});this.getAriaDescribedBy().forEach(function(d){if(s.getAriaLabelledBy().indexOf(d)===-1){s.addAriaLabelledBy(d);}});};
c.prototype._overwriteImageOnload=function(i){var t=this;if(i.onload===sap.m.Image.prototype.onload){i.onload=function(){if(sap.m.Image.prototype.onload){sap.m.Image.prototype.onload.apply(this,arguments);}window.setTimeout(function(){t._updateWidth();},20);};}};
c.prototype._getIconAriaLabel=function(i){var o=a.getIconInfo(i.getSrc()),r="";if(o&&o.name){r=o.name;}return r;};
c.prototype._getVisibleButtons=function(){return this.getButtons().filter(function(b){return b.getVisible();});};
c.prototype.clone=function(){var s=this.getSelectedButton(),d=this.removeAllAggregation("buttons"),o=C.prototype.clone.apply(this,arguments),e=d.map(function(b){return b.getId();}).indexOf(s),i;if(e>-1){o.setSelectedButton(o.getButtons()[e]);}for(i=0;i<d.length;i++){this.addAggregation("buttons",d[i]);}return o;};
return c;});
sap.ui.predefine('sap/m/SegmentedButtonItem',['./library','sap/ui/core/Item','sap/m/Button','sap/ui/core/CustomStyleClassSupport'],function(l,I,B,C){"use strict";
var S=I.extend("sap.m.SegmentedButtonItem",{metadata:{library:"sap.m",properties:{icon:{type:"string",group:"Appearance",defaultValue:null},visible:{type:"boolean",group:"Appearance",defaultValue:true},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null}},events:{press:{}}}});
C.apply(S.prototype);
S.prototype.init=function(){var b=new B(this.getId()+"-button");this.aCustomStyleClasses;this.mCustomStyleClassMap;b.aCustomStyleClasses=this.aCustomStyleClasses;b.mCustomStyleClassMap=this.mCustomStyleClassMap;b.getCustomData=this.getCustomData.bind(this);b.getLayoutData=this.getLayoutData.bind(this);b.firePress=function(){this.firePress();B.prototype.firePress.call(b);}.bind(this);this.getDomRef=b.getDomRef.bind(b);this.oButton=b;};
S.prototype.exit=function(){if(this.oButton){this.oButton.destroy();this.oButton=null;}};
S.prototype.setText=function(v){this.setProperty("text",v,true);if(this.oButton){this.oButton.setText(this.getText());}return this;};
S.prototype.setIcon=function(v){this.setProperty("icon",v,true);if(this.oButton){this.oButton.setIcon(this.getIcon());}return this;};
S.prototype.setEnabled=function(v){this.setProperty("enabled",v,true);if(this.oButton){this.oButton.setEnabled(this.getEnabled());}return this;};
S.prototype.setTextDirection=function(v){this.setProperty("textDirection",v,true);if(this.oButton){this.oButton.setTextDirection(this.getTextDirection());}return this;};
S.prototype.setVisible=function(v){this.setProperty("visible",v,true);if(this.oButton){this.oButton.setVisible(v);}return this;};
S.prototype.setWidth=function(v){this.setProperty("width",v,true);if(this.oButton){this.oButton.setWidth(this.getWidth());}return this;};
S.prototype.setTooltip=function(v){this.setAggregation("tooltip",v,true);if(this.oButton){this.oButton.setTooltip(v);}return this;};
return S;});
sap.ui.predefine('sap/m/SegmentedButtonRenderer',["sap/ui/core/library","sap/ui/core/InvisibleRenderer"],function(c,I){"use strict";var T=c.TextDirection;var S={apiVersion:2};
S.render=function(r,C){var b=C.getButtons(),v=b.filter(function(B){return B.getVisible();}),V=0,s=C.getSelectedButton(),B,t,a,d;if(C._bInOverflow){r.openStart("div",C);r.openEnd();r.renderControl(C.getAggregation("_select"));r.close("div");return;}r.openStart("ul",C);if(S._addAllIconsClass(b)){r.class("sapMSegBIcons");}r.class("sapMSegB");r.style('width',C.getWidth());t=C.getTooltip_AsString();if(t){r.attr("title",t);}r.accessibilityState(C,{role:"radiogroup"});r.openEnd();for(var i=0;i<b.length;i++){B=b[i];if(B.getVisible()){var e=B.getText(),o=B.getIcon(),f="",g;++V;if(o){g=B._getImage((B.getId()+"-img"),o);if(g instanceof sap.m.Image){C._overwriteImageOnload(g);}else if(!B.getTooltip()){f=C._getIconAriaLabel(g);}}r.openStart("li",B);r.attr("aria-posinset",V);r.attr("aria-setsize",v.length);r.class("sapMSegBBtn");if(B.getId()===v[v.length-1].getId()){r.class("sapMSegBtnLastVisibleButton");}if(B.aCustomStyleClasses!==undefined&&B.aCustomStyleClasses instanceof Array){for(var j=0;j<B.aCustomStyleClasses.length;j++){r.class(B.aCustomStyleClasses[j]);}}if(B.getEnabled()){r.class("sapMSegBBtnFocusable");}else{r.class("sapMSegBBtnDis");}if(s===B.getId()){r.class("sapMSegBBtnSel");}if(o&&e!==''){r.class("sapMSegBBtnMixed");}a=B.getWidth();r.style('width',a);t=B.getTooltip_AsString();if(t){r.attr("title",t);}r.attr("tabindex",B.getEnabled()?"0":"-1");d=B.getTextDirection();if(d!==T.Inherit){r.attr("dir",d.toLowerCase());}r.accessibilityState(B,{role:"radio",checked:s===B.getId()});if(g&&f!==""){if(e!==""){f+=" "+e;}else{r.attr("title",f);}r.attr("aria-label",f);}r.openEnd();r.openStart("div");r.class("sapMSegBBtnInner");r.openEnd();if(o&&g){r.renderControl(g);}if(e!==''){r.text(e);}r.close("div");r.close("li");}else{I.render(r,B,"li");}}r.close("ul");};
S._addAllIconsClass=function(b){for(var i=0;i<b.length;i++){if(!b[i].getIcon()){return false;}}return true;};
return S;},true);
sap.ui.predefine('sap/m/SuggestionsPopover',['sap/ui/Device','sap/ui/base/EventProvider','sap/ui/core/InvisibleText','sap/ui/core/ListItem','sap/ui/core/ResizeHandler','sap/ui/core/ValueStateSupport','sap/m/library','sap/ui/core/library','sap/m/Bar','sap/m/Toolbar','sap/m/Button','sap/m/ToggleButton','sap/m/ColumnListItem','sap/m/GroupHeaderListItem','sap/ui/core/SeparatorItem','sap/m/Dialog','sap/m/List','sap/m/Popover','sap/m/StandardListItem','sap/m/Table','sap/m/Title','sap/ui/core/IconPool',"sap/ui/events/KeyCodes","sap/m/ValueStateHeader","sap/m/inputUtils/highlightDOMElements","sap/m/inputUtils/scrollToItem"],function(D,E,I,L,R,V,l,c,B,T,a,b,C,G,S,d,e,P,f,g,h,j,K,k,m,s){"use strict";var n=l.ListMode;var o=l.PlacementType;var p=l.ListType;var q=l.ListSeparators;var r="sapMSuggestionsPopover",t="sapUiNoContentPadding";var u=c.ValueState;
var v=E.extend("sap.m.SuggestionsPopover",{
constructor:function(i){E.apply(this,arguments);this._oInput=i;this._bHasTabularSuggestions=false;this._bUseDialog=D.system.phone;this._iPopupListSelectedIndex=-1;this._sPopoverContentWidth=null;this._bEnableHighlighting=true;this._bIsInputIncrementalType=false;this._bAutocompleteEnabled=false;this._sTypedInValue='';this._sOldValueState=u.None;this._oInput.addEventDelegate({onsapup:function(w){if(!this._oInput.isComposingCharacter()){this._onsaparrowkey(w,"up",1);}},onsapdown:function(w){if(!this._oInput.isComposingCharacter()){this._onsaparrowkey(w,"down",1);}},onsappageup:function(w){this._onsaparrowkey(w,"up",5);},onsappagedown:function(w){this._onsaparrowkey(w,"down",5);},onsaphome:function(w){var x;if(this._oList){x=this._oList.getItems().length?this._oList.getItems().length-1:0;this._onsaparrowkey(w,"up",x);}},onsapend:function(w){if(this._oList){this._onsaparrowkey(w,"down",this._oList.getItems().length);}},onsapright:this._onsapright,onsaptabnext:this._handleValueStateLinkNav,onsaptabprevious:this._handleValueStateLinkNav},this);},
destroy:function(){if(this._oPopover){this._oPopover.destroy();this._oPopover=null;}if(this._oList){this._oList.destroy();this._oList=null;}this._oProposedItem=null;this._oInputDelegate=null;this._oValueStateHeader=null;if(this._oPickerValueStateText){this._oPickerValueStateText.destroy();this._oPickerValueStateText=null;}}
});
v.M_EVENTS={SELECTION_CHANGE:"selectionChange"};
v.prototype.isOpen=function(){return this._oPopover&&this._oPopover.isOpen();};
v.prototype.setInputLabels=function(i){this._fnInputLabels=i;};
v.prototype._getInputLabels=function(){return this._fnInputLabels();};
v.prototype.updatePickerHeaderTitle=function(){var i=sap.ui.getCore().getLibraryResourceBundle("sap.m"),w=this.getPickerTitle(),x,y;if(!w){return;}y=this._getInputLabels();if(y.length){x=y[0];if(x&&(typeof x.getText==="function")){w.setText(x.getText());}}else{w.setText(i.getText("COMBOBOX_PICKER_TITLE"));}return w;};
v.prototype.getPickerTitle=function(){return this._oPopover.getCustomHeader().getContentMiddle()[0];};
v.prototype.getOkButton=function(){var i=this._oPopover&&this._oPopover.getBeginButton();return i||null;};
v.prototype.getCancelButton=function(){var i=this._oPopover&&this._oPopover.getCustomHeader()&&this._oPopover.getCustomHeader().getContentRight&&this._oPopover.getCustomHeader().getContentRight()[0];return i||null;};
v.prototype.getFilterSelectedButton=function(){var i=this._oPopover&&this._oPopover.getSubHeader()&&this._oPopover.getSubHeader().getContent()[1];return i||null;};
v.prototype._createFilterSelectedButton=function(){var i=j.getIconURI("multiselect-all");return new b({icon:i});};
v.prototype._createSuggestionPopup=function(O){O=O||[];var i=this._oInput,w=this,M=i._oRb;this._oPopover=!this._bUseDialog?(new P(i.getId()+"-popup",{showArrow:false,placement:o.VerticalPreferredBottom,showHeader:true,initialFocus:i,horizontalScrolling:true,beforeClose:function(){if(w.bMessageValueStateActive){w._getValueStateHeader().removeStyleClass("sapMPseudoFocus");w.bMessageValueStateActive=false;}}})):(new d(i.getId()+"-popup",{beginButton:new a(i.getId()+"-popup-closeButton",{text:M.getText("SUGGESTIONSPOPOVER_CLOSE_BUTTON")}),stretch:true,customHeader:new B(i.getId()+"-popup-header",{contentMiddle:new h(),contentRight:new a({icon:j.getIconURI("decline")})}),subHeader:this.createSubHeaderContent(O),horizontalScrolling:false,initialFocus:this._oPopupInput,beforeOpen:function(){w.updatePickerHeaderTitle();},afterClose:function(){i.focus();l.closeKeyboard();}}));this._registerAutocomplete();this._oPopover.addStyleClass(r);this._oPopover.addStyleClass(t);this._oPopover.addAriaLabelledBy(I.getStaticId("sap.m","INPUT_AVALIABLE_VALUES"));if(!this._bUseDialog){this._overwritePopover();}if(this._oList){this._oPopover.addContent(this._oList);}};
v.prototype.createSubHeaderContent=function(O){var i=[this._oPopupInput];if(O.showSelectedButton){i.push(this._createFilterSelectedButton());}return new T({content:i});};
v.prototype._createSuggestionPopupContent=function(i){var w=this._oInput;this._bHasTabularSuggestions=i;if(!i){this._oList=new e(w.getId()+"-popup-list",{showNoData:false,mode:n.SingleSelectMaster,rememberSelections:false,width:"100%",showSeparators:q.None,busyIndicatorDelay:0});this._oList.addEventDelegate({onAfterRendering:function(){var z,A;if(!this._bEnableHighlighting){return;}z=this._oList.$().find('.sapMSLIInfo, .sapMSLITitleOnly');A=(this._sTypedInValue||this._oInput.getValue()).toLowerCase();m(z,A);}.bind(this)});}else{this._oList=this._oInput._getSuggestionsTable();}if(this._oPopover){if(this._bUseDialog){this._oPopover.addAggregation("content",this._oList,true);var x=this._oPopover.$("scrollCont")[0];if(x){var y=sap.ui.getCore().createRenderManager();y.renderControl(this._oList);y.flush(x);y.destroy();}}else{this._oPopover.addContent(this._oList);}}};
v.prototype._getValueStateHeader=function(){if(!this._oValueStateHeader){this._oValueStateHeader=new k();if(this._oPopover.isA("sap.m.Popover")){this._oPopover.setCustomHeader(this._oValueStateHeader);}else{this._oPopover.insertContent(this._oValueStateHeader,0);}this._oValueStateHeader.setPopup(this._oPopover);}return this._oValueStateHeader;};
v.prototype._destroySuggestionPopup=function(){if(this._oPopover){if(this._oList instanceof g){this._oPopover.removeAllContent();}this._oPopover.destroy();this._oPopover=null;}if(this._oList instanceof e){this._oList.destroy();this._oList=null;}if(this._oPickerValueStateText){this._oPickerValueStateText.destroy();this._oPickerValueStateText=null;}if(this._oValueStateHeader){this._oValueStateHeader.destroy();this._oValueStateHeader=null;}this._getInput().removeEventDelegate(this._oInputDelegate,this);};
v.prototype._overwritePopover=function(){var i=this._oInput;this._oPopover.open=function(){this.openBy(i,false,true);};this._oPopover.oPopup.setAnimations(function($,w,O){O();},function($,w,x){x();});};
v.prototype._resizePopup=function(){var i=this._oInput;if(this._oList&&this._oPopover){if(this._sPopoverContentWidth){this._oPopover.setContentWidth(this._sPopoverContentWidth);}else{this._oPopover.setContentWidth((i.$().outerWidth())+"px");}setTimeout(function(){if(this._oPopover&&this._oPopover.isOpen()&&this._oPopover.$().outerWidth()<i.$().outerWidth()){this._oPopover.setContentWidth((i.$().outerWidth())+"px");}}.bind(this),0);}};
v.prototype._registerResize=function(){if(!this._bUseDialog){this._sPopupResizeHandler=R.register(this._oInput,this._resizePopup.bind(this));}};
v.prototype._deregisterResize=function(){if(this._sPopupResizeHandler){this._sPopupResizeHandler=R.deregister(this._sPopupResizeHandler);}};
v.prototype._handleValueStateLinkNav=function(i){this.bMessageValueStateActive=this._oInput.getFormattedTextFocused?this._oInput.getFormattedTextFocused():this.bMessageValueStateActive;if((!this.bMessageValueStateActive||!this.getValueStateLinks().length)||(this.bMessageValueStateActive&&document.activeElement.tagName==="A")){return;}var w=this.getValueStateLinks(),x=w[w.length-1];i.preventDefault();this._iPopupListSelectedIndex=-1;w[0].focus();this._getValueStateHeader().removeStyleClass("sapMPseudoFocus");w.forEach(function(y){y.addDelegate({onsapup:function(i){this._oInput.getFocusDomRef().focus();this._onsaparrowkey(i,"up",1);},onsapdown:function(i){this._oInput.getFocusDomRef().focus();this._onsaparrowkey(i,"down",1);}},this);},this);x.addDelegate({onsaptabnext:function(i){this.bMessageValueStateActive=false;this._oInput.onsapfocusleave(i);this._oPopover.close();setTimeout(function(){this._oInput.closeValueStateMessage();}.bind(this),0);}},this);w[0].addDelegate({onsaptabprevious:function(i){i.preventDefault();this._oInput.getFocusDomRef().focus();this._getValueStateHeader().addStyleClass("sapMPseudoFocus");this._oInput.removeStyleClass("sapMFocus");}},this);};
v.prototype._onsaparrowkey=function(i,w,x){var y=this._oInput,z,A=y.$("inner");if(i.isMarked()){return;}if(!y.getEnabled()||!y.getEditable()){return;}if(w!=="up"&&w!=="down"){return;}if(this._bIsInputIncrementalType){i.setMarked();}if(!this._oPopover||!this._oPopover.isOpen()){return;}i.preventDefault();i.stopPropagation();var F=false,H=this._oList,J=H.getItems(),M=H.getSelectedItem(),N=this._iPopupListSelectedIndex,O,Q=this._getValueStateHeader(),U=Q.getFormattedText(),W=D.browser.msie?U:Q,X=N;if(w=="down"&&N===J.length-1){return;}if(this.getValueStateLinks().length&&this.bMessageValueStateActive&&i.type==="sapend"){W.removeStyleClass("sapMPseudoFocus");this._oList.addStyleClass("sapMListFocus");X=0;N=J.length-1;J[N].addStyleClass("sapMLIBFocused");this.bMessageValueStateActive=false;}var Y;if(x>1){if(w=="down"&&N+x>=J.length){w="up";x=1;J[N].setSelected(false);J[N].removeStyleClass("sapMLIBFocused");Y=N;N=J.length-1;F=true;}else if(w=="up"&&N-x<0&&N>=0){w="down";x=1;J[N].setSelected(false);J[N].removeStyleClass("sapMLIBFocused");Y=N;N=0;F=true;}}y.removeStyleClass("sapMFocus");this._oList.addStyleClass("sapMListFocus");if(N===-1){N=0;if(this._isSuggestionItemSelectable(J[N])){X=N;F=true;}else{w="down";}}if(w==="down"){while(N<J.length-1&&(!F||!this._isSuggestionItemSelectable(J[N]))){J[N].setSelected(false);J[N].removeStyleClass("sapMLIBFocused");N=N+x;F=true;x=1;if(Y===N){break;}}}else{while(N>0&&(!F||!J[N].getVisible()||!this._isSuggestionItemSelectable(J[N]))){J[N].setSelected(false);J[N].removeStyleClass("sapMLIBFocused");N=N-x;F=true;x=1;if(Y===N){break;}}}if((this.getValueStateLinks().length&&!this.bMessageValueStateActive&&i.type!=="sapend")&&((w==="up"&&(!this._isSuggestionItemSelectable(J[N])||X===0))||i.type==="saphome")){W.addStyleClass(("sapMPseudoFocus"));this._oList.removeStyleClass("sapMListFocus");A.attr("aria-activedescendant",U.getId());this.bMessageValueStateActive=true;this._iPopupListSelectedIndex=-1;s(J[0],this._oPopover);return;}if((this.getValueStateLinks().length&&this.bMessageValueStateActive)&&(w==="up"&&N===0||w==="down")){W.removeStyleClass("sapMPseudoFocus");this._oList.addStyleClass("sapMListFocus");this.bMessageValueStateActive=false;}if(!this._isSuggestionItemSelectable(J[N])){if(X>=0){J[X].setSelected(true).updateAccessibilityState();A.attr("aria-activedescendant",J[X].getId());J[X].addStyleClass("sapMLIBFocused");}return;}else{z=J[N];z.setSelected(true).updateAccessibilityState();z.addStyleClass("sapMLIBFocused");A.attr("aria-activedescendant",J[N].getId());}if(D.system.desktop){s(J[N],this._oPopover);}this._oLastSelectedHeader&&this._oLastSelectedHeader.removeStyleClass("sapMInputFocusedHeaderGroup");if(C&&J[N]instanceof C){O=y._getInputValue(y._fnRowResultFilter(J[N]));}else{if(J[N].isA("sap.m.GroupHeaderListItem")){O="";J[N].addStyleClass("sapMInputFocusedHeaderGroup");M&&M.setSelected(false);this._oLastSelectedHeader=J[N];}else{O=y._getInputValue(J[N].getTitle());}}this._iPopupListSelectedIndex=N;this._bSuggestionItemChanged=true;this.fireEvent(v.M_EVENTS.SELECTION_CHANGE,{newValue:O});};
v.prototype.getValueStateLinks=function(){var H=this._getValueStateHeader(),F=H&&typeof H.getFormattedText==="function"&&H.getFormattedText(),i=F&&typeof F.getControls==="function"&&F.getControls();return i||[];};
v.prototype._isSuggestionItemSelectable=function(i){var w=this._bHasTabularSuggestions||i.getType()!==p.Inactive||i.isA("sap.m.GroupHeaderListItem");return i.getVisible()&&w;};
v.prototype.setOkPressHandler=function(H){var O=this.getOkButton();O&&O.attachPress(H);return O;};
v.prototype.setCancelPressHandler=function(H){var i=this.getCancelButton();i&&i.attachPress(H);};
v.prototype.setShowSelectedPressHandler=function(H){var F=this.getFilterSelectedButton();F&&F.attachPress(H);return F;};
v.prototype._registerAutocomplete=function(){var i=this._oPopover,U=this._getInput(),w=this._bUseDialog;if(w){i.addEventDelegate({ontap:function(){if(!this._bSuggestionItemTapped&&this._sProposedItemText){U.setValue(this._sProposedItemText);this._sProposedItemText=null;}}},this);}else{i.attachAfterOpen(this._handleTypeAhead,this);}i.attachAfterOpen(this._setSelectedSuggestionItem,this);i.attachAfterClose(this._finalizeAutocomplete,this);this._oInputDelegate={onkeydown:function(x){this._bDoTypeAhead=!D.os.android&&this._bAutocompleteEnabled&&(x.which!==K.BACKSPACE)&&(x.which!==K.DELETE);},oninput:this._handleTypeAhead};U.addEventDelegate(this._oInputDelegate,this);};
v.prototype._handleTypeAhead=function(){var w=this._getInput(),x=w.getValue();this._oProposedItem=null;this._sProposedItemText=null;this._sTypedInValue=x;if(!this._bDoTypeAhead||x===""){return;}if(!this._oPopover.isOpen()||x.length<this._oInput.getStartSuggestion()){return;}if(document.activeElement!==w.getFocusDomRef()){return;}var y=x.toLowerCase(),z=this._bHasTabularSuggestions?this._oInput.getSuggestionRows():this._oInput.getSuggestionItems(),A,N,F,i;z=z.filter(function(H){return!(H.isA("sap.ui.core.SeparatorItem")||H.isA("sap.m.GroupHeaderListItem"));});A=z.length;for(i=0;i<A;i++){F=this._bHasTabularSuggestions?this._oInput._fnRowResultFilter(z[i]):z[i].getText();if(F.toLowerCase().indexOf(y)===0){this._oProposedItem=z[i];N=F;break;}}this._sProposedItemText=N;if(N){N=this._formatTypedAheadValue(N);if(!w.isComposingCharacter()){w.updateDomValue(N);}if(D.system.desktop){w.selectText(x.length,N.length);}else{setTimeout(function(){w.selectText(x.length,N.length);},0);}}};
v.prototype._setSelectedSuggestionItem=function(){var F;if(this._oList){F=this._oList.getItems();for(var i=0;i<F.length;i++){if((F[i]._oItem||F[i])===this._oProposedItem){F[i].setSelected(true);break;}}}};
v.prototype._getInput=function(){return this._bUseDialog?this._oPopupInput:this._oInput;};
v.prototype._finalizeAutocomplete=function(){if(this._oInput.isComposingCharacter()){return;}if(!this._bAutocompleteEnabled){return;}if(!this._bSuggestionItemTapped&&!this._bSuggestionItemChanged&&this._oProposedItem){if(this._bHasTabularSuggestions){this._oInput.setSelectionRow(this._oProposedItem,true);}else{this._oInput.setSelectionItem(this._oProposedItem,true);}}if(this._oProposedItem&&document.activeElement===this._oInput.getFocusDomRef()){var i=this._oInput.getValue().length;this._oInput.selectText(i,i);}this._resetTypeAhead();};
v.prototype._resetTypeAhead=function(){this._oProposedItem=null;this._sProposedItemText=null;this._sTypedInValue='';this._bSuggestionItemTapped=false;this._bSuggestionItemChanged=false;};
v.prototype._formatTypedAheadValue=function(N){return this._sTypedInValue.concat(N.substring(this._sTypedInValue.length,N.length));};
v.prototype._onsapright=function(){var i=this._oInput,w=i.getValue();if(!this._bAutocompleteEnabled){return;}if(this._sTypedInValue!==w){this._sTypedInValue=w;i.fireLiveChange({value:w,newValue:w});}};
v.prototype.updateValueState=function(i,w,x){var y=x&&i!==u.None;w=w||V.getAdditionalText(i);if(!this._oPopover){return this;}if(this._oPopupInput){this._oPopupInput.setValueState(i);}this._getValueStateHeader().setValueState(i);if(this._oValueStateHeader&&typeof w==="string"){this._oValueStateHeader.setText(w);}else if(this._oValueStateHeader&&typeof w==="object"){this._oValueStateHeader.setFormattedText(w);}if(this._oValueStateHeader){this._oValueStateHeader.setVisible(y);}this._alignValueStateStyles(i);return this;};
v.prototype._alignValueStateStyles=function(i){var w=r+"ValueState",O=r+this._sOldValueState+"State",x=r+i+"State";this._oPopover.addStyleClass(w);this._oPopover.removeStyleClass(O);this._oPopover.addStyleClass(x);this._sOldValueState=i;};
v.prototype.addContent=function(i){this._oPopover.addContent(i);};
return v;});
sap.ui.predefine('sap/m/TimePickerSlider',['sap/ui/core/Control','./TimePickerSliderRenderer','sap/ui/core/IconPool','sap/ui/Device',"sap/ui/events/KeyCodes","sap/m/Button","sap/ui/thirdparty/jquery"],function(C,T,I,D,K,B,q){"use strict";
var a=C.extend("sap.m.TimePickerSlider",{
metadata:{library:"sap.m",properties:{selectedValue:{type:"string",defaultValue:null},isCyclic:{type:"boolean",defaultValue:true},label:{type:"string",defaultValue:null},isExpanded:{type:"boolean",defaultValue:false}},aggregations:{items:{type:"sap.m.VisibleItem",multiple:true,singularName:"item"},_arrowUp:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_arrowDown:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},events:{expanded:{},collapsed:{}}},
renderer:T.render
});
var S=sap.ui.getCore().getConfiguration().getAnimation()?200:0;var M=50;var L=32;var A=32;
a.prototype.init=function(){this._bIsDrag=null;this._selectionOffset=0;this._mousedown=false;this._dragSession=null;this._iSelectedItemIndex=-1;this._animatingSnap=false;this._iSelectedIndex=-1;this._animating=false;this._intervalId=null;this._maxScrollTop=null;this._minScrollTop=null;this._marginTop=null;this._marginBottom=null;this._bOneTimeValueSelectionAnimation=false;this._bEnabled=true;if(D.system.desktop){this._fnHandleTypeValues=t.call(this);}this._initArrows();};
a.prototype.exit=function(){var s=this._getSliderContainerDomRef();if(s){s.stop();}if(this._intervalId){clearInterval(this._intervalId);this._intervalId=null;}};
a.prototype.onAfterRendering=function(){if(D.system.phone){setTimeout(this._afterExpandCollapse.bind(this),0);}else{this._afterExpandCollapse();}this._attachEvents();};
a.prototype.onThemeChanged=function(e){this.invalidate();};
a.prototype.fireTap=function(e){var s,i,d;if(!this.getIsExpanded()){if(D.system.desktop){this.focus();}else{this.setIsExpanded(true);}}else{s=e.srcElement||e.originalTarget;if(s&&s.tagName.toLowerCase()==="li"){i=q(s).text();d=F.call(this,i);this._iClickedIndex=Array.prototype.slice.call(s.parentElement.children).indexOf(s);this._bOneTimeValueSelectionAnimation=true;this.setSelectedValue(d);this._fireSelectedValueChange(d);}else{this._addSelectionStyle();this.focus();}}};
a.prototype.setSelectedValue=function(v){var i=f(this._getVisibleItems(),function(E){return E.getKey()===v;}),d=this,e,s,g,h;if(i===-1){return this;}if(this.getDomRef()){s=this._getSliderContainerDomRef();g=this._getItemHeightInPx();h=this._getContentRepeat();if(i*g>=this._selectionOffset){e=this._getVisibleItems().length*Math.floor(h/2)+i;}else{e=this._getVisibleItems().length*Math.ceil(h/2)+i;}if(this._bOneTimeValueSelectionAnimation){s.scrollTop((e-this._iClickedIndex+this._iSelectedItemIndex)*g-this._selectionOffset);this._animatingSnap=true;s.animate({scrollTop:e*g-this._selectionOffset},S,'linear',function(){s.clearQueue();d._animatingSnap=false;d._bOneTimeValueSelectionAnimation=false;});}else{s.scrollTop(e*g-this._selectionOffset);}this._removeSelectionStyle();this._iSelectedItemIndex=e;this._addSelectionStyle();}return this.setProperty("selectedValue",v,true);};
a.prototype.setIsExpanded=function(v,s){this.setProperty("isExpanded",v,true);if(!this.getDomRef()){return this;}var $=this.$();if(v){$.addClass("sapMTPSliderExpanded");if(D.system.phone){setTimeout(function(){this._updateDynamicLayout(v);if(!s){this.fireExpanded({ctrl:this});}}.bind(this),0);}else{this._updateDynamicLayout(v);if(!s){this.fireExpanded({ctrl:this});}}}else{this._stopAnimation();if(this._animatingSnap===true){this._animatingSnap=false;this._getSliderContainerDomRef().stop(true);if(this._animatingTargetIndex!==null&&this._animatingTargetIndex!==undefined){this._scrollerSnapped(this._animatingTargetIndex);this._animatingTargetIndex=null;}else if(this._iSelectedIndex!==-1){this._scrollerSnapped(this._iSelectedIndex);}}$.removeClass("sapMTPSliderExpanded");this._updateMargins(v);if(D.system.phone){setTimeout(this._afterExpandCollapse.bind(this),0);}else{this._afterExpandCollapse();}if(!s){this.fireCollapsed({ctrl:this});}}return this;};
a.prototype.onfocusin=function(e){if(D.system.desktop&&!this.getIsExpanded()){this.setIsExpanded(true);}};
a.prototype.onfocusout=function(e){var s=e.relatedTarget?e.relatedTarget.id:null,d=[this.getAggregation("_arrowUp").getId(),this.getAggregation("_arrowDown").getId()];if(s&&d.indexOf(s)!==-1){return;}if(D.system.desktop&&this.getIsExpanded()){this.setIsExpanded(false);}};
a.prototype._onmousewheel=function(e){var O,d,w;e.preventDefault();e.stopPropagation();if(!this.getIsExpanded()||this._intervalId){return false;}O=e.originalEvent;d=O.detail?(-O.detail>0):(O.wheelDelta>0);w=O.detail?(-O.detail/3):(O.wheelDelta/120);if(!w){return false;}this._handleWheelScroll(d,w);};
a.prototype._handleWheelScroll=function(d,w){var r=d?Math.ceil:Math.floor,R;if(!this._aWheelDeltas){this._aWheelDeltas=[];}this._aWheelDeltas.push(w);if(!this._bWheelScrolling){this._bWheelScrolling=true;this._intervalId=setInterval(function(){if(!this._aWheelDeltas.length){clearInterval(this._intervalId);this._intervalId=null;this._bWheelScrolling=false;}else{R=this._aWheelDeltas[0];this._aWheelDeltas=[];R=r(R);if(R){this._offsetSlider(R);}}}.bind(this),150);}return false;};
a.prototype.onsappageup=function(e){if(this.getIsExpanded()){var i=this._getVisibleItems()[0],v=i.getKey();this.setSelectedValue(v);this._fireSelectedValueChange(v);}};
a.prototype.onsappagedown=function(e){if(this.getIsExpanded()){var l=this._getVisibleItems()[this._getVisibleItems().length-1],v=l.getKey();this.setSelectedValue(v);this._fireSelectedValueChange(v);}};
a.prototype.onsapup=function(e){if(this.getIsExpanded()){this._offsetValue(-1);}};
a.prototype.onsapdown=function(e){if(this.getIsExpanded()){this._offsetValue(1);}};
a.prototype.onkeydown=function(e){var k=e.which||e.keyCode,d=K;if(k>=d.NUMPAD_0&&k<=d.NUMPAD_9){k=this._convertNumPadToNumKeyCode(k);}if((k>=d.A&&k<=d.Z)||(k>=d.DIGIT_0&&k<=d.DIGIT_9)){this._fnHandleTypeValues(e.timeStamp,k);}};
a.prototype._getSliderContainerDomRef=function(){return this.$().find(".sapMTimePickerSlider");};
a.prototype._getContentRepeat=function(){var i;if(this.getIsCyclic()){i=Math.ceil(M/this._getVisibleItems().length);i=Math.max(i,3);}else{i=1;}return i;};
a.prototype._getItemHeightInPx=function(){return this.$("content").find("li:not(.TPSliderItemHidden)")[0].getBoundingClientRect().height;};
a.prototype._updateSelectionFrameLayout=function(){var $,i,d,e,s=this.$().offset(),g=s?s.top:0,h=this.$().parents(".sapMTimePickerContainer").offset(),j=h?h.top:0;if(this.getDomRef()){e=this._getItemHeightInPx();$=this.$().find(".sapMTPPickerSelectionFrame");d=g-j;i=(this.$().height()-e+L)/2+d;$.css("top",i);if(D.system.phone){setTimeout(this._afterExpandCollapse.bind(this),0);}else{this._afterExpandCollapse();}}};
a.prototype._updateStepAndValue=function(n,s){var v=0,$,i;for(i=0;i<this.getItems().length;i++){if(i%s!==0&&i!==n){this.getItems()[i].setVisible(false);}else{this.getItems()[i].setVisible(true);v++;}}if(v>2&&v<13&&this.getDomRef()){$=this.$().find(".sapMTimePickerSlider");$.className="";q($).addClass("sapMTimePickerSlider SliderValues"+v.toString());}this.setIsCyclic(v>2);this.setSelectedValue(n.toString());};
a.prototype._updateMargins=function(i){var d=this._getItemHeightInPx(),$,v,V,e,g,h,m,j;if(this.getDomRef()){d=this._getItemHeightInPx();$=this.$().find(".SliderValues3,.SliderValues4,.SliderValues5,.SliderValues6,.SliderValues7,.SliderValues8,.SliderValues9,.SliderValues10,.SliderValues11,.SliderValues12");if(!$.length){return;}if(i){v=this._getVisibleItems().length;V=d*Math.floor(v/2);e=d*Math.ceil(v/2);h=this.$().parents().hasClass('sapUiSizeCompact')?A:0;g=(this.$().height()-d+L)/2;m=g-V-L-h;j=this.$().height()-g-e-h;m=Math.max(m,0);j=Math.max(j,0);}else{m=0;j=0;}$.css("margin-top",m);$.css("margin-bottom",j);}};
a.prototype._updateDynamicLayout=function(i){this._updateMargins(i);this._updateSelectionFrameLayout();};
a.prototype._getSelectionFrameTopOffset=function(){var $=this._getSliderContainerDomRef().find(".sapMTPPickerSelectionFrame"),d=$.offset();return d.top;};
a.prototype._animateScroll=function(s){var $=this._getSliderContainerDomRef(),p=$.scrollTop(),d=25,e=$.height(),g=this.$("content").height(),i=200,h=e+i,j=this._getContentRepeat(),k=this.getIsCyclic(),l=0.9,m=0.05,n=this;this._intervalId=setInterval(function(){n._animating=true;p=p-s*d;if(k){p=n._getUpdatedCycleScrollTop(e,g,p,h,j);}else{if(p>n._maxScrollTop){p=n._maxScrollTop;s=0;}if(p<n._minScrollTop){p=n._minScrollTop;s=0;}}$.scrollTop(p);s*=l;if(Math.abs(s)<m){var r=n._getItemHeightInPx();var O=n._selectionOffset?(n._selectionOffset%r):0;var u=Math.round((p+O)/r)*r-O;clearInterval(n._intervalId);n._intervalId=null;n._animating=null;n._iSelectedIndex=Math.round((p+n._selectionOffset)/r);n._animatingSnap=true;$.animate({scrollTop:u},S,'linear',function(){$.clearQueue();n._animatingSnap=false;if($.css("visibility")==="visible"){n._scrollerSnapped(n._iSelectedIndex);}});}},d);};
a.prototype._stopAnimation=function(){if(this._animating){clearInterval(this._intervalId);this._intervalId=null;this._animating=null;}};
a.prototype._startDrag=function(p){if(!this._dragSession){this._dragSession={};this._dragSession.positions=[];}this._dragSession.pageY=p;this._dragSession.startTop=this._getSliderContainerDomRef().scrollTop();};
a.prototype._doDrag=function(p,d){if(this._dragSession){this._dragSession.offsetY=p-this._dragSession.pageY;this._dragSession.positions.push({pageY:p,timeStamp:d});if(this._dragSession.positions.length>20){this._dragSession.positions.splice(0,10);}if(this._bIsDrag){this._getSliderContainerDomRef().scrollTop(this._dragSession.startTop-this._dragSession.offsetY);}}};
a.prototype._endDrag=function(p,d){if(this._dragSession){var O,e;for(var i=this._dragSession.positions.length-1;i>=0;i--){O=d-this._dragSession.positions[i].timeStamp;e=p-this._dragSession.positions[i].pageY;if(O>100){break;}}var s=(e/O);if(this._animating){clearInterval(this._intervalId);this._intervalId=null;this._animating=null;}this._dragSession=null;this._animateScroll(s);}};
a.prototype._afterExpandCollapse=function(){var s=this.getSelectedValue(),d=this._getSelectionFrameTopOffset(),$=this._getSliderContainerDomRef(),e=$.offset(),i,l,g,h;this._selectionOffset=d-e.top;if(!this.getIsCyclic()){l=this.$("content");h=this._getItemHeightInPx();g=this.$().height();if(this.getIsExpanded()){this._minScrollTop=0;this._marginTop=d-e.top;this._maxScrollTop=h*(this._getVisibleItems().length-1);i=$.height();this._marginBottom=i-this._marginTop-h;if(this._marginBottom<0){this._marginBottom=g-this._marginTop-h;}l.css("margin-top",this._marginTop);l.css("margin-bottom",this._marginBottom);}else{this._marginBottom=g-h;l.css("margin-top",0);l.css("margin-bottom",this._marginBottom);}this._selectionOffset=0;}if(!this.getIsExpanded()){this._selectionOffset=0;}this.$().attr('aria-expanded',this.getIsExpanded());this.setSelectedValue(s);};
a.prototype._getUpdatedCycleScrollTop=function(i,d,e,g,h){var j=d-e-i;while(j<g){e=e-d/h;j=d-e-i;}while(e<g){e=e+d/h;}return e;};
a.prototype._scrollerSnapped=function(i){var s=i,d=this._getVisibleItems().length,n;while(s>=d){s=s-d;}if(!this.getIsCyclic()){s=i;}n=this._getVisibleItems()[s].getKey();this.setSelectedValue(n);this._fireSelectedValueChange(n);};
a.prototype._updateScroll=function(){var s=this.getSelectedValue();if(s!==this._getVisibleItems()[0].getKey()&&this._getSliderContainerDomRef().scrollTop()+(this._selectionOffset?this._selectionOffset:0)===0){this.setSelectedValue(s);this._fireSelectedValueChange(s);}};
a.prototype._addSelectionStyle=function(){var $=this.$("content").find("li:not(.TPSliderItemHidden)"),s=$.eq(this._iSelectedItemIndex).text(),d,e;if(!s){return;}e=s;if(e&&e.length>1&&e.indexOf('0')===0){e=e.substring(1);}$.eq(this._iSelectedItemIndex).addClass("sapMTimePickerItemSelected");d=document.getElementById(this.getId()+"-valDescription");if(d.innerHTML!==e){d.innerHTML=e;}};
a.prototype._removeSelectionStyle=function(){var $=this.$("content").find("li:not(.TPSliderItemHidden)");$.eq(this._iSelectedItemIndex).removeClass("sapMTimePickerItemSelected");};
a.prototype._attachEvents=function(){var e=this._getSliderContainerDomRef()[0];if(D.system.combi){e.addEventListener("touchstart",q.proxy(o,this),false);e.addEventListener("touchmove",q.proxy(b,this),false);document.addEventListener("touchend",q.proxy(c,this),false);e.addEventListener("mousedown",q.proxy(o,this),false);document.addEventListener("mousemove",q.proxy(b,this),false);document.addEventListener("mouseup",q.proxy(c,this),false);}else{if(D.system.phone||D.system.tablet){e.addEventListener("touchstart",q.proxy(o,this),false);e.addEventListener("touchmove",q.proxy(b,this),false);document.addEventListener("touchend",q.proxy(c,this),false);}else{e.addEventListener("mousedown",q.proxy(o,this),false);document.addEventListener("mousemove",q.proxy(b,this),false);document.addEventListener("mouseup",q.proxy(c,this),false);}}};
a.prototype._detachEvents=function(){var e=this.getDomRef();if(D.system.combi){e.removeEventListener("touchstart",q.proxy(o,this),false);e.removeEventListener("touchmove",q.proxy(b,this),false);document.removeEventListener("touchend",q.proxy(c,this),false);e.removeEventListener("mousedown",q.proxy(o,this),false);document.removeEventListener("mousemove",q.proxy(b,this),false);document.removeEventListener("mouseup",q.proxy(c,this),false);}else{if(D.system.phone||D.system.tablet){e.removeEventListener("touchstart",q.proxy(o,this),false);e.removeEventListener("touchmove",q.proxy(b,this),false);document.removeEventListener("touchend",q.proxy(c,this),false);}else{e.removeEventListener("mousedown",q.proxy(o,this),false);document.removeEventListener("mousemove",q.proxy(b,this),false);document.removeEventListener("mouseup",q.proxy(c,this),false);}}};
a.prototype._offsetValue=function(i){var s=this._getSliderContainerDomRef(),d,e=this._getItemHeightInPx(),g,h,j=this.getIsCyclic(),k=this;this._stopAnimation();if(this._animatingSnap===true){this._animatingSnap=false;this._getSliderContainerDomRef().stop(true);if(this._animatingTargetIndex!==null){this._scrollerSnapped(this._animatingTargetIndex);this._animatingTargetIndex=null;}else if(this._iSelectedIndex!==-1){this._scrollerSnapped(this._iSelectedIndex);}}h=this._iSelectedItemIndex+i;d=s.scrollTop();g=d+i*e;if(!j){if(h<0||h>=this._getVisibleItems().length){return;}if(g>this._maxScrollTop){g=this._maxScrollTop;}if(g<this._minScrollTop){g=this._minScrollTop;}}this._animatingSnap=true;this._animatingTargetIndex=h;s.animate({scrollTop:g},S,'linear',function(){s.clearQueue();k._animatingSnap=false;k._animatingTargetIndex=null;if(s.css("visibility")==="visible"){k._scrollerSnapped(h);}});};
a.prototype._offsetSlider=function(O){var s=this._getSliderContainerDomRef().scrollTop(),d=this,$=d._getSliderContainerDomRef().height(),e=d.$("content").height(),i=200,g=$+i,h=d._getContentRepeat(),j=d.getIsCyclic(),k=d._getItemHeightInPx();s=s-O*k;if(j){s=d._getUpdatedCycleScrollTop($,e,s,g,h);}else{if(s>d._maxScrollTop){s=d._maxScrollTop;}if(s<d._minScrollTop){s=d._minScrollTop;}}d._getSliderContainerDomRef().scrollTop(s);d._iSelectedIndex=Math.round((s+d._selectionOffset)/k);d._scrollerSnapped(d._iSelectedIndex);};
a.prototype._initArrows=function(){var d=this,e,g,r=sap.ui.getCore().getLibraryResourceBundle("sap.m");e=new B({icon:I.getIconURI("slim-arrow-up"),press:function(E){d._offsetValue(-1);},tooltip:r.getText("TIMEPICKER_TOOLTIP_UP"),type:'Transparent'});e.addEventDelegate({onAfterRendering:function(){e.$().attr("tabindex",-1);}});this.setAggregation("_arrowUp",e);g=new B({icon:I.getIconURI("slim-arrow-down"),press:function(E){d._offsetValue(1);},tooltip:r.getText("TIMEPICKER_TOOLTIP_DOWN"),type:'Transparent'});g.addStyleClass("sapMTimePickerItemArrowDown");g.addEventDelegate({onAfterRendering:function(){g.$().attr("tabindex",-1);}});this.setAggregation("_arrowDown",g);};
a.prototype._convertNumPadToNumKeyCode=function(k){var d=K;if(k>=d.NUMPAD_0&&k<=d.NUMPAD_9){k-=48;}return k;};
function f(d,p){if(d==null){throw new TypeError('findIndex called with null or undefined array');}if(typeof p!=='function'){throw new TypeError('predicate must be a function');}var l=d.length;var e=arguments[1];var v;for(var i=0;i<l;i++){v=d[i];if(p.call(e,v,i,d)){return i;}}return-1;}
var o=function(e){var p=e.touches&&e.touches.length?e.touches[0].pageY:e.pageY;this._bIsDrag=false;if(!this.getIsExpanded()){return;}this._stopAnimation();this._startDrag(p);if(!D.system.desktop){e.preventDefault();}this._mousedown=true;};var b=function(e){var p=e.touches&&e.touches.length?e.touches[0].pageY:e.pageY;if(!this._mousedown||!this.getIsExpanded()){return;}if(!this._bIsDrag&&this._dragSession&&this._dragSession.positions.length){var d=this._dragSession.positions.some(function(g){return Math.abs(g.pageY-p)>5;});if(d){this._bIsDrag=true;}}this._doDrag(p,e.timeStamp);this._mousedown=true;};var c=function(e){var p=e.changedTouches&&e.changedTouches.length?e.changedTouches[0].pageY:e.pageY;if(this._bIsDrag===false){this.fireTap(e);this._dragSession=null;}this._bIsDrag=true;if(!this.getIsExpanded()){this._dragSession=null;return;}this._endDrag(p,e.timeStamp);this._mousedown=false;};var F=function(s){var i=this._getVisibleItems();var d=f(i,function(e){return e.getText()===s;});return i[d]?i[d].getKey():'';};var t=function(){var l=-1,i=-1,w=1000,s="",d=function(e,k){var m;if(l+w<e){s="";}else{if(i!==-1){clearTimeout(i);i=-1;}}s+=String.fromCharCode(k).toLowerCase();m=this._getVisibleItems().filter(function(g){return g.getKey().indexOf(s)===0;});if(m.length>1){i=setTimeout(function(){this.setSelectedValue(s);s="";i=-1;}.bind(this),w);}else if(m.length===1){this.setSelectedValue(m[0].getKey());s="";}else{s="";}l=e;};return d;};
a.prototype._getVisibleItems=function(){return this.getItems().filter(function(i){return i.getVisible();});};
a.prototype._setEnabled=function(e){this._bEnabled=e;if(e){this.$().removeClass("sapMTPDisabled");this.$().attr("tabindex",0);}else{this.$().addClass("sapMTPDisabled");this.$().attr("tabindex",-1);}return this;};
a.prototype._getEnabled=function(e){return this._bEnabled;};
a.prototype._fireSelectedValueChange=function(v){this.fireEvent("_selectedValueChange",{value:v});};
return a;});
sap.ui.predefine('sap/m/TimePickerSliderRenderer',[],function(){"use strict";var T={apiVersion:2};
T.render=function(r,c){var i,R,n=c._getContentRepeat(),I=c.getItems(),C=c.getLabel();r.openStart("div",c);r.attr("tabindex","0");r.class("sapMTPColumn");if(c.getIsExpanded()){r.class("sapMTPSliderExpanded");}if(!c.getIsCyclic()){r.class("sapMTimePickerSliderShort");}if(!c._getEnabled()){r.class("sapMTPDisabled");}r.accessibilityState(c,{role:"list",labelledby:{value:c.getId()+"-label",append:true},describedby:{value:c.getId()+"-valDescription",append:true}});r.openEnd();r.openStart("div",c.getId()+"-label");r.class("sapMTimePickerLabel");r.openEnd();r.text(C);r.close("div");r.openStart("div",c.getId()+"-valDescription");r.attr('aria-hidden','false');r.attr('aria-live','assertive');r.class("sapUiInvisibleText");r.openEnd();r.close("div");r.openStart("div");r.class("sapMTimePickerItemArrows");r.openEnd();r.renderControl(c.getAggregation("_arrowUp"));r.close("div");r.openStart("div");r.class("sapMTimePickerSlider");T.addItemValuesCssClass(r,c);r.attr("unselectable","on");r.openEnd();r.openStart("div");r.class("sapMTPPickerSelectionFrame");r.openEnd();r.close("div");r.openStart("ul",c.getId()+"-content");r.attr("unselectable","on");r.openEnd();for(R=1;R<=n;R++){for(i=0;i<I.length;i++){r.openStart("li");r.class("sapMTimePickerItem");if(!I[i].getVisible()){r.class("TPSliderItemHidden");}r.accessibilityState(c);r.attr("unselectable","on");r.openEnd();r.text(I[i].getText());r.close("li");}}r.close("ul");r.close("div");r.openStart("div");r.class("sapMTimePickerItemArrows");r.openEnd();r.renderControl(c.getAggregation("_arrowDown"));r.close("div");r.close("div");};
T.addItemValuesCssClass=function(r,c){var v=c.getItems().filter(function(i){return i.getVisible();}).length;if(v>2&&v<13){r.class("SliderValues"+v.toString());}};
return T;});
sap.ui.predefine('sap/m/TimePickerSliders',['sap/ui/core/library','sap/ui/core/Control','sap/ui/model/type/Date','sap/ui/model/odata/type/ODataType','sap/ui/core/format/DateFormat','./TimePickerSlidersRenderer','./TimePickerSlider','./VisibleItem','sap/ui/core/LocaleData','sap/ui/Device','sap/ui/core/Locale','./TimePickerSlidersRenderer',"sap/ui/thirdparty/jquery"],function(c,C,S,O,D,a,T,V,L,b,d,e,q){"use strict";var f=1,g=c.CalendarType;
var h=C.extend("sap.m.TimePickerSliders",{metadata:{library:"sap.m",properties:{localeId:{type:"string",group:"Data"},displayFormat:{name:"displayFormat",type:"string",group:"Appearance"},labelText:{name:"labelText",type:"string"},minutesStep:{type:"int",group:"Misc",defaultValue:f},secondsStep:{type:"int",group:"Misc",defaultValue:f},width:{type:"sap.ui.core.CSSSize",group:"Appearance"},height:{type:"sap.ui.core.CSSSize",group:"Appearance"},value:{type:"string",group:"Data",defaultValue:null},valueFormat:{type:"string",group:"Data",defaultValue:null},support2400:{type:"boolean",group:"Misc",defaultValue:false}},aggregations:{_columns:{type:"sap.m.TimePickerSlider",multiple:true,visibility:"hidden"}},events:{change:{parameters:{value:{type:"string"}}}}}});
h.prototype.init=function(){var l=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale(),o=L.getInstance(l),p=o.getDayPeriods("abbreviated"),i=o.getTimePattern("medium");this._fnLayoutChanged=q.proxy(this._onOrientationChanged,this);b.resize.attachHandler(this._fnLayoutChanged);this._sAM=p[0];this._sPM=p[1];this._onSliderExpanded=this._onSliderExpanded.bind(this);this._onSliderCollapsed=this._onSliderCollapsed.bind(this);this.setDisplayFormat(i);this._setTimeValues();this._iMinutes;this._iSeconds;};
h.prototype.exit=function(){this.$().off(!!b.browser.firefox?"DOMMouseScroll":"mousewheel",this._onmousewheel);b.resize.detachHandler(this._fnOrientationChanged);};
h.prototype.onAfterRendering=function(){this.$().off(!!b.browser.firefox?"DOMMouseScroll":"mousewheel",this._onmousewheel);this.$().on(!!b.browser.firefox?"DOMMouseScroll":"mousewheel",q.proxy(this._onmousewheel,this));this.$().on('selectstart',F);if(this._getShouldOpenSliderAfterRendering()){if(b.system.desktop){this._getFirstSlider().setIsExpanded(true);}}};
h.prototype.setLocaleId=function(l){var o,p;l=this.validateProperty("localeId",l);this.setProperty("localeId",l,true);if(l){o=new d(l);p=L.getInstance(o).getDayPeriods("abbreviated");this._sAM=p[0];this._sPM=p[1];this._destroyColumns();this._setupLists();}return this;};
h.prototype.setSupport2400=function(i){this.setProperty("support2400",i,true);this._destroyColumns();this._setupLists();return this;};
h.prototype.setDisplayFormat=function(i){this.setProperty("displayFormat",i,true);this._destroyColumns();this._setupLists();return this;};
h.prototype.setMinutesStep=function(v){v=Math.max(f,v||f);this.setProperty("minutesStep",v,true);this._destroyColumns();this._setupLists();return this;};
h.prototype.setSecondsStep=function(v){v=Math.max(f,v||f);this.setProperty("secondsStep",v,true);this._destroyColumns();this._setupLists();return this;};
h.prototype.setValue=function(v){var H=this._getHoursSlider(),i=this._getValueFormatPattern(),I=i.indexOf("HH"),j=i.indexOf("H"),k=H&&H.getSelectedValue()==="24",l=h._isHoursValue24(v,I,j);if(k&&this._isFormatSupport24()&&!l){v=h._replaceZeroHoursWith24(v,I,j);}v=this.validateProperty("value",v);this.setProperty("value",v,true);var o;if(v){o=this._parseValue(l?h._replace24HoursWithZero(v,I,j):v);}if(o){this._setTimeValues(o,l);}return this;};
h.prototype.getTimeValues=function(){var H=this._getHoursSlider(),m=this._getMinutesSlider(),o=this._getSecondsSlider(),i=this._getFormatSlider(),j=null,A=null,k=new Date();if(H){j=parseInt(H.getSelectedValue());}if(i){A=i.getSelectedValue();}if(A==="am"&&j===12){j=0;}else if(A==="pm"&&j!==12){j+=12;}if(j!==null){k.setHours(j.toString());}if(m){k.setMinutes(m.getSelectedValue());}if(o){k.setSeconds(o.getSelectedValue());}return k;};
h.prototype.collapseAll=function(){var i=this.getAggregation("_columns");if(i){for(var I=0;I<i.length;I++){if(i[I].getIsExpanded()){i[I].setIsExpanded(false);}}}return this;};
h.prototype.openFirstSlider=function(){var o=this._getFirstSlider();o.setIsExpanded(true);o.focus();return this;};
h.prototype._setTimeValues=function(o,H){var i=this._getHoursSlider(),m=this._getMinutesSlider(),j=this._getSecondsSlider(),k=this._getFormatSlider(),l,A=null;o=o||new Date();if(Object.prototype.toString.call(o)!=="[object Date]"||isNaN(o)){throw new Error("Date must be a JavaScript date object; "+this);}if(!H){var v=this._formatValue(o,true);this.setProperty("value",v,true);l=o.getHours();}else{l=24;}if(k){A=l>=12?"pm":"am";l=(l>12)?l-12:l;l=(l===0?12:l);}i&&i.setSelectedValue(l.toString());m&&m._updateStepAndValue(o.getMinutes(),this.getMinutesStep());j&&j._updateStepAndValue(o.getSeconds(),this.getSecondsStep());k&&k.setSelectedValue(A);if(H){this._disableSlider(m);m&&m.setSelectedValue("0");this._disableSlider(j);j&&j.setSelectedValue("0");}else{this._enableSlider(m);this._enableSlider(j);}};
h.prototype._updateSlidersValues=function(){var i=this.getAggregation("_columns");if(i){for(var I=0;I<i.length;I++){i[I]._updateScroll();}}};
h.prototype.onsaphome=function(E){var n=this._getFirstSlider(),o=this._getCurrentSlider();if(o&&document.activeElement===o.getDomRef()&&this._isSliderEnabled(n)){n.focus();}};
h.prototype.onsapend=function(E){var n=this._getLastSlider(),o=this._getCurrentSlider();if(o&&document.activeElement===o.getDomRef()&&this._isSliderEnabled(n)){n.focus();}};
h.prototype.onsapleft=function(E){var n,o=this._getCurrentSlider(),i=-1,N=-1,j=this.getAggregation("_columns");if(o&&document.activeElement===o.getDomRef()){i=j.indexOf(o);N=i>0?i-1:j.length-1;n=j[N];if(this._isSliderEnabled(n)){n.focus();}}};
h.prototype.onsapright=function(E){var n,o=this._getCurrentSlider(),i=-1,N=-1,j=this.getAggregation("_columns");if(o&&document.activeElement===o.getDomRef()){i=j.indexOf(o);N=i<j.length-1?i+1:0;n=j[N];if(this._isSliderEnabled(n)){n.focus();}}};
h.prototype._onmousewheel=function(E){var i=this._getCurrentSlider();if(i){i._onmousewheel(E);}};
h.prototype._onOrientationChanged=function(){var j=this.getAggregation("_columns");if(!j){return;}for(var i=0;i<j.length;i++){if(j[i].getIsExpanded()){j[i]._updateSelectionFrameLayout();}}};
h.prototype._generatePickerListValues=function(i,t,j,l){var v=[],k;for(var I=i;I<=t;I+=1){if(I<10&&l){k="0"+I.toString();}else{k=I.toString();}var o=new V({key:I.toString(),text:k});if(I%j!==0){o.setVisible(false);}v.push(o);}return v;};
h.prototype._checkStyle=function(p){return(p==="short"||p==="medium"||p==="long"||p==="full");};
h.prototype._getDisplayFormatPattern=function(){var p=this.getDisplayFormat();if(this._checkStyle(p)){p=this._getLocaleBasedPattern(p);}return p;};
h.prototype._getValueFormatPattern=function(){var p=this._getBoundValueTypePattern()||this.getValueFormat()||"medium";if(this._checkStyle(p)){p=this._getLocaleBasedPattern(p);}return p;};
h.prototype._getLocaleBasedPattern=function(p){return L.getInstance(sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale()).getTimePattern(p);};
h.prototype._destroyColumns=function(){var i=this.getAggregation("_columns");if(i){this.destroyAggregation("_columns");}};
h.prototype._setupLists=function(){var r=sap.ui.getCore().getLibraryResourceBundle("sap.m"),l=r.getText("TIMEPICKER_LBL_HOURS"),i=r.getText("TIMEPICKER_LBL_MINUTES"),j=r.getText("TIMEPICKER_LBL_SECONDS"),k=r.getText("TIMEPICKER_LBL_AMPM"),m=this.getMinutesStep(),n=this.getSecondsStep(),o=this._getDisplayFormatPattern();if(o===undefined){return;}var H=false,p=false,t,u;if(o.indexOf("HH")!==-1){H=true;t=0;u=this.getSupport2400()?24:23;p=true;}else if(o.indexOf("H")!==-1){H=true;t=0;u=this.getSupport2400()?24:23;}else if(o.indexOf("hh")!==-1){H=true;t=1;u=12;p=true;}else if(o.indexOf("h")!==-1){H=true;t=1;u=12;}if(H){this.addAggregation("_columns",new T(this.getId()+"-listHours",{items:this._generatePickerListValues(t,u,1,p),expanded:this._onSliderExpanded,collapsed:this._onSliderCollapsed,label:l}).attachEvent("_selectedValueChange",this._handleHoursChange,this));}if(o.indexOf("m")!==-1){var v=this._generatePickerListValues(0,59,m,true);this.addAggregation("_columns",new T(this.getId()+"-listMins",{items:v,expanded:this._onSliderExpanded,collapsed:this._onSliderCollapsed,label:i}));}if(o.indexOf("s")!==-1){var v=this._generatePickerListValues(0,59,n,true);this.addAggregation("_columns",new T(this.getId()+"-listSecs",{items:v,expanded:this._onSliderExpanded,collapsed:this._onSliderCollapsed,label:j}));}if(o.indexOf("a")!==-1){this.addAggregation("_columns",new T(this.getId()+"-listFormat",{items:[{key:"am",text:this._sAM},{key:"pm",text:this._sPM}],expanded:this._onSliderExpanded,collapsed:this._onSliderCollapsed,label:k,isCyclic:false}).addStyleClass("sapMTimePickerSliderShort"));}var w,x=this.getValue();if(x){w=this._parseValue(x);}if(w){this._setTimeValues(w);}};
h.prototype._getCurrentSlider=function(){var j=this.getAggregation("_columns");if(j){for(var i=0;i<j.length;i++){if(j[i].getIsExpanded()){return j[i];}}}return null;};
h.prototype._getHoursSlider=function(){return sap.ui.getCore().byId(this.getId()+"-listHours")||null;};
h.prototype._getMinutesSlider=function(){return sap.ui.getCore().byId(this.getId()+"-listMins")||null;};
h.prototype._getSecondsSlider=function(){return sap.ui.getCore().byId(this.getId()+"-listSecs")||null;};
h.prototype._getFormatSlider=function(){return sap.ui.getCore().byId(this.getId()+"-listFormat")||null;};
h.prototype._getFirstSlider=function(){return this.getAggregation("_columns")[0]||null;};
h.prototype._getLastSlider=function(){var i=this.getAggregation("_columns");return i[i.length-1]||null;};
h.prototype._parseValue=function(v){return this._getFormatter().parse(v);};
h.prototype._isSliderEnabled=function(o){return o._getEnabled();};
h.prototype._getFormatter=function(){var p=this._getBoundValueTypePattern(),r=false,B=this.getBinding("value"),i;if(B&&B.oType&&B.oType.oOutputFormat){r=!!B.oType.oOutputFormat.oFormatOptions.relative;i=B.oType.oOutputFormat.oFormatOptions.calendarType;}if(!p){p=this.getValueFormat()||"medium";i=g.Gregorian;}if(!i){i=sap.ui.getCore().getConfiguration().getCalendarType();}return this._getFormatterInstance(p,r,i);};
h.prototype._getBoundValueTypePattern=function(){var B=this.getBinding("value"),o=B&&B.getType&&B.getType();if(o instanceof S){return o.getOutputPattern();}if(o instanceof O&&o.oFormat){return o.oFormat.oFormatOptions.pattern;}return undefined;};
h.prototype._getFormatterInstance=function(p,r,i,j){var o;if(this._checkStyle(p)){o=this._getFormatInstance({style:p,strictParsing:true,relative:r,calendarType:i});}else{o=this._getFormatInstance({pattern:p,strictParsing:true,relative:r,calendarType:i});}return o;};
h.prototype._getFormatInstance=function(A,i){return D.getTimeInstance(A);};
h.prototype._formatValue=function(o){if(o){return this._getFormatter().format(o);}return"";};
h.prototype._onSliderExpanded=function(E){var j=this.getAggregation("_columns");for(var i=0;i<j.length;i++){if(j[i]!==E.oSource&&j[i].getIsExpanded()){j[i].setIsExpanded(false);}}};
h.prototype._onSliderCollapsed=function(E){var o=this.getTimeValues();this.setValue(this._formatValue(o,true));this.fireChange({value:this.getValue()});};
h.prototype._getShouldOpenSliderAfterRendering=function(){return this._shouldOpenSliderAfterRendering;};
h.prototype._setShouldOpenSliderAfterRendering=function(i){this._shouldOpenSliderAfterRendering=i;return this;};
h.prototype._isFormatSupport24=function(){var i=this._getDisplayFormatPattern();return i.indexOf("HH")!==-1||i.indexOf("H")!==-1;};
h.prototype._disableSlider=function(o){if(o){o._setEnabled(false);}return this;};
h.prototype._enableSlider=function(o){if(o){o._setEnabled(true);}return this;};
h.prototype._handleHoursChange=function(E){var v=E.getParameter("value"),m=this._getMinutesSlider(),o=this._getSecondsSlider();if(this.getSupport2400()){if(v==="24"){if(m&&m._getEnabled()){this._iMinutes=m.getSelectedValue();this._disableSlider(m);m.setSelectedValue("0");}if(o&&o._getEnabled()){this._iSeconds=o.getSelectedValue();this._disableSlider(o);o.setSelectedValue("0");}}else{if(m&&!m._getEnabled()){this._enableSlider(m);m.setSelectedValue(this._iMinutes);}if(o&&!o._getEnabled()){this._enableSlider(o);o.setSelectedValue(this._iSeconds);}}}};
h._replaceZeroHoursWith24=function(v,i,I){var H=2,j=i;if(i===-1){H=1;j=I;}return v.substr(0,j)+"24"+v.substr(j+H);};
h._replace24HoursWithZero=function(v,i,I){var H=2,j=i;if(i===-1){H=1;j=I;}return v.substr(0,j)+s(0,H)+v.substr(j+2);};
h._isHoursValue24=function(v,i,I){if(i===-1&&I===-1){return false;}var j=i;if(i===-1){j=I;}return v.substr(j,2)==="24";};
function s(j,k){var r="";for(var i=0;i<k;i++){r+=j;}return r;}
function F(){return false;}
return h;});
sap.ui.predefine('sap/m/TimePickerSlidersRenderer',["sap/ui/Device"],function(D){"use strict";var T={apiVersion:2};
T.render=function(r,c){var s=c.getAggregation("_columns"),l=c.getLabelText()||"",R=sap.ui.getCore().getLibraryResourceBundle("sap.m"),S,b=sap.ui.getCore().getConfiguration().getRTL();r.openStart("div",c);r.class("sapMTimePickerContainer");r.style("width",c.getWidth());r.style("height",c.getHeight());r.accessibilityState(c,{label:(l+" "+R.getText("TIMEPICKER_SCREENREADER_TAG")).trim()});r.openEnd();if(!D.system.desktop){r.openStart("div",c.getId()+"-label");r.class("sapMTimePickerContainerLabel");r.openEnd();r.style("display","block");r.text(l);r.close("div");}if(b){for(S=s.length-1;S>=0;S--){r.renderControl(s[S]);}}else{for(S=0;S<s.length;S++){r.renderControl(s[S]);}}r.close("div");};
return T;},true);
sap.ui.predefine('sap/m/Token',['./library','sap/ui/core/Control','sap/ui/core/library','sap/ui/core/Icon','./TokenRenderer','sap/ui/core/InvisibleText','sap/ui/events/KeyCodes','sap/ui/core/theming/Parameters','sap/ui/core/Core'],function(l,C,c,I,T,a,K,P,b){"use strict";var d=c.TextDirection;
var e=C.extend("sap.m.Token",{metadata:{library:"sap.m",properties:{selected:{type:"boolean",group:"Misc",defaultValue:false},key:{type:"string",group:"Misc",defaultValue:""},text:{type:"string",group:"Misc",defaultValue:""},editable:{type:"boolean",group:"Misc",defaultValue:true},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:d.Inherit},editableParent:{type:"boolean",group:"Behavior",defaultValue:true,visibility:"hidden"},truncated:{type:"boolean",group:"Appearance",defaultValue:false,visibility:"hidden"},posinset:{type:"int",visibility:"hidden"},setsize:{type:"int",visibility:"hidden"}},aggregations:{deleteIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{"delete":{enableEventBubbling:true},press:{},select:{},deselect:{}}}});
e.prototype.init=function(){var D=new I({id:this.getId()+"-icon",src:"sap-icon://decline",noTabStop:true,press:this._fireDeleteToken.bind(this)});D.addStyleClass("sapMTokenIcon");D.setUseIconTooltip(false);this.setAggregation("deleteIcon",D);};
e.prototype.ontouchstart=function(E){if(E.target.id===this.getId()+"-icon"){E.preventDefault();}};
e.prototype._getTooltip=function(o,E){var t=o.getTooltip_AsString(),D=b.getLibraryResourceBundle("sap.m").getText("TOKEN_ARIA_DELETABLE");if(E&&!t){return D;}return t;};
e.prototype._onTokenPress=function(E){var s=this.getSelected(),f=E.ctrlKey||E.metaKey,n=true;if(f||(E.which===K.SPACE)){n=!s;}this.setSelected(n);this.firePress();if(s!==n){if(n){this.fireSelect();}else{this.fireDeselect();}}if(this.getSelected()){this.focus();}};
e.prototype.ontap=function(E){var D=this.getAggregation("deleteIcon");if(D&&E.target.id===D.getId()){E.setMark("tokenDeletePress",true);return;}E.setMark("tokenTap",this);this._onTokenPress(E);};
e.prototype._fireDeleteToken=function(E,k,B){if(this.getEditable()&&this.getProperty("editableParent")){this.fireDelete({token:this,byKeyboard:k,backspace:B});}E.preventDefault();};
e.prototype.onsapspace=function(E){this._onTokenPress(E);if(E){E.preventDefault();E.stopPropagation();}};
e.prototype.onkeydown=function(E){if((E.ctrlKey||E.metaKey)&&E.which===K.SPACE){this.onsapspace(E);E.preventDefault();}};
e.prototype.getTruncated=function(){return this.getProperty("truncated");};
e.prototype.setTruncated=function(v){return this.setProperty("truncated",v);};
return e;});
sap.ui.predefine('sap/m/TokenRenderer',["sap/ui/core/library","sap/ui/core/InvisibleText"],function(c,I){"use strict";var T=c.TextDirection;var a={apiVersion:2};
a.render=function(r,C){var t=C._getTooltip(C,C.getEditable()&&C.getProperty("editableParent"));var d=C.getAggregation("deleteIcon");var A=[];var o={role:"option"};var p=C.getProperty("posinset");var s=C.getProperty("setsize");r.openStart("div",C).attr("tabindex","-1").class("sapMToken");if(C.getSelected()){r.class("sapMTokenSelected");}if(p!==undefined){r.attr("aria-posinset",C.getProperty("posinset"));}if(s!==undefined){r.attr("aria-setsize",C.getProperty("setsize"));}if(!C.getEditable()){r.class("sapMTokenReadOnly");}if(C.getTruncated()){r.class("sapMTokenTruncated");}if(t){r.attr("title",t);}A.push(I.getStaticId("sap.m","TOKEN_ARIA_LABEL"));if(C.getEditable()&&C.getProperty("editableParent")){A.push(I.getStaticId("sap.m","TOKEN_ARIA_DELETABLE"));}if(C.getSelected()){A.push(I.getStaticId("sap.m","TOKEN_ARIA_SELECTED"));}o.describedby={value:A.join(" "),append:true};r.accessibilityState(C,o);r.openEnd();a._renderInnerControl(r,C);if(C.getEditable()&&d){r.renderControl(d);}r.close("div");};
a._renderInnerControl=function(r,C){var t=C.getTextDirection();r.openStart("span").class("sapMTokenText");if(t!==T.Inherit){r.attr("dir",t.toLowerCase());}r.openEnd();var b=C.getText();if(b){r.text(b);}r.close("span");};
return a;},true);
sap.ui.predefine('sap/m/Tokenizer',['./library','sap/m/Button','sap/m/List','sap/m/StandardListItem','sap/m/ResponsivePopover','sap/ui/core/Core','sap/ui/core/Control','sap/ui/core/delegate/ScrollEnablement','sap/ui/Device','sap/ui/core/InvisibleText','sap/ui/core/ResizeHandler','./TokenizerRenderer',"sap/ui/dom/containsOrEquals","sap/ui/events/KeyCodes","sap/base/Log","sap/ui/core/EnabledPropagator","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/control"],function(l,B,L,S,R,C,c,d,D,I,e,T,f,K,g,E,q){"use strict";var h=l.TokenizerRenderMode,P=l.PlacementType,j=l.ListMode;
var k=c.extend("sap.m.Tokenizer",{metadata:{library:"sap.m",properties:{editable:{type:"boolean",group:"Misc",defaultValue:true},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},maxWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},renderMode:{type:"string",group:"Misc",defaultValue:h.Loose},hiddenTokensCount:{type:"int",group:"Misc",defaultValue:0,visibility:"hidden"}},defaultAggregation:"tokens",aggregations:{tokens:{type:"sap.m.Token",multiple:true,singularName:"token"},_tokensInfo:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{tokenChange:{parameters:{type:{type:"string"},token:{type:"sap.m.Token"},tokens:{type:"sap.m.Token[]"},addedTokens:{type:"sap.m.Token[]"},removedTokens:{type:"sap.m.Token[]"}}},tokenUpdate:{allowPreventDefault:true,parameters:{type:{type:"string"},addedTokens:{type:"sap.m.Token[]"},removedTokens:{type:"sap.m.Token[]"}}},tokenDelete:{parameters:{tokens:{type:"sap.m.Token[]"},keyCode:{type:"number"}}}}}});
var r=C.getLibraryResourceBundle("sap.m");E.apply(k.prototype,[true]);
k.prototype.init=function(){this.allowTextSelection(false);this._oTokensWidthMap={};this._oIndicator=null;this._oScroller=new d(this,this.getId()+"-scrollContainer",{horizontal:true,vertical:false,nonTouchScrolling:true});if(C.getConfiguration().getAccessibility()){var a=new I({text:r.getText("TOKENIZER_ARIA_CONTAIN_TOKEN")});this.setAggregation("_tokensInfo",a);}this.attachEvent("delete",function(o){var t=o.getSource();var s=this.getSelectedTokens();this.fireTokenChange({type:sap.m.Tokenizer.TokenChangeType.Removed,token:t,tokens:s.length?s:[t],addedTokens:[],removedTokens:s.length?s:[t]});this.fireTokenUpdate({type:sap.m.Tokenizer.TokenChangeType.Removed,addedTokens:[],removedTokens:s.length?s:[t]});this.fireEvent("tokenDelete",{tokens:[t]});},this);};
k.prototype._handleNMoreIndicatorPress=function(){this._togglePopup(this.getTokensPopup());};
k.prototype._getTokensList=function(){if(!this._oTokensList){this._oTokensList=new L({width:"auto",mode:j.Delete}).attachDelete(this._handleListItemDelete,this);}return this._oTokensList;};
k.prototype._setPopoverMode=function(m){var s={},p=this.getTokensPopup();switch(m){case j.Delete:s={showArrow:false,placement:P.VerticalPreferredBottom};break;default:s={showArrow:true,placement:P.Auto};break;}p.setShowArrow(s.showArrow);p.setPlacement(s.placement);this._getTokensList().setMode(m);};
k.prototype._fillTokensList=function(o,F){o.destroyItems();F=F?F:function(){return true;};this.getTokens().filter(F).forEach(function(t){o.addItem(this._mapTokenToListItem(t));},this);};
k.prototype._handleListItemDelete=function(o){var a,i,b,m=o.getParameter("listItem"),s=m&&m.data("tokenId"),t;t=this.getTokens().filter(function(n){return(n.getId()===s)&&n.getEditable();})[0];if(t){this.fireTokenUpdate({addedTokens:[],removedTokens:[t],type:k.TokenUpdateType.Removed});this.fireTokenDelete({tokens:[t]});a=this._getTokensList().getItems();b=a.indexOf(m);i=(b===a.length-1)?a[a.length-2]:a[b+1];i&&i.focus();m.destroy();this._adjustTokensVisibility();}};
k.prototype.getTokensPopup=function(){if(this._oPopup){return this._oPopup;}this._oPopup=new R({showArrow:false,showHeader:false,placement:P.Auto,offsetX:0,offsetY:3,horizontalScrolling:false,content:this._getTokensList()}).attachBeforeOpen(function(){var w=this.getEditable()?120:0,p=this._oPopup;if(p.getContent&&!p.getContent().length){p.addContent(this._getTokensList());}this._fillTokensList(this._getTokensList());w+=Object.keys(this._oTokensWidthMap).map(function(s){return this._oTokensWidthMap[s];},this).sort(function(a,b){return a-b;}).pop()||0;p.setContentWidth(w+"px");},this);this.addDependent(this._oPopup);if(D.system.phone){this._oPopup.setEndButton(new B({text:r.getText("SUGGESTIONSPOPOVER_CLOSE_BUTTON"),press:function(){this._oPopup.close();}.bind(this)}));}return this._oPopup;};
k.prototype._togglePopup=function(p){var o,a=this.getDomRef(),b=p.isOpen(),i=this.getEditable();this._setPopoverMode(i?j.Delete:j.None);if(b){p.close();}else{o=i||this.hasOneTruncatedToken()?a:this._oIndicator[0];o=o&&o.className.indexOf("sapUiHidden")===-1?o:a;p.openBy(o||a);}};
k.prototype._mapTokenToListItem=function(t){if(!t){return null;}var o=new S({selected:true}).data("tokenId",t.getId());o.setTitle(t.getText());return o;};
k.prototype._getPixelWidth=function(){var m=this.getMaxWidth(),t,o=this.getDomRef(),p;if(!o){return;}p=parseInt(this.$().css("padding-left"));if(m.indexOf("px")===-1){t=o.clientWidth;}else{t=parseInt(this.getMaxWidth());}return t-p;};
k.prototype._adjustTokensVisibility=function(){if(!this.getDomRef()){return;}var t=this._getPixelWidth(),a=this._getVisibleTokens().reverse(),i=a.length,b,F,m,n=-1;a.some(function(o,p){t=t-this._oTokensWidthMap[o.getId()];if(t<0){n=p;return true;}else{F=t;}},this);if(i===1&&n!==-1){this.setFirstTokenTruncated(true);return;}else if(i===1&&a[0].getTruncated()){this.setFirstTokenTruncated(false);}if(n>-1){for(m=0;m<i;m++){if(m>=n){a[m].addStyleClass("sapMHiddenToken");}else{a[m].removeStyleClass("sapMHiddenToken");}}this._handleNMoreIndicator(i-n);b=this._oIndicator.width();if(b>=F){n=n-1;this._handleNMoreIndicator(i-n);a[n].addStyleClass("sapMHiddenToken");}this._setHiddenTokensCount(i-n);}else{this._setHiddenTokensCount(0);this._showAllTokens();}};
k.prototype.setFirstTokenTruncated=function(v){var t=this.getTokens()[0];t&&t.setTruncated(v);if(v){this.addStyleClass("sapMTokenizerOneLongToken");}else{this.removeStyleClass("sapMTokenizerOneLongToken");this.scrollToEnd();}return this;};
k.prototype.hasOneTruncatedToken=function(){return this.getTokens().length===1&&this.getTokens()[0].getTruncated();};
k.prototype._handleNMoreIndicator=function(H){if(!this.getDomRef()){return this;}if(H){var s="MULTIINPUT_SHOW_MORE_TOKENS";if(H===this._getVisibleTokens().length){if(H===1){s="TOKENIZER_SHOW_ALL_ITEM";}else{s="TOKENIZER_SHOW_ALL_ITEMS";}}this._oIndicator.html(r.getText(s,H));}return this;};
k.prototype._getVisibleTokens=function(){return this.getTokens().filter(function(t){return t.getVisible();});};
k.prototype._showAllTokens=function(){this._getVisibleTokens().forEach(function(t){t.removeStyleClass("sapMHiddenToken");});};
k.prototype.getScrollDelegate=function(){return this._oScroller;};
k.prototype.scrollToEnd=function(){var a=this.getDomRef(),s;if(!this.getDomRef()){return;}s=this.$().find(".sapMTokenizerScrollContainer")[0];if(D.browser.msie){setTimeout(function(){a.scrollLeft=s.scrollWidth;});}else{a.scrollLeft=s.scrollWidth;}};
k.prototype._registerResizeHandler=function(){if(!this._sResizeHandlerId){this._sResizeHandlerId=e.register(this.getDomRef(),this._handleResize.bind(this));}};
k.prototype._handleResize=function(){this._useCollapsedMode(this.getRenderMode());this.scrollToEnd();};
k.prototype.setPixelWidth=function(n){if(typeof n!=="number"){g.warning("Tokenizer.setPixelWidth called with invalid parameter. Expected parameter of type number.");return;}this.setWidth(n+"px");if(this._oScroller){this._oScroller.refresh();}};
k.prototype.scrollToStart=function(){var a=this.getDomRef();if(!a){return;}a.scrollLeft=0;};
k.prototype.getScrollWidth=function(){if(!this.getDomRef()){return 0;}return this.$().children(".sapMTokenizerScrollContainer")[0].scrollWidth;};
k.prototype.onBeforeRendering=function(){var t=this.getTokens();if(t.length===0){this.setFirstTokenTruncated(false);}t.forEach(function(o,i){o.setProperty("editableParent",this.getEditable()&&this.getEnabled(),true);o.setProperty("posinset",i+1,true);o.setProperty("setsize",t.length,true);},this);this._setTokensAria();};
k.prototype.onAfterRendering=function(){var s=this.getRenderMode();this._oIndicator=this.$().find(".sapMTokenizerIndicator");if(C.isThemeApplied()){this._storeTokensSizes();}this._useCollapsedMode(s);this._registerResizeHandler();if(s===h.Loose){this.scrollToEnd();}};
k.prototype.onThemeChanged=function(){this._storeTokensSizes();this._useCollapsedMode(this.getRenderMode());};
k.prototype._storeTokensSizes=function(){var t=this.getTokens();t.forEach(function(o){if(o.getDomRef()&&!o.$().hasClass("sapMHiddenToken")&&!o.getTruncated()){this._oTokensWidthMap[o.getId()]=o.$().outerWidth(true);}},this);};
k.prototype._useCollapsedMode=function(s){var t=this._getVisibleTokens();if(!t.length){return;}if(s===h.Narrow){this._adjustTokensVisibility();}else{this._setHiddenTokensCount(0);this._showAllTokens();}};
k.prototype.onsapfocusleave=function(o){if(document.activeElement===this.getDomRef()||!this._checkFocus()){this._changeAllTokensSelection(false);this._oSelectionOrigin=null;}};
k.prototype.onsapbackspace=function(o){var s=this.getSelectedTokens();var F=this.getTokens().filter(function(t){return t.getFocusDomRef()===document.activeElement;})[0];var a=s.length?s:[F];o.preventDefault();return this.fireTokenDelete({tokens:a,keyCode:o.which});};
k.prototype.onsapdelete=k.prototype.onsapbackspace;
k.prototype.onkeydown=function(o){var s;if(!this.getEnabled()){return;}if(o.which===K.TAB){this._changeAllTokensSelection(false);}if((o.ctrlKey||o.metaKey)&&o.which===K.A){s=this.getSelectedTokens().length<this._getVisibleTokens().length;if(this._getVisibleTokens().length>0){this.focus();this._changeAllTokensSelection(s);o.preventDefault();o.stopPropagation();}}if((o.ctrlKey||o.metaKey)&&(o.which===K.C||o.which===K.INSERT)){this._copy();}if(((o.ctrlKey||o.metaKey)&&o.which===K.X)||(o.shiftKey&&o.which===K.DELETE)){if(this.getEditable()){this._cut();}else{this._copy();}}};
k.prototype.onsappreviousmodifiers=function(o){this.onsapprevious(o);};
k.prototype.onsapnextmodifiers=function(o){this.onsapnext(o);};
k.prototype.onsaphomemodifiers=function(o){this._selectRange(false);};
k.prototype.onsapendmodifiers=function(o){this._selectRange(true);};
k.prototype._selectRange=function(F){var o={},t=this._getVisibleTokens(),a=q(document.activeElement).control()[0],b=t.indexOf(a);if(!a||!a.isA("sap.m.Token")){return;}if(F){o.start=b;o.end=t.length-1;}else{o.start=0;o.end=b;}if(o.start<o.end){for(var i=o.start;i<=o.end;i++){t[i].setSelected(true);}}};
k.prototype._copy=function(){this._fillClipboard("copy");};
k.prototype._fillClipboard=function(s){var a=this.getSelectedTokens();var t=a.map(function(o){return o.getText();}).join("\r\n");var b=function(o){if(o.clipboardData){o.clipboardData.setData('text/plain',t);}else{o.originalEvent.clipboardData.setData('text/plain',t);}o.preventDefault();};if(D.browser.msie&&window.clipboardData){window.clipboardData.setData("text",t);}else{document.addEventListener(s,b);document.execCommand(s);document.removeEventListener(s,b);}};
k.prototype._cut=function(){var s=this.getSelectedTokens();this._fillClipboard("cut");this.fireTokenChange({type:sap.m.Tokenizer.TokenChangeType.Removed,token:s,tokens:s,addedTokens:[],removedTokens:s});this.fireTokenUpdate({type:sap.m.Tokenizer.TokenChangeType.Removed,addedTokens:[],removedTokens:s});this.fireTokenDelete({tokens:s});};
k.prototype._ensureTokenVisible=function(t){if(!t||!t.getDomRef()||!this.getDomRef()){return;}var i=this.$().offset().left,a=this.$().width(),b=t.$().offset().left,m=t.$().width();if(this._getVisibleTokens().indexOf(t)===0){this.$().scrollLeft(0);return;}if(b<i){this.$().scrollLeft(this.$().scrollLeft()-i+b);}if(b-i+m>a){this.$().scrollLeft(this.$().scrollLeft()+(b-i+m-a));}};
k.prototype.ontap=function(o){var s=o.shiftKey,b=(o.ctrlKey||o.metaKey),t=o.getMark("tokenTap"),a=o.getMark("tokenDeletePress"),m=this._getVisibleTokens(),n=m[m.length-1],F,p,u,M,v;if(a||!t||(!s&&b)){this._oSelectionOrigin=null;return;}if(D.browser.msie&&t===n){this.scrollToEnd();}if(!s){this._oSelectionOrigin=t;this._changeAllTokensSelection(false,t,true);}F=t;if(this._oSelectionOrigin){F=this._oSelectionOrigin;}else{this._oSelectionOrigin=F;}p=this.indexOfToken(F);u=this.indexOfToken(t);M=Math.min(p,u);v=Math.max(p,u);m.forEach(function(w,i){if(i>=M&&i<=v){w.setSelected(true);}else if(!b){w.setSelected(false);}});};
k.prototype.onsapprevious=function(o){var t=this._getVisibleTokens(),i=t.length;if(i===0){return;}var F=q(document.activeElement).control()[0];var a=F?t.indexOf(F):-1;if(a===0){o.setMarked("forwardFocusToParent");return;}var b,m;if(a>0){b=t[a-1];b.focus();}else{b=t[t.length-1];b.focus({preventScroll:true});}if(o.shiftKey){m=t[a];b.setSelected(true);m.setSelected(true);}o.setMarked();o.preventDefault();};
k.prototype.onsapnext=function(o){var t=this._getVisibleTokens(),i=t.length;if(i===0){return;}var F=q(document.activeElement).control()[0];var a=F?t.indexOf(F):-1;if(a<i-1){var n=t[a+1],b=t[a];n.focus();if(o.shiftKey){n.setSelected(true);b.setSelected(true);}this._ensureTokenVisible(n);}else{o.setMarked("forwardFocusToParent");return;}o.setMarked();o.preventDefault();};
k.prototype.addValidator=function(v){g.warning("[Warning]:","You are attempting to use deprecated method 'addValidator()', please use MultiInput.prototype.addValidator instead.",this);};
k.prototype.removeValidator=function(v){g.warning("[Warning]:","You are attempting to use deprecated method 'addValidator()', please use MultiInput.prototype.addValidator instead.",this);};
k.prototype.removeAllValidators=function(){g.warning("[Warning]:","You are attempting to use deprecated method 'addValidator()', please use MultiInput.prototype.addValidator instead.",this);};
k.prototype.addValidateToken=function(p){g.warning("[Warning]:","You are attempting to use deprecated method 'addValidator()', please use MultiInput.prototype.addValidator instead.",this);};
k.prototype._parseString=function(s){return s.split(/\r\n|\r|\n/g);};
k.prototype._checkFocus=function(){return this.getDomRef()&&f(this.getDomRef(),document.activeElement);};
k.prototype.selectAllTokens=function(s){if(s===undefined){s=true;}this._changeAllTokensSelection(s);return this;};
k.prototype._changeAllTokensSelection=function(s,t,b){var a=this._getVisibleTokens();a.filter(function(o){return o!==t;}).forEach(function(o){o.setSelected(s);});if(!b){this._doSelect();}return this;};
k.prototype.getSelectedTokens=function(){return this._getVisibleTokens().filter(function(t){return t.getSelected();});};
k.prototype.onsaphome=function(o){var a=this.getTokens().filter(function(t){return t.getDomRef()&&!t.getDomRef().classList.contains("sapMHiddenToken");});a.length&&a[0].focus();this.scrollToStart();o.preventDefault();};
k.prototype.onsapend=function(o){var t=this._getVisibleTokens(),a=t[t.length-1];if(a.getDomRef()!==document.activeElement){a.focus();this.scrollToEnd();o.stopPropagation();}else{o.setMarked("forwardFocusToParent");}o.preventDefault();};
k.prototype.onclick=function(o){var F;if(!this.getEnabled()){return;}F=!this.hasStyleClass("sapMTokenizerIndicatorDisabled")&&(o.target===this.getFocusDomRef()||o.target.classList.contains("sapMTokenizerIndicator"));if(F){this._handleNMoreIndicatorPress();}};
k.prototype.ontouchstart=function(o){o.setMarked();if(D.browser.chrome&&window.getSelection()){window.getSelection().removeAllRanges();}};
k.prototype.exit=function(){this._deregisterResizeHandler();if(this._oTokensList){this._oTokensList.destroy();this._oTokensList=null;}if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}if(this._oPopup){this._oPopup.destroy();this._oPopup=null;}this._oTokensWidthMap=null;this._oIndicator=null;this._aTokenValidators=null;};
k.prototype._deregisterResizeHandler=function(){if(this._sResizeHandlerId){e.deregister(this._sResizeHandlerId);delete this._sResizeHandlerId;}};
k.prototype._setTokensAria=function(){var t=this._getVisibleTokens().length;var i;var s="";var a="";var o={0:"TOKENIZER_ARIA_CONTAIN_TOKEN",1:"TOKENIZER_ARIA_CONTAIN_ONE_TOKEN"};if(C.getConfiguration().getAccessibility()){i=this.getAggregation("_tokensInfo");a=o[t]?o[t]:"TOKENIZER_ARIA_CONTAIN_SEVERAL_TOKENS";s=r.getText(a,t);i.setText(s);}};
k.prototype._doSelect=function(){if(this._checkFocus()&&this._bCopyToClipboardSupport){var F=document.activeElement;var s=window.getSelection();s.removeAllRanges();if(this.getSelectedTokens().length){var o=document.createRange();o.selectNodeContents(this.getDomRef("clip"));s.addRange(o);}if(window.clipboardData&&F.id===this.getId()+"-clip"&&this.getDomRef()){this.getDomRef().focus();}}};
k.prototype._setHiddenTokensCount=function(i){i=this.validateProperty("hiddenTokensCount",i);return this.setProperty("hiddenTokensCount",i);};
k.prototype.getHiddenTokensCount=function(){return this.getProperty("hiddenTokensCount");};
k.prototype.getTokensInfoId=function(){return this.getAggregation("_tokensInfo").getId();};
k.prototype._handleBackspace=function(i,F){var t=this.getTokens();if(t[i-1]){return t[i-1].focus();}return F();};
k.prototype._handleDelete=function(i,F){var t=this.getTokens();if(t[i+1]){return t[i+1].focus();}return F();};
k.prototype.focusToken=function(i,o,F){var t=this.getTokens();var b=o.keyCode;var a=o.keyCode===K.BACKSPACE;if(t.length===0){return;}if(!b){return;}if(a){return this._handleBackspace(i,F);}return this._handleDelete(i,F);};
k.TokenChangeType={Added:"added",Removed:"removed",RemovedAll:"removedAll",TokensChanged:"tokensChanged"};k.TokenUpdateType={Added:"added",Removed:"removed"};return k;});
sap.ui.predefine('sap/m/TokenizerRenderer',['sap/ui/Device','sap/ui/core/InvisibleText'],function(D,I){"use strict";var T={apiVersion:2};
T.render=function(r,c){if(c.getParent()&&(c.getParent()instanceof sap.m.MultiInput||c.getParent()instanceof sap.m.MultiComboBox)){r.openStart("div",c);}else{r.openStart("div",c).attr("tabindex","0");}r.class("sapMTokenizer");if(!c.getEditable()){r.class("sapMTokenizerReadonly");}if(!c.getEnabled()){r.class("sapMTokenizerDisabled");}var t=c.getTokens();if(!t.length){r.class("sapMTokenizerEmpty");}r.style("max-width",c.getMaxWidth());var p=c.getWidth();if(p){r.style("width",p);}var a={role:"listbox"};a.labelledby={value:I.getStaticId("sap.m","TOKENIZER_ARIA_LABEL"),append:true};r.accessibilityState(c,a);r.openEnd();r.renderControl(c.getAggregation("_tokensInfo"));c._bCopyToClipboardSupport=false;if((D.system.desktop||D.system.combi)&&t.length){r.openStart("div",c.getId()+"-clip").class("sapMTokenizerClip");if(window.clipboardData){r.attr("contenteditable","true");r.attr("tabindex","-1");}r.openEnd();r.unsafeHtml("&nbsp");r.close("div");c._bCopyToClipboardSupport=true;}r.openStart("div",c.getId()+"-scrollContainer");r.class("sapMTokenizerScrollContainer");r.openEnd();T._renderTokens(r,c);r.close("div");T._renderIndicator(r,c);r.close("div");};
T._renderTokens=function(r,c){var i=0,t=c.getTokens(),l=t.length;for(i=0;i<l;i++){r.renderControl(t[i]);}};
T._renderIndicator=function(r,c){r.openStart("span");r.class("sapMTokenizerIndicator");if(c.getHiddenTokensCount()===0){r.class("sapUiHidden");}r.openEnd().close("span");};
return T;},true);
sap.ui.predefine('sap/m/ValueStateHeader',["./library","sap/ui/core/library","sap/ui/Device","sap/ui/core/Core","sap/ui/core/Control"],function(l,c,D,C,a){"use strict";var V=c.ValueState;
var b=a.extend("sap.m.ValueStateHeader",{
metadata:{library:"sap.m",properties:{text:{type:"string",defaultValue:""},valueState:{type:"sap.ui.core.ValueState",defaultValue:V.None}},aggregations:{formattedText:{type:"sap.m.FormattedText",multiple:false}},associations:{popup:{type:"sap.ui.core.Popup",multiple:false}}},
renderer:{apiVersion:2,render:function(r,o){var m={None:"",Error:"sapMValueStateHeaderError",Warning:"sapMValueStateHeaderWarning",Success:"sapMValueStateHeaderSuccess",Information:"sapMValueStateHeaderInformation"};r.openStart("div",o).class("sapMValueStateHeaderRoot").class(m[o.getValueState()]).openEnd();r.openStart("span",o.getId()+"-inner").class("sapMValueStateHeaderText").openEnd();if(o.getFormattedText()){r.renderControl(o.getFormattedText());}else{r.text(o.getText());}r.close("span");r.close("div");}}
});
b.prototype._fnOrientationChange=function(){var p=this._getAssociatedPopupObject(),h=this.getDomRef();if(h&&p&&p.isA("sap.m.Dialog")){h.style.width=p.getDomRef().getBoundingClientRect().width+"px";}};
b.prototype.init=function(){D.orientation.attachHandler(this._fnOrientationChange,this);};
b.prototype.exit=function(){D.orientation.detachHandler(this._fnOrientationChange,this);};
b.prototype.setPopup=function(p){var t=this;var r=false;var P=(typeof p==="string")?C.byId(p):p;this.setAssociation("popup",P);if(P.isA("sap.m.Dialog")){return this;}P._afterAdjustPositionAndArrowHook=function(){var d=t.getDomRef();if(!d){return;}d.style.width=P.getDomRef().getBoundingClientRect().width+"px";d.style.height="auto";if(!r){r=true;setTimeout(function(){P._fnOrientationChange();},0);}};return this;};
b.prototype._getAssociatedPopupObject=function(){return C.byId(this.getPopup());};
b.prototype.onAfterRendering=function(){var p=this._getAssociatedPopupObject();if(p){this.getDomRef().style.width=p.getDomRef().getBoundingClientRect().width+"px";if(p.isA("sap.m.Popover")){setTimeout(function(){p._fnOrientationChange();},0);}}};
return b;},true);
sap.ui.predefine('sap/m/VisibleItem',['./library','sap/ui/core/Item',"sap/ui/thirdparty/jquery"],function(l,I,q){"use strict";
var V=I.extend("sap.m.VisibleItem",{metadata:{library:"sap.m",properties:{visible:{type:"boolean",group:"Behavior",defaultValue:true}}}});
V.prototype._getRefs=function(){var p=this.getParent(),$,t=this;if(p&&p.$("content")){$=p.$("content").find("li").filter(function(){return q(this).html()===t.getText();});}return $;};
V.prototype.setVisible=function(v){if(this.getVisible()===v){return;}var $=this._getRefs();if($){if(v){$.removeClass('TPSliderItemHidden');}else{$.addClass('TPSliderItemHidden');}}return this.setProperty('visible',v,true);};
return V;});
sap.ui.predefine('sap/m/inputUtils/completeTextSelected',[],function(){"use strict";var c=function(i){var v=i&&i.value&&i.value.length;if(!i||!v||i.selectionStart!==0||i.selectionEnd!==v){return false;}return true;};return c;});
sap.ui.predefine('sap/m/inputUtils/highlightDOMElements',["sap/m/inputUtils/wordStartsWithValue","sap/base/security/encodeXML"],function(w,e){"use strict";var _=function(i,I,W){var d,s,a,n,c,t=i?i.textContent:"",f="";if(!w(t,I)){return e(t);}I=I.toLowerCase();a=I.length;while(w(t,I)){d=t.toLowerCase();s=d.indexOf(I);s=(s>0)?d.indexOf(' '+I)+1:s;c=t.substring(0,s);t=t.substring(s);f+=e(c);c=t.substring(0,a);t=t.substring(a);f+='<span class="sapMInputHighlight">'+e(c)+'</span>';n=t.indexOf(" ");n=n===-1?t.length:n;c=t.substring(0,n);t=t.substring(n);f+=e(c);if(!W){break;}}if(t){f+=e(t);}return f;};var h=function(I,s,W){var i;if(!I&&!I.length){return;}var a=[];for(i=0;i<I.length;i++){a.push(_(I[i],s,W));}for(i=0;i<I.length;i++){I[i].innerHTML=a[i];}};return h;});
sap.ui.predefine('sap/m/inputUtils/inputsDefaultFilter',["sap/m/inputUtils/wordStartsWithValue"],function(w){"use strict";var d=function(v,i,f){if(!i){return false;}if(i.isA("sap.ui.core.ListItem")&&f&&w(i.getAdditionalText(),v)){return true;}return w(i.getText(),v);};return d;});
sap.ui.predefine('sap/m/inputUtils/scrollToItem',[],function(){"use strict";var s=function(i,p){var I=i&&i.getDomRef&&i.getDomRef(),P=p&&p.getDomRef&&p.getDomRef('cont');if(!P||!I){return;}var a=P.scrollTop,b=I.offsetTop,c=P.clientHeight,d=I.offsetHeight;if(a>b){P.scrollTop=b;}else if((b+d)>(a+c)){P.scrollTop=Math.ceil(b+d-c);}};return s;});
sap.ui.predefine('sap/m/inputUtils/wordStartsWithValue',[],function(){"use strict";var w=function(t,v){var i;if(!t||typeof t!=="string"||typeof v!=="string"){return false;}while(t){if(t.toLowerCase().indexOf(v.toLowerCase())===0){return true;}i=t.indexOf(' ');if(i===-1){break;}t=t.substring(i+1);}return false;};return w;});
sap.ui.predefine('sap/ui/core/SeparatorItem',['./Item','./library'],function(I,l){"use strict";
var S=I.extend("sap.ui.core.SeparatorItem",{metadata:{library:"sap.ui.core"}});
return S;});
sap.ui.predefine('sap/ui/dom/jquery/cursorPos',['sap/ui/thirdparty/jquery'],function(q){"use strict";var c=function a(p){var l=arguments.length,t,T;t=this.prop("tagName");T=this.prop("type");if(this.length===1&&((t=="INPUT"&&(T=="text"||T=="password"||T=="search"))||t=="TEXTAREA")){var d=this.get(0);if(l>0){if(typeof(d.selectionStart)=="number"){d.focus();d.selectionStart=p;d.selectionEnd=p;}return this;}else{if(typeof(d.selectionStart)=="number"){return d.selectionStart;}return-1;}}else{return this;}};q.fn.cursorPos=c;return q;});
sap.ui.predefine('sap/ui/dom/jquery/getSelectedText',['sap/ui/thirdparty/jquery'],function(q){"use strict";var g=function(){var d=this.get(0);try{if(typeof d.selectionStart==="number"){return d.value.substring(d.selectionStart,d.selectionEnd);}}catch(e){}return"";};q.fn.getSelectedText=g;return q;});
sap.ui.predefine('sap/ui/dom/jquery/selectText',['sap/ui/thirdparty/jquery'],function(q){"use strict";var s=function a(S,E){var d=this.get(0);try{if(typeof(d.selectionStart)==="number"){d.setSelectionRange(S>0?S:0,E);}}catch(e){}return this;};q.fn.selectText=s;return q;});
sap.ui.predefine('sap/ui/integration/designtime/editor/CardEditor',["sap/ui/core/Control","sap/ui/core/Core","sap/base/util/deepClone","sap/base/util/merge","sap/ui/integration/widgets/Card","sap/ui/integration/Designtime","sap/ui/model/json/JSONModel","sap/ui/integration/util/CardMerger","sap/m/Label","sap/m/Title","sap/ui/core/Icon","sap/m/ResponsivePopover","sap/m/Text","sap/base/Log","sap/ui/core/Popup","sap/base/i18n/ResourceBundle","sap/ui/thirdparty/URI","sap/ui/dom/includeStylesheet","sap/base/util/LoaderExtensions","sap/ui/core/theming/Parameters"],function(C,b,d,m,c,D,J,e,L,T,I,R,f,g,P,h,U,k,l,p){"use strict";
function q(s){if(s&&s.nodeType!==1){return 0;}var z=parseInt(window.getComputedStyle(s).getPropertyValue('z-index'));if(isNaN(z)){return q(s.parentNode);}return z+1;}
var r=/\{\{(?!parameters.)(?!destinations.)([^\}\}]+)\}\}/g,t=5000,u=b.getLibraryResourceBundle("sap.ui.integration");
var v=C.extend("sap.ui.integration.designtime.editor.CardEditor",{
metadata:{library:"sap.ui.integration",properties:{card:{type:"any",defaultValue:null},mode:{type:"string",defaultValue:"admin"},language:{type:"string",defaultValue:""},allowDynamicValues:{type:"boolean",defaultValue:false},allowSettings:{type:"boolean",defaultValue:false},designtime:{type:"object"}},aggregations:{_formContent:{type:"sap.ui.core.Control",multiple:true,visibility:"hidden"},_preview:{type:"sap.ui.integration.designtime.editor.CardPreview",multiple:false,visibility:"hidden"}},events:{ready:{}}},
renderer:function(o,a){o.openStart("div");a.getMode()==="translation"?o.addClass("sapUiIntegrationCardEditorTranslation"):o.addClass("sapUiIntegrationCardEditorPreview");o.addClass("sapUiIntegrationCardEditor");o.writeClasses();o.writeElementData(a);o.openEnd();if(a.isReady()){o.openStart("div");o.addClass("sapUiIntegrationCardEditorForm");if(a.getMode()!=="translation"){o.addClass("settingsButtonSpace");}o.writeClasses();o.openEnd();var j=a.getAggregation("_formContent");if(j){var n,s=0;for(var i=0;i<j.length;i++){var x=j[i];if(x.isA("sap.m.Label")){n=x;continue;}o.openStart("div");o.addClass("sapUiIntegrationCardEditorItem");if(a.getMode()==="translation"){o.addClass("language");}if(x._cols===1){o.addClass("sapUiIntegrationCardEditorItemCol"+(++s));}else{s=0;}o.writeClasses();o.openEnd();if(x.isA("sap.m.Title")){o.renderControl(x);}else{if(n){var y=n.getDependents()&&n.getDependents()[0];o.openStart("div");o.addClass("sapUiIntegrationCardEditorItemLabel");if(y&&a.getMode()!=="translation"){o.addClass("description");}o.openEnd();o.renderControl(n);if(y){o.renderControl(y);}o.close("div");}o.renderControl(x);}o.close("div");n=null;s=s==2?0:s;}}o.close("div");var z=a.getAggregation("_preview");z&&o.renderControl(z);}o.close("div");}
});
v.prototype.init=function(){this._ready=false;this._aFieldReadyPromise=[];this._oResourceBundle=u;this._appliedLayerManifestChanges=[];this._currentLayerManifestChanges={};this._mDestinationDataProviders={};};
v.prototype.isReady=function(){return this._ready;};
function w(o,s,a,i){i=i||"";a=a||[];if(typeof o==="object"){if(!o[s]){for(var n in o){w(o[n],s,a,i+"/"+n);}}else{if(o.type){a.push({path:o.pathvalue||i.substring(1),value:o.pathvalue||"{context>"+i.substring(1)+"/value}",object:o});}else{a.push({path:i.substring(1),object:o});for(var n in o){w(o[n],s,a,i+"/"+n);}}}}return a;}
v.prototype._filterManifestChangesByLayer=function(M){var a=[],o={":layer":e.layers[this.getMode()]},i=e.layers[this.getMode()];M.manifestChanges.forEach(function(j){var n=j.hasOwnProperty(":layer")?j[":layer"]:1000;if(n<i){a.push(j);}else if(n===i){o=j;}});M.manifestChanges=a;this._currentLayerManifestChanges=o;};
v.prototype.setCard=function(a,s){this._ready=false;if(a===this.getProperty("card")){return this;}if(this._oEditorCard){this._oEditorCard.destroy();}if(this._oDesigntimeInstance){this._oDesigntimeInstance.destroy();}this.setProperty("card",a,s);Promise.resolve().then(function(){this._initCard(a);}.bind(this));return this;};
v.prototype.setLanguage=function(V,s){if(!V||typeof V!=="string"){return this;}this._language=V.replace("-","_");this.setProperty("language",V,s);if(!v._languages[this._language]){this._language=this._language.split("_")[0];}if(!v._languages[this._language]){g.warning("The language: "+V+" is currently unknown, some UI controls might show "+V+" instead of the language name.");}return this;};
v.prototype.onAfterRendering=function(){if(this.getDomRef()){this._iZIndex=q(this.getDomRef());P.setInitialZIndex(this._iZIndex);}};
v.prototype._getOriginalManifestJson=function(){try{return this._oEditorCard._oCardManifest._oManifest.getRawJson();}catch(a){return{};}};
v.prototype._initCard=function(a){if(typeof a==="string"){try{a=JSON.parse(a);}catch(i){var j=b.byId(a);if(!j){var n=document.getElementById(a);if(n&&n.tagName&&n.tagName==="ui-integration-card"){j=n._getControl();}}a=j;}}if(a&&a.isA&&a.isA("sap.ui.integration.widgets.Card")){a={manifest:a.getManifest(),manifestChanges:a.getManifestChanges(),host:a.getHost(),baseUrl:a.getBaseUrl()};}if(typeof a==="object"){var o=e.layers[this.getMode()];if(a.manifestChanges){this._filterManifestChangesByLayer(a);}this._oEditorCard=new c(a);var s=this;this._oEditorCard._prepareToApplyManifestSettings=function(){c.prototype._prepareToApplyManifestSettings.apply(this,arguments);if(!s._oEditorCard._isManifestReady){return;}if(s._manifestModel){return;}s._appliedLayerManifestChanges=a.manifestChanges;var M=s._oEditorCard.getManifestEntry("/");var _=m({},M);s._oProviderCard=s._oEditorCard;s._oProviderCard._editorManifest=M;s._beforeManifestModel=new J(_);if(o<e.layers["translation"]&&s._currentLayerManifestChanges){M=e.mergeCardDelta(M,[s._currentLayerManifestChanges]);}s._manifestModel=new J(M);s._originalManifestModel=new J(s._getOriginalManifestJson());s._initInternal();if(!s._oEditorCard.getModel("i18n")){s._oEditorCard._loadDefaultTranslations();}s.setModel(s._oEditorCard.getModel("i18n"),"i18n");s._createContextModel();};this._oEditorCard.onBeforeRendering();}};
v.prototype._initInternal=function(){var s=this._oEditorCard.getManifestEntry("/sap.card/designtime"),o=this._manifestModel.getProperty("/sap.card/configuration"),a,i=this.getDesigntime();if(i){if(typeof i==="function"){a=new Promise(function(j,n){var x=new i();this._applyDesigntimeDefaults(x.getSettings());j(x);}.bind(this));}else if(typeof i==="object"){a=new Promise(function(j,n){sap.ui.require(["sap/ui/integration/Designtime"],function(D){var A=D.extend("test.Designtime");A.prototype.create=function(){return i;};var x=new A();this._applyDesigntimeDefaults(x.getSettings());j(x);}.bind(this));}.bind(this));}}else if(s){a=this._oEditorCard.loadDesigntime().then(function(j){this._applyDesigntimeDefaults(j.getSettings());return j;}.bind(this));}else{a=Promise.resolve(this._createParameterDesigntime(o));}a.then(function(j){this._oDesigntimeInstance=j;if(this.getMode()==="admin"||this.getMode()==="all"){this._addDestinationSettings(o,this._oDesigntimeInstance);}this._settingsModel=new J(this._oDesigntimeInstance.getSettings());this.setModel(this._settingsModel,"currentSettings");this.setModel(this._settingsModel,"items");this._applyDesigntimeLayers();this._requireFields().then(function(){this._startEditor();}.bind(this));}.bind(this));};
v.prototype.getCurrentSettings=function(){var s=this._settingsModel.getProperty("/"),a={},N;if(s&&s.form&&s.form.items){for(var n in s.form.items){var i=s.form.items[n];if(i.editable&&i.visible){if(this.getMode()!=="translation"){if(i.translatable&&!i._changed&&i._translatedDefaultPlaceholder&&!this._currentLayerManifestChanges[i.manifestPath]){continue;}else{a[i.manifestpath]=i.value;}}else if(i.translatable&&i.value){a[i.manifestpath]=i.value;}if(i._next&&(this.getAllowSettings())){if(i._next.editable===false){N=N||{};N[i._settingspath+"/editable"]=false;}if(i._next.visible===false){N=N||{};N[i._settingspath+"/visible"]=false;}if(typeof i._next.allowDynamicValues==="boolean"&&this.getAllowDynamicValues()){N=N||{};N[i._settingspath+"/allowDynamicValues"]=i._next.allowDynamicValues;}}}}}a[":layer"]=e.layers[this.getMode()];a[":errors"]=this.checkCurrentSettings()[":errors"];if(N){a[":designtime"]=N;}return a;};
v.prototype.checkCurrentSettings=function(){var s=this._settingsModel.getProperty("/"),a={};if(s&&s.form&&s.form.items){for(var n in s.form.items){var i=s.form.items[n];if(i.editable){if((i.isValid||i.required)&&!(this.getMode()==="translation"&&i.translatable)){if(i.isValid){a[i.manifestpath]=i.isValid(i);}a[i.manifestpath]=true;var j=i.value;var o=i.type;if(o==="string"&&j===""){a[i.manifestpath]=j;}if((o==="date"||o==="datetime")&&isNaN(Date.parse(j))){a[i.manifestpath]=j;}if(o==="integer"){if(isNaN(parseInt(j))){a[i.manifestpath]=j;}else if(j<i.min||j>i.max){a[i.manifestpath]=j;}}if(o==="number"){if(isNaN(parseFloat(j))){a[i.manifestpath]=j;}else if(j<i.min||j>i.max){a[i.manifestpath]=j;}}}}}a[":layer"]=e.layers[this.getMode()];}a[":errors"]=Object.values(a).indexOf(false)>-1;return a;};
v.prototype._createContextModel=function(){var H=this._oEditorCard.getHostInstance(),i=new J({}),F=new J([]);this.setModel(i,"context");this.setModel(F,"contextflat");F._getPathObject=function(s){var a=this.getData().filter(function(o){if(o.path===s){return true;}});return a.length?a[0]:null;};F._getValueObject=function(V){var a=this.getData()||[];a=a.filter(function(o){if(o.value===V||o.object.value===V){return true;}});return a.length?a[0]:null;};var j=new Promise(function(a,n){if(H&&H.getContext){var o=false;setTimeout(function(){if(o){return;}g.error("Card Editor context could not be determined with "+t+".");o=true;a({});},t);H.getContext().then(function(s){if(o){g.error("Card Editor context returned after more than "+t+". Context is ignored.");}o=true;a(s||{});});}else{a({});}});j.then(function(o){var a={};a["empty"]=v._contextEntries.empty;for(var n in o){a[n]=o[n];}a["card.internal"]=v._contextEntries.cardinternal;i.setData(a);F.setData(w(a,"label"));});i.getProperty=function(s,o){var a=this.resolve(s,o);if(a.endsWith("/value")){this._mValues=this._mValues||{};if(this._mValues.hasOwnProperty(a)){return this._mValues[a];}this._mValues[a]=undefined;H.getContextValue(a.substring(1)).then(function(V){this._mValues[a]=V;this.checkUpdate();}.bind(this));return undefined;}else{return J.prototype.getProperty.apply(this,arguments);}};};
v.fieldMap={"string":"sap/ui/integration/designtime/editor/fields/StringField","integer":"sap/ui/integration/designtime/editor/fields/IntegerField","number":"sap/ui/integration/designtime/editor/fields/NumberField","boolean":"sap/ui/integration/designtime/editor/fields/BooleanField","date":"sap/ui/integration/designtime/editor/fields/DateField","datetime":"sap/ui/integration/designtime/editor/fields/DateTimeField","string[]":"sap/ui/integration/designtime/editor/fields/ListField","destination":"sap/ui/integration/designtime/editor/fields/DestinationField"};v.Fields=null;
v.prototype._requireFields=function(){if(v.Fields){return Promise.resolve();}return new Promise(function(a){sap.ui.require(Object.values(v.fieldMap),function(){v.Fields={};for(var n in v.fieldMap){v.Fields[n]=arguments[Object.keys(v.fieldMap).indexOf(n)];}a();});});};
v.prototype._createLabel=function(o){var a=new L({text:o.label,required:o.required&&o.editable||false,visible:o.visible,objectBindings:{currentSettings:{path:"currentSettings>"+o._settingspath},items:{path:"items>/form/items"}}});a._cols=o.cols||2;if(o.description){var i=new I({src:"sap-icon://message-information",color:"Marker",size:"12px",useIconTooltip:false,visible:this.getMode()!=="translation"});i.addStyleClass("sapUiIntegrationCardEditorDescriptionIcon");a.addDependent(i);i.onmouseover=function(){this._getPopover().getContent()[0].setText(o.description);this._getPopover().openBy(i);}.bind(this);i.onmouseout=function(){this._getPopover().close();}.bind(this);}return a;};
v.prototype._getPopover=function(){if(this._oPopover){return this._oPopover;}var o=new f({text:""});o.addStyleClass("sapUiTinyMargin sapUiIntegrationCardEditorDescriptionText");this._oPopover=new R({showHeader:false,content:[o]});this._oPopover.addStyleClass("sapUiIntegrationCardEditorPopover");return this._oPopover;};
v.prototype._updateProviderCard=function(a){if(this._ready){var M=this._oProviderCard._editorManifest;if(a.length===0){return;}for(var i=0;i<a.length;i++){var o=a[i];o.config._cancel=true;}delete M["sap.card"].header;delete M["sap.card"].content;delete M["sap.card"].data;M["sap.card"].type="List";var j=this._oProviderCard;this._oProviderCard=new c({manifest:M,baseUrl:this._oProviderCard.getBaseUrl(),host:this._oProviderCard.getHost()});this._oProviderCard.setManifestChanges([this.getCurrentSettings()]);this._oProviderCard._editorManifest=M;var n=this;this._oProviderCard._fillFiltersModel=function(){if(!n._oProviderCard._oDataProviderFactory){return;}n._bIgnoreUpdates=true;for(var i=0;i<a.length;i++){var o=a[i];o.config._cancel=false;n._addValueListModel(o.config,o.field,true);}n._bIgnoreUpdates=false;};this._oProviderCard.setVisible(false);this._oProviderCard.onBeforeRendering();if(j&&j!==this._oEditorCard){j.destroy();}}};
v.prototype._createField=function(o){var F=new v.Fields[o.type]({configuration:o,mode:this.getMode(),host:this._oEditorCard.getHostInstance(),objectBindings:{currentSettings:{path:"currentSettings>"+o._settingspath},items:{path:"items>/form/items"}},visible:o.visible});this._aFieldReadyPromise.push(F._readyPromise);var B=this._settingsModel.bindProperty(o._settingspath+"/value");B.attachChange(function(){if(!this._bIgnoreUpdates){o._changed=true;if(o._dependentFields&&o._dependentFields.length>0){this._updateProviderCard(o._dependentFields);}this._updatePreview();}}.bind(this));this._addValueListModel(o,F);F._cols=o.cols||2;return F;};
v.prototype._addValueListModel=function(o,F,a){if(o.values&&o.values.data&&this._oProviderCard&&this._oProviderCard._oDataProviderFactory){var V=new J({}),j=this._oProviderCard._oDataProviderFactory.create(o.values.data).getData();this._settingsModel.setProperty(o._settingspath+"/_loading",true);j.then(function(B){if(o._cancel){o._values=[];return;}o._values=B;V.setData(B);V.checkUpdate(true);this._settingsModel.setProperty(o._settingspath+"/_loading",false);}.bind(this)).catch(function(){o._values={};V.setData({});V.checkUpdate(true);this._settingsModel.setProperty(o._settingspath+"/_loading",false);}.bind(this));F.setModel(V,undefined);F.bindObject({path:o.values.data.path||"/"});if(!a){var s=JSON.stringify(o.values.data);if(s){var n=/parameters\.([^\}\}]+)|destinations\.([^\}\}]+)/g,x=s.match(n);if(x){for(var i=0;i<x.length;i++){var y=x[i].indexOf("parameters.")===0?"/value":"/name",z="/sap.card/configuration/"+x[i].replace(".","/")+y,A=this._mItemsByPaths[z];if(A){A._dependentFields=A._dependentFields||[];A._dependentFields.push({field:F,config:o});}}}}}}};
v.prototype._addItem=function(o){var M=this.getMode();if(this.getAllowDynamicValues()===false){o.allowDynamicValues=false;}if(this.getAllowSettings()===false){o.allowSettings=false;}o._beforeValue=this._beforeManifestModel.getProperty(o.manifestpath);o.__cols=o.cols||2;if(o.visible===false||(!o.translatable&&M==="translation")){return;}if(o.type==="group"){var a=new T({text:o.label,visible:o.visible,objectBindings:{currentSettings:{path:"currentSettings>"+o._settingspath},items:{path:"items>/form/items"}}});this.addAggregation("_formContent",a);a._cols=o.cols||2;return;}if(M==="translation"){if(typeof o.value==="string"&&o.value.indexOf("{")===0){return;}o._language={value:o.value};o.cols=1;var i=d(o,10);i._settingspath+="/_language";i.editable=false;i.required=false;if(!i.value){i.value="-";}this.addAggregation("_formContent",this._createLabel(i));this.addAggregation("_formContent",this._createField(i));o.value=o._translatedDefaultValue||"";o.editable=o.visible=o.translatable;if(this._currentLayerManifestChanges){o.value=this._currentLayerManifestChanges[o.manifestpath]||o.value;}o.label=o._translatedLabel||"";o.required=false;}this.addAggregation("_formContent",this._createLabel(o));var F=this._createField(o);this.addAggregation("_formContent",F);o.cols=o.__cols;delete o.__cols;};
v.prototype._getCurrentLanguageSpecificText=function(K){var s=this._language;if(this._oTranslationBundle){var a=this._oTranslationBundle.getText(K);if(a===K){return"";}return a;}if(!s){return"";}var i=this._oEditorCard.getManifestEntry("/sap.app/i18n");if(!i){return"";}if(typeof i==="string"){var o=new U(i);this._oTranslationBundle=new h(o,s,false,false,[s],"",true);return this._getCurrentLanguageSpecificText(K);}};
v.prototype._startEditor=function(){var s=this._settingsModel.getProperty("/");if(s.form&&s.form.items){if(this.getMode()==="translation"){this._addItem({type:"group",cols:1,translatable:true,label:u.getText("CARDEDITOR_ORIGINALLANG")});this._addItem({type:"group",cols:1,translatable:true,label:v._languages[this._language]||this.getLanguage()});}this._mItemsByPaths={};for(var n in s.form.items){var i=s.form.items[n];if(i.manifestpath){this._mItemsByPaths[i.manifestpath]=i;}if(i){i.label=i.label||n;if(i.type==="string"){var a=this._getManifestDefaultValue(i.manifestpath),j=i.defaultValue;if(this._isValueWithHandlebarsTranslation(a)){i.translatable=true;i._translatedDefaultValue=this._getCurrentLanguageSpecificText(a.substring(2,a.length-2));i._translatedDefaultPlaceholder=a;}else if(j&&j.startsWith("{i18n>")){i.translatable=true;i._translatedDefaultPlaceholder=j;i.value=this._currentLayerManifestChanges[i.manifestpath]||this.getModel("i18n").getResourceBundle().getText(j.substring(6,j.length-1));if(this.getMode()==="translation"){i._translatedDefaultValue=this._getCurrentLanguageSpecificText(j.substring(6,j.length-1));}}if(this.getMode()==="translation"){if(this._isValueWithHandlebarsTranslation(i.label)){i._translatedLabel=this._getCurrentLanguageSpecificText(i.label.substring(2,i.label.length-2),true);}else if(i.label&&i.label.startsWith("{i18n>")){i._translatedLabel=this._getCurrentLanguageSpecificText(i.label.substring(6,i.label.length-1),true);}}}i._changed=false;}}}for(var n in s.form.items){var i=s.form.items[n];this._addItem(i);}if(this.getMode()!=="translation"){this._initPreview().then(function(){Promise.all(this._aFieldReadyPromise).then(function(){this._ready=true;this.fireReady();}.bind(this));}.bind(this));}else{Promise.all(this._aFieldReadyPromise).then(function(){this._ready=true;this.fireReady();}.bind(this));}};
v.prototype.destroy=function(){if(this._oEditorCard){this._oEditorCard.destroy();}if(this._oPopover){this._oPopover.destroy();}if(this._oDesigntimeInstance){this._oDesigntimeInstance.destroy();}this._manifestModel=null;this._originalManifestModel=null;this._settingsModel=null;C.prototype.destroy.apply(this,arguments);};
v.prototype._initPreview=function(){return new Promise(function(a,i){sap.ui.require(["sap/ui/integration/designtime/editor/CardPreview"],function(j){var o=new j({settings:this._oDesigntimeInstance.getSettings(),card:this._oEditorCard});this.setAggregation("_preview",o);a();}.bind(this));}.bind(this));};
v.prototype._updatePreview=function(){var o=this.getAggregation("_preview");if(o){o.update();}};
v.prototype._applyDesigntimeDefaults=function(s){s=s||{};s.form=s.form||{};s.form.items=s.form.items||{};s.preview=s.preview||{modes:"Abstract"};var i=s.form.items||s.form.items;for(var n in i){var o=i[n];if(o.manifestpath){o.value=this._manifestModel.getProperty(o.manifestpath);}if(o.visible===undefined||o.visible===null){o.visible=true;}if(typeof o.translatable!=="boolean"){o.translatable=false;}if(o.editable===undefined||o.editable===null){o.editable=true;}if(!o.label){o.label=n;}if(!o.type||o.type==="enum"){o.type="string";}if(o.value===undefined||o.value===null){switch(o.type){case"boolean":o.value=o.defaultValue||false;break;case"integer":case"number":o.value=o.defaultValue||0;break;case"string[]":o.value=o.defaultValue||[];break;default:o.value=o.defaultValue||"";}}if(o.type==="group"){if(o.visible===undefined||o.value===null){o.visible=true;}}o._settingspath="/form/items/"+n;}};
v.prototype._applyDesigntimeLayers=function(s){if(this._appliedLayerManifestChanges&&Array.isArray(this._appliedLayerManifestChanges)){for(var i=0;i<this._appliedLayerManifestChanges.length;i++){var o=this._appliedLayerManifestChanges[i][":designtime"];if(o){var K=Object.keys(o);for(var j=0;j<K.length;j++){this._settingsModel.setProperty(K[j],o[K[j]]);}}}}if(this._currentLayerManifestChanges){var o=this._currentLayerManifestChanges[":designtime"];if(o){var K=Object.keys(o);for(var j=0;j<K.length;j++){var a=K[j],n=a.substring(0,a.lastIndexOf("/")+1)+"_next";if(!this._settingsModel.getProperty(n)){this._settingsModel.setProperty(n,{});}var n=a.substring(0,a.lastIndexOf("/")+1)+"_next",x=a.substring(a.lastIndexOf("/")+1);this._settingsModel.setProperty(n+"/"+x,o[K[j]]);}}}};
v.prototype._createParameterDesigntime=function(o){var s={},B="/sap.card/configuration/parameters/",M=this.getMode();if(o&&o.parameters){s.form=s.form||{};s.form.items=s.form.items||{};var i=s.form.items;Object.keys(o.parameters).forEach(function(n){i[n]=m({manifestpath:B+n+"/value",editable:(M!=="translation"),_settingspath:"/form/items/"+n},o.parameters[n]);var a=i[n];if(!a.type){a.type="string";}if(!a.hasOwnProperty("visible")){a.visible=true;}});}return new D(s);};
v.prototype._addDestinationSettings=function(o){var s=this._oDesigntimeInstance.getSettings(),B="/sap.card/configuration/destinations/";s.form=s.form||{};s.form.items=s.form.items||{};if(s&&o&&o.destinations){if(!s.form.items["destination.group"]){s.form.items["destination.group"]={label:u.getText("CARDEDITOR_DESTINATIONS")||"Destinations",type:"group",visible:true};}var i=s.form.items;Object.keys(o.destinations).forEach(function(n){var _=[{}],H=this._oEditorCard.getHostInstance();i[n+".destinaton"]=m({manifestpath:B+n+"/name",visible:true,type:"destination",editable:true,allowDynamicValues:false,allowSettings:false,value:o.destinations[n].name,defaultValue:o.destinations[n].defaultUrl,_settingspath:"/form/items/"+[n+".destinaton"],_values:_,_destinationName:n},o.destinations[n]);if(typeof i[n+".destinaton"].label==="undefined"){i[n+".destinaton"].label=n;}if(H){i[n+".destinaton"]._loading=true;this._oEditorCard.getHostInstance().getDestinations().then(function(n,a){i[n+".destinaton"]._values=_.concat(a);i[n+".destinaton"]._loading=false;this._settingsModel.checkUpdate(true);i[n+".destinaton"].value=o.destinations[n].name;}.bind(this,n));}}.bind(this));}};
v.prototype._getManifestDefaultValue=function(s){return this._originalManifestModel.getProperty(s);};
v.prototype._isValueWithHandlebarsTranslation=function(V){if(typeof V==="string"){return!!V.match(r);}return false;};
v._contextEntries={empty:{label:u.getText("CARDEDITOR_CONTEXT_EMPTY_VAL"),type:"string",description:u.getText("CARDEDITOR_CONTEXT_EMPTY_DESC"),placeholder:"",value:""},cardinternal:{label:u.getText("CARDEDITOR_CONTEXT_CARD_INTERNAL_VAL"),todayIso:{type:"string",label:u.getText("CARDEDITOR_CONTEXT_CARD_TODAY_VAL"),description:u.getText("CARDEDITOR_CONTEXT_CARD_TODAY_DESC"),tags:[],placeholder:u.getText("CARDEDITOR_CONTEXT_CARD_TODAY_VAL"),customize:["format.dataTime"],value:"{{parameters.TODAY_ISO}}"},nowIso:{type:"string",label:u.getText("CARDEDITOR_CONTEXT_CARD_NOW_VAL"),description:u.getText("CARDEDITOR_CONTEXT_CARD_NOW_DESC"),tags:[],placeholder:u.getText("CARDEDITOR_CONTEXT_CARD_NOW_VAL"),customize:["dateFormatters"],value:"{{parameters.NOW_ISO}}"},currentLanguage:{type:"string",label:u.getText("CARDEDITOR_CONTEXT_CARD_LANG_VAL"),description:u.getText("CARDEDITOR_CONTEXT_CARD_LANG_VAL"),tags:["technical"],customize:["languageFormatters"],placeholder:u.getText("CARDEDITOR_CONTEXT_CARD_LANG_VAL"),value:"{{parameters.LOCALE}}"}}};v._languages={};
v._appendThemeVars=function(){var o=document.getElementById("sap-ui-integration-editor-style");if(o&&o.parentNode){o.parentNode.removeChild(o);}var V=["sapUiButtonHoverBackground","sapUiBaseBG","sapUiContentLabelColor","sapUiTileSeparatorColor","sapUiHighlight","sapUiListSelectionBackgroundColor","sapUiChartScrollbarBorderColor"],s=document.createElement("style");s.setAttribute("id","sap-ui-integration-editor-style");for(var i=0;i<V.length;i++){V[i]="--"+V[i]+":"+p.get(V[i]);}s.innerHTML=".sapUiIntegrationCardEditor, .sapUiIntegrationFieldSettings, .sapUiIntegrationIconSelectList {"+V.join(";")+"}";document.body.appendChild(s);};
v.init=function(){this.init=function(){};v._appendThemeVars();b.attachThemeChanged(function(){v._appendThemeVars();});var s=sap.ui.require.toUrl("sap.ui.integration.designtime.editor.css.CardEditor".replace(/\./g,"/")+".css");k(s);l.loadResource("sap/ui/integration/designtime/editor/languages.json",{dataType:"json",failOnError:false,async:true}).then(function(o){v._languages=o;});};
v.init();return v;});
sap.ui.predefine('sap/ui/integration/designtime/editor/CardPreview',["sap/ui/core/Control","sap/m/HBox","sap/m/Image","sap/m/ToggleButton","sap/ui/integration/widgets/Card","sap/ui/core/Core","sap/ui/dom/includeStylesheet","sap/ui/integration/util/CardMerger"],function(C,H,I,T,a,c,i,d){"use strict";
var e=C.extend("sap.ui.integration.designtime.editor.CardPreview",{
metadata:{properties:{settings:{type:"any"},card:{type:"object"}},aggregations:{cardPreview:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}}},
renderer:function(r,o){if(o._getCurrentMode()==="None"){r.openStart("div",o);r.openEnd();return;}r.openStart("div",o);r.addClass("sapUiIntegrationDTPreview");if(f()){r.addClass("sapUiIntegrationDTPreviewDark");}r.writeClasses();r.openEnd();r.openStart("div");r.addClass("before");r.writeAttribute("tabindex","0");r.writeAttributeEscaped("id",o.getId()+"-before");r.addStyle("z-index",o.getParent()._iZIndex+1);r.writeStyles();r.openEnd();r.close("div");r.renderControl(o._getCardPreview());r.openStart("div");r.writeAttribute("tabindex","0");r.writeAttributeEscaped("id",o.getId()+"-after");r.openEnd();r.close("div");if(o._getModes().indexOf("Live")>-1&&o._getModes().indexOf("Abstract")>-1){r.renderControl(o._getModeToggleButton());}}
});
e.prototype.init=function(){this._oResourceBundle=c.getLibraryResourceBundle("sap.ui.integration");c.attachThemeChanged(function(){if(this.getDomRef()){if(f()){this.getDomRef().classList.add("sapUiIntegrationDTPreviewDark");}else{this.getDomRef().classList.remove("sapUiIntegrationDTPreviewDark");}}else{this.update();}}.bind(this));};
e.prototype.destroy=function(){if(this._oModeToggleButton){this._oModeToggleButton.destroy();}if(this._oCardPreview){this._oCardPreview.destroy();}if(this._oImagePlaceholder){this._oImagePlaceholder.destroy();}if(this._oCardPlaceholder){this._oCardPlaceholder.destroy();}C.prototype.destroy.apply(this,arguments);};
e.prototype._getCardPreview=function(){var p=null;if(this._getCurrentMode()==="Abstract"){if(this.getSettings().preview.src){p=this._getImagePlaceholder();}else{p=this._getCardPlaceholderPreview();}}else if(this._getCurrentMode()==="Live"){p=this._getCardRealPreview();}if(p){this.setAggregation("cardPreview",p);if(!this.getSettings().preview||this.getSettings().preview.scaled!==false){p.addStyleClass("sapUiIntegrationDTPreviewScale");}else{p.addStyleClass("sapUiIntegrationDTPreviewNoScale");}}return p;};
e.prototype._getCardPlaceholderPreview=function(){var o=this.getCard(),p;function _(s,x){return o.getManifestEntry(s)?x||"{bound}":null;}var h=null;if(o.getManifestEntry("/sap.card/header")){var t=o.getManifestEntry("/sap.card/header/type");if(t&&t.toUpperCase()==="NUMERIC"){h={"title":_("/sap.card/header/title"),"type":"Numeric","subTitle":_("/sap.card/header/subTitle"),"unitOfMeasurement":_("/sap.card/header/unitOfMeasurement"),"mainIndicator":_("/sap.card/header/mainIndicator",{"number":"{bound}","unit":"{bound}","trend":"{bound}","state":"{bound}"}),"details":_("/sap.card/header/details"),"sideIndicators":[_("/sap.card/header/sideIndicators/0",{"title":"Deviation","number":"{bound}","unit":"{bound}"}),_("/sap.card/header/sideIndicators/1",{"title":"Target","number":"{bound}","unit":"{bound}"})]};}else{h={"title":_("/sap.card/header/title"),"subTitle":_("/sap.card/header/subTitle"),"status":_("/sap.card/header/status"),"icon":_("/sap.card/header/icon",{"src":"{bound}"})};}}var b=this.getParent().getCurrentSettings();p={"sap.app":{"type":"card","id":o.getManifestEntry("/sap.app/id")+".abstractPreview"},"sap.card":{"type":o.getManifestEntry("/sap.card/type")==="List"?"List":"Component","header":h,"content":{"maxItems":Math.min(b["/sap.card/content/maxItems"]||6,6),"item":{"title":{"value":_("/sap.card/content/item/value")},"icon":_("/sap.card/content/item/icon",{"src":"{bound}"}),"description":_("/sap.card/content/item/description"),"info":{"value":_("/sap.card/content/item/info")}}}}};if(!this._oCardPlaceholder){this._oCardPlaceholder=new a();this._oCardPlaceholder._setPreviewMode(true);}this._oCardPlaceholder.setManifest(p);this._oCardPlaceholder.refresh();return this._oCardPlaceholder;};
e.prototype.getTransformContentInfo=function(){return{transformStyle:"scale3d(0.4, 0.4, 1)",transformFactor:0.4,transformOriginStyle:"0 0",widthStyle:"500px",heightStyle:"600px",zIndex:this.getParent()._iZIndex};};
e.prototype._getCardRealPreview=function(){if(!this._oCardPreview){this._oCardPreview=new a();this._oCardPreview.setBaseUrl(this.getCard().getBaseUrl());}this._initalChanges=this._initalChanges||this._oCardPreview.getManifestChanges()||[];var b=this._initalChanges.concat([this.getParent().getCurrentSettings()]);this._oCardPreview.setManifestChanges(b);this._oCardPreview.setManifest(this.getCard().getManifestEntry("/"));this._oCardPreview.refresh();this._oCardPreview.editor=this._oCardPreview.editor||{};this._oCardPreview.preview=this._oCardPreview.editor.preview=this;return this._oCardPreview;};
e.prototype._getImagePlaceholder=function(){var s=this.getSettings();if(s.preview.src){if(!this._oImagePlaceholder){var h=new H();h.addStyleClass("sapFCard");h.setWidth("500px");var b=this.getCard().getBaseUrl();if(!b&&typeof this.getCard().getManifest()==="string"){b=this.getCard().getManifest();b=b.substring(0,b.lastIndexOf("/")+1);}var g=b+"/"+s.preview.src;var o=new I({src:g});o.addStyleClass("sapUiIntegrationDTPreviewImg");o.setWidth("500px");o.setHeight("600px");h.addItem(o);this._oImagePlaceholder=h;}}return this._oImagePlaceholder;};
e.prototype._getModes=function(){var s=this.getSettings();s.preview=s.preview||{};s.preview.modes=s.preview.modes||"Abstract";return s.preview.modes;};
e.prototype._getCurrentMode=function(){var m=this._getModes();if(!this._currentMode){switch(m){case"AbstractLive":case"Abstract":this._currentMode="Abstract";break;case"LiveAbstract":case"Live":this._currentMode="Live";break;default:this._currentMode="None";}}return this._currentMode;};
e.prototype._toggleCurrentMode=function(){var m=this._getModes();if(m.indexOf("Live")>-1&&m.indexOf("Abstract")>-1){this._currentMode=this._getCurrentMode()==="Abstract"?"Live":"Abstract";}};
e.prototype._getModeToggleButton=function(){var b=c.getLibraryResourceBundle("sap.ui.integration");if(!this._oModeToggleButton){this._oModeToggleButton=new T();this._oModeToggleButton.setTooltip();this._oModeToggleButton.addStyleClass("sapUiIntegrationDTPreviewButton");this._oModeToggleButton.attachPress(function(){this._toggleCurrentMode();this.update();}.bind(this));}var t=this._oModeToggleButton,g=this._getCurrentMode();if(g==="None"){t.setVisible(false);}if(g==="Abstract"){t.setIcon("sap-icon://media-play");t.setPressed(false);t.setTooltip(b.getText("CARDEDITOR_PREVIEW_BTN_LIVEPREVIEW"));}else if(g==="Live"){t.setIcon("sap-icon://media-pause");t.setPressed(true);t.setTooltip(b.getText("CARDEDITOR_PREVIEW_BTN_SAMPLEPREVIEW"));}return this._oModeToggleButton;};
e.prototype.update=function(){this.invalidate();};
function f(h){h=h||window.getComputedStyle(document.body).backgroundColor;var m=/rgb\((\d+).*?(\d+).*?(\d+)\)/.exec(h);if(!m){return false;}var r=parseInt(m[1]),g=parseInt(m[2]),b=parseInt(m[3]),y=(r*299+g*587+b*114)/1000;return(y<=128);}
e.prototype.onsaptabnext=function(E){if(E.target===this.getDomRef("before")){this.getDomRef("after").focus();}};
e.prototype.onsaptabprevious=function(E){if(E.target===this.getDomRef("after")){this.getDomRef("before").focus();}};
e.init=function(){var s=sap.ui.require.toUrl("sap.ui.integration.designtime.editor.css.CardPreview".replace(/\./g,"/")+".css");i(s);this.init=function(){};};
e.init();return e;});
sap.ui.predefine('sap/ui/integration/designtime/editor/fields/BaseField',["sap/ui/core/Control","sap/m/Button","sap/m/MultiInput","./Settings","sap/m/Token","sap/ui/core/Core"],function(C,B,M,S,T,a){"use strict";var r=a.getLibraryResourceBundle("sap.ui.integration"),b="sap/ui/integration/designtime/editor/fields/viz";
var c=C.extend("sap.ui.integration.designtime.editor.fields.Base",{
metadata:{properties:{configuration:{type:"object"},specialButton:{type:"object"},mode:{type:"string"},host:{type:"object"},visible:{type:"boolean",defaultValue:true}},aggregations:{_field:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_settingsButton:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_dynamicField:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{afterInit:{}}},
renderer:function(R,o){var f=o.getAggregation("_field"),s=o.getAggregation("_settingsButton"),d=o._getDynamicField();R.openStart("div");R.addClass("sapUiIntegrationCardEditorItemField");if(f&&f.getWidth&&!s){}if(!o.getVisible()){R.addStyle("display","none");}R.writeClasses();R.writeStyles();R.writeElementData(o);R.openEnd();if(o.getVisible()){R.openStart("span");R.writeClasses();R.openEnd();R.openStart("span");R.addClass("sapUiIntegrationCardEditorEditor");if(o._hasDynamicValue()){R.addStyle("width","1px");R.addStyle("opacity","0");}R.writeStyles();R.writeClasses();R.openEnd();R.renderControl(f);R.close("span");R.close("span");if(s||o._hasDynamicValue()){R.openStart("span");R.addClass("sapUiIntegrationCardEditorSettings");R.writeClasses();R.openEnd();R.openStart("span");R.addClass("sapUiIntegrationCardEditorSettingsField");if(o._hasDynamicValue()){R.addStyle("width","calc(100% - 2.5rem)");R.addStyle("opacity","1");}R.writeClasses();R.writeStyles();R.openEnd();R.renderControl(d);R.close("span");R.openStart("span");R.addClass("sapUiIntegrationCardEditorSettingsButton");R.writeClasses();R.openEnd();R.renderControl(s);R.close("span");R.close("span");}}R.close("div");}
});
c.prototype.init=function(){this._readyPromise=new Promise(function(d){this._fieldResolver=d;}.bind(this));};
c.prototype.setConfiguration=function(o,s){if(o!==this.getConfiguration()){this.setProperty("configuration",o,s);if(o){Promise.resolve().then(function(){this.initEditor(o);}.bind(this));}}return this;};
c.prototype.initEditor=function(o){var d;this.initVisualization&&this.initVisualization(o);if(this._visualization.editor){d=this._visualization.editor;}else if(this._visualization.type){if(typeof this._visualization.type==="string"){if(this._visualization.type.indexOf("/")===-1){this._visualization.type=b+"/"+this._visualization.type;this._visualization.settings=this._visualization.settings||{value:"{currentSettings>value}",editable:"{currentSettings>editable}"};}sap.ui.require([this._visualization.type],function(f){this._visualization.type=f;this.initEditor(o);}.bind(this));return;}d=new this._visualization.type(this._visualization.settings||{});}if(d instanceof C){this.setAggregation("_field",d);}var m=this.getMode();o.allowSettings=o.allowSettings||o.allowSettings!==false&&m==="admin";o.allowDynamicValues=o.allowDynamicValues||o.allowDynamicValues!==false;o._changeDynamicValues=o.visible&&o.editable&&(o.allowDynamicValues||o.allowSettings)&&m!=="translation";if(o._changeDynamicValues){this._addSettingsButton();}this._applySettings(o);};
c.prototype.initVisualization=function(){};
c.prototype._hasDynamicValue=function(){var v=this._getCurrentProperty("value");var d=typeof v==="string"&&(v.indexOf("{context>")===0||v.indexOf("{{parameters")===0);this._setCurrentProperty("_hasDynamicValue",d);return d;};
c.prototype._hasSettings=function(){var o=this.getConfiguration();if(o._next){o._hasSettings=(o._next.editable===false||o._next.visible===false||o._next.allowDynamicValues===false);}else{o._hasSettings=false;}return o._hasSettings;};
c.prototype._getDynamicField=function(){var f=this.getAggregation("_dynamicField");if(!f){var f=new M({showValueHelp:false});this.setAggregation("_dynamicField",f);}return f;};
c.prototype._hideDynamicField=function(){var d=this._getDynamicField(),f=this.getAggregation("_field");if(d.getDomRef()){var s=d.getDomRef().parentNode.style;s.width="1px";s.opacity=0;s=f.getDomRef().parentNode.style;f.getDomRef().style.visibility="visible";s.width="calc(100% - 2.5rem)";s.opacity=1;}};
c.prototype._showDynamicField=function(){var d=this._getDynamicField(),f=this.getAggregation("_field");if(d.getDomRef()){var s=d.getDomRef().parentNode.style;s.width="calc(100% - 2.5rem)";s.opacity=1;s=f.getDomRef().parentNode.style;f.getDomRef().style.visibility="hidden";s.width="1px";s.opacity=0;}};
c.prototype._getSettingsPanel=function(){if(!this._oSettingsPanel){this._oSettingsPanel=new S();}return this._oSettingsPanel;};
c.prototype._openSettingsDialog=function(d){var s=this._getSettingsPanel();window.setTimeout(function(){s.setConfiguration(this.getConfiguration());s.open(this.getAggregation("_settingsButton"),this.getAggregation("_settingsButton"),this.getParent().getAggregation("_preview"),this.getHost(),this,this._applySettings.bind(this),this._cancelSettings.bind(this));}.bind(this),d||600);};
c.prototype._addSettingsButton=function(){this._getDynamicField();this.setAggregation("_settingsButton",new B({icon:"{= ${currentSettings>_hasDynamicValue} ? 'sap-icon://display-more' : 'sap-icon://enter-more'}",type:"Transparent",tooltip:r.getText("CARDEDITOR_FIELD_MORE_SETTINGS"),press:function(){this._openSettingsDialog(200);}.bind(this)}));};
c.prototype._setCurrentProperty=function(p,v){if(this._getCurrentProperty(p)!==v){this.getModel("currentSettings").setProperty(p,v,this.getBindingContext("currentSettings"));}};
c.prototype._getCurrentProperty=function(p){return this.getModel("currentSettings").getProperty(p,this.getBindingContext("currentSettings"));};
c.prototype._applySettings=function(d){var D=this._getDynamicField(),o=this.getModel("contextflat")._getValueObject(d.value);D.removeAllTokens();if(!this._getCurrentProperty("_changeDynamicValues")){D.setEnabled(false);}if(o&&o.path!=="empty"){if(o.object.value&&o.object.value.indexOf("{{")==0){this._setCurrentProperty("value",o.object.value);}else{this._setCurrentProperty("value",o.value);}D.addToken(new T({text:o.object.label,"delete":function(){this._setCurrentProperty("value","");if(!this._hasDynamicValue()){this._hideDynamicField();}this._applyButtonStyles();window.setTimeout(function(){this.getAggregation("_field").focus();}.bind(this),100);}.bind(this)}));}else{this._setCurrentProperty("value",d.value);this._hideDynamicField();}this._setCurrentProperty("_next",d._next);this._applyButtonStyles();if(!this._hasDynamicValue()){this._hideDynamicField();}else{this._showDynamicField();}this._fieldResolver&&this._fieldResolver();this._fieldResolver=null;};
c.prototype._cancelSettings=function(){this._applyButtonStyles();if(!this._hasDynamicValue()){this._hideDynamicField();}};
c.prototype._applyButtonStyles=function(){if(!this._hasDynamicValue()){this.removeStyleClass("dynamicvalue");}else{this.addStyleClass("dynamicvalue");}if(!this._hasSettings()){this.removeStyleClass("settings");}else{this.addStyleClass("settings");}};
return c;});
sap.ui.predefine('sap/ui/integration/designtime/editor/fields/BooleanField',["sap/ui/integration/designtime/editor/fields/BaseField","sap/m/CheckBox"],function(B,C){"use strict";
var a=B.extend("sap.ui.integration.designtime.editor.fields.BooleanField",{renderer:B.getMetadata().getRenderer()});
a.prototype.initVisualization=function(c){var v=c.visualization;if(!v){v={type:C,settings:{selected:{path:'currentSettings>value'},editable:{path:'currentSettings>editable'}}};c.withLabel=true;}this._visualization=v;};
return a;});
sap.ui.predefine('sap/ui/integration/designtime/editor/fields/DateField',["sap/ui/integration/designtime/editor/fields/BaseField","sap/m/DatePicker"],function(B,D){"use strict";
var a=B.extend("sap.ui.integration.designtime.editor.fields.DateField",{renderer:B.getMetadata().getRenderer()});
a.prototype.initVisualization=function(c){var V=c.visualization;if(!V){V={type:D,settings:{dateValue:{path:'currentSettings>value',formatter:function(v){return new Date(v);}},editable:{path:'currentSettings>editable'},valueFormat:"YYYY-MM-dd",width:"16rem",change:function(e){if(e.getParameters().valid){var s=e.getSource();s.getBinding("dateValue").setRawValue(s.getValue());s.getBinding("dateValue").checkUpdate();}else{var s=e.getSource();s.getBinding("dateValue").setRawValue("");}}}};}this._visualization=V;};
return a;});
sap.ui.predefine('sap/ui/integration/designtime/editor/fields/DateTimeField',["sap/ui/integration/designtime/editor/fields/BaseField","sap/m/DateTimePicker"],function(B,D){"use strict";
var a=B.extend("sap.ui.integration.designtime.editor.fields.DateTimeField",{renderer:B.getMetadata().getRenderer()});
a.prototype.initVisualization=function(c){var V=c.visualization;if(!V){V={type:D,settings:{dateValue:{path:'currentSettings>value',formatter:function(v){return new Date(v);}},editable:{path:'currentSettings>editable'},width:"16rem",change:function(e){if(e.getParameters().valid){var s=e.getSource();s.getBinding("dateValue").setRawValue(s.getDateValue().toISOString());s.getBinding("dateValue").checkUpdate();}else{var s=e.getSource();s.getBinding("dateValue").setRawValue("");s.getBinding("dateValue").checkUpdate(true);}}}};}this._visualization=V;};
return a;});
sap.ui.predefine('sap/ui/integration/designtime/editor/fields/DestinationField',["sap/ui/integration/designtime/editor/fields/BaseField","sap/m/Select","sap/ui/core/ListItem"],function(B,S,L){"use strict";
var D=B.extend("sap.ui.integration.designtime.editor.fields.DestinationField",{renderer:B.getMetadata().getRenderer()});
D.prototype.initVisualization=function(c){var v=c.visualization;if(!v){v={type:S,settings:{busy:{path:'currentSettings>_loading'},selectedKey:{path:'currentSettings>value'},width:"100%",items:{path:"currentSettings>_values",template:new L({text:"{currentSettings>name}",key:"{currentSettings>name}"})}}};}this._visualization=v;};
return D;});
sap.ui.predefine('sap/ui/integration/designtime/editor/fields/IntegerField',["sap/ui/integration/designtime/editor/fields/BaseField","sap/m/Input","sap/ui/model/type/Integer"],function(B,I,a){"use strict";
var b=B.extend("sap.ui.integration.designtime.editor.fields.IntegerField",{renderer:B.getMetadata().getRenderer()});
b.prototype.initVisualization=function(c){var v=c.visualization;if(!v){v={type:I,settings:{value:{path:'currentSettings>value',type:new a()},editable:{path:'currentSettings>editable'},type:"Number"}};}this._visualization=v;};
return b;});
sap.ui.predefine('sap/ui/integration/designtime/editor/fields/ListField',["sap/ui/integration/designtime/editor/fields/BaseField","sap/m/Input","sap/m/Text","sap/m/MultiComboBox","sap/ui/core/ListItem"],function(B,I,T,M,L){"use strict";
var b=B.extend("sap.ui.integration.designtime.editor.fields.ListField",{renderer:B.getMetadata().getRenderer()});
b.prototype.initVisualization=function(c){var v=c.visualization;if(!v){if(c.editable){if(c.values){var i=new L(c.values.item);v={type:M,settings:{selectedKeys:{path:'currentSettings>value'},editable:{path:'currentSettings>editable'},showSecondaryValues:true,width:"100%",items:{path:"",template:i}}};}else{v={type:I,settings:{value:{path:'currentSettings>value',formatter:function(a){a=a||[];return a.join(",");}},change:function(e){var s=e.getSource();s.getBinding("value").setRawValue(s.getValue().split(","));},editable:c.editable,placeholder:c.placeholder}};}}else{v={type:T,settings:{text:{path:'currentSettings>value'},wrapping:false}};}}this._visualization=v;};
return b;});
sap.ui.predefine('sap/ui/integration/designtime/editor/fields/NumberField',["sap/ui/integration/designtime/editor/fields/BaseField","sap/m/Input","sap/ui/model/type/Float"],function(B,I,F){"use strict";
var N=B.extend("sap.ui.integration.designtime.editor.fields.NumberField",{renderer:B.getMetadata().getRenderer()});
N.prototype.initVisualization=function(c){var v=c.visualization;if(!v){v={type:I,settings:{value:{path:'currentSettings>value',type:new F()},editable:{path:'currentSettings>editable'},type:"Number"}};}this._visualization=v;};
return N;});
sap.ui.predefine('sap/ui/integration/designtime/editor/fields/Settings',["sap/ui/core/Control","sap/m/ResponsivePopover","sap/ui/model/json/JSONModel","sap/m/Button","sap/m/SegmentedButton","sap/m/SegmentedButtonItem","sap/m/VBox","sap/m/HBox","sap/m/Select","sap/ui/core/ListItem","sap/m/Label","sap/m/Text","sap/m/Title","sap/m/CheckBox","sap/m/Menu","sap/m/MenuItem","sap/m/Input","sap/ui/integration/util/ParameterMap","sap/base/util/merge","sap/ui/core/Core"],function(C,P,J,B,S,b,V,H,c,L,d,T,e,f,M,g,I,h,m,j){"use strict";
var k=C.extend("sap.ui.integration.designtime.editor.fields.Settings",{
metadata:{},
renderer:function(){}
});
k.prototype.setConfiguration=function(o){this._originalConfig=o;o=m({},o);var a=new J(o);this.setModel(a,"currentSettings");this.bindElement({path:"currentSettings>/"});};
k.prototype.open=function(o,a,i,n,v,e1,f1){this.addDependent(z);this.oHost=n;this.fnApply=e1;this.fnCancel=f1;this._oOpener=v;p=true;o.addDependent(this);q=this;this.getModel("currentSettings").checkUpdate(true,true);b1(r.getText("CARDEDITOR_SELECT_FROM_LIST"),[]);if(a){z.setContentWidth((i.getDomRef().offsetWidth+30)+"px");z.setContentHeight((i.getDomRef().offsetHeight-80)+"px");z.setPlacement("Right");u.setValue(o._label);z.openBy(o);}else{z.open();}l=this.getModel("currentSettings");if(l.getProperty("/_hasDynamicValue")){E();}else if(l.getProperty("/_hasSettings")){A();}else if(l.getProperty("/allowDynamicValues")){E();}else if(l.getProperty("/allowSettings")){A();}};
var r=j.getLibraryResourceBundle("sap.ui.integration"),l,p,q=null,D,s,t,u,w,x,y,F;
k.prototype._applyCurrentSettings=function(){this.fnApply(l.getData());};
k.prototype._cancelCurrentSettings=function(){this.fnCancel(this._originalConfig);};
k.prototype.destroy=function(){this.removeDependent(z);return C.prototype.destroy.apply(this,arguments);};
var z=new P({showArrow:true,contentWidth:"400px",showHeader:false,horizontalScrolling:false,modal:false,endButton:new B({text:r.getText("CARDEDITOR_MORE_CANCEL"),press:function(){z.close();}}),beginButton:new B({text:r.getText("CARDEDITOR_MORE_OK"),type:"Emphasized",press:function(){q._applyCurrentSettings();p=false;z.close();}}),afterClose:function(){if(p){q._cancelCurrentSettings();}p=true;}});z.attachAfterOpen(function(){var o=this.getDomRef().querySelector("footer"),a=U.getDomRef();if(a.nextSibling!==o){o.parentNode.insertBefore(a,o);o.style.marginTop="0rem";a.style.display="flex";}var i=W.getDomRef(),n=o.querySelector("button").parentNode;if(i){n.insertBefore(i,n.firstChild);}window.requestAnimationFrame(function(){z.getDomRef()&&(z.getDomRef().style.opacity="1");});});
function A(){s.setVisible(true);D.setVisible(false);G.setSelectedKey("settings");var o=U.getDomRef();window.requestAnimationFrame(function(){o&&(o.style.opacity="0");});}
function E(){s.setVisible(false);D.setVisible(true);G.setSelectedKey("dynamic");var a=q.getModel("contextflat"),o=a._getValueObject(l.getProperty("/value"));if(o&&o.object.label){u.setValue(o.object.label);b1(o.object.description,o.object.tags);if(o.path==="empty"){u.setValue(o.object.label);}d1(o);}var i=U.getDomRef();window.requestAnimationFrame(function(){i&&(i.style.opacity="1");});}
z.addStyleClass("sapUiIntegrationFieldSettings");var G=new S({width:"100%",visible:"{= ${currentSettings>allowDynamicValues} && ${currentSettings>allowSettings}}"});var K=new b({text:r.getText("CARDEDITOR_MORE_DYNAMICVALUES"),key:"dynamic",icon:"{= ${currentSettings>_hasDynamicValue} ? 'sap-icon://display-more' : 'sap-icon://enter-more'}",width:"50%",press:E});K.addStyleClass("dynbtn sel");var N=new b({text:r.getText("CARDEDITOR_MORE_SETTINGS"),key:"settings",icon:"sap-icon://action-settings",width:"50%",press:A});N.addStyleClass("setbtn");G.addItem(K);G.addItem(N);var O=new T({text:r.getText("CARDEDITOR_MORE_DYNAMICVALUES"),visible:"{= ${currentSettings>allowDynamicValues} && !${currentSettings>allowSettings}}"});O.addStyleClass("sapUiTinyMagin");var Q=new T({text:r.getText("CARDEDITOR_MORE_SETTINGS"),visible:"{= !${currentSettings>allowDynamicValues} && ${currentSettings>allowSettings}}"});Q.addStyleClass("sapUiTinyMagin");var R=new H({width:"100%",items:[G,O,Q]});R.addStyleClass("headertitle");var U=new V({width:"100%",items:[new T({text:r.getText("CARDEDITOR_ACTUAL_VALUE")}),new I({value:{path:"currentSettings>_currentContextValue"},editable:false})]});U.addStyleClass("currentval");var W=new B({type:"Transparent",text:r.getText("CARDEDITOR_MORE_RESET"),enabled:"{= ${currentSettings>_next/visible} === false || ${currentSettings>_next/editable} === false || ${currentSettings>_next/allowDynamicValues} === false || ${currentSettings>_beforeValue} !== ${currentSettings>value}}",tooltip:r.getText("CARDEDITOR_MORE_SETTINGS_P_ADMIN_RESET"),press:function(){Y("visible",true);Y("editable",true);Y("allowDynamicValues",true);l.setProperty("/value",l.getProperty("/_beforeValue"));z.getBeginButton().firePress();}});W.addStyleClass("resetbutton");var X=new V({width:"100%",items:[R,U,W]});X.addStyleClass("tabs");z.setCustomHeader(X);
function Y(a,v){if(!l.getProperty("/_next")){l.setProperty("/_next",{});}l.setProperty("/_next/"+a,v);}
function Z(o,v){var a=[];for(var n in o){if(o[n]&&o[n].label){var e1=new g({text:o[n].label});e1.__data=o[n];o[n].pathvalue=(v+"/"+n).substring(1);a.push(e1);var f1=Z(o[n],v+"/"+n);for(var i=0;i<f1.length;i++){e1.addItem(f1[i]);}}}return a;}
function $(){D=new V({visible:true});s=new V({visible:false});D.addStyleClass("sapUiSmallMargin");u=new I({width:"100%",showValueHelp:true,valueHelpOnly:true,valueHelpRequest:function(){if(w){w.destroy();}w=new M({});x=Z(D.getModel("context").getData(),"");for(var i=0;i<x.length;i++){w.addItem(x[i]);}w.attachItemSelected(function(a){var n=a.getParameter("item").__data;b1(n.description||"",n.tags||[]);u.setValue(n.placeholder||n.label);var e1=q.getModel("contextflat");d1(e1._getPathObject(n.pathvalue));});u.addDependent(w);w.addStyleClass("sapUiIntegrationFieldSettingsMenu");w.openBy(u,false,null,null,"1 0");}});u.addStyleClass("selectvariable");var v=new V({items:[new d({text:"Select a dynamic value"}),u]});D.addItem(v);t=new T({text:"",maxLines:6,renderWhitespace:true});v=new V({width:"100%",items:[t]});t.addStyleClass("description");D.addItem(v);if(_.length===-1){y=new c({width:"100%",enabled:true,change:function(){F.setText(y.getSelectedItem()._data.description);}});v=new V({visible:false,items:[new d({text:"Customize the value..."}),y]});D.addItem(v);F=new T({text:"",maxLines:4,renderWhitespace:true});F.addStyleClass("description");v=new V({width:"100%",items:[F]});D.addItem(v);D.getItems()[2].getItems()[0].addStyleClass("sapUiTinyMarginTop");}D.getItems()[0].getItems()[0].addStyleClass("sapUiTinyMarginTop");s.addStyleClass("sapUiSmallMargin");s.addItem(new H({items:[new e({text:r.getText("CARDEDITOR_MORE_SETTINGS_P_ADMIN")}),new B({type:"Transparent",tooltip:r.getText("CARDEDITOR_MORE_SETTINGS_P_ADMIN_RESET"),enabled:"{= ${currentSettings>_next/visible} === false || ${currentSettings>_next/editable} === false || ${currentSettings>_next/allowDynamicValues} === false}",icon:"sap-icon://reset",visible:false,press:function(){s.getItems()[1].getItems()[1].focus();Y("visible",true);Y("editable",true);Y("allowDynamicValues",true);}})]}));s.addItem(new H({items:[new d({text:r.getText("CARDEDITOR_MORE_SETTINGS_P_ADMIN_VISIBLE")}),new f({selected:"{= ${currentSettings>_next/visible} !== false}",select:function(a){Y("visible",a.getParameter("selected"));}})]}));s.addItem(new H({items:[new d({text:r.getText("CARDEDITOR_MORE_SETTINGS_P_ADMIN_EDIT")}),new f({selected:"{= ${currentSettings>_next/editable} !== false}",enabled:"{= ${currentSettings>_next/visible} !== false}",select:function(a){Y("editable",a.getParameter("selected"));}})]}));s.addItem(new H({visible:"{= ${currentSettings>allowDynamicValues}!== false}",items:[new d({text:r.getText("CARDEDITOR_MORE_SETTINGS_P_ADMIN_DYN")}),new f({selected:"{= ${currentSettings>_next/allowDynamicValues} !== false}",enabled:"{= ${currentSettings>_next/visible} !== false && ${currentSettings>_next/editable} !== false}",select:function(a){Y("allowDynamicValues",a.getParameter("selected"));}})]}));var o=s.getItems();o[0].addStyleClass("stitle");o[1].addStyleClass("cbrow");o[2].addStyleClass("cbrow");o[3].addStyleClass("cbrow");z.addContent(D);z.addContent(s);}
var _=[{formatMethod:"format.DateTime",sourceTypes:["datetime","date"],label:"Relative date/datetime text of the value",description:"Should be applied to dynamic values of type date or datetime or string values that represent a datetime in the format 'yyyy-MM-ddZhh:mm:ss'",example:"4 weeks ago",syntax:"handlebars",binding:"{= format.dateTime('__|VALUE|__',{relative:true})}"},{formatMethod:"format.DateTime",sourceTypes:["datetime","date"],label:"Short date/datetime text of the value",description:"Should be applied to dynamic values of type date, date-time or text values that represent a datetime in the format 'yyyy-MM-ddZhh:mm:ss.sss'",example:"9/18/20, 2:09 PM",binding:"{= format.dateTime('__|VALUE|__',{style:'short'})}"},{formatMethod:"format.DateTime",sourceTypes:["datetime","date"],label:"Medium date/datetime text of the value",description:"Should be applied to dynamic values of type date, date-time or text values that represent a datetime in the format 'yyyy-MM-ddThh:mm:ss.sssZ'",example:"Sep 18, 2020, 2:09:04 PM",binding:"{= format.dateTime('__|VALUE|__',{style:'medium'})}"},{formatMethod:"format.DateTime",sourceTypes:["datetime","date"],label:"Long date, date-time text of the value",description:"Should be applied to dynamic values of type date or date-time or string values that represent a datetime in the format 'yyyy-MM-ddThh:mm:ss.sssZ'",example:"Sep 18, 2020, 2:09:04 PM",binding:"{= format.dateTime('__|VALUE|__',{style:'long'})}"}];
function a1(a,n){a=a||[];y.removeAllItems();var o=[];y.addItem(new L({text:"No customizing needed",key:""}));for(var i=0;i<_.length;i++){var v=_[i],e1=new L({text:v.label,key:"key"+i});e1._data=v;if(v.sourceTypes.indexOf(n)>-1||a.indexOf(v.formatMethod)>-1){y.addItem(e1);}else{o.push(e1);}}for(var i=0;i<o.length;i++){y.addItem(o[i]);}}
$();
function b1(a,i){i=i||[];if(i.indexOf("technical")>-1){a=a+"\n"+r.getText("CARDEDITOR_MORE_DYNAMICVALUES_TECHHINT");}t.setText(a);}
function c1(o){if(_.length===-1){if(!o){y.removeAllItems();y.addItem(new L({text:"No customizing available for this value"}));F.setText("");y.setEnabled(false);}else{a1(o.customize,o.type);y.setEnabled(true);}}}
function d1(o){if(o){l.setProperty("/_hasDynamicValue",true);var a=o.value;l.setProperty("/value",a);l.setProperty("/_contextpath",o.path);if(o.object&&o.object.value&&o.object.value.indexOf("{{")===0){l.setProperty("/_currentContextValue",h.processPredefinedParameter(o.object.value));c1(o.object);}else{if(o.path==="empty"){l.setProperty("/value","");l.setProperty("/_currentContextValue","");l.setProperty("/_hasDynamicValue",false);c1();}else{c1(o.object);if(o.object&&o.object.hasOwnProperty("value")){l.setProperty("/_currentContextValue",o.object.value);}else{q.oHost.getContextValue(o.path+"/value").then(function(v){if(v===null){l.setProperty("/_currentContextValue","(not available)");}else{l.setProperty("/_currentContextValue",v);}o.object&&(o.object.value=v);});}}}}}
k._private=function(){return{oPopover:z,oSegmentedButton:G,oSettingsButton:N,oDynamicPanel:D,oSettingsPanel:s,oCurrentModel:l,updateCurrentValue:d1,oCurrentInstance:q,oDynamicValueField:u,getMenuItems:function(){return x;},getMenu:function(){return w;}};};
return k;});
sap.ui.predefine('sap/ui/integration/designtime/editor/fields/StringField',["sap/ui/integration/designtime/editor/fields/BaseField","sap/m/Input","sap/m/Text","sap/m/Select","sap/m/ComboBox","sap/ui/core/ListItem","./viz/IconSelect"],function(B,I,T,S,C,L,a){"use strict";
var b=B.extend("sap.ui.integration.designtime.editor.fields.StringField",{renderer:B.getMetadata().getRenderer()});
b.prototype.initVisualization=function(c){var v=c.visualization;if(!v){if(c.editable){if(c.enum){var i=new L({key:{path:"currentSettings>"},text:{path:"currentSettings>"}});v={type:S,settings:{selectedKey:{path:'currentSettings>value'},editable:c.editable,showSecondaryValues:false,width:"100%",items:{path:"currentSettings>enum",template:i}}};}else if(c.values){var i=new L(c.values.item);v={type:S,settings:{busy:{path:'currentSettings>_loading'},selectedKey:{path:'currentSettings>value'},editable:c.editable,showSecondaryValues:true,width:"100%",items:{path:"",template:i}}};}else{v={type:I,settings:{value:{path:'currentSettings>value'},editable:c.editable,placeholder:c.placeholder}};}}else{if(this.getMode()==="translation"){v={type:T,settings:{text:{path:'currentSettings>value'},wrapping:false}};}else{v={type:I,settings:{value:{path:'currentSettings>value'},editable:false}};}}}this._visualization=v;};
return b;});
sap.ui.predefine('sap/ui/integration/designtime/editor/fields/viz/ColorSelect',["sap/ui/core/Control","sap/m/ColorPalettePopover","sap/m/Button","sap/ui/core/Core","sap/base/util/merge","sap/ui/core/theming/Parameters"],function(C,a,B,b,m,P){"use strict";
var c=C.extend("sap.ui.integration.designtime.editor.fields.viz.ColorSelect",{
metadata:{properties:{enumValue:{type:"string",defaultValue:""},colorValue:{type:"string",defaultValue:""},editable:{type:"boolean",defaultValue:true},colorEnum:{type:"string",defaultValue:"sap.m.AvatarColor"},background:{type:"boolean",defaultValue:true},allowCustomColors:{type:"boolean",defaultValue:false}},aggregations:{_colorpalette:{type:"sap.m.ColorPalettePopover",multiple:false,visibility:"hidden"},_button:{type:"sap.m.Button",multiple:false,visibility:"hidden"}}},
renderer:function(r,f){var g=f.getAggregation("_button");r.openStart("div");r.addClass("sapUiIntegrationColorSelect");r.writeClasses();r.writeStyles();r.writeElementData(f);r.openEnd();r.renderControl(g);r.close("div");}
});
var e={};
function s(){e={"sap.m.AvatarColor":{"Accent1":P.get("sapUiAccent1"),"Accent2":P.get("sapUiAccent2"),"Accent3":P.get("sapUiAccent3"),"Accent4":P.get("sapUiAccent4"),"Accent5":P.get("sapUiAccent5"),"Accent6":P.get("sapUiAccent6"),"Accent7":P.get("sapUiAccent7"),"Accent8":P.get("sapUiAccent8"),"Accent9":P.get("sapUiAccent9"),"Accent10":P.get("sapUiAccent10"),"TileIcon":P.get("sapUiTileIconColor"),"Transparent":"transparent","Placeholder":P.get("sapUiContentImagePlaceholderBackground")}};}
s();b.attachThemeChanged(s);var o,d=new a("oColorPalettePopoverFull",{colorSelect:function(E){var f=E.getParameter("value"),g=e[o.getColorEnum()],i=Object.values(g).indexOf(f);o.setEnumValue(Object.keys(g)[i]);o.setColorValue(f);o._colorValue=f;}});
c.prototype.init=function(){this._oButton=new B({icon:"sap-icon://color-fill",press:function(){this._openPalette();}.bind(this)});this._colorValue="transparent";this.setAggregation("_button",this._oButton);};
c.prototype.onBeforeRendering=function(){if(!this._oStyle){this._oStyle=document.createElement("style");this._oStyle.innerHTML="#"+this.getId()+" .sapUiIcon::before { color: "+this._colorValue+" !important}";document.body.appendChild(this._oStyle);}var r=this._oStyle.sheet.rules[0];if(!this._colorValue||this._colorValue==="transparent"){r.style.opacity="0.5";r.style.color="transparent";r.style.backgroundSize="10px 10px";r.style.backgroundPosition="0px 0px, 0px 10px, 10px -10px, -10px 10px";r.style.border="1px dashed #808080";r.style.padding="0px 0px";r.style.backgroundImage="linear-gradient(45deg, #ddd 25%, transparent 25%), linear-gradient(-45deg, #ddd 25%, transparent 25%), linear-gradient(45deg, transparent 75%, #ddd 75%), linear-gradient(-45deg, transparent 75%, #ddd 75%)";}else{r.style.textShadow="unset";r.style.opacity="unset";r.style.backgroundSize="unset";r.style.backgroundPosition="unset";r.style.border="unset";r.style.padding="unset";r.style.backgroundImage="unset";r.style.color=this._colorValue;}};
c.prototype._openPalette=function(){o=this;d.setShowDefaultColorButton(true);d.setShowMoreColorsButton(false);d.setDefaultColor("");var E=e[this.getColorEnum()];if(E){var f=[];for(var n in E){f.push(E[n]);}d.setColors(f);}d.openBy(this._oButton);};
c.prototype.setEnumValue=function(v){this.setProperty("enumValue",v,true);this._colorValue=e[this.getColorEnum()][v];this.rerender();};
c.prototype.bindProperty=function(p,f){C.prototype.bindProperty.apply(this,arguments);if(p==="editable"){var g=m({},f);this._oButton.bindProperty("enabled",g);}return this;};
return c;});
sap.ui.predefine('sap/ui/integration/designtime/editor/fields/viz/IconSelect',["sap/ui/core/Control","sap/m/Select","sap/ui/core/ListItem","sap/ui/model/json/JSONModel","sap/ui/core/IconPool","sap/base/util/merge","sap/ui/core/Core","sap/base/util/deepClone"],function(C,S,L,J,I,m,c,d){"use strict";var r=c.getLibraryResourceBundle("sap.ui.integration"),D;
var e=C.extend("sap.ui.integration.designtime.editor.fields.viz.IconSelect",{
metadata:{properties:{value:{type:"string",defaultValue:"sap-icon://accept"},editable:{type:"boolean",defaultValue:true},allowFile:{type:"boolean",defaultValue:true},allowNone:{type:"boolean",defaultValue:true}},aggregations:{_select:{type:"sap.m.Select",multiple:false,visibility:"hidden"}}},
renderer:function(R,o){var s=o.getAggregation("_select");R.openStart("div");R.addClass("sapUiIntegrationIconSelect");if(s&&o.getWidth){R.addStyle("width",s.getWidth());}R.writeClasses();R.writeStyles();R.writeElementData(o);R.openEnd();R.renderControl(s);R.close("div");}
});
e.prototype._initIconModel=function(){var i=I.getIconNames();i=i.sort(function(a,b){return a.toLowerCase().localeCompare(b.toLowerCase());});var f=[];if(!D){i.filter(function(s){var t=I.getIconInfo(s).text||("-"+s).replace(/-(.)/ig,function(M,a){return" "+a.toUpperCase();}).substring(1);f.push({icon:"sap-icon://"+s,key:"sap-icon://"+s,text:t,tooltip:t,enabled:true});});f=[{icon:"",text:r.getText("CARDEDITOR_ICON_NONE"),tooltip:"",key:"empty",enabled:true},{icon:"sap-icon://upload",text:r.getText("CARDEDITOR_ICON_CHOOSE"),tooltip:"",key:"file",enabled:true},{icon:"sap-icon://download",text:r.getText("CARDEDITOR_ICON_SELECTED"),tooltip:"",key:"selected",enabled:false}].concat(f);D=d(f);}else{f=d(D);}this._oIconModel=new J(f);this._oIconModel.setSizeLimit(f.length);};
e.prototype.init=function(){if(!this._oIconModel){this._initIconModel();}var i=new L({icon:"{iconlist>icon}",text:"{iconlist>text}",tooltip:"{iconlist>tooltip}",key:"{iconlist>key}",enabled:"{iconlist>enabled}"});this._oFileUpload=document.createElement("INPUT");this._oFileUpload.type="file";this._oFileUpload.accept=".png,.jpg,.jpeg,.svg";this._boundFileUploadChange=this._fileUploadChange.bind(this);this._oFileUpload.addEventListener("change",this._boundFileUploadChange);this._oSelect=new S({width:"100%",items:{path:"iconlist>/",template:i},change:function(E){var s=E.getSource(),a=E.getSource().getSelectedKey();if(a==="file"){s._customImage=null;this._oFileUpload.click();this._boundFocusBack=this._focusBack.bind(this);s.getDomRef("hiddenSelect").addEventListener("focus",this._boundFocusBack);}else{this.setValue(a);}}.bind(this)});this._oSelect.setModel(this._oIconModel,"iconlist");var o=this._oSelect.open;this._oSelect.open=function(){o&&o.apply(this,arguments);this.getPicker().addStyleClass("sapUiIntegrationIconSelectList");this.getPicker().setContentHeight("400px");};this._oSelect.addDelegate({onAfterRendering:function(){var a=this._oSelect.getDomRef("labelIcon");if(a){var s=this._oSelect._customImage;if(s){a.style.backgroundImage="url('"+s+"')";a.classList.add("sapMSelectListItemIconCustom");}else{a.style.backgroundImage="unset";a.classList.remove("sapMSelectListItemIconCustom");}}}.bind(this)});this._oSelect.addDelegate({onsappageup:function(){if(this._oSelect.isOpen()){var s=this._oSelect.getSelectedIndex();this._oSelect.setSelectedIndex(s-50);}}.bind(this),onsappagedown:function(){if(this._oSelect.isOpen()){var s=this._oSelect.getSelectedIndex();if(s<3){this._oSelect.setSelectedIndex(29);}else{this._oSelect.setSelectedIndex(s+50);}}}.bind(this),onsapup:function(){if(this._oSelect.isOpen()){var a=this.getAllowFile();var A=this.getAllowNone();var f=this._oIconModel.getProperty("/2/enabled");var s=this._oSelect.getSelectedIndex();if(s>11+2){this._oSelect.setSelectedIndex(s-11);}else if(s>=3){if(A&&!a){this._oSelect.setSelectedIndex(0);}else if(f){this._oSelect.setSelectedIndex(2);}else{this._oSelect.setSelectedIndex(3);}}}}.bind(this),onsapdown:function(){if(this._oSelect.isOpen()){var s=this._oSelect.getSelectedIndex();if(s>1){this._oSelect.setSelectedIndex(s+11);}}}.bind(this),onsapleft:function(){if(this._oSelect.isOpen()){this._oSelect.onsapup.apply(this._oSelect,arguments);}}.bind(this),onsapright:function(){if(this._oSelect.isOpen()){this._oSelect.onsapdown.apply(this._oSelect,arguments);}}.bind(this)},true);this.setAggregation("_select",this._oSelect);};
e.prototype._fileUploadChange=function(){var f=new window.FileReader();f.onload=function(){this.setValue(f.result);this._oSelect.invalidate();}.bind(this);if(this._oFileUpload.files.length===1){f.readAsDataURL(this._oFileUpload.files[0]);}};
e.prototype._focusBack=function(){this._oSelect.getDomRef("hiddenSelect").removeEventListener("focus",this._boundFocusBack);setTimeout(function(){this.setValue(this.getValue());}.bind(this),150);};
e.prototype.bindProperty=function(p,b){C.prototype.bindProperty.apply(this,arguments);if(p==="editable"){var s=m({},b);this._oSelect.bindProperty("editable",s);}return this;};
e.prototype.setValue=function(v){this.setProperty("value",v,true);if(v.indexOf("data:image/")===0){this._oSelect._customImage=v;this._oIconModel.setProperty("/2/enabled",true);this._oSelect.setSelectedKey("selected");}else{this._oSelect._customImage=null;this._oIconModel.setProperty("/2/enabled",false);this._oSelect.setSelectedKey(v);}this._oSelect.invalidate();return this;};
e.prototype.setAllowFile=function(v){this.setProperty("allowFile",v,true);v=this.getAllowFile();this._oIconModel.setProperty("/1/enabled",v);return this;};
e.prototype.setAllowNone=function(v){this.setProperty("allowNone",v,true);v=this.getAllowNone();this._oIconModel.setProperty("/0/enabled",v);return this;};
return e;});
sap.ui.predefine('sap/ui/integration/designtime/editor/fields/viz/ShapeSelect',["sap/ui/core/Control","sap/m/SegmentedButton","sap/m/SegmentedButtonItem","sap/ui/core/Core","sap/base/util/merge","sap/ui/core/theming/Parameters"],function(C,S,a,b,m,P){"use strict";
var c=C.extend("sap.ui.integration.designtime.editor.fields.viz.ShapeSelect",{
metadata:{properties:{value:{type:"string",defaultValue:"Circle"},editable:{type:"boolean",defaultValue:true}},aggregations:{_segmentedbutton:{type:"sap.m.SegmentedButton",multiple:false,visibility:"hidden"}}},
renderer:function(r,o){var s=o.getAggregation("_segmentedbutton");r.openStart("div");r.addClass("sapUiIntegrationShapeSelect");r.writeClasses();r.writeStyles();r.writeElementData(o);r.openEnd();r.renderControl(s);r.close("div");}
});
c.prototype.init=function(){this._oSegmentedButton=new S({items:[new a({icon:"sap-icon://circle-task",key:"Circle"}),new a({icon:"sap-icon://border",key:"Square"})]});this.setAggregation("_segmentedbutton",this._oSegmentedButton);};
c.prototype.bindProperty=function(p,B){C.prototype.bindProperty.apply(this,arguments);if(p==="editable"){var s=m({},B);this._oSegmentedButton.bindProperty("enabled",s);}if(p==="value"){var s=m({},B);this._oSegmentedButton.bindProperty("selectedKey",s);}return this;};
return c;});
sap.ui.predefine('sap/ui/model/odata/type/DateTimeBase',["sap/base/Log","sap/ui/core/format/DateFormat","sap/ui/model/FormatException","sap/ui/model/ParseException","sap/ui/model/ValidateException","sap/ui/model/odata/type/ODataType","sap/ui/thirdparty/jquery"],function(L,D,F,P,V,O,q){"use strict";var f=new Date().getFullYear(),d=new Date(Date.UTC(f,11,31)),o=new Date(f,11,31,23,59,58);
function i(t){return t.oConstraints&&t.oConstraints.isDateOnly;}
function g(t){return sap.ui.getCore().getLibraryResourceBundle().getText(i(t)?"EnterDate":"EnterDateTime",[t.formatValue(i(t)?d:o,"string")]);}
function a(t){var c;if(!t.oFormat){c=q.extend({strictParsing:true},t.oFormatOptions);if(i(t)){c.UTC=true;t.oFormat=D.getDateInstance(c);}else{t.oFormat=D.getDateTimeInstance(c);}}return t.oFormat;}
function s(t,c){var n,p;t.oConstraints=undefined;if(c){n=c.nullable;if(n===false||n==="false"){t.oConstraints={nullable:false};}else if(n!==undefined&&n!==true&&n!=="true"){L.warning("Illegal nullable: "+n,null,t.getName());}if(c.isDateOnly===true){t.oConstraints=t.oConstraints||{};t.oConstraints.isDateOnly=true;}p=c.precision;if(p!==undefined){if(p===Math.floor(p)&&p>=1&&p<=12){t.oConstraints=t.oConstraints||{};t.oConstraints.precision=p;}else if(p!==0){L.warning("Illegal precision: "+p,null,t.getName());}}}t._handleLocalizationChange();}
var b=O.extend("sap.ui.model.odata.type.DateTimeBase",{
constructor:function(c,C){O.apply(this,arguments);s(this,C);this.oFormat=null;this.oFormatOptions=c;},
metadata:{"abstract":true}
});
b.prototype.formatValue=function(v,t){if(v===null||v===undefined){return null;}switch(this.getPrimitiveType(t)){case"any":case"object":return v;case"string":if(!(v instanceof Date)){throw new F("Illegal "+this.getName()+" value: "+v);}return a(this).format(v);default:throw new F("Don't know how to format "+this.getName()+" to "+t);}};
b.prototype.parseValue=function(v,S){var r;if(v===null||v===""){return null;}switch(this.getPrimitiveType(S)){case"object":return v;case"string":r=a(this).parse(v);if(!r){throw new P(g(this));}return r;default:throw new P("Don't know how to parse "+this.getName()+" from "+S);}};
b.prototype._handleLocalizationChange=function(){this.oFormat=null;};
b.prototype.validateValue=function(v){if(v===null){if(this.oConstraints&&this.oConstraints.nullable===false){throw new V(g(this));}return;}else if(v instanceof Date){if(v.getFullYear()===0){throw new V(g(this));}return;}throw new V("Illegal "+this.getName()+" value: "+v);};
return b;});
sap.ui.predefine('sap/ui/model/odata/type/ODataType',["sap/ui/model/SimpleType"],function(S){"use strict";
var O=S.extend("sap.ui.model.odata.type.ODataType",{
constructor:function(f,c){},
metadata:{"abstract":true}
});
O.prototype.getInterface=function(){return this;};
O.prototype.setConstraints=function(c){};
O.prototype.setFormatOptions=function(f){};
return O;});
sap.ui.predefine('sap/ui/model/type/Date',['sap/ui/core/format/DateFormat','sap/ui/model/SimpleType','sap/ui/model/FormatException','sap/ui/model/ParseException','sap/ui/model/ValidateException',"sap/ui/thirdparty/jquery","sap/base/util/isEmptyObject"],function(D,S,F,P,V,q,i){"use strict";
var a=S.extend("sap.ui.model.type.Date",{constructor:function(){S.apply(this,arguments);this.sName="Date";}});
a.prototype.formatValue=function(v,I){var f;switch(this.getPrimitiveType(I)){case"string":case"any":if(v==null){return"";}if(this.oFormatOptions.source&&this.oFormatOptions.source.pattern!=="timestamp"&&v===""){return"";}f=this.getModelFormat();v=f.parse(v);return this.oOutputFormat.format(v);default:throw new F("Don't know how to format Date to "+I);}};
a.prototype.parseValue=function(v,I){var r,b;switch(this.getPrimitiveType(I)){case"string":if(v===""){return null;}var r=this.oOutputFormat.parse(v);if(!r){b=sap.ui.getCore().getLibraryResourceBundle();throw new P(b.getText(this.sName+".Invalid"));}if(this.oInputFormat){if(this.oFormatOptions.source.pattern=="timestamp"){r=r.getTime();}else{r=this.oInputFormat.format(r);}}return r;default:throw new P("Don't know how to parse Date from "+I);}};
a.prototype.validateValue=function(v){if(this.oConstraints){var b=sap.ui.getCore().getLibraryResourceBundle(),c=[],m=[],I=this.oInputFormat,C,d=this;if(I&&this.oFormatOptions.source.pattern!="timestamp"){v=I.parse(v);}q.each(this.oConstraints,function(n,o){if(I){o=I.parse(o);}C=d.oOutputFormat.format(o);switch(n){case"minimum":if(v<o){c.push("minimum");m.push(b.getText(d.sName+".Minimum",[C]));}break;case"maximum":if(v>o){c.push("maximum");m.push(b.getText(d.sName+".Maximum",[C]));}break;}});if(c.length>0){throw new V(this.combineMessages(m),c);}}};
var t={format:function(v){if(v instanceof Date){return v.getTime();}return null;},parse:function(v){if(typeof(v)!="number"){if(isNaN(v)){throw new F("Cannot format date: "+v+" is not a valid Timestamp");}else{v=parseInt(v);}}v=new Date(v);return v;}};
a.prototype.getModelFormat=function(){if(this.oInputFormat){if(this.oFormatOptions.source.pattern=="timestamp"){return t;}else{return this.oInputFormat;}}else{return S.prototype.getModelFormat.call(this);}};
a.prototype.setFormatOptions=function(f){this.oFormatOptions=f;this._createFormats();};
a.prototype.getOutputPattern=function(){return this.oOutputFormat.oFormatOptions.pattern;};
a.prototype._handleLocalizationChange=function(){this._createFormats();};
a.prototype._createFormats=function(){var s=this.oFormatOptions.source;this.oOutputFormat=D.getInstance(this.oFormatOptions);if(s){if(i(s)){s={pattern:"yyyy-MM-dd"};}this.oInputFormat=D.getInstance(s);}};
return a;});
sap.ui.predefine('sap/ui/model/type/Float',['sap/ui/core/format/NumberFormat','sap/ui/model/SimpleType','sap/ui/model/FormatException','sap/ui/model/ParseException','sap/ui/model/ValidateException',"sap/ui/thirdparty/jquery","sap/base/util/isEmptyObject"],function(N,S,F,P,V,q,i){"use strict";
var a=S.extend("sap.ui.model.type.Float",{constructor:function(){S.apply(this,arguments);this.sName="Float";}});
a.prototype.formatValue=function(v,I){var f=v;if(v==undefined||v==null){return null;}if(this.oInputFormat){f=this.oInputFormat.parse(v);if(f==null){throw new F("Cannot format float: "+v+" has the wrong format");}}switch(this.getPrimitiveType(I)){case"string":return this.oOutputFormat.format(f);case"int":return Math.floor(f);case"float":case"any":return f;default:throw new F("Don't know how to format Float to "+I);}};
a.prototype.parseValue=function(v,I){var r,b;switch(this.getPrimitiveType(I)){case"string":r=this.oOutputFormat.parse(v);if(isNaN(r)){b=sap.ui.getCore().getLibraryResourceBundle();throw new P(b.getText("Float.Invalid"));}break;case"int":case"float":r=v;break;default:throw new P("Don't know how to parse Float from "+I);}if(this.oInputFormat){r=this.oInputFormat.format(r);}return r;};
a.prototype.validateValue=function(v){if(this.oConstraints){var b=sap.ui.getCore().getLibraryResourceBundle(),c=[],m=[],f=v,t=this;if(this.oInputFormat){f=this.oInputFormat.parse(v);}q.each(this.oConstraints,function(n,C){switch(n){case"minimum":if(f<C){c.push("minimum");m.push(b.getText("Float.Minimum",[t.oOutputFormat.format(C)]));}break;case"maximum":if(f>C){c.push("maximum");m.push(b.getText("Float.Maximum",[t.oOutputFormat.format(C)]));}}});if(c.length>0){throw new V(this.combineMessages(m),c);}}};
a.prototype.setFormatOptions=function(f){this.oFormatOptions=f;this._createFormats();};
a.prototype._handleLocalizationChange=function(){this._createFormats();};
a.prototype._createFormats=function(){var s=this.oFormatOptions.source;this.oOutputFormat=N.getFloatInstance(this.oFormatOptions);if(s){if(i(s)){s={groupingEnabled:false,groupingSeparator:",",decimalSeparator:"."};}this.oInputFormat=N.getFloatInstance(s);}};
return a;});
sap.ui.predefine('sap/ui/model/type/Integer',['sap/ui/core/format/NumberFormat','sap/ui/model/SimpleType','sap/ui/model/FormatException','sap/ui/model/ParseException','sap/ui/model/ValidateException',"sap/ui/thirdparty/jquery","sap/base/util/isEmptyObject"],function(N,S,F,P,V,q,i){"use strict";
var I=S.extend("sap.ui.model.type.Integer",{constructor:function(){S.apply(this,arguments);this.sName="Integer";}});
I.prototype.formatValue=function(v,s){var a=v;if(v==undefined||v==null){return null;}if(this.oInputFormat){a=this.oInputFormat.parse(v);if(a==null){throw new F("Cannot format float: "+v+" has the wrong format");}}switch(this.getPrimitiveType(s)){case"string":return this.oOutputFormat.format(a);case"int":case"float":case"any":return a;default:throw new F("Don't know how to format Integer to "+s);}};
I.prototype.parseValue=function(v,s){var r,b;switch(this.getPrimitiveType(s)){case"string":r=this.oOutputFormat.parse(String(v));if(isNaN(r)){b=sap.ui.getCore().getLibraryResourceBundle();throw new P(b.getText("EnterInt"));}break;case"float":r=Math.floor(v);if(r!=v){b=sap.ui.getCore().getLibraryResourceBundle();throw new P(b.getText("EnterInt"));}break;case"int":r=v;break;default:throw new P("Don't know how to parse Integer from "+s);}if(this.oInputFormat){r=this.oInputFormat.format(r);}return r;};
I.prototype.validateValue=function(v){if(this.oConstraints){var b=sap.ui.getCore().getLibraryResourceBundle(),a=[],m=[],c=v,t=this;if(this.oInputFormat){c=this.oInputFormat.parse(v);}q.each(this.oConstraints,function(n,C){switch(n){case"minimum":if(c<C){a.push("minimum");m.push(b.getText("Integer.Minimum",[t.oOutputFormat.format(C)]));}break;case"maximum":if(c>C){a.push("maximum");m.push(b.getText("Integer.Maximum",[t.oOutputFormat.format(C)]));}}});if(a.length>0){throw new V(this.combineMessages(m),a);}}};
I.prototype.setFormatOptions=function(f){this.oFormatOptions=f;this._createFormats();};
I.prototype._handleLocalizationChange=function(){this._createFormats();};
I.prototype._createFormats=function(){var s=this.oFormatOptions.source;this.oOutputFormat=N.getIntegerInstance(this.oFormatOptions);if(s){if(i(s)){s={groupingEnabled:false,groupingSeparator:",",decimalSeparator:"."};}this.oInputFormat=N.getIntegerInstance(s);}};
return I;});
sap.ui.predefine('sap/ui/unified/Menu',['sap/ui/core/Element','sap/ui/core/Control','sap/ui/Device','sap/ui/core/Popup','./MenuItemBase','./library','sap/ui/core/library','sap/ui/unified/MenuRenderer',"sap/ui/dom/containsOrEquals","sap/ui/thirdparty/jquery","sap/ui/events/KeyCodes","sap/base/Log","sap/ui/events/ControlEvents","sap/ui/events/PseudoEvents","sap/ui/events/checkMouseEnterOrLeave"],function(E,C,D,P,M,l,c,a,b,q,K,L,d,f,g){"use strict";var h=P.Dock;var O=c.OpenState;
var j=C.extend("sap.ui.unified.Menu",{metadata:{interfaces:["sap.ui.core.IContextMenu"],library:"sap.ui.unified",properties:{enabled:{type:"boolean",group:"Behavior",defaultValue:true},ariaDescription:{type:"string",group:"Accessibility",defaultValue:null},maxVisibleItems:{type:"int",group:"Behavior",defaultValue:0},pageSize:{type:"int",group:"Behavior",defaultValue:5}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.unified.MenuItemBase",multiple:true,singularName:"item"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{itemSelect:{parameters:{item:{type:"sap.ui.unified.MenuItemBase"}}}}}});
(function(w){j.prototype.bCozySupported=true;j._DELAY_SUBMENU_TIMER=300;j._DELAY_SUBMENU_TIMER_EXT=400;
j.prototype.init=function(){var t=this;this.bOpen=false;this.oOpenedSubMenu=null;this.oHoveredItem=null;this.oPopup=null;this._bOpenedAsContextMenu=false;this.fAnyEventHandlerProxy=q.proxy(function(e){var r=this.getRootMenu();if(r!=this||!this.bOpen||!this.getDomRef()||(e.type!="mousedown"&&e.type!="touchstart")){return;}r.handleOuterEvent(this.getId(),e);},this);this.fOrientationChangeHandler=function(){t.close();};this.bUseTopStyle=false;};
j.prototype._setCustomEnhanceAccStateFunction=function(e){this._fnCustomEnhanceAccStateFunction=e;};
j.prototype.enhanceAccessibilityState=function(e,A){var i=typeof this._fnCustomEnhanceAccStateFunction==="function";return i?this._fnCustomEnhanceAccStateFunction(e,A):A;};
j.prototype.exit=function(){if(this.oPopup){this.oPopup.detachClosed(this._menuClosed,this);this.oPopup.destroy();delete this.oPopup;}d.unbindAnyEvent(this.fAnyEventHandlerProxy);if(this._bOrientationChangeBound){q(w).off("orientationchange",this.fOrientationChangeHandler);this._bOrientationChangeBound=false;}this._resetDelayedRerenderItems();this._detachResizeHandler();};
j.prototype.invalidate=function(o){if(o instanceof M&&this.getDomRef()){this._delayedRerenderItems();}else{C.prototype.invalidate.apply(this,arguments);}};
j.prototype.onBeforeRendering=function(){this._resetDelayedRerenderItems();this.$().off("mousemove");};
j.prototype.onAfterRendering=function(){if(this.$().parent().attr("id")!="sap-ui-static"){L.error("sap.ui.unified.Menu: The Menu is popup based and must not be rendered directly as content of the page.");this.close();this.$().remove();}var I=this.getItems();for(var i=0;i<I.length;i++){if(I[i].onAfterRendering&&I[i].getDomRef()){I[i].onAfterRendering();}}if(this.oHoveredItem){this.oHoveredItem.hover(true,this);}m(this);this.$().on("mousemove",this._focusMenuItem.bind(this));};
j.prototype._focusMenuItem=function(e){if(!D.system.desktop){return;}var i=this.getItemByDomRef(e.target);if(!this.bOpen||!i){return;}if(this.oOpenedSubMenu&&b(this.oOpenedSubMenu.getDomRef(),e.target)){return;}this.setHoveredItem(i);i&&i.focus(this);this._openSubMenuDelayed(i);};
j.prototype.onThemeChanged=function(){if(this.getDomRef()&&this.getPopup().getOpenState()===O.OPEN){m(this);this.getPopup()._applyPosition(this.getPopup()._oLastPosition);}};
j.prototype.addItem=function(i){this.addAggregation("items",i,!!this.getDomRef());this._delayedRerenderItems();return this;};
j.prototype.insertItem=function(i,e){this.insertAggregation("items",i,e,!!this.getDomRef());this._delayedRerenderItems();return this;};
j.prototype.removeItem=function(i){this.removeAggregation("items",i,!!this.getDomRef());this._delayedRerenderItems();return this;};
j.prototype.removeAllItems=function(){var r=this.removeAllAggregation("items",!!this.getDomRef());this._delayedRerenderItems();return r;};
j.prototype.destroyItems=function(){this.destroyAggregation("items",!!this.getDomRef());this._delayedRerenderItems();return this;};
j.prototype._delayedRerenderItems=function(){if(!this.getDomRef()){return;}this._resetDelayedRerenderItems();this._discardOpenSubMenuDelayed();this._itemRerenderTimer=setTimeout(function(){var o=this.getDomRef();if(o){var r=sap.ui.getCore().createRenderManager();a.renderItems(r,this);r.flush(o);r.destroy();this.onAfterRendering();this.getPopup()._applyPosition(this.getPopup()._oLastPosition);}}.bind(this),0);};
j.prototype._resetDelayedRerenderItems=function(){if(this._itemRerenderTimer){clearTimeout(this._itemRerenderTimer);delete this._itemRerenderTimer;}};
j.prototype._detachResizeHandler=function(){if(this._hasResizeListener){D.resize.detachHandler(this._handleResizeChange,this);this._hasResizeListener=false;}};
j.prototype.open=function(W,o,e,i,n,p,r){var N;if(this.bOpen){return;}s(this,true);this.oOpenerRef=o;this.bIgnoreOpenerDOMRef=false;this.getPopup().open(0,e,i,n,p||"0 0",r||"flipfit flipfit",function(t){var u=this.getPopup()._getOfDom(n);if(!u||!q(u).is(":visible")||!_(u)){this.close();}else{this.getPopup()._applyPosition(t.lastPosition);}}.bind(this));this.bOpen=true;D.resize.attachHandler(this._handleResizeChange,this);this._hasResizeListener=true;if(W||this.getRootMenu().getId()===this.getId()){N=this.getNextSelectableItem(-1);this.setHoveredItem(N);N&&N.focus(this);}d.bindAnyEvent(this.fAnyEventHandlerProxy);if(D.support.orientation&&this.getRootMenu()===this){q(w).on("orientationchange",this.fOrientationChangeHandler);this._bOrientationChangeBound=true;}};
j.prototype._handleResizeChange=function(){this.getPopup()._applyPosition(this.getPopup()._oLastPosition);};
j.prototype.openAsContextMenu=function(e,o){var i,n,r,p,t;o=o instanceof E?o.getDomRef():o;if(e instanceof q.Event){t=q(o).offset();i=e.pageX-t.left;n=e.pageY-t.top;this._iX=e.clientX;this._iY=e.clientY;}else{i=e.offsetX||0;n=e.offsetY||0;this._iX=e.left||0;this._iY=e.top||0;}r=sap.ui.getCore().getConfiguration().getRTL();p=h;if(r){i=o.clientWidth-i;}this._bOpenedAsContextMenu=true;this.open(true,o,p.BeginTop,p.BeginTop,o,i+" "+n,'fit');};
j.prototype._handleOpened=function(){var $,W,i,e,r,B,R,n,o,p;if(!this._bOpenedAsContextMenu){return;}$=this.$();W=q(w);i=this._iX;e=this._iY;r=W.scrollLeft()+W.width();B=W.scrollTop()+W.height();R=sap.ui.getCore().getConfiguration().getRTL();n=false;o=$.width();p=$.height();if(e+p>B){e=e-p;n=true;}if(R){if((r-i)+o>r){i=r-(i+o);n=true;}else{i=r-i;n=true;}}else{if(i+o>r){i=i-o;n=true;}}this._bOpenedAsContextMenu=false;n&&this.oPopup.setPosition("begin top","begin top",W,i+" "+e,"flipfit");};
j.prototype.close=function(W){if(!this.bOpen||j._dbg){return;}this._discardOpenSubMenuDelayed();s(this,false);delete this._bFixed;d.unbindAnyEvent(this.fAnyEventHandlerProxy);if(this._bOrientationChangeBound){q(w).off("orientationchange",this.fOrientationChangeHandler);this._bOrientationChangeBound=false;}this.bOpen=false;this.closeSubmenu();this.setHoveredItem();if(!W){this.bIgnoreOpenerDOMRef=true;}this.getPopup().close(0);this._detachResizeHandler();this._resetDelayedRerenderItems();this.$().remove();this.bOutput=false;if(this.isSubMenu()){this.getParent().getParent().oOpenedSubMenu=null;}};
j.prototype._menuClosed=function(){if(this.oOpenerRef){if(!this.bIgnoreOpenerDOMRef){try{this.oOpenerRef.focus();}catch(e){L.warning("Menu.close cannot restore the focus on opener "+this.oOpenerRef+", "+e);}}this.oOpenerRef=undefined;}};
j.prototype.onclick=function(e){this.selectItem(this.getItemByDomRef(e.target),false,!!(e.metaKey||e.ctrlKey));e.preventDefault();e.stopPropagation();};
j.prototype.onsapnext=function(e){var i,n,S=this.oHoveredItem?this.oHoveredItem.getSubmenu():undefined;if(e.keyCode!=K.ARROW_DOWN){if(S&&this.checkEnabled(this.oHoveredItem)){if(S.bOpen){n=S.getNextSelectableItem(-1);S.setHoveredItem(n);n&&n.focus(this);}else{this.openSubmenu(this.oHoveredItem,true);}}return;}if(S&&S.bOpen){this.closeSubmenu(false,true);}i=this.oHoveredItem?this.indexOfAggregation("items",this.oHoveredItem):-1;n=this.getNextSelectableItem(i);this.setHoveredItem(n);n&&n.focus(this);e.preventDefault();e.stopPropagation();};
j.prototype.onsapnextmodifiers=j.prototype.onsapnext;
j.prototype.onsapprevious=function(e){var i=this.oHoveredItem?this.indexOfAggregation("items",this.oHoveredItem):-1,p=this.getPreviousSelectableItem(i),S=this.oHoveredItem?this.oHoveredItem.getSubmenu():null;if(e.keyCode!=K.ARROW_UP){if(this.isSubMenu()){this.close(true);}e.preventDefault();e.stopPropagation();return;}if(S&&S.bOpen){this.closeSubmenu(false,true);}this.setHoveredItem(p);p&&p.focus(this);e.preventDefault();e.stopPropagation();};
j.prototype.onsappreviousmodifiers=j.prototype.onsapprevious;
j.prototype.onsaphome=function(e){var n=this.getNextSelectableItem(-1);this.setHoveredItem(n);n&&n.focus(this);e.preventDefault();e.stopPropagation();};
j.prototype.onsapend=function(e){var p=this.getPreviousSelectableItem(this.getItems().length);this.setHoveredItem(p);p&&p.focus(this);e.preventDefault();e.stopPropagation();};
j.prototype.onsappagedown=function(e){var i=this.oHoveredItem?this.indexOfAggregation("items",this.oHoveredItem):-1,n;if(this.getPageSize()<1){this.onsapend(e);return;}i+=this.getPageSize();if(i>=this.getItems().length){this.onsapend(e);return;}n=this.getNextSelectableItem(i-1);this.setHoveredItem(n);n&&n.focus(this);e.preventDefault();e.stopPropagation();};
j.prototype.onsappageup=function(e){var i=this.oHoveredItem?this.indexOfAggregation("items",this.oHoveredItem):-1,p;if(this.getPageSize()<1){this.onsaphome(e);return;}i-=this.getPageSize();if(i<0){this.onsaphome(e);return;}p=this.getPreviousSelectableItem(i+1);this.setHoveredItem(p);p&&p.focus(this);e.preventDefault();e.stopPropagation();};
j.prototype.onsapselect=function(e){this._sapSelectOnKeyDown=true;e.preventDefault();e.stopPropagation();};
j.prototype.onkeyup=function(e){if(this.oHoveredItem&&(q(e.target).prop("tagName")!="INPUT")){var o=this.oHoveredItem.getDomRef();q(o).trigger("focus");}if(!this._sapSelectOnKeyDown&&(e.key!==K.Space||(!D.os.macintosh&&w.navigator.maxTouchPoints<=1))){return;}else{this._sapSelectOnKeyDown=false;}if(!f.events.sapselect.fnCheck(e)&&e.key!=="Enter"){return;}this.selectItem(this.oHoveredItem,true,false);e.preventDefault();e.stopPropagation();};
j.prototype.onsapbackspace=function(e){if(q(e.target).prop("tagName")!="INPUT"){e.preventDefault();}};
j.prototype.onsapbackspacemodifiers=j.prototype.onsapbackspace;
j.prototype.onsapescape=function(e){this.close(true);e.preventDefault();e.stopPropagation();};
j.prototype.onsaptabnext=function(e){if(this.isSubMenu()){e.preventDefault();}this.close(true);e.stopPropagation();};
j.prototype.onsaptabprevious=j.prototype.onsaptabnext;
j.prototype._openSubMenuDelayed=function(i){if(!i){return;}this._discardOpenSubMenuDelayed();this._delayedSubMenuTimer=setTimeout(function(){this.checkEnabled(i)&&this.closeSubmenu(false,true);if(this.checkEnabled(i)&&i.getSubmenu()){this.setHoveredItem(i);i&&i.focus(this);this.openSubmenu(i,false,true);}}.bind(this),i.getSubmenu()&&this.checkEnabled(i)?j._DELAY_SUBMENU_TIMER:j._DELAY_SUBMENU_TIMER_EXT);};
j.prototype._discardOpenSubMenuDelayed=function(i){if(this._delayedSubMenuTimer){clearTimeout(this._delayedSubMenuTimer);this._delayedSubMenuTimer=null;}};
j.prototype.onmouseout=function(e){if(!D.system.desktop){return;}if(g(e,this.getDomRef())){this.setHoveredItem(null);}else{this.setHoveredItem(this.oHoveredItem);}this._discardOpenSubMenuDelayed();};
j.prototype.onsapfocusleave=function(e){if(this.oOpenedSubMenu||!this.bOpen){return;}this.getRootMenu().handleOuterEvent(this.getId(),e);};
j.prototype.handleOuterEvent=function(o,e){var i=false,t=D.support.touch||D.system.combi;this.bIgnoreOpenerDOMRef=false;if(e.type=="mousedown"||e.type=="touchstart"){if(t&&(e.isMarked("delayedMouseEvent")||e.isMarked("cancelAutoClose"))){return;}var n=this;while(n&&!i){if(b(n.getDomRef(),e.target)){i=true;}n=n.oOpenedSubMenu;}}else if(e.type=="sapfocusleave"){if(t){return;}if(e.relatedControlId){var n=this;while(n&&!i){if((n.oOpenedSubMenu&&n.oOpenedSubMenu.getId()==e.relatedControlId)||b(n.getDomRef(),q(document.getElementById(e.relatedControlId)).get(0))){i=true;}n=n.oOpenedSubMenu;}}if(!i){this.bIgnoreOpenerDOMRef=true;}}if(!i){this.close();}};
j.prototype.getItemByDomRef=function(o){var I=this.getItems(),e=I.length;for(var i=0;i<e;i++){var n=I[i],p=n.getDomRef();if(b(p,o)){return n;}}return null;};
j.prototype.selectItem=function(i,W,e){if(!i||!(i instanceof M&&this.checkEnabled(i))){return;}var S=i.getSubmenu();if(!S){this.getRootMenu().close(true);}else{if(!D.system.desktop&&this.oOpenedSubMenu===S){this.closeSubmenu();}else{this.openSubmenu(i,W);}}i.fireSelect({item:i,ctrlKey:e});this.getRootMenu().fireItemSelect({item:i});};
j.prototype.isSubMenu=function(){return this.getParent()&&this.getParent().getParent&&this.getParent().getParent()instanceof j;};
j.prototype.getRootMenu=function(){var t=this;while(t.isSubMenu()){t=t.getParent().getParent();}return t;};
j.prototype.getMenuLevel=function(){var i=1;var t=this;while(t.isSubMenu()){t=t.getParent().getParent();i++;}return i;};
j.prototype.getPopup=function(){if(!this.oPopup){this.oPopup=new P(this,false,true,false);this.oPopup.setDurations(0,0);this.oPopup.attachClosed(this._menuClosed,this);this.oPopup.attachOpened(this._handleOpened,this);}return this.oPopup;};
j.prototype.setHoveredItem=function(i){if(this.oHoveredItem){this.oHoveredItem.hover(false,this);}if(!i){this.oHoveredItem=null;return;}this.oHoveredItem=i;i.hover(true,this);this.scrollToItem(this.oHoveredItem);};
j.prototype.openSubmenu=function(i,W,e){var S=i.getSubmenu();if(!S){return;}if(this.oOpenedSubMenu&&this.oOpenedSubMenu!==S){this.closeSubmenu();}if(this.oOpenedSubMenu){this.oOpenedSubMenu._bFixed=(e&&this.oOpenedSubMenu._bFixed)||(!e&&!this.oOpenedSubMenu._bFixed);this.oOpenedSubMenu._bringToFront();}else{this.oOpenedSubMenu=S;var n=P.Dock;S.open(W,i,n.BeginTop,n.EndTop,i,"-4 4");}};
j.prototype.closeSubmenu=function(i,I){if(this.oOpenedSubMenu){if(i&&this.oOpenedSubMenu._bFixed){return;}if(I){this.oOpenedSubMenu.bIgnoreOpenerDOMRef=true;}this.oOpenedSubMenu.close();this.oOpenedSubMenu=null;}};
j.prototype.scrollToItem=function(i){var o=this.getDomRef(),I=i?i.getDomRef():null;if(!I||!o){return;}var e=o.scrollTop,n=I.offsetTop,p=q(o).height(),r=q(I).height();if(e>n){o.scrollTop=n;}else if((n+r)>(e+p)){o.scrollTop=Math.ceil(n+r-p);}};
j.prototype._bringToFront=function(){q(document.getElementById(this.getPopup().getId())).mousedown();};
j.prototype.checkEnabled=function(i){return i&&i.getEnabled()&&this.getEnabled();};
j.prototype.getNextSelectableItem=function(I){var o=null;var e=this.getItems();for(var i=I+1;i<e.length;i++){if(e[i].getVisible()&&this.checkEnabled(e[i])){o=e[i];break;}}if(!o){for(var i=0;i<=I;i++){if(e[i].getVisible()&&this.checkEnabled(e[i])){o=e[i];break;}}}return o;};
j.prototype.getPreviousSelectableItem=function(I){var o=null;var e=this.getItems();for(var i=I-1;i>=0;i--){if(e[i].getVisible()&&this.checkEnabled(e[i])){o=e[i];break;}}if(!o){for(var i=e.length-1;i>=I;i--){if(e[i].getVisible()&&this.checkEnabled(e[i])){o=e[i];break;}}}return o;};
j.prototype.setRootMenuTopStyle=function(u){this.getRootMenu().bUseTopStyle=u;j.rerenderMenu(this.getRootMenu());};
j.rerenderMenu=function(o){var I=o.getItems();for(var i=0;i<I.length;i++){var S=I[i].getSubmenu();if(S){j.rerenderMenu(S);}}o.invalidate();o.rerender();};
j.prototype.focus=function(){if(this.bOpen){C.prototype.focus.apply(this,arguments);}};
j.prototype.isCozy=function(){if(!this.bCozySupported){return false;}if(this.hasStyleClass("sapUiSizeCozy")){return true;}if(k(this.oOpenerRef)){return true;}if(k(this.getParent())){return true;}return false;};
function k(r){if(!r){return false;}r=r.$?r.$():q(r);return r.closest(".sapUiSizeCompact,.sapUiSizeCondensed,.sapUiSizeCozy").hasClass("sapUiSizeCozy");}
function s(o,e){var p=o.getParent();if(p&&p instanceof M){p.onSubmenuToggle(e);}}
function m(o){var e=o.getMaxVisibleItems(),n=document.documentElement.clientHeight-10,$=o.$();if(e>0){var I=o.getItems();for(var i=0;i<I.length;i++){if(I[i].getDomRef()){n=Math.min(n,I[i].$().outerHeight(true)*e);break;}}}if($.outerHeight(true)>n){$.css("max-height",n+"px").toggleClass("sapUiMnuScroll",true);}else{$.css("max-height","").toggleClass("sapUiMnuScroll",false);}}
function _(o){var r;if(!o){return false;}if(o instanceof q){o=o.get(0);}r=o.getBoundingClientRect();return(r.top>=0&&r.left>=0&&r.bottom<=(w.innerHeight||document.documentElement.clientHeight)&&r.right<=(w.innerWidth||document.documentElement.clientWidth));}
})(window);return j;});
sap.ui.predefine('sap/ui/unified/MenuItem',['sap/ui/core/IconPool','./MenuItemBase','./library','sap/ui/core/library'],function(I,M,l,c){"use strict";
var a=M.extend("sap.ui.unified.MenuItem",{metadata:{library:"sap.ui.unified",properties:{text:{type:"string",group:"Appearance",defaultValue:''},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:''}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}}}});
I.insertFontFaceStyle();
a.prototype.render=function(r,i,m,o){var b=r,s=i.getSubmenu(),d=i.getEnabled();b.openStart("li",i);if(i.getVisible()&&d){b.attr("tabindex","0");}b.class("sapUiMnuItm");if(o.iItemNo==1){b.class("sapUiMnuItmFirst");}else if(o.iItemNo==o.iTotalItems){b.class("sapUiMnuItmLast");}if(!m.checkEnabled(i)){b.class("sapUiMnuItmDsbl");}if(i.getStartsSection()){b.class("sapUiMnuItmSepBefore");}if(!d){b.attr("disabled","disabled");}if(i.getTooltip_AsString()){b.attr("title",i.getTooltip_AsString());}if(o.bAccessible){b.accessibilityState(i,{role:"menuitem",disabled:null,posinset:o.iItemNo,setsize:o.iTotalItems,labelledby:{value:this.getId()+"-txt "+this.getId()+"-scuttxt",append:true}});if(s){b.attr("aria-haspopup",c.aria.HasPopup.Menu.toLowerCase());b.attr("aria-owns",s.getId());}}b.openEnd();b.openStart("div");b.class("sapUiMnuItmL");b.openEnd();b.close("div");if(i.getIcon()){b.openStart("div");b.class("sapUiMnuItmIco");b.openEnd();b.icon(i.getIcon(),null,{title:null});b.close("div");}b.openStart("div",this.getId()+"-txt");b.class("sapUiMnuItmTxt");b.openEnd();b.text(i.getText());b.close("div");b.openStart("div",this.getId()+"-scuttxt");b.class("sapUiMnuItmSCut");b.openEnd();b.close("div");b.openStart("div");b.class("sapUiMnuItmSbMnu");b.openEnd();if(s){b.openStart("div");b.class("sapUiIconMirrorInRTL");b.openEnd();b.close("div");}b.close("div");b.openStart("div");b.class("sapUiMnuItmR");b.openEnd();b.close("div");b.close("li");};
a.prototype.hover=function(h,m){this.$().toggleClass("sapUiMnuItmHov",h);};
a.prototype.focus=function(m){if(this.getEnabled()&&this.getVisible()){this.$().trigger("focus");}else{m.focus();}};
return a;});
sap.ui.predefine('sap/ui/unified/MenuItemBase',['sap/ui/core/Element','./library'],function(E,l){"use strict";
var M=E.extend("sap.ui.unified.MenuItemBase",{metadata:{library:"sap.ui.unified",properties:{enabled:{type:"boolean",group:"Behavior",defaultValue:true},visible:{type:"boolean",group:"Behavior",defaultValue:true},startsSection:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"submenu",aggregations:{submenu:{type:"sap.ui.unified.Menu",multiple:false}},events:{select:{parameters:{item:{type:"sap.ui.unified.MenuItemBase"}}}}}});
M.prototype.init=function(){};
M.prototype.render=function(r,i,m){var a=r;a.openStart("li",i);a.openEnd();a.openStart("div",this.getId()+"-txt");a.style("white-space","nowrap");a.style("display","inline-block");a.style("padding","1px");a.style("color","black");a.openEnd();a.text(i.getId());if(this.getSubmenu()){a.text("&nbsp;&nbsp;->");}a.close("div");a.close("li");};
M.prototype.hover=function(h,m){this.$("txt").attr("style",h?"white-space:nowrap;display:inline-block;padding:1px;color:red;":"white-space:nowrap;display:inline-block;padding:1px;color:black;");};
M.prototype.focus=function(){};
M.prototype.onSubmenuToggle=function(o){this.$().toggleClass("sapUiMnuItmSubMnuOpen",o);};
M.prototype.onAfterRendering=function(){};
M.prototype.onsapshow=function(e){if(this.getParent()&&this.getParent().close){this.getParent().close(true);}e.preventDefault();};
M.prototype.onsaphide=M.prototype.onsapshow;return M;});
sap.ui.predefine('sap/ui/unified/MenuRenderer',[],function(){"use strict";var M={apiVersion:2};
M.render=function(r,m){var a=sap.ui.getCore().getConfiguration().getAccessibility(),R=m.getRootMenu();if(m.oHoveredItem&&m.indexOfItem(m.oHoveredItem)<0){m.oHoveredItem=null;}r.openStart("div",m);r.attr("tabindex",-1);r.attr("hideFocus",true);if(m.getTooltip_AsString()){r.attr("title",m.getTooltip_AsString());}if(a){r.accessibilityState(m,{disabled:null,labelledby:{value:m.getId()+"-label",append:true}});}r.class("sapUiMnu");if(R.bUseTopStyle){r.class("sapUiMnuTop");}if(R.isCozy()){r.class("sapUiSizeCozy");}if(m.bCozySupported){r.class("sapUiMnuCozySupport");}r.openEnd();M.renderItems(r,m);if(a){r.openStart("span",m.getId()+"-label");r.class("sapUiInvisibleText");r.attr("aria-hidden",true);r.openEnd();r.text(m.getAriaDescription()?m.getAriaDescription():"");r.close("span");}r.close("div");};
M.renderItems=function(r,m){var I=m.getItems(),a=sap.ui.getCore().getConfiguration().getAccessibility(),h=false,H=false,n=0,b=0,i,o;r.openStart("ul");r.attr("role","menu");r.class("sapUiMnuLst");for(i=0;i<I.length;i++){if(I[i].getIcon&&I[i].getIcon()){h=true;}if(I[i].getSubmenu()){H=true;}}if(!h){r.class("sapUiMnuNoIco");}if(!H){r.class("sapUiMnuNoSbMnu");}r.openEnd();n=0;for(i=0;i<I.length;i++){if(I[i].getVisible()&&I[i].render){n++;}}for(i=0;i<I.length;i++){o=I[i];if(o.getVisible()&&o.render){b++;if(o.getStartsSection()){r.openStart("li");if(a){r.attr("role","separator");}r.class("sapUiMnuDiv");r.openEnd();r.openStart("div");r.class("sapUiMnuDivL");r.openEnd();r.close("div");r.voidStart("hr").voidEnd();r.openStart("div");r.class("sapUiMnuDivR");r.openEnd();r.close("div");r.close("li");}o.render(r,o,m,{bAccessible:a,iItemNo:b,iTotalItems:n});}}r.close("ul");};
return M;},true);
sap.ui.predefine('sap/ui/unified/calendar/CustomMonthPicker',["sap/ui/core/Renderer","sap/ui/unified/Calendar",'sap/ui/unified/CalendarRenderer',"sap/ui/unified/calendar/Header","sap/ui/unified/DateRange","sap/ui/dom/containsOrEquals"],function(R,C,a,H,D,c){"use strict";var b=R.extend(a);b.apiVersion=2;
var d=C.extend("sap.ui.unified.internal.CustomMonthPicker",{
metadata:{library:"sap.ui.unified"},
renderer:b
});
d.prototype._initializeHeader=function(){var h=new H(this.getId()+"--Head",{visibleButton1:false});h.attachEvent("pressPrevious",this._handlePrevious,this);h.attachEvent("pressNext",this._handleNext,this);h.attachEvent("pressButton2",this._handleButton2,this);this._afterHeaderRenderAdjustCSS=this._createOnAfterRenderingDelegate(h);h.addDelegate(this._afterHeaderRenderAdjustCSS);this.setAggregation("header",h);};
d.prototype.onBeforeRendering=function(){var h=this.getAggregation("header");C.prototype.onBeforeRendering.call(this,arguments);h.setVisibleButton1(false);h.setVisibleButton2(true);};
d.prototype.onAfterRendering=function(){this._showMonthPicker(undefined,true);};
d.prototype._selectYear=function(){var m=this._getMonthPicker(),y=this._getYearPicker(),f=this._getFocusedDate();f.setYear(y.getYear());m._setYear(f.getYear());this._focusDate(f,true);this._showMonthPicker();};
d.prototype._selectMonth=function(){var m=this._getMonthPicker(),s=this.getSelectedDates()[0],f=this._getFocusedDate();if(!s){s=new D();}if(!m.getIntervalSelection()){f.setMonth(m.getMonth());s.setStartDate(f.toLocalJSDate());this.addSelectedDate(s);}this.fireSelect();};
d.prototype.onsapescape=function(e){this.fireCancel();};
return d;});
sap.ui.predefine('sap/ui/unified/calendar/CustomYearPicker',["sap/ui/core/Renderer","sap/ui/unified/Calendar","sap/ui/unified/CalendarRenderer","sap/ui/unified/calendar/Header","sap/ui/unified/DateRange"],function(R,C,a,H,D){"use strict";var b=R.extend(a);b.apiVersion=2;
var c=C.extend("sap.ui.unified.internal.CustomYearPicker",{
metadata:{library:"sap.ui.unified"},
renderer:b
});
c.prototype._initializeHeader=function(){var h=new H(this.getId()+"--Head",{visibleButton1:false});h.attachEvent("pressPrevious",this._handlePrevious,this);h.attachEvent("pressNext",this._handleNext,this);h.attachEvent("pressButton2",this._handleButton2,this);this._afterHeaderRenderAdjustCSS=this._createOnAfterRenderingDelegate(h);h.addDelegate(this._afterHeaderRenderAdjustCSS);this.setAggregation("header",h);};
c.prototype.onBeforeRendering=function(){var h=this.getAggregation("header");C.prototype.onBeforeRendering.call(this,arguments);h.setVisibleButton1(false);h.setVisibleButton2(true);};
c.prototype.onAfterRendering=function(){C.prototype.onAfterRendering.apply(this,arguments);this._showYearPicker();};
c.prototype.onThemeChanged=function(){C.prototype.onThemeChanged.apply(this,arguments);};
c.prototype._selectYear=function(){var d=this.getSelectedDates()[0],y=this._getYearPicker();if(!d){d=new D();}if(!y.getIntervalSelection()){d.setStartDate(this._getYearPicker().getDate());this.addSelectedDate(d);}this.fireSelect();};
c.prototype.onsapescape=function(e){this.fireCancel();};
return c;});
sap.ui.require.preload({
	"sap/m/ColorPalette.js":function(){sap.ui.getCore().loadLibrary("sap.ui.unified");sap.ui.define(['sap/ui/core/Control','sap/ui/Device','sap/ui/base/DataType','sap/ui/core/library','sap/ui/core/delegate/ItemNavigation','./Button','./Dialog','./library','./ColorPaletteRenderer',"sap/ui/dom/containsOrEquals","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery","sap/ui/unified/ColorPickerDisplayMode"],function(C,D,a,c,I,B,b,l,d,e,K,q,f){"use strict";var g=c.CSSColor;var h;var i;var j=l.ButtonType;var k=a.getType("boolean");var m="sapMColorPaletteSquare";var S=5;var M=2;var n=15;var L=sap.ui.getCore().getLibraryResourceBundle("sap.m");
var o=C.extend("sap.m.ColorPalette",{metadata:{library:"sap.m",properties:{colors:{type:"sap.ui.core.CSSColor[]",group:"Appearance",defaultValue:["gold","darkorange","indianred","darkmagenta","cornflowerblue","deepskyblue","darkcyan","olivedrab","darkslategray","azure","white","lightgray","darkgray","dimgray","black"]}},aggregations:{_defaultColorButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_moreColorsButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},events:{colorSelect:{parameters:{"value":{type:"sap.ui.core.CSSColor"},"defaultAction":{type:"boolean"}}}}}});
o.prototype.init=function(){this._oDefaultColor=null;this._bShowDefaultColorButton=false;this._bShowMoreColorsButton=false;this._bShowRecentColorsSection=false;this._oDisplayMode=f.Default;this._oMoreColorsDialog=null;this._oPaletteColorItemNavigation=null;this._oRecentColorItemNavigation=null;this._recentColors=[];};
o.prototype.exit=function(){if(this._oMoreColorsDialog){this._oMoreColorsDialog.destroy();delete this._oMoreColorsDialog;}if(this._oPaletteColorItemNavigation){this.removeDelegate(this._oPaletteColorItemNavigation);this._oPaletteColorItemNavigation.destroy();delete this._oPaletteColorItemNavigation;}if(this._oRecentColorItemNavigation){this.removeDelegate(this._oRecentColorItemNavigation);this._oRecentColorItemNavigation.destroy();delete this._oRecentColorItemNavigation;}};
o.prototype.setColors=function(r){r=this.validateProperty("colors",r);if(r.length<M||r.length>n){throw new Error("Cannot set property 'colors' - array must has minimum 2 and maximum 15 elements");}return this.setProperty("colors",r);};
o.prototype._setDisplayMode=function(r){var s=this._getColorPicker();s.setDisplayMode(r);this._oDisplayMode=r;return this;};
o.prototype._getDisplayMode=function(){return this._oDisplayMode;};
o.prototype._getColorPicker=function(){return this._ensureMoreColorsDialog()._oColorPicker;};
o.prototype.ontap=function(E){var t=q(E.target),s,$;$=t.closest("."+m);if(!$.length){return;}s=$.attr("data-sap-ui-color");this._fireColorSelect(s,false,E);};
o.prototype.onsaptabnext=o.prototype.onsaptabprevious=function(E){var r=this._getElementInfo(E.target);if(r.bIsMoreColorsButton){this.fireEvent("_colorNotSelected",{_originalEvent:E});return;}if(r.bIsDefaultColorButton){this._fireColorSelect(this._getDefaultColor(),true,E);return;}o.prototype.ontap.apply(this,arguments);};o.prototype.onsapenter=o.prototype.ontap;
o.prototype.onsapspace=function(E){E.preventDefault();};
o.prototype.onkeyup=function(E){if(E.which===K.SPACE){E.preventDefault();o.prototype.ontap.apply(this,arguments);}};
o.prototype.onAfterRendering=function(){this._ensureItemNavigation();};
o.prototype.pushToRecentColors=function(s){var r=this._recentColors.indexOf(s);if(r>-1){this._recentColors.splice(r,1);}else if(this._recentColors.length===5){this._recentColors.pop();}this._recentColors.unshift(s);this.invalidate();};
o.prototype.setColorPickerSelectedColor=function(r){if(!g.isValid(r)){throw new Error("Cannot set the selected color - invalid value: "+r);}this._getColorPicker().setColorString(r);return this;};
o.prototype._createDefaultColorButton=function(){return new B(this.getId()+"-btnDefaultColor",{width:"100%",type:j.Transparent,text:L.getText("COLOR_PALETTE_DEFAULT_COLOR"),visible:this._getShowDefaultColorButton(),press:function(E){this._fireColorSelect(this._getDefaultColor(),true,E);}.bind(this)});};
o.prototype._getDefaultColor=function(){return this._oDefaultColor;};
o.prototype._setDefaultColor=function(r){if(!g.isValid(r)){throw new Error("Cannot set internal property '_defaultColor' - invalid value: "+r);}this._oDefaultColor=r;return this;};
o.prototype._getShowDefaultColorButton=function(){return this._bShowDefaultColorButton;};
o.prototype._setShowDefaultColorButton=function(v){if(!k.isValid(v)){throw new Error("Cannot set internal property 'showDefaultColorButton' - invalid value: "+v);}this._bShowDefaultColorButton=v;if(v&&!this._getDefaultColorButton()){this.setAggregation("_defaultColorButton",this._createDefaultColorButton());}if(this._getDefaultColorButton()){this._getDefaultColorButton().setVisible(v);}return this;};
o.prototype._getDefaultColorButton=function(){return this.getAggregation("_defaultColorButton");};
o.prototype._createMoreColorsButton=function(){return new B(this.getId()+"-btnMoreColors",{width:"100%",type:j.Transparent,text:L.getText("COLOR_PALETTE_MORE_COLORS"),visible:this._getShowMoreColorsButton(),press:this._openColorPicker.bind(this)});};
o.prototype._getShowMoreColorsButton=function(){return this._bShowMoreColorsButton;};
o.prototype._getShowRecentColorsSection=function(){return this._bShowRecentColorsSection;};
o.prototype._getRecentColors=function(){return this._recentColors;};
o.prototype._setShowRecentColorsSection=function(v){if(!k.isValid(v)){throw new Error("Cannot set internal property 'showRecentColorsSection' - invalid value: "+v);}this._bShowRecentColorsSection=v;return this;};
o.prototype._setShowMoreColorsButton=function(v){if(!k.isValid(v)){throw new Error("Cannot set internal property 'showMoreColorsButton' - invalid value: "+v);}this._bShowMoreColorsButton=v;if(v&&!this._getMoreColorsButton()){this.setAggregation("_moreColorsButton",this._createMoreColorsButton());}if(this._getMoreColorsButton()){this._getMoreColorsButton().setVisible(v);}return this;};
o.prototype._getMoreColorsButton=function(){return this.getAggregation("_moreColorsButton");};
o.prototype._openColorPicker=function(){this.fireEvent("_beforeOpenColorPicker");this._ensureMoreColorsDialog().open();};
o.prototype._ensureMoreColorsDialog=function(){if(!this._oMoreColorsDialog){this._oMoreColorsDialog=this._createMoreColorsDialog();}return this._oMoreColorsDialog;};
o.prototype._createMoreColorsDialog=function(){var r=new b(this.getId()+"-moreColorsDialog",{stretch:!!D.system.phone,title:L.getText("COLOR_PALETTE_MORE_COLORS_TITLE")}).addStyleClass("CPDialog");this._ensureUnifiedLibrary();r.addContent(r._oColorPicker=new h({mode:i.HSL,displayMode:this._oDisplayMode}));r.setBeginButton(new B({text:L.getText("COLOR_PALETTE_MORE_COLORS_CONFIRM"),press:function(E){r.close();if(r._oColorPicker.getColorString()){this._fireColorSelect(r._oColorPicker.getColorString(),false,E);}}.bind(this)}));r.setEndButton(new B({text:L.getText("COLOR_PALETTE_MORE_COLORS_CANCEL"),press:function(){r.close();}}));return r;};
o.prototype._ensureUnifiedLibrary=function(){var u;if(!h){sap.ui.getCore().loadLibrary("sap.ui.unified");u=sap.ui.require("sap/ui/unified/library");h=sap.ui.requireSync("sap/ui/unified/ColorPicker");i=u.ColorPickerMode;}};
o.prototype._focusFirstElement=function(){var F=this._getShowDefaultColorButton()?this._getDefaultColorButton().getDomRef():this._getAllPaletteColorSwatches()[0];F.focus();};
o.prototype._fireColorSelect=function(r,s,O){this.fireColorSelect({value:r,defaultAction:s,_originalEvent:O});this.pushToRecentColors(r);};
o.prototype._ensureItemNavigation=function(){var P=[],r=[];if(!this._oPaletteColorItemNavigation){this._oPaletteColorItemNavigation=new p(this);this._oPaletteColorItemNavigation.setColumns(S);this._oPaletteColorItemNavigation.setCycling(false);this.addDelegate(this._oPaletteColorItemNavigation);this._oPaletteColorItemNavigation.attachEvent(I.Events.BorderReached,this._onSwatchContainerBorderReached,this);}if(!this._oRecentColorItemNavigation){this._oRecentColorItemNavigation=new p(this);this._oRecentColorItemNavigation.setColumns(S);this._oRecentColorItemNavigation.setCycling(false);this.addDelegate(this._oRecentColorItemNavigation);this._oRecentColorItemNavigation.attachEvent(I.Events.BorderReached,this._onSwatchContainerBorderReached,this);}P=P.concat(this._getAllPaletteColorSwatches());r=r.concat(this._getAllRecentColorSwatches());r=r.slice(0,this._getRecentColors().length);this._oPaletteColorItemNavigation.setRootDomRef(this.getDomRef("swatchCont-paletteColor"));this._oPaletteColorItemNavigation.setItemDomRefs(P);this._oRecentColorItemNavigation.setRootDomRef(this.getDomRef("swatchCont-recentColors"));this._oRecentColorItemNavigation.setItemDomRefs(r);};
o.prototype._onSwatchContainerBorderReached=function(E){var N,s,H=["saphome","sapend"].indexOf(E.getParameter("event").type)>-1,r=this._getAllRecentColorSwatches()[0]?this._getElementInfo(E.mParameters.event.target).bIsRecentColorSwatch:false;if(E.getParameter(p.BorderReachedDirection)===p.BorderReachedDirectionForward){if(this._getShowMoreColorsButton()&&!r){N=this._getMoreColorsButton();}else if(!H&&this._bShowRecentColorsSection&&!r&&this._getRecentColors().length>0){N=this._getAllRecentColorSwatches()[0];}else if(!H&&this._getShowDefaultColorButton()){N=this._getDefaultColorButton();}else if(!H){N=this._getAllPaletteColorSwatches()[0];}}else{if(this._getShowDefaultColorButton()&&!r){N=this._getDefaultColorButton();}else if(!H&&this._bShowRecentColorsSection&&!r&&this._getRecentColors().length>0){N=this._getAllRecentColorSwatches()[0];}else if(!H&&this._getShowMoreColorsButton()){N=this._getMoreColorsButton();}else if(!H&&!this._getShowDefaultColorButton()){s=this._getAllPaletteColorSwatches();N=s[s.length-1];}else if(!H){s=this._getAllPaletteColorSwatches();N=s[this._oPaletteColorItemNavigation._getIndexOfTheFirstItemInLastRow()];}}if(N){N.focus();}return N;};
o.prototype.onsapnext=function(E){var N,r=this._getElementInfo(E.target);if(!(r.bIsDefaultColorButton||r.bIsMoreColorsButton)){return;}E.preventDefault();E.stopImmediatePropagation(true);if(r.bIsDefaultColorButton){N=this._getAllPaletteColorSwatches()[0];}else if(this._getRecentColors().length>0&&!r.bIsRecentColorSwatch&&this._bShowRecentColorsSection){N=this._getAllRecentColorSwatches()[0];}else{N=this._getShowDefaultColorButton()?this._getDefaultColorButton():this._getAllPaletteColorSwatches()[0];}N.focus();};
o.prototype.onsapprevious=function(E){var N,F=this._getElementInfo(E.target),A;if(!(F.bIsDefaultColorButton||F.bIsMoreColorsButton||E.target===this._getAllRecentColorSwatches()[0])){return;}E.preventDefault();E.stopImmediatePropagation(true);A=this._getAllPaletteColorSwatches();if(F.bIsMoreColorsButton||(!F.bIsMoreColorsButton&&this.bIsRecentColorSwatch)){N=E.keyCode===K.ARROW_UP?A[this._oPaletteColorItemNavigation._getIndexOfTheFirstItemInLastRow()]:A[A.length-1];}else if(F.bIsRecentColorSwatch&&!this._bShowMoreColorsButton&&!this._bShowDefaultColorButton){A=this._getAllPaletteColorSwatches();N=A[this._oPaletteColorItemNavigation._getIndexOfTheFirstItemInLastRow()];}else if(this._getRecentColors().length>0&&!F.bIsRecentColorSwatch&&this._bShowRecentColorsSection){N=this._getAllRecentColorSwatches()[0];}else if(this._getShowMoreColorsButton()){N=this._getMoreColorsButton();}else{N=A[this._oPaletteColorItemNavigation._getIndexOfTheFirstItemInLastRow()];}N.focus();};
o.prototype.onsaphome=function(E){var r=this._getElementInfo(E.target);if(!r.bIsMoreColorsButton){return;}if(this._getShowDefaultColorButton()){this._getDefaultColorButton().focus();}E.preventDefault();E.stopImmediatePropagation(true);};
o.prototype.onsapend=function(E){var r=this._getElementInfo(E.target);if(!r.bIsDefaultColorButton){return;}if(this._getShowMoreColorsButton()){this._getMoreColorsButton().focus();}E.preventDefault();E.stopImmediatePropagation(true);};
o.prototype._getAllPaletteColorSwatches=function(){return this.$().find("."+m).get().slice(0,this.getColors().length);};
o.prototype._getAllRecentColorSwatches=function(){return this.$().find("."+m).get().slice(this.getColors().length);};
o.prototype._getElementInfo=function(E){var r=this._getShowDefaultColorButton()&&e(E,this._getDefaultColorButton().getDomRef()),s=!r&&this._getShowMoreColorsButton()&&e(E,this._getMoreColorsButton().getDomRef()),t=this._getAllRecentColorSwatches().indexOf(E)>-1,u=this._getAllPaletteColorSwatches().indexOf(E)>-1;return{bIsDefaultColorButton:r,bIsMoreColorsButton:s,bIsASwatch:u,bIsRecentColorSwatch:t};};
var p=I.extend("sap.m.ItemNavigationHomeEnd",{constructor:function(){I.apply(this,arguments);this.setHomeEndColumnMode(true);this.fireEvent=function(N,E){var s;if(N===I.Events.BorderReached){s=p.BorderReachedDirectionBackward;if(["sapnext","sapend"].indexOf(E.event.type)>-1){s=p.BorderReachedDirectionForward;}E[p.BorderReachedDirection]=s;}I.prototype.fireEvent.apply(this,arguments);};}});
p.BorderReachedDirection="direction";p.BorderReachedDirectionForward="BorderReachedDirectionForward";p.BorderReachedDirectionBackward="BorderReachedDirectionBackward";
p.prototype.getColumns=function(){return this.iColumns;};
p.prototype.onsapprevious=function(E){var r=e(this.getRootDomRef(),E.target),A=E.keyCode===K.ARROW_UP&&this.getFocusedIndex()===0;if(!r){return;}if(!A){I.prototype.onsapprevious.apply(this,arguments);return;}E.preventDefault();this.fireEvent(I.Events.BorderReached,{index:0,event:E});};
p.prototype.onsapnext=function(E){var r=e(this.getRootDomRef(),E.target),s,t,u;if(!r){return;}if(E.keyCode!==K.ARROW_DOWN){I.prototype.onsapnext.apply(this,arguments);return;}t=this.getFocusedIndex();u=this._getItemInfo(t);if(u.bIsLastItem&&u.bIsInTheLastColumn){E.preventDefault();this.fireEvent(I.Events.BorderReached,{index:t,event:E});return;}if(u.bNextRowExists&&!u.bItemSameColumnNextRowExists){E.preventDefault();s=this.getItemDomRefs();s[s.length-1].focus();return;}I.prototype.onsapnext.apply(this,arguments);};
p.prototype.onsaphome=function(E){var r=e(this.getRootDomRef(),E.target),s;if(!r){return;}s=this._getItemInfo(this.getFocusedIndex());if(!s.bIsInTheFirstColumn){I.prototype.onsaphome.apply(this,arguments);return;}E.preventDefault();if(s.bIsFirstItem){this.fireEvent(I.Events.BorderReached,{index:0,event:E});}else{this.getItemDomRefs()[0].focus();}};
p.prototype.onsapend=function(E){var r=e(this.getRootDomRef(),E.target),s;if(!r){return;}s=this._getItemInfo(this.getFocusedIndex());if(!(s.bIsLastItem||s.bIsInTheLastColumn)){I.prototype.onsapend.apply(this,arguments);return;}E.preventDefault();if(s.bIsLastItem){this.fireEvent(I.Events.BorderReached,{index:this.getItemDomRefs().length-1,event:E});}else{this.getItemDomRefs()[this.getItemDomRefs().length-1].focus();}};
p.prototype._getItemInfo=function(r){var s=this.getItemDomRefs().length,t=r===(s-1),u=s>this.getColumns()?this.getColumns():s,v=r%this.getColumns()===0,w=(r+1)%u===0,x=Math.floor(r/this.getColumns())+1,N,y;N=x*this.getColumns()<s;y=N&&(r+this.getColumns())<s;return{bIsFirstItem:r===0,bIsLastItem:t,bIsInTheLastColumn:w,bIsInTheFirstColumn:v,bNextRowExists:N,bItemSameColumnNextRowExists:y};};
p.prototype._getIndexOfTheFirstItemInLastRow=function(){return Math.floor((this.getItemDomRefs().length-1)/this.getColumns())*this.getColumns();};
o.prototype._ItemNavigation=p;o.prototype._ColorsHelper={RGB_TO_NAMED_COLORS_MAP:{"#FFB200":"gold","#FF8C00":"darkorange","#CD5C5C":"indianred","#8B008B":"darkmagenta","#6495ED":"cornflowerblue","#00BFFF":"deepskyblue","#008B8B":"darkcyan","#6B8E23":"olivedrab","#2F4F4F":"darkslategray","#F0FFFF":"azure","#FFFFFF":"white","#D3D3D3":"lightgray","#A9A9A9":"darkgray","#696969":"dimgray","#000000":"black"},NAME_COLORS_TO_RGB_MAP:{"gold":"#FFB200","darkorange":"#FF8C00","indianred":"#CD5C5C","darkmagenta":"#8B008B","cornflowerblue":"#6495ED","deepskyblue":"#00BFFF","darkcyan":"#008B8B","olivedrab":"#6B8E23","darkslategray":"#2F4F4F","azure":"#F0FFFF","white":"#FFFFFF","lightgray":"#D3D3D3","darkgray":"#A9A9A9","dimgray":"#696969","black":"#000000"},getNamedColor:function(s){var H="";if(!s||s.toLowerCase().indexOf("hsl")!==-1){return undefined;}if(s.indexOf("#")===-1){return this.NAME_COLORS_TO_RGB_MAP[s.toLowerCase()]?s.toLowerCase():undefined;}if(s.length===4){H=["#",s[1],s[1],s[2],s[2],s[3],s[3]].join("");}else{H=s;}H=H.toUpperCase();return this.RGB_TO_NAMED_COLORS_MAP[H];}};return o;});
},
	"sap/m/ColorPalettePopover.js":function(){sap.ui.getCore().loadLibrary("sap.ui.unified");sap.ui.define(['sap/ui/core/Control','sap/ui/Device','sap/ui/unified/ColorPickerDisplayMode','./Button','./ResponsivePopover','./ColorPalette','./library'],function(C,D,a,B,R,b,l){"use strict";var P=l.PlacementType;
var c=C.extend("sap.m.ColorPalettePopover",{
metadata:{library:"sap.m",publicMethods:["openBy","close"],properties:{defaultColor:{type:"sap.ui.core.CSSColor",group:"Appearance",defaultValue:null},colors:{type:"sap.ui.core.CSSColor[]",group:"Appearance",defaultValue:["gold","darkorange","indianred","darkmagenta","cornflowerblue","deepskyblue","darkcyan","olivedrab","darkslategray","azure","white","lightgray","darkgray","dimgray","black"]},showDefaultColorButton:{type:"boolean",group:"Appearance",defaultValue:true},showMoreColorsButton:{type:"boolean",group:"Appearance",defaultValue:true},showRecentColorsSection:{type:"boolean",group:"Appearance",defaultValue:true},displayMode:{type:"sap.ui.unified.ColorPickerDisplayMode",group:"Appearance",defaultValue:a.Default}},events:{colorSelect:{parameters:{"value":{type:"sap.ui.core.CSSColor"},"defaultAction":{type:"boolean"}}}}},
renderer:{apiVersion:2}
});
var L=sap.ui.getCore().getLibraryResourceBundle("sap.m");var F={COLOR_PALETTE_PROPS:{colors:"setColors",defaultColor:"_setDefaultColor",showDefaultColorButton:"_setShowDefaultColorButton",showMoreColorsButton:"_setShowMoreColorsButton",showRecentColorsSection:"_setShowRecentColorsSection",displayMode:"_setDisplayMode"},POPOVER_METHODS:{getDomRef:"",close:"",openBy:""}};
c.prototype.init=function(){this._oPopover=null;this._bPopoverDestroying=null;};
c.prototype.exit=function(){this._bPopoverDestroying=true;if(this._oPopover){this._oPopover.removeDelegate(this._oPopover._onAfterRenderingDelegate);this._oPopover.destroy();this._oPopover=null;}};
c.prototype.setColorPickerSelectedColor=function(d){this._getPalette().setColorPickerSelectedColor(d);return this;};
c.prototype._getPalette=function(){return this._ensurePopover().getContent()[0];};
c.prototype._ensurePopover=function(){if(!this._oPopover){this._oPopover=this._createPopover();}return this._oPopover;};
c.prototype._createPopover=function(){var p,o=this._createColorPalette(),d;p=new R(this.getId()+"-colorPalettePopover",{showHeader:D.system.phone,placement:P.VerticalPreferredBottom,showArrow:false,showCloseButton:false,title:L.getText("COLOR_PALETTE_TITLE"),content:o,afterOpen:o._focusFirstElement.bind(o)}).addStyleClass("sapMColorPaletteContainer");if(D.system.phone){p.setEndButton(new B({text:L.getText("COLOR_PALETTE_CANCEL"),press:function(){p.close();}}));}o.attachEvent("_beforeOpenColorPicker",function(){p.close();});o.attachEvent("_colorNotSelected",function(e){this._handleNextOrPreviousUponPaletteClose(e);p.close();}.bind(this));o.attachEvent("colorSelect",function(e){this._handleNextOrPreviousUponPaletteClose(e);p.close();this.fireColorSelect({"value":e.getParameter("value"),"defaultAction":e.getParameter("defaultAction")});}.bind(this));d={onAfterRendering:function(){var $=this.$();$.attr("aria-modal","true");$.attr("aria-label",this.getTitle());}};p.addEventDelegate(d,p);p._onAfterRenderingDelegate=d;return p;};
c.prototype._createColorPalette=function(){var o=new b(this.getId()+"-palette");o._setShowDefaultColorButton(this.getShowDefaultColorButton());o._setShowMoreColorsButton(this.getShowMoreColorsButton());o._setShowRecentColorsSection(this.getShowRecentColorsSection());return o;};
c.prototype._handleNextOrPreviousUponPaletteClose=function(e){var o=e.getParameter("_originalEvent");if(!o){return;}if(o.type==="saptabnext"||o.type==="saptabprevious"){o.stopPropagation();o.preventDefault();}};
c.prototype.setProperty=function(p,v,s){var t;if(F.COLOR_PALETTE_PROPS[p]!==undefined){t=F.COLOR_PALETTE_PROPS[p]||p;b.prototype[t].call(this._getPalette(),v);}return C.prototype.setProperty.apply(this,arguments);};
Object.keys(F.POPOVER_METHODS).forEach(function(s){var t=F.COLOR_PALETTE_PROPS[s]||s;c.prototype[s]=function(){if(this._bPopoverDestroying){return null;}var p=this._ensurePopover();return p[t].apply(p,arguments);};});return c;});
},
	"sap/m/DatePicker.js":function(){sap.ui.getCore().loadLibrary("sap.ui.unified");sap.ui.define(['sap/ui/thirdparty/jquery','sap/ui/Device','./InputBase','./DateTimeField','./Button','./ResponsivePopover','sap/ui/core/date/UniversalDate','./library','sap/ui/core/Control','sap/ui/core/library',"./DatePickerRenderer","sap/base/util/deepEqual","sap/base/assert","sap/base/Log","sap/ui/core/IconPool","./InstanceManager","sap/ui/unified/Calendar","sap/ui/unified/DateRange",'sap/ui/unified/DateTypeRange',"sap/ui/unified/calendar/CustomMonthPicker","sap/ui/unified/calendar/CustomYearPicker","sap/ui/unified/library","sap/ui/dom/jquery/cursorPos"],function(q,D,I,a,B,R,U,l,C,c,b,d,e,L,f,g,h,j,k,m,n,u){"use strict";var o=c.CalendarType;var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");
var p=a.extend("sap.m.DatePicker",{metadata:{library:"sap.m",properties:{displayFormatType:{type:"string",group:"Appearance",defaultValue:""},secondaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance",defaultValue:null},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null},showFooter:{type:"boolean",group:"Misc",defaultValue:false}},aggregations:{specialDates:{type:"sap.ui.core.Element",multiple:true,singularName:"specialDate"},_popup:{type:"sap.m.ResponsivePopover",multiple:false,visibility:"hidden"}},associations:{legend:{type:"sap.ui.core.Control",multiple:false}},events:{navigate:{parameters:{dateRange:{type:"sap.ui.unified.DateRange"},afterPopupOpened:{type:"boolean"}}}},designtime:"sap/m/designtime/DatePicker.designtime",dnd:{draggable:false,droppable:true}}});
p.prototype.init=function(){a.prototype.init.apply(this,arguments);this._bIntervalSelection=false;this._bOnlyCalendar=true;this._bValid=true;this._oMinDate=new Date(1,0,1);this._oMinDate.setFullYear(1);this._oMaxDate=new Date(9999,11,31,23,59,59,999);var i=this.addEndIcon({id:this.getId()+"-icon",src:this.getIconSrc(),noTabStop:true,tooltip:r.getText("OPEN_PICKER_TEXT")});this._bShouldClosePicker=false;i.addEventDelegate({onmousedown:function(E){this._bShouldClosePicker=!!this.isOpen();}},this);i.attachPress(function(){this.toggleOpen(this._bShouldClosePicker);},this);};
p.prototype.isValidValue=function(){return this._bValid;};
p.prototype.isOpen=function(){return this._oPopup&&this._oPopup.isOpen();};
p.prototype.toggleOpen=function(O){if(this.getEditable()&&this.getEnabled()){if(O){s.call(this);}else{_.call(this);}}};
p.prototype.getIconSrc=function(){return f.getIconURI("appointment-2");};
p.prototype.exit=function(){I.prototype.exit.apply(this,arguments);if(this._oPopup){if(this._oPopup.isOpen()){this._oPopup.close();}delete this._oPopup;}if(this._getCalendar()){this._getCalendar().destroy();delete this._getCalendar();}if(this._iInvalidateCalendar){clearTimeout(this._iInvalidateCalendar);}this._sUsedDisplayPattern=undefined;this._sUsedDisplayCalendarType=undefined;this._oDisplayFormat=undefined;this._sUsedValuePattern=undefined;this._sUsedValueCalendarType=undefined;this._oValueFormat=undefined;};
p.prototype.invalidate=function(O){if(!O||O!=this._getCalendar()){C.prototype.invalidate.apply(this,arguments);this._iInvalidateCalendar=setTimeout(y.bind(this),0);}};
p.prototype.onBeforeRendering=function(){a.prototype.onBeforeRendering.apply(this,arguments);this._checkMinMaxDate();var V=this._getValueHelpIcon();if(V){V.setProperty("visible",this.getEditable(),true);}};
p.prototype.setWidth=function(W){return I.prototype.setWidth.call(this,W||"100%");};
p.prototype.getWidth=function(W){return this.getProperty("width")||"100%";};
p.prototype.applyFocusInfo=function(F){this._bFocusNoPopup=true;if(!D.support.touch||D.system.desktop){I.prototype.applyFocusInfo.apply(this,arguments);}};
p.prototype.onfocusin=function(E){if(!q(E.target).hasClass("sapUiIcon")){I.prototype.onfocusin.apply(this,arguments);}this._bFocusNoPopup=undefined;};
p.prototype.onsapshow=function(E){this.toggleOpen(this.isOpen());E.preventDefault();};
p.prototype.onsaphide=p.prototype.onsapshow;
p.prototype.onsappageup=function(E){var i=this._getCalendarConstructor().getMetadata().getName();E.preventDefault();if(i!="sap.ui.unified.Calendar"){return;}this._increaseDate(1,"day");};
p.prototype.onsappageupmodifiers=function(E){var i=this._getCalendarConstructor().getMetadata().getName();E.preventDefault();if(!E.ctrlKey&&E.shiftKey){if(i=="sap.ui.unified.internal.CustomYearPicker"){return;}this._increaseDate(1,"month");}else{this._increaseDate(1,"year");}};
p.prototype.onsappagedown=function(E){var i=this._getCalendarConstructor().getMetadata().getName();E.preventDefault();if(i!="sap.ui.unified.Calendar"){return;}this._increaseDate(-1,"day");};
p.prototype.onsappagedownmodifiers=function(E){var i=this._getCalendarConstructor().getMetadata().getName();E.preventDefault();if(!E.ctrlKey&&E.shiftKey){if(i=="sap.ui.unified.internal.CustomYearPicker"){return;}this._increaseDate(-1,"month");}else{this._increaseDate(-1,"year");}};
p.prototype.onkeypress=function(E){if(!E.charCode||E.metaKey||E.ctrlKey){return;}var F=this._getFormatter(true);var i=String.fromCharCode(E.charCode);if(i&&F.sAllowedCharacters&&F.sAllowedCharacters.indexOf(i)<0){E.preventDefault();}};
p.prototype._getValueHelpIcon=function(){var V=this.getAggregation("_endIcon");return V&&V[0];};
p.prototype._dateValidation=function(i){this._bValid=true;if(i&&(i.getTime()<this._oMinDate.getTime()||i.getTime()>this._oMaxDate.getTime())){this._bValid=false;e(this._bValid,"Date must be in valid range");}this.setProperty("dateValue",i);return i;};
p.prototype.setMinDate=function(i){if(!this._isValidDate(i)){throw new Error("Date must be a JavaScript date object; "+this);}if(d(this.getMinDate(),i)){return this;}if(i){var Y=i.getFullYear();if(Y<1||Y>9999){throw new Error("Date must be between 0001-01-01 and 9999-12-31; "+this);}this._oMinDate=new Date(i.getTime());var z=this.getDateValue();if(z&&z.getTime()<i.getTime()){this._bValid=false;L.warning("DateValue not in valid date range",this);}}else{this._oMinDate=new Date(1,0,1);this._oMinDate.setFullYear(1);}this.setProperty("minDate",i);if(this._getCalendar()){this._getCalendar().setMinDate(i);}this._oMinDate.setHours(0,0,0,0);return this;};
p.prototype.setMaxDate=function(i){if(!this._isValidDate(i)){throw new Error("Date must be a JavaScript date object; "+this);}if(d(this.getMaxDate(),i)){return this;}if(i){var Y=i.getFullYear();if(Y<1||Y>9999){throw new Error("Date must be between 0001-01-01 and 9999-12-31; "+this);}this._oMaxDate=new Date(i.getTime());var z=this.getDateValue();if(z&&z.getTime()>i.getTime()){this._bValid=false;L.warning("DateValue not in valid date",this);}}else{this._oMaxDate=new Date(9999,11,31,23,59,59,999);}this.setProperty("maxDate",i);if(this._getCalendar()){this._getCalendar().setMaxDate(i);}this._oMaxDate.setHours(23,59,59,999);return this;};
p.prototype._checkMinMaxDate=function(){if(this._oMinDate.getTime()>this._oMaxDate.getTime()){L.warning("minDate > MaxDate -> dates switched",this);var M=new Date(this._oMinDate.getTime());var i=new Date(this._oMaxDate.getTime());this._oMinDate=new Date(i.getTime());this._oMaxDate=new Date(M.getTime());this.setProperty("minDate",i,true);this.setProperty("maxDate",M,true);if(this._getCalendar()){this._getCalendar().setMinDate(i);this._getCalendar().setMaxDate(M);}}var z=this.getDateValue();if(z&&(z.getTime()<this._oMinDate.getTime()||z.getTime()>this._oMaxDate.getTime())){this._bValid=false;L.error("dateValue "+z.toString()+"(value="+this.getValue()+") does not match "+"min/max date range("+this._oMinDate.toString()+" - "+this._oMaxDate.toString()+"). App. "+"developers should take care to maintain dateValue/value accordingly.",this);}};
p.prototype.getDisplayFormatType=function(){return this.getProperty("displayFormatType");};
p.prototype._handleDateValidation=function(i){this._bValid=true;if(!i||i.getTime()<this._oMinDate.getTime()||i.getTime()>this._oMaxDate.getTime()){this._bValid=false;L.warning("Value can not be converted to a valid date",this);}var V=this._formatValue(i,true);if(V!==this.getValue()){this.setLastValue(V);}this.setProperty("value",V);this.setProperty("dateValue",i);};
p.prototype.setDisplayFormatType=function(i){if(i){var F=false;for(var T in o){if(T==i){F=true;break;}}if(!F){throw new Error(i+" is not a valid calendar type"+this);}}this.setProperty("displayFormatType",i,true);this.setDisplayFormat(this.getDisplayFormat());return this;};
p.prototype.setSecondaryCalendarType=function(i){this._bSecondaryCalendarTypeSet=true;this.setProperty("secondaryCalendarType",i,true);if(this._getCalendar()){this._getCalendar().setSecondaryCalendarType(i);}return this;};
p.prototype.setShowFooter=function(F){var P=this._oPopup,i=this._getCalendar();this.setProperty("showFooter",F);if(!P||!i){return this;}P._getButtonFooter().setVisible(F);return this;};
p.prototype.addSpecialDate=function(S){x.call(this,S);this.addAggregation("specialDates",S,true);y.call(this);return this;};
p.prototype.insertSpecialDate=function(S,i){x.call(this,S);this.insertAggregation("specialDates",S,i,true);y.call(this);return this;};
p.prototype.removeSpecialDate=function(S){var i=this.removeAggregation("specialDates",S,true);y.call(this);return i;};
p.prototype.removeAllSpecialDates=function(){var i=this.removeAllAggregation("specialDates",true);y.call(this);return i;};
p.prototype.destroySpecialDates=function(){this.destroyAggregation("specialDates",true);y.call(this);return this;};
p.prototype.setLegend=function(i){this.setAssociation("legend",i,true);var z=this.getLegend();if(z){var A=sap.ui.require("sap/ui/unified/CalendarLegend");i=sap.ui.getCore().byId(z);if(i&&!(typeof A=="function"&&i instanceof A)){throw new Error(i+" is not an sap.ui.unified.CalendarLegend. "+this);}}if(this._getCalendar()){this._getCalendar().setLegend(z);}return this;};
p.prototype.onChange=function(E){if(!this.getEditable()||!this.getEnabled()){return;}var V=this._$input.val(),O=this._formatValue(this.getDateValue()),i;if(V==O&&this._bValid){return;}if(this.getShowFooter()&&this._oPopup&&!V){this._oPopup.getBeginButton().setEnabled(false);}this._bValid=true;if(V!=""){i=this._parseValue(V,true);if(!i||i.getTime()<this._oMinDate.getTime()||i.getTime()>this._oMaxDate.getTime()){this._bValid=false;i=undefined;}else{V=this._formatValue(i);}}if(this.getDomRef()&&(this._$input.val()!==V)){this._$input.val(V);this._curpos=this._$input.cursorPos();}if(i){V=this._formatValue(i,true);}if(this.getLastValue()!==V||(i&&this.getDateValue()&&i.getFullYear()!==this.getDateValue().getFullYear())){this.setLastValue(V);this.setProperty("value",V,true);var N=this.getValue();if(this._bValid&&V==N){this.setProperty("dateValue",i,true);}V=N;if(this.isOpen()){if(this._bValid){i=this.getDateValue();}this._getCalendar().focusDate(i);var S=this._oDateRange.getStartDate();if((!S&&i)||(S&&i&&S.getTime()!=i.getTime())){this._oDateRange.setStartDate(new Date(i.getTime()));}else if(S&&!i){this._oDateRange.setStartDate(undefined);}}this.fireChangeEvent(V,{valid:this._bValid});}};
p.prototype._getInputValue=function(V){V=(typeof V=="undefined")?this._$input.val():V.toString();var i=this._parseValue(V,true);V=this._formatValue(i,true);return V;};
p.prototype.updateDomValue=function(V){if(this.isActive()&&(this._$input.val()!==V)){this._bCheckDomValue=true;V=(typeof V=="undefined")?this._$input.val():V.toString();this._curpos=this._$input.cursorPos();var i=this._parseValue(V,true);V=this._formatValue(i);this._$input.val(V);if(document.activeElement===this._$input[0]){this._$input.cursorPos(this._curpos);}}return this;};
p.prototype._storeInputSelection=function(i){if((D.browser.msie||D.browser.edge)&&!D.support.touch){this._oInputSelBeforePopupOpen={iStart:i.selectionStart,iEnd:i.selectionEnd};i.selectionStart=0;i.selectionEnd=0;}};
p.prototype._restoreInputSelection=function(i){if((D.browser.msie||D.browser.edge)&&!D.support.touch){i.selectionStart=this._oInputSelBeforePopupOpen.iStart;i.selectionEnd=this._oInputSelBeforePopupOpen.iEnd;}};
function _(){this._createPopup();this._createPopupContent();var i;var z=this.getBinding("value");if(z&&z.oType&&z.oType.oOutputFormat){i=z.oType.oOutputFormat.oFormatOptions.calendarType;}else if(z&&z.oType&&z.oType.oFormat){i=z.oType.oFormat.oFormatOptions.calendarType;}if(!i){i=this.getDisplayFormatType();}if(i){this._getCalendar().setPrimaryCalendarType(i);}var V=this._bValid?this._formatValue(this.getDateValue()):this.getValue();if(V!=this._$input.val()){this.onChange();}this._fillDateRange();this._openPopup();this.fireNavigate({dateRange:this._getVisibleDatesRange(this._getCalendar()),afterPopupOpened:true});}
p.prototype._createPopup=function(){var i,z;if(!this._oPopup){this._oPopup=new R(this.getId()+"-RP",{showCloseButton:false,showArrow:false,showHeader:false,placement:l.PlacementType.VerticalPreferedBottom,beginButton:new B({type:l.ButtonType.Emphasized,text:r.getText("DATEPICKER_SELECTION_CONFIRM"),press:this._handleOKButton.bind(this)}),afterOpen:t.bind(this),afterClose:v.bind(this)}).addStyleClass("sapMRPCalendar");if(this.getShowFooter()){this._oPopup.addStyleClass("sapMLandscapePadding");}this._oPopup._getPopup().setAutoClose(true);if(D.system.phone){i=this.$("inner").attr("aria-labelledby");z=i?document.getElementById(i).getAttribute("aria-label"):"";this._oPopup.setTitle(z);this._oPopup.setShowHeader(true);this._oPopup.setShowCloseButton(true);}else{this._oPopup._getPopup().setDurations(0,0);this._oPopup.setEndButton(new B({text:r.getText("DATEPICKER_SELECTION_CANCEL"),press:this._handleCancelButton.bind(this)}));}this.setAggregation("_popup",this._oPopup,true);}};
p.prototype._openPopup=function(){if(!this._oPopup){return;}this._storeInputSelection(this._$input.get(0));this._oPopup._getPopup().setAutoCloseAreas([this.getDomRef()]);this._oPopup.openBy(this);};
p.prototype._getVisibleDatesRange=function(i){var V=i._getVisibleDays();return new j({startDate:V[0].toLocalJSDate(),endDate:V[V.length-1].toLocalJSDate()});};
p.prototype._createPopupContent=function(){var i=this._getCalendarConstructor();if(!this._getCalendar()){this._oCalendar=new i(this.getId()+"-cal",{intervalSelection:this._bIntervalSelection,minDate:this.getMinDate(),maxDate:this.getMaxDate(),legend:this.getLegend(),startDateChange:function(){this.fireNavigate({dateRange:this._getVisibleDatesRange(this._getCalendar())});}.bind(this)});this._oDateRange=new j();this._getCalendar().addSelectedDate(this._oDateRange);this._getCalendar()._setSpecialDatesControlOrigin(this);this._getCalendar().attachCancel(s,this);this._getCalendar().setPopupMode(true);if(this.$().closest(".sapUiSizeCompact").length>0){this._getCalendar().addStyleClass("sapUiSizeCompact");}if(this._bSecondaryCalendarTypeSet){this._getCalendar().setSecondaryCalendarType(this.getSecondaryCalendarType());}if(this._bOnlyCalendar){this._getCalendar().attachSelect(this._handleCalendarSelect,this);this._getCalendar().attachEvent("_renderMonth",w,this);this._oPopup._getButtonFooter().setVisible(this.getShowFooter());this._getCalendar()._bSkipCancelButtonRendering=true;this._oPopup.addContent(this._getCalendar());if(!this.getDateValue()){this._oPopup.getBeginButton().setEnabled(false);}}}};
p.prototype._getCalendarConstructor=function(){var P=this._getFormatter(true).aFormatArray.map(function(z){return z.type.toLowerCase();}),i=P.indexOf("day")>=0,M=P.indexOf("month")>=0,Y=P.indexOf("year")>=0;if(i&&M&&Y){return h;}else if(M&&Y){return m;}else if(Y){return n;}else{L.warning("Not valid date pattern! Default Calendar constructor function is returned",this);return h;}};
p.prototype._fillDateRange=function(){var i=this.getDateValue();if(i&&i.getTime()>=this._oMinDate.getTime()&&i.getTime()<=this._oMaxDate.getTime()){this._getCalendar().focusDate(new Date(i.getTime()));if(!this._oDateRange.getStartDate()||this._oDateRange.getStartDate().getTime()!=i.getTime()){this._oDateRange.setStartDate(new Date(i.getTime()));}}else{var z=this.getInitialFocusedDateValue();var F=z?z:new Date();var M=this._oMaxDate.getTime();if(F.getTime()<this._oMinDate.getTime()||F.getTime()>M){F=this._oMinDate;}this._getCalendar().focusDate(F);if(this._oDateRange.getStartDate()){this._oDateRange.setStartDate(undefined);}}};
p.prototype.getAccessibilityInfo=function(){var i=this.getRenderer();var z=I.prototype.getAccessibilityInfo.apply(this,arguments);var V=this.getValue()||"";if(this._bValid){var A=this.getDateValue();if(A){V=this._formatValue(A);}}z.type=r.getText("ACC_CTR_TYPE_DATEINPUT");z.description=[V,i.getLabelledByAnnouncement(this),i.getDescribedByAnnouncement(this)].join(" ").trim();return z;};
p.prototype._selectDate=function(){var i=this.getDateValue(),z=this._getSelectedDate(),V="";if(!d(z,i)){this.setDateValue(new Date(z.getTime()));V=this.getValue();this.fireChangeEvent(V,{valid:true});this._focusInput();}else if(!this._bValid){V=this._formatValue(z);if(V!=this._$input.val()){this._bValid=true;if(this.getDomRef()){this._$input.val(V);this.setLastValue(V);}V=this._formatValue(z,true);this.setProperty("value",V,true);this.fireChangeEvent(V,{valid:true});this._focusInput();}}else if(D.system.desktop||!D.support.touch){this.focus();}this._oPopup.close();};
p.prototype._handleCalendarSelect=function(){if(this.getShowFooter()){this._oPopup.getBeginButton().setEnabled(true);return;}this._selectDate();};
p.prototype._focusInput=function(){if(this.getDomRef()&&(D.system.desktop||!D.support.touch)){this._curpos=this._$input.val().length;this._$input.cursorPos(this._curpos);}return this;};
p.prototype._getCalendar=function(){return this._oCalendar;};
p.prototype._getSelectedDate=function(){var S=this._getCalendar().getSelectedDates(),i;if(S.length>0){i=S[0].getStartDate();}return i;};
p.prototype._handleOKButton=function(){this._selectDate();};
p.prototype._handleCancelButton=function(){if(!this.getDateValue()){this._oPopup.getBeginButton().setEnabled(false);}this._oPopup.close();};
function s(E){if(this.isOpen()){this._oPopup.close();if((D.system.desktop||!D.support.touch)){this.focus();}}}
p.prototype._increaseDate=function(N,i){var O=this.getDateValue();var z=this._$input.cursorPos();if(O&&this.getEditable()&&this.getEnabled()){var A;var E=this.getBinding("value");if(E&&E.oType&&E.oType.oOutputFormat){A=E.oType.oOutputFormat.oFormatOptions.calendarType;}else if(E&&E.oType&&E.oType.oFormat){A=E.oType.oFormat.oFormatOptions.calendarType;}if(!A){A=this.getDisplayFormatType();}var F=U.getInstance(new Date(O.getTime()),A);O=U.getInstance(new Date(O.getTime()),A);switch(i){case"day":F.setDate(F.getDate()+N);break;case"month":F.setMonth(F.getMonth()+N);var M=(O.getMonth()+N)%12;if(M<0){M=12+M;}while(F.getMonth()!=M){F.setDate(F.getDate()-1);}break;case"year":F.setFullYear(F.getFullYear()+N);while(F.getMonth()!=O.getMonth()){F.setDate(F.getDate()-1);}break;default:break;}if(F.getTime()<this._oMinDate.getTime()){F=new U(this._oMinDate.getTime());}else if(F.getTime()>this._oMaxDate.getTime()){F=new U(this._oMaxDate.getTime());}if(!d(this.getDateValue(),F.getJSDate())){this.setDateValue(new Date(F.getTime()));this._curpos=z;this._$input.cursorPos(this._curpos);var V=this.getValue();this.fireChangeEvent(V,{valid:true});}}};
p.prototype._getSpecialDates=function(){var z=this.getSpecialDates();for(var i=0;i<z.length;i++){var N=z[i].getSecondaryType()===u.CalendarDayType.NonWorking&&z[i].getType()!==u.CalendarDayType.NonWorking;if(N){var A=new k();A.setType(z[i].getSecondaryType());A.setStartDate(z[i].getStartDate());if(z[i].getEndDate()){A.setEndDate(z[i].getEndDate());}z.push(A);}}return z;};
function t(){this.addStyleClass(I.ICON_PRESSED_CSS_CLASS);this._renderedDays=this._getCalendar().$("-Month0-days").find(".sapUiCalItem").length;this.$("inner").attr("aria-owns",this.getId()+"-cal");this.$("inner").attr("aria-expanded",true);g.addPopoverInstance(this._oPopup);this._getCalendar().focus();}
function v(){if(!this.getDateValue()){this._oPopup.getBeginButton().setEnabled(false);}this.removeStyleClass(I.ICON_PRESSED_CSS_CLASS);this.$("inner").attr("aria-expanded",false);this._restoreInputSelection(this._$input.get(0));this._getCalendar()._closedPickers();g.removePopoverInstance(this._oPopup);}
function w(E){var i=E.getParameter("days"),P=this._oPopup._getPopup();if(i>this._renderedDays){this._renderedDays=i;P._applyPosition(P._oLastPosition);}}
function x(S){var k=sap.ui.require("sap/ui/unified/DateTypeRange");if(S&&!(k&&S instanceof k)){throw new Error(S+"is not valid for aggregation \"specialDates\" of "+this);}}
function y(){if(this.isOpen()){this._getCalendar()._bDateRangeChanged=false;this._getCalendar().invalidate();}}
return p;});
},
	"sap/m/DateTimePicker.js":function(){sap.ui.getCore().loadLibrary("sap.ui.unified");sap.ui.define(["sap/ui/thirdparty/jquery",'./InputBase','./DatePicker','sap/ui/model/type/Date','sap/ui/unified/DateRange','./library','sap/ui/core/Control','sap/ui/Device','sap/ui/core/format/DateFormat','sap/ui/core/LocaleData','./DateTimePickerRenderer','./TimePickerSliders','./SegmentedButton','./SegmentedButtonItem','./ResponsivePopover','./Button',"sap/ui/events/KeyCodes","sap/ui/core/IconPool"],function(q,I,D,a,b,l,C,c,d,L,e,T,S,f,R,B,K,g){"use strict";var P=l.PlacementType,h=l.ButtonType,k="Phone";
var m=D.extend("sap.m.DateTimePicker",{metadata:{library:"sap.m",properties:{minutesStep:{type:"int",group:"Misc",defaultValue:1},secondsStep:{type:"int",group:"Misc",defaultValue:1}},designtime:"sap/m/designtime/DateTimePicker.designtime",dnd:{draggable:false,droppable:true}}});
var n={Short:"short",Medium:"medium",Long:"long",Full:"full"};
var o=C.extend("sap.m.internal.DateTimePickerPopup",{
metadata:{library:"sap.m",aggregations:{_switcher:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},calendar:{type:"sap.ui.core.Control",multiple:false},timeSliders:{type:"sap.ui.core.Control",multiple:false}}},
renderer:{apiVersion:2,render:function(i,j){i.openStart("div",j);i.class("sapMDateTimePopupCont").class("sapMTimePickerDropDown");i.openEnd();var v=j.getAggregation("_switcher");if(v){i.openStart("div");i.class("sapMTimePickerSwitch");i.openEnd();i.renderControl(v);i.close("div");}var w=j.getCalendar();if(w){i.renderControl(w);}i.openStart("div");i.class("sapMTimePickerSep");i.openEnd();i.close("div");var x=j.getTimeSliders();if(x){i.renderControl(x);}i.close("div");}},
init:function(){},
onBeforeRendering:function(){var i=this.getAggregation("_switcher");if(!i){var j=sap.ui.getCore().getLibraryResourceBundle("sap.m");var v=j.getText("DATETIMEPICKER_DATE");var w=j.getText("DATETIMEPICKER_TIME");i=new S(this.getId()+"-Switch",{selectedKey:"Cal",items:[new f(this.getId()+"-Switch-Cal",{key:"Cal",text:v}),new f(this.getId()+"-Switch-Sli",{key:"Sli",text:w})]});i.attachSelect(this._handleSelect,this);this.setAggregation("_switcher",i,true);}if(c.system.phone||q('html').hasClass("sapUiMedia-Std-Phone")){i.setVisible(true);i.setSelectedKey("Cal");}else{i.setVisible(false);}},
onAfterRendering:function(){if(c.system.phone||q('html').hasClass("sapUiMedia-Std-Phone")){var i=this.getAggregation("_switcher");var j=i.getSelectedKey();this._switchVisibility(j);}},
_handleSelect:function(E){this._switchVisibility(E.getParameter("key"));},
_switchVisibility:function(i){var j=this.getCalendar();var v=this.getTimeSliders();if(!j||!v){return;}if(i=="Cal"){j.$().css("display","");v.$().css("display","none");}else{j.$().css("display","none");v.$().css("display","");v._updateSlidersValues();v._onOrientationChanged();v.openFirstSlider();}},
switchToTime:function(){var i=this.getAggregation("_switcher");if(i&&i.getVisible()){i.setSelectedKey("Sli");this._switchVisibility("Sli");}},
getSpecialDates:function(){return this._oDateTimePicker.getSpecialDates();},
onkeydown:function(E){var i=E.keyCode===K.TAB&&!E.shiftKey;var j=E.keyCode===K.TAB&&E.shiftKey;if(i&&E.target.classList.contains('sapUiCalHeadBLast')){this.getAggregation('timeSliders').getDomRef().children[0].focus();}if(j&&E.target.classList.contains('sapUiCalItem')){var v=this.oParent.getAggregation("footer").getAggregation("content").length-1;this.oParent.getAggregation("footer").getAggregation("content")[v].focus();}}
});
m.prototype.init=function(){D.prototype.init.apply(this,arguments);this._bOnlyCalendar=false;};
m.prototype.getIconSrc=function(){return g.getIconURI("date-time");};
m.prototype.exit=function(){D.prototype.exit.apply(this,arguments);if(this._oSliders){this._oSliders.destroy();delete this._oSliders;}this._oPopupContent=undefined;c.media.detachHandler(this._handleWindowResize,this);};
m.prototype.setDisplayFormat=function(i){D.prototype.setDisplayFormat.apply(this,arguments);if(this._oSliders){this._oSliders.setDisplayFormat(t.call(this));}return this;};
m.prototype.setMinutesStep=function(M){this.setProperty('minutesStep',M,true);if(this._oSliders){this._oSliders.setMinutesStep(M);}return this;};
m.prototype._getDefaultValueStyle=function(){return n.Medium;};
m.prototype.setMinDate=function(i){D.prototype.setMinDate.call(this,i);if(i){this._oMinDate.setHours(i.getHours(),i.getMinutes(),i.getSeconds());}return this;};
m.prototype.setMaxDate=function(i){D.prototype.setMaxDate.call(this,i);if(i){this._oMaxDate.setHours(i.getHours(),i.getMinutes(),i.getSeconds());}return this;};
m.prototype.setSecondsStep=function(i){this.setProperty('secondsStep',i,true);if(this._oSliders){this._oSliders.setSecondsStep(i);}return this;};
m.prototype._getFormatInstance=function(A,i){var M=q.extend({},A);var j=-1;if(M.style){j=M.style.indexOf("/");}if(i){var v=q.extend({},M);if(j>0){v.style=v.style.substr(0,j);}this._oDisplayFormatDate=d.getInstance(v);}return d.getDateTimeInstance(M);};
m.prototype._checkStyle=function(v){if(D.prototype._checkStyle.apply(this,arguments)){return true;}else if(v.indexOf("/")>0){var w=[n.Short,n.Medium,n.Long,n.Long];var x=false;for(var i=0;i<w.length;i++){var y=w[i];for(var j=0;j<w.length;j++){var z=w[j];if(v==y+"/"+z){x=true;break;}}if(x){break;}}return x;}return false;};
m.prototype._parseValue=function(v,i){var j=D.prototype._parseValue.apply(this,arguments);if(i&&!j){j=this._oDisplayFormatDate.parse(v);if(j){var O=this.getDateValue();if(!O){O=new Date();}j.setHours(O.getHours());j.setMinutes(O.getMinutes());j.setSeconds(O.getSeconds());j.setMilliseconds(O.getMilliseconds());}}return j;};
m.prototype._getLocaleBasedPattern=function(i){var j=L.getInstance(sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale()),v=i.indexOf("/");if(v>0){return j.getCombinedDateTimePattern(i.substr(0,v),i.substr(v+1));}else{return j.getCombinedDateTimePattern(i,i);}};
m.prototype._createPopup=function(){var i,j,v,O,w,x;if(!this._oPopup){v=sap.ui.getCore().getLibraryResourceBundle("sap.m");O=v.getText("TIMEPICKER_SET");w=v.getText("TIMEPICKER_CANCEL");this._oPopupContent=new o(this.getId()+"-PC");this._oPopupContent._oDateTimePicker=this;this._oOKButton=new B(this.getId()+"-OK",{text:O,type:h.Emphasized,press:_.bind(this)});this._oPopup=new R(this.getId()+"-RP",{showCloseButton:false,showHeader:false,placement:P.VerticalPreferedBottom,beginButton:this._oOKButton,content:this._oPopupContent,afterOpen:r.bind(this),afterClose:s.bind(this)});if(c.system.phone){i=this.$("inner").attr("aria-labelledby");j=i?document.getElementById(i).getAttribute("aria-label"):"";this._oPopup.setTitle(j);this._oPopup.setShowHeader(true);this._oPopup.setShowCloseButton(true);}else{this._oPopup.setEndButton(new B(this.getId()+"-Cancel",{text:w,press:p.bind(this)}));}this._oPopup.addStyleClass("sapMDateTimePopup");x=this._oPopup.getAggregation("_popup");if(x.setShowArrow){x.setShowArrow(false);}this.setAggregation("_popup",this._oPopup,true);}};
m.prototype._openPopup=function(){if(!this._oPopup){return;}this.addStyleClass(I.ICON_PRESSED_CSS_CLASS);this._storeInputSelection(this._$input.get(0));var i=this._oPopup.getAggregation("_popup");i.oPopup.setAutoCloseAreas([this.getDomRef()]);this._oPopup.openBy(this);var j=this._oPopup.getContent()[0]&&this._oPopup.getContent()[0].getTimeSliders();if(j){setTimeout(j._updateSlidersValues.bind(j),0);}};
m.prototype._createPopupContent=function(){var N=!this._oCalendar;D.prototype._createPopupContent.apply(this,arguments);if(N){this._oPopupContent.setCalendar(this._oCalendar);this._oCalendar.attachSelect(u,this);}if(!this._oSliders){this._oSliders=new T(this.getId()+"-Sliders",{minutesStep:this.getMinutesStep(),secondsStep:this.getSecondsStep(),displayFormat:t.call(this),localeId:this.getLocaleId()})._setShouldOpenSliderAfterRendering(true);this._oPopupContent.setTimeSliders(this._oSliders);}};
m.prototype._selectFocusedDateValue=function(i){var j=this._oCalendar;j.removeAllSelectedDates();j.addSelectedDate(i);return this;};
m.prototype._fillDateRange=function(){var i=this.getDateValue(),j=true;if(i){i=new Date(i.getTime());this._oOKButton.setEnabled(true);}else{j=false;i=this.getInitialFocusedDateValue();if(!i){i=new Date();this._oCalendar.removeAllSelectedDates();}var M=this._oMaxDate.getTime();if(i.getTime()<this._oMinDate.getTime()||i.getTime()>M){i=this._oMinDate;}this._oOKButton.setEnabled(false);}this._oCalendar.focusDate(i);if(j){if(!this._oDateRange.getStartDate()||this._oDateRange.getStartDate().getTime()!=i.getTime()){this._oDateRange.setStartDate(i);}}this._oSliders._setTimeValues(i);};
m.prototype._getSelectedDate=function(){var i=D.prototype._getSelectedDate.apply(this,arguments);if(i){var j=this._oSliders.getTimeValues();var v=this._oSliders._getDisplayFormatPattern();if(v.search("h")>=0||v.search("H")>=0){i.setHours(j.getHours());}if(v.search("m")>=0){i.setMinutes(j.getMinutes());}if(v.search("s")>=0){i.setSeconds(j.getSeconds());}if(i.getTime()<this._oMinDate.getTime()){i=new Date(this._oMinDate.getTime());}else if(i.getTime()>this._oMaxDate.getTime()){i=new Date(this._oMaxDate.getTime());}}return i;};
m.prototype.getLocaleId=function(){return sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();};
m.prototype.getAccessibilityInfo=function(){var i=D.prototype.getAccessibilityInfo.apply(this,arguments);i.type=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_DATETIMEINPUT");return i;};
function _(E){this._handleCalendarSelect();}
function p(E){this.onsaphide(E);if(!this.getDateValue()){this._oCalendar.removeAllSelectedDates();}}
m.prototype._handleWindowResize=function(i){var j=this.getAggregation("_popup").getContent()[0].getAggregation("_switcher"),v=this.getAggregation("_popup").getContent()[0].getCalendar(),w=this.getAggregation("_popup").getContent()[0].getTimeSliders();if(i.name===k){j.setVisible(true);this.getAggregation("_popup").getContent()[0]._switchVisibility(j.getSelectedKey());}else{j.setVisible(false);w.$().css("display","");v.$().css("display","");}};
function r(E){this.$("inner").attr("aria-expanded",true);this._oCalendar.focus();this._oSliders._onOrientationChanged();c.media.attachHandler(this._handleWindowResize,this);}
function s(){this.removeStyleClass(I.ICON_PRESSED_CSS_CLASS);this.$("inner").attr("aria-expanded",false);this._restoreInputSelection(this._$input.get(0));this._oCalendar._closedPickers();c.media.detachHandler(this._handleWindowResize,this);}
function t(){var i=this.getDisplayFormat();var j;var v=this.getBinding("value");if(v&&v.oType&&(v.oType instanceof a)){i=v.oType.getOutputPattern();}else if(v&&v.oType&&v.oType.oFormat){i=v.oType.oFormat.oFormatOptions.pattern;}else{i=this.getDisplayFormat();}if(!i){i=n.Medium;}var w=i.indexOf("/");if(w>0&&this._checkStyle(i)){i=i.substr(w+1);}if(i==n.Short||i==n.Medium||i==n.Long||i==n.Full){var x=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();var y=L.getInstance(x);j=y.getTimePattern(i);}else{j=i;}return j;}
function u(E){this._oOKButton.setEnabled(true);this._oPopupContent.switchToTime();}
return m;});
},
	"sap/m/Menu.js":function(){sap.ui.getCore().loadLibrary("sap.ui.unified");sap.ui.define(['./library','sap/ui/core/Control','./Button','./Dialog','./NavContainer','./List','./Page','./MenuListItem','sap/ui/unified/Menu','sap/ui/unified/MenuItem','sap/ui/Device','sap/ui/core/EnabledPropagator',"sap/ui/thirdparty/jquery","sap/ui/core/Popup"],function(l,C,B,D,N,L,P,M,U,a,b,E,q,c){"use strict";var d=c.Dock;var e=l.ListType;var f=l.ListMode;
var g=C.extend("sap.m.Menu",{
metadata:{interfaces:["sap.ui.core.IContextMenu"],library:"sap.m",properties:{title:{type:"string",group:"Misc",defaultValue:null}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.MenuItem",multiple:true,singularName:"item",bindable:"bindable"},_dialog:{type:"sap.m.Dialog",multiple:false,visibility:"hidden"},_menu:{type:"sap.ui.unified.Menu",multiple:false,visibility:"hidden"}},events:{itemSelected:{parameters:{item:{type:"sap.m.MenuItem"}}},closed:{}}},
renderer:null
});
E.call(g.prototype);g.UNIFIED_MENU_ITEMS_ID_SUFFIX='-unifiedmenu';g.UNFIFIED_MENU_ITEMS_PROPS=a.getMetadata().getAllProperties();g.LIST_ITEMS_ID_SUFFIX='-menuinnerlist';g.MENU_LIST_ITEMS_PROPS=M.getMetadata().getAllProperties();
g.prototype.init=function(){if(b.system.phone){this._initDialog();}this._bIsInitialized=false;};
g.prototype.exit=function(){if(this._navContainerId){this._navContainerId=null;}if(this._bIsInitialized){this._bIsInitialized=null;}if(this._getMenu()&&this._getMenu().getPopup()){this._getMenu().getPopup().detachClosed(this._menuClosed,this);}};
g.prototype.invalidate=function(){};
g.prototype.setTitle=function(t){var n=this._getNavContainer();this.setProperty("title",t,true);if(n&&n.getPages().length){n.getPages()[0].setTitle(t);}return this;};
g.prototype.openBy=function(o,w,s,i,O){if(b.system.phone){this._openDialog();}else{if(!this._bIsInitialized){this._initAllMenuItems();this._bIsInitialized=true;}if(!s){s=d.BeginTop;}if(!i){i=d.BeginBottom;}if(!O){O="0 -2";}this._getMenu().open(w,o,s,i,o,O);}};
g.prototype.close=function(){if(b.system.phone){this._getDialog().close();}else{this._getVisualParent().close();}};
g.prototype._initDialog=function(){var o=new D({showHeader:false,stretch:true,content:this._initNavContainer(),buttons:[this._initCloseButton()]});o.addStyleClass("sapMRespMenuDialog");o.removeStyleClass("sapUiPopupWithPadding");this.setAggregation("_dialog",o,true);o.attachAfterClose(this._menuClosed,this);};
g.prototype._getDialog=function(){return this.getAggregation("_dialog");};
g.prototype._openDialog=function(){if(!this._bIsInitialized){this._initAllPages();this._bIsInitialized=true;}this._getNavContainer().to(this._getNavContainer().getPages()[0]);this._getDialog().open();};
g.prototype._initAllMenuItems=function(){this._initMenuForItems(this.getItems());};
g.prototype._setCustomEnhanceAccStateFunction=function(i){this._fnEnhanceUnifiedMenuAccState=i;};
g.prototype._initMenuForItems=function(i,p){var m=new U();m._setCustomEnhanceAccStateFunction(this._fnEnhanceUnifiedMenuAccState);m.isCozy=this._isMenuCozy.bind(this,m);this.addStyleClass('sapMMenu');m.aCustomStyleClasses=this.aCustomStyleClasses;m.mCustomStyleClassMap=this.mCustomStyleClassMap;i.forEach(function(I){this._addVisualMenuItemFromItem(I,m);}.bind(this));if(p){p.setSubmenu(m);}else{m.getPopup().attachClosed(this._menuClosed,this);this.setAggregation('_menu',m,true);}m.attachItemSelect(this._handleMenuItemSelect,this);};
g.prototype._menuClosed=function(){this.fireClosed();};
g.prototype._getMenu=function(){return this.getAggregation("_menu");};
g.prototype._initCloseButton=function(){var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");return new B({text:r.getText("MENU_CLOSE"),press:h.bind(this)});};
function h(){this._getDialog().close();}
g.prototype._initNavContainer=function(){var n=new N();this._navContainerId=n.getId();return n;};
g.prototype._getNavContainer=function(){return sap.ui.getCore().byId(this._navContainerId);};
g.prototype._initAllPages=function(){this._initPageForParent(this);};
g.prototype._initPageForParent=function(p){var i=p.getItems(),k=p instanceof g,s=k?p.getTitle():p.getText(),o=new L({mode:f.None}),m=new P({title:s,showNavButton:!k,content:o});if(!k){this._setBackButtonTooltipForPageWithParent(p,m);}m.attachNavButtonPress(function(){this._getNavContainer().back();},this);this._getNavContainer().addPage(m);i.forEach(function(I){this._addListItemFromItem(I,m);},this);this._updateListInset(o);o.attachEvent("itemPress",this._handleListItemPress,this);return m;};
g.prototype._handleListItemPress=function(o){var i=o.getParameter("listItem"),m=sap.ui.getCore().byId(i.getMenuItem()),p=m._getVisualChild();if(p){this._getNavContainer().to(p);}else{this._getDialog().close();this.fireItemSelected({item:m});}m.firePress();};
g.prototype._setBackButtonTooltipForPageWithParent=function(p,o){var i=p.getParent(),r=sap.ui.getCore().getLibraryResourceBundle("sap.m"),s;s=i instanceof g?i.getTitle():i.getText();s=r.getText("MENU_PAGE_BACK_BUTTON")+" "+s;o.setNavButtonTooltip(s);};
g.prototype._createMenuListItemFromItem=function(i){return new M({id:this._generateListItemId(i.getId()),type:e.Active,icon:i.getIcon(),title:i.getText(),startsSection:i.getStartsSection(),menuItem:i,tooltip:i.getTooltip(),visible:i.getVisible()});};
g.prototype._createVisualMenuItemFromItem=function(I){var u=new a({id:this._generateUnifiedMenuItemId(I.getId()),icon:I.getIcon(),text:I.getText(),startsSection:I.getStartsSection(),tooltip:I.getTooltip(),visible:I.getVisible(),enabled:I.getEnabled()}),i,k=I.getCustomData();for(i=0;i<k.length;i++){I._addCustomData(u,k[i]);}return u;};
g.prototype._addVisualMenuItemFromItem=function(i,m,I){var o=this._createVisualMenuItemFromItem(i);i._setVisualParent(m);i._setVisualControl(o);var k=['aggregationChanged','propertyChanged'];k.forEach(function(s){var n='_on'+s.slice(0,1).toUpperCase()+s.slice(1);i.attachEvent(s,this[n],this);},this);if(i.getItems().length!==0){this._initMenuForItems(i.getItems(),o);i._setVisualChild(i.getItems()[0]._getVisualParent());}if(I===undefined){m.addItem(o);}else{m.insertItem(o,I);}};
g.prototype._addListItemFromItem=function(i,p,I){var m=this._createMenuListItemFromItem(i),o=p.getContent()[0];i._setVisualParent(p);i._setVisualControl(m);var k=['aggregationChanged','propertyChanged'];k.forEach(function(s){var n='_on'+s.slice(0,1).toUpperCase()+s.slice(1);i.attachEvent(s,this[n],this);},this);if(i.getItems().length!==0){this._initPageForParent(i);i._setVisualChild(i.getItems()[0]._getVisualParent());}if(I===undefined){o.addItem(m);}else{o.insertItem(m,I);}o.rerender();};
g.prototype._connectVisualItem=function(i,o,I){if(!o||sap.ui.getCore().byId(i._getVisualControl())){return;}if(b.system.phone){this._addListItemFromItem(i,o,I);var k=o.getContent()[0];this._updateListInset(k);}else{this._addVisualMenuItemFromItem(i,o,I);}};
g.prototype._updateListInset=function(o){var H=false,I="sapMListIcons",k=o.getItems();for(var i=0;i<k.length;i++){if(k[i].getIcon()){H=true;break;}}if(H){o.addStyleClass(I);}else{o.removeStyleClass(I);}};
g.prototype._handleMenuItemSelect=function(o){var u=o.getParameter("item"),m;if(!u){return;}m=this._findMenuItemByUnfdMenuItem(u);if(m&&!m.getItems().length){this.fireItemSelected({item:m});}if(m){m.firePress();}};
g.prototype._generateListItemId=function(m){return m+g.LIST_ITEMS_ID_SUFFIX;};
g.prototype._generateUnifiedMenuItemId=function(m){return m+g.UNIFIED_MENU_ITEMS_ID_SUFFIX;};
g.prototype._findMenuItemByUnfdMenuItem=function(u){var k=[],o=u,I,m,i;do{k.push(o.getId());o=o.getParent().getParent();}while(o instanceof a);I=this.getItems();do{m=k.pop();for(i=0;i<I.length;i++){if(I[i]._getVisualControl()===m){if(k.length===0){return I[i];}else{I=I[i].getItems();break;}}}}while(k.length);return null;};
g.prototype._isMenuCozy=function(m){if(!m.bCozySupported){return false;}if(m.hasStyleClass("sapUiSizeCozy")){return true;}if(j(m.oOpenerRef)){return true;}return false;};
function j(r){if(!r){return false;}r=r.$?r.$():q(r);var $=r.closest(".sapUiSizeCompact,.sapUiSizeCondensed,.sapUiSizeCozy");return(!$.hasClass("sapUiSizeCompact")&&!$.hasClass("sapUiSizeCondensed"))||$.hasClass("sapUiSizeCozy");}
g.prototype.addAggregation=function(A,o,s){C.prototype.addAggregation.apply(this,arguments);if(A==="items"){this._connectVisualItem(o,this._getVisualParent());}return this;};
g.prototype.insertAggregation=function(A,o,i,s){C.prototype.insertAggregation.apply(this,arguments);if(A==="items"){this._connectVisualItem(o,this._getVisualParent(),i);}return this;};
g.prototype.removeAggregation=function(A,o,s){var i=C.prototype.removeAggregation.apply(this,arguments);if(A==="items"){this._removeVisualItem(i);}return i;};
g.prototype.removeAllAggregation=function(A,s){var I=C.prototype.removeAllAggregation.apply(this,arguments);if(A==="items"){for(var i=0;i<I.length;i++){this._removeVisualItem(I[i]);}}return I;};
g.prototype._removeVisualItem=function(i,p){var v=sap.ui.getCore().byId(i._getVisualControl()),m;if(v){m=v.getParent();m.removeItem(v);if(b.system.phone){this._removeSubPageForItem(i);if(m.getItems().length===0){if(p){p._setVisualChild(null);sap.ui.getCore().byId(p._getVisualControl()).rerender();}}if(m){m.rerender();}}}};
g.prototype.destroyAggregation=function(A,s){if(A==="items"){for(var i=0;i<this.getItems().length;i++){this._removeVisualItem(this.getItems()[i]);}}return C.prototype.destroyAggregation.apply(this,arguments);};
g.prototype._removeSubPageForItem=function(I,s){var S;if(!s){for(var i=0;i<I.getItems().length;i++){this._removeSubPageForItem(I.getItems()[i]);}}if(I._getVisualChild()){S=sap.ui.getCore().byId(I._getVisualChild());if(this._getNavContainer()&&S){this._getNavContainer().removePage(S);}!!S&&S.destroy();}};
g.prototype._getVisualParent=function(){var n=this._getNavContainer(),m=this._getMenu();if(n&&n.getPages().length){return n.getPages()[0];}else{return m;}};
g.prototype._onPropertyChanged=function(o){var p=o.getParameter("propertyKey"),i=o.getParameter("propertyValue"),t=b.system.phone?g.MENU_LIST_ITEMS_PROPS:g.UNFIFIED_MENU_ITEMS_PROPS,G=b.system.phone?this._generateListItemId:this._generateUnifiedMenuItemId,T;if(b.system.phone&&p==='text'){p='title';}if(!t[p]){return;}T=G(o.getSource().getId());if(T){sap.ui.getCore().byId(T).setProperty(p,i);if(b.system.phone&&this._getDialog().isOpen()){this._getDialog().close();}}};
g.prototype._onAggregationChanged=function(o){var A=o.getParameter("aggregationName");switch(A){case'items':this._onItemsAggregationChanged(o);break;case'tooltip':this._onTooltipAggregationChanged(o);break;}};
g.prototype._onTooltipAggregationChanged=function(o){var v=o.getSource()._getVisualControl(),m=o.getParameter("methodName"),i=o.getParameter("methodParams"),V;if(!v){return;}V=sap.ui.getCore().byId(v);if(m==="set"){V.setTooltip(i.item);}if(m==="destroy"){V.destroyTooltip();}};
g.prototype._onItemsAggregationChanged=function(o){var I=o.getSource(),m=o.getParameter("methodName"),k=o.getParameter("methodParams"),n;if(m==="add"||m==="insert"){if(m==="insert"){n=k.index;}this._addOrInsertItem(I,k.item,n);}if(m==="remove"){this._removeVisualItem(k.item,I);}if(m==="removeall"){for(var i=0;i<k.items.length;i++){this._removeVisualItem(k.items[i],I);}}if(m==="destroy"){this._destroyItem(I);}};
g.prototype._addOrInsertItem=function(p,n,i){var o;if(p._getVisualChild()){this._connectVisualItem(n,sap.ui.getCore().byId(p._getVisualChild()),i);}else{if(b.system.phone){this._initPageForParent(p);p._setVisualChild(p.getItems()[0]._getVisualParent());o=sap.ui.getCore().byId(p._getVisualControl());o.rerender();}else{this._initMenuForItems(p.getItems(),sap.ui.getCore().byId(p._getVisualControl()));p._setVisualChild(p.getItems()[0]._getVisualParent());}}};
g.prototype._destroyItem=function(i){var v=sap.ui.getCore().byId(i._getVisualControl());if(v&&v.setMenuItem){v.setMenuItem(null);}this._removeSubPageForItem(i,true);i._setVisualChild(null);if(v&&v.setMenuItem){v.rerender();v.setMenuItem(i);}};
g.prototype.getDomRefId=function(){if(b.system.phone){return this._getDialog().getId();}else{return this._getMenu().getId();}};
g.prototype.openAsContextMenu=function(o,O){if(b.system.phone){this._openDialog();}else{if(!this._bIsInitialized){this._initAllMenuItems();this._bIsInitialized=true;}this._getMenu().openAsContextMenu(o,O);}};
["addStyleClass","removeStyleClass","toggleStyleClass"].forEach(function(m){g.prototype[m]=function(s,S){var o=this._getDialog();C.prototype[m].apply(this,arguments);if(o){o[m].apply(o,arguments);}return this;};});return g;});
},
	"sap/ui/integration/customElements/CustomElementCardEditor.js":function(){sap.ui.require(["sap/ui/integration/designtime/editor/CardEditor","sap/ui/integration/customElements/CustomElementBase"],function(C,a){"use strict";var b=a.extend(C,{});b.prototype.getCurrentSettings=function(){return this._getControl().getCurrentSettings();};var d=["ui-integration-card"];a.define("ui-integration-card-editor",b,d);});
}
},"sap-ui-integration-editor"
);
//# sourceMappingURL=sap-ui-integration-editor.js.map