/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/core/Control","sap/ui/core/Core","sap/m/ScrollBar","sap/m/library","sap/ui/base/ManagedObjectObserver","sap/ui/core/ResizeHandler","sap/ui/core/Configuration","sap/ui/core/delegate/ScrollEnablement","sap/ui/Device","sap/ui/base/ManagedObject","sap/f/DynamicPageTitle","sap/f/DynamicPageHeader","./DynamicPageRenderer","sap/base/Log","sap/ui/dom/getScrollbarSize","sap/ui/core/theming/Parameters",'sap/ui/dom/units/Rem',"sap/ui/core/library"],function(l,C,a,S,L,M,R,b,c,D,d,e,f,g,h,i,P,j,k){"use strict";var m=L.PageBackgroundDesign;var n=C.extend("sap.f.DynamicPage",{metadata:{library:"sap.f",properties:{preserveHeaderStateOnScroll:{type:"boolean",group:"Behavior",defaultValue:false},headerExpanded:{type:"boolean",group:"Behavior",defaultValue:true},toggleHeaderOnTitleClick:{type:"boolean",group:"Behavior",defaultValue:true},showFooter:{type:"boolean",group:"Behavior",defaultValue:false},backgroundDesign:{type:"sap.m.PageBackgroundDesign",group:"Appearance",defaultValue:m.Standard},fitContent:{type:"boolean",group:"Behavior",defaultValue:false}},associations:{stickySubheaderProvider:{type:"sap.f.IDynamicPageStickyContent",multiple:false}},aggregations:{title:{type:"sap.f.DynamicPageTitle",multiple:false},header:{type:"sap.f.DynamicPageHeader",multiple:false},content:{type:"sap.ui.core.Control",multiple:false},footer:{type:"sap.m.IBar",multiple:false},landmarkInfo:{type:"sap.f.DynamicPageAccessibleLandmarkInfo",multiple:false},_scrollBar:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},dnd:{draggable:false,droppable:true},designtime:"sap/f/designtime/DynamicPage.designtime"}});function o(O){if(arguments.length===1){return O&&("length"in O)?O.length>0:!!O;}return Array.prototype.slice.call(arguments).every(function(q){return o(q);});}function p(E){var q;if(!E){return false;}q=E.getBoundingClientRect();return!!(q.width&&q.height);}var A=k.AccessibleLandmarkRole;n.HEADER_MAX_ALLOWED_PINNED_PERCENTAGE=0.6;n.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE=0.6;n.HEADER_MAX_ALLOWED_NON_SROLLABLE_ON_MOBILE=0.3;n.BREAK_POINTS={TABLET:1024,PHONE:600};n.EVENTS={TITLE_PRESS:"_titlePress",TITLE_MOUSE_OVER:"_titleMouseOver",TITLE_MOUSE_OUT:"_titleMouseOut",PIN_UNPIN_PRESS:"_pinUnpinPress",VISUAL_INDICATOR_MOUSE_OVER:"_visualIndicatorMouseOver",VISUAL_INDICATOR_MOUSE_OUT:"_visualIndicatorMouseOut",HEADER_VISUAL_INDICATOR_PRESS:"_headerVisualIndicatorPress",TITLE_VISUAL_INDICATOR_PRESS:"_titleVisualIndicatorPress"};n.MEDIA={PHONE:"sapFDynamicPage-Std-Phone",TABLET:"sapFDynamicPage-Std-Tablet",DESKTOP:"sapFDynamicPage-Std-Desktop"};n.RESIZE_HANDLER_ID={PAGE:"_sResizeHandlerId",TITLE:"_sTitleResizeHandlerId",HEADER:"_sHeaderResizeHandlerId",CONTENT:"_sContentResizeHandlerId"};n.DIV="div";n.HEADER="header";n.FOOTER="footer";n.SHOW_FOOTER_CLASS_NAME="sapFDynamicPageActualFooterControlShow";n.HIDE_FOOTER_CLASS_NAME="sapFDynamicPageActualFooterControlHide";n.NAVIGATION_CLASS_NAME="sapFDynamicPageNavigation";n.ARIA_ROLE_DESCRIPTION="DYNAMIC_PAGE_ROLE_DESCRIPTION";n.prototype.init=function(){this._bPinned=false;this._bHeaderInTitleArea=false;this._bExpandingWithAClick=false;this._bSuppressToggleHeaderOnce=false;this._headerBiggerThanAllowedHeight=false;this._oStickySubheader=null;this._bStickySubheaderInTitleArea=false;this._bMSBrowser=D.browser.internet_explorer||D.browser.edge||false;this._oScrollHelper=new c(this,this.getId()+"-content",{horizontal:false,vertical:true});this._oStickyHeaderObserver=null;this._oHeaderObserver=null;this._oSubHeaderAfterRenderingDelegate={onAfterRendering:function(){this._bStickySubheaderInTitleArea=false;this._adjustStickyContent();}};this._setAriaRoleDescription(a.getLibraryResourceBundle("sap.f").getText(n.ARIA_ROLE_DESCRIPTION));this._iHeaderContentPaddingBottom=j.toPx(P.get("_sap_f_DynamicPageHeader_PaddingBottom"));};n.prototype.onBeforeRendering=function(){if(!this._preserveHeaderStateOnScroll()){this._attachPinPressHandler();}this._attachTitlePressHandler();this._attachVisualIndicatorsPressHandlers();if(D.system.desktop){this._attachVisualIndicatorMouseOverHandlers();this._attachTitleMouseOverHandlers();}this._attachHeaderObserver();this._addStickySubheaderAfterRenderingDelegate();this._detachScrollHandler();this._detachResizeHandlers();this._toggleAdditionalNavigationClass();};n.prototype.onAfterRendering=function(){var s,q;if(this._preserveHeaderStateOnScroll()){setTimeout(this._overridePreserveHeaderStateOnScroll.bind(this),0);}this._bPinned=false;this._cacheDomElements();this._attachResizeHandlers();this._updateMedia(this._getWidth(this));this._attachScrollHandler();this._updateScrollBar();this._attachPageChildrenAfterRenderingDelegates();this._resetPinButtonState();if(!this.getHeaderExpanded()){this._snapHeader(false);s=this.getHeader()&&!this.getPreserveHeaderStateOnScroll()&&this._canSnapHeaderOnScroll();if(s){q=this._getScrollBar().getScrollPosition();this._setScrollPosition(q?q:this._getSnappingHeight());}else{this._toggleHeaderVisibility(false);this._moveHeaderToTitleArea();}}this._updateToggleHeaderVisualIndicators();this._updateTitleVisualState();};n.prototype.exit=function(){this._detachResizeHandlers();if(this._oScrollHelper){this._oScrollHelper.destroy();}if(this._oStickyHeaderObserver){this._oStickyHeaderObserver.disconnect();}if(this._oHeaderObserver){this._oHeaderObserver.disconnect();}if(this._oStickySubheader){this._oStickySubheader.removeEventDelegate(this._oSubHeaderAfterRenderingDelegate);}};n.prototype.setShowFooter=function(s){var r=this.setProperty("showFooter",s,true);this._toggleFooter(s);return r;};n.prototype.setHeader=function(H){var O=this.getHeader();if(H===O){return this;}if(O){if(this._oStickyHeaderObserver){this._oStickyHeaderObserver.disconnect();}if(this._oHeaderObserver){this._oHeaderObserver.disconnect();}this._deRegisterResizeHandler(n.RESIZE_HANDLER_ID.HEADER);O.detachEvent(n.EVENTS.PIN_UNPIN_PRESS,this._onPinUnpinButtonPress);this._bAlreadyAttachedPinPressHandler=false;O.detachEvent(n.EVENTS.HEADER_VISUAL_INDICATOR_PRESS,this._onCollapseHeaderVisualIndicatorPress);this._bAlreadyAttachedHeaderIndicatorPressHandler=false;O.detachEvent(n.EVENTS.VISUAL_INDICATOR_MOUSE_OVER,this._onVisualIndicatorMouseOver);O.detachEvent(n.EVENTS.VISUAL_INDICATOR_MOUSE_OUT,this._onVisualIndicatorMouseOut);this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler=false;this._bAlreadyAttachedStickyHeaderObserver=false;this._bAlreadyAttachedHeaderObserver=false;}this.setAggregation("header",H);return this;};n.prototype.setStickySubheaderProvider=function(s){var O,q=this.getStickySubheaderProvider();if(s===q){return this;}O=a.byId(q);if(this._oStickySubheader&&O){O._returnStickyContent();O._setStickySubheaderSticked(false);this._oStickySubheader.removeEventDelegate(this._oSubHeaderAfterRenderingDelegate);this._bAlreadyAddedStickySubheaderAfterRenderingDelegate=false;this._oStickySubheader=null;}this.setAssociation("stickySubheaderProvider",s);return this;};n.prototype.setHeaderExpanded=function(H){H=this.validateProperty("headerExpanded",H);if(this._bPinned){return this;}if(this.getHeaderExpanded()===H){return this;}if(this.getDomRef()){this._titleExpandCollapseWhenAllowed();}this.setProperty("headerExpanded",H,true);return this;};n.prototype.setToggleHeaderOnTitleClick=function(t){var H=this.getHeaderExpanded(),r=this.setProperty("toggleHeaderOnTitleClick",t,true);t=this.getProperty("toggleHeaderOnTitleClick");this._updateTitleVisualState();this._updateToggleHeaderVisualIndicators();this._updateARIAStates(H);return r;};n.prototype.setFitContent=function(F){var r=this.setProperty("fitContent",F,true);if(o(this.$())){this._updateFitContainer();}return r;};n.prototype.getScrollDelegate=function(){return this._oScrollHelper;};n.prototype._overridePreserveHeaderStateOnScroll=function(){if(!this._shouldOverridePreserveHeaderStateOnScroll()){this._headerBiggerThanAllowedHeight=false;return;}this._headerBiggerThanAllowedHeight=true;if(this.getHeaderExpanded()){this._moveHeaderToContentArea(true);}else{this._adjustSnap();}this._updateScrollBar();};n.prototype._shouldOverridePreserveHeaderStateOnScroll=function(){return this._headerBiggerThanAllowedToBeFixed()&&this._preserveHeaderStateOnScroll();};n.prototype._toggleFooter=function(s){var F=this.getFooter(),u,q;if(!o(this.$())||!o(F)||!o(this.$footerWrapper)){return;}q=a.getConfiguration().getAnimationMode();u=q!==b.AnimationMode.none&&q!==b.AnimationMode.minimal;this._toggleFooterSpacer(s);if(u){this._toggleFooterAnimation(s,F);}else{this.$footerWrapper.toggleClass("sapUiHidden",!s);}this._updateScrollBar();};n.prototype._toggleFooterAnimation=function(s,F){this.$footerWrapper.on("webkitAnimationEnd animationend",this._onToggleFooterAnimationEnd.bind(this,F));if(s){this.$footerWrapper.removeClass("sapUiHidden");}F.toggleStyleClass(n.SHOW_FOOTER_CLASS_NAME,s);F.toggleStyleClass(n.HIDE_FOOTER_CLASS_NAME,!s);};n.prototype._onToggleFooterAnimationEnd=function(F){this.$footerWrapper.off("webkitAnimationEnd animationend");if(F.hasStyleClass(n.HIDE_FOOTER_CLASS_NAME)){this.$footerWrapper.addClass("sapUiHidden");F.removeStyleClass(n.HIDE_FOOTER_CLASS_NAME);}else{F.removeStyleClass(n.SHOW_FOOTER_CLASS_NAME);}};n.prototype._toggleFooterSpacer=function(t){var $=this.$("spacer");if(o($)){$.toggleClass("sapFDynamicPageContentWrapperSpacer",t);}if(o(this.$contentFitContainer)){this.$contentFitContainer.toggleClass("sapFDynamicPageContentFitContainerFooterVisible",t);}};n.prototype._toggleHeaderInTabChain=function(t){var q=this.getTitle(),r=this.getHeader();if(!o(q)||!o(r)){return;}r.$().css("visibility",t?"visible":"hidden");};n.prototype._snapHeader=function(q,u){var r=this.getTitle();if(this._bPinned&&!u){h.debug("DynamicPage :: aborted snapping, header is pinned",this);return;}h.debug("DynamicPage :: snapped header",this);if(this._bPinned&&u){this._unPin();this._togglePinButtonPressedState(false);}if(o(r)){r._toggleState(false,u);if(q&&this._bHeaderInTitleArea){this._moveHeaderToContentArea(true);}}if(!o(this.$titleArea)){h.warning("DynamicPage :: couldn't snap header. There's no title.",this);return;}this.setProperty("headerExpanded",false,true);if(this._hasVisibleTitleAndHeader()){this.$titleArea.addClass(D.system.phone&&r.getSnappedTitleOnMobile()?"sapFDynamicPageTitleSnappedTitleOnMobile":"sapFDynamicPageTitleSnapped");this._updateToggleHeaderVisualIndicators();this._togglePinButtonVisibility(false);}this._toggleHeaderInTabChain(false);this._updateARIAStates(false);};n.prototype._expandHeader=function(q,u){var r=this.getTitle();h.debug("DynamicPage :: expand header",this);if(o(r)){r._toggleState(true,u);if(q){this._moveHeaderToTitleArea(true);}}if(!o(this.$titleArea)){h.warning("DynamicPage :: couldn't expand header. There's no title.",this);return;}this.setProperty("headerExpanded",true,true);if(this._hasVisibleTitleAndHeader()){this.$titleArea.removeClass(D.system.phone&&r.getSnappedTitleOnMobile()?"sapFDynamicPageTitleSnappedTitleOnMobile":"sapFDynamicPageTitleSnapped");this._updateToggleHeaderVisualIndicators();if(!this.getPreserveHeaderStateOnScroll()&&!this._headerBiggerThanAllowedToPin()){this._togglePinButtonVisibility(true);}}this._toggleHeaderInTabChain(true);this._updateARIAStates(true);};n.prototype._toggleHeaderVisibility=function(s,u){var E=this.getHeaderExpanded(),q=this.getTitle(),r=this.getHeader();if(this._bPinned&&!u){h.debug("DynamicPage :: header toggle aborted, header is pinned",this);return;}if(o(q)){q._toggleState(E);}if(o(r)){r.$().toggleClass("sapFDynamicPageHeaderHidden",!s);this._updateScrollBar();}};n.prototype._moveHeaderToContentArea=function(O){var q=this.getHeader();if(o(q)){q.$().prependTo(this.$wrapper);this._bHeaderInTitleArea=false;if(O){this._offsetContentOnMoveHeader();}}};n.prototype._moveHeaderToTitleArea=function(O){var q=this.getHeader();if(o(q)){q.$().prependTo(this.$stickyPlaceholder);this._bHeaderInTitleArea=true;if(O){this._offsetContentOnMoveHeader();}}};n.prototype._offsetContentOnMoveHeader=function(){var O=Math.ceil(this._getHeaderHeight()),q=this._getScrollPosition(),r=this._getScrollBar().getScrollPosition(),N;if(!O){return;}if(!q&&r){N=this._getScrollBar().getScrollPosition();}else{N=this._bHeaderInTitleArea?q-O:q+O;}N=Math.max(N,0);this._setScrollPosition(N,true);};n.prototype._pin=function(){var $=this.$();if(this._bPinned){return;}this._bPinned=true;if(!this._bHeaderInTitleArea){this._moveHeaderToTitleArea(true);this._updateScrollBar();}this._updateToggleHeaderVisualIndicators();this._togglePinButtonARIAState(this._bPinned);if(o($)){$.addClass("sapFDynamicPageHeaderPinned");}};n.prototype._unPin=function(){var $=this.$();if(!this._bPinned){return;}this._bPinned=false;this._updateToggleHeaderVisualIndicators();this._togglePinButtonARIAState(this._bPinned);if(o($)){$.removeClass("sapFDynamicPageHeaderPinned");}};n.prototype._togglePinButtonVisibility=function(t){var q=this.getHeader();if(o(q)){q._setShowPinBtn(t);}};n.prototype._togglePinButtonPressedState=function(q){var r=this.getHeader();if(o(r)){r._togglePinButton(q);}};n.prototype._togglePinButtonARIAState=function(q){var r=this.getHeader();if(o(r)){r._updateARIAPinButtonState(q);}};n.prototype._resetPinButtonState=function(){if(this._preserveHeaderStateOnScroll()){this._togglePinButtonVisibility(false);}else{this._togglePinButtonPressedState(false);this._togglePinButtonARIAState(false);}};n.prototype._restorePinButtonFocus=function(){this.getHeader()._focusPinButton();};n.prototype._getScrollPosition=function(){return o(this.$wrapper)?Math.ceil(this.$wrapper.scrollTop()):0;};n.prototype._setAriaRoleDescription=function(s){this._sAriaRoleDescription=s;return this;};n.prototype._getAriaRoleDescription=function(){return this._sAriaRoleDescription;};n.prototype._setScrollPosition=function(N,s){if(!o(this.$wrapper)){return;}if(this._getScrollPosition()===N){return;}if(s){this._bSuppressToggleHeaderOnce=true;}if(!this.getScrollDelegate()._$Container){this.getScrollDelegate()._$Container=this.$wrapper;}this.getScrollDelegate().scrollTo(0,N);};n.prototype._shouldSnapOnScroll=function(){return!this._preserveHeaderStateOnScroll()&&this._getScrollPosition()>=this._getSnappingHeight()&&this.getHeaderExpanded()&&!this._bPinned;};n.prototype._shouldExpandOnScroll=function(){var I=this._needsVerticalScrollBar();return!this._preserveHeaderStateOnScroll()&&this._getScrollPosition()<this._getSnappingHeight()&&!this.getHeaderExpanded()&&!this._bPinned&&I;};n.prototype._shouldStickStickyContent=function(){var I,s,q;q=this._getScrollPosition();I=q<Math.ceil(this._getHeaderHeight()-this._iHeaderContentPaddingBottom)&&!this._bPinned&&!this.getPreserveHeaderStateOnScroll();s=q===0||I&&this._hasVisibleHeader();return!s;};n.prototype._headerScrolledOut=function(){return this._getScrollPosition()>=this._getSnappingHeight();};n.prototype._headerSnapAllowed=function(){return!this._preserveHeaderStateOnScroll()&&this.getHeaderExpanded()&&!this._bPinned;};n.prototype._canSnapHeaderOnScroll=function(){var q=this._getMaxScrollPosition(),t=this._bMSBrowser?1:0;if(this._bHeaderInTitleArea){q+=this._getHeaderHeight();q-=t;}return q>this._getSnappingHeight();};n.prototype._getSnappingHeight=function(){var s=Math.ceil(this._getHeaderHeight()||this._getTitleHeight())-this._iHeaderContentPaddingBottom;return s>0?s:0;};n.prototype._getMaxScrollPosition=function(){var $;if(o(this.$wrapper)){$=this.$wrapper[0];return $.scrollHeight-$.clientHeight;}return 0;};n.prototype._needsVerticalScrollBar=function(){var t=this._bMSBrowser?1:0;return this._getMaxScrollPosition()>t;};n.prototype._getOwnHeight=function(){return this._getHeight(this);};n.prototype._getEntireHeaderHeight=function(){var t=0,H=0,q=this.getTitle(),r=this.getHeader();if(o(q)){t=q.$().outerHeight();}if(o(r)){H=r.$().outerHeight();}return t+H;};n.prototype._headerBiggerThanAllowedToPin=function(q){if(!(typeof q==="number"&&!isNaN(parseInt(q)))){q=this._getOwnHeight();}return this._getEntireHeaderHeight()>n.HEADER_MAX_ALLOWED_PINNED_PERCENTAGE*q;};n.prototype._headerBiggerThanAllowedToBeFixed=function(){var q=this._getOwnHeight();return this._getEntireHeaderHeight()>n.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE*q;};n.prototype._headerBiggerThanAllowedToBeExpandedInTitleArea=function(){var E=this._getEntireHeaderHeight(),q=this._getOwnHeight();if(q===0){return false;}return D.system.phone?E>=n.HEADER_MAX_ALLOWED_NON_SROLLABLE_ON_MOBILE*q:E>=q;};n.prototype._measureScrollBarOffsetHeight=function(){var H=0,s=!this.getHeaderExpanded(),q=this._bHeaderInTitleArea;if(this._preserveHeaderStateOnScroll()||this._bPinned||(!s&&this._bHeaderInTitleArea)){H=this._getTitleAreaHeight();h.debug("DynamicPage :: preserveHeaderState is enabled or header pinned :: title area height"+H,this);return H;}if(s||!o(this.getTitle())||!this._canSnapHeaderOnScroll()){H=this._getTitleHeight();h.debug("DynamicPage :: header snapped :: title height "+H,this);return H;}this._snapHeader(true);H=this._getTitleHeight();if(!s){this._expandHeader(q);}h.debug("DynamicPage :: snapped mode :: title height "+H,this);return H;};n.prototype._updateScrollBar=function(){var s,q,N;if(!D.system.desktop||!o(this.$wrapper)||(this._getHeight(this)===0)){return;}s=this._getScrollBar();s.setContentSize(this._measureScrollBarOffsetHeight()+this.$wrapper[0].scrollHeight+"px");q=this._needsVerticalScrollBar();N=this.bHasScrollbar!==q;if(N){s.toggleStyleClass("sapUiHidden",!q);this.toggleStyleClass("sapFDynamicPageWithScroll",q);this.bHasScrollbar=q;}setTimeout(this._updateFitContainer.bind(this),0);setTimeout(this._updateScrollBarOffset.bind(this),0);};n.prototype._updateFitContainer=function(N){var q=typeof N!=='undefined'?!N:!this._needsVerticalScrollBar(),F=this.getFitContent(),t=F||q;this.$contentFitContainer.toggleClass("sapFDynamicPageContentFitContainer",t);};n.prototype._updateScrollBarOffset=function(){var s=a.getConfiguration().getRTL()?"left":"right",O=this._needsVerticalScrollBar()?i().width+"px":0,F=this.getFooter();this.$titleArea.css("padding-"+s,O);if(o(F)){F.$().css(s,O);}};n.prototype._updateHeaderARIAState=function(E){var q=this.getHeader();if(o(q)){q._updateARIAState(E);}};n.prototype._updateTitleARIAState=function(E){var q=this.getTitle();if(o(q)){q._updateARIAState(E);}};n.prototype._updateARIAStates=function(E){this._updateHeaderARIAState(E);this._updateTitleARIAState(E);};n.prototype._applyContextualSettings=function(q){var r=q.contextualWidth;this._updateMedia(r);return d.prototype._applyContextualSettings.call(this,q);};n.prototype._updateMedia=function(w){if(!w){return;}if(w<=n.BREAK_POINTS.PHONE){this._updateMediaStyle(n.MEDIA.PHONE);}else if(w<=n.BREAK_POINTS.TABLET){this._updateMediaStyle(n.MEDIA.TABLET);}else{this._updateMediaStyle(n.MEDIA.DESKTOP);}};n.prototype._updateMediaStyle=function(s){Object.keys(n.MEDIA).forEach(function(q){var E=s===n.MEDIA[q];this.toggleStyleClass(n.MEDIA[q],E);},this);};n.prototype._toggleExpandVisualIndicator=function(t){var q=this.getTitle();if(o(q)){q._toggleExpandButton(t);}};n.prototype._focusExpandVisualIndicator=function(){var q=this.getTitle();if(o(q)){q._focusExpandButton();}};n.prototype._toggleCollapseVisualIndicator=function(t){var q=this.getHeader();if(o(q)){q._toggleCollapseButton(t);}};n.prototype._focusCollapseVisualIndicator=function(){var q=this.getHeader();if(o(q)){q._focusCollapseButton();}};n.prototype._updateToggleHeaderVisualIndicators=function(){var H,q,E,r=this._hasVisibleTitleAndHeader(),s=this.getHeader(),t=false;if(o(s)){t=!!s.getContent().length;}if(!this.getToggleHeaderOnTitleClick()||!r){q=false;E=false;}else{H=this.getHeaderExpanded();q=H;E=D.system.phone&&this.getTitle().getAggregation("snappedTitleOnMobile")?false:!H;}E=E&&t;q=q&&t;this._toggleCollapseVisualIndicator(q);this._toggleExpandVisualIndicator(E);};n.prototype._updateHeaderVisualState=function(H,q){var r=this.getHeader();if(H&&this.getPreserveHeaderStateOnScroll()){this._overridePreserveHeaderStateOnScroll();}if(!this._preserveHeaderStateOnScroll()&&r){if(this._headerBiggerThanAllowedToPin(q)||D.system.phone){this._unPin();this._togglePinButtonVisibility(false);this._togglePinButtonPressedState(false);}else{this._togglePinButtonVisibility(true);}if(this.getHeaderExpanded()&&this._bHeaderInTitleArea&&this._headerBiggerThanAllowedToBeExpandedInTitleArea()){this._expandHeader(false);this._setScrollPosition(0);}}};n.prototype._updateTitleVisualState=function(){var t=this.getTitle(),T=this._hasVisibleTitleAndHeader()&&this.getToggleHeaderOnTitleClick();this.$().toggleClass("sapFDynamicPageTitleClickEnabled",T&&!D.system.phone);if(o(t)){t._toggleFocusableState(T);}};n.prototype._scrollBellowCollapseVisualIndicator=function(){var H=this.getHeader(),$,q,v,O;if(o(H)){$=this.getHeader()._getCollapseButton().getDomRef();q=$.getBoundingClientRect().height;v=this.$wrapper[0].getBoundingClientRect().height;O=$.offsetTop+q-v;this._setScrollPosition(O);}};n.prototype._hasVisibleTitleAndHeader=function(){var t=this.getTitle();return o(t)&&t.getVisible()&&this._hasVisibleHeader();};n.prototype._hasVisibleHeader=function(){var H=this.getHeader();return o(H)&&H.getVisible()&&o(H.getContent());};n.prototype._getHeight=function(q){var $;if(!(q instanceof C)){return 0;}$=q.getDomRef();return $?$.getBoundingClientRect().height:0;};n.prototype._getWidth=function(q){return!(q instanceof C)?0:q.$().outerWidth()||0;};n.prototype._getTitleAreaHeight=function(){return o(this.$titleArea)?this.$titleArea.outerHeight()||0:0;};n.prototype._getTitleHeight=function(){return this._getHeight(this.getTitle());};n.prototype._getHeaderHeight=function(){return this._getHeight(this.getHeader());};n.prototype._preserveHeaderStateOnScroll=function(){return this.getPreserveHeaderStateOnScroll()&&!this._headerBiggerThanAllowedHeight;};n.prototype._getScrollBar=function(){if(!o(this.getAggregation("_scrollBar"))){var v=new S(this.getId()+"-vertSB",{scrollPosition:0,scroll:this._onScrollBarScroll.bind(this)});this.setAggregation("_scrollBar",v,true);}return this.getAggregation("_scrollBar");};n.prototype._cacheDomElements=function(){var F=this.getFooter();if(o(F)){this.$footer=F.$();this.$footerWrapper=this.$("footerWrapper");}this.$wrapper=this.$("contentWrapper");this.$contentFitContainer=this.$("contentFitContainer");this.$titleArea=this.$("header");this.$stickyPlaceholder=this.$("stickyPlaceholder");this._cacheTitleDom();this._cacheHeaderDom();};n.prototype._cacheTitleDom=function(){var t=this.getTitle();if(o(t)){this.$title=t.$();}};n.prototype._cacheHeaderDom=function(){var H=this.getHeader();if(o(H)){this.$header=H.$();}};n.prototype._adjustSnap=function(){var q,I,r,s,t,u,$=this.$();if(!o($)){return;}if(!p($[0])){return;}q=this.getHeader();I=!this.getHeaderExpanded();if(!q||!I){return;}r=!this._preserveHeaderStateOnScroll()&&this._canSnapHeaderOnScroll();s=I&&q.$().hasClass("sapFDynamicPageHeaderHidden");if(r&&s){this._toggleHeaderVisibility(true);this._moveHeaderToContentArea(true);return;}if(!r&&!s){this._moveHeaderToTitleArea(true);this._toggleHeaderVisibility(false);return;}if(r){t=this._getScrollPosition();u=this._getSnappingHeight();if(t<u){this._setScrollPosition(u);}}};n.prototype.ontouchmove=function(E){E.setMarked();};n.prototype._onChildControlAfterRendering=function(E){var s=E.srcControl;if(s instanceof e){this._cacheTitleDom();this._deRegisterResizeHandler(n.RESIZE_HANDLER_ID.TITLE);this._registerResizeHandler(n.RESIZE_HANDLER_ID.TITLE,this.$title[0],this._onChildControlsHeightChange.bind(this));}else if(s instanceof f&&s.getDomRef()!==this.$header.get(0)){this._cacheHeaderDom();this._deRegisterResizeHandler(n.RESIZE_HANDLER_ID.HEADER);this._registerResizeHandler(n.RESIZE_HANDLER_ID.HEADER,this.$header[0],this._onChildControlsHeightChange.bind(this));}setTimeout(this._updateScrollBar.bind(this),0);};n.prototype._onChildControlsHeightChange=function(E){var N=this._needsVerticalScrollBar(),H=this.getHeader(),q,O;if(N){this._updateFitContainer(N);}this._adjustSnap();if(!this._bExpandingWithAClick){this._updateScrollBar();}this._bExpandingWithAClick=false;if(H&&E.target.id===H.getId()){q=E.size.height;O=E.oldSize.height;this._updateHeaderVisualState(q!==O);this._adaptScrollPositionOnHeaderChange(q,O);}};n.prototype._onResize=function(E){var q=this.getTitle(),r=E.size.width,s=E.size.height,H=s!==E.oldSize.height;this._updateHeaderVisualState(H,s);if(o(q)){q._onResize(r);}this._adjustSnap();this._updateScrollBar();this._updateMedia(r);};n.prototype._onWrapperScroll=function(E){var s=Math.max(E.target.scrollTop,0);if(D.system.desktop){if(this.allowCustomScroll===true){this.allowCustomScroll=false;return;}this.allowInnerDiv=true;this._getScrollBar().setScrollPosition(s);this.toggleStyleClass("sapFDynamicPageWithScroll",this._needsVerticalScrollBar());}};n.prototype._toggleHeaderOnScroll=function(){this._adjustStickyContent();if(this._bSuppressToggleHeaderOnce){this._bSuppressToggleHeaderOnce=false;return;}if(D.system.desktop&&this._bExpandingWithAClick){return;}if(this._preserveHeaderStateOnScroll()){return;}if(this._shouldSnapOnScroll()){this._snapHeader(true,true);}else if(this._shouldExpandOnScroll()){this._expandHeader(false,true);this._toggleHeaderVisibility(true);}else if(!this._bPinned&&this._bHeaderInTitleArea){var q=(this._getScrollPosition()>=this._getSnappingHeight());this._moveHeaderToContentArea(q);}};n.prototype._adjustStickyContent=function(){if(!this._oStickySubheader){return;}var q,s=this._shouldStickStickyContent(),r,t=this.getStickySubheaderProvider();if(s===this._bStickySubheaderInTitleArea){return;}r=a.byId(t);if(!o(r)){return;}q=document.activeElement;r._setStickySubheaderSticked(s);if(s){this._oStickySubheader.$().appendTo(this.$stickyPlaceholder);}else{r._returnStickyContent();}q.focus();this._bStickySubheaderInTitleArea=s;};n.prototype._onScrollBarScroll=function(){if(this.allowInnerDiv===true){this.allowInnerDiv=false;return;}this.allowCustomScroll=true;this._setScrollPosition(this._getScrollBar().getScrollPosition());};n.prototype._adaptScrollPositionOnHeaderChange=function(N,O){var H=N-O,q=this.getHeader();if(H&&(!this.getHeaderExpanded()&&(q.$().css("visibility")!=="hidden"))&&!this._bHeaderInTitleArea&&this._needsVerticalScrollBar()){this._setScrollPosition(this._getScrollPosition()+H);}};n.prototype._onTitlePress=function(){if(this.getToggleHeaderOnTitleClick()&&this._hasVisibleTitleAndHeader()){this._titleExpandCollapseWhenAllowed(true);this.getTitle()._focus();}};n.prototype._onExpandHeaderVisualIndicatorPress=function(){this._onTitlePress();if(this._headerBiggerThanAllowedToBeExpandedInTitleArea()){this._scrollBellowCollapseVisualIndicator();}this._focusCollapseVisualIndicator();};n.prototype._onCollapseHeaderVisualIndicatorPress=function(){this._onTitlePress();this._focusExpandVisualIndicator();};n.prototype._onVisualIndicatorMouseOver=function(){var $=this.$();if(o($)){$.addClass("sapFDynamicPageTitleForceHovered");}};n.prototype._onVisualIndicatorMouseOut=function(){var $=this.$();if(o($)){$.removeClass("sapFDynamicPageTitleForceHovered");}};n.prototype._onTitleMouseOver=n.prototype._onVisualIndicatorMouseOver;n.prototype._onTitleMouseOut=n.prototype._onVisualIndicatorMouseOut;n.prototype._titleExpandCollapseWhenAllowed=function(u){var q;if(this._bPinned&&!u){return this;}if(this._preserveHeaderStateOnScroll()||!this._canSnapHeaderOnScroll()||!this.getHeader()){if(!this.getHeaderExpanded()){this._expandHeader(false,u);this._toggleHeaderVisibility(true,u);}else{this._snapHeader(false,u);this._toggleHeaderVisibility(false,u);}}else if(!this.getHeaderExpanded()){q=!this._headerBiggerThanAllowedToBeExpandedInTitleArea();this._bExpandingWithAClick=true;this._expandHeader(q,u);this.getHeader().$().removeClass("sapFDynamicPageHeaderHidden");if(!q){this._setScrollPosition(0);}this._bExpandingWithAClick=false;}else{var r=this._bHeaderInTitleArea;this._snapHeader(r,u);if(!r){this._setScrollPosition(this._getSnappingHeight()+this._iHeaderContentPaddingBottom);}}};n.prototype._onPinUnpinButtonPress=function(){if(this._bPinned){this._unPin();}else{this._pin();this._restorePinButtonFocus();}};n.prototype._attachResizeHandlers=function(){var q=this._onChildControlsHeightChange.bind(this);this._registerResizeHandler(n.RESIZE_HANDLER_ID.PAGE,this,this._onResize.bind(this));if(o(this.$title)){this._registerResizeHandler(n.RESIZE_HANDLER_ID.TITLE,this.$title[0],q);}if(o(this.$header)){this._registerResizeHandler(n.RESIZE_HANDLER_ID.HEADER,this.$header[0],q);}if(o(this.$contentFitContainer)){this._registerResizeHandler(n.RESIZE_HANDLER_ID.CONTENT,this.$contentFitContainer[0],q);}};n.prototype._registerResizeHandler=function(H,O,q){if(!this[H]){this[H]=R.register(O,q);}};n.prototype._detachResizeHandlers=function(){this._deRegisterResizeHandler(n.RESIZE_HANDLER_ID.PAGE);this._deRegisterResizeHandler(n.RESIZE_HANDLER_ID.TITLE);this._deRegisterResizeHandler(n.RESIZE_HANDLER_ID.HEADER);this._deRegisterResizeHandler(n.RESIZE_HANDLER_ID.CONTENT);};n.prototype._deRegisterResizeHandler=function(H){if(this[H]){R.deregister(this[H]);this[H]=null;}};n.prototype._attachPageChildrenAfterRenderingDelegates=function(){var t=this.getTitle(),H=this.getHeader(),q=this.getContent(),r={onAfterRendering:this._onChildControlAfterRendering.bind(this)};if(o(t)){t.addEventDelegate(r);}if(o(q)){q.addEventDelegate(r);}if(o(H)){H.addEventDelegate(r);}};n.prototype._attachTitlePressHandler=function(){var t=this.getTitle();if(o(t)&&!this._bAlreadyAttachedTitlePressHandler){t.attachEvent(n.EVENTS.TITLE_PRESS,this._onTitlePress,this);this._bAlreadyAttachedTitlePressHandler=true;}};n.prototype._attachPinPressHandler=function(){var H=this.getHeader();if(o(H)&&!this._bAlreadyAttachedPinPressHandler){H.attachEvent(n.EVENTS.PIN_UNPIN_PRESS,this._onPinUnpinButtonPress,this);this._bAlreadyAttachedPinPressHandler=true;}};n.prototype._attachStickyHeaderObserver=function(){var H=this.getHeader();if(o(H)&&!this._bAlreadyAttachedStickyHeaderObserver){if(!this._oStickyHeaderObserver){this._oStickyHeaderObserver=new M(this._adjustStickyContent.bind(this));}this._oStickyHeaderObserver.observe(H,{properties:["visible"]});this._bAlreadyAttachedStickyHeaderObserver=true;}};n.prototype._attachHeaderObserver=function(){var H=this.getHeader();if(o(H)&&!this._bAlreadyAttachedHeaderObserver){if(!this._oHeaderObserver){this._oHeaderObserver=new M(this._updateToggleHeaderVisualIndicators.bind(this));}this._oHeaderObserver.observe(H,{aggregations:["content"]});this._bAlreadyAttachedHeaderObserver=true;}};n.prototype._attachVisualIndicatorsPressHandlers=function(){var t=this.getTitle(),H=this.getHeader();if(o(t)&&!this._bAlreadyAttachedTitleIndicatorPressHandler){t.attachEvent(n.EVENTS.TITLE_VISUAL_INDICATOR_PRESS,this._onExpandHeaderVisualIndicatorPress,this);this._bAlreadyAttachedTitleIndicatorPressHandler=true;}if(o(H)&&!this._bAlreadyAttachedHeaderIndicatorPressHandler){H.attachEvent(n.EVENTS.HEADER_VISUAL_INDICATOR_PRESS,this._onCollapseHeaderVisualIndicatorPress,this);this._bAlreadyAttachedHeaderIndicatorPressHandler=true;}};n.prototype._addStickySubheaderAfterRenderingDelegate=function(){var s,q=this.getStickySubheaderProvider(),I;s=a.byId(q);if(o(s)&&!this._bAlreadyAddedStickySubheaderAfterRenderingDelegate){I=s.getMetadata().getInterfaces().indexOf("sap.f.IDynamicPageStickyContent")!==-1;if(I){this._oStickySubheader=s._getStickyContent();this._oStickySubheader.addEventDelegate(this._oSubHeaderAfterRenderingDelegate,this);this._bAlreadyAddedStickySubheaderAfterRenderingDelegate=true;this._attachStickyHeaderObserver();}}};n.prototype._attachVisualIndicatorMouseOverHandlers=function(){var H=this.getHeader();if(o(H)&&!this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler){H.attachEvent(n.EVENTS.VISUAL_INDICATOR_MOUSE_OVER,this._onVisualIndicatorMouseOver,this);H.attachEvent(n.EVENTS.VISUAL_INDICATOR_MOUSE_OUT,this._onVisualIndicatorMouseOut,this);this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler=true;}};n.prototype._attachTitleMouseOverHandlers=function(){var t=this.getTitle();if(o(t)&&!this._bAlreadyAttachedTitleMouseOverOutHandler){t.attachEvent(n.EVENTS.TITLE_MOUSE_OVER,this._onTitleMouseOver,this);t.attachEvent(n.EVENTS.TITLE_MOUSE_OUT,this._onTitleMouseOut,this);this._bAlreadyAttachedTitleMouseOverOutHandler=true;}};n.prototype._attachScrollHandler=function(){this._onWrapperScrollReference=this._onWrapperScroll.bind(this);this._toggleHeaderOnScrollReference=this._toggleHeaderOnScroll.bind(this);this.$wrapper.on("scroll",this._onWrapperScrollReference);this.$wrapper.on("scroll",this._toggleHeaderOnScrollReference);};n.prototype._toggleAdditionalNavigationClass=function(){var s=this._bStickySubheaderProviderExists();this.toggleStyleClass(n.NAVIGATION_CLASS_NAME,s);};n.prototype._bStickySubheaderProviderExists=function(){var s=a.byId(this.getStickySubheaderProvider());return!!s&&s.isA("sap.f.IDynamicPageStickyContent");};n.prototype._detachScrollHandler=function(){if(this.$wrapper){this.$wrapper.off("scroll",this._onWrapperScrollReference);this.$wrapper.off("scroll",this._toggleHeaderOnScrollReference);}};n.prototype._formatLandmarkInfo=function(q,s){if(q){var r=q["get"+s+"Role"]()||"",t=q["get"+s+"Label"]()||"";if(r===A.None){r='';}return{role:r.toLowerCase(),label:t};}return{};};n.prototype._getHeaderTag=function(q){if(q&&q.getHeaderRole()!==A.None){return n.DIV;}return n.HEADER;};n.prototype._getFooterTag=function(q){if(q&&q.getFooterRole()!==A.None){return n.DIV;}return n.FOOTER;};return n;});
