//@ui5-bundle sap/f/library-preload.js
/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/f/Avatar',["sap/m/Avatar","sap/m/AvatarRenderer","./library"],function(M,A){"use strict";
var a=M.extend("sap.f.Avatar",{
metadata:{library:"sap.f",properties:{},designtime:"sap/f/designtime/Avatar.designtime"},
renderer:A
});
a.prototype._getDefaultTooltip=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.f").getText("AVATAR_TOOLTIP");};
return a;});
sap.ui.predefine('sap/f/AvatarGroup',["./library","sap/ui/core/Control","sap/ui/core/delegate/ItemNavigation","sap/ui/dom/units/Rem","./AvatarGroupRenderer","sap/m/Button","sap/m/library","sap/ui/core/ResizeHandler","sap/ui/events/KeyCodes","sap/ui/core/Core"],function(l,C,I,R,A,B,L,a,K,b){"use strict";var c=l.AvatarGroupType;var d=L.AvatarColor;var e=L.AvatarSize;var f={XS:2,S:3,M:4,L:5,XL:7};var g={XS:0.75,S:1.25,M:1.625,L:2,XL:2.75};var h={XS:0.0625,S:0.125,M:0.125,L:0.125,XL:0.25};
var i=C.extend("sap.f.AvatarGroup",{metadata:{library:"sap.f",properties:{groupType:{type:"sap.f.AvatarGroupType",group:"Appearance",defaultValue:c.Group},avatarDisplaySize:{type:"sap.m.AvatarSize",group:"Appearance",defaultValue:e.S}},defaultAggregation:"items",aggregations:{items:{type:'sap.f.AvatarGroupItem',multiple:true}},events:{press:{parameters:{groupType:{type:"string"},overflowButtonPressed:{type:"boolean"},avatarsDisplayed:{type:"int"}}}}}});
i.prototype.init=function(){this._oShowMoreButton=new B({});this._oShowMoreButton.addStyleClass("sapFAvatarGroupMoreButton");this._bFirstRendering=true;this._onResizeRef=this._onResize.bind(this);this._iCurrentAvatarColorNumber=1;this._bShowMoreButton=false;};
i.prototype.exit=function(){this._detachResizeHandlers();if(this._oItemNavigation){this.removeEventDelegate(this._oItemNavigation);this._oItemNavigation.destroy();this._oItemNavigation=null;}this._oShowMoreButton.destroy();this._oShowMoreButton=null;};
i.prototype.onBeforeRendering=function(){if(this._bFirstRendering){this._iAvatarsToShow=this.getItems().length;this._bFirstRendering=false;}};
i.prototype.onAfterRendering=function(){var D,j=[];if(!this._oItemNavigation){this._oItemNavigation=new I(null,null);this._oItemNavigation.setDisabledModifiers({sapnext:["alt","meta"],sapprevious:["alt","meta"]});this.addEventDelegate(this._oItemNavigation);}D=this.getDomRef();this._oItemNavigation.setRootDomRef(D);if(this.getGroupType()===c.Individual){this.getItems().forEach(function(o){j.push(o.getDomRef());});this._oItemNavigation.setItemDomRefs(j);}this._detachResizeHandlers();this._attachResizeHandlers();if(b.isThemeApplied()){this._onResize();}if(this._shouldShowMoreButton()){this._oShowMoreButton.$().attr("role","button");if(this.getGroupType()===c.Group){this._oShowMoreButton.$().attr("tabindex","-1");}else{this._oShowMoreButton.$().attr("aria-label",this._getResourceBundle().getText("AVATARGROUP_POPUP"));}}this._updateAccState();};
i.prototype.onThemeChanged=function(){if(!this.getDomRef()){return;}this._onResize();};
i.prototype._getResourceBundle=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.f");};
i.prototype._updateAccState=function(){var r=this._getResourceBundle(),s=r.getText("AVATARGROUP_NUMBER_OF_AVATARS",[this._iAvatarsToShow,(this.getItems().length-this._iAvatarsToShow)]),p=r.getText("AVATARGROUP_POPUP");if(this.getGroupType()===c.Group){this.$().attr("aria-label",p+" "+s);}};
i.prototype._attachResizeHandlers=function(){this._iResizeHandlerId=a.register(this,this._onResizeRef);};
i.prototype._detachResizeHandlers=function(){if(this._iResizeHandlerId){a.deregister(this._iResizeHandlerId);this._iResizeHandlerId=null;}};
i.prototype.setGroupType=function(v){this.getItems().forEach(function(o){o._setGroupType(v);});return this.setProperty("groupType",v);};
i.prototype.addItem=function(o){o._setDisplaySize(this.getAvatarDisplaySize());o._setAvatarColor(d["Accent"+this._iCurrentAvatarColorNumber]);o._setGroupType(this.getGroupType());this._iAvatarsToShow=this.getItems().length;this._iCurrentAvatarColorNumber++;if(this._iCurrentAvatarColorNumber>10){this._iCurrentAvatarColorNumber=1;}return this.addAggregation("items",o);};
i.prototype.setAvatarDisplaySize=function(v){var o=this.getAvatarDisplaySize();this._oShowMoreButton.removeStyleClass("sapFAvatarGroupMoreButton"+o);this._oShowMoreButton.addStyleClass("sapFAvatarGroupMoreButton"+v);if(o===v){return this;}this.getItems().forEach(function(j){j._setDisplaySize(v);});return this.setProperty("avatarDisplaySize",v);};
i.prototype.ontap=function(E){var o=E.srcControl;this.firePress({groupType:this.getGroupType(),eventSource:o,overflowButtonPressed:o===this._oShowMoreButton,avatarsDisplayed:this._iAvatarsToShow});};
i.prototype.onsapspace=function(E){this.ontap(E);};
i.prototype.onsapenter=function(E){this.ontap(E);};
i.prototype.onkeyup=function(E){if(E.shiftKey&&E.keyCode==K.ENTER||E.shiftKey&&E.keyCode==K.SPACE){E.preventDefault();}};
i.prototype._getAvatarMargin=function(s){var G=this.getGroupType();if(G===c.Group){return g[s];}else{return h[s];}};
i.prototype._getAvatarNetWidth=function(j,k){var G=this.getGroupType();if(G===c.Group){return j-k;}else{return j+k;}};
i.prototype._getAvatarsToShow=function(w,j,k){var r=R.toPx(1),m=w-(j*r),n=Math.floor(m/(k*r));return n+1;};
i.prototype._adjustAvatarsToShow=function(j){if(j-this._iAvatarsToShow>99){this._iAvatarsToShow-=2;}else{this._iAvatarsToShow--;}};
i.prototype._getWidth=function(){return Math.ceil(this.$().width());};
i.prototype._onResize=function(){var w=this._getWidth(),j=this.getItems(),k=j.length,s=this.getAvatarDisplaySize(),m=f[s],n=this._getAvatarMargin(s),o=this._getAvatarNetWidth(m,n),r=this.$().children(".sapFAvatarGroupItem").length;this._iAvatarsToShow=this._getAvatarsToShow(w,m,o);if(k>this._iAvatarsToShow&&k>0){this._bShowMoreButton=true;this._bAutoWidth=false;this._adjustAvatarsToShow(k);if(r!=this._iAvatarsToShow){this._oShowMoreButton.setText("+"+(k-this._iAvatarsToShow));this.invalidate();}}else{this._bAutoWidth=true;this.getDomRef().style.width="auto";if(this._bShowMoreButton){this._bShowMoreButton=false;this.invalidate();}}};
i.prototype._shouldShowMoreButton=function(){return this._bShowMoreButton;};
return i;});
sap.ui.predefine('sap/f/AvatarGroupItem',["./library","sap/ui/base/ManagedObject","sap/ui/core/Control","./Avatar","./AvatarGroupItemRenderer"],function(l,M,C,A,a){"use strict";
var b=C.extend("sap.f.AvatarGroupItem",{metadata:{library:"sap.f",properties:{src:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},initials:{type:"string",group:"Data",defaultValue:null},fallbackIcon:{type:"string",group:"Data",defaultValue:null}}}});
b.prototype.onBeforeRendering=function(){this._getAvatar();};
b.prototype.destroy=function(){if(this._oAvatar){this._oAvatar.destroy();this._oAvatar=null;}if(this._oPopover){this._oPopover.destroy();this._oPopover=null;}M.prototype.destroy.apply(this);};
b.prototype.setSrc=function(v){if(this.getSrc()===v){return this;}this._getAvatar().setSrc(v);return this.setProperty("src",v);};
b.prototype.setInitials=function(v){if(this.getInitials()===v){return this;}this._getAvatar().setInitials(v);return this.setProperty("initials",v);};
b.prototype.setFallbackIcon=function(v){if(this.getFallbackIcon()===v){return this;}this._getAvatar().setFallbackIcon(v);return this.setProperty("fallbackIcon",v);};
b.prototype.getAvatarColor=function(){return this._sAvatarColor;};
b.prototype._setGroupType=function(v){this._sGroupType=v;this.invalidate();};
b.prototype._getGroupType=function(){return this._sGroupType;};
b.prototype._setAvatarColor=function(v){this._sAvatarColor=v;this._getAvatar().setBackgroundColor(v);};
b.prototype._setDisplaySize=function(v){this._sAvatarDisplaySize=v;this._getAvatar().setDisplaySize(v);};
b.prototype._getDisplaySize=function(){return this._sAvatarDisplaySize;};
b.prototype._getAvatar=function(){if(!this._oAvatar){this._oAvatar=new A({src:this.getSrc(),initials:this.getInitials(),fallbackIcon:this.getFallbackIcon(),backgroundColor:this.getAvatarColor(),showBorder:true,displaySize:this._getDisplaySize()});}return this._oAvatar;};
return b;});
sap.ui.predefine('sap/f/AvatarGroupItemRenderer',["sap/f/library"],function(l){"use strict";var A={apiVersion:2};
A.render=function(r,a){r.openStart("div",a).class("sapFAvatarGroupItem").class("sapFAvatarGroupItem"+a._sAvatarDisplaySize);if(a._getGroupType()==="Individual"){r.attr("tabindex",0);}r.openEnd();r.renderControl(a._getAvatar());r.close("div");};
return A;},true);
sap.ui.predefine('sap/f/AvatarGroupRenderer',["sap/f/library"],function(l){"use strict";var A={apiVersion:2};
A.render=function(r,a){var s="sapFAvatarGroup",g=a.getGroupType(),b=s+g,I=a.getItems(),S=a._shouldShowMoreButton();r.openStart("div",a).class(s).class(b).class(s+a.getAvatarDisplaySize());if(S){r.class("sapFAvatarGroupShowMore");}if(a._bAutoWidth){r.style("width","auto");}if(g==="Group"){r.attr("role","button");}r.openEnd();for(var i=0;i<a._iAvatarsToShow;i++){r.renderControl(I[i]);}if(S){r.renderControl(a._oShowMoreButton);}r.close("div");};
return A;},true);
sap.ui.predefine('sap/f/CalendarInCard',['sap/m/Button','sap/m/Toolbar','sap/ui/core/Core','sap/ui/core/date/UniversalDate','sap/ui/core/format/DateFormat','sap/ui/core/IconPool','sap/ui/core/InvisibleText','sap/ui/dom/containsOrEquals','sap/ui/unified/Calendar','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/calendar/CalendarUtils','./CalendarInCardRenderer'],function(B,T,C,U,D,I,a,c,b,d,e,f){"use strict";
var g=b.extend("sap.f.CalendarInCard",{metadata:{library:"sap.f"}});
g.prototype.onBeforeRendering=function(){var m=this.getAggregation("month"),F=this._getFocusedDate().toLocalJSDate();m[0].displayDate(F);this._iSize=0;switch(this._iMode){case 0:this._oPickerBtn.setText(this._formatPickerText(F));break;case 1:this._oPickerBtn.setText(this._formatMonthPickerText());break;case 2:case 3:this._oPickerBtn.setText(this._formatYearPickerText());break;}this._updateTodayButtonState();};
g.prototype.onAfterRendering=function(E){};
g.prototype.onsaptabnext=function(E){if(c(this.getDomRef("content"),E.target)){if(this._oTodayBtn.getEnabled()){this._oTodayBtn.focus();}else{this._oPickerBtn.focus();}E.preventDefault();}else if(E.target.id===this._oTodayBtn.getId()){if(this._oPickerBtn.getVisible()){this._oPickerBtn.focus();E.preventDefault();}else{this._clearTabindex0();}}else if(E.target.id===this._oPickerBtn.getId()){this._clearTabindex0();}};
g.prototype.onsaptabprevious=function(E){if(c(this.getDomRef("content"),E.target)){this._clearTabindex0();}else if(E.target.id===this._oTodayBtn.getId()){this._moveFocusToCalContent();E.preventDefault();}else if(E.target.id===this._oPickerBtn.getId()){if(this._oTodayBtn.getEnabled()){this._oTodayBtn.focus();}else{this._moveFocusToCalContent();}E.preventDefault();}};
g.prototype._initializeHeader=function(){var n=this.getId()+"--Head",r=C.getLibraryResourceBundle("sap.f"),p=new B(n+"-PrevBtn",{icon:I.getIconURI('slim-arrow-left'),tooltip:r.getText("CALENDAR_BTN_PREV"),type:"Transparent",press:function(){this._handlePrevious();}.bind(this)}),N=new B({icon:I.getIconURI('slim-arrow-right'),tooltip:r.getText("CALENDAR_BTN_NEXT"),type:"Transparent",press:function(){this._handleNext();}.bind(this)}),h=new T(n,{ariaLabelledBy:a.getStaticId("sap.f","CALENDAR_NAVIGATION")});this._oTodayBtn=new B({text:r.getText("CALENDAR_TODAY"),ariaLabelledBy:a.getStaticId("sap.f","CALENDAR_NAVIGATE_TO_TODAY"),type:"Transparent",press:function(){this._handleTodayPress();}.bind(this)});this._oPickerBtn=new B({type:"Transparent",ariaLabelledBy:a.getStaticId("sap.f","CALENDAR_SELECT_RANGE"),press:function(){this._handlePickerButtonPress();}.bind(this)});h.addContent(p).addContent(this._oTodayBtn).addContent(N).addContent(this._oPickerBtn);this.setAggregation("header",h);};
g.prototype._handlePickerButtonPress=function(){switch(this._iMode){case 0:this._showMonthPicker();this._oPickerBtn.getDomRef().focus();break;case 1:this._showYearPicker();this._oPickerBtn.getDomRef().focus();break;case 2:this._showYearRangePicker();break;}};
g.prototype._handleTodayPress=function(){var o=new Date(),h=d.fromLocalJSDate(o);this.getAggregation("month")[0].setDate(o);this.getSelectedDates()[0].setStartDate(o);this._setFocusedDate(h);if(this._iMode===3){o.setFullYear(o.getFullYear()-(this._getYearRangePicker().getRangeSize()/2));this._getYearRangePicker().setDate(o);this._oPickerBtn.setText(this._formatYearPickerText());}else if(this._iMode===2){this._getYearPicker().setDate(o);this._oPickerBtn.setText(this._formatYearPickerText());}else if(this._iMode===1){this.displayDate(o);this._getMonthPicker()._iYear=o.getFullYear();this._getMonthPicker().setMonth(o.getMonth());this._oPickerBtn.setText(this._formatMonthPickerText());}else{this._oPickerBtn.setText(this._formatPickerText());}this._updateTodayButtonState();this.fireSelect();};
g.prototype._formatPickerText=function(F){var o=F?F:this.getSelectedDates()[0].getStartDate(),r=C.getConfiguration().getRTL(),h=D.getDateInstance({format:"yMMMM"}),s=h.format(o),R,E;if(!r){R=s;if(E){R+=" - "+E;}}else{if(E){R=E+" - "+s;}else{R=s;}}return R;};
g.prototype._formatYearPickerText=function(){var i=this._getYearPicker().getDate().getFullYear(),y=this._getYearPicker().getYears(),s=i-Math.floor(y/2),E=i+y/2-1;return""+s+" - "+E;};
g.prototype._formatMonthPickerText=function(){return D.getDateInstance({format:"y"}).format(this.getStartDate());};
g.prototype._showMonthPicker=function(s){var o=this._getFocusedDate(),m=this._getMonthPicker();this._iMode===2&&this._hideYearPicker(true);m.setVisible(true);this._renderPicker(m);m._setYear(o.getYear());this._showOverlay();if(!s){m.setMonth(o.getMonth());this._setDisabledMonths(o.getYear(),m);}this._iMode=1;this._togglePrevNext(o,false);this._oPickerBtn.setText(this._formatMonthPickerText());};
g.prototype._showYearPicker=function(){var o=this._getFocusedDate(),y=this._getYearPicker(),m,h;this._iMode===1&&this._hideMonthPicker(true);y.getDomRef()?y.$().css("display",""):this._renderPicker(y);this._showOverlay();if(_.call(this)==1){m=this.getAggregation("month")[0];h=m.$("days").find(".sapUiCalItem");if(h.length==28){y.$().addClass("sapUiCalYearNoTop");}else{y.$().removeClass("sapUiCalYearNoTop");}}this._togglePrevNexYearPicker();this._iMode=2;y.setDate(o.toLocalJSDate());this._oPickerBtn.setText(this._formatYearPickerText());};
g.prototype._showYearRangePicker=function(){this._hideYearPicker();b.prototype._showYearRangePicker.apply(this,arguments);this._oPickerBtn.setVisible(false);};
g.prototype._selectMonth=function(){b.prototype._selectMonth.apply(this,arguments);this.getSelectedDates()[0].setStartDate(this._getFocusedDate().toLocalJSDate());this._oPickerBtn.setText(this._formatPickerText());this._updateTodayButtonState();};
g.prototype._selectYear=function(){b.prototype._selectYear.apply(this,arguments);this.getSelectedDates()[0].setStartDate(this._getFocusedDate().toLocalJSDate());this._oPickerBtn.setText(this._formatMonthPickerText());this._showMonthPicker();this._updateTodayButtonState();};
g.prototype._selectYearRange=function(){var y=this.getAggregation("yearRangePicker"),r=y.getRangeSize(),p=this.getPrimaryCalendarType(),s=d.fromLocalJSDate(y.getDate(),p),F=this._getFocusedDate();s.setMonth(F.getMonth(),F.getDate());s.setYear(s.getYear()+Math.floor(r/2));this.getSelectedDates()[0].setStartDate(s.toLocalJSDate());F.setYear(s.getYear());this._setFocusedDate(F);this._hideYearRangePicker();this._showYearPicker();this._oPickerBtn.setVisible(true).setText(this._formatYearPickerText());this._updateTodayButtonState();};
g.prototype._hideYearRangePicker=function(){b.prototype._hideYearRangePicker.apply(this,arguments);this._renderMonth();};
g.prototype._handlePrevious=function(){b.prototype._handlePrevious.apply(this,arguments);this._handleArrowNavigation(1);};
g.prototype._handleNext=function(){b.prototype._handleNext.apply(this,arguments);this._handleArrowNavigation(-1);};
g.prototype._handleArrowNavigation=function(i){var m,y,Y;if(this._iMode===3){Y=this._getYearRangePicker();Y.getDate().setFullYear(Y.getDate().getFullYear()+(i*Y.getYears()));this._oPickerBtn.setText(this._formatYearPickerText());}else if(this._iMode===2){y=this._getYearPicker();y.getDate().setFullYear(y.getDate().getFullYear()+(i*y.getYears()));this._oPickerBtn.setText(this._formatYearPickerText());}else if(this._iMode===1){m=this._getMonthPicker();this._getFocusedDate().setYear(m._iYear);this.getAggregation("month")[0].getDate().setYear(m._iYear);this._oPickerBtn.setText(this._formatMonthPickerText());}else{this._oPickerBtn.setText(this._formatPickerText(this._getFocusedDate().toLocalJSDate()));}this._updateTodayButtonState();};
g.prototype._dateMatchesVisibleRange=function(){var o=d.fromLocalJSDate(new Date()),s,i,y,Y,S;switch(this._iMode){case 0:s=this.getSelectedDates().length?this.getSelectedDates()[0].getStartDate():this.getStartDate();i=s.getDate()===o.getDate();return i&&e._isSameMonthAndYear(d.fromLocalJSDate(this.getStartDate()),o);case 1:return e._isSameMonthAndYear(d.fromLocalJSDate(this.getStartDate()),o);case 2:return e._isSameMonthAndYear(d.fromLocalJSDate(this._getYearPicker().getDate()),o);case 3:y=this._getYearRangePicker();Y=y.getDate();S=new Date(Y.getFullYear()+(y.getRangeSize()/2),Y.getMonth(),Y.getDate());return e._isSameMonthAndYear(d.fromLocalJSDate(S),o);}};
g.prototype._updateTodayButtonState=function(){if(this._oTodayBtn){this._oTodayBtn.setEnabled(!this._dateMatchesVisibleRange());}};
g.prototype._updateHeader=function(){};
g.prototype.onsapescape=function(){this.fireCancel();this._closedPickers();this._oPickerBtn.setVisible(true);this._oPickerBtn.setText(this._formatPickerText());};
g.prototype._updateHeadersButtons=function(){};
g.prototype._togglePrevNext=function(){};
g.prototype._togglePrevNexYearPicker=function(){};
g.prototype._initializeSecondMonthHeader=function(){};
g.prototype._updateHeadersYearPrimaryText=function(){};
g.prototype._updateHeadersYearAdditionalText=function(){};
g.prototype._updateActiveHeaderYearButtonVisibility=function(){};
g.prototype._setHeaderText=function(){};
function _(){return 1;}
return g;});
sap.ui.predefine('sap/f/CalendarInCardRenderer',['sap/ui/core/Renderer','sap/ui/unified/CalendarRenderer'],function(R,C){"use strict";var a=R.extend(C);a.apiVersion=2;
a.render=function(r,c){var i=c.getId(),t=c.getTooltip_AsString(),m=c.getAggregation("month"),w=c.getWidth(),b=sap.ui.getCore().getLibraryResourceBundle("sap.f"),A={labelledby:{value:"",append:false}};r.openStart("div",c);r.class("sapUiCal");if(m.length>1){r.class("sapUiCalMulti");}r.accessibilityState(c,A);if(t){r.attr("title",t);}if(w){r.class("sapUiCalWidth");r.style("width",w);}if(c._getSecondaryCalendarType()){r.class("sapUiCalSecType");}r.openEnd();var h=c.getAggregation("header");r.renderControl(h);r.openStart("div",i+"-content");r.class("sapUiCalContent");r.openEnd();r.renderControl(m[0]);switch(c._iMode){case 1:r.renderControl(c._getMonthPicker());break;case 2:r.renderControl(c._getYearPicker());break;case 3:r.renderControl(c._getYearRangePicker());break;}this.renderCalContentOverlay(r,c,i);r.close("div");if(!c._bSkipCancelButtonRendering){r.openStart("button",i+"-cancel");r.class("sapUiCalCancel");r.attr("tabindex","-1");r.openEnd();r.text(b.getText("CALENDAR_CANCEL"));r.close("button");}r.openStart("div",i+"-end");r.attr("tabindex","0");r.style("position","absolute");r.style("width","0");r.style("height","0");r.style("right","0");r.style("bottom","0");r.openEnd();r.close("div");this.renderCalContentAndArrowsOverlay(r,c,i);r.close("div");};
return a;},true);
sap.ui.predefine('sap/f/Card',["sap/f/library","./CardBase","sap/f/CardRenderer"],function(l,C,a){"use strict";var H=l.cards.HeaderPosition;
var b=C.extend("sap.f.Card",{
metadata:{library:"sap.f",properties:{headerPosition:{type:"sap.f.cards.HeaderPosition",group:"Appearance",defaultValue:H.Top}},aggregations:{header:{type:"sap.f.cards.IHeader",multiple:false},content:{type:"sap.ui.core.Control",multiple:false}}},
renderer:a
});
b.prototype.getCardHeader=function(){return this.getHeader();};
b.prototype.getCardHeaderPosition=function(){return this.getHeaderPosition();};
b.prototype.getCardContent=function(){return this.getContent();};
return b;});
sap.ui.predefine('sap/f/CardBase',["sap/ui/core/Control","sap/f/library","sap/m/library","sap/ui/core/InvisibleText","sap/ui/core/Core","sap/m/BadgeEnabler","sap/f/CardRenderer"],function(C,l,L,I,a,B,b){"use strict";var c=L.BadgeState;var d=3000;
var e=C.extend("sap.f.CardBase",{
metadata:{library:"sap.f",interfaces:["sap.f.ICard","sap.m.IBadge"],properties:{width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"100%"},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"auto"}},aggregations:{}},
renderer:b
});
B.call(e.prototype);
e.prototype.init=function(){this._oRb=a.getLibraryResourceBundle("sap.f");this._ariaContentText=new I({id:this.getId()+"-ariaContentText"});this._ariaContentText.setText(this._oRb.getText("ARIA_LABEL_CARD_CONTENT"));this._ariaText=new I({id:this.getId()+"-ariaText"});this._ariaText.setText(this._oRb.getText("ARIA_ROLEDESCRIPTION_CARD"));this.initBadgeEnablement({accentColor:"AccentColor6"});};
e.prototype.exit=function(){this._oRb=null;if(this._ariaContentText){this._ariaContentText.destroy();this._ariaContentText=null;}if(this._ariaText){this._ariaText.destroy();this._ariaText=null;}};
e.prototype.getCardHeader=function(){return null;};
e.prototype.getCardHeaderPosition=function(){return null;};
e.prototype.getCardContent=function(){return null;};
e.prototype.getFocusDomRef=function(){return this.getCardHeader()?this.getCardHeader().getDomRef():this.getDomRef();};
e.prototype.onmousedown=function(){this._hideBadge();};
e.prototype.onsapenter=function(){this._hideBadge();};
e.prototype.onfocusin=function(){this._startBadgeHiding();};
e.prototype._startBadgeHiding=function(){if(this._iHideBadgeTimeout){return;}this._iHideBadgeTimeout=setTimeout(this._hideBadge.bind(this),d);};
e.prototype._hideBadge=function(){var o=this.getBadgeCustomData();if(o){o.setVisible(false);}this._iHideBadgeTimeout=null;};
e.prototype.onBadgeUpdate=function(v,s,f){var h=this.getCardHeader(),D,A;if(h){D=h.getDomRef();}else{D=this.getDomRef("contentSection");}if(!D){return;}A=D.getAttribute("aria-labelledby")||"";switch(s){case c.Appear:A=f+" "+A;D.setAttribute("aria-labelledby",A);break;case c.Disappear:A=A.replace(f,"").trim();D.setAttribute("aria-labelledby",A);break;}};
e.prototype.getAriaLabelBadgeText=function(){return this.getBadgeCustomData().getValue();};
e.prototype._getAriaLabelledIds=function(){var h=this.getCardHeader(),t=h&&h._getTitle()?h._getTitle().getId():"",A=this.getId()+"-ariaText "+t;return A.trim();};
return e;});
sap.ui.predefine('sap/f/CardRenderer',["sap/f/library"],function(l){"use strict";var H=l.cards.HeaderPosition;var C={apiVersion:2};
C.render=function(r,c){var h=c.getCardHeader(),s=c.getHeight(),b=h&&c.getCardHeaderPosition()===H.Bottom,t=c.getTooltip_AsString(),f=c.getAggregation("_filterBar");r.openStart("div",c).class("sapFCard").style("width",c.getWidth());if(!c.getCardContent()){r.class("sapFCardNoContent");}if(b){r.class("sapFCardBottomHeader");}if(s&&s!=="auto"){r.style("height",s);}if(t){r.attr("title",t);}r.accessibilityState(c,{role:"region",labelledby:{value:c._getAriaLabelledIds(),append:true}});r.openEnd();if(h&&c.getCardHeaderPosition()===H.Top){r.renderControl(h);}if(f){r.openStart("div").class("sapFCardFilterBar").openEnd();r.renderControl(f);r.close("div");}C.renderContentSection(r,c);if(b){r.renderControl(h);}r.renderControl(c._ariaText);r.renderControl(c._ariaContentText);r.close("div");};
C.renderContentSection=function(r,c){var o=c.getCardContent();if(o){r.openStart("div",c.getId()+"-contentSection").class("sapFCardContent").accessibilityState(c,{role:"group",labelledby:{value:c.getId()+"-ariaContentText",append:true}}).openEnd();r.renderControl(o);r.close("div");}};
return C;});
sap.ui.predefine('sap/f/DynamicPage',["./library","sap/ui/core/Control","sap/ui/core/Core","sap/m/ScrollBar","sap/m/library","sap/ui/base/ManagedObjectObserver","sap/ui/core/ResizeHandler","sap/ui/core/Configuration","sap/ui/core/delegate/ScrollEnablement","sap/ui/Device","sap/ui/base/ManagedObject","sap/f/DynamicPageTitle","sap/f/DynamicPageHeader","./DynamicPageRenderer","sap/base/Log","sap/ui/dom/getScrollbarSize","sap/ui/core/theming/Parameters",'sap/ui/dom/units/Rem',"sap/ui/core/library"],function(l,C,a,S,L,M,R,b,c,D,d,e,f,g,h,i,P,j,k){"use strict";var m=L.PageBackgroundDesign;
var n=C.extend("sap.f.DynamicPage",{metadata:{library:"sap.f",properties:{preserveHeaderStateOnScroll:{type:"boolean",group:"Behavior",defaultValue:false},headerExpanded:{type:"boolean",group:"Behavior",defaultValue:true},toggleHeaderOnTitleClick:{type:"boolean",group:"Behavior",defaultValue:true},showFooter:{type:"boolean",group:"Behavior",defaultValue:false},backgroundDesign:{type:"sap.m.PageBackgroundDesign",group:"Appearance",defaultValue:m.Standard},fitContent:{type:"boolean",group:"Behavior",defaultValue:false}},associations:{stickySubheaderProvider:{type:"sap.f.IDynamicPageStickyContent",multiple:false}},aggregations:{title:{type:"sap.f.DynamicPageTitle",multiple:false},header:{type:"sap.f.DynamicPageHeader",multiple:false},content:{type:"sap.ui.core.Control",multiple:false},footer:{type:"sap.m.IBar",multiple:false},landmarkInfo:{type:"sap.f.DynamicPageAccessibleLandmarkInfo",multiple:false},_scrollBar:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},dnd:{draggable:false,droppable:true},designtime:"sap/f/designtime/DynamicPage.designtime"}});
function o(O){if(arguments.length===1){return O&&("length"in O)?O.length>0:!!O;}return Array.prototype.slice.call(arguments).every(function(q){return o(q);});}
function p(E){var q;if(!E){return false;}q=E.getBoundingClientRect();return!!(q.width&&q.height);}
var A=k.AccessibleLandmarkRole;n.HEADER_MAX_ALLOWED_PINNED_PERCENTAGE=0.6;n.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE=0.6;n.HEADER_MAX_ALLOWED_NON_SROLLABLE_ON_MOBILE=0.3;n.BREAK_POINTS={TABLET:1024,PHONE:600};n.EVENTS={TITLE_PRESS:"_titlePress",TITLE_MOUSE_OVER:"_titleMouseOver",TITLE_MOUSE_OUT:"_titleMouseOut",PIN_UNPIN_PRESS:"_pinUnpinPress",VISUAL_INDICATOR_MOUSE_OVER:"_visualIndicatorMouseOver",VISUAL_INDICATOR_MOUSE_OUT:"_visualIndicatorMouseOut",HEADER_VISUAL_INDICATOR_PRESS:"_headerVisualIndicatorPress",TITLE_VISUAL_INDICATOR_PRESS:"_titleVisualIndicatorPress"};n.MEDIA={PHONE:"sapFDynamicPage-Std-Phone",TABLET:"sapFDynamicPage-Std-Tablet",DESKTOP:"sapFDynamicPage-Std-Desktop"};n.RESIZE_HANDLER_ID={PAGE:"_sResizeHandlerId",TITLE:"_sTitleResizeHandlerId",HEADER:"_sHeaderResizeHandlerId",CONTENT:"_sContentResizeHandlerId"};n.DIV="div";n.HEADER="header";n.FOOTER="footer";n.SHOW_FOOTER_CLASS_NAME="sapFDynamicPageActualFooterControlShow";n.HIDE_FOOTER_CLASS_NAME="sapFDynamicPageActualFooterControlHide";n.NAVIGATION_CLASS_NAME="sapFDynamicPageNavigation";n.ARIA_ROLE_DESCRIPTION="DYNAMIC_PAGE_ROLE_DESCRIPTION";
n.prototype.init=function(){this._bPinned=false;this._bHeaderInTitleArea=false;this._bExpandingWithAClick=false;this._bSuppressToggleHeaderOnce=false;this._headerBiggerThanAllowedHeight=false;this._oStickySubheader=null;this._bStickySubheaderInTitleArea=false;this._bMSBrowser=D.browser.internet_explorer||D.browser.edge||false;this._oScrollHelper=new c(this,this.getId()+"-content",{horizontal:false,vertical:true});this._oStickyHeaderObserver=null;this._oHeaderObserver=null;this._oSubHeaderAfterRenderingDelegate={onAfterRendering:function(){this._bStickySubheaderInTitleArea=false;this._adjustStickyContent();}};this._setAriaRoleDescription(a.getLibraryResourceBundle("sap.f").getText(n.ARIA_ROLE_DESCRIPTION));this._iHeaderContentPaddingBottom=j.toPx(P.get("_sap_f_DynamicPageHeader_PaddingBottom"));};
n.prototype.onBeforeRendering=function(){if(!this._preserveHeaderStateOnScroll()){this._attachPinPressHandler();}this._attachTitlePressHandler();this._attachVisualIndicatorsPressHandlers();if(D.system.desktop){this._attachVisualIndicatorMouseOverHandlers();this._attachTitleMouseOverHandlers();}this._attachHeaderObserver();this._addStickySubheaderAfterRenderingDelegate();this._detachScrollHandler();this._detachResizeHandlers();this._toggleAdditionalNavigationClass();};
n.prototype.onAfterRendering=function(){var s,q;if(this._preserveHeaderStateOnScroll()){setTimeout(this._overridePreserveHeaderStateOnScroll.bind(this),0);}this._bPinned=false;this._cacheDomElements();this._attachResizeHandlers();this._updateMedia(this._getWidth(this));this._attachScrollHandler();this._updateScrollBar();this._attachPageChildrenAfterRenderingDelegates();this._resetPinButtonState();if(!this.getHeaderExpanded()){this._snapHeader(false);s=this.getHeader()&&!this.getPreserveHeaderStateOnScroll()&&this._canSnapHeaderOnScroll();if(s){q=this._getScrollBar().getScrollPosition();this._setScrollPosition(q?q:this._getSnappingHeight());}else{this._toggleHeaderVisibility(false);this._moveHeaderToTitleArea();}}this._updateToggleHeaderVisualIndicators();this._updateTitleVisualState();};
n.prototype.exit=function(){this._detachResizeHandlers();if(this._oScrollHelper){this._oScrollHelper.destroy();}if(this._oStickyHeaderObserver){this._oStickyHeaderObserver.disconnect();}if(this._oHeaderObserver){this._oHeaderObserver.disconnect();}if(this._oStickySubheader){this._oStickySubheader.removeEventDelegate(this._oSubHeaderAfterRenderingDelegate);}};
n.prototype.setShowFooter=function(s){var r=this.setProperty("showFooter",s,true);this._toggleFooter(s);return r;};
n.prototype.setHeader=function(H){var O=this.getHeader();if(H===O){return this;}if(O){if(this._oStickyHeaderObserver){this._oStickyHeaderObserver.disconnect();}if(this._oHeaderObserver){this._oHeaderObserver.disconnect();}this._deRegisterResizeHandler(n.RESIZE_HANDLER_ID.HEADER);O.detachEvent(n.EVENTS.PIN_UNPIN_PRESS,this._onPinUnpinButtonPress);this._bAlreadyAttachedPinPressHandler=false;O.detachEvent(n.EVENTS.HEADER_VISUAL_INDICATOR_PRESS,this._onCollapseHeaderVisualIndicatorPress);this._bAlreadyAttachedHeaderIndicatorPressHandler=false;O.detachEvent(n.EVENTS.VISUAL_INDICATOR_MOUSE_OVER,this._onVisualIndicatorMouseOver);O.detachEvent(n.EVENTS.VISUAL_INDICATOR_MOUSE_OUT,this._onVisualIndicatorMouseOut);this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler=false;this._bAlreadyAttachedStickyHeaderObserver=false;this._bAlreadyAttachedHeaderObserver=false;}this.setAggregation("header",H);return this;};
n.prototype.setStickySubheaderProvider=function(s){var O,q=this.getStickySubheaderProvider();if(s===q){return this;}O=a.byId(q);if(this._oStickySubheader&&O){O._returnStickyContent();O._setStickySubheaderSticked(false);this._oStickySubheader.removeEventDelegate(this._oSubHeaderAfterRenderingDelegate);this._bAlreadyAddedStickySubheaderAfterRenderingDelegate=false;this._oStickySubheader=null;}this.setAssociation("stickySubheaderProvider",s);return this;};
n.prototype.setHeaderExpanded=function(H){H=this.validateProperty("headerExpanded",H);if(this._bPinned){return this;}if(this.getHeaderExpanded()===H){return this;}if(this.getDomRef()){this._titleExpandCollapseWhenAllowed();}this.setProperty("headerExpanded",H,true);return this;};
n.prototype.setToggleHeaderOnTitleClick=function(t){var H=this.getHeaderExpanded(),r=this.setProperty("toggleHeaderOnTitleClick",t,true);t=this.getProperty("toggleHeaderOnTitleClick");this._updateTitleVisualState();this._updateToggleHeaderVisualIndicators();this._updateARIAStates(H);return r;};
n.prototype.setFitContent=function(F){var r=this.setProperty("fitContent",F,true);if(o(this.$())){this._updateFitContainer();}return r;};
n.prototype.getScrollDelegate=function(){return this._oScrollHelper;};
n.prototype._overridePreserveHeaderStateOnScroll=function(){if(!this._shouldOverridePreserveHeaderStateOnScroll()){this._headerBiggerThanAllowedHeight=false;return;}this._headerBiggerThanAllowedHeight=true;if(this.getHeaderExpanded()){this._moveHeaderToContentArea(true);}else{this._adjustSnap();}this._updateScrollBar();};
n.prototype._shouldOverridePreserveHeaderStateOnScroll=function(){return this._headerBiggerThanAllowedToBeFixed()&&this._preserveHeaderStateOnScroll();};
n.prototype._toggleFooter=function(s){var F=this.getFooter(),u,q;if(!o(this.$())||!o(F)||!o(this.$footerWrapper)){return;}q=a.getConfiguration().getAnimationMode();u=q!==b.AnimationMode.none&&q!==b.AnimationMode.minimal;this._toggleFooterSpacer(s);if(u){this._toggleFooterAnimation(s,F);}else{this.$footerWrapper.toggleClass("sapUiHidden",!s);}this._updateScrollBar();};
n.prototype._toggleFooterAnimation=function(s,F){this.$footerWrapper.on("webkitAnimationEnd animationend",this._onToggleFooterAnimationEnd.bind(this,F));if(s){this.$footerWrapper.removeClass("sapUiHidden");}F.toggleStyleClass(n.SHOW_FOOTER_CLASS_NAME,s);F.toggleStyleClass(n.HIDE_FOOTER_CLASS_NAME,!s);};
n.prototype._onToggleFooterAnimationEnd=function(F){this.$footerWrapper.off("webkitAnimationEnd animationend");if(F.hasStyleClass(n.HIDE_FOOTER_CLASS_NAME)){this.$footerWrapper.addClass("sapUiHidden");F.removeStyleClass(n.HIDE_FOOTER_CLASS_NAME);}else{F.removeStyleClass(n.SHOW_FOOTER_CLASS_NAME);}};
n.prototype._toggleFooterSpacer=function(t){var $=this.$("spacer");if(o($)){$.toggleClass("sapFDynamicPageContentWrapperSpacer",t);}if(o(this.$contentFitContainer)){this.$contentFitContainer.toggleClass("sapFDynamicPageContentFitContainerFooterVisible",t);}};
n.prototype._toggleHeaderInTabChain=function(t){var q=this.getTitle(),r=this.getHeader();if(!o(q)||!o(r)){return;}r.$().css("visibility",t?"visible":"hidden");};
n.prototype._snapHeader=function(q,u){var r=this.getTitle();if(this._bPinned&&!u){h.debug("DynamicPage :: aborted snapping, header is pinned",this);return;}h.debug("DynamicPage :: snapped header",this);if(this._bPinned&&u){this._unPin();this._togglePinButtonPressedState(false);}if(o(r)){r._toggleState(false,u);if(q&&this._bHeaderInTitleArea){this._moveHeaderToContentArea(true);}}if(!o(this.$titleArea)){h.warning("DynamicPage :: couldn't snap header. There's no title.",this);return;}this.setProperty("headerExpanded",false,true);if(this._hasVisibleTitleAndHeader()){this.$titleArea.addClass(D.system.phone&&r.getSnappedTitleOnMobile()?"sapFDynamicPageTitleSnappedTitleOnMobile":"sapFDynamicPageTitleSnapped");this._updateToggleHeaderVisualIndicators();this._togglePinButtonVisibility(false);}this._toggleHeaderInTabChain(false);this._updateARIAStates(false);};
n.prototype._expandHeader=function(q,u){var r=this.getTitle();h.debug("DynamicPage :: expand header",this);if(o(r)){r._toggleState(true,u);if(q){this._moveHeaderToTitleArea(true);}}if(!o(this.$titleArea)){h.warning("DynamicPage :: couldn't expand header. There's no title.",this);return;}this.setProperty("headerExpanded",true,true);if(this._hasVisibleTitleAndHeader()){this.$titleArea.removeClass(D.system.phone&&r.getSnappedTitleOnMobile()?"sapFDynamicPageTitleSnappedTitleOnMobile":"sapFDynamicPageTitleSnapped");this._updateToggleHeaderVisualIndicators();if(!this.getPreserveHeaderStateOnScroll()&&!this._headerBiggerThanAllowedToPin()){this._togglePinButtonVisibility(true);}}this._toggleHeaderInTabChain(true);this._updateARIAStates(true);};
n.prototype._toggleHeaderVisibility=function(s,u){var E=this.getHeaderExpanded(),q=this.getTitle(),r=this.getHeader();if(this._bPinned&&!u){h.debug("DynamicPage :: header toggle aborted, header is pinned",this);return;}if(o(q)){q._toggleState(E);}if(o(r)){r.$().toggleClass("sapFDynamicPageHeaderHidden",!s);this._updateScrollBar();}};
n.prototype._moveHeaderToContentArea=function(O){var q=this.getHeader();if(o(q)){q.$().prependTo(this.$wrapper);this._bHeaderInTitleArea=false;if(O){this._offsetContentOnMoveHeader();}}};
n.prototype._moveHeaderToTitleArea=function(O){var q=this.getHeader();if(o(q)){q.$().prependTo(this.$stickyPlaceholder);this._bHeaderInTitleArea=true;if(O){this._offsetContentOnMoveHeader();}}};
n.prototype._offsetContentOnMoveHeader=function(){var O=Math.ceil(this._getHeaderHeight()),q=this._getScrollPosition(),r=this._getScrollBar().getScrollPosition(),N;if(!O){return;}if(!q&&r){N=this._getScrollBar().getScrollPosition();}else{N=this._bHeaderInTitleArea?q-O:q+O;}N=Math.max(N,0);this._setScrollPosition(N,true);};
n.prototype._pin=function(){var $=this.$();if(this._bPinned){return;}this._bPinned=true;if(!this._bHeaderInTitleArea){this._moveHeaderToTitleArea(true);this._updateScrollBar();}this._updateToggleHeaderVisualIndicators();this._togglePinButtonARIAState(this._bPinned);if(o($)){$.addClass("sapFDynamicPageHeaderPinned");}};
n.prototype._unPin=function(){var $=this.$();if(!this._bPinned){return;}this._bPinned=false;this._updateToggleHeaderVisualIndicators();this._togglePinButtonARIAState(this._bPinned);if(o($)){$.removeClass("sapFDynamicPageHeaderPinned");}};
n.prototype._togglePinButtonVisibility=function(t){var q=this.getHeader();if(o(q)){q._setShowPinBtn(t);}};
n.prototype._togglePinButtonPressedState=function(q){var r=this.getHeader();if(o(r)){r._togglePinButton(q);}};
n.prototype._togglePinButtonARIAState=function(q){var r=this.getHeader();if(o(r)){r._updateARIAPinButtonState(q);}};
n.prototype._resetPinButtonState=function(){if(this._preserveHeaderStateOnScroll()){this._togglePinButtonVisibility(false);}else{this._togglePinButtonPressedState(false);this._togglePinButtonARIAState(false);}};
n.prototype._restorePinButtonFocus=function(){this.getHeader()._focusPinButton();};
n.prototype._getScrollPosition=function(){return o(this.$wrapper)?Math.ceil(this.$wrapper.scrollTop()):0;};
n.prototype._setAriaRoleDescription=function(s){this._sAriaRoleDescription=s;return this;};
n.prototype._getAriaRoleDescription=function(){return this._sAriaRoleDescription;};
n.prototype._setScrollPosition=function(N,s){if(!o(this.$wrapper)){return;}if(this._getScrollPosition()===N){return;}if(s){this._bSuppressToggleHeaderOnce=true;}if(!this.getScrollDelegate()._$Container){this.getScrollDelegate()._$Container=this.$wrapper;}this.getScrollDelegate().scrollTo(0,N);};
n.prototype._shouldSnapOnScroll=function(){return!this._preserveHeaderStateOnScroll()&&this._getScrollPosition()>=this._getSnappingHeight()&&this.getHeaderExpanded()&&!this._bPinned;};
n.prototype._shouldExpandOnScroll=function(){var I=this._needsVerticalScrollBar();return!this._preserveHeaderStateOnScroll()&&this._getScrollPosition()<this._getSnappingHeight()&&!this.getHeaderExpanded()&&!this._bPinned&&I;};
n.prototype._shouldStickStickyContent=function(){var I,s,q;q=this._getScrollPosition();I=q<Math.ceil(this._getHeaderHeight()-this._iHeaderContentPaddingBottom)&&!this._bPinned&&!this.getPreserveHeaderStateOnScroll();s=q===0||I&&this._hasVisibleHeader();return!s;};
n.prototype._headerScrolledOut=function(){return this._getScrollPosition()>=this._getSnappingHeight();};
n.prototype._headerSnapAllowed=function(){return!this._preserveHeaderStateOnScroll()&&this.getHeaderExpanded()&&!this._bPinned;};
n.prototype._canSnapHeaderOnScroll=function(){var q=this._getMaxScrollPosition(),t=this._bMSBrowser?1:0;if(this._bHeaderInTitleArea){q+=this._getHeaderHeight();q-=t;}return q>this._getSnappingHeight();};
n.prototype._getSnappingHeight=function(){var s=Math.ceil(this._getHeaderHeight()||this._getTitleHeight())-this._iHeaderContentPaddingBottom;return s>0?s:0;};
n.prototype._getMaxScrollPosition=function(){var $;if(o(this.$wrapper)){$=this.$wrapper[0];return $.scrollHeight-$.clientHeight;}return 0;};
n.prototype._needsVerticalScrollBar=function(){var t=this._bMSBrowser?1:0;return this._getMaxScrollPosition()>t;};
n.prototype._getOwnHeight=function(){return this._getHeight(this);};
n.prototype._getEntireHeaderHeight=function(){var t=0,H=0,q=this.getTitle(),r=this.getHeader();if(o(q)){t=q.$().outerHeight();}if(o(r)){H=r.$().outerHeight();}return t+H;};
n.prototype._headerBiggerThanAllowedToPin=function(q){if(!(typeof q==="number"&&!isNaN(parseInt(q)))){q=this._getOwnHeight();}return this._getEntireHeaderHeight()>n.HEADER_MAX_ALLOWED_PINNED_PERCENTAGE*q;};
n.prototype._headerBiggerThanAllowedToBeFixed=function(){var q=this._getOwnHeight();return this._getEntireHeaderHeight()>n.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE*q;};
n.prototype._headerBiggerThanAllowedToBeExpandedInTitleArea=function(){var E=this._getEntireHeaderHeight(),q=this._getOwnHeight();if(q===0){return false;}return D.system.phone?E>=n.HEADER_MAX_ALLOWED_NON_SROLLABLE_ON_MOBILE*q:E>=q;};
n.prototype._measureScrollBarOffsetHeight=function(){var H=0,s=!this.getHeaderExpanded(),q=this._bHeaderInTitleArea;if(this._preserveHeaderStateOnScroll()||this._bPinned||(!s&&this._bHeaderInTitleArea)){H=this._getTitleAreaHeight();h.debug("DynamicPage :: preserveHeaderState is enabled or header pinned :: title area height"+H,this);return H;}if(s||!o(this.getTitle())||!this._canSnapHeaderOnScroll()){H=this._getTitleHeight();h.debug("DynamicPage :: header snapped :: title height "+H,this);return H;}this._snapHeader(true);H=this._getTitleHeight();if(!s){this._expandHeader(q);}h.debug("DynamicPage :: snapped mode :: title height "+H,this);return H;};
n.prototype._updateScrollBar=function(){var s,q,N;if(!D.system.desktop||!o(this.$wrapper)||(this._getHeight(this)===0)){return;}s=this._getScrollBar();s.setContentSize(this._measureScrollBarOffsetHeight()+this.$wrapper[0].scrollHeight+"px");q=this._needsVerticalScrollBar();N=this.bHasScrollbar!==q;if(N){s.toggleStyleClass("sapUiHidden",!q);this.toggleStyleClass("sapFDynamicPageWithScroll",q);this.bHasScrollbar=q;}setTimeout(this._updateFitContainer.bind(this),0);setTimeout(this._updateScrollBarOffset.bind(this),0);};
n.prototype._updateFitContainer=function(N){var q=typeof N!=='undefined'?!N:!this._needsVerticalScrollBar(),F=this.getFitContent(),t=F||q;this.$contentFitContainer.toggleClass("sapFDynamicPageContentFitContainer",t);};
n.prototype._updateScrollBarOffset=function(){var s=a.getConfiguration().getRTL()?"left":"right",O=this._needsVerticalScrollBar()?i().width+"px":0,F=this.getFooter();this.$titleArea.css("padding-"+s,O);if(o(F)){F.$().css(s,O);}};
n.prototype._updateHeaderARIAState=function(E){var q=this.getHeader();if(o(q)){q._updateARIAState(E);}};
n.prototype._updateTitleARIAState=function(E){var q=this.getTitle();if(o(q)){q._updateARIAState(E);}};
n.prototype._updateARIAStates=function(E){this._updateHeaderARIAState(E);this._updateTitleARIAState(E);};
n.prototype._applyContextualSettings=function(q){var r=q.contextualWidth;this._updateMedia(r);return d.prototype._applyContextualSettings.call(this,q);};
n.prototype._updateMedia=function(w){if(!w){return;}if(w<=n.BREAK_POINTS.PHONE){this._updateMediaStyle(n.MEDIA.PHONE);}else if(w<=n.BREAK_POINTS.TABLET){this._updateMediaStyle(n.MEDIA.TABLET);}else{this._updateMediaStyle(n.MEDIA.DESKTOP);}};
n.prototype._updateMediaStyle=function(s){Object.keys(n.MEDIA).forEach(function(q){var E=s===n.MEDIA[q];this.toggleStyleClass(n.MEDIA[q],E);},this);};
n.prototype._toggleExpandVisualIndicator=function(t){var q=this.getTitle();if(o(q)){q._toggleExpandButton(t);}};
n.prototype._focusExpandVisualIndicator=function(){var q=this.getTitle();if(o(q)){q._focusExpandButton();}};
n.prototype._toggleCollapseVisualIndicator=function(t){var q=this.getHeader();if(o(q)){q._toggleCollapseButton(t);}};
n.prototype._focusCollapseVisualIndicator=function(){var q=this.getHeader();if(o(q)){q._focusCollapseButton();}};
n.prototype._updateToggleHeaderVisualIndicators=function(){var H,q,E,r=this._hasVisibleTitleAndHeader(),s=this.getHeader(),t=false;if(o(s)){t=!!s.getContent().length;}if(!this.getToggleHeaderOnTitleClick()||!r){q=false;E=false;}else{H=this.getHeaderExpanded();q=H;E=D.system.phone&&this.getTitle().getAggregation("snappedTitleOnMobile")?false:!H;}E=E&&t;q=q&&t;this._toggleCollapseVisualIndicator(q);this._toggleExpandVisualIndicator(E);};
n.prototype._updateHeaderVisualState=function(H,q){var r=this.getHeader();if(H&&this.getPreserveHeaderStateOnScroll()){this._overridePreserveHeaderStateOnScroll();}if(!this._preserveHeaderStateOnScroll()&&r){if(this._headerBiggerThanAllowedToPin(q)||D.system.phone){this._unPin();this._togglePinButtonVisibility(false);this._togglePinButtonPressedState(false);}else{this._togglePinButtonVisibility(true);}if(this.getHeaderExpanded()&&this._bHeaderInTitleArea&&this._headerBiggerThanAllowedToBeExpandedInTitleArea()){this._expandHeader(false);this._setScrollPosition(0);}}};
n.prototype._updateTitleVisualState=function(){var t=this.getTitle(),T=this._hasVisibleTitleAndHeader()&&this.getToggleHeaderOnTitleClick();this.$().toggleClass("sapFDynamicPageTitleClickEnabled",T&&!D.system.phone);if(o(t)){t._toggleFocusableState(T);}};
n.prototype._scrollBellowCollapseVisualIndicator=function(){var H=this.getHeader(),$,q,v,O;if(o(H)){$=this.getHeader()._getCollapseButton().getDomRef();q=$.getBoundingClientRect().height;v=this.$wrapper[0].getBoundingClientRect().height;O=$.offsetTop+q-v;this._setScrollPosition(O);}};
n.prototype._hasVisibleTitleAndHeader=function(){var t=this.getTitle();return o(t)&&t.getVisible()&&this._hasVisibleHeader();};
n.prototype._hasVisibleHeader=function(){var H=this.getHeader();return o(H)&&H.getVisible()&&o(H.getContent());};
n.prototype._getHeight=function(q){var $;if(!(q instanceof C)){return 0;}$=q.getDomRef();return $?$.getBoundingClientRect().height:0;};
n.prototype._getWidth=function(q){return!(q instanceof C)?0:q.$().outerWidth()||0;};
n.prototype._getTitleAreaHeight=function(){return o(this.$titleArea)?this.$titleArea.outerHeight()||0:0;};
n.prototype._getTitleHeight=function(){return this._getHeight(this.getTitle());};
n.prototype._getHeaderHeight=function(){return this._getHeight(this.getHeader());};
n.prototype._preserveHeaderStateOnScroll=function(){return this.getPreserveHeaderStateOnScroll()&&!this._headerBiggerThanAllowedHeight;};
n.prototype._getScrollBar=function(){if(!o(this.getAggregation("_scrollBar"))){var v=new S(this.getId()+"-vertSB",{scrollPosition:0,scroll:this._onScrollBarScroll.bind(this)});this.setAggregation("_scrollBar",v,true);}return this.getAggregation("_scrollBar");};
n.prototype._cacheDomElements=function(){var F=this.getFooter();if(o(F)){this.$footer=F.$();this.$footerWrapper=this.$("footerWrapper");}this.$wrapper=this.$("contentWrapper");this.$contentFitContainer=this.$("contentFitContainer");this.$titleArea=this.$("header");this.$stickyPlaceholder=this.$("stickyPlaceholder");this._cacheTitleDom();this._cacheHeaderDom();};
n.prototype._cacheTitleDom=function(){var t=this.getTitle();if(o(t)){this.$title=t.$();}};
n.prototype._cacheHeaderDom=function(){var H=this.getHeader();if(o(H)){this.$header=H.$();}};
n.prototype._adjustSnap=function(){var q,I,r,s,t,u,$=this.$();if(!o($)){return;}if(!p($[0])){return;}q=this.getHeader();I=!this.getHeaderExpanded();if(!q||!I){return;}r=!this._preserveHeaderStateOnScroll()&&this._canSnapHeaderOnScroll();s=I&&q.$().hasClass("sapFDynamicPageHeaderHidden");if(r&&s){this._toggleHeaderVisibility(true);this._moveHeaderToContentArea(true);return;}if(!r&&!s){this._moveHeaderToTitleArea(true);this._toggleHeaderVisibility(false);return;}if(r){t=this._getScrollPosition();u=this._getSnappingHeight();if(t<u){this._setScrollPosition(u);}}};
n.prototype.ontouchmove=function(E){E.setMarked();};
n.prototype._onChildControlAfterRendering=function(E){var s=E.srcControl;if(s instanceof e){this._cacheTitleDom();this._deRegisterResizeHandler(n.RESIZE_HANDLER_ID.TITLE);this._registerResizeHandler(n.RESIZE_HANDLER_ID.TITLE,this.$title[0],this._onChildControlsHeightChange.bind(this));}else if(s instanceof f&&s.getDomRef()!==this.$header.get(0)){this._cacheHeaderDom();this._deRegisterResizeHandler(n.RESIZE_HANDLER_ID.HEADER);this._registerResizeHandler(n.RESIZE_HANDLER_ID.HEADER,this.$header[0],this._onChildControlsHeightChange.bind(this));}setTimeout(this._updateScrollBar.bind(this),0);};
n.prototype._onChildControlsHeightChange=function(E){var N=this._needsVerticalScrollBar(),H=this.getHeader(),q,O;if(N){this._updateFitContainer(N);}this._adjustSnap();if(!this._bExpandingWithAClick){this._updateScrollBar();}this._bExpandingWithAClick=false;if(H&&E.target.id===H.getId()){q=E.size.height;O=E.oldSize.height;this._updateHeaderVisualState(q!==O);this._adaptScrollPositionOnHeaderChange(q,O);}};
n.prototype._onResize=function(E){var q=this.getTitle(),r=E.size.width,s=E.size.height,H=s!==E.oldSize.height;this._updateHeaderVisualState(H,s);if(o(q)){q._onResize(r);}this._adjustSnap();this._updateScrollBar();this._updateMedia(r);};
n.prototype._onWrapperScroll=function(E){var s=Math.max(E.target.scrollTop,0);if(D.system.desktop){if(this.allowCustomScroll===true){this.allowCustomScroll=false;return;}this.allowInnerDiv=true;this._getScrollBar().setScrollPosition(s);this.toggleStyleClass("sapFDynamicPageWithScroll",this._needsVerticalScrollBar());}};
n.prototype._toggleHeaderOnScroll=function(){this._adjustStickyContent();if(this._bSuppressToggleHeaderOnce){this._bSuppressToggleHeaderOnce=false;return;}if(D.system.desktop&&this._bExpandingWithAClick){return;}if(this._preserveHeaderStateOnScroll()){return;}if(this._shouldSnapOnScroll()){this._snapHeader(true,true);}else if(this._shouldExpandOnScroll()){this._expandHeader(false,true);this._toggleHeaderVisibility(true);}else if(!this._bPinned&&this._bHeaderInTitleArea){var q=(this._getScrollPosition()>=this._getSnappingHeight());this._moveHeaderToContentArea(q);}};
n.prototype._adjustStickyContent=function(){if(!this._oStickySubheader){return;}var q,s=this._shouldStickStickyContent(),r,t=this.getStickySubheaderProvider();if(s===this._bStickySubheaderInTitleArea){return;}r=a.byId(t);if(!o(r)){return;}q=document.activeElement;r._setStickySubheaderSticked(s);if(s){this._oStickySubheader.$().appendTo(this.$stickyPlaceholder);}else{r._returnStickyContent();}q.focus();this._bStickySubheaderInTitleArea=s;};
n.prototype._onScrollBarScroll=function(){if(this.allowInnerDiv===true){this.allowInnerDiv=false;return;}this.allowCustomScroll=true;this._setScrollPosition(this._getScrollBar().getScrollPosition());};
n.prototype._adaptScrollPositionOnHeaderChange=function(N,O){var H=N-O,q=this.getHeader();if(H&&(!this.getHeaderExpanded()&&(q.$().css("visibility")!=="hidden"))&&!this._bHeaderInTitleArea&&this._needsVerticalScrollBar()){this._setScrollPosition(this._getScrollPosition()+H);}};
n.prototype._onTitlePress=function(){if(this.getToggleHeaderOnTitleClick()&&this._hasVisibleTitleAndHeader()){this._titleExpandCollapseWhenAllowed(true);this.getTitle()._focus();}};
n.prototype._onExpandHeaderVisualIndicatorPress=function(){this._onTitlePress();if(this._headerBiggerThanAllowedToBeExpandedInTitleArea()){this._scrollBellowCollapseVisualIndicator();}this._focusCollapseVisualIndicator();};
n.prototype._onCollapseHeaderVisualIndicatorPress=function(){this._onTitlePress();this._focusExpandVisualIndicator();};
n.prototype._onVisualIndicatorMouseOver=function(){var $=this.$();if(o($)){$.addClass("sapFDynamicPageTitleForceHovered");}};
n.prototype._onVisualIndicatorMouseOut=function(){var $=this.$();if(o($)){$.removeClass("sapFDynamicPageTitleForceHovered");}};
n.prototype._onTitleMouseOver=n.prototype._onVisualIndicatorMouseOver;n.prototype._onTitleMouseOut=n.prototype._onVisualIndicatorMouseOut;
n.prototype._titleExpandCollapseWhenAllowed=function(u){var q;if(this._bPinned&&!u){return this;}if(this._preserveHeaderStateOnScroll()||!this._canSnapHeaderOnScroll()||!this.getHeader()){if(!this.getHeaderExpanded()){this._expandHeader(false,u);this._toggleHeaderVisibility(true,u);}else{this._snapHeader(false,u);this._toggleHeaderVisibility(false,u);}}else if(!this.getHeaderExpanded()){q=!this._headerBiggerThanAllowedToBeExpandedInTitleArea();this._bExpandingWithAClick=true;this._expandHeader(q,u);this.getHeader().$().removeClass("sapFDynamicPageHeaderHidden");if(!q){this._setScrollPosition(0);}this._bExpandingWithAClick=false;}else{var r=this._bHeaderInTitleArea;this._snapHeader(r,u);if(!r){this._setScrollPosition(this._getSnappingHeight()+this._iHeaderContentPaddingBottom);}}};
n.prototype._onPinUnpinButtonPress=function(){if(this._bPinned){this._unPin();}else{this._pin();this._restorePinButtonFocus();}};
n.prototype._attachResizeHandlers=function(){var q=this._onChildControlsHeightChange.bind(this);this._registerResizeHandler(n.RESIZE_HANDLER_ID.PAGE,this,this._onResize.bind(this));if(o(this.$title)){this._registerResizeHandler(n.RESIZE_HANDLER_ID.TITLE,this.$title[0],q);}if(o(this.$header)){this._registerResizeHandler(n.RESIZE_HANDLER_ID.HEADER,this.$header[0],q);}if(o(this.$contentFitContainer)){this._registerResizeHandler(n.RESIZE_HANDLER_ID.CONTENT,this.$contentFitContainer[0],q);}};
n.prototype._registerResizeHandler=function(H,O,q){if(!this[H]){this[H]=R.register(O,q);}};
n.prototype._detachResizeHandlers=function(){this._deRegisterResizeHandler(n.RESIZE_HANDLER_ID.PAGE);this._deRegisterResizeHandler(n.RESIZE_HANDLER_ID.TITLE);this._deRegisterResizeHandler(n.RESIZE_HANDLER_ID.HEADER);this._deRegisterResizeHandler(n.RESIZE_HANDLER_ID.CONTENT);};
n.prototype._deRegisterResizeHandler=function(H){if(this[H]){R.deregister(this[H]);this[H]=null;}};
n.prototype._attachPageChildrenAfterRenderingDelegates=function(){var t=this.getTitle(),H=this.getHeader(),q=this.getContent(),r={onAfterRendering:this._onChildControlAfterRendering.bind(this)};if(o(t)){t.addEventDelegate(r);}if(o(q)){q.addEventDelegate(r);}if(o(H)){H.addEventDelegate(r);}};
n.prototype._attachTitlePressHandler=function(){var t=this.getTitle();if(o(t)&&!this._bAlreadyAttachedTitlePressHandler){t.attachEvent(n.EVENTS.TITLE_PRESS,this._onTitlePress,this);this._bAlreadyAttachedTitlePressHandler=true;}};
n.prototype._attachPinPressHandler=function(){var H=this.getHeader();if(o(H)&&!this._bAlreadyAttachedPinPressHandler){H.attachEvent(n.EVENTS.PIN_UNPIN_PRESS,this._onPinUnpinButtonPress,this);this._bAlreadyAttachedPinPressHandler=true;}};
n.prototype._attachStickyHeaderObserver=function(){var H=this.getHeader();if(o(H)&&!this._bAlreadyAttachedStickyHeaderObserver){if(!this._oStickyHeaderObserver){this._oStickyHeaderObserver=new M(this._adjustStickyContent.bind(this));}this._oStickyHeaderObserver.observe(H,{properties:["visible"]});this._bAlreadyAttachedStickyHeaderObserver=true;}};
n.prototype._attachHeaderObserver=function(){var H=this.getHeader();if(o(H)&&!this._bAlreadyAttachedHeaderObserver){if(!this._oHeaderObserver){this._oHeaderObserver=new M(this._updateToggleHeaderVisualIndicators.bind(this));}this._oHeaderObserver.observe(H,{aggregations:["content"]});this._bAlreadyAttachedHeaderObserver=true;}};
n.prototype._attachVisualIndicatorsPressHandlers=function(){var t=this.getTitle(),H=this.getHeader();if(o(t)&&!this._bAlreadyAttachedTitleIndicatorPressHandler){t.attachEvent(n.EVENTS.TITLE_VISUAL_INDICATOR_PRESS,this._onExpandHeaderVisualIndicatorPress,this);this._bAlreadyAttachedTitleIndicatorPressHandler=true;}if(o(H)&&!this._bAlreadyAttachedHeaderIndicatorPressHandler){H.attachEvent(n.EVENTS.HEADER_VISUAL_INDICATOR_PRESS,this._onCollapseHeaderVisualIndicatorPress,this);this._bAlreadyAttachedHeaderIndicatorPressHandler=true;}};
n.prototype._addStickySubheaderAfterRenderingDelegate=function(){var s,q=this.getStickySubheaderProvider(),I;s=a.byId(q);if(o(s)&&!this._bAlreadyAddedStickySubheaderAfterRenderingDelegate){I=s.getMetadata().getInterfaces().indexOf("sap.f.IDynamicPageStickyContent")!==-1;if(I){this._oStickySubheader=s._getStickyContent();this._oStickySubheader.addEventDelegate(this._oSubHeaderAfterRenderingDelegate,this);this._bAlreadyAddedStickySubheaderAfterRenderingDelegate=true;this._attachStickyHeaderObserver();}}};
n.prototype._attachVisualIndicatorMouseOverHandlers=function(){var H=this.getHeader();if(o(H)&&!this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler){H.attachEvent(n.EVENTS.VISUAL_INDICATOR_MOUSE_OVER,this._onVisualIndicatorMouseOver,this);H.attachEvent(n.EVENTS.VISUAL_INDICATOR_MOUSE_OUT,this._onVisualIndicatorMouseOut,this);this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler=true;}};
n.prototype._attachTitleMouseOverHandlers=function(){var t=this.getTitle();if(o(t)&&!this._bAlreadyAttachedTitleMouseOverOutHandler){t.attachEvent(n.EVENTS.TITLE_MOUSE_OVER,this._onTitleMouseOver,this);t.attachEvent(n.EVENTS.TITLE_MOUSE_OUT,this._onTitleMouseOut,this);this._bAlreadyAttachedTitleMouseOverOutHandler=true;}};
n.prototype._attachScrollHandler=function(){this._onWrapperScrollReference=this._onWrapperScroll.bind(this);this._toggleHeaderOnScrollReference=this._toggleHeaderOnScroll.bind(this);this.$wrapper.on("scroll",this._onWrapperScrollReference);this.$wrapper.on("scroll",this._toggleHeaderOnScrollReference);};
n.prototype._toggleAdditionalNavigationClass=function(){var s=this._bStickySubheaderProviderExists();this.toggleStyleClass(n.NAVIGATION_CLASS_NAME,s);};
n.prototype._bStickySubheaderProviderExists=function(){var s=a.byId(this.getStickySubheaderProvider());return!!s&&s.isA("sap.f.IDynamicPageStickyContent");};
n.prototype._detachScrollHandler=function(){if(this.$wrapper){this.$wrapper.off("scroll",this._onWrapperScrollReference);this.$wrapper.off("scroll",this._toggleHeaderOnScrollReference);}};
n.prototype._formatLandmarkInfo=function(q,s){if(q){var r=q["get"+s+"Role"]()||"",t=q["get"+s+"Label"]()||"";if(r===A.None){r='';}return{role:r.toLowerCase(),label:t};}return{};};
n.prototype._getHeaderTag=function(q){if(q&&q.getHeaderRole()!==A.None){return n.DIV;}return n.HEADER;};
n.prototype._getFooterTag=function(q){if(q&&q.getFooterRole()!==A.None){return n.DIV;}return n.FOOTER;};
return n;});
sap.ui.predefine('sap/f/DynamicPageAccessibleLandmarkInfo',['sap/ui/core/Element','./library'],function(E,l){"use strict";
var D=E.extend("sap.f.DynamicPageAccessibleLandmarkInfo",{metadata:{library:"sap.f",properties:{rootRole:{type:"sap.ui.core.AccessibleLandmarkRole",defaultValue:"None"},rootLabel:{type:"string",defaultValue:null},contentRole:{type:"sap.ui.core.AccessibleLandmarkRole",defaultValue:"None"},contentLabel:{type:"string",defaultValue:null},headerRole:{type:"sap.ui.core.AccessibleLandmarkRole",defaultValue:"None"},headerLabel:{type:"string",defaultValue:null},footerRole:{type:"sap.ui.core.AccessibleLandmarkRole",defaultValue:"None"},footerLabel:{type:"string",defaultValue:null}}}});
return D;});
sap.ui.predefine('sap/f/DynamicPageHeader',["./library","sap/ui/Device","sap/ui/core/Control","sap/ui/core/library","sap/m/ToggleButton","sap/m/Button","./DynamicPageHeaderRenderer","sap/ui/core/InvisibleMessage"],function(l,D,C,a,T,B,b,I){"use strict";var c=a.InvisibleMessageMode;
var d=C.extend("sap.f.DynamicPageHeader",{metadata:{library:"sap.f",properties:{pinnable:{type:"boolean",group:"Appearance",defaultValue:true},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance"}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true},_pinButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_collapseButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},designtime:"sap/f/designtime/DynamicPageHeader.designtime"}});
d._getResourceBundle=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.f");};
d.ARIA={ARIA_CONTROLS:"aria-controls",ARIA_EXPANDED:"aria-expanded",ARIA_LABEL:"aria-label",LABEL_EXPANDED:d._getResourceBundle().getText("EXPANDED_HEADER"),LABEL_COLLAPSED:d._getResourceBundle().getText("SNAPPED_HEADER"),LABEL_PINNED:d._getResourceBundle().getText("PIN_HEADER"),LABEL_UNPINNED:d._getResourceBundle().getText("UNPIN_HEADER"),TOOLTIP_COLLAPSE_BUTTON:d._getResourceBundle().getText("COLLAPSE_HEADER_BUTTON_TOOLTIP"),STATE_TRUE:"true",STATE_FALSE:"false"};
d.prototype.init=function(){this._bShowCollapseButton=true;this._oInvisibleMessage=null;};
d.prototype.onAfterRendering=function(){this._initARIAState();this._initPinButtonARIAState();if(!this._oInvisibleMessage){this._oInvisibleMessage=I.getInstance();}};
d.prototype._togglePinButton=function(v){this._getPinButton().setPressed(v);};
d.prototype._setShowPinBtn=function(v){this._getPinButton().$().toggleClass("sapUiHidden",!v);};
d.prototype._pinUnpinFireEvent=function(){this.fireEvent("_pinUnpinPress");};
d.prototype._onCollapseButtonPress=function(){this.fireEvent("_headerVisualIndicatorPress");};
d.prototype._onCollapseButtonMouseOver=function(){this.fireEvent("_visualIndicatorMouseOver");};
d.prototype._onCollapseButtonMouseOut=function(){this.fireEvent("_visualIndicatorMouseOut");};
d.prototype._initARIAState=function(){var $=this.$();$.attr(d.ARIA.ARIA_EXPANDED,d.ARIA.STATE_TRUE);$.attr(d.ARIA.ARIA_LABEL,d.ARIA.LABEL_EXPANDED);};
d.prototype._initPinButtonARIAState=function(){var $;if(this.getPinnable()){$=this._getPinButtonJQueryRef();$.attr(d.ARIA.ARIA_CONTROLS,this.getId());}};
d.prototype._updateARIAState=function(e){var $=this.$();if(e){$.attr(d.ARIA.ARIA_EXPANDED,d.ARIA.STATE_TRUE);$.attr(d.ARIA.ARIA_LABEL,d.ARIA.LABEL_EXPANDED);}else{$.attr(d.ARIA.ARIA_EXPANDED,d.ARIA.STATE_FALSE);$.attr(d.ARIA.ARIA_LABEL,d.ARIA.LABEL_COLLAPSED);}};
d.prototype._updateARIAPinButtonState=function(p){var P=this._getPinButton();if(p){P.setTooltip(d.ARIA.LABEL_UNPINNED);}else{P.setTooltip(d.ARIA.LABEL_PINNED);}};
d.prototype._getPinButton=function(){if(!this.getAggregation("_pinButton")){var p=new T({id:this.getId()+"-pinBtn",icon:"sap-icon://pushpin-off",tooltip:d.ARIA.LABEL_PINNED,press:this._pinUnpinFireEvent.bind(this)}).addStyleClass("sapFDynamicPageHeaderPinButton");this.setAggregation("_pinButton",p,true);}return this.getAggregation("_pinButton");};
d.prototype._getCollapseButton=function(){if(!this.getAggregation("_collapseButton")){var o=new B({id:this.getId()+"-collapseBtn",icon:"sap-icon://slim-arrow-up",press:this._onCollapseButtonPress.bind(this),tooltip:d.ARIA.TOOLTIP_COLLAPSE_BUTTON}).addStyleClass("sapFDynamicPageToggleHeaderIndicator");o.onmouseover=this._onCollapseButtonMouseOver.bind(this);o.onmouseout=this._onCollapseButtonMouseOut.bind(this);this.setAggregation("_collapseButton",o,true);}return this.getAggregation("_collapseButton");};
d.prototype._toggleCollapseButton=function(t){this._setShowCollapseButton(t);this._getCollapseButton().$().toggleClass("sapUiHidden",!t);};
d.prototype._getShowCollapseButton=function(){return this._bShowCollapseButton&&!!this.getContent().length;};
d.prototype._setShowCollapseButton=function(v){this._bShowCollapseButton=!!v;};
d.prototype._focusCollapseButton=function(){this._getCollapseButton().$().trigger("focus");this._oInvisibleMessage.announce(this._getCollapseButton().getTooltip(),c.Polite);};
d.prototype._focusPinButton=function(){this._getPinButtonJQueryRef().trigger("focus");};
d.prototype._getPinButtonJQueryRef=function(){return this._getPinButton().$();};
d.prototype._getState=function(){var e=this.getContent(),h=e.length>0,H=this.getPinnable()&&h&&!D.system.phone,p=this._getPinButton(),o=this._getCollapseButton();o.toggleStyleClass("sapUiHidden",!this._getShowCollapseButton());return{content:e,headerHasContent:h,headerPinnable:H,hasContent:e.length>0,pinButton:p,collapseButton:o};};
return d;});
sap.ui.predefine('sap/f/DynamicPageHeaderRenderer',[],function(){"use strict";var D={apiVersion:2};
D.render=function(r,d){var o=d._getState(),s="sapFDynamicPageHeader",b=d.getBackgroundDesign();r.openStart("header",d);r.accessibilityState({role:"region"});r.class("sapContrastPlus");r.class(s);if(o.headerHasContent){r.class("sapFDynamicPageHeaderWithContent");}if(o.headerPinnable){r.class("sapFDynamicPageHeaderPinnable");}if(b){r.class(s+b);}r.openEnd();this._renderHeaderContent(r,o);r.renderControl(o.collapseButton);if(o.headerPinnable){r.renderControl(o.pinButton);}r.close("header");};
D._renderHeaderContent=function(r,d){if(d.headerHasContent){r.openStart("div");r.class("sapFDynamicPageHeaderContent");r.openEnd();d.content.forEach(r.renderControl,r);r.close("div");}};
return D;},true);
sap.ui.predefine('sap/f/DynamicPageRenderer',["sap/ui/Device"],function(D){"use strict";var a={apiVersion:2};
a.render=function(r,d){var o=d.getTitle(),b=d.getHeader(),c=d.getFooter(),e=d.getContent(),h=d.getHeaderExpanded(),H=b?b.getContent():[],f=H.length>0,s=d.getShowFooter(),p=d._preserveHeaderStateOnScroll(),l=d.getLandmarkInfo(),g=d._getHeaderTag(l),F=d._getFooterTag(l);r.openStart("article",d);r.class("sapFDynamicPage");if(d.getToggleHeaderOnTitleClick()){r.class("sapFDynamicPageTitleClickEnabled");}r.attr("aria-roledescription",d._getAriaRoleDescription());r.accessibilityState(d,d._formatLandmarkInfo(l,"Root"));r.openEnd();if(D.system.desktop){r.renderControl(d._getScrollBar());}r.openStart(g,d.getId()+"-header");r.class("sapContrastPlus");r.class("sapFDynamicPageTitleWrapper");if(!h){r.class(D.system.phone&&o&&o.getSnappedTitleOnMobile()?"sapFDynamicPageTitleSnappedTitleOnMobile":"sapFDynamicPageTitleSnapped");}if(!f){r.class("sapFDynamicPageTitleOnly");}r.accessibilityState(d,d._formatLandmarkInfo(l,"Header"));r.attr("data-sap-ui-customfastnavgroup",true);r.openEnd();r.renderControl(o);r.openStart("div",d.getId()+"-stickyPlaceholder");r.openEnd();if(p){r.renderControl(b);}r.close("div");r.close(g);r.openStart("div",d.getId()+"-contentWrapper");r.class("sapFDynamicPageContentWrapper");if(d.getBackgroundDesign()){r.class("sapFDynamicPageContentWrapper"+d.getBackgroundDesign());}r.openEnd();if(!p){r.renderControl(b);}r.openStart("div",d.getId()+"-content");r.class("sapFDynamicPageContent");r.accessibilityState(d,d._formatLandmarkInfo(l,"Content"));r.openEnd();r.openStart("div",d.getId()+"-contentFitContainer");if(d.getFitContent()){r.class("sapFDynamicPageContentFitContainer");}if(c&&s){r.class("sapFDynamicPageContentFitContainerFooterVisible");}r.openEnd();r.renderControl(e);a.renderFooterSpacer(r,d,c,s);r.close("div");r.close("div");r.close("div");a.renderFooter(r,d,c,s,F,l);r.close("article");};
a.renderFooter=function(r,d,o,s,f,l){if(o){r.openStart(f,d.getId()+"-footerWrapper");r.class("sapContrast").class("sapContrastPlus").class("sapFDynamicPageFooter").class("sapFFooter-CTX");if(!s){r.class("sapUiHidden");}r.accessibilityState(d,d._formatLandmarkInfo(l,"Footer"));r.openEnd();o.addStyleClass("sapFDynamicPageActualFooterControl");r.renderControl(o);r.close(f);}};
a.renderFooterSpacer=function(r,d,o,s){if(o){r.openStart("div",d.getId()+"-spacer");if(s){r.class("sapFDynamicPageContentWrapperSpacer");}r.openEnd();r.close("div");}};
return a;},true);
sap.ui.predefine('sap/f/DynamicPageTitle',["./library","sap/ui/core/library","sap/ui/core/Control","sap/ui/base/ManagedObjectObserver","sap/m/library","sap/m/Toolbar","sap/m/ToolbarSeparator","sap/m/OverflowToolbar","sap/m/Button","sap/ui/core/InvisibleText","./DynamicPageTitleRenderer","sap/base/Log","sap/ui/core/HTML","sap/ui/core/Icon","sap/ui/Device","sap/ui/events/KeyCodes","sap/ui/core/InvisibleMessage"],function(l,C,a,M,m,T,b,O,B,I,D,L,H,c,d,K,e){"use strict";var f=l.DynamicPageTitleArea,g=m.ToolbarStyle,h=C.InvisibleMessageMode;var o=sap.ui.getCore();
var i=a.extend("sap.f.DynamicPageTitle",{metadata:{library:"sap.f",properties:{primaryArea:{type:"sap.f.DynamicPageTitleArea",group:"Appearance",defaultValue:f.Begin},areaShrinkRatio:{type:"sap.f.DynamicPageTitleShrinkRatio",group:"Appearance",defaultValue:"1:1.6:1.6"},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance"}},aggregations:{heading:{type:"sap.ui.core.Control",multiple:false,defaultValue:null},snappedHeading:{type:"sap.ui.core.Control",multiple:false,defaultValue:null},expandedHeading:{type:"sap.ui.core.Control",multiple:false,defaultValue:null},actions:{type:"sap.ui.core.Control",multiple:true,singularName:"action"},navigationActions:{type:"sap.m.Button",multiple:true,singularName:"navigationAction"},content:{type:"sap.ui.core.Control",multiple:true},snappedContent:{type:"sap.ui.core.Control",multiple:true},expandedContent:{type:"sap.ui.core.Control",multiple:true},snappedTitleOnMobile:{type:"sap.m.Title",multiple:false},breadcrumbs:{type:"sap.m.IBreadcrumbs",multiple:false},_actionsToolbar:{type:"sap.m.OverflowToolbar",multiple:false,visibility:"hidden"},_navActionsToolbar:{type:"sap.m.Toolbar",multiple:false,visibility:"hidden"},_navActionsToolbarSeparator:{type:"sap.m.ToolbarSeparator",multiple:false,visibility:"hidden"},_expandButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_snappedTitleOnMobileIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"}},events:{stateChange:{parameters:{isExpanded:{type:"boolean"}}}},designtime:"sap/f/designtime/DynamicPageTitle.designtime"}});
function j(v){if(arguments.length===1){return v&&("length"in v)?v.length>0:!!v;}return Array.prototype.slice.call(arguments).every(function(n){return j(n);});}
i.NAV_ACTIONS_PLACEMENT_BREAK_POINT=1280;i.PRIMARY_AREA_MIDDLE_SHRINK_FACTORS={headingAreaShrinkFactor:1.6,contentAreaShrinkFactor:1,actionsAreaShrinkFactor:1.6};i.TOGGLE_HEADER_TEXT_ID=I.getStaticId("sap.f","TOGGLE_HEADER");i.DEFAULT_HEADER_TEXT_ID=I.getStaticId("sap.f","DEFAULT_HEADER_TEXT");
i._renderControl=function(n,p){var r;if(!p||!n){return;}r=o.createRenderManager();r.renderControl(p);r.flush(n);r.destroy();};
function k(n){return typeof n==="function";}
i.prototype.init=function(){this._bExpandedState=true;this._bShowExpandButton=false;this._bIsFocusable=true;this._fnActionSubstituteParentFunction=function(){return this;}.bind(this);this._bNavigationActionsInTopArea=false;this._oRB=o.getLibraryResourceBundle("sap.f");this._oObserver=new M(i.prototype._observeChanges.bind(this));this._oObserver.observe(this,{aggregations:["content","_actionsToolbar"]});this._oRB=sap.ui.getCore().getLibraryResourceBundle("sap.f");this._oInvisibleMessage=null;};
i.prototype.onBeforeRendering=function(){this._getActionsToolbar();this._observeControl(this.getBreadcrumbs());this._detachFocusSpanHandlers();};
i.prototype.onAfterRendering=function(){this._cacheDomElements();this._attachFocusSpanHandlers();this._toggleState(this._bExpandedState);this._toggleFocusableState(this._bIsFocusable);this._doNavigationActionsLayout();this._updateTopAreaVisibility();if(!this._oInvisibleMessage){this._oInvisibleMessage=e.getInstance();}};
i.prototype.exit=function(){if(this._oObserver){this._oObserver.disconnect();this._oObserver=null;}};
i.prototype.setPrimaryArea=function(A){var s=this.getAreaShrinkRatio(),S=this._getShrinkFactorsObject(),n=this.getMetadata().getProperty("areaShrinkRatio").getDefaultValue();if(!this.getDomRef()){return this.setProperty("primaryArea",A,true);}if(s!==n){return this.setProperty("primaryArea",A,true);}if(A===f.Begin){this._setShrinkFactors(S.headingAreaShrinkFactor,S.contentAreaShrinkFactor,S.actionsAreaShrinkFactor);}else{this._setShrinkFactors(i.PRIMARY_AREA_MIDDLE_SHRINK_FACTORS.headingAreaShrinkFactor,i.PRIMARY_AREA_MIDDLE_SHRINK_FACTORS.contentAreaShrinkFactor,i.PRIMARY_AREA_MIDDLE_SHRINK_FACTORS.actionsAreaShrinkFactor);}return this.setProperty("primaryArea",A,true);};
i.prototype.setAreaShrinkRatio=function(A){A=this.validateProperty("areaShrinkRatio",A);this.setProperty("areaShrinkRatio",A,true);var s=this._getShrinkFactorsObject();if(this.getPrimaryArea()===f.Middle){L.warning("DynamicPageTitle :: Property primaryArea is disregarded when areaShrinkRatio is set.",this);}if(s.headingAreaShrinkFactor>1&&s.contentAreaShrinkFactor>1&&s.actionsAreaShrinkFactor>1){L.warning("DynamicPageTitle :: One of the shrink factors should be set to 1.",this);}this._setShrinkFactors(s.headingAreaShrinkFactor,s.contentAreaShrinkFactor,s.actionsAreaShrinkFactor);return this;};
i.prototype.ontap=function(E){var s=E.srcControl;if(s===this||s===this.getAggregation("_actionsToolbar")||s===this.getAggregation("breadcrumbs")||s===this.getAggregation("snappedTitleOnMobile")){this.fireEvent("_titlePress");}};
i.prototype.onmouseover=function(){if(this._bTitleMouseOverFired){return;}this.fireEvent("_titleMouseOver");this._bTitleMouseOverFired=true;};
i.prototype.onmouseout=function(E){if(E&&this.getDomRef().contains(E.relatedTarget)){return;}this.fireEvent("_titleMouseOut");this._bTitleMouseOverFired=false;};
i.prototype.onkeyup=function(E){if(E&&E.which===K.SPACE&&!E.shiftKey){this.onsapenter(E);}};
i.prototype.onsapspace=function(E){if(E.srcControl===this){E.preventDefault();}};
i.prototype.onsapenter=function(E){if(E.srcControl===this){this.fireEvent("_titlePress");}};
["addAction","insertAction","removeAction","indexOfAction","removeAllActions","destroyActions","getActions"].forEach(function(s){i.prototype[s]=function(n){var t=this._getActionsToolbar(),p=s.replace(/Actions?/,"Content"),S=true,r;if(s==="addAction"||s==="insertAction"){if(!this._actionExists(n,"actions")){t[p].apply(t,arguments);this._preProcessAction(n,"actions");}r=this;}else if(s==="removeAction"){this._postProcessAction(n);}else if(s==="removeAllActions"){this.getActions().forEach(this._postProcessAction,this);}else if(s==="destroyActions"){this.getActions().forEach(this._postProcessAction,this);t[p].apply(t,arguments);r=this;}else if(s==="getActions"){S=false;}r=r||t[p].apply(t,arguments);S&&this._updateSeparatorVisibility();return r;};});["addNavigationAction","insertNavigationAction","removeNavigationAction","indexOfNavigationAction","removeAllNavigationActions","destroyNavigationActions","getNavigationActions"].forEach(function(s){i.prototype[s]=function(n){var t=this._getNavigationActionsToolbar(),p=s.replace(/NavigationActions?/,"Content"),q=true,r;if(s==="addNavigationAction"||s==="insertNavigationAction"){if(!this._actionExists(n,"navigationActions")){t[p].apply(t,arguments);this._preProcessAction(n,"navigationActions");}r=this;}else if(s==="removeNavigationAction"){this._postProcessAction(n);}else if(s==="removeAllNavigationActions"){this.getNavigationActions().forEach(this._postProcessAction,this);}else if(s==="destroyNavigationActions"){this.getNavigationActions().forEach(this._postProcessAction,this);t[p].apply(t,arguments);r=this;}else if(s==="getNavigationActions"){q=false;}r=r||t[p].apply(t,arguments);q&&this._updateTopAreaVisibility();return r;};});
i.prototype.clone=function(s,n,p){var t=a.prototype.clone.apply(this,arguments),q=true;if(p){q=!!p.cloneChildren;}if(!q){return t;}var r=function(A){if(!this.isBound(A)){var u=this.getMetadata().getAggregation(A);u.get(this).forEach(function(v){u.add(t,v.clone());},this);}}.bind(this);r("actions");r("navigationActions");return t;};
i.prototype._actionExists=function(A,s){return this.getMetadata().getAggregation(s).get(this).indexOf(A)>-1;};
i.prototype._cacheDomElements=function(){this.$topNavigationActionsArea=this.$("topNavigationArea");this.$mainNavigationActionsArea=this.$("mainNavigationArea");this.$beginArea=this.$("left-inner");this.$topArea=this.$("top");this.$mainArea=this.$("main");this.$middleArea=this.$("content");this.$snappedTitleOnMobileWrapper=this.$("snapped-title-on-mobile-wrapper");this.$snappedHeadingWrapper=this.$("snapped-heading-wrapper");this.$expandHeadingWrapper=this.$("expand-heading-wrapper");this.$snappedWrapper=this.$("snapped-wrapper");this.$expandWrapper=this.$("expand-wrapper");this._$focusSpan=this.$("focusSpan");};
i.prototype._getActionsToolbar=function(){if(!this.getAggregation("_actionsToolbar")){this.setAggregation("_actionsToolbar",new O({id:this.getId()+"-_actionsToolbar",style:g.Clear}).addStyleClass("sapFDynamicPageTitleActionsBar"),true);}return this.getAggregation("_actionsToolbar");};
i.prototype._getNavigationActionsToolbar=function(){if(!this.getAggregation("_navActionsToolbar")){this.setAggregation("_navActionsToolbar",new T({id:this.getId()+"-navActionsToolbar",style:g.Clear}).addStyleClass("sapFDynamicPageTitleActionsBar"),true);}return this.getAggregation("_navActionsToolbar");};
i.prototype._getToolbarSeparator=function(){if(!this.getAggregation("_navActionsToolbarSeparator")){this.setAggregation("_navActionsToolbarSeparator",new b({id:this.getId()+"-separator"}),true);}return this.getAggregation("_navActionsToolbarSeparator");};
i.prototype._toggleFocusableState=function(F){var $;this._bIsFocusable=F;$=this._getFocusSpan();if($){F?$.show():$.hide();}};
i.prototype._preProcessAction=function(A,p){if(k(A._fnOriginalGetParent)){return;}this._observeControl(A);A._fnOriginalGetParent=A.getParent;A.getParent=this._fnActionSubstituteParentFunction;A._sOriginalParentAggregationName=A.sParentAggregationName;A.sParentAggregationName=p;};
i.prototype._postProcessAction=function(A){if(!k(A._fnOriginalGetParent)){return;}this._unobserveControl(A);A.getParent=A._fnOriginalGetParent;A._fnOriginalGetParent=null;A.sParentAggregationName=A._sOriginalParentAggregationName;A._sOriginalParentAggregationName=null;};
i.prototype._observeControl=function(n){this._oObserver.observe(n,{properties:["visible"]});};
i.prototype._unobserveControl=function(n){this._oObserver.unobserve(n,{properties:["visible"]});};
i.prototype._doNavigationActionsLayout=function(){var r,n,N;if(this.getNavigationActions().length===0){return;}N=this._getNavigationActionsToolbar();r=this._shouldRenderNavigationActionsInTopArea();if(r){n=this.$topNavigationActionsArea[0];}else{n=this.$mainNavigationActionsArea[0];}this._bNavigationActionsInTopArea=r;i._renderControl(n,N);this._updateSeparatorVisibility();};
i.prototype._updateTopAreaVisibility=function(n){var N=this._areNavigationActionsInTopArea(),p=this._shouldRenderNavigationActionsInTopArea(n),q=this.getBreadcrumbs()&&this.getBreadcrumbs().getVisible(),r=d.system.phone&&this.getSnappedTitleOnMobile()&&!this._bExpandedState,s=(q||p)&&!r,S=this.getNavigationActions().length>0&&(p^N);this._toggleTopAreaVisibility(s);if(S){this._toggleNavigationActionsPlacement(p);}else{this._updateSeparatorVisibility();}};
i.prototype._onResize=function(n){this._updateTopAreaVisibility(n);};
i.prototype._toggleNavigationActionsPlacement=function(s){this["_showNavigationActionsIn"+(s?"Top":"Main")+"Area"]();this._updateSeparatorVisibility();};
i.prototype._showNavigationActionsInTopArea=function(){var n=this._getNavigationActionsToolbar(),p;if(this.$topNavigationActionsArea&&this.$topNavigationActionsArea.length>0){p=document.activeElement;this.$topNavigationActionsArea.html(n.$());p&&p.focus();}this._bNavigationActionsInTopArea=true;};
i.prototype._showNavigationActionsInMainArea=function(){var n=this._getNavigationActionsToolbar(),p;if(this.$mainNavigationActionsArea&&this.$mainNavigationActionsArea.length>0){p=document.activeElement;this.$mainNavigationActionsArea.html(n.$());p&&p.focus();}this._bNavigationActionsInTopArea=false;};
i.prototype._areNavigationActionsInTopArea=function(){return this._bNavigationActionsInTopArea;};
i.prototype._updateSeparatorVisibility=function(){if(this.getDomRef()){this._getToolbarSeparator().toggleStyleClass("sapUiHidden",!this._shouldShowSeparator());}};
i.prototype._toggleTopAreaVisibility=function(s){if(this.getDomRef()){this.$("top").toggleClass("sapUiHidden",!s);}};
i.prototype._shouldShowSeparator=function(){var n,p;if(this._bNavigationActionsInTopArea){return false;}n=this._getVisibleActions().length>0;p=this._getVisibleNavigationActions().length>0;return n&&p;};
i.prototype._getVisibleActions=function(){return this.getActions().filter(function(A){return A.getVisible();});};
i.prototype._getVisibleNavigationActions=function(){return this.getNavigationActions().filter(function(A){return A.getVisible();});};
i.prototype._setShrinkFactors=function(n,p,A){this.$("left-inner").css("flex-shrink",n);this.$("content").css("flex-shrink",p);this.$("mainActions").css("flex-shrink",A);};
i.prototype._shouldRenderNavigationActionsInTopArea=function(n){var w,p,q;if(this._getVisibleNavigationActions().length===0){return false;}w=n?n:this._getWidth();p=this._getVisibleActions().length>0;q=this.getBreadcrumbs()&&this.getBreadcrumbs().getVisible();return w<i.NAV_ACTIONS_PLACEMENT_BREAK_POINT&&(q||p);};
i.prototype._toggleState=function(E,u){var n=this._bExpandedState;this._bExpandedState=E;if(!this.getDomRef()){return;}if(d.system.phone&&this.getSnappedTitleOnMobile()){this.$snappedTitleOnMobileWrapper.toggleClass("sapUiHidden",E);this.$topArea.toggleClass("sapUiHidden",!E);this.$mainArea.toggleClass("sapUiHidden",!E);this.$().toggleClass("sapContrast",!E);}else{if(j(this.getSnappedHeading())){this.$snappedHeadingWrapper.toggleClass("sapUiHidden",E);}if(j(this.getExpandedHeading())){this.$expandHeadingWrapper.toggleClass("sapUiHidden",!E);}if(u&&n!==E){this.fireEvent("stateChange",{isExpanded:E});}}if(j(this.getSnappedContent())){this.$snappedWrapper.toggleClass("sapUiHidden",E);this.$snappedWrapper.parent().toggleClass("sapFDynamicPageTitleMainSnapContentVisible",!E);}if(j(this.getExpandedContent())){this.$expandWrapper.toggleClass("sapUiHidden",!E);this.$expandWrapper.parent().toggleClass("sapFDynamicPageTitleMainExpandContentVisible",E);}};
i.prototype._getExpandButton=function(){if(!this.getAggregation("_expandButton")){var E=new B({id:this.getId()+"-expandBtn",icon:"sap-icon://slim-arrow-down",press:this._onExpandButtonPress.bind(this),tooltip:this._oRB.getText("EXPAND_HEADER_BUTTON_TOOLTIP")}).addStyleClass("sapFDynamicPageToggleHeaderIndicator sapUiHidden");this.setAggregation("_expandButton",E,true);}return this.getAggregation("_expandButton");};
i.prototype._getSnappedTitleOnMobileIcon=function(){if(!this.getAggregation("_snappedTitleOnMobileIcon")){var n=new c({id:this.getId()+"-snappedTitleOnMobileIcon",src:"sap-icon://slim-arrow-down",press:this._onExpandButtonPress.bind(this)});this.setAggregation("_snappedTitleOnMobileIcon",n,true);}return this.getAggregation("_snappedTitleOnMobileIcon");};
i.prototype._onExpandButtonPress=function(){this.fireEvent("_titleVisualIndicatorPress");};
i.prototype._toggleExpandButton=function(t){this._setShowExpandButton(t);this._getExpandButton().$().toggleClass("sapUiHidden",!t);};
i.prototype._getShowExpandButton=function(){return this._bShowExpandButton;};
i.prototype._setShowExpandButton=function(v){this._bShowExpandButton=!!v;};
i.prototype._focusExpandButton=function(){this._getExpandButton().$().trigger("focus");this._oInvisibleMessage.announce(this._getExpandButton().getTooltip(),h.Polite);};
i.prototype._getWidth=function(){return this.$().outerWidth();};
i.prototype._getState=function(){var n=this.getActions().length>0,p=this.getNavigationActions().length>0,q=this.getContent(),s=this.getSnappedContent(),E=this.getExpandedContent(),r=E.length>0,t=s.length>0,S=this._getShrinkFactorsObject(),u=this._getExpandButton(),F=this._getFocusSpan(),v=this.getBreadcrumbs(),w=this.getSnappedTitleOnMobile(),x=this._getSnappedTitleOnMobileIcon(),y=w&&d.system.phone,z=v||p,A=!!(v&&!p),G=p&&!v,J=this.getMetadata().getProperty("areaShrinkRatio").getDefaultValue();if(this.getAreaShrinkRatio()===J&&this.getPrimaryArea()===f.Middle){S.headingAreaShrinkFactor=i.PRIMARY_AREA_MIDDLE_SHRINK_FACTORS.headingAreaShrinkFactor;S.contentAreaShrinkFactor=i.PRIMARY_AREA_MIDDLE_SHRINK_FACTORS.contentAreaShrinkFactor;S.actionsAreaShrinkFactor=i.PRIMARY_AREA_MIDDLE_SHRINK_FACTORS.actionsAreaShrinkFactor;}u.toggleStyleClass("sapUiHidden",!this._getShowExpandButton());return{id:this.getId(),actionBar:this._getActionsToolbar(),navigationBar:this._getNavigationActionsToolbar(),hasActions:n,hasNavigationActions:p,content:q,hasContent:q.length>0,heading:this.getHeading(),snappedHeading:this.getSnappedHeading(),expandedHeading:this.getExpandedHeading(),expandButton:u,focusSpan:F,snappedTitleOnMobileContext:w,snappedTitleOnMobileIcon:x,snappedContent:s,expandedContent:E,hasSnappedContent:t,hasExpandedContent:r,hasSnappedTitleOnMobile:y,hasAdditionalContent:r||(t&&!y),isSnapped:!this._bExpandedState,headingAreaShrinkFactor:S.headingAreaShrinkFactor,contentAreaShrinkFactor:S.contentAreaShrinkFactor,actionsAreaShrinkFactor:S.actionsAreaShrinkFactor,breadcrumbs:this.getBreadcrumbs(),separator:this._getToolbarSeparator(),hasTopContent:z,hasOnlyBreadcrumbs:A,hasOnlyNavigationActions:G,contentAreaFlexBasis:this._sContentAreaFlexBasis,actionsAreaFlexBasis:this._sActionsAreaFlexBasis,isFocusable:this._bIsFocusable};};
i.prototype._getShrinkFactorsObject=function(){var r={},A=this.getAreaShrinkRatio().split(":");r.headingAreaShrinkFactor=parseFloat(A[0]);r.contentAreaShrinkFactor=parseFloat(A[1]);r.actionsAreaShrinkFactor=parseFloat(A[2]);return r;};
i.prototype._observeChanges=function(n){var p=n.object,s=n.name;if(p===this){if(s==="content"||s==="_actionsToolbar"){this._observeContentChanges(n);}}else if(s==="visible"){this._updateTopAreaVisibility();}};
i.prototype._observeContentChanges=function(n){var p=n.child,s=n.mutation;if(!(p instanceof O)){return;}if(s==="insert"){p.attachEvent("_contentSizeChange",this._onContentSizeChange,this);}else if(s==="remove"){p.detachEvent("_contentSizeChange",this._onContentSizeChange,this);this._setContentAreaFlexBasis(0,p.$().parent());}};
i.prototype._onContentSizeChange=function(E){var n=E.getParameter("contentSize");this._setContentAreaFlexBasis(n,E.getSource().$().parent());};
i.prototype._setContentAreaFlexBasis=function(n,$){var F,s;n=parseInt(n);F=n?n+"px":"auto";s=F!=="auto"?F:undefined;$.css({"flex-basis":F});if($.hasClass("sapFDynamicPageTitleMainContent")){this._sContentAreaFlexBasis=s;}else if($.hasClass("sapFDynamicPageTitleMainActions")){this._sActionsAreaFlexBasis=s;}};
i.prototype._updateARIAState=function(E){var A=this._getARIALabelReferences(E)||i.DEFAULT_HEADER_TEXT_ID,$=this._getFocusSpan();if($){$.attr("aria-labelledby",A);$.attr("aria-expanded",E);}return this;};
i.prototype._getARIALabelReferences=function(E){var r="",n=this.getHeading()||(E?this.getExpandedHeading():this.getSnappedHeading());if(n){r+=n.getId();}return r;};
i.prototype._focus=function(){this._getFocusSpan().trigger("focus");};
i.prototype._getAriaDescribedByReferences=function(){var t=this.getAriaDescribedBy(),s=i.TOGGLE_HEADER_TEXT_ID;if(t.length>0){s+=" "+t.join(" ");}return s;};
i.prototype._attachFocusSpanHandlers=function(){this._$focusSpan.on("focusin",this._addFocusClass.bind(this));this._$focusSpan.on("focusout",this._removeFocusClass.bind(this));};
i.prototype._detachFocusSpanHandlers=function(){if(this._$focusSpan){this._$focusSpan.off("focusin");this._$focusSpan.off("focusout");}};
i.prototype._getFocusSpan=function(){return this._$focusSpan;};
i.prototype._addFocusClass=function(){this.$().addClass("sapFDynamicPageTitleFocus");};
i.prototype._removeFocusClass=function(){this.$().removeClass("sapFDynamicPageTitleFocus");};
return i;});
sap.ui.predefine('sap/f/DynamicPageTitleRenderer',["./library"],function(l){"use strict";var D={apiVersion:2};
D.render=function(r,d){var o=d._getState(),s="sapFDynamicPageTitle",b=d.getBackgroundDesign(),L=d._getARIALabelReferences(d._bExpandedState)||d.DEFAULT_HEADER_TEXT_ID,a=d._getAriaDescribedByReferences();r.openStart("div",d);r.class(s);if(b){r.class(s+b);}r.openEnd();r.openStart("span",d.getId()+"-focusSpan").class("sapFDynamicPageTitleFocusSpan").attr("role","button").attr("aria-expanded",d._bExpandedState).attr("aria-labelledby",L).attr("aria-describedby",a).attr("tabindex",0);r.openEnd().close("span");this._renderTopArea(r,o);this._renderMainArea(r,o);this._renderSnappedExpandedContentArea(r,o);if(o.hasSnappedTitleOnMobile){this._renderSnappedTitleOnMobile(r,o);}r.renderControl(o.expandButton);r.close("div");};
D._renderTopArea=function(r,d){if(d.hasTopContent){r.openStart("div",d.id+"-top");r.class("sapFDynamicPageTitleTop");if(d.hasOnlyBreadcrumbs){r.class("sapFDynamicPageTitleTopBreadCrumbsOnly");}if(d.hasOnlyNavigationActions){r.class("sapFDynamicPageTitleTopNavActionsOnly");}r.openEnd();this._renderTopBreadcrumbsArea(r,d);this._renderTopNavigationArea(r,d);r.close("div");}};
D._renderTopBreadcrumbsArea=function(r,d){if(d.breadcrumbs){r.openStart("div",d.id+"-breadcrumbs");r.class("sapFDynamicPageTitleTopLeft");r.openEnd();r.renderControl(d.breadcrumbs);r.close("div");}};
D._renderTopNavigationArea=function(r,d){if(d.hasNavigationActions){r.openStart("div",d.id+"-topNavigationArea");r.class("sapFDynamicPageTitleTopRight");r.openEnd();r.close("div");}};
D._renderMainArea=function(r,d){r.openStart("div",d.id+"-main");r.class("sapFDynamicPageTitleMain");if(!d.hasContent){r.class("sapFDynamicPageTitleMainNoContent");}r.openEnd();r.openStart("div");r.class("sapFDynamicPageTitleMainInner");r.openEnd();this._renderMainHeadingArea(r,d);this._renderMainContentArea(r,d);this._renderMainActionsArea(r,d);r.close("div");this._renderMainNavigationArea(r,d);r.close("div");};
D._renderMainHeadingArea=function(r,d){r.openStart("div",d.id+"-left-inner");r.class("sapFDynamicPageTitleMainHeading");r.style("flex-shrink",d.headingAreaShrinkFactor);r.openEnd();r.openStart("div");r.class("sapFDynamicPageTitleHeading-CTX");r.class("sapFDynamicPageTitleMainHeadingInner");r.openEnd();if(d.heading){r.renderControl(d.heading);}else{if(d.snappedHeading){D._renderSnappedHeading(r,d);}if(d.expandedHeading){D._renderExpandHeading(r,d);}}r.close("div");r.close("div");};
D._renderMainContentArea=function(r,d){r.openStart("div",d.id+"-content");r.class("sapFDynamicPageTitleMainContent");r.class("sapFDynamicPageTitleContent-CTX");r.style("flex-shrink",d.contentAreaShrinkFactor);if(d.contentAreaFlexBasis){r.style("flex-basis",d.contentAreaFlexBasis);}r.openEnd();d.content.forEach(r.renderControl,r);r.close("div");};
D._renderMainActionsArea=function(r,d){r.openStart("div",d.id+"-mainActions");r.class("sapFDynamicPageTitleMainActions");r.style("flex-shrink",d.actionsAreaShrinkFactor);if(d.actionsAreaFlexBasis){r.style("flex-basis",d.actionsAreaFlexBasis);}r.openEnd();if(d.hasActions){r.renderControl(d.actionBar);}r.close("div");};
D._renderMainNavigationArea=function(r,d){if(d.hasNavigationActions){r.openStart("div",d.id+"-mainNavigationAreaWrapper");r.class("sapFDynamicPageTitleMainNavigationArea");r.openEnd();r.renderControl(d.separator);r.openStart("div",d.id+"-mainNavigationArea");r.class("sapFDynamicPageTitleMainNavigationAreaInner");r.openEnd();r.close("div");r.close("div");}};
D._renderSnappedExpandedContentArea=function(r,d){if(d.hasAdditionalContent){r.openStart("div");r.class("sapFDynamicPageTitleMainHeadingSnappedExpandContent");r.openEnd();if(d.hasSnappedContent&&!d.hasSnappedTitleOnMobile){D._renderSnappedContent(r,d);}if(d.hasExpandedContent){D._renderExpandContent(r,d);}r.close("div");}};
D._renderExpandHeading=function(r,d){r.openStart("div",d.id+"-expand-heading-wrapper");r.openEnd();r.renderControl(d.expandedHeading);r.close("div");};
D._renderSnappedHeading=function(r,d){r.openStart("div",d.id+"-snapped-heading-wrapper");if(!d.isSnapped){r.class("sapUiHidden");}r.openEnd();r.renderControl(d.snappedHeading);r.close("div");};
D._renderExpandContent=function(r,d){r.openStart("div",d.id+"-expand-wrapper");r.openEnd();d.expandedContent.forEach(r.renderControl,r);r.close("div");};
D._renderSnappedContent=function(r,d){r.openStart("div",d.id+"-snapped-wrapper");if(!d.isSnapped){r.class("sapUiHidden");}r.class("sapFDynamicPageTitleSnapped");r.openEnd();d.snappedContent.forEach(r.renderControl,r);r.close("div");};
D._renderSnappedTitleOnMobile=function(r,d){r.openStart("div",d.id+"-snapped-title-on-mobile-wrapper");if(!d.isSnapped){r.class("sapUiHidden");}r.class("sapFDynamicPageTitleSnappedTitleOnMobile");r.openEnd();r.renderControl(d.snappedTitleOnMobileContext);r.renderControl(d.snappedTitleOnMobileIcon);r.close("div");};
return D;},true);
sap.ui.predefine('sap/f/FlexibleColumnLayout',["sap/ui/thirdparty/jquery","./library","sap/ui/Device","sap/ui/core/ResizeHandler","sap/ui/core/Control","sap/m/library","sap/m/Button","sap/m/NavContainer","sap/ui/core/Configuration","sap/ui/core/theming/Parameters",'sap/ui/dom/units/Rem',"./FlexibleColumnLayoutRenderer","sap/base/Log","sap/base/assert","sap/base/util/isEmptyObject","sap/base/util/merge"],function(q,l,D,R,C,m,B,N,a,P,b,F,L,c,d,e){"use strict";var f=l.LayoutType;
var g=C.extend("sap.f.FlexibleColumnLayout",{metadata:{properties:{autoFocus:{type:"boolean",group:"Behavior",defaultValue:true},layout:{type:"sap.f.LayoutType",defaultValue:f.OneColumn},defaultTransitionNameBeginColumn:{type:"string",group:"Appearance",defaultValue:"slide"},defaultTransitionNameMidColumn:{type:"string",group:"Appearance",defaultValue:"slide"},defaultTransitionNameEndColumn:{type:"string",group:"Appearance",defaultValue:"slide"},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:m.BackgroundDesign.Transparent},restoreFocusOnBackNavigation:{type:"boolean",group:"Behavior",defaultValue:false}},aggregations:{beginColumnPages:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_getBeginColumn",aggregation:"pages"}},midColumnPages:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_getMidColumn",aggregation:"pages"}},endColumnPages:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_getEndColumn",aggregation:"pages"}},_beginColumnNav:{type:"sap.m.NavContainer",multiple:false,visibility:"hidden"},_midColumnNav:{type:"sap.m.NavContainer",multiple:false,visibility:"hidden"},_endColumnNav:{type:"sap.m.NavContainer",multiple:false,visibility:"hidden"},_beginColumnBackArrow:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_midColumnForwardArrow:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_midColumnBackArrow:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_endColumnForwardArrow:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},associations:{initialBeginColumnPage:{type:"sap.ui.core.Control",multiple:false},initialMidColumnPage:{type:"sap.ui.core.Control",multiple:false},initialEndColumnPage:{type:"sap.ui.core.Control",multiple:false}},events:{stateChange:{parameters:{layout:{type:"sap.f.LayoutType"},maxColumnsCount:{type:"int"},isNavigationArrow:{type:"boolean"},isResize:{type:"boolean"}}},beginColumnNavigate:{allowPreventDefault:true,parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},afterBeginColumnNavigate:{parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},midColumnNavigate:{allowPreventDefault:true,parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},afterMidColumnNavigate:{parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},endColumnNavigate:{allowPreventDefault:true,parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},afterEndColumnNavigate:{parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},columnResize:{parameters:{beginColumn:{type:"boolean"},midColumn:{type:"boolean"},endColumn:{type:"boolean"}}}}}});
g.COLUMN_RESIZING_ANIMATION_DURATION=560;g.PINNED_COLUMN_CLASS_NAME="sapFFCLPinnedColumn";g.COLUMN_ORDER=["begin","mid","end"];
g.prototype.init=function(){this._iWidth=0;this._oColumnFocusInfo={begin:{},mid:{},end:{}};this._initNavContainers();this._initButtons();this._oLayoutHistory=new h();this._oAnimationEndListener=new A();this._oRenderedColumnPagesBoolMap={};this._iNavigationArrowWidth=b.toPx(P.get("_sap_f_FCL_navigation_arrow_width"));this._oColumnWidthInfo={begin:0,mid:0,end:0};};
g.prototype._onNavContainerRendered=function(E){var o=E.srcControl,H=o.getPages().length>0,i=this._hasAnyColumnPagesRendered();this._setColumnPagesRendered(o.getId(),H);if(this._hasAnyColumnPagesRendered()!==i){this._hideShowArrows();}};
g.prototype._createNavContainer=function(s){var i=s.charAt(0).toUpperCase()+s.slice(1);var n=new N(this.getId()+"-"+s+"ColumnNav",{autoFocus:this.getAutoFocus(),navigate:function(E){this._handleNavigationEvent(E,false,s);}.bind(this),afterNavigate:function(E){this._handleNavigationEvent(E,true,s);}.bind(this),defaultTransitionName:this["getDefaultTransitionName"+i+"Column"]()});n.addDelegate({"onAfterRendering":this._onNavContainerRendered},this);this["_"+s+'ColumnFocusOutDelegate']={onfocusout:function(E){this._oColumnFocusInfo[s]=E.target;}};n.addEventDelegate(this["_"+s+'ColumnFocusOutDelegate'],this);return n;};
g.prototype._handleNavigationEvent=function(E,i,s){var j,k;if(i){j="after"+(s.charAt(0).toUpperCase()+s.slice(1))+"ColumnNavigate";}else{j=s+"ColumnNavigate";}k=this.fireEvent(j,E.mParameters,true);if(!k){E.preventDefault();}};
g.prototype._getColumnByStringName=function(s){if(s==='end'){return this._getEndColumn();}else if(s==='mid'){return this._getMidColumn();}else{return this._getBeginColumn();}};
g.prototype._getBeginColumn=function(){return this.getAggregation("_beginColumnNav");};
g.prototype._getMidColumn=function(){return this.getAggregation("_midColumnNav");};
g.prototype._getEndColumn=function(){return this.getAggregation("_endColumnNav");};
g.prototype._flushColumnContent=function(s){var o=this.getAggregation("_"+s+"ColumnNav"),r=sap.ui.getCore().createRenderManager();r.renderControl(o);r.flush(this._$columns[s].find(".sapFFCLColumnContent")[0],undefined,true);r.destroy();};
g.prototype.setLayout=function(n){n=this.validateProperty("layout",n);var s=this.getLayout();if(s===n){return this;}var r=this.setProperty("layout",n,true);this._oLayoutHistory.addEntry(n);this._hideShowArrows();this._resizeColumns();return r;};
g.prototype.setAutoFocus=function(n){n=this.validateProperty("autoFocus",n);var i=this.getAutoFocus();if(i===n){return this;}this._getNavContainers().forEach(function(o){o.setAutoFocus(n);});return this.setProperty("autoFocus",n,true);};
g.prototype.onBeforeRendering=function(){this._deregisterResizeHandler();this._oAnimationEndListener.cancelAll();};
g.prototype.onAfterRendering=function(){this._measureControlWidth();this._registerResizeHandler();this._cacheDOMElements();this._hideShowArrows();this._resizeColumns();this._flushColumnContent("begin");this._flushColumnContent("mid");this._flushColumnContent("end");this._fireStateChange(false,false);};
g.prototype._restoreFocusToColumn=function(s){var E=this._oColumnFocusInfo[s];if(!E||d(E)){E=this._getFirstFocusableElement(s);}q(E).trigger("focus");};
g.prototype._getFirstFocusableElement=function(s){var o=this._getColumnByStringName(s),i=o.getCurrentPage();if(i){return i.$().firstFocusableDomRef();}return null;};
g.prototype._isFocusInSomeOfThePreviousColumns=function(){var i=g.COLUMN_ORDER.indexOf(this._sPreviuosLastVisibleColumn)-1,o;for(;i>=0;i--){o=this._getColumnByStringName(g.COLUMN_ORDER[i]);if(o&&o._isFocusInControl(o)){return true;}}return false;};
g.prototype._getControlWidth=function(){if(this._iWidth===0){this._measureControlWidth();}return this._iWidth;};
g.prototype._measureControlWidth=function(){if(this.$().is(":visible")){this._iWidth=this.$().width();}else{this._iWidth=0;}};
g.prototype.exit=function(){this._removeNavContainersFocusOutDelegate();this._oRenderedColumnPagesBoolMap=null;this._oColumnFocusInfo=null;this._deregisterResizeHandler();this._handleEvent(q.Event("Destroy"));};
g.prototype._removeNavContainersFocusOutDelegate=function(){g.COLUMN_ORDER.forEach(function(s){this._getColumnByStringName(s).removeEventDelegate(this["_"+s+"ColumnFocusOutDelegate"]);},this);};
g.prototype._registerResizeHandler=function(){c(!this._iResizeHandlerId,"Resize handler already registered");this._iResizeHandlerId=R.register(this,this._onResize.bind(this));};
g.prototype._deregisterResizeHandler=function(){if(this._iResizeHandlerId){R.deregister(this._iResizeHandlerId);this._iResizeHandlerId=null;}};
g.prototype._initNavContainers=function(){this.setAggregation("_beginColumnNav",this._createNavContainer("begin"),true);this.setAggregation("_midColumnNav",this._createNavContainer("mid"),true);this.setAggregation("_endColumnNav",this._createNavContainer("end"),true);};
g.prototype._getNavContainers=function(){return[this._getBeginColumn(),this._getMidColumn(),this._getEndColumn()];};
g.prototype._initButtons=function(){var o=new B(this.getId()+"-beginBack",{icon:"sap-icon://slim-arrow-left",tooltip:g._getResourceBundle().getText("FCL_BEGIN_COLUMN_BACK_ARROW"),type:"Transparent",press:this._onArrowClick.bind(this,"left")}).addStyleClass("sapFFCLNavigationButton").addStyleClass("sapFFCLNavigationButtonRight");this.setAggregation("_beginColumnBackArrow",o,true);var M=new B(this.getId()+"-midForward",{icon:"sap-icon://slim-arrow-right",tooltip:g._getResourceBundle().getText("FCL_MID_COLUMN_FORWARD_ARROW"),type:"Transparent",press:this._onArrowClick.bind(this,"right")}).addStyleClass("sapFFCLNavigationButton").addStyleClass("sapFFCLNavigationButtonLeft");this.setAggregation("_midColumnForwardArrow",M,true);var i=new B(this.getId()+"-midBack",{icon:"sap-icon://slim-arrow-left",tooltip:g._getResourceBundle().getText("FCL_MID_COLUMN_BACK_ARROW"),type:"Transparent",press:this._onArrowClick.bind(this,"left")}).addStyleClass("sapFFCLNavigationButton").addStyleClass("sapFFCLNavigationButtonRight");this.setAggregation("_midColumnBackArrow",i,true);var E=new B(this.getId()+"-endForward",{icon:"sap-icon://slim-arrow-right",tooltip:g._getResourceBundle().getText("FCL_END_COLUMN_FORWARD_ARROW"),type:"Transparent",press:this._onArrowClick.bind(this,"right")}).addStyleClass("sapFFCLNavigationButton").addStyleClass("sapFFCLNavigationButtonLeft");this.setAggregation("_endColumnForwardArrow",E,true);};
g.prototype._cacheDOMElements=function(){this._cacheColumns();if(!D.system.phone){this._cacheArrows();}};
g.prototype._cacheColumns=function(){this._$columns={begin:this.$("beginColumn"),mid:this.$("midColumn"),end:this.$("endColumn")};};
g.prototype._cacheArrows=function(){this._oColumnSeparatorArrows={beginBack:this.$("beginBack"),midForward:this.$("midForward"),midBack:this.$("midBack"),endForward:this.$("endForward")};};
g.prototype._getVisibleColumnsCount=function(){return g.COLUMN_ORDER.filter(function(s){return this._getColumnSize(s)>0;},this).length;};
g.prototype._getVisibleArrowsCount=function(){if(!this._oColumnSeparatorArrows){return 0;}return Object.keys(this._oColumnSeparatorArrows).filter(function(s){return this._oColumnSeparatorArrows[s].data("visible");},this).length;};
g.prototype._getTotalColumnsWidth=function(H){var s=this._getVisibleArrowsCount();if(H){s++;}return this._getControlWidth()-s*this._iNavigationArrowWidth;};
g.prototype._resizeColumns=function(){var p,i,j=g.COLUMN_ORDER.slice(),r=sap.ui.getCore().getConfiguration().getRTL(),s=sap.ui.getCore().getConfiguration().getAnimationMode(),H=s!==a.AnimationMode.none&&s!==a.AnimationMode.minimal,k,v,n,o,t,I,u,w={};if(!this.isActive()){return;}v=this._getVisibleColumnsCount();if(v===0){return;}o=this.getLayout();n=this._getMaxColumnsCountForLayout(o,g.DESKTOP_BREAKPOINT);t=j[n-1];u=this.getRestoreFocusOnBackNavigation()&&this._isNavigatingBackward(t)&&!this._isFocusInSomeOfThePreviousColumns();I=(v===3)&&(o===f.ThreeColumnsEndExpanded);i=this._getTotalColumnsWidth(I);if(H){j.forEach(function(x){var S=this._shouldConcealColumn(n,x),y=this._shouldRevealColumn(n,x===t),z=this._$columns[x];z.toggleClass(g.PINNED_COLUMN_CLASS_NAME,S||y);},this);j.forEach(function(x){w[x]=this._oAnimationEndListener.isWaitingForColumnResizeEnd(this._$columns[x]);},this);this._oAnimationEndListener.cancelAll();}j.forEach(function(x){var y=this._$columns[x],z=y.get(0),E,G,S,J,K,M,O;p=this._getColumnSize(x);E=Math.round(i*(p/100));if([100,0].indexOf(p)!==-1){G=p+"%";}else{G=E+"px";}O={previousAnimationCompleted:!w[y],iNewWidth:E,shouldRestoreFocus:u&&(x===t),hidden:p===0&&this._oColumnWidthInfo[x]===0};if(H){S=this._shouldRevealColumn(n,x===t);J=this._shouldConcealColumn(n,x);K=S||J;O=e(O,{hasAnimations:true,shouldConcealColumn:J,pinned:K});M=this._canResizeColumnWithAnimation(x,O);}if(!J){y.toggleClass("sapFFCLColumnActive",p>0);}y.toggleClass("sapFFCLColumnInset",I&&(x==="mid"));y.removeClass("sapFFCLColumnHidden");y.removeClass("sapFFCLColumnOnlyActive");y.removeClass("sapFFCLColumnLastActive");y.removeClass("sapFFCLColumnFirstActive");if(M){R.suspend(z);this._oAnimationEndListener.waitForColumnResizeEnd(y).then(function(){R.resume(z);}).catch(function(){R.resume(z);});}if(!J){y.width(G);}else{this._oAnimationEndListener.waitForAllColumnsResizeEnd().then(function(){y.width(G);}).catch(function(){});}if(M||K){this._oAnimationEndListener.waitForAllColumnsResizeEnd().then(this._afterColumnResize.bind(this,x,O)).catch(function(){});}else{this._afterColumnResize(x,O);}if(!D.system.phone){this._updateColumnContextualSettings(x,E);this._updateColumnCSSClasses(x,E);}},this);k=j.filter(function(x){return this._getColumnSize(x)>0;},this);if(r){j.reverse();}if(k.length===1){this._$columns[k[0]].addClass("sapFFCLColumnOnlyActive");}if(k.length>1){this._$columns[k[0]].addClass("sapFFCLColumnFirstActive");this._$columns[k[k.length-1]].addClass("sapFFCLColumnLastActive");}this._storePreviousResizingInfo(n,t);};
g.prototype._afterColumnResize=function(s,o){var i=this._$columns[s],S=o.shouldConcealColumn,n=o.iNewWidth,j=o.shouldRestoreFocus;i.toggleClass(g.PINNED_COLUMN_CLASS_NAME,false);if(S){i.removeClass("sapFFCLColumnActive");}i.toggleClass("sapFFCLColumnHidden",n===0);this._cacheColumnWidth(s,n);if(j){this._restoreFocusToColumn(s);}};
g.prototype._getColumnWidth=function(s){var o=this._$columns[s].get(0),i=o.style.width,j=parseInt(i),p;if(/px$/.test(i)){return j;}p=/%$/.test(i);if(p&&(j===100)){return this._getControlWidth();}if(p&&(j===0)){return 0;}return o.offsetWidth;};
g.prototype._cacheColumnWidth=function(s,n){var E;if(this._oColumnWidthInfo[s]!==n){E={};g.COLUMN_ORDER.forEach(function(i){E[i+"Column"]=i===s;});this.fireColumnResize(E);}this._oColumnWidthInfo[s]=n;};
g.prototype._storePreviousResizingInfo=function(v,s){var o=this.getLayout();this._iPreviousVisibleColumnsCount=v;this._bWasFullScreen=o===f.MidColumnFullScreen||o===f.EndColumnFullScreen;this._sPreviuosLastVisibleColumn=s;};
g.prototype._isNavigatingBackward=function(s){return this._bWasFullScreen||g.COLUMN_ORDER.indexOf(this._sPreviuosLastVisibleColumn)>g.COLUMN_ORDER.indexOf(s);};
g.prototype._shouldRevealColumn=function(v,i){return(v>this._iPreviousVisibleColumnsCount)&&!this._bWasFullScreen&&i;};
g.prototype._shouldConcealColumn=function(v,s){return(v<this._iPreviousVisibleColumnsCount&&s===this._sPreviuosLastVisibleColumn&&!this._bWasFullScreen&&this._getColumnSize(s)===0);};
g.prototype._canResizeColumnWithAnimation=function(s,o){var i,j,n=o.iNewWidth,H=o.hasAnimations,p=o.pinned,k=o.hidden,w=!o.previousAnimationCompleted;if(!H||p||k){return false;}i=this._$columns[s];if(w){return i.width()!==n;}j=!i.get(0).style.width;if(j){return false;}return this._getColumnWidth(s)!==n;};
g.prototype._propagateContextualSettings=function(){};
g.prototype._updateColumnContextualSettings=function(s,w){var o,i;o=this.getAggregation("_"+s+"ColumnNav");if(!o){return;}i=o._getContextualSettings();if(!i||i.contextualWidth!==w){o._applyContextualSettings({contextualWidth:w});}};
g.prototype._updateColumnCSSClasses=function(s,w){var n="";this._$columns[s].removeClass("sapUiContainer-Narrow sapUiContainer-Medium sapUiContainer-Wide sapUiContainer-ExtraWide");if(w<D.media._predefinedRangeSets[D.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0]){n="Narrow";}else if(w<D.media._predefinedRangeSets[D.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1]){n="Medium";}else if(w<D.media._predefinedRangeSets[D.media.RANGESETS.SAP_STANDARD_EXTENDED].points[2]){n="Wide";}else{n="ExtraWide";}this._$columns[s].addClass("sapUiContainer-"+n);};
g.prototype._getColumnSize=function(s){var i=this.getLayout(),j=this._getColumnWidthDistributionForLayout(i),S=j.split("/"),M={begin:0,mid:1,end:2},k=S[M[s]];return parseInt(k);};
g.prototype.getMaxColumnsCount=function(){return this._getMaxColumnsCountForWidth(this._getControlWidth());};
g.prototype._getMaxColumnsCountForWidth=function(w){if(w>=g.DESKTOP_BREAKPOINT){return 3;}if(w>=g.TABLET_BREAKPOINT&&w<g.DESKTOP_BREAKPOINT){return 2;}if(w>0){return 1;}return 0;};
g.prototype._getMaxColumnsCountForLayout=function(s,w){var i=this._getMaxColumnsCountForWidth(w),j=this._getColumnWidthDistributionForLayout(s,false,i),S=j.split("/"),M={begin:0,mid:1,end:2},k,n,o=0;Object.keys(M).forEach(function(p){k=S[M[p]];n=parseInt(k);if(n){o++;}});return o;};
g.prototype._onResize=function(E){var o=E.oldSize.width,n=E.size.width,O,M;this._iWidth=n;if(n===0){return;}O=this._getMaxColumnsCountForWidth(o);M=this._getMaxColumnsCountForWidth(n);this._resizeColumns();if(M!==O){this._hideShowArrows();this._fireStateChange(false,true);}};
g.prototype._setColumnPagesRendered=function(i,H){this._oRenderedColumnPagesBoolMap[i]=H;};
g.prototype._hasAnyColumnPagesRendered=function(){return Object.keys(this._oRenderedColumnPagesBoolMap).some(function(k){return this._oRenderedColumnPagesBoolMap[k];},this);};
g.prototype._onArrowClick=function(s){var i=this.getLayout(),I=typeof g.SHIFT_TARGETS[i]!=="undefined"&&typeof g.SHIFT_TARGETS[i][s]!=="undefined",n;c(I,"An invalid layout was used for determining arrow behavior");n=I?g.SHIFT_TARGETS[i][s]:f.OneColumn;this.setLayout(n);if(g.ARROWS_NAMES[n][s]!==g.ARROWS_NAMES[i][s]&&I){var o=s==='right'?'left':'right';this._oColumnSeparatorArrows[g.ARROWS_NAMES[n][o]].focus();}this._fireStateChange(true,false);};
g.prototype._hideShowArrows=function(){var s=this.getLayout(),M={},n=[],i,I;if(!this.isActive()||D.system.phone){return;}i=this.getMaxColumnsCount();if(i>1){M[f.TwoColumnsBeginExpanded]=["beginBack"];M[f.TwoColumnsMidExpanded]=["midForward"];M[f.ThreeColumnsMidExpanded]=["midForward","midBack"];M[f.ThreeColumnsEndExpanded]=["endForward"];M[f.ThreeColumnsMidExpandedEndHidden]=["midForward","midBack"];M[f.ThreeColumnsBeginExpandedEndHidden]=["beginBack"];if(typeof M[s]==="object"){n=M[s];}}I=this._hasAnyColumnPagesRendered();Object.keys(this._oColumnSeparatorArrows).forEach(function(k){this._toggleButton(k,n.indexOf(k)!==-1,I);},this);};
g.prototype._toggleButton=function(s,S,r){this._oColumnSeparatorArrows[s].toggle(S&&r);this._oColumnSeparatorArrows[s].data("visible",S);};
g.prototype._fireStateChange=function(i,I){if(this._getControlWidth()===0){return;}this.fireStateChange({isNavigationArrow:i,isResize:I,layout:this.getLayout(),maxColumnsCount:this.getMaxColumnsCount()});};
g.prototype.setInitialBeginColumnPage=function(p){this._getBeginColumn().setInitialPage(p);this.setAssociation('initialBeginColumnPage',p,true);return this;};
g.prototype.setInitialMidColumnPage=function(p){this._getMidColumn().setInitialPage(p);this.setAssociation('initialMidColumnPage',p,true);return this;};
g.prototype.setInitialEndColumnPage=function(p){this._getEndColumn().setInitialPage(p);this.setAssociation('initialEndColumnPage',p,true);return this;};
g.prototype.to=function(p,t,o,T){if(this._getBeginColumn().getPage(p)){this._getBeginColumn().to(p,t,o,T);}else if(this._getMidColumn().getPage(p)){this._getMidColumn().to(p,t,o,T);}else{this._getEndColumn().to(p,t,o,T);}return this;};
g.prototype.backToPage=function(p,o,t){if(this._getBeginColumn().getPage(p)){this._getBeginColumn().backToPage(p,o,t);}else if(this._getMidColumn().getPage(p)){this._getMidColumn().backToPage(p,o,t);}else{this._getEndColumn().backToPage(p,o,t);}return this;};
g.prototype._safeBackToPage=function(p,t,i,T){if(this._getBeginColumn().getPage(p)){this._getBeginColumn()._safeBackToPage(p,t,i,T);}else if(this._getMidColumn().getPage(p)){this._getMidColumn()._safeBackToPage(p,t,i,T);}else{this._getEndColumn()._safeBackToPage(p,t,i,T);}};
g.prototype.toBeginColumnPage=function(p,t,o,T){this._getBeginColumn().to(p,t,o,T);return this;};
g.prototype.toMidColumnPage=function(p,t,o,T){this._getMidColumn().to(p,t,o,T);return this;};
g.prototype.toEndColumnPage=function(p,t,o,T){this._getEndColumn().to(p,t,o,T);return this;};
g.prototype.backBeginColumn=function(i,t){return this._getBeginColumn().back(i,t);};
g.prototype.backMidColumn=function(i,t){return this._getMidColumn().back(i,t);};
g.prototype.backEndColumn=function(i,t){return this._getEndColumn().back(i,t);};
g.prototype.backBeginColumnToPage=function(p,i,t){return this._getBeginColumn().backToPage(p,i,t);};
g.prototype.backMidColumnToPage=function(p,i,t){return this._getMidColumn().backToPage(p,i,t);};
g.prototype.backEndColumnToPage=function(p,i,t){return this._getEndColumn().backToPage(p,i,t);};
g.prototype.backToTopBeginColumn=function(o,t){this._getBeginColumn().backToTop(o,t);return this;};
g.prototype.backToTopMidColumn=function(o,t){this._getMidColumn().backToTop(o,t);return this;};
g.prototype.backToTopEndColumn=function(o,t){this._getEndColumn().backToTop(o,t);return this;};
g.prototype.getCurrentBeginColumnPage=function(){return this._getBeginColumn().getCurrentPage();};
g.prototype.getCurrentMidColumnPage=function(){return this._getMidColumn().getCurrentPage();};
g.prototype.getCurrentEndColumnPage=function(){return this._getEndColumn().getCurrentPage();};
g.prototype.setDefaultTransitionNameBeginColumn=function(t){this.setProperty("defaultTransitionNameBeginColumn",t,true);this._getBeginColumn().setDefaultTransitionName(t);return this;};
g.prototype.setDefaultTransitionNameMidColumn=function(t){this.setProperty("defaultTransitionNameMidColumn",t,true);this._getMidColumn().setDefaultTransitionName(t);return this;};
g.prototype.setDefaultTransitionNameEndColumn=function(t){this.setProperty("defaultTransitionNameEndColumn",t,true);this._getEndColumn().setDefaultTransitionName(t);return this;};
g.prototype._getLayoutHistory=function(){return this._oLayoutHistory;};
g.prototype._getColumnWidthDistributionForLayout=function(s,i,M){var o={},r;M||(M=this.getMaxColumnsCount());if(M===0){r="0/0/0";}else{o[f.OneColumn]="100/0/0";o[f.MidColumnFullScreen]="0/100/0";o[f.EndColumnFullScreen]="0/0/100";if(M===1){o[f.TwoColumnsBeginExpanded]="0/100/0";o[f.TwoColumnsMidExpanded]="0/100/0";o[f.ThreeColumnsMidExpanded]="0/0/100";o[f.ThreeColumnsEndExpanded]="0/0/100";o[f.ThreeColumnsMidExpandedEndHidden]="0/0/100";o[f.ThreeColumnsBeginExpandedEndHidden]="0/0/100";}else{o[f.TwoColumnsBeginExpanded]="67/33/0";o[f.TwoColumnsMidExpanded]="33/67/0";o[f.ThreeColumnsMidExpanded]=M===2?"0/67/33":"25/50/25";o[f.ThreeColumnsEndExpanded]=M===2?"0/33/67":"25/25/50";o[f.ThreeColumnsMidExpandedEndHidden]="33/67/0";o[f.ThreeColumnsBeginExpandedEndHidden]="67/33/0";}r=o[s];}if(i){r=r.split("/").map(function(j){return parseInt(j);});}return r;};
g.DESKTOP_BREAKPOINT=1280;g.TABLET_BREAKPOINT=960;g.ARROWS_NAMES={TwoColumnsBeginExpanded:{"left":"beginBack"},TwoColumnsMidExpanded:{"right":"midForward"},ThreeColumnsMidExpanded:{"left":"midBack","right":"midForward"},ThreeColumnsEndExpanded:{"right":"endForward"},ThreeColumnsMidExpandedEndHidden:{"left":"midBack","right":"midForward"},ThreeColumnsBeginExpandedEndHidden:{"left":"beginBack"}};
g._getResourceBundle=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.f");};
g.SHIFT_TARGETS={TwoColumnsBeginExpanded:{"left":f.TwoColumnsMidExpanded},TwoColumnsMidExpanded:{"right":f.TwoColumnsBeginExpanded},ThreeColumnsMidExpanded:{"left":f.ThreeColumnsEndExpanded,"right":f.ThreeColumnsMidExpandedEndHidden},ThreeColumnsEndExpanded:{"right":f.ThreeColumnsMidExpanded},ThreeColumnsMidExpandedEndHidden:{"left":f.ThreeColumnsMidExpanded,"right":f.ThreeColumnsBeginExpandedEndHidden},ThreeColumnsBeginExpandedEndHidden:{"left":f.ThreeColumnsMidExpandedEndHidden}};
function h(){this._aLayoutHistory=[];}
h.prototype.addEntry=function(s){if(typeof s!=="undefined"){this._aLayoutHistory.push(s);}};
h.prototype.getClosestEntryThatMatches=function(j){var i;for(i=this._aLayoutHistory.length-1;i>=0;i--){if(j.indexOf(this._aLayoutHistory[i])!==-1){return this._aLayoutHistory[i];}}};
function A(){this._oListeners={};this._aPendingPromises=[];this._oPendingPromises={};this._oCancelPromises={};this._oPendingPromiseAll=null;}
A.prototype.waitForColumnResizeEnd=function($){var i=$.get(0).id,p;if(!this._oPendingPromises[i]){p=new Promise(function(r,j){L.debug("FlexibleColumnLayout","wait for column "+i+" to resize");this._attachTransitionEnd($,function(){L.debug("FlexibleColumnLayout","completed column "+i+" resize");this._cleanUp($);r();}.bind(this));this._oCancelPromises[i]={cancel:function(){L.debug("FlexibleColumnLayout","cancel column "+i+" resize");this._cleanUp($);j();}.bind(this)};}.bind(this));this._aPendingPromises.push(p);this._oPendingPromises[i]=p;}return this._oPendingPromises[i];};
A.prototype.waitForAllColumnsResizeEnd=function(){if(!this._oPendingPromiseAll){this._oPendingPromiseAll=new Promise(function(r,i){this.iTimer=setTimeout(function(){Promise.all(this._aPendingPromises).then(function(){L.debug("FlexibleColumnLayout","completed all columns resize");r();},0).catch(function(){i();});this.iTimer=null;}.bind(this));}.bind(this));}return this._oPendingPromiseAll;};
A.prototype.isWaitingForColumnResizeEnd=function($){var i=$.get(0).id;return!!this._oListeners[i];};
A.prototype.cancelAll=function(){Object.keys(this._oCancelPromises).forEach(function(i){this._oCancelPromises[i].cancel();},this);this._oPendingPromises={};this._aPendingPromises=[];this._oCancelPromises={};this._oPendingPromiseAll=null;if(this.iTimer){clearTimeout(this.iTimer);this.iTimer=null;}L.debug("FlexibleColumnLayout","detached all listeners for columns resize");};
A.prototype._attachTransitionEnd=function($,i){var I=$.get(0).id;if(!this._oListeners[I]){$.on("webkitTransitionEnd transitionend",i);this._oListeners[I]=i;}};
A.prototype._detachTransitionEnd=function($){var i=$.get(0).id;if(this._oListeners[i]){$.off("webkitTransitionEnd transitionend",this._oListeners[i]);this._oListeners[i]=null;}};
A.prototype._cleanUp=function($){if($.length){var i=$.get(0).id;this._detachTransitionEnd($);delete this._oPendingPromises[i];delete this._oCancelPromises[i];}};
return g;});
sap.ui.predefine('sap/f/FlexibleColumnLayoutRenderer',["sap/ui/core/InvisibleText","sap/ui/Device","sap/m/library"],function(I,D,m){"use strict";var F={apiVersion:2};
F.render=function(r,c){var b=c.getBackgroundDesign();r.openStart("div",c);r.class("sapFFCL");if(b!==m.BackgroundDesign.Transparent){r.class("sapFFCLBackgroundDesign"+b);}r.openEnd();F.renderBeginColumn(r,c);F.renderMidColumn(r,c);F.renderEndColumn(r,c);r.close("div");};
F.renderBeginColumn=function(r,c){var b=c.getAggregation("_beginColumnBackArrow");r.openStart("div",c.getId()+"-beginColumn");r.accessibilityState(c,{role:"region",labelledby:I.getStaticId("sap.f","FCL_BEGIN_COLUMN_REGION_TEXT")});r.class("sapFFCLColumn");r.class("sapFFCLColumnBegin");r.class("sapFFCLColumnActive");r.openEnd();F.renderColumnContentWrapper(r);r.close("div");F.renderArrow(r,b);};
F.renderMidColumn=function(r,c){var M=c.getAggregation("_midColumnForwardArrow"),o=c.getAggregation("_midColumnBackArrow");F.renderArrow(r,M);r.openStart("div",c.getId()+"-midColumn");r.accessibilityState(c,{role:"region",labelledby:I.getStaticId("sap.f","FCL_MID_COLUMN_REGION_TEXT")});r.class("sapFFCLColumn");r.class("sapFFCLColumnMid");r.openEnd();F.renderColumnContentWrapper(r);r.close("div");F.renderArrow(r,o);};
F.renderEndColumn=function(r,c){var e=c.getAggregation("_endColumnForwardArrow");F.renderArrow(r,e);r.openStart("div",c.getId()+"-endColumn");r.accessibilityState(c,{role:"region",labelledby:I.getStaticId("sap.f","FCL_END_COLUMN_REGION_TEXT")});r.class("sapFFCLColumn");r.class("sapFFCLColumnEnd");r.openEnd();F.renderColumnContentWrapper(r);r.close("div");};
F.renderArrow=function(r,a){if(!D.system.phone){r.openStart("div");r.class("sapFFCLArrow");r.class("sapContrastPlus");r.openEnd();r.renderControl(a);r.close("div");}};
F.renderColumnContentWrapper=function(r){r.openStart("div");r.class("sapFFCLColumnContent");r.openEnd();r.close("div");};
return F;},true);
sap.ui.predefine('sap/f/FlexibleColumnLayoutSemanticHelper',["./library","./FlexibleColumnLayout","sap/base/assert"],function(l,F,a){"use strict";var L=l.LayoutType;var b=function(f,s){var m={Normal:3,MasterDetail:2,SingleColumn:1},i,M;s||(s={});this._oFCL=f;this._defaultLayoutType=L.OneColumn;this._defaultTwoColumnLayoutType=[L.TwoColumnsBeginExpanded,L.TwoColumnsMidExpanded].indexOf(s.defaultTwoColumnLayoutType)!==-1?s.defaultTwoColumnLayoutType:L.TwoColumnsBeginExpanded;this._defaultThreeColumnLayoutType=[L.ThreeColumnsMidExpanded,L.ThreeColumnsEndExpanded].indexOf(s.defaultThreeColumnLayoutType)!==-1?s.defaultThreeColumnLayoutType:L.ThreeColumnsMidExpanded;if(["Normal","MasterDetail","SingleColumn"].indexOf(s.mode)!==-1&&!s.maxColumnsCount){M=m[s.mode];}else{M=s.maxColumnsCount?parseInt(s.maxColumnsCount):3;if(M<1||M>3){M=3;}}this._maxColumnsCount=M;i=s.initialColumnsCount?parseInt(s.initialColumnsCount):1;if(i<1||i>2||this._maxColumnsCount===1){i=1;}this._initialColumnsCount=i;};b._oInstances={};
b.getInstanceFor=function(f,s){a(f instanceof F,"Passed control is not FlexibleColumnLayout");var i=f.getId();if(typeof b._oInstances[i]==="undefined"){b._oInstances[i]=new b(f,s);var d={onDestroy:function(){delete b._oInstances[i];}};f.addEventDelegate(d);}return b._oInstances[i];};
b.prototype.getCurrentUIState=function(){var c=this._oFCL.getLayout();return this._getUIStateForLayout(c);};
b.prototype.getNextUIState=function(n){var c=this._oFCL.getLayout(),i=this._initialColumnsCount,N;if(n===0){if(i===2&&this._canShowTwoColumns()){N=this._defaultTwoColumnLayoutType;}else{N=L.OneColumn;}}if(n===1){if(this._maxColumnsCount===1){N=L.MidColumnFullScreen;}else{if([L.TwoColumnsBeginExpanded,L.TwoColumnsMidExpanded].indexOf(c)!==-1){N=c;}else if([L.MidColumnFullScreen,L.EndColumnFullScreen].indexOf(c)!==-1){N=L.MidColumnFullScreen;}else{N=this._defaultTwoColumnLayoutType;}}}if(n===2){if(this._maxColumnsCount<3){N=L.EndColumnFullScreen;}else{if([L.ThreeColumnsMidExpandedEndHidden,L.ThreeColumnsBeginExpandedEndHidden].indexOf(c)!==-1){N=this._defaultThreeColumnLayoutType;}else if([L.ThreeColumnsMidExpanded,L.ThreeColumnsEndExpanded].indexOf(c)!==-1){N=c;}else if([L.MidColumnFullScreen,L.EndColumnFullScreen].indexOf(c)!==-1){N=L.EndColumnFullScreen;}else{N=this._defaultThreeColumnLayoutType;}}}if(n>2){N=L.EndColumnFullScreen;}return this._getUIStateForLayout(N);};
b.prototype._getUIStateForLayout=function(s){var S=this._oFCL._getColumnWidthDistributionForLayout(s,true),c=S.join("/"),m=this._oFCL.getMaxColumnsCount();return{layout:s,maxColumnsCount:m,columnsSizes:this._getColumnsSizes(S),columnsVisibility:this._getColumnsVisibility(S),isFullScreen:this._getIsFullScreen(S),isLogicallyFullScreen:this._getIsLogicallyFullScreen(s),actionButtonsInfo:this._getActionButtonsInfo(c,m)};};
b.prototype._getColumnsSizes=function(s){return{beginColumn:s[0],midColumn:s[1],endColumn:s[2]};};
b.prototype._getColumnsVisibility=function(s){return{beginColumn:s[0]!==0,midColumn:s[1]!==0,endColumn:s[2]!==0};};
b.prototype._getIsFullScreen=function(s){return s.indexOf(100)!==-1;};
b.prototype._getIsLogicallyFullScreen=function(s){return[L.OneColumn,L.MidColumnFullScreen,L.EndColumnFullScreen].indexOf(s)!==-1;};
b.prototype._getActionButtonsInfo=function(c,m){var M={fullScreen:null,exitFullScreen:null,closeColumn:null},e={fullScreen:null,exitFullScreen:null,closeColumn:null},E,s;if(this._maxColumnsCount===1){return{midColumn:M,endColumn:e};}if(m===1){M.closeColumn=this._defaultLayoutType;e.closeColumn=this._defaultTwoColumnLayoutType;}else{if(c==="67/33/0"||c==="33/67/0"){M.fullScreen=L.MidColumnFullScreen;M.closeColumn=this._defaultLayoutType;}if(c==="25/50/25"||c==="25/25/50"||c==="0/67/33"||c==="0/33/67"){e.fullScreen=L.EndColumnFullScreen;e.closeColumn=this._defaultTwoColumnLayoutType;}if(c==="0/100/0"){E=[L.TwoColumnsBeginExpanded,L.TwoColumnsMidExpanded,L.ThreeColumnsBeginExpandedEndHidden,L.ThreeColumnsMidExpandedEndHidden];s=this._oFCL._getLayoutHistory().getClosestEntryThatMatches(E)||this._defaultTwoColumnLayoutType;M.exitFullScreen=s;M.closeColumn=this._defaultLayoutType;}if(c==="0/0/100"){if(this._maxColumnsCount!==2){E=[L.ThreeColumnsMidExpanded,L.ThreeColumnsEndExpanded];s=this._oFCL._getLayoutHistory().getClosestEntryThatMatches(E)||this._defaultThreeColumnLayoutType;e.exitFullScreen=s;e.closeColumn=this._defaultTwoColumnLayoutType;}}}return{midColumn:M,endColumn:e};};
b.prototype.getDefaultLayouts=function(){return{defaultLayoutType:this._defaultLayoutType,defaultTwoColumnLayoutType:this._defaultTwoColumnLayoutType,defaultThreeColumnLayoutType:this._defaultThreeColumnLayoutType};};
b.prototype._canShowTwoColumns=function(){var c=this._oFCL._getControlWidth(),m=this._oFCL._getMaxColumnsCountForWidth(c||window.innerWidth);return m>1;};
b.prototype.isReady=function(){return this.isDOMReady();};
b.prototype.isDOMReady=function(){return this._oFCL.getDomRef()!==null;};
b.prototype.whenReady=function(){var t=this;return new Promise(function(r,c){t.whenDOMReady().then(function(){r();}).catch(function(d){c(d);});});};
b.prototype.whenDOMReady=function(){var t=this;var d=new Promise(function(r,c){if(!t._oFCL||t._oFCL.bIsDestroyed){c('FlexibleColumnLayout reference missing. Please make sure FlexibleColumnLayoutSemanticHelper is properly initialized.');}if(t._oFCL.getDomRef()){r();}else{var D={onAfterRendering:function(){t._oFCL.removeEventDelegate(D);r();}};t._oFCL.addEventDelegate(D);}});return d;};
return b;},true);
sap.ui.predefine('sap/f/GridContainer',["./GridContainerRenderer","./GridContainerSettings","./GridContainerUtils","./delegate/GridContainerItemNavigation","./library","./dnd/GridKeyboardDragAndDrop","sap/base/strings/capitalize","sap/ui/base/ManagedObjectObserver","sap/ui/core/Control","sap/ui/core/Core","sap/ui/core/ResizeHandler","sap/ui/core/delegate/ItemNavigation","sap/ui/core/InvisibleRenderer","sap/ui/Device","sap/ui/events/KeyCodes","sap/ui/layout/cssgrid/VirtualGrid","sap/ui/thirdparty/jquery"],function(G,a,b,c,l,d,e,M,C,f,R,I,g,D,K,V,q){"use strict";var h=f.getConfiguration().getRTL();var E=16;var o=["sap.f.Card","sap.ui.integration.widgets.Card","sap.m.GenericTile"];
function j(){return!D.browser.msie&&!(D.browser.edge&&D.browser.version<E);}
function m(i){var k=i.getLayoutData();return k?k.getColumns():1;}
function n(i){var k=i.getLayoutData();return k?k.getActualRows():1;}
function p(i){var k=i.getLayoutData();return k?k.hasAutoHeight():true;}
var r=C.extend("sap.f.GridContainer",{metadata:{library:"sap.f",interfaces:["sap.f.dnd.IGridDroppable"],properties:{width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:""},minHeight:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"2rem"},containerQuery:{type:"boolean",group:"Behavior",defaultValue:false},snapToRow:{type:"boolean",group:"Appearance",defaultValue:false},allowDenseFill:{type:"boolean",group:"Appearance",defaultValue:false},inlineBlockLayout:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.core.Control",multiple:true,singularName:"item",dnd:true},layout:{type:"sap.f.GridContainerSettings",multiple:false},layoutXS:{type:"sap.f.GridContainerSettings",multiple:false},layoutS:{type:"sap.f.GridContainerSettings",multiple:false},layoutM:{type:"sap.f.GridContainerSettings",multiple:false},layoutL:{type:"sap.f.GridContainerSettings",multiple:false},layoutXL:{type:"sap.f.GridContainerSettings",multiple:false},_defaultLayout:{type:"sap.f.GridContainerSettings",multiple:false,visibility:"hidden"}},events:{layoutChange:{parameters:{layout:{type:"string"}}},borderReached:{parameters:{event:{type:"jQuery.Event"}}}},dnd:{draggable:false,droppable:true}}});
r.prototype.bUseExtendedChangeDetection=true;
r.prototype.getActiveLayoutSettings=function(){var s=this.getAggregation(this._sActiveLayout);if(!s&&this._sActiveLayout==="layoutXS"){s=this.getAggregation("layoutS");}if(!s){s=this.getAggregation("layout")||this.getAggregation("_defaultLayout");}return s;};
r.prototype._onBeforeItemRendering=function(){var i=this.getParent();if(i._reflectItemVisibilityToWrapper(this)&&!j()){i._scheduleIEPolyfill();}};
r.prototype._onAfterItemRendering=function(){var i=this.getParent(),F;if(i._hasOwnVisualFocus(this)){F=this.getFocusDomRef();F.setAttribute("tabindex",-1);F.tabIndex=-1;}if(!i._resizeListeners[this.getId()]){i._resizeListeners[this.getId()]=R.register(this,i._resizeItemHandler);}i._setItemNavigationItems();if(!j()){i._scheduleIEPolyfill();return;}i._applyItemAutoRows(this);};
r.prototype._reflectItemVisibilityToWrapper=function(i){var k=this._getItemWrapper(i),$;if(!k){return false;}$=q(k);if(i.getVisible()&&$.hasClass("sapFGridContainerInvisiblePlaceholder")){$.removeClass("sapFGridContainerInvisiblePlaceholder");}else if(!i.getVisible()&&!$.hasClass("sapFGridContainerInvisiblePlaceholder")){$.addClass("sapFGridContainerInvisiblePlaceholder");return true;}return false;};
r.prototype._onItemChange=function(i){if(i.name!=="items"||!i.child){return;}if(i.mutation==="insert"){i.child.addEventDelegate(this._itemDelegate,i.child);}else if(i.mutation==="remove"){i.child.removeEventDelegate(this._itemDelegate,i.child);}};
r.prototype._deregisterResizeListeners=function(){var k,i;for(k in this._resizeListeners){i=this._resizeListeners[k];R.deregister(i);}delete this._resizeListeners;D.resize.detachHandler(this._resizeDeviceHandler);};
r.prototype._setItemNavigationItems=function(){if(!this._isRenderingFinished){return;}var t=this,w=[];if(!t._oItemNavigation){t._oItemNavigation=new c().setCycling(false).attachEvent(I.Events.BorderReached,this._onItemNavigationBorderReached,this).setDisabledModifiers({sapnext:["alt","meta","ctrl"],sapprevious:["alt","meta","ctrl"]}).setFocusedIndex(0);t.addDelegate(this._oItemNavigation);}t.$().children().map(function(i,W){if(W.getAttribute("class").indexOf("sapFGridContainerItemWrapper")>-1){w.push(W);}});t._oItemNavigation.setRootDomRef(t.getDomRef());t._oItemNavigation.setItemDomRefs(w);};
r.prototype._detectActiveLayout=function(){var w=(this.getContainerQuery()&&this.getDomRef())?this._getComputedWidth():D.resize.width,i=D.media.getCurrentRange("GridContainerRangeSet",w),L="layout"+i.name,O=this.getActiveLayoutSettings(),s=false;if(!w){return false;}if(this._sActiveLayout!==L){this.addStyleClass("sapFGridContainer"+e(L));if(this._sActiveLayout){this.removeStyleClass("sapFGridContainer"+e(this._sActiveLayout));}this._sActiveLayout=L;s=O!==this.getActiveLayoutSettings();this.fireLayoutChange({layout:this._sActiveLayout});}return s;};
r.prototype._getActiveGridStyles=function(){var s=this.getActiveLayoutSettings(),i=s.getColumns()||"auto-fill",k=s.getColumnSize(),t=s.getMinColumnSize(),u=s.getMaxColumnSize(),S={"grid-gap":s.getGap()};if(t&&u){S["grid-template-columns"]="repeat("+i+", minmax("+t+", "+u+"))";}else{S["grid-template-columns"]="repeat("+i+", "+k+")";}if(this.getInlineBlockLayout()){S["grid-auto-rows"]="min-content";}else{S["grid-auto-rows"]=s.getRowSize();}return S;};
r.prototype.init=function(){this._oRb=f.getLibraryResourceBundle("sap.f");this.setAggregation("_defaultLayout",new a());this._initRangeSet();this._resizeListeners={};this._oItemNavigation=null;this._itemDelegate={onBeforeRendering:this._onBeforeItemRendering,onAfterRendering:this._onAfterItemRendering};this._itemsObserver=new M(this._onItemChange.bind(this));this._itemsObserver.observe(this,{aggregations:["items"]});this._resizeHandler=this._resize.bind(this);this._resizeDeviceHandler=this._resizeDevice.bind(this);D.resize.attachHandler(this._resizeDeviceHandler);this._resizeItemHandler=this._resizeItem.bind(this);if(!j()){this._attachDndPolyfill();}};
r.prototype.insertItem=function(i,k){this.insertAggregation("items",i,k,true);if(!this.getDomRef()||!j()||!i.getVisible()){this.invalidate();return this;}var s=f.createRenderManager(),w=this._createItemWrapper(i),N=this._getItemAt(k+1),t=this.getDomRef();if(N){t.insertBefore(w,this._getItemWrapper(N));}else{t.insertBefore(w,t.lastChild);}i.addStyleClass("sapFGridContainerItemInnerWrapper");s.render(i,w);s.destroy();return this;};
r.prototype.removeItem=function(i){var k=this.removeAggregation("items",i,true),s=this.getDomRef(),t=k.getDomRef();if(!s||!t||!j()){this.invalidate();return k;}s.removeChild(t.parentElement);return k;};
r.prototype.onBeforeRendering=function(){this._detectActiveLayout();var i=this._resizeListeners[this.getId()];if(i){R.deregister(i);}this._isRenderingFinished=false;};
r.prototype.onAfterRendering=function(){this._resizeListeners[this.getId()]=R.register(this.getDomRef(),this._resizeHandler);this._isRenderingFinished=true;this._setItemNavigationItems();this._applyLayout(true);if(this.getItems().length===1&&this._forceFocus){this.focusItem(0);this._forceFocus=false;}};
r.prototype.exit=function(){this._deregisterResizeListeners();if(this._itemsObserver){this._itemsObserver.disconnect();delete this._itemsObserver;}if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;this._oItemNavigation=null;}if(!j()){this._detachDndPolyfill();}this._forceFocus=null;};
r.prototype._initRangeSet=function(){if(!D.media.hasRangeSet("GridContainerRangeSet")){D.media.initRangeSet("GridContainerRangeSet",[375,600,1024,1440],"px",["XS","S","M","L","XL"]);}};
r.prototype._resize=function(){if(!this._isWidthChanged()){return;}var s=this._detectActiveLayout();this._applyLayout(s);};
r.prototype._resizeDevice=function(){if(!this.getContainerQuery()){this._resize();}};
r.prototype._isWidthChanged=function(){var i=this._getComputedWidth(),v=D.resize.width;if(this._lastGridWidth===i&&this._lastViewportWidth===v){return false;}this._lastGridWidth=i;this._lastViewportWidth=v;return true;};
r.prototype._getComputedWidth=function(){if(!this.getDomRef()){return null;}return this.getDomRef().getBoundingClientRect().width;};
r.prototype._resizeItem=function(i){if(!j()){if(!this._bDraggingInAnotherContainer){this._scheduleIEPolyfill();}this._bDraggingInAnotherContainer=false;return;}this._applyItemAutoRows(i.control);};
r.prototype._applyLayout=function(s){if(!this._isRenderingFinished){return;}if(!j()){this._scheduleIEPolyfill(s);return;}if(s){this.$().css(this._getActiveGridStyles());this.getItems().forEach(this._applyItemAutoRows.bind(this));}this._enforceMaxColumns();};
r.prototype._applyItemAutoRows=function(i){if(!this._isRenderingFinished){return;}if(this.getInlineBlockLayout()){return;}if(p(i)){var $=i.$(),s=this.getActiveLayoutSettings(),k=s.calculateRowsForItem($.outerHeight());if(!k){return;}$.parent().css({'grid-row':'span '+Math.max(k,n(i))});}};
r.prototype._enforceMaxColumns=function(){var s=this.getActiveLayoutSettings(),i=s.getComputedColumnsCount(this.$().innerWidth());if(!i){return;}this.getItems().forEach(function(k){k.$().parent().css("grid-column","span "+Math.min(m(k),i));});};
r.prototype._getItemAt=function(i){var k=this.getItems(),t;if(i<0){i=0;}if(k.length&&k[i]){t=k[i];}return t;};
r.prototype._createItemWrapper=function(i){var s=G.getStylesForItemWrapper(i,this),S=s.styles,k=s.classes,w=document.createElement("div");w.setAttribute("tabindex","0");S.forEach(function(v,t){w.style.setProperty(t,v);});k.forEach(function(v){w.classList.add(v);});return w;};
r.prototype._scheduleIEPolyfill=function(i){if(this._iPolyfillCallId){clearTimeout(this._iPolyfillCallId);}if(i){this._applyIEPolyfillLayout();return;}this._iPolyfillCallId=setTimeout(this._applyIEPolyfillLayout.bind(this),0);};
r.prototype._applyIEPolyfillLayout=function(){if(!this._isRenderingFinished){return;}if(this.bIsDestroyed){return;}var $=this.$(),s=$.innerWidth(),S=this.getActiveLayoutSettings(),t=S.getMinColumnSizeInPx()||S.getColumnSizeInPx(),u=S.getRowSizeInPx(),v=S.getGapInPx(),w=S.getComputedColumnsCount(s),x=parseInt($.css("padding-top").replace("px","")),y=parseInt($.css("padding-left").replace("px","")),z=this.getItems();if(!t||!u){return;}if(!z.length){return;}var A=new V();A.init({numberOfCols:Math.max(1,w),cellWidth:t,cellHeight:u,unitOfMeasure:"px",gapSize:v,topOffset:x?x:0,leftOffset:y?y:0,allowDenseFill:this.getAllowDenseFill(),rtl:h,width:s});var i,k,B,F,H,J,L=[];var N=function(O){A.fitElement(O+'',this._polyfillDropIndicator.columns||S.calculateColumnsForItem(Math.round(this._polyfillDropIndicator.width)),this._polyfillDropIndicator.rows||S.calculateRowsForItem(Math.round(this._polyfillDropIndicator.height)));L.push({id:O+'',domRef:this._polyfillDropIndicator.domRef});}.bind(this);for(i=0,k=0;i<z.length;i++){if(this._polyfillDropIndicator&&this._polyfillDropIndicator.insertAt===i){N(k);k++;}B=z[i];F=B.$();if(!F.is(":visible")){continue;}H=m(B);if(p(B)){J=this._calcAutoRowsForPolyfill(B,S);}else{J=n(B);}A.fitElement(k+'',H,J);L.push({id:k+'',domRef:F.parent()});k++;}if(this._polyfillDropIndicator&&this._polyfillDropIndicator.insertAt>=z.length){N(z.length);}A.calculatePositions();L.forEach(function(O){var P=A.getItems()[O.id];O.domRef.css({position:'absolute',top:P.top,left:P.left,width:P.width,height:P.height});});$.css("height",A.getHeight()+"px");if(!this.getWidth()&&S.getColumns()){if(!this.getContainerQuery()){$.css("width",A.getWidth()+"px");}}};
r.prototype._calcAutoRowsForPolyfill=function(i,k){var $=i.$(),s,t;if($.hasClass("sapFCardAnalytical")){s=$[0].scrollHeight;}else{s=$.outerHeight();}t=Math.max(k.calculateRowsForItem(s),n(i));return t;};
r.prototype._polyfillAfterDragOver=function(i){var $=i.getParameter("indicator");this._polyfillDropIndicator={rows:i.getParameter("rows"),columns:i.getParameter("columns"),width:i.getParameter("width"),height:i.getParameter("height"),domRef:$,insertAt:i.getParameter("indicatorIndex")};this._scheduleIEPolyfill();};
r.prototype._polyfillAfterDragEnd=function(i){this._polyfillDropIndicator=null;};
r.prototype._polyfillDraggingInAnotherContainer=function(){this._bDraggingInAnotherContainer=true;};
r.prototype._attachDndPolyfill=function(){this.attachEvent("_gridPolyfillAfterDragOver",this._polyfillAfterDragOver,this);this.attachEvent("_gridPolyfillAfterDragEnd",this._polyfillAfterDragEnd,this);this.attachEvent("_gridPolyfillDraggingInAnotherContainer",this._polyfillDraggingInAnotherContainer,this);};
r.prototype._detachDndPolyfill=function(){this.detachEvent("_gridPolyfillAfterDragOver",this._polyfillAfterDragOver,this);this.detachEvent("_gridPolyfillAfterDragEnd",this._polyfillAfterDragEnd,this);this.detachEvent("_gridPolyfillDraggingInAnotherContainer",this._polyfillDraggingInAnotherContainer,this);};
r.prototype._onItemNavigationBorderReached=function(i){this.fireEvent("borderReached",{event:i instanceof q.Event?i:i.getParameter("event")});};
r.prototype.onsapnext=function(i){var k=this._oItemNavigation.getItemDomRefs();if(k.indexOf(i.target)===-1){i.stopImmediatePropagation(true);}var s=q(i.target.firstElementChild).control(0);if(i.keyCode===K.ARROW_DOWN){i.stopImmediatePropagation(true);var N=this._getClosestItemBelowInThisContainer(s);if(N){this._getItemWrapper(N).focus();}else{this._onItemNavigationBorderReached(i);}}};
r.prototype.onsapprevious=function(i){var k=this._oItemNavigation.getItemDomRefs();if(k.indexOf(i.target)===-1){i.stopImmediatePropagation(true);}var s=q(i.target.firstElementChild).control(0);if(i.keyCode===K.ARROW_UP){i.stopImmediatePropagation(true);var N=this._getClosestItemAboveInThisContainer(s);if(N){this._getItemWrapper(N).focus();}else{this._onItemNavigationBorderReached(i);}}};
["onkeypress","onkeyup","onkeydown","onsapenter","onsapselect","onsapspace"].forEach(function(N){r.prototype[N]=function(i){if(!this._isItemWrapper(i.target)){return;}if(N==="onsapspace"){i.preventDefault();}var k=q(i.target.firstChild).control()[0];if(k){var F=k.getFocusDomRef(),s=q(F).control()[0];if(s&&s[N]){s[N].call(s,i);}}};});
r.prototype._hasOwnVisualFocus=function(i){return o.indexOf(i.getMetadata().getName())>-1;};
r.prototype._moveItem=function(i){if(!this._isItemWrapper(i.target)){return;}var k=q(i.target.firstElementChild).control(0),L=this.getItems().length,s=this.indexOfItem(k),t=-1,u=null,v="After";switch(i.keyCode){case K.ARROW_RIGHT:t=f.getConfiguration().getRTL()?s-1:s+1;if(t>=0&&t<L){u=this.getItems()[t];}break;case K.ARROW_LEFT:t=f.getConfiguration().getRTL()?s+1:s-1;if(t>=0&&t<L){u=this.getItems()[t];}break;case K.ARROW_UP:u=this._getClosestItemAbove(k);if(!u||(u.isA("sap.f.GridContainer")&&!u.getItems().length)){break;}if(this!==u.getParent()){v="Before";}break;case K.ARROW_DOWN:u=this._getClosestItemBelow(k);if(!u||(u.isA("sap.f.GridContainer")&&!u.getItems().length)){break;}if(this!==u.getParent()){v="Before";}break;default:break;}t=this.indexOfItem(u);if(!u){return;}i.stopPropagation();if(!u.isA("sap.f.GridContainer")&&this===u.getParent()&&t<s){v="Before";}d.fireDnDByKeyboard(k,u,v,i);this._setItemNavigationItems();};
r.prototype.onsapincreasemodifiers=r.prototype._moveItem;r.prototype.onsapdecreasemodifiers=r.prototype._moveItem;
r.prototype._getClosestItemBelowInThisContainer=function(i){var k=this.getItems().map(this._getItemWrapper).filter(function(w){return b.isBelow(i,w);});var s=b.findClosest(i,k);if(s){return q(s.firstElementChild).control(0);}return null;};
r.prototype._getClosestItemBelow=function(i){var k=this._getClosestItemBelowInThisContainer(i);if(k){return k;}var s=Array.from(document.querySelectorAll(".sapFGridContainer")).filter(function(v){return b.isBelow(i,v);});var t=b.findClosestGridContainer(i,s);if(!t){return null;}var u=[];q(t).control(0).getItems().forEach(function(i){u.push(i.getDomRef());});if(u.length){k=b.findClosest(i,u);return q(k).control(0);}return q(t).control(0);};
r.prototype._getClosestItemAboveInThisContainer=function(i){var k=this.getItems().map(this._getItemWrapper).filter(function(w){return b.isAbove(i,w);});var s=b.findClosest(i,k);if(s){return q(s.firstElementChild).control(0);}return null;};
r.prototype._getClosestItemAbove=function(i){var k=this._getClosestItemAboveInThisContainer(i);if(k){return k;}var s=Array.from(document.querySelectorAll(".sapFGridContainer")).filter(function(v){return b.isAbove(i,v);});var t=b.findClosestGridContainer(i,s);if(!t){return null;}var u=[];q(t).control(0).getItems().forEach(function(i){u.push(i.getDomRef());});if(u.length){k=b.findClosest(i,u);return q(k).control(0);}return q(t).control(0);};
r.prototype.focusItem=function(i){var k,s=this._oItemNavigation;this._forceFocus=true;this._setItemNavigationItems();k=s.getItemDomRefs();if(k[i]){s.setFocusedIndex(i);k[i].focus();}};
r.prototype._isItemWrapper=function(i){return i.classList.contains("sapFGridContainerItemWrapper");};
r.prototype._getItemWrapper=function(i){var k=i.getDomRef(),s;if(k){return k.parentElement;}s=document.getElementById(g.createInvisiblePlaceholderId(i));if(s){return s.parentElement;}return null;};
return r;});
sap.ui.predefine('sap/f/GridContainerItemLayoutData',['sap/ui/core/LayoutData'],function(L){"use strict";
var G=L.extend("sap.f.GridContainerItemLayoutData",{metadata:{library:"sap.f",properties:{columns:{type:"int",group:"Misc",defaultValue:1},minRows:{type:"int",group:"Misc"},rows:{type:"int",group:"Misc"}}}});
G.prototype.hasAutoHeight=function(){return!this.getRows();};
G.prototype.getActualRows=function(){return Math.max(this.getRows()||1,this.getMinRows()||1);};
return G;});
sap.ui.predefine('sap/f/GridContainerRenderer',["sap/ui/Device"],function(D){"use strict";var G={apiVersion:2};
G.render=function(r,c){r.openStart('div',c);r.accessibilityState(c,{role:"list",roledescription:c._oRb.getText("GRIDCONTAINER_ROLEDESCRIPTION")});r.class("sapFGridContainer");if(c.getSnapToRow()){r.class("sapFGridContainerSnapToRow");}if(c.getAllowDenseFill()){r.class("sapFGridContainerDenseFill");}if(c.getWidth()){r.style("width",c.getWidth());}if(c.getMinHeight()){r.style("min-height",c.getMinHeight());}this.addGridStyles(r,c);var t=c.getTooltip_AsString();if(t){r.attr("title",t);}r.openEnd();this.renderDummyArea(r,c,"before",-1);var i=0,I=c.getItems();for(i=0;i<I.length;i++){this.renderItem(r,I[i],c,i,I.length);}this.renderDummyArea(r,c,"after",-1);r.close("div");};
G.addGridStyles=function(r,c){var s=c._getActiveGridStyles();for(var n in s){r.style(n,s[n]);}};
G.renderItem=function(r,i,c,I,s){var S=G.getStylesForItemWrapper(i,c),m=S.styles,C=S.classes;r.openStart("div",c.getId()+"-item-"+I);r.accessibilityState(c,{role:"listitem",labelledby:i.getId()});m.forEach(function(v,k){r.style(k,v);});C.forEach(function(v){r.class(v);});r.attr("tabindex","0");r.openEnd();i.addStyleClass("sapFGridContainerItemInnerWrapper");r.renderControl(i);r.close("div");};
G.getStylesForItemWrapper=function(i,c){var s=new Map(),C=["sapFGridContainerItemWrapper"];var l=i.getLayoutData();if(l){var I=l.getColumns(),t=c.getActiveLayoutSettings().getColumns();if(I&&t){I=Math.min(I,t);}if(I){s.set("grid-column","span "+I);}if(c.getInlineBlockLayout()){s.set("grid-row","span 1");}else if(l.getRows()||l.getMinRows()){s.set("grid-row","span "+l.getActualRows());}if(!l.hasAutoHeight()){C.push("sapFGridContainerItemFixedRows");}}if(!i.getVisible()){C.push("sapFGridContainerInvisiblePlaceholder");}if(c._hasOwnVisualFocus(i)){C.push("sapFGridContainerItemWrapperNoVisualFocus");}return{styles:s,classes:C};};
G.renderDummyArea=function(r,c,a,t){r.openStart("div",c.getId()+"-"+a);r.attr("tabindex",t);r.class("sapFGridContainerDummyArea");r.openEnd();r.close("div");};
return G;},true);
sap.ui.predefine('sap/f/GridContainerSettings',["sap/ui/base/ManagedObject","sap/ui/dom/units/Rem","sap/base/Log"],function(M,R,L){"use strict";
function c(C){if(C===null||C===undefined){return C;}if(C===0||C==="0"){return 0;}var m=C.match(/^(\d+(\.\d+)?)(px|rem)$/),v;if(m){if(m[3]==="px"){v=parseFloat(m[1]);}else{v=R.toPx(parseFloat(m[1]));}}else{L.error("Css size '"+C+"' is not supported for some features in GridContainer. Only 'px' and 'rem' are supported.");v=NaN;}return Math.ceil(v);}
var G=M.extend("sap.f.GridContainerSettings",{metadata:{library:"sap.f",properties:{columns:{type:"int"},columnSize:{type:"sap.ui.core.CSSSize",defaultValue:"80px"},minColumnSize:{type:"sap.ui.core.CSSSize"},maxColumnSize:{type:"sap.ui.core.CSSSize"},rowSize:{type:"sap.ui.core.CSSSize",defaultValue:"80px"},gap:{type:"sap.ui.core.CSSSize",defaultValue:"16px"}}}});
G.prototype.getColumnSizeInPx=function(){return c(this.getColumnSize());};
G.prototype.getMinColumnSizeInPx=function(){return c(this.getMinColumnSize());};
G.prototype.getRowSizeInPx=function(){return c(this.getRowSize());};
G.prototype.getGapInPx=function(){return c(this.getGap());};
G.prototype.getComputedColumnsCount=function(g){if(this.getColumns()){return this.getColumns();}var i=this.getGapInPx(),C=this.getColumnSizeInPx();return Math.floor((g+i)/(C+i));};
G.prototype.calculateRowsForItem=function(i){var g=this.getGapInPx(),r=this.getRowSizeInPx();return Math.ceil((i+g)/(r+g));};
G.prototype.calculateColumnsForItem=function(i){var g=this.getGapInPx(),C=this.getColumnSizeInPx();return Math.ceil((i+g)/(C+g));};
return G;});
sap.ui.predefine('sap/f/GridContainerUtils',[],function(){"use strict";return{isAbove:function(i,e){var y=i.getDomRef().getBoundingClientRect().top,Y=e.getBoundingClientRect().top;return Y-y<0;},isBelow:function(i,e){var y=i.getDomRef().getBoundingClientRect().top,Y=e.getBoundingClientRect().top;return Y-y>0;},findClosest:function(i,e){var c=null,C=Number.POSITIVE_INFINITY,x=i.getDomRef().getBoundingClientRect().left,y=i.getDomRef().getBoundingClientRect().top;e.forEach(function(E){var X=E.getBoundingClientRect().left,Y=E.getBoundingClientRect().top;var d=(X-x)*(X-x)+(Y-y)*(Y-y);if(d<C){c=E;C=d;}});return c;},findClosestGridContainer:function(i,e){var c=null,C=Number.POSITIVE_INFINITY,y=i.getDomRef().getBoundingClientRect().top;e.forEach(function(E){var Y=E.getBoundingClientRect().top;var d=(Y-y)*(Y-y);if(d<C){c=E;C=d;}});return c;}};});
sap.ui.predefine('sap/f/GridList',["./library","sap/ui/events/KeyCodes","sap/m/ListBase","sap/ui/base/ManagedObjectObserver","sap/ui/layout/cssgrid/GridLayoutDelegate","sap/ui/layout/cssgrid/GridLayoutBase","./GridListRenderer"],function(l,K,L,M,G,a){"use strict";
var b=L.extend("sap.f.GridList",{metadata:{library:"sap.f",interfaces:["sap.ui.layout.cssgrid.IGridConfigurable","sap.f.dnd.IGridDroppable"],aggregations:{customLayout:{type:"sap.ui.layout.cssgrid.GridLayoutBase",multiple:false}}}});
b.prototype.init=function(){L.prototype.init.apply(this,arguments);this._oItemDelegate={onAfterRendering:this._onAfterItemRendering};this._addGridLayoutDelegate();this._oGridObserver=new M(b.prototype._onGridChange.bind(this));this._oGridObserver.observe(this,{aggregations:["items"]});};
b.prototype.exit=function(){this._removeGridLayoutDelegate();if(this._oGridObserver){this._oGridObserver.disconnect();this._oGridObserver=null;}L.prototype.exit.apply(this,arguments);};
b.prototype.getGridDomRefs=function(){return[this.getItemsContainerDomRef()];};
b.prototype.getGridLayoutConfiguration=b.prototype.getCustomLayout;
b.prototype._addGridLayoutDelegate=function(){if(!this.oGridLayoutDelegate){this.oGridLayoutDelegate=new G();this.addEventDelegate(this.oGridLayoutDelegate,this);}};
b.prototype._removeGridLayoutDelegate=function(){if(this.oGridLayoutDelegate){this.removeEventDelegate(this.oGridLayoutDelegate);this.oGridLayoutDelegate.destroy();this.oGridLayoutDelegate=null;}};
b.prototype._onGridChange=function(c){if(c.name!=="items"||!c.child){return;}if(c.mutation==="insert"){c.child.addEventDelegate(this._oItemDelegate,c.child);}else if(c.mutation==="remove"){c.child.removeEventDelegate(this._oItemDelegate,c.child);}};
b.prototype._onAfterItemRendering=function(){a.setItemStyles(this);};
b.prototype.onLayoutDataChange=function(e){a.setItemStyles(e.srcControl);};
b.prototype.onsapnext=function(e){var i=this._oItemNavigation;if(!i){return;}if(e.keyCode===K.ARROW_RIGHT){i.onsapnext({keyCode:K.ARROW_DOWN,target:e.target,preventDefault:e.preventDefault,stopPropagation:e.stopPropagation});}};
b.prototype.onsapprevious=function(e){var i=this._oItemNavigation;if(!i){return;}if(e.keyCode===K.ARROW_LEFT){i.onsapprevious({keyCode:K.ARROW_UP,target:e.target,preventDefault:e.preventDefault,stopPropagation:e.stopPropagation});}};
return b;});
sap.ui.predefine('sap/f/GridListItem',["sap/m/ListItemBase","./GridListItemRenderer"],function(L){"use strict";
var G=L.extend("sap.f.GridListItem",{metadata:{library:"sap.f",defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",bindable:"bindable"}}}});
G.prototype.getContentAnnouncement=function(){return this.getContent().map(function(c){return L.getAccessibilityText(c);}).join(" ").trim();};
return G;});
sap.ui.predefine('sap/f/GridListItemRenderer',["sap/m/ListItemBaseRenderer","sap/ui/core/Renderer","sap/m/library"],function(L,R,l){"use strict";var a=l.ListType;var b=l.ListMode;var M=-1;var G=R.extend(L);G.apiVersion=2;
G.renderLIAttributes=function(r,o){r.class("sapFGLI");};
G.renderContentFormer=function(r,o){this.renderHighlight(r,o);};
G.renderLIContentWrapper=function(r,o){r.openStart("div").class("sapFGLIWrapper").openEnd();this.renderToolbar(r,o);L.renderLIContentWrapper.apply(this,arguments);r.close("div");};
G.renderContentLatter=function(r,o){};
G.renderToolbar=function(r,o){var m=o.getMode(),i=m===b.Delete,t=o.getType();if(!o.getCounter()&&(m===""||m===b.None||m===b.SingleSelectMaster)&&(t===a.Inactive||t===a.Active)){return;}r.openStart("div",o.getId()+"-gridListItemToolbar");r.class("sapFGLIToolbar");r.openEnd();if(!i){this.renderMode(r,o,M);}this.renderToolbarSpacer(r);L.renderContentLatter.apply(this,arguments);r.close("div");};
G.renderLIContent=function(r,o){o.getContent().forEach(r.renderControl,r);};
G.renderToolbarSpacer=function(r){r.openStart("div").class("sapFGLIToolbarSpacer").openEnd().close("div");};
return G;},true);
sap.ui.predefine('sap/f/GridListRenderer',["sap/ui/core/Renderer","sap/m/ListBaseRenderer"],function(R,L){"use strict";var G=R.extend(L);G.apiVersion=2;
G.renderContainerAttributes=function(r,c){L.renderContainerAttributes.apply(this,arguments);r.class("sapFGridList");};
G.renderListStartAttributes=function(r,c){L.renderListStartAttributes.apply(this,arguments);this.renderGridAttributes(r,c);};
G.renderGridAttributes=function(r,c){var g=c.getGridLayoutConfiguration();if(g){g.renderSingleGridLayout(r);}else{r.class("sapFGridListDefault");}if(c.isGrouped()){r.class("sapFGridListGroup");}};
return G;},true);
sap.ui.predefine('sap/f/PlanningCalendarInCardLegend',['sap/m/PlanningCalendarLegend','sap/ui/unified/CalendarLegendItem','./PlanningCalendarInCardLegendRenderer'],function(P,C,a){"use strict";
var b=P.extend("sap.f.PlanningCalendarInCardLegend",{metadata:{library:"sap.m",properties:{visibleLegendItemsCount:{type:"int",group:"Data",defaultValue:2}}}});
b.prototype.exit=function(){P.prototype.exit.call(this,arguments);if(this._oItemsLink){this._oItemsLink.destroy();this._oItemsLink=null;}};
b.prototype._getMoreItemsText=function(i){if(!this._oItemsLink){this._oItemsLink=new sap.ui.unified.CalendarLegendItem({text:"More ("+i+")"});}return this._oItemsLink;};
return b;});
sap.ui.predefine('sap/f/PlanningCalendarInCardLegendRenderer',['sap/m/PlanningCalendarLegendRenderer','sap/ui/core/Renderer'],function(P,R){"use strict";var a=R.extend(P);a.apiVersion=2;
a.renderItemsHeader=function(r,l){};
a.renderAppointmentsItemsHeader=function(r,l){};
a.renderAdditionalContent=function(r,l){};
a.renderAdditionalItems=function(r,l){var A=l.getAppointmentItems(),v=l.getVisibleLegendItemsCount(),b,i;if(l.getItems().length>=v){b=0;}else if(l.getItems().length+l.getAppointmentItems().length>v){b=v-l.getItems().length;}else{b=l.getAppointmentItems().length;}for(i=0;i<b;i++){this.renderLegendItem(r,"sapUiCalLegDayType"+l._getItemType(A[i],A).slice(4),A[i],["sapUiUnifiedLegendSquareColor","sapMPlanCalLegendAppCircle"]);}if(l.getItems().length+l.getAppointmentItems().length>v){this.renderLegendItem(r,"sapUiCalLegMoreText",l._getMoreItemsText(l.getItems().length+l.getAppointmentItems().length-v),[]);}};
a.defineItemsLength=function(l,c){var v=l.getVisibleLegendItemsCount();if(c>=v){return v;}else{return c;}};
return a;},true);
sap.ui.predefine('sap/f/ProductSwitch',["sap/ui/core/Core","sap/ui/core/Control",'sap/ui/core/delegate/ItemNavigation',"sap/f/GridContainer","sap/f/GridContainerSettings","sap/f/ProductSwitchItem","sap/f/ProductSwitchRenderer"],function(C,a,I,G,b,P,c){"use strict";
var d=a.extend("sap.f.ProductSwitch",{metadata:{library:"sap.f",aggregations:{_gridContainer:{type:"sap.f.GridContainer",visibility:"hidden",multiple:false},items:{type:"sap.f.ProductSwitchItem",multiple:true,singularName:"item",forwarding:{getter:"_getGridContainer",aggregation:"items"}}},associations:{selectedItem:{type:"sap.f.ProductSwitchItem",multiple:false}},events:{change:{parameters:{itemPressed:{type:"sap.f.ProductSwitchItem"}}}}}});
d.COLUMNS={THREE_COLUMNS:3,FOUR_COLUMNS:4};
d.prototype.init=function(){this._oCurrentSelectedItem=null;};
d.prototype.exit=function(){this._oCurrentSelectedItem=null;this._destroyItemNavigation();};
d.prototype._destroyItemNavigation=function(){if(this._oItemNavigation){this.removeEventDelegate(this._oItemNavigation);this._oItemNavigation.destroy();this._oItemNavigation=null;}};
d.prototype.onAfterRendering=function(){var D,e=[];if(!this._oItemNavigation){this._oItemNavigation=new I(null,null);this._oItemNavigation.setDisabledModifiers({sapnext:["alt","meta"],sapprevious:["alt","meta"]});this.addEventDelegate(this._oItemNavigation);}D=this.getDomRef();this._oItemNavigation.setRootDomRef(D);e=this.getItems().map(function(i){return i.getDomRef();});this._oItemNavigation.setItemDomRefs(e);};
d.prototype._gridContainerItemsUpdate=function(){var l=this._getGridContainer().getLayout();l.setColumns(this.getItems().length<=6?d.COLUMNS.THREE_COLUMNS:d.COLUMNS.FOUR_COLUMNS);};
d.prototype._changeLayoutHandler=function(e){var E=e.getParameter("layout"),i=E==="layoutS"||E==="layoutXS";this._getGridContainer().toggleStyleClass("sapFProductSwitch-Popover-CTX",!i);};
d.prototype._getGridContainer=function(){var g=this.getAggregation("_gridContainer");if(!g){g=new G({layoutChange:this._changeLayoutHandler.bind(this)}).setLayout(new b({columnSize:"11.25rem",rowSize:"7rem",gap:"0.5rem",columns:4})).setLayoutM(new b({columnSize:"11.25rem",rowSize:"7rem",gap:"0.5rem",columns:3})).setLayoutS(new b({columnSize:"100%",rowSize:"5rem",gap:"0",columns:1}));this.setAggregation("_gridContainer",g);}return g;};
d.prototype._onItemPress=function(e){this.setSelectedItem(e.oSource);this.fireChange({itemPressed:e.oSource});};
d.prototype._setSelection=function(i){if(this._oCurrentSelectedItem){this._oCurrentSelectedItem.removeStyleClass("sapFPSItemSelected");this._oCurrentSelectedItem.$().removeAttr("aria-checked");}this._oCurrentSelectedItem=i;if(this._oCurrentSelectedItem){this._oCurrentSelectedItem.addStyleClass("sapFPSItemSelected");this._oCurrentSelectedItem.$().attr("aria-checked","true");}};
d.prototype.setSelectedItem=function(i){if(typeof i==="string"){i=C.byId(i);}if(!(i instanceof P)&&i!==null){return this;}this._setSelection(i);return this.setAssociation("selectedItem",i,true);};
d.prototype.addItem=function(i){this.addAggregation("items",i);if(i){i.attachEvent("_itemPress",this._onItemPress,this);}this._gridContainerItemsUpdate();return this;};
d.prototype.insertItem=function(i,e){this.insertAggregation("items",i,e);if(i){i.attachEvent("_itemPress",this._onItemPress,this);}this._gridContainerItemsUpdate();return this;};
d.prototype.removeItem=function(i){var r=this.removeAggregation("items",i).detachEvent("_itemPress",this._onItemPress,this);this._gridContainerItemsUpdate();return r;};
d.prototype.removeAllItems=function(){var i=this.getItems(),r;i.forEach(function(o){o.detachEvent("_itemPress",this._onItemPress,this);},this);r=this.removeAllAggregation("items");this._gridContainerItemsUpdate();return r;};
d.prototype.destroyItems=function(){var i=this.getItems(),D;i.forEach(function(o){o.detachEvent("_itemPress",this._onItemPress,this);},this);D=this.destroyAggregation("items");this._gridContainerItemsUpdate();return D;};
d.prototype._getItemsCount=function(){return this.getItems().length;};
d.prototype._getItemPosition=function(i){var e=this.getItems(),f;e.forEach(function(o,g){if(o===i){f=g+1;}});return f;};
return d;});
sap.ui.predefine('sap/f/ProductSwitchItem',["sap/ui/core/Control","sap/ui/core/Icon","sap/ui/core/library","sap/m/Text","sap/ui/events/KeyCodes","sap/f/ProductSwitchItemRenderer"],function(C,I,l,T,K,P){"use strict";var a=l.TextAlign;
var b=C.extend("sap.f.ProductSwitchItem",{metadata:{library:"sap.f",properties:{src:{type:"sap.ui.core.URI",defaultValue:null},title:{type:"string",defaultValue:null},subTitle:{type:"string",defaultValue:null},targetSrc:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},target:{type:"string",group:"Behavior",defaultValue:null}},aggregations:{_icon:{type:"sap.ui.core.Icon",visibility:"hidden",multiple:false},_title:{type:"sap.m.Text",visibility:"hidden",multiple:false}}}});
b.prototype.init=function(){this._bSpaceEnterPressed=false;this._bEscapeShiftKeyPress=false;};
b.prototype.setTitle=function(t){this.setProperty("title",t);this._getTitle().setText(t);return this;};
b.prototype.setSrc=function(s){this.setProperty("src",s);this._getIcon().setSrc(s);return this;};
b.prototype.setSubTitle=function(s){this.setProperty("subTitle",s);this._getTitle().setMaxLines(s?1:2);return this;};
b.prototype._getIcon=function(){var i=this.getAggregation("_icon");if(!i){i=new I();if(this.getSrc()){i.setSrc(this.getSrc());}this.setAggregation("_icon",i);}return i;};
b.prototype._getTitle=function(){var t=this.getAggregation("_title");if(!t){t=new T({text:this.getTitle(),maxLines:2,textAlign:a.Initial}).addStyleClass("sapFPSItemMainTitle").addStyleClass("sapFPSItemTitle");this.setAggregation("_title",t);}return t;};
b.prototype._getProductSwitch=function(){return this.getParent().getParent();};
b.prototype.onkeyup=function(e){if((e.keyCode===K.SPACE&&!this._bEscapeShiftKeyPress)){this.fireEvent("_itemPress");}if(e.keyCode===K.SPACE||e.keyCode===K.ENTER){this._bSpaceEnterPressed=false;this._bEscapeShiftKeyPress=false;}};
b.prototype.ontap=function(){this.fireEvent("_itemPress");};
b.prototype.onkeydown=function(e){if((e.keyCode===K.ESCAPE||e.keyCode===K.SHIFT)&&this._bSpaceEnterPressed){this._bEscapeShiftKeyPress=true;}if(e.keyCode===K.SPACE||e.keyCode===K.ENTER){this._bSpaceEnterPressed=true;if(e.keyCode===K.ENTER&&!this._bEscapeShiftKeyPress){this.fireEvent("_itemPress");}e.preventDefault();}};
return b;});
sap.ui.predefine('sap/f/ProductSwitchItemRenderer',[],function(){"use strict";var P={apiVersion:2};
P.render=function(r,c){var p=c._getProductSwitch(),a={role:"menuitemradio"};if(p){a.setsize=p._getItemsCount();a.posinset=p._getItemPosition(c);a.checked=c.getId()===p.getSelectedItem()?"true":undefined;}r.openStart("div",c);r.class("sapFPSItemContainer");r.attr("tabindex",0);r.accessibilityState(c,a);r.openEnd();r.openStart("span");r.class("sapFPSItemIconPlaceholder");r.class("sapUiTinyMarginBottom");r.openEnd();if(c.getSrc()){r.renderControl(c._getIcon());}r.close("span");r.openStart("div");r.class("sapFPSItemTextSection");r.openEnd();if(c.getTitle()){r.renderControl(c._getTitle());}if(c.getSubTitle()){r.openStart("div");r.class("sapFPSItemSubTitle");r.class("sapFPSItemTitle");r.openEnd();r.text(c.getSubTitle());r.close("div");}r.close("div");r.close("div");};
return P;},true);
sap.ui.predefine('sap/f/ProductSwitchRenderer',["sap/ui/core/Core"],function(C){"use strict";return{apiVersion:2,render:function(r,c){var R=C.getLibraryResourceBundle("sap.f");r.openStart("div",c);r.attr("role","menu");r.attr("aria-label",R.getText("PRODUCTSWITCH_CONTAINER_LABEL"));r.openEnd();r.renderControl(c._getGridContainer());r.close("div");}};},true);
sap.ui.predefine('sap/f/SearchManager',['sap/ui/core/Element','sap/ui/base/ManagedObjectObserver','./shellBar/Search'],function(E,M,S){"use strict";var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");
var a=E.extend("sap.f.SearchManager",{metadata:{library:"sap.f",properties:{value:{type:"string",group:"Data",defaultValue:null,bindable:"bindable"},placeholder:{type:"string",group:"Misc",defaultValue:null},maxLength:{type:"int",group:"Behavior",defaultValue:0},enabled:{type:"boolean",group:"Behavior",defaultValue:true},enableSuggestions:{type:"boolean",group:"Behavior",defaultValue:false}},aggregations:{suggestionItems:{type:"sap.m.SuggestionItem",multiple:true,forwarding:{getter:"_getSearchField",aggregation:"suggestionItems"},singularName:"suggestionItem"}},events:{search:{parameters:{query:{type:"string"},clearButtonPressed:{type:"boolean"}}},liveChange:{parameters:{newValue:{type:"string"}}},suggest:{parameters:{suggestValue:{type:"string"}}}}}});
a.prototype.init=function(){this.setProperty("placeholder",r.getText("FACETFILTER_SEARCH"),true);this._oConfigObserver=new M(this._synchronizePropertiesWithConfig.bind(this));this._oConfigObserver.observe(this,{properties:Object.keys(this.getMetadata().getProperties())});this._initShellBarManagedSearch();};
a.prototype._synchronizePropertiesWithConfig=function(){var s=this._oSearch._getSearchField(),o=s.getMetadata(),c=this.getMetadata(),k,n;Object.keys(c.getAllProperties()).forEach(function(p){k=o.hasProperty(p);if(k){n=c.getProperty(p).get(this);o.getProperty(p).set(s,n);}},this);};
a.prototype._initShellBarManagedSearch=function(){if(!this._oSearch){this._oSearch=new S({search:this._onSearch.bind(this),liveChange:this._onLiveChange.bind(this),suggest:this._onSuggest.bind(this)});}};
a.prototype.exit=function(){if(this._oConfigObserver){this._oConfigObserver.disconnect();this._oConfigObserver=null;}if(this._oSearch){this._oSearch.destroy();}};
a.prototype._onLiveChange=function(e){var n=e.getParameters(),b=e.getParameter("newValue");n.id=this.getId();this.setProperty("value",b,true);this.fireLiveChange(n);};
a.prototype._onSearch=function(e){var n=e.getParameters();n.id=this.getId();this.fireSearch(n);};
a.prototype._onSuggest=function(e){var n=e.getParameters();n.id=this.getId();this.fireSuggest(n);};
a.prototype.suggest=function(s){this._getSearchField().suggest(s);};
a.prototype._getSearchField=function(){return this._oSearch._getSearchField();};
return a;});
sap.ui.predefine('sap/f/ShellBar',['sap/f/library',"sap/ui/core/Control","./shellBar/Factory","./shellBar/AdditionalContentSupport","./shellBar/ResponsiveHandler","./shellBar/Accessibility","sap/m/BarInPageEnabler","./ShellBarRenderer"],function(l,C,F,A,R,a,B){"use strict";var b=l.AvatarSize;
var S=C.extend("sap.f.ShellBar",{metadata:{library:"sap.f",interfaces:["sap.f.IShellBar","sap.m.IBar","sap.tnt.IToolHeader"],properties:{title:{type:"string",group:"Appearance",defaultValue:""},secondTitle:{type:"string",group:"Appearance",defaultValue:""},homeIcon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:""},homeIconTooltip:{type:"string",group:"Appearance",defaultValue:""},showMenuButton:{type:"boolean",group:"Appearance",defaultValue:false},showNavButton:{type:"boolean",group:"Appearance",defaultValue:false},showCopilot:{type:"boolean",group:"Appearance",defaultValue:false},showSearch:{type:"boolean",group:"Appearance",defaultValue:false},showNotifications:{type:"boolean",group:"Appearance",defaultValue:false},showProductSwitcher:{type:"boolean",group:"Appearance",defaultValue:false},notificationsNumber:{type:"string",group:"Appearance",defaultValue:""}},aggregations:{menu:{type:"sap.m.Menu",multiple:false,forwarding:{getter:"_getMenu",aggregation:"menu"}},searchManager:{type:"sap.f.SearchManager",multiple:false},profile:{type:"sap.m.Avatar",multiple:false},additionalContent:{type:"sap.f.IShellBar",multiple:true,singularName:"additionalContent"},_overflowToolbar:{type:"sap.m.OverflowToolbar",multiple:false,visibility:"hidden"},_additionalBox:{type:"sap.m.HBox",multiple:false,visibility:"hidden"}},events:{homeIconPressed:{parameters:{icon:{type:"sap.m.Image"}}},menuButtonPressed:{parameters:{button:{type:"sap.m.Button"}}},navButtonPressed:{parameters:{button:{type:"sap.m.Button"}}},copilotPressed:{parameters:{image:{type:"sap.m.Image"}}},searchButtonPressed:{parameters:{button:{type:"sap.m.Button"}}},notificationsPressed:{parameters:{button:{type:"sap.m.Button"}}},productSwitcherPressed:{parameters:{button:{type:"sap.m.Button"}}},avatarPressed:{parameters:{avatar:{type:"sap.m.Avatar"}}}}}});
A.apply(S.prototype);
S.prototype.init=function(){this._oFactory=new F(this);this._bOTBUpdateNeeded=true;this._bLeftBoxUpdateNeeded=true;this._bRightBoxUpdateNeeded=true;this._oOverflowToolbar=this._oFactory.getOverflowToolbar();this._oAdditionalBox=this._oFactory.getAdditionalBox();this._aControls=[];this._aAdditionalContent=[];this.setAggregation("_overflowToolbar",this._oOverflowToolbar);this.setAggregation("_additionalBox",this._oAdditionalBox);this._oToolbarSpacer=this._oFactory.getToolbarSpacer();this._oResponsiveHandler=new R(this);this._oAcc=new a(this);};
S.prototype.onBeforeRendering=function(){var n=this.getNotificationsNumber();if(this.getShowNotifications()&&n!==undefined){this._updateNotificationsIndicators(n);}this._assignControls();};
S.prototype.exit=function(){this._aLeftControls=[];this._aRightControls=[];this._aControls=[];this._oResponsiveHandler.exit();this._oFactory.destroy();this._oAcc.exit();};
S.prototype.setHomeIcon=function(s){if(s){if(!this._oHomeIcon){this._oHomeIcon=this._oFactory.getHomeIcon();}this._oHomeIcon.setSrc(s);}else{this._oHomeIcon=null;}this._bLeftBoxUpdateNeeded=true;return this.setProperty("homeIcon",s);};
S.prototype.setProfile=function(o){this.validateAggregation("profile",o,false);if(o){o.setDisplaySize(b.XS);o.setTooltip(this._oAcc.getEntityTooltip("PROFILE"));o.attachPress(function(){this.fireEvent("avatarPressed",{avatar:o});},this);o.addStyleClass("sapFShellBarProfile");}return this.setAggregation("profile",o);};
S.prototype.setHomeIconTooltip=function(t){var d=this._oAcc.getEntityTooltip("LOGO");if(!this._oHomeIcon){this._oHomeIcon=this._oFactory.getHomeIcon();}if(t){this._oHomeIcon.setTooltip(t);}else{this._oHomeIcon.setTooltip(d);}return this.setProperty("homeIconTooltip",t,true);};
S.prototype.setTitle=function(t){this._sTitle=t;if(!t){this._oPrimaryTitle=null;this._oMegaMenu=null;}else{if(!this._oMegaMenu){this._oMegaMenu=this._oFactory.getMegaMenu();}this._oMegaMenu.setText(t);if(!this._oPrimaryTitle){this._oPrimaryTitle=this._oFactory.getPrimaryTitle();}this._oPrimaryTitle.setText(t);}this._bLeftBoxUpdateNeeded=true;return this.setProperty("title",t);};
S.prototype.setSecondTitle=function(t){if(t){if(!this._oSecondTitle){this._oSecondTitle=this._oFactory.getSecondTitle();}this._oSecondTitle.setText(t);}else{this._oSecondTitle=null;}this._bLeftBoxUpdateNeeded=true;return this.setProperty("secondTitle",t);};
S.prototype.setShowCopilot=function(s){if(s){if(!this._oCopilot){this._oCopilot=this._oFactory.getCopilot();}}else{this._oCopilot=null;}this._bOTBUpdateNeeded=true;this._bLeftBoxUpdateNeeded=true;this._bRightBoxUpdateNeeded=true;return this.setProperty("showCopilot",s);};
S.prototype.setShowSearch=function(s){if(s){if(!this._oSearch){this._oSearch=this._oFactory.getSearch();}}else{this._oSearch=null;}this._bOTBUpdateNeeded=true;return this.setProperty("showSearch",s);};
S.prototype.setSearchManager=function(c){this.setAggregation("searchManager",c);if(c){if(!this._oManagedSearch){this._oManagedSearch=this._oFactory.getManagedSearch();}}else{this._oManagedSearch=null;}this._bOTBUpdateNeeded=true;return this;};
S.prototype.setShowNotifications=function(s){if(s){if(!this._oNotifications){this._oNotifications=this._oFactory.getNotifications();}}else{this._oNotifications=null;}this._bOTBUpdateNeeded=true;return this.setProperty("showNotifications",s);};
S.prototype.setShowProductSwitcher=function(s){if(s){if(!this._oProductSwitcher){this._oProductSwitcher=this._oFactory.getProductSwitcher();}}else{this._oProductSwitcher=null;}this._bRightBoxUpdateNeeded=true;return this.setProperty("showProductSwitcher",s);};
S.prototype.setShowNavButton=function(s){if(s){if(!this._oNavButton){this._oNavButton=this._oFactory.getNavButton();}}else{this._oNavButton=null;}this._bLeftBoxUpdateNeeded=true;return this.setProperty("showNavButton",s);};
S.prototype.setShowMenuButton=function(s){if(s){if(!this._oMenuButton){this._oMenuButton=this._oFactory.getMenuButton();}}else{this._oMenuButton=null;}this._bLeftBoxUpdateNeeded=true;return this.setProperty("showMenuButton",s);};
S.prototype.setNotificationsNumber=function(n){if(this.getShowNotifications()&&n!==undefined){this._updateNotificationsIndicators(n);this._oAcc.updateNotificationsNumber(n);}return this.setProperty("notificationsNumber",n,true);};
S.prototype._addDataToControl=function(c){c.addStyleClass("sapFShellBarItem");if(this._aControls.indexOf(c)===-1){this._aControls.push(c);}return c;};
S.prototype._assignControls=function(){if(!this._bOTBUpdateNeeded&&!this._bLeftBoxUpdateNeeded&&!this._bRightBoxUpdateNeeded){return;}if(this._bLeftBoxUpdateNeeded){this._aLeftControls=[];if(this._oNavButton){this.addControlToCollection(this._oNavButton,this._aLeftControls);}if(this._oMenuButton){this.addControlToCollection(this._oMenuButton,this._aLeftControls);}if(this._oHomeIcon){this.addControlToCollection(this._oHomeIcon,this._aLeftControls);}this._assignControlsToAdditionalBox();this._aLeftControls.push(this._oAdditionalBox);}if(this._oCopilot){this._addDataToControl(this._oCopilot);}if(this._bRightBoxUpdateNeeded||this._bOTBUpdateNeeded){this._aRightControls=[];if(this._bOTBUpdateNeeded){this._assignControlsToOverflowToolbar();}this._aRightControls.push(this._oOverflowToolbar);}this._bLeftBoxUpdateNeeded=false;this._bRightBoxUpdateNeeded=false;this._bOTBUpdateNeeded=false;};
S.prototype._assignControlsToAdditionalBox=function(){this._oAdditionalBox.removeAllItems();this._oTitleControl=null;if(this.getShowMenuButton()){if(this._oPrimaryTitle){this.addControlToCollection(this._oPrimaryTitle,this._oAdditionalBox);this._oTitleControl=this._oPrimaryTitle;}}else if(this._oMegaMenu){if(this._oMegaMenu.getMenu()&&this._oMegaMenu.getMenu().getItems().length){this.addControlToCollection(this._oMegaMenu,this._oAdditionalBox);this._oTitleControl=this._oMegaMenu;}else if(this._oPrimaryTitle){this.addControlToCollection(this._oPrimaryTitle,this._oAdditionalBox);this._oTitleControl=this._oPrimaryTitle;}}if(this._oSecondTitle){this.addControlToCollection(this._oSecondTitle,this._oAdditionalBox);}return this._oAdditionalBox;};
S.prototype._assignControlsToOverflowToolbar=function(){var c;if(!this._oOverflowToolbar){return;}this._oOverflowToolbar.removeAllContent();this.addControlToCollection(this._oToolbarSpacer,this._oOverflowToolbar);if(this._oManagedSearch){this.addControlToCollection(this._oManagedSearch,this._oOverflowToolbar);}if(this._oSearch){this.addControlToCollection(this._oSearch,this._oOverflowToolbar);}if(this._oNotifications){this.addControlToCollection(this._oNotifications,this._oOverflowToolbar);}c=this.getAdditionalContent();if(c){c.forEach(function(o){this.addControlToCollection(o,this._oOverflowToolbar);},this);}this._bOTBUpdateNeeded=false;return this._oOverflowToolbar;};
S.prototype.addControlToCollection=function(c,e){var f;if(Array.isArray(e)){f="push";}else{f=e===this._oAdditionalBox?"addItem":"addContent";}this._addDataToControl(c);e[f](c);};
S.prototype._updateNotificationsIndicators=function(n){if(this._oOverflowToolbar._getOverflowButton()){this._oOverflowToolbar._getOverflowButton().data("notifications",n,true);}if(this._oNotifications){this._oNotifications.data("notifications",n,true);}};
S.prototype._getMenu=function(){if(!this._oMegaMenu){this._oMegaMenu=this._oFactory.getMegaMenu();}return this._oMegaMenu;};
S.prototype.onThemeChanged=function(){this._oResponsiveHandler._handleResize();};
S.prototype._getOverflowToolbar=function(){return this._oOverflowToolbar;};
S.prototype.getContext=B.prototype.getContext;S.prototype.isContextSensitive=B.prototype.isContextSensitive;S.prototype.setHTMLTag=B.prototype.setHTMLTag;S.prototype.getHTMLTag=B.prototype.getHTMLTag;S.prototype.applyTagAndContextClassFor=B.prototype.applyTagAndContextClassFor;S.prototype._applyContextClassFor=B.prototype._applyContextClassFor;S.prototype._applyTag=B.prototype._applyTag;S.prototype._getContextOptions=B.prototype._getContextOptions;S.prototype._setRootAccessibilityRole=B.prototype._setRootAccessibilityRole;S.prototype._getRootAccessibilityRole=B.prototype._getRootAccessibilityRole;S.prototype._setRootAriaLevel=B.prototype._setRootAriaLevel;S.prototype._getRootAriaLevel=B.prototype._getRootAriaLevel;return S;});
sap.ui.predefine('sap/f/ShellBarRenderer',[],function(){"use strict";return{apiVersion:2,render:function(r,c){var a=c._oAcc,R=a.getRootAttributes(),t=c.getTitle(),A=c.getProfile(),b=t&&!c.getShowMenuButton();r.openStart("div",c);r.class("sapFShellBar");if(c.getShowNotifications()){r.class("sapFShellBarNotifications");}if(c.getShowCopilot()){r.class("sapFShellBarCopilot");}r.accessibilityState({role:R.role,label:R.label});r.openEnd();if(b){r.openStart("div",c.getId()+"-titleHidden").class("sapFShellBarTitleHidden").attr("role","heading").attr("aria-level","1").openEnd();r.text(t).close("div");}if(c._aLeftControls&&c._aLeftControls.length){r.openStart("div").class("sapFShellBarOLHB").openEnd();c._aLeftControls.forEach(r.renderControl,r);r.close("div");}if(c._oCopilot){r.renderControl(c._oCopilot);}if(c._aRightControls&&c._aRightControls.length){r.openStart("div").class("sapFShellBarORHB").openEnd();c._aRightControls.forEach(r.renderControl,r);r.close("div");}if(A){r.renderControl(A);}if(c._oProductSwitcher){r.renderControl(c._oProductSwitcher);}r.close("div");},shouldAddIBarContext:function(){return false;}};},true);
sap.ui.predefine('sap/f/cards/Header',["sap/m/library","sap/f/library","sap/ui/core/Control","sap/m/Text","sap/f/Avatar","sap/ui/Device","sap/f/cards/HeaderRenderer","sap/ui/core/Core"],function(l,a,C,T,A,D,H,b){"use strict";var c=l.AvatarShape;var d=l.AvatarColor;
var e=C.extend("sap.f.cards.Header",{
metadata:{library:"sap.f",interfaces:["sap.f.cards.IHeader"],properties:{title:{type:"string",defaultValue:""},subtitle:{type:"string",defaultValue:""},statusText:{type:"string",defaultValue:""},iconDisplayShape:{type:"sap.m.AvatarShape",defaultValue:c.Circle},iconSrc:{type:"sap.ui.core.URI",defaultValue:""},iconInitials:{type:"string",defaultValue:""},iconAlt:{type:"string",defaultValue:""},iconBackgroundColor:{type:"sap.m.AvatarColor",defaultValue:d.Transparent}},aggregations:{toolbar:{type:"sap.ui.core.Control",multiple:false},_title:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_subtitle:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_avatar:{type:"sap.f.Avatar",multiple:false,visibility:"hidden"}},events:{press:{}}},
renderer:H
});
e.prototype.init=function(){this._oRb=b.getLibraryResourceBundle("sap.f");this.data("sap-ui-fastnavgroup","true",true);};
e.prototype.exit=function(){this._oRb=null;};
e.prototype._getTitle=function(){var t=this.getAggregation("_title");if(!t){t=new T({maxLines:3}).addStyleClass("sapFCardTitle");this.setAggregation("_title",t);}return t;};
e.prototype._getSubtitle=function(){var s=this.getAggregation("_subtitle");if(!s){s=new T({maxLines:2}).addStyleClass("sapFCardSubtitle");this.setAggregation("_subtitle",s);}return s;};
e.prototype._getAvatar=function(){var o=this.getAggregation("_avatar");if(!o){o=new A().addStyleClass("sapFCardIcon");this.setAggregation("_avatar",o);}return o;};
e.prototype.onBeforeRendering=function(){var o=this._getAvatar();this._getTitle().setText(this.getTitle());this._getSubtitle().setText(this.getSubtitle());o.setDisplayShape(this.getIconDisplayShape());o.setSrc(this.getIconSrc());o.setInitials(this.getIconInitials());o.setTooltip(this.getIconAlt());o.setBackgroundColor(this.getIconBackgroundColor());this._setAccessibilityAttributes();};
e.prototype._getHeaderAccessibility=function(){var s=this._getSubtitle()?this._getSubtitle().getId():"",S=this.getStatusText()?this.getId()+"-status":"",f=this._getAvatar()?this._getAvatar().getId():"",i=s+" "+S+" "+f;return i.trim();};
e.prototype.onAfterRendering=function(){if(D.browser.msie){if(this.getTitle()){this._getTitle().clampText();}if(this.getSubtitle()){this._getSubtitle().clampText();}}};
e.prototype.ontap=function(E){var s=E.srcControl;if(s&&s.getId().indexOf("overflowButton")>-1){return;}this.firePress();};
e.prototype.onsapselect=function(){this.firePress();};
e.prototype._setAccessibilityAttributes=function(){if(this.hasListeners("press")){this._sAriaRole="button";this._sAriaHeadingLevel=undefined;this._sAriaRoleDescritoion=this._oRb.getText("ARIA_ROLEDESCRIPTION_INTERACTIVE_CARD_HEADER");}else{this._sAriaRole="heading";this._sAriaHeadingLevel="3";this._sAriaRoleDescritoion=this._oRb.getText("ARIA_ROLEDESCRIPTION_CARD_HEADER");}};
e.prototype.isLoading=function(){return false;};
e.prototype.attachPress=function(){var m=Array.prototype.slice.apply(arguments);m.unshift("press");C.prototype.attachEvent.apply(this,m);this.invalidate();return this;};
e.prototype.detachPress=function(){var m=Array.prototype.slice.apply(arguments);m.unshift("press");C.prototype.detachEvent.apply(this,m);this.invalidate();return this;};
e.prototype._isInsideGridContainer=function(){var p=this.getParent();if(!p){return false;}p=p.getParent();if(!p){return false;}return p.isA("sap.f.GridContainer");};
return e;});
sap.ui.predefine('sap/f/cards/HeaderRenderer',[],function(){"use strict";var H={apiVersion:2};
H.render=function(r,h){var s=h.getStatusText(),t=h.getAggregation("_title"),S=h.getAggregation("_subtitle"),a=h.getAggregation("_avatar"),l=h.isLoading(),b=h.mBindingInfos,T=h.getToolbar(),c=h._isInsideGridContainer()?"-1":"0";r.openStart("div",h).attr("tabindex",c).class("sapFCardHeader");if(l){r.class("sapFCardHeaderLoading");}if(h.hasListeners("press")){r.class("sapFCardClickable");}r.accessibilityState(h,{role:h._sAriaRole,labelledby:{value:h._getHeaderAccessibility(),append:true},roledescription:{value:h._sAriaRoleDescritoion,append:true},level:{value:h._sAriaHeadingLevel}});r.openEnd();if(h.getIconSrc()||h.getIconInitials()||b.iconSrc){r.openStart("div").class("sapFCardHeaderImage").openEnd();if(b.iconSrc){a.addStyleClass("sapFCardHeaderItemBinded");}r.renderControl(a);r.close("div");}r.openStart("div").class("sapFCardHeaderText").openEnd();if(h.getTitle()||b.title){r.openStart("div").class("sapFCardHeaderTextFirstLine").openEnd();if(b.title){t.addStyleClass("sapFCardHeaderItemBinded");}r.renderControl(t);if(s!==undefined){r.openStart("span",h.getId()+"-status").class("sapFCardStatus");if(b.statusText){r.class("sapFCardHeaderItemBinded");}r.openEnd().text(s).close("span");}r.close("div");if(h.getSubtitle()||b.subtitle){if(b.subtitle){S.addStyleClass("sapFCardHeaderItemBinded");}r.renderControl(S);}}r.close("div");if(T){r.openStart("div").class("sapFCardHeaderToolbar").openEnd();r.renderControl(T);r.close("div");}r.close("div");};
return H;},true);
sap.ui.predefine('sap/f/cards/NumericHeader',["sap/ui/core/Control","sap/m/NumericContent","sap/m/Text","sap/f/cards/NumericHeaderRenderer","sap/ui/core/Core"],function(C,N,T,a,b){"use strict";
var c=C.extend("sap.f.cards.NumericHeader",{
metadata:{library:"sap.f",interfaces:["sap.f.cards.IHeader"],properties:{title:{"type":"string",group:"Appearance"},subtitle:{"type":"string",group:"Appearance"},statusText:{type:"string",defaultValue:""},unitOfMeasurement:{"type":"string",group:"Data"},number:{"type":"string",group:"Data"},scale:{"type":"string",group:"Data"},trend:{"type":"sap.m.DeviationIndicator",group:"Appearance",defaultValue:"None"},state:{"type":"sap.m.ValueColor",group:"Appearance",defaultValue:"Neutral"},details:{"type":"string",group:"Appearance"}},aggregations:{toolbar:{type:"sap.ui.core.Control",multiple:false},sideIndicators:{type:"sap.f.cards.NumericSideIndicator",multiple:true},_title:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_subtitle:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_unitOfMeasurement:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_details:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_mainIndicator:{type:"sap.m.NumericContent",multiple:false,visibility:"hidden"}},events:{press:{}}},
renderer:a
});
c.prototype.init=function(){this._oRb=b.getLibraryResourceBundle("sap.f");this.data("sap-ui-fastnavgroup","true",true);};
c.prototype.exit=function(){this._oRb=null;};
c.prototype.onBeforeRendering=function(){this._setAccessibilityAttributes();};
c.prototype.setTitle=function(v){this.setProperty("title",v,true);this._getTitle().setText(v);return this;};
c.prototype.setSubtitle=function(v){this.setProperty("subtitle",v,true);this._getSubtitle().setText(v);return this;};
c.prototype.setUnitOfMeasurement=function(v){this.setProperty("unitOfMeasurement",v,true);this._getUnitOfMeasurement().setText(v);return this;};
c.prototype.setDetails=function(v){this.setProperty("details",v,true);this._getDetails().setText(v);return this;};
c.prototype.setNumber=function(v){this.setProperty("number",v,true);this._getMainIndicator().setValue(v);return this;};
c.prototype.setScale=function(v){this.setProperty("scale",v,true);this._getMainIndicator().setScale(v);return this;};
c.prototype.setTrend=function(v){this.setProperty("trend",v,true);this._getMainIndicator().setIndicator(v);return this;};
c.prototype.setState=function(v){this.setProperty("state",v,true);this._getMainIndicator().setValueColor(v);return this;};
c.prototype._getTitle=function(){var o=this.getAggregation("_title");if(!o){o=new T({id:this.getId()+"-title",wrapping:true,maxLines:3});this.setAggregation("_title",o);}return o;};
c.prototype._getSubtitle=function(){var o=this.getAggregation("_subtitle");if(!o){o=new T({id:this.getId()+"-subtitle",wrapping:true,maxLines:2});this.setAggregation("_subtitle",o);}return o;};
c.prototype._getUnitOfMeasurement=function(){var o=this.getAggregation("_unitOfMeasurement");if(!o){o=new T({id:this.getId()+"-unitOfMeasurement",wrapping:false});this.setAggregation("_unitOfMeasurement",o);}return o;};
c.prototype._getDetails=function(){var o=this.getAggregation("_details");if(!o){o=new T({id:this.getId()+"-details",wrapping:false});this.setAggregation("_details",o);}return o;};
c.prototype._getMainIndicator=function(){var o=this.getAggregation("_mainIndicator");if(!o){o=new N({id:this.getId()+"-mainIndicator",withMargin:false,nullifyValue:false,animateTextChange:false,truncateValueTo:100});this.setAggregation("_mainIndicator",o);}return o;};
c.prototype.ontap=function(e){var s=e.srcControl;if(s&&s.getId().indexOf("overflowButton")>-1){return;}this.firePress();};
c.prototype.onsapselect=function(){this.firePress();};
c.prototype._getHeaderAccessibility=function(){var s=this._getSubtitle()?this._getSubtitle().getId():"",S=this.getStatusText()?this.getId()+"-status":"",u=this._getUnitOfMeasurement()?this._getUnitOfMeasurement().getId():"",d=this.getSideIndicators()?this._getSideIndicatorIds():"",D=this._getDetails()?this._getDetails().getId():"",m=this._getMainIndicator()?this._getMainIndicator().getId():"",i=s+" "+S+" "+u+" "+m+d+" "+D;return i.trim();};
c.prototype._setAccessibilityAttributes=function(){if(this.hasListeners("press")){this._sAriaRole="button";this._sAriaHeadingLevel=undefined;this._sAriaRoleDescritoion=this._oRb.getText("ARIA_ROLEDESCRIPTION_INTERACTIVE_CARD_HEADER");}else{this._sAriaRole="heading";this._sAriaHeadingLevel="3";this._sAriaRoleDescritoion=this._oRb.getText("ARIA_ROLEDESCRIPTION_CARD_HEADER");}};
c.prototype._getSideIndicatorIds=function(){var s="";this.getSideIndicators().forEach(function(S){s+=" "+S.getId();});return s;};
c.prototype.isLoading=function(){return false;};
c.prototype.attachPress=function(){var m=Array.prototype.slice.apply(arguments);m.unshift("press");C.prototype.attachEvent.apply(this,m);this.invalidate();return this;};
c.prototype.detachPress=function(){var m=Array.prototype.slice.apply(arguments);m.unshift("press");C.prototype.detachEvent.apply(this,m);this.invalidate();return this;};
c.prototype._isInsideGridContainer=function(){var p=this.getParent();if(!p){return false;}p=p.getParent();if(!p){return false;}return p.isA("sap.f.GridContainer");};
return c;});
sap.ui.predefine('sap/f/cards/NumericHeaderRenderer',[],function(){"use strict";var N={apiVersion:2};
N.render=function(r,n){var l=n.isLoading(),t=n.getToolbar(),T=n._isInsideGridContainer()?"-1":"0";r.openStart("div",n).class("sapFCardHeader").class("sapFCardNumericHeader");if(l){r.class("sapFCardHeaderLoading");}if(n.hasListeners("press")){r.class("sapFCardClickable");}r.attr("tabindex",T);r.accessibilityState(n,{role:n._sAriaRole,labelledby:{value:n._getHeaderAccessibility(),append:true},roledescription:{value:n._sAriaRoleDescritoion,append:true},level:{value:n._sAriaHeadingLevel}});r.openEnd();r.openStart("div").class("sapFCardHeaderContent").openEnd();N.renderHeaderText(r,n);N.renderIndicators(r,n);N.renderDetails(r,n);r.close("div");if(t){r.openStart("div").class("sapFCardHeaderToolbar").openEnd();r.renderControl(t);r.close("div");}r.close("div");};
N.renderHeaderText=function(r,n){var t=n.getAggregation("_title"),s=n.getAggregation("_subtitle"),u=n.getAggregation("_unitOfMeasurement"),S=n.getStatusText(),b=n.mBindingInfos;r.openStart("div").class("sapFCardHeaderText").openEnd();r.openStart("div").class("sapFCardHeaderTextFirstLine").openEnd();if(t){if(b.title){t.addStyleClass("sapFCardHeaderItemBinded");}t.addStyleClass("sapFCardTitle");r.renderControl(t);}if(S){r.openStart("span",n.getId()+'-status').class("sapFCardStatus");if(b.statusText){r.class("sapFCardHeaderItemBinded");}r.openEnd().text(S).close("span");}r.close("div");if(((s&&s.getText())||(b&&b.subtitle))||((u&&u.getText())||(b&&b.unitOfMeasurement))){r.openStart("div").class("sapFCardSubtitle").openEnd();if(s){if(b.subtitle){s.addStyleClass("sapFCardHeaderItemBinded");}r.renderControl(s);}if(u){u.addStyleClass("sapFCardHeaderUnitOfMeasurement");if(b.unitOfMeasurement){u.addStyleClass("sapFCardHeaderItemBinded");}r.renderControl(u);}r.close("div");}r.close("div");};
N.renderIndicators=function(r,n){var m=n.getAggregation("_mainIndicator"),s=n.getAggregation("sideIndicators"),b=n.mBindingInfos;if((m&&m.getValue())||s.length!==0){r.openStart("div").class("sapFCardHeaderIndicators").openEnd();if(m){r.openStart("div").class("sapFCardHeaderMainIndicator").openEnd();if(b.scale||b.number||b.trend||b.state){m.addStyleClass("sapFCardHeaderItemBinded");}else{m.removeStyleClass("sapFCardHeaderItemBinded");}r.renderControl(m);r.close("div");r.openStart("div").class("sapFCardHeaderIndicatorsGap").openEnd().close("div");}if(s.length!==0){r.openStart("div").class("sapFCardHeaderSideIndicators").openEnd();s.forEach(function(i){r.renderControl(i);});r.close("div");}r.close("div");}};
N.renderDetails=function(r,n){var d=n.getAggregation("_details"),b=n.mBindingInfos;if((d&&d.getText())||b.details){d.addStyleClass("sapFCardHeaderItemBinded");d.addStyleClass("sapFCardHeaderDetails");r.renderControl(d);}};
return N;},true);
sap.ui.predefine('sap/f/cards/NumericSideIndicator',["sap/ui/core/Control","sap/m/Text","sap/f/cards/NumericSideIndicatorRenderer"],function(C,T,N){"use strict";
var a=C.extend("sap.f.cards.NumericSideIndicator",{
metadata:{library:"sap.f",properties:{title:{"type":"string",group:"Appearance"},number:{"type":"string",group:"Data"},unit:{"type":"string",group:"Data"}},aggregations:{_title:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_number:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_unit:{type:"sap.m.Text",multiple:false,visibility:"hidden"}}},
renderer:N
});
a.prototype.setTitle=function(v){this.setProperty("title",v,true);this._getTitle().setText(v);return this;};
a.prototype.setNumber=function(v){this.setProperty("number",v,true);this._getNumber().setText(v);return this;};
a.prototype.setUnit=function(v){this.setProperty("unit",v,true);this._getUnit().setText(v);return this;};
a.prototype._getTitle=function(){var c=this.getAggregation("_title");if(!c){c=new T({id:this.getId()+"-title",wrapping:false});this.setAggregation("_title",c);}return c;};
a.prototype._getNumber=function(){var c=this.getAggregation("_number");if(!c){c=new T({id:this.getId()+"-number"});this.setAggregation("_number",c);}return c;};
a.prototype._getUnit=function(){var c=this.getAggregation("_unit");if(!c){c=new T({id:this.getId()+"-unit"});this.setAggregation("_unit",c);}return c;};
return a;});
sap.ui.predefine('sap/f/cards/NumericSideIndicatorRenderer',[],function(){"use strict";var N={apiVersion:2};
N.render=function(r,n){var b=n.mBindingInfos;r.openStart("div",n).class("sapFCardHeaderSideIndicator");if(b.title||b.number||b.unit){r.class("sapFCardHeaderItemBinded");}r.openEnd();var t=n.getAggregation("_title");if(t){t.addStyleClass("sapFCardHeaderSITitle");r.renderControl(t);}r.openStart("div").class("sapFCardHeaderSINumber");if(b.title||b.number||b.unit){r.class("sapFCardHeaderItemBinded");}r.openEnd();var o=n.getAggregation("_number");if(o){r.renderControl(o);}var u=n.getAggregation("_unit");if(u){r.renderControl(u);}r.close("div");r.close("div");};
return N;},true);
sap.ui.predefine('sap/f/cards/loading/GenericPlaceholder',["sap/ui/core/Control","sap/ui/core/Core"],function(C,a){"use strict";
var G=C.extend("sap.f.cards.loading.GenericPlaceholder",{
metadata:{library:"sap.f"},
renderer:{apiVersion:2,render:function(r,c){var R=a.getLibraryResourceBundle("sap.ui.core"),t=R.getText("BUSY_TEXT");r.openStart("div",c).class("sapFCardContentPlaceholder").class("sapFCardContentGenericPlaceholder").attr("tabindex","0").attr("title",t);r.accessibilityState(c,{role:"progressbar",valuemin:"0",valuemax:"100"});r.openEnd();r.openStart("div").class("sapFCardLoadingShimmer").openEnd();this.renderSVG(r);r.close("div");r.close("div");},renderSVG:function(r){r.openStart("svg").attr("height","100%").attr("xmlns","http://www.w3.org/2000/svg").attr("version","1.1").attr("viewBox","0 0 144 144").class("sapFCardSVG").openEnd();r.openStart("g").openEnd();r.openStart("path").attr("d","M0,0v144h144V0H0z M36.4,114h-8.8V87.8h8.8V114z M50.3,114h-9.2V80.8h9.2V114z M64.1,114h-9.2V99.9h9.2V114z M66.9,64.9 c0,1.6-0.8,2.4-2.2,2.4H26.8c-1.6,0-2.4-0.8-2.4-2.4V26.4c0-1.6,0.8-2.4,2.4-2.4h37.9c1.5,0,2.2,0.8,2.2,2.4V64.9z M119.6,117.6 c0,1.6-0.8,2.4-2.2,2.4H79.1c-1.6,0-2.4-0.8-2.4-2.4V79.1c0-1.6,0.8-2.4,2.4-2.4h38.2c1.5,0,2.2,0.8,2.2,2.4V117.6z M119.6,64.7 c0,0.6-0.2,1.2-0.7,1.8c-0.4,0.6-1,0.8-1.6,0.8H79.1c-0.6,0-1.2-0.3-1.7-0.8c-0.5-0.6-0.8-1.2-0.8-1.8V26.4c0-0.6,0.3-1.2,0.8-1.7 c0.6-0.5,1.2-0.8,1.8-0.8h38.1c1.5,0,2.2,0.8,2.2,2.4V64.7z").openEnd().close("path");r.openStart("path").attr("d","M92.3,104.8l-6.6-5.1l-4.5,6l9.6,7.3c0.2,0.4,0.9,0.7,2.1,0.9c1.4,0,2.5-0.6,3.4-1.7L114,87l-6.2-4.3L92.3,104.8z").openEnd().close("path");r.openStart("rect").attr("x","32.8").attr("y","43.1").attr("width","25.9").attr("height","5.2").openEnd().close("rect");r.openStart("rect").attr("x","32.8").attr("y","52.5").attr("width","25.9").attr("height","5.2").openEnd().close("rect");r.openStart("path").attr("d","M115.9,27.2H81c-0.8,0-1.1,0.4-1.1,1.1v34.9c0,0.6,0.4,0.9,1.1,0.9h34.9c0.6,0,0.9-0.3,0.9-0.9V28.3 C116.8,27.6,116.5,27.2,115.9,27.2z M93.8,35.3c1.2-0.9,2.7-1.4,4.4-1.4c1.9,0,3.4,0.5,4.5,1.6c1.1,1.1,1.7,2.7,1.7,4.8 c0,1.9-0.7,3.3-2,4.2s-2.7,1.4-4.2,1.4c-1.8,0-3.2-0.5-4.4-1.5c-1.2-1-1.8-2.6-1.8-4.7C92.1,37.8,92.7,36.3,93.8,35.3z M108.8,59.6 H87.4v-5.8c0-1.6,0.3-2.9,1-3.8c0.7-0.9,1.6-1.7,2.6-2.2c1.1-0.5,2.2-0.8,3.4-0.9c1.2-0.1,2.3-0.2,3.3-0.2h1.1 c2.6,0,4.9,0.4,6.9,1.3c2,0.9,3,2.8,3,5.8V59.6z").openEnd().close("path");r.openStart("rect").attr("x","32.8").attr("y","33.8").attr("width","25.9").attr("height","5.1").openEnd().close("rect");r.close("g");r.close("svg");}}
});
return G;});
sap.ui.predefine('sap/f/cards/loading/ListPlaceholder',["sap/ui/core/Control","sap/ui/core/Core"],function(C,a){"use strict";
var L=C.extend("sap.f.cards.loading.ListPlaceholder",{
metadata:{library:"sap.f",properties:{maxItems:{type:"int",group:"Misc"},item:{type:"any"}}},
renderer:{apiVersion:2,render:function(r,c){var m=c.getMaxItems(),I=c.getItem(),R=a.getLibraryResourceBundle("sap.ui.core"),t=R.getText("BUSY_TEXT");r.openStart("div",c).class("sapFCardContentPlaceholder").class("sapFCardContentListPlaceholder").attr("tabindex","0").attr("title",t);r.accessibilityState(c,{role:"progressbar",valuemin:"0",valuemax:"100"});r.openEnd();for(var i=0;i<m;i++){r.openStart("div").class("sapFCardContentShimmerPlaceholderItem");if(I&&I.icon){r.class("sapFCardContentShimmerPlaceholderWithIcon");}if(I&&I.description){r.class("sapFCardContentShimmerPlaceholderWithDescription");}if(I&&I.chart){r.class("sapFCardContentShimmerPlaceholderWithChart");}r.openEnd();if(I&&I.icon){r.openStart("div").class("sapFCardContentShimmerPlaceholderImg").class("sapFCardLoadingShimmer").openEnd().close("div");}r.openStart("div").class("sapFCardContentShimmerPlaceholderRows").openEnd();if(I&&I.title){r.openStart("div").class("sapFCardContentShimmerPlaceholderItemText").class("sapFCardLoadingShimmer").openEnd().close("div");}if(I&&I.description){r.openStart("div").class("sapFCardContentShimmerPlaceholderItemText").class("sapFCardLoadingShimmer").openEnd().close("div");}if(I&&I.chart){r.openStart("div").class("sapFCardContentShimmerPlaceholderItemText").class("sapFCardLoadingShimmer").openEnd().close("div");}r.close("div");r.close("div");}r.close("div");}}
});
return L;});
sap.ui.predefine('sap/f/changeHandler/MoveDynamicPageTitleActions',["sap/ui/fl/Utils"],function(F){"use strict";var M={};var A="actions";
M.applyChange=function(c,C,p){var m=p.modifier,v=p.view,a=p.appComponent,o=c.getDefinition().content.movedElements[0];var b=m.bySelector(o.selector,a,v),t=o.targetIndex;m.getAggregation(C,A).forEach(function(B,i){if(m.getId(B)===m.getId(b)){m.removeAggregation(C,A,B);m.insertAggregation(C,"dependents",B,undefined,v);c.setRevertData({index:i,sourceParent:m.getSelector(C,a),aggregation:A});}});m.insertAggregation(C,A,b,t,v);return true;};
M.revertChange=function(c,C,p){var m=p.modifier,v=p.view,a=p.appComponent,o=c.getDefinition().content.movedElements[0],r=c.getRevertData();var b=m.bySelector(o.selector,a,v),t=r?r.index:o.targetIndex,s=o.sourceIndex;m.removeAggregation(C,A,b,t,v);m.insertAggregation(C,A,b,s,v);return true;};
M.completeChangeContent=function(c,s,p){var m=p.modifier,a=p.appComponent,C=c.getDefinition();C.content={movedElements:[],targetAggregation:s.target.aggregation,targetContainer:s.selector};s.movedElements.forEach(function(e){var E=e.element||m.bySelector(e.id,a);C.content.movedElements.push({selector:m.getSelector(E,a),sourceIndex:e.sourceIndex,targetIndex:e.targetIndex});});};
M.getCondenserInfo=function(c){var C=c.getContent();var r=c.getRevertData();return{affectedControl:C.movedElements[0].selector,classification:sap.ui.fl.condenser.Classification.Move,sourceContainer:r.sourceParent,targetContainer:C.targetContainer,sourceIndex:r.index,sourceAggregation:r.aggregation,targetAggregation:C.targetAggregation,setTargetIndex:function(c,n){c.getContent().movedElements[0].targetIndex=n;},getTargetIndex:function(c){return c.getContent().movedElements[0].targetIndex;}};};
return M;},true);
sap.ui.predefine('sap/f/delegate/GridContainerItemNavigation',["sap/ui/core/delegate/ItemNavigation","./GridItemNavigation"],function(I,G){"use strict";
function d(c){if(c.onfocusin){c.onfocusin();}}
var a=G.extend("sap.f.delegate.GridContainerItemNavigation",{
constructor:function(){G.apply(this,arguments);this.attachEvent(I.Events.FocusLeave,this._onFocusLeave,this);},
metadata:{library:"sap.f",properties:{},events:{}}
});
a.prototype._onFocusLeave=function(e){var c=this.getFocusedDomRef();this.getItemDomRefs().forEach(function(i,b){if(c===i){var n=b++;this.setFocusedIndex(n);}}.bind(this));this._bFocusLeft=true;};
a.prototype.forwardTab=function(f){var i=this._getRootDomRefId()+"-"+(f?"after":"before");document.getElementById(i).focus();};
a.prototype._getRootDomRefId=function(f){return this.getRootDomRef().getAttribute("id");};
a.prototype.onsaptabnext=function(e){var n=this.getItemDomRefs(),l=this.getFocusedIndex(),L=jQuery(n[l]),T=[];var A=L.find(":sapTabbable");A.map(function(i,b){if(b.className.indexOf("DummyArea")===-1){T.push(b);}});var t=jQuery(T),f=t.length===1?0:t.length-1;if(f===-1||(t.control(f)&&t.control(f).getId()===e.target.id)){this._lastFocusedElement=e.target;this.forwardTab(true);}};
a.prototype.onsaptabprevious=function(e){if(!e.target.classList.contains("sapFGridContainerItemWrapper")){this._lastFocusedElement=e.target;return;}var t=e.target.id;if(t===(this._getRootDomRefId()+"-nodata")){this.forwardTab(false);}this._lastFocusedElement=null;this.forwardTab(false);};
a.prototype.onmousedown=function(e){this._bIsMouseDown=true;I.prototype.onmousedown.call(this,e);};
a.prototype.onmouseup=function(e){var $=jQuery(e.target).closest('.sapFGridContainerItemWrapperNoVisualFocus'),c;if($.length){c=$.children().eq(0).control()[0];if(c&&c.getFocusDomRef()===document.activeElement){this._lastFocusedElement=null;$.trigger("focus");d(c);}}this._bIsMouseDown=false;};
a.prototype.onfocusin=function(e){I.prototype.onfocusin.call(this,e);var $=jQuery(e.target).closest('.sapFGridContainerItemWrapperNoVisualFocus'),c,n,l;if($.length){c=$.children().eq(0).control()[0];if(c){d(c);if(!this._bIsMouseDown&&c.getFocusDomRef()===e.target){this._lastFocusedElement=null;$.trigger("focus");return;}}}if(e.target.classList.contains("sapFGridContainerItemWrapper")){this._lastFocusedElement=null;}if(this._bFocusLeft){this._bFocusLeft=false;n=this.getItemDomRefs();l=this.getFocusedIndex();if(this._lastFocusedElement){this._lastFocusedElement.focus();}else{n[l].focus();}}};
a.prototype.focusItem=function(i,e){if(i===this.iFocusedIndex&&this.aItemDomRefs[this.iFocusedIndex]===document.activeElement){this.fireEvent(I.Events.FocusAgain,{index:i,event:e});return;}this.fireEvent(I.Events.BeforeFocus,{index:i,event:e});this.setFocusedIndex(i);this.bISetFocus=true;if(e&&jQuery(this.aItemDomRefs[this.iFocusedIndex]).data("sap.INRoot")){var o=jQuery(this.aItemDomRefs[this.iFocusedIndex]).data("sap.INRoot");o._sFocusEvent=e.type;}if(!this._bIsMouseDown&&this.aItemDomRefs.length){this.aItemDomRefs[this.iFocusedIndex].focus();}this.fireEvent(I.Events.AfterFocus,{index:i,event:e});};
return a;});
sap.ui.predefine('sap/f/delegate/GridItemNavigation',["sap/ui/core/delegate/ItemNavigation","sap/ui/events/KeyCodes"],function(I,K){"use strict";
var G=I.extend("sap.f.delegate.GridItemNavigation",{metadata:{library:"sap.f",properties:{},events:{}}});
G.prototype.onsapnext=function(e){I.prototype.onsapnext.call(this,e);};
G.prototype.onsapprevious=function(e){I.prototype.onsapprevious.call(this,e);};
return G;});
sap.ui.predefine('sap/f/dnd/GridDragOver',['sap/ui/base/Object',"sap/ui/thirdparty/jquery","sap/base/Log"],function(B,q,L){"use strict";
var G=B.extend("sap.f.dnd.GridDragOver",{
_iTimeoutBeforeDrop:200,
_$indicator:q("<div class='sapUiDnDGridIndicator'></div>"),
constructor:function(){this._oDragControlDelegate={ondragend:this.scheduleEndDrag};this._oDropContainerDelegate={ondragleave:this._onDragLeave,onBeforeRendering:this._onDropContainerBeforeRendering,onAfterRendering:this._onDropContainerAfterRendering};},
destroy:function(){this._oDragEndDelegate=null;}
});
G.prototype.setCurrentContext=function(d,D,t){if(this._oDragControl===d&&this._oDropContainer===D&&this._sTargetAggregation===t){return this;}if(this._oDragControl&&this._oDragControl!==d){this.endDrag();}this._oDragControl=d;this._oDragContainer=d.getParent();this._oDropContainer=D;this._sTargetAggregation=t;this._mDragItemDimensions=this._getDimensions(d);this._bIsInSameContainer=this._oDragContainer===this._oDropContainer;if(this._bIsInSameContainer){this._iDragFromIndex=D.indexOfAggregation(t,d);}else{this._iDragFromIndex=null;}D.getAggregation(t).forEach(function(c){c.addStyleClass("sapUiDnDGridControl");});this._attachEventDelegates();return this;};
G.prototype.handleDragOver=function(d){if(this._shouldFreeze(d.pageX,d.pageY)){return;}var D=this._calculateDropPosition(d);if(!D){return;}if(this._timeoutOnSamePosition(D)){if(D.targetControl===this._oDragControl){return;}this._hideDraggedItem();this._showIndicator(D,d);this._freezeCurrentPosition(d.pageX,d.pageY);}};
G.prototype.getSuggestedDropPosition=function(){return this._mLastDropPosition;};
G.prototype.setDropIndicatorSize=function(I){if(!I){this._mDropIndicatorSize=null;return;}if(!I.rows||!I.columns){L.error("Custom indicator size for grid drag and drop is not valid. It must be an object with rows and columns properties: '{rows: <int>, columns: <int>}'.");this._mDropIndicatorSize=null;return;}this._mDropIndicatorSize=I;};
G.prototype.scheduleEndDrag=function(){if(!this._isDragActive()){return;}var b=this._oDropContainer.getBindingInfo(this._sTargetAggregation);if(b&&b.template){setTimeout(this.endDrag.bind(this),0);}else{this.endDrag();}};
G.prototype.endDrag=function(){if(!this._isDragActive()){return;}this._hideIndicator();this._showDraggedItem();this._removeEventDelegates();this._oDropContainer.fireEvent("_gridPolyfillAfterDragEnd",{indicator:this._$indicator});this._mDropIndicatorSize=null;this._oDragControl=null;this._oDropContainer=null;this._sTargetAggregation=null;this._iDragFromIndex=null;this._iDropPositionHoldStart=null;this._mLastDropPosition=null;this._mFreezePosition=null;};
G.prototype._isDragActive=function(){return this._oDragControl&&this._oDropContainer;};
G.prototype._showIndicator=function(d,D){var o=this._oDropContainer,a=o.getDomRefForSetting(this._sTargetAggregation)||o.getDomRef(),t=d.targetControl,T=o.indexOfAggregation(this._sTargetAggregation,t),$,b,s;if(t){$=this._findContainingGridItem(t);b=$||t.$();}if(b&&o.isA("sap.f.GridContainer")){b=b.closest(".sapFGridContainerItemWrapper");}if(this._mDropIndicatorSize){s={"grid-row-start":"span "+this._mDropIndicatorSize.rows,"grid-column-start":"span "+this._mDropIndicatorSize.columns};}else{s={"grid-column-start":this._mDragItemDimensions.columnsSpan,"grid-row-start":this._mDragItemDimensions.rowsSpan};}if(s){this._$indicator.css(s);}if(b&&d.position=="Before"){this._$indicator.insertBefore(b);}else if(b){this._$indicator.insertAfter(b);T+=1;}else{a.appendChild(this._$indicator[0]);}this._$indicator.show();this._iDragFromIndex=T;var e={indicator:this._$indicator,indicatorIndex:this._iDragFromIndex};if(this._mDropIndicatorSize){e.rows=this._mDropIndicatorSize.rows;e.columns=this._mDropIndicatorSize.columns;}else{e.width=this._mDragItemDimensions.rect.width;e.height=this._mDragItemDimensions.rect.height;}this._oDropContainer.fireEvent("_gridPolyfillAfterDragOver",e);};
G.prototype._hideIndicator=function(){this._$indicator.detach();this._$indicator.attr("style","");};
G.prototype._hideDraggedItem=function(){this._oDragControl.$().hide();var $=this._findContainingGridItem(this._oDragControl);if($&&this._bIsInSameContainer){$.hide();}else{this._oDragContainer.fireEvent("_gridPolyfillDraggingInAnotherContainer");}};
G.prototype._showDraggedItem=function(){if(this._oDragControl.getDomRef()){this._oDragControl.$().show();}var $=this._findContainingGridItem(this._oDragControl);if($){$.show();}};
G.prototype._timeoutOnSamePosition=function(d){if(!this._mLastDropPosition||d.targetControl!==this._mLastDropPosition.targetControl||d.position!=this._mLastDropPosition.position){this._iDropPositionHoldStart=Date.now();this._mLastDropPosition=d;return false;}return Date.now()-this._iDropPositionHoldStart>this._iTimeoutBeforeDrop;};
G.prototype._shouldFreeze=function(p,P){var t=20;return this._mFreezePosition&&Math.abs(this._mFreezePosition.pageX-p)<t&&Math.abs(this._mFreezePosition.pageY-P)<t;};
G.prototype._freezeCurrentPosition=function(p,P){this._mFreezePosition={pageX:p,pageY:P};};
G.prototype._calculateDropPosition=function(d){var $=this._findItemFromPoint(d.pageX,d.pageY),c,t,b;if(!$){c=this._findClosestItem(d.pageX,d.pageY);}if(c){$=c.target;}if(c&&c.direction==="Left"){b="After";}if(!$){$=this._getLastItem();b="After";}if(!$){return{targetControl:null,position:"After"};}if($.hasClass("sapUiDnDGridIndicator")){return null;}t=$.control(0,true);if(!b){b=this._calculateDropBeforeOrAfter(t,d);}return{targetControl:t,position:b};};
G.prototype._calculateDropBeforeOrAfter=function(t,d){var D=this._getDimensions(t),c=D.rect;if(this._oDragControl===t){return"Before";}if((this._mDragItemDimensions.rect.width*1.5)<c.width){var p=window.pageXOffset,m={left:c.left+p,width:c.width},C=d.pageX-m.left;return C<m.width*0.5?"Before":"After";}if(this._iDragFromIndex===null){return"Before";}var T=this._oDropContainer.indexOfAggregation(this._sTargetAggregation,t);if(this._iDragFromIndex>T){return"Before";}return"After";};
G.prototype._getDimensions=function(c){var $=this._findContainingGridItem(c);if($){return{rect:$[0].getBoundingClientRect(),columnsSpan:$.css("grid-column-start"),rowsSpan:$.css("grid-row-start")};}return{rect:c.getDomRef().getBoundingClientRect(),columnsSpan:"span 1",rowsSpan:"span 1"};};
G.prototype._findContainingGridItem=function(c){var $=c.$(),d=$.parent().css("display");if(d==="grid"||d==="inline-grid"){return $;}d=$.parent().parent().css("display");if(d==="grid"||d==="inline-grid"){return $.parent();}return null;};
G.prototype._getLastItem=function(){var I=this._oDropContainer.getAggregation(this._sTargetAggregation),$;if(I&&I.length){$=I[I.length-1].$();}return $;};
G.prototype._findItemFromPoint=function(p,P){var o=document.elementFromPoint(p,P),$=q(o).closest(".sapUiDnDGridControl, .sapUiDnDGridIndicator");if($.hasClass("sapUiDnDGridIndicator")){return $;}if($.hasClass("sapUiDnDGridControl")){return $;}return null;};
G.prototype._findClosestItem=function(p,P){var I=sap.ui.getCore().getConfiguration().getRTL(),a=I?-1:1,s=80*a,S=20,$,d,t=0,x=p-s;while(!$&&x>0&&t<4){$=this._findItemFromPoint(x,P);x-=s;t++;}if($){d="Left";}if(!$&&P-S>0){$=this._findItemFromPoint(p,P-20);d="Top";}return{target:$,direction:d};};
G.prototype._removeEventDelegates=function(){if(this._oDropContainer){this._oDropContainer.removeEventDelegate(this._oDropContainerDelegate);}if(this._oDragControl){this._oDragControl.removeEventDelegate(this._oDragControlDelegate);}};
G.prototype._attachEventDelegates=function(){this._removeEventDelegates();this._oDragControl.addEventDelegate(this._oDragControlDelegate,this);this._oDropContainer.addEventDelegate(this._oDropContainerDelegate,this);};
G.prototype._onDragLeave=function(e){var E=document.elementFromPoint(e.pageX,e.pageY),I=this._oDropContainer.getDomRef().contains(E);if(!I){this.scheduleEndDrag();}};
G.prototype._onDropContainerBeforeRendering=function(){if(!this._isDragActive()){return;}this._hideIndicator();};
G.prototype._onDropContainerAfterRendering=function(){if(!this._isDragActive()){return;}this._hideDraggedItem();if(this._mLastDropPosition){this._showIndicator(this._mLastDropPosition);}};
var i;
G.getInstance=function(){if(!i){i=new G();}return i;};
return G;});
sap.ui.predefine('sap/f/dnd/GridDropInfo',["sap/ui/core/library","sap/ui/core/dnd/DropInfo","sap/f/dnd/GridDragOver","sap/base/Log"],function(c,D,G,L){"use strict";
var a=D.extend("sap.f.dnd.GridDropInfo",{metadata:{library:"sap.f",interfaces:["sap.ui.core.dnd.IDropInfo"],properties:{dropIndicatorSize:{type:"function",invalidate:false,parameters:{draggedControl:{type:"sap.ui.core.Control"}}}},events:{}}});
a.prototype.isDroppable=function(C,e){if(!this._shouldEnhance()){return D.prototype.isDroppable.apply(this,arguments);}if(!this.getEnabled()){return false;}if(!C||!e){return false;}var d=this.getDropTarget();if(!d){return false;}var A=d.getDomRefForSetting(this.getTargetAggregation());if(A&&A.contains(e.target)){e.setMark("DragWithin",this.getTargetAggregation());return true;}if(!A&&d===C){return true;}return false;};
a.prototype.fireDragEnter=function(e){if(!this._shouldEnhance()||this._isKeyboardEvent(e)){return D.prototype.fireDragEnter.apply(this,arguments);}if(!e||!e.dragSession||!e.dragSession.getDragControl()){return null;}this._hideDefaultIndicator(e);var g=G.getInstance(),d=e.dragSession.getDragControl();if(this.getDropIndicatorSize()){g.setDropIndicatorSize(this.getDropIndicatorSize()(d));}g.setCurrentContext(e.dragSession.getDragControl(),this.getDropTarget(),this.getTargetAggregation());var m=g.getSuggestedDropPosition();var b=this.fireEvent("dragEnter",{dragSession:e.dragSession,browserEvent:e.originalEvent,target:m?m.targetControl:null},true);if(b){g.handleDragOver(e);}return b;};
a.prototype.fireDragOver=function(e){if(!this._shouldEnhance()||this._isKeyboardEvent(e)){return D.prototype.fireDragOver.apply(this,arguments);}if(!e||!e.dragSession||!e.dragSession.getDragControl()){return null;}this._hideDefaultIndicator(e);var d=this._suggestDropPosition(e);if(d&&e.dragSession&&d.targetControl){e.dragSession.setDropControl(d.targetControl);}return this.fireEvent("dragOver",{dragSession:e.dragSession,browserEvent:e.originalEvent,target:d?d.targetControl:null,dropPosition:d?d.position:null});};
a.prototype.fireDrop=function(e){if(!this._shouldEnhance()||this._isKeyboardEvent(e)){return D.prototype.fireDrop.apply(this,arguments);}if(!e||!e.dragSession||!e.dragSession.getDragControl()){return null;}var d=e.dragSession,g=G.getInstance(),m;g.setCurrentContext(d.getDragControl(),this.getDropTarget(),this.getTargetAggregation());m=g.getSuggestedDropPosition();this.fireEvent("drop",{dragSession:e.dragSession,browserEvent:e.originalEvent,dropPosition:m?m.position:null,draggedControl:d.getDragControl(),droppedControl:m?m.targetControl:null});g.scheduleEndDrag();};
a.prototype._shouldEnhance=function(){if(this._bShouldEnhance===undefined){if(!this.getParent().isA("sap.f.dnd.IGridDroppable")){L.error("The control which uses 'sap.f.dnd.GridDropInfo' has to implement 'sap.f.dnd.IGridDroppable'.","sap.f.dnd.GridDropInfo");this._bShouldEnhance=false;return this._bShouldEnhance;}this._bShouldEnhance=this.getDropPosition()===c.dnd.DropPosition.Between&&this.getDropLayout()===c.dnd.DropLayout.Horizontal;}return this._bShouldEnhance;};
a.prototype._isKeyboardEvent=function(e){return e.originalEvent.type==="keydown";};
a.prototype._suggestDropPosition=function(d){if(!d.dragSession||!d.dragSession.getDragControl()){return null;}var g=G.getInstance();g.setCurrentContext(d.dragSession.getDragControl(),this.getDropTarget(),this.getTargetAggregation());g.handleDragOver(d);return g.getSuggestedDropPosition();};
a.prototype._hideDefaultIndicator=function(d){d.dragSession.setIndicatorConfig({visibility:"hidden",position:"relative"});};
return a;});
sap.ui.predefine('sap/f/dnd/GridKeyboardDragAndDrop',["sap/ui/thirdparty/jquery"],function(q){"use strict";var G={};
function c(e,d,D,s){return{setIndicatorConfig:q.noop,getDragControl:function(){return d;},getDropControl:function(){return D;},getDropPosition:function(){return s;}};}
function g(C){var p=C.getParent(),s=(C.getDragDropConfig)?C.getDragDropConfig():[],P=(p&&p.getDragDropConfig)?p.getDragDropConfig():[];return s.concat(P);}
function a(d){var D=g(d);return D.filter(function(o){return o.isDraggable(d);});}
function b(d,D,e){var f=g(d);D=D||[];return f.filter(function(o){return!o.isA("sap.ui.core.dnd.IDragInfo");}).concat(D).filter(function(o){if(!o.isDroppable(d,e)){return false;}var s=o.getGroupName();if(!s){return true;}return D.some(function(h){return h.getGroupName()==s;});});}
G.fireDnDByKeyboard=function(d,D,s,e){var v=a(d);e.dragSession=c(e,d,D.isA("sap.f.GridContainer")?null:D,s);if(!v.length){return;}v=e.isMarked("NonDraggable")?[]:v.filter(function(f){return f.fireDragStart(e);});if(!v.length){return;}var o=D.isA("sap.f.GridContainer")?D:D.getParent();var V=b(o,v,e);V=V.filter(function(f){return f.fireDragEnter(e);});V.forEach(function(f){f.fireDrop(e);});};
return G;},true);
sap.ui.predefine('sap/f/flexibility/Avatar.flexibility',["sap/ui/thirdparty/jquery","sap/m/flexibility/Avatar.flexibility"],function(q,a){"use strict";return q.extend(a,{});},true);
sap.ui.predefine('sap/f/flexibility/DynamicPageTitle.flexibility',["sap/m/changeHandler/CombineButtons","sap/m/changeHandler/SplitMenuButton","sap/f/changeHandler/MoveDynamicPageTitleActions"],function(C,S,M){"use strict";return{"hideControl":"default","unhideControl":"default","combineButtons":{"changeHandler":C,"layers":{"CUSTOMER":false}},"splitMenuButton":{"changeHandler":S,"layers":{"CUSTOMER":false}},"moveActions":{"changeHandler":M},"moveControls":"default"};},true);
sap.ui.predefine('sap/f/library',["sap/ui/base/DataType","sap/m/AvatarShape","sap/m/AvatarSize","sap/m/AvatarType","sap/m/AvatarColor","sap/m/AvatarImageFitType","sap/m/library","sap/ui/Global","sap/ui/core/library","sap/ui/layout/library"],function(D,A,a,b,c,d){"use strict";sap.ui.getCore().initLibrary({name:"sap.f",version:"1.84.0",dependencies:["sap.ui.core","sap.m","sap.ui.layout"],designtime:"sap/f/designtime/library.designtime",interfaces:["sap.f.cards.IHeader","sap.f.ICard","sap.f.IShellBar","sap.f.IDynamicPageStickyContent","sap.f.dnd.IGridDroppable"],types:["sap.f.AvatarImageFitType","sap.f.AvatarShape","sap.f.AvatarSize","sap.f.AvatarType","sap.f.AvatarColor","sap.f.AvatarGroupType","sap.f.cards.HeaderPosition","sap.f.DynamicPageTitleArea","sap.f.DynamicPageTitleShrinkRatio","sap.f.LayoutType"],controls:["sap.f.Avatar","sap.f.AvatarGroup","sap.f.AvatarGroupItem","sap.f.cards.Header","sap.f.cards.NumericHeader","sap.f.cards.NumericSideIndicator","sap.f.CalendarInCard","sap.f.Card","sap.f.GridContainer","sap.f.DynamicPage","sap.f.DynamicPageHeader","sap.f.DynamicPageTitle","sap.f.FlexibleColumnLayout","sap.f.semantic.SemanticPage","sap.f.GridList","sap.f.GridListItem","sap.f.PlanningCalendarInCardLegend","sap.f.ProductSwitch","sap.f.ProductSwitchItem","sap.f.ShellBar"],elements:["sap.f.DynamicPageAccessibleLandmarkInfo","sap.f.GridContainerItemLayoutData","sap.f.semantic.AddAction","sap.f.semantic.CloseAction","sap.f.semantic.CopyAction","sap.f.semantic.DeleteAction","sap.f.semantic.DiscussInJamAction","sap.f.semantic.EditAction","sap.f.semantic.ExitFullScreenAction","sap.f.semantic.FavoriteAction","sap.f.semantic.FlagAction","sap.f.semantic.FooterMainAction","sap.f.semantic.FullScreenAction","sap.f.semantic.MainAction","sap.f.semantic.MessagesIndicator","sap.f.semantic.NegativeAction","sap.f.semantic.PositiveAction","sap.f.semantic.PrintAction","sap.f.semantic.SemanticButton","sap.f.semantic.SemanticControl","sap.f.semantic.SemanticToggleButton","sap.f.semantic.SendEmailAction","sap.f.semantic.SendMessageAction","sap.f.semantic.ShareInJamAction","sap.f.semantic.TitleMainAction","sap.f.SearchManager"],extensions:{flChangeHandlers:{"sap.f.Avatar":"sap/f/flexibility/Avatar","sap.f.DynamicPageHeader":{"hideControl":"default","unhideControl":"default","moveControls":"default"},"sap.f.DynamicPageTitle":"sap/f/flexibility/DynamicPageTitle","sap.f.semantic.SemanticPage":{"moveControls":"default"}},"sap.ui.support":{publicRules:true,internalRules:true}}});var t=sap.f;t.DynamicPageTitleArea={Begin:"Begin",Middle:"Middle"};t.DynamicPageTitleShrinkRatio=D.createType('sap.f.DynamicPageTitleShrinkRatio',{isValid:function(v){return/^(([0-9]\d*)(\.\d)?:([0-9]\d*)(\.\d)?:([0-9]\d*)(\.\d)?)$/.test(v);}},D.getType('string'));t.LayoutType={OneColumn:"OneColumn",TwoColumnsBeginExpanded:"TwoColumnsBeginExpanded",TwoColumnsMidExpanded:"TwoColumnsMidExpanded",MidColumnFullScreen:"MidColumnFullScreen",ThreeColumnsMidExpanded:"ThreeColumnsMidExpanded",ThreeColumnsEndExpanded:"ThreeColumnsEndExpanded",ThreeColumnsMidExpandedEndHidden:"ThreeColumnsMidExpandedEndHidden",ThreeColumnsBeginExpandedEndHidden:"ThreeColumnsBeginExpandedEndHidden",EndColumnFullScreen:"EndColumnFullScreen"};sap.ui.lazyRequire("sap.f.routing.Router");sap.ui.lazyRequire("sap.f.routing.Target");sap.ui.lazyRequire("sap.f.routing.TargetHandler");sap.ui.lazyRequire("sap.f.routing.Targets");t.AvatarShape=A;t.AvatarSize=a;t.AvatarType=b;t.AvatarColor=c;t.AvatarImageFitType=d;t.AvatarGroupType={Group:"Group",Individual:"Individual"};t.cards.HeaderPosition={Top:"Top",Bottom:"Bottom"};return t;});
sap.ui.predefine('sap/f/routing/Router',['sap/ui/core/routing/Router','./TargetHandler','./Targets'],function(R,T,a){"use strict";
var M=R.extend("sap.f.routing.Router",{
constructor:function(){this._oTargetHandler=new T();R.prototype.constructor.apply(this,arguments);},
destroy:function(){R.prototype.destroy.apply(this,arguments);this._oTargetHandler.destroy();this._oTargetHandler=null;},
getTargetHandler:function(){return this._oTargetHandler;},
_createTargets:function(c,t){return new a({views:this._oViews,config:c,targets:t,targetHandler:this._oTargetHandler});},
fireRouteMatched:function(A){var r=this.getRoute(A.name),t;if(r._oTarget){t=r._oTarget._oOptions;this._oTargetHandler.addNavigation({navigationIdentifier:A.name,transition:t.transition,transitionParameters:t.transitionParameters,eventData:A.arguments,targetControl:A.targetControl,view:A.view,layout:r._oConfig.layout});}return R.prototype.fireRouteMatched.apply(this,arguments);},
fireRoutePatternMatched:function(A){var r=A.name,v;if(this._oTargets&&this._oTargets._oLastDisplayedTarget){v=this._oTargets._getViewLevel(this._oTargets._oLastDisplayedTarget);}this._oTargetHandler.navigate({navigationIdentifier:r,viewLevel:v,askHistory:true});return R.prototype.fireRoutePatternMatched.apply(this,arguments);}
});
return M;});
sap.ui.predefine('sap/f/routing/Target',['sap/ui/core/routing/Target','sap/f/FlexibleColumnLayout','./async/Target'],function(T,F,a){"use strict";
var M=T.extend("sap.f.routing.Target",{
constructor:function(o,v,p,t){this._oTargetHandler=t;T.prototype.constructor.apply(this,arguments);var b=a;this._super={};for(var f in b){this._super[f]=this[f];this[f]=b[f];}},
_beforePlacingViewIntoContainer:function(A){var c=A.container;var r=A.data&&A.data.routeConfig;if(c instanceof F&&r&&r.layout){c.setLayout(r.layout);}T.prototype._beforePlacingViewIntoContainer.apply(this,arguments);}
});
return M;});
sap.ui.predefine('sap/f/routing/TargetHandler',['sap/m/InstanceManager','sap/f/FlexibleColumnLayout','sap/ui/base/Object','sap/ui/core/routing/History',"sap/base/Log"],function(I,F,B,H,L){"use strict";
var T=B.extend("sap.f.routing.TargetHandler",{constructor:function(c){this._aQueue=[];this._oNavigationOrderPromise=Promise.resolve();if(c===undefined){this._bCloseDialogs=true;}else{this._bCloseDialogs=!!c;}}});
T.prototype.setCloseDialogs=function(c){this._bCloseDialogs=!!c;return this;};
T.prototype.getCloseDialogs=function(){return this._bCloseDialogs;};
T.prototype.addNavigation=function(p){this._aQueue.push(p);};
T.prototype.navigate=function(d){var r=this._createResultingNavigations(d.navigationIdentifier),c=false,b=this._getDirection(d),n;while(r.length){n=this._applyNavigationResult(r.shift().oParams,b);c=c||n;}if(c){this._closeDialogs();}};
T.prototype._chainNavigation=function(n){this._oNavigationOrderPromise=this._oNavigationOrderPromise.then(n);return this._oNavigationOrderPromise;};
T.prototype._getDirection=function(d){var t=d.viewLevel,h=H.getInstance(),b=false;if(d.direction==="Backwards"){b=true;}else if(isNaN(t)||isNaN(this._iCurrentViewLevel)||t===this._iCurrentViewLevel){if(d.askHistory){b=h.getDirection()==="Backwards";}}else{b=t<this._iCurrentViewLevel;}this._iCurrentViewLevel=t;return b;};
T.prototype._createResultingNavigations=function(n){var i,c,C,o,r=[],R;while(this._aQueue.length){c=this._aQueue.shift();C=c.targetControl;o={oContainer:C,oParams:c};if(!a(C)){continue;}for(i=0;i<r.length;i++){R=r[i];if(R.oContainer!==C){continue;}}r.push(o);}return r;};
T.prototype._applyNavigationResult=function(p,b){var t=p.targetControl,A=p.eventData,s=p.transition||"",o=p.transitionParameters,v=p.view.getId(),c,i=t instanceof F,S=false;if(i){c=[t.getCurrentBeginColumnPage(),t.getCurrentMidColumnPage(),t.getCurrentEndColumnPage()];S=c.some(function(C){return C&&C.getId()===v;});}if(S){L.info("navigation to view with id: "+v+" is skipped since it already is displayed by its targetControl","sap.f.routing.TargetHandler");return false;}L.info("navigation to view with id: "+v+" the targetControl is "+t.getId()+" backwards is "+b);if(b){t._safeBackToPage(v,s,A,o);}else{t.to(v,s,A,o);}return true;};
T.prototype._closeDialogs=function(){if(!this._bCloseDialogs){return;}if(I.hasOpenPopover()){I.closeAllPopovers();}if(I.hasOpenDialog()){I.closeAllDialogs();}if(I.hasOpenLightBox()){I.closeAllLightBoxes();}};
function a(c){return c&&c.isA(["sap.m.NavContainer","sap.m.SplitContainer","sap.f.FlexibleColumnLayout"]);}
return T;});
sap.ui.predefine('sap/f/routing/Targets',['sap/ui/core/routing/Targets','./TargetHandler','./Target','./async/Targets'],function(T,a,b,c){"use strict";
var M=T.extend("sap.f.routing.Targets",{
constructor:function(o){o.config._async=true;if(o.targetHandler){this._oTargetHandler=o.targetHandler;}else{this._oTargetHandler=new a();this._bHasOwnTargetHandler=true;}T.prototype.constructor.apply(this,arguments);var d=c;this._super={};for(var f in d){this._super[f]=this[f];this[f]=d[f];}},
destroy:function(){T.prototype.destroy.apply(this,arguments);if(this._bHasOwnTargetHandler){this._oTargetHandler.destroy();}this._oTargetHandler=null;},
getTargetHandler:function(){return this._oTargetHandler;},
_constructTarget:function(o,p){return new b(o,this.getViews(),p,this._oTargetHandler);},
_getViewLevel:function(t){var v;do{v=t._oOptions.viewLevel;if(v!==undefined){return v;}t=t._oParent;}while(t);return v;}
});
return M;});
sap.ui.predefine('sap/f/routing/async/Target',[],function(){"use strict";return{_place:function(d){var p=this._super._place.apply(this,arguments),r=d&&d.routeConfig||{},t=this;return this._oTargetHandler._chainNavigation(function(){return p.then(function(v){t._oTargetHandler.addNavigation({navigationIdentifier:t._oOptions._name,transition:t._oOptions.transition,transitionParameters:t._oOptions.transitionParameters,eventData:d,targetControl:v.control,view:v.view,layout:r.layout});return v;});});}};},true);
sap.ui.predefine('sap/f/routing/async/Targets',[],function(){"use strict";return{display:function(){var v,n;this._oLastDisplayedTarget=null;var p=this._super.display.apply(this,arguments);return p.then(function(V){if(this._oLastDisplayedTarget){v=this._getViewLevel(this._oLastDisplayedTarget);n=this._oLastDisplayedTarget._oOptions._name;}this._oTargetHandler.navigate({viewLevel:v,navigationIdentifier:n});return V;}.bind(this));},_displaySingleTarget:function(t){var T=this.getTarget(t.name);return this._super._displaySingleTarget.apply(this,arguments).then(function(v){if(T){this._oLastDisplayedTarget=T;}return v;}.bind(this));}};},true);
sap.ui.predefine('sap/f/semantic/AddAction',['sap/f/semantic/SemanticButton'],function(S){"use strict";
var A=S.extend("sap.f.semantic.AddAction",{metadata:{library:"sap.f"}});
return A;});
sap.ui.predefine('sap/f/semantic/CloseAction',['./SemanticButton'],function(S){"use strict";
var C=S.extend("sap.f.semantic.CloseAction",{metadata:{library:"sap.f"}});
return C;});
sap.ui.predefine('sap/f/semantic/CopyAction',['./SemanticButton'],function(S){"use strict";
var C=S.extend("sap.f.semantic.CopyAction",{metadata:{library:"sap.f"}});
return C;});
sap.ui.predefine('sap/f/semantic/DeleteAction',['sap/f/semantic/SemanticButton'],function(S){"use strict";
var D=S.extend("sap.f.semantic.DeleteAction",{metadata:{library:"sap.f"}});
return D;});
sap.ui.predefine('sap/f/semantic/DiscussInJamAction',['sap/f/semantic/SemanticButton'],function(S){"use strict";
var D=S.extend("sap.f.semantic.DiscussInJamAction",{metadata:{library:"sap.f"}});
return D;});
sap.ui.predefine('sap/f/semantic/EditAction',['./SemanticButton'],function(S){"use strict";
var E=S.extend("sap.f.semantic.EditAction",{metadata:{library:"sap.f"}});
return E;});
sap.ui.predefine('sap/f/semantic/ExitFullScreenAction',['./SemanticButton'],function(S){"use strict";
var E=S.extend("sap.f.semantic.ExitFullScreenAction",{metadata:{library:"sap.f"}});
return E;});
sap.ui.predefine('sap/f/semantic/FavoriteAction',['./SemanticToggleButton'],function(S){"use strict";
var F=S.extend("sap.f.semantic.FavoriteAction",{metadata:{library:"sap.f"}});
return F;});
sap.ui.predefine('sap/f/semantic/FlagAction',['./SemanticToggleButton'],function(S){"use strict";
var F=S.extend("sap.f.semantic.FlagAction",{metadata:{library:"sap.f"}});
return F;});
sap.ui.predefine('sap/f/semantic/FooterMainAction',["./MainAction"],function(M){"use strict";
var F=M.extend("sap.f.semantic.FooterMainAction",{metadata:{library:"sap.f"}});
return F;});
sap.ui.predefine('sap/f/semantic/FullScreenAction',['./SemanticButton'],function(S){"use strict";
var F=S.extend("sap.f.semantic.FullScreenAction",{metadata:{library:"sap.f"}});
return F;});
sap.ui.predefine('sap/f/semantic/MainAction',['sap/f/semantic/SemanticButton'],function(S){"use strict";
var M=S.extend("sap.f.semantic.MainAction",{metadata:{library:"sap.f","abstract":true,properties:{text:{type:"string",group:"Misc",defaultValue:null}}}});
return M;});
sap.ui.predefine('sap/f/semantic/MessagesIndicator',['./SemanticButton'],function(S){"use strict";
var M=S.extend("sap.f.semantic.MessagesIndicator",{metadata:{library:"sap.f"}});
return M;});
sap.ui.predefine('sap/f/semantic/NegativeAction',['sap/f/semantic/SemanticButton'],function(S){"use strict";
var N=S.extend("sap.f.semantic.NegativeAction",{metadata:{library:"sap.f",properties:{text:{type:"string",group:"Misc",defaultValue:null}}}});
return N;});
sap.ui.predefine('sap/f/semantic/PositiveAction',['sap/f/semantic/SemanticButton'],function(S){"use strict";
var P=S.extend("sap.f.semantic.PositiveAction",{metadata:{library:"sap.f",properties:{text:{type:"string",group:"Misc",defaultValue:null}}}});
return P;});
sap.ui.predefine('sap/f/semantic/PrintAction',['sap/f/semantic/SemanticButton'],function(S){"use strict";
var P=S.extend("sap.f.semantic.PrintAction",{metadata:{library:"sap.f"}});
return P;});
sap.ui.predefine('sap/f/semantic/SemanticButton',["sap/m/semantic/SemanticButton","sap/f/semantic/SemanticConfiguration"],function(M,S){"use strict";
var a=M.extend("sap.f.semantic.SemanticButton",{metadata:{library:"sap.f","abstract":true}});
a.prototype._getConfiguration=function(){return S.getConfiguration(this.getMetadata().getName());};
return a;});
sap.ui.predefine('sap/f/semantic/SemanticConfiguration',["sap/ui/base/Object","sap/ui/core/IconPool","sap/m/library","sap/m/OverflowToolbarLayoutData","sap/ui/core/InvisibleText"],function(B,I,m,O,a){"use strict";var b=m.OverflowToolbarPriority;var c=m.ButtonType;
var S=B.extend("sap.f.semantic.SemanticConfiguration",{getInterface:function(){return this;}});
S._Placement={titleText:"titleText",titleIcon:"titleIcon",footerLeft:"footerLeft",footerRight:"footerRight",shareMenu:"shareMenu"};
S.isKnownSemanticType=function(t){return S.getConfiguration(t)!==null;};
S.getConfiguration=function(t){return S._oTypeConfigs[t]||null;};
S.getSettings=function(t){if(S.isKnownSemanticType(t)){return S._oTypeConfigs[t].getSettings();}return null;};
S.getConstraints=function(t){if(S.isKnownSemanticType(t)){return S._oTypeConfigs[t].constraints||null;}return null;};
S.getPlacement=function(t){if(S.isKnownSemanticType(t)){return S._oTypeConfigs[t].placement;}return null;};
S.getOrder=function(t){if(S.isKnownSemanticType(t)){return S._oTypeConfigs[t].order;}return null;};
S.shouldBePreprocessed=function(t){if(S.isKnownSemanticType(t)){return S._oTypeConfigs[t].needPreprocesing||false;}return false;};
S.isMainAction=function(t){if(S.isKnownSemanticType(t)){return S._oTypeConfigs[t].mainAction||false;}return false;};
S.isNavigationAction=function(t){if(S.isKnownSemanticType(t)){return S._oTypeConfigs[t].navigation||false;}return false;};
S._oTypeConfigs=(function(){var t={},o=sap.ui.getCore().getLibraryResourceBundle("sap.f");t["sap.f.semantic.TitleMainAction"]={placement:S._Placement.titleText,order:0,mainAction:true,getSettings:function(){return{type:c.Emphasized,layoutData:new O({priority:b.NeverOverflow})};}};t["sap.f.semantic.EditAction"]={placement:S._Placement.titleText,order:1,getSettings:function(){return{text:o.getText("SEMANTIC_CONTROL_EDIT"),tooltip:o.getText("SEMANTIC_CONTROL_EDIT"),type:c.Transparent};}};t["sap.f.semantic.DeleteAction"]={placement:S._Placement.titleText,order:2,getSettings:function(){return{text:o.getText("SEMANTIC_CONTROL_DELETE"),type:c.Transparent};}};t["sap.f.semantic.CopyAction"]={placement:S._Placement.titleText,order:3,getSettings:function(){return{text:o.getText("SEMANTIC_CONTROL_COPY"),type:c.Transparent};}};t["sap.f.semantic.AddAction"]={placement:S._Placement.titleText,order:4,getSettings:function(){return{text:o.getText("SEMANTIC_CONTROL_ADD"),tooltip:o.getText("SEMANTIC_CONTROL_ADD"),type:c.Transparent};}};t["sap.f.semantic.FavoriteAction"]={placement:S._Placement.titleIcon,order:0,constraints:"IconOnly",getSettings:function(){return{icon:I.getIconURI("favorite"),text:o.getText("SEMANTIC_CONTROL_FAVORITE"),type:c.Transparent};}};t["sap.f.semantic.FlagAction"]={placement:S._Placement.titleIcon,order:1,constraints:"IconOnly",getSettings:function(){return{icon:I.getIconURI("flag"),text:o.getText("SEMANTIC_CONTROL_FLAG"),type:c.Transparent};}};t["sap.f.semantic.FullScreenAction"]={placement:S._Placement.titleIcon,order:0,constraints:"IconOnly",navigation:true,getSettings:function(){return{icon:I.getIconURI("full-screen"),tooltip:o.getText("SEMANTIC_CONTROL_FULL_SCREEN"),layoutData:new O({priority:b.NeverOverflow}),type:c.Transparent};}};t["sap.f.semantic.ExitFullScreenAction"]={placement:S._Placement.titleIcon,order:1,constraints:"IconOnly",navigation:true,getSettings:function(){return{icon:I.getIconURI("exit-full-screen"),tooltip:o.getText("SEMANTIC_CONTROL_EXIT_FULL_SCREEN"),layoutData:new O({priority:b.NeverOverflow}),type:c.Transparent};}};t["sap.f.semantic.CloseAction"]={placement:S._Placement.titleIcon,order:2,constraints:"IconOnly",navigation:true,getSettings:function(){return{icon:I.getIconURI("decline"),tooltip:o.getText("SEMANTIC_CONTROL_CLOSE"),layoutData:new O({priority:b.NeverOverflow}),type:c.Transparent};}};t["sap.f.semantic.MessagesIndicator"]={placement:S._Placement.footerLeft,order:0,mainAction:false,getSettings:function(){var T=a.getStaticId("sap.f","SEMANTIC_CONTROL_MESSAGES_INDICATOR");return{icon:I.getIconURI("message-popup"),text:{path:"message>/",formatter:function(M){return M.length||0;}},tooltip:o.getText("SEMANTIC_CONTROL_MESSAGES_INDICATOR"),ariaLabelledBy:T,type:c.Emphasized,visible:{path:"message>/",formatter:function(M){return M&&M.length>0;}},models:{message:sap.ui.getCore().getMessageManager().getMessageModel()},layoutData:new O({priority:b.NeverOverflow})};}};t["sap.m.DraftIndicator"]={placement:S._Placement.footerRight,order:0,needPreprocesing:true,mainAction:false,getSettings:function(){return{layoutData:new O({shrinkable:false})};}};t["sap.f.semantic.FooterMainAction"]={placement:S._Placement.footerRight,order:1,mainAction:true,getSettings:function(){return{type:c.Emphasized,text:o.getText("SEMANTIC_CONTROL_SAVE"),layoutData:new O({priority:b.NeverOverflow})};}};t["sap.f.semantic.PositiveAction"]={placement:S._Placement.footerRight,order:2,mainAction:false,getSettings:function(){return{type:c.Accept,text:o.getText("SEMANTIC_CONTROL_ACCEPT"),layoutData:new O({priority:b.NeverOverflow})};}};t["sap.f.semantic.NegativeAction"]={placement:S._Placement.footerRight,order:3,mainAction:false,getSettings:function(){return{type:c.Reject,text:o.getText("SEMANTIC_CONTROL_REJECT"),layoutData:new O({priority:b.NeverOverflow})};}};t["sap.f.semantic.SendEmailAction"]={placement:S._Placement.shareMenu,order:0,constraints:"IconOnly",getSettings:function(){return{icon:I.getIconURI("email"),text:o.getText("SEMANTIC_CONTROL_SEND_EMAIL"),type:c.Transparent};}};t["sap.f.semantic.DiscussInJamAction"]={placement:S._Placement.shareMenu,order:1,constraints:"IconOnly",getSettings:function(){return{icon:I.getIconURI("discussion-2"),text:o.getText("SEMANTIC_CONTROL_DISCUSS_IN_JAM"),type:c.Transparent};}};t["sap.f.semantic.ShareInJamAction"]={placement:S._Placement.shareMenu,order:2,constraints:"IconOnly",getSettings:function(){return{icon:I.getIconURI("share-2"),text:o.getText("SEMANTIC_CONTROL_SHARE_IN_JAM"),type:c.Transparent};}};t["sap.f.semantic.SendMessageAction"]={placement:S._Placement.shareMenu,order:3,constraints:"IconOnly",getSettings:function(){return{icon:I.getIconURI("discussion"),text:o.getText("SEMANTIC_CONTROL_SEND_MESSAGE"),type:c.Transparent};}};t["saveAsTileAction"]={placement:S._Placement.shareMenu,order:4,constraints:"IconOnly"};t["sap.f.semantic.PrintAction"]={placement:S._Placement.shareMenu,order:5,constraints:"IconOnly",getSettings:function(){return{icon:I.getIconURI("print"),text:o.getText("SEMANTIC_CONTROL_PRINT"),type:c.Transparent};}};return t;})();return S;});
sap.ui.predefine('sap/f/semantic/SemanticContainer',["sap/ui/base/Object","./SemanticConfiguration","sap/base/Log"],function(B,S,L){"use strict";
var a=B.extend("sap.f.semantic.SemanticContainer",{
constructor:function(c,p){if(!c){L.error("SemanticContainer :: missing argument - container reference",this);return;}this._oContainer=c;this._oParent=p;},
getInterface:function(){return this;}
});
a.prototype._getContainer=function(){return this._oContainer;};
a.prototype._getParent=function(){return this._oParent;};
a.prototype._shouldBePreprocessed=function(c){var t=(c._getType&&c._getType())||c.getMetadata().getName();return S.shouldBePreprocessed(t);};
a.prototype._getControlOrder=function(c){var t=(c._getType&&c._getType())||c.getMetadata().getName();return S.getOrder(t);};
a.prototype._getConstraints=function(c){return S.getConstraints(c.getMetadata().getName());};
a.prototype._getControl=function(c){return c._getControl?c._getControl():c;};
a.prototype._isMainAction=function(c){return S.isMainAction(c.getMetadata().getName());};
a.prototype._isNavigationAction=function(c){return S.isNavigationAction(c.getMetadata().getName());};
a.prototype._callContainerAggregationMethod=function(m){return this._getContainer()[m].apply(this._getContainer(),Array.prototype.slice.call(arguments).slice(1));};
a.prototype._sortControlByOrder=function(c,C){return this._getControlOrder(c)-this._getControlOrder(C);};
a.prototype.destroy=function(){this._oParent=null;this._oContainer=null;};
return a;});
sap.ui.predefine('sap/f/semantic/SemanticControl',["sap/ui/thirdparty/jquery","sap/ui/base/ManagedObject","sap/ui/core/Element","./SemanticConfiguration"],function(q,M,E,S){"use strict";
var a=E.extend("sap.f.semantic.SemanticControl",{metadata:{library:"sap.f","abstract":true,properties:{visible:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{_control:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}}}});
a.prototype.setProperty=function(k,v,s){M.prototype.setProperty.call(this,k,v,true);this._applyProperty(k,v,s);return this;};
a.prototype.updateAggregation=function(n){this._getControl().updateAggregation(n);};
a.prototype.refreshAggregation=function(n){this._getControl().refreshAggregation(n);};
a.prototype.setAggregation=function(A,o,s){if(A==='_control'){return M.prototype.setAggregation.call(this,A,o,s);}return this._getControl().setAggregation(A,o,s);};
a.prototype.getAggregation=function(A,d){if(A==='_control'){return M.prototype.getAggregation.call(this,A,d);}return this._getControl().getAggregation(A,d);};
a.prototype.indexOfAggregation=function(A,o){return this._getControl().indexOfAggregation(A,o);};
a.prototype.insertAggregation=function(A,o,i,s){return this._getControl().insertAggregation(A,o,i,s);};
a.prototype.addAggregation=function(A,o,s){return this._getControl().addAggregation(A,o,s);};
a.prototype.removeAggregation=function(A,o,s){return this._getControl().removeAggregation(A,o,s);};
a.prototype.removeAllAggregation=function(A,s){return this._getControl().removeAllAggregation(A,s);};
a.prototype.destroyAggregation=function(A,s){return this._getControl().destroyAggregation(A,s);};
a.prototype.bindAggregation=function(n,b){return this._getControl().bindAggregation(n,b);};
a.prototype.unbindAggregation=function(n,s){return this._getControl().unbindAggregation(n,s);};
a.prototype.clone=function(i,l){var C=E.prototype.clone.apply(this,arguments);var p=this._getControl().clone(i,l);C.setAggregation('_control',p);return C;};
a.prototype.destroy=function(){var r=E.prototype.destroy.apply(this,arguments);if(this.getAggregation("_control")){this.getAggregation("_control").destroy();}return r;};
a.prototype.getDomRef=function(s){return this._getControl().getDomRef(s);};
a.prototype.addEventDelegate=function(d,t){q.each(d,function(e,C){if(typeof C==='function'){d[e]=function(o){o.srcControl=this;C.call(t,o);}.bind(this);}}.bind(this));this._getControl().addEventDelegate(d,t);return this;};
a.prototype.removeEventDelegate=function(d){this._getControl().removeEventDelegate(d);return this;};
a.prototype._getConfiguration=function(){return S.getConfiguration(this.getMetadata().getName());};
a.prototype._applyProperty=function(k,v,s){var C=this._getControl(),b;if(C){b="set"+c(k);this._getControl()[b](v,s);}};
function c(n){return n.charAt(0).toUpperCase()+n.slice(1);}
return a;});
sap.ui.predefine('sap/f/semantic/SemanticFooter',["sap/m/ToolbarSpacer","sap/m/library","./SemanticContainer"],function(T,m,S){"use strict";var B=m.ButtonType;
var a=S.extend("sap.f.semantic.SemanticFooter",{constructor:function(c,p){S.call(this,c,p);this._aCustomContent=[];this._aSemanticLeftContent=[];this._aSemanticRightContent=[];this._iSemanticLeftContentCount=1;this._fnParentSubstitute=function(){return this._oParent;}.bind(this);this._insertSpacer();}});
a.mPlacementMethodMap={footerLeft:"LeftContent",footerRight:"RightContent"};
a.prototype.addCustomAction=function(c){c.setType(B.Transparent);this._callContainerAggregationMethod("addContent",c);this._aCustomContent.push(c);return this;};
a.prototype.insertCustomAction=function(c,i){var C=this._getCustomContentInsertIndex(i);c.setType(B.Transparent);this._callContainerAggregationMethod("insertContent",c,C);this._aCustomContent.splice(i,0,c);return this;};
a.prototype.getCustomActions=function(){return this._aCustomContent;};
a.prototype.indexOfCustomAction=function(c){return this._aCustomContent.indexOf(c);};
a.prototype.removeCustomAction=function(c){var r=this._callContainerAggregationMethod("removeContent",c);this._aCustomContent.splice(this._aCustomContent.indexOf(c),1);return r;};
a.prototype.removeAllCustomActions=function(){var r=[];this._aCustomContent.forEach(function(c){var R=this._callContainerAggregationMethod("removeContent",c);if(R){r.push(c);}},this);this._aCustomContent=[];return r;};
a.prototype.destroyCustomActions=function(){this.removeAllCustomActions(true).forEach(function(c){c.destroy();});return this;};
a.prototype.addContent=function(s,p){this["_insertSemantic"+a.mPlacementMethodMap[p]].call(this,s);return this;};
a.prototype.removeContent=function(s,p){this["_removeSemantic"+a.mPlacementMethodMap[p]].call(this,s);return this;};
a.prototype.destroy=function(){this._aCustomContent=null;this._aSemanticLeftContent=null;this._aSemanticRightContent=null;this._oSpacer=null;return S.prototype.destroy.call(this);};
a.prototype._insertSemanticLeftContent=function(s){var c=this._getControl(s),C=this._getControlOrder(s),i=this._getSemanticLeftContentInsertIndex(C);this._callContainerAggregationMethod("insertContent",c,i);this._iSemanticLeftContentCount++;this._aSemanticLeftContent.push(s);return this;};
a.prototype._insertSemanticRightContent=function(s){var c=this._getControl(s);this._aSemanticRightContent.push(s);this._callContainerAggregationMethod("insertContent",c,this._getSemanticRightContentInsertIndex(s));if(this._shouldBePreprocessed(s)){this._preProcessControl(c);}return this;};
a.prototype._removeSemanticLeftContent=function(s){var c=this._getControl(s);this._callContainerAggregationMethod("removeContent",c);this._iSemanticLeftContentCount--;this._aSemanticLeftContent.splice(this._aSemanticLeftContent.indexOf(c),1);return s;};
a.prototype._removeSemanticRightContent=function(s){var c=this._getControl(s);this._callContainerAggregationMethod("removeContent",c);this._aSemanticRightContent.splice(this._aSemanticRightContent.indexOf(s),1);this._postProcessControl(c);return s;};
a.prototype._getSemanticLeftContentInsertIndex=function(c){return this._iSemanticLeftContentCount>1?c:0;};
a.prototype._getSemanticRightContentInsertIndex=function(s){this._aSemanticRightContent.sort(this._sortControlByOrder.bind(this));return this._iSemanticLeftContentCount+this._aSemanticRightContent.indexOf(s);};
a.prototype._getCustomContentInsertIndex=function(i){return i+this._iSemanticLeftContentCount+this._aSemanticRightContent.length;};
a.prototype._insertSpacer=function(){this._callContainerAggregationMethod("addContent",this._getSpacer());return this;};
a.prototype._getSpacer=function(){if(!this._oSpacer){this._oSpacer=new T();}return this._oSpacer;};
a.prototype._preProcessControl=function(c){if(!(typeof c._fnOriginalGetParent==="function")){c._fnOriginalGetParent=c.getParent;c.getParent=this._fnParentSubstitute;}};
a.prototype._postProcessControl=function(c){if(c._fnOriginalGetParent){c.getParent=c._fnOriginalGetParent;delete c._fnOriginalGetParent;}};
return a;});
sap.ui.predefine('sap/f/semantic/SemanticPage',["sap/ui/core/Control","sap/ui/base/ManagedObject","sap/f/library","sap/f/DynamicPage","sap/f/DynamicPageTitle","sap/f/DynamicPageHeader","sap/m/OverflowToolbar","sap/m/ActionSheet","./SemanticTitle","./SemanticFooter","./SemanticShareMenu","./SemanticConfiguration","./SemanticPageRenderer"],function(C,M,l,D,a,b,O,A,S,c,d,e,f){"use strict";var g=l.DynamicPageTitleArea;
var h=C.extend("sap.f.semantic.SemanticPage",{metadata:{library:"sap.f",properties:{headerExpanded:{type:"boolean",group:"Behavior",defaultValue:true},headerPinnable:{type:"boolean",group:"Behavior",defaultValue:true},preserveHeaderStateOnScroll:{type:"boolean",group:"Behavior",defaultValue:false},toggleHeaderOnTitleClick:{type:"boolean",group:"Behavior",defaultValue:true},showFooter:{type:"boolean",group:"Behavior",defaultValue:false},titlePrimaryArea:{type:"sap.f.DynamicPageTitleArea",group:"Appearance",defaultValue:g.Begin},titleAreaShrinkRatio:{type:"sap.f.DynamicPageTitleShrinkRatio",group:"Appearance",defaultValue:"1:1.6:1.6"},fitContent:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"content",aggregations:{titleHeading:{type:"sap.ui.core.Control",multiple:false,defaultValue:null,forwarding:{getter:"_getTitle",aggregation:"heading"}},titleExpandedHeading:{type:"sap.ui.core.Control",multiple:false,defaultValue:null,forwarding:{getter:"_getTitle",aggregation:"expandedHeading"}},titleSnappedHeading:{type:"sap.ui.core.Control",multiple:false,defaultValue:null,forwarding:{getter:"_getTitle",aggregation:"snappedHeading"}},titleBreadcrumbs:{type:"sap.m.IBreadcrumbs",multiple:false,defaultValue:null,forwarding:{getter:"_getTitle",aggregation:"breadcrumbs"}},titleSnappedOnMobile:{type:"sap.m.Title",multiple:false,forwarding:{getter:"_getTitle",aggregation:"snappedTitleOnMobile"}},titleSnappedContent:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_getTitle",aggregation:"snappedContent"}},titleExpandedContent:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_getTitle",aggregation:"expandedContent"}},titleContent:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_getTitle",aggregation:"content"}},titleMainAction:{type:"sap.f.semantic.TitleMainAction",multiple:false},editAction:{type:"sap.f.semantic.EditAction",multiple:false},deleteAction:{type:"sap.f.semantic.DeleteAction",multiple:false},copyAction:{type:"sap.f.semantic.CopyAction",multiple:false},addAction:{type:"sap.f.semantic.AddAction",multiple:false},flagAction:{type:"sap.f.semantic.FlagAction",multiple:false},favoriteAction:{type:"sap.f.semantic.FavoriteAction",multiple:false},fullScreenAction:{type:"sap.f.semantic.FullScreenAction",multiple:false},exitFullScreenAction:{type:"sap.f.semantic.ExitFullScreenAction",multiple:false},closeAction:{type:"sap.f.semantic.CloseAction",multiple:false},titleCustomTextActions:{type:"sap.m.Button",multiple:true},titleCustomIconActions:{type:"sap.m.OverflowToolbarButton",multiple:true},headerContent:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_getHeader",aggregation:"content"}},content:{type:"sap.ui.core.Control",multiple:false},footerMainAction:{type:"sap.f.semantic.FooterMainAction",multiple:false},messagesIndicator:{type:"sap.f.semantic.MessagesIndicator",multiple:false},draftIndicator:{type:"sap.m.DraftIndicator",multiple:false},positiveAction:{type:"sap.f.semantic.PositiveAction",multiple:false},negativeAction:{type:"sap.f.semantic.NegativeAction",multiple:false},footerCustomActions:{type:"sap.m.Button",multiple:true},discussInJamAction:{type:"sap.f.semantic.DiscussInJamAction",multiple:false},saveAsTileAction:{type:"sap.m.Button",multiple:false},shareInJamAction:{type:"sap.f.semantic.ShareInJamAction",multiple:false},sendMessageAction:{type:"sap.f.semantic.SendMessageAction",multiple:false},sendEmailAction:{type:"sap.f.semantic.SendEmailAction",multiple:false},printAction:{type:"sap.f.semantic.PrintAction",multiple:false},customShareActions:{type:"sap.m.Button",multiple:true},landmarkInfo:{type:"sap.f.DynamicPageAccessibleLandmarkInfo",multiple:false,forwarding:{getter:"_getPage",aggregation:"landmarkInfo"}},_dynamicPage:{type:"sap.f.DynamicPage",multiple:false,visibility:"hidden"}},dnd:{draggable:false,droppable:true},designtime:"sap/f/designtime/SemanticPage.designtime"}});
h._EVENTS={SHARE_MENU_CONTENT_CHANGED:"_shareMenuContentChanged"};h._SAVE_AS_TILE_ACTION="saveAsTileAction";h.CONTENT_PADDING_CLASSES_TO_FORWARD={"sapUiNoContentPadding":true,"sapUiContentPadding":true,"sapUiResponsiveContentPadding":true};h.ARIA_ROLE_DESCRIPTION="SEMANTIC_PAGE_ROLE_DESCRIPTION";
h.prototype.init=function(){this._bSPBeingDestroyed=false;this._initDynamicPage();this._attachShareMenuButtonChange();this._fnActionSubstituteParentFunction=function(){return this;}.bind(this);};
h.prototype.exit=function(){this._bSPBeingDestroyed=true;this._cleanMemory();};
h.prototype.setHeaderExpanded=function(H){this._getPage().setHeaderExpanded(H);return this;};
h.prototype.getHeaderExpanded=function(){return this._getPage().getHeaderExpanded();};
h.prototype.setHeaderPinnable=function(H){var o=this._getPage(),i=o.getHeader();i.setPinnable(H);return this.setProperty("headerPinnable",i.getPinnable(),true);};
h.prototype.setPreserveHeaderStateOnScroll=function(p){var o=this._getPage();o.setPreserveHeaderStateOnScroll(p);return this.setProperty("preserveHeaderStateOnScroll",o.getPreserveHeaderStateOnScroll(),true);};
h.prototype.setToggleHeaderOnTitleClick=function(t){this._getPage().setToggleHeaderOnTitleClick(t);return this.setProperty("toggleHeaderOnTitleClick",t,true);};
h.prototype.setShowFooter=function(s){this._getPage().setShowFooter(s);return this.setProperty("showFooter",s,true);};
h.prototype.setTitlePrimaryArea=function(p){var o=this._getTitle();o.setPrimaryArea(p);return this.setProperty("titlePrimaryArea",o.getPrimaryArea(),true);};
h.prototype.setTitleAreaShrinkRatio=function(s){var o=this._getTitle();o.setAreaShrinkRatio(s);return this.setProperty("titleAreaShrinkRatio",o.getAreaShrinkRatio(),true);};
h.prototype.setFitContent=function(F){this._getPage().setFitContent(F);return this.setProperty("fitContent",F,true);};
h.prototype.addStyleClass=function(s,i){var o=this.getAggregation("_dynamicPage");if(h.CONTENT_PADDING_CLASSES_TO_FORWARD[s]){o.addStyleClass(s,true);}return C.prototype.addStyleClass.call(this,s,i);};
h.prototype.removeStyleClass=function(s,i){var o=this.getAggregation("_dynamicPage");if(h.CONTENT_PADDING_CLASSES_TO_FORWARD[s]){o.removeStyleClass(s,true);}return C.prototype.removeStyleClass.call(this,s,i);};
h.prototype.setAggregation=function(s,o,i){var j=this.mAggregations[s],t,p;if(j===o){return this;}o=this.validateAggregation(s,o,false);if(s===h._SAVE_AS_TILE_ACTION){t=h._SAVE_AS_TILE_ACTION;}else{t=this.getMetadata().getManagedAggregation(s).type;}if(e.isKnownSemanticType(t)){p=e.getPlacement(t);if(j){this._onRemoveAggregation(j,t);this._getSemanticContainer(p).removeContent(j,p);}if(o){o._getType=function(){return t;};this._getSemanticContainer(p).addContent(o,p);this._onAddAggregation(o,t);}return M.prototype.setAggregation.call(this,s,o,true);}return M.prototype.setAggregation.call(this,s,o,i);};
h.prototype.destroyAggregation=function(s,i){var o=this.getMetadata().getAggregations()[s],j,p,t;if(s===h._SAVE_AS_TILE_ACTION){t=h._SAVE_AS_TILE_ACTION;}else{t=o&&o.type;}if(t&&e.isKnownSemanticType(t)){j=M.prototype.getAggregation.call(this,s);if(j){p=e.getPlacement(t);this._onRemoveAggregation(j,t);!this._bSPBeingDestroyed&&this._getSemanticContainer(p).removeContent(j,p);}}return M.prototype.destroyAggregation.call(this,s,i);};
["getContent","setContent","destroyContent"].forEach(function(m){var i=/^(set|destroy)/.test(m);h.prototype[m]=function(o){var j=this._getPage();var r=j[m].apply(j,arguments);return i?this:r;};},this);["addTitleCustomTextAction","insertTitleCustomTextAction","indexOfTitleCustomTextAction","removeTitleCustomTextAction","removeAllTitleCustomTextActions","destroyTitleCustomTextActions","getTitleCustomTextActions"].forEach(function(m){var i=/^(add|insert|destroy)/.test(m);h.prototype[m]=function(){var s=this._getSemanticTitle(),j=m.replace(/TitleCustomTextAction?/,"CustomTextAction"),r;r=s[j].apply(s,arguments);return i?this:r;};},this);["addTitleCustomIconAction","insertTitleCustomIconAction","indexOfTitleCustomIconAction","removeTitleCustomIconAction","removeAllTitleCustomIconActions","destroyTitleCustomIconActions","getTitleCustomIconActions"].forEach(function(m){var i=/^(add|insert|destroy)/.test(m);h.prototype[m]=function(){var s=this._getSemanticTitle(),j=m.replace(/TitleCustomIconAction?/,"CustomIconAction"),r;r=s[j].apply(s,arguments);return i?this:r;};},this);["addFooterCustomAction","insertFooterCustomAction","indexOfFooterCustomAction","removeFooterCustomAction","removeAllFooterCustomActions","destroyFooterCustomActions","getFooterCustomActions"].forEach(function(m){var i=/^(add|insert|destroy)/.test(m);h.prototype[m]=function(){var s=this._getSemanticFooter(),j=m.replace(/FooterCustomAction?/,"CustomAction"),r;r=s[j].apply(s,arguments);return i?this:r;};},this);["addCustomShareAction","insertCustomShareAction","indexOfCustomShareAction","removeCustomShareAction","removeAllCustomShareActions","destroyCustomShareActions","getCustomShareActions"].forEach(function(m){var i=/^(add|insert|destroy)/.test(m);h.prototype[m]=function(){var s=this._getShareMenu(),j=m.replace(/CustomShareAction?/,"CustomAction"),r;r=s[j].apply(s,arguments);return i?this:r;};},this);
h.prototype._onAddAggregation=function(o,t){if(t===h._SAVE_AS_TILE_ACTION){this._replaceParent(o);}};
h.prototype._onRemoveAggregation=function(o,t){if(t===h._SAVE_AS_TILE_ACTION){this._restoreParent(o);}if(o._getType){delete o._getType;}};
h.prototype._replaceParent=function(o){if(o._fnOriginalGetParent){return;}o._fnOriginalGetParent=o.getParent;o.getParent=this._fnActionSubstituteParentFunction;};
h.prototype._restoreParent=function(o){if(o&&o._fnOriginalGetParent){o.getParent=o._fnOriginalGetParent;}};
h.prototype._attachShareMenuButtonChange=function(){this.attachEvent(h._EVENTS.SHARE_MENU_CONTENT_CHANGED,this._onShareMenuContentChanged,this);};
h.prototype._onShareMenuContentChanged=function(E){var s=E.getParameter("bEmpty"),o=this._getSemanticTitle(),i=this._getShareMenu(),j=i._getShareMenuButton();if(!j.getParent()){o.addContent(j,"shareIcon");return;}j.setVisible(!s);};
h.prototype._getPage=function(){if(!this.getAggregation("_dynamicPage")){this._initDynamicPage();}return this.getAggregation("_dynamicPage");};
h.prototype._initDynamicPage=function(){var o=new D(this.getId()+"-page",{title:this._getTitle(),header:this._getHeader(),footer:this._getFooter()}),s=sap.ui.getCore().getLibraryResourceBundle("sap.f").getText(h.ARIA_ROLE_DESCRIPTION);o._setAriaRoleDescription(s);this.setAggregation("_dynamicPage",o,true);};
h.prototype._getTitle=function(){if(!this._oDynamicPageTitle){this._oDynamicPageTitle=this._getSemanticTitle()._getContainer();}return this._oDynamicPageTitle;};
h.prototype._getHeader=function(){if(!this._oDynamicPageHeader){this._oDynamicPageHeader=new b(this.getId()+"-pageHeader");}return this._oDynamicPageHeader;};
h.prototype._getFooter=function(){if(!this._oDynamicPageFooter){this._oDynamicPageFooter=this._getSemanticFooter()._getContainer();}return this._oDynamicPageFooter;};
h.prototype._getSemanticTitle=function(){if(!this._oSemanticTitle){this._oSemanticTitle=new S(new a(this.getId()+"-pageTitle"),this);}return this._oSemanticTitle;};
h.prototype._getShareMenu=function(){if(!this._oShareMenu){this._oShareMenu=new d(this._getActionSheet(),this);this.addDependent(this._oShareMenu._oContainer);}return this._oShareMenu;};
h.prototype._getActionSheet=function(){if(!this._oActionSheet){this._oActionSheet=new A(this.getId()+"-shareMenu");}return this._oActionSheet;};
h.prototype._getSemanticFooter=function(){if(!this._oSemanticFooter){this._oSemanticFooter=new c(this._getOverflowToolbar(),this);}return this._oSemanticFooter;};
h.prototype._getOverflowToolbar=function(){if(!this._oOverflowToolbar){this._oOverflowToolbar=new O(this.getId()+"-pageFooter");}return this._oOverflowToolbar;};
h.prototype._getSemanticContainer=function(p){var P=e._Placement;if(p===P.titleText||p===P.titleIcon){return this._getSemanticTitle();}else if(p===P.footerLeft||p===P.footerRight){return this._getSemanticFooter();}else if(p===P.shareMenu){return this._getShareMenu();}return null;};
h.prototype._cleanMemory=function(){if(this._oShareMenu){this._oShareMenu.destroy();this._oShareMenu=null;}if(this._oActionSheet){this._oActionSheet.destroy();this._oActionSheet=null;}if(this._oSemanticTitle){this._oSemanticTitle.destroy();this._oSemanticTitle=null;}if(this._oDynamicPageTitle){this._oDynamicPageTitle.destroy();this._oDynamicPageTitle=null;}if(this._oDynamicPageHeader){this._oDynamicPageHeader.destroy();this._oDynamicPageHeader=null;}if(this._oSemanticFooter){this._oSemanticFooter.destroy();this._oSemanticFooter=null;}if(this._oDynamicPageFooter){this._oDynamicPageFooter.destroy();this._oDynamicPageFooter=null;}if(this._oOverflowToolbar){this._oOverflowToolbar.destroy();this._oOverflowToolbar=null;}};
return h;});
sap.ui.predefine('sap/f/semantic/SemanticPageRenderer',[],function(){"use strict";var S={apiVersion:2};
S.render=function(r,s){r.openStart("div",s);r.class("sapFSemanticPage");r.openEnd();r.renderControl(s._getPage());r.close("div");};
return S;},true);
sap.ui.predefine('sap/f/semantic/SemanticShareMenu',["sap/ui/core/IconPool","sap/ui/base/EventProvider","sap/m/library","sap/m/OverflowToolbarButton","sap/m/OverflowToolbarLayoutData","./SemanticContainer"],function(I,E,m,O,a,S){"use strict";var B=m.ButtonType;
var b=S.extend("sap.f.semantic.SemanticShareMenu",{constructor:function(c,p){S.call(this,c,p);this._aShareMenuActions=[];this._aCustomShareActions=[];this._setMode(b._Mode.initial);}});
b._Mode={initial:"initial",menu:"menu"};
b.prototype.addCustomAction=function(c){this._onControlAdded(c);this._callContainerAggregationMethod("insertButton",c,this._getCustomActionInsertIndex());this._aCustomShareActions.push(c);return this;};
b.prototype.insertCustomAction=function(c,i){this._onControlAdded(c);this._callContainerAggregationMethod("insertButton",c,this._getCustomActionInsertIndex(i));this._aCustomShareActions.splice(i,0,c);return this;};
b.prototype.getCustomActions=function(){return this._aCustomShareActions;};
b.prototype.indexOfCustomAction=function(c){return this._aCustomShareActions.indexOf(c);};
b.prototype.removeCustomAction=function(c){var r=this._callContainerAggregationMethod("removeButton",c);this._aCustomShareActions.splice(this._aCustomShareActions.indexOf(c),1);this._onControlRemoved();return r;};
b.prototype.removeAllCustomActions=function(){var r=[];this._aCustomShareActions.forEach(function(c){var R=this._callContainerAggregationMethod("removeButton",c);if(R){r.push(c);}},this);this._aCustomShareActions=[];this._onControlRemoved();return r;};
b.prototype.destroyCustomActions=function(){this.removeAllCustomActions(true).forEach(function(c){c.destroy();});return this;};
b.prototype.addContent=function(s){var c=this._getControl(s);this._onControlAdded(c);this._aShareMenuActions.push(s);this._preProcessOverflowToolbarButton(c);this._callContainerAggregationMethod("insertButton",c,this._getSemanticActionInsertIndex(s));return this;};
b.prototype.removeContent=function(s){var c=this._getControl(s);this._callContainerAggregationMethod("removeButton",c);this._aShareMenuActions.splice(this._aShareMenuActions.indexOf(s),1);this._postProcessOverflowToolbarButton(s);this._onControlRemoved();return this;};
b.prototype.destroy=function(){this._oShareMenuBtn=null;this._aShareMenuActions=null;this._aCustomShareActions=null;return S.prototype.destroy.call(this);};
b.prototype._getMode=function(){return this._mode;};
b.prototype._setMode=function(M){if(this._getMode()===M){return this;}if(M===b._Mode.initial){if(this._getMode()){this._fireContentChanged(true);}this._mode=b._Mode.initial;return this;}if(M===b._Mode.menu){this._mode=b._Mode.menu;this._fireContentChanged(false);}return this;};
b.prototype._fireContentChanged=function(e){E.prototype.fireEvent.call(this._getParent(),"_shareMenuContentChanged",{"bEmpty":e});};
b.prototype._getShareMenuButton=function(){var c=this._getContainer();if(!this._oShareMenuBtn){this._oShareMenuBtn=new O(c.getId()+"-shareButton",{icon:I.getIconURI("action"),tooltip:sap.ui.getCore().getLibraryResourceBundle("sap.f").getText("SEMANTIC_CONTROL_ACTION_SHARE"),layoutData:new a({closeOverflowOnInteraction:false}),text:sap.ui.getCore().getLibraryResourceBundle("sap.f").getText("SEMANTIC_CONTROL_ACTION_SHARE"),type:B.Transparent,press:function(){c.openBy(this._oShareMenuBtn);}.bind(this)});this._oShareMenuBtn.addEventDelegate({onAfterRendering:function(){this._oShareMenuBtn.$().attr("aria-haspopup","menu");}.bind(this)},this);}return this._oShareMenuBtn;};
b.prototype._getCustomActionInsertIndex=function(i){var c=this._aCustomShareActions.length;if(i===undefined){return this._aShareMenuActions.length+c;}i=i>=c?c:i;i+=this._aShareMenuActions.length;return i;};
b.prototype._getSemanticActionInsertIndex=function(s){this._aShareMenuActions.sort(this._sortControlByOrder.bind(this));return this._aShareMenuActions.indexOf(s);};
b.prototype._onControlAdded=function(c){if(this._isInitialMode()){this._setMode(b._Mode.menu,c);}};
b.prototype._onControlRemoved=function(){var A=this._aShareMenuActions.length,c=this._aCustomShareActions.length,e=(A+c)===0;if(this._isMenuMode()&&e){this._setMode(b._Mode.initial);}};
b.prototype._preProcessOverflowToolbarButton=function(o){if(o instanceof O){o._bInOverflow=true;}};
b.prototype._postProcessOverflowToolbarButton=function(o){if(o instanceof O){delete o._bInOverflow;}};
b.prototype._isInitialMode=function(){return this._getMode()===b._Mode.initial;};
b.prototype._isMenuMode=function(){return this._getMode()===b._Mode.menu;};
return b;});
sap.ui.predefine('sap/f/semantic/SemanticTitle',["sap/m/library","./SemanticContainer"],function(m,S){"use strict";var B=m.ButtonType;
var a=S.extend("sap.f.semantic.SemanticTitle",{constructor:function(c,p){S.call(this,c,p);this._iMainActionCount=0;this._aSemanticTextActions=[];this._aSemanticSimpleIconActions=[];this._aSemanticNavIconActions=[];this._aCustomTextActions=[];this._aCustomIconActions=[];}});
a.mPlacementMethodMap={titleText:"TextContent",titleIcon:"IconContent",shareIcon:"ShareContent"};
a.prototype.addContent=function(s,p){this["_insertSemantic"+a.mPlacementMethodMap[p]].call(this,s);return this;};
a.prototype.removeContent=function(s,p){this["_removeSemantic"+a.mPlacementMethodMap[p]].call(this,s);return this;};
a.prototype.destroy=function(){this._aSemanticSimpleIconActions=null;this._aSemanticTextActions=null;this._aCustomTextActions=null;this._aCustomIconActions=null;this._aSemanticNavIconActions=null;return S.prototype.destroy.call(this);};
a.prototype.addCustomTextAction=function(c){c.setType(B.Transparent);this._callContainerAggregationMethod("insertAction",c,this._getCustomTextActionInsertIndex());this._aCustomTextActions.push(c);return this;};
a.prototype.insertCustomTextAction=function(c,i){c.setType(B.Transparent);this._callContainerAggregationMethod("insertAction",c,this._getCustomTextActionInsertIndex(i));this._aCustomTextActions.splice(i,0,c);return this;};
a.prototype.indexOfCustomTextAction=function(c){return this._aCustomTextActions.indexOf(c);};
a.prototype.removeCustomTextAction=function(c){var i=this._aCustomTextActions.indexOf(c),r=this._callContainerAggregationMethod("removeAction",c);this._aCustomTextActions.splice(i,1);return r;};
a.prototype.removeAllCustomTextActions=function(){var r=[];this._aCustomTextActions.forEach(function(c){var R=this._callContainerAggregationMethod("removeAction",c);if(R){r.push(c);}},this);this._aCustomTextActions=[];return r;};
a.prototype.destroyCustomTextActions=function(){this.removeAllCustomTextActions().forEach(function(c){c.destroy();});return this;};
a.prototype.getCustomTextActions=function(){return this._aCustomTextActions;};
a.prototype.addCustomIconAction=function(c){c.setType(B.Transparent);this._callContainerAggregationMethod("insertAction",c,this._getCustomIconActionInsertIndex());this._aCustomIconActions.push(c);return this;};
a.prototype.insertCustomIconAction=function(c,i){c.setType(B.Transparent);this._callContainerAggregationMethod("insertAction",c,this._getCustomIconActionInsertIndex(i));this._aCustomIconActions.splice(i,0,c);return this;};
a.prototype.indexOfCustomIconAction=function(c){return this._aCustomIconActions.indexOf(c);};
a.prototype.removeCustomIconAction=function(c){var i=this._aCustomIconActions.indexOf(c),r=this._callContainerAggregationMethod("removeAction",c);this._aCustomIconActions.splice(i,1);return r;};
a.prototype.removeAllCustomIconActions=function(){var r=[];this._aCustomIconActions.forEach(function(c){var R=this._callContainerAggregationMethod("removeAction",c);if(R){r.push(c);}},this);this._aCustomIconActions=[];return r;};
a.prototype.destroyCustomIconActions=function(){this.removeAllCustomIconActions().forEach(function(c){c.destroy();});return this;};
a.prototype.getCustomIconActions=function(){return this._aCustomIconActions;};
a.prototype._insertSemanticTextContent=function(s){var c=this._getControl(s),i=this._isMainAction(s),I;this._aSemanticTextActions.push(s);if(i){this._iMainActionCount++;I=this._getSemanticTextMainActionInsertIndex();}else{I=this._getSemanticTextActionInsertIndex(s);}this._callContainerAggregationMethod("insertAction",c,I);return this;};
a.prototype._removeSemanticTextContent=function(s){var c=this._getControl(s),C=this._aSemanticTextActions.indexOf(s),i=this._isMainAction(s);if(i){this._iMainActionCount--;}this._aSemanticTextActions.splice(C,1);this._callContainerAggregationMethod("removeAction",c);return this;};
a.prototype._insertSemanticIconContent=function(s){var c=this._getControl(s),C,i;if(this._isNavigationAction(s)){this._aSemanticNavIconActions.push(s);i=this._getSemanticNavIconActionInsertIndex(s);C="insertNavigationAction";}else{this._aSemanticSimpleIconActions.push(s);i=this._getSemanticSimpleIconActionInsertIndex(s);C="insertAction";}this._callContainerAggregationMethod(C,c,i);return this;};
a.prototype._removeSemanticIconContent=function(s){var c=this._getControl(s),C,i;if(this._isNavigationAction(s)){i=this._aSemanticNavIconActions.indexOf(s);this._aSemanticNavIconActions.splice(i,1);C="removeNavigationAction";}else{i=this._aSemanticTextActions.indexOf(s);this._aSemanticSimpleIconActions.splice(i,1);C="removeAction";}this._callContainerAggregationMethod(C,c);return this;};
a.prototype._insertSemanticShareContent=function(s){var c=this._getControl(s),i=this._getSemanticShareMenuInsertIndex();this._callContainerAggregationMethod("insertAction",c,i);return this;};
a.prototype._removeSemanticShareContent=function(s){var c=this._getControl(s);this._callContainerAggregationMethod("removeAction",c);return this;};
a.prototype._getSemanticTextMainActionInsertIndex=function(){return 0;};
a.prototype._getCustomTextActionInsertIndex=function(i){var c=this._aCustomTextActions.length;if(i===undefined){return this._iMainActionCount+c;}i=i>=c?c:i;i+=this._iMainActionCount;return i;};
a.prototype._getSemanticTextActionInsertIndex=function(s){this._aSemanticTextActions.sort(this._sortControlByOrder.bind(this));return this._getCustomTextActionInsertIndex()+this._aSemanticTextActions.indexOf(s)-this._iMainActionCount;};
a.prototype._getCustomIconActionInsertIndex=function(i){var c=this._aCustomIconActions.length,p=this._aCustomTextActions.length+this._aSemanticTextActions.length;if(i===undefined){return p+c;}i=i>=c?c:i;i+=p;return i;};
a.prototype._getSemanticSimpleIconActionInsertIndex=function(s){this._aSemanticSimpleIconActions.sort(this._sortControlByOrder.bind(this));return this._getCustomIconActionInsertIndex()+this._aSemanticSimpleIconActions.indexOf(s);};
a.prototype._getSemanticNavIconActionInsertIndex=function(s){this._aSemanticNavIconActions.sort(this._sortControlByOrder.bind(this));return this._aSemanticNavIconActions.indexOf(s);};
a.prototype._getSemanticShareMenuInsertIndex=function(){return this._callContainerAggregationMethod("getActions").length;};
a.prototype._getContainerBar=function(){var c=this._getContainer();if(c){return c.getAggregation("_overflowToolbar");}return null;};
return a;});
sap.ui.predefine('sap/f/semantic/SemanticToggleButton',["sap/m/semantic/SemanticToggleButton","sap/f/semantic/SemanticConfiguration"],function(M,S){"use strict";
var a=M.extend("sap.f.semantic.SemanticToggleButton",{metadata:{library:"sap.f","abstract":true}});
a.prototype._getConfiguration=function(){return S.getConfiguration(this.getMetadata().getName());};
return a;});
sap.ui.predefine('sap/f/semantic/SendEmailAction',['sap/f/semantic/SemanticButton'],function(S){"use strict";
var a=S.extend("sap.f.semantic.SendEmailAction",{metadata:{library:"sap.f"}});
return a;});
sap.ui.predefine('sap/f/semantic/SendMessageAction',['sap/f/semantic/SemanticButton'],function(S){"use strict";
var a=S.extend("sap.f.semantic.SendMessageAction",{metadata:{library:"sap.f"}});
return a;});
sap.ui.predefine('sap/f/semantic/ShareInJamAction',['sap/f/semantic/SemanticButton'],function(S){"use strict";
var a=S.extend("sap.f.semantic.ShareInJamAction",{metadata:{library:"sap.f"}});
return a;});
sap.ui.predefine('sap/f/semantic/TitleMainAction',["./MainAction"],function(M){"use strict";
var T=M.extend("sap.f.semantic.TitleMainAction",{metadata:{library:"sap.f"}});
return T;});
sap.ui.predefine('sap/f/shellBar/Accessibility',["sap/ui/core/Core"],function(C){"use strict";var A=function(c){if(c){this._oControl=c;this._oControl.addDelegate(this._controlDelegate,false,this);}this.oRb=C.getLibraryResourceBundle("sap.f");};A.prototype._controlDelegate={onBeforeRendering:function(){this.attachDelegates();}};
A.prototype.attachDelegates=function(){var a=this._oControl.getProfile();this._oDelegateSecondTitle={onAfterRendering:this.onAfterRenderingSecondTitle};this._oDelegateSearch={onAfterRendering:this.onAfterRenderingSearch};this._oDelegateNotifications={onAfterRendering:this.onAfterRenderingNotifications};this._oDelegateAvatar={onAfterRendering:this.onAfterRenderingAvatar};this._oDelegateProducts={onAfterRendering:this.onAfterRenderingProducts};this._oDelegateNavButton={onAfterRendering:this.onAfterRenderingNavButton};this._oDelegateMenuButton={onAfterRendering:this.onAfterRenderingMenuButton};if(this._oControl._oSecondTitle){this._oControl._oSecondTitle.addDelegate(this._oDelegateSecondTitle,false,this);}if(this._oControl._oSearch){this._oControl._oSearch.addDelegate(this._oDelegateSearch,false,this);}if(this._oControl._oNotifications){this._oControl._oNotifications.addDelegate(this._oDelegateNotifications,false,this);}if(a){a.addDelegate(this._oDelegateAvatar,false,this);}if(this._oControl._oProductSwitcher){this._oControl._oProductSwitcher.addDelegate(this._oDelegateProducts,false,this);}if(this._oControl._oNavButton){this._oControl._oNavButton.addDelegate(this._oDelegateNavButton,false,this);}if(this._oControl._oMenuButton){this._oControl._oMenuButton.addDelegate(this._oDelegateMenuButton,false,this);}};
A.prototype.getRootAttributes=function(){return{role:"banner",label:this.oRb.getText("SHELLBAR_CONTAINER_LABEL")};};
A.prototype.getCoPilotAttributes=function(){return{role:"button",label:this.oRb.getText("SHELLBAR_COPILOT_TOOLTIP")};};
A.prototype.getEntityTooltip=function(e){return this.oRb.getText("SHELLBAR_"+e+"_TOOLTIP")||"";};
A.prototype.updateNotificationsNumber=function(n){var t=this.getEntityTooltip("NOTIFICATIONS"),a=n?n+" "+t:t;this._oControl._oNotifications.setTooltip(a);this._oControl._oNotifications.$().attr("aria-label",a);};
A.prototype.onAfterRenderingSecondTitle=function(){var $=this._oControl._oSecondTitle.$();$.attr("role","heading");$.attr("aria-level","2");};
A.prototype.onAfterRenderingSearch=function(){this._oControl._oSearch.$().attr("aria-label",this.getEntityTooltip("SEARCH"));};
A.prototype.onAfterRenderingNotifications=function(){var $=this._oControl._oNotifications.$(),t=this.getEntityTooltip("NOTIFICATIONS"),n=this._oControl._oNotifications.data("notifications"),a=n?n+" "+t:t;$.attr("aria-label",a);$.attr("aria-haspopup","dialog");};
A.prototype.onAfterRenderingAvatar=function(){var $=this._oControl.getProfile().$();$.attr("aria-label",this.getEntityTooltip("PROFILE"));$.attr("aria-haspopup","menu");};
A.prototype.onAfterRenderingProducts=function(){var $=this._oControl._oProductSwitcher.$();$.attr("aria-label",this.getEntityTooltip("PRODUCTS"));$.attr("aria-haspopup","menu");};
A.prototype.onAfterRenderingNavButton=function(){this._oControl._oNavButton.$().attr("aria-label",this.getEntityTooltip("BACK"));};
A.prototype.onAfterRenderingMenuButton=function(){var $=this._oControl._oMenuButton.$();$.attr("aria-label",this.getEntityTooltip("MENU"));$.attr("aria-haspopup","menu");};
A.prototype.exit=function(){var a=this._oControl.getProfile();if(this._oControl){this._oControl.removeDelegate(this._controlDelegate);}if(this._oControl._oSecondTitle){this._oControl._oSecondTitle.removeDelegate(this._oDelegateSecondTitle);}if(this._oControl._oSearch){this._oControl._oSearch.removeDelegate(this._oDelegateSearch);}if(this._oControl._oNotifications){this._oControl._oNotifications.removeDelegate(this._oDelegateNotifications);}if(a){a.removeDelegate(this._oDelegateAvatar);}if(this._oControl._oProductSwitcher){this._oControl._oProductSwitcher.removeDelegate(this._oDelegateProducts);}if(this._oControl._oNavButton){this._oControl._oNavButton.removeDelegate(this._oDelegateNavButton);}if(this._oControl._oMenuButton){this._oControl._oMenuButton.removeDelegate(this._oDelegateMenuButton);}};
return A;});
sap.ui.predefine('sap/f/shellBar/AdditionalContentSupport',["sap/m/OverflowToolbarLayoutData","sap/base/Log","sap/m/library"],function(O,L,l){"use strict";var a=l.OverflowToolbarPriority;var A=function(){if(!this.isA("sap.ui.core.Element")){return;}this._prepareNewAdditionalControl=function(c){if(!c.getLayoutData()){c.setLayoutData(new O({priority:a.Low}));}return c;};this.addAdditionalContent=function(c){this.validateAggregation("additionalContent",c,true);if(this.indexOfAdditionalContent(c)!==-1){L.warning("Object"+c+" is already added to ShellBar");return this;}this._aAdditionalContent.push(this._prepareNewAdditionalControl(c));this._updateParent();return this;};this.insertAdditionalContent=function(c,i){this.validateAggregation("additionalContent",c,true);if(this.indexOfAdditionalContent(c)!==-1){L.warning("Object"+c+" is already added to ShellBar");return this;}this._aAdditionalContent.splice(i,0,c);this._updateParent();return this;};this.indexOfAdditionalContent=function(c){for(var i=0;i<this._aAdditionalContent.length;i++){if(this._aAdditionalContent[i]===c){return i;}}return-1;};this.removeAdditionalContent=function(o){var c,i,_=o;if(typeof(_)==="string"){for(i=0;i<this._aAdditionalContent.length;i++){if(this._aAdditionalContent[i]&&this._aAdditionalContent[i].getId()===_){_=i;break;}else if(i===this._aAdditionalContent.length-1){_=-1;}}}if(typeof(_)==="object"){for(i=0;i<this._aAdditionalContent.length;i++){if(this._aAdditionalContent[i]===_){_=i;break;}else if(i===this._aAdditionalContent.length-1){_=-1;}}}if(typeof(_)==="number"){if(_<0||_>=this._aAdditionalContent.length){L.warning("ShellBar.removeAggregation AdditionalContent called with invalid parameter for "+"non-existing object:, "+o);return null;}else{c=this._aAdditionalContent[_];this._aAdditionalContent.splice(_,1);c.setParent(null);this._updateParent();return c;}}else{return null;}};this.removeAllAdditionalContent=function(){var c,C=this._aAdditionalContent,i;if(!C){return[];}this._aAdditionalContent=[];for(i=0;i<C.length;i++){c=C[i];c.setParent(null);}this._updateParent();return C;};this.destroyAdditionalContent=function(){this._aAdditionalContent.forEach(this._destroyAllAdditionalContent,this);this._aAdditionalContent=[];this._updateParent();return this;};this._destroyAllAdditionalContent=function(c){return c.destroy();};this.getAdditionalContent=function(){return this._aAdditionalContent;};this._updateParent=function(){this._bOTBUpdateNeeded=true;this.invalidate();};};return A;});
sap.ui.predefine('sap/f/shellBar/CoPilot',["sap/ui/core/Control","sap/ui/core/Configuration","sap/f/shellBar/CoPilotRenderer"],function(C,a,b){"use strict";
var c=C.extend("sap.f.shellBar.CoPilot",{
metadata:{library:"sap.f",events:{press:{}}},
renderer:b
});
c.prototype.ontap=function(e){e.setMarked();this.firePress({});};
c.prototype.getAnimation=function(){return sap.ui.getCore().getConfiguration().getAnimationMode()!==a.AnimationMode.none;};
return c;});
sap.ui.predefine('sap/f/shellBar/CoPilotRenderer',['./Accessibility'],function(A){"use strict";var C={};
C.render=function(r,c){var a=new A(),o=a.getCoPilotAttributes(),t=c.getTooltip();r.write("<div");r.writeAttribute("tabindex","0");if(t){r.writeAttributeEscaped("title",t);}r.writeAccessibilityState({role:o.role,label:o.label});r.writeControlData(c);r.addClass("CPImage");r.writeStyles();r.writeClasses();r.write(">");if(c.getAnimation()){r.write('<svg focusable="false" alt="'+t+'" role="presentation" version="1.1" width="48" height="48" viewBox="-150 -150 300 300" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"><defs><linearGradient id="grad1" x1="0%" x2="100%" y1="100%" y2="0%"><stop class="color1" offset="0%" style="stop-opacity:0.7"/><stop class="color2" offset="80%" style="stop-opacity:0.7"/></linearGradient><linearGradient id="grad2" x1="0%" x2="100%" y1="100%" y2="0%"><stop class="color1" offset="0%" style="stop-opacity:0.36"/><stop class="color2" offset="80%" style="stop-opacity:0.36"/></linearGradient><linearGradient id="grad3" x1="0%" x2="100%" y1="100%" y2="0%"><stop class="color1" offset="0%" style="stop-opacity:0.2"/><stop class="color2" offset="80%" style="stop-opacity:0.2"/></linearGradient><mask id="innerCircle"><circle cx="0" cy="0" r="120" fill="white" /><circle cx="0" cy="0" r="76" fill="black" /></mask>'+'<path id="path" d="M 102 0 C 102 17.85 86.87 29.53 77.94 44.99 C 69.01 60.46 66.46 79.4 51 88.33 C 35.53 97.26 17.85 90 5.51000e-15 90 C -17.85 90 -35.53 97.26 -50.99 88.33 C -66.46 79.4 -69.01 60.46 -77.94 45 C -86.87 29.53 -102 17.85 -102 1.24000e-14 C -102 -17.85 -86.87 -29.53 -77.94 -44.99 C -69.01 -60.46 -66.46 -79.4 -51 -88.33 C -35.53 -97.26 -17.85 -89.99 -1.65000e-14 -90 C 17.85 -90 35.53 -97.26 50.99 -88.33 C 66.46 -79.4 69.01 -60.46 77.94 -45 C 86.87 -29.53 102 -17.85 102 0 Z M 97.27 0 C 98.58 17.55 94.29 34.2 84.09 48.54 C 74.21 62.42 58.47 67.23 43.57 75.46 C 28.94 83.54 16.64 93.54 5.81000e-15 95 C -17.27 96.5 -33.78 93.13 -48.19 83.47 C -62.26 74.04 -68.01 58.82 -76.14 43.96 C -84.09 29.4 -92 16.48 -93.8 1.14000e-14 C -95.7 -17.53 -94.76 -34.35 -86.34 -49.84 C -77.83 -65.5 -64.53 -76.31 -48.31 -83.67 C -32.81 -90.7 -17 -88.78 -1.63000e-14 -89 C 17.21 -89.21 34.09 -93.47 49 -84.87 C 63.91 -76.28 68.61 -59.49 77.12 -44.53 C 85.58 -29.66 95.99 -17.05 97.27 0 Z" dur="30s" repeatCount="indefinite"/><animateTransform attributeName="transform" type="scale" values="1;1.05;1.05;1.02;1" dur="0.15s" begin="click_area.mousedown" repeatCount="1" additive="sum"/></path></defs><g style="mask: url(#innerCircle)"><g fill="url(#grad3)" transform="rotate(54)"><use xlink:href="#path"><animateTransform id="animate1" attributeName="transform" type="rotate" from="54" to="416" dur="15s" repeatCount="indefinite"/></use></g><g fill="url(#grad2)" transform="rotate(74)"><use xlink:href="#path" /></g><g fill="url(#grad1)" transform="rotate(90)"><use xlink:href="#path"><animateTransform id="animate2" attributeName="transform" type="rotate" from="90" to="450" dur="30s" repeatCount="indefinite"/></use></g></g><circle cx="0" cy="0" r="76" fill="transparent" id="click_area"/></svg>');}else{r.write('<svg focusable="false" alt="'+t+'" role="presentation" version="1.1" width="48" height="48" viewBox="-150 -150 300 300" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"><defs><linearGradient id="grad1" x1="0%" x2="100%" y1="100%" y2="0%"><stop class="color1" offset="0%" style="stop-opacity:0.7"/><stop class="color2" offset="80%" style="stop-opacity:0.7"/></linearGradient><linearGradient id="grad2" x1="0%" x2="100%" y1="100%" y2="0%"><stop class="color1" offset="0%" style="stop-opacity:0.36"/><stop class="color2" offset="80%" style="stop-opacity:0.36"/></linearGradient><linearGradient id="grad3" x1="0%" x2="100%" y1="100%" y2="0%"><stop class="color1" offset="0%" style="stop-opacity:0.2"/><stop class="color2" offset="80%" style="stop-opacity:0.2"/></linearGradient><mask id="innerCircle"><circle cx="0" cy="0" r="120" fill="white" /><circle cx="0" cy="0" r="76" fill="black" /></mask><path id="path" d="M 98.1584 0 C 98.3156 17.3952 89.0511 31.3348 79.5494 45.9279 C 70.339 60.0814 60.6163 71.2177 46.1724 79.9729 C 31.4266 88.9178 17.2493 94.3909 5.77261e-15 94.2739 C -17.1547 94.1581 -30.8225 87.6907 -45.7979 79.3244 C -61.0143 70.8266 -73.5583 62.554 -83.0507 47.9493 C -92.6677 33.1579 -98.4872 17.5705 -97.1793 1.19010e-14 C -95.9465 -16.9777 -84.488 -29.0862 -76.1351 -43.9566 C -67.6795 -59.0155 -63.8629 -76.1085 -49.262 -85.3243 C -34.502 -94.6464 -17.4328 -93.0037 -1.69174e-14 -92.0939 C 16.8967 -91.214 31.8608 -89.0341 46.4198 -80.4014 C 60.872 -71.8326 69.6003 -59.5351 78.6792 -45.4254 C 88.0511 -30.9104 98.015 -17.2766 98.1584 0 Z"/></defs><g style="mask: url(#innerCircle)"><g fill="url(#grad3)" transform="rotate(54)"><use xlink:href="#path"/></g><g fill="url(#grad2)" transform="rotate(74)"><use xlink:href="#path" /></g><g fill="url(#grad1)" transform="rotate(90)"><use xlink:href="#path"/></g></g><circle cx="0" cy="0" r="76" fill="transparent" id="click_area"/></svg>');}r.write("</div>");};
return C;},true);
sap.ui.predefine('sap/f/shellBar/ControlSpacer',['sap/ui/core/Control','sap/f/shellBar/ControlSpacerRenderer'],function(C,a){"use strict";
var b=C.extend("sap.f.shellBar.ControlSpacer",{
metadata:{library:"sap.f",properties:{width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:''}}},
renderer:a
});
b.prototype.setWidth=function(w){if(this.$().length){this.$().width(w);}return this.setProperty("width",w,true);};
return b;});
sap.ui.predefine('sap/f/shellBar/ControlSpacerRenderer',[],function(){"use strict";var C={apiVersion:2};
C.render=function(r,c){r.openStart("div",c);r.class("sapMTBSpacer");r.style("width",c.getWidth());r.openEnd().close("div");};
return C;},true);
sap.ui.predefine('sap/f/shellBar/Factory',["sap/m/Title","sap/m/Image","sap/m/MenuButton","sap/m/OverflowToolbar","sap/m/OverflowToolbarButton","sap/m/ToolbarSpacer","sap/m/OverflowToolbarLayoutData","sap/m/FlexItemData","./CoPilot","./Accessibility","sap/m/library","sap/ui/core/library","sap/ui/core/theming/Parameters","sap/m/HBox"],function(T,I,M,O,a,b,c,F,C,A,l,d,P,H){"use strict";var e=l.OverflowToolbarPriority;var f=l.ToolbarDesign;var B=l.ButtonType;var g=d.TitleLevel;var h=function(o){this._oContext=o;this._oControls={};this._oAcc=new A();};
h.prototype.getOverflowToolbar=function(){if(!this._oControls.oOverflowToolbar){this._oControls.oOverflowToolbar=new O({design:f.Transparent,style:"Clear"}).addStyleClass("sapFShellBarOTB").setLayoutData(new F({growFactor:1,shrinkFactor:1,minWidth:"0px",maxWidth:"100%"}))._setEnableAccessibilty(false);this._oControls.oOverflowToolbar._getOverflowButton().addStyleClass("sapFShellBarItem sapFShellBarOverflowButton");}return this._oControls.oOverflowToolbar;};
h.prototype.getAdditionalBox=function(){if(!this._oControls.oAdditionalBox){this._oControls.oAdditionalBox=new H({alignItems:"Center"}).addStyleClass("sapFShellBarOAHB");}return this._oControls.oAdditionalBox;};
h.prototype.getToolbarSpacer=function(){if(!this._oControls.oToolbarSpacer){this._oControls.oToolbarSpacer=new b();}return this._oControls.oToolbarSpacer;};
h.prototype.getSecondTitle=function(){if(!this._oControls.oSecondTitle){this._oControls.oSecondTitle=new T({titleStyle:g.H6}).addStyleClass("sapFShellBarSecondTitle").setLayoutData(new F({shrinkFactor:2,minWidth:"1px"}));}this._oControls.oSecondTitle._sFontSize=P.get("_sap_f_ShellBar_SecondTitle_FontSize");return this._oControls.oSecondTitle;};
h.prototype.getHomeIcon=function(){if(!this._oControls.oHomeIcon){this._oControls.oHomeIcon=new I({densityAware:false,tooltip:this._oAcc.getEntityTooltip("LOGO"),press:function(){this._oContext.fireEvent("homeIconPressed",{icon:this._oControls.oHomeIcon});}.bind(this)}).addStyleClass("sapFShellBarHomeIcon");}return this._oControls.oHomeIcon;};
h.prototype.getMegaMenu=function(){if(!this._oControls.oMegaMenu){this._oControls.oMegaMenu=new M({type:B.Transparent,iconDensityAware:false,layoutData:new F({shrinkFactor:0,minWidth:"0px",maxWidth:"100%"})}).addStyleClass("sapFSHMegaMenu");}this._oControls.oMegaMenu._sFontSize=P.get("_sap_f_ShellBar_PrimaryTitle_FontSize");return this._oControls.oMegaMenu;};
h.prototype.getPrimaryTitle=function(){if(!this._oControls.oPrimaryTitle){this._oControls.oPrimaryTitle=new T({titleStyle:g.H6,level:g.H1}).setLayoutData(new F({shrinkFactor:0,minWidth:"0px",maxWidth:"100%"})).addStyleClass("sapFShellBarPrimaryTitle");}this._oControls.oPrimaryTitle._sFontSize=P.get("_sap_f_ShellBar_PrimaryTitle_FontSize");return this._oControls.oPrimaryTitle;};
h.prototype.getCopilot=function(){if(!this._oControls.oCopilot){this._oControls.oCopilot=new C({tooltip:this._oAcc.getEntityTooltip("COPILOT"),press:function(){this._oContext.fireEvent("copilotPressed",{image:this._oControls.oCopilot});}.bind(this)});}return this._oControls.oCopilot;};
h.prototype.getSearch=function(){if(!this._oControls.oSearch){this._oControls.oSearch=new a({text:"Search",icon:"sap-icon://search",type:B.Transparent,tooltip:this._oAcc.getEntityTooltip("SEARCH"),press:function(){this._oContext.fireEvent("searchButtonPressed",{button:this._oControls.oSearch});}.bind(this)}).setLayoutData(new c({priority:e.Low}));}return this._oControls.oSearch;};
h.prototype.getManagedSearch=function(){if(!this._oControls.oManagedSearch){this._oControls.oManagedSearch=this._oContext.getSearchManager()._oSearch;}return this._oControls.oManagedSearch;};
h.prototype.getNavButton=function(){if(!this._oControls.oNavButton){this._oControls.oNavButton=new a({icon:"sap-icon://nav-back",type:B.Transparent,tooltip:this._oAcc.getEntityTooltip("BACK"),press:function(){this._oContext.fireEvent("navButtonPressed",{button:this._oControls.oNavButton});}.bind(this)});}return this._oControls.oNavButton;};
h.prototype.getMenuButton=function(){if(!this._oControls.oMenuButton){this._oControls.oMenuButton=new a({icon:"sap-icon://menu2",type:B.Transparent,tooltip:this._oAcc.getEntityTooltip("MENU"),press:function(){this._oContext.fireEvent("menuButtonPressed",{button:this._oControls.oMenuButton});}.bind(this)});}return this._oControls.oMenuButton;};
h.prototype.getNotifications=function(){if(!this._oControls.oNotifications){this._oControls.oNotifications=new a({text:"Notifications",icon:"sap-icon://bell",type:B.Transparent,tooltip:this._oAcc.getEntityTooltip("NOTIFICATIONS"),press:function(){this._oContext.fireEvent("notificationsPressed",{button:this._oControls.oNotifications});}.bind(this)}).addStyleClass("sapFButtonNotifications").setLayoutData(new c({priority:e.Low}));}return this._oControls.oNotifications;};
h.prototype.getProductSwitcher=function(){if(!this._oControls.oProductSwitcher){this._oControls.oProductSwitcher=new a({text:"My products",icon:"sap-icon://grid",type:B.Transparent,tooltip:this._oAcc.getEntityTooltip("PRODUCTS"),press:function(){this._oContext.fireEvent("productSwitcherPressed",{button:this._oControls.oProductSwitcher});}.bind(this)}).addStyleClass("sapFShellBarGridButton").addStyleClass("sapFShellBarItem");}return this._oControls.oProductSwitcher;};
h.prototype.destroy=function(){Object.keys(this._oControls).forEach(function(k){var o=this._oControls[k];if(o){o.destroy();}}.bind(this));};
return h;});
sap.ui.predefine('sap/f/shellBar/ResponsiveHandler',["sap/m/OverflowToolbarLayoutData","sap/ui/Device","sap/ui/core/ResizeHandler","sap/ui/dom/units/Rem","sap/m/library"],function(O,D,R,a,l){"use strict";var b=l.OverflowToolbarPriority;var M=12;var c=function(C){this._oControl=C;this._oDelegate={onAfterRendering:this.onAfterRendering,onBeforeRendering:this.onBeforeRendering};this._oControl.addDelegate(this._oDelegate,false,this);this.sCurrentRange="";this._bAttachedManagedSearchHandler=false;this._oControl._iResizeHandlerId=R.register(this._oControl,this._handleResize.bind(this));this._iMinSearchWidth=a.toPx(M);};
c.prototype.onAfterRendering=function(){var p=D.media.getCurrentRange("Std",this._oControl.$().outerWidth(true)).name==="Phone";this._oButton=this._oControl._oMegaMenu&&this._oControl._oMegaMenu.getAggregation("_button");this._oDomRef=this._oControl.getDomRef();this.bIsMegaMenuConfigured=this._oControl._oTitleControl&&this._oControl._oTitleControl===this._oControl._oMegaMenu;if(this._oControl._oManagedSearch&&!this._bAttachedManagedSearchHandler){this._oControl._oManagedSearch.attachEvent("_updateVisualState",this._switchOpenStateOnSearch,this);this._bAttachedManagedSearchHandler=true;}if(p){this._transformTitleControlMobile();}this._handleResize();};
c.prototype.exit=function(){if(this._oControl._iResizeHandlerId){R.deregister(this._oControl._iResizeHandlerId);this._oControl._iResizeHandlerId=null;}};
c.prototype._handleResize=function(){if(!this._oDomRef){return;}var C=this._oControl.$(),w=C.outerWidth(),o=D.media.getCurrentRange("Std",w),p;this.sCurrentRange=o.name;if(o){p=this.sCurrentRange==="Phone";C.toggleClass("sapFShellBarSizeDesktop",this.sCurrentRange==="Desktop");C.toggleClass("sapFShellBarSizeTablet",this.sCurrentRange==="Tablet");C.toggleClass("sapFShellBarSizePhone",p);}if(this._oControl._oManagedSearch&&this._oControl._oManagedSearch.getIsOpen()){setTimeout(this._adaptSearch.bind(this),100);}else{this._oControl._bSearchPlaceHolder=false;}if(this._iPreviousWidth===w){return;}this._iPreviousWidth=w;if(!this._oControl._oNavButton&&!this._oControl._oMenuButton&&!this._oControl._oHomeIcon&&!this._oControl._oMegaMenu&&!this._oControl._oSecondTitle&&!this._oControl._oManagedSearch&&!this._oControl._oCopilot){return;}if(p&&!this.bWasInPhoneRange){this._transformToPhoneState();}else if(!p&&this.bWasInPhoneRange){this._transformToRegularState();}};
c.prototype._switchOpenStateOnSearch=function(){var s=this._oControl._oManagedSearch;if(!s){return;}if(this.bWasInPhoneRange){this._transformToPhoneState();}else{this._transformToRegularState();}this._oControl.toggleStyleClass("sapFShellBarSearchIsOpen",s.getIsOpen());};
c.prototype._transformToPhoneState=function(){var s=this._oControl._oManagedSearch,o=this._oControl._getOverflowToolbar().getContent(),S=this._oControl._oToolbarSpacer;if(this._oControl._oSecondTitle){this._oControl._oSecondTitle.setVisible(false);}this._transformTitleControlMobile();if(!this._bControlsLayoutDataCached){this._cacheControlsLayoutData();this._bControlsLayoutDataCached=true;}o.forEach(function(C){if(C===S){return;}C.setLayoutData(new O({priority:b.AlwaysOverflow}));});this.bWasInPhoneRange=true;if(s){s.setPhoneMode(true);if(s.getIsOpen()){this._toggleAllControlsExceptSearch(true);this._bSearchWasOpen=true;}else if(this._bSearchWasOpen){this._toggleAllControlsExceptSearch(false);this._bSearchWasOpen=false;}}this._oControl.invalidate();};
c.prototype._transformToRegularState=function(){var s=this._oControl._oManagedSearch;this._toggleAllControlsExceptSearch(false);if(this._oControl._oSecondTitle){this._oControl._oSecondTitle.setVisible(true);}if(this._oControl._oHomeIcon){if(this._oControl._oMegaMenu){this._oControl._oMegaMenu.setText(this._oControl._sTitle).setIcon("");}if(this._oControl._oPrimaryTitle){this._oControl._oPrimaryTitle.setText(this._oControl._sTitle);}if(this.bIsMegaMenuConfigured){this._oControl._oHomeIcon.setVisible(true);}}if(this._bControlsLayoutDataCached){this._restoreControlsLayoutData();this._bControlsLayoutDataCached=false;}this.bWasInPhoneRange=false;if(s){s.setPhoneMode(false);this._oControl._bSearchPlaceHolder=false;}this._oControl.invalidate();};
c.prototype._transformTitleControlMobile=function(){var C;if(!this._oControl._oHomeIcon){return this.bIsMegaMenuConfigured?this._oControl._oMegaMenu.setText(this._oControl.getTitle()).setIcon(""):false;}C=this.bIsMegaMenuConfigured&&this._oControl._oHomeIcon.getVisible()||!this.bIsMegaMenuConfigured&&!this._oControl._oHomeIcon.getVisible();if(this._oControl._oMegaMenu){this._oControl._oMegaMenu.setText("").setIcon(this._oControl.getHomeIcon());}if(this._oControl._oPrimaryTitle){this._oControl._oPrimaryTitle.setText("");}if(C){this._oControl._oHomeIcon.setVisible(!this.bIsMegaMenuConfigured);this._oControl.invalidate();}};
c.prototype._adaptSearch=function(){var s=this._oControl._oManagedSearch,S;if(!s||this.sCurrentRange==="Phone"){return;}S=s.$().width();if(this._oControl._bSearchPlaceHolder){if(S>=this._iMinSearchWidth){this._oControl._bSearchPlaceHolder=false;this._toggleAllControlsExceptSearch(false);}}else if(S<this._iMinSearchWidth){this._oControl._bSearchPlaceHolder=true;this._toggleAllControlsExceptSearch(true);}else if(s.hasStyleClass("sapFShellBarSearchOpenTick")){s.removeStyleClass("sapFShellBarSearchOpenTick");this._adaptSearch();}return this;};
c.prototype._toggleAllControlsExceptSearch=function(s){var S=this._oControl._oManagedSearch;this._oControl.toggleStyleClass("sapFShellBarFullSearch",s);S&&S.toggleStyleClass("sapFShellBarSearchFullWidth",s);};
c.prototype._cacheControlsLayoutData=function(){var o=this._oControl._getOverflowToolbar().getContent();this._oCachedLayoutData={};o.forEach(function(C){this._oCachedLayoutData[C.getId()]=C.getLayoutData();},this);};
c.prototype._restoreControlsLayoutData=function(){var o=this._oControl._getOverflowToolbar().getContent();o.forEach(function(C){var L=this._oCachedLayoutData[C.getId()];if(L){C.setLayoutData(L);}},this);};
return c;});
sap.ui.predefine('sap/f/shellBar/Search',['sap/ui/core/Control','sap/f/shellBar/SearchRenderer','sap/m/SearchField','sap/m/OverflowToolbarButton',"sap/m/OverflowToolbarLayoutData","sap/m/Button","sap/ui/events/KeyCodes","./Accessibility","sap/m/library"],function(C,S,a,O,b,B,K,A,l){"use strict";var c=l.ButtonType;var d=l.OverflowToolbarPriority;
var e=C.extend("sap.f.shellBar.Search",{
metadata:{interfaces:["sap.m.IOverflowToolbarContent"],library:"sap.f",properties:{isOpen:{type:"boolean",defaultValue:false},phoneMode:{type:"boolean",defaultValue:false},width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null}},aggregations:{_searchField:{type:"sap.m.SearchField",multiple:false},_searchButton:{type:"sap.m.OverflowToolbarButton",multiple:false},_cancelButton:{type:"sap.m.Button",multiple:false}},events:{search:{parameters:{query:{type:"string"},clearButtonPressed:{type:"boolean"}}},liveChange:{parameters:{newValue:{type:"string"}}},suggest:{parameters:{suggestValue:{type:"string"}}}}},
renderer:S
});
e.prototype.init=function(){this._sOldValue="";this._shouldFocusSearch=false;this._layoutDataWhenOpen=new b({priority:d.NeverOverflow});this._layoutDataWhenClosed=new b({priority:d.Low});this._oAcc=new A();};
e.prototype.onBeforeRendering=function(){this._switchOpenStateOnSearch();};
e.prototype.onAfterRendering=function(){setTimeout(function(){if(this._shouldFocusSearch){this._getSearchField().getFocusDomRef().focus();this._shouldFocusSearch=false;}}.bind(this),0);};
e.prototype.exit=function(){if(this._layoutDataWhenOpen){this._layoutDataWhenOpen.destroy();}if(this._layoutDataWhenClosed){this._layoutDataWhenClosed.destroy();}};
e.prototype._getSearchField=function(){var s=this.getAggregation("_searchField");if(!s){s=new a({showSearchButton:false,search:this._onSearch.bind(this),liveChange:this._onLiveChange.bind(this),suggest:this._onSuggest.bind(this)});this.setAggregation("_searchField",s);}return s;};
e.prototype._getSearchButton=function(){var s=this.getAggregation("_searchButton");if(!s){s=new O({text:"Search",icon:"sap-icon://search",type:c.Transparent,press:this._onPressSearchButtonHandler.bind(this),tooltip:this._oAcc.getEntityTooltip("SEARCH")});this.setAggregation("_searchButton",s);}return s;};
e.prototype._getCancelButton=function(){var o=this.getAggregation("_cancelButton");if(!o){o=new B({text:"Cancel",type:c.Transparent,press:this._onPressCancelButtonHandler.bind(this)});o.addStyleClass("sapFShellBarSearchCancelButton");this.setAggregation("_cancelButton",o);}return o;};
e.prototype.toggleVisibilityOfSearchField=function(){var i=this.getIsOpen();this.setIsOpen(!i);this._shouldFocusSearch=!i;this.fireEvent("_updateVisualState",{isOpen:!i});};
e.prototype._switchOpenStateOnSearch=function(){var L;if(this.getIsOpen()){L=this._layoutDataWhenOpen;}else if(!this._bInOverflow){L=this._layoutDataWhenClosed;}if(!L||this.getLayoutData()===L){return;}this.toggleStyleClass("sapFShellBarSearchOpenTick",this.getIsOpen());this.setLayoutData(L);};
e.prototype._onPressSearchButtonHandler=function(){var s=this._getSearchField();if(s.getValue()&&this.getIsOpen()){this.fireSearch({query:s.getValue(),clearButtonPressed:false});}else{this.toggleVisibilityOfSearchField();}};
e.prototype._onPressCancelButtonHandler=function(){this.toggleVisibilityOfSearchField();};
e.prototype._onSearch=function(E){var n=E.getParameters();n.id=this.getId();if(E.getParameter("clearButtonPressed")){this._shouldCloseOnNextEscape=false;}this.fireSearch(n);};
e.prototype._onLiveChange=function(E){var n=E.getParameters();delete n.refreshButtonPressed;delete n.suggestionItem;n.id=this.getId();this._shouldCloseOnNextEscape=!n.newValue;this.fireLiveChange(n);};
e.prototype._onSuggest=function(E){var n=E.getParameters();n.id=this.getId();this.fireSuggest(n);};
e.prototype.onkeyup=function(E){var s=this._getSearchField();if(E.keyCode===K.ESCAPE){if(s._oSuggest&&s._oSuggest.isOpen()){return;}if(this._shouldCloseOnNextEscape){this._shouldCloseOnNextEscape=false;return;}this.toggleVisibilityOfSearchField();}};
e.prototype._onBeforeEnterOverflow=function(){var s=this._getSearchButton();this._bInOverflow=true;s._bInOverflow=true;s.addStyleClass("sapFShellBarSearchOverflowToolbar");this._switchOpenStateOnSearch();};
e.prototype._onAfterExitOverflow=function(){var s=this._getSearchButton();this._bInOverflow=false;s._bInOverflow=false;s.removeStyleClass("sapFShellBarSearchOverflowToolbar");};
e.prototype.getOverflowToolbarConfig=function(){var o={canOverflow:true};o.onBeforeEnterOverflow=this._onBeforeEnterOverflow.bind(this);o.onAfterExitOverflow=this._onAfterExitOverflow.bind(this);return o;};
return e;});
sap.ui.predefine('sap/f/shellBar/SearchRenderer',[],function(){"use strict";var S={apiVersion:2};
S.render=function(r,s){var o=s._getSearchField(),c=s._getCancelButton(),a=s._getSearchButton(),i=s.getIsOpen(),p=s.getPhoneMode();r.openStart("div",s);if(i){r.class("sapFShellBarSearch");}if(p){r.class("sapFShellBarSearchFullWidth");}r.openEnd();r.openStart("div");r.class("sapFShellBarSearchWrap");r.openEnd();if(i){r.renderControl(o);}r.renderControl(a);if(i){r.renderControl(c);}r.close("div");r.close("div");};
return S;},true);
sap.ui.require.preload({
	"sap/f/manifest.json":'{"_version":"1.21.0","sap.app":{"id":"sap.f","type":"library","embeds":[],"applicationVersion":{"version":"1.84.0"},"title":"SAPUI5 library with Fiori controls.","description":"SAPUI5 library with Fiori controls.","ach":"CA-UI5-CTR","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.84","libs":{"sap.ui.core":{"minVersion":"1.84.0"},"sap.ui.layout":{"minVersion":"1.84.0"},"sap.m":{"minVersion":"1.84.0"}}},"library":{"i18n":{"bundleUrl":"messagebundle.properties","supportedLocales":["","ar","bg","ca","cs","da","de","el","en","en-GB","en-US-sappsd","en-US-saptrc","es","es-MX","et","fi","fr","hi","hr","hu","it","iw","ja","kk","ko","lt","lv","ms","nl","no","pl","pt","rigi","ro","ru","sh","sk","sl","sv","th","tr","uk","vi","zh-CN","zh-TW"]},"content":{"controls":["sap.f.Avatar","sap.f.AvatarGroup","sap.f.AvatarGroupItem","sap.f.cards.Header","sap.f.cards.NumericHeader","sap.f.cards.NumericSideIndicator","sap.f.CalendarInCard","sap.f.Card","sap.f.GridContainer","sap.f.DynamicPage","sap.f.DynamicPageHeader","sap.f.DynamicPageTitle","sap.f.FlexibleColumnLayout","sap.f.semantic.SemanticPage","sap.f.GridList","sap.f.GridListItem","sap.f.PlanningCalendarInCardLegend","sap.f.ProductSwitch","sap.f.ProductSwitchItem","sap.f.ShellBar"],"elements":["sap.f.DynamicPageAccessibleLandmarkInfo","sap.f.GridContainerItemLayoutData","sap.f.semantic.AddAction","sap.f.semantic.CloseAction","sap.f.semantic.CopyAction","sap.f.semantic.DeleteAction","sap.f.semantic.DiscussInJamAction","sap.f.semantic.EditAction","sap.f.semantic.ExitFullScreenAction","sap.f.semantic.FavoriteAction","sap.f.semantic.FlagAction","sap.f.semantic.FooterMainAction","sap.f.semantic.FullScreenAction","sap.f.semantic.MainAction","sap.f.semantic.MessagesIndicator","sap.f.semantic.NegativeAction","sap.f.semantic.PositiveAction","sap.f.semantic.PrintAction","sap.f.semantic.SemanticButton","sap.f.semantic.SemanticControl","sap.f.semantic.SemanticToggleButton","sap.f.semantic.SendEmailAction","sap.f.semantic.SendMessageAction","sap.f.semantic.ShareInJamAction","sap.f.semantic.TitleMainAction","sap.f.SearchManager"],"types":["sap.f.AvatarImageFitType","sap.f.AvatarShape","sap.f.AvatarSize","sap.f.AvatarType","sap.f.AvatarColor","sap.f.AvatarGroupType","sap.f.cards.HeaderPosition","sap.f.DynamicPageTitleArea","sap.f.DynamicPageTitleShrinkRatio","sap.f.LayoutType"],"interfaces":["sap.f.cards.IHeader","sap.f.ICard","sap.f.IShellBar","sap.f.IDynamicPageStickyContent","sap.f.dnd.IGridDroppable"]}}}}'
},"sap/f/library-preload"
);
//# sourceMappingURL=library-preload.js.map