/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./Dialog','./ComboBoxTextField','./Input','./GroupHeaderListItem','./SuggestionsPopover','sap/ui/core/SeparatorItem','sap/ui/core/InvisibleText','sap/base/Log','./library','sap/ui/Device','sap/ui/core/library','./ComboBoxBaseRenderer',"sap/ui/dom/containsOrEquals","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery","sap/base/security/encodeXML","sap/base/strings/escapeRegExp","sap/m/inputUtils/highlightDOMElements"],function(D,C,I,G,S,a,b,L,l,c,d,e,f,K,q,g,h,j){"use strict";var k=l.ListType;var P=l.PlacementType;var m=["value","enabled","name","placeholder","editable","textAlign","textDirection","valueState","valueStateText"];var n=C.extend("sap.m.ComboBoxBase",{metadata:{library:"sap.m","abstract":true,defaultAggregation:"items",properties:{showSecondaryValues:{type:"boolean",group:"Misc",defaultValue:false},formattedTextFocused:{type:"boolean",defaultValue:false,hidden:true},open:{type:"boolean",defaultValue:false,hidden:true}},aggregations:{items:{type:"sap.ui.core.Item",multiple:true,singularName:"item",bindable:"bindable"},picker:{type:"sap.ui.core.PopupInterface",multiple:false,visibility:"hidden"}},events:{loadItems:{}},dnd:{draggable:false,droppable:true}}});n.prototype.oncompositionstart=function(){this._bIsComposingCharacter=true;};n.prototype.oncompositionend=function(E){this._bIsComposingCharacter=false;this._sComposition=E.target.value;if(!c.browser.edge&&!c.browser.firefox){C.prototype.handleInput.apply(this,arguments);this.handleInputValidation(E,this.isComposingCharacter());}};n.prototype.isComposingCharacter=function(){return this._bIsComposingCharacter;};n.prototype.updateItems=function(r){this.bItemsUpdated=false;this.destroyItems();this.updateAggregation("items");this.bItemsUpdated=true;if(this.hasLoadItemsEventListeners()){this.onItemsLoaded();}};n.prototype.setFilterFunction=function(F){if(F===null||F===undefined){this.fnFilter=null;return this;}if(typeof(F)!=="function"){L.warning("Passed filter is not a function and the default implementation will be used");}else{this.fnFilter=F;}return this;};n.prototype.highlightList=function(v){var i=[];i=this._getList().$().find('.sapMSLIInfo, .sapMSLITitleOnly');j(i,v);};n.prototype._modifyPopupInput=function(i){this.setTextFieldHandler(i);return i;};n.prototype.setTextFieldHandler=function(t){var i=this,T=t._handleEvent;t._handleEvent=function(E){T.apply(this,arguments);if(/keydown|sapdown|sapup|saphome|sapend|sappagedown|sappageup|input/.test(E.type)){i._handleEvent(E);}};};n.prototype.refreshItems=function(){this.bItemsUpdated=false;this.refreshAggregation("items");};n.prototype.loadItems=function(i,o){var p=typeof i==="function";if(this.hasLoadItemsEventListeners()&&(this.getItems().length===0)){this._bOnItemsLoadedScheduled=false;if(p){o=q.extend({action:i,busyIndicator:true,busyIndicatorDelay:300},o);this.aMessageQueue.push(o);if((this.iLoadItemsEventInitialProcessingTimeoutID===-1)&&(o.busyIndicator)){this.iLoadItemsEventInitialProcessingTimeoutID=setTimeout(function r(){this.setInternalBusyIndicatorDelay(0);this.setInternalBusyIndicator(true);}.bind(this),o.busyIndicatorDelay);}}if(!this.bProcessingLoadItemsEvent){this.bProcessingLoadItemsEvent=true;this.fireLoadItems();}}else if(p){i.call(this);}};n.prototype.onItemsLoaded=function(){this.bProcessingLoadItemsEvent=false;clearTimeout(this.iLoadItemsEventInitialProcessingTimeoutID);if(this.bInitialBusyIndicatorState!==this.getBusy()){this.setInternalBusyIndicator(this.bInitialBusyIndicatorState);}if(this.iInitialBusyIndicatorDelay!==this.getBusyIndicatorDelay()){this.setInternalBusyIndicatorDelay(this.iInitialBusyIndicatorDelay);}for(var i=0,o,N,p;i<this.aMessageQueue.length;i++){o=this.aMessageQueue.shift();i--;p=(i+1)===this.aMessageQueue.length;N=p?null:this.aMessageQueue[i+1];if(typeof o.action==="function"){if((o.name==="input")&&!p&&(N.name==="input")){continue;}o.action.call(this);}}};n.prototype.hasLoadItemsEventListeners=function(){return this.hasListeners("loadItems");};n.prototype._scheduleOnItemsLoadedOnce=function(){if(!this._bOnItemsLoadedScheduled&&!this.isBound("items")&&this.hasLoadItemsEventListeners()&&this.bProcessingLoadItemsEvent){this._bOnItemsLoadedScheduled=true;setTimeout(this.onItemsLoaded.bind(this),0);}};n.prototype.getPickerInvisibleTextId=function(){return b.getStaticId("sap.m","COMBOBOX_AVAILABLE_OPTIONS");};n.prototype._getGroupHeaderInvisibleText=function(){if(!this._oGroupHeaderInvisibleText){this._oGroupHeaderInvisibleText=new b();this._oGroupHeaderInvisibleText.toStatic();}return this._oGroupHeaderInvisibleText;};n.prototype._getItemByListItem=function(o){return this._getItemBy(o,"ListItem");};n.prototype._getItemBy=function(o,s){s=this.getRenderer().CSS_CLASS_COMBOBOXBASE+s;for(var i=0,p=this.getItems(),r=p.length;i<r;i++){if(p[i].data(s)===o){return p[i];}}return null;};n.prototype._isListInSuggestMode=function(){return this._getList().getItems().some(function(o){return!o.getVisible()&&this._getItemByListItem(o).getEnabled();},this);};n.prototype.getListItem=function(i){return i?i.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"ListItem"):null;};n.prototype.getSelectable=function(i){return i._bSelectable;};n.prototype._setItemsShownWithFilter=function(v){this._bItemsShownWithFilter=v;};n.prototype._getItemsShownWithFilter=function(){return this._bItemsShownWithFilter;};n.prototype.init=function(){C.prototype.init.apply(this,arguments);this.setPickerType(c.system.phone?"Dialog":"Dropdown");this._setItemsShownWithFilter(false);this.bItemsUpdated=false;this.bOpenedByKeyboardOrButton=false;this._bShouldClosePicker=false;this._oPickerValueStateText=null;this.bProcessingLoadItemsEvent=false;this.iLoadItemsEventInitialProcessingTimeoutID=-1;this.aMessageQueue=[];this.bInitialBusyIndicatorState=this.getBusy();this.iInitialBusyIndicatorDelay=this.getBusyIndicatorDelay();this._bOnItemsLoadedScheduled=false;this._bDoTypeAhead=true;this.getIcon().addEventDelegate({onmousedown:function(E){this._bShouldClosePicker=this.isOpen();}},this);this.getIcon().attachPress(this._handlePopupOpenAndItemsLoad.bind(this,true));this._sComposition="";this.fnFilter=null;};n.prototype.onBeforeRendering=function(){var s=this.getOpen(),v=s?this._getSuggestionsPopover()._getValueStateHeader().getText():null,V=s?this._getSuggestionsPopover()._getValueStateHeader().getValueState():null;C.prototype.onBeforeRendering.apply(this,arguments);if(s&&((this.getValueStateText()&&v!==this.getValueStateText())||(this.getValueState()!==V)||this.getFormattedValueStateText())){this._updateSuggestionsPopoverValueState();}};n.prototype._handlePopupOpenAndItemsLoad=function(o){var p;if(!this.getEnabled()||!this.getEditable()){return;}if(o&&this._getItemsShownWithFilter()){this._bShouldClosePicker=false;this.toggleIconPressedStyle(true);this.bOpenedByKeyboardOrButton=false;this.clearFilter();this._setItemsShownWithFilter(false);return;}if(this._bShouldClosePicker){this._bShouldClosePicker=false;this.close();return;}this.loadItems();this.bOpenedByKeyboardOrButton=o;if(this.isPlatformTablet()){this.syncPickerContent();p=this.getPicker();p.setInitialFocus(p);}this.open();};n.prototype.exit=function(){C.prototype.exit.apply(this,arguments);if(this._getList()){this._getList().destroy();this._oList=null;}if(this._getGroupHeaderInvisibleText()){this._getGroupHeaderInvisibleText().destroy();this._oGroupHeaderInvisibleText=null;}clearTimeout(this.iLoadItemsEventInitialProcessingTimeoutID);this.aMessageQueue=null;this.fnFilter=null;};n.prototype.onsapshow=function(E){if(!this.getEnabled()||!this.getEditable()){return;}E.setMarked();if(E.keyCode===K.F4){this.onF4(E);}if(this._getItemsShownWithFilter()){this.loadItems(this._handlePopupOpenAndItemsLoad.bind(this,true));return;}if(this.isOpen()){this.close();return;}this.selectText(0,this.getValue().length);this.loadItems();this.bOpenedByKeyboardOrButton=true;this.open();};n.prototype.onF4=function(E){E.preventDefault();};n.prototype.onsapescape=function(E){if(this.getEnabled()&&this.getEditable()&&this.isOpen()){E.setMarked();E.preventDefault();this.close();}else{C.prototype.onsapescape.apply(this,arguments);}};n.prototype.onsaphide=n.prototype.onsapshow;n.prototype.onsapfocusleave=function(E){if(!E.relatedControlId){C.prototype.onsapfocusleave.apply(this,arguments);return;}var r=sap.ui.getCore().byId(E.relatedControlId);if(r===this){return;}var p=this.getPicker(),F=r&&r.getFocusDomRef();if(p&&f(p.getFocusDomRef(),F)){return;}C.prototype.onsapfocusleave.apply(this,arguments);};n.prototype.getPopupAnchorDomRef=function(){return this.getDomRef();};n.prototype.addContent=function(p){};n.prototype.getList=function(){L.warning("[Warning]:","You are attempting to use deprecated method 'getList()', please refer to SAP note 2746748.",this);return this._getList();};n.prototype._getList=function(){if(this.bIsDestroyed){return null;}return this._oList;};n.prototype.setPickerType=function(p){this._sPickerType=p;};n.prototype.getPickerType=function(){return this._sPickerType;};n.prototype._updateSuggestionsPopoverValueState=function(){var s=this._getSuggestionsPopover();if(!s){return;}var v=this.getValueState(),N=this.getValueState()!==s._getValueStateHeader().getValueState(),o=this.getFormattedValueStateText(),V=this.getValueStateText(),i=o||N;if(s.isOpen()&&!i){this.setFormattedValueStateText(s._getValueStateHeader().getFormattedText());}s.updateValueState(v,(o||V),this.getShowValueStateMessage());};n.prototype.shouldValueStateMessageBeOpened=function(){var s=C.prototype.shouldValueStateMessageBeOpened.apply(this,arguments);return(s&&!this.isOpen());};n.prototype.onPropertyChange=function(o,i){var N=o.getParameter("newValue"),p=o.getParameter("name"),M="set"+p.charAt(0).toUpperCase()+p.slice(1),r=(i&&i.srcControl)||this.getPickerTextField();if(this.getInputForwardableProperties().indexOf(p)>-1&&r&&(typeof r[M]==="function")){r[M](N);}};n.prototype.getInputForwardableProperties=function(){return m;};n.prototype.isPickerDialog=function(){return this.getPickerType()==="Dialog";};n.prototype.isPlatformTablet=function(){var N=!c.system.combi,t=c.system.tablet&&N;return t;};n.prototype.createPickerTextField=function(){var i=new I({width:"100%",showValueStateMessage:false});return i;};n.prototype.getDropdownSettings=function(){return{showArrow:false,placement:P.VerticalPreferredBottom,offsetX:0,offsetY:0,bounce:false,ariaLabelledBy:this.getPickerInvisibleTextId()||undefined};};n.prototype._configureList=function(){};n.prototype.createPicker=function(p){var o=this.getAggregation("picker");if(o){return o;}this._oSuggestionPopover=this._createSuggestionsPopover();o=this._oSuggestionPopover._oPopover;this.setAggregation("picker",o,true);this.configPicker(o);return o;};n.prototype.configPicker=function(p){};n.prototype._hasShowSelectedButton=function(){return false;};n.prototype._createSuggestionsPopover=function(){var u=this.isPickerDialog(),s;s=new S(this);if(u){var i=this.createPickerTextField();s._oPopupInput=this._modifyPopupInput(i);}s._createSuggestionPopup({showSelectedButton:this._hasShowSelectedButton()});s._createSuggestionPopupContent(false);this.forwardEventHandlersToSuggPopover(s);this._oList=s._oList;this._configureList(this._oList);return s;};n.prototype.forwardEventHandlersToSuggPopover=function(s){s.setOkPressHandler(this._handleOkPress.bind(this));s.setCancelPressHandler(this._handleCancelPress.bind(this));s.setInputLabels(this.getLabels.bind(this));};n.prototype._handleOkPress=function(){var t=this,T=t.getPickerTextField();t.updateDomValue(T.getValue());t.onChange();t.close();};n.prototype._handleCancelPress=function(){this.close();this.revertSelection();};n.prototype.setSelectable=function(i,s){if(this.indexOfItem(i)<0){return;}i._bSelectable=s;var o=this.getListItem(i);if(o){o.setVisible(s);}};n.prototype.onBeforeOpen=function(){this._updateSuggestionsPopoverValueState();if(!this._getItemsShownWithFilter()){this.toggleIconPressedStyle(true);}};n.prototype.onBeforeClose=function(){this.bOpenedByKeyboardOrButton=false;this._setItemsShownWithFilter(false);this._updateSuggestionsPopoverValueState();};n.prototype.getPicker=function(){var p=this.getAggregation("picker");if(p&&!p.bIsDestroyed&&!this.bIsDestroyed){return p;}return null;};n.prototype._getSuggestionsPopover=function(){return this._oSuggestionPopover;};n.prototype.getValueStateLinks=function(){var H=this.getPicker()&&this.getPicker().getCustomHeader()&&typeof this.getPicker().getCustomHeader().getFormattedText==="function",F=H&&this.getPicker().getCustomHeader().getFormattedText(),v=F&&F.getControls();return v||[];};n.prototype.getPickerTextField=function(){var p=this.getPicker(),s=p&&p.getSubHeader();return s&&s.getContent()[0]||null;};n.prototype.getPickerTitle=function(){var p=this.getPicker(),H=p&&p.getCustomHeader();if(this.isPickerDialog()&&H){return H.getContentMiddle()[0];}return null;};n.prototype.revertSelection=function(){};n.prototype.hasContent=function(){return this.getItems().length>0;};n.prototype.syncPickerContent=function(){};n.prototype.findFirstEnabledItem=function(o){o=o||this.getItems();for(var i=0;i<o.length;i++){if(o[i].getEnabled()){return o[i];}}return null;};n.prototype.findLastEnabledItem=function(i){i=i||this.getItems();return this.findFirstEnabledItem(i.reverse());};n.prototype.open=function(){var p=this.getPicker();if(p){p.open();}return this;};n.prototype.getVisibleItems=function(){for(var i=0,o,p=this.getItems(),v=[];i<p.length;i++){o=this.getListItem(p[i]);if(o&&o.getVisible()){v.push(p[i]);}}return v;};n.prototype.isItemSelected=function(){};n.prototype.getKeys=function(o){o=o||this.getItems();for(var i=0,p=[];i<o.length;i++){p[i]=o[i].getKey();}return p;};n.prototype.getSelectableItems=function(){return this.getEnabledItems(this.getVisibleItems());};n.prototype.findItem=function(p,v){var M="get"+p.charAt(0).toUpperCase()+p.slice(1);for(var i=0,o=this.getItems();i<o.length;i++){if(o[i][M]()===v){return o[i];}}return null;};n.prototype.getItemByText=function(t){return this.findItem("text",t);};n.prototype.clearFilter=function(){this.getItems().forEach(function(i){var o=this.getListItem(i);if(o){o.setVisible(i.getEnabled()&&this.getSelectable(i));}},this);};n.prototype.onItemChange=function(o){};n.prototype.clearSelection=function(){};n.prototype.setInternalBusyIndicator=function(B){this.bInitialBusyIndicatorState=this.getBusy();return this.setBusy.apply(this,arguments);};n.prototype.setInternalBusyIndicatorDelay=function(i){this.iInitialBusyIndicatorDelay=this.getBusyIndicatorDelay();return this.setBusyIndicatorDelay.apply(this,arguments);};n.prototype.addItem=function(i){this.addAggregation("items",i);if(i){i.attachEvent("_change",this.onItemChange,this);}if(this._getList()){this._getList().addItem(this._mapItemToListItem(i));}return this;};n.prototype.insertItem=function(i,o){this.insertAggregation("items",i,o,true);if(i){i.attachEvent("_change",this.onItemChange,this);}if(this._getList()){this._getList().insertItem(this._mapItemToListItem(i),o);}this._scheduleOnItemsLoadedOnce();return this;};n.prototype.getItemAt=function(i){return this.getItems()[+i]||null;};n.prototype.getFirstItem=function(){return this.getItems()[0]||null;};n.prototype.getLastItem=function(){var i=this.getItems();return i[i.length-1]||null;};n.prototype.getEnabledItems=function(i){i=i||this.getItems();return i.filter(function(o){return o.getEnabled();});};n.prototype.getItemByKey=function(s){return this.findItem("key",s);};n.prototype.addItemGroup=function(o,H,s){H=H||new a({text:o.text||o.key});this.addAggregation("items",H,s);if(this._getList()&&H.isA("sap.ui.core.SeparatorItem")){this._getList().addItem(this._mapItemToListItem(H));}return H;};n.prototype._mapSeparatorItemToGroupHeader=function(s){var o=new G({title:s.getText(),ariaLabelledBy:this._getGroupHeaderInvisibleText().getId(),type:k.Inactive});o.addStyleClass(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"NonInteractiveItem");return o;};n.prototype.isOpen=function(){var p=this.getPicker();return!!(p&&p.isOpen());};n.prototype.close=function(){var p=this.getPicker();if(p){p.close();}return this;};n.prototype.removeItem=function(i){i=this.removeAggregation("items",i);if(i){i.detachEvent("_change",this.onItemChange,this);}return i;};n.prototype.removeAllItems=function(){var o=this.removeAllAggregation("items");this.clearSelection();for(var i=0;i<o.length;i++){o[i].detachEvent("_change",this.onItemChange,this);}return o;};n.prototype.intersectItems=function(i,o){return i.filter(function(p){return o.map(function(O){return O.getId();}).indexOf(p.getId())!==-1;});};n.prototype.showItems=function(F){var i=this.fnFilter,o=function(){if(!this.getItems().length){return;}this.detachLoadItems(o);this.setFilterFunction(F||function(){return true;});this.applyShowItemsFilters();this._handlePopupOpenAndItemsLoad(false);this.setFilterFunction(i);}.bind(this);if(!this.getEnabled()||!this.getEditable()){return;}this._setItemsShownWithFilter(true);this.attachLoadItems(o);this.loadItems(o);};n.prototype.applyShowItemsFilters=function(){};return n;});
