/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./library','sap/ui/core/Control',"sap/ui/core/Core",'sap/ui/core/delegate/ItemNavigation','./IconTabBarDragAndDropUtil','sap/ui/core/library','./IconTabBarSelectListRenderer',"sap/ui/thirdparty/jquery"],function(l,C,a,I,b,c,d,q){"use strict";var D=c.dnd.DropPosition;var e=C.extend("sap.m.IconTabBarSelectList",{metadata:{library:"sap.m",aggregations:{items:{type:"sap.m.IconTab",multiple:true,singularName:"item",dnd:true}},events:{selectionChange:{parameters:{selectedItem:{type:"sap.m.IconTabFilter"}}}}}});e.prototype.init=function(){this._oItemNavigation=new I();this._oItemNavigation.setCycling(false);this.addEventDelegate(this._oItemNavigation);this._oItemNavigation.setPageSize(10);this._oIconTabHeader=null;this._oTabFilter=null;};e.prototype.exit=function(){this._oItemNavigation.destroy();this._oItemNavigation=null;this._oIconTabHeader=null;this._oTabFilter=null;};e.prototype.onBeforeRendering=function(){if(!this._oIconTabHeader){return;}this.destroyDragDropConfig();this._setsDragAndConfiguration();};e.prototype.onAfterRendering=function(){this._initItemNavigation();this.getItems().forEach(function(i){if(i._onAfterParentRendering){i._onAfterParentRendering();}});};e.prototype._setsDragAndConfiguration=function(){if(this._oIconTabHeader.getEnableTabReordering()&&!this.getDragDropConfig().length){b.setDragDropAggregations(this,"Vertical",this._oIconTabHeader._getDropPosition());}};e.prototype._initItemNavigation=function(){var f=this.getItems(),g=[],p=this._oIconTabHeader.oSelectedItem,s=-1,o,i;for(i=0;i<f.length;i++){o=f[i];if(o.isA("sap.m.IconTabFilter")){var h=o._getAllSubFiltersDomRefs();g=g.concat(o.getDomRef(),h);}if(p&&this.getSelectedItem()&&this.getSelectedItem()._getRealTab()===p){s=i;}}if(p&&g.indexOf(p.getDomRef())!==-1){s=g.indexOf(p.getDomRef());}this._oItemNavigation.setRootDomRef(this.getDomRef()).setItemDomRefs(g).setSelectedIndex(s);};e.prototype.getVisibleItems=function(){return this.getItems().filter(function(i){return i.getVisible();});};e.prototype.getVisibleTabFilters=function(){return this.getVisibleItems().filter(function(i){return i.isA("sap.m.IconTabFilter");});};e.prototype.setSelectedItem=function(i){this._selectedItem=i;};e.prototype.getSelectedItem=function(){return this._selectedItem;};e.prototype._getIconTabHeader=function(){return this._oIconTabHeader;};e.prototype.ontap=function(E){var t=E.srcControl;if(!t){return;}if(!t.isA("sap.m.IconTabFilter")){return;}if(this._oIconTabHeader._isUnselectable(t)){return;}E.preventDefault();if(t!=this.getSelectedItem()){this.fireSelectionChange({selectedItem:t});}};e.prototype.onsapenter=e.prototype.ontap;e.prototype.onsapspace=e.prototype.ontap;e.prototype.checkIconOnly=function(){this._bIconOnly=this.getVisibleTabFilters().every(function(i){return!i.getText()&&!i.getCount();});return this._bIconOnly;};e.prototype._handleDragAndDrop=function(E){var s=E.getParameter("dropPosition"),o=E.getParameter("draggedControl"),f=E.getParameter("droppedControl"),g=f._getRealTab().getParent(),h=this._oIconTabHeader.getMaxNestingLevel();if(this._oTabFilter._bIsOverflow){g=this._oIconTabHeader;}if(s===D.On){g=f._getRealTab();}b.handleDrop(g,s,o._getRealTab(),f._getRealTab(),true,h);this._oIconTabHeader._setItemsForStrip();this._oIconTabHeader._initItemNavigation();this._oTabFilter._setSelectListItems();this._initItemNavigation();f._getRealTab().getParent().$().trigger("focus");};e.prototype.ondragrearranging=function(E){if(!this._oIconTabHeader.getEnableTabReordering()){return;}var t=E.srcControl,k=E.keyCode,i=this.indexOfItem(t),o=this;b.moveItem.call(o,t,k,o.getItems().length-1);this._initItemNavigation();t.$().trigger("focus");if(i===this.indexOfItem(t)){return;}o=t._getRealTab().getParent();if(this._oTabFilter._bIsOverflow&&t._getRealTab()._getNestedLevel()===1){this._oIconTabHeader._moveTab(t._getRealTab(),k,this._oIconTabHeader.getItems().length-1);}else{b.moveItem.call(o,t._getRealTab(),k,o.getItems().length-1);}};e.prototype.onsaphomemodifiers=e.prototype.ondragrearranging;e.prototype.onsapendmodifiers=e.prototype.ondragrearranging;e.prototype.onsapincreasemodifiers=e.prototype.ondragrearranging;e.prototype.onsapdecreasemodifiers=e.prototype.ondragrearranging;return e;});
