/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./InputBase','./ComboBoxTextField','./ComboBoxBase','./Tokenizer','./Token','./List','./StandardListItem','./Popover','./GroupHeaderListItem','./library','sap/ui/core/EnabledPropagator','sap/ui/core/IconPool','sap/ui/core/library','sap/ui/Device','sap/ui/core/Item','sap/ui/core/SeparatorItem','sap/ui/core/ResizeHandler','./MultiComboBoxRenderer',"sap/ui/dom/containsOrEquals","sap/m/inputUtils/completeTextSelected","sap/m/inputUtils/inputsDefaultFilter","sap/ui/events/KeyCodes","sap/base/util/deepEqual","sap/base/assert","sap/base/Log","sap/ui/core/Core",'sap/ui/core/InvisibleText',"sap/ui/thirdparty/jquery","sap/ui/dom/jquery/cursorPos","sap/ui/dom/jquery/control"],function(I,C,a,T,b,L,S,P,G,l,E,c,d,D,e,f,R,M,g,h,j,K,k,m,n,o,p,q){"use strict";var r=l.ListType;var s=l.ListMode;var V=d.ValueState;var O=d.OpenState;var t=l.TokenizerRenderMode;var u=a.extend("sap.m.MultiComboBox",{metadata:{library:"sap.m",designtime:"sap/m/designtime/MultiComboBox.designtime",properties:{selectedKeys:{type:"string[]",group:"Data",defaultValue:[]},hasSelection:{type:"boolean",visibility:"hidden",defaultValue:false}},associations:{selectedItems:{type:"sap.ui.core.Item",multiple:true,singularName:"selectedItem"}},aggregations:{tokenizer:{type:"sap.m.Tokenizer",multiple:false,visibility:"hidden"}},events:{selectionChange:{parameters:{changedItem:{type:"sap.ui.core.Item"},selected:{type:"boolean"}}},selectionFinish:{parameters:{selectedItems:{type:"sap.ui.core.Item[]"}}}},dnd:{draggable:false,droppable:true}}});c.insertFontFaceStyle();E.apply(u.prototype,[true]);u.prototype.clone=function(i){var v=a.prototype.clone.apply(this,arguments),w=this._getList();if(w){v.syncPickerContent();}return v;};u.prototype.open=function(){if(!this.isOpen()){this._bPickerIsOpening=true;}this.syncPickerContent();return a.prototype.open.apply(this,arguments);};u.prototype.onsapend=function(i){if(i.isMarked("forwardFocusToParent")){this.focus();}};u.prototype.onsaphome=function(i){if(!this.getFocusDomRef().selectionStart){T.prototype.onsaphome.apply(this.getAggregation("tokenizer"),arguments);}i.setMarked();};u.prototype.onsapdown=function(i){if(!this.getEnabled()||!this.getEditable()){return;}i.setMarked();i.preventDefault();this.syncPickerContent();var v=this.getSelectableItems();var w=v[0];var x=this;if(w&&this.isOpen()&&this.getValueStateLinks().length){this._handleFormattedTextNav();return;}else if(w&&this.isOpen()){setTimeout(function(){x.getListItem(w).focus();},0);return;}if(this.isFocusInTokenizer()){return;}this._oTraversalItem=this._getNextTraversalItem();if(this._oTraversalItem&&!this.isComposingCharacter()){this.updateDomValue(this._oTraversalItem.getText());this.selectText(0,this.getValue().length);}};u.prototype.onsapup=function(i){if(!this.getEnabled()||!this.getEditable()){return;}i.setMarked();i.preventDefault();this.syncPickerContent();if(this.isFocusInTokenizer()){return;}this._oTraversalItem=this._getPreviousTraversalItem();if(this._oTraversalItem){this.updateDomValue(this._oTraversalItem.getText());this.selectText(0,this.getValue().length);}};u.prototype.isFocusInTokenizer=function(){return q.contains(this.getAggregation("tokenizer").getFocusDomRef(),document.activeElement);};u.prototype.onsapshow=function(i){this._handleItemToFocus();a.prototype.onsapshow.apply(this,arguments);};u.prototype._handlePopupOpenAndItemsLoad=function(){this._handleItemToFocus();a.prototype._handlePopupOpenAndItemsLoad.apply(this,arguments);};u.prototype._valueStateNavDelegate=function(v,F,i){var w=this;this.oValueStateNavDelegate={};this.oValueStateNavDelegate.onsapdown=function(){w.getListItem(w.getSelectableItems()[0]).focus();};this.oValueStateNavDelegate.onsapup=function(){w.getFocusDomRef().focus();};this.oValueStateNavDelegate.onsapend=function(x){x.preventDefault();var y=w.getSelectableItems();w.getListItem(w.getSelectableItems()[y.length-1]).focus();};this.oValueStateNavDelegate.onfocusout=function(x){v.removeStyleClass("sapMFocusable");if(!v.getDomRef().contains(x.relatedTarget)){i.forEach(function(y){y.getDomRef().setAttribute("tabindex","-1");});}if(D.browser.msie){F.removeStyleClass("sapMPseudoFocus");}};return this.oValueStateNavDelegate;};u.prototype._closePickerDelegate={onsaptabnext:function(){if(D.browser.msie){this.getPicker().getCustomHeader().getFormattedText().removeStyleClass("sapMPseudoFocus");}this.close();setTimeout(function(){this.closeValueStateMessage();}.bind(this),0);}};u.prototype._formattedTextLinksNav={onsapup:function(){this.focus();},onsapdown:function(){this.getSelectableItems()[0].focus();}};u.prototype._handleFormattedTextNav=function(){var i=this.getPicker().getCustomHeader(),v=this.getValueStateLinks(),F=i.getFormattedText(),w=this.oValueStateNavDelegate||this._valueStateNavDelegate(i,F,v),x=v?v[v.length-1]:null,y=v?v[0]:null;if(!v.length||i.getDomRef()===document.activeElement){return;}i.getDomRef().setAttribute("tabindex","-1");i.addDelegate(w);i.addStyleClass("sapMFocusable");i.focus();if(D.browser.msie){F.addStyleClass("sapMPseudoFocus");}v.forEach(function(z){z.getDomRef().setAttribute("tabindex","0");z.addDelegate(this._formattedTextLinksNav,this);},this);this.oMoveFocusBackToVSHeader=!this.oMoveFocusBackToVSHeader?{onsaptabprevious:function(z){z.preventDefault();i.focus();i.addStyleClass("sapMFocusable");}}:this.oMoveFocusBackToVSHeader;x.addDelegate(this._closePickerDelegate,this);y.addDelegate(this.oMoveFocusBackToVSHeader,this);};u.prototype.onsaphide=u.prototype.onsapshow;u.prototype._selectItemByKey=function(v){var w,x,y,i,z,A,B=this.isOpen();if(!this.getEnabled()||!this.getEditable()){return;}if(v){v.setMarked();}w=this._getUnselectedItems(B?"":this.getValue());for(i=0;i<w.length;i++){A=!(w[i].getKey()===undefined||w[i].getKey()===null)&&!w[i].isA("sap.ui.core.SeparatorItem");if(w[i].getText().toUpperCase()===this.getValue().toUpperCase()&&A){y=w[i];z=true;break;}}if(z){x={item:y,id:y.getId(),key:y.getKey(),fireChangeEvent:true,fireFinishEvent:true,suppressInvalidate:true,listItemUpdated:false};this._bPreventValueRemove=false;if(this.getValue()===""||(typeof this.getValue()==="string"&&y.getText().toLowerCase().startsWith(this.getValue().toLowerCase()))){if(this.getListItem(y).isSelected()){this.setValue('');}else{this.setSelection(x);}}}else{this._bPreventValueRemove=true;}if(v){this.close();}};u.prototype.onsapenter=function(i){var v=this.getAggregation("tokenizer");I.prototype.onsapenter.apply(this,arguments);this._showAlreadySelectedVisualEffect();if(this.getValue()){this._selectItemByKey(i);}if(!this.getEditable()&&v.getHiddenTokensCount()&&i.target===this.getFocusDomRef()){v._togglePopup(v.getTokensPopup());}};u.prototype.onsaptabnext=function(i){var v=this.getValue();if(v){var w=this._getUnselectedItemsStartingText(v);if(w.length===1){this._selectItemByKey(i);}else{this._showWrongValueVisualEffect();}}};u.prototype.onsaptabprevious=u.prototype.onsaptabnext;u.prototype.onsapfocusleave=function(i){var v=this.isPlatformTablet(),w=o.byId(i.relatedControlId),F=w&&w.getFocusDomRef(),x=this.getValue(),y=this.getPicker(),z=this.getAggregation("tokenizer");if(!this._bPickerIsOpening&&(!y||!y.getFocusDomRef()||!F||!q.contains(y.getFocusDomRef(),F))){this.setValue(null);if(x){this.fireChangeEvent("",{value:x});}if(!q.contains(this.getDomRef(),document.activeElement)){z.setRenderMode(t.Narrow);}}if(y&&F){if(k(y.getFocusDomRef(),F)&&!v&&!this.isPickerDialog()){this.focus();}}};u.prototype.onfocusin=function(i){var v=this.getPicker();var w=false;var x=v&&v.getFocusDomRef();var y=(v&&v.oPopup.getOpenState())||O.CLOSED;var z=y===O.CLOSING||y===O.CLOSED;var A=this.getPickerType()==="Dropdown";var B=this.getAggregation("tokenizer");if(A){w=x&&q.contains(x,i.relatedTarget);}if(this.getEditable()&&i.target===this.getDomRef("inner")){B.setRenderMode(t.Loose);}if(i.target===this.getFocusDomRef()){B.hasOneTruncatedToken()&&B.setFirstTokenTruncated(false);this.getEnabled()&&this.addStyleClass("sapMFocus");!z&&w&&this.handleInputValidation(i,false);}if(i.target===this.getOpenArea()&&A&&!this.isPlatformTablet()){this.focus();}if(!this.isOpen()&&this.shouldValueStateMessageBeOpened()){this.openValueStateMessage();}};u.prototype._handleItemTap=function(i){var v=q(i.target).control(0);if(!v.isA("sap.m.CheckBox")&&!v.isA("sap.m.GroupHeaderListItem")){this._bCheckBoxClicked=false;}};u.prototype._handleItemPress=function(i){if(this.isOpen()&&this._isListInSuggestMode()&&this.getPicker().oPopup.getOpenState()!==O.CLOSING){this.clearFilter();var v=this._getLastSelectedItem();if(v){this.getListItem(v).focus();}}};u.prototype._handleSelectionLiveChange=function(i){var v=i.getParameter("listItem");var w=i.getParameter("selected");var N=this._getItemByListItem(v);var x=this.isPickerDialog()?this.getPickerTextField():this;if(v.getType()==="Inactive"){return;}m(N,"The corresponding mapped item was not found on "+this);if(!N){return;}var y={item:N,id:N.getId(),key:N.getKey(),fireChangeEvent:true,suppressInvalidate:true,listItemUpdated:true};if(w){this.fireChangeEvent(N.getText());this.setSelection(y);}else{this.fireChangeEvent(N.getText());this.removeSelection(y);}if(this._bCheckBoxClicked){x.setValue(this._sOldInput);if(this.isOpen()&&this.getPicker().oPopup.getOpenState()!==O.CLOSING){v.focus();}}else{this._bCheckBoxClicked=true;this.setValue("");this.close();}};u.prototype.onkeydown=function(i){var v=this.getEditable(),w=this.getAggregation("tokenizer"),x=w.getTokens().length;a.prototype.onkeydown.apply(this,arguments);if(!this.getEnabled()){return;}if((i.ctrlKey||i.metaKey)&&i.which===K.I&&x){i.preventDefault();if(v){this._togglePopover();}else{this._handleIndicatorPress();}return;}this._bIsPasteEvent=(i.ctrlKey||i.metaKey)&&(i.which===K.V);if(this.getValue().length===0&&(i.ctrlKey||i.metaKey)&&(i.which===K.A)&&this._hasTokens()){w.focus();w.selectAllTokens(true);i.preventDefault();}if(this.isPickerDialog()){this._sOldValue=this.getPickerTextField().getValue();this._iOldCursorPos=q(this.getFocusDomRef()).cursorPos();}this._bDoTypeAhead=!D.os.android&&(i.which!==K.BACKSPACE)&&(i.which!==K.DELETE);};u.prototype.oninput=function(i){a.prototype.oninput.apply(this,arguments);var v=i.srcControl,w=this.isPickerDialog(),x=w?this.getPickerTextField():this,y=x.getValueState();if(y===V.Error&&this._bAlreadySelected){x.setValueState(this._sInitialValueState);x.setValueStateText(this._sInitialValueStateText);this._bAlreadySelected=false;}if(!this.getEnabled()||!this.getEditable()){return;}this.syncPickerContent();this.handleInputValidation(i,this.isComposingCharacter());if(this._bIsPasteEvent){v.updateDomValue(this._sOldValue||i.target.value||"");return;}if(this.isOpen()){setTimeout(this.highlightList.bind(this,this._sOldInput));}if(this._getItemsShownWithFilter()){this.toggleIconPressedStyle(true);}};u.prototype.filterItems=function(i){var F=this.fnFilter?this.fnFilter:j;var v=[];var w=false;var x=[];i.items.forEach(function(y){if(y.isA("sap.ui.core.SeparatorItem")){x.push({separator:y});this.getListItem(y).setVisible(false);w=true;return;}var z=!!F(i.value,y);if(i.value===""){z=true;if(!this.bOpenedByKeyboardOrButton&&!this.isPickerDialog()){return;}}if(w&&z){this.getListItem(x[x.length-1].separator).setVisible(true);}var A=this.getListItem(y);if(A){A.setVisible(z);z&&v.push(y);}},this);return v;};u.prototype.onkeyup=function(i){if(!this.getEnabled()||!this.getEditable()){return;}this._sOldValue=this.getValue();this._iOldCursorPos=q(this.getFocusDomRef()).cursorPos();};u.prototype._showWrongValueVisualEffect=function(){var i=this._getSuggestionsPopover();var v=this._sInitialValueStateText;var w=this._sInitialValueState;var x=v||this._oRbC.getText("VALUE_STATE_ERROR");var y=this;if(w===V.Error){return;}if(i){i.updateValueState(V.Error,x,true);setTimeout(i.updateValueState.bind(i,y.getValueState(),x,true),1000);}if(!this.isPickerDialog()){this.setValueState(V.Error);this.setValueStateText(this.getValueStateText()||x);setTimeout(this["setValueState"].bind(this,w||V.Error),1000);}this._syncInputWidth(this.getAggregation("tokenizer"));};u.prototype._showAlreadySelectedVisualEffect=function(){var A=this._oRbM.getText("VALUE_STATE_ERROR_ALREADY_SELECTED");if(!this.getValue()){return;}var i=!!this.getSelectedItems().filter(function(v){return v.getText().toLowerCase()===this.getValue().toLowerCase();},this).length;var N=this.getItems().filter(function(v){return v.getText().toLowerCase()===this.getValue().toLowerCase();},this).length;if(i){this._sInitialValueState=this.getValueState();this._sInitialValueStateText=this.getValueStateText();this.setValueStateText(A);this._bAlreadySelected=true;this.setValueState("Error");return;}else if(N){return;}else{this._showWrongValueVisualEffect();}};u.prototype._hasShowSelectedButton=function(){return true;};u.prototype.forwardEventHandlersToSuggPopover=function(i){a.prototype.forwardEventHandlersToSuggPopover.apply(this,arguments);i.setShowSelectedPressHandler(this._filterSelectedItems.bind(this));};u.prototype.configPicker=function(i){var v=this.getRenderer(),w=v.CSS_CLASS_MULTICOMBOBOX;i.setHorizontalScrolling(false).addStyleClass(v.CSS_CLASS_COMBOBOXBASE+"Picker").addStyleClass(w+"Picker").addStyleClass(w+"Picker-CTX").attachBeforeOpen(this.onBeforeOpen,this).attachAfterOpen(this.onAfterOpen,this).attachBeforeClose(this.onBeforeClose,this).attachAfterClose(this.onAfterClose,this).addEventDelegate({onBeforeRendering:this.onBeforeRenderingPicker,onAfterRendering:this.onAfterRenderingPicker},this);};u.prototype._configureList=function(i){if(!i){return;}i.setMode(s.MultiSelect);i.setIncludeItemInSelection(true);i.attachBrowserEvent("tap",this._handleItemTap,this).attachSelectionChange(this._handleSelectionLiveChange,this).attachItemPress(this._handleItemPress,this);i.addEventDelegate({onAfterRendering:this.onAfterRenderingList,onfocusin:this.onFocusinList},this);};u.prototype._modifyPopupInput=function(i){a.prototype._modifyPopupInput.apply(this,arguments);i.attachSubmit(function(v){var w=i.getValue();if(w){this.setValue(w);this._selectItemByKey();this.setValue(this._sOldInput);this.close();}}.bind(this));i.addEventDelegate({onfocusout:this._handleInputFocusOut},this);return i;};u.prototype.onBeforeRendering=function(){a.prototype.onBeforeRendering.apply(this,arguments);this._bInitialSelectedKeysSettersCompleted=true;this.getAggregation("tokenizer").setEnabled(this.getEnabled());if(this._getList()){this.syncPickerContent(true);}this._deregisterResizeHandler();this._synchronizeSelectedItemAndKey();this.setProperty("hasSelection",!!this.getSelectedItems().length,true);if(!this._bAlreadySelected){this._sInitialValueStateText=this.getValueStateText();}if(this.getValueState()!==V.Error){this._sInitialValueState=this.getValueState();}};u.prototype.syncPickerContent=function(F){var i,v,w=this.getPicker();if(!w){w=this.createPicker(this.getPickerType());this._updateSuggestionsPopoverValueState();F=true;}if(F){v=this._getList();i=this.getEditable()?this.getItems():this.getSelectedItems();this._synchronizeSelectedItemAndKey();v.destroyItems();this._clearTokenizer();this._fillList(i);if(v.getItemNavigation()){this._iFocusedIndex=v.getItemNavigation().getFocusedIndex();}}return w;};u.prototype._registerResizeHandler=function(){m(!this._iResizeHandlerId,"Resize handler already registered");this._iResizeHandlerId=R.register(this,this._onResize.bind(this));};u.prototype._deregisterResizeHandler=function(){if(this._iResizeHandlerId){R.deregister(this._iResizeHandlerId);this._iResizeHandlerId=null;}};u.prototype._onResize=function(){var i=this.getAggregation("tokenizer");i.setMaxWidth(this._calculateSpaceForTokenizer());this._syncInputWidth(i);this._handleNMoreAccessibility();};u.prototype.onBeforeRenderingPicker=function(){var i=this["_onBeforeRendering"+this.getPickerType()];if(i){i.call(this);}};u.prototype.onAfterRenderingPicker=function(){var i=this["_onAfterRendering"+this.getPickerType()];if(i){i.call(this);}};u.prototype.onBeforeOpen=function(){a.prototype.onBeforeOpen.apply(this,arguments);var i=this["_onBeforeOpen"+this.getPickerType()];this._resetCurrentItem();this.addContent();this._aInitiallySelectedItems=this.getSelectedItems();this._synchronizeSelectedItemAndKey();if(i){i.call(this);}};u.prototype.onAfterOpen=function(){var i=this.getFocusDomRef(),v=this.getValueStateLinks();i&&this.getFocusDomRef().setAttribute("aria-expanded","true");this._bPickerIsOpening=false;if(!this.isPlatformTablet()){this.getPicker().setInitialFocus(this);}v.forEach(function(w){w.addDelegate({onAfterRendering:function(){if(this.getFocusDomRef()){this.getFocusDomRef().setAttribute("tabindex","-1");}}},w);});this.closeValueStateMessage();};u.prototype.onBeforeClose=function(){a.prototype.onBeforeClose.apply(this,arguments);};u.prototype.onAfterClose=function(){var U=!q.contains(this.getDomRef(),document.activeElement)||this.isPickerDialog(),i=this.getFocusDomRef();i&&this.getFocusDomRef().setAttribute("aria-expanded","false");this.toggleIconPressedStyle(false);this.clearFilter();!this.isComposingCharacter()&&!this._bPreventValueRemove&&this.setValue("");this._sOldValue="";this._sOldInput="";this._getSuggestionsPopover()._sTypedInValue="";if(this.isPickerDialog()){this.getPickerTextField().setValue("");this.getFilterSelectedButton()&&this.getFilterSelectedButton().setPressed(false);}this.fireSelectionFinish({selectedItems:this.getSelectedItems()});this.getAggregation("tokenizer").setRenderMode(U?t.Narrow:t.Loose);if(this.getValueState()==V.Error&&document.activeElement===this.getFocusDomRef()){this.selectText(0,this.getValue().length);}};u.prototype._onBeforeOpenDialog=function(){};u.prototype._onBeforeOpenDropdown=function(){var i=this.getPicker(),v=this.getDomRef(),w;if(v&&i){w=(v.offsetWidth/parseFloat(l.BaseFontSize))+"rem";i.setContentMinWidth(w);}};u.prototype.getFilterSelectedButton=function(){return this._getSuggestionsPopover().getFilterSelectedButton();};u.prototype._filterSelectedItems=function(i,F){var v=i.oSource,w,x,y=this.getPickerTextField()?this.getPickerTextField().getValue():"",z=(v&&v.getPressed&&v.getPressed())||F,A=this.getVisibleItems(),B=this.getItems(),H=this.getSelectedItems(),J=null;if(z){A.forEach(function(N){x=H.indexOf(N)>-1?true:false;w=this.getListItem(N);if(!w){return;}if(w.isA("sap.m.GroupHeaderListItem")){w.setVisible(false);J=w;}else{w.setVisible(x);if(x&&J){J.setVisible(true);}}},this);}else{this.filterItems({value:y,items:B});}};u.prototype.revertSelection=function(){this.setSelectedItems(this._aInitiallySelectedItems);};u.prototype.setSelection=function(i){var v=this._getList();if(i.item&&this.isItemSelected(i.item)){return;}if(!i.item){return;}if(!i.listItemUpdated&&this.getListItem(i.item)&&v){v.setSelectedItem(this.getListItem(i.item),true);}var w=new b({key:i.key});w.setText(i.item.getText());i.item.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Token",w);this.getAggregation("tokenizer").addToken(w);this.$().toggleClass("sapMMultiComboBoxHasToken",this._hasTokens());this.setValue('');this.addAssociation("selectedItems",i.item,i.suppressInvalidate);var x=this.getSelectedKeys();var y=this.getKeys([i.item])[0];if(y===""||x.indexOf(y)===-1){x.push(y);this.setProperty("selectedKeys",x,i.suppressInvalidate);}if(i.fireChangeEvent){this.fireSelectionChange({changedItem:i.item,selected:true});}if(i.fireFinishEvent){if(!this.isOpen()){this.fireSelectionFinish({selectedItems:this.getSelectedItems()});}}};u.prototype.removeSelection=function(i){if(i.item&&!this.isItemSelected(i.item)){return;}if(!i.item){return;}this.removeAssociation("selectedItems",i.item,i.suppressInvalidate);var v=this.getSelectedKeys();var w=v.indexOf(i.item.getKey());v.splice(w,1);this.setProperty("selectedKeys",v,i.suppressInvalidate);if(!i.listItemUpdated&&this.getListItem(i.item)){var x=this.getListItem(i.item);this._getList().setSelectedItem(x,false);}if(!i.tokenUpdated){var y=this._getTokenByItem(i.item);i.item.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Token",null);this.getAggregation("tokenizer").removeToken(y);}this.$().toggleClass("sapMMultiComboBoxHasToken",this._hasTokens());if(i.fireChangeEvent){this.fireSelectionChange({changedItem:i.item,selected:false});}if(i.fireFinishEvent){if(!this.isOpen()){this.fireSelectionFinish({selectedItems:this.getSelectedItems()});}}};u.prototype._synchronizeSelectedItemAndKey=function(){var v=this.getSelectedKeys();var w=this.getKeys(this.getSelectedItems());if(!v.length){n.info("Info: _synchronizeSelectedItemAndKey() the MultiComboBox control does not contain any item on ",this);return;}for(var i=0,x=null,y=null,z=v.length;i<z;i++){x=v[i];if(w.indexOf(x)>-1){continue;}y=this.getItemByKey(""+x);if(y){this.setSelection({item:y,id:y.getId(),key:y.getKey(),fireChangeEvent:false,suppressInvalidate:true,listItemUpdated:false});}}};u.prototype._getTokenByItem=function(i){return i?i.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Token"):null;};u.prototype.updateItems=function(i){var v=function(z){return z&&z.getKey&&z.getKey();},w,x=this.getSelectedItems().map(v),y=this.getSelectedKeys();var U=a.prototype.updateItems.apply(this,arguments);x=this.getSelectedItems().map(v).filter(function(z){return x.indexOf(z)>-1;});w=y.concat(x);this.setSelectedKeys(w);return U;};u.prototype._getSelectedItemsOf=function(v){for(var i=0,w=v.length,x=[];i<w;i++){if(this.getListItem(v[i]).isSelected()){x.push(v[i]);}}return x;};u.prototype._getLastSelectedItem=function(){var i=this.getAggregation("tokenizer").getTokens();var v=i.length?i[i.length-1]:null;if(!v){return null;}return this._getItemByToken(v);};u.prototype._getFocusedListItem=function(){if(!document.activeElement){return null;}var F=o.byId(document.activeElement.id);if(this._getList()&&g(this._getList().getFocusDomRef(),F.getFocusDomRef())){return F;}return null;};u.prototype._getFocusedItem=function(){var i=this._getFocusedListItem();return this._getItemByListItem(i);};u.prototype._hasTokens=function(){return this.getAggregation("tokenizer").getTokens().length>0;};u.prototype._getCurrentItem=function(){if(!this._oCurrentItem){return this._getFocusedItem();}return this._oCurrentItem;};u.prototype._setCurrentItem=function(i){this._oCurrentItem=i;};u.prototype._resetCurrentItem=function(){this._oCurrentItem=null;};u.prototype._decorateListItem=function(i){i.addDelegate({onkeyup:function(v){var w=null;if(v.which==K.SPACE&&this.isOpen()&&this._isListInSuggestMode()){this.open();w=this._getLastSelectedItem();if(w){this.getListItem(w).focus();}return;}},onkeydown:function(v){var w=null,x=null;if(v.shiftKey&&v.which==K.ARROW_DOWN){x=this._getCurrentItem();w=this._getNextVisibleItemOf(x);}if(v.shiftKey&&v.which==K.ARROW_UP){x=this._getCurrentItem();w=this._getPreviousVisibleItemOf(x);}if(v.shiftKey&&v.which===K.SPACE){x=this._getCurrentItem();this._selectPreviousItemsOf(x);}if(w&&w!==x){if(this.getListItem(x).isSelected()){this.setSelection({item:w,id:w.getId(),key:w.getKey(),fireChangeEvent:true,suppressInvalidate:true});this._setCurrentItem(w);}else{this.removeSelection({item:w,id:w.getId(),key:w.getKey(),fireChangeEvent:true,suppressInvalidate:true});this._setCurrentItem(w);}return;}this._resetCurrentItem();if((v.ctrlKey||v.metaKey)&&v.which==K.A){v.setMarked();v.preventDefault();var y=this.getSelectableItems();var z=this._getSelectedItemsOf(y);if(z.length!==y.length){y.forEach(function(w){this.setSelection({item:w,id:w.getId(),key:w.getKey(),fireChangeEvent:true,suppressInvalidate:true,listItemUpdated:false});},this);}else{y.forEach(function(w){this.removeSelection({item:w,id:w.getId(),key:w.getKey(),fireChangeEvent:true,suppressInvalidate:true,listItemUpdated:false});},this);}}}},true,this);i.addEventDelegate({onsapbackspace:function(v){v.preventDefault();},onsapshow:function(v){v.setMarked();if(this.isOpen()){this.close();return;}if(this.hasContent()){this.open();}},onsaphide:function(v){this.onsapshow(v);},onsapenter:function(v){v.setMarked();this.close();},onsaphome:function(v){v.setMarked();v.preventDefault();if(this.getValueStateLinks().length){this._handleFormattedTextNav();v.stopPropagation(true);return;}var w=this.getSelectableItems();var x=w[0];this.getListItem(x).focus();},onsapend:function(v){v.setMarked();v.preventDefault();var w=this.getSelectableItems();var x=w[w.length-1];this.getListItem(x).focus();},onsapup:function(v){v.setMarked();v.preventDefault();var w=this.getSelectableItems();var x=w[0];var y=q(document.activeElement).control()[0];if(y===this.getListItem(x)&&this.getValueStateLinks().length){this._handleFormattedTextNav();v.stopPropagation(true);return;}else if(y===this.getListItem(x)){this.focus();v.stopPropagation(true);}},onfocusin:function(v){this.addStyleClass(this.getRenderer().CSS_CLASS_MULTICOMBOBOX+"Focused");},onfocusout:function(v){this.removeStyleClass(this.getRenderer().CSS_CLASS_MULTICOMBOBOX+"Focused");},onsapfocusleave:function(v){var w=this.getAggregation("picker");var x=o.byId(v.relatedControlId);if(w&&x&&k(w.getFocusDomRef(),x.getFocusDomRef())){if(v.srcControl){v.srcControl.focus();}}}},this);if(D.support.touch){i.addEventDelegate({ontouchstart:function(v){v.setMark("cancelAutoClose");}});}};u.prototype._handleInputFocusOut=function(){var i=this.isPickerDialog()?this.getPickerTextField():this,U=this._sOldInput||this._sOldValue||"";i.updateDomValue(U);this._bIsPasteEvent=null;};u.prototype.onItemChange=function(i){var v=a.prototype.onItemChange.apply(this,arguments);this._forwardItemInfoToToken(i);return v;};u.prototype._forwardItemInfoToToken=function(i){var v=i.getSource(),w=i.getParameters(),x=this._getTokenByItem(v);if(!x){return;}if(w.name==="enabled"){x.setVisible(w.newValue);}else if(x.getMetadata().hasProperty(w.name)){x.setProperty(w.name,w.newValue,false);}};u.prototype._handleIndicatorPress=function(){var i,v=this.getAggregation("tokenizer");if(this.getEditable()){this.syncPickerContent();this._filterSelectedItems({},true);this.focus();i=this.getPicker();i.open();}else{v._togglePopup(v.getTokensPopup());}if(this.isPickerDialog()){this.getFilterSelectedButton().setPressed(true);this.bOpenedByKeyboardOrButton=true;}};u.prototype._togglePopover=function(){var i=this.getPicker();if(!i){i=this.syncPickerContent(true);}if(i.isOpen()){i.close();}else{i.open();}};u.prototype._createTokenizer=function(){var i=new T({renderMode:t.Narrow}).attachTokenDelete(this._handleTokenDelete,this);i.getTokensPopup().attachAfterOpen(function(){if(i.hasOneTruncatedToken()){i.setFirstTokenTruncated(false);}}).attachAfterClose(function(){var v=i.getTokens();if(v.length===1&&!v[0].getTruncated()){i.setFirstTokenTruncated(true);}});i.addEventDelegate({onAfterRendering:this._onAfterRenderingTokenizer},this);return i;};u.prototype._onAfterRenderingTokenizer=function(){var i=this.getAggregation("tokenizer");if(this.getEditable()){i.addStyleClass("sapMTokenizerIndicatorDisabled");}else{i.removeStyleClass("sapMTokenizerIndicatorDisabled");}setTimeout(this._syncInputWidth.bind(this,i),0);setTimeout(this._handleNMoreAccessibility.bind(this),0);setTimeout(i["scrollToEnd"].bind(i),0);};u.prototype._handleTokenDelete=function(i){var v=i.getParameter("tokens");var w=this.getSelectedItems();this._removeSelection(v);if(w.length!==this.getSelectableItems()){!this.isPickerDialog()&&!this.isFocusInTokenizer()&&this.focus();this.fireChangeEvent("");this.setProperty("hasSelection",!!this.getSelectedItems().length);}};u.prototype._removeSelection=function(i){var v=this.getAggregation("tokenizer");i.forEach(function(w){var x=(w&&this._getItemByToken(w));if(x&&this.isItemSelected(x)){this.removeSelection({item:x,id:x.getId(),key:x.getKey(),tokenUpdated:true,fireChangeEvent:true,fireFinishEvent:true,suppressInvalidate:true});w.destroy();if(this.getSelectedItems().length>0){var i=v.getTokens();i[i.length-1].focus();}else{this.focus();}}},this);};u.prototype.onAfterRenderingList=function(){var i=this._getList();var v=document.activeElement===this.getFocusDomRef();if(this.getEditable()&&!v&&i&&i.getItems()[this._iFocusedIndex]){i.getItems()[this._iFocusedIndex].focus();this._iFocusedIndex=null;}};u.prototype.onFocusinList=function(){if(this._bListItemNavigationInvalidated&&this._getList().getItemNavigation()){this._getList().getItemNavigation().setSelectedIndex(this._iInitialItemFocus);this._bListItemNavigationInvalidated=false;}};u.prototype.onAfterRendering=function(){var i=this.getAggregation("tokenizer");a.prototype.onAfterRendering.apply(this,arguments);this._registerResizeHandler();setTimeout(function(){i.setMaxWidth(this._calculateSpaceForTokenizer());}.bind(this),0);};u.prototype.onfocusout=function(i){this.isOpen()&&this._handleInputFocusOut();this.removeStyleClass("sapMFocus");if(this.getValueState()===V.Error&&this.getValueStateText()===this._oRbM.getText("VALUE_STATE_ERROR_ALREADY_SELECTED")){this.setValueState(this._sInitialValueState);this.setValueStateText(this._sInitialValueStateText);}a.prototype.onfocusout.apply(this,arguments);};u.prototype.onpaste=function(i){var v;if(window.clipboardData){v=window.clipboardData.getData("Text");}else{v=i.originalEvent.clipboardData.getData('text/plain');}var w=v.split(/\r\n|\r|\n/g);if(w&&w.length>0){this.getSelectableItems().forEach(function(x){if(w.indexOf(x.getText())>-1){this.setSelection({item:x,id:x.getId(),key:x.getKey(),fireChangeEvent:true,fireFinishEvent:true,suppressInvalidate:true,listItemUpdated:false});}},this);}};u.prototype.onsapbackspace=function(i){var v=this.getAggregation("tokenizer");var w=v.getTokens();var x=w.filter(function(y){return y.getSelected();});if(!this.getEnabled()||!this.getEditable()){i.preventDefault();return;}if(this.getCursorPosition()>0||this.getValue().length>0){return;}if(x.length>0){this._removeAllTokens();return;}if(document.activeElement===this.getFocusDomRef()){w[w.length-1]&&w[w.length-1].focus();}i.preventDefault();};u.prototype._removeAllTokens=function(){var i=this.getAggregation("tokenizer");var v=i.getTokens().filter(function(w){return w.getSelected();});if(!v.length){return;}this._removeSelection(v);this.fireChangeEvent("");this.invalidate();};u.prototype.onsapdelete=u.prototype.onsapbackspace;u.prototype.onsapnext=function(i){var v=this.getAggregation("tokenizer");if(i.isMarked()){return;}var F=q(document.activeElement).control()[0];if(!F){return;}if(F===v||v.$().find(F.$()).length>0&&this.getEditable()){this.focus();}};u.prototype.onsapprevious=function(i){if(this.getCursorPosition()===0&&!h(this.getFocusDomRef())){if(i.srcControl===this){T.prototype.onsapprevious.apply(this.getAggregation("tokenizer"),arguments);}}};u.prototype.onclick=function(i){var v=this.getEditable(),w=this.getEnabled(),N=i.target.className.indexOf("sapMTokenizerIndicator")>-1,x=this.getAggregation("tokenizer"),y=i.target.className.indexOf("sapMToken")>-1&&this.getAggregation("tokenizer").hasOneTruncatedToken();if(v&&w&&(N||y)){i.preventDefault();this._handleIndicatorPress();x.setFirstTokenTruncated(false);}};u.prototype.ontap=function(i){a.prototype.ontap.apply(this,arguments);var v=this.getOpenArea();if(!this.getEnabled()||!this.getEditable()){return;}i.setMarked();if(this.isPickerDialog()&&v.contains(i.target)){this.open();}};u.prototype.getOpenArea=function(){if(this.isPickerDialog()){return this.getDomRef();}else{return a.prototype.getOpenArea.apply(this,arguments);}};u.prototype._getItemsStartingWithPerTerm=function(i,v){var w=[],x=v?this.getEnabledItems():this.getSelectableItems(),F=this.fnFilter?this.fnFilter:j;x.forEach(function(y){if(F(i,y)){w.push(y);}},this);return w;};u.prototype._getItemsStartingWith=function(i,v){var w=[],x=v?this.getEnabledItems():this.getSelectableItems();x.forEach(function(y){if(typeof i==="string"&&i!==""&&y.getText().toLowerCase().startsWith(i.toLowerCase())){w.push(y);}},this);return w;};u.prototype._getUnselectedItemsStartingText=function(i){var v=[];this._getUnselectedItems().forEach(function(w){if(typeof i==="string"&&i!==""&&w.getText().toLowerCase().startsWith(i.toLowerCase())){v.push(w);}},this);return v;};u.prototype.getCursorPosition=function(){return this._$input.cursorPos();};u.prototype._selectPreviousItemsOf=function(i){var v;do{v=true;var w=this._getPreviousVisibleItemOf(i);if(w){var x=this.getListItem(w);if(x){v=this.getListItem(w).getSelected();}}this.setSelection({item:i,id:i.getId(),key:i.getKey(),fireChangeEvent:true,suppressInvalidate:true});i=w;}while(!v);};u.prototype._getNextVisibleItemOf=function(i){var v=this.getSelectableItems();var w=v.indexOf(i)+1;if(w<=0||w>v.length-1){return null;}return v[w];};u.prototype._getPreviousVisibleItemOf=function(i){var v=this.getSelectableItems();var w=v.indexOf(i)-1;if(w<0){return null;}return v[w];};u.prototype._getNextUnselectedItemOf=function(i){var v=this._getUnselectedItems();var w=v.indexOf(i)+1;if(w<=0||w>v.length-1){return null;}return v[w];};u.prototype._getPreviousUnselectedItemOf=function(i){var v=this._getUnselectedItems();var w=v.indexOf(i)-1;if(w<0){return null;}return v[w];};u.prototype._getNextTraversalItem=function(){var v=this.getValue();var i=v?this._getItemsStartingWithPerTerm(v):[];var w=this._getUnselectedItems();if(i.indexOf(this._oTraversalItem)>-1&&this._oTraversalItem.getText()===this.getValue()){return this._getNextUnselectedItemOf(this._oTraversalItem);}if(i.length&&i[0].getText()===this.getValue()){return this._getNextUnselectedItemOf(i[0]);}return i.length?i[0]:w[0];};u.prototype._getPreviousTraversalItem=function(){var v=this.getValue();var i=v?this._getItemsStartingWithPerTerm(v):[];if(i.indexOf(this._oTraversalItem)>-1&&this._oTraversalItem.getText()===this.getValue()){return this._getPreviousUnselectedItemOf(this._oTraversalItem);}if(i.length&&i[i.length-1].getText()===this.getValue()){return this._getPreviousUnselectedItemOf(i[i.length-1]);}if(i.length){return i[i.length-1];}else{var w=this._getUnselectedItems();if(w.length>0){return w[w.length-1];}else{return null;}}};u.prototype.setSelectedItems=function(i){this.removeAllSelectedItems();if(!i||!i.length){return this;}if(!Array.isArray(i)){n.warning("Warning: setSelectedItems() has to be an array of sap.ui.core.Item instances or of valid sap.ui.core.Item IDs",this);return this;}i.forEach(function(v){if(!(v instanceof e)&&(typeof v!=="string")){n.warning("Warning: setSelectedItems() has to be an array of sap.ui.core.Item instances or of valid sap.ui.core.Item IDs",this);return;}if(typeof v==="string"){v=o.byId(v);}this.setSelection({item:v?v:null,id:v?v.getId():"",key:v?v.getKey():"",suppressInvalidate:true});},this);return this;};u.prototype.addSelectedItem=function(i){if(!i){return this;}if(typeof i==="string"){i=o.byId(i);}this.setSelection({item:i?i:null,id:i?i.getId():"",key:i?i.getKey():"",fireChangeEvent:false,suppressInvalidate:true});return this;};u.prototype.removeSelectedItem=function(i){if(!i){return null;}if(typeof i==="string"){i=o.byId(i);}if(!this.isItemSelected(i)){return null;}this.removeSelection({item:i,id:i.getId(),key:i.getKey(),fireChangeEvent:false,suppressInvalidate:true});return i;};u.prototype.removeAllSelectedItems=function(){var i=[];var v=this.getAssociation("selectedItems",[]);v.forEach(function(w){var x=this.removeSelectedItem(w);if(x){i.push(x.getId());}},this);return i;};u.prototype.removeSelectedKeys=function(i){var v,w=[];if(!i||!i.length||!Array.isArray(i)){return w;}i.forEach(function(x){v=this.getItemByKey(x);if(v){this.removeSelection({item:v?v:null,id:v?v.getId():"",key:v?v.getKey():"",fireChangeEvent:false,suppressInvalidate:true});w.push(v);}},this);return w;};u.prototype.setSelectedKeys=function(i){if(this._bInitialSelectedKeysSettersCompleted){this.setProperty("selectedKeys",[],true);this.removeAllSelectedItems();}this.addSelectedKeys(i);this._bInitialSelectedKeysSettersCompleted=true;return this;};u.prototype.addSelectedKeys=function(i){var v,w=[];i=this.validateProperty("selectedKeys",i);i.forEach(function(x){var y=this.getItemByKey(x);if(y){this.addSelectedItem(y);}else if(x!=null){w.push(x);}},this);if(w.length>0){v=this.getProperty("selectedKeys").filter(function(x){return w.indexOf(x)===-1;});w=v.concat(w);this.setProperty("selectedKeys",w,true);}return this;};u.prototype._getUnselectedItems=function(){var i=q(this.getSelectableItems()).not(this.getSelectedItems()).get();if(!this.isOpen()){return i.filter(function(v){return!v.isA("sap.ui.core.SeparatorItem");});}return i;};u.prototype.getSelectedItems=function(){var i=[],v=this.getAssociation("selectedItems")||[];v.forEach(function(w){var x=o.byId(w);if(x){i.push(x);}},this);return i;};u.prototype.getWidth=function(){return this.getProperty("width")||"100%";};u.prototype.setEditable=function(i){var v=this._getList(),w=this.getAggregation("tokenizer");a.prototype.setEditable.apply(this,arguments);w.setEditable(i);if(v){this.syncPickerContent(true);this._updatePopoverBasedOnEditMode(i);}return this;};u.prototype._updatePopoverBasedOnEditMode=function(i){var v=this._getList(),w=this._getSuggestionsPopover();if(!v){return;}if(i){w.addContent(v);}};u.prototype._mapItemToListItem=function(i){var v,w,x,A;var y=this.getRenderer();if(!i){return null;}A=(i.getAdditionalText&&this.getShowSecondaryValues())?i.getAdditionalText():"";if(i.isA("sap.ui.core.SeparatorItem")){v=this._mapSeparatorItemToGroupHeader(i,y);i.data(y.CSS_CLASS_COMBOBOXBASE+"ListItem",v);this._decorateListItem(v);return v;}w=y.CSS_CLASS_MULTICOMBOBOX+"Item";x=(this.isItemSelected(i))?w+"Selected":"";v=new S({type:r.Active,visible:i.getEnabled()}).addStyleClass(w+" "+x);v.setTooltip(i.getTooltip());i.data(y.CSS_CLASS_COMBOBOXBASE+"ListItem",v);v.setTitle(i.getText());v.setInfo(A);if(x){var z=new b({key:i.getKey()});z.setText(i.getText());i.data(y.CSS_CLASS_COMBOBOXBASE+"Token",z);this.getAggregation("tokenizer").addToken(z,true);}this.setSelectable(i,i.getEnabled());this._decorateListItem(v);return v;};u.prototype.setSelectable=function(i,v){a.prototype.setSelectable.call(this,i,v);var w=this._getTokenByItem(i);if(w){w.setVisible(v);}};u.prototype._fillList=function(v){if(!v){return null;}if(!this._oListItemEnterEventDelegate){this._oListItemEnterEventDelegate={onsapenter:function(y){if(y.srcControl.isSelected()){y.setMarked();}}};}for(var i=0,w,x=v.length;i<x;i++){w=this._mapItemToListItem(v[i]);w.removeEventDelegate(this._oListItemEnterEventDelegate);w.addDelegate(this._oListItemEnterEventDelegate,true,this,true);this._getList().addAggregation("items",w,true);if(this.isItemSelected(v[i])){this._getList().setSelectedItem(w,true);}}};u.prototype.handleInputValidation=function(i,v){var w=i.target.value,x=this._sOldInput&&this._sOldInput.length>w.length,y=this.isValueValid(w),z,A,B;var F=i.srcControl;if(!y&&w!==""&&!v){this._handleFieldValidationState(F);return;}B=this._getItemsStartingWith(w,true);if(!v||this._bIsPasteEvent){this._handleTypeAhead(w,B,F);}z=this.getEnabledItems();if(this.isPickerDialog()){A=this.getFilterSelectedButton();if(A!=null&&A.getPressed()){A.setPressed(false);}}if(x){z=this.getItems();}this.filterItems({value:w,items:z});this._sOldInput=w;if((!this.getValue()||!y)&&!this.bOpenedByKeyboardOrButton&&!this.isPickerDialog()){this.close();}else{this.open();}};u.prototype.isValueValid=function(v){var i=this._getItemsStartingWith(v,true);var w=this._getItemsStartingWithPerTerm(v,true);return i.length||w.length;};u.prototype._handleTypeAhead=function(v,i,w){var x=this.getSelectedItems();var y=i.filter(function(z){if(z.isA("sap.ui.core.SeparatorItem")){return false;}return x.indexOf(z)===-1;});if(this._bDoTypeAhead&&y.length){w.updateDomValue(y[0].getText());if(document.activeElement===w.getFocusDomRef()){w.selectText(v.length,w.getValue().length);}}};u.prototype._handleFieldValidationState=function(i){if(this._sOldInput&&this.isValueValid(this._sOldInput)){i.updateDomValue(this._sOldInput);}else if(this._sOldValue&&this.isValueValid(this._sOldValue)){i.updateDomValue(this._sOldValue);}else{i.updateDomValue("");}if(this._iOldCursorPos){q(i.getFocusDomRef()).cursorPos(this._iOldCursorPos);}this._showWrongValueVisualEffect();};u.prototype.init=function(){this._oRb=o.getLibraryResourceBundle("sap.m");a.prototype.init.apply(this,arguments);this._bInitialSelectedKeysSettersCompleted=false;this._bListItemNavigationInvalidated=false;this._iInitialItemFocus=-1;this._bCheckBoxClicked=true;this._bPreventValueRemove=false;this._oTokenizer=this._createTokenizer();this.setAggregation("tokenizer",this._oTokenizer);this._aInitiallySelectedItems=[];this._oRbM=o.getLibraryResourceBundle("sap.m");this._oRbC=o.getLibraryResourceBundle("sap.ui.core");this._fillList();};u.prototype.clearSelection=function(){this.removeAllSelectedItems();};u.prototype.insertItem=function(i,v){this.insertAggregation("items",i,v,true);if(i){i.attachEvent("_change",this.onItemChange,this);}if(this._getList()){this._getList().insertItem(this._mapItemToListItem(i),v);}return this;};u.prototype.removeItem=function(i){i=this.removeAggregation("items",i);if(this._getList()){this._getList().removeItem(i&&this.getListItem(i));}this.removeSelection({item:i,id:i?i.getId():"",key:i?i.getKey():"",fireChangeEvent:false,suppressInvalidate:true,listItemUpdated:true});return i;};u.prototype.isItemSelected=function(i){return this.getSelectedItems().indexOf(i)>-1;};u.prototype._clearTokenizer=function(){this.getAggregation("tokenizer").destroyTokens();};u.prototype.exit=function(){var i=["_oSuggestionPopover","_oToggleButton","_oPickerCustomHeader","_oCustomHeaderToolbar","_oPickerCloseButton"],v=this;a.prototype.exit.apply(this,arguments);this._deregisterResizeHandler();i.forEach(function(w){if(v[w]){v[w].destroy();v[w]=null;}});this._sInitialValueState=null;};u.prototype.destroyItems=function(){this.destroyAggregation("items");this.setProperty("selectedKeys",[],true);if(this._getList()){this._getList().destroyItems();}this.getAggregation("tokenizer").destroyTokens();return this;};u.prototype.removeAllItems=function(){var i=this.removeAllAggregation("items");this.removeAllSelectedItems();if(this._getList()){this._getList().removeAllItems();}return i;};u.prototype._getItemByToken=function(i){return this._getItemBy(i,"Token");};u.prototype._getItemByValue=function(v){return this.getSelectableItems().find(function(i){return i.getText().toLowerCase()===v.toLowerCase();});};u.prototype._handleItemToFocus=function(){if(this.isOpen()){return;}this.syncPickerContent();var i,v,w=o.byId(document.activeElement.id),x=this.getSelectedItems(),y=this.getSelectableItems(),z=this._getList(),A=z&&z.getItemNavigation(),B=this.getValue(),F=this.getPicker();if(w&&w.isA("sap.m.Token")){v=this._getItemByToken(w);}else if(B){v=this._getItemByValue(B);}if(!v){v=x.length?this._getItemByListItem(this._getList().getSelectedItems()[0]):y[0];}i=y.indexOf(v);if(A){A.setSelectedIndex(i);}else{this._bListItemNavigationInvalidated=true;this._iInitialItemFocus=i;}F.setInitialFocus(z);};u.prototype.getAccessibilityInfo=function(){var i=this.getSelectedItems().map(function(w){return w.getText();}).join(" ");var v=a.prototype.getAccessibilityInfo.apply(this,arguments);v.type=o.getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_MULTICOMBO");v.description=((v.description||"")+" "+i).trim();return v;};u.prototype._calculateSpaceForTokenizer=function(){if(this.getDomRef()){var i,v=this.getDomRef().offsetWidth,w=this._calculateIconsSpace(),x=this.$().find(".sapMInputBaseInner"),y=["min-width","padding-right","padding-left"],z=y.reduce(function(A,B){return A+(parseInt(x.css(B))||0);},0);i=v-(w+z);i=i<0?0:i;return i+"px";}else{return null;}};u.prototype._syncInputWidth=function(i){var F=this.getDomRef('inner'),v,w;if(!F||(i&&!i.getDomRef())){return;}w=parseFloat(i.getDomRef().getBoundingClientRect().width.toFixed(2));v=this._calculateIconsSpace();F.style.width='calc(100% - '+parseFloat(v+w)+"px)";};u.prototype._handleNMoreAccessibility=function(){var i=p.getStaticId("sap.m","MULTICOMBOBOX_OPEN_NMORE_POPOVER"),v=this.getAggregation("tokenizer"),F=this.getFocusDomRef(),A=(F&&F.getAttribute("aria-labelledby")),w=A?A.split(" "):[],N=w.indexOf(i),x=this.getEnabled(),y=!this.getEditable()&&v&&v.getHiddenTokensCount();if(y&&N===-1){w.push(i);x&&this.getFocusDomRef().setAttribute("aria-keyshortcuts","Enter");}else if(N!==-1&&!y){w.splice(N,1);this.getFocusDomRef().removeAttribute("aria-keyshortcuts");}if(F&&w.length){F.setAttribute("aria-labelledby",w.join(" ").trim());}};u.prototype.applyShowItemsFilters=function(){this.syncPickerContent();this.filterItems({value:this.getValue()||"_",items:this.getItems()});};u.prototype.showItems=function(F){var H=true,i=this.fnFilter;if(typeof F==="function"){this.syncPickerContent();this.setFilterFunction(F||function(){return true;});H=this.filterItems({value:this.getValue()||"_",items:this.getItems()}).length>0;this.setFilterFunction(i);}if(H){a.prototype.showItems.apply(this,arguments);}};return u;});
