/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./Input','./Tokenizer','./Token','./library','sap/ui/core/EnabledPropagator','sap/ui/base/ManagedObjectMetadata','sap/ui/base/ManagedObjectObserver','sap/ui/Device','./Popover','./List','./Title','./Bar','./Toolbar','./StandardListItem','sap/ui/core/ResizeHandler','sap/ui/core/IconPool','./MultiInputRenderer',"sap/ui/dom/containsOrEquals","sap/m/inputUtils/completeTextSelected","sap/ui/events/KeyCodes",'sap/ui/core/InvisibleText',"sap/ui/thirdparty/jquery","sap/ui/dom/jquery/cursorPos","sap/ui/dom/jquery/control"],function(I,T,a,l,E,M,b,D,P,L,c,B,d,S,R,f,g,h,j,K,k,q){"use strict";var m=l.TokenizerRenderMode;var n=I.extend("sap.m.MultiInput",{metadata:{library:"sap.m",designtime:"sap/m/designtime/MultiInput.designtime",properties:{enableMultiLineMode:{type:"boolean",group:"Behavior",defaultValue:false},maxTokens:{type:"int",group:"Behavior"}},aggregations:{tokens:{type:"sap.m.Token",multiple:true,singularName:"token"},tokenizer:{type:"sap.m.Tokenizer",multiple:false,visibility:"hidden"}},events:{tokenChange:{parameters:{type:{type:"string"},token:{type:"sap.m.Token"},tokens:{type:"sap.m.Token[]"},addedTokens:{type:"sap.m.Token[]"},removedTokens:{type:"sap.m.Token[]"}}},tokenUpdate:{allowPreventDefault:true,parameters:{type:{type:"string"},addedTokens:{type:"sap.m.Token[]"},removedTokens:{type:"sap.m.Token[]"}}}},dnd:{draggable:false,droppable:true}}});E.apply(n.prototype,[true]);var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");n.prototype.init=function(){var t=this;this._bShowListWithTokens=false;I.prototype.init.call(this);this._bIsValidating=false;var o=new T({renderMode:m.Narrow,tokenDelete:this._tokenDelete.bind(this)});o.updateTokens=function(){this.destroyTokens();this.updateAggregation("tokens");};this.setAggregation("tokenizer",o);o.getTokensPopup().setInitialFocus(this).attachBeforeOpen(this._onBeforeOpenTokensPicker.bind(this)).attachAfterClose(this._onAfterCloseTokensPicker.bind(this));this.setAggregation("tokenizer",o);this._oTokenizerObserver=new b(function(C){var s=C.mutation;var e=C.child;switch(s){case"insert":this.fireTokenChange({type:sap.m.Tokenizer.TokenChangeType.Added,token:e,tokens:[e],removedTokens:[]});break;case"remove":var i=C.object.getTokens().length?sap.m.Tokenizer.TokenChangeType.Removed:sap.m.Tokenizer.TokenChangeType.RemovedAll;this.fireTokenChange({type:i,token:e,removedTokens:[e]});break;default:break;}this.invalidate();}.bind(this));this._oTokenizerObserver.observe(o,{aggregations:["tokens"]});this._bShowListWithTokens=false;this._bIsValidating=false;o.addEventDelegate({onThemeChanged:this._handleInnerVisibility.bind(this),onAfterRendering:function(){if(this.isMobileDevice()&&this.getEditable()){o.addStyleClass("sapMTokenizerIndicatorDisabled");}else{o.removeStyleClass("sapMTokenizerIndicatorDisabled");}this._syncInputWidth(o);this._handleInnerVisibility();this._handleNMoreAccessibility();this._registerTokenizerResizeHandler();}.bind(this)},this);this._aTokenValidators=[];this.setShowValueHelp(true);this.setShowSuggestion(true);this._getSuggestionsPopoverInstance()._oPopover.attachBeforeOpen(function(){if(t.isMobileDevice()!==true){return;}var e=o._getTokensList();o._fillTokensList(e);this.addContent(e);t._manageListsVisibility(!!o.getTokens().length);});this.attachSuggestionItemSelected(this._onSuggestionItemSelected,this);this.attachLiveChange(this._onLiveChange,this);this.attachValueHelpRequest(this._onValueHelpRequested,this);this._getValueHelpIcon().setProperty("visible",true,true);this._onResize=this._onResize.bind(this);};n.prototype.exit=function(){this._deregisterResizeHandler();this._deregisterTokenizerResizeHandler();this._oTokenizerObserver.disconnect();this._oTokenizerObserver.destroy();this._oTokenizerObserver=null;I.prototype.exit.call(this);};n.prototype.onAfterRendering=function(){var t=this.getAggregation("tokenizer");this._bTokenIsValidated=false;t.setMaxWidth(this._calculateSpaceForTokenizer());t.scrollToEnd();this._registerResizeHandler();I.prototype.onAfterRendering.apply(this,arguments);};n.prototype._tokenDelete=function(e){this._deleteTokens(e.getParameter("tokens"),e.getParameters());};n.prototype._deleteTokens=function(e,o){var t=this.getAggregation("tokenizer");var i=0;var p=o.keyCode===K.BACKSPACE;var s=e[e.length-1];var F=e[0];i=this.getTokens().indexOf(p?F:s);t.focusToken(i,o,function(){this.focus();}.bind(this));this.fireTokenUpdate({type:T.TokenUpdateType.Removed,addedTokens:[],removedTokens:e});e.forEach(function(u){u.destroy();},this);};n.prototype._handleInnerVisibility=function(){var H=!!this.getAggregation("tokenizer").getHiddenTokensCount();this._setValueVisible(!H);};n.prototype.oninput=function(e){this.setProperty("selectedKey",'',true);I.prototype.oninput.call(this,e);if(e.isMarked("invalid")||!this.getEditable()){return;}this._setValueVisible(true);this._manageListsVisibility(false);this.getAggregation("tokenizer").getTokensPopup().close();};n.prototype._registerResizeHandler=function(){if(!this._iResizeHandlerId){this._iResizeHandlerId=R.register(this,this._onResize);}};n.prototype._deregisterResizeHandler=function(){if(this._iResizeHandlerId){R.deregister(this._iResizeHandlerId);this._iResizeHandlerId=null;}};n.prototype._registerTokenizerResizeHandler=function(){if(!this._iTokenizerResizeHandler){this._iTokenizerResizeHandler=R.register(this.getAggregation("tokenizer"),this._onResize);}};n.prototype._deregisterTokenizerResizeHandler=function(){if(this._iTokenizerResizeHandler){R.deregister(this._iTokenizerResizeHandler);this._iTokenizerResizeHandler=null;}};n.prototype._onResize=function(){this.getAggregation("tokenizer").setMaxWidth(this._calculateSpaceForTokenizer());};n.prototype._onSuggestionItemSelected=function(e){var t=this.getAggregation("tokenizer"),i=null,o=null,O=t.getTokens().length;if(this.getMaxTokens()&&O>=this.getMaxTokens()||this._bValueHelpOpen){return;}if(this._hasTabularSuggestions()){i=e.getParameter("selectedRow");}else{i=e.getParameter("selectedItem");if(i){o=new a({text:i.getText(),key:i.getKey()});}}if(i&&!this._bTokenIsAdded){var p=this.getValue();this.addValidateToken({text:p,token:o,suggestionObject:i,validationCallback:this._validationCallback.bind(this,O)});}if(this.isMobileDevice()){var N=t.getTokens().length;if(O<N){this.setValue("");}if(this._getSuggestionsList()instanceof sap.m.Table){this._getSuggestionsList().addStyleClass("sapMInputSuggestionTableHidden");}else{this._getSuggestionsList().destroyItems();}var s=this.getAggregation("tokenizer").getScrollDelegate();if(s){s.scrollTo(0,0,0);}this._getSuggestionsPopoverInstance()._oPopupInput.focus();}this._bTokenIsAdded=false;};n.prototype._onValueHelpRequested=function(){this._bValueHelpOpen=true;};n.prototype._onLiveChange=function(e){var C=this.getAggregation("tokenizer").getTokens().every(function(t){return t.getSelected();});if(!C){return;}this.removeAllTokens();};n.prototype._setValueVisible=function(v){var V=v?"1":"0";this.$("inner").css("opacity",V);};n.prototype.onmousedown=function(e){if(e.target==this.getDomRef('content')){e.preventDefault();e.stopPropagation();}};n.prototype.openMultiLine=function(){};n.prototype.closeMultiLine=function(){};n.prototype.showItems=function(){I.prototype.showItems.apply(this,arguments);this._manageListsVisibility(false);};n.prototype.onBeforeRendering=function(){var t=this.getAggregation("tokenizer");var o=t._getTokensList();I.prototype.onBeforeRendering.apply(this,arguments);this._hideTokensOverLimit();t.setEnabled(this.getEnabled());t._fillTokensList(o);};n.prototype._hideTokensOverLimit=function(){if(!this.getMaxTokens()){return;}this.getTokens().forEach(function(t,i){if(i>=this.getMaxTokens()){return t.setVisible(false);}return t.setVisible(true);},this);};n.prototype.onsapnext=function(e){var t=this.getAggregation("tokenizer");if(e.isMarked()){return;}var F=q(document.activeElement).control()[0];if(!F){return;}if(t===F||t.$().find(F.$()).length>0){t.scrollToEnd();this.$().find("input").trigger("focus");}};n.prototype.onsapbackspace=function(e){var v=this.getValue();var i=this.getFocusDomRef()===document.activeElement;var t=this.getTokens();var o=t[t.length-1];if(v===""&&i&&o&&e.srcControl===this){var A=t.filter(function(p){return p.getSelected();}).length===t.length;if(A){return this._deleteTokens(t,{keyCode:K.BACKSPACE});}o.focus();e.preventDefault();}};n.prototype.onsapdelete=function(e){if(!this.getEditable()){return;}if(this.getValue()&&!j(this.getFocusDomRef())){return;}if(e.isMarked("forwardFocusToParent")){this.focus();}};n.prototype.onkeydown=function(e){var t=this.getAggregation("tokenizer");if(!this.getEnabled()){return;}if(e.which===K.TAB){t.selectAllTokens(false);}if((e.ctrlKey||e.metaKey)&&e.which===K.A&&t.getTokens().length>0){t.focus();t.selectAllTokens(true);e.preventDefault();}if((e.ctrlKey||e.metaKey)&&(e.which===K.C||e.which===K.INSERT)){t._copy();}if(((e.ctrlKey||e.metaKey)&&e.which===K.X)||(e.shiftKey&&e.which===K.DELETE)){if(this.getEditable()){t._cut();}else{t._copy();}}if((e.ctrlKey||e.metaKey)&&e.which===K.I&&t.getTokens().length){t._togglePopup(t.getTokensPopup());e.preventDefault();}};n.prototype.onpaste=function(e){var o,i,s,A=[];if(this.getValueHelpOnly()){return;}if(window.clipboardData){o=window.clipboardData.getData("Text");}else{o=e.originalEvent.clipboardData.getData('text/plain');}s=o.split(/\r\n|\r|\n/g);if(s.length<=1){return;}setTimeout(function(){if(s){if(this.fireEvent("_validateOnPaste",{texts:s},true)){var p="";for(i=0;i<s.length;i++){if(s[i]){var t=this._convertTextToToken(s[i],true);if(this._addUniqueToken(t)){A.push(t);}else{p=s[i];}}}this.updateDomValue(p);if(A.length>0){this.fireTokenUpdate({addedTokens:A,removedTokens:[],type:T.TokenUpdateType.Added});this.fireTokenChange({addedTokens:A,removedTokens:[],type:T.TokenChangeType.TokensChanged});}}if(A.length){this.cancelPendingSuggest();}}}.bind(this),0);};n.prototype._validationCallback=function(o,v){var N=this.getAggregation("tokenizer").getTokens().length;var s=this._getSuggestionsPopoverInstance();this._bIsValidating=false;if(v){this.setValue("");this._bTokenIsValidated=true;if(this.isMobileDevice()&&s&&s._oPopupInput&&(o<N)){s._oPopupInput.setValue("");}}};n.prototype.onsapprevious=function(e){if(this._getIsSuggestionPopupOpen()){return;}if(this._$input.cursorPos()===0){if(e.srcControl===this){T.prototype.onsapprevious.apply(this.getAggregation("tokenizer"),arguments);}}if(e.keyCode===K.ARROW_UP){e.preventDefault();}};n.prototype.onsaphome=function(e){if(!this.getFocusDomRef().selectionStart){T.prototype.onsaphome.apply(this.getAggregation("tokenizer"),arguments);}};n.prototype.onsapend=function(e){if(e.isMarked("forwardFocusToParent")){this.focus();}};n.prototype.onsapenter=function(e){if(I.prototype.onsapenter){I.prototype.onsapenter.apply(this,arguments);}var v=true,t=this.getAggregation("tokenizer");if(this._getIsSuggestionPopupOpen()){if(this._hasTabularSuggestions()){v=!this._oSuggestionTable.getSelectedItem();}else{v=!this._getSuggestionsList().getSelectedItem();}}if(v){this._validateCurrentText();}if(e&&e.setMarked&&this._bTokenIsValidated){e.setMarked();}if(!this.getEditable()&&t.getHiddenTokensCount()&&e.target===this.getFocusDomRef()){t._togglePopup(t.getTokensPopup());}this.focus();};n.prototype.onsapfocusleave=function(e){var p=this._getSuggestionsPopoverPopup(),t=this.getAggregation("tokenizer"),s=t.getTokensPopup(),N=false,i=false,o=this.getDomRef()&&h(this.getDomRef(),document.activeElement),u,F;if(p&&p.isA("sap.m.Popover")){if(e.relatedControlId){u=sap.ui.getCore().byId(e.relatedControlId).getFocusDomRef();N=h(p.getFocusDomRef(),u);i=h(t.getFocusDomRef(),u);if(s){F=h(s.getFocusDomRef(),u);}}}I.prototype.onsapfocusleave.apply(this,arguments);if(this._bIsValidating||this._bValueHelpOpen){return;}if(!this.isMobileDevice()&&!N&&e.relatedControlId!==this.getId()&&!i){this._validateCurrentText(true);}if(!this.isMobileDevice()&&this.getEditable()){if(o||N){return;}}if(!F&&!i){s.isOpen()&&!this.isMobileDevice()&&t._togglePopup(s);t.setRenderMode(m.Narrow);}this._handleInnerVisibility();};n.prototype.ontap=function(e){var t=this.getAggregation("tokenizer");if(document.activeElement===this._$input[0]||document.activeElement===t.getDomRef()){t.selectAllTokens(false);}if(e&&e.isMarked("tokenDeletePress")){return;}I.prototype.ontap.apply(this,arguments);};n.prototype.onfocusin=function(e){var t=this.getAggregation("tokenizer");this._deregisterTokenizerResizeHandler();this._bValueHelpOpen=false;if(e.target===this.getFocusDomRef()){I.prototype.onfocusin.apply(this,arguments);if(t.hasOneTruncatedToken()){t.getTokens()[0].setSelected(false);!this.isMobileDevice()&&t.setFirstTokenTruncated(false);}}if(!this.isMobileDevice()&&this.getEditable()&&e.target===this.getDomRef("inner")&&!(this._getIsSuggestionPopupOpen())){t.setRenderMode(m.Loose);this._setValueVisible(true);}this._registerResizeHandler();};n.prototype.onsapescape=function(e){var t=this.getAggregation("tokenizer"),p=t.getTokensPopup();this.getAggregation("tokenizer").selectAllTokens(false);this.selectText(0,0);if(p.isOpen()){t._togglePopup(p);}I.prototype.onsapescape.apply(this,arguments);};n.prototype._getIsSuggestionPopupOpen=function(){var s=this._getSuggestionsPopoverInstance(),o=this._getSuggestionsPopoverPopup();return s&&o&&o.isOpen();};n.prototype.setEditable=function(e){var t=this.getAggregation("tokenizer");e=this.validateProperty("editable",e);if(e===this.getEditable()){return this;}if(I.prototype.setEditable){I.prototype.setEditable.apply(this,arguments);}t.setEditable(e);return this;};n.prototype._findItem=function(t,e,o,G){if(!t){return;}if(!(e&&e.length)){return;}t=t.toLowerCase();var p=e.length;for(var i=0;i<p;i++){var s=e[i];var u=G(s);if(!u){continue;}u=u.toLowerCase();if(u===t){return s;}if(!o&&u.indexOf(t)===0){return s;}}};n.prototype._getSuggestionItem=function(t,e){var o=null;var p=null;if(this._hasTabularSuggestions()){o=this.getSuggestionRows();p=this._findItem(t,o,e,function(s){var u=s.getCells();var v=null;if(u){var i;for(i=0;i<u.length;i++){if(u[i].getText){v=u[i].getText();break;}}}return v;});}else{o=this.getSuggestionItems();p=this._findItem(t,o,e,function(p){return p.getText();});}return p;};n.prototype.clone=function(){var C;this.detachSuggestionItemSelected(this._onSuggestionItemSelected,this);this.detachLiveChange(this._onLiveChange,this);this.detachValueHelpRequest(this._onValueHelpRequested,this);C=I.prototype.clone.apply(this,arguments);this.attachSuggestionItemSelected(this._onSuggestionItemSelected,this);this.attachLiveChange(this._onLiveChange,this);this.attachValueHelpRequest(this._onValueHelpRequested,this);return C;};n.getMetadata().forwardAggregation("tokens",{getter:function(){return this.getAggregation("tokenizer");},aggregation:"tokens",forwardBinding:true});n.prototype.getPopupAnchorDomRef=function(){return this.getDomRef("content");};n.prototype.setTokens=function(t){if(!Array.isArray(t)){return;}this.removeAllTokens();t.forEach(function(o){M.addAPIParentInfoBegin(o,this,"tokens");},this);t.forEach(function(o){this.addToken(o);},this);t.forEach(function(o){M.addAPIParentInfoEnd(o);},this);this.fireTokenChange({type:sap.m.Tokenizer.TokenChangeType.TokensChanged,addedTokens:t,removedTokens:[]});return this;};n.TokenChangeType={Added:"added",Removed:"removed",RemovedAll:"removedAll",TokensChanged:"tokensChanged"};n.WaitForAsyncValidation="sap.m.MultiInput.WaitForAsyncValidation";n.prototype.getDomRefForValueStateMessage=n.prototype.getPopupAnchorDomRef;n.prototype.updateInputField=function(N){I.prototype.updateInputField.call(this,N);var s=this._getSuggestionsPopoverInstance();this.setDOMValue('');if(s._oPopupInput){s._oPopupInput.setDOMValue('');}};n.prototype.onChange=function(e,p,N){p=p||this.getChangeEventParams();if(!this.getEditable()||!this.getEnabled()){return;}var v=this._getInputValue(N);if(v===this.getLastValue()){this._bCheckDomValue=false;return;}if(!this._bTokenIsValidated){this.setValue(v);v=this.getValue();this.setLastValue(v);}this.fireChangeEvent(v,p);return true;};n.prototype.getAccessibilityInfo=function(){var t=this.getTokens().map(function(o){return o.getText();}).join(" ");var i=I.prototype.getAccessibilityInfo.apply(this,arguments);i.type=r.getText("ACC_CTR_TYPE_MULTIINPUT");i.description=((i.description||"")+" "+t).trim();return i;};n.prototype._modifyPopupInput=function(p){var t=this;p.addEventDelegate({oninput:t._manageListsVisibility.bind(t,false),onsapenter:function(e){if(p.getValue()){t._closeSuggestionPopup();}t._validateCurrentText();t._setValueVisible(false);t.onChange(e,null,p.getValue());}});return p;};n.prototype._hasShowSelectedButton=function(){return true;};n.prototype.forwardEventHandlersToSuggPopover=function(s){I.prototype.forwardEventHandlersToSuggPopover.apply(this,arguments);s.setShowSelectedPressHandler(this._handleShowSelectedPress.bind(this));};n.prototype._handleShowSelectedPress=function(e){this._bShowListWithTokens=e.getSource().getPressed();this._manageListsVisibility(this._bShowListWithTokens);};n.prototype._onBeforeOpenTokensPicker=function(){var t=this.getAggregation("tokenizer"),p=t.getTokensPopup(),o=this.getDomRef(),e=this.getEditable(),C,i;this._setValueVisible(false);this._manageListsVisibility(true);if(o&&p){C=parseInt(p.getContentWidth());i=o.offsetWidth>C?o.offsetWidth:C;i=((t.getTokens().length===1)||!e)?"auto":(i/parseFloat(l.BaseFontSize))+"rem";p.setContentWidth(i);}};n.prototype._onAfterCloseTokensPicker=function(){if(document.activeElement!==this.getDomRef("inner")){this.getAggregation("tokenizer").setRenderMode(m.Narrow);}};n.prototype.getDialogTitle=function(){var p=this._getSuggestionsPopoverPopup(),H=p&&p.getCustomHeader();if(H){return H.getContentMiddle()[0];}return null;};n.prototype._updatePickerHeaderTitle=function(){var o,e;e=this.getLabels();if(e.length){o=e[0];if(o&&(typeof o.getText==="function")){this.getDialogTitle().setText(o.getText());}}else{this.getDialogTitle().setText(r.getText("COMBOBOX_PICKER_TITLE"));}};n.prototype._getSuggestionsList=function(){var s=this._getSuggestionsPopoverInstance();return s&&s._oList;};n.prototype._getSuggestionsPopoverInstance=function(){return this._oSuggPopover;};n.prototype._getSuggestionsPopoverPopup=function(){return this._oSuggestionPopup;};n.prototype._manageListsVisibility=function(s){if(!this.isMobileDevice()){return;}this.getAggregation("tokenizer")._getTokensList().setVisible(s);this._getSuggestionsList()&&this._getSuggestionsList().setVisible(!s);this._getSuggestionsPopover().getFilterSelectedButton().setPressed(s);};n.prototype._handleNMoreAccessibility=function(){var i=k.getStaticId("sap.m","MULTICOMBOBOX_OPEN_NMORE_POPOVER"),F=this.getFocusDomRef(),A=(F&&F.getAttribute("aria-labelledby")),e=A?A.split(" "):[],N=e.indexOf(i),o=this.getEnabled(),p=!this.getEditable()&&this.getAggregation("tokenizer").getHiddenTokensCount();if(p&&N===-1){e.push(i);o&&this.getFocusDomRef().setAttribute("aria-keyshortcuts","Enter");}else if(N!==-1&&!p){e.splice(N,1);this.getFocusDomRef().removeAttribute("aria-keyshortcuts");}if(F&&e.length){F.setAttribute("aria-labelledby",e.join(" ").trim());}};n.prototype._calculateSpaceForTokenizer=function(){var o=this.getDomRef();if(o){var s,e=this.$().find(".sapMInputDescriptionWrapper"),i=this.$().find(".sapMInputBaseInner"),C=o.offsetWidth||0,p=e.width()||0,t=this._calculateIconsSpace(),u=["min-width","padding-right","padding-left"],v=u.reduce(function(A,w){return A+(parseInt(i.css(w))||0);},0);s=C-(t+v+p);s=s<0?0:s;return s+"px";}else{return null;}};n.prototype._syncInputWidth=function(t){var F=this.getDomRef('inner'),s,i;if(!F||(t&&!t.getDomRef())){return;}s=this._calculateIconsSpace();i=Math.ceil(t.getDomRef().getBoundingClientRect().width);F.style.width='calc(100% - '+Math.floor(s+i)+"px";};n.prototype.isValueHelpOnlyOpener=function(t){return[this._$input[0],this._getValueHelpIcon().getDomRef()].indexOf(t)>-1;};n.prototype._shouldTriggerSuggest=function(){var s=I.prototype._shouldTriggerSuggest.apply(this,arguments);return s&&!this._bShowListWithTokens;};n.prototype.addValidator=function(v){if(typeof(v)==="function"){this._aTokenValidators.push(v);}};n.prototype.removeValidator=function(v){var i=this._aTokenValidators.indexOf(v);if(i!==-1){this._aTokenValidators.splice(i,1);}};n.prototype.removeAllValidators=function(){this._aTokenValidators=[];};n.prototype.getValidators=function(){return this._aTokenValidators;};n.prototype.addValidateToken=function(p,v){var t=this._validateToken(p,v),A=this._addUniqueToken(t,p.validationCallback);if(A){this.fireTokenUpdate({addedTokens:[t],removedTokens:[],type:T.TokenUpdateType.Added});this.fireTokenChange({addedTokens:[t],removedTokens:[],type:T.TokenChangeType.TokensChanged});}};n.prototype._validateToken=function(p,v){var t=p.token,V=p.validationCallback,s=p.suggestionObject,e=t&&t.getText(),o=e?e:p.text,u;v=v?v:this._aTokenValidators;u=v.length;if(!u){if(!t&&V){V(false);}return t;}for(var i=0;i<u;i++){t=v[i]({text:o,suggestedToken:t,suggestionObject:s,asyncCallback:this._getAsyncValidationCallback(v,i,o,s,V)});if(!t){if(V){V(false);}return null;}if(t===n.WaitForAsyncValidation){return null;}}return t;};n.prototype._addUniqueToken=function(t,v){if(!t){return false;}var e=!this._tokenExists(t);e&&this.addToken(t);if(v){v(e);}return e;};n.prototype._tokenExists=function(t){var o=this.getTokens(),e=o.length,s=t&&t.getKey();if(!s){return false;}for(var i=0;i<e;i++){if(o[i].getKey()===s){return true;}}return false;};n.prototype._convertTextToToken=function(t,C){var o=this.getAggregation("tokenizer"),O=o.getTokens().length,e=this._configureTokenOptions(t,false,C),v=e.text,i=e.item,p=e.token;if(!v){return null;}return this._validateToken({text:v,token:p,suggestionObject:i,validationCallback:this._validationCallback.bind(this,O)});};n.prototype._validateCurrentText=function(e){var t=this.getAggregation("tokenizer"),o=t.getTokens().length,O=this._configureTokenOptions(this.getValue(),e),v=O.text,i=O.item,p=O.token;if(!v){return null;}if(i){this._bTokenIsAdded=true;}if(!this.getMaxTokens()||this.getTokens().length<this.getMaxTokens()){this._bIsValidating=true;this.addValidateToken({text:v,token:p,suggestionObject:i,validationCallback:this._validationCallback.bind(this,o)});}};n.prototype._configureTokenOptions=function(v,e,p){var i,t;if(v&&this.getEditable()){v=v.trim();}if(v&&(e||p||this._getIsSuggestionPopupOpen())){if(this._hasTabularSuggestions()){i=this._oSuggestionTable.getSelectedItem();}else{i=this._getSuggestionItem(v,e);}}if(i&&i.getText&&i.getKey){t=new a({text:i.getText(),key:i.getKey()});}return{text:v,item:i,token:t};};n.prototype._getAsyncValidationCallback=function(v,V,i,s,e){var t=this;return function(o){if(o){o=t.addValidateToken({text:i,token:o,suggestionObject:s,validationCallback:e},v.slice(V+1));}else{e&&e(false);}};};return n;});
