/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.getCore().loadLibrary("sap.ui.unified");sap.ui.define(['sap/m/delegate/DateNavigation','sap/ui/core/Control','sap/ui/base/ManagedObjectObserver','sap/ui/unified/library','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/calendar/DatesRow','sap/ui/unified/calendar/OneMonthDatesRow','sap/ui/unified/calendar/MonthsRow','sap/ui/unified/calendar/TimesRow','sap/ui/unified/DateRange','sap/ui/unified/DateTypeRange','sap/ui/unified/CalendarAppointment','sap/ui/unified/CalendarRow','sap/ui/unified/CalendarRowRenderer','sap/ui/Device','sap/ui/core/Core','sap/ui/core/Element','sap/ui/core/Renderer','sap/ui/core/ResizeHandler','sap/ui/core/InvisibleText','sap/ui/core/Item','sap/ui/core/dnd/DragInfo','sap/ui/core/dnd/DropInfo','sap/ui/core/dnd/DragDropInfo','sap/ui/core/format/DateFormat','sap/m/Select','sap/m/Button','sap/m/OverflowToolbar','sap/m/Toolbar','sap/m/Table','sap/m/Column','sap/m/ColumnListItem','sap/m/ColumnListItemRenderer','sap/m/SegmentedButtonItem','sap/m/StandardListItem','sap/m/StandardListItemRenderer','sap/m/PlanningCalendarHeader','sap/m/PlanningCalendarRow','sap/m/PlanningCalendarRenderer','sap/m/PlanningCalendarView','sap/m/CheckBox','sap/m/library',"sap/base/util/deepEqual","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/control"],function(D,C,M,u,a,b,c,O,d,T,e,f,g,h,k,l,m,E,R,n,I,o,p,q,r,s,S,B,t,v,w,x,y,z,A,F,G,P,H,J,K,L,N,Q,U,V){"use strict";var W=N.Sticky;var X=u.CalendarDayType;var Y=N.ListMode;var Z=N.ToolbarDesign;var $=N.PlanningCalendarBuiltInView;var _=N.ScreenSize;var a1=u.CalendarAppointmentVisualization;var b1=u.GroupAppointmentsMode;var c1=u.CalendarIntervalType;var d1=u.CalendarAppointmentHeight;var e1=u.CalendarAppointmentRoundWidth;var f1="DragDropConfig";var g1="ResizeConfig";var h1="CreateConfig";var i1="-CLI";var j1=C.extend("sap.m.PlanningCalendar",{metadata:{library:"sap.m",properties:{startDate:{type:"object",group:"Data"},viewKey:{type:"string",group:"Appearance",defaultValue:c1.Hour},singleSelection:{type:"boolean",group:"Misc",defaultValue:true},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},showIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},showEmptyIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},showRowHeaders:{type:"boolean",group:"Appearance",defaultValue:true},noDataText:{type:"string",group:"Misc",defaultValue:null},groupAppointmentsMode:{type:"sap.ui.unified.GroupAppointmentsMode",group:"Appearance",defaultValue:b1.Collapsed},appointmentsReducedHeight:{type:"boolean",group:"Appearance",defaultValue:false},appointmentHeight:{type:"sap.ui.unified.CalendarAppointmentHeight",group:"Appearance",defaultValue:d1.Regular},appointmentRoundWidth:{type:"sap.ui.unified.CalendarAppointmentRoundWidth",group:"Appearance",defaultValue:e1.None},appointmentsVisualization:{type:"sap.ui.unified.CalendarAppointmentVisualization",group:"Appearance",defaultValue:a1.Standard},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null},showDayNamesLine:{type:"boolean",group:"Appearance",defaultValue:false},showWeekNumbers:{type:"boolean",group:"Appearance",defaultValue:false},builtInViews:{type:"string[]",group:"Appearance",defaultValue:[]},stickyHeader:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{rows:{type:"sap.m.PlanningCalendarRow",multiple:true,singularName:"row"},views:{type:"sap.m.PlanningCalendarView",multiple:true,singularName:"view"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},toolbarContent:{type:"sap.ui.core.Control",multiple:true,singularName:"toolbarContent",forwarding:{getter:"_getHeader",aggregation:"actions"},forwardBinding:true},table:{type:"sap.m.Table",multiple:false,visibility:"hidden"},header:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{appointmentSelect:{parameters:{appointment:{type:"sap.ui.unified.CalendarAppointment"},appointments:{type:"sap.ui.unified.CalendarAppointment[]"},multiSelect:{type:"boolean"},domRefId:{type:"string"}}},intervalSelect:{parameters:{startDate:{type:"object"},endDate:{type:"object"},subInterval:{type:"boolean"},row:{type:"sap.m.PlanningCalendarRow"}}},rowSelectionChange:{parameters:{rows:{type:"sap.m.PlanningCalendarRow[]"}}},startDateChange:{},viewChange:{},rowHeaderClick:{parameters:{headerId:{type:"string"},row:{type:"sap.m.PlanningCalendarRow"}}}},designtime:"sap/m/designtime/PlanningCalendar.designtime"},constructor:function(i,j){C.prototype.constructor.apply(this,arguments);if(typeof i!=="string"){j=i;}if(j&&typeof j.customAppointmentsSorterCallback==="function"){this._fnCustomSortedAppointments=j.customAppointmentsSorterCallback;}}});var k1=["_oTimesRow","_oDatesRow","_oMonthsRow","_oWeeksRow","_oOneMonthsRow"],l1={};l1[c1.Day]={sInstanceName:"_oDatesRow",sIdSuffix:"-DatesRow",oClass:c};l1[c1.Week]={sInstanceName:"_oWeeksRow",sIdSuffix:"-WeeksRow",oClass:c};l1[c1.OneMonth]={sInstanceName:"_oOneMonthsRow",sIdSuffix:"-OneMonthsRow",oClass:O};var m1=_.Desktop;var n1=[$.Hour,$.Day,$.Month,$.Week,$.OneMonth];var o1={PHONE:"600",TABLET:"1024"};var p1=["sap.ui.unified.calendar.TimesRow","sap.ui.unified.calendar.DatesRow","sap.ui.unified.calendar.MonthsRow","sap.ui.unified.calendar.OneMonthDatesRow"];var q1=C.extend("sap.m._PlanningCalendarInternalHeader",{metadata:{aggregations:{"toolbar":{type:"sap.m.Toolbar",multiple:false},"allCheckBox":{type:"sap.m.CheckBox",multiple:false}}},renderer:{apiVersion:2,render:function(i,j){i.openStart("div",j);i.class("sapMPlanCalHead");i.openEnd();var Q1=j.getToolbar();if(Q1){i.renderControl(Q1);}var R1=j.getAllCheckBox();if(R1){i.renderControl(R1);}i.close("div");}}});j1.prototype.init=function(){this._dateNav=new D();this._iBreakPointTablet=l.media._predefinedRangeSets[l.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0];this._iBreakPointDesktop=l.media._predefinedRangeSets[l.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1];this._iBreakPointLargeDesktop=l.media._predefinedRangeSets[l.media.RANGESETS.SAP_STANDARD_EXTENDED].points[2];if(l.system.phone||V('html').hasClass("sapUiMedia-Std-Phone")){this._iSize=0;this._iSizeScreen=0;}else if((l.system.tablet||V('html').hasClass("sapUiMedia-Std-Tablet"))&&!(l.system.desktop||V('html').hasClass("sapUiMedia-Std-Desktop"))){this._iSize=1;this._iSizeScreen=1;}else{this._iSize=2;this._iSizeScreen=2;}this.addStyleClass("sapMSize"+this._iSize);this.setAggregation("header",this._createHeader());this._attachHeaderEvents();this._oRB=m.getLibraryResourceBundle("sap.m");var i=this.getId();this._oIntervalTypeSelect=this._getHeader()._getOrCreateViewSwitch();this._oIntervalTypeSelect.attachEvent("selectionChange",r1,this);this._oTodayButton=this._getHeader()._getTodayButton();this._oCalendarHeader=new q1(i+"-CalHead",{});this._oInfoToolbar=new v(i+"-InfoToolbar",{height:"auto",design:Z.Transparent,content:[this._oCalendarHeader,this._oTimesRow],ariaLabelledBy:I.getStaticId("sap.m","PC_INTERVAL_TOOLBAR")});var j=new w(i+"-Table",{sticky:[],infoToolbar:this._oInfoToolbar,mode:Y.SingleSelectMaster,columns:[new x({styleClass:"sapMPlanCalRowHead"}),new x({width:"80%",styleClass:"sapMPlanCalAppRow",minScreenWidth:m1,demandPopin:true})],ariaLabelledBy:i+"-Descr"});j.attachEvent("selectionChange",H1,this);j.addDelegate({onBeforeRendering:function(){if(this._rowHeaderClickEvent){this._rowHeaderClickEvent.off();}},onAfterRendering:function(){this._rowHeaderClickEvent=j.$().find(".sapMPlanCalRowHead > div.sapMLIB").on("click",function(Q1){var R1=V(Q1.currentTarget).control(0),S1=D1(R1.getParent()),T1=R1.getId();this.fireRowHeaderClick({headerId:T1,row:S1});}.bind(this));this._adjustColumnHeadersTopOffset();}},false,this);this.setAggregation("table",j,true);this.setStartDate(new Date());this._resizeProxy=V.proxy(v1,this);this._fnCustomSortedAppointments=undefined;this.iWidth=0;};j1.prototype.exit=function(){if(this._sResizeListener){n.deregister(this._sResizeListener);this._sResizeListener=undefined;}l.orientation.detachHandler(this._updateStickyHeader,this);if(this._sUpdateCurrentTime){clearTimeout(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}var i=this.getAggregation("table");i.removeAllItems();k1.forEach(function(Q1){if(this[Q1]){this[Q1]._oPlanningCalendar=undefined;this[Q1].destroy();this[Q1]=undefined;}},this);if(this._oViews){for(var j in this._oViews){this._oViews[j].destroy();}}if(this._oSelectAllCheckBox){this._oSelectAllCheckBox.destroy();}if(this._rowHeaderClickEvent){this._rowHeaderClickEvent.off();this._rowHeaderClickEvent=null;}};j1.prototype.onBeforeRendering=function(){this._bBeforeRendering=true;if((!this._oTimesRow&&!this._oDatesRow&&!this._oMonthsRow&&!this._oWeeksRow&&!this._oOneMonthsRow)||this._bCheckView){this.setViewKey(this.getViewKey());this._bCheckView=undefined;}K1.call(this);if(this._sUpdateCurrentTime){clearTimeout(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}this._updatePickerSelection();this._updateHeaderButtons();l.orientation.detachHandler(this._updateStickyHeader,this);this._bBeforeRendering=undefined;this._toggleStickyClasses();};j1.prototype.attachEvent=function(i,j,Q1,R1){C.prototype.attachEvent.call(this,i,j,Q1,R1);if(this.hasListeners("intervalSelect")){k1.forEach(function(S1){if(this[S1]){this[S1]._setAriaRole("button");}},this);}return this;};j1.prototype.detachEvent=function(i,j,Q1){C.prototype.detachEvent.call(this,i,j,Q1);if(!this.hasListeners("intervalSelect")){k1.forEach(function(R1){if(this[R1]){this[R1]._setAriaRole("gridcell");}},this);}return this;};j1.prototype._createHeader=function(){var i=new P(this.getId()+"-Header");i.getAggregation("_actionsToolbar").addAriaLabelledBy(I.getStaticId("sap.m","PC_FUNCTIONS_TOOLBAR"));i.getAggregation("_navigationToolbar").addAriaLabelledBy(I.getStaticId("sap.m","PC_INTERVAL_SELECTION_TOOLBAR"));return i;};j1.prototype._attachHeaderEvents=function(){var i=this._getHeader();i.attachEvent("pressPrevious",this._handlePressArrow,this);i.attachEvent("pressToday",this._handleTodayPress,this);i.attachEvent("pressNext",this._handlePressArrow,this);i.attachEvent("dateSelect",this._handleDateSelect,this);return this;};j1.prototype._handlePressArrow=function(i){this._applyArrowsLogic(i.getId()==="pressPrevious");};j1.prototype._applyArrowsLogic=function(i){if(i){this._dateNav.previous();}else{this._dateNav.next();}if(this.getMinDate()&&this._dateNav.getStart().getTime()<=this.getMinDate().getTime()){this._dateNav.setStart(this.getMinDate());this._dateNav.setCurrent(this.getMinDate());}if(this.getMaxDate()&&this._dateNav.getEnd().getTime()>=this.getMaxDate().getTime()){this._dateNav.setStart(this.getMaxDate());this._dateNav.setCurrent(this.getMaxDate());}var j=this._getRowInstanceByViewKey(this.getViewKey());this.setStartDate(this._dateNav.getStart());j.setDate(this._dateNav.getCurrent());this._updatePickerSelection();this.fireStartDateChange();};j1.prototype._formatPickerText=function(){var i=this._getFirstAndLastRangeDate(),j=a._createLocalDate(i.oStartDate,true),Q1=a._createLocalDate(i.oEndDate,true),R1=this.getViewKey(),S1=c1[R1]?c1[R1]:this._getView(R1).getIntervalType(),T1=m.getConfiguration().getRTL(),U1,V1,W1,X1;switch(S1){case c1.Hour:U1=s.getDateInstance({format:"yMMMMd"});W1=U1.format(j);if(j.getDate()!==Q1.getDate()){X1=U1.format(Q1);}break;case c1.Day:case c1.Week:U1=s.getDateInstance({format:"yMMMMd"});W1=U1.format(j);X1=U1.format(Q1);break;case c1.OneMonth:U1=s.getDateInstance({format:"yMMMM"});W1=U1.format(j);break;case c1.Month:U1=s.getDateInstance({format:"y"});W1=U1.format(j);if(j.getFullYear()!==Q1.getFullYear()){X1=U1.format(Q1);}break;default:throw new Error("Unknown IntervalType: "+R1+"; "+this);}if(!T1){V1=W1;if(X1){V1+=" - "+X1;}}else{if(X1){V1=X1+" - "+W1;}else{V1=W1;}}return V1;};j1.prototype._getFirstAndLastRangeDate=function(){var i=a._createUniversalUTCDate(this.getStartDate(),"Gregorian",true),j=a._createUniversalUTCDate(this._dateNav.getEnd(),"Gregorian",true);return{oStartDate:i,oEndDate:j};};j1.prototype._getHeader=function(){return this.getAggregation("header");};j1.prototype._toggleStickyClasses=function(){this.toggleStyleClass("sapMPCSticky",this.getStickyHeader());return this;};j1.prototype._adjustColumnHeadersTopOffset=function(){var i=this.getStickyHeader(),j=this.getDomRef().querySelector(".sapMListInfoTBarContainer"),Q1;switch(i){case true:Q1=this._getHeader().$().outerHeight()+"px";break;default:Q1="auto";break;}j.style.top=Q1;return this;};j1.prototype._setAriaRole=function(i){if(this.hasListeners("intervalSelect")){i._setAriaRole("button");}else{i._setAriaRole("gridcell");}};j1.prototype._updateTodayButtonState=function(){if(this._oTodayButton){this._oTodayButton.setEnabled(!this._dateMatchesVisibleRange(new Date(),this.getViewKey()));}};j1.prototype._dateMatchesVisibleRange=function(i,j){var Q1=this._getView(j,!this._bBeforeRendering);if(!Q1){return false;}var R1=Q1.getIntervalType(),S1=l1[R1],T1=S1?this[S1.sInstanceName]:null,U1=false;if(T1&&j==="One Month"){return a._isSameMonthAndYear(b.fromLocalJSDate(this.getStartDate()),b.fromLocalJSDate(i));}else if(T1&&j==="Week"){var V1=T1.getDays(),W1=b.fromLocalJSDate(i),X1=b.fromLocalJSDate(this.getStartDate()),Y1=b.fromLocalJSDate(this.getStartDate());Y1.setDate(Y1.getDate()+V1);return W1.isSameOrAfter(X1)&&W1.isBefore(Y1);}return U1;};j1.prototype.onAfterRendering=function(i){i.size={width:this.getDomRef().offsetWidth};v1.call(this,i,true);if(!this._sResizeListener){this._sResizeListener=n.register(this,this._resizeProxy);}if(l.system.phone&&this.getStickyHeader()){l.orientation.attachHandler(this._updateStickyHeader,this);}this._updateCurrentTimeVisualization(false);if(this.getHeight()){var j=this.getDomRef().querySelector("table");if(this.getHeight().indexOf("%")>-1){j.style.height=this.getHeight();return;}var Q1=this.$().height()-this._oInfoToolbar.$().height()+"px";j.style.height=Q1;}this._adjustColumnHeadersTopOffset();};j1.prototype.onThemeChanged=function(){if(this.getDomRef()){this._adjustColumnHeadersTopOffset();}};j1.prototype.addToolbarContent=function(i){if(i&&i.isA("sap.m.Title")){this._observeHeaderTitleText(i);this._getHeader().setTitle(i.getText());i.setVisible(false);}this.addAggregation("toolbarContent",i);return this;};j1.prototype.insertToolbarContent=function(i,j){if(i&&i.isA("sap.m.Title")){this._observeHeaderTitleText(i);this._getHeader().setTitle(i.getText());i.setVisible(false);}this.insertAggregation("toolbarContent",i,j);return this;};j1.prototype.removeToolbarContent=function(i){var j;if(i&&i.isA("sap.m.Title")){this._getHeader().setTitle("");this._disconnectAndDestroyHeaderObserver();}else{j=this.removeAggregation("toolbarContent",i);}return j;};j1.prototype.removeAllToolbarContent=function(){var i=this.removeAllAggregation("toolbarContent");this._getHeader().setTitle("");this._disconnectAndDestroyHeaderObserver();return i;};j1.prototype.destroyToolbarContent=function(){var i=this.destroyAggregation("toolbarContent");this._getHeader().setTitle("");this._disconnectAndDestroyHeaderObserver();return i;};j1.prototype._getHeaderObserver=function(){if(!this._oHeaderObserver){this._oHeaderObserver=new M(this._handleTitleTextChange.bind(this));}return this._oHeaderObserver;};j1.prototype._observeHeaderTitleText=function(i){this._getHeaderObserver().observe(i,{properties:["text"]});};j1.prototype._handleTitleTextChange=function(i){this._getHeader().setTitle(i.current);};j1.prototype._disconnectAndDestroyHeaderObserver=function(){if(this._oHeaderObserver){this._oHeaderObserver.disconnect();this._oHeaderObserver.destroy();this._oHeaderObserver=null;}};j1.prototype.setStartDate=function(i){var j;if(!i){j=new Date();}else{a._checkJSDateObject(i);j=new Date(i.getTime());}j=this._shiftStartDate(j);if(Q(j,this.getStartDate())){this._updateTodayButtonState();return this;}var Q1=j.getFullYear();a._checkYearInValidRange(Q1);var R1=this.getMinDate();if(R1&&R1.getTime()>j.getTime()){U.warning("StartDate < minDate -> StartDate set to minDate",this);j=new Date(R1.getTime());}else{var S1=this.getMaxDate();if(S1&&S1.getTime()<j.getTime()){U.warning("StartDate > maxDate -> StartDate set to minDate",this);if(R1){j=new Date(R1.getTime());}else{j=new Date(1,0,1);j.setFullYear(1);}}}this.setProperty("startDate",j,true);this._dateNav.setStart(j);this._dateNav.setCurrent(j);this._getHeader().setStartDate(j);k1.forEach(function(T1){if(this[T1]){this[T1].setStartDate(new Date(j.getTime()));}},this);if(this.getViewKey()===$.OneMonth&&this._oOneMonthsRow.getMode()<2&&this._oOneMonthsRow.getSelectedDates().length){this._setRowsStartDate(this._oOneMonthsRow.getSelectedDates()[0].getStartDate());}else{this._setRowsStartDate(new Date(j.getTime()));}if(this.getViewKey()===$.Week||this.getViewKey()===$.OneMonth){this._updateTodayButtonState();}if(this.getDomRef()){this._updateCurrentTimeVisualization(false);this._updatePickerSelection();}this._updateHeaderButtons();return this;};j1.prototype.setMinDate=function(i){if(Q(i,this.getMinDate())){return this;}var j=this.getMaxDate(),Q1=this._getHeader();if(i){a._checkJSDateObject(i);var R1=i.getFullYear();a._checkYearInValidRange(R1);this.setProperty("minDate",i,true);this._bNoStartDateChange=true;Q1.getAggregation("_calendarPicker").setMinDate(new Date(i.getTime()));Q1.getAggregation("_monthPicker").setMinDate(new Date(i.getTime()));Q1.getAggregation("_yearPicker").setMinDate(new Date(i.getTime()));if(j&&j.getTime()<i.getTime()){U.warning("minDate > maxDate -> maxDate set to end of the month",this);j=new Date(i.getTime());j.setMonth(j.getMonth()+1,0);j.setHours(23);j.setMinutes(59);j.setSeconds(59);j.setMilliseconds(0);this.setMaxDate(j);}this._bNoStartDateChange=undefined;var S1=this.getStartDate();if(S1&&S1.getTime()<i.getTime()){U.warning("StartDate < minDate -> StartDate set to minDate",this);S1=new Date(i.getTime());this.setStartDate(S1);Q1.setPickerText(this._formatPickerText());}}else{this.setProperty("minDate",undefined,true);Q1.getAggregation("_calendarPicker").setMinDate();Q1.getAggregation("_monthPicker").setMinDate();Q1.getAggregation("_yearPicker").setMinDate();}var T1=new Date();if(i&&T1.getTime()<i.getTime()){this._oTodayButton.setVisible(false);}else if(!j||T1.getTime()<j.getTime()){this._oTodayButton.setVisible(true);}return this;};j1.prototype.setMaxDate=function(i){if(Q(i,this.getMaxDate())){return this;}var j=this.getMinDate(),Q1=this._getHeader();if(i){a._checkJSDateObject(i);var R1=i.getFullYear();a._checkYearInValidRange(R1);this.setProperty("maxDate",i,true);this._bNoStartDateChange=true;Q1.getAggregation("_calendarPicker").setMaxDate(new Date(i.getTime()));Q1.getAggregation("_monthPicker").setMaxDate(new Date(i.getTime()));Q1.getAggregation("_yearPicker").setMaxDate(new Date(i.getTime()));if(j&&j.getTime()>i.getTime()){U.warning("maxDate < minDate -> maxDate set to begin of the month",this);j=new Date(i.getTime());j.setDate(1);j.setHours(0);j.setMinutes(0);j.setSeconds(0);j.setMilliseconds(0);this.setMinDate(j);}this._bNoStartDateChange=undefined;var S1=this.getStartDate();if(S1&&S1.getTime()>i.getTime()){U.warning("StartDate > maxDate -> StartDate set to minDate",this);if(j){S1=new Date(j.getTime());}else{S1=new Date(1,0,1);S1.setFullYear(1);}this.setStartDate(S1);Q1.setPickerText(this._formatPickerText());}}else{this.setProperty("maxDate",undefined,true);Q1.getAggregation("_calendarPicker").setMaxDate();Q1.getAggregation("_monthPicker").setMaxDate();Q1.getAggregation("_yearPicker").setMaxDate();}var T1=new Date();if(i&&T1.getTime()>i.getTime()){this._oTodayButton.setVisible(false);}else if(!j||T1.getTime()>j.getTime()){this._oTodayButton.setVisible(true);}return this;};j1.prototype.removeIntervalInstanceFromInfoToolbar=function(){var i=this._oInfoToolbar.getContent();i.forEach(function(j){if(j.isA(p1)){this._oInfoToolbar.removeContent(j);}}.bind(this));};j1.prototype.setViewKey=function(j){var Q1,R1,S1,T1=this.getViewKey(),U1=this._getHeader(),V1;this.setProperty("viewKey",j,true);this._oIntervalTypeSelect.setSelectedKey(j);this.removeIntervalInstanceFromInfoToolbar();var W1=this.getStartDate();var X1=this.getMinDate();var Y1=this.getMaxDate();var Z1=this._getView(j,!this._bBeforeRendering);if(!Z1){this._bCheckView=true;this.invalidate();}else{var $1=Z1.getIntervalType();var _1=this._getIntervals(Z1);this._bCheckView=false;this._dateNav.setUnit($1);this._dateNav.setStep(_1);this._dateNav.setCurrent(undefined);switch($1){case c1.Hour:if(!this._oTimesRow){this._oTimesRow=new T(this.getId()+"-TimesRow",{startDate:new Date(W1.getTime()),items:_1,legend:this.getLegend()});this._setAriaRole(this._oTimesRow);this._oTimesRow._setLegendControlOrigin(this);this._oTimesRow.attachEvent("focus",this._handleFocus,this);this._oTimesRow.attachEvent("select",this._handleCalendarSelect,this);this._oTimesRow._oPlanningCalendar=this;this._oTimesRow._getSpecialDates=function(){return this._oPlanningCalendar._getSpecialDates();};this._oTimesRow.getSpecialDates=function(){return this._oPlanningCalendar.getSpecialDates();};}else if(this._oTimesRow.getItems()!==_1){this._oTimesRow.setItems(_1);this._dateNav.setStep(_1);}this._insertInterval(this._oTimesRow);U1.setAssociation("currentPicker",U1.getAggregation("_calendarPicker"));break;case c1.Day:case c1.Week:case c1.OneMonth:S1=l1[$1];Q1=this[S1.sInstanceName];if(!Q1){Q1=new S1.oClass(this.getId()+S1.sIdSuffix,{startDate:new Date(W1.getTime()),days:_1,showDayNamesLine:this.getShowDayNamesLine(),legend:this.getLegend(),showWeekNumbers:this.getShowWeekNumbers()});this._setAriaRole(Q1);Q1.attachEvent("select",this._handleCalendarSelect,this);Q1.attachEvent("focus",this._handleFocus,this);if(j===$.OneMonth){Q1._setRowsStartDate=this._setRowsStartDate.bind(this);}Q1._oPlanningCalendar=this;Q1._getSpecialDates=function(){return this._oPlanningCalendar._getSpecialDates();};Q1.getSpecialDates=function(){return this._oPlanningCalendar.getSpecialDates();};}else if(Q1.getDays()!==_1){Q1.setDays(_1);this._dateNav.setStep(_1);}this._insertInterval(Q1);this[S1.sInstanceName]=Q1;if($1===c1.OneMonth){U1.setAssociation("currentPicker",U1.getAggregation("_monthPicker"));}else{U1.setAssociation("currentPicker",U1.getAggregation("_calendarPicker"));}break;case c1.Month:if(!this._oMonthsRow){this._oMonthsRow=new d(this.getId()+"-MonthsRow",{startDate:new Date(W1.getTime()),months:_1,legend:this.getLegend()});this._setAriaRole(this._oMonthsRow);this._oMonthsRow._setLegendControlOrigin(this);this._oMonthsRow.attachEvent("focus",this._handleFocus,this);this._oMonthsRow.attachEvent("select",this._handleCalendarSelect,this);this._oMonthsRow._oPlanningCalendar=this;this._oMonthsRow._getSpecialDates=function(){return this._oPlanningCalendar._getSpecialDates();};this._oMonthsRow.getSpecialDates=function(){return this._oPlanningCalendar.getSpecialDates();};}else if(this._oMonthsRow.setMonths()!==_1){this._oMonthsRow.setMonths(_1);this._dateNav.setStep(_1);}this._insertInterval(this._oMonthsRow);U1.setAssociation("currentPicker",U1.getAggregation("_yearPicker"));break;default:throw new Error("Unknown IntervalType: "+$1+"; "+this);}var a2=this.getRows();for(var i=0;i<a2.length;i++){var b2=a2[i];var c2=G1(b2);c2.setIntervalType($1);c2.setIntervals(_1);c2.setShowSubIntervals(Z1.getShowSubIntervals());}if(this.getDomRef()){this._updateCurrentTimeVisualization(false);t1.call(this,this.getShowWeekNumbers(),this._viewAllowsWeekNumbers(j));u1.call(this,this.getShowDayNamesLine(),!!Q1);}this._updatePickerSelection();}if(j===$.Week||j===$.OneMonth||j===$.Month){R1=this.getStartDate();this.setStartDate(new Date(R1.getTime()));if(R1.getTime()!==this.getStartDate().getTime()){this.fireStartDateChange();}}if(this._oOneMonthsRow&&j===$.OneMonth){this._oOneMonthsRow.setMode(this._iSize);this._oOldStartDate=new Date(this.getStartDate().getTime());this._adjustSelectedDate(b.fromLocalJSDate(R1));if(this._iSize<2){this._setRowsStartDate(R1);}}else if(this._oOneMonthsRow&&T1===$.OneMonth&&this._oOneMonthsRow.getSelectedDates().length){V1=this._oOneMonthsRow.getSelectedDates()[0].getStartDate();V1.setHours(this._oOldStartDate.getHours());V1.setMinutes(this._oOldStartDate.getMinutes());V1.setSeconds(this._oOldStartDate.getSeconds());V1.setMilliseconds(this._oOldStartDate.getMilliseconds());if(V1){this.setStartDate(V1);}}if(X1){U1.getAggregation("_calendarPicker").setMinDate(new Date(X1.getTime()));U1.getAggregation("_yearPicker").setMinDate(new Date(X1.getTime()));U1.getAggregation("_monthPicker").setMinDate(new Date(X1.getTime()));}if(Y1){U1.getAggregation("_calendarPicker").setMaxDate(new Date(Y1.getTime()));U1.getAggregation("_yearPicker").setMaxDate(new Date(Y1.getTime()));U1.getAggregation("_monthPicker").setMaxDate(new Date(Y1.getTime()));}this._updateTodayButtonState();return this;};j1.prototype._handleFocus=function(i){var j=i.getParameter("date"),Q1=i.getParameter("restoreOldDate");if(Q1){return;}this.shiftToDate(j,i.getParameter("otherMonth"));};j1.prototype.shiftToDate=function(i,j){var Q1=this._getRowInstanceByViewKey(this.getViewKey()),R1,S1;this._dateNav.toDate(i);R1=this._dateNav.getStart();S1=this._dateNav.getCurrent();if(this._dateNav.getCurrent()>this._dateNav.getEnd()){R1=new Date(this._dateNav.getStart());R1.setDate(R1.getDate()+1);}if((this.getMaxDate()&&this.getMaxDate()<i)||(this.getMinDate()&&this.getMinDate()>i)){return;}if(j){this.fireStartDateChange();}if(Q1&&!(Q1.getMode&&Q1.getMode()<2&&!j)){this.setStartDate(R1);Q1.setStartDate(R1);Q1.setDate(S1);}};j1.prototype._shiftStartDate=function(i){if(this.getViewKey()===$.Week){var j=a.getFirstDateOfWeek(a._createUniversalUTCDate(i,undefined,true));i.setTime(a._createLocalDate(j,true).getTime());}if((this.getViewKey()===$.OneMonth||this.getViewKey()===$.Month)){var Q1=a.getFirstDateOfMonth(a._createUniversalUTCDate(i,undefined,true));i.setTime(a._createLocalDate(Q1,true).getTime());}return i;};j1.prototype._updatePickerSelection=function(){var i=this._getFirstAndLastRangeDate(),j=this._getHeader().getAssociation("currentPicker"),Q1=m.byId(j),R1;R1=new e({startDate:a._createLocalDate(i.oStartDate,true),endDate:a._createLocalDate(i.oEndDate,true)});Q1.destroySelectedDates();Q1.addSelectedDate(R1);this._getHeader().setPickerText(this._formatPickerText());this._updateTodayButtonState();};j1.prototype._adjustSelectedDate=function(i){var j=i.toLocalJSDate();if(this._oOneMonthsRow.getMode&&this._oOneMonthsRow.getMode()<2){this._oOneMonthsRow.removeAllSelectedDates();this._oOneMonthsRow.addSelectedDate(new e({startDate:j}));this._oOneMonthsRow.selectDate(j);}};j1.prototype._insertInterval=function(i){if(this._iSizeScreen>1){this._oInfoToolbar.addContent(i);}else{this._oInfoToolbar.insertContent(i,1);}};j1.prototype._viewAllowsWeekNumbers=function(i){var j=this._getView(i).getIntervalType(),Q1=l1[j];return!!Q1&&!!Q1.oClass.prototype.setShowWeekNumbers;};j1.prototype._viewAllowsDayNamesLine=function(i){var j=this._getView(i).getIntervalType(),Q1=l1[j];return!!Q1&&!!Q1.oClass.prototype.setShowDayNamesLine;};j1.prototype._getRowInstanceByViewKey=function(i){var j=this._getView(i).getIntervalType(),Q1=l1[j],R1;if(Q1){R1=this[Q1.sInstanceName];}if(j===c1.Month){R1=this._oMonthsRow;}if(j===c1.Hour){R1=this._oTimesRow;}return R1;};j1.prototype.setShowWeekNumbers=function(i){this.setProperty("showWeekNumbers",i,true);this._getViews().forEach(function(j){var Q1=j.getKey(),R1=this._viewAllowsWeekNumbers(Q1),S1=this._getRowInstanceByViewKey(Q1);if(S1&&R1){S1.setShowWeekNumbers(i);}if(this.getDomRef()&&this.getViewKey()===Q1){t1.call(this,i,R1);}},this);return this;};j1.prototype.setShowIntervalHeaders=function(j){this.setProperty("showIntervalHeaders",j,true);var Q1=this.getRows();for(var i=0;i<Q1.length;i++){var R1=Q1[i];G1(R1).setShowIntervalHeaders(j);}return this;};j1.prototype.setShowEmptyIntervalHeaders=function(j){this.setProperty("showEmptyIntervalHeaders",j,true);var Q1=this.getRows();for(var i=0;i<Q1.length;i++){var R1=Q1[i];G1(R1).setShowEmptyIntervalHeaders(j);}return this;};j1.prototype.setGroupAppointmentsMode=function(j){this.setProperty("groupAppointmentsMode",j,true);var Q1=this.getRows();for(var i=0;i<Q1.length;i++){var R1=Q1[i];G1(R1).setGroupAppointmentsMode(j);}return this;};j1.prototype.setAppointmentsReducedHeight=function(j){this.setProperty("appointmentsReducedHeight",j,true);var Q1=this.getRows();for(var i=0;i<Q1.length;i++){var R1=Q1[i];G1(R1).setAppointmentsReducedHeight(j);}return this;};j1.prototype.setAppointmentHeight=function(j){var Q1=this.getRows(),i;this.setProperty("appointmentHeight",j);for(i=0;i<Q1.length;i++){var R1=Q1[i];G1(R1).setAppointmentHeight(j);}return this;};j1.prototype.setAppointmentRoundWidth=function(j){var Q1=this.getRows(),i;this.setProperty("appointmentRoundWidth",j);for(i=0;i<Q1.length;i++){var R1=Q1[i];G1(R1).setAppointmentRoundWidth(j);}return this;};j1.prototype.setAppointmentsVisualization=function(j){this.setProperty("appointmentsVisualization",j,true);var Q1=this.getRows();for(var i=0;i<Q1.length;i++){var R1=Q1[i];G1(R1).setAppointmentsVisualization(j);}return this;};j1.prototype.setShowRowHeaders=function(i){this.setProperty("showRowHeaders",i,true);var j=this.getAggregation("table");j.getColumns()[0].setVisible(i);this._toggleAppointmentsColumnPopinState(i);this.$().toggleClass("sapMPlanCalNoHead",!i);O1.call(this);this._setSelectionMode.call(this);return this;};j1.prototype.setShowDayNamesLine=function(i){var j,Q1,R1,S1=!!this.getDomRef(),T1=this.getViewKey();for(j in l1){Q1=l1[j].sInstanceName;if(this[Q1]){R1=this[Q1];R1.setShowDayNamesLine(i);if(S1&&j===T1){u1.call(this,i,true);}}}return this.setProperty("showDayNamesLine",i,false);};j1.prototype.setStickyHeader=function(i){if(this.getStickyHeader()===i){return this;}this.setProperty("stickyHeader",i,true);if(l.system.phone){if(i){l.orientation.attachHandler(this._updateStickyHeader,this);}else{l.orientation.detachHandler(this._updateStickyHeader,this);}}this._updateStickyHeader();return this;};j1.prototype._updateStickyHeader=function(){var i=[],j=this.getStickyHeader(),Q1=this.getViewKey()===$.OneMonth&&this._iSize<2,R1=j&&!l.system.phone&&!Q1,S1=j&&!(l.system.phone&&l.orientation.landscape)&&!Q1;if(R1){i.push(W.HeaderToolbar);}if(this._oInfoToolbar&&S1){i.push(W.InfoToolbar);}this.getAggregation("table").setSticky(i);};j1.prototype.addRow=function(i){this.addAggregation("rows",i);this.getAggregation("table").addItem(this._createPlanningCalendarListItem(i));return this;};j1.prototype.insertRow=function(i,j){this.insertAggregation("rows",i,j);this.getAggregation("table").insertItem(this._createPlanningCalendarListItem(i),j,true);return this;};j1.prototype.removeRow=function(i){var j=this.removeAggregation("rows",i,true),Q1=this.getAggregation("table");Q1.removeItem(E1(j),true);this._handleRowRemoval(j);N1.call(this);this._setSelectionMode.call(this);return j;};j1.prototype.removeAllRows=function(){var i=this.removeAllAggregation("rows",true),j=this.getAggregation("table");j.removeAllItems(true);i.forEach(this._handleRowRemoval,this);N1.call(this);this._setSelectionMode.call(this);return i;};j1.prototype.destroyRows=function(){var i;var j=this.getAggregation("table");j.destroyItems(true);i=this.destroyAggregation("rows");N1.call(this);this._setSelectionMode.call(this);return i;};j1.prototype.setSingleSelection=function(i){this.setProperty("singleSelection",i,true);O1.call(this);this._setSelectionMode.call(this);if(i){this.selectAllRows(false);}else{N1.call(this);}this.$().toggleClass("sapMPlanCalMultiSel",!i);return this;};j1.prototype.setNoDataText=function(i){this.setProperty("noDataText",i,true);var j=this.getAggregation("table");j.setNoDataText(i);return this;};j1.prototype.setLegend=function(j){this.setAssociation("legend",j,true);var Q1=this.getRows(),R1=this.getLegend()&&m.byId(this.getLegend()),S1;for(var i=0;i<Q1.length;i++){var T1=Q1[i];G1(T1).setLegend(j);}k1.forEach(function(U1){if(this[U1]){this[U1].setLegend(j);}},this);if(R1){S1=new M(function(U1){this.invalidate();}.bind(this));S1.observe(R1,{destroy:true});}return this;};j1.prototype.addAriaLabelledBy=function(i){this.addAssociation("ariaLabelledBy",i,true);var j=this.getAggregation("table");j.addAriaLabelledBy(i);return this;};j1.prototype.removeAriaLabelledBy=function(i){this.removeAssociation("ariaLabelledBy",i,true);var j=this.getAggregation("table");j.removeAriaLabelledBy(i);return this;};j1.prototype.removeAllAriaLabelledBy=function(){this.removeAllAssociation("ariaLabelledBy",true);var i=this.getAggregation("table");i.removeAllAriaLabelledBy();i.addAriaLabelledBy(this.getId()+"-Descr");return this;};j1.prototype.invalidate=function(i){var j=i&&i instanceof e;if(!this._bIsBeingDestroyed&&(this._bDateRangeChanged||j)){if(this.getDomRef()){var Q1=this.getViewKey();var R1=this._getView(Q1);var S1=R1.getIntervalType();switch(S1){case c1.Hour:if(this._oTimesRow){this._oTimesRow.invalidate(arguments);}break;case c1.Day:if(this._oDatesRow){this._oDatesRow.invalidate(arguments);}break;case c1.Month:if(this._oMonthsRow){this._oMonthsRow.invalidate(arguments);}break;case c1.OneMonth:if(this._oOneMonthsRow){this._oOneMonthsRow.invalidate(arguments);}break;case c1.Week:if(this._oWeeksRow){this._oWeeksRow.invalidate(arguments);}break;default:throw new Error("Unknown IntervalType: "+S1+"; "+this);}}this._bDateRangeChanged=undefined;}else{if(i&&i instanceof sap.m.PlanningCalendarView){this._bCheckView=true;}C.prototype.invalidate.apply(this,arguments);}};j1.prototype.addSpecialDate=function(i){this._bDateRangeChanged=true;return C.prototype.addAggregation.call(this,"specialDates",i);};j1.prototype.insertSpecialDate=function(i,j){this._bDateRangeChanged=true;return C.prototype.insertAggregation.call(this,"specialDates",i,j);};j1.prototype.removeSpecialDate=function(i){this._bDateRangeChanged=true;return C.prototype.removeAggregation.call(this,"specialDates",i);};j1.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;return this.removeAllAggregation("specialDates");};j1.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;return this.destroyAggregation("specialDates");};j1.prototype.removeAllViews=function(){this._bCheckView=true;var i=this.removeAllAggregation("views"),j=this.getBuiltInViews();if(j.length){this.setViewKey(j[0]);}else{this.setViewKey(n1[0]);}return i;};j1.prototype.destroyViews=function(){this._bCheckView=true;var i=this.destroyAggregation("views"),j=this.getBuiltInViews();if(j.length){this.setViewKey(j[0]);}else{this.setViewKey(n1[0]);}return i;};j1.prototype.getSelectedRows=function(){return this.getRows().filter(function(i){return i.getSelected();});};j1.prototype.selectAllRows=function(j){var Q1=this.getRows();if(!(j&&this.getSingleSelection())){for(var i=0;i<Q1.length;i++){var R1=Q1[i];R1.setSelected(j);}if(this._oSelectAllCheckBox){this._oSelectAllCheckBox.setSelected(j);}}return this;};j1.prototype.onsaphomemodifiers=function(i){if((i.metaKey||i.ctrlKey)&&!i.altKey&&!i.shiftKey){var j=this.getRows();var Q1=j[0];var R1=new V.Event("saphome");R1._bPlanningCalendar=true;G1(Q1).onsaphome(R1);i.preventDefault();i.stopPropagation();}};j1.prototype.onsapendmodifiers=function(i){if((i.metaKey||i.ctrlKey)&&!i.altKey&&!i.shiftKey){var j=this.getRows();var Q1=j[j.length-1];var R1=new V.Event("sapend");R1._bPlanningCalendar=true;G1(Q1).onsapend(R1);i.preventDefault();i.stopPropagation();}};j1.prototype.setBuiltInViews=function(i){this.setProperty("builtInViews",i);this.setViewKey(this._getViews()[0].getKey());return this;};j1.prototype.removeView=function(i){var j=this.removeAggregation("views",i);if(!this.getViews().length){this.setViewKey(this._getViews()[0].getKey());}return j;};j1.prototype._getIntervals=function(i){var j=0;switch(this._iSize){case 0:j=i.getIntervalsS();break;case 1:j=i.getIntervalsM();break;default:j=i.getIntervalsL();break;}return j;};j1.prototype._getView=function(j,Q1){var R1=this._getViews();var S1;for(var i=0;i<R1.length;i++){S1=R1[i];if(S1.getKey()!=j){S1=undefined;}else{break;}}if(!S1&&!Q1){throw new Error("PlanningCalendarView with key "+j+" not assigned "+this);}return S1;};j1.prototype._changeStartDate=function(i){if(this._bNoStartDateChange){return;}this.setStartDate(new Date(i.getTime()));this._updatePickerSelection();this.fireStartDateChange();};j1.prototype._updateCurrentTimeVisualization=function(j){if(this._sUpdateCurrentTime){clearTimeout(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}if(j){var Q1=this.getRows();for(var i=0;i<Q1.length;i++){var R1=Q1[i];G1(R1).updateCurrentTimeVisualization();}}var S1=new Date();var T1=this.getStartDate();var U1=this.getViewKey();var V1=this._getView(U1);var W1=V1.getIntervalType();var X1=this._getIntervals(V1);var Y1=0;var Z1=0;var $1=0;switch(W1){case c1.Hour:Y1=60000;Z1=T1.getTime()-3600000;$1=T1.getTime()+X1*3600000;break;case c1.Day:case c1.Week:case c1.OneMonth:Y1=1800000;Z1=T1.getTime()-3600000;$1=T1.getTime()+X1*86400000;break;default:Y1=-1;break;}if(S1.getTime()<=$1&&S1.getTime()>=Z1&&Y1>0){this._sUpdateCurrentTime=setTimeout(this['_updateCurrentTimeVisualization'].bind(this,true),Y1);}};function r1(i){this.setViewKey(i.getParameter("item").getKey());this.fireViewChange();}j1.prototype._handleTodayPress=function(i){var j=new Date(),Q1,R1=this.getViewKey();if(R1===$.OneMonth){Q1=a.getFirstDateOfMonth(a._createUniversalUTCDate(j,undefined,true));this._adjustSelectedDate(b.fromLocalJSDate(j));j=a._createLocalDate(Q1,true);}if(R1===$.Week){Q1=this.getStartDate();j.setHours(Q1.getHours());j.setMinutes(Q1.getMinutes());j.setSeconds(Q1.getSeconds());}this.setStartDate(j);this._dateNav.setCurrent(j);this._updatePickerSelection();this.fireStartDateChange();};j1.prototype._handleStartDateChange=function(i){var j=i.oSource.getStartDate();if(this._getView(this.getViewKey()).getIntervalType()!==c1.Hour){var Q1=this.getStartDate();j.setHours(Q1.getHours());j.setMinutes(Q1.getMinutes());j.setSeconds(Q1.getSeconds());}this._changeStartDate(j);};j1.prototype._handleDateSelect=function(i){var j=i.oSource.getStartDate();if(this._getView(this.getViewKey()).getIntervalType()===c1.Hour){var Q1=this.getStartDate();j.setHours(Q1.getHours());j.setMinutes(Q1.getMinutes());j.setSeconds(Q1.getSeconds());}this._changeStartDate(j);this._dateNav.setCurrent(j);var R1=this.getViewKey(),S1=this._getView(R1),T1=S1.getIntervalType(),U1;if(T1==="Hour"){T1="Time";}else if(T1==="Day"){T1="Date";}else if(T1==="One Month"){T1="OneMonth";}U1="_o"+T1+"sRow";if(this[U1]){this[U1].setDate(j);}};j1.prototype._handleCalendarSelect=function(i){var j=i.getSource().getSelectedDates();if(!j.length){return;}var Q1=new Date(j[0].getStartDate());var R1=a._createUniversalUTCDate(Q1,undefined,true);var S1=this.getViewKey();var T1=this._getView(S1);var U1=T1.getIntervalType();if(U1!==c1.OneMonth||this._iSize>1){j[0].setStartDate();}switch(U1){case c1.Hour:R1.setUTCHours(R1.getUTCHours()+1);break;case c1.Day:case c1.Week:R1.setUTCDate(R1.getUTCDate()+1);break;case c1.OneMonth:if(this._iSize<2){var V1=new Date(Q1.getTime());if(a.monthsDiffer(this.getStartDate(),Q1)){this.setStartDate(Q1);this._getHeader().setPickerText(this._formatPickerText());}this._setRowsStartDate(V1);this._oOneMonthsRow._focusDate(b.fromLocalJSDate(V1),true);}else if(a._isNextMonth(Q1,this.getStartDate())){this.shiftToDate(Q1);return;}R1.setUTCDate(R1.getUTCDate()+1);break;case c1.Month:R1.setUTCMonth(R1.getUTCMonth()+1);break;default:throw new Error("Unknown IntervalType: "+U1+"; "+this);}R1.setUTCMilliseconds(R1.getUTCMilliseconds()-1);R1=a._createLocalDate(R1,true);this._formatPickerText();this.fireIntervalSelect({startDate:Q1,endDate:R1,subInterval:false,row:undefined});};function s1(i){var j=i.getParameter("startDate");var Q1=this.getViewKey();var R1=this._getView(Q1);var S1=R1.getIntervalType();if(S1===c1.OneMonth&&a._isNextMonth(j,this.getStartDate())){this.shiftToDate(j);return;}var T1=i.getParameter("endDate");var U1=i.getParameter("subInterval");var V1=D1(i.oSource.getParent());this._formatPickerText();this.fireIntervalSelect({startDate:j,endDate:T1,subInterval:U1,row:V1});}j1.prototype._applyContextualSettings=function(i){return C.prototype._applyContextualSettings.call(this,i);};function t1(i,j){this.$().toggleClass("sapMPlanCalWithWeekNumbers",i&&j);}function u1(i,j){this.$().toggleClass("sapMPlanCalWithDayNamesLine",i&&j);}function v1(j,Q1){if(j.size.width<=0){return;}if(Math.abs(this.iWidth-j.size.width)<15){return;}this.iWidth=j.size.width;this._applyContextualSettings({contextualWidth:this.iWidth});var R1=this.getRows();var S1;var i=0;var T1;var U1=this._iSize;I1.call(this,j.size.width);if(U1!=this._iSize){J1.call(this,this._iSize);var V1=this.getViewKey();var W1=this._getView(V1);var X1=W1.getIntervalType();var Y1=this._getIntervals(W1);for(i=0;i<R1.length;i++){S1=R1[i];var Z1=G1(S1);if(Y1!=Z1.getIntervals()){Z1.setIntervals(Y1);}else{Z1.handleResize();}}switch(X1){case c1.Hour:if(this._oTimesRow&&this._oTimesRow.getItems()!=Y1){this._oTimesRow.setItems(Y1);this._dateNav.setStep(Y1);}break;case c1.Day:if(this._oDatesRow&&this._oDatesRow.getDays()!=Y1){this._oDatesRow.setDays(Y1);this._dateNav.setStep(Y1);}break;case c1.Month:if(this._oMonthsRow&&this._oMonthsRow.getMonths()!=Y1){this._oMonthsRow.setMonths(Y1);this._dateNav.setStep(Y1);}break;case c1.Week:if(this._oWeeksRow&&this._oWeeksRow.getDays()!=Y1){this._oWeeksRow.setDays(Y1);this._dateNav.setStep(Y1);}break;case c1.OneMonth:if(this._oOneMonthsRow&&this._oOneMonthsRow.getDays()!=Y1){this._oOneMonthsRow.setDays(Y1);this._dateNav.setStep(Y1);if(this._iSize>1){this._setRowsStartDate(new Date(this.getStartDate().getTime()));}}break;default:throw new Error("Unknown IntervalType: "+X1+"; "+this);}O1.call(this);}else if(!Q1){for(i=0;i<R1.length;i++){S1=R1[i];G1(S1).handleResize();}}if(this._oOneMonthsRow&&this.getViewKey()===c1.OneMonth){T1=(this._getSelectedDates().length&&this._getSelectedDates()[0].getStartDate())?this._getSelectedDates()[0].getStartDate():this.getStartDate();this._oOneMonthsRow.setMode(this._iSize);this._adjustSelectedDate(b.fromLocalJSDate(T1));}if(this.getStickyHeader()){this._updateStickyHeader();}}function w1(Q1){var R1=Q1.getParameter("appointment"),S1=Q1.getParameter("multiSelect"),T1=Q1.getParameter("appointments"),U1=Q1.getParameter("domRefId"),V1,W1,X1,Y1,Z1,i,j;if(!S1){W1=this.getRows();for(i=0;i<W1.length;i++){X1=W1[i];if(Q1.oSource!=G1(X1)){Y1=X1.getAppointments();for(j=0;j<Y1.length;j++){Z1=Y1[j];Z1.setSelected(false);}}}}V1={appointment:R1,appointments:T1,multiSelect:S1,domRefId:U1};this.fireAppointmentSelect(V1);}j1.prototype._setRowsStartDate=function(j){var Q1=this.getRows(),R1,i;for(i=0;i<Q1.length;i++){R1=Q1[i];G1(R1).setStartDate(j);}};j1.prototype._toggleAppointmentsColumnPopinState=function(i){var j=this.getAggregation("table"),Q1=j.getColumns()[1];Q1.setDemandPopin(i);Q1.setMinScreenWidth(i?m1:"");};j1.prototype._getViews=function(){var i=this.getViews(),j=this.getBuiltInViews(),Q1,R1=[],S1=$,T1=c1;if(!this._oViews){this._oViews={};}if(j.length){R1=j;}else{R1=i.length?[]:n1;}Q1=R1.map(function(V1){switch(V1){case S1.Hour:return this._oViews[S1.Hour]||(this._oViews[S1.Hour]=new K(this.getId()+"-HourView",{key:S1.Hour,intervalType:T1.Hour,description:this._oRB&&this._oRB.getText("PLANNINGCALENDAR_HOURS"),intervalsS:6,intervalsM:6,intervalsL:12}));case S1.Day:return this._oViews[S1.Day]||(this._oViews[S1.Day]=new K(this.getId()+"-DayView",{key:S1.Day,intervalType:T1.Day,description:this._oRB&&this._oRB.getText("PLANNINGCALENDAR_DAYS"),intervalsS:7,intervalsM:7,intervalsL:14}));case S1.Month:return this._oViews[S1.Month]||(this._oViews[S1.Month]=new K(this.getId()+"-MonthView",{key:S1.Month,intervalType:T1.Month,description:this._oRB&&this._oRB.getText("PLANNINGCALENDAR_MONTHS"),intervalsS:3,intervalsM:6,intervalsL:12}));case S1.Week:return this._oViews[S1.Week]||(this._oViews[S1.Week]=new K(this.getId()+"-WeekView",{key:S1.Week,intervalType:T1.Week,description:this._oRB&&this._oRB.getText("PLANNINGCALENDAR_WEEK"),intervalsS:7,intervalsM:7,intervalsL:7}));case S1.OneMonth:return this._oViews[S1.OneMonth]||(this._oViews[S1.OneMonth]=new K(this.getId()+"-OneMonthView",{key:S1.OneMonth,intervalType:T1.OneMonth,description:this._oRB&&this._oRB.getText("PLANNINGCALENDAR_ONE_MONTH"),intervalsS:1,intervalsM:1,intervalsL:31}));default:U.error("Cannot get PlanningCalendar views. Invalid view key "+V1);break;}},this);for(var U1 in this._oViews){if(R1.indexOf(U1)<0){this._oViews[U1].destroy();delete this._oViews[U1];}}if(i.length){Q1=Q1.concat(i);}return Q1;};j1.prototype.getSelectedAppointments=function(){var i=[];this.getRows().filter(function(j){i.push.apply(i,G1(j).aSelectedAppointments);});return i;};j1.prototype.setCustomAppointmentsSorterCallback=function(i){if(typeof i==="function"||i===null||i===undefined){this.getRows().forEach(function(j){G1(j)._setCustomAppointmentsSorterCallback(i);});this._fnCustomSortedAppointments=i;}else{U.warning("Your custom sort function won't be used, but the old one will be preserved.",this);}return this;};j1.prototype.setWidth=function(i){var j=this.getStartDate();this.getRows().forEach(function(Q1){G1(Q1).setStartDate(j);});return this.setProperty("width",i);};j1.prototype.getCustomAppointmentsSorterCallback=function(){return this._fnCustomSortedAppointments;};j1.prototype._onRowDeselectAppointment=function(){var Q1=this.getRows();for(var i=0;i<Q1.length;i++){var R1=G1(Q1[i]).aSelectedAppointments;for(var j=0;j<R1.length;j++){var S1=m.byId(R1[j]);if(S1){S1.setProperty("selected",false,true);S1.$().removeClass("sapUiCalendarAppSel");}}G1(Q1[i]).aSelectedAppointments=[];}};j1.prototype._updateRowTimeline=function(i){var j=G1(i),Q1,R1,S1,T1,U1=this.getViewKey()===$.OneMonth&&this._iSize<2,V1=this.getStartDate();j.setNonWorkingDays(i.getNonWorkingDays());j.setNonWorkingHours(i.getNonWorkingHours());if(U1&&this._oOneMonthsRow&&this._oOneMonthsRow.getSelectedDates().length){V1=this._oOneMonthsRow.getSelectedDates()[0].getStartDate();}j.setStartDate(V1);j.setShowIntervalHeaders(this.getShowIntervalHeaders());j.setShowEmptyIntervalHeaders(this.getShowEmptyIntervalHeaders());j.setGroupAppointmentsMode(this.getGroupAppointmentsMode());j.setAppointmentsReducedHeight(this.getAppointmentsReducedHeight());j.setAppointmentRoundWidth(this.getAppointmentRoundWidth());j.setLegend(this.getLegend());j.setAppointmentsVisualization(this.getAppointmentsVisualization());j.setAppointmentHeight(this.getAppointmentHeight());j.attachEvent("select",w1,this);j.attachEvent("startDateChange",this._handleStartDateChange,this);j.attachEvent("leaveRow",M1,this);j.attachEvent("intervalSelect",s1,this);N1.call(this);if(P1.call(this)){Q1=this.getViewKey();R1=this._getView(Q1);S1=R1.getIntervalType();T1=this._getIntervals(R1);j.setIntervalType(S1);j.setIntervals(T1);j.setShowSubIntervals(R1.getShowSubIntervals());}this._setSelectionMode.call(this);if(this._fnCustomSortedAppointments){j._setCustomAppointmentsSorterCallback(this._fnCustomSortedAppointments);}};j1.prototype._observeRowChanges=function(i){var j=E1(i),Q1=F1(i),R1=G1(i);var S1={destroy:function(){j.destroy();},change:{title:function(T1){Q1.setProperty(T1.name,T1.current);},icon:function(T1){Q1.setProperty(T1.name,T1.current);},text:function(T1){R1.toggleStyleClass("sapMPlanCalRowLarge",!!T1.current);Q1.setProperty("description",T1.current);},enableAppointmentsDragAndDrop:function(T1){this._enableAppointmentsDragAndDrop(i);}.bind(this),enableAppointmentsResize:function(T1){this._enableAppointmentsResize(i);}.bind(this),enableAppointmentsCreate:function(T1){this._enableAppointmentsCreate(i);}.bind(this),nonWorkingDays:function(T1){R1.setProperty(T1.name,T1.current);},nonWorkingHours:function(T1){R1.setProperty(T1.name,T1.current);},selected:function(T1){N1.call(this);j.setProperty(T1.name,T1.current);}.bind(this),tooltip:function(T1){if(T1.mutation==="insert"){Q1.setTooltip(T1.child);}else if(T1.mutation==="remove"){Q1.setTooltip();}},intervalHeaders:function(T1){R1.invalidate();},appointments:function(T1){R1.invalidate();}}};new M(function(T1){if(T1.type==="destroy"){S1.destroy();}else if(S1.change[T1.name]){S1.change[T1.name](T1);}}).observe(i,{properties:["icon","text","title","nonWorkingDays","nonWorkingHours","selected","enableAppointmentsDragAndDrop","enableAppointmentsResize","enableAppointmentsCreate"],aggregations:["tooltip","appointments","intervalHeaders","headerContent"],destroy:true});i.invalidate=function(T1){if(!T1||!(T1 instanceof g)){E.prototype.invalidate.apply(this,arguments);}else if(j){R1.invalidate(T1);}};i.applyFocusInfo=function(T1){R1.applyFocusInfo(T1);return this;};};j1.prototype._createPlanningCalendarListItem=function(i){var j,Q1,R1;if(i.getHeaderContent().length||i.getBindingInfo("headerContent")){Q1=i._getPlanningCalendarCustomRowHeader();}else{Q1=new x1(i.getId()+"-Head",{icon:i.getIcon(),description:i.getText(),title:i.getTitle(),tooltip:i.getTooltip(),iconDensityAware:false});}R1=new z1(i.getId()+"-CalRow",{checkResize:false,updateCurrentTime:false,ariaLabelledBy:Q1.getId()});R1.getAppointments=function(){return i.getAppointments();};R1.getIntervalHeaders=function(){return i.getIntervalHeaders();};R1.setAssociation("row",i.getId());j=new B1(i.getId()+i1,{cells:[Q1,R1]});this._updateRowTimeline(i);this._observeRowChanges(i);this._enableAppointmentsDragAndDrop(i);this._enableAppointmentsResize(i);this._enableAppointmentsCreate(i);return j;};j1.prototype._handleRowRemoval=function(i){var j=G1(i);j.detachEvent("select",w1,this);j.detachEvent("startDateChange",this._handleStartDateChange,this);j.detachEvent("leaveRow",M1,this);j.detachEvent("intervalSelect",s1,this);if(this._fnCustomSortedAppointments){j._fnCustomSortedAppointments=undefined;}E1(i).destroy();};var x1=F.extend("sap.m._PlanningCalendarRowHeader",{renderer:{apiVersion:2,renderTabIndex:function(i,j){},getAriaRole:function(i,j){}},TagName:"div"});x1.prototype.isSelectable=function(){return false;};var y1=R.extend(k);y1.apiVersion=2;y1.getLegendItems=function(i){var j=[],Q1,R1=i.getLegend();if(R1){Q1=m.byId(R1);if(Q1){j=Q1.getAppointmentItems?Q1.getAppointmentItems():Q1.getItems();}else{U.error("PlanningCalendarLegend with id '"+R1+"' does not exist!",i);}}return j;};y1.renderBeforeAppointments=function(j,Q1){var R1=D1(Q1.getParent()),S1;if(!R1.getEnableAppointmentsDragAndDrop()&&!R1.getEnableAppointmentsResize()&&!R1.getEnableAppointmentsCreate()||Q1._isOneMonthsRowOnSmallSizes()){return;}S1=Q1.getAggregation("_intervalPlaceholders");j.openStart("div");j.class("sapUiCalendarRowAppsOverlay");j.openEnd();if(S1){for(var i=0;i<S1.length;i++){var T1=S1[i];T1.setWidth(100/S1.length+"%");j.renderControl(T1);}}j.close("div");};y1.renderResizeHandle=function(i,j,Q1){if(!D1(j.getParent()).getEnableAppointmentsResize()||j._isOneMonthsRowOnSmallSizes()||(Q1._aAppointments&&Q1._aAppointments.length>0)){return;}i.openStart("span");i.class("sapUiCalendarAppResizeHandle");i.openEnd();i.close("span");};y1.writeCustomAttributes=function(i,j){if(D1(j.getParent()).getEnableAppointmentsCreate()){i.attr("draggable","true");}};y1.renderInterval=function(j,Q1,R1,S1,T1,U1,V1,W1,X1,Y1,Z1,$1,_1){var a2=Q1.getIntervalType(),b2;if(a2===c1.Day||a2===c1.Week||a2===c1.OneMonth){var c2=D1(Q1.getParent()),d2=c2.getParent(),e2=function(o2){return o2.getType()===X.NonWorking;},f2=c2._getSpecialDates().filter(e2),g2=d2._getSpecialDates().filter(e2),h2=Q1.getStartDate(),i2,j2,k2,l2;if(g2&&f2){i2=g2.concat(f2);}else if(f2){i2=f2;}if(i2&&i2.length){var m2=function(o2){return o2===j2.getDay();};j2=new Date(h2.getTime());j2.setHours(0,0,0);j2.setDate(h2.getDate()+R1);for(var i=0;i<i2.length;i++){if(i2[i].getStartDate()){k2=new Date(i2[i].getStartDate().getTime());}if(i2[i].getEndDate()){l2=new Date(i2[i].getEndDate().getTime());}else{l2=new Date(i2[i].getStartDate().getTime());l2.setHours(23,59,59);}if(j2.getTime()>=k2.getTime()&&j2.getTime()<=l2.getTime()){var n2=U1.some(m2);if(!n2){b2="sapUiCalendarRowAppsNoWork";}}}}}k.renderInterval(j,Q1,R1,S1,T1,U1,V1,W1,X1,Y1,Z1,$1,_1,b2);};var z1=h.extend("sap.m._PlanningCalendarRowTimeline",{metadata:{aggregations:{intervalHeaders:{type:"sap.ui.unified.CalendarAppointment",multiple:true},_intervalPlaceholders:{type:"sap.m._PlanningCalendarIntervalPlaceholder",multiple:true,visibility:"hidden",dnd:{droppable:true}}},associations:{row:{type:"sap.m.PlanningCalendarRow",multiple:false}},dnd:true},renderer:y1});z1.prototype._updatePlaceholders=function(){var j=this.getProperty("intervals");if(this.getIntervalType()===c1.Hour){j*=2;}this.removeAllAggregation("_intervalPlaceholders");for(var i=0;i<j;i++){this.addAggregation("_intervalPlaceholders",new A1());}};z1.prototype.onBeforeRendering=function(){h.prototype.onBeforeRendering.call(this);this._updatePlaceholders();};z1.prototype.onmousedown=function(i){var j=i.target.classList;this._isResizeHandleMouseDownTarget=j.contains("sapUiCalendarAppResizeHandle");this._isRowAppsIntervalMouseDownTarget=j.contains("sapUiCalendarRowAppsInt");};z1.prototype._isResizingPerformed=function(){return this._isResizeHandleMouseDownTarget;};z1.prototype._isDraggingPerformed=function(){return!this._isResizeHandleMouseDownTarget&&!this._isRowAppsIntervalMouseDownTarget;};z1.prototype._isCreatingPerformed=function(){return this._isRowAppsIntervalMouseDownTarget;};var A1=C.extend("sap.m._PlanningCalendarIntervalPlaceholder",{metadata:{properties:{width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null}}},renderer:function(i,j){i.openStart("div",j);i.style("width",j.getWidth());i.class("sapUiCalendarRowAppsPlaceholder");i.openEnd();i.close("div");}});var B1=y.extend("sap.m.internal.PlanningCalendarRowListItem",{metadata:{library:"sap.m"},renderer:z});B1.prototype.getHeader=function(){return this.getCells()[0];};B1.prototype.getTimeline=function(){return this.getCells()[1];};B1.prototype.getCustomData=function(){return D1(this).getCustomData();};j1.prototype._getSelectedDates=function(){var i=this.getViewKey(),j=this._getView(i),Q1=j.getIntervalType(),R1=l1[Q1];return this[R1.sInstanceName].getSelectedDates();};j1.prototype._enableAppointmentsDragAndDrop=function(i){var j=G1(i),Q1;if(i.getEnableAppointmentsDragAndDrop()){Q1=i.getDragDropConfig().some(function(R1){return R1.getGroupName()===f1;});if(!Q1){this._addDragDropInfo(i,G1(i));}}else{i.getDragDropConfig().forEach(function(R1){if(R1.getGroupName()===f1){i.removeDragDropConfig(R1);R1.destroy();}});j.getDragDropConfig().forEach(function(R1){if(R1.getGroupName()===f1){j.removeDragDropConfig(R1);R1.destroy();}});}};j1.prototype._enableAppointmentsResize=function(i){var j=i.getEnableAppointmentsResize(),Q1=this._getConfigFromDragDropConfigAggregation(i.getAggregation("dragDropConfig"),g1),R1;if(j&&!Q1){R1=this._createResizeConfig(i);i.addAggregation("dragDropConfig",R1,true);}if(!j&&Q1){i.removeAggregation("dragDropConfig",Q1,true);Q1.destroy();}};j1.prototype._enableAppointmentsCreate=function(i){var j=i.getEnableAppointmentsCreate(),Q1=G1(i),R1=this._getConfigFromDragDropConfigAggregation(Q1.getAggregation("dragDropConfig"),h1),S1;if(j&&!R1){S1=this._createAppointmentsCreateConfig(i);Q1.addAggregation("dragDropConfig",S1,true);}if(!j&&R1){Q1.removeAggregation("dragDropConfig",R1,true);R1.destroy();}};j1.prototype._addDragDropInfo=function(i,j){i.addDragDropConfig(new p({groupName:f1,sourceAggregation:"appointments",dragStart:function(Q1){var R1=function(){var S1=V(".sapUiCalendarRowAppsOverlay");setTimeout(function(){S1.addClass("sapUiCalendarRowAppsOverlayDragging");},0);V(document).one("dragend",function(){S1.removeClass("sapUiCalendarRowAppsOverlayDragging");});};if(j._isOneMonthsRowOnSmallSizes()||!j._isDraggingPerformed()){Q1.preventDefault();return;}R1();}}));j.addDragDropConfig(new q({groupName:f1,targetAggregation:"_intervalPlaceholders",dragEnter:function(Q1){var R1=Q1.getParameter("dragSession"),S1=R1.getDragControl(),T1=j.getIntervalType(),U1=j.getStartDate(),V1=j.indexOfAggregation("_intervalPlaceholders",R1.getDropControl()),W1=j.getId(),X1,Y1=function(){var $1=V(R1.getIndicator()),_1=R1.getDropControl().getDomRef().getBoundingClientRect(),a2=m.byId(W1).getDomRef().getBoundingClientRect(),b2=R1.getDragControl().$().outerWidth(),c2=m.getConfiguration().getRTL(),d2=c2?Math.ceil(_1.right)-a2.left:a2.right-Math.ceil(_1.left);$1.css("min-width",(b2<d2)?b2:d2).css(c2?"border-left-width":"border-right-width",(b2>d2)?"0":"").css("margin-left",c2?-($1.outerWidth()-parseFloat($1.context.style.width)):"");};if(i.hasListeners("appointmentDragEnter")){if(T1===c1.Hour){X1=this._calcNewHoursAppPos(U1,S1.getStartDate(),S1.getEndDate(),V1);}else if(T1===c1.Day||T1===c1.Week||(T1===c1.OneMonth&&!j._isOneMonthsRowOnSmallSizes())){X1=this._calcNewDaysAppPos(U1,S1.getStartDate(),S1.getEndDate(),V1);}else if(T1===c1.Month){X1=this._calcNewMonthsAppPos(U1,S1.getStartDate(),S1.getEndDate(),V1);}var Z1=i.fireAppointmentDragEnter({appointment:S1,startDate:X1.startDate,endDate:X1.endDate,calendarRow:D1(j.getParent())});if(!Z1){Q1.preventDefault();return;}}else if(G1(S1.getParent())!==j){Q1.preventDefault();return;}if(j.getIntervalType()!==c1.Hour){return;}if(!R1.getIndicator()){setTimeout(Y1,0);}else{Y1();}}.bind(this),drop:function(Q1){var R1=Q1.getParameter("dragSession"),S1=R1.getDragControl(),T1=j.getIntervalType(),U1=j.getStartDate(),V1=j.indexOfAggregation("_intervalPlaceholders",R1.getDropControl()),W1,X1=Q1.getParameter("browserEvent"),Y1=(X1.metaKey||X1.ctrlKey);if(T1===c1.Hour){W1=this._calcNewHoursAppPos(U1,S1.getStartDate(),S1.getEndDate(),V1);}else if(T1===c1.Day||T1===c1.Week||(T1===c1.OneMonth&&!j._isOneMonthsRowOnSmallSizes())){W1=this._calcNewDaysAppPos(U1,S1.getStartDate(),S1.getEndDate(),V1);}else if(T1===c1.Month){W1=this._calcNewMonthsAppPos(U1,S1.getStartDate(),S1.getEndDate(),V1);}j.$().find(".sapUiCalendarRowAppsOverlay").removeClass("sapUiCalendarRowAppsOverlayDragging");if(S1.getStartDate().getTime()===W1.startDate.getTime()&&S1.getParent()===D1(j.getParent())){return;}i.fireAppointmentDrop({appointment:S1,startDate:W1.startDate,endDate:W1.endDate,calendarRow:D1(j.getParent()),copy:Y1});}.bind(this)}));};j1.prototype._calcNewHoursAppPos=function(i,j,Q1,R1){var S1=a._createUniversalUTCDate(i,null,true),T1=a._createUniversalUTCDate(j,null,true),U1=a._createUniversalUTCDate(Q1,null,true),V1=new Date(S1.setUTCMinutes(0,0,0)+(R1*30*60*1000));return{startDate:a._createLocalDate(V1,true),endDate:a._createLocalDate(new Date(V1.getTime()+U1.getTime()-T1.getTime()),true)};};j1.prototype._calcNewDaysAppPos=function(i,j,Q1,R1){var S1=a._createUniversalUTCDate(i,null,true),T1=a._createUniversalUTCDate(j,null,true),U1=a._createUniversalUTCDate(Q1,null,true),V1=U1.getTime()-T1.getTime();T1.setUTCFullYear(S1.getUTCFullYear(),S1.getUTCMonth(),S1.getUTCDate()+R1);U1=new Date(T1.getTime()+V1);return{startDate:a._createLocalDate(T1,true),endDate:a._createLocalDate(U1,true)};};j1.prototype._calcNewMonthsAppPos=function(i,j,Q1,R1){var S1=a._createUniversalUTCDate(i,null,true),T1=a._createUniversalUTCDate(j,null,true),U1=a._createUniversalUTCDate(Q1,null,true),V1=U1.getTime()-T1.getTime();T1.setUTCFullYear(S1.getUTCFullYear(),S1.getUTCMonth()+R1);U1=new Date(T1.getTime()+V1);return{startDate:a._createLocalDate(T1,true),endDate:a._createLocalDate(U1,true)};};j1.prototype._createResizeConfig=function(i){var j=G1(i),Q1=new r({sourceAggregation:"appointments",targetAggregation:"_intervalPlaceholders",targetElement:G1(i),dragStart:function(R1){if(!i.getEnableAppointmentsResize()||j._isOneMonthsRowOnSmallSizes()||!j._isResizingPerformed()){R1.preventDefault();return;}var S1=R1.getParameter("dragSession"),T1=j.$().find(".sapUiCalendarRowAppsOverlay"),U1=V(S1.getIndicator()),V1=S1.getDragControl().$();U1.addClass("sapUiDnDIndicatorHide");setTimeout(function(){T1.addClass("sapUiCalendarRowAppsOverlayDragging");},0);V(document).one("dragend",function(){T1.removeClass("sapUiCalendarRowAppsOverlayDragging");U1.removeClass("sapUiDnDIndicatorHide");V1.css({width:"auto","min-width":"auto","z-index":"auto",opacity:1});});if(!l.browser.msie&&!l.browser.edge){R1.getParameter("browserEvent").dataTransfer.setDragImage(C1(),0,0);}},dragEnter:function(R1){var S1=R1.getParameter("dragSession"),T1=this.getTargetElement(),U1=function(){var Z1=V(S1.getIndicator());Z1.addClass("sapUiDnDIndicatorHide");},V1=S1.getDropControl().getDomRef().getBoundingClientRect(),W1=m.byId(T1).getDomRef().getBoundingClientRect(),X1={width:V1.left+V1.width-(S1.getDragControl().$().position().left+W1.left),"z-index":1,opacity:0.8},Y1=X1.width;if(V1.width>0){while(Y1<=0){Y1+=V1.width;}while(Y1>V1.width){Y1-=V1.width;}}X1["min-width"]=Y1;S1.getDragControl().$().css(X1);if(!S1.getIndicator()){setTimeout(U1,0);}else{U1();}},drop:function(R1){var j=G1(i),S1=R1.getParameter("dragSession"),T1=S1.getDragControl(),U1=j.getIntervalType(),V1=j.getStartDate(),W1=j.indexOfAggregation("_intervalPlaceholders",S1.getDropControl()),X1;if(U1===c1.Hour){X1=this._calcResizeNewHoursAppPos(V1,T1.getStartDate(),T1.getEndDate(),W1);}else if(U1===c1.Day||U1===c1.Week||(U1===c1.OneMonth&&!j._isOneMonthsRowOnSmallSizes())){X1=this._calcResizeNewDaysAppPos(V1,T1.getStartDate(),T1.getEndDate(),W1);}else if(U1===c1.Month){X1=this._calcResizeNewMonthsAppPos(V1,T1.getStartDate(),T1.getEndDate(),W1);}j.$().find(".sapUiCalendarRowAppsOverlay").removeClass("sapUiCalendarRowAppsOverlayDragging");V(S1.getIndicator()).removeClass("sapUiDnDIndicatorHide");T1.$().css({width:"auto","min-width":"auto","z-index":"auto",opacity:1});if(T1.getEndDate().getTime()===X1.endDate.getTime()){return;}i.fireAppointmentResize({appointment:T1,startDate:X1.startDate,endDate:X1.endDate,calendarRow:i});}.bind(this)});Q1.setProperty("groupName",g1);return Q1;};j1.prototype._calcResizeNewHoursAppPos=function(i,j,Q1,R1){var S1=a._createUniversalUTCDate(new Date(i.getTime()),null,true),T1=30*60*1000,U1=a._createUniversalUTCDate(j,null,true),V1=new Date(S1.setUTCMinutes(0,0,0)+((R1+1)*T1));if(V1.getTime()<=U1.getTime()){V1=new Date(U1.getTime()+T1);}return{startDate:a._createLocalDate(U1,true),endDate:a._createLocalDate(V1,true)};};j1.prototype._calcResizeNewDaysAppPos=function(i,j,Q1,R1){var S1=a._createUniversalUTCDate(i,null,true),T1=a._createUniversalUTCDate(j,null,true),U1=new Date(S1.setUTCDate(S1.getUTCDate()+R1+1)),V1={};V1.startDate=a._createLocalDate(T1);V1.startDateTime=a._createLocalDate(T1,true);V1.endDate=a._createLocalDate(U1);if(V1.endDate<=V1.startDate){V1.endDate=a._createLocalDate(new Date(U1.setUTCDate(T1.getUTCDate()+1)));}return{startDate:V1.startDateTime,endDate:V1.endDate};};j1.prototype._calcResizeNewMonthsAppPos=function(i,j,Q1,R1){var S1=a._createUniversalUTCDate(i,null,true),T1=a._createUniversalUTCDate(j,null,true),U1=new Date(S1.setUTCMonth(S1.getUTCMonth()+R1+1,1));if(a._monthsBetween(T1,U1,true)<0){U1=new Date(U1.setUTCFullYear(T1.getUTCFullYear(),T1.getUTCMonth()+1,1));}return{startDate:a._createLocalDate(T1,true),endDate:a._createLocalDate(U1)};};j1.prototype._calcCreateNewAppHours=function(i,j,Q1){var R1=a._createUniversalUTCDate(i,null,true),S1=30*60*1000,T1=(j<=Q1)?j:Q1,U1=(j<=Q1)?Q1+1:j,V1=new Date(R1.setUTCMinutes(0,0,0)),W1=new Date(V1.getTime()+T1*S1),X1=new Date(V1.getTime()+U1*S1);return{startDate:a._createLocalDate(W1,true),endDate:a._createLocalDate(X1,true)};};j1.prototype._calcCreateNewAppDays=function(i,j,Q1){var R1=a._createUniversalUTCDate(i,null,true),S1=(j<=Q1)?j:Q1,T1=(j<=Q1)?Q1+1:j,U1=new Date(R1.getTime()),V1=new Date(R1.getTime());return{startDate:a._createLocalDate(new Date(U1.setUTCDate(U1.getUTCDate()+S1))),endDate:a._createLocalDate(new Date(V1.setUTCDate(V1.getUTCDate()+T1)))};};j1.prototype._calcCreateNewAppMonths=function(i,j,Q1){var R1=a._createUniversalUTCDate(i,null,true),S1=(j<=Q1)?j:Q1,T1=(j<=Q1)?Q1+1:j,U1=new Date(R1.getTime()),V1=new Date(R1.getTime());return{startDate:a._createLocalDate(new Date(U1.setUTCMonth(U1.getUTCMonth()+S1,1))),endDate:a._createLocalDate(new Date(V1.setUTCMonth(V1.getUTCMonth()+T1,1)))};};j1.prototype._getConfigFromDragDropConfigAggregation=function(j,Q1){var R1=j,S1=R1&&R1.length;for(var i=0;i<S1;i++){if(R1[i].getGroupName()===Q1){return R1[i];}}return null;};j1.prototype._createAppointmentsCreateConfig=function(i){var j=G1(i),Q1=new r({targetAggregation:"_intervalPlaceholders",dragStart:function(R1){if(!i.getEnableAppointmentsCreate()||j._isOneMonthsRowOnSmallSizes()||!j._isCreatingPerformed()){R1.preventDefault();return;}var S1=R1.getParameter("dragSession"),T1=j.$().find(".sapUiCalendarRowAppsOverlay"),U1=V(S1.getIndicator());setTimeout(function(){T1.addClass("sapUiCalendarRowAppsOverlayDragging");},0);V(document).one("dragend",function(){T1.removeClass("sapUiCalendarRowAppsOverlayDragging");U1.html("");U1.removeClass("sapUiCalendarApp sapUiCalendarAppType01 sapUiAppCreate");});if(!l.browser.msie&&!l.browser.edge){R1.getParameter("browserEvent").dataTransfer.setDragImage(C1(),0,0);}},dragEnter:function(R1){var S1=R1.getParameter("dragSession"),T1=S1.getDropControl().getDomRef().getBoundingClientRect(),U1=function(){var W1=V(S1.getIndicator());W1.addClass("sapUiCalendarApp sapUiCalendarAppType01 sapUiAppCreate");};var V1=S1.getData("text")?parseFloat(S1.getData("text").split("|")[0]):0;if(V1){if(V1<=T1.left){S1.setIndicatorConfig({left:V1,width:Math.max((T1.left+T1.width-V1),T1.width)});}else{S1.setIndicatorConfig({left:T1.left,width:V1-T1.left});}}else{S1.setData("text",T1.left+"|"+j.indexOfAggregation("_intervalPlaceholders",S1.getDropControl()));}if(!S1.getIndicator()){setTimeout(U1,0);}else{U1();}},drop:function(R1){var S1=R1.getParameter("dragSession"),T1=V(S1.getIndicator()),U1=j.getIntervalType(),V1=G1(i).getStartDate(),W1=parseInt(S1.getData("text").split("|")[1]),X1=j.indexOfAggregation("_intervalPlaceholders",S1.getDropControl()),Y1;if(U1===c1.Hour){Y1=this._calcCreateNewAppHours(V1,W1,X1);}else if(U1===c1.Day||U1===c1.Week||(U1===c1.OneMonth&&!j._isOneMonthsRowOnSmallSizes())){Y1=this._calcCreateNewAppDays(V1,W1,X1);}else if(U1===c1.Month){Y1=this._calcCreateNewAppMonths(V1,W1,X1);}i.fireAppointmentCreate({startDate:Y1.startDate,endDate:Y1.endDate,calendarRow:i});T1.html("");T1.removeClass("sapUiCalendarApp sapUiCalendarAppType01 sapUiAppCreate");}.bind(this)});Q1.setProperty("groupName",h1);return Q1;};j1.prototype._updateHeaderButtons=function(){var i=this.getViewKey(),j=this._getView(i,true),Q1=j&&j.getIntervalType(),R1=new Date(this._dateNav.getStart().getTime()),S1=new Date(this._dateNav.getEnd().getTime()),T1=this.getMinDate()?new Date(this.getMinDate().getTime()):undefined,U1=this.getMaxDate()?new Date(this.getMaxDate().getTime()):undefined;if(Q1!=="Hour"){T1&&T1.setHours(0,0,0,0);U1&&U1.setHours(23,59,59,999);R1.setHours(0,0,0,0);S1.setHours(23,59,59,999);}this._getHeader()._oPrevBtn.setEnabled(!T1||R1.getTime()>T1.getTime());this._getHeader()._oNextBtn.setEnabled(!U1||S1.getTime()<U1.getTime());};j1.prototype._getSpecialDates=function(){var j=this.getSpecialDates();for(var i=0;i<j.length;i++){var Q1=j[i].getSecondaryType()===u.CalendarDayType.NonWorking&&j[i].getType()!==u.CalendarDayType.NonWorking;if(Q1){var R1=new f();R1.setType(u.CalendarDayType.NonWorking);R1.setStartDate(j[i].getStartDate());if(j[i].getEndDate()){R1.setEndDate(j[i].getEndDate());}j.push(R1);}}return j;};function C1(){var i=V("<span></span>").addClass("sapUiCalAppResizeGhost");i.appendTo(document.body);setTimeout(function(){i.remove();},0);return i.get(0);}function D1(i){var j=i.getId();return m.byId(j.substring(0,j.indexOf(i1)));}function E1(i){return m.byId(i.getId()+i1);}function F1(i){var j=E1(i);return j?j.getHeader():null;}function G1(i){var j=E1(i);return j?j.getTimeline():null;}function H1(j){var Q1=[];var R1=this.getRows();for(var i=0;i<R1.length;i++){var S1=R1[i];var T1=E1(S1);var U1=T1.getSelected();if(S1.getSelected()!=U1){S1.setProperty("selected",U1,true);Q1.push(S1);}}if(!this.getSingleSelection()){N1.call(this);}if(Q1.length>0){this.fireRowSelectionChange({rows:Q1});}}function I1(i){if(i<this._iBreakPointTablet){this._iSize=0;}else if(i<this._iBreakPointDesktop){this._iSize=1;}else{this._iSize=2;}if(i<o1.PHONE){this._iSizeScreen=0;}else if(i<o1.TABLET){this._iSizeScreen=1;}else{this._iSizeScreen=2;}}function J1(j){var Q1='sapMSize'+j,i,R1;for(i=0;i<3;i++){R1='sapMSize'+i;if(R1===Q1){this.addStyleClass(R1);}else{this.removeStyleClass(R1);}}}function K1(){var j=this._getViews();this._oIntervalTypeSelect.destroyItems();var i;var Q1;for(i=0;i<j.length;i++){var R1=j[i];Q1=new A(this.getId()+"-"+i,{key:R1.getKey(),text:R1.getDescription(),tooltip:R1.getTooltip()});this._oIntervalTypeSelect.addItem(Q1);}if(this._oIntervalTypeSelect.getItems().length>4){this._getHeader()._convertViewSwitchToSelect();}else{this._getHeader()._convertViewSwitchToSegmentedButton();}this._oIntervalTypeSelect.setVisible(!(j.length===1));}function L1(i){var j=i.getParameter("selected");var Q1=this.getRows();if(j){Q1=this.getRows().filter(function(R1){return!R1.getSelected();});}this.selectAllRows(j);this.fireRowSelectionChange({rows:Q1});}function M1(j){var Q1=j.oSource;var R1=j.getParameter("type");var S1=this.getRows();var T1;var U1;var V1;var W1;var i=0;var X1=0;var Y1;for(i=0;i<S1.length;i++){T1=S1[i];if(G1(T1)==Q1){X1=i;break;}}switch(R1){case"sapup":V1=Q1.getFocusedAppointment();W1=V1.getStartDate();if(X1>0){X1--;}U1=S1[X1];G1(U1).focusNearestAppointment(W1);break;case"sapdown":V1=Q1.getFocusedAppointment();W1=V1.getStartDate();if(X1<S1.length-1){X1++;}U1=S1[X1];G1(U1).focusNearestAppointment(W1);break;case"saphome":if(X1>0){U1=S1[0];Y1=new V.Event(R1);Y1._bPlanningCalendar=true;G1(U1).onsaphome(Y1);}break;case"sapend":if(X1<S1.length-1){U1=S1[S1.length-1];Y1=new V.Event(R1);Y1._bPlanningCalendar=true;G1(U1).onsapend(Y1);}break;default:break;}}function N1(){if(this._oSelectAllCheckBox){var i=this.getRows();var j=this.getSelectedRows();if(i.length==j.length&&j.length>0){this._oSelectAllCheckBox.setSelected(true);}else{this._oSelectAllCheckBox.setSelected(false);}}}function O1(){if(this.getSingleSelection()){if(this._oCalendarHeader.getAllCheckBox()){this._oCalendarHeader.setAllCheckBox();}else if(this._oInfoToolbar.getContent().length>2){this._oInfoToolbar.removeContent(this._oSelectAllCheckBox);}}else{if(!this._oSelectAllCheckBox){this._oSelectAllCheckBox=new L(this.getId()+"-All",{text:this._oRB.getText("COLUMNSPANEL_SELECT_ALL")});this._oSelectAllCheckBox.attachEvent("select",L1,this);}if(this._iSizeScreen<2||!this.getShowRowHeaders()){var i=this._oInfoToolbar.indexOfContent(this._oSelectAllCheckBox);if(this._iSizeScreen<2){if(i<this._oInfoToolbar.getContent().length-1){this._oInfoToolbar.addContent(this._oSelectAllCheckBox);}}else if(i<0||i>1){if(i>1){this._oInfoToolbar.removeContent(this._oSelectAllCheckBox);}this._oInfoToolbar.insertContent(this._oSelectAllCheckBox,1);}}else{this._oCalendarHeader.setAllCheckBox(this._oSelectAllCheckBox);}}}j1.prototype._setSelectionMode=function(){var i=this.getAggregation("table");var j=i.getMode();var Q1;if(this.getSingleSelection()){if(!this.getShowRowHeaders()&&this.getRows().length==1){Q1=Y.None;}else{Q1=Y.SingleSelectMaster;}}else{Q1=Y.MultiSelect;}if(j!=Q1){i.setMode(Q1);}};function P1(){return this._oTimesRow||this._oDatesRow||this._oMonthsRow||this._oWeeksRow||this._oOneMonthsRow;}return j1;});
