/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Renderer','sap/ui/core/Core','sap/ui/core/ValueStateSupport','sap/ui/core/IconPool','sap/m/library','sap/ui/Device','sap/ui/core/InvisibleText','sap/ui/core/library'],function(R,C,V,I,l,D,a,c){"use strict";var T=c.TextDirection;var b=c.ValueState;var S=l.SelectType;var d={apiVersion:2};d.CSS_CLASS="sapMSlt";d.render=function(r,s){var t=s.getTooltip_AsString(),e=s.getType(),A=s.getAutoAdjustWidth(),E=s.getEditable(),f=s.getEnabled(),g=s.getWidth(),w=g.indexOf("%")>-1,h=A||g==="auto"||w,i=d.CSS_CLASS;r.openStart("div",s);this.addClass(r,s);r.class(i);r.class(i+s.getType());if(!f){r.class(i+"Disabled");}else if(!E){r.class(i+"Readonly");}if(h&&(e===S.Default)){r.class(i+"MinWidth");}if(A){r.class(i+"AutoAdjustedWidth");}else{r.style("width",g);}if(s.getIcon()){r.class(i+"WithIcon");}if(f&&E&&D.system.desktop){r.class(i+"Hoverable");}r.class(i+"WithArrow");if(s.getValueState()!==b.None){this.addValueStateClasses(r,s);}r.style("max-width",s.getMaxWidth());if(t){r.attr("title",t);}else if(e===S.IconOnly){var o=I.getIconInfo(s.getIcon());if(o){r.attr("title",o.text);}}r.openEnd();this.renderHiddenSelect(r,s);this.renderLabel(r,s);switch(e){case S.Default:this.renderArrow(r,s);break;case S.IconOnly:this.renderIcon(r,s);break;}var L=s.getList();if(s._isShadowListRequired()&&L){this.renderShadowList(r,L);}this.renderAccessibilityDomNodes(r,s);r.close("div");};d.renderHiddenSelect=function(r,s){var L=s.getList(),e,i;r.openStart("select",s.getId()+"-hiddenSelect");this.writeAccessibilityState(r,s);if(s.getRequired()){r.attr("required","required");}if(!s.getEnabled()){r.attr("disabled","disabled");}r.attr("name",s.getName());r.attr("value",s.getSelectedKey());r.class("sapUiPseudoInvisibleText");r.class(d.CSS_CLASS+"HiddenSelect");r.openEnd();for(i=0,e=L.getItems();i<e.length;i++){r.openStart("option");r.attr("value",e[i].getText());r.openEnd();r.text(e[i].getText());r.close("option");}r.close('select');};d.renderLabel=function(r,s){var o=s.getSelectedItem(),t=s.getTextDirection(),e=R.getTextAlign(s.getTextAlign(),t),f=d.CSS_CLASS;r.openStart("span",s.getId()+"-label");r.attr("aria-hidden",true);r.class(f+"Label");if(s.getValueState()!==b.None){r.class(f+"LabelState");r.class(f+"Label"+s.getValueState());}if(s.getType()===S.IconOnly){r.class("sapUiPseudoInvisibleText");}if(t!==T.Inherit){r.attr("dir",t.toLowerCase());}r.style("text-align",e);r.openEnd();if(s.getType()!==S.IconOnly){r.renderControl(s._getValueIcon());r.openStart("span",s.getId()+"-labelText");r.class("sapMSelectListItemText");r.openEnd();r.text(o&&o.getParent()?o.getText():null);r.close("span");}r.close("span");};d.renderArrow=function(r,s){var e=d.CSS_CLASS;r.openStart("span",s.getId()+"-arrow");r.attr("aria-hidden",true);r.class(e+"Arrow");if(s.getValueState()!==b.None){r.class(e+"ArrowState");}r.openEnd().close("span");};d.renderIcon=function(r,s){var t=s.getTooltip_AsString();r.icon(s.getIcon(),d.CSS_CLASS+"Icon",{id:s.getId()+"-icon",title:t||null});};d.renderShadowList=function(r,L){var o=L.getRenderer();o.writeOpenListTag(r,L,{elementData:false});this.renderShadowItems(r,L);o.writeCloseListTag(r,L);};d.renderShadowItems=function(r,L){var o=L.getRenderer(),s=L.getItems().length,e=L.getSelectedItem();for(var i=0,f=L.getItems();i<f.length;i++){o.renderItem(r,L,f[i],{selected:e===f[i],setsize:s,posinset:i+1,elementData:false});}};d.addClass=function(r,s){};d.addValueStateClasses=function(r,s){r.class(d.CSS_CLASS+"State");r.class(d.CSS_CLASS+s.getValueState());};d.getAriaRole=function(s){switch(s.getType()){case S.Default:return"listbox";case S.IconOnly:return"button";}};d._getValueStateString=function(s){var e="sap.ui.core";switch(s.getValueState()){case b.Success:return a.getStaticId(e,"VALUE_STATE_SUCCESS");case b.Warning:return a.getStaticId(e,"VALUE_STATE_WARNING");case b.Information:return a.getStaticId(e,"VALUE_STATE_INFORMATION");}return"";};d.writeAccessibilityState=function(r,s){var v=this._getValueStateString(s),o=s.getSelectedItem(),i=s.getType()===S.IconOnly,e=s._getValueIcon(),L=[],A=[],f,g,h,j;s.getLabels().forEach(function(m){if(m&&m.getId){L.push(m.getId());}});if(s.isOpen()&&o&&o.getDomRef()){h=o.getId();}if(o&&!o.getText()&&o.getIcon&&o.getIcon()){var k=I.getIconInfo(o.getIcon());if(k){j=k.text||k.name;}}if(j&&e){v=e.getId();}if(v){A.push(v);g=s.getValueStateMessageId()+"-sr";}if(L.length){A=A.concat(L);}f={value:A.join(" "),append:true};r.accessibilityState(null,{role:this.getAriaRole(s),roledescription:s._sAriaRoleDescription,readonly:i?undefined:s.getEnabled()&&!s.getEditable(),expanded:s.isOpen(),invalid:(s.getValueState()===b.Error)?true:undefined,labelledby:(i||f.value==="")?undefined:f,describedby:g,activedescendant:h,haspopup:"listbox"});};d.renderAccessibilityDomNodes=function(r,o){var v=o.getValueState();if(v===b.None){return;}var s=C.getLibraryResourceBundle("sap.m").getText("INPUTBASE_VALUE_STATE_"+v.toUpperCase());r.openStart("div",o.getValueStateMessageId()+"-sr").class("sapUiPseudoInvisibleText").attr("aria-live","assertive").attr("aria-atomic","true").openEnd().text(s+" ").text(o.getValueStateText()||V.getAdditionalText(o)).close("div");};return d;},true);
