/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/library","sap/ui/core/IconPool","sap/ui/core/theming/Parameters","sap/ui/Device","./library","./ListItemBase","./Image","./StandardListItemRenderer"],function(c,I,T,D,l,L,a,S){"use strict";var b=c.TextDirection;var V=c.ValueState;var d=L.extend("sap.m.StandardListItem",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Misc",defaultValue:null},description:{type:"string",group:"Misc",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconInset:{type:"boolean",group:"Appearance",defaultValue:true},iconDensityAware:{type:"boolean",group:"Misc",defaultValue:true},activeIcon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},info:{type:"string",group:"Misc",defaultValue:null},infoState:{type:"sap.ui.core.ValueState",group:"Misc",defaultValue:V.None},adaptTitleSize:{type:"boolean",group:"Appearance",defaultValue:true},titleTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:b.Inherit},infoTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:b.Inherit},wrapping:{type:"boolean",group:"Behavior",defaultValue:false},infoStateInverted:{type:"boolean",group:"Appearance",defaultValue:false}},designtime:"sap/m/designtime/StandardListItem.designtime"}});d.prototype.exit=function(){if(this._oImage){this._oImage.destroy("KeepDom");}L.prototype.exit.apply(this,arguments);};d.prototype.setIcon=function(i){var o=this.getIcon();this.setProperty("icon",i);if(this._oImage&&(!i||I.isIconURI(i)!=I.isIconURI(o))){this._oImage.destroy("KeepDom");this._oImage=undefined;}return this;};d.prototype._getImage=function(){var i=this._oImage;if(i){i.setSrc(this.getIcon());if(i.setDensityAware){i.setDensityAware(this.getIconDensityAware());}}else{i=I.createControlByURI({id:this.getId()+"-img",src:this.getIcon(),densityAware:this.getIconDensityAware(),useIconTooltip:false},a).setParent(this,null,true);}var s=this.getIconInset()?"sapMSLIImg":"sapMSLIImgNoInset";i.addStyleClass(i instanceof a?s:s+"Icon",true);this._oImage=i;return this._oImage;};d.prototype._activeHandlingInheritor=function(){if(this._oImage){var A=this.getActiveIcon();A&&this._oImage.setSrc(A);}};d.prototype._inactiveHandlingInheritor=function(){if(this._oImage){this._oImage.setSrc(this.getIcon());}};d.prototype.getContentAnnouncement=function(B){var i=this.getInfoState(),t=this.getTitle(),s,e=this.getDescription(),f,o,g,O=[],h=this.getInfo();if(this.getWrapping()){o=this.getDomRef("titleButton");g=this.getDomRef("descriptionButton");t=this._bTitleTextExpanded?t:this._getCollapsedText(t);e=this._bDescriptionTextExpanded?e:this._getCollapsedText(e);O.push(t);if(o){s=o.textContent+" "+B.getText("ACC_CTR_TYPE_BUTTON");s&&O.push(s);}O.push(e);if(g){f=g.textContent+" . "+B.getText("ACC_CTR_TYPE_BUTTON");f&&O.push(f);}}else{t&&O.push(t);e&&O.push(e);}h&&O.push(h);if(i!="None"&&i!=this.getHighlight()){O.push(B.getText("LIST_ITEM_STATE_"+i.toUpperCase()));}return O.join(" . ").trim();};d.prototype._measureInfoTextWidth=function(t){if(!d._themeInfo){d._themeInfo={};}if(!d._themeInfo.sFontFamily||t){d._themeInfo.sFontFamily=T.get("sapUiFontFamily");}if(!d._themeInfo.sFontStyleInfoStateInverted||t){d._themeInfo.sFontStyleInfoStateInverted="bold "+parseFloat(T.get("sapMFontSmallSize"))*16+"px"+" "+d._themeInfo.sFontFamily;}if(!d._themeInfo.sFontStyle||t){d._themeInfo.sFontStyle=parseFloat(T.get("sapMFontMediumSize"))*16+"px"+" "+d._themeInfo.sFontFamily;}if(!d._themeInfo.iBaseFontSize||t){d._themeInfo.iBaseFontSize=parseInt(l.BaseFontSize)||16;}if(!d._oCanvas){d._oCanvas=document.createElement("canvas");d._oCtx=d._oCanvas.getContext("2d");}if(this.getInfoStateInverted()){d._oCtx.font=d._themeInfo.sFontStyleInfoStateInverted||"";}else{d._oCtx.font=d._themeInfo.sFontStyle||"";}return Math.ceil(d._oCtx.measureText(this.getInfo()).width)/d._themeInfo.iBaseFontSize;};d.prototype._getInfoTextMinWidth=function(w){if(this.getInfoStateInverted()&&w<=7.5){return w+0.625+"rem";}if(w<=7.5){return w+"rem";}return"7.5rem";};d.prototype.ontap=function(e){this._checkExpandCollapse(e);if(!e.isMarked()){return L.prototype.ontap.apply(this,arguments);}};d.prototype.onsapspace=function(e){this._checkExpandCollapse(e,true);if(!e.isMarked()){return L.prototype.onsapspace.apply(this,arguments);}};d.prototype._checkExpandCollapse=function(e,p){var t=e.target,i=t&&t.id;if(i&&i===this.getId()+"-titleButton"){if(p){e.preventDefault();}e.setMarked();return this._toggleExpandCollapse("title",this._bTitleTextExpanded);}if(i&&i===this.getId()+"-descriptionButton"){if(p){e.preventDefault();}e.setMarked();return this._toggleExpandCollapse("description",this._bDescriptionTextExpanded);}};d.prototype._toggleExpandCollapse=function(w,t){var o=this.getDomRef(w+"Text"),e=this.getDomRef(w+"ThreeDots"),B=this.getDomRef(w+"Button"),s=w==="title"?this.getTitle():this.getDescription(),r=sap.ui.getCore().getLibraryResourceBundle("sap.m");if(!t){o.textContent=s;e.textContent=" ";B.textContent=r.getText("TEXT_SHOW_LESS");t=true;}else{o.textContent=this._getCollapsedText(s);e.textContent=" ... ";B.textContent=r.getText("TEXT_SHOW_MORE");t=false;}if(w==="title"){this._bTitleTextExpanded=t;}else{this._bDescriptionTextExpanded=t;}};d.prototype._getCollapsedText=function(t){var m=D.system.phone?100:300;return t.substr(0,m);};d.prototype.onThemeChanged=function(e){L.prototype.onThemeChanged.apply(this,arguments);var t=e.theme;if(!this._initialRender){this._initialRender=true;if(!d._themeInfo){d._themeInfo={};}if(!d._themeInfo.sCurrentTheme){d._themeInfo.sCurrentTheme=t;}return;}var i=this.getDomRef("info");if(i){var w;if(d._themeInfo.sCurrentTheme!==t){d._themeInfo.sCurrentTheme=t;w=this._measureInfoTextWidth(true);}else{w=this._measureInfoTextWidth();}i.style.minWidth=this._getInfoTextMinWidth(w);}};return d;});
