/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/core/Control","sap/ui/core/InvisibleText","./WizardStepRenderer","./Button","./TitlePropagationSupport","sap/base/Log"],function(l,C,I,W,B,T,L){"use strict";var a=C.extend("sap.m.WizardStep",{metadata:{properties:{title:{type:"string",group:"appearance",defaultValue:""},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:""},validated:{type:"boolean",group:"Behavior",defaultValue:true},optional:{type:"boolean",group:"Appearance",defaultValue:false}},events:{complete:{parameters:{}},activate:{parameters:{}}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},_nextButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},associations:{subsequentSteps:{type:"sap.m.WizardStep",multiple:true,singularName:"subsequentStep"},nextStep:{type:"sap.m.WizardStep",multiple:false}}}});var b=l.ButtonType;T.call(a.prototype,"content",function(){return this.getId()+"-title";});a.prototype.init=function(){this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._oNumberInvisibleText=new I({id:this.getId()+"-NumberedTitle"}).toStatic();this._createNextButton();this._initTitlePropagationSupport();};a.prototype._createNextButton=function(){this._oNextButton=new B(this.getId()+"-nextButton",{text:this._oResourceBundle.getText("WIZARD_STEP")+2,type:b.Emphasized,press:this._complete.bind(this)}).addStyleClass("sapMWizardNextButtonVisible");this.setAggregation("_nextButton",this._oNextButton);};a.prototype.setWizardContext=function(s){["bLast","bReviewStep","sButtonText","bParentAllowsButtonShow"].forEach(function(p){if(typeof s[p]!=="undefined"){this[p]=s[p];}}.bind(this));this._oNextButton.setText(this.sButtonText);this.setLast(this.bLast);this.setButtonVisibility();};a.prototype._getNumberInvisibleText=function(){return this._oNumberInvisibleText;};a.prototype._setNumberInvisibleText=function(n){return this._oNumberInvisibleText.setText(this._oResourceBundle.getText("WIZARD_STEP")+n+" "+this.getTitle());};a.prototype.setValidated=function(v){this.setProperty("validated",v,true);this.setButtonVisibility();return this;};a.prototype.setNextStep=function(v){this.setAssociation("nextStep",v,true);var p=this._getWizardParent();if(p!==null){p._checkCircularReference(this._getNextStepReference());p._updateProgressNavigator();}return this;};a.prototype.setVisible=function(v){this.setProperty("visible",v,true);L.warning("Don't use the set visible method for wizard steps. If you need to show/hide steps based on some condition - use the branching property of the Wizard instead.");return this;};a.prototype._isLeaf=function(){if(this.getNextStep()===null&&this.getSubsequentSteps().length===0){return true;}return false;};a.prototype._isBranched=function(){return this.getSubsequentSteps().length>1;};a.prototype._getNextStepReference=function(){if(this.getNextStep()!==null){return sap.ui.getCore().byId(this.getNextStep());}if(this.getSubsequentSteps().length===1){return sap.ui.getCore().byId(this.getSubsequentSteps()[0]);}return null;};a.prototype._containsSubsequentStep=function(s){return this.getSubsequentSteps().some(function(S){return S===s;});};a.prototype._getWizardParent=function(){var p=this.getParent();while(!(p instanceof sap.m.Wizard)){if(p===null){return null;}p=p.getParent();}return p;};a.prototype.setLast=function(c){this.bLast=c;this.toggleStyleClass("sapMWizardLastActivatedStep",c);this.setButtonVisibility();};a.prototype.setButtonVisibility=function(){var s=this.getValidated()&&this.bParentAllowsButtonShow&&this.bLast;if(typeof s==='undefined'){return;}this.displayButton(s);};a.prototype.displayButton=function(s){this._oNextButton.toggleStyleClass("sapMWizardNextButtonHidden",!s);this._oNextButton.toggleStyleClass("sapMWizardNextButtonVisible",s);this._oNextButton.setVisible(s);};a.prototype._activate=function(){this.setLast(true);this.addStyleClass("sapMWizardStepActivated");this.fireActivate();};a.prototype._deactivate=function(){this.removeStyleClass("sapMWizardStepActivated");};a.prototype._complete=function(){var w=this._getWizardParent();this.setLast(this.bReviewStep||false);this.fireComplete();if(w!==null){w._handleNextButtonPress();}};a.prototype.exit=function(){this._oNumberInvisibleText.destroy();this._oNumberInvisibleText=null;};return a;});
