//@ui5-bundle sap/m/library-preload.js
/*
 * ! OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/m/ColumnHeaderPopover',['sap/ui/core/Control','sap/m/Toolbar','sap/m/Button','sap/m/ResponsivePopover','sap/m/ToolbarSpacer','sap/ui/dom/containsOrEquals'],function(C,T,B,R,a,c){"use strict";
var b=C.extend("sap.m.ColumnHeaderPopover",{
library:"sap.m",
metadata:{properties:{},aggregations:{items:{type:"sap.m.ColumnPopoverItem",multiple:true,singularName:"item",bindable:true},_popover:{type:"sap.m.ResponsivePopover",multiple:false,visibility:"hidden"}},defaultAggregation:"items",associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}}},
renderer:null
});
b.prototype.init=function(){this._bPopoverCreated=false;this._oShownCustomContent=null;var t=this;this._minWidthDelegate=function(){this.$().css("min-width",t.minWidth);};};
b.prototype.exit=function(){if(this._oToolbar){this._oToolbar.destroy();this._oToolbar=null;}this._closeBtn=null;this._spacer=null;this._aButtons=null;this._oShownCustomContent=null;};
b.prototype._createPopover=function(){var t=this;this._oShownCustomContent=null;var o=sap.ui.getCore().getLibraryResourceBundle("sap.m"),s=o.getText("COLUMNHEADERPOPOVER_CLOSE_BUTTON");var p=new R(this.getId()+"-popover",{showArrow:false,showHeader:false,placement:"Bottom",verticalScrolling:true,horizontalScrolling:false,ariaLabelledBy:this.getAriaLabelledBy(),beforeClose:function(e){if(t._oShownCustomContent){t._oShownCustomContent.setVisible(false);t._oShownCustomContent=null;}t._cleanSelection();}});p._oControl.addDelegate({"onAfterRendering":this._minWidthDelegate},p._oControl);this.setAggregation("_popover",p);var d=new T(this.getId()+"-tb");this._spacer=new a();this._closeBtn=new B(d.getId()+"-closeBtn",{type:"Transparent",icon:"sap-icon://decline",tooltip:s,press:[p.close,p]});d.addContent(this._spacer);d.addContent(this._closeBtn);p.addContent(d);this._oToolbar=d;};
b.prototype._cleanSelection=function(o){var d=this._aButtons;if(d){d.forEach(function(e){if((!o||e!==o)&&e.getPressed&&e.getPressed()){e.setPressed(false);}});}};
b.prototype.openBy=function(o){if(!this._bPopoverCreated){this._createPopover();this._bPopoverCreated=true;}else{this._oToolbar.removeContent(this._spacer);this._oToolbar.removeContent(this._closeBtn);this._oToolbar.destroyContent();}var p=this.getAggregation("_popover");var d=[];var I=this.getItems();var m=5;for(var i=0;(i<I.length)&&(d.length<m);i++){var e=I[i];if(e.getVisible()){var f=e._createButton(this._oToolbar.getId()+"-btn_"+i,this);f._sContentId=e._sContentId;d.push(f);this._oToolbar.insertContent(f,i);}}if(d.length===0){return;}this._aButtons=d;this._oToolbar.addContent(this._spacer);this._oToolbar.addContent(this._closeBtn);if(!this._bAppendedToUIArea&&!this.getParent()){var s=sap.ui.getCore().getStaticAreaRef();s=sap.ui.getCore().getUIArea(s);s.addContent(this,true);this._bAppendedToUIArea=true;}var O=o.getFocusDomRef();if(O){p.setOffsetY(-O.clientHeight);this.minWidth=O.clientWidth;}p.openBy(o);};
b.prototype.invalidate=function(o){var p=this.getAggregation("_popover");if(o===p){C.prototype.invalidate.apply(this,arguments);}return this;};
b.prototype.addAriaLabelledBy=function(i){var r=this.getAggregation("_popover");if(r){r.addAriaLabelledBy(i);}return this.addAssociation("ariaLabelledBy",i);};
b.prototype.removeAriaLabelledBy=function(o){var r=this.getAggregation("_popover");if(r){r.removeAriaLabelledBy(o);}return this.removeAssociation("ariaLabelledBy",o);};
b.prototype.removeAllAssociation=function(A,s){if(A==="ariaLabelledBy"){var r=this.getAggregation("_popover");if(r){r.removeAllAssociation(A,s);}}return C.prototype.removeAllAssociation.apply(this,arguments);};
return b;});
sap.ui.predefine('sap/m/ColumnPopoverActionItem',['./ColumnPopoverItem','sap/m/Button'],function(C,B){"use strict";
var a=C.extend("sap.m.ColumnPopoverActionItem",{
library:"sap.m",
metadata:{properties:{icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},text:{type:"string",group:"Misc",defaultValue:null}},events:{press:{}}}
});
a.prototype._createButton=function(i,c){return new B(i,{icon:this.getIcon(),type:"Transparent",tooltip:this.getText(),visible:this.getVisible(),press:[function(e){if(c._oShownCustomContent){c._oShownCustomContent.setVisible(false);c._oShownCustomContent=null;c._cleanSelection(this);}var p=c.getAggregation("_popover");p.close();this.firePress();},this]});};
return a;});
sap.ui.predefine('sap/m/ColumnPopoverCustomItem',['./ColumnPopoverItem','sap/m/ToggleButton'],function(C,T){"use strict";
var a=C.extend("sap.m.ColumnPopoverCustomItem",{
library:"sap.m",
metadata:{properties:{icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},text:{type:"string",group:"Misc",defaultValue:null}},aggregations:{content:{type:"sap.ui.core.Control",multiple:false,singularName:"content"}},events:{beforeShowContent:{}}}
});
a.prototype._createButton=function(i,c){var p=c.getAggregation("_popover");var o=this.getContent();if(o){o.setVisible(false);this._sContentId=o.sId;}p.addContent(o);var t=this;return new T(i,{icon:this.getIcon(),type:"Transparent",tooltip:this.getText(),visible:this.getVisible(),press:function(){if(c._oShownCustomContent){c._oShownCustomContent.setVisible(false);}if(this.getPressed()){c._cleanSelection(this);t.fireBeforeShowContent();if(o){o.setVisible(true);c._oShownCustomContent=o;}}else if(o){o.setVisible(false);c._oShownCustomContent=null;}}});};
return a;});
sap.ui.predefine('sap/m/ColumnPopoverItem',['sap/ui/core/Element'],function(E){"use strict";
var C=E.extend("sap.m.ColumnPopoverItem",{metadata:{library:"sap.m",properties:{visible:{type:"boolean",group:"Misc",defaultValue:true}}}});
C.prototype._createButton=function(){throw new Error('Abstract function _create Button must be implemented in your Item (that extends this abstract object).');};
return C;});
sap.ui.predefine('sap/m/ColumnPopoverSortItem',['sap/ui/core/Core','./ColumnPopoverItem','sap/m/ToggleButton','sap/m/Button','sap/m/StandardListItem','sap/m/List'],function(C,a,T,B,S,L){"use strict";
var b=a.extend("sap.m.ColumnPopoverSortItem",{
library:"sap.m",
metadata:{properties:{label:{type:"string",group:"Misc",defaultValue:null}},events:{sort:{parameters:{property:{type:"string"}}}},aggregations:{items:{type:"sap.ui.core.Item",multiple:true,singularName:"item",bindable:true}}}
});
b.prototype._createButton=function(I,c){var o=C.getLibraryResourceBundle("sap.m"),s=o.getText("COLUMNHEADERPOPOVER_SORT_BUTTON"),d=this.getItems(),t=this;if(d.length>1){var p=c.getAggregation("_popover");var l=new L();for(var i=0;i<d.length;i++){var e=new S({title:d[i].getText(),type:"Active"});l.addItem(e);e.data("key",d[i].getKey());}l.attachEvent("itemPress",function(E){p.close();var e=E.getParameter("listItem");t.fireSort({property:e.data("key")});});l.setVisible(false);p.addContent(l);return new T(I,{icon:"sap-icon://sort",type:"Transparent",tooltip:s,visible:this.getVisible(),press:function(){if(c._oShownCustomContent){c._oShownCustomContent.setVisible(false);}if(this.getPressed()){c._cleanSelection(this);if(l){l.setVisible(true);c._oShownCustomContent=l;}}else if(l){l.setVisible(false);c._oShownCustomContent=null;}}});}else{return new B(I,{icon:"sap-icon://sort",type:"Transparent",tooltip:s,visible:this.getVisible(),press:function(){var p=c.getAggregation("_popover");if(c._oShownCustomContent){c._oShownCustomContent.setVisible(false);c._oShownCustomContent=null;c._cleanSelection(this);}p.close();t.fireSort({property:d[0]?d[0].getKey():null});}});}};
return b;});
sap.ui.predefine('sap/m/CustomTreeItem',['./TreeItemBase','./ListItemBase','./library',"./CustomTreeItemRenderer"],function(T,L,l,C){"use strict";
var a=T.extend("sap.m.CustomTreeItem",{metadata:{library:"sap.m",defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",bindable:"bindable"}}}});
a.prototype.getContentAnnouncement=function(){return this.getContent().map(function(c){return L.getAccessibilityText(c);}).join(" ").trim();};
return a;});
sap.ui.predefine('sap/m/CustomTreeItemRenderer',['./TreeItemBaseRenderer','sap/ui/core/Renderer'],function(T,R){"use strict";var C=R.extend(T);C.apiVersion=2;
C.renderLIAttributes=function(r,l){r.class("sapMCTI");T.renderLIAttributes.apply(this,arguments);};
C.renderLIContent=function(r,l){l.getContent().forEach(function(c){r.renderControl(c);});};
return C;},true);
sap.ui.predefine('sap/m/P13nAnyFilterItem',['./library','sap/m/P13nFilterItem'],function(l,P){"use strict";
var a=P.extend("sap.m.P13nAnyFilterItem",{metadata:{library:"sap.m",properties:{value1:{type:"any",group:"Misc",defaultValue:null},value2:{type:"any",group:"Misc",defaultValue:null}}}});
return a;});
sap.ui.predefine('sap/m/P13nColumnsItem',['./library','sap/ui/core/Item'],function(l,I){"use strict";
var P=I.extend("sap.m.P13nColumnsItem",{metadata:{library:"sap.m",properties:{columnKey:{type:"string",group:"Misc"},index:{type:"int",group:"Appearance"},visible:{type:"boolean",group:"Appearance"},width:{type:"string",group:"Misc"},total:{type:"boolean"}}}});
return P;});
sap.ui.predefine('sap/m/P13nColumnsPanel',['sap/ui/core/library','sap/ui/model/ChangeReason','sap/ui/model/json/JSONModel','sap/ui/model/BindingMode','sap/ui/core/ResizeHandler','sap/ui/core/IconPool','./library','./Table','./Column','./ColumnListItem','./P13nPanel','./P13nColumnsItem','./SearchField','./ScrollContainer','./Text','./Button','./OverflowToolbar','./OverflowToolbarLayoutData','./OverflowToolbarButton','./ToolbarSpacer',"sap/ui/thirdparty/jquery"],function(C,c,J,B,R,I,l,T,d,e,P,f,S,g,h,i,O,j,k,m,q){"use strict";var n=l.OverflowToolbarPriority;var o=l.ButtonType;var p=l.ToolbarDesign;var L=l.ListType;var r=l.ListMode;var s=l.P13nPanelType;
var t=P.extend("sap.m.P13nColumnsPanel",{
metadata:{library:"sap.m",properties:{visibleItemsThreshold:{type:"int",group:"Behavior",defaultValue:-1}},aggregations:{columnsItems:{type:"sap.m.P13nColumnsItem",multiple:true,singularName:"columnsItem",bindable:"bindable"},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"}},events:{addColumnsItem:{parameters:{newItem:{type:"sap.m.P13nColumnsItem"}}},changeColumnsItems:{parameters:{newItems:{type:"sap.m.P13nColumnsItem[]"},existingItems:{type:"sap.m.P13nColumnsItem[]"},items:{type:"object[]"}}},setData:{}}},
renderer:{apiVersion:2,render:function(a,b){a.openStart("div",b);a.class("sapMP13nColumnsPanel");a.openEnd();b.getAggregation("content").forEach(function(u){a.renderControl(u);});a.close("div");}}
});
t.prototype.init=function(){this._iLiveChangeTimer=0;this._iSearchTimer=0;this._bIgnoreUpdateInternalModel=false;this._bUpdateInternalModel=true;this._bTableItemsChanged=false;this._bOnAfterRenderingFirstTimeExecuted=false;var M=new J({items:[],columnKeyOfMarkedItem:undefined,isMoveDownButtonEnabled:undefined,isMoveUpButtonEnabled:undefined,showOnlySelectedItems:undefined,countOfSelectedItems:0,countOfItems:0});M.setDefaultBindingMode(B.TwoWay);M.setSizeLimit(1000);this.setModel(M,"$sapmP13nColumnsPanel");this.setType(s.columns);this.setTitle(sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("COLUMSPANEL_TITLE"));this._createTable();this._createToolbar();this.setVerticalScrolling(false);var a=new g({horizontal:false,vertical:true,content:[this._oTable],width:'100%',height:'100%'});this.addAggregation("content",a);var b=this;this._fnHandleResize=function(){var u=false,v,w;if(b.getParent){var $=null,x,H;var y=b.getParent();var z=b._getToolbar();if(y&&y.$){$=y.$("cont");if($.children().length>0&&z.$().length>0){v=a.$()[0].clientHeight;x=$.children()[0].clientHeight;H=z?z.$()[0].clientHeight:0;w=x-H;if(v!==w){a.setHeight(w+'px');u=true;}}}}return u;};this._sContainerResizeListener=R.register(a,this._fnHandleResize);};
t.prototype.reInitialize=function(){};
t.prototype.onBeforeRendering=function(){this._updateInternalModel();if(!this._getInternalModel().getProperty("/columnKeyOfMarkedItem")){this._setColumnKeyOfMarkedItem(this._getColumnKeyByTableItem(this._getVisibleTableItems()[0]));}this._switchMarkedTableItemTo(this._getTableItemByColumnKey(this._getInternalModel().getProperty("/columnKeyOfMarkedItem")));this._updateControlLogic();};
t.prototype.onAfterRendering=function(){if(!this._bOnAfterRenderingFirstTimeExecuted){this._bOnAfterRenderingFirstTimeExecuted=true;window.clearTimeout(this._iLiveChangeTimer);var a=this;this._iLiveChangeTimer=window.setTimeout(function(){a._fnHandleResize();},0);}};
t.prototype.getOkPayload=function(){this._updateInternalModel();var M=this._getInternalModel().getProperty("/items");return{tableItems:M.map(function(a){return{columnKey:a.columnKey,index:a.persistentIndex===-1?undefined:a.persistentIndex,visible:a.persistentSelected,width:a.width};}),tableItemsChanged:this._bTableItemsChanged,selectedItems:M.filter(function(a){return a.persistentSelected;}).map(function(a){return{columnKey:a.columnKey};})};};
t.prototype.getResetPayload=function(){return{oPanel:this};};
t.prototype.exit=function(){R.deregister(this._sContainerResizeListener);this._sContainerResizeListener=null;this._getToolbar().destroy();this._oTable.destroy();this._oTable=null;if(this._getInternalModel()){this._getInternalModel().destroy();}window.clearTimeout(this._iLiveChangeTimer);window.clearTimeout(this._iSearchTimer);};
t.prototype.addItem=function(a){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.addAggregation("items",a);return this;};
t.prototype.insertItem=function(a,b){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.insertAggregation("items",a,b);return this;};
t.prototype.removeItem=function(a){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}a=this.removeAggregation("items",a);return a;};
t.prototype.removeAllItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAllAggregation("items");};
t.prototype.destroyItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.destroyAggregation("items");return this;};
t.prototype.addColumnsItem=function(a){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.addAggregation("columnsItems",a);return this;};
t.prototype.insertColumnsItem=function(a,b){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.insertAggregation("columnsItems",a,b);return this;};
t.prototype.updateColumnsItems=function(a){this.updateAggregation("columnsItems");if(a===c.Change&&!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}};
t.prototype.removeColumnsItem=function(a){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAggregation("columnsItems",a);};
t.prototype.removeAllColumnsItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAllAggregation("columnsItems");};
t.prototype.destroyColumnsItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.destroyAggregation("columnsItems");return this;};
t.prototype.onBeforeNavigationFrom=function(){var M=this._getSelectedModelItems();var v=this.getVisibleItemsThreshold();return!(M&&v!==-1&&M.length>v);};
t.prototype._notifyChange=function(){this._bTableItemsChanged=true;var a=this.getChangeNotifier();if(a){a(this);}};
t.prototype._scrollToSelectedItem=function(a){if(!a){return;}sap.ui.getCore().applyChanges();};
t.prototype._getInternalModel=function(){return this.getModel("$sapmP13nColumnsPanel");};
t.prototype._createTable=function(){this._oTable=new T({mode:r.MultiSelect,rememberSelections:false,itemPress:q.proxy(this._onItemPressed,this),selectionChange:q.proxy(this._onSelectionChange,this),columns:[new d({vAlign:C.VerticalAlign.Middle,header:new h({text:{parts:[{path:'/countOfSelectedItems'},{path:'/countOfItems'}],formatter:function(a,b){return sap.ui.getCore().getLibraryResourceBundle("sap.m").getText('COLUMNSPANEL_SELECT_ALL_WITH_COUNTER',[a,b]);}}})})],items:{path:"/items",templateShareable:false,template:new e({cells:[new h({text:"{text}"})],visible:"{visible}",selected:"{persistentSelected}",tooltip:"{tooltip}",type:L.Active})}});this._oTable.setModel(this._getInternalModel());};
t.prototype._createToolbar=function(){var a=this;var b=sap.ui.getCore().getLibraryResourceBundle("sap.m");var u=new O(this.getId()+"-toolbar",{design:p.Auto,content:[new m(),new S(this.getId()+"-searchField",{liveChange:function(E){var v=E.getSource().getValue(),D=(v?300:0);window.clearTimeout(a._iSearchTimer);if(D){a._iSearchTimer=window.setTimeout(function(){a._onExecuteSearch();},D);}else{a._onExecuteSearch();}},search:q.proxy(this._onExecuteSearch,this),layoutData:new j({minWidth:"12.5rem",maxWidth:"23.077rem",shrinkable:true,moveToOverflow:false,stayInOverflow:false})}),new i(this.getId()+"-showSelected",{text:{path:'/showOnlySelectedItems',formatter:function(v){return v?b.getText('COLUMNSPANEL_SHOW_ALL'):b.getText('COLUMNSPANEL_SHOW_SELECTED');}},tooltip:{path:'/showOnlySelectedItems',formatter:function(v){return v?b.getText('COLUMNSPANEL_SHOW_ALL'):b.getText('COLUMNSPANEL_SHOW_SELECTED');}},type:o.Transparent,press:q.proxy(this._onSwitchButtonShowSelected,this),layoutData:new j({moveToOverflow:true,priority:n.High})}),new k({icon:I.getIconURI("collapse-group"),text:b.getText('COLUMNSPANEL_MOVE_TO_TOP'),tooltip:b.getText('COLUMNSPANEL_MOVE_TO_TOP'),type:o.Transparent,enabled:{path:'/isMoveUpButtonEnabled'},press:q.proxy(this.onPressButtonMoveToTop,this),layoutData:new j({moveToOverflow:true,priority:n.Low,group:2})}),new k({icon:I.getIconURI("slim-arrow-up"),text:b.getText('COLUMNSPANEL_MOVE_UP'),tooltip:b.getText('COLUMNSPANEL_MOVE_UP'),type:o.Transparent,enabled:{path:'/isMoveUpButtonEnabled'},press:q.proxy(this.onPressButtonMoveUp,this),layoutData:new j({moveToOverflow:true,priority:n.High,group:1})}),new k({icon:I.getIconURI("slim-arrow-down"),text:b.getText('COLUMNSPANEL_MOVE_DOWN'),tooltip:b.getText('COLUMNSPANEL_MOVE_DOWN'),type:o.Transparent,enabled:{path:'/isMoveDownButtonEnabled'},press:q.proxy(this.onPressButtonMoveDown,this),layoutData:new j({moveToOverflow:true,priority:n.High,group:1})}),new k({icon:I.getIconURI("expand-group"),text:b.getText('COLUMNSPANEL_MOVE_TO_BOTTOM'),tooltip:b.getText('COLUMNSPANEL_MOVE_TO_BOTTOM'),type:o.Transparent,enabled:{path:'/isMoveDownButtonEnabled'},press:q.proxy(this.onPressButtonMoveToBottom,this),layoutData:new j({moveToOverflow:true,priority:n.Low,group:2})})]});u.setModel(this._getInternalModel());this.addAggregation("content",u);};
t.prototype.onPressButtonMoveToTop=function(){this._moveMarkedTableItem(this._getMarkedTableItem(),this._getVisibleTableItems()[0]);};
t.prototype.onPressButtonMoveUp=function(){var v=this._getVisibleTableItems();this._moveMarkedTableItem(this._getMarkedTableItem(),v[v.indexOf(this._getMarkedTableItem())-1]);};
t.prototype.onPressButtonMoveDown=function(){var v=this._getVisibleTableItems();this._moveMarkedTableItem(this._getMarkedTableItem(),v[v.indexOf(this._getMarkedTableItem())+1]);};
t.prototype.onPressButtonMoveToBottom=function(){var v=this._getVisibleTableItems();this._moveMarkedTableItem(this._getMarkedTableItem(),v[v.length-1]);};
t.prototype._onSwitchButtonShowSelected=function(){this._getInternalModel().setProperty("/showOnlySelectedItems",!this._getInternalModel().getProperty("/showOnlySelectedItems"));this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();this._scrollToSelectedItem(this._getMarkedTableItem());this._updateControlLogic();this._fnHandleResize();};
t.prototype._onExecuteSearch=function(){this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();this._updateControlLogic();};
t.prototype._switchVisibilityOfUnselectedModelItems=function(){var b=this._isFilteredByShowSelected();var M=this._getInternalModel().getProperty("/items");M.forEach(function(a){if(a.persistentSelected){a.visible=true;return;}a.visible=!b;});this._getInternalModel().setProperty("/items",M);};
t.prototype._getVisibleModelItems=function(){return this._getInternalModel().getProperty("/items").filter(function(M){return!!M.visible;});};
t.prototype._moveMarkedTableItem=function(a,b){var M=this._getModelItemByColumnKey(this._getColumnKeyByTableItem(a));var u=this._getModelItemByColumnKey(this._getColumnKeyByTableItem(b));var v=this._getModelItemIndexByColumnKey(M.columnKey);var w=this._getModelItemIndexByColumnKey(u.columnKey);this._moveModelItems(v,w);this._checkButtonFocus(w);this._scrollToSelectedItem(this._getMarkedTableItem());this._updateControlLogic();this._fireChangeColumnsItems();this._fireSetData();this._notifyChange();};
t.prototype._checkButtonFocus=function(a){var M=this._oTable.getItems().length-1;if(a===0||a===M){sap.ui.getCore().byId(this.getId()+"-showSelected").focus();}};
t.prototype._moveModelItems=function(a,b){var M=this._getInternalModel().getProperty("/items");if(a<0||b<0||a>M.length-1||b>M.length-1){return false;}this._removeStyleOfMarkedTableItem();var u=M.splice(a,1);M.splice(b,0,u[0]);this._updateModelItemsPersistentIndex(M);this._updateCounts(M);this._getInternalModel().setProperty("/items",M);this._switchMarkedTableItemTo(this._getMarkedTableItem());return true;};
t.prototype._getModelItemByColumnKey=function(a){var M=this._getInternalModel().getProperty("/items").filter(function(b){return b.columnKey===a;});return M[0];};
t.prototype._updateCounts=function(M){var a=0;var b=0;M.forEach(function(u){a++;if(u.persistentSelected){b++;}});this._getInternalModel().setProperty("/countOfItems",a);this._getInternalModel().setProperty("/countOfSelectedItems",b);};
t.prototype._sortModelItemsByPersistentIndex=function(M){var u;var v;try{v=sap.ui.getCore().getConfiguration().getLocale().toString();if(typeof window.Intl!=='undefined'){u=window.Intl.Collator(v,{numeric:true});}}catch(E){}M.forEach(function(a,b){a.localIndex=b;});M.sort(function(a,b){if(a.persistentSelected===true&&(b.persistentSelected===false||b.persistentSelected===undefined)){return-1;}else if((a.persistentSelected===false||a.persistentSelected===undefined)&&b.persistentSelected===true){return 1;}else if(a.persistentSelected===true&&b.persistentSelected===true){if(a.persistentIndex>-1&&a.persistentIndex<b.persistentIndex){return-1;}else if(b.persistentIndex>-1&&a.persistentIndex>b.persistentIndex){return 1;}else{return a.localIndex-b.localIndex;}}else if((a.persistentSelected===false||a.persistentSelected===undefined)&&(b.persistentSelected===false||b.persistentSelected===undefined)){return u?u.compare(a.text,b.text):a.text.localeCompare(b.text,v,{numeric:true});}});M.forEach(function(a){delete a.localIndex;});};
t.prototype._getColumnKeyByTableItem=function(a){var b=this._oTable.indexOfItem(a);if(b<0){return null;}return this._oTable.getBinding("items").getContexts()[b].getObject().columnKey;};
t.prototype._getModelItemIndexByColumnKey=function(a){var b=-1;this._getInternalModel().getProperty("/items").some(function(M,u){if(M.columnKey===a){b=u;return true;}});return b;};
t.prototype._getSelectedModelItems=function(){return this._getInternalModel().getProperty("/items").filter(function(M){return M.persistentSelected;});};
t.prototype._getVisibleTableItems=function(){return this._oTable.getItems().filter(function(a){return a.getVisible();});};
t.prototype._getTableItemByColumnKey=function(a){var b=this._oTable.getBinding("items").getContexts();var u=this._oTable.getItems().filter(function(v,w){return b[w].getObject().columnKey===a;});return u[0];};
t.prototype._getToolbar=function(){return sap.ui.getCore().byId(this.getId()+"-toolbar")||null;};
t.prototype._getSearchField=function(){return sap.ui.getCore().byId(this.getId()+"-searchField")||null;};
t.prototype._getSearchText=function(){var a=this._getSearchField();return a?a.getValue():"";};
t.prototype._isFilteredBySearchText=function(){return!!this._getSearchText().length;};
t.prototype._isFilteredByShowSelected=function(){return this._getInternalModel().getData().showOnlySelectedItems;};
t.prototype._updateControlLogic=function(){var b=this._isFilteredBySearchText();var a=this._isFilteredByShowSelected();var v=this._getVisibleTableItems();this._getInternalModel().setProperty("/isMoveUpButtonEnabled",v.indexOf(this._getMarkedTableItem())>0);this._getInternalModel().setProperty("/isMoveDownButtonEnabled",v.indexOf(this._getMarkedTableItem())>-1&&v.indexOf(this._getMarkedTableItem())<v.length-1);var u=sap.ui.getCore().byId(this._oTable.getId()+'-sa');if(u){u.setEnabled(!b&&!a);}};
t.prototype._updateModelItemsPersistentIndex=function(M){var a=-1;M.forEach(function(b){b.persistentIndex=-1;if(b.persistentSelected){a++;b.persistentIndex=a;}});};
t.prototype._fireSetData=function(){this._bIgnoreUpdateInternalModel=true;this.fireSetData();this._bIgnoreUpdateInternalModel=false;};
t.prototype._fireChangeColumnsItems=function(){this._bIgnoreUpdateInternalModel=true;var M=this._getInternalModel().getProperty("/items");var E={newItems:[],existingItems:[],items:M.map(function(a){return{columnKey:a.columnKey,visible:a.persistentSelected,index:a.persistentIndex===-1?undefined:a.persistentIndex,width:a.width,total:a.total};})};M.forEach(function(a){var b=this._getColumnsItemByColumnKey(a.columnKey);if(b){b.setVisible(a.persistentSelected);b.setIndex(a.persistentIndex===-1?undefined:a.persistentIndex);if(a.width!==undefined){b.setWidth(a.width);}if(a.total!==undefined){b.setTotal(a.total);}E.existingItems.push(b);}else{E.newItems.push(new f({columnKey:a.columnKey,visible:a.persistentSelected,index:a.persistentIndex===-1?undefined:a.persistentIndex,width:a.width,total:a.total}));}},this);this.fireChangeColumnsItems(E);this._bIgnoreUpdateInternalModel=false;};
t.prototype._getColumnsItemByColumnKey=function(a){var b=this.getColumnsItems().filter(function(u){return u.getColumnKey()===a;});return b[0];};
t.prototype._getMarkedTableItem=function(){return this._getTableItemByColumnKey(this._getInternalModel().getProperty("/columnKeyOfMarkedItem"));};
t.prototype._setColumnKeyOfMarkedItem=function(a){this._getInternalModel().setProperty("/columnKeyOfMarkedItem",a);};
t.prototype._onItemPressed=function(E){this._switchMarkedTableItemTo(E.getParameter('listItem'));this._updateControlLogic();};
t.prototype._onSelectionChange=function(E){if(!E.getParameter("selectAll")&&E.getParameter("listItems").length===1){this._switchMarkedTableItemTo(E.getParameter("listItem"));}this._selectTableItem();};
t.prototype._selectTableItem=function(){this._updateControlLogic();var M=this._getInternalModel().getProperty("/items");this._updateModelItemsPersistentIndex(M);this._updateCounts(M);this._getInternalModel().setProperty("/items",M);this._fireChangeColumnsItems();this._fireSetData();this._notifyChange();var v=this.getValidationExecutor();if(v){v();}};
t.prototype._switchMarkedTableItemTo=function(a){this._removeStyleOfMarkedTableItem();var b=this._getColumnKeyByTableItem(a);if(b){this._setColumnKeyOfMarkedItem(b);a.addStyleClass("sapMP13nColumnsPanelItemSelected");}};
t.prototype._removeStyleOfMarkedTableItem=function(){if(this._getMarkedTableItem()){this._getMarkedTableItem().removeStyleClass("sapMP13nColumnsPanelItemSelected");}};
t.prototype._filterModelItemsBySearchText=function(){var a=this._getSearchText();a=a.replace(/(^\s+)|(\s+$)/g,'');a=a.replace(/[-\/\\^$*+?.()|[\]{}]/g,'\\$&');var b=new RegExp(a,'igm');if(!b){return;}this._getVisibleModelItems().forEach(function(M){M.visible=false;if(typeof M.text==="string"&&M.text.match(b)){M.visible=true;}if(typeof M.tooltip==="string"&&M.tooltip.match(b)){M.visible=true;}});this._getInternalModel().refresh();};
t.prototype._updateInternalModel=function(){if(!this._bUpdateInternalModel){return;}this._bUpdateInternalModel=false;this._removeStyleOfMarkedTableItem();var M=this._getInternalModel().getProperty("/items");this._getInternalModel().setProperty("/items",this.getItems().map(function(b){return{columnKey:b.getColumnKey(),visible:true,text:b.getText(),tooltip:b.getTooltip(),persistentIndex:-1,persistentSelected:b.getVisible(),width:undefined,total:undefined};},this));this.getColumnsItems().forEach(function(b){var u=this._getModelItemByColumnKey(b.getColumnKey());if(!u){return;}if(b.getIndex()!==undefined){u.persistentIndex=b.getIndex();}if(b.getVisible()!==undefined){u.persistentSelected=b.getVisible();}if(b.getWidth()!==undefined){u.width=b.getWidth();}if(b.getTotal()!==undefined){u.total=b.getTotal();}},this);this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();var a=this._getInternalModel().getProperty("/items");this._sortModelItemsByPersistentIndex(a);this._updateCounts(a);this._getInternalModel().setProperty("/items",a);this._switchMarkedTableItemTo(this._getMarkedTableItem());if(q(a).not(M).length!==0||q(M).not(a).length!==0){this._bTableItemsChanged=true;}};
return t;});
sap.ui.predefine('sap/m/P13nConditionPanel',['./library','sap/ui/core/library','sap/ui/core/Control','sap/ui/core/IconPool','sap/ui/Device','sap/ui/core/InvisibleText','sap/ui/core/ResizeHandler','sap/ui/core/Item','sap/ui/core/ListItem','sap/ui/model/odata/type/Boolean','sap/ui/model/type/String','sap/ui/model/odata/type/String','sap/ui/model/type/Date','sap/ui/model/type/Time','sap/ui/model/odata/type/DateTime','sap/ui/model/type/Float','./Button','./OverflowToolbar','./OverflowToolbarLayoutData','./ToolbarSpacer','./Text','./SearchField','./CheckBox','./ComboBox','./Select','./Label','./Input','./DatePicker','./TimePicker','./DateTimePicker','sap/base/Log','sap/ui/thirdparty/jquery','./P13nOperationsHelper','sap/m/P13nConditionPanelRenderer'],function(a,c,C,I,D,b,R,d,L,B,S,e,f,T,g,F,h,O,k,m,o,q,r,s,t,u,v,x,y,z,A,Q,P,E){"use strict";var V=c.ValueState;var G=a.ButtonType;var H=a.ToolbarDesign;var J=c.TextAlign;var K=a.OverflowToolbarPriority;var M=a.P13nConditionOperation;var N;var U;var W;var X;
var Y=C.extend("sap.m.P13nConditionPanel",{
metadata:{library:"sap.m",properties:{maxConditions:{type:"string",group:"Misc",defaultValue:'-1'},exclude:{type:"boolean",group:"Misc",defaultValue:false},containerQuery:{type:"boolean",group:"Misc",defaultValue:false},autoAddNewRow:{type:"boolean",group:"Misc",defaultValue:false},disableFirstRemoveIcon:{type:"boolean",group:"Misc",defaultValue:false},alwaysShowAddIcon:{type:"boolean",group:"Misc",defaultValue:true},usePrevConditionSetting:{type:"boolean",group:"Misc",defaultValue:true},autoReduceKeyFieldItems:{type:"boolean",group:"Misc",defaultValue:false},layoutMode:{type:"string",group:"Misc",defaultValue:null},showLabel:{type:"boolean",group:"Misc",defaultValue:false},displayFormat:{type:"string",group:"Misc",defaultValue:null},validationExecutor:{type:"object",group:"Misc",defaultValue:null}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"}},events:{dataChange:{}}},
renderer:E.renderer
});
Y.prototype.setConditions=function(j){if(!j){A.error("sap.m.P13nConditionPanel : aCondition is not defined");}if(this._bIgnoreSetConditions){return;}this._oConditionsMap={};this._aConditionKeys=[];this._iConditions=0;for(var i=0;i<j.length;i++){this._addCondition2Map(j[i]);}this._clearConditions();this._fillConditions();};
Y.prototype.removeAllConditions=function(){this._oConditionsMap={};this._aConditionKeys=[];this._iConditions=0;this._clearConditions();this._fillConditions();};
Y.prototype.addCondition=function(i){if(this._bIgnoreSetConditions){return;}i.index=this._iConditions;this._addCondition2Map(i);this._addCondition(i);};
Y.prototype.insertCondition=function(i,j){if(this._bIgnoreSetConditions){return;}if(j!==undefined){i.index=j;}this._addCondition2Map(i);this._addCondition(i);};
Y.prototype.removeCondition=function(i){this._clearConditions();if(typeof i=="string"){this._removeConditionFromMap(i);}if(typeof i=="object"){this._removeConditionFromMap(i.key);}this._fillConditions();};
Y.prototype._addCondition2Map=function(i){if(!i.key){i.key="condition_"+this._iConditions;if(this.getExclude()){i.key="x"+i.key;}}this._iConditions++;this._oConditionsMap[i.key]=i;this._aConditionKeys.push(i.key);};
Y.prototype._removeConditionFromMap=function(j){this._iConditions--;delete this._oConditionsMap[j];var i=this._aConditionKeys.indexOf(j);if(i>=0){this._aConditionKeys.splice(i,1);}};
Y.prototype.getConditions=function(){var i;var j=[];if(this._oConditionsMap){for(var l in this._oConditionsMap){i=this._oConditionsMap[l];var n=i.value;if(!n){n=this._getFormatedConditionText(i.operation,i.value1,i.value2,i.exclude,i.keyField,i.showIfGrouped);}if(!i._oGrid||i._oGrid.select.getSelected()){j.push({"key":l,"text":n,"exclude":i.exclude,"operation":i.operation,"keyField":i.keyField,"value1":i.value1,"value2":this._hasSecondValue(i.operation)?i.value2:null,"showIfGrouped":i.showIfGrouped});}}}return j;};
Y.prototype.setOperations=function(i,j){j=j||"default";this._oTypeOperations[j]=i;this._updateAllOperations();};
Y.prototype.setValues=function(i,j){j=j||"default";this._oTypeValues[j]=i;};
Y.prototype.addOperation=function(i,j){j=j||"default";this._oTypeOperations[j].push(i);this._updateAllOperations();};
Y.prototype.removeAllOperations=function(i){i=i||"default";this._oTypeOperations[i]=[];this._updateAllOperations();};
Y.prototype.getOperations=function(i){i=i||"default";return this._oTypeOperations[i];};
Y.prototype.setKeyFields=function(i){this._aKeyFields=i;this._aKeyFields.forEach(function(j){Y._createKeyFieldTypeInstance(j);},this);this._updateKeyFieldItems(this._oConditionsGrid,true);this._updateAllConditionsEnableStates();this._createAndUpdateAllKeyFields();this._updateAllOperations();};
Y.prototype.addKeyField=function(i){this._aKeyFields.push(i);Y._createKeyFieldTypeInstance(i);this._updateKeyFieldItems(this._oConditionsGrid,true,true);this._updateAllConditionsEnableStates();this._createAndUpdateAllKeyFields();this._updateAllOperations();};
Y._createKeyFieldTypeInstance=function(i){var j;if(!i.typeInstance){switch(i.type){case"boolean":i.typeInstance=new B();break;case"numc":if(!(i.formatSettings&&i.formatSettings.isDigitSequence)){A.error("sap.m.P13nConditionPanel","NUMC type support requires isDigitSequence==true!");i.formatSettings=Object.assign({},i.formatSettings,{isDigitSequence:true});}j=i.formatSettings;if(i.maxLength){j=Object.assign({},j,{maxLength:i.maxLength});}if(!j.maxLength){A.error("sap.m.P13nConditionPanel","NUMC type suppport requires maxLength!");}i.typeInstance=new e({},j);break;case"date":i.typeInstance=new f(Object.assign({},i.formatSettings,{strictParsing:true}),{});break;case"time":i.typeInstance=new T(Object.assign({},i.formatSettings,{strictParsing:true}),{});break;case"datetime":i.typeInstance=new g(Object.assign({},i.formatSettings,{strictParsing:true}),{displayFormat:"Date"});var n=i.typeInstance;if(!n.oFormat){n.formatValue(new Date(),"string");}if(n.oFormat){n.oFormat.oFormatOptions.UTC=false;}break;case"stringdate":sap.ui.getCore().loadLibrary("sap.ui.comp");X=X||sap.ui.requireSync("sap/ui/comp/odata/type/StringDate");i.typeInstance=new X(Object.assign({},i.formatSettings,{strictParsing:true}));break;case"numeric":if(i.precision||i.scale){j={};if(i.precision){j["maxIntegerDigits"]=parseInt(i.precision);}if(i.scale){j["maxFractionDigits"]=parseInt(i.scale);}}i.typeInstance=new F(j);break;default:var l=i.formatSettings;if(i.maxLength){l=Object.assign({},l,{maxLength:i.maxLength});}i.typeInstance=new S({},l);break;}}};
Y.prototype.removeAllKeyFields=function(){this._aKeyFields=[];this._updateKeyFieldItems(this._oConditionsGrid,true);};
Y.prototype.getKeyFields=function(){return this._aKeyFields;};
Y.prototype.setAlwaysShowAddIcon=function(i){this.setProperty("alwaysShowAddIcon",i);if(this._oConditionsGrid){this._oConditionsGrid.toggleStyleClass("conditionRootGrid",this.getLayoutMode()!=="Desktop");}return this;};
Y.prototype.setLayoutMode=function(l){this.setProperty("layoutMode",l);if(this._oConditionsGrid){this._oConditionsGrid.toggleStyleClass("conditionRootGrid",l!=="Desktop");}this._updateConditionFieldSpans(l);this._clearConditions();this._fillConditions();return this;};
Y.prototype.setContainerQuery=function(i){this._unregisterResizeHandler();this.setProperty("containerQuery",i);this._registerResizeHandler();this._clearConditions();this._fillConditions();return this;};
Y.prototype._updateConditionFieldSpans=function(i){if(this._aConditionsFields){var j=i==="Desktop";if(j){this._aConditionsFields[2].SpanFilter="L3 M3 S3";this._aConditionsFields[4].SpanFilter="L2 M2 S2";this._aConditionsFields[5].SpanFilter="L3 M3 S3";this._aConditionsFields[6].SpanFilter="L2 M2 S2";this._aConditionsFields[7].SpanFilter="L1 M1 S1";}var l=i==="Tablet";if(l){this._aConditionsFields[2].SpanFilter="L5 M5 S5";this._aConditionsFields[4].SpanFilter="L5 M5 S5";this._aConditionsFields[5].SpanFilter="L10 M10 S10";this._aConditionsFields[6].SpanFilter="L10 M10 S10";this._aConditionsFields[7].SpanFilter="L1 M1 S1";}}};
Y.prototype.init=function(){sap.ui.getCore().loadLibrary("sap.ui.layout");var N=Y._getGridConstructor();this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._sFromLabelText=this._oRb.getText("CONDITIONPANEL_LABELFROM");this._sToLabelText=this._oRb.getText("CONDITIONPANEL_LABELTO");this._sValueLabelText=this._oRb.getText("CONDITIONPANEL_LABELVALUE");this._sShowIfGroupedLabelText=this._oRb.getText("CONDITIONPANEL_LABELGROUPING");this._sValidationDialogFieldMessage=this._oRb.getText("CONDITIONPANEL_FIELDMESSAGE");this._oOperationsHelper=new P();this._oTypeOperations={"default":[]};this._oTypeValues={"default":[]};this._aKeyFields=[];this._oConditionsMap={};this._aConditionKeys=[];this._iConditions=0;this._sLayoutMode="Desktop";this._sConditionType="Filter";this._sAddRemoveIconTooltip="FILTER";this._iBreakPointTablet=D.media._predefinedRangeSets[D.media.RANGESETS.SAP_STANDARD].points[0];this._iBreakPointDesktop=D.media._predefinedRangeSets[D.media.RANGESETS.SAP_STANDARD].points[1];this._oConditionsGrid=new N({width:"100%",defaultSpan:"L12 M12 S12",hSpacing:0,vSpacing:0}).toggleStyleClass("conditionRootGrid",this.getLayoutMode()!=="Desktop");this._oConditionsGrid.addStyleClass("sapUiRespGridOverflowHidden");this._iFirstConditionIndex=0;this._iConditionPageSize=10;this._oInvisibleTextField=new b({text:this._oRb.getText("CONDITIONPANEL_FIELD_LABEL")});this._oInvisibleTextOperator=new b({text:this._oRb.getText("CONDITIONPANEL_OPERATOR_LABEL")});this.addAggregation("content",this._oInvisibleTextField);this.addAggregation("content",this._oInvisibleTextOperator);this.addAggregation("content",this._oConditionsGrid);this._registerResizeHandler();this._aConditionsFields=this._createConditionsFields();this._oButtonGroupSpan={"SpanFilter":"L2 M2 S2","SpanSort":D.system.phone?"L2 M2 S4":"L2 M2 S3","SpanGroup":"L2 M2 S3"};this._updateConditionFieldSpans(this.getLayoutMode());this._fillConditions();};
Y.prototype._createPaginatorToolbar=function(){this._bPaginatorButtonsVisible=false;var i=this;this._oPrevButton=new h({icon:I.getIconURI("navigation-left-arrow"),tooltip:this._oRb.getText("WIZARD_FINISH"),visible:true,press:function(j){i._iFirstConditionIndex=Math.max(0,i._iFirstConditionIndex-i._iConditionPageSize);i._clearConditions();i._fillConditions();},layoutData:new k({priority:K.NeverOverflow})});this._oNextButton=new h({icon:I.getIconURI("navigation-right-arrow"),tooltip:this._oRb.getText("WIZARD_NEXT"),visible:true,press:function(j){i._iFirstConditionIndex+=i._iConditionPageSize;i._clearConditions();i._fillConditions();},layoutData:new k({priority:K.NeverOverflow})});this._oRemoveAllButton=new h({text:this._oRb.getText("CONDITIONPANEL_REMOVE_ALL"),visible:true,press:function(j){i._aConditionKeys.forEach(function(l,n){if(n>=0){this.fireDataChange({key:l,index:n,operation:"remove",newData:null});}},i);this._iFirstConditionIndex=0;i.removeAllConditions();},layoutData:new k({priority:K.Low})});this._oAddButton=new h({icon:I.getIconURI("add"),tooltip:this._oRb.getText("CONDITIONPANEL_ADD"+(this._sAddRemoveIconTooltipKey?"_"+this._sAddRemoveIconTooltipKey:"")+"_TOOLTIP"),visible:true,press:function(j){var l=i._createConditionRow(i._oConditionsGrid,undefined,null,0);i._changeField(l);setTimeout(function(){l.keyField.focus();});i._updatePaginatorToolbar();},layoutData:new k({priority:K.Low})});this._oHeaderText=new o({wrapping:false,layoutData:new k({priority:K.NeverOverflow})});this._oPageText=new o({wrapping:false,textAlign:J.Center,layoutData:new k({priority:K.NeverOverflow})});this._oFilterField=new q({width:"12rem",layoutData:new k({priority:K.High})});this._oPaginatorToolbar=new O({height:"3rem",design:H.Transparent,content:[this._oHeaderText,new m(),this._oFilterField,this._oPrevButton,this._oPageText,this._oNextButton,this._oRemoveAllButton,this._oAddButton]});};
Y.prototype._updatePaginatorToolbar=function(){if(this._sConditionType!=="Filter"||this.getMaxConditions()!=="-1"){return;}var i=this._aConditionKeys.length;var p=1+Math.floor(Math.max(0,i-1)/this._iConditionPageSize);var j=1+Math.floor(this._iFirstConditionIndex/this._iConditionPageSize);var l=this.getParent();if(!this._oPaginatorToolbar){if(i>this._iConditionPageSize){this._createPaginatorToolbar();this.insertAggregation("content",this._oPaginatorToolbar,0);this._onGridResize();}else{if(l&&l.setHeaderText){if(this._sOrgHeaderText==undefined){this._sOrgHeaderText=l.getHeaderText();}l.setHeaderText(this._sOrgHeaderText+(i>0?" ("+i+")":""));}return;}}this._oPrevButton.setEnabled(this._iFirstConditionIndex>0);this._oNextButton.setEnabled(this._iFirstConditionIndex+this._iConditionPageSize<i);if(l&&l.setHeaderToolbar){if(!l.getHeaderToolbar()){this.removeAggregation("content",this._oPaginatorToolbar);l.setHeaderToolbar(this._oPaginatorToolbar);l.attachExpand(function(Z){this._setToolbarElementVisibility(Z.getSource().getExpanded()&&this._bPaginatorButtonsVisible);}.bind(this));}}if(l&&l.setHeaderText){if(this._sOrgHeaderText==undefined){this._sOrgHeaderText=l.getHeaderText();}var n=this._sOrgHeaderText+(i>0?" ("+i+")":"");l.setHeaderText(n);this._oHeaderText.setText(n);}else{this._oHeaderText.setText(i+" Conditions");}this._oPageText.setText(j+"/"+p);this._bPaginatorButtonsVisible=this._bPaginatorButtonsVisible||p>1;this._setToolbarElementVisibility(this._bPaginatorButtonsVisible);if(j>p){this._iFirstConditionIndex-=Math.max(0,this._iConditionPageSize);this._clearConditions();this._fillConditions();}var w=0;this._oConditionsGrid.getContent().forEach(function(Z){if(Z.select.getSelected()){w++;}},this);if(p==j&&(i-this._iFirstConditionIndex)>w){this._clearConditions();this._fillConditions();}};
Y.prototype._setToolbarElementVisibility=function(i){this._oPrevButton.setVisible(i);this._oNextButton.setVisible(i);this._oPageText.setVisible(i);this._oFilterField.setVisible(false);this._oAddButton.setVisible(i);this._oRemoveAllButton.setVisible(i);};
Y.prototype.exit=function(){this._clearConditions();this._unregisterResizeHandler();this._aConditionsFields=null;this._aKeys=null;this._aKeyFields=null;this._oTypeOperations=null;this._oRb=null;this._sFromLabelText=null;this._sToLabelText=null;this._sValueLabelText=null;this._sValidationDialogFieldMessage=null;this._oConditionsMap=null;this._aConditionKeys=[];};
Y.prototype._clearConditions=function(){var i=this._oConditionsGrid.getContent();i.forEach(function(j){for(var l in this._aConditionsFields){var n=this._aConditionsFields[l];if(j[n["ID"]]&&j.getContent().indexOf(j[n["ID"]])===-1){j[n["ID"]].destroy();}}},this);this._oConditionsGrid.destroyContent();};
Y.prototype._fillConditions=function(){var j,l;var i=0,p=this._getMaxConditionsAsNumber(),n=this._aConditionKeys.length;if(this._oConditionsMap){var w=this._sConditionType!=="Filter"||this.getMaxConditions()!=="-1"?9999:this._iConditionPageSize;n=Math.min(n,Math.min(p,this._iFirstConditionIndex+w));for(i=this._iFirstConditionIndex;i<n;i++){l=this._aConditionKeys[i];j=this._oConditionsMap[l];this._createConditionRow(this._oConditionsGrid,j,l);}}this._updatePaginatorToolbar();if((this.getAutoAddNewRow()||this._oConditionsGrid.getContent().length===0)&&this._oConditionsGrid.getContent().length<p){this._createConditionRow(this._oConditionsGrid);}};
Y.prototype._addCondition=function(j){var i=0;var l=this._getMaxConditionsAsNumber();if(this._oConditionsMap){for(var n in this._oConditionsMap){if(i<l&&j===this._oConditionsMap[n]){this._createConditionRow(this._oConditionsGrid,j,n,i);}i++;}}this._updatePaginatorToolbar();};
Y.prototype._getMaxConditionsAsNumber=function(){return this.getMaxConditions()==="-1"?9999:parseInt(this.getMaxConditions());};
Y.prototype.onAfterRendering=function(){if(this.getLayoutMode()){this._sLayoutMode=this.getLayoutMode();return;}};
Y.prototype._handleMediaChange=function(p){this._sLayoutMode=p.name;this._updateLayout(p);};
Y.prototype._unregisterResizeHandler=function(){if(this._sContainerResizeListener){R.deregister(this._sContainerResizeListener);this._sContainerResizeListener=null;}D.media.detachHandler(this._handleMediaChange,this,D.media.RANGESETS.SAP_STANDARD);};
Y.prototype._registerResizeHandler=function(){if(this.getContainerQuery()){this._sContainerResizeListener=R.register(this._oConditionsGrid,this._onGridResize.bind(this));this._onGridResize();}else{D.media.attachHandler(this._handleMediaChange,this,D.media.RANGESETS.SAP_STANDARD);}};
Y.prototype._getKeyFromConditionGrid=function(i){var j=i.data("_key");if(!j){j=this._createConditionKey();}return j;};
Y.prototype._createConditionKey=function(){var i=0;var j;do{j="condition_"+i;if(this.getExclude()){j="x"+j;}i++;}while(this._oConditionsMap[j]);return j;};
Y.prototype._createConditionRow=function(i,j,l,p,n){var w,Z=this,N=Y._getGridConstructor(),U=Y._getGridDataConstructor();if(p===undefined){p=i.getContent().length;}var $=new N({width:"100%",defaultSpan:"L12 M12 S12",hSpacing:1,vSpacing:0,containerQuery:this.getContainerQuery()}).data("_key",l);$.addStyleClass("sapUiRespGridOverflowHidden");for(var _ in this._aConditionsFields){var a1;var b1=this._aConditionsFields[_];switch(b1["Control"]){case"CheckBox":a1=new r({enabled:false,layoutData:new U({span:b1["Span"+this._sConditionType]})});this._setLayoutVisible(a1,false);if(b1["ID"]==="showIfGrouped"){a1.setEnabled(true);a1.setText(b1["Label"]);a1.attachSelect(function(){Z._changeField($);});a1.setSelected(j?j.showIfGrouped:true);}else{if(j){a1.setSelected(true);a1.setEnabled(true);}}break;case"ComboBox":if(b1["ID"]==="keyField"){a1=new s({width:"100%",ariaLabelledBy:this._oInvisibleTextField});var c1=a1.setSelectedKey.bind(a1);a1.setSelectedKey=function(l){c1(l);var o1=Z.getValidationExecutor();if(o1){o1();}};var d1=a1.setSelectedItem.bind(a1);a1.setSelectedItem=function(o1){d1(o1);var p1=Z.getValidationExecutor();if(p1){p1();}};a1.setLayoutData(new U({span:b1["Span"+this._sConditionType]}));this._fillKeyFieldListItems(a1,this._aKeyFields);if(a1.attachSelectionChange){a1.attachSelectionChange(function(o1){var p1=Z.getValidationExecutor();if(p1){p1();}Z._handleSelectionChangeOnKeyField(i,$);});}if(a1.attachChange){a1.attachChange(function(o1){$.keyField.close();Z._handleChangeOnKeyField(i,$);});}if(a1.setSelectedItem){if(j){a1.setSelectedKey(j.keyField);this._aKeyFields.forEach(function(e1,o1){var p1=e1.key;if(p1===undefined){p1=e1;}if(j.keyField===p1){a1.setSelectedItem(a1.getItems()[o1]);}},this);}else{if(this.getUsePrevConditionSetting()&&!this.getAutoReduceKeyFieldItems()){if(p>0&&!l&&n){w=i.getContent()[p-1];if(w.keyField.getSelectedKey()){a1.setSelectedKey(w.keyField.getSelectedKey());}else{if(!a1.getSelectedItem()&&a1.getItems().length>0){a1.setSelectedItem(a1.getItems()[0]);}}}else{this._aKeyFields.some(function(e1,o1){if(e1.isDefault){a1.setSelectedItem(a1.getItems()[o1]);return true;}if(!a1.getSelectedItem()&&e1.type!=="boolean"){a1.setSelectedItem(a1.getItems()[o1]);}},this);if(!a1.getSelectedItem()&&a1.getItems().length>0){a1.setSelectedItem(a1.getItems()[0]);}}}else{this._aKeyFields.forEach(function(e1,o1){if(e1.isDefault){a1.setSelectedItem(a1.getItems()[o1]);}},this);}}}}if(b1["ID"]==="operation"){a1=new t({width:"100%",ariaLabelledBy:this._oInvisibleTextOperator,layoutData:new U({span:b1["Span"+this._sConditionType]})});a1.attachChange(function(){Z._handleChangeOnOperationField(i,$);});$[b1["ID"]]=a1;this._updateOperationItems(i,$);if(j){var e1=this._getCurrentKeyFieldItem($.keyField),f1=this._getRelevantOperations(e1),g1=this.getCurrentOparation(j);f1.some(function(o1){if(g1===o1){a1.setSelectedKey(o1);return true;}},this);}else{if(this.getUsePrevConditionSetting()){if(p>0&&l===null){var w=i.getContent()[p-1];a1.setSelectedKey(w.operation.getSelectedKey());}}}}if(a1.getSelectedItem&&a1.getSelectedItem()&&a1.getMetadata()._sUIDToken!=="box"){a1.setTooltip(a1.getSelectedItem().getTooltip()||a1.getSelectedItem().getText());}break;case"TextField":var h1=this._getCurrentKeyFieldItem($.keyField);a1=this._createValueField(h1,b1,$);a1.oTargetGrid=i;if(j&&j[b1["ID"]]!==undefined){var i1=j[b1["ID"]];if(a1 instanceof t){if(typeof i1==="boolean"){a1.setSelectedIndex(i1?2:1);}}else if(i1!==null&&$.oType){if(typeof i1==="string"&&$.oType.getName()==="sap.ui.comp.odata.type.StringDate"){a1.setValue(i1);}else{if(typeof i1==="string"&&["String","sap.ui.model.odata.type.String","sap.ui.model.odata.type.Decimal"].indexOf($.oType.getName())==-1){try{i1=$.oType.parseValue(i1,"string");a1.setValue($.oType.formatValue(i1,"string"));}catch(j1){A.error("sap.m.P13nConditionPanel","Value '"+i1+"' does not have the expected type format for "+$.oType.getName()+".parseValue()");}}else{a1.setValue($.oType.formatValue(i1,"string"));}}}else{a1.setValue(i1);}}break;case"Label":a1=new u({text:b1["Text"]+":",visible:this.getShowLabel(),layoutData:new U({span:b1["Span"+this._sConditionType]})}).addStyleClass("conditionLabel");a1.oTargetGrid=i;break;}$[b1["ID"]]=a1;$.addContent(a1);}this._addButtons($,i);i.insertContent($,p);this._updateOperationItems(i,$);this._changeOperationValueFields(i,$);this._updateAllConditionsEnableStates();this._updateConditionButtons(i);if(this.getAutoReduceKeyFieldItems()){this._updateKeyFieldItems(i,false);}if(this._sLayoutMode){this._updateLayout({name:this._sLayoutMode});}if(j){var k1=this._getFormatedConditionText(j.operation,j.value1,j.value2,j.exclude,j.keyField,j.showIfGrouped);j._oGrid=$;j.value=k1;this._oConditionsMap[l]=j;}var l1=$.operation.getSelectedKey();if(l1==="BT"&&$.value1.setMinDate&&$.value2.setMaxDate){var m1=$.value1.getDateValue();var n1=$.value2.getDateValue();this._updateMinMaxDate($,m1,n1);}else{this._updateMinMaxDate($,null,null);}return $;};
Y.prototype._handleRemoveCondition=function(i,j){var l=i.getContent().indexOf(j);this._removeCondition(i,j);if(this.getAutoReduceKeyFieldItems()){this._updateKeyFieldItems(i,false);}if(l>=0){l=Math.min(l,i.getContent().length-1);var j=i.getContent()[l];setTimeout(function(){j.remove.focus();});}this._updatePaginatorToolbar();};
Y.prototype._handleAddCondition=function(i,j,l){var p=i.getContent().indexOf(j);var n=this._createConditionRow(i,undefined,null,p+1,l);this._changeField(n);setTimeout(function(){n.keyField.focus();});this._updatePaginatorToolbar();};
Y.prototype._getCurrentKeyFieldItem=function(i){if(i.getSelectedKey&&i.getSelectedKey()){var j=i.getSelectedKey();var l=this._aKeyFields;for(var n in l){var p=l[n];if(p.key===j){return p;}}}return null;};
Y.prototype._createValueField=function(j,n,p){var w;var Z;var $=this;var U=Y._getGridDataConstructor();var _={value:n["Value"],width:"100%",placeholder:n["Label"],change:function(i){$._validateAndFormatFieldValue(i);$._changeField(p,i);},layoutData:new U({span:n["Span"+this._sConditionType]})};if(j&&j.typeInstance){var a1=j.typeInstance;Z=this._findConfig(a1,"ctrl");if(Z==="DateTimePicker"&&a1.getMetadata().getName()==="sap.ui.model.odata.type.DateTime"){if(!(a1.oConstraints&&a1.oConstraints.isDateOnly)){A.error("sap.m.P13nConditionPanel","sap.ui.model.odata.type.DateTime without displayFormat = Date is not supported!");a1.oConstraints=Object.assign({},a1.oConstraints,{isDateOnly:true});}Z="DatePicker";}p.oType=a1;if(Z=="select"){var b1=[];var c1=j.values||this._oTypeValues[Z]||["",a1.formatValue(false,"string"),a1.formatValue(true,"string")];c1.forEach(function(i,e1){b1.push(new d({key:e1.toString(),text:i.toString()}));});_={width:"100%",items:b1,change:function(){$._changeField(p);$._makeFieldValid(w,true);},layoutData:new U({span:n["Span"+this._sConditionType]})};w=new t(_);}else if(Z=="TimePicker"){if(a1.oFormatOptions&&a1.oFormatOptions.style){_.displayFormat=a1.oFormatOptions.style;}w=new y(_);}else if(Z=="DateTimePicker"){if(a1.oFormatOptions&&a1.oFormatOptions.style){_.displayFormat=a1.oFormatOptions.style;}w=new z(_);}else if(Z==="DatePicker"){if(a1.oFormatOptions){_.displayFormat=a1.oFormatOptions.style||a1.oFormatOptions.pattern;if(a1.isA("sap.ui.comp.odata.type.StringDate")){_.valueFormat="yyyyMMdd";}}w=new x(_);}else{w=new v(_);if(this._fSuggestCallback){j=this._getCurrentKeyFieldItem(p.keyField);if(j&&j.key){var d1=this._fSuggestCallback(w,j.key);if(d1){w._oSuggestProvider=d1;}}}}}else{p.oType=null;w=new v(_);}if(Z!=="boolean"&&Z!=="enum"&&w){w.onpaste=function(e1){var f1;if(window.clipboardData){f1=window.clipboardData.getData("Text");}else{f1=e1.originalEvent.clipboardData.getData('text/plain');}var p=e1.srcControl.getParent();var g1=f1.split(/\r\n|\r|\n/g);if(g1&&g1[g1.length-1].trim()===""){g1.pop();}var h1=p.operation;var op=h1.getSelectedKey();if(g1&&g1.length>1&&op!=="BT"){setTimeout(function(){var i1=g1?g1.length:0;var j1=$._getCurrentKeyFieldItem(p.keyField);var h1=p.operation;for(var i=0;i<i1;i++){if($._aConditionKeys.length>=$._getMaxConditionsAsNumber()){break;}var k1=g1[i].trim();if(k1){var l1;if(j1.typeInstance){try{l1=j1.typeInstance.parseValue(k1,"string");j1.typeInstance.validateValue(l1);}catch(m1){A.error("sap.m.P13nConditionPanel.onPaste","not able to parse value "+k1+" with type "+j1.typeInstance.getName());k1="";l1=null;}if(!l1){continue;}}var n1={"index":$._iConditions,"key":$._createConditionKey(),"exclude":$.getExclude(),"operation":h1.getSelectedKey(),"keyField":j1.key,"value1":l1,"value2":null};$._addCondition2Map(n1);$.fireDataChange({key:n1.key,index:n1.index,operation:"add",newData:n1});}}$._clearConditions();$._fillConditions();},0);}};}if(j&&j.maxLength&&w.setMaxLength){var l=-1;if(typeof j.maxLength==="string"){l=parseInt(j.maxLength);}if(typeof j.maxLength==="number"){l=j.maxLength;}if(l>0&&(!w.getShowSuggestion||!w.getShowSuggestion())){w.setMaxLength(l);}}return w;};
Y.prototype._fillOperationListItems=function(i,j,l){if(l==="_STRING_"){l="";}if(l==="_TIME_"||l==="_DATETIME_"){l="_DATE_";}if(l==="_BOOLEAN_"||l==="_NUMC_"){l="";}i.destroyItems();j.forEach(function(n){var p=this._oRb.getText("CONDITIONPANEL_OPTION"+l+n);if(p.startsWith("CONDITIONPANEL_OPTION")){p=this._oRb.getText("CONDITIONPANEL_OPTION"+n);}i.addItem(new L({key:n,text:p,tooltip:p}));}.bind(this));};
Y.prototype._fillKeyFieldListItems=function(i,j){i.destroyItems();for(var l in j){var n=j[l];i.addItem(new L({key:n.key,text:n.text,tooltip:n.tooltip?n.tooltip:n.text}));}i.setEditable(i.getItems().length>1);};
Y.prototype._handleChangeOnOperationField=function(i,j){this._changeOperationValueFields(i,j);this._changeField(j);};
Y.prototype._handleSelectionChangeOnKeyField=function(i,j){if(this._sConditionType==="Filter"){this._updateOperationItems(i,j);this._createAndUpdateValueFields(i,j);this._changeOperationValueFields(i,j);}this._changeField(j);};
Y.prototype._handleChangeOnKeyField=function(i,j){if(this.getAutoReduceKeyFieldItems()){this._updateKeyFieldItems(i,false,false,j.keyField);}};
Y.prototype._createAndUpdateAllKeyFields=function(){var i=this._oConditionsGrid.getContent();i.forEach(function(j){this._createAndUpdateValueFields(this._oConditionsGrid,j);this._changeOperationValueFields(this._oConditionsGrid,j);},this);};
Y.prototype._createAndUpdateValueFields=function(i,j){var l=this._getCurrentKeyFieldItem(j.keyField);var n=function(j,p,w){var Z=p.getValue?p.getValue():"";var $=j.indexOfContent(p);j.removeContent(p);if(p._oSuggestProvider){p._oSuggestProvider.destroy();p._oSuggestProvider=null;}p.destroy();var _=this._aConditionsFields[w];p=this._createValueField(l,_,j);j[_["ID"]]=p;j.insertContent(p,$===-1?j.indexOfContent(j.operation)+1:$);var a1,b1;if(j.oType&&Z){try{a1=j.oType.parseValue(Z,"string");j.oType.validateValue(a1);b1=j.oType.formatValue(a1,"string");p.setValue(b1);}catch(c1){var d1=c1.message;this._makeFieldValid(p,false,d1);p.setValue(Z);}}};n.bind(this)(j,j.value1,5);n.bind(this)(j,j.value2,6);};
Y.prototype._updateAllOperations=function(){var i=this._oConditionsGrid.getContent();i.forEach(function(j){this._updateOperationItems(this._oConditionsGrid,j);this._changeOperationValueFields(this._oConditionsGrid,j);},this);};
Y.prototype._updateOperationItems=function(i,j){var l=this._getCurrentKeyFieldItem(j.keyField);var n=l&&l.type||"";var p=j.operation;var w=p.getSelectedItem();var Z=this._getRelevantOperations(l);this._fillOperationListItems(p,Z,n?"_"+n.toUpperCase()+"_":"");if(w&&p.getItemByKey(w.getKey())){p.setSelectedKey(w.getKey());}else{p.setSelectedItem(p.getItems()[0]);}this._sConditionType="Filter";if(Z[0]===M.Ascending||Z[0]===M.Descending){this._sConditionType="Sort";}if(Z[0]===M.GroupAscending||Z[0]===M.GroupDescending){this._sConditionType="Group";}this._adjustValue1Span(j);};
Y.prototype._updateKeyFieldItems=function(l,p,w,Z){var n=l.getContent().length;var i;var $={};if(!p){for(i=0;i<n;i++){var _=l.getContent()[i].keyField;var a1=_.getSelectedKey();if(a1!=null&&a1!==""){$[a1]=true;}}}for(i=0;i<n;i++){var _=l.getContent()[i].keyField;var b1=l.getContent()[i].select;var c1=_.getSelectedKey();var j=0;var d1=this._aKeyFields;if(_!==Z){if(w){j=d1.length-1;}else{_.destroyItems();}for(j;j<d1.length;j++){var e1=d1[j];if(e1.key==null||e1.key===""||!$[e1.key]||e1.key===c1){_.addItem(new L({key:e1.key,text:e1.text,tooltip:e1.tooltip?e1.tooltip:e1.text}));}}_.setEditable(_.getItems().length>1);}if(c1){_.setSelectedKey(c1);}else if(_.getItems().length>0){_.setSelectedItem(_.getItems()[0]);}if(!b1.getSelected()){this._aKeyFields.some(function(f1,g1){if(f1.isDefault){_.setSelectedItem(_.getItems()[g1]);return true;}if(!_.getSelectedItem()){if(f1.type!=="boolean"){_.setSelectedItem(_.getItems()[g1]);}}},this);}if(_.getSelectedItem()){_.setTooltip(_.getSelectedItem().getTooltip()||_.getSelectedItem().getText());}}};
Y.prototype._changeOperationValueFields=function(i,j){var l=j.operation;var n=l.getSelectedKey();var p=j.value1;var w=j.value2;var Z=j.showIfGrouped;if(!n){return;}if(this._hasSecondValue(n)){if(p.setPlaceholder&&p.getPlaceholder()!==this._sFromLabelText){p.setPlaceholder(this._sFromLabelText);}if(!p.getVisible()){p.setVisible(true);j.insertContent(p,j.getContent().length-1);}if(w.setPlaceholder&&w.getPlaceholder()!==this._sToLabelText){w.setPlaceholder(this._sToLabelText);}if(!w.getVisible()){w.setVisible(true);j.insertContent(w,j.getContent().length-this._getSecondValueNegativeIndex());}}else{if(n===M.GroupAscending||n===M.GroupDescending){if(p.getVisible()){p.setVisible(false);j.removeContent(p);}if(w.getVisible()){w.setVisible(false);j.removeContent(w);}if(l.getVisible()){l.setVisible(false);j.removeContent(l);}Z.setVisible(this._getMaxConditionsAsNumber()!=1);this._setLayoutVisible(Z,this._getMaxConditionsAsNumber()!=1);}else{if(this._hasNoValues(n)){if(p.getVisible()){p.setVisible(false);j.removeContent(p);}if(w.getVisible()){w.setVisible(false);j.removeContent(w);}j.removeContent(Z);}else{if(p.setPlaceholder&&p.getPlaceholder()!==this._sValueLabelText){p.setPlaceholder(this._sValueLabelText);}if(!p.getVisible()){p.setVisible(true);j.insertContent(p,j.getContent().length-1);}if(w.getVisible()){w.setVisible(false);j.removeContent(w);}}}}this._adjustValue1Span(j);};
Y.prototype._adjustValue1Span=function(i){if(this._sConditionType==="Filter"&&i.value1&&i.operation){var j=i.operation;var n=this._aConditionsFields[5]["Span"+this._sConditionType];if(j.getSelectedKey()!=="BT"){n="L5 M10 S10";}var l=i.value1.getLayoutData();if(l.getSpan()!==n){l.setSpan(n);}}};
Y.prototype._getIndexOfCondition=function(i){var j=-1;i.getParent().getContent().some(function(l){if(l.select.getSelected()){j++;}return(l===i);},this);return j+this._iFirstConditionIndex;};
Y.prototype._makeFieldValid=function(i,j,l){if(j){i.setValueState(V.None);i.setValueStateText("");}else{i.setValueState(V.Warning);i.setValueStateText(l?l:this._sValidationDialogFieldMessage);}};
Y.prototype._validateAndFormatFieldValue=function(i){var j=i.oSource;var l=j.getParent();var n;if(j.getDateValue&&i){n=i.getParameter("value");var p=i.getParameter("valid");this._makeFieldValid(j,p);return;}else{n=j.getValue&&j.getValue();}if(!l){return;}if(this.getDisplayFormat()==="UpperCase"&&n){n=n.toUpperCase();j.setValue(n);}if(l.oType&&n){try{var w=l.oType.parseValue(n,"string");l.oType.validateValue(w);this._makeFieldValid(j,true);n=l.oType.formatValue(w,"string");j.setValue(n);}catch(Z){var $=Z.message;this._makeFieldValid(j,false,$);}}else{this._makeFieldValid(j,true);}};
Y.prototype._updateMinMaxDate=function(i,j,l){if(i.value1.setMinDate&&i.value2.setMaxDate){if(i.value1&&i.value1.setMaxDate){i.value1.setMaxDate(l instanceof Date?l:null);}if(i.value2&&i.value2.setMinDate){i.value2.setMinDate(j instanceof Date?j:null);}}};
Y.prototype._changeField=function(i,j){var l=i.keyField.getSelectedKey();if(i.keyField.getSelectedItem()){i.keyField.setTooltip(i.keyField.getSelectedItem().getTooltip()||i.keyField.getSelectedItem().getText());}else{i.keyField.setTooltip(null);}var n=i.operation.getSelectedKey();if(i.operation.getSelectedItem()){i.operation.setTooltip(i.operation.getSelectedItem().getTooltip()||i.operation.getSelectedItem().getText());}else{i.operation.setTooltip(null);}var p=function(j1,k1){var f1;var l1;if(j1.getDateValue&&!(j1.isA("sap.m.TimePicker"))&&k1.getName()!=="sap.ui.comp.odata.type.StringDate"){l1=j1.getDateValue();if(k1&&l1){if((j&&j.getParameter("valid"))||j1.isValidValue()){f1=k1.formatValue(l1,"string");}else{f1="";}}}else{f1=this._getValueTextFromField(j1);l1=f1;if(k1&&k1.getName()==="sap.ui.comp.odata.type.StringDate"){f1=k1.formatValue(l1,"string");}else if(k1&&f1){try{l1=k1.parseValue(f1,"string");k1.validateValue(l1);}catch(m1){A.error("sap.m.P13nConditionPanel","not able to parse value "+f1+" with type "+k1.getName());f1="";}}}return[l1,f1];}.bind(this);var w=p(i.value1,i.oType);var Z=w[0],$=w[1];w=p(i.value2,i.oType);var _=w[0],a1=w[1];if(this._hasSecondValue(n)){this._updateMinMaxDate(i,Z,_);}else{this._updateMinMaxDate(i,null,null);}var b1=this._getCurrentKeyFieldItem(i.keyField);if(b1&&b1.type==="numc"){if([M.Contains,M.EndsWith].indexOf(n)!=-1){Z=i.oType.formatValue(Z,"string");}}var c1=i.showIfGrouped.getSelected();var d1=this.getExclude();var e1=i.select;var f1="";var g1;if(l===""||l==null){l=null;g1=this._getKeyFromConditionGrid(i);this._removeConditionFromMap(g1);this._enableCondition(i,false);var h1=this._getIndexOfCondition(i);if(e1.getSelected()){e1.setSelected(false);e1.setEnabled(false);this._bIgnoreSetConditions=true;this.fireDataChange({key:g1,index:h1,operation:"remove",newData:null});this._bIgnoreSetConditions=false;}return;}this._enableCondition(i,true);f1=this._getFormatedConditionText(n,$,a1,d1,l,c1);var i1={"value":f1,"exclude":d1,"operation":n,"keyField":l,"value1":Z,"value2":this._hasSecondValue(n)?_:null,"showIfGrouped":c1};g1=this._getKeyFromConditionGrid(i);if(f1!==""){e1.setSelected(true);e1.setEnabled(true);var n="update";if(!this._oConditionsMap[g1]){n="add";}this._oConditionsMap[g1]=i1;if(n==="add"){this._aConditionKeys.splice(this._getIndexOfCondition(i),0,g1);}i.data("_key",g1);this.fireDataChange({key:g1,index:this._getIndexOfCondition(i),operation:n,newData:i1});}else if(this._oConditionsMap[g1]!==undefined){this._removeConditionFromMap(g1);i.data("_key",null);var h1=this._getIndexOfCondition(i);if(e1.getSelected()){e1.setSelected(false);e1.setEnabled(false);this._bIgnoreSetConditions=true;this.fireDataChange({key:g1,index:h1,operation:"remove",newData:null});this._bIgnoreSetConditions=false;}}this._updatePaginatorToolbar();};
Y.prototype._getValueTextFromField=function(i){if(i instanceof t){return i.getSelectedItem()?i.getSelectedItem().getText():"";}return i.getValue();};
Y.prototype._updateAllConditionsEnableStates=function(){var i=this._oConditionsGrid.getContent();i.forEach(function(j){var l=this._getCurrentKeyFieldItem(j.keyField);var n=l&&l.key!==undefined?l.key:l;var p=n!==""&&n!==null;this._enableCondition(j,p);},this);};
Y.prototype._enableCondition=function(i,j){i.operation.setEnabled(j);i.value1.setEnabled(j);i.value2.setEnabled(j);i.showIfGrouped.setEnabled(j);};
Y.prototype._removeCondition=function(i,j){var l=this._getKeyFromConditionGrid(j);var n=-1;if(j.select.getSelected()){n=this._getIndexOfCondition(j);}this._removeConditionFromMap(l);j.destroy();if(i.getContent().length<1){this._createConditionRow(i);}else{this._updateConditionButtons(i);}if(n>=0){this.fireDataChange({key:l,index:n,operation:"remove",newData:null});}};
Y.prototype._updateConditionButtons=function(j){var l=this._getMaxConditionsAsNumber();var n=j.getContent().length;for(var i=0;i<n;i++){var p=j.getContent()[i].add;if((this.getAlwaysShowAddIcon()&&(n<l))||(i===n-1&&i<l-1)){p.removeStyleClass("displayNone");}else{p.addStyleClass("displayNone");}var w=j.getContent()[i].remove;if(l===1||(i===0&&n===1&&this.getDisableFirstRemoveIcon())){w.addStyleClass("displayNone");}else{w.removeStyleClass("displayNone");}}};
Y.prototype.validateConditions=function(){var j=this;var l=function(n){var p=true;for(var i=0;i<n.length;i++){var w=n[i];var Z=j._checkCondition(w,i===n.length-1);p=p&&Z;}return p;};return l(this._oConditionsGrid.getContent());};
Y.prototype.removeValidationErrors=function(){this._oConditionsGrid.getContent().forEach(function(i){var j=i.value1;var l=i.value2;j.setValueState(V.None);j.setValueStateText("");l.setValueState(V.None);l.setValueStateText("");},this);};
Y.prototype.removeInvalidConditions=function(){var i=[];this._oConditionsGrid.getContent().forEach(function(j){if(j.value1.getValueState()!==V.None||j.value2.getValueState()!==V.None){i.push(j);}},this);i.forEach(function(j){this._removeCondition(this._oConditionsGrid,j);if(this.getAutoReduceKeyFieldItems()){this._updateKeyFieldItems(this._oConditionsGrid,false);}},this);};
Y.prototype._checkCondition=function(i,j){var l=true;var n=i.value1;var p=i.value2;var w=n&&(n.getVisible()&&!this._getValueTextFromField(n));var Z=n&&n.getVisible()&&n.getValueState?n.getValueState():V.None;var $=p&&(p.getVisible()&&!this._getValueTextFromField(p));var _=p&&p.getVisible()&&p.getValueState?p.getValueState():V.None;var a1=i.operation.getSelectedKey();if(this._hasSecondValue(a1)){if(!w?$:!$){if(w){n.setValueState(V.Warning);n.setValueStateText(this._sValidationDialogFieldMessage);}if($){p.setValueState(V.Warning);p.setValueStateText(this._sValidationDialogFieldMessage);}l=false;}else if(Z!==V.None||_!==V.None){l=false;}else{n.setValueState(V.None);n.setValueStateText("");p.setValueState(V.None);p.setValueStateText("");}}if((n.getVisible()&&n.getValueState&&n.getValueState()!==V.None)||(p.getVisible()&&p.getValueState&&p.getValueState()!==V.None)){l=false;}return l;};
Y.prototype._getFormatedConditionText=function(j,l,n,p,w,Z){var $=Y.getFormatedConditionText(j,l,n,p);if(!$){switch(j){case M.Initial:$="=''";break;case M.NotEmpty:$="!''";break;case M.Ascending:$="ascending";break;case M.GroupAscending:$="ascending";$+=" showIfGrouped:"+Z;break;case M.Descending:$="descending";break;case M.GroupDescending:$="descending";$+=" showIfGrouped:"+Z;break;case M.Total:$="total";break;case M.Average:$="average";break;case M.Minimum:$="minimum";break;case M.Maximum:$="maximum";break;}if(p&&$!==""){$="!("+$+")";}}if(this._aKeyFields&&this._aKeyFields.length>1){var _=null;for(var i=0;i<this._aKeyFields.length;i++){var a1=this._aKeyFields[i];if(typeof a1!=="string"){if(a1.key===w&&a1.text){_=a1.text;}}}if(_&&$!==""){$=_+": "+$;}}return $;};
Y._oConditionMap={"EQ":"=$0","GT":">$0","GE":">=$0","LT":"<$0","LE":"<=$0","Contains":"*$0*","StartsWith":"$0*","EndsWith":"*$0","BT":"$0...$1","Empty":"<$r>"};(function(){var _=sap.ui.getCore().getLibraryResourceBundle("sap.m");Y._oConditionMap[M.Empty]=Y._oConditionMap[M.Empty].replace("$r",_.getText("CONDITIONPANEL_OPTIONEmpty"));})();
Y._templateReplace=function(i,j){return i.replace(/\$\d/g,function(l){return j[parseInt(l.substr(1))];});};
Y.getFormatedConditionText=function(i,j,l,n){var p="";switch(i){case M.Empty:p=Y._templateReplace(Y._oConditionMap[i],[]);break;case M.EQ:case M.GT:case M.GE:case M.LT:case M.LE:case M.Contains:case M.StartsWith:case M.EndsWith:if(j!==""&&j!==undefined&&j!==null){p=Y._templateReplace(Y._oConditionMap[i],[j]);}break;case M.BT:if(j!==""&&j!==undefined&&j!==null){if(l!==""&&l!==undefined&&l!==null){p=Y._templateReplace(Y._oConditionMap[i],[j,l]);}}break;default:break;}if(n&&p!==""){p="!("+p+")";}return p;};
Y.prototype._updateLayout=function(j){if(!this._oConditionsGrid){return;}var l=this._oConditionsGrid.getContent();var n=this._aConditionsFields.length;var p=n;if(j.name==="Tablet"){p=5;}if(j.name==="Phone"){p=3;}if(this._sConditionType==="Filter"){for(var i=0;i<l.length;i++){var w=l[i];w.ButtonContainer.removeStyleClass("floatRight");w.removeContent(w.ButtonContainer);w.insertContent(w.ButtonContainer,p);if(!this.getAlwaysShowAddIcon()){if(p!==n){w.ButtonContainer.removeContent(w.add);w.addContent(w.add);}else{w.removeContent(w.add);w.ButtonContainer.addContent(w.add);}}}}};
Y.prototype._onGridResize=function(){var w;if(this._oPaginatorToolbar&&this._oConditionsGrid&&this._oConditionsGrid.getContent().length>0){var i=this._oConditionsGrid.getContent()[0];if(i.remove&&i.remove.$().position()){w=0;if(this._oPaginatorToolbar.getParent()&&this._oPaginatorToolbar.getParent().getExpandable&&this._oPaginatorToolbar.getParent().getExpandable()){w=48-4;}var j=i.remove.$().position().left-w+i.remove.$().width();this._oPaginatorToolbar.setWidth(j+"px");}}var l=this._oConditionsGrid.getDomRef();if(!l){return;}if(!Q(l).is(":visible")){return;}w=l.clientWidth;var n={};if(w<=this._iBreakPointTablet){n.name="Phone";}else if((w>this._iBreakPointTablet)&&(w<=this._iBreakPointDesktop)){n.name="Tablet";}else{n.name="Desktop";}if(n.name==="Phone"&&this._sLayoutMode!==n.name){this._updateLayout(n);this._sLayoutMode=n.name;}if(n.name==="Tablet"&&this._sLayoutMode!==n.name){this._updateLayout(n);this._sLayoutMode=n.name;}if(n.name==="Desktop"&&this._sLayoutMode!==n.name){this._updateLayout(n);this._sLayoutMode=n.name;}};
Y.prototype._findConfig=function(i,j){if(typeof i==="object"){i=i.getMetadata().getName();}var l;while(i&&!(l=this._getConfig(i,j))){i=this._getParentType(i);}return l;};
Y.prototype._getConfig=function(i,j){var l=this._mOpsForType[i];if(l){return l[j];}};
Y.prototype._getParentType=function(i){return this._mTypes[i];};
Y.prototype._getRelevantOperations=function(i){var j,l=i&&i.type&&this.getOperations(i.type);if(i&&i.operations){j=i.operations;}else if(Array.isArray(l)&&l.length>0){j=l;}else{j=this.getOperations("default");}return j;};
Y.prototype._addButtons=function(i,j){var l=this;var U=Y._getGridDataConstructor();var W=Y._getHorizontalLayoutConstructor(),n=new W({layoutData:new U({span:this.getLayoutMode()==="Desktop"?"L2 M2 S2":this._oButtonGroupSpan["Span"+this._sConditionType]})}).addStyleClass("floatRight");i.addContent(n);i["ButtonContainer"]=n;var p=new h({type:G.Transparent,icon:I.getIconURI("sys-cancel"),tooltip:this._oRb.getText("CONDITIONPANEL_REMOVE"+(this._sAddRemoveIconTooltipKey?"_"+this._sAddRemoveIconTooltipKey:"")+"_TOOLTIP"),press:function(){l._handleRemoveCondition(this.oTargetGrid,i);},layoutData:new U({span:this.getLayoutMode()==="Desktop"?"L1 M1 S1":"L1 M2 S2"})});p.oTargetGrid=j;n.addContent(p);i["remove"]=p;var w=new h({type:G.Transparent,icon:I.getIconURI("add"),tooltip:this._oRb.getText("CONDITIONPANEL_ADD"+(this._sAddRemoveIconTooltipKey?"_"+this._sAddRemoveIconTooltipKey:"")+"_TOOLTIP"),press:function(){l._handleAddCondition(this.oTargetGrid,i,true);},layoutData:new U({span:this.getLayoutMode()==="Desktop"?"L1 M1 S1":"L1 M10 S10"})});w.oTargetGrid=j;w.addStyleClass("conditionAddBtnFloatRight");n.addContent(w);i["add"]=w;};
Y.prototype.getCurrentOparation=function(i){return i.operation;};
Y.prototype.setSuggestCallback=function(i){this._fSuggestCallback=i;};
Y.prototype._hasSecondValue=function(i){return i===M.BT;};
Y.prototype._getSecondValueNegativeIndex=function(){return 1;};
Y.prototype._createConditionsFields=function(){return[{"ID":"select","Label":"","SpanFilter":"L1 M1 S1","SpanSort":"L1 M1 S1","SpanGroup":"L1 M1 S1","Control":"CheckBox","Value":""},{"ID":"keyFieldLabel","Text":"Sort By","SpanFilter":"L1 M1 S1","SpanSort":"L1 M1 S1","SpanGroup":"L1 M1 S1","Control":"Label"},{"ID":"keyField","Label":"","SpanFilter":"L3 M5 S10","SpanSort":"L5 M5 S12","SpanGroup":"L4 M4 S12","Control":"ComboBox"},{"ID":"operationLabel","Text":"Sort Order","SpanFilter":"L1 M1 S1","SpanSort":"L1 M1 S1","SpanGroup":"L1 M1 S1","Control":"Label"},{"ID":"operation","Label":"","SpanFilter":"L2 M5 S10","SpanSort":D.system.phone?"L5 M5 S8":"L5 M5 S9","SpanGroup":"L2 M5 S10","Control":"ComboBox"},{"ID":"value1","Label":this._sFromLabelText,"SpanFilter":"L3 M10 S10","SpanSort":"L3 M10 S10","SpanGroup":"L3 M10 S10","Control":"TextField","Value":""},{"ID":"value2","Label":this._sToLabelText,"SpanFilter":"L2 M10 S10","SpanSort":"L2 M10 S10","SpanGroup":"L2 M10 S10","Control":"TextField","Value":""},{"ID":"showIfGrouped","Label":this._sShowIfGroupedLabelText,"SpanFilter":"L1 M10 S10","SpanSort":"L1 M10 S10","SpanGroup":"L3 M4 S9","Control":"CheckBox","Value":"false"}];};
Y.prototype._hasNoValues=function(i){return i===M.Empty||i===M.Initial||i===M.Ascending||i===M.Descending||i===M.Total||i===M.Average||i===M.Minimum||i===M.Maximum;};
Y.prototype._setLayoutVisible=function(i,j){var l;if(i.getLayoutData===undefined){return;}l=i.getLayoutData&&i.getLayoutData();if(l&&(l.getMetadata&&l.getMetadata().getName()==="sap.ui.layout.GridData")){l.setVisibleXL(j);l.setVisibleL(j);l.setVisibleM(j);l.setVisibleS(j);}else{i.setLayoutData(new U({visibleXL:j,visibleL:j,visibleM:j,visibleS:j}));}};
Y._getGridConstructor=function(){if(N===undefined){N=sap.ui.requireSync("sap/ui/layout/Grid");}return N;};
Y._getGridDataConstructor=function(){if(U===undefined){U=sap.ui.requireSync("sap/ui/layout/GridData");}return U;};
Y._getHorizontalLayoutConstructor=function(){if(W===undefined){W=sap.ui.requireSync("sap/ui/layout/HorizontalLayout");}return W;};
Y.prototype._mTypes={"base":undefined,"string":"base","numeric":"base","date":"base","time":"base","boolean":"base","int":"numeric","float":"numeric","sap.ui.model.type.Boolean":"boolean","sap.ui.model.type.Date":"date","sap.ui.model.type.FileSize":"string","sap.ui.model.type.Float":"float","sap.ui.model.type.Integer":"int","sap.ui.model.type.String":"string","sap.ui.model.type.Time":"time","sap.ui.comp.odata.type.StringDate":"date","sap.ui.model.odata.type.Boolean":"boolean","sap.ui.model.odata.type.Byte":"int","sap.ui.model.odata.type.Date":"date","sap.ui.model.odata.type.DateTime":"datetime","sap.ui.model.odata.type.DateTimeOffset":"datetime","sap.ui.model.odata.type.Decimal":"float","sap.ui.model.odata.type.Double":"float","sap.ui.model.odata.type.Single":"float","sap.ui.model.odata.type.Guid":"string","sap.ui.model.odata.type.Int16":"int","sap.ui.model.odata.type.Int32":"int","sap.ui.model.odata.type.Int64":"int","sap.ui.model.odata.type.Raw":"string","sap.ui.model.odata.type.SByte":"int","sap.ui.model.odata.type.String":"string","sap.ui.model.odata.type.Time":"time","sap.ui.model.odata.type.TimeOfDay":"time","Edm.Boolean":"sap.ui.model.odata.type.Boolean","Edm.Byte":"sap.ui.model.odata.type.Byte","Edm.Date":"sap.ui.model.odata.type.Date","Edm.DateTime":"sap.ui.model.odata.type.DateTime","Edm.DateTimeOffset":"sap.ui.model.odata.type.DateTimeOffset","Edm.Decimal":"sap.ui.model.odata.type.Decimal","Edm.Double":"sap.ui.model.odata.type.Double","Edm.Single":"sap.ui.model.odata.type.Single","Edm.Guid":"sap.ui.model.odata.type.Guid","Edm.Int16":"sap.ui.model.odata.type.Int16","Edm.Int32":"sap.ui.model.odata.type.Int32","Edm.Int64":"sap.ui.model.odata.type.Int64","Edm.SByte":"sap.ui.model.odata.type.SByte","Edm.String":"sap.ui.model.odata.type.String","Edm.Time":"sap.ui.model.odata.type.Time","Edm.TimeOfDay":"sap.ui.model.odata.type.TimeOfDay"};Y.prototype._mOpsForType={"base":{ctrl:"input"},"string":{ctrl:"input"},"date":{ctrl:"DatePicker"},"datetime":{ctrl:"DateTimePicker"},"numeric":{ctrl:"input"},"time":{ctrl:"TimePicker"},"boolean":{ctrl:"select"}};return Y;});
sap.ui.predefine('sap/m/P13nDialog',['./Dialog','./library','sap/ui/core/EnabledPropagator','./DialogRenderer','sap/ui/core/library','sap/ui/Device','./Bar','./Button','./Title','sap/m/OverflowToolbarLayoutData','sap/ui/base/ManagedObjectObserver',"sap/ui/thirdparty/jquery","sap/base/Log","sap/base/util/isEmptyObject"],function(D,l,E,a,c,b,B,d,T,O,M,q,L,e){"use strict";var f=l.OverflowToolbarPriority;var g=l.ListType;var P=l.P13nPanelType;var h=l.ListMode;var j=c.MessageType;var k=l.ButtonType;var N;var m;var p={apiVersion:2,render:function(r,C){a.render.apply(this,arguments);var i=C._getVisiblePanelID();var o=C.getVisiblePanel();if(i&&o){r.openStart("div",i);r.openEnd();r.renderControl(o);r.close("div");}}};
var n=D.extend("sap.m.P13nDialog",{
metadata:{library:"sap.m",properties:{initialVisiblePanelType:{type:"string",group:"Misc",defaultValue:null},showReset:{type:"boolean",group:"Appearance",defaultValue:false},showResetEnabled:{type:"boolean",group:"Appearance",defaultValue:false},validationExecutor:{type:"object",group:"Misc",defaultValue:null}},aggregations:{panels:{type:"sap.m.P13nPanel",multiple:true,singularName:"panel",bindable:"bindable"}},events:{ok:{},cancel:{},reset:{}}},
renderer:p
});
E.apply(n.prototype,[true]);
n.prototype.init=function(o){this.addStyleClass("sapMP13nDialog");D.prototype.init.apply(this,arguments);this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._mValidationListener={};this._createDialog();this._mVisibleNavigationItems={};this._bNavigationControlsPromiseResolved=false;this._oNavigationControlsPromise=this._requestRequiredNavigationControls();this._oObserver=new M(_.bind(this));this._oObserver.observe(this,{properties:["showReset","showResetEnabled"],aggregations:["panels"]});};
n.prototype.setShowResetEnabled=function(i){return this.setProperty("showResetEnabled",i,true);};
n.prototype._createDialog=function(){if(b.system.phone){var t=this;this.setStretch(true);this.setVerticalScrolling(false);this.setHorizontalScrolling(false);this.setCustomHeader(new B(this.getId()+"-phoneHeader",{contentLeft:new d(this.getId()+"-backToList",{visible:false,type:k.Back,press:function(){t._backToList();}}),contentMiddle:new T(this.getId()+"-phoneTitle",{text:this._oResourceBundle.getText("P13NDIALOG_VIEW_SETTINGS"),level:"H2"})}));this.addButton(this._createOKButton());this.addButton(this._createCancelButton());this.addButton(this._createResetButton());}else{this.setHorizontalScrolling(false);this.setContentWidth("65rem");this.setContentHeight("40rem");this.setDraggable(true);this.setResizable(true);this.setTitle(this._oResourceBundle.getText("P13NDIALOG_VIEW_SETTINGS"));this.addButton(this._createOKButton());this.addButton(this._createCancelButton());this.addButton(this._createResetButton());}};
n.prototype._showValidationDialog=function(C,F,v){var w=[];var i=[];this._prepareMessages(F,v,w,i);var t=this;return new Promise(function(r){sap.ui.require(["sap/m/MessageBox"],function(o){var s="";if(i.length){i.forEach(function(u,I,x){s=(x.length>1?"• ":"")+u.messageText+"\n"+s;});o.show(s,{icon:o.Icon.ERROR,title:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VALIDATION_TITLE_ERROR"),actions:[o.Action.CLOSE],styleClass:t.$().closest(".sapUiSizeCompact").length?"sapUiSizeCompact":""});}else if(w.length){w.forEach(function(u,I,x){s=(x.length>1?"• ":"")+u.messageText+"\n"+s;});s=s+sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VALIDATION_MESSAGE_QUESTION");o.show(s,{icon:o.Icon.WARNING,title:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VALIDATION_TITLE"),actions:[sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VALIDATION_FIX"),o.Action.IGNORE],onClose:function(A){if(A===o.Action.IGNORE){C();}},styleClass:t.$().closest(".sapUiSizeCompact").length?"sapUiSizeCompact":""});}r();});});};
n.prototype._prepareMessages=function(F,v,w,o){if(!F.length&&!v.length){return;}F.forEach(function(s){switch(s){case P.filter:v.push({messageType:j.Warning,messageText:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VALIDATION_MESSAGE")});break;case P.columns:v.push({messageType:j.Warning,messageText:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VISIBLE_ITEMS_THRESHOLD_MESSAGE")});break;default:L.error("Panel type '"+s+"' is not supported jet.");}});var u=v.filter(function(r,I,s){for(var i=++I;i<s.length;i++){if(r.messageText===s[i].messageText){return false;}}return true;});u.forEach(function(i){if(i.messageType===j.Warning){w.push(i);}else if(i.messageType===j.Error){o.push(i);}});};
n.prototype._mapPanelToNavigationItem=function(o){if(!o){return null;}return b.system.phone?new m(o.getId()+"-navItem",{type:g.Navigation,title:o.getTitle()}):new m(o.getId()+"-navItem",{text:o.getTitle()});};
n.prototype._switchPanel=function(o){var i=this._getPanelByNavigationItem(o);this.setVerticalScrolling(i.getVerticalScrolling());if(b.system.phone){var r=this._getNavigationControl();if(r){r.setVisible(false);i.beforeNavigationTo();i.setVisible(true);this.getCustomHeader().getContentMiddle()[0].setText(i.getTitle());this.getCustomHeader().getContentLeft()[0].setVisible(true);}}else{this.getPanels().forEach(function(s){if(s===i){s.beforeNavigationTo();s.setVisible(true);}else{s.setVisible(false);}},this);}this.invalidate();this.rerender();};
n.prototype._backToList=function(){var o=this._getNavigationControl();if(o){o.setVisible(true);var i=this.getVisiblePanel();i.setVisible(false);this._updateDialogTitle();this.getCustomHeader().getContentLeft()[0].setVisible(false);}};
n.prototype.getVisiblePanel=function(){var o=null;this.getPanels().some(function(i){if(i.getVisible()){o=i;return true;}});return o;};
n.prototype._getVisiblePanelID=function(){var o=this.getVisiblePanel();if(o){return this.getId()+"-panel_"+o.getId();}return null;};
n.prototype._getPanelByNavigationItem=function(o){for(var i=0,r=this.getPanels(),s=r.length;i<s;i++){if(this._getNavigationItemByPanel(r[i])===o){return r[i];}}return null;};
n.prototype._getNavigationItemByPanel=function(o){return o?o.data("sapMP13nDialogNavigationItem"):null;};
n.prototype.onAfterRendering=function(){D.prototype.onAfterRendering.apply(this,arguments);var C=q(this.getFocusDomRef()).find(".sapMDialogScrollCont");var i=this._getVisiblePanelID();if(i&&C){var $=q(document.getElementById(i));$.appendTo(q(C));}};
n.prototype._updateDialogTitle=function(){var o=this.getVisiblePanel();var t=this._oResourceBundle.getText("P13NDIALOG_VIEW_SETTINGS");if(!this._isNavigationControlExpected()&&o){switch(o.getType()){case P.filter:t=this._oResourceBundle.getText("P13NDIALOG_TITLE_FILTER");break;case P.sort:t=this._oResourceBundle.getText("P13NDIALOG_TITLE_SORT");break;case P.group:t=this._oResourceBundle.getText("P13NDIALOG_TITLE_GROUP");break;case P.columns:t=this._oResourceBundle.getText("P13NDIALOG_TITLE_COLUMNS");break;case P.dimeasure:t=this._oResourceBundle.getText("P13NDIALOG_TITLE_DIMEASURE");break;default:t=o.getTitleLarge()||this._oResourceBundle.getText("P13NDIALOG_VIEW_SETTINGS");}}if(b.system.phone){this.getCustomHeader().getContentMiddle()[0].setText(t);}else{this.setTitle(t);}};
n.prototype._registerValidationListener=function(o,C){if(this.getPanels().indexOf(o)&&C&&this._mValidationListener[o.getType()]===undefined){this._mValidationListener[o.getType()]=C;}};
n.prototype._callValidationExecutor=function(){var v=this.getValidationExecutor();if(v&&!e(this._mValidationListener)){var t=this;v(this._getPayloadOfPanels()).then(function(V){var r=t._distributeValidationResult(V);for(var s in t._mValidationListener){var C=t._mValidationListener[s];C(r[s]||[]);}});}};
n.prototype._distributeValidationResult=function(r){var o={};r.forEach(function(R){R.panelTypes.forEach(function(t){if(o[t]===undefined){o[t]=[];}o[t].push({columnKey:R.columnKey,messageType:R.messageType,messageText:R.messageText});});});return o;};
n.prototype._createOKButton=function(){var t=this;return new d(this.getId()+"-ok",{type:k.Emphasized,text:this._oResourceBundle.getText("P13NDIALOG_OK"),layoutData:new O({priority:f.NeverOverflow}),press:function(){t.setBusy(true);var o=t._getPayloadOfPanels();var F=function(){t.setBusy(false);t.fireOk({payload:o});};var i=[];var C=function(){t.getPanels().forEach(function(r){if(i.indexOf(r.getType())>-1){r.onAfterNavigationFrom();}});F();};t.getPanels().forEach(function(r){if(!r.onBeforeNavigationFrom()){i.push(r.getType());}});var v=[];var V=t.getValidationExecutor();if(V){V(o).then(function(v){if(i.length||v.length){t.setBusy(false);t._showValidationDialog(C,i,v);}else{F();}});}else{if(i.length||v.length){t.setBusy(false);t._showValidationDialog(C,i,v);}else{F();}}}});};
n.prototype._createCancelButton=function(){var t=this;return new d(this.getId()+"-cancel",{text:this._oResourceBundle.getText("P13NDIALOG_CANCEL"),layoutData:new O({priority:f.NeverOverflow}),press:function(){t.fireCancel();}});};
n.prototype._createResetButton=function(){var t=this;return new d(this.getId()+"-reset",{text:this._oResourceBundle.getText("P13NDIALOG_RESET"),layoutData:new O({priority:f.NeverOverflow}),visible:this.getShowReset(),enabled:this.getShowResetEnabled(),press:function(){sap.ui.getCore().byId(t.getId()+"-ok").focus();t.setShowResetEnabled(false);var o={};t.getPanels().forEach(function(i){o[i.getType()]=i.getResetPayload();});t.fireReset({payload:o});}});};
n.prototype._getPayloadOfPanels=function(){var o={};this.getPanels().forEach(function(i){o[i.getType()]=i.getOkPayload();});return o;};
n.prototype.exit=function(){D.prototype.exit.apply(this,arguments);this._oObserver.disconnect();this._oObserver=undefined;this._mValidationListener={};this._mVisibleNavigationItems={};this._oNavigationControlsPromise=null;};
n.prototype._isInstanceOf=function(o,s){var C=sap.ui.require(s);return o&&typeof C==='function'&&(o instanceof C);};
function _(C){if(this._isInstanceOf(C.object,"sap/m/P13nDialog")){var i;switch(C.name){case"panels":var o=C.child?[C.child]:C.children;o.forEach(function(r){switch(C.mutation){case"insert":this._mVisibleNavigationItems[r.sId]=r.getVisible();r.setVisible(false);r.beforeNavigationTo();this._oObserver.observe(r,{properties:["title"]});r.setValidationExecutor(q.proxy(this._callValidationExecutor,this));r.setValidationListener(q.proxy(this._registerValidationListener,this));break;case"remove":delete this._mVisibleNavigationItems[r.sId];this._oObserver.unobserve(r);r.setValidationExecutor();r.setValidationListener();break;default:L.error("Mutation '"+C.mutation+"' is not supported jet.");}},this);if(this._bNavigationControlsPromiseResolved){this._updateDialog();}else{this._oNavigationControlsPromise.then(function(){this._updateDialog();}.bind(this));}break;case"showReset":i=this.getButtons();if(i.length>1){i[2].setVisible(C.current);}break;case"showResetEnabled":i=this.getButtons();if(i.length>1){i[2].setEnabled(C.current);i[2].invalidate();}break;default:L.error("The property or aggregation '"+C.name+"' has not been registered.");}}else if(this._isInstanceOf(C.object,"sap/m/P13nPanel")){if(C.name==="title"){var I=this._getNavigationItemByPanel(C.object);if(I){if(b.system.phone){I.setTitle(C.current);}else{I.setText(C.current);}}}}}
n.prototype._isNavigationControlExpected=function(){return this._getCountOfVisibleNavigationItems()>1;};
n.prototype._getCountOfVisibleNavigationItems=function(){var C=0;for(var i in this._mVisibleNavigationItems){C=this._mVisibleNavigationItems[i]?C+1:C;}return C;};
n.prototype._isNavigationControlExists=function(){return b.system.phone?this.getContent().length>0:(!!this.getSubHeader()&&this.getSubHeader().getContentLeft().length>0);};
n.prototype._getNavigationControl=function(){if(!this._isNavigationControlExists()){this._createNavigationControl();}return b.system.phone?this.getContent()[0]:this.getSubHeader().getContentLeft()[0];};
n.prototype._setVisibleOfNavigationControl=function(v){if(!this._isNavigationControlExists()){return;}return b.system.phone?this.getContent()[0].setVisible(v):this.getSubHeader().setVisible(v);};
n.prototype._createNavigationControl=function(){if(b.system.phone){this.addContent(new N(this.getId()+"-navigationItems",{mode:h.None,itemPress:function(o){this._switchPanel(o.getParameter("listItem"));}.bind(this)}));}else{this.setSubHeader(new B(this.getId()+"-navigationBar",{contentLeft:new N(this.getId()+"-navigationItems",{width:'100%',selectionChange:function(o){this._switchPanel(o.getParameter("item"));}.bind(this)})}));}return this._getNavigationControl();};
n.prototype._updateDialog=function(){var o=this._getNavigationControl();o.destroyItems();var i=this._determineInitialVisiblePanel();this.getPanels().forEach(function(r){var s=this._mapPanelToNavigationItem(r);r.data("sapMP13nDialogNavigationItem",s);o.addItem(s);var v=b.system.phone?this._mVisibleNavigationItems[r.sId]&&this._getCountOfVisibleNavigationItems()===1:this._mVisibleNavigationItems[r.sId]&&i===r.sId;r.setVisible(v);if(v){if(!b.system.phone){this.setVerticalScrolling(r.getVerticalScrolling());}}s.setVisible(this._mVisibleNavigationItems[r.sId]);if(v&&o.setSelectedItem){o.setSelectedItem(s);}}.bind(this));this._updateDialogTitle();this._setVisibleOfNavigationControl(this._isNavigationControlExpected());};
n.prototype._determineInitialVisiblePanel=function(){if(this.getInitialVisiblePanelType()){for(var i=0;i<this.getPanels().length;i++){if(this.getPanels()[i].getType()==this.getInitialVisiblePanelType()){return this.getPanels()[i].sId;}}}var I;this.getPanels().some(function(o){if(this._mVisibleNavigationItems[o.sId]){I=o.sId;return true;}}.bind(this));return I;};
n.prototype._requestRequiredNavigationControls=function(){var s=b.system.phone?"sap/m/List":"sap/m/SegmentedButton";var i=b.system.phone?"sap/m/StandardListItem":"sap/m/SegmentedButtonItem";N=sap.ui.require(s);m=sap.ui.require(i);if(N&&m){this._bNavigationControlsPromiseResolved=true;return Promise.resolve();}if(!this._oNavigationControlsPromise){this._oNavigationControlsPromise=new Promise(function(r){sap.ui.require([s,i],function(o,t){N=o;m=t;this._bNavigationControlsPromiseResolved=true;return r();}.bind(this));}.bind(this));}return this._oNavigationControlsPromise;};
return n;});
sap.ui.predefine('sap/m/P13nDimMeasureItem',['./library','sap/ui/core/Item'],function(l,I){"use strict";
var P=I.extend("sap.m.P13nDimMeasureItem",{metadata:{library:"sap.m",properties:{columnKey:{type:"string"},index:{type:"int",defaultValue:-1},visible:{type:"boolean"},role:{type:"string"}}}});
return P;});
sap.ui.predefine('sap/m/P13nDimMeasurePanel',['./library','./P13nPanel','./P13nDimMeasureItem','./SearchField','./Table','./Column','./ColumnListItem','./ScrollContainer','./Text','./Select','./ComboBox','./Button','./OverflowToolbar','./OverflowToolbarLayoutData','./OverflowToolbarButton','./ToolbarSpacer','sap/ui/core/library','sap/ui/model/ChangeReason','sap/ui/model/json/JSONModel','sap/ui/model/BindingMode','sap/ui/core/ResizeHandler','sap/ui/core/Item','sap/ui/core/InvisibleText','sap/ui/core/IconPool',"sap/ui/thirdparty/jquery"],function(l,P,c,S,T,C,d,e,f,g,h,B,O,i,j,k,m,n,J,o,R,I,p,q,Q){"use strict";var r=l.OverflowToolbarPriority;var s=l.ButtonType;var t=l.ToolbarDesign;var L=l.ListType;var u=l.ListMode;var v=l.P13nPanelType;
var w=P.extend("sap.m.P13nDimMeasurePanel",{
metadata:{library:"sap.m",properties:{chartTypeKey:{type:"string",defaultValue:""}},aggregations:{dimMeasureItems:{type:"sap.m.P13nDimMeasureItem",multiple:true,singularName:"dimMeasureItem",bindable:"bindable"},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"},availableChartTypes:{type:"sap.ui.core.Item",multiple:true,singularName:"availableChartType"}},events:{changeDimMeasureItems:{},changeChartType:{}}},
renderer:{apiVersion:2,render:function(a,b){a.openStart("div",b);a.class("sapMP13nColumnsPanel");a.openEnd();b.getAggregation("content").forEach(function(x){a.renderControl(x);});a.close("div");}}
});
w.prototype.init=function(){var a=this;this._iLiveChangeTimer=0;this._iSearchTimer=0;this._bIgnoreUpdateInternalModel=false;this._bUpdateInternalModel=true;this._bOnAfterRenderingFirstTimeExecuted=false;var b=sap.ui.getCore().getLibraryResourceBundle("sap.m");this.oAvailableRoleTypes={Dimension:[{key:"category",text:b.getText('COLUMNSPANEL_CHARTROLE_CATEGORY')},{key:"category2",text:b.getText('COLUMNSPANEL_CHARTROLE_CATEGORY2')},{key:"series",text:b.getText('COLUMNSPANEL_CHARTROLE_SERIES')}],Measure:[{key:"axis1",text:b.getText('COLUMNSPANEL_CHARTROLE_AXIS1')},{key:"axis2",text:b.getText('COLUMNSPANEL_CHARTROLE_AXIS2')},{key:"axis3",text:b.getText('COLUMNSPANEL_CHARTROLE_AXIS3')},{key:"axis4",text:b.getText('COLUMNSPANEL_CHARTROLE_AXIS4')}]};var M=new J({availableChartTypes:[],selectedChartTypeKey:null,items:[],columnKeyOfMarkedItem:undefined,isMoveDownButtonEnabled:undefined,isMoveUpButtonEnabled:undefined,showOnlySelectedItems:undefined,countOfSelectedItems:0,countOfItems:0});M.setDefaultBindingMode(o.TwoWay);M.setSizeLimit(1000);this.setModel(M,"$sapmP13nDimMeasurePanel");this.setType(v.dimeasure);this.setTitle(b.getText("CHARTPANEL_TITLE"));this._createTable();this._createToolbar();this.setVerticalScrolling(false);var x=new e({horizontal:false,vertical:true,content:[this._oTable],width:'100%',height:'100%'});this.addAggregation("content",x);this._fnHandleResize=function(){var y=false,z,A;if(a.getParent){var $=null,D,H;var E=a.getParent();var F=a._getToolbar();if(E&&E.$){$=E.$("cont");if($.children().length>0&&F.$().length>0){z=x.$()[0].clientHeight;D=$.children()[0].clientHeight;H=F?F.$()[0].clientHeight:0;A=D-H;if(z!==A){x.setHeight(A+'px');y=true;}}}}return y;};this._sContainerResizeListener=R.register(x,this._fnHandleResize);};
w.prototype.onBeforeRendering=function(){this._updateInternalModel();if(!this._getInternalModel().getProperty("/columnKeyOfMarkedItem")){this._setColumnKeyOfMarkedItem(this._getColumnKeyByTableItem(this._getVisibleTableItems()[0]));}this._switchMarkedTableItemTo(this._getTableItemByColumnKey(this._getInternalModel().getProperty("/columnKeyOfMarkedItem")));this._updateControlLogic();};
w.prototype.onAfterRendering=function(){var a=this;if(!this._bOnAfterRenderingFirstTimeExecuted){this._bOnAfterRenderingFirstTimeExecuted=true;window.clearTimeout(this._iLiveChangeTimer);this._iLiveChangeTimer=window.setTimeout(function(){a._fnHandleResize();a._getToolbar()._resetAndInvalidateToolbar();},0);}};
w.prototype.getOkPayload=function(){this._updateInternalModel();this._getInternalModel().getProperty("/items").forEach(function(M){if(this._getDimMeasureItemByColumnKey(M.columnKey)){return;}if(!M.persistentSelected){return;}this.addAggregation("dimMeasureItems",new c({columnKey:M.columnKey,visible:M.persistentSelected,index:M.persistentIndex===-1?undefined:M.persistentIndex,role:M.role}));},this);return{dimMeasureItems:this.getDimMeasureItems(),chartTypeKey:this.getChartTypeKey()};};
w.prototype.exit=function(){R.deregister(this._sContainerResizeListener);this._sContainerResizeListener=null;this._getToolbar().destroy();this._oTable.destroy();this._oTable=null;if(this._getInternalModel()){this._getInternalModel().destroy();}if(this.oInvisibleChartTypeText){this.oInvisibleChartTypeText.destroy();this.oInvisibleChartTypeText=null;}window.clearTimeout(this._iLiveChangeTimer);window.clearTimeout(this._iSearchTimer);};
w.prototype.addItem=function(a){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.addAggregation("items",a);return this;};
w.prototype.insertItem=function(a,b){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.insertAggregation("items",a,b);return this;};
w.prototype.removeItem=function(a){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}a=this.removeAggregation("items",a);return a;};
w.prototype.removeAllItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAllAggregation("items");};
w.prototype.destroyItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.destroyAggregation("items");return this;};
w.prototype.addDimMeasureItem=function(D){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.addAggregation("dimMeasureItems",D);return this;};
w.prototype.insertDimMeasureItem=function(D,a){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.insertAggregation("dimMeasureItems",D,a);return this;};
w.prototype.updateDimMeasureItems=function(a){this.updateAggregation("dimMeasureItems");if(a===n.Change&&!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}};
w.prototype.removeDimMeasureItem=function(D){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAggregation("dimMeasureItems",D);};
w.prototype.removeAllDimMeasureItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAllAggregation("dimMeasureItems");};
w.prototype.destroyDimMeasureItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.destroyAggregation("dimMeasureItems");return this;};
w.prototype.setChartTypeKey=function(a){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.setProperty("chartTypeKey",a);return this;};
w.prototype.addAvailableChartType=function(a){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.addAggregation("availableChartTypes",a);return this;};
w.prototype.insertAvailableChartType=function(a,b){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.insertAggregation("availableChartTypes",a,b);return this;};
w.prototype.removeAvailableChartType=function(a){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAggregation("availableChartTypes",a);};
w.prototype.removeAllAvailableChartType=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAllAggregation("availableChartTypes");};
w.prototype.destroyAvailableChartType=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.destroyAggregation("availableChartTypes");return this;};
w.prototype._notifyChange=function(){var a=this.getChangeNotifier();if(a){a(this);}};
w.prototype._scrollToSelectedItem=function(a){if(!a){return;}sap.ui.getCore().applyChanges();if(!!a.getDomRef()){a.focus();}};
w.prototype._getInternalModel=function(){return this.getModel("$sapmP13nDimMeasurePanel");};
w.prototype._createTable=function(){var a=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._oTable=new T({mode:u.MultiSelect,rememberSelections:false,itemPress:Q.proxy(this._onItemPressed,this),selectionChange:Q.proxy(this._onSelectionChange,this),columns:[new C({vAlign:m.VerticalAlign.Middle,header:new f({text:{parts:[{path:'/countOfSelectedItems'},{path:'/countOfItems'}],formatter:function(b,x){return a.getText('COLUMNSPANEL_SELECT_ALL_WITH_COUNTER',[b,x]);}}})}),new C({vAlign:m.VerticalAlign.Middle,header:new f({text:a.getText('COLUMNSPANEL_COLUMN_TYPE')})}),new C({vAlign:m.VerticalAlign.Middle,header:new f({text:a.getText('COLUMNSPANEL_COLUMN_ROLE')})})],items:{path:"/items",templateShareable:false,template:new d({cells:[new f({text:"{text}"}),new f({text:{path:'',formatter:function(M){if(M.aggregationRole==="Dimension"){return a.getText('COLUMNSPANEL_TYPE_DIMENSION');}if(M.aggregationRole==="Measure"){return a.getText('COLUMNSPANEL_TYPE_MEASURE');}}}}),new g({selectedKey:"{role}",items:{path:'availableRoleTypes',factory:function(b,x){var A=x.getObject();return new I({key:A.key,text:A.text});}},change:Q.proxy(this._onRoleChange,this)})],visible:"{visible}",selected:"{persistentSelected}",tooltip:"{tooltip}",type:L.Active})}});this._oTable.setModel(this._getInternalModel());};
w.prototype._createToolbar=function(){var a=this;var b=sap.ui.getCore().getLibraryResourceBundle("sap.m");var x=new p({text:b.getText('COLUMNSPANEL_CHARTTYPE')});this.oInvisibleChartTypeText=x;var y=new h({placeholder:x.getText(),selectedKey:{path:'/selectedChartTypeKey'},ariaLabelledBy:x,items:{path:'/availableChartTypes',templateShareable:false,template:new I({key:"{key}",text:"{text}"})},selectionChange:Q.proxy(this._onChartTypeChange,this),layoutData:new i({moveToOverflow:false,stayInOverflow:false})});var z=new O(this.getId()+"-toolbar",{design:t.Auto,content:[x,y,new k(),new S(this.getId()+"-searchField",{liveChange:function(E){var V=E.getSource().getValue(),D=(V?300:0);window.clearTimeout(a._iSearchTimer);if(D){a._iSearchTimer=window.setTimeout(function(){a._onExecuteSearch();},D);}else{a._onExecuteSearch();}},search:Q.proxy(this._onExecuteSearch,this),layoutData:new i({minWidth:"12.5rem",maxWidth:"23.077rem",shrinkable:true,moveToOverflow:false,stayInOverflow:false})}),new B({text:{path:'/showOnlySelectedItems',formatter:function(A){return A?b.getText('COLUMNSPANEL_SHOW_ALL'):b.getText('COLUMNSPANEL_SHOW_SELECTED');}},tooltip:{path:'/showOnlySelectedItems',formatter:function(A){return A?b.getText('COLUMNSPANEL_SHOW_ALL'):b.getText('COLUMNSPANEL_SHOW_SELECTED');}},type:s.Transparent,press:Q.proxy(this._onSwitchButtonShowSelected,this),layoutData:new i({moveToOverflow:true,priority:r.High})}),new j({icon:q.getIconURI("collapse-group"),text:b.getText('COLUMNSPANEL_MOVE_TO_TOP'),tooltip:b.getText('COLUMNSPANEL_MOVE_TO_TOP'),type:s.Transparent,enabled:{path:'/isMoveUpButtonEnabled'},press:Q.proxy(this.onPressButtonMoveToTop,this),layoutData:new i({moveToOverflow:true,priority:r.Low,group:2})}),new j({icon:q.getIconURI("slim-arrow-up"),text:b.getText('COLUMNSPANEL_MOVE_UP'),tooltip:b.getText('COLUMNSPANEL_MOVE_UP'),type:s.Transparent,enabled:{path:'/isMoveUpButtonEnabled'},press:Q.proxy(this.onPressButtonMoveUp,this),layoutData:new i({moveToOverflow:true,priority:r.High,group:1})}),new j({icon:q.getIconURI("slim-arrow-down"),text:b.getText('COLUMNSPANEL_MOVE_DOWN'),tooltip:b.getText('COLUMNSPANEL_MOVE_DOWN'),type:s.Transparent,enabled:{path:'/isMoveDownButtonEnabled'},press:Q.proxy(this.onPressButtonMoveDown,this),layoutData:new i({moveToOverflow:true,priority:r.High,group:1})}),new j({icon:q.getIconURI("expand-group"),text:b.getText('COLUMNSPANEL_MOVE_TO_BOTTOM'),tooltip:b.getText('COLUMNSPANEL_MOVE_TO_BOTTOM'),type:s.Transparent,enabled:{path:'/isMoveDownButtonEnabled'},press:Q.proxy(this.onPressButtonMoveToBottom,this),layoutData:new i({moveToOverflow:true,priority:r.Low,group:2})})]});z.setModel(this._getInternalModel());this.addAggregation("content",z);};
w.prototype.onPressButtonMoveToTop=function(){this._moveMarkedTableItem(this._getMarkedTableItem(),this._getVisibleTableItems()[0]);};
w.prototype.onPressButtonMoveUp=function(){var V=this._getVisibleTableItems();this._moveMarkedTableItem(this._getMarkedTableItem(),V[V.indexOf(this._getMarkedTableItem())-1]);};
w.prototype.onPressButtonMoveDown=function(){var V=this._getVisibleTableItems();this._moveMarkedTableItem(this._getMarkedTableItem(),V[V.indexOf(this._getMarkedTableItem())+1]);};
w.prototype.onPressButtonMoveToBottom=function(){var V=this._getVisibleTableItems();this._moveMarkedTableItem(this._getMarkedTableItem(),V[V.length-1]);};
w.prototype._onSwitchButtonShowSelected=function(){this._getInternalModel().setProperty("/showOnlySelectedItems",!this._getInternalModel().getProperty("/showOnlySelectedItems"));this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();this._scrollToSelectedItem(this._getMarkedTableItem());this._updateControlLogic();this._fnHandleResize();};
w.prototype._onExecuteSearch=function(){this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();this._updateControlLogic();};
w.prototype._switchVisibilityOfUnselectedModelItems=function(){var b=this._isFilteredByShowSelected();var M=this._getInternalModel().getProperty("/items");M.forEach(function(a){if(a.persistentSelected){a.visible=true;return;}a.visible=!b;});this._getInternalModel().setProperty("/items",M);};
w.prototype._getVisibleModelItems=function(){return this._getInternalModel().getProperty("/items").filter(function(M){return!!M.visible;});};
w.prototype._getVisibleModelItems=function(){return this._getInternalModel().getProperty("/items").filter(function(M){return!!M.visible;});};
w.prototype._moveMarkedTableItem=function(a,b){var M=this._getModelItemByColumnKey(this._getColumnKeyByTableItem(a));var x=this._getModelItemByColumnKey(this._getColumnKeyByTableItem(b));var y=this._getModelItemIndexByColumnKey(M.columnKey);var z=this._getModelItemIndexByColumnKey(x.columnKey);this._moveModelItems(y,z);this._scrollToSelectedItem(this._getMarkedTableItem());this._updateControlLogic();this._fireChangeDimMeasureItems();this._notifyChange();};
w.prototype._moveModelItems=function(a,b){var M=this._getInternalModel().getProperty("/items");if(a<0||b<0||a>M.length-1||b>M.length-1){return false;}this._removeStyleOfMarkedTableItem();var x=M.splice(a,1);M.splice(b,0,x[0]);this._updateModelItemsPersistentIndex(M);this._updateCounts(M);this._getInternalModel().setProperty("/items",M);this._switchMarkedTableItemTo(this._getMarkedTableItem());return true;};
w.prototype._getModelItemByColumnKey=function(a){var M=this._getInternalModel().getProperty("/items").filter(function(b){return b.columnKey===a;});return M[0];};
w.prototype._updateCounts=function(M){var a=0;var b=0;M.forEach(function(x){a++;if(x.persistentSelected){b++;}});this._getInternalModel().setProperty("/countOfItems",a);this._getInternalModel().setProperty("/countOfSelectedItems",b);};
w.prototype._sortModelItemsByPersistentIndex=function(M){var x;var y=sap.ui.getCore().getConfiguration().getLocale().toString();try{if(typeof window.Intl!=='undefined'){x=window.Intl.Collator(y,{numeric:true});}}catch(E){}M.forEach(function(a,b){a.localIndex=b;});M.sort(function(a,b){if(a.persistentSelected===true&&(b.persistentSelected===false||b.persistentSelected===undefined)){return-1;}else if((a.persistentSelected===false||a.persistentSelected===undefined)&&b.persistentSelected===true){return 1;}else if(a.persistentSelected===true&&b.persistentSelected===true){if(a.persistentIndex>-1&&a.persistentIndex<b.persistentIndex){return-1;}else if(b.persistentIndex>-1&&a.persistentIndex>b.persistentIndex){return 1;}else{return a.localIndex-b.localIndex;}}else if((a.persistentSelected===false||a.persistentSelected===undefined)&&(b.persistentSelected===false||b.persistentSelected===undefined)){return x?x.compare(a.text,b.text):a.text.localeCompare(b.text,y,{numeric:true});}});M.forEach(function(a){delete a.localIndex;});};
w.prototype._getColumnKeyByTableItem=function(a){var b=this._oTable.indexOfItem(a);if(b<0){return null;}return this._oTable.getBinding("items").getContexts()[b].getObject().columnKey;};
w.prototype._getModelItemIndexByColumnKey=function(a){var b=-1;this._getInternalModel().getData().items.some(function(M,x){if(M.columnKey===a){b=x;return true;}});return b;};
w.prototype._getSelectedModelItems=function(){return this._getInternalModel().getProperty("/items").filter(function(M){return M.persistentSelected;});};
w.prototype._getVisibleTableItems=function(){return this._oTable.getItems().filter(function(a){return a.getVisible();});};
w.prototype._getTableItemByColumnKey=function(a){var b=this._oTable.getBinding("items").getContexts();var x=this._oTable.getItems().filter(function(y,z){return b[z].getObject().columnKey===a;});return x[0];};
w.prototype._getToolbar=function(){return sap.ui.getCore().byId(this.getId()+"-toolbar")||null;};
w.prototype._getSearchField=function(){return sap.ui.getCore().byId(this.getId()+"-searchField")||null;};
w.prototype._getSearchText=function(){var a=this._getSearchField();return a?a.getValue():"";};
w.prototype._isFilteredBySearchText=function(){return!!this._getSearchText().length;};
w.prototype._isFilteredByShowSelected=function(){return this._getInternalModel().getData().showOnlySelectedItems;};
w.prototype._updateControlLogic=function(){var b=this._isFilteredBySearchText();var a=this._isFilteredByShowSelected();var V=this._getVisibleTableItems();this._getInternalModel().setProperty("/isMoveUpButtonEnabled",V.indexOf(this._getMarkedTableItem())>0);this._getInternalModel().setProperty("/isMoveDownButtonEnabled",V.indexOf(this._getMarkedTableItem())>-1&&V.indexOf(this._getMarkedTableItem())<V.length-1);var x=sap.ui.getCore().byId(this._oTable.getId()+'-sa');if(x){x.setEnabled(!b&&!a);}};
w.prototype._updateModelItemsPersistentIndex=function(M){var a=-1;M.forEach(function(b){b.persistentIndex=-1;if(b.persistentSelected){a++;b.persistentIndex=a;}});};
w.prototype._fireChangeDimMeasureItems=function(){this._bIgnoreUpdateInternalModel=true;this.fireChangeDimMeasureItems({items:this._getInternalModel().getProperty("/items").map(function(M){return{columnKey:M.columnKey,visible:M.persistentSelected,index:M.persistentIndex===-1?undefined:M.persistentIndex,role:M.role};})});this._bIgnoreUpdateInternalModel=false;};
w.prototype._fireChangeChartType=function(){this._bIgnoreUpdateInternalModel=true;this.fireChangeChartType({chartTypeKey:this._getInternalModel().getProperty("/selectedChartTypeKey")});this._bIgnoreUpdateInternalModel=false;};
w.prototype._getDimMeasureItemByColumnKey=function(a){var D=this.getDimMeasureItems().filter(function(b){return b.getColumnKey()===a;});return D[0];};
w.prototype._getMarkedTableItem=function(){return this._getTableItemByColumnKey(this._getInternalModel().getProperty("/columnKeyOfMarkedItem"));};
w.prototype._setColumnKeyOfMarkedItem=function(a){this._getInternalModel().setProperty("/columnKeyOfMarkedItem",a);};
w.prototype._onItemPressed=function(E){this._switchMarkedTableItemTo(E.getParameter('listItem'));this._updateControlLogic();};
w.prototype._onChartTypeChange=function(E){this._fireChangeChartType();this._notifyChange();};
w.prototype._onRoleChange=function(E){this._fireChangeDimMeasureItems();this._notifyChange();};
w.prototype._onSelectionChange=function(E){if(!E.getParameter("selectAll")&&E.getParameter("listItems").length===1){this._switchMarkedTableItemTo(E.getParameter("listItem"));}this._selectTableItem();};
w.prototype._selectTableItem=function(){this._updateControlLogic();var M=this._getInternalModel().getProperty("/items");this._updateModelItemsPersistentIndex(M);this._updateCounts(M);this._getInternalModel().setProperty("/items",M);this._fireChangeDimMeasureItems();this._notifyChange();};
w.prototype._switchMarkedTableItemTo=function(a){this._removeStyleOfMarkedTableItem();var b=this._getColumnKeyByTableItem(a);if(b){this._setColumnKeyOfMarkedItem(b);a.addStyleClass("sapMP13nColumnsPanelItemSelected");}};
w.prototype._removeStyleOfMarkedTableItem=function(){if(this._getMarkedTableItem()){this._getMarkedTableItem().removeStyleClass("sapMP13nColumnsPanelItemSelected");}};
w.prototype._filterModelItemsBySearchText=function(){var a=this._getSearchText();a=a.replace(/(^\s+)|(\s+$)/g,'');a=a.replace(/[-\/\\^$*+?.()|[\]{}]/g,'\\$&');var b=new RegExp(a,'igm');if(!b){return;}this._getVisibleModelItems().forEach(function(M){var x=this._getTableItemByColumnKey(M.columnKey);var y=x.getCells();M.visible=false;if(y[0]&&y[0].getText().match(b)){M.visible=true;}if(y[1]&&y[1].getText().match(b)){M.visible=true;}if(y[2]&&y[2].getSelectedItem()&&y[2].getSelectedItem().getText().match(b)){M.visible=true;}if(M.tooltip&&M.tooltip.match(b)){M.visible=true;}},this);this._getInternalModel().refresh();};
w.prototype._updateInternalModel=function(){if(!this._bUpdateInternalModel){return;}this._bUpdateInternalModel=false;this._removeStyleOfMarkedTableItem();this._getInternalModel().setProperty("/items",this.getItems().map(function(a){return{columnKey:a.getColumnKey(),visible:true,text:a.getText(),tooltip:a.getTooltip(),aggregationRole:a.getAggregationRole(),availableRoleTypes:this.oAvailableRoleTypes[a.getAggregationRole()],role:a.getRole(),persistentIndex:-1,persistentSelected:undefined};},this));this._getInternalModel().setProperty("/selectedChartTypeKey",this.getChartTypeKey());this._getInternalModel().setProperty("/availableChartTypes",this.getAvailableChartTypes().map(function(a){return{key:a.getKey(),text:a.getText()};},this));this.getDimMeasureItems().forEach(function(D){var a=this._getModelItemByColumnKey(D.getColumnKey());if(!a){return;}if(D.getIndex()!==undefined){a.persistentIndex=D.getIndex();}if(D.getVisible()!==undefined){a.persistentSelected=D.getVisible();}if(D.getRole()!==undefined){a.role=D.getRole();}},this);this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();var M=this._getInternalModel().getProperty("/items");this._sortModelItemsByPersistentIndex(M);this._updateCounts(M);this._getInternalModel().setProperty("/items",M);this._switchMarkedTableItemTo(this._getMarkedTableItem());};
return w;});
sap.ui.predefine('sap/m/P13nFilterItem',['./library','sap/ui/core/Item'],function(l,I){"use strict";
var P=I.extend("sap.m.P13nFilterItem",{metadata:{library:"sap.m",properties:{operation:{type:"string",group:"Misc",defaultValue:null},value1:{type:"string",group:"Misc",defaultValue:null},value2:{type:"string",group:"Misc",defaultValue:null},columnKey:{type:"string",group:"Misc",defaultValue:null},exclude:{type:"boolean",group:"Misc",defaultValue:false}}}});
P.prototype.setOperation=function(o){return this.setProperty("operation",o,true);};
P.prototype.setColumnKey=function(k){return this.setProperty("columnKey",k,true);};
P.prototype.setValue1=function(v){return this.setProperty("value1",v,true);};
P.prototype.setValue2=function(v){return this.setProperty("value2",v,true);};
P.prototype.setExclude=function(e){return this.setProperty("exclude",e,true);};
return P;});
sap.ui.predefine('sap/m/P13nFilterPanel',['./P13nConditionPanel','./P13nPanel','./library','sap/m/Panel','./P13nFilterItem','./P13nOperationsHelper','sap/m/P13nFilterPanelRenderer'],function(P,a,l,b,c,d,e){"use strict";var f=l.P13nPanelType;var g=l.P13nConditionOperation;
var h=a.extend("sap.m.P13nFilterPanel",{
metadata:{library:"sap.m",properties:{maxIncludes:{type:"string",group:"Misc",defaultValue:'-1'},maxExcludes:{type:"string",group:"Misc",defaultValue:'-1'},containerQuery:{type:"boolean",group:"Misc",defaultValue:false},layoutMode:{type:"string",group:"Misc",defaultValue:null},enableEmptyOperations:{type:"boolean",group:"Misc",defaultValue:false}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"},filterItems:{type:"sap.m.P13nFilterItem",multiple:true,singularName:"filterItem",bindable:"bindable"},messageStrip:{type:"sap.m.MessageStrip",multiple:false}},events:{addFilterItem:{},removeFilterItem:{},updateFilterItem:{},filterItemChanged:{parameters:{reason:{type:"string"},key:{type:"string"},index:{type:"int"},itemData:{type:"object"}}}}},
renderer:e.renderer
});
h.prototype.setConditions=function(C){var I=[];var E=[];if(C.length){for(var i=0;i<C.length;i++){var o=C[i];if(!o.exclude){I.push(o);}else{E.push(o);}}}this._oIncludeFilterPanel.setConditions(I);this._oExcludeFilterPanel.setConditions(E);if(E.length>0){this._oExcludePanel.setExpanded(true);}return this;};
h.prototype.getConditions=function(){var i=this._oIncludeFilterPanel.getConditions();var E=this._oExcludeFilterPanel.getConditions();return i.concat(E);};
h.prototype.setContainerQuery=function(C){this.setProperty("containerQuery",C);this._oIncludeFilterPanel.setContainerQuery(C);this._oExcludeFilterPanel.setContainerQuery(C);return this;};
h.prototype.setLayoutMode=function(m){this.setProperty("layoutMode",m);this._oIncludeFilterPanel.setLayoutMode(m);this._oExcludeFilterPanel.setLayoutMode(m);return this;};
h.prototype.validateConditions=function(){return this._oIncludeFilterPanel.validateConditions()&&this._oExcludeFilterPanel.validateConditions();};
h.prototype.removeInvalidConditions=function(){this._oIncludeFilterPanel.removeInvalidConditions();this._oExcludeFilterPanel.removeInvalidConditions();};
h.prototype.removeValidationErrors=function(){this._oIncludeFilterPanel.removeValidationErrors();this._oExcludeFilterPanel.removeValidationErrors();};
h.prototype.onBeforeNavigationFrom=function(){return this.validateConditions();};
h.prototype.onAfterNavigationFrom=function(){return this.removeInvalidConditions();};
h.prototype.setIncludeOperations=function(o,t){t=t||"default";this._aIncludeOperations[t]=o;if(this._oIncludeFilterPanel){this._oIncludeFilterPanel.setOperations(this._aIncludeOperations[t],t);}};
h.prototype.getIncludeOperations=function(t){if(this._oIncludeFilterPanel){return this._oIncludeFilterPanel.getOperations(t);}};
h.prototype.setExcludeOperations=function(o,t){t=t||"default";this._aExcludeOperations[t]=o;if(this._oExcludeFilterPanel){this._oExcludeFilterPanel.setOperations(this._aExcludeOperations[t],t);}};
h.prototype.getExcludeOperations=function(t){if(this._oExcludeFilterPanel){return this._oExcludeFilterPanel.getOperations(t);}};
h.prototype.setKeyFields=function(k,K){this._aKeyFields=k;if(this._oIncludeFilterPanel){k.some(function(o){if(o.isDefault){this._oIncludeFilterPanel.setAutoAddNewRow(true);}}.bind(this));this._oIncludeFilterPanel.setKeyFields(k);}if(this._oExcludeFilterPanel){this._oExcludeFilterPanel.setKeyFields((Array.isArray(K)&&K.length>0)?K:k);}};
h.prototype.getKeyFields=function(){return this._aKeyFields;};
h.prototype.setMaxIncludes=function(m){this.setProperty("maxIncludes",m);if(this._oIncludeFilterPanel){this._oIncludeFilterPanel.setMaxConditions(m);}this._updatePanel();return this;};
h.prototype.setMaxExcludes=function(m){this.setProperty("maxExcludes",m);if(this._oExcludeFilterPanel){this._oExcludeFilterPanel.setMaxConditions(m);}this._updatePanel();return this;};
h.prototype._updatePanel=function(){var m=this.getMaxIncludes()==="-1"?1000:parseInt(this.getMaxIncludes());var M=this.getMaxExcludes()==="-1"?1000:parseInt(this.getMaxExcludes());if(m>0){if(M<=0){this._oIncludePanel.setHeaderText(null);this._oIncludePanel.setExpandable(false);this._oIncludePanel.addStyleClass("panelTopMargin");this._oIncludePanel.addStyleClass("panelNoHeader");}}if(M===0){this._oExcludePanel.setHeaderText(null);this._oExcludePanel.setExpandable(false);this._oExcludePanel.addStyleClass("panelNoHeader");}};
h.prototype.init=function(){this.setType(f.filter);this.setTitle(sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("FILTERPANEL_TITLE"));sap.ui.getCore().loadLibrary("sap.ui.layout");this._aKeyFields=[];this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._aIncludeOperations={};this._aExcludeOperations={};this._oIncludePanel=new b({expanded:true,expandable:true,headerText:this._oRb.getText("FILTERPANEL_INCLUDES"),width:"auto"}).addStyleClass("sapMFilterPadding");this._oIncludeFilterPanel=new P({maxConditions:this.getMaxIncludes(),alwaysShowAddIcon:false,layoutMode:this.getLayoutMode(),dataChange:this._handleDataChange()});this._oIncludeFilterPanel._sAddRemoveIconTooltipKey="FILTER";this._oIncludePanel.addContent(this._oIncludeFilterPanel);this.addAggregation("content",this._oIncludePanel);this._oExcludePanel=new b({expanded:false,expandable:true,headerText:this._oRb.getText("FILTERPANEL_EXCLUDES"),width:"auto"}).addStyleClass("sapMFilterPadding");this._oExcludeFilterPanel=new P({exclude:true,maxConditions:this.getMaxExcludes(),alwaysShowAddIcon:false,layoutMode:this.getLayoutMode(),dataChange:this._handleDataChange()});this._oExcludeFilterPanel._sAddRemoveIconTooltipKey="FILTER";if(!this._oOperationsHelper){this._oOperationsHelper=new d();}this._updateOperations();var t;for(t in this._aExcludeOperations){this._oExcludeFilterPanel.setOperations(this._aExcludeOperations[t],t);}for(t in this._aIncludeOperations){this._oIncludeFilterPanel.setOperations(this._aIncludeOperations[t],t);}this._oExcludePanel.addContent(this._oExcludeFilterPanel);this.addAggregation("content",this._oExcludePanel);this._updatePanel();};
h.prototype.exit=function(){var i=function(o){if(o&&o.destroy){o.destroy();}return null;};this._oOperationsHelper=i(this._oOperationsHelper);this._aKeyFields=i(this._aKeyFields);this._aIncludeOperations=i(this._aIncludeOperations);this._aExcludeOperations=i(this._aExcludeOperations);this._oRb=i(this._oRb);};
h.prototype.onBeforeRendering=function(){var k=[],K,m,E=this.getEnableEmptyOperations();if(this._bUpdateRequired){this._bUpdateRequired=false;var M=this.getMessageStrip();if(M){M.addStyleClass("sapUiResponsiveMargin");this.insertAggregation("content",M,0);}K=[];m=(this.getBindingInfo("items")||{}).model;var G=function(n,o,i){var B=i.getBinding(n),j;if(B&&o){return o.getObject()[B.getPath()];}j=i.getMetadata();return j.hasProperty(n)?j.getProperty(n).get(i):j.getAggregation(n).get(i);};this.getItems().forEach(function(i){var o=i.getBindingContext(m),F,n,j;if(i.getBinding("key")){o.getObject()[i.getBinding("key").getPath()]=i.getKey();}K.push(F={key:i.getColumnKey(),text:G("text",o,i),tooltip:G("tooltip",o,i),maxLength:G("maxLength",o,i),type:G("type",o,i),typeInstance:G("typeInstance",o,i),formatSettings:G("formatSettings",o,i),precision:G("precision",o,i),scale:G("scale",o,i),isDefault:G("isDefault",o,i),values:G("values",o,i)});if(E){n=i.getNullable();j={};Object.keys(F).forEach(function(s){j[s]=F[s];});k.push(j);this._enhanceFieldOperationsWithEmpty(j,n,true);this._enhanceFieldOperationsWithEmpty(F,n);this._modifyFieldOperationsBasedOnMaxLength(j);}this._modifyFieldOperationsBasedOnMaxLength(F);},this);this.setKeyFields(K,k);var C=[];m=(this.getBindingInfo("filterItems")||{}).model;this.getFilterItems().forEach(function(F){var o=F.getBindingContext(m);if(F.getBinding("key")&&o){o.getObject()[F.getBinding("key").getPath()]=F.getKey();}C.push({key:F.getKey(),keyField:G("columnKey",o,F),operation:G("operation",o,F),value1:G("value1",o,F),value2:G("value2",o,F),exclude:G("exclude",o,F)});});this.setConditions(C);}};
h.prototype._updateOperations=function(){this._oOperationsHelper.getIncludeTypes().forEach(function(t){this.setIncludeOperations(this._oOperationsHelper.getIncludeOperationsByType(t),t);}.bind(this));this._oOperationsHelper.getExcludeTypes().forEach(function(t){this.setExcludeOperations(this._oOperationsHelper.getExcludeOperationsByType(t),t);}.bind(this));};
h.prototype._enableEnhancedExcludeOperations=function(){if(this._oOperationsHelper){this._oOperationsHelper.setUseExcludeOperationsExtended();}this._updateOperations();};
h.prototype._modifyFieldOperationsBasedOnMaxLength=function(F){var o;if(F.maxLength===1||F.maxLength==="1"){o=F.operations?F.operations:this._oIncludeFilterPanel.getOperations(F.type);F.operations=[];o.forEach(function(O){if([g.Contains,g.StartsWith,g.EndsWith].indexOf(O)===-1){F.operations.push(O);}},this);}};
h.prototype._enhanceFieldOperationsWithEmpty=function(F,n,E){var o,O;if(["string","stringdate"].indexOf(F.type)>-1||(["date","datetime"].indexOf(F.type)>-1&&n)){o=this[E?"_oExcludeFilterPanel":"_oIncludeFilterPanel"];O=o.getOperations(F.type);if(!O){O=o.getOperations();}if(!Array.isArray(F.operations)){F.operations=[];}O.forEach(function(s){F.operations.push(s);});if(F.operations.indexOf(g.Empty)===-1){F.operations.push(g.Empty);}}};
h.prototype.addItem=function(i){a.prototype.addItem.apply(this,arguments);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
h.prototype.removeItem=function(i){var r=a.prototype.removeItem.apply(this,arguments);this._bUpdateRequired=true;return r;};
h.prototype.destroyItems=function(){this.destroyAggregation("items");if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
h.prototype.addFilterItem=function(F){this.addAggregation("filterItems",F,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
h.prototype.insertFilterItem=function(F,i){this.insertAggregation("filterItems",F,i,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
h.prototype.updateFilterItems=function(r){this.updateAggregation("filterItems");if(r==="change"&&!this._bIgnoreBindCalls){this._bUpdateRequired=true;this.invalidate();}};
h.prototype.setMessageStrip=function(m){this.setAggregation("messageStrip",m,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
h.prototype.updateMessageStrip=function(r){this.updateAggregation("messageStrip");if(r==="change"&&!this._bIgnoreBindCalls){this._bUpdateRequired=true;}};
h.prototype.removeFilterItem=function(F){F=this.removeAggregation("filterItems",F,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return F;};
h.prototype.removeAllFilterItems=function(){var F=this.removeAllAggregation("filterItems",true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return F;};
h.prototype.destroyFilterItems=function(){this.destroyAggregation("filterItems");if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
h.prototype._handleDataChange=function(){var t=this;return function(E){var n=E.getParameter("newData");var o=E.getParameter("operation");var k=E.getParameter("key");var C=E.getParameter("index");var F;var I=-1;var j=E.getSource()===t._oExcludeFilterPanel;t.getFilterItems().some(function(m,i){if((!m.getExclude()&&!j)||(m.getExclude()&&j)){C--;}I=i;return C<0;},this);switch(o){case"update":F=t.getFilterItems()[I];if(F){F.setExclude(n.exclude);F.setColumnKey(n.keyField);F.setOperation(n.operation);F.setValue1(n.value1);F.setValue2(n.value2);}t.fireUpdateFilterItem({key:k,index:I,filterItemData:F});t.fireFilterItemChanged({reason:"updated",key:k,index:I,itemData:{columnKey:n.keyField,operation:n.operation,exclude:n.exclude,value1:n.value1,value2:n.value2}});break;case"add":if(C>=0){I++;}F=new c({columnKey:n.keyField,exclude:n.exclude,operation:n.operation});F.setValue1(n.value1);F.setValue2(n.value2);t._bIgnoreBindCalls=true;t.fireAddFilterItem({key:k,index:I,filterItemData:F});t.fireFilterItemChanged({reason:"added",key:k,index:I,itemData:{columnKey:n.keyField,operation:n.operation,exclude:n.exclude,value1:n.value1,value2:n.value2}});t._bIgnoreBindCalls=false;break;case"remove":t._bIgnoreBindCalls=true;t.fireRemoveFilterItem({key:k,index:I});t.fireFilterItemChanged({reason:"removed",key:k,index:I});t._bIgnoreBindCalls=false;break;default:throw"Operation'"+o+"' is not supported yet";}t._notifyChange();};};
h.prototype._notifyChange=function(){var L=this.getChangeNotifier();if(L){L(this);}};
return h;});
sap.ui.predefine('sap/m/P13nGroupItem',['./library','sap/ui/core/Item'],function(l,I){"use strict";
var P=I.extend("sap.m.P13nGroupItem",{metadata:{library:"sap.m",properties:{operation:{type:"string",group:"Misc",defaultValue:null},columnKey:{type:"string",group:"Misc",defaultValue:null},showIfGrouped:{type:"boolean",group:"Misc",defaultValue:false}}}});
P.prototype.setColumnKey=function(v){return this.setProperty("columnKey",v,true);};
P.prototype.setOperation=function(v){return this.setProperty("operation",v,true);};
P.prototype.setShowIfGrouped=function(v){return this.setProperty("showIfGrouped",v,true);};
return P;});
sap.ui.predefine('sap/m/P13nGroupPanel',['./library','./P13nConditionPanel','./P13nPanel','./P13nGroupItem',"sap/ui/thirdparty/jquery"],function(l,P,a,c,q){"use strict";var d=l.P13nPanelType;var e=l.P13nConditionOperation;
var f=a.extend("sap.m.P13nGroupPanel",{
metadata:{library:"sap.m",properties:{maxGroups:{type:"string",group:"Misc",defaultValue:'-1'},containerQuery:{type:"boolean",group:"Misc",defaultValue:false},layoutMode:{type:"string",group:"Misc",defaultValue:null}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"},groupItems:{type:"sap.m.P13nGroupItem",multiple:true,singularName:"groupItem",bindable:"bindable"}},events:{addGroupItem:{parameters:{}},removeGroupItem:{},updateGroupItem:{}}},
renderer:{apiVersion:2,render:function(r,C){r.openStart("section",C);r.class("sapMGroupPanel");r.openEnd();r.openStart("div");r.class("sapMGroupPanelContent");r.class("sapMGroupPanelBG");r.openEnd();C.getAggregation("content").forEach(function(o){r.renderControl(o);});r.close("div");r.close("section");}}
});
f.prototype.setMaxGroups=function(m){this.setProperty("maxGroups",m);if(this._oGroupPanel){this._oGroupPanel.setMaxConditions(m);}return this;};
f.prototype._getConditions=function(){return this._oGroupPanel.getConditions();};
f.prototype.setContainerQuery=function(b){this.setProperty("containerQuery",b);this._oGroupPanel.setContainerQuery(b);return this;};
f.prototype.setLayoutMode=function(m){this.setProperty("layoutMode",m);this._oGroupPanel.setLayoutMode(m);return this;};
f.prototype.validateConditions=function(){return this._oGroupPanel.validateConditions();};
f.prototype.removeInvalidConditions=function(){this._oGroupPanel.removeInvalidConditions();};
f.prototype.removeValidationErrors=function(){this._oGroupPanel.removeValidationErrors();};
f.prototype.onBeforeNavigationFrom=function(){return this.validateConditions();};
f.prototype.onAfterNavigationFrom=function(){return this.removeInvalidConditions();};
f.prototype.setOperations=function(o){this._aOperations=o;if(this._oGroupPanel){this._oGroupPanel.setOperations(this._aOperations);}};
f.prototype.init=function(){this.setType(d.group);this.setTitle(sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("GROUPPANEL_TITLE"));sap.ui.getCore().loadLibrary("sap.ui.layout");this._aKeyFields=[];if(!this._aOperations){this.setOperations([e.GroupAscending,e.GroupDescending]);}this._oGroupPanel=new P({maxConditions:this.getMaxGroups(),autoReduceKeyFieldItems:true,layoutMode:this.getLayoutMode(),dataChange:this._handleDataChange(),validationExecutor:q.proxy(this._callValidationExecutor,this)});this._oGroupPanel.setOperations(this._aOperations);this._oGroupPanel._sAddRemoveIconTooltipKey="GROUP";this.addAggregation("content",this._oGroupPanel);};
f.prototype.exit=function(){var b=function(o){if(o&&o.destroy){o.destroy();}return null;};this._aKeyFields=b(this._aKeyFields);this._aOperations=b(this._aOperations);};
f.prototype.onBeforeRendering=function(){if(this._bUpdateRequired){this._bUpdateRequired=false;var k=[];var m=(this.getBindingInfo("items")||{}).model;var g=function(n,o,i){var b=i.getBinding(n);if(b&&o){return o.getObject()[b.getPath()];}return i.getMetadata().getProperty(n)?i.getProperty(n):i.getAggregation(n);};this.getItems().forEach(function(i){var o=i.getBindingContext(m);if(i.getBinding("key")){o.getObject()[i.getBinding("key").getPath()]=i.getKey();}k.push({key:i.getColumnKey(),text:g("text",o,i),tooltip:g("tooltip",o,i)});});k.splice(0,0,{key:null,text:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_SELECTION_NONE")});this._oGroupPanel.setKeyFields(k);var C=[];m=(this.getBindingInfo("groupItems")||{}).model;this.getGroupItems().forEach(function(G){var o=G.getBindingContext(m);if(G.getBinding("key")){o.getObject()[G.getBinding("key").getPath()]=G.getKey();}C.push({key:G.getKey(),keyField:g("columnKey",o,G),operation:g("operation",o,G),showIfGrouped:g("showIfGrouped",o,G)});});this._oGroupPanel.setConditions(C);}};
f.prototype.addItem=function(i){a.prototype.addItem.apply(this,arguments);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
f.prototype.removeItem=function(i){var r=a.prototype.removeItem.apply(this,arguments);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return r;};
f.prototype.destroyItems=function(){this.destroyAggregation("items");if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
f.prototype.addGroupItem=function(g){this.addAggregation("groupItems",g,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
f.prototype.insertGroupItem=function(g,i){this.insertAggregation("groupItems",g,i,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
f.prototype.updateGroupItems=function(r){this.updateAggregation("groupItems");if(r==="change"&&!this._bIgnoreBindCalls){this._bUpdateRequired=true;this.invalidate();}};
f.prototype.removeGroupItem=function(g){g=this.removeAggregation("groupItems",g,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return g;};
f.prototype.removeAllGroupItems=function(){var g=this.removeAllAggregation("groupItems",true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return g;};
f.prototype.destroyGroupItems=function(){this.destroyAggregation("groupItems");if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
f.prototype._handleDataChange=function(){var t=this;return function(E){var n=E.getParameter("newData");var o=E.getParameter("operation");var k=E.getParameter("key");var i=E.getParameter("index");var g;if(o==="update"){g=t.getGroupItems()[i];if(g){g.setColumnKey(n.keyField);g.setOperation(n.operation);g.setShowIfGrouped(n.showIfGrouped);}t.fireUpdateGroupItem({key:k,index:i,groupItemData:g});t._notifyChange();}if(o==="add"){g=new c({key:k,columnKey:n.keyField,operation:n.operation,showIfGrouped:n.showIfGrouped});t._bIgnoreBindCalls=true;t.fireAddGroupItem({key:k,index:i,groupItemData:g});t._bIgnoreBindCalls=false;t._notifyChange();}if(o==="remove"){t._bIgnoreBindCalls=true;t.fireRemoveGroupItem({key:k,index:i});t._bIgnoreBindCalls=false;t._notifyChange();}};};
f.prototype.getOkPayload=function(){if(!this.getModel()){return null;}var s=[];this._oGroupPanel._oConditionsGrid.getContent().forEach(function(C){var o=C.keyField;s.push(o.getSelectedKey());});return{selectedColumnKeys:s};};
f.prototype._callValidationExecutor=function(){var v=this.getValidationExecutor();if(v){v();}};
f.prototype._updateValidationResult=function(v){this._oGroupPanel._oConditionsGrid.getContent().forEach(function(C){var o=C.keyField;o.setValueStateText("");o.setValueState("None");var s=o.getSelectedKey();v.forEach(function(r){if(r.columnKey===s){o.setValueStateText(r.messageText);o.setValueState(r.messageType);}});});};
f.prototype.setValidationListener=function(L){this.setProperty("validationListener",L);if(L){L(this,q.proxy(this._updateValidationResult,this));}return this;};
f.prototype._notifyChange=function(){var L=this.getChangeNotifier();if(L){L(this);}};
return f;});
sap.ui.predefine('sap/m/P13nItem',['./library','sap/ui/core/Element'],function(l,E){"use strict";
var P=E.extend("sap.m.P13nItem",{metadata:{library:"sap.m",properties:{columnKey:{type:"string",group:"Data",defaultValue:null},text:{type:"string",group:"Misc",defaultValue:""},visible:{type:"boolean",group:"Misc",defaultValue:null},type:{type:"string",group:"Misc",defaultValue:"text"},typeInstance:{type:"object",group:"Misc",defaultValue:null,since:"1.56"},precision:{type:"string",group:"Misc",defaultValue:null},formatSettings:{type:"object",group:"Misc",defaultValue:null,since:"1.52"},scale:{type:"string",group:"Misc",defaultValue:null},maxLength:{type:"string",group:"Misc",defaultValue:null},width:{type:"string",group:"Misc",defaultValue:null},isDefault:{type:"boolean",group:"Misc",defaultValue:false},values:{type:"string[]",group:"Misc",defaultValue:null},role:{type:"string",defaultValue:null},aggregationRole:{type:"string",defaultValue:null},href:{type:"string",defaultValue:null},target:{type:"string",defaultValue:null},press:{type:"object",defaultValue:null},description:{type:"string",defaultValue:null},nullable:{type:"boolean",group:"Misc",defaultValue:false}}}});
return P;});
sap.ui.predefine('sap/m/P13nOperationsHelper',["./library"],function(l){"use strict";var P=function(){this.init();};var O=l.P13nConditionOperation;P.prototype.oIncludeOperations={"default":[O.EQ,O.BT,O.LT,O.LE,O.GT,O.GE],"string":[O.Contains,O.EQ,O.BT,O.StartsWith,O.EndsWith,O.LT,O.LE,O.GT,O.GE],"date":[O.EQ,O.BT,O.LT,O.LE,O.GT,O.GE],"time":[O.EQ,O.BT,O.LT,O.LE,O.GT,O.GE],"datetime":[O.EQ,O.BT,O.LT,O.LE,O.GT,O.GE],"numeric":[O.EQ,O.BT,O.LT,O.LE,O.GT,O.GE],"numc":[O.Contains,O.EQ,O.BT,O.EndsWith,O.LT,O.LE,O.GT,O.GE],"boolean":[O.EQ]};P.prototype.oExcludeOperationsDefault={"default":[O.EQ]};P.prototype.oExcludeOperationsExtended={"default":[O.EQ,O.BT,O.LT,O.LE,O.GT,O.GE],"string":[O.Contains,O.EQ,O.BT,O.StartsWith,O.EndsWith,O.LT,O.LE,O.GT,O.GE],"date":[O.EQ,O.BT,O.LT,O.LE,O.GT,O.GE],"time":[O.EQ,O.BT,O.LT,O.LE,O.GT,O.GE],"datetime":[O.EQ,O.BT,O.LT,O.LE,O.GT,O.GE],"numeric":[O.EQ,O.BT,O.LT,O.LE,O.GT,O.GE],"numc":[O.Contains,O.EQ,O.BT,O.EndsWith,O.LT,O.LE,O.GT,O.GE],"boolean":[O.EQ]};
P.prototype.init=function(){this.oExcludeOperations=this.oExcludeOperationsDefault;};
P.prototype.setUseExcludeOperationsExtended=function(){this.oExcludeOperations=this.oExcludeOperationsExtended;};
P.prototype.getIncludeOperationsByType=function(t){if(!t){t="default";}return this.oIncludeOperations[t].map(function(o){return o;});};
P.prototype.getExcludeOperationsByType=function(t){if(!t){t="default";}return this.oExcludeOperations[t].map(function(o){return o;});};
P.prototype.getIncludeTypes=function(){return Object.keys(this.oIncludeOperations);};
P.prototype.getExcludeTypes=function(){return Object.keys(this.oExcludeOperations);};
return P;},true);
sap.ui.predefine('sap/m/P13nPanel',['./library','sap/ui/core/Control'],function(l,C){"use strict";
var P=C.extend("sap.m.P13nPanel",{
metadata:{"abstract":true,library:"sap.m",properties:{title:{type:"string",group:"Appearance",defaultValue:null},titleLarge:{type:"string",group:"Appearance",defaultValue:null},type:{type:"string",group:"Misc",defaultValue:null},verticalScrolling:{type:"boolean",group:"Misc",defaultValue:true},validationExecutor:{type:"object",group:"Misc",defaultValue:null},validationListener:{type:"object",group:"Misc",defaultValue:null},changeNotifier:{type:"object",group:"Misc",defaultValue:null}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.P13nItem",multiple:true,singularName:"item",bindable:"bindable"}},events:{beforeNavigationTo:{}}},
renderer:{apiVersion:2,render:function(r,c){r.openStart("span",c);r.class("sapMP13nPanel");r.openEnd();r.close("span");}}
});
P.prototype.getOkPayload=function(){return{};};
P.prototype.getResetPayload=function(){return{};};
P.prototype.beforeNavigationTo=function(){this.fireBeforeNavigationTo();};
P.prototype.onBeforeNavigationFrom=function(){return true;};
P.prototype.onAfterNavigationFrom=function(){};
return P;});
sap.ui.predefine('sap/m/P13nSelectionItem',['./library','sap/ui/core/Item'],function(l,I){"use strict";
var P=I.extend("sap.m.P13nSelectionItem",{metadata:{library:"sap.m",properties:{columnKey:{type:"string",defaultValue:undefined},selected:{type:"boolean",defaultValue:false}}}});
return P;});
sap.ui.predefine('sap/m/P13nSelectionPanel',['./library','./ColumnListItem','./P13nPanel','./SearchField','./Text','./Table','./Column','./ScrollContainer','./P13nSelectionItem','./VBox','./Link','./OverflowToolbar','./OverflowToolbarLayoutData','./ToolbarSpacer','sap/ui/core/library','sap/ui/model/ChangeReason','sap/ui/model/json/JSONModel','sap/ui/model/BindingMode','sap/ui/core/ResizeHandler',"sap/ui/thirdparty/jquery"],function(l,C,P,S,T,a,b,c,d,V,L,O,e,f,g,h,J,B,R,q){"use strict";var i=l.ToolbarDesign;var j=l.ListType;var k=l.ListMode;var m=l.P13nPanelType;
var n=P.extend("sap.m.P13nSelectionPanel",{
metadata:{library:"sap.m",aggregations:{selectionItems:{type:"sap.m.P13nSelectionItem",multiple:true,singularName:"selectionItem",bindable:"bindable"},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"}},events:{changeSelectionItems:{parameters:{items:{type:"object[]"}}}}},
renderer:{apiVersion:2,render:function(r,o){r.openStart("div",o);r.class("sapMP13nColumnsPanel");r.openEnd();o.getAggregation("content").forEach(function(p){r.renderControl(p);});r.close("div");}}
});
n.prototype.init=function(){this._iLiveChangeTimer=0;this._iSearchTimer=0;this._bIgnoreUpdateInternalModel=false;this._bUpdateInternalModel=true;this._bOnAfterRenderingFirstTimeExecuted=false;var M=new J({items:[],countOfSelectedItems:0,countOfItems:0});M.setDefaultBindingMode(B.TwoWay);M.setSizeLimit(1000);this.setModel(M,"$sapmP13nSelectionPanel");this.setType(m.selection);this._createTable();this._createToolbar();this.setVerticalScrolling(false);var s=new c({horizontal:false,vertical:true,content:[this._oTable],width:'100%',height:'100%'});this.addAggregation("content",s);var t=this;this._fnHandleResize=function(){var o=false,p,r;if(t.getParent){var $=null,u,H;var v=t.getParent();var w=t._getToolbar();if(v&&v.$){$=v.$("cont");if($.children().length>0&&w.$().length>0){p=s.$()[0].clientHeight;u=$.children()[0].clientHeight;H=w?w.$()[0].clientHeight:0;r=u-H;if(p!==r){s.setHeight(r+'px');o=true;}}}}return o;};this._sContainerResizeListener=R.register(s,this._fnHandleResize);};
n.prototype.onBeforeRendering=function(){this._updateInternalModel();};
n.prototype.onAfterRendering=function(){var t=this;if(!this._bOnAfterRenderingFirstTimeExecuted){this._bOnAfterRenderingFirstTimeExecuted=true;window.clearTimeout(this._iLiveChangeTimer);this._iLiveChangeTimer=window.setTimeout(function(){t._fnHandleResize();},0);}};
n.prototype.getOkPayload=function(){this._updateInternalModel();var M=this._getInternalModel().getProperty("/items");return{selectionItems:M.map(function(o){return{columnKey:o.columnKey,selected:o.persistentSelected};})};};
n.prototype.exit=function(){R.deregister(this._sContainerResizeListener);this._sContainerResizeListener=null;this._getToolbar().destroy();this._oTable.destroy();this._oTable=null;if(this._getInternalModel()){this._getInternalModel().destroy();}window.clearTimeout(this._iLiveChangeTimer);window.clearTimeout(this._iSearchTimer);};
n.prototype.addItem=function(I){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.addAggregation("items",I);return this;};
n.prototype.insertItem=function(I,o){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.insertAggregation("items",I,o);return this;};
n.prototype.removeItem=function(I){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}I=this.removeAggregation("items",I);return I;};
n.prototype.removeAllItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAllAggregation("items");};
n.prototype.destroyItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.destroyAggregation("items");return this;};
n.prototype.addSelectionItem=function(s){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.addAggregation("selectionItems",s);return this;};
n.prototype.insertSelectionItem=function(s,I){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.insertAggregation("selectionItems",s,I);return this;};
n.prototype.updateSelectionItems=function(r){this.updateAggregation("selectionItems");if(r===h.Change&&!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}};
n.prototype.removeSelectionItem=function(s){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAggregation("selectionItems",s);};
n.prototype.removeAllSelectionItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}return this.removeAllAggregation("selectionItems");};
n.prototype.destroySelectionItems=function(){if(!this._bIgnoreUpdateInternalModel){this._bUpdateInternalModel=true;}this.destroyAggregation("selectionItems");return this;};
n.prototype.onBeforeNavigationFrom=function(){return true;};
n.prototype._notifyChange=function(){var o=this.getChangeNotifier();if(o){o(this);}};
n.prototype._getInternalModel=function(){return this.getModel("$sapmP13nSelectionPanel");};
n.prototype._createTable=function(){var t=this;this._oTable=new a({mode:k.MultiSelect,rememberSelections:false,selectionChange:q.proxy(this._onSelectionChange,this),columns:[new b({vAlign:g.VerticalAlign.Middle,header:new T({text:{parts:[{path:'/countOfSelectedItems'},{path:'/countOfItems'}],formatter:function(o,p){return sap.ui.getCore().getLibraryResourceBundle("sap.m").getText('COLUMNSPANEL_SELECT_ALL_WITH_COUNTER',[o,p]);}}})})],items:{path:"/items",templateShareable:false,template:new C({cells:new V({items:[new L({href:"{href}",text:"{text}",target:"{target}",enabled:{path:'href',formatter:function(v){if(!v){this.addStyleClass("sapUiCompSmartLink");}return!!v;}},press:function(E){var H=E.getSource().getHref();var I=t.getItems().filter(function(o){return o.getHref()===H&&!!o.getPress();});if(!I.length){return;}var p=I[0].getPress();p(E);}}),new T({visible:{path:'description',formatter:function(D){return!!D;}},text:"{description}"})]}),visible:"{visible}",selected:"{persistentSelected}",tooltip:"{tooltip}",type:j.Active})}});this._oTable.setModel(this._getInternalModel());};
n.prototype._createToolbar=function(){var t=this;var o=new O(this.getId()+"-toolbar",{design:i.Auto,content:[new f(),new S(this.getId()+"-searchField",{liveChange:function(E){var v=E.getSource().getValue(),D=(v?300:0);window.clearTimeout(t._iSearchTimer);if(D){t._iSearchTimer=window.setTimeout(function(){t._onExecuteSearch();},D);}else{t._onExecuteSearch();}},search:q.proxy(this._onExecuteSearch,this),layoutData:new e({minWidth:"12.5rem",maxWidth:"23.077rem",shrinkable:true,moveToOverflow:false,stayInOverflow:false})})]});o.setModel(this._getInternalModel());this.addAggregation("content",o);};
n.prototype._onExecuteSearch=function(){this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();this._updateControlLogic();};
n.prototype._switchVisibilityOfUnselectedModelItems=function(){var s=this._isFilteredByShowSelected();var M=this._getInternalModel().getProperty("/items");M.forEach(function(o){if(o.persistentSelected){o.visible=true;return;}o.visible=!s;});this._getInternalModel().setProperty("/items",M);};
n.prototype._getVisibleModelItems=function(){return this._getInternalModel().getProperty("/items").filter(function(M){return!!M.visible;});};
n.prototype._getModelItemByColumnKey=function(s){var M=this._getInternalModel().getProperty("/items").filter(function(o){return o.columnKey===s;});return M[0];};
n.prototype._updateCounts=function(M){var o=0;var p=0;M.forEach(function(r){o++;if(r.persistentSelected){p++;}});this._getInternalModel().setProperty("/countOfItems",o);this._getInternalModel().setProperty("/countOfSelectedItems",p);};
n.prototype._getToolbar=function(){return sap.ui.getCore().byId(this.getId()+"-toolbar")||null;};
n.prototype._getSearchField=function(){return sap.ui.getCore().byId(this.getId()+"-searchField")||null;};
n.prototype._getSearchText=function(){var s=this._getSearchField();return s?s.getValue():"";};
n.prototype._isFilteredBySearchText=function(){return!!this._getSearchText().length;};
n.prototype._isFilteredByShowSelected=function(){return false;};
n.prototype._updateControlLogic=function(){var I=this._isFilteredBySearchText();var s=this._isFilteredByShowSelected();var t=sap.ui.getCore().byId(this._oTable.getId()+'-sa');if(t){t.setEnabled(!I&&!s);}};
n.prototype._fireChangeSelectionItems=function(){this._bIgnoreUpdateInternalModel=true;var M=this._getInternalModel().getProperty("/items");this.fireChangeSelectionItems({items:M.map(function(o){return{columnKey:o.columnKey,selected:o.persistentSelected};})});this._bIgnoreUpdateInternalModel=false;};
n.prototype._onSelectionChange=function(){this._selectTableItem();};
n.prototype._selectTableItem=function(){var M=this._getInternalModel().getProperty("/items");this._updateCounts(M);this._getInternalModel().setProperty("/items",M);this._fireChangeSelectionItems();this._notifyChange();};
n.prototype._filterModelItemsBySearchText=function(){var s=this._getSearchText();s=s.replace(/(^\s+)|(\s+$)/g,'');s=s.replace(/[-\/\\^$*+?.()|[\]{}]/g,'\\$&');var r=new RegExp(s,'igm');this._getVisibleModelItems().forEach(function(M){M.visible=false;if(M.text&&M.text.match(r)){M.visible=true;}if(M.tooltip&&M.tooltip.match(r)){M.visible=true;}});this._getInternalModel().refresh();};
n.prototype._updateInternalModel=function(){if(!this._bUpdateInternalModel){return;}this._bUpdateInternalModel=false;this._getInternalModel().setProperty("/items",this.getItems().map(function(I){return{columnKey:I.getColumnKey(),visible:true,text:I.getText(),tooltip:I.getTooltip(),href:I.getHref(),target:I.getTarget(),persistentSelected:I.getVisible(),description:I.getDescription()};},this));this.getSelectionItems().forEach(function(s){var o=this._getModelItemByColumnKey(s.getColumnKey());if(!o){return;}if(s.getSelected()!==undefined){o.persistentSelected=s.getSelected();}},this);this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();var M=this._getInternalModel().getProperty("/items");this._updateCounts(M);this._getInternalModel().setProperty("/items",M);};
return n;});
sap.ui.predefine('sap/m/P13nSortItem',['./library','sap/ui/core/Item'],function(l,I){"use strict";
var P=I.extend("sap.m.P13nSortItem",{metadata:{library:"sap.m",properties:{operation:{type:"string",group:"Misc",defaultValue:null},columnKey:{type:"string",group:"Misc",defaultValue:null}}}});
P.prototype.setColumnKey=function(v){return this.setProperty("columnKey",v,true);};
P.prototype.setOperation=function(v){return this.setProperty("operation",v,true);};
return P;});
sap.ui.predefine('sap/m/P13nSortPanel',['./library','./P13nConditionPanel','./P13nPanel','./P13nSortItem'],function(l,P,a,c){"use strict";var d=l.P13nPanelType;var e=l.P13nConditionOperation;
var f=a.extend("sap.m.P13nSortPanel",{
metadata:{library:"sap.m",properties:{containerQuery:{type:"boolean",group:"Misc",defaultValue:false},layoutMode:{type:"string",group:"Misc",defaultValue:null}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"},sortItems:{type:"sap.m.P13nSortItem",multiple:true,singularName:"sortItem",bindable:"bindable"}},events:{addSortItem:{},removeSortItem:{},updateSortItem:{}}},
renderer:{apiVersion:2,render:function(r,C){r.openStart("section",C);r.class("sapMSortPanel");r.openEnd();r.openStart("div");r.class("sapMSortPanelContent");r.class("sapMSortPanelBG");r.openEnd();C.getAggregation("content").forEach(function(o){r.renderControl(o);});r.close("div");r.close("section");}}
});
f.prototype._getConditions=function(){return this._oSortPanel.getConditions();};
f.prototype.setContainerQuery=function(b){this.setProperty("containerQuery",b);this._oSortPanel.setContainerQuery(b);return this;};
f.prototype.setLayoutMode=function(m){this.setProperty("layoutMode",m);this._oSortPanel.setLayoutMode(m);return this;};
f.prototype.validateConditions=function(){return this._oSortPanel.validateConditions();};
f.prototype.removeInvalidConditions=function(){this._oSortPanel.removeInvalidConditions();};
f.prototype.removeValidationErrors=function(){this._oSortPanel.removeValidationErrors();};
f.prototype.onBeforeNavigationFrom=function(){return this.validateConditions();};
f.prototype.onAfterNavigationFrom=function(){return this.removeInvalidConditions();};
f.prototype.setOperations=function(o){this._aOperations=o;if(this._oSortPanel){this._oSortPanel.setOperations(this._aOperations);}return this;};
f.prototype.init=function(){this.setType(d.sort);this.setTitle(sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("SORTPANEL_TITLE"));sap.ui.getCore().loadLibrary("sap.ui.layout");this._aKeyFields=[];if(!this._aOperations){this.setOperations([e.Ascending,e.Descending]);}this._oSortPanel=new P({autoReduceKeyFieldItems:true,layoutMode:this.getLayoutMode(),dataChange:this._handleDataChange()});this._oSortPanel.setOperations(this._aOperations);this._oSortPanel._sAddRemoveIconTooltipKey="SORT";this.addAggregation("content",this._oSortPanel);};
f.prototype.exit=function(){var b=function(o){if(o&&o.destroy){o.destroy();}return null;};this._aKeyFields=b(this._aKeyFields);this._aOperations=b(this._aOperations);};
f.prototype.onBeforeRendering=function(){if(this._bUpdateRequired){this._bUpdateRequired=false;var k=[];var m=(this.getBindingInfo("items")||{}).model;var g=function(n,o,i){var b=i.getBinding(n);if(b&&o){return o.getObject()[b.getPath()];}return i.getMetadata().getProperty(n)?i.getProperty(n):i.getAggregation(n);};this.getItems().forEach(function(i){var o=i.getBindingContext(m);if(i.getBinding("key")){o.getObject()[i.getBinding("key").getPath()]=i.getKey();}k.push({key:i.getColumnKey(),text:g("text",o,i),tooltip:g("tooltip",o,i)});});k.splice(0,0,{key:null,text:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_SELECTION_NONE")});this._oSortPanel.setKeyFields(k);var C=[];m=(this.getBindingInfo("sortItems")||{}).model;this.getSortItems().forEach(function(s){var o=s.getBindingContext(m);if(s.getBinding("key")){o.getObject()[s.getBinding("key").getPath()]=s.getKey();}C.push({key:s.getKey(),keyField:g("columnKey",o,s),operation:g("operation",o,s)});});this._oSortPanel.setConditions(C);}};
f.prototype.addItem=function(i){a.prototype.addItem.apply(this,arguments);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
f.prototype.removeItem=function(i){var r=a.prototype.removeItem.apply(this,arguments);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return r;};
f.prototype.destroyItems=function(){this.destroyAggregation("items");if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
f.prototype.addSortItem=function(s){this.addAggregation("sortItems",s,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
f.prototype.insertSortItem=function(s,i){this.insertAggregation("sortItems",s,i,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
f.prototype.updateSortItems=function(r){this.updateAggregation("sortItems");if(r==="change"&&!this._bIgnoreBindCalls){this._bUpdateRequired=true;this.invalidate();}};
f.prototype.removeSortItem=function(s){s=this.removeAggregation("sortItems",s,true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return s;};
f.prototype.removeAllSortItems=function(){var s=this.removeAllAggregation("sortItems",true);if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return s;};
f.prototype.destroySortItems=function(){this.destroyAggregation("sortItems");if(!this._bIgnoreBindCalls){this._bUpdateRequired=true;}return this;};
f.prototype._handleDataChange=function(){var t=this;return function(E){var n=E.getParameter("newData");var o=E.getParameter("operation");var k=E.getParameter("key");var i=E.getParameter("index");var s;if(o==="update"){s=t.getSortItems()[i];if(s){s.setColumnKey(n.keyField);s.setOperation(n.operation);}t.fireUpdateSortItem({key:k,index:i,sortItemData:s});t._notifyChange();}if(o==="add"){s=new c({key:k,columnKey:n.keyField,operation:n.operation});t._bIgnoreBindCalls=true;t.fireAddSortItem({key:k,index:i,sortItemData:s});t._bIgnoreBindCalls=false;t._notifyChange();}if(o==="remove"){t._bIgnoreBindCalls=true;t.fireRemoveSortItem({key:k,index:i});t._bIgnoreBindCalls=false;t._notifyChange();}};};
f.prototype._notifyChange=function(){var L=this.getChangeNotifier();if(L){L(this);}};
return f;});
sap.ui.predefine('sap/m/QuickView',["./library","sap/ui/Device","sap/ui/core/IconPool","./QuickViewBase","./ResponsivePopover","./NavContainer","./Page","./Bar","./Button"],function(l,D,I,Q,R,N,P,B,a){"use strict";var b=l.PlacementType;
var c=Q.extend("sap.m.QuickView",{
metadata:{library:"sap.m",properties:{placement:{type:"sap.m.PlacementType",group:"Misc",defaultValue:b.Right},width:{type:'sap.ui.core.CSSSize',group:'Dimension',defaultValue:'320px'}},aggregations:{},designtime:"sap/m/designtime/QuickView.designtime",events:{afterOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},afterClose:{parameters:{openBy:{type:"sap.ui.core.Control"},origin:{type:"sap.m.Button"}}},beforeOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},beforeClose:{parameters:{openBy:{type:"sap.ui.core.Control"},origin:{type:"sap.m.Button"}}}}},
renderer:{apiVersion:2,render:function(){}}
});
c.prototype.init=function(){var n={pages:[new P()],navigate:this._navigate.bind(this),afterNavigate:this._afterNavigate.bind(this)};this._oNavContainer=new N(n);var t=this;this._oPopover=new R(this.getId()+'-quickView',{placement:this.getPlacement(),content:[this._oNavContainer],contentWidth:this.getWidth(),showHeader:false,showCloseButton:false,afterOpen:function(e){t._afterOpen(e);t.fireAfterOpen({openBy:e.getParameter("openBy")});},afterClose:function(e){t.fireAfterClose({openBy:e.getParameter("openBy"),origin:t.getCloseButton()});},beforeOpen:function(e){t.fireBeforeOpen({openBy:e.getParameter("openBy")});},beforeClose:function(e){t.fireBeforeClose({openBy:e.getParameter("openBy"),origin:t.getCloseButton()});t._bRendered=false;}});this._oPopover.addStyleClass("sapMQuickView");var p=this._oPopover.getAggregation("_popup");p.addEventDelegate({onBeforeRendering:this._initializeQuickView,onAfterRendering:this._setLinkWidth,onkeydown:this._onPopupKeyDown},this);var t=this;var s=p._fnAdjustPositionAndArrow;if(s){p._fnAdjustPositionAndArrow=function(){s.apply(p,arguments);t._adjustContainerHeight();};}this._bItemsChanged=true;};
c.prototype._initializeQuickView=function(){this._bRendered=true;if(this._bItemsChanged){this._clearContainerHeight();this._initPages();var p=this._oNavContainer.getCurrentPage();if(p){var h=p.getCustomHeader();if(h){this._oPopover.addAriaDescribedBy(h.getId());}}var d=this.getAggregation("pages");if(!d&&D.system.phone){this._addEmptyPage();}this._bItemsChanged=false;}};
c.prototype.exit=function(){this._bRendered=false;this._bItemsChanged=true;if(this._oPopover){this._oPopover.destroy();this._oPopover=null;}};
c.prototype.invalidate=function(){};
c.prototype._createPage=function(q){return q._createPage();};
c.prototype._onPopupKeyDown=function(e){this._processKeyboard(e);};
c.prototype._afterOpen=function(e){if(D.system.phone){this._restoreFocus();}};
c.prototype._addEmptyPage=function(){var p=new P({customHeader:new B().addStyleClass("sapMQuickViewHeader")});var t=this;var C=p.getCustomHeader();C.addContentRight(new a({icon:I.getIconURI("decline"),press:function(){t._oPopover.close();}}));p.addStyleClass('sapMQuickViewPage');this._oNavContainer.addPage(p);};
c.prototype._clearContainerHeight=function(){var p=this._oPopover.getAggregation("_popup");var $=p.$().find('.sapMPopoverCont');if($[0]&&$[0].style.height){$[0].style.height='';}};
c.prototype._adjustContainerHeight=function(){if(this.getPages().length<=1){return;}var p=this._oPopover.getAggregation("_popup");var $=p.$().find('.sapMPopoverCont');if($[0]&&!$[0].style.height){$[0].style.height=$.height()+'px';}};
c.prototype._setLinkWidth=function(){this._oPopover.$().find(".sapMLnk").css("width","auto");};
c.prototype.getCloseButton=function(){if(!D.system.phone){return undefined;}var p=this._oNavContainer.getCurrentPage();var o=p.getCustomHeader().getContentRight()[0];return o;};
c.prototype.setPlacement=function(p){this.setProperty("placement",p,true);this._oPopover.setPlacement(p);return this;};
c.prototype.setWidth=function(w){if(this._oPopover){this._oPopover.setContentWidth(w);this.setProperty('width',w,true);}return this;};
c.prototype.openBy=function(C){this._bItemsChanged=true;this._oPopover.openBy(C);return this;};
c.prototype.close=function(){this._oPopover.close();return this;};
c.prototype.getDomRef=function(s){return this._oPopover&&this._oPopover.getAggregation("_popup").getDomRef(s);};
["addStyleClass","removeStyleClass","toggleStyleClass","hasStyleClass","getBusyIndicatorDelay","setBusyIndicatorDelay","getVisible","setVisible","getFieldGroupIds","setFieldGroupIds","getBusy","setBusy","setTooltip","getTooltip"].forEach(function(n){c.prototype[n]=function(){if(this._oPopover&&this._oPopover[n]){var r=this._oPopover.getAggregation("_popup")[n].apply(this._oPopover.getAggregation("_popup"),arguments);return r===this._oPopover.getAggregation("_popup")?this:r;}};});["setModel","bindAggregation","setAggregation","insertAggregation","addAggregation","removeAggregation","removeAllAggregation","destroyAggregation"].forEach(function(f){c.prototype["_"+f+"Old"]=c.prototype[f];c.prototype[f]=function(){var n=[],r,i;for(i=0;i<arguments.length;i++){n.push(arguments[i]);}if(["setModel","bindAggregation"].indexOf(f)===-1){n.push(true);}r=c.prototype["_"+f+"Old"].apply(this,n);this._bItemsChanged=true;if(this._oPopover){if(arguments[0]!=="pages"){this._oPopover[f].apply(this._oPopover,arguments);}if(this._bRendered){this._initializeQuickView();}}if(["removeAggregation","removeAllAggregation"].indexOf(f)!==-1){return r;}return this;};});return c;});
sap.ui.predefine('sap/m/QuickViewBase',["./library","sap/ui/core/Control","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/Focusable"],function(l,C,K,q){"use strict";
var Q=C.extend("sap.m.QuickViewBase",{
metadata:{library:"sap.m",properties:{},defaultAggregation:"pages",aggregations:{pages:{type:"sap.m.QuickViewPage",multiple:true,singularName:"page",bindable:"bindable"}},events:{navigate:{allowPreventDefault:true,parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"},navOrigin:{type:"sap.ui.core.Control"}}},afterNavigate:{parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"},isTopPage:{type:"boolean"},navOrigin:{type:"sap.ui.core.Control"}}}}},
renderer:{apiVersion:2,render:function(){}}
});
Q.prototype.navigateBack=function(){if(!this._oNavContainer.currentPageIsTopPage()){this._setNavOrigin(null);this._oNavContainer.back();}};
Q.prototype.getNavContainer=function(){return this._oNavContainer;};
Q.prototype._initPages=function(){var n=this._oNavContainer;n.destroyPages();n.init();var p=this.getAggregation("pages");if(!p){return;}var I=this.getId();for(var i=0;i<p.length;i++){var o=p[i];o._oPage=null;var N={hasBackButton:i>0,popover:this._oPopover,navContainer:n,quickViewId:I,quickView:this};o.setNavContext(N);var P=this._createPage(o);this._oNavContainer.addPage(P);}};
Q.prototype._processKeyboard=function(e){if(e.shiftKey&&e.which===K.ENTER){this.navigateBack();e.preventDefault();}};
Q.prototype._createPage=function(o){return o;};
Q.prototype._navigate=function(e){var t=e.getParameter('to');var f=e.getParameter('from');var T=e.getParameter('toId');var F=e.getParameter('fromId');var i=q(document.getElementById(F)).index();var a=q(document.getElementById(T)).index();if(a==-1||a>i){t.addStyleClass('sapMNavItemOffset');}else{f.addStyleClass('sapMNavItemOffset');}f.$().parents('.sapMPanelContent').scrollTop(0);var p=e.getParameters();if(this._navOrigin){p.navOrigin=this._navOrigin;}this.fireNavigate(p);};
Q.prototype._afterNavigate=function(e){var t=e.getParameter('to');var f=e.getParameter('from');var T=e.getParameter('toId');var F=e.getParameter('fromId');var i=q(document.getElementById(F)).index();var a=q(document.getElementById(T)).index();if(a>i){t.removeStyleClass('sapMNavItemOffset');}else{f.removeStyleClass('sapMNavItemOffset');}var p=e.getParameters();p.isTopPage=this._oNavContainer.currentPageIsTopPage();if(this._navOrigin){p.navOrigin=this._navOrigin;}this.fireAfterNavigate(p);this._setLinkWidth();setTimeout(this._restoreFocus.bind(this),0);};
Q.prototype._restoreFocus=function(){var p=this._oNavContainer.getCurrentPage();var f=this._oNavContainer._mFocusObject[p.getId()];if(!f){var c=p.getContent();if(c&&c.length>1){f=c[1].$().firstFocusableDomRef();}}if(f){f.focus();}};
Q.prototype._setLinkWidth=function(){};
Q.prototype._setNavOrigin=function(c){this._navOrigin=c;};
return Q;});
sap.ui.predefine('sap/m/QuickViewCard',["./library","./QuickViewBase","./NavContainer","./Page","./ScrollContainer","./QuickViewCardRenderer"],function(l,Q,N,P,S,a){"use strict";
var b=Q.extend("sap.m.QuickViewCard",{metadata:{library:"sap.m",properties:{showVerticalScrollBar:{type:"boolean",group:"Behavior",defaultValue:true}},designtime:"sap/m/designtime/QuickViewCard.designtime"}});
b.prototype.init=function(){var n={pages:[new P()],navigate:this._navigate.bind(this),afterNavigate:this._afterNavigate.bind(this)};this._oNavContainer=new N(n);};
b.prototype.onBeforeRendering=function(){this._initPages();};
b.prototype.onAfterRendering=function(){this._setLinkWidth();};
b.prototype.exit=function(){if(this._oNavContainer){this._oNavContainer.destroy();}};
b.prototype.onkeydown=function(e){this._processKeyboard(e);};
b.prototype._createPage=function(q){var c=q._createPageContent();q._mPageContent=null;var C=new S(this.getId()+'-'+q.getPageId(),{horizontal:false,vertical:false});if(c.header){C.addContent(c.header);}C.addContent(c.form);C.addStyleClass('sapMQuickViewPage');return C;};
b.prototype._setLinkWidth=function(){this.$().find(".sapMLnk").css("width","auto");};
return b;});
sap.ui.predefine('sap/m/QuickViewGroupElement',["./library","sap/ui/core/Element","./Link","./Text","sap/ui/core/CustomData"],function(l,E,L,T,C){"use strict";var G=l.QuickViewGroupElementType;
var a=E.extend("sap.m.QuickViewGroupElement",{metadata:{library:"sap.m",properties:{visible:{type:"boolean",group:"Appearance",defaultValue:true},label:{type:"string",group:"Misc",defaultValue:""},value:{type:"string",group:"Misc",defaultValue:""},url:{type:"string",group:"Misc",defaultValue:""},target:{type:"string",group:"Misc",defaultValue:"_blank"},type:{type:"sap.m.QuickViewGroupElementType",group:"Misc",defaultValue:G.text},pageLinkId:{type:"string",group:"Misc",defaultValue:""},emailSubject:{type:"string",group:"Misc",defaultValue:""}}}});
a.prototype._getGroupElementValue=function(q){if(!this.getValue()){return null;}switch(this.getType()){case G.email:var h="mailto:"+this.getValue();var s=this.getEmailSubject();if(s){h+='?subject='+s;}return new L({href:h,text:this.getValue(),wrapping:true});case G.phone:case G.mobile:return new L({href:"tel:"+this.getValue(),text:this.getValue()});case G.link:return new L({href:this.getUrl(),text:this.getValue(),target:this.getTarget()});case G.pageLink:var b=this.getPageLinkId();if(q){b=q+'-'+b;}return new L({text:this.getValue(),customData:[new C({key:"pageNumber",value:b})]});default:return new T({text:this.getValue()});}};
a.prototype.setProperty=function(){E.prototype.setProperty.apply(this,arguments);var g=this.getParent();if(!g){return this;}var p=g.getParent();if(p){p._updatePage();}return this;};
a.prototype.getQuickViewBase=function(){var p=this.getParent();if(p&&p.getQuickViewBase){return p.getQuickViewBase();}return null;};
return a;});
sap.ui.predefine('sap/m/QuickViewPage',["./library","sap/ui/core/Core","sap/ui/core/Control","sap/ui/core/IconPool","sap/ui/layout/form/SimpleForm","sap/ui/layout/VerticalLayout","sap/ui/layout/HorizontalLayout","sap/m/Page","sap/m/Button","sap/m/Bar","sap/m/Title","sap/m/Image","sap/m/Link","sap/m/Text","sap/m/Label","sap/m/HBox","sap/ui/core/Icon","sap/ui/core/Title","sap/ui/core/CustomData","sap/ui/core/library","sap/ui/layout/library","sap/ui/Device","sap/ui/layout/form/ResponsiveGridLayout","./QuickViewPageRenderer","sap/base/security/encodeURL","sap/ui/dom/jquery/Focusable"],function(l,C,a,I,S,V,H,P,B,b,T,c,L,d,e,f,g,h,i,m,n,D,R,Q,o){"use strict";var U=l.URLHelper;var p=n.form.SimpleFormLayout;var q=m.TitleLevel;var r=l.QuickViewGroupElementType;var s=l.ButtonType;var t=C.getLibraryResourceBundle('sap.m');
var u=a.extend("sap.m.QuickViewPage",{metadata:{library:"sap.m",properties:{pageId:{type:"string",group:"Misc",defaultValue:""},header:{type:"string",group:"Misc",defaultValue:""},title:{type:"string",group:"Misc",defaultValue:""},titleUrl:{type:"string",group:"Misc",defaultValue:""},crossAppNavCallback:{type:"object",group:"Misc"},description:{type:"string",group:"Misc",defaultValue:""},icon:{type:"string",group:"Misc",defaultValue:""},fallbackIcon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null}},defaultAggregation:"groups",aggregations:{groups:{type:"sap.m.QuickViewGroup",multiple:true,singularName:"group",bindable:"bindable"}}}});
u.prototype.init=function(){var G=sap.ushell&&sap.ushell.Container&&sap.ushell.Container.getService;if(G){this.oCrossAppNavigator=G("CrossApplicationNavigation");}};
u.prototype.onBeforeRendering=function(){this._destroyPageContent();this._createPageContent();};
u.prototype.getPageContent=function(){return this._mPageContent;};
u.prototype.setNavContext=function(j){this._mNavContext=j;};
u.prototype.getNavContext=function(){return this._mNavContext;};
u.prototype.setPageTitleControl=function(j){this._oPageTitle=j;};
u.prototype.getPageTitleControl=function(){return this._oPageTitle;};
u.prototype._createPage=function(){var j=this._createPageContent();var N=this.getNavContext();var k;if(this._oPage){k=this._oPage;k.destroyContent();k.setCustomHeader(new b());}else{k=this._oPage=new P(N.quickViewId+'-'+this.getPageId(),{customHeader:new b()});k.addEventDelegate({onAfterRendering:this.onAfterRenderingPage},this);}if(this.getHeader()===""&&N.quickView.getPages().length===1&&!D.system.phone){k.setShowHeader(false);k.addStyleClass('sapMQuickViewPageWithoutHeader');}if(j.header){k.addContent(j.header);}k.addContent(j.form);var v=k.getCustomHeader();v.addContentMiddle(new T({text:this.getHeader()}).addStyleClass("sapMQuickViewTitle"));if(N.hasBackButton){v.addContentLeft(new B({type:s.Back,tooltip:t.getText("PAGE_NAVBUTTON_TEXT"),press:function(){if(N.navContainer){N.quickView._setNavOrigin(null);N.navContainer.back();}}}));}if(N.popover&&D.system.phone){v.addContentRight(new B({icon:I.getIconURI("decline"),press:function(){N.popover.close();}}));}k.addStyleClass('sapMQuickViewPage');return k;};
u.prototype.onAfterRenderingPage=function(){var j=this.getParent(),k=j instanceof a&&j.isA('sap.m.QuickView');if(k&&!this._oPage.$().firstFocusableDomRef()){this._oPage.$('cont').attr('tabindex',0);}if(this._bItemsChanged){var N=this.getNavContext();if(N){N.quickView._restoreFocus();}this._bItemsChanged=false;}};
u.prototype._createPageContent=function(){var F=this._createForm();var j=this._getPageHeaderContent();var k=this.getPageTitleControl();if(j&&k){F.addAriaLabelledBy(k);}this._mPageContent={form:F,header:j};return this._mPageContent;};
u.prototype._createForm=function(){var G=this.getAggregation("groups"),F=new S({maxContainerCols:1,editable:false,layout:p.ResponsiveGridLayout});if(G){for(var j=0;j<G.length;j++){if(G[j].getVisible()){this._renderGroup(G[j],F);}}}return F;};
u.prototype._getPageHeaderContent=function(){var j,F,k=this.getFallbackIcon(),v=new V(),w=new H(),x=this.getIcon(),y=this.getTitle(),z=this.getDescription(),A=this.getTitleUrl();if(!x&&!y&&!z){return null;}if(x){if(this.getIcon().indexOf("sap-icon")==0){j=this._createIcon(x,!A,y);}else{j=new c({src:x,decorative:false,tooltip:y}).addStyleClass("sapUiIcon sapMQuickViewPageImage");if(I.isIconURI(k)){F=this._createIcon(k,!A,y);F.addStyleClass("sapMQuickViewThumbnail sapMQuickViewPageFallbackIconHidden");j.attachError(this._onImageLoadError.bind(this));w.addContent(F);}}j.addStyleClass("sapMQuickViewThumbnail");if(A){j.attachPress(this._crossApplicationNavigation(this));if(F){F.attachPress(this._crossApplicationNavigation(this));}}w.addContent(j);}var E;if(A){E=new L({text:y,href:A,target:"_blank"});}else if(this.getCrossAppNavCallback()){E=new L({text:y});E.attachPress(this._crossApplicationNavigation(this));}else{E=new T({text:y,level:q.H3});}this.setPageTitleControl(E);var G=new d({text:z});v.addContent(E);v.addContent(G);w.addContent(v);return w;};
u.prototype._createIcon=function(j,k,v){return new g({src:j,decorative:k,useIconTooltip:false,tooltip:v});};
u.prototype._renderGroup=function(G,F){var E=G.getAggregation("elements");var j,v,w;if(G.getHeading()){F.addContent(new h({text:G.getHeading(),level:q.H4}));}if(!E){return;}var N=this.getNavContext();for(var k=0;k<E.length;k++){j=E[k];if(!j.getVisible()){continue;}w=new e({text:j.getLabel()});var x;if(N){x=N.quickViewId;}v=j._getGroupElementValue(x);F.addContent(w);if(!v){F.addContent(new d({text:""}));continue;}w.setLabelFor(v.getId());if(j.getType()==r.pageLink){v.attachPress(this._attachPressLink(this));}if(j.getType()==r.mobile&&!D.system.desktop){var y=new g({src:I.getIconURI("post"),tooltip:t.getText("QUICKVIEW_SEND_SMS"),decorative:false,customData:[new i({key:"phoneNumber",value:j.getValue()})],press:this._mobilePress});var z=new f({items:[v,y]});F.addContent(z);}else{F.addContent(v);}}};
u.prototype._crossApplicationNavigation=function(j){return function(){if(j.getCrossAppNavCallback()&&j.oCrossAppNavigator){var k=j.getCrossAppNavCallback();if(typeof k=="function"){var v=k();var w=j.oCrossAppNavigator.hrefForExternal({target:{semanticObject:v.target.semanticObject,action:v.target.action},params:v.params});U.redirect(w);}}else if(j.getTitleUrl()){window.open(j.getTitleUrl(),"_blank");}};};
u.prototype._destroyPageContent=function(){if(!this._mPageContent){return;}if(this._mPageContent.form){this._mPageContent.form.destroy();}if(this._mPageContent.header){this._mPageContent.header.destroy();}this._mPageContent=null;};
u.prototype.exit=function(){if(this._oPage){this._oPage.destroy();this._oPage=null;}else{this._destroyPageContent();}this._mNavContext=null;};
u.prototype._attachPressLink=function(j){var N=j.getNavContext();return function(E){E.preventDefault();var k=this.getCustomData()[0].getValue();if(N.navContainer&&k){N.quickView._setNavOrigin(this);N.navContainer.to(k);}};};
u.prototype._mobilePress=function(){var j="sms://"+o(this.getCustomData()[0].getValue());window.location.replace(j);};
u.prototype._updatePage=function(){var N=this.getNavContext();if(N&&N.quickView._bRendered){this._bItemsChanged=true;N.popover.focus();if(N.quickView.indexOfPage(this)==0){N.quickView._clearContainerHeight();}this._createPage();N.popover.$().css('display','block');N.quickView._adjustContainerHeight();N.quickView._restoreFocus();}};
["setModel","bindAggregation","setAggregation","insertAggregation","addAggregation","removeAggregation","removeAllAggregation","destroyAggregation"].forEach(function(F){u.prototype["_"+F+"Old"]=u.prototype[F];u.prototype[F]=function(){var j=u.prototype["_"+F+"Old"].apply(this,arguments);this._updatePage();if(["removeAggregation","removeAllAggregation"].indexOf(F)!==-1){return j;}return this;};});
u.prototype.setProperty=function(){a.prototype.setProperty.apply(this,arguments);this._updatePage();return this;};
u.prototype.getQuickViewBase=function(){var j=this.getParent();if(j&&j.isA("sap.m.QuickViewBase")){return j;}return null;};
u.prototype._onImageLoadError=function(E){var F=0,j=this._mPageContent.header.getContent()[F],k=E.getSource(),v=document.activeElement===k.getDomRef();j.removeStyleClass("sapMQuickViewPageFallbackIconHidden");k.addStyleClass("sapMQuickViewPageFailedImage");if(v){j.focus();}};
return u;});
/*!
 * @copyright@
 */
sap.ui.predefine('sap/m/NumericContentRenderer',["sap/m/library"],function(l){"use strict";var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");var V=l.ValueColor;var N={apiVersion:2};
N.render=function(R,c){var s=c.getState();var w=c.getWithMargin();var W=w?"":"WithoutMargin";R.openStart("div",c);var t=c.getTooltip_AsString();if(typeof t!=="string"){t="";}R.attr("aria-label",t);R.attr("role","img");R.attr("aria-roledescription",r.getText("NUMERIC_CONTENT_ROLE_DESCRIPTION"));if(s===l.LoadState.Failed||s===l.LoadState.Loading){R.attr("aria-disabled","true");}if(c.getAnimateTextChange()){R.class("sapMNCAnimation");}if(c.getWidth()){R.style("width",c.getSize());}R.class("sapMNC");R.class(W);if(c.hasListeners("press")){R.attr("tabindex",0);R.class("sapMPointer");}R.openEnd();R.openStart("div");R.class("sapMNCInner");R.class(W);R.openEnd();this._renderValue(R,c,W);R.close("div");R.close("div");};
N._prepareAndRenderIcon=function(R,c,i,n){if(i){var s,L=l.LoadState,C=c.getState();for(s in L){if(L.hasOwnProperty(s)&&s!==C){i.removeStyleClass(s);}else if(L.hasOwnProperty(s)&&s===C){i.addStyleClass(s);}}i.addStyleClass("sapMNCIconImage");var S={sapMNCLargeFontSize:false,sapMNCMediumFontSize:false,sapMNCSmallFontSize:false};S[n]=true;Object.keys(S).forEach(function(k){i.toggleStyleClass(k,S[k]);});R.renderControl(i);}};
N._renderScaleAndIndicator=function(R,c,w,v,s,n){var i=l.DeviationIndicator.None!==c.getIndicator()&&v!=="";var S=s&&v;if(i||S){var a=c.getState();var C=c.getValueColor();R.openStart("div",c.getId()+"-indicator");R.class("sapMNCIndScale");R.class(w);R.class(a);R.class(a);if(n){R.class(n);}R.openEnd();R.renderControl(c._oIndicatorIcon);if(S){R.openStart("div",c.getId()+"-scale");R.class("sapMNCScale");R.class(a);R.class(C);R.openEnd();R.text(s);R.close("div");}R.close("div");}};
N._renderValue=function(R,c,w){var v=c.getValue();var s=c.getScale();if(c.getFormatterValue()){var f=c._parseFormattedValue(v);s=f.scale;v=f.value;}var e=c.getNullifyValue()?"0":"";R.openStart("div",c.getId()+"-value");R.class("sapMNCValue");R.class(w);if(c.getValueColor()===V.None){R.class(r.getText("SEMANTIC_COLOR_NEUTRAL"));}else{R.class(c.getValueColor());}R.class(c.getState());R.openEnd();var m=c._getMaxDigitsData();this._prepareAndRenderIcon(R,c,c._oIcon,m.fontClass);var C=c.getTruncateValueTo()||m.maxLength;R.openStart("span",c.getId()+"-value-inner");if(m.fontClass){R.class(m.fontClass);}R.openEnd();if(v.length>=C&&(v[C-1]==="."||v[C-1]===",")){R.text(v.substring(0,C-1));}else{R.text(v?v.substring(0,C):e);}R.close("span");this._renderScaleAndIndicator(R,c,w,v,s,m.fontClass);R.close("div");};
return N;},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/m/AccButton',['./Button','./AccButtonRenderer'],function(B,A){"use strict";
var a=B.extend("sap.m.AccButton",{metadata:{library:"sap.m",properties:{"tabIndex":{type:"string",defaultValue:null,bindable:"bindable"},"ariaHidden":{type:"string",defaultValue:null,bindable:"bindable"},"ariaHaspopup":{type:"string",defaultValue:null,bindable:"bindable"}}}});
return a;});
sap.ui.predefine('sap/m/AccButtonRenderer',["./ButtonRenderer","sap/ui/core/Renderer"],function(B,R){"use strict";var A=R.extend(B);A.apiVersion=2;
A.renderAccessibilityAttributes=function(r,c){if(c.getTabIndex()){r.attr("tabindex",c.getTabIndex());}if(c.getAriaHidden()){r.attr("aria-hidden",c.getAriaHidden());}if(c.getAriaHaspopup()){r.attr("aria-haspopup",c.getAriaHaspopup());}};
return A;},true);
sap.ui.predefine('sap/m/ActionListItem',['./ListItemBase','./library','./ActionListItemRenderer'],function(L,l,A){"use strict";var a=l.ListMode;var b=l.ListType;
var c=L.extend("sap.m.ActionListItem",{metadata:{library:"sap.m",properties:{text:{type:"string",group:"Misc",defaultValue:null}}}});
c.prototype.init=function(){this.setType(b.Active);L.prototype.init.apply(this,arguments);};
c.prototype.getMode=function(){return a.None;};
c.prototype.onsapspace=c.prototype.onsapenter;
c.prototype.getContentAnnouncement=function(){return this.getText();};
return c;});
sap.ui.predefine('sap/m/ActionListItemRenderer',["./ListItemBaseRenderer","sap/ui/core/Renderer"],function(L,R){"use strict";var A=R.extend(L);A.apiVersion=2;
A.renderLIAttributes=function(r,l){r.class("sapMALI");};
A.renderLIContent=function(r,l){var t=l.getText();if(t){r.openStart("div").class("sapMALIText").openEnd();r.text(t);r.close("div");}};
return A;},true);
sap.ui.predefine('sap/m/ActionSelect',['./Select','sap/ui/core/InvisibleText','sap/ui/core/Core','./ActionSelectRenderer'],function(S,I,C,A){"use strict";
var a=S.extend("sap.m.ActionSelect",{metadata:{library:"sap.m",associations:{buttons:{type:"sap.m.Button",multiple:true,singularName:"button"}}}});
a.prototype.init=function(){S.prototype.init.call(this);this.getList().addEventDelegate({onfocusin:this.onfocusinList},this);};
a.prototype.hasContent=function(){return S.prototype.hasContent.call(this)||!!this.getButtons().length;};
a.prototype.addContentToFlex=function(){var s=this.getSimpleFixFlex();this.getButtons().forEach(function(b){s.addFlexContent(C.byId(b));});};
a.prototype._onBeforeRenderingPopover=function(){S.prototype._onBeforeRenderingPopover.call(this);var p=this.getPicker();p&&p._setAriaRoleApplication(true);this._updateTutorMessage();};
a.prototype.onAfterRenderingPicker=function(){S.prototype.onAfterRenderingPicker.call(this);var p=this.getPicker(),r=this.getRenderer();p.addStyleClass(r.CSS_CLASS+"Picker");p.addStyleClass(r.ACTION_SELECT_CSS_CLASS+"Picker");p.addStyleClass(r.ACTION_SELECT_CSS_CLASS+"Picker-CTX");};
a.prototype.createPickerCloseButton=function(){};
a.prototype.removeButton=function(b){var s=this.getSimpleFixFlex();if(s){if(typeof b==="number"){b=this.getButtons()[b];}s.removeFlexContent(b);}return this.removeAssociation("buttons",b);};
a.prototype.removeAllButtons=function(){var s=this.getSimpleFixFlex();if(s){this.getButtons().forEach(function(b){s.removeFlexContent(C.byId(b));});}return this.removeAllAssociation("buttons");};
a.prototype.onsaptabprevious=function(e){var b=this.getButtons(),p=this.getPicker(),i;if(e.isMarked()||!this.getEnabled()){return;}e.setMarked();if(p&&p.isOpen()&&b.length>0){for(i=b.length-1;i>=0;i--){if(C.byId(b[i]).getEnabled()){C.byId(b[i]).focus();e.preventDefault();break;}}}};
a.prototype.onsaptabnext=function(e){var b=this.getButtons(),p=this.getPicker(),i;this._bProcessChange=false;if(e.isMarked()||!this.getEnabled()){return;}e.setMarked();if(p&&p.isOpen()&&b.length>0){for(i=0;i<b.length;i++){if(C.byId(b[i]).getEnabled()){C.byId(b[i]).focus();e.preventDefault();break;}}}};
a.prototype.onsapfocusleave=function(e){var b=this.getButtons();var k=(b.indexOf(e.relatedControlId)===-1);if(k){S.prototype.onsapfocusleave.apply(this,arguments);}this._toggleListFocusIndication(true);};
a.prototype.onfocusinList=function(e){if(document.activeElement!==this.getList().getDomRef()){this.focus();}};
a.prototype.onfocusin=function(){S.prototype.onfocusin.apply(this,arguments);this._toggleListFocusIndication(false);};
a.prototype._toggleListFocusIndication=function(r){var s=this.getSelectedItem();if(this.isOpen()&&s){s.$().toggleClass("sapMActionSelectItemWithoutFocus",r);}};
a.prototype._updateTutorMessage=function(){var p=this.getPicker(),b=p.getAriaLabelledBy(),h=!!this.getButtons().length,t;if(!this._sTutorMessageId){this._sTutorMessageId=this._getTutorMessageId();this._oTutorMessageText=new I(this._sTutorMessageId,{text:C.getLibraryResourceBundle("sap.m").getText("ACTION_SELECT_TUTOR_MESSAGE")}).toStatic();}t=(b.indexOf(this._sTutorMessageId)===-1);if(t&&h){p.addAriaLabelledBy(this._sTutorMessageId);}else{if(!h){p.removeAriaLabelledBy(this._sTutorMessageId);}}};
a.prototype._getTutorMessageId=function(){return this.getId()+"-tutorMessage";};
a.prototype.exit=function(){if(this._oTutorMessageText){this._oTutorMessageText.destroy();this._oTutorMessageText=null;}};
return a;});
sap.ui.predefine('sap/m/ActionSelectRenderer',['sap/ui/core/Renderer','./SelectRenderer'],function(R,S){"use strict";var A=R.extend(S);A.ACTION_SELECT_CSS_CLASS="sapMActionSelect";A.apiVersion=2;
A.addClass=function(r,a){r.class(A.ACTION_SELECT_CSS_CLASS);};
return A;},true);
sap.ui.predefine('sap/m/ActionSheet',['./Dialog','./Popover','./library','sap/ui/core/Control','sap/ui/core/delegate/ItemNavigation','sap/ui/core/InvisibleText','sap/ui/Device','./ActionSheetRenderer','./Button',"sap/ui/thirdparty/jquery"],function(D,P,l,C,I,a,b,A,B,q){"use strict";var c=l.ButtonType;var d=l.DialogType;var e=l.PlacementType;
var f=C.extend("sap.m.ActionSheet",{metadata:{library:"sap.m",properties:{placement:{type:"sap.m.PlacementType",group:"Appearance",defaultValue:e.Bottom},showCancelButton:{type:"boolean",group:"Appearance",defaultValue:true},cancelButtonText:{type:"string",group:"Appearance",defaultValue:null},title:{type:"string",group:"Appearance",defaultValue:null}},aggregations:{buttons:{type:"sap.m.Button",multiple:true,singularName:"button"},_cancelButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_invisibleAriaTexts:{type:"sap.ui.core.InvisibleText",multiple:true,visibility:"hidden"}},defaultAggregation:"buttons",events:{cancelButtonTap:{deprecated:true},beforeOpen:{},afterOpen:{},beforeClose:{parameters:{origin:{type:"sap.m.Button"}}},afterClose:{parameters:{origin:{type:"sap.m.Button"}}},cancelButtonPress:{}},designtime:"sap/m/designtime/ActionSheet.designtime"}});
f.prototype.init=function(){this._fnOrientationChange=this._orientationChange.bind(this);this._actionSelected=null;};
f.prototype.exit=function(){b.resize.detachHandler(this._fnOrientationChange);if(this._parent){this._parent.destroy();this._parent=null;}if(this._oCancelButton){this._oCancelButton.destroy();this._oCancelButton=null;}this._clearItemNavigation();};
f.prototype._clearItemNavigation=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}};
f.prototype._setItemNavigation=function(){var g=this._getAllButtons(),h=[],o=this.getDomRef();if(o){this._oItemNavigation.setRootDomRef(o);for(var i=0;i<g.length;i++){if(g[i].getEnabled()&&g[i].getVisible()){h.push(g[i].getFocusDomRef());}}if(this._oCancelButton){h.push(this._oCancelButton.getFocusDomRef());}this._oItemNavigation.setItemDomRefs(h);this._oItemNavigation.setSelectedIndex(0);this._oItemNavigation.setPageSize(5);this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"]});}};
f.prototype.onmousedown=function(E){if(E.srcControl.isA("sap.m.Button")&&this.getButtons().indexOf(E.srcControl)!==-1){this._actionSelected=E.srcControl;}};
f.prototype.onBeforeRendering=function(){var t,p;this._clearItemNavigation();t=this.getTitle();if(this._parent&&!this.isPropertyInitial("title")&&this._parent.getTitle()!==t){if(b.system.phone){this._parent.setTitle(t);this._parent.setShowHeader(!!t);}if(t){this._parent.addStyleClass("sapMActionSheetDialogWithTitle");}else{this._parent.removeStyleClass("sapMActionSheetDialogWithTitle");}}p=this.getPlacement();if(this._parent&&!b.system.phone&&!this.isPropertyInitial("placement")&&this._parent.setPlacement()!==p){this._parent.setPlacement(p);}};
f.prototype.onAfterRendering=function(){this._oItemNavigation=new I();this._oItemNavigation.setCycling(false);this.addDelegate(this._oItemNavigation);this._setItemNavigation();};
f.prototype.sapfocusleave=function(){this.close();};
f.prototype.openBy=function(o){var t=this;if(!this._parent){var O=this.getParent();if(O){this.setParent(null);}if(!b.system.phone){this._parent=new P({placement:this.getPlacement(),showHeader:false,content:[this],beforeOpen:function(){t.fireBeforeOpen();},afterOpen:function(){t.focus();t.fireAfterOpen();},beforeClose:function(){t.fireBeforeClose();},afterClose:function(){if(t.getShowCancelButton()){t.fireCancelButtonTap();t.fireCancelButtonPress();}t._onAfterClose(t._actionSelected);t._actionSelected=null;},ariaLabelledBy:this.getPopupHiddenLabelId()||undefined}).addStyleClass("sapMActionSheetPopover");this._parent._setAriaRoleApplication(true);if(b.browser.internet_explorer){this._parent._fnAdjustPositionAndArrow=q.proxy(function(){P.prototype._adjustPositionAndArrow.apply(this);var $=this.$(),g=$.children(".sapMPopoverCont")[0].getBoundingClientRect().width;q.each($.find(".sapMActionSheet > .sapMBtn"),function(i,h){var j=q(h),k;j.css("width","");k=h.getBoundingClientRect().width;if(k<=g){j.css("width","100%");}});},this._parent);}}else{this._parent=new D({title:this.getTitle(),type:d.Standard,content:[this],beforeOpen:function(){t.fireBeforeOpen();},afterOpen:function(){t.focus();t.fireAfterOpen();},beforeClose:function(E){t.fireBeforeClose({origin:E.getParameter("origin")});},afterClose:function(E){t._actionSelected=E.getParameter("origin");t._onAfterClose(t._actionSelected);t._actionSelected=null;b.resize.detachHandler(t._fnOrientationChange);}}).addStyleClass("sapMActionSheetDialog");if(this.getTitle()){this._parent.addStyleClass("sapMActionSheetDialogWithTitle");}else{this._parent.addAriaLabelledBy(this.getPopupHiddenLabelId()||undefined);}if(!b.system.phone){this._parent.setBeginButton(this._getCancelButton());}if(b.system.phone){this._parent.oPopup.setModal(true);this._parent._setDimensions=function(){D.prototype._setDimensions.apply(this);this.$("cont").css("max-height","");};this._parent._adjustScrollingPane=function(){var h=this.$().height();this.$("cont").css("max-height",h);if(this._oScroller){this._oScroller.refresh();}};}}if(O){O.addDependent(this._parent);}}if(!b.system.phone){this._parent.openBy(o);}else{this._parent.open();b.resize.attachHandler(this._fnOrientationChange);}};
f.prototype.close=function(){if(this._parent){this._parent.close();}};
f.prototype.isOpen=function(){return!!this._parent&&this._parent.isOpen();};
f.prototype._createCancelButton=function(){if(!this._oCancelButton){var s=(this.getCancelButtonText())?this.getCancelButtonText():sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACTIONSHEET_CANCELBUTTON_TEXT"),t=this;this._oCancelButton=new B(this.getId()+'-cancelBtn',{text:s,type:c.Reject,press:function(){if(b.system.phone&&t._parent){t._parent._oCloseTrigger=this;}t.close();t.fireCancelButtonTap();t.fireCancelButtonPress();}}).addStyleClass("sapMActionSheetButton sapMActionSheetCancelButton sapMBtnTransparent sapMBtnInverted");if(b.system.phone){this.setAggregation("_cancelButton",this._oCancelButton,true);}}return this;};
f.prototype._getCancelButton=function(){if(b.system.phone&&this.getShowCancelButton()){this._createCancelButton();return this._oCancelButton;}return null;};
f.prototype.setCancelButtonText=function(t){this.setProperty("cancelButtonText",t,true);if(this._oCancelButton){this._oCancelButton.setText(t);}return this;};
f.prototype._preProcessActionButton=function(o){var t=o.getType();if(t!==c.Accept&&t!==c.Reject){o.setType(c.Transparent);}o.addStyleClass("sapMBtnInverted");if(!o.getIcon()){o.addStyleClass("sapMActionSheetButtonNoIcon");}o.addStyleClass("sapMActionSheetButton");this._parent&&this._parent.invalidate();return this;};
f.prototype._buttonSelected=function(){if(b.system.phone&&this._parent){this._parent._oCloseTrigger=this;}this.close();};
f.prototype._orientationChange=function(){this._parent._adjustScrollingPane();};
f.prototype._addAriaHiddenTexts=function(o){var s=o.getId(),i;if(sap.ui.getCore().getConfiguration().getAccessibility()){i=new a(s+"-actionSheetHiddenText");this.addAggregation("_invisibleAriaTexts",i,false);o.addAriaLabelledBy(i.getId());}};
f.prototype._removeAriaHiddenTexts=function(o){o.getAriaLabelledBy().forEach(function(i){var g=sap.ui.getCore().byId(i);if(g instanceof a&&i.indexOf("actionSheetHiddenText")>-1){this.removeAggregation("_invisibleAriaTexts",g,false);o.removeAriaLabelledBy(g);g.destroy();}},this);};
f.prototype.addButton=function(o){this.addAggregation("buttons",o,false);this._addAriaHiddenTexts(o);this._preProcessActionButton(o);o.attachPress(this._buttonSelected,this);return this;};
f.prototype.insertButton=function(o,i){this.insertAggregation("buttons",o,i,false);this._addAriaHiddenTexts(o);this._preProcessActionButton(o);o.attachPress(this._buttonSelected,this);return this;};
f.prototype.removeButton=function(o){var r=this.removeAggregation("buttons",o,false);if(r){r.detachPress(this._buttonSelected,this);this._removeAriaHiddenTexts(r);}return r;};
f.prototype.removeAllButtons=function(){var r=this.removeAllAggregation("buttons",false),t=this;q.each(r,function(i,o){o.detachPress(t._buttonSelected,t);t._removeAriaHiddenTexts(o);});return r;};
f.prototype.clone=function(){var g=this.getButtons();for(var i=0;i<g.length;i++){g[i].detachPress(this._buttonSelected,this);}var o=C.prototype.clone.apply(this,arguments);for(var j=0;j<g.length;j++){g[j].attachPress(this._buttonSelected,this);}return o;};
f.prototype._getAllButtons=function(){return this.getButtons();};
f.prototype.getPopupHiddenLabelId=function(){return a.getStaticId("sap.m","ACTIONSHEET_AVAILABLE_ACTIONS");};
f.prototype._applyContextualSettings=function(){C.prototype._applyContextualSettings.call(this);};
f.prototype._onAfterClose=function(o){this.fireAfterClose({origin:o});};
return f;});
sap.ui.predefine('sap/m/ActionSheetRenderer',["sap/ui/Device"],function(D){"use strict";var A={apiVersion:2};
A.render=function(r,c){var a=c._getAllButtons(),I=c.getAggregation("_invisibleAriaTexts"),R=sap.ui.getCore().getLibraryResourceBundle('sap.m'),b=a.length,d=sap.ui.getCore().getConfiguration().getAccessibility(),v=a.filter(function(B){return B.getVisible();}).length,C,i,m,B,V=1,g=function(o){return I.filter(function(e){return e.getId().indexOf(o.getId())>-1;})[0];};for(i=0;i<b;i++){B=a[i];if(B.getIcon()&&B.getVisible()){m=true;}}r.openStart("div",c);r.class("sapMActionSheet");if(m){r.class("sapMActionSheetMixedButtons");}var t=c.getTooltip_AsString();if(t){r.attr("title",t);}d&&r.attr("role","presentation");r.openEnd();for(i=0;i<b;i++){B=a[i];r.renderControl(a[i]);if(d&&B.getVisible()){C=g(B);if(C){C.setText(R.getText('ACTIONSHEET_BUTTON_INDEX',[V,v]));r.renderControl(C);}V++;}}if(D.system.phone&&c.getShowCancelButton()){r.renderControl(c._getCancelButton());}r.close("div");};
return A;},true);
sap.ui.predefine('sap/m/App',['./NavContainer','./library','./AppRenderer','sap/ui/base/DataType',"sap/ui/util/Mobile","sap/base/Log","sap/ui/thirdparty/jquery"],function(N,l,A,D,M,L,q){"use strict";
var a=N.extend("sap.m.App",{metadata:{library:"sap.m",properties:{homeIcon:{type:"any",group:"Misc",defaultValue:null},backgroundColor:{type:"string",group:"Appearance",defaultValue:null},backgroundImage:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},backgroundRepeat:{type:"boolean",group:"Appearance",defaultValue:false},backgroundOpacity:{type:"float",group:"Appearance",defaultValue:1},mobileWebAppCapable:{type:"boolean",group:"Appearance",defaultValue:true}},events:{orientationChange:{deprecated:true,parameters:{landscape:{type:"boolean"}}}}}});
a.prototype.init=function(){N.prototype.init.apply(this,arguments);this.addStyleClass("sapMApp");M.init({viewport:!this._debugZoomAndScroll,statusBar:"default",hideBrowser:true,preventScroll:!this._debugZoomAndScroll,rootId:this.getId()});q(window).on("resize",q.proxy(this._handleOrientationChange,this));};
a.prototype.onBeforeRendering=function(){if(N.prototype.onBeforeRendering){N.prototype.onBeforeRendering.apply(this,arguments);}M.init({homeIcon:this.getHomeIcon(),mobileWebAppCapable:this.getMobileWebAppCapable()});};
a.prototype.onAfterRendering=function(){if(N.prototype.onAfterRendering){N.prototype.onAfterRendering.apply(this,arguments);}var r=this.getDomRef().parentNode;while(r&&r!==document.documentElement){var $=q(r);if($.attr("data-sap-ui-root-content")){break;}if(!r.style.height){r.style.height="100%";}r=r.parentNode;}};
a.prototype.exit=function(){q(window).off("resize",this._handleOrientationChange);if(this._sInitTimer){clearTimeout(this._sInitTimer);}};
a.prototype._handleOrientationChange=function(){var $=q(window);var i=$.width()>$.height();if(this._oldIsLandscape!==i){this.fireOrientationChange({landscape:i});this._oldIsLandscape=i;}};
a.prototype.setBackgroundOpacity=function(o){if(o>1||o<0){L.warning("Invalid value "+o+" for App.setBackgroundOpacity() ignored. Valid values are: floats between 0 and 1.");return this;}this.$("BG").css("opacity",o);return this.setProperty("backgroundOpacity",o,true);};
return a;});
sap.ui.predefine('sap/m/AppRenderer',['./NavContainerRenderer','sap/ui/core/Renderer','sap/m/library'],function(N,R,l){"use strict";var B=l.BackgroundHelper;var A=R.extend(N);A.apiVersion=2;
A.renderAttributes=function(r,c){B.addBackgroundColorStyles(r,c.getBackgroundColor(),c.getBackgroundImage());};
A.renderBeforeContent=function(r,c){B.renderBackgroundImageTag(r,c,"sapMAppBG",c.getBackgroundImage(),c.getBackgroundRepeat(),c.getBackgroundOpacity());};
return A;},true);
sap.ui.predefine('sap/m/AssociativeOverflowToolbar',['sap/base/Log','./OverflowToolbar','./OverflowToolbarRenderer','./Toolbar','sap/ui/Device'],function(L,O,a,T,D){"use strict";
var A=O.extend("sap.m.AssociativeOverflowToolbar",{
metadata:{associations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}}},
renderer:a
});
A.prototype.getContent=function(){var b=this.getAssociation("content")||[];var c=[];b.forEach(function(d){var C=sap.ui.getCore().byId(d);if(C){c.push(C);}});return c;};
A.prototype.insertContent=function(c,I){var s=c.getId(),b=this.getAssociation("content").filter(function(d){return d!==s;});var i;if(I<0){i=0;}else if(I>b.length){i=b.length;}else{i=I;}if(i!==I){L.warning("AssociativeOverflowToolbar.insertContent: index '"+I+"' out of range [0,"+b.length+"], forced to "+i);}b.splice(i,0,s);this.removeAllAssociation("content");b.forEach(function(d){this.addAssociation("content",d);},this);return this;};
A.prototype.exit=function(){O.prototype.exit.apply(this,arguments);return this._callToolbarMethod('destroyContent',[true]);};
A.prototype.indexOfContent=function(c){var b=this.getAssociation("content")||[];return b.indexOf(c.getId());};
A.prototype._handleResize=function(){if(D.system.phone){this._resetAndInvalidateToolbar();}else{this._bControlsInfoCached=false;O.prototype._handleResize.apply(this,arguments);}};
A.prototype._callToolbarMethod=function(f,b){switch(f){case'addContent':return this.addAssociation("content",b[0]);case'getContent':return this.getContent();case'insertContent':return this.insertContent(b[0],b[1]);case'removeContent':return sap.ui.getCore().byId(this.removeAssociation("content",b[0],b[1],b[2]))||null;case'destroyContent':this.removeAllAssociation("content",b[0]);return this;case'removeAllContent':return this.removeAllAssociation("content",b[0]).map(function(c){return sap.ui.getCore().byId(c);});default:return T.prototype[f].apply(this,b);}};
return A;});
sap.ui.predefine('sap/m/Avatar',["sap/ui/core/Control","sap/ui/core/IconPool","./AvatarRenderer","sap/ui/events/KeyCodes","sap/base/Log","sap/ui/core/Icon","./library"],function(C,I,A,K,L,a,l){"use strict";var b=l.AvatarType;var c=l.AvatarImageFitType;var d=l.AvatarColor;var e=l.AvatarSize;var f=l.AvatarShape;var g=Object.keys(d).filter(function(s){return s.indexOf("Accent")!==-1;});
var h=C.extend("sap.m.Avatar",{metadata:{library:"sap.m",properties:{src:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},initials:{type:"string",group:"Data",defaultValue:null},displayShape:{type:"sap.m.AvatarShape",group:"Appearance",defaultValue:f.Circle},displaySize:{type:"sap.m.AvatarSize",group:"Appearance",defaultValue:e.S},customDisplaySize:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"3rem"},customFontSize:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"1.125rem"},imageFitType:{type:"sap.m.AvatarImageFitType",group:"Appearance",defaultValue:c.Cover},fallbackIcon:{type:"string",group:"Data",defaultValue:null},backgroundColor:{type:"sap.m.AvatarColor",group:"Appearance",defaultValue:d.Accent6},showBorder:{type:"boolean",group:"Appearance",defaultValue:false},badgeIcon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:""},badgeTooltip:{type:"string",group:"Data",defaultValue:null}},aggregations:{detailBox:{type:'sap.m.LightBox',multiple:false,bindable:"bindable"},_badge:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{press:{}},dnd:{draggable:true,droppable:false},designtime:"sap/m/designtime/Avatar.designtime"}});
h.DEFAULT_CIRCLE_PLACEHOLDER="sap-icon://person-placeholder";h.DEFAULT_SQUARE_PLACEHOLDER="sap-icon://product";h.AVATAR_BADGE_TOOLTIP={"sap-icon://zoom-in":sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("AVATAR_TOOLTIP_ZOOMIN"),"sap-icon://camera":sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("AVATAR_TOOLTIP_CAMERA"),"sap-icon://edit":sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("AVATAR_TOOLTIP_EDIT")};
h.prototype.init=function(){this._sActualType=null;this._bIsDefaultIcon=true;this._sImageFallbackType=null;this._sPickedRandomColor=null;this._badgeRef=null;};
h.prototype.exit=function(){if(this._icon){this._icon.destroy();}if(this._fnLightBoxOpen){this._fnLightBoxOpen=null;}if(this._badgeRef){this._badgeRef.destroy();}this._sPickedRandomColor=null;};
h.prototype.setDetailBox=function(o){var i=this.getDetailBox();if(o){if(o===i){return this;}if(i){this.detachPress(this._fnLightBoxOpen,i);}this._fnLightBoxOpen=o.open;this.attachPress(this._fnLightBoxOpen,o);}else if(this._fnLightBoxOpen){this.detachPress(this._fnLightBoxOpen,i);this._fnLightBoxOpen=null;}return this.setAggregation("detailBox",o);};
h.prototype.clone=function(){var o=C.prototype.clone.apply(this,arguments),i=o.getDetailBox();if(i){o.detachPress(this._fnLightBoxOpen,this.getDetailBox());o._fnLightBoxOpen=i.open;o.attachPress(o._fnLightBoxOpen,i);}return o;};
h.prototype.attachPress=function(){Array.prototype.unshift.apply(arguments,["press"]);C.prototype.attachEvent.apply(this,arguments);if(this.hasListeners("press")){this.$().attr("tabindex","0");this.$().attr("role","button");}return this;};
h.prototype.detachPress=function(){Array.prototype.unshift.apply(arguments,["press"]);C.prototype.detachEvent.apply(this,arguments);if(!this.hasListeners("press")){this.$().removeAttr("tabindex");this.$().attr("role","img");}return this;};
h.prototype.ontap=function(){this.firePress({});};
h.prototype.onkeydown=function(E){if(E.which===K.SHIFT||E.which===K.ESCAPE){this._bShouldInterupt=this._bSpacePressed;}if(E.which===K.SPACE){this._bSpacePressed=true;E.preventDefault();}if(E.which===K.ENTER){this.firePress({});}};
h.prototype.onkeyup=function(E){if(E.which===K.SPACE){if(!this._bShouldInterupt){this.firePress({});}this._bShouldInterupt=false;this._bSpacePressed=false;E.stopPropagation();}};
h.prototype._areInitialsValid=function(i){var v=/^[a-zA-Z]{1,2}$/;if(!v.test(i)){L.warning("Initials should consist of only 1 or 2 latin letters",this);this._sActualType=b.Icon;this._bIsDefaultIcon=true;return false;}return true;};
h.prototype._validateSrc=function(s){if(I.isIconURI(s)){this._sActualType=b.Icon;this._bIsDefaultIcon=I.getIconInfo(s)?false:true;}else{this._bIsDefaultIcon=true;this._sActualType=b.Image;this.preloadedImage=new window.Image();this.preloadedImage.src=s;this.preloadedImage.onload=this._onImageLoad.bind(this);this.preloadedImage.onerror=this._onImageError.bind(this);}return this;};
h.prototype._getDisplayIcon=function(s){return I.isIconURI(s)&&I.getIconInfo(s)?I.createControlByURI({src:s}):null;};
h.prototype._getActualDisplayType=function(){var s=this.getSrc(),i=this.getInitials();if(s){this._validateSrc(s);}else if(i&&this._areInitialsValid(i)){this._sActualType=b.Initials;}else{L.warning("No src and initials were provided",this);this._sActualType=b.Icon;this._bIsDefaultIcon=true;}return this._sActualType;};
h.prototype._getImageFallbackType=function(){var i=this.getInitials();this._sImageFallbackType=i&&this._areInitialsValid(i)?b.Initials:b.Icon;return this._sImageFallbackType;};
h.prototype._getDefaultIconPath=function(D){var s=null,F=this.getFallbackIcon();if(F&&I.isIconURI(F)){s=F;}else if(D===f.Circle){s=h.DEFAULT_CIRCLE_PLACEHOLDER;}else if(D===f.Square){s=h.DEFAULT_SQUARE_PLACEHOLDER;}return s;};
h.prototype._getIcon=function(){var s=this.getSrc(),D=this.getDisplayShape();if(this._bIsDefaultIcon){s=this._getDefaultIconPath(D);}if(!this._icon){this._icon=I.createControlByURI({alt:"Image placeholder",src:s});}else if(this._icon.getSrc()!==s){this._icon.setSrc(s);}return this._icon;};
h.prototype._getDefaultTooltip=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("AVATAR_TOOLTIP");};
h.prototype._getBadgeIconSource=function(){var B;if(this.getDetailBox()){B="sap-icon://zoom-in";}else if(this.getBadgeIcon()!==""){if(this._getDisplayIcon(this.getBadgeIcon())){B=this.getBadgeIcon();}else{L.warning("No valid Icon URI source for badge affordance was provided");}}return B;};
h.prototype._getBadgeTooltip=function(){var B=this._getDefaultTooltip(),s=this.getBadgeIcon();if(this.getBadgeTooltip()){B=this.getBadgeTooltip();}else if(s&&h.AVATAR_BADGE_TOOLTIP[this.getBadgeIcon()]){B=h.AVATAR_BADGE_TOOLTIP[s];}return B;};
h.prototype._getBadge=function(){var B=this._getBadgeIconSource(),s=this._getBadgeTooltip();if(!B){return;}if(!this._badgeRef){this.setAggregation("_badge",new a({src:B,tooltip:s}));}this._badgeRef=this.getAggregation("_badge");return this._badgeRef;};
h.prototype._onImageLoad=function(){delete this.preloadedImage;};
h.prototype._onImageError=function(){var F=this._getImageFallbackType();this.$().removeClass("sapFAvatarImage").addClass("sapFAvatar"+F);delete this.preloadedImage;};
h.prototype._getActualBackgroundColor=function(){var B=this.getBackgroundColor();if(B===d.Random){if(this._sPickedRandomColor){return this._sPickedRandomColor;}B=this._sPickedRandomColor=d[g[g.length*Math.random()<<0]];}else{this._sPickedRandomColor=null;}return B;};
return h;});
sap.ui.predefine('sap/m/AvatarColor',[],function(){"use strict";var A={Accent1:"Accent1",Accent2:"Accent2",Accent3:"Accent3",Accent4:"Accent4",Accent5:"Accent5",Accent6:"Accent6",Accent7:"Accent7",Accent8:"Accent8",Accent9:"Accent9",Accent10:"Accent10",Random:"Random",Transparent:"Transparent",TileIcon:"TileIcon",Placeholder:"Placeholder"};return A;});
sap.ui.predefine('sap/m/AvatarImageFitType',[],function(){"use strict";var A={Cover:"Cover",Contain:"Contain"};return A;});
sap.ui.predefine('sap/m/AvatarRenderer',["sap/m/library","sap/base/security/encodeCSS"],function(l,e){"use strict";var A=l.AvatarSize;var a=l.AvatarType;var b={apiVersion:2};
b.render=function(r,o){var i=o.getInitials(),s=o._getActualDisplayType(),I=o._getImageFallbackType(),d=o.getDisplaySize(),D=o.getDisplayShape(),c=o.getImageFitType(),C=o.getCustomDisplaySize(),f=o.getCustomFontSize(),S=o.getSrc(),g="sapFAvatar",t=o.getTooltip_AsString(),L=o.getAriaLabelledBy(),h=o.getAriaDescribedBy(),B=o.hasListeners("press")?o._getBadge():null,j=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("AVATAR_ROLE_DESCRIPTION");r.openStart("span",o);r.class(g);r.class("sapFAvatarColor"+o._getActualBackgroundColor());r.class(g+d);r.class(g+s);r.class(g+D);if(o.hasListeners("press")){r.class("sapMPointer");r.class(g+"Focusable");r.attr("role","button");r.attr("tabindex",0);}else{r.attr("role","img");}r.attr("aria-roledescription",j);if(o.getShowBorder()){r.class("sapFAvatarBorder");}if(d===A.Custom){r.style("width",C);r.style("height",C);r.style("font-size",f);}if(t){r.attr("title",t);r.attr("aria-label",t);}else if(i){r.attr("aria-label",i);}if(L&&L.length>0){r.attr("aria-labelledby",L.join(" "));}if(h&&h.length>0){r.attr("aria-describedby",h.join(" "));}r.openEnd();if(s===a.Icon||I===a.Icon){r.renderControl(o._getIcon().addStyleClass(g+"TypeIcon"));}else if(s===a.Initials||I===a.Initials){r.openStart("span");r.class(g+"InitialsHolder");r.openEnd();r.text(i);r.close("span");}if(s===a.Image){r.openStart("span");r.class(g+"ImageHolder");r.class(g+s+c);r.style("background-image","url('"+e(S)+"')");r.openEnd();r.close("span");}if(B){r.openStart("div");r.class(g+"BadgeIconActiveArea");if(C){r.style("font-size",C);}r.openEnd();r.openStart("span");r.class(g+"BadgeIcon");r.openEnd();r.renderControl(B);r.close("span");r.close("div");}r.close("span");};
return b;},true);
sap.ui.predefine('sap/m/AvatarShape',[],function(){"use strict";var A={Circle:"Circle",Square:"Square"};return A;});
sap.ui.predefine('sap/m/AvatarSize',[],function(){"use strict";var A={XS:"XS",S:"S",M:"M",L:"L",XL:"XL",Custom:"Custom"};return A;});
sap.ui.predefine('sap/m/AvatarType',[],function(){"use strict";var A={Icon:"Icon",Image:"Image",Initials:"Initials"};return A;});
sap.ui.predefine('sap/m/BadgeCustomData',['sap/ui/core/CustomData','sap/base/Log'],function(C,L){"use strict";
var B=C.extend("sap.m.BadgeCustomData",{metadata:{properties:{visible:{type:"boolean",group:"Appearance",defaultValue:true}}}});
B.prototype.init=function(){var p=this.getParent();if(p&&!p.isA("sap.m.IBadge")){L.warning("BadgeCustomData must be attached only to controls, which implement sap.m.IBadge");}};
B.prototype.setValue=function(v){if(this.getValue()===v){return this;}var p=this.getParent();C.prototype.setValue.call(this,v);if(p&&typeof v==="string"){p.updateBadgeValue(v);}return this;};
B.prototype.setVisible=function(v){if(this.getVisible()===v){return this;}this.setProperty("visible",v,true);var p=this.getParent();if(p){p.updateBadgeVisibility(v);}return this;};
B.prototype.setKey=function(){return this;};
return B;});
sap.ui.predefine('sap/m/BadgeEnabler',['sap/m/BadgeCustomData','sap/base/Log','sap/m/library'],function(B,L,l){"use strict";var I="sapMBadge";var a={topLeft:"sapMBadgeTopLeft",topRight:"sapMBadgeTopRight",inline:"sapMBadgeInline"};var b=l.BadgeState;var c=l.BadgeStyle;var d=["","undefined","null"];var e=function(){this.initBadgeEnablement=function(C,o){var D=o?o:this;this._oBadgeConfig=C||{};D.addEventDelegate({onAfterRendering:f},this);};function _(C,o){if(C.suffix){return o.$(C.suffix);}if(C.selector){return o.$().find(C.selector).first();}}function f(){this._isBadgeAttached=false;if(!this.getBadgeCustomData()||!this.getBadgeCustomData().getVisible()){return false;}j.call(this);if(!Object.keys(this._oBadgeConfig).length){return this;}return this;}function g(){var o=h.call(this);o.removeClass("sapMBadgeAnimationUpdate");o.removeClass("sapMBadgeAnimationAdd");o.width();o.addClass("sapMBadgeAnimationRemove");o.removeAttr("aria-label");this._isBadgeAttached=false;m.call(this,"",b["Disappear"]);return this;}function h(){return this.$(I);}function i(){return this.getId()+"-"+I;}function j(){var o,s=i.call(this),p=h.call(this),q=typeof this.badgeValueFormatter==="function"&&this.badgeValueFormatter,v=n(q?q.call(this,this.getBadgeCustomData().getValue()):this.getBadgeCustomData().getValue()),S=this._oBadgeConfig.style?this._oBadgeConfig.style:c.Default;this._oBadgeContainer=this._oBadgeConfig&&this._oBadgeConfig.selector?_(this._oBadgeConfig.selector,this):this.$();if(p.length){p.remove();}o=jQuery('<div></div>').addClass(I+"Indicator");o.addClass(I+S);o.attr("id",s);o.attr("data-badge",v);o.attr("aria-label",k.call(this));o.appendTo(this._oBadgeContainer);o.addClass("sapMBadgeAnimationAdd");this._isBadgeAttached=true;this._oBadgeContainer.addClass(I);if(this._oBadgeConfig.position){this._oBadgeContainer.addClass(a[this._oBadgeConfig.position]);}if(this._oBadgeConfig.accentColor){this._oBadgeContainer.addClass(I+this._oBadgeConfig.accentColor);}m.call(this,v,b["Appear"]);}this.updateBadgeValue=function(v){var o=typeof this.badgeValueFormatter==="function"&&this.badgeValueFormatter,p;v=n((o?o.call(this,v):v)||this.getBadgeCustomData().getValue())||"";if(!this.getBadgeCustomData().getVisible()){return false;}p=h.call(this);p.removeClass("sapMBadgeAnimationUpdate");p.attr("data-badge",v);p.attr("aria-label",k.call(this));p.width();p.addClass("sapMBadgeAnimationUpdate");m.call(this,v,b["Updated"]);};function k(){var A=this.getAriaLabelBadgeText;return A&&typeof A==="function"&&A.call(this);}function m(v,s){if(this.onBadgeUpdate&&typeof this.onBadgeUpdate==="function"){var o=i.call(this);return this.onBadgeUpdate(v,s,o);}}function n(v){return d.indexOf(v)===-1&&v;}this.addCustomData=function(C){if(C.isA("sap.m.BadgeCustomData")){this.removeAggregation("customData",this._oBadgeCustomData,true);this._oBadgeCustomData=C;this.addAggregation("customData",C,true);return this.updateBadgeVisibility(C.getVisible());}return this.addAggregation("customData",C);};this.insertCustomData=function(C){if(C.isA("sap.m.BadgeCustomData")){this.removeAggregation("customData",this._oBadgeCustomData,true);this._oBadgeCustomData=C;this.addAggregation("customData",C,true);return this.updateBadgeVisibility(C.getVisible());}return this.insertAggregation("customData",C);};this.getBadgeCustomData=function(){var o=this.getCustomData().filter(function(p){return p instanceof B;});return o.length?o[0]:undefined;};this.removeBadgeCustomData=function(){var o;o=this._oBadgeCustomData;this._oBadgeCustomData=null;return this.removeAggregation("customData",o,true);};this.setBadgeAccentColor=function(v){if(!this._oBadgeContainer){return false;}this._oBadgeContainer.removeClass(I+this._oBadgeConfig.accentColor);this._oBadgeContainer.addClass(I+v);this._oBadgeConfig.accentColor=v;};this.setBadgePosition=function(v){if(!this._oBadgeContainer){return false;}this._oBadgeContainer.removeClass(I+this._oBadgeConfig.position);this._oBadgeContainer.addClass(a[v]);this._oBadgeConfig.position=v;};this.updateBadgeVisibility=function(v){return v?j.call(this):g.call(this);};this._renderBadge=function(){f.call(this);};};return e;});
sap.ui.predefine('sap/m/Bar',['./BarInPageEnabler','./library','sap/ui/core/Control','sap/ui/core/ResizeHandler','sap/ui/Device','./BarRenderer',"sap/ui/thirdparty/jquery"],function(B,l,C,R,D,a,q){"use strict";var b=l.BarDesign;
var c=C.extend("sap.m.Bar",{metadata:{interfaces:["sap.m.IBar"],library:"sap.m",properties:{enableFlexBox:{type:"boolean",group:"Misc",defaultValue:false,deprecated:true},translucent:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},design:{type:"sap.m.BarDesign",group:"Appearance",defaultValue:b.Auto}},aggregations:{contentLeft:{type:"sap.ui.core.Control",multiple:true,singularName:"contentLeft"},contentMiddle:{type:"sap.ui.core.Control",multiple:true,singularName:"contentMiddle"},contentRight:{type:"sap.ui.core.Control",multiple:true,singularName:"contentRight"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},designtime:"sap/m/designtime/Bar.designtime",dnd:{draggable:false,droppable:true}}});
c.prototype.onBeforeRendering=function(){this._removeAllListeners();};
c.prototype.onAfterRendering=function(){this._handleResize();};
c.prototype.init=function(){this.data("sap-ui-fastnavgroup","true",true);};
c.prototype.exit=function(){this._removeAllListeners();if(this._oflexBox){this._oflexBox.destroy();this._oflexBox=null;}this._$MidBarPlaceHolder=null;this._$RightBar=null;this._$LeftBar=null;};
c._aResizeHandlers=["_sResizeListenerId","_sResizeListenerIdMid","_sResizeListenerIdRight","_sResizeListenerIdLeft"];
c.prototype._removeAllListeners=function(){var t=this;c._aResizeHandlers.forEach(function(i){t._removeListenerFailsave(i);});};
c.prototype._removeListenerFailsave=function(L){if(this[L]){R.deregister(this[L]);this[L]=null;}};
c.prototype._handleResize=function(){this._removeAllListeners();var e=!!this.getContentLeft().length,f=!!this.getContentMiddle().length,g=!!this.getContentRight().length;if(!this.getVisible()){return;}if(!e&&!f&&!g){return;}this._$LeftBar=this.$("BarLeft");this._$RightBar=this.$("BarRight");this._$MidBarPlaceHolder=this.$("BarPH");this._updatePosition(e,f,g);this._sResizeListenerId=R.register(this.getDomRef(),q.proxy(this._handleResize,this));if(this.getEnableFlexBox()){return;}if(e){this._sResizeListenerIdLeft=R.register(this._$LeftBar[0],q.proxy(this._handleResize,this));}if(f){this._sResizeListenerIdMid=R.register(this._$MidBarPlaceHolder[0],q.proxy(this._handleResize,this));}if(g){this._sResizeListenerIdRight=R.register(this._$RightBar[0],q.proxy(this._handleResize,this));}};
c.prototype._updatePosition=function(e,f,g){if(!e&&!g&&f){return;}if(e&&!f&&!g){return;}if(!e&&!f&&g){return;}var i=this.$().outerWidth(true);this._$RightBar.css({width:""});this._$LeftBar.css({width:""});if(D.browser.msie){this._$MidBarPlaceHolder.css({position:"",width:""});}else{this._$MidBarPlaceHolder.css({position:"",width:"",visibility:"hidden"});}var r=this._$RightBar.outerWidth(true);if(r>i){if(e){this._$LeftBar.css({width:"0px"});}if(f){this._$MidBarPlaceHolder.css({width:"0px"});}this._$RightBar.css({width:i+"px"});return;}var L=this._getBarContainerWidth(this._$LeftBar);if(i<(L+r)){L=i-r;this._$LeftBar.css({width:L+"px"});this._$MidBarPlaceHolder.css({width:"0px"});return;}this._$MidBarPlaceHolder.css(this._getMidBarCss(r,i,L));};
c.prototype._getMidBarCss=function(r,i,L){var m=this._$MidBarPlaceHolder.outerWidth(true),e=sap.ui.getCore().getConfiguration().getRTL(),s=e?"right":"left",M={visibility:""};if(this.getEnableFlexBox()){m=i-L-r-parseInt(this._$MidBarPlaceHolder.css('margin-left'))-parseInt(this._$MidBarPlaceHolder.css('margin-right'));M.position="absolute";M.width=m+"px";M[s]=L;return M;}var S=i-L-r,f=(i/2)-(m/2),g=L>f,h=(i/2)+(m/2),j=(i-r)<h;if(this._$MidBarPlaceHolder.closest(".sapMBarTitleStart").length>0||(S>0&&(g||j))){M.position="absolute";M.width=S+"px";M.left=e?r:L;}return M;};
c.prototype._getBarContainerWidth=function($){var i,e=0,f=$.children(),g=0;if(D.browser.webkit||D.browser.firefox||D.browser.edge){for(i=0;i<f.length;i++){g+=q(f[i]).outerWidth(true);}e=$.outerWidth(true);}else{var o;for(i=0;i<f.length;i++){o=window.getComputedStyle(f[i]);if(o.width=="auto"){g+=q(f[i]).width()+1;}else{g+=parseFloat(o.width);}g+=parseFloat(o.marginLeft);g+=parseFloat(o.marginRight);g+=parseFloat(o.paddingLeft);g+=parseFloat(o.paddingRight);}var h=window.getComputedStyle($[0]);e+=parseFloat(h.width);e+=parseFloat(h.marginLeft);e+=parseFloat(h.marginRight);e+=parseFloat(h.paddingLeft);e+=parseFloat(h.paddingRight);}if(e<g){e=g;}return e;};
var d=B.extend("sap.m.BarInAnyContentEnabler",{});
d.mContexts={dialogFooter:{contextClass:"sapMFooter-CTX",tag:"Footer"}};
d.prototype.getContext=function(){var p=B.prototype.getContext.call();for(var k in d.mContexts){p[k]=d.mContexts[k];}return p;};
c.prototype.getContext=d.prototype.getContext;c.prototype.isContextSensitive=d.prototype.isContextSensitive;c.prototype.setHTMLTag=d.prototype.setHTMLTag;c.prototype.getHTMLTag=d.prototype.getHTMLTag;c.prototype.applyTagAndContextClassFor=d.prototype.applyTagAndContextClassFor;c.prototype._applyContextClassFor=d.prototype._applyContextClassFor;c.prototype._applyTag=d.prototype._applyTag;c.prototype._getContextOptions=d.prototype._getContextOptions;c.prototype._setRootAccessibilityRole=d.prototype._setRootAccessibilityRole;c.prototype._getRootAccessibilityRole=d.prototype._getRootAccessibilityRole;c.prototype._setRootAriaLevel=d.prototype._setRootAriaLevel;c.prototype._getRootAriaLevel=d.prototype._getRootAriaLevel;return c;});
sap.ui.predefine('sap/m/BarInPageEnabler',['sap/ui/base/Object','sap/m/library',"sap/base/Log"],function(O,l,L){"use strict";var I=l.IBarHTMLTag;var c={footer:{contextClass:"sapMFooter-CTX sapContrast sapContrastPlus",tag:"Footer",internalAriaLabel:"BAR_ARIA_DESCRIPTION_FOOTER"},header:{contextClass:"sapMHeader-CTX",tag:"Header",internalAriaLabel:"BAR_ARIA_DESCRIPTION_HEADER"},subheader:{contextClass:"sapMSubHeader-CTX",tag:"Header",internalAriaLabel:"BAR_ARIA_DESCRIPTION_SUBHEADER"}};var a="sapMIBar";
var B=O.extend("sap.m.BarInPageEnabler",{
isContextSensitive:function(){return this.getDesign&&this.getDesign()==="Auto";},
setHTMLTag:function(n){if(n===this.sTag){return this;}this.sTag=n;return this;},
getHTMLTag:function(){if(!this.hasOwnProperty("sTag")){this.sTag=I.Div;}return this.sTag;},
getContext:function(){return c;},
_getRootAccessibilityRole:function(){var r=this._sRootAccessibilityRole||"toolbar";return r;},
_setRootAccessibilityRole:function(r){this._sRootAccessibilityRole=r;return this;},
_getRootAriaLevel:function(){var A=this.sAriaLevel;return A;},
_setRootAriaLevel:function(s){this.sAriaLevel=s;return this;},
applyTagAndContextClassFor:function(C){this._applyTag(C);return this._applyContextClassFor(C);},
_applyContextClassFor:function(C){var o=this._getContextOptions(C);if(!o){return this;}if(!this.isContextSensitive){L.error("The bar control you are using does not implement all the members of the IBar interface",this);return this;}if(!this.getRenderer().shouldAddIBarContext()){this.addStyleClass(a+"-CTX");}if(this.isContextSensitive()){this.addStyleClass(o.contextClass);}return this;},
_applyTag:function(C){var o=this._getContextOptions(C);if(!o){return this;}if(!this.setHTMLTag){L.error("The bar control you are using does not implement all the members of the IBar interface",this);return this;}this.setHTMLTag(o.tag);return this;},
_getContextOptions:function(C){var o;if(this.getContext){o=this.getContext();}else{o=c;}var b=o[C];if(!b){L.error("The context "+C+" is not known",this);return null;}return b;},
render:function(r,C){var t=C.getHTMLTag().toLowerCase();r.openStart(t,C);r.class(a);if(this.shouldAddIBarContext(C)){r.class(a+"-CTX");}B.renderTooltip(r,C);this.decorateRootElement(r,C);r.openEnd();this.renderBarContent(r,C);r.close(t);}
});
B.renderTooltip=function(r,C){var t=C.getTooltip_AsString();if(t){r.attr("title",t);}};
B.addChildClassTo=function(C){C.addStyleClass("sapMBarChild");};
return B;});
sap.ui.predefine('sap/m/BarRenderer',['./BarInPageEnabler','sap/ui/Device',"sap/base/Log",'sap/m/HBox'],function(B,D,L,H){"use strict";var a={apiVersion:2};a.render=B.prototype.render;
a.decorateRootElement=function(r,c){r.class("sapMBar");r.class(this.getContext(c));r.accessibilityState(c,{"role":c._getRootAccessibilityRole(),"level":c._getRootAriaLevel()});if(c.getTranslucent()&&D.support.touch){r.class("sapMBarTranslucent");}r.class("sapMBar-CTX");};
a.shouldAddIBarContext=function(){return true;};
a.renderBarContent=function(r,c){r.openStart("div",c.getId()+"-BarLeft");r.class("sapMBarLeft");r.class("sapMBarContainer");w("left",r,c);r.openEnd();this.renderAllControls(c.getContentLeft(),r,c);r.close("div");r.openStart("div",c.getId()+"-BarMiddle");r.class("sapMBarMiddle");r.openEnd();if(c.getEnableFlexBox()){c._oflexBox=c._oflexBox||new H(c.getId()+"-BarPH",{alignItems:"Center"}).addStyleClass("sapMBarPH").setParent(c,null,true);var C=!!c.getContentLeft().length,b=!!c.getContentMiddle().length,d=!!c.getContentRight().length;if(b&&!C&&!d){c._oflexBox.addStyleClass("sapMBarFlexBoxWidth100");}c.getContentMiddle().forEach(function(m){c._oflexBox.addItem(m);});r.renderControl(c._oflexBox);}else{r.openStart("div",c.getId()+"-BarPH");r.class("sapMBarPH");r.class("sapMBarContainer");w("middle",r,c);r.openEnd();this.renderAllControls(c.getContentMiddle(),r,c);r.close("div");}r.close("div");r.openStart("div",c.getId()+"-BarRight");r.class("sapMBarRight");r.class("sapMBarContainer");if(sap.ui.getCore().getConfiguration().getRTL()){r.class("sapMRTL");}w("right",r,c);r.openEnd();this.renderAllControls(c.getContentRight(),r,c);r.close("div");};
a.renderAllControls=function(c,r,b){c.forEach(function(C){B.addChildClassTo(C,b);r.renderControl(C);});};
a._mContexts={Header:"sapMHeader-CTX",SubHeader:"sapMSubHeader-CTX",Footer:"sapMFooter-CTX",Default:"sapMContent-CTX"};
a.getContext=function(c){var d=c.getDesign(),C=a._mContexts;return C[d]||C.Default;};
function w(A,r,c){var C=!!c.getContentLeft().length,b=!!c.getContentMiddle().length,d=!!c.getContentRight().length;switch(A.toLowerCase()){case"left":if(C&&!b&&!d){r.style("width","100%");}break;case"middle":if(b&&!C&&!d){r.style("width","100%");}break;case"right":if(d&&!C&&!b){r.style("width","100%");}break;default:L.error("Cannot determine which of the three content aggregations is alone");}}
return a;},true);
sap.ui.predefine('sap/m/Breadcrumbs',["sap/ui/core/Control","sap/m/Text","sap/m/Link","sap/m/Select","sap/ui/core/Item","sap/ui/core/delegate/ItemNavigation","sap/ui/core/ResizeHandler","sap/ui/core/IconPool","sap/ui/Device","sap/m/library","./BreadcrumbsRenderer"],function(C,T,L,S,I,a,R,b,D,l,B){"use strict";var c=l.SelectType,d=l.BreadcrumbsSeparatorStyle;
var e=C.extend("sap.m.Breadcrumbs",{metadata:{library:"sap.m",interfaces:["sap.m.IBreadcrumbs"],designtime:"sap/m/designtime/Breadcrumbs.designtime",properties:{currentLocationText:{type:"string",group:"Behavior",defaultValue:null},separatorStyle:{type:"sap.m.BreadcrumbsSeparatorStyle",group:"Appearance",defaultValue:d.Slash}},aggregations:{links:{type:"sap.m.Link",multiple:true,singularName:"link"},_currentLocation:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_select:{type:"sap.m.Select",multiple:false,visibility:"hidden"}},defaultAggregation:"links"}});
e.STYLE_MAPPER={Slash:"/",BackSlash:"\\",DoubleSlash:"//",DoubleBackSlash:"\\\\",GreaterThan:">",DoubleGreaterThan:">>"};
e.prototype.init=function(){this._sSeparatorSymbol=e.STYLE_MAPPER[this.getSeparatorStyle()];};
e.prototype.onBeforeRendering=function(){this.bRenderingPhase=true;if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}if(this._bControlsInfoCached){this._updateSelect(true);}};
e.prototype.onAfterRendering=function(){if(!this._sResizeListenerId){this._sResizeListenerId=R.register(this,this._handleScreenResize.bind(this));}if(!this._bControlsInfoCached){this._updateSelect(true);return;}this._configureKeyboardHandling();this.bRenderingPhase=false;};
e.prototype.onThemeChanged=function(){this._resetControl();};
e.prototype.exit=function(){this._resetControl();this._destroyItemNavigation();};
e.PAGEUP_AND_PAGEDOWN_JUMP_SIZE=5;
e.prototype._getAugmentedId=function(s){return this.getId()+"-"+s;};
e.prototype._getSelect=function(){if(!this.getAggregation("_select")){this.setAggregation("_select",this._decorateSelect(new S({id:this._getAugmentedId("select"),change:this._selectChangeHandler.bind(this),forceSelection:false,autoAdjustWidth:true,icon:b.getIconURI("slim-arrow-down"),type:c.IconOnly,tooltip:B._getResourceBundleText("BREADCRUMB_SELECT_TOOLTIP")})),true);}return this.getAggregation("_select");};
e.prototype._getCurrentLocation=function(){if(!this.getAggregation("_currentLocation")){var o=new T({id:this._getAugmentedId("currentText"),text:this.getCurrentLocationText(),wrapping:false}).addStyleClass("sapMBreadcrumbsCurrentLocation");o.addEventDelegate({onAfterRendering:function(){o.$().attr("aria-current","page");}});this.setAggregation("_currentLocation",o).addStyleClass("sapMBreadcrumbsCurrentLocation");}return this.getAggregation("_currentLocation");};
function f(A,h){var i=Array.prototype.slice.apply(h);i.unshift(A);return i;}
e.prototype.insertLink=function(o,i){var r=this.insertAggregation.apply(this,f("links",arguments));this._registerControlListener(o);this._resetControl();return r;};
e.prototype.addLink=function(o){var r=this.addAggregation.apply(this,f("links",arguments));this._registerControlListener(o);this._resetControl();return r;};
e.prototype.removeLink=function(o){var r=this.removeAggregation.apply(this,f("links",arguments));this._deregisterControlListener(r);this._resetControl();return r;};
e.prototype.removeAllLinks=function(){var h=this.getAggregation("links",[]);var r=this.removeAllAggregation.apply(this,f("links",arguments));h.forEach(this._deregisterControlListener,this);this._resetControl();return r;};
e.prototype.destroyLinks=function(){var h=this.getAggregation("links",[]);var r=this.destroyAggregation.apply(this,f("links",arguments));h.forEach(this._deregisterControlListener,this);this._resetControl();return r;};
e.prototype._decorateSelect=function(s){s.getPicker().attachAfterOpen(this._removeItemNavigation,this).attachBeforeClose(this._restoreItemNavigation,this);s._onBeforeOpenDialog=this._onSelectBeforeOpenDialog.bind(this);s._onBeforeOpenPopover=this._onSelectBeforeOpenPopover.bind(this);s.onsapescape=this._onSelectEscPress.bind(this);return s;};
e.prototype._removeItemNavigation=function(){this.removeDelegate(this._getItemNavigation());};
e.prototype._onSelectBeforeOpenDialog=function(){var s=this._getSelect();if(this.getCurrentLocationText()&&D.system.phone){s.setSelectedIndex(0);}else{s.setSelectedItem(null);}S.prototype._onBeforeOpenDialog.call(s);this._removeItemNavigation();};
e.prototype._onSelectBeforeOpenPopover=function(){this._getSelect().setSelectedItem(null);this._removeItemNavigation();};
e.prototype._restoreItemNavigation=function(){this.addDelegate(this._getItemNavigation());};
e.prototype._onSelectEscPress=function(){this._getSelect().close();};
e.prototype._createSelectItem=function(i){return new I({key:i.getId(),text:i.getText()});};
e.prototype._selectChangeHandler=function(E){var o,s,h,i=E.getParameter("selectedItem");if(!i){return;}if(!this._getSelect().isOpen()){return;}o=sap.ui.getCore().byId(i.getKey());if(!(o instanceof L)){return;}s=o.getHref();h=o.getTarget();o.firePress();if(s){if(h){window.open(s,h);}else{window.location.href=s;}}};
e.prototype._getItemsForMobile=function(){var i=this.getLinks();if(this.getCurrentLocationText()){i.push(this._getCurrentLocation());}return i;};
e.prototype._updateSelect=function(i){var s=this._getSelect(),h,o=this._getControlDistribution();if(!this._bControlDistributionCached||i){s.destroyItems();h=D.system.phone?this._getItemsForMobile():o.aControlsForSelect;h.map(this._createSelectItem).reverse().forEach(s.insertItem,s);this._bControlDistributionCached=true;this.invalidate(this);}s.setVisible(!!o.aControlsForSelect.length);if(!this._sResizeListenerId&&!this.bRenderingPhase){this._sResizeListenerId=R.register(this,this._handleScreenResize.bind(this));}};
e.prototype._getControlsForBreadcrumbTrail=function(){var v;if(this._bControlDistributionCached&&this._oDistributedControls){return this._oDistributedControls.aControlsForBreadcrumbTrail;}v=this.getLinks().filter(function(o){return o.getVisible();});if(this.getCurrentLocationText()){return v.concat([this._getCurrentLocation()]);}return v;};
e.prototype._getControlInfo=function(o){return{id:o.getId(),control:o,width:g(o.$().parent()),bCanOverflow:o instanceof L};};
e.prototype._getControlDistribution=function(m){m=m||this._iContainerSize;this._iContainerSize=m;this._oDistributedControls=this._determineControlDistribution(m);return this._oDistributedControls;};
e.prototype._getSelectWidth=function(){return this._getSelect().getVisible()&&this._iSelectWidth||0;};
e.prototype._determineControlDistribution=function(m){var i,o,h=this._getControlsInfo().aControlInfo,s=this._getSelectWidth(),j=[],k=[],u=s;for(i=h.length-1;i>=0;i--){o=h[i];u+=o.width;if(h.length-1===i){k.push(o.control);continue;}if(i===0){u-=s;}if(u>m&&o.bCanOverflow){j.unshift(o.control);}else{k.unshift(o.control);}}return{aControlsForBreadcrumbTrail:k,aControlsForSelect:j};};
e.prototype._getControlsInfo=function(){if(!this._bControlsInfoCached){this._iSelectWidth=g(this._getSelect().$().parent())||0;this._aControlInfo=this._getControlsForBreadcrumbTrail().map(this._getControlInfo);this._iContainerSize=g(this.$());this._bControlsInfoCached=true;}return{aControlInfo:this._aControlInfo,iSelectWidth:this._iSelectWidth,iContentSize:this._iContainerSize};};
e.prototype._handleScreenResize=function(E){var i=this._oDistributedControls.aControlsForBreadcrumbTrail.length,o=this._getControlDistribution(E.size.width),h=o.aControlsForBreadcrumbTrail.length;if(i!==h){this._updateSelect(true);}return this;};
e.prototype._getItemsToNavigate=function(){var i=this._getControlsForBreadcrumbTrail().slice(),s=this._getSelect();if(s.getVisible()){i.unshift(s);}return i;};
e.prototype._getItemNavigation=function(){if(!this._itemNavigation){this._itemNavigation=new a();}return this._itemNavigation;};
e.prototype._destroyItemNavigation=function(){if(this._itemNavigation){this.removeEventDelegate(this._itemNavigation);this._itemNavigation.destroy();this._itemNavigation=null;}};
e.prototype._configureKeyboardHandling=function(){var i=this._getItemNavigation(),s=-1,h=this._getItemsToNavigate(),n=[];if(h.length===0){return;}h.forEach(function(o,j){if(j===0){o.$().attr("tabindex","0");}o.$().attr("tabindex","-1");n.push(o.getDomRef());});this.addDelegate(i);i.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"],saphome:["alt"],sapend:["alt"]});i.setCycling(false);i.setPageSize(e.PAGEUP_AND_PAGEDOWN_JUMP_SIZE);i.setRootDomRef(this.getDomRef());i.setItemDomRefs(n);i.setSelectedIndex(s);return this;};
e.prototype._registerControlListener=function(o){if(o){o.attachEvent("_change",this._resetControl,this);}};
e.prototype._deregisterControlListener=function(o){if(o){o.detachEvent("_change",this._resetControl,this);}};
e.prototype.setCurrentLocationText=function(t){var o=this._getCurrentLocation(),r=this.setProperty("currentLocationText",t,true);if(o.getText()!==t){o.setText(t);this._resetControl();}return r;};
e.prototype.setSeparatorStyle=function(s){this.setProperty("separatorStyle",s);var h=e.STYLE_MAPPER[this.getSeparatorStyle()];if(h){this._sSeparatorSymbol=h;}return this;};
e.prototype._resetControl=function(){this._aControlInfo=null;this._iContainerSize=null;this._bControlsInfoCached=null;this._bControlDistributionCached=null;this._oDistributedControls=null;if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}this.removeDelegate(this._getItemNavigation());this.invalidate(this);return this;};
function g($){var m;if($.length){m=$.outerWidth(true)-$.outerWidth();return $.get(0).getBoundingClientRect().width+m;}}
return e;});
sap.ui.predefine('sap/m/BreadcrumbsRenderer',["sap/m/Text"],function(T){"use strict";var B={apiVersion:2};var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");
B.render=function(R,c){var C=c._getControlsForBreadcrumbTrail(),s=c._getSelect(),S=c._sSeparatorSymbol;R.openStart("nav",c);R.class("sapMBreadcrumbs");R.attr("aria-label",B._getResourceBundleText("BREADCRUMB_LABEL"));R.openEnd();R.openStart("ol");R.openEnd();if(s.getVisible()){this._renderControlInListItem(R,s,S,false,"sapMBreadcrumbsSelectItem");}C.forEach(function(o){this._renderControlInListItem(R,o,S,o instanceof T);},this);R.close("ol");R.close("nav");};
B._renderControlInListItem=function(R,c,s,S,a){R.openStart("li");R.class("sapMBreadcrumbsItem");R.class(a);R.openEnd();R.renderControl(c);if(!S){R.openStart("span").class("sapMBreadcrumbsSeparator").openEnd().text(s).close("span");}R.close("li");};
B._getResourceBundleText=function(t){return r.getText(t);};
return B;},true);
sap.ui.predefine('sap/m/BusyDialog',['./library','sap/ui/core/Control','sap/m/Dialog','sap/m/BusyIndicator','sap/m/Label','sap/m/Button',"sap/base/Log",'sap/ui/core/Core'],function(l,C,D,B,L,a,b,c){"use strict";
var d=C.extend("sap.m.BusyDialog",{
metadata:{library:"sap.m",properties:{text:{type:"string",group:"Appearance",defaultValue:''},title:{type:"string",group:"Appearance",defaultValue:''},customIcon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:''},customIconRotationSpeed:{type:"int",group:"Appearance",defaultValue:1000},customIconDensityAware:{type:"boolean",defaultValue:true},customIconWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"44px"},customIconHeight:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"44px"},cancelButtonText:{type:"string",group:"Misc",defaultValue:''},showCancelButton:{type:"boolean",group:"Appearance",defaultValue:false}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{close:{parameters:{cancelPressed:{type:"boolean"}}}},designtime:"sap/m/designtime/BusyDialog.designtime"},
renderer:{apiVersion:2,render:function(r,o){}}
});
d.prototype.init=function(){this._busyIndicator=new B(this.getId()+'-busyInd',{visible:true});this._oDialog=new D(this.getId()+'-Dialog',{content:this._busyIndicator,showHeader:false,afterClose:this._fnCloseHandler.bind(this),initialFocus:this._busyIndicator.getId()+'-busyIndicator'}).addStyleClass('sapMBusyDialog');this._oDialog.close=function(){};this._oDialog.addEventDelegate({onBeforeRendering:function(){var t=this.getText(),e=this.getTitle(),s=this.getShowCancelButton()||this.getCancelButtonText();if(!t&&!e&&!s){this._oDialog.addStyleClass('sapMBusyDialog-Light');}else{this._oDialog.removeStyleClass('sapMBusyDialog-Light');}}},this);this._oDialog.oPopup.onsapescape=function(e){this.close(true);}.bind(this);};
d.prototype.exit=function(){this._busyIndicator.destroy();this._busyIndicator=null;if(this._cancelButton){this._cancelButton.destroy();this._cancelButton=null;}if(this._oLabel){this._oLabel.destroy();this._oLabel=null;}if(this._oDialog){this._oDialog.destroy();this._oDialog=null;}};
d.prototype.open=function(){b.debug("sap.m.BusyDialog.open called at "+new Date().getTime());if(this.getAriaLabelledBy()&&!this._oDialog._$dialog){var t=this;this.getAriaLabelledBy().forEach(function(i){t._oDialog.addAriaLabelledBy(i);});}if(!document.body||!c.isInitialized()){setTimeout(function(){this.open();}.bind(this),50);}else{this._oDialog.open();}return this;};
d.prototype.close=function(i){this._isClosedFromUserInteraction=i;D.prototype.close.call(this._oDialog);return this;};
d.prototype._fnCloseHandler=function(){this.fireClose({cancelPressed:this._isClosedFromUserInteraction||false});};
d.prototype.setTitle=function(t){this.setProperty('title',t,true);this._oDialog.setTitle(t).setShowHeader(!!t);return this;};
d.prototype.setTooltip=function(t){this._oDialog.setTooltip(t);return this;};
d.prototype.getTooltip=function(){return this._oDialog.getTooltip();};
d.prototype.setText=function(t){this.setProperty('text',t,true);if(!this._oLabel){if(t){this._oLabel=new L(this.getId()+'-TextLabel',{text:t}).addStyleClass('sapMBusyDialogLabel');this._oDialog.insertAggregation('content',this._oLabel,0);this._oDialog.addAriaLabelledBy(this._oLabel.getId());}}else{if(t){this._oLabel.setText(t).setVisible(true);}else{this._oLabel.setVisible(false);}}return this;};
d.prototype.setCustomIcon=function(i){this.setProperty("customIcon",i,true);this._busyIndicator.setCustomIcon(i);return this;};
d.prototype.setCustomIconRotationSpeed=function(s){this.setProperty("customIconRotationSpeed",s,true);this._busyIndicator.setCustomIconRotationSpeed(s);return this;};
d.prototype.setCustomIconDensityAware=function(i){this.setProperty("customIconDensityAware",i,true);this._busyIndicator.setCustomIconDensityAware(i);return this;};
d.prototype.setCustomIconWidth=function(w){this.setProperty("customIconWidth",w,true);this._busyIndicator.setCustomIconWidth(w);return this;};
d.prototype.setCustomIconHeight=function(h){this.setProperty("customIconHeight",h,true);this._busyIndicator.setCustomIconHeight(h);return this;};
d.prototype.setShowCancelButton=function(i){this.setProperty("showCancelButton",i,false);if(i){this._oDialog.setEndButton(this._getCancelButton());}else{this._destroyTheCancelButton();}return this;};
d.prototype.setCancelButtonText=function(t){this.setProperty("cancelButtonText",t,false);if(t){this._getCancelButton().setText(t);this._oDialog.setEndButton(this._getCancelButton());}else{this._destroyTheCancelButton();}return this;};
d.prototype.getDomRef=function(){return this._oDialog&&this._oDialog.getDomRef();};
["addStyleClass","removeStyleClass","toggleStyleClass","hasStyleClass"].forEach(function(A){d.prototype[A]=function(){if(this._oDialog&&this._oDialog[A]){this._oDialog[A].apply(this._oDialog,arguments);return this;}};});
d.prototype._destroyTheCancelButton=function(){this._oDialog.destroyEndButton();this._cancelButton=null;};
d.prototype._getCancelButton=function(){var e=this.getCancelButtonText();e=e?e:c.getLibraryResourceBundle("sap.m").getText("BUSYDIALOG_CANCELBUTTON_TEXT");return this._cancelButton?this._cancelButton:this._cancelButton=new a(this.getId()+'busyCancelBtn',{text:e,press:function(){this.close(true);}.bind(this)});};
return d;});
sap.ui.predefine('sap/m/BusyIndicator',['./library','sap/ui/core/Control','sap/ui/core/library','sap/m/Image','sap/m/Label',"./BusyIndicatorRenderer"],function(l,C,c,I,L,B){"use strict";var T=c.TextDirection;
var a=C.extend("sap.m.BusyIndicator",{metadata:{library:"sap.m",properties:{text:{type:"string",group:"Data",defaultValue:""},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit},customIcon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:""},customIconRotationSpeed:{type:"int",group:"Appearance",defaultValue:1000},customIconDensityAware:{type:"boolean",defaultValue:true},customIconWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"44px"},customIconHeight:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"44px"},size:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:"1rem"},design:{type:"string",group:"Appearance",defaultValue:"auto"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}}}});
a.prototype.init=function(){this.setBusyIndicatorDelay(0);};
a.prototype.onBeforeRendering=function(){if(this.getCustomIcon()){this.setBusy(false);}else{this.setBusy(true,"busy-area");}if(this._busyLabel){this._busyLabel.setTextDirection(this.getTextDirection());}if(this._iconImage){this._iconImage.setDensityAware(this.getCustomIconDensityAware());this._iconImage.setSrc(this.getCustomIcon());this._iconImage.setWidth(this.getCustomIconWidth());this._iconImage.setHeight(this.getCustomIconHeight());}else if(!this._iconImage&&this.getCustomIcon()){this._createCustomIcon(this.getCustomIcon()).addStyleClass("sapMBsyIndIcon");}if(this._busyLabel){this._busyLabel.setText(this.getText());this._busyLabel.setTextDirection(this.getTextDirection());}else if(!this._busyLabel&&this.getText()){this._createLabel(this.getText());}var r=this.getCustomIconRotationSpeed();if(r<0){this.setCustomIconRotationSpeed(0);}};
a.prototype.onAfterRendering=function(){this._setRotationSpeed();};
a.prototype.exit=function(){if(this._iconImage){this._iconImage.destroy();this._iconImage=null;}if(this._busyLabel){this._busyLabel.destroy();this._busyLabel=null;}};
a.prototype._createCustomIcon=function(i){this._iconImage=new I(this.getId()+"-icon",{src:i,width:this.getCustomIconWidth(),height:this.getCustomIconHeight(),densityAware:this.getCustomIconDensityAware()});return this._iconImage;};
a.prototype._createLabel=function(t){this._busyLabel=new L(this.getId()+"-label",{labelFor:this.getId(),text:t,textAlign:"Center",textDirection:this.getTextDirection()});return this._busyLabel;};
a.prototype._setRotationSpeed=function(){if(!this._iconImage){return;}var $=this._iconImage.$();var r=this.getCustomIconRotationSpeed()+"ms";$.css("-webkit-animation-duration",r).css("animation-duration",r);$.css("display","none");setTimeout(function(){$.css("display","inline");},0);};
return a;});
sap.ui.predefine('sap/m/BusyIndicatorRenderer',[],function(){"use strict";var B={apiVersion:2};
B.render=function(r,b){var t=b.getTooltip_AsString();r.openStart("div",b).class("sapMBusyIndicator");r.style("font-size",b.getSize());r.accessibilityState(b);if(t){r.attr("title",t);}r.openEnd();if(b.getCustomIcon()){r.renderControl(b._iconImage);}else{r.openStart("div",b.getId()+"-busy-area");r.class("sapMBusyIndicatorBusyArea").openEnd().close("div");}if(b._busyLabel){r.renderControl(b._busyLabel);}r.close("div");};
return B;},true);
sap.ui.predefine('sap/m/Button',["./library","sap/ui/core/Control","sap/ui/core/ShortcutHintsMixin","sap/ui/core/EnabledPropagator","sap/ui/core/IconPool","sap/ui/Device","sap/ui/core/ContextMenuSupport","sap/ui/core/library","./ButtonRenderer","sap/ui/events/KeyCodes","sap/ui/core/LabelEnablement","sap/m/BadgeEnabler","sap/ui/core/InvisibleText"],function(l,C,S,E,I,D,a,c,B,K,L,b,d){"use strict";var T=c.TextDirection;var e=l.ButtonType;var f=l.ButtonAccessibilityType;var g=l.BadgeState;var A=c.aria.HasPopup;var h=1,i=9999;
var j=C.extend("sap.m.Button",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.m",properties:{text:{type:"string",group:"Misc",defaultValue:""},type:{type:"sap.m.ButtonType",group:"Appearance",defaultValue:e.Default},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:""},iconFirst:{type:"boolean",group:"Appearance",defaultValue:true},activeIcon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconDensityAware:{type:"boolean",group:"Misc",defaultValue:true},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit},ariaHasPopup:{type:"sap.ui.core.aria.HasPopup",group:"Accessibility",defaultValue:A.None}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{tap:{deprecated:true},press:{}},designtime:"sap/m/designtime/Button.designtime",dnd:{draggable:true,droppable:false}}});
E.call(j.prototype);a.apply(j.prototype);b.call(j.prototype);
j.prototype.init=function(){this._onmouseenter=this._onmouseenter.bind(this);this._buttonPressed=false;S.addConfig(this,{event:"press",position:"0 0",addAccessibilityLabel:true},this);this.initBadgeEnablement({position:"topRight",selector:{suffix:"inner"}});this._oBadgeData={value:"",state:""};this._badgeMinValue=h;this._badgeMaxValue=i;};
j.prototype.badgeValueFormatter=function(v){var V=parseInt(v),o=this.getBadgeCustomData(),k=o.getVisible();if(isNaN(V)){return false;}if(V<this._badgeMinValue){k&&o.setVisible(false);}else{!k&&o.setVisible(true);if(V>this._badgeMaxValue&&v.indexOf("+")===-1){v=this._badgeMaxValue<1000?this._badgeMaxValue+"+":"999+";}}return v;};
j.prototype.setBadgeMinValue=function(m){var v=this.getBadgeCustomData().getValue();if(m&&!isNaN(m)&&m>=h&&m!=this._badgeMinValue){this._badgeMinValue=m;this.badgeValueFormatter(v);this.invalidate();}return this;};
j.prototype.setBadgeMaxValue=function(m){if(m&&!isNaN(m)&&m<=i&&m!=this._badgeMaxValue){this._badgeMaxValue=m;this.invalidate();}return this;};
j.prototype.onBadgeUpdate=function(v,s){if(this._oBadgeData.value!==v||this._oBadgeData.state!==s){if(s===g.Disappear){v="";}this._updateBadgeInvisibleText(v);this._oBadgeData={value:v,state:s};}};
j.prototype._updateBadgeInvisibleText=function(v){var r=sap.ui.getCore().getLibraryResourceBundle("sap.m"),s,p;v=v.toString().trim();p=v.indexOf("+");if(p!==-1){s=r.getText("BUTTON_BADGE_MORE_THAN_ITEMS",v.substr(0,p));}else{switch(v){case"":s="";break;case"1":s=r.getText("BUTTON_BADGE_ONE_ITEM",v);break;default:s=r.getText("BUTTON_BADGE_MANY_ITEMS",v);}}this._getBadgeInvisibleText().setText(s);};
j.prototype._getBadgeInvisibleText=function(){return this._oBadgeInvisibleText||(this._oBadgeInvisibleText=new d(this.getId()+"-badge").toStatic());};
j.prototype.exit=function(){if(this._image){this._image.destroy();}if(this._iconBtn){this._iconBtn.destroy();}if(this._oBadgeInvisibleText){this._oBadgeInvisibleText.destroy();this._oBadgeData=null;}this.$().off("mouseenter",this._onmouseenter);};
j.prototype.setType=function(s){this.setProperty("type",s,false);if(s===e.Critical){this._sTypeIconURI="sap-icon://message-warning";}else if(s===e.Negative){this._sTypeIconURI="sap-icon://message-error";}else if(s===e.Success){this._sTypeIconURI="sap-icon://message-success";}else if(s===e.Neutral){this._sTypeIconURI="sap-icon://message-information";}else{this._sTypeIconURI=null;}return this;};
j.prototype.onBeforeRendering=function(){this._bRenderActive=this._bActive;this.$().off("mouseenter",this._onmouseenter);};
j.prototype.onAfterRendering=function(){if(this._bRenderActive){this._activeButton();this._bRenderActive=this._bActive;}this.$().on("mouseenter",this._onmouseenter);};
j.prototype.ontouchstart=function(o){o.setMarked();if(this._bRenderActive){delete this._bRenderActive;}if(o.targetTouches.length===1){this._buttonPressed=true;this._activeButton();}if(this.getEnabled()&&this.getVisible()){if((D.browser.safari||D.browser.firefox)&&(o.originalEvent&&o.originalEvent.type==="mousedown")){this._setButtonFocus();}if(!D.browser.msie){this._sTouchStartTargetId=o.target.id.replace(this.getId(),'');}}else{if(!D.browser.msie){this._sTouchStartTargetId='';}}};
j.prototype.ontouchend=function(o){var s;this._buttonPressed=o.originalEvent&&o.originalEvent.buttons&1;this._inactiveButton();if(this._bRenderActive){delete this._bRenderActive;this.ontap(o,true);}if(!D.browser.msie){s=o.target.id.replace(this.getId(),'');if(this._buttonPressed===0&&((this._sTouchStartTargetId==="-BDI-content"&&(s==='-content'||s==='-inner'||s==='-img'))||(this._sTouchStartTargetId==="-content"&&(s==='-inner'||s==='-img'))||(this._sTouchStartTargetId==='-img'&&s!=='-img'))){this.ontap(o,true);}}this._sTouchStartTargetId='';};
j.prototype.ontouchcancel=function(){this._buttonPressed=false;this._sTouchStartTargetId='';this._inactiveButton();};
j.prototype.ontap=function(o,F){o.setMarked();delete this._bRenderActive;if(this.bFromTouchEnd){return;}if(this.getEnabled()&&this.getVisible()){if((o.originalEvent&&o.originalEvent.type==="touchend")){this.focus();}this.fireTap({});this.firePress({});}this.bFromTouchEnd=F;if(this.bFromTouchEnd){setTimeout(function(){delete this.bFromTouchEnd;}.bind(this),0);}};
j.prototype.onkeydown=function(o){if(o.which===K.SPACE||o.which===K.ENTER||o.which===K.ESCAPE||o.which===K.SHIFT){if(o.which===K.SPACE||o.which===K.ENTER){o.setMarked();this._activeButton();}if(o.which===K.ENTER){this.firePress({});}if(o.which===K.SPACE){this._bPressedSpace=true;}if(this._bPressedSpace){if(o.which===K.SHIFT||o.which===K.ESCAPE){this._bPressedEscapeOrShift=true;this._inactiveButton();}}}else{if(this._bPressedSpace){o.preventDefault();}}};
j.prototype.onkeyup=function(o){if(o.which===K.ENTER){o.setMarked();this._inactiveButton();}if(o.which===K.SPACE){if(!this._bPressedEscapeOrShift){o.setMarked();this._inactiveButton();this.firePress({});}else{this._bPressedEscapeOrShift=false;}this._bPressedSpace=false;}if(o.which===K.ESCAPE){this._bPressedSpace=false;}};
j.prototype._onmouseenter=function(o){if(this._buttonPressed&&o.originalEvent&&o.originalEvent.buttons&1){this._activeButton();}};
j.prototype.onfocusout=function(){this._buttonPressed=false;this._sTouchStartTargetId='';this._inactiveButton();};
j.prototype._activeButton=function(){if(!this._isUnstyled()){this.$("inner").addClass("sapMBtnActive");}this._bActive=this.getEnabled();if(this._bActive){if(this._getAppliedIcon()&&this.getActiveIcon()&&this._image){this._image.setSrc(this.getActiveIcon());}}};
j.prototype._inactiveButton=function(){if(!this._isUnstyled()){this.$("inner").removeClass("sapMBtnActive");}this._bActive=false;if(this.getEnabled()){if(this._getAppliedIcon()&&this.getActiveIcon()&&this._image){this._image.setSrc(this._getAppliedIcon());}}};
j.prototype._isHoverable=function(){return this.getEnabled()&&D.system.desktop;};
j.prototype._getImage=function(s,k,m,n){var o=I.isIconURI(k),p;if(this._image instanceof sap.m.Image&&o||this._image instanceof sap.ui.core.Icon&&!o){this._image.destroy();this._image=undefined;}p=this.getIconFirst();if(this._image){this._image.setSrc(k);if(this._image instanceof sap.m.Image){this._image.setActiveSrc(m);this._image.setDensityAware(n);}}else{this._image=I.createControlByURI({id:s,src:k,activeSrc:m,densityAware:n,useIconTooltip:false},sap.m.Image).addStyleClass("sapMBtnCustomIcon").setParent(this,null,true);}this._image.addStyleClass("sapMBtnIcon");this._image.toggleStyleClass("sapMBtnIconLeft",p);this._image.toggleStyleClass("sapMBtnIconRight",!p);return this._image;};
j.prototype._getInternalIconBtn=function(s,k){var o=this._iconBtn;if(o){o.setSrc(k);}else{o=I.createControlByURI({id:s,src:k,useIconTooltip:false},sap.m.Image).setParent(this,null,true);}o.addStyleClass("sapMBtnIcon");o.addStyleClass("sapMBtnIconLeft");this._iconBtn=o;return this._iconBtn;};
j.prototype._isUnstyled=function(){var u=false;if(this.getType()===e.Unstyled){u=true;}return u;};
j.prototype.getPopupAnchorDomRef=function(){return this.getDomRef("inner");};
j.prototype._getText=function(){return this.getText();};
j.prototype._getTooltip=function(){var t,o;t=this.getTooltip_AsString();if(!t&&!this.getText()){o=I.getIconInfo(this._getAppliedIcon());if(o){t=o.text?o.text:o.name;}}return t;};
j.prototype._getAppliedIcon=function(){return this.getIcon()||this._sTypeIconURI;};
j.prototype.getAccessibilityInfo=function(){var s=this.getText()||this.getTooltip_AsString();if(!s&&this._getAppliedIcon()){var o=I.getIconInfo(this._getAppliedIcon());if(o){s=o.text||o.name;}}return{role:"button",type:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_BUTTON"),description:s,focusable:this.getEnabled(),enabled:this.getEnabled()};};
j.prototype._setButtonFocus=function(){setTimeout(function(){this.focus();}.bind(this),0);};
j.prototype._determineSelfReferencePresence=function(){var k=this.getAriaLabelledBy(),m=k.indexOf(this.getId())!==-1,H=L.getReferencingLabels(this).length>0,p=this.getParent(),n=!!(p&&p.enhanceAccessibilityState);return!m&&this._getText()&&(k.length>0||H||n);};
j.prototype._determineAccessibilityType=function(){var H=this.getAriaLabelledBy().length>0,k=this.getAriaDescribedBy().length>0,m=L.getReferencingLabels(this).length>0,n=this.getType()!==e.Default,o=H||m,p=k||n||(this._oBadgeData&&this._oBadgeData.value!==""&&this._oBadgeData.State!==g.Disappear),s;if(!o&&!p){s=f.Default;}else if(o&&!p){s=f.Labelled;}else if(!o&&p){s=f.Described;}else if(o&&p){s=f.Combined;}return s;};
j.prototype._getTitleAttribute=function(s){return this.getTooltip();};
return j;});
sap.ui.predefine('sap/m/ButtonRenderer',['sap/ui/Device','sap/ui/core/library','sap/ui/core/IconPool','sap/ui/core/ShortcutHintsMixin','sap/m/library','sap/ui/core/InvisibleText'],function(D,c,I,S,l,a){"use strict";var B=l.ButtonType;var b=l.ButtonAccessibilityType;var T=c.TextDirection;var d=l.BadgeState;var A=c.aria.HasPopup;var e={apiVersion:2};
e.render=function(R,o){var s=o.getId();var t=o.getType();var E=o.getEnabled();var w=o.getWidth();var f=o._getTooltip();var g=o._getText();var h=o.getTextDirection();var i=D.browser.internet_explorer||D.browser.edge;var j=(h===T.Inherit)&&!i;var k=I.getIconURI("nav-back");var M;R.openStart("button",o);R.class("sapMBtnBase");if(!o._isUnstyled()){R.class("sapMBtn");if((t===B.Back||t===B.Up)&&o._getAppliedIcon()&&!g){R.class("sapMBtnBack");}}var n=e.generateAccProps(o);if(this.renderAccessibilityAttributes){this.renderAccessibilityAttributes(R,o,n);}R.accessibilityState(o,n);if(!E){R.attr("disabled","disabled");if(!o._isUnstyled()){R.class("sapMBtnDisabled");}}else{switch(t){case B.Accept:case B.Reject:case B.Emphasized:case B.Attention:R.class("sapMBtnInverted");break;default:break;}}if(f&&!S.isDOMIDRegistered(s)){R.attr("title",f);}if(w!=""||w.toLowerCase()==="auto"){R.style("width",w);if(o._getAppliedIcon()&&g){M="4rem";}else{M="2.25rem";}R.style("min-width",M);}r(o,R);R.openEnd();R.openStart("span",s+"-inner");if(!o._isUnstyled()){R.class("sapMBtnInner");}if(o._isHoverable()){R.class("sapMBtnHoverable");}if(E){R.class("sapMFocusable");if(i){R.class("sapMIE");}}if(!o._isUnstyled()){if(g){R.class("sapMBtnText");}if(t===B.Back||t===B.Up){R.class("sapMBtnBack");}if(o._getAppliedIcon()){if(o.getIconFirst()){R.class("sapMBtnIconFirst");}else{R.class("sapMBtnIconLast");}}}if(this.renderButtonAttributes){this.renderButtonAttributes(R,o);}if(!o._isUnstyled()&&t!==""){R.class("sapMBtn"+t);}r(o,R);R.openEnd();if(t===B.Back||t===B.Up){this.writeInternalIconPoolHtml(R,o,k);}if(o.getIconFirst()&&o._getAppliedIcon()){this.writeImgHtml(R,o);}if(g){R.openStart("span",s+"-content");R.class("sapMBtnContent");if(h!==T.Inherit){R.attr("dir",h.toLowerCase());}R.openEnd();if(j){R.openStart("bdi",s+"-BDI-content");R.openEnd();}R.text(g);if(j){R.close("bdi");}R.close("span");}if(!o.getIconFirst()&&o._getAppliedIcon()){this.writeImgHtml(R,o);}if(i&&E){R.openStart("span");R.class("sapMBtnFocusDiv");R.openEnd();R.close("span");}R.close("span");if(f){R.openStart("span",s+"-tooltip");R.class("sapUiInvisibleText");R.openEnd();R.text(f);R.close("span");}R.close("button");};
e.writeImgHtml=function(R,o){R.renderControl(o._getImage(o.getId()+"-img",o._getAppliedIcon(),o.getActiveIcon(),o.getIconDensityAware()));};
e.writeInternalIconPoolHtml=function(R,o,u){R.renderControl(o._getInternalIconBtn((o.getId()+"-iconBtn"),u));};
function r(o,R){if(o._bExcludeFromTabChain){R.attr("tabindex",-1);}}
var m={Accept:"BUTTON_ARIA_TYPE_ACCEPT",Reject:"BUTTON_ARIA_TYPE_REJECT",Attention:"BUTTON_ARIA_TYPE_ATTENTION",Emphasized:"BUTTON_ARIA_TYPE_EMPHASIZED",Critical:"BUTTON_ARIA_TYPE_CRITICAL",Negative:"BUTTON_ARIA_TYPE_NEGATIVE",Success:"BUTTON_ARIA_TYPE_SUCCESS"};
e.getButtonTypeAriaLabelId=function(t){return a.getStaticId("sap.m",m[t]);};
e.getBadgeTextId=function(o){return o._oBadgeData&&o._oBadgeData.value!==""&&o._oBadgeData.state!==d.Disappear?o._getBadgeInvisibleText().getId():"";};
e.generateAccProps=function(o){var t=o._getText(),h=o.getAriaHasPopup(),f;if(t){f=e.generateTextButtonAccProps(o);}else{f=e.generateIconOnlyButtonAccProps(o);}f["disabled"]=null;f["haspopup"]=(h===A.None)?null:h.toLowerCase();return f;};
e.generateIconOnlyButtonAccProps=function(o){var t=e.getButtonTypeAriaLabelId(o.getType()),s=this.getBadgeTextId(o),f=o._getTooltip(),g=o.getId()+"-tooltip",h=o._determineAccessibilityType(),i={};switch(h){case b.Default:i["label"]={value:f,append:true};break;case b.Described:i["label"]={value:f,append:true};i["describedby"]={value:(g+" "+t+" "+s).trim(),append:true};break;case b.Labelled:i["describedby"]={value:g,append:true};break;case b.Combined:i["describedby"]={value:(g+" "+t+" "+s).trim(),append:true};break;default:break;}return i;};
e.generateTextButtonAccProps=function(o){var s=o.getId(),t=e.getButtonTypeAriaLabelId(o.getType()),f=this.getBadgeTextId(o),g=o._getTooltip()?s+"-tooltip":"",i=s+"-content",h=o._determineAccessibilityType(),p=o._determineSelfReferencePresence(),j={},k;switch(h){case b.Default:g&&(j["describedby"]={value:g,append:true});break;case b.Described:k=(g+" "+t+" "+f).trim();k&&(j["describedby"]={value:k,append:true});break;case b.Labelled:p&&(j["labelledby"]={value:i,append:true});g&&(j["describedby"]={value:g,append:true});break;case b.Combined:k=(g+" "+t+" "+f).trim();k&&(j["describedby"]={value:k,append:true});p&&(j["labelledby"]={value:i,append:true});break;default:break;}return j;};
return e;},true);
sap.ui.predefine('sap/m/Carousel',["./library","sap/ui/core/Core","sap/ui/core/Control","sap/ui/Device","sap/ui/core/ResizeHandler","sap/ui/core/library","sap/m/MessagePage","sap/ui/core/theming/Parameters","sap/ui/dom/units/Rem","./CarouselRenderer","./CarouselLayout","sap/ui/events/KeyCodes","sap/base/Log","sap/ui/events/F6Navigation","sap/ui/thirdparty/jquery","sap/ui/thirdparty/mobify-carousel","sap/ui/core/IconPool"],function(l,C,a,D,R,c,M,P,b,d,f,K,L,F,q){"use strict";var B=c.BusyIndicatorSize;var I=l.ImageHelper;var g=l.CarouselArrowsPlacement;var h=l.PlacementType;
var j=a.extend("sap.m.Carousel",{metadata:{library:"sap.m",designtime:"sap/m/designtime/Carousel.designtime",properties:{height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},loop:{type:"boolean",group:"Misc",defaultValue:false},showPageIndicator:{type:"boolean",group:"Appearance",defaultValue:true},pageIndicatorPlacement:{type:"sap.m.PlacementType",group:"Appearance",defaultValue:h.Bottom},showBusyIndicator:{type:"boolean",group:"Appearance",defaultValue:true,deprecated:true},arrowsPlacement:{type:"sap.m.CarouselArrowsPlacement",group:"Appearance",defaultValue:g.Content}},defaultAggregation:"pages",aggregations:{pages:{type:"sap.ui.core.Control",multiple:true,singularName:"page"},customLayout:{type:"sap.m.CarouselLayout",multiple:false}},associations:{activePage:{type:"sap.ui.core.Control",multiple:false}},events:{loadPage:{deprecated:true,parameters:{pageId:{type:"string"}}},unloadPage:{deprecated:true,parameters:{pageId:{type:"string"}}},pageChanged:{parameters:{oldActivePageId:{type:"string"},newActivePageId:{type:"string"},activePages:{type:"array"}}},beforePageChanged:{parameters:{activePages:{type:"array"}}}}}});
j._INNER_SELECTOR=".sapMCrslInner";j._PAGE_INDICATOR_SELECTOR=".sapMCrslBulleted";j._PAGE_INDICATOR_ARROWS_SELECTOR=".sapMCrslIndicatorArrow";j._CONTROLS=".sapMCrslControls";j._ITEM_SELECTOR=".sapMCrslItem";j._LEFTMOST_CLASS="sapMCrslLeftmost";j._RIGHTMOST_CLASS="sapMCrslRightmost";j._LATERAL_CLASSES="sapMCrslLeftmost sapMCrslRightmost";j._MODIFIERNUMBERFORKEYBOARDHANDLING=10;j._BULLETS_TO_NUMBERS_THRESHOLD=9;j._PREVIOUS_CLASS_ARROW="sapMCrslPrev";j._NEXT_CLASS_ARROW="sapMCrslNext";
j.prototype.init=function(){this._fnAdjustAfterResize=function(){var $=this.$().find(j._INNER_SELECTOR);this._oMobifyCarousel.resize($);this._setWidthOfPages(this._getNumberOfItemsToShow());}.bind(this);this._aOrderOfFocusedElements=[];this._aAllActivePages=[];this._aAllActivePagesIndexes=[];this._onBeforePageChangedRef=this._onBeforePageChanged.bind(this);this._onAfterPageChangedRef=this._onAfterPageChanged.bind(this);this.data("sap-ui-fastnavgroup","true",true);this._oRb=C.getLibraryResourceBundle("sap.m");};
j.prototype.exit=function(){if(this._oMobifyCarousel){this._oMobifyCarousel.destroy();delete this._oMobifyCarousel;}if(this._oArrowLeft){this._oArrowLeft.destroy();delete this._oArrowLeft;}if(this._oArrowRight){this._oArrowRight.destroy();delete this._oArrowRight;}if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}if(this.oMessagePage){this.oMessagePage.destroy();this.oMessagePage=null;}this.$().off('afterSlide');this._fnAdjustAfterResize=null;this._$InnerDiv=null;this._aOrderOfFocusedElements=null;this._aAllActivePages=null;this._aAllActivePagesIndexes=null;};
j.prototype.ontouchstart=function(e){if(this._oMobifyCarousel){if(e.target instanceof HTMLImageElement){e.preventDefault();}this._oMobifyCarousel.touchstart(e);}};
j.prototype.ontouchmove=function(e){if(this._oMobifyCarousel){this._oMobifyCarousel.touchmove(e);}};
j.prototype.ontouchend=function(e){if(this._oMobifyCarousel){if(this._oMobifyCarousel.hasActiveTransition()){this._oMobifyCarousel.onTransitionComplete();}this._oMobifyCarousel.touchend(e);}};
j.prototype.onBeforeRendering=function(){var A=this.getActivePage();if(!A&&this.getPages().length>0){this.setAssociation("activePage",this.getPages()[0].getId(),true);}if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}this.$().off('beforeSlide',this._onBeforePageChangedRef);this.$().off('afterSlide',this._onAfterPageChangedRef);this.$().find(".sapMCrslItemTableCell").off("focus");return this;};
j.prototype._getNumberOfItemsToShow=function(){var p=this.getPages().length,o=this.getCustomLayout(),n=1;if(o&&o.isA("sap.m.CarouselLayout")){n=Math.max(o.getVisiblePagesCount(),1);}if(n>1&&p<n){return p;}return n;};
j.prototype.onAfterRendering=function(){if(this._oMobifyCarousel){this._oMobifyCarousel.unbind();setTimeout(function(){if(this._oMobifyCarousel){this._oMobifyCarousel.onTransitionComplete();}}.bind(this),0);}var n=this._getNumberOfItemsToShow();this.$().carousel(undefined,{numberOfItemsToShow:n});this._oMobifyCarousel=this.getDomRef()._carousel;this._oMobifyCarousel.setLoop(this.getLoop());this._oMobifyCarousel.setRTL(C.getConfiguration().getRTL());if(n>1){this._setWidthOfPages(n);}var A=this.getActivePage();if(A){this._updateActivePages(A);var i=this._getPageNumber(A);if(isNaN(i)||i==0){if(this.getPages().length>0){this.setAssociation("activePage",this.getPages()[0].getId(),true);this._adjustHUDVisibility(1);}}else{if(C.isThemeApplied()){this._moveToPage(i+1);}else{C.attachThemeChanged(this._handleThemeLoad,this);}if(this.getParent()&&this.getParent().isA("sap.zen.commons.layout.PositionContainer")){if(this._isCarouselUsedWithCommonsLayout===undefined){setTimeout(this["invalidate"].bind(this),0);this._isCarouselUsedWithCommonsLayout=true;}}}}this.$().on('beforeSlide',this._onBeforePageChangedRef);this.$().on('afterSlide',this._onAfterPageChangedRef);this._$InnerDiv=this.$().find(j._INNER_SELECTOR)[0];this._sResizeListenerId=R.register(this._$InnerDiv,this._fnAdjustAfterResize);this.$().find(".sapMCrslItemTableCell").on("focus",function(e){e.preventDefault();q(e.target).parents('.sapMCrsl').trigger("focus");return false;});var p=this.getParent();while(p){if(p.isA("sap.m.IconTabBar")){var t=this;p.attachExpand(function(e){var E=e.getParameter('expand');if(E&&i>0){t._moveToPage(i+1);}});break;}p=p.getParent();}};
j.prototype._onBeforePageChanged=function(e,p,n){if(e.target!==this.getDomRef()){return;}var N=this.getPages()[n-1].getId();this._updateActivePages(N);this.fireBeforePageChanged({activePages:this._aAllActivePagesIndexes});};
j.prototype._onAfterPageChanged=function(e,p,n){var H=this.getPages().length>0;if(e.target!==this.getDomRef()){return;}if(H&&n>0){this._changePage(p,n);}};
j.prototype._setWidthOfPages=function(n){var i=this._calculatePagesWidth(n);this.$().find(".sapMCrslItem").each(function(e,p){p.style.width=i+"%";});};
j.prototype._calculatePagesWidth=function(n){var w=this.$().width(),m=b.toPx(P.get("_sap_m_Carousel_PagesMarginRight")),i=(w-(m*(n-1)))/n,e=(i/w)*100;return e;};
j.prototype._handleThemeLoad=function(){var A=this.getActivePage();if(A){var i=this._getPageNumber(A);if(i>0){this._moveToPage(i+1);}}C.detachThemeChanged(this._handleThemeLoad,this);};
j.prototype._moveToPage=function(i){this._oMobifyCarousel.changeAnimation('sapMCrslNoTransition');this._oMobifyCarousel.move(i);this._changePage(undefined,i);};
j.prototype._changePage=function(o,n){this._adjustHUDVisibility(n);var O=this.getActivePage();if(o){O=this.getPages()[o-1].getId();}var N=this.getPages()[n-1].getId();this.setAssociation("activePage",N,true);var t=this._getPageIndicatorText(n);L.debug("sap.m.Carousel: firing pageChanged event: old page: "+O+", new page: "+N);if(!D.system.desktop){q(document.activeElement).trigger("blur");}this.firePageChanged({oldActivePageId:O,newActivePageId:N,activePages:this._aAllActivePagesIndexes});this.$('slide-number').text(t);};
j.prototype._getPageIndicatorText=function(n){return this._oRb.getText("CAROUSEL_PAGE_INDICATOR_TEXT",[n,this.getPages().length-this._getNumberOfItemsToShow()+1]);};
j.prototype._adjustHUDVisibility=function(n){var N=this._getNumberOfItemsToShow();if(D.system.desktop&&!this.getLoop()&&this.getPages().length>1){var H=this.$('hud');H.removeClass(j._LATERAL_CLASSES);if(n===1){H.addClass(j._LEFTMOST_CLASS);this._focusCarouselContainer(H,j._PREVIOUS_CLASS_ARROW);}if((n+N-1)===this.getPages().length){H.addClass(j._RIGHTMOST_CLASS);this._focusCarouselContainer(H,j._NEXT_CLASS_ARROW);}}};
j.prototype._focusCarouselContainer=function(H,A){if(H.find('.'+A)[0]===document.activeElement){this.focus();}};
j.prototype.setActivePage=function(p){var s=null;if(typeof(p)=='string'){s=p;}else if(p instanceof a){s=p.getId();}if(s){if(s===this.getActivePage()){return this;}var i=this._getPageNumber(s);if(!isNaN(i)){if(this._oMobifyCarousel){this._oMobifyCarousel.move(i+1);}}}this.setAssociation("activePage",s,true);return this;};
j.prototype._getNavigationArrow=function(s){if(!this["_oArrow"+s]){this["_oArrow"+s]=I.getImageControl(this.getId()+"-arrowScroll"+s,this["_oArrow"+s],this,{src:"sap-icon://slim-arrow-"+s.toLowerCase(),useIconTooltip:false});}return this["_oArrow"+s];};
j.prototype._getErrorPage=function(){if(!this.oMessagePage){this.oMessagePage=new M({text:this._oRb.getText("CAROUSEL_ERROR_MESSAGE"),description:"",icon:"sap-icon://document",showHeader:false});}return this.oMessagePage;};
j.prototype.previous=function(){if(this._oMobifyCarousel){this._oMobifyCarousel.prev();}else{L.warning("Unable to execute sap.m.Carousel.previous: carousel must be rendered first.");}return this;};
j.prototype.next=function(){if(this._oMobifyCarousel){this._oMobifyCarousel.next();}else{L.warning("Unable to execute sap.m.Carousel.next: carousel must be rendered first.");}return this;};
j.prototype._getPageNumber=function(p){var i,r;for(i=0;i<this.getPages().length;i++){if(this.getPages()[i].getId()==p){r=i;break;}}return r;};
j.prototype.onsaptabprevious=function(e){this._bDirection=false;this._fnOnTabPress(e);};
j.prototype.onsaptabnext=function(e){this._bDirection=true;this._fnOnTabPress(e);};
j.prototype.onfocusin=function(e){this.saveLastFocusReference(e);this._bDirection=undefined;};
j.prototype.onsapskipforward=function(e){e.preventDefault();this._handleGroupNavigation(e,false);};
j.prototype.onsapskipback=function(e){e.preventDefault();this._handleGroupNavigation(e,true);};
j.prototype.onkeydown=function(e){if(e.keyCode==K.F7){this._handleF7Key(e);return;}if(e.target!=this.getDomRef()){return;}switch(e.keyCode){case 189:case K.NUMPAD_MINUS:this._fnSkipToIndex(e,-1);break;case K.PLUS:case K.NUMPAD_PLUS:this._fnSkipToIndex(e,1);break;}};
j.prototype.onsapescape=function(e){var i;if(e.target===this.$()[0]&&this._lastActivePageNumber){i=this._lastActivePageNumber+1;this._oMobifyCarousel.move(i);this._changePage(undefined,i);}};
j.prototype.onsapright=function(e){this._fnSkipToIndex(e,1);};
j.prototype.onsapup=function(e){this._fnSkipToIndex(e,-1);};
j.prototype.onsapleft=function(e){this._fnSkipToIndex(e,-1);};
j.prototype.onsapdown=function(e){this._fnSkipToIndex(e,1);};
j.prototype.onsaphome=function(e){this._fnSkipToIndex(e,0);};
j.prototype.onsapend=function(e){this._fnSkipToIndex(e,this.getPages().length);};
j.prototype.onsaprightmodifiers=function(e){if(e.ctrlKey){this._fnSkipToIndex(e,j._MODIFIERNUMBERFORKEYBOARDHANDLING);}};
j.prototype.onsapupmodifiers=function(e){if(e.ctrlKey){this._fnSkipToIndex(e,j._MODIFIERNUMBERFORKEYBOARDHANDLING);}};
j.prototype.onsappageup=function(e){this._fnSkipToIndex(e,j._MODIFIERNUMBERFORKEYBOARDHANDLING);};
j.prototype.onsapleftmodifiers=function(e){if(e.ctrlKey){this._fnSkipToIndex(e,-j._MODIFIERNUMBERFORKEYBOARDHANDLING);}};
j.prototype.onsapdownmodifiers=function(e){if(e.ctrlKey){this._fnSkipToIndex(e,-j._MODIFIERNUMBERFORKEYBOARDHANDLING);}};
j.prototype.onsappagedown=function(e){this._fnSkipToIndex(e,-j._MODIFIERNUMBERFORKEYBOARDHANDLING);};
j.prototype._fnOnTabPress=function(e){if(e.target===this.$()[0]){this._lastActivePageNumber=this._getPageNumber(this.getActivePage());}};
j.prototype._handleGroupNavigation=function(e,s){var E=q.Event("keydown");e.preventDefault();this.$().trigger("focus");E.target=e.target;E.key='F6';E.shiftKey=s;F.handleF6GroupNavigation(E);};
j.prototype.saveLastFocusReference=function(e){var o=q(e.target).closest(".sapMCrsPage").control(0),s;if(this._bDirection===undefined){return;}if(this._lastFocusablePageElement===undefined){this._lastFocusablePageElement={};}if(o){s=o.getId();this._lastFocusablePageElement[s]=e.target;this._updateFocusedPagesOrder(s);}};
j.prototype._getActivePageLastFocusedElement=function(){if(this._lastFocusablePageElement){return this._lastFocusablePageElement[this._getLastFocusedActivePage()];}};
j.prototype._updateFocusedPagesOrder=function(s){var i=this._aOrderOfFocusedElements.indexOf(s);if(i>-1){this._aOrderOfFocusedElements.splice(0,0,this._aOrderOfFocusedElements.splice(i,1)[0]);}else{this._aOrderOfFocusedElements.unshift(s);}};
j.prototype._updateActivePages=function(n){var N=this._getPageNumber(n),e=this._getNumberOfItemsToShow(),k=N+e,A=this.getPages();if(k>A.length){k=A.length-e;}this._aAllActivePages=[];this._aAllActivePagesIndexes=[];for(var i=N;i<k;i++){this._aAllActivePages.push(A[i].getId());this._aAllActivePagesIndexes.push(i);}};
j.prototype._getLastFocusedActivePage=function(){for(var i=0;i<this._aOrderOfFocusedElements.length;i++){var p=this._aOrderOfFocusedElements[i];if(this._aAllActivePages.indexOf(p)>-1){return p;}}return this.getActivePage();};
j.prototype._fnSkipToIndex=function(e,n){var i=n;if(e.target!==this.getDomRef()){return;}e.preventDefault();if(this._oMobifyCarousel.hasActiveTransition()){this._oMobifyCarousel.onTransitionComplete();}if(n!==0){i=this._getPageNumber(this.getActivePage())+1+n;}this._oMobifyCarousel.move(i);};
j.prototype._handleF7Key=function(e){var A;e.preventDefault();A=this._getActivePageLastFocusedElement();if(e.target===this.$()[0]&&A){A.focus();}else{this.$().trigger("focus");}};
j.prototype.setShowBusyIndicator=function(){L.warning("sap.m.Carousel: Deprecated function 'setShowBusyIndicator' called. Does nothing.");return this;};
j.prototype.getShowBusyIndicator=function(){L.warning("sap.m.Carousel: Deprecated function 'getShowBusyIndicator' called. Does nothing.");return false;};
j.prototype.setBusyIndicatorSize=function(s){if(!(s in B)){s=B.Medium;}return a.prototype.setBusyIndicatorSize.call(this,s);};
return j;});
sap.ui.predefine('sap/m/CarouselLayout',["sap/ui/base/ManagedObject"],function(M){"use strict";
var C=M.extend("sap.m.CarouselLayout",{metadata:{library:"sap.m",properties:{visiblePagesCount:{type:"int",group:"Misc",defaultValue:1}}}});
return C;});
sap.ui.predefine('sap/m/CarouselRenderer',["sap/m/library","sap/base/strings/capitalize","sap/ui/core/Core","sap/ui/Device"],function(l,c,C,D){"use strict";var a=l.CarouselArrowsPlacement;var P=l.PlacementType;var r=C.getLibraryResourceBundle("sap.m");var b={apiVersion:2};b._BULLETS_TO_NUMBERS_THRESHOLD=9;
b.render=function(R,o){var p=o.getPages(),i=p.length,s=o.getPageIndicatorPlacement(),A=o.getArrowsPlacement(),I=o._getPageNumber(o.getActivePage());this._renderOpeningDiv(R,o);if(s===P.Top){this._renderPageIndicatorAndArrows(R,o,{iPageCount:i,iIndex:I,sArrowsPlacement:A,bBottom:false,bShowPageIndicator:o.getShowPageIndicator()});}this._renderInnerDiv(R,o,p,s);if(D.system.desktop&&i>o._getNumberOfItemsToShow()&&A===a.Content){this._renderHudArrows(R,o);}if(s===P.Bottom){this._renderPageIndicatorAndArrows(R,o,{iPageCount:i,iIndex:I,sArrowsPlacement:A,bBottom:true,bShowPageIndicator:o.getShowPageIndicator()});}R.close("div");};
b._renderOpeningDiv=function(R,o){var t=o.getTooltip_AsString();R.openStart("div",o).class("sapMCrsl").class("sapMCrslFluid").style("width",o.getWidth()).style("height",o.getHeight()).attr("data-sap-ui-customfastnavgroup",true).attr("tabindex",0).accessibilityState(o,{role:"listbox"});if(t){R.attr("title",t);}R.openEnd();};
b._renderInnerDiv=function(R,o,p,s){R.openStart("div").class("sapMCrslInner");if(p.length>1&&(o.getShowPageIndicator()||o.getArrowsPlacement()===a.PageIndicator)){if(s===P.Bottom){R.class("sapMCrslBottomOffset");if(o.getArrowsPlacement()===a.PageIndicator){R.class("sapMCrslBottomArrowsOffset");}}else{R.class("sapMCrslTopOffset");if(o.getArrowsPlacement()===a.PageIndicator){R.class("sapMCrslTopArrowsOffset");}}}R.openEnd();var f=function(d,i,A){R.openStart("div",o.getId()+"-"+d.getId()+"-slide").class("sapMCrslItem").accessibilityState(d,{role:"option",posinset:i+1,setsize:A.length}).openEnd();b._renderPageInScrollContainer(R,o,d);R.close("div");};if(p.length){p.forEach(f);}else{R.renderControl(o._getErrorPage());}R.close("div");};
b._renderPageIndicatorAndArrows=function(R,o,s){var p=s.iPageCount,S=D.system.desktop&&s.sArrowsPlacement===a.PageIndicator,I=o.getId(),O=[],n=o._getNumberOfItemsToShow(),d=1;if(p<=o._getNumberOfItemsToShow()){return;}if(!s.bShowPageIndicator&&!S){return;}if(s.bBottom){O.push("sapMCrslControlsBottom");}else{O.push("sapMCrslControlsTop");}if(S){R.openStart("div").class("sapMCrslControls");O.forEach(function(e){R.class(e);});R.openEnd();R.openStart("div").class("sapMCrslControlsContainer");O.forEach(function(e){R.class(e);});R.openEnd();}else{R.openStart("div").class("sapMCrslControlsNoArrows");O.forEach(function(e){R.class(e);});R.openEnd();}if(S){this._renderArrow(R,o,"previous");}R.openStart("div",I+"-pageIndicator");if(!s.bShowPageIndicator){R.style("opacity","0");}if(p<b._BULLETS_TO_NUMBERS_THRESHOLD){R.class("sapMCrslBulleted").openEnd();for(var i=1;i<=p-n+1;i++){R.openStart("span").attr("data-slide",d).accessibilityState({role:"img",label:r.getText("CAROUSEL_POSITION",[i,p])}).openEnd().text(i).close("span");d++;}}else{R.class("sapMCrslNumeric").openEnd();var t=r.getText("CAROUSEL_PAGE_INDICATOR_TEXT",[s.iIndex+1,p-n+1]);R.openStart("span",I+"-"+"slide-number").openEnd().text(t).close("span");}R.close("div");if(S){this._renderArrow(R,o,"next");}if(!S){R.close("div");}if(S){R.close("div").close("div");}};
b._renderHudArrows=function(R,o){var A;if(o.getShowPageIndicator()){if(o.getPageIndicatorPlacement()===P.Top){A="sapMCrslHudTop";}else if(o.getPageIndicatorPlacement()===P.Bottom){A="sapMCrslHudBottom";}}else{A="sapMCrslHudMiddle";}R.openStart("div",o.getId()+"-hud").class("sapMCrslHud").class(A).openEnd();this._renderArrow(R,o,"previous");this._renderArrow(R,o,"next");R.close("div");};
b._renderArrow=function(R,o,d){var s=d.slice(0,4);R.openStart("a").class("sapMCrsl"+c(s)).attr("tabindex","-1").attr("data-slide",s).attr("title",r.getText("PAGINGBUTTON_"+d.toUpperCase())).openEnd();R.openStart("div").class("sapMCrslArrowInner").openEnd();R.renderControl(o._getNavigationArrow(d==="previous"?"Left":"Right"));R.close("div").close("a");};
b._renderPageInScrollContainer=function(R,o,p){R.openStart("div").class("sapMScrollCont").class("sapMScrollContH").style("width","100%").style("height","100%").openEnd();R.openStart("div").class("sapMScrollContScroll").openEnd();R.openStart("div").class("sapMCrslItemTable").openEnd();R.openStart("div").class("sapMCrslItemTableCell");if(p.isA("sap.m.Image")){var i="sapMCrslImgNoArrows",s=D.system.desktop&&o.getArrowsPlacement()===a.PageIndicator;if(s){i="sapMCrslImg";}R.class(i);}R.openEnd();R.renderControl(p.addStyleClass("sapMCrsPage"));R.close("div");R.close("div");R.close("div");R.close("div");};
return b;},true);
sap.ui.predefine('sap/m/CheckBox',['./Label','./library','sap/ui/Device','sap/ui/core/Control','sap/ui/core/IconPool','sap/ui/core/EnabledPropagator','sap/ui/core/library','./CheckBoxRenderer',"sap/ui/thirdparty/jquery","sap/ui/events/KeyCodes",'sap/ui/core/LabelEnablement','sap/ui/core/message/MessageMixin'],function(L,l,D,C,I,E,c,a,q,K,b,M){"use strict";var V=c.ValueState;var T=c.TextAlign;var d=c.TextDirection;
var e=C.extend("sap.m.CheckBox",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.m",properties:{selected:{type:"boolean",group:"Data",defaultValue:false},partiallySelected:{type:"boolean",group:"Data",defaultValue:false},enabled:{type:"boolean",group:"Behavior",defaultValue:true},name:{type:"string",group:"Misc",defaultValue:null},text:{type:"string",group:"Appearance",defaultValue:null},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:d.Inherit},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:T.Begin},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:''},useEntireWidth:{type:"boolean",group:"Appearance",defaultValue:false},activeHandling:{type:"boolean",group:"Misc",defaultValue:true},editable:{type:"boolean",group:"Behavior",defaultValue:true},valueState:{type:"sap.ui.core.ValueState",group:"Data",defaultValue:V.None},valueStateText:{type:"string",group:"Misc",defaultValue:null,visibility:"hidden"},displayOnly:{type:"boolean",group:"Behavior",defaultValue:false},wrapping:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{_label:{type:"sap.m.Label",group:"Behavior",multiple:false,visibility:"hidden"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{select:{parameters:{selected:{type:"boolean"}}}},dnd:{draggable:true,droppable:false},designtime:"sap/m/designtime/CheckBox.designtime"}});
E.call(e.prototype);M.call(e.prototype);
e.prototype.init=function(){this.addActiveState(this);I.insertFontFaceStyle();this._handleReferencingLabels();};
e.prototype.exit=function(){this._oLabel=null;delete this._iTabIndex;};
e.prototype.setText=function(t){var o=this._getLabel();this.setProperty("text",t);o.setText(t);return this;};
e.prototype.setWidth=function(w){this.setProperty("width",w,true);this._setWidth();return this;};
e.prototype.setUseEntireWidth=function(u){this.setProperty("useEntireWidth",u,true);this._setWidth();return this;};
e.prototype.setTextDirection=function(s){var o=this._getLabel();this.setProperty("textDirection",s);o.setTextDirection(s);return this;};
e.prototype.setTextAlign=function(A){var o=this._getLabel();this.setProperty("textAlign",A);o.setTextAlign(A);return this;};
e.prototype.setValueStateText=function(t){return this.setProperty("valueStateText",t);};
e.prototype.setWrapping=function(w){var o=this._getLabel();this.setProperty("wrapping",w);o.setWrapping(w);return this;};
e.prototype.addActiveState=function(o){if(D.os.blackberry){o.addDelegate({ontouchstart:function(f){q(o.getDomRef()).addClass("sapMActive");},ontouchend:function(f){q(o.getDomRef()).removeClass("sapMActive");}});}};
e.prototype.ontouchstart=function(o){o.originalEvent._sapui_handledByControl=true;};
e.prototype.ontap=function(o){var s;if(this.getEnabled()&&this.getEditable()&&!this.getDisplayOnly()){this.$().trigger("focus");s=this._getSelectedState();this.setSelected(s);this.setPartiallySelected(false);this.fireSelect({selected:s});o&&o.setMarked();}};
e.prototype.onkeyup=function(o){if(o&&o.which===K.SPACE&&!o.shiftKey){this.ontap(o);o.preventDefault();o.stopPropagation();}};
e.prototype.onsapspace=function(o){o.preventDefault();};
e.prototype.onsapenter=function(o){this.ontap(o);};
e.prototype.setTabIndex=function(t){this._iTabIndex=t;this.$("CbBg").attr("tabindex",t);return this;};
e.prototype.getTabIndex=function(){if(this.hasOwnProperty("_iTabIndex")){return this._iTabIndex;}return(this.getEnabled()&&!this.getDisplayOnly())?0:-1;};
e.prototype._getLabel=function(){if(!this._oLabel){this._oLabel=new L(this.getId()+"-label",{labelFor:this.getId()}).addStyleClass("sapMCbLabel");this.setAggregation("_label",this._oLabel,true);}return this.getAggregation("_label");};
e.prototype._setWidth=function(){var o=this._getLabel(),$=this.$(),w=this.getWidth();if(this.getUseEntireWidth()){o.setWidth("");$.outerWidth(w);}else{$.outerWidth("");o.setWidth(w);}};
e.prototype._getSelectedState=function(){var s=this.getSelected(),p=this.getPartiallySelected();return(s===p)||(!s&&p);};
e.prototype._getAriaChecked=function(){var s=this.getSelected();if(this.getPartiallySelected()&&s){return"mixed";}return s;};
e.prototype._fnLabelTapHandler=function(){this.$().trigger("focus");};
e.prototype._handleReferencingLabels=function(){var f=b.getReferencingLabels(this),t=this;if(f.length>0){f.forEach(function(s){sap.ui.getCore().byId(s).addEventDelegate({ontap:function(){t._fnLabelTapHandler();}});});}};
e.prototype.getAccessibilityInfo=function(){var B=sap.ui.getCore().getLibraryResourceBundle("sap.m");return{role:"checkbox",type:B.getText("ACC_CTR_TYPE_CHECKBOX"),description:(this.getText()||"")+(this.getSelected()?(" "+B.getText("ACC_CTR_STATE_CHECKED")):""),focusable:this.getEnabled()&&!this.getDisplayOnly(),enabled:this.getEnabled(),editable:this.getEditable()};};
e.prototype.getFormDoNotAdjustWidth=function(){return this.getText()?false:true;};
return e;});
sap.ui.predefine('sap/m/CheckBoxRenderer',['sap/ui/core/library','sap/ui/core/ValueStateSupport','sap/ui/Device'],function(c,V,D){"use strict";var a=c.ValueState;var C={apiVersion:2};
C.render=function(r,o){var i=o.getId(),e=o.getEnabled(),d=o.getDisplayOnly(),E=o.getEditable(),I=e&&!d,b=e&&d,f=o.getAggregation("_label"),v=o.getValueState(),g=a.Error===v,h=a.Warning===v,j=a.Success===v,k=a.Information===v,u=o.getUseEntireWidth();r.openStart("div",o);r.class("sapMCb");if(!E){r.class("sapMCbRo");}if(b){r.class("sapMCbDisplayOnly");}if(!e){r.class("sapMCbBgDis");}if(o.getText()){r.class("sapMCbHasLabel");}if(o.getWrapping()){r.class("sapMCbWrapped");}if(g){r.class("sapMCbErr");}else if(h){r.class("sapMCbWarn");}else if(j){r.class("sapMCbSucc");}else if(k){r.class("sapMCbInfo");}if(u){r.style("width",o.getWidth());}var t=this.getTooltipText(o);if(t){r.attr("title",t);}if(I){r.attr("tabindex",o.getTabIndex());}r.accessibilityState(o,{role:"checkbox",selected:null,checked:o._getAriaChecked(),describedby:t?i+"-Descr":undefined});if(b){r.attr("aria-readonly",true);}r.openEnd();r.openStart("div",o.getId()+"-CbBg");r.class("sapMCbBg");if(I&&E&&D.system.desktop){r.class("sapMCbHoverable");}if(!o.getActiveHandling()){r.class("sapMCbActiveStateOff");}r.class("sapMCbMark");if(o.getSelected()){r.class("sapMCbMarkChecked");}if(o.getPartiallySelected()){r.class("sapMCbMarkPartiallyChecked");}r.openEnd();r.voidStart("input",o.getId()+"-CB");r.attr("type","CheckBox");if(o.getSelected()){r.attr("checked","checked");}if(o.getName()){r.attr("name",o.getName());}if(!e){r.attr("disabled","disabled");}if(!E){r.attr("readonly","readonly");}r.voidEnd();r.close("div");r.renderControl(f);if(t&&sap.ui.getCore().getConfiguration().getAccessibility()){r.openStart("span",i+"-Descr");r.class("sapUiHidden");r.openEnd();r.text(t);r.close("span");}r.close("div");};
C.getTooltipText=function(o){var v=o.getProperty("valueStateText"),t=o.getTooltip_AsString();if(v){return(t?t+" - ":"")+v;}else{return V.enrichTooltip(o,t);}};
return C;},true);
sap.ui.predefine('sap/m/ColorPaletteRenderer',['sap/ui/Device'],function(D){"use strict";var C={apiVersion:2};var l=sap.ui.getCore().getLibraryResourceBundle("sap.m");
C.render=function(r,c){r.openStart("div",c);r.class("sapMColorPalette");r.openEnd();if(c._getShowDefaultColorButton()){this.renderDefaultColorButton(r,c);this.renderSeparator(r);}this.renderSwatches(r,c);if(c._getShowMoreColorsButton()){this.renderSeparator(r);this.renderMoreColorsButton(r,c);if(D.system.phone){this.renderSeparator(r);}}if(c._getShowRecentColorsSection()){if(!c._getShowMoreColorsButton()||!D.system.phone){this.renderSeparator(r);}this.renderRecentColorsSection(r,c);if(D.system.phone){this.renderSeparator(r);}}r.close("div");};
C.renderSwatches=function(r,c){var s=c.getColors();r.openStart("div",c.getId()+"-swatchCont-paletteColor");r.class("sapMColorPaletteContent");r.accessibilityState(c,{"role":"region","label":l.getText("COLOR_PALETTE_SWATCH_CONTAINER_TITLE")});r.openEnd();s.forEach(function(a,i){this.renderSquare(r,c,a,i,false);},this);r.close("div");};
C.renderSquare=function(r,c,s,i,I){var n=c._ColorsHelper.getNamedColor(s),a=(n===undefined)?l.getText("COLOR_PALETTE_PREDEFINED_COLOR_CUSTOM"):l.getText("COLOR_PALETTE_PREDEFINED_COLOR_"+n.toUpperCase()),b=I?l.getText("COLOR_PALETTE_RECENT_COLOR",[i+1,a]):l.getText("COLOR_PALETTE_PREDEFINED_COLOR",[i+1,a]);r.openStart("div");r.class("sapMColorPaletteSquare");if(I&&s===""){r.class("sapMRecentColorSquareDisabled");}r.attr("data-sap-ui-color",s);r.attr("tabindex","-1");r.attr("title",b);r.accessibilityState(c,{"role":"button","label":b});r.openEnd();r.openStart("div");r.style("background-color",s);r.openEnd();r.close("div");r.close("div");};
C.renderSeparator=function(r){r.openStart("div");r.class("sapMColorPaletteSeparator");r.openEnd();r.voidStart("hr");r.voidEnd();r.close("div");};
C.renderDefaultColorButton=function(r,c){r.renderControl(c._getDefaultColorButton());};
C.renderMoreColorsButton=function(r,c){r.renderControl(c._getMoreColorsButton());};
C.renderRecentColorsSection=function(r,c){var s,R=c._getRecentColors(),a=5,b=l.getText("COLOR_PALETTE_SWATCH_RECENT_COLOR_CONTAINER_TITLE");r.openStart("div",c.getId()+"-swatchCont-recentColors");r.class("sapMColorPaletteContent");r.attr("role","region");r.attr("aria-label",b);r.openEnd();for(var i=0;i<a;i++){if(R[i]){s=R[i];}else{s="";}this.renderSquare(r,c,s,i,true);}r.close("div");};
return C;},true);
sap.ui.predefine('sap/m/Column',['./library','sap/ui/core/Element','sap/ui/core/Renderer','sap/ui/core/library','sap/ui/Device',"sap/ui/thirdparty/jquery"],function(l,E,R,c,D,q){"use strict";var P=l.PopinDisplay;var V=c.VerticalAlign;var T=c.TextAlign;var S=c.SortOrder;
var C=E.extend("sap.m.Column",{metadata:{library:"sap.m",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},hAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:T.Begin},vAlign:{type:"sap.ui.core.VerticalAlign",group:"Appearance",defaultValue:V.Inherit},styleClass:{type:"string",group:"Appearance",defaultValue:null},visible:{type:"boolean",group:"Appearance",defaultValue:true},minScreenWidth:{type:"string",group:"Behavior",defaultValue:null},demandPopin:{type:"boolean",group:"Behavior",defaultValue:false},popinHAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:T.Begin,deprecated:true},popinDisplay:{type:"sap.m.PopinDisplay",group:"Appearance",defaultValue:P.Block},mergeDuplicates:{type:"boolean",group:"Behavior",defaultValue:false},mergeFunctionName:{type:"string",group:"Misc",defaultValue:'getText'},sortIndicator:{type:"sap.ui.core.SortOrder",group:"Appearance",defaultValue:S.None},importance:{type:"sap.ui.core.Priority",group:"Behavior",defaultValue:"None"},autoPopinWidth:{type:"float",group:"Behavior",defaultValue:8}},defaultAggregation:"header",aggregations:{header:{type:"sap.ui.core.Control",multiple:false},footer:{type:"sap.ui.core.Control",multiple:false}},designtime:"sap/m/designtime/Column.designtime"}});
C.prototype._index=-1;C.prototype._screen="";C.prototype._media=null;C.prototype._bForcedColumn=false;
C.prototype.exit=function(){this._clearMedia();};
C.prototype.getTable=function(){var p=this.getParent();if(p&&p.isA("sap.m.Table")){return p;}};
C.prototype.informTable=function(e,p,v){var t=this.getTable();if(t){var m="onColumn"+e;if(t[m]){t[m](this,p,v);}}};
C.prototype.ontouchstart=function(e){this._bTouchStartMarked=e.isMarked();};
C.prototype.ontap=function(e){if(!this._bTouchStartMarked&&!e.isMarked()){this.informTable("Press");}};
C.prototype.onsapspace=function(e){if(e.srcControl===this){this.informTable("Press");e.preventDefault();}};
C.prototype.onsapenter=C.prototype.onsapspace;
C.prototype.invalidate=function(){var p=this.getParent();if(!p||!p.bOutput){return;}E.prototype.invalidate.apply(this,arguments);};
C.prototype._clearMedia=function(){if(this._media&&this._minWidth){this._detachMediaContainerWidthChange(this._notifyResize,this,this.getId());D.media.removeRangeSet(this.getId());this._media=null;}};
C.prototype._addMedia=function(){delete this._bShouldAddMedia;if(this._minWidth){D.media.initRangeSet(this.getId(),[parseFloat(this._minWidth)]);this._attachMediaContainerWidthChange(this._notifyResize,this,this.getId());this._media=this._getCurrentMediaContainerRange(this.getId());if(this._media){this._media.matches=!!this._media.from;}}};
C.prototype._notifyResize=function(m){if(this._media.from===m.from){return;}this._media=m;this._media.matches=!!m.from;setTimeout(function(){this.fireEvent("media",this);this.informTable("Resize");}.bind(this),0);};
C.prototype._validateMinWidth=function(w){if(!w){return;}if(Object.prototype.toString.call(w)!="[object String]"){throw new Error('expected string for property "minScreenWidth" of '+this);}if(Object.keys(l.ScreenSizes).indexOf(w.toLowerCase())!=-1){return;}if(!/^\d+(\.\d+)?(px|em|rem)$/i.test(w)){throw new Error('invalid CSS size("px", "em", "rem" required) or sap.m.ScreenSize enumeration for property "minScreenWidth" of '+this);}};
C.prototype._isWidthPredefined=function(w){var t=this,u=w.replace(/[^a-z]/ig,""),b=parseFloat(l.BaseFontSize)||16;q.each(l.ScreenSizes,function(s,a){if(u!="px"){a/=b;}if(a+u==w){t._minWidth=this+"px";t._screen=s;return false;}});if(this._minWidth){return true;}if(u=="px"){this._minWidth=w;}else{this._minWidth=parseFloat(w)*b+"px";}};
C.prototype.getCssAlign=function(a){a=a||this.getHAlign();if(a===T.Begin||a===T.End||a===T.Initial){a=R.getTextAlign(a);}return a.toLowerCase();};
C.prototype.getStyleClass=function(r){var a=this.getProperty("styleClass");if(!r){return a;}if(this._screen&&(!this.getDemandPopin()||!window.matchMedia)){a+=" sapMSize-"+this._screen;}else if(this._media&&!this._media.matches){a+=" sapMListTblNone";}return a.trim();};
C.prototype.setIndex=function(n){this._index=+n;};
C.prototype.setOrder=function(n){this._order=+n;};
C.prototype.getOrder=function(){return this.hasOwnProperty("_order")?this._order:this.getInitialOrder();};
C.prototype.setInitialOrder=function(n){this._initialOrder=+n;};
C.prototype.getInitialOrder=function(){if(this.hasOwnProperty("_initialOrder")){return this._initialOrder;}var t=this.getTable();if(!t){return-1;}return t.indexOfColumn(this);};
C.prototype.setDisplay=function(t,d){if(!t||this._index<0){return;}var i=this._index+1,p=this.getParent(),a=d&&!this.isHidden()?"table-cell":"none",h=t.querySelector("tr > th:nth-child("+i+")"),b=t.querySelectorAll("tr > td:nth-child("+i+")"),e=b.length;h.style.display=a;h.setAttribute("aria-hidden",!d);for(i=0;i<e;i++){b[i].style.display=a;b[i].setAttribute("aria-hidden",!d);}if(p&&p.setTableHeaderVisibility){setTimeout(function(){p.setTableHeaderVisibility(d);},0);}};
C.prototype.setWidth=function(w){var t=this.getTable();if(!t){return this.setProperty("width",w);}if(this.getWidth()===w){return this;}var o=t.shouldRenderDummyColumn();this.informTable("WidthChanged",w);if(o!==t.shouldRenderDummyColumn()){return this.setProperty("width",w);}var a=t.getAutoPopinMode();this.setProperty("width",w,a);if(a){var $=this.$();$.css("width",w);$.attr("data-sap-width",w);}this.informTable("RecalculateAutoPopin",true);return this;};
C.prototype.setImportance=function(i){if(this.getImportance()===i){return this;}this.setProperty("importance",i,true);this.informTable("RecalculateAutoPopin",true);return this;};
C.prototype.setAutoPopinWidth=function(w){if(this.getAutoPopinWidth()===w){return this;}this.setProperty("autoPopinWidth",w,true);this.informTable("RecalculateAutoPopin",true);return this;};
C.prototype.setVisible=function(v){if(v==this.getVisible()){return this;}var p=this.getParent(),t=p&&p.getTableDomRef&&p.getTableDomRef(),s=t&&this._index>=0;this.setProperty("visible",v,s);if(s){this.informTable("RecalculateAutoPopin",true);this.setDisplay(t,v);}return this;};
C.prototype._setMinScreenWidth=function(w){this._clearMedia();this._minWidth=0;this._screen="";if(w){w=w.toLowerCase();var a=l.ScreenSizes[w];if(a){this._screen=w;this._minWidth=a+"px";}else{this._isWidthPredefined(w);}var p=this.getTable();if(p&&p.isActive()){this._addMedia();}else{this._bShouldAddMedia=true;}}};
C.prototype.setMinScreenWidth=function(w){if(w==this.getMinScreenWidth()){return this;}this._validateMinWidth(w);this._setMinScreenWidth(w);var t=this.getTable();if(!t){return this.setProperty("minScreenWidth",w);}return this.setProperty("minScreenWidth",w,t.getAutoPopinMode());};
C.prototype.setDemandPopin=function(v){if(v==this.getDemandPopin()){return this;}if(!this.getMinScreenWidth()){return this.setProperty("demandPopin",v,true);}return this.setProperty("demandPopin",v);};
C.prototype.setSortIndicator=function(s){this.setProperty("sortIndicator",s,true);this.$().attr("aria-sort",this.getSortIndicator().toLowerCase());return this;};
C.prototype.isPopin=function(){if(!this.getDemandPopin()){return false;}var t=this.getTable();if(t){var h=t.getHiddenInPopin()||[];var H=h.some(function(i){return this.getImportance()===i;},this);if(H){return false;}}if(this._media){return!this._media.matches;}return false;};
C.prototype.isHidden=function(){if(this._media){return!this._media.matches;}if(this._screen&&this._minWidth){return parseFloat(this._minWidth)>window.innerWidth;}return false;};
C.prototype.setLastValue=function(v){if(this.getMergeDuplicates()){this._lastValue=v;}return this;};
C.prototype.clearLastValue=function(){return this.setLastValue(NaN);};
C.prototype.getLastValue=function(){return this._lastValue;};
C.prototype.onItemsRemoved=function(){this.clearLastValue();};
C.prototype.getFocusDomRef=function(){var p=this.getParent();if(p&&p.bActiveHeaders){var o=this.getDomRef();if(o){return o.firstChild;}}return E.prototype.getFocusDomRef.apply(this,arguments);};
C.prototype.getCalculatedMinScreenWidth=function(){return parseInt(this._minWidth)||0;};
C.prototype.setForcedColumn=function(f){if(this._bForcedColumn==f){return;}this._bForcedColumn=f;this._setMinScreenWidth(f?"":this.getMinScreenWidth());};
return C;});
sap.ui.predefine('sap/m/ColumnListItem',["sap/ui/core/Element","sap/ui/core/library","./library","./ListItemBase","./ColumnListItemRenderer","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/Selectors"],function(E,c,l,L,C,q){"use strict";var a=l.ListType;var V=c.VerticalAlign;
var b=L.extend("sap.m.ColumnListItem",{metadata:{library:"sap.m",properties:{vAlign:{type:"sap.ui.core.VerticalAlign",group:"Appearance",defaultValue:V.Inherit}},defaultAggregation:"cells",aggregations:{cells:{type:"sap.ui.core.Control",multiple:true,singularName:"cell",bindable:"bindable"}}}});
var T=E.extend("sap.m.TablePopin",{
ontap:function(e){if(e.isMarked()||L.detectTextSelection(this.getDomRef())){return e.stopImmediatePropagation(true);}if(e.srcControl===this||!q(e.target).is(":sapFocusable")){this.getParent().focus();}},
_onMouseEnter:function(){var $=q(this),d=$.prev();if(!d.length||!d.hasClass("sapMLIBHoverable")||d.hasClass("sapMPopinHovered")){return;}d.addClass("sapMPopinHovered");},
_onMouseLeave:function(){var $=q(this),d=$.prev();if(!d.length||!d.hasClass("sapMLIBHoverable")||!d.hasClass("sapMPopinHovered")){return;}d.removeClass("sapMPopinHovered");}
});
b.prototype.TagName="tr";
b.prototype.init=function(){L.prototype.init.call(this);this._bNeedsTypeColumn=false;this._aClonedHeaders=[];};
b.prototype.onAfterRendering=function(){L.prototype.onAfterRendering.call(this);this._checkTypeColumn();var p=this.hasPopin();if(p){this.$Popin().on("mouseenter",p._onMouseEnter).on("mouseleave",p._onMouseLeave);}};
b.prototype.exit=function(){L.prototype.exit.call(this);this._checkTypeColumn(false);this._destroyClonedHeaders();if(this._oPopin){this._oPopin.destroy(true);this._oPopin=null;}};
b.prototype.setVisible=function(v){L.prototype.setVisible.call(this,v);if(!v&&this.hasPopin()){this.removePopin();}return this;};
b.prototype.getTable=function(){var p=this.getParent();if(p&&p.isA("sap.m.Table")){return p;}};
b.prototype.getPopin=function(){if(!this._oPopin){this._oPopin=new T({id:this.getId()+"-sub"}).addDelegate({ontouchstart:this.ontouchstart,ontouchmove:this.ontouchmove,ontap:this.ontap,ontouchend:this.ontouchend,ontouchcancel:this.ontouchcancel,onsaptabnext:this.onsaptabnext,onsaptabprevious:this.onsaptabprevious,onsapup:this.onsapup,onsapdown:this.onsapdown,oncontextmenu:this.oncontextmenu},this).setParent(this,null,true);}return this._oPopin;};
b.prototype.$Popin=function(){return this.$("sub");};
b.prototype.hasPopin=function(){return this._oPopin;};
b.prototype.removePopin=function(){this._oPopin&&this.$Popin().remove();};
b.prototype.getTabbables=function(){return this.$().add(this.$Popin()).find(":sapTabbable");};
b.prototype.getAccessibilityType=function(B){return B.getText("ACC_CTR_TYPE_ROW");};
b.prototype.getContentAnnouncement=function(B){var t=this.getTable();if(!t){return;}var o=[],d=this.getCells(),e=t.getColumns(true);e.forEach(function(f){var g=d[f.getInitialOrder()];if(!g||!f.getVisible()||(f.isHidden()&&!f.isPopin())){return;}var h=f.getHeader();if(h&&h.getVisible()){o.push(L.getAccessibilityText(h)+" "+L.getAccessibilityText(g,true));}else{o.push(L.getAccessibilityText(g,true));}});return o.join(" . ").trim();};
b.prototype.updateSelectedDOM=function(s,t){L.prototype.updateSelectedDOM.apply(this,arguments);if(this.hasPopin()){this.$Popin().attr("aria-selected",s);}};
b.prototype.onfocusin=function(e){if(e.isMarked()){return;}if(e.srcControl===this){this.$().children(".sapMListTblCellDup").find(":sapTabbable").attr("tabindex",-1);}L.prototype.onfocusin.apply(this,arguments);};
b.prototype._checkTypeColumn=function(n){if(n==undefined){n=this._needsTypeColumn();}if(this._bNeedsTypeColumn!=n){this._bNeedsTypeColumn=n;this.informList("TypeColumnChange",n);}};
b.prototype._needsTypeColumn=function(){var t=this.getType();return this.getVisible()&&(t==a.Detail||t==a.Navigation||t==a.DetailAndActive);};
b.prototype._addClonedHeader=function(h){return this._aClonedHeaders.push(h);};
b.prototype._destroyClonedHeaders=function(){if(this._aClonedHeaders.length){this._aClonedHeaders.forEach(function(o){o.destroy("KeepDom");});this._aClonedHeaders=[];}};
b.prototype._activeHandlingInheritor=function(){this._toggleActiveClass(true);};
b.prototype._inactiveHandlingInheritor=function(){this._toggleActiveClass(false);};
b.prototype._toggleActiveClass=function(s){if(this.hasPopin()){this.$Popin().toggleClass("sapMLIBActive",s);}};
return b;});
sap.ui.predefine('sap/m/ColumnListItemRenderer',["sap/ui/core/Renderer","sap/ui/core/library","sap/ui/core/Core","sap/ui/Device","sap/base/Log","./library","./ListItemBaseRenderer"],function(R,c,C,D,L,l,a){"use strict";var P=l.PopinDisplay;var V=c.VerticalAlign;var b=l.PopinLayout;var d=R.extend(a);d.apiVersion=2;
d.render=function(r,o){var t=o.getTable();if(!t){return;}a.render.apply(this,arguments);if(o.getVisible()&&t.hasPopin()){this.renderPopin(r,o,t);}};
d.renderHighlight=function(r,o){r.openStart("td");r.class("sapMListTblHighlightCell");r.attr("role","presentation");r.attr("aria-hidden","true");r.openEnd();a.renderHighlight.apply(this,arguments);r.close("td");};
d.renderNavigated=function(r,o){r.openStart("td");r.class("sapMListTblNavigatedCell");r.attr("role","presentation");r.attr("aria-hidden","true");r.openEnd();a.renderNavigated.apply(this,arguments);r.close("td");};
d.renderType=function(r,o){r.openStart("td");r.class("sapMListTblNavCol");r.attr("role","presentation");r.attr("aria-hidden","true");r.openEnd();a.renderType.apply(this,arguments);r.close("td");};
d.renderModeContent=function(r,o){r.openStart("td");r.class("sapMListTblSelCol");r.attr("role","presentation");r.attr("aria-hidden","true");r.openEnd();a.renderModeContent.apply(this,arguments);r.close("td");};
d.renderCounter=function(r,o){};
d.getAriaRole=function(o){return"";};
d.renderLIAttributes=function(r,o){r.class("sapMListTblRow");var A=o.getVAlign();if(A!=V.Inherit){r.class("sapMListTblRow"+A);}var t=o.getTable();if(t&&t.getAlternateRowColors()){var p=t.indexOfItem(o);if(p%2==0){r.class("sapMListTblRowAlternate");}}if(t&&t.shouldRenderDummyColumn()){r.class("sapMListTblRowHasDummyCell");}};
d.renderLIContentWrapper=function(r,o){var t=o.getTable();if(!t){return;}var e=t.getColumns(true),f=o.getCells();o._destroyClonedHeaders();e.forEach(function(g,i){var h,j=true,k=f[g.getInitialOrder()];if(!k||!g.getVisible()||g.isPopin()){g.setIndex(-1);return;}r.openStart("td",o.getId()+"_cell"+i);r.class("sapMListTblCell");r.attr("data-sap-ui-column",g.getId());if(g){var s=g.getStyleClass(true).split(" ");s&&s.forEach(function(v){r.class(v);});h=g.getHeader();if(h){r.attr("headers",g.getId());}if(!t.hasPopin()&&g.getMergeDuplicates()){var F=g.getMergeFunctionName(),m=F.split("#"),n=m[1],p=m[0];if(typeof k[p]!="function"){L.warning("mergeFunctionName property is defined on "+g+" but this is not function of "+k);}else if(t._bRendering||!k.bOutput){var q=g.getLastValue(),u=k[p](n);if(q===u){j=C.getConfiguration().getAccessibility();k.addStyleClass("sapMListTblCellDupCnt");r.class("sapMListTblCellDup");}else{g.setLastValue(u);}}else if(k.hasStyleClass("sapMListTblCellDupCnt")){r.class("sapMListTblCellDup");}}g.getVAlign()!="Inherit"&&r.style("vertical-align",g.getVAlign().toLowerCase());r.style("text-align",g.getCssAlign());if(g.isHidden()){r.style("display","none");r.attr("aria-hidden","true");}}r.openEnd();if(j){this.applyAriaLabelledBy(h,k);r.renderControl(k);}r.close("td");},this);};
d.renderDummyCell=function(r,o){r.openStart("td");r.class("sapMListTblDummyCell");r.attr("role","presentation");r.attr("aria-hidden","true");r.openEnd();r.close("td");};
d.applyAriaLabelledBy=function(h,o){if(h&&h.getText&&h.getVisible()&&o.getAriaLabelledBy&&(o.getAriaLabelledBy()||[]).indexOf(h.getId())==-1){o.addAriaLabelledBy(h);}};
d.renderPopin=function(r,o,t){o.removePopin();r.openStart("tr",o.getPopin());r.class("sapMListTblSubRow");r.attr("tabindex","-1");if(o.isSelectable()){r.attr("aria-selected",o.getSelected());}r.openEnd();this.renderHighlight(r,o);r.openStart("td",o.getId()+"-subcell");r.class("sapMListTblSubRowCell");r.attr("colspan",t.shouldRenderDummyColumn()?t.getColSpan()+1:t.getColSpan());var p=t.getPopinLayout();if(D.browser.msie||(D.browser.edge&&D.browser.version<16)){p=b.Block;}r.attr("aria-labelledby",this.getAriaAnnouncement(null,"TABLE_POPIN_ROLE_DESCRIPTION"));r.openEnd();r.openStart("div");r.class("sapMListTblSubCnt");r.class("sapMListTblSubCnt"+p);r.openEnd();var e=o.getCells(),f=t.getColumns(true);f.forEach(function(g){if(!g.getVisible()||!g.isPopin()){return;}var h=e[g.getInitialOrder()],H=g.getHeader();if(!H&&!h){return;}var s=g.getStyleClass().split(" "),i=g.getPopinDisplay();r.openStart("div");r.class("sapMListTblSubCntRow");s&&s.forEach(function(j){r.class(j);});r.openEnd();if(H&&i!=P.WithoutHeader){r.openStart("div").class("sapMListTblSubCntHdr").openEnd();H=H.clone();g.addDependent(H);o._addClonedHeader(H);r.renderControl(H);r.close("div");r.openStart("div").class("sapMListTblSubCntSpr").openEnd();r.text(C.getLibraryResourceBundle("sap.m").getText("TABLE_POPIN_LABEL_COLON"));r.close("div");}if(h){r.openStart("div");r.class("sapMListTblSubCntVal");r.class("sapMListTblSubCntVal"+i);r.openEnd();this.applyAriaLabelledBy(H,h);r.renderControl(h);r.close("div");}r.close("div");},this);r.close("div");r.close("td");this.renderNavigated(r,o);r.close("tr");};
d.addLegacyOutlineClass=function(r,o){};
d.renderContentLatter=function(r,o){var t=o.getTable();if(t&&t.shouldRenderDummyColumn()){if(!t.hasPopin()){a.renderContentLatter.apply(this,arguments);this.renderDummyCell(r,o);}else{this.renderDummyCell(r,o);a.renderContentLatter.apply(this,arguments);}}else{a.renderContentLatter.apply(this,arguments);}};
return d;},true);
sap.ui.predefine('sap/m/ComboBox',['./ComboBoxTextField','./ComboBoxBase','./List','./library','sap/ui/Device','sap/ui/core/Item','./StandardListItem','./ComboBoxRenderer','sap/ui/base/ManagedObjectObserver',"sap/ui/dom/containsOrEquals","sap/m/inputUtils/scrollToItem","sap/m/inputUtils/inputsDefaultFilter","sap/ui/events/KeyCodes","./Toolbar","sap/base/assert","sap/base/security/encodeXML","sap/ui/core/Core","sap/base/Log","sap/ui/dom/jquery/control"],function(C,a,L,l,D,I,S,b,M,c,s,d,K,T,f,g,h,j,q){"use strict";var k=l.ListType;var m=l.ListMode;
var n=a.extend("sap.m.ComboBox",{metadata:{library:"sap.m",designtime:"sap/m/designtime/ComboBox.designtime",properties:{selectedKey:{type:"string",group:"Data",defaultValue:""},selectedItemId:{type:"string",group:"Misc",defaultValue:""},filterSecondaryValues:{type:"boolean",group:"Misc",defaultValue:false}},associations:{selectedItem:{type:"sap.ui.core.Item",multiple:false}},events:{change:{parameters:{value:{type:"string"},itemPressed:{type:"boolean"}}},selectionChange:{parameters:{selectedItem:{type:"sap.ui.core.Item"}}}},dnd:{draggable:false,droppable:true}}});
function H(e,i){if(!i){return;}var r=e.getFocusDomRef(),t=e._getSelectionRange().start,u=r.value.substring(0,r.selectionStart),v=e._shouldResetSelectionStart(i),w=e.getSelectedItem(),G=i.isA("sap.ui.core.SeparatorItem"),x=e.getListItem(i);e.handleListItemsVisualFocus(x);e.setSelection(i);if(i!==w&&!G){e.updateDomValue(i.getText());e.fireSelectionChange({selectedItem:i});i=e.getSelectedItem();x=e.getListItem(i);if(v){t=0;}e.selectText(t,r.value.length);e._bIsLastFocusedItemHeader=false;}if(G){e.setSelectedItem(null);e.fireSelectionChange({selectedItem:null});e.updateDomValue(u);e._bIsLastFocusedItemHeader=true;e._getGroupHeaderInvisibleText().setText(e._oRb.getText("LIST_ITEM_GROUP_HEADER")+" "+i.getText());}if(e.isOpen()){e.removeStyleClass("sapMFocus");e._getList().addStyleClass("sapMListFocus");}else{e.addStyleClass("sapMFocus");}s(x,e.getPicker());}
function o(i,e){if(document.activeElement===this.getFocusDomRef()){this.selectText(i,e);}}
function p(i){var e=this.getSelectedItem(),r=this.getListItem(e),t=e&&r&&r.getDomRef(),u=t&&t.offsetTop,v=t&&t.offsetHeight,P=this.getPicker(),w=P.getDomRef("cont"),x=w.clientHeight;if(e&&((u+v)>(x))){if(!i){this._getList().$().css("visibility","hidden");}else{w.scrollTop=u-v/2;this._getList().$().css("visibility","visible");}}}
n.prototype._getSelectedItemText=function(i){i=i||this.getSelectedItem();if(!i){i=this.getDefaultSelectedItem();}if(i){return i.getText();}return"";};
n.prototype.setSelectedIndex=function(i,_){var e;_=_||this.getItems();i=(i>_.length-1)?_.length-1:Math.max(0,i);e=_[i];if(e){this.setSelection(e);}};
n.prototype.revertSelection=function(){var P,e=this.getPickerTextField();this.setSelectedItem(this._oSelectedItemBeforeOpen);this.setValue(this._sValueBeforeOpen);if(this.getSelectedItem()===null){P=this._sValueBeforeOpen;}else{P=this._oSelectedItemBeforeOpen.getText();}e&&e.setValue(P);};
n.prototype.filterItems=function(O){var e,i=this.getItems(),F=[],r=[],t=O.properties.indexOf("additionalText")>-1,u=this.fnFilter||d,G=[],v=false;this._oFirstItemTextMatched=null;i.forEach(function(w){if(w.isA("sap.ui.core.SeparatorItem")){G.push({header:w,visible:false});v=true;e=this.getListItem(w);e&&e.setVisible(false);return;}var x=u.call(this,O.value,w,t);if(x&&v&&G.length){G[G.length-1].visible=true;v=false;}if(x){r.push(w);F.push(w);}}.bind(this));i.forEach(function(w){if(w.isA("sap.ui.core.SeparatorItem")){return;}var x=F.indexOf(w)>-1;var y=r.indexOf(w)>-1;if(!this._oFirstItemTextMatched&&y){this._oFirstItemTextMatched=w;}e=this.getListItem(w);e&&e.setVisible(x);},this);G.forEach(function(w){if(w.visible){e=this.getListItem(w.header);e&&e.setVisible(true);}}.bind(this));return F;};
n.prototype._filterStartsWithItems=function(i,e){var r=i.toLowerCase();var t=this.getItems(),F=t.filter(function(u){return u[e]&&u[e]().toLowerCase().startsWith(r);});return F;};
n.prototype._getFilters=function(){return this.getFilterSecondaryValues()?["text","additionalText"]:["text"];};
n.prototype.getNextFocusableItem=function(e){var A=this.getSelectableItems(),i=this.getNonSeparatorSelectableItems(A),F=this.hasStyleClass("sapMFocus"),r=this.getSelectedItem()||this._getItemByListItem(this._oLastFocusedListItem),t=this.getFormattedTextFocused(),N;if((F&&this.isOpen())||t){N=A[0];}else if(F&&!this.getValueStateLinks().length){N=i[i.indexOf(r)+(e?1:-1)];}else{N=A[A.indexOf(r)+(e?1:-1)];}if(t||(!t&&r===A[0]&&!e&&this.getValueStateLinks().length)){this.setProperty("formattedTextFocused",!t);}return N;};
n.prototype.getNonSeparatorSelectableItems=function(i){return i.filter(function(e){return!e.isA("sap.ui.core.SeparatorItem");});};
n.prototype._itemsTextStartsWithTypedValue=function(i,t){if(!i||typeof t!="string"||t==""){return false;}return i.getText().toLowerCase().startsWith(t.toLowerCase());};
n.prototype._shouldResetSelectionStart=function(i){var e=this.getFocusDomRef(),r=this._getSelectionRange(),t=r.start!==r.end,u=e.value.substring(0,r.start),v=this._itemsTextStartsWithTypedValue(i,u);return!(v&&(t||this._bIsLastFocusedItemHeader));};
n.prototype._getSelectionRange=function(){var e=this.getFocusDomRef(),v=this.getValue(),i=e.selectionStart,r=e.selectionEnd,R={start:i,end:r};if(!(D.browser.msie||D.browser.edge)){return R;}if(this._bIsLastFocusedItemHeader){R.start=v.length;R.end=v.length;}return R;};
n.prototype.handleListItemsVisualFocus=function(e){if(this._oLastFocusedListItem){this._oLastFocusedListItem.removeStyleClass("sapMLIBFocused");this._oLastFocusedListItem=null;}else if(this.isOpen()&&this.getFocusDomRef()){this.getFocusDomRef().setAttribute("aria-activedescendant",e.getId());}if(e){this._oLastFocusedListItem=e;e.addStyleClass("sapMLIBFocused");}};
n.prototype.setSelection=function(i){var e=this._getList(),r=this._getSuggestionsPopover(),t,u;this.setAssociation("selectedItem",i);this._setPropertyProtected("selectedItemId",(i instanceof I)?i.getId():i,true);if(typeof i==="string"){i=h.byId(i);}if(e){t=this.getListItem(i);if(t){e.setSelectedItem(t,true);}else{e.removeSelections(true);}}u=i?i.getKey():"";this._setPropertyProtected("selectedKey",u);if(r){r._iPopupListSelectedIndex=this.getItems().indexOf(i);}};
n.prototype.isSelectionSynchronized=function(){var i=this.getSelectedItem();return this.getSelectedKey()===(i&&i.getKey());};
n.prototype._mapItemToListItem=function(i){var e,r,t,A;var R=this.getRenderer();if(!i){return null;}A=(i.getAdditionalText&&this.getShowSecondaryValues())?i.getAdditionalText():"";r=R.CSS_CLASS_COMBOBOXBASE+"Item";t=(this.isItemSelected(i))?r+"Selected":"";if(i.isA("sap.ui.core.SeparatorItem")){e=this._mapSeparatorItemToGroupHeader(i,R);}else{e=new S({type:k.Active,info:A,visible:i.getEnabled()}).addStyleClass(r+" "+t);}e.setTitle(i.getText());this.setSelectable(i,i.getEnabled());e.setTooltip(i.getTooltip());i.data(R.CSS_CLASS_COMBOBOXBASE+"ListItem",e);i.getCustomData().forEach(function(u){e.addCustomData(u.clone());});this._oItemObserver.observe(i,{properties:["text","additionalText","enabled","tooltip"]});return e;};
n.prototype._forwardItemProperties=function(P){var i=P.object,e=i.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"ListItem"),r={text:"title",enabled:"visible",tooltip:"tooltip"},A,t,u;if(Object.keys(r).indexOf(P.name)>-1){t=r[P.name];u="set"+t.charAt(0).toUpperCase()+t.slice(1);e[u](P.current);}if(P.name==="additionalText"){A=this.getShowSecondaryValues()?P.current:"";e.setInfo(A);}};
n.prototype.isItemSelected=function(i){return i&&(i.getId()===this.getAssociation("selectedItem"));};
n.prototype.setAssociation=function(A,i,e){var r=this._getList();if(r&&(A==="selectedItem")){if(!(i instanceof I)){i=this.findItem("id",i);}r.setSelectedItem(this.getListItem(i),true);}return a.prototype.setAssociation.apply(this,arguments);};
n.prototype.removeAllAssociation=function(A,e){var i=this._getList();if(i&&(A==="selectedItem")){L.prototype.removeAllAssociation.apply(i,arguments);}return a.prototype.removeAllAssociation.apply(this,arguments);};
n.prototype.init=function(){this._oRb=h.getLibraryResourceBundle("sap.m");a.prototype.init.apply(this,arguments);this.bOpenValueStateMessage=true;this._sValueBeforeOpen="";this._sInputValueBeforeOpen="";this._oSelectedItemBeforeOpen=null;this._oFirstItemTextMatched=null;this.bIsFocused=false;if(D.system.phone){this.attachEvent("_change",this.onPropertyChange,this);}this._oLastFocusedListItem=null;this._bIsLastFocusedItemHeader=null;this._oItemObserver=new M(this._forwardItemProperties.bind(this));};
n.prototype.onBeforeRendering=function(){a.prototype.onBeforeRendering.apply(this,arguments);var e=this.getSelectedItem(),i=this._getList(),r=e&&this.getListItem(e),F=this.getProperty("formattedTextFocused"),t=this.getPicker()&&this.getPicker().getCustomHeader(),P=(D.browser.msie&&t&&t.getFormattedText)?t.getFormattedText():t;this.synchronizeSelection();if(!this.getOpen()&&document.activeElement===this.getFocusDomRef()){this.addStyleClass("sapMFocus");}if(F){P.addStyleClass("sapMPseudoFocus");i.removeStyleClass("sapMListFocus");r.removeStyleClass("sapMLIBFocused");this.removeStyleClass("sapMFocus");}else if(P){P.removeStyleClass("sapMPseudoFocus");}};
n.prototype._fillList=function(){var e=this._getList(),r,t,u,i,v;if(!e){return;}if(this._oLastFocusedListItem){v=this._getItemByListItem(this._oLastFocusedListItem);}e.destroyItems();r=this.getItems();if(this._sInputValueBeforeOpen){r=this.filterItems({properties:this._getFilters(),value:this._sInputValueBeforeOpen});}for(i=0,u=r.length;i<u;i++){t=this._mapItemToListItem(r[i]);e.addAggregation("items",t,true);}if(v){this._oLastFocusedListItem=this.getListItem(v);}};
n.prototype.exit=function(){a.prototype.exit.apply(this,arguments);this._oRb=null;this._oSelectedItemBeforeOpen=null;this._oFirstItemTextMatched=null;this._oLastFocusedListItem=null;if(this._oSuggestionPopover){if(this._oPickerCustomHeader){this._oPickerCustomHeader.destroy();this._oPickerCustomHeader=null;}this._oSuggestionPopover.destroy();this._oSuggestionPopover=null;}if(this._oItemObserver){this._oItemObserver.disconnect();this._oItemObserver=null;}};
n.prototype.onBeforeRenderingPicker=function(){var O=this["onBeforeRendering"+this.getPickerType()];O&&O.call(this);};
n.prototype.onBeforeRenderingDropdown=function(){var P=this.getPicker(),w=(this.$().outerWidth()/parseFloat(l.BaseFontSize))+"rem";if(P){P.setContentMinWidth(w);}};
n.prototype.onBeforeRenderingList=function(){if(this.bProcessingLoadItemsEvent){var e=this._getList(),F=this.getFocusDomRef();if(e){e.setBusy(true);}if(F){F.setAttribute("aria-busy","true");}}};
n.prototype.onAfterRenderingPicker=function(){var O=this["onAfterRendering"+this.getPickerType()];O&&O.call(this);p.call(this,false);};
n.prototype.onAfterRenderingList=function(){var e=this.getSelectedItem(),i=this.getListItem(e);if(this.bProcessingLoadItemsEvent&&(this.getItems().length===0)){return;}var r=this._getList(),F=this.getFocusDomRef();this.highlightList(this._sInputValueBeforeOpen);if(e){r.setSelectedItem(i);this.handleListItemsVisualFocus(i);}if(r){r.setBusy(false);}if(F){F.removeAttribute("aria-busy");}};
n.prototype.oninput=function(e){a.prototype.oninput.apply(this,arguments);this.syncPickerContent();if(e.isMarked("invalid")){return;}this.loadItems(function(){this.handleInputValidation(e,this.isComposingCharacter());},{name:"input",busyIndicator:false});if(this.bProcessingLoadItemsEvent&&(this.getPickerType()==="Dropdown")){this.open();}if(this._oLastFocusedListItem){this._oLastFocusedListItem.removeStyleClass("sapMLIBFocused");this._oLastFocusedListItem=null;}this.setFormattedTextFocused(false);this.addStyleClass("sapMFocus");this._getList().removeStyleClass("sapMListFocus");if(this._getItemsShownWithFilter()){this.toggleIconPressedStyle(true);}};
n.prototype.handleInputValidation=function(e,i){var v,r,F,t,u,w=this.getSelectedItem(),V=e.target.value,E=V==="",x=e.srcControl,y=(this.getPickerType()==="Dropdown"),z=this.getListItem(w);if(E&&!this.bOpenedByKeyboardOrButton&&!this.isPickerDialog()){v=this.getItems();}else{v=this.filterItems({properties:this._getFilters(),value:V});}F=v[0];t=v.some(function(A){return A.getKey()===this.getSelectedKey();},this);r=this.intersectItems(this._filterStartsWithItems(V,'getText'),v);u=!E&&F&&F.getEnabled();if(F&&this.getSelectedKey()&&!t){this.setSelection(null);}if(u&&x&&x._bDoTypeAhead){this.handleTypeAhead(x,v,V,i);}else if(u&&V===r[0].getText()){this.setSelection(r[0]);}else{this.setSelection(null);}if(w!==this.getSelectedItem()){this.fireSelectionChange({selectedItem:this.getSelectedItem()});z=this.getListItem(this.getSelectedItem());}this._sInputValueBeforeOpen=V;if(this.isOpen()){setTimeout(function(){this.highlightList(V);}.bind(this));}if(F){if(E&&!this.bOpenedByKeyboardOrButton){this.close();}else if(y){this.open();s(z,this.getPicker());}}else if(this.isOpen()){if(y&&!this.bOpenedByKeyboardOrButton){this.close();}}else{this.clearFilter();}};
n.prototype.handleTypeAhead=function(i,e,v,r){var t=this.intersectItems(this._filterStartsWithItems(v,'getText'),e);var u=this.getFilterSecondaryValues();var w=D.system.desktop;var x=this.intersectItems(this._filterStartsWithItems(v,'getAdditionalText'),e);if(u&&!t[0]&&x[0]){!r&&i.updateDomValue(x[0].getAdditionalText());this.setSelection(x[0]);}else if(t[0]){!r&&i.updateDomValue(t[0].getText());this.setSelection(t[0]);}if(w){o.call(i,v.length,i.getValue().length);}else{setTimeout(o.bind(i,v.length,i.getValue().length),0);}this.addStyleClass("sapMFocus");this._getList().removeStyleClass("sapMListFocus");};
n.prototype.onSelectionChange=function(e){var i=this._getItemByListItem(e.getParameter("listItem")),P=this.getChangeEventParams(),r=(i!==this.getSelectedItem());this.updateDomValue(i.getText());this.setSelection(i);this.fireSelectionChange({selectedItem:this.getSelectedItem()});if(r){P.itemPressed=true;this.onChange(null,P);}};
n.prototype.onItemPress=function(e){var i=e.getParameter("listItem"),t=i.getTitle(),P=this.getChangeEventParams(),r=(i!==this.getListItem(this.getSelectedItem()));if(i.isA("sap.m.GroupHeaderListItem")){return;}this.handleListItemsVisualFocus(i);this.updateDomValue(t);if(!r){P.itemPressed=true;this.onChange(null,P);}this._setPropertyProtected("value",t,true);if(this.getPickerType()==="Dropdown"&&!this.isPlatformTablet()){this.selectText.bind(this,this.getValue().length,this.getValue().length);}this.close();};
n.prototype.onBeforeOpen=function(){a.prototype.onBeforeOpen.apply(this,arguments);var P=this["onBeforeOpen"+this.getPickerType()],e=this.getFocusDomRef();this.setProperty("open",true);if(this.hasLoadItemsEventListeners()&&!this.bProcessingLoadItemsEvent){this.loadItems();}if(e){e.setAttribute("aria-controls",this.getPicker().getId());}this.addContent();P&&P.call(this);};
n.prototype.onBeforeOpenDialog=function(){var P=this.getPickerTextField();this._oSelectedItemBeforeOpen=this.getSelectedItem();this._sValueBeforeOpen=this.getValue();if(this.getSelectedItem()){this.filterItems({properties:this._getFilters(),value:""});}P.setValue(this._sValueBeforeOpen);};
n.prototype.onAfterOpen=function(){var i=this.getSelectedItem(),e=this._getSelectionRange(),t=this.isPlatformTablet();this.closeValueStateMessage();p.call(this,true);if(!t&&i&&e.start===e.end&&e.start>1){setTimeout(function(){this.selectText(0,e.end);}.bind(this),0);}};
n.prototype.onBeforeClose=function(){a.prototype.onBeforeClose.apply(this,arguments);var e=this.getFocusDomRef();this.setProperty("open",false);this.setProperty("formattedTextFocused",false);if(e){e.removeAttribute("aria-controls");}this.toggleIconPressedStyle(false);};
n.prototype.onAfterClose=function(){this.clearFilter();this._sInputValueBeforeOpen="";if(this.isPickerDialog()){a.prototype.closeValueStateMessage.apply(this,arguments);}};
n.prototype.onItemChange=function(e){var i=this.getAssociation("selectedItem"),N=e.getParameter("newValue"),P=e.getParameter("name");if(i===e.getParameter("id")){switch(P){case"text":if(!this.isBound("value")){this.setValue(N);}break;case"key":if(!this.isBound("selectedKey")){this.setSelectedKey(N);}break;}}};
n.prototype.onkeydown=function(e){var i=e.srcControl;a.prototype.onkeydown.apply(i,arguments);if(!i.getEnabled()||!i.getEditable()){return;}var r=K;i._bDoTypeAhead=!D.os.android&&(e.which!==r.BACKSPACE)&&(e.which!==r.DELETE);};
n.prototype.oncut=function(e){var i=e.srcControl;a.prototype.oncut.apply(i,arguments);i._bDoTypeAhead=false;};
n.prototype.onsapenter=function(e){var i=e.srcControl,r=i.getSelectedItem();if(r&&this.getFilterSecondaryValues()){i.updateDomValue(r.getText());}a.prototype.onsapenter.apply(i,arguments);if(!i.getEnabled()||!i.getEditable()){return;}if(i.isOpen()&&!this.isComposingCharacter()){i.close();}};
n.prototype.onsapdown=function(e){var i=e.srcControl;if(!i.getEnabled()||!i.getEditable()){return;}this.syncPickerContent();e.setMarked();e.preventDefault();this.loadItems(function r(){H.call(this,i,this.getNextFocusableItem(true));});};
n.prototype.onsapup=function(e){var i=e.srcControl;if(!i.getEnabled()||!i.getEditable()){return;}this.syncPickerContent();e.setMarked();e.preventDefault();this.loadItems(function r(){H.call(this,i,this.getNextFocusableItem(false));});};
n.prototype.onsaphome=function(e){var i=e.srcControl;if(!i.getEnabled()||!i.getEditable()){return;}this.syncPickerContent();e.setMarked();if(this.getValueStateLinks().length){this.setProperty("formattedTextFocused",true);}e.preventDefault();this.loadItems(function r(){var F=this.getSelectableItems()[0];H.call(this,i,F);});};
n.prototype.onsapend=function(e){var i=e.srcControl;if(!i.getEnabled()||!i.getEditable()){return;}this.syncPickerContent();e.setMarked();e.preventDefault();if(this.getValueStateLinks().length&&this.getFormattedTextFocused()){this.setProperty("formattedTextFocused",false);}this.loadItems(function t(){var r=this.findLastEnabledItem(this.getSelectableItems());H.call(this,i,r);});};
n.prototype.onsappagedown=function(e){var i=e.srcControl;if(!i.getEnabled()||!i.getEditable()){return;}this.syncPickerContent();e.setMarked();e.preventDefault();if(this.getValueStateLinks().length&&this.getFormattedTextFocused()){this.setProperty("formattedTextFocused",false);}this.loadItems(function(){var r=this.getNonSeparatorSelectableItems(this.getSelectableItems()),t=r.indexOf(this.getSelectedItem())+10,u;t=(t>r.length-1)?r.length-1:Math.max(0,t);u=r[t];H.call(this,i,u);});};
n.prototype.onsappageup=function(e){var i=e.srcControl;if(!i.getEnabled()||!i.getEditable()){return;}this.syncPickerContent();e.setMarked();e.preventDefault();this.loadItems(function(){var r=this.getNonSeparatorSelectableItems(this.getSelectableItems()),t=r.indexOf(this.getSelectedItem())-10,u;t=(t>r.length-1)?r.length-1:Math.max(0,t);u=r[t];H.call(this,i,u);});};
n.prototype.onsapshow=function(e){var i,r,E=this.getEditable(),t;a.prototype.onsapshow.apply(this,arguments);this.syncPickerContent();if(!this.getValue()&&E){i=this.getSelectableItems();r=this.getNonSeparatorSelectableItems(i)[0];if(r){t=this.getListItem(r);if(this.isOpen()){this.removeStyleClass("sapMFocus");this._getList().addStyleClass("sapMListFocus");this.handleListItemsVisualFocus(t);}else{this.addStyleClass("sapMFocus");}this.setSelection(r);this.updateDomValue(r.getText());this.fireSelectionChange({selectedItem:r});setTimeout(function(){this.selectText(0,r.getText().length);}.bind(this),0);}}};
n.prototype.onsaphide=n.prototype.onsapshow;
n.prototype.ontap=function(e){var i=this.getFocusDomRef(),A="aria-activedescendant";this.addStyleClass("sapMFocus");if(this.getFormattedTextFocused()){this.setFormattedTextFocused(false);}else if((this.getOpen()&&this._getList().hasStyleClass("sapMListFocus"))||this._oLastFocusedListItem){this._getList().removeStyleClass("sapMListFocus");this._oLastFocusedListItem.removeStyleClass("sapMLIBFocused");this._oLastFocusedListItem=null;i.removeAttribute(A);}};
n.prototype.onfocusin=function(e){var i=this.getPickerType()==="Dropdown";if(this._bIsBeingDestroyed){return;}if(e.target===this.getOpenArea()){this.bOpenValueStateMessage=false;if(i&&!this.isPlatformTablet()){this.focus();}}else{if(i){setTimeout(function(){if(document.activeElement===this.getFocusDomRef()&&!this.bIsFocused&&!this.bFocusoutDueRendering&&!this.getSelectedText()){this.selectText(0,this.getValue().length);}this.bIsFocused=true;}.bind(this),0);}if(!this.isOpen()&&this.bOpenValueStateMessage&&this.shouldValueStateMessageBeOpened()){this.openValueStateMessage();}this.bOpenValueStateMessage=true;}if(this.getEnabled()&&(!this.isOpen()||!this.getSelectedItem()||!this._getList().hasStyleClass("sapMListFocus"))){this.addStyleClass("sapMFocus");}};
n.prototype.onsapfocusleave=function(e){this.bIsFocused=false;var t,P,r,F,i=this.getSelectedItem();if(i&&this.getFilterSecondaryValues()){this.updateDomValue(i.getText());}a.prototype.onsapfocusleave.apply(this,arguments);if(this.isPickerDialog()){return;}P=this.getPicker();if(!e.relatedControlId||!P){return;}t=this.isPlatformTablet();r=h.byId(e.relatedControlId);F=r&&r.getFocusDomRef();if(c(P.getFocusDomRef(),F)&&!t&&!this.getFormattedTextFocused()){this.focus();}};
n.prototype.synchronizeSelection=function(){if(this.isSelectionSynchronized()){return;}var e=this.getSelectedKey(),i=this.getItemByKey(""+e);if(i&&(e!=="")){this.setAssociation("selectedItem",i,true);this._setPropertyProtected("selectedItemId",i.getId(),true);this.setValue(i.getText());this._sValue=this.getValue();}};
n.prototype.configPicker=function(P){var r=this.getRenderer(),e=r.CSS_CLASS_COMBOBOXBASE;P.setHorizontalScrolling(false).addStyleClass(e+"Picker").addStyleClass(e+"Picker-CTX").attachBeforeOpen(this.onBeforeOpen,this).attachAfterOpen(this.onAfterOpen,this).attachBeforeClose(this.onBeforeClose,this).attachAfterClose(this.onAfterClose,this).addEventDelegate({onBeforeRendering:this.onBeforeRenderingPicker,onAfterRendering:this.onAfterRenderingPicker},this);};
n.prototype._configureList=function(e){var r=this.getRenderer();if(!e){return;}e.setMode(m.SingleSelectMaster).addStyleClass(r.CSS_CLASS_COMBOBOXBASE+"List").addStyleClass(r.CSS_CLASS_COMBOBOX+"List");e.attachSelectionChange(this.onSelectionChange,this).attachItemPress(this.onItemPress,this);e.addEventDelegate({onBeforeRendering:this.onBeforeRenderingList,onAfterRendering:this.onAfterRenderingList},this);};
n.prototype.destroyItems=function(){this.destroyAggregation("items");if(this._getList()){this._getList().destroyItems();}return this;};
n.prototype.getDefaultSelectedItem=function(){return null;};
n.prototype.getChangeEventParams=function(){return{itemPressed:false};};
n.prototype.clearSelection=function(){this.setSelection(null);};
n.prototype.selectText=function(i,e){a.prototype.selectText.apply(this,arguments);this.textSelectionStart=i;this.textSelectionEnd=e;return this;};
n.prototype.removeAllItems=function(){var i=a.prototype.removeAllItems.apply(this,arguments);this._fillList();return i;};
n.prototype.clone=function(i){var e=a.prototype.clone.apply(this,arguments),r=this._getList();if(!this.isBound("items")&&r){e.syncPickerContent();e.setSelectedIndex(this.indexOfItem(this.getSelectedItem()));}return e;};
n.prototype.open=function(){this.syncPickerContent();var e=this._getList();a.prototype.open.call(this);if(this.getSelectedItem()){e.addStyleClass("sapMListFocus");this.removeStyleClass("sapMFocus");}return this;};
n.prototype.syncPickerContent=function(){var P,e=this.getPicker(),i=this.getInputForwardableProperties();if(!e){var r,G;e=this.createPicker(this.getPickerType());P=this.getPickerTextField();this._fillList();if(P){i.forEach(function(t){t=t.charAt(0).toUpperCase()+t.slice(1);r="set"+t;G="get"+t;if(P[r]){P[r](this[G]());}},this);}this._getSuggestionsPopover().updateValueState(this.getValueState(),this.getValueStateText(),this.getShowValueStateMessage());}this.synchronizeSelection();return e;};
n.prototype.findAggregatedObjects=function(){var e=this._getList();if(e){return L.prototype.findAggregatedObjects.apply(e,arguments);}return[];};
n.prototype.setSelectedItem=function(i){if(typeof i==="string"){this.setAssociation("selectedItem",i,true);i=h.byId(i);}if(!(i instanceof I)&&i!==null){return this;}if(!i){i=this.getDefaultSelectedItem();}this.setSelection(i);this.setValue(this._getSelectedItemText(i));return this;};
n.prototype.setSelectedItemId=function(i){i=this.validateProperty("selectedItemId",i);if(!i){i=this.getDefaultSelectedItem();}this.setSelection(i);i=this.getSelectedItem();this.setValue(this._getSelectedItemText(i));return this;};
n.prototype.setSelectedKey=function(e){e=this.validateProperty("selectedKey",e);var i=(e===""),r=this.isBound("selectedKey")&&this.isBound("value")&&this.getBindingInfo("selectedKey").skipModelUpdate;if(i){this.setSelection(null);if(!r){this.setValue("");}return this;}var t=this.getItemByKey(e);if(t){this.setSelection(t);if(!r){this.setValue(this._getSelectedItemText(t));}return this;}this._sValue=this.getValue();return this._setPropertyProtected("selectedKey",e);};
n.prototype._setPropertyProtected=function(P,v,i){try{return this.setProperty(P,v,i);}catch(e){j.warning("setSelectedKey update failed due to exception. Loggable in support mode log",null,null,function(){return{exception:e};});}};
n.prototype.getSelectedItem=function(){var v=this.getAssociation("selectedItem");return(v===null)?null:h.byId(v)||null;};
n.prototype.removeItem=function(i){i=a.prototype.removeItem.apply(this,arguments);var e;if(this._getList()){this._getList().removeItem(i&&this.getListItem(i));}if(this.isBound("items")&&!this.bItemsUpdated){return i;}var v=this.getValue();if(this.getItems().length===0){this.clearSelection();}else if(this.isItemSelected(i)){e=this.getDefaultSelectedItem();this.setSelection(e);this.setValue(v);}return i;};
n.prototype._modifyPopupInput=function(i){a.prototype._modifyPopupInput.apply(this,arguments);i.addEventDelegate({onsapenter:function(){var t=i.getValue();this.updateDomValue(t);this.onChange();if(t){this.updateDomValue(t);this.onChange();this.close();}}},this);return i;};
n.prototype.applyShowItemsFilters=function(){var P,e;this.syncPickerContent();P=this.getPicker();e=function(){P.detachBeforeOpen(e,this);P=null;this.filterItems({value:this.getValue()||"_",properties:this._getFilters()});};P.attachBeforeOpen(e,this);};
n.prototype.showItems=function(F){var e,i=Array.prototype.slice.call(arguments),r=this.fnFilter,t=function(){this.setFilterFunction(F||function(){return true;});e=this.filterItems({value:this.getValue()||"_",properties:this._getFilters()});this.setFilterFunction(r);if(e&&e.length){a.prototype.showItems.apply(this,i);}}.bind(this);this.attachLoadItems(t);this.loadItems(t);};
n.prototype._getFormattedValueStateText=function(){if(this.isOpen()){return this._getSuggestionsPopover()._getValueStateHeader().getFormattedText();}else{return C.prototype.getFormattedValueStateText.call(this);}};
return n;});
sap.ui.predefine('sap/m/ComboBoxBase',['./Dialog','./ComboBoxTextField','./Input','./GroupHeaderListItem','./SuggestionsPopover','sap/ui/core/SeparatorItem','sap/ui/core/InvisibleText','sap/base/Log','./library','sap/ui/Device','sap/ui/core/library','./ComboBoxBaseRenderer',"sap/ui/dom/containsOrEquals","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery","sap/base/security/encodeXML","sap/base/strings/escapeRegExp","sap/m/inputUtils/highlightDOMElements"],function(D,C,I,G,S,a,b,L,l,c,d,e,f,K,q,g,h,j){"use strict";var k=l.ListType;var P=l.PlacementType;var m=["value","enabled","name","placeholder","editable","textAlign","textDirection","valueState","valueStateText"];
var n=C.extend("sap.m.ComboBoxBase",{metadata:{library:"sap.m","abstract":true,defaultAggregation:"items",properties:{showSecondaryValues:{type:"boolean",group:"Misc",defaultValue:false},formattedTextFocused:{type:"boolean",defaultValue:false,hidden:true},open:{type:"boolean",defaultValue:false,hidden:true}},aggregations:{items:{type:"sap.ui.core.Item",multiple:true,singularName:"item",bindable:"bindable"},picker:{type:"sap.ui.core.PopupInterface",multiple:false,visibility:"hidden"}},events:{loadItems:{}},dnd:{draggable:false,droppable:true}}});
n.prototype.oncompositionstart=function(){this._bIsComposingCharacter=true;};
n.prototype.oncompositionend=function(E){this._bIsComposingCharacter=false;this._sComposition=E.target.value;if(!c.browser.edge&&!c.browser.firefox){C.prototype.handleInput.apply(this,arguments);this.handleInputValidation(E,this.isComposingCharacter());}};
n.prototype.isComposingCharacter=function(){return this._bIsComposingCharacter;};
n.prototype.updateItems=function(r){this.bItemsUpdated=false;this.destroyItems();this.updateAggregation("items");this.bItemsUpdated=true;if(this.hasLoadItemsEventListeners()){this.onItemsLoaded();}};
n.prototype.setFilterFunction=function(F){if(F===null||F===undefined){this.fnFilter=null;return this;}if(typeof(F)!=="function"){L.warning("Passed filter is not a function and the default implementation will be used");}else{this.fnFilter=F;}return this;};
n.prototype.highlightList=function(v){var i=[];i=this._getList().$().find('.sapMSLIInfo, .sapMSLITitleOnly');j(i,v);};
n.prototype._modifyPopupInput=function(i){this.setTextFieldHandler(i);return i;};
n.prototype.setTextFieldHandler=function(t){var i=this,T=t._handleEvent;t._handleEvent=function(E){T.apply(this,arguments);if(/keydown|sapdown|sapup|saphome|sapend|sappagedown|sappageup|input/.test(E.type)){i._handleEvent(E);}};};
n.prototype.refreshItems=function(){this.bItemsUpdated=false;this.refreshAggregation("items");};
n.prototype.loadItems=function(i,o){var p=typeof i==="function";if(this.hasLoadItemsEventListeners()&&(this.getItems().length===0)){this._bOnItemsLoadedScheduled=false;if(p){o=q.extend({action:i,busyIndicator:true,busyIndicatorDelay:300},o);this.aMessageQueue.push(o);if((this.iLoadItemsEventInitialProcessingTimeoutID===-1)&&(o.busyIndicator)){this.iLoadItemsEventInitialProcessingTimeoutID=setTimeout(function r(){this.setInternalBusyIndicatorDelay(0);this.setInternalBusyIndicator(true);}.bind(this),o.busyIndicatorDelay);}}if(!this.bProcessingLoadItemsEvent){this.bProcessingLoadItemsEvent=true;this.fireLoadItems();}}else if(p){i.call(this);}};
n.prototype.onItemsLoaded=function(){this.bProcessingLoadItemsEvent=false;clearTimeout(this.iLoadItemsEventInitialProcessingTimeoutID);if(this.bInitialBusyIndicatorState!==this.getBusy()){this.setInternalBusyIndicator(this.bInitialBusyIndicatorState);}if(this.iInitialBusyIndicatorDelay!==this.getBusyIndicatorDelay()){this.setInternalBusyIndicatorDelay(this.iInitialBusyIndicatorDelay);}for(var i=0,o,N,p;i<this.aMessageQueue.length;i++){o=this.aMessageQueue.shift();i--;p=(i+1)===this.aMessageQueue.length;N=p?null:this.aMessageQueue[i+1];if(typeof o.action==="function"){if((o.name==="input")&&!p&&(N.name==="input")){continue;}o.action.call(this);}}};
n.prototype.hasLoadItemsEventListeners=function(){return this.hasListeners("loadItems");};
n.prototype._scheduleOnItemsLoadedOnce=function(){if(!this._bOnItemsLoadedScheduled&&!this.isBound("items")&&this.hasLoadItemsEventListeners()&&this.bProcessingLoadItemsEvent){this._bOnItemsLoadedScheduled=true;setTimeout(this.onItemsLoaded.bind(this),0);}};
n.prototype.getPickerInvisibleTextId=function(){return b.getStaticId("sap.m","COMBOBOX_AVAILABLE_OPTIONS");};
n.prototype._getGroupHeaderInvisibleText=function(){if(!this._oGroupHeaderInvisibleText){this._oGroupHeaderInvisibleText=new b();this._oGroupHeaderInvisibleText.toStatic();}return this._oGroupHeaderInvisibleText;};
n.prototype._getItemByListItem=function(o){return this._getItemBy(o,"ListItem");};
n.prototype._getItemBy=function(o,s){s=this.getRenderer().CSS_CLASS_COMBOBOXBASE+s;for(var i=0,p=this.getItems(),r=p.length;i<r;i++){if(p[i].data(s)===o){return p[i];}}return null;};
n.prototype._isListInSuggestMode=function(){return this._getList().getItems().some(function(o){return!o.getVisible()&&this._getItemByListItem(o).getEnabled();},this);};
n.prototype.getListItem=function(i){return i?i.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"ListItem"):null;};
n.prototype.getSelectable=function(i){return i._bSelectable;};
n.prototype._setItemsShownWithFilter=function(v){this._bItemsShownWithFilter=v;};
n.prototype._getItemsShownWithFilter=function(){return this._bItemsShownWithFilter;};
n.prototype.init=function(){C.prototype.init.apply(this,arguments);this.setPickerType(c.system.phone?"Dialog":"Dropdown");this._setItemsShownWithFilter(false);this.bItemsUpdated=false;this.bOpenedByKeyboardOrButton=false;this._bShouldClosePicker=false;this._oPickerValueStateText=null;this.bProcessingLoadItemsEvent=false;this.iLoadItemsEventInitialProcessingTimeoutID=-1;this.aMessageQueue=[];this.bInitialBusyIndicatorState=this.getBusy();this.iInitialBusyIndicatorDelay=this.getBusyIndicatorDelay();this._bOnItemsLoadedScheduled=false;this._bDoTypeAhead=true;this.getIcon().addEventDelegate({onmousedown:function(E){this._bShouldClosePicker=this.isOpen();}},this);this.getIcon().attachPress(this._handlePopupOpenAndItemsLoad.bind(this,true));this._sComposition="";this.fnFilter=null;};
n.prototype.onBeforeRendering=function(){var s=this.getOpen(),v=s?this._getSuggestionsPopover()._getValueStateHeader().getText():null,V=s?this._getSuggestionsPopover()._getValueStateHeader().getValueState():null;C.prototype.onBeforeRendering.apply(this,arguments);if(s&&((this.getValueStateText()&&v!==this.getValueStateText())||(this.getValueState()!==V)||this.getFormattedValueStateText())){this._updateSuggestionsPopoverValueState();}};
n.prototype._handlePopupOpenAndItemsLoad=function(o){var p;if(!this.getEnabled()||!this.getEditable()){return;}if(o&&this._getItemsShownWithFilter()){this._bShouldClosePicker=false;this.toggleIconPressedStyle(true);this.bOpenedByKeyboardOrButton=false;this.clearFilter();this._setItemsShownWithFilter(false);return;}if(this._bShouldClosePicker){this._bShouldClosePicker=false;this.close();return;}this.loadItems();this.bOpenedByKeyboardOrButton=o;if(this.isPlatformTablet()){this.syncPickerContent();p=this.getPicker();p.setInitialFocus(p);}this.open();};
n.prototype.exit=function(){C.prototype.exit.apply(this,arguments);if(this._getList()){this._getList().destroy();this._oList=null;}if(this._getGroupHeaderInvisibleText()){this._getGroupHeaderInvisibleText().destroy();this._oGroupHeaderInvisibleText=null;}clearTimeout(this.iLoadItemsEventInitialProcessingTimeoutID);this.aMessageQueue=null;this.fnFilter=null;};
n.prototype.onsapshow=function(E){if(!this.getEnabled()||!this.getEditable()){return;}E.setMarked();if(E.keyCode===K.F4){this.onF4(E);}if(this._getItemsShownWithFilter()){this.loadItems(this._handlePopupOpenAndItemsLoad.bind(this,true));return;}if(this.isOpen()){this.close();return;}this.selectText(0,this.getValue().length);this.loadItems();this.bOpenedByKeyboardOrButton=true;this.open();};
n.prototype.onF4=function(E){E.preventDefault();};
n.prototype.onsapescape=function(E){if(this.getEnabled()&&this.getEditable()&&this.isOpen()){E.setMarked();E.preventDefault();this.close();}else{C.prototype.onsapescape.apply(this,arguments);}};
n.prototype.onsaphide=n.prototype.onsapshow;
n.prototype.onsapfocusleave=function(E){if(!E.relatedControlId){C.prototype.onsapfocusleave.apply(this,arguments);return;}var r=sap.ui.getCore().byId(E.relatedControlId);if(r===this){return;}var p=this.getPicker(),F=r&&r.getFocusDomRef();if(p&&f(p.getFocusDomRef(),F)){return;}C.prototype.onsapfocusleave.apply(this,arguments);};
n.prototype.getPopupAnchorDomRef=function(){return this.getDomRef();};
n.prototype.addContent=function(p){};
n.prototype.getList=function(){L.warning("[Warning]:","You are attempting to use deprecated method 'getList()', please refer to SAP note 2746748.",this);return this._getList();};
n.prototype._getList=function(){if(this.bIsDestroyed){return null;}return this._oList;};
n.prototype.setPickerType=function(p){this._sPickerType=p;};
n.prototype.getPickerType=function(){return this._sPickerType;};
n.prototype._updateSuggestionsPopoverValueState=function(){var s=this._getSuggestionsPopover();if(!s){return;}var v=this.getValueState(),N=this.getValueState()!==s._getValueStateHeader().getValueState(),o=this.getFormattedValueStateText(),V=this.getValueStateText(),i=o||N;if(s.isOpen()&&!i){this.setFormattedValueStateText(s._getValueStateHeader().getFormattedText());}s.updateValueState(v,(o||V),this.getShowValueStateMessage());};
n.prototype.shouldValueStateMessageBeOpened=function(){var s=C.prototype.shouldValueStateMessageBeOpened.apply(this,arguments);return(s&&!this.isOpen());};
n.prototype.onPropertyChange=function(o,i){var N=o.getParameter("newValue"),p=o.getParameter("name"),M="set"+p.charAt(0).toUpperCase()+p.slice(1),r=(i&&i.srcControl)||this.getPickerTextField();if(this.getInputForwardableProperties().indexOf(p)>-1&&r&&(typeof r[M]==="function")){r[M](N);}};
n.prototype.getInputForwardableProperties=function(){return m;};
n.prototype.isPickerDialog=function(){return this.getPickerType()==="Dialog";};
n.prototype.isPlatformTablet=function(){var N=!c.system.combi,t=c.system.tablet&&N;return t;};
n.prototype.createPickerTextField=function(){var i=new I({width:"100%",showValueStateMessage:false});return i;};
n.prototype.getDropdownSettings=function(){return{showArrow:false,placement:P.VerticalPreferredBottom,offsetX:0,offsetY:0,bounce:false,ariaLabelledBy:this.getPickerInvisibleTextId()||undefined};};
n.prototype._configureList=function(){};
n.prototype.createPicker=function(p){var o=this.getAggregation("picker");if(o){return o;}this._oSuggestionPopover=this._createSuggestionsPopover();o=this._oSuggestionPopover._oPopover;this.setAggregation("picker",o,true);this.configPicker(o);return o;};
n.prototype.configPicker=function(p){};
n.prototype._hasShowSelectedButton=function(){return false;};
n.prototype._createSuggestionsPopover=function(){var u=this.isPickerDialog(),s;s=new S(this);if(u){var i=this.createPickerTextField();s._oPopupInput=this._modifyPopupInput(i);}s._createSuggestionPopup({showSelectedButton:this._hasShowSelectedButton()});s._createSuggestionPopupContent(false);this.forwardEventHandlersToSuggPopover(s);this._oList=s._oList;this._configureList(this._oList);return s;};
n.prototype.forwardEventHandlersToSuggPopover=function(s){s.setOkPressHandler(this._handleOkPress.bind(this));s.setCancelPressHandler(this._handleCancelPress.bind(this));s.setInputLabels(this.getLabels.bind(this));};
n.prototype._handleOkPress=function(){var t=this,T=t.getPickerTextField();t.updateDomValue(T.getValue());t.onChange();t.close();};
n.prototype._handleCancelPress=function(){this.close();this.revertSelection();};
n.prototype.setSelectable=function(i,s){if(this.indexOfItem(i)<0){return;}i._bSelectable=s;var o=this.getListItem(i);if(o){o.setVisible(s);}};
n.prototype.onBeforeOpen=function(){this._updateSuggestionsPopoverValueState();if(!this._getItemsShownWithFilter()){this.toggleIconPressedStyle(true);}};
n.prototype.onBeforeClose=function(){this.bOpenedByKeyboardOrButton=false;this._setItemsShownWithFilter(false);this._updateSuggestionsPopoverValueState();};
n.prototype.getPicker=function(){var p=this.getAggregation("picker");if(p&&!p.bIsDestroyed&&!this.bIsDestroyed){return p;}return null;};
n.prototype._getSuggestionsPopover=function(){return this._oSuggestionPopover;};
n.prototype.getValueStateLinks=function(){var H=this.getPicker()&&this.getPicker().getCustomHeader()&&typeof this.getPicker().getCustomHeader().getFormattedText==="function",F=H&&this.getPicker().getCustomHeader().getFormattedText(),v=F&&F.getControls();return v||[];};
n.prototype.getPickerTextField=function(){var p=this.getPicker(),s=p&&p.getSubHeader();return s&&s.getContent()[0]||null;};
n.prototype.getPickerTitle=function(){var p=this.getPicker(),H=p&&p.getCustomHeader();if(this.isPickerDialog()&&H){return H.getContentMiddle()[0];}return null;};
n.prototype.revertSelection=function(){};
n.prototype.hasContent=function(){return this.getItems().length>0;};
n.prototype.syncPickerContent=function(){};
n.prototype.findFirstEnabledItem=function(o){o=o||this.getItems();for(var i=0;i<o.length;i++){if(o[i].getEnabled()){return o[i];}}return null;};
n.prototype.findLastEnabledItem=function(i){i=i||this.getItems();return this.findFirstEnabledItem(i.reverse());};
n.prototype.open=function(){var p=this.getPicker();if(p){p.open();}return this;};
n.prototype.getVisibleItems=function(){for(var i=0,o,p=this.getItems(),v=[];i<p.length;i++){o=this.getListItem(p[i]);if(o&&o.getVisible()){v.push(p[i]);}}return v;};
n.prototype.isItemSelected=function(){};
n.prototype.getKeys=function(o){o=o||this.getItems();for(var i=0,p=[];i<o.length;i++){p[i]=o[i].getKey();}return p;};
n.prototype.getSelectableItems=function(){return this.getEnabledItems(this.getVisibleItems());};
n.prototype.findItem=function(p,v){var M="get"+p.charAt(0).toUpperCase()+p.slice(1);for(var i=0,o=this.getItems();i<o.length;i++){if(o[i][M]()===v){return o[i];}}return null;};
n.prototype.getItemByText=function(t){return this.findItem("text",t);};
n.prototype.clearFilter=function(){this.getItems().forEach(function(i){var o=this.getListItem(i);if(o){o.setVisible(i.getEnabled()&&this.getSelectable(i));}},this);};
n.prototype.onItemChange=function(o){};
n.prototype.clearSelection=function(){};
n.prototype.setInternalBusyIndicator=function(B){this.bInitialBusyIndicatorState=this.getBusy();return this.setBusy.apply(this,arguments);};
n.prototype.setInternalBusyIndicatorDelay=function(i){this.iInitialBusyIndicatorDelay=this.getBusyIndicatorDelay();return this.setBusyIndicatorDelay.apply(this,arguments);};
n.prototype.addItem=function(i){this.addAggregation("items",i);if(i){i.attachEvent("_change",this.onItemChange,this);}if(this._getList()){this._getList().addItem(this._mapItemToListItem(i));}return this;};
n.prototype.insertItem=function(i,o){this.insertAggregation("items",i,o,true);if(i){i.attachEvent("_change",this.onItemChange,this);}if(this._getList()){this._getList().insertItem(this._mapItemToListItem(i),o);}this._scheduleOnItemsLoadedOnce();return this;};
n.prototype.getItemAt=function(i){return this.getItems()[+i]||null;};
n.prototype.getFirstItem=function(){return this.getItems()[0]||null;};
n.prototype.getLastItem=function(){var i=this.getItems();return i[i.length-1]||null;};
n.prototype.getEnabledItems=function(i){i=i||this.getItems();return i.filter(function(o){return o.getEnabled();});};
n.prototype.getItemByKey=function(s){return this.findItem("key",s);};
n.prototype.addItemGroup=function(o,H,s){H=H||new a({text:o.text||o.key});this.addAggregation("items",H,s);if(this._getList()&&H.isA("sap.ui.core.SeparatorItem")){this._getList().addItem(this._mapItemToListItem(H));}return H;};
n.prototype._mapSeparatorItemToGroupHeader=function(s){var o=new G({title:s.getText(),ariaLabelledBy:this._getGroupHeaderInvisibleText().getId(),type:k.Inactive});o.addStyleClass(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"NonInteractiveItem");return o;};
n.prototype.isOpen=function(){var p=this.getPicker();return!!(p&&p.isOpen());};
n.prototype.close=function(){var p=this.getPicker();if(p){p.close();}return this;};
n.prototype.removeItem=function(i){i=this.removeAggregation("items",i);if(i){i.detachEvent("_change",this.onItemChange,this);}return i;};
n.prototype.removeAllItems=function(){var o=this.removeAllAggregation("items");this.clearSelection();for(var i=0;i<o.length;i++){o[i].detachEvent("_change",this.onItemChange,this);}return o;};
n.prototype.intersectItems=function(i,o){return i.filter(function(p){return o.map(function(O){return O.getId();}).indexOf(p.getId())!==-1;});};
n.prototype.showItems=function(F){var i=this.fnFilter,o=function(){if(!this.getItems().length){return;}this.detachLoadItems(o);this.setFilterFunction(F||function(){return true;});this.applyShowItemsFilters();this._handlePopupOpenAndItemsLoad(false);this.setFilterFunction(i);}.bind(this);if(!this.getEnabled()||!this.getEditable()){return;}this._setItemsShownWithFilter(true);this.attachLoadItems(o);this.loadItems(o);};
n.prototype.applyShowItemsFilters=function(){};
return n;});
sap.ui.predefine('sap/m/ComboBoxBaseRenderer',['./ComboBoxTextFieldRenderer','sap/ui/core/Renderer','sap/ui/core/Core'],function(C,R,a){"use strict";var b=R.extend(C);b.apiVersion=2;b.CSS_CLASS_COMBOBOXBASE="sapMComboBoxBase";
b.getAccessibilityState=function(c){var A=C.getAccessibilityState.call(this,c),l=c._getList();if(l){A.controls=l.getId();}return A;};
b.addOuterClasses=function(r,c){C.addOuterClasses.apply(this,arguments);var d=b.CSS_CLASS_COMBOBOXBASE;r.class(d);if(!c.getEnabled()){r.class(d+"Disabled");}if(!c.getEditable()){r.class(d+"Readonly");}};
b.addButtonClasses=function(r,c){C.addButtonClasses.apply(this,arguments);r.class(b.CSS_CLASS_COMBOBOXBASE+"Arrow");};
return b;},true);
sap.ui.predefine('sap/m/ComboBoxRenderer',['./ComboBoxBaseRenderer','sap/ui/core/Renderer','sap/ui/Device'],function(C,R){"use strict";var a=R.extend(C);a.apiVersion=2;a.CSS_CLASS_COMBOBOX="sapMComboBox";
a.addOuterClasses=function(r,c){C.addOuterClasses.apply(this,arguments);r.class(a.CSS_CLASS_COMBOBOX);};
a.addInnerClasses=function(r,c){C.addInnerClasses.apply(this,arguments);r.class(a.CSS_CLASS_COMBOBOX+"Inner");};
a.addButtonClasses=function(r,c){C.addButtonClasses.apply(this,arguments);r.class(a.CSS_CLASS_COMBOBOX+"Arrow");};
a.addPlaceholderClasses=function(r,c){C.addPlaceholderClasses.apply(this,arguments);r.class(a.CSS_CLASS_COMBOBOX+"Placeholder");};
a.writeInnerAttributes=function(r,c){var s=c.getSelectedItem(),S=s&&c.getListItem(s),o=c.isOpen(),f=c.getProperty("formattedTextFocused");C.writeInnerAttributes.apply(this,arguments);r.attr("aria-expanded",o);if(f){r.attr("aria-activedescendant",c._getFormattedValueStateText().getId());}else if(o&&S&&S.hasStyleClass("sapMLIBFocused")&&c.getFocusDomRef()===document.activeElement){r.attr("aria-activedescendant",S.getId());}};
return a;},true);
sap.ui.predefine('sap/m/ComboBoxTextField',['./InputBase','./library','sap/ui/core/InvisibleText','sap/ui/core/library','sap/ui/Device','sap/ui/core/LabelEnablement',"./ComboBoxTextFieldRenderer"],function(I,l,a,c,D,L,C){"use strict";
var b=I.extend("sap.m.ComboBoxTextField",{metadata:{library:"sap.m",properties:{maxWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},showButton:{type:"boolean",group:"Appearance",defaultValue:true}}}});
var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");
b.prototype.init=function(){I.prototype.init.apply(this,arguments);this.addEndIcon({id:this.getId()+"-arrow",src:"sap-icon://slim-arrow-down",noTabStop:true,alt:r.getText("COMBOBOX_BUTTON"),decorative:false});};
b.prototype.getIcon=function(){return this.getAggregation("_endIcon")[0];};
b.prototype.toggleIconPressedStyle=function(s){this.toggleStyleClass(I.ICON_PRESSED_CSS_CLASS,s);};
b.prototype.onBeforeRendering=function(){I.prototype.onBeforeRendering.apply(this,arguments);var R=L.getReferencingLabels(this)||[],i=this.getIcon();i.setVisible(this.getShowButton());R.forEach(function(s){if(i.getAriaLabelledBy().indexOf(s)===-1){i.addAssociation("ariaLabelledBy",s,true);}},this);if(!this.oInvisibleText&&D.browser.msie){this.oInvisibleText=new a(this.getId()+'-describedby',{text:r.getText("ACC_CTR_TYPE_COMBO")}).toStatic();}};
b.prototype.getOpenArea=function(){var d=this.getIcon().getDomRef();return d?d.parentNode:d;};
b.prototype.onsapenter=function(e){I.prototype.onsapenter.apply(this,arguments);if(!this.getEnabled()||!this.getEditable()){return;}this._bCheckDomValue&&e.setMarked();var v=this.getValue(),V=v.length;this.setValue(v);this.selectText(V,V);};
b.prototype.getValue=function(){var d=this.getFocusDomRef();if(d){return d.value;}return this.getProperty("value");};
b.prototype.getDomRefForValueStateMessage=function(){return this.getDomRef();};
b.prototype.getAccessibilityInfo=function(){var i=I.prototype.getAccessibilityInfo.apply(this,arguments);i.type=r.getText("ACC_CTR_TYPE_COMBO");return i;};
b.prototype.exit=function(){I.prototype.exit.apply(this,arguments);if(this.oInvisibleText){this.oInvisibleText.destroy();this.oInvisibleText=null;}};
return b;});
sap.ui.predefine('sap/m/ComboBoxTextFieldRenderer',['./InputBaseRenderer','sap/ui/core/Renderer','sap/ui/core/LabelEnablement','sap/ui/Device'],function(I,R,L,D){"use strict";var C=R.extend(I);C.apiVersion=2;C.CSS_CLASS_COMBOBOXTEXTFIELD="sapMComboBoxTextField";
C.writeInnerAttributes=function(r,c){r.attr("role","combobox");r.attr("aria-haspopup","listbox");r.attr("aria-autocomplete","both");r.attr("aria-expanded","false");r.attr("autocomplete","off");r.attr("autocorrect","off");r.attr("autocapitalize","off");r.attr("type","text");};
C.getAriaRole=function(){};
C.getAriaDescribedBy=function(c){var a=I.getAriaDescribedBy.apply(this,arguments);if(D.browser.msie){return(a||"")+" "+c.oInvisibleText.getId();}return a;};
C.addOuterStyles=function(r,c){r.style("max-width",c.getMaxWidth());};
return C;},true);
sap.ui.predefine('sap/m/CustomListItem',['./ListItemBase','./library','./CustomListItemRenderer'],function(L,l,C){"use strict";
var a=L.extend("sap.m.CustomListItem",{metadata:{library:"sap.m",defaultAggregation:"content",properties:{accDescription:{tpye:"string",group:"Behavior"}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",bindable:"bindable"}},designtime:"sap/m/designtime/CustomListItem.designtime"}});
a.prototype.setAccDescription=function(A){this.setProperty("accDescription",A,true);return this;};
a.prototype.getContentAnnouncement=function(){var A=this.getAccDescription();if(A){return A;}return this.getContent().map(function(c){return L.getAccessibilityText(c);}).join(" ").trim();};
return a;});
sap.ui.predefine('sap/m/CustomListItemRenderer',["./ListItemBaseRenderer","sap/ui/core/Renderer"],function(L,R){"use strict";var C=R.extend(L);C.apiVersion=2;
C.renderLIAttributes=function(r,l){r.class("sapMCLI");};
C.renderLIContent=function(r,l){l.getContent().forEach(r.renderControl,r);};
return C;},true);
sap.ui.predefine('sap/m/CustomTile',['./Tile','./library','./CustomTileRenderer'],function(T,l,C){"use strict";
var a=T.extend("sap.m.CustomTile",{metadata:{library:"sap.m",designtime:"sap/m/designtime/CustomTile.designtime",defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:false}}}});
return a;});
sap.ui.predefine('sap/m/CustomTileRenderer',['./TileRenderer','sap/ui/core/Renderer'],function(T,R){"use strict";var C=R.extend(T);
C.render=function(r,c){var t,v;r.write("<div tabindex=\"0\"");r.writeControlData(c);r.addClass("sapMCustomTile");r.writeClasses();if(c._invisible){r.addStyle("visibility","hidden");r.writeStyles();}if(c.getParent()instanceof sap.m.TileContainer){t=c.getParent();v=t._getVisibleTiles();r.writeAccessibilityState(c,{role:"option",posinset:t._indexOfVisibleTile(c,v)+1,setsize:v.length});}r.write(">");r.write("<div id=\""+c.getId()+"-remove\" class=\"sapMTCRemove\"></div>");r.write("<div class=\"sapMCustomTileContent\">");this._renderContent(r,c);r.write("</div></div>");};
C._renderContent=function(r,t){r.renderControl(t.getContent());};
return C;},true);
sap.ui.predefine('sap/m/DatePickerRenderer',['sap/ui/core/Renderer','./InputBaseRenderer','sap/ui/core/library'],function(R,I,c){"use strict";var D=R.extend(I);D.apiVersion=2;
D.writeInnerValue=function(r,d){if(d._bValid){r.attr("value",d._formatValue(d.getDateValue()));}else{r.attr("value",d.getValue());}};
D.writeInnerAttributes=function(r,d){r.attr("type","text");if(d._bMobile){r.attr("readonly","readonly");}};
D.getAriaRole=function(d){return"combobox";};
D.getAccessibilityState=function(d){var a=I.getAccessibilityState.apply(this,arguments);a["roledescription"]=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_DATEINPUT");a["autocomplete"]="none";a["haspopup"]=c.aria.HasPopup.Grid.toLowerCase();a["expanded"]=false;a["disabled"]=null;if(d._bMobile&&d.getEnabled()&&d.getEditable()){a["readonly"]=false;}return a;};
return D;},true);
sap.ui.predefine('sap/m/DateRangeSelectionRenderer',['sap/ui/core/Renderer','./DatePickerRenderer'],function(R,D){"use strict";var a=R.extend(D);a.apiVersion=2;
a.writeInnerValue=function(r,c){if(c._bValid){r.attr("value",c._formatValue(c.getDateValue(),c.getSecondDateValue()));}else{r.attr("value",c.getValue());}};
a.getAccessibilityState=function(d){var A=D.getAccessibilityState.apply(this,arguments);A["roledescription"]=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_DATERANGEINPUT");return A;};
return a;},true);
sap.ui.predefine('sap/m/DateTimeField',['sap/ui/model/type/Date','sap/ui/model/odata/type/ODataType','sap/ui/model/odata/type/DateTimeBase','./InputBase','sap/ui/core/LocaleData','sap/ui/core/library','sap/ui/core/format/DateFormat','./DateTimeFieldRenderer',"sap/base/util/deepEqual","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/cursorPos"],function(S,O,D,I,L,c,a,b,d,f,q){"use strict";var C=c.CalendarType;
var g=I.extend("sap.m.DateTimeField",{metadata:{"abstract":true,library:"sap.m",properties:{displayFormat:{type:"string",group:"Appearance",defaultValue:null},valueFormat:{type:"string",group:"Data",defaultValue:null},dateValue:{type:"object",group:"Data",defaultValue:null},initialFocusedDateValue:{type:"object",group:"Data",defaultValue:null}}}});
g.prototype.setValue=function(v){v=this.validateProperty("value",v);var o=this.getValue();if(v===o){return this;}else{this.setLastValue(v);}this.setProperty("value",v);this._bValid=true;var e;if(v){e=this._parseValue(v);if(!e||e.getTime()<this._oMinDate.getTime()||e.getTime()>this._oMaxDate.getTime()){this._bValid=false;f.warning("Value can not be converted to a valid date",this);}}this.setProperty("dateValue",e);if(this.getDomRef()){var s;if(e){s=this._formatValue(e);}else{s=v;}if(this._$input.val()!==s){this._$input.val(s);this._curpos=this._$input.cursorPos();}}return this;};
g.prototype.setDateValue=function(o){if(!this._isValidDate(o)){throw new Error("Date must be a JavaScript date object; "+this);}if(d(this.getDateValue(),o)){return this;}o=this._dateValidation(o);var v=this._formatValue(o,true);if(v!==this.getValue()){this.setLastValue(v);}this.setProperty("value",v);if(this.getDomRef()){var s=this._formatValue(o);if(this._$input.val()!==s){this._$input.val(s);this._curpos=this._$input.cursorPos();}}return this;};
g.prototype.setValueFormat=function(v){this.setProperty("valueFormat",v,true);var V=this.getValue();if(V){this._handleDateValidation(this._parseValue(V));}return this;};
g.prototype.setDisplayFormat=function(s){this.setProperty("displayFormat",s,true);this.updateDomValue(this._formatValue(this.getDateValue()));this._updateDomPlaceholder(this._getPlaceholder());return this;};
g.prototype.getDisplayFormatType=function(){return null;};
g.prototype._dateValidation=function(o){this._bValid=true;this.setProperty("dateValue",o);return o;};
g.prototype._handleDateValidation=function(o){this._bValid=true;this.setProperty("dateValue",o);};
g.prototype._getPlaceholder=function(){var p=this.getPlaceholder();if(!p){p=this._getDisplayFormatPattern();if(!p){p=this._getDefaultDisplayStyle();}if(this._checkStyle(p)){p=this._getLocaleBasedPattern(p);}}return p;};
g.prototype._getLocaleBasedPattern=function(p){return L.getInstance(sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale()).getDatePattern(p);};
g.prototype._parseValue=function(v,h){var B=this.getBinding("value"),o=B&&B.getType&&B.getType(),F,i,j;if(o&&this._isSupportedBindingType(o)){try{j=o.parseValue(v,"string");if(typeof(j)==="string"&&o instanceof D){j=D.prototype.parseValue.call(o,v,"string");}F=o.oFormatOptions;if(F&&F.source&&F.source.pattern=="timestamp"){j=new Date(j);}else if(F&&F.source&&typeof F.source.pattern==="string"){j=o.oInputFormat.parse(v);}}catch(e){}if(j&&((o.oFormatOptions&&this._isFormatOptionsUTC(o.oFormatOptions))||(o.oConstraints&&o.oConstraints.isDateOnly))){i=new Date(j.getUTCFullYear(),j.getUTCMonth(),j.getUTCDate(),j.getUTCHours(),j.getUTCMinutes(),j.getUTCSeconds(),j.getUTCMilliseconds());i.setFullYear(j.getUTCFullYear());j=i;}return j;}return this._getFormatter(h).parse(v);};
g.prototype._formatValue=function(o,v){if(!o){return"";}var B=this.getBinding("value"),e=B&&B.getType&&B.getType(),F,h;if(e&&this._isSupportedBindingType(e)){if((e.oFormatOptions&&e.oFormatOptions.UTC)||(e.oConstraints&&e.oConstraints.isDateOnly)){h=new Date(Date.UTC(o.getFullYear(),o.getMonth(),o.getDate(),o.getHours(),o.getMinutes(),o.getSeconds(),o.getMilliseconds()));h.setUTCFullYear(o.getFullYear());o=h;}F=e.oFormatOptions;if(F&&F.source&&F.source.pattern=="timestamp"){o=o.getTime();}else if(e.oOutputFormat){return e.oOutputFormat.format(o);}return e.formatValue(o,"string");}return this._getFormatter(!v).format(o);};
g.prototype._isSupportedBindingType=function(B){return B.isA(["sap.ui.model.type.Date","sap.ui.model.odata.type.DateTime","sap.ui.model.odata.type.DateTimeOffset"]);};
g.prototype._isFormatOptionsUTC=function(B){return(B.UTC||(B.source&&B.source.UTC));};
g.prototype._getDefaultDisplayStyle=function(){return"medium";};
g.prototype._getDefaultValueStyle=function(){return"short";};
g.prototype._getFormatter=function(e){var p=this._getBoundValueTypePattern(),r=false,F,B=this.getBinding("value"),s;if(B&&B.oType&&B.oType.oOutputFormat){r=!!B.oType.oOutputFormat.oFormatOptions.relative;s=B.oType.oOutputFormat.oFormatOptions.calendarType;}if(!p){if(e){p=(this.getDisplayFormat()||this._getDefaultDisplayStyle());s=this.getDisplayFormatType();}else{p=(this.getValueFormat()||this._getDefaultValueStyle());s=C.Gregorian;}}if(!s){s=sap.ui.getCore().getConfiguration().getCalendarType();}if(e){if(p===this._sUsedDisplayPattern&&s===this._sUsedDisplayCalendarType){F=this._oDisplayFormat;}}else{if(p===this._sUsedValuePattern&&s===this._sUsedValueCalendarType){F=this._oValueFormat;}}if(F){return F;}return this._getFormatterInstance(F,p,r,s,e);};
g.prototype._getFormatterInstance=function(F,p,r,s,e){if(this._checkStyle(p)){F=this._getFormatInstance({style:p,strictParsing:true,relative:r,calendarType:s},e);}else{F=this._getFormatInstance({pattern:p,strictParsing:true,relative:r,calendarType:s},e);}if(e){this._sUsedDisplayPattern=p;this._sUsedDisplayCalendarType=s;this._oDisplayFormat=F;}else{this._sUsedValuePattern=p;this._sUsedValueCalendarType=s;this._oValueFormat=F;}return F;};
g.prototype._getFormatInstance=function(A,e){return a.getInstance(A);};
g.prototype._checkStyle=function(p){return(p==="short"||p==="medium"||p==="long"||p==="full");};
g.prototype._getDisplayFormatPattern=function(){var p=this._getBoundValueTypePattern();if(p){return p;}p=this.getDisplayFormat();if(this._checkStyle(p)){p=this._getLocaleBasedPattern(p);}return p;};
g.prototype._getBoundValueTypePattern=function(){var B=this.getBinding("value"),o=B&&B.getType&&B.getType();if(o instanceof S){return o.getOutputPattern();}if(o instanceof O&&o.oFormat){return o.oFormat.oFormatOptions.pattern;}return undefined;};
g.prototype._isValidDate=function(o){return!o||Object.prototype.toString.call(o)==="[object Date]";};
g.prototype._updateDomPlaceholder=function(v){if(this.getDomRef()){this._$input.attr("placeholder",v);}};
return g;});
sap.ui.predefine('sap/m/DateTimeFieldRenderer',['sap/ui/core/Renderer','./InputBaseRenderer'],function(R,I){"use strict";var D=R.extend(I);D.apiVersion=2;return D;},true);
sap.ui.predefine('sap/m/DateTimeInput',["sap/ui/thirdparty/jquery",'sap/ui/core/Control','./library','./DatePicker','./DateTimePicker','./TimePicker','sap/ui/model/type/Date','sap/ui/model/type/Time','sap/ui/model/type/DateTime','sap/ui/model/odata/type/ODataType','sap/ui/core/library','sap/ui/Device',"./DateTimeInputRenderer"],function(q,C,l,D,a,T,b,c,d,O,e,f,g){"use strict";var h=l.DateTimeInputType;var j=e.TextDirection;var k=e.TextAlign;var V=e.ValueState;
var m=C.extend("sap.m.DateTimeInput",{metadata:{library:"sap.m",designtime:"sap/m/designtime/DateTimeInput.designtime",properties:{value:{type:"string",group:"Data",defaultValue:null,bindable:"bindable"},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},enabled:{type:"boolean",group:"Behavior",defaultValue:true},editable:{type:"boolean",group:"Behavior",defaultValue:true},valueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:V.None},valueStateText:{type:"string",group:"Misc",defaultValue:null},showValueStateMessage:{type:"boolean",group:"Misc",defaultValue:true},name:{type:"string",group:"Misc",defaultValue:null},placeholder:{type:"string",group:"Misc",defaultValue:null},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:k.Initial},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:j.Inherit},type:{type:"sap.m.DateTimeInputType",group:"Data",defaultValue:h.Date},displayFormat:{type:"string",group:"Appearance",defaultValue:null},valueFormat:{type:"string",group:"Data",defaultValue:null},dateValue:{type:"object",group:"Data",defaultValue:null}},aggregations:{_picker:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{change:{parameters:{value:{type:"string"},dateValue:{type:"object"},valid:{type:"boolean"}}}}}});
!(function(P,$,i){var r=l.getLocaleData();q.extend(P,{_types:{Date:{valueFormat:r.getDatePattern("short"),displayFormat:r.getDatePattern("medium")},Time:{valueFormat:r.getTimePattern("short"),displayFormat:r.getTimePattern("short")},DateTime:{valueFormat:r.getDateTimePattern("short"),displayFormat:r.getDateTimePattern("short")}}});["Time","Date"].forEach(function(t,s){["valueFormat","displayFormat"].forEach(function(F){var u=P._types;u.DateTime[F]=u.DateTime[F].replace("{"+s+"}",u[t][F]);});});}(m.prototype,q,f));
m.prototype.init=function(){this.setType(h.Date);};
m.prototype.onBeforeRendering=function(){o.call(this);};
m.prototype.getFocusDomRef=function(){var P=_.call(this);return P.getFocusDomRef();};
m.prototype.getIdForLabel=function(){var P=_.call(this);return P.getIdForLabel();};
function n(t){var P;switch(t){case h.DateTime:P=new a(this.getId()+"-Picker");break;case h.Time:P=new T(this.getId()+"-Picker",{localeId:sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString()});break;default:P=new D(this.getId()+"-Picker");break;}P.setDisplayFormat(this.getDisplayFormat()||this._types[t].displayFormat);P.setValueFormat(this.getValueFormat()||this._types[t].valueFormat);if(this.getDateValue()){P.setDateValue(this.getDateValue());}P.setEnabled(this.getEnabled());P.setEditable(this.getEditable());P.setValueState(this.getValueState());P.setValueStateText(this.getValueStateText());P.setShowValueStateMessage(this.getShowValueStateMessage());P.setName(this.getName());P.setPlaceholder(this.getPlaceholder());P.setTextAlign(this.getTextAlign());P.setTextDirection(this.getTextDirection());P.setWidth("100%");P.attachChange(p,this);var A=this.getAriaLabelledBy();for(var i=0;i<A.length;i++){P.addAriaLabelledBy(A[i]);}return P;}
m.prototype.setType=function(t){if(t==this.getType()&&_.call(this)){return this;}this.destroyAggregation("_picker");var P=n.call(this,t);this.setAggregation("_picker",P);this.setProperty("type",t);return this;};
m.prototype.setWidth=function(w){this.setProperty("width",w);if(this.getDomRef()){w=this.getWidth();this.$().css("width",w);}return this;};
m.prototype.setValue=function(v){o.call(this);v=this.validateProperty("value",v);if(v.toLowerCase()=="now"){return this.setDateValue(new Date());}if(v===this.getValue()){return this;}this.setProperty("value",v,true);var P=_.call(this);P.setValue(v);var i=P.getDateValue();this.setProperty("dateValue",i,true);return this;};
m.prototype.setDateValue=function(i){if(!this._isValidDate(i)){throw new Error("Date must be a JavaScript date object; "+this);}o.call(this);this.setProperty("dateValue",i,true);var P=_.call(this);P.setDateValue(i);var v=P.getValue();this.setProperty("value",v,true);return this;};
m.prototype.setDisplayFormat=function(s){this.setProperty("displayFormat",s,true);var P=_.call(this);P.setDisplayFormat(s||this._types[this.getType()].displayFormat);return this;};
m.prototype.setValueFormat=function(v){this.setProperty("valueFormat",v,true);var P=_.call(this);P.setValueFormat(v||this._types[this.getType()].ValueFormat);return this;};
m.prototype.setEnabled=function(E){this.setProperty("enabled",E,true);var P=_.call(this);P.setEnabled(E);return this;};
m.prototype.setEditable=function(E){this.setProperty("editable",E,true);var P=_.call(this);P.setEditable(E);return this;};
m.prototype.setValueState=function(v){this.setProperty("valueState",v,true);var P=_.call(this);P.setValueState(v);return this;};
m.prototype.setValueStateText=function(v){this.setProperty("valueStateText",v,true);var P=_.call(this);P.setValueStateText(v);return this;};
m.prototype.setShowValueStateMessage=function(s){this.setProperty("showValueStateMessage",s,true);var P=_.call(this);P.setShowValueStateMessage(s);return this;};
m.prototype.setName=function(N){this.setProperty("name",N,true);var P=_.call(this);P.setName(N);return this;};
m.prototype.setPlaceholder=function(P){this.setProperty("placeholder",P,true);var i=_.call(this);i.setPlaceholder(P);return this;};
m.prototype.setTextAlign=function(t){this.setProperty("textAlign",t,true);var P=_.call(this);P.setTextAlign(t);return this;};
m.prototype.setTextDirection=function(t){this.setProperty("textDirection",t,true);var P=_.call(this);P.setTextDirection(t);return this;};
m.prototype.addAriaLabelledBy=function(i){this.addAssociation("ariaLabelledBy",i,true);var P=_.call(this);P.addAriaLabelledBy(i);return this;};
m.prototype.removeAriaLabelledBy=function(i){this.removeAssociation("ariaLabelledBy",i,true);var P=_.call(this);P.removeAriaLabelledBy(i);return this;};
m.prototype.removeAllAriaLabelledBy=function(){this.removeAssociation("ariaLabelledBy",true);var P=_.call(this);P.removeAllAriaLabelledBy();return this;};
m.prototype.getAccessibilityInfo=function(){var P=_.call(this);return P&&P.getAccessibilityInfo?P.getAccessibilityInfo():null;};
m.prototype._getPickerByTypeAndPattern=function(t,i,r){var R=/[DdYyMLWwGQUur]/,s=/[HhKkmsa]/,u=s.test(r),v=R.test(r),w=u&&!v,x=v&&!u,y=v&&u,N,z;switch(t){case h.Time:case h.Date:case h.DateTime:if(w&&i.getMetadata().getName()!=="sap.m.TimePicker"){N=h.Time;}else if(x&&i.getMetadata().getName()!=="sap.m.DatePicker"){N=h.Date;}else if(y&&i.getMetadata().getName()!=="sap.m.DateTimePicker"){N=h.DateTime;}break;default:{throw"Invalid type: "+t+". Expected is one of the sap.m.DateTimeInputType";}}if(N){this.destroyAggregation("_picker");z=n.call(this,N);this.setAggregation("_picker",z);}return z||i;};
m.prototype._getBoundValueTypePattern=function(){var B=this.getBinding("value"),i=B&&B.getType()&&B.getType();if(i instanceof b||i instanceof c||i instanceof d){return i.getOutputPattern();}if(i instanceof O&&i.oFormat){return i.oFormat.oFormatOptions.pattern;}return undefined;};
function _(){return this.getAggregation("_picker");}
m.prototype._isValidDate=function(i){return!i||Object.prototype.toString.call(i)==="[object Date]";};
function o(){if(this._getBoundValueTypePattern()){var P=this._getBoundValueTypePattern();var i=_.call(this);i=this._getPickerByTypeAndPattern(this.getType(),i,P);if(i.getValueFormat()!=P){i.setValueFormat(P);}if(i.getDisplayFormat()!=P){i.setDisplayFormat(P);}}}
function p(E){var v=E.getParameter("value");var i;var r=E.getParameter("valid");this.setProperty("value",v,true);if(r){i=E.oSource.getDateValue();this.setProperty("dateValue",i,true);}this.fireChange({value:v,newValue:v,valid:r,dateValue:i,newDateValue:i});}
return m;});
sap.ui.predefine('sap/m/DateTimeInputRenderer',[],function(){"use strict";var D={};
D.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapMDTI");var w=c.getWidth();if(w){r.addStyle("width",w);}r.writeStyles();r.writeClasses();r.write(">");var p=c.getAggregation("_picker");if(p){r.renderControl(p);}r.write("</div>");};
return D;},true);
sap.ui.predefine('sap/m/DateTimePickerRenderer',['sap/ui/core/Renderer','./DatePickerRenderer','./InputBaseRenderer','sap/ui/core/library'],function(R,D,I,c){"use strict";var a=R.extend(D);a.apiVersion=2;
a.getDescribedByAnnouncement=function(d){var b=I.getDescribedByAnnouncement.apply(this,arguments);return sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("DATETIMEPICKER_TYPE")+" "+b;};
a.getAccessibilityState=function(d){var A=D.getAccessibilityState.apply(this,arguments);A["haspopup"]=c.aria.HasPopup.Dialog.toLowerCase();return A;};
return a;},true);
sap.ui.predefine('sap/m/Dialog',["./Bar","./InstanceManager","./AssociativeOverflowToolbar","./ToolbarSpacer","./Title","./library","./TitleAlignmentMixin","sap/m/Image","sap/ui/core/Control","sap/ui/core/IconPool","sap/ui/core/Popup","sap/ui/core/delegate/ScrollEnablement","sap/ui/core/RenderManager","sap/ui/core/InvisibleText","sap/ui/core/ResizeHandler","sap/ui/core/util/ResponsivePaddingsEnablement","sap/ui/Device","sap/ui/core/library","sap/ui/events/KeyCodes","./TitlePropagationSupport","./DialogRenderer","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/core/Core","sap/ui/core/Configuration","sap/ui/dom/jquery/control","sap/ui/dom/jquery/Focusable"],function(B,I,A,T,a,l,b,c,C,d,P,S,R,f,g,h,D,j,K,k,m,L,q,n,o){"use strict";var O=j.OpenState;var p=l.DialogType;var r=l.DialogRoleType;var V=j.ValueState;var s=l.TitleAlignment;var t=n.getConfiguration().getAnimationMode();var u=t!==o.AnimationMode.none&&t!==o.AnimationMode.minimal;var v=u?300:10;var w=17;
var x=C.extend("sap.m.Dialog",{metadata:{interfaces:["sap.ui.core.PopupInterface"],library:"sap.m",properties:{icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},title:{type:"string",group:"Appearance",defaultValue:null},showHeader:{type:"boolean",group:"Appearance",defaultValue:true},type:{type:"sap.m.DialogType",group:"Appearance",defaultValue:p.Standard},state:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:V.None},stretchOnPhone:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},stretch:{type:"boolean",group:"Appearance",defaultValue:false},contentWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},contentHeight:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},horizontalScrolling:{type:"boolean",group:"Behavior",defaultValue:true},verticalScrolling:{type:"boolean",group:"Behavior",defaultValue:true},resizable:{type:"boolean",group:"Behavior",defaultValue:false},draggable:{type:"boolean",group:"Behavior",defaultValue:false},escapeHandler:{type:"any",group:"Behavior",defaultValue:null},role:{type:"sap.m.DialogRoleType",group:"Data",defaultValue:r.Dialog,visibility:"hidden"},closeOnNavigation:{type:"boolean",group:"Behavior",defaultValue:true},titleAlignment:{type:"sap.m.TitleAlignment",group:"Misc",defaultValue:s.Auto}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},subHeader:{type:"sap.m.IBar",multiple:false},customHeader:{type:"sap.m.IBar",multiple:false},beginButton:{type:"sap.m.Button",multiple:false},endButton:{type:"sap.m.Button",multiple:false},buttons:{type:"sap.m.Button",multiple:true,singularName:"button"},_header:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_icon:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_toolbar:{type:"sap.m.OverflowToolbar",multiple:false,visibility:"hidden"},_valueState:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"}},associations:{leftButton:{type:"sap.m.Button",multiple:false,deprecated:true},rightButton:{type:"sap.m.Button",multiple:false,deprecated:true},initialFocus:{type:"sap.ui.core.Control",multiple:false},ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{beforeOpen:{},afterOpen:{},beforeClose:{parameters:{origin:{type:"sap.m.Button"}}},afterClose:{parameters:{origin:{type:"sap.m.Button"}}}},designtime:"sap/m/designtime/Dialog.designtime"}});
h.call(x.prototype,{header:{suffix:"header"},subHeader:{selector:".sapMDialogSubHeader .sapMIBar"},content:{selector:".sapMDialogScrollCont"},footer:{suffix:"footer"}});k.call(x.prototype,"content",function(){return this._headerTitle?this._headerTitle.getId():false;});x._bPaddingByDefault=(n.getConfiguration().getCompatibilityVersion("sapMDialogWithPadding").compareTo("1.16")<0);x._mIcons={};x._mIcons[V.Success]=d.getIconURI("message-success");x._mIcons[V.Warning]=d.getIconURI("message-warning");x._mIcons[V.Error]=d.getIconURI("message-error");x._mIcons[V.Information]=d.getIconURI("hint");
x.prototype.init=function(){var e=this;this._oManuallySetSize=null;this._oManuallySetPosition=null;this._bRTL=n.getConfiguration().getRTL();this._scrollContentList=["sap.m.NavContainer","sap.m.Page","sap.m.ScrollContainer","sap.m.SplitContainer","sap.m.MultiInput","sap.m.SimpleFixFlex"];this.oPopup=new P();this.oPopup.setShadow(true);this.oPopup.setNavigationMode("SCOPE");this.oPopup.setModal(true);this.oPopup.setAnimations(q.proxy(this._openAnimation,this),q.proxy(this._closeAnimation,this));this.oPopup._applyPosition=function(i,F){e._setDimensions();e._adjustScrollingPane();if(e._oManuallySetPosition){i.at={left:e._oManuallySetPosition.x,top:e._oManuallySetPosition.y};}else{i.at=e._calcCenter();}e._deregisterContentResizeHandler();P.prototype._applyPosition.call(this,i);e._registerContentResizeHandler();};if(x._bPaddingByDefault){this.addStyleClass("sapUiPopupWithPadding");}this._initTitlePropagationSupport();this._initResponsivePaddingsEnablement();};
x.prototype.onBeforeRendering=function(){if(this._hasSingleScrollableContent()){this.setVerticalScrolling(false);this.setHorizontalScrolling(false);L.info("VerticalScrolling and horizontalScrolling in sap.m.Dialog with ID "+this.getId()+" has been disabled because there's scrollable content inside");}else if(!this._oScroller){this._oScroller=new S(this,this.getId()+"-scroll",{horizontal:this.getHorizontalScrolling(),vertical:this.getVerticalScrolling()});}if(this._oScroller){this._oScroller.setVertical(this.getVerticalScrolling());this._oScroller.setHorizontal(this.getHorizontalScrolling());}this._createToolbarButtons();if(n.getConfiguration().getAccessibility()&&this.getState()!=V.None){var e=new f({text:this.getValueStateString(this.getState())});this.setAggregation("_valueState",e);this.addAriaLabelledBy(e.getId());}};
x.prototype.onAfterRendering=function(){this._$scrollPane=this.$("scroll");this._$content=this.$("cont");this._$dialog=this.$();if(this.isOpen()){this._setInitialFocus();}};
x.prototype.exit=function(){I.removeDialogInstance(this);this._deregisterContentResizeHandler();this._deregisterResizeHandler();if(this.oPopup){this.oPopup.detachOpened(this._handleOpened,this);this.oPopup.detachClosed(this._handleClosed,this);this.oPopup.destroy();this.oPopup=null;}if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}if(this._header){this._header.destroy();this._header=null;}if(this._headerTitle){this._headerTitle.destroy();this._headerTitle=null;}if(this._iconImage){this._iconImage.destroy();this._iconImage=null;}if(this._toolbarSpacer){this._toolbarSpacer.destroy();this._toolbarSpacer=null;}};
x.prototype.open=function(){var e=this.oPopup;e.setInitialFocusId(this.getId());var i=e.getOpenState();switch(i){case O.OPEN:case O.OPENING:return this;case O.CLOSING:this._bOpenAfterClose=true;break;default:}this._oCloseTrigger=null;this.fireBeforeOpen();e.attachOpened(this._handleOpened,this);this._iLastWidthAndHeightWithScroll=null;e.setContent(this);e.open();this._registerResizeHandler();I.addDialogInstance(this);return this;};
x.prototype.close=function(){this._bOpenAfterClose=false;this.$().removeClass('sapDialogDisableTransition');this._deregisterResizeHandler();var e=this.oPopup;var i=this.oPopup.getOpenState();if(!(i===O.CLOSED||i===O.CLOSING)){l.closeKeyboard();this.fireBeforeClose({origin:this._oCloseTrigger});e.attachClosed(this._handleClosed,this);this._bDisableRepositioning=false;this._oManuallySetPosition=null;this._oManuallySetSize=null;e.close();this._deregisterContentResizeHandler();}return this;};
x.prototype.isOpen=function(){return!!this.oPopup&&this.oPopup.isOpen();};
x.prototype.setIcon=function(i){this._bHasCustomIcon=true;return this.setProperty("icon",i);};
x.prototype.setState=function(e){var i;this.setProperty("state",e);if(this._bHasCustomIcon){return this;}if(e===V.None){i="";}else{i=x._mIcons[e];}this.setProperty("icon",i);return this;};
x.prototype._handleOpened=function(){this.oPopup.detachOpened(this._handleOpened,this);this._setInitialFocus();this.fireAfterOpen();};
x.prototype._handleClosed=function(){if(!this.oPopup){return;}this.oPopup.detachClosed(this._handleClosed,this);if(this.getDomRef()){R.preserveContent(this.getDomRef());this.$().remove();}I.removeDialogInstance(this);this.fireAfterClose({origin:this._oCloseTrigger});if(this._bOpenAfterClose){this._bOpenAfterClose=false;this.open();}};
x.prototype.onfocusin=function(e){var i=e.target;if(i.id===this.getId()+"-firstfe"){var z=this.$("footer").lastFocusableDomRef()||this.$("cont").lastFocusableDomRef()||(this.getSubHeader()&&this.getSubHeader().$().firstFocusableDomRef())||(this._getAnyHeader()&&this._getAnyHeader().$().lastFocusableDomRef());if(z){z.focus();}}else if(i.id===this.getId()+"-lastfe"){var F=(this._getAnyHeader()&&this._getAnyHeader().$().firstFocusableDomRef())||(this.getSubHeader()&&this.getSubHeader().$().firstFocusableDomRef())||this.$("cont").firstFocusableDomRef()||this.$("footer").firstFocusableDomRef();if(F){F.focus();}}};
x.prototype._getPromiseWrapper=function(){var e=this;return{reject:function(){e.currentPromise.reject();},resolve:function(){e.currentPromise.resolve();}};};
x.prototype.onsapescape=function(e){var E=this.getEscapeHandler(),i={},z=this;if(this._isSpaceOrEnterPressed){return;}if(e.originalEvent&&e.originalEvent._sapui_handledByControl){return;}this._oCloseTrigger=null;if(typeof E==='function'){new Promise(function(F,G){i.resolve=F;i.reject=G;z.currentPromise=i;E(z._getPromiseWrapper());}).then(function(F){z.close();}).catch(function(){L.info("Disallow dialog closing");});}else{this.close();}e.stopPropagation();};
x.prototype.onkeyup=function(e){if(this._isSpaceOrEnter(e)){this._isSpaceOrEnterPressed=false;}};
x.prototype.onkeydown=function(e){if(this._isSpaceOrEnter(e)){this._isSpaceOrEnterPressed=true;}};
x.prototype._isSpaceOrEnter=function(e){var i=e.which||e.keyCode;return i==K.SPACE||i==K.ENTER;};
x.prototype._openAnimation=function($,i,e){$.addClass("sapMDialogOpen");$.css("display","block");setTimeout(e,v);};
x.prototype._closeAnimation=function($,i,e){$.removeClass("sapMDialogOpen");setTimeout(e,v);};
x.prototype._setDimensions=function(){var $=this.$(),e=this.getStretch(),i=this.getStretchOnPhone()&&D.system.phone,M=this.getType()===p.Message,z={};if(!e){if(!this._oManuallySetSize){z.width=this.getContentWidth()||undefined;z.height=this.getContentHeight()||undefined;}else{z.width=this._oManuallySetSize.width;z.height=this._oManuallySetSize.height;}}if(z.width=='auto'){z.width=undefined;}if(z.height=='auto'){z.height=undefined;}if((e&&!M)||(i)){this.$().addClass('sapMDialogStretched');}$.css(z);if(!e&&!this._oManuallySetSize&&!this._bDisableRepositioning){this._centerDialog();}if(window.navigator.userAgent.toLowerCase().indexOf("chrome")!==-1&&this.getStretch()){$.find('> footer').css({bottom:'0.001px'});}};
x.prototype._adjustScrollingPane=function(){if(this._oScroller){this._oScroller.refresh();}};
x.prototype._reposition=function(){};
x.prototype._repositionAfterOpen=function(){};
x.prototype._reapplyPosition=function(){this._adjustScrollingPane();};
x.prototype._onResize=function(){var $=this.$(),e=this.$('cont'),i,z=this.getContentHeight(),E=this.getContentWidth(),F,G=Math.floor(window.innerWidth*0.9),H=2,J=D.browser,M=0;if(this._oManuallySetSize){e.css({width:'auto'});return;}if(!z||z=='auto'){i=e.scrollTop();e.css({height:'auto'});$.children().each(function(){M+=q(this).outerHeight(true);});if(this.getStretch()||M>$.innerHeight()){F=parseFloat($.height())+H;e.height(Math.round(F));}e.scrollTop(i);}if(D.system.desktop&&!J.chrome){var N=e.width()+"x"+e.height(),Q=$.css("min-width")!==$.css("width");if(N!==this._iLastWidthAndHeightWithScroll&&Q){if(this._hasVerticalScrollbar()&&(!E||E=='auto')&&!this.getStretch()&&e.width()<G){$.addClass("sapMDialogVerticalScrollIncluded");e.css({"padding-right":w});this._iLastWidthAndHeightWithScroll=N;}else{$.removeClass("sapMDialogVerticalScrollIncluded");e.css({"padding-right":""});this._iLastWidthAndHeightWithScroll=null;}}}if(!this.getStretch()&&!this._oManuallySetSize&&!this._bDisableRepositioning){this._centerDialog();}};
x.prototype._hasVerticalScrollbar=function(){var $=this.$('cont');if(D.browser.msie){return $[0].clientWidth<$.outerWidth();}return $[0].clientHeight<$[0].scrollHeight;};
x.prototype._centerDialog=function(){this.$().css(this._calcCenter());};
x.prototype._calcCenter=function(){var e=window.innerWidth,i=window.innerHeight,$=this.$(),z=$.outerWidth(),E=$.outerHeight();return{left:Math.round((e-z)/2),top:Math.round((i-E)/2)};};
x.prototype._createHeader=function(){if(!this._header){this._header=new B(this.getId()+"-header");this._header._setRootAccessibilityRole("heading");this._header._setRootAriaLevel("2");this._setupBarTitleAlignment(this._header,this.getId()+"_header");this.setAggregation("_header",this._header);}};
x.prototype._applyTitleToHeader=function(){var e=this.getProperty("title");if(this._headerTitle){this._headerTitle.setText(e);}else{this._headerTitle=new a(this.getId()+"-title",{text:e,level:"H2"}).addStyleClass("sapMDialogTitle");this._header.addContentMiddle(this._headerTitle);}};
x.prototype._hasSingleScrollableContent=function(){var e=this.getContent();while(e.length===1&&e[0]instanceof C&&e[0].isA("sap.ui.core.mvc.View")){e=e[0].getContent();}if(e.length===1&&e[0]instanceof C&&e[0].isA(this._scrollContentList)){return true;}return false;};
x.prototype._getFocusDomRef=function(){var i=this.getInitialFocus();if(i){return document.getElementById(i);}return this._getFirstFocusableContentSubHeader()||this._getFirstFocusableContentElement()||this._getFirstVisibleButtonDomRef()||this.getDomRef();};
x.prototype._getFirstVisibleButtonDomRef=function(){var e=this.getBeginButton(),E=this.getEndButton(),z=this.getButtons(),F;if(e&&e.getVisible()){F=e.getDomRef();}else if(E&&E.getVisible()){F=E.getDomRef();}else if(z&&z.length>0){for(var i=0;i<z.length;i++){if(z[i].getVisible()){F=z[i].getDomRef();break;}}}return F;};
x.prototype._getFirstFocusableContentSubHeader=function(){var $=this.$().find('.sapMDialogSubHeader');return $.firstFocusableDomRef();};
x.prototype._getFirstFocusableContentElement=function(){var $=this.$("cont");return $.firstFocusableDomRef();};
x.prototype._setInitialFocus=function(){var F=this._getFocusDomRef(),e;if(F&&F.id){e=n.byId(F.id);}if(e){if(e.getVisible&&!e.getVisible()){this.focus();return;}F=e.getFocusDomRef();}if(!F){this.setInitialFocus("");F=this._getFocusDomRef();}if(!this.getInitialFocus()){this.setAssociation('initialFocus',F?F.id:this.getId(),true);}if(D.system.desktop||(F&&!/input|textarea|select/i.test(F.tagName))){if(F){F.focus();}}else{this.focus();}};
x.prototype.getScrollDelegate=function(){return this._oScroller;};
x.prototype._composeAggreNameInHeader=function(e){var H;if(e==="Begin"){H="contentLeft";}else if(e==="End"){H="contentRight";}else{H="content"+e;}return H;};
x.prototype._isToolbarEmpty=function(){var e=this._oToolbar.getContent().filter(function(i){return i.getMetadata().getName()!=='sap.m.ToolbarSpacer';});return e.length===0;};
x.prototype._setButton=function(e,i,z){return this;};
x.prototype._getButton=function(e){var i=e.toLowerCase()+"Button",z="_o"+this._firstLetterUpperCase(e)+"Button";if(D.system.phone){return this.getAggregation(i,null,true);}else{return this[z];}};
x.prototype._getButtonFromHeader=function(e){if(this._header){var H=this._composeAggreNameInHeader(this._firstLetterUpperCase(e)),i=this._header.getAggregation(H);return i&&i[0];}else{return null;}};
x.prototype._firstLetterUpperCase=function(e){return e.charAt(0).toUpperCase()+e.slice(1);};
x.prototype._getAnyHeader=function(){var e=this.getCustomHeader();if(e){e._setRootAriaLevel("2");return e._setRootAccessibilityRole("heading");}else{var i=this.getShowHeader();if(!i){return null;}this._createHeader();this._applyTitleToHeader();this._applyIconToHeader();return this._header;}};
x.prototype._deregisterResizeHandler=function(){if(this._resizeListenerId){g.deregister(this._resizeListenerId);this._resizeListenerId=null;}D.resize.detachHandler(this._onResize,this);};
x.prototype._registerResizeHandler=function(){var _=this.$("scroll");this._resizeListenerId=g.register(_.get(0),q.proxy(this._onResize,this));D.resize.attachHandler(this._onResize,this);this._onResize();};
x.prototype._deregisterContentResizeHandler=function(){if(this._sContentResizeListenerId){g.deregister(this._sContentResizeListenerId);this._sContentResizeListenerId=null;}};
x.prototype._registerContentResizeHandler=function(){if(!this._sContentResizeListenerId){this._sContentResizeListenerId=g.register(this.getDomRef("scrollCont"),q.proxy(this._onResize,this));}this._onResize();};
x.prototype._attachHandler=function(e){var i=this;if(!this._oButtonDelegate){this._oButtonDelegate={ontap:function(){i._oCloseTrigger=this;},onkeyup:function(){i._oCloseTrigger=this;},onkeydown:function(){i._oCloseTrigger=this;}};}if(e){e.addDelegate(this._oButtonDelegate,true,e);}};
x.prototype._createToolbarButtons=function(){var e=this._getToolbar();var i=this.getButtons();var z=this.getBeginButton();var E=this.getEndButton(),F=this,G=[z,E];G.forEach(function(H){if(H&&F._oButtonDelegate){H.removeDelegate(F._oButtonDelegate);}});e.removeAllContent();if(!("_toolbarSpacer"in this)){this._toolbarSpacer=new T();}e.addContent(this._toolbarSpacer);G.forEach(function(H){F._attachHandler(H);});if(i&&i.length){i.forEach(function(H){e.addContent(H);});}else{if(z){e.addContent(z);}if(E){e.addContent(E);}}};
x.prototype._getToolbar=function(){if(!this._oToolbar){this._oToolbar=new A(this.getId()+"-footer").addStyleClass("sapMTBNoBorders");this._oToolbar.addDelegate({onAfterRendering:function(){if(this.getType()===p.Message){this.$("footer").removeClass("sapContrast sapContrastPlus");}}},false,this);this.setAggregation("_toolbar",this._oToolbar);}return this._oToolbar;};
x.prototype.getValueStateString=function(e){var i=n.getLibraryResourceBundle("sap.m");switch(e){case(V.Success):return i.getText("LIST_ITEM_STATE_SUCCESS");case(V.Warning):return i.getText("LIST_ITEM_STATE_WARNING");case(V.Error):return i.getText("LIST_ITEM_STATE_ERROR");case(V.Information):return i.getText("LIST_ITEM_STATE_INFORMATION");default:return"";}};
x.prototype.setSubHeader=function(e){this.setAggregation("subHeader",e);if(e){e.setVisible=function(i){e.setProperty("visible",i);this.invalidate();}.bind(this);}return this;};
x.prototype.setLeftButton=function(e){if(typeof e==="string"){e=n.byId(e);}this.setBeginButton(e);return this.setAssociation("leftButton",e);};
x.prototype.setRightButton=function(e){if(typeof e==="string"){e=n.byId(e);}this.setEndButton(e);return this.setAssociation("rightButton",e);};
x.prototype.getLeftButton=function(){var e=this.getBeginButton();return e?e.getId():null;};
x.prototype.getRightButton=function(){var e=this.getEndButton();return e?e.getId():null;};
x.prototype.setBeginButton=function(e){if(e&&e.isA("sap.m.Button")){e.addStyleClass("sapMDialogBeginButton");}return this.setAggregation("beginButton",e);};
x.prototype.setEndButton=function(e){if(e&&e.isA("sap.m.Button")){e.addStyleClass("sapMDialogEndButton");}return this.setAggregation("endButton",e);};
x.prototype.getAggregation=function(e,i,z){var E=C.prototype.getAggregation.apply(this,Array.prototype.slice.call(arguments,0,2));if(e==='buttons'&&E&&E.length===0){this.getBeginButton()&&E.push(this.getBeginButton());this.getEndButton()&&E.push(this.getEndButton());}return E;};
x.prototype.getAriaLabelledBy=function(){var H=this._getAnyHeader(),e=this.getAssociation("ariaLabelledBy",[]).slice();var i=this.getSubHeader();if(i){e.unshift(i.getId());}if(H){var z=H.findAggregatedObjects(true,function(E){return E.isA("sap.m.Title");});if(z.length){e=z.map(function(E){return E.getId();}).concat(e);}else{e.unshift(H.getId());}}return e;};
x.prototype._applyIconToHeader=function(){var i=this.getIcon();if(!i){if(this._iconImage){this._iconImage.destroy();this._iconImage=null;}return;}if(!this._iconImage){this._iconImage=d.createControlByURI({id:this.getId()+"-icon",src:i,useIconTooltip:false},c).addStyleClass("sapMDialogIcon");this._header.insertAggregation("contentMiddle",this._iconImage,0);}this._iconImage.setSrc(i);};
x.prototype.setInitialFocus=function(i){return this.setAssociation("initialFocus",i,true);};
x.prototype.forceInvalidate=C.prototype.invalidate;
x.prototype.invalidate=function(e){if(this.isOpen()){this.forceInvalidate(e);}};
function y(e){var $=q(e);var i=$.control(0);if($.parents('.sapMDialogSection').length){return false;}if(!i||i.getMetadata().getInterfaces().indexOf("sap.m.IBar")>-1){return true;}return $.hasClass('sapMDialogTitle');}
if(D.system.desktop){x.prototype.ondblclick=function(e){if(y(e.target)){var $=this.$('cont');this._bDisableRepositioning=false;this._oManuallySetPosition=null;this._oManuallySetSize=null;this.oPopup&&this.oPopup._applyPosition(this.oPopup._oLastPosition,true);$.css({height:'100%'});}};x.prototype.onmousedown=function(e){if(e.which===3){return;}if(this.getStretch()||(!this.getDraggable()&&!this.getResizable())){return;}var i;var z=this;var $=q(document);var E=q(e.target);var F=E.hasClass('sapMDialogResizeHandler')&&this.getResizable();var M=function(_){i=i?clearTimeout(i):setTimeout(function(){_();},0);};var G=window.innerWidth;var H=window.innerHeight;var J={x:e.pageX,y:e.pageY,width:z._$dialog.width(),height:z._$dialog.height(),outerHeight:z._$dialog.outerHeight(),offset:{x:e.offsetX?e.offsetX:e.originalEvent.layerX,y:e.offsetY?e.offsetY:e.originalEvent.layerY},position:{x:z._$dialog.offset().left,y:z._$dialog.offset().top}};var N;function Q(){var _=z.$(),a1=z.$('cont'),b1,c1;$.off("mouseup",Q);$.off("mousemove",N);if(F){z._$dialog.removeClass('sapMDialogResizing');b1=parseInt(_.height());c1=parseInt(_.css("border-top-width"))+parseInt(_.css("border-bottom-width"));a1.height(b1+c1);}}if((y(e.target)&&this.getDraggable())||F){z._bDisableRepositioning=true;z._$dialog.addClass('sapDialogDisableTransition');z._oManuallySetPosition={x:J.position.x,y:J.position.y};z._$dialog.css({left:Math.min(Math.max(0,z._oManuallySetPosition.x),G-J.width),top:Math.min(Math.max(0,z._oManuallySetPosition.y),H-J.height),width:J.width});}if(y(e.target)&&this.getDraggable()){N=function(_){if(_.buttons===0){Q();return;}M(function(){z._bDisableRepositioning=true;z._oManuallySetPosition={x:Math.max(0,Math.min(_.pageX-e.pageX+J.position.x,G-J.width)),y:Math.max(0,Math.min(_.pageY-e.pageY+J.position.y,H-J.outerHeight))};z._$dialog.css({left:z._oManuallySetPosition.x,top:z._oManuallySetPosition.y});});};$.on("mousemove",N);}else if(F){z._$dialog.addClass('sapMDialogResizing');var U={};var W=parseInt(z._$dialog.css('min-width'));var X=J.x+J.width-W;var Y=E.width()-e.offsetX;var Z=E.height()-e.offsetY;N=function(_){M(function(){z._bDisableRepositioning=true;z.$('cont').height('').width('');if(_.pageY+Z>H){_.pageY=H-Z;}if(_.pageX+Y>G){_.pageX=G-Y;}z._oManuallySetSize={width:J.width+_.pageX-J.x,height:J.height+_.pageY-J.y};if(z._bRTL){U.left=Math.min(Math.max(_.pageX,0),X);z._oManuallySetSize.width=J.width+J.x-Math.max(_.pageX,0);}U.width=z._oManuallySetSize.width;U.height=z._oManuallySetSize.height;z._$dialog.css(U);});};$.on("mousemove",N);}else{return;}$.on("mouseup",Q);e.preventDefault();e.stopPropagation();};}
x.prototype._applyContextualSettings=function(){C.prototype._applyContextualSettings.call(this);};
b.mixInto(x.prototype);return x;});
sap.ui.predefine('sap/m/DialogRenderer',["sap/m/library","sap/ui/Device","sap/ui/core/library"],function(l,D,c){"use strict";var a=l.DialogType;var b=l.DialogRoleType;var V=c.ValueState;var d={apiVersion:2};d._mStateClasses={};d._mStateClasses[V.None]="";d._mStateClasses[V.Success]="sapMDialogSuccess";d._mStateClasses[V.Warning]="sapMDialogWarning";d._mStateClasses[V.Error]="sapMDialogError";d._mStateClasses[V.Information]="sapMDialogInformation";
d.render=function(r,o){var i=o.getId(),h=o._getAnyHeader(),s=o.getSubHeader(),B=o.getBeginButton(),e=o.getEndButton(),S=o.getState(),f=o.getStretch(),g=o.getStretchOnPhone()&&D.system.phone,v=o.getAggregation("_valueState");r.openStart("div",o).style("width",o.getContentWidth()).style("height",o.getContentHeight()).class("sapMDialog").class("sapMDialog-CTX").class("sapMPopup-CTX");if(o.isOpen()){r.class("sapMDialogOpen");}if(window.devicePixelRatio>1){r.class("sapMDialogHighPixelDensity");}if(o._bDisableRepositioning){r.class("sapMDialogTouched");}if(f||g){r.class("sapMDialogStretched");}r.class(d._mStateClasses[S]);var n=!o._oToolbar&&!B&&!e;var E=o._oToolbar&&o._isToolbarEmpty()&&!B&&!e;if(n||E){r.class("sapMDialog-NoFooter");}if(!h){r.class("sapMDialog-NoHeader");}var R=o.getProperty("role");if(S===V.Error||S===V.Warning){R=b.AlertDialog;}r.accessibilityState(o,{role:R,modal:true});if(o._forceDisableScrolling){r.class("sapMDialogWithScrollCont");}if(s&&s.getVisible()){r.class("sapMDialogWithSubHeader");if(s.getDesign()==l.ToolbarDesign.Info){r.class("sapMDialogSubHeaderInfoBar");}}if(o.getType()===a.Message){r.class("sapMMessageDialog");}if(!o.getVerticalScrolling()){r.class("sapMDialogVerScrollDisabled");}if(!o.getHorizontalScrolling()){r.class("sapMDialogHorScrollDisabled");}if(D.system.phone){r.class("sapMDialogPhone");}if(o.getDraggable()&&!f){r.class("sapMDialogDraggable");}if(l._bSizeCompact){r.class("sapUiSizeCompact");}var t=o.getTooltip_AsString();if(t){r.attr("title",t);}r.attr("tabindex","-1");r.openEnd();if(D.system.desktop){if(o.getResizable()&&!f){r.icon("sap-icon://resize-corner",["sapMDialogResizeHandler"],{"title":""});}r.openStart("span",i+"-firstfe").class("sapMDialogFirstFE").attr("tabindex","0").openEnd().close("span");}if(h){h._applyContextClassFor("header");r.openStart("header").class("sapMDialogTitle").openEnd().renderControl(h).close("header");}if(s){s._applyContextClassFor("subheader");r.openStart("header").class("sapMDialogSubHeader").openEnd().renderControl(s).close("header");}if(v){r.renderControl(v);}r.openStart("section",i+"-cont").class("sapMDialogSection").openEnd();r.openStart("div",i+"-scroll").class("sapMDialogScroll").openEnd();r.openStart("div",i+"-scrollCont").class("sapMDialogScrollCont");if(o.getStretch()||o.getContentHeight()){r.class("sapMDialogStretchContent");}r.openEnd();o.getContent().forEach(r.renderControl,r);r.close("div").close("div").close("section");if(!(n||E)){o._oToolbar._applyContextClassFor("footer");r.openStart("footer").class("sapMDialogFooter").openEnd().renderControl(o._oToolbar).close("footer");}if(D.system.desktop){r.openStart("span",i+"-lastfe").class("sapMDialogLastFE").attr("tabindex","0").openEnd().close("span");}r.close("div");};
return d;},true);
sap.ui.predefine('sap/m/DisplayListItem',["sap/ui/core/library","./library","./ListItemBase","./DisplayListItemRenderer"],function(c,l,L,D){"use strict";var T=c.TextDirection;
var a=L.extend("sap.m.DisplayListItem",{metadata:{library:"sap.m",properties:{label:{type:"string",group:"Misc",defaultValue:null},value:{type:"string",group:"Data",defaultValue:null},valueTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit}}}});
a.prototype.getContentAnnouncement=function(){return this.getLabel()+" "+this.getValue();};
return a;});
sap.ui.predefine('sap/m/DisplayListItemRenderer',["sap/ui/core/library","sap/ui/core/Renderer","./ListItemBaseRenderer"],function(c,R,L){"use strict";var T=c.TextDirection;var D=R.extend(L);D.apiVersion=2;
D.renderLIAttributes=function(r,l){r.class("sapMDLI");};
D.renderLIContent=function(r,l){var s=l.getLabel();if(s){r.openStart("label");r.attr("for",l.getId()+"-value");r.class("sapMDLILabel");r.openEnd();r.text(s);r.close("label");}var v=l.getValue();if(v){r.openStart("div",l.getId()+"-value");r.class("sapMDLIValue");var V=l.getValueTextDirection();if(V!=T.Inherit){r.attr("dir",V.toLowerCase());}r.openEnd();r.text(v);r.close("div");}};
return D;},true);
sap.ui.predefine('sap/m/DraftIndicator',["sap/ui/core/Control","sap/m/Label","sap/m/library","./DraftIndicatorRenderer"],function(C,L,l,D){"use strict";var a=l.DraftIndicatorState;
var b=C.extend("sap.m.DraftIndicator",{metadata:{library:"sap.m",designtime:"sap/m/designtime/DraftIndicator.designtime",properties:{state:{type:"sap.m.DraftIndicatorState",group:"Behavior",defaultValue:a.Clear},minDisplayTime:{type:"int",group:"Behavior",defaultValue:1500}},aggregations:{_label:{type:"sap.m.Label",multiple:false,visibility:"hidden"}}}});
var B=sap.ui.getCore().getLibraryResourceBundle("sap.m");b._oTEXTS={};b._oTEXTS[a.Saving]=B.getText("DRAFT_INDICATOR_SAVING_DRAFT");b._oTEXTS[a.Saved]=B.getText("DRAFT_INDICATOR_DRAFT_SAVED");b._oTEXTS[a.Clear]="";
b.prototype.init=function(){this.aQueue=[];this.iDelayedCallId=null;};
b.prototype.exit=function(){this._resetDraftTimer();};
b.prototype.setState=function(s){this.setProperty("state",s);this._addToQueue(s);if(s===a.Saving){this._addToQueue(a.Clear);}return this;};
b.prototype._getLabel=function(){var c=this.getAggregation('_label');if(!c){var c=new L({id:this.getId()+"-label"});this.setAggregation('_label',c,true);c=this.getAggregation('_label');}return c;};
b.prototype.showDraftSaving=function(){this._addToQueue(a.Saving);this._addToQueue(a.Clear);};
b.prototype.showDraftSaved=function(){this._addToQueue(a.Saved);};
b.prototype.clearDraftState=function(){this._addToQueue(a.Clear);};
b.prototype._addToQueue=function(s){this.aQueue.push(s);this._processQueue();};
b.prototype._processQueue=function(){if(this.iDelayedCallId){return;}var n=this.aQueue.shift();var t=this.getMinDisplayTime();if(!n){return;}this._applyState(n);if(n===a.Clear){this._proceed();return;}this.iDelayedCallId=setTimeout(this._proceed.bind(this),t);};
b.prototype._proceed=function(){this._resetDraftTimer();this._processQueue();};
b.prototype._applyState=function(s){this._getLabel().setText(b._oTEXTS[s]);};
b.prototype._resetDraftTimer=function(){clearTimeout(this.iDelayedCallId);this.iDelayedCallId=null;};
return b;});
sap.ui.predefine('sap/m/DraftIndicatorRenderer',[],function(){"use strict";var D={apiVersion:2};
D.render=function(r,c){r.openStart("div",c);r.class("sapMDraftIndicator");r.openEnd();var l=c._getLabel();r.renderControl(l);r.close("div");};
return D;},true);
sap.ui.predefine('sap/m/FacetFilter',['./NavContainer','./library','sap/ui/core/Control','sap/ui/core/CustomData','sap/ui/core/IconPool','sap/ui/core/delegate/ItemNavigation','sap/ui/core/InvisibleText','sap/ui/core/IntervalTrigger','sap/ui/Device','sap/ui/base/ManagedObject','sap/ui/core/Icon','sap/ui/model/Filter','sap/ui/model/FilterOperator','sap/ui/model/json/JSONModel','./FacetFilterRenderer',"sap/ui/events/KeyCodes","sap/base/assert","sap/base/Log","sap/ui/events/jquery/EventSimulation","sap/ui/thirdparty/jquery","sap/m/Button","sap/m/ToolbarSpacer","sap/m/OverflowToolbar","sap/m/Text","sap/m/Toolbar","sap/m/Popover","sap/m/SearchField","sap/m/Bar","sap/m/Dialog","sap/m/List","sap/m/StandardListItem","sap/m/CheckBox","sap/m/Page","sap/ui/dom/jquery/scrollRightRTL","sap/ui/dom/jquery/scrollLeftRTL","sap/ui/dom/jquery/Selectors"],function(N,l,C,a,I,b,c,d,D,M,e,F,f,J,g,K,h,L,E,q,B,T,O,m,n,P,S,o,p,r,s,t,u){"use strict";var v=l.ToolbarDesign;var w=l.ListType;var x=l.ListMode;var y=l.FacetFilterListDataType;var z=l.ButtonType;var A=l.PlacementType;var G=l.FacetFilterType;
var H=C.extend("sap.m.FacetFilter",{metadata:{interfaces:["sap.ui.core.IShrinkable"],library:"sap.m",properties:{showPersonalization:{type:"boolean",group:"Appearance",defaultValue:false},type:{type:"sap.m.FacetFilterType",group:"Appearance",defaultValue:G.Simple},liveSearch:{type:"boolean",group:"Behavior",defaultValue:true},showSummaryBar:{type:"boolean",group:"Behavior",defaultValue:false},showReset:{type:"boolean",group:"Behavior",defaultValue:true},showPopoverOKButton:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"lists",aggregations:{lists:{type:"sap.m.FacetFilterList",multiple:true,singularName:"list"},buttons:{type:"sap.m.Button",multiple:true,singularName:"button",visibility:"hidden"},removeFacetIcons:{type:"sap.ui.core.Icon",multiple:true,singularName:"removeFacetIcon",visibility:"hidden"},popover:{type:"sap.m.Popover",multiple:false,visibility:"hidden"},addFacetButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},dialog:{type:"sap.m.Dialog",multiple:false,visibility:"hidden"},summaryBar:{type:"sap.m.Toolbar",multiple:false,visibility:"hidden"},resetButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},arrowLeft:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},arrowRight:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},events:{reset:{},confirm:{}}}});
H.SCROLL_STEP=264;
H.prototype.setType=function(i){var j,k;if(D.system.phone){this.setProperty("type",G.Light);k=true;}else{this.setProperty("type",i);k=(i===G.Light);}j=this._getSummaryBar();j.setActive(k);if(i===G.Light){if(this.getShowReset()){this._addResetToSummary(j);}else{this._removeResetFromSummary(j);}}return this;};
H.prototype.setShowReset=function(V){this.setProperty("showReset",V);var i=this._getSummaryBar();if(V){if(this.getShowSummaryBar()||this.getType()===G.Light){this._addResetToSummary(i);}}else{if(this.getShowSummaryBar()||this.getType()===G.Light){this._removeResetFromSummary(i);}}return this;};
H.prototype.setShowSummaryBar=function(V){this.setProperty("showSummaryBar",V);if(V){var i=this._getSummaryBar();if(this.getShowReset()){this._addResetToSummary(i);}else{this._removeResetFromSummary(i);}i.setActive(this.getType()===G.Light);}return this;};
H.prototype.setLiveSearch=function(V){this.setProperty("liveSearch",V);if(this._displayedList){var i=this._displayedList;var j=sap.ui.getCore().byId(i.getAssociation("search"));j.detachLiveChange(i._handleSearchEvent,i);if(V){j.attachLiveChange(i._handleSearchEvent,i);}}return this;};
H.prototype.getLists=function(){var i=this.getAggregation("lists");if(!i){i=[];}if(this._displayedList){i.splice(this._listAggrIndex,0,this._displayedList);}i.forEach(function(j){if(!j.hasListeners("listItemsChange")){j.attachEvent("listItemsChange",_.bind(this));}}.bind(this));return i;};
function _(i){var j=i.getSource();if(this._oAllCheckBoxBar){this._oAllCheckBoxBar.setVisible(Boolean(j.getItems(true).length));}}
H.prototype.removeList=function(i){var j=M.prototype.removeAggregation.call(this,"lists",i);this._removeList(j);return j;};
H.prototype.removeAggregation=function(){var i=M.prototype.removeAggregation.apply(this,arguments);if(arguments[0]==="lists"){this._removeList(i);}return i;};
H.prototype.openFilterDialog=function(){var i=this._getFacetDialog();var j=this._getFacetDialogNavContainer();i.addContent(j);this.getLists().forEach(function(k){if(k.getMode()===x.MultiSelect){k._preserveOriginalActiveState();}});i.setInitialFocus(j.getPages()[0].getContent()[0].getItems()[0]);i.open();return this;};
H.prototype.init=function(){this._pageSize=5;this._addDelegateFlag=false;this._invalidateFlag=false;this._lastCategoryFocusIndex=0;this._aDomRefs=null;this._previousTarget=null;this._addTarget=null;this._aRows=null;this._bundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this.data("sap-ui-fastnavgroup","true",true);this._buttons={};this._aOwnedLabels=[];this._removeFacetIcons={};this._listAggrIndex=-1;this._displayedList=null;this._lastScrolling=false;this._bPreviousScrollForward=false;this._bPreviousScrollBack=false;this._getAddFacetButton();this.setAggregation("resetButton",this._createResetButton());if(E.touchEventMode==="ON"&&!D.system.phone){this._enableTouchSupport();}if(D.system.phone){this.setType(G.Light);}};
H.prototype.exit=function(){var i;d.removeListener(this._checkOverflow,this);if(this.oItemNavigation){this.removeDelegate(this.oItemNavigation);this.oItemNavigation.destroy();}if(this._aOwnedLabels){this._aOwnedLabels.forEach(function(j){i=sap.ui.getCore().byId(j);if(i){i.destroy();}});this._aOwnedLabels=null;}if(this._oAllCheckBoxBar){this._oAllCheckBoxBar=undefined;}};
H.prototype.onBeforeRendering=function(){if(this.getShowSummaryBar()||this.getType()===G.Light){var i=this._getSummaryBar();var j=i.getContent()[0];j.setText(this._getSummaryText());}d.removeListener(this._checkOverflow,this);};
H.prototype.onAfterRendering=function(){var i=this.getShowSummaryBar(),j=this.getType(),k=this._getSummaryBar().$();if(j!==G.Light&&!D.system.phone){d.addListener(this._checkOverflow,this);}if(j!==G.Light){this._startItemNavigation();}if(j===G.Light){k.attr("aria-roledescription",this._bundle.getText("FACETFILTER_ACTIVE_TITLE"));k.attr("role","group");}else if(i){k.attr("aria-roledescription",this._bundle.getText("FACETFILTER_TITLE"));}};
H.prototype._startItemNavigation=function(){var j=this.getDomRef(),R=j.getElementsByClassName("sapMFFHead"),k=[];if(R.length>0){for(var i=0;i<R[0].childNodes.length;i++){if(R[0].childNodes[i].id.indexOf("ff")<0&&R[0].childNodes[i].id.indexOf("icon")<0&&R[0].childNodes[i].id.indexOf("add")<0){k.push(R[0].childNodes[i]);}if(R[0].childNodes[i].id.indexOf("add")>=0){k.push(R[0].childNodes[i]);}}}if(k!=""){this._aDomRefs=k;}if((!this.oItemNavigation)||this._addDelegateFlag==true){this.oItemNavigation=new b();this.addDelegate(this.oItemNavigation);this._addDelegateFlag=false;}this._aRows=R;for(var i=0;i<this.$().find(":sapTabbable").length;i++){if(this.$().find(":sapTabbable")[i].id.indexOf("add")>=0){this._addTarget=this.$().find(":sapTabbable")[i];break;}}this.oItemNavigation.setRootDomRef(j);this.oItemNavigation.setItemDomRefs(k);this.oItemNavigation.setCycling(false);this.oItemNavigation.setPageSize(this._pageSize);};
H.prototype.onsapdelete=function(i){var j,Q;if(this.getType()===G.Light){return;}if(!this.getShowPersonalization()){return;}j=sap.ui.getCore().byId(i.target.id);if(!j){return;}Q=sap.ui.getCore().byId(j.getAssociation("list"));if(!Q){return;}if(!Q.getShowRemoveFacetIcon()){return;}Q.removeSelections(true);Q.setSelectedKeys();Q.setProperty("active",false,true);this.invalidate();var $=this.$().find(":sapTabbable");q($[$.length-1]).trigger("focus");var R=this.oItemNavigation.getFocusedIndex();q(i.target).trigger("blur");this.oItemNavigation.setFocusedIndex(R+1);this.focus();if(this.oItemNavigation.getFocusedIndex()==0){for(var k=0;k<this.$().find(":sapTabbable").length-1;k++){if($[k].id.indexOf("add")>=0){q($[k]).trigger("focus");}}}};
H.prototype.onsaptabnext=function(j){if(this.getType()===G.Light){return;}this._previousTarget=j.target;if(j.target.parentNode.className=="sapMFFHead"){for(var i=0;i<this.$().find(":sapTabbable").length;i++){if(this.$().find(":sapTabbable")[i].parentNode.className=="sapMFFResetDiv"){q(this.$().find(":sapTabbable")[i]).trigger("focus");this._invalidateFlag=false;j.preventDefault();j.setMarked();return;}}}this._lastCategoryFocusIndex=this.oItemNavigation.getFocusedIndex();if(this._invalidateFlag==true){this.oItemNavigation.setFocusedIndex(-1);this.focus();this._invalidateFlag=false;}};
H.prototype.onsaptabprevious=function(i){if(this.getType()===G.Light){return;}if(i.target.parentNode.className=="sapMFFResetDiv"&&this._previousTarget==null){q(this.$().find(":sapTabbable")[0]).trigger("focus");i.preventDefault();i.setMarked();return;}if(i.target.parentNode.className=="sapMFFResetDiv"&&this._previousTarget!=null&&this._previousTarget.id!=i.target.id){q(this._previousTarget).trigger("focus");i.preventDefault();i.setMarked();return;}if(i.target.id.indexOf("add")>=0||i.target.parentNode.className=="sapMFFHead"){this._previousTarget=i.target;q(this.$().find(":sapTabbable")[0]).trigger("focus");}};
H.prototype.onsapend=function(i){if(this.getType()===G.Light){return;}if(this._addTarget!=null){q(this._addTarget).trigger("focus");i.preventDefault();i.setMarked();}else{q(this._aRows[this._aRows.length-1]).trigger("focus");i.preventDefault();i.setMarked();}this._previousTarget=i.target;};
H.prototype.onsaphome=function(i){if(this.getType()===G.Light){return;}q(this._aRows[0]).trigger("focus");i.preventDefault();i.setMarked();this._previousTarget=i.target;};
H.prototype.onsappageup=function(i){this._previousTarget=i.target;};
H.prototype.onsappagedown=function(i){this._previousTarget=i.target;};
H.prototype.onsapincreasemodifiers=function(i){if(this.getType()===G.Light){return;}if(i.which==K.ARROW_RIGHT){this._previousTarget=i.target;var j=this.oItemNavigation.getFocusedIndex()-1;var k=j+this._pageSize;q(i.target).trigger("blur");this.oItemNavigation.setFocusedIndex(k);this.focus();}};
H.prototype.onsapdecreasemodifiers=function(i){if(this.getType()===G.Light){return;}var j=0;if(i.which==K.ARROW_LEFT){this._previousTarget=i.target;j=this.oItemNavigation.getFocusedIndex()+1;var k=j-this._pageSize;q(i.target).trigger("blur");this.oItemNavigation.setFocusedIndex(k);this.focus();}};
H.prototype.onsapdownmodifiers=function(i){if(this.getType()===G.Light){return;}this._previousTarget=i.target;var j=0;j=this.oItemNavigation.getFocusedIndex()-1;var k=j+this._pageSize;q(i.target).trigger("blur");this.oItemNavigation.setFocusedIndex(k);this.focus();};
H.prototype.onsapupmodifiers=function(i){if(this.getType()===G.Light){return;}this._previousTarget=i.target;var j=0;j=this.oItemNavigation.getFocusedIndex();if(j!=0){j=j+1;}var k=j-this._pageSize;q(i.target).trigger("blur");this.oItemNavigation.setFocusedIndex(k);this.focus();};
H.prototype.onsapexpand=function(i){if(this.getType()===G.Light){return;}this._previousTarget=i.target;var j=this.oItemNavigation.getFocusedIndex()+1;q(i.target).trigger("blur");this.oItemNavigation.setFocusedIndex(j);this.focus();};
H.prototype.onsapcollapse=function(i){if(this.getType()===G.Light){return;}this._previousTarget=i.target;var j=this.oItemNavigation.getFocusedIndex()-1;q(i.target).trigger("blur");this.oItemNavigation.setFocusedIndex(j);this.focus();};
H.prototype.onsapdown=function(i){if(this.getType()===G.Light){return;}this._previousTarget=i.target;if(i.target.parentNode.className=="sapMFFResetDiv"){q(i.target).trigger("focus");i.preventDefault();i.setMarked();return;}};
H.prototype.onsapup=function(i){if(this.getType()===G.Light){return;}this._previousTarget=i.target;if(i.target.parentNode.className=="sapMFFResetDiv"){q(i.target).trigger("focus");i.preventDefault();i.setMarked();}};
H.prototype.onsapleft=function(i){if(this.getType()===G.Light){return;}this._previousTarget=i.target;if(i.target.parentNode.className=="sapMFFResetDiv"){q(i.target).trigger("focus");i.preventDefault();i.setMarked();}};
H.prototype.onsapright=function(i){if(this.getType()===G.Light){return;}this._previousTarget=i.target;if(i.target.parentNode.className=="sapMFFResetDiv"){q(i.target).trigger("focus");i.preventDefault();i.setMarked();}};
H.prototype.onsapescape=function(i){if(this.getType()===G.Light){return;}if(i.target.parentNode.className=="sapMFFResetDiv"){return;}var j=this._lastCategoryFocusIndex;q(i.target).trigger("blur");this.oItemNavigation.setFocusedIndex(j);this.focus();};
H.prototype._getPopover=function(){var i=this.getAggregation("popover");if(!i){var j=this;i=new P({placement:A.Bottom,beforeOpen:function(Q){if(j._displayedList){j._displayedList._bSearchEventDefaultBehavior&&j._displayedList._setSearchValue("");}this.setCustomHeader(j._createFilterItemsSearchFieldBar(j._displayedList));var R=this.getSubHeader();if(!R){this.setSubHeader(j._createSelectAllCheckboxBar(j._displayedList));}k(j._displayedList);},afterClose:function(Q){j._addDelegateFlag=true;j._handlePopoverAfterClose();},horizontalScrolling:false});this.setAggregation("popover",i,true);i.setContentWidth("30%");i.addStyleClass("sapMFFPop");var k=function(Q){if(!Q){return;}var R=j._getFacetRemoveIcon(Q);if(R){R._bTouchStarted=false;}};}if(this.getShowPopoverOKButton()){this._addOKButtonToPopover(i);}else{i.destroyAggregation("footer");}return i;};
H.prototype._handlePopoverAfterClose=function(){var i=this.getAggregation("popover"),j=this._displayedList;if(!i){return;}var k=this._getFacetRemoveIcon(j);if(k&&k._bTouchStarted){return;}this._restoreListFromDisplayContainer(i);this._displayRemoveIcon(false,j);j._fireListCloseEvent();this._fireConfirmEvent();this.destroyAggregation("popover");if(this._oOpenPopoverDeferred){setTimeout(function(){this._oOpenPopoverDeferred.resolve();this._oOpenPopoverDeferred=undefined;}.bind(this),0);}};
H.prototype._fireConfirmEvent=function(){this.fireEvent('confirm');};
H.prototype._openPopover=function(i,j){var k;if(!i.isOpen()){var Q=sap.ui.getCore().byId(j.getAssociation("list"));h(Q,"The facet filter button should be associated with a list.");k=!Q.fireListOpen({});this._moveListToDisplayContainer(Q,i);i.openBy(j);if(Q.getShowRemoveFacetIcon()){this._displayRemoveIcon(true,Q);}if(Q.getWordWrap()){i.setContentWidth("30%");}if(!k){Q._applySearch();}}return this;};
H.prototype._getAddFacetButton=function(){var i=this.getAggregation("addFacetButton");if(!i){i=new B(this.getId()+"-add",{icon:I.getIconURI("add-filter"),type:z.Transparent,tooltip:this._bundle.getText("FACETFILTER_ADDFACET"),press:function(j){this.openFilterDialog();}.bind(this)});this.setAggregation("addFacetButton",i,true);}return i;};
H.prototype._getButtonForList=function(i){if(this._buttons[i.getId()]){this._setButtonText(i);return this._buttons[i.getId()];}var j=this;var k=new B({type:z.Transparent,press:function(Q){var R=this;var U=function(){var V=j._getPopover();j._openPopover(V,R);};if(i.getMode()===x.MultiSelect){i._preserveOriginalActiveState();}var V=j._getPopover();if(V.isOpen()){setTimeout(function(){if(V.isOpen()){return;}j._oOpenPopoverDeferred=q.Deferred();j._oOpenPopoverDeferred.promise().done(U);},100);}else{setTimeout(U.bind(this),100);}}});this._buttons[i.getId()]=k;this.addAggregation("buttons",k);k.setAssociation("list",i.getId(),true);this._setButtonText(i);return k;};
H.prototype._setButtonText=function(i){var j=this._buttons[i.getId()];if(i._iAllItemsCount===undefined&&i.getMaxItemsCount()||!i._bSearchEventDefaultBehavior){i._iAllItemsCount=i.getMaxItemsCount();}if(j){var k="";var Q=Object.getOwnPropertyNames(i._oSelectedKeys);var R=Q.length;if(R===1){var U=i._oSelectedKeys[Q[0]];k=this._bundle.getText("FACETFILTER_ITEM_SELECTION",[i.getTitle(),U]);}else if(R>0&&R===(i._iAllItemsCount?i._iAllItemsCount:0)){k=this._bundle.getText("FACETFILTER_ALL_SELECTED",[i.getTitle()]);}else if(R>0){k=this._bundle.getText("FACETFILTER_ITEM_SELECTION",[i.getTitle(),R]);}else{k=i.getTitle();}j.setText(k);}};
H.prototype._getFacetRemoveIcon=function(i){var j=this,k=this._removeFacetIcons[i.getId()];if(!k){k=new e({src:I.getIconURI("decline"),tooltip:this._bundle.getText("FACETFILTER_REMOVE"),press:function(){k._bPressed=true;}});k.addDelegate({ontouchstart:function(){k._bTouchStarted=true;k._bPressed=false;},ontouchend:function(){j._displayRemoveIcon(false,i);k._bTouchStarted=false;setTimeout(Q.bind(this),100);}},true);var Q=function(){if(k._bPressed){i.removeSelections(true);i.setSelectedKeys();i.setProperty("active",false,true);}j._handlePopoverAfterClose();};k.setAssociation("list",i.getId(),true);k.addStyleClass("sapMFFLRemoveIcon");this._removeFacetIcons[i.getId()]=k;this.addAggregation("removeFacetIcons",k);this._displayRemoveIcon(false,i);}return k;};
H.prototype._displayRemoveIcon=function(i,j){if(this.getShowPersonalization()){var k=this._removeFacetIcons[j.getId()];if(i){k.removeStyleClass("sapMFFLHiddenRemoveIcon");k.addStyleClass("sapMFFLVisibleRemoveIcon");}else{k.removeStyleClass("sapMFFLVisibleRemoveIcon");k.addStyleClass("sapMFFLHiddenRemoveIcon");}}};
H.prototype._getFacetDialogNavContainer=function(){var i=new N({autoFocus:false});var j=this._createFacetPage();i.addPage(j);i.setInitialPage(j);i.attachAfterNavigate(function(k){var Q=k.getParameters()["to"];var R=k.getParameters()['from'];if(R===j){var U=(this._displayedList.getMode()===x.MultiSelect)?Q.getContent(0)[1].getItems()[0]:Q.getContent(0)[0].getItems()[0];if(U){U.focus();}}if(Q===j){R.destroySubHeader();h(this._displayedList===null,"Filter items list should have been placed back in the FacetFilter aggregation before page content is destroyed.");R.destroyContent();this._selectedFacetItem.invalidate();Q.invalidate();this._selectedFacetItem.focus();this._selectedFacetItem=null;}}.bind(this));return i;};
H.prototype._createFacetPage=function(){var i=this._createFacetList();var j=new S({width:"100%",tooltip:this._bundle.getText("FACETFILTER_SEARCH"),liveChange:function(Q){var R=i.getBinding("items");if(R){var U=new F("text",f.Contains,Q.getParameters()["newValue"]);R.filter([U]);}}});var k=new u({enableScrolling:true,title:this._bundle.getText("FACETFILTER_TITLE"),subHeader:new o({contentMiddle:j}),content:[i]});return k;};
H.prototype._createFilterItemsPage=function(){var i=new u({showNavButton:true,enableScrolling:true,navButtonPress:function(j){var k=j.getSource().getParent();this._navFromFilterItemsPage(k);}.bind(this)});return i;};
H.prototype._getFilterItemsPage=function(i){var j=i.getPages()[1];if(j){i.removePage(j);j.destroy();}var k=this._createFilterItemsPage();i.addPage(k);return k;};
H.prototype._createFilterItemsSearchFieldBar=function(i){var j=true;if(i.getDataType()!=y.String){j=false;}var k=new S({value:i._getSearchValue(),width:"100%",enabled:j,tooltip:this._bundle.getText("FACETFILTER_SEARCH"),search:function(R){this._displayedList._handleSearchEvent(R);}.bind(this)});if(this.getLiveSearch()){k.attachLiveChange(i._handleSearchEvent,i);}var Q=new o({contentMiddle:k});i.setAssociation("search",k);return Q;};
H.prototype._getFacetDialog=function(){var i=this.getAggregation("dialog");if(!i){var j=this;i=new p({showHeader:false,stretch:D.system.phone?true:false,afterClose:function(){j._addDelegateFlag=true;j._invalidateFlag=true;var k=this.getContent()[0];var Q=k.getPages()[1];if(k.getCurrentPage()===Q){var R=j._restoreListFromDisplayContainer(Q);if(R.getMode()===x.MultiSelect){R._updateActiveState();j._bCheckForAddListBtn=true;}R._fireListCloseEvent();R._bSearchEventDefaultBehavior&&R._search("");}this.destroyAggregation("content",true);j.invalidate();},beginButton:new B({text:this._bundle.getText("FACETFILTER_ACCEPT"),tooltip:this._bundle.getText("FACETFILTER_ACCEPT"),press:function(){j._closeDialog();}}),contentHeight:"500px",ariaLabelledBy:[c.getStaticId("sap.m","FACETFILTER_AVAILABLE_FILTER_NAMES")]});i.addStyleClass("sapMFFDialog");i.onsapentermodifiers=function(k){if(k.shiftKey&&!k.ctrlKey&&!k.altKey){var Q=this.getContent()[0];j._navFromFilterItemsPage(Q);}};this.setAggregation("dialog",i,true);}return i;};
H.prototype._closeDialog=function(){var i=this.getAggregation("dialog");if(i&&i.isOpen()){i.close();this._fireConfirmEvent();}};
H.prototype._closePopover=function(){var i=this.getAggregation("popover");if(i&&i.isOpen()){i.close();}};
H.prototype._createFacetList=function(){var j=this._oFacetList=new r({mode:x.None,items:{path:"/items",template:new s({title:"{text}",counter:"{count}",type:w.Navigation,customData:[new a({key:"index",value:"{index}"})]})}});var k=this._getMapFacetLists();var Q=new J({items:k});if(k.length>100){Q.setSizeLimit(k.length);}var R=this;j.attachUpdateFinished(function(){for(var i=0;i<j.getItems().length;i++){var U=this.getItems()[i];U.detachPress(R._handleFacetListItemPress,R);U.attachPress(R._handleFacetListItemPress,R);}});j.setModel(Q);return j;};
H.prototype.refreshFacetList=function(){this._oFacetList.getModel().setData({items:this._getMapFacetLists()});return this;};
H.prototype._getMapFacetLists=function(){return this.getLists().map(function(i,j){return{text:i.getTitle(),count:i.getAllCount(),index:j};});};
H.prototype._createSelectAllCheckboxBar=function(i){if(!i.getMultiSelect()){return null;}var j=i.getActive()&&i.getItems().length>0&&Object.getOwnPropertyNames(i._oSelectedKeys).length===i.getItems().length;var k=new t(i.getId()+"-selectAll",{text:this._bundle.getText("FACETFILTER_CHECKBOX_ALL"),tooltip:this._bundle.getText("FACETFILTER_CHECKBOX_ALL"),selected:j,select:function(R){k.setSelected(R.getParameter("selected"));i._handleSelectAllClick(R.getParameter("selected"));}});i.setAssociation("allcheckbox",k);var Q=new o({visible:Boolean(i.getItems(true).length)});Q.addEventDelegate({ontap:function(R){if(R.srcControl===this){i._handleSelectAllClick(k.getSelected());}}},Q);Q.addContentLeft(k);Q.addStyleClass("sapMFFCheckbar");this._oAllCheckBoxBar=Q;return Q;};
H.prototype._handleFacetListItemPress=function(i){this._navToFilterItemsPage(i.getSource());};
H.prototype._navToFilterItemsPage=function(i){this._selectedFacetItem=i;var j=this.getAggregation("dialog").getContent()[0];var k=i.getCustomData();h(k.length===1,"There should be exactly one custom data for the original facet list item index");var Q=k[0].getValue();var R=this.getLists()[Q];this._listIndexAgg=this.indexOfAggregation("lists",R);if(this._listIndexAgg==Q){var U=this._getFilterItemsPage(j);R.fireListOpen({});this._moveListToDisplayContainer(R,U);U.setSubHeader(this._createFilterItemsSearchFieldBar(R));var V=this._createSelectAllCheckboxBar(R);if(V){U.insertContent(V,0);}U.setTitle(R.getTitle());j.to(U);}};
H.prototype._navFromFilterItemsPage=function(i){var j=i.getPages()[1];var k=this._restoreListFromDisplayContainer(j);if(k.getMode()===x.MultiSelect){k._updateActiveState();}k._fireListCloseEvent();k._bSearchEventDefaultBehavior&&k._search("");this._selectedFacetItem.setCounter(k.getAllCount());i.backToTop();};
H.prototype._moveListToDisplayContainer=function(i,j){this._listAggrIndex=this.indexOfAggregation("lists",i);h(this._listAggrIndex>-1,"The lists index should be valid.");M.prototype.removeAggregation.call(this,"lists",i,true);j.addAggregation("content",i,false);i.setAssociation("facetFilter",this,true);this._displayedList=i;};
H.prototype._restoreListFromDisplayContainer=function(i){var j=i.removeAggregation("content",this._displayedList,true);this.insertAggregation("lists",j,this._listAggrIndex,j.getActive());this._listAggrIndex=-1;this._displayedList=null;return j;};
H.prototype._getSequencedLists=function(){var k=-1;var Q=[];var R=this.getLists();if(R.length>0){for(var i=0;i<R.length;i++){if(R[i].getActive()){if(R[i].getSequence()<-1){R[i].setSequence(-1);}else if(R[i].getSequence()>k){k=R[i].getSequence();}Q.push(R[i]);}else if(!R[i].getRetainListSequence()){R[i].setSequence(-1);}}for(var j=0;j<Q.length;j++){if(Q[j].getSequence()<=-1){k+=1;Q[j].setSequence(k);}}if(Q.length>1){Q.sort(function(U,V){return U.getSequence()-V.getSequence();});}}return Q;};
H.prototype._getSummaryBar=function(){var i=this.getAggregation("summaryBar"),j=this.getType();if(!i){var k=new m({maxLines:1});i=new n({content:[k],active:j===G.Light?true:false,design:v.Info,ariaLabelledBy:k,press:function(Q){this.openFilterDialog();}.bind(this)});i._setRootAccessibilityRole("group");this.setAggregation("summaryBar",i);}return i;};
H.prototype._createResetButton=function(){var j=new B({type:z.Transparent,icon:I.getIconURI("undo"),tooltip:this._bundle.getText("FACETFILTER_RESET"),press:function(k){this._addDelegateFlag=true;this._invalidateFlag=true;this.fireReset();var Q=this.getLists();for(var i=0;i<Q.length;i++){Q[i]._setSearchValue("");Q[i]._applySearch();var R=Q[i].getItems()[0];if(R){R.focus();}}this.invalidate();}.bind(this)});return j;};
H.prototype._addOKButtonToPopover=function(i){var j=i.getFooter(),k;if(!j){k=new B({text:this._bundle.getText("FACETFILTER_ACCEPT"),tooltip:this._bundle.getText("FACETFILTER_ACCEPT"),press:function(){this._closePopover();}.bind(this)});j=new O({content:[new T(),k]});i.setFooter(j);}};
H.prototype._getSummaryText=function(){var k=", ";var Q=" ";var R="";var U=true;var V=this.getLists();if(V.length>0){for(var i=0;i<V.length;i++){var W=V[i];if(W.getActive()){var X=this._getSelectedItemsText(W);var Y="";for(var j=0;j<X.length;j++){Y=Y+X[j]+k;}if(Y){Y=Y.substring(0,Y.lastIndexOf(k)).trim();if(U){R=this._bundle.getText("FACETFILTER_INFOBAR_FILTERED_BY",[W.getTitle(),Y]);U=false;}else{R=R+Q+this._bundle.getText("FACETFILTER_INFOBAR_AND")+Q+this._bundle.getText("FACETFILTER_INFOBAR_AFTER_AND",[W.getTitle(),Y]);}}}}}if(!R){R=this._bundle.getText("FACETFILTER_INFOBAR_NO_FILTERS");}return R;};
H.prototype._getSelectedItemsText=function(i){var j=i.getSelectedItems().map(function(k){return k.getText();});i._oSelectedKeys&&Object.getOwnPropertyNames(i._oSelectedKeys).forEach(function(k){j.indexOf(i._oSelectedKeys[k])===-1&&j.push(i._oSelectedKeys[k]);});return j;};
H.prototype._addResetToSummary=function(i){if(i.getContent().length===1){i.addContent(new T({width:""}));var j=this._createResetButton();i.addContent(j);j.addStyleClass("sapUiSizeCompact");j.addStyleClass("sapMFFRefresh");j.addStyleClass("sapMFFBtnHoverable");}};
H.prototype._removeResetFromSummary=function(i){if(i.getContent().length===3){var j=i.removeAggregation("content",1);j.destroy();var k=i.removeAggregation("content",1);k.destroy();}};
H.prototype._removeList=function(i){if(i){var j=this._buttons[i.getId()];if(j){this.removeAggregation("buttons",j);j.destroy();}var R=this._removeFacetIcons[i.getId()];if(R){this.removeAggregation("removeIcons",R);R.destroy();}delete this._buttons[i.getId()];delete this._removeFacetIcons[i.getId()];}};
H.prototype._getScrollingArrow=function(j){var k=null;var Q={src:"sap-icon://navigation-"+j+"-arrow"};if(j==="left"){k=this.getAggregation("arrowLeft");if(!k){Q.id=this.getId()+"-arrowScrollLeft";k=I.createControlByURI(Q);var R=["sapMPointer","sapMFFArrowScroll","sapMFFArrowScrollLeft"];for(var i=0;i<R.length;i++){k.addStyleClass(R[i]);k.setTooltip(this._bundle.getText("FACETFILTER_PREVIOUS"));}this.setAggregation("arrowLeft",k);}}else if(j==="right"){k=this.getAggregation("arrowRight");if(!k){Q.id=this.getId()+"-arrowScrollRight";k=I.createControlByURI(Q);var U=["sapMPointer","sapMFFArrowScroll","sapMFFArrowScrollRight"];for(var i=0;i<U.length;i++){k.addStyleClass(U[i]);k.setTooltip(this._bundle.getText("FACETFILTER_NEXT"));}this.setAggregation("arrowRight",k);}}else{L.error("Scrolling arrow name "+j+" is not valid");}return k;};
H.prototype._checkOverflow=function(){var i=this.getDomRef("head"),$=q(i),j=this.$(),k=false,Q=false,R=false,U=null,V=null,W=null;if(i){U=i.scrollLeft;V=i.scrollWidth;W=i.clientWidth;if(V>W){if(V-W==1){V=W;}else{R=true;}}j.toggleClass("sapMFFScrolling",R);j.toggleClass("sapMFFNoScrolling",!R);this._lastScrolling=R;if(!this._bRtl){k=U>0;Q=(V>W)&&(V>U+W);}else{Q=$.scrollLeftRTL()>0;k=$.scrollRightRTL()>0;}if((Q!=this._bPreviousScrollForward)||(k!=this._bPreviousScrollBack)){j.toggleClass("sapMFFNoScrollBack",!k);j.toggleClass("sapMFFNoScrollForward",!Q);}}};
H.prototype.onclick=function(i){var j=i.target.id;if(j){var k=this.getId(),Q=i.target;i.preventDefault();if(j==k+"-arrowScrollLeft"){Q.tabIndex=-1;Q.focus();this._scroll(-H.SCROLL_STEP,500);}else if(j==k+"-arrowScrollRight"){Q.tabIndex=-1;Q.focus();this._scroll(H.SCROLL_STEP,500);}}};
H.prototype._scroll=function(i,j){var k=this.getDomRef("head");var Q=k.scrollLeft;if(!D.browser.internet_explorer&&this._bRtl){i=-i;}var R=Q+i;q(k).stop(true,true).animate({scrollLeft:R},j);};
H.prototype._enableTouchSupport=function(){var i=function(Q){var R=this.getType();if(R===G.Light){return;}Q.preventDefault();if(this._iInertiaIntervalId){window.clearInterval(this._iInertiaIntervalId);}this.startScrollX=this.getDomRef("head").scrollLeft;this.startTouchX=Q.touches[0].pageX;this._bTouchNotMoved=true;this._lastMoveTime=new Date().getTime();}.bind(this);var j=function(Q){var R=this.getType();if(R===G.Light){return;}var U=Q.touches[0].pageX-this.startTouchX;var V=this.getDomRef("head");var W=V.scrollLeft;var X=this.startScrollX-U;V.scrollLeft=X;this._bTouchNotMoved=false;var Y=new Date().getTime()-this._lastMoveTime;this._lastMoveTime=new Date().getTime();if(Y>0){this._velocity=(X-W)/Y;}Q.preventDefault();}.bind(this);var k=function(Q){var R=this.getType();if(R===G.Light){return;}if(this._bTouchNotMoved===false){Q.preventDefault();var U=this.getDomRef("head");var V=50;var W=Math.abs(this._velocity/10);this._iInertiaIntervalId=window.setInterval(function(){this._velocity=this._velocity*0.80;var X=this._velocity*V;U.scrollLeft=U.scrollLeft+X;if(Math.abs(this._velocity)<W){window.clearInterval(this._iInertiaIntervalId);this._iInertiaIntervalId=undefined;}},V);}else if(this._bTouchNotMoved===true){this.onclick(Q);Q.preventDefault();}this._bTouchNotMoved=undefined;this._lastMoveTime=undefined;}.bind(this);this.addEventDelegate({ontouchstart:i},this);this.addEventDelegate({ontouchend:k},this);this.addEventDelegate({ontouchmove:j},this);};
return H;});
sap.ui.predefine('sap/m/FacetFilterItem',['./ListItemBase','./library','./FacetFilterItemRenderer'],function(L,l,F){"use strict";
var a=L.extend("sap.m.FacetFilterItem",{metadata:{library:"sap.m",properties:{key:{type:"string",group:"Data",defaultValue:null},text:{type:"string",group:"Misc",defaultValue:null},count:{type:"int",group:"Misc",defaultValue:null,deprecated:true}}}});
a.prototype.setCount=function(c){this.setProperty("count",c);this.setProperty("counter",c);return this;};
a.prototype.setCounter=function(c){this.setProperty("count",c);this.setProperty("counter",c);return this;};
a.prototype.init=function(){this.attachEvent("_change",this._itemTextChange);L.prototype.init.apply(this);this.addStyleClass("sapMFFLI");};
a.prototype.exit=function(){L.prototype.exit.apply(this);this.detachEvent("_change",this._itemTextChange);};
a.prototype._itemTextChange=function(e){if(e.getParameter("name")==="text"){this.informList("TextChange",e.getParameter("newValue"));}};
return a;});
sap.ui.predefine('sap/m/FacetFilterItemRenderer',['./ListItemBaseRenderer','sap/ui/core/Renderer'],function(L,R){"use strict";var F=R.extend(L);F.apiVersion=2;
F.renderLIContent=function(r,c){r.openStart("div",c);if(c.getParent()&&c.getParent().getWordWrap()){r.class("sapMFFLITitleWrap");}else{r.class("sapMFFLITitle");}r.openEnd();r.text(c.getText());r.close("div");};
return F;},true);
sap.ui.predefine('sap/m/FacetFilterList',['./List','./library','sap/ui/model/ChangeReason','sap/ui/model/Filter','./FacetFilterListRenderer','./FacetFilterItem',"sap/base/Log","sap/ui/model/FilterOperator","sap/ui/model/FilterType"],function(L,l,C,F,a,b,c,d,e){"use strict";var f=l.ListMode;var g=l.FacetFilterListDataType;
var h=L.extend("sap.m.FacetFilterList",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Appearance",defaultValue:null},wordWrap:{type:"boolean",group:"Appearance",defaultValue:false},multiSelect:{type:"boolean",group:"Behavior",defaultValue:true,deprecated:true},active:{type:"boolean",group:"Behavior",defaultValue:true},enableCaseInsensitiveSearch:{type:"boolean",group:"Behavior",defaultValue:false,deprecated:false},allCount:{type:"int",group:"Appearance",defaultValue:null},sequence:{type:"int",group:"Behavior",defaultValue:-1},key:{type:"string",group:"Identification",defaultValue:null},showRemoveFacetIcon:{type:"boolean",group:"Misc",defaultValue:true},retainListSequence:{type:"boolean",group:"Misc",defaultValue:false},dataType:{type:"sap.m.FacetFilterListDataType",group:"Misc",defaultValue:g.String}},events:{listOpen:{allowPreventDefault:true},listClose:{parameters:{selectedItems:{type:"sap.m.FacetFilterItem[]"},allSelected:{type:"boolean"},selectedKeys:{type:"object"}}},search:{allowPreventDefault:true,parameters:{term:{type:"string"}}}}}});
h.prototype.setTitle=function(t){this.setProperty("title",t,true);this._updateFacetFilterButtonText();return this;};
h.prototype.setMultiSelect=function(v){this.setProperty("multiSelect",v,true);var m=v?f.MultiSelect:f.SingleSelectMaster;this.setMode(m);return this;};
h.prototype.setMode=function(m){if(m===f.MultiSelect||m===f.SingleSelectMaster){L.prototype.setMode.call(this,m);this.setProperty("multiSelect",m===f.MultiSelect?true:false,true);}return this;};
h.prototype._applySearch=function(){var s=this._getSearchValue();if(s===null){return;}this._bSearchEventDefaultBehavior&&this._search(s,true);this._updateSelectAllCheckBox();};
h.prototype.getSelectedItems=function(){var s=[];var o={};var i=L.prototype.getSelectedItems.apply(this,arguments);i.forEach(function(I){s.push(new b({text:I.getText(),key:I.getKey(),selected:true}));o[I.getKey()]=true;});var S=this.getSelectedKeys();var j=Object.getOwnPropertyNames(S);if(i.length<j.length){j.forEach(function(k){if(!o[k]){s.push(new b({text:S[k],key:k,selected:true}));}});}return s;};
h.prototype.getSelectedItem=function(){var i=L.prototype.getSelectedItem.apply(this,arguments);var s=Object.getOwnPropertyNames(this.getSelectedKeys());if(!i&&s.length>0){i=new b({text:this.getSelectedKeys()[s[0]],key:s[0],selected:true});}return i;};
h.prototype.removeSelections=function(A){if(this._allowRemoveSelections){A?this.setSelectedKeys():L.prototype.removeSelections.call(this,A);}return this;};
h.prototype.getSelectedKeys=function(){var r={};var k=this._oSelectedKeys;Object.getOwnPropertyNames(k).forEach(function(i){r[i]=k[i];});return r;};
h.prototype.setSelectedKeys=function(k){this._oSelectedKeys={};var K=false;k&&Object.getOwnPropertyNames(k).forEach(function(i){this._addSelectedKey(i,k[i]);K=true;},this);if(K){if(this.getMode()===f.MultiSelect){this.setActive(true);}this._selectItemsByKeys();}else{L.prototype.removeSelections.call(this);}};
h.prototype._getNonGroupItems=function(){var i=[];this.getItems().forEach(function(I){if(I.getMode()!==f.None){i.push(I);}});return i;};
h.prototype.removeSelectedKey=function(k,t){if(this._removeSelectedKey(k,t)){this._getNonGroupItems().forEach(function(i){var I=i.getKey()||i.getText();k===I&&i.setSelected(false);});}};
h.prototype.removeSelectedKeys=function(){this._oSelectedKeys={};L.prototype.removeSelections.call(this,true);};
h.prototype.removeItem=function(i){var I=L.prototype.removeItem.apply(this,arguments);if(!this._filtering){I&&I.getSelected()&&this.removeSelectedKey(I.getKey(),I.getText());return I;}};
h.prototype.init=function(){this._firstTime=true;this._bSearchEventDefaultBehavior=true;this._saveBindInfo;this._oSelectedKeys={};L.prototype.init.call(this);this.setMode(f.MultiSelect);this.setIncludeItemInSelection(true);this.setGrowing(true);this.setRememberSelections(false);this._searchValue="";this.attachUpdateFinished(function(E){var u=E.getParameter("reason");u=u?u.toLowerCase():u;if(u==="change"){var B=this.getBinding("items"),m=B?B.getModel():null;if(m&&m.getProperty(B.getPath())){this._iAllItemsCount=m.getProperty(B.getPath()).length||0;}this._oSelectedKeys={};this._getNonGroupItems().forEach(function(i){if(i.getSelected()){this._addSelectedKey(i.getKey(),i.getText());}},this);}if(u!==C.Filter.toLowerCase()){this._selectItemsByKeys();}this._updateFacetFilterButtonText();this._updateSelectAllCheckBox();});this._allowRemoveSelections=true;this._bOriginalActiveState;this._iAllItemsCount;};
h.prototype._resetItemsBinding=function(){if(this.isBound("items")){this._setSearchValue("");this._allowRemoveSelections=false;L.prototype._resetItemsBinding.apply(this,arguments);this._allowRemoveSelections=true;}};
h.prototype._fireListCloseEvent=function(){var s=this.getSelectedItems();var S=this.getSelectedKeys();var A=s.length===0;this._firstTime=true;this.fireListClose({selectedItems:s,selectedKeys:S,allSelected:A});};
h.prototype._updateActiveState=function(){var o=sap.ui.getCore().byId(this.getAssociation("allcheckbox"));if(Object.getOwnPropertyNames(this._oSelectedKeys).length>0||(o&&o.getSelected())){this.setActive(true);}};
h.prototype._handleSearchEvent=function(E){var s=E.getParameters()["query"];if(s===undefined){s=E.getParameters()["newValue"];}this._bSearchEventDefaultBehavior=this.fireSearch({term:s,clearButtonPressed:E.getParameters()["clearButtonPressed"]});this._bSearchEventDefaultBehavior?this._search(s):this._setSearchValue(s);this._updateSelectAllCheckBox();};
h.prototype._search=function(s,i){var j,B,u,U,p,o,P,k,n=0,m=this.getBinding("items"),q=this.getBindingInfo("items");function r(M){return M instanceof sap.ui.model.odata.ODataModel||M instanceof sap.ui.model.odata.v2.ODataModel||M instanceof sap.ui.model.odata.v4.ODataModel;}if(i||(s!==this._searchValue)){this._searchValue=s;if(q&&q.binding){j=q.binding.aFilters;if(j.length>0){n=j[0].aFilters.length;if(this._firstTime){this._saveBindInfo=j[0].aFilters[0][0];this._firstTime=false;}}}if(m){if(s||n>0){k=q.template?q.template:q.factory();B=k.getBindingInfo("text").parts;p=B[0].path;if(p||p===""){u=[];B.forEach(function(t){u.push(new F(t.path,d.Contains,s));});if(this.getEnableCaseInsensitiveSearch()&&r(m.getModel())){u.forEach(function(t){t.bCaseSensitive=false;});}P=new F(u,false);if(n>1){o=new F([P,this._saveBindInfo],true);}else{if(this._saveBindInfo>""&&U.sPath!=this._saveBindInfo.sPath){o=new F([P,this._saveBindInfo],true);}else{if(s==""){o=[];}else{o=new F([P],true);}}}m.filter(o,e.Control);}}else{m.filter([],e.Control);}}else{c.warning("No filtering performed","The list must be defined with a binding for search to work",this);}}};
h.prototype._getSearchValue=function(){return this._searchValue;};
h.prototype._updateSelectAllCheckBox=function(){var i=this._getNonGroupItems(),I=i.length,o,A,s;function j(k){return k.getSelected();}if(this.getMultiSelect()){o=sap.ui.getCore().byId(this.getAssociation("allcheckbox"));A=I>0&&I===i.filter(j).length;s=this.getActive()&&A;o&&o.setSelected(s);}};
h.prototype._addSelectedKey=function(k,t){if(!k&&!t){c.error("Both sKey and sText are not defined. At least one must be defined.");return;}if(this.getMode()===f.SingleSelectMaster){this.removeSelectedKeys();}if(!k){k=t;}this._oSelectedKeys[k]=t||k;};
h.prototype._removeSelectedKey=function(k,t){if(!k&&!t){c.error("Both sKey and sText are not defined. At least one must be defined.");return false;}if(!k){k=t;}delete this._oSelectedKeys[k];return true;};
h.prototype._setSearchValue=function(v){this._searchValue=v;};
h.prototype._isItemSelected=function(i){return!!(this._oSelectedKeys[i&&(i.getKey()||i.getText())]);};
h.prototype._updateFacetFilterButtonText=function(){if(this.getParent()&&this.getParent()._setButtonText){this.getParent()._setButtonText(this);}};
h.prototype._selectItemsByKeys=function(){this._getNonGroupItems().forEach(function(i){i.setSelected(this._isItemSelected(i));},this);this._updateFacetFilterButtonText();};
h.prototype._handleSelectAllClick=function(s){var A,i,I=this._getNonGroupItems(),j=I.length;I.forEach(function(o){if(s){this._addSelectedKey(o.getKey(),o.getText());}else{this._removeSelectedKey(o.getKey(),o.getText());}o.setSelected(s,true);},this);function k(o){return o.getSelected();}if(this.getMode()===f.MultiSelect){i=j>0&&j===I.filter(k).length;A=this._getOriginalActiveState()||(s&&i);this.setActive(A);}setTimeout(this._updateSelectAllCheckBox.bind(this),0);};
h.prototype.onItemTextChange=function(i,n){var k=i.getKey();if(this._oSelectedKeys[k]&&n&&!this._filtering){this._oSelectedKeys[k]=n;}};
h.prototype.onItemSelectedChange=function(i,s){var A;if(s){this._addSelectedKey(i.getKey(),i.getText());}else{this._removeSelectedKey(i.getKey(),i.getText());}L.prototype.onItemSelectedChange.apply(this,arguments);if(this.getMode()===f.MultiSelect){A=this._getOriginalActiveState()||s||this.getSelectedItems().length>1;this.setActive(A);}!this.getDomRef()&&this.getParent()&&this.getParent().getDomRef()&&this.getParent().invalidate();setTimeout(this._updateSelectAllCheckBox.bind(this),0);};
h.prototype.updateItems=function(r){var p=document.activeElement;this._filtering=r===C.Filter;L.prototype.updateItems.apply(this,arguments);this._filtering=false;if(p&&p.getAttribute("id")!==document.activeElement.getAttribute("id")){this.focus();}if(!this.getGrowing()||r===C.Filter){this._selectItemsByKeys();}};
h.prototype._getOriginalActiveState=function(){return this._bOriginalActiveState;};
h.prototype._preserveOriginalActiveState=function(){this._bOriginalActiveState=this.getActive();};
h.prototype._showBusyIndicator=function(){L.prototype._showBusyIndicator.apply(this,arguments);this.fireEvent("listItemsChange");};
h.prototype._hideBusyIndicator=function(){L.prototype._hideBusyIndicator.apply(this,arguments);this.fireEvent("listItemsChange");};
return h;});
sap.ui.predefine('sap/m/FacetFilterListRenderer',['./ListRenderer','sap/ui/core/Renderer'],function(L,R){"use strict";var F=R.extend(L);F.apiVersion=2;return F;},true);
sap.ui.predefine('sap/m/FacetFilterRenderer',["sap/m/library","sap/ui/Device","sap/ui/core/InvisibleText"],function(l,D,I){"use strict";var F=l.FacetFilterType;var a={apiVersion:2};
a.render=function(r,c){if(c.getType()===F.Light||c.getShowSummaryBar()){a.renderSummaryBar(r,c);}else{a.renderSimpleFlow(r,c);}};
a.renderSimpleFlow=function(r,c){r.openStart("div",c);r.class("sapMFF");r.accessibilityState({role:"toolbar",roledescription:c._bundle.getText("FACETFILTER_TITLE")});if(c._lastScrolling){r.class("sapMFFScrolling");}else{r.class("sapMFFNoScrolling");}if(c.getShowReset()){r.class("sapMFFResetSpacer");}r.openEnd();if(D.system.desktop){r.renderControl(c._getScrollingArrow("left"));}r.openStart("div",c.getId()+"-head");r.class("sapMFFHead");r.openEnd();a.renderFacetFilterListButtons(c,r);if(c.getShowPersonalization()){a.renderAddFilterButton(c,r);}r.close("div");if(D.system.desktop){r.renderControl(c._getScrollingArrow("right"));}if(c.getShowReset()){r.openStart("div");r.class("sapMFFResetDiv");r.openEnd();r.renderControl(c.getAggregation("resetButton"));r.close("div");}r.close("div");};
a.renderSummaryBar=function(r,c){r.openStart("div",c);r.class("sapMFF");r.openEnd();r.renderControl(c.getAggregation("summaryBar"));r.close("div");};
a.getAriaAnnouncement=function(k,b){return I.getStaticId("sap.m",b||"FACETFILTER_"+k.toUpperCase());};
a.renderFacetFilterListButtons=function(c,r){var L=c._getSequencedLists(),b=L.length,s=c.getShowPersonalization(),A=s&&(c.getType()===F.Simple),f=A?b+1:b,B,i;for(i=0;i<b;i++){var d=L[i].getItems().length>0,e=L[i].getActive(),g=c._bCheckForAddListBtn&&(d||e);if(!c._bCheckForAddListBtn||g){B=c._getButtonForList(L[i]);a.addPositionInfoForButton(c,B,i+1,f);if(s){B.addAriaDescribedBy(a.getAriaAnnouncement("ARIA_REMOVE"));}r.renderControl(B);if(s){r.renderControl(c._getFacetRemoveIcon(L[i]));}}}return this;};
a.renderAddFilterButton=function(c,r){var A=c.getAggregation("addFacetButton"),b=c._getSequencedLists().length+1;a.addPositionInfoForButton(c,A,b,b);r.renderControl(A);return this;};
a.addPositionInfoForButton=function(c,b,p,s){var S=a.createStaticPositioningLabel(c,p,s);a.clearOldPositioningLabels(c,b);b.addAriaDescribedBy(S);return this;};
a.clearOldPositioningLabels=function(c,b){var o=b.removeAllAriaDescribedBy(),r=this.getAriaAnnouncement("ARIA_REMOVE"),i;o.forEach(function(s){if(r===s){return;}i=sap.ui.getCore().byId(s);i&&i.destroy();});return this;};
a.createStaticPositioningLabel=function(c,p,s){var r=sap.ui.getCore().getLibraryResourceBundle("sap.m"),f=r.getText("FACETFILTER_ARIA_FACET_FILTER"),P=r.getText("FACETFILTERLIST_ARIA_POSITION",[p,s]),S=new I({text:f+" "+P}).toStatic();c._aOwnedLabels.push(S.getId());return S;};
return a;},true);
sap.ui.predefine('sap/m/FeedContent',['./library','sap/ui/core/Control','sap/m/Text','sap/ui/Device','./FeedContentRenderer',"sap/ui/events/KeyCodes"],function(l,C,T,D,F,K){"use strict";var S=l.Size;
var a=C.extend("sap.m.FeedContent",{metadata:{library:"sap.m",properties:{"size":{type:"sap.m.Size",group:"Misc",defaultValue:S.Auto},"contentText":{type:"string",group:"Misc",defaultValue:null},"subheader":{type:"string",group:"Misc",defaultValue:null},"value":{type:"string",group:"Misc",defaultValue:null},"valueColor":{type:"sap.m.ValueColor",group:"Misc",defaultValue:null},"truncateValueTo":{type:"int",group:"Misc",defaultValue:4}},defaultAggregation:"_contentTextAgr",aggregations:{"_contentTextAgr":{type:"sap.m.Text",multiple:false,visibility:"hidden"}},events:{"press":{}}}});
a.prototype.init=function(){this._oContentText=new T(this.getId()+"-content-text",{maxLines:2});this._oContentText.cacheLineHeight=false;this.setAggregation("_contentTextAgr",this._oContentText,true);this.setTooltip("{AltText}");};
a.prototype.onBeforeRendering=function(){this.$().off("mouseenter");this.$().off("mouseleave");};
a.prototype.onAfterRendering=function(){this.$().on("mouseenter",this._addTooltip.bind(this));this.$().on("mouseleave",this._removeTooltip.bind(this));};
a.prototype.exit=function(){this._oContentText=null;};
a.prototype._addTooltip=function(){this.$().attr("title",this.getTooltip_AsString());};
a.prototype._removeTooltip=function(){this.$().attr("title",null);};
a.prototype.getAltText=function(){var A="";var i=true;if(this.getAggregation("_contentTextAgr").getText()){A+=this.getAggregation("_contentTextAgr").getText();i=false;}if(this.getSubheader()){if(i){A+=""+this.getSubheader();}else{A+="\n"+this.getSubheader();}i=false;}if(this.getValue()){if(i){A+=""+this.getValue();}else{A+="\n"+this.getValue();}}return A;};
a.prototype.getTooltip_AsString=function(){var t=this.getTooltip();var s=this.getAltText();if(typeof t==="string"||t instanceof String){s=t.split("{AltText}").join(s).split("((AltText))").join(s);return s;}if(t){return t;}else{return"";}};
a.prototype.setContentText=function(t){this._oContentText.setText(t);return this;};
a.prototype.ontap=function(e){if(D.browser.msie){this.$().trigger("focus");}this.firePress();};
a.prototype.onkeydown=function(e){if(e.which===K.ENTER||e.which===K.SPACE){this.firePress();e.preventDefault();}};
a.prototype.attachEvent=function(e,d,f,b){C.prototype.attachEvent.call(this,e,d,f,b);if(this.hasListeners("press")){this.$().attr("tabindex",0).addClass("sapMPointer");}return this;};
a.prototype.detachEvent=function(e,f,b){C.prototype.detachEvent.call(this,e,f,b);if(!this.hasListeners("press")){this.$().removeAttr("tabindex").removeClass("sapMPointer");}return this;};
return a;});
sap.ui.predefine('sap/m/FeedContentRenderer',[],function(){"use strict";var F={};
F.render=function(r,c){var s=c.getSubheader();var v=c.getValue();var t=c.getTooltip_AsString();if(typeof t!=="string"){t="";}r.write("<div");r.writeControlData(c);r.writeAttribute("role","presentation");r.writeAttributeEscaped("aria-label",t);r.addClass("sapMFC");if(c.hasListeners("press")){r.writeAttribute("tabindex","0");r.addClass("sapMPointer");}r.writeClasses();r.write(">");if(v){r.write("<div");r.writeAttribute("id",c.getId()+"-value");r.addClass("sapMFCValue");r.addClass(c.getValueColor());r.writeClasses();r.write(">");var C=c.getTruncateValueTo();if(v.length>=C&&(v[C-1]==="."||v[C-1]===",")){r.writeEscaped(v.substring(0,C-1));}else if(v){r.writeEscaped(v.substring(0,C));}else{r.writeEscaped("");}r.write("</div>");}r.write("<div");r.addClass("sapMFCCTxt");r.writeClasses();r.write(">");r.renderControl(c._oContentText);r.write("</div>");r.write("<div");r.writeAttribute("id",c.getId()+"-subheader");r.addClass("sapMFCSbh");r.writeClasses();r.write(">");r.writeEscaped(s);r.write("</div>");r.write("</div>");};
return F;},true);
sap.ui.predefine('sap/m/FeedInput',["./library","sap/ui/core/Control","sap/ui/core/IconPool","sap/m/TextArea","sap/m/Button","./FeedInputRenderer","sap/ui/thirdparty/jquery","sap/base/security/URLWhitelist","sap/base/security/sanitizeHTML"],function(l,C,I,T,B,F,q,U,s){"use strict";var a=l.ButtonType;var M=15,b=2,c=0;
var d=C.extend("sap.m.FeedInput",{metadata:{library:"sap.m",designtime:"sap/m/designtime/FeedInput.designtime",properties:{enabled:{type:"boolean",group:"Behavior",defaultValue:true},rows:{type:"int",group:"Appearance",defaultValue:2},showExceededText:{type:"boolean",group:"Behavior",defaultValue:false},maxLength:{type:"int",group:"Behavior",defaultValue:0},growing:{type:"boolean",group:"Behavior",defaultValue:false},growingMaxLines:{type:"int",group:"Behavior",defaultValue:0},placeholder:{type:"string",group:"Appearance",defaultValue:"Post something here"},value:{type:"string",group:"Data",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},showIcon:{type:"boolean",group:"Behavior",defaultValue:true},iconDensityAware:{type:"boolean",group:"Appearance",defaultValue:true},buttonTooltip:{type:"sap.ui.core.TooltipBase",group:"Accessibility",defaultValue:"Submit"},ariaLabelForPicture:{type:"string",group:"Accessibility",defaultValue:null}},events:{post:{parameters:{value:{type:"string"}}}}}});
var _={ATTRIBS:{'style':1,'class':1,'a::href':1,'a::target':1},ELEMENTS:{'a':{cssClass:'sapMLnk'},'abbr':1,'blockquote':1,'br':1,'cite':1,'code':1,'em':1,'h1':{cssClass:'sapMTitle sapMTitleStyleH1'},'h2':{cssClass:'sapMTitle sapMTitleStyleH2'},'h3':{cssClass:'sapMTitle sapMTitleStyleH3'},'h4':{cssClass:'sapMTitle sapMTitleStyleH4'},'h5':{cssClass:'sapMTitle sapMTitleStyleH5'},'h6':{cssClass:'sapMTitle sapMTitleStyleH6'},'p':1,'pre':1,'strong':1,'span':1,'u':1,'dl':1,'dt':1,'dd':1,'ol':1,'ul':1,'li':1}};d.prototype._renderingRules=_;
function S(t,e){var f,v,g=t==="a";var h=this._renderingRules.ELEMENTS[t].cssClass||"";for(var i=0;i<e.length;i+=2){f=e[i];v=e[i+1];if(!this._renderingRules.ATTRIBS[f]&&!this._renderingRules.ATTRIBS[t+"::"+f]){e[i+1]=null;continue;}if(f=="href"){if(!U.validate(v)){e[i+1]="#";g=false;}}if(f=="target"){g=false;}if(h&&f.toLowerCase()=="class"){e[i+1]=h+" "+v;h="";}}if(g){e.push("target");e.push("_blank");}if(h){e.push("class");e.push(h);}return e;}
function p(t,e){return S.call(this,t,e);}
d.prototype._sanitizeHTML=function(t){return s(t,{tagPolicy:p.bind(this),uriRewriter:function(u){if(U.validate(u)){return u;}}});};
d.prototype.init=function(){var o=sap.ui.getCore().getLibraryResourceBundle("sap.m");this.setProperty("placeholder",o.getText("FEEDINPUT_PLACEHOLDER"),true);this.setProperty("buttonTooltip",o.getText("FEEDINPUT_SUBMIT"),true);};
d.prototype.exit=function(){if(this._oTextArea){this._oTextArea.destroy();}if(this._oButton){this._oButton.destroy();}if(this._oImageControl){this._oImageControl.destroy();}};
d.prototype.setIconDensityAware=function(i){this.setProperty("iconDensityAware",i,true);var f=sap.ui.require("sap/m/Image");if(this._getImageControl()instanceof f){this._getImageControl().setDensityAware(i);}return this;};
d.prototype.setRows=function(r){var m=this.getProperty("growingMaxLines");if(r>M){r=M;}else if(r<b){r=b;}if(r>m&&m!==0){this.setProperty("growingMaxLines",r,true);this._getTextArea().setGrowingMaxLines(r);}this.setProperty("rows",r,true);this._getTextArea().setRows(r);return this;};
d.prototype.setShowExceededText=function(v){this.setProperty("showExceededText",v,true);this._getTextArea().setShowExceededText(v);return this;};
d.prototype.setMaxLength=function(m){this.setProperty("maxLength",m,true);this._getTextArea().setMaxLength(m);return this;};
d.prototype.setGrowing=function(g){this.setProperty("growing",g,true);this._getTextArea().setGrowing(g);return this;};
d.prototype.setGrowingMaxLines=function(m){var r=this.getProperty("rows");if(m!==c){if(m<r){m=r;}else if(m>M){m=M;}}this.setProperty("growingMaxLines",m,true);this._getTextArea().setGrowingMaxLines(m);return this;};
d.prototype.setValue=function(v){this.setProperty("value",v,true);this._getTextArea().setValue(v);this._enablePostButton();return this;};
d.prototype.setPlaceholder=function(v){this.setProperty("placeholder",v,true);this._getTextArea().setPlaceholder(v);return this;};
d.prototype.setEnabled=function(e){this.setProperty("enabled",e,true);if(this.getDomRef("outerContainer")){if(e){this.getDomRef("outerContainer").classList.remove("sapMFeedInDisabled");}else{this.getDomRef("outerContainer").classList.add("sapMFeedInDisabled");}}this._getTextArea().setEnabled(e);this._enablePostButton();return this;};
d.prototype.setButtonTooltip=function(v){this.setProperty("buttonTooltip",v,true);this._getPostButton().setTooltip(v);return this;};
d.prototype._getTextArea=function(){var t=this;if(!this._oTextArea){this._oTextArea=new T(this.getId()+"-textArea",{value:this.getValue(),maxLength:this.getMaxLength(),placeholder:this.getPlaceholder(),growing:this.getGrowing(),growingMaxLines:this.getGrowingMaxLines(),showExceededText:this.getShowExceededText(),rows:this.getRows(),liveChange:q.proxy(function(e){var v=e.getParameter("value");this.setProperty("value",v,true);this._enablePostButton();},this)});this._oTextArea.setParent(this);this._oTextArea.addEventDelegate({onAfterRendering:function(){t.$("counterContainer").empty();t.$("counterContainer").html(t._oTextArea.getAggregation("_counter").$());}});}return this._oTextArea;};
d.prototype._getPostButton=function(){if(!this._oButton){this._oButton=new B(this.getId()+"-button",{enabled:false,type:a.Default,icon:"sap-icon://feeder-arrow",tooltip:this.getButtonTooltip(),press:q.proxy(function(){this._oTextArea.focus();this.firePost({value:this._sanitizeHTML(this.getValue())});this.setValue(null);},this)});this._oButton.setParent(this);}return this._oButton;};
d.prototype._enablePostButton=function(){var P=this._isControlEnabled();var o=this._getPostButton();o.setEnabled(P);};
d.prototype._isControlEnabled=function(){var v=this.getValue();return this.getEnabled()&&(typeof v==="string"||v instanceof String)&&v.trim().length>0;};
d.prototype._getImageControl=function(){var i=this.getIcon()||I.getIconURI("person-placeholder"),e=this.getId()+'-icon',P={src:i,alt:this.getAriaLabelForPicture(),densityAware:this.getIconDensityAware(),decorative:false,useIconTooltip:false},f=['sapMFeedInImage'];this._oImageControl=l.ImageHelper.getImageControl(e,this._oImageControl,this,P,f);return this._oImageControl;};
return d;});
sap.ui.predefine('sap/m/FeedInputRenderer',[],function(){"use strict";var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");var F={};
F.render=function(R,c){var m=c.getId();R.write("<div");R.writeControlData(c);R.addClass("sapMFeedInBase");R.writeAttribute("role","group");R.writeAttributeEscaped("aria-label",r.getText("FEED_INPUT_ARIA_LABEL"));R.writeClasses();R.write(">");R.write('<div id="'+m+'-outerContainer"');R.addClass("sapMFeedIn");if(!c.getShowIcon()){R.addClass("sapMFeedInNoIcon");}if(!c.getEnabled()){R.addClass("sapMFeedInDisabled");}R.writeClasses();R.write(">");if(!!c.getShowIcon()){this._addImage(R,c,m);}R.write('<div id="'+m+'-container"');R.addClass("sapMFeedInContainer");R.writeClasses();R.write(">");var t=c._getTextArea();R.renderControl(t);R.renderControl(c._getPostButton());R.write("</div>");R.write("</div>");R.write('<div id="'+m+'-counterContainer"');R.addClass("sapMFeedInCounter");R.writeClasses();R.write(">");R.write("</div>");R.write("</div>");};
F._addImage=function(R,c,m){R.write('<figure id="'+m+'-figure" class ="sapMFeedInFigure');if(!!c.getIcon()){R.write('">');}else{R.write(' sapMFeedListItemIsDefaultIcon">');}R.renderControl(c._getImageControl());R.write('</figure>');};
return F;},true);
sap.ui.predefine('sap/m/FeedListItem',["./ListItemBase","./Link","./library","./FormattedText","sap/ui/core/Control","sap/ui/core/IconPool","sap/m/Button","sap/ui/Device","./FeedListItemRenderer"],function(L,a,l,F,C,I,B,D,b){"use strict";var c=l.ListType;var d=l.ImageHelper;var e=l.LinkConversion;var f=l.ButtonType;
var g=L.extend("sap.m.FeedListItem",{metadata:{library:"sap.m",designtime:"sap/m/designtime/FeedListItem.designtime",properties:{icon:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},activeIcon:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},sender:{type:"string",group:"Data",defaultValue:null},text:{type:"string",group:"Data",defaultValue:null},moreLabel:{type:"string",group:"Data",defaultValue:null},lessLabel:{type:"string",group:"Data",defaultValue:null},info:{type:"string",group:"Data",defaultValue:null},timestamp:{type:"string",group:"Data",defaultValue:null},senderActive:{type:"boolean",group:"Behavior",defaultValue:true},iconActive:{type:"boolean",group:"Behavior",defaultValue:true},iconDensityAware:{type:"boolean",defaultValue:true},showIcon:{type:"boolean",group:"Behavior",defaultValue:true},convertLinksToAnchorTags:{type:"sap.m.LinkConversion",group:"Behavior",defaultValue:e.None},convertedLinksDefaultTarget:{type:"string",group:"Behavior",defaultValue:"_blank"},maxCharacters:{type:"int",group:"Behavior",defaultValue:null}},defaultAggregation:"actions",aggregations:{actions:{type:"sap.m.FeedListItemAction",multiple:true},_text:{type:"sap.m.FormattedText",multiple:false,visibility:"hidden"},_actionSheet:{type:"sap.m.ActionSheet",multiple:false,visibility:"hidden"},_actionButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},events:{senderPress:{parameters:{domRef:{type:"string"},getDomRef:{type:"function"}}},iconPress:{parameters:{domRef:{type:"string"},getDomRef:{type:"function"}}}}}});
g._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");g._nMaxCharactersMobile=300;g._nMaxCharactersDesktop=500;g._sTextShowMore=g._oRb.getText("TEXT_SHOW_MORE");g._sTextShowLess=g._oRb.getText("TEXT_SHOW_LESS");
g.prototype.init=function(){L.prototype.init.apply(this);this.setAggregation("_text",new F(this.getId()+"-formattedText"),true);this.setAggregation("_actionButton",new B({id:this.getId()+"-actionButton",type:f.Transparent,icon:"sap-icon://overflow",press:[this._onActionButtonPress,this]}),true);};
g.prototype._onActionButtonPress=function(){sap.ui.require(["sap/m/ActionSheet"],this._openActionSheet.bind(this));};
g.prototype._openActionSheet=function(A){var o=this.getAggregation("_actionSheet");var h=this.getActions();var j;if(!(o&&o instanceof A)){o=new A({id:this.getId()+"-actionSheet",beforeOpen:[this._onBeforeOpenActionSheet,this]});this.setAggregation("_actionSheet",o,true);}o.destroyAggregation("buttons",true);for(var i=0;i<h.length;i++){j=h[i];o.addButton(new B({icon:j.getIcon(),text:j.getText(),press:j.firePress.bind(j,{"item":this})}));}o.openBy(this.getAggregation("_actionButton"));};
g.prototype._onBeforeOpenActionSheet=function(h){var A,t;if(D.system.phone){return;}t=sap.ui.getCore().getConfiguration().getTheme();A=h.getSource().getParent();A.removeStyleClass("sapContrast sapContrastPlus");if(t==="sap_belize"){A.addStyleClass("sapContrast");}else if(t==="sap_belize_plus"){A.addStyleClass("sapContrastPlus");}};
g.prototype.invalidate=function(){C.prototype.invalidate.apply(this,arguments);var m=g._sTextShowMore;if(this.getMoreLabel()){m=this.getMoreLabel();}delete this._bTextExpanded;if(this._oLinkExpandCollapse){this._oLinkExpandCollapse.setProperty("text",m,true);}};
g.prototype.onBeforeRendering=function(){this.$("realtext").find('a[target="_blank"]').off("click");var o=this.getAggregation("_text");o.setProperty("convertLinksToAnchorTags",this.getConvertLinksToAnchorTags(),true);o.setProperty("convertedLinksDefaultTarget",this.getConvertedLinksDefaultTarget(),true);if(this.getConvertLinksToAnchorTags()===l.LinkConversion.None){o.setHtmlText(this.getText());}else{o.setProperty("htmlText",this.getText(),true);}this._sFullText=o._getDisplayHtml().replace(/\n/g,"<br>");this._sShortText=this._getCollapsedText();if(this._sShortText){this._sShortText=this._sShortText.replace(/<br>/g," ");}this._bEmptyTagsInShortTextCleared=false;};
g.prototype.onAfterRendering=function(){if(document.getElementById(this.getAggregation("_actionButton"))){document.getElementById(this.getAggregation("_actionButton").getId()).setAttribute("aria-haspopup","menu");}if(this._checkTextIsExpandable()&&!this._bTextExpanded){this._clearEmptyTagsInCollapsedText();}var r=this.$("realtext");F.prototype.onAfterRendering.apply({$:function(){return r;}});};
g.prototype.exit=function(){this.$("realtext").find('a[target="_blank"]').off("click");if(this._oLinkControl){this._oLinkControl.destroy();}if(this._oImageControl){this._oImageControl.destroy();}if(this._oLinkExpandCollapse){this._oLinkExpandCollapse.destroy();}L.prototype.exit.apply(this);};
g.prototype.ontap=function(E){if(E.srcControl){if((!this.getIconActive()&&this._oImageControl&&E.srcControl.getId()===this._oImageControl.getId())||(!this.getSenderActive()&&this._oLinkControl&&E.srcControl.getId()===this._oLinkControl.getId())||(!this._oImageControl||(E.srcControl.getId()!==this._oImageControl.getId())&&(!this._oLinkControl||(E.srcControl.getId()!==this._oLinkControl.getId()))&&(!this._oLinkExpandCollapse||(E.srcControl.getId()!==this._oLinkExpandCollapse.getId())))){L.prototype.ontap.apply(this,[E]);}}};
g.prototype.onfocusin=function(E){if(this._oImageControl){var $=this.$("icon");if(E.target.id===this.getId()){$.removeAttr("alt");}else{$.attr("alt"," ");}}var i=E.srcControl,o=i.getDomRef(),p=this.getParent().getAccessbilityPosition(i);if(i instanceof sap.m.FeedListItem){o.setAttribute("aria-posinset",p.posInset);o.setAttribute("aria-setsize",p.setSize);}};
g.prototype._getImageControl=function(){var i=this.getIcon();var s=i?i:I.getIconURI("person-placeholder");var h=this.getId()+'-icon';var p={src:s,alt:this.getSender(),densityAware:this.getIconDensityAware(),decorative:false,useIconTooltip:false};var j;if(this.getIconActive()){j=['sapMFeedListItemImage'];}else{j=['sapMFeedListItemImageInactive'];}var t=this;this._oImageControl=d.getImageControl(h,this._oImageControl,this,p,j);if(this.getIconActive()){if(!this._oImageControl.hasListeners("press")){this._oImageControl.attachPress(function(){t.fireIconPress({domRef:this.getDomRef(),getDomRef:this.getDomRef.bind(this)});});}}return this._oImageControl;};
g.prototype._getLinkSender=function(w){if(!this._oLinkControl){var t=this;this._oLinkControl=new a({press:function(){t.fireSenderPress({domRef:this.getDomRef(),getDomRef:this.getDomRef.bind(this)});}});this._oLinkControl.setParent(this,null,true);}if(w){this._oLinkControl.setProperty("text",this.getSender()+g._oRb.getText("COLON"),true);}else{this._oLinkControl.setProperty("text",this.getSender(),true);}this._oLinkControl.setProperty("enabled",this.getSenderActive(),true);return this._oLinkControl;};
g.prototype._activeHandlingInheritor=function(){var A=this.getActiveIcon();if(this._oImageControl&&A){this._oImageControl.setSrc(A);}};
g.prototype._inactiveHandlingInheritor=function(){var s=this.getIcon()?this.getIcon():I.getIconURI("person-placeholder");if(this._oImageControl){this._oImageControl.setSrc(s);}};
g.prototype._getCollapsedText=function(){this._nMaxCollapsedLength=this.getMaxCharacters();if(this._nMaxCollapsedLength===0){if(D.system.phone){this._nMaxCollapsedLength=g._nMaxCharactersMobile;}else{this._nMaxCollapsedLength=g._nMaxCharactersDesktop;}}var p=this._convertHtmlToPlainText(this._sFullText);var t=null;if(p&&p.length>this._nMaxCollapsedLength){var s=p.substring(0,this._nMaxCollapsedLength);var n=s.lastIndexOf(" ");if(n>0){s=s.substr(0,n);}if(p.length===this._sFullText.length){t=s;}else{t=this._convertPlainToHtmlText(s);}}return t;};
g.prototype._clearEmptyTagsInCollapsedText=function(){var r;if(this._bEmptyTagsInShortTextCleared){return;}this._bEmptyTagsInShortTextCleared=true;do{r=this.$("realtext").find(":empty").remove();}while(r.length>0);this._sShortText=this.$("realtext").html();};
g.prototype._toggleTextExpanded=function(){var $=this.$("realtext");var h=this.$("threeDots");var m=g._sTextShowMore;var s=g._sTextShowLess;if(this.getMoreLabel()){m=this.getMoreLabel();}if(this.getLessLabel()){s=this.getLessLabel();}if(this._bTextExpanded){$.html(this._sShortText.replace(/&#xa;/g,"<br>"));h.text(" ... ");this._oLinkExpandCollapse.setText(m);this._bTextExpanded=false;this._clearEmptyTagsInCollapsedText();}else{$.html(this._sFullText.replace(/&#xa;/g,"<br>"));h.text("  ");this._oLinkExpandCollapse.setText(s);this._bTextExpanded=true;}};
g.prototype._getLinkExpandCollapse=function(){var m=g._sTextShowMore;if(this.getMoreLabel()){m=this.getMoreLabel();}if(!this._oLinkExpandCollapse){this._oLinkExpandCollapse=new a({text:m,press:[this._toggleTextExpanded,this]});this._bTextExpanded=false;this._oLinkExpandCollapse.setParent(this,null,true);}return this._oLinkExpandCollapse;};
g.prototype._convertHtmlToPlainText=function(h){var r=/(<([^>]+)>)/ig;return h.replace(r,"");};
g.prototype._convertPlainToHtmlText=function(h){var s=this._sFullText;var r=/(<([^>]+)>)/ig;var E=s.split(r);var t="";for(var i=0;i<E.length;i++){if(E[i].length===0){continue;}if(h.length>0&&E[i].indexOf(h.trim())!==-1){E[i]=h;}if(/^<.+>$/.test(E[i])){t=t+E[i];E[i+1]="";continue;}if(h.indexOf(E[i].trim())===-1){continue;}else{h=h.replace(E[i],"");}t=t+E[i];}return t;};
g.prototype._checkTextIsExpandable=function(){return this._sShortText!==null;};
g.prototype.setType=function(t){if(this.getType()!==t){if(t===c.Navigation){this.setProperty("type",c.Active);}else{this.setProperty("type",t);}}return this;};
return g;});
sap.ui.predefine('sap/m/FeedListItemAction',["sap/ui/core/Element"],function(E){"use strict";
var F=E.extend("sap.m.FeedListItemAction",{metadata:{library:"sap.m",properties:{icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},text:{type:"string",group:"Misc",defaultValue:""},key:{type:"string",group:"Misc",defaultValue:""}},events:{press:{}}}});
return F;});
sap.ui.predefine('sap/m/FeedListItemRenderer',["./ListItemBaseRenderer","sap/ui/core/Renderer","sap/ui/Device"],function(L,R,D){"use strict";var F=R.extend(L);
F.renderLIAttributes=function(r,c){r.addClass("sapMFeedListItemTitleDiv");r.addClass("sapMFeedListShowSeparatorsAll");};
F.renderLIContent=function(r,c){var m=c.getId(),i=D.system.phone;r.write('<div');r.addClass('sapMFeedListItem');r.writeClasses();r.write('>');if(c.getShowIcon()){this._writeImageControl(r,c,m);}if(c.getActions().length>0){r.write("<div");r.writeAttributeEscaped("id",m+"-action-button");r.addClass('sapMFeedListItemActionButton');r.writeClasses();r.write(">");r.renderControl(c.getAggregation("_actionButton"));r.write("</div>");}if(i){r.write('<div class= "sapMFeedListItemHeader sapUiSelectable ');if(c.getShowIcon()){r.write('sapMFeedListItemHasFigure ');}if(c.getSender()&&c.getTimestamp()){r.write('sapMFeedListItemFullHeight');}r.write('" >');if(c.getSender()){r.write('<p id="'+m+'-name" class="sapMFeedListItemTextName sapUiSelectable">');r.renderControl(c._getLinkSender(false));r.write('</p>');}if(c.getTimestamp()){r.write('<p id="'+m+'-timestamp" class="sapMFeedListItemTimestamp sapUiSelectable">');r.writeEscaped(c.getTimestamp());r.write('</p>');}r.write('</div>');r.write('<div class="sapMFeedListItemText sapUiSelectable">');this._writeText(r,c,m,i);if(c._checkTextIsExpandable()){this._writeCollapsedText(r,c,m);}else{r.write(c._sFullText);r.write('</span>');}r.write('</div>');if(c.getInfo()){r.write('<p class="sapMFeedListItemFooter sapUiSelectable">');if(c.getInfo()){r.write('<span id="'+m+'-info" class="sapMFeedListItemInfo sapUiSelectable">');r.writeEscaped(c.getInfo());r.write('</span>');}r.write('</p>');}}else{r.write('<div class= "sapMFeedListItemText ');if(c.getShowIcon()){r.write('sapMFeedListItemHasFigure');}r.write('" >');r.write('<div id="'+m+'-text" class="sapMFeedListItemTextText sapUiSelectable">');if(c.getSender()){r.write('<span id="'+m+'-name" class="sapMFeedListItemTextName sapUiSelectable">');r.renderControl(c._getLinkSender(true));r.write('</span>');}this._writeText(r,c,m,i);if(c._checkTextIsExpandable()){this._writeCollapsedText(r,c,m);}else{r.write(c._sFullText);r.write('</span>');}r.write('</div>');if(c.getInfo()||c.getTimestamp()){r.write('<p class="sapMFeedListItemFooter sapUiSelectable">');if(!sap.ui.getCore().getConfiguration().getRTL()){if(c.getInfo()){this._writeInfo(r,c,m);if(c.getTimestamp()){r.write("<span>&#160&#160&#x00B7&#160&#160</span>");}}if(c.getTimestamp()){this._writeTimestamp(r,c,m);}}else{if(c.getTimestamp()){this._writeTimestamp(r,c,m);}if(c.getInfo()){if(c.getTimestamp()){r.write("<span>&#160&#160&#x00B7&#160&#160</span>");}this._writeInfo(r,c,m);}}r.write('</p>');}r.write('</div>');}r.write('</div>');};
F._writeImageControl=function(r,c,i){r.write('<figure id="'+i+'-figure"');r.addClass('sapMFeedListItemFigure');if(!c.getIcon()){r.addClass('sapMFeedListItemIsDefaultIcon');}r.writeClasses();r.write('>');r.renderControl(c._getImageControl());r.write('</figure>');};
F._writeCollapsedText=function(r,c,i){if(c._bTextExpanded){r.write(c._sFullText);r.write('</span>');r.write('<span id="'+i+'-threeDots" class ="sapMFeedListItemTextString">');r.write("&#32");r.write('</span>');}else{r.write(c._sShortText);r.write('</span>');r.write('<span id="'+i+'-threeDots" class ="sapMFeedListItemTextString">');r.write("&#32&#46&#46&#46&#32");r.write('</span>');}var l=c._getLinkExpandCollapse();l.addStyleClass("sapMFeedListItemLinkExpandCollapse");r.renderControl(l);};
F._writeTimestamp=function(r,c,i){r.write('<span id="'+i+'-timestamp"');r.addClass('sapMFeedListItemTimestampText');r.addClass('sapUiSelectable');if(c.getUnread()){r.addClass('sapMFeedListItem-Unread');}r.writeClasses();r.write(">");r.writeEscaped(c.getTimestamp());r.write('</span>');};
F._writeInfo=function(r,c,i){r.write('<span id="'+i+'-info"');r.addClass('sapMFeedListItemInfoText');r.addClass('sapUiSelectable');if(c.getUnread()){r.addClass('sapMFeedListItem-Unread');}r.writeClasses();r.write(">");r.writeEscaped(c.getInfo());r.write('</span>');};
F._writeText=function(r,c,i,I){r.write('<span id="'+i+'-realtext"');I?r.addClass('sapMFeedListItemText'):r.addClass('sapMFeedListItemTextString');r.addClass('sapMFeedListItemText');r.addClass('sapUiSelectable');if(c.getUnread()){r.addClass('sapMFeedListItem-Unread');}r.writeClasses();r.write(">");};
return F;},true);
sap.ui.predefine('sap/m/Fiori20Adapter',['sap/ui/base/Object','sap/ui/base/EventProvider','sap/ui/base/ManagedObjectObserver','sap/ui/Device',"sap/base/Log","sap/ui/thirdparty/jquery"],function(B,E,M,D,L,q){"use strict";var e=new E(),i,c,C;
var H=B.extend("HeaderAdapter",{constructor:function(o,A){if(!o||!A){L.error("Cannot initialize: Invalid arguments.");return;}this._oHeader=o;this._oStyledPage=null;this._oTitleInfo=null;this._oSubTitleInfo=null;this._oBackButtonInfo=null;this._oAdaptOptions=A;}});
H.prototype.adapt=function(){var s=this._oAdaptOptions.bStylePage,k=this._oAdaptOptions.bCollapseHeader;if(s){this._toggleStyle("sapF2Adapted",true,true);}this._adaptTitle();this._adaptBackButton();if(k){this._collapseHeader();}return this.getAdaptedContent();};
H.prototype.getAdaptedContent=function(){return{oTitleInfo:this._oTitleInfo,oSubTitleInfo:this._oSubTitleInfo,oBackButtonInfo:this._oBackButtonInfo,oStyledPage:this._oStyledPage};};
H.prototype._adaptTitle=function(){if(!H._isAdaptableHeader(this._oHeader)||this._oAdaptOptions.bMoveTitle!==true){return false;}this._oTitleInfo=this._detectTitle();this._oSubTitleInfo=this._detectSubTitle();var s=!!this._oTitleInfo||!!this._oSubTitleInfo;if(this._oTitleInfo){this._oTitleInfo.oControl.toggleStyleClass("sapF2AdaptedTitle",true);}return s;};
H.prototype._adaptBackButton=function(){if(!H._isAdaptableHeader(this._oHeader)||this._oAdaptOptions.bHideBackButton!==true){return false;}var k,l=false;this._oBackButtonInfo=this._detectBackButton();if(this._oBackButtonInfo){k=this._oBackButtonInfo.oControl.getVisible();this._oBackButtonInfo.oControl.toggleStyleClass("sapF2AdaptedNavigation",k);l=true;}return l;};
H.prototype._toggleStyle=function(s,A,S){var p=this._oHeader.getParent();if(!p){return;}this._oStyledPage=p;if(A===true){p.addStyleClass(s,S);}else if(A===false){p.removeStyleClass(s,S);}else if(A===undefined){p.hasStyleClass(s)?p.removeStyleClass(s,S):p.addStyleClass(s,S);}};
H._isAdaptableHeader=function(o){if(!o||!f(o,"sap/m/Bar")){return false;}var p=o.getParent();return p&&(f(p,"sap/m/Page")||f(p,"sap/m/MessagePage")||f(p,"sap/uxap/ObjectPageHeader"));};
H.prototype._detectTitle=function(){var t;if(H._isAdaptableHeader(this._oHeader)){var m=this._oHeader.getContentMiddle();if(m.length===1&&a(m[0])){var T=m[0];t={id:T.getId(),text:T.getText(),oControl:T,sChangeEventId:"_change",sPropertyName:"text"};}}return t;};
H.prototype._detectSubTitle=function(p){if(f(p,"sap/uxap/ObjectPageHeader")){var o=p.getHeaderTitle();if(o){return{id:o.getId(),text:o.getObjectTitle(),oControl:o,sChangeEventId:"_titleChange",sPropertyName:"objectTitle"};}}};
H.prototype._detectBackButton=function(){var k,o;if(H._isAdaptableHeader(this._oHeader)){k=this._oHeader.getContentLeft();if(k.length>0&&f(k[0],"sap/m/Button")&&(k[0].getType()==="Back"||k[0].getType()==="Up"||k[0].getIcon()==="sap-icon://nav-back")){o=k[0];return{id:o.getId(),oControl:o,sChangeEventId:"_change",sPropertyName:"visible"};}}};
H.prototype._collapseHeader=function(){var t=this._oTitleInfo,k=this._oBackButtonInfo,l,m,n,o,p,r,A;if(H._isAdaptableHeader(this._oHeader)){l=this._oHeader.getContentLeft();m=this._oHeader.getContentMiddle();n=this._oHeader.getContentRight();o=(l.length===1)&&(h(l[0])||k);p=(m.length===1)&&(h(m[0])||t);r=(n.length===1)&&h(n[0]);A=(l.length===0||o)&&(m.length===0||p)&&((n.length===0)||r);this._toggleStyle("sapF2CollapsedHeader",A,true);}};
var F=B.extend("sap.m.Fiori20Adapter",{});
F.attachViewChange=function(l,o){e.attachEvent("adaptedViewChange",l,o);};
F.detachViewChange=function(l,o){e.detachEvent("adaptedViewChange",l,o);};
F.traverse=function(o,A){i={aViewTitles:{},aViewSubTitles:{},aViewBackButtons:{}};c={};C=null;this._doBFS([{oNode:o,oAdaptOptions:A}]);if(this._getCurrentlyAdaptedTopViewId()){this._fireViewChange(this._getCurrentlyAdaptedTopViewId(),A);}};
F._doBFS=function(Q){var n=Q.shift();if(!n){return;}var N=n.oNode,A=n.oAdaptOptions,s=A.iSearchDepth;A=this._applyRules(A,N);if(!this._isAdaptationRequired(N,A)||(s<=0)){return;}var I=this._isTopNavigableView(N);if(I){this._setAsCurrentlyAdaptedTopViewId(N.getId());}var o=this._processNode(N,A);var k=this._getNodeChildren(N),l=q.extend({},A,{iSearchDepth:this._updateSearchDepth(s,N)});if(o){var t=!!o.oTitleInfo,m=!!o.oBackButton,p=!!o.oStyledPage;l=q.extend(l,{bMoveTitle:A.bMoveTitle&&!t,bHideBackButton:A.bHideBackButton&&!m,bStylePage:A.bStylePage&&!p});}k.forEach(function(r){if(r){Q.push({oNode:r,oAdaptOptions:l});}});this._doBFS(Q);};
F._processNode=function(o,A){this._attachDefferedAdaptationListeners(o,A);if(H._isAdaptableHeader(o)){return this._adaptHeader(o,A);}if(o.getParent()&&f(o.getParent(),"sap/m/NavContainer")){return this._getCachedViewInfoToMerge(o.getId());}};
F._attachDefferedAdaptationListeners=function(o,A){this._attachAdaptableContentChange(o,A);this._attachNavigablePageChange(o,A);if(f(o,"sap/m/Page")||f(o,"sap/ui/core/mvc/XMLView")){this._observeAddAggregation(o,"content",A);}if(f(o,"sap/m/NavContainer")){this._observeRemoveAggregation(o,"pages",A);}if((A.bLateAdaptation===true)&&f(o,"sap/m/Bar")){this._observeAddAggregation(o,"contentLeft",A,o);this._observeAddAggregation(o,"contentMiddle",A,o);this._observeAddAggregation(o,"contentRight",A,o);}if(f(o,"sap/ui/core/ComponentContainer")){var k=o.getComponentInstance();if(!k&&o.getName()&&!o.getDomRef()){var t=this;var l={onBeforeRendering:function(){o.removeEventDelegate(l);t._doBFS([{oNode:o.getComponentInstance(),oAdaptOptions:A}]);if(t._getCurrentlyAdaptedTopViewId()){t._fireViewChange(t._getCurrentlyAdaptedTopViewId(),A);}}};o.addEventDelegate(l,this);}}};
F._checkHasListener=function(o,s){var k=c[o.getId()];return k&&k[s];};
F._setHasListener=function(o,s,l){var k=c[o.getId()];if(!k){k={};c[o.getId()]=k;}k[s]=l;};
F._attachAdaptableContentChange=function(o,A){if(typeof o._getAdaptableContent!=="function"){return;}if(this._checkHasListener(o,"_adaptableContentChange")){return;}var O=this._getCurrentlyAdaptedTopViewId();var k=function(l){var m=l.getParameter("adaptableContent");this._setAsCurrentlyAdaptedTopViewId(O);this._doBFS([{oNode:m,oAdaptOptions:A}]);if(this._getCurrentlyAdaptedTopViewId()){this._fireViewChange(this._getCurrentlyAdaptedTopViewId(),A);}}.bind(this);o.attachEvent("_adaptableContentChange",k);this._setHasListener(o,"_adaptableContentChange",k);};
F._attachNavigablePageChange=function(o,A){if(!f(o,"sap/m/NavContainer")){return;}if(this._checkHasListener(o,"navigate")){return;}var O=function(k){var n=k.getParameter("to");A=this._applyRules(A,n);this._doBFS([{oNode:n,oAdaptOptions:A}]);if(this._getCurrentlyAdaptedTopViewId()){this._fireViewChange(this._getCurrentlyAdaptedTopViewId(),A);}}.bind(this);o.attachNavigate(O);this._setHasListener(o,"navigate",O);};
F._observeAddAggregation=function(o,A,k,l){if(this._checkHasListener(o,A)){return;}var O=this._getCurrentlyAdaptedTopViewId(),m=function(p){var s=p.mutation,r=p.object;if((s==="add")||(s==="insert")){this._setAsCurrentlyAdaptedTopViewId(O);this._doBFS([{oNode:l?l:r,oAdaptOptions:k}]);if(this._getCurrentlyAdaptedTopViewId()){this._fireViewChange(this._getCurrentlyAdaptedTopViewId(),k);}}}.bind(this),n=new M(m);n.observe(o,{aggregations:[A]});this._setHasListener(o,A,n);};
F._observeRemoveAggregation=function(o,A,k){if(this._checkHasListener(o,A)){return;}var O=new M(this._onRemoveAggregation.bind(this));O.observe(o,{aggregations:[A]});this._setHasListener(o,A,O);};
F._removeFromMergeInfo=function(m,o){Object.keys(m).forEach(function(k){var l=m[k];if((l.oControl===o)||j(l.oControl,o)){this._detachAllListeners(l.oControl);delete m[k];}},this);};
F._detachAllListeners=function(o){var k=c[o.getId()];if(!k){return;}Object.keys(k).forEach(function(s){var l=k[s];if(l instanceof M){l.disconnect();}else{o.detachEvent(s,l);}delete k[s];});};
F._onRemoveAggregation=function(o){var m=o.mutation,r;if(m==="remove"){r=o.child;this._detachAllListeners(r);this._removeFromMergeInfo(i.aViewTitles,r);this._removeFromMergeInfo(i.aViewSubTitles,r);this._removeFromMergeInfo(i.aViewBackButtons,r);}};
F._getNodeChildren=function(o){if(typeof o._getAdaptableContent==="function"){var k=[o._getAdaptableContent()];if(f(o,"sap/m/Page")){k=k.concat(o.getContent());}return k;}if(f(o,"sap/m/SplitContainer")){return[].concat(o.getAggregation("_navMaster"),o.getAggregation("_navDetail"));}if(f(o,"sap/uxap/ObjectPageLayout")){return[o.getHeaderTitle()];}if(f(o,"sap/ui/core/ComponentContainer")){return[o.getComponentInstance()];}if(f(o,"sap/ui/core/UIComponent")){return[o.getAggregation("rootControl")];}return o.findAggregatedObjects(false,g);};
F._updateSearchDepth=function(s,o){if(f(o,"sap/ui/core/mvc/View")||f(o,"sap/ui/core/Component")||f(o,"sap/ui/core/ComponentContainer")){return s;}return s-1;};
F._getTotalCachedInfoToMerge=function(v){var V=sap.ui.getCore().byId(v),o=this._getCachedViewInfoToMerge(v),k,l,s,S,m,p,n;if(!D.system.phone&&this._isTopSplitContainerSubView(V)){p=V.getParent();m=p&&p.getParent();if(m){k=m._oMasterNav&&(m._oMasterNav.getId()===p.getId());l=m._oDetailNav&&(m._oDetailNav.getId()===p.getId());}}if(k){s=m.getCurrentDetailPage();S=s&&s.getId();n=this._getCachedViewInfoToMerge(S);o=this._mergeSplitViewInfos(o,n);}if(l){s=m.getCurrentMasterPage();S=s&&s.getId();n=this._getCachedViewInfoToMerge(S);o=this._mergeSplitViewInfos(n,o);}o.sViewId=(k||l)?m.getId():v;return o;};
F._isTopSplitContainerSubView=function(o){var p=o&&o.getParent();return this._isTopmostNavContainer(p)&&f(p.getParent(),"sap/m/SplitContainer");};
F._mergeSplitViewInfos=function(m,o){q.each(m,function(k,v){m[k]=v||o[k];});return m;};
F._getCachedViewInfoToMerge=function(v){var o=(i.aViewBackButtons[v])?i.aViewBackButtons[v].oControl:undefined;return{oTitleInfo:i.aViewTitles[v],oSubTitleInfo:i.aViewSubTitles[v],oBackButton:o};};
F._applyRules=function(A,o){var p=o.getParent();if(f(p,"sap/m/SplitContainer")){var I=D.system.phone,m=A.bMoveTitle,k=A.bHideBackButton;if(m){m=I;}if(k&&!D.system.phone){k='initialPage';}return q.extend({},A,{bMoveTitle:m,bHideBackButton:k});}if(f(p,"sap/m/NavContainer")){if(A.bHideBackButton==='initialPage'){var l=p._getActualInitialPage()&&(p._getActualInitialPage().getId()===o.getId());return q.extend({},A,{bHideBackButton:l});}}if((A.bMoveTitle===false)||(A.bHideBackButton===false)){return q.extend({},A,{bCollapseHeader:false});}return A;};
F._getCurrentlyAdaptedTopViewId=function(){return C;};
F._setAsCurrentlyAdaptedTopViewId=function(v){C=v;};
F._isTopNavigableView=function(n){var p=n.getParent();return p&&this._isTopmostNavContainer(p);};
F._isTopmostNavContainer=function(o){var k,n=o;while(n){if(f(n,"sap/m/NavContainer")){k=n;}n=n.getParent();}return k&&(k.getId()===o.getId());};
F._adaptHeader=function(o,A){if(!o||!A){return;}var k=new H(o,A),l=k.adapt();var t=this._getCurrentlyAdaptedTopViewId();if(l.oTitleInfo){i.aViewTitles[t]=l.oTitleInfo;this._registerTextChangeListener(i.aViewTitles,t,A);}if(l.oSubTitleInfo){i.aViewSubTitles[t]=l.oSubTitleInfo;this._registerTextChangeListener(i.aViewSubTitles,t,A);}if(l.oBackButtonInfo){if(l.oBackButtonInfo.oControl.getVisible()){i.aViewBackButtons[t]=l.oBackButtonInfo;}this._registerVisibilityChangeListener(l.oBackButtonInfo,i.aViewBackButtons,t,A);}return l;};
F._registerTextChangeListener=function(t,v,A){var T=t[v];if(T&&T.oControl&&T.sChangeEventId){if(this._checkHasListener(T.oControl,T.sChangeEventId)){return;}var k=function(o){var T=t[v];if(o.getParameter("name")!==T.sPropertyName){return;}T.text=o.getParameter("newValue");this._fireViewChange(v,A);}.bind(this);T.oControl.attachEvent(T.sChangeEventId,k);this._setHasListener(T.oControl,T.sChangeEventId,k);}};
F._registerVisibilityChangeListener=function(o,k,v,A){var V;if(o&&o.oControl&&o.sChangeEventId){if(this._checkHasListener(o.oControl,o.sChangeEventId)){return;}var l=function(m){if(m.getParameter("name")!==o.sPropertyName){return;}V=m.getParameter("newValue");if(!V){q.each(k,function(I,n){if(n.oControl.getId()===o.oControl.getId()){delete k[I];}});}var p=o.oControl.getParent();if(H._isAdaptableHeader(p)){F._adaptHeader(p,A);this._fireViewChange(v,A);}}.bind(this);o.oControl.attachEvent(o.sChangeEventId,l);this._setHasListener(o.oControl,o.sChangeEventId,l);}};
F._fireViewChange=function(v,A){var t=this._getTotalCachedInfoToMerge(v);t.oAdaptOptions=A;e.fireEvent("adaptedViewChange",t);};
F._isAdaptationRequired=function(n,A){if(!n||this._isNonAdaptableControl(n)){return false;}for(var o in A){if(A.hasOwnProperty(o)&&((A[o]===true)||(A[o]==="initialPage"))){return true;}}return false;};
F._isNonAdaptableControl=function(o){return b(o);};
function a(o){return d(o,["sap/m/Label","sap/m/Text","sap/m/Title"]);}
function b(o){return d(o,["sap/m/List","sap/m/Table","sap/ui/table/Table","sap/ui/table/TreeTable"]);}
function d(o,t){if(!o||!t){return;}return t.some(function(T){return f(o,T);});}
function f(o,t){var T=sap.ui.require(t);return T&&(o instanceof T);}
function g(o){return o&&(o.sParentAggregationName!=="dependents");}
function h(o){return o&&(typeof o.getVisible==="function")&&(o.getVisible()===false);}
function j(o,r){var p=o&&o.getParent();while(p){if(p===r){return true;}p=p.getParent();}return false;}
return F;});
sap.ui.predefine('sap/m/FlexBox',['./FlexBoxStylingHelper','./FlexItemData','./library','sap/ui/core/Control','sap/ui/core/InvisibleRenderer','./FlexBoxRenderer','sap/ui/thirdparty/jquery'],function(F,a,l,C,I,b,q){"use strict";var B=l.BackgroundDesign;var c=l.FlexAlignContent;var d=l.FlexWrap;var e=l.FlexAlignItems;var f=l.FlexJustifyContent;var g=l.FlexRendertype;var h=l.FlexDirection;
var j=C.extend("sap.m.FlexBox",{metadata:{library:"sap.m",properties:{height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:''},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:''},displayInline:{type:"boolean",group:"Appearance",defaultValue:false},direction:{type:"sap.m.FlexDirection",group:"Appearance",defaultValue:h.Row},fitContainer:{type:"boolean",group:"Appearance",defaultValue:false},renderType:{type:"sap.m.FlexRendertype",group:"Misc",defaultValue:g.Div},justifyContent:{type:"sap.m.FlexJustifyContent",group:"Appearance",defaultValue:f.Start},alignItems:{type:"sap.m.FlexAlignItems",group:"Appearance",defaultValue:e.Stretch},wrap:{type:"sap.m.FlexWrap",group:"Appearance",defaultValue:d.NoWrap},alignContent:{type:"sap.m.FlexAlignContent",group:"Appearance",defaultValue:c.Stretch},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:B.Transparent}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.core.Control",multiple:true,singularName:"item"}},designtime:"sap/m/designtime/FlexBox.designtime",dnd:{draggable:false,droppable:true}}});
j.prototype.init=function(){this._oItemDelegate={onAfterRendering:this._onAfterItemRendering};};
j.prototype.addItem=function(i){this.addAggregation("items",i);this._onItemInserted(i);return this;};
j.prototype.insertItem=function(i,k){this.insertAggregation("items",i,k);this._onItemInserted(i);return this;};
j.prototype.removeItem=function(i){var o=this.removeAggregation("items",i);this._onItemRemoved(o);return o;};
j.prototype.removeAllItems=function(){var k=this.getItems();for(var i=0;i<k.length;i++){this._onItemRemoved(k[i]);}return this.removeAllAggregation("items");};
j.prototype._onItemInserted=function(i){if(i&&!(i instanceof j)){i.attachEvent("_change",this._onItemChange,this);if(this.getRenderType()===g.Bare){i.addEventDelegate(this._oItemDelegate,i);}}};
j.prototype._onItemRemoved=function(i){if(i&&!(i instanceof j)){i.detachEvent("_change",this._onItemChange,this);if(this.getRenderType()===g.Bare){i.removeEventDelegate(this._oItemDelegate,i);}}};
j.prototype._onItemChange=function(o){if(o.getParameter("name")!=="visible"||(this.getRenderType()!==g.List&&this.getRenderType()!==g.Div)){return;}var i=sap.ui.getCore().byId(o.getParameter("id")),$=null;if(i.getLayoutData()){$=q(document.getElementById(i.getLayoutData().getId()));}else{$=q(document.getElementById(I.createInvisiblePlaceholderId(i))).parent();}if(o.getParameter("newValue")){$.removeClass("sapUiHiddenPlaceholder").removeAttr("aria-hidden");}else{$.addClass("sapUiHiddenPlaceholder").attr("aria-hidden","true");}};
j.prototype._onAfterItemRendering=function(){var L=this.getLayoutData();if(L instanceof a){F.setFlexItemStyles(null,L);}};
j.prototype.setRenderType=function(v){var o=this.getRenderType(),i=this.getItems();if(v===o){return this;}this.setProperty("renderType",v);if(o==="Bare"){i.forEach(this._onItemRemoved,this);}if(v==="Bare"){i.forEach(this._onItemInserted,this);}return this;};
j.prototype.getAccessibilityInfo=function(){return{children:this.getItems()};};
return j;});
sap.ui.predefine('sap/m/FlexBoxCssPropertyMap',[],function(){"use strict";var F={'specie10':{'order':{'<number>':{'flex-order':'<number>'}},'flex-grow':{'<number>':{'flex-positive':'<number>','flex-preferred-size':'auto'}},'flex-shrink':{'<number>':{'flex-negative':'<number>'}},'flex-basis':{'<number>':{'flex-preferred-size':'<number>'}}}};return F;},true);
sap.ui.predefine('sap/m/FlexBoxRenderer',['./FlexBoxStylingHelper','sap/m/library',"sap/base/Log","sap/m/FlexItemData"],function(F,l,L,a){"use strict";var b=l.FlexDirection;var c=l.FlexRendertype;var d={apiVersion:2};
d.render=function(r,f){r.openStart(f.getRenderType()===c.List?"ul":"div",f);var p=f.getParent();if(p&&p.isA("sap.m.FlexBox")){if(!f.hasStyleClass("sapMFlexItem")){r.class("sapMFlexItem");}var o=f.getLayoutData();if(o instanceof a){F.setFlexItemStyles(r,o);}}else if(f.getFitContainer()){r.class("sapMFlexBoxFit");}r.class("sapMFlexBox");if(f.getDisplayInline()){r.class("sapMFlexBoxInline");}if(f.getDirection()===b.Column||f.getDirection()===b.ColumnReverse){r.class("sapMVBox");}else{r.class("sapMHBox");}if(f.getDirection()===b.RowReverse||f.getDirection()===b.ColumnReverse){r.class("sapMFlexBoxReverse");}r.class("sapMFlexBoxJustify"+f.getJustifyContent());r.class("sapMFlexBoxAlignItems"+f.getAlignItems());r.class("sapMFlexBoxWrap"+f.getWrap());r.class("sapMFlexBoxAlignContent"+f.getAlignContent());var B="sapMFlexBoxBG"+f.getBackgroundDesign();if(!f.hasStyleClass(B)){r.class(B);}r.style("height",f.getHeight());r.style("width",f.getWidth());var t=f.getTooltip_AsString();if(t){r.attr("title",t);}r.openEnd();d.renderItems(f,r);if(f.getRenderType()===c.List){r.close("ul");}else{r.close("div");}};
d.renderItems=function(f,r){var C=f.getItems(),w='';for(var i=0;i<C.length;i++){if(C[i].isA('sap.m.FlexBox')||f.getRenderType()===c.Bare){w="";}else if(f.getRenderType()===c.List){w="li";}else{w="div";}d.renderItem(C[i],w,r);}};
d.renderItem=function(i,w,r){var o=i.getLayoutData();if(w&&!o){i.setAggregation("layoutData",new a(),true);o=i.getLayoutData();}if(!(o instanceof a)){if(o){L.warning(o+" set on "+i+" is not of type sap.m.FlexItemData");}if(w){r.openStart(w);}}else{if(w){r.openStart(w,o.getId());}if(o.getStyleClass()){d.addItemClass(o.getStyleClass(),i,w,r);}d.addItemClass("sapMFlexItemAlign"+o.getAlignSelf(),i,w,r);d.addItemClass("sapMFlexBoxBG"+o.getBackgroundDesign(),i,w,r);if(w){F.setFlexItemStyles(r,o);}}d.addItemClass("sapMFlexItem",i,w,r);if(w){if(i.isA("sap.m.ScrollContainer")){r.class("sapMFlexBoxScroll");}if(!i.getVisible()){r.class("sapUiHiddenPlaceholder");}r.openEnd();}r.renderControl(i);if(w){r.close(w);}};
d.addItemClass=function(C,i,w,r){if(w){r.class(C);}else{i.addStyleClass(C);}};
return d;},true);
sap.ui.predefine('sap/m/FlexBoxStylingHelper',['./FlexBoxCssPropertyMap','sap/ui/Device'],function(F,D){"use strict";var a={};
a.setFlexItemStyles=function(r,l){r=r||null;var o=''+l.getOrder(),g=''+l.getGrowFactor(),s=''+l.getShrinkFactor(),b=l.getBaseSize().toLowerCase(),m=l.getMinHeight(),M=l.getMaxHeight(),c=l.getMinWidth(),d=l.getMaxWidth();if(typeof o!=='undefined'){a.setStyle(r,l,"order",o);}if(typeof g!=='undefined'){a.setStyle(r,l,"flex-grow",g);}if(typeof s!=='undefined'){a.setStyle(r,l,"flex-shrink",s);}if(typeof b!=='undefined'){a.setStyle(r,l,"flex-basis",b);}if(typeof m!=='undefined'){a.setStyle(r,l,"min-height",m);}if(typeof M!=='undefined'){a.setStyle(r,l,"max-height",M);}if(typeof c!=='undefined'){a.setStyle(r,l,"min-width",c);}if(typeof d!=='undefined'){a.setStyle(r,l,"max-width",d);}};
a.setStyle=function(r,l,p,v){if(typeof(v)==="string"){v=v.replace(/([a-z])([A-Z])/g,"$1-$2").toLowerCase();}else if(typeof(v)==="number"){v=v.toString();}a.writeStyle(r,l,p,v);};
a.writeStyle=function(r,l,p,v){if(D.browser.internet_explorer&&(p==="flex-basis"||p==="flex-preferred-size")){if(l.getParent()){if(l.getParent().getParent().getDirection().indexOf("Row")>-1){p="width";}else{p="height";}}}if(r){if(v==="0"||v){r.style(p,v);}}else{if(l.$().length){if(v!=="0"&&!v){l.$().css(p,null);}else{l.$().css(p,v);}}else{if(l.getParent()){if(v!=="0"&&!v){l.getParent().$().css(p,null);}else{l.getParent().$().css(p,v);}}}}};
return a;},true);
sap.ui.predefine('sap/m/FlexItemData',['./FlexBoxStylingHelper','./library','sap/ui/core/LayoutData'],function(F,l,L){"use strict";var B=l.BackgroundDesign;var a=l.FlexAlignSelf;
var b=L.extend("sap.m.FlexItemData",{metadata:{library:"sap.m",properties:{alignSelf:{type:"sap.m.FlexAlignSelf",group:"Misc",defaultValue:a.Auto},order:{type:"int",group:"Misc",defaultValue:0},growFactor:{type:"float",group:"Misc",defaultValue:0},shrinkFactor:{type:"float",group:"Misc",defaultValue:1},baseSize:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:"auto"},minHeight:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'auto'},maxHeight:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:''},minWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'auto'},maxWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:''},styleClass:{type:"string",group:"Misc",defaultValue:''},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:B.Transparent}}}});
b.prototype.setAlignSelf=function(v){var o=this.getAlignSelf();this.setProperty("alignSelf",v,true);this.$().removeClass("sapMFlexItemAlign"+o).addClass("sapMFlexItemAlign"+this.getAlignSelf());return this;};
b.prototype.setOrder=function(v){this.setProperty("order",v,true);F.setStyle(null,this,"order",this.getOrder());return this;};
b.prototype.setGrowFactor=function(v){this.setProperty("growFactor",v,true);F.setStyle(null,this,"flex-grow",this.getGrowFactor());return this;};
b.prototype.setShrinkFactor=function(v){this.setProperty("shrinkFactor",v,true);F.setStyle(null,this,"flex-shrink",this.getShrinkFactor());return this;};
b.prototype.setBaseSize=function(v){this.setProperty("baseSize",v,true);F.setStyle(null,this,"flex-basis",this.getBaseSize());return this;};
b.prototype.setMinHeight=function(v){this.setProperty("minHeight",v,true);this.$().css("min-height",this.getMinHeight());return this;};
b.prototype.setMaxHeight=function(v){this.setProperty("maxHeight",v,true);this.$().css("max-height",this.getMaxHeight());return this;};
b.prototype.setMinWidth=function(v){this.setProperty("minWidth",v,true);this.$().css("min-width",this.getMinWidth());return this;};
b.prototype.setMaxWidth=function(v){this.setProperty("maxWidth",v,true);this.$().css("max-width",this.getMaxWidth());return this;};
b.prototype.setBackgroundDesign=function(v){var o=this.getBackgroundDesign();this.setProperty("backgroundDesign",v,true);this.$().removeClass("sapMFlexBoxBG"+o).addClass("sapMFlexBoxBG"+this.getBackgroundDesign());return this;};
b.prototype.setStyleClass=function(v){var o=this.getStyleClass();this.setProperty("styleClass",v,true);this.$().removeClass(o).addClass(this.getStyleClass());return this;};
b.prototype.getDomRef=function(s){var p,i=L.prototype.getDomRef.call(this,s);if(i){return i;}p=this.getParent();if(!p){return null;}return p.getDomRef(s);};
return b;});
sap.ui.predefine('sap/m/FormattedText',['./library','sap/ui/core/Control','./FormattedTextAnchorGenerator','./FormattedTextRenderer',"sap/base/Log","sap/base/security/URLWhitelist","sap/base/security/sanitizeHTML"],function(l,C,F,a,L,U,s){"use strict";var b=l.LinkConversion;
var c=C.extend("sap.m.FormattedText",{metadata:{library:"sap.m",properties:{htmlText:{type:"string",group:"Misc",defaultValue:""},width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},convertLinksToAnchorTags:{type:"sap.m.LinkConversion",group:"Behavior",defaultValue:b.None},convertedLinksDefaultTarget:{type:"string",group:"Behavior",defaultValue:"_blank"},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null}},aggregations:{controls:{type:"sap.m.Link",multiple:true,singularName:"control"}}}});
var _={ATTRIBS:{'style':1,'class':1,'a::href':1,'a::target':1},ELEMENTS:{'a':{cssClass:'sapMLnk'},'abbr':1,'blockquote':1,'br':1,'cite':1,'code':1,'em':1,'h1':{cssClass:'sapMTitle sapMTitleStyleH1'},'h2':{cssClass:'sapMTitle sapMTitleStyleH2'},'h3':{cssClass:'sapMTitle sapMTitleStyleH3'},'h4':{cssClass:'sapMTitle sapMTitleStyleH4'},'h5':{cssClass:'sapMTitle sapMTitleStyleH5'},'h6':{cssClass:'sapMTitle sapMTitleStyleH6'},'p':1,'pre':1,'strong':1,'span':1,'u':1,'dl':1,'dt':1,'dd':1,'ol':1,'ul':1,'li':1}},d={ATTRIBS:{'a::href':1,'a::target':1},ELEMENTS:{'a':{cssClass:'sapMLnk'},'em':1,'strong':1,'u':1}};c.prototype._renderingRules=_;
c.prototype.init=function(){};
function S(t,f){var w;var g,v,h=t==="a";var j=this._renderingRules.ELEMENTS[t].cssClass||"";for(var i=0;i<f.length;i+=2){g=f[i];v=f[i+1];if(!this._renderingRules.ATTRIBS[g]&&!this._renderingRules.ATTRIBS[t+"::"+g]){w='FormattedText: <'+t+'> with attribute ['+g+'="'+v+'"] is not allowed';L.warning(w,this);f[i+1]=null;continue;}if(g=="href"){if(!U.validate(v)){L.warning("FormattedText: incorrect href attribute:"+v,this);f[i+1]="#";h=false;}}if(g=="target"){h=false;}if(j&&g.toLowerCase()=="class"){f[i+1]=j+" "+v;j="";}}if(h){f.push("target");f.push("_blank");}if(j){f.push("class");f.push(j);}return f;}
function p(t,f){if(this._renderingRules.ELEMENTS[t]){return S.call(this,t,f);}else{var w='<'+t+'> is not allowed';L.warning(w,this);}}
function e(t){return s(t,{tagPolicy:p.bind(this),uriRewriter:function(u){if(U.validate(u)){return u;}}});}
function o(E){var n=window.open();n.opener=null;n.location=E.currentTarget.href;E.preventDefault();}
c.prototype.onAfterRendering=function(){this.$().find('a[target="_blank"]').on("click",o);};
c.prototype.onBeforeRendering=function(){this.$().find('a[target="_blank"]').off("click",o);};
c.prototype._getDisplayHtml=function(){var t=this.getHtmlText(),A=this.getConvertLinksToAnchorTags();if(A===l.LinkConversion.None){return t;}t=F.generateAnchors(t,A,this.getConvertedLinksDefaultTarget());return e.call(this,t);};
c.prototype.setHtmlText=function(t){return this.setProperty("htmlText",e.call(this,t));};
c.prototype._setUseLimitedRenderingRules=function(f){this._renderingRules=f?d:_;};
return c;});
sap.ui.predefine('sap/m/FormattedTextAnchorGenerator',["sap/ui/base/Object","sap/m/library","sap/base/security/URLWhitelist"],function(B,l,U){"use strict";var L=l.LinkConversion;
var A=B.extend("sap.m.FormattedTextAnchorGenerator",{getInterface:function(){return this;}});
var c=/(\b(https?|ftp):\/\/[-A-Z0-9+&@#\/%?=~_|!:,.;()$]*[-A-Z0-9+&@#\/%=~_|])/gim;var W=/(www\.[^\s><]+(\b|$))/gim;var d="//";var D=/<(?:"[^"]*"['"]*|'[^']*'['"]*|[^'">])+(?!\/\s\*)>/gim;var E=/<a[^>]*>([^<]+)<\/a>/gim;var e=[D,E];
A.generateAnchors=function(t,s,T){if(s===L.ProtocolOnly){t=A._createAnchors(t,c,T);}if(s===L.All){t=A._createAnchors(t,c,T);t=A._createAnchors(t,W,T,d);}return t;};
A._createPositionObject=function(i,a){return{iStartPos:i,iEndPos:i+a};};
A._isNested=function(f,s){return f.iStartPos<s.iStartPos&&f.iEndPos>s.iEndPos;};
A._isAllowed=function(b,C){return b.some(function(o){return A._isNested(o,C);});};
A._shouldBeProcessed=function(u,C,b){return U.validate(u)&&!A._isAllowed(b,C);};
A._scanForEntitiesToSkip=function(r,t){var a=[],C;while((C=r.exec(t))!==null){a.push(A._createPositionObject(C.index,C[0].length));}return a;};
A._getEntitiesToSkipWhileSearchingForLinks=function(t){return e.map(function(s){return A._scanForEntitiesToSkip(s,t);}).reduce(function(a,b){return a.concat(b);});};
A._createAnchors=function(t,r,T,p){var a=A._getEntitiesToSkipWhileSearchingForLinks(t),C;p=p||'';C=function(P){var o=A._createPositionObject(arguments[3],P.length);if(!A._shouldBeProcessed(P,o,a)){return P;}return"<a href=\""+p+P+"\" target=\""+T+"\">"+P+"</a>";};return t.replace(r,C);};
return A;});
sap.ui.predefine('sap/m/FormattedTextRenderer',["sap/base/Log"],function(L){"use strict";var F={apiVersion:2};
F.render=function(r,c){var w=c.getWidth(),h=c.getHeight(),C=c.getAggregation("controls"),t=c._getDisplayHtml(),R=[],n='',s=0;r.openStart("div",c);r.class("sapMFT");if(w){r.class("sapMFTOverflowWidth");}if(h){r.class("sapMFTOverflowHeight");}if(c.getTooltip_AsString()){r.attr("title",c.getTooltip_AsString());}r.style("width",w||null);r.style("height",h||null);r.openEnd();while(t!==''&&t!==n){n=t.replace(/(?:\%\%(\d+))/,_);}if(t!==''){try{r.unsafeHtml(t);}catch(e){r.text(t);}}r.close("div");function _(m,i,p){var M=m.length;try{r.unsafeHtml(t.substr(0,p));}catch(e){r.text(t.substr(0,p));}s+=p;if(C&&C[i]!==undefined){if(R[i]===undefined){r.renderControl(C[i]);R[i]=s;}else{L.error("Control with index '"+i+"' ("+m+", htmlText@"+s+") is already rendered (htmlText@"+R[i]+")!",'sap.m.FormattedText:',c.getId());}}else{r.text(m);L.error("Missing control for placeholder '"+m+"' (htmlText@"+s+")!",'sap.m.FormattedText:',c.getId());}t=t.substr(p+M);s+=M;}};
return F;},true);
sap.ui.predefine('sap/m/GenericTag',["sap/ui/core/Control","sap/ui/events/KeyCodes",'./library',"sap/ui/core/library","sap/ui/core/Icon","./GenericTagRenderer"],function(C,K,l,c,I){"use strict";var G=l.GenericTagDesign,a=l.GenericTagValueState,V=c.ValueState,b={Error:"sap-icon://message-error",Warning:"sap-icon://message-warning",Success:"sap-icon://message-success",Information:"sap-icon://hint"};
var d=C.extend("sap.m.GenericTag",{metadata:{library:"sap.m",interfaces:["sap.m.IOverflowToolbarContent","sap.m.IOverflowToolbarFlexibleContent"],properties:{text:{type:"string",defaultValue:""},status:{type:"sap.ui.core.ValueState",defaultValue:V.None},design:{type:"sap.m.GenericTagDesign",defaultValue:G.Full},valueState:{type:"sap.m.GenericTagValueState",defaultValue:a.None}},defaultAggregation:"value",aggregations:{value:{type:"sap.m.ObjectNumber",multiple:false},_statusIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_errorIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},events:{press:{}}}});
d.CLASSNAME_OVERFLOW_TOOLBAR="sapMGenericTagOverflowToolbar";
d.prototype.setStatus=function(s){this.setProperty("status",s,false);this._getStatusIcon().setSrc(s!==V.None?b[s]:null);return this;};
d.prototype.setValue=function(v){var p=this.getValue();if(p){v.detachEvent("_change",this._fireValueChanged,this);}this.setAggregation("value",v);v.attachEvent("_change",this._fireValueChanged,this);this._fireValueChanged();return this;};
d.prototype._fireValueChanged=function(){this.fireEvent("_valueChanged");};
d.prototype._getStatusIcon=function(){var s=this.getAggregation("_statusIcon");if(!s){s=new I(this.getId()+"-statusIcon").addStyleClass("sapMGenericTagIcon");this.setAggregation("_statusIcon",s);}return s;};
d.prototype._getErrorIcon=function(){var e=this.getAggregation("_errorIcon");if(!e){e=new I(this.getId()+"-errorIcon",{src:b[V.Error]}).addStyleClass("sapMGenericTagErrorIcon");this.setAggregation("_errorIcon",e);}return e;};
d.prototype.ontouchstart=function(){this._toggleActiveGenericTag(true);};
d.prototype.ontouchend=function(){this._toggleActiveGenericTag(false);};
d.prototype.ontouchcancel=function(){this._toggleActiveGenericTag(false);};
d.prototype.onkeydown=function(e){if(e.which===K.SPACE||e.which===K.ENTER){this._toggleActiveGenericTag(true);}if(e.which===K.SHIFT||e.which===K.ESCAPE){this._bShouldInterupt=this._bSpacePressed;}if(e.which===K.SPACE){this._bSpacePressed=true;e.preventDefault();}if(e.which===K.ENTER){this.firePress();}};
d.prototype.onkeyup=function(e){if(e.which===K.SPACE||e.which===K.ENTER){this._toggleActiveGenericTag(false);}if(e.which===K.SPACE){if(!this._bShouldInterupt){this.firePress();}this._bShouldInterupt=false;this._bSpacePressed=false;}};
d.prototype.onclick=function(){this.firePress();};
d.prototype.onfocusout=function(){this._toggleActiveGenericTag(false);};
d.prototype._toggleActiveGenericTag=function(t){this.toggleStyleClass("sapMGenericTagActive",t);};
d.prototype._onBeforeEnterOverflow=function(o){o.addStyleClass(d.CLASSNAME_OVERFLOW_TOOLBAR);};
d.prototype._onAfterExitOverflow=function(o){o.removeStyleClass(d.CLASSNAME_OVERFLOW_TOOLBAR);};
d.prototype.getOverflowToolbarConfig=function(){var o={canOverflow:true,invalidationEvents:["_valueChanged"]};o.onBeforeEnterOverflow=this._onBeforeEnterOverflow;o.onAfterExitOverflow=this._onAfterExitOverflow;return o;};
return d;});
sap.ui.predefine('sap/m/GenericTagRenderer',["./library","sap/ui/core/library"],function(l,c){"use strict";var G=l.GenericTagDesign,a=l.GenericTagValueState,V=c.ValueState,C=sap.ui.getCore(),b={apiVersion:2};
b.render=function(r,o){var L=this._getAriaLabelledBy(o),R=C.getLibraryResourceBundle("sap.m"),t=o.getTooltip_AsString();r.openStart("div",o);r.class("sapMGenericTag");r.attr("tabindex",0);r.class("sapMGenericTag"+o.getStatus());r.accessibilityState(o,{role:"button",roledescription:R.getText("GENERICTAG_ROLEDESCRIPTION"),labelledby:L.join(" ")});if(t){r.attr("title",t);}r.openEnd();r.openStart("div");r.class("sapMGenericTagWrap");r.openEnd();this.renderElements(r,o);r.close("div");r.close("div");};
b.renderElements=function(r,o){var s=o.getDesign()===G.StatusIconHidden,S=o.getValueState()===a.Error,v=o.getValue();if(!s&&o.getStatus()!==V.None){r.renderControl(o._getStatusIcon());}this.renderText(r,o);if(S){r.renderControl(o._getErrorIcon());}else if(v){r.renderControl(v.addStyleClass("sapMGenericTagValue"));}this.renderHiddenARIAElement(r,o);};
b.renderText=function(r,o){r.openStart("span",o.getId()+"-text");r.class("sapMGenericTagText");r.openEnd();r.text(o.getText());r.close("span");};
b.renderHiddenARIAElement=function(r,o){if(o.getStatus()===V.None){return;}r.openStart("span",o.getId()+"-status");r.class("sapUiInvisibleText");r.attr("aria-hidden","true");r.openEnd();r.text(this._getGenericTagStatusText(o));r.close("span");};
b._getAriaLabelledBy=function(o){var L=[],i=o.getId(),t=this._getTagValueId(o),T=this._getTagValueState(o);if(o.getStatus()!==V.None){L.push(i+"-status");}L.push(i+"-text");L.push(o.getValueState()===a.Error?i+"-errorIcon":t);if(T&&T!==V.None){L.push(t+'-state');}return L;};
b._getGenericTagStatusText=function(o){var r=sap.ui.getCore().getLibraryResourceBundle("sap.m"),A;switch(o.getStatus()){case V.Error:A=r.getText("GENERICTAG_ARIA_VALUE_STATE_ERROR");break;case V.Warning:A=r.getText("GENERICTAG_ARIA_VALUE_STATE_WARNING");break;case V.Success:A=r.getText("GENERICTAG_ARIA_VALUE_STATE_SUCCESS");break;case V.Information:A=r.getText("GENERICTAG_ARIA_VALUE_STATE_INFORMATION");break;default:}return A;};
b._getTagValueId=function(o){var v=o.getValue();return v?v.getId():"";};
b._getTagValueState=function(o){var v=o.getValue();return v?v.getState():"";};
return b;},true);
sap.ui.predefine('sap/m/GenericTile',['./library','sap/ui/core/Control','sap/m/Text','sap/ui/core/HTML','sap/ui/core/Icon','sap/ui/core/IconPool','sap/m/Button','sap/m/GenericTileRenderer','sap/m/GenericTileLineModeRenderer','sap/ui/Device','sap/ui/core/ResizeHandler',"sap/base/strings/camelize","sap/base/util/deepEqual","sap/ui/events/PseudoEvents","sap/ui/thirdparty/jquery"],function(l,C,T,H,I,a,B,G,L,D,R,c,d,P,q){"use strict";var b=l.GenericTileScope,e=l.LoadState,F=l.FrameType,S=l.Size,f=l.GenericTileMode,g=l.TileSizeBehavior,W=l.WrappingType;var h="GenericTileDeviceSet";var j={};
var m=C.extend("sap.m.GenericTile",{
metadata:{library:"sap.m",properties:{mode:{type:"sap.m.GenericTileMode",group:"Appearance",defaultValue:f.ContentMode},header:{type:"string",group:"Appearance",defaultValue:null},subheader:{type:"string",group:"Appearance",defaultValue:null},failedText:{type:"string",group:"Appearance",defaultValue:null},size:{type:"sap.m.Size",group:"Misc",defaultValue:S.Auto},frameType:{type:"sap.m.FrameType",group:"Misc",defaultValue:F.OneByOne},backgroundImage:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},headerImage:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},state:{type:"sap.m.LoadState",group:"Misc",defaultValue:e.Loaded},imageDescription:{type:"string",group:"Accessibility",defaultValue:null},scope:{type:"sap.m.GenericTileScope",group:"Misc",defaultValue:b.Display},sizeBehavior:{type:"sap.m.TileSizeBehavior",defaultValue:g.Responsive},ariaLabel:{type:"string",group:"Accessibility",defaultValue:null},ariaRole:{type:"string",group:"Accessibility",defaultValue:null},ariaRoleDescription:{type:"string",group:"Accessibility",defaultValue:null},url:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},wrappingType:{type:"sap.m.WrappingType",group:"Appearance",defaultValue:W.Normal},width:{type:"sap.ui.core.CSSSize",group:"Appearance"},additionalTooltip:{type:"string",group:"Accessibility",defaultValue:null}},defaultAggregation:"tileContent",aggregations:{tileContent:{type:"sap.m.TileContent",multiple:true,bindable:"bindable"},icon:{type:"sap.ui.core.Control",multiple:false},_titleText:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_failedMessageText:{type:"sap.m.Text",multiple:false,visibility:"hidden"}},events:{press:{parameters:{scope:{type:"sap.m.GenericTileScope"},action:{type:"string"},domRef:{type:"any"}}}}},
renderer:function(r,o){if(o.getMode()===l.GenericTileMode.LineMode){L.render(r,o);}else{G.render(r,o);}}
});
m._Action={Press:"Press",Remove:"Remove"};m.LINEMODE_SIBLING_PROPERTIES=["state","subheader","header","scope"];
m.prototype.init=function(){this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");if(!D.media.hasRangeSet(h)){D.media.initRangeSet(h,[450],"px",["small","large"]);}this._oTitle=new T(this.getId()+"-title");this._oTitle.addStyleClass("sapMGTTitle");this._oTitle.cacheLineHeight=false;this.setAggregation("_titleText",this._oTitle,true);this._oSubTitle=new T(this.getId()+"-subTitle");this._oSubTitle.cacheLineHeight=false;this.addDependent(this._oSubTitle);this._sFailedToLoad=this._oRb.getText("INFOTILE_CANNOT_LOAD_TILE");this._sLoading=this._oRb.getText("INFOTILE_LOADING");this._oFailedText=new T(this.getId()+"-failed-txt",{maxLines:2});this._oFailedText.cacheLineHeight=false;this._oFailedText.addStyleClass("sapMGTFailed");this.setAggregation("_failedMessageText",this._oFailedText,true);this._oWarningIcon=new I(this.getId()+"-warn-icon",{src:"sap-icon://notification",size:"1.375rem"});this._oWarningIcon.addStyleClass("sapMGTFtrFldIcnMrk");this._oBusy=new H(this.getId()+"-overlay");this._oBusy.setBusyIndicatorDelay(0);this._bTilePress=true;this._bThemeApplied=true;if(!sap.ui.getCore().isInitialized()){this._bThemeApplied=false;sap.ui.getCore().attachInit(this._handleCoreInitialized.bind(this));}else{this._handleCoreInitialized();}};
m.prototype.setWrappingType=function(w){this.setProperty("wrappingType",w,true);this._oTitle.setWrappingType(w);this._oFailedText.setWrappingType(w);this._oSubTitle.setWrappingType(w);return this;};
m.prototype.setSubheader=function(s){this.setProperty("subheader",s);this._oSubTitle.setText(s);return this;};
m.prototype._handleCoreInitialized=function(){this._bThemeApplied=sap.ui.getCore().isThemeApplied();if(!this._bThemeApplied){sap.ui.getCore().attachThemeChanged(this._handleThemeApplied,this);}};
m.prototype._handleThemeApplied=function(){this._bThemeApplied=true;this._oTitle.clampHeight();sap.ui.getCore().detachThemeChanged(this._handleThemeApplied,this);};
m.prototype._initScopeContent=function(t){if(!this.getState||this.getState()!==l.LoadState.Disabled){this._oMoreIcon=this._oMoreIcon||a.createControlByURI({id:this.getId()+"-action-more",size:"1rem",useIconTooltip:false,src:"sap-icon://overflow"}).addStyleClass("sapMPointer").addStyleClass(t+"MoreIcon");this._oRemoveButton=this._oRemoveButton||new B({id:this.getId()+"-action-remove",icon:"sap-icon://decline",tooltip:this._oRb.getText("GENERICTILE_REMOVEBUTTON_TEXT")}).addStyleClass("sapUiSizeCompact").addStyleClass(t+"RemoveButton");this._oRemoveButton._bExcludeFromTabChain=true;switch(this.getScope()){case l.GenericTileScope.Actions:this._oMoreIcon.setVisible(true);this._oRemoveButton.setVisible(true);break;case l.GenericTileScope.ActionMore:this._oMoreIcon.setVisible(true);this._oRemoveButton.setVisible(false);break;case l.GenericTileScope.ActionRemove:this._oRemoveButton.setVisible(true);this._oMoreIcon.setVisible(false);break;default:}}};
m.prototype._isSmall=function(){return this.getSizeBehavior()===g.Small||window.matchMedia("(max-width: 374px)").matches;};
m.prototype.exit=function(){if(this._sParentResizeListenerId){R.deregister(this._sResizeListenerId);this._sParentResizeListenerId=null;}D.media.detachHandler(this._handleMediaChange,this,h);if(this._$RootNode){this._$RootNode.off(this._getAnimationEvents());this._$RootNode=null;}this._clearAnimationUpdateQueue();this._oWarningIcon.destroy();if(this._oImage){this._oImage.destroy();}this._oBusy.destroy();if(this._oMoreIcon){this._oMoreIcon.destroy();}if(this._oRemoveButton){this._oRemoveButton.destroy();}};
m.prototype.onBeforeRendering=function(){var s=!!this.getSubheader();if(this.getMode()===l.GenericTileMode.HeaderMode){this._applyHeaderMode(s);}else{this._applyContentMode(s);}var t=this.getTileContent().length;for(var i=0;i<t;i++){this.getTileContent()[i].setProperty("disabled",this.getState()===l.LoadState.Disabled,true);}this._initScopeContent("sapMGT");this._generateFailedText();this.$().off("mouseenter");this.$().off("mouseleave");if(this._sParentResizeListenerId){R.deregister(this._sResizeListenerId);this._sParentResizeListenerId=null;}D.media.detachHandler(this._handleMediaChange,this,h);if(this._$RootNode){this._$RootNode.off(this._getAnimationEvents());}if(this.getFrameType()===l.FrameType.Auto){this.setProperty("frameType",l.FrameType.OneByOne,true);}};
m.prototype.onAfterRendering=function(){this._setupResizeClassHandler();this.$().on("mouseenter",this._updateAriaAndTitle.bind(this));this.$().on("mouseleave",this._removeTooltipFromControl.bind(this));var M=this.getMode();var s=this._isScreenLarge();if(M===l.GenericTileMode.LineMode){var p=this.$().parent();if(s){p.addClass("sapMGTLineModeContainer");p.removeClass("sapMGTLineModeListContainer");p.addClass("sapMGTLineModeFloatingContainer");this._updateHoverStyle(true);if(this.getParent()instanceof C){this._sParentResizeListenerId=R.register(this.getParent(),this._handleResize.bind(this));}else{this._sParentResizeListenerId=R.register(p,this._handleResize.bind(this));}}else{p.removeClass("sapMGTLineModeFloatingContainer");p.addClass("sapMGTLineModeListContainer");}}if(M===l.GenericTileMode.LineMode&&this._bUpdateLineTileSiblings){this._updateLineTileSiblings();this._bUpdateLineTileSiblings=false;}if(M===l.GenericTileMode.LineMode){D.media.attachHandler(this._handleMediaChange,this,h);}this.onDragComplete();};
m.prototype.onDragComplete=function(){if(this.hasStyleClass("sapMGTPressActive")){this.removeStyleClass("sapMGTPressActive");if(this.$("hover-overlay").length>0){this.$("hover-overlay").removeClass("sapMGTPressActive");}if(this.getMode()===l.GenericTileMode.LineMode){this.removeStyleClass("sapMGTLineModePress");}}};
m.prototype._handleResize=function(){if(this.getMode()===l.GenericTileMode.LineMode&&this._isScreenLarge()&&this.getParent()){this._queueAnimationEnd();}};
m.prototype._setupResizeClassHandler=function(){var i=function(){if(this.getSizeBehavior()===g.Small||window.matchMedia("(max-width: 374px)").matches){this.$().addClass("sapMTileSmallPhone");}else{this.$().removeClass("sapMTileSmallPhone");}}.bind(this);q(window).on("resize",i);i();};
m.prototype._isCompact=function(){return q("body").hasClass("sapUiSizeCompact")||this.$().is(".sapUiSizeCompact")||this.$().closest(".sapUiSizeCompact").length>0;};
m.prototype._calculateStyleData=function(){this.$("lineBreak").remove();if(!this._isScreenLarge()||!this.getDomRef()||this.$().is(":hidden")){return null;}var $=this.$(),E=this.$("endMarker"),s=this.$("startMarker");if(E.length===0||s.length===0){return null;}var k=this._getLineCount(),n,o,p=Math.ceil(L._getCSSPixelValue(this,"margin-top")),r,A=this.$().parent().innerWidth(),t=Math.ceil(L._getCSSPixelValue(this,"min-height")),u=L._getCSSPixelValue(this,"line-height"),v=this.$().is(":not(:first-child)")&&k>1,w=q("<span><br></span>"),i=0,x=sap.ui.getCore().getConfiguration().getRTL(),y=E.position();if(v){w.attr("id",this.getId()+"-lineBreak");$.prepend(w);k=this._getLineCount();y=E.position();}var z={rtl:x,lineBreak:v,startOffset:s.offset(),endOffset:E.offset(),availableWidth:A,lines:[]};var J;if(D.browser.msie||D.browser.edge){J=w.find("br").position();}else{J=w.position();}var K=J;if(!(D.browser.mozilla||D.browser.msie||D.browser.edge)&&J.left<y.left){K=y;}z.positionLeft=v?J.left:$.position().left;z.positionRight=v?$.width()-K.left:z.availableWidth-$.position().left;if(!v&&k>1){z.positionRight=s.parent().innerWidth()-(s.position().left+s.width());}for(i;i<k;i++){if(v&&i===0){continue;}if(k===1){n=x?z.availableWidth-z.positionLeft:z.positionLeft;r=$.width();}else if(i===k-1){n=0;r=x?$.width()-y.left:y.left;}else if(v&&i===1){n=0;r=A;}else{n=0;r=A;}o=i*u+p;z.lines.push({offset:{x:n,y:o},width:r,height:t});}return z;};
m.prototype._getStyleData=function(){var s=this._calculateStyleData();if(!d(this._oStyleData,s)){delete this._oStyleData;this._oStyleData=s;return true;}return false;};
m.prototype._getAnimationEvents=function(){return"transitionend.sapMGT$id animationend.sapMGT$id".replace(/\$id/g,c(this.getId()));};
m.prototype._updateHoverStyle=function(i){if(!this._getStyleData()&&!i){return;}this._clearAnimationUpdateQueue();this._cHoverStyleUpdates=-1;this._oAnimationEndCallIds={};if(this._oStyleData&&this._oStyleData.lineBreak&&this.getUIArea()){this._$RootNode=q(this.getUIArea().getRootNode());this._$RootNode.on(this._getAnimationEvents(),this._queueAnimationEnd.bind(this));}this._queueAnimationEnd();};
m.prototype._queueAnimationEnd=function(E){if(E){var t=q(E.target);if(t.is(".sapMGT, .sapMGT *")){return false;}}if(typeof this._cHoverStyleUpdates!=="number"){this._cHoverStyleUpdates=-1;}if(!this._oAnimationEndCallIds){this._oAnimationEndCallIds={};}this._cHoverStyleUpdates++;this._oAnimationEndCallIds[this._cHoverStyleUpdates]=setTimeout(this._handleAnimationEnd.bind(this,this._cHoverStyleUpdates),10);};
m.prototype._handleAnimationEnd=function(i){delete this._oAnimationEndCallIds[i];if(this._cHoverStyleUpdates===i){this._getStyleData();L._updateHoverStyle.call(this);}};
m.prototype._clearAnimationUpdateQueue=function(){for(var k in this._oAnimationEndCallIds){clearTimeout(this._oAnimationEndCallIds[k]);delete this._oAnimationEndCallIds[k];}};
m.prototype._getLineCount=function(){var o=this.getDomRef().getBoundingClientRect(),i=L._getCSSPixelValue(this,"line-height");return Math.round(o.height/i);};
m.prototype.getBoundingRects=function(){var p=this.$().offset();if(this.getMode()===l.GenericTileMode.LineMode&&this._isScreenLarge()){this._getStyleData();var r=[],s,o;this.$().find(".sapMGTLineStyleHelper").each(function(){s=q(this);o=s.offset();r.push({offset:{x:o.left,y:o.top},width:s.width(),height:s.height()});});return r;}else{return[{offset:{x:p.left,y:p.top},width:this.$().width(),height:this.$().height()}];}};
m.prototype._updateLineTileSiblings=function(){var p=this.getParent();if(this.getMode()===l.GenericTileMode.LineMode&&this._isScreenLarge()&&p){var i=p.indexOfAggregation(this.sParentAggregationName,this);var s=p.getAggregation(this.sParentAggregationName).splice(i+1);for(i=0;i<s.length;i++){var o=s[i];if(o instanceof l.GenericTile&&o.getMode()===l.GenericTileMode.LineMode){o._updateHoverStyle();}}}};
m.prototype.ontouchstart=function(){this.addStyleClass("sapMGTPressActive");if(this.$("hover-overlay").length>0){this.$("hover-overlay").addClass("sapMGTPressActive");}if(this.getMode()===l.GenericTileMode.LineMode){this.addStyleClass("sapMGTLineModePress");}};
m.prototype.ontouchcancel=function(){this.removeStyleClass("sapMGTPressActive");if(this.$("hover-overlay").length>0){this.$("hover-overlay").removeClass("sapMGTPressActive");}};
m.prototype.ontouchend=function(){this.removeStyleClass("sapMGTPressActive");if(this.$("hover-overlay").length>0){this.$("hover-overlay").removeClass("sapMGTPressActive");}if(this.getMode()===l.GenericTileMode.LineMode){this.removeStyleClass("sapMGTLineModePress");}};
m.prototype.ontap=function(i){var p;if(this._bTilePress&&this.getState()!==l.LoadState.Disabled){this.$().trigger("focus");p=this._getEventParams(i);if(!(this.isInActionRemoveScope()&&p.action===m._Action.Press)){this.firePress(p);}i.preventDefault();}};
m.prototype.onkeydown=function(i){var k=j[i.keyCode];if(!k){j[i.keyCode]=true;if(j[32]||j[13]){i.preventDefault();}}if(P.events.sapselect.fnCheck(i)&&this.getState()!==l.LoadState.Disabled){this.addStyleClass("sapMGTPressActive");if(this.$("hover-overlay").length>0){this.$("hover-overlay").addClass("sapMGTPressActive");}i.preventDefault();}};
m.prototype._updateAriaLabel=function(){var A=this._getAriaText(),t=this.$(),i=false;if(t.attr("aria-label")!==A){t.attr("aria-label",A);i=true;}return i;};
m.prototype.onkeyup=function(i){var k=j[i.keyCode];if(k){delete j[i.keyCode];}var p,n=false,s=this.getScope(),A=s===l.GenericTileScope.Actions||s===l.GenericTileScope.ActionRemove;if(A&&(P.events.sapdelete.fnCheck(i)||P.events.sapbackspace.fnCheck(i))){p={scope:s,action:m._Action.Remove,domRef:this._oRemoveButton.getPopupAnchorDomRef()};n=true;}if(P.events.sapselect.fnCheck(i)&&this.getState()!==l.LoadState.Disabled){this.removeStyleClass("sapMGTPressActive");if(this.$("hover-overlay").length>0){this.$("hover-overlay").removeClass("sapMGTPressActive");}p=this._getEventParams(i);n=true;}if(n){this.firePress(p);i.preventDefault();}this._updateAriaLabel();};
m.prototype.setProperty=function(p){C.prototype.setProperty.apply(this,arguments);if(this.getMode()===l.GenericTileMode.LineMode&&m.LINEMODE_SIBLING_PROPERTIES.indexOf(p)!==-1){this._bUpdateLineTileSiblings=true;}return this;};
m.prototype.getHeader=function(){return this._oTitle.getText();};
m.prototype.setHeader=function(t){this.setProperty("header",t);this._oTitle.setText(t);return this;};
m.prototype.setHeaderImage=function(u){var v=!d(this.getHeaderImage(),u);if(v){if(this._oImage){this._oImage.destroy();this._oImage=undefined;}if(u){this._oImage=a.createControlByURI({id:this.getId()+"-icon-image",src:u},l.Image);this._oImage.addStyleClass("sapMGTHdrIconImage");}}return this.setProperty("headerImage",u);};
m.prototype._applyHeaderMode=function(s){var i=this.getFrameType();if(i===F.OneByHalf||i===F.TwoByHalf){this._oTitle.setProperty("maxLines",2,true);}else{if(s){this._oTitle.setProperty("maxLines",4,true);}else{this._oTitle.setProperty("maxLines",5,true);}}this._changeTileContentContentVisibility(false);};
m.prototype._applyContentMode=function(s){var k=this.getFrameType();var t=this.getTileContent();if(k===F.TwoByHalf||k===F.OneByHalf){if(t.length){for(var i=0;i<t.length;i++){var n=t[i].getAggregation('content');if(n!==null){if((k===F.OneByHalf&&n.getMetadata()._sClassName==="sap.m.ImageContent")){this._oTitle.setProperty("maxLines",2,true);break;}else{this._oTitle.setProperty("maxLines",1,true);break;}}this._oTitle.setProperty("maxLines",2,true);}}else{this._oTitle.setProperty("maxLines",2,true);}}else if(s){this._oTitle.setProperty("maxLines",2,true);}else{this._oTitle.setProperty("maxLines",3,true);}this._changeTileContentContentVisibility(true);};
m.prototype._changeTileContentContentVisibility=function(v){var t;t=this.getTileContent();for(var i=0;i<t.length;i++){t[i].setRenderContent(v);}};
m.prototype._getHeaderAriaAndTooltipText=function(){var t="";var i=true;if(this.getHeader()){t+=this.getHeader();i=false;}if(this.getSubheader()){t+=(i?"":"\n")+this.getSubheader();i=false;}if(this.getImageDescription()){t+=(i?"":"\n")+this.getImageDescription();}return t;};
m.prototype._getContentAriaAndTooltipText=function(){var t="";var k=true;var n=this.getTileContent();var A=this.getAdditionalTooltip();if(!this._isInActionScope()&&this.getMode()===l.GenericTileMode.ContentMode){for(var i=0;i<n.length;i++){if(typeof n[i]._getAriaAndTooltipText==="function"){t+=(k?"":"\n")+n[i]._getAriaAndTooltipText();}else if(n[i].getTooltip_AsString()){t+=(k?"":"\n")+n[i].getTooltip_AsString();}k=false;}}if(A){t+=(k?"":"\n")+A;}return t;};
m.prototype._getAriaAndTooltipText=function(){var A=(this.getTooltip_AsString()&&!this._isTooltipSuppressed())?this.getTooltip_AsString():(this._getHeaderAriaAndTooltipText()+"\n"+this._getContentAriaAndTooltipText());switch(this.getState()){case l.LoadState.Disabled:return"";case l.LoadState.Loading:return A+"\n"+this._sLoading;case l.LoadState.Failed:return A+"\n"+this._oFailedText.getText();default:if(A.trim().length===0){return"";}else{return A;}}};
m.prototype._getAriaText=function(){var A=this.getTooltip_Text();var s=this.getAriaLabel();if(!A||this._isTooltipSuppressed()){A=this._getAriaAndTooltipText();}if(this._isInActionScope()){A=this._oRb.getText("GENERICTILE_ACTIONS_ARIA_TEXT")+" "+A;}if(s){A=s+" "+A;}return A;};
m.prototype._getTooltipText=function(){var t=this.getTooltip_Text();if(this._isTooltipSuppressed()===true){t=null;}return t;};
m.prototype._checkFooter=function(t,i){var s=i.getState();var A=this._isInActionScope()||this._bShowActionsView===true;var k=this.getFrameType();var n=t.getAggregation('content');if(s===l.LoadState.Failed||A&&s!==l.LoadState.Disabled){t.setRenderFooter(false);}else if(k===F.TwoByHalf&&(n!==null||this.getSubheader())){t.setRenderFooter(false);}else if(k===F.OneByHalf&&((n!==null&&n.getMetadata()._sClassName!=="sap.m.ImageContent")||this.getSubheader())){t.setRenderFooter(false);}else{t.setRenderFooter(true);}};
m.prototype._isInActionScope=function(){return this.getScope()===l.GenericTileScope.Actions||this.getScope()===l.GenericTileScope.ActionMore||this.getScope()===l.GenericTileScope.ActionRemove;};
m.prototype.isInActionRemoveScope=function(){return this.getScope()===l.GenericTileScope.ActionRemove;};
m.prototype._generateFailedText=function(){var s=this.getFailedText();var i=s?s:this._sFailedToLoad;this._oFailedText.setProperty("text",i,true);this._oFailedText.setAggregation("tooltip",i,true);};
m.prototype._isTooltipSuppressed=function(){var t=this.getTooltip_Text();if(t&&t.length>0&&t.trim().length===0){return true;}else{return false;}};
m.prototype._isHeaderTextTruncated=function(){var o,M,$,w;if(this.getMode()===l.GenericTileMode.LineMode){$=this.$("hdr-text");if($.length>0){w=Math.ceil($[0].getBoundingClientRect().width);return($[0]&&w<$[0].scrollWidth);}else{return false;}}else{o=this.getAggregation("_titleText").getDomRef("inner");M=this.getAggregation("_titleText").getClampHeight(o);return(M<o.scrollHeight);}};
m.prototype._isSubheaderTextTruncated=function(){var s;if(this.getMode()===l.GenericTileMode.LineMode){s=this.$("subHdr-text");}else{s=this.$("subTitle");}if(s.length>0){var w=Math.ceil(s[0].getBoundingClientRect().width);return(s[0]&&w<s[0].scrollWidth);}else{return false;}};
m.prototype._setTooltipFromControl=function(){var t=this._getAriaAndTooltipText();if(t&&!this._getTooltipText()&&!this._isTooltipSuppressed()){this.$().attr("title",t.trim());this._bTooltipFromControl=true;}};
m.prototype._updateAriaAndTitle=function(){var A=this._getAriaAndTooltipText();var s=this._getAriaText();var t=this.$();if(t.attr("title")!==A){t.attr("aria-label",s);}if(this._isInActionScope()){t.find('*:not(.sapMGTRemoveButton)').removeAttr("aria-label").removeAttr("title").off("mouseenter");}else{t.find('*').removeAttr("aria-label").removeAttr("title").off("mouseenter");}this._setTooltipFromControl();};
m.prototype._removeTooltipFromControl=function(){if(this._bTooltipFromControl){this.$().removeAttr("title");this._bTooltipFromControl=false;}};
m.prototype._isScreenLarge=function(){return this._getCurrentMediaContainerRange(h).name==="large";};
m.prototype._getEventParams=function(E){var p,A=m._Action.Press,s=this.getScope(),o=this.getDomRef();if((s===l.GenericTileScope.Actions||l.GenericTileScope.ActionRemove)&&E.target.id.indexOf("-action-remove")>-1){A=m._Action.Remove;o=this._oRemoveButton.getPopupAnchorDomRef();}else if(s===l.GenericTileScope.Actions||s===l.GenericTileScope.ActionMore){o=this._oMoreIcon.getDomRef();}p={scope:s,action:A,domRef:o};return p;};
m.prototype._handleMediaChange=function(){this._bUpdateLineTileSiblings=true;this.invalidate();};
m.prototype.setPressEnabled=function(v){this._bTilePress=v;};
m.prototype.showActionsView=function(v){if(this._bShowActionsView!==v){this._bShowActionsView=v;this.invalidate();}};
return m;});
sap.ui.predefine('sap/m/GenericTileLineModeRenderer',["sap/m/library","sap/base/security/encodeCSS","sap/ui/thirdparty/jquery"],function(l,e,q){"use strict";var G=l.GenericTileScope;var L=l.LoadState;var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");var a={apiVersion:2};
a.render=function(R,c){var t=c._getTooltipText(),i=c._isScreenLarge(),A=c._getAriaText(),s=c.getScope(),S,I=false,h=c.hasListeners("press"),b=c.getState(),d=c.getAriaRoleDescription(),f=c.getAriaRole();var g=c.getUrl()&&!c._isInActionScope()&&b!==L.Disabled;this._bRTL=sap.ui.getCore().getConfiguration().getRTL();if(s===G.Actions){S=e("sapMGTScopeActions");}else if(s===G.ActionMore||s===G.ActionRemove){I=true;S=e("sapMGTScopeSingleAction");}else{S=e("sapMGTScopeDisplay");}if(g){R.openStart("a",c);R.attr("href",c.getUrl());R.attr("draggable","false");}else{R.openStart("span",c);}R.attr("aria-label",A);if(d){R.attr("aria-roledescription",d);}else{R.attr("aria-roledescription",r.getText("GENERIC_TILE_ROLE_DESCRIPTION"));}if(f){R.attr("role",f);}else if(!g){R.attr("role",h?"button":"presentation");}else{R.attr("role","link");}R.class("sapMGT");R.class(S);R.class("sapMGTLineMode");this._writeDirection(R);if(t){R.attr("title",t);}if(b!==L.Disabled){if(!c.isInActionRemoveScope()){R.class("sapMPointer");}R.attr("tabindex","0");}else{R.class("sapMGTDisabled");}if(b===L.Failed){R.class("sapMGTFailed");}R.openEnd();if(i){R.openStart("div",c.getId()+"-startMarker");R.class("sapMGTStartMarker");R.openEnd();R.close("div");this._renderFailedIcon(R,c);this._renderHeader(R,c);if(c.getSubheader()){this._renderSubheader(R,c);}R.openStart("div",c.getId()+"-endMarker");R.class("sapMGTEndMarker");R.openEnd();if(c._isInActionScope()){this._renderActionsScope(R,c,I);}R.close("div");R.openStart("div",c.getId()+"-styleHelper");R.class("sapMGTStyleHelper");R.openEnd();R.close("div");}else{if(c.getState()!==L.Disabled){this._renderFocusDiv(R,c);}R.openStart("div",c.getId()+"-touchArea");R.class("sapMGTTouchArea");R.openEnd();this._renderFailedIcon(R,c);R.openStart("span",c.getId()+"-lineModeHelpContainer");R.class("sapMGTLineModeHelpContainer");R.openEnd();this._renderHeader(R,c);if(c.getSubheader()){this._renderSubheader(R,c);}R.close("span");if(c._isInActionScope()){this._renderActionsScope(R,c,I);}R.close("div");}if(g){R.close("a");}else{R.close("span");}};
a._writeDirection=function(R){if(this._bRTL){R.attr("dir","rtl");}};
a._renderFailedIcon=function(R,c){if(c.getState()===L.Failed){if(c._isCompact()){c._oWarningIcon.setSize("1.25rem");}else{c._oWarningIcon.setSize("1.375rem");}R.renderControl(c._oWarningIcon.addStyleClass("sapMGTLineModeFailedIcon"));}};
a._renderHeader=function(R,c){R.openStart("span",c.getId()+"-hdr-text");this._writeDirection(R);R.class("sapMGTHdrTxt");R.openEnd();R.text(c._oTitle.getText());R.close("span");};
a._renderSubheader=function(R,c){R.openStart("span",c.getId()+"-subHdr-text");this._writeDirection(R);R.class("sapMGTSubHdrTxt");R.openEnd();R.text(c._oSubTitle.getText());R.close("span");};
a._renderActionsScope=function(R,c,i){if(c.getState()!==L.Disabled){R.openStart("span",c.getId()+"-actions");R.class("sapMGTActionsContainer");if(i){R.class("sapMGTScopeSingleActionContainer");}R.openEnd();R.renderControl(c._oMoreIcon);R.renderControl(c._oRemoveButton);R.close("span");}};
a._updateHoverStyle=function(){var s=this.$("styleHelper"),o,i=0,h="";s.empty();if(!this._oStyleData||this.$().is(":hidden")){return;}if(this._oStyleData.rtl){s.css("right",-this._oStyleData.positionRight);}else{s.css("left",-this._oStyleData.positionLeft);}for(i;i<this._oStyleData.lines.length;i++){o=this._oStyleData.lines[i];var R=q("<div class='sapMGTLineStyleHelper'><div class='sapMGTLineStyleHelperInner'></div></div>");if(this._oStyleData.rtl){R.css("right",o.offset.x+"px");}else{R.css("left",o.offset.x+"px");}R.css({top:o.offset.y+"px",width:o.width+"px",height:o.height});h+=R.get(0).outerHTML.trim();}s.html(h);};
a._renderFocusDiv=function(R,c){R.openStart("div",c.getId()+"-focus");R.class("sapMGTFocusDiv");R.openEnd();R.close("div");};
a._getCSSPixelValue=function(o,p){var O=o instanceof q?o:o.$(),m=(O.css(p)||"").match(/([^a-zA-Z\%]*)(.*)/),v=parseFloat(m[1]),u=m[2];return(u==="px")?v:v*16;};
return a;},true);
sap.ui.predefine('sap/m/GenericTileRenderer',["sap/m/library","sap/base/security/encodeCSS"],function(l,e){"use strict";var G=l.GenericTileMode;var L=l.LoadState;var f=l.FrameType;var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");var a={apiVersion:2};
a.render=function(R,c){var t=c._getTooltipText();var A=c._getAriaText();var h=c.getHeaderImage();var H=c.hasListeners("press");var s=c.getState();var S=e("sapMGTState"+s);var b;var d=c.getFrameType();var g=c.getAriaRoleDescription();var j=c.getAriaRole();var k=c.getUrl()&&!c._isInActionScope()&&s!==L.Disabled;if(c._isInActionScope()){b=e("sapMGTScopeActions");}else{b=e("sapMGTScopeDisplay");}if(k){R.openStart("a",c);R.attr("href",c.getUrl());R.attr("draggable","false");}else{R.openStart("div",c);}if(t){R.attr("title",t);}R.class("sapMGT");R.class(S);R.class(b);if(!c._isInActionScope()&&c._bShowActionsView){R.class("sapMGTScopeActions");}R.class(d);if(j){R.attr("role",j);}else if(!k){R.attr("role",H?"button":"presentation");}else{R.attr("role","link");}R.attr("aria-label",A);if(g){R.attr("aria-roledescription",g);}else{R.attr("aria-roledescription",r.getText("GENERIC_TILE_ROLE_DESCRIPTION"));}if(s!==L.Disabled){if(!c.isInActionRemoveScope()){R.class("sapMPointer");}R.attr("tabindex","0");}if(c.getWidth()){R.style("width",c.getWidth());}if(c.getBackgroundImage()){R.style("background-image","url('"+e(c.getBackgroundImage())+"')");R.class("sapMGTBackgroundImage");}if(c.getMode()===G.HeaderMode){R.class("sapMGTHeaderMode");}R.openEnd();R.openStart("div");R.class("sapMGTHdrContent");R.class(d);if(t){R.attr("title",t);}R.openEnd();if(h){R.renderControl(c._oImage);}this._renderHeader(R,c);var T=c.getTileContent();var m=T.length;var n=d===f.OneByHalf||d===f.TwoByHalf;var o=false;for(var i=0;i<m;i++){if(T[i].getAggregation("content")!==null){if(d===f.OneByHalf&&T[i].getAggregation("content").getMetadata()._sClassName==="sap.m.ImageContent"){o=false;}else{o=true;break;}}}if(!(n&&o)){if(c.getSubheader()){this._renderSubheader(R,c);}}R.close("div");R.openStart("div",c.getId()+"-content");R.class("sapMGTContent");R.openEnd();for(var i=0;i<m;i++){c._checkFooter(T[i],c);R.renderControl(T[i]);}R.close("div");if(s!==L.Loaded){this._renderStateOverlay(R,c,t);}if(s!==L.Disabled){this._renderHoverOverlay(R,c);this._renderFocusDiv(R,c);}if(c._isInActionScope()){this._renderActionsScope(R,c);}if(k){R.close("a");}else{R.close("div");}};
a._renderFocusDiv=function(R,c){R.openStart("div",c.getId()+"-focus");R.class("sapMGTFocusDiv");R.openEnd();R.close("div");};
a._renderStateOverlay=function(R,c,t){var s=c.getState();R.openStart("div",c.getId()+"-overlay");R.class("sapMGTOverlay");if(t){R.attr("title",t);}R.openEnd();switch(s){case L.Loading:c._oBusy.setBusy(s==L.Loading);R.renderControl(c._oBusy);break;case L.Failed:R.openStart("div",c.getId()+"-failed-ftr");R.class("sapMGenericTileFtrFld");R.openEnd();R.openStart("div",c.getId()+"-failed-icon");R.class("sapMGenericTileFtrFldIcn");R.openEnd();R.renderControl(c._oWarningIcon);R.close("div");if(!c._isInActionScope()&&!c._bShowActionsView){R.openStart("div",c.getId()+"-failed-text");R.class("sapMGenericTileFtrFldTxt");R.openEnd();R.renderControl(c.getAggregation("_failedMessageText"));R.close("div");}R.close("div");break;default:}R.close("div");};
a._renderActionsScope=function(R,c){if(c.getState()!==L.Disabled){R.renderControl(c._oRemoveButton);R.renderControl(c._oMoreIcon);}};
a._renderHoverOverlay=function(R,c){R.openStart("div",c.getId()+"-hover-overlay");if(c.getBackgroundImage()){R.class("sapMGTWithImageHoverOverlay");}else{R.class("sapMGTWithoutImageHoverOverlay");}R.openEnd();R.close("div");};
a._renderHeader=function(R,c){R.openStart("div",c.getId()+"-hdr-text");R.class("sapMGTHdrTxt");R.openEnd();R.renderControl(c._oTitle);R.close("div");};
a._renderSubheader=function(R,c){R.openStart("div",c.getId()+"-subHdr-text");R.class("sapMGTSubHdrTxt");R.openEnd();R.renderControl(c._oSubTitle);R.close("div");};
return a;},true);
sap.ui.predefine('sap/m/GroupHeaderListItem',["sap/ui/core/library","./library","./ListItemBase","./GroupHeaderListItemRenderer"],function(c,l,L,G){"use strict";var a=l.ListMode;var T=c.TextDirection;
var b=L.extend("sap.m.GroupHeaderListItem",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Data",defaultValue:null},count:{type:"string",group:"Data",defaultValue:null},upperCase:{type:"boolean",group:"Appearance",defaultValue:false},titleTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit}}}});
b.prototype.getMode=function(){return a.None;};
b.prototype.shouldClearLastValue=function(){return true;};
b.prototype.getTable=function(){var p=this.getParent();if(p&&p.isA("sap.m.Table")){return p;}};
b.prototype.onBeforeRendering=function(){var t=this.getTable();if(t){t.getColumns().forEach(function(C){C.clearLastValue();});this.TagName="tr";}};
b.prototype.getAccessibilityType=function(B){var t=this.getTable()?"ROW":"OPTION";return B.getText("LIST_ITEM_GROUP_HEADER")+" "+B.getText("ACC_CTR_TYPE_"+t);};
b.prototype.getContentAnnouncement=function(){return this.getTitle();};
b.prototype.getGroupAnnouncement=function(){};
return b;});
sap.ui.predefine('sap/m/GroupHeaderListItemRenderer',["sap/ui/core/library","sap/ui/core/Renderer","./ListItemBaseRenderer"],function(c,R,L){"use strict";var T=c.TextDirection;var G=R.extend(L);G.apiVersion=2;
G.renderType=function(r,l){var t=l.getTable();if(t){if(t.hasPopin()){this.renderDummyCell(r,t);}this.renderCell(r,"sapMListTblNavCol");}L.renderType.apply(this,arguments);if(t){r.close("td");}};
G.renderNavigated=function(r,l){var t=l.getTable();if(t){this.renderCell(r,"sapMListTblNavigatedCol");}L.renderNavigated.apply(this,arguments);if(t){r.close("td");}};
G.renderDummyCell=function(r,t){if(t.shouldRenderDummyColumn()){this.renderCell(r,"sapMListTblDummyCell");r.close("td");}};
G.renderCell=function(r,C){r.openStart("td");r.class(C);r.attr("role","presentation");r.attr("aria-hidden","true");r.openEnd();};
G.renderCounter=function(r,l){};
G.renderLIAttributes=function(r,l){r.class("sapMGHLI");if(l.getUpperCase()){r.class("sapMGHLIUpperCase");}var t=l.getTable();if(t&&t.shouldRenderDummyColumn()){r.class("sapMListTblRowHasDummyCell");}};
G.renderLIContentWrapper=function(r,l){var t=l.getTable();if(t){r.openStart("td");r.class("sapMGHLICell");r.attr("colspan",t.getColSpan());r.openEnd();}L.renderLIContentWrapper.apply(this,arguments);if(t){r.close("td");}};
G.renderLIContent=function(r,l){var t=l.getTitleTextDirection();r.openStart("span");r.class("sapMGHLITitle");if(t!=T.Inherit){r.attr("dir",t.toLowerCase());}r.openEnd();r.text(l.getTitle());r.close("span");var C=l.getCount()||l.getCounter();if(C){r.openStart("span");r.class("sapMGHLICounter");r.openEnd();r.text(" ("+C+")");r.close("span");}};
G.addLegacyOutlineClass=function(r,l){if(!l.getTable()){L.addLegacyOutlineClass.apply(this,arguments);}};
G.getAriaRole=function(l){if(l.getTable()){return"row";}return L.getAriaRole.apply(this,arguments);};
return G;},true);
sap.ui.predefine('sap/m/GrowingEnablement',['sap/ui/base/Object','sap/ui/core/format/NumberFormat','sap/m/library','sap/ui/model/ChangeReason','sap/ui/base/ManagedObjectMetadata','sap/ui/core/HTML','sap/m/CustomListItem',"sap/base/security/encodeXML"],function(B,N,l,C,M,H,a,e){"use strict";var L=l.ListType;var b=l.ListGrowingDirection;
var G=B.extend("sap.m.GrowingEnablement",{
constructor:function(c){B.apply(this);this._oControl=c;this._oControl.bUseExtendedChangeDetection=true;this._oControl.addDelegate(this);var r=this._oControl.getItems(true).length;this._iRenderedDataItems=r;this._iLimit=r;this._bLoading=false;this._sGroupingPath="";this._bDataRequested=false;this._oContainerDomRef=null;this._iLastItemsCount=0;this._iTriggerTimer=0;this._aChunk=[];this._oRM=null;},
destroy:function(){if(this._oTrigger){this._oTrigger.destroy();this._oTrigger=null;}if(this._oScrollDelegate){this._oScrollDelegate.setGrowingList(null);this._oScrollDelegate=null;}if(this._oRM){this._oRM.destroy();this._oRM=null;}this._oControl.$("triggerList").remove();this._oControl.bUseExtendedChangeDetection=false;this._oControl.removeDelegate(this);this._oContainerDomRef=null;this._oControl=null;},
render:function(r){r.openStart("div",this._oControl.getId()+"-triggerList");r.class("sapMListUl").class("sapMGrowingList");r.style("display","none");r.openEnd();r.renderControl(this._getTrigger());r.close("div");},
onAfterRendering:function(){var c=this._oControl;if(c.getGrowingScrollToLoad()){var s=l.getScrollDelegate(c);if(s){this._oScrollDelegate=s;s.setGrowingList(this.onScrollToLoad.bind(this),c.getGrowingDirection(),this._updateTrigger.bind(this,false));}}else if(this._oScrollDelegate){this._oScrollDelegate.setGrowingList(null);this._oScrollDelegate=null;}if(!this._bLoading){this._updateTriggerDelayed(false);}},
setTriggerText:function(t){this._oControl.$("triggerText").text(t);},
reset:function(){this._iLimit=0;var o=this._oControl.getBindingInfo("items");this._oControl.oExtendedChangeDetectionConfig=(!o||!o.template)?null:{replace:true};},
shouldReset:function(c){var m=C;return c==m.Sort||c==m.Filter||c==m.Context;},
getInfo:function(){return{total:this._oControl.getMaxItemsCount(),actual:this._iRenderedDataItems};},
onScrollToLoad:function(){var t=this._oControl.getDomRef("triggerList");if(this._bLoading||!t||t.style.display!="none"){return;}if(this._oControl.getGrowingDirection()==b.Upwards){var s=this._oScrollDelegate;this._oScrollPosition={left:s.getScrollLeft(),top:s.getScrollHeight()};}this.requestNewPage();},
requestNewPage:function(){if(!this._oControl||this._bLoading){return;}var o=this._oControl.getBinding("items");if(o&&!o.isLengthFinal()||this._iLimit<this._oControl.getMaxItemsCount()){if(this._oControl.getMetadata().hasProperty("enableBusyIndicator")){this._bParentEnableBusyIndicator=this._oControl.getEnableBusyIndicator();this._oControl.setEnableBusyIndicator(false);}this._iLimit+=this._oControl.getGrowingThreshold();this._updateTriggerDelayed(true);this.updateItems("Growing");}},
_onBeforePageLoaded:function(c){this._bLoading=true;this._oControl.onBeforePageLoaded(this.getInfo(),c);},
_onAfterPageLoaded:function(c){this._bLoading=false;this._updateTriggerDelayed(false);this._oControl.onAfterPageLoaded(this.getInfo(),c);if(this._oControl.setEnableBusyIndicator){this._oControl.setEnableBusyIndicator(this._bParentEnableBusyIndicator);}},
_getTrigger:function(){var t=this._oControl.getId()+"-trigger",T=this._oControl.getGrowingTriggerText();T=T||sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("LOAD_MORE_DATA");this._oControl.addNavSection(t);if(this._oTrigger){this.setTriggerText(T);return this._oTrigger;}this._oTrigger=new a({id:t,busyIndicatorDelay:0,type:L.Active,content:new H({content:'<div class="sapMGrowingListTrigger">'+'<div class="sapMSLIDiv sapMGrowingListTriggerText">'+'<span class="sapMSLITitle" id="'+t+'Text">'+e(T)+'</span>'+'</div>'+'<div class="sapMGrowingListDescription sapMSLIDescription" id="'+t+'Info"></div>'+'</div>'})}).setParent(this._oControl,null,true).attachPress(this.requestNewPage,this).addDelegate({onsapenter:function(E){this.requestNewPage();E.preventDefault();},onsapspace:function(E){this.requestNewPage();E.preventDefault();},onAfterRendering:function(E){var $=this._oTrigger.$();$.removeAttr("aria-selected");$.attr({"tabindex":0,"role":"button","aria-labelledby":t+"Text"+" "+t+"Info"});}},this);this._oTrigger.getList=function(){};this._oTrigger.TagName="div";return this._oTrigger;},
_getListItemInfo:function(){return("[ "+this._iRenderedDataItems+" / "+N.getFloatInstance().format(this._oControl.getMaxItemsCount())+" ]");},
_getGroupingPath:function(o){var s=o.aSorters||[];var S=s[0]||{};return(S.fnGroup)?S.sPath||"":"";},
_getDomIndex:function(i){if(typeof i!="number"){return i;}if(this._oControl.hasPopin&&this._oControl.hasPopin()){return(i*2);}return i;},
_getHasScrollbars:function(){if(!this._oScrollDelegate){return false;}if(this._iRenderedDataItems>=40){return true;}return this._oScrollDelegate.getMaxScrollTop()>this._oControl.getDomRef("triggerList").clientHeight;},
destroyListItems:function(s){this._oControl.destroyItems(s);this._iRenderedDataItems=0;this._aChunk=[];},
addListItem:function(c,o,s){var d=this._oControl,f=o.binding,i=this.createListItem(c,o);if(f.isGrouped()){var I=d.getItems(true),g=I[I.length-1],m=o.model,h=f.getGroup(i.getBindingContext(m));if(g&&g.isGroupHeader()){d.removeAggregation("items",g,true);this._fnAppendGroupItem=this.appendGroupItem.bind(this,h,g,s);g=I[I.length-1];}if(!g||h.key!==f.getGroup(g.getBindingContext(m)).key){var j=(o.groupHeaderFactory)?o.groupHeaderFactory(h):null;if(d.getGrowingDirection()==b.Upwards){this.applyPendingGroupItem();this._fnAppendGroupItem=this.appendGroupItem.bind(this,h,j,s);}else{this.appendGroupItem(h,j,s);}}}d.addAggregation("items",i,s);if(s){this._aChunk.push(i);}},
applyPendingGroupItem:function(){if(this._fnAppendGroupItem){this._fnAppendGroupItem();this._fnAppendGroupItem=undefined;}},
appendGroupItem:function(g,o,s){o=this._oControl.addItemGroup(g,o,s);if(s){this._aChunk.push(o);}},
createListItem:function(c,o){this._iRenderedDataItems++;return G.createItem(c,o);},
updateItemsBindingContext:function(d,m){if(!d.length){return;}var I=this._oControl.getItems(true);for(var i=0,c=0,o;i<I.length;i++){o=I[i];if(!o.isGroupHeader()){o.setBindingContext(d[c++],m);}}},
applyChunk:function(I,d){this.applyPendingGroupItem();var c=this._aChunk.length;if(!c){return;}if(this._oControl.isA("sap.m.Table")){var h=this._oControl.getColumns().some(function(o){return o.getVisible();});if(!h){return;}}if(this._oControl.getGrowingDirection()==b.Upwards){this._aChunk.reverse();if(I===true){I=0;}else if(typeof I=="number"){I=this._iRenderedDataItems-c-I;}}d=d||this._oContainerDomRef;this._oRM=this._oRM||sap.ui.getCore().createRenderManager();for(var i=0;i<c;i++){this._oRM.renderControl(this._aChunk[i]);}this._oRM.flush(d,false,this._getDomIndex(I));this._aChunk=[];},
addListItems:function(c,o,s){for(var i=0;i<c.length;i++){this.addListItem(c[i],o,s);}},
rebuildListItems:function(c,o,s){this.destroyListItems(s);this.addListItems(c,o,s);if(s){var h=this._oContainerDomRef.contains(document.activeElement);this.applyChunk(false);h&&this._oControl.focus();}else{this.applyPendingGroupItem();}},
insertListItem:function(c,o,i){var I=this.createListItem(c,o);this._oControl.insertAggregation("items",I,i,true);this._aChunk.push(I);},
deleteListItem:function(i){this._oControl.getItems(true)[i].destroy(true);this._iRenderedDataItems--;},
refreshItems:function(c){if(!this._bDataRequested){this._bDataRequested=true;this._onBeforePageLoaded(c);}if(!this._iLimit||this.shouldReset(c)||!this._oControl.getItems(true).length){this._iLimit=this._oControl.getGrowingThreshold();}this._oControl.getBinding("items").getContexts(0,this._iLimit);},
updateItems:function(c){var o=this._oControl,d=o.getBinding("items"),f=o.getBindingInfo("items"),I=o.getItems(true);if(!this._iLimit||this.shouldReset(c)||!I.length){this._iLimit=o.getGrowingThreshold();}if(this._bDataRequested){this._bDataRequested=false;}else{this._onBeforePageLoaded(c);}var g=d.getContexts(0,this._iLimit)||[];if(g.dataRequested){this._bDataRequested=true;if(g.diff&&!g.diff.length){return;}}this._oContainerDomRef=o.getItemsContainerDomRef();var D=g.diff,F=false,v;if(!g.length){this.destroyListItems();}else if(!this._oContainerDomRef){this.rebuildListItems(g,f);}else if(!D||!I.length&&D.length){if(o.shouldRenderItems()){this.rebuildListItems(g,f,true);}}else if(d.isGrouped()||o.checkGrowingFromScratch()){if(this._sGroupingPath!=this._getGroupingPath(d)){F=true;}else{for(var i=0;i<D.length;i++){var h=D[i],j=g[h.index];if(h.type=="delete"||h.type=="replace"){F=true;break;}else if(h.index!=this._iRenderedDataItems){F=true;break;}else{this.addListItem(j,f,true);v=true;}}}}else{if(this._sGroupingPath){o.removeGroupHeaders(true);}v=-1;var k=-1;for(var i=0;i<D.length;i++){var h=D[i],m=h.index,j=g[m];if(h.type=="delete"){if(v!=-1){this.applyChunk(v);k=-1;v=-1;}this.deleteListItem(m);}else if(h.type=="insert"){if(v==-1){v=m;}else if(k>-1&&m!=k+1){this.applyChunk(v);v=m;}this.insertListItem(j,f,m);k=m;}}}if(F){this.rebuildListItems(g,f,true);}else if(this._oContainerDomRef&&D){this.updateItemsBindingContext(g,f.model);this.applyChunk(v);}this._oContainerDomRef=null;this._sGroupingPath=this._getGroupingPath(d);if(!this._bDataRequested){this._onAfterPageLoaded(c);}},
_updateTriggerDelayed:function(c){if(this._oControl.getGrowingScrollToLoad()){this._iTriggerTimer&&window.cancelAnimationFrame(this._iTriggerTimer);this._iTriggerTimer=window.requestAnimationFrame(this._updateTrigger.bind(this,c));}else{this._updateTrigger(c);}},
_updateTrigger:function(c){var t=this._oTrigger,o=this._oControl,v=o&&o.getVisibleItems().length>0;if(!t||!o||!v||!o.shouldRenderItems()||!o.getDomRef()){return;}var d=o.getBinding("items");if(!d){return;}t.setBusy(c);t.$().toggleClass("sapMGrowingListBusyIndicatorVisible",c);if(c){t.setActive(false);o.$("triggerList").css("display","");}else{var i=o.getItems(true),I=i.length,f=d.getLength()||0,g=d.isLengthFinal(),h=o.getGrowingScrollToLoad(),T=t.getDomRef();if(T&&T.contains(document.activeElement)){(i[this._iLastItemsCount]||o).focus();}if(!I||!this._iLimit||(g&&this._iLimit>=f)||(h&&this._getHasScrollbars())){o.$("triggerList").css("display","none");}else{if(g){o.$("triggerInfo").css("display","block").text(this._getListItemInfo());}t.$().removeClass("sapMGrowingListBusyIndicatorVisible");o.$("triggerList").css("display","");if(o.isA("sap.m.Table")&&!o.hasPopin()&&o.shouldRenderDummyColumn()){var D=o.getDomRef("tblHeadDummyCol");var w=o.getDomRef().clientWidth-D.clientWidth;T.style.width=w+"px";}}this._iLastItemsCount=this._oControl.getItems(true).length;if(h&&this._oScrollPosition===undefined&&o.getGrowingDirection()==b.Upwards){this._oScrollPosition={left:0,top:0};}if(I>0&&this._oScrollPosition){var s=this._oScrollDelegate,S=this._oScrollPosition;s.scrollTo(S.left,s.getScrollHeight()-S.top);this._oScrollPosition=null;}}}
});
G.createItem=function(c,o,i){var I=o.factory(M.uid(i?i:"clone"),c);return I.setBindingContext(c,o.model);};
return G;});
sap.ui.predefine('sap/m/GrowingList',['./List','./library','./GrowingListRenderer'],function(L,l,G){"use strict";
var a=L.extend("sap.m.GrowingList",{metadata:{deprecated:true,library:"sap.m",properties:{threshold:{type:"int",group:"Misc",defaultValue:20},triggerText:{type:"string",group:"Appearance",defaultValue:null},scrollToLoad:{type:"boolean",group:"Behavior",defaultValue:false}}}});
a.prototype._isIncompatible=function(){return sap.ui.getCore().getConfiguration().getCompatibilityVersion("sapMGrowingList").compareTo("1.16")>=0;};
a.prototype.init=function(){L.prototype.init.call(this);if(!this._isIncompatible()){this.setGrowing();}};
a.prototype.setGrowing=function(){return L.prototype.setGrowing.call(this,true);};
!(function(g,o){["Threshold","TriggerText","ScrollToLoad"].forEach(function(p){g["set"+p]=o["setGrowing"+p];g["get"+p]=o["getGrowing"+p];});}(a.prototype,L.prototype));return a;});
sap.ui.predefine('sap/m/GrowingListRenderer',['./ListRenderer','sap/ui/core/Renderer',"sap/base/Log"],function(L,R,a){"use strict";var G=R.extend(L);G.apiVersion=2;
G.render=function(r,c){if(c._isIncompatible()){a.warning("Does not render sap.m.GrowingList#"+c.getId()+" when compatibility version is 1.16 or higher. Instead use sap.m.List/Table control with growing feature!");}else{L.render.call(this,r,c);}};
return G;},true);
sap.ui.predefine('sap/m/HBox',['./FlexBox','./library','./HBoxRenderer'],function(F,l,H){"use strict";
var a=F.extend("sap.m.HBox",{metadata:{library:"sap.m",designtime:"sap/m/designtime/HBox.designtime"}});
return a;});
sap.ui.predefine('sap/m/HBoxRenderer',['./FlexBoxRenderer'],function(F){"use strict";var H={apiVersion:2};
H.render=function(r,c){F.render.apply(this,[r,c]);};
return H;},true);
sap.ui.predefine('sap/m/HeaderContainer',['./library','./Button','./ScrollContainer','sap/ui/core/Core','sap/ui/core/Control','sap/ui/Device','sap/m/HeaderContainerItemNavigator','sap/ui/core/delegate/ItemNavigation','sap/ui/core/library','sap/ui/core/IntervalTrigger','sap/ui/base/ManagedObject','sap/ui/core/Icon','./HeaderContainerRenderer',"sap/base/Log","sap/ui/events/PseudoEvents","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/control","sap/ui/dom/jquery/scrollLeftRTL","sap/ui/dom/jquery/scrollRightRTL","sap/ui/dom/jquery/Selectors"],function(l,B,S,C,a,D,H,I,c,b,M,d,e,L,P,q){"use strict";var O=c.Orientation;
var f=a.extend("sap.m.HeaderContainerItemContainer",{
metadata:{defaultAggregation:"item",properties:{position:{type:"int",defaultValue:null},setSize:{type:"int",defaultValue:null},ariaLabelledBy:{type:"string",defaultValue:null}},aggregations:{item:{type:"sap.ui.core.Control",multiple:false}}},
renderer:function(r,o){var i=o.getAggregation("item");if(!i||!i.getVisible()){return;}r.write("<div");r.writeControlData(o);r.addClass("sapMHdrCntrItemCntr");r.addClass("sapMHrdrCntrInner");r.writeAttribute("aria-setsize",o.getSetSize());r.writeAttribute("aria-posinset",o.getPosition());r.writeAttribute("role","listitem");if(o.getAriaLabelledBy()){r.writeAttributeEscaped("aria-labelledby",o.getAriaLabelledBy());}r.writeClasses();r.write(">");r.renderControl(i);r.write("</div>");}
});
var g=a.extend("sap.m.HeaderContainer",{metadata:{interfaces:["sap.m.ObjectHeaderContainer"],library:"sap.m",properties:{scrollStep:{type:"int",defaultValue:300,group:"Behavior"},scrollStepByItem:{type:"int",defaultValue:1,group:"Behavior"},scrollTime:{type:"int",defaultValue:500,group:"Behavior"},showOverflowItem:{type:"boolean",defaultValue:true,group:"Behavior"},showDividers:{type:"boolean",defaultValue:true,group:"Appearance"},orientation:{type:"sap.ui.core.Orientation",defaultValue:O.Horizontal,group:"Appearance"},backgroundDesign:{type:"sap.m.BackgroundDesign",defaultValue:l.BackgroundDesign.Transparent,group:"Appearance"},width:{type:"sap.ui.core.CSSSize",group:"Appearance"},height:{type:"sap.ui.core.CSSSize",group:"Appearance"}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true},_scrollContainer:{type:"sap.m.ScrollContainer",multiple:false,visibility:"hidden"},_prevButton:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_nextButton:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{scroll:{}}}});
g.prototype.init=function(){this._aItemEnd=[];this._bRtl=sap.ui.getCore().getConfiguration().getRTL();this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._oScrollCntr=new S(this.getId()+"-scrl-cntnr",{width:"100%",height:"100%",horizontal:!D.system.desktop});this.setAggregation("_scrollContainer",this._oScrollCntr,true);if(D.system.desktop){this._oArrowPrev=new B({id:this.getId()+"-scrl-prev-button",type:l.ButtonType.Transparent,tooltip:this._oRb.getText("HEADERCONTAINER_BUTTON_PREV_SECTION"),press:function(E){E.cancelBubble();this._scroll(this._getScrollValue(false),this.getScrollTime());}.bind(this)}).addStyleClass("sapMHdrCntrBtn").addStyleClass("sapMHdrCntrLeft");this._oArrowPrev._bExcludeFromTabChain=true;this.setAggregation("_prevButton",this._oArrowPrev,true);this._oArrowNext=new B({id:this.getId()+"-scrl-next-button",type:l.ButtonType.Transparent,tooltip:this._oRb.getText("HEADERCONTAINER_BUTTON_NEXT_SECTION"),press:function(E){E.cancelBubble();this._scroll(this._getScrollValue(true),this.getScrollTime());}.bind(this)}).addStyleClass("sapMHdrCntrBtn").addStyleClass("sapMHdrCntrRight");this._oArrowNext._bExcludeFromTabChain=true;this.setAggregation("_nextButton",this._oArrowNext,true);}else if(D.system.phone||D.system.tablet){this._oArrowPrev=new d({id:this.getId()+"-scrl-prev-button"}).addStyleClass("sapMHdrCntrBtn").addStyleClass("sapMHdrCntrLeft");this.setAggregation("_prevButton",this._oArrowPrev,true);this._oArrowNext=new d({id:this.getId()+"-scrl-next-button"}).addStyleClass("sapMHdrCntrBtn").addStyleClass("sapMHdrCntrRight");this.setAggregation("_nextButton",this._oArrowNext,true);}this._oScrollCntr.addDelegate({onAfterRendering:function(){if(D.system.desktop){var F=this._oScrollCntr.getDomRef("scroll");var o=this._oScrollCntr.$("scroll");var h=o.find(".sapMHrdrCntrInner").attr("tabindex","0");if(!this._oItemNavigation){this._oItemNavigation=new H();this.addDelegate(this._oItemNavigation);this._oItemNavigation.attachEvent(I.Events.BorderReached,this._handleBorderReached,this);this._oItemNavigation.attachEvent(I.Events.AfterFocus,this._handleAfterFocus,this);this._oItemNavigation.attachEvent(I.Events.BeforeFocus,this._handleBeforeFocus,this);if(D.browser.msie||D.browser.edge){this._oItemNavigation.attachEvent(I.Events.FocusAgain,this._handleFocusAgain,this);}}this._oItemNavigation.setRootDomRef(F);this._oItemNavigation.setItemDomRefs(h);this._oItemNavigation.setTabIndex0();this._oItemNavigation.setCycling(false);this._handleMobileScrolling();}}.bind(this)});b.addListener(this._checkOverflow,this);};
g.prototype.onBeforeRendering=function(){if(!this.getHeight()){L.warning("No height provided",this);}if(!this.getWidth()){L.warning("No width provided",this);}if(D.system.desktop){this._oArrowPrev.setIcon(this.getOrientation()===O.Horizontal?"sap-icon://slim-arrow-left":"sap-icon://slim-arrow-up");this._oArrowNext.setIcon(this.getOrientation()===O.Horizontal?"sap-icon://slim-arrow-right":"sap-icon://slim-arrow-down");}else if(D.system.phone||D.system.tablet){this._oArrowPrev.setSrc(this.getOrientation()===O.Horizontal?"sap-icon://slim-arrow-left":"sap-icon://slim-arrow-up");this._oArrowNext.setSrc(this.getOrientation()===O.Horizontal?"sap-icon://slim-arrow-right":"sap-icon://slim-arrow-down");}};
g.prototype.onAfterRendering=function(){this._bRtl=sap.ui.getCore().getConfiguration().getRTL();this._checkOverflow();};
g.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();this._oItemNavigation=null;}b.removeListener(this._checkOverflow,this);};
g.prototype.onsaptabnext=function(E){var F=this.$().find(":focusable");var t=F.index(E.target);var n=F.eq(t+1).get(0);var o=this._getParentCell(E.target);var T;if(n){T=this._getParentCell(n);}if((o&&T&&o.id!==T.id)||(n&&n.id===this.getId()+"-after")||(n&&n.id===this.getId()+"-scrl-prev-button")||(n&&n.id===this.getId()+"-scrl-next-button")){var h=F.last().get(0);if(h){this._bIgnoreFocusIn=true;h.focus();}}};
g.prototype.onsaptabprevious=function(E){this.$().find(".sapMHdrCntrItemCntr").css("border-color","");var F=this.$().find(":focusable");var t=F.index(E.target);var p=F.eq(t-1).get(0);var o=this._getParentCell(E.target);var T;if(p){T=this._getParentCell(p);}if(!T||o&&o.id!==T.id){var s=this.$().attr("tabindex");this.$().attr("tabindex","0");this.$().trigger("focus");if(!s){this.$().removeAttr("tabindex");}else{this.$().attr("tabindex",s);}}};
g.prototype.setOrientation=function(v){this.setProperty("orientation",v);if(v===O.Horizontal&&!D.system.desktop){this._oScrollCntr.setHorizontal(true);this._oScrollCntr.setVertical(false);}else if(!D.system.desktop){this._oScrollCntr.setHorizontal(false);this._oScrollCntr.setVertical(true);}return this;};
g.prototype.validateAggregation=function(A,o,m){return this._callMethodInManagedObject("validateAggregation",A,o,m);};
g.prototype.getAggregation=function(A,o,s){return this._callMethodInManagedObject("getAggregation",A,o,s);};
g.prototype.setAggregation=function(A,o,s){return this._callMethodInManagedObject("setAggregation",A,o,s);};
g.prototype.indexOfAggregation=function(A,o){return this._callMethodInManagedObject("indexOfAggregation",A,o);};
g.prototype.insertAggregation=function(A,o,i,s){return this._callMethodInManagedObject("insertAggregation",A,o,i,s);};
g.prototype.addAggregation=function(A,o,s){return this._callMethodInManagedObject("addAggregation",A,o,s);};
g.prototype.removeAggregation=function(A,o,s){return this._callMethodInManagedObject("removeAggregation",A,o,s);};
g.prototype.removeAllAggregation=function(A,s){return this._callMethodInManagedObject("removeAllAggregation",A,s);};
g.prototype.destroyAggregation=function(A,s){return this._callMethodInManagedObject("destroyAggregation",A,s);};
g.prototype._setScrollInProcess=function(v){this.bScrollInProcess=v;};
g.prototype._scroll=function(i,h){this._setScrollInProcess(true);this.fireScroll();setTimeout(this._setScrollInProcess.bind(this,false),h+300);if(this.getOrientation()===O.Horizontal){this._hScroll(i,h);}else{this._vScroll(i,h);}};
g.prototype._vScroll=function(h,i){var o=this._oScrollCntr.getDomRef(),s=o.scrollTop,j=o.scrollHeight,k=s+h,m=o.clientHeight,p=parseFloat(this.$("scroll-area").css("padding-top")),r;if(k<=0){r=this._calculateRemainingScrolling(h,i,s);this.$("scroll-area").css("transition","padding "+r+"s");this.$().removeClass("sapMHrdrTopPadding");}else if(k+m+p>=j){r=this._calculateRemainingScrolling(h,i,j-m-s);this.$("scroll-area").css("transition","padding "+r+"s");if(m+h>j&&m!==j){this.$().removeClass("sapMHrdrBottomPadding");this.$().addClass("sapMHrdrTopPadding");}else{this.$().removeClass("sapMHrdrBottomPadding");}}else{this.$("scroll-area").css("transition","padding "+i/1000+"s");}this._oScrollCntr.scrollTo(0,k,i);};
g.prototype._hScroll=function(h,i){var o=this._oScrollCntr.getDomRef();var s,j,k,m,p,r;if(!this._bRtl){j=o.scrollLeft;m=o.scrollWidth;k=o.clientWidth+(D.browser.msie?1:0);s=j+h;p=parseFloat(this.$("scroll-area").css("padding-left"));if(s<=0){r=this._calculateRemainingScrolling(h,i,j);this.$("scroll-area").css("transition","padding "+r+"s");this.$().removeClass("sapMHrdrLeftPadding");}else if(s+o.clientWidth+p>=m){r=this._calculateRemainingScrolling(h,i,m-k-j);this.$("scroll-area").css("transition","padding "+r+"s");if(k+h>m&&k!==m){this.$().removeClass("sapMHrdrRightPadding");this.$().addClass("sapMHrdrLeftPadding");}else{this.$().removeClass("sapMHrdrRightPadding");}}else{this.$("scroll-area").css("transition","padding "+i/1000+"s");}this._oScrollCntr.scrollTo(s,0,i);}else{s=q(o).scrollRightRTL()+h;this._oScrollCntr.scrollTo((s>0)?s:0,0,i);}};
g.prototype._collectItemSize=function(){var s=0,h=this._filterVisibleItems(),F=this.getOrientation()===O.Horizontal?"outerWidth":"outerHeight";this._aItemEnd=[];h.forEach(function(o,i){s+=o.$().parent()[F](true);this._aItemEnd[i]=s;},this);};
g.prototype._getScrollValue=function(F){if(!this._oScrollCntr){return 0;}var h=this.getOrientation()===O.Horizontal,$=this._oScrollCntr.$(),j=this.$("prev-button-container"),m=this.$("next-button-container"),s=h?$[0].scrollLeft:$[0].scrollTop,t=0,n=0,o,p=this._filterVisibleItems();var G=function(k){var n=0,u=0;var v=10;if(this._bRtl&&h){if(!j.is(":visible")){u=j.width();}if(!m.is(":visible")){u=m.width();}}for(var i=0;i<p.length&&i<k;i++){n+=r(p[i]);}return n!==0?n+v-u:0;}.bind(this);var r=function(k){return h?k.$().parent().outerWidth(true):k.$().parent().outerHeight(true);};var E=function(){var n=this._getSize(true),u,A=0;for(var i=t;i<p.length;i++){if(!p[i].$().is(":visible")){u=r(p[i])+G(i)-n-s;for(var k=t;k<p.length&&k<i;k++){if(o+A>u){break;}t++;A+=r(p[k]);}o+=A;break;}}}.bind(this);if(this.getScrollStepByItem()>0){s=h&&this._bRtl?$.scrollRightRTL():s;for(var i=0;i<p.length;i++){n+=r(p[i]);if(n>=s){t=i;break;}}t=(F?1:-1)*this.getScrollStepByItem()+t;if(t<0){t=0;}if(t>=p.length){t=p.length-1;}o=G(t)-s;if(F&&!this.getShowOverflowItem()){E();}return o;}return F?this.getScrollStep():-this.getScrollStep();};
g.prototype._calculateRemainingScrolling=function(h,i,j){return Math.abs(j*i/(1000*h));};
g.prototype._checkOverflow=function(){if(this.getOrientation()===O.Horizontal){this._checkHOverflow();}else{this._checkVOverflow();}};
g.prototype._filterVisibleItems=function(){return this.getContent().filter(function(i){return i.getVisible();});};
g.prototype._getFirstItemOffset=function(t){var F=this._filterVisibleItems()[0],$=F&&F.$(),h=$&&$.parent(),i=h&&h[0]&&h[0][t];return i||0;};
g.prototype._checkVOverflow=function(){var o=this._oScrollCntr.getDomRef(),h,$;if(o){var F=this._getFirstItemOffset("offsetTop");var s=Math.ceil(o.scrollTop);var i=false;var j=false;var r=o.scrollHeight;var k=o.offsetHeight;if(Math.abs(r-k)===1){r=k;}if(s>F){i=true;}if((r>k)&&(s+k<r)){j=true;}j=this._checkForOverflowItem(j);$=this.$("prev-button-container");h=$.is(":visible");if(h&&!i){$.hide();this.$().removeClass("sapMHrdrTopPadding");}if(!h&&i){$.show();this.$().addClass("sapMHrdrTopPadding");}$=this.$("next-button-container");var m=$.is(":visible");if(m&&!j){$.hide();this.$().removeClass("sapMHrdrBottomPadding");}if(!m&&j){$.show();this.$().addClass("sapMHrdrBottomPadding");}}};
g.prototype._handleMobileScrolling=function(){if(C.isMobile()){var $=this.$("scrl-cntnr-scroll"),i=this.getOrientation()===O.Horizontal,p=i?"clientX":"clientY",h=0,t=this,s=false;$.on("touchstart",function(E){s=true;h=E.targetTouches[0][p];});$.on("touchmove",function(E){if(s){var j=E.targetTouches[0][p],k=h-j,o=t._oScrollCntr.getDomRef();i?o.scrollLeft+=k:o.scrollTop+=k;h=j;E.preventDefault();}});$.on("touchend",function(){s=false;});}};
g.prototype._checkHOverflow=function(){var o=this._oScrollCntr.getDomRef(),$;if(o){var F=this._getFirstItemOffset("offsetLeft");var s=Math.ceil(o.scrollLeft);var h=false;var i=false;var r=o.scrollWidth;var j=o.offsetWidth;if(Math.abs(r-j)===1){r=j;}if(this._bRtl){var k=q(o).scrollLeftRTL();if(k>((D.browser.msie||D.browser.edge)?1:0)){i=true;}}else if(s>F){h=true;}if(r-5>j){if(this._bRtl){if(q(o).scrollRightRTL()>1){h=true;}}else if(s+j<r){i=true;}}$=this.$("prev-button-container");i=this._checkForOverflowItem(i);var m=$.is(":visible");if(m&&!h){$.hide();this.$().removeClass("sapMHrdrLeftPadding");}if(!m&&h){$.show();this.$().addClass("sapMHrdrLeftPadding");}$=this.$("next-button-container");var n=$.is(":visible");if(n&&!i){$.hide();this.$().removeClass("sapMHrdrRightPadding");}if(!n&&i){$.show();this.$().addClass("sapMHrdrRightPadding");}}};
g.prototype._getSize=function(A){var $=this._oScrollCntr.$(),h=this.getOrientation()===O.Horizontal,i=this.$("next-button-container"),j=!i.is(":visible")&&A,F=h?"width":"height";return $[F]()-(j?i[F]():0);};
g.prototype._checkForOverflowItem=function(s){if(this._oScrollCntr&&!this.getShowOverflowItem()){var $=this._oScrollCntr.$(),h=this.getOrientation()===O.Horizontal,j=!h?$[0].scrollTop:(this._bRtl?$.scrollRightRTL():$[0].scrollLeft),F=h?"width":"height",k=this._getSize(s),m=this._filterVisibleItems();this._collectItemSize();this._aItemEnd.forEach(function(E,i){var n=m[i].$(),o=n.parent(),v=n.is(":visible");if(s&&E>j+k){if(i===0||this._aItemEnd[i-1]<=j){o.css(F,"auto");n.show();}else if(v){o[F](o[F]());n.hide();s=true;}}else{if(!v){o.css(F,"auto");n.show();}}},this);}return s;};
g.prototype._handleBorderReached=function(E){if(D.browser.msie&&this.bScrollInProcess){return;}var i=E.getParameter("index");if(i===0){this._scroll(this._getScrollValue(false),this.getScrollTime());}else if(i===this._filterVisibleItems().length-1){this._scroll(this._getScrollValue(true),this.getScrollTime());}};
g.prototype._handleAfterFocus=function(E){var s=E.getParameter("event");if((D.browser.msie||D.browser.edge)&&s.type==="mousedown"&&s.srcControl instanceof sap.m.Input){s.srcControl.focus();}if(D.browser.msie&&this.bScrollInProcess){return;}var i=E.getParameter("index");if(i===0){this._scroll(this._getScrollValue(false),this.getScrollTime());}else if(i===this._filterVisibleItems().length-1){this._scroll(this._getScrollValue(true),this.getScrollTime());}};
g.prototype._handleFocusAgain=function(E){var s=E.getParameter("event");if((D.browser.msie||D.browser.edge)&&s.type==="mousedown"&&s.srcControl instanceof sap.m.Input){s.srcControl.focus();}E.getParameter("event").preventDefault();};
g.prototype._handleBeforeFocus=function(E){var o=E.getParameter("event");if(q(o.target).hasClass("sapMHdrCntrItemCntr")||q(o.target).hasClass("sapMScrollContScroll")||P.events.sapprevious.fnCheck(o)||P.events.sapnext.fnCheck(o)){this.$().find(".sapMHdrCntrItemCntr").css("border-color","");}else{this.$().find(".sapMHdrCntrItemCntr").css("border-color","transparent");}};
g.prototype._unWrapHeaderContainerItemContainer=function(w){if(w instanceof f){w=w.getItem();}else if(Array.isArray(w)){for(var i=0;i<w.length;i++){if(w[i]instanceof f){w[i]=w[i].getItem();}}}return w;};
g._AGGREGATION_FUNCTIONS=["validateAggregation","validateAggregation","getAggregation","setAggregation","indexOfAggregation","removeAggregation"];g._AGGREGATION_FUNCTIONS_FOR_INSERT=["insertAggregation","addAggregation"];
g.prototype._callMethodInManagedObject=function(F,A){var h=Array.prototype.slice.call(arguments);if(A==="content"){var o=h[2];h[1]="content";if(o instanceof a){if(((g._AGGREGATION_FUNCTIONS?Array.prototype.indexOf.call(g._AGGREGATION_FUNCTIONS,F):-1))>-1&&o.getParent()instanceof f){h[2]=o.getParent();}else if(((g._AGGREGATION_FUNCTIONS_FOR_INSERT?Array.prototype.indexOf.call(g._AGGREGATION_FUNCTIONS_FOR_INSERT,F):-1))>-1){h[2]=new f({item:o});}}var r=this._oScrollCntr[F].apply(this._oScrollCntr,h.slice(1));if(F!=="removeAllAggregation"){var j=this._oScrollCntr.getContent();var k=this.getAriaLabelledBy();var p=1;var v=j.filter(function(n){return n.getItem().getVisible();}).length;for(var i=0;i<j.length;i++){var m=j[i];if(m.getItem().getVisible()){m.setPosition(p);m.setSetSize(v);m.setAriaLabelledBy(k[i]);p++;}}}return this._unWrapHeaderContainerItemContainer(r);}else{return M.prototype[F].apply(this,h.slice(1));}};
g.prototype._getParentCell=function(o){return q(o).parents(".sapMHrdrCntrInner").andSelf(".sapMHrdrCntrInner").get(0);};
g.prototype.onfocusin=function(E){if(this._bIgnoreFocusIn){this._bIgnoreFocusIn=false;return;}if(E.target.id===this.getId()+"-after"){this._restoreLastFocused();}};
g.prototype._restoreLastFocused=function(){if(!this._oItemNavigation){return;}var n=this._oItemNavigation.getItemDomRefs();var i=this._oItemNavigation.getFocusedIndex();var $=q(n[i]);var r=$.control(0)||{};var t=r.getTabbables?r.getTabbables():$.find(":sapTabbable");t.eq(-1).add($).eq(-1).trigger("focus");};
return g;});
sap.ui.predefine('sap/m/HeaderContainerItemNavigator',["sap/ui/core/delegate/ItemNavigation","sap/base/assert","sap/ui/dom/containsOrEquals","sap/ui/events/KeyCodes"],function(I,a,c,K){"use strict";
var H=I.extend("sap.m.HeaderContainerItemNavigator");
H.prototype.focusItem=function(i,e){if(e.type==="mousedown"){var f=this.aItemDomRefs[i].focus;this.aItemDomRefs[i].focus=function(){};this._callParent("focusItem",arguments);this.aItemDomRefs[i].focus=f;return;}this._callParent("focusItem",arguments);};
H.prototype._callParent=function(f,A){if(typeof I.prototype[f]==="function"){I.prototype[f].apply(this,A);}};
H.prototype.onsaphome=function(e){if(this._skipNavigation(e)){return;}this._callParent("onsaphome",arguments);};
H.prototype.onsapend=function(e){if(this._skipNavigation(e)){return;}this._callParent("onsapend",arguments);};
H.prototype.onsapnext=function(e){if(this._skipNavigation(e)){return;}this._callParent("onsapnext",arguments);};
H.prototype.onsapprevious=function(e){if(this._skipNavigation(e,true,false)){return;}this._callParent("onsapprevious",arguments);};
H.prototype._skipNavigation=function(e){return Array.prototype.indexOf.call(this.aItemDomRefs,e.target)===-1;};
return H;});
sap.ui.predefine('sap/m/HeaderContainerRenderer',['sap/ui/core/library',"sap/base/security/encodeCSS"],function(c,e){"use strict";var O=c.Orientation;var H={};
H.render=function(r,C){var t=C.getTooltip_AsString();var o=C.getOrientation();if(o){o=e(o);}var b=e("sapMHdrCntrBG"+C.getBackgroundDesign());r.write("<div");r.writeControlData(C);if(t&&(typeof t==="string")){r.writeAttributeEscaped("title",t);}r.addClass("sapMHdrCntr");r.addClass(o);if(C.getShowDividers()){r.addClass("sapMHrdrCntrDvdrs");}r.writeClasses();if(C.getHeight()){r.addStyle("height",C.getHeight());}else{r.addStyle("height",(C.getOrientation()===O.Horizontal)?"auto":"100%");}if(C.getWidth()){r.addStyle("width",C.getWidth());}else{r.addStyle("width",(C.getOrientation()===O.Horizontal)?"100%":"auto");}r.writeStyles();var d="";var a=C.getContent();for(var i=0;a&&i<a.length;i++){d+=a[i].getId()+" ";}r.writeAttribute("role","list");r.write(">");r.write("<div");r.writeAttributeEscaped("id",C.getId()+"-scroll-area");r.addClass("sapMHdrCntrCntr");r.addClass(o);r.addClass(b);r.writeClasses();r.write(">");r.renderControl(C.getAggregation("_scrollContainer"));r.write("</div>");var B=C.getAggregation("_prevButton");if(B){r.write("<div");r.writeAttributeEscaped("id",C.getId()+"-prev-button-container");r.addClass("sapMHdrCntrBtnCntr");r.addClass("sapMHdrCntrLeft");r.addClass(o);r.writeClasses();r.write(">");r.renderControl(B);r.write("</div>");}B=C.getAggregation("_nextButton");if(B){r.write("<div");r.writeAttributeEscaped("id",C.getId()+"-next-button-container");r.addClass("sapMHdrCntrBtnCntr");r.addClass("sapMHdrCntrRight");r.addClass(o);r.writeClasses();r.write(">");r.renderControl(B);r.write("</div>");}r.write("<div");r.writeAttribute("id",C.getId()+"-after");r.writeAttribute("tabindex","0");r.write("></div>");r.write("</div>");};
return H;},true);
sap.ui.predefine('sap/m/HyphenationSupport',["sap/ui/core/Core","./library","sap/ui/core/hyphenation/Hyphenation","sap/base/Log"],function(C,l,H,L){"use strict";var W=l.WrappingType;
function i(o){if(!o.isA("sap.m.IHyphenation")){L.error("[UI5 Hyphenation] The given control does not implement interface sap.m.IHyphenation and can not use HyphenationSupport mixin.");return false;}return true;}
function a(o,k){var t=o.getTextsToBeHyphenated();if(typeof t!=="object"){L.error("[UI5 Hyphenation] The result of getTextsToBeHyphenated method is not a map object.",o.getId());return false;}if(Object.keys(t).indexOf(k)<0){L.error("[UI5 Hyphenation] The key "+k+" is not found in the result of getTextsToBeHyphenated method.",o.getId());return false;}return true;}
function s(D,n){n=n||"";var f=D.childNodes;if(f.length===1&&f[0].nodeType===window.Node.TEXT_NODE){f[0].nodeValue=n;}else{D.textContent=n;}}
function d(t,T){var D=[];Object.keys(t).forEach(function(k){if(!(k in T&&t[k]===T[k])){D.push(k);}});return D;}
function b(){var f=C.getConfiguration().getHyphenation(),o=H.getInstance();if(f==="native"||f==="disable"){return false;}if(f==="thirdparty"){return true;}return o.isLanguageSupported()&&!o.canUseNativeHyphenation()&&o.canUseThirdPartyHyphenation();}
function c(o){var f=C.getConfiguration().getHyphenation();if(f==='disable'){return false;}if(o.getWrappingType()===W.Hyphenated&&!o.getWrapping()){L.warning("[UI5 Hyphenation] The property wrappingType=Hyphenated will not take effect unless wrapping=true.",o.getId());}return o.getWrapping()&&o.getWrappingType()===W.Hyphenated;}
function h(o){if(!c(o)||!b()){o._mHyphenatedTexts={};o._mUnhyphenatedTexts={};return;}var t=o.getTextsToBeHyphenated(),f=d(t,o._mUnhyphenatedTexts);if(f.length>0){o._mUnhyphenatedTexts=t;f.forEach(function(k){delete o._mHyphenatedTexts[k];});var g=H.getInstance();if(!g.isLanguageInitialized()){g.initialize().then(function(){var D=o.isActive()?o.getDomRefsForHyphenatedTexts():null,n=false;f.forEach(function(k){o._mHyphenatedTexts[k]=g.hyphenate(t[k]);if(D&&k in D){s(D[k],o._mHyphenatedTexts[k]);}else{n=true;}});if(n){o.invalidate();}});}else{f.forEach(function(k){o._mHyphenatedTexts[k]=g.hyphenate(t[k]);});}}}
var e={};
e.mixInto=function(o){if(!i(o)){return;}var I=o.init;o.init=function(f){var r=I.apply(this,arguments);this._mHyphenatedTexts={};this._mUnhyphenatedTexts={};return r;};var O=o.onBeforeRendering;o.onBeforeRendering=function(){var r=O.apply(this,arguments);h(this);return r;};};
e.writeHyphenationClass=function(r,o){if(!i(o)){return;}if(c(o)&&!b()){r.class("sapUiHyphenation");}};
e.getTextForRender=function(o,k){if(!i(o)){return null;}if(!a(o,k)){return null;}var t=o.getTextsToBeHyphenated();if(c(o)&&b()){if(t[k]!==o._mUnhyphenatedTexts[k]){h(o);}if(k in o._mHyphenatedTexts){return o._mHyphenatedTexts[k];}}return t[k];};
return e;});
sap.ui.predefine('sap/m/IconTabBar',['./library',"sap/ui/core/Core",'sap/ui/core/Control','./IconTabBarRenderer','./IconTabHeader',"sap/ui/core/util/ResponsivePaddingsEnablement","sap/ui/thirdparty/jquery"],function(l,C,a,I,b,R,q){"use strict";var c=l.IconTabHeaderMode;var B=l.BackgroundDesign;var d=l.IconTabDensityMode;
var e=a.extend("sap.m.IconTabBar",{metadata:{interfaces:["sap.m.ObjectHeaderContainer","sap.f.IDynamicPageStickyContent"],library:"sap.m",properties:{showSelection:{type:"boolean",group:"Misc",defaultValue:true,deprecated:true},expandable:{type:"boolean",group:"Misc",defaultValue:true},expanded:{type:"boolean",group:"Misc",defaultValue:true},selectedKey:{type:"string",group:"Data",defaultValue:null},upperCase:{type:"boolean",group:"Appearance",defaultValue:false},stretchContentHeight:{type:"boolean",group:"Appearance",defaultValue:false},applyContentPadding:{type:"boolean",group:"Appearance",defaultValue:true},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:B.Solid},headerMode:{type:"sap.m.IconTabHeaderMode",group:"Appearance",defaultValue:c.Standard},showOverflowSelectList:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},headerBackgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:B.Solid},enableTabReordering:{type:"boolean",group:"Behavior",defaultValue:false},maxNestingLevel:{type:"int",group:"Behavior",defaultValue:0},tabDensityMode:{type:"sap.m.IconTabDensityMode",group:"Appearance",defaultValue:d.Cozy},ariaTexts:{type:"object",group:"Accessibility",defaultValue:null}},aggregations:{items:{type:"sap.m.IconTab",multiple:true,singularName:"item",forwarding:{getter:"_getIconTabHeader",aggregation:"items",forwardBinding:true}},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},_header:{type:"sap.m.IconTabHeader",multiple:false,visibility:"hidden"}},events:{select:{parameters:{item:{type:"sap.m.IconTabFilter"},key:{type:"string"},selectedItem:{type:"sap.m.IconTabFilter"},selectedKey:{type:"string"}}},expand:{parameters:{expand:{type:"boolean"},collapse:{type:"boolean"}}}},designtime:"sap/m/designtime/IconTabBar.designtime"}});
R.call(e.prototype,{header:{selector:".sapMITH"},content:{suffix:"content"}});e._CLASSES_TO_COPY=["sapUiResponsiveContentPadding","sapUiNoContentPadding","sapUiContentPadding"];
e.prototype.init=function(){this._initResponsivePaddingsEnablement();};
e.prototype.setExpanded=function(E){this.setProperty("expanded",E,true);if(this.$().length){this._toggleExpandCollapse(E);}return this;};
e.prototype.setHeaderMode=function(m){this.setProperty("headerMode",m,true);this._getIconTabHeader().setMode(m);return this;};
e.prototype.setTabDensityMode=function(m){this.setProperty("tabDensityMode",m);this._getIconTabHeader().setTabDensityMode(m);return this;};
e.prototype.setHeaderBackgroundDesign=function(h){this.setProperty("headerBackgroundDesign",h,true);this._getIconTabHeader().setBackgroundDesign(h);return this;};
e.prototype.setEnableTabReordering=function(v){this.setProperty("enableTabReordering",v,true);this._getIconTabHeader().setEnableTabReordering(v);return this;};
e.prototype.setAriaTexts=function(A){this.setProperty("ariaTexts",A,true);this._getIconTabHeader().setAriaTexts(A);return this;};
e.prototype.addStyleClass=function(s,S){var i=this._getIconTabHeader();if(e._CLASSES_TO_COPY.indexOf(s)!==-1){i.addStyleClass(s,true);}return a.prototype.addStyleClass.apply(this,arguments);};
e.prototype.removeStyleClass=function(s,S){var i=this._getIconTabHeader();if(e._CLASSES_TO_COPY.indexOf(s)!==-1){i.removeStyleClass(s,true);}return a.prototype.removeStyleClass.apply(this,arguments);};
e.prototype._rerenderContent=function(o){var $=this.$("content");if(o&&($.length>0)){var r=C.createRenderManager();for(var i=0;i<o.length;i++){r.renderControl(o[i]);}r.flush($[0]);r.destroy();}};
e.prototype._toggleExpandCollapse=function(E){var $=this.$("content");var s=this._getIconTabHeader().oSelectedItem;if(E===undefined){E=!this.getExpanded();}if(s){s.$().toggleClass("sapMITBSelected",E);s.$().attr({'aria-expanded':E});if(E){s.$().attr({'aria-selected':E});}else{s.$().removeAttr('aria-selected');}}this._iAnimationCounter=(this._iAnimationCounter===undefined?1:++this._iAnimationCounter);if(E){if(s){if(this.$("content").children().length===0){var S=s.getContent();if(S.length>0){this._rerenderContent(S);}else{this._rerenderContent(this.getContent());}}$.stop(true,true).slideDown('400',q.proxy(this.onTransitionEnded,this,E));this.$("containerContent").toggleClass("sapMITBContentClosed",!E);}}else{this.$("contentArrow").hide();$.stop(true,true).slideUp('400',q.proxy(this.onTransitionEnded,this,E));}if(!E||s){this.setProperty("expanded",E,true);}this.fireExpand({expand:E,collapse:!E});return this;};
e.prototype.onTransitionEnded=function(E){var $=this.$("content"),f=this.$("containerContent"),g=this.$("contentArrow");if(this._iAnimationCounter===1){f.toggleClass("sapMITBContentClosed",!E);if(E){g.show();$.css("display","block");}else{g.hide();$.css("display","none");}}this._iAnimationCounter=(this._iAnimationCounter>0?--this._iAnimationCounter:0);return this;};
e.prototype._getIconTabHeader=function(){var o=this.getAggregation("_header");if(!o){o=new b(this.getId()+"--header",{});this.setAggregation("_header",o,true);}return o;};
e.prototype._getStickyContent=function(){return this._getIconTabHeader();};
e.prototype._returnStickyContent=function(){if(this.bIsDestroyed){return;}this._getStickyContent().$().prependTo(this.$());};
e.prototype._setStickySubheaderSticked=function(i){this._bStickyContentSticked=i;};
e.prototype._getStickySubheaderSticked=function(){return this._bStickyContentSticked;};
e.prototype.onBeforeRendering=function(){var i=this._getIconTabHeader(),$=i.$();i.setMaxNestingLevel(this.getMaxNestingLevel());if(this._bStickyContentSticked&&$){delete this._bStickyContentSticked;this._getIconTabHeader().$().remove();}};
e.prototype.setShowSelection=function(v){this._getIconTabHeader().setShowSelection(v);return this;};
e.prototype.getShowSelection=function(){return this._getIconTabHeader().getShowSelection();};
e.prototype.setSelectedKey=function(v){this._getIconTabHeader().setSelectedKey(v);return this;};
e.prototype.getSelectedKey=function(){return this._getIconTabHeader().getSelectedKey();};
e.prototype.setSelectedItem=function(i,A){return this._getIconTabHeader().setSelectedItem(i,A);};
return e;});
sap.ui.predefine('sap/m/IconTabBarDragAndDropUtil',['sap/ui/core/dnd/DragInfo','sap/ui/core/dnd/DropInfo',"sap/ui/events/KeyCodes",'sap/ui/core/library'],function(D,a,K,c){"use strict";var b=c.dnd.DropPosition;var I="Before",d="insertBefore",e="insertAfter",i,f="IconTabReorder",g="Forward",h="Backward";var j={_insertControl:function(i,o,k,l){var $=o.$(),m=k.$(),n=[],p=[];if(o._getNestedLevel()>1&&k._getNestedLevel()>1){n=o._getRootTab()._getSelectList().getItems().filter(function(q){return o._getRealTab()._isParentOf(q._getRealTab());});p=k._getRootTab()._getSelectList().getItems().filter(function(q){return k._getRealTab()._isParentOf(q._getRealTab());});}if(l){var O=o._getRootTab().getParent()._getOverflow()._getSelectList().getItems();n=O.filter(function(q){return o._getRealTab()._isParentOf(q._getRealTab());});p=O.filter(function(q){return k._getRealTab()._isParentOf(q._getRealTab());});}if(i===e){$.insertAfter(m);}else{$.insertBefore(m);}n.reverse().forEach(function(C){C.$().insertAfter($);});p.reverse().forEach(function(C){C.$().insertAfter(m);});},handleDrop:function(C,s,o,k,l,m){var B=C.indexOfItem(o),n=C.indexOfItem(k),A=0,r=sap.ui.getCore().getConfiguration().getRTL(),p=s===I,q=k._getNestedLevel()-1;if(o._isParentOf(k)){return;}if(q===m&&s===b.On){return;}if(r&&!l){if(p){A=B<n?n:n+1;i=e;}else{A=B<n?n-1:n;i=d;}}else{if(p){A=B<n?n-1:n;i=d;}else{A=B<n?n:n+1;i=e;}}if(C.isA("sap.m.IconTabFilter")||!o.getParent().isA("sap.m.IconTabHeader")){if(p){A=n;}else{A=n+1;}}j._insertControl(i,o,k);if(s===b.On){if(k===o){return;}A=C.getAggregation("items").length;}j._handleConfigurationAfterDragAndDrop.call(C,o,A);},_updateAccessibilityInfo:function(){var o=this.getItems(),A=1,k;o.forEach(function(l){k=l.getDomRef();if(k&&k.getAttribute("aria-posinset")!==null){k.setAttribute("aria-posinset",A++);}});},_handleConfigurationAfterDragAndDrop:function(o,k){var l=[],m=this.isA("sap.m.IconTabHeader")?this:this._getIconTabHeader();if(this.isA("sap.m.IconTabBarSelectList")){l=this.getItems().filter(function(p){return o._getRealTab()._isParentOf(p._getRealTab());});}m._setPreserveSelection(true);this.removeAggregation('items',o,true);this.insertAggregation('items',o,k,true);l.forEach(function(p){this.removeAggregation('items',p,true);}.bind(this));var n=1+this.indexOfAggregation('items',o);l.reverse().forEach(function(p){this.insertAggregation('items',p,n,true);}.bind(this));m._setPreserveSelection(false);j._updateAccessibilityInfo.call(this);},_decreaseDropIndex:function(B,k){var p=B-1;while(p>=0&&(k[B]._getRealTab()._getNestedLevel()!==k[p]._getRealTab()._getNestedLevel()||!k[p].getVisible()||(!k[B].$().hasClass("sapMITBFilterHidden")&&k[p].$().hasClass("sapMITBFilterHidden")))){p--;}if(p<0){i=e;return B;}i=d;return p;},_increaseDropIndex:function(B,k,m){var n=B+1;while(n<k.length&&(k[B]._getRealTab()._getNestedLevel()!==k[n]._getRealTab()._getNestedLevel()||!k[n].getVisible())){n++;}if(n>m){i=d;return B;}i=e;return n;},moveItem:function(o,k,m){var l=this.getItems(),B=this.indexOfItem(o),r=sap.ui.getCore().getConfiguration().getRTL(),n,p;if(this.isA("sap.m.IconTabFilter")){l=this._getRealTab().getItems();}switch(k){case K.HOME:n=0;i=d;break;case K.END:n=l.length-1;i=e;break;case K.ARROW_LEFT:if(r){p=j.preventDragBetweenSubItems(o,g,this);n=j._increaseDropIndex(B,l,m);}else{p=j.preventDragBetweenSubItems(o,h,this);n=j._decreaseDropIndex(B,l);}break;case K.ARROW_RIGHT:if(r){p=j.preventDragBetweenSubItems(o,h,this);n=j._decreaseDropIndex(B,l);}else{p=j.preventDragBetweenSubItems(o,g,this);n=j._increaseDropIndex(B,l,m);}break;case K.ARROW_DOWN:p=j.preventDragBetweenSubItems(o,g,this);n=j._increaseDropIndex(B,l,m);break;case K.ARROW_UP:p=j.preventDragBetweenSubItems(o,h,this);n=j._decreaseDropIndex(B,l);break;default:return false;}if(p){return false;}if(!this.isA("sap.m.IconTabFilter")){var q=l[n];j._insertControl(i,o,q,this._oTabFilter&&this._oTabFilter._bIsOverflow);}j._handleConfigurationAfterDragAndDrop.call(this,o,n);return true;},setDragDropAggregations:function(k,s,o){var l=k._oIconTabHeader?k._oIconTabHeader:k;var m=l.getId();k.addDragDropConfig(new D({sourceAggregation:"items",groupName:f+m}));k.addDragDropConfig(new a({targetAggregation:"items",dropPosition:o,dropLayout:s,drop:k._handleDragAndDrop.bind(k),groupName:f+m}));},preventDragBetweenSubItems:function(o,s,C){var p=false;if(C.isA("sap.m.IconTabBarSelectList")){var r=o._getRealTab(),P=r.getParent(),k=P.getItems();if((k.indexOf(r)===0&&s===h)||(k.indexOf(r)+1===k.length&&s===g)||k.length===1){p=true;}}return p;}};return j;});
sap.ui.predefine('sap/m/IconTabBarRenderer',[],function(){"use strict";var I={apiVersion:2};I._aAllIconColors=['sapMITBFilterCritical','sapMITBFilterPositive','sapMITBFilterNegative','sapMITBFilterDefault'];
I.render=function(r,i){var c=i.getContent(),h=i._getIconTabHeader();r.openStart("div",i).class("sapMITB");if(i.getStretchContentHeight()){r.class("sapMITBStretch");}if(!i.getApplyContentPadding()){r.class("sapMITBNoContentPadding");}r.class("sapMITBBackgroundDesign"+i.getBackgroundDesign()).openEnd();if(!i._bHideHeader){r.renderControl(h);}r.openStart("div",i.getId()+"-containerContent").class("sapMITBContainerContent");if(!i.getExpanded()){r.class("sapMITBContentClosed");}r.openEnd();r.openStart("div",i.getId()+"-content").class("sapMITBContent").attr("role","tabpanel");if(!i.getExpanded()){r.style("display","none");}if(h.oSelectedItem){r.accessibilityState({labelledby:h.oSelectedItem.getId()});}r.openEnd();if(i.getExpanded()){if(h.oSelectedItem&&h.oSelectedItem.getContent()){var C=h.oSelectedItem.getContent();if(C.length>0){c=C;}}c.forEach(function(o){r.renderControl(o);});}r.close("div").close("div").close("div");};
return I;},true);
sap.ui.predefine('sap/m/IconTabBarSelectList',['./library','sap/ui/core/Control',"sap/ui/core/Core",'sap/ui/core/delegate/ItemNavigation','./IconTabBarDragAndDropUtil','sap/ui/core/library','./IconTabBarSelectListRenderer',"sap/ui/thirdparty/jquery"],function(l,C,a,I,b,c,d,q){"use strict";var D=c.dnd.DropPosition;
var e=C.extend("sap.m.IconTabBarSelectList",{metadata:{library:"sap.m",aggregations:{items:{type:"sap.m.IconTab",multiple:true,singularName:"item",dnd:true}},events:{selectionChange:{parameters:{selectedItem:{type:"sap.m.IconTabFilter"}}}}}});
e.prototype.init=function(){this._oItemNavigation=new I();this._oItemNavigation.setCycling(false);this.addEventDelegate(this._oItemNavigation);this._oItemNavigation.setPageSize(10);this._oIconTabHeader=null;this._oTabFilter=null;};
e.prototype.exit=function(){this._oItemNavigation.destroy();this._oItemNavigation=null;this._oIconTabHeader=null;this._oTabFilter=null;};
e.prototype.onBeforeRendering=function(){if(!this._oIconTabHeader){return;}this.destroyDragDropConfig();this._setsDragAndConfiguration();};
e.prototype.onAfterRendering=function(){this._initItemNavigation();this.getItems().forEach(function(i){if(i._onAfterParentRendering){i._onAfterParentRendering();}});};
e.prototype._setsDragAndConfiguration=function(){if(this._oIconTabHeader.getEnableTabReordering()&&!this.getDragDropConfig().length){b.setDragDropAggregations(this,"Vertical",this._oIconTabHeader._getDropPosition());}};
e.prototype._initItemNavigation=function(){var f=this.getItems(),g=[],p=this._oIconTabHeader.oSelectedItem,s=-1,o,i;for(i=0;i<f.length;i++){o=f[i];if(o.isA("sap.m.IconTabFilter")){var h=o._getAllSubFiltersDomRefs();g=g.concat(o.getDomRef(),h);}if(p&&this.getSelectedItem()&&this.getSelectedItem()._getRealTab()===p){s=i;}}if(p&&g.indexOf(p.getDomRef())!==-1){s=g.indexOf(p.getDomRef());}this._oItemNavigation.setRootDomRef(this.getDomRef()).setItemDomRefs(g).setSelectedIndex(s);};
e.prototype.getVisibleItems=function(){return this.getItems().filter(function(i){return i.getVisible();});};
e.prototype.getVisibleTabFilters=function(){return this.getVisibleItems().filter(function(i){return i.isA("sap.m.IconTabFilter");});};
e.prototype.setSelectedItem=function(i){this._selectedItem=i;};
e.prototype.getSelectedItem=function(){return this._selectedItem;};
e.prototype._getIconTabHeader=function(){return this._oIconTabHeader;};
e.prototype.ontap=function(E){var t=E.srcControl;if(!t){return;}if(!t.isA("sap.m.IconTabFilter")){return;}if(this._oIconTabHeader._isUnselectable(t)){return;}E.preventDefault();if(t!=this.getSelectedItem()){this.fireSelectionChange({selectedItem:t});}};
e.prototype.onsapenter=e.prototype.ontap;e.prototype.onsapspace=e.prototype.ontap;
e.prototype.checkIconOnly=function(){this._bIconOnly=this.getVisibleTabFilters().every(function(i){return!i.getText()&&!i.getCount();});return this._bIconOnly;};
e.prototype._handleDragAndDrop=function(E){var s=E.getParameter("dropPosition"),o=E.getParameter("draggedControl"),f=E.getParameter("droppedControl"),g=f._getRealTab().getParent(),h=this._oIconTabHeader.getMaxNestingLevel();if(this._oTabFilter._bIsOverflow){g=this._oIconTabHeader;}if(s===D.On){g=f._getRealTab();}b.handleDrop(g,s,o._getRealTab(),f._getRealTab(),true,h);this._oIconTabHeader._setItemsForStrip();this._oIconTabHeader._initItemNavigation();this._oTabFilter._setSelectListItems();this._initItemNavigation();f._getRealTab().getParent().$().trigger("focus");};
e.prototype.ondragrearranging=function(E){if(!this._oIconTabHeader.getEnableTabReordering()){return;}var t=E.srcControl,k=E.keyCode,i=this.indexOfItem(t),o=this;b.moveItem.call(o,t,k,o.getItems().length-1);this._initItemNavigation();t.$().trigger("focus");if(i===this.indexOfItem(t)){return;}o=t._getRealTab().getParent();if(this._oTabFilter._bIsOverflow&&t._getRealTab()._getNestedLevel()===1){this._oIconTabHeader._moveTab(t._getRealTab(),k,this._oIconTabHeader.getItems().length-1);}else{b.moveItem.call(o,t._getRealTab(),k,o.getItems().length-1);}};
e.prototype.onsaphomemodifiers=e.prototype.ondragrearranging;e.prototype.onsapendmodifiers=e.prototype.ondragrearranging;e.prototype.onsapincreasemodifiers=e.prototype.ondragrearranging;e.prototype.onsapdecreasemodifiers=e.prototype.ondragrearranging;return e;});
sap.ui.predefine('sap/m/IconTabBarSelectListRenderer',["sap/ui/core/theming/Parameters","sap/ui/core/library"],function(P,c){"use strict";var I=c.IconColor;var a={apiVersion:2};a.fNestedItemPaddingLeft=Number.parseFloat(P.get("_sap_m_IconTabBar_SelectListItem_PaddingLeft"));
a.render=function(r,s){var i=s.getVisibleItems(),o=s._oIconTabHeader,t=o._checkTextOnly(),T=o.getVisibleTabFilters().length,n=this.fNestedItemPaddingLeft,e=false;var h=i.filter(function(b){return b.isA("sap.m.IconTabFilter");}).some(function(b){return b.getIconColor()!==I.Default;});s.checkIconOnly();var A=Number.parseFloat(P.get("_sap_m_IconTabBar_SelectListItem_PaddingLeftAdditional"));if(h&&A){n+=A;e=true;}this.renderList(r,i,s,o,t,n,e,T);};
a.renderList=function(r,b,s,o,t,p,e,S){if(!b.length){return;}r.openStart("ul",s).attr("role","menu").class("sapMITBSelectList");if(t){r.class("sapMITBSelectListTextOnly");}r.openEnd();for(var i=0;i<b.length;i++){var d=b[i],f;if(o&&d.isA("sap.m.IconTabFilter")){f=o.getVisibleTabFilters().indexOf(d._getRealTab());}if(d.isA("sap.m.IconTabFilter")&&d._getRootTab()._getSelectList()===s){f=i;S=b.length;}var l=d._getNestedLevel()-2;if(e){l++;}if(s._bIsOverflow){l++;}d.renderInSelectList(r,s,f,S,p*l);}r.close("ul");};
return a;},true);
sap.ui.predefine('sap/m/IconTabFilter',["./library","./AccButton","./IconTabFilterExpandButtonBadge","sap/ui/core/library","sap/ui/core/Core","sap/ui/core/Item","sap/ui/core/Renderer","sap/ui/core/IconPool",'sap/ui/core/InvisibleMessage',"sap/ui/core/InvisibleText","sap/ui/core/Control",'sap/ui/Device',"sap/m/BadgeCustomData","sap/m/Button","sap/m/ResponsivePopover","sap/m/IconTabBarSelectList","sap/m/BadgeEnabler"],function(l,A,I,c,C,a,R,b,d,e,f,D,B,g,h,j,k){"use strict";var T=c.TextAlign;var m=c.TextDirection;var n=l.ButtonType;var P=l.PlacementType;var o=l.ImageHelper;var p=l.IconTabFilterDesign;var q=l.BadgeStyle;var r=l.BadgeState;var s=c.IconColor;var t=3000;var u=c.InvisibleMessageMode;
var v=a.extend("sap.m.IconTabFilter",{metadata:{interfaces:["sap.m.IconTab","sap.ui.core.PopupInterface","sap.m.IBadge"],library:"sap.m",designtime:"sap/m/designtime/IconTabFilter.designtime",properties:{count:{type:"string",group:"Data",defaultValue:''},showAll:{type:"boolean",group:"Misc",defaultValue:false},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:''},iconColor:{type:"sap.ui.core.IconColor",group:"Appearance",defaultValue:s.Default},iconDensityAware:{type:"boolean",group:"Appearance",defaultValue:true},visible:{type:"boolean",group:"Behavior",defaultValue:true},design:{type:"sap.m.IconTabFilterDesign",group:"Appearance",defaultValue:p.Vertical}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},items:{type:"sap.m.IconTab",multiple:true,singularName:"item"},_expandButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_expandButtonBadge:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}}}});
k.call(v.prototype);var w=C.getLibraryResourceBundle("sap.m");v._aAllIconColors=['sapMITBFilterCritical','sapMITBFilterPositive','sapMITBFilterNegative','sapMITBFilterDefault','sapMITBFilterNeutral'];
v.prototype._getImageControl=function(i,x,y){var z={src:this.getIcon(),densityAware:this.getIconDensityAware(),useIconTooltip:false};if(z.src){this._oImageControl=o.getImageControl(this.getId()+"-icon",this._oImageControl,x,z,i,y);}else if(this._oImageControl){this._oImageControl.destroy();this._oImageControl=null;}return this._oImageControl;};
v.prototype.init=function(){this._oDragEventDelegate={onlongdragover:this._handleOnLongDragOver,ondragover:this._handleOnDragOver,ondragleave:this._handleOnDragLeave,ondrop:this._handleOnDrop};this.initBadgeEnablement({style:q.Attention,selector:{selector:".sapMITBBadgeHolder"}});this._oCloneInList=null;this.setAggregation("_expandButtonBadge",new I());};
v.prototype.exit=function(E){if(this._oImageControl){this._oImageControl.destroy();}if(a.prototype.exit){a.prototype.exit.call(this,E);}if(this._invisibleText){this._invisibleText.destroy();this._invisibleText=null;}if(this._oPopover){this._oPopover.destroy();this._oPopover=null;}if(this._oExpandButton){this._oExpandButton.removeEventDelegate(this._oDragEventDelegate);this._oExpandButton.destroy();this._oExpandButton=null;}this.removeEventDelegate(this._oDragEventDelegate);this._oDragEventDelegate=null;if(this._iHideBadgeTimeout){clearTimeout(this._iHideBadgeTimeout);}};
v.prototype.invalidate=function(){var i=this.getParent(),x,O;if(!i){return;}x=i.getParent();if(!(x instanceof sap.m.IconTabBar)){i.invalidate();return;}O=x.getParent();if(O instanceof sap.m.ObjectHeader){O.invalidate();}else{x.invalidate();}};
v.prototype.setProperty=function(i,V,S){switch(i){case'enabled':case'textDirection':case'text':case'count':case'showAll':case'icon':case'iconColor':case'iconDensityAware':case'design':if(this.getProperty(i)===V){return this;}f.prototype.setProperty.call(this,i,V,true);if(!S){var x=this.getParent();if(x instanceof sap.m.IconTabHeader){x.invalidate();}}break;default:f.prototype.setProperty.apply(this,arguments);break;}return this;};
v.prototype._getNonEmptyKey=function(){var K=this.getKey();if(K){return K;}return this.getId();};
v.prototype._getRealTab=function(){return this._oRealItem||this;};
v.prototype._getRootTab=function(){var i=this._getRealTab(),x=i.getParent();while(x&&x.isA("sap.m.IconTabFilter")){i=x;x=x.getParent();}return i;};
v.prototype._getNestedLevel=function(){var i=this._getRealTab().getParent(),L;for(L=1;i&&i.isA("sap.m.IconTabFilter");L++){i=i.getParent();}return L;};
v.prototype.render=function(i,V,x){if(!this.getVisible()){return;}this._prepareDragEventDelegate();var y=this.getParent(),z=y.getParent(),H=y._isInsideIconTabBar(),E={role:"tab"},F=this.getId(),G=this.getCount(),J=this.getText(),K=this.getIcon(),L=this.getIconColor(),S=L==='Positive'||L==='Critical'||L==='Negative'||L==='Neutral',M=this.getDesign()===p.Horizontal,N=y._bTextOnly,O=y._bInLine||y.isInlineMode(),Q=this.getShowAll();if(H){E.controls=z.getId()+"-content";}if(this.getItems().length){E.roledescription=w.getText("ICONTABFILTER_SPLIT_TAB");}if(J.length||G!==""||K){var U=[];if(G!==""){U.push(F+"-count");}if(J.length){U.push(F+"-text");}if(K){U.push(F+"-icon");}if(S){U.push(F+"-iconColor");}E.labelledby=U.join(" ");}if(V!==undefined&&x!==undefined){Object.assign(E,{posinset:V+1,setsize:x});}i.openStart("div",this).accessibilityState(E).class("sapMITBItem");if(!G){i.class("sapMITBItemNoCount");}if(M){i.class("sapMITBHorizontal");}else{i.class("sapMITBVertical");}if(Q){i.class("sapMITBAll");}else{i.class("sapMITBFilter").class("sapMITBFilter"+L);}if(y._isUnselectable(this)){i.class("sapMITHUnselectable");}if(this.getItems().length>0){i.class("sapMITBFilterWithItems");}if(!this.getEnabled()){i.class("sapMITBDisabled").attr("aria-disabled",true);}i.attr("aria-selected",false);var W=this.getTooltip_AsString();if(W){i.attr("title",W);}if(this._bIsOverflow||this.getItems().length){i.attr("aria-haspopup","menu");}i.openEnd();i.openStart("div").class("sapMITBFilterWrapper").openEnd();if(!O){i.openStart("div",F+"-tab").class("sapMITBTab").openEnd();if(!Q||!K){if(S){i.openStart("div",F+"-iconColor").style("display","none").openEnd().text(w.getText('ICONTABBAR_ICONCOLOR_'+L.toUpperCase())).close("div");}i.renderControl(this._getImageControl(['sapMITBFilterIcon',"sapMITBBadgeHolder",'sapMITBFilter'+L],y,v._aAllIconColors));}if(!Q&&!K&&!N){i.openStart("span").class("sapMITBFilterNoIcon").openEnd().close("span");}if(M&&!Q){i.close("div");i.openStart("div").class("sapMITBHorizontalWrapper").openEnd();}i.openStart("span",F+"-count").class("sapMITBCount");if(Q||(!K&&!J.length)){i.class("sapMITBBadgeHolder");}i.openEnd();if(G===""&&M){i.unsafeHtml("&nbsp;");}else{i.text(G);}i.close("span");if(!M){i.close("div");}}if(J.length){i.openStart("div",F+"-text").class("sapMITBText");if(H&&z.getUpperCase()){i.class("sapMITBTextUpperCase");}if(O){i.attr("dir","ltr");}i.openEnd();i.openStart("span").class("sapMITHTextContent");if(!K&&!Q){i.class("sapMITBBadgeHolder");}i.openEnd();i.text(y._getDisplayText(this));i.close("span");if(this._bIsOverflow||this.getItems().length&&y._isUnselectable(this)){i.openStart("span",this.getId()+"-expandButton").class("sapMITHShowSubItemsIcon").openEnd();i.icon(b.getIconURI("slim-arrow-down"),null,{"title":null,"aria-hidden":true});i.close("span");}i.close("div");}if(!O&&M){i.close("div");}i.openStart("div").class("sapMITBContentArrow").openEnd().close("div");i.close("div");if(this.getItems().length&&!y._isUnselectable(this)){i.openStart("span").accessibilityState({role:"separator"}).openEnd().close("span");i.renderControl(this._getExpandButton());}i.renderControl(this.getAggregation("_expandButtonBadge"));if(this.getItems().length){this._updateExpandButtonBadge();}i.close("div");};
v.prototype.renderInSelectList=function(i,S,x,y,z){if(this._invisibleText){this._invisibleText.destroy();this._invisibleText=null;}if(!this.getVisible()){return;}var E=true,F=S._bIconOnly,G=S._oIconTabHeader;if(G){E=G._bTextOnly;}i.openStart("li",this).class("sapMITBSelectItem").attr("tabindex","-1").attr("role","menuitem");if(z){i.style("padding-left",z+"rem");}if(x!==undefined&&y!==undefined){i.attr("aria-posinset",x+1);i.attr("aria-setsize",y);i.attr("aria-level",this._getNestedLevel());}var H=this.getTooltip_AsString();if(H){i.attr("title",H);}if(G._isUnselectable(this)){i.class("sapMITHUnselectable");}if(!this.getEnabled()){i.class("sapMITBDisabled").attr("aria-disabled",true);}if(S.getSelectedItem()==this){i.class("sapMITBSelectItemSelected");i.attr("aria-selected",true);}var J=this.getIconColor();i.class("sapMITBFilter"+J);var K=this.getId(),L=J=='Positive'||J=='Critical'||J=='Negative'||J=='Neutral',M=[];if(!F){M.push(K+"-text");}if(!E&&this.getIcon()){M.push(K+"-icon");}if(L){this._invisibleText=new e({text:w.getText('ICONTABBAR_ICONCOLOR_'+J.toUpperCase())});M.push(this._invisibleText.getId());}i.accessibilityState({labelledby:M.join(" ")}).openEnd();if(this._invisibleText){i.renderControl(this._invisibleText);}if(!E){this._renderIcon(i,F);}if(!F){this._renderText(i);}i.close("li");};
v.prototype._onAfterParentRendering=function(){this._renderBadge();d.getInstance();};
v.prototype._renderIcon=function(i,x){var y=this.getIcon();if(y){var z=b.getIconInfo(y),E=["sapMITBSelectItemIcon"];if(z&&!z.suppressMirroring){E.push("sapUiIconMirrorInRTL");}if(x){E.push("sapMITBBadgeHolder");}i.icon(y,E,{id:this.getId()+"-icon","aria-hidden":true});}else{i.openStart("span").class("sapUiIcon").openEnd().close("span");}};
v.prototype._renderText=function(i){var x=this.getText(),y=this.getCount(),z=C.getConfiguration().getRTL(),E=this.getTextDirection();i.openStart("span",this.getId()+"-text").attr("dir","ltr").class("sapMText").class("sapMTextNoWrap").class("sapMITBText").class("sapMITBBadgeHolder");if(E!==m.Inherit){i.attr('dir',E.toLowerCase());}var F=R.getTextAlign(T.Begin,E);if(F){i.style("text-align",F);}if(y){if(z){x='('+y+') '+x;}else{x+=' ('+y+')';}}i.openEnd().text(x).close("span");};
v.prototype._getSelectList=function(){if(!this._oSelectList){this._oSelectList=new j({selectionChange:function(E){var i=E.getParameter("selectedItem");this._oIconTabHeader.setSelectedItem(i._getRealTab());this._oTabFilter._closePopover();}});this._oSelectList._oIconTabHeader=this.getParent();this._oSelectList._oTabFilter=this;this._oSelectList._bIsOverflow=this._bIsOverflow;}return this._oSelectList;};
v.prototype._prepareDragEventDelegate=function(){if(this.getEnabled()){this.addEventDelegate(this._oDragEventDelegate,this);}else{this.removeEventDelegate(this._oDragEventDelegate);}};
v.prototype._getExpandButton=function(){this._oExpandButton=this.getAggregation("_expandButton");if(!this._oExpandButton){this._oExpandButton=new A(this.getId()+"-expandButton",{type:n.Transparent,icon:b.getIconURI("slim-arrow-down"),tooltip:w.getText("ICONTABHEADER_OVERFLOW_MORE"),tabIndex:"-1",press:this._expandButtonPress.bind(this)}).addStyleClass("sapMITBFilterExpandBtn");this.setAggregation("_expandButton",this._oExpandButton);}return this._oExpandButton;};
v.prototype._updateExpandButtonBadge=function(){var E=this.getAggregation("_expandButtonBadge"),H=E.getBadgeCustomData()&&E.getBadgeCustomData().getVisible(),i=this._hasChildWithBadge();if(i&&!H){E.addCustomData(new B({visible:true}));}else if(!i&&H){E.getBadgeCustomData().setVisible(false);}};
v.prototype._hasChildWithBadge=function(){var i=this._bIsOverflow?this._getIconTabHeader()._getItemsForOverflow():this._getAllSubItems();return i.some(function(x){return x.isA("sap.m.IBadge")&&x.getBadgeCustomData()&&x.getBadgeCustomData().getVisible();});};
v.prototype._expandButtonPress=function(){if(!this.getEnabled()){return;}this.$().trigger("focus");if(!this._oPopover){this._oPopover=new h({showArrow:false,showHeader:false,offsetY:0,offsetX:0,placement:P.VerticalPreferredBottom}).addStyleClass("sapMITBFilterPopover");this._oPopover.attachBeforeClose(function(){this._getSelectList().destroyItems();},this);if(D.system.phone){this._oPopover._oControl.addButton(this._createPopoverCloseButton());}this.addDependent(this._oPopover);this._oPopover._oControl._adaptPositionParams=function(){var i=this.$().parents().hasClass("sapUiSizeCompact");this._arrowOffset=0;if(i){this._offsets=["0 0","0 0","0 4","0 0"];}else{this._offsets=["0 0","0 0","0 5","0 0"];}this._atPositions=["end top","end top","end bottom","begin top"];this._myPositions=["end bottom","begin top","end top","end top"];};}var H=this._setSelectListItems();var S=this._getSelectList();this._oPopover.removeAllContent();if(this.getItems().length||this._bIsOverflow){this._oPopover.addContent(S);this._oPopover.setInitialFocus(H?S.getSelectedItem():S.getVisibleTabFilters()[0]);this._oPopover.openBy(this);}};
v.prototype._getAllSubItems=function(){var i=[];this._getRealTab().getItems().forEach(function(x){if(x.isA("sap.m.IconTabFilter")){i=i.concat(x,x._getAllSubItems());}else{i=i.concat(x);}});return i;};
v.prototype._getAllSubFilters=function(){return this._getAllSubItems().filter(function(i){return i.isA("sap.m.IconTabFilter");});};
v.prototype._getAllSubFiltersDomRefs=function(){return this._getAllSubFilters().filter(function(S){return Boolean(S._getRealTab().getDomRef());}).map(function(S){return S._getRealTab().getDomRef();});};
v.prototype._getFirstAvailableSubFilter=function(){var x=this._getAllSubFilters();for(var i=0;i<x.length;i++){var y=x[i];if(y.getContent().length&&y.getVisible()){return y;}}return this;};
v.prototype._isParentOf=function(x){var y=this._getAllSubFilters();for(var i=0;i<y.length;i++){if(y[i]._getRealTab()===x){return true;}}return false;};
v.prototype._createPopoverCloseButton=function(){return new g({text:w.getText("SELECT_CANCEL_BUTTON"),press:this._closePopover.bind(this)});};
v.prototype._closePopover=function(){if(this._oPopover){this._oPopover.close();this._oPopover.removeAllContent();}if(this._bIsOverflow&&this.getParent().oSelectedItem){(this.getParent()._oSelectedRootItem||this.getParent().oSelectedItem).$().focus();}};
v.prototype._handleOnDragOver=function(E){if(this._isDropPossible(E)){this.getDomRef().classList.add("sapMITHDragOver");E.preventDefault();}};
v.prototype._handleOnLongDragOver=function(E){if(this._isDropPossible(E)){if(this._oPopover&&this._oPopover.isOpen()){return;}this._expandButtonPress();}};
v.prototype._handleOnDrop=function(){this.getDomRef().classList.remove("sapMITHDragOver");};
v.prototype._handleOnDragLeave=function(){this.getDomRef().classList.remove("sapMITHDragOver");};
v.prototype._isDropPossible=function(E){var i=this._getIconTabHeader(),x=E.dragSession.getDragControl()._getRealTab(),S=i.oSelectedItem;if(i!==x._getIconTabHeader()){return false;}if(x===this||x._isParentOf(this)){return false;}if(!this._bIsOverflow&&!i.getMaxNestingLevel()){return false;}if(this._bIsOverflow&&S&&(S===x||S._getRootTab()===x)){return false;}return true;};
v.prototype._setSelectListItems=function(){var x=this.getParent(),S=this._getSelectList(),y=this._getAllSubItems(),z=x.oSelectedItem,H=false,E,L,F,i,G;if(this._bIsOverflow){y=x._getItemsForOverflow();}S.destroyItems();S.setSelectedItem(null);for(i=0;i<y.length;i++){E=y[i];L=E.clone(undefined,undefined,{cloneChildren:false,cloneBindings:true});E._oCloneInList=L;F=E.getCustomData();for(G=0;G<F.length;G++){L.addCustomData(F[G].clone());}L._oRealItem=E;S.addItem(L);if(E.isA("sap.m.IconTabSeparator")){continue;}if(L._getRealTab()===z){S.setSelectedItem(L);H=true;continue;}if(L._getRealTab()._isParentOf(z)){S.setSelectedItem(z._getRealTab());H=true;}}return H;};
v.prototype._getIconTabHeader=function(){return this._getRootTab().getParent();};
v.prototype.onsapdown=function(E){if(!this.getEnabled()){return;}if(this._bIsOverflow||((this._getNestedLevel()===1&&this._getRealTab()===this)&&this._getRealTab().getItems().length!==0)){E.stopImmediatePropagation();this._expandButtonPress();}};
v.prototype._startBadgeHiding=function(){if(this._iHideBadgeTimeout){return;}this._iHideBadgeTimeout=setTimeout(this._hideBadge.bind(this),t);if(this._getRootTab()!==this){this._getRootTab()._updateExpandButtonBadge();}};
v.prototype._hideBadge=function(){var i=this.getBadgeCustomData();if(!i){return;}i.setVisible(false);if(this._getRootTab()!==this){this._getRootTab()._updateExpandButtonBadge();}if(this._oCloneInList&&!this._oCloneInList.bIsDestroyed&&this._oCloneInList.getBadgeCustomData()){this._oCloneInList.getBadgeCustomData().setVisible(false);this._oCloneInList=null;}if(this._isInOverflow()){this._getIconTabHeader()._getOverflow()._updateExpandButtonBadge();}this._iHideBadgeTimeout=null;};
v.prototype._isInOverflow=function(){return!this._bIsOverflow&&this._getIconTabHeader()._getItemsInStrip().indexOf(this._getRealTab())===-1;};
v.prototype.onBadgeUpdate=function(V,S,i){var x=this.getDomRef(),y=this._getIconTabHeader(),z,E,F,G,O,H,J;if(!y){return;}if(x){F=x.getAttribute("aria-labelledby")||"";switch(S){case r.Appear:F=i+" "+F;break;case r.Disappear:F=F.replace(i,"").trim();break;}x.setAttribute("aria-labelledby",F);}if(!y._isRendered()){return;}z=this._getRootTab();if(z._isInOverflow()){O=this._getIconTabHeader()._getOverflow();O._updateExpandButtonBadge();}else if(z!==this){z._updateExpandButtonBadge();}if(S!==r.Appear){return;}this._enableMotion();if(this._isInOverflow()&&this._oCloneInList){this._oCloneInList.addCustomData(new B());}E=d.getInstance();G=this.getText();if(z._isInOverflow()){H="ICONTABFILTER_SUB_ITEM_BADGE";J=[G,O.getText()];}else{if(z!==this){H="ICONTABFILTER_SUB_ITEM_BADGE";J=[G,z.getText()];}else{H="ICONTABFILTER_BADGE_MSG";J=G;}}E.announce(w.getText(H,J),u.Assertive);};
v.prototype.getAriaLabelBadgeText=function(){return w.getText("ICONTABFILTER_BADGE");};
v.prototype._enableMotion=function(){if(this._getRealTab()._isInOverflow()){if(this._oCloneInList&&this._oCloneInList.getDomRef()){this._oCloneInList.getDomRef().classList.add("sapMITBFilterBadgeMotion");}}else if(this.getDomRef()){this.getDomRef().classList.add("sapMITBFilterBadgeMotion");}};
return v;});
sap.ui.predefine('sap/m/IconTabFilterExpandButtonBadge',["./BadgeEnabler","sap/ui/core/Control","sap/ui/core/Core"],function(B,C,a){"use strict";var r=a.getLibraryResourceBundle("sap.m");
var I=C.extend("sap.m.IconTabFilterExpandButtonBadge",{
metadata:{library:"sap.m",interfaces:["sap.m.IBadge"]},
renderer:{apiVersion:2,render:function(R,c){R.openStart("div",c).class("sapMITFExpandButtonBadge").openEnd().close("div");}}
});
B.call(I.prototype);
I.prototype.init=function(){this.initBadgeEnablement({style:"Attention"});};
I.prototype.getAriaLabelBadgeText=function(){return r.getText("ICONTABFILTER_SUB_ITEMS_BADGES");};
I.prototype.onBadgeUpdate=function(){var p=this.getParent();p.onBadgeUpdate.apply(p,arguments);};
return I;});
sap.ui.predefine('sap/m/IconTabHeader',['./library','sap/ui/core/Core','sap/ui/core/Control','sap/ui/core/EnabledPropagator','sap/ui/core/delegate/ItemNavigation',"sap/ui/core/InvisibleText",'sap/ui/core/ResizeHandler','sap/ui/Device','sap/m/Button','sap/m/IconTabFilter','sap/m/IconTabSeparator','sap/m/IconTabBarDragAndDropUtil','sap/ui/core/library','sap/m/IconTabHeaderRenderer',"sap/ui/thirdparty/jquery","sap/base/Log","sap/ui/events/KeyCodes"],function(l,C,a,E,I,b,R,D,B,c,d,e,f,g,q,L,K){"use strict";var h=f.dnd.DropPosition;var k=l.BackgroundDesign;var m=l.IconTabHeaderMode;var n=l.IconTabDensityMode;
var o=a.extend("sap.m.IconTabHeader",{metadata:{library:"sap.m",properties:{showSelection:{type:"boolean",group:"Misc",defaultValue:true,deprecated:true},selectedKey:{type:"string",group:"Data",defaultValue:null},visible:{type:"boolean",group:"Behavior",defaultValue:true},mode:{type:"sap.m.IconTabHeaderMode",group:"Appearance",defaultValue:m.Standard},showOverflowSelectList:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:k.Solid},enableTabReordering:{type:"boolean",group:"Behavior",defaultValue:false},maxNestingLevel:{type:"int",group:"Behavior",defaultValue:0},tabDensityMode:{type:"sap.m.IconTabDensityMode",group:"Appearance",defaultValue:n.Cozy},ariaTexts:{type:"object",group:"Accessibility",defaultValue:null}},aggregations:{items:{type:"sap.m.IconTab",multiple:true,singularName:"item",dnd:{draggable:true,droppable:true,layout:"Horizontal"}},_overflow:{type:"sap.m.IconTabFilter",multiple:false,visibility:"hidden"}},events:{select:{parameters:{item:{type:"sap.m.IconTabFilter"},key:{type:"string"}}}}}});
var r=C.getLibraryResourceBundle("sap.m");E.apply(o.prototype,[true]);
o.prototype.init=function(){this._aTabKeys=[];this._oAriaHeadText=null;this._bIsRendered=false;};
o.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}if(this._aTabKeys){this._aTabKeys=null;}if(this._oOverflow){this._oOverflow.removeEventDelegate(this._oOverflowEventDelegate);this._oOverflowEventDelegate=null;this._oOverflow=null;}if(this._oAriaHeadText){this._oAriaHeadText.destroy();this._oAriaHeadText=null;}this._bRtl=null;};
o.prototype.onBeforeRendering=function(){this._bIsRendered=false;this._bRtl=C.getConfiguration().getRTL();if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}this._updateSelection();this.destroyDragDropConfig();this._setsDragAndDropConfigurations();};
o.prototype.onAfterRendering=function(){this._applyTabDensityMode();if(this.oSelectedItem){this._applySelectionToFilters();this.oSelectedItem._hideBadge();}if(C.isThemeApplied()){this._setItemsForStrip();}else{C.attachThemeChanged(this._handleThemeLoad,this);}this._initItemNavigation();this._sResizeListenerId=R.register(this.getDomRef(),q.proxy(this._fnResize,this));this.getItems().forEach(function(i){if(i._onAfterParentRendering){i._onAfterParentRendering();}});this._bIsRendered=true;};
o.prototype._isRendered=function(){return this._bIsRendered;};
o.prototype._getSelectList=function(){return this._getOverflow()._getSelectList();};
o.prototype._getOverflow=function(){var O=this.getAggregation("_overflow");if(!O){O=new c({id:this.getId()+'-overflow',text:r.getText("ICONTABHEADER_OVERFLOW_MORE")});O._bIsOverflow=true;this._oOverflowEventDelegate={onsapnext:O.onsapdown};O.addEventDelegate(this._oOverflowEventDelegate,O);this.setAggregation("_overflow",O);this._oOverflow=O;}return O;};
o.prototype._getInvisibleHeadText=function(){var A=this.getAriaTexts()||{};if(!this._oAriaHeadText){this._oAriaHeadText=new b({id:this.getId()+"-ariaHeadText"});}this._oAriaHeadText.setText(A.headerDescription);return this._oAriaHeadText;};
o.prototype._onItemNavigationFocusLeave=function(){if(!this.oSelectedItem){return;}var j=this.getItems();var p=-1;var s;for(var i=0;i<j.length;i++){s=j[i];if(s instanceof c==false){continue;}p++;if((this.oSelectedItem._getRootTab()||this.oSelectedItem)===s){break;}}this._oItemNavigation.setFocusedIndex(p);};
o.prototype.getTabFilters=function(){var t=[];this.getItems().forEach(function(i){if(i instanceof c){t.push(i);}});return t;};
o.prototype._setsDragAndDropConfigurations=function(){if(this.getEnableTabReordering()&&!this.getDragDropConfig().length){e.setDragDropAggregations(this,"Horizontal",this._getDropPosition());}};
o.prototype._getDropPosition=function(){return this.getMaxNestingLevel()===0?h.Between:h.OnOrBetween;};
o.prototype.setSelectedKey=function(s){var j=this.getTabFilters(),p=this._isInsideIconTabBar(),S;if(j.length>0){s=s||j[0]._getNonEmptyKey();}if(this.$().length){for(var i=0;i<j.length;i++){if(j[i]._getNonEmptyKey()===s){this.setSelectedItem(j[i],true);S=true;break;}}if(!S&&!p&&s){this.setSelectedItem(null);}}this.setProperty("selectedKey",s,true);return this;};
o.prototype.setSelectedItem=function(i,A){if(!i){if(this.oSelectedItem){this._removeSelectionFromFilters();this.oSelectedItem=null;}return this;}if(this._isUnselectable(i)){return this;}var p=this.getParent();var j=this._isInsideIconTabBar();var s=false;if(i.getContent().length===0&&this.oSelectedItem&&this.oSelectedItem.getContent().length===0){s=true;}if(this.oSelectedItem&&this.oSelectedItem.getVisible()&&(!A&&j&&p.getExpandable()||this.oSelectedItem!==i)){this._removeSelectionFromFilters();}if(i.getVisible()){if(this.oSelectedItem===i){if(!A&&j&&p.getExpandable()){p._toggleExpandCollapse();}}else{if(j){p.$("content").attr('aria-labelledby',i.sId);}this.oSelectedItem=i;this._applySelectionToFilters();this.setProperty("selectedKey",this.oSelectedItem._getNonEmptyKey(),true);if(j&&(p.getExpandable()||p.getExpanded())){var S=this.oSelectedItem.getContent();if(S.length>0){p._rerenderContent(S);}else{if(!s){p._rerenderContent(p.getContent());}}if(!A&&p.getExpandable()&&!p.getExpanded()){p._toggleExpandCollapse(true);}}}}this.oSelectedItem=i;var t=this.oSelectedItem._getNonEmptyKey();this.setProperty("selectedKey",t,true);if(j){p.setProperty("selectedKey",t,true);}if(!A){if(j){p.fireSelect({selectedItem:this.oSelectedItem,selectedKey:t,item:this.oSelectedItem,key:t});}else{this.fireSelect({selectedItem:this.oSelectedItem,selectedKey:t,item:this.oSelectedItem,key:t});}}this.oSelectedItem._startBadgeHiding();this._setItemsForStrip();return this;};
o.prototype.getVisibleTabFilters=function(){return this.getTabFilters().filter(function(F){return F.getVisible();});};
o.prototype._initItemNavigation=function(){var t=[],s=-1,S=this.oSelectedItem&&this.oSelectedItem._getRootTab();this.getTabFilters().forEach(function(i){var j=this.getFocusDomRef(i);if(!j){return;}j.setAttribute("tabindex","-1");t.push(j);if(i===S||i===this.oSelectedItem){s=t.indexOf(j);}}.bind(this));if(this.$().hasClass("sapMITHOverflowList")){var O=this._getOverflow().getFocusDomRef();O.setAttribute("tabindex","-1");t.push(O);}if(!this._oItemNavigation){this._oItemNavigation=new I().setCycling(false).attachEvent(I.Events.FocusLeave,this._onItemNavigationFocusLeave,this).setDisabledModifiers({sapnext:["alt","meta"],sapprevious:["alt","meta"]});this.addDelegate(this._oItemNavigation);}this._oItemNavigation.setRootDomRef(this.getDomRef()).setItemDomRefs(t).setPageSize(t.length).setSelectedIndex(s);};
o.prototype.onThemeChanged=function(){this._applyTabDensityMode();};
o.prototype._applyTabDensityMode=function(){var t=this.getTabDensityMode();this.$().removeClass("sapUiSizeCompact");switch(t){case n.Compact:this.$().addClass("sapUiSizeCompact");break;case n.Inherit:if(this.$().closest(".sapUiSizeCompact").length){this.$().addClass("sapUiSizeCompact");}break;}};
o.prototype._handleThemeLoad=function(){setTimeout(this._setItemsForStrip.bind(this),350);C.detachThemeChanged(this._handleThemeLoad,this);};
o.prototype.destroyItems=function(){this.oSelectedItem=null;this._aTabKeys=[];this.destroyAggregation("items");return this;};
o.prototype.addItem=function(i){if(!(i instanceof d)){var s=i.getKey();if(this._aTabKeys.indexOf(s)!==-1){L.warning("sap.m.IconTabHeader: duplicate key '"+s+"' inside the IconTabFilter. Please use unique keys.");}this._aTabKeys.push(s);}this.addAggregation("items",i);this._invalidateParentIconTabBar();};
o.prototype.insertItem=function(i,j){if(!(i instanceof d)){var s=i.getKey();if(this._aTabKeys.indexOf(s)!==-1){L.warning("sap.m.IconTabHeader: duplicate key '"+s+"' inside the IconTabFilter. Please use unique keys.");}this._aTabKeys.push(s);}this.insertAggregation("items",i,j);this._invalidateParentIconTabBar();};
o.prototype.removeAllItems=function(){var i=this.removeAllAggregation("items");this._aTabKeys=[];this.oSelectedItem=null;this._invalidateParentIconTabBar();return i;};
o.prototype.removeItem=function(i){i=this.removeAggregation("items",i);if(i&&!(i instanceof d)){var s=i.getKey();this._aTabKeys.splice(this._aTabKeys.indexOf(s),1);}if(this.oSelectedItem===i){this.oSelectedItem=null;}this._invalidateParentIconTabBar();return i;};
o.prototype.updateAggregation=function(){this.oSelectedItem=null;a.prototype.updateAggregation.apply(this,arguments);this.invalidate();};
o.prototype.removeAggregation=function(A,O,s){var i=this.getTabFilters();var j=a.prototype.removeAggregation.apply(this,arguments);if(s){return j;}if(!this._getPreserveSelection()&&j&&j==this.oSelectedItem&&A=='items'){var p=(i?Array.prototype.indexOf.call(i,j):-1);i=this.getTabFilters();p=Math.max(0,Math.min(p,i.length-1));var S=i[p];if(S){this.setSelectedItem(S,true);}else{var t=this.getParent();if(this._isInsideIconTabBar()&&t.getExpanded()){t.$("content").children().remove();}}}return j;};
o.prototype.removeAllAggregation=function(A,s){if(A=='items'){var i=this.getParent();if(this._isInsideIconTabBar()&&i.getExpanded()){i.$("content").children().remove();}}return a.prototype.removeAllAggregation.apply(this,arguments);};
o.prototype._getPreserveSelection=function(){return this._bPreserveSelection;};
o.prototype._setPreserveSelection=function(p){this._bPreserveSelection=p;};
o.prototype._getDisplayText=function(i){var t=i.getText();if(this.isInlineMode()){var s=i.getCount();if(s){if(this._bRtl){t='('+s+') '+t;}else{t+=' ('+s+')';}}}return t;};
o.prototype.isInlineMode=function(){return this._bTextOnly&&this.getMode()==m.Inline;};
o.prototype._checkTextOnly=function(){this._bTextOnly=this.getItems().every(function(i){return i instanceof d||!i.getIcon();});return this._bTextOnly;};
o.prototype._checkNoText=function(j){if(j.length>0){for(var i=0;i<j.length;i++){if(!(j[i]instanceof d)){if(j[i].getText().length>0){return false;}}}}return true;};
o.prototype._checkInLine=function(j){var p;if(j.length>0){for(var i=0;i<j.length;i++){p=j[i];if(!(p instanceof d)){if(p.getIcon()||p.getCount()){this._bInLine=false;return false;}}}}this._bInLine=true;return true;};
o.prototype._getItemsInStrip=function(){return this.getItems().filter(function(i){var j=i.getDomRef();return j&&!j.classList.contains("sapMITBFilterHidden");});};
o.prototype._setItemsForStrip=function(){var t=this.getVisibleTabFilters();if(!C.isThemeApplied()||!t.length){return;}var T=this.getDomRef("head"),s=(this.oSelectedItem&&this.oSelectedItem.getVisible())?this.oSelectedItem:t[0];if(!T){return;}var j=T.offsetWidth,i,S=(s._getRootTab()||s).getDomRef(),p=this.getItems().filter(function(A){return A.getDomRef();}).map(function(A){return A.getDomRef();});if(!p.length||!S){return;}p.forEach(function(A){A.style.width="";A.classList.remove("sapMITBFilterHidden");A.classList.remove("sapMITBFilterTruncated");});var u=p.indexOf(S),v=this._getItemSize(S),w,x=0,y;if(p[u-1]&&p[u-1].classList.contains("sapMITBSep")){w=p[u-1];x=this._getItemSize(w);}y=v+x;if(j<y){S.style.width=(j-20-x)+"px";S.classList.add("sapMITBFilterTruncated");}p.splice(u,1);if(w){p.splice(u-1,1);}var z=this._findLastVisibleItem(p,j,y);for(i=z+1;i<p.length;i++){p[i].classList.add("sapMITBFilterHidden");}this._getOverflow()._updateExpandButtonBadge();this._getOverflow().$().toggleClass("sapMITHOverflowVisible",z+1!==p.length);this.$().toggleClass("sapMITHOverflowList",z+1!==p.length);};
o.prototype._findLastVisibleItem=function(i,t,s){var j=-1,p,u,v,P;for(p=0;p<i.length;p++){u=i[p];v=this._getItemSize(u);if(t>(s+v)){s+=v;j=p;}else{P=i[p-1];if(P&&P.classList.contains("sapMITBSep")){j-=1;}break;}}return j;};
o.prototype._getItemSize=function(i){var s=window.getComputedStyle(i),w=i.offsetWidth,M=Number.parseInt(s.marginLeft)+Number.parseInt(s.marginRight);return w+M;};
o.prototype._handleActivation=function(i){var t=i.target.id,j=i.srcControl,s,$=q(i.target);if(j instanceof B){return;}var p=q(document.getElementById(t));if(p.parents()&&Array.prototype.indexOf.call(p.parents(),this.$("content")[0])>-1){}else{if(t){i.preventDefault();if($.hasClass('sapMITBFilterIcon')||$.hasClass('sapMITBCount')||$.hasClass('sapMITBText')||$.hasClass('sapMITBTab')||$.hasClass('sapMITBContentArrow')||$.hasClass('sapMITBSep')||$.hasClass('sapMITBSepIcon')){s=i.srcControl.getId().replace(/-icon$/,"");j=C.byId(s);if(j.getMetadata().isInstanceOf("sap.m.IconTab")&&!(j instanceof d)){if(this._isUnselectable(j)){if(j.getItems().length||j._bIsOverflow){j._expandButtonPress();}return;}if(j===this._getOverflow()){j._expandButtonPress();return;}this.setSelectedItem(j);}}else if(j.getMetadata().isInstanceOf("sap.m.IconTab")&&!(j instanceof d)){if(this._isUnselectable(j)){if(j.getItems().length||j._bIsOverflow){j._expandButtonPress();}return;}if(j===this._getOverflow()){j._expandButtonPress();return;}this.setSelectedItem(j);}}else{if(j.getMetadata().isInstanceOf("sap.m.IconTab")&&!(j instanceof d)){if(this._isUnselectable(j)){if(j.getItems().length||j._bIsOverflow){j._expandButtonPress();}return;}if(j===this._getOverflow()){j._expandButtonPress();return;}this.setSelectedItem(j);}}}};
o.prototype._fnResize=function(){if(this._getOverflow()._oPopover){this._getOverflow()._oPopover.close();}this._setItemsForStrip();this._initItemNavigation();};
o.prototype._isUnselectable=function(i){var F=i._getRealTab();return!F.getEnabled()||(this._isInsideIconTabBar()&&!this.getParent().getContent().length&&F._getNestedLevel()===1&&F.getItems().length&&!F.getContent().length)||F._bIsOverflow;};
o.prototype._isInsideIconTabBar=function(){var p=this.getParent();return p instanceof a&&p.isA('sap.m.IconTabBar');};
o.prototype._invalidateParentIconTabBar=function(){if(this._isInsideIconTabBar()){this.getParent().invalidate();}};
o.prototype.getFocusDomRef=function(F){var t=F||this.oSelectedItem;if(!t){return null;}return t.getDomRef();};
o.prototype.applyFocusInfo=function(F){if(F.focusDomRef){q(F.focusDomRef).trigger("focus");}};
o.prototype._updateSelection=function(){var j=this.getItems(),s=this.getSelectedKey(),i=0,p=this.getParent(),t=this._isInsideIconTabBar(),u=p&&p.isA("sap.tnt.ToolHeader");if(!j.length){return;}if(!this.oSelectedItem||s&&s!==this.oSelectedItem._getNonEmptyKey()){if(s){this.oSelectedItem=this._findItemByKey(s);}if(!this.oSelectedItem&&(t||!s)){for(i=0;i<j.length;i++){if(!(j[i]instanceof d)&&j[i].getVisible()){this.oSelectedItem=j[i];break;}}}}if(!u&&this.oSelectedItem&&!this.oSelectedItem.getVisible()){for(i=0;i<j.length;i++){if(!(j[i]instanceof d)&&j[i].getVisible()){this.oSelectedItem=j[i];break;}}}if(!this.oSelectedItem){return;}if(this._isUnselectable(this.oSelectedItem)){this.setSelectedItem(this.oSelectedItem._getFirstAvailableSubFilter(),true);return;}this.setProperty("selectedKey",this.oSelectedItem._getNonEmptyKey(),true);};
o.prototype._findItemByKey=function(s){var t=this.getTabFilters(),S;for(var i=0;i<t.length;i++){if(t[i]._getNonEmptyKey()===s){return t[i];}S=t[i]._getAllSubFilters();for(var j=0;j<S.length;j++){if(S[j]._getNonEmptyKey()===s){return S[j];}}}};
o.prototype._applySelectionToFilters=function(){if(this._isInsideIconTabBar()&&!this.getParent().getExpanded()){return;}this.oSelectedItem.$().addClass("sapMITBSelected").attr({'aria-selected':true});if(this.oSelectedItem._getNestedLevel()!==1){var s=this.oSelectedItem._getRootTab();s.$().addClass("sapMITBSelected").attr({"aria-selected":true});}};
o.prototype._removeSelectionFromFilters=function(){this.oSelectedItem.$().removeClass("sapMITBSelected").attr({'aria-selected':false});if(this.oSelectedItem._getNestedLevel()!==1){var s=this.oSelectedItem._getRootTab();s.$().removeClass("sapMITBSelected").attr({"aria-selected":false});}};
o.prototype._getItemsForOverflow=function(){var i=this._getItemsInStrip(),j=[];this.getItems().forEach(function(p){if(!D.system.phone&&i.indexOf(p)>-1){return;}j.push(p);if(p.isA("sap.m.IconTabFilter")){p._getAllSubItems().forEach(function(s){j.push(s);});}});return j;};
o.prototype.ontouchstart=function(i){var t=i.targetTouches[0];this._iActiveTouch=t.identifier;};
o.prototype.ontouchend=function(i){if(this._iActiveTouch===undefined){return;}var M=0;var j=1;var p;if(i.which===p||i.which===M||i.which===j){this._handleActivation(i);}this._iActiveTouch=undefined;};
o.prototype.ontouchcancel=o.prototype.ontouchend;
o.prototype.onkeydown=function(i){switch(i.which){case K.ENTER:this._handleActivation(i);i.preventDefault();break;case K.SPACE:this._handleActivation(i);i.preventDefault();break;}};
o.prototype._handleDragAndDrop=function(i){var j=i.getParameter("dropPosition"),p=i.getParameter("draggedControl"),s=i.getParameter("droppedControl"),t=this,u=this.getMaxNestingLevel();if(j===h.On){t=s._getRealTab();}e.handleDrop(t,j,p._getRealTab(),s,false,u);if(p._getNestedLevel()>1){p._getRootTab()._closePopover();}this._setItemsForStrip();this._initItemNavigation();this._getOverflow()._setSelectListItems();this._getSelectList()._initItemNavigation();p._getRealTab().$().trigger("focus");if(j===h.On){s._getRealTab().$().trigger("focus");}};
o.prototype._moveTab=function(t,i,M){e.moveItem.call(this,t,i,M);this._setItemsForStrip();this._initItemNavigation();};
o.prototype.ondragrearranging=function(i){if(!this.getEnableTabReordering()){return;}var t=i.srcControl,T=this.indexOfItem(this._getItemsInStrip().pop());this._moveTab(t,i.keyCode,T);t.$().trigger("focus");};
o.prototype.onsaphomemodifiers=o.prototype.ondragrearranging;o.prototype.onsapendmodifiers=o.prototype.ondragrearranging;o.prototype.onsapincreasemodifiers=o.prototype.ondragrearranging;o.prototype.onsapdecreasemodifiers=o.prototype.ondragrearranging;return o;});
sap.ui.predefine('sap/m/IconTabHeaderRenderer',[],function(){"use strict";var I={apiVersion:2};
I.render=function(r,c){if(!c.getVisible()){return;}var s=c.getId(),a=c.getItems(),v=c.getVisibleTabFilters().length,V=0,t=c._checkTextOnly(),n=c._checkNoText(a),b=c._checkInLine(a)||c.isInlineMode();var o=c.getParent(),u=o&&o.isA('sap.m.IconTabBar')&&o.getUpperCase(),A=c.getAriaTexts()||{};r.openStart("div",c).class("sapMITH").class("sapContrastPlus").class("sapMITHBackgroundDesign"+c.getBackgroundDesign());if(a.length){r.class("sapMITHOverflowList");}if(u){r.class("sapMITBTextUpperCase");}if(t){r.class("sapMITBTextOnly");}if(n){r.class("sapMITBNoText");}if(b){r.class("sapMITBInLine");}r.accessibilityState(c,{role:"navigation"});if(A.headerLabel){r.accessibilityState(c,{label:A.headerLabel});}r.openEnd();if(A.headerDescription){r.renderControl(c._getInvisibleHeadText());}r.openStart("div",s+"-head").class("sapMITBHead");r.accessibilityState({role:"tablist",orientation:"horizontal"});if(A.headerDescription){r.accessibilityState({describedby:c._getInvisibleHeadText().getId()});}r.openEnd();for(var i=0;i<a.length;i++){var d=a[i];d.render(r,V,v);if(d.isA("sap.m.IconTabFilter")){if(d.getVisible()){V++;}}}r.close("div");if(a.length){r.openStart("div").class("sapMITHOverflow").openEnd();c._getOverflow().render(r);r.close("div");}r.close("div");};
return I;},true);
sap.ui.predefine('sap/m/IconTabSeparator',["./library","sap/ui/core/Core","sap/ui/core/Element","sap/ui/core/Item","sap/m/IconTabFilter"],function(l,C,E,I,a){"use strict";var b=l.ImageHelper;
var c=E.extend("sap.m.IconTabSeparator",{metadata:{interfaces:["sap.m.IconTab"],library:"sap.m",designtime:"sap/m/designtime/IconTabSeparator.designtime",properties:{icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:''},visible:{type:"boolean",group:"Behavior",defaultValue:true},iconDensityAware:{type:"boolean",group:"Appearance",defaultValue:true}}}});
c.prototype._getImageControl=function(d,p){var P={src:this.getIcon(),densityAware:this.getIconDensityAware(),useIconTooltip:false};this._oImageControl=b.getImageControl(this.getId()+"-icon",this._oImageControl,p,P,d);return this._oImageControl;};
c.prototype.exit=function(e){if(this._oImageControl){this._oImageControl.destroy();}if(I.prototype.exit){I.prototype.exit.call(this,e);}};
c.prototype._getRealTab=function(){return a.prototype._getRealTab.call(this);};
c.prototype._getNestedLevel=function(){return a.prototype._getNestedLevel.call(this);};
c.prototype.render=function(r){if(!this.getVisible()){return;}var i=this.getIcon(),o=this.getParent(),R=C.getLibraryResourceBundle('sap.m'),A={};if(i){A.role="img";A.label=R.getText("ICONTABBAR_NEXTSTEP");}else{A.role="separator";}r.openStart("div",this).accessibilityState(A).class("sapMITBItem").class("sapMITBSep");if(!i){r.class("sapMITBSepLine");}r.openEnd();if(i){r.renderControl(this._getImageControl(["sapMITBSepIcon"],o));}r.close("div");};
c.prototype.renderInSelectList=function(r,s,i,S,p){if(!this.getVisible()){return;}var d=this.getIcon(),o=s._oIconTabHeader,R=C.getLibraryResourceBundle('sap.m'),A={};if(d){A.role="img";A.label=R.getText("ICONTABBAR_NEXTSTEP");}else{A.role="separator";}r.openStart("li",this).class("sapMITBSelectItem").class("sapMITBSep").accessibilityState(A);if(p&&!d){r.style("padding-left",p+"rem");}if(!d){r.class("sapMITBSepLine");}r.openEnd();if(d){r.renderControl(this._getImageControl(["sapMITBSepIcon"],o));}r.close("li");};
return c;});
sap.ui.predefine('sap/m/Image',['./library','sap/ui/core/Control','sap/ui/base/DataType','./ImageRenderer',"sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery","sap/base/security/encodeCSS"],function(l,C,D,I,K,q,e){"use strict";var a=l.ImageMode;
var b=C.extend("sap.m.Image",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.m",designtime:"sap/m/designtime/Image.designtime",properties:{src:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},decorative:{type:"boolean",group:"Accessibility",defaultValue:true},alt:{type:"string",group:"Accessibility",defaultValue:null},useMap:{type:"string",group:"Misc",defaultValue:null},densityAware:{type:"boolean",group:"Misc",defaultValue:false},activeSrc:{type:"sap.ui.core.URI",group:"Data",defaultValue:""},mode:{type:"sap.m.ImageMode",group:"Misc",defaultValue:"Image"},backgroundSize:{type:"string",group:"Appearance",defaultValue:"cover"},backgroundPosition:{type:"string",group:"Appearance",defaultValue:"initial"},backgroundRepeat:{type:"string",group:"Appearance",defaultValue:"no-repeat"}},aggregations:{detailBox:{type:'sap.m.LightBox',multiple:false,bindable:"bindable"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},ariaDetails:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDetails"}},events:{tap:{},press:{},load:{},error:{}},dnd:{draggable:true,droppable:false}}});
b._currentDevicePixelRatio=(function(){var r=(window.devicePixelRatio===undefined?1:window.devicePixelRatio);if(r<=1){r=1;}else{r*=2;r=Math.round(r);r/=2;}if(r>2){r=2;}return r;}());
b.prototype.onload=function(E){var w,h;if(!this._defaultEventTriggered){this._defaultEventTriggered=true;}this._bVersion2Tried=false;var d=this.$(),o=d[0];if(this.getMode()===a.Background){d.css("background-image","url(\""+e(this._oImage.src)+"\")");}if(!this._isWidthOrHeightSet()){if(this._iLoadImageDensity>1){w=Math.round(o.getBoundingClientRect().width);h=Math.round(o.getBoundingClientRect().height);if((w===o.naturalWidth)&&(h===o.naturalHeight)){d.width(w/this._iLoadImageDensity);}}}d.removeClass("sapMNoImg");this.fireLoad();};
b.prototype.onerror=function(E){if(!this._defaultEventTriggered){this._defaultEventTriggered=true;}var $=this.$(),m=this.getMode(),s=(m===a.Image)?this._getDomImg().attr("src"):this._oImage.src,d=b._currentDevicePixelRatio,c=this._isActiveState?this.getActiveSrc():this.getSrc();$.addClass("sapMNoImg");if(!s||this._iLoadImageDensity===1){if(this.getAlt()&&!this.getDecorative()){$.removeClass("sapMNoImg");}this.fireError();return;}if(d===2||d<1){this._iLoadImageDensity=1;this._updateDomSrc(this._generateSrcByDensity(c,1));}else if(d===1.5){if(this._bVersion2Tried){setTimeout(q.proxy(function(){this._iLoadImageDensity=1;this._updateDomSrc(this._generateSrcByDensity(c,1));},this),0);}else{setTimeout(q.proxy(function(){this._iLoadImageDensity=2;this._updateDomSrc(this._generateSrcByDensity(c,2));this._bVersion2Tried=true;},this),0);}}};
b.prototype.setDetailBox=function(L){var c=this.getDetailBox();if(L){if(L===c){return this;}if(c){this.detachPress(this._fnLightBoxOpen,c);}this._fnLightBoxOpen=L.open;this.attachPress(this._fnLightBoxOpen,L);}else if(this._fnLightBoxOpen){this.detachPress(this._fnLightBoxOpen,c);this._fnLightBoxOpen=null;}return this.setAggregation("detailBox",L);};
b.prototype.clone=function(){var c=C.prototype.clone.apply(this,arguments),o=c.getDetailBox();if(o){c.detachPress(this._fnLightBoxOpen,this.getDetailBox());c._fnLightBoxOpen=o.open;c.attachPress(c._fnLightBoxOpen,o);}return c;};
b.prototype.onBeforeRendering=function(){this._defaultEventTriggered=false;if(this.getMode()==a.Image){var d=this.getDetailBox()?this.$().find(".sapMImg"):this.$();d.off("load").off("error");}};
b.prototype.onAfterRendering=function(){var d=this.getDetailBox()?this.$().find(".sapMImg"):this.$(),m=this.getMode(),o;if(m===a.Image){d.on("load",q.proxy(this.onload,this));d.on("error",q.proxy(this.onerror,this));o=d[0];}if(m===a.Background){o=this._oImage;}if(o&&o.complete&&!this._defaultEventTriggered){if(o.naturalWidth>0){this.onload({});}else{this.onerror({});}}};
b.prototype.exit=function(){if(this._oImage){q(this._oImage).off("load",this.onload).off("error",this.onerror);this._oImage=null;}else{this.$().off("load",this.onload).off("error",this.onerror);}if(this._fnLightBoxOpen){this._fnLightBoxOpen=null;}};
b.prototype.ontouchstart=function(E){if(E.srcControl.mEventRegistry["press"]||E.srcControl.mEventRegistry["tap"]){E.setMarked();}if(E.targetTouches.length===1&&this.getActiveSrc()){this._updateDomSrc(this._getDensityAwareActiveSrc());this._isActiveState=true;}};
b.prototype.ontouchend=function(E){if(E.targetTouches.length===0&&this.getActiveSrc()){this._isActiveState=false;this._updateDomSrc(this._getDensityAwareSrc());this.$().removeClass("sapMNoImg");}};
b.prototype.attachPress=function(){Array.prototype.unshift.apply(arguments,["press"]);C.prototype.attachEvent.apply(this,arguments);if(this.hasListeners("press")){this.$().attr("tabindex","0");this.$().attr("role","button");}return this;};
b.prototype.detachPress=function(){Array.prototype.unshift.apply(arguments,["press"]);C.prototype.detachEvent.apply(this,arguments);if(!this.hasListeners("press")){this.$().removeAttr("tabindex");if(this.getDecorative()){this.$().attr("role","presentation");}else{this.$().removeAttr("role");}}return this;};
b.prototype.ontap=function(E){this.fireTap({});this.firePress({});};
b.prototype.onkeyup=function(E){if(E.which===K.SPACE||E.which===K.ENTER){this.firePress({});E.stopPropagation();}};
b.prototype.onsapspace=function(E){E.preventDefault();};
b.prototype._updateDomSrc=function(s){var d=this.$(),m=this.getMode();if(d.length){if(m===a.Image){this._getDomImg().attr("src",s);}else{d.addClass("sapMNoImg");q(this._oImage).attr("src",s);}}};
b.prototype._getDomImg=function(){var d=this.$();return this.getDetailBox()?d.children("img"):d;};
b.prototype._preLoadImage=function(s){if(this.getMode()!==a.Background){return;}var $=q(this._oImage);if(!this._oImage){this._oImage=new window.Image();$=q(this._oImage);$.on("load",q.proxy(this.onload,this)).on("error",q.proxy(this.onerror,this));}this._oImage.src=s;};
b.prototype._isWidthOrHeightSet=function(){return(this.getWidth()&&this.getWidth()!=='')||(this.getHeight()&&this.getHeight()!=='');};
b.prototype._getDensityAwareSrc=function(){var s=this.getSrc(),c=this.getDensityAware(),d=c?b._currentDevicePixelRatio:1;this._iLoadImageDensity=d;return this._generateSrcByDensity(s,d);};
b.prototype._getDensityAwareActiveSrc=function(){var A=this.getActiveSrc(),c=this.getDensityAware(),d=c?b._currentDevicePixelRatio:1;this._iLoadImageDensity=d;return this._generateSrcByDensity(A,d);};
b.prototype._generateSrcByDensity=function(s,d){if(!s){return"";}if(this._isDataUri(s)){this._iLoadImageDensity=1;return s;}if(d===1){return s;}var L=s.lastIndexOf("."),c=s.lastIndexOf("/"),N=s.substring(0,L),E=s.substring(L);if(L===-1||(c>L)){return s+"@"+d;}N=N+"@"+d;return N+E;};
b.prototype._isDataUri=function(s){return s?s.indexOf("data:")===0:false;};
b.prototype._isValidBackgroundSizeValue=function(v){v=n(v);return i(v.split(" "),["auto","cover","contain","initial"])||D.getType("sap.ui.core.CSSSizeShortHand").isValid(v);};
b.prototype._isValidBackgroundPositionValue=function(v){v=n(v);return i(v.split(" "),["left","right","top","center","bottom","initial"])||D.getType("sap.ui.core.CSSSizeShortHand").isValid(v);};
b.prototype.getAccessibilityInfo=function(){var h=this.hasListeners("press");if(this.getDecorative()&&!this.getUseMap()&&!h){return null;}return{role:h?"button":"img",type:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText(h?"ACC_CTR_TYPE_BUTTON":"ACC_CTR_TYPE_IMAGE"),description:this.getAlt()||this.getTooltip_AsString()||"",focusable:h};};
b.prototype.getFocusDomRef=function(){return this.getDomRef("inner")||this.getDomRef();};
b.prototype.getFormDoNotAdjustWidth=function(){return true;};
function i(t,r){function c(T){return r.indexOf(T)<0;}return t&&r&&!t.some(c);}
function n(v){var w=/\s+/g;return v==null?"":String(v).trim().replace(w," ");}
return b;});
sap.ui.predefine('sap/m/ImageContent',['./library','sap/ui/core/Control','sap/m/Image','sap/ui/core/IconPool','sap/ui/Device','./ImageContentRenderer',"sap/ui/events/KeyCodes"],function(l,C,I,a,D,b,K){"use strict";
var c=C.extend("sap.m.ImageContent",{metadata:{library:"sap.m",properties:{src:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},description:{type:"string",group:"Accessibility",defaultValue:null}},defaultAggregation:"_content",aggregations:{_content:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{press:{}}}});
c.prototype.onBeforeRendering=function(){var i,u,d;i=this.getAggregation("_content");u=this.getSrc();d=this.getDescription();if(!i||u!==i.getSrc()||d!==i.getAlt()){if(i){i.destroy();i=null;}i=a.createControlByURI({id:this.getId()+"-icon-image",src:u,alt:d,decorative:true},I);this.setAggregation("_content",i,true);this._setPointerOnImage();}if(d){this.setTooltip(d.trim());}};
c.prototype._setPointerOnImage=function(){var i=this.getAggregation("_content");if(i&&this.hasListeners("press")){i.addStyleClass("sapMPointer");}else if(i&&i.hasStyleClass("sapMPointer")){i.removeStyleClass("sapMPointer");}};
c.prototype.ontap=function(e){if(D.browser.msie){this.$().trigger("focus");}this.firePress();};
c.prototype.onkeydown=function(e){if(e.which===K.ENTER||e.which===K.SPACE){this.firePress();e.preventDefault();}};
c.prototype.attachEvent=function(e,d,f,g){C.prototype.attachEvent.call(this,e,d,f,g);if(this.hasListeners("press")){this.$().attr("tabindex",0).addClass("sapMPointer");this._setPointerOnImage();}return this;};
c.prototype.detachEvent=function(e,f,d){C.prototype.detachEvent.call(this,e,f,d);if(!this.hasListeners("press")){this.$().removeAttr("tabindex").removeClass("sapMPointer");this._setPointerOnImage();}return this;};
c.prototype.getAltText=function(){var o=this.getAggregation("_content");if(o&&o.getAlt()!==""){return o.getAlt();}else if(o&&o.getAccessibilityInfo()){return o.getAccessibilityInfo().description;}else{return"";}};
return c;});
sap.ui.predefine('sap/m/ImageContentRenderer',[],function(){"use strict";var I={apiVersion:2};
I.render=function(r,c){r.openStart("div",c);r.class("sapMImageContent");var t=c.getTooltip_AsString();if(t){r.attr("title",t);}if(c.hasListeners("press")){r.class("sapMPointer");r.attr("tabindex","0");}r.openEnd();var C=c.getAggregation("_content");if(C){C.addStyleClass("sapMImageContentImageIcon");r.renderControl(C);}r.close("div");};
return I;},true);
sap.ui.predefine('sap/m/ImageRenderer',['sap/m/library',"sap/base/security/encodeCSS"],function(l,e){"use strict";var I=l.ImageMode;var a={apiVersion:2};
a.render=function(r,i){var m=i.getMode(),b=i.getAlt(),t=i.getTooltip_AsString(),h=i.hasListeners("press"),L=i.getDetailBox(),u=i.getUseMap(),c=i.getAriaLabelledBy(),d=i.getAriaDescribedBy(),D=i.getAriaDetails(),f=m===I.Image;if(L){r.openStart("span",i);r.class("sapMLightBoxImage");r.openEnd();r.openStart("span").class("sapMLightBoxMagnifyingGlass").openEnd().close("span");}if(f){r.voidStart("img",!L?i:i.getId()+"-inner");}else{r.openStart("span",!L?i:i.getId()+"-inner");}if(!i.getDecorative()){if(c&&c.length>0){r.attr("aria-labelledby",c.join(" "));}if(d&&d.length>0){r.attr("aria-describedby",d.join(" "));}if(D&&D.length>0){r.attr("aria-details",D.join(" "));}}if(f){r.attr("src",i._getDensityAwareSrc());}else{i._preLoadImage(i._getDensityAwareSrc());if(i._isValidBackgroundSizeValue(i.getBackgroundSize())){r.style("background-size",i.getBackgroundSize());}if(i._isValidBackgroundPositionValue(i.getBackgroundPosition())){r.style("background-position",i.getBackgroundPosition());}r.style("background-repeat",e(i.getBackgroundRepeat()));}r.class("sapMImg");if(i.hasListeners("press")||i.hasListeners("tap")){r.class("sapMPointer");}if(u||!i.getDecorative()||h){r.class("sapMImgFocusable");}if(u){if(!(u.startsWith("#"))){u="#"+u;}r.attr("usemap",u);}if(i.getDecorative()&&!u&&!h){r.attr("role","presentation");r.attr("aria-hidden","true");r.attr("alt","");}else if(b||t){r.attr("alt",b||t);}if(b||t){r.attr("aria-label",b||t);}if(t){r.attr("title",t);}if(h){r.attr("role","button");r.attr("tabindex",0);}r.style("width",i.getWidth());r.style("height",i.getHeight());f?r.voidEnd():r.openEnd().close("span");if(L){r.close("span");}};
return a;},true);
sap.ui.predefine('sap/m/Input',['./InputBase','./Popover','sap/ui/core/Item','./ColumnListItem','./GroupHeaderListItem','./StandardListItem','sap/ui/core/SeparatorItem','./List','./Table','./library','sap/ui/core/IconPool','sap/ui/Device','sap/ui/core/Control','./SuggestionsPopover','./Toolbar','./ToolbarSpacer','./Button',"sap/ui/dom/containsOrEquals","sap/base/assert","sap/base/util/deepEqual","sap/m/inputUtils/wordStartsWithValue","sap/m/inputUtils/inputsDefaultFilter","sap/m/inputUtils/highlightDOMElements","./InputRenderer","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/selectText"],function(I,P,a,C,G,S,b,L,T,l,c,D,d,e,f,g,B,h,j,k,w,m,n,o,q){"use strict";var p=l.ListType;var r=l.InputTextFormatMode;var s=l.InputType;var t=l.ListMode;var u=l.ListSeparators;
var v=I.extend("sap.m.Input",{metadata:{library:"sap.m",properties:{type:{type:"sap.m.InputType",group:"Data",defaultValue:s.Text},maxLength:{type:"int",group:"Behavior",defaultValue:0},dateFormat:{type:"string",group:"Misc",defaultValue:'YYYY-MM-dd',deprecated:true},showValueHelp:{type:"boolean",group:"Behavior",defaultValue:false},valueHelpIconSrc:{type:"sap.ui.core.URI",group:"Behavior",defaultValue:"sap-icon://value-help"},showSuggestion:{type:"boolean",group:"Behavior",defaultValue:false},valueHelpOnly:{type:"boolean",group:"Behavior",defaultValue:false},filterSuggests:{type:"boolean",group:"Behavior",defaultValue:true},maxSuggestionWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},startSuggestion:{type:"int",group:"Behavior",defaultValue:1},showTableSuggestionValueHelp:{type:"boolean",group:"Behavior",defaultValue:true},description:{type:"string",group:"Misc",defaultValue:null},fieldWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:'50%'},valueLiveUpdate:{type:"boolean",group:"Behavior",defaultValue:false},selectedKey:{type:"string",group:"Data",defaultValue:""},textFormatMode:{type:"sap.m.InputTextFormatMode",group:"Misc",defaultValue:r.Value},textFormatter:{type:"any",group:"Misc",defaultValue:""},suggestionRowValidator:{type:"any",group:"Misc",defaultValue:""},enableSuggestionsHighlighting:{type:"boolean",group:"Behavior",defaultValue:true},autocomplete:{type:"boolean",group:"Behavior",defaultValue:true}},defaultAggregation:"suggestionItems",aggregations:{suggestionItems:{type:"sap.ui.core.Item",multiple:true,singularName:"suggestionItem"},suggestionColumns:{type:"sap.m.Column",multiple:true,singularName:"suggestionColumn",bindable:"bindable",forwarding:{getter:"_getSuggestionsTable",aggregation:"columns"}},suggestionRows:{type:"sap.m.ColumnListItem",altTypes:["sap.m.GroupHeaderListItem"],multiple:true,singularName:"suggestionRow",bindable:"bindable",forwarding:{getter:"_getSuggestionsTable",aggregation:"items"}},_suggestionPopup:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_valueHelpIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},associations:{selectedItem:{type:"sap.ui.core.Item",multiple:false},selectedRow:{type:"sap.m.ColumnListItem",multiple:false}},events:{liveChange:{parameters:{value:{type:"string"},escPressed:{type:"boolean"},previousValue:{type:"string"}}},valueHelpRequest:{parameters:{fromSuggestions:{type:"boolean"}}},suggest:{parameters:{suggestValue:{type:"string"},suggestionColumns:{type:"sap.m.ListBase"}}},suggestionItemSelected:{parameters:{selectedItem:{type:"sap.ui.core.Item"},selectedRow:{type:"sap.m.ColumnListItem"}}},submit:{parameters:{value:{type:"string"}}}},designtime:"sap/m/designtime/Input.designtime"}});
c.insertFontFaceStyle();
v._DEFAULTFILTER_TABULAR=function(V,x){var y=x.getCells(),i=0;for(;i<y.length;i++){if(y[i].getText){if(w(y[i].getText(),V)){return true;}}}return false;};
v._DEFAULTRESULT_TABULAR=function(x){var y=x.getCells(),i=0;for(;i<y.length;i++){if(y[i].getText){return y[i].getText();}}return"";};
v.prototype.init=function(){I.prototype.init.call(this);this._fnFilter=m;this._bFullScreen=D.system.phone;this._iSetCount=0;this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");};
v.prototype.exit=function(){I.prototype.exit.call(this);this._deregisterEvents();this.cancelPendingSuggest();if(this._iRefreshListTimeout){clearTimeout(this._iRefreshListTimeout);this._iRefreshListTimeout=null;}if(this._oSuggestionTable){this._oSuggestionTable.destroy();this._oSuggestionTable=null;}if(this._oSuggPopover){this._oSuggPopover.destroy();this._oSuggPopover=null;}if(this._oShowMoreButton){this._oShowMoreButton.destroy();this._oShowMoreButton=null;}if(this._oButtonToolbar){this._oButtonToolbar.destroy();this._oButtonToolbar=null;}this.$().off("click");};
v.prototype.onBeforeRendering=function(){var i=this.getSelectedKey(),x=this.getShowValueHelp()&&this.getEnabled()&&this.getEditable(),E=this.getAggregation("_endIcon")||[],y=E[0],z,A=this._isSuggestionsPopoverOpen(),V=A?this._oSuggPopover._getValueStateHeader().getText():null,F=A?this._oSuggPopover._getValueStateHeader().getValueState():"";I.prototype.onBeforeRendering.call(this);this._deregisterEvents();if(i){this.setSelectedKey(i);}if(this.getShowSuggestion()){this._oSuggPopover._bAutocompleteEnabled=this.getAutocomplete();if(this.getShowTableSuggestionValueHelp()){this._addShowMoreButton();}else{this._removeShowMoreButton();}z=this._oSuggPopover._oPopupInput;if(z){z.setType(this.getType());}}if(x){y=this._getValueHelpIcon();y.setProperty("visible",true,true);}else if(y){y.setProperty("visible",false,true);}if(!this.getWidth()){this.setProperty("width","100%",true);}if(this._oSuggPopover){this._oSuggPopover._resetTypeAhead();}if(A&&((this.getValueStateText()&&V!==this.getValueStateText())||(this.getValueState()!==F)||(this.getFormattedValueStateText()))){this._updateSuggestionsPopoverValueState();}};
v.prototype._getDisplayText=function(i){var x=this.getTextFormatter();if(x){return x(i);}var y=i.getText(),K=i.getKey(),z=this.getTextFormatMode();switch(z){case r.Key:return K;case r.ValueKey:return y+' ('+K+')';case r.KeyValue:return'('+K+') '+y;default:return y;}};
v.prototype._onValueUpdated=function(i){if(this._bSelectingItem||i===this._sSelectedValue){return;}var K=this.getSelectedKey(),H;if(K===''){return;}if(this._hasTabularSuggestions()){H=this._oSuggestionTable&&!!this._oSuggestionTable.getSelectedItem();}else{H=this._oSuggPopover._oList&&!!this._oSuggPopover._oList.getSelectedItem();}if(H){return;}this.setProperty("selectedKey",'',true);this.setAssociation("selectedRow",null,true);this.setAssociation("selectedItem",null,true);this.fireSuggestionItemSelected({selectedItem:null,selectedRow:null});};
v.prototype._updateSelectionFromList=function(){if(this._oSuggPopover._iPopupListSelectedIndex<0){return false;}var i=this._oSuggPopover._oList.getSelectedItem();if(i){if(this._hasTabularSuggestions()){this.setSelectionRow(i,true);}else{this.setSelectionItem(i._oItem,true);}}return true;};
v.prototype.setSelectionItem=function(i,x){this._bSelectingItem=true;if(!i){this.setAssociation("selectedItem",null,true);this.setValue('');return;}this._oSuggPopover._iPopupListSelectedIndex=-1;var y=this._iSetCount,N;this.setAssociation("selectedItem",i,true);this.setProperty("selectedKey",i.getKey(),true);if(x){this.fireSuggestionItemSelected({selectedItem:i});}if(y!==this._iSetCount){N=this.getValue();}else{N=this._getDisplayText(i);}this._sSelectedValue=N;this.updateInputField(N);if(this.bIsDestroyed){return;}if(!(this.isMobileDevice()&&this instanceof sap.m.MultiInput)){this._closeSuggestionPopup();}this._bSelectingItem=false;};
v.prototype.addSuggestionRowGroup=function(i,H,x){H=H||new G({title:i.text||i.key});this.addAggregation("suggestionRows",H,x);return H;};
v.prototype.addSuggestionItemGroup=function(i,H,x){H=H||new b({text:i.text||i.key});this.addAggregation("suggestionItems",H,x);return H;};
v.prototype.setSelectedItem=function(i){if(typeof i==="string"){i=sap.ui.getCore().byId(i);}if(i!==null&&!(i instanceof a)){return this;}this.setSelectionItem(i);return this;};
v.prototype.setSelectedKey=function(K){K=this.validateProperty("selectedKey",K);this.setProperty("selectedKey",K,true);if(this._hasTabularSuggestions()){return this;}if(!K){this.setSelectionItem();return this;}var i=this.getSuggestionItemByKey(K);this.setSelectionItem(i);return this;};
v.prototype.getSuggestionItemByKey=function(K){var x=this.getSuggestionItems()||[],y,i;for(i=0;i<x.length;i++){y=x[i];if(y.getKey()===K){return y;}}};
v.prototype._getFormattedValueStateText=function(){var i=this._isSuggestionsPopoverOpen(),V=i?this._oSuggPopover._getValueStateHeader().getFormattedText():null;if(i&&V){return V;}else{return I.prototype.getFormattedValueStateText.call(this);}};
v.prototype.setSelectionRow=function(i,x){if(!i){this.setAssociation("selectedRow",null,true);return;}this._oSuggPopover._iPopupListSelectedIndex=-1;this._bSelectingItem=true;var y,z=this.getSuggestionRowValidator();if(z){y=z(i);if(!(y instanceof a)){y=null;}}var A=this._iSetCount,K="",N;this.setAssociation("selectedRow",i,true);if(y){K=y.getKey();}this.setProperty("selectedKey",K,true);if(x){this.fireSuggestionItemSelected({selectedRow:i});}if(A!==this._iSetCount){N=this.getValue();}else{if(y){N=this._getDisplayText(y);}else{N=this._fnRowResultFilter?this._fnRowResultFilter(i):e._DEFAULTRESULT_TABULAR(i);}}this._sSelectedValue=N;this.updateInputField(N);if(this.bIsDestroyed){return;}if(!(this.isMobileDevice()&&this instanceof sap.m.MultiInput&&this._isMultiLineMode)){this._closeSuggestionPopup();}this._bSelectingItem=false;};
v.prototype.setSelectedRow=function(i){if(typeof i==="string"){i=sap.ui.getCore().byId(i);}if(i!==null&&!(i instanceof C)){return this;}this.setSelectionRow(i);return this;};
v.prototype._getValueHelpIcon=function(){var i=this,E=this.getAggregation("_endIcon")||[],x=this.getValueHelpIconSrc(),V=E[0];if(!V){V=this.addEndIcon({id:this.getId()+"-vhi",src:x,useIconTooltip:false,alt:this._oRb.getText("INPUT_VALUEHELP_BUTTON"),decorative:false,noTabStop:true,press:function(y){if(!i.getValueHelpOnly()){var z=this.getParent(),$;if(D.support.touch){$=z.$('inner');$.attr('readonly','readonly');z.focus();$.removeAttr('readonly');}else{z.focus();}i.bValueHelpRequested=true;i._fireValueHelpRequest(false);}}});}else if(V.getSrc()!==x){V.setSrc(x);}return V;};
v.prototype._fireValueHelpRequest=function(F){var i="";if(this.getShowSuggestion()&&this._oSuggPopover){i=this._oSuggPopover._sTypedInValue||"";}else{i=this.getDOMValue();}this.fireValueHelpRequest({fromSuggestions:F,_userInputValue:i});};
v.prototype._fireValueHelpRequestForValueHelpOnly=function(){if(this.getEnabled()&&this.getEditable()&&this.getShowValueHelp()&&this.getValueHelpOnly()){if(D.system.phone){this.focus();}this._fireValueHelpRequest(false);}};
v.prototype.ontap=function(E){I.prototype.ontap.call(this,E);if(this.isValueHelpOnlyOpener(E.target)){this._fireValueHelpRequestForValueHelpOnly();}if(this.isMobileDevice()&&this.getEditable()&&this.getEnabled()&&this.getShowSuggestion()&&this._oSuggPopover&&E.target.id!=this.getId()+"-vhi"){this._openSuggestionsPopover();}};
v.prototype.setFilterFunction=function(F){if(F===null||F===undefined){this._fnFilter=m;return this;}j(typeof(F)==="function","Input.setFilterFunction: first argument fnFilter must be a function on "+this);this._fnFilter=F;return this;};
v.prototype.setRowResultFunction=function(F){var i;if(F===null||F===undefined){this._fnRowResultFilter=e._DEFAULTRESULT_TABULAR;return this;}j(typeof(F)==="function","Input.setRowResultFunction: first argument fnFilter must be a function on "+this);this._fnRowResultFilter=F;i=this.getSelectedRow();if(i){this.setSelectedRow(i);}return this;};
v.prototype.closeSuggestions=function(){this._closeSuggestionPopup();};
v.prototype._doSelect=function(i,E){if(D.support.touch){return;}var x=this._$input[0];if(x){var R=this._$input;x.focus();R.selectText(i?i:0,E?E:R.val().length);}return this;};
v.prototype._isIncrementalType=function(){var i=this.getType();if(i==="Number"||i==="Date"||i==="Datetime"||i==="Month"||i==="Time"||i==="Week"){return true;}return false;};
v.prototype.onsapescape=function(E){var i;if(this._isSuggestionsPopoverOpen()){E.originalEvent._sapui_handledByControl=true;this._oSuggPopover._iPopupListSelectedIndex=-1;this._closeSuggestionPopup();if(this._sBeforeSuggest!==undefined){if(this._sBeforeSuggest!==this.getValue()){i=this.getLastValue();this.setValue(this._sBeforeSuggest);this.setLastValue(i);}this._sBeforeSuggest=undefined;}return;}if(this.getValueLiveUpdate()){this.setProperty("value",this.getLastValue(),true);}if(I.prototype.onsapescape){I.prototype.onsapescape.apply(this,arguments);}};
v.prototype.onsapenter=function(E){this.cancelPendingSuggest();if(this._isSuggestionsPopoverOpen()){if(!this._updateSelectionFromList()&&!this.isComposingCharacter()){this._closeSuggestionPopup();}}if(I.prototype.onsapenter){I.prototype.onsapenter.apply(this,arguments);}if(this.getEnabled()&&this.getEditable()&&!(this.getValueHelpOnly()&&this.getShowValueHelp())){this.fireSubmit({value:this.getValue()});}};
v.prototype.onsapfocusleave=function(E){var i=this._oSuggPopover,x=i&&i._oPopover,F=E.relatedControlId&&sap.ui.getCore().byId(E.relatedControlId),y=F&&F.getFocusDomRef(),H=i&&i._sProposedItemText&&this.getAutocomplete(),z=x&&y&&h(x.getDomRef(),y);if(x instanceof P){if(z&&!i.bMessageValueStateActive){this._bPopupHasFocus=true;if(D.system.desktop&&k(x.getFocusDomRef(),y)||F.isA("sap.m.GroupHeaderListItem")){this.focus();}}else{if(this.getDOMValue()===this._sSelectedSuggViaKeyboard){this._sSelectedSuggViaKeyboard=null;}}}if(!z&&!H){I.prototype.onsapfocusleave.apply(this,arguments);}this.bValueHelpRequested=false;};
v.prototype.onmousedown=function(E){if(this._isSuggestionsPopoverOpen()){E.stopPropagation();}};
v.prototype._deregisterEvents=function(){if(this._oSuggPopover){this._oSuggPopover._deregisterResize();}if(this.isMobileDevice()&&this._oSuggPopover&&this._oSuggPopover._oPopover){this.$().off("click");}};
v.prototype.updateSuggestionItems=function(){this._bSuspendInvalidate=true;this.updateAggregation("suggestionItems");this._synchronizeSuggestions();this._bSuspendInvalidate=false;return this;};
v.prototype.invalidate=function(){if(!this._bSuspendInvalidate){d.prototype.invalidate.apply(this,arguments);}};
v.prototype.cancelPendingSuggest=function(){if(this._iSuggestDelay){clearTimeout(this._iSuggestDelay);this._iSuggestDelay=null;}};
v.prototype._triggerSuggest=function(V){this.cancelPendingSuggest();this._bShouldRefreshListItems=true;if(!V){V="";}if(V.length>=this.getStartSuggestion()){this._iSuggestDelay=setTimeout(function(){if(this._sPrevSuggValue!==V){this._bBindingUpdated=false;this.fireSuggest({suggestValue:V});if(!this._bBindingUpdated){this._refreshItemsDelayed();}this._sPrevSuggValue=V;}}.bind(this),300);}else if(this.isMobileDevice()){if(this._oSuggPopover._oList instanceof T){this._oSuggPopover._oList.addStyleClass("sapMInputSuggestionTableHidden");}else if(this._oSuggPopover._oList&&this._oSuggPopover._oList.destroyItems){this._oSuggPopover._oList.destroyItems();}}else if(this._isSuggestionsPopoverOpen()){setTimeout(function(){var N=this.getDOMValue()||'';if(N<this.getStartSuggestion()){this._oSuggPopover._iPopupListSelectedIndex=-1;this._closeSuggestionPopup();}}.bind(this),0);}};
(function(){
v.prototype.setShowSuggestion=function(V){this.setProperty("showSuggestion",V,true);if(V){this._oSuggPopover=this._getSuggestionsPopover();this._oSuggPopover._iPopupListSelectedIndex=-1;if(!this._oSuggPopover._oPopover){this._createSuggestionsPopoverPopup();this._synchronizeSuggestions();this._createSuggestionPopupContent();}}else{if(this._oSuggPopover){this._oSuggPopover._destroySuggestionPopup();this._oSuggPopover._iPopupListSelectedIndex=-1;this._oButtonToolbar=null;this._oShowMoreButton=null;}}return this;};
v.prototype._shouldTriggerSuggest=function(){return!this._bPopupHasFocus&&!this.getStartSuggestion()&&!this.getValue()&&this.getShowSuggestion();};
v.prototype.setShowTableSuggestionValueHelp=function(V){this.setProperty("showTableSuggestionValueHelp",V,true);if(!(this._oSuggPopover&&this._oSuggPopover._oPopover)){return this;}if(V){this._addShowMoreButton();}else{this._removeShowMoreButton();}return this;};
v.prototype.onchange=function(E){if(this.getShowValueHelp()||this.getShowSuggestion()){return;}this.onChange(E);};
v.prototype.oninput=function(E){I.prototype.oninput.call(this,E);if(E.isMarked("invalid")){return;}var V=this.getDOMValue(),i,x,y;if(this.getValueLiveUpdate()){this.setProperty("value",V,true);this._onValueUpdated(V);}this.fireLiveChange({value:V,newValue:V});this.addStyleClass("sapMFocus");if(this.getShowSuggestion()&&!this.isMobileDevice()){i=this._getSuggestionsPopover();x=i._oList;this._triggerSuggest(V);if(x&&!i.bMessageValueStateActive){y=x.getSelectedItem();x.removeStyleClass("sapMListFocus");y&&y.removeStyleClass("sapMLIBFocused");}else if(i.bMessageValueStateActive&&document.activeElement.tagName!=="A"){i._getValueStateHeader().removeStyleClass("sapMPseudoFocus");}}};
v.prototype.getValue=function(){return this.getDomRef("inner")&&this._$input?this.getDOMValue():this.getProperty("value");};
v.prototype._refreshItemsDelayed=function(){clearTimeout(this._iRefreshListTimeout);this._iRefreshListTimeout=setTimeout(function(){if(this._oSuggPopover){this._refreshListItems();}}.bind(this),0);};
v.prototype._filterListItems=function(x,y){var i,z,A,E=[],H=[],F=this.getFilterSuggests(),J=false;for(i=0;i<x.length;i++){A=x[i];if(x[i].isA("sap.ui.core.SeparatorItem")){z=new G({id:A.getId()+"-ghli",title:x[i].getText()});E.push({header:z,visible:false});this._configureListItem(A,z);H.push(z);}else if(!F||this._fnFilter(y,A)){z=new S({title:A.getText(),info:A.getAdditionalText&&A.getAdditionalText()});if(!J&&(this._oSuggPopover._sProposedItemText===x[i].getText())){z.setSelected(true);J=true;}if(E.length){E[E.length-1].visible=true;}this._configureListItem(A,z);H.push(z);}}E.forEach(function(K){K.header.setVisible(K.visible);});return{hitItems:H,groups:E};};
v.prototype._filterTabularItems=function(x,y){var i,z,F=this.getFilterSuggests(),H=[],A=[],E=false;for(i=0;i<x.length;i++){if(x[i].isA("sap.m.GroupHeaderListItem")){A.push({header:x[i],visible:false});}else{z=!F||this._fnFilter(y,x[i]);x[i].setVisible(z);z&&H.push(x[i]);if(!E&&z&&this._oSuggPopover._sProposedItemText===this._fnRowResultFilter(x[i])){x[i].setSelected(true);E=true;}if(A.length&&z){A[A.length-1].visible=true;}}}A.forEach(function(J){J.header.setVisible(J.visible);});this._getSuggestionsTable().invalidate();return{hitItems:H,groups:A};};
v.prototype._clearSuggestionPopupItems=function(){if(!this._oSuggPopover._oList){return;}if(this._oSuggPopover._oList instanceof T){this._oSuggPopover._oList.removeSelections(true);}else{this._oSuggPopover._oList.destroyItems();}};
v.prototype._hideSuggestionPopup=function(){var i=this._oSuggPopover._oPopover;function x(){if(D.browser.internet_explorer){var F=this.getFocusInfo();this.setDOMValue(this._oSuggPopover._sTypedInValue);this.applyFocusInfo(F);}else{this.setDOMValue(this._oSuggPopover._sTypedInValue);}}if(!this.isMobileDevice()){if(this._isSuggestionsPopoverOpen()){this._sCloseTimer=setTimeout(function(){if(this._oSuggPopover){this._oSuggPopover._iPopupListSelectedIndex=-1;}this.cancelPendingSuggest();if(this._oSuggPopover._sTypedInValue){x.call(this);}this._oSuggPopover._oProposedItem=null;i.close();}.bind(this),0);}}else if(this._hasTabularSuggestions()&&this._oSuggPopover._oList){this._oSuggPopover._oList.addStyleClass("sapMInputSuggestionTableHidden");}this.$("SuggDescr").text("");this.$("inner").removeAttr("aria-activedescendant");};
v.prototype._openSuggestionPopup=function(O){if(!this.isMobileDevice()){if(this._sCloseTimer){clearTimeout(this._sCloseTimer);this._sCloseTimer=null;}if(!this._isSuggestionsPopoverOpen()&&!this._sOpenTimer&&O!==false){this._sOpenTimer=setTimeout(function(){this._sOpenTimer=null;this._oSuggPopover&&this._openSuggestionsPopover();}.bind(this),0);}}};
v.prototype._getFilteredSuggestionItems=function(i){var F,x=this.getSuggestionItems(),y=this.getSuggestionRows();if(this._hasTabularSuggestions()){if(this.isMobileDevice()&&this._oSuggPopover._oList){this._oSuggPopover._oList.removeStyleClass("sapMInputSuggestionTableHidden");}F=this._filterTabularItems(y,i);}else{F=this._filterListItems(x,i);}return F;};
v.prototype._fillSimpleSuggestionPopupItems=function(F){var i,H=F.hitItems,x=F.groups,y=H.length,z=y;if(!this._hasTabularSuggestions()){for(i=0;i<y;i++){this._oSuggPopover._oList.addItem(H[i]);}z-=x.length;}return z;};
v.prototype._applySuggestionAcc=function(N){var A="",R=this._oRb;if(N===1){A=R.getText("INPUT_SUGGESTIONS_ONE_HIT");}else if(N>1){A=R.getText("INPUT_SUGGESTIONS_MORE_HITS",N);}else{A=R.getText("INPUT_SUGGESTIONS_NO_HIT");}this.$("SuggDescr").text(A);};
v.prototype._refreshListItems=function(){var i=this.getShowSuggestion(),x=this._oSuggPopover._sTypedInValue||this.getDOMValue()||"",F,y;this._oSuggPopover._iPopupListSelectedIndex=-1;if(!i||!this._bShouldRefreshListItems||!this.getDomRef()||(!this.isMobileDevice()&&!this.$().hasClass("sapMInputFocused"))){return null;}this._clearSuggestionPopupItems();if(x.length<this.getStartSuggestion()){this._hideSuggestionPopup();return false;}F=this._getFilteredSuggestionItems(x);y=this._fillSimpleSuggestionPopupItems(F);if(y>0){this._openSuggestionPopup(this.getValue().length>=this.getStartSuggestion());}else{this._hideSuggestionPopup();}this._applySuggestionAcc(y);};
v.prototype._configureListItem=function(i,x){var y=p.Active;if(!i.getEnabled()||x.isA("sap.m.GroupHeaderListItem")){y=p.Inactive;}x.setType(y);x._oItem=i;x.addEventDelegate({ontouchstart:function(E){(E.originalEvent||E)._sapui_cancelAutoClose=true;}});return x;};
v.prototype.addSuggestionItem=function(i){this.addAggregation("suggestionItems",i,true);if(!this._oSuggPopover){this._getSuggestionsPopover();}this._synchronizeSuggestions();this._createSuggestionPopupContent();return this;};
v.prototype.insertSuggestionItem=function(i,x){this.insertAggregation("suggestionItems",x,i,true);if(!this._oSuggPopover){this._getSuggestionsPopover();}this._synchronizeSuggestions();this._createSuggestionPopupContent();return this;};
v.prototype.removeSuggestionItem=function(i){var x=this.removeAggregation("suggestionItems",i,true);this._synchronizeSuggestions();return x;};
v.prototype.removeAllSuggestionItems=function(){var i=this.removeAllAggregation("suggestionItems",true);this._synchronizeSuggestions();return i;};
v.prototype.destroySuggestionItems=function(){this.destroyAggregation("suggestionItems",true);this._synchronizeSuggestions();return this;};
v.prototype.addSuggestionRow=function(i){i.setType(p.Active);this.addAggregation("suggestionRows",i);this._synchronizeSuggestions();this._createSuggestionPopupContent(true);return this;};
v.prototype.insertSuggestionRow=function(i,x){i.setType(p.Active);this.insertAggregation("suggestionRows",i,x);this._synchronizeSuggestions();this._createSuggestionPopupContent(true);return this;};
v.prototype.removeSuggestionRow=function(i){var x=this.removeAggregation("suggestionRows",i);this._synchronizeSuggestions();return x;};
v.prototype.removeAllSuggestionRows=function(){var i=this.removeAllAggregation("suggestionRows");this._synchronizeSuggestions();return i;};
v.prototype.destroySuggestionRows=function(){this.destroyAggregation("suggestionRows");this._synchronizeSuggestions();return this;};
v.prototype.bindAggregation=function(){if(arguments[0]==="suggestionRows"||arguments[0]==="suggestionColumns"||arguments[0]==="suggestionItems"){this._createSuggestionPopupContent(arguments[0]==="suggestionRows"||arguments[0]==="suggestionColumns");this._bBindingUpdated=true;}return I.prototype.bindAggregation.apply(this,arguments);};
v.prototype._closeSuggestionPopup=function(){if(this._isSuggestionsPopoverOpen()){this.cancelPendingSuggest();this._oSuggPopover._oPopover.close();if(!this.isMobileDevice()&&this.$().hasClass("sapMInputFocused")){this.openValueStateMessage();}this.$("SuggDescr").text("");this.$("inner").removeAttr("aria-activedescendant");this._sPrevSuggValue=null;}};
v.prototype._synchronizeSuggestions=function(){if(document.activeElement===this.getFocusDomRef()){this._bShouldRefreshListItems=true;this._refreshItemsDelayed();}if(!this.getDomRef()||this._isSuggestionsPopoverOpen()){return;}this._synchronizeSelection();};
v.prototype._synchronizeSelection=function(){var i=this.getSelectedKey();if(!i){return;}if(this.getValue()&&!this.getSelectedItem()&&!this.getSelectedRow()){return;}this.setSelectedKey(i);};
})();
v.prototype.onfocusin=function(E){I.prototype.onfocusin.apply(this,arguments);this.addStyleClass("sapMInputFocused");if(!this.isMobileDevice()&&this._isSuggestionsPopoverOpen()){this.closeValueStateMessage();}if(this._shouldTriggerSuggest()){this._triggerSuggest(this.getValue());}this._bPopupHasFocus=undefined;this._sPrevSuggValue=null;};
v.prototype.oncompositionend=function(E){I.prototype.oncompositionend.apply(this,arguments);if(this._oSuggPopover&&!D.browser.edge&&!D.browser.firefox){this._oSuggPopover._handleTypeAhead();}};
v.prototype.onsapshow=function(E){if(!this.getEnabled()||!this.getEditable()||!this.getShowValueHelp()){return;}this.bValueHelpRequested=true;this._fireValueHelpRequest(false);E.preventDefault();E.stopPropagation();};
v.prototype.onsaphide=v.prototype.onsapshow;
v.prototype.onsapselect=function(E){this._fireValueHelpRequestForValueHelpOnly();};
v.prototype.onfocusout=function(E){I.prototype.onfocusout.apply(this,arguments);this.removeStyleClass("sapMInputFocused");this.$("SuggDescr").text("");};
v.prototype._hasTabularSuggestions=function(){return!!(this.getAggregation("suggestionColumns")&&this.getAggregation("suggestionColumns").length);};
v.prototype._getSuggestionsTable=function(){if(this._bIsBeingDestroyed){return this._oSuggestionTable;}if(!this._oSuggestionTable){this._oSuggestionTable=new T(this.getId()+"-popup-table",{mode:t.SingleSelectMaster,showNoData:false,showSeparators:u.None,width:"100%",enableBusyIndicator:false,rememberSelections:false,itemPress:function(E){if(D.system.desktop){this.focus();}this._oSuggPopover._bSuggestionItemTapped=true;var i=E.getParameter("listItem");this.setSelectionRow(i,true);}.bind(this),sticky:[l.Sticky.ColumnHeaders]});this._oSuggestionTable.addEventDelegate({onAfterRendering:function(){var i,x;if(!this.getEnableSuggestionsHighlighting()){return;}i=this._oSuggestionTable.$().find('tbody .sapMLabel');x=(this._sTypedInValue||this.getValue()).toLowerCase();n(i,x);}.bind(this)});if(this.isMobileDevice()){this._oSuggestionTable.addStyleClass("sapMInputSuggestionTableHidden");}this._oSuggestionTable.updateItems=function(){T.prototype.updateItems.apply(this,arguments);this._refreshItemsDelayed();return this;};}return this._oSuggestionTable;};
v.prototype.clone=function(){var i=d.prototype.clone.apply(this,arguments);i.setRowResultFunction(this._fnRowResultFilter);i.setValue(this.getValue());return i;};
v.prototype.setValue=function(V){this._iSetCount++;I.prototype.setValue.call(this,V);this._onValueUpdated(V);return this;};
v.prototype.setDOMValue=function(i){this._$input.val(i);};
v.prototype.getDOMValue=function(){return this._$input.val();};
v.prototype.updateInputField=function(N){if(this._isSuggestionsPopoverOpen()&&this.isMobileDevice()){this._oSuggPopover._oPopupInput.setValue(N);this._oSuggPopover._oPopupInput._doSelect();}else{N=this._getInputValue(N);this.setDOMValue(N);this.onChange(null,null,N);}};
v.prototype.getAccessibilityInfo=function(){var i=I.prototype.getAccessibilityInfo.apply(this,arguments);i.description=((i.description||"")+" "+this.getDescription()).trim();return i;};
v.prototype.preventChangeOnFocusLeave=function(E){return this.bFocusoutDueRendering||this.bValueHelpRequested;};
v.prototype._getShowMoreButton=function(){return this._oShowMoreButton||(this._oShowMoreButton=new B({text:this._oRb.getText("INPUT_SUGGESTIONS_SHOW_ALL"),press:this._getShowMoreButtonPress.bind(this)}));};
v.prototype._getShowMoreButtonPress=function(){var i;if(this.getShowTableSuggestionValueHelp()){if(this._oSuggPopover._sTypedInValue){i=this._oSuggPopover._sTypedInValue;this.updateDomValue(i);this._oSuggPopover._resetTypeAhead();this._oSuggPopover._sTypedInValue=i;}this._fireValueHelpRequest(true);this._oSuggPopover._iPopupListSelectedIndex=-1;this._closeSuggestionPopup();}};
v.prototype._addShowMoreButton=function(i){var x=this._oSuggPopover&&this._oSuggPopover._oPopover;if(!x||!i&&!this._hasTabularSuggestions()){return;}if(x.isA("sap.m.Dialog")){var y=this._getShowMoreButton();x.setEndButton(y);}else{var z=this._getButtonToolbar();x.setFooter(z);}};
v.prototype._removeShowMoreButton=function(){var i=this._oSuggPopover&&this._oSuggPopover._oPopover;if(!i||!this._hasTabularSuggestions()){return;}if(i.isA("sap.m.Dialog")){i.setEndButton(null);}else{i.setFooter(null);}};
v.prototype._getButtonToolbar=function(){var i=this._getShowMoreButton();return this._oButtonToolbar||(this._oButtonToolbar=new f({content:[new g(),i]}));};
v.prototype._hasShowSelectedButton=function(){return false;};
v.prototype._createSuggestionPopupContent=function(i){if(this._bIsBeingDestroyed||this._getSuggestionsPopover()._oList){return;}this._oSuggPopover._createSuggestionPopupContent(i);if(!this._hasTabularSuggestions()&&!i){this._oSuggPopover._oList.attachItemPress(function(E){if(D.system.desktop){this.focus();}var x=E.getParameter("listItem");if(!x.isA("sap.m.GroupHeaderListItem")){this._oSuggPopover._bSuggestionItemTapped=true;this.setSelectionItem(x._oItem,true);}},this);}else{if(this._fnFilter===m){this._fnFilter=v._DEFAULTFILTER_TABULAR;}if(!this._fnRowResultFilter){this._fnRowResultFilter=v._DEFAULTRESULT_TABULAR;}if(this.getShowTableSuggestionValueHelp()){this._addShowMoreButton(i);}}};
v.prototype._createPopupInput=function(){var i=new v(this.getId()+"-popup-input",{width:"100%",valueLiveUpdate:true,showValueStateMessage:false,valueState:this.getValueState(),showValueHelp:this.getShowValueHelp(),valueHelpRequest:function(E){this.fireValueHelpRequest({fromSuggestions:true});this._oSuggPopover._iPopupListSelectedIndex=-1;this._closeSuggestionPopup();}.bind(this),liveChange:function(E){var V=E.getParameter("newValue");this.setDOMValue(this._getInputValue(this._oSuggPopover._oPopupInput.getValue()));this._triggerSuggest(V);this.fireLiveChange({value:V,newValue:V});}.bind(this)});return i;};
v.prototype._modifyPopupInput=function(i){i.addEventDelegate({onsapenter:function(){if(this.getAutocomplete()){this._oSuggPopover._finalizeAutocomplete();}this._closeSuggestionPopup();}},this);return i;};
v.prototype.forwardEventHandlersToSuggPopover=function(i){i.setOkPressHandler(this._closeSuggestionPopup.bind(this));i.setCancelPressHandler(this._closeSuggestionPopup.bind(this));};
v.prototype._getSuggestionsPopover=function(){if(!this._oSuggPopover){var i=this._oSuggPopover=new e(this);if(this.isMobileDevice()){var x=this._createPopupInput();i._oPopupInput=this._modifyPopupInput(x);}this._oSuggPopover.setInputLabels(this.getLabels.bind(this));this._createSuggestionsPopoverPopup();this.forwardEventHandlersToSuggPopover(i);i._bAutocompleteEnabled=this.getAutocomplete();i.attachEvent(e.M_EVENTS.SELECTION_CHANGE,function(E){var N=E.getParameter("newValue");this.setDOMValue(N);this._sSelectedSuggViaKeyboard=N;this._doSelect();},this);if(this.getShowTableSuggestionValueHelp()){this._addShowMoreButton();}}return this._oSuggPopover;};
v.prototype._createSuggestionsPopoverPopup=function(){if(!this._oSuggPopover){return;}var i=this._oSuggPopover;var x;i._createSuggestionPopup({showSelectedButton:this._hasShowSelectedButton()});x=i._oPopover;x.attachBeforeOpen(function(){this._updateSuggestionsPopoverValueState();},this);x.attachBeforeClose(function(){this._updateSuggestionsPopoverValueState();},this);if(this.isMobileDevice()){x.attachBeforeClose(function(){this.setDOMValue(this._getInputValue(i._oPopupInput.getValue()));this.onChange();},this).attachAfterClose(function(){var y=i._oList;if(!y){return;}if(T&&!(y instanceof T)){y.destroyItems();}else{y.removeSelections(true);}}).attachAfterOpen(function(){this._triggerSuggest(this.getValue());this._refreshListItems();},this).attachBeforeOpen(function(){i._oPopupInput.setPlaceholder(this.getPlaceholder());i._oPopupInput.setMaxLength(this.getMaxLength());i._oPopupInput.setValue(this.getValue());},this);}else{x.attachAfterClose(function(){this._updateSelectionFromList();var y=i._oList,z=y.getSelectedItem();if(!y){return;}if(y instanceof T){z&&z.removeStyleClass("sapMLIBFocused");y.removeSelections(true);}else{y.destroyItems();}i._deregisterResize();},this).attachBeforeOpen(function(){i._sPopoverContentWidth=this.getMaxSuggestionWidth();i._bEnableHighlighting=this.getEnableSuggestionsHighlighting();i._bAutocompleteEnabled=this.getAutocomplete();i._bIsInputIncrementalType=this._isIncrementalType();this._sBeforeSuggest=this.getValue();i._resizePopup();i._registerResize();},this);}this.setAggregation("_suggestionPopup",x);this._oSuggestionPopup=x;};
v.prototype.showItems=function(F){var i,x,y=this._fnFilter;if(!this.getEnabled()||!this.getEditable()){return;}this.setFilterFunction(F||function(){return true;});this._clearSuggestionPopupItems();i=this._getFilteredSuggestionItems(this.getDOMValue());x=this._fillSimpleSuggestionPopupItems(i);if(x>0){this._openSuggestionPopup();}else{this._hideSuggestionPopup();}this._applySuggestionAcc(x);this.setFilterFunction(y);};
v.prototype.shouldValueStateMessageBeOpened=function(){var i=I.prototype.shouldValueStateMessageBeOpened.apply(this,arguments);if(!i||this._isSuggestionsPopoverOpen()){return false;}return true;};
v.prototype._isSuggestionsPopoverOpen=function(){return this._oSuggPopover&&this._oSuggPopover.isOpen();};
v.prototype.isMobileDevice=function(){return D.system.phone;};
v.prototype._openSuggestionsPopover=function(){this.closeValueStateMessage();this._updateSuggestionsPopoverValueState();this._oSuggPopover._oPopover.open();};
v.prototype._updateSuggestionsPopoverValueState=function(){var i=this._oSuggPopover,V=this.getValueState(),N=this.getValueState()!==i._getValueStateHeader().getValueState(),x=this.getFormattedValueStateText(),y=this.getValueStateText();if(!i){return;}if(this._isSuggestionsPopoverOpen()&&!x&&!N){this.setFormattedValueStateText(this._oSuggPopover._getValueStateHeader().getFormattedText());}i.updateValueState(V,(x||y),this.getShowValueStateMessage());if(this.isMobileDevice()){i._oPopupInput.setValueState(V);}};
v.prototype.setShowValueHelp=function(i){this.setProperty("showValueHelp",i);if(this._oSuggPopover&&this._oSuggPopover._oPopupInput){this._oSuggPopover._oPopupInput.setShowValueHelp(i);}return this;};
v.prototype.isValueHelpOnlyOpener=function(i){return true;};
return v;});
sap.ui.predefine('sap/m/InputBase',['./library','sap/ui/core/Control','sap/ui/core/EnabledPropagator','sap/ui/core/IconPool','./delegate/ValueStateMessage','sap/ui/core/message/MessageMixin','sap/ui/core/library','sap/ui/Device','./InputBaseRenderer','sap/base/Log',"sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/cursorPos","sap/ui/dom/jquery/getSelectedText","sap/ui/dom/jquery/selectText"],function(l,C,E,I,V,M,c,D,a,b,K,q){"use strict";var T=c.TextDirection;var d=c.TextAlign;var f=c.ValueState;
var g=C.extend("sap.m.InputBase",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.m",properties:{value:{type:"string",group:"Data",defaultValue:null,bindable:"bindable"},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true},valueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:f.None},name:{type:"string",group:"Misc",defaultValue:null},placeholder:{type:"string",group:"Misc",defaultValue:null},editable:{type:"boolean",group:"Behavior",defaultValue:true},valueStateText:{type:"string",group:"Misc",defaultValue:null},showValueStateMessage:{type:"boolean",group:"Misc",defaultValue:true},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:d.Initial},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit},required:{type:"boolean",group:"Misc",defaultValue:false}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{change:{parameters:{value:{type:"string"}}}},aggregations:{formattedValueStateText:{type:"sap.m.FormattedText",multiple:false,defaultValue:null},_invisibleFormattedValueStateText:{type:"sap.m.FormattedText",multiple:false,visibility:"hidden",defaultValue:null},_endIcon:{type:"sap.ui.core.Icon",multiple:true,visibility:"hidden"},_beginIcon:{type:"sap.ui.core.Icon",multiple:true,visibility:"hidden"}},designtime:"sap/m/designtime/InputBase.designtime"}});
E.call(g.prototype);I.insertFontFaceStyle();M.call(g.prototype);g.ICON_PRESSED_CSS_CLASS="sapMInputBaseIconPressed";g.ICON_CSS_CLASS="sapMInputBaseIcon";g.prototype.bShowLabelAsPlaceholder=!D.support.input.placeholder;
g.prototype.handleInput=function(e){if(this._bIgnoreNextInput||this._bIgnoreNextInputNonASCII){this._bIgnoreNextInput=false;this._bIgnoreNextInputNonASCII=false;e.setMarked("invalid");return;}this._bIgnoreNextInput=false;this._bIgnoreNextInputNonASCII=false;if(!this.getEditable()){e.setMarked("invalid");return;}if(document.activeElement!==e.target&&D.browser.msie&&this.getValue()===this.getLastValue()){e.setMarked("invalid");return;}this._bCheckDomValue=true;};
g.prototype._getPlaceholder=function(){return this.getPlaceholder()||"";};
g.prototype._getInputValue=function(v){v=(v===undefined)?this.$("inner").val()||"":v.toString();if(this.getMaxLength&&this.getMaxLength()>0){v=v.substring(0,this.getMaxLength());}return v;};
g.prototype._getInputElementTagName=function(){if(!this._sInputTagElementName){this._sInputTagElementName=this._$input&&this._$input.get(0)&&this._$input.get(0).tagName;}return this._sInputTagElementName;};
g.prototype.init=function(){this.setLastValue("");this.bRenderingPhase=false;this._oValueStateMessage=new V(this);this._bIsComposingCharacter=false;this.fnCloseValueStateOnClick=function(){this.closeValueStateMessage();};};
g.prototype.oncompositionstart=function(){this._bIsComposingCharacter=true;};
g.prototype.oncompositionend=function(e){this._bIsComposingCharacter=false;if(!D.browser.edge&&!D.browser.firefox){this.handleInput(e);}};
g.prototype.isComposingCharacter=function(){return this._bIsComposingCharacter;};
g.prototype.onBeforeRendering=function(){var F=this.getFormattedValueStateText();var o=F&&F.getHtmlText();var e=this.getAggregation("_invisibleFormattedValueStateText");var h=e&&e.getHtmlText();if(D.browser.msie&&D.browser.version>9&&!/^[\x00-\x7F]*$/.test(this.getValue())){this._bIgnoreNextInputNonASCII=true;this._oDomRefBeforeRendering=this.getDomRef();}if(this._bCheckDomValue&&!this.bRenderingPhase){this._sDomValue=this._getInputValue();}if(F&&o!==h){e&&e.destroy();this.setAggregation("_invisibleFormattedValueStateText",F.clone());}this.bRenderingPhase=true;};
g.prototype.onAfterRendering=function(){var v=this.getValueState();var i=this.getFocusDomRef()===document.activeElement;var e=v===f.None;if(this._bCheckDomValue&&this._sDomValue!==this._getInputValue()){this.$("inner").val(this._sDomValue);}this.$("message").text(this.getValueStateText());this._bIgnoreNextInputNonASCII=this._bIgnoreNextInputNonASCII&&this._oDomRefBeforeRendering!==this.getDomRef();this._bCheckDomValue=false;this.bRenderingPhase=false;if(i){this[e?"closeValueStateMessage":"openValueStateMessage"]();}if(this.getAggregation("_invisibleFormattedValueStateText")){this.getAggregation("_invisibleFormattedValueStateText").getControls().forEach(function(o){o.getDomRef()&&o.getDomRef().setAttribute("tabindex",-1);});}};
g.prototype.exit=function(){if(this._oValueStateMessage){this._oValueStateMessage.destroy();}this._oValueStateMessage=null;this._oDomRefBeforeRendering=null;};
g.prototype.ontouchstart=function(e){e.setMarked();};
g.prototype.onfocusin=function(e){this._bIgnoreNextInput=!this.bShowLabelAsPlaceholder&&D.browser.msie&&D.browser.version>9&&!!this.getPlaceholder()&&!this._getInputValue()&&this._getInputElementTagName()==="INPUT";this.addStyleClass("sapMFocus");this.openValueStateMessage();};
g.prototype.onfocusout=function(e){this.removeStyleClass("sapMFocus");if(!this._bClickOnValueStateLink(e)){this.closeValueStateMessage();}};
g.prototype.onsapfocusleave=function(e){if(!this.preventChangeOnFocusLeave(e)){this.onChange(e);}};
g.prototype.preventChangeOnFocusLeave=function(e){return this.bFocusoutDueRendering;};
g.prototype.getChangeEventParams=function(){return{};};
g.prototype.ontap=function(e){return;};
g.prototype.onChange=function(e,p,n){p=p||this.getChangeEventParams();if(!this.getEditable()||!this.getEnabled()){return;}var v=this._getInputValue(n);if(v!==this.getLastValue()){this.setValue(v);v=this.getValue();this.setLastValue(v);this.fireChangeEvent(v,p);return true;}else{this._bCheckDomValue=false;}};
g.prototype.fireChangeEvent=function(v,p){var o=q.extend({value:v,newValue:v},p);this.fireChange(o);};
g.prototype.onValueRevertedByEscape=function(v,p){this.fireEvent("liveChange",{value:v,escPressed:true,previousValue:p,newValue:v});};
g.prototype.onsapenter=function(e){if((D.browser.safari||D.browser.msie)&&this.isComposingCharacter()){e.setMarked("invalid");return;}this.onChange(e);};
g.prototype.onsapescape=function(e){var v=this._getInputValue();if(v!==this.getLastValue()){e.setMarked();e.preventDefault();this.updateDomValue(this.getLastValue());this.onValueRevertedByEscape(this.getLastValue(),v);}};
g.prototype.oninput=function(e){this.handleInput(e);};
g.prototype.onkeydown=function(e){if(this.getDomRef("inner").getAttribute("readonly")&&e.keyCode==K.BACKSPACE){e.preventDefault();}};
g.prototype.oncut=function(e){};
g.prototype.selectText=function(s,S){this.$("inner").selectText(s,S);return this;};
g.prototype.getSelectedText=function(){return this.$("inner").getSelectedText();};
g.prototype.setProperty=function(p,v,s){if(p=="value"){this._bCheckDomValue=false;}return C.prototype.setProperty.apply(this,arguments);};
g.prototype.getFocusInfo=function(){var F=C.prototype.getFocusInfo.call(this),o=this.getFocusDomRef();q.extend(F,{cursorPos:0,selectionStart:0,selectionEnd:0});if(o){F.cursorPos=q(o).cursorPos();try{F.selectionStart=o.selectionStart;F.selectionEnd=o.selectionEnd;}catch(e){}}return F;};
g.prototype.applyFocusInfo=function(F){C.prototype.applyFocusInfo.call(this,F);this.$("inner").cursorPos(F.cursorPos);this.selectText(F.selectionStart,F.selectionEnd);return this;};
g.prototype.updateDomValue=function(v){var i=this.getFocusDomRef();if(!this.isActive()){return this;}v=this._getInputValue(v);if(this._getInputValue()===v){return this;}this._bCheckDomValue=true;if(this._bPreferUserInteraction){this.handleInputValueConcurrency(v);}else{i.value=v;}return this;};
g.prototype._aValueStateLinks=function(){if(this.getFormattedValueStateText()&&this.getFormattedValueStateText().getHtmlText()&&this.getFormattedValueStateText().getControls().length){return this.getFormattedValueStateText().getControls();}else{return[];}};
g.prototype._bClickOnValueStateLink=function(e){var v=this._aValueStateLinks();return v.some(function(L){return e.relatedTarget===L.getDomRef();});};
g.prototype._attachValueStateLinkPress=function(){this._aValueStateLinks().forEach(function(L){L.attachPress(this.fnCloseValueStateOnClick,this);},this);};
g.prototype._detachValueStateLinkPress=function(){this._aValueStateLinks().forEach(function(L){L.detachPress(this.fnCloseValueStateOnClick,this);},this);};
g.prototype.handleInputValueConcurrency=function(v){var i=this.getFocusDomRef(),s=i&&this._getInputValue(),e=this.getProperty("value"),h=document.activeElement===i,B=this.isBound("value")&&this.getBindingInfo("value").skipModelUpdate;if(h&&B&&s&&(e!==s)){return this;}i.value=v;if(h&&B&&!s){i.select();}};
g.prototype._setPreferUserInteraction=function(p){this._bPreferUserInteraction=p;};
g.prototype.closeValueStateMessage=function(){setTimeout(function(){if(this._oValueStateMessage){this._detachValueStateLinkPress();this._oValueStateMessage.close();}}.bind(this),0);};
g.prototype.getDomRefForValueStateMessage=function(){return this.getDomRef("content");};
g.prototype.getPopupAnchorDomRef=function(){return this.getDomRef();};
g.prototype.iOpenMessagePopupDuration=0;
g.prototype.getValueStateMessageId=function(){return this.getId()+"-message";};
g.prototype.getLabels=function(){var L=this.getAriaLabelledBy().map(function(s){return sap.ui.getCore().byId(s);});var o=sap.ui.require("sap/ui/core/LabelEnablement");if(o){L=L.concat(o.getReferencingLabels(this).map(function(s){return sap.ui.getCore().byId(s);}));}return L;};
g.prototype.openValueStateMessage=function(){if(this._oValueStateMessage&&this.shouldValueStateMessageBeOpened()){setTimeout(function(){if(!this.bIsDestroyed){this._detachValueStateLinkPress();this._attachValueStateLinkPress();this._oValueStateMessage.open();}}.bind(this),0);}};
g.prototype.shouldValueStateMessageBeOpened=function(){return(this.getValueState()!==f.None)&&this.getEditable()&&this.getEnabled()&&this.getShowValueStateMessage();};
g.prototype._calculateIconsSpace=function(){var e=this.getAggregation("_endIcon")||[],B=this.getAggregation("_beginIcon")||[],i=e.concat(B),h;return i.reduce(function(A,o){h=o&&o.getDomRef()?o.getDomRef().offsetWidth:0;return A+h;},0);};
g.prototype.setValue=function(v){v=this.validateProperty("value",v);v=this._getInputValue(v);this.updateDomValue(v);if(v!==this.getProperty("value")){this.setLastValue(v);}this.setProperty("value",v,true);return this;};
g.prototype.getFocusDomRef=function(){return this.getDomRef("inner");};
g.prototype.getIdForLabel=function(){return this.getId()+"-inner";};
g.prototype.getAccessibilityInfo=function(){var r=this.getRequired()?'Required':'',R=this.getRenderer();return{role:R.getAriaRole(this),type:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_INPUT"),description:[this.getValue()||"",R.getLabelledByAnnouncement(this),R.getDescribedByAnnouncement(this),r].join(" ").trim(),focusable:this.getEnabled(),enabled:this.getEnabled(),editable:this.getEnabled()&&this.getEditable()};};
g.prototype._addIcon=function(i,o){if(["begin","end"].indexOf(i)===-1){b.error('icon position is not "begin", neither "end", please check again the passed setting');return null;}var e=I.createControlByURI(o).addStyleClass(g.ICON_CSS_CLASS);this.addAggregation("_"+i+"Icon",e);return e;};
g.prototype.addBeginIcon=function(i){return this._addIcon("begin",i);};
g.prototype.addEndIcon=function(i){return this._addIcon("end",i);};
Object.defineProperty(g.prototype,"_$input",{get:function(){return this.$("inner");}});
g.prototype.setLastValue=function(v){this._lastValue=v;return this;};
g.prototype.getLastValue=function(){return this._lastValue;};
return g;});
sap.ui.predefine('sap/m/InputBaseRenderer',['sap/ui/core/Renderer','sap/ui/core/Core','sap/ui/core/library','sap/ui/core/ValueStateSupport','sap/ui/core/LabelEnablement','sap/ui/Device'],function(R,C,c,V,L,D){"use strict";var T=c.TextDirection;var a=c.ValueState;var I={apiVersion:2};
I.render=function(r,o){var v=o.getValueState(),t=o.getTextDirection(),s=R.getTextAlign(o.getTextAlign(),t),A=sap.ui.getCore().getConfiguration().getAccessibility(),b=o.getAggregation("_beginIcon")||[],e=o.getAggregation("_endIcon")||[],d,f;r.openStart("div",o);this.addOuterStyles(r,o);this.addControlWidth(r,o);r.class("sapMInputBase");this.addPaddingClass(r,o);this.addCursorClass(r,o);this.addOuterClasses(r,o);if(!o.getEnabled()){r.class("sapMInputBaseDisabled");}if(!o.getEditable()){r.class("sapMInputBaseReadonly");}if(v!==a.None&&o.getEditable()&&o.getEnabled()){r.class("sapMInputBaseState");}if(b.length){d=b.filter(function(i){return i.getVisible();});d.length&&r.class("sapMInputBaseHasBeginIcons");}if(e.length){f=e.filter(function(i){return i.getVisible();});f.length&&r.class("sapMInputBaseHasEndIcons");}this.writeOuterAttributes(r,o);var g=o.getTooltip_AsString();if(g){r.attr("title",g);}r.openEnd();r.openStart("div",o.getId()+"-content");r.class("sapMInputBaseContentWrapper");if(!o.getEnabled()){r.class("sapMInputBaseDisabledWrapper");}else if(!o.getEditable()){r.class("sapMInputBaseReadonlyWrapper");}if(v!==a.None&&o.getEditable()&&o.getEnabled()){this.addValueStateClasses(r,o);}this.addWrapperStyles(r,o);r.openEnd();if(b.length){this.writeIcons(r,b);}this.prependInnerContent(r,o);this.openInputTag(r,o);if(o.getName()){r.attr("name",o.getName());}if(!o.bShowLabelAsPlaceholder&&o._getPlaceholder()){r.attr("placeholder",o._getPlaceholder());}if(o.getMaxLength&&o.getMaxLength()>0){r.attr("maxlength",o.getMaxLength());}if(!o.getEnabled()){r.attr("disabled","disabled");}else if(!o.getEditable()){r.attr("readonly","readonly");}if(t!=T.Inherit){r.attr("dir",t.toLowerCase());}this.writeInnerValue(r,o);if(A){this.writeAccessibilityState(r,o);}if(D.browser.mozilla){if(g){r.attr("x-moz-errormessage",g);}else{r.attr("x-moz-errormessage"," ");}}this.writeInnerAttributes(r,o);r.class("sapMInputBaseInner");this.addInnerClasses(r,o);r.style("text-align",s);this.addInnerStyles(r,o);this.endInputTag(r,o);this.writeInnerContent(r,o);this.closeInputTag(r,o);if(e.length){this.writeIcons(r,e);}r.close("div");this.writeDecorations(r,o);if(A){this.renderAriaLabelledBy(r,o);this.renderAriaDescribedBy(r,o);this.renderValueStateAccDom(r,o);}r.close("div");};
I.getAriaRole=function(o){return"textbox";};
I.getAriaLabelledBy=function(o){if(this.getLabelledByAnnouncement(o)){return o.getId()+"-labelledby";}};
I.getLabelledByAnnouncement=function(o){return"";};
I.renderAriaLabelledBy=function(r,o){var A=this.getLabelledByAnnouncement(o);if(A){r.openStart("span",o.getId()+"-labelledby").attr("aria-hidden","true").class("sapUiInvisibleText").openEnd().text(A.trim()).close("span");}};
I.getAriaDescribedBy=function(o){if(this.getDescribedByAnnouncement(o)){return o.getId()+"-describedby";}};
I.getDescribedByAnnouncement=function(o){return"";};
I.renderAriaDescribedBy=function(r,o){var A=this.getDescribedByAnnouncement(o);if(A){r.openStart("span",o.getId()+"-describedby").attr("aria-hidden","true").class("sapUiInvisibleText").openEnd().text(A.trim()).close("span");}};
I.renderValueStateAccDom=function(r,o){var v=o.getValueState();if(v===a.None||!o.getEditable()||!o.getEnabled()){return;}var s=document.activeElement!==o.getFocusDomRef()||v===a.Error;var A=o.getValueStateMessageId()+"-sr";var f=o.getAggregation("_invisibleFormattedValueStateText");var b=C.getLibraryResourceBundle("sap.m").getText("INPUTBASE_VALUE_STATE_"+v.toUpperCase());r.openStart("div",A).class("sapUiPseudoInvisibleText");if(s){r.attr("aria-live","assertive");}r.attr("aria-atomic","true").openEnd().text(b).text(" ");if(f){r.renderControl(f);}else{r.text(o.getValueStateText()||V.getAdditionalText(o));}r.close("div");};
I.getAccessibilityState=function(o){var A=this.getAriaLabelledBy(o),s=this.getAriaDescribedBy(o),r=this.getAriaRole(o),v=o.getValueStateMessageId()+"-sr",m={};if(r){m.role=r;}if(o.getValueState()===a.Error&&o.getEditable()&&o.getEnabled()){m.invalid=true;m.errormessage=v;}else if(o.getValueState()!==a.None&&o.getEditable()&&o.getEnabled()){s=s?v+" "+s:v;}if(A){m.labelledby={value:A.trim(),append:true};}if(s){m.describedby={value:s.trim(),append:true};}m.disabled=null;m.readonly=null;return m;};
I.writeAccessibilityState=function(r,o){r.accessibilityState(o,this.getAccessibilityState(o));};
I.openInputTag=function(r,o){r.voidStart("input",o.getId()+"-"+this.getInnerSuffix());};
I.endInputTag=function(r,o){r.voidEnd();};
I.writeInnerValue=function(r,o){r.attr("value",o.getValue());};
I.addCursorClass=function(r,o){};
I.addPaddingClass=function(r,o){r.class("sapMInputBaseHeightMargin");};
I.addOuterStyles=function(r,o){};
I.addControlWidth=function(r,o){if(!o.getProperty('width')){r.class("sapMInputBaseNoWidth");}r.style("width",o.getWidth());};
I.addOuterClasses=function(r,o){};
I.writeOuterAttributes=function(r,o){};
I.addInnerStyles=function(r,o){};
I.addWrapperStyles=function(r,o){r.style("width","100%");};
I.addInnerClasses=function(r,o){};
I.writeInnerAttributes=function(r,o){};
I.prependInnerContent=function(r,o){};
I.writeInnerContent=function(r,o){};
I.writeIcons=function(r,i){r.openStart("div").attr("tabindex","-1").class("sapMInputBaseIconContainer").openEnd();i.forEach(r.renderControl,r);r.close("div");};
I.writeDecorations=function(r,o){};
I.closeInputTag=function(r,o){};
I.addPlaceholderStyles=function(r,o){};
I.addPlaceholderClasses=function(r,o){};
I.addValueStateClasses=function(r,o){r.class("sapMInputBaseContentWrapperState");r.class("sapMInputBaseContentWrapper"+o.getValueState());};
I.getInnerSuffix=function(){return"inner";};
return I;},true);
sap.ui.predefine('sap/m/InputListItem',["sap/ui/core/library","./library","./ListItemBase","./InputListItemRenderer"],function(c,l,L,I){"use strict";var T=c.TextDirection;
var a=L.extend("sap.m.InputListItem",{metadata:{library:"sap.m",properties:{label:{type:"string",group:"Misc",defaultValue:null},labelTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",bindable:"bindable"}},designtime:"sap/m/designtime/InputListItem.designtime"}});
a.prototype.getContentAnnouncement=function(){var A=this.getLabel()+" . ";this.getContent().forEach(function(C){A+=L.getAccessibilityText(C)+" ";});return A.trim();};
return a;});
sap.ui.predefine('sap/m/InputListItemRenderer',["sap/ui/core/library","sap/ui/core/Renderer","./ListItemBaseRenderer"],function(c,R,L){"use strict";var T=c.TextDirection;var I=R.extend(L);I.apiVersion=2;
I.renderLIAttributes=function(r,l){r.class("sapMILI");};
I.renderLIContent=function(r,l){var s=l.getLabel();var i=l.getId()+"-label";if(s){r.openStart("span",i);r.class("sapMILILabel");var a=l.getLabelTextDirection();if(a!==T.Inherit){r.attr("dir",a.toLowerCase());}r.openEnd();r.text(s);r.close("span");}r.openStart("div").class("sapMILIDiv").class("sapMILI-CTX").openEnd();l.getContent().forEach(function(C){if(C.addAriaLabelledBy&&C.getAriaLabelledBy().indexOf(i)===-1){C.addAriaLabelledBy(i);}r.renderControl(C);});r.close("div");};
return I;},true);
sap.ui.predefine('sap/m/InputRenderer',['sap/ui/core/InvisibleText','sap/ui/core/Renderer','./InputBaseRenderer','sap/m/library'],function(I,R,a,l){"use strict";var b=l.InputType;var c=R.extend(a);c.apiVersion=2;
c.addOuterClasses=function(r,C){r.class("sapMInput");if(C.getDescription()){r.class("sapMInputWithDescription");}};
c.writeInnerAttributes=function(r,C){var s=C.getShowSuggestion();r.attr("type",C.getType().toLowerCase());if(C.getType()==b.Number){r.attr("step","any");}if(C.getType()==b.Number&&sap.ui.getCore().getConfiguration().getRTL()){r.attr("dir","ltr").style("text-align","right");}if(s){r.attr("aria-haspopup","listbox");}if(s||C.getShowValueStateMessage()){r.attr("autocomplete","off");}if((!C.getEnabled()&&C.getType()=="Password")||(C.getShowSuggestion()&&C.isMobileDevice())||(C.getValueHelpOnly()&&C.getEnabled()&&C.getEditable()&&C.getShowValueHelp())){r.attr("readonly","readonly");}};
c.addInnerClasses=function(r,C){};
c.writeDescription=function(r,C){r.openStart("div").class("sapMInputDescriptionWrapper").style("width","calc(100% - "+C.getFieldWidth()+")").openEnd();r.openStart("span",C.getId()+"-descr").class("sapMInputDescriptionText").openEnd().text(C.getDescription()).close("span");r.close("div");};
c.writeDecorations=function(r,C){if(C.getDescription()){this.writeDescription(r,C);}if(sap.ui.getCore().getConfiguration().getAccessibility()){if(C.getShowSuggestion()&&C.getEnabled()&&C.getEditable()){r.openStart("span",C.getId()+"-SuggDescr").class("sapUiPseudoInvisibleText").attr("role","status").attr("aria-live","polite").openEnd().close("span");}}};
c.addWrapperStyles=function(r,C){r.style("width",C.getDescription()?C.getFieldWidth():"100%");};
c.getAriaLabelledBy=function(C){var d=a.getAriaLabelledBy.call(this,C)||"";if(C.getDescription()){d=d+" "+C.getId()+"-descr";}return d;};
c.getAriaDescribedBy=function(C){var A=a.getAriaDescribedBy.apply(this,arguments);function d(s){A=A?A+" "+s:s;}if(C.getShowValueHelp()&&C.getEnabled()&&C.getEditable()){d(I.getStaticId("sap.m","INPUT_VALUEHELP"));if(C.getValueHelpOnly()){d(I.getStaticId("sap.m","INPUT_DISABLED"));}}return A;};
c.getAriaRole=function(C){return"";};
c.getAccessibilityState=function(C){var A=a.getAccessibilityState.apply(this,arguments);return A;};
return c;},true);
sap.ui.predefine('sap/m/InstanceManager',["sap/base/assert","sap/base/Log","sap/ui/thirdparty/jquery"],function(a,L,q){"use strict";var I={};var r={},e=[];var p="_POPOVER_",d="_DIALOG_",l="_LIGHTBOX_";
I.addInstance=function(c,i){a(c,"In sap.m.InstanceManager.addInstance method, the parameter sCategoryId can't be null or empty string");a(i instanceof Object,"In sap.m.InstanceManager.addInstance method, the parameter oInstance should be an object");if(!r[c]){r[c]=[];}if(r[c].indexOf(i)===-1){r[c].push(i);}return this;};
I.removeInstance=function(c,o){var C=r[c],i;a(c,"In sap.m.InstanceManager.removeInstance method, the parameter sCategoryId can't be null or empty string");a(o instanceof Object,"In sap.m.InstanceManager.removeInstance method, the parameter oInstance should be an object");if(!C){return null;}i=C.indexOf(o);return(i===-1)?null:C.splice(i,1);};
I.getInstancesByCategoryId=function(c){a(c,"In sap.m.InstanceManager.getInstancesByCategoryId method, the parameter sCategoryId can't be null or empty string");return r[c]||e;};
I.isInstanceManaged=function(c,i){a(c,"In sap.m.InstanceManager.isInstanceManaged method, the parameter sCategoryId can't be null or empty string");a(i instanceof Object,"In sap.m.InstanceManager.isInstanceManaged method, the parameter oInstance should be an object");var C=r[c];if(!C||!i){return false;}return C.indexOf(i)!==-1;};
I.isCategoryEmpty=function(c){a(c,"In sap.m.InstanceManager.isCategoryEmpty method, the parameter sCategoryId can't be null or empty string");var C=r[c];return!C||C.length===0;};
I.addPopoverInstance=function(P){if(typeof P.close==="function"){I.addInstance(p,P);}else{L.warning("In method addPopoverInstance: the parameter doesn't have a close method and can't be managed.");}return this;};
I.addDialogInstance=function(D){if(typeof D.close==="function"){I.addInstance(d,D);}else{L.warning("In method addDialogInstance: the parameter doesn't have a close method and can't be managed.");}return this;};
I.addLightBoxInstance=function(o){if(typeof o.close==="function"){I.addInstance(l,o);}else{L.warning("In method addLightBoxInstance: the parameter doesn't have a close method and can't be managed.");}return this;};
I.removePopoverInstance=function(P){return I.removeInstance(p,P);};
I.removeDialogInstance=function(D){return I.removeInstance(d,D);};
I.removeLightBoxInstance=function(o){return I.removeInstance(l,o);};
I.hasOpenPopover=function(){return!I.isCategoryEmpty(p);};
I.hasOpenDialog=function(){return!I.isCategoryEmpty(d);};
I.hasOpenLightBox=function(){return!I.isCategoryEmpty(l);};
I.isDialogOpen=function(D){return I.isInstanceManaged(d,D);};
I.isPopoverOpen=function(P){return I.isInstanceManaged(p,P);};
I.isLightBoxOpen=function(o){return I.isInstanceManaged(l,o);};
I.getOpenPopovers=function(){return I.getInstancesByCategoryId(p);};
I.getOpenDialogs=function(){return I.getInstancesByCategoryId(d);};
I.getOpenLightBoxes=function(){return I.getInstancesByCategoryId(l);};
I.closeAllPopovers=function(){var b=I.getOpenPopovers(),i;for(i=0;i<b.length;i++){b[i].close();}return this;};
I.closeAllDialogs=function(c){var D,b=[],f=I.getOpenDialogs(),g,i;for(i=0;i<f.length;i++){g=f[i];if(!g.getCloseOnNavigation()){continue;}if(c){D=new q.Deferred().done();b.push(D);g.attachEvent("afterClose",(function(h){return function(){h.resolve();};}(D)));}g.close();}if(c){q.when.apply(this,b).then(c);}return this;};
I.closeAllLightBoxes=function(){var i=I.getOpenLightBoxes(),b=i.length,c;for(c=0;c<b;c+=1){i[c].close();}return this;};
return I;},true);
sap.ui.predefine('sap/m/Label',['./library','sap/ui/core/Control','sap/ui/core/LabelEnablement','sap/m/HyphenationSupport','sap/ui/core/library','./LabelRenderer'],function(l,C,L,H,c,a){"use strict";var T=c.TextDirection;var b=c.TextAlign;var d=l.LabelDesign;var V=c.VerticalAlign;var W=l.WrappingType;
var e=C.extend("sap.m.Label",{metadata:{interfaces:["sap.ui.core.Label","sap.ui.core.IShrinkable","sap.m.IOverflowToolbarContent","sap.m.IHyphenation"],library:"sap.m",properties:{design:{type:"sap.m.LabelDesign",group:"Appearance",defaultValue:d.Standard},text:{type:"string",group:"Misc",defaultValue:null},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:b.Begin},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:''},required:{type:"boolean",group:"Misc",defaultValue:false},displayOnly:{type:"boolean",group:"Appearance",defaultValue:false},wrapping:{type:"boolean",group:"Appearance",defaultValue:false},wrappingType:{type:"sap.m.WrappingType",group:"Appearance",defaultValue:W.Normal},vAlign:{type:"sap.ui.core.VerticalAlign",group:"Appearance",defaultValue:V.Inherit}},associations:{labelFor:{type:"sap.ui.core.Control",multiple:false}},designtime:"sap/m/designtime/Label.designtime"}});
e.prototype.getAccessibilityInfo=function(){return{description:this.getText()};};
e.prototype.getOverflowToolbarConfig=function(){var o={canOverflow:true,propsUnrelatedToSize:["design","required","displayOnly"]};function g(f){var h=f&&f.getLayoutData();if(i(h,"sap/m/OverflowToolbarLayoutData")){return h.getGroup();}}o.onBeforeEnterOverflow=function(f){var I=false,t,s,h,j,k;t=f.getParent();if(!i(t,"sap/m/OverflowToolbar")){return;}s=f.getLabelFor();h=s&&sap.ui.getCore().byId(s);if(!h||(t.indexOfContent(h)<0)){return;}j=g(f);k=g(h);I=j&&(j===k);f.toggleStyleClass("sapMLabelMediumMarginTop",I,true);};o.onAfterExitOverflow=function(f){f.toggleStyleClass("sapMLabelMediumMarginTop",false,true);};return o;};
e.prototype.getTextsToBeHyphenated=function(){return{"main":this.getText()};};
e.prototype.getDomRefsForHyphenatedTexts=function(){return{"main":this.$("bdi")[0]};};
L.enrich(e.prototype);H.mixInto(e.prototype);
function i(o,m){if(o&&m){var f=sap.ui.require(m);return(typeof f==='function')&&(o instanceof f);}}
return e;});
sap.ui.predefine('sap/m/LabelRenderer',['sap/ui/core/Renderer','sap/m/library','sap/ui/core/library','sap/m/HyphenationSupport',"sap/ui/core/LabelEnablement"],function(R,l,c,H,L){"use strict";var T=c.TextDirection;var V=c.VerticalAlign;var a=l.LabelDesign;var b={apiVersion:2};
b.render=function(d,o){var r=b,t=o.getTextDirection(),s=o.getTextAlign(),w=o.getWidth(),e=o.getText(),f=o.getTooltip_AsString(),g=o.getLabelForRendering(),h=g?"label":"span",D=o.isDisplayOnly(),v=o.getVAlign();d.openStart(h,o);d.class("sapMLabel");d.class("sapUiSelectable");if(o.isWrapping()){d.class("sapMLabelWrapped");}if(o.getDesign()==a.Bold){d.style("font-weight","bold");}if(o.isRequired()){d.class("sapMLabelRequired");}if(g){L.writeLabelForAttribute(d,o);}else if(o.getParent()instanceof sap.m.Toolbar){d.class("sapMLabelTBHeader");}d.accessibilityState({label:o.getText()});if(t!==T.Inherit){d.attr("dir",t.toLowerCase());}if(w){d.style("width",w);}else{d.class("sapMLabelMaxWidth");}if(s){s=r.getTextAlign(s,t);if(s){d.style("text-align",s);}}if(e==""){d.class("sapMLabelNoText");}if(D){d.class("sapMLabelDisplayOnly");}if(v!=V.Inherit){d.style("vertical-align",v.toLowerCase());}H.writeHyphenationClass(d,o);if(f){d.attr("title",f);}d.openEnd();d.openStart("span",o.getId()+"-text");d.class("sapMLabelTextWrapper");d.openEnd();d.openStart("bdi",o.getId()+"-bdi");d.openEnd();if(e){e=H.getTextForRender(o,"main");d.text(e);}d.close("bdi");d.close("span");d.openStart("span");d.class("sapMLabelColonAndRequired");d.openEnd();d.close("span");d.close(h);};
b.getTextAlign=R.getTextAlign;return b;},true);
sap.ui.predefine('sap/m/LightBox',["./library","sap/ui/core/Control","sap/ui/core/Popup","sap/ui/core/Core","sap/m/Text","sap/m/Button","sap/ui/core/ResizeHandler","sap/ui/Device","sap/ui/core/Icon","sap/ui/layout/VerticalLayout","./InstanceManager","sap/ui/core/InvisibleText","sap/ui/core/library","./LightBoxRenderer","sap/m/BusyIndicator","sap/ui/thirdparty/jquery","sap/ui/dom/units/Rem"],function(l,C,P,a,T,B,R,D,I,V,b,c,d,L,e,q,f){"use strict";var g=l.ButtonType;var h=l.LightBoxLoadingStates;var O=d.OpenState;var i=d.TextAlign;
var j=C.extend("sap.m.LightBox",{metadata:{library:"sap.m",interfaces:["sap.ui.core.PopupInterface"],aggregations:{imageContent:{type:"sap.m.LightBoxItem",multiple:true,bindable:"bindable"},_closeButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_verticalLayout:{type:"sap.ui.layout.VerticalLayout",multiple:false,visibility:"hidden"},_invisiblePopupText:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"},_busy:{type:"sap.m.BusyIndicator",multiple:false,visibility:"hidden"}},defaultAggregation:"imageContent",events:{},designtime:"sap/m/designtime/LightBox.designtime"}});
j.prototype.init=function(){this._createPopup();this._iWidth=0;this._iHeight=0;this._isRendering=true;this._iResizeListenerId=null;this._$lightBox=null;this._oRB=a.getLibraryResourceBundle("sap.m");this.setAggregation("_invisiblePopupText",new c());};
j.prototype.onBeforeRendering=function(){var o=this._getImageContent(),n=o._getNativeImage(),s=o.getImageSrc(),S=o._getImageState(),k=this._oRB.getText("LIGHTBOX_ARIA_ENLARGED",[o.getTitle(),o.getSubtitle()]),E=this._oRB.getText("LIGHTBOX_IMAGE_ERROR"),m=this._oRB.getText("LIGHTBOX_IMAGE_ERROR_DETAILS");this._createErrorControls();if(n.getAttribute("src")!==s){n.src=s;}if(this._iResizeListenerId){D.resize.detachHandler(this._fnResizeListener);R.deregister(this._iResizeListenerId);this._iResizeListenerId=null;}switch(S){case h.Loading:if(!this._iTimeoutId){this._iTimeoutId=setTimeout(function(){o._setImageState(h.TimeOutError);},10000);}break;case h.Loaded:clearTimeout(this._iTimeoutId);this._calculateSizes(n);break;case h.Error:clearTimeout(this._iTimeoutId);k+=" "+E+" "+m;break;default:break;}if(o){this.getAggregation("_invisiblePopupText").setText(k);}this._isRendering=true;};
j.prototype.onAfterRendering=function(){this._isRendering=false;this._$lightBox=this.$();if(!this._iResizeListenerId){this._fnResizeListener=this._onResize.bind(this);D.resize.attachHandler(this._fnResizeListener);this._iResizeListenerId=R.register(this,this._fnResizeListener);}};
j.prototype.forceInvalidate=C.prototype.invalidate;
j.prototype.invalidate=function(o){var k=this._getImageContent();if(this.isOpen()){if(k&&k.getImageSrc()){this.forceInvalidate(o);}else{this.close();}}return this;};
j.prototype.exit=function(){if(this._oPopup){this._oPopup.detachOpened(this._fnPopupOpened,this);this._oPopup.detachClosed(this._fnPopupClosed,this);this._oPopup.destroy();this._oPopup=null;}if(this._iResizeListenerId){D.resize.detachHandler(this._fnResizeListener);R.deregister(this._iResizeListenerId);this._iResizeListenerId=null;}b.removeLightBoxInstance(this);};
j.prototype.open=function(){var o=this._getImageContent();this._oPopup.setContent(this);if(o&&o.getImageSrc()){this._oPopup.open(300,"center center","center center",document.body,null);b.addLightBoxInstance(this);}return this;};
j.prototype.isOpen=function(){if(this._oPopup&&this._oPopup.isOpen()){return true;}return false;};
j.prototype.close=function(){if(this._iResizeListenerId){D.resize.detachHandler(this._fnResizeListener);R.deregister(this._iResizeListenerId);this._iResizeListenerId=null;}this._oPopup.close();b.removeLightBoxInstance(this);return this;};
j.prototype._getCloseButton=function(){var o=this.getAggregation("_closeButton");if(!o){o=new B({id:this.getId()+"-closeButton",text:this._oRB.getText("LIGHTBOX_CLOSE_BUTTON"),type:g.Transparent,press:this.close.bind(this)});this.setAggregation("_closeButton",o,true);}return o;};
j.prototype._getBusyIndicator=function(){var o=this.getAggregation("_busy");if(!o){o=new e();this.setAggregation("_busy",o,true);}return o;};
j.prototype._imageStateChanged=function(n){var E=n===h.Loaded||n===h.Error;if(E&&!this._isRendering){this.rerender();}};
j.prototype._createPopup=function(){this._oPopup=new P(this,true,true);this._oPopup.attachOpened(this._fnPopupOpened,this);this._oPopup.attachClosed(this._fnPopupClosed,this);};
j.prototype._fnPopupOpened=function(){this._onResize();q("#sap-ui-blocklayer-popup").on("click",function(){this.close();}.bind(this));};
j.prototype._fnPopupClosed=function(){q("#sap-ui-blocklayer-popup").off("click");};
j.prototype._createErrorControls=function(){var E,s,t,S,o;if(this.getAggregation("_verticalLayout")){return;}if(this._getImageContent()._getImageState()===h.TimeOutError){E=this._oRB.getText("LIGHTBOX_IMAGE_TIMED_OUT");s=this._oRB.getText("LIGHTBOX_IMAGE_TIMED_OUT_DETAILS");}else{E=this._oRB.getText("LIGHTBOX_IMAGE_ERROR");s=this._oRB.getText("LIGHTBOX_IMAGE_ERROR_DETAILS");}t=new T({text:E,textAlign:i.Center}).addStyleClass("sapMLightBoxErrorTitle");S=new T({text:s,textAlign:i.Center}).addStyleClass("sapMLightBoxErrorSubtitle");o=new I({src:"sap-icon://picture"}).addStyleClass("sapMLightBoxErrorIcon");this.setAggregation("_verticalLayout",new V({content:[o,t,S]}).addStyleClass("sapMLightBoxVerticalLayout"));};
j.prototype._onResize=function(){var m=this._calculateOffset()/2+"px",t=m,v=m,M="",k="",o=this._getImageContent(),n=this.getDomRef(),p,r,s=this._calculateOffset();if(o._getImageState()===h.Loaded){this._calculateSizes(o._getNativeImage());p=this._iWidth;r=this._iHeight;this._$lightBox.width(p);this._$lightBox.height(r);}else{p=n.clientWidth;r=n.clientHeight;}if(window.innerWidth>p+s){v="50%";k=Math.round(-p/2);}if(window.innerHeight>r+s){t="50%";M=Math.round(-r/2);}this._$lightBox.css({"top":t,"margin-top":M,"left":v,"margin-left":k});};
j.prototype._calculateSizes=function(n){var F=this._calculateFooterHeightInPx(),k=288-F,o=this._getImageContent().getAggregation("_image"),H;this._setImageSize(o,n.naturalWidth,n.naturalHeight);this._calculateAndSetLightBoxSize(o);H=this._pxToNumber(o.getHeight());this.toggleStyleClass("sapMLightBoxMinSize",H<k);this._isBusy=false;};
j.prototype._calculateFooterHeightInPx=function(){var k=this.$().parents().hasClass("sapUiSizeCompact"),s=this._getImageContent().getSubtitle(),F=3;if(k&&!s){F-=0.5;}if(s){F+=0.5;}return f.toPx(F);};
j.prototype._calculateAndSetLightBoxSize=function(o){var k,m,n=20*16,p=18*16,F=this._calculateFooterHeightInPx();k=this._pxToNumber(o.getHeight());m=this._pxToNumber(o.getWidth());this._iWidth=Math.max(n,m);this._iHeight=Math.max(p,k+F);this._bIsLightBoxBiggerThanMinDimensions=(m>=n)&&(k>=(p-F));};
j.prototype._setImageSize=function(o,w,H){var F=this._calculateFooterHeightInPx(),k=this._getDimensions(w,H,F);o.setWidth(k.width+"px");o.setHeight(k.height+"px");};
j.prototype._getDimensions=function(k,m,F){var n=20*16,o=18*16,$=q(window),w=$.height(),W=$.width(),M=this._calculateOffset(),A=Math.max(W-M,n),p=Math.max(w-M,o),s;p-=F;if(m<=p){if(k<=A){}else{m*=A/k;k=A;}}else if(k<=A){k*=p/m;m=p;}else{s=Math.max(k/A,m/p);k/=s;m/=s;}return{width:Math.round(k),height:Math.round(m)};};
j.prototype._pxToNumber=function(s){return(s.substring(0,(s.length-2)))*1;};
j.prototype._getImageContent=function(){var k=this.getAggregation("imageContent");return k&&k[0];};
j.prototype._calculateOffset=function(){if(D.system.desktop){return 4*16;}if(D.system.tablet){return 2*16;}if(D.system.phone&&D.resize.width>320){return 1*16;}return 0;};
j.prototype.onsapescape=function(E){var o=this._oPopup.getOpenState();if(o!==O.CLOSED||o!==O.CLOSING){this.close();E.stopPropagation();}};
return j;});
sap.ui.predefine('sap/m/LightBoxItem',["./library","sap/ui/core/library","sap/ui/core/Element","sap/m/Image","sap/m/Title","sap/m/Label"],function(l,c,E,I,T,L){"use strict";var a=l.LightBoxLoadingStates;var O=c.OpenState;var b=c.TitleLevel;
var d=E.extend("sap.m.LightBoxItem",{metadata:{library:"sap.m",properties:{imageSrc:{type:"sap.ui.core.URI",group:"Appearance",multiple:false,defaultValue:""},alt:{type:"string",group:"Appearance",multiple:false,defaultValue:""},title:{type:"string",group:"Appearance",multiple:false,defaultValue:""},subtitle:{type:"string",group:"Appearance",multiple:false,defaultValue:""}},aggregations:{_image:{type:"sap.m.Image",multiple:false,visibility:"hidden"},_title:{type:"sap.m.Title",multiple:false,visibility:"hidden"},_subtitle:{type:"sap.m.Label",multiple:false,visibility:"hidden"}}}});
d.prototype.init=function(){this._createNativeImage();this.setAggregation("_image",new I({decorative:false,densityAware:false}),true);this.setAggregation("_title",new T({level:b.H5,wrapping:false}),true);this.setAggregation("_subtitle",new L({wrapping:false}),true);};
d.prototype._createNativeImage=function(){var t=this;this._sImageState=a.Loading;this._oImage=new window.Image();this._oImage.onload=function(){if(this.complete&&t._sImageState===a.Loading){t._setImageState(a.Loaded);}};this._oImage.onerror=function(){t._setImageState(a.Error);};};
d.prototype.exit=function(){this._oImage=null;};
d.prototype._setImageState=function(i){if(i!==this._sImageState){this._sImageState=i;if(this.getParent()){this.getParent()._imageStateChanged(i);}}};
d.prototype._getImageState=function(){return this._sImageState;};
d.prototype._getNativeImage=function(){return this._oImage;};
d.prototype.setImageSrc=function(i){var o=this.getAggregation("_image"),e=this.getParent();if(this.getImageSrc()===i){return this;}this._sImageState=a.Loading;if(e&&e._oPopup.getOpenState()===O.OPEN){this._oImage.src=i;}this.setProperty("imageSrc",i,false);o.setSrc(i);return this;};
d.prototype.setAlt=function(e){var i=this.getAggregation("_image");this.setProperty("alt",e,false);i.setAlt(e);return this;};
d.prototype.setTitle=function(t){var o=this.getAggregation("_title");this.setProperty("title",t,false);o.setText(t);return this;};
d.prototype.setSubtitle=function(s){var S=this.getAggregation("_subtitle");this.setProperty("subtitle",s,false);S.setText(s);return this;};
return d;});
sap.ui.predefine('sap/m/LightBoxRenderer',["sap/m/library"],function(l){"use strict";var L=l.LightBoxLoadingStates;var a={apiVersion:2};
a.render=function(r,c){var o=c._getImageContent();var i=o._getImageState();var I=c.getAggregation("_invisiblePopupText");r.openStart("div",c).class("sapMLightBox").attr("tabindex","-1").accessibilityState({role:"dialog",modal:true,labelledby:I&&I.getId()});if(o.getSubtitle()){r.class("sapMLightBoxTwoLines");}if(c._bIsLightBoxBiggerThanMinDimensions){r.class("sapMLightBoxTopCornersRadius");}if(i!==L.Error){r.style("width",c._iWidth+"px");r.style("height",c._iHeight+"px");}else{r.class("sapMLightBoxError");}r.openEnd();r.renderControl(I);if(i===L.Loading){this.renderBusyState(r,c);}else if(i===L.TimeOutError||i===L.Error){this.renderError(r,c);}else{this.renderImage(r,c);}this.renderFooter(r,c,o);r.close("div");c._isRendering=false;};
a.renderImage=function(r,c){var o=c._getImageContent();r.openStart("div",o);if(o.getSubtitle()){r.class("sapMLightBoxImageContainerTwoLines");}else{r.class("sapMLightBoxImageContainer");}r.openEnd();r.renderControl(o.getAggregation("_image"));r.close("div");};
a.renderError=function(r,c){var o=c._getImageContent();r.openStart("div");if(o&&o.getSubtitle()){r.class("sapMLightBoxErrorContainerTwoLines");}else{r.class("sapMLightBoxErrorContainer");}r.openEnd();r.renderControl(c.getAggregation("_verticalLayout"));r.close("div");};
a.renderBusyState=function(r,c){r.renderControl(c._getBusyIndicator());};
a.renderFooter=function(r,c,i){var t=i.getAggregation("_title"),s=i.getAggregation("_subtitle");r.openStart("div").class("sapMLightBoxFooter").class("sapContrast").class("sapContrastPlus");if(i.getSubtitle()){r.class("sapMLightBoxFooterTwoLines");}r.openEnd();r.openStart("div").class("sapMLightBoxTitleSection").openEnd();if(t){r.renderControl(t.addStyleClass("sapMLightBoxTitle"));}if(s&&s.getText()){r.renderControl(s.addStyleClass("sapMLightBoxSubtitle"));}r.close("div");r.renderControl(c._getCloseButton());r.close("div");};
return a;},true);
sap.ui.predefine('sap/m/Link',['./library','sap/ui/core/Control','sap/ui/core/InvisibleText','sap/ui/core/EnabledPropagator','sap/ui/core/LabelEnablement','sap/ui/core/library','sap/ui/Device','./LinkRenderer',"sap/ui/events/KeyCodes","sap/base/Log","sap/base/security/URLWhitelist"],function(l,C,I,E,L,c,D,a,K,b,U){"use strict";var T=c.TextDirection;var d=c.TextAlign;
var e=C.extend("sap.m.Link",{metadata:{interfaces:["sap.ui.core.IShrinkable","sap.ui.core.IFormContent"],library:"sap.m",designtime:"sap/m/designtime/Link.designtime",properties:{text:{type:"string",group:"Data",defaultValue:''},enabled:{type:"boolean",group:"Behavior",defaultValue:true},target:{type:"string",group:"Behavior",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},href:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},validateUrl:{type:"boolean",group:"Data",defaultValue:false},wrapping:{type:"boolean",group:"Appearance",defaultValue:false},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:d.Initial},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit},subtle:{type:"boolean",group:"Behavior",defaultValue:false},emphasized:{type:"boolean",group:"Behavior",defaultValue:false}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{press:{allowPreventDefault:true,parameters:{ctrlKey:{type:"boolean"},metaKey:{type:"boolean"}}}},dnd:{draggable:true,droppable:false}}});
E.call(e.prototype);
e.prototype.onBeforeRendering=function(){};
e.prototype.onkeydown=function(o){if(o.which===K.SPACE||o.which===K.SHIFT||o.which===K.ESCAPE){if(o.which===K.SPACE){if(this.getEnabled()||this.getHref()){o.setMarked();o.preventDefault();this._bPressedSpace=true;}}if(this._bPressedSpace&&(o.which===K.ESCAPE||o.which===K.SHIFT)){this._bPressedEscapeOrShift=true;}}else{if(this._bPressedSpace){o.preventDefault();}}};
e.prototype.onkeyup=function(o){if(o.which===K.SPACE){if(!this._bPressedEscapeOrShift){this._handlePress(o);if(this.getHref()&&!o.isDefaultPrevented()){o.preventDefault();o.setMarked();var f=document.createEvent('MouseEvents');f.initEvent('click',false,true);this.getDomRef().dispatchEvent(f);}}else{this._bPressedEscapeOrShift=false;}this._bPressedSpace=false;}};
e.prototype._handlePress=function(o){if(this.getEnabled()){o.setMarked();if(!this.firePress({ctrlKey:!!o.ctrlKey,metaKey:!!o.metaKey})||!this.getHref()){o.preventDefault();}}else{o.preventDefault();}};
e.prototype.onsapenter=e.prototype._handlePress;if(D.support.touch){e.prototype.ontap=e.prototype._handlePress;}else{e.prototype.onclick=e.prototype._handlePress;}
e.prototype.ontouchstart=function(o){if(this.getEnabled()){o.setMarked();}};
e.prototype.setSubtle=function(s){this.setProperty("subtle",s);if(s&&!e.prototype._sAriaLinkSubtleId){e.prototype._sAriaLinkSubtleId=I.getStaticId("sap.m","LINK_SUBTLE");}return this;};
e.prototype.setEmphasized=function(f){this.setProperty("emphasized",f);if(f&&!e.prototype._sAriaLinkEmphasizedId){e.prototype._sAriaLinkEmphasizedId=I.getStaticId("sap.m","LINK_EMPHASIZED");}return this;};
e.prototype._isHrefValid=function(u){return this.getValidateUrl()?U.validate(u):true;};
e.prototype.getAccessibilityInfo=function(){return{role:"link",type:this.getText()?sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_LINK"):undefined,description:this.getText()||this.getHref()||"",focusable:this.getEnabled(),enabled:this.getEnabled()};};
e.prototype.getFormDoNotAdjustWidth=function(){return true;};
e.prototype._getTabindex=function(){return(this.getText()&&this.getEnabled())?"0":"-1";};
e.prototype._determineSelfReferencePresence=function(){var A=this.getAriaLabelledBy(),f=A.indexOf(this.getId())!==-1,h=L.getReferencingLabels(this).length>0,p=this.getParent(),g=!!(p&&p.enhanceAccessibilityState);return!f&&(A.length>0||h||g);};
return e;});
sap.ui.predefine('sap/m/LinkRenderer',['sap/ui/core/Renderer','sap/ui/core/library'],function(R,c){"use strict";var T=c.TextDirection;var L={apiVersion:2};
L.render=function(r,C){var t=C.getTextDirection(),s=R.getTextAlign(C.getTextAlign(),t),S=C._determineSelfReferencePresence(),h=C.getHref(),a={labelledby:S?{value:C.getId(),append:true}:undefined},i=h&&C._isHrefValid(h),e=C.getEnabled(),b="";r.openStart("a",C);r.class("sapMLnk");if(C.getSubtle()){r.class("sapMLnkSubtle");b+=C._sAriaLinkSubtleId;}if(C.getEmphasized()){r.class("sapMLnkEmphasized");b+=" "+C._sAriaLinkEmphasizedId;}a.describedby=b?{value:b.trim(),append:true}:undefined;if(!e){r.class("sapMLnkDsbl");r.attr("aria-disabled","true");}r.attr("tabindex",C._getTabindex());if(C.getWrapping()){r.class("sapMLnkWrapping");}if(C.getTooltip_AsString()){r.attr("title",C.getTooltip_AsString());}if(i&&e){r.attr("href",h);}else if(C.getText()){r.attr("href","");}if(C.getTarget()){r.attr("target",C.getTarget());}if(C.getWidth()){r.style("width",C.getWidth());}else{r.class("sapMLnkMaxWidth");}if(s){r.style("text-align",s);}if(t!==T.Inherit){r.attr("dir",t.toLowerCase());}C.getDragDropConfig().forEach(function(d){if(!d.getEnabled()){r.attr("draggable",false);}});r.accessibilityState(C,a);r.openEnd();if(this.writeText){this.writeText(r,C);}else{this.renderText(r,C);}r.close("a");};
L.renderText=function(r,C){r.text(C.getText());};
return L;},true);
sap.ui.predefine('sap/m/List',["./library","./ListBase","./ListRenderer"],function(l,L,a){"use strict";var B=l.BackgroundDesign;
var b=L.extend("sap.m.List",{metadata:{library:"sap.m",properties:{backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:B.Solid}}}});
return b;});
sap.ui.predefine('sap/m/ListBase',["sap/ui/events/KeyCodes","sap/ui/Device","sap/ui/core/Core","sap/ui/core/Control","sap/ui/core/InvisibleText","sap/ui/core/LabelEnablement","sap/ui/core/delegate/ItemNavigation","./library","./InstanceManager","./GrowingEnablement","./GroupHeaderListItem","./ListItemBase","./ListBaseRenderer","sap/base/strings/capitalize","sap/ui/thirdparty/jquery","sap/base/Log","sap/ui/dom/jquery/control","sap/ui/dom/jquery/Selectors","sap/ui/dom/jquery/Aria"],function(K,D,C,a,I,L,b,l,c,G,d,f,g,h,q,j){"use strict";var k=l.ListType;var m=l.ListKeyboardMode;var n=l.ListGrowingDirection;var S=l.SwipeDirection;var o=l.ListSeparators;var p=l.ListMode;var r=l.ListHeaderDesign;var s=l.Sticky;
var t=a.extend("sap.m.ListBase",{metadata:{library:"sap.m",dnd:true,properties:{inset:{type:"boolean",group:"Appearance",defaultValue:false},headerText:{type:"string",group:"Misc",defaultValue:null},headerDesign:{type:"sap.m.ListHeaderDesign",group:"Appearance",defaultValue:r.Standard,deprecated:true},footerText:{type:"string",group:"Misc",defaultValue:null},mode:{type:"sap.m.ListMode",group:"Behavior",defaultValue:p.None},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},includeItemInSelection:{type:"boolean",group:"Behavior",defaultValue:false},showUnread:{type:"boolean",group:"Misc",defaultValue:false},noDataText:{type:"string",group:"Misc",defaultValue:null},showNoData:{type:"boolean",group:"Misc",defaultValue:true},enableBusyIndicator:{type:"boolean",group:"Behavior",defaultValue:true},modeAnimationOn:{type:"boolean",group:"Misc",defaultValue:true},showSeparators:{type:"sap.m.ListSeparators",group:"Appearance",defaultValue:o.All},swipeDirection:{type:"sap.m.SwipeDirection",group:"Misc",defaultValue:S.Both},growing:{type:"boolean",group:"Behavior",defaultValue:false},growingThreshold:{type:"int",group:"Misc",defaultValue:20},growingTriggerText:{type:"string",group:"Appearance",defaultValue:null},growingScrollToLoad:{type:"boolean",group:"Behavior",defaultValue:false},growingDirection:{type:"sap.m.ListGrowingDirection",group:"Behavior",defaultValue:n.Downwards},rememberSelections:{type:"boolean",group:"Behavior",defaultValue:true},keyboardMode:{type:"sap.m.ListKeyboardMode",group:"Behavior",defaultValue:m.Navigation},sticky:{type:"sap.m.Sticky[]",group:"Appearance"}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.ListItemBase",multiple:true,singularName:"item",bindable:"bindable",selector:"#{id} .sapMListItems",dnd:true},swipeContent:{type:"sap.ui.core.Control",multiple:false},headerToolbar:{type:"sap.m.Toolbar",multiple:false},infoToolbar:{type:"sap.m.Toolbar",multiple:false},contextMenu:{type:"sap.ui.core.IContextMenu",multiple:false},_messageStrip:{type:"sap.m.MessageStrip",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{select:{deprecated:true,parameters:{listItem:{type:"sap.m.ListItemBase"}}},selectionChange:{parameters:{listItem:{type:"sap.m.ListItemBase"},listItems:{type:"sap.m.ListItemBase[]"},selected:{type:"boolean"},selectAll:{type:"boolean"}}},"delete":{parameters:{listItem:{type:"sap.m.ListItemBase"}}},swipe:{allowPreventDefault:true,parameters:{listItem:{type:"sap.m.ListItemBase"},swipeContent:{type:"sap.ui.core.Control"},srcControl:{type:"sap.ui.core.Control"},swipeDirection:{type:"sap.m.SwipeDirection"}}},growingStarted:{deprecated:true,parameters:{actual:{type:"int"},total:{type:"int"}}},growingFinished:{deprecated:true,parameters:{actual:{type:"int"},total:{type:"int"}}},updateStarted:{parameters:{reason:{type:"string"},actual:{type:"int"},total:{type:"int"}}},updateFinished:{parameters:{reason:{type:"string"},actual:{type:"int"},total:{type:"int"}}},itemPress:{parameters:{listItem:{type:"sap.m.ListItemBase"},srcControl:{type:"sap.ui.core.Control"}}},beforeOpenContextMenu:{allowPreventDefault:true,parameters:{listItem:{type:"sap.m.ListItemBase"}}}},designtime:"sap/m/designtime/ListBase.designtime"}});
t.prototype.bAnnounceDetails=true;t.prototype.bPreventMassSelection=false;
t.getInvisibleText=function(){return this.oInvisibleText||(this.oInvisibleText=new I().toStatic());};
t.prototype.sNavItemClass="sapMLIB";
t.prototype.init=function(){this._aNavSections=[];this._aSelectedPaths=[];this._iItemNeedsHighlight=0;this._iItemNeedsNavigated=0;this._bItemsBeingBound=false;this._bSkippedInvalidationOnRebind=false;this.data("sap-ui-fastnavgroup","true",true);};
t.prototype.onBeforeRendering=function(){this._bRendering=true;this._bActiveItem=false;this._aNavSections=[];this._removeSwipeContent();};
t.prototype.onAfterRendering=function(){this._bRendering=false;this._sLastMode=this.getMode();if(D.system.desktop){this._startItemNavigation(true);}};
t.prototype.exit=function(){this._oSelectedItem=null;this._aNavSections=[];this._aSelectedPaths=[];this._destroyGrowingDelegate();this._destroyItemNavigation();};
t.prototype.refreshItems=function(R){if(this._oGrowingDelegate){this._oGrowingDelegate.refreshItems(R);}else{if(!this._bReceivingData){this._updateStarted(R);this._bReceivingData=true;}this.refreshAggregation("items");}};
t.prototype.updateItems=function(R,e){if(e&&e.detailedReason==="AddVirtualContext"){u(this);return;}else if(e&&e.detailedReason==="RemoveVirtualContext"){v(this);return;}if(this._bSkippedInvalidationOnRebind&&this.getBinding("items").getLength()===0){this.invalidate();}if(this._oGrowingDelegate){this._oGrowingDelegate.updateItems(R);}else{if(this._bReceivingData){this._bReceivingData=false;}else{this._updateStarted(R);}this.updateAggregation("items");this._updateFinished();}this._bSkippedInvalidationOnRebind=false;};
function u(e){var B=e.getBinding("items");var i=e.getBindingInfo("items");var V=B.getContexts(0,e.getGrowing()?e.getGrowingThreshold():i.length)[0];v(e);e._oVirtualItem=G.createItem(V,i,"virtual");e.addAggregation("dependents",e._oVirtualItem,true);}
function v(e){if(e._oVirtualItem){e._oVirtualItem.destroy();delete e._oVirtualItem;}}
t.prototype.setBindingContext=function(e,M){var i=(this.getBindingInfo("items")||{}).model;if(i===M){this._resetItemsBinding();}return a.prototype.setBindingContext.apply(this,arguments);};
t.prototype.bindAggregation=function(N){this._bItemsBeingBound=N==="items";v(this);a.prototype.bindAggregation.apply(this,arguments);this._bItemsBeingBound=false;return this;};
t.prototype._bindAggregation=function(N,B){function e(B,E,H){B.events=B.events||{};if(!B.events[E]){B.events[E]=H;}else{var O=B.events[E];B.events[E]=function(){H.apply(this,arguments);O.apply(this,arguments);};}}if(N==="items"){this._resetItemsBinding();e(B,"dataRequested",this._onBindingDataRequestedListener.bind(this));e(B,"dataReceived",this._onBindingDataReceivedListener.bind(this));}a.prototype._bindAggregation.call(this,N,B);};
t.prototype._onBindingDataRequestedListener=function(e){this._showBusyIndicator();if(this._dataReceivedHandlerId!=null){clearTimeout(this._dataReceivedHandlerId);delete this._dataReceivedHandlerId;}};
t.prototype._onBindingDataReceivedListener=function(e){if(this._dataReceivedHandlerId!=null){clearTimeout(this._dataReceivedHandlerId);delete this._dataReceivedHandlerId;}this._dataReceivedHandlerId=setTimeout(function(){this._hideBusyIndicator();delete this._dataReceivedHandlerId;}.bind(this),0);};
t.prototype.destroyItems=function(e){if(!this.getItems(true).length){return this;}this._oSelectedItem=null;this.destroyAggregation("items","KeepDom");if(!e){if(this._bItemsBeingBound){this._bSkippedInvalidationOnRebind=true;}else{this.invalidate();}}return this;};
t.prototype.removeAllItems=function(A){this._oSelectedItem=null;return this.removeAllAggregation("items");};
t.prototype.removeItem=function(i){var e=this.removeAggregation("items",i);if(e&&e===this._oSelectedItem){this._oSelectedItem=null;}return e;};
t.prototype.getItems=function(R){if(R){return this.mAggregations["items"]||[];}return this.getAggregation("items",[]);};
t.prototype.getId=function(e){var i=this.sId;return e?i+"-"+e:i;};
t.prototype.setGrowing=function(e){e=!!e;if(this.getGrowing()!=e){this.setProperty("growing",e,!e);if(e){this._oGrowingDelegate=new G(this);}else if(this._oGrowingDelegate){this._oGrowingDelegate.destroy();this._oGrowingDelegate=null;}}return this;};
t.prototype.setGrowingThreshold=function(T){return this.setProperty("growingThreshold",T,true);};
t.prototype.setEnableBusyIndicator=function(e){this.setProperty("enableBusyIndicator",e,true);if(!this.getEnableBusyIndicator()){this._hideBusyIndicator();}return this;};
t.prototype.setNoDataText=function(N){this.setProperty("noDataText",N,true);this.$("nodata-text").text(this.getNoDataText());return this;};
t.prototype.getNoDataText=function(e){if(e&&this._bBusy){return"";}var N=this.getProperty("noDataText");N=N||C.getLibraryResourceBundle("sap.m").getText("LIST_NO_DATA");return N;};
t.prototype.getSelectedItem=function(){var e=this.getItems(true);for(var i=0;i<e.length;i++){if(e[i].getSelected()){return e[i];}}return null;};
t.prototype.setSelectedItem=function(e,i,F){if(this.indexOfItem(e)<0){j.warning("setSelectedItem is called without valid ListItem parameter on "+this);return;}if(this._bSelectionMode){e.setSelected((i===undefined)?true:!!i);F&&this._fireSelectionChangeEvent([e]);}};
t.prototype.getSelectedItems=function(){return this.getItems(true).filter(function(i){return i.getSelected();});};
t.prototype.setSelectedItemById=function(i,e){var w=C.byId(i);return this.setSelectedItem(w,e);};
t.prototype.getSelectedContexts=function(A){var B=this.getBindingInfo("items"),M=(B||{}).model,e=this.getModel(M);if(!B||!e){return[];}if(A&&this.getRememberSelections()){return this._aSelectedPaths.map(function(P){return e.getContext(P);});}return this.getSelectedItems().map(function(i){return i.getBindingContext(M);});};
t.prototype.removeSelections=function(A,F,e){var i=[];this._oSelectedItem=null;A&&(this._aSelectedPaths=[]);this.getItems(true).forEach(function(w){if(!w.getSelected()){return;}if(e&&w.isSelectedBoundTwoWay()){return;}w.setSelected(false,true);i.push(w);!A&&this._updateSelectedPaths(w);},this);if(F&&i.length){this._fireSelectionChangeEvent(i);}return this;};
t.prototype.selectAll=function(F){if(this.getMode()!="MultiSelect"){return this;}var e=[];this.getItems(true).forEach(function(i){if(!i.getSelected()){i.setSelected(true,true);e.push(i);this._updateSelectedPaths(i);}},this);if(F&&e.length){this._fireSelectionChangeEvent(e,F);}return this;};
t.prototype.getLastMode=function(M){return this._sLastMode;};
t.prototype.setMode=function(M){M=this.validateProperty("mode",M);var O=this.getMode();if(O==M){return this;}this._bSelectionMode=M.indexOf("Select")>-1;if(!this._bSelectionMode){this.removeSelections(true);}else{var e=this.getSelectedItems();if(e.length>1){this.removeSelections(true);}else if(O===p.MultiSelect){this._oSelectedItem=e[0];}}return this.setProperty("mode",M);};
t.prototype.getGrowingInfo=function(){return this._oGrowingDelegate?this._oGrowingDelegate.getInfo():null;};
t.prototype.setRememberSelections=function(R){this.setProperty("rememberSelections",R,true);!this.getRememberSelections()&&(this._aSelectedPaths=[]);return this;};
t.prototype.setSelectedContextPaths=function(e){this._aSelectedPaths=e||[];};
t.prototype.getSelectedContextPaths=function(A){if(!A||(A&&this.getRememberSelections())){return this._aSelectedPaths.slice(0);}return this.getSelectedItems().map(function(i){return i.getBindingContextPath();});};
t.prototype.isAllSelectableSelected=function(){if(this.getMode()!=p.MultiSelect){return false;}var i=this.getItems(true),e=this.getSelectedItems().length,w=i.filter(function(x){return x.isSelectable();}).length;return(i.length>0)&&(e==w);};
t.prototype.getVisibleItems=function(){return this.getItems(true).filter(function(i){return i.getVisible();});};
t.prototype.getActiveItem=function(){return this._bActiveItem;};
t.prototype.onItemDOMUpdate=function(e){if(!this._bRendering&&this.bOutput){this._startItemNavigation(true);}var V=this.getVisibleItems().length>0;if(!V&&!this._bInvalidatedForNoData){this.invalidate();this._bInvalidatedForNoData=true;}else if(V&&this._bInvalidatedForNoData){this.invalidate();this._bInvalidatedForNoData=false;}};
t.prototype.onItemActiveChange=function(e,A){this._bActiveItem=A;};
t.prototype.onItemHighlightChange=function(i,N){this._iItemNeedsHighlight+=(N?1:-1);if(this._iItemNeedsHighlight==1&&N){this.$("listUl").addClass("sapMListHighlight");}else if(this._iItemNeedsHighlight==0){this.$("listUl").removeClass("sapMListHighlight");}};
t.prototype.onItemNavigatedChange=function(i,N){this._iItemNeedsNavigated+=(N?1:-1);if(this._iItemNeedsNavigated==1&&N){this.$("listUl").addClass("sapMListNavigated");}else if(this._iItemNeedsNavigated==0){this.$("listUl").removeClass("sapMListNavigated");}};
t.prototype.onItemSelectedChange=function(e,i){if(this.getMode()==p.MultiSelect){this._updateSelectedPaths(e,i);return;}if(i){this._aSelectedPaths=[];this._oSelectedItem&&this._oSelectedItem.setSelected(false,true);this._oSelectedItem=e;}else if(this._oSelectedItem===e){this._oSelectedItem=null;}this._updateSelectedPaths(e,i);};
t.prototype.getItemsContainerDomRef=function(){return this.getDomRef("listUl");};
t.prototype.checkGrowingFromScratch=function(){};
t.prototype.onBeforePageLoaded=function(e,i){this._fireUpdateStarted(i,e);this.fireGrowingStarted(e);};
t.prototype.onAfterPageLoaded=function(e,i){this._fireUpdateFinished(e);this.fireGrowingFinished(e);};
t.prototype.addNavSection=function(i){this._aNavSections.push(i);return i;};
t.prototype.getMaxItemsCount=function(){var B=this.getBinding("items");if(B&&B.getLength){return B.getLength()||0;}return this.getItems(true).length;};
t.prototype.shouldRenderItems=function(){return true;};
t.prototype._resetItemsBinding=function(){if(this.isBound("items")){this._bUpdating=false;this._bReceivingData=false;this.removeSelections(true,false,true);this._oGrowingDelegate&&this._oGrowingDelegate.reset();this._hideBusyIndicator();if(this._oItemNavigation){this._oItemNavigation.iFocusedIndex=-1;}}};
t.prototype._updateStarted=function(R){if(!this._bReceivingData&&!this._bUpdating){this._bUpdating=true;this._fireUpdateStarted(R);}};
t.prototype._fireUpdateStarted=function(R,i){this._sUpdateReason=h(R||"Refresh");this.fireUpdateStarted({reason:this._sUpdateReason,actual:i?i.actual:this.getItems(true).length,total:i?i.total:this.getMaxItemsCount()});};
t.prototype.onThemeChanged=function(){if(this._oGrowingDelegate){this._oGrowingDelegate._updateTrigger();}};
t.prototype._updateFinished=function(){if(!this._bReceivingData&&this._bUpdating){this._fireUpdateFinished();this._bUpdating=false;}};
t.prototype._fireUpdateFinished=function(i){this._hideBusyIndicator();setTimeout(function(){this._bItemNavigationInvalidated=true;this.fireUpdateFinished({reason:this._sUpdateReason,actual:i?i.actual:this.getItems(true).length,total:i?i.total:this.getMaxItemsCount()});}.bind(this),0);};
t.prototype._showBusyIndicator=function(){if(this.getEnableBusyIndicator()&&!this.getBusy()&&!this._bBusy){this._bBusy=true;this._sBusyTimer=setTimeout(function(){this.$("nodata-text").text("");}.bind(this),this.getBusyIndicatorDelay());this.setBusy(true,"listUl");}};
t.prototype._hideBusyIndicator=function(){if(this._bBusy){this._bBusy=false;this.setBusy(false,"listUl");clearTimeout(this._sBusyTimer);if(!this.getItems(true).length){this.$("nodata-text").text(this.getNoDataText());}}};
t.prototype.setBusy=function(B,e){if(this.getBusy()==B){return this;}a.prototype.setBusy.apply(this,arguments);if(!B||!window.IntersectionObserver){clearTimeout(this._iBusyTimer);return this;}this._iBusyTimer=setTimeout(function(){var i=this.getDomRef(e);var A=this.getDomRef("busyIndicator");var w=l.getScrollDelegate(this,true);if(!i||!A||!w){return;}var x=new window.IntersectionObserver(function(E){x.disconnect();var y=E.pop();var R=y.intersectionRatio;if(R<=0||R>=1){return;}var z=A.firstChild.style;if(y.intersectionRect.height>=y.rootBounds.height){z.position="sticky";}else{z.top=((y.boundingClientRect.top<0?1-R:0)+(R/2))*100+"%";}},{root:w.getContainerDomRef()});x.observe(i);}.bind(this),this.getBusyIndicatorDelay());return this;};
t.prototype.onItemBindingContextSet=function(i){if(!this._bSelectionMode||!this.getRememberSelections()||!this.isBound("items")){return;}if(i.isSelectedBoundTwoWay()){return;}var P=i.getBindingContextPath();if(P){var e=(this._aSelectedPaths.indexOf(P)>-1);i.setSelected(e);}};
t.prototype.onItemInserted=function(i,e){if(e){this.onItemSelectedChange(i,true);}if(!this._bSelectionMode||!this._aSelectedPaths.length||!this.getRememberSelections()||!this.isBound("items")||i.isSelectedBoundTwoWay()||i.getSelected()){return;}var P=i.getBindingContextPath();if(P&&this._aSelectedPaths.indexOf(P)>-1){i.setSelected(true);}};
t.prototype.onItemSelect=function(e,w){var M=this.getMode();if(this._mRangeSelection&&!this.bPreventMassSelection){if(!this._mRangeSelection.selected){this._fireSelectionChangeEvent([e]);this._mRangeSelection.index=this.getVisibleItems().indexOf(e);this._mRangeSelection.selected=w;return;}if(!w){e.setSelected(true);return;}var x=this.indexOfItem(e),y=this.getItems(),z,A,B=[],E;if(x<this._mRangeSelection.index){z=this._mRangeSelection.index-x;E=-1;}else{z=x-this._mRangeSelection.index;E=1;}for(var i=1;i<=z;i++){A=y[this._mRangeSelection.index+(i*E)];if(A.isSelectable()&&A.getVisible()&&!A.getSelected()){A.setSelected(true);B.push(A);}else if(A===e){B.push(A);}}this._fireSelectionChangeEvent(B);return;}if(M===p.MultiSelect){this._fireSelectionChangeEvent([e]);}else if(this._bSelectionMode&&w){this._fireSelectionChangeEvent([e]);}};
t.prototype._fireSelectionChangeEvent=function(e,i){var w=e&&e[0];if(!w){return;}this.fireSelectionChange({listItem:w,listItems:e,selected:w.getSelected(),selectAll:!!i});if(this.getGrowing()){this._bSelectAll=i;}this.fireSelect({listItem:w});};
t.prototype.onItemDelete=function(e){this.fireDelete({listItem:e});};
t.prototype.onItemPress=function(e,i){if(e.getType()==k.Inactive){return;}setTimeout(function(){this.fireItemPress({listItem:e,srcControl:i});}.bind(this),0);};
t.prototype.onItemKeyDown=function(i,e){if(!e.shiftKey||e.ctrlKey||e.altKey||e.metaKey||this.getMode()!==p.MultiSelect||!i.isSelectable()||this.bPreventMassSelection||e.which===K.F6){if(this._mRangeSelection){this._mRangeSelection=null;}return;}var V=this.getVisibleItems(),H=V.some(function(w){return!!w.getSelected();});if(!H){return;}if(!this._mRangeSelection){this._mRangeSelection={index:V.indexOf(i),selected:i.getSelected()};}};
t.prototype.onItemKeyUp=function(i,e){if(e.which===K.SHIFT){this._mRangeSelection=null;}};
t.prototype._updateSelectedPaths=function(i,e){if(!this.getRememberSelections()||!this.isBound("items")){return;}var P=i.getBindingContextPath();if(!P){return;}e=(e===undefined)?i.getSelected():e;var w=this._aSelectedPaths.indexOf(P);if(e){w<0&&this._aSelectedPaths.push(P);}else{w>-1&&this._aSelectedPaths.splice(w,1);}};
t.prototype._destroyGrowingDelegate=function(){if(this._oGrowingDelegate){this._oGrowingDelegate.destroy();this._oGrowingDelegate=null;}};
t.prototype._destroyItemNavigation=function(){if(this._oItemNavigation){this.removeEventDelegate(this._oItemNavigation);this._oItemNavigation.destroy();this._oItemNavigation=null;}};
t.prototype._getTouchBlocker=function(){return this.$().children();};
t.prototype._getSwipeContainer=function(){return this._$swipeContainer||(this._$swipeContainer=q("<div>",{"id":this.getId("swp"),"class":"sapMListSwp"}));};
t.prototype._setSwipePosition=function(){if(this._isSwipeActive){return this._getSwipeContainer().css("top",this._swipedItem.$().position().top);}};
t.prototype._renderSwipeContent=function(){var $=this._swipedItem.$(),e=this._getSwipeContainer();this.$().prepend(e.css({top:$.position().top,height:$.outerHeight(true)}));if(this._bRerenderSwipeContent){this._bRerenderSwipeContent=false;var i=C.createRenderManager();i.render(this.getSwipeContent(),e.empty()[0]);i.destroy();}return this;};
t.prototype._swipeIn=function(){var i=this,$=i._getTouchBlocker(),w=i._getSwipeContainer();i._isSwipeActive=true;i._renderSwipeContent();c.addPopoverInstance(i);window.document.activeElement.blur();q(window).on("resize.swp",function(){i._setSwipePosition();});$.css("pointer-events","none").on("touchstart.swp mousedown.swp",function(e){if(!w[0].firstChild.contains(e.target)){e.preventDefault();e.stopPropagation();}});w.on("webkitAnimationEnd animationend",function(){q(this).off("webkitAnimationEnd animationend");w.css("opacity",1).trigger("focus");$.parent().on("touchend.swp touchcancel.swp mouseup.swp",function(e){if(!w[0].firstChild.contains(e.target)){i.swipeOut();}});}).removeClass("sapMListSwpOutAnim").addClass("sapMListSwpInAnim");};
t.prototype._onSwipeOut=function(e){this._getSwipeContainer().css("opacity",0).remove();q(window).off("resize.swp");this._getTouchBlocker().css("pointer-events","auto").off("touchstart.swp mousedown.swp");if(typeof e=="function"){e.call(this,this._swipedItem,this.getSwipeContent());}this._isSwipeActive=false;c.removePopoverInstance(this);};
t.prototype.swipeOut=function(e){if(!this._isSwipeActive){return this;}var i=this,$=this._getSwipeContainer();this._getTouchBlocker().parent().off("touchend.swp touchend.swp touchcancel.swp mouseup.swp");$.on("webkitAnimationEnd animationend",function(){q(this).off("webkitAnimationEnd animationend");i._onSwipeOut(e);}).removeClass("sapMListSwpInAnim").addClass("sapMListSwpOutAnim");return this;};
t.prototype._removeSwipeContent=function(){if(this._isSwipeActive){this.swipeOut()._onSwipeOut();}};
t.prototype.close=t.prototype._removeSwipeContent;
t.prototype._onSwipe=function(e,i){var w=this.getSwipeContent(),x=e.srcControl;if(w&&x&&!this._isSwipeActive&&this!==x&&!this._eventHandledByControl&&D.support.touch){for(var y=x;y&&!(y instanceof f);y=y.oParent);if(y instanceof f){this._swipedItem=y;this.fireSwipe({listItem:this._swipedItem,swipeContent:w,srcControl:x,swipeDirection:i},true)&&this._swipeIn();}}};
t.prototype.ontouchstart=function(e){this._eventHandledByControl=e.isMarked();};
t.prototype.onswipeleft=function(e){var R=C.getConfiguration().getRTL();var i=R?S.EndToBegin:S.BeginToEnd;var w=this.getSwipeDirection();if(w===S.LeftToRight){w=S.BeginToEnd;}else if(w===S.RightToLeft){w=S.EndToBegin;}if(w!=i){if(w==S.Both){w=R?S.BeginToEnd:S.EndToBegin;}this._onSwipe(e,w);}};
t.prototype.onswiperight=function(e){var R=C.getConfiguration().getRTL();var i=R?S.BeginToEnd:S.EndToBegin;var w=this.getSwipeDirection();if(w===S.LeftToRight){w=S.BeginToEnd;}else if(w===S.RightToLeft){w=S.EndToBegin;}if(w!=i){if(w==S.Both){w=R?S.EndToBegin:S.BeginToEnd;}this._onSwipe(e,w);}};
t.prototype.setSwipeDirection=function(e){return this.setProperty("swipeDirection",e,true);};
t.prototype.getSwipedItem=function(){return(this._isSwipeActive?this._swipedItem:null);};
t.prototype.setSwipeContent=function(e){this._bRerenderSwipeContent=true;this.toggleStyleClass("sapMListSwipable",!!e);return this.setAggregation("swipeContent",e,!this._isSwipeActive);};
t.prototype.invalidate=function(O){if(O&&O===this.getSwipeContent()){this._bRerenderSwipeContent=true;this._isSwipeActive&&this._renderSwipeContent();return;}return a.prototype.invalidate.apply(this,arguments);};
t.prototype.addItemGroup=function(e,H,i){if(!H){H=new d();H.setTitle(e.text||e.key);}H._bGroupHeader=true;this.addAggregation("items",H,i);return H;};
t.prototype.removeGroupHeaders=function(e){this.getItems(true).forEach(function(i){if(i.isGroupHeader()){i.destroy(e);}});};
t.prototype.getAccessibilityType=function(){return C.getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_LIST");};
t.prototype.getAccessibilityStates=function(){if(!this.getItems(true).length){return"";}var e="",M=p,i=this.getMode(),B=C.getLibraryResourceBundle("sap.m");if(L.isRequired(this)){e+=B.getText("LIST_REQUIRED")+" ";}if(i==M.MultiSelect){e+=B.getText("LIST_MULTISELECTABLE")+" . ";}else if(i==M.Delete){e+=B.getText("LIST_DELETABLE")+" . ";}else if(i!=M.None){e+=B.getText("LIST_SELECTABLE")+" . ";}if(this.isGrouped()){e+=B.getText("LIST_GROUPED")+" . ";}return e;};
t.prototype.getAccessibilityInfo=function(){return{description:this.getAccessibilityStates().trim(),focusable:true};};
t.prototype.getAccessbilityPosition=function(i){var e=0,w=this.getVisibleItems(),P=w.indexOf(i)+1,B=this.getBinding("items");if(this.getGrowing()&&this.getGrowingScrollToLoad()&&B&&B.isLengthFinal()){e=B.getLength();if(B.isGrouped()){e+=w.filter(function(i){return i.isGroupHeader()&&i.getVisible();}).length;}}else{e=w.length;}return{setSize:e,posInset:P};};
t.prototype.onItemFocusIn=function(i,F){this._handleStickyItemFocus(i.getDomRef());if(i!==F||!C.getConfiguration().getAccessibility()){return;}var e=i.getDomRef(),P=this.getAccessbilityPosition(i);if(D.browser.msie&&this._oItemNavigation&&this._oItemNavigation.getFocusedDomRef()===e){e.classList.remove("sapMLIBFocusable");setTimeout(function(){e.classList.add("sapMLIBFocusable");},0);}if(!i.getContentAnnouncement){this.getNavigationRoot().setAttribute("aria-activedescendant",e.id);e.setAttribute("aria-posinset",P.posInset);e.setAttribute("aria-setsize",P.setSize);}else{var A=i.getAccessibilityInfo(),B=C.getLibraryResourceBundle("sap.m"),w=A.type+" . ";if(!D.browser.chrome||this.isA("sap.m.Table")){w+=B.getText("LIST_ITEM_POSITION",[P.posInset,P.setSize])+" . ";}else{e.setAttribute("aria-posinset",P.posInset);e.setAttribute("aria-setsize",P.setSize);}w+=A.description;this.updateInvisibleText(w,e);return w;}};
t.prototype.updateInvisibleText=function(T,i,P){var e=t.getInvisibleText(),F=q(i||document.activeElement);if(this.bAnnounceDetails){this.bAnnounceDetails=false;T=this.getAccessibilityInfo().description+" "+T;}e.setText(T.trim());F.addAriaLabelledBy(e.getId(),P);};
t.prototype.getNavigationRoot=function(){return this.getDomRef("listUl");};
t.prototype.getFocusDomRef=function(){return this.getNavigationRoot();};
t.prototype._startItemNavigation=function(i){if(!D.system.desktop){return;}var e=this.getDomRef();if(!this.getShowNoData()&&!this.getVisibleItems().length&&e){e.classList.add("sapMListPreventFocus");this._destroyItemNavigation();return;}if(e){e.classList.remove("sapMListPreventFocus");}var w=this.getKeyboardMode(),x=m;if(w==x.Edit&&!this.getItems(true).length){return;}var N=this.getNavigationRoot();var T=(w==x.Edit)?-1:0;if(i&&N&&!N.contains(document.activeElement)){this._bItemNavigationInvalidated=true;if(!N.getAttribute("tabindex")){N.tabIndex=T;}return;}if(!this._oItemNavigation){this._oItemNavigation=new b();this._oItemNavigation.setCycling(false);this.addDelegate(this._oItemNavigation);this._setItemNavigationTabIndex(T);this._oItemNavigation.setTableMode(true,true).setColumns(1);this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"]});}this._oItemNavigation.setPageSize(this.getGrowingThreshold());this._oItemNavigation.setRootDomRef(N);this.setNavigationItems(this._oItemNavigation,N);this._bItemNavigationInvalidated=false;};
t.prototype.setNavigationItems=function(i,N){var e=q(N).children(".sapMLIB").get();i.setItemDomRefs(e);if(i.getFocusedIndex()==-1){if(this.getGrowing()&&this.getGrowingDirection()==n.Upwards){i.setFocusedIndex(e.length-1);}else{i.setFocusedIndex(0);}}};
t.prototype.getItemNavigation=function(){return this._oItemNavigation;};
t.prototype._setItemNavigationTabIndex=function(T){if(this._oItemNavigation){this._oItemNavigation.iActiveTabIndex=T;this._oItemNavigation.iTabIndex=T;}};
t.prototype.setKeyboardMode=function(e){this.setProperty("keyboardMode",e,true);if(this.isActive()){var T=(e==m.Edit)?-1:0;this.$("nodata").prop("tabIndex",~T);this.$("listUl").prop("tabIndex",T);this.$("after").prop("tabIndex",T);this._setItemNavigationTabIndex(T);}return this;};
t.prototype.setItemFocusable=function(e){if(!this._oItemNavigation){return;}var i=this._oItemNavigation.getItemDomRefs();var w=i.indexOf(e.getDomRef());if(w>=0){this._oItemNavigation.setFocusedIndex(w);}};
t.prototype.forwardTab=function(F){this._bIgnoreFocusIn=true;this.$(F?"after":"before").trigger("focus");};
t.prototype.onsaptabnext=function(e){if(e.isMarked()||this.getKeyboardMode()==m.Edit){return;}if(e.target.id==this.getId("nodata")){this.forwardTab(true);e.setMarked();}};
t.prototype.onsaptabprevious=function(e){if(e.isMarked()||this.getKeyboardMode()==m.Edit){return;}var T=e.target.id;if(T==this.getId("nodata")){this.forwardTab(false);}else if(T==this.getId("trigger")){this.focusPrevious();e.preventDefault();}};
t.prototype._navToSection=function(F){var T;var i=0;var e=F?1:-1;var w=this._aNavSections.length;this._aNavSections.some(function(y,z){var A=(y?window.document.getElementById(y):null);if(A&&A.contains(document.activeElement)){i=z;return true;}});var x=this.getItemsContainerDomRef();var $=q(document.getElementById(this._aNavSections[i]));if($[0]===x&&this._oItemNavigation){$.data("redirect",this._oItemNavigation.getFocusedIndex());}this._aNavSections.some(function(){i=(i+e+w)%w;T=q(document.getElementById(this._aNavSections[i]));if(T[0]===x&&this._oItemNavigation){var R=T.data("redirect");var y=this._oItemNavigation.getItemDomRefs();var z=y[R]||x.children[0];T=q(z);}if(T.is(":focusable")){T.trigger("focus");return true;}},this);return T;};
t.prototype.onsapshow=function(e){if(e.isMarked()||e.which==K.F4||e.target.id!=this.getId("trigger")&&!q(e.target).hasClass(this.sNavItemClass)){return;}if(this._navToSection(true)){e.preventDefault();e.setMarked();}};
t.prototype.onsaphide=function(e){if(e.isMarked()||e.target.id!=this.getId("trigger")&&!q(e.target).hasClass(this.sNavItemClass)){return;}if(this._navToSection(false)){e.preventDefault();e.setMarked();}};
t.prototype.onkeydown=function(e){var i=(e.which==K.A)&&(e.metaKey||e.ctrlKey);if(e.isMarked()||!i||!q(e.target).hasClass(this.sNavItemClass)||this.bPreventMassSelection){return;}e.preventDefault();if(this.getMode()!==p.MultiSelect){return;}if(this.isAllSelectableSelected()){this.removeSelections(false,true);}else{this.selectAll(true);}e.setMarked();};
t.prototype.onmousedown=function(e){if(this._bItemNavigationInvalidated){this._startItemNavigation();}if(e.shiftKey&&this._mRangeSelection&&e.srcControl.getId().includes("-selectMulti")){e.preventDefault();}};
t.prototype.focusPrevious=function(){if(!this._oItemNavigation){return;}var N=this._oItemNavigation.getItemDomRefs();var i=this._oItemNavigation.getFocusedIndex();var $=q(N[i]);var R=$.control(0)||{};var T=R.getTabbables?R.getTabbables():$.find(":sapTabbable");var F=T.eq(-1).add($).eq(-1);this.bAnnounceDetails=true;F.trigger("focus");};
t.prototype.onfocusin=function(e){if(this._bIgnoreFocusIn){this._bIgnoreFocusIn=false;e.stopImmediatePropagation(true);return;}if(this._bItemNavigationInvalidated){this._startItemNavigation();}var T=e.target;if(T.id==this.getId("nodata")){this.updateInvisibleText(this.getNoDataText(),T);}if(e.isMarked()||!this._oItemNavigation||this.getKeyboardMode()==m.Edit||T.id!=this.getId("after")){return;}this.focusPrevious();e.setMarked();};
t.prototype.onsapfocusleave=function(e){if(this._oItemNavigation&&!this.bAnnounceDetails&&!this.getNavigationRoot().contains(document.activeElement)){this.bAnnounceDetails=true;}};
t.prototype.onItemArrowUpDown=function(e,E){var i=this.getItems(true),w=i.indexOf(e)+(E.type=="sapup"?-1:1),x=i[w];if(x&&x.isGroupHeader()){x=i[w+(E.type=="sapup"?-1:1)];}if(!x){return;}var T=x.getTabbables(),F=e.getTabbables().index(E.target),$=T.eq(T[F]?F:-1);$[0]?$.trigger("focus"):x.focus();E.preventDefault();E.setMarked();};
t.prototype.onItemContextMenu=function(e,E){var i=this.getContextMenu();if(!i){return;}var w=this.fireBeforeOpenContextMenu({listItem:e,column:C.byId(q(E.target).closest(".sapMListTblCell",this.getNavigationRoot()).attr("data-sap-ui-column"))});if(w){E.setMarked();E.preventDefault();var B,x=this.getBindingInfo("items");if(x){B=e.getBindingContext(x.model);i.setBindingContext(B,x.model);}i.openAsContextMenu(E,e);}};
t.prototype.onItemUpDownModifiers=function(i,e,w){if(!this._mRangeSelection||this.bPreventMassSelection){return;}var V=this.getVisibleItems(),x=V.indexOf(i),y=V[x+w];if(!y){if(this._mRangeSelection){this._mRangeSelection=null;}e.setMarked();return;}var z=y.getSelected();if(this._mRangeSelection.direction===undefined){this._mRangeSelection.direction=w;}else if(this._mRangeSelection.direction!==w){if(this._mRangeSelection.index!==V.indexOf(i)){y=i;z=y.getSelected();if(this._mRangeSelection.selected&&z){this.setSelectedItem(y,false,true);return;}}else{this._mRangeSelection.direction=w;}}if(this._mRangeSelection.selected!==z&&y.isSelectable()){this.setSelectedItem(y,this._mRangeSelection.selected,true);}};
t.prototype.isGrouped=function(){var B=this.getBinding("items");return B&&B.isGrouped();};
t.prototype.setContextMenu=function(e){this.setAggregation("contextMenu",e,true);return this;};
t.prototype.destroyContextMenu=function(){this.destroyAggregation("contextMenu",true);return this;};
t.getStickyBrowserSupport=function(){var B=D.browser;return(B.safari||B.chrome||(B.firefox&&B.version>=59)||(B.edge&&B.version>=16));};
t.prototype.getStickyStyleValue=function(){var e=this.getSticky();if(!e||!e.length||!t.getStickyBrowserSupport()){return(this._iStickyValue=0);}var i=0,H=this.getHeaderText(),w=this.getHeaderToolbar(),x=H||(w&&w.getVisible()),y=this.getInfoToolbar(),z=y&&y.getVisible(),A=false;if(this.isA("sap.m.Table")){A=this.getColumns().some(function(B){return B.getVisible()&&B.getHeader();});}e.forEach(function(B){if(B===s.HeaderToolbar&&x){i+=1;}else if(B===s.InfoToolbar&&z){i+=2;}else if(B===s.ColumnHeaders&&A){i+=4;}});return(this._iStickyValue=i);};
t.prototype._handleStickyItemFocus=function(i){if(!this._iStickyValue){return;}var e=l.getScrollDelegate(this,true);if(!e){return;}var T=0,w=0,x=0,y=0,H=0,z=0;if(this._iStickyValue&4){var A=this.getDomRef("tblHeader").firstChild;var B=A.getBoundingClientRect();w=parseInt(B.bottom);T=parseInt(B.height);}if(this._iStickyValue&2){var E=this.getDomRef().querySelector(".sapMListInfoTBarContainer");if(E){var F=E.getBoundingClientRect();y=parseInt(F.bottom);x=parseInt(F.height);}}if(this._iStickyValue&1){var J=this.getDomRef().querySelector(".sapMListHdr");if(J){var M=J.getBoundingClientRect();z=parseInt(M.bottom);H=parseInt(M.height);}}var N=Math.round(i.getBoundingClientRect().top);if(w>N||y>N||z>N){window.requestAnimationFrame(function(){e.scrollToElement(i,0,[0,-T-x-H]);});}};
t.prototype.setHeaderToolbar=function(H){return this._setToolbar("headerToolbar",H);};
t.prototype.setInfoToolbar=function(i){return this._setToolbar("infoToolbar",i);};
t.prototype.scrollToIndex=function(i){var e,R,w,x;x=l.getScrollDelegate(this,true);if(!x){return;}e=this.getVisibleItems();R=e.length;if(typeof i!=='number'||i<-1){i=0;}if(i>=R||i===-1){i=R-1;}w=e[i];if(!w){return;}setTimeout(function(){x.scrollToElement(w.getDomRef(),null,[0,this._getStickyAreaHeight()*-1]);}.bind(this),0);};
t.prototype._getStickyAreaHeight=function(){var e=this.getSticky();if(!(e&&e.length)){return 0;}return e.reduce(function(i,w){var x,y;switch(w){case s.HeaderToolbar:x=this.getHeaderToolbar();y=x&&x.getDomRef()||this.getDomRef("header");break;case s.InfoToolbar:x=this.getInfoToolbar();y=x&&x.getDomRef();break;case s.ColumnHeaders:y=this.getDomRef("tblHeader");break;default:}return i+(y?y.offsetHeight:0);}.bind(this),0);};
t.prototype._setToolbar=function(A,T){var O=this.getAggregation(A);if(O){O.detachEvent("_change",this._onToolbarPropertyChanged,this);}this.setAggregation(A,T);if(T){T.attachEvent("_change",this._onToolbarPropertyChanged,this);}return this;};
t.prototype._onToolbarPropertyChanged=function(e){if(e.getParameter("name")!=="visible"){return;}var O=this._iStickyValue,N=this.getStickyStyleValue();if(O!==N){var i=this.getDomRef();if(i){var w=i.classList;w.toggle("sapMSticky",!!N);w.remove("sapMSticky"+O);w.toggle("sapMSticky"+N,!!N);}}};
return t;});
sap.ui.predefine('sap/m/ListBaseRenderer',["sap/m/library","sap/ui/Device","sap/ui/core/InvisibleText","./ListItemBaseRenderer"],function(l,D,I,L){"use strict";var a=l.ListGrowingDirection;var b=l.ListKeyboardMode;var T=l.ToolbarDesign;var c={apiVersion:2};c.ModeOrder={None:0,Delete:1,MultiSelect:-1,SingleSelect:1,SingleSelectLeft:-1,SingleSelectMaster:0};
c.render=function(r,C){r.openStart("div",C);r.class("sapMList");if(C.getInset()){r.class("sapMListInsetBG");}r.style("width",C.getWidth());if(C.getBackgroundDesign){r.class("sapMListBG"+C.getBackgroundDesign());}var t=C.getTooltip_AsString();if(t){r.attr("title",t);}var s=C.getStickyStyleValue();if(s){r.class("sapMSticky");r.class("sapMSticky"+s);}this.renderContainerAttributes(r,C);r.openEnd();r.renderControl(C.getAggregation("_messageStrip"));var h=C.getHeaderText();var H=C.getHeaderToolbar();if(H){H.setDesign(T.Transparent,true);H.addStyleClass("sapMListHdr");H.addStyleClass("sapMListHdrTBar");H.addStyleClass("sapMTBHeader-CTX");r.renderControl(H);}else if(h){r.openStart("header",C.getId("header"));r.class("sapMListHdr").class("sapMListHdrText").openEnd();r.text(h);r.close("header");}var o=C.getInfoToolbar();if(o){o.setDesign(T.Info,true);o.addStyleClass("sapMListInfoTBar");r.openStart("div").class("sapMListInfoTBarContainer").openEnd();r.renderControl(o);r.close("div");}var d=C.getItems(),S=C.getShowNoData(),R=C.shouldRenderItems()&&d.length,e=C.getKeyboardMode()==b.Edit?-1:0,u=C.getGrowingDirection()==a.Upwards&&C.getGrowing();if(u){this.renderGrowing(r,C);}this.renderDummyArea(r,C,"before",-1);this.renderListStartAttributes(r,C);r.class("sapMListUl");if(C._iItemNeedsHighlight){r.class("sapMListHighlight");}if(R||S){r.attr("tabindex",e);}r.class("sapMListShowSeparators"+C.getShowSeparators());r.class("sapMListMode"+C.getMode());if(C._iItemNeedsNavigated){r.class("sapMListNavigated");}r.openEnd();this.renderListHeadAttributes(r,C);if(R){if(u){d.reverse();}for(var i=0;i<d.length;i++){r.renderControl(d[i]);}}var v=C.getVisibleItems().length>0;if(S&&(!R||!v)){this.renderNoData(r,C);}this.renderListEndAttributes(r,C);this.renderDummyArea(r,C,"after",e);if(!u){this.renderGrowing(r,C);}if(C.getFooterText()){r.openStart("footer",C.getId("footer")).class("sapMListFtr").openEnd();r.text(C.getFooterText());r.close("footer");}r.close("div");};
c.renderContainerAttributes=function(r,C){};
c.renderListHeadAttributes=function(r,C){};
c.renderListStartAttributes=function(r,C){r.openStart("ul",C.getId("listUl"));r.class("sapMListItems");C.addNavSection(C.getId("listUl"));r.accessibilityState(C,this.getAccessibilityState(C));};
c.getAriaRole=function(C){return"listbox";};
c.getNoDataAriaRole=function(){return null;};
c.getAriaLabelledBy=function(C){var h=C.getHeaderToolbar();if(h){var t=h.getTitleControl();if(t){var s=t.getId();if(C.getAriaLabelledBy().indexOf(s)===-1){return s;}}}else if(C.getHeaderText()){return C.getId("header");}};
c.getAriaDescribedBy=function(C){if(C.getFooterText()){return C.getId("footer");}};
c.getAccessibilityState=function(C){var r=this.getAriaRole(C);return{role:r,multiselectable:(r&&C._bSelectionMode)?C.getMode()=="MultiSelect":undefined,labelledby:{value:this.getAriaLabelledBy(C),append:true},describedby:{value:this.getAriaDescribedBy(C),append:true}};};
c.renderListEndAttributes=function(r,C){r.close("ul");};
c.renderNoData=function(r,C){r.openStart("li",C.getId("nodata"));r.attr("tabindex",C.getKeyboardMode()==b.Navigation?-1:0);var A=this.getNoDataAriaRole();if(A){r.attr("role",A);}r.class("sapMLIB").class("sapMListNoData").class("sapMLIBTypeInactive");L.addFocusableClasses.call(L,r);r.openEnd();r.openStart("div",C.getId("nodata-text")).class("sapMListNoDataText").openEnd();r.text(C.getNoDataText(true));r.close("div");r.close("li");};
c.renderDummyArea=function(r,C,A,t){r.openStart("div",C.getId(A)).attr("tabindex",t);if(D.system.desktop){r.class("sapMListDummyArea");}r.openEnd().close("div");};
c.renderGrowing=function(r,C){var g=C._oGrowingDelegate;if(g){g.render(r);}};
c.getAriaAnnouncement=function(B){return I.getStaticId("sap.m",B);};
return c;},true);
sap.ui.predefine('sap/m/ListItemBase',["sap/ui/base/DataType","sap/ui/events/KeyCodes","sap/ui/model/BindingMode","sap/ui/Device","sap/ui/core/library","sap/ui/core/Control","sap/ui/core/IconPool","sap/ui/core/Icon","sap/ui/core/InvisibleText","sap/ui/core/theming/Parameters","./library","./Button","./CheckBox","./RadioButton","./ListItemBaseRenderer","sap/base/strings/capitalize","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/Selectors"],function(D,K,B,a,c,C,I,b,d,T,l,e,f,R,L,g,q){"use strict";var h=l.ListKeyboardMode;var i=l.ListMode;var j=l.ListType;var k=l.ButtonType;var M=c.MessageType;
var m=C.extend("sap.m.ListItemBase",{metadata:{library:"sap.m",properties:{type:{type:"sap.m.ListType",group:"Misc",defaultValue:j.Inactive},visible:{type:"boolean",group:"Appearance",defaultValue:true},unread:{type:"boolean",group:"Misc",defaultValue:false},selected:{type:"boolean",defaultValue:false},counter:{type:"int",group:"Misc",defaultValue:null},highlight:{type:"string",group:"Appearance",defaultValue:"None"},highlightText:{type:"string",group:"Misc",defaultValue:""},navigated:{type:"boolean",group:"Appearance",defaultValue:false}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{tap:{deprecated:true},detailTap:{deprecated:true},press:{},detailPress:{}},designtime:"sap/m/designtime/ListItemBase.designtime"}});
m.getAccessibilityText=function(o,n){if(!o||!o.getVisible||!o.getVisible()){return"";}var A;if(o.getAccessibilityInfo){A=o.getAccessibilityInfo();}if(!A||!o.getAccessibilityInfo){A=this.getDefaultAccessibilityInfo(o.getDomRef());}A=q.extend({type:"",description:"",children:[]},A);var p=sap.ui.getCore().getLibraryResourceBundle("sap.m"),t=A.type+" "+A.description+" ",s=o.getTooltip_AsString();if(A.enabled===false){t+=p.getText("CONTROL_DISABLED")+" ";}if(A.editable===false){t+=p.getText("CONTROL_READONLY")+" ";}if(!A.type&&s&&t.indexOf(s)==-1){t=s+" "+t;}A.children.forEach(function(r){t+=m.getAccessibilityText(r)+" ";});t=t.trim();if(n&&!t){t=p.getText("CONTROL_EMPTY");}return t;};
m.getDefaultAccessibilityInfo=function(o){if(!o){return null;}var N=window.Node,n=window.NodeFilter,t=document.createTreeWalker(o,n.SHOW_TEXT+n.SHOW_ELEMENT,function(r){if(r.type===N.ELEMENT_NODE){if(r.classList.contains("sapUiInvisibleText")){return n.FILTER_SKIP;}if(r.getAttribute("aria-hidden")=="true"||r.style.visibility=="hidden"||r.style.display=="none"){return n.FILTER_REJECT;}return n.FILTER_SKIP;}return n.FILTER_ACCEPT;},false);var p=[];while(t.nextNode()){var r=t.currentNode;if(r.nodeType===N.TEXT_NODE){var s=(r.nodeValue||"").trim();if(s){p.push(s);}}}return{description:p.join(" ")};};
m.prototype.DetailIconURI=I.getIconURI("edit");m.prototype.NavigationIconURI=I.getIconURI("slim-arrow-right");m.prototype.TagName="li";
m.prototype.init=function(){this._active=false;this._bGroupHeader=false;this._bNeedsHighlight=false;this._bNeedsNavigated=false;};
m.prototype.onAfterRendering=function(){this.informList("DOMUpdate",true);this._checkHighlight();this._checkNavigated();};
m.prototype.invalidate=function(){if(!this.bOutput){return;}C.prototype.invalidate.apply(this,arguments);};
m.prototype.getBindingContextPath=function(s){var o=this.getList();if(o&&!s){s=(o.getBindingInfo("items")||{}).model;}var n=this.getBindingContext(s);if(n){return n.getPath();}};
m.prototype.isSelectedBoundTwoWay=function(){var o=this.getBinding("selected");if(o&&o.getBindingMode()==B.TwoWay){return true;}};
m.prototype.getList=function(){var p=this.getParent();if(p&&p.isA("sap.m.ListBase")){return p;}};
m.prototype.getListProperty=function(p,F){var o=this.getList();if(o){p=g(p);return o["get"+p]();}return F;};
m.prototype.informList=function(E,p,P){var o=this.getList();if(o){var s="onItem"+E;if(o[s]){o[s](this,p,P);}}};
m.prototype.informSelectedChange=function(s){var o=this.getList();if(o){o.onItemSelectedChange(this,s);this.bSelectedDelayed=undefined;}else{this.bSelectedDelayed=s;}};
m.prototype.getAccessibilityType=function(o){return o.getText("ACC_CTR_TYPE_OPTION");};
m.prototype.getGroupAnnouncement=function(){return this.$().prevAll(".sapMGHLI:first").text();};
m.prototype.getAccessibilityDescription=function(o){var O=[],t=this.getType(),H=this.getHighlight(),s=this.getTooltip_AsString();if(this.getSelected()){O.push(o.getText("LIST_ITEM_SELECTED"));}if(H!==M.None){var n=this.getHighlightText();if(H in M&&!n){n=o.getText("LIST_ITEM_STATE_"+H.toUpperCase());}O.push(n);}if(this.getUnread()&&this.getListProperty("showUnread")){O.push(o.getText("LIST_ITEM_UNREAD"));}if(this.getCounter()){O.push(o.getText("LIST_ITEM_COUNTER",this.getCounter()));}if(t==j.Navigation){O.push(o.getText("LIST_ITEM_NAVIGATION"));}else{if(t==j.Detail||t==j.DetailAndActive){O.push(o.getText("LIST_ITEM_DETAIL"));}if(t==j.Active||t==j.DetailAndActive){O.push(o.getText("LIST_ITEM_ACTIVE"));}}var G=this.getGroupAnnouncement()||"";if(G){O.push(G);}if(this.getContentAnnouncement){O.push((this.getContentAnnouncement(o)||"").trim());}if(s){O.push(s);}if(this.getNavigated()){O.push(o.getText("LIST_ITEM_NAVIGATED"));}return O.join(" . ");};
m.prototype.getAccessibilityInfo=function(){var o=sap.ui.getCore().getLibraryResourceBundle("sap.m");return{type:this.getAccessibilityType(o),description:this.getAccessibilityDescription(o),focusable:true};};
m.prototype.getMode=function(){return this.getListProperty("mode","");};
m.prototype.updateAccessibilityState=function(A){var t=this.$();if(!t.length){return;}var $=t.parent().children(".sapMLIB");t.attr(q.extend({"aria-setsize":$.length,"aria-posinset":$.index(t)+1},A));};
m.prototype.getDeleteControl=function(n){if(!n||this._oDeleteControl){return this._oDeleteControl;}if(!this.DeleteIconURI){m.prototype.DeleteIconURI=I.getIconURI(T.get("_sap_m_ListItemBase_DeleteIcon"));}this._oDeleteControl=new e({id:this.getId()+"-imgDel",icon:this.DeleteIconURI,type:k.Transparent,tooltip:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("LIST_ITEM_DELETE")}).addStyleClass("sapMLIBIconDel sapMLIBSelectD").setParent(this,null,true).attachPress(function(E){this.informList("Delete");},this);this._oDeleteControl._bExcludeFromTabChain=true;this._oDeleteControl.getEnabled=function(){return true;};return this._oDeleteControl;};
m.prototype.onThemeChanged=function(){m.prototype.DeleteIconURI=I.getIconURI(T.get("_sap_m_ListItemBase_DeleteIcon"));if(this._oDeleteControl){this._oDeleteControl.setIcon(this.DeleteIconURI);}};
m.prototype.getDetailControl=function(n){if(!n||this._oDetailControl){return this._oDetailControl;}this._oDetailControl=new e({id:this.getId()+"-imgDet",icon:this.DetailIconURI,type:k.Transparent,tooltip:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("LIST_ITEM_EDIT")}).addStyleClass("sapMLIBType sapMLIBIconDet").setParent(this,null,true).attachPress(function(){this.fireDetailTap();this.fireDetailPress();},this);this._oDetailControl._bExcludeFromTabChain=true;this._oDetailControl.getEnabled=function(){return true;};return this._oDetailControl;};
m.prototype.getNavigationControl=function(n){if(!n||this._oNavigationControl){return this._oNavigationControl;}this._oNavigationControl=new b({id:this.getId()+"-imgNav",src:this.NavigationIconURI,useIconTooltip:false,noTabStop:true}).setParent(this,null,true).addStyleClass("sapMLIBType sapMLIBImgNav");return this._oNavigationControl;};
m.prototype.getSingleSelectControl=function(n){if(!n||this._oSingleSelectControl){n&&this._oSingleSelectControl.setSelected(this.getSelected());return this._oSingleSelectControl;}this._oSingleSelectControl=new R({id:this.getId()+"-selectSingle",groupName:this.getListProperty("id")+"_selectGroup",activeHandling:false,selected:this.getSelected(),ariaLabelledBy:d.getStaticId("sap.m","LIST_ITEM_SELECTION")}).addStyleClass("sapMLIBSelectS").setParent(this,null,true).setTabIndex(-1).attachSelect(function(E){var s=E.getParameter("selected");this.setSelected(s);this.informList("Select",s);},this);this._oSingleSelectControl.getEnabled=function(){return true;};return this._oSingleSelectControl;};
m.prototype.getMultiSelectControl=function(n){if(!n||this._oMultiSelectControl){n&&this._oMultiSelectControl.setSelected(this.getSelected());return this._oMultiSelectControl;}this._oMultiSelectControl=new f({id:this.getId()+"-selectMulti",activeHandling:false,selected:this.getSelected(),ariaLabelledBy:d.getStaticId("sap.m","LIST_ITEM_SELECTION")}).addStyleClass("sapMLIBSelectM").setParent(this,null,true).setTabIndex(-1).addEventDelegate({onkeydown:function(E){this.informList("KeyDown",E);},onkeyup:function(E){this.informList("KeyUp",E);}},this).attachSelect(function(E){var s=E.getParameter("selected");this.setSelected(s);this.informList("Select",s);},this);this._oMultiSelectControl.getEnabled=function(){return true;};return this._oMultiSelectControl;};
m.prototype.getModeControl=function(n){var s=this.getMode();if(!s||s==i.None){return;}if(s==i.Delete){return this.getDeleteControl(n);}if(s==i.MultiSelect){return this.getMultiSelectControl(n);}return this.getSingleSelectControl(n);};
m.prototype.getTypeControl=function(n){var t=this.getType();if(t==j.Detail||t==j.DetailAndActive){return this.getDetailControl(n);}if(t==j.Navigation){return this.getNavigationControl(n);}};
m.prototype.destroyControls=function(n){n.forEach(function(s){s="_o"+s+"Control";if(this[s]){this[s].destroy("KeepDom");this[s]=null;}},this);};
m.prototype.isActionable=function(){return this.isIncludedIntoSelection()||(this.getType()!=j.Inactive&&this.getType()!=j.Detail);};
m.prototype.exit=function(){this._oLastFocused=null;this._checkHighlight(false);this._checkNavigated(false);this.setActive(false);this.destroyControls(["Delete","SingleSelect","MultiSelect","Detail","Navigation"]);};
m.prototype.setHighlight=function(v){if(v==null){v=M.None;}else if(!D.getType("sap.ui.core.MessageType").isValid(v)&&!D.getType("sap.ui.core.IndicationColor").isValid(v)){throw new Error('"'+v+'" is not a value of the enums sap.ui.core.MessageType or sap.ui.core.IndicationColor for property "highlight" of '+this);}return this.setProperty("highlight",v);};
m.prototype.isSelectable=function(){var s=this.getMode();return!(s==i.None||s==i.Delete);};
m.prototype.getSelected=function(){if(this.isSelectable()){return this.getProperty("selected");}return false;};
m.prototype.isSelected=m.prototype.getSelected;
m.prototype.setSelected=function(s,n){s=this.validateProperty("selected",s);if(!this.isSelectable()||s==this.getSelected()){return this;}if(!n){this.informSelectedChange(s);}var S=this.getModeControl();if(S){S.setSelected(s);}this.updateSelectedDOM(s,this.$());this.setProperty("selected",s,true);return this;};
m.prototype.updateSelectedDOM=function(s,t){t.toggleClass("sapMLIBSelected",s);t.attr("aria-selected",s);};
m.prototype.setParent=function(p){C.prototype.setParent.apply(this,arguments);if(!p){this._bGroupHeader=false;return;}this.informList("Inserted",this.bSelectedDelayed);return this;};
m.prototype.setBindingContext=function(){C.prototype.setBindingContext.apply(this,arguments);this.informList("BindingContextSet");return this;};
m.prototype.isGroupHeader=function(){return this._bGroupHeader;};
m.prototype.isIncludedIntoSelection=function(){if(!this.isSelectable()){return false;}var s=this.getMode();return s==i.SingleSelectMaster||(this.getListProperty("includeItemInSelection")&&(s==i.SingleSelectLeft||s==i.SingleSelect||s==i.MultiSelect));};
m.prototype._checkHighlight=function(n){if(n==undefined){n=(this.getVisible()&&this.getHighlight()!=M.None);}if(this._bNeedsHighlight!=n){this._bNeedsHighlight=n;this.informList("HighlightChange",n);}};
m.prototype._checkNavigated=function(n){if(n==undefined){n=(this.getVisible()&&this.getNavigated());}if(this._bNeedsNavigated!=n){this._bNeedsNavigated=n;this.informList("NavigatedChange",n);}};
m.prototype.hasActiveType=function(){var t=this.getType();return(t==j.Active||t==j.Navigation||t==j.DetailAndActive);};
m.prototype.setActive=function(A){if(A==this._active){return this;}if(A&&this.getListProperty("activeItem")){return this;}var t=this.$();this._active=A;this._activeHandling(t);if(this.getType()==j.Navigation){this._activeHandlingNav(t);}if(A){this._activeHandlingInheritor(t);}else{this._inactiveHandlingInheritor(t);}this.informList("ActiveChange",A);};
m.detectTextSelection=function(o){var s=window.getSelection(),t=s.toString().replace("\n","");return t&&q.contains(o,s.focusNode);};
m.prototype.ontap=function(E){if(this._eventHandledByControl){return E.setMarked();}if(m.detectTextSelection(this.getDomRef())){return;}if(this.isIncludedIntoSelection()){if(this.getMode()==i.MultiSelect){this.setSelected(!this.getSelected());this.informList("Select",this.getSelected());}else if(!this.getSelected()){this.setSelected(true);this.informList("Select",true);}}else if(this.hasActiveType()){window.clearTimeout(this._timeoutIdStart);window.clearTimeout(this._timeoutIdEnd);this.setActive(true);if(a.os.ios){this.focus();}setTimeout(function(){this.setActive(false);}.bind(this),180);setTimeout(function(){this.fireTap();this.firePress();}.bind(this),0);}this.informList("Press",E.srcControl);};
m.prototype.ontouchstart=function(E){this._eventHandledByControl=E.isMarked();var t=E.targetTouches[0];this._touchedY=t.clientY;this._touchedX=t.clientX;if(this._eventHandledByControl||E.touches.length!=1||!this.hasActiveType()){return;}this._timeoutIdStart=setTimeout(function(){this.setActive(true);}.bind(this),100);};
m.prototype.ontouchmove=function(E){if((this._active||this._timeoutIdStart)&&(Math.abs(this._touchedY-E.targetTouches[0].clientY)>10||Math.abs(this._touchedX-E.targetTouches[0].clientX)>10)){clearTimeout(this._timeoutIdStart);this._timeoutIdStart=null;this._timeoutIdEnd=null;this.setActive(false);}};
m.prototype.ontouchend=function(E){if(this.hasActiveType()){this._timeoutIdEnd=setTimeout(function(){this.setActive(false);}.bind(this),100);}};
m.prototype.ontouchcancel=m.prototype.ontouchend;m.prototype.ondragend=m.prototype.ontouchend;
m.prototype._activeHandlingNav=function(){};
m.prototype._activeHandlingInheritor=function(){};
m.prototype._inactiveHandlingInheritor=function(){};
m.prototype._activeHandling=function(t){t.toggleClass("sapMLIBActive",this._active);if(a.system.desktop&&this.isActionable()){t.toggleClass("sapMLIBHoverable",!this._active);}};
m.prototype.onsapspace=function(E){if(E.srcControl!==this){return;}E.preventDefault();if(E.isMarked()||!this.isSelectable()){return;}if(this.getMode()==i.MultiSelect){this.setSelected(!this.getSelected());this.informList("Select",this.getSelected());}else if(!this.getSelected()){this.setSelected(true);this.informList("Select",true);}E.setMarked();};
m.prototype.onsapenter=function(E){var o=this.getList();if(E.isMarked()||!o){return;}if(E.srcControl!==this&&o.getKeyboardMode()==h.Edit){o.setKeyboardMode(h.Navigation);this._switchFocus(E);return;}if(E.srcControl!==this){return;}if(this.isIncludedIntoSelection()){this.onsapspace(E);}else if(this.hasActiveType()){E.setMarked();this.setActive(true);setTimeout(function(){this.setActive(false);}.bind(this),180);setTimeout(function(){this.fireTap();this.firePress();}.bind(this),0);}o.onItemPress(this,E.srcControl);};
m.prototype.onsapdelete=function(E){if(E.isMarked()||E.srcControl!==this||this.getMode()!=i.Delete){return;}this.informList("Delete");E.preventDefault();E.setMarked();};
m.prototype._switchFocus=function(E){var o=this.getList();if(!o){return;}var t=this.getTabbables();if(E.srcControl!==this){o._iLastFocusPosOfItem=t.index(E.target);this.focus();}else if(t.length){var F=o._iLastFocusPosOfItem||0;F=t[F]?F:-1;t.eq(F).trigger("focus");}E.preventDefault();E.setMarked();};
m.prototype.onkeydown=function(E){if(E.isMarked()){return;}if(E.which==K.F7){this._switchFocus(E);return;}if(E.which==K.F2){if(E.srcControl===this&&this.getType().indexOf("Detail")==0&&this.hasListeners("detailPress")||this.hasListeners("detailTap")){this.fireDetailTap();this.fireDetailPress();E.preventDefault();E.setMarked();}else{var o=this.getList();if(o){this.$().prop("tabIndex",-1);o.setKeyboardMode(o.getKeyboardMode()==h.Edit?h.Navigation:h.Edit);this._switchFocus(E);}}}if(E.srcControl!==this){return;}this.informList("KeyDown",E);};
m.prototype.onkeyup=function(E){if(E.isMarked()||E.srcControl!==this){return;}this.informList("KeyUp",E);};
m.prototype.onsapupmodifiers=function(E){if(E.isMarked()||E.srcControl!==this){return;}this.informList("UpDownModifiers",E,-1);};
m.prototype.onsapdownmodifiers=function(E){if(E.isMarked()||E.srcControl!==this){return;}this.informList("UpDownModifiers",E,1);};
m.prototype.getTabbables=function(){return this.$().find(":sapTabbable");};
m.prototype.onsaptabnext=function(E){var o=this.getList();if(!o||E.isMarked()||o.getKeyboardMode()==h.Edit){return;}var n=this.getTabbables().get(-1)||this.getDomRef();if(E.target===n){o.forwardTab(true);E.setMarked();}};
m.prototype.onsaptabprevious=function(E){var o=this.getList();if(!o||E.isMarked()||o.getKeyboardMode()==h.Edit){return;}if(E.target===this.getDomRef()){o.forwardTab(false);E.setMarked();}};
m.prototype.onfocusin=function(E){var o=this.getList();if(!o||E.isMarked()){return;}this.informList("FocusIn",E.srcControl);if(E.srcControl===this){return;}if(o.getKeyboardMode()==h.Edit||!q(E.target).is(":sapFocusable")){return;}setTimeout(o["setItemFocusable"].bind(o,this),0);E.setMarked();};
m.prototype.onsapup=function(E){if(E.isMarked()||E.srcControl===this||this.getListProperty("keyboardMode")===h.Navigation){return;}this.informList("ArrowUpDown",E);};
m.prototype.oncontextmenu=function(E){if(this._bGroupHeader){return;}if(q(document.activeElement).is(":focusable")&&document.activeElement!==this.getDomRef()&&E.srcControl!==this.getModeControl()){return;}this.informList("ContextMenu",E);};
m.prototype.onsapdown=m.prototype.onsapup;return m;});
sap.ui.predefine('sap/m/ListItemBaseRenderer',["./library","sap/ui/core/Core","sap/ui/Device","sap/ui/core/InvisibleText","sap/ui/core/InvisibleRenderer"],function(l,C,D,I,a){"use strict";var L=l.ListType;var b=l.ListMode;var c={apiVersion:2};
c.renderInvisible=function(r,o){a.render(r,o,o.TagName);};
c.renderHighlight=function(r,o){var h=o.getHighlight();if(h=="None"){return;}r.openStart("div");r.class("sapMLIBHighlight");r.class("sapMLIBHighlight"+h);r.openEnd();r.close("div");};
c.isModeMatched=function(m,o){var O=(sap.ui.require("sap/m/ListBaseRenderer")||{}).ModeOrder||{};return O[m]==o;};
c.renderMode=function(r,o,O){var m=o.getMode();if(!this.isModeMatched(m,O)){return;}var M=o.getModeControl(true);if(M){this.renderModeContent(r,o,M);}};
c.renderModeContent=function(r,o,m){this.decorateMode(m,o);r.renderControl(m);};
c.decorateMode=function(m,o){m.removeStyleClass("sapMLIBSelectAnimation sapMLIBUnselectAnimation");if(!C.getConfiguration().getAnimation()||!o.getListProperty("modeAnimationOn")){return;}var M=o.getMode(),s=o.getListProperty("lastMode");if(!s||s==M){return;}if(M==b.None){m.addStyleClass("sapMLIBUnselectAnimation");}else{m.addStyleClass("sapMLIBSelectAnimation");}};
c.renderCounter=function(r,o){var i=o.getCounter();if(i){this.renderCounterContent(r,o,i);}};
c.renderCounterContent=function(r,o,i){r.openStart("div",o.getId()+"-counter");r.attr("aria-label",C.getLibraryResourceBundle("sap.m").getText("LIST_ITEM_COUNTER",i));r.class("sapMLIBCounter");r.openEnd();r.text(i);r.close("div");};
c.renderType=function(r,o){var t=o.getTypeControl(true);if(t){r.renderControl(t);}};
c.openItemTag=function(r,o){r.openStart(o.TagName,o);};
c.closeItemTag=function(r,o){r.close(o.TagName);};
c.renderTabIndex=function(r,o){r.attr("tabindex","-1");};
c.renderTooltip=function(r,o){var t=o.getTooltip_AsString();if(t){r.attr("title",t);}};
c.addFocusableClasses=function(r,o){if(D.system.desktop){r.class("sapMLIBFocusable");this.addLegacyOutlineClass(r,o);}};
c.addLegacyOutlineClass=function(r,o){if(D.browser.msie||D.browser.edge){r.class("sapMLIBLegacyOutline");}};
c.getAriaAnnouncement=function(k,B){return I.getStaticId("sap.m",B||"LIST_ITEM_"+k.toUpperCase());};
c.getAriaRole=function(o){return"option";};
c.getAriaLabelledBy=function(o){if(!o.getContentAnnouncement&&o.getAriaLabelledBy().length){return o.getId();}};
c.getAriaDescribedBy=function(o){if(o.getContentAnnouncement){return"";}var d=[],t=o.getType();if(o.getListProperty("showUnread")&&o.getUnread()){d.push(this.getAriaAnnouncement("unread"));}if(o.getMode()==b.Delete){d.push(this.getAriaAnnouncement("delete"));}if(t==L.Navigation){d.push(this.getAriaAnnouncement("navigation"));}else{if(t==L.Detail||t==L.DetailAndActive){d.push(this.getAriaAnnouncement("detail"));}if(t==L.Active||t==L.DetailAndActive){d.push(this.getAriaAnnouncement("active"));}}return d.join(" ");};
c.getAccessibilityState=function(o){var A=this.getAriaLabelledBy(o),s=this.getAriaDescribedBy(o),m={role:this.getAriaRole(o)};if(o.isSelectable()){m.selected=o.getProperty("selected");}if(A){m.labelledby={value:A.trim(),append:true};}if(s){m.describedby={value:s.trim(),append:true};}return m;};
c.renderLIContent=function(r,o){};
c.renderLIAttributes=function(r,o){};
c.renderContentFormer=function(r,o){this.renderHighlight(r,o);this.renderMode(r,o,-1);};
c.renderContentLatter=function(r,o){this.renderCounter(r,o);this.renderType(r,o);this.renderMode(r,o,1);this.renderNavigated(r,o);};
c.renderLIContentWrapper=function(r,o){r.openStart("div",o.getId()+"-content").class("sapMLIBContent").openEnd();this.renderLIContent(r,o);r.close("div");};
c.renderNavigated=function(r,o){if(!o.getNavigated()){return;}r.openStart("div");r.class("sapMLIBNavigated");r.openEnd();r.close("div");};
c.render=function(r,o){if(!o.getVisible()){this.renderInvisible(r,o);return false;}this.openItemTag(r,o);r.class("sapMLIB");r.class("sapMLIB-CTX");r.class("sapMLIBShowSeparator");r.class("sapMLIBType"+o.getType());if(D.system.desktop&&o.isActionable()){r.class("sapMLIBActionable");r.class("sapMLIBHoverable");}if(o.getSelected()){r.class("sapMLIBSelected");}if(o.getListProperty("showUnread")&&o.getUnread()){r.class("sapMLIBUnread");}this.addFocusableClasses(r,o);this.renderTooltip(r,o);this.renderTabIndex(r,o);if(C.getConfiguration().getAccessibility()){r.accessibilityState(o,this.getAccessibilityState(o));}this.renderLIAttributes(r,o);r.openEnd();this.renderContentFormer(r,o);this.renderLIContentWrapper(r,o);this.renderContentLatter(r,o);this.closeItemTag(r,o);};
return c;},true);
sap.ui.predefine('sap/m/ListRenderer',["sap/ui/core/Renderer","./ListBaseRenderer"],function(R,L){"use strict";var a=R.extend(L);a.apiVersion=2;
a.getNoDataAriaRole=function(){return"option";};
return a;},true);
sap.ui.predefine('sap/m/MaskEnabler',['sap/ui/core/Control','./InputBase','sap/ui/Device','sap/ui/core/library',"sap/ui/events/KeyCodes","sap/base/Log","sap/ui/thirdparty/jquery","sap/m/MaskInputRule","sap/ui/dom/jquery/cursorPos"],function(C,I,D,c,K,L,q,M){"use strict";var T=c.TextDirection;var a=function(){var E='^';this.init=a.init=function(){I.prototype.init.call(this);this._iCaretTimeoutId=null;this._iUserInputStartPosition=null;this._iMaskLength=null;this._sOldInputValue=null;this._oRules=null;this._oTempValue=null;this._bSkipSetupMaskVariables=null;this._setDefaultRules();this._setupMaskVariables();};this.exit=a.exit=function(){this._iCaretTimeoutId=null;this._iUserInputStartPosition=null;this._iMaskLength=null;this._sOldInputValue=null;this._oRules=null;this._oTempValue=null;this._bSkipSetupMaskVariables=null;};this.onBeforeRendering=function(){if(this._isMaskEnabled()){var v=this._validateDependencies();if(v){L.warning("Invalid mask input: "+v);}}I.prototype.onBeforeRendering.apply(this,arguments);};this.onAfterRendering=function(){I.prototype.onAfterRendering.apply(this,arguments);};this.onfocusin=a.onfocusin=function(e){this._sOldInputValue=this._getInputValue();I.prototype.onfocusin.apply(this,arguments);if(this._isMaskEnabled()){if(!this._oTempValue.differsFromOriginal()||!this._isValidInput(this._sOldInputValue)){this._applyMask();}this._positionCaret(true);}};this.onfocusout=function(e){if(this._isMaskEnabled()){this.bFocusoutDueRendering=this.bRenderingPhase;this.removeStyleClass("sapMFocus");q(document).off('.sapMIBtouchstart');if(this.bRenderingPhase){return;}this.closeValueStateMessage();this._inputCompletedHandler();}else{this._inputCompletedHandlerNoMask();I.prototype.onfocusout.apply(this,arguments);}};this.oninput=function(e){if(this._isChromeOnAndroid()){this._onInputForAndroidHandler(e);return;}I.prototype.oninput.apply(this,arguments);if(this._isMaskEnabled()){this._applyMask();this._positionCaret(false);}};this.onkeypress=function(e){if(this._isMaskEnabled()){this._keyPressHandler(e);}};this.onkeydown=a.onkeydown=function(e){if(this._isMaskEnabled()){var k=this._parseKeyBoardEvent(e);I.prototype.onkeydown.apply(this,arguments);this._keyDownHandler(e,k);}else{var k=this._parseKeyBoardEvent(e);if(k.bEnter){this._inputCompletedHandlerNoMask();}I.prototype.onkeydown.apply(this,arguments);}};this.onsapenter=function(e){};this.onsapfocusleave=function(e){};this.setValue=a.setValue=function(v){v=this.validateProperty('value',v);I.prototype.setValue.call(this,v);this._sOldInputValue=v;if(this._isMaskEnabled()){if(!this._oTempValue){this._setupMaskVariables();}if(this._oTempValue._aInitial.join('')!==v){this._applyRules(v);}}return this;};this.addAggregation=function(A,o,s){if(A==="rules"){if(!this._validateRegexAgainstPlaceHolderSymbol(o)){return this;}this._removeRuleWithSymbol(o.getMaskFormatSymbol());C.prototype.addAggregation.apply(this,arguments);if(!this._bSkipSetupMaskVariables){this._setupMaskVariables();}return this;}return C.prototype.addAggregation.apply(this,arguments);};this.insertAggregation=function(A,o,i,s){if(A==="rules"){if(!this._validateRegexAgainstPlaceHolderSymbol(o)){return this;}this._removeRuleWithSymbol(o.getMaskFormatSymbol());C.prototype.insertAggregation.apply(this,arguments);this._setupMaskVariables();return this;}return C.prototype.insertAggregation.apply(this,arguments);};this._validateRegexAgainstPlaceHolderSymbol=function(r){if(new RegExp(r.getRegex()).test(this.getPlaceholderSymbol())){L.error("Rejecting input mask rule because it includes the currently set placeholder symbol.");return false;}return true;};this.setPlaceholderSymbol=function(s){var S;if(!/^.$/i.test(s)){L.error("Invalid placeholder symbol string given");return this;}S=this.getRules().some(function(r){return new RegExp(r.getRegex()).test(s);});if(S){L.error("Rejecting placeholder symbol because it is included as a regex in an existing mask input rule.");}else{this.setProperty("placeholderSymbol",s);this._setupMaskVariables();}return this;};this.setMask=function(m){if(!m){var e="Setting an empty mask is pointless. Make sure you set it with a non-empty value.";L.warning(e);return this;}this.setProperty("mask",m,true);this._setupMaskVariables();return this;};this._isCharAllowed=function(s,i){return this._oRules.applyCharAt(s,i);};this._feedReplaceChar=function(s,p,e){return s;};this._inputCompletedHandlerNoMask=function(){var v=this._getInputValue();if(this._sOldInputValue!==v){I.prototype.setValue.call(this,this._getAlteredUserInputValue?this._getAlteredUserInputValue(v):v);this._sOldInputValue=v;if(this.onChange&&!this.onChange({value:v})){this.fireChangeEvent(v);}}};var b=function(e){this._aInitial=e.slice(0);this._aContent=e;};b.prototype.setCharAt=function(s,p){this._aContent[p]=s;};b.prototype.charAt=function(p){return this._aContent[p];};b.prototype.toString=function(){return this._aContent.join('');};b.prototype.differsFromOriginal=function(){return this.differsFrom(this._aInitial);};b.prototype.differsFrom=function(v){var i=0;if(v.length!==this._aContent.length){return true;}for(;i<v.length;i++){if(v[i]!==this._aContent[i]){return true;}}return false;};b.prototype.getSize=function(){return this._aContent.length;};var d=function(r){this._aRules=r;};d.prototype.nextTo=function(i){if(typeof i==="undefined"){i=-1;}do{i++;}while(i<this._aRules.length&&!this._aRules[i]);return i;};d.prototype.previousTo=function(i){do{i--;}while(!this._aRules[i]&&i>0);return i;};d.prototype.hasRuleAt=function(i){return!!this._aRules[i];};d.prototype.applyCharAt=function(s,i){return this._aRules[i].test(s);};this._setDefaultRules=function(){this._bSkipSetupMaskVariables=true;this.addRule(new M({maskFormatSymbol:"a",regex:"[A-Za-z]"}),true);this.addRule(new M({maskFormatSymbol:"9",regex:"[0-9]"}),true);this._bSkipSetupMaskVariables=false;};this._validateDependencies=function(){var p=this.getPlaceholderSymbol(),r=this.getRules(),m=[],e=[];if(!this.getMask()){e.push("Empty mask");}if(r.length){m=[];r.every(function(R){var s=R.getMaskFormatSymbol(),f=s!==p,g;g=!m.some(function(S){return s===S;});m.push(s);if(!f){e.push("Placeholder symbol is the  same as the existing rule's mask format symbol");}if(!g){e.push("Duplicated rule's maskFormatSymbol ["+s+"]");}return f&&g;});}return e.length?e.join(". "):null;};this._removeRuleWithSymbol=function(s){var S=this._findRuleBySymbol(s,this.getRules());if(S){this.removeAggregation('rules',S.oRule);S.oRule.destroy();}};this._findRuleBySymbol=function(m,r){var R=null;if(typeof m!=="string"||m.length!==1){L.error(m+" is not a valid mask rule symbol");return null;}q.each(r,function(i,o){if(o.getMaskFormatSymbol()===m){R={oRule:o,iIndex:i};return false;}});return R;};this._getTextSelection=function(){var _=q(this.getFocusDomRef());if(!_&&(_.length===0||_.is(":hidden"))){return{};}return{iFrom:_[0].selectionStart,iTo:_[0].selectionEnd,bHasSelection:(_[0].selectionEnd-_[0].selectionStart!==0)};};this._setCursorPosition=function(p){if(p<0){p=0;}q(this.getFocusDomRef()).cursorPos(p);return this;};this._getCursorPosition=function(){return q(this.getFocusDomRef()).cursorPos();};this._setupMaskVariables=function(){var r=this.getRules(),m=this.getMask(),s=this._getSkipIndexes(m),e=this._getMaskArray(m,s),p=this.getPlaceholderSymbol(),i=this._buildMaskValueArray(e,p,r,s),t=this._buildRules(e,r,s);this._oTempValue=new b(i);this._iMaskLength=t.length;this._oRules=new d(t);this._iUserInputStartPosition=this._oRules.nextTo();};this._getMaskArray=function(m,s){var l=Array.isArray(s)?s.length:0,e=(m)?m.split(""):[],i;for(i=0;i<l;i++){e.splice(s[i],1);}return e;};this._getSkipIndexes=function(m){var l=(m)?m.length:0,i,s=[],p=0,e=false;for(i=0;i<l;i++){if(m[i]===E&&!e){s.push(i-p);e=true;p++;}else{e=false;}}return s;};this._applyMask=function(){var m=this._getInputValue();if(!this.getEditable()){return;}this._applyAndUpdate(m);};this._resetTempValue=function(f,t){var i,p=this.getPlaceholderSymbol();if(typeof f==="undefined"||f===null){f=0;t=this._oTempValue.getSize()-1;}for(i=f;i<=t;i++){if(this._oRules.hasRuleAt(i)){this._oTempValue.setCharAt(p,i);}}};this._applyAndUpdate=function(m){this._applyRules(m);this.updateDomValue(this._oTempValue.toString());};this._findFirstPlaceholderPosition=function(){return this._oTempValue.toString().indexOf(this.getPlaceholderSymbol());};this._applyRules=function(i){var s,e=0,m,p=this.getPlaceholderSymbol(),f;if(this._oTempValue.toString()===i){return;}for(m=0;m<this._iMaskLength;m++){if(this._oRules.hasRuleAt(m)){this._oTempValue.setCharAt(p,m);f=false;if(i.length){do{s=i.charAt(e);e++;if(this._oRules.applyCharAt(s,m)){this._oTempValue.setCharAt(s,m);f=true;}}while(!f&&(e<i.length));}if(!f){this._resetTempValue(m+1,this._iMaskLength-1);break;}}else{if(this._oTempValue.charAt(m)===i.charAt(e)){e++;}}}};this._keyPressHandler=function(e,k){var s,p,f;if(!this.getEditable()){return;}k=k||this._parseKeyBoardEvent(e);if(k.bCtrlKey||k.bAltKey||k.bMetaKey||k.bBeforeSpace){return;}s=this._getTextSelection();if(!k.bEnter&&!k.bShiftLeftOrRightArrow&&!k.bHome&&!k.bEnd&&!(k.bShift&&k.bDelete)&&!(k.bCtrlKey&&k.bInsert)&&!(k.bShift&&k.bInsert)){if(s.bHasSelection){this._resetTempValue(s.iFrom,s.iTo-1);this.updateDomValue(this._oTempValue.toString());this._setCursorPosition(Math.max(this._iUserInputStartPosition,s.iFrom));}p=this._oRules.nextTo(s.iFrom-1);if(p<this._iMaskLength){f=this._feedReplaceChar(k.sChar,p,this._getInputValue());this._feedNextString(f,p);}e.preventDefault();}};this.oncut=function(e){var s=this._getTextSelection(),m=this._getMinBrowserDelay(),B=s.iFrom,i=s.iTo;I.prototype.oncut(e);if(!s.bHasSelection||!this._isMaskEnabled()){return;}i=i-1;this._resetTempValue(B,i);setTimeout(function u(v,p,o){this._oTempValue._aContent=o;this.updateDomValue(v);setTimeout(this._setCursorPosition.bind(this,p),m);}.bind(this,this._oTempValue.toString(),Math.max(this._iUserInputStartPosition,B),this._oTempValue._aContent.slice(0)),m);};this._keyDownHandler=function(e,k){var s,S,i,n,k=k||this._parseKeyBoardEvent(e);if(!this.getEditable()){return;}if(!k.bShift&&(k.bArrowRight||k.bArrowLeft)){i=this._getCursorPosition();S=this._getTextSelection();s=this._determineArrowKeyDirection(k,S);if(this._isRtlMode()&&S.bHasSelection){n=this._determineRtlCaretPositionFromSelection(s);}else{n=this._oRules[s](i);}if(this._isWebkitProblematicCase()){n=this._fixWebkitBorderPositions(n,s);}this._setCursorPosition(n);e.preventDefault();}else if(k.bEscape){this._applyAndUpdate(this._sOldInputValue);this._positionCaret(true);e.preventDefault();}else if(k.bEnter){this._inputCompletedHandler(e);}else if((k.bCtrlKey&&k.bInsert)||(k.bShift&&k.bInsert)){I.prototype.onkeydown.apply(this,arguments);}else if((!k.bShift&&k.bDelete)||k.bBackspace){this._revertKey(k);e.preventDefault();}else if(this._isChromeOnAndroid()){this._oKeyDownStateAndroid={sValue:this._oTempValue.toString(),iCursorPosition:this._getCursorPosition(),oSelection:this._getTextSelection()};}};this._revertKey=function(k,s){s=s||this._getTextSelection();var B=s.iFrom,e=s.iTo;if(!s.bHasSelection){if(k.bBackspace){B=this._oRules.previousTo(B);}}if(k.bBackspace||(k.bDelete&&s.bHasSelection)){e=e-1;}this._resetTempValue(B,e);this.updateDomValue(this._oTempValue.toString());this._setCursorPosition(Math.max(this._iUserInputStartPosition,B));};this._feedNextString=function(n,p){var N,A=false,e=n.split(""),s;while(e.length){s=e.splice(0,1)[0];if(this._oRules.applyCharAt(s,p)){A=true;this._oTempValue.setCharAt(s,p);p=this._oRules.nextTo(p);}}if(A){N=p;this.updateDomValue(this._oTempValue.toString());this._setCursorPosition(N);}};this._inputCompletedHandler=function(){var n=this._getInputValue(),t,v,e,f;if(this._oTempValue.differsFrom(n)){this._applyAndUpdate(n);}t=this._oTempValue.differsFromOriginal();v=t?this._oTempValue.toString():"";e=!this._sOldInputValue||!this.getValue();f=!n;if(e&&(f||!t)){this.updateDomValue("");return;}if(this._sOldInputValue!==this._oTempValue.toString()){I.prototype.setValue.call(this,this._getAlteredUserInputValue?this._getAlteredUserInputValue(v):v);this._sOldInputValue=v;if(this.onChange&&!this.onChange({value:v})){this.fireChangeEvent(v);}}};this._buildMaskValueArray=function(m,p,r,s){return m.map(function(e,i){var n=s.indexOf(i)===-1,R=this._findRuleBySymbol(e,r);return(n&&R)?p:e;},this);};this._buildRules=function(m,r,s){var t=[],S,l=m.length,i=0;for(;i<l;i++){if(s.indexOf(i)===-1){S=this._findRuleBySymbol(m[i],r);t.push(S?new RegExp(S.oRule.getRegex()):null);}else{t.push(null);}}return t;};this._parseKeyBoardEvent=function(e){var p=e.which||e.keyCode,k=K,A=p===k.ARROW_RIGHT,f=p===k.ARROW_LEFT,s=e.shiftKey;return{iCode:p,sChar:String.fromCharCode(p),bCtrlKey:e.ctrlKey,bAltKey:e.altKey,bMetaKey:e.metaKey,bShift:s,bInsert:p===K.INSERT,bBackspace:p===k.BACKSPACE,bDelete:p===k.DELETE,bEscape:p===k.ESCAPE,bEnter:p===k.ENTER,bIphoneEscape:(D.system.phone&&D.os.ios&&p===127),bArrowRight:A,bArrowLeft:f,bHome:p===K.HOME,bEnd:p===K.END,bShiftLeftOrRightArrow:s&&(f||A),bBeforeSpace:p<k.SPACE};};this._positionCaret=function(s){var m=this.getMask(),i=this._getMinBrowserDelay(),e;clearTimeout(this._iCaretTimeoutId);e=this._findFirstPlaceholderPosition();if(e<0){e=m.length;}this._iCaretTimeoutId=setTimeout(function(){if(this.getFocusDomRef()!==document.activeElement){return;}if(s&&(e===(m.length))){this.selectText(0,e);}else{this._setCursorPosition(e);}}.bind(this),i);};this._getMinBrowserDelay=function(){return!D.browser.msie?4:50;};this._isValidInput=function(s){var l=s.length,i=0,e;for(;i<l;i++){e=s[i];if(this._oRules.hasRuleAt(i)&&(!this._oRules.applyCharAt(e,i)&&e!==this.getPlaceholderSymbol())){return false;}if(!this._oRules.hasRuleAt(i)&&e!==this._oTempValue.charAt(i)){return false;}}return true;};this._isRtlChar=function(s){var l='A-Za-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02B8\u0300-\u0590\u0800-\u1FFF'+'\u2C00-\uFB1C\uFDFE-\uFE6F\uFEFD-\uFFFF',r='\u0591-\u07FF\uFB1D-\uFDFD\uFE70-\uFEFC',e=new RegExp('^[^'+l+']*['+r+']');return e.test(s);};this._fixWebkitBorderPositions=function(i,s){var t=this._oTempValue.toString().length;if(s==='nextTo'){if(i===0||i===t||i===1){i=0;}else if(i===t+1){i=1;}}else{if(i===0||i===t-1){i=t;}else if(i===-1||i===t){i=t-1;}}return i;};this._containsRtlChars=function(){var t=this._oTempValue.toString(),e=false;for(var i=0;i<t.length;i++){e=this._isRtlChar(t[i]);}return e;};this._isRtlMode=function(){return sap.ui.getCore().getConfiguration().getRTL()||(this.getTextDirection()===T.RTL);};this._isWebkitProblematicCase=function(){return D.browser.webkit&&this._isRtlMode()&&!this._containsRtlChars();};this._determineArrowKeyDirection=function(k,s){var e;if(!this._isRtlMode()||!this._containsRtlChars()||s.bHasSelection){if(k.bArrowRight){e='nextTo';}else{e='previousTo';}}else{if(k.bArrowRight){e='previousTo';}else{e='nextTo';}}return e;};this._determineRtlCaretPositionFromSelection=function(s,w){var n,S=this._getTextSelection();if(w){if(s==='nextTo'){if(!this._containsRtlChars()){n=S.iFrom;}else{n=S.iTo;}}else{if(!this._containsRtlChars()){n=S.iTo;}else{n=S.iFrom;}}}else{if(s==='nextTo'){if(!this._containsRtlChars()){n=S.iTo;}else{n=S.iFrom;}}else{if(!this._containsRtlChars()){n=S.iFrom;}else{n=S.iTo;}}}return n;};this._onInputForAndroidHandler=function(e){var k;if(!this._oKeyDownStateAndroid){return;}k=this._buildKeyboardEventInfo(this._oKeyDownStateAndroid.sValue,this._getInputValue(),this._oKeyDownStateAndroid.oSelection);this.updateDomValue(this._oKeyDownStateAndroid.sValue);setTimeout(function(i,o,f){this._setCursorPosition(o.iCursorPosition);if(f.bBackspace){this._revertKey(f,o.oSelection);if(o.oSelection.bHasSelection&&f.sChar){this._keyPressHandler(i,f);}}else{this._keyPressHandler(i,f);}}.bind(this,e,this._oKeyDownStateAndroid,k),0);delete this._oKeyDownStateAndroid;e.preventDefault();};this._buildKeyboardEventInfo=function(o,n,O){var N="",i,r={},e;if(!o&&!n){return{};}if(o&&n&&n.length<o.length){r.bBackspace=true;}for(i=0;i<n.length;i++){e=O.bHasSelection&&O.iFrom===i;if(e||o[i]!==n[i]){N=n[i];break;}}r.sChar=N;return r;};this._isChromeOnAndroid=function(){return D.browser.chrome&&D.os.android;};};return a;},true);
sap.ui.predefine('sap/m/MaskInput',['./InputBase','./MaskEnabler','./MaskInputRenderer'],function(I,M,a){"use strict";
var b=I.extend("sap.m.MaskInput",{metadata:{library:"sap.m",properties:{placeholderSymbol:{type:"string",group:"Misc",defaultValue:"_"},mask:{type:"string",group:"Misc",defaultValue:null}},aggregations:{rules:{type:"sap.m.MaskInputRule",multiple:true,singularName:"rule"}},dnd:{draggable:false,droppable:true}}});
M.call(b.prototype);
b.prototype._isMaskEnabled=function(){return true;};
return b;});
sap.ui.predefine('sap/m/MaskInputRenderer',['sap/ui/core/Renderer','./InputBaseRenderer'],function(R,I){"use strict";var M=R.extend(I);M.apiVersion=2;
M.getLabelledByAnnouncement=function(c){var m=c.getMask(),p=c.getPlaceholder()||"",r,s,a="";if(m&&m.length){r=sap.ui.getCore().getLibraryResourceBundle("sap.m");s=r.getText("MASKINPUT_SCREENREADER_TAG");if(p){p=" "+p+" ";}a=s+p;return a;}return I.getLabelledByAnnouncement.apply(this,arguments);};
M.getDescribedByAnnouncement=function(c){var m=c.getMask(),s=c.getPlaceholderSymbol(),r,a="";if(m.length&&s){r=sap.ui.getCore().getLibraryResourceBundle("sap.m");a=r.getText("MASKINPUT_SCREENREADER_DESCRIPTION",[s,m]);return a.trim();}return I.getDescribedByAnnouncement.apply(this,arguments);};
return M;},true);
sap.ui.predefine('sap/m/MaskInputRule',['sap/ui/core/Element',"sap/base/Log"],function(E,L){"use strict";
var M=E.extend("sap.m.MaskInputRule",{metadata:{library:"sap.m",properties:{maskFormatSymbol:{type:"string",group:"Misc",defaultValue:"*"},regex:{type:"string",group:"Misc",defaultValue:"[a-zA-Z0-9]"}}}});
M.prototype.setMaskFormatSymbol=function(n){var i=v.call(this,n);if(i){this.setProperty("maskFormatSymbol",n);}return this;};
M.prototype.setRegex=function(n){var i=a.call(this,n);if(i){this.setProperty("regex",n);}return this;};
M.prototype.toString=function(){return this.getMaskFormatSymbol()+":"+this.getRegex();};
function v(n){if(/^.$/i.test(n)){return true;}L.error("The mask format symbol '"+n+"' is not valid");return false;}
function a(r){if(/.+/i.test(r)){return true;}L.error("The regex value '"+r+"' is not valid");return false;}
return M;});
sap.ui.predefine('sap/m/MenuButton',['./library','sap/ui/core/Control','./Button','./SplitButton','sap/ui/Device','sap/ui/core/EnabledPropagator','sap/ui/core/library','sap/ui/core/Popup','sap/ui/core/LabelEnablement',"./MenuButtonRenderer","sap/ui/events/KeyCodes"],function(l,C,B,S,D,E,c,P,L,M,K){"use strict";var a=l.MenuButtonMode;var T=c.TextDirection;var b=l.ButtonType;var d=P.Dock;var n=["buttonMode","useDefaultActionOnly","width","menuPosition"];
var e=C.extend("sap.m.MenuButton",{metadata:{library:"sap.m",properties:{text:{type:"string",group:"Misc",defaultValue:null},type:{type:"sap.m.ButtonType",group:"Appearance",defaultValue:b.Default},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},activeIcon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconDensityAware:{type:"boolean",group:"Misc",defaultValue:true},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit},buttonMode:{type:"sap.m.MenuButtonMode",group:"Misc",defaultValue:a.Regular},menuPosition:{type:"sap.ui.core.Popup.Dock",group:"Misc",defaultValue:d.BeginBottom},useDefaultActionOnly:{type:"boolean",group:"Behavior",defaultValue:false}},aggregations:{menu:{type:"sap.m.Menu",multiple:false,singularName:"menu"},_button:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{defaultAction:{}},defaultAggregation:"menu",designtime:"sap/m/designtime/MenuButton.designtime",dnd:{draggable:true,droppable:false}}});
E.call(e.prototype);
e.prototype.init=function(){this._initButtonControl();};
e.prototype.exit=function(){if(this._sDefaultText){this._sDefaultText=null;}if(this._sDefaultIcon){this._sDefaultIcon=null;}if(this._iInitialTextBtnContentWidth){this._iInitialTextBtnContentWidth=null;}if(this._lastActionItemId){this._lastActionItemId=null;}if(this.getMenu()){this.getMenu().detachClosed(this._menuClosed,this);}};
e.prototype.onBeforeRendering=function(){if(!this._sDefaultText){this._sDefaultText=this.getText();}if(!this._sDefaultIcon){this._sDefaultIcon=this.getIcon();}this._updateButtonControl();this._attachMenuEvents();};
e.prototype._needsWidth=function(){return this._isSplitButton()&&this.getWidth()==="";};
e.prototype._getTextBtnContentDomRef=function(){return this._getButtonControl()._getTextButton().getDomRef("content");};
e.prototype.onAfterRendering=function(){if(this._needsWidth()&&sap.ui.getCore().isThemeApplied()&&this._getTextBtnContentDomRef()&&this._getInitialTextBtnWidth()>0){this._getTextBtnContentDomRef().style.width=this._getInitialTextBtnWidth()+'px';}};
e.prototype.onThemeChanged=function(o){if(this._needsWidth()&&this.getDomRef()&&!this._iInitialTextBtnContentWidth&&this._getTextBtnContentDomRef()&&this._getInitialTextBtnWidth()>0){this._getTextBtnContentDomRef().style.width=this._getInitialTextBtnWidth()+'px';}};
e.prototype._getInitialTextBtnWidth=function(){if(!this._iInitialTextBtnContentWidth){this._iInitialTextBtnContentWidth=Math.ceil(this._getTextBtnContentDomRef().getBoundingClientRect().width);}return this._iInitialTextBtnContentWidth;};
e.prototype.setButtonMode=function(m){var t=this.getTooltip();C.prototype.setProperty.call(this,"buttonMode",m,true);this._getButtonControl().destroy();this._initButtonControl();for(var k in this.mProperties){if(this.mProperties.hasOwnProperty(k)&&n.indexOf(k)<0){this._getButtonControl().setProperty(k,this.mProperties[k],true);}}if(t){this._getButtonControl().setTooltip(t);}if(!this._isSplitButton()&&this._sDefaultText){this.setText(this._sDefaultText);}else if(!this.getUseDefaultActionOnly()&&this._getLastSelectedItem()){this.setText(sap.ui.getCore().byId(this._getLastSelectedItem()).getText());}if(!this._isSplitButton()&&this._sDefaultIcon){this.setIcon(this._sDefaultIcon);}else if(!this.getUseDefaultActionOnly()&&this._getLastSelectedItem()){this.setIcon(sap.ui.getCore().byId(this._getLastSelectedItem()).getIcon());}this.invalidate();return this;};
e.prototype._initButton=function(){var o=new B(this.getId()+"-internalBtn",{width:"100%",ariaHasPopup:c.aria.HasPopup.Menu});o.attachPress(this._handleButtonPress,this);return o;};
e.prototype._initSplitButton=function(){var o=new S(this.getId()+"-internalSplitBtn",{width:"100%"});o.attachPress(this._handleActionPress,this);o.attachArrowPress(this._handleButtonPress,this);return o;};
e.prototype._initButtonControl=function(){var o;if(this._isSplitButton()){o=this._initSplitButton();}else{o=this._initButton();}this.setAggregation("_button",o,true);};
e.prototype._updateButtonControl=function(){this._getButtonControl().setText(this.getText());};
e.prototype._getButtonControl=function(){return this.getAggregation("_button");};
e.prototype._handleButtonPress=function(w){var m=this.getMenu(),o={zero:"0 0",plus2_right:"0 +2",minus2_right:"0 -2",plus2_left:"+2 0",minus2_left:"-2 0"};if(!m){return;}if(this._bPopupOpen){this.getMenu().close();this._bPopupOpen=false;return;}if(!m.getTitle()){m.setTitle(this.getText());}var p=[this,w];switch(this.getMenuPosition()){case d.BeginTop:p.push(d.BeginBottom,d.BeginTop,o.plus2_right);break;case d.BeginCenter:p.push(d.BeginCenter,d.BeginCenter,o.zero);break;case d.LeftTop:p.push(d.RightBottom,d.LeftBottom,o.plus2_left);break;case d.LeftCenter:p.push(d.RightCenter,d.LeftCenter,o.plus2_left);break;case d.LeftBottom:p.push(d.RightTop,d.LeftTop,o.plus2_left);break;case d.CenterTop:p.push(d.CenterBottom,d.CenterTop,o.plus2_left);break;case d.CenterCenter:p.push(d.CenterCenter,d.CenterCenter,o.zero);break;case d.CenterBottom:p.push(d.CenterTop,d.CenterBottom,o.minus2_right);break;case d.RightTop:p.push(d.LeftBottom,d.RightBottom,o.minus2_left);break;case d.RightCenter:p.push(d.LeftCenter,d.RightCenter,o.minus2_left);break;case d.RightBottom:p.push(d.LeftTop,d.RightTop,o.minus2_left);break;case d.EndTop:p.push(d.EndBottom,d.EndTop,o.plus2_right);break;case d.EndCenter:p.push(d.EndCenter,d.EndCenter,o.zero);break;case d.EndBottom:p.push(d.EndTop,d.EndBottom,o.minus2_right);break;default:case d.BeginBottom:p.push(d.BeginTop,d.BeginBottom,o.minus2_right);break;}m.openBy.apply(m,p);if(this.getMenu()){this._bPopupOpen=true;}this._writeAriaAttributes();if(this._isSplitButton()&&!D.system.phone){this._getButtonControl().setArrowState(true);}};
e.prototype._handleActionPress=function(){var s=this._getLastSelectedItem(),o;if(!this.getUseDefaultActionOnly()&&s){o=sap.ui.getCore().byId(s);this.getMenu().fireItemSelected({item:o});}else{this.fireDefaultAction();}};
e.prototype._menuClosed=function(){var o=this._getButtonControl(),O=o;this._bPopupOpen=false;if(this._isSplitButton()){o.setArrowState(false);O=o._getArrowButton();}O.$().removeAttr("aria-controls");};
e.prototype._menuItemSelected=function(o){var m=o.getParameter("item");this.fireEvent("_menuItemSelected",{item:m});this._bPopupOpen=false;if(!this._isSplitButton()||this.getUseDefaultActionOnly()||!m){return;}this._lastActionItemId=m.getId();!!this._sDefaultText&&this.setText(m.getText());!!this._sDefaultIcon&&this.setIcon(m.getIcon());};
e.prototype._getLastSelectedItem=function(){return this._lastActionItemId;};
e.prototype._attachMenuEvents=function(){if(this.getMenu()){this.getMenu().attachClosed(this._menuClosed,this);this.getMenu().attachItemSelected(this._menuItemSelected,this);}};
e.prototype._isSplitButton=function(){return this.getButtonMode()===a.Split;};
e.prototype.setProperty=function(p,v,s){function i(t){var f=[b.Up,b.Back,b.Unstyled];return f.indexOf(t)!==-1;}if(p==="type"&&i(v)){return this;}if(p==='text'){this._sDefaultText=v;}switch(p){case'activeIcon':case'iconDensityAware':case'textDirection':case'visible':case'enabled':this._getButtonControl().setProperty(p,v);break;}return C.prototype.setProperty.apply(this,arguments);};
e.prototype.setTooltip=function(t){this._getButtonControl().setTooltip(t);return C.prototype.setTooltip.apply(this,arguments);};
e.prototype.setText=function(v){B.prototype.setProperty.call(this,'text',v);this._getButtonControl().setText(v);return this;};
e.prototype.setType=function(v){B.prototype.setProperty.call(this,'type',v);this._getButtonControl().setType(v);return this;};
e.prototype.setIcon=function(v){B.prototype.setProperty.call(this,'icon',v);this._getButtonControl().setIcon(v);return this;};
e.prototype.addAriaLabelledBy=function(A){this.getAggregation("_button").addAssociation("ariaLabelledBy",A);return C.prototype.addAssociation.call(this,"ariaLabelledBy",A);};
e.prototype.addAriaDescribedBy=function(A){this.getAggregation("_button").addAssociation("ariaDescribedBy",A);return C.prototype.addAssociation.call(this,"ariaDescribedBy",A);};
e.prototype.removeAriaLabelledBy=function(A){this.getAggregation("_button").removeAssociation("ariaLabelledBy",A);return C.prototype.removeAssociation.call(this,"ariaLabelledBy",A);};
e.prototype.removeAriaDescribedBy=function(A){this.getAggregation("_button").removeAssociation("ariaDescribedBy",A);return C.prototype.removeAssociation.call(this,"ariaDescribedBy",A);};
e.prototype.removeAllAriaLabelledBy=function(A){this.getAggregation("_button").removeAllAssociation("ariaLabelledBy");return C.prototype.removeAllAssociation.call(this,"ariaLabelledBy");};
e.prototype.removeAllAriaDescribedBy=function(){this.getAggregation("_button").removeAllAssociation("ariaDescribedBy");return C.prototype.removeAllAssociation.call(this,"ariaDescribedBy");};
e.prototype.getFocusDomRef=function(){return this._getButtonControl().getDomRef();};
e.prototype.onsapup=function(o){this.openMenuByKeyboard();o.stopPropagation();};
e.prototype.onsapdown=function(o){this.openMenuByKeyboard();o.stopPropagation();};
e.prototype.onsapupmodifiers=function(o){this.openMenuByKeyboard();o.stopPropagation();};
e.prototype.onsapdownmodifiers=function(o){this.openMenuByKeyboard();o.stopPropagation();};
e.prototype.onsapshow=function(o){this.openMenuByKeyboard();!!o&&o.preventDefault();};
e.prototype.ontouchstart=function(){this._bPopupOpen=this.getMenu()&&this.getMenu()._getMenu()&&this.getMenu()._getMenu().getPopup().isOpen();};
e.prototype.onkeydown=function(o){if((o.keyCode===K.ENTER||o.keyCode===K.TAB)&&this._bPopupOpen){this.getMenu().close();this._bPopupOpen=false;}};
e.prototype.openMenuByKeyboard=function(){if(!this._isSplitButton()){this._handleButtonPress(true);}};
e.prototype._writeAriaAttributes=function(){var o=this._getButtonControl(),O=this._isSplitButton()?o._getArrowButton():o,m=this.getMenu();if(m){O.$().attr("aria-controls",m.getDomRefId());}};
e.prototype.getIdForLabel=function(){return this.getId()+"-internalBtn";};
e.prototype._ensureBackwardsReference=function(){var i=this._getButtonControl(),I=i.getAriaLabelledBy(),r=L.getReferencingLabels(this);r.forEach(function(s){if(I&&I.indexOf(s)===-1){i.addAriaLabelledBy(s);}});return this;};
return e;});
sap.ui.predefine('sap/m/MenuButtonRenderer',[],function(){"use strict";var M={apiVersion:2};M.CSS_CLASS="sapMMenuBtn";
M.render=function(r,m){var w=m.getWidth();r.openStart("div",m);r.class(M.CSS_CLASS).class(M.CSS_CLASS+m.getButtonMode());if(w!=""){r.style("width",w);}r.openEnd();m._ensureBackwardsReference();r.renderControl(m._getButtonControl());r.close("div");};
return M;},true);
sap.ui.predefine('sap/m/MenuItem',['./library','sap/ui/core/Item','sap/ui/base/ManagedObjectObserver'],function(l,I,M){"use strict";
var a=I.extend("sap.m.MenuItem",{metadata:{library:"sap.m",properties:{icon:{type:"string",group:"Appearance",defaultValue:null},visible:{type:"boolean",group:"Appearance",defaultValue:true},startsSection:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.MenuItem",multiple:true,singularName:"item",bindable:"bindable"}},events:{press:{},propertyChanged:{parameters:{propertyKey:{type:"string"},propertyValue:{type:"any"}}},aggregationChanged:{parameters:{aggregationName:{type:"String"},methodName:{type:"String"},methodParams:{type:"Object"}}}}}});
a.UNIFIED_MENU_ITEMS_ID_SUFFIX='-unifiedmenu';
a.prototype.exit=function(){if(this._sVisualChild){this._sVisualChild=null;}if(this._sVisualParent){this._sVisualParent=null;}if(this._sVisualControl){this._sVisualControl=null;}};
a.prototype.setProperty=function(p,P){I.prototype.setProperty.apply(this,arguments);this.fireEvent("propertyChanged",{propertyKey:p,propertyValue:P});};
a.prototype.setAggregation=function(A,o,s){I.prototype.setAggregation.apply(this,arguments);this.fireEvent("aggregationChanged",{aggregationName:A,methodName:"set",methodParams:{item:o}});return this;};
a.prototype.addAggregation=function(A,o,s){var v=this._getVisualControl(),V;I.prototype.addAggregation.apply(this,arguments);if(A==='customData'&&v){V=sap.ui.getCore().byId(v);this._addCustomData(V,o);}this.fireEvent("aggregationChanged",{aggregationName:A,methodName:"add",methodParams:{item:o}});return this;};
a.prototype.insertAggregation=function(A,o,i,s){var v=this._getVisualControl(),V;I.prototype.insertAggregation.apply(this,arguments);if(A==='customData'&&v){V=sap.ui.getCore().byId(v);V.insertCustomData(o.clone(a.UNIFIED_MENU_ITEMS_ID_SUFFIX),i);this._observeCustomDataChanges(o);}this.fireEvent("aggregationChanged",{aggregationName:A,methodName:"insert",methodParams:{item:o,index:i}});return this;};
a.prototype.removeAggregation=function(A,o,s){var O=I.prototype.removeAggregation.apply(this,arguments);if(A==="customData"){if(this.getCustomData().length===1){this._disconnectAndDestroyCustomDataObserver();}else if(o&&this._oCustomDataObserver){this._oCustomDataObserver.unobserve(o,{properties:["value"]});}}this.fireEvent("aggregationChanged",{aggregationName:A,methodName:"remove",methodParams:{item:O}});return O;};
a.prototype.removeAllAggregation=function(A,s){var o=I.prototype.removeAllAggregation.apply(this,arguments);if(A==='customData'){this._disconnectAndDestroyCustomDataObserver();}this.fireEvent("aggregationChanged",{aggregationName:A,methodName:"removeall",methodParams:{items:o}});return o;};
a.prototype.destroyAggregation=function(A,s){if(A==='customData'){this._disconnectAndDestroyCustomDataObserver();}this.fireEvent("aggregationChanged",{aggregationName:A,methodName:"destroy"});return I.prototype.destroyAggregation.apply(this,arguments);};
a.prototype.destroy=function(){var v=sap.ui.getCore().byId(this._getVisualControl());if(v){v.destroy();}return I.prototype.destroy.apply(this,arguments);};
a.prototype._addCustomData=function(v,c){v.addCustomData(c.clone(a.UNIFIED_MENU_ITEMS_ID_SUFFIX,undefined,{bCloneChildren:false,bCloneBindings:true}));this._observeCustomDataChanges(c);};
a.prototype._observeCustomDataChanges=function(c){this._getCustomDataObserver().observe(c,{properties:["value"]});};
a.prototype._customDataObserverCallbackFunction=function(c){sap.ui.getCore().byId(c.object.getId()+"-"+a.UNIFIED_MENU_ITEMS_ID_SUFFIX).setValue(c.current);};
a.prototype._getCustomDataObserver=function(){if(!this._oCustomDataObserver){this._oCustomDataObserver=new M(this._customDataObserverCallbackFunction);}return this._oCustomDataObserver;};
a.prototype._disconnectAndDestroyCustomDataObserver=function(){if(this._oCustomDataObserver){this._oCustomDataObserver.disconnect();this._oCustomDataObserver.destroy();this._oCustomDataObserver=null;}};
a.prototype._setVisualChild=function(c){this._setInternalRef(c,"_sVisualChild");};
a.prototype._setVisualParent=function(c){this._setInternalRef(c,"_sVisualParent");};
a.prototype._setVisualControl=function(c){this._setInternalRef(c,"_sVisualControl");};
a.prototype._setInternalRef=function(c,i){if(!c||typeof c==="string"){this[i]=c;}else if(c.getId){this[i]=c.getId();}};
a.prototype._getVisualChild=function(){return this._sVisualChild;};
a.prototype._getVisualParent=function(){return this._sVisualParent;};
a.prototype._getVisualControl=function(){return this._sVisualControl;};
return a;});
sap.ui.predefine('sap/m/MenuListItem',['./ListItemBase','./library','sap/ui/core/IconPool','sap/ui/core/library','./MenuListItemRenderer'],function(L,l,I,c,M){"use strict";var T=c.TextDirection;
var a=L.extend("sap.m.MenuListItem",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Misc",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconDensityAware:{type:"boolean",group:"Misc",defaultValue:true},titleTextDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit},startsSection:{type:"boolean",group:"Behavior",defaultValue:false}},associations:{menuItem:{type:"sap.m.MenuItem",multiple:false}}}});
a.prototype.exit=function(){if(this._image){this._image.destroy();}if(this._imageRightArrow){this._imageRightArrow.destroy();}L.prototype.exit.apply(this,arguments);};
a.prototype._getImage=function(i,s,S,b){var o=this._image;if(o){o.setSrc(S);if(o instanceof sap.m.Image){o.setDensityAware(b);}}else{o=I.createControlByURI({id:i,src:S,densityAware:b,useIconTooltip:false},sap.m.Image).setParent(this,null,true);}if(o instanceof sap.m.Image){o.addStyleClass(s,true);}else{o.addStyleClass(s+"Icon",true);}this._image=o;return this._image;};
a.prototype._getIconArrowRight=function(){if(!this._imageRightArrow){this._imageRightArrow=I.createControlByURI({id:this.getId()+"-arrowRight",src:"sap-icon://slim-arrow-right",useIconTooltip:false},sap.m.Image).setParent(this,null,true);this._imageRightArrow.addStyleClass("sapMMenuLIArrowRightIcon",true);}return this._imageRightArrow;};
a.prototype._hasSubItems=function(){return!!(this.getMenuItem()&&sap.ui.getCore().byId(this.getMenuItem()).getItems().length);};
return a;});
sap.ui.predefine('sap/m/MenuListItemRenderer',['./ListItemBaseRenderer','sap/ui/core/Renderer','sap/m/library','sap/ui/core/library'],function(L,R,l,c){"use strict";var T=c.TextDirection;var a=l.ListType;var M=R.extend(L);M.apiVersion=2;
M.openItemTag=function(r,o){if(o.getStartsSection()){r.openStart("li");r.attr("role","separator");r.class("sapUiMnuDiv");r.openEnd();r.openStart("div");r.class("sapUiMnuDivL");r.openEnd();r.close("div");r.voidStart("hr").voidEnd();r.openStart("div");r.class("sapUiMnuDivR");r.openEnd();r.close("div");r.close("li");}L.openItemTag(r,o);};
M.renderLIAttributes=function(r,o){r.class("sapMSLI");if(o.getIcon()){r.class("sapMSLIIcon");}if(o.getType()==a.Detail||o.getType()==a.DetailAndActive){r.class("sapMSLIDetail");}if(o._hasSubItems()){r.class("sapMMenuLIHasChildren");}};
M.renderLIContent=function(r,o){var t=o.getTitleTextDirection();if(o.getIcon()){r.renderControl(o._getImage((o.getId()+"-img"),"sapMMenuLIImgThumb",o.getIcon(),o.getIconDensityAware()));}r.openStart("div");r.class("sapMSLIDiv");r.class("sapMSLITitleDiv");r.openEnd();if(o._bNoFlex){r.openStart("div");r.class("sapMLIBNoFlex");r.openEnd();}r.openStart("div");r.class("sapMSLITitleOnly");if(t!==T.Inherit){r.attr("dir",t.toLowerCase());}r.openEnd();r.text(o.getTitle());r.close("div");if(o._bNoFlex){r.close('div');}r.close("div");if(o._hasSubItems()){r.renderControl(o._getIconArrowRight());}};
return M;},true);
sap.ui.predefine('sap/m/MessageBox',['./Button','./Dialog','./Text','./FormattedText','./Link','./VBox','sap/ui/core/IconPool','sap/ui/core/ElementMetadata','sap/ui/core/library','sap/ui/core/Control','sap/m/library',"sap/ui/thirdparty/jquery",'sap/ui/core/theming/Parameters'],function(B,D,T,F,L,V,I,E,c,C,l,q,P){"use strict";var a=l.DialogType;var b=l.DialogRoleType;var d=c.TextDirection;var e=l.ButtonType;var M={};M.Action={OK:"OK",CANCEL:"CANCEL",YES:"YES",NO:"NO",ABORT:"ABORT",RETRY:"RETRY",IGNORE:"IGNORE",CLOSE:"CLOSE",DELETE:"DELETE"};M.Icon={NONE:undefined,INFORMATION:"INFORMATION",WARNING:"WARNING",ERROR:"ERROR",SUCCESS:"SUCCESS",QUESTION:"QUESTION"};(function(){var A=M.Action,f=M.Icon;var _=function(){if(M._rb!==sap.ui.getCore().getLibraryResourceBundle("sap.m")){M._rb=sap.ui.getCore().getLibraryResourceBundle("sap.m");}};
M.show=function(m,o){var g,h,v,r=null,j=[],i,s,t,k,n,p,u,w={id:E.uid("mbox"),initialFocus:null,textDirection:d.Inherit,verticalScrolling:true,horizontalScrolling:true,details:"",contentWidth:null},x=P.get("_sap_m_Message_Box_Information_Icon")==="true",S=x?"message-information":"hint",y={"INFORMATION":"sapMMessageBoxInfo","WARNING":"sapMMessageBoxWarning","ERROR":"sapMMessageBoxError","SUCCESS":"sapMMessageBoxSuccess","QUESTION":"sapMMessageBoxQuestion","STANDARD":"sapMMessageBoxStandard"},z={"INFORMATION":I.getIconURI(S),"WARNING":I.getIconURI("message-warning"),"ERROR":I.getIconURI("message-error"),"SUCCESS":I.getIconURI("message-success"),"QUESTION":I.getIconURI("question-mark")};_();if(typeof o==="string"||arguments.length>2){s=arguments[1];t=arguments[2];k=arguments[3];n=arguments[4];p=arguments[5];u=arguments[6];o={icon:s,title:t,actions:k,onClose:n,id:p,styleClass:u};}if(o&&o.hasOwnProperty("details")){w.icon=f.INFORMATION;w.emphasizedAction=A.OK;w.actions=[A.OK,A.CANCEL];o=q.extend({},w,o);}o=q.extend({},w,o);if(typeof o.actions!=="undefined"&&!Array.isArray(o.actions)){if(o.emphasizedAction!==null){o.emphasizedAction=o.actions;}o.actions=[o.actions];}if(!o.actions||o.actions.length===0){o.emphasizedAction=A.OK;o.actions=[A.OK];}function G(O,H){var Q;if(M.Action.hasOwnProperty(O)){Q=M._rb.getText("MSGBOX_"+O);}var R=new B({id:E.uid("mbox-btn-"),text:Q||O,type:H,press:function(){r=O;g.close();}});return R;}var H;for(i=0;i<o.actions.length;i++){H=o.emphasizedAction===o.actions[i]?e.Emphasized:e.Default;j.push(G(o.actions[i],H));}function J(o,h){var O,Q,R=new V({items:[h]});if(!o.details){return R;}if(typeof o.details=='object'){o.details="<pre>"+JSON.stringify(o.details,null,'\t').replace(/{/gi,"\\{")+"</pre>";}O=new F().setVisible(false).setHtmlText(o.details);Q=new L({text:M._rb.getText("MSGBOX_LINK_TITLE"),press:function(){var U=g.getInitialFocus();g.addAriaLabelledBy(O);O.setVisible(true);Q.setVisible(false);g._setInitialFocus();if(!U||U===Q.getId()){j[0].focus();}}});Q.addStyleClass("sapMMessageBoxLinkText");O.addStyleClass("sapMMessageBoxDetails");R.addItem(Q);R.addItem(O);return R;}function K(){if(typeof o.onClose==="function"){o.onClose(r);}g.detachAfterClose(K);g.destroy();}function N(){var i=0;var O=null;if(o.initialFocus){if(o.initialFocus instanceof C){O=o.initialFocus;}if(typeof o.initialFocus==="string"){for(i=0;i<j.length;i++){if(M.Action.hasOwnProperty(o.initialFocus)){if(M._rb.getText("MSGBOX_"+o.initialFocus).toLowerCase()===j[i].getText().toLowerCase()){O=j[i];break;}}else{if(o.initialFocus.toLowerCase()===j[i].getText().toLowerCase()){O=j[i];break;}}}}}return O;}if(typeof(m)==="string"){v=new T({textDirection:o.textDirection}).setText(m).addStyleClass("sapMMsgBoxText");h=v;}else if(m instanceof C){v=m.addStyleClass("sapMMsgBoxText");}if(o&&o.hasOwnProperty("details")&&o.details!==""){v=J(o,v);}g=new D({id:o.id,type:a.Message,title:o.title,content:v,icon:z[o.icon],initialFocus:N(),verticalScrolling:o.verticalScrolling,horizontalScrolling:o.horizontalScrolling,afterClose:K,buttons:j,ariaLabelledBy:h?h.getId():undefined,contentWidth:o.contentWidth,closeOnNavigation:o.closeOnNavigation}).addStyleClass("sapMMessageBox");g.setProperty("role",b.AlertDialog);if(y[o.icon]){g.addStyleClass(y[o.icon]);}else{g.addStyleClass(y.STANDARD);}if(o.styleClass){g.addStyleClass(o.styleClass);}g.open();};
M.alert=function(m,o){_();var g={icon:f.NONE,title:M._rb.getText("MSGBOX_TITLE_ALERT"),emphasizedAction:o&&o.actions?null:A.OK,actions:A.OK,id:E.uid("alert"),initialFocus:null},h,t,s,S;if(typeof o==="function"||arguments.length>2){h=arguments[1];t=arguments[2];s=arguments[3];S=arguments[4];o={onClose:h,title:t,id:s,styleClass:S};}o=q.extend({},g,o);return M.show(m,o);};
M.confirm=function(m,o){_();var g={icon:f.QUESTION,title:M._rb.getText("MSGBOX_TITLE_CONFIRM"),emphasizedAction:o&&o.actions?null:A.OK,actions:[A.OK,A.CANCEL],id:E.uid("confirm"),initialFocus:null},h,t,s,S;if(typeof o==="function"||arguments.length>2){h=arguments[1];t=arguments[2];s=arguments[3];S=arguments[4];o={onClose:h,title:t,id:s,styleClass:S};}o=q.extend({},g,o);return M.show(m,o);};
M.error=function(m,o){_();var g={icon:f.ERROR,title:M._rb.getText("MSGBOX_TITLE_ERROR"),emphasizedAction:null,actions:A.CLOSE,id:E.uid("error"),initialFocus:null};o=q.extend({},g,o);return M.show(m,o);};
M.information=function(m,o){_();var g={icon:f.INFORMATION,title:M._rb.getText("MSGBOX_TITLE_INFO"),emphasizedAction:o&&o.actions?null:A.OK,actions:A.OK,id:E.uid("info"),initialFocus:null};o=q.extend({},g,o);return M.show(m,o);};
M.warning=function(m,o){_();var g={icon:f.WARNING,title:M._rb.getText("MSGBOX_TITLE_WARNING"),emphasizedAction:o&&o.actions?null:A.OK,actions:A.OK,id:E.uid("warning"),initialFocus:null};o=q.extend({},g,o);return M.show(m,o);};
M.success=function(m,o){_();var g={icon:f.SUCCESS,title:M._rb.getText("MSGBOX_TITLE_SUCCESS"),emphasizedAction:o&&o.actions?null:A.OK,actions:A.OK,id:E.uid("success"),initialFocus:null};o=q.extend({},g,o);return M.show(m,o);};
}());return M;},true);
sap.ui.predefine('sap/m/MessageItem',["./library","sap/ui/core/Item","sap/ui/core/library","sap/base/Log","sap/base/security/sanitizeHTML"],function(l,I,c,L,s){"use strict";var M=c.MessageType;
var a=I.extend("sap.m.MessageItem",{metadata:{library:"sap.m",properties:{type:{type:"sap.ui.core.MessageType",group:"Appearance",defaultValue:M.Error},title:{type:"string",group:"Appearance",defaultValue:""},subtitle:{type:"string",group:"Misc",defaultValue:null},description:{type:"string",group:"Appearance",defaultValue:""},markupDescription:{type:"boolean",group:"Appearance",defaultValue:false},longtextUrl:{type:"sap.ui.core.URI",group:"Behavior",defaultValue:null},counter:{type:"int",group:"Misc",defaultValue:null},groupName:{type:"string",group:"Misc",defaultValue:""},activeTitle:{type:"boolean",group:"Misc",defaultValue:false}},defaultAggregation:"link",aggregations:{link:{type:"sap.m.Link",multiple:false,singularName:"link"}}}});
a.prototype.setProperty=function(p,v,S){var P=this.getParent(),t=this.getType().toLowerCase(),b=["description","type","groupName"],u=function(n,i){if(i._oMessagePopoverItem.getId()===this.getId()&&i.getMetadata().getProperty(n)){i.setProperty(n,v);}};if(b.indexOf(p)===-1&&P&&("_bItemsChanged"in P)&&!P._bItemsChanged){P._oLists&&P._oLists.all&&P._oLists.all.getItems&&P._oLists.all.getItems().forEach(u.bind(this,p));P._oLists&&P._oLists[t]&&P._oLists[t].getItems&&P._oLists[t].getItems().forEach(u.bind(this,p));}if(typeof this._updatePropertiesFn==="function"){this._updatePropertiesFn();}return I.prototype.setProperty.apply(this,arguments);};
a.prototype._updateProperties=function(b){this._updatePropertiesFn=b;};
a.prototype.setDescription=function(d){if(typeof d==='undefined'){d='';}if(this.getMarkupDescription()){d=s(d);}this.setProperty("description",d,true);return this;};
a.prototype.setType=function(t){if(t===M.None){t=M.Information;L.warning("The provided None type is handled and rendered as Information type");}return this.setProperty("type",t,true);};
return a;});
sap.ui.predefine('sap/m/MessageListItem',["sap/ui/core/library","sap/ui/core/InvisibleText","./library",'./StandardListItem','./Link',"./MessageListItemRenderer"],function(c,I,l,S,L,M){"use strict";var a=c.MessageType;
var b=S.extend("sap.m.MessageListItem",{metadata:{library:"sap.m",properties:{activeTitle:{type:"boolean",group:"Misc",defaultValue:false},messageType:{type:"sap.ui.core.MessageType",group:"Appearance",defaultValue:a.Error}},aggregations:{link:{type:"sap.m.Link",group:"Misc",multiple:false},linkAriaDescribedBy:{type:"sap.ui.core.Control",group:"Misc",multiple:false}},events:{activeTitlePress:{}}}});
b.prototype.onBeforeRendering=function(){S.prototype.onBeforeRendering.apply(this,arguments);var o=this.getLink(),d;if(!o&&this.getActiveTitle()){o=new L({press:[this.fireActiveTitlePress,this]});this.setLink(o);}if(o&&!o.getAriaDescribedBy().length){d=this._getLinkAriaDescribedBy();o.setProperty("text",this.getTitle(),true);o.addAssociation('ariaDescribedBy',d.getId(),true);this.setAggregation("linkAriaDescribedBy",d,true);}};
b.prototype._getLinkAriaDescribedBy=function(){var A=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("MESSAGE_VIEW_LINK_FOCUS_TEXT",[this.getMessageType()]);return new I(this.getId()+"-link",{text:A});};
b.prototype.onkeydown=function(e){if(this.getActiveTitle()&&e.altKey&&e.key==='Enter'){this.fireActiveTitlePress(this);}};
b.prototype.getContentAnnouncement=function(B){var A=S.prototype.getContentAnnouncement.apply(this,arguments),s,m;if(this.getActiveTitle()){m=B.getText("MESSAGEVIEW_BUTTON_TOOLTIP_"+this.getMessageType().toUpperCase());s=B.getText("MESSAGE_LIST_ITEM_FOCUS_TEXT",[m]);A+=" ".concat(s);}return A;};
return b;});
sap.ui.predefine('sap/m/MessageListItemRenderer',["./StandardListItemRenderer","sap/ui/core/Renderer"],function(S,R){"use strict";var M=R.extend(S);M.apiVersion=2;
M.renderTitle=function(r,c){if(c.getActiveTitle()){r.renderControl(c.getLink());r.renderControl(c.getLinkAriaDescribedBy());}else{S.renderTitle.apply(this,arguments);}};
return M;},true);
sap.ui.predefine('sap/m/MessagePage',['./library','sap/ui/core/library','sap/ui/core/Control','sap/ui/core/IconPool','sap/ui/base/ManagedObject','sap/m/Text','sap/m/Image','sap/m/Button','sap/m/Title','sap/m/Bar','sap/m/FormattedText','./MessagePageRenderer',"sap/ui/thirdparty/jquery"],function(l,c,C,I,M,T,a,B,b,d,F,e,q){"use strict";var f=c.TextAlign;var g=c.TextDirection;var h=l.ButtonType;var i=l.BarDesign;
var j=C.extend("sap.m.MessagePage",{metadata:{library:"sap.m",properties:{text:{type:"string",group:"Misc",defaultValue:"No matching items found."},description:{type:"string",group:"Misc",defaultValue:"Check the filter settings."},title:{type:"string",group:"Misc",defaultValue:null},showHeader:{type:"boolean",group:"Appearance",defaultValue:true},showNavButton:{type:"boolean",group:"Appearance",defaultValue:false},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:"sap-icon://documents"},iconAlt:{type:"string",group:"Misc",defaultValue:null},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:g.Inherit},enableFormattedText:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{customText:{type:"sap.m.Link",multiple:false},customDescription:{type:"sap.m.Link",multiple:false},buttons:{type:"sap.m.Button",multiple:true},_internalHeader:{type:"sap.m.Bar",multiple:false,visibility:"hidden"},_formattedText:{type:"sap.m.FormattedText",multiple:false,visibility:"hidden"},_text:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_description:{type:"sap.m.Text",multiple:false,visibility:"hidden"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{navButtonPress:{}},designtime:"sap/m/designtime/MessagePage.designtime"}});
j.ARIA_ROLE_DESCRIPTION="MESSAGE_PAGE_ROLE_DESCRIPTION";
j.prototype.init=function(){var o=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._oTitle=null;this._oNavButton=new B(this.getId()+"-navButton",{type:h.Back,press:q.proxy(function(){this.fireNavButtonPress();},this)});this.setAggregation("_internalHeader",new d(this.getId()+"-intHeader",{design:i.Header}));this.setProperty("text",o.getText("MESSAGE_PAGE_TEXT"),true);this.setProperty("description",o.getText("MESSAGE_PAGE_DESCRIPTION"),true);this._sAriaRoleDescription=o.getText(j.ARIA_ROLE_DESCRIPTION);};
j.prototype.exit=function(){if(this._oNavButton){this._oNavButton.destroy();this._oNavButton=null;}if(this._oIconControl){this._oIconControl.destroy();this._oIconControl=null;}};
j.prototype.setTitle=function(t){this.setProperty("title",t,true);if(!this._oTitle){this._oTitle=new b(this.getId()+"-title");this._getInternalHeader().addContentMiddle(this._oTitle);}this._oTitle.setText(t);return this;};
j.prototype.setText=function(t){this.setProperty("text",t,true);var o=this.getAggregation("_text");o&&o.setText(t);return this;};
j.prototype.setDescription=function(D){this.setProperty("description",D,true);var o=this.getAggregation("_formattedText"),k=this.getAggregation("_description");o&&o.setHtmlText(D);k&&k.setText(D);return this;};
j.prototype.setShowNavButton=function(s){this.setProperty("showNavButton",s,true);var H=this._getInternalHeader();if(s){H.addContentLeft(this._oNavButton);}else{H.removeAllContentLeft();}return this;};
j.prototype.setIcon=function(s){var v=this.getIcon()||"";s=s||"";if(v!==s){var S=!!v&&!!s&&I.isIconURI(s)===I.isIconURI(v);this.setProperty("icon",s,S);if(S&&this._oIconControl){this._oIconControl.setSrc(s);}}return this;};
j.prototype.setEnableFormattedText=function(E){var o;if(E){o=this._getFormattedText();o.setHtmlText(this.getDescription());}return this.setProperty("enableFormattedText",E);};
j.prototype._getIconControl=function(){if(this._oIconControl){this._oIconControl.destroy();this._oIconControl=null;}this._oIconControl=I.createControlByURI({id:this.getId()+"-pageIcon",src:this.getIcon(),height:"8rem",width:"8rem",useIconTooltip:true,decorative:false,alt:this.getIconAlt()},a).addStyleClass("sapMMessagePageIcon");return this._oIconControl;};
j.prototype._getText=function(){if(this.getAggregation("customText")){return this.getAggregation("customText");}if(!this.getAggregation("_text")){var t=new T(this.getId()+"-text",{id:this.getId()+"-customText",text:M.escapeSettingsValue(this.getText()),textAlign:f.Center,textDirection:this.getTextDirection()});this.setAggregation("_text",t);}return this.getAggregation("_text");};
j.prototype._getDescription=function(){if(this.getAggregation("customDescription")){return this.getAggregation("customDescription");}if(this.getEnableFormattedText()){return this._getFormattedText();}if(!this.getAggregation("_description")){var D=new T(this.getId()+"-description",{id:this.getId()+"-customDescription",text:M.escapeSettingsValue(this.getDescription()),textAlign:f.Center,textDirection:this.getTextDirection()});this.setAggregation("_description",D);}return this.getAggregation("_description");};
j.prototype._getAnyHeader=function(){return this._getInternalHeader();};
j.prototype._getInternalHeader=function(){return this.getAggregation("_internalHeader");};
j.prototype._getFormattedText=function(){var o=this.getAggregation("_formattedText");if(!o){o=new F(this.getId()+"-formattedText");this.setAggregation("_formattedText",o);}return o;};
return j;});
sap.ui.predefine('sap/m/MessagePageRenderer',['sap/ui/core/library'],function(c){"use strict";var T=c.TextDirection;var M={apiVersion:2};
M.render=function(r,m){this.startOpeningDiv(r,m);this.renderHeader(r,m);this.startInnerDivs(r);this.renderContent(r,m);this.endInnerDivs(r);this.endOpeningDiv(r);};
M.startOpeningDiv=function(r,m){r.openStart("div",m);r.attr("aria-roledescription",m._sAriaRoleDescription);r.class("sapMMessagePage");if(m.getTextDirection()!==T.Inherit){r.attr("dir",m.getTextDirection().toLowerCase());}r.openEnd();};
M.renderHeader=function(r,m){if(m.getShowHeader()){r.renderControl(m.getAggregation("_internalHeader"));}};
M.startInnerDivs=function(r){r.openStart("div");r.class("sapMMessagePageInner");r.openEnd();r.openStart("div");r.class("sapMMessagePageContentWrapper");r.openEnd();};
M.renderContent=function(r,m){if(m.getIcon()){r.renderControl(m._getIconControl());}r.renderControl(m._getText().addStyleClass("sapMMessagePageMainText"));r.renderControl(m._getDescription().addStyleClass("sapMMessagePageDescription"));this.renderButtons(r,m);};
M.renderButtons=function(r,m){var b=m.getButtons();if(b.length>0){r.openStart("div");r.class("sapMMessagePageButtonsWrapper");r.openEnd();for(var i=0;i<b.length;i++){r.renderControl(b[i]);}r.close("div");}};
M.endInnerDivs=function(r){r.close("div");r.close("div");};
M.endOpeningDiv=function(r){r.close("div");};
return M;},true);
sap.ui.predefine('sap/m/MessagePopover',["./ResponsivePopover","./Button","./Toolbar","./Bar","sap/ui/core/Control","sap/ui/core/IconPool","./semantic/SemanticPage","./Popover","./MessageView","sap/ui/Device","./MessagePopoverRenderer","sap/base/Log","sap/ui/thirdparty/jquery"],function(R,B,T,a,C,I,S,P,M,D,b,L,q){"use strict";
var c=C.extend("sap.m.MessagePopover",{metadata:{library:"sap.m",properties:{asyncDescriptionHandler:{type:"any",group:"Behavior",defaultValue:null},asyncURLHandler:{type:"any",group:"Behavior",defaultValue:null},placement:{type:"sap.m.VerticalPlacementType",group:"Behavior",defaultValue:"Vertical"},initiallyExpanded:{type:"boolean",group:"Behavior",defaultValue:true},groupItems:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.MessageItem",altTypes:["sap.m.MessagePopoverItem"],multiple:true,singularName:"item"},headerButton:{type:"sap.m.Button",multiple:false,forwarding:{idSuffix:"-messageView",aggregation:"headerButton"}}},events:{afterOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},afterClose:{parameters:{openBy:{type:"sap.ui.core.Control"}}},beforeOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},beforeClose:{parameters:{openBy:{type:"sap.ui.core.Control"}}},itemSelect:{parameters:{item:{type:"sap.m.MessagePopoverItem"},messageTypeFilter:{type:"sap.ui.core.MessageType"}}},listSelect:{parameters:{messageTypeFilter:{type:"sap.ui.core.MessageType"}}},longtextLoaded:{},urlValidated:{},activeTitlePress:{parameters:{item:{type:"sap.m.MessageItem"}}}}}});
function d(n){return n.charAt(0).toUpperCase()+n.slice(1);}
var e="sapMMsgPopover",f="320px",g="440px",h={back:I.getIconURI("nav-back"),close:I.getIconURI("decline"),information:I.getIconURI("message-information"),warning:I.getIconURI("message-warning"),error:I.getIconURI("message-error"),success:I.getIconURI("message-success")},A=["asyncDescriptionHandler","asyncURLHandler"],i={asyncDescriptionHandler:function(j){var l=j.item.getLongtextUrl();if(l){q.ajax({type:"GET",url:l,success:function(k){j.item.setDescription(k);j.promise.resolve();},error:function(){var E="A request has failed for long text data. URL: "+l;L.error(E);j.promise.reject(E);}});}}};
c.setDefaultHandlers=function(m){A.forEach(function(F){if(m.hasOwnProperty(F)){i[F]=m[F];}});};
c.prototype.init=function(){var t=this;var p;this._oOpenByControl=null;this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._oMessageView=this._initMessageView();this._oMessageView.addEventDelegate({onBeforeRendering:function(){var s=t._oMessageView._oSegmentedButton.getVisible(),j=!t.getInitiallyExpanded()||s;t._oMessageView._oSegmentedButton.setVisible(j);t._oMessageView._listPage.setShowHeader(true);}});this._insertCloseBtn(this._oMessageView._oListHeader);this._insertCloseBtn(this._oMessageView._oDetailsHeader);this._oMessageView._oSegmentedButton.attachEvent("select",this._onSegButtonSelect,this);this._oPopover=new R(this.getId()+"-messagePopover",{showHeader:false,contentWidth:g,contentHeight:f,placement:this.getPlacement(),showCloseButton:false,verticalScrolling:false,horizontalScrolling:false,modal:false,afterOpen:function(E){t.fireAfterOpen({openBy:E.getParameter("openBy")});},afterClose:function(E){t._oMessageView._navContainer.backToTop();t.fireAfterClose({openBy:E.getParameter("openBy")});},beforeOpen:function(E){t.fireBeforeOpen({openBy:E.getParameter("openBy")});},beforeClose:function(E){t.fireBeforeClose({openBy:E.getParameter("openBy")});}}).addStyleClass(e);this._oPopover._setAriaModal(false);this._oPopover.addContent(this._oMessageView);this._oPopover.addAssociation("ariaLabelledBy",this.getId()+"-messageView-HeadingDescr",true);p=this._oPopover.getAggregation("_popup");p.oPopup.setAutoClose(false);p.addEventDelegate({onBeforeRendering:this.onBeforeRenderingPopover,onAfterRendering:this.onAfterRenderingPopover},this);if(D.system.phone){this._oPopover.setBeginButton(new B({text:this._oResourceBundle.getText("MESSAGEPOPOVER_CLOSE"),press:this.close.bind(this)}));}A.forEach(function(F){if(i.hasOwnProperty(F)){this['set'+d(F)](i[F]);}},this);};
c.prototype.onBeforeRendering=function(){if(this.getDependents().indexOf(this._oPopover)===-1){this.addDependent(this._oPopover);}this._oPopover.setPlacement(this.getPlacement());};
c.prototype.onBeforeRenderingPopover=function(){if(this._oMessageView&&this._bItemsChanged){var j=this.getItems();var t=this;this._oMessageView.destroyItems();j.forEach(function(k){k._updateProperties(function(){t._bItemsChanged=true;});this._oMessageView.addItem(k.clone("","",{cloneChildren:true,cloneBinding:true}));},this);this._bItemsChanged=false;}this._setInitialFocus();if(this._oOpenByControl&&!this._oOpenByControl.getVisible()){this._oPopover.close();}this._syncMessageView();};
c.prototype.onAfterRenderingPopover=function(){if(this._oPopover._oControl._sFocusControlId){this._oPopover._oControl._sFocusControlId=null;}};
c.prototype.exit=function(){this._oResourceBundle=null;this._oOpenByControl=null;if(this._oMessageView){this._oMessageView.destroy();this._oMessageView=null;}if(this._oPopover){this._oPopover.destroy();this._oPopover=null;}};
c.prototype.openBy=function(o){var r=this._oPopover.getAggregation("_popup"),p=o.getParent();this._oOpenByControl=o;if(r instanceof P){if((p instanceof T||p instanceof a||p instanceof S)){r._minDimensions={width:400,height:128};r.setShowArrow(false);r.setResizable(true);}else{r.setShowArrow(true);}}if(this._oPopover){this._restoreExpansionDefaults();this._oPopover.openBy(o);}return this;};
c.prototype.close=function(){if(this._oPopover){this._oPopover.close();}return this;};
c.prototype.isOpen=function(){return this._oPopover.isOpen();};
c.prototype.toggle=function(o){if(this.isOpen()){this.close();}else{this.openBy(o);}return this;};
c.prototype.getDomRef=function(s){return this._oPopover&&this._oPopover.getAggregation("_popup").getDomRef(s);};
c.prototype._initMessageView=function(){var t=this,m;m=new M(this.getId()+"-messageView",{activeTitlePress:function(E){if(D.system.phone){t.close();}t.fireActiveTitlePress({item:E.getParameter("item")});},listSelect:function(E){t.fireListSelect({messageTypeFilter:E.getParameter('messageTypeFilter')});},itemSelect:function(E){t.fireItemSelect({messageTypeFilter:E.getParameter('messageTypeFilter'),item:E.getParameter('item')});},longtextLoaded:function(){t.fireLongtextLoaded();},urlValidated:function(){t.fireUrlValidated();}});m._makeAutomaticBinding=function(){var j=t.getItems();if(!t.getBindingInfo("items")&&!j.length){this._bindToMessageModel();}};return m;};
c.prototype._onSegButtonSelect=function(){if(this.isOpen()&&!this.getInitiallyExpanded()&&this._oPopover.hasStyleClass(e+"-init")){this._expandMsgPopover();}};
c.prototype._restoreExpansionDefaults=function(){if(this._oMessageView&&!this.getInitiallyExpanded()&&this.getItems().length!=1){this._collapseMsgPopover();this._oMessageView._oSegmentedButton.setSelectedButton("none");}else{this._expandMsgPopover();}};
c.prototype._expandMsgPopover=function(){var s,H=f,s=this._oPopover.$("cont").css("height");if(this.getInitiallyExpanded()&&s!=="0px"){H=parseFloat(s)?s:H;}this._oPopover.setContentHeight(H).removeStyleClass(e+"-init");};
c.prototype._collapseMsgPopover=function(){this._oPopover.addStyleClass(e+"-init").setContentHeight("auto");};
c.prototype._insertCloseBtn=function(o){var s=this._oResourceBundle.getText("MESSAGEPOPOVER_CLOSE"),j=new B({icon:h["close"],visible:!D.system.phone,tooltip:s,press:this.close.bind(this)}).addStyleClass(e+"CloseBtn");o.insertContent(j,3,true);};
c.prototype._setInitialFocus=function(){if(this._oMessageView&&this._oMessageView._isListPage()&&this.getInitiallyExpanded()){this._oPopover.setInitialFocus(this._oMessageView._oLists[this._sCurrentList||'all']);}};
c.prototype._syncMessageView=function(){if(this._oMessageView){this._oMessageView.setProperty('asyncDescriptionHandler',this.getAsyncDescriptionHandler(),true);this._oMessageView.setProperty('asyncURLHandler',this.getAsyncURLHandler(),true);this._oMessageView.setProperty("groupItems",this.getGroupItems(),false);}};
c.prototype.setModel=function(m,n){if(this._oMessageView){this._oMessageView.setModel(m,n);}return C.prototype.setModel.apply(this,arguments);};
c.prototype.navigateBack=function(){if(this._oMessageView){this._oMessageView.navigateBack();}};
["invalidate","addStyleClass","removeStyleClass","toggleStyleClass","hasStyleClass","getBusyIndicatorDelay","setBusyIndicatorDelay","getVisible","setVisible","getBusy","setBusy"].forEach(function(n){c.prototype[n]=function(){if(this._oPopover&&this._oPopover[n]){var p=this._oPopover;var r=p[n].apply(p,arguments);return r===p?this:r;}};});["setModel","bindAggregation","setAggregation","insertAggregation","addAggregation","removeAggregation","removeAllAggregation","destroyAggregation"].forEach(function(F){c.prototype["_"+F+"Old"]=c.prototype[F];c.prototype[F]=function(){var r=c.prototype["_"+F+"Old"].apply(this,arguments);this._bItemsChanged=true;if(this._oPopover){this._oPopover.invalidate();}if(["removeAggregation","removeAllAggregation"].indexOf(F)!==-1){return r;}return this;};});return c;});
sap.ui.predefine('sap/m/MessagePopoverItem',["./library","./MessageItem"],function(l,M){"use strict";
var a=M.extend("sap.m.MessagePopoverItem",{});
return a;});
sap.ui.predefine('sap/m/MessagePopoverRenderer',[],function(){"use strict";var M={apiVersion:2};
M.render=function(r,c){};
return M;},true);
sap.ui.predefine('sap/m/MessageStrip',["./library","sap/ui/core/Control","./MessageStripUtilities","./Text","./Link","./FormattedText","sap/ui/core/library","./MessageStripRenderer","sap/base/Log","sap/m/Button","sap/ui/core/Core","sap/ui/core/InvisibleText"],function(l,C,M,T,L,F,c,a,b,B,d,I){"use strict";var e=c.MessageType;var f=l.ButtonType;
var g=C.extend("sap.m.MessageStrip",{metadata:{library:"sap.m",designtime:"sap/m/designtime/MessageStrip.designtime",properties:{text:{type:"string",group:"Appearance",defaultValue:""},type:{type:"sap.ui.core.MessageType",group:"Appearance",defaultValue:e.Information},customIcon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:""},showIcon:{type:"boolean",group:"Appearance",defaultValue:false},showCloseButton:{type:"boolean",group:"Appearance",defaultValue:false},enableFormattedText:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"link",aggregations:{link:{type:"sap.m.Link",multiple:false,singularName:"link"},_formattedText:{type:"sap.m.FormattedText",multiple:false,visibility:"hidden"},_text:{type:"sap.m.Text",multiple:false,visibility:"hidden"},_closeButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},events:{close:{}},dnd:{draggable:true,droppable:false}}});
g.prototype.init=function(){this.data("sap-ui-fastnavgroup","true",true);this.setAggregation("_text",new T());this._initCloseButton();};
g.prototype.setText=function(t){var o=this.getAggregation("_formattedText");if(o){o.setHtmlText(t);}this.getAggregation("_text").setText(t);return this.setProperty("text",t);};
g.prototype.setType=function(t){if(!t||t===e.None){b.warning(M.MESSAGES.TYPE_NOT_SUPPORTED);t=e.Information;}this.getType()!==t&&this._setButtonAriaLabelledBy(t);return this.setProperty("type",t);};
g.prototype.close=function(){var h=function(){this.setVisible(false);this.fireClose();}.bind(this);if(!d.getConfiguration().getAnimation()){h();return;}M.closeTransitionWithCSS.call(this,h);};
g.prototype.setEnableFormattedText=function(E){var o=this.getAggregation("_formattedText");if(E){if(!o){o=new F();o._setUseLimitedRenderingRules(true);this.setAggregation("_formattedText",o);}o.setHtmlText(this.getText());}return this.setProperty("enableFormattedText",E);};
g.prototype.setAggregation=function(n,o,s){if(n==="link"&&o instanceof L){o.addAriaDescribedBy(this.getId());}C.prototype.setAggregation.call(this,n,o,s);return this;};
a.getAccessibilityState=function(){var A=M.getAccessibilityState.call(this),o=this.getLink(),r=d.getLibraryResourceBundle("sap.m");if(!o){A.labelledby=this.getId();}A.roledescription=r.getText("MESSAGE_STRIP_ARIA_ROLE_DESCRIPTION");return A;};
g.prototype.ontouchmove=function(E){E.setMarked();};
g.prototype._initCloseButton=function(){var r=d.getLibraryResourceBundle("sap.m"),o=this.getAggregation("_closeButton");if(!o){var h=new B({type:f.Transparent,tooltip:r.getText("MESSAGE_STRIP_TITLE"),icon:"sap-icon://decline",press:this.close.bind(this)}).addStyleClass(M.CLASSES.CLOSE_BUTTON).addStyleClass("sapUiSizeCompact");this.setAggregation("_closeButton",h);this._setButtonAriaLabelledBy(this.getType());}};
g.prototype._setButtonAriaLabelledBy=function(t){var o=this.getAggregation("_closeButton"),r=d.getLibraryResourceBundle("sap.m"),s=r.getText("MESSAGE_STRIP_"+t.toUpperCase()+"_CLOSE_BUTTON");if(!this._oInvisibleText){this._oInvisibleText=new I({text:s}).toStatic();}else{this._oInvisibleText.setText(s);}if(o){o.removeAllAriaLabelledBy();o.addAriaLabelledBy(this._oInvisibleText.getId());}};
g.prototype.exit=function(){if(this._oInvisibleText){this._oInvisibleText.destroy();this._oInvisibleText=null;}};
return g;});
sap.ui.predefine('sap/m/MessageStripRenderer',["./MessageStripUtilities"],function(M){"use strict";var a={apiVersion:2};
a.render=function(r,c){this.startMessageStrip(r,c);this.renderAriaTypeText(r,c);if(c.getShowIcon()){this.renderIcon(r,c);}this.renderTextAndLink(r,c);if(c.getShowCloseButton()){this.renderCloseButton(r,c);}this.endMessageStrip(r);};
a.startMessageStrip=function(r,c){r.openStart("div",c);r.class(M.CLASSES.ROOT);r.class(M.CLASSES.ROOT+c.getType());r.attr(M.ATTRIBUTES.CLOSABLE,c.getShowCloseButton());r.accessibilityState(c,this.getAccessibilityState.call(c));r.openEnd();};
a.renderAriaTypeText=function(r,c){r.openStart("span");r.class("sapUiPseudoInvisibleText");r.openEnd();r.text(M.getAriaTypeText.call(c));r.close("span");};
a.renderIcon=function(r,c){r.openStart("div");r.class(M.CLASSES.ICON);r.openEnd();r.icon(M.getIconURI.call(c),null,{"title":null,"aria-hidden":true});r.close("div");};
a.renderTextAndLink=function(r,c){var f=c.getAggregation("_formattedText");r.openStart("div");r.class(M.CLASSES.MESSAGE);r.openEnd();if(c.getEnableFormattedText()&&f){r.renderControl(f);}else{r.renderControl(c.getAggregation("_text"));}r.renderControl(c.getLink());r.close("div");};
a.renderCloseButton=function(r,c){r.renderControl(c.getAggregation("_closeButton"));};
a.endMessageStrip=function(r){r.close("div");};
return a;},true);
sap.ui.predefine('sap/m/MessageStripUtilities',function(){"use strict";var M={};M.MESSAGES={TYPE_NOT_SUPPORTED:"Value 'sap.ui.core.MessageType.None' for property 'type' is not supported."+"Defaulting to 'sap.ui.core.MessageType.Information'"};M.CLASSES={ROOT:"sapMMsgStrip",ICON:"sapMMsgStripIcon",MESSAGE:"sapMMsgStripMessage",CLOSE_BUTTON:"sapMMsgStripCloseButton",CLOSING_TRANSITION:"sapMMsgStripClosing"};M.ATTRIBUTES={CLOSABLE:"data-sap-ui-ms-closable"};M.RESOURCE_BUNDLE=sap.ui.getCore().getLibraryResourceBundle("sap.m");
M.getIconURI=function(){var t=this.getType(),c=this.getCustomIcon(),i="sap-icon://message-"+t.toLowerCase();return c||i;};
M.getAriaTypeText=function(){var b="MESSAGE_STRIP_"+this.getType().toUpperCase(),a=M.RESOURCE_BUNDLE.getText(b);if(this.getShowCloseButton()){a+=" "+M.RESOURCE_BUNDLE.getText("MESSAGE_STRIP_CLOSABLE");}return a;};
M.isMSCloseButtonPressed=function(t){return t.className.indexOf(M.CLASSES.CLOSE_BUTTON)!==-1||t.parentNode.className.indexOf(M.CLASSES.CLOSE_BUTTON)!==-1;};
M.closeTransitionWithCSS=function(c){this.$().addClass(M.CLASSES.CLOSING_TRANSITION).one("webkitTransitionEnd transitionend",c);};
M.getAccessibilityState=function(){return{role:"note",live:"assertive"};};
return M;});
sap.ui.predefine('sap/m/MessageToast',['./InstanceManager','sap/ui/core/Popup','sap/ui/core/library','sap/ui/core/Control','sap/ui/Device',"sap/base/Log","sap/ui/thirdparty/jquery"],function(I,P,c,C,D,L,q){"use strict";var a=c.Dock;var d=c.CSSSize;var M={};var O="0 -64",e="sapMMessageToast",E="sapUiSelectable",B="sapContrast",f="sapContrastPlus";M._mSettings={duration:3000,width:"15em",my:"center bottom",at:"center bottom",of:document.defaultView,offset:"0 0",collision:"fit fit",onClose:null,animationTimingFunction:"ease",animationDuration:1000,autoClose:true,closeOnBrowserNavigation:true};M._aPopups=[];M._iOpenedPopups=0;M._bBoundedEvents=false;
M._validateSettings=function(s){M._isFiniteInteger(s.duration);M._validateWidth(s.width);M._validateDockPosition(s.my);M._validateDockPosition(s.at);M._validateOf(s.of);M._validateOffset(s.offset);M._validateCollision(s.collision);M._validateOnClose(s.onClose);M._validateAutoClose(s.autoClose);M._validateAnimationTimingFunction(s.animationTimingFunction);M._isFiniteInteger(s.animationDuration);};
M._isFiniteInteger=function(N){if(typeof N!=="number"||!isFinite(N)||!(Math.floor(N)===N)||N<=0){L.error('"iNumber" needs to be a finite positive nonzero integer on '+M+"._isFiniteInteger");}};
M._validateWidth=function(w){if(!d.isValid(w)){L.error(w+' is not of type '+'"sap.ui.core.CSSSize" for property "width" on '+M+"._validateWidth");}};
M._validateDockPosition=function(s){if(!a.isValid(s)){L.error('"'+s+'"'+' is not of type '+'"sap.ui.core.Popup.Dock" on '+M+"._validateDockPosition");}};
M._validateOf=function(v){if(!(v instanceof q)&&!(v&&v.nodeType===1)&&!(v instanceof C)&&v!==window){L.error('"of" needs to be an instance of sap.ui.core.Control or an Element or a jQuery object or the window on '+M+"._validateOf");}};
M._validateOffset=function(o){if(typeof o!=="string"){L.error(o+' is of type '+typeof o+', expected "string" for property "offset" on '+M+"._validateOffset");}};
M._validateCollision=function(s){var r=/^(fit|flip|none|flipfit|flipflip|flip flip|flip fit|fitflip|fitfit|fit fit|fit flip)$/i;if(!r.test(s)){L.error('"collision" needs to be a single value “fit”, “flip”, or “none”, or a pair for horizontal and vertical e.g. "fit flip”, "fit none", "flipfit" on '+M+"._validateOffset");}};
M._validateOnClose=function(b){if(typeof b!=="function"&&b!==null){L.error('"onClose" should be a function or null on '+M+"._validateOnClose");}};
M._validateAutoClose=function(b){if(typeof b!=="boolean"){L.error('"autoClose" should be a boolean on '+M+"._validateAutoClose");}};
M._validateAnimationTimingFunction=function(t){var r=/^(ease|linear|ease-in|ease-out|ease-in-out)$/i;if(!r.test(t)){L.error('"animationTimingFunction" should be a string, expected values: '+"ease, linear, ease-in, ease-out, ease-in-out on "+M+"._validateAnimationTimingFunction");}};
function h(o){for(var p=["my","at","of","offset"],i=0;i<p.length;i++){if(o[p[i]]!==undefined){return false;}}return true;}
function g(s){var m=document.createElement("div");m.className=e+" "+E+" "+B+" "+f;if(sap.ui.getCore().getConfiguration().getAccessibility()){m.setAttribute("role","alert");m.setAttribute("aria-label"," ");}m.style.width=s.width;m.appendChild(document.createTextNode(s.message));return m;}
function n(o){if(o){if(h(o)){o.offset=O;}if(o.of&&o.of.nodeType===9){o.of=document.defaultView;}}else{o={offset:O};}return o;}
M._handleResizeEvent=function(){if(D.system.phone||D.system.tablet){M._resetPosition(M._aPopups);}setTimeout(M["_applyPositions"].bind(M,M._aPopups),0);};
M._handleMouseDownEvent=function(o){var i=o.target.hasAttribute("class")&&o.target.getAttribute("class").indexOf(e)!==-1;if(i||o.isMarked("delayedMouseEvent")){return;}M._aPopups.forEach(function(p){p&&p.__bAutoClose&&p.close();});};
M._resetPosition=function(p){for(var i=0,m;i<p.length;i++){m=p[i]&&p[i].getContent();if(m){m.style.visibility="hidden";m.style.left=0;}}};
M._applyPositions=function(p){for(var i=0,o,m;i<p.length;i++){o=p[i];if(o){m=o._oPosition;if(D.system.phone||D.system.tablet){setTimeout(M["_applyPosition"].bind(M,o,m),0);}else{o.setPosition(m.my,m.at,m.of,m.offset);}}}};
M._applyPosition=function(p,m){m=m||p._oPosition;var o=p.getContent();p.setPosition(m.my,m.at,m.of,m.offset);o.style.visibility="visible";};
M._setCloseAnimation=function(m,i,b,s){var j="opacity "+s.animationTimingFunction+" "+s.animationDuration+"ms",t="webkitTransitionEnd."+e+" transitionend."+e;if(sap.ui.getCore().getConfiguration().getAnimation()&&s.animationDuration>0){m[0].style.webkitTransition=j;m[0].style.transition=j;m[0].style.opacity=0;m.on(t,function k(){m.off(t);b();});}else{b();}};
M.show=function(m,o){var t=M,s=q.extend({},M._mSettings,{message:m}),p=new P(),i,b,j="mousedown."+e+" touchstart."+e,k,l;o=n(o);q.extend(s,o);M._validateSettings(s);b=g(s);i=M._aPopups.push(p)-1;p.setContent(b);p.setPosition(s.my,s.at,s.of,s.offset,s.collision);p.setAnimations(function x($,v,w){w();},function x($,v,w){t._setCloseAnimation($,v,w,s);});p.setShadow(false);p.__bAutoClose=s.autoClose;if(s.closeOnBrowserNavigation){I.addPopoverInstance(p);}if(!M._bBoundedEvents){q(window).on("resize."+e,M._handleResizeEvent.bind(M));q(document).on(j,M._handleMouseDownEvent.bind(M));M._bBoundedEvents=true;}p.open();M._iOpenedPopups++;function r(){I.removePopoverInstance(t._aPopups[i]);q(t._aPopups[i].getContent()).remove();t._aPopups[i].detachClosed(r);t._aPopups[i].destroy();t._aPopups[i]=null;t._iOpenedPopups--;if(t._iOpenedPopups===0){t._aPopups=[];q(window).off("resize."+e);q(document).off(j);t._bBoundedEvents=false;}if(typeof s.onClose==="function"){s.onClose.call(t);}}p.attachClosed(r);k=setTimeout(p["close"].bind(p),s.duration);function u(){clearTimeout(k);k=null;function v(){l=setTimeout(p["close"].bind(p),s.duration);p.getContent().removeEventListener("mouseleave",v);}p.getContent().addEventListener("mouseleave",v);clearTimeout(l);l=null;}p.getContent().addEventListener("touchstart",u);p.getContent().addEventListener("mouseover",u);if(D.system.desktop){p.getContent().addEventListener("mouseleave",function(){k=setTimeout(p["close"].bind(p),s.duration);});}};
M.toString=function(){return"sap.m.MessageToast";};
return M;},true);
sap.ui.predefine('sap/m/MessageView',["sap/ui/thirdparty/jquery","sap/ui/core/Control","sap/ui/core/CustomData","sap/ui/core/IconPool","sap/ui/core/HTML","sap/ui/core/Icon","./Button","./Toolbar","./ToolbarSpacer","./List","./MessageListItem","./library","./Text","./SegmentedButton","./Page","./NavContainer","./Link","./MessageItem","./GroupHeaderListItem","sap/ui/core/library","sap/ui/base/ManagedObject","./MessageViewRenderer","sap/ui/events/KeyCodes","sap/base/Log","sap/base/security/URLWhitelist","sap/ui/thirdparty/caja-html-sanitizer"],function(q,C,a,I,H,b,B,T,c,L,M,l,d,S,P,N,e,f,G,g,h,j,K,k,U){"use strict";var V=g.ValueState;var m=g.MessageType;var n=l.ListType;
var o=C.extend("sap.m.MessageView",{metadata:{library:"sap.m",properties:{asyncDescriptionHandler:{type:"any",group:"Behavior",defaultValue:null},asyncURLHandler:{type:"any",group:"Behavior",defaultValue:null},groupItems:{type:"boolean",group:"Behavior",defaultValue:false},showDetailsPageHeader:{type:"boolean",group:"Behavior",defaultValue:true}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.MessageItem",multiple:true,singularName:"item"},headerButton:{type:"sap.m.Button",multiple:false},_navContainer:{type:"sap.m.NavContainer",multiple:false,visibility:"hidden"}},events:{afterOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},itemSelect:{parameters:{item:{type:"sap.m.MessageItem"},messageTypeFilter:{type:"sap.ui.core.MessageType"}}},listSelect:{parameters:{messageTypeFilter:{type:"sap.ui.core.MessageType"}}},longtextLoaded:{},urlValidated:{},activeTitlePress:{parameters:{item:{type:"sap.m.MessageItem"}}}}}});
var p="sapMMsgView";var r={back:I.getIconURI("nav-back"),close:I.getIconURI("decline"),information:I.getIconURI("message-information"),warning:I.getIconURI("message-warning"),error:I.getIconURI("message-error"),success:I.getIconURI("message-success")};var s=["all","error","warning","success","information"];var A=["asyncDescriptionHandler","asyncURLHandler"];var D={asyncDescriptionHandler:function(i){var t=i.item.getLongtextUrl();if(t){q.ajax({type:"GET",url:t,success:function(u){i.item.setDescription(u);i.promise.resolve();},error:function(){var E="A request has failed for long text data. URL: "+t;k.error(E);i.promise.reject(E);}});}}};
o.setDefaultHandlers=function(i){A.forEach(function(F){if(i.hasOwnProperty(F)){D[F]=i[F];}});};
o.prototype.init=function(){var t=this;this._bHasHeaderButton=false;this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._createNavigationPages();this._createLists();A.forEach(function(F){if(D.hasOwnProperty(F)){t.setProperty(F,D[F]);}});};
o.prototype._afterNavigate=function(){setTimeout(this["_restoreFocus"].bind(this),0);setTimeout(this["_restoreItemsType"].bind(this),0);};
o.prototype._restoreFocus=function(){if(this._isListPage()&&this.getItems().length){this._oLists[this._sCurrentList||'all'].focus();}else if(this._oBackButton){this._oBackButton.focus();}};
o.prototype._restoreItemsType=function(){if(this._isListPage()&&this.getItems().length>1){var t=this;this._oLists[this._sCurrentList||'all'].getItems().forEach(function(i){if(i.isA("sap.m.MessageListItem")){t._setItemType(i);}});}};
o.prototype._setItemType=function(i){var t,u=i.getActiveTitle();if(!i.getTitle()||!i.getDescription()){if(u){t=".sapMSLITitleOnly a";}else{t=".sapMSLITitleOnly";}}else if(u){t=".sapMSLITitle a";}else{t=".sapMSLITitle";}var v=i.getDomRef().querySelector(t);if(v.offsetWidth<v.scrollWidth){i.setType(n.Navigation);if(this.getItems().length===1){this._fnHandleForwardNavigation(i,"show");}}};
o.prototype.onBeforeRendering=function(){var i,t=this.getItems();this._clearLists();this._detailsPage.setShowHeader(this.getShowDetailsPageHeader());if(this.getGroupItems()){i=this._groupItems(t);this._fillGroupedLists(i);}else{this._fillLists(t);}var u=this.getHeaderButton();if(u){this._bHasHeaderButton=true;this._oListHeader.insertContent(u,2);}this._clearSegmentedButton();this._fillSegmentedButton();this._fnFilterList(this._getCurrentMessageTypeFilter()||"all");if(t.length===1&&this._oLists.all.getItems()[0].getType()===n.Navigation){this._fnHandleForwardNavigation(this._oLists.all.getItems()[0],"show");this._navContainer._pageStack[this._navContainer._pageStack.length-1].transition="slide";}this._makeAutomaticBinding();};
o.prototype._fillGroupedLists=function(i){var t=Object.keys(i),u=t.indexOf(""),v;if(u!==-1){v=i[""];this._fillLists(v);delete i[""];t.splice(u,1);}t.forEach(function(w){this._fillListsWithGroups(w,i[w]);},this);};
o.prototype._fillListsWithGroups=function(i,t){var u=new G({title:i});this._oLists["all"].addAggregation("items",u,true);this._fillLists(t);};
o.prototype.exit=function(){if(this._oLists){this._destroyLists();}if(this._oMessageItemTemplate){this._oMessageItemTemplate.destroy();}this._oResourceBundle=null;this._oListHeader=null;this._oDetailsHeader=null;this._oSegmentedButton=null;this._oBackButton=null;this._navContainer=null;this._listPage=null;this._detailsPage=null;this._sCurrentList=null;};
o.prototype._makeAutomaticBinding=function(){var i=this.getItems();if(!this.getBindingInfo("items")&&!i.length){this._bindToMessageModel();}};
o.prototype._bindToMessageModel=function(){var t=this;this.setModel(sap.ui.getCore().getMessageManager().getMessageModel(),"message");this._oMessageItemTemplate=new f({type:"{message>type}",title:"{message>message}",description:"{message>description}",longtextUrl:"{message>longtextUrl}"});this.bindAggregation("items",{path:"message>/",template:t._oMessageItemTemplate});};
o.prototype._groupItems=function(i){var t={},u;i.forEach(function(v){u=v.getGroupName();t[u]=t[u]||[];t[u].push(v);});return t;};
o.prototype._onkeypress=function(E){if(E.shiftKey&&E.keyCode==K.ENTER){this.navigateBack();}};
o.prototype._getListHeader=function(){return this._oListHeader||this._createListHeader();};
o.prototype._getDetailsHeader=function(){return this._oDetailsHeader||this._createDetailsHeader();};
o.prototype._createListHeader=function(){var i=this._oResourceBundle.getText("MESSAGEPOPOVER_CLOSE");var t=this.getId()+"-CloseBtnDescr";var u=new H(t,{content:"<span id=\""+t+"\" style=\"display: none;\">"+i+"</span>"});var v=this._oResourceBundle.getText("MESSAGEPOPOVER_ARIA_HEADING");var w=this.getId()+"-HeadingDescr";var x=new H(w,{content:"<span id=\""+w+"\" style=\"display: none;\" role=\"heading\">"+v+"</span>"});this._oSegmentedButton=new S(this.getId()+"-segmented",{}).addStyleClass("sapMSegmentedButtonNoAutoWidth");this._oListHeader=new T({content:[this._oSegmentedButton,new c(),u,x]});return this._oListHeader;};
o.prototype._createDetailsHeader=function(){var i=this._oResourceBundle.getText("MESSAGEPOPOVER_CLOSE");var t=this.getId()+"-CloseBtnDetDescr";var u=new H(t,{content:"<span id=\""+t+"\" style=\"display: none;\">"+i+"</span>"});var v=this._oResourceBundle.getText("MESSAGEPOPOVER_ARIA_BACK_BUTTON_TOOLTIP");var w=this._oResourceBundle.getText("MESSAGEPOPOVER_ARIA_BACK_BUTTON");var x=this.getId()+"-BackBtnDetDescr";var y=new H(x,{content:"<span id=\""+x+"\" style=\"display: none;\">"+w+"</span>"});this._oBackButton=new B({icon:r["back"],press:this.navigateBack.bind(this),ariaLabelledBy:y,tooltip:v}).addStyleClass(p+"BackBtn");this._oDetailsHeader=new T({content:[this._oBackButton,new c(),u,y]});return this._oDetailsHeader;};
o.prototype._createNavigationPages=function(){this._listPage=new P(this.getId()+"listPage",{customHeader:this._getListHeader()});this._detailsPage=new P(this.getId()+"-detailsPage",{customHeader:this._getDetailsHeader()});this._detailsPage.addEventDelegate({onclick:function(E){var t=E.target;if(t.nodeName.toUpperCase()==="A"&&(t.className.indexOf("sapMMsgViewItemDisabledLink")!==-1||t.className.indexOf("sapMMsgViewItemPendingLink")!==-1)){E.preventDefault();}}});this._navContainer=new N(this.getId()+"-navContainer",{initialPage:this.getId()+"listPage",pages:[this._listPage,this._detailsPage],afterNavigate:this._afterNavigate.bind(this)});this.setAggregation("_navContainer",this._navContainer);return this;};
o.prototype._createLists=function(){this._oLists={};s.forEach(function(i){this._oLists[i]=new L({itemPress:this._fnHandleItemPress.bind(this),visible:false});this._listPage.addAggregation("content",this._oLists[i],true);},this);return this;};
o.prototype._clearLists=function(){s.forEach(function(i){if(this._oLists[i]){this._oLists[i].destroyAggregation("items",true);}},this);return this;};
o.prototype._destroyLists=function(){s.forEach(function(i){this._oLists[i]=null;},this);this._oLists=null;};
o.prototype._fillLists=function(i){i.forEach(function(t){var u=this._mapItemToListItem(t),v=this._mapItemToListItem(t);this._oLists["all"].addAggregation("items",u,true);this._oLists[t.getType().toLowerCase()].addAggregation("items",v,true);},this);};
o.prototype._mapItemToListItem=function(i){if(!i){return null;}var t=i.getType(),u=this,v=this._getItemType(i),w=new M({title:h.escapeSettingsValue(i.getTitle()),description:h.escapeSettingsValue(i.getSubtitle()),counter:i.getCounter(),icon:this._mapIcon(t),infoState:this._mapInfoState(t),info:"\r",type:v,messageType:i.getType(),activeTitle:i.getActiveTitle(),activeTitlePress:function(){u.fireActiveTitlePress({item:i});}}).addStyleClass(p+"Item").addStyleClass(p+"Item"+t).toggleStyleClass(p+"ItemActive",i.getActiveTitle());if(v!==n.Navigation){w.addEventDelegate({onAfterRendering:function(){u._setItemType(w);}},this);}w._oMessageItem=i;return w;};
o.prototype._mapInfoState=function(t){if(!t){return null;}switch(t){case m.Warning:return V.Warning;case m.Error:return V.Error;case m.Success:return V.Success;case m.Information:case m.None:return V.None;default:k.warning("The provided MessageType is not mapped to a specific ValueState",t);return null;}};
o.prototype._mapIcon=function(i){if(!i){return null;}return r[i.toLowerCase()];};
o.prototype._getItemType=function(i){return(i.getDescription()||i.getMarkupDescription()||i.getLongtextUrl())?n.Navigation:n.Inactive;};
o.prototype._clearSegmentedButton=function(){if(this._oSegmentedButton){this._oSegmentedButton.destroyAggregation("buttons",true);}return this;};
o.prototype._fillSegmentedButton=function(){var t=this;var i=function(w){return function(){t._fnFilterList(w);};};s.forEach(function(w){var x=this._oLists[w],y=w=="all"?"MESSAGEPOPOVER_ALL":"MESSAGEVIEW_BUTTON_TOOLTIP_"+w.toUpperCase(),z=x.getItems().filter(function(F){return(F instanceof M);}).length,E;if(z>0){E=new B(this.getId()+"-"+w,{text:w=="all"?this._oResourceBundle.getText(y):z,tooltip:this._oResourceBundle.getText(y),icon:r[w],press:i(w)}).addStyleClass(p+"Btn"+w.charAt(0).toUpperCase()+w.slice(1));this._oSegmentedButton.addButton(E,true);}},this);var u=this._oSegmentedButton.getButtons().length>2;this._oSegmentedButton.setVisible(u);if(!u){this._oSegmentedButton.setSelectedButton(this._oSegmentedButton.getButtons()[0]);this._fnFilterList('all');}var v=u||this._bHasHeaderButton;this._listPage.setShowHeader(v);return this;};
o.prototype._setIcon=function(i,t){this._previousIconTypeClass=p+"DescIcon"+i.getType();this._oMessageIcon=new b({src:t.getIcon()}).addStyleClass(p+"DescIcon").addStyleClass(this._previousIconTypeClass);this._detailsPage.addContent(this._oMessageIcon);};
o.prototype._setTitle=function(i,t){var u=i.getActiveTitle(),v,w=this,x=h.escapeSettingsValue(i.getTitle()),y=this.getId()+"MessageTitleText";if(u){v=new e(y,{text:x,ariaDescribedBy:t.getId()+"-link",press:function(){w.fireActiveTitlePress({item:i});}});}else{v=new d(y,{text:x});}v.addStyleClass("sapMMsgViewTitleText");this._detailsPage.addAggregation("content",v);};
o.prototype._setDescription=function(i){var t=i.getLink();this._oLastSelectedItem=i;if(i.getMarkupDescription()){this._oMessageDescriptionText=new H(this.getId()+"MarkupDescription",{content:"<div class='sapMMsgViewDescriptionText'>"+h.escapeSettingsValue(i.getDescription())+"</div>"});}else{this._oMessageDescriptionText=new d(this.getId()+"MessageDescriptionText",{text:h.escapeSettingsValue(i.getDescription())}).addStyleClass("sapMMsgViewDescriptionText");}this._detailsPage.addContent(this._oMessageDescriptionText);if(t){var u=this._createLinkCopy(t);this._detailsPage.addContent(u);u.addStyleClass("sapMMsgViewDescriptionLink");}};
o.prototype._createLinkCopy=function(i){var t,u=i.clone("","",{cloneChildren:false,cloneBindings:false}),v=i.getCustomData()||[];t=Object.keys(i.getMetadata().getProperties());t.forEach(function(w){u.setProperty(w,i.getProperty(w));});u.destroyCustomData();v.forEach(function(w){var x=new a({key:w.getKey(),value:w.getValue()});u.addCustomData(x);});return u;};
o.prototype._iNextValidationTaskId=0;
o.prototype._validateURL=function(u){if(U.validate(u)){return u;}k.warning("You have entered invalid URL");return"";};
o.prototype._queueValidation=function(i){var t=this.getAsyncURLHandler();var v=++this._iNextValidationTaskId;var u={};var w=new Promise(function(x,y){u.resolve=x;u.reject=y;var z={url:i,id:v,promise:u};t(z);});w.id=v;return w;};
o.prototype._getTagPolicy=function(){var t=this,i;var u=html.makeTagPolicy(this._validateURL());return function O(v,w){var x,y=false;if(v.toUpperCase()==="A"){for(i=0;i<w.length;){if(w[i]==="href"){y=true;x=w[i+1];w.splice(0,2);continue;}i+=2;}}w=u(v,w);if(y&&typeof t.getAsyncURLHandler()==="function"){w=w||[];var z="sapMMsgViewItemDisabledLink sapMMsgViewItemPendingLink";var E=w.indexOf("class");if(E>-1){w[E+1]+=z;}else{w.unshift(z);w.unshift("class");}var F=w.indexOf("id");if(F>-1){w.splice(F+1,1);w.splice(F,1);}var J=t._queueValidation(x);w.push("href");w.push(x);w.push("target");w.push("_blank");w.push("id");w.push("sap-ui-"+t.getId()+"-link-under-validation-"+J.id);J.then(function(Q){var $=q(document.getElementById("sap-ui-"+t.getId()+"-link-under-validation-"+Q.id));if(Q.allowed){k.info("Allow link "+x);}else{k.info("Disallow link "+x);}$.removeClass("sapMMsgViewItemPendingLink");$.toggleClass("sapMMsgViewItemDisabledLink",!Q.allowed);t.fireUrlValidated();}).catch(function(){k.warning("Async URL validation could not be performed.");});}return w;};};
o.prototype._sanitizeDescription=function(i){var t=i.getDescription();if(i.getMarkupDescription()){var u=this._getTagPolicy();t=html.sanitizeWithPolicy(t,u);}i.setDescription(t);this._setDescription(i);};
o.prototype._fnHandleForwardNavigation=function(i,t){var u=i._oMessageItem,v=this._detailsPage.getContent()||[],w=this.getAsyncDescriptionHandler();this._previousIconTypeClass=this._previousIconTypeClass||"";this.fireItemSelect({item:u,messageTypeFilter:this._getCurrentMessageTypeFilter()});this._clearDetailsPage.call(this,v);if(typeof w==="function"&&!!u.getLongtextUrl()){u.setMarkupDescription(true);var x={};var y=new Promise(function(E,F){x.resolve=E;x.reject=F;});var z=function(){this._detailsPage.setBusy(false);this._navigateToDetails.call(this,u,i,t,true);}.bind(this);y.then(z).catch(function(){k.warning("Async description loading could not be performed.");z();});this._navContainer.to(this._detailsPage);this._detailsPage.setBusy(true);w({promise:x,item:u});}else{this._navigateToDetails.call(this,u,i,t,false);}this._listPage.$().attr("aria-hidden","true");};
o.prototype._fnHandleItemPress=function(E){this._fnHandleForwardNavigation(E.getParameter("listItem"),"slide");};
o.prototype._navigateToDetails=function(i,t,u,v){this._setTitle(i,t);this._sanitizeDescription(i);this._setIcon(i,t);this._detailsPage.rerender();this.fireLongtextLoaded();if(!v){this._navContainer.to(this._detailsPage,u);}};
o.prototype._clearDetailsPage=function(i){i.forEach(function(t){t.destroy();},this);};
o.prototype.navigateBack=function(){this._listPage.$().removeAttr("aria-hidden");this._navContainer.back();};
o.prototype._fnFilterList=function(i){s.forEach(function(t){if(t!=i&&this._oLists[t].getVisible()){this._oLists[t].setVisible(false);}},this);this._sCurrentList=i;this._oLists[i].setVisible(true);this.fireListSelect({messageTypeFilter:this._getCurrentMessageTypeFilter()});};
o.prototype._getCurrentMessageTypeFilter=function(){return this._sCurrentList=="all"?"":this._sCurrentList;};
o.prototype._isListPage=function(){return this._navContainer.getCurrentPage()==this._listPage;};
return o;});
sap.ui.predefine('sap/m/MessageViewRenderer',["sap/ui/core/Core"],function(C){"use strict";var M={apiVersion:2};var a="sapMMsgView";
M.render=function(r,c){var R=C.getLibraryResourceBundle("sap.m");r.openStart("div",c);r.class(a);r.accessibilityState(c,{role:"region",label:R.getText("MESSAGE_VIEW_ARIA_LABEL")});r.openEnd();r.renderControl(c._navContainer);r.close("div");};
return M;},true);
sap.ui.predefine('sap/m/MultiComboBox',['./InputBase','./ComboBoxTextField','./ComboBoxBase','./Tokenizer','./Token','./List','./StandardListItem','./Popover','./GroupHeaderListItem','./library','sap/ui/core/EnabledPropagator','sap/ui/core/IconPool','sap/ui/core/library','sap/ui/Device','sap/ui/core/Item','sap/ui/core/SeparatorItem','sap/ui/core/ResizeHandler','./MultiComboBoxRenderer',"sap/ui/dom/containsOrEquals","sap/m/inputUtils/completeTextSelected","sap/m/inputUtils/inputsDefaultFilter","sap/ui/events/KeyCodes","sap/base/util/deepEqual","sap/base/assert","sap/base/Log","sap/ui/core/Core",'sap/ui/core/InvisibleText',"sap/ui/thirdparty/jquery","sap/ui/dom/jquery/cursorPos","sap/ui/dom/jquery/control"],function(I,C,a,T,b,L,S,P,G,l,E,c,d,D,e,f,R,M,g,h,j,K,k,m,n,o,p,q){"use strict";var r=l.ListType;var s=l.ListMode;var V=d.ValueState;var O=d.OpenState;var t=l.TokenizerRenderMode;
var u=a.extend("sap.m.MultiComboBox",{metadata:{library:"sap.m",designtime:"sap/m/designtime/MultiComboBox.designtime",properties:{selectedKeys:{type:"string[]",group:"Data",defaultValue:[]},hasSelection:{type:"boolean",visibility:"hidden",defaultValue:false}},associations:{selectedItems:{type:"sap.ui.core.Item",multiple:true,singularName:"selectedItem"}},aggregations:{tokenizer:{type:"sap.m.Tokenizer",multiple:false,visibility:"hidden"}},events:{selectionChange:{parameters:{changedItem:{type:"sap.ui.core.Item"},selected:{type:"boolean"}}},selectionFinish:{parameters:{selectedItems:{type:"sap.ui.core.Item[]"}}}},dnd:{draggable:false,droppable:true}}});
c.insertFontFaceStyle();E.apply(u.prototype,[true]);
u.prototype.clone=function(i){var v=a.prototype.clone.apply(this,arguments),w=this._getList();if(w){v.syncPickerContent();}return v;};
u.prototype.open=function(){if(!this.isOpen()){this._bPickerIsOpening=true;}this.syncPickerContent();return a.prototype.open.apply(this,arguments);};
u.prototype.onsapend=function(i){if(i.isMarked("forwardFocusToParent")){this.focus();}};
u.prototype.onsaphome=function(i){if(!this.getFocusDomRef().selectionStart){T.prototype.onsaphome.apply(this.getAggregation("tokenizer"),arguments);}i.setMarked();};
u.prototype.onsapdown=function(i){if(!this.getEnabled()||!this.getEditable()){return;}i.setMarked();i.preventDefault();this.syncPickerContent();var v=this.getSelectableItems();var w=v[0];var x=this;if(w&&this.isOpen()&&this.getValueStateLinks().length){this._handleFormattedTextNav();return;}else if(w&&this.isOpen()){setTimeout(function(){x.getListItem(w).focus();},0);return;}if(this.isFocusInTokenizer()){return;}this._oTraversalItem=this._getNextTraversalItem();if(this._oTraversalItem&&!this.isComposingCharacter()){this.updateDomValue(this._oTraversalItem.getText());this.selectText(0,this.getValue().length);}};
u.prototype.onsapup=function(i){if(!this.getEnabled()||!this.getEditable()){return;}i.setMarked();i.preventDefault();this.syncPickerContent();if(this.isFocusInTokenizer()){return;}this._oTraversalItem=this._getPreviousTraversalItem();if(this._oTraversalItem){this.updateDomValue(this._oTraversalItem.getText());this.selectText(0,this.getValue().length);}};
u.prototype.isFocusInTokenizer=function(){return q.contains(this.getAggregation("tokenizer").getFocusDomRef(),document.activeElement);};
u.prototype.onsapshow=function(i){this._handleItemToFocus();a.prototype.onsapshow.apply(this,arguments);};
u.prototype._handlePopupOpenAndItemsLoad=function(){this._handleItemToFocus();a.prototype._handlePopupOpenAndItemsLoad.apply(this,arguments);};
u.prototype._valueStateNavDelegate=function(v,F,i){var w=this;this.oValueStateNavDelegate={};this.oValueStateNavDelegate.onsapdown=function(){w.getListItem(w.getSelectableItems()[0]).focus();};this.oValueStateNavDelegate.onsapup=function(){w.getFocusDomRef().focus();};this.oValueStateNavDelegate.onsapend=function(x){x.preventDefault();var y=w.getSelectableItems();w.getListItem(w.getSelectableItems()[y.length-1]).focus();};this.oValueStateNavDelegate.onfocusout=function(x){v.removeStyleClass("sapMFocusable");if(!v.getDomRef().contains(x.relatedTarget)){i.forEach(function(y){y.getDomRef().setAttribute("tabindex","-1");});}if(D.browser.msie){F.removeStyleClass("sapMPseudoFocus");}};return this.oValueStateNavDelegate;};
u.prototype._closePickerDelegate={onsaptabnext:function(){if(D.browser.msie){this.getPicker().getCustomHeader().getFormattedText().removeStyleClass("sapMPseudoFocus");}this.close();setTimeout(function(){this.closeValueStateMessage();}.bind(this),0);}};u.prototype._formattedTextLinksNav={onsapup:function(){this.focus();},onsapdown:function(){this.getSelectableItems()[0].focus();}};
u.prototype._handleFormattedTextNav=function(){var i=this.getPicker().getCustomHeader(),v=this.getValueStateLinks(),F=i.getFormattedText(),w=this.oValueStateNavDelegate||this._valueStateNavDelegate(i,F,v),x=v?v[v.length-1]:null,y=v?v[0]:null;if(!v.length||i.getDomRef()===document.activeElement){return;}i.getDomRef().setAttribute("tabindex","-1");i.addDelegate(w);i.addStyleClass("sapMFocusable");i.focus();if(D.browser.msie){F.addStyleClass("sapMPseudoFocus");}v.forEach(function(z){z.getDomRef().setAttribute("tabindex","0");z.addDelegate(this._formattedTextLinksNav,this);},this);this.oMoveFocusBackToVSHeader=!this.oMoveFocusBackToVSHeader?{onsaptabprevious:function(z){z.preventDefault();i.focus();i.addStyleClass("sapMFocusable");}}:this.oMoveFocusBackToVSHeader;x.addDelegate(this._closePickerDelegate,this);y.addDelegate(this.oMoveFocusBackToVSHeader,this);};
u.prototype.onsaphide=u.prototype.onsapshow;
u.prototype._selectItemByKey=function(v){var w,x,y,i,z,A,B=this.isOpen();if(!this.getEnabled()||!this.getEditable()){return;}if(v){v.setMarked();}w=this._getUnselectedItems(B?"":this.getValue());for(i=0;i<w.length;i++){A=!(w[i].getKey()===undefined||w[i].getKey()===null)&&!w[i].isA("sap.ui.core.SeparatorItem");if(w[i].getText().toUpperCase()===this.getValue().toUpperCase()&&A){y=w[i];z=true;break;}}if(z){x={item:y,id:y.getId(),key:y.getKey(),fireChangeEvent:true,fireFinishEvent:true,suppressInvalidate:true,listItemUpdated:false};this._bPreventValueRemove=false;if(this.getValue()===""||(typeof this.getValue()==="string"&&y.getText().toLowerCase().startsWith(this.getValue().toLowerCase()))){if(this.getListItem(y).isSelected()){this.setValue('');}else{this.setSelection(x);}}}else{this._bPreventValueRemove=true;}if(v){this.close();}};
u.prototype.onsapenter=function(i){var v=this.getAggregation("tokenizer");I.prototype.onsapenter.apply(this,arguments);this._showAlreadySelectedVisualEffect();if(this.getValue()){this._selectItemByKey(i);}if(!this.getEditable()&&v.getHiddenTokensCount()&&i.target===this.getFocusDomRef()){v._togglePopup(v.getTokensPopup());}};
u.prototype.onsaptabnext=function(i){var v=this.getValue();if(v){var w=this._getUnselectedItemsStartingText(v);if(w.length===1){this._selectItemByKey(i);}else{this._showWrongValueVisualEffect();}}};
u.prototype.onsaptabprevious=u.prototype.onsaptabnext;
u.prototype.onsapfocusleave=function(i){var v=this.isPlatformTablet(),w=o.byId(i.relatedControlId),F=w&&w.getFocusDomRef(),x=this.getValue(),y=this.getPicker(),z=this.getAggregation("tokenizer");if(!this._bPickerIsOpening&&(!y||!y.getFocusDomRef()||!F||!q.contains(y.getFocusDomRef(),F))){this.setValue(null);if(x){this.fireChangeEvent("",{value:x});}if(!q.contains(this.getDomRef(),document.activeElement)){z.setRenderMode(t.Narrow);}}if(y&&F){if(k(y.getFocusDomRef(),F)&&!v&&!this.isPickerDialog()){this.focus();}}};
u.prototype.onfocusin=function(i){var v=this.getPicker();var w=false;var x=v&&v.getFocusDomRef();var y=(v&&v.oPopup.getOpenState())||O.CLOSED;var z=y===O.CLOSING||y===O.CLOSED;var A=this.getPickerType()==="Dropdown";var B=this.getAggregation("tokenizer");if(A){w=x&&q.contains(x,i.relatedTarget);}if(this.getEditable()&&i.target===this.getDomRef("inner")){B.setRenderMode(t.Loose);}if(i.target===this.getFocusDomRef()){B.hasOneTruncatedToken()&&B.setFirstTokenTruncated(false);this.getEnabled()&&this.addStyleClass("sapMFocus");!z&&w&&this.handleInputValidation(i,false);}if(i.target===this.getOpenArea()&&A&&!this.isPlatformTablet()){this.focus();}if(!this.isOpen()&&this.shouldValueStateMessageBeOpened()){this.openValueStateMessage();}};
u.prototype._handleItemTap=function(i){var v=q(i.target).control(0);if(!v.isA("sap.m.CheckBox")&&!v.isA("sap.m.GroupHeaderListItem")){this._bCheckBoxClicked=false;}};
u.prototype._handleItemPress=function(i){if(this.isOpen()&&this._isListInSuggestMode()&&this.getPicker().oPopup.getOpenState()!==O.CLOSING){this.clearFilter();var v=this._getLastSelectedItem();if(v){this.getListItem(v).focus();}}};
u.prototype._handleSelectionLiveChange=function(i){var v=i.getParameter("listItem");var w=i.getParameter("selected");var N=this._getItemByListItem(v);var x=this.isPickerDialog()?this.getPickerTextField():this;if(v.getType()==="Inactive"){return;}m(N,"The corresponding mapped item was not found on "+this);if(!N){return;}var y={item:N,id:N.getId(),key:N.getKey(),fireChangeEvent:true,suppressInvalidate:true,listItemUpdated:true};if(w){this.fireChangeEvent(N.getText());this.setSelection(y);}else{this.fireChangeEvent(N.getText());this.removeSelection(y);}if(this._bCheckBoxClicked){x.setValue(this._sOldInput);if(this.isOpen()&&this.getPicker().oPopup.getOpenState()!==O.CLOSING){v.focus();}}else{this._bCheckBoxClicked=true;this.setValue("");this.close();}};
u.prototype.onkeydown=function(i){var v=this.getEditable(),w=this.getAggregation("tokenizer"),x=w.getTokens().length;a.prototype.onkeydown.apply(this,arguments);if(!this.getEnabled()){return;}if((i.ctrlKey||i.metaKey)&&i.which===K.I&&x){i.preventDefault();if(v){this._togglePopover();}else{this._handleIndicatorPress();}return;}this._bIsPasteEvent=(i.ctrlKey||i.metaKey)&&(i.which===K.V);if(this.getValue().length===0&&(i.ctrlKey||i.metaKey)&&(i.which===K.A)&&this._hasTokens()){w.focus();w.selectAllTokens(true);i.preventDefault();}if(this.isPickerDialog()){this._sOldValue=this.getPickerTextField().getValue();this._iOldCursorPos=q(this.getFocusDomRef()).cursorPos();}this._bDoTypeAhead=!D.os.android&&(i.which!==K.BACKSPACE)&&(i.which!==K.DELETE);};
u.prototype.oninput=function(i){a.prototype.oninput.apply(this,arguments);var v=i.srcControl,w=this.isPickerDialog(),x=w?this.getPickerTextField():this,y=x.getValueState();if(y===V.Error&&this._bAlreadySelected){x.setValueState(this._sInitialValueState);x.setValueStateText(this._sInitialValueStateText);this._bAlreadySelected=false;}if(!this.getEnabled()||!this.getEditable()){return;}this.syncPickerContent();this.handleInputValidation(i,this.isComposingCharacter());if(this._bIsPasteEvent){v.updateDomValue(this._sOldValue||i.target.value||"");return;}if(this.isOpen()){setTimeout(this.highlightList.bind(this,this._sOldInput));}if(this._getItemsShownWithFilter()){this.toggleIconPressedStyle(true);}};
u.prototype.filterItems=function(i){var F=this.fnFilter?this.fnFilter:j;var v=[];var w=false;var x=[];i.items.forEach(function(y){if(y.isA("sap.ui.core.SeparatorItem")){x.push({separator:y});this.getListItem(y).setVisible(false);w=true;return;}var z=!!F(i.value,y);if(i.value===""){z=true;if(!this.bOpenedByKeyboardOrButton&&!this.isPickerDialog()){return;}}if(w&&z){this.getListItem(x[x.length-1].separator).setVisible(true);}var A=this.getListItem(y);if(A){A.setVisible(z);z&&v.push(y);}},this);return v;};
u.prototype.onkeyup=function(i){if(!this.getEnabled()||!this.getEditable()){return;}this._sOldValue=this.getValue();this._iOldCursorPos=q(this.getFocusDomRef()).cursorPos();};
u.prototype._showWrongValueVisualEffect=function(){var i=this._getSuggestionsPopover();var v=this._sInitialValueStateText;var w=this._sInitialValueState;var x=v||this._oRbC.getText("VALUE_STATE_ERROR");var y=this;if(w===V.Error){return;}if(i){i.updateValueState(V.Error,x,true);setTimeout(i.updateValueState.bind(i,y.getValueState(),x,true),1000);}if(!this.isPickerDialog()){this.setValueState(V.Error);this.setValueStateText(this.getValueStateText()||x);setTimeout(this["setValueState"].bind(this,w||V.Error),1000);}this._syncInputWidth(this.getAggregation("tokenizer"));};
u.prototype._showAlreadySelectedVisualEffect=function(){var A=this._oRbM.getText("VALUE_STATE_ERROR_ALREADY_SELECTED");if(!this.getValue()){return;}var i=!!this.getSelectedItems().filter(function(v){return v.getText().toLowerCase()===this.getValue().toLowerCase();},this).length;var N=this.getItems().filter(function(v){return v.getText().toLowerCase()===this.getValue().toLowerCase();},this).length;if(i){this._sInitialValueState=this.getValueState();this._sInitialValueStateText=this.getValueStateText();this.setValueStateText(A);this._bAlreadySelected=true;this.setValueState("Error");return;}else if(N){return;}else{this._showWrongValueVisualEffect();}};
u.prototype._hasShowSelectedButton=function(){return true;};
u.prototype.forwardEventHandlersToSuggPopover=function(i){a.prototype.forwardEventHandlersToSuggPopover.apply(this,arguments);i.setShowSelectedPressHandler(this._filterSelectedItems.bind(this));};
u.prototype.configPicker=function(i){var v=this.getRenderer(),w=v.CSS_CLASS_MULTICOMBOBOX;i.setHorizontalScrolling(false).addStyleClass(v.CSS_CLASS_COMBOBOXBASE+"Picker").addStyleClass(w+"Picker").addStyleClass(w+"Picker-CTX").attachBeforeOpen(this.onBeforeOpen,this).attachAfterOpen(this.onAfterOpen,this).attachBeforeClose(this.onBeforeClose,this).attachAfterClose(this.onAfterClose,this).addEventDelegate({onBeforeRendering:this.onBeforeRenderingPicker,onAfterRendering:this.onAfterRenderingPicker},this);};
u.prototype._configureList=function(i){if(!i){return;}i.setMode(s.MultiSelect);i.setIncludeItemInSelection(true);i.attachBrowserEvent("tap",this._handleItemTap,this).attachSelectionChange(this._handleSelectionLiveChange,this).attachItemPress(this._handleItemPress,this);i.addEventDelegate({onAfterRendering:this.onAfterRenderingList,onfocusin:this.onFocusinList},this);};
u.prototype._modifyPopupInput=function(i){a.prototype._modifyPopupInput.apply(this,arguments);i.attachSubmit(function(v){var w=i.getValue();if(w){this.setValue(w);this._selectItemByKey();this.setValue(this._sOldInput);this.close();}}.bind(this));i.addEventDelegate({onfocusout:this._handleInputFocusOut},this);return i;};
u.prototype.onBeforeRendering=function(){a.prototype.onBeforeRendering.apply(this,arguments);this._bInitialSelectedKeysSettersCompleted=true;this.getAggregation("tokenizer").setEnabled(this.getEnabled());if(this._getList()){this.syncPickerContent(true);}this._deregisterResizeHandler();this._synchronizeSelectedItemAndKey();this.setProperty("hasSelection",!!this.getSelectedItems().length,true);if(!this._bAlreadySelected){this._sInitialValueStateText=this.getValueStateText();}if(this.getValueState()!==V.Error){this._sInitialValueState=this.getValueState();}};
u.prototype.syncPickerContent=function(F){var i,v,w=this.getPicker();if(!w){w=this.createPicker(this.getPickerType());this._updateSuggestionsPopoverValueState();F=true;}if(F){v=this._getList();i=this.getEditable()?this.getItems():this.getSelectedItems();this._synchronizeSelectedItemAndKey();v.destroyItems();this._clearTokenizer();this._fillList(i);if(v.getItemNavigation()){this._iFocusedIndex=v.getItemNavigation().getFocusedIndex();}}return w;};
u.prototype._registerResizeHandler=function(){m(!this._iResizeHandlerId,"Resize handler already registered");this._iResizeHandlerId=R.register(this,this._onResize.bind(this));};
u.prototype._deregisterResizeHandler=function(){if(this._iResizeHandlerId){R.deregister(this._iResizeHandlerId);this._iResizeHandlerId=null;}};
u.prototype._onResize=function(){var i=this.getAggregation("tokenizer");i.setMaxWidth(this._calculateSpaceForTokenizer());this._syncInputWidth(i);this._handleNMoreAccessibility();};
u.prototype.onBeforeRenderingPicker=function(){var i=this["_onBeforeRendering"+this.getPickerType()];if(i){i.call(this);}};
u.prototype.onAfterRenderingPicker=function(){var i=this["_onAfterRendering"+this.getPickerType()];if(i){i.call(this);}};
u.prototype.onBeforeOpen=function(){a.prototype.onBeforeOpen.apply(this,arguments);var i=this["_onBeforeOpen"+this.getPickerType()];this._resetCurrentItem();this.addContent();this._aInitiallySelectedItems=this.getSelectedItems();this._synchronizeSelectedItemAndKey();if(i){i.call(this);}};
u.prototype.onAfterOpen=function(){var i=this.getFocusDomRef(),v=this.getValueStateLinks();i&&this.getFocusDomRef().setAttribute("aria-expanded","true");this._bPickerIsOpening=false;if(!this.isPlatformTablet()){this.getPicker().setInitialFocus(this);}v.forEach(function(w){w.addDelegate({onAfterRendering:function(){if(this.getFocusDomRef()){this.getFocusDomRef().setAttribute("tabindex","-1");}}},w);});this.closeValueStateMessage();};
u.prototype.onBeforeClose=function(){a.prototype.onBeforeClose.apply(this,arguments);};
u.prototype.onAfterClose=function(){var U=!q.contains(this.getDomRef(),document.activeElement)||this.isPickerDialog(),i=this.getFocusDomRef();i&&this.getFocusDomRef().setAttribute("aria-expanded","false");this.toggleIconPressedStyle(false);this.clearFilter();!this.isComposingCharacter()&&!this._bPreventValueRemove&&this.setValue("");this._sOldValue="";this._sOldInput="";this._getSuggestionsPopover()._sTypedInValue="";if(this.isPickerDialog()){this.getPickerTextField().setValue("");this.getFilterSelectedButton()&&this.getFilterSelectedButton().setPressed(false);}this.fireSelectionFinish({selectedItems:this.getSelectedItems()});this.getAggregation("tokenizer").setRenderMode(U?t.Narrow:t.Loose);if(this.getValueState()==V.Error&&document.activeElement===this.getFocusDomRef()){this.selectText(0,this.getValue().length);}};
u.prototype._onBeforeOpenDialog=function(){};
u.prototype._onBeforeOpenDropdown=function(){var i=this.getPicker(),v=this.getDomRef(),w;if(v&&i){w=(v.offsetWidth/parseFloat(l.BaseFontSize))+"rem";i.setContentMinWidth(w);}};
u.prototype.getFilterSelectedButton=function(){return this._getSuggestionsPopover().getFilterSelectedButton();};
u.prototype._filterSelectedItems=function(i,F){var v=i.oSource,w,x,y=this.getPickerTextField()?this.getPickerTextField().getValue():"",z=(v&&v.getPressed&&v.getPressed())||F,A=this.getVisibleItems(),B=this.getItems(),H=this.getSelectedItems(),J=null;if(z){A.forEach(function(N){x=H.indexOf(N)>-1?true:false;w=this.getListItem(N);if(!w){return;}if(w.isA("sap.m.GroupHeaderListItem")){w.setVisible(false);J=w;}else{w.setVisible(x);if(x&&J){J.setVisible(true);}}},this);}else{this.filterItems({value:y,items:B});}};
u.prototype.revertSelection=function(){this.setSelectedItems(this._aInitiallySelectedItems);};
u.prototype.setSelection=function(i){var v=this._getList();if(i.item&&this.isItemSelected(i.item)){return;}if(!i.item){return;}if(!i.listItemUpdated&&this.getListItem(i.item)&&v){v.setSelectedItem(this.getListItem(i.item),true);}var w=new b({key:i.key});w.setText(i.item.getText());i.item.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Token",w);this.getAggregation("tokenizer").addToken(w);this.$().toggleClass("sapMMultiComboBoxHasToken",this._hasTokens());this.setValue('');this.addAssociation("selectedItems",i.item,i.suppressInvalidate);var x=this.getSelectedKeys();var y=this.getKeys([i.item])[0];if(y===""||x.indexOf(y)===-1){x.push(y);this.setProperty("selectedKeys",x,i.suppressInvalidate);}if(i.fireChangeEvent){this.fireSelectionChange({changedItem:i.item,selected:true});}if(i.fireFinishEvent){if(!this.isOpen()){this.fireSelectionFinish({selectedItems:this.getSelectedItems()});}}};
u.prototype.removeSelection=function(i){if(i.item&&!this.isItemSelected(i.item)){return;}if(!i.item){return;}this.removeAssociation("selectedItems",i.item,i.suppressInvalidate);var v=this.getSelectedKeys();var w=v.indexOf(i.item.getKey());v.splice(w,1);this.setProperty("selectedKeys",v,i.suppressInvalidate);if(!i.listItemUpdated&&this.getListItem(i.item)){var x=this.getListItem(i.item);this._getList().setSelectedItem(x,false);}if(!i.tokenUpdated){var y=this._getTokenByItem(i.item);i.item.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Token",null);this.getAggregation("tokenizer").removeToken(y);}this.$().toggleClass("sapMMultiComboBoxHasToken",this._hasTokens());if(i.fireChangeEvent){this.fireSelectionChange({changedItem:i.item,selected:false});}if(i.fireFinishEvent){if(!this.isOpen()){this.fireSelectionFinish({selectedItems:this.getSelectedItems()});}}};
u.prototype._synchronizeSelectedItemAndKey=function(){var v=this.getSelectedKeys();var w=this.getKeys(this.getSelectedItems());if(!v.length){n.info("Info: _synchronizeSelectedItemAndKey() the MultiComboBox control does not contain any item on ",this);return;}for(var i=0,x=null,y=null,z=v.length;i<z;i++){x=v[i];if(w.indexOf(x)>-1){continue;}y=this.getItemByKey(""+x);if(y){this.setSelection({item:y,id:y.getId(),key:y.getKey(),fireChangeEvent:false,suppressInvalidate:true,listItemUpdated:false});}}};
u.prototype._getTokenByItem=function(i){return i?i.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Token"):null;};
u.prototype.updateItems=function(i){var v=function(z){return z&&z.getKey&&z.getKey();},w,x=this.getSelectedItems().map(v),y=this.getSelectedKeys();var U=a.prototype.updateItems.apply(this,arguments);x=this.getSelectedItems().map(v).filter(function(z){return x.indexOf(z)>-1;});w=y.concat(x);this.setSelectedKeys(w);return U;};
u.prototype._getSelectedItemsOf=function(v){for(var i=0,w=v.length,x=[];i<w;i++){if(this.getListItem(v[i]).isSelected()){x.push(v[i]);}}return x;};
u.prototype._getLastSelectedItem=function(){var i=this.getAggregation("tokenizer").getTokens();var v=i.length?i[i.length-1]:null;if(!v){return null;}return this._getItemByToken(v);};
u.prototype._getFocusedListItem=function(){if(!document.activeElement){return null;}var F=o.byId(document.activeElement.id);if(this._getList()&&g(this._getList().getFocusDomRef(),F.getFocusDomRef())){return F;}return null;};
u.prototype._getFocusedItem=function(){var i=this._getFocusedListItem();return this._getItemByListItem(i);};
u.prototype._hasTokens=function(){return this.getAggregation("tokenizer").getTokens().length>0;};
u.prototype._getCurrentItem=function(){if(!this._oCurrentItem){return this._getFocusedItem();}return this._oCurrentItem;};
u.prototype._setCurrentItem=function(i){this._oCurrentItem=i;};
u.prototype._resetCurrentItem=function(){this._oCurrentItem=null;};
u.prototype._decorateListItem=function(i){i.addDelegate({onkeyup:function(v){var w=null;if(v.which==K.SPACE&&this.isOpen()&&this._isListInSuggestMode()){this.open();w=this._getLastSelectedItem();if(w){this.getListItem(w).focus();}return;}},onkeydown:function(v){var w=null,x=null;if(v.shiftKey&&v.which==K.ARROW_DOWN){x=this._getCurrentItem();w=this._getNextVisibleItemOf(x);}if(v.shiftKey&&v.which==K.ARROW_UP){x=this._getCurrentItem();w=this._getPreviousVisibleItemOf(x);}if(v.shiftKey&&v.which===K.SPACE){x=this._getCurrentItem();this._selectPreviousItemsOf(x);}if(w&&w!==x){if(this.getListItem(x).isSelected()){this.setSelection({item:w,id:w.getId(),key:w.getKey(),fireChangeEvent:true,suppressInvalidate:true});this._setCurrentItem(w);}else{this.removeSelection({item:w,id:w.getId(),key:w.getKey(),fireChangeEvent:true,suppressInvalidate:true});this._setCurrentItem(w);}return;}this._resetCurrentItem();if((v.ctrlKey||v.metaKey)&&v.which==K.A){v.setMarked();v.preventDefault();var y=this.getSelectableItems();var z=this._getSelectedItemsOf(y);if(z.length!==y.length){y.forEach(function(w){this.setSelection({item:w,id:w.getId(),key:w.getKey(),fireChangeEvent:true,suppressInvalidate:true,listItemUpdated:false});},this);}else{y.forEach(function(w){this.removeSelection({item:w,id:w.getId(),key:w.getKey(),fireChangeEvent:true,suppressInvalidate:true,listItemUpdated:false});},this);}}}},true,this);i.addEventDelegate({onsapbackspace:function(v){v.preventDefault();},onsapshow:function(v){v.setMarked();if(this.isOpen()){this.close();return;}if(this.hasContent()){this.open();}},onsaphide:function(v){this.onsapshow(v);},onsapenter:function(v){v.setMarked();this.close();},onsaphome:function(v){v.setMarked();v.preventDefault();if(this.getValueStateLinks().length){this._handleFormattedTextNav();v.stopPropagation(true);return;}var w=this.getSelectableItems();var x=w[0];this.getListItem(x).focus();},onsapend:function(v){v.setMarked();v.preventDefault();var w=this.getSelectableItems();var x=w[w.length-1];this.getListItem(x).focus();},onsapup:function(v){v.setMarked();v.preventDefault();var w=this.getSelectableItems();var x=w[0];var y=q(document.activeElement).control()[0];if(y===this.getListItem(x)&&this.getValueStateLinks().length){this._handleFormattedTextNav();v.stopPropagation(true);return;}else if(y===this.getListItem(x)){this.focus();v.stopPropagation(true);}},onfocusin:function(v){this.addStyleClass(this.getRenderer().CSS_CLASS_MULTICOMBOBOX+"Focused");},onfocusout:function(v){this.removeStyleClass(this.getRenderer().CSS_CLASS_MULTICOMBOBOX+"Focused");},onsapfocusleave:function(v){var w=this.getAggregation("picker");var x=o.byId(v.relatedControlId);if(w&&x&&k(w.getFocusDomRef(),x.getFocusDomRef())){if(v.srcControl){v.srcControl.focus();}}}},this);if(D.support.touch){i.addEventDelegate({ontouchstart:function(v){v.setMark("cancelAutoClose");}});}};
u.prototype._handleInputFocusOut=function(){var i=this.isPickerDialog()?this.getPickerTextField():this,U=this._sOldInput||this._sOldValue||"";i.updateDomValue(U);this._bIsPasteEvent=null;};
u.prototype.onItemChange=function(i){var v=a.prototype.onItemChange.apply(this,arguments);this._forwardItemInfoToToken(i);return v;};
u.prototype._forwardItemInfoToToken=function(i){var v=i.getSource(),w=i.getParameters(),x=this._getTokenByItem(v);if(!x){return;}if(w.name==="enabled"){x.setVisible(w.newValue);}else if(x.getMetadata().hasProperty(w.name)){x.setProperty(w.name,w.newValue,false);}};
u.prototype._handleIndicatorPress=function(){var i,v=this.getAggregation("tokenizer");if(this.getEditable()){this.syncPickerContent();this._filterSelectedItems({},true);this.focus();i=this.getPicker();i.open();}else{v._togglePopup(v.getTokensPopup());}if(this.isPickerDialog()){this.getFilterSelectedButton().setPressed(true);this.bOpenedByKeyboardOrButton=true;}};
u.prototype._togglePopover=function(){var i=this.getPicker();if(!i){i=this.syncPickerContent(true);}if(i.isOpen()){i.close();}else{i.open();}};
u.prototype._createTokenizer=function(){var i=new T({renderMode:t.Narrow}).attachTokenDelete(this._handleTokenDelete,this);i.getTokensPopup().attachAfterOpen(function(){if(i.hasOneTruncatedToken()){i.setFirstTokenTruncated(false);}}).attachAfterClose(function(){var v=i.getTokens();if(v.length===1&&!v[0].getTruncated()){i.setFirstTokenTruncated(true);}});i.addEventDelegate({onAfterRendering:this._onAfterRenderingTokenizer},this);return i;};
u.prototype._onAfterRenderingTokenizer=function(){var i=this.getAggregation("tokenizer");if(this.getEditable()){i.addStyleClass("sapMTokenizerIndicatorDisabled");}else{i.removeStyleClass("sapMTokenizerIndicatorDisabled");}setTimeout(this._syncInputWidth.bind(this,i),0);setTimeout(this._handleNMoreAccessibility.bind(this),0);setTimeout(i["scrollToEnd"].bind(i),0);};
u.prototype._handleTokenDelete=function(i){var v=i.getParameter("tokens");var w=this.getSelectedItems();this._removeSelection(v);if(w.length!==this.getSelectableItems()){!this.isPickerDialog()&&!this.isFocusInTokenizer()&&this.focus();this.fireChangeEvent("");this.setProperty("hasSelection",!!this.getSelectedItems().length);}};
u.prototype._removeSelection=function(i){var v=this.getAggregation("tokenizer");i.forEach(function(w){var x=(w&&this._getItemByToken(w));if(x&&this.isItemSelected(x)){this.removeSelection({item:x,id:x.getId(),key:x.getKey(),tokenUpdated:true,fireChangeEvent:true,fireFinishEvent:true,suppressInvalidate:true});w.destroy();if(this.getSelectedItems().length>0){var i=v.getTokens();i[i.length-1].focus();}else{this.focus();}}},this);};
u.prototype.onAfterRenderingList=function(){var i=this._getList();var v=document.activeElement===this.getFocusDomRef();if(this.getEditable()&&!v&&i&&i.getItems()[this._iFocusedIndex]){i.getItems()[this._iFocusedIndex].focus();this._iFocusedIndex=null;}};
u.prototype.onFocusinList=function(){if(this._bListItemNavigationInvalidated&&this._getList().getItemNavigation()){this._getList().getItemNavigation().setSelectedIndex(this._iInitialItemFocus);this._bListItemNavigationInvalidated=false;}};
u.prototype.onAfterRendering=function(){var i=this.getAggregation("tokenizer");a.prototype.onAfterRendering.apply(this,arguments);this._registerResizeHandler();setTimeout(function(){i.setMaxWidth(this._calculateSpaceForTokenizer());}.bind(this),0);};
u.prototype.onfocusout=function(i){this.isOpen()&&this._handleInputFocusOut();this.removeStyleClass("sapMFocus");if(this.getValueState()===V.Error&&this.getValueStateText()===this._oRbM.getText("VALUE_STATE_ERROR_ALREADY_SELECTED")){this.setValueState(this._sInitialValueState);this.setValueStateText(this._sInitialValueStateText);}a.prototype.onfocusout.apply(this,arguments);};
u.prototype.onpaste=function(i){var v;if(window.clipboardData){v=window.clipboardData.getData("Text");}else{v=i.originalEvent.clipboardData.getData('text/plain');}var w=v.split(/\r\n|\r|\n/g);if(w&&w.length>0){this.getSelectableItems().forEach(function(x){if(w.indexOf(x.getText())>-1){this.setSelection({item:x,id:x.getId(),key:x.getKey(),fireChangeEvent:true,fireFinishEvent:true,suppressInvalidate:true,listItemUpdated:false});}},this);}};
u.prototype.onsapbackspace=function(i){var v=this.getAggregation("tokenizer");var w=v.getTokens();var x=w.filter(function(y){return y.getSelected();});if(!this.getEnabled()||!this.getEditable()){i.preventDefault();return;}if(this.getCursorPosition()>0||this.getValue().length>0){return;}if(x.length>0){this._removeAllTokens();return;}if(document.activeElement===this.getFocusDomRef()){w[w.length-1]&&w[w.length-1].focus();}i.preventDefault();};
u.prototype._removeAllTokens=function(){var i=this.getAggregation("tokenizer");var v=i.getTokens().filter(function(w){return w.getSelected();});if(!v.length){return;}this._removeSelection(v);this.fireChangeEvent("");this.invalidate();};
u.prototype.onsapdelete=u.prototype.onsapbackspace;
u.prototype.onsapnext=function(i){var v=this.getAggregation("tokenizer");if(i.isMarked()){return;}var F=q(document.activeElement).control()[0];if(!F){return;}if(F===v||v.$().find(F.$()).length>0&&this.getEditable()){this.focus();}};
u.prototype.onsapprevious=function(i){if(this.getCursorPosition()===0&&!h(this.getFocusDomRef())){if(i.srcControl===this){T.prototype.onsapprevious.apply(this.getAggregation("tokenizer"),arguments);}}};
u.prototype.onclick=function(i){var v=this.getEditable(),w=this.getEnabled(),N=i.target.className.indexOf("sapMTokenizerIndicator")>-1,x=this.getAggregation("tokenizer"),y=i.target.className.indexOf("sapMToken")>-1&&this.getAggregation("tokenizer").hasOneTruncatedToken();if(v&&w&&(N||y)){i.preventDefault();this._handleIndicatorPress();x.setFirstTokenTruncated(false);}};
u.prototype.ontap=function(i){a.prototype.ontap.apply(this,arguments);var v=this.getOpenArea();if(!this.getEnabled()||!this.getEditable()){return;}i.setMarked();if(this.isPickerDialog()&&v.contains(i.target)){this.open();}};
u.prototype.getOpenArea=function(){if(this.isPickerDialog()){return this.getDomRef();}else{return a.prototype.getOpenArea.apply(this,arguments);}};
u.prototype._getItemsStartingWithPerTerm=function(i,v){var w=[],x=v?this.getEnabledItems():this.getSelectableItems(),F=this.fnFilter?this.fnFilter:j;x.forEach(function(y){if(F(i,y)){w.push(y);}},this);return w;};
u.prototype._getItemsStartingWith=function(i,v){var w=[],x=v?this.getEnabledItems():this.getSelectableItems();x.forEach(function(y){if(typeof i==="string"&&i!==""&&y.getText().toLowerCase().startsWith(i.toLowerCase())){w.push(y);}},this);return w;};
u.prototype._getUnselectedItemsStartingText=function(i){var v=[];this._getUnselectedItems().forEach(function(w){if(typeof i==="string"&&i!==""&&w.getText().toLowerCase().startsWith(i.toLowerCase())){v.push(w);}},this);return v;};
u.prototype.getCursorPosition=function(){return this._$input.cursorPos();};
u.prototype._selectPreviousItemsOf=function(i){var v;do{v=true;var w=this._getPreviousVisibleItemOf(i);if(w){var x=this.getListItem(w);if(x){v=this.getListItem(w).getSelected();}}this.setSelection({item:i,id:i.getId(),key:i.getKey(),fireChangeEvent:true,suppressInvalidate:true});i=w;}while(!v);};
u.prototype._getNextVisibleItemOf=function(i){var v=this.getSelectableItems();var w=v.indexOf(i)+1;if(w<=0||w>v.length-1){return null;}return v[w];};
u.prototype._getPreviousVisibleItemOf=function(i){var v=this.getSelectableItems();var w=v.indexOf(i)-1;if(w<0){return null;}return v[w];};
u.prototype._getNextUnselectedItemOf=function(i){var v=this._getUnselectedItems();var w=v.indexOf(i)+1;if(w<=0||w>v.length-1){return null;}return v[w];};
u.prototype._getPreviousUnselectedItemOf=function(i){var v=this._getUnselectedItems();var w=v.indexOf(i)-1;if(w<0){return null;}return v[w];};
u.prototype._getNextTraversalItem=function(){var v=this.getValue();var i=v?this._getItemsStartingWithPerTerm(v):[];var w=this._getUnselectedItems();if(i.indexOf(this._oTraversalItem)>-1&&this._oTraversalItem.getText()===this.getValue()){return this._getNextUnselectedItemOf(this._oTraversalItem);}if(i.length&&i[0].getText()===this.getValue()){return this._getNextUnselectedItemOf(i[0]);}return i.length?i[0]:w[0];};
u.prototype._getPreviousTraversalItem=function(){var v=this.getValue();var i=v?this._getItemsStartingWithPerTerm(v):[];if(i.indexOf(this._oTraversalItem)>-1&&this._oTraversalItem.getText()===this.getValue()){return this._getPreviousUnselectedItemOf(this._oTraversalItem);}if(i.length&&i[i.length-1].getText()===this.getValue()){return this._getPreviousUnselectedItemOf(i[i.length-1]);}if(i.length){return i[i.length-1];}else{var w=this._getUnselectedItems();if(w.length>0){return w[w.length-1];}else{return null;}}};
u.prototype.setSelectedItems=function(i){this.removeAllSelectedItems();if(!i||!i.length){return this;}if(!Array.isArray(i)){n.warning("Warning: setSelectedItems() has to be an array of sap.ui.core.Item instances or of valid sap.ui.core.Item IDs",this);return this;}i.forEach(function(v){if(!(v instanceof e)&&(typeof v!=="string")){n.warning("Warning: setSelectedItems() has to be an array of sap.ui.core.Item instances or of valid sap.ui.core.Item IDs",this);return;}if(typeof v==="string"){v=o.byId(v);}this.setSelection({item:v?v:null,id:v?v.getId():"",key:v?v.getKey():"",suppressInvalidate:true});},this);return this;};
u.prototype.addSelectedItem=function(i){if(!i){return this;}if(typeof i==="string"){i=o.byId(i);}this.setSelection({item:i?i:null,id:i?i.getId():"",key:i?i.getKey():"",fireChangeEvent:false,suppressInvalidate:true});return this;};
u.prototype.removeSelectedItem=function(i){if(!i){return null;}if(typeof i==="string"){i=o.byId(i);}if(!this.isItemSelected(i)){return null;}this.removeSelection({item:i,id:i.getId(),key:i.getKey(),fireChangeEvent:false,suppressInvalidate:true});return i;};
u.prototype.removeAllSelectedItems=function(){var i=[];var v=this.getAssociation("selectedItems",[]);v.forEach(function(w){var x=this.removeSelectedItem(w);if(x){i.push(x.getId());}},this);return i;};
u.prototype.removeSelectedKeys=function(i){var v,w=[];if(!i||!i.length||!Array.isArray(i)){return w;}i.forEach(function(x){v=this.getItemByKey(x);if(v){this.removeSelection({item:v?v:null,id:v?v.getId():"",key:v?v.getKey():"",fireChangeEvent:false,suppressInvalidate:true});w.push(v);}},this);return w;};
u.prototype.setSelectedKeys=function(i){if(this._bInitialSelectedKeysSettersCompleted){this.setProperty("selectedKeys",[],true);this.removeAllSelectedItems();}this.addSelectedKeys(i);this._bInitialSelectedKeysSettersCompleted=true;return this;};
u.prototype.addSelectedKeys=function(i){var v,w=[];i=this.validateProperty("selectedKeys",i);i.forEach(function(x){var y=this.getItemByKey(x);if(y){this.addSelectedItem(y);}else if(x!=null){w.push(x);}},this);if(w.length>0){v=this.getProperty("selectedKeys").filter(function(x){return w.indexOf(x)===-1;});w=v.concat(w);this.setProperty("selectedKeys",w,true);}return this;};
u.prototype._getUnselectedItems=function(){var i=q(this.getSelectableItems()).not(this.getSelectedItems()).get();if(!this.isOpen()){return i.filter(function(v){return!v.isA("sap.ui.core.SeparatorItem");});}return i;};
u.prototype.getSelectedItems=function(){var i=[],v=this.getAssociation("selectedItems")||[];v.forEach(function(w){var x=o.byId(w);if(x){i.push(x);}},this);return i;};
u.prototype.getWidth=function(){return this.getProperty("width")||"100%";};
u.prototype.setEditable=function(i){var v=this._getList(),w=this.getAggregation("tokenizer");a.prototype.setEditable.apply(this,arguments);w.setEditable(i);if(v){this.syncPickerContent(true);this._updatePopoverBasedOnEditMode(i);}return this;};
u.prototype._updatePopoverBasedOnEditMode=function(i){var v=this._getList(),w=this._getSuggestionsPopover();if(!v){return;}if(i){w.addContent(v);}};
u.prototype._mapItemToListItem=function(i){var v,w,x,A;var y=this.getRenderer();if(!i){return null;}A=(i.getAdditionalText&&this.getShowSecondaryValues())?i.getAdditionalText():"";if(i.isA("sap.ui.core.SeparatorItem")){v=this._mapSeparatorItemToGroupHeader(i,y);i.data(y.CSS_CLASS_COMBOBOXBASE+"ListItem",v);this._decorateListItem(v);return v;}w=y.CSS_CLASS_MULTICOMBOBOX+"Item";x=(this.isItemSelected(i))?w+"Selected":"";v=new S({type:r.Active,visible:i.getEnabled()}).addStyleClass(w+" "+x);v.setTooltip(i.getTooltip());i.data(y.CSS_CLASS_COMBOBOXBASE+"ListItem",v);v.setTitle(i.getText());v.setInfo(A);if(x){var z=new b({key:i.getKey()});z.setText(i.getText());i.data(y.CSS_CLASS_COMBOBOXBASE+"Token",z);this.getAggregation("tokenizer").addToken(z,true);}this.setSelectable(i,i.getEnabled());this._decorateListItem(v);return v;};
u.prototype.setSelectable=function(i,v){a.prototype.setSelectable.call(this,i,v);var w=this._getTokenByItem(i);if(w){w.setVisible(v);}};
u.prototype._fillList=function(v){if(!v){return null;}if(!this._oListItemEnterEventDelegate){this._oListItemEnterEventDelegate={onsapenter:function(y){if(y.srcControl.isSelected()){y.setMarked();}}};}for(var i=0,w,x=v.length;i<x;i++){w=this._mapItemToListItem(v[i]);w.removeEventDelegate(this._oListItemEnterEventDelegate);w.addDelegate(this._oListItemEnterEventDelegate,true,this,true);this._getList().addAggregation("items",w,true);if(this.isItemSelected(v[i])){this._getList().setSelectedItem(w,true);}}};
u.prototype.handleInputValidation=function(i,v){var w=i.target.value,x=this._sOldInput&&this._sOldInput.length>w.length,y=this.isValueValid(w),z,A,B;var F=i.srcControl;if(!y&&w!==""&&!v){this._handleFieldValidationState(F);return;}B=this._getItemsStartingWith(w,true);if(!v||this._bIsPasteEvent){this._handleTypeAhead(w,B,F);}z=this.getEnabledItems();if(this.isPickerDialog()){A=this.getFilterSelectedButton();if(A!=null&&A.getPressed()){A.setPressed(false);}}if(x){z=this.getItems();}this.filterItems({value:w,items:z});this._sOldInput=w;if((!this.getValue()||!y)&&!this.bOpenedByKeyboardOrButton&&!this.isPickerDialog()){this.close();}else{this.open();}};
u.prototype.isValueValid=function(v){var i=this._getItemsStartingWith(v,true);var w=this._getItemsStartingWithPerTerm(v,true);return i.length||w.length;};
u.prototype._handleTypeAhead=function(v,i,w){var x=this.getSelectedItems();var y=i.filter(function(z){if(z.isA("sap.ui.core.SeparatorItem")){return false;}return x.indexOf(z)===-1;});if(this._bDoTypeAhead&&y.length){w.updateDomValue(y[0].getText());if(document.activeElement===w.getFocusDomRef()){w.selectText(v.length,w.getValue().length);}}};
u.prototype._handleFieldValidationState=function(i){if(this._sOldInput&&this.isValueValid(this._sOldInput)){i.updateDomValue(this._sOldInput);}else if(this._sOldValue&&this.isValueValid(this._sOldValue)){i.updateDomValue(this._sOldValue);}else{i.updateDomValue("");}if(this._iOldCursorPos){q(i.getFocusDomRef()).cursorPos(this._iOldCursorPos);}this._showWrongValueVisualEffect();};
u.prototype.init=function(){this._oRb=o.getLibraryResourceBundle("sap.m");a.prototype.init.apply(this,arguments);this._bInitialSelectedKeysSettersCompleted=false;this._bListItemNavigationInvalidated=false;this._iInitialItemFocus=-1;this._bCheckBoxClicked=true;this._bPreventValueRemove=false;this._oTokenizer=this._createTokenizer();this.setAggregation("tokenizer",this._oTokenizer);this._aInitiallySelectedItems=[];this._oRbM=o.getLibraryResourceBundle("sap.m");this._oRbC=o.getLibraryResourceBundle("sap.ui.core");this._fillList();};
u.prototype.clearSelection=function(){this.removeAllSelectedItems();};
u.prototype.insertItem=function(i,v){this.insertAggregation("items",i,v,true);if(i){i.attachEvent("_change",this.onItemChange,this);}if(this._getList()){this._getList().insertItem(this._mapItemToListItem(i),v);}return this;};
u.prototype.removeItem=function(i){i=this.removeAggregation("items",i);if(this._getList()){this._getList().removeItem(i&&this.getListItem(i));}this.removeSelection({item:i,id:i?i.getId():"",key:i?i.getKey():"",fireChangeEvent:false,suppressInvalidate:true,listItemUpdated:true});return i;};
u.prototype.isItemSelected=function(i){return this.getSelectedItems().indexOf(i)>-1;};
u.prototype._clearTokenizer=function(){this.getAggregation("tokenizer").destroyTokens();};
u.prototype.exit=function(){var i=["_oSuggestionPopover","_oToggleButton","_oPickerCustomHeader","_oCustomHeaderToolbar","_oPickerCloseButton"],v=this;a.prototype.exit.apply(this,arguments);this._deregisterResizeHandler();i.forEach(function(w){if(v[w]){v[w].destroy();v[w]=null;}});this._sInitialValueState=null;};
u.prototype.destroyItems=function(){this.destroyAggregation("items");this.setProperty("selectedKeys",[],true);if(this._getList()){this._getList().destroyItems();}this.getAggregation("tokenizer").destroyTokens();return this;};
u.prototype.removeAllItems=function(){var i=this.removeAllAggregation("items");this.removeAllSelectedItems();if(this._getList()){this._getList().removeAllItems();}return i;};
u.prototype._getItemByToken=function(i){return this._getItemBy(i,"Token");};
u.prototype._getItemByValue=function(v){return this.getSelectableItems().find(function(i){return i.getText().toLowerCase()===v.toLowerCase();});};
u.prototype._handleItemToFocus=function(){if(this.isOpen()){return;}this.syncPickerContent();var i,v,w=o.byId(document.activeElement.id),x=this.getSelectedItems(),y=this.getSelectableItems(),z=this._getList(),A=z&&z.getItemNavigation(),B=this.getValue(),F=this.getPicker();if(w&&w.isA("sap.m.Token")){v=this._getItemByToken(w);}else if(B){v=this._getItemByValue(B);}if(!v){v=x.length?this._getItemByListItem(this._getList().getSelectedItems()[0]):y[0];}i=y.indexOf(v);if(A){A.setSelectedIndex(i);}else{this._bListItemNavigationInvalidated=true;this._iInitialItemFocus=i;}F.setInitialFocus(z);};
u.prototype.getAccessibilityInfo=function(){var i=this.getSelectedItems().map(function(w){return w.getText();}).join(" ");var v=a.prototype.getAccessibilityInfo.apply(this,arguments);v.type=o.getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_MULTICOMBO");v.description=((v.description||"")+" "+i).trim();return v;};
u.prototype._calculateSpaceForTokenizer=function(){if(this.getDomRef()){var i,v=this.getDomRef().offsetWidth,w=this._calculateIconsSpace(),x=this.$().find(".sapMInputBaseInner"),y=["min-width","padding-right","padding-left"],z=y.reduce(function(A,B){return A+(parseInt(x.css(B))||0);},0);i=v-(w+z);i=i<0?0:i;return i+"px";}else{return null;}};
u.prototype._syncInputWidth=function(i){var F=this.getDomRef('inner'),v,w;if(!F||(i&&!i.getDomRef())){return;}w=parseFloat(i.getDomRef().getBoundingClientRect().width.toFixed(2));v=this._calculateIconsSpace();F.style.width='calc(100% - '+parseFloat(v+w)+"px)";};
u.prototype._handleNMoreAccessibility=function(){var i=p.getStaticId("sap.m","MULTICOMBOBOX_OPEN_NMORE_POPOVER"),v=this.getAggregation("tokenizer"),F=this.getFocusDomRef(),A=(F&&F.getAttribute("aria-labelledby")),w=A?A.split(" "):[],N=w.indexOf(i),x=this.getEnabled(),y=!this.getEditable()&&v&&v.getHiddenTokensCount();if(y&&N===-1){w.push(i);x&&this.getFocusDomRef().setAttribute("aria-keyshortcuts","Enter");}else if(N!==-1&&!y){w.splice(N,1);this.getFocusDomRef().removeAttribute("aria-keyshortcuts");}if(F&&w.length){F.setAttribute("aria-labelledby",w.join(" ").trim());}};
u.prototype.applyShowItemsFilters=function(){this.syncPickerContent();this.filterItems({value:this.getValue()||"_",items:this.getItems()});};
u.prototype.showItems=function(F){var H=true,i=this.fnFilter;if(typeof F==="function"){this.syncPickerContent();this.setFilterFunction(F||function(){return true;});H=this.filterItems({value:this.getValue()||"_",items:this.getItems()}).length>0;this.setFilterFunction(i);}if(H){a.prototype.showItems.apply(this,arguments);}};
return u;});
sap.ui.predefine('sap/m/MultiComboBoxRenderer',['./ComboBoxBaseRenderer','./ComboBoxTextFieldRenderer','sap/ui/core/Renderer','sap/ui/core/Core'],function(C,a,R,b){"use strict";var M=R.extend(C);M.apiVersion=2;M.CSS_CLASS_MULTICOMBOBOX="sapMMultiComboBox";
M.addOuterClasses=function(r,c){C.addOuterClasses.apply(this,arguments);r.class(M.CSS_CLASS_MULTICOMBOBOX);if(c.getProperty("hasSelection")){r.class("sapMMultiComboBoxHasToken");}};
M.getAriaDescribedBy=function(c){var A=a.getAriaDescribedBy.apply(this,arguments),t=c.getAggregation("tokenizer"),i=t&&t.getTokensInfoId();return(A||"")+" "+i;};
M.getAccessibilityState=function(c){var A=C.getAccessibilityState.apply(this,arguments),r=b.getLibraryResourceBundle("sap.m");A.roledescription=r.getText("MULTICOMBOBOX_ARIA_ROLE_DESCRIPTION");return A;};
M.prependInnerContent=function(r,c){r.renderControl(c.getAggregation("tokenizer"));};
return M;},true);
sap.ui.predefine('sap/m/MultiEditField',["sap/ui/core/XMLComposite","./library","sap/ui/core/Item"],function(X,l,I){"use strict";
var M=X.extend("sap.m.MultiEditField",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.m",properties:{selectedItem:{type:"sap.ui.core.Item",group:"Data",defaultValue:null,invalidate:true},showValueHelp:{type:"boolean",group:"Behavior",defaultValue:true,invalidate:true},nullable:{type:"boolean",group:"Behavior",defaultValue:true,invalidate:true},required:{type:"boolean",group:"Behavior",defaultValue:false,invalidate:true}},aggregations:{items:{type:"sap.ui.core.Item",multiple:true,bindable:"bindable"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{change:{parameters:{selectedItem:{type:"sap.ui.core.Item"}}}}}});
M.prototype.init=function(){if(!M.prototype._oRb){M.prototype._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");}var k=new I({key:"keep",text:"< "+this._oRb.getText("MULTI_EDIT_KEEP_TEXT")+" >"}),b=new I({key:"blank",text:"< "+this._oRb.getText("MULTI_EDIT_BLANK_TEXT")+" >"}),n=new I({key:"new",text:"< "+this._oRb.getText("MULTI_EDIT_NEW_TEXT")+" >"});this._getKeepAll=function(){return k;};this._getBlank=function(){return b;};this._getValueHelp=function(){return n;};this.byId("select").getParent=this.getParent.bind(this);this._oLastSelectedItem=this._getKeepAll();};
M.prototype.onBeforeRendering=function(){this.insertAggregation("items",this._getKeepAll(),0,true);if(this.getNullable()){this.insertAggregation("items",this._getBlank(),1,true);}else{this.removeAggregation("items",this._getBlank(),true);}if(this.getShowValueHelp()){this.insertAggregation("items",this._getValueHelp(),this.getNullable()?2:1,true);}else{this.removeAggregation("items",this._getValueHelp(),true);}var s=this.getSelectedItem();if(s){s=this._getInternalItem(s);this.byId("select").setSelectedItem(s);}};
M.prototype.setSelectedItem=function(s){var i=this._getExternalItem(s)||s;var o;if(i&&this.indexOfItem(i)>=0&&!this._isSpecialValueItem(i)){o=this._getInternalItem(s);if(o){this.byId("select").setSelectedItem(o);}this._oLastSelectedItem=i;return this.setProperty("selectedItem",i);}return this;};
M.prototype.exit=function(){this._getKeepAll().destroy();this._getBlank().destroy();this._getValueHelp().destroy();var i=this.byId("itemTemplate");if(i){i.destroy();}};
M.prototype.getFormDoNotAdjustWidth=function(){return true;};
M.prototype.isBlankSelected=function(){return this._getExternalItem(this.byId("select").getSelectedItem())===this._getBlank();};
M.prototype.isKeepExistingSelected=function(){return this._getExternalItem(this.byId("select").getSelectedItem())===this._getKeepAll();};
M.prototype._isSpecialValueItem=function(i){return i===this._getKeepAll()||i===this._getBlank()||i===this._getValueHelp();};
M.prototype._handleSelectionChange=function(e){var i=this._getExternalItem(e.getParameter("selectedItem"));if(i&&!this._isSpecialValueItem(i)){this.fireChange({selectedItem:i});}else if(i===this._getValueHelp()){this.fireEvent("_valueHelpRequest");}if(i!==this._getValueHelp()){this._oLastSelectedItem=i;this.setProperty("selectedItem",i,true);}};
M.prototype.resetSelection=function(){this.byId("select").setSelectedItem(this._getInternalItem(this._oLastSelectedItem));};
M.prototype._getExternalItem=function(i){var a=this.byId("select").indexOfItem(i);if(a>=0){return this.getItems()[a];}return null;};
M.prototype._getInternalItem=function(i){var a=this.indexOfItem(i);if(a>=0){return this.byId("select").getItems()[a];}return null;};
M.prototype._getInternalDomRef=function(){var s=this.byId("select");return s&&s.getDomRef();};
M.prototype._getInternalUIArea=function(){return this.byId("select").getUIArea();};
return M;});
sap.ui.predefine('sap/m/MultiInput',['./Input','./Tokenizer','./Token','./library','sap/ui/core/EnabledPropagator','sap/ui/base/ManagedObjectMetadata','sap/ui/base/ManagedObjectObserver','sap/ui/Device','./Popover','./List','./Title','./Bar','./Toolbar','./StandardListItem','sap/ui/core/ResizeHandler','sap/ui/core/IconPool','./MultiInputRenderer',"sap/ui/dom/containsOrEquals","sap/m/inputUtils/completeTextSelected","sap/ui/events/KeyCodes",'sap/ui/core/InvisibleText',"sap/ui/thirdparty/jquery","sap/ui/dom/jquery/cursorPos","sap/ui/dom/jquery/control"],function(I,T,a,l,E,M,b,D,P,L,c,B,d,S,R,f,g,h,j,K,k,q){"use strict";var m=l.TokenizerRenderMode;
var n=I.extend("sap.m.MultiInput",{metadata:{library:"sap.m",designtime:"sap/m/designtime/MultiInput.designtime",properties:{enableMultiLineMode:{type:"boolean",group:"Behavior",defaultValue:false},maxTokens:{type:"int",group:"Behavior"}},aggregations:{tokens:{type:"sap.m.Token",multiple:true,singularName:"token"},tokenizer:{type:"sap.m.Tokenizer",multiple:false,visibility:"hidden"}},events:{tokenChange:{parameters:{type:{type:"string"},token:{type:"sap.m.Token"},tokens:{type:"sap.m.Token[]"},addedTokens:{type:"sap.m.Token[]"},removedTokens:{type:"sap.m.Token[]"}}},tokenUpdate:{allowPreventDefault:true,parameters:{type:{type:"string"},addedTokens:{type:"sap.m.Token[]"},removedTokens:{type:"sap.m.Token[]"}}}},dnd:{draggable:false,droppable:true}}});
E.apply(n.prototype,[true]);var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");
n.prototype.init=function(){var t=this;this._bShowListWithTokens=false;I.prototype.init.call(this);this._bIsValidating=false;var o=new T({renderMode:m.Narrow,tokenDelete:this._tokenDelete.bind(this)});o.updateTokens=function(){this.destroyTokens();this.updateAggregation("tokens");};this.setAggregation("tokenizer",o);o.getTokensPopup().setInitialFocus(this).attachBeforeOpen(this._onBeforeOpenTokensPicker.bind(this)).attachAfterClose(this._onAfterCloseTokensPicker.bind(this));this.setAggregation("tokenizer",o);this._oTokenizerObserver=new b(function(C){var s=C.mutation;var e=C.child;switch(s){case"insert":this.fireTokenChange({type:sap.m.Tokenizer.TokenChangeType.Added,token:e,tokens:[e],removedTokens:[]});break;case"remove":var i=C.object.getTokens().length?sap.m.Tokenizer.TokenChangeType.Removed:sap.m.Tokenizer.TokenChangeType.RemovedAll;this.fireTokenChange({type:i,token:e,removedTokens:[e]});break;default:break;}this.invalidate();}.bind(this));this._oTokenizerObserver.observe(o,{aggregations:["tokens"]});this._bShowListWithTokens=false;this._bIsValidating=false;o.addEventDelegate({onThemeChanged:this._handleInnerVisibility.bind(this),onAfterRendering:function(){if(this.isMobileDevice()&&this.getEditable()){o.addStyleClass("sapMTokenizerIndicatorDisabled");}else{o.removeStyleClass("sapMTokenizerIndicatorDisabled");}this._syncInputWidth(o);this._handleInnerVisibility();this._handleNMoreAccessibility();this._registerTokenizerResizeHandler();}.bind(this)},this);this._aTokenValidators=[];this.setShowValueHelp(true);this.setShowSuggestion(true);this._getSuggestionsPopoverInstance()._oPopover.attachBeforeOpen(function(){if(t.isMobileDevice()!==true){return;}var e=o._getTokensList();o._fillTokensList(e);this.addContent(e);t._manageListsVisibility(!!o.getTokens().length);});this.attachSuggestionItemSelected(this._onSuggestionItemSelected,this);this.attachLiveChange(this._onLiveChange,this);this.attachValueHelpRequest(this._onValueHelpRequested,this);this._getValueHelpIcon().setProperty("visible",true,true);this._onResize=this._onResize.bind(this);};
n.prototype.exit=function(){this._deregisterResizeHandler();this._deregisterTokenizerResizeHandler();this._oTokenizerObserver.disconnect();this._oTokenizerObserver.destroy();this._oTokenizerObserver=null;I.prototype.exit.call(this);};
n.prototype.onAfterRendering=function(){var t=this.getAggregation("tokenizer");this._bTokenIsValidated=false;t.setMaxWidth(this._calculateSpaceForTokenizer());t.scrollToEnd();this._registerResizeHandler();I.prototype.onAfterRendering.apply(this,arguments);};
n.prototype._tokenDelete=function(e){this._deleteTokens(e.getParameter("tokens"),e.getParameters());};
n.prototype._deleteTokens=function(e,o){var t=this.getAggregation("tokenizer");var i=0;var p=o.keyCode===K.BACKSPACE;var s=e[e.length-1];var F=e[0];i=this.getTokens().indexOf(p?F:s);t.focusToken(i,o,function(){this.focus();}.bind(this));this.fireTokenUpdate({type:T.TokenUpdateType.Removed,addedTokens:[],removedTokens:e});e.forEach(function(u){u.destroy();},this);};
n.prototype._handleInnerVisibility=function(){var H=!!this.getAggregation("tokenizer").getHiddenTokensCount();this._setValueVisible(!H);};
n.prototype.oninput=function(e){this.setProperty("selectedKey",'',true);I.prototype.oninput.call(this,e);if(e.isMarked("invalid")||!this.getEditable()){return;}this._setValueVisible(true);this._manageListsVisibility(false);this.getAggregation("tokenizer").getTokensPopup().close();};
n.prototype._registerResizeHandler=function(){if(!this._iResizeHandlerId){this._iResizeHandlerId=R.register(this,this._onResize);}};
n.prototype._deregisterResizeHandler=function(){if(this._iResizeHandlerId){R.deregister(this._iResizeHandlerId);this._iResizeHandlerId=null;}};
n.prototype._registerTokenizerResizeHandler=function(){if(!this._iTokenizerResizeHandler){this._iTokenizerResizeHandler=R.register(this.getAggregation("tokenizer"),this._onResize);}};
n.prototype._deregisterTokenizerResizeHandler=function(){if(this._iTokenizerResizeHandler){R.deregister(this._iTokenizerResizeHandler);this._iTokenizerResizeHandler=null;}};
n.prototype._onResize=function(){this.getAggregation("tokenizer").setMaxWidth(this._calculateSpaceForTokenizer());};
n.prototype._onSuggestionItemSelected=function(e){var t=this.getAggregation("tokenizer"),i=null,o=null,O=t.getTokens().length;if(this.getMaxTokens()&&O>=this.getMaxTokens()||this._bValueHelpOpen){return;}if(this._hasTabularSuggestions()){i=e.getParameter("selectedRow");}else{i=e.getParameter("selectedItem");if(i){o=new a({text:i.getText(),key:i.getKey()});}}if(i&&!this._bTokenIsAdded){var p=this.getValue();this.addValidateToken({text:p,token:o,suggestionObject:i,validationCallback:this._validationCallback.bind(this,O)});}if(this.isMobileDevice()){var N=t.getTokens().length;if(O<N){this.setValue("");}if(this._getSuggestionsList()instanceof sap.m.Table){this._getSuggestionsList().addStyleClass("sapMInputSuggestionTableHidden");}else{this._getSuggestionsList().destroyItems();}var s=this.getAggregation("tokenizer").getScrollDelegate();if(s){s.scrollTo(0,0,0);}this._getSuggestionsPopoverInstance()._oPopupInput.focus();}this._bTokenIsAdded=false;};
n.prototype._onValueHelpRequested=function(){this._bValueHelpOpen=true;};
n.prototype._onLiveChange=function(e){var C=this.getAggregation("tokenizer").getTokens().every(function(t){return t.getSelected();});if(!C){return;}this.removeAllTokens();};
n.prototype._setValueVisible=function(v){var V=v?"1":"0";this.$("inner").css("opacity",V);};
n.prototype.onmousedown=function(e){if(e.target==this.getDomRef('content')){e.preventDefault();e.stopPropagation();}};
n.prototype.openMultiLine=function(){};
n.prototype.closeMultiLine=function(){};
n.prototype.showItems=function(){I.prototype.showItems.apply(this,arguments);this._manageListsVisibility(false);};
n.prototype.onBeforeRendering=function(){var t=this.getAggregation("tokenizer");var o=t._getTokensList();I.prototype.onBeforeRendering.apply(this,arguments);this._hideTokensOverLimit();t.setEnabled(this.getEnabled());t._fillTokensList(o);};
n.prototype._hideTokensOverLimit=function(){if(!this.getMaxTokens()){return;}this.getTokens().forEach(function(t,i){if(i>=this.getMaxTokens()){return t.setVisible(false);}return t.setVisible(true);},this);};
n.prototype.onsapnext=function(e){var t=this.getAggregation("tokenizer");if(e.isMarked()){return;}var F=q(document.activeElement).control()[0];if(!F){return;}if(t===F||t.$().find(F.$()).length>0){t.scrollToEnd();this.$().find("input").trigger("focus");}};
n.prototype.onsapbackspace=function(e){var v=this.getValue();var i=this.getFocusDomRef()===document.activeElement;var t=this.getTokens();var o=t[t.length-1];if(v===""&&i&&o&&e.srcControl===this){var A=t.filter(function(p){return p.getSelected();}).length===t.length;if(A){return this._deleteTokens(t,{keyCode:K.BACKSPACE});}o.focus();e.preventDefault();}};
n.prototype.onsapdelete=function(e){if(!this.getEditable()){return;}if(this.getValue()&&!j(this.getFocusDomRef())){return;}if(e.isMarked("forwardFocusToParent")){this.focus();}};
n.prototype.onkeydown=function(e){var t=this.getAggregation("tokenizer");if(!this.getEnabled()){return;}if(e.which===K.TAB){t.selectAllTokens(false);}if((e.ctrlKey||e.metaKey)&&e.which===K.A&&t.getTokens().length>0){t.focus();t.selectAllTokens(true);e.preventDefault();}if((e.ctrlKey||e.metaKey)&&(e.which===K.C||e.which===K.INSERT)){t._copy();}if(((e.ctrlKey||e.metaKey)&&e.which===K.X)||(e.shiftKey&&e.which===K.DELETE)){if(this.getEditable()){t._cut();}else{t._copy();}}if((e.ctrlKey||e.metaKey)&&e.which===K.I&&t.getTokens().length){t._togglePopup(t.getTokensPopup());e.preventDefault();}};
n.prototype.onpaste=function(e){var o,i,s,A=[];if(this.getValueHelpOnly()){return;}if(window.clipboardData){o=window.clipboardData.getData("Text");}else{o=e.originalEvent.clipboardData.getData('text/plain');}s=o.split(/\r\n|\r|\n/g);if(s.length<=1){return;}setTimeout(function(){if(s){if(this.fireEvent("_validateOnPaste",{texts:s},true)){var p="";for(i=0;i<s.length;i++){if(s[i]){var t=this._convertTextToToken(s[i],true);if(this._addUniqueToken(t)){A.push(t);}else{p=s[i];}}}this.updateDomValue(p);if(A.length>0){this.fireTokenUpdate({addedTokens:A,removedTokens:[],type:T.TokenUpdateType.Added});this.fireTokenChange({addedTokens:A,removedTokens:[],type:T.TokenChangeType.TokensChanged});}}if(A.length){this.cancelPendingSuggest();}}}.bind(this),0);};
n.prototype._validationCallback=function(o,v){var N=this.getAggregation("tokenizer").getTokens().length;var s=this._getSuggestionsPopoverInstance();this._bIsValidating=false;if(v){this.setValue("");this._bTokenIsValidated=true;if(this.isMobileDevice()&&s&&s._oPopupInput&&(o<N)){s._oPopupInput.setValue("");}}};
n.prototype.onsapprevious=function(e){if(this._getIsSuggestionPopupOpen()){return;}if(this._$input.cursorPos()===0){if(e.srcControl===this){T.prototype.onsapprevious.apply(this.getAggregation("tokenizer"),arguments);}}if(e.keyCode===K.ARROW_UP){e.preventDefault();}};
n.prototype.onsaphome=function(e){if(!this.getFocusDomRef().selectionStart){T.prototype.onsaphome.apply(this.getAggregation("tokenizer"),arguments);}};
n.prototype.onsapend=function(e){if(e.isMarked("forwardFocusToParent")){this.focus();}};
n.prototype.onsapenter=function(e){if(I.prototype.onsapenter){I.prototype.onsapenter.apply(this,arguments);}var v=true,t=this.getAggregation("tokenizer");if(this._getIsSuggestionPopupOpen()){if(this._hasTabularSuggestions()){v=!this._oSuggestionTable.getSelectedItem();}else{v=!this._getSuggestionsList().getSelectedItem();}}if(v){this._validateCurrentText();}if(e&&e.setMarked&&this._bTokenIsValidated){e.setMarked();}if(!this.getEditable()&&t.getHiddenTokensCount()&&e.target===this.getFocusDomRef()){t._togglePopup(t.getTokensPopup());}this.focus();};
n.prototype.onsapfocusleave=function(e){var p=this._getSuggestionsPopoverPopup(),t=this.getAggregation("tokenizer"),s=t.getTokensPopup(),N=false,i=false,o=this.getDomRef()&&h(this.getDomRef(),document.activeElement),u,F;if(p&&p.isA("sap.m.Popover")){if(e.relatedControlId){u=sap.ui.getCore().byId(e.relatedControlId).getFocusDomRef();N=h(p.getFocusDomRef(),u);i=h(t.getFocusDomRef(),u);if(s){F=h(s.getFocusDomRef(),u);}}}I.prototype.onsapfocusleave.apply(this,arguments);if(this._bIsValidating||this._bValueHelpOpen){return;}if(!this.isMobileDevice()&&!N&&e.relatedControlId!==this.getId()&&!i){this._validateCurrentText(true);}if(!this.isMobileDevice()&&this.getEditable()){if(o||N){return;}}if(!F&&!i){s.isOpen()&&!this.isMobileDevice()&&t._togglePopup(s);t.setRenderMode(m.Narrow);}this._handleInnerVisibility();};
n.prototype.ontap=function(e){var t=this.getAggregation("tokenizer");if(document.activeElement===this._$input[0]||document.activeElement===t.getDomRef()){t.selectAllTokens(false);}if(e&&e.isMarked("tokenDeletePress")){return;}I.prototype.ontap.apply(this,arguments);};
n.prototype.onfocusin=function(e){var t=this.getAggregation("tokenizer");this._deregisterTokenizerResizeHandler();this._bValueHelpOpen=false;if(e.target===this.getFocusDomRef()){I.prototype.onfocusin.apply(this,arguments);if(t.hasOneTruncatedToken()){t.getTokens()[0].setSelected(false);!this.isMobileDevice()&&t.setFirstTokenTruncated(false);}}if(!this.isMobileDevice()&&this.getEditable()&&e.target===this.getDomRef("inner")&&!(this._getIsSuggestionPopupOpen())){t.setRenderMode(m.Loose);this._setValueVisible(true);}this._registerResizeHandler();};
n.prototype.onsapescape=function(e){var t=this.getAggregation("tokenizer"),p=t.getTokensPopup();this.getAggregation("tokenizer").selectAllTokens(false);this.selectText(0,0);if(p.isOpen()){t._togglePopup(p);}I.prototype.onsapescape.apply(this,arguments);};
n.prototype._getIsSuggestionPopupOpen=function(){var s=this._getSuggestionsPopoverInstance(),o=this._getSuggestionsPopoverPopup();return s&&o&&o.isOpen();};
n.prototype.setEditable=function(e){var t=this.getAggregation("tokenizer");e=this.validateProperty("editable",e);if(e===this.getEditable()){return this;}if(I.prototype.setEditable){I.prototype.setEditable.apply(this,arguments);}t.setEditable(e);return this;};
n.prototype._findItem=function(t,e,o,G){if(!t){return;}if(!(e&&e.length)){return;}t=t.toLowerCase();var p=e.length;for(var i=0;i<p;i++){var s=e[i];var u=G(s);if(!u){continue;}u=u.toLowerCase();if(u===t){return s;}if(!o&&u.indexOf(t)===0){return s;}}};
n.prototype._getSuggestionItem=function(t,e){var o=null;var p=null;if(this._hasTabularSuggestions()){o=this.getSuggestionRows();p=this._findItem(t,o,e,function(s){var u=s.getCells();var v=null;if(u){var i;for(i=0;i<u.length;i++){if(u[i].getText){v=u[i].getText();break;}}}return v;});}else{o=this.getSuggestionItems();p=this._findItem(t,o,e,function(p){return p.getText();});}return p;};
n.prototype.clone=function(){var C;this.detachSuggestionItemSelected(this._onSuggestionItemSelected,this);this.detachLiveChange(this._onLiveChange,this);this.detachValueHelpRequest(this._onValueHelpRequested,this);C=I.prototype.clone.apply(this,arguments);this.attachSuggestionItemSelected(this._onSuggestionItemSelected,this);this.attachLiveChange(this._onLiveChange,this);this.attachValueHelpRequest(this._onValueHelpRequested,this);return C;};
n.getMetadata().forwardAggregation("tokens",{getter:function(){return this.getAggregation("tokenizer");},aggregation:"tokens",forwardBinding:true});
n.prototype.getPopupAnchorDomRef=function(){return this.getDomRef("content");};
n.prototype.setTokens=function(t){if(!Array.isArray(t)){return;}this.removeAllTokens();t.forEach(function(o){M.addAPIParentInfoBegin(o,this,"tokens");},this);t.forEach(function(o){this.addToken(o);},this);t.forEach(function(o){M.addAPIParentInfoEnd(o);},this);this.fireTokenChange({type:sap.m.Tokenizer.TokenChangeType.TokensChanged,addedTokens:t,removedTokens:[]});return this;};
n.TokenChangeType={Added:"added",Removed:"removed",RemovedAll:"removedAll",TokensChanged:"tokensChanged"};n.WaitForAsyncValidation="sap.m.MultiInput.WaitForAsyncValidation";n.prototype.getDomRefForValueStateMessage=n.prototype.getPopupAnchorDomRef;
n.prototype.updateInputField=function(N){I.prototype.updateInputField.call(this,N);var s=this._getSuggestionsPopoverInstance();this.setDOMValue('');if(s._oPopupInput){s._oPopupInput.setDOMValue('');}};
n.prototype.onChange=function(e,p,N){p=p||this.getChangeEventParams();if(!this.getEditable()||!this.getEnabled()){return;}var v=this._getInputValue(N);if(v===this.getLastValue()){this._bCheckDomValue=false;return;}if(!this._bTokenIsValidated){this.setValue(v);v=this.getValue();this.setLastValue(v);}this.fireChangeEvent(v,p);return true;};
n.prototype.getAccessibilityInfo=function(){var t=this.getTokens().map(function(o){return o.getText();}).join(" ");var i=I.prototype.getAccessibilityInfo.apply(this,arguments);i.type=r.getText("ACC_CTR_TYPE_MULTIINPUT");i.description=((i.description||"")+" "+t).trim();return i;};
n.prototype._modifyPopupInput=function(p){var t=this;p.addEventDelegate({oninput:t._manageListsVisibility.bind(t,false),onsapenter:function(e){if(p.getValue()){t._closeSuggestionPopup();}t._validateCurrentText();t._setValueVisible(false);t.onChange(e,null,p.getValue());}});return p;};
n.prototype._hasShowSelectedButton=function(){return true;};
n.prototype.forwardEventHandlersToSuggPopover=function(s){I.prototype.forwardEventHandlersToSuggPopover.apply(this,arguments);s.setShowSelectedPressHandler(this._handleShowSelectedPress.bind(this));};
n.prototype._handleShowSelectedPress=function(e){this._bShowListWithTokens=e.getSource().getPressed();this._manageListsVisibility(this._bShowListWithTokens);};
n.prototype._onBeforeOpenTokensPicker=function(){var t=this.getAggregation("tokenizer"),p=t.getTokensPopup(),o=this.getDomRef(),e=this.getEditable(),C,i;this._setValueVisible(false);this._manageListsVisibility(true);if(o&&p){C=parseInt(p.getContentWidth());i=o.offsetWidth>C?o.offsetWidth:C;i=((t.getTokens().length===1)||!e)?"auto":(i/parseFloat(l.BaseFontSize))+"rem";p.setContentWidth(i);}};
n.prototype._onAfterCloseTokensPicker=function(){if(document.activeElement!==this.getDomRef("inner")){this.getAggregation("tokenizer").setRenderMode(m.Narrow);}};
n.prototype.getDialogTitle=function(){var p=this._getSuggestionsPopoverPopup(),H=p&&p.getCustomHeader();if(H){return H.getContentMiddle()[0];}return null;};
n.prototype._updatePickerHeaderTitle=function(){var o,e;e=this.getLabels();if(e.length){o=e[0];if(o&&(typeof o.getText==="function")){this.getDialogTitle().setText(o.getText());}}else{this.getDialogTitle().setText(r.getText("COMBOBOX_PICKER_TITLE"));}};
n.prototype._getSuggestionsList=function(){var s=this._getSuggestionsPopoverInstance();return s&&s._oList;};
n.prototype._getSuggestionsPopoverInstance=function(){return this._oSuggPopover;};
n.prototype._getSuggestionsPopoverPopup=function(){return this._oSuggestionPopup;};
n.prototype._manageListsVisibility=function(s){if(!this.isMobileDevice()){return;}this.getAggregation("tokenizer")._getTokensList().setVisible(s);this._getSuggestionsList()&&this._getSuggestionsList().setVisible(!s);this._getSuggestionsPopover().getFilterSelectedButton().setPressed(s);};
n.prototype._handleNMoreAccessibility=function(){var i=k.getStaticId("sap.m","MULTICOMBOBOX_OPEN_NMORE_POPOVER"),F=this.getFocusDomRef(),A=(F&&F.getAttribute("aria-labelledby")),e=A?A.split(" "):[],N=e.indexOf(i),o=this.getEnabled(),p=!this.getEditable()&&this.getAggregation("tokenizer").getHiddenTokensCount();if(p&&N===-1){e.push(i);o&&this.getFocusDomRef().setAttribute("aria-keyshortcuts","Enter");}else if(N!==-1&&!p){e.splice(N,1);this.getFocusDomRef().removeAttribute("aria-keyshortcuts");}if(F&&e.length){F.setAttribute("aria-labelledby",e.join(" ").trim());}};
n.prototype._calculateSpaceForTokenizer=function(){var o=this.getDomRef();if(o){var s,e=this.$().find(".sapMInputDescriptionWrapper"),i=this.$().find(".sapMInputBaseInner"),C=o.offsetWidth||0,p=e.width()||0,t=this._calculateIconsSpace(),u=["min-width","padding-right","padding-left"],v=u.reduce(function(A,w){return A+(parseInt(i.css(w))||0);},0);s=C-(t+v+p);s=s<0?0:s;return s+"px";}else{return null;}};
n.prototype._syncInputWidth=function(t){var F=this.getDomRef('inner'),s,i;if(!F||(t&&!t.getDomRef())){return;}s=this._calculateIconsSpace();i=Math.ceil(t.getDomRef().getBoundingClientRect().width);F.style.width='calc(100% - '+Math.floor(s+i)+"px";};
n.prototype.isValueHelpOnlyOpener=function(t){return[this._$input[0],this._getValueHelpIcon().getDomRef()].indexOf(t)>-1;};
n.prototype._shouldTriggerSuggest=function(){var s=I.prototype._shouldTriggerSuggest.apply(this,arguments);return s&&!this._bShowListWithTokens;};
n.prototype.addValidator=function(v){if(typeof(v)==="function"){this._aTokenValidators.push(v);}};
n.prototype.removeValidator=function(v){var i=this._aTokenValidators.indexOf(v);if(i!==-1){this._aTokenValidators.splice(i,1);}};
n.prototype.removeAllValidators=function(){this._aTokenValidators=[];};
n.prototype.getValidators=function(){return this._aTokenValidators;};
n.prototype.addValidateToken=function(p,v){var t=this._validateToken(p,v),A=this._addUniqueToken(t,p.validationCallback);if(A){this.fireTokenUpdate({addedTokens:[t],removedTokens:[],type:T.TokenUpdateType.Added});this.fireTokenChange({addedTokens:[t],removedTokens:[],type:T.TokenChangeType.TokensChanged});}};
n.prototype._validateToken=function(p,v){var t=p.token,V=p.validationCallback,s=p.suggestionObject,e=t&&t.getText(),o=e?e:p.text,u;v=v?v:this._aTokenValidators;u=v.length;if(!u){if(!t&&V){V(false);}return t;}for(var i=0;i<u;i++){t=v[i]({text:o,suggestedToken:t,suggestionObject:s,asyncCallback:this._getAsyncValidationCallback(v,i,o,s,V)});if(!t){if(V){V(false);}return null;}if(t===n.WaitForAsyncValidation){return null;}}return t;};
n.prototype._addUniqueToken=function(t,v){if(!t){return false;}var e=!this._tokenExists(t);e&&this.addToken(t);if(v){v(e);}return e;};
n.prototype._tokenExists=function(t){var o=this.getTokens(),e=o.length,s=t&&t.getKey();if(!s){return false;}for(var i=0;i<e;i++){if(o[i].getKey()===s){return true;}}return false;};
n.prototype._convertTextToToken=function(t,C){var o=this.getAggregation("tokenizer"),O=o.getTokens().length,e=this._configureTokenOptions(t,false,C),v=e.text,i=e.item,p=e.token;if(!v){return null;}return this._validateToken({text:v,token:p,suggestionObject:i,validationCallback:this._validationCallback.bind(this,O)});};
n.prototype._validateCurrentText=function(e){var t=this.getAggregation("tokenizer"),o=t.getTokens().length,O=this._configureTokenOptions(this.getValue(),e),v=O.text,i=O.item,p=O.token;if(!v){return null;}if(i){this._bTokenIsAdded=true;}if(!this.getMaxTokens()||this.getTokens().length<this.getMaxTokens()){this._bIsValidating=true;this.addValidateToken({text:v,token:p,suggestionObject:i,validationCallback:this._validationCallback.bind(this,o)});}};
n.prototype._configureTokenOptions=function(v,e,p){var i,t;if(v&&this.getEditable()){v=v.trim();}if(v&&(e||p||this._getIsSuggestionPopupOpen())){if(this._hasTabularSuggestions()){i=this._oSuggestionTable.getSelectedItem();}else{i=this._getSuggestionItem(v,e);}}if(i&&i.getText&&i.getKey){t=new a({text:i.getText(),key:i.getKey()});}return{text:v,item:i,token:t};};
n.prototype._getAsyncValidationCallback=function(v,V,i,s,e){var t=this;return function(o){if(o){o=t.addValidateToken({text:i,token:o,suggestionObject:s,validationCallback:e},v.slice(V+1));}else{e&&e(false);}};};
return n;});
sap.ui.predefine('sap/m/MultiInputRenderer',['./InputRenderer','sap/ui/core/Renderer',"sap/ui/core/Core"],function(I,R,C){"use strict";var M=R.extend(I);M.apiVersion=2;
M.prependInnerContent=function(r,c){r.renderControl(c.getAggregation("tokenizer"));};
M.addOuterClasses=function(r,c){I.addOuterClasses.apply(this,arguments);r.class("sapMMultiInput");if(c.getTokens().length>0){r.class("sapMMultiInputHasTokens");}};
M.getAriaDescribedBy=function(c){var a=I.getAriaDescribedBy.apply(this,arguments),i=c.getAggregation("tokenizer")&&c.getAggregation("tokenizer").getTokensInfoId();if(a){a=a+" "+i;}else{a=i;}return a;};
M.getAccessibilityState=function(c){var a=I.getAccessibilityState.apply(this,arguments),r=C.getLibraryResourceBundle("sap.m");a.roledescription=r.getText("MULTIINPUT_ARIA_ROLE_DESCRIPTION");return a;};
return M;},true);
sap.ui.predefine('sap/m/NavContainer',['./library','sap/ui/core/Control','sap/ui/core/RenderManager','sap/ui/Device','./NavContainerRenderer',"sap/ui/thirdparty/jquery","sap/base/Log","sap/ui/dom/jquery/Focusable"],function(a,C,R,D,N,q,L){"use strict";
var b=C.extend("sap.m.NavContainer",{metadata:{library:"sap.m",properties:{autoFocus:{type:"boolean",group:"Behavior",defaultValue:true},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},visible:{type:"boolean",group:"Appearance",defaultValue:true},defaultTransitionName:{type:"string",group:"Appearance",defaultValue:"slide"}},defaultAggregation:"pages",aggregations:{pages:{type:"sap.ui.core.Control",multiple:true,singularName:"page"}},associations:{initialPage:{type:"sap.ui.core.Control",multiple:false}},events:{navigate:{allowPreventDefault:true,parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},afterNavigate:{parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}}}}});
var u=sap.ui.getCore().getConfiguration().getAnimation(),g=function(d){return u?d:0;},h=function(c){return!!(c&&c.getParent());},s=function(p,d){if(h(p)){p.$().css({'-webkit-animation-direction':d,'animation-direction':d});}};b.TransitionDirection={BACK:"back",TO:"to"};
b.prototype.init=function(){this._pageStack=[];this._aQueue=[];this._mVisitedPages={};this._mFocusObject={};this._iTransitionsCompleted=0;this._bNeverRendered=true;this._bNavigating=false;this._bRenderingInProgress=false;};
b.prototype.exit=function(){this._mFocusObject=null;};
b.prototype.onBeforeRendering=function(){var p=this.getCurrentPage();if(this._bNeverRendered&&p){var c=p.getId();if(!this._mVisitedPages[c]){this._mVisitedPages[c]=true;var n={from:null,fromId:null,to:p,toId:c,firstTime:true,isTo:false,isBack:false,isBackToPage:false,isBackToTop:false,direction:"initial"};var e=q.Event("BeforeFirstShow",n);e.srcControl=this;e.data=this._oToDataBeforeRendering||{};e.backData={};p._handleEvent(e);e=q.Event("BeforeShow",n);e.srcControl=this;e.data=this._oToDataBeforeRendering||{};e.backData={};p._handleEvent(e);}}};
b.prototype.onAfterRendering=function(){var p=this.getCurrentPage(),f,n,c,e;if(this._bNeverRendered&&p){this._bNeverRendered=false;delete this._bNeverRendered;c=p.getId();if(!this._isInsideAPopup()&&this.getAutoFocus()){f=b._applyAutoFocusTo(c);if(f){this._mFocusObject[c]=f;}}n={from:null,fromId:null,to:p,toId:c,firstTime:true,isTo:false,isBack:false,isBackToTop:false,isBackToPage:false,direction:"initial"};e=q.Event("AfterShow",n);e.srcControl=this;e.data=this._oToDataBeforeRendering||{};e.backData={};p._handleEvent(e);}};
b.prototype._getActualInitialPage=function(){var p=this.getInitialPage();if(p){var c=sap.ui.getCore().byId(p);if(c){return c;}else{L.error("NavContainer: control with ID '"+p+"' was set as 'initialPage' but was not found as a DIRECT child of this NavContainer (number of current children: "+this.getPages().length+").");}}var d=this.getPages();return(d.length>0?d[0]:null);};
b.prototype.getPage=function(p){var P=this.getPages();for(var i=0;i<P.length;i++){if(P[i]&&(P[i].getId()==p)){return P[i];}}return null;};
b.prototype._ensurePageStackInitialized=function(d){if(this._pageStack.length===0){var p=this._getActualInitialPage();if(p){this._pageStack.push({id:p.getId(),isInitial:true,data:d||{}});}}return this._pageStack;};
b.prototype.getCurrentPage=function(){var c=this._ensurePageStackInitialized();if(c.length>=1){return this.getPage(c[c.length-1].id);}else{L.warning(this+": page stack is empty but should have been initialized - application failed to provide a page to display");return undefined;}};
b.prototype.getPreviousPage=function(){var c=this._ensurePageStackInitialized();if(c.length>1){return this.getPage(c[c.length-2].id);}else if(c.length==1){return undefined;}else{L.warning(this+": page stack is empty but should have been initialized - application failed to provide a page to display");}};
b.prototype.currentPageIsTopPage=function(){var c=this._ensurePageStackInitialized();return(c.length===1);};
b.prototype.insertPreviousPage=function(p,t,d){var c=this._ensurePageStackInitialized();if(this._pageStack.length>0){var i=c.length-1;var e={id:p,transition:t,data:d};if(i===0){e.isInitial=true;delete c[c.length-1].isInitial;}c.splice(i,0,e);}else{L.warning(this+": insertPreviousPage called with empty page stack; ignoring");}return this;};
b._applyAutoFocusTo=function(i){var f=q(document.getElementById(i)).firstFocusableDomRef();if(f){f.focus();}return f;};
b.prototype._applyAutoFocus=function(n){var p=n.toId,d,c=n.isBack||n.isBackToPage||n.isBackToTop;if(!n.bFocusInsideFromPage){return;}if(c){d=this._mFocusObject!=null?this._mFocusObject[p]:null;if(d){d.focus();}else{b._applyAutoFocusTo(p);}}else if(n.isTo){b._applyAutoFocusTo(p);}};
b.prototype._afterTransitionCallback=function(n,d,B){var e=q.Event("AfterShow",n);e.data=d||{};e.backData=B||{};e.srcControl=this;n.to._handleEvent(e);e=q.Event("AfterHide",n);e.srcControl=this;n.from._handleEvent(e);this._iTransitionsCompleted++;this._bNavigating=false;if(this.getAutoFocus()){this._applyAutoFocus(n);}this.fireAfterNavigate(n);L.info(this+": _afterTransitionCallback called, to: "+n.toId);if(n.to.hasStyleClass("sapMNavItemHidden")){L.warning(this.toString()+": target page '"+n.toId+"' still has CSS class 'sapMNavItemHidden' after transition. This should not be the case, please check the preceding log statements.");n.to.removeStyleClass("sapMNavItemHidden");}this._dequeueNavigation();};
b.prototype._dequeueNavigation=function(){var n=this._aQueue.shift();if(typeof n==="function"){n();}};
b.prototype._isInPageStack=function(p){return this._pageStack.some(function(P){return P.id===p;});};
b.prototype._safeBackToPage=function(p,t,d,T){var c;if(!this.getPage(p)){return this;}c=this.getCurrentPage();if(c&&c.getId()===p){return this;}if(this._isInPageStack(p)){return this.backToPage(p,d,T);}else{d=d||{};d.safeBackToPage=true;return this.to(p,t,d,T);}};
b.prototype._isFocusInControl=function(c){return q(document.activeElement).closest(c.$()).length>0;};
b.prototype.to=function(p,t,d,T,f){if(p instanceof C){p=p.getId();}if(typeof(t)!=="string"){T=d;d=t;}t=t||this.getDefaultTransitionName();T=T||{};d=d||{};var F={id:p,transition:t,data:d};this._ensurePageStackInitialized(d);if(this._bNavigating){L.info(this.toString()+": Cannot navigate to page "+p+" because another navigation is already in progress. - navigation will be executed after the previous one");this._aQueue.push(q.proxy(function(){this.to(p,t,d,T,true);},this));return this;}if(this._bNeverRendered){this._oToDataBeforeRendering=d;}var o=this.getCurrentPage();if(o&&(o.getId()===p)){L.warning(this.toString()+": Cannot navigate to page "+p+" because this is the current page.");if(f){this._dequeueNavigation();}if(this._pageStack.length===1){this._pageStack[0].transition=F.transition;}return this;}var c=this.getPage(p);if(c){if(!o){L.warning("Navigation triggered to page with ID '"+p+"', but the current page is not known/aggregated by "+this);return this;}var n={from:o,fromId:o.getId(),to:c,toId:p,firstTime:!this._mVisitedPages[p],isTo:true,isBack:false,isBackToTop:false,isBackToPage:false,direction:"to",bFocusInsideFromPage:this._isFocusInControl(o)};if(n.bFocusInsideFromPage){this._mFocusObject[o.getId()]=document.activeElement;}var e=this.fireNavigate(n);if(e){a.closeKeyboard();var E=q.Event("BeforeHide",n);E.srcControl=this;o._handleEvent(E);if(!this._mVisitedPages[p]){E=q.Event("BeforeFirstShow",n);E.srcControl=this;E.data=d||{};E.backData={};c._handleEvent(E);}E=q.Event("BeforeShow",n);E.srcControl=this;E.data=d||{};E.backData={};c._handleEvent(E);this._pageStack.push(F);L.info(this.toString()+": navigating to page '"+p+"': "+c.toString());this._mVisitedPages[p]=true;if(!this.getDomRef()){L.info("'Hidden' 'to' navigation in not-rendered NavContainer "+this.toString());if(this._bRenderingInProgress){setTimeout(this.invalidate.bind(this),0);}return this;}var i;if(!(i=c.getDomRef())||i.parentNode!=this.getDomRef()||R.isPreservedContent(i)){c.addStyleClass("sapMNavItemRendering");L.debug("Rendering 'to' page '"+c.toString()+"' for 'to' navigation");var r=sap.ui.getCore().createRenderManager();r.render(c,this.getDomRef());r.destroy();c.addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemRendering");}var j=b.transitions[t]||b.transitions["slide"];var k=this._iTransitionsCompleted;var l=this;window.setTimeout(function(){if(l&&(l._iTransitionsCompleted<k+1)){L.warning("Transition '"+t+"' 'to' was triggered five seconds ago, but has not yet invoked the end-of-transition callback.");}},g(5000));this._bNavigating=true;var m=(d.safeBackToPage||T.safeBackToPage)?"back":"to";this._cacheTransitionInfo(t,m);j[m].call(this,o,c,q.proxy(function(){this._afterTransitionCallback(n,d);},this),T);}else{L.info("Navigation to page with ID '"+p+"' has been aborted by the application");}}else{L.warning("Navigation triggered to page with ID '"+p+"', but this page is not known/aggregated by "+this);}return this;};
b.prototype.back=function(c,t){this._backTo("back",c,t);return this;};
b.prototype.backToPage=function(p,c,t){this._backTo("backToPage",c,t,p);return this;};
b.prototype.backToTop=function(c,t){this._backTo("backToTop",c,t);return this;};
b.prototype._backTo=function(t,c,T,r){if(this._bNavigating){L.warning(this.toString()+": Cannot navigate back because another navigation is already in progress. - navigation will be executed after the previous one");this._aQueue.push(q.proxy(function(){this._backTo(t,c,T,r);},this));return this;}if(this._pageStack.length<=1){if(this._pageStack.length===1&&!this._pageStack[0].isInitial){throw new Error("Initial page not found on the stack. How did this happen?");}this._aQueue=[];return this;}else{if(r instanceof C){r=r.getId();}var f=this._pageStack[this._pageStack.length-1];var d=f.transition;var F=this.getPage(f.id);var o;var e;if(t==="backToTop"){o=this._getActualInitialPage();e=null;}else if(t==="backToPage"){var i=this._findClosestPreviousPageInfo(r);if(!i){L.error(this.toString()+": Cannot navigate backToPage('"+r+"') because target page was not found among the previous pages.");return this;}o=sap.ui.getCore().byId(i.id);if(!o){L.error(this.toString()+": Cannot navigate backToPage('"+r+"') because target page does not exist anymore.");return this;}e=i.data;}else{o=this.getPreviousPage();e=this._pageStack[this._pageStack.length-2].data;}if(!o){L.error("NavContainer back navigation: target page is not defined or not aggregated by this NavContainer. Aborting navigation.");return;}var j=o.getId();c=c||{};T=T||{};var n={from:F,fromId:F.getId(),to:o,toId:j,firstTime:!this._mVisitedPages[j],isTo:false,isBack:(t==="back"),isBackToPage:(t==="backToPage"),isBackToTop:(t==="backToTop"),direction:t,bFocusInsideFromPage:this._isFocusInControl(F)};var k=this.fireNavigate(n);if(k){a.closeKeyboard();var E=q.Event("BeforeHide",n);E.srcControl=this;F._handleEvent(E);if(!this._mVisitedPages[j]){E=q.Event("BeforeFirstShow",n);E.srcControl=this;E.backData=c||{};E.data={};o._handleEvent(E);}E=q.Event("BeforeShow",n);E.srcControl=this;E.backData=c||{};E.data=e||{};o._handleEvent(E);this._pageStack.pop();L.info(this.toString()+": navigating back to page "+o.toString());this._mVisitedPages[j]=true;if(t==="backToTop"){this._pageStack=[];L.info(this.toString()+": navigating back to top");this.getCurrentPage();}else if(t==="backToPage"){var p=[],l;while(this._pageStack[this._pageStack.length-1].id!==r){l=this._pageStack.pop();p.push(l.id);}L.info(this.toString()+": navigating back to specific page "+o.toString()+" across the pages: "+p.join(", "));}if(!this.getDomRef()){L.info("'Hidden' back navigation in not-rendered NavContainer "+this.toString());return this;}var m=b.transitions[d]||b.transitions["slide"];var v=this._iTransitionsCompleted;var w=this;window.setTimeout(function(){if(w&&(w._iTransitionsCompleted<v+1)){L.warning("Transition '"+d+"' 'back' was triggered five seconds ago, but has not yet invoked the end-of-transition callback.");}},g(5000));this._bNavigating=true;var x;if(!(x=o.getDomRef())||x.parentNode!=this.getDomRef()||R.isPreservedContent(x)){o.addStyleClass("sapMNavItemRendering");L.debug("Rendering 'to' page '"+o.toString()+"' for back navigation");var y=sap.ui.getCore().createRenderManager();var z=this.$().children().index(F.getDomRef());y.renderControl(o);y.flush(this.getDomRef(),false,z);y.destroy();o.addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemRendering");}if(F.getId()===o.getId()){L.info("Transition is skipped when navigating back to the same page instance"+o.toString());this._afterTransitionCallback(n,e,c);return this;}this._cacheTransitionInfo(d,b.TransitionDirection.BACK);m.back.call(this,F,o,q.proxy(function(){this._afterTransitionCallback(n,e,c);},this),T);}}return this;};
b.prototype._findClosestPreviousPageInfo=function(r){for(var i=this._pageStack.length-2;i>=0;i--){var c=this._pageStack[i];if(c.id===r){return c;}}return null;};
b.prototype._cacheTransitionInfo=function(t,T){this._sTransitionName=t;this._sTransitionDirection=T;};
b.prototype._fadeTransition=function(f,t,c){this.oFromPage=f;this.oToPage=t;this.fCallback=c;this._fadeOutAnimation();};
b.prototype._fadeOutAnimation=function(){var t=this,f=this.oFromPage,T=this.oToPage;T.addStyleClass("sapMNavItemTransparent");if(this._sTransitionName==="slide"){if(this._sTransitionDirection===b.TransitionDirection.TO){T.addStyleClass("sapMNavItemSlideLeft");f.addStyleClass("sapMNavItemSlideRight");}else{T.addStyleClass("sapMNavItemSlideRight");f.addStyleClass("sapMNavItemSlideLeft");}}T.removeStyleClass("sapMNavItemHidden");f.addStyleClass("sapMNavItemOpaque");window.setTimeout(function(){f.$().on("webkitTransitionEnd transitionend",t._fadeOutAnimationEnd.bind(t));t.bTransition1EndPending=true;f.addStyleClass("sapMNavItemFading").removeStyleClass("sapMNavItemOpaque").addStyleClass("sapMNavItemTransparent");window.setTimeout(function(){if(t.bTransition1EndPending){t._fadeOutAnimationEnd();}},g(150));},g(10));};
b.prototype._fadeOutAnimationEnd=function(e){var f=this.oFromPage;if(e&&e.originalEvent&&e.originalEvent.propertyName!=="opacity"){return;}this.bTransition1EndPending=false;q(f.$()).off("webkitTransitionEnd transitionend");f.removeStyleClass("sapMNavItemSlideLeft").removeStyleClass("sapMNavItemSlideRight");this._fadeInAnimation();};
b.prototype._fadeInAnimation=function(){var t=this,T=this.oToPage;window.setTimeout(function(){T.$().on("webkitTransitionEnd transitionend",t._fadeInAnimationEnd.bind(t));t.bTransition2EndPending=true;T.addStyleClass("sapMNavItemFading").removeStyleClass("sapMNavItemTransparent").addStyleClass("sapMNavItemOpaque");window.setTimeout(function(){if(t.bTransition2EndPending){t._fadeInAnimationEnd();}},g(150));},g(10));};
b.prototype._fadeInAnimationEnd=function(e){var t=this.oToPage,f=this.oFromPage;if(e&&e.originalEvent&&e.originalEvent.propertyName!=="opacity"){return;}this.bTransition2EndPending=false;if(h(f)){f.addStyleClass("sapMNavItemHidden");f.removeStyleClass("sapMNavItemFading").removeStyleClass("sapMNavItemTransparent");}q(t.$()).off("webkitTransitionEnd transitionend");if(h(t)){t.removeStyleClass("sapMNavItemFading").removeStyleClass("sapMNavItemOpaque").removeStyleClass("sapMNavItemSlideLeft").removeStyleClass("sapMNavItemSlideRight");}this.fCallback();};
b.prototype._baseSlideAnimation=function(f,t,c){var F=false,T=true,i=this._sTransitionDirection===b.TransitionDirection.BACK,A=i?"reverse":"normal",d=i?"sapMNavItemSlideCenterToLeft":"sapMNavItemSlideRightToCenter",e=!i?"sapMNavItemSlideCenterToLeft":"sapMNavItemSlideRightToCenter",j=function(){q(this).off("webkitAnimationEnd animationend");if(!F){return(F=true);}T=false;s(t,"");s(f,"");if(h(t)){t.removeStyleClass(d);}if(h(f)){f.removeStyleClass(e).addStyleClass("sapMNavItemHidden");}c();};f.$().on("webkitAnimationEnd animationend",j);t.$().on("webkitAnimationEnd animationend",j);s(t,A);s(f,A);f.addStyleClass(e);t.addStyleClass(d).removeStyleClass("sapMNavItemHidden");window.setTimeout(function(){if(T){F=true;j.apply(f.$().add(t.$()));}},g(400));};
b.transitions=b.transitions||{};b.transitions["show"]={to:function(f,t,c){t.removeStyleClass("sapMNavItemHidden");f&&f.addStyleClass("sapMNavItemHidden");c();},back:function(f,t,c){t.removeStyleClass("sapMNavItemHidden");f&&f.addStyleClass("sapMNavItemHidden");c();}};b.transitions["baseSlide"]={to:b.prototype._baseSlideAnimation,back:b.prototype._baseSlideAnimation};b.transitions["slide"]={to:b.prototype._fadeTransition,back:b.prototype._fadeTransition};b.transitions["fade"]={to:b.prototype._fadeTransition,back:b.prototype._fadeTransition};b.transitions["flip"]={to:function(f,t,c){var d=this;window.setTimeout(function(){d.$().addClass("sapMNavFlip");t.addStyleClass("sapMNavItemFlipNext");t.removeStyleClass("sapMNavItemHidden");window.setTimeout(function(){var o=false;var T=true;var A=null;A=function(){q(this).off("webkitTransitionEnd transitionend");if(!o){o=true;}else{T=false;if(h(t)){t.removeStyleClass("sapMNavItemFlipping");}if(h(f)){f.removeStyleClass("sapMNavItemFlipping").addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemFlipPrevious");}d.$().removeClass("sapMNavFlip");c();}};f.$().on("webkitTransitionEnd transitionend",A);t.$().on("webkitTransitionEnd transitionend",A);t.addStyleClass("sapMNavItemFlipping").removeStyleClass("sapMNavItemFlipNext");f.addStyleClass("sapMNavItemFlipping").addStyleClass("sapMNavItemFlipPrevious");window.setTimeout(function(){if(T){o=true;A.apply(f.$().add(t.$()));}},g(600));},g(60));},0);},back:function(f,t,c){var d=this;d.$().addClass("sapMNavFlip");t.addStyleClass("sapMNavItemFlipPrevious");t.removeStyleClass("sapMNavItemHidden");window.setTimeout(function(){var o=false;var T=true;var A=null;A=function(){q(this).off("webkitTransitionEnd transitionend");if(!o){o=true;}else{T=false;if(h(t)){t.removeStyleClass("sapMNavItemFlipping");}if(h(f)){f.removeStyleClass("sapMNavItemFlipping").addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemFlipNext");}d.$().removeClass("sapMNavFlip");c();}};f.$().on("webkitTransitionEnd transitionend",A);t.$().on("webkitTransitionEnd transitionend",A);t.addStyleClass("sapMNavItemFlipping").removeStyleClass("sapMNavItemFlipPrevious");f.addStyleClass("sapMNavItemFlipping").addStyleClass("sapMNavItemFlipNext");window.setTimeout(function(){if(T){o=true;A.apply(f.$().add(t.$()));}},g(600));},g(60));}};b.transitions["door"]={to:function(f,t,c){var d=this;window.setTimeout(function(){d.$().addClass("sapMNavDoor");t.addStyleClass("sapMNavItemDoorInNext");t.removeStyleClass("sapMNavItemHidden");window.setTimeout(function(){var o=false;var T=true;var A=null;A=function(){q(this).off("webkitAnimationEnd animationend");if(!o){o=true;}else{T=false;if(h(t)){t.removeStyleClass("sapMNavItemDooring").removeStyleClass("sapMNavItemDoorInNext");}if(h(f)){f.removeStyleClass("sapMNavItemDooring").addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemDoorInPrevious");}d.$().removeClass("sapMNavDoor");c();}};f.$().on("webkitAnimationEnd animationend",A);t.$().on("webkitAnimationEnd animationend",A);t.addStyleClass("sapMNavItemDooring");f.addStyleClass("sapMNavItemDooring").addStyleClass("sapMNavItemDoorInPrevious");window.setTimeout(function(){if(T){o=true;A.apply(f.$().add(t.$()));}},g(1000));},g(60));},0);},back:function(f,t,c){var d=this;d.$().addClass("sapMNavDoor");t.addStyleClass("sapMNavItemDoorOutNext");t.removeStyleClass("sapMNavItemHidden");window.setTimeout(function(){var o=false;var T=true;var A=null;A=function(){q(this).off("webkitAnimationEnd animationend");if(!o){o=true;}else{T=false;if(h(t)){t.removeStyleClass("sapMNavItemDooring").removeStyleClass("sapMNavItemDoorOutNext");}if(h(f)){f.removeStyleClass("sapMNavItemDooring").addStyleClass("sapMNavItemHidden").removeStyleClass("sapMNavItemDoorOutPrevious");}d.$().removeClass("sapMNavDoor");c();}};f.$().on("webkitAnimationEnd animationend",A);t.$().on("webkitAnimationEnd animationend",A);t.addStyleClass("sapMNavItemDooring");f.addStyleClass("sapMNavItemDooring").addStyleClass("sapMNavItemDoorOutPrevious");window.setTimeout(function(){if(T){o=true;A.apply(f.$().add(t.$()));}},g(1000));},g(60));}};
b.prototype.addCustomTransition=function(n,t,B){if(b.transitions[n]){L.warning("Transition with name "+n+" already exists in "+this+". It is now being replaced by custom transition.");}b.transitions[n]={to:t,back:B};return this;};
b.addCustomTransition=b.prototype.addCustomTransition;b.prototype.forceInvalidation=b.prototype.invalidate;
b.prototype.invalidate=function(S){if(S==this){}else if(!S){this.forceInvalidation();}else if(S instanceof C){var I=false,p=this.getPages(),l=p.length;for(var i=0;i<l;i++){if(p[i]===S){I=true;break;}}if((!I||S===this.getCurrentPage())&&!this._isInsideAPopup()){this.forceInvalidation();}}else{this.forceInvalidation();}};
b.prototype._isInsideAPopup=function(){var S;S=function(c){if(!c){return false;}if(c.getMetadata().isInstanceOf("sap.ui.core.PopupInterface")){return true;}return S(c.getParent());};return S(this);};
b.prototype.removePage=function(p){var P;if(typeof(p)=="number"){P=this.getPages()[p];}else if(typeof(p)=="string"){P=sap.ui.getCore().byId(p);}else{P=p;}P=this.removeAggregation("pages",P,P!==this.getCurrentPage());this._onPageRemoved(P);return P;};
b.prototype._onPageRemoved=function(p){if(!p){return;}p.$().remove();p.removeStyleClass("sapMNavItemHidden");p.removeStyleClass("sapMNavItem");var S=this._ensurePageStackInitialized();this._pageStack=S.filter(function(P){return p.getId()!==P.id;});};
b.prototype.removeAllPages=function(){var p=this.removeAllAggregation("pages");for(var i=0;i<p.length;i++){this._onPageRemoved(p[i]);}return p;};
b.prototype.addPage=function(p){var P=this.getPages();if(P.indexOf(p)>-1){return this;}this.addAggregation("pages",p,true);p.addStyleClass("sapMNavItem");var i=P.length;if(i===0&&this.getPages().length===1){this._fireAdaptableContentChange(p);if(this.getDomRef()){this._ensurePageStackInitialized();this.rerender();}}return this;};
b.prototype.insertPage=function(p,i){var P=this.getPages().length;this.insertAggregation("pages",p,i,true);p.addStyleClass("sapMNavItem");if(P===0&&this.getPages().length===1){this._fireAdaptableContentChange(p);if(this.getDomRef()){this._ensurePageStackInitialized();this.rerender();}}return this;};
b.prototype._getAdaptableContent=function(){return this.getCurrentPage();};
b.prototype._fireAdaptableContentChange=function(p){if(p&&this.mEventRegistry["_adaptableContentChange"]){this.fireEvent("_adaptableContentChange",{"parent":this,"adaptableContent":p});}};
return b;});
sap.ui.predefine('sap/m/NavContainerRenderer',["sap/ui/core/InvisibleRenderer"],function(I){"use strict";var N={apiVersion:2};
N.render=function(r,c){c._bRenderingInProgress=true;if(!c.getVisible()){I.render(r,c,"div");return false;}var h=c.getHeight(),t=c.getTooltip_AsString(),C=c.getCurrentPage();r.openStart("div",c);r.class("sapMNav");r.style("width",c.getWidth());if(h&&h!="100%"){r.style("height",h);}if(this.renderAttributes){this.renderAttributes(r,c);}if(t){r.attr("title",t);}r.openEnd();if(this.renderBeforeContent){this.renderBeforeContent(r,c);}c.getPages().forEach(function(p){if(p===C){C.removeStyleClass("sapMNavItemHidden");r.renderControl(C);}else{r.cleanupControlWithoutRendering(p);}});r.close("div");c._bRenderingInProgress=false;};
return N;},true);
sap.ui.predefine('sap/m/NewsContent',['./library','sap/ui/core/Control','sap/m/Text','sap/ui/Device','./NewsContentRenderer',"sap/ui/events/KeyCodes"],function(l,C,T,D,N,K){"use strict";
var a=C.extend("sap.m.NewsContent",{metadata:{library:"sap.m",designtime:"sap/m/designtime/NewsContent.designtime",properties:{"size":{type:"sap.m.Size",group:"Misc",defaultValue:"Auto"},"contentText":{type:"string",group:"Misc",defaultValue:null},"subheader":{type:"string",group:"Misc",defaultValue:null}},defaultAggregation:"_contentText",aggregations:{"_contentText":{type:"sap.m.Text",multiple:false,visibility:"hidden"}},events:{"press":{}}}});
a.prototype.init=function(){this._oContentText=new T(this.getId()+"-content-text",{maxLines:2});this._oContentText.cacheLineHeight=false;this.setAggregation("_contentText",this._oContentText,true);this.setTooltip("{AltText}");};
a.prototype.onBeforeRendering=function(){this._setPointerOnContentText();this.$().off("mouseenter");this.$().off("mouseleave");};
a.prototype.onAfterRendering=function(){this.$().on("mouseenter",this._addTooltip.bind(this));this.$().on("mouseleave",this._removeTooltip.bind(this));};
a.prototype._addTooltip=function(){this.$().attr("title",this.getTooltip_AsString());};
a.prototype._removeTooltip=function(){this.$().attr("title",null);};
a.prototype._setPointerOnContentText=function(){var t=this.getAggregation("_contentText");if(t&&this.hasListeners("press")){t.addStyleClass("sapMPointer");}else if(t&&t.hasStyleClass("sapMPointer")){t.removeStyleClass("sapMPointer");}};
a.prototype.getAltText=function(){var A="";var i=true;if(this.getAggregation("_contentText").getText()){A+=this.getAggregation("_contentText").getText();i=false;}if(this.getSubheader()){if(i){A+=""+this.getSubheader();}else{A+="\n"+this.getSubheader();}}return A;};
a.prototype.getTooltip_AsString=function(){var t=this.getTooltip();var s=this.getAltText();if(typeof t==="string"||t instanceof String){s=t.split("{AltText}").join(s).split("((AltText))").join(s);return s;}if(t){return t;}else{return"";}};
a.prototype.setContentText=function(t){this._oContentText.setText(t);return this.setProperty("contentText",t,true);};
a.prototype.ontap=function(e){if(D.browser.msie){this.$().trigger("focus");}this.firePress();};
a.prototype.onkeydown=function(e){if(e.which===K.ENTER||e.which===K.SPACE){this.firePress();e.preventDefault();}};
a.prototype.attachEvent=function(e,d,f,b){C.prototype.attachEvent.call(this,e,d,f,b);if(this.hasListeners("press")){this.$().attr("tabindex",0).addClass("sapMPointer");this._setPointerOnContentText();}return this;};
a.prototype.detachEvent=function(e,f,b){C.prototype.detachEvent.call(this,e,f,b);if(!this.hasListeners("press")){this.$().removeAttr("tabindex").removeClass("sapMPointer");this._setPointerOnContentText();}return this;};
return a;});
sap.ui.predefine('sap/m/NewsContentRenderer',[],function(){"use strict";var N={};
N.render=function(r,c){var s=c.getSubheader();var t=c.getTooltip_AsString();if(typeof t!=="string"){t="";}r.write("<div");r.writeControlData(c);r.writeAttribute("role","presentation");r.writeAttributeEscaped("aria-label",t);r.addClass("sapMNwC");if(c.hasListeners("press")){r.addClass("sapMPointer");r.writeAttribute("tabindex","0");}r.writeClasses();r.write(">");r.write("<div");r.addClass("sapMNwCCTxt");r.writeClasses();r.write(">");r.renderControl(c._oContentText);r.write("</div>");r.write("<div");r.writeAttribute("id",c.getId()+"-subheader");r.addClass("sapMNwCSbh");r.writeClasses();r.write(">");r.writeEscaped(s);r.write("</div>");r.write("</div>");};
return N;},true);
sap.ui.predefine('sap/m/NotificationListBase',['./library','sap/ui/core/Core','sap/ui/core/Control','sap/ui/core/Element','sap/ui/Device','./ListItemBase','./Button','./ToolbarSeparator','sap/m/OverflowToolbar','sap/m/OverflowToolbarLayoutData','sap/ui/core/IconPool','sap/ui/core/Icon','sap/ui/core/library'],function(l,C,a,E,D,L,B,T,O,b,I,c,d){'use strict';var P=d.Priority;var e=l.ButtonType;var f=l.OverflowToolbarPriority;var r=C.getLibraryResourceBundle('sap.m'),g=r.getText('NOTIFICATION_LIST_ITEM_CLOSE'),h=r.getText('NOTIFICATION_LIST_GROUP_CLOSE');
var N=L.extend('sap.m.NotificationListBase',{
metadata:{library:'sap.m',"abstract":true,properties:{priority:{type:'sap.ui.core.Priority',group:'Appearance',defaultValue:P.None},title:{type:'string',group:'Appearance',defaultValue:''},datetime:{type:'string',group:'Appearance',defaultValue:''},showButtons:{type:'boolean',group:'Behavior',defaultValue:true},showCloseButton:{type:'boolean',group:'Behavior',defaultValue:true},authorName:{type:'string',group:'Appearance',defaultValue:''},authorPicture:{type:'sap.ui.core.URI'}},aggregations:{buttons:{type:'sap.m.Button',multiple:true},_closeButton:{type:'sap.m.Button',multiple:false,visibility:"hidden"},_overflowToolbar:{type:'sap.m.OverflowToolbar',multiple:false,visibility:"hidden"},_priorityIcon:{type:'sap.ui.core.Icon',multiple:false,visibility:"hidden"}},events:{close:{}}},
renderer:null
});
N.prototype._activeHandling=function(){};
N.prototype.updateSelectedDOM=function(){};
N.prototype.getAccessibilityText=function(){return'';};
N.prototype.getButtons=function(){var i=this._getCloseButton(),t=this._getToolbarSeparator();return this._getOverflowToolbar().getContent().filter(function(j){return j!==i&&j!==t;},this);};
N.prototype.addButton=function(o){var i=this._getOverflowToolbar(),j=i.getContent().length;if(D.system.phone){j-=2;}i.insertContent(o,j);this.invalidate();return this;};
N.prototype.insertButton=function(o,i){this._getOverflowToolbar().insertContent(o,i);this.invalidate();return this;};
N.prototype.removeButton=function(o){var i=this._getOverflowToolbar().removeContent(o.getId());this.invalidate();return i;};
N.prototype.removeAllButtons=function(){var o=this._getOverflowToolbar(),i=this.getButtons();i.forEach(function(j){o.removeContent(j.getId());});this.invalidate();return this;};
N.prototype.destroyButtons=function(){var i=this.getButtons();i.forEach(function(j){j.destroy();});this.invalidate();return this;};
N.prototype.clone=function(){var i=L.prototype.clone.apply(this,arguments);i.destroyAggregation('_overflowToolbar');var o=this.getAggregation('_overflowToolbar');if(o){i.setAggregation("_overflowToolbar",o.clone(),true);}return i;};
N.prototype._getOverflowToolbar=function(){var o=this.getAggregation('_overflowToolbar'),t,i;if(!o){o=new O(this.getId()+'-overflowToolbar',{});this.setAggregation("_overflowToolbar",o,true);if(D.system.phone){i=this._getCloseButton();i.setLayoutData(new b({priority:f.AlwaysOverflow}));t=new T();t.setLayoutData(new b({priority:f.AlwaysOverflow}));o.addContent(t);o.addContent(i);}}return o;};
N.prototype._getCloseButton=function(){var i,o,j,k;if(D.system.phone){o=this._getOverflowToolbar();j=o.getContent();if(o&&j.length){k=j.length-1;i=j[k];}}else{i=this.getAggregation("_closeButton");}if(!i){if(D.system.phone){i=new B(this.getId()+'-closeButtonOverflow',{text:this.isA("sap.m.NotificationListItem")?g:h,type:e.Default,press:function(){this.close();}.bind(this)});}else{i=new B(this.getId()+'-closeButtonX',{icon:I.getIconURI('decline'),type:e.Transparent,tooltip:this.isA("sap.m.NotificationListItem")?g:h,press:function(){this.close();}.bind(this)});this.setAggregation("_closeButton",i);}}return i;};
N.prototype._getToolbarSeparator=function(){if(!D.system.phone){return null;}var t,o=this._getOverflowToolbar(),i=o.getContent(),j;if(o&&i.length){j=i.length-2;t=i[j];}return t;};
N.prototype.exit=function(){};
N.prototype._hasActionButtons=function(){return this.getShowButtons()&&this.getButtons().length;};
N.prototype._shouldRenderCloseButton=function(){return!D.system.phone&&this.getShowCloseButton();};
N.prototype._shouldRenderOverflowToolbar=function(){var i=this._hasActionButtons();if(D.system.phone){return i||this.getShowCloseButton();}return i;};
N.prototype.onBeforeRendering=function(){var j=this.getButtons(),k,m;if(D.system.phone){this._updatePhoneButtons();return;}k=j.length>1?f.AlwaysOverflow:f.NeverOverflow;for(var i=0;i<j.length;i++){m=j[i];m.setLayoutData(new b({priority:i===0?k:f.AlwaysOverflow}));}};
N.prototype._updatePhoneButtons=function(){var i=this._getCloseButton(),j=this.isA("sap.m.NotificationListGroup"),k=j?h:g,m=j&&this.getCollapsed(),n=!m&&this._hasActionButtons(),s=this.getShowCloseButton(),t=this._getToolbarSeparator(),p;this.getButtons().forEach(function(o){if(n){p=f.AlwaysOverflow;o.removeStyleClass('sapMNLIBHiddenButton');}else{p=f.NeverOverflow;o.addStyleClass('sapMNLIBHiddenButton');}o.setLayoutData(new b({priority:p}));});if(!s){i.setVisible(false);t.setVisible(false);return;}i.setVisible(true);if(n){i.setText(k);i.setTooltip('');i.setType(e.Default);i.setIcon('');i.setLayoutData(new b({priority:f.AlwaysOverflow}));t.setVisible(true);}else{i.setText('');i.setTooltip(k);i.setType(e.Transparent);i.setIcon(I.getIconURI('decline'));i.setLayoutData(new b({priority:f.NeverOverflow}));t.setVisible(false);}};
N.prototype.close=function(){var p=this.getParent();this.fireClose();var H=!!this.getParent();if(!H&&p&&p instanceof E){var i={onAfterRendering:function(){p.focus();p.removeEventDelegate(i);}};p.addEventDelegate(i);}};
N.prototype._getPriorityIcon=function(){var p=this.getAggregation('_priorityIcon');if(!p){p=new c({src:'sap-icon://message-error',useIconTooltip:false});this.setAggregation("_priorityIcon",p,true);}return p;};
return N;});
sap.ui.predefine('sap/m/NotificationListGroup',['./library','sap/ui/core/Core','./NotificationListBase','sap/ui/core/InvisibleText','./ListItemBase','sap/ui/core/IconPool','sap/ui/core/library','sap/ui/Device','sap/m/Button','./NotificationListGroupRenderer',"sap/ui/events/KeyCodes"],function(l,C,N,I,L,a,c,D,B,b,K){'use strict';var P=c.Priority;var d=l.ButtonType;var R=C.getLibraryResourceBundle('sap.m'),E=R.getText('NOTIFICATION_LIST_GROUP_EXPAND'),e=R.getText('NOTIFICATION_LIST_GROUP_COLLAPSE'),f=R.getText('NOTIFICATION_LIST_GROUP_READ'),U=R.getText('NOTIFICATION_LIST_GROUP_UNREAD'),g='sap-icon://slim-arrow-right',h='sap-icon://slim-arrow-down';var m=D.system.desktop?400:100;
var i=N.extend('sap.m.NotificationListGroup',{metadata:{library:'sap.m',properties:{collapsed:{type:'boolean',group:'Behavior',defaultValue:false},autoPriority:{type:'boolean',group:'Behavior',defaultValue:true},showEmptyGroup:{type:'boolean',group:'Behavior',defaultValue:false},enableCollapseButtonWhenEmpty:{type:'boolean',group:'Behavior',defaultValue:false},showItemsCounter:{type:'boolean',group:'Behavior',defaultValue:true},authorName:{type:'string',group:'Appearance',defaultValue:'',deprecated:true},authorPicture:{type:'sap.ui.core.URI',multiple:false,deprecated:true},datetime:{type:'string',group:'Appearance',defaultValue:'',deprecated:true}},defaultAggregation:'items',aggregations:{items:{type:'sap.m.NotificationListItem',multiple:true,singularName:'item'},_collapseButton:{type:'sap.m.Button',multiple:false,visibility:"hidden"}},events:{onCollapse:{parameters:{collapsed:{type:'boolean'}}}}}});
i.prototype._getCollapseButton=function(){var k=this.getAggregation('_collapseButton'),n=this.getCollapsed();if(!k){k=new B(this.getId()+'-collapseButton',{type:d.Transparent,press:function(){var o=!this.getCollapsed();this.setCollapsed(o);this.fireOnCollapse({collapsed:o});}.bind(this)});this.setAggregation("_collapseButton",k,true);}k.setIcon(n?g:h);k.setTooltip(n?E:e);return k;};
i.prototype.init=function(){this._groupTitleInvisibleText=new I({id:this.getId()+"-invisibleGroupTitleText"});};
i.prototype.exit=function(){N.prototype.exit.apply(this,arguments);if(this._groupTitleInvisibleText){this._groupTitleInvisibleText.destroy();this._groupTitleInvisibleText=null;}};
i.prototype.getVisibleItems=function(){var v=this.getItems().filter(function(k){return k.getVisible();});return v;};
i.prototype._getVisibleItemsCount=function(){return this.getVisibleItems().length;};
i.prototype._getGroupTitleInvisibleText=function(){var r=this.getUnread()?U:f,p,k=this.getPriority(),n,o=[r];if(k!==P.None){p=R.getText('NOTIFICATION_LIST_GROUP_PRIORITY',k);o.push(p);}if(this.getShowItemsCounter()){n=R.getText("LIST_ITEM_COUNTER",[this._getVisibleItemsCount()]);o.push(n);}return this._groupTitleInvisibleText.setText(o.join(' '));};
i.prototype.getPriority=function(){if(!this.getAutoPriority()){return this.getProperty('priority');}var n=this.getAggregation('items');var p=P.None;if(n){n.forEach(function(k){p=j(p,k.getPriority());});}else{p=this.getProperty('priority');}return p;};
function j(k,s){if(k==s){return k;}if((k=='None')){return s;}if((k=='Low')&&(s!='None')){return s;}if((k=='Medium')&&(s!='None'&&s!='Low')){return s;}return k;}
i.prototype.onBeforeRendering=function(){N.prototype.onBeforeRendering.apply(this,arguments);this._getCollapseButton().setVisible(this.getEnableCollapseButtonWhenEmpty()||this._getVisibleItemsCount()>0);};
i.prototype._isMaxNumberReached=function(){return this.getItems().length>m;};
i.prototype._getMaxNumberReachedMsg=function(){return{title:R.getText('NOTIFICATION_LIST_GROUP_MAX_NOTIFICATIONS_TITLE',this.getItems().le