/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library",'sap/ui/core/Core',"sap/ui/core/Item",'sap/ui/core/Icon','./NavigationList','sap/ui/core/InvisibleText','sap/ui/core/Renderer','sap/ui/core/IconPool',"sap/ui/events/KeyCodes","sap/ui/core/library","sap/ui/dom/jquery/Aria"],function(l,C,I,a,N,b,R,c,K,d){"use strict";var T=d.TextAlign;var e=d.TextDirection;var f=I.extend("sap.tnt.NavigationListItem",{metadata:{library:"sap.tnt",properties:{icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:''},expanded:{type:"boolean",group:"Misc",defaultValue:true},hasExpander:{type:"boolean",group:"Misc",defaultValue:true},visible:{type:"boolean",group:"Appearance",defaultValue:true},href:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},target:{type:"string",group:"Behavior",defaultValue:null}},defaultAggregation:"items",aggregations:{items:{type:"sap.tnt.NavigationListItem",multiple:true,singularName:"item"},_expandIconControl:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},events:{select:{parameters:{item:{type:"sap.ui.core.Item"}}}},designtime:"sap/tnt/designtime/NavigationListItem.designtime"}});f.expandIcon='sap-icon://navigation-right-arrow';f.collapseIcon='sap-icon://navigation-down-arrow';f._getInvisibleText=function(){return this._invisibleText||(this._invisibleText=new b().toStatic());};f.prototype.init=function(){this._resourceBundle=C.getLibraryResourceBundle("sap.ui.core");this._resourceBundleMLib=C.getLibraryResourceBundle("sap.m");this._resourceBundleTNTLib=C.getLibraryResourceBundle("sap.tnt");};f.prototype._getUniqueKey=function(){var k=this.getKey();if(k){return k;}return this.getId();};f.prototype._getExpandIconControl=function(){var g=this.getAggregation('_expandIconControl');if(!g){var h=this.getExpanded();g=new a({src:h?f.collapseIcon:f.expandIcon,visible:this.getItems().length>0&&this.getHasExpander(),useIconTooltip:false,tooltip:this._getExpandIconTooltip(!h)}).addStyleClass('sapTntNavLIExpandIcon');this.setAggregation("_expandIconControl",g,true);}return g;};f.prototype._getExpandIconTooltip=function(g){if(!this.getEnabled()){return'';}var t=g?'Icon.expand':'Icon.collapse';return this._resourceBundle.getText(t);};f.prototype.getLevel=function(){var g=0;var p=this.getParent();if(p.getMetadata().getName()=='sap.tnt.NavigationListItem'){return p.getLevel()+1;}return g;};f.prototype.getNavigationList=function(){var p=this.getParent();while(p&&p.getMetadata().getName()!='sap.tnt.NavigationList'){p=p.getParent();}return p;};f.prototype._isListExpanded=function(){var n=this.getNavigationList();return n.getExpanded()||n.hasStyleClass("sapTntNavLIPopup");};f.prototype.createPopupList=function(){var n=[],g=this.getNavigationList(),s=g.getSelectedItem(),p,h,j,k=this.getItems();for(var i=0;i<k.length;i++){h=k[i];if(h.getVisible()){j=new f({key:h.getId(),text:h.getText(),textDirection:h.getTextDirection(),enabled:h.getEnabled(),href:h.getHref(),target:h.getTarget()});n.push(j);if(s===h){p=j;}}}var m=new f({expanded:true,hasExpander:false,key:this.getId(),text:this.getText(),enabled:this.getEnabled(),textDirection:this.getTextDirection(),href:this.getHref(),target:this.getTarget(),items:n});var o=new N({itemSelect:this.onPopupItemSelect.bind(this),items:[m]}).addStyleClass('sapTntNavLIPopup');if(s==this){p=m;o.isGroupSelected=true;}o.setSelectedItem(p);return o;};f.prototype.onPopupItemSelect=function(g){var i=g.getParameter('item');i=C.byId(i.getKey());i._selectItem(g);};f.prototype._selectItem=function(g){var p={item:this},n=this.getNavigationList();this.fireSelect(p);n._selectItem(p);this._openUrl();};f.prototype._openUrl=function(){var h=this.getHref();if(h){window.open(h,this.getTarget()||'_self');}};f.prototype.onkeydown=function(g){if(g.isMarked('subItem')){return;}g.setMarked('subItem');if(this.getLevel()>0){return;}var i=C.getConfiguration().getRTL();if((g.shiftKey&&g.which==189)||g.which==K.NUMPAD_MINUS||(g.which==K.ARROW_RIGHT&&i)||(g.which==K.ARROW_LEFT&&!i)){if(this.collapse()){g.preventDefault();g.stopPropagation();}}else if(g.which==K.NUMPAD_PLUS||(g.shiftKey&&g.which==K.PLUS)||g.which==K.ARROW_LEFT&&i||g.which==K.ARROW_RIGHT&&!i){if(this.expand()){g.preventDefault();g.stopPropagation();}}};f.prototype.expand=function(g){if(this.getExpanded()||!this.getHasExpander()||this.getItems().length==0||this.getLevel()>0){return;}this.setProperty('expanded',true,true);this.$().find('.sapTntNavLIGroup').attr('aria-expanded',true);var h=this._getExpandIconControl();h.setSrc(f.collapseIcon);h.setTooltip(this._getExpandIconTooltip(false));var $=this.$().find('.sapTntNavLIGroupItems');$.stop(true,true).slideDown(g||'fast',function(){$.toggleClass('sapTntNavLIHiddenGroupItems');});this.getNavigationList()._updateNavItems();return true;};f.prototype.collapse=function(g){if(!this.getExpanded()||!this.getHasExpander()||this.getItems().length==0||this.getLevel()>0){return;}this.setProperty('expanded',false,true);this.$().find('.sapTntNavLIGroup').attr('aria-expanded',false);var h=this._getExpandIconControl();h.setSrc(f.expandIcon);h.setTooltip(this._getExpandIconTooltip(true));var $=this.$().find('.sapTntNavLIGroupItems');$.stop(true,true).slideUp(g||'fast',function(){$.toggleClass('sapTntNavLIHiddenGroupItems');});this.getNavigationList()._updateNavItems();return true;};f.prototype.ontap=function(g){var n=this.getNavigationList(),s=C.byId(g.target.id),h=this.getLevel(),p,i;if(g.isMarked('subItem')){return;}g.setMarked('subItem');if(!this.getEnabled()){return;}if(h===1){p=this.getParent();if(this.getEnabled()&&p.getEnabled()){this._selectItem(g);}return;}if(n.getExpanded()||!this.getItems().length){if(!s||s.getMetadata().getName()!=='sap.ui.core.Icon'||!s.$().hasClass('sapTntNavLIExpandIcon')){this._selectItem(g);return;}g.preventDefault();if(this.getExpanded()){this.collapse();}else{this.expand();}}else{i=this.createPopupList();n._openPopover(this,i);}};f.prototype.onsapenter=f.prototype.ontap;f.prototype.onsapspace=f.prototype.ontap;f.prototype.render=function(r,g){if(!this.getVisible()){return;}if(this.getLevel()===0){this.renderFirstLevelNavItem(r,g);}else{this.renderSecondLevelNavItem(r,g);}};f.prototype.renderGroupItem=function(r,g){var i=this._isListExpanded(),h=this.getExpanded(),j=this._getVisibleItems(this),k=j.length,t=this.getText(),m=this.getHref(),n=this.getTarget(),o,p={level:'1',role:'treeitem',selected:false,roledescription:this._resourceBundleTNTLib.getText("NAVIGATION_LIST_ITEM_ROLE_DESCRIPTION_TREE_ITEM")};r.openStart("div");r.class("sapTntNavLIItem");r.class("sapTntNavLIGroup");if(g._selectedItem===this){p.selected=true;r.class("sapTntNavLIItemSelected");}if(!this.getEnabled()){r.class("sapTntNavLIItemDisabled");}if(!i&&this._hasSelectedChild(g._selectedItem)){r.class("sapTntNavLIItemSelected");}if(i){o=this.getTooltip_AsString()||t;if(o){r.attr("title",o);}if(this.getEnabled()){r.attr("tabindex","-1");}if(k>0){p.expanded=h;}r.accessibilityState(p);}r.openEnd();r.openStart('a',this.getId()+'-a');r.attr('tabindex','-1');if(m){r.attr('href',m);}if(n){r.attr('target',n);}r.openEnd();this._renderIcon(r);if(g.getExpanded()){var q=this._getExpandIconControl();q.setVisible(this.getItems().length>0&&this.getHasExpander());q.setSrc(this.getExpanded()?f.collapseIcon:f.expandIcon);q.setTooltip(this._getExpandIconTooltip(!this.getExpanded()));this._renderText(r);r.renderControl(q);}r.close("a");r.close("div");};f.prototype.renderFirstLevelNavItem=function(r,g){var h,j=this._getVisibleItems(this),k=j.length,m=this.getExpanded(),n=this._isListExpanded(),t,o={role:'menuitemradio',checked:false,roledescription:this._resourceBundleTNTLib.getText("NAVIGATION_LIST_ITEM_ROLE_DESCRIPTION_MENUITEM")};r.openStart("li",this);if(!n){if(this.getEnabled()){r.attr('tabindex','-1');}t=this.getTooltip_AsString()||this.getText();if(t){r.attr("title",t);}if(k>0){if(this.getEnabled()){r.class("sapTnTNavLINotExpandedTriangle");}o.haspopup="tree";}if(g._selectedItem===this){o.checked=true;}r.accessibilityState(o);}else{r.attr('aria-hidden','true');}r.openEnd();this.renderGroupItem(r,g);if(n){r.openStart('ul');r.attr('aria-hidden','true');r.attr('role','group');r.class("sapTntNavLIGroupItems");if(!m){r.class("sapTntNavLIHiddenGroupItems");}r.openEnd();for(var i=0;i<k;i++){h=j[i];h.render(r,g,i,k);}r.close("ul");}r.close("li");};f.prototype.renderSecondLevelNavItem=function(r,g){var h=this.getParent(),i=this.getHref(),t=this.getTarget(),j={role:'treeitem',level:'2',selected:false,roledescription:this._resourceBundleTNTLib.getText("NAVIGATION_LIST_ITEM_ROLE_DESCRIPTION_TREE_ITEM")};r.openStart('li',this);r.class("sapTntNavLIItem");r.class("sapTntNavLIGroupItem");if(g._selectedItem===this){j.selected=true;r.class("sapTntNavLIItemSelected");}if(!this.getEnabled()||!h.getEnabled()){r.class("sapTntNavLIItemDisabled");}else{r.attr('tabindex','-1');}var k=this.getText();var m=this.getTooltip_AsString()||k;if(m){r.attr("title",m);}r.accessibilityState(j);r.openEnd();r.openStart('a',this.getId()+'-a');r.attr('tabindex','-1');if(i){r.attr('href',i);}if(t){r.attr('target',t);}r.openEnd();this._renderText(r);r.close('a');r.close('li');};f.prototype._renderIcon=function(r){var i=this.getIcon(),g=c.getIconInfo(i);if(i){r.openStart('span');r.class("sapUiIcon");r.class("sapTntNavLIGroupIcon");r.attr("aria-hidden",true);if(g&&!g.suppressMirroring){r.class("sapUiIconMirrorInRTL");}if(g){r.attr("data-sap-ui-icon-content",g.content);r.style("font-family","'"+g.fontFamily+"'");}r.openEnd();r.close('span');}else{r.openStart('span');r.class('sapUiIcon');r.class('sapTntNavLIGroupIcon');r.attr('aria-hidden',true);r.openEnd();r.close('span');}};f.prototype._renderText=function(r){r.openStart('span');r.class("sapMText");r.class("sapTntNavLIText");r.class("sapMTextNoWrap");var t=this.getTextDirection();if(t!==e.Inherit){r.attr("dir",t.toLowerCase());}var g=R.getTextAlign(T.Begin,t);if(g){r.style("text-align",g);}r.openEnd();r.text(this.getText());r.close('span');};f.prototype._unselect=function(){var $=this.$(),n=this.getNavigationList();if(!n){return;}if(this._isListExpanded()){if(this.getLevel()===0){$=$.find('.sapTntNavLIGroup');}$.attr('aria-selected',false);}else{$.attr('aria-checked',false);$=$.find('.sapTntNavLIGroup');if(this.getParent().isA("sap.tnt.NavigationListItem")){this.getParent().$().find('.sapTntNavLIGroup').removeClass('sapTntNavLIItemSelected');}}$.removeClass('sapTntNavLIItemSelected');};f.prototype._select=function(){var $=this.$(),n=this.getNavigationList();if(!n){return;}if(this._isListExpanded()){if(this.getLevel()===0){$=$.find('.sapTntNavLIGroup');}$.attr('aria-selected',true);}else{$.attr('aria-checked',true);$=$.find('.sapTntNavLIGroup');if(this.getParent().isA("sap.tnt.NavigationListItem")){this.getParent().$().find('.sapTntNavLIGroup').addClass('sapTntNavLIItemSelected');}n._closePopover();}$.addClass('sapTntNavLIItemSelected');};f.prototype._getDomRefs=function(){var g=[];if(!this.getEnabled()){return g;}var $=this.$();g.push($.find('.sapTntNavLIGroup')[0]);if(this.getExpanded()){var s=$.find('.sapTntNavLIGroupItem');for(var i=0;i<s.length;i++){g.push(s[i]);}}return g;};f.prototype._getVisibleItems=function(g){var v=[];var i=g.getItems();var h;for(var j=0;j<i.length;j++){h=i[j];if(h.getVisible()){v.push(h);}}return v;};f.prototype.onclick=function(g){if(this.getHref()){g.preventDefault();}};f.prototype.onmousedown=function(g){if(this.getHref()){g.preventDefault();}};f.prototype.onfocusin=function(g){if(g.srcControl!==this){return;}this._updateAccessibilityText();};f.prototype._updateAccessibilityText=function(){var i=f._getInvisibleText(),n=this.getNavigationList(),g=this._resourceBundleMLib,h=n.getExpanded()?g.getText("ACC_CTR_TYPE_TREEITEM"):'',$=this._getAccessibilityItem(),p=this._getAccessibilityPosition(),j=g.getText("LIST_ITEM_POSITION",[p.index,p.size]),s=n._selectedItem===this?g.getText("LIST_ITEM_SELECTED"):'',k=n.getExpanded()?this.getText():"",t=h+" "+j+" "+s+" "+k;i.setText(t);$.addAriaLabelledBy(i.getId());};f.prototype._getAccessibilityPosition=function(){var p=this.getParent(),v=this._getVisibleItems(p),s=v.length,i=v.indexOf(this)+1;return{index:i,size:s};};f.prototype._getAccessibilityItem=function(){var $=this.$(),n=this.getNavigationList(),i=n.getExpanded();if(i&&this.getLevel()===0){$=$.find('.sapTntNavLIGroup');}return $;};f.prototype._hasSelectedChild=function(s){var g=this.getItems(),i;for(i=0;i<g.length;i++){if(g[i]===s){return true;}}return false;};return f;});
