/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/thirdparty/jquery','./library','sap/ui/core/CustomStyleClassSupport','sap/ui/core/Element','./Tree'],function(q,l,C,E,T){"use strict";var a=l.TreeSelectionMode;var b=E.extend("sap.ui.commons.TreeNode",{metadata:{library:"sap.ui.commons",properties:{text:{type:"string",group:"Misc",defaultValue:null},expanded:{type:"boolean",group:"Misc",defaultValue:true},hasExpander:{type:"boolean",group:"Misc",defaultValue:false},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},isSelected:{type:"boolean",group:"Misc",defaultValue:false},selectable:{type:"boolean",group:"Misc",defaultValue:true}},defaultAggregation:"nodes",aggregations:{nodes:{type:"sap.ui.commons.TreeNode",multiple:true,singularName:"node"}},associations:{selectedForNodes:{type:"sap.ui.commons.TreeNode",multiple:true,singularName:"selectedForNode",visibility:"hidden"},ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{toggleOpenState:{parameters:{opened:{type:"boolean"}}},selected:{}}}});b.prototype.getSelectedForNodes=function(){return this.getAssociation("selectedForNodes",[]);};b.ANIMATION_DURATION=600;C.apply(b.prototype);b.prototype.expand=function(d,D){this.setProperty("expanded",true,true);var f=null;if(!D){f=e.bind(this);}var o=this.$();if(o.hasClass("sapUiTreeNodeCollapsed")){o.toggleClass("sapUiTreeNodeCollapsed");o.toggleClass("sapUiTreeNodeExpanded");o.attr("aria-expanded","true");var g=this.$("children");if(g){if(d){g.show();}else{g.stop(true,true);g.show(b.ANIMATION_DURATION,f);}g.css({display:'block'});}this.fireToggleOpenState({opened:true});}if(d){var n=this._getNodes();for(var i=0;i<n.length;i++){n[i].expand(d,true);}f&&f();}};b.prototype.collapse=function(d,D){this.setProperty("expanded",false,true);var f=null;if(!D){f=c.bind(this);}var o=this.$();if(o.hasClass("sapUiTreeNodeExpanded")){o.toggleClass("sapUiTreeNodeCollapsed");o.toggleClass("sapUiTreeNodeExpanded");o.attr("aria-expanded","false");var g=this.$("children");if(g){if(d){g.hide();}else{g.stop(true,true);g.hide(b.ANIMATION_DURATION,f);}}this.fireToggleOpenState({opened:false});}if(d){var n=this._getNodes();for(var i=0;i<n.length;i++){n[i].collapse(d,true);}f&&f();}};b.prototype.select=function(s){var t=this.getTree();if(t){t.setSelection(this,s);}else{this._select();}};function e(){var t=this.getTree();if(t){t._adjustSelectionOnExpanding(this);}}function c(){var t=this.getTree();if(t){t._adjustSelectionOnCollapsing(this);t._adjustFocus();}}b.prototype._select=function(s){this.setProperty("isSelected",true,true);if(!s){this.fireSelected();}if(this.getDomRef()){this.$().closest(".sapUiTreeNode").addClass("sapUiTreeNodeSelected").attr("aria-selected","true");this.scrollIntoView();}};b.prototype._deselect=function(s){this.setProperty("isSelected",false,true);if(this.getDomRef()){this.$().removeClass("sapUiTreeNodeSelected").removeAttr("aria-selected");}};b.prototype._getNodes=function(){return this.mAggregations.nodes||[];};b.prototype.hasSelectedHiddenChild=function(){var n=this._getNodes();for(var i=0;i<n.length;i++){if((!n[i].isVisible()&&n[i].getIsSelected())||n[i].hasSelectedHiddenChild()){return true;}}return false;};b.prototype.setIsSelected=function(i){var t=this.getTree();if(!this.getSelectable()){return this;}if(i==this.getProperty("isSelected")){return this;}if(t){t._setNodeSelection(this,i,true);}else{this.setProperty("isSelected",i,true);}return this;};b.prototype.setSelectable=function(s){if(!s&&this.getIsSelected()){this.setIsSelected(false);}this.setProperty("selectable",s);return this;};b.prototype.onclick=function(o){var d=o.target,t=this.getTree();if(q(d).is(".sapUiTreeNode")||q(d).is(".sapUiTreeNodeNotSelectable")){if(q(d).is(".sapUiTreeNodeNotSelectable")){d=q(d).closest(".sapUiTreeNode")[0];}if(q(d).hasClass("sapUiTreeNodeExpanded")){this.collapse();}else{this.expand();}t.placeFocus(d);d.focus();}else if(q(d).is(".sapUiTreeNodeContent")||q(d).is(".sapUiTreeIcon")){var s=T.SelectionType.Select;if(t.getSelectionMode()==a.Multi){if(o.shiftKey){s=T.SelectionType.Range;}if(o.metaKey||o.ctrlKey){s=T.SelectionType.Toggle;}}t.setSelection(this,false,s);d=q(d).closest(".sapUiTreeNode")[0];t.placeFocus(d);d.focus();}};b.prototype.onsapselect=function(o){if(this.getSelectable()){this.getTree().setSelection(this);}else if(this.getExpanded()){this.collapse();}else{this.expand();}};b.prototype.onsapexpand=function(o){this.expand();};b.prototype.onsapcollapse=function(o){this.collapse();};b.prototype.onsapleft=function(o){if(sap.ui.getCore().getConfiguration().getRTL()){this.expand();}else{this.collapse();}o.preventDefault();};b.prototype.onsapright=function(o){if(sap.ui.getCore().getConfiguration().getRTL()){this.collapse();}else{this.expand();}o.preventDefault();};b.prototype.focus=function(){var d=this.getFocusDomRef();if(d){d.setAttribute("tabindex","0");d.focus();}};b.prototype.blur=function(){var d=this.getFocusDomRef();if(d){d.setAttribute("tabindex","-1");}};b.prototype.getTree=function(){var p=this.getParent();while(p instanceof b){p=p.getParent();}return p;};b.prototype.hasChildren=function(){var s=this._getNodes();if(s.length){return true;}return false;};b.prototype.isVisible=function(){var p=this.getParent();while(p instanceof b){if(!p.getExpanded()){return false;}p=p.getParent();}return true;};b.prototype.scrollIntoView=function(){var n=this.$(),t=this.getTree().$(),$=t.find(".sapUiTreeCont"),o=n[0].offsetTop,s=$.scrollTop(),h=$.height(),N,O=n[0].offsetLeft,S=$.scrollLeft(),w=$.width(),i;if(o>s+h||o<s){N=o-Math.floor(h*0.5);N=Math.max(N,0);}if(O>S+w||O<S){i=O-Math.floor(w*0.5);i=Math.max(i,0);}if(N!==undefined||i!==undefined){var m={};if(N!==undefined){m.scrollTop=N;}if(i!==undefined){m.scrollLeft=i;}$.stop(true,true).animate(m);}};b.prototype.getTooltip_AsString=function(){var t;var o=this.getTooltip();if(typeof o==="string"||o instanceof String){t=o;}if(!t){t=this.getText();}return t;};return b;});
