/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/Device','sap/ui/Global','sap/ui/base/BindingParser','sap/ui/base/DataType','sap/ui/base/EventProvider','sap/ui/base/Interface','sap/ui/base/Object','sap/ui/base/ManagedObject','sap/ui/performance/trace/Interaction','./Component','./Configuration','./Control','./Element','./ElementMetadata','./FocusHandler','./RenderManager','./ResizeHandler','./ThemeCheck','./UIArea','./message/MessageManager',"sap/ui/util/ActivityDetection","sap/ui/dom/getScrollbarSize","sap/base/i18n/ResourceBundle","sap/base/Log","sap/ui/performance/Measurement","sap/ui/security/FrameOptions","sap/base/assert","sap/ui/dom/includeStylesheet","sap/base/util/ObjectPath","sap/base/util/Version","sap/base/util/array/uniqueSort","sap/base/util/uid",'sap/ui/performance/trace/initTraces','sap/base/util/LoaderExtensions','sap/base/util/isEmptyObject','sap/base/util/each','sap/ui/VersionInfo','sap/ui/events/jquery/EventSimulation'],function(q,D,G,B,a,E,I,c,M,d,C,f,g,h,j,F,R,k,T,U,n,A,r,s,L,t,u,w,x,O,V,y,z,H,J,K,N,P){"use strict";if(sap.ui.getCore&&sap.ui.getCore()){return sap.ui.getCore();}H();var Q=U._oRenderLog;var S={};var W={};var _;var X=function(b,e){var i=[],o=0,l=0;this.startTask=function(p){var v=i.length;i[v]={name:p,finished:false};o++;return v;};this.finishTask=function(p,v){if(!i[p]||i[p].finished){throw new Error("trying to finish non existing or already finished task");}i[p].finished=true;o--;if(v===false){l++;}if(o===0){L.info("Sync point '"+b+"' finished (tasks:"+i.length+", open:"+o+", failures:"+l+")");m();}};function m(){if(e){e(o,l);}e=null;}L.info("Sync point '"+b+"' created");};var Y=c.extend("sap.ui.core.Core",{constructor:function(){var b=this,e="sap.ui.core.Core";if(sap.ui.getCore&&sap.ui.getCore()){L.error("Only the framework must create an instance of sap/ui/core/Core."+" To get access to its functionality, use sap.ui.getCore().");return sap.ui.getCore();}c.call(this);_=new E();["attachEvent","detachEvent","getEventingParent"].forEach(function(v){Y.prototype[v]=_[v].bind(_);});this.bBooted=false;this.bInitialized=false;this.bDomReady=false;this.aPlugins=[];this.mLibraries={};this.mResourceBundles={};this.mUIAreas={};this.oModels={};this.oEventBus=null;Object.defineProperty(this,"mElements",{get:function(){L.error("oCore.mElements was a private member and has been removed. Use one of the methods in sap.ui.core.Element.registry instead");return h.registry.all();},configurable:false});this.mObjects={"template":{}};this.oRootComponent=null;this.aInitListeners=[];this.bInitLegacyLib=false;this._sRerenderTimer=this;this.aPrerenderingTasks=[];L.info("Creating Core",null,e);t.start("coreComplete","Core.js - complete");t.start("coreBoot","Core.js - boot");t.start("coreInit","Core.js - init");this.oConfiguration=new f(this);var o=this.oConfiguration["frameOptionsConfig"]||{};o.mode=this.oConfiguration.getFrameOptions();o.whitelistService=this.oConfiguration.getWhitelistService();this.oFrameOptions=new u(o);if(this.oConfiguration["bindingSyntax"]==="complex"){M.bindingParser=B.complexParser;}if(this.oConfiguration["xx-designMode"]==true){B._keepBindingStrings=true;}this._grantFriendAccess();var m=this.oConfiguration.modules;if(this.oConfiguration.getDebug()){m.unshift("sap.ui.debug.DebugEnv");}var i=m.indexOf("sap.ui.core.library");if(i!=0){if(i>0){m.splice(i,1);}m.unshift("sap.ui.core.library");}if(this.oConfiguration["xx-lesssupport"]&&m.indexOf("sap.ui.core.plugin.LessSupport")==-1){L.info("Including LessSupport into declared modules");m.push("sap.ui.core.plugin.LessSupport");}var p=this.oConfiguration.preload;if(window["sap-ui-debug"]===true){p="";}if(p==="auto"){if(window["sap-ui-optimized"]){p=sap.ui.loader.config().async?"async":"sync";}else{p="";}}this.oConfiguration.preload=p;var l=p==="async"||sap.ui.loader.config().async;this.oConfiguration['xx-libraryPreloadFiles'].forEach(function(v){var J1=String(v).trim().split(/\s*:\s*/),K1=J1[0],L1=J1[1];if(J1.length===1){L1=K1;K1='';}if(/^(?:none|js|json|both)$/.test(L1)){$[K1]=L1;}});L.info("Declared modules: "+m,e);this._setupThemes();this._setupContentDirection();this._setupBrowser();this._setupOS();this._setupLang();this._setupAnimation();sap.ui.getCore=function(){return b.getInterface();};this.oRenderManager=new R();var o1=new X("UI5 Document Ready",function(v,J1){b.bDomReady=true;b.init();});var p1=o1.startTask("document.ready");var q1=o1.startTask("preload and boot");var r1=function(){L.trace("document is ready");o1.finishTask(p1);document.removeEventListener("DOMContentLoaded",r1);};if(document.readyState!=="loading"){r1();}else{document.addEventListener("DOMContentLoaded",r1);}var s1=new X("UI5 Core Preloads and Bootstrap Script",function(v,J1){L.trace("Core loaded: open="+v+", failures="+J1);b._boot(l,function(){o1.finishTask(q1);t.end("coreBoot");});});var t1=s1.startTask("create sp2 tasks task");if(this.oConfiguration["versionedLibCss"]){var u1=s1.startTask("load version info");var v1=function(v){if(v){L.trace("Loaded \"sap-ui-version.json\".");}else{L.error("Could not load \"sap-ui-version.json\".");}s1.finishTask(u1);};var w1=sap.ui.getVersionInfo({async:l,failOnError:false});if(w1 instanceof Promise){w1.then(v1,function(v){L.error("Unexpected error when loading \"sap-ui-version.json\": "+v);s1.finishTask(u1);});}else{v1(w1);}}var x1=this.oConfiguration["xx-bootTask"];if(x1){var y1=s1.startTask("custom boot task");x1(function(v){s1.finishTask(y1,typeof v==="undefined"||v===true);});}this._polyfillFlexbox();var z1=s1.startTask("bootstrap script");this.boot=function(){if(this.bBooted){return;}this.bBooted=true;s1.finishTask(z1);};if(p==="sync"||p==="async"){var A1=m.reduce(function(v,J1){var K1=J1.search(/\.library$/);if(K1>=0){v.push(J1.slice(0,K1));}return v;},[]);var B1=this.loadLibraries(A1,{async:l,preloadOnly:true});if(l){var C1=s1.startTask("preload bootstrap libraries");B1.then(function(){s1.finishTask(C1);},function(){s1.finishTask(C1,false);});}}var D1=this.oConfiguration.getAppCacheBuster();if(D1&&D1.length>0){var E1=sap.ui.requireSync('sap/ui/core/AppCacheBuster');E1.boot(s1);}if(this.oConfiguration.getSupportMode()!==null){var F1=s1.startTask("support info script");var G1=function(v,J1){v.initializeSupportMode(b.oConfiguration.getSupportMode(),l);J1.initSupportRules(b.oConfiguration.getSupportMode());s1.finishTask(F1);};if(l){sap.ui.require(["sap/ui/core/support/Support","sap/ui/support/Bootstrap"],G1,function(v){L.error("Could not load support mode modules:",v);});}else{L.warning("Synchronous loading of Support mode. Set preload configuration to 'async' or switch to asynchronous bootstrap to prevent these synchronous request.","SyncXHR",null,function(){return{type:"SyncXHR",name:"support-mode"};});G1(sap.ui.requireSync("sap/ui/core/support/Support"),sap.ui.requireSync("sap/ui/support/Bootstrap"));}}if(this.oConfiguration.getTestRecorderMode()!==null){var H1=s1.startTask("test recorder script");var I1=function(v){v.init(b.oConfiguration.getTestRecorderMode());s1.finishTask(H1);};if(l){sap.ui.require(["sap/ui/testrecorder/Bootstrap"],I1,function(v){L.error("Could not load test recorder:",v);});}else{L.warning("Synchronous loading of Test recorder mode. Set preload configuration to 'async' or switch to asynchronous bootstrap to prevent these synchronous request.","SyncXHR",null,function(){return{type:"SyncXHR",name:"test-recorder-mode"};});I1(sap.ui.requireSync("sap/ui/testrecorder/Bootstrap"));}}s1.finishTask(t1);},metadata:{publicMethods:["boot","isInitialized","isThemeApplied","attachInitEvent","attachInit","getRenderManager","createRenderManager","getConfiguration","setRoot","createUIArea","getUIArea","getUIDirty","getElementById","getCurrentFocusedControlId","getControl","getComponent","getTemplate","lock","unlock","isLocked","attachEvent","detachEvent","applyChanges","getEventBus","applyTheme","setThemeRoot","attachThemeChanged","detachThemeChanged","getStaticAreaRef","attachThemeScopingChanged","detachThemeScopingChanged","fireThemeScopingChanged","notifyContentDensityChanged","registerPlugin","unregisterPlugin","getLibraryResourceBundle","byId","getLoadedLibraries","loadLibrary","loadLibraries","initLibrary","includeLibraryTheme","setModel","getModel","hasModel","isMobile","attachControlEvent","detachControlEvent","attachIntervalTimer","detachIntervalTimer","attachParseError","detachParseError","fireParseError","attachValidationError","detachValidationError","fireValidationError","attachFormatError","detachFormatError","fireFormatError","attachValidationSuccess","detachValidationSuccess","fireValidationSuccess","attachLocalizationChanged","detachLocalizationChanged","attachLibraryChanged","detachLibraryChanged","isStaticAreaRef","createComponent","getRootComponent","getApplication","setMessageManager","getMessageManager","byFieldGroupId","addPrerenderingTask"]}});Y.M_EVENTS={ControlEvent:"ControlEvent",UIUpdated:"UIUpdated",ThemeChanged:"ThemeChanged",ThemeScopingChanged:"themeScopingChanged",LocalizationChanged:"localizationChanged",LibraryChanged:"libraryChanged",ValidationError:"validationError",ParseError:"parseError",FormatError:"formatError",ValidationSuccess:"validationSuccess"};var Z="sap-ui-static";Y.aFnDone=[];Y.prototype._grantFriendAccess=function(){var b=this;j.prototype.register=function(m){b.registerElementClass(m);};h._updateFocusInfo=function(e){if(b.oFocusHandler){b.oFocusHandler.updateControlFocusInfo(e);}};};Y.prototype._setupThemes=function(){var b="sap.ui.core.Core";var o=window["sap-ui-config"];if(this.oConfiguration.themeRoot){o=o||{};o.themeroots=o.themeroots||{};o.themeroots[this.oConfiguration.getTheme()]=this.oConfiguration.themeRoot;}if(o){if(o.themeroots){for(var e in o.themeroots){var i=o.themeroots[e];if(typeof i==="string"){this.setThemeRoot(e,i);}else{for(var l in i){if(l.length>0){this.setThemeRoot(e,[l],i[l]);}else{this.setThemeRoot(e,i[l]);}}}}}}this.sTheme=this.oConfiguration.getTheme();document.documentElement.classList.add("sapUiTheme-"+this.sTheme);L.info("Declared theme "+this.sTheme,null,b);};Y.prototype._setupContentDirection=function(){var b="sap.ui.core.Core",e=this.oConfiguration.getRTL()?"rtl":"ltr";document.documentElement.setAttribute("dir",e);L.info("Content direction set to '"+e+"'",null,b);};Y.prototype._setupBrowser=function(){var e="sap.ui.core.Core";var i=document.documentElement;var b=D.browser;var l=b.name;if(l){if(l===b.BROWSER.SAFARI&&b.mobile){l="m"+l;}l=l+(b.version===-1?"":Math.floor(b.version));i.dataset.sapUiBrowser=l;L.debug("Browser-Id: "+l,null,e);}};Y.prototype._setupOS=function(b){var b=document.documentElement;b.dataset.sapUiOs=D.os.name+D.os.versionStr;var o=null;switch(D.os.name){case D.os.OS.IOS:o="sap-ios";break;case D.os.OS.ANDROID:o="sap-android";break;case D.os.OS.BLACKBERRY:o="sap-bb";break;case D.os.OS.WINDOWS_PHONE:o="sap-winphone";break;}if(o){b.classList.add(o);}};Y.prototype._setupLang=function(){var b=document.documentElement;var e=function(){var l=this.oConfiguration.getLocale();l?b.setAttribute("lang",l.toString()):b.removeAttribute("lang");};e.call(this);this.attachLocalizationChanged(e,this);};Y.prototype._setupAnimation=function(){if(this.oConfiguration){var b=document.documentElement;var e=this.oConfiguration.getAnimation();b.dataset.sapUiAnimation=e?"on":"off";if(typeof q!=="undefined"){q.fx.off=!e;}var i=this.oConfiguration.getAnimationMode();b.dataset.sapUiAnimationMode=i;}};Y.prototype._polyfillFlexbox=function(){q.support.useFlexBoxPolyfill=false;};Y.prototype._boot=function(b,e){var i=this.oConfiguration['preloadLibCss'];if(i&&i.length>0&&!i.appManaged){this.includeLibraryTheme("sap-ui-merged",undefined,"?l="+i.join(","));}if(b){return this._requireModulesAsync().then(function(){e();});}L.warning("Modules and libraries declared via bootstrap-configuration are loaded synchronously. Set preload configuration to"+" 'async' or switch to asynchronous bootstrap to prevent these requests.","SyncXHR",null,function(){return{type:"SyncXHR",name:"legacy-module"};});this.oConfiguration.modules.forEach(function(l){var m=l.match(/^(.*)\.library$/);if(m){this.loadLibrary(m[1]);}else{sap.ui.requireSync(/^jquery\.sap\./.test(l)?l:l.replace(/\./g,"/"));}}.bind(this));e();};Y.prototype._requireModulesAsync=function(){var l=[],b=[];this.oConfiguration.modules.forEach(function(e){var m=e.match(/^(.*)\.library$/);if(m){l.push(m[1]);}else{b.push(/^jquery\.sap\./.test(e)?e:e.replace(/\./g,"/"));}});return Promise.all([this.loadLibraries(l),new Promise(function(e){sap.ui.require(b,function(){e(Array.prototype.slice.call(arguments));});})]);};Y.prototype.applyTheme=function(b,e){w(typeof b==="string","sThemeName must be a string");w(typeof e==="string"||typeof e==="undefined","sThemeBaseUrl must be a string or undefined");b=this.oConfiguration._normalizeTheme(b,e);if(e){this.setThemeRoot(b,e);}if(b&&this.sTheme!=b){var i=this.sTheme;var l=document.documentElement;this._updateThemeUrls(b,true);this.sTheme=b;this.oConfiguration._setTheme(b);l.classList.remove("sapUiTheme-"+i);l.classList.add("sapUiTheme-"+b);if(this.oThemeCheck){this.oThemeCheck.fireThemeChangedEvent(false);}}};Y.prototype._updateThemeUrl=function(l,b,e){var i,m=l.href.search(/[?#]/),o,p,v="library",o1=this.oConfiguration.getRTL()?"-RTL":"",p1,q1;var r1=/^sap-ui-theme(?:skeleton)?-(.*)$/i.exec(l.id);if(Array.isArray(r1)){i=r1[1];}else{i=l.id.slice(13);}if(m>-1){o=l.href.substring(0,m);p=l.href.substring(m);}else{o=l.href;p="";}o=o.substring(o.lastIndexOf("/")+1);if((q1=i.indexOf("-["))>0){v+=i.slice(q1+2,-1);i=i.slice(0,q1);}if(o===(v+".css")||o===(v+"-RTL.css")){o=v+o1+".css";}p1=this._getThemePath(i,b)+o+p;if(p1!=l.href){if(e){l.dataset.sapUiFoucmarker=l.id;}x(p1,l.id);}};Y.prototype._updateThemeUrls=function(b,e){var o=document.querySelectorAll("link[id^=sap-ui-theme-],link[id^=sap-ui-themeskeleton-]");Array.prototype.forEach.call(o,function(i){this._updateThemeUrl(i,b,e);}.bind(this));};Y.prototype._ensureThemeRoot=function(l,b){if(this._mThemeRoots){var p=this._mThemeRoots[b+" "+l]||this._mThemeRoots[b];if(p){p=p+l.replace(/\./g,"/")+"/themes/"+b+"/";l1(l+".themes."+b,p);}}};Y.prototype._getThemePath=function(l,b){this._ensureThemeRoot(l,b);return k1(l+".themes."+b,"/");};Y.prototype.setThemeRoot=function(b,l,e,m){w(typeof b==="string","sThemeName must be a string");w((Array.isArray(l)&&typeof e==="string")||(typeof l==="string"&&e===undefined),"either the second parameter must be a string (and the third is undefined), or it must be an array and the third parameter is a string");if(!this._mThemeRoots){this._mThemeRoots={};}if(typeof l==="string"){m=e;e=l;l=undefined;}e=e+(e.slice(-1)=="/"?"":"/");if(l){for(var i=0;i<l.length;i++){var o=l[i];this._mThemeRoots[b+" "+o]=e;}}else{this._mThemeRoots[b]=e;}if(m&&b===this.sTheme){this._updateThemeUrls(this.sTheme);}return this;};Y.prototype.init=function(){if(this.bInitialized){return;}var b="sap.ui.core.Core.init()";this.boot();L.info("Initializing",null,b);this.oFocusHandler=new F(document.body,this);this.oRenderManager._setFocusHandler(this.oFocusHandler);this.oResizeHandler=new k(this);this.oThemeCheck=new T(this);L.info("Initialized",null,b);t.end("coreInit");L.info("Starting Plugins",null,b);this.startPlugins();L.info("Plugins started",null,b);this._createUIAreas();this._setBodyAccessibilityRole();this.oThemeCheck.fireThemeChangedEvent(true);var e=this.oConfiguration['xx-waitForTheme'];if(this.isThemeApplied()||!e){Y.aFnDone.push(d.notifyAsyncStep());this._executeInitialization();this.renderPendingUIUpdates("during Core init");t.end("coreComplete");}else if(e==="rendering"){Y.aFnDone.push(d.notifyAsyncStep());this._executeInitialization();Q.debug("delay initial rendering until theme has been loaded");_.attachEventOnce(Y.M_EVENTS.ThemeChanged,function(){setTimeout(this.renderPendingUIUpdates.bind(this,"after theme has been loaded"),D.browser.safari?50:0);},this);t.end("coreComplete");}else if(e==="init"){Q.debug("delay init event and initial rendering until theme has been loaded");Y.aFnDone.push(d.notifyAsyncStep());_.attachEventOnce(Y.M_EVENTS.ThemeChanged,function(){this._executeInitialization();setTimeout(this.renderPendingUIUpdates.bind(this,"after theme has been loaded"),D.browser.safari?50:0);t.end("coreComplete");},this);}};Y.prototype._createUIAreas=function(){var o=this.oConfiguration;if(o.areas){for(var i=0,l=o.areas.length;i<l;i++){this.createUIArea(o.areas[i]);}o.areas=undefined;}};Y.prototype._executeOnInit=function(){var o=this.oConfiguration.onInit;if(o){if(typeof o==="function"){o();}else if(typeof o==="string"){var b=/^module\:((?:[_$.\-a-zA-Z0-9]+\/)*[_$.\-a-zA-Z0-9]+)$/.exec(o);if(b&&b[1]){setTimeout(sap.ui.require.bind(sap.ui,[b[1]]),0);}else{var e=O.get(o);if(typeof e==="function"){e();}else{L.warning("[Deprecated] Do not use inline JavaScript code with the oninit attribute."+" Use the module:... syntax or the name of a global function");window.eval(o);}}}this.oConfiguration.onInit=undefined;}};Y.prototype._setupRootComponent=function(){var b="sap.ui.core.Core.init()",o=this.oConfiguration;var e=o.getRootComponent();if(e){L.info("Loading Root Component: "+e,null,b);var i=sap.ui.component({name:e});this.oRootComponent=i;var l=o["xx-rootComponentNode"];if(l&&i.isA('sap.ui.core.UIComponent')){var m=document.getElementById(l);if(m){L.info("Creating ComponentContainer for Root Component: "+e,null,b);var p=sap.ui.requireSync('sap/ui/core/ComponentContainer'),v=new p({component:i,propagateModel:true});v.placeAt(m);}}}else{var o1=o.getApplication();if(o1){L.warning("The configuration 'application' is deprecated. Please use the configuration 'component' instead! "+"Please migrate from sap.ui.app.Application to sap.ui.core.Component.","SyncXHR",null,function(){return{type:"Deprecation",name:"sap.ui.core"};});L.info("Loading Application: "+o1,null,b);sap.ui.requireSync(o1.replace(/\./g,"/"));var p1=O.get(o1);w(p1!==undefined,"The specified application \""+o1+"\" could not be found!");var q1=new p1();w(c.isA(q1,'sap.ui.app.Application'),"The specified application \""+o1+"\" must be an instance of sap.ui.app.Application!");}}};Y.prototype._setBodyAccessibilityRole=function(){var o=this.oConfiguration,b=document.body;if(o.getAccessibility()&&o.getAutoAriaBodyRole()&&!b.getAttribute("role")){b.setAttribute("role","application");}};Y.prototype._executeInitListeners=function(){var b="sap.ui.core.Core.init()";var e=this.aInitListeners;this.aInitListeners=undefined;if(e&&e.length>0){L.info("Fire Loaded Event",null,b);e.forEach(function(i){i();});}};Y.prototype._executeInitialization=function(){if(this.bInitialized){return;}this.bInitialized=true;this._executeOnInit();this._setupRootComponent();this._executeInitListeners();};Y.prototype.isInitialized=function(){return this.bInitialized;};Y.prototype.isThemeApplied=function(){return T.themeLoaded;};Y.prototype.attachInitEvent=function(b){w(typeof b==="function","fnFunction must be a function");if(this.aInitListeners){this.aInitListeners.push(b);}};Y.prototype.attachInit=function(b){w(typeof b==="function","fnFunction must be a function");if(this.aInitListeners){this.aInitListeners.push(b);}else{b();}};Y.prototype.lock=function(){this.bLocked=true;};Y.prototype.unlock=function(){this.bLocked=false;};Y.prototype.isLocked=function(){return this.bLocked;};Y.prototype.getConfiguration=function(){return this.oConfiguration;};Y.prototype.getRenderManager=function(){return this.createRenderManager();};Y.prototype.createRenderManager=function(){w(this.isInitialized(),"A RenderManager should be created only after the Core has been initialized");var o=new R();o._setFocusHandler(this.oFocusHandler);return o.getInterface();};Y.prototype.getCurrentFocusedControlId=function(){if(!this.isInitialized()){throw new Error("Core must be initialized");}return this.oFocusHandler.getCurrentFocusedControlId();};var $={};function a1(l){w(typeof l==='string'&&l||typeof l==='object'&&typeof l.name==='string'&&l.name&&(l.json==null||typeof l.json==='boolean'),"lib must be a non-empty string or an object with at least a non-empty 'name' property and an optional (boolean) property 'json'");var b='both';if(typeof l==='object'){if(l.json===true){b='json';}else if(l.json===false){b='js';}l=l.name;}var e=$[l]||$['']||'both';if(e==='both'){e=b;}else if(e!==b&&b!=='both'){e='none';}return{name:l,fileType:e};}function b1(l){var b=this;l=a1(l);var i=l.name,m=l.fileType,o=i.replace(/\./g,'/'),v=this.oConfiguration.getDepCache();if(m==='none'||!!sap.ui.loader._.getModuleState(o+'/library.js')){return Promise.resolve(true);}var o1=W[i]||(W[i]={});if(o1.promise){return o1.promise;}o1.pending=true;o1.async=true;var p;if(m!=='json'){var p1=o+(v?'/library-h2-preload.js':'/library-preload.js');p=sap.ui.loader._.loadJSResourceAsync(p1).then(function(){return e1(i);},function(e){if(m!=='js'){L.error("failed to load '"+p1+"' ("+(e&&e.message||e)+"), falling back to library-preload.json");return h1(i);}});}else{p=h1(i);}o1.promise=p.then(function(e){var q1=[],r1=d1(i);if(e&&e.length){e=P._getTransitiveDependencyForLibraries(e);q1=e.map(b1.bind(b));}if(r1&&V(r1._version).compareTo("1.9.0")>=0){q1.push(b.getLibraryResourceBundle(i,true));}return Promise.all(q1).then(function(){o1.pending=false;});});return o1.promise;}var c1=new Map();function d1(l){if(c1.has(l)){return c1.get(l);}var m=l.replace(/\./g,'/')+'/manifest.json';if(sap.ui.loader._.getModuleState(m)){var o=J.loadResource(m,{dataType:'json',async:false,failOnError:false});c1.set(l,o);return o;}}function e1(l){var m=d1(l);var b=m&&m["sap.ui5"]&&m["sap.ui5"].dependencies&&m["sap.ui5"].dependencies.libs;if(b){return Object.keys(b).reduce(function(e,i){if(!b[i].lazy){e.push(i);}return e;},[]);}}function f1(o,b){var m=o.modules,e=function(i){return/^jquery\.sap\./.test(i)?i:i.replace(/\./g,"/");};if(V(o.version||"1.0").compareTo("2.0")<0){m={};for(var i in o.modules){m[e(i)+".js"]=o.modules[i];}}sap.ui.require.preload(m,o.name,b);}function g1(b){if(Array.isArray(b)){return b.map(function(e){return e.replace(/\.library-preload$/,'');});}return b;}function h1(l){var b=k1(l,"/library-preload.json");return Promise.resolve(q.ajax({dataType:"json",url:b})).then(function(e){if(e){f1(e,b);return g1(e.dependencies);}},function(e,i,m){L.error("failed to load '"+b+"': "+(m||i));});}function i1(l){l=a1(l);var b=l.name,i=l.fileType,m=b.replace(/\./g,'/'),o=!!sap.ui.loader._.getModuleState(m+'/library.js');if(i==='none'||o){return;}var p=W[b]||(W[b]={});if(p.pending===false){return;}if(p.pending){if(p.async){L.warning("request to load "+b+" synchronously while async loading is pending; this causes a duplicate request and should be avoided by caller");}else{L.warning("request to load "+b+" synchronously while sync loading is pending (cycle, ignored)");return;}}p.pending=true;p.async=false;var v;p.promise=new Promise(function(q1,r1){v=q1;});var o1;if(i!=='json'){var p1=m+'/library-preload';try{sap.ui.requireSync(p1);o1=e1(b);}catch(e){L.error("failed to load '"+p1+"' ("+(e&&e.message||e)+")");if(e&&e.loadError&&i!=='js'){o1=j1(b);}}}else{o1=j1(b);}if(o1&&o1.length){o1.forEach(i1);}p.pending=false;v();}function j1(l){var b=k1(l,"/library-preload.json");var e;q.ajax({dataType:"json",async:false,url:b,success:function(i){if(i){f1(i,b);e=i.dependencies;}},error:function(i,m,o){L.error("failed to load '"+b+"': "+(o||m));}});return g1(e);}function k1(m,b){return sap.ui.require.toUrl(m.replace(/\./g,"/")+b);}function l1(m,b){J.registerResourcePath(m.replace(/\./g,"/"),b);}Y.prototype.loadLibrary=function(l,v){w(typeof l==="string","sLibrary must be a string");w(v===undefined||typeof v==='boolean'||typeof v==='string'||typeof v==='object'&&(v.url==null||typeof v.url==='string')&&(v.async==null||typeof v.async==='boolean'),"vUrl must be empty or a string or an object with an optional property 'url' of type string and an optional boolean property 'async'");if(typeof v==='boolean'){v={async:v};}if(typeof v==='object'){if(v.async){if(v.url&&W[l]==null){l1(l,v.url);}return this.loadLibraries([l]);}v=v.url;}if(!S[l]){var m=l+".library";if(v){l1(l,v);}if(this.oConfiguration.preload==='sync'||this.oConfiguration.preload==='async'){i1(l);}sap.ui.requireSync(m.replace(/\./g,"/"));if(!S[l]){L.warning("library "+l+" didn't initialize itself");this.initLibrary(l);}}return this.mLibraries[l];};Y.prototype.loadLibraries=function(l,o){w(Array.isArray(l),"aLibraries must be an array");o=Object.assign({async:true,preloadOnly:false},o);var p=this.oConfiguration.preload==='sync'||this.oConfiguration.preload==='async',b=o.async,e=!o.preloadOnly;function i(){return l.map(function(p1){if(typeof p1==='object'){p1=p1.name;}return p1.replace(/\./g,"/")+"/library";});}function m(){return new Promise(function(p1,q1){sap.ui.require(i(),function(){p1();},q1);});}function v(){i().forEach(sap.ui.requireSync);}if(b){l=P._getTransitiveDependencyForLibraries(l);var o1=p?Promise.all(l.map(b1.bind(this))):Promise.resolve(true);return e?o1.then(m):o1;}else{if(p){l.forEach(i1);}if(e){v();}}};Y.prototype.createComponent=function(v,b,i,m){if(typeof v==="string"){v={name:v,url:b};if(typeof i==="object"){v.settings=i;}else{v.id=i;v.settings=m;}}if(v.async&&(v.manifest!==undefined||(v.manifestFirst===undefined&&v.manifestUrl===undefined))){if(v.manifest===undefined){v.manifest=false;}return C.create(v);}return sap.ui.component(v);};Y.prototype.getRootComponent=function(){return this.oRootComponent;};Y.prototype.initLibrary=function(l){w(typeof l==='string'||typeof l==='object',"oLibInfo must be a string or object");var b=typeof l==='string';if(b){l={name:l};}var e=l.name,m="sap.ui.core.Core.initLibrary()";if(b){L.error("[Deprecated] library "+e+" uses old fashioned initLibrary() call (rebuild with newest generator)");}if(!e||S[e]){return;}L.debug("Analyzing Library "+e,null,m);S[e]=true;function o(q1,r1){var s1,t1;for(s1 in r1){t1=r1[s1];if(t1!==undefined){if(Array.isArray(q1[s1])){if(q1[s1].length===0){q1[s1]=t1;}else{q1[s1]=y(q1[s1].concat(t1));}}else if(q1[s1]===undefined){q1[s1]=t1;}else if(s1!="name"){L.warning("library info setting ignored: "+s1+"="+t1);}}}return q1;}O.create(e);this.mLibraries[e]=l=o(this.mLibraries[e]||{name:e,dependencies:[],types:[],interfaces:[],controls:[],elements:[]},l);for(var i=0;i<l.dependencies.length;i++){var p=l.dependencies[i];L.debug("resolve Dependencies to "+p,null,m);if(S[p]!==true){L.warning("Dependency from "+e+" to "+p+" has not been resolved by library itself",null,m);this.loadLibrary(p);}}a.registerInterfaceTypes(l.interfaces);for(var i=0;i<l.types.length;i++){if(!/^(any|boolean|float|int|string|object|void)$/.test(l.types[i])){sap.ui.loader._.declareModule(l.types[i].replace(/\./g,"/")+".js");var v=l.types[i].substring(0,l.types[i].lastIndexOf("."));if(O.get(v)===undefined){O.create(v);}}}var o1=l.controls.concat(l.elements);for(var i=0;i<o1.length;i++){sap.ui.lazyRequire(o1[i],"new extend getMetadata");}if(!l.noLibraryCSS){this._ensureThemeRoot(e,this.sTheme);this._ensureThemeRoot(e,"base");if(this.oConfiguration['preloadLibCss'].indexOf(e)<0){var p1=this._getLibraryCssQueryParams(l);this.includeLibraryTheme(e,undefined,p1);if(this.oThemeCheck&&this.isInitialized()){this.oThemeCheck.fireThemeChangedEvent(false);}}}l.sName=l.name;l.aControls=l.controls;this.fireLibraryChanged({name:e,stereotype:"library",operation:"add",metadata:l});};function m1(l){var o=document.getElementById(l);if(o){o.dataset.sapUiFoucmarker=l;}}Y.prototype.includeLibraryTheme=function(l,v,b){w(typeof l==="string","sLibName must be a string");w(v===undefined||typeof v==="string","sVariant must be a string or undefined");if((l!="sap.ui.legacy")&&(l!="sap.ui.classic")){if(!v){v="";}var e=(/^(true|x)$/i.test(this.oConfiguration['xx-cssVariables'])?"_skeleton":"");var i=(this.oConfiguration.getRTL()?"-RTL":"");var m,o=l+(v.length>0?"-["+v+"]":v);if(l&&l.indexOf(":")==-1){m="library"+v+e+i;}else{m=l.substring(l.indexOf(":")+1)+v;l=l.substring(0,l.indexOf(":"));}var p="sap-ui-theme-"+o;m1(p);var o1;if(/^(true|x|additional)$/i.test(this.oConfiguration['xx-cssVariables'])){o1=this._getThemePath(l,this.sTheme)+"css_variables.css"+(b?b:"");L.info("Including "+o1+" -  sap.ui.core.Core.includeLibraryTheme()");x(o1,p);p="sap-ui-themeskeleton-"+o;m1(p);}o1=this._getThemePath(l,this.sTheme)+m+".css"+(b?b:"");L.info("Including "+o1+" -  sap.ui.core.Core.includeLibraryTheme()");x(o1,p);var p1=sap.ui.require("sap/ui/core/theming/Parameters");if(p1){p1._addLibraryTheme(o);}}};Y.prototype._getLibraryCssQueryParams=function(l){var b;if(this.oConfiguration["versionedLibCss"]&&l){b="?version="+l.version;if(G.versioninfo){b+="&sap-ui-dist-version="+G.versioninfo.version;}}return b;};Y.prototype.getLoadedLibraries=function(){return Object.assign({},this.mLibraries);};Y.prototype.getLibraryResourceBundle=function(l,b,e){var m,i,v,o;if(typeof l==="boolean"){e=l;l=undefined;b=undefined;}if(typeof b==="boolean"){e=b;b=undefined;}function p(o1){if(o1==null||o1===true){return{bundleUrl:"messagebundle.properties"};}if(typeof o1==="string"){return{bundleUrl:o1};}if(typeof o1==="object"){return o1;}}w((l===undefined&&b===undefined)||typeof l==="string","sLibraryName must be a string or there is no argument given at all");w(b===undefined||typeof b==="string","sLocale must be a string or omitted");l=l||"sap.ui.core";b=b||this.getConfiguration().getLanguage();i=l+"/"+b;v=this.mResourceBundles[i];if(!v||(!e&&v instanceof Promise)){m=d1(l);if(m&&V(m._version).compareTo("1.9.0")>=0){o=m["sap.ui5"]&&m["sap.ui5"].library&&m["sap.ui5"].library.i18n;}o=p(o);if(o){v=s.create({url:k1(l+"/",o.bundleUrl),supportedLocales:o.supportedLocales,fallbackLocale:o.fallbackLocale,locale:b,async:e});if(v instanceof Promise){v=v.then(function(o1){this.mResourceBundles[i]=o1;return o1;}.bind(this));}this.mResourceBundles[i]=v;}}return e?Promise.resolve(v):v;};Y.prototype.setRoot=function(o,b){w(typeof o==="string"||typeof o==="object","oDomRef must be a string or object");w(b instanceof I||b instanceof g,"oControl must be a Control or Interface");if(b){b.placeAt(o,"only");}};Y.prototype.createUIArea=function(o){var b=this;w(typeof o==="string"||typeof o==="object","oDomRef must be a string or object");if(!o){throw new Error("oDomRef must not be null");}if(typeof(o)==="string"){var i=o;if(i==Z){o=this.getStaticAreaRef();}else{o=document.getElementById(o);if(!o){throw new Error("DOM element with ID '"+i+"' not found in page, but application tries to insert content.");}}}if(!o.id||o.id.length==0){o.id=z();}var e=o.id;if(!this.mUIAreas[e]){this.mUIAreas[e]=new U(this,o);if(!K(this.oModels)){var p={oModels:Object.assign({},this.oModels),oBindingContexts:{},aPropagationListeners:[]};b.mUIAreas[e]._propagateProperties(true,b.mUIAreas[e],p,true);}}else{this.mUIAreas[e].setRootNode(o);}return this.mUIAreas[e];};Y.prototype.getUIArea=function(o){w(typeof o==="string"||typeof o==="object","o must be a string or object");var i="";if(typeof(o)=="string"){i=o;}else{i=o.id;}if(i){return this.mUIAreas[i];}return null;};Y.prototype.addInvalidatedUIArea=function(o){if(!this._sRerenderTimer){Q.debug("Registering timer for delayed re-rendering");Y.aFnDone.push(d.notifyAsyncStep());this._sRerenderTimer=setTimeout(this["renderPendingUIUpdates"].bind(this),0);}};Y.MAX_RENDERING_ITERATIONS=20;Y.prototype.renderPendingUIUpdates=function(b){Q.debug("Render pending UI updates: start ("+(b||"by timer")+")");t.start("renderPendingUIUpdates","Render pending UI updates in all UIAreas");var e=false,l=Y.MAX_RENDERING_ITERATIONS>0,i=0;this._bRendering=true;do{if(l){i++;if(i>Y.MAX_RENDERING_ITERATIONS){this._bRendering=false;throw new Error("Rendering has been re-started too many times ("+i+"). Add URL parameter sap-ui-xx-debugRendering=true for a detailed analysis.");}if(i>1){Q.debug("Render pending UI updates: iteration "+i);}}if(this._sRerenderTimer){if(this._sRerenderTimer!==this){clearTimeout(this._sRerenderTimer);}this._sRerenderTimer=undefined;if(Y.aFnDone.length>0){Y.aFnDone.pop()();}}this.runPrerenderingTasks();var m=this.mUIAreas;for(var o in m){e=m[o].rerender()||e;}}while(l&&this._sRerenderTimer);this._bRendering=false;if(e){this.fireUIUpdated();}Q.debug("Render pending UI updates: finished");t.end("renderPendingUIUpdates");};Y.prototype.getUIDirty=function(){return!!(this._sRerenderTimer||this._bRendering);};Y.prototype.attachUIUpdated=function(b,l){_.attachEvent(Y.M_EVENTS.UIUpdated,b,l);};Y.prototype.detachUIUpdated=function(b,l){_.detachEvent(Y.M_EVENTS.UIUpdated,b,l);};Y.prototype.fireUIUpdated=function(p){_.fireEvent(Y.M_EVENTS.UIUpdated,p);};Y.prototype.notifyContentDensityChanged=function(){this.fireThemeChanged();};Y.prototype.attachThemeChanged=function(b,l){_.attachEvent(Y.M_EVENTS.ThemeChanged,b,l);};Y.prototype.detachThemeChanged=function(b,l){_.detachEvent(Y.M_EVENTS.ThemeChanged,b,l);};Y.prototype.fireThemeChanged=function(p){r(true);var b=sap.ui.require("sap/ui/core/theming/Parameters");if(b){b.reset(true);}p=p||{};if(!p.theme){p.theme=this.getConfiguration().getTheme();}var e=Y.M_EVENTS.ThemeChanged;var o=q.Event(e);o.theme=p.theme;h.registry.forEach(function(i){i._handleEvent(o);});A.refresh();_.fireEvent(e,p);};Y.prototype.attachThemeScopingChanged=function(b,l){_.attachEvent(Y.M_EVENTS.ThemeScopingChanged,b,l);};Y.prototype.detachThemeScopingChanged=function(b,l){_.detachEvent(Y.M_EVENTS.ThemeScopingChanged,b,l);};Y.prototype.fireThemeScopingChanged=function(p){_.fireEvent(Y.M_EVENTS.ThemeScopingChanged,p);};Y.prototype.attachLocalizationChanged=function(b,l){_.attachEvent(Y.M_EVENTS.LocalizationChanged,b,l);};Y.prototype.detachLocalizationChanged=function(b,l){_.detachEvent(Y.M_EVENTS.LocalizationChanged,b,l);};Y.prototype.fireLocalizationChanged=function(m){var e=Y.M_EVENTS.LocalizationChanged,b=q.Event(e,{changes:m}),i=M._handleLocalizationChange;L.info("localization settings changed: "+Object.keys(m).join(","),null,"sap.ui.core.Core");N(this.oModels,function(p,o){if(o&&o._handleLocalizationChange){o._handleLocalizationChange();}});function l(p){N(this.mUIAreas,function(o,v){i.call(v,p);});C.registry.forEach(function(o){i.call(o,p);});h.registry.forEach(function(o){i.call(o,p);});}l.call(this,1);l.call(this,2);if(m.rtl!=undefined){document.documentElement.setAttribute("dir",m.rtl?"rtl":"ltr");this._updateThemeUrls(this.sTheme);N(this.mUIAreas,function(p,o){o.invalidate();});L.info("RTL mode "+m.rtl?"activated":"deactivated");}h.registry.forEach(function(o){o._handleEvent(b);});_.fireEvent(e,{changes:m});};Y.prototype.attachLibraryChanged=function(b,l){_.attachEvent(Y.M_EVENTS.LibraryChanged,b,l);};Y.prototype.detachLibraryChanged=function(b,l){_.detachEvent(Y.M_EVENTS.LibraryChanged,b,l);};Y.prototype.fireLibraryChanged=function(p){_.fireEvent(Y.M_EVENTS.LibraryChanged,p);};Y.prototype.applyChanges=function(){this.renderPendingUIUpdates("forced by applyChanges");};Y.prototype.registerElementClass=function(m){var b=m.getName(),l=m.getLibraryName()||"",o=this.mLibraries[l],e=g.prototype.isPrototypeOf(m.getClass().prototype)?'controls':'elements';if(!o){O.create(l);o=this.mLibraries[l]={name:l,dependencies:[],types:[],interfaces:[],controls:[],elements:[]};}if(o[e].indexOf(b)<0){o[e].push(b);L.debug("Class "+m.getName()+" registered for library "+m.getLibraryName());this.fireLibraryChanged({name:m.getName(),stereotype:m.getStereotype(),operation:"add",metadata:m});}};Y.prototype.registerObject=function(o){var i=o.getId(),b=o.getMetadata().getStereotype(),e=this.getObject(b,i);if(e&&e!==o){L.error("adding object \""+b+"\" with duplicate id '"+i+"'");throw new Error("Error: adding object \""+b+"\" with duplicate id '"+i+"'");}this.mObjects[b][i]=o;};Y.prototype.deregisterObject=function(o){var i=o.getId(),b=o.getMetadata().getStereotype();delete this.mObjects[b][i];};Y.prototype.byId=h.registry.get;Y.prototype.getControl=h.registry.get;Y.prototype.getElementById=h.registry.get;Y.prototype.getObject=function(b,i){w(i==null||typeof i==="string","sId must be a string when defined");w(this.mObjects[b]!==undefined,"sType must be a supported stereotype");return i==null?undefined:this.mObjects[b]&&this.mObjects[b][i];};Y.prototype.getComponent=C.registry.get;Y.prototype.getTemplate=function(i){L.warning("Synchronous loading of 'sap/ui/core/tmpl/Template'. Use 'sap/ui/core/tmpl/Template' module and"+" call Template.byId instead","SyncXHR",null,function(){return{type:"SyncXHR",name:"Core.prototype.getTemplate"};});var b=sap.ui.requireSync('sap/ui/core/tmpl/Template');return b.byId(i);};Y.prototype.getStaticAreaRef=function(){var o=document.getElementById(Z),b,e;if(!o){o=document.createElement("div");e=document.createElement("span");b=this.getConfiguration();if(!this.bDomReady){throw new Error("DOM is not ready yet. Static UIArea cannot be created.");}o.setAttribute("id",Z);Object.assign(o.style,{"height":"0","width":"0","overflow":"hidden","float":b.getRTL()?"right":"left"});e.setAttribute("id",Z+"-firstfe");e.setAttribute("tabindex",-1);e.style.fontSize=0;o.appendChild(e);document.body.insertBefore(o,document.body.firstChild);this.createUIArea(o).bInitial=false;}return o;};Y.prototype.isStaticAreaRef=function(o){return o&&(o.id===Z);};var n1;Y.prototype.attachIntervalTimer=function(b,l){if(!n1){n1=sap.ui.requireSync("sap/ui/core/IntervalTrigger");}n1.addListener(b,l);};Y.prototype.detachIntervalTimer=function(b,l){if(n1){n1.removeListener(b,l);}};Y.prototype.attachControlEvent=function(b,l){_.attachEvent(Y.M_EVENTS.ControlEvent,b,l);};Y.prototype.detachControlEvent=function(b,l){_.detachEvent(Y.M_EVENTS.ControlEvent,b,l);};Y.prototype.fireControlEvent=function(p){_.fireEvent(Y.M_EVENTS.ControlEvent,p);};Y.prototype._handleControlEvent=function(e,b){var o=q.Event(e.type);Object.assign(o,e);o.originalEvent=undefined;this.fireControlEvent({"browserEvent":o,"uiArea":b});};Y.prototype.getApplication=function(){return sap.ui.getApplication&&sap.ui.getApplication();};Y.prototype.registerPlugin=function(p){w(typeof p==="object","oPlugin must be an object");if(!p){return;}for(var i=0,l=this.aPlugins.length;i<l;i++){if(this.aPlugins[i]===p){return;}}this.aPlugins.push(p);if(this.bInitialized&&p&&p.startPlugin){p.startPlugin(this);}};Y.prototype.unregisterPlugin=function(p){w(typeof p==="object","oPlugin must be an object");if(!p){return;}var b=-1;for(var i=this.aPlugins.length;i--;i>=0){if(this.aPlugins[i]===p){b=i;break;}}if(b==-1){return;}if(this.bInitialized&&p&&p.stopPlugin){p.stopPlugin(this);}this.aPlugins.splice(b,1);};Y.prototype.startPlugins=function(){for(var i=0,l=this.aPlugins.length;i<l;i++){var p=this.aPlugins[i];if(p&&p.startPlugin){p.startPlugin(this,true);}}};Y.prototype.stopPlugins=function(){for(var i=0,l=this.aPlugins.length;i<l;i++){var p=this.aPlugins[i];if(p&&p.stopPlugin){p.stopPlugin(this);}}};Y.prototype.setModel=function(m,b){w(m==null||c.isA(m,'sap.ui.model.Model'),"oModel must be an instance of sap.ui.model.Model, null or undefined");w(b===undefined||(typeof b==="string"&&!/^(undefined|null)?$/.test(b)),"sName must be a string or omitted");var e=this,p;if(!m&&this.oModels[b]){delete this.oModels[b];if(K(e.oModels)&&K(e.oBindingContexts)){p=M._oEmptyPropagatedProperties;}else{p={oModels:Object.assign({},e.oModels),oBindingContexts:{},aPropagationListeners:[]};}N(this.mUIAreas,function(i,o){if(m!=o.getModel(b)){o._propagateProperties(b,o,p,false,b);}});}else if(m&&m!==this.oModels[b]){this.oModels[b]=m;N(this.mUIAreas,function(i,o){if(m!=o.getModel(b)){var p={oModels:Object.assign({},this.oModels),oBindingContexts:{},aPropagationListeners:[]};o._propagateProperties(b,o,p,false,b);}}.bind(this));}return this;};Y.prototype.setMessageManager=function(m){this.oMessageManager=m;};Y.prototype.getMessageManager=function(){if(!this.oMessageManager){this.oMessageManager=new n();}return this.oMessageManager;};Y.prototype.byFieldGroupId=function(v){return h.registry.filter(function(e){return e instanceof g&&e.checkFieldGroupIds(v);});};Y.prototype.getModel=function(b){w(b===undefined||(typeof b==="string"&&!/^(undefined|null)?$/.test(b)),"sName must be a string or omitted");return this.oModels[b];};Y.prototype.hasModel=function(){return!K(this.oModels);};Y.prototype.getEventBus=function(){if(!this.oEventBus){var b=sap.ui.require('sap/ui/core/EventBus');if(!b){L.warning("Synchronous loading of EventBus. Ensure that 'sap/ui/core/EventBus' module is loaded"+" before this function is called.","SyncXHR",null,function(){return{type:"SyncXHR",name:"core-eventbus"};});b=sap.ui.requireSync('sap/ui/core/EventBus');}var e=this.oEventBus=new b();this._preserveHandler=function(i){e.publish("sap.ui","__preserveContent",{domNode:i.domNode});};R.attachPreserveContent(this._preserveHandler);}return this.oEventBus;};Y.prototype.attachValidationError=function(o,b,l){if(typeof(o)==="function"){l=b;b=o;o=undefined;}_.attachEvent(Y.M_EVENTS.ValidationError,o,b,l);return this;};Y.prototype.detachValidationError=function(b,l){_.detachEvent(Y.M_EVENTS.ValidationError,b,l);return this;};Y.prototype.attachParseError=function(o,b,l){if(typeof(o)==="function"){l=b;b=o;o=undefined;}_.attachEvent(Y.M_EVENTS.ParseError,o,b,l);return this;};Y.prototype.detachParseError=function(b,l){_.detachEvent(Y.M_EVENTS.ParseError,b,l);return this;};Y.prototype.attachFormatError=function(o,b,l){if(typeof(o)==="function"){l=b;b=o;o=undefined;}_.attachEvent(Y.M_EVENTS.FormatError,o,b,l);return this;};Y.prototype.detachFormatError=function(b,l){_.detachEvent(Y.M_EVENTS.FormatError,b,l);return this;};Y.prototype.attachValidationSuccess=function(o,b,l){if(typeof(o)==="function"){l=b;b=o;o=undefined;}_.attachEvent(Y.M_EVENTS.ValidationSuccess,o,b,l);return this;};Y.prototype.detachValidationSuccess=function(b,l){_.detachEvent(Y.M_EVENTS.ValidationSuccess,b,l);return this;};Y.prototype.fireParseError=function(p){_.fireEvent(Y.M_EVENTS.ParseError,p);return this;};Y.prototype.fireValidationError=function(p){_.fireEvent(Y.M_EVENTS.ValidationError,p);return this;};Y.prototype.fireFormatError=function(p){_.fireEvent(Y.M_EVENTS.FormatError,p);return this;};Y.prototype.fireValidationSuccess=function(p){_.fireEvent(Y.M_EVENTS.ValidationSuccess,p);return this;};Y.prototype.isMobile=function(){return D.browser.mobile;};Y.prototype._getEventProvider=function(){return _;};Y.prototype.addPrerenderingTask=function(p,b){if(b){this.aPrerenderingTasks.unshift(p);}else{this.aPrerenderingTasks.push(p);}this.addInvalidatedUIArea();};Y.prototype.runPrerenderingTasks=function(){var b=this.aPrerenderingTasks.slice();this.aPrerenderingTasks=[];b.forEach(function(p){p();});};Y.prototype.destroy=function(){R.detachPreserveContent(this._preserveHandler);this.oFocusHandler.destroy();_.destroy();c.prototype.destroy.call(this);};sap.ui.setRoot=function(o,b){w(typeof o==="string"||typeof o==="object","oDomRef must be a string or object");w(b instanceof I||b instanceof g,"oControl must be a Control or Interface");sap.ui.getCore().setRoot(o,b);};return new Y().getInterface();});
