/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/Device','sap/ui/base/ManagedObject','sap/ui/base/Object','sap/ui/base/ObjectPool','./Control','./IntervalTrigger','./RenderManager','./Element','./ResizeHandler','./library',"sap/base/assert","sap/base/Log","sap/base/util/Version","sap/base/util/uid","sap/base/util/extend","sap/base/util/deepExtend","sap/ui/dom/containsOrEquals","sap/ui/thirdparty/jquery","sap/ui/events/F6Navigation","sap/ui/events/isMouseEventDelayed","sap/ui/base/EventProvider","sap/ui/dom/jquery/control","sap/ui/dom/jquery/Focusable","sap/ui/dom/jquery/rect"],function(D,M,B,O,C,I,R,E,a,b,c,L,V,u,d,f,g,q,F,h,k){"use strict";var m=b.CSSSize;var n=b.OpenState;var s;function o(){if(s){return s;}var S,i;try{S=sap.ui.getCore().getStaticAreaRef();s=sap.ui.getCore().getUIArea(S);}catch(e){L.error(e);throw new Error("Popup cannot be opened because static UIArea cannot be determined.");}i=new C();s.addDependent(i);s=i.getUIArea();i.destroy();return s;}var P=M.extend("sap.ui.core.Popup",{constructor:function(e,i,S,A){c(arguments.length==0||(e&&typeof e==="object"),"oContent must be an object or there may be no arguments at all");c((i===undefined||i===true||i===false),"bModal must be true, false, or undefined");c((S===undefined||S===true||S===false),"bShadow must be true, false, or undefined");c((A===undefined||A===true||A===false),"bAutoClose must be true, false, or undefined");M.apply(this);this._popupUID=u();this.bOpen=false;this.eOpenState=n.CLOSED;this._mEvents={};this._mEvents["sap.ui.core.Popup.addFocusableContent-"+this._popupUID]=this._addFocusableArea;this._mEvents["sap.ui.core.Popup.removeFocusableContent-"+this._popupUID]=this._removeFocusableArea;this._mEvents["sap.ui.core.Popup.closePopup-"+this._popupUID]=this._closePopup;this._mEvents["sap.ui.core.Popup.onFocusEvent-"+this._popupUID]=this.onFocusEvent;this._mEvents["sap.ui.core.Popup.increaseZIndex-"+this._popupUID]=this._increaseMyZIndex;this._mEvents["sap.ui.core.Popup.contains-"+this._popupUID]=this._containsEventBusWrapper;if(e){this.setContent(e);}this._oDefaultPosition={my:P.Dock.CenterCenter,at:P.Dock.CenterCenter,of:document,offset:"0 0",collision:"flip"};this._oPosition=Object.assign({},this._oDefaultPosition);this._bModal=!!i;this._oPreviousFocus=null;this._sInitialFocusId=null;this._bShadow=typeof(S)==="boolean"?S:true;this._bAutoClose=!!A;this._animations={open:null,close:null};this._durations={open:"fast",close:"fast"};this._iZIndex=-1;this._oBlindLayer=null;this.setNavigationMode();if(this.touchEnabled){this._fAutoCloseHandler=function(j){if(j.isMarked("delayedMouseEvent")||j.isMarked("cancelAutoClose")){return;}if(this.eOpenState===n.CLOSING||this.eOpenState===n.CLOSED){return;}if(!this._contains(j.target)){this.close();}};}this._F6NavigationHandler=function(j){var l={},v=this._sF6NavMode,w;if(v=="DOCK"){if(this._bModal){v="NONE";}else if(this._oLastPosition&&this._oLastPosition.of){w=this._getOfDom(this._oLastPosition.of);if(!w||w===document){w=null;v="NONE";}}}switch(v){case"SCOPE":l.scope=this._$()[0];break;case"DOCK":l.target=w;var $=q(w).parents("[data-sap-ui-popup]");l.scope=$.length?$[0]:null;break;default:l.skip=true;}F.handleF6GroupNavigation(j,l);};},metadata:{library:"sap.ui.core",publicMethods:["open","close","setContent","getContent","setPosition","setShadow","setModal","getModal","setAutoClose","setAutoCloseAreas","setExtraContent","isOpen","getAutoClose","getOpenState","setAnimations","setDurations","attachOpened","attachClosed","detachOpened","detachClosed"],associations:{"childPopups":{type:"sap.ui.core.Popup",multiple:true,visibility:"hidden"}},events:{"opened":{},"closed":{}}}});P.prototype.getChildPopups=function(){return this.getAssociation("childPopups",[]);};P.prototype.addChildPopup=function(v){return this.addAssociation("childPopups",v);};P.prototype.removeChildPopup=function(v){return this.removeAssociation("childPopups",v);};P._activateBlindLayer=true;P.blStack=[];P.Dock={BeginTop:"begin top",BeginCenter:"begin center",BeginBottom:"begin bottom",LeftTop:"left top",LeftCenter:"left center",LeftBottom:"left bottom",CenterTop:"center top",CenterCenter:"center center",CenterBottom:"center bottom",RightTop:"right top",RightCenter:"right center",RightBottom:"right bottom",EndTop:"end top",EndCenter:"end center",EndBottom:"end bottom"};P.prototype.touchEnabled=D.support.touch&&(D.browser.safari||!D.system.combi);P.prototype.preventBrowserFocus=D.support.touch&&!D.system.combi;B.extend("sap.ui.core.Popup.Layer",{constructor:function(){var e=this.getDomString();this._$Ref=q(e).appendTo(sap.ui.getCore().getStaticAreaRef());}});P.Layer.prototype.init=function(e,z){this._$Ref.css({"visibility":"visible","z-index":z});this.update(e,z);this._$Ref.insertAfter(e).show();};P.Layer.prototype.update=function(e,z){if(e.length){var i=e.rect();this._$Ref.css({"left":i.left,"top":i.top});if(e.css("right")!="auto"&&e.css("right")!="inherit"){this._$Ref.css({"right":e.css("right"),"width":"auto"});}else{this._$Ref.css({"width":i.width,"right":"auto"});}if(e.css("bottom")!="auto"&&e.css("bottom")!="inherit"){this._$Ref.css({"bottom":e.css("bottom"),"height":"auto"});}else{this._$Ref.css({"height":i.height,"bottom":"auto"});}if(typeof(z)==="number"){this._$Ref.css("z-index",z);}}};P.Layer.prototype.reset=function(){if(this._$Ref.length){this._$Ref[0].style.display="none";this._$Ref[0].style.visibility="hidden";this._$Ref.appendTo(sap.ui.getCore().getStaticAreaRef());}};P.Layer.prototype.getDomString=function(){L.error("sap.ui.core.Popup.Layer: getDomString function must be overwritten!");return"";};P.Layer.extend("sap.ui.core.Popup.BlindLayer",{constructor:function(){P.Layer.apply(this);}});P.BlindLayer.prototype.getDomString=function(){return"<div class=\"sapUiBliLy\" id=\"sap-ui-blindlayer-"+u()+"\"><iframe scrolling=\"no\" tabIndex=\"-1\"></iframe></div>";};P.prototype.oBlindLayerPool=new O(P.BlindLayer);P.Layer.extend("sap.ui.core.Popup.ShieldLayer",{constructor:function(){P.Layer.apply(this);}});P.ShieldLayer.prototype.getDomString=function(){return"<div class=\"sapUiPopupShield\" id=\"sap-ui-shieldlayer-"+u()+"\"></div>";};P.prototype.oShieldLayerPool=new O(P.ShieldLayer);(function(){var l=0;var i=Math.pow(2,32)-1;P.setInitialZIndex=function(e){if(e>=i){throw new Error("Z-index can't be higher than Number.MAX_SAFE_INTEGER");}l=Math.max(e,this.getLastZIndex());};P.getLastZIndex=function(){return l;};P.prototype.getLastZIndex=function(){return P.getLastZIndex();};P.getNextZIndex=function(){l+=10;if(l>=i){throw new Error("Z-index can't be higher than Number.MAX_SAFE_INTEGER");}return l;};P.prototype.getNextZIndex=function(){return P.getNextZIndex();};}());var r=function(e,i){if((!e&&i)||(e&&!i)){return false;}if(!e&&!i){return true;}var j=3;var l=Math.abs(e.left-i.left);var T=Math.abs(e.top-i.top);var w=Math.abs(e.width-i.width);var H=Math.abs(e.height-i.height);if(l>j||T>j||w>j||H>j){return false;}return true;};P.prototype.open=function(i,e,j,l,v,w,x){c(this.oContent,"Popup content must have been set by now");if(this.eOpenState!=n.CLOSED){return;}this.eOpenState=n.OPENING;var s=o(),U;this._bContentAddedToStatic=false;this._bUIAreaPatched=false;if(this.oContent instanceof C){if(!this.oContent.getParent()){s.addContent(this.oContent,true);this._bContentAddedToStatic=true;}else if(!this.oContent.getUIArea()){this.oContent.getUIArea=function(){return s;};this._bUIAreaPatched=true;}U=this.oContent.getUIArea();if(P._bEnableUIAreaCheck&&U.getRootNode().id!==s.getRootNode().id){L.warning("The Popup content is NOT connected with the static-UIArea and may not work properly!");}}if(typeof(i)=="string"){x=w;w=v;v=l;l=j;j=e;e=i;i=-1;}if(i===undefined){i=-1;}c(i===-1||(typeof i==="number"&&i%1==0),"iDuration must be an integer (or omitted)");c(e===undefined||typeof e==="string","my must be a string or empty");c(j===undefined||typeof j==="string","at must be a string or empty");c(!l||typeof l==="object"||typeof l==="function","of must be empty or an object");c(!v||typeof v==="string","offset must be empty or a string");c(!w||typeof w==="string","collision must be empty or a string");this._oPreviousFocus=P.getCurrentFocusInfo();if(this.isInPopup(l)||this.isInPopup(this._oPosition.of)){var y=this.getParentPopupId(l)||this.getParentPopupId(this._oPosition.of);var z="";var A=this.getContent();if(A instanceof E){z=A.getId();}else if(typeof A==="object"){z=A.id;}this.addChildToPopup(y,z);this.addChildToPopup(y,this._popupUID);}var $=this._$(true);var G="fast";if((i===0)||(i>0)){G=i;}else if((this._durations.open===0)||(this._durations.open>0)){G=this._durations.open;}var H;if(e||j||l||v||w){H=this._createPosition(e,j,l,v,w);this._oPosition=H;}else{H=this._oPosition;}if(!H.of){H.of=this._oPosition.of||document;}this._iZIndex=this._iZIndex===this.getLastZIndex()?this._iZIndex:this.getNextZIndex();var S=sap.ui.getCore().getStaticAreaRef();$.css({"position":"absolute","visibility":"hidden"});if(!($[0].parentNode==S)){$.appendTo(S);}$.css("z-index",this._iZIndex);L.debug("position popup content "+$.attr("id")+" at "+JSON.stringify(H.at));this._applyPosition(H);if(x!==undefined){this.setFollowOf(x);}$.toggleClass("sapUiShd",this._bShadow);var J=$[0];if(J){J.style.display="none";J.style.visibility="visible";}var N=G==0;this._duringOpen(!N);if(N){this._opened();}else if(this._animations.open){this._animations.open.call(null,$,G,this._opened.bind(this));}else{$.fadeIn(G,this._opened.bind(this));}};P.prototype._getDomRefToFocus=function(){var $=this._$(false,true),e,i;if(this._shouldGetFocusAfterOpen()){if(this._sInitialFocusId){i=sap.ui.getCore().byId(this._sInitialFocusId);if(i){e=i.getFocusDomRef();}e=e||window.document.getElementById(this._sInitialFocusId);}e=e||$.firstFocusableDomRef();}return e;};P.prototype._opened=function(){if(this.eOpenState!==n.OPENING){return;}this.bOpen=true;var $=this._$(false,true);if($[0]&&$[0].style){$[0].style.display="block";}if(this._shouldGetFocusAfterOpen()){var e=this._getDomRefToFocus();if(e){e.focus();}var i=this._getOfDom(this._oLastPosition.of);var j=q(i).rect();if(this._oLastOfRect&&j&&!r(this._oLastOfRect,j)){this._applyPosition(this._oLastPosition);}}this.eOpenState=n.OPEN;if(this.getFollowOf()){P.DockTrigger.addListener(P.checkDocking,this);}this._updateBlindLayer();this.fireOpened();};P.prototype._duringOpen=function(e){var $=this._$(false,true),S=sap.ui.getCore().getStaticAreaRef(),i=document.getElementById(S.id+"-firstfe");P._clearSelection();this._setupUserSelection();if(h()){if(this._oTopShieldLayer){clearTimeout(this._iTopShieldRemoveTimer);this._iTopShieldRemoveTimer=null;}else{this._oTopShieldLayer=this.oShieldLayerPool.borrowObject($,this._iZIndex+1);}this._iTopShieldRemoveTimer=setTimeout(function(){this.oShieldLayerPool.returnObject(this._oTopShieldLayer);this._oTopShieldLayer=null;this._iTopShieldRemoveTimer=null;}.bind(this),500);}if(!!D.browser.msie&&!D.os.windows_phone&&P._activateBlindLayer){this._oBlindLayer=this.oBlindLayerPool.borrowObject($,this._iZIndex-1);}if(this._bModal){this._showBlockLayer();}if(e&&i&&this._shouldGetFocusAfterOpen()&&!this.isInPopup(document.activeElement)&&this._getDomRefToFocus()!==document.activeElement){i.focus({preventScroll:true});}if(this.oContent instanceof E){this.oContent.addDelegate(this);}this.bOpen=true;this._activateFocusHandle();this._$(false,true).on("keydown",q.proxy(this._F6NavigationHandler,this));if(this._oBlindLayer){this._resizeListenerId=a.register(this._$().get(0),q.proxy(this.onresize,this));}};P.prototype._shouldGetFocusAfterOpen=function(){return this._bModal||this._bAutoClose||this._sInitialFocusId;};P.prototype._contains=function(e){var i=this._$().get(0);if(!i){return false;}var j=g(i,e);var l;if(!j){l=this.getChildPopups();j=l.some(function(v){var w=(v?window.document.getElementById(v):null);var j=g(w,e);if(!j){var x="sap.ui.core.Popup.contains-"+v;var y={domRef:e};sap.ui.getCore().getEventBus().publish("sap.ui",x,y);j=y.contains;}return j;});}if(!j){p.forEach(function(S){j=j||q(e).closest(S).length>0;});}return j;};P.prototype._containsEventBusWrapper=function(e,i,j){j.contains=this._contains(j.domRef);};P.prototype.onFocusEvent=function(e){var i=q.event.fix(e);if(arguments.length>1&&arguments[1]==="sap.ui.core.Popup.onFocusEvent-"+this._popupUID){i=q.event.fix(arguments[2]);}var j=(i.type=="focus"||i.type=="activate")?"focus":"blur";var l=false;if(j=="focus"){var v=this._$().get(0);if(v){l=this._contains(i.target);L.debug("focus event on "+i.target.id+", contains: "+l);if(this._bModal&&!l){var T=P.blStack.length>0&&P.blStack[P.blStack.length-1].popup===this;if(T){if(D.system.desktop||q(i.target).is(":input")){if(this.oLastBlurredElement){setTimeout(function(){if(this.oLastBlurredElement){this.oLastBlurredElement.focus();}}.bind(this),0);}else{v.focus();}}}}else if(this._bAutoClose&&l&&this._sTimeoutId){clearTimeout(this._sTimeoutId);this._sTimeoutId=null;}}}else if(j=="blur"){L.debug("blur event on "+i.target.id);if(this._bModal){this.oLastBlurredElement=i.target;}else if(this._bAutoClose){if(!this.touchEnabled&&!this._sTimeoutId){if(i.target===document.activeElement){return;}var w=typeof this._durations.close==="string"?0:this._durations.close;this._sTimeoutId=setTimeout(function(){this.close(w,"autocloseBlur");var x=this._oLastPosition&&this._oLastPosition.of;if(x){var y=this.getParentPopupId(x);if(y){var z="sap.ui.core.Popup.onFocusEvent-"+y;sap.ui.getCore().getEventBus().publish("sap.ui",z,i);}}}.bind(this),w);}}}};P.prototype.setInitialFocusId=function(i){c(!i||typeof i==="string","sId must be a string or empty");this._sInitialFocusId=i;};P.prototype.close=function(i){if(P._autoCloseDebug){return;}if(this._sTimeoutId){clearTimeout(this._sTimeoutId);this._sTimeoutId=null;if(arguments.length>1){var A=arguments[1];if(typeof A=="string"&&A=="autocloseBlur"&&this._isFocusInsidePopup()){return;}}}c(i===undefined||(typeof i==="number"&&(i%1==0)),"iDuration must be empty or an integer");if(this.eOpenState==n.CLOSED||this.eOpenState==n.CLOSING){return;}var e="fast";if((i===0)||(i>0)){e=i;}else if((this._durations.close===0)||(this._durations.close>0)){e=this._durations.close;}this.eOpenState=n.CLOSING;if(this.getFollowOf()){P.DockTrigger.removeListener(P.checkDocking,this);}if(this.oContent){if(this._bContentAddedToStatic){sap.ui.getCore().getEventBus().publish("sap.ui","__beforePopupClose",{domNode:this._$().get(0)});var S=sap.ui.getCore().getStaticAreaRef();S=sap.ui.getCore().getUIArea(S);S.removeContent(S.indexOfContent(this.oContent),true);}else if(this._bUIAreaPatched){delete this.oContent.getUIArea;}}this._bContentAddedToStatic=false;this._bUIAreaPatched=false;this._sTimeoutId=null;this._deactivateFocusHandle();this._$(false,true).off("keydown",this._F6NavigationHandler);if(this.oContent instanceof E){this.oContent.removeDelegate(this);}var $=this._$();if(this._bEventBusEventsRegistered){this._unregisterEventBusEvents();}if(this._oBlindLayer){this.oBlindLayerPool.returnObject(this._oBlindLayer);}this._oBlindLayer=null;if(h()){if(this._oBottomShieldLayer){clearTimeout(this._iBottomShieldRemoveTimer);this._iBottomShieldRemoveTimer=null;}else{this._oBottomShieldLayer=this.oShieldLayerPool.borrowObject($,this._iZIndex-3);}this._iBottomShieldRemoveTimer=setTimeout(function(){this.oShieldLayerPool.returnObject(this._oBottomShieldLayer);this._oBottomShieldLayer=null;this._iBottomShieldRemoveTimer=null;}.bind(this),500);}if(this.isInPopup(this._oLastPosition.of)){var j=this.getParentPopupId(this._oLastPosition.of);var l="";var v=this.getContent();if(v instanceof E){l=v.getId();}else if(typeof v==="object"){l=v.id;}this.removeChildFromPopup(j,l);this.removeChildFromPopup(j,this._popupUID);}if(this._bModal&&this.preventBrowserFocus){$.one("mousedown",function(w){w.preventDefault();});}this._duringClose();if(e==0){this._closed();}else if(this._animations.close){this._animations.close.call(null,$,e,this._closed.bind(this));}else{$.fadeOut(e,this._closed.bind(this));}};P.prototype._closed=function(){var $=this._$(false,true);if(this._bModal){this._hideBlockLayer();}P._clearSelection();this._restoreUserSelection();if($.length){var e=$.get(0);if(e){e.style.display="none";e.style.visibility="hidden";e.style.left="0px";e.style.top="0px";e.style.right="";}$=this._$(false,true);e=$.length?$[0]:null;if(e){e.style.display="none";e.style.visibility="hidden";e.style.left="0px";e.style.top="0px";e.style.right="";}}if(this._bModal){P.applyFocusInfo(this._oPreviousFocus);this._oPreviousFocus=null;this.oLastBlurredElement=null;}this.bOpen=false;this.eOpenState=n.CLOSED;var i=this.getChildPopups();for(var j=0,l=i.length;j<l;j++){this.closePopup(i[j]);}this.fireClosed();};P.prototype._duringClose=function(){if(this._resizeListenerId){a.deregister(this._resizeListenerId);this._resizeListenerId=null;}};P.getCurrentFocusInfo=function(){var e=null;var i=sap.ui.getCore().getCurrentFocusedControlId();if(i){var j=sap.ui.getCore().byId(i);e={'sFocusId':i,'oFocusInfo':j?j.getFocusInfo():{}};}else{try{var l=document.activeElement;if(l&&l.nodeName){e={'sFocusId':l.id,'oFocusedElement':l,'oFocusInfo':{}};}}catch(v){e=null;}}if(e){e.popup=this;}return e;};P.applyFocusInfo=function(e){var i={preventScroll:true};if(e){var j=sap.ui.getCore().byId(e.sFocusId);if(j){j.applyFocusInfo(Object.assign(i,e.oFocusInfo));}else{var l=((e.sFocusId?window.document.getElementById(e.sFocusId):null))||e.oFocusedElement;if(l){l.focus(i);}}}};P.prototype.setContent=function(e){c(typeof e==="object","oContent must be an object");this.oContent=e;return this;};P.prototype.getContent=function(){return this.oContent;};P.prototype.setPosition=function(e,i,j,l,v){c(typeof e==="string","my must be a string");c(typeof i==="string"||(typeof i==="object"&&(typeof i.left==="number")&&(typeof i.top==="number")),"my must be a string or an object with 'left' and 'top' properties");c(!j||typeof j==="object"||typeof j==="function","of must be empty or an object");c(!l||typeof l==="string","offset must be empty or a string");c(!v||typeof v==="string","collision must be empty or a string");this._oPosition=this._createPosition(e,i,j,l,v);if(this.eOpenState!=n.CLOSED){this._applyPosition(this._oPosition);this._oBlindLayer&&this._oBlindLayer.update(this._$());}return this;};P.prototype._createPosition=function(e,i,j,l,v){var N=false;if(e&&(e.indexOf("+")>=0||e.indexOf("-")>=0)){N=true;if(l&&l!="0 0"){L.warning("offset used in my and in offset, the offset value will be ignored","sap.ui.core.Popup","setPosition");}l=null;}var w=d({},this._oDefaultPosition,{"my":e||this._oDefaultPosition.my,"at":i||this._oDefaultPosition.at,"of":j,"offset":l,"collision":v});if(!q.ui.version){if(P._bNewOffset==null){P._bNewOffset=true;var $=q(document.createElement("div"));$.position({of:window,using:function(A,G){P._bNewOffset=(G!==undefined);}});}}var x=[];var y=[];if(P._bNewOffset||V(q.ui.version).compareTo("1.8.23")>0){if(l&&l!="0 0"){x=w.my.split(" ");y=l.split(" ");var S=[parseInt(y[0])<0?"":"+",parseInt(y[1])<0?"":"+"];w.my=x[0]+S[0]+y[0]+" "+x[1]+S[1]+y[1];w.offset=null;}}else if(N){x=w.my.split(" ");y=["",""];var z=x[0].indexOf("+");if(z<0){z=x[0].indexOf("-");}if(z>=0){y[0]=x[0].slice(z);x[0]=x[0].slice(0,z);}z=x[1].indexOf("+");if(z<0){z=x[1].indexOf("-");}if(z>=0){y[1]=x[1].slice(z);x[1]=x[1].slice(0,z);}w.my=x[0]+" "+x[1];w.offset=y[0]+" "+y[1];}return w;};P.prototype._getPositionOffset=function(){var e=[];if(this._oPosition.my&&(this._oPosition.my.indexOf("+")>=0||this._oPosition.my.indexOf("-")>=0)){var i=this._oPosition.my.split(" ");var j=i[0].indexOf("+");if(j<0){j=i[0].indexOf("-");}if(j>=0){e[0]=i[0].slice(j);}j=i[1].indexOf("+");if(j<0){j=i[1].indexOf("-");}if(j>=0){e[1]=i[1].slice(j);}}else if(this._oPosition.offset){e=this._oPosition.offset.split(" ");}return e;};P.prototype._applyPosition=function(e){var i=sap.ui.getCore().getConfiguration().getRTL();var $=this._$();if($.length){var A=e.at;var j=$.get(0);if(typeof(A)==="string"){j.style.display="block";j.style.left="";j.style.right="";$.position(this._resolveReference(this._convertPositionRTL(e,i)));this._fixPositioning(e,i);}else if(m.isValid(A.left)&&m.isValid(A.top)){$.css({"left":A.left,"top":A.top});}else if(m.isValid(A.right)&&m.isValid(A.top)){$.css({"right":A.right,"top":A.top});}else if(typeof(A.left)==="number"&&typeof(A.top)==="number"){var l=$[0];if(l&&l.style.right){var w=$[0].getBoundingClientRect().width;$.css({"right":(document.documentElement.clientWidth-(A.left+w))+"px","top":A.top+"px"});}else{$.css({"left":A.left+"px","top":A.top+"px"});}}this._oLastPosition=e;this._oLastOfRect=this._calcOfRect(e.of);}};P.prototype._calcOfRect=function(e){var i=this._getOfDom(e);if(i){return q(i).rect();}return null;};P.prototype._getOfDom=function(e){if(e instanceof q.Event){return null;}var $;if(typeof(e)==="string"){$=q(document.getElementById(e));}else if(e instanceof q){$=e;}else{$=q(e instanceof E?e.getDomRef():e);}return $[0];};P.prototype._convertPositionRTL=function(e,i){var j=Object.assign({},e);if(i){var N=false;if(j.my&&(j.my.indexOf("+")>=0||j.my.indexOf("-")>=0)){N=true;}if((j.offset||N)&&((j.my.indexOf("begin")>-1)||(j.my.indexOf("end")>-1))&&((j.at.indexOf("begin")>-1)||(j.at.indexOf("end")>-1))){if(N){var l=j.my.split(" ");if(l.length==2){j.my="";if(l[0]){if(l[0].indexOf("begin")>-1||l[0].indexOf("end")>-1){if(l[0].indexOf("+")>-1){l[0]=l[0].replace("+","-");}else if(l[0].indexOf("-")>-1){l[0]=l[0].replace("-","+");}}j.my=l[0];}if(l[1]){if(l[1].indexOf("begin")>-1||l[1].indexOf("end")>-1){if(l[1].indexOf("+")>-1){l[1]=l[1].replace("+","-");}else if(l[1].indexOf("-")>-1){l[1]=l[1].replace("-","+");}}if(l[0]){j.my=j.my+" ";}j.my=j.my+l[1];}}}else{j.offset=this._mirrorOffset(j.offset);}}j.my=j.my.replace("begin","right").replace("end","left");j.at=j.at.replace("begin","right").replace("end","left");}else{j.my=j.my.replace("end","right").replace("begin","left");j.at=j.at.replace("end","right").replace("begin","left");}return j;};P.prototype._mirrorOffset=function(e){var i=String(e).trim().split(/\s/);var j=parseInt(i[0]);return(-j)+" "+i[i.length-1];};P.prototype._fixPositioning=function(e,i){var j=e.my;if(typeof(j)==="string"){if(P._isPositionFixingNeeded(j,i)){var $=this._$();var l=q(window).width()-$[0].getBoundingClientRect().width-$.offset().left;$.css({"right":l+"px","left":""});}}};P._isPositionFixingNeeded=function(e,i){return i&&((e.indexOf("right")>-1)||(e.indexOf("begin")>-1)||(e.indexOf("center")>-1))||!i&&((e.indexOf("right")>-1)||(e.indexOf("end")>-1));};P.prototype._resolveReference=function(e){var i=e;if(e.of instanceof E){i=Object.assign({},e,{of:e.of.getDomRef()});}return i;};P.prototype.setShadow=function(S){c(typeof S==="boolean","bShowShadow must be boolean");this._bShadow=S;if(this.eOpenState!=n.CLOSED){this._$().toggleClass("sapUiShd",S);}return this;};P.prototype.setModal=function(e,i){c(typeof e==="boolean","bModal must be boolean");c(!i||typeof i==="string","sModalCSSClass must be empty or a string");var j=this._bModal;this._bModal=e;this._sModalCSSClass=i;if(this.isOpen()){if(j!==e){P._clearSelection();if(e){this._setupUserSelection();this._showBlockLayer();}else{this._hideBlockLayer();this._restoreUserSelection();}if(this.touchEnabled&&this._bAutoClose){if(!e){q(document).on("touchstart mousedown",q.proxy(this._fAutoCloseHandler,this));}else{q(document).off("touchstart mousedown",this._fAutoCloseHandler);}}}}return this;};P.prototype.getModal=function(){return this._bModal;};P.prototype.setNavigationMode=function(e){if(e!="NONE"&&e!="DOCK"&&e!="SCOPE"){this._sF6NavMode="NONE";}this._sF6NavMode=e;};P.prototype.setAutoClose=function(A){c(typeof A==="boolean","bAutoClose must be boolean");if(this.touchEnabled&&this.isOpen()&&this._bAutoClose!==A){if(!this._bModal){if(A){q(document).on("touchstart mousedown",q.proxy(this._fAutoCloseHandler,this));}else{q(document).off("touchstart mousedown",this._fAutoCloseHandler);}}}this._bAutoClose=A;return this;};P.prototype.setExtraContent=function(e){c(Array.isArray(e),"Extra popup content must be an array which contains either sap.ui.core.Element, DOM Element or an ID");if(!this._aExtraContent){this._aExtraContent=[];}var j=function(z){return{onBeforeRendering:function(){var A=z.getDomRef();if(A&&this.isOpen()){if(D.browser.msie){q(A).off("deactivate."+this._popupUID,this.fEventHandler);}else{A.removeEventListener("blur",this.fEventHandler,true);}}},onAfterRendering:function(){var A=z.getDomRef();if(A&&this.isOpen()){if(D.browser.msie){q(A).on("deactivate."+this._popupUID,this.fEventHandler);}else{A.addEventListener("blur",this.fEventHandler,true);}}}};};var v,w,x,y;for(var i=0,l=e.length;i<l;i++){w=e[i];if(w instanceof E){v=w.getId();}else if(typeof w==="object"){v=w.id;}else if(typeof w==="string"){v=w;}if(this.getChildPopups().indexOf(v)===-1){this.addChildPopup(v);y={id:v};if(w instanceof E){x=j(w);w.addEventDelegate(x,this);y.delegate=x;}this._aExtraContent.push(y);}}return this;};P.prototype.setAutoCloseAreas=P.prototype.setExtraContent;P.prototype.setAnimations=function(e,i){c(e===null||typeof e==="function","fnOpen must be a function");c(i===null||typeof i==="function","fnClose must be a function");if(e&&(typeof(e)=="function")){this._animations.open=e;}if(i&&(typeof(i)=="function")){this._animations.close=i;}return this;};P.prototype.setDurations=function(i,e){c(i===null||(typeof i==="number"&&(i%1==0)),"iOpenDuration must be null or an integer");c(!e||(typeof e==="number"&&(e%1==0)),"iOpenDuration must be undefined or an integer");if((i>0)||(i===0)){this._durations.open=i;}if((e>0)||(e===0)){this._durations.close=e;}return this;};P.CLOSE_ON_SCROLL="close_Popup_if_of_is_moved";P.prototype._fnCloseOnScroll=function(e){this.close();};P.prototype.setFollowOf=function(e){P.DockTrigger.removeListener(P.checkDocking,this);var U=false;this._bFollowOf=true;this._followOfHandler=null;if(typeof(e)==="function"){this._followOfHandler=e;U=true;}else if(typeof(e)==="boolean"){U=e;}else if(e===P.CLOSE_ON_SCROLL){this._followOfHandler=this._fnCloseOnScroll;U=true;}else{this._bFollowOf=false;if(e!==null){L.error("Trying to set an invalid type to 'followOf: "+e);}}if(U&&this._oLastPosition){this._oLastOfRect=this._calcOfRect(this._oLastPosition.of);}if(this._bFollowOf&&this.getOpenState()===n.OPEN){P.DockTrigger.addListener(P.checkDocking,this);}};P.prototype.getAutoClose=function(){return this._bAutoClose;};P.prototype.getFollowOf=function(){if(this._bFollowOf){return typeof(this._followOfHandler)==="function"?this._followOfHandler:true;}return false;};P.prototype.isOpen=function(){return this.bOpen;};P.prototype.getOpenState=function(){return this.eOpenState;};P.prototype.destroy=function(){if(this._resizeListenerId){a.deregister(this._resizeListenerId);this._resizeListenerId=null;}this.close(0);this.oContent=null;if(this._bFollowOf){this.setFollowOf(null);}if(this._bEventBusEventsRegistered){this._unregisterEventBusEvents();}if(this._iTopShieldRemoveTimer){clearTimeout(this._iTopShieldRemoveTimer);this.oShieldLayerPool.returnObject(this._oTopShieldLayer);this._oTopShieldLayer=null;this._iTopShieldRemoveTimer=null;}if(this._iBottomShieldRemoveTimer){clearTimeout(this._iBottomShieldRemoveTimer);this.oShieldLayerPool.returnObject(this._oBottomShieldLayer);this._oBottomShieldLayer=null;this._iBottomShieldRemoveTimer=null;}if(this._aExtraContent){var e;this._aExtraContent.forEach(function(A){if(A.delegate){e=q(document.getElementById(A.id)).control(0);if(e){e.removeEventDelegate(A.delegate);}}});}M.prototype.destroy.apply(this,arguments);};P.prototype.exit=function(){delete this._mEvents;};P.prototype._addFocusEventListeners=function(e,j,v){if(!this.fEventHandler){this.fEventHandler=q.proxy(this.onFocusEvent,this);}var $=this._$();var w=this.getChildPopups();var x={};var i=0,l=0;if($.length){if(document.addEventListener&&!D.browser.msie){document.addEventListener("focus",this.fEventHandler,true);$.get(0).addEventListener("blur",this.fEventHandler,true);for(i=0,l=w.length;i<l;i++){x=(w[i]?window.document.getElementById(w[i]):null);if(x){x.addEventListener("blur",this.fEventHandler,true);}}}else{q(document).on("activate."+this._popupUID,this.fEventHandler);$.on("deactivate."+this._popupUID,this.fEventHandler);for(i=0,l=w.length;i<l;i++){x=(w[i]?window.document.getElementById(w[i]):null);if(x){q(x).on("deactivate."+this._popupUID,this.fEventHandler);}}}}};P.prototype._removeFocusEventListeners=function(e,j,v){var $=this._$(false,true);if(!$.length){return;}var w=this.getChildPopups();var x={};var i=0,l=0;if(document.removeEventListener&&!D.browser.msie){document.removeEventListener("focus",this.fEventHandler,true);$.get(0).removeEventListener("blur",this.fEventHandler,true);for(i=0,l=w.length;i<l;i++){x=(w[i]?window.document.getElementById(w[i]):null);if(x){x.removeEventListener("blur",this.fEventHandler,true);}this.closePopup(w[i]);}}else{q(document).off("activate."+this._popupUID,this.fEventHandler);$.off("deactivate."+this._popupUID,this.fEventHandler);for(i=0,l=w.length;i<l;i++){x=(w[i]?window.document.getElementById(w[i]):null);if(x){q(x).off("deactivate."+this._popupUID,this.fEventHandler);}}}this.fEventHandler=null;};P.prototype._activateFocusHandle=function(){if(this._bModal||this._bAutoClose){this._addFocusEventListeners();}if(this.touchEnabled&&!this._bModal&&this._bAutoClose){q(document).on("touchstart mousedown",q.proxy(this._fAutoCloseHandler,this));}};P.prototype._deactivateFocusHandle=function(){if(this.fEventHandler){this._removeFocusEventListeners();}if(this.touchEnabled&&!this._bModal&&this._bAutoClose){q(document).off("touchstart mousedown",this._fAutoCloseHandler);}};P.prototype._registerEventBusEvents=function(e,i,j){var l=this;q.each(l._mEvents,function(v,w){sap.ui.getCore().getEventBus().subscribe("sap.ui",v,w,l);});this._bEventBusEventsRegistered=true;};P.prototype._unregisterEventBusEvents=function(e,i,j){var l=this;q.each(l._mEvents,function(v,w){sap.ui.getCore().getEventBus().unsubscribe("sap.ui",v,w,l);});delete this._bEventBusEventsRegistered;};P.prototype._addFocusableArea=function(e,i,j){if(this.getChildPopups().indexOf(j.id)===-1){this.addChildPopup(j.id);}};P.prototype._removeFocusableArea=function(e,i,j){this.removeChildPopup(j.id);};P.prototype._closePopup=function(e,i,j){this.close(typeof this._durations.close==="string"?0:this._durations.close);};P.prototype._setIdentity=function($){if(typeof $==="object"){$.attr("data-sap-ui-popup",this._popupUID);}else{L.warning("Incorrect DomRef-type for 'setIdentity': "+$,this);return;}if(!this._bEventBusEventsRegistered){this._registerEventBusEvents();}};P.prototype._$=function(e,G){var $;if(this.oContent instanceof C){$=this.oContent.$();if(e||($.length===0&&!G)){L.info("Rendering of popup content: "+this.oContent.getId());if($.length>0){R.preserveContent($[0],true,false);}sap.ui.getCore().getRenderManager().render(this.oContent,sap.ui.getCore().getStaticAreaRef());$=this.oContent.$();}}else if(this.oContent instanceof E){$=this.oContent.$();}else{$=q(this.oContent);}this._setIdentity($);return $;};function _(e){if(P._blockLayerStateProvider){P._blockLayerStateProvider.fireEvent("blockLayerStateChange",e);}}P.attachBlockLayerStateChange=function(e,i,l){if(!P._blockLayerStateProvider){P._blockLayerStateProvider=new k();}P._blockLayerStateProvider.attachEvent("blockLayerStateChange",e,i,l);};P.detachBlockLayerStateChange=function(e,l){if(P._blockLayerStateProvider){P._blockLayerStateProvider.detachEvent("blockLayerStateChange",e,l);}};P.prototype._showBlockLayer=function(){var $=q("#sap-ui-blocklayer-popup"),e="sapUiBLy"+(this._sModalCSSClass?" "+this._sModalCSSClass:"");if($.length===0){$=q('<div id="sap-ui-blocklayer-popup" tabindex="0" class="'+e+'"></div>');$.appendTo(sap.ui.getCore().getStaticAreaRef());}else{$.removeClass().addClass(e);}P.blStack.push({zIndex:this._iZIndex-2,popup:this});$.css({"z-index":this._iZIndex-2,"visibility":"visible"}).show();q("html").addClass("sapUiBLyBack");if(P.blStack.length===1){_({visible:true,zIndex:P.blStack[0].zIndex});}};P.prototype._hideBlockLayer=function(){var $=q("#sap-ui-blocklayer-popup"),e=this,l;if($.length){var i=$.get(0);if(P.blStack.length>1){P.blStack=P.blStack.filter(function(j){return j.popup!==e;});i.style.zIndex=P.blStack[P.blStack.length-1].zIndex;i.style.visibility="visible";i.style.display="block";}else{l=P.blStack.pop();i.style.visibility="hidden";i.style.display="none";window.setTimeout(function(){q("html").removeClass("sapUiBLyBack");},0);_({visible:false,zIndex:l.zIndex});}}};P.prototype._isFocusInsidePopup=function(){var e=this._$(false).get(0);if(e&&g(e,document.activeElement)){return true;}return false;};P.DockTrigger=I;P.checkDocking=function(){if(this.getOpenState()===n.OPEN){var e=this._getOfDom(this._oLastPosition.of),i;if(e){if((e===window)||(e===window.document)||g(document.documentElement,e)){i=q(e).rect();}else if(e.id){var N=window.document.getElementById(e.id);var j=q(N).rect();if(j&&!r(i,j)){i=j;this._oLastPosition.of=N;}}}if(!i){this.close();return;}else if(i.left===0&&i.top===0&&i.height===0&&i.height===0&&this._oLastPosition.of.id){this._oLastPosition.of=window.document.getElementById(this._oLastPosition.of.id);e=this._getOfDom(this._oLastPosition.of);i=q(e).rect();if(!i){this.close();return;}}if(this._oLastOfRect){if(!r(this._oLastOfRect,i)){if(this._followOfHandler){var l=f({},this._oLastPosition),v=f({},this._oLastOfRect);this._followOfHandler({lastPosition:l,lastOfRect:v,currentOfRect:i});}else{this._applyPosition(this._oLastPosition);}}}}};P.prototype.ontouchstart=function(e){this.onmousedown(e,true);this._bMousedownCalled=true;};P.prototype.onmousedown=function(e,S){if(this._bMousedownCalled&&!S){this._bMousedownCalled=false;return;}if(this._iZIndex===this.getLastZIndex()||this.getModal()){return;}this._increaseMyZIndex("","mousedown",e);};P.prototype._increaseMyZIndex=function(e,j,v){var w=this.getParentPopup(this._oLastPosition.of);if(v&&v.type==="mousedown"||v&&v.isFromParentPopup||w.length===0){this._iZIndex=this.getNextZIndex();var $=this._$(false,true);$.css("z-index",this._iZIndex);if(this._oBlindLayer){this._oBlindLayer.update($,this._iZIndex-1);}if(v&&!v.type||v&&v.type!="mousedown"||j==="mousedown"){var x=this.getChildPopups();for(var i=0,l=x.length;i<l;i++){this.increaseZIndex(x[i],true);}}}else if(w.length>0){var y=q(w.get(0)).attr("data-sap-ui-popup");this.increaseZIndex(y,false);}};P.prototype.onAfterRendering=function(e){var i=this.getContent();var $=i instanceof E?i.$():q(i);$.toggleClass("sapUiShd",this._bShadow);P._clearSelection();this._setupUserSelection();$.css("position","absolute");this._setIdentity($);var j=$[0];var l=j.style.left;var v=j.style.right;var w=j.style.top;var x=j.style.bottom;if(!(l&&l!="auto"||v&&v!="auto"||w&&w!="auto"||x&&x!="auto")){L.debug("reposition popup content "+$.attr("id")+" at "+JSON.stringify(this._oLastPosition.at));this._applyPosition(this._oLastPosition);}$.show().css({"visibility":"visible","z-index":this._iZIndex});if(this._oBlindLayer){this._resizeListenerId=a.register(this._$().get(0),q.proxy(this.onresize,this));}if(this.isOpen()&&(this.getModal()||this.getAutoClose())){this._addFocusEventListeners();}this._$(false,true).on("keydown",q.proxy(this._F6NavigationHandler,this));};P.prototype.onBeforeRendering=function(e){if(this._resizeListenerId){a.deregister(this._resizeListenerId);this._resizeListenerId=null;}if(this.isOpen()&&(this.getModal()||this.getAutoClose())){this._removeFocusEventListeners();}this._$(false,true).off("keydown",this._F6NavigationHandler);};P.prototype.onresize=function(e){if(this.eOpenState!=n.CLOSED&&this._oBlindLayer){var i=this;setTimeout(function(){i._updateBlindLayer();},0);}};P.prototype._updateBlindLayer=function(){if(this.eOpenState!=n.CLOSED&&this._oBlindLayer){this._oBlindLayer.update(this._$(false,true));}};P.prototype.isInPopup=function(T){var $=this.getParentPopup(T);return $&&$.length>0;};P.prototype.getParentPopup=function(T){var e=T?T:this;var $=q(e instanceof E?e.getDomRef():e);return $.closest("[data-sap-ui-popup]");};P.prototype.getParentPopupId=function(T){var $=this.getParentPopup(T);return $.attr("data-sap-ui-popup");};P.prototype.addChildToPopup=function(e,i){var j="sap.ui.core.Popup.addFocusableContent-"+e;sap.ui.getCore().getEventBus().publish("sap.ui",j,{id:i});};P.prototype.removeChildFromPopup=function(e,i){var j="sap.ui.core.Popup.removeFocusableContent-"+e;sap.ui.getCore().getEventBus().publish("sap.ui",j,{id:i});};P.prototype.closePopup=function(e){var i="sap.ui.core.Popup.closePopup-"+e;sap.ui.getCore().getEventBus().publish("sap.ui",i);};P.prototype.increaseZIndex=function(e,i){var j="sap.ui.core.Popup.increaseZIndex-"+e;sap.ui.getCore().getEventBus().publish("sap.ui",j,{isFromParentPopup:i?i:false});};P.prototype.focusTabChain=function(e){var S=e.event.target,N=e.that.getMetadata().getName(),i;if((!e.$FocusablesContent||!e.$FocusablesFooter)||(!e.$FocusablesContent.length&&!e.$FocusablesFooter.length)){return;}if(S.id===e.firstFocusable){L.debug("First dummy focus element was focused","",N);if(e.$FocusablesFooter.length>0){L.debug("Last footer element will be focused","",N);i=e.$FocusablesFooter[e.$FocusablesFooter.length-1];}else{L.debug("Last content element will be focused","",N);i=e.$FocusablesContent[e.$FocusablesContent.length-1];}}else if(S.id===e.lastFocusable){L.debug("Last dummy focus element was focues","",N);if(e.$FocusablesContent.length>0){L.debug("First content element will be focused","",N);i=e.$FocusablesContent[0];}else{L.debug("First footer element will be focused","",N);i=e.$FocusablesFooter[0];}}if(i){setTimeout(function(){var j=sap.ui.getCore().byId(i.id);if(j instanceof C){L.debug("Focus will be handled by "+j.getMetadata().getName(),"",N);}else{L.debug("oFocusDomRef will be focused","",N);}if(j){j.focus();}else if(i){i.focus();}return j?j.getId():i.id;},0);}};P.prototype._setupUserSelection=function(){var $=this._$(false,true);P._markAsUserSelectable($,this._bModal||P.blStack.length>0);if(this._bModal){if(P.blStack.length>0){var l=P.blStack[P.blStack.length-1];var G=function(e){return e.popup.getId();};if(P.blStack.map(G).indexOf(this.getId())===-1){P._markAsNotUserSelectable(l.popup._$(false,true),true);}else if(l.popup.getId()!==this.getId()){P._markAsNotUserSelectable($,true);}}else{P._markAsNotUserSelectable(q("html"),true);P._markExternalContentAsUserSelectable(true);}}};P.prototype._restoreUserSelection=function(){var $=this._$(false,true);P._markAsNotUserSelectable($,false);if(P.blStack.length>0){P._markAsUserSelectable(P.blStack[P.blStack.length-1].popup._$(false,true),true);}else{P._markAsUserSelectable(q("html"),false);P._markExternalContentAsNotUserSelectable(false);}};P._clearSelection=function(){var S=document.getSelection();if(!S.isCollapsed){S.removeAllRanges();}};P._markAsUserSelectable=function($,e){if(!(D.browser.msie||D.browser.edge)){$.removeClass("sapUiNotUserSelectable");if(e){$.addClass("sapUiUserSelectable");}}};P._markAsNotUserSelectable=function($,e){if(!(D.browser.msie||D.browser.edge)){$.removeClass("sapUiUserSelectable");if(e){$.addClass("sapUiNotUserSelectable");}}};var p=new Set(),t="[data-sap-ui-integration-popup-content]";p.add(t);P.addExternalContent=function(S,e){if(!Array.isArray(S)){S=[S];}S.forEach(Set.prototype.add.bind(p));if(e){P.markExternalContentAsSelectable();}};P.removeExternalContent=function(S,e){if(!Array.isArray(S)){S=[S];}if(e){P.markExternalContentAsNotSelectable();}S.forEach(function(i){if(i!==t){p.delete(i);}});};P.markExternalContentAsSelectable=function(){P._clearSelection();if(P.blStack.length>0){P._markExternalContentAsUserSelectable(true);}};P.markExternalContentAsNotSelectable=function(){P._clearSelection();if(P.blStack.length>0){P._markExternalContentAsNotUserSelectable(false);}};P._getExternalContent=function(){var e=[];if(p.size>0){p.forEach(function(S){var $=q(S);if($.length>0){e.push($);}});}return e;};P._markExternalContentAsUserSelectable=function(e){var i=P._getExternalContent();i.forEach(function($){P._markAsUserSelectable($,e);});};P._markExternalContentAsNotUserSelectable=function(e){var i=P._getExternalContent();i.forEach(function($){P._markAsNotUserSelectable($,e);});};return P;});
