//@ui5-bundle sap/ui/core/library-preload.js
/*
 * ! OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/base/ManagedObjectObserver',['sap/ui/base/Object','sap/ui/base/ManagedObject','sap/ui/base/EventProvider',"sap/base/util/array/uniqueSort",'sap/base/util/deepExtend'],function(B,M,E,u,d){"use strict";
var a=B.extend("sap.ui.base.ManagedObjectObserver",{constructor:function(C){if(!C&&typeof C!=="function"){throw new Error("Missing callback function in ManagedObjectObserver constructor");}this._fnCallback=C;}});
a.prototype.observe=function(i,C){if(!(i instanceof M)){if(i==null){return;}throw new TypeError("ManagedObjectObserver can only handle ManagedObjects, but observe was called for "+i);}p(i,C);c(i,this,C);};
a.prototype.unobserve=function(i,C){if(!(i instanceof M)){if(i==null){return;}throw new TypeError("ManagedObjectObserver can only handle ManagedObjects, but unobserve was called for "+i);}if(C){p(i,C);}r(i,this,C);};
a.prototype.isObserved=function(i,C){if(!(i instanceof M)){if(i==null){return false;}throw new TypeError("ManagedObjectObserver can only handle ManagedObjects, but isObserved was called for "+i);}return e(i,this,C);};
a.prototype.disconnect=function(){f(this);};
a.prototype.getConfiguration=function(i){return g(i,this);};
var O={},t=Object.create(null);
O.propertyChange=function(i,n,v,N){h("properties",i,n,function(){return{type:"property",old:v,current:N};});};
O.aggregationChange=function(i,n,s,v){h("aggregations",i,n,function(){return{type:"aggregation",mutation:s,children:Array.isArray(v)?v:null,child:!Array.isArray(v)?v:null};});};
O.parentChange=function(i,n,s,P){h("parent",i,n,function(){return{type:"parent",mutation:s,parent:P};});var q=s==="unset"?"remove":"insert";O.aggregationChange(P,n,q,i);};
O.associationChange=function(i,n,s,I){h("associations",i,n,function(){return{type:"association",mutation:s,ids:I};});};
O.eventChange=function(i,n,s,L,F,D){h("events",i,n,function(){return{type:"event",mutation:s,listener:L,func:F,data:D};});};
O.bindingChange=function(i,n,s,q,v){h("bindings",i,n,function(){return{type:"binding",mutation:s,bindingInfo:q,memberType:v};});};
O.objectDestroyed=function(i){h("destroy",i,null,function(){return{type:"destroy"};});var I=i.getId();if(t[I]){i.detachEvent("EventHandlerChange",H);delete t[I];}delete i._observer;};
function h(T,n,N,C){var I=n.getId(),q=t[I];if(q){var s;for(var i=0;i<q.listeners.length;i++){if(b(q.configurations[i],T,N)){if(!s){s=C();s.name=N;s.object=n;}var L=q.listeners[i];L._fnCallback(s);}}}}
function b(C,T,n){if(C==null||!T){return false;}if(T!="destroy"&&T!="parent"&&!n){return false;}return C[T]===true||(Array.isArray(C[T])&&C[T].indexOf(n)>-1);}
function c(T,L,C){j(T,L,C,false);}
function g(T,L){var i=T.getId();var n=t[i];if(n&&n.listeners){var I=n.listeners.indexOf(L);if(I>=0){var C=d({},n.configurations[I]);return C;}}return null;}
function r(T,L,C){C=C||g(T,L);j(T,L,C,true);}
function e(T,L,C){var i=T.getId(),n=t[i];C=C||g(T,L);if(!n){return false;}var I=n.listeners.indexOf(L);if(I===-1){return false;}else{return m(n.configurations[I].properties,C.properties)&&m(n.configurations[I].aggregations,C.aggregations)&&m(n.configurations[I].associations,C.associations)&&m(n.configurations[I].bindings,C.bindings)&&m(n.configurations[I].events,C.events)&&o(n.configurations[I].destroy,C.destroy)&&o(n.configurations[I].parent,C.parent);}}
function f(L){for(var n in t){var T=t[n];for(var i=0;i<T.listeners.length;i++){if(T.listeners[i]===L){T.listeners.splice(i,1);T.configurations.splice(i,1);}}if(T.listeners&&T.listeners.length===0){delete t[n];T.object._observer=undefined;}}}
function j(T,L,C,R){var i=T.getId(),n=t[i],q,I;if(R){if(!n){return;}I=n.listeners.indexOf(L);if(I>=0){q=n.configurations[I];}}else{if(!n){n=t[i]={listeners:[],configurations:[],object:T};}I=n.listeners.indexOf(L);if(I===-1){n.listeners.push(L);n.configurations.push(C);}else{q=n.configurations[I];}}if(q){q.properties=q.properties||[];l(q.properties,C.properties,R);q.aggregations=q.aggregations||[];l(q.aggregations,C.aggregations,R);q.associations=q.associations||[];l(q.associations,C.associations,R);q.bindings=q.bindings||[];l(q.bindings,C.bindings,R);q.events=q.events||[];l(q.events,C.events,R);if(C.destroy!=null){if(R){delete q.destroy;}else{q.destroy=C.destroy;}}if(C.parent!=null){if(R){delete q.parent;}else{q.parent=C.parent;}}}var s=k(T,"events");if(T._observer&&R){if(!s&&E.hasListener(T,"EventHandlerChange",H)){T.detachEvent("EventHandlerChange",H);}if(!s&&!k(T,"properties")&&!k(T,"aggregations")&&!k(T,"associations")&&!k(T,"destroy")&&!k(T,"parent")&&!k(T,"bindings")){delete T._observer;delete t[i];}}else if(!T._observer&&!R){if(s&&!E.hasListener(T,"EventHandlerChange",H)){T.attachEvent("EventHandlerChange",H);}T._observer=O;}}
function k(T,s){var i=T.getId(),n=t[i];if(n){var C=n.configurations.filter(function(q){return q.hasOwnProperty(s)&&q[s]&&(q[s]===true||q[s].length>0);});return C.length>0;}return false;}
function H(i){var T=i.getSource(),s=i.mParameters.EventId;if(T.getMetadata().hasEvent(s)){if(i.mParameters.type==="listenerAttached"){O.eventChange(T,s,"insert",i.mParameters.listener,i.mParameters.func,i.mParameters.data);}else if(i.mParameters.type==="listenerDetached"){O.eventChange(T,s,"remove",i.mParameters.listener,i.mParameters.func,i.mParameters.data);}}}
function l(n,A,R){if(!A){return;}for(var i=0;i<A.length;i++){var I=n.indexOf(A[i]);if(I>-1&&R){n.splice(I,1);}else if(I===-1&&!R){n.push(A[i]);}}}
function m(F,s){if(!Array.isArray(s)||s.length==0){return true;}if(!Array.isArray(F)||F.length==0){return false;}var U=u(F.concat(s));return F.length===U.length;}
function o(i,C){if(C==null){return true;}return i===C;}
function p(i,C){var n=i.getMetadata(),P=Object.keys(n.getAllProperties()),A=Object.keys(n.getAllAggregations()),q=Object.keys(n.getAllAssociations()),s=u(P.concat(A)),v=Object.keys(n.getAllEvents());C.properties=C.properties===true?P:C.properties;C.aggregations=C.aggregations===true?A:C.aggregations;C.associations=C.associations===true?q:C.associations;C.bindings=C.bindings===true?s:C.bindings;C.events=C.events===true?v:C.events;C.destroy=(C.destroy==null)?false:C.destroy;C.parent=(C.parent==null)?false:C.parent;}
return a;});
sap.ui.predefine('sap/ui/model/base/ManagedObjectModel',['../json/JSONModel','../json/JSONPropertyBinding','../json/JSONListBinding','sap/ui/base/ManagedObject','sap/ui/base/ManagedObjectObserver','../Context','../ChangeReason',"sap/base/util/uid","sap/base/Log","sap/base/util/isPlainObject","sap/base/util/deepClone"],function(J,a,b,M,c,C,d,u,L,e,f){"use strict";var g="@custom",I="--";
function _(n,o,A,O){var p=A.get(o)||[],q,r;for(var i=0;i<p.length;i++){q=p[i];if(!(q instanceof M)){continue;}r=true;if(O){n._oObserver.observe(q,{properties:true,aggregations:true});}else{n._oObserver.unobserve(q,{properties:true,aggregations:true});}var s=q.getMetadata().getAllAggregations();for(var K in s){_(n,q,s[K],O);}}if(r){var K=o.getId()+"/@"+A.name;if(O){if(!n._mObservedCount.aggregations[K]){n._mObservedCount.aggregations[K]=0;}n._mObservedCount.aggregations[K]++;}else{delete n._mObservedCount.aggregations[K];}}}
function h(n){var s,i=n.length-1,p=[];while(!(n[i].node instanceof M)){if(s){p.splice(0,0,s);}s=n[i].path;i--;}return[n[i].node,n[i+1],p,s];}
function j(o){var D="",p;var t=typeof o;if(o==null||(t!="object"&&t!="function")){D=o;}else if(e(o)){D=JSON.stringify(o);}else if(o instanceof M){D=o.getId();for(p in o.mProperties){D=D+"$"+j(o.mProperties[p]);}}else if(Array.isArray(o)){for(var i=0;o.length;i++){D=D+"$"+j(o);}}else{L.warning("Could not stringify object "+o);D="$";}return D;}
var k=b.extend("sap.ui.model.base.ManagedObjectModelAggregationBinding",{
constructor:function(){b.apply(this,arguments);this._getOriginOfManagedObjectModelBinding();},
_mightBeAffectedByChangesInside:function(o){while(o){if(o.getParent()===this._oOriginMO){return true;}o=o.getParent();}return false;},
getEntryKey:function(o){var O=o.getObject();if(O instanceof M){return O.getId();}return b.prototype.getEntryKey.apply(this,arguments);},
getEntryData:function(o){var O=o.getObject();if(O instanceof M){return j(O);}return b.prototype.getEntryData.apply(this,arguments);},
_getContexts:function(s,i){var S;if(this._oAggregation){var o=this._oOriginMO.getBinding(this._sMember);if(o){var n=o.getModel();S=n.iSizeLimit;}var B=this._oOriginMO.getBindingInfo(this._sMember);if(B&&s>=0&&i&&S&&i>S){var U=false;if(s!=B.startIndex){B.startIndex=s;U=true;}if(i!=B.length){B.length=i;U=true;}if(U){this._oAggregation.update(this._oOriginMO,"change");}}}return b.prototype._getContexts.apply(this,arguments);},
_getOriginOfManagedObjectModelBinding:function(){if(!this._oOriginMO){var o=this.oModel,n=[];o._getObject(this.sPath,this.oContext,n);var v=h(n);this._oOriginMO=v[0];this._aPartsInJSON=v[2];this._sMember=v[3];this._oAggregation=this._oOriginMO.getMetadata().getAggregation(this._sMember);}},
getLength:function(){if(this._aPartsInJSON.length==0){var i=this._oOriginMO.getBinding(this._sMember);if(i&&i.isA("sap.ui.model.ListBinding")){return i.getLength();}}return b.prototype.getLength.apply(this,arguments);},
isLengthFinal:function(){if(this._aPartsInJSON.length==0){var i=this._oOriginMO.getBinding(this._sMember);if(i&&i.isA("sap.ui.model.ListBinding")){return i.isLengthFinal();}}return true;}
});
var l=a.extend("sap.ui.model.base.ManagedObjectModelPropertyBinding");
var m=J.extend("sap.ui.model.base.ManagedObjectModel",{constructor:function(o,D){if(!D&&typeof D!="object"){D={};}D[g]={};this._oObject=o;this._mObservedCount={properties:{},aggregations:{}};this.mListBinding={};J.apply(this,[D]);this._oObserver=new c(this.observerChanges.bind(this));}});
m.prototype.getAggregation=J.prototype.getProperty;
m.prototype.setData=function(D,i){var n={};n[g]=D;J.prototype.setData.apply(this,[n,i]);};
m.prototype.getJSON=function(){return JSON.stringify(this.oData[g]);};
m.prototype.setProperty=function(p,v,o,A){var r=this.resolve(p,o),n,O,P;if(!r){return false;}if(r.indexOf("/"+g)===0){return J.prototype.setProperty.apply(this,arguments);}n=r.lastIndexOf("/");O=r.substring(0,n||1);P=r.substr(n+1);var N=[],q=this._getObject(O,null,N);if(q){if(q instanceof M){var s=q.getMetadata().getManagedProperty(P);if(s){if(s.get(q)!==v){s.set(q,v);var F=function(B){var p=this.resolve(B.sPath,B.oContext);return p?p.startsWith(r):false;}.bind(this);this.checkUpdate(false,A,F);return true;}}else{L.warning("The setProperty method only supports properties, the path "+r+" does not point to a property",null,"sap.ui.model.base.ManagedObjectModel");}}else if(q[P]!==v){var V=h(N);var t=f(V[1].node),w=V[2];var x=t;for(var i=0;i<w.length;i++){x=x[w[i]];}x[P]=v;var y="/"+P;if(w.length>0){y="/"+w.join("/")+y;}var D=r.lastIndexOf(y);var z=r.substr(0,D);return this.setProperty(z,t,o);}}return false;};
m.prototype.addBinding=function(B){J.prototype.addBinding.apply(this,arguments);if(B instanceof k){var A=B.sPath.replace("/","");this.mListBinding[A]=B;}B.checkUpdate(false);};
m.prototype.removeBinding=function(B){J.prototype.removeBinding.apply(this,arguments);if(B instanceof k){var A=B.sPath.replace("/","");delete this.mListBinding[A];}this._observeBeforeEvaluating(B,false);};
m.prototype.firePropertyChange=function(p){if(p.reason===d.Binding){p.resolvedPath=this.resolve(p.path,p.context);}J.prototype.firePropertyChange.call(this,p);};
m.prototype.bindAggregation=function(p,o,P){return J.prototype.bindProperty.apply(this,arguments);};
m.prototype.bindProperty=function(p,o,P){var B=new l(this,p,o,P);return B;};
m.prototype.bindList=function(p,o,s,F,P){var B=new k(this,p,o,s,F,P);return B;};
m.prototype.getManagedObject=function(p,o){if(p instanceof C){o=p;p=o.getPath();}var O=this.getProperty(p,o);if(O instanceof M){return O;}return null;};
m.prototype.getRootObject=function(){return this._oObject;};
m.prototype._observePropertyChange=function(o,p){if(!o||!p){return;}var K=o.getId()+"/@"+p.name;if(!this._oObserver.isObserved(o,{properties:[p.name]})){this._oObserver.observe(o,{properties:[p.name]});this._mObservedCount.properties[K]=1;}else{this._mObservedCount.properties[K]++;}};
m.prototype._unobservePropertyChange=function(o,p){if(!o||!p){return;}var K=o.getId()+"/@"+p.name;this._mObservedCount.properties[K]--;if(this._mObservedCount.properties[K]==0){this._oObserver.unobserve(o,{properties:[p.name]});delete this._mObservedCount.properties[K];}};
m.prototype._observeAggregationChange=function(o,A){if(!o||!A){return;}var K=o.getId()+"/@"+A.name;if(!this._oObserver.isObserved(o,{aggregations:[A.name]})){this._oObserver.observe(o,{aggregations:[A.name]});this._mObservedCount.aggregations[K]=1;_(this,o,A,true);}else{this._mObservedCount.aggregations[K]++;}};
m.prototype._unobserveAggregationChange=function(o,A){if(!o||!A){return;}var K=o.getId()+"/@"+A.name;this._mObservedCount.aggregations[K]--;if(this._mObservedCount.aggregations[K]==0){this._oObserver.unobserve(o,{aggregations:[A.name]});delete this._mObservedCount.aggregations[K];}};
m.prototype._createId=function(i){var o=this._oObject;if(typeof o.createId==="function"){return o.createId(i);}if(!i){return o.getId()+I+u();}if(i.indexOf(o.getId()+I)!=0){return o.getId()+I+i;}return i;};
m.prototype._getSpecialNode=function(n,s,p,P){if(n instanceof M){if(s==="className"){if(n.getMetadata){return n.getMetadata().getName();}else{return typeof n;}}else if(s==="id"){return n.getId();}else if(s==="metadataContexts"){return n._oProviderData;}}else if(s==="binding"&&p&&P){return p.getBinding(P);}else if(s==="bound"&&p&&P){return p.isBound(P);}else if(s==="bindingInfo"&&p&&P){return p.getBindingInfo(P);}else if(Array.isArray(n)){if(s==="length"){return n.length;}else if(s.indexOf("id=")===0){var o=s.substring(3),F=null;for(var i=0;i<n.length;i++){if(n[i].getId()===this._createId(o)||n[i].getId()===o){F=n[i];break;}}return F;}}return null;};
m.prototype._getObject=function(p,o,n){var N=this._oObject,r="",t=this;if(n){n.push({path:"/",node:N});}this.aBindings.forEach(function(B){if(!B._bAttached){t._observeBeforeEvaluating(B,true);}});if(typeof p==="string"&&p.indexOf("/")!=0&&!o){return null;}if(o instanceof M){N=o;r=p;}else if(!o||o instanceof C){r=this.resolve(p,o);if(!r){return N;}if(r.indexOf("/"+g)===0){return J.prototype._getObject.apply(this,[p,o]);}}else{N=o;r=p;}if(!N){return null;}var P=r.split("/"),i=0;if(!P[0]){i++;}var q=null,s=null,v;while(N!==null&&P[i]){v=P[i];if(v=="id"){v="@id";}if(v.indexOf("@")===0){N=this._getSpecialNode(N,v.substring(1),q,s);}else if(N instanceof M){var w=N.getMetadata();if(w.isInstanceOf("sap.ui.core.IDScope")&&v.indexOf("#")===0){N=N.byId(v.substring(1));}else{q=N;s=v;var x=w.getManagedProperty(v);if(x){N=x.get(N);}else{var A=w.getManagedAggregation(v);if(A){N=A.get(N);}else{if(N&&N[v]&&typeof N[v]==="function"){N=N[v]();}else{N=null;}}}}}else if(Array.isArray(N)||e(N)){N=N[v];}else{if(N&&N[v]&&typeof N[v]==="function"){N=N[v]();}else{N=null;}}if(n){n.push({path:v,node:N});}i++;}return N;};
m.prototype.destroy=function(){for(var n in this._mAggregationObjects){var o=this._mAggregationObjects[n];if(o.object.invalidate.fn){o.object.invalidate=o.object.invalidate.fn;}}J.prototype.destroy.apply(this,arguments);};
m.prototype._observeBeforeEvaluating=function(B,o){if(!B.isResolved()){return;}var p=B.getPath();var i=B.getContext(),n=this._oObject,r;if(i instanceof M){n=i;r=p;}else if(!i||i instanceof C){r=this.resolve(p,i);if(!r){return;}if(r.indexOf("/"+g)===0){return;}}else{return;}var P=r.split("/");if(!P[0]){P.shift();}var s=P[0];if(n.getMetadata().isInstanceOf("sap.ui.core.IDScope")&&s.indexOf("#")===0){n=n.byId(s.substring(1));s=P[1];}if(n instanceof M){var N=n.getMetadata(),q=N.getManagedProperty(s);if(q){if(o===true){this._observePropertyChange(n,q);}else if(o===false){this._unobservePropertyChange(n,q);}}else{var A=N.getAggregation(s)||N.getAllPrivateAggregations()[s];if(A){if(o===true){this._observeAggregationChange(n,A);}else if(o===false){this._unobserveAggregationChange(n,A);}}}B._bAttached=o;}};
m.prototype.observerChanges=function(o){if(o.type=="aggregation"){var A={};if(o.child instanceof M){A=o.child.getMetadata().getAllAggregations();}if(o.mutation=="insert"){if(o.child instanceof M){this._oObserver.observe(o.child,{properties:true,aggregations:true});}for(var K in A){_(this,o.child,A[K],true);}if(this.mListBinding[o.name]){var i=this._oObject.getBinding(o.name);var n=this._oObject.getAggregation(o.name);if(i&&i.getCurrentContexts().length!=n.length){return;}}}else{if(o.child instanceof M){this._oObserver.unobserve(o.child,{properties:true,aggregations:true});}for(var K in A){_(this,o.child,A[K],false);}}}else if(o.type==="property"){this.aBindings.forEach(function(B){if(B._mightBeAffectedByChangesInside&&B._mightBeAffectedByChangesInside(o.object)){B.checkUpdate(true);}});}this.checkUpdate();};
m.prototype.checkUpdate=function(F,A,i){if(A){if(!this.sUpdateTimer){this.sUpdateTimer=setTimeout(function(){this.checkUpdate(F,false,i);}.bind(this),0);}return;}if(this.sUpdateTimer){clearTimeout(this.sUpdateTimer);this.sUpdateTimer=null;}var B=this.aBindings.slice(0);B.forEach(function(o){if(!i||i(o)){o.checkUpdate(F);}});};
return m;});
sap.ui.predefine('sap/ui/model/base/XMLNodeAttributesModel',['../json/JSONModel','sap/ui/base/ManagedObject','./XMLNodeUtils','sap/ui/core/util/reflection/XmlTreeModifier'],function(J,M,U,X){"use strict";
var a=J.extend("sap.ui.model.base.XMLNodeAttributesModel",{
constructor:function(n,c,C){this.oCallback=c;this.oNode=n;this.sContext=C;this.getMetadata();J.apply(this,[n]);},
evalMode:{simple:"",binding:"@binding",bindingStr:"@bindingStr",data:"@data",metaContext:"@metaContext"}
});
a.prototype.getMetadata=function(){if(!this.oMetadata){var n=this.oNode.namespaceURI,c=U.findControlClass(n,U.localName(this.oNode));this.oMetadata=c.getMetadata();this.mAggregations=this.oMetadata.getAllAggregations();this.mProperties=this.oMetadata.getAllProperties();this.mSpecialSettings=this.oMetadata._mAllSpecialSettings;this.mEvent=this.oMetadata.getAllEvents();}return this.oMetadata;};
a.prototype.getVisitor=function(){return this.oCallback;};
a.prototype.getProperty=function(p,c){p=p||"/";var r,C=p.length==0;var e=this.evalMode.simple;p=this.resolve(p,c);p=p.substring(1);var P=p.split("/");var d=P.indexOf("@data");var m=P.indexOf("@metaContext");if(d>-1){e=this.evalMode.data;P.splice(d,1);}else if(m>-1){var b=P.slice(0,m);var s=P.slice(m+1,P.length);var o=this._diveDeep(b,C,this.evalMode.metaContext);r=this._getAnnotation(s,o);return r;}else{var l=P[P.length-1];if(l.startsWith("@")){P.splice(-1,1);e=l;}}if(P[0]=="metadataContexts"){var f=this.oNode.getAttribute("metadataContexts");if(P.length==1){r=f;}else{var g=M.bindingParser(f);switch(P[1]){case"model":r=g.model;break;case"data":P.splice(1,1);r=this._diveDeep(P,C,this.evalMode.data);break;default:r=f;break;}}}else{r=this._diveDeep(P,C,e);}return r;};
a.prototype.getAggregation=a.prototype.getProperty;a.prototype.getSpecialSetting=a.prototype.getProperty;a.prototype.getEvent=a.prototype.getProperty;
a.prototype._diveDeep=function(p,c,e){var r=this._getTopProperty(p[0],e);if(p.length>1){p.shift();for(var i=0;i<p.length;i++){if(r){r=r[p[i]];}}}return r;};
a.prototype._getTopProperty=function(p,e){var r=null;var P;if(p.length==0){return this.oNode;}if(this.mProperties.hasOwnProperty(p)){P=this.mProperties[p];if(e===this.evalMode.simple){e=this.evalMode.data;}if(!this.oNode.hasAttribute(p)){r=P.defaultValue;}else{r=this.oNode.getAttribute(p);}}else if(this.mAggregations.hasOwnProperty(p)){if(this.oNode.hasAttribute(p)){r=this.oNode.getAttribute(p);}else{r=X.getAggregation(this.oNode,p);}}else if(!this.mSpecialSettings.hasOwnProperty(p)&&!this.mEvents.hasOwnProperty(p)){r=null;}else{if(this.oNode.hasAttribute(p)){r=this.oNode.getAttribute(p);}}var b=M.bindingParser(r);switch(e){case this.evalMode.simple:break;case this.evalMode.binding:r=b;break;case this.evalMode.bindingStr:if(!b){r="";}break;case this.evalMode.metaContext:var m={};if(b){if(typeof b==="string"){b=M.bindingParser("{"+b+"}");}var o=this.oCallback.getSettings().models[b.model];if(o){m.metaModel=o.getMetaModel();if(m.metaModel&&m.metaModel.getMetaContext){m.metaContext=m.metaModel.getMetaContext(b.path);m.schema=m.metaModel.getProperty(m.metaContext.getPath());}}r=m;}return r;case this.evalMode.data:if(b){var R=null;try{R=this.oCallback.getResult(r);}catch(c){}if(R){r=R;}}break;}if(r){if(P){var s=U.parseScalarType(P.type,r,p);if(!(typeof s==="object"&&s.path)){r=s;}}}return r;};
a.prototype._getObject=function(p,c,C){p=this.resolve(p,c);var i,o=this.getProperty(p,c);if(Array.isArray(o)){var l=o;var P=function(b){return function(){return p+"/"+b;};};for(i=0;i<l.length;i++){l[i].getPath=P(i);}return l;}return o;};
a.prototype.getContextName=function(){return this.sContext;};
a.prototype._getAnnotation=function(p,m){var A=m.schema;var i=0;while(A&&p[i]){A=A[p[i]];i++;}return A;};
return a;});
sap.ui.predefine('sap/ui/model/base/XMLNodeUtils',['sap/ui/thirdparty/jquery','sap/ui/base/DataType','sap/ui/base/ManagedObject','sap/base/util/ObjectPath','sap/base/Log'],function(q,D,M,O,L){"use strict";return{parseScalarType:function(t,v,n,c){var b=M.bindingParser(v,c,true);if(b&&typeof b==="object"){return b;}var V=v=b||v;var T=D.getType(t);if(T){if(T instanceof D&&!T.isValid(V)){V=T.parseValue(v);}}else{throw new Error("Property "+n+" has unknown type "+t);}return typeof V==="string"?M.bindingParser.escape(V):V;},localName:function(x){return x.localName||x.baseName||x.nodeName;},findControlClass:function(n,l){var c;var m=sap.ui.getCore().getLoadedLibraries();q.each(m,function(s,o){if(n===o.namespace||n===o.name){c=o.name+"."+((o.tagNames&&o.tagNames[l])||l);}});c=c||n+"."+l;var C=sap.ui.requireSync(c.replace(/\./g,"/"));C=C||O.get(c);if(C){return C;}else{L.error("Can't find object class '"+c+"' for XML-view","","XMLTemplateProcessor.js");}},getChildren:function(N){var i,o=N.childNodes,n=o.length,c=[];for(i=0;i<n;i++){if(o.item(i).nodeType===1){c.push(o.item(i));}}return c;}};});
sap.ui.predefine('sap/ui/model/meta/AdapterConstants',[],function(){"use strict";return{TextArrangement:{TextOnly:"TextOnly",TextFirst:"TextFirst",TextLast:"TextLast",TextSeparate:"TextSeparate"},Relation:{atMostOne:"0..1",one:"1",many:"n"},SupportedSortDirection:{none:"none",both:"both",asc:"ascending",desc:"descending"},Status:{None:undefined,VeryNegative:-1,Neutral:0,Negative:1,Critical:2,Positive:3,VeryPositive:4},Importance:{None:undefined,High:0,Medium:1,Low:2},ContactType:{fn:"formattedName",photo:"photo",role:"role",title:"title",org:"org",adr:"addresses",email:"emails",tel:"phones"},AddressType:{street:"street",code:"code",locality:"locality",region:"region",country:"country"},EmailAddressType:{address:"uri"},PhoneNumberType:{uri:"uri"}};});
sap.ui.predefine('sap/ui/model/meta/AdapterFactory',[],function(){"use strict";var A=function(){};
A.requestAdapter=function(m){return null;};
A.getAdapter=function(m){return null;};
return A;});
sap.ui.predefine('sap/ui/model/meta/BaseAdapter',["sap/ui/base/Object","./AdapterConstants","sap/ui/model/json/JSONModel","sap/ui/base/SyncPromise"],function(B,A,J,S){"use strict";
var a=B.extend("sap.ui.model.meta.BaseAdapter",{
oMetaModel:undefined,
sModelName:undefined,
constructor:function(m,p){this.constants=A;this.mMetadataContext=m;this.oModel=m.model;this.oMetaModel=this.oModel.getMetaModel();this.modelName=m.modelName;this.contextName=m.contextName;this.path=m.path;this.metaPath=m.metaPath;this._mProperties={};this._mPropertyBag={};this._mCustomPropertyBag={};this.init();this.enhance(p);},
enhance:function(p){if(p){for(var P in p){this.putProperty(P,p[P]);}}},
init:function(){if(!this.metaPath){this.oMetaContext=this.oMetaModel.getMetaContext(this.path);this.metaPath=this.oMetaContext.getPath();}else{this.oMetaContext=this.oMetaModel.createBindingContext(this.metaPath);}},
getModelName:function(){return this.modelName;},
putProperty:function(p,g,b,c){if(!g){return;}if(!c){c=this;}Object.defineProperty(this,p,{configurable:true,get:function(){if(this._mCustomPropertyBag[p]){return this._mCustomPropertyBag[p];}if(!this._mPropertyBag.hasOwnProperty(p)){this._mPropertyBag[p]=new S(function(r,d){if(typeof g=='function'){r(g.apply(c,b));}else{r(g);}});}return this._mPropertyBag[p];},set:function(v){this._mCustomPropertyBag[p]=v;}});},
convertToSimpleBinding:function(v,t){var p="{";if(this.modelName){p=p+"model: '"+this.modelName+"',";}if(this.sContextPath&&v.startsWith(this.sContextPath)){v=v.replace(this.sContextPath,"");}p=p+"path: '"+escape(v)+"'";if(t){p=p+", type: '"+t+"'";}p=p+"}";return p;},
getContext:function(){return this.contextName;},
setValue:function(p,v){this.putProperty(p,this._identity,[v],this);},
_identity:function(v){return v;},
parentPromise:function(p,m){return new Promise(function(r,b){sap.ui.require([p],function(P){var o=new P(m);r(o);},b);});},
getAdapterModel:function(){if(!this._oAdapterModel){this._oAdapterModel=new J(this);}return this._oAdapterModel;},
updateContextPath:function(c){var C=c.getBindingContext(this.model);var s=C?this.removeKeys(C.getPath())+"/":null;if(s&&s!=this.sContextPath){this.sContextPath=s;this._mPropertyBag={};}},
removeKeys:function(p){return p;},
sibling:function(s){if(!s){return null;}var m={model:this.oModel,path:s};var c=this.getMetadata().getClass();var o=new c(m);o.sContextPath=this.sContextPath;return o;}
});
return a;});
/**
 * @license
 * Lodash (Custom Build) <https://lodash.com/>
 * Build: `lodash strict include="omit,uniq,uniqBy,uniqWith,intersection,intersectionBy,intersectionWith,pick,pickBy,debounce,throttle,max,min,castArray,curry,merge,mergeWith,toArray,xor,xorBy,xorWith,isNil,difference,differenceBy,differenceWith,flatMap,flatMapDeep,flatMapDepth,isEqual,isEqualWith,without,flatten,flattenDeep,flattenDepth,compact,zipObject,zipObjectDeep,union,unionBy,unionWith"`
 * Copyright OpenJS Foundation and other contributors <https://openjsf.org/>
 * Released under MIT license <https://lodash.com/license>
 * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
 * Copyright Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
 */
sap.ui.predefine('sap/base/util/restricted/_/lodash.custom',function(){'use strict';var u;var V='4.17.20';var L=200;var F='Expected a function';var H='__lodash_hash_undefined__';var M=500;var P='__lodash_placeholder__';var C=1,a=2,b=4;var c=1,d=2;var W=1,f=2,g=4,h=8,i=16,j=32,k=64,l=128,m=256,o=512;var p=800,q=16;var I=1/0,r=9007199254740991,s=1.7976931348623157e+308,N=0/0;var t=4294967295;var w=[['ary',l],['bind',W],['bindKey',f],['curry',h],['curryRight',i],['flip',o],['partial',j],['partialRight',k],['rearg',m]];var v='[object Arguments]',x='[object Array]',y='[object AsyncFunction]',z='[object Boolean]',A='[object Date]',B='[object Error]',D='[object Function]',E='[object GeneratorFunction]',G='[object Map]',J='[object Number]',K='[object Null]',O='[object Object]',Q='[object Promise]',R='[object Proxy]',S='[object RegExp]',T='[object Set]',U='[object String]',X='[object Symbol]',Y='[object Undefined]',Z='[object WeakMap]';var $='[object ArrayBuffer]',_='[object DataView]',a1='[object Float32Array]',b1='[object Float64Array]',c1='[object Int8Array]',d1='[object Int16Array]',e1='[object Int32Array]',f1='[object Uint8Array]',g1='[object Uint8ClampedArray]',h1='[object Uint16Array]',i1='[object Uint32Array]';var j1=/\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/,k1=/^\w*$/,l1=/[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g;var m1=/[\\^$.*+?()[\]{}|]/g;var n1=/^\s+|\s+$/g;var o1=/\{(?:\n\/\* \[wrapped with .+\] \*\/)?\n?/,p1=/\{\n\/\* \[wrapped with (.+)\] \*/,q1=/,? & /;var r1=/\\(\\)?/g;var s1=/\w*$/;var t1=/^[-+]0x[0-9a-f]+$/i;var u1=/^0b[01]+$/i;var v1=/^\[object .+?Constructor\]$/;var w1=/^0o[0-7]+$/i;var x1=/^(?:0|[1-9]\d*)$/;var y1='\\ud800-\\udfff',z1='\\u0300-\\u036f',A1='\\ufe20-\\ufe2f',B1='\\u20d0-\\u20ff',C1=z1+A1+B1,D1='\\ufe0e\\ufe0f';var E1='['+y1+']',F1='['+C1+']',G1='\\ud83c[\\udffb-\\udfff]',H1='(?:'+F1+'|'+G1+')',I1='[^'+y1+']',J1='(?:\\ud83c[\\udde6-\\uddff]){2}',K1='[\\ud800-\\udbff][\\udc00-\\udfff]',L1='\\u200d';var M1=H1+'?',N1='['+D1+']?',O1='(?:'+L1+'(?:'+[I1,J1,K1].join('|')+')'+N1+M1+')*',P1=N1+M1+O1,Q1='(?:'+[I1+F1+'?',F1,J1,K1,E1].join('|')+')';var R1=RegExp(G1+'(?='+G1+')|'+Q1+P1,'g');var S1=RegExp('['+L1+y1+C1+D1+']');var T1={};T1[a1]=T1[b1]=T1[c1]=T1[d1]=T1[e1]=T1[f1]=T1[g1]=T1[h1]=T1[i1]=true;T1[v]=T1[x]=T1[$]=T1[z]=T1[_]=T1[A]=T1[B]=T1[D]=T1[G]=T1[J]=T1[O]=T1[S]=T1[T]=T1[U]=T1[Z]=false;var U1={};U1[v]=U1[x]=U1[$]=U1[_]=U1[z]=U1[A]=U1[a1]=U1[b1]=U1[c1]=U1[d1]=U1[e1]=U1[G]=U1[J]=U1[O]=U1[S]=U1[T]=U1[U]=U1[X]=U1[f1]=U1[g1]=U1[h1]=U1[i1]=true;U1[B]=U1[D]=U1[Z]=false;var V1=parseInt;var W1=typeof global=='object'&&global&&global.Object===Object&&global;var X1=typeof self=='object'&&self&&self.Object===Object&&self;var Y1=W1||X1||Function('return this')();var Z1=typeof exports=='object'&&exports&&!exports.nodeType&&exports;var $1=Z1&&typeof module=='object'&&module&&!module.nodeType&&module;var _1=$1&&$1.exports===Z1;var a2=_1&&W1.process;var b2=(function(){try{var n=$1&&$1.require&&$1.require('util').types;if(n){return n;}return a2&&a2.binding&&a2.binding('util');}catch(e){}}());var c2=b2&&b2.isMap,d2=b2&&b2.isSet,e2=b2&&b2.isTypedArray;
function f2(e,n,Y6){switch(Y6.length){case 0:return e.call(n);case 1:return e.call(n,Y6[0]);case 2:return e.call(n,Y6[0],Y6[1]);case 3:return e.call(n,Y6[0],Y6[1],Y6[2]);}return e.apply(n,Y6);}
function g2(e,H7){var n=-1,Y6=e==null?0:e.length;while(++n<Y6){if(H7(e[n],n,e)===false){break;}}return e;}
function h2(e,n){var Y6=-1,O7=e==null?0:e.length,P7=0,Q7=[];while(++Y6<O7){var R7=e[Y6];if(n(R7,Y6,e)){Q7[P7++]=R7;}}return Q7;}
function i2(e,n){var Y6=e==null?0:e.length;return!!Y6&&p2(e,n,0)>-1;}
function j2(e,n,Y6){var O7=-1,P7=e==null?0:e.length;while(++O7<P7){if(Y6(n,e[O7])){return true;}}return false;}
function k2(e,H7){var n=-1,Y6=e==null?0:e.length,O7=Array(Y6);while(++n<Y6){O7[n]=H7(e[n],n,e);}return O7;}
function l2(e,E7){var n=-1,Y6=E7.length,O7=e.length;while(++n<Y6){e[O7+n]=E7[n];}return e;}
function m2(e,n){var Y6=-1,O7=e==null?0:e.length;while(++Y6<O7){if(n(e[Y6],Y6,e)){return true;}}return false;}
function n2(e){return e.split('');}
function o2(e,n,Y6,O7){var P7=e.length,Q7=Y6+(O7?1:-1);while((O7?Q7--:++Q7<P7)){if(n(e[Q7],Q7,e)){return Q7;}}return-1;}
function p2(e,n,Y6){return n===n?E2(e,n,Y6):o2(e,q2,Y6);}
function q2(e){return e!==e;}
function r2(e){return function(n){return n==null?u:n[e];};}
function s2(n,H7){var e=-1,Y6=Array(n);while(++e<n){Y6[e]=H7(e);}return Y6;}
function t2(e){return function(n){return e(n);};}
function u2(e,n){return k2(n,function(Y6){return e[Y6];});}
function v2(e,n){return e.has(n);}
function w2(e,n){var Y6=e.length,O7=0;while(Y6--){if(e[Y6]===n){++O7;}}return O7;}
function x2(e,n){return e==null?u:e[n];}
function y2(e){return S1.test(e);}
function z2(e){var n,Y6=[];while(!(n=e.next()).done){Y6.push(n.value);}return Y6;}
function A2(R6){var e=-1,n=Array(R6.size);R6.forEach(function(Y6,O7){n[++e]=[O7,Y6];});return n;}
function B2(e,n){return function(Y6){return e(n(Y6));};}
function C2(e,n){var Y6=-1,O7=e.length,P7=0,Q7=[];while(++Y6<O7){var R7=e[Y6];if(R7===n||R7===P){e[Y6]=P;Q7[P7++]=Y6;}}return Q7;}
function D2(e){var n=-1,Y6=Array(e.size);e.forEach(function(O7){Y6[++n]=O7;});return Y6;}
function E2(e,n,Y6){var O7=Y6-1,P7=e.length;while(++O7<P7){if(e[O7]===n){return O7;}}return-1;}
function F2(e){return y2(e)?G2(e):n2(e);}
function G2(e){return e.match(R1)||[];}
var H2=Array.prototype,I2=Function.prototype,J2=Object.prototype;var K2=Y1['__core-js_shared__'];var L2=I2.toString;var M2=J2.hasOwnProperty;var N2=(function(){var e=/[^.]+$/.exec(K2&&K2.keys&&K2.keys.IE_PROTO||'');return e?('Symbol(src)_1.'+e):'';}());var O2=J2.toString;var P2=L2.call(Object);var Q2=RegExp('^'+L2.call(M2).replace(m1,'\\$&').replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g,'$1.*?')+'$');var R2=_1?Y1.Buffer:u,S2=Y1.Symbol,T2=Y1.Uint8Array,U2=R2?R2.allocUnsafe:u,V2=B2(Object.getPrototypeOf,Object),W2=Object.create,X2=J2.propertyIsEnumerable,Y2=H2.splice,Z2=S2?S2.isConcatSpreadable:u,$2=S2?S2.iterator:u,_2=S2?S2.toStringTag:u;var a3=(function(){try{var n=I5(Object,'defineProperty');n({},'',{});return n;}catch(e){}}());var b3=Object.getOwnPropertySymbols,c3=R2?R2.isBuffer:u,d3=B2(Object.keys,Object),e3=Math.max,f3=Math.min,g3=Date.now;var h3=I5(Y1,'DataView'),i3=I5(Y1,'Map'),j3=I5(Y1,'Promise'),k3=I5(Y1,'Set'),l3=I5(Y1,'WeakMap'),m3=I5(Object,'create');var n3=l3&&new l3;var o3={};var p3=p6(h3),q3=p6(i3),r3=p6(j3),s3=p6(k3),t3=p6(l3);var u3=S2?S2.prototype:u,v3=u3?u3.valueOf:u,w3=u3?u3.toString:u;
function x3(){}
var y3=(function(){function e(){}return function(n){if(!g7(n)){return{};}if(W2){return W2(n);}e.prototype=n;var Y6=new e;e.prototype=u;return Y6;};}());
function z3(){}
function A3(e){this.__wrapped__=e;this.__actions__=[];this.__dir__=1;this.__filtered__=false;this.__iteratees__=[];this.__takeCount__=t;this.__views__=[];}
A3.prototype=y3(z3.prototype);A3.prototype.constructor=A3;
function B3(e){var n=-1,Y6=e==null?0:e.length;this.clear();while(++n<Y6){var O7=e[n];this.set(O7[0],O7[1]);}}
function C3(){this.__data__=m3?m3(null):{};this.size=0;}
function D3(e){var n=this.has(e)&&delete this.__data__[e];this.size-=n?1:0;return n;}
function E3(e){var n=this.__data__;if(m3){var Y6=n[e];return Y6===H?u:Y6;}return M2.call(n,e)?n[e]:u;}
function F3(e){var n=this.__data__;return m3?(n[e]!==u):M2.call(n,e);}
function G3(e,n){var Y6=this.__data__;this.size+=this.has(e)?0:1;Y6[e]=(m3&&n===u)?H:n;return this;}
B3.prototype.clear=C3;B3.prototype['delete']=D3;B3.prototype.get=E3;B3.prototype.has=F3;B3.prototype.set=G3;
function H3(e){var n=-1,Y6=e==null?0:e.length;this.clear();while(++n<Y6){var O7=e[n];this.set(O7[0],O7[1]);}}
function I3(){this.__data__=[];this.size=0;}
function J3(e){var n=this.__data__,Y6=d4(n,e);if(Y6<0){return false;}var O7=n.length-1;if(Y6==O7){n.pop();}else{Y2.call(n,Y6,1);}--this.size;return true;}
function K3(e){var n=this.__data__,Y6=d4(n,e);return Y6<0?u:n[Y6][1];}
function L3(e){return d4(this.__data__,e)>-1;}
function M3(e,n){var Y6=this.__data__,O7=d4(Y6,e);if(O7<0){++this.size;Y6.push([e,n]);}else{Y6[O7][1]=n;}return this;}
H3.prototype.clear=I3;H3.prototype['delete']=J3;H3.prototype.get=K3;H3.prototype.has=L3;H3.prototype.set=M3;
function N3(e){var n=-1,Y6=e==null?0:e.length;this.clear();while(++n<Y6){var O7=e[n];this.set(O7[0],O7[1]);}}
function O3(){this.size=0;this.__data__={'hash':new B3,'map':new(i3||H3),'string':new B3};}
function P3(e){var n=G5(this,e)['delete'](e);this.size-=n?1:0;return n;}
function Q3(e){return G5(this,e).get(e);}
function R3(e){return G5(this,e).has(e);}
function S3(e,n){var Y6=G5(this,e),O7=Y6.size;Y6.set(e,n);this.size+=Y6.size==O7?0:1;return this;}
N3.prototype.clear=O3;N3.prototype['delete']=P3;N3.prototype.get=Q3;N3.prototype.has=R3;N3.prototype.set=S3;
function T3(E7){var e=-1,n=E7==null?0:E7.length;this.__data__=new N3;while(++e<n){this.add(E7[e]);}}
function U3(e){this.__data__.set(e,H);return this;}
function V3(e){return this.__data__.has(e);}
T3.prototype.add=T3.prototype.push=U3;T3.prototype.has=V3;
function W3(e){var n=this.__data__=new H3(e);this.size=n.size;}
function X3(){this.__data__=new H3;this.size=0;}
function Y3(e){var n=this.__data__,Y6=n['delete'](e);this.size=n.size;return Y6;}
function Z3(e){return this.__data__.get(e);}
function $3(e){return this.__data__.has(e);}
function _3(e,n){var Y6=this.__data__;if(Y6 instanceof H3){var O7=Y6.__data__;if(!i3||(O7.length<L-1)){O7.push([e,n]);this.size=++Y6.size;return this;}Y6=this.__data__=new N3(O7);}Y6.set(e,n);this.size=Y6.size;return this;}
W3.prototype.clear=X3;W3.prototype['delete']=Y3;W3.prototype.get=Z3;W3.prototype.has=$3;W3.prototype.set=_3;
function a4(e,n){var Y6=$6(e),O7=!Y6&&Z6(e),P7=!Y6&&!O7&&b7(e),Q7=!Y6&&!O7&&!P7&&o7(e),R7=Y6||O7||P7||Q7,S7=R7?s2(e.length,String):[],T7=S7.length;for(var U7 in e){if((n||M2.call(e,U7))&&!(R7&&(U7=='length'||(P7&&(U7=='offset'||U7=='parent'))||(Q7&&(U7=='buffer'||U7=='byteLength'||U7=='byteOffset'))||U5(U7,T7)))){S7.push(U7);}}return S7;}
function b4(e,n,Y6){if((Y6!==u&&!eq(e[n],Y6))||(Y6===u&&!(n in e))){g4(e,n,Y6);}}
function c4(e,n,Y6){var O7=e[n];if(!(M2.call(e,n)&&eq(O7,Y6))||(Y6===u&&!(n in e))){g4(e,n,Y6);}}
function d4(e,n){var Y6=e.length;while(Y6--){if(eq(e[Y6][0],n)){return Y6;}}return-1;}
function e4(e,n){return e&&h5(n,x7(n),e);}
function f4(e,n){return e&&h5(n,y7(n),e);}
function g4(e,n,Y6){if(n=='__proto__'&&a3){a3(e,n,{'configurable':true,'enumerable':true,'value':Y6,'writable':true});}else{e[n]=Y6;}}
function h4(e,n,Y6,O7,P7,Q7){var R7,S7=n&C,T7=n&a,U7=n&b;if(Y6){R7=P7?Y6(e,O7,P7,Q7):Y6(e);}if(R7!==u){return R7;}if(!g7(e)){return e;}var V7=$6(e);if(V7){R7=P5(e);if(!S7){return g5(e,R7);}}else{var W7=M5(e),X7=W7==D||W7==E;if(b7(e)){return $4(e,S7);}if(W7==O||W7==v||(X7&&!P7)){R7=(T7||X7)?{}:Q5(e);if(!S7){return T7?j5(e,f4(R7,e)):i5(e,e4(R7,e));}}else{if(!U1[W7]){return P7?e:{};}R7=R5(e,W7,S7);}}Q7||(Q7=new W3);var Y7=Q7.get(e);if(Y7){return Y7;}Q7.set(e,R7);if(l7(e)){e.forEach(function(_7){R7.add(h4(_7,n,Y6,_7,e,Q7));});}else if(i7(e)){e.forEach(function(_7,O7){R7.set(O7,h4(_7,n,Y6,O7,e,Q7));});}var Z7=U7?(T7?B5:A5):(T7?y7:x7);var $7=V7?u:Z7(e);g2($7||e,function(_7,O7){if($7){O7=_7;_7=e[O7];}c4(R7,O7,h4(_7,n,Y6,O7,e,Q7));});return R7;}
function i4(e,E7,H7,n){var Y6=-1,O7=i2,P7=true,Q7=e.length,R7=[],S7=E7.length;if(!Q7){return R7;}if(H7){E7=k2(E7,t2(H7));}if(n){O7=j2;P7=false;}else if(E7.length>=L){O7=v2;P7=false;E7=new T3(E7);}outer:while(++Y6<Q7){var T7=e[Y6],U7=H7==null?T7:H7(T7);T7=(n||T7!==0)?T7:0;if(P7&&U7===U7){var V7=S7;while(V7--){if(E7[V7]===U7){continue outer;}}R7.push(T7);}else if(!O7(E7,U7,n)){R7.push(T7);}}return R7;}
var j4=l5(n4);
function k4(e,H7,n){var Y6=-1,O7=e.length;while(++Y6<O7){var P7=e[Y6],Q7=H7(P7);if(Q7!=null&&(R7===u?(Q7===Q7&&!n7(Q7)):n(Q7,R7))){var R7=Q7,S7=P7;}}return S7;}
function l4(e,n,Y6,O7,P7){var Q7=-1,R7=e.length;Y6||(Y6=T5);P7||(P7=[]);while(++Q7<R7){var S7=e[Q7];if(n>0&&Y6(S7)){if(n>1){l4(S7,n-1,Y6,O7,P7);}else{l2(P7,S7);}}else if(!O7){P7[P7.length]=S7;}}return P7;}
var m4=m5();
function n4(e,H7){return e&&m4(e,H7,x7);}
function o4(e,n){n=Z4(n,e);var Y6=0,O7=n.length;while(e!=null&&Y6<O7){e=e[o6(n[Y6++])];}return(Y6&&Y6==O7)?e:u;}
function p4(e,n,Y6){var O7=n(e);return $6(e)?O7:l2(O7,Y6(e));}
function q4(e){if(e==null){return e===u?Y:K;}return(_2&&_2 in Object(e))?J5(e):e6(e);}
function r4(e,n){return e>n;}
function s4(e,n){return e!=null&&n in Object(e);}
function t4(e,H7,n){var Y6=n?j2:i2,O7=e[0].length,P7=e.length,Q7=P7,R7=Array(P7),S7=Infinity,T7=[];while(Q7--){var U7=e[Q7];if(Q7&&H7){U7=k2(U7,t2(H7));}S7=f3(U7.length,S7);R7[Q7]=!n&&(H7||(O7>=120&&U7.length>=120))?new T3(Q7&&U7):u;}U7=e[0];var V7=-1,W7=R7[0];outer:while(++V7<O7&&T7.length<S7){var X7=U7[V7],Y7=H7?H7(X7):X7;X7=(n||X7!==0)?X7:0;if(!(W7?v2(W7,Y7):Y6(T7,Y7,n))){Q7=P7;while(--Q7){var Z7=R7[Q7];if(!(Z7?v2(Z7,Y7):Y6(e[Q7],Y7,n))){continue outer;}}if(W7){W7.push(Y7);}T7.push(X7);}}return T7;}
function u4(e){return h7(e)&&q4(e)==v;}
function v4(e,n,Y6,O7,P7){if(e===n){return true;}if(e==null||n==null||(!h7(e)&&!h7(n))){return e!==e&&n!==n;}return w4(e,n,Y6,O7,v4,P7);}
function w4(e,n,Y6,O7,P7,Q7){var R7=$6(e),S7=$6(n),T7=R7?x:M5(e),U7=S7?x:M5(n);T7=T7==v?O:T7;U7=U7==v?O:U7;var V7=T7==O,W7=U7==O,X7=T7==U7;if(X7&&b7(e)){if(!b7(n)){return false;}R7=true;V7=false;}if(X7&&!V7){Q7||(Q7=new W3);return(R7||o7(e))?w5(e,n,Y6,O7,P7,Q7):x5(e,n,T7,Y6,O7,P7,Q7);}if(!(Y6&c)){var Y7=V7&&M2.call(e,'__wrapped__'),Z7=W7&&M2.call(n,'__wrapped__');if(Y7||Z7){var $7=Y7?e.value():e,_7=Z7?n.value():n;Q7||(Q7=new W3);return P7($7,_7,Y6,O7,Q7);}}if(!X7){return false;}Q7||(Q7=new W3);return y5(e,n,Y6,O7,P7,Q7);}
function x4(e){return h7(e)&&M5(e)==G;}
function y4(e,n,Y6,O7){var P7=Y6.length,Q7=P7,R7=!O7;if(e==null){return!Q7;}e=Object(e);while(P7--){var S7=Y6[P7];if((R7&&S7[2])?S7[1]!==e[S7[0]]:!(S7[0]in e)){return false;}}while(++P7<Q7){S7=Y6[P7];var T7=S7[0],U7=e[T7],V7=S7[1];if(R7&&S7[2]){if(U7===u&&!(T7 in e)){return false;}}else{var W7=new W3;if(O7){var X7=O7(U7,V7,T7,e,n,W7);}if(!(X7===u?v4(V7,U7,c|d,O7,W7):X7)){return false;}}}return true;}
function z4(e){if(!g7(e)||Z5(e)){return false;}var n=e7(e)?Q2:v1;return n.test(p6(e));}
function A4(e){return h7(e)&&M5(e)==T;}
function B4(e){return h7(e)&&f7(e.length)&&!!T1[q4(e)];}
function C4(e){if(typeof e=='function'){return e;}if(e==null){return G7;}if(typeof e=='object'){return $6(e)?I4(e[0],e[1]):H4(e);}return J7(e);}
function D4(e){if(!$5(e)){return d3(e);}var n=[];for(var Y6 in Object(e)){if(M2.call(e,Y6)&&Y6!='constructor'){n.push(Y6);}}return n;}
function E4(e){if(!g7(e)){return d6(e);}var n=$5(e),Y6=[];for(var O7 in e){if(!(O7=='constructor'&&(n||!M2.call(e,O7)))){Y6.push(O7);}}return Y6;}
function F4(e,n){return e<n;}
function G4(e,H7){var n=-1,Y6=_6(e)?Array(e.length):[];j4(e,function(O7,P7,e){Y6[++n]=H7(O7,P7,e);});return Y6;}
function H4(e){var n=H5(e);if(n.length==1&&n[0][2]){return a6(n[0][0],n[0][1]);}return function(Y6){return Y6===e||y4(Y6,e,n);};}
function I4(e,n){if(W5(e)&&_5(n)){return a6(o6(e),n);}return function(Y6){var O7=v7(Y6,e);return(O7===u&&O7===n)?w7(Y6,e):v4(n,O7,c|d);};}
function J4(e,n,Y6,O7,P7){if(e===n){return;}m4(n,function(Q7,R7){P7||(P7=new W3);if(g7(Q7)){K4(e,n,R7,Y6,J4,O7,P7);}else{var S7=O7?O7(i6(e,R7),Q7,(R7+''),e,n,P7):u;if(S7===u){S7=Q7;}b4(e,R7,S7);}},y7);}
function K4(e,n,Y6,O7,P7,Q7,R7){var S7=i6(e,Y6),T7=i6(n,Y6),U7=R7.get(T7);if(U7){b4(e,Y6,U7);return;}var V7=Q7?Q7(S7,T7,(Y6+''),e,n,R7):u;var W7=V7===u;if(W7){var X7=$6(T7),Y7=!X7&&b7(T7),Z7=!X7&&!Y7&&o7(T7);V7=T7;if(X7||Y7||Z7){if($6(S7)){V7=S7;}else if(a7(S7)){V7=g5(S7);}else if(Y7){W7=false;V7=$4(T7,true);}else if(Z7){W7=false;V7=d5(T7,true);}else{V7=[];}}else if(k7(T7)||Z6(T7)){V7=S7;if(Z6(S7)){V7=t7(S7);}else if(!g7(S7)||e7(S7)){V7=Q5(T7);}}else{W7=false;}}if(W7){R7.set(T7,V7);P7(V7,T7,O7,Q7,R7);R7['delete'](T7);}b4(e,Y6,V7);}
function L4(e,n){return M4(e,n,function(Y6,O7){return w7(e,O7);});}
function M4(e,n,Y6){var O7=-1,P7=n.length,Q7={};while(++O7<P7){var R7=n[O7],S7=o4(e,R7);if(Y6(S7,R7)){P4(Q7,Z4(R7,e),S7);}}return Q7;}
function N4(e){return function(n){return o4(n,e);};}
function O4(e,n){return k6(f6(e,n,G7),e+'');}
function P4(e,n,Y6,O7){if(!g7(e)){return e;}n=Z4(n,e);var P7=-1,Q7=n.length,R7=Q7-1,S7=e;while(S7!=null&&++P7<Q7){var T7=o6(n[P7]),U7=Y6;if(T7==='__proto__'||T7==='constructor'||T7==='prototype'){return e;}if(P7!=R7){var V7=S7[T7];U7=O7?O7(V7,T7,S7):u;if(U7===u){U7=g7(V7)?V7:(U5(n[P7+1])?[]:{});}}c4(S7,T7,U7);S7=S7[T7];}return e;}
var Q4=!n3?G7:function(e,n){n3.set(e,n);return e;};var R4=!a3?G7:function(e,n){return a3(e,'toString',{'configurable':true,'enumerable':false,'value':F7(n),'writable':true});};
function S4(e,n,Y6){var O7=-1,P7=e.length;if(n<0){n=-n>P7?0:(P7+n);}Y6=Y6>P7?P7:Y6;if(Y6<0){Y6+=P7;}P7=n>Y6?0:((Y6-n)>>>0);n>>>=0;var Q7=Array(P7);while(++O7<P7){Q7[O7]=e[O7+n];}return Q7;}
function T4(e){if(typeof e=='string'){return e;}if($6(e)){return k2(e,T4)+'';}if(n7(e)){return w3?w3.call(e):'';}var n=(e+'');return(n=='0'&&(1/e)==-I)?'-0':n;}
function U4(e,H7,n){var Y6=-1,O7=i2,P7=e.length,Q7=true,R7=[],S7=R7;if(n){Q7=false;O7=j2;}else if(P7>=L){var T7=H7?null:t5(e);if(T7){return D2(T7);}Q7=false;O7=v2;S7=new T3;}else{S7=H7?[]:R7;}outer:while(++Y6<P7){var U7=e[Y6],V7=H7?H7(U7):U7;U7=(n||U7!==0)?U7:0;if(Q7&&V7===V7){var W7=S7.length;while(W7--){if(S7[W7]===V7){continue outer;}}if(H7){S7.push(V7);}R7.push(U7);}else if(!O7(S7,V7,n)){if(S7!==R7){S7.push(V7);}R7.push(U7);}}return R7;}
function V4(e,n){n=Z4(n,e);e=g6(e,n);return e==null||delete e[o6(B6(n))];}
function W4(e,H7,n){var Y6=e.length;if(Y6<2){return Y6?U4(e[0]):[];}var O7=-1,P7=Array(Y6);while(++O7<Y6){var Q7=e[O7],R7=-1;while(++R7<Y6){if(R7!=O7){P7[O7]=i4(P7[O7]||Q7,e[R7],H7,n);}}}return U4(l4(P7,1),H7,n);}
function X4(e,E7,n){var Y6=-1,O7=e.length,P7=E7.length,Q7={};while(++Y6<O7){var R7=Y6<P7?E7[Y6]:u;n(Q7,e[Y6],R7);}return Q7;}
function Y4(e){return a7(e)?e:[];}
function Z4(e,n){if($6(e)){return e;}return W5(e,n)?[e]:n6(u7(e));}
function $4(e,n){if(n){return e.slice();}var Y6=e.length,O7=U2?U2(Y6):new e.constructor(Y6);e.copy(O7);return O7;}
function _4(e){var n=new e.constructor(e.byteLength);new T2(n).set(new T2(e));return n;}
function a5(e,n){var Y6=n?_4(e.buffer):e.buffer;return new e.constructor(Y6,e.byteOffset,e.byteLength);}
function b5(e){var n=new e.constructor(e.source,s1.exec(e));n.lastIndex=e.lastIndex;return n;}
function c5(e){return v3?Object(v3.call(e)):{};}
function d5(e,n){var Y6=n?_4(e.buffer):e.buffer;return new e.constructor(Y6,e.byteOffset,e.length);}
function e5(e,n,Y6,O7){var P7=-1,Q7=e.length,R7=Y6.length,S7=-1,T7=n.length,U7=e3(Q7-R7,0),V7=Array(T7+U7),W7=!O7;while(++S7<T7){V7[S7]=n[S7];}while(++P7<R7){if(W7||P7<Q7){V7[Y6[P7]]=e[P7];}}while(U7--){V7[S7++]=e[P7++];}return V7;}
function f5(e,n,Y6,O7){var P7=-1,Q7=e.length,R7=-1,S7=Y6.length,T7=-1,U7=n.length,V7=e3(Q7-S7,0),W7=Array(V7+U7),X7=!O7;while(++P7<V7){W7[P7]=e[P7];}var Y7=P7;while(++T7<U7){W7[Y7+T7]=n[T7];}while(++R7<S7){if(X7||P7<Q7){W7[Y7+Y6[R7]]=e[P7++];}}return W7;}
function g5(e,n){var Y6=-1,O7=e.length;n||(n=Array(O7));while(++Y6<O7){n[Y6]=e[Y6];}return n;}
function h5(e,n,Y6,O7){var P7=!Y6;Y6||(Y6={});var Q7=-1,R7=n.length;while(++Q7<R7){var S7=n[Q7];var T7=O7?O7(Y6[S7],e[S7],S7,Y6,e):u;if(T7===u){T7=e[S7];}if(P7){g4(Y6,S7,T7);}else{c4(Y6,S7,T7);}}return Y6;}
function i5(e,n){return h5(e,K5(e),n);}
function j5(e,n){return h5(e,L5(e),n);}
function k5(e){return O4(function(n,Y6){var O7=-1,P7=Y6.length,Q7=P7>1?Y6[P7-1]:u,R7=P7>2?Y6[2]:u;Q7=(e.length>3&&typeof Q7=='function')?(P7--,Q7):u;if(R7&&V5(Y6[0],Y6[1],R7)){Q7=P7<3?u:Q7;P7=1;}n=Object(n);while(++O7<P7){var S7=Y6[O7];if(S7){e(n,S7,O7,Q7);}}return n;});}
function l5(e,n){return function(Y6,H7){if(Y6==null){return Y6;}if(!_6(Y6)){return e(Y6,H7);}var O7=Y6.length,P7=n?O7:-1,Q7=Object(Y6);while((n?P7--:++P7<O7)){if(H7(Q7[P7],P7,Q7)===false){break;}}return Y6;};}
function m5(e){return function(n,H7,Y6){var O7=-1,P7=Object(n),Q7=Y6(n),R7=Q7.length;while(R7--){var S7=Q7[e?R7:++O7];if(H7(P7[S7],S7,P7)===false){break;}}return n;};}
function n5(e,n,Y6){var O7=n&W,P7=o5(e);function Q7(){var fn=(this&&this!==Y1&&this instanceof Q7)?P7:e;return fn.apply(O7?Y6:this,arguments);}return Q7;}
function o5(e){return function(){var n=arguments;switch(n.length){case 0:return new e;case 1:return new e(n[0]);case 2:return new e(n[0],n[1]);case 3:return new e(n[0],n[1],n[2]);case 4:return new e(n[0],n[1],n[2],n[3]);case 5:return new e(n[0],n[1],n[2],n[3],n[4]);case 6:return new e(n[0],n[1],n[2],n[3],n[4],n[5]);case 7:return new e(n[0],n[1],n[2],n[3],n[4],n[5],n[6]);}var Y6=y3(e.prototype),O7=e.apply(Y6,n);return g7(O7)?O7:Y6;};}
function p5(e,n,Y6){var O7=o5(e);function P7(){var Q7=arguments.length,R7=Array(Q7),S7=Q7,T7=E5(P7);while(S7--){R7[S7]=arguments[S7];}var U7=(Q7<3&&R7[0]!==T7&&R7[Q7-1]!==T7)?[]:C2(R7,T7);Q7-=U7.length;if(Q7<Y6){return s5(e,n,q5,P7.placeholder,u,R7,U7,u,u,Y6-Q7);}var fn=(this&&this!==Y1&&this instanceof P7)?O7:e;return f2(fn,this,R7);}return P7;}
function q5(e,n,Y6,O7,P7,Q7,R7,S7,T7,U7){var V7=n&l,W7=n&W,X7=n&f,Y7=n&(h|i),Z7=n&o,$7=X7?u:o5(e);function _7(){var a8=arguments.length,b8=Array(a8),c8=a8;while(c8--){b8[c8]=arguments[c8];}if(Y7){var d8=E5(_7),e8=w2(b8,d8);}if(O7){b8=e5(b8,O7,P7,Y7);}if(Q7){b8=f5(b8,Q7,R7,Y7);}a8-=e8;if(Y7&&a8<U7){var f8=C2(b8,d8);return s5(e,n,q5,_7.placeholder,Y6,b8,f8,S7,T7,U7-a8);}var g8=W7?Y6:this,fn=X7?g8[e]:e;a8=b8.length;if(S7){b8=h6(b8,S7);}else if(Z7&&a8>1){b8.reverse();}if(V7&&T7<a8){b8.length=T7;}if(this&&this!==Y1&&this instanceof _7){fn=$7||o5(fn);}return fn.apply(g8,b8);}return _7;}
function r5(e,n,Y6,O7){var P7=n&W,Q7=o5(e);function R7(){var S7=-1,T7=arguments.length,U7=-1,V7=O7.length,W7=Array(V7+T7),fn=(this&&this!==Y1&&this instanceof R7)?Q7:e;while(++U7<V7){W7[U7]=O7[U7];}while(T7--){W7[U7++]=arguments[++S7];}return f2(fn,P7?Y6:this,W7);}return R7;}
function s5(e,n,Y6,O7,P7,Q7,R7,S7,T7,U7){var V7=n&h,W7=V7?R7:u,X7=V7?u:R7,Y7=V7?Q7:u,Z7=V7?u:Q7;n|=(V7?j:k);n&=~(V7?k:j);if(!(n&g)){n&=~(W|f);}var $7=[e,n,P7,Y7,W7,Z7,X7,S7,T7,U7];var _7=Y6.apply(u,$7);if(Y5(e)){j6(_7,$7);}_7.placeholder=O7;return l6(_7,e,n);}
var t5=!(k3&&(1/D2(new k3([,-0]))[1])==I)?I7:function(E7){return new k3(E7);};
function u5(e,n,Y6,O7,P7,Q7,R7,S7){var T7=n&f;if(!T7&&typeof e!='function'){throw new TypeError(F);}var U7=O7?O7.length:0;if(!U7){n&=~(j|k);O7=P7=u;}R7=R7===u?R7:e3(r7(R7),0);S7=S7===u?S7:r7(S7);U7-=P7?P7.length:0;if(n&k){var V7=O7,W7=P7;O7=P7=u;}var X7=T7?u:C5(e);var Y7=[e,n,Y6,O7,P7,V7,W7,Q7,R7,S7];if(X7){c6(Y7,X7);}e=Y7[0];n=Y7[1];Y6=Y7[2];O7=Y7[3];P7=Y7[4];S7=Y7[9]=Y7[9]===u?(T7?0:e.length):e3(Y7[9]-U7,0);if(!S7&&n&(h|i)){n&=~(h|i);}if(!n||n==W){var Z7=n5(e,n,Y6);}else if(n==h||n==i){Z7=p5(e,n,S7);}else if((n==j||n==(W|j))&&!P7.length){Z7=r5(e,n,Y6,O7);}else{Z7=q5.apply(u,Y7);}var $7=X7?Q4:j6;return l6($7(Z7,Y7),e,n);}
function v5(e){return k7(e)?u:e;}
function w5(e,n,Y6,O7,P7,Q7){var R7=Y6&c,S7=e.length,T7=n.length;if(S7!=T7&&!(R7&&T7>S7)){return false;}var U7=Q7.get(e);var V7=Q7.get(n);if(U7&&V7){return U7==n&&V7==e;}var W7=-1,X7=true,Y7=(Y6&d)?new T3:u;Q7.set(e,n);Q7.set(n,e);while(++W7<S7){var Z7=e[W7],$7=n[W7];if(O7){var _7=R7?O7($7,Z7,W7,n,e,Q7):O7(Z7,$7,W7,e,n,Q7);}if(_7!==u){if(_7){continue;}X7=false;break;}if(Y7){if(!m2(n,function($7,a8){if(!v2(Y7,a8)&&(Z7===$7||P7(Z7,$7,Y6,O7,Q7))){return Y7.push(a8);}})){X7=false;break;}}else if(!(Z7===$7||P7(Z7,$7,Y6,O7,Q7))){X7=false;break;}}Q7['delete'](e);Q7['delete'](n);return X7;}
function x5(e,n,Y6,O7,P7,Q7,R7){switch(Y6){case _:if((e.byteLength!=n.byteLength)||(e.byteOffset!=n.byteOffset)){return false;}e=e.buffer;n=n.buffer;case $:if((e.byteLength!=n.byteLength)||!Q7(new T2(e),new T2(n))){return false;}return true;case z:case A:case J:return eq(+e,+n);case B:return e.name==n.name&&e.message==n.message;case S:case U:return e==(n+'');case G:var S7=A2;case T:var T7=O7&c;S7||(S7=D2);if(e.size!=n.size&&!T7){return false;}var U7=R7.get(e);if(U7){return U7==n;}O7|=d;R7.set(e,n);var V7=w5(S7(e),S7(n),O7,P7,Q7,R7);R7['delete'](e);return V7;case X:if(v3){return v3.call(e)==v3.call(n);}}return false;}
function y5(e,n,Y6,O7,P7,Q7){var R7=Y6&c,S7=A5(e),T7=S7.length,U7=A5(n),V7=U7.length;if(T7!=V7&&!R7){return false;}var W7=T7;while(W7--){var X7=S7[W7];if(!(R7?X7 in n:M2.call(n,X7))){return false;}}var Y7=Q7.get(e);var Z7=Q7.get(n);if(Y7&&Z7){return Y7==n&&Z7==e;}var $7=true;Q7.set(e,n);Q7.set(n,e);var _7=R7;while(++W7<T7){X7=S7[W7];var a8=e[X7],b8=n[X7];if(O7){var c8=R7?O7(b8,a8,X7,n,e,Q7):O7(a8,b8,X7,e,n,Q7);}if(!(c8===u?(a8===b8||P7(a8,b8,Y6,O7,Q7)):c8)){$7=false;break;}_7||(_7=X7=='constructor');}if($7&&!_7){var d8=e.constructor,e8=n.constructor;if(d8!=e8&&('constructor'in e&&'constructor'in n)&&!(typeof d8=='function'&&d8 instanceof d8&&typeof e8=='function'&&e8 instanceof e8)){$7=false;}}Q7['delete'](e);Q7['delete'](n);return $7;}
function z5(e){return k6(f6(e,u,v6),e+'');}
function A5(e){return p4(e,x7,K5);}
function B5(e){return p4(e,y7,L5);}
var C5=!n3?I7:function(e){return n3.get(e);};
function D5(e){var n=(e.name+''),Y6=o3[n],O7=M2.call(o3,n)?Y6.length:0;while(O7--){var P7=Y6[O7],Q7=P7.func;if(Q7==null||Q7==e){return P7.name;}}return n;}
function E5(e){var n=M2.call(x3,'placeholder')?x3:e;return n.placeholder;}
function F5(){var e=x3.iteratee||H7;e=e===H7?C4:e;return arguments.length?e(arguments[0],arguments[1]):e;}
function G5(R6,e){var n=R6.__data__;return X5(e)?n[typeof e=='string'?'string':'hash']:n.map;}
function H5(e){var n=x7(e),Y6=n.length;while(Y6--){var O7=n[Y6],P7=e[O7];n[Y6]=[O7,P7,_5(P7)];}return n;}
function I5(e,n){var Y6=x2(e,n);return z4(Y6)?Y6:u;}
function J5(n){var Y6=M2.call(n,_2),O7=n[_2];try{n[_2]=u;var P7=true;}catch(e){}var Q7=O2.call(n);if(P7){if(Y6){n[_2]=O7;}else{delete n[_2];}}return Q7;}
var K5=!b3?K7:function(e){if(e==null){return[];}e=Object(e);return h2(b3(e),function(n){return X2.call(e,n);});};var L5=!b3?K7:function(e){var n=[];while(e){l2(n,K5(e));e=V2(e);}return n;};var M5=q4;if((h3&&M5(new h3(new ArrayBuffer(1)))!=_)||(i3&&M5(new i3)!=G)||(j3&&M5(j3.resolve())!=Q)||(k3&&M5(new k3)!=T)||(l3&&M5(new l3)!=Z)){M5=function(e){var n=q4(e),Y6=n==O?e.constructor:u,O7=Y6?p6(Y6):'';if(O7){switch(O7){case p3:return _;case q3:return G;case r3:return Q;case s3:return T;case t3:return Z;}}return n;};}
function N5(e){var n=e.match(p1);return n?n[1].split(q1):[];}
function O5(e,n,Y6){n=Z4(n,e);var O7=-1,P7=n.length,Q7=false;while(++O7<P7){var R7=o6(n[O7]);if(!(Q7=e!=null&&Y6(e,R7))){break;}e=e[R7];}if(Q7||++O7!=P7){return Q7;}P7=e==null?0:e.length;return!!P7&&f7(P7)&&U5(R7,P7)&&($6(e)||Z6(e));}
function P5(e){var n=e.length,Y6=new e.constructor(n);if(n&&typeof e[0]=='string'&&M2.call(e,'index')){Y6.index=e.index;Y6.input=e.input;}return Y6;}
function Q5(e){return(typeof e.constructor=='function'&&!$5(e))?y3(V2(e)):{};}
function R5(e,n,Y6){var O7=e.constructor;switch(n){case $:return _4(e);case z:case A:return new O7(+e);case _:return a5(e,Y6);case a1:case b1:case c1:case d1:case e1:case f1:case g1:case h1:case i1:return d5(e,Y6);case G:return new O7;case J:case U:return new O7(e);case S:return b5(e);case T:return new O7;case X:return c5(e);}}
function S5(e,n){var Y6=n.length;if(!Y6){return e;}var O7=Y6-1;n[O7]=(Y6>1?'& ':'')+n[O7];n=n.join(Y6>2?', ':' ');return e.replace(o1,'{\n/* [wrapped with '+n+'] */\n');}
function T5(e){return $6(e)||Z6(e)||!!(Z2&&e&&e[Z2]);}
function U5(e,n){var Y6=typeof e;n=n==null?r:n;return!!n&&(Y6=='number'||(Y6!='symbol'&&x1.test(e)))&&(e>-1&&e%1==0&&e<n);}
function V5(e,n,Y6){if(!g7(Y6)){return false;}var O7=typeof n;if(O7=='number'?(_6(Y6)&&U5(n,Y6.length)):(O7=='string'&&n in Y6)){return eq(Y6[n],e);}return false;}
function W5(e,n){if($6(e)){return false;}var Y6=typeof e;if(Y6=='number'||Y6=='symbol'||Y6=='boolean'||e==null||n7(e)){return true;}return k1.test(e)||!j1.test(e)||(n!=null&&e in Object(n));}
function X5(e){var n=typeof e;return(n=='string'||n=='number'||n=='symbol'||n=='boolean')?(e!=='__proto__'):(e===null);}
function Y5(e){var n=D5(e),Y6=x3[n];if(typeof Y6!='function'||!(n in A3.prototype)){return false;}if(e===Y6){return true;}var O7=C5(Y6);return!!O7&&e===O7[0];}
function Z5(e){return!!N2&&(N2 in e);}
function $5(e){var n=e&&e.constructor,Y6=(typeof n=='function'&&n.prototype)||J2;return e===Y6;}
function _5(e){return e===e&&!g7(e);}
function a6(e,n){return function(Y6){if(Y6==null){return false;}return Y6[e]===n&&(n!==u||(e in Object(Y6)));};}
function b6(e){var n=V6(e,function(O7){if(Y6.size===M){Y6.clear();}return O7;});var Y6=n.cache;return n;}
function c6(e,n){var Y6=e[1],O7=n[1],P7=Y6|O7,Q7=P7<(W|f|l);var R7=((O7==l)&&(Y6==h))||((O7==l)&&(Y6==m)&&(e[7].length<=n[8]))||((O7==(l|m))&&(n[7].length<=n[8])&&(Y6==h));if(!(Q7||R7)){return e;}if(O7&W){e[2]=n[2];P7|=Y6&W?0:g;}var S7=n[3];if(S7){var T7=e[3];e[3]=T7?e5(T7,S7,n[4]):S7;e[4]=T7?C2(e[3],P):n[4];}S7=n[5];if(S7){T7=e[5];e[5]=T7?f5(T7,S7,n[6]):S7;e[6]=T7?C2(e[5],P):n[6];}S7=n[7];if(S7){e[7]=S7;}if(O7&l){e[8]=e[8]==null?n[8]:f3(e[8],n[8]);}if(e[9]==null){e[9]=n[9];}e[0]=n[0];e[1]=P7;return e;}
function d6(e){var n=[];if(e!=null){for(var Y6 in Object(e)){n.push(Y6);}}return n;}
function e6(e){return O2.call(e);}
function f6(e,n,Y6){n=e3(n===u?(e.length-1):n,0);return function(){var O7=arguments,P7=-1,Q7=e3(O7.length-n,0),R7=Array(Q7);while(++P7<Q7){R7[P7]=O7[n+P7];}P7=-1;var S7=Array(n+1);while(++P7<n){S7[P7]=O7[P7];}S7[n]=Y6(R7);return f2(e,this,S7);};}
function g6(e,n){return n.length<2?e:o4(e,S4(n,0,-1));}
function h6(e,n){var Y6=e.length,O7=f3(n.length,Y6),P7=g5(e);while(O7--){var Q7=n[O7];e[O7]=U5(Q7,Y6)?P7[Q7]:u;}return e;}
function i6(e,n){if(n==='constructor'&&typeof e[n]==='function'){return;}if(n=='__proto__'){return;}return e[n];}
var j6=m6(Q4);var k6=m6(R4);
function l6(e,n,Y6){var O7=(n+'');return k6(e,S5(O7,q6(N5(O7),Y6)));}
function m6(e){var n=0,Y6=0;return function(){var O7=g3(),P7=q-(O7-Y6);Y6=O7;if(P7>0){if(++n>=p){return arguments[0];}}else{n=0;}return e.apply(u,arguments);};}
var n6=b6(function(e){var n=[];if(e.charCodeAt(0)===46){n.push('');}e.replace(l1,function(Y6,O7,P7,Q7){n.push(P7?Q7.replace(r1,'$1'):(O7||Y6));});return n;});
function o6(e){if(typeof e=='string'||n7(e)){return e;}var n=(e+'');return(n=='0'&&(1/e)==-I)?'-0':n;}
function p6(n){if(n!=null){try{return L2.call(n);}catch(e){}try{return(n+'');}catch(e){}}return'';}
function q6(e,n){g2(w,function(Y6){var O7='_.'+Y6[0];if((n&Y6[1])&&!i2(e,O7)){e.push(O7);}});return e.sort();}
function r6(e){var n=-1,Y6=e==null?0:e.length,O7=0,P7=[];while(++n<Y6){var Q7=e[n];if(Q7){P7[O7++]=Q7;}}return P7;}
var s6=O4(function(e,E7){return a7(e)?i4(e,l4(E7,1,a7,true)):[];});var t6=O4(function(e,E7){var H7=B6(E7);if(a7(H7)){H7=u;}return a7(e)?i4(e,l4(E7,1,a7,true),F5(H7,2)):[];});var u6=O4(function(e,E7){var n=B6(E7);if(a7(n)){n=u;}return a7(e)?i4(e,l4(E7,1,a7,true),u,n):[];});
function v6(e){var n=e==null?0:e.length;return n?l4(e,1):[];}
function w6(e){var n=e==null?0:e.length;return n?l4(e,I):[];}
function x6(e,n){var Y6=e==null?0:e.length;if(!Y6){return[];}n=n===u?1:r7(n);return l4(e,n);}
var y6=O4(function(e){var n=k2(e,Y4);return(n.length&&n[0]===e[0])?t4(n):[];});var z6=O4(function(e){var H7=B6(e),n=k2(e,Y4);if(H7===B6(n)){H7=u;}else{n.pop();}return(n.length&&n[0]===e[0])?t4(n,F5(H7,2)):[];});var A6=O4(function(e){var n=B6(e),Y6=k2(e,Y4);n=typeof n=='function'?n:u;if(n){Y6.pop();}return(Y6.length&&Y6[0]===e[0])?t4(Y6,u,n):[];});
function B6(e){var n=e==null?0:e.length;return n?e[n-1]:u;}
var C6=O4(function(e){return U4(l4(e,1,a7,true));});var D6=O4(function(e){var H7=B6(e);if(a7(H7)){H7=u;}return U4(l4(e,1,a7,true),F5(H7,2));});var E6=O4(function(e){var n=B6(e);n=typeof n=='function'?n:u;return U4(l4(e,1,a7,true),u,n);});
function F6(e){return(e&&e.length)?U4(e):[];}
function G6(e,H7){return(e&&e.length)?U4(e,F5(H7,2)):[];}
function H6(e,n){n=typeof n=='function'?n:u;return(e&&e.length)?U4(e,u,n):[];}
var I6=O4(function(e,E7){return a7(e)?i4(e,E7):[];});var J6=O4(function(e){return W4(h2(e,a7));});var K6=O4(function(e){var H7=B6(e);if(a7(H7)){H7=u;}return W4(h2(e,a7),F5(H7,2));});var L6=O4(function(e){var n=B6(e);n=typeof n=='function'?n:u;return W4(h2(e,a7),u,n);});
function M6(e,E7){return X4(e||[],E7||[],c4);}
function N6(e,E7){return X4(e||[],E7||[],P4);}
function O6(e,H7){return l4(R6(e,H7),1);}
function P6(e,H7){return l4(R6(e,H7),I);}
function Q6(e,H7,n){n=n===u?1:r7(n);return l4(R6(e,H7),n);}
function R6(e,H7){var n=$6(e)?k2:G4;return n(e,F5(H7,3));}
var S6=function(){return Y1.Date.now();};
function T6(e,n,Y6){n=Y6?u:n;var O7=u5(e,h,u,u,u,u,u,n);O7.placeholder=T6.placeholder;return O7;}
function U6(e,n,Y6){var O7,P7,Q7,R7,S7,T7,U7=0,V7=false,W7=false,X7=true;if(typeof e!='function'){throw new TypeError(F);}n=s7(n)||0;if(g7(Y6)){V7=!!Y6.leading;W7='maxWait'in Y6;Q7=W7?e3(s7(Y6.maxWait)||0,n):Q7;X7='trailing'in Y6?!!Y6.trailing:X7;}function Y7(f8){var g8=O7,h8=P7;O7=P7=u;U7=f8;R7=e.apply(h8,g8);return R7;}function Z7(f8){U7=f8;S7=setTimeout(a8,n);return V7?Y7(f8):R7;}function $7(f8){var g8=f8-T7,h8=f8-U7,i8=n-g8;return W7?f3(i8,Q7-h8):i8;}function _7(f8){var g8=f8-T7,h8=f8-U7;return(T7===u||(g8>=n)||(g8<0)||(W7&&h8>=Q7));}function a8(){var f8=S6();if(_7(f8)){return b8(f8);}S7=setTimeout(a8,$7(f8));}function b8(f8){S7=u;if(X7&&O7){return Y7(f8);}O7=P7=u;return R7;}function c8(){if(S7!==u){clearTimeout(S7);}U7=0;O7=T7=P7=S7=u;}function d8(){return S7===u?R7:b8(S6());}function e8(){var f8=S6(),g8=_7(f8);O7=arguments;P7=this;T7=f8;if(g8){if(S7===u){return Z7(T7);}if(W7){clearTimeout(S7);S7=setTimeout(a8,n);return Y7(T7);}}if(S7===u){S7=setTimeout(a8,n);}return R7;}e8.cancel=c8;e8.flush=d8;return e8;}
function V6(e,n){if(typeof e!='function'||(n!=null&&typeof n!='function')){throw new TypeError(F);}var Y6=function(){var O7=arguments,P7=n?n.apply(this,O7):O7[0],Q7=Y6.cache;if(Q7.has(P7)){return Q7.get(P7);}var R7=e.apply(this,O7);Y6.cache=Q7.set(P7,R7)||Q7;return R7;};Y6.cache=new(V6.Cache||N3);return Y6;}
V6.Cache=N3;
function W6(e,n,Y6){var O7=true,P7=true;if(typeof e!='function'){throw new TypeError(F);}if(g7(Y6)){O7='leading'in Y6?!!Y6.leading:O7;P7='trailing'in Y6?!!Y6.trailing:P7;}return U6(e,n,{'leading':O7,'maxWait':n,'trailing':P7});}
function X6(){if(!arguments.length){return[];}var e=arguments[0];return $6(e)?e:[e];}
function eq(e,n){return e===n||(e!==e&&n!==n);}
var Z6=u4(function(){return arguments;}())?u4:function(e){return h7(e)&&M2.call(e,'callee')&&!X2.call(e,'callee');};var $6=Array.isArray;
function _6(e){return e!=null&&f7(e.length)&&!e7(e);}
function a7(e){return h7(e)&&_6(e);}
var b7=c3||L7;
function c7(e,n){return v4(e,n);}
function d7(e,n,Y6){Y6=typeof Y6=='function'?Y6:u;var O7=Y6?Y6(e,n):u;return O7===u?v4(e,n,u,Y6):!!O7;}
function e7(e){if(!g7(e)){return false;}var n=q4(e);return n==D||n==E||n==y||n==R;}
function f7(e){return typeof e=='number'&&e>-1&&e%1==0&&e<=r;}
function g7(e){var n=typeof e;return e!=null&&(n=='object'||n=='function');}
function h7(e){return e!=null&&typeof e=='object';}
var i7=c2?t2(c2):x4;
function j7(e){return e==null;}
function k7(e){if(!h7(e)||q4(e)!=O){return false;}var n=V2(e);if(n===null){return true;}var Y6=M2.call(n,'constructor')&&n.constructor;return typeof Y6=='function'&&Y6 instanceof Y6&&L2.call(Y6)==P2;}
var l7=d2?t2(d2):A4;
function m7(e){return typeof e=='string'||(!$6(e)&&h7(e)&&q4(e)==U);}
function n7(e){return typeof e=='symbol'||(h7(e)&&q4(e)==X);}
var o7=e2?t2(e2):B4;
function p7(e){if(!e){return[];}if(_6(e)){return m7(e)?F2(e):g5(e);}if($2&&e[$2]){return z2(e[$2]());}var n=M5(e),Y6=n==G?A2:(n==T?D2:E7);return Y6(e);}
function q7(e){if(!e){return e===0?e:0;}e=s7(e);if(e===I||e===-I){var n=(e<0?-1:1);return n*s;}return e===e?e:0;}
function r7(e){var n=q7(e),Y6=n%1;return n===n?(Y6?n-Y6:n):0;}
function s7(e){if(typeof e=='number'){return e;}if(n7(e)){return N;}if(g7(e)){var n=typeof e.valueOf=='function'?e.valueOf():e;e=g7(n)?(n+''):n;}if(typeof e!='string'){return e===0?e:+e;}e=e.replace(n1,'');var Y6=u1.test(e);return(Y6||w1.test(e))?V1(e.slice(2),Y6?2:8):(t1.test(e)?N:+e);}
function t7(e){return h5(e,y7(e));}
function u7(e){return e==null?'':T4(e);}
function v7(e,n,Y6){var O7=e==null?u:o4(e,n);return O7===u?Y6:O7;}
function w7(e,n){return e!=null&&O5(e,n,s4);}
function x7(e){return _6(e)?a4(e):D4(e);}
function y7(e){return _6(e)?a4(e,true):E4(e);}
var z7=k5(function(e,n,Y6){J4(e,n,Y6);});var A7=k5(function(e,n,Y6,O7){J4(e,n,Y6,O7);});var B7=z5(function(e,n){var Y6={};if(e==null){return Y6;}var O7=false;n=k2(n,function(Q7){Q7=Z4(Q7,e);O7||(O7=Q7.length>1);return Q7;});h5(e,B5(e),Y6);if(O7){Y6=h4(Y6,C|a|b,v5);}var P7=n.length;while(P7--){V4(Y6,n[P7]);}return Y6;});var C7=z5(function(e,n){return e==null?{}:L4(e,n);});
function D7(e,n){if(e==null){return{};}var Y6=k2(B5(e),function(O7){return[O7];});n=F5(n);return M4(e,Y6,function(O7,P7){return n(O7,P7[0]);});}
function E7(e){return e==null?[]:u2(e,x7(e));}
function F7(e){return function(){return e;};}
function G7(e){return e;}
function H7(e){return C4(typeof e=='function'?e:h4(e,C));}
function I7(){}
function J7(e){return W5(e)?r2(o6(e)):N4(e);}
function K7(){return[];}
function L7(){return false;}
function M7(e){return(e&&e.length)?k4(e,G7,r4):u;}
function N7(e){return(e&&e.length)?k4(e,G7,F4):u;}
x3.castArray=X6;x3.compact=r6;x3.constant=F7;x3.curry=T6;x3.debounce=U6;x3.difference=s6;x3.differenceBy=t6;x3.differenceWith=u6;x3.flatMap=O6;x3.flatMapDeep=P6;x3.flatMapDepth=Q6;x3.flatten=v6;x3.flattenDeep=w6;x3.flattenDepth=x6;x3.intersection=y6;x3.intersectionBy=z6;x3.intersectionWith=A6;x3.iteratee=H7;x3.keys=x7;x3.keysIn=y7;x3.map=R6;x3.memoize=V6;x3.merge=z7;x3.mergeWith=A7;x3.omit=B7;x3.pick=C7;x3.pickBy=D7;x3.property=J7;x3.throttle=W6;x3.toArray=p7;x3.toPlainObject=t7;x3.union=C6;x3.unionBy=D6;x3.unionWith=E6;x3.uniq=F6;x3.uniqBy=G6;x3.uniqWith=H6;x3.values=E7;x3.without=I6;x3.xor=J6;x3.xorBy=K6;x3.xorWith=L6;x3.zipObject=M6;x3.zipObjectDeep=N6;x3.eq=eq;x3.get=v7;x3.hasIn=w7;x3.identity=G7;x3.isArguments=Z6;x3.isArray=$6;x3.isArrayLike=_6;x3.isArrayLikeObject=a7;x3.isBuffer=b7;x3.isEqual=c7;x3.isEqualWith=d7;x3.isFunction=e7;x3.isLength=f7;x3.isMap=i7;x3.isNil=j7;x3.isObject=g7;x3.isObjectLike=h7;x3.isPlainObject=k7;x3.isSet=l7;x3.isString=m7;x3.isSymbol=n7;x3.isTypedArray=o7;x3.last=B6;x3.max=M7;x3.min=N7;x3.stubArray=K7;x3.stubFalse=L7;x3.noop=I7;x3.now=S6;x3.toFinite=q7;x3.toInteger=r7;x3.toNumber=s7;x3.toString=u7;x3.VERSION=V;T6.placeholder=x3;return x3;});
/*!
 * Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)
 * Version 2.0.0, see https://github.com/sindresorhus/p-cancelable/tree/v2.0.0
 */
sap.ui.predefine('sap/base/util/restricted/_CancelablePromise',function(){'use strict';
function _(o,a){var p;if(typeof Symbol==="undefined"||o[Symbol.iterator]==null){if(Array.isArray(o)||(p=b(o))||a&&o&&typeof o.length==="number"){if(p)o=p;var i=0;var F=function F(){};return{s:F,n:function n(){if(i>=o.length)return{done:true};return{done:false,value:o[i++]};},e:function e(f){throw f;},f:F};}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");}var y=true,z=false,A;return{s:function s(){p=o[Symbol.iterator]();},n:function n(){var s=p.next();y=s.done;return s;},e:function e(f){z=true;A=f;},f:function f(){try{if(!y&&p.return!=null)p.return();}finally{if(z)throw A;}}};}
function b(o,a){if(!o)return;if(typeof o==="string")return c(o,a);var n=Object.prototype.toString.call(o).slice(8,-1);if(n==="Object"&&o.constructor)n=o.constructor.name;if(n==="Map"||n==="Set")return Array.from(o);if(n==="Arguments"||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return c(o,a);}
function c(a,e){if(e==null||e>a.length)e=a.length;for(var i=0,f=new Array(e);i<e;i++){f[i]=a[i];}return f;}
function d(o){"@babel/helpers - typeof";if(typeof Symbol==="function"&&typeof Symbol.iterator==="symbol"){d=function d(o){return typeof o;};}else{d=function d(o){return o&&typeof Symbol==="function"&&o.constructor===Symbol&&o!==Symbol.prototype?"symbol":typeof o;};}return d(o);}
function g(i,a){if(!(i instanceof a)){throw new TypeError("Cannot call a class as a function");}}
function h(a,p){for(var i=0;i<p.length;i++){var e=p[i];e.enumerable=e.enumerable||false;e.configurable=true;if("value"in e)e.writable=true;Object.defineProperty(a,e.key,e);}}
function j(a,p,s){if(p)h(a.prototype,p);if(s)h(a,s);return a;}
function k(s,a){if(typeof a!=="function"&&a!==null){throw new TypeError("Super expression must either be null or a function");}s.prototype=Object.create(a&&a.prototype,{constructor:{value:s,writable:true,configurable:true}});if(a)w(s,a);}
function l(D){var a=u();return function f(){var S=x(D),e;if(a){var N=x(this).constructor;e=Reflect.construct(S,arguments,N);}else{e=S.apply(this,arguments);}return m(this,e);};}
function m(s,a){if(a&&(d(a)==="object"||typeof a==="function")){return a;}return q(s);}
function q(s){if(s===void 0){throw new ReferenceError("this hasn't been initialised - super() hasn't been called");}return s;}
function r(a){var e=typeof Map==="function"?new Map():undefined;r=function r(a){if(a===null||!v(a))return a;if(typeof a!=="function"){throw new TypeError("Super expression must either be null or a function");}if(typeof e!=="undefined"){if(e.has(a))return e.get(a);e.set(a,W);}function W(){return t(a,arguments,x(this).constructor);}W.prototype=Object.create(a.prototype,{constructor:{value:W,enumerable:false,writable:true,configurable:true}});return w(W,a);};return r(a);}
function t(e,f,i){if(u()){t=Reflect.construct;}else{t=function t(e,f,i){var a=[null];a.push.apply(a,f);var n=Function.bind.apply(e,a);var o=new n();if(i)w(o,i.prototype);return o;};}return t.apply(null,arguments);}
function u(){if(typeof Reflect==="undefined"||!Reflect.construct)return false;if(Reflect.construct.sham)return false;if(typeof Proxy==="function")return true;try{Date.prototype.toString.call(Reflect.construct(Date,[],function(){}));return true;}catch(e){return false;}}
function v(f){return Function.toString.call(f).indexOf("[native code]")!==-1;}
function w(o,p){w=Object.setPrototypeOf||function w(o,p){o.__proto__=p;return o;};return w(o,p);}
function x(o){x=Object.setPrototypeOf?Object.getPrototypeOf:function x(o){return o.__proto__||Object.getPrototypeOf(o);};return x(o);}
var C=function(a){k(C,a);var e=l(C);function C(f){var i;g(this,C);i=e.call(this,f||'Promise was canceled');i.name='CancelError';return i;}j(C,[{key:"isCanceled",get:function f(){return true;}}]);return C;}(r(Error));var P=function(){j(P,null,[{key:"fn",value:function f(a){return function(){for(var e=arguments.length,i=new Array(e),n=0;n<e;n++){i[n]=arguments[n];}return new P(function(o,p,s){i.push(s);a.apply(void 0,i).then(o,p);});};}}]);function P(e){var a=this;g(this,P);this._cancelHandlers=[];this._isPending=true;this._isCanceled=false;this._rejectOnCancel=true;this._promise=new Promise(function(f,i){a._reject=i;var o=function o(s){a._isPending=false;f(s);};var n=function n(s){a._isPending=false;i(s);};var p=function p(s){if(!a._isPending){throw new Error('The `onCancel` handler was attached after the promise settled.');}a._cancelHandlers.push(s);};Object.defineProperties(p,{shouldReject:{get:function s(){return a._rejectOnCancel;},set:function y(s){a._rejectOnCancel=s;}}});return e(o,n,p);});}j(P,[{key:"then",value:function e(o,a){return this._promise.then(o,a);}},{key:"catch",value:function a(o){return this._promise.catch(o);}},{key:"finally",value:function a(o){return this._promise.finally(o);}},{key:"cancel",value:function p(a){if(!this._isPending||this._isCanceled){return;}if(this._cancelHandlers.length>0){try{var e=_(this._cancelHandlers),f;try{for(e.s();!(f=e.n()).done;){var i=f.value;i();}}catch(n){e.e(n);}finally{e.f();}}catch(o){this._reject(o);}}this._isCanceled=true;if(this._rejectOnCancel){this._reject(new C(a));}}},{key:"isCanceled",get:function a(){return this._isCanceled;}}]);return P;}();Object.setPrototypeOf(P.prototype,Promise.prototype);P.CancelError=C;return P;});
/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('jquery.sap.act',['sap/ui/util/ActivityDetection','jquery.sap.global'],function(A,q){"use strict";q.sap.act=A;return q;});
sap.ui.predefine('jquery.sap.encoder',['jquery.sap.global','sap/base/security/encodeXML','sap/base/security/encodeJS','sap/base/security/encodeURL','sap/base/security/encodeURLParameters','sap/base/security/encodeCSS','sap/base/security/URLWhitelist','sap/base/security/sanitizeHTML'],function(q,e,a,b,c,d,U,s){"use strict";q.sap.encodeHTML=e;q.sap.encodeXML=e;q.sap.escapeHTML=e;q.sap.encodeJS=a;q.sap.escapeJS=a;q.sap.encodeURL=b;q.sap.encodeURLParameters=c;q.sap.encodeCSS=d;q.sap.clearUrlWhitelist=U.clear;q.sap.addUrlWhitelist=U.add;
q.sap.removeUrlWhitelist=function(i){U.delete(U.entries()[i]);};
q.sap.getUrlWhitelist=U.entries;q.sap.validateUrl=U.validate;q.sap._sanitizeHTML=s;return q;});
sap.ui.predefine('jquery.sap.events',['jquery.sap.global','sap/ui/events/ControlEvents','sap/ui/events/PseudoEvents','sap/ui/events/checkMouseEnterOrLeave','sap/ui/events/isSpecialKey','sap/ui/events/isMouseEventDelayed','sap/ui/events/F6Navigation','sap/ui/events/jquery/EventExtension','sap/ui/events/jquery/EventSimulation','sap/ui/events/KeyCodes','sap/base/util/defineCoupledProperty'],function(q,C,P,c,i,I,F,E,a,K,d){"use strict";q.sap.PseudoEvents=P.events;q.sap.ControlEvents=C.events;q.sap.disableTouchToMouseHandling=a.disableTouchToMouseHandling;d(q.sap,"touchEventMode",a,"touchEventMode");q.sap.bindAnyEvent=C.bindAnyEvent;q.sap.unbindAnyEvent=C.unbindAnyEvent;q.sap.checkMouseEnterOrLeave=c;
q.sap.isSpecialKey=function(e){if(e.key){return i(e);}function b(e){var k=e.which;return(k===K.SHIFT)||(k===K.CONTROL)||(k===K.ALT)||(k===K.CAPS_LOCK)||(k===K.NUM_LOCK);}function f(e){var k=e.which,A=(k>=37&&k<=40);switch(e.type){case"keydown":case"keyup":return A;case"keypress":return k===0;default:return false;}}var k=e.which,s=b(e)||f(e)||(k>=33&&k<=36)||(k>=44&&k<=46)||(k>=112&&k<=123)||(k===K.BREAK)||(k===K.BACKSPACE)||(k===K.TAB)||(k===K.ENTER)||(k===K.ESCAPE)||(k===K.SCROLL_LOCK);switch(e.type){case"keydown":case"keyup":return s;case"keypress":return(k===0||k===K.BACKSPACE||k===K.ESCAPE||k===K.ENTER)||false;default:return false;}};
q.sap.handleF6GroupNavigation=function(e,s){if(!e.key&&e.keyCode===K.F6){e.key="F6";}return F.handleF6GroupNavigation(e,s);};
q.sap._FASTNAVIGATIONKEY=F.fastNavigationKey;
q.sap._refreshMouseEventDelayedFlag=function(n){q.sap.isMouseEventDelayed=I.apply(this,arguments);};
q.sap._refreshMouseEventDelayedFlag(navigator);return q;});
sap.ui.predefine('jquery.sap.history',["jquery.sap.global","sap/base/Log","sap/base/util/uid","sap/base/strings/escapeRegExp"],function(q,L,u,e){"use strict";(function(w){var s="_skip",r=/\|id-[0-9]+-[0-9]+/,a=new RegExp(s+"[0-9]*$"),b=[],h=[],S={},c=0,d,I="|",H=[],f=false,g,j=false;
q.sap.history=function(B){if(!q.isPlainObject(B)){return;}if(!j){var W=q(w),C=(w.location.href.split("#")[1]||"");W.on('hashchange',l);if(Array.isArray(B.routes)){var i,D;for(i=0;i<B.routes.length;i++){D=B.routes[i];if(D.path&&D.handler){q.sap.history.addRoute(D.path,D.handler);}}}if(typeof B.defaultHandler==="function"){g=B.defaultHandler;}h.push(C);if(C.length>1){W.trigger("hashchange",[true]);}else{d=C;}j=true;}};
q.sap.history.addHistory=function(i,B,C,V){var U,D;if(C===undefined){C=true;}if(!V){D=p(i,B);U=o(D);if(U){D+=(I+U);}D+=(I+(C?"1":"0"));}else{D=n(d);}H.push(D);S[D]=true;w.location.hash=D;return D;};
q.sap.history.addVirtualHistory=function(){q.sap.history.addHistory("",undefined,false,true);};
q.sap.history.addRoute=function(i,B,T){if(T){B=q.proxy(B,T);}var R={};R.sIdentifier=i;R['action']=B;b.push(R);return this;};
q.sap.history.setDefaultHandler=function(i){g=i;};
q.sap.history.getDefaultHandler=function(){return g;};
q.sap.history.backToHash=function(i){i=i||"";var B;if(h.length===1){if(typeof g==="function"){g();}}else{B=k(d,i);if(B<0){w.history.go(B);}else{L.error("jQuery.sap.history.backToHash: "+i+"is not in the history stack or it's after the current hash");}}};
q.sap.history.backThroughPath=function(P){P=P||"";P=w.encodeURIComponent(P);var i;if(h.length===1){if(typeof g==="function"){g();}}else{i=k(d,P,true);if(i<0){w.history.go(i);}else{L.error("jQuery.sap.history.backThroughPath: there's no history state which has the "+P+" identifier in the history stack before the current hash");}}};
q.sap.history.back=function(i){if(h.length===1){if(typeof g==="function"){g(q.sap.history.NavType.Back);}}else{if(!i){i=1;}w.history.go(-1*i);}};
q.sap.history.NavType={Back:"_back",Forward:"_forward",Bookmark:"_bookmark",Unknown:"_unknown"};
function k(C,T,P){var B=h.indexOf(C),D,i,E;if(B>0){if(P){for(i=B-1;i>=0;i--){E=h[i];if(E.indexOf(T)===0&&!v(E)){return i-B;}}}else{D=h.indexOf(T);if((D===-1)&&T.length===0){return-1*B;}if((D>-1)&&(D<B)){return D-B;}}}return 0;}
function l(E,M){var i=(w.location.href.split("#")[1]||"");i=m(i);if(M||!S[i]){H.push(i);}if(!f){f=true;if(H.length>0){var B=H.shift();if(S[B]){t(B);delete S[B];}else{y(B);}d=B;}f=false;}}
function m(i,R){var B=i,C=i?i.indexOf("#"):-1;if(C===0){B=B.slice(C+1);}if(R){B=B.replace(r,"");}return B;}
function n(i){var P=i?i:"";if(v(P)){var B=P.lastIndexOf(s);P=P.slice(0,B);}return P+s+c++;}
function p(i,B){var E=encodeURIComponent(i);var C=encodeURIComponent(JSON.stringify(B));return E+I+C;}
function o(B){var C=h.indexOf(d),i,D;if(C>-1){for(i=0;i<C+1;i++){D=h[i];if(D.slice(0,D.length-2)===B){return u();}}}return"";}
function t(i){var B=h.indexOf(d);if(!(B===-1||B===h.length-1)){h.splice(B+1,h.length-1-B);}h.push(i);}
function v(i){return a.test(i);}
function x(C,F){var B=h.indexOf(C),i;if(B!==-1){if(F){for(i=B;i<h.length;i++){if(!v(h[i])){return i-B;}}}else{for(i=B;i>=0;i--){if(!v(h[i])){return i-B;}}return-1*(B+1);}}}
function y(i){var R,B,P,N,C;if(d===undefined){P=A(i);if(!P||!P.bBookmarkable){if(typeof g==="function"){g(q.sap.history.NavType.Bookmark);}return;}}if(i.length===0){if(typeof g==="function"){g(q.sap.history.NavType.Back);}}else{N=h.indexOf(i);if(N===0){P=A(i);if(!P||!P.bBookmarkable){if(typeof g==="function"){g(q.sap.history.NavType.Back);}return;}}if(v(i)){if(v(d)){B=x(i,false);w.history.go(B);}else{var D=new RegExp(e(d+s)+"[0-9]*$");if(D.test(i)){B=x(i,true);if(B){w.history.go(B);}else{w.history.back();}}else{B=x(i,false);w.history.go(B);}}}else{if(N===-1){C=q.sap.history.NavType.Unknown;h.push(i);}else{if(h.indexOf(d,N+1)===-1){C=q.sap.history.NavType.Forward;}else{C=q.sap.history.NavType.Back;}}P=A(i);if(P){R=z(P.sIdentifier);if(R){R.action.apply(null,[P.oStateData,C]);}}else{L.error("hash format error! The current Hash: "+i);}}}}
function z(B){var i;for(i=0;i<b.length;i++){if(b[i].sIdentifier===B){return b[i];}}}
function A(B){if(v(B)){var i=B.lastIndexOf(s);B=B.slice(0,i);}var P=B.split(I),R={};if(P.length===4||P.length===3){R.sIdentifier=w.decodeURIComponent(P[0]);R.oStateData=JSON.parse(w.decodeURIComponent(P[1]));if(P.length===4){R.uid=P[2];}R.bBookmarkable=P[P.length-1]==="0"?false:true;return R;}else{return null;}}
})(this);return q;});
sap.ui.predefine('jquery.sap.keycodes',['jquery.sap.global','sap/ui/events/KeyCodes'],function(q,K){"use strict";q.sap.KeyCodes=K;return q;});
sap.ui.predefine('jquery.sap.mobile',['jquery.sap.global','sap/ui/util/Mobile','sap/ui/Device'],function(q,M,D){"use strict";
function g(t,p){var d=Object.getOwnPropertyDescriptor(t,p);return d&&d.value;}
(function(){q.os=q.extend({os:D.os.name,version:D.os.versionStr,fVersion:D.os.version},g(q,"os"));q.os[D.os.name]=true;q.device=q.extend({},g(q,"device"));q.device.is=q.extend({standalone:window.navigator.standalone,landscape:D.orientation.landscape,portrait:D.orientation.portrait,iphone:D.os.ios&&D.system.phone,ipad:D.os.ios&&D.system.tablet,android_phone:D.system.phone&&D.os.android,android_tablet:D.system.tablet&&D.os.android,tablet:D.system.tablet,phone:D.system.phone,desktop:D.system.desktop},q.device.is);})();q.sap.initMobile=M.init;q.sap.setIcons=M.setIcons;q.sap.setMobileWebAppCapable=M.setWebAppCapable;return q;});
sap.ui.predefine('jquery.sap.promise',[],function(){"use strict";if(!window.Promise){sap.ui.requireSync("sap/ui/thirdparty/es6-promise");}});
sap.ui.predefine('jquery.sap.properties',['jquery.sap.global','sap/base/util/Properties'],function(q,P){"use strict";q.sap.properties=P.create;return q;});
sap.ui.predefine('jquery.sap.resources',['sap/base/i18n/ResourceBundle','jquery.sap.global'],function(R,q){"use strict";
q.sap.resources=function(){return R.create.apply(R,arguments);};
q.sap.resources.isBundle=function(b){return b instanceof R;};
q.sap.resources._getFallbackLocales=R._getFallbackLocales;return q;});
sap.ui.predefine('jquery.sap.sjax',['jquery.sap.global'],function(q){"use strict";q.sap.sjaxSettings={complexResult:true,fallback:undefined};
q.sap.sjax=function a(o){var s=q.extend(true,{},q.sap.sjaxSettings,o,{async:false,success:function(d,t,x){r={success:true,data:d,status:t,statusCode:x&&x.status};},error:function(x,t,e){r={success:false,data:undefined,status:t,error:e,statusCode:x.status,errorResponse:x.responseText};}});var r;q.ajax(s);if(!s.complexResult){return r.success?r.data:s.fallback;}return r;};
q.sap.syncHead=function(u){return q.sap.sjax({type:'HEAD',url:u}).success;};
q.sap.syncGet=function s(u,d,D){return q.sap.sjax({url:u,data:d,type:'GET',dataType:D||'text'});};
q.sap.syncPost=function s(u,d,D){return q.sap.sjax({url:u,data:d,type:'POST',dataType:D||'text'});};
q.sap.syncGetText=function s(u,d,f){return q.sap.sjax({url:u,data:d,type:'GET',dataType:'text',fallback:f,complexResult:(arguments.length<3)});};
q.sap.syncGetJSON=function s(u,d,f){return q.sap.sjax({url:u,data:d||null,type:'GET',dataType:'json',fallback:f,complexResult:(arguments.length<3)});};
return q;});
sap.ui.predefine('jquery.sap.storage',['jquery.sap.global','sap/base/assert','sap/ui/util/Storage'],function(q,a,S){"use strict";var s={};
q.sap.storage=function(o,i){if(!o){o=S.Type.session;}if(typeof(o)==="string"&&S.Type[o]){var k=o;if(i&&i!="state.key_"){k=o+"_"+i;}return s[k]||(s[k]=new S(o,i));}a(o instanceof Object&&o.clear&&o.setItem&&o.getItem&&o.removeItem,"storage: duck typing the storage");return new S(o,i);};
q.sap.storage.Storage=S;q.sap.storage.Type=S.Type;Object.assign(q.sap.storage,S);return q;});
sap.ui.predefine('jquery.sap.strings',['jquery.sap.global','sap/base/strings/capitalize','sap/base/strings/camelize','sap/base/strings/hyphenate','sap/base/strings/escapeRegExp','sap/base/strings/formatMessage'],function(q,c,a,h,e,f){"use strict";
q.sap.endsWith=function(s,E){if(typeof(E)!="string"||E==""){return false;}return s.endsWith(E);};
q.sap.endsWithIgnoreCase=function(s,E){if(typeof(E)!="string"||E==""){return false;}s=s.toUpperCase();E=E.toUpperCase();return s.endsWith(E);};
q.sap.startsWith=function(s,S){if(typeof(S)!="string"||S==""){return false;}return s.startsWith(S);};
q.sap.startsWithIgnoreCase=function(s,S){if(typeof(S)!="string"||S==""){return false;}s=s.toUpperCase();S=S.toUpperCase();return s.startsWith(S);};
q.sap.charToUpperCase=function(s,p){if(!s){return s;}if(!p||isNaN(p)||p<=0||p>=s.length){return c(s);}var C=s.charAt(p).toUpperCase();if(p>0){return s.substring(0,p)+C+s.substring(p+1);}return C+s.substring(p+1);};
q.sap.padLeft=function(s,p,l){if(!s){s="";}if(p&&p.length===1){return s.padStart(l,p);}while(s.length<l){s=p+s;}return s;};
q.sap.padRight=function(s,p,l){if(!s){s="";}if(p&&p.length===1){return s.padEnd(l,p);}while(s.length<l){s=s+p;}return s;};
q.sap.camelCase=a;q.sap.hyphen=h;q.sap.escapeRegExp=e;q.sap.formatMessage=f;return q;});
sap.ui.predefine('jquery.sap.trace',['jquery.sap.global','sap/ui/thirdparty/URI','sap/ui/Device','sap/ui/performance/trace/Passport','sap/ui/performance/trace/Interaction','sap/ui/performance/trace/FESR','sap/base/Log','sap/ui/Global'],function(q,U,D,P,I,F,L){"use strict";
function l(){if(!(window.performance&&window.performance.getEntries)){L.warning("Interaction tracking is not supported on browsers with insufficient performance API");}}
q.sap.interaction={};
q.sap.interaction.setActive=function(){l();I.setActive.apply(this,arguments);};
q.sap.interaction.getActive=I.getActive;q.sap.interaction.notifyStepStart=I.notifyStepStart;q.sap.interaction.notifyStepEnd=I.notifyStepEnd;q.sap.interaction.notifyEventStart=I.notifyEventStart;q.sap.interaction.notifyScrollEvent=I.notifyScrollEvent;q.sap.interaction.notifyEventEnd=I.notifyEventEnd;q.sap.interaction.setStepComponent=I.setStepComponent;q.sap.fesr={};
q.sap.fesr.setActive=function(){l();F.setActive.apply(this,arguments);};
q.sap.fesr.getActive=F.getActive;q.sap.fesr.getCurrentTransactionId=P.getTransactionId;q.sap.fesr.getRootId=P.getRootId;q.sap.fesr.addBusyDuration=I.addBusyDuration;q.sap.passport={};q.sap.passport.setActive=P.setActive;q.sap.passport.traceFlags=P.traceFlags;
function g(){var a=!!document.querySelector("meta[name=sap-ui-fesr][content=true]"),p=window.location.search.match(/[\?|&]sap-ui-(?:xx-)?fesr=(true|x|X|false)&?/);if(p){a=p[1]&&p[1]!="false";}return a;}
q.sap.interaction.notifyStepStart(null,true);F.setActive(g());if(/sap-ui-xx-e2e-trace=(true|x|X)/.test(location.search)){sap.ui.requireSync("sap/ui/core/support/trace/E2eTraceLib");}return q;});
sap.ui.predefine('jquery.sap.ui',['jquery.sap.global','sap/base/util/ObjectPath','sap/ui/dom/jquery/control'],function(q,O){"use strict";
function f(c){return c.getUIArea().getInterface();}
function u(){return sap.ui.getCore().getUIArea(this.id)!=null;}
function a(){return sap.ui.getCore().getUIArea(this.id);}
q.fn.root=function(r){if(r){sap.ui.getCore().setRoot(this.get(0),r);return this;}var c=this.control();if(c.length>0){return c.map(f);}var U=this.uiarea();if(U.length>0){return U;}this.each(function(){sap.ui.getCore().createUIArea(this);});return this;};
q.fn.uiarea=function(i){var U=this.slice("[id]").filter(u).map(a).get();return typeof(i)==="number"?U[i]:U;};
q.fn.sapui=function(c,i,C){return this.each(function(){var o=null;if(this){if(c.indexOf(".")==-1){c="sap.ui.commons."+c;}var b=O.get(c);if(b){if(typeof C=='object'&&typeof C.press=='function'){C.press=q.proxy(C.press,this);}o=new(b)(i,C);o.placeAt(this);}}});};
return q;});
sap.ui.predefine('jquery.sap.unicode',['jquery.sap.global','sap/ui/Device'],function(q,D){'use strict';var i,N;if(!String.prototype.normalize&&!D.browser.mobile){N=sap.ui.requireSync('sap/base/strings/NormalizePolyfill');N.apply();i=N.isStringNFC;}else{i=function(s){return s.normalize("NFC")===s;};}q.sap.isStringNFC=i;return q;});
sap.ui.predefine('jquery.sap.xml',['jquery.sap.global','sap/ui/util/XMLHelper'],function(q,X){"use strict";q.sap.parseXML=X.parse;
q.sap.serializeXML=function(x){var s="";if(window.ActiveXObject){s=x.xml;if(s){return s;}}if(window.XMLSerializer){return X.serialize(x);}return s;};
q.sap.isEqualNode=function(n,N){if(n===N){return true;}if(!n||!N){return false;}if(n.isEqualNode){return n.isEqualNode(N);}if(n.nodeType!=N.nodeType){return false;}if(n.nodeValue!=N.nodeValue){return false;}if(n.baseName!=N.baseName){return false;}if(n.nodeName!=N.nodeName){return false;}if(n.nameSpaceURI!=N.nameSpaceURI){return false;}if(n.prefix!=N.prefix){return false;}if(n.nodeType!=1){return true;}if(n.attributes.length!=N.attributes.length){return false;}for(var i=0;i<n.attributes.length;i++){if(!q.sap.isEqualNode(n.attributes[i],N.attributes[i])){return false;}}if(n.childNodes.length!=N.childNodes.length){return false;}for(var i=0;i<n.childNodes.length;i++){if(!q.sap.isEqualNode(n.childNodes[i],N.childNodes[i])){return false;}}return true;};
q.sap.getParseError=X.getParseError;return q;});
sap.ui.predefine('sap/base/security/URLWhitelist',["sap/base/assert"],function(a){"use strict";var u={};
function U(p,h,b,c){if(p){this.protocol=p.toUpperCase();}if(h){this.host=h.toUpperCase();}this.port=b;this.path=c;}
var w=[];
u.clear=function(){w.splice(0,w.length);};
u.add=function(p,h,b,c){var e=new U(p,h,b,c);var i=w.length;w[i]=e;};
u.delete=function(e){w.splice(w.indexOf(e),1);};
u.entries=function(){return w.slice();};
u.validate=function(s){var r=/^(?:([^:\/?#]+):)?((?:\/\/((?:\[[^\]]+\]|[^\/?#:]+))(?::([0-9]+))?)?([^?#]*))(?:\?([^#]*))?(?:#(.*))?$/.exec(s);if(!r){return false;}var p=r[1],b=r[2],h=r[3],P=r[4],c=r[5],q=r[6],H=r[7];var d=/^([a-z0-9-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*$/i;var e=/^([a-z0-9-._~!$&'()*+,;=:@\/?]|%[0-9a-f]{2})*$/i;var f=e;var g=/^([a-z0-9!$'*+:^_`{|}~-]|%[0-9a-f]{2})+(?:\.([a-z0-9!$'*+:^_`{|}~-]|%[0-9a-f]{2})+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?$/i;var j=/^([0-9]{1,3}\.){3}[0-9]{1,3}$/;var k=/^(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])$/;var l=/^\[[^\]]+\]$/;var m=/^\[(((([0-9a-f]{1,4}:){6}|(::([0-9a-f]{1,4}:){5})|(([0-9a-f]{1,4})?::([0-9a-f]{1,4}:){4})|((([0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::([0-9a-f]{1,4}:){3})|((([0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::([0-9a-f]{1,4}:){2})|((([0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:)|((([0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::))(([0-9a-f]{1,4}:[0-9a-f]{1,4})|(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])))|((([0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4})|((([0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::))\]$/i;var n=/^([a-z0-9]([a-z0-9\-]*[a-z0-9])?\.)*[a-z0-9]([a-z0-9\-]*[a-z0-9])?$/i;if(p){p=p.toUpperCase();if(w.length<=0){if(!/^(https?|ftp)/i.test(p)){return false;}}}if(h){if(j.test(h)){if(!k.test(h)){return false;}}else if(l.test(h)){if(!m.test(h)){return false;}}else if(!n.test(h)){return false;}h=h.toUpperCase();}if(c){if(p==="MAILTO"){var A=b.split(",");for(var i=0;i<A.length;i++){if(!g.test(A[i])){return false;}}}else{var C=c.split("/");for(var i=0;i<C.length;i++){if(!d.test(C[i])){return false;}}}}if(q){if(!e.test(q)){return false;}}if(H){if(!f.test(H)){return false;}}if(w.length>0){var F=false;for(var i=0;i<w.length;i++){a(w[i]instanceof U,"whitelist entry type wrong");if(!p||!w[i].protocol||p==w[i].protocol){var o=false;if(h&&w[i].host&&/^\*/.test(w[i].host)){var t=w[i].host.slice(1).replace(/[-[\]{}()*+?.,\\^$|#\s]/g,"\\$&");var v=RegExp(t+"$");if(v.test(h)){o=true;}}else if(!h||!w[i].host||h==w[i].host){o=true;}if(o){if((!h&&!P)||!w[i].port||P==w[i].port){if(w[i].path&&/\*$/.test(w[i].path)){var x=w[i].path.slice(0,-1).replace(/[-[\]{}()*+?.,\\^$|#\s]/g,"\\$&");var v=RegExp("^"+x);if(v.test(c)){F=true;}}else if(!w[i].path||c==w[i].path){F=true;}}}}if(F){break;}}if(!F){return false;}}return true;};
return u;});
sap.ui.predefine('sap/base/security/encodeJS',["sap/base/strings/toHex"],function(t){"use strict";var r=/[\x00-\x2b\x2d\x2f\x3a-\x40\x5b-\x5e\x60\x7b-\xff\u2028\u2029]/g,j={};var J=function(c){var E=j[c];if(!E){var C=c.charCodeAt(0);if(C<256){E="\\x"+t(C,2);}else{E="\\u"+t(C,4);}j[c]=E;}return E;};var e=function(s){return s.replace(r,J);};return e;});
sap.ui.predefine('sap/base/security/encodeURL',["sap/base/strings/toHex"],function(t){"use strict";var r=/[\ud800-\udbff][\udc00-\udfff]|[\x00-\x2c\x2f\x3a-\x40\x5b-\x5e\x60\x7b-\uffff]/g,u={};var U=function(c){var E=u[c];if(!E){var C=c.codePointAt(0);if(C<128){E="%"+t(C,2);}else if(C<2048){E="%"+t((C>>6)|192,2)+"%"+t((C&63)|128,2);}else if(C<65536){E="%"+t((C>>12)|224,2)+"%"+t(((C>>6)&63)|128,2)+"%"+t((C&63)|128,2);}else{E="%"+t((C>>18)|240,2)+"%"+t(((C>>12)&63)|128,2)+"%"+t(((C>>6)&63)|128,2)+"%"+t((C&63)|128,2);}u[c]=E;}return E;};var e=function(s){return s.replace(r,U);};return e;});
sap.ui.predefine('sap/base/security/encodeURLParameters',["./encodeURL"],function(e){"use strict";var E=function(p){if(!p){return"";}var u=[];Object.keys(p).forEach(function(n){var v=p[n];if(v instanceof String||typeof v==="string"){v=e(v);}u.push(e(n)+"="+v);});return u.join("&");};return E;});
sap.ui.predefine('sap/base/security/sanitizeHTML',["sap/base/assert","sap/base/security/URLWhitelist","sap/ui/thirdparty/caja-html-sanitizer"],function(a,U){"use strict";var s=function(h,o){a(window.html&&window.html.sanitize,"Sanitizer should have been loaded");o=o||{uriRewriter:function(u){if(U.validate(u)){return u;}}};var t=o.tagPolicy||window.html.makeTagPolicy(o.uriRewriter,o.tokenPolicy);return window.html.sanitizeWithPolicy(h,t);};return s;});
sap.ui.predefine('sap/base/strings/NormalizePolyfill',["sap/ui/thirdparty/unorm","sap/ui/thirdparty/unormdata"],function(){"use strict";
function apply(){String.prototype.normalize=function(s){switch(s){case'NFC':return nfcQuickCheck(this)?this:UNorm.nfc(this);case'NFD':return UNorm.nfd(this);case'NFKC':return UNorm.nfkc(this);case'NFKD':return UNorm.nfkd(this);default:return nfcQuickCheck(this)?this:UNorm.nfc(this);}};}
var mData={};(function(){var N=[[0x0340,0x0341],[0x0343,0x0344],0x374,0x037E,0x387,[0x0958,0x095F],[0x09DC,0x09DD],0x09DF,0x0A33,0x0A36,[0x0A59,0x0A5B],0x0A5E,[0x0B5C,0x0B5D],0x0F43,0x0F4D,0x0F52,0x0F57,0x0F5C,0x0F69,0x0F73,[0x0F75,0x0F76],0x0F78,0x0F81,0x0F93,0x0F9D,0x0FA2,0x0FA7,0x0FAC,0x0FB9,0x1F71,0x1F73,0x1F75,0x1F77,0x1F79,0x1F7B,0x1F7D,0x1FBB,0x1FBE,0x1FC9,0x1FCB,0x1FD3,0x1FDB,0x1FE3,0x1FEB,[0x1FEE,0x1FEF],0x1FF9,0x1FFB,0x1FFD,[0x2000,0x2001],0x2126,[0x212A,0x212B],0x2329,0x232A,0x2ADC,[0xF900,0xFA0D],0xFA10,0xFA12,[0xFA15,0xFA1E],0xFA20,0xFA22,[0xFA25,0xFA26],[0xFA2A,0xFA6D],[0xFA70,0xFAD9],0xFB1D,0xFB1F,[0xFB2A,0xFB36],[0xFB38,0xFB3C],0xFB3E,[0xFB40,0xFB41],[0xFB43,0xFB44],[0xFB46,0xFB4E],[0x1D15E,0x1D164],[0x1D1BB,0x1D1C0],[0x2F800,0x2FA1D],[0x0300,0x0304],[0x0306,0x030C],0x030F,0x311,[0x0313,0x0314],0x031B,[0x0323,0x0328],[0x032D,0x032E],[0x0330,0x0331],0x338,0x342,0x345,[0x0653,0x0655],0x093C,0x09BE,0x09D7,0x0B3E,0x0B56,0x0B57,0x0BBE,0x0BD7,0x0C56,0x0CC2,[0x0CD5,0x0CD6],0x0D3E,0x0D57,0x0DCA,0x0DCF,0x0DDF,0x102E,[0x1161,0x1175],[0x11A8,0x11C2],0x1B35,[0x3099,0x309A],0x110BA,0x11127,0x1133E,0x11357,0x114B0,0x114BA,0x114BD,0x115AF];for(var i=0;i<N.length;i++){if(typeof N[i]=="number"){mData[N[i]]=true;}else{var a=N[i][0];var b=N[i][1];while(a<=b){mData[a++]=true;}}}}());
function isHighSurrogate(c){return c>=0xD800&&c<=0xDBFF;}
function isLowSurrogate(c){return c>=0xDC00&&c<=0xDFFF;}
function getCanonicalClass(cp){var dunit,hash;hash=cp&0xFF00;dunit=UNorm.UChar.udata[hash];if(dunit===undefined){dunit=UNorm.UChar.udata[hash]={};}else if(typeof dunit==="string"){dunit=UNorm.UChar.udata[hash]=eval("("+dunit+")");}return dunit[cp]&&!!dunit[cp][1]?(dunit[cp][1]&0xff):0;}
function isNotAllowed(c){return mData[c];}
function nfcQuickCheck(s){if(!/^[\u0001-\u00ff]*$/.test(s)){var l=0;for(var i=0;i<s.length;++i){var c=s.charCodeAt(i);if(isHighSurrogate(c)){var n=s.charCodeAt(i+1);if(isLowSurrogate(n)){c=(c-0xD800)*0x400+(n-0xDC00)+0x10000;++i;}}var a=getCanonicalClass(c);if(l>a&&a!==0||isNotAllowed(c)){return false;}l=a;}}return true;}
var NormalizePolyfill=Object.create(null);NormalizePolyfill.apply=apply;NormalizePolyfill.isStringNFC=nfcQuickCheck;return NormalizePolyfill;});
sap.ui.predefine('sap/base/strings/camelize',[],function(){"use strict";var r=/-(.)/ig;var c=function(s){return s.replace(r,function(m,C){return C.toUpperCase();});};return c;});
sap.ui.predefine('sap/base/strings/capitalize',[],function(){"use strict";var c=function(s){return s.charAt(0).toUpperCase()+s.substring(1);};return c;});
sap.ui.predefine('sap/base/strings/hyphenate',[],function(){"use strict";var r=/([A-Z])/g;var h=function(s){return s.replace(r,function(m,c){return"-"+c.toLowerCase();});};return h;});
sap.ui.predefine('sap/base/util/defineCoupledProperty',[],function(){"use strict";var d=function(t,T,s,S){var v=s[S];var p={configurable:true,get:function(){return v;},set:function(_){v=_;}};Object.defineProperty(t,T,p);Object.defineProperty(s,S,p);};return d;});
sap.ui.predefine('sap/base/util/includes',["sap/base/util/values"],function(v){"use strict";
function e(a,b){return a===b||(a!==a&&b!==b);}
var I=function(c,V,f){if(typeof f!=='number'){f=0;}if(Array.isArray(c)){if(typeof c.includes==='function'){return c.includes(V,f);}f=f<0?f+c.length:f;f=f<0?0:f;for(var i=f;i<c.length;i++){if(e(c[i],V)){return true;}}return false;}else if(typeof c==='string'){f=f<0?c.length+f:f;if(typeof c.includes==='function'){return c.includes(V,f);}return c.indexOf(V,f)!==-1;}else{return I(v(c),V,f);}};return I;});
sap.ui.predefine('sap/base/util/restricted/_castArray',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.castArray;});
sap.ui.predefine('sap/base/util/restricted/_compact',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.compact;});
sap.ui.predefine('sap/base/util/restricted/_curry',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.curry;});
sap.ui.predefine('sap/base/util/restricted/_debounce',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.debounce;});
sap.ui.predefine('sap/base/util/restricted/_difference',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.difference;});
sap.ui.predefine('sap/base/util/restricted/_differenceBy',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.differenceBy;});
sap.ui.predefine('sap/base/util/restricted/_differenceWith',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.differenceWith;});
sap.ui.predefine('sap/base/util/restricted/_flatMap',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.flatMap;});
sap.ui.predefine('sap/base/util/restricted/_flatMapDeep',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.flatMapDeep;});
sap.ui.predefine('sap/base/util/restricted/_flatMapDepth',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.flatMapDepth;});
sap.ui.predefine('sap/base/util/restricted/_flatten',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.flatten;});
sap.ui.predefine('sap/base/util/restricted/_flattenDeep',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.flattenDeep;});
sap.ui.predefine('sap/base/util/restricted/_flattenDepth',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.flattenDepth;});
sap.ui.predefine('sap/base/util/restricted/_intersection',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.intersection;});
sap.ui.predefine('sap/base/util/restricted/_intersectionBy',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.intersectionBy;});
sap.ui.predefine('sap/base/util/restricted/_intersectionWith',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.intersectionWith;});
sap.ui.predefine('sap/base/util/restricted/_isEqual',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.isEqual;});
sap.ui.predefine('sap/base/util/restricted/_isEqualWith',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.isEqualWith;});
sap.ui.predefine('sap/base/util/restricted/_isNil',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.isNil;});
sap.ui.predefine('sap/base/util/restricted/_max',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.max;});
sap.ui.predefine('sap/base/util/restricted/_merge',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.merge;});
sap.ui.predefine('sap/base/util/restricted/_mergeWith',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.mergeWith;});
sap.ui.predefine('sap/base/util/restricted/_min',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.min;});
sap.ui.predefine('sap/base/util/restricted/_omit',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.omit;});
sap.ui.predefine('sap/base/util/restricted/_pick',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.pick;});
sap.ui.predefine('sap/base/util/restricted/_pickBy',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.pickBy;});
sap.ui.predefine('sap/base/util/restricted/_throttle',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.throttle;});
sap.ui.predefine('sap/base/util/restricted/_toArray',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.toArray;});
sap.ui.predefine('sap/base/util/restricted/_union',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.union;});
sap.ui.predefine('sap/base/util/restricted/_unionBy',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.unionBy;});
sap.ui.predefine('sap/base/util/restricted/_unionWith',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.unionWith;});
sap.ui.predefine('sap/base/util/restricted/_uniq',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.uniq;});
sap.ui.predefine('sap/base/util/restricted/_uniqBy',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.uniqBy;});
sap.ui.predefine('sap/base/util/restricted/_uniqWith',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.uniqWith;});
sap.ui.predefine('sap/base/util/restricted/_without',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.without;});
sap.ui.predefine('sap/base/util/restricted/_xor',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.xor;});
sap.ui.predefine('sap/base/util/restricted/_xorBy',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.xorBy;});
sap.ui.predefine('sap/base/util/restricted/_xorWith',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.xorWith;});
sap.ui.predefine('sap/base/util/restricted/_zipObject',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.zipObject;});
sap.ui.predefine('sap/base/util/restricted/_zipObjectDeep',["sap/base/util/restricted/_/lodash.custom"],function(l){"use strict";return l.zipObjectDeep;});
sap.ui.predefine('sap/base/util/values',function(){"use strict";var v=function a(o){if(typeof o==="undefined"||o===null||o!==o){return[];}if(typeof Object.values==='function'){return Object.values(o);}if(typeof o==='string'){return o.split('');}if(typeof o!=='object'){return[];}return Object.keys(o).map(function(V){return o[V];});};return v;});
sap.ui.predefine('sap/ui/app/Application',['sap/base/assert','./ApplicationMetadata','sap/ui/core/Component','sap/ui/core/ComponentContainer','sap/ui/model/Model','sap/ui/model/json/JSONModel','jquery.sap.sjax'],function(a,A,C,b,M,J,q){"use strict";
var c=C.extend("sap.ui.app.Application",{
metadata:{"abstract":true,properties:{root:"string",config:"any"},aggregations:{rootComponent:{type:"sap.ui.core.UIComponent",multiple:false}},publicMethods:["getView"],deprecated:true},
constructor:function(i,s){if(this.onError){this.onWindowError=this.onError;}if(this.onBeforeExit){this.onWindowBeforeUnload=this.onBeforeExit;}if(this.onExit){this.onWindowUnload=this.onExit;}C.apply(this,arguments);if(sap.ui.getApplication){throw new Error("Only one instance of sap.ui.app.Application is allowed");}sap.ui.getApplication=this._getInstance.bind(this);sap.ui.getCore().attachInit(function(){this._initRootComponent();this.main();}.bind(this));},
_initRootComponent:function(){var r=this.createRootComponent();if(r){this.setRootComponent(r);var o=new b({component:r});o.placeAt(this.getRoot()||document.body);}},
createRootComponent:function(){var r=this.getMetadata().getRootComponent();var R;if(r){R=sap.ui.component({name:r});}return R;},
getView:function(){return this.getRootComponent();},
_getInstance:function(){return this;},
main:function(){},
onBeforeExit:function(){},
onExit:function(){},
onError:null,
setConfig:function(v){if(typeof v==="string"){var u=v;v=new J();var r=q.sap.sjax({url:u,dataType:'json'});if(r.success){v.setData(r.data);}else{throw new Error("Could not load config file: "+u);}}if(typeof v==="object"&&!(v instanceof M)){v=new J(v);}a(v instanceof M,"the config property value must be a string, an object or an instance of sap.ui.model.Model");this.setProperty("config",v);},
destroy:function(s){delete sap.ui.getApplication;C.prototype.destroy.apply(this,arguments);}
},A);
return c;});
sap.ui.predefine('sap/ui/app/ApplicationMetadata',['sap/base/Log','sap/ui/core/ComponentMetadata','jquery.sap.sjax'],function(L,C,q){"use strict";var A=function(c,o){C.apply(this,arguments);};A.prototype=Object.create(C.prototype);A.prototype.constructor=A;
A.preprocessClassInfo=function(c){if(c&&typeof c.metadata==="string"){c.metadata={_src:c.metadata};}return c;};
A.prototype.applySettings=function(c){var s=c.metadata;C.prototype.applySettings.call(this,c);if(s._src){L.warning("The metadata of the application "+this.getName()+" is loaded from file "+s._src+". This is a design time feature and not for productive usage!");var p=this.getName().replace(/\.\w+?$/,"");var u=sap.ui.require.toUrl(p.replace(/\./g,"/")+"/"+s._src);var r=q.sap.syncGetJSON(u);if(r.success){Object.assign(s,r.data);}else{L.error("Failed to load application metadata from \""+s._src+"\"! Reason: "+r.error);}}this._mRootComponent=s.rootComponent||null;};
A.prototype.getRootComponent=function(){return this._mRootComponent;};
return A;},true);
sap.ui.predefine('sap/ui/app/MockServer',['jquery.sap.global','sap/ui/core/util/MockServer'],function(q,M){"use strict";var a=M;return a;},true);
sap.ui.predefine('sap/ui/core/AppCacheBuster',['sap/ui/base/ManagedObject','./Core','sap/ui/thirdparty/URI','sap/base/Log','sap/base/util/extend','sap/base/strings/escapeRegExp','sap/ui/thirdparty/jquery'],function(M,C,U,L,a,b,q){"use strict";var c=sap.ui.getCore().getConfiguration();var l=c.getLanguage();var s=c.getAppCacheBusterMode()==="sync";var B=c.getAppCacheBusterMode()==="batch";var S={index:{},active:false};var v,d,f,x,E;var g=document.baseURI.replace(/\?.*|#.*/g,"");var u=U(sap.ui.require.toUrl("")+"/../");var o=u.toString();if(u.is("relative")){u=u.absoluteTo(g);}var h=u.normalize().toString();var r=U("resources").absoluteTo(h).toString();var F=new RegExp("^"+b(r));var i=function(e){if(e.length>0&&e.slice(-1)!=="/"){e+="/";}return e;};var R=function(h,e){var I=S.index;var j;var k;var m;if(Array.isArray(h)&&!B){h.forEach(function(G){R(G,e);});}else if(Array.isArray(h)&&B){var n=i(h[0]);var p=[];L.debug("sap.ui.core.AppCacheBuster.register(\""+n+"\"); // BATCH MODE!");var t=A.normalizeURL(n);L.debug("  --> normalized to: \""+t+"\"");h.forEach(function(G){k=i(G);var J=A.normalizeURL(k);if(!I[m]){p.push(J);}});if(p.length>0){var k=t+"sap-ui-cachebuster-info.json?sap-ui-language="+l;j={url:k,type:"POST",async:!s&&!!e,dataType:"json",contentType:"text/plain",data:p.join("\n"),success:function(G){A.onIndexLoaded(k,G);a(I,G);},error:function(){L.error("Failed to batch load AppCacheBuster index file from: \""+k+"\".");}};}}else{h=i(h);L.debug("sap.ui.core.AppCacheBuster.register(\""+h+"\");");m=A.normalizeURL(h);L.debug("  --> normalized to: \""+m+"\"");if(!I[m]){var k=m+"sap-ui-cachebuster-info.json?sap-ui-language="+l;j={url:k,async:!s&&!!e,dataType:"json",success:function(G){A.onIndexLoaded(k,G);I[m]=G;},error:function(){L.error("Failed to load AppCacheBuster index file from: \""+k+"\".");}};}}if(j){var w=A.onIndexLoad(j.url);if(w!=null){L.info("AppCacheBuster index file injected for: \""+k+"\".");j.success(w);}else{if(j.async){var y=e.startTask("load "+k);var z=j.success,D=j.error;Object.assign(j,{success:function(G){z.apply(this,arguments);e.finishTask(y);},error:function(){D.apply(this,arguments);e.finishTask(y,false);}});}L.info("Loading AppCacheBuster index file from: \""+k+"\".");q.ajax(j);}}};var A={boot:function(e){var j=c.getAppCacheBuster();if(j&&j.length>0){j=j.slice();var k=true;var V=String(j[0]).toLowerCase();if(j.length===1){if(V==="true"||V==="x"){var u=U(o);j=u.is("relative")?[u.toString()]:[];}else if(V==="false"){k=false;}}if(k){A.init();R(j,e);}}},init:function(){S.active=true;v=M.prototype.validateProperty;d=Object.getOwnPropertyDescriptor(HTMLScriptElement.prototype,"src");f=Object.getOwnPropertyDescriptor(HTMLLinkElement.prototype,"href");var j=A.convertURL;var n=A.normalizeURL;var I=function(e){if(this.active===true&&e&&typeof(e)==="string"){e=n(e);return!e.match(F);}return false;}.bind(S);x=XMLHttpRequest.prototype.open;XMLHttpRequest.prototype.open=function(e,t){if(t&&I(t)){arguments[1]=j(t);}x.apply(this,arguments);};E=XMLHttpRequest.prototype.open;M.prototype.validateProperty=function(P,V){var t=this.getMetadata(),w=t.getProperty(P),y;if(w&&w.type==="sap.ui.core.URI"){y=Array.prototype.slice.apply(arguments);try{if(I(y[1])){y[1]=j(y[1]);}}catch(e){}}return v.apply(this,y||arguments);};var k=function(e){var t={get:e.get,set:function(w){if(I(w)){w=j(w);}e.set.call(this,w);},enumerable:e.enumerable,configurable:e.configurable};t.set._sapUiCoreACB=true;return t;};var m=false;try{Object.defineProperty(HTMLScriptElement.prototype,"src",k(d));}catch(p){L.error("Your browser doesn't support redefining the src property of the script tag. Disabling AppCacheBuster as it is not supported on your browser!\nError: "+p);m=true;}try{Object.defineProperty(HTMLLinkElement.prototype,"href",k(f));}catch(p){L.error("Your browser doesn't support redefining the href property of the link tag. Disabling AppCacheBuster as it is not supported on your browser!\nError: "+p);m=true;}if(m){this.exit();}},exit:function(){M.prototype.validateProperty=v;if(XMLHttpRequest.prototype.open===E){XMLHttpRequest.prototype.open=x;}var e;if((e=Object.getOwnPropertyDescriptor(HTMLScriptElement.prototype,"src"))&&e.set&&e.set._sapUiCoreACB===true){Object.defineProperty(HTMLScriptElement.prototype,"src",d);}if((e=Object.getOwnPropertyDescriptor(HTMLLinkElement.prototype,"href"))&&e.set&&e.set._sapUiCoreACB===true){Object.defineProperty(HTMLLinkElement.prototype,"href",f);}S.index={};S.active=false;S={index:{},active:false};},register:function(h){R(h);},convertURL:function(e){L.debug("sap.ui.core.AppCacheBuster.convertURL(\""+e+"\");");var I=S.index;if(I&&e&&!/^#/.test(e)){var n=A.normalizeURL(e);L.debug("  --> normalized to: \""+n+"\"");if(n&&A.handleURL(n)){for(var h in I){var m=I[h],j,k;if(h&&n.length>=h.length&&n.slice(0,h.length)===h){j=n.slice(h.length);k=j.match(/([^?#]*)/)[1];if(m[k]){e=h+"~"+m[k]+"~/"+j;L.debug("  ==> rewritten to \""+e+"\";");break;}}}}}return e;},normalizeURL:function(e){var u=U(e||"./");if(u.is("relative")){u=u.absoluteTo(g);}return u.normalizeProtocol().normalizeHostname().normalizePort().normalizePath().toString();},handleURL:function(e){return true;},onIndexLoad:function(e){return null;},onIndexLoaded:function(e,I){}};var H=c.getAppCacheBusterHooks();if(H){["handleURL","onIndexLoad","onIndexLoaded"].forEach(function(e){if(typeof H[e]==="function"){A[e]=H[e];}});}return A;},true);
sap.ui.predefine('sap/ui/core/BusyIndicator',['sap/ui/thirdparty/jquery','../base/EventProvider','./Popup','./BusyIndicatorUtils','sap/ui/core/library',"sap/ui/performance/trace/FESR","sap/ui/performance/trace/Interaction","sap/base/Log","sap/base/assert","sap/base/util/now"],function(q,E,P,B,l,F,I,L,a,n){"use strict";var b=l.BusyIndicatorSize;var c=Object.assign(new E(),{oPopup:null,oDomRef:null,bOpenRequested:false,iDEFAULT_DELAY_MS:1000,sDOM_ID:"sapUiBusyIndicator"});c.M_EVENTS={Open:"Open",Close:"Close"};c._bShowIsDelayed=undefined;
c._init=function(){var r=document.createElement("div");r.id=this.sDOM_ID;var o=document.createElement("div");this._oResBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.core");var t=this._oResBundle.getText("BUSY_TEXT");delete this._oResBundle;o.className="sapUiBusy";o.setAttribute("tabindex","0");o.setAttribute("role","progressbar");o.setAttribute("alt","");o.setAttribute("title",t);r.appendChild(o);var d=B.getElement(b.Large);d.setAttribute("title",t);r.appendChild(d);var i=sap.ui.getCore().getStaticAreaRef();i.appendChild(r);this.oDomRef=r;this.oPopup=new P(r);this.oPopup.setModal(true,"sapUiBlyBusy");this.oPopup.setShadow(false);this.oPopup.attachOpened(function(e){this._onOpen(e);},this);};
c._onOpen=function(e){var d=document.getElementById(c.sDOM_ID);d.style.height="100%";d.style.width="100%";var A=d.querySelector(".sapUiLocalBusyIndicator");A.className+=" sapUiLocalBusyIndicatorFade";if(d){d.focus();}this.fireOpen({$Busy:this.oPopup._$()});};
c.show=function(d){L.debug("sap.ui.core.BusyIndicator.show (delay: "+d+") at "+new Date().getTime());a(d===undefined||(typeof d=="number"&&(d%1==0)),"iDelay must be empty or an integer");if(!document.body||!sap.ui.getCore().isInitialized()){if(c._bShowIsDelayed===undefined){sap.ui.getCore().attachInit(function(){if(c._bShowIsDelayed){c.show(d);}});}c._bShowIsDelayed=true;return;}if((d===undefined)||((d!=0)&&(parseInt(d)==0))||(parseInt(d)<0)){d=this.iDEFAULT_DELAY_MS;}if(F.getActive()){this._fDelayedStartTime=n()+d;}if(!this.oDomRef){this._init();}this.bOpenRequested=true;if(d===0){this._showNowIfRequested();}else{setTimeout(this["_showNowIfRequested"].bind(this),d);}};
c._showNowIfRequested=function(){L.debug("sap.ui.core.BusyIndicator._showNowIfRequested (bOpenRequested: "+this.bOpenRequested+") at "+new Date().getTime());if(!this.bOpenRequested){return;}var o=(window.scrollX===undefined?window.pageXOffset:window.scrollX);var O=(window.scrollY===undefined?window.pageYOffset:window.scrollY);var s=o+" "+O;this.bOpenRequested=false;this.oPopup.open(0,P.Dock.LeftTop,P.Dock.LeftTop,document,s);};
c.hide=function(){L.debug("sap.ui.core.BusyIndicator.hide at "+new Date().getTime());if(this._fDelayedStartTime){var f=n()-this._fDelayedStartTime;I.addBusyDuration((f>0)?f:0);delete this._fDelayedStartTime;}var d=c;if(c._bShowIsDelayed===true){c._bShowIsDelayed=false;}d.bOpenRequested=false;if(d.oDomRef){var A=d.oDomRef.querySelector(".sapUiLocalBusyIndicator");q(A).removeClass("sapUiLocalBusyIndicatorFade");this.fireClose({$Busy:this.oPopup._$()});d.oPopup.close(0);}};
c.attachOpen=function(f,o){this.attachEvent(c.M_EVENTS.Open,f,o);return this;};
c.detachOpen=function(f,o){this.detachEvent(c.M_EVENTS.Open,f,o);return this;};
c.attachClose=function(f,o){this.attachEvent(c.M_EVENTS.Close,f,o);return this;};
c.detachClose=function(f,o){this.detachEvent(c.M_EVENTS.Close,f,o);return this;};
c.fireOpen=function(p){this.fireEvent(c.M_EVENTS.Open,p);};
c.fireClose=function(p){this.fireEvent(c.M_EVENTS.Close,p);};
return c;},true);
sap.ui.predefine('sap/ui/core/CommandExecution',['sap/base/Log','sap/base/util/isEmptyObject','sap/ui/core/Component','sap/ui/core/Element','sap/ui/core/Shortcut'],function(L,a,C,E,S){"use strict";
var b=E.extend("sap.ui.core.CommandExecution",{
metadata:{library:"sap.ui.core",properties:{command:{type:"string"},enabled:{type:"boolean",defaultValue:true},visible:{type:"boolean",defaultValue:true}},events:{execute:{}}},
bSkipUpdate:false,
trigger:function(){if(this.getVisible()&&this.getEnabled()){this.fireExecute({});}},
setCommand:function(c){if(!this.getCommand()){this.setProperty("command",c,true);}else{L.error("The 'command' property can only be applied initially!");}return this;},
_getCommandInfo:function(){var c,o=this.getParent(),d=C.getOwnerComponentFor(this);while(!d&&o&&o.getParent()){d=C.getOwnerComponentFor(o);o=o.getParent();}if(d){c=d.getCommand(this.getCommand());}return c?Object.assign({},c):null;},
_updateContextData:function(c){var p=this.getParent();c[this.getCommand()]={};c[this.getCommand()].enabled=this.getEnabled();c[this.getCommand()].id=this.getId();c[this.getCommand()].visible=this.getVisible();this.getModel("$cmd").setProperty("/"+p.getId(),c);},
_createCommandData:function(p){if(!this.bSkipUpdate){this.bSkipUpdate=true;var P=this.getParent(),m=P.getModel("$cmd"),d=m.getData(),c=d[P.getId()];if(!c){c=Object.create(p);}else if(p!==Object.getPrototypeOf(c)){c=Object.create(p);}this._updateContextData(c);if(!P.getObjectBinding("$cmd")){P.bindElement("$cmd>/"+P.getId());}this.bSkipUpdate=false;}},
setParent:function(p){var t=this,c,o=this.getParent(),P,s,i;function g(){var d=p.oPropagatedProperties.oBindingContexts["$cmd"];return d?d.getObject():null;}function m(){if(p.getModel("$cmd")){var P=g();t.getParent().detachModelContextChange(m);t._createCommandData(P);}}E.prototype.setParent.apply(this,arguments);c=this._getCommandInfo();if(c&&this.getVisible()){if(p&&p!==o){s=c.shortcut;i=S.isRegistered(this.getParent(),s);if(!i){S.register(p,s,this.trigger.bind(this));}if(p.getModel("$cmd")){P=g();this._createCommandData(P);}else{p.attachModelContextChange(m);}if(!p._propagateProperties._sapui_fnOrig){var O=p._propagateProperties;p._propagateProperties=function(n,d,e,u,N,U){O.apply(p,arguments);var A=p.getBindingContext("$cmd");var f=arguments[1];if(A&&f.isA("sap.ui.core.CommandExecution")){var h=A.getObject();var j=Object.getPrototypeOf(h);P=g();if(j!==P){t._createCommandData.apply(f,[P]);}}};p._propagateProperties._sapui_fnOrig=O;}}if(o&&o!=p){s=c.shortcut;i=S.isRegistered(o,s);if(i){S.unregister(o,c.shortcut);}this._cleanupContext(o);}}return this;},
_cleanupContext:function(c){if(c.getBindingContext("$cmd")){var o=c.getBindingContext("$cmd").getObject();if(o){delete o[this.getCommand()];if(a(Object.assign({},o))){if(c._propagateProperties._sapui_fnOrig){c._propagateProperties=c._propagateProperties._sapui_fnOrig;}if(!c._bIsBeingDestroyed){c.unbindElement("$cmd");}}}}},
setVisible:function(v){var p=this.getParent(),c=this.getModel("$cmd");this.setProperty("visible",v,true);v=this.getProperty("visible");if(p){var o=this._getCommandInfo(),s=o.shortcut,i=S.isRegistered(p,s);if(v&&!i){S.register(p,s,this.trigger.bind(this));}else if(!v&&i){S.unregister(p,s);}}if(c){var d=this.getBindingContext("$cmd");c.setProperty(this.getCommand()+"/visible",v,d);}return this;},
setEnabled:function(v){var c=this.getModel("$cmd");this.setProperty("enabled",v,true);if(c){var o=this.getBindingContext("$cmd");c.setProperty(this.getCommand()+"/enabled",this.getProperty("enabled"),o);}return this;},
destroy:function(){var p=this.getParent();if(p){var c=this._getCommandInfo();S.unregister(this.getParent(),c.shortcut);this._cleanupContext(p);}E.prototype.destroy.apply(this,arguments);}
});
b.find=function(c,s){var i,o,A;A=c.getDependents();for(i=0;i<A.length;i++){if(A[i].isA("sap.ui.core.CommandExecution")&&A[i].getCommand()===s){o=A[i];}}if(!o&&c.getParent()){o=b.find(c.getParent(),s);}return o;};
return b;});
sap.ui.predefine('sap/ui/core/ComponentContainer',['sap/ui/base/ManagedObject','./Control','./Component','./Core','./library',"./ComponentContainerRenderer","sap/base/Log"],function(M,C,a,b,l,c,L){"use strict";var d=l.ComponentLifecycle;
var e=C.extend("sap.ui.core.ComponentContainer",{metadata:{library:"sap.ui.core",properties:{name:{type:"string",defaultValue:null},url:{type:"sap.ui.core.URI",defaultValue:null},async:{type:"boolean",defaultValue:false},handleValidation:{type:"boolean",defaultValue:false},settings:{type:"object",defaultValue:null},propagateModel:{type:"boolean",defaultValue:false},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},lifecycle:{type:"sap.ui.core.ComponentLifecycle",defaultValue:d.Legacy},autoPrefixId:{type:"boolean",defaultValue:false},usage:{type:"string",defaultValue:null},manifest:{type:"any",defaultValue:null}},associations:{component:{type:"sap.ui.core.UIComponent",multiple:false}},events:{componentCreated:{parameters:{component:{type:"sap.ui.core.UIComponent"}}},componentFailed:{allowPreventDefault:true,parameters:{reason:{type:"object"}}}},designtime:"sap/ui/core/designtime/ComponentContainer.designtime"}});
function s(o,v,S,D){var g=typeof v==="string"?b.getComponent(v):v;var O=o.getComponentInstance();if(O!==g){if(O){O.setContainer(undefined);if(D){O.destroy();}else{o._propagateProperties(true,O,M._oEmptyPropagatedProperties,true);}}o.setAssociation("component",g,S);g=o.getComponentInstance();if(g){g.setContainer(o);o.propagateProperties(true);}}}
e.prototype.getComponentInstance=function(){var g=this.getComponent();return g&&b.getComponent(g);};
e.prototype.setComponent=function(v,S){s(this,v,S,this.getLifecycle()===d.Container||(typeof this.getUsage()==="string"&&this.getUsage()&&this.getLifecycle()===d.Legacy));return this;};
e.prototype.applySettings=function(S,o){if(S){if(S.manifest==="true"||S.manifest==="false"){S.manifest=S.manifest==="true";}if(S.manifest&&S.async===undefined){S.async=true;}}C.prototype.applySettings.apply(this,arguments);};
function f(o){var n=o.getName();var m=o.getManifest();var u=o.getUrl();var S=o.getSettings();var g={name:n?n:undefined,manifest:m!==null?m:false,async:o.getAsync(),url:u?u:undefined,handleValidation:o.getHandleValidation(),settings:S!==null?S:undefined};return g;}
e.prototype._createComponent=function(){var o=a.getOwnerComponentFor(this),u=this.getUsage(),m=f(this);if(u){if(o){m=o._enhanceWithUsageConfig(u,m);}else{L.error("ComponentContainer \""+this.getId()+"\" does have a \"usage\", but no owner component!");}}if(this.getAutoPrefixId()){if(m.id){m.id=this.getId()+"-"+m.id;}if(m.settings&&m.settings.id){m.settings.id=this.getId()+"-"+m.settings.id;}}return a._createComponent(m,o);};
e.prototype.onBeforeRendering=function(){var o=this.getComponentInstance(),u=this.getUsage(),n=this.getName(),m=this.getManifest();if(!this._oComponentPromise&&!o&&(u||n||m)){o=this._createComponent();if(o instanceof Promise){this._oComponentPromise=o;o.then(function(o){delete this._oComponentPromise;this.setComponent(o);this.fireComponentCreated({component:o});}.bind(this),function(r){delete this._oComponentPromise;if(this.fireComponentFailed({reason:r})){L.error("Failed to load component for container "+this.getId(),r);}}.bind(this));}else if(o){this.setComponent(o,true);this.fireComponentCreated({component:o});}else{this.fireComponentFailed({reason:new Error("The component could not be created.")});}}if(o&&o.onBeforeRendering){o.onBeforeRendering();}};
e.prototype.onAfterRendering=function(){var o=this.getComponentInstance();if(o&&o.onAfterRendering){o.onAfterRendering();}};
e.prototype.exit=function(){s(this,undefined,true,this.getLifecycle()!==d.Application);};
e.prototype.propagateProperties=function(n){var o=this.getComponentInstance();if(o&&this.getPropagateModel()){this._propagateProperties(n,o);}C.prototype.propagateProperties.apply(this,arguments);};
e.prototype._propagateContextualSettings=function(){var o=this.getComponentInstance();if(o){o._applyContextualSettings(this._getContextualSettings());}};
return e;});
sap.ui.predefine('sap/ui/core/ComponentContainerRenderer',function(){"use strict";var C={apiVersion:2};
C.render=function(r,c){var o=c.getComponentInstance();var w=c.getWidth();var h=c.getHeight();r.openStart("div",c);r.style("width",w);r.style("height",h);r.class("sapUiComponentContainer");r.openEnd();r.openStart("div",c.getId()+"-uiarea");if(w&&w!=="auto"){r.style("width","100%");}if(h&&h!=="auto"){r.style("height","100%");}r.openEnd();if(o){o.render(r);}r.close("div");r.close("div");};
return C;},true);
sap.ui.predefine('sap/ui/core/ComponentSupport',['sap/ui/base/DataType','sap/ui/core/Component','sap/ui/core/ComponentContainer','sap/ui/core/library',"sap/base/Log","sap/base/util/ObjectPath","sap/base/strings/camelize"],function(D,C,a,b,L,O,c){"use strict";var d=b.ComponentLifecycle;var e=a.getMetadata();var f=function(){};
f.run=function(){var E=f._find();for(var i=0,l=E.length;i<l;i++){var o=E[i];L.debug("Parsing element "+o.outerHTML,"","sap/ui/core/ComponentSupport");var s=f._parse(o);f._applyDefaultSettings(s);L.debug("Creating ComponentContainer with the following settings",JSON.stringify(s,0,2),"sap/ui/core/ComponentSupport");new a(s).placeAt(o);o.removeAttribute("data-sap-ui-component");}};
f._find=function(){return document.querySelectorAll("[data-sap-ui-component]");};
f._parse=function(E){var s={};for(var i=0,l=E.attributes.length;i<l;i++){var A=E.attributes[i];var p=/^data-((?!sap-ui-component).+)/g.exec(A.name);if(p){var k=c(p[1]);var v=A.value;if(k!=="id"){var P=e.getProperty(k);var o=!P&&e.getEvent(k);if(!P&&!o){L.warning("Property or event \""+k+"\" will be ignored as it does not exist in sap.ui.core.ComponentContainer");continue;}if(P){var t=D.getType(P.type);if(!t){throw new Error("Property \""+P.name+"\" has no known type");}v=t.parseValue(v);}else if(o){var g=O.get(v);if(typeof g!=="function"){throw new Error("Callback handler for event \""+o.name+"\" not found");}v=g;}}s[k]=v;}}return s;};
f._applyDefaultSettings=function(s){s.async=true;if(s.manifest===undefined||s.manifest==="true"){s.manifest=true;}else if(s.manifest==="false"){L.error("Ignoring \"manifest=false\" for ComponentContainer of component \""+s.name+"\" as it is not supported by ComponentSupport. "+"Forcing \"manifest=true\"","","sap/ui/core/ComponentSupport");s.manifest=true;}s.lifecycle=s.lifecycle===undefined?d.Container:s.lifecycle;s.autoPrefixId=s.autoPrefixId===undefined?true:s.autoPrefixId;};
f.run();return f;});
sap.ui.predefine('sap/ui/core/ContextMenuSupport',["./Control"],function(C){"use strict";var a=function(){var c;if(!(this instanceof C)){return;}function o(e){e.stopPropagation();if(e.srcControl!==this){return;}e.preventDefault();this._oContextMenu.openAsContextMenu(e,this);}c={oncontextmenu:o};this.setContextMenu=function(b){if(b==null&&this.getContextMenu()){this._oContextMenu=null;this.removeEventDelegate(c,this);return;}else if(!b||!b.getMetadata||!b.getMetadata().isInstanceOf("sap.ui.core.IContextMenu")){return;}if(!this._oContextMenu){this.addEventDelegate(c,this);}this._oContextMenu=b;};this.getContextMenu=function(){return this._oContextMenu;};};return a;},true);
sap.ui.predefine('sap/ui/core/CustomData',['./Element'],function(E){"use strict";var C=E._CustomData;return C;});
sap.ui.predefine('sap/ui/core/CustomizingConfiguration',['./Core','./Component','sap/base/Log','sap/base/util/extend','sap/base/util/ObjectPath',"sap/base/util/isEmptyObject"],function(C,a,L,e,O,i){"use strict";var b="sap.ui.viewReplacements",c="sap.ui.viewExtensions",d="sap.ui.viewModifications",f="sap.ui.controllerExtensions",g="sap.ui.controllerReplacements";var m={};
function h(t,o,k){var s=o&&typeof o==="string"?o:(o&&a.getOwnerIdFor(o));if(s){var l=a.get(s);var p=l&&l.getMetadata().getComponentName();var q=m[p+"::"+s];if(q&&q[t]&&k(q[t])){return false;}else{q=m[p];if(q&&q[t]&&k(q[t])){return false;}}}else{for(p in m){q=m[p];if(q&&q[t]&&k(q[t])){break;}}}}
var j={log:function(){if(window.console){window.console.log(m);}},activateForComponent:function(s){L.info("CustomizingConfiguration: activateForComponent('"+s+"')");var F=s+".Component";sap.ui.requireSync(F.replace(/\./g,"/"));var o=O.get(F).getMetadata().getCustomizing();m[s]=o;L.debug("CustomizingConfiguration: customizing configuration for component '"+s+"' loaded: "+JSON.stringify(o));},deactivateForComponent:function(s){if(m[s]){L.info("CustomizingConfiguration: deactivateForComponent('"+s+"')");delete m[s];}},activateForComponentInstance:function(o){L.info("CustomizingConfiguration: activateForComponentInstance('"+o.getId()+"')");var s=o.getMetadata().getComponentName(),k=s+"::"+o.getId(),l=o.getManifest()["sap.ui5"]&&o.getManifest()["sap.ui5"]["extends"]&&o.getManifest()["sap.ui5"]["extends"]["extensions"];m[k]=l;L.debug("CustomizingConfiguration: customizing configuration for component '"+k+"' loaded: "+JSON.stringify(l));},deactivateForComponentInstance:function(o){var s=o.getMetadata().getComponentName(),k=s+"::"+o.getId();if(m[k]){L.info("CustomizingConfiguration: deactivateForComponent('"+k+"')");delete m[k];}},getViewReplacement:function(v,o){var r;h(b,o,function(k){r=k[v];return!!r;});return r;},getViewExtension:function(v,E,o){var r;h(c,o,function(k){r=k[v]&&k[v][E];return!!r;});return r;},getControllerExtension:function(s,o){var r;h(f,o,function(k){r=k[s];return!!r;});return r;},getControllerReplacement:function(s,o){var r;h(g,o,function(k){r=k[s];return!!r;});return r;},getCustomProperties:function(v,s,o){var S;h(d,o,function(k){var l=k[v]&&k[v][s];var u={};var V=false;var p,n;if(l){for(n in l){p=l[n];if(n==="visible"){V=true;u[n]=p;L.info("Customizing: custom value for property '"+n+"' of control '"+s+"' in View '"+v+"' applied: "+p);}else{L.warning("Customizing: custom value for property '"+n+"' of control '"+s+"' in View '"+v+"' ignored: only the 'visible' property can be customized.");}}if(V){S=S||{};e(S,u);}}});return S;},hasCustomProperties:function(v,o){var s={};h(d,o,function(k){if(!!k[v]){s=k[v];}});return!i(s);}};if(sap.ui.getCore().getConfiguration().getDisableCustomizing()){L.info("CustomizingConfiguration: disabling Customizing now");for(var n in j){if(typeof j[n]==="function"){j[n]=function(){};}}}return j;},true);
sap.ui.predefine('sap/ui/core/DeclarativeSupport',['sap/ui/thirdparty/jquery','sap/ui/base/DataType','sap/ui/base/ManagedObject','./Control','./CustomData','./HTML','./mvc/View','./mvc/EventHandlerResolver','sap/base/Log','sap/base/util/ObjectPath','sap/base/assert','sap/base/strings/camelize'],function(q,D,M,C,a,H,V,E,L,O,b,c){"use strict";var d={};d.attributes={"data-sap-ui-type":true,"data-sap-ui-id":true,"data-sap-ui-aggregation":true,"data-sap-ui-default-aggregation":true,"data-sap-ui-binding":function(v,s){var B=M.bindingParser(v);s.objectBindings=s.objectBindings||{};s.objectBindings[B.model||undefined]=B;},"data-tooltip":function(v,s){s["tooltip"]=v;},"tooltip":function(v,s,f){s["tooltip"]=v;L.warning('[Deprecated] Control "'+s.id+'": The attribute "tooltip" is not prefixed with "data-*". Future version of declarative support will only suppport attributes with "data-*" prefix.');},"class":true,"style":true,"id":true};
d.compile=function(e,v,i){var t=this;q(e).find("[data-sap-ui-type]").filter(function(){return q(this).parents("[data-sap-ui-type]").length===0;}).each(function(){t._compile(this,v,i);});};
d._compile=function(e,v,i){var $=q(e);var t=$.attr("data-sap-ui-type");var f=[];var I=t==="sap.ui.core.UIArea";if(I){var g=this;$.children().each(function(){var o=g._createControl(this,v);if(o){f.push(o);}});}else{var o=this._createControl(e,v);if(o){f.push(o);}}$.empty();var A=[];q.each(e.attributes,function(h,j){var n=j.name;if(!I||I&&/^data-/g.test(n.toLowerCase())){A.push(n);}});if(A.length>0){$.removeAttr(A.join(" "));}f.forEach(function(o){if(o instanceof C){if(v&&!i){v.addContent(o);}else{o.placeAt(e);if(v){v.connectControl(o);}}}});};
d._createControl=function(e,v){var $=q(e);var o=null;var t=$.attr("data-sap-ui-type");if(t){var f=sap.ui.requireSync(t.replace(/\./g,"/"));f=f||O.get(t);b(typeof f!=="undefined","Class not found: "+t);var s={};s.id=this._getId($,v);if(v&&v._sProcessingMode!=null&&f.getMetadata().hasSpecialSetting("processingMode")){s.processingMode=v._sProcessingMode;}this._addSettingsForAttributes(s,f,e,v);this._addSettingsForAggregations(s,f,e,v);var o;if(V.prototype.isPrototypeOf(f.prototype)&&typeof f._sType==="string"){o=V._legacyCreate(s,undefined,f._sType);}else{o=new f(s);}if(e.className){o.addStyleClass(e.className);}$.removeAttr("data-sap-ui-type");}else{o=this._createHtmlControl(e,v);}return o;};
d._createHtmlControl=function(e,v){var h=new H();h.setDOMContent(e);this.compile(e,v,true);return h;};
d._addSettingsForAttributes=function(s,f,e,v){var t=this;var S=d.attributes;var B=M.bindingParser;var g=[];var r=/^data-custom-data:(.+)/i;q.each(e.attributes,function(i,A){var n=A.name;var h=A.value;if(!r.test(n)){if(typeof S[n]==="undefined"){n=t.convertAttributeToSettingName(n,s.id);var p=t._getProperty(f,n);if(p){var o=B(h,v&&v.getController(),true);if(o&&typeof o==="object"){s[n]=o;}else{s[n]=t.convertValueToType(t.getPropertyDataType(p),o||h);}}else if(t._getAssociation(f,n)){var j=t._getAssociation(f,n);if(j.multiple){h=h.replace(/\s*,\s*|\s+/g,",");s[n]=h.split(",").map(function(I){return v?v.createId(I):I;});}else{s[n]=v?v.createId(h):h;}}else if(t._getAggregation(f,n)){var k=t._getAggregation(f,n);if(k.multiple){var o=B(h,v&&v.getController());if(o){s[n]=o;}else{throw new Error("Aggregation "+n+" with cardinality 0..n only allows binding paths as attribute value");}}else if(k.altTypes){var o=B(h,v&&v.getController(),true);if(o&&typeof o==="object"){s[n]=o;}else{s[n]=t.convertValueToType(k.altTypes[0],o||h);}}else{throw new Error("Aggregation "+n+" not supported");}}else if(t._getEvent(f,n)){var l=v&&(v._oContainingView||v).getController();var m=E.resolveEventHandler(h,l);if(m){s[n]=m;}else{throw new Error('Control "'+s.id+'": The function "'+h+'" for the event "'+n+'" is not defined');}}else{b((n==="id"),"DeclarativeSupport encountered unknown setting '"+n+"' for class '"+f.getMetadata().getName()+"' (value:'"+h+"')");}}else if(typeof S[n]==="function"){S[n](h,s,f);}}else{n=c(r.exec(n)[1]);var o=B(h,v&&v.getController());g.push(new a({key:n,value:o||h}));}});if(g.length>0){s.customData=g;}return s;};
d._addSettingsForAggregations=function(s,f,e,v){var $=q(e);var g=this._getDefaultAggregation(f,e);var t=this;var A=f.getMetadata().getAllAggregations();$.children().each(function(){var h=q(this);var i=h.attr("data-sap-ui-aggregation");var T=h.attr("data-sap-ui-type");var u=false;if(!i){u=true;i=g;}if(i&&A[i]){var m=A[i].multiple;var j=function(o){var k=t._createControl(o,v);if(k){if(m){if(!s[i]){s[i]=[];}if(typeof s[i].path==="string"){b(!s[i].template,"list bindings support only a single template object");s[i].template=k;}else{s[i].push(k);}}else{s[i]=k;}}};if(u||(T&&!u)){j(this);}else{h.children().each(function(){j(this);});}}h.removeAttr("data-sap-ui-aggregation");h.removeAttr("data-sap-ui-type");});return s;};
d._getId=function(e,v){var $=q(e);var i=$.attr("id");if(i){if(v){i=v.createId(i);$.attr("data-sap-ui-id",i);}$.attr("id","");}return i;};
d._getProperty=function(f,n){return f.getMetadata().getProperty(n);};
d.convertValueToType=function(t,v){if(t instanceof D){v=t.parseValue(v);}return typeof v==="string"?M.bindingParser.escape(v):v;};
d.getPropertyDataType=function(p){var t=D.getType(p.type);if(!t){throw new Error("Property "+p.name+" has no known type");}return t;};
d.convertAttributeToSettingName=function(A,i,e){if(A.indexOf("data-")===0){A=A.substr(5);}else if(e){L.warning('[Deprecated] Control "'+i+'": The attribute "'+A+'" is not prefixed with "data-*". Future version of declarative support will only suppport attributes with "data-*" prefix.');}else{throw new Error('Control "'+i+'": The attribute "'+A+'" is not prefixed with "data-*".');}return c(A);};
d._getAssociation=function(f,n){return f.getMetadata().getAssociation(n);};
d._getAggregation=function(f,n){return f.getMetadata().getAggregation(n);};
d._getEvent=function(f,n){return f.getMetadata().getEvent(n);};
d._getDefaultAggregation=function(f,e){var $=q(e);var s=$.attr("data-sap-ui-default-aggregation")||f.getMetadata().getDefaultAggregationName();$.removeAttr("data-sap-ui-default-aggregation");return s;};
return d;},true);
sap.ui.predefine('sap/ui/core/EnabledPropagator',['./Control'],function(C){"use strict";var E=function(d,l){if(!(this instanceof C)){throw new Error("EnabledPropagator only supports subclasses of Control");}if(d===undefined){d=true;}function f(c){var p=c.getParent();while(p&&!p.getEnabled&&p.getParent){p=p.getParent();}return p;}if(this.getEnabled===undefined){this.getEnabled=function(){var p=f(this);return(p&&p.getEnabled&&!p.getEnabled())?false:this.getProperty("enabled");};if(l){this.getMetadata().addProperty("Enabled",{type:"boolean",group:"Behavior",defaultValue:!!d});}this.getMetadata().addProperty("enabled",{type:"boolean",group:"Behavior",defaultValue:!!d});this.getMetadata().addPublicMethods('getEnabled');}else{var o=this.getEnabled;this.getEnabled=function(){var p=f(this);return(p&&p.getEnabled&&!p.getEnabled())?false:o.apply(this);};}if(this.setEnabled===undefined){this.setEnabled=function(e){return this.setProperty("enabled",e);};this.getMetadata().addPublicMethods('setEnabled');}};return E;},true);
sap.ui.predefine('sap/ui/core/ExtensionPoint',["sap/base/Log","sap/base/util/ObjectPath","sap/ui/core/mvc/View"],function(L,O,V){"use strict";
sap.ui.extensionpoint=function(c,e,C,t,a){L.warning("Do not use deprecated factory function 'sap.ui.extensionpoint'. Use 'sap.ui.core.ExtensionPoint.load' instead","sap.ui.extensionpoint",null,function(){return{type:"sap.ui.extensionpoint",name:e};});return E._factory(c,e,C,t,a);};
var E=sap.ui.extensionpoint;
E._factory=function(c,e,C,t,a){var b,v,r;var d=sap.ui.require('sap/ui/core/CustomizingConfiguration');if(c){if(c.isA("sap.ui.core.mvc.View")){b=d&&d.getViewExtension(c.sViewName,e,c);v=c;}else if(c.isA("sap.ui.core.Fragment")){b=d&&d.getViewExtension(c.getFragmentName(),e,c);v=c._oContainingView;}}if(b){if(b.className){var f=sap.ui.requireSync(b.className.replace(/\./g,"/"));f=f||O.get(b.className);var I=v&&b.id?v.createId(b.id):b.id;L.info("Customizing: View extension found for extension point '"+e+"' in View '"+v.sViewName+"': "+b.className+": "+(b.viewName||b.fragmentName));if(b.className==="sap.ui.core.Fragment"){var F=new f({id:I,type:b.type,fragmentName:b.fragmentName,containingView:v});r=(Array.isArray(F)?F:[F]);}else if(b.className==="sap.ui.core.mvc.View"){v=V._legacyCreate({type:b.type,viewName:b.viewName,id:I});r=[v];}else{L.warning("Customizing: Unknown extension className configured (and ignored) in Component.js for extension point '"+e+"' in View '"+v.sViewName+"': "+b.className);}}else{L.warning("Customizing: no extension className configured in Component.js for extension point '"+e+"' in View '"+v.sViewName+"': "+b.className);}}else if(E._fnExtensionProvider){var s=E._fnExtensionProvider(v);if(s){return[{providerClass:s,view:v,name:e,createDefault:C,targetControl:undefined,aggregationName:undefined,index:undefined,ready:function(g){var n=this._nextSibling;while(n!=null){n.index+=g.length;n=n._nextSibling;}},_isExtensionPoint:true,_nextSibling:null}];}}if(!r&&typeof C==='function'){r=C();}var p=function(r){if(r&&!Array.isArray(r)){r=[r];}if(r&&t){var A=t.getMetadata().getAggregation(a);if(A){for(var i=0,l=r.length;i<l;i++){t[A._sMutator](r[i]);}}else{L.error("Creating extension point failed - Tried to add extension point with name "+e+" to an aggregation of "+t.getId()+" in view "+v.sViewName+", but sAggregationName was not provided correctly and I could not find a default aggregation");}}return r||[];};if(r&&typeof r.then==='function'){return r.then(p);}else{return p(r);}};
E.registerExtensionProvider=function(e){if(e==null){delete E._fnExtensionProvider;}else if(typeof e=="function"){E._fnExtensionProvider=e;}else{L.error("ExtensionPoint provider must be a function!");}};
E.load=function(o){return Promise.resolve(E._factory(o.container,o.name,o.createDefaultContent));};
return E;});
sap.ui.predefine('sap/ui/core/Fragment',['sap/ui/thirdparty/jquery','../base/ManagedObject','./Element','./DeclarativeSupport','./XMLTemplateProcessor','sap/base/Log','sap/base/util/LoaderExtensions','sap/base/util/merge','sap/ui/core/Component'],function(q,M,E,D,X,L,a,m,C){"use strict";var r={},t={};
var F=M.extend("sap.ui.core.Fragment",{
metadata:{properties:{type:'string'},specialSettings:{async:{type:'boolean',visibility:'hidden'},fragmentName:'string',fragmentContent:'any',containingView:{type:'sap.ui.core.mvc.View',visibility:'hidden'},oController:{type:'sap.ui.core.mvc.Controller',visibility:'hidden'},sId:{type:'sap.ui.core.ID',visibility:'hidden'},sOwnerId:{type:'sap.ui.core.ID',visibility:'hidden'},processingMode:{type:'string',visibility:'hidden'}}},
constructor:function(i,s){M.apply(this,arguments);if(!this._bAsync){if(this._aContent&&this._aContent.length==1){return this._aContent[0];}else{return this._aContent;}}}
});
F.registerType=function(T,o){if(!typeof(T)==="string"){L.error("Ignoring non-string Fragment type: "+T);return;}if(t[T]){L.warning("sap.ui.core.Fragment.registerType(): Fragment type '"+T+"' is already defined. Overriding this type now!");}t[T]=o;};
F.prototype._initCompositeSupport=function(s){if(!s){throw new Error("Settings must be set");}if(!(s.fragmentName||s.fragmentContent)){throw new Error("Please provide a fragment name");}if(s.oController){this.oController=s.oController;}this._bAsync=s.async||false;this._sExplicitId=s.sId||s.id;this._sFragmentName=s.fragmentName;this.fnScopedRunWithOwner=s.containingView&&s.containingView.fnScopedRunWithOwner;if(!this.fnScopedRunWithOwner&&this._sOwnerId){var o=C.get(this._sOwnerId);this.fnScopedRunWithOwner=function(c){return o.runAsOwner(c);};}var b=t[s.type];if(b){b.init.apply(this,[s]);}else{throw new Error("No type for the fragment has been specified: "+s.type);}};
F.prototype.getFragmentName=function(){return this._sFragmentName;};
F.prototype.getController=function(){return this.oController;};
F.byId=function(s,i){if(!(typeof(s)==="string"&&typeof(i)==="string")){L.error("sap.ui.core.Fragment.byId: two strings must be given as parameters, but are: "+s+" and "+i);return undefined;}return sap.ui.getCore().byId(s+"--"+i);};
F.createId=function(s,i){if(!(typeof(s)==="string"&&typeof(i)==="string")){L.error("sap.ui.core.Fragment.createId: two strings must be given as parameters, but are: "+s+" and "+i);return undefined;}return s+"--"+i;};
F.prototype.createId=function(i){var b=this._sExplicitId?this._sExplicitId+"--"+i:i;if(this._oContainingView&&this._oContainingView!=this){b=this._oContainingView.createId(b);}return b;};
F.prototype.isSubView=function(){return true;};
sap.ui.fragment=function(n,T,c){var s;if(typeof(T)==="string"){s=T.toLowerCase();}else if(typeof(T)==="object"&&typeof(T.fragmentName)==="string"){s=T.fragmentName.toLowerCase();}else{s="";}L.info("Do not use deprecated factory function 'sap.ui."+s+"fragment'. Require 'sap/ui/core/Fragment' and use 'load()' instead","sap.ui."+s+"fragment",null,function(){return{type:"sap.ui."+s+"fragment",name:s?n+".fragment."+s:n};});return f(n,T,c);};
function f(n,T,c){var s={};if(typeof(n)==="string"){s.fragmentName=n;s.oController=c;s.type=T;}else if(typeof(n)==="object"){s=n;s.async=s.async===true?s.async:false;if(T){s.oController=T;}if(s.async){var b=function(){var o=C.get(s.sOwnerId);if(o){return o.runAsOwner(function(){return new F(s);});}return new F(s);};if(s.fragmentName){var d=s.fragmentName.replace(/\./g,"/")+".fragment";return new Promise(function(e,g){switch(s.type){case"XML":default:X.loadTemplatePromise(s.fragmentName,"fragment").then(function(h){s.fragmentContent=h;e(b());});break;case"JS":sap.ui.require([d],function(h){s.fragmentContent=h;e(b());},g);break;case"HTML":a.loadResource(d+".html",{async:true}).then(function(o){s.fragmentContent=o;e(b());});break;}});}else{return Promise.resolve(b());}}}else{L.error("sap.ui.fragment() must be called with Fragment name or config object as first parameter, but is: "+n);}return new F(s);}
F.load=function(o){var p=Object.assign({},o);if(p.name&&p.definition){L.error("The properties 'name' and 'definition' shouldn't be provided at the same time. The fragment definition will be used instead of the name. Fragment name was: "+p.name);delete p.name;}p.type=p.type||"XML";p.async=true;p.processingMode="sequential";p.fragmentName=p.name;p.fragmentContent=p.definition;p.oController=p.controller;p.sOwnerId=M._sOwnerId;delete p.name;delete p.definition;delete p.controller;var b=f(p);return b.then(function(c){return c._parsed();});};
F.prototype._parsed=function(){if(this._bAsync){return this._pContentPromise;}return Promise.resolve(this._pContentPromise.unwrap());};
sap.ui.xmlfragment=function(i,v,c){if(typeof(i)==="string"){if(typeof(v)==="string"){return sap.ui.fragment({fragmentName:v,sId:i,type:"XML"},c);}else{return sap.ui.fragment(i,"XML",v);}}else{i.type="XML";return sap.ui.fragment(i,v);}};
sap.ui.jsfragment=function(n,v,c){if(typeof n==="string"&&typeof v==="object"){if(v.createContent){r[n]=v;sap.ui.loader._.declareModule(n.replace(/\./g,"/")+".fragment.js");}else{return sap.ui.fragment(n,"JS",v);}}else if(typeof n==="string"&&v===undefined){return sap.ui.fragment(n,"JS");}else{if(typeof n==="object"){n.type="JS";return sap.ui.fragment(n,v);}else if(arguments.length>=3){return sap.ui.fragment({id:n,fragmentName:v,type:"JS"},c);}else{L.error("sap.ui.jsfragment() was called with wrong parameter set: "+n+" + "+v);}}};
sap.ui.htmlfragment=function(i,v,c){if(typeof(i)==="string"){if(typeof(v)==="string"){return sap.ui.fragment({fragmentName:v,sId:i,type:"HTML"},c);}else{return sap.ui.fragment(i,"HTML",v);}}else{i.type="HTML";return sap.ui.fragment(i,v);}};
F.registerType("XML",{init:function(s){this._aContent=[];if(s.fragmentContent){if(typeof(s.fragmentContent)==="string"){this._xContent=q.parseXML(s.fragmentContent).documentElement;}else{this._xContent=s.fragmentContent;}}else{L.warning("Synchronous loading of fragment, due to Fragment.init() call for '"+s.fragmentName+"'. Use 'sap/ui/core/Fragment' module with Fragment.load() instead.","SyncXHR",null,function(){return{type:"SyncXHR",name:"Fragment"};});this._xContent=X.loadTemplate(s.fragmentName,"fragment");}this._oContainingView=this._sExplicitId?this:(s.containingView||this);if((this._oContainingView===this)){this._oContainingView.oController=(s.containingView&&s.containingView.oController)||s.oController;}this._sProcessingMode=s.processingMode;var S=this._oContainingView._fnSettingsPreprocessor;var p={fnRunWithPreprocessor:function(b){return M.runWithPreprocessors(b,{settings:S});}};this.fnScopedRunWithOwner=this._oContainingView.fnScopedRunWithOwner;this._pContentPromise=X.parseTemplatePromise(this._xContent,this,this._bAsync,p).then(function(c){this._aContent=c;if(this._aContent&&this._aContent.length&&s.objectBindings){this._aContent.forEach(function(o,i){if(o instanceof E){for(var b in s.objectBindings){o.bindObject(s.objectBindings[b]);}}});}return this._aContent.length>1?this._aContent:this._aContent[0];}.bind(this));}});F.registerType("JS",{init:function(s){this._aContent=[];if(s.fragmentContent){m(this,s.fragmentContent);}else{if(!r[s.fragmentName]){sap.ui.requireSync(s.fragmentName.replace(/\./g,"/")+".fragment");}m(this,r[s.fragmentName]);}this._oContainingView=s.containingView||this;M.runWithPreprocessors(function(){var c;if(this.fnScopedRunWithOwner){this.fnScopedRunWithOwner(function(){c=this.createContent(s.oController||this._oContainingView.oController);}.bind(this));}else{c=this.createContent(s.oController||this._oContainingView.oController);}if(c instanceof Promise){this._pContentPromise=c.then(function(b){this._aContent=this._aContent.concat(b);return this._aContent.length>1?this._aContent:this._aContent[0];}.bind(this));}else{this._pContentPromise=new Promise(function(b,d){this._aContent=this._aContent.concat(c);b(this._aContent.length>1?this._aContent:this._aContent[0]);}.bind(this));}}.bind(this),{settings:this._oContainingView._fnSettingsPreprocessor});}});(function(){var _={};var b=function(T){var u=sap.ui.require.toUrl(T.replace(/\./g,"/"))+".fragment.html";var h=_[u];var R;if(!h){R=T.replace(/\./g,"/")+".fragment.html";h=a.loadResource(R);_[u]=h;}return h;};F.registerType("HTML",{init:function(s){this._aContent=[];this.getContent=function(){return this._aContent;};this.addContent=function(e){this._aContent.push(e);};this._oContainingView=s.containingView||this;this._sProcessingMode=s.processingMode;var h=s.fragmentContent||b(s.fragmentName);this._oTemplate=document.createElement("div");if(typeof h==="string"){this._oTemplate.innerHTML=h;}else{var n=h;var o=document.createDocumentFragment();for(var i=0;i<n.length;i++){o.appendChild(n.item(i));}this._oTemplate.appendChild(o);}var c=this._oTemplate.getElementsByTagName("template")[0];var p=this.getMetadata().getAllProperties();if(c){var d=this;q.each(c.attributes,function(I,A){var N=D.convertAttributeToSettingName(A.name,d.getId());var v=A.value;var P=p[N];if(!s[N]){if(P){s[N]=D.convertValueToType(D.getPropertyDataType(P),v);}else if(sap.ui.core.mvc.HTMLView._mAllowedSettings[N]){s[N]=v;}}});this._oTemplate=c;}if(this._oTemplate.content){var o=this._oTemplate.content;this._oTemplate=document.createElement("div");this._oTemplate.appendChild(o);}M.runWithPreprocessors(function(){if(this.fnScopedRunWithOwner){this.fnScopedRunWithOwner(function(){D.compile(this._oTemplate,this);}.bind(this));}else{D.compile(this._oTemplate,this);}var e=this.getContent();if(e&&e.length===1){this._aContent=[e[0]];this._pContentPromise=new Promise(function(g,j){g(this._aContent[0]);}.bind(this));}}.bind(this),{settings:this._oContainingView._fnSettingsPreprocessor});}});}());return F;});
sap.ui.predefine('sap/ui/core/HTML',['sap/ui/thirdparty/jquery',"sap/base/Log",'./Control','./RenderManager',"./HTMLRenderer","sap/base/security/sanitizeHTML"],function(q,L,C,R,H,b){"use strict";var c=R.RenderPrefixes;
var d=C.extend("sap.ui.core.HTML",{metadata:{library:"sap.ui.core",properties:{content:{type:"string",group:"Misc",defaultValue:null},preferDOM:{type:"boolean",group:"Misc",defaultValue:true},sanitizeContent:{type:"boolean",group:"Misc",defaultValue:false},visible:{type:"boolean",group:"Appearance",defaultValue:true}},events:{afterRendering:{parameters:{isPreservedDOM:{type:"boolean"}}}}}});
d.prototype.getDomRef=function(s){var i=s?this.getId()+"-"+s:this.getId();return document.getElementById(c.Dummy+i)||document.getElementById(i);};
d.prototype.setContent=function(e){function p(s){if(q.parseHTML){var a=q.parseHTML(s);if(a){var f=0,g=a.length;while(f<g&&a[f].nodeType!=1){f++;}while(f<g&&a[g-1].nodeType!=1){g--;}if(f>0||g<a.length){a=a.slice(f,g);}return q(a);}}return q(s);}if(this.getSanitizeContent()){L.trace("sanitizing HTML content for "+this);e=b(e);}this.setProperty("content",e,true);if(this.getDomRef()){var $=p(this.getContent());q(this.getDomRef()).replaceWith($);this._postprocessNewContent($);}else{this.invalidate();}return this;};
d.prototype.setSanitizeContent=function(s){this.setProperty("sanitizeContent",s,true);if(s){this.setContent(this.getContent());}return this;};
d.prototype.onBeforeRendering=function(){if(!this.getPreferDOM()){return;}var D=this.getDomRef();if(D&&!R.isPreservedContent(D)){for(var i=D.id,n;D&&D.getAttribute("data-sap-ui-preserve")==i;D=n){n=D.nextElementSibling;R.preserveContent(D,true,false);}}};
d.prototype.onAfterRendering=function(){if(!this.getVisible()){return;}var $=q(document.getElementById(c.Dummy+this.getId()));var a=R.findPreservedContent(this.getId());var e;var i=false;if((!this.getPreferDOM()||a.length==0)){a.remove();e=new q(this.getContent());$.replaceWith(e);}else if(a.length>0){$.replaceWith(a);e=a;i=true;}else{$.remove();}this._postprocessNewContent(e);this.fireAfterRendering({isPreservedDOM:i});};
d.prototype._postprocessNewContent=function($){if($&&$.length>0){if($.length>1){L.warning("[Unsupported Feature]: "+this+" has rendered "+$.length+" root nodes!");}else{var s=$.attr("id");if(s&&s!=this.getId()){L.warning("[Unsupported Feature]: Id of HTML Control '"+this.getId()+"' does not match with content id '"+s+"'!");}}if(this.getPreferDOM()){R.markPreservableContent($,this.getId());}if($.find("#"+this.getId().replace(/(:|\.)/g,'\\$1')).length===0){$.filter(":not([id])").first().attr("id",this.getId());}}else{L.debug(""+this+" is empty after rendering, setting bOutput to false");this.bOutput=false;}};
d.prototype.setDOMContent=function(D){var $=q(D);if(this.getDomRef()){q(this.getDomRef()).replaceWith($);this._postprocessNewContent($);}else{$.appendTo(R.getPreserveAreaRef());if(this.getUIArea()){this.getUIArea().invalidate();}this._postprocessNewContent($);}return this;};
d.prototype.setTooltip=function(){L.warning("The sap.ui.core.HTML control doesn't support tooltips. Add the tooltip to the HTML content instead.");return C.prototype.setTooltip.apply(this,arguments);};
"hasStyleClass addStyleClass removeStyleClass toggleStyleClass".split(" ").forEach(function(m){d.prototype[m]=function(){L.warning("The sap.ui.core.HTML control doesn't support custom style classes. Manage custom CSS classes in the HTML content instead.");return C.prototype[m].apply(this,arguments);};});return d;});
sap.ui.predefine('sap/ui/core/HTMLRenderer',['./RenderManager'],function(R){"use strict";var a=R.RenderPrefixes;var H={apiVersion:2,render:function(r,c){r.openStart("div",a.Dummy+c.getId());r.style("display","none");r.openEnd();r.close("div");}};return H;},true);
sap.ui.predefine('sap/ui/core/History',['sap/ui/base/Object',"sap/ui/util/Storage"],function(B,S){"use strict";
var H=B.extend("sap.ui.core.History",{
constructor:function(i,s){B.apply(this);if(!s){s={};}var h=s.prefix?s.prefix:document.location.pathname;this._iMaxHistory=s.max?s.max:100;this._sHistoryId=h+i;this._oStorage=new S(S.Type.local);this._fFilter=s.filter?s.filter:function(a,v){return a&&(!v||(v&&((typeof v=="string"?a.toLowerCase().startsWith(v.toLowerCase()):false))));};this._fCheckHistory=s.checkHistory?s.checkHistory:function(a){return a;};},
_initHistory:function(){if(!this._aHistory){var h=this._oStorage.get(this._sHistoryId);if(typeof(h)==="string"){h=h.split(",");}else if(!h){h=[];}this._aHistory=this._fCheckHistory(h);}return this._aHistory;},
get:function(v){var h=this._initHistory();var r=[];for(var i=0;i<h.length;i++){if(this._fFilter(h[i],v)){r.push(h[i]);}}return r;},
remove:function(v){var h=this._initHistory();for(var i=0;i<h.length;i++){if(h[i]==v){h.splice(i,1);break;}}},
add:function(v){var h=this._initHistory();for(var i=0;i<h.length;i++){if(h[i]===v){h.splice(i,1);break;}}h.unshift(v);if(h.length>this._iMaxHistory){h.splice(this._iMaxHistory);}this._oStorage.put(this._sHistoryId,h);},
clear:function(){this._oStorage.remove(this._sHistoryId);this._aHistory=null;}
});
return H;});
sap.ui.predefine('sap/ui/core/Icon',['sap/base/assert','../Device','./Control','./IconPool','./InvisibleText','./library',"./IconRenderer","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery","sap/base/Log"],function(a,D,C,I,b,l,c,K,q,L){"use strict";var d=l.IconColor;var e=l.CSSColor;var i=function(v){if(v!=null&&v!==""&&!e.isValid(v)&&!(v in d)){L.error("\""+v+"\" is not of type sap.ui.core.CSSColor nor of type sap.ui.core.IconColor.");return false;}else{return true;}};
var f=C.extend("sap.ui.core.Icon",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.ui.core",designtime:"sap/ui/core/designtime/Icon.designtime",properties:{src:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},size:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},color:{type:"string",group:"Appearance",defaultValue:null},hoverColor:{type:"string",group:"Appearance",defaultValue:null},activeColor:{type:"string",group:"Appearance",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},backgroundColor:{type:"string",group:"Appearance",defaultValue:null},hoverBackgroundColor:{type:"string",group:"Appearance",defaultValue:null},activeBackgroundColor:{type:"string",group:"Appearance",defaultValue:null},decorative:{type:"boolean",group:"Accessibility",defaultValue:true},useIconTooltip:{type:"boolean",group:"Accessibility",defaultValue:true},alt:{type:"string",group:"Accessibility",defaultValue:null},noTabStop:{type:"boolean",group:"Accessibility",defaultValue:false}},aggregations:{_invisibleText:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{press:{}}}});
f.prototype[D.support.touch?"ontouchstart":"onmousedown"]=function(E){if(this.hasListeners("press")){E.setMarked();}var A=this.getActiveColor(),s=this.getActiveBackgroundColor(),$;if(A||s){if(!E.targetTouches||(E.targetTouches&&E.targetTouches.length===1)){$=this.$();$.addClass("sapUiIconActive");if(A){this._addColorClass(A,"color");}if(s){this._addColorClass(s,"background-color");}}}};f.prototype[D.support.touch?"ontouchend":"onmouseup"]=function(E){if(!E.targetTouches||(E.targetTouches&&E.targetTouches.length===0)){this.$().removeClass("sapUiIconActive");this._restoreColors(D.system.desktop?"hover":undefined);}};
f.prototype.onmouseover=function(){var h=this.getHoverColor(),H=this.getHoverBackgroundColor();if(h){this._addColorClass(h,"color");}if(H){this._addColorClass(H,"background-color");}};
f.prototype.onmouseout=function(){this._restoreColors();};
f.prototype[D.support.touch&&!D.system.desktop?"ontap":"onclick"]=function(E){if(this.hasListeners("press")){E.setMarked();}this.firePress({});};
f.prototype.onkeydown=function(E){if(E.which===K.SPACE||E.which===K.ENTER){E.preventDefault();var $=this.$(),A=this.getActiveColor(),s=this.getActiveBackgroundColor();$.addClass("sapUiIconActive");if(A){this._addColorClass(A,"color");}if(s){this._addColorClass(s,"background-color");}}};
f.prototype.onkeyup=function(E){if(E.which===K.SPACE||E.which===K.ENTER){this.$().removeClass("sapUiIconActive");this._restoreColors();this.firePress({});}};
f.prototype._restoreColors=function(m){var s,B;if(m==="hover"){s=this.getHoverColor();B=this.getHoverBackgroundColor();}s=s||this.getColor();B=B||this.getBackgroundColor();this._addColorClass(s||"","color");this._addColorClass(B||"","background-color");};
f.prototype._addColorClass=function(s,g){var $=this.$(),t=this;var h="";if(g==="color"){h="sapUiIconColor";}else if(g==="background-color"){h="sapUiIconBGColor";}else{return;}q.each(d,function(p,P){t.removeStyleClass(h+P);});if(s in d){$.css(g,"");this.addStyleClass(h+s);}else{$.css(g,s);}};
f.prototype.setSrc=function(s){a(s==null||I.isIconURI(s),this+": Property 'src' (value: '"+s+"') should be a valid Icon URI (sap-icon://...)");return this.setProperty("src",s);};
f.prototype.setColor=function(s){if(i(s)){this.setProperty("color",s,true);this._addColorClass(s,"color");}return this;};
f.prototype.setActiveColor=function(s){if(i(s)){this.setProperty("activeColor",s,true);}return this;};
f.prototype.setHoverColor=function(s){if(i(s)){this.setProperty("hoverColor",s,true);}return this;};
f.prototype.setBackgroundColor=function(s){if(i(s)){this.setProperty("backgroundColor",s,true);this._addColorClass(s,"background-color");}return this;};
f.prototype.setActiveBackgroundColor=function(s){if(i(s)){this.setProperty("activeBackgroundColor",s,true);}return this;};
f.prototype.setHoverBackgroundColor=function(s){if(i(s)){this.setProperty("hoverBackgroundColor",s,true);}return this;};
f.prototype.attachEvent=function(E){C.prototype.attachEvent.apply(this,arguments);if(E=="press"&&this.hasListeners("press")){this.invalidate();}return this;};
f.prototype.detachEvent=function(E){C.prototype.detachEvent.apply(this,arguments);if(E=="press"&&!this.hasListeners("press")){this.invalidate();}return this;};
f.prototype._getOutputTitle=function(o){var t=this.getTooltip_AsString(),u=this.getUseIconTooltip();if(t||(u&&o&&o.text)){return t||o.text;}};
f.prototype._getIconLabel=function(o){var A=this.getAlt(),t=this.getTooltip_AsString(),u=this.getUseIconTooltip(),s=A||t||(u&&o&&(o.text||o.name)),O=this._getOutputTitle(o);if(s&&s!==O){return s;}};
f.prototype._createInvisibleText=function(t){var o=this.getAggregation("_invisibleText");if(!o){o=new b(this.getId()+"-label",{text:t});this.setAggregation("_invisibleText",o,true);}else{o.setProperty("text",t,true);}return o;};
f.prototype._getAccessibilityAttributes=function(o){var g=this.getAriaLabelledBy(),A={},s=this._getIconLabel(o),h;if(this.getDecorative()){A.role="presentation";A.hidden="true";}else{if(this.hasListeners("press")){A.role="button";}else{A.role="img";}}if(g.length>0){if(s){h=this._createInvisibleText(s);g.push(h.getId());}A.labelledby=g.join(" ");}else if(s){A.label=s;}return A;};
f.prototype.getAccessibilityInfo=function(){if(this.getDecorative()){return null;}var h=this.hasListeners("press");var o=I.getIconInfo(this.getSrc(),undefined,"sync");return{role:h?"button":"img",type:sap.ui.getCore().getLibraryResourceBundle("sap.ui.core").getText(h?"ACC_CTR_TYPE_BUTTON":"ACC_CTR_TYPE_IMAGE"),description:this.getAlt()||this.getTooltip_AsString()||(o?o.text||o.name:""),focusable:h};};
return f;});
sap.ui.predefine('sap/ui/core/IconPool',['./Core','sap/ui/thirdparty/URI',"sap/base/i18n/ResourceBundle","sap/base/Log","sap/ui/thirdparty/jquery"],function(c,U,R,L,q){"use strict";var S='SAP-icons';var I='sap-icon';var f={undefined:{config:{fontFamily:S},metadataLoaded:true,inserted:true}};var r={'undefined':{'accidental-leave':0xe000,'account':0xe001,'wrench':0xe002,'windows-doors':0xe003,'washing-machine':0xe004,'visits':0xe005,'video':0xe006,'travel-expense':0x1e007,'temperature':0xe008,'task':0x1e009,'synchronize':0xe00a,'survey':0x1e00b,'settings':0xe00c,'search':0x1e00d,'sales-document':0x1e00e,'retail-store':0xe00f,'refresh':0xe010,'product':0xe011,'present':0xe012,'ppt-attachment':0xe013,'pool':0xe014,'pie-chart':0xe015,'picture':0xe016,'photo-voltaic':0xe017,'phone':0xe018,'pending':0xe019,'pdf-attachment':0xe01a,'past':0x1e01b,'outgoing-call':0xe01c,'opportunity':0xe01d,'opportunities':0x1e01e,'notes':0xe01f,'money-bills':0x1e020,'map':0xe021,'log':0xe022,'line-charts':0xe023,'lightbulb':0xe024,'leads':0xe025,'lead':0x1e026,'laptop':0xe027,'kpi-managing-my-area':0x1e028,'kpi-corporate-performance':0x1e029,'incoming-call':0xe02a,'inbox':0xe02b,'horizontal-bar-chart':0xe02c,'history':0xe02d,'heating-cooling':0xe02e,'gantt-bars':0xe02f,'future':0x1e030,'fridge':0xe031,'fallback':0xe032,'expense-report':0x1e033,'excel-attachment':0xe034,'energy-saving-lightbulb':0xe035,'employee':0xe036,'email':0xe037,'edit':0xe038,'duplicate':0xe039,'download':0xe03a,'doc-attachment':0xe03b,'dishwasher':0xe03c,'delete':0xe03d,'decline':0xe03e,'complete':0x1e03f,'competitor':0xe040,'collections-management':0xe041,'chalkboard':0x1e042,'cart':0xe043,'card':0xe044,'camera':0xe045,'calendar':0x1e046,'begin':0xe047,'basket':0xe048,'bar-chart':0xe049,'attachment':0xe04a,'arrow-top':0xe04b,'arrow-right':0xe04c,'arrow-left':0xe04d,'arrow-bottom':0xe04e,'approvals':0x1e04f,'appointment':0xe050,'alphabetical-order':0x1e051,'along-stacked-chart':0xe052,'alert':0xe053,'addresses':0xe054,'address-book':0x1e055,'add-filter':0xe056,'add-favorite':0xe057,'add':0xe058,'activities':0x1e059,'action':0xe05a,'accept':0x1e05b,'hint':0x1e05c,'group':0xe05d,'check-availability':0x1e05e,'weather-proofing':0xe05f,'payment-approval':0x1e060,'batch-payments':0x1e061,'bed':0xe062,'arobase':0x1e063,'family-care':0xe064,'favorite':0xe065,'navigation-right-arrow':0xe066,'navigation-left-arrow':0xe067,'e-care':0xe068,'less':0xe069,'lateness':0xe06a,'lab':0xe06b,'internet-browser':0xe06c,'instance':0xe06d,'inspection':0xe06e,'image-viewer':0xe06f,'home':0xe070,'grid':0xe071,'goalseek':0xe072,'general-leave-request':0xe073,'create-leave-request':0xe074,'flight':0xe075,'filter':0xe076,'favorite-list':0xe077,'factory':0xe078,'endoscopy':0xe079,'employee-pane':0xe07a,'employee-approvals':0x1e07b,'email-read':0xe07c,'electrocardiogram':0xe07d,'documents':0xe07e,'decision':0xe07f,'database':0xe080,'customer-history':0xe081,'customer':0xe082,'credit-card':0xe083,'create-entry-time':0xe084,'contacts':0xe085,'compare':0xe086,'clinical-order':0xe087,'chain-link':0xe088,'pull-down':0xe089,'cargo-train':0xe08a,'car-rental':0xe08b,'business-card':0xe08c,'bar-code':0xe08d,'folder-blank':0xe08e,'passenger-train':0xe08f,'question-mark':0x1e090,'world':0xe091,'iphone':0xe092,'ipad':0xe093,'warning':0xe094,'sort':0xe095,'course-book':0xe096,'course-program':0xe097,'add-coursebook':0xe098,'print':0xe099,'save':0xe09a,'play':0x1e09b,'pause':0xe09c,'record':0xe09d,'response':0xe09e,'pushpin-on':0xe09f,'pushpin-off':0xe0a0,'unfavorite':0xe0a1,'learning-assistant':0xe0a2,'timesheet':0xe0a3,'time-entry-request':0xe0a4,'list':0xe0a5,'action-settings':0xe0a6,'share':0xe0a7,'feed':0xe0a8,'role':0xe0a9,'flag':0x1e0aa,'post':0xe0ab,'inspect':0xe0ac,'inspect-down':0xe0ad,'appointment-2':0xe0ae,'target-group':0xe0af,'marketing-campaign':0xe0b0,'notification':0xe0b1,'message-error':0xe0b1,'comment':0xe0b2,'shipping-status':0xe0b3,'collaborate':0xe0b4,'shortcut':0xe0b5,'lead-outdated':0x1e0b6,'tools-opportunity':0xe0b7,'permission':0xe0b8,'supplier':0xe0b9,'table-view':0xe0ba,'table-chart':0xe0bb,'switch-views':0xe0bc,'e-learning':0xe0bd,'manager':0xe0be,'switch-classes':0xe0bf,'simple-payment':0x1e0c0,'signature':0xe0c1,'sales-order-item':0x1e0c2,'sales-order':0x1e0c3,'request':0xe0c4,'receipt':0xe0c5,'puzzle':0xe0c6,'process':0xe0c7,'private':0xe0c8,'popup-window':0xe0c9,'person-placeholder':0xe0ca,'per-diem':0x1e0cb,'paper-plane':0xe0cc,'paid-leave':0x1e0cd,'pdf-reader':0x1e0ce,'overview-chart':0xe0cf,'overlay':0xe0d0,'org-chart':0xe0d1,'number-sign':0xe0d2,'notification-2':0xe0d3,'my-sales-order':0x1e0d4,'meal':0xe0d5,'loan':0x1e0d6,'order-status':0x1e0d7,'customer-order-entry':0x1e0d8,'performance':0xe0d9,'menu':0xe0da,'employee-lookup':0xe0db,'education':0xe0dc,'customer-briefing':0xe0dd,'customer-and-contacts':0xe0de,'my-view':0xe0df,'accelerated':0xe0e0,'to-be-reviewed':0xe0e1,'warning2':0xe0e2,'feeder-arrow':0xe0e3,'quality-issue':0xe0e4,'workflow-tasks':0xe0e5,'create':0xe0e6,'home-share':0xe0e7,'globe':0x1e0e8,'tags':0xe0e9,'work-history':0xe0ea,'x-ray':0xe0eb,'wounds-doc':0xe0ec,'web-cam':0xe0ed,'waiver':0x1e0ee,'vertical-bar-chart':0xe0ef,'upstacked-chart':0xe0f0,'trip-report':0xe0f1,'microphone':0xe0f2,'unpaid-leave':0x1e0f3,'tree':0xe0f4,'toaster-up':0xe0f5,'toaster-top':0xe0f6,'toaster-down':0xe0f7,'time-account':0xe0f8,'theater':0xe0f9,'taxi':0xe0fa,'subway-train':0xe0fb,'study-leave':0xe0fc,'stethoscope':0xe0fd,'step':0xe0fe,'sonography':0xe0ff,'soccor':0xe100,'soccer':0xe100,'physical-activity':0xe101,'pharmacy':0xe102,'official-service':0xe103,'offsite-work':0xe104,'nutrition-activity':0xe105,'newspaper':0xe106,'monitor-payments':0x1e107,'map-2':0xe108,'machine':0xe109,'mri-scan':0xe10a,'end-user-experience-monitoring':0xe10b,'unwired':0xe10c,'customer-financial-fact-sheet':0x1e10d,'retail-store-manager':0xe10e,'Netweaver-business-client':0xe10f,'electronic-medical-record':0xe110,'eam-work-order':0x1e111,'customer-view':0xe112,'crm-service-manager':0xe113,'crm-sales':0x1e114,'widgets':0x1e115,'commission-check':0x1e116,'collections-insight':0x1e117,'clinical-tast-tracker':0xe118,'citizen-connect':0xe119,'cart-approval':0x1e11a,'capital-projects':0x1e11b,'bo-strategy-management':0xe11c,'business-objects-mobile':0xe11d,'business-objects-explorer':0xe11e,'business-objects-experience':0xe11f,'bbyd-dashboard':0xe120,'bbyd-active-sales':0x1e121,'business-by-design':0x1e122,'business-one':0x1e123,'sap-box':0xe124,'manager-insight':0xe125,'accounting-document-verification':0x1e126,'hr-approval':0x1e127,'idea-wall':0xe128,'Chart-Tree-Map':0xe129,'cart-5':0xe12a,'cart-4':0xe12b,'wallet':0xe12c,'vehicle-repair':0xe12d,'upload':0xe12e,'unlocked':0xe12f,'umbrella':0xe130,'travel-request':0x1e131,'travel-expense-report':0x1e132,'travel-itinerary':0xe133,'time-overtime':0x1e134,'thing-type':0xe135,'technical-object':0xe136,'tag':0xe137,'syringe':0xe138,'syntax':0xe139,'suitcase':0xe13a,'simulate':0xe13b,'shield':0xe13c,'share-2':0xe13d,'sales-quote':0x1e13e,'repost':0xe13f,'provision':0xe140,'projector':0xe141,'add-product':0xe142,'pipeline-analysis':0xe143,'add-photo':0xe144,'palette':0xe145,'nurse':0xe146,'sales-notification':0x1e147,'mileage':0xe148,'meeting-room':0xe149,'media-forward':0x1e14a,'media-play':0x1e14b,'media-pause':0xe14c,'media-reverse':0x1e14d,'media-rewind':0x1e14e,'measurement-document':0xe14f,'measuring-point':0xe150,'measure':0xe151,'map-3':0xe152,'locked':0xe153,'letter':0xe154,'journey-arrive':0xe155,'journey-change':0xe156,'journey-depart':0xe157,'it-system':0xe158,'it-instance':0xe159,'it-host':0xe15a,'iphone-2':0xe15b,'ipad-2':0xe15c,'inventory':0xe15d,'insurance-house':0xe15e,'insurance-life':0xe15f,'insurance-car':0xe160,'initiative':0xe161,'incident':0x1e162,'group-2':0xe163,'goal':0xe164,'functional-location':0xe165,'full-screen':0xe166,'form':0xe167,'fob-watch':0xe168,'blank-tag':0xe169,'family-protection':0xe16a,'folder':0xe16b,'fax-machine':0xe16c,'example':0xe16d,'eraser':0xe16e,'employee-rejections':0xe16f,'drop-down-list':0xe170,'draw-rectangle':0xe171,'document':0xe172,'doctor':0xe173,'discussion-2':0xe174,'discussion':0xe175,'dimension':0xe176,'customer-and-supplier':0xe177,'crop':0xe178,'add-contact':0xe179,'compare-2':0xe17a,'color-fill':0xe17b,'collision':0xe17c,'curriculum':0xe17d,'chart-axis':0xe17e,'full-stacked-chart':0xe17f,'full-stacked-column-chart':0xe180,'vertical-bar-chart-2':0xe181,'horizontal-bar-chart-2':0xe182,'horizontal-stacked-chart':0xe183,'vertical-stacked-chart':0xe184,'choropleth-chart':0x1e185,'geographic-bubble-chart':0x1e186,'multiple-radar-chart':0xe187,'radar-chart':0xe188,'crossed-line-chart':0xe189,'multiple-line-chart':0xe18a,'multiple-bar-chart':0xe18b,'line-chart':0xe18c,'line-chart-dual-axis':0xe18d,'bubble-chart':0xe18e,'scatter-chart':0xe18f,'multiple-pie-chart':0xe190,'column-chart-dual-axis':0xe191,'tag-cloud-chart':0xe192,'area-chart':0xe193,'cause':0xe194,'cart-3':0xe195,'cart-2':0xe196,'bus-public-transport':0xe197,'burglary':0xe198,'building':0xe199,'border':0xe19a,'bookmark':0xe19b,'badge':0xe19c,'attachment-audio':0xe19d,'attachment-video':0xe19e,'attachment-html':0xe19f,'attachment-photo':0xe1a0,'attachment-e-pub':0xe1a1,'attachment-zip-file':0xe1a2,'attachment-text-file':0xe1a3,'add-equipment':0xe1a4,'add-activity':0x1e1a5,'activity-individual':0xe1a6,'activity-2':0x1e1a7,'add-activity-2':0x1e1a8,'activity-items':0xe1a9,'activity-assigned-to-goal':0xe1aa,'status-completed':0xe1ab,'status-positive':0xe1ab,'status-error':0xe1ac,'status-negative':0xe1ac,'status-inactive':0xe1ad,'status-in-process':0xe1ae,'status-critical':0xe1ae,'blank-tag-2':0xe1af,'cart-full':0xe1b0,'locate-me':0xe1b1,'paging':0xe1b2,'company-view':0xe1b3,'document-text':0xe1b4,'explorer':0xe1b5,'personnel-view':0xe1b6,'sorting-ranking':0xe1b7,'drill-down':0xe1b8,'drill-up':0xe1b9,'vds-file':0xe1ba,'sap-logo-shape':0x1e1bb,'folder-full':0xe1bc,'system-exit':0xe1bd,'system-exit-2':0xe1be,'close-command-field':0xe1bf,'open-command-field':0xe1c0,'sys-enter-2':0x1e1c1,'sys-enter':0x1e1c2,'sys-help-2':0x1e1c3,'sys-help':0x1e1c4,'sys-back':0xe1c5,'sys-back-2':0xe1c6,'sys-cancel':0xe1c7,'sys-cancel-2':0xe1c8,'open-folder':0xe1c9,'sys-find-next':0xe1ca,'sys-find':0xe1cb,'sys-monitor':0xe1cc,'sys-prev-page':0xe1cd,'sys-first-page':0xe1ce,'sys-next-page':0xe1cf,'sys-last-page':0xe1d0,'generate-shortcut':0xe1d1,'create-session':0xe1d2,'display-more':0xe1d3,'enter-more':0xe1d4,'zoom-in':0xe1d5,'zoom-out':0xe1d6,'header':0xe1d7,'detail-view':0xe1d8,'show-edit':0xe1d8,'collapse':0xe1d9,'expand':0xe1da,'positive':0xe1db,'negative':0xe1dc,'display':0xe1dd,'menu2':0xe1de,'redo':0xe1df,'undo':0xe1e0,'navigation-up-arrow':0xe1e1,'navigation-down-arrow':0xe1e2,'down':0xe1e3,'up':0xe1e4,'shelf':0xe1e5,'background':0xe1e6,'resize':0xe1e7,'move':0xe1e8,'show':0xe1e9,'hide':0xe1ea,'nav-back':0xe1eb,'error':0xe1ec,'slim-arrow-right':0xe1ed,'slim-arrow-left':0xe1ee,'slim-arrow-down':0xe1ef,'slim-arrow-up':0xe1f0,'forward':0xe1f1,'overflow':0xe1f2,'value-help':0xe1f3,'multi-select':0x1e1f4,'exit-full-screen':0xe1f5,'sys-add':0xe1f6,'sys-minus':0xe1f7,'dropdown':0xe1f8,'expand-group':0xe1f9,'collapse-group':0xe200,'vertical-grip':0xe1fa,'horizontal-grip':0xe1fb,'sort-descending':0xe1fc,'sort-ascending':0xe1fd,'arrow-down':0xe1fe,'legend':0xe1ff,'message-warning':0xe201,'message-information':0x1e202,'message-success':0x1e203,'restart':0xe204,'stop':0xe205,'add-process':0xe206,'cancel-maintenance':0xe207,'activate':0xe208,'resize-horizontal':0xe209,'resize-vertical':0xe20a,'connected':0xe20b,'disconnected':0xe20c,'edit-outside':0xe20d,'key':0xe20e,'minimize':0xe20f,'back-to-top':0xe210,'hello-world':0xe211,'outbox':0xe212,'donut-chart':0xe213,'heatmap-chart':0xe214,'horizontal-bullet-chart':0xe215,'vertical-bullet-chart':0xe216,'call':0xe217,'download-from-cloud':0xe218,'upload-to-cloud':0xe219,'jam':0xe21a,'sap-ui5':0xe21b,'message-popup':0xe21c,'cloud':0xe21d,'horizontal-waterfall-chart':0x1e21e,'vertical-waterfall-chart':0x1e21f,'broken-link':0xe220,'headset':0xe221,'thumb-up':0x1e222,'thumb-down':0x1e223,'multiselect-all':0x1e224,'multiselect-none':0x1e225,'scissors':0xe226,'sound':0x1e227,'sound-loud':0x1e228,'sound-off':0x1e229,'date-time':0x1e22a,'user-settings':0xe22b,'key-user-settings':0xe22c,'developer-settings':0xe22d,'text-formatting':0x1e22e,'bold-text':0x1e22f,'italic-text':0x1e230,'underline-text':0x1e231,'text-align-justified':0x1e232,'text-align-left':0x1e233,'text-align-center':0x1e234,'text-align-right':0x1e235,'bullet-text':0x1e236,'numbered-text':0x1e237,'co':0xe238,'ui-notifications':0xe239,'bell':0xe23a,'cancel-share':0xe23b,'write-new-document':0xe23c,'write-new':0xe23d,'cancel':0x1e23e,'screen-split-one':0xe23f,'screen-split-two':0xe240,'screen-split-three':0xe241,'customize':0xe242,'user-edit':0xe243,'source-code':0xe244,'copy':0xe245,'paste':0xe246,'line-chart-time-axis':0x1e247,'clear-filter':0xe248,'reset':0xe249,'trend-up':0xe24a,'trend-down':0xe24b,'cursor-arrow':0xe24c,'add-document':0xe24d,'create-form':0xe24e,'resize-corner':0xe24f,'chevron-phase':0xe250,'chevron-phase-2':0xe251,'rhombus-milestone':0xe252,'rhombus-milestone-2':0xe253,'circle-task':0xe254,'circle-task-2':0xe255,'project-definition-triangle':0xe256,'project-definition-triangle-2':0xe257,'master-task-triangle':0xe258,'master-task-triangle-2':0xe259,'program-triangles':0xe25a,'program-triangles-2':0xe25b,'mirrored-task-circle':0xe25c,'mirrored-task-circle-2':0xe25d,'checklist-item':0xe25e,'checklist-item-2':0xe25f,'checklist':0xe260,'checklist-2':0xe261,'chart-table-view':0xe262,'filter-analytics':0xe263,'filter-facets':0xe264,'filter-fields':0xe265,'indent':0xe266,'outdent':0xe267,'heading1':0x1e268,'heading2':0x1e269,'heading3':0x1e26a,'decrease-line-height':0xe26b,'increase-line-height':0xe26c,'fx':0x1e26d,'add-folder':0xe26e,'away':0xe26f,'busy':0xe270,'appear-offline':0xe271,'blur':0xe272,'pixelate':0xe273,'horizontal-combination-chart':0xe274,'add-employee':0xe275,'text-color':0x1e276,'browse-folder':0xe277,'primary-key':0xe278,'two-keys':0xe279,'strikethrough':0xe27a,'text':0xe27b,'responsive':0xe27c,'desktop-mobile':0xe27d,'table-row':0xe27e,'table-column':0xe27f,'validate':0x1e280,'keyboard-and-mouse':0xe281,'touch':0xe282,'expand-all':0xe283,'collapse-all':0xe284,'combine':0xe285,'split':0xe286,'megamenu':0xe287,'feedback':0xe288,'information':0xe289,'s4hana':0x1e28A,'translate':0x1e28B}};var C;
function g(){if(!C){C=sap.ui.getCore().getLibraryResourceBundle("sap.ui.core");}return C;}
var a;var b={};
b.createControlByURI=function(s,d){if(typeof s==="string"){s={src:s};}if(s&&s.src){var e=s.src,h=d;if(b.isIconURI(e)){a=a||sap.ui.requireSync("sap/ui/core/Icon");h=a;if(s.tap){s.press=s.tap;delete s.tap;}}if(typeof h==="function"){s=h.getMetadata().removeUnknownSettings(s);return new h(s);}}};
b.addIcon=function(d,e,h){if(typeof h==="string"){h={fontFamily:arguments[2],content:arguments[3],overWrite:!!arguments[4],suppressMirroring:!!arguments[5]};}if(typeof e!=="string"){e=String(e);}e=e==='undefined'?undefined:e;if(!r[e]){r[e]={};}var j=r[e],k=j[d],p,s,t,K;if(k){if(e===undefined){L.warning("Icon with name '"+d+"' in built-in collection already exists and can not be overwritten.","sap.ui.core.IconPool");return;}else if(!h.overWrite){L.warning("Icon with name '"+d+"' in collection '"+e+"' already exists. Specify 'iconInfo.overWrite' in order to overwrite.","sap.ui.core.IconPool");return;}}p={protocol:I,hostname:e||d,path:e?d:undefined};if(Array.isArray(h.content)){s=h.content.map(m).join('');}else{s=m(h.content);}if(h.resourceBundle instanceof R){K="Icon."+d;if(h.resourceBundle.hasText(K)){t=h.resourceBundle.getText(K);}}k=j[d]={name:d,collection:e,uri:U.build(p),fontFamily:h.fontFamily,content:s,text:t||'',suppressMirroring:h.suppressMirroring,skipMirroring:h.suppressMirroring};return k;};
b.getIconURI=function(d,e){var h=this.getIconInfo(d,e);return h&&h.uri;};
b.getIconInfo=function(d,e,l){var p,h,j,n=b.isIconURI(d);if(!d){return;}if(!l&&n){l=e;}l=l||"sync";j=(l==="async"||l==="mixed");function k(){var s=r[e];var h=s&&s[d];if(typeof h==='number'){r[e][d]=undefined;h=b.addIcon(d,e,{fontFamily:f[e].config.fontFamily,content:h&0xFFFF,suppressMirroring:!!(h&0x10000),resourceBundle:g()});}return h;}if(n){p=U.parse(d);if(p.path.length===1){e=undefined;d=p.hostname;}else{e=p.hostname;d=p.path.slice(1);}if(!d){return;}}if(typeof e!=="string"){e=String(e);}e=e==='undefined'?undefined:e;h=k();if(h===undefined&&e!==undefined){var o=b._loadFontMetadata(e,j);}if(j){if(o){return o.then(function(){h=k();if(!h){L.warning("Icon info for icon '"+d+"' in collection '"+e+"' could not be fetched");}return h;});}else{if(l==="async"){return Promise.resolve(h);}else{h=k();}}}else{h=k();}if(!h){L.warning("Icon info for icon '"+d+"' in collection '"+e+"' could not be fetched");}return h;};
b.fontLoaded=function(s){if(f[s]){if(f[s].metadataLoaded instanceof Promise){return f[s].metadataLoaded;}else if(f[s].metadataLoaded===true){return Promise.resolve();}}};
b.isIconURI=function(u){if(!u){return false;}var p=U.parse(u);return p.protocol===I&&!!p.hostname;};
b.getIconCollectionNames=function(){return Object.keys(r);};
b.getIconNames=function(d){var e=r[d];return e?Object.keys(e):[];};
b.insertFontFaceStyle=function(F,p,s){var e;if(arguments.length===0||F===S){L.info("It's not needed to call IconPool.insertFontFaceStyle to insert font-face for the predefined icon font SAP-icons because the font-face is included in the library.css of sap.ui.core");return;}if(F&&p===undefined){L.error("IconPool.insertFontFaceStyle must be called with at least two parameters!");return;}if(s===undefined){s=F;}if(!f[s]){L.error("Icon font '"+s+"' has not been registered yet.");return;}if(f[s].inserted){L.info("The font face style of icon font '"+s+"' was already inserted.");return;}e=document.createElement("style");e.type="text/css";e.textContent="@font-face {"+"font-family: '"+F+"';"+"src: url('"+p+F+".woff2') format('woff2'),"+"url('"+p+F+".woff') format('woff'),"+"url('"+p+F+".ttf') format('truetype'),"+"local('"+F+"');"+"font-weight: normal;"+"font-style: normal;"+"}";document.head.appendChild(e);f[s].inserted=true;f[s].fontFace=F;};
b.registerFont=function(o){o.collectionName=o.collectionName||o.fontFamily;if(!o.fontURI){L.error("The configuration parameter fontURI is missing, cannot register the font '"+o.collectionName+"'!");return;}if(o.fontFamily===S){L.error("The font family"+S+" is already registered");return;}if(o.fontURI.substr(o.fontURI.length-1)!=="/"){o.fontURI+="/";}if(!f[o.collectionName]||f[o.collectionName].metadataLoaded===false){f[o.collectionName]={config:o,inserted:false};}else{L.warning("The font '"+o.collectionName+"' is already registered");}if(!o.lazy){b._loadFontMetadata(o.collectionName,true);}};
b._loadFontMetadata=function(d,e){var o;if(f[d]){if(typeof f[d].metadataLoaded==="boolean"){return;}if(e&&f[d].metadataLoaded instanceof Promise){return f[d].metadataLoaded;}o=f[d].config;}else{if(!r[d]){L.error("The font configuration for collection '"+d+"' is not registered");}f[d]={metadataLoaded:false};}function l(F){for(var k in F){F[k]=parseInt(F[k],16);}r[d]=F;b.insertFontFaceStyle(o.fontFamily,o.fontURI,d);f[d].metadataLoaded=true;}if(o){if(o.metadataURI===undefined){o.metadataURI=o.fontURI+o.fontFamily+".json";}if(e&&!o.metadata){if(f[d].metadataLoaded instanceof Promise){return f[d].metadataLoaded;}var p=new Promise(function(h){if(r[d]===undefined){f[d].metadataLoadedResolve=h;f[d].metadataXhr=q.ajax(o.metadataURI,{dataType:"json",success:function(j){l(j);delete f[d].metadataXhr;delete f[d].metadataLoadedResolve;h();},error:function(j,s){if(s!=="abort"){L.error("An error occurred loading the font metadata for collection '"+d+"'");f[d].metadataLoaded=false;h();}}});}});f[d].metadataLoaded=p;return p;}else{if(o.metadataURI){if(f[d].metadataXhr){f[d].metadataXhr.abort("Replaced by sync request");f[d].metadataXhr=null;}L.warning("Synchronous loading of font meta data in IconPool, due to .getIconInfo() call"+" for '"+d+"'. Use loading mode 'async' to avoid this call.","SyncXHR",null,function(){return{type:"SyncXHR",name:"IconPool"};});q.ajax(o.metadataURI,{dataType:"json",async:false,success:function(j){l(j);if(f[d].metadataLoadedResolve){f[d].metadataLoadedResolve();delete f[d].metadataLoadedResolve;}},error:function(){if(f[d].metadataLoadedResolve){f[d].metadataLoadedResolve();delete f[d].metadataLoadedResolve;}L.error("An error occurred loading the font metadata for collection '"+d+"'");f[d].metadataLoaded=false;}});}else{l(o.metadata);}}}};
var i={"application/msword":"sap-icon://doc-attachment","application/vnd.openxmlformats-officedocument.wordprocessingml.document":"sap-icon://doc-attachment","application/rtf":"sap-icon://doc-attachment","application/pdf":"sap-icon://pdf-attachment","application/vnd.openxmlformats-officedocument.spreadsheetml.sheet":"sap-icon://excel-attachment","application/vnd.ms-excel":"sap-icon://excel-attachment","application/msexcel":"sap-icon://excel-attachment","application/vnd.ms-powerpoint":"sap-icon://ppt-attachment","application/vnd.openxmlformats-officedocument.presentationml.presentation":"sap-icon://ppt-attachment","application/vnd.openxmlformats-officedocument.presentationml.slideshow":"sap-icon://ppt-attachment","application/mspowerpoint":"sap-icon://ppt-attachment","application/xml":"sap-icon://attachment-html","application/xhtml+xml":"sap-icon://attachment-html","application/x-httpd-php":"sap-icon://attachment-html","application/x-javascript":"sap-icon://attachment-html","application/gzip":"sap-icon://attachment-zip-file","application/x-rar-compressed":"sap-icon://attachment-zip-file","application/x-tar":"sap-icon://attachment-zip-file","application/zip":"sap-icon://attachment-zip-file","audio/voxware":"sap-icon://attachment-audio","audio/x-aiff":"sap-icon://attachment-audio","audio/x-midi":"sap-icon://attachment-audio","audio/x-mpeg":"sap-icon://attachment-audio","audio/x-pn-realaudio":"sap-icon://attachment-audio","audio/x-pn-realaudio-plugin":"sap-icon://attachment-audio","audio/x-qt-stream":"sap-icon://attachment-audio","audio/x-wav":"sap-icon://attachment-audio","image/png":"sap-icon://attachment-photo","image/tiff":"sap-icon://attachment-photo","image/bmp":"sap-icon://attachment-photo","image/jpeg":"sap-icon://attachment-photo","image/gif":"sap-icon://attachment-photo","text/plain":"sap-icon://attachment-text-file","text/comma-separated-values":"sap-icon://attachment-text-file","text/css":"sap-icon://attachment-text-file","text/html":"sap-icon://attachment-text-file","text/javascript":"sap-icon://attachment-text-file","text/richtext":"sap-icon://attachment-text-file","text/rtf":"sap-icon://attachment-text-file","text/tab-separated-values":"sap-icon://attachment-text-file","text/xml":"sap-icon://attachment-text-file","video/mpeg":"sap-icon://attachment-video","video/quicktime":"sap-icon://attachment-video","video/x-msvideo":"sap-icon://attachment-video","application/x-shockwave-flash":"sap-icon://attachment-video"};
b.getIconForMimeType=function(M){return i[M]||"sap-icon://document";};
function m(d){return String.fromCharCode(typeof d==='number'?d:parseInt(d,16));}
return b;},true);
sap.ui.predefine('sap/ui/core/IconRenderer',['./IconPool','./library',"sap/base/security/encodeCSS"],function(I,l,e){"use strict";var a=l.IconColor;var b={apiVersion:2};
b.render=function(r,c){var i=I.getIconInfo(c.getSrc(),undefined,"mixed"),w=c.getWidth(),h=c.getHeight(),C=c.getColor(),B=c.getBackgroundColor(),s=c.getSize(),t=c._getOutputTitle(i),L,o,A,d=false;if(i instanceof Promise){i.then(c.invalidate.bind(c));}else if(i){d=true;L=c.getAriaLabelledBy();A=c._getAccessibilityAttributes(i);o=c.getAggregation("_invisibleText");}r.openStart("span",c);r.class("sapUiIcon");if(d){r.accessibilityState(c,A);r.attr("data-sap-ui-icon-content",i.content);r.style("font-family","'"+e(i.fontFamily)+"'");if(!i.suppressMirroring){r.class("sapUiIconMirrorInRTL");}}if(t){r.attr("title",t);}if(c.hasListeners("press")){r.class("sapUiIconPointer");if(!c.getNoTabStop()){r.attr("tabindex","0");}}r.style("width",w);r.style("height",h);r.style("line-height",h);r.style("font-size",s);if(C&&!(C in a)){r.style("color",C);}if(B&&!(B in a)){r.style("background-color",B);}r.openEnd();if(L&&L.length&&o){r.renderControl(o);}r.close("span");};
return b;},true);
sap.ui.predefine('sap/ui/core/IndicationColorSupport',['./Element','./library',"sap/base/assert"],function(E,l,a){"use strict";var I=l.IndicationColor;var b={};var t=null;var e=function(){if(!t){t={};var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.core");t[I.Indication01]=r.getText("INDICATION_STATE_INDICATION01");t[I.Indication02]=r.getText("INDICATION_STATE_INDICATION02");t[I.Indication03]=r.getText("INDICATION_STATE_INDICATION03");t[I.Indication04]=r.getText("INDICATION_STATE_INDICATION04");t[I.Indication05]=r.getText("INDICATION_STATE_INDICATION05");t[I.Indication06]=r.getText("INDICATION_STATE_INDICATION06");t[I.Indication07]=r.getText("INDICATION_STATE_INDICATION07");t[I.Indication08]=r.getText("INDICATION_STATE_INDICATION08");}};
b.getAdditionalText=function(v){var i=null;if(v&&v.getValueState){i=v.getIndicationColor();}else if(I[v]){i=v;}if(i){e();return t[i];}return null;};
return b;},true);
sap.ui.predefine('sap/ui/core/InvisibleMessage',["./library","sap/ui/base/ManagedObject","sap/base/Log"],function(c,M,L){"use strict";var i;var I=c.InvisibleMessageMode;
var a=M.extend("sap.ui.core.InvisibleMessage",{constructor:function(){if(i){L.warning('This is a singleton, therefore you are not able to create another instance of this class.');return i;}i=this;M.apply(this,arguments);}});
a.getInstance=function(){if(!i){i=new a("__invisiblemessage",{});}return i;};
a.prototype.init=function(){var C=sap.ui.getCore(),s=C.getStaticAreaRef();s.insertAdjacentHTML("beforeend",this.getPoliteInstance());s.insertAdjacentHTML("beforeend",this.getAssertiveInstance());};
a.prototype.announce=function(t,m){var C=sap.ui.getCore(),s=C.getStaticAreaRef(),p=s.querySelector(".sapUiInvisibleMessagePolite"),A=s.querySelector(".sapUiInvisibleMessageAssertive");if(!p||!A){return;}var n=m===I.Assertive?A:p;n.textContent="";n.textContent=t;if(m!==I.Assertive&&m!==I.Polite){L.info('You have entered an invalid mode. Valid values are: '+'"Polite" '+'and "Assertive".'+' The framework will automatically set the mode to "Polite".');}};
a.prototype.getPoliteInstance=function(){var s=this.getId();return'<span id="'+s+'-polite'+'" data-sap-ui="'+s+'-polite'+'" class="sapUiInvisibleMessagePolite" role="status" aria-live="polite">'+'</span>';};
a.prototype.getAssertiveInstance=function(){var s=this.getId();return'<span id="'+s+'-assertive'+'" data-sap-ui="'+s+'-assertive'+'" class="sapUiInvisibleMessageAssertive" role="status" aria-live="assertive">'+'</span>';};
return a;});
sap.ui.predefine('sap/ui/core/InvisibleText',['./Control','./library',"sap/base/Log","sap/base/security/encodeXML"],function(C,l,L,a){"use strict";
var I=C.extend("sap.ui.core.InvisibleText",{
metadata:{library:"sap.ui.core",publicMethods:["toStatic"],properties:{text:{type:"string",defaultValue:""}}},
renderer:{apiVersion:2,render:function(r,c){r.openStart("span",c);r.class("sapUiInvisibleText");r.attr("aria-hidden","true");r.openEnd();r.text(c.getText()||"");r.close("span");}}
});
function m(w){return function(){L.warning(w+" is not supported by control sap.ui.core.InvisibleText.");return this;};}
I.prototype.setBusy=m("Property busy");I.prototype.setBusyIndicatorDelay=m("Property busy");I.prototype.setBusyIndicatorSize=m("Property busy");I.prototype.setVisible=m("Property visible");I.prototype.setTooltip=m("Aggregation tooltip");
I.prototype.setText=function(T){this.setProperty("text",T,true);this.$().html(a(this.getText()||""));return this;};
I.prototype.getRendererMarkup=function(){var i=this.getId();return'<span id="'+i+'" data-sap-ui="'+i+'" class="sapUiInvisibleText" aria-hidden="true">'+a(this.getText())+'</span>';};
I.prototype.toStatic=function(){var c=sap.ui.getCore();try{var s=c.getStaticAreaRef();s.insertAdjacentHTML("beforeend",this.getRendererMarkup());this.bOutput=true;}catch(e){this.placeAt("sap-ui-static");}return this;};
var t=Object.create(null);
I.getStaticId=function(s,T){var b="",k,B,o;if(sap.ui.getCore().getConfiguration().getAccessibility()&&T){k=s+"|"+T;b=t[k];if(b==null){B=sap.ui.getCore().getLibraryResourceBundle(s);o=new I().setText(B.getText(T));o.toStatic();b=t[k]=o.getId();}}return b;};
sap.ui.getCore().attachLocalizationChanged(function(e){var c=sap.ui.getCore(),k,p,b,T;for(k in t){p=k.indexOf('|');b=c.getLibraryResourceBundle(k.slice(0,p));T=c.byId(t[k]);T&&T.setText(b.getText(k.slice(p+1)));}});return I;});
sap.ui.predefine('sap/ui/core/Item',['./Element','./library'],function(E,l){"use strict";var T=l.TextDirection;
var I=E.extend("sap.ui.core.Item",{metadata:{library:"sap.ui.core",properties:{text:{type:"string",group:"Misc",defaultValue:""},enabled:{type:"boolean",group:"Misc",defaultValue:true},textDirection:{type:"sap.ui.core.TextDirection",group:"Misc",defaultValue:T.Inherit},key:{type:"string",group:"Data",defaultValue:null}}}});
return I;});
sap.ui.predefine('sap/ui/core/LayoutData',['./Element','./library',"sap/ui/thirdparty/jquery"],function(E,l,q){"use strict";
var L=E.extend("sap.ui.core.LayoutData",{metadata:{"abstract":true,library:"sap.ui.core"}});
L.prototype.invalidate=function(){var p=this.getParent();if(p&&p.getMetadata().getName()=="sap.ui.core.VariantLayoutData"){p=p.getParent();}if(p){var o=p.getParent();if(o){var e=q.Event("LayoutDataChange");e.srcControl=p;o._handleEvent(e);}}};
L.prototype.setLayoutData=function(o){return this;};
return L;});
sap.ui.predefine('sap/ui/core/ListItem',['./Item','./library'],function(I,l){"use strict";
var L=I.extend("sap.ui.core.ListItem",{metadata:{library:"sap.ui.core",properties:{icon:{type:"string",group:"Appearance",defaultValue:null},additionalText:{type:"string",group:"Data",defaultValue:null}}}});
return L;});
sap.ui.predefine('sap/ui/core/LocalBusyIndicator',['./Control','./library','./theming/Parameters',"./LocalBusyIndicatorRenderer","sap/ui/thirdparty/jquery"],function(C,l,P,L,q){"use strict";
var a=C.extend("sap.ui.core.LocalBusyIndicator",{metadata:{deprecated:true,library:"sap.ui.core",properties:{width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:'100px'},height:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:'100px'}}}});
(function(){
a.prototype.init=function(){var r="sap.ui.core.LocalBusyIndicator:";var p="sapUiLocalBusyIndicatorBoxSize";p=P.get(r+p);this._iBoxSize=8;p="sapUiLocalBusyIndicatorBoxColor";this._sBoxColor=P.get(r+p);p="sapUiLocalBusyIndicatorBoxColorActive";this._sBoxColorActive=P.get(r+p);this._animateProxy=q.proxy(A,this);};
a.prototype.exit=function(){clearTimeout(this._delayedCallId);delete this._delayedCallId;};
a.prototype.onThemeChanged=function(e){if(this.getDomRef()){this.invalidate();}};
a.prototype.onAfterRendering=function(){var w=parseInt(this.getWidth());var h=parseInt(this.getHeight());var $=this.$();$.css("width",w+"px");$.css("height",h+"px");var b=this.$("animation");var c=Math.floor(w/2);c-=Math.floor((5*this._iBoxSize)/2);var t=Math.floor(h/2)-Math.floor(this._iBoxSize/2);b.css("left",c+"px");b.css("top",t+"px");if(!this._$left){this._$left=this.$("leftBox");}if(!this._$middle){this._$middle=this.$("middleBox");}if(!this._$right){this._$right=this.$("rightBox");}this._delayedCallId=setTimeout(this._animateProxy.bind(this),0);};
var A=function(){if(this.getDomRef()){var t=this;var $,b,c;var d="",e="";if(t._$left){$=t._$left;}else{return;}if(t._$middle){b=t._$middle;}else{return;}if(t._$right){c=t._$right;}else{return;}if(t._sBoxColor){d=t._sBoxColor;}else{return;}if(t._sBoxColorActive){e=t._sBoxColorActive;}else{return;}$.css("background-color",e);setTimeout(function(){$.css("background-color",d);b.css("background-color",e);setTimeout(function(){b.css("background-color",d);c.css("background-color",e);setTimeout(function(){c.css("background-color",d);},150);},150);},150);this._delayedCallId=setTimeout(this._animateProxy.bind(this),1200);}};}());return a;});
sap.ui.predefine('sap/ui/core/LocalBusyIndicatorRenderer',function(){"use strict";var L={apiVersion:2};
L.render=function(R,c){R.openStart("div",c);R.class("sapUiLocalBusyIndicator");R.openEnd();r(R,c);R.close("div");};
var r=function(R,c){var I=c.getId();var s=I+"-animation";var b=["-leftBox","-middleBox","-rightBox"];R.openStart('div',s);R.class("sapUiLocalBusyIndicatorAnimation");R.openEnd();for(var i=0;i<b.length;i++){R.openStart('div',I+b[i]);R.class("sapUiLocalBusyIndicatorBox");R.openEnd();R.close("div");}R.close("div");};return L;},true);
sap.ui.predefine('sap/ui/core/LocalBusyIndicatorSupport',['./Control',"sap/base/Log"],function(C,L){"use strict";var a=function(){if(this===C.prototype){this.setDelay=this.setBusyIndicatorDelay;}else{L.error("Only controls can use the LocalBusyIndicator",this);}};return a;},true);
sap.ui.predefine('sap/ui/core/LocaleData',['sap/base/util/extend','sap/ui/base/Object','./CalendarType','./Locale','sap/base/assert','sap/base/util/LoaderExtensions'],function(e,B,C,L,a,b){"use strict";
var c=B.extend("sap.ui.core.LocaleData",{
constructor:function(o){this.oLocale=o;B.apply(this);this.mData=k(o);},
_get:function(){return this._getDeep(this.mData,arguments);},
_getMerged:function(){return this._get.apply(this,arguments);},
_getDeep:function(o,p){var r=o;for(var i=0;i<p.length;i++){r=r[p[i]];if(r===undefined){break;}}return r;},
getOrientation:function(){return this._get("orientation");},
getLanguages:function(){return this._get("languages");},
getScripts:function(){return this._get("scripts");},
getTerritories:function(){return this._get("territories");},
getMonths:function(w,s){a(w=="narrow"||w=="abbreviated"||w=="wide","sWidth must be narrow, abbreviated or wide");return this._get(h(s),"months","format",w);},
getMonthsStandAlone:function(w,s){a(w=="narrow"||w=="abbreviated"||w=="wide","sWidth must be narrow, abbreviated or wide");return this._get(h(s),"months","stand-alone",w);},
getDays:function(w,s){a(w=="narrow"||w=="abbreviated"||w=="wide"||w=="short","sWidth must be narrow, abbreviate, wide or short");return this._get(h(s),"days","format",w);},
getDaysStandAlone:function(w,s){a(w=="narrow"||w=="abbreviated"||w=="wide"||w=="short","sWidth must be narrow, abbreviated, wide or short");return this._get(h(s),"days","stand-alone",w);},
getQuarters:function(w,s){a(w=="narrow"||w=="abbreviated"||w=="wide","sWidth must be narrow, abbreviated or wide");return this._get(h(s),"quarters","format",w);},
getQuartersStandAlone:function(w,s){a(w=="narrow"||w=="abbreviated"||w=="wide","sWidth must be narrow, abbreviated or wide");return this._get(h(s),"quarters","stand-alone",w);},
getDayPeriods:function(w,s){a(w=="narrow"||w=="abbreviated"||w=="wide","sWidth must be narrow, abbreviated or wide");return this._get(h(s),"dayPeriods","format",w);},
getDayPeriodsStandAlone:function(w,s){a(w=="narrow"||w=="abbreviated"||w=="wide","sWidth must be narrow, abbreviated or wide");return this._get(h(s),"dayPeriods","stand-alone",w);},
getDatePattern:function(s,i){a(s=="short"||s=="medium"||s=="long"||s=="full","sStyle must be short, medium, long or full");return this._get(h(i),"dateFormats",s);},
getTimePattern:function(s,i){a(s=="short"||s=="medium"||s=="long"||s=="full","sStyle must be short, medium, long or full");return this._get(h(i),"timeFormats",s);},
getDateTimePattern:function(s,i){a(s=="short"||s=="medium"||s=="long"||s=="full","sStyle must be short, medium, long or full");return this._get(h(i),"dateTimeFormats",s);},
getCombinedDateTimePattern:function(D,t,s){a(D=="short"||D=="medium"||D=="long"||D=="full","sStyle must be short, medium, long or full");a(t=="short"||t=="medium"||t=="long"||t=="full","sStyle must be short, medium, long or full");var i=this.getDateTimePattern(D,s),j=this.getDatePattern(D,s),T=this.getTimePattern(t,s);return i.replace("{0}",T).replace("{1}",j);},
getCustomDateTimePattern:function(s,i){var A=this._get(h(i),"dateTimeFormats","availableFormats");return this._getFormatPattern(s,A,i);},
getIntervalPattern:function(i,s){var I=this._get(h(s),"dateTimeFormats","intervalFormats"),j,o,D,p,P;if(i){j=i.split("-");o=j[0];D=j[1];p=I[o];if(p){P=p[D];if(P){return P;}}}return I.intervalFormatFallback;},
getCombinedIntervalPattern:function(p,s){var i=this._get(h(s),"dateTimeFormats","intervalFormats"),F=i.intervalFormatFallback;return F.replace(/\{(0|1)\}/g,p);},
getCustomIntervalPattern:function(s,G,i){var A=this._get(h(i),"dateTimeFormats","intervalFormats");return this._getFormatPattern(s,A,i,G);},
_getFormatPattern:function(s,A,i,D){var p,P,I;if(!D){p=A[s];}else if(typeof D==="string"){if(D=="j"||D=="J"){D=this.getPreferredHourSymbol();}I=A[s];p=I&&I[D];}if(p){if(typeof p==="object"){P=Object.keys(p).map(function(K){return p[K];});}else{return p;}}if(!P){P=this._createFormatPattern(s,A,i,D);}if(P&&P.length===1){return P[0];}return P;},
_createFormatPattern:function(s,A,j,D){var t=this._parseSkeletonFormat(s),p,o=this._findBestMatch(t,s,A),T,q,S,G,P,r,u,v,w=/^([GyYqQMLwWEecdD]+)([hHkKjJmszZvVOXx]+)$/,x,i;if(D){if(typeof D==="string"){v=d[D]?d[D].group:"";if(v){x=m[v].index>t[t.length-1].index;}u=D;}else{x=true;if(t[0].symbol==="y"&&o&&o.pattern.G){S=d["G"];G=m[S.group];t.splice(0,0,{symbol:"G",group:S.group,match:S.match,index:G.index,field:G.field,length:1});}for(i=t.length-1;i>=0;i--){T=t[i];if(D[T.group]){x=false;break;}}for(i=0;i<t.length;i++){T=t[i];if(D[T.group]){u=T.symbol;break;}}if((u=="h"||u=="K")&&D.DayPeriod){u="a";}}if(x){return[this.getCustomDateTimePattern(s,j)];}if(o&&o.missingTokens.length===0){P=o.pattern[u];if(P&&o.distance>0){P=this._expandFields(P,o.patternTokens,t);}}if(!P){q=this._get(h(j),"dateTimeFormats","availableFormats");if(w.test(s)&&"ahHkKjJms".indexOf(u)>=0){P=this._getMixedFormatPattern(s,q,j,D);}else{r=this._getFormatPattern(s,q,j);P=this.getCombinedIntervalPattern(r,j);}}p=[P];}else if(!o){P=s;p=[P];}else{if(typeof o.pattern==="string"){p=[o.pattern];}else if(typeof o.pattern==="object"){p=[];for(var K in o.pattern){P=o.pattern[K];p.push(P);}}if(o.distance>0){if(o.missingTokens.length>0){if(w.test(s)){p=[this._getMixedFormatPattern(s,A,j)];}else{p=this._expandFields(p,o.patternTokens,t);p=this._appendItems(p,o.missingTokens,j);}}else{p=this._expandFields(p,o.patternTokens,t);}}}if(s.indexOf("J")>=0){p.forEach(function(P,I){p[I]=P.replace(/ ?[abB](?=([^']*'[^']*')*[^']*)$/g,"");});}return p;},
_parseSkeletonFormat:function(s){var t=[],T={index:-1},S,o,G;for(var i=0;i<s.length;i++){S=s.charAt(i);if(S=="j"||S=="J"){S=this.getPreferredHourSymbol();}if(S==T.symbol){T.length++;continue;}o=d[S];G=m[o.group];if(o.group=="Other"||G.diffOnly){throw new Error("Symbol '"+S+"' is not allowed in skeleton format '"+s+"'");}if(G.index<=T.index){throw new Error("Symbol '"+S+"' at wrong position or duplicate in skeleton format '"+s+"'");}T={symbol:S,group:o.group,match:o.match,index:G.index,field:G.field,length:1};t.push(T);}return t;},
_findBestMatch:function(t,s,A){var T,j,o,p,q,D,r,F,u,v,w={distance:10000,firstDiffPos:-1};for(var x in A){if(x==="intervalFormatFallback"||x.indexOf("B")>-1){continue;}T=this._parseSkeletonFormat(x);D=0;j=[];r=true;if(t.length<T.length){continue;}q=0;F=t.length;for(var i=0;i<t.length;i++){o=t[i];p=T[q];if(F===t.length){F=i;}if(p){u=d[o.symbol];v=d[p.symbol];if(o.symbol===p.symbol){if(o.length===p.length){if(F===i){F=t.length;}}else{if(o.length<u.numericCeiling?p.length<v.numericCeiling:p.length>=v.numericCeiling){D+=Math.abs(o.length-p.length);}else{D+=5;}}q++;continue;}else{if(o.match==p.match){D+=Math.abs(o.length-p.length)+10;q++;continue;}}}j.push(o);D+=50-i;}if(q<T.length){r=false;}if(r&&(D<w.distance||(D===w.distance&&F>w.firstDiffPos))){w.distance=D;w.firstDiffPos=F;w.missingTokens=j;w.pattern=A[x];w.patternTokens=T;}}if(w.pattern){return w;}},
_expandFields:function(p,P,t){var s=(typeof p==="string");var o;if(s){o=[p];}else{o=p;}var r=o.map(function(q){var G={},u={},R="",Q=false,i=0,S,v,w,N,x,y,z,A;t.forEach(function(T){G[T.group]=T;});P.forEach(function(T){u[T.group]=T;});while(i<q.length){A=q.charAt(i);if(Q){R+=A;if(A=="'"){Q=false;}}else{z=d[A];if(z&&G[z.group]&&u[z.group]){x=G[z.group];y=u[z.group];S=x.length;w=y.length;v=1;while(q.charAt(i+1)==A){i++;v++;}if(S===w||((S<z.numericCeiling)?(v>=z.numericCeiling):(v<z.numericCeiling))){N=v;}else{N=Math.max(v,S);}for(var j=0;j<N;j++){R+=A;}}else{R+=A;if(A=="'"){Q=true;}}}i++;}return R;});return s?r[0]:r;},
_appendItems:function(p,j,s){var A=this._get(h(s),"dateTimeFormats","appendItems");p.forEach(function(P,I){var D,o,q;j.forEach(function(t){o=A[t.group];D="'"+this.getDisplayName(t.field)+"'";q="";for(var i=0;i<t.length;i++){q+=t.symbol;}p[I]=o.replace(/\{0\}/,P).replace(/\{1\}/,q).replace(/\{2\}/,D);}.bind(this));}.bind(this));return p;},
_getMixedFormatPattern:function(s,A,i,D){var r=/^([GyYqQMLwWEecdD]+)([hHkKjJmszZvVOXx]+)$/,j=/MMMM|LLLL/,o=/MMM|LLL/,p=/E|e|c/,R,q,t,S,u,T,v,w;R=r.exec(s);q=R[1];t=R[2];u=this._getFormatPattern(q,A,i);if(D){T=this.getCustomIntervalPattern(t,D,i);}else{T=this._getFormatPattern(t,A,i);}if(j.test(q)){S=p.test(q)?"full":"long";}else if(o.test(q)){S="medium";}else{S="short";}v=this.getDateTimePattern(S,i);w=v.replace(/\{1\}/,u).replace(/\{0\}/,T);return w;},
getNumberSymbol:function(t){a(t=="decimal"||t=="group"||t=="plusSign"||t=="minusSign"||t=="percentSign","sType must be decimal, group, plusSign, minusSign or percentSign");return this._get("symbols-latn-"+t);},
getLenientNumberSymbols:function(t){a(t=="plusSign"||t=="minusSign","sType must be plusSign or minusSign");return this._get("lenient-scope-number")[t];},
getDecimalPattern:function(){return this._get("decimalFormat").standard;},
getCurrencyPattern:function(s){return this._get("currencyFormat")[s]||this._get("currencyFormat").standard;},
getCurrencySpacing:function(p){return this._get("currencyFormat","currencySpacing",p==="after"?"afterCurrency":"beforeCurrency");},
getPercentPattern:function(){return this._get("percentFormat").standard;},
getMiscPattern:function(N){a(N=="approximately"||N=="atLeast"||N=="atMost"||N=="range","sName must be approximately, atLeast, atMost or range");return this._get("miscPattern")[N];},
getMinimalDaysInFirstWeek:function(){return this._get("weekData-minDays");},
getFirstDayOfWeek:function(){return this._get("weekData-firstDay");},
getWeekendStart:function(){return this._get("weekData-weekendStart");},
getWeekendEnd:function(){return this._get("weekData-weekendEnd");},
getCustomCurrencyCodes:function(){var i=this._get("currency")||{},j={};Object.keys(i).forEach(function(s){j[s]=s;});return j;},
getCurrencyDigits:function(s){var i=this._get("currency");if(i){if(i[s]&&i[s].hasOwnProperty("digits")){return i[s].digits;}else if(i["DEFAULT"]&&i["DEFAULT"].hasOwnProperty("digits")){return i["DEFAULT"].digits;}}var D=this._get("currencyDigits",s);if(D==null){D=this._get("currencyDigits","DEFAULT");if(D==null){D=2;}}return D;},
getCurrencySymbol:function(s){var o=this.getCurrencySymbols();return(o&&o[s])||s;},
getCurrencyCodeBySymbol:function(s){var o=this._get("currencySymbols"),i;for(i in o){if(o[i]===s){return i;}}return s;},
getCurrencySymbols:function(){var i=this._get("currency"),j={},I;for(var s in i){I=i[s].isoCode;if(i[s].symbol){j[s]=i[s].symbol;}else if(I){j[s]=this._get("currencySymbols")[I];}}return Object.assign({},this._get("currencySymbols"),j);},
getUnitDisplayName:function(u){var U=this.getUnitFormat(u);return(U&&U["displayName"])||"";},
getRelativePatterns:function(s,S){if(S===undefined){S="wide";}a(S==="wide"||S==="short"||S==="narrow","sStyle is only allowed to be set with 'wide', 'short' or 'narrow'");var p=[],P=this.getPluralCategories(),o,t,v,i;if(!s){s=["year","month","week","day","hour","minute","second"];}s.forEach(function(j){o=this._get("dateFields",j+"-"+S);for(var E in o){if(E.indexOf("relative-type-")===0){v=parseInt(E.substr(14));p.push({scale:j,value:v,pattern:o[E]});}else if(E.indexOf("relativeTime-type-")==0){t=o[E];i=E.substr(18)==="past"?-1:1;P.forEach(function(K){p.push({scale:j,sign:i,pattern:t["relativeTimePattern-count-"+K]});});}}}.bind(this));return p;},
getRelativePattern:function(s,D,F,S){var p,t,K,P;if(typeof F==="string"){S=F;F=undefined;}if(F===undefined){F=D>0;}if(S===undefined){S="wide";}a(S==="wide"||S==="short"||S==="narrow","sStyle is only allowed to be set with 'wide', 'short' or 'narrow'");K=s+"-"+S;if(D===0||D===-2||D===2){p=this._get("dateFields",K,"relative-type-"+D);}if(!p){t=this._get("dateFields",K,"relativeTime-type-"+(F?"future":"past"));P=this.getPluralCategory(Math.abs(D).toString());p=t["relativeTimePattern-count-"+P];}return p;},
getRelativeSecond:function(D,s){return this.getRelativePattern("second",D,s);},
getRelativeMinute:function(D,s){if(D==0){return null;}return this.getRelativePattern("minute",D,s);},
getRelativeHour:function(D,s){if(D==0){return null;}return this.getRelativePattern("hour",D,s);},
getRelativeDay:function(D,s){return this.getRelativePattern("day",D,s);},
getRelativeWeek:function(D,s){return this.getRelativePattern("week",D,s);},
getRelativeMonth:function(D,s){return this.getRelativePattern("month",D,s);},
getDisplayName:function(t,s){a(t=="second"||t=="minute"||t=="hour"||t=="zone"||t=="day"||t=="weekday"||t=="week"||t=="month"||t=="quarter"||t=="year"||t=="era","sType must be second, minute, hour, zone, day, weekday, week, month, quarter, year, era");if(s===undefined){s="wide";}a(s==="wide"||s==="short"||s==="narrow","sStyle is only allowed to be set with 'wide', 'short' or 'narrow'");var S=["era","weekday","zone"],K=S.indexOf(t)===-1?t+"-"+s:t;return this._get("dateFields",K,"displayName");},
getRelativeYear:function(D,s){return this.getRelativePattern("year",D,s);},
getDecimalFormat:function(s,N,p){var F;var o;switch(s){case"long":o=this._get("decimalFormat-long");break;default:o=this._get("decimalFormat-short");break;}if(o){var i=N+"-"+p;F=o[i];if(!F){i=N+"-other";F=o[i];}}return F;},
getCurrencyFormat:function(s,N,p){var F;var o=this._get("currencyFormat-"+s);if(!o){if(s==="sap-short"){throw new Error("Failed to get CLDR data for property \"currencyFormat-sap-short\"");}o=this._get("currencyFormat-short");}if(o){var i=N+"-"+p;F=o[i];if(!F){i=N+"-other";F=o[i];}}return F;},
getListFormat:function(t,s){var F=this._get("listPattern-"+(t||"standard")+"-"+(s||"wide"));if(F){return F;}return{};},
getResolvedUnitFormat:function(u){u=this.getUnitFromMapping(u)||u;return this.getUnitFormat(u);},
getUnitFormat:function(u){return this._get("units","short",u);},
getUnitFormats:function(){return this._getMerged("units","short");},
getUnitFromMapping:function(s){return this._get("unitMappings",s);},
getEras:function(w,s){a(w=="wide"||w=="abbreviated"||w=="narrow","sWidth must be wide, abbreviate or narrow");var E=this._get(h(s),"era-"+w),j=[];for(var i in E){j[parseInt(i)]=E[i];}return j;},
getEraDates:function(s){var E=this._get("eras-"+s.toLowerCase()),j=[];for(var i in E){j[parseInt(i)]=E[i];}return j;},
getCalendarWeek:function(s,w){a(s=="wide"||s=="narrow","sStyle must be wide or narrow");var o=sap.ui.getCore().getLibraryResourceBundle("sap.ui.core",this.oLocale.toString()),K="date.week.calendarweek."+s;return o.getText(K,w);},
getPreferredCalendarType:function(){var s=this._get("calendarPreference"),j=s?s.split(" "):[],o,t,i;for(i=0;i<j.length;i++){o=j[i].split("-")[0];for(t in C){if(o===t.toLowerCase()){return t;}}}return C.Gregorian;},
getPreferredHourSymbol:function(){return this._get("timeData","_preferred");},
getPluralCategories:function(){var p=this._get("plurals"),i=Object.keys(p);i.push("other");return i;},
getPluralCategory:function(N){var p=this._get("plurals");if(typeof N==="number"){N=N.toString();}if(!this._pluralTest){this._pluralTest={};}for(var s in p){var t=this._pluralTest[s];if(!t){t=this._parsePluralRule(p[s]);this._pluralTest[s]=t;}if(t(N)){return s;}}return"other";},
_parsePluralRule:function(r){var O="or",j="and",p="%",q="=",s="!=",t="n",u="i",v="f",w="t",x="v",y="w",R="..",S=",";var i=0,T;T=r.split(" ");function z(o){if(T[i]===o){i++;return true;}return false;}function A(){var o=T[i];i++;return o;}function D(){var K,J;K=E();if(z(O)){J=D();return function(o){return K(o)||J(o);};}return K;}function E(){var K,N;K=F();if(z(j)){N=E();return function(o){return K(o)&&N(o);};}return K;}function F(){var K,N,P;K=G();if(z(q)){P=true;}else if(z(s)){P=false;}else{throw new Error("Expected '=' or '!='");}N=I();if(P){return function(o){return N(o).indexOf(K(o))>=0;};}else{return function(o){return N(o).indexOf(K(o))===-1;};}}function G(){var K;K=H();if(z(p)){var N=parseInt(A());return function(o){return K(o)%N;};}return K;}function H(){if(z(t)){return function(o){return o.n;};}else if(z(u)){return function(o){return o.i;};}else if(z(v)){return function(o){return o.f;};}else if(z(w)){return function(o){return o.t;};}else if(z(x)){return function(o){return o.v;};}else if(z(y)){return function(o){return o.w;};}else{throw new Error("Unknown operand: "+A());}}function I(){var V=[],K=A(),P=K.split(S),N,Q,U;P.forEach(function(o){N=o.split(R);if(N.length===1){V.push(parseInt(o));}else{Q=parseInt(N[0]);U=parseInt(N[1]);for(var i=Q;i<=U;i++){V.push(i);}}});return function(o){return V;};}var J=D();if(i!=T.length){throw new Error("Not completely parsed");}return function(V){var K=V.indexOf("."),N,P,Q,o;if(K===-1){N=V;P="";Q="";}else{N=V.substr(0,K);P=V.substr(K+1);Q=P.replace(/0+$/,'');}o={n:parseFloat(V),i:parseInt(N),v:P.length,w:Q.length,f:parseInt(P),t:parseInt(Q)};return J(o);};}
});
var m={"Era":{field:"era",index:0},"Year":{field:"year",index:1},"Quarter":{field:"quarter",index:2},"Month":{field:"month",index:3},"Week":{field:"week",index:4},"Day-Of-Week":{field:"weekday",index:5},"Day":{field:"day",index:6},"DayPeriod":{field:"hour",index:7,diffOnly:true},"Hour":{field:"hour",index:8},"Minute":{field:"minute",index:9},"Second":{field:"second",index:10},"Timezone":{field:"zone",index:11}};var d={"G":{group:"Era",match:"Era",numericCeiling:1},"y":{group:"Year",match:"Year",numericCeiling:100},"Y":{group:"Year",match:"Year",numericCeiling:100},"Q":{group:"Quarter",match:"Quarter",numericCeiling:3},"q":{group:"Quarter",match:"Quarter",numericCeiling:3},"M":{group:"Month",match:"Month",numericCeiling:3},"L":{group:"Month",match:"Month",numericCeiling:3},"w":{group:"Week",match:"Week",numericCeiling:100},"W":{group:"Week",match:"Week",numericCeiling:100},"d":{group:"Day",match:"Day",numericCeiling:100},"D":{group:"Day",match:"Day",numericCeiling:100},"E":{group:"Day-Of-Week",match:"Day-Of-Week",numericCeiling:1},"e":{group:"Day-Of-Week",match:"Day-Of-Week",numericCeiling:3},"c":{group:"Day-Of-Week",match:"Day-Of-Week",numericCeiling:2},"h":{group:"Hour",match:"Hour12",numericCeiling:100},"H":{group:"Hour",match:"Hour24",numericCeiling:100},"k":{group:"Hour",match:"Hour24",numericCeiling:100},"K":{group:"Hour",match:"Hour12",numericCeiling:100},"m":{group:"Minute",match:"Minute",numericCeiling:100},"s":{group:"Second",match:"Second",numericCeiling:100},"z":{group:"Timezone",match:"Timezone",numericCeiling:1},"Z":{group:"Timezone",match:"Timezone",numericCeiling:1},"O":{group:"Timezone",match:"Timezone",numericCeiling:1},"v":{group:"Timezone",match:"Timezone",numericCeiling:1},"V":{group:"Timezone",match:"Timezone",numericCeiling:1},"X":{group:"Timezone",match:"Timezone",numericCeiling:1},"x":{group:"Timezone",match:"Timezone",numericCeiling:1},"S":{group:"Other",numericCeiling:100},"u":{group:"Other",numericCeiling:100},"U":{group:"Other",numericCeiling:1},"r":{group:"Other",numericCeiling:100},"F":{group:"Other",numericCeiling:100},"g":{group:"Other",numericCeiling:100},"a":{group:"DayPeriod",numericCeiling:1},"b":{group:"Other",numericCeiling:1},"B":{group:"Other",numericCeiling:1},"A":{group:"Other",numericCeiling:100}};var M={"orientation":"left-to-right","languages":{},"scripts":{},"territories":{},"ca-gregorian":{"dateFormats":{"full":"EEEE, MMMM d, y","long":"MMMM d, y","medium":"MMM d, y","short":"M/d/yy"},"timeFormats":{"full":"h:mm:ss a zzzz","long":"h:mm:ss a z","medium":"h:mm:ss a","short":"h:mm a"},"dateTimeFormats":{"full":"{1} 'at' {0}","long":"{1} 'at' {0}","medium":"{1}, {0}","short":"{1}, {0}","availableFormats":{"d":"d","E":"ccc","Ed":"d E","Ehm":"E h:mm a","EHm":"E HH:mm","Ehms":"E h:mm:ss a","EHms":"E HH:mm:ss","Gy":"y G","GyMMM":"MMM y G","GyMMMd":"MMM d, y G","GyMMMEd":"E, MMM d, y G","h":"h a","H":"HH","hm":"h:mm a","Hm":"HH:mm","hms":"h:mm:ss a","Hms":"HH:mm:ss","hmsv":"h:mm:ss a v","Hmsv":"HH:mm:ss v","hmv":"h:mm a v","Hmv":"HH:mm v","M":"L","Md":"M/d","MEd":"E, M/d","MMM":"LLL","MMMd":"MMM d","MMMEd":"E, MMM d","MMMMd":"MMMM d","ms":"mm:ss","y":"y","yM":"M/y","yMd":"M/d/y","yMEd":"E, M/d/y","yMMM":"MMM y","yMMMd":"MMM d, y","yMMMEd":"E, MMM d, y","yMMMM":"MMMM y","yQQQ":"QQQ y","yQQQQ":"QQQQ y"},"appendItems":{"Day":"{0} ({2}: {1})","Day-Of-Week":"{0} {1}","Era":"{0} {1}","Hour":"{0} ({2}: {1})","Minute":"{0} ({2}: {1})","Month":"{0} ({2}: {1})","Quarter":"{0} ({2}: {1})","Second":"{0} ({2}: {1})","Timezone":"{0} {1}","Week":"{0} ({2}: {1})","Year":"{0} {1}"},"intervalFormats":{"intervalFormatFallback":"{0} \u2013 {1}","d":{"d":"d \u2013 d"},"h":{"a":"h a \u2013 h a","h":"h \u2013 h a"},"H":{"H":"HH \u2013 HH"},"hm":{"a":"h:mm a \u2013 h:mm a","h":"h:mm \u2013 h:mm a","m":"h:mm \u2013 h:mm a"},"Hm":{"H":"HH:mm \u2013 HH:mm","m":"HH:mm \u2013 HH:mm"},"hmv":{"a":"h:mm a \u2013 h:mm a v","h":"h:mm \u2013 h:mm a v","m":"h:mm \u2013 h:mm a v"},"Hmv":{"H":"HH:mm \u2013 HH:mm v","m":"HH:mm \u2013 HH:mm v"},"hv":{"a":"h a \u2013 h a v","h":"h \u2013 h a v"},"Hv":{"H":"HH \u2013 HH v"},"M":{"M":"M \u2013 M"},"Md":{"d":"M/d \u2013 M/d","M":"M/d \u2013 M/d"},"MEd":{"d":"E, M/d \u2013 E, M/d","M":"E, M/d \u2013 E, M/d"},"MMM":{"M":"MMM \u2013 MMM"},"MMMd":{"d":"MMM d \u2013 d","M":"MMM d \u2013 MMM d"},"MMMEd":{"d":"E, MMM d \u2013 E, MMM d","M":"E, MMM d \u2013 E, MMM d"},"y":{"y":"y \u2013 y"},"yM":{"M":"M/y \u2013 M/y","y":"M/y \u2013 M/y"},"yMd":{"d":"M/d/y \u2013 M/d/y","M":"M/d/y \u2013 M/d/y","y":"M/d/y \u2013 M/d/y"},"yMEd":{"d":"E, M/d/y \u2013 E, M/d/y","M":"E, M/d/y \u2013 E, M/d/y","y":"E, M/d/y \u2013 E, M/d/y"},"yMMM":{"M":"MMM \u2013 MMM y","y":"MMM y \u2013 MMM y"},"yMMMd":{"d":"MMM d \u2013 d, y","M":"MMM d \u2013 MMM d, y","y":"MMM d, y \u2013 MMM d, y"},"yMMMEd":{"d":"E, MMM d \u2013 E, MMM d, y","M":"E, MMM d \u2013 E, MMM d, y","y":"E, MMM d, y \u2013 E, MMM d, y"},"yMMMM":{"M":"MMMM \u2013 MMMM y","y":"MMMM y \u2013 MMMM y"}}},"months":{"format":{"abbreviated":["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],"narrow":["J","F","M","A","M","J","J","A","S","O","N","D"],"wide":["January","February","March","April","May","June","July","August","September","October","November","December"]},"stand-alone":{"abbreviated":["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],"narrow":["J","F","M","A","M","J","J","A","S","O","N","D"],"wide":["January","February","March","April","May","June","July","August","September","October","November","December"]}},"days":{"format":{"abbreviated":["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],"narrow":["S","M","T","W","T","F","S"],"short":["Su","Mo","Tu","We","Th","Fr","Sa"],"wide":["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"]},"stand-alone":{"abbreviated":["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],"narrow":["S","M","T","W","T","F","S"],"short":["Su","Mo","Tu","We","Th","Fr","Sa"],"wide":["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"]}},"quarters":{"format":{"abbreviated":["Q1","Q2","Q3","Q4"],"narrow":["1","2","3","4"],"wide":["1st quarter","2nd quarter","3rd quarter","4th quarter"]},"stand-alone":{"abbreviated":["Q1","Q2","Q3","Q4"],"narrow":["1","2","3","4"],"wide":["1st quarter","2nd quarter","3rd quarter","4th quarter"]}},"dayPeriods":{"format":{"abbreviated":["AM","PM"],"narrow":["a","p"],"wide":["AM","PM"]},"stand-alone":{"abbreviated":["AM","PM"],"narrow":["AM","PM"],"wide":["AM","PM"]}},"era-wide":{"0":"Before Christ","1":"Anno Domini"},"era-abbreviated":{"0":"BC","1":"AD"},"era-narrow":{"0":"B","1":"A"}},"eras-gregorian":{"0":{"_end":"0-12-31"},"1":{"_start":"1-01-01"}},"dateFields":{"era":{"displayName":"era"},"year-wide":{"displayName":"year","relative-type--1":"last year","relative-type-0":"this year","relative-type-1":"next year","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} year","relativeTimePattern-count-other":"in {0} years"},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} year ago","relativeTimePattern-count-other":"{0} years ago"}},"year-short":{"displayName":"yr.","relative-type--1":"last yr.","relative-type-0":"this yr.","relative-type-1":"next yr.","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} yr.","relativeTimePattern-count-other":"in {0} yr."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} yr. ago","relativeTimePattern-count-other":"{0} yr. ago"}},"year-narrow":{"displayName":"yr.","relative-type--1":"last yr.","relative-type-0":"this yr.","relative-type-1":"next yr.","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} yr.","relativeTimePattern-count-other":"in {0} yr."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} yr. ago","relativeTimePattern-count-other":"{0} yr. ago"}},"quarter-wide":{"displayName":"quarter","relative-type--1":"last quarter","relative-type-0":"this quarter","relative-type-1":"next quarter","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} quarter","relativeTimePattern-count-other":"in {0} quarters"},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} quarter ago","relativeTimePattern-count-other":"{0} quarters ago"}},"quarter-short":{"displayName":"qtr.","relative-type--1":"last qtr.","relative-type-0":"this qtr.","relative-type-1":"next qtr.","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} qtr.","relativeTimePattern-count-other":"in {0} qtrs."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} qtr. ago","relativeTimePattern-count-other":"{0} qtrs. ago"}},"quarter-narrow":{"displayName":"qtr.","relative-type--1":"last qtr.","relative-type-0":"this qtr.","relative-type-1":"next qtr.","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} qtr.","relativeTimePattern-count-other":"in {0} qtrs."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} qtr. ago","relativeTimePattern-count-other":"{0} qtrs. ago"}},"month-wide":{"displayName":"month","relative-type--1":"last month","relative-type-0":"this month","relative-type-1":"next month","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} month","relativeTimePattern-count-other":"in {0} months"},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} month ago","relativeTimePattern-count-other":"{0} months ago"}},"month-short":{"displayName":"mo.","relative-type--1":"last mo.","relative-type-0":"this mo.","relative-type-1":"next mo.","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} mo.","relativeTimePattern-count-other":"in {0} mo."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} mo. ago","relativeTimePattern-count-other":"{0} mo. ago"}},"month-narrow":{"displayName":"mo.","relative-type--1":"last mo.","relative-type-0":"this mo.","relative-type-1":"next mo.","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} mo.","relativeTimePattern-count-other":"in {0} mo."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} mo. ago","relativeTimePattern-count-other":"{0} mo. ago"}},"week-wide":{"displayName":"week","relative-type--1":"last week","relative-type-0":"this week","relative-type-1":"next week","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} week","relativeTimePattern-count-other":"in {0} weeks"},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} week ago","relativeTimePattern-count-other":"{0} weeks ago"},"relativePeriod":"the week of {0}"},"week-short":{"displayName":"wk.","relative-type--1":"last wk.","relative-type-0":"this wk.","relative-type-1":"next wk.","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} wk.","relativeTimePattern-count-other":"in {0} wk."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} wk. ago","relativeTimePattern-count-other":"{0} wk. ago"},"relativePeriod":"the week of {0}"},"week-narrow":{"displayName":"wk.","relative-type--1":"last wk.","relative-type-0":"this wk.","relative-type-1":"next wk.","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} wk.","relativeTimePattern-count-other":"in {0} wk."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} wk. ago","relativeTimePattern-count-other":"{0} wk. ago"},"relativePeriod":"the week of {0}"},"day-wide":{"displayName":"day","relative-type--1":"yesterday","relative-type-0":"today","relative-type-1":"tomorrow","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} day","relativeTimePattern-count-other":"in {0} days"},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} day ago","relativeTimePattern-count-other":"{0} days ago"}},"day-short":{"displayName":"day","relative-type--1":"yesterday","relative-type-0":"today","relative-type-1":"tomorrow","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} day","relativeTimePattern-count-other":"in {0} days"},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} day ago","relativeTimePattern-count-other":"{0} days ago"}},"day-narrow":{"displayName":"day","relative-type--1":"yesterday","relative-type-0":"today","relative-type-1":"tomorrow","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} day","relativeTimePattern-count-other":"in {0} days"},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} day ago","relativeTimePattern-count-other":"{0} days ago"}},"weekday":{"displayName":"day of the week"},"hour-wide":{"displayName":"hour","relative-type-0":"this hour","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} hour","relativeTimePattern-count-other":"in {0} hours"},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} hour ago","relativeTimePattern-count-other":"{0} hours ago"}},"hour-short":{"displayName":"hr.","relative-type-0":"this hour","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} hr.","relativeTimePattern-count-other":"in {0} hr."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} hr. ago","relativeTimePattern-count-other":"{0} hr. ago"}},"hour-narrow":{"displayName":"hr.","relative-type-0":"this hour","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} hr.","relativeTimePattern-count-other":"in {0} hr."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} hr. ago","relativeTimePattern-count-other":"{0} hr. ago"}},"minute-wide":{"displayName":"minute","relative-type-0":"this minute","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} minute","relativeTimePattern-count-other":"in {0} minutes"},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} minute ago","relativeTimePattern-count-other":"{0} minutes ago"}},"minute-short":{"displayName":"min.","relative-type-0":"this minute","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} min.","relativeTimePattern-count-other":"in {0} min."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} min. ago","relativeTimePattern-count-other":"{0} min. ago"}},"minute-narrow":{"displayName":"min.","relative-type-0":"this minute","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} min.","relativeTimePattern-count-other":"in {0} min."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} min. ago","relativeTimePattern-count-other":"{0} min. ago"}},"second-wide":{"displayName":"second","relative-type-0":"now","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} second","relativeTimePattern-count-other":"in {0} seconds"},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} second ago","relativeTimePattern-count-other":"{0} seconds ago"}},"second-short":{"displayName":"sec.","relative-type-0":"now","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} sec.","relativeTimePattern-count-other":"in {0} sec."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} sec. ago","relativeTimePattern-count-other":"{0} sec. ago"}},"second-narrow":{"displayName":"sec.","relative-type-0":"now","relativeTime-type-future":{"relativeTimePattern-count-one":"in {0} sec.","relativeTimePattern-count-other":"in {0} sec."},"relativeTime-type-past":{"relativeTimePattern-count-one":"{0} sec. ago","relativeTimePattern-count-other":"{0} sec. ago"}},"zone":{"displayName":"time zone"}},"decimalFormat":{"standard":"#,##0.###"},"currencyFormat":{"standard":"\xa4#,##0.00","currencySpacing":{"beforeCurrency":{"currencyMatch":"[:^S:]","surroundingMatch":"[:digit:]","insertBetween":"\xa0"},"afterCurrency":{"currencyMatch":"[:^S:]","surroundingMatch":"[:digit:]","insertBetween":"\xa0"}}},"percentFormat":{"standard":"#,##0%"},"miscPattern":{"approximately":"~{0}","atLeast":"{0}+","atMost":"\u2264{0}","range":"{0}\u2013{1}"},"symbols-latn-decimal":".","symbols-latn-group":",","symbols-latn-plusSign":"+","symbols-latn-minusSign":"-","symbols-latn-percentSign":"%","weekData-minDays":4,"weekData-firstDay":1,"weekData-weekendStart":6,"weekData-weekendEnd":0,"timeData":{_allowed:"H h",_preferred:"H"},"lenient-scope-number":{"minusSign":"\x2d\u2010\u2012\u2013\u207b\u208b\u2212\u2796\ufe63","commaSign":"\x2c\u060c\u066b\u3001\ufe10\ufe11\ufe50\ufe51\uff0c","plusSign":"\x2b\u207a\u208a\u2795\ufb29\ufe62"},"plurals":{},"units":{"short":{"per":{"compoundUnitPattern":"{0}/{1}"},"acceleration-g-force":{"displayName":"g-force","unitPattern-count-one":"{0} G","unitPattern-count-other":"{0} G"},"acceleration-meter-per-second-squared":{"displayName":"meters/sec\xb2","unitPattern-count-one":"{0} m/s\xb2","unitPattern-count-other":"{0} m/s\xb2"},"angle-revolution":{"displayName":"rev","unitPattern-count-one":"{0} rev","unitPattern-count-other":"{0} rev"},"angle-radian":{"displayName":"radians","unitPattern-count-one":"{0} rad","unitPattern-count-other":"{0} rad"},"angle-degree":{"displayName":"degrees","unitPattern-count-one":"{0} deg","unitPattern-count-other":"{0} deg"},"angle-arc-minute":{"displayName":"arcmins","unitPattern-count-one":"{0} arcmin","unitPattern-count-other":"{0} arcmins"},"angle-arc-second":{"displayName":"arcsecs","unitPattern-count-one":"{0} arcsec","unitPattern-count-other":"{0} arcsecs"},"area-square-kilometer":{"displayName":"km\xb2","unitPattern-count-one":"{0} km\xb2","unitPattern-count-other":"{0} km\xb2","perUnitPattern":"{0}/km\xb2"},"area-hectare":{"displayName":"hectares","unitPattern-count-one":"{0} ha","unitPattern-count-other":"{0} ha"},"area-square-meter":{"displayName":"meters\xb2","unitPattern-count-one":"{0} m\xb2","unitPattern-count-other":"{0} m\xb2","perUnitPattern":"{0}/m\xb2"},"area-square-centimeter":{"displayName":"cm\xb2","unitPattern-count-one":"{0} cm\xb2","unitPattern-count-other":"{0} cm\xb2","perUnitPattern":"{0}/cm\xb2"},"area-square-mile":{"displayName":"sq miles","unitPattern-count-one":"{0} sq mi","unitPattern-count-other":"{0} sq mi","perUnitPattern":"{0}/mi\xb2"},"area-acre":{"displayName":"acres","unitPattern-count-one":"{0} ac","unitPattern-count-other":"{0} ac"},"area-square-yard":{"displayName":"yards\xb2","unitPattern-count-one":"{0} yd\xb2","unitPattern-count-other":"{0} yd\xb2"},"area-square-foot":{"displayName":"sq feet","unitPattern-count-one":"{0} sq ft","unitPattern-count-other":"{0} sq ft"},"area-square-inch":{"displayName":"inches\xb2","unitPattern-count-one":"{0} in\xb2","unitPattern-count-other":"{0} in\xb2","perUnitPattern":"{0}/in\xb2"},"concentr-karat":{"displayName":"karats","unitPattern-count-one":"{0} kt","unitPattern-count-other":"{0} kt"},"concentr-milligram-per-deciliter":{"displayName":"mg/dL","unitPattern-count-one":"{0} mg/dL","unitPattern-count-other":"{0} mg/dL"},"concentr-millimole-per-liter":{"displayName":"millimol/liter","unitPattern-count-one":"{0} mmol/L","unitPattern-count-other":"{0} mmol/L"},"concentr-part-per-million":{"displayName":"parts/million","unitPattern-count-one":"{0} ppm","unitPattern-count-other":"{0} ppm"},"consumption-liter-per-kilometer":{"displayName":"liters/km","unitPattern-count-one":"{0} L/km","unitPattern-count-other":"{0} L/km"},"consumption-liter-per-100kilometers":{"displayName":"L/100 km","unitPattern-count-one":"{0} L/100 km","unitPattern-count-other":"{0} L/100 km"},"consumption-mile-per-gallon":{"displayName":"miles/gal","unitPattern-count-one":"{0} mpg","unitPattern-count-other":"{0} mpg"},"consumption-mile-per-gallon-imperial":{"displayName":"miles/gal Imp.","unitPattern-count-one":"{0} mpg Imp.","unitPattern-count-other":"{0} mpg Imp."},"digital-terabyte":{"displayName":"TByte","unitPattern-count-one":"{0} TB","unitPattern-count-other":"{0} TB"},"digital-terabit":{"displayName":"Tbit","unitPattern-count-one":"{0} Tb","unitPattern-count-other":"{0} Tb"},"digital-gigabyte":{"displayName":"GByte","unitPattern-count-one":"{0} GB","unitPattern-count-other":"{0} GB"},"digital-gigabit":{"displayName":"Gbit","unitPattern-count-one":"{0} Gb","unitPattern-count-other":"{0} Gb"},"digital-megabyte":{"displayName":"MByte","unitPattern-count-one":"{0} MB","unitPattern-count-other":"{0} MB"},"digital-megabit":{"displayName":"Mbit","unitPattern-count-one":"{0} Mb","unitPattern-count-other":"{0} Mb"},"digital-kilobyte":{"displayName":"kByte","unitPattern-count-one":"{0} kB","unitPattern-count-other":"{0} kB"},"digital-kilobit":{"displayName":"kbit","unitPattern-count-one":"{0} kb","unitPattern-count-other":"{0} kb"},"digital-byte":{"displayName":"byte","unitPattern-count-one":"{0} byte","unitPattern-count-other":"{0} byte"},"digital-bit":{"displayName":"bit","unitPattern-count-one":"{0} bit","unitPattern-count-other":"{0} bit"},"duration-century":{"displayName":"c","unitPattern-count-one":"{0} c","unitPattern-count-other":"{0} c"},"duration-year":{"displayName":"years","unitPattern-count-one":"{0} yr","unitPattern-count-other":"{0} yrs","perUnitPattern":"{0}/y"},"duration-month":{"displayName":"months","unitPattern-count-one":"{0} mth","unitPattern-count-other":"{0} mths","perUnitPattern":"{0}/m"},"duration-week":{"displayName":"weeks","unitPattern-count-one":"{0} wk","unitPattern-count-other":"{0} wks","perUnitPattern":"{0}/w"},"duration-day":{"displayName":"days","unitPattern-count-one":"{0} day","unitPattern-count-other":"{0} days","perUnitPattern":"{0}/d"},"duration-hour":{"displayName":"hours","unitPattern-count-one":"{0} hr","unitPattern-count-other":"{0} hr","perUnitPattern":"{0}/h"},"duration-minute":{"displayName":"mins","unitPattern-count-one":"{0} min","unitPattern-count-other":"{0} min","perUnitPattern":"{0}/min"},"duration-second":{"displayName":"secs","unitPattern-count-one":"{0} sec","unitPattern-count-other":"{0} sec","perUnitPattern":"{0}/s"},"duration-millisecond":{"displayName":"millisecs","unitPattern-count-one":"{0} ms","unitPattern-count-other":"{0} ms"},"duration-microsecond":{"displayName":"\u03bcsecs","unitPattern-count-one":"{0} \u03bcs","unitPattern-count-other":"{0} \u03bcs"},"duration-nanosecond":{"displayName":"nanosecs","unitPattern-count-one":"{0} ns","unitPattern-count-other":"{0} ns"},"electric-ampere":{"displayName":"amps","unitPattern-count-one":"{0} A","unitPattern-count-other":"{0} A"},"electric-milliampere":{"displayName":"milliamps","unitPattern-count-one":"{0} mA","unitPattern-count-other":"{0} mA"},"electric-ohm":{"displayName":"ohms","unitPattern-count-one":"{0} \u03a9","unitPattern-count-other":"{0} \u03a9"},"electric-volt":{"displayName":"volts","unitPattern-count-one":"{0} V","unitPattern-count-other":"{0} V"},"energy-kilocalorie":{"displayName":"kcal","unitPattern-count-one":"{0} kcal","unitPattern-count-other":"{0} kcal"},"energy-calorie":{"displayName":"cal","unitPattern-count-one":"{0} cal","unitPattern-count-other":"{0} cal"},"energy-foodcalorie":{"displayName":"Cal","unitPattern-count-one":"{0} Cal","unitPattern-count-other":"{0} Cal"},"energy-kilojoule":{"displayName":"kilojoule","unitPattern-count-one":"{0} kJ","unitPattern-count-other":"{0} kJ"},"energy-joule":{"displayName":"joules","unitPattern-count-one":"{0} J","unitPattern-count-other":"{0} J"},"energy-kilowatt-hour":{"displayName":"kW-hour","unitPattern-count-one":"{0} kWh","unitPattern-count-other":"{0} kWh"},"frequency-gigahertz":{"displayName":"GHz","unitPattern-count-one":"{0} GHz","unitPattern-count-other":"{0} GHz"},"frequency-megahertz":{"displayName":"MHz","unitPattern-count-one":"{0} MHz","unitPattern-count-other":"{0} MHz"},"frequency-kilohertz":{"displayName":"kHz","unitPattern-count-one":"{0} kHz","unitPattern-count-other":"{0} kHz"},"frequency-hertz":{"displayName":"Hz","unitPattern-count-one":"{0} Hz","unitPattern-count-other":"{0} Hz"},"length-kilometer":{"displayName":"km","unitPattern-count-one":"{0} km","unitPattern-count-other":"{0} km","perUnitPattern":"{0}/km"},"length-meter":{"displayName":"m","unitPattern-count-one":"{0} m","unitPattern-count-other":"{0} m","perUnitPattern":"{0}/m"},"length-decimeter":{"displayName":"dm","unitPattern-count-one":"{0} dm","unitPattern-count-other":"{0} dm"},"length-centimeter":{"displayName":"cm","unitPattern-count-one":"{0} cm","unitPattern-count-other":"{0} cm","perUnitPattern":"{0}/cm"},"length-millimeter":{"displayName":"mm","unitPattern-count-one":"{0} mm","unitPattern-count-other":"{0} mm"},"length-micrometer":{"displayName":"\xb5meters","unitPattern-count-one":"{0} \xb5m","unitPattern-count-other":"{0} \xb5m"},"length-nanometer":{"displayName":"nm","unitPattern-count-one":"{0} nm","unitPattern-count-other":"{0} nm"},"length-picometer":{"displayName":"pm","unitPattern-count-one":"{0} pm","unitPattern-count-other":"{0} pm"},"length-mile":{"displayName":"miles","unitPattern-count-one":"{0} mi","unitPattern-count-other":"{0} mi"},"length-yard":{"displayName":"yards","unitPattern-count-one":"{0} yd","unitPattern-count-other":"{0} yd"},"length-foot":{"displayName":"feet","unitPattern-count-one":"{0} ft","unitPattern-count-other":"{0} ft","perUnitPattern":"{0}/ft"},"length-inch":{"displayName":"inches","unitPattern-count-one":"{0} in","unitPattern-count-other":"{0} in","perUnitPattern":"{0}/in"},"length-parsec":{"displayName":"parsecs","unitPattern-count-one":"{0} pc","unitPattern-count-other":"{0} pc"},"length-light-year":{"displayName":"light yrs","unitPattern-count-one":"{0} ly","unitPattern-count-other":"{0} ly"},"length-astronomical-unit":{"displayName":"au","unitPattern-count-one":"{0} au","unitPattern-count-other":"{0} au"},"length-furlong":{"displayName":"furlongs","unitPattern-count-one":"{0} fur","unitPattern-count-other":"{0} fur"},"length-fathom":{"displayName":"fathoms","unitPattern-count-one":"{0} ftm","unitPattern-count-other":"{0} ftm"},"length-nautical-mile":{"displayName":"nmi","unitPattern-count-one":"{0} nmi","unitPattern-count-other":"{0} nmi"},"length-mile-scandinavian":{"displayName":"smi","unitPattern-count-one":"{0} smi","unitPattern-count-other":"{0} smi"},"length-point":{"displayName":"points","unitPattern-count-one":"{0} pt","unitPattern-count-other":"{0} pt"},"light-lux":{"displayName":"lux","unitPattern-count-one":"{0} lx","unitPattern-count-other":"{0} lx"},"mass-metric-ton":{"displayName":"t","unitPattern-count-one":"{0} t","unitPattern-count-other":"{0} t"},"mass-kilogram":{"displayName":"kg","unitPattern-count-one":"{0} kg","unitPattern-count-other":"{0} kg","perUnitPattern":"{0}/kg"},"mass-gram":{"displayName":"grams","unitPattern-count-one":"{0} g","unitPattern-count-other":"{0} g","perUnitPattern":"{0}/g"},"mass-milligram":{"displayName":"mg","unitPattern-count-one":"{0} mg","unitPattern-count-other":"{0} mg"},"mass-microgram":{"displayName":"\xb5g","unitPattern-count-one":"{0} \xb5g","unitPattern-count-other":"{0} \xb5g"},"mass-ton":{"displayName":"tons","unitPattern-count-one":"{0} tn","unitPattern-count-other":"{0} tn"},"mass-stone":{"displayName":"stones","unitPattern-count-one":"{0} st","unitPattern-count-other":"{0} st"},"mass-pound":{"displayName":"pounds","unitPattern-count-one":"{0} lb","unitPattern-count-other":"{0} lb","perUnitPattern":"{0}/lb"},"mass-ounce":{"displayName":"oz","unitPattern-count-one":"{0} oz","unitPattern-count-other":"{0} oz","perUnitPattern":"{0}/oz"},"mass-ounce-troy":{"displayName":"oz troy","unitPattern-count-one":"{0} oz t","unitPattern-count-other":"{0} oz t"},"mass-carat":{"displayName":"carats","unitPattern-count-one":"{0} CD","unitPattern-count-other":"{0} CD"},"power-gigawatt":{"displayName":"GW","unitPattern-count-one":"{0} GW","unitPattern-count-other":"{0} GW"},"power-megawatt":{"displayName":"MW","unitPattern-count-one":"{0} MW","unitPattern-count-other":"{0} MW"},"power-kilowatt":{"displayName":"kW","unitPattern-count-one":"{0} kW","unitPattern-count-other":"{0} kW"},"power-watt":{"displayName":"watts","unitPattern-count-one":"{0} W","unitPattern-count-other":"{0} W"},"power-milliwatt":{"displayName":"mW","unitPattern-count-one":"{0} mW","unitPattern-count-other":"{0} mW"},"power-horsepower":{"displayName":"hp","unitPattern-count-one":"{0} hp","unitPattern-count-other":"{0} hp"},"pressure-hectopascal":{"displayName":"hPa","unitPattern-count-one":"{0} hPa","unitPattern-count-other":"{0} hPa"},"pressure-millimeter-of-mercury":{"displayName":"mmHg","unitPattern-count-one":"{0} mmHg","unitPattern-count-other":"{0} mmHg"},"pressure-pound-per-square-inch":{"displayName":"psi","unitPattern-count-one":"{0} psi","unitPattern-count-other":"{0} psi"},"pressure-inch-hg":{"displayName":"inHg","unitPattern-count-one":"{0} inHg","unitPattern-count-other":"{0} inHg"},"pressure-millibar":{"displayName":"mbar","unitPattern-count-one":"{0} mbar","unitPattern-count-other":"{0} mbar"},"speed-kilometer-per-hour":{"displayName":"km/hour","unitPattern-count-one":"{0} kph","unitPattern-count-other":"{0} kph"},"speed-meter-per-second":{"displayName":"meters/sec","unitPattern-count-one":"{0} m/s","unitPattern-count-other":"{0} m/s"},"speed-mile-per-hour":{"displayName":"miles/hour","unitPattern-count-one":"{0} mph","unitPattern-count-other":"{0} mph"},"speed-knot":{"displayName":"kn","unitPattern-count-one":"{0} kn","unitPattern-count-other":"{0} kn"},"temperature-generic":{"displayName":"\xb0","unitPattern-count-other":"{0}\xb0"},"temperature-celsius":{"displayName":"deg. C","unitPattern-count-one":"{0}\xb0C","unitPattern-count-other":"{0}\xb0C"},"temperature-fahrenheit":{"displayName":"deg. F","unitPattern-count-one":"{0}\xb0F","unitPattern-count-other":"{0}\xb0F"},"temperature-kelvin":{"displayName":"K","unitPattern-count-one":"{0} K","unitPattern-count-other":"{0} K"},"volume-cubic-kilometer":{"displayName":"km\xb3","unitPattern-count-one":"{0} km\xb3","unitPattern-count-other":"{0} km\xb3"},"volume-cubic-meter":{"displayName":"m\xb3","unitPattern-count-one":"{0} m\xb3","unitPattern-count-other":"{0} m\xb3","perUnitPattern":"{0}/m\xb3"},"volume-cubic-centimeter":{"displayName":"cm\xb3","unitPattern-count-one":"{0} cm\xb3","unitPattern-count-other":"{0} cm\xb3","perUnitPattern":"{0}/cm\xb3"},"volume-cubic-mile":{"displayName":"mi\xb3","unitPattern-count-one":"{0} mi\xb3","unitPattern-count-other":"{0} mi\xb3"},"volume-cubic-yard":{"displayName":"yards\xb3","unitPattern-count-one":"{0} yd\xb3","unitPattern-count-other":"{0} yd\xb3"},"volume-cubic-foot":{"displayName":"feet\xb3","unitPattern-count-one":"{0} ft\xb3","unitPattern-count-other":"{0} ft\xb3"},"volume-cubic-inch":{"displayName":"inches\xb3","unitPattern-count-one":"{0} in\xb3","unitPattern-count-other":"{0} in\xb3"},"volume-megaliter":{"displayName":"ML","unitPattern-count-one":"{0} ML","unitPattern-count-other":"{0} ML"},"volume-hectoliter":{"displayName":"hL","unitPattern-count-one":"{0} hL","unitPattern-count-other":"{0} hL"},"volume-liter":{"displayName":"liters","unitPattern-count-one":"{0} L","unitPattern-count-other":"{0} L","perUnitPattern":"{0}/L"},"volume-deciliter":{"displayName":"dL","unitPattern-count-one":"{0} dL","unitPattern-count-other":"{0} dL"},"volume-centiliter":{"displayName":"cL","unitPattern-count-one":"{0} cL","unitPattern-count-other":"{0} cL"},"volume-milliliter":{"displayName":"mL","unitPattern-count-one":"{0} mL","unitPattern-count-other":"{0} mL"},"volume-pint-metric":{"displayName":"mpt","unitPattern-count-one":"{0} mpt","unitPattern-count-other":"{0} mpt"},"volume-cup-metric":{"displayName":"mcup","unitPattern-count-one":"{0} mc","unitPattern-count-other":"{0} mc"},"volume-acre-foot":{"displayName":"acre ft","unitPattern-count-one":"{0} ac ft","unitPattern-count-other":"{0} ac ft"},"volume-bushel":{"displayName":"bushels","unitPattern-count-one":"{0} bu","unitPattern-count-other":"{0} bu"},"volume-gallon":{"displayName":"gal","unitPattern-count-one":"{0} gal","unitPattern-count-other":"{0} gal","perUnitPattern":"{0}/gal US"},"volume-gallon-imperial":{"displayName":"Imp. gal","unitPattern-count-one":"{0} gal Imp.","unitPattern-count-other":"{0} gal Imp.","perUnitPattern":"{0}/gal Imp."},"volume-quart":{"displayName":"qts","unitPattern-count-one":"{0} qt","unitPattern-count-other":"{0} qt"},"volume-pint":{"displayName":"pints","unitPattern-count-one":"{0} pt","unitPattern-count-other":"{0} pt"},"volume-cup":{"displayName":"cups","unitPattern-count-one":"{0} c","unitPattern-count-other":"{0} c"},"volume-fluid-ounce":{"displayName":"fl oz","unitPattern-count-one":"{0} fl oz","unitPattern-count-other":"{0} fl oz"},"volume-tablespoon":{"displayName":"tbsp","unitPattern-count-one":"{0} tbsp","unitPattern-count-other":"{0} tbsp"},"volume-teaspoon":{"displayName":"tsp","unitPattern-count-one":"{0} tsp","unitPattern-count-other":"{0} tsp"},"coordinateUnit":{"east":"{0} E","north":"{0} N","south":"{0} S","west":"{0} W"}}}};var f={"iw":"he","ji":"yi","in":"id","sh":"sr"};var g=(function(){var j=L._cldrLocales,r={},i;if(j){for(i=0;i<j.length;i++){r[j[i]]=true;}}return r;}());var l={};
function h(s){if(!s){s=sap.ui.getCore().getConfiguration().getCalendarType();}return"ca-"+s.toLowerCase();}
function k(o){var s=o.getLanguage()||"",S=o.getScript()||"",r=o.getRegion()||"",D;function i(p,q){var t,v,u;if(!q){return;}for(t in q){if(q.hasOwnProperty(t)){v=p[t];u=q[t];if(v===undefined){p[t]=u;}else if(v===null){delete p[t];}else if(typeof v==='object'&&typeof u==='object'){i(v,u);}}}}function j(I){if(!l[I]&&(!g||g[I]===true)){var p=l[I]=b.loadResource("sap/ui/core/cldr/"+I+".json",{dataType:"json",failOnError:false});if(p&&p.__fallbackLocale){i(p,j(p.__fallbackLocale));delete p.__fallbackLocale;}}return l[I];}s=(s&&f[s])||s;if(s==="no"){s="nb";}if(s==="zh"&&!r){if(S==="Hans"){r="CN";}else if(S==="Hant"){r="TW";}}var I=s+"_"+r;if(s&&r){D=j(I);}if(!D&&s){D=j(s);}l[I]=D||M;return l[I];}
var n=c.extend("sap.ui.core.CustomLocaleData",{
constructor:function(o){c.apply(this,arguments);this.mCustomData=sap.ui.getCore().getConfiguration().getFormatSettings().getCustomLocaleData();},
_get:function(){var A=Array.prototype.slice.call(arguments),s,K;if(A[0].indexOf("ca-")==0){s=A[0];if(s==h()){A=A.slice(1);}}K=A.join("-");var v=this.mCustomData[K];if(v==null){v=this._getDeep(this.mCustomData,arguments);if(v==null){v=this._getDeep(this.mData,arguments);}}return v;},
_getMerged:function(){var D=this._getDeep(this.mData,arguments);var i=this._getDeep(this.mCustomData,arguments);return e({},D,i);}
});
c.getInstance=function(o){return o.hasPrivateUseSubtag("sapufmt")?new n(o):new c(o);};
return c;});
sap.ui.predefine('sap/ui/core/Message',['./Element','./library',"sap/base/Log"],function(E,l,L){"use strict";var M=l.MessageType;
var a=E.extend("sap.ui.core.Message",{metadata:{library:"sap.ui.core",properties:{text:{type:"string",group:"Misc",defaultValue:null},timestamp:{type:"string",group:"Misc",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},level:{type:"sap.ui.core.MessageType",group:"Misc",defaultValue:M.None},readOnly:{type:"boolean",group:"Misc",defaultValue:false}}}});
a.prototype.getDefaultIcon=function(s){var m=sap.ui.require.toUrl("sap/ui/core/themes/"+sap.ui.getCore().getConfiguration().getTheme());var i=m+"/img/message/";if(s&&s=="32x32"){i+="32x32/";}else{i+="16x16/";}var u="";switch(this.getProperty("level")){case M.Error:u=i+"Message_Icon_Error.png";break;case M.Information:u=i+"Message_Icon_Information.png";break;case M.Warning:u=i+"Message_Icon_Warning.png";break;case M.Success:u=i+"Message_Icon_Success.png";break;case M.None:default:u=this.getProperty("icon");break;}return u;};
a.prototype.compareByType=function(o){return a.compareByType(this,o);};
a.compareByType=function(m,o){if(!m&&!o){return 0;}if(m&&!o){return 1;}if(!m&&o){return-1;}var s=m.getLevel();var b=o.getLevel();if(s===b){return 0;}switch(s){case M.Error:return 1;case M.Warning:return b===M.Error?-1:1;case M.Success:return b===M.Error||b===M.Warning?-1:1;case M.Information:return b===M.None?1:-1;case M.None:return-1;default:L.error("Comparison error",this);return 0;}};
return a;});
sap.ui.predefine('sap/ui/core/Popup',['sap/ui/Device','sap/ui/base/ManagedObject','sap/ui/base/Object','sap/ui/base/ObjectPool','./Control','./IntervalTrigger','./RenderManager','./Element','./ResizeHandler','./library',"sap/base/assert","sap/base/Log","sap/base/util/Version","sap/base/util/uid","sap/base/util/extend","sap/base/util/deepExtend","sap/ui/dom/containsOrEquals","sap/ui/thirdparty/jquery","sap/ui/events/F6Navigation","sap/ui/events/isMouseEventDelayed","sap/ui/base/EventProvider","sap/ui/dom/jquery/control","sap/ui/dom/jquery/Focusable","sap/ui/dom/jquery/rect"],function(D,M,B,O,C,I,R,E,a,b,c,L,V,u,d,f,g,q,F,h,k){"use strict";var m=b.CSSSize;var n=b.OpenState;var s;
function o(){if(s){return s;}var S,i;try{S=sap.ui.getCore().getStaticAreaRef();s=sap.ui.getCore().getUIArea(S);}catch(e){L.error(e);throw new Error("Popup cannot be opened because static UIArea cannot be determined.");}i=new C();s.addDependent(i);s=i.getUIArea();i.destroy();return s;}
var P=M.extend("sap.ui.core.Popup",{
constructor:function(e,i,S,A){c(arguments.length==0||(e&&typeof e==="object"),"oContent must be an object or there may be no arguments at all");c((i===undefined||i===true||i===false),"bModal must be true, false, or undefined");c((S===undefined||S===true||S===false),"bShadow must be true, false, or undefined");c((A===undefined||A===true||A===false),"bAutoClose must be true, false, or undefined");M.apply(this);this._popupUID=u();this.bOpen=false;this.eOpenState=n.CLOSED;this._mEvents={};this._mEvents["sap.ui.core.Popup.addFocusableContent-"+this._popupUID]=this._addFocusableArea;this._mEvents["sap.ui.core.Popup.removeFocusableContent-"+this._popupUID]=this._removeFocusableArea;this._mEvents["sap.ui.core.Popup.closePopup-"+this._popupUID]=this._closePopup;this._mEvents["sap.ui.core.Popup.onFocusEvent-"+this._popupUID]=this.onFocusEvent;this._mEvents["sap.ui.core.Popup.increaseZIndex-"+this._popupUID]=this._increaseMyZIndex;this._mEvents["sap.ui.core.Popup.contains-"+this._popupUID]=this._containsEventBusWrapper;if(e){this.setContent(e);}this._oDefaultPosition={my:P.Dock.CenterCenter,at:P.Dock.CenterCenter,of:document,offset:"0 0",collision:"flip"};this._oPosition=Object.assign({},this._oDefaultPosition);this._bModal=!!i;this._oPreviousFocus=null;this._sInitialFocusId=null;this._bShadow=typeof(S)==="boolean"?S:true;this._bAutoClose=!!A;this._animations={open:null,close:null};this._durations={open:"fast",close:"fast"};this._iZIndex=-1;this._oBlindLayer=null;this.setNavigationMode();if(this.touchEnabled){this._fAutoCloseHandler=function(j){if(j.isMarked("delayedMouseEvent")||j.isMarked("cancelAutoClose")){return;}if(this.eOpenState===n.CLOSING||this.eOpenState===n.CLOSED){return;}if(!this._contains(j.target)){this.close();}};}this._F6NavigationHandler=function(j){var l={},v=this._sF6NavMode,w;if(v=="DOCK"){if(this._bModal){v="NONE";}else if(this._oLastPosition&&this._oLastPosition.of){w=this._getOfDom(this._oLastPosition.of);if(!w||w===document){w=null;v="NONE";}}}switch(v){case"SCOPE":l.scope=this._$()[0];break;case"DOCK":l.target=w;var $=q(w).parents("[data-sap-ui-popup]");l.scope=$.length?$[0]:null;break;default:l.skip=true;}F.handleF6GroupNavigation(j,l);};},
metadata:{library:"sap.ui.core",publicMethods:["open","close","setContent","getContent","setPosition","setShadow","setModal","getModal","setAutoClose","setAutoCloseAreas","setExtraContent","isOpen","getAutoClose","getOpenState","setAnimations","setDurations","attachOpened","attachClosed","detachOpened","detachClosed"],associations:{"childPopups":{type:"sap.ui.core.Popup",multiple:true,visibility:"hidden"}},events:{"opened":{},"closed":{}}}
});
P.prototype.getChildPopups=function(){return this.getAssociation("childPopups",[]);};
P.prototype.addChildPopup=function(v){return this.addAssociation("childPopups",v);};
P.prototype.removeChildPopup=function(v){return this.removeAssociation("childPopups",v);};
P._activateBlindLayer=true;P.blStack=[];P.Dock={BeginTop:"begin top",BeginCenter:"begin center",BeginBottom:"begin bottom",LeftTop:"left top",LeftCenter:"left center",LeftBottom:"left bottom",CenterTop:"center top",CenterCenter:"center center",CenterBottom:"center bottom",RightTop:"right top",RightCenter:"right center",RightBottom:"right bottom",EndTop:"end top",EndCenter:"end center",EndBottom:"end bottom"};P.prototype.touchEnabled=D.support.touch&&(D.browser.safari||!D.system.combi);P.prototype.preventBrowserFocus=D.support.touch&&!D.system.combi;
B.extend("sap.ui.core.Popup.Layer",{constructor:function(){var e=this.getDomString();this._$Ref=q(e).appendTo(sap.ui.getCore().getStaticAreaRef());}});
P.Layer.prototype.init=function(e,z){this._$Ref.css({"visibility":"visible","z-index":z});this.update(e,z);this._$Ref.insertAfter(e).show();};
P.Layer.prototype.update=function(e,z){if(e.length){var i=e.rect();this._$Ref.css({"left":i.left,"top":i.top});if(e.css("right")!="auto"&&e.css("right")!="inherit"){this._$Ref.css({"right":e.css("right"),"width":"auto"});}else{this._$Ref.css({"width":i.width,"right":"auto"});}if(e.css("bottom")!="auto"&&e.css("bottom")!="inherit"){this._$Ref.css({"bottom":e.css("bottom"),"height":"auto"});}else{this._$Ref.css({"height":i.height,"bottom":"auto"});}if(typeof(z)==="number"){this._$Ref.css("z-index",z);}}};
P.Layer.prototype.reset=function(){if(this._$Ref.length){this._$Ref[0].style.display="none";this._$Ref[0].style.visibility="hidden";this._$Ref.appendTo(sap.ui.getCore().getStaticAreaRef());}};
P.Layer.prototype.getDomString=function(){L.error("sap.ui.core.Popup.Layer: getDomString function must be overwritten!");return"";};
P.Layer.extend("sap.ui.core.Popup.BlindLayer",{constructor:function(){P.Layer.apply(this);}});
P.BlindLayer.prototype.getDomString=function(){return"<div class=\"sapUiBliLy\" id=\"sap-ui-blindlayer-"+u()+"\"><iframe scrolling=\"no\" tabIndex=\"-1\"></iframe></div>";};
P.prototype.oBlindLayerPool=new O(P.BlindLayer);
P.Layer.extend("sap.ui.core.Popup.ShieldLayer",{constructor:function(){P.Layer.apply(this);}});
P.ShieldLayer.prototype.getDomString=function(){return"<div class=\"sapUiPopupShield\" id=\"sap-ui-shieldlayer-"+u()+"\"></div>";};
P.prototype.oShieldLayerPool=new O(P.ShieldLayer);(function(){var l=0;var i=Math.pow(2,32)-1;
P.setInitialZIndex=function(e){if(e>=i){throw new Error("Z-index can't be higher than Number.MAX_SAFE_INTEGER");}l=Math.max(e,this.getLastZIndex());};
P.getLastZIndex=function(){return l;};
P.prototype.getLastZIndex=function(){return P.getLastZIndex();};
P.getNextZIndex=function(){l+=10;if(l>=i){throw new Error("Z-index can't be higher than Number.MAX_SAFE_INTEGER");}return l;};
P.prototype.getNextZIndex=function(){return P.getNextZIndex();};
}());var r=function(e,i){if((!e&&i)||(e&&!i)){return false;}if(!e&&!i){return true;}var j=3;var l=Math.abs(e.left-i.left);var T=Math.abs(e.top-i.top);var w=Math.abs(e.width-i.width);var H=Math.abs(e.height-i.height);if(l>j||T>j||w>j||H>j){return false;}return true;};
P.prototype.open=function(i,e,j,l,v,w,x){c(this.oContent,"Popup content must have been set by now");if(this.eOpenState!=n.CLOSED){return;}this.eOpenState=n.OPENING;var s=o(),U;this._bContentAddedToStatic=false;this._bUIAreaPatched=false;if(this.oContent instanceof C){if(!this.oContent.getParent()){s.addContent(this.oContent,true);this._bContentAddedToStatic=true;}else if(!this.oContent.getUIArea()){this.oContent.getUIArea=function(){return s;};this._bUIAreaPatched=true;}U=this.oContent.getUIArea();if(P._bEnableUIAreaCheck&&U.getRootNode().id!==s.getRootNode().id){L.warning("The Popup content is NOT connected with the static-UIArea and may not work properly!");}}if(typeof(i)=="string"){x=w;w=v;v=l;l=j;j=e;e=i;i=-1;}if(i===undefined){i=-1;}c(i===-1||(typeof i==="number"&&i%1==0),"iDuration must be an integer (or omitted)");c(e===undefined||typeof e==="string","my must be a string or empty");c(j===undefined||typeof j==="string","at must be a string or empty");c(!l||typeof l==="object"||typeof l==="function","of must be empty or an object");c(!v||typeof v==="string","offset must be empty or a string");c(!w||typeof w==="string","collision must be empty or a string");this._oPreviousFocus=P.getCurrentFocusInfo();if(this.isInPopup(l)||this.isInPopup(this._oPosition.of)){var y=this.getParentPopupId(l)||this.getParentPopupId(this._oPosition.of);var z="";var A=this.getContent();if(A instanceof E){z=A.getId();}else if(typeof A==="object"){z=A.id;}this.addChildToPopup(y,z);this.addChildToPopup(y,this._popupUID);}var $=this._$(true);var G="fast";if((i===0)||(i>0)){G=i;}else if((this._durations.open===0)||(this._durations.open>0)){G=this._durations.open;}var H;if(e||j||l||v||w){H=this._createPosition(e,j,l,v,w);this._oPosition=H;}else{H=this._oPosition;}if(!H.of){H.of=this._oPosition.of||document;}this._iZIndex=this._iZIndex===this.getLastZIndex()?this._iZIndex:this.getNextZIndex();var S=sap.ui.getCore().getStaticAreaRef();$.css({"position":"absolute","visibility":"hidden"});if(!($[0].parentNode==S)){$.appendTo(S);}$.css("z-index",this._iZIndex);L.debug("position popup content "+$.attr("id")+" at "+JSON.stringify(H.at));this._applyPosition(H);if(x!==undefined){this.setFollowOf(x);}$.toggleClass("sapUiShd",this._bShadow);var J=$[0];if(J){J.style.display="none";J.style.visibility="visible";}var N=G==0;this._duringOpen(!N);if(N){this._opened();}else if(this._animations.open){this._animations.open.call(null,$,G,this._opened.bind(this));}else{$.fadeIn(G,this._opened.bind(this));}};
P.prototype._getDomRefToFocus=function(){var $=this._$(false,true),e,i;if(this._shouldGetFocusAfterOpen()){if(this._sInitialFocusId){i=sap.ui.getCore().byId(this._sInitialFocusId);if(i){e=i.getFocusDomRef();}e=e||window.document.getElementById(this._sInitialFocusId);}e=e||$.firstFocusableDomRef();}return e;};
P.prototype._opened=function(){if(this.eOpenState!==n.OPENING){return;}this.bOpen=true;var $=this._$(false,true);if($[0]&&$[0].style){$[0].style.display="block";}if(this._shouldGetFocusAfterOpen()){var e=this._getDomRefToFocus();if(e){e.focus();}var i=this._getOfDom(this._oLastPosition.of);var j=q(i).rect();if(this._oLastOfRect&&j&&!r(this._oLastOfRect,j)){this._applyPosition(this._oLastPosition);}}this.eOpenState=n.OPEN;if(this.getFollowOf()){P.DockTrigger.addListener(P.checkDocking,this);}this._updateBlindLayer();this.fireOpened();};
P.prototype._duringOpen=function(e){var $=this._$(false,true),S=sap.ui.getCore().getStaticAreaRef(),i=document.getElementById(S.id+"-firstfe");P._clearSelection();this._setupUserSelection();if(h()){if(this._oTopShieldLayer){clearTimeout(this._iTopShieldRemoveTimer);this._iTopShieldRemoveTimer=null;}else{this._oTopShieldLayer=this.oShieldLayerPool.borrowObject($,this._iZIndex+1);}this._iTopShieldRemoveTimer=setTimeout(function(){this.oShieldLayerPool.returnObject(this._oTopShieldLayer);this._oTopShieldLayer=null;this._iTopShieldRemoveTimer=null;}.bind(this),500);}if(!!D.browser.msie&&!D.os.windows_phone&&P._activateBlindLayer){this._oBlindLayer=this.oBlindLayerPool.borrowObject($,this._iZIndex-1);}if(this._bModal){this._showBlockLayer();}if(e&&i&&this._shouldGetFocusAfterOpen()&&!this.isInPopup(document.activeElement)&&this._getDomRefToFocus()!==document.activeElement){i.focus({preventScroll:true});}if(this.oContent instanceof E){this.oContent.addDelegate(this);}this.bOpen=true;this._activateFocusHandle();this._$(false,true).on("keydown",q.proxy(this._F6NavigationHandler,this));if(this._oBlindLayer){this._resizeListenerId=a.register(this._$().get(0),q.proxy(this.onresize,this));}};
P.prototype._shouldGetFocusAfterOpen=function(){return this._bModal||this._bAutoClose||this._sInitialFocusId;};
P.prototype._contains=function(e){var i=this._$().get(0);if(!i){return false;}var j=g(i,e);var l;if(!j){l=this.getChildPopups();j=l.some(function(v){var w=(v?window.document.getElementById(v):null);var j=g(w,e);if(!j){var x="sap.ui.core.Popup.contains-"+v;var y={domRef:e};sap.ui.getCore().getEventBus().publish("sap.ui",x,y);j=y.contains;}return j;});}if(!j){p.forEach(function(S){j=j||q(e).closest(S).length>0;});}return j;};
P.prototype._containsEventBusWrapper=function(e,i,j){j.contains=this._contains(j.domRef);};
P.prototype.onFocusEvent=function(e){var i=q.event.fix(e);if(arguments.length>1&&arguments[1]==="sap.ui.core.Popup.onFocusEvent-"+this._popupUID){i=q.event.fix(arguments[2]);}var j=(i.type=="focus"||i.type=="activate")?"focus":"blur";var l=false;if(j=="focus"){var v=this._$().get(0);if(v){l=this._contains(i.target);L.debug("focus event on "+i.target.id+", contains: "+l);if(this._bModal&&!l){var T=P.blStack.length>0&&P.blStack[P.blStack.length-1].popup===this;if(T){if(D.system.desktop||q(i.target).is(":input")){if(this.oLastBlurredElement){setTimeout(function(){if(this.oLastBlurredElement){this.oLastBlurredElement.focus();}}.bind(this),0);}else{v.focus();}}}}else if(this._bAutoClose&&l&&this._sTimeoutId){clearTimeout(this._sTimeoutId);this._sTimeoutId=null;}}}else if(j=="blur"){L.debug("blur event on "+i.target.id);if(this._bModal){this.oLastBlurredElement=i.target;}else if(this._bAutoClose){if(!this.touchEnabled&&!this._sTimeoutId){if(i.target===document.activeElement){return;}var w=typeof this._durations.close==="string"?0:this._durations.close;this._sTimeoutId=setTimeout(function(){this.close(w,"autocloseBlur");var x=this._oLastPosition&&this._oLastPosition.of;if(x){var y=this.getParentPopupId(x);if(y){var z="sap.ui.core.Popup.onFocusEvent-"+y;sap.ui.getCore().getEventBus().publish("sap.ui",z,i);}}}.bind(this),w);}}}};
P.prototype.setInitialFocusId=function(i){c(!i||typeof i==="string","sId must be a string or empty");this._sInitialFocusId=i;};
P.prototype.close=function(i){if(P._autoCloseDebug){return;}if(this._sTimeoutId){clearTimeout(this._sTimeoutId);this._sTimeoutId=null;if(arguments.length>1){var A=arguments[1];if(typeof A=="string"&&A=="autocloseBlur"&&this._isFocusInsidePopup()){return;}}}c(i===undefined||(typeof i==="number"&&(i%1==0)),"iDuration must be empty or an integer");if(this.eOpenState==n.CLOSED||this.eOpenState==n.CLOSING){return;}var e="fast";if((i===0)||(i>0)){e=i;}else if((this._durations.close===0)||(this._durations.close>0)){e=this._durations.close;}this.eOpenState=n.CLOSING;if(this.getFollowOf()){P.DockTrigger.removeListener(P.checkDocking,this);}if(this.oContent){if(this._bContentAddedToStatic){sap.ui.getCore().getEventBus().publish("sap.ui","__beforePopupClose",{domNode:this._$().get(0)});var S=sap.ui.getCore().getStaticAreaRef();S=sap.ui.getCore().getUIArea(S);S.removeContent(S.indexOfContent(this.oContent),true);}else if(this._bUIAreaPatched){delete this.oContent.getUIArea;}}this._bContentAddedToStatic=false;this._bUIAreaPatched=false;this._sTimeoutId=null;this._deactivateFocusHandle();this._$(false,true).off("keydown",this._F6NavigationHandler);if(this.oContent instanceof E){this.oContent.removeDelegate(this);}var $=this._$();if(this._bEventBusEventsRegistered){this._unregisterEventBusEvents();}if(this._oBlindLayer){this.oBlindLayerPool.returnObject(this._oBlindLayer);}this._oBlindLayer=null;if(h()){if(this._oBottomShieldLayer){clearTimeout(this._iBottomShieldRemoveTimer);this._iBottomShieldRemoveTimer=null;}else{this._oBottomShieldLayer=this.oShieldLayerPool.borrowObject($,this._iZIndex-3);}this._iBottomShieldRemoveTimer=setTimeout(function(){this.oShieldLayerPool.returnObject(this._oBottomShieldLayer);this._oBottomShieldLayer=null;this._iBottomShieldRemoveTimer=null;}.bind(this),500);}if(this.isInPopup(this._oLastPosition.of)){var j=this.getParentPopupId(this._oLastPosition.of);var l="";var v=this.getContent();if(v instanceof E){l=v.getId();}else if(typeof v==="object"){l=v.id;}this.removeChildFromPopup(j,l);this.removeChildFromPopup(j,this._popupUID);}if(this._bModal&&this.preventBrowserFocus){$.one("mousedown",function(w){w.preventDefault();});}this._duringClose();if(e==0){this._closed();}else if(this._animations.close){this._animations.close.call(null,$,e,this._closed.bind(this));}else{$.fadeOut(e,this._closed.bind(this));}};
P.prototype._closed=function(){var $=this._$(false,true);if(this._bModal){this._hideBlockLayer();}P._clearSelection();this._restoreUserSelection();if($.length){var e=$.get(0);if(e){e.style.display="none";e.style.visibility="hidden";e.style.left="0px";e.style.top="0px";e.style.right="";}$=this._$(false,true);e=$.length?$[0]:null;if(e){e.style.display="none";e.style.visibility="hidden";e.style.left="0px";e.style.top="0px";e.style.right="";}}if(this._bModal){P.applyFocusInfo(this._oPreviousFocus);this._oPreviousFocus=null;this.oLastBlurredElement=null;}this.bOpen=false;this.eOpenState=n.CLOSED;var i=this.getChildPopups();for(var j=0,l=i.length;j<l;j++){this.closePopup(i[j]);}this.fireClosed();};
P.prototype._duringClose=function(){if(this._resizeListenerId){a.deregister(this._resizeListenerId);this._resizeListenerId=null;}};
P.getCurrentFocusInfo=function(){var e=null;var i=sap.ui.getCore().getCurrentFocusedControlId();if(i){var j=sap.ui.getCore().byId(i);e={'sFocusId':i,'oFocusInfo':j?j.getFocusInfo():{}};}else{try{var l=document.activeElement;if(l&&l.nodeName){e={'sFocusId':l.id,'oFocusedElement':l,'oFocusInfo':{}};}}catch(v){e=null;}}if(e){e.popup=this;}return e;};
P.applyFocusInfo=function(e){var i={preventScroll:true};if(e){var j=sap.ui.getCore().byId(e.sFocusId);if(j){j.applyFocusInfo(Object.assign(i,e.oFocusInfo));}else{var l=((e.sFocusId?window.document.getElementById(e.sFocusId):null))||e.oFocusedElement;if(l){l.focus(i);}}}};
P.prototype.setContent=function(e){c(typeof e==="object","oContent must be an object");this.oContent=e;return this;};
P.prototype.getContent=function(){return this.oContent;};
P.prototype.setPosition=function(e,i,j,l,v){c(typeof e==="string","my must be a string");c(typeof i==="string"||(typeof i==="object"&&(typeof i.left==="number")&&(typeof i.top==="number")),"my must be a string or an object with 'left' and 'top' properties");c(!j||typeof j==="object"||typeof j==="function","of must be empty or an object");c(!l||typeof l==="string","offset must be empty or a string");c(!v||typeof v==="string","collision must be empty or a string");this._oPosition=this._createPosition(e,i,j,l,v);if(this.eOpenState!=n.CLOSED){this._applyPosition(this._oPosition);this._oBlindLayer&&this._oBlindLayer.update(this._$());}return this;};
P.prototype._createPosition=function(e,i,j,l,v){var N=false;if(e&&(e.indexOf("+")>=0||e.indexOf("-")>=0)){N=true;if(l&&l!="0 0"){L.warning("offset used in my and in offset, the offset value will be ignored","sap.ui.core.Popup","setPosition");}l=null;}var w=d({},this._oDefaultPosition,{"my":e||this._oDefaultPosition.my,"at":i||this._oDefaultPosition.at,"of":j,"offset":l,"collision":v});if(!q.ui.version){if(P._bNewOffset==null){P._bNewOffset=true;var $=q(document.createElement("div"));$.position({of:window,using:function(A,G){P._bNewOffset=(G!==undefined);}});}}var x=[];var y=[];if(P._bNewOffset||V(q.ui.version).compareTo("1.8.23")>0){if(l&&l!="0 0"){x=w.my.split(" ");y=l.split(" ");var S=[parseInt(y[0])<0?"":"+",parseInt(y[1])<0?"":"+"];w.my=x[0]+S[0]+y[0]+" "+x[1]+S[1]+y[1];w.offset=null;}}else if(N){x=w.my.split(" ");y=["",""];var z=x[0].indexOf("+");if(z<0){z=x[0].indexOf("-");}if(z>=0){y[0]=x[0].slice(z);x[0]=x[0].slice(0,z);}z=x[1].indexOf("+");if(z<0){z=x[1].indexOf("-");}if(z>=0){y[1]=x[1].slice(z);x[1]=x[1].slice(0,z);}w.my=x[0]+" "+x[1];w.offset=y[0]+" "+y[1];}return w;};
P.prototype._getPositionOffset=function(){var e=[];if(this._oPosition.my&&(this._oPosition.my.indexOf("+")>=0||this._oPosition.my.indexOf("-")>=0)){var i=this._oPosition.my.split(" ");var j=i[0].indexOf("+");if(j<0){j=i[0].indexOf("-");}if(j>=0){e[0]=i[0].slice(j);}j=i[1].indexOf("+");if(j<0){j=i[1].indexOf("-");}if(j>=0){e[1]=i[1].slice(j);}}else if(this._oPosition.offset){e=this._oPosition.offset.split(" ");}return e;};
P.prototype._applyPosition=function(e){var i=sap.ui.getCore().getConfiguration().getRTL();var $=this._$();if($.length){var A=e.at;var j=$.get(0);if(typeof(A)==="string"){j.style.display="block";j.style.left="";j.style.right="";$.position(this._resolveReference(this._convertPositionRTL(e,i)));this._fixPositioning(e,i);}else if(m.isValid(A.left)&&m.isValid(A.top)){$.css({"left":A.left,"top":A.top});}else if(m.isValid(A.right)&&m.isValid(A.top)){$.css({"right":A.right,"top":A.top});}else if(typeof(A.left)==="number"&&typeof(A.top)==="number"){var l=$[0];if(l&&l.style.right){var w=$[0].getBoundingClientRect().width;$.css({"right":(document.documentElement.clientWidth-(A.left+w))+"px","top":A.top+"px"});}else{$.css({"left":A.left+"px","top":A.top+"px"});}}this._oLastPosition=e;this._oLastOfRect=this._calcOfRect(e.of);}};
P.prototype._calcOfRect=function(e){var i=this._getOfDom(e);if(i){return q(i).rect();}return null;};
P.prototype._getOfDom=function(e){if(e instanceof q.Event){return null;}var $;if(typeof(e)==="string"){$=q(document.getElementById(e));}else if(e instanceof q){$=e;}else{$=q(e instanceof E?e.getDomRef():e);}return $[0];};
P.prototype._convertPositionRTL=function(e,i){var j=Object.assign({},e);if(i){var N=false;if(j.my&&(j.my.indexOf("+")>=0||j.my.indexOf("-")>=0)){N=true;}if((j.offset||N)&&((j.my.indexOf("begin")>-1)||(j.my.indexOf("end")>-1))&&((j.at.indexOf("begin")>-1)||(j.at.indexOf("end")>-1))){if(N){var l=j.my.split(" ");if(l.length==2){j.my="";if(l[0]){if(l[0].indexOf("begin")>-1||l[0].indexOf("end")>-1){if(l[0].indexOf("+")>-1){l[0]=l[0].replace("+","-");}else if(l[0].indexOf("-")>-1){l[0]=l[0].replace("-","+");}}j.my=l[0];}if(l[1]){if(l[1].indexOf("begin")>-1||l[1].indexOf("end")>-1){if(l[1].indexOf("+")>-1){l[1]=l[1].replace("+","-");}else if(l[1].indexOf("-")>-1){l[1]=l[1].replace("-","+");}}if(l[0]){j.my=j.my+" ";}j.my=j.my+l[1];}}}else{j.offset=this._mirrorOffset(j.offset);}}j.my=j.my.replace("begin","right").replace("end","left");j.at=j.at.replace("begin","right").replace("end","left");}else{j.my=j.my.replace("end","right").replace("begin","left");j.at=j.at.replace("end","right").replace("begin","left");}return j;};
P.prototype._mirrorOffset=function(e){var i=String(e).trim().split(/\s/);var j=parseInt(i[0]);return(-j)+" "+i[i.length-1];};
P.prototype._fixPositioning=function(e,i){var j=e.my;if(typeof(j)==="string"){if(P._isPositionFixingNeeded(j,i)){var $=this._$();var l=q(window).width()-$[0].getBoundingClientRect().width-$.offset().left;$.css({"right":l+"px","left":""});}}};
P._isPositionFixingNeeded=function(e,i){return i&&((e.indexOf("right")>-1)||(e.indexOf("begin")>-1)||(e.indexOf("center")>-1))||!i&&((e.indexOf("right")>-1)||(e.indexOf("end")>-1));};
P.prototype._resolveReference=function(e){var i=e;if(e.of instanceof E){i=Object.assign({},e,{of:e.of.getDomRef()});}return i;};
P.prototype.setShadow=function(S){c(typeof S==="boolean","bShowShadow must be boolean");this._bShadow=S;if(this.eOpenState!=n.CLOSED){this._$().toggleClass("sapUiShd",S);}return this;};
P.prototype.setModal=function(e,i){c(typeof e==="boolean","bModal must be boolean");c(!i||typeof i==="string","sModalCSSClass must be empty or a string");var j=this._bModal;this._bModal=e;this._sModalCSSClass=i;if(this.isOpen()){if(j!==e){P._clearSelection();if(e){this._setupUserSelection();this._showBlockLayer();}else{this._hideBlockLayer();this._restoreUserSelection();}if(this.touchEnabled&&this._bAutoClose){if(!e){q(document).on("touchstart mousedown",q.proxy(this._fAutoCloseHandler,this));}else{q(document).off("touchstart mousedown",this._fAutoCloseHandler);}}}}return this;};
P.prototype.getModal=function(){return this._bModal;};
P.prototype.setNavigationMode=function(e){if(e!="NONE"&&e!="DOCK"&&e!="SCOPE"){this._sF6NavMode="NONE";}this._sF6NavMode=e;};
P.prototype.setAutoClose=function(A){c(typeof A==="boolean","bAutoClose must be boolean");if(this.touchEnabled&&this.isOpen()&&this._bAutoClose!==A){if(!this._bModal){if(A){q(document).on("touchstart mousedown",q.proxy(this._fAutoCloseHandler,this));}else{q(document).off("touchstart mousedown",this._fAutoCloseHandler);}}}this._bAutoClose=A;return this;};
P.prototype.setExtraContent=function(e){c(Array.isArray(e),"Extra popup content must be an array which contains either sap.ui.core.Element, DOM Element or an ID");if(!this._aExtraContent){this._aExtraContent=[];}var j=function(z){return{onBeforeRendering:function(){var A=z.getDomRef();if(A&&this.isOpen()){if(D.browser.msie){q(A).off("deactivate."+this._popupUID,this.fEventHandler);}else{A.removeEventListener("blur",this.fEventHandler,true);}}},onAfterRendering:function(){var A=z.getDomRef();if(A&&this.isOpen()){if(D.browser.msie){q(A).on("deactivate."+this._popupUID,this.fEventHandler);}else{A.addEventListener("blur",this.fEventHandler,true);}}}};};var v,w,x,y;for(var i=0,l=e.length;i<l;i++){w=e[i];if(w instanceof E){v=w.getId();}else if(typeof w==="object"){v=w.id;}else if(typeof w==="string"){v=w;}if(this.getChildPopups().indexOf(v)===-1){this.addChildPopup(v);y={id:v};if(w instanceof E){x=j(w);w.addEventDelegate(x,this);y.delegate=x;}this._aExtraContent.push(y);}}return this;};
P.prototype.setAutoCloseAreas=P.prototype.setExtraContent;
P.prototype.setAnimations=function(e,i){c(e===null||typeof e==="function","fnOpen must be a function");c(i===null||typeof i==="function","fnClose must be a function");if(e&&(typeof(e)=="function")){this._animations.open=e;}if(i&&(typeof(i)=="function")){this._animations.close=i;}return this;};
P.prototype.setDurations=function(i,e){c(i===null||(typeof i==="number"&&(i%1==0)),"iOpenDuration must be null or an integer");c(!e||(typeof e==="number"&&(e%1==0)),"iOpenDuration must be undefined or an integer");if((i>0)||(i===0)){this._durations.open=i;}if((e>0)||(e===0)){this._durations.close=e;}return this;};
P.CLOSE_ON_SCROLL="close_Popup_if_of_is_moved";
P.prototype._fnCloseOnScroll=function(e){this.close();};
P.prototype.setFollowOf=function(e){P.DockTrigger.removeListener(P.checkDocking,this);var U=false;this._bFollowOf=true;this._followOfHandler=null;if(typeof(e)==="function"){this._followOfHandler=e;U=true;}else if(typeof(e)==="boolean"){U=e;}else if(e===P.CLOSE_ON_SCROLL){this._followOfHandler=this._fnCloseOnScroll;U=true;}else{this._bFollowOf=false;if(e!==null){L.error("Trying to set an invalid type to 'followOf: "+e);}}if(U&&this._oLastPosition){this._oLastOfRect=this._calcOfRect(this._oLastPosition.of);}if(this._bFollowOf&&this.getOpenState()===n.OPEN){P.DockTrigger.addListener(P.checkDocking,this);}};
P.prototype.getAutoClose=function(){return this._bAutoClose;};
P.prototype.getFollowOf=function(){if(this._bFollowOf){return typeof(this._followOfHandler)==="function"?this._followOfHandler:true;}return false;};
P.prototype.isOpen=function(){return this.bOpen;};
P.prototype.getOpenState=function(){return this.eOpenState;};
P.prototype.destroy=function(){if(this._resizeListenerId){a.deregister(this._resizeListenerId);this._resizeListenerId=null;}this.close(0);this.oContent=null;if(this._bFollowOf){this.setFollowOf(null);}if(this._bEventBusEventsRegistered){this._unregisterEventBusEvents();}if(this._iTopShieldRemoveTimer){clearTimeout(this._iTopShieldRemoveTimer);this.oShieldLayerPool.returnObject(this._oTopShieldLayer);this._oTopShieldLayer=null;this._iTopShieldRemoveTimer=null;}if(this._iBottomShieldRemoveTimer){clearTimeout(this._iBottomShieldRemoveTimer);this.oShieldLayerPool.returnObject(this._oBottomShieldLayer);this._oBottomShieldLayer=null;this._iBottomShieldRemoveTimer=null;}if(this._aExtraContent){var e;this._aExtraContent.forEach(function(A){if(A.delegate){e=q(document.getElementById(A.id)).control(0);if(e){e.removeEventDelegate(A.delegate);}}});}M.prototype.destroy.apply(this,arguments);};
P.prototype.exit=function(){delete this._mEvents;};
P.prototype._addFocusEventListeners=function(e,j,v){if(!this.fEventHandler){this.fEventHandler=q.proxy(this.onFocusEvent,this);}var $=this._$();var w=this.getChildPopups();var x={};var i=0,l=0;if($.length){if(document.addEventListener&&!D.browser.msie){document.addEventListener("focus",this.fEventHandler,true);$.get(0).addEventListener("blur",this.fEventHandler,true);for(i=0,l=w.length;i<l;i++){x=(w[i]?window.document.getElementById(w[i]):null);if(x){x.addEventListener("blur",this.fEventHandler,true);}}}else{q(document).on("activate."+this._popupUID,this.fEventHandler);$.on("deactivate."+this._popupUID,this.fEventHandler);for(i=0,l=w.length;i<l;i++){x=(w[i]?window.document.getElementById(w[i]):null);if(x){q(x).on("deactivate."+this._popupUID,this.fEventHandler);}}}}};
P.prototype._removeFocusEventListeners=function(e,j,v){var $=this._$(false,true);if(!$.length){return;}var w=this.getChildPopups();var x={};var i=0,l=0;if(document.removeEventListener&&!D.browser.msie){document.removeEventListener("focus",this.fEventHandler,true);$.get(0).removeEventListener("blur",this.fEventHandler,true);for(i=0,l=w.length;i<l;i++){x=(w[i]?window.document.getElementById(w[i]):null);if(x){x.removeEventListener("blur",this.fEventHandler,true);}this.closePopup(w[i]);}}else{q(document).off("activate."+this._popupUID,this.fEventHandler);$.off("deactivate."+this._popupUID,this.fEventHandler);for(i=0,l=w.length;i<l;i++){x=(w[i]?window.document.getElementById(w[i]):null);if(x){q(x).off("deactivate."+this._popupUID,this.fEventHandler);}}}this.fEventHandler=null;};
P.prototype._activateFocusHandle=function(){if(this._bModal||this._bAutoClose){this._addFocusEventListeners();}if(this.touchEnabled&&!this._bModal&&this._bAutoClose){q(document).on("touchstart mousedown",q.proxy(this._fAutoCloseHandler,this));}};
P.prototype._deactivateFocusHandle=function(){if(this.fEventHandler){this._removeFocusEventListeners();}if(this.touchEnabled&&!this._bModal&&this._bAutoClose){q(document).off("touchstart mousedown",this._fAutoCloseHandler);}};
P.prototype._registerEventBusEvents=function(e,i,j){var l=this;q.each(l._mEvents,function(v,w){sap.ui.getCore().getEventBus().subscribe("sap.ui",v,w,l);});this._bEventBusEventsRegistered=true;};
P.prototype._unregisterEventBusEvents=function(e,i,j){var l=this;q.each(l._mEvents,function(v,w){sap.ui.getCore().getEventBus().unsubscribe("sap.ui",v,w,l);});delete this._bEventBusEventsRegistered;};
P.prototype._addFocusableArea=function(e,i,j){if(this.getChildPopups().indexOf(j.id)===-1){this.addChildPopup(j.id);}};
P.prototype._removeFocusableArea=function(e,i,j){this.removeChildPopup(j.id);};
P.prototype._closePopup=function(e,i,j){this.close(typeof this._durations.close==="string"?0:this._durations.close);};
P.prototype._setIdentity=function($){if(typeof $==="object"){$.attr("data-sap-ui-popup",this._popupUID);}else{L.warning("Incorrect DomRef-type for 'setIdentity': "+$,this);return;}if(!this._bEventBusEventsRegistered){this._registerEventBusEvents();}};
P.prototype._$=function(e,G){var $;if(this.oContent instanceof C){$=this.oContent.$();if(e||($.length===0&&!G)){L.info("Rendering of popup content: "+this.oContent.getId());if($.length>0){R.preserveContent($[0],true,false);}sap.ui.getCore().getRenderManager().render(this.oContent,sap.ui.getCore().getStaticAreaRef());$=this.oContent.$();}}else if(this.oContent instanceof E){$=this.oContent.$();}else{$=q(this.oContent);}this._setIdentity($);return $;};
function _(e){if(P._blockLayerStateProvider){P._blockLayerStateProvider.fireEvent("blockLayerStateChange",e);}}
P.attachBlockLayerStateChange=function(e,i,l){if(!P._blockLayerStateProvider){P._blockLayerStateProvider=new k();}P._blockLayerStateProvider.attachEvent("blockLayerStateChange",e,i,l);};
P.detachBlockLayerStateChange=function(e,l){if(P._blockLayerStateProvider){P._blockLayerStateProvider.detachEvent("blockLayerStateChange",e,l);}};
P.prototype._showBlockLayer=function(){var $=q("#sap-ui-blocklayer-popup"),e="sapUiBLy"+(this._sModalCSSClass?" "+this._sModalCSSClass:"");if($.length===0){$=q('<div id="sap-ui-blocklayer-popup" tabindex="0" class="'+e+'"></div>');$.appendTo(sap.ui.getCore().getStaticAreaRef());}else{$.removeClass().addClass(e);}P.blStack.push({zIndex:this._iZIndex-2,popup:this});$.css({"z-index":this._iZIndex-2,"visibility":"visible"}).show();q("html").addClass("sapUiBLyBack");if(P.blStack.length===1){_({visible:true,zIndex:P.blStack[0].zIndex});}};
P.prototype._hideBlockLayer=function(){var $=q("#sap-ui-blocklayer-popup"),e=this,l;if($.length){var i=$.get(0);if(P.blStack.length>1){P.blStack=P.blStack.filter(function(j){return j.popup!==e;});i.style.zIndex=P.blStack[P.blStack.length-1].zIndex;i.style.visibility="visible";i.style.display="block";}else{l=P.blStack.pop();i.style.visibility="hidden";i.style.display="none";window.setTimeout(function(){q("html").removeClass("sapUiBLyBack");},0);_({visible:false,zIndex:l.zIndex});}}};
P.prototype._isFocusInsidePopup=function(){var e=this._$(false).get(0);if(e&&g(e,document.activeElement)){return true;}return false;};
P.DockTrigger=I;
P.checkDocking=function(){if(this.getOpenState()===n.OPEN){var e=this._getOfDom(this._oLastPosition.of),i;if(e){if((e===window)||(e===window.document)||g(document.documentElement,e)){i=q(e).rect();}else if(e.id){var N=window.document.getElementById(e.id);var j=q(N).rect();if(j&&!r(i,j)){i=j;this._oLastPosition.of=N;}}}if(!i){this.close();return;}else if(i.left===0&&i.top===0&&i.height===0&&i.height===0&&this._oLastPosition.of.id){this._oLastPosition.of=window.document.getElementById(this._oLastPosition.of.id);e=this._getOfDom(this._oLastPosition.of);i=q(e).rect();if(!i){this.close();return;}}if(this._oLastOfRect){if(!r(this._oLastOfRect,i)){if(this._followOfHandler){var l=f({},this._oLastPosition),v=f({},this._oLastOfRect);this._followOfHandler({lastPosition:l,lastOfRect:v,currentOfRect:i});}else{this._applyPosition(this._oLastPosition);}}}}};
P.prototype.ontouchstart=function(e){this.onmousedown(e,true);this._bMousedownCalled=true;};
P.prototype.onmousedown=function(e,S){if(this._bMousedownCalled&&!S){this._bMousedownCalled=false;return;}if(this._iZIndex===this.getLastZIndex()||this.getModal()){return;}this._increaseMyZIndex("","mousedown",e);};
P.prototype._increaseMyZIndex=function(e,j,v){var w=this.getParentPopup(this._oLastPosition.of);if(v&&v.type==="mousedown"||v&&v.isFromParentPopup||w.length===0){this._iZIndex=this.getNextZIndex();var $=this._$(false,true);$.css("z-index",this._iZIndex);if(this._oBlindLayer){this._oBlindLayer.update($,this._iZIndex-1);}if(v&&!v.type||v&&v.type!="mousedown"||j==="mousedown"){var x=this.getChildPopups();for(var i=0,l=x.length;i<l;i++){this.increaseZIndex(x[i],true);}}}else if(w.length>0){var y=q(w.get(0)).attr("data-sap-ui-popup");this.increaseZIndex(y,false);}};
P.prototype.onAfterRendering=function(e){var i=this.getContent();var $=i instanceof E?i.$():q(i);$.toggleClass("sapUiShd",this._bShadow);P._clearSelection();this._setupUserSelection();$.css("position","absolute");this._setIdentity($);var j=$[0];var l=j.style.left;var v=j.style.right;var w=j.style.top;var x=j.style.bottom;if(!(l&&l!="auto"||v&&v!="auto"||w&&w!="auto"||x&&x!="auto")){L.debug("reposition popup content "+$.attr("id")+" at "+JSON.stringify(this._oLastPosition.at));this._applyPosition(this._oLastPosition);}$.show().css({"visibility":"visible","z-index":this._iZIndex});if(this._oBlindLayer){this._resizeListenerId=a.register(this._$().get(0),q.proxy(this.onresize,this));}if(this.isOpen()&&(this.getModal()||this.getAutoClose())){this._addFocusEventListeners();}this._$(false,true).on("keydown",q.proxy(this._F6NavigationHandler,this));};
P.prototype.onBeforeRendering=function(e){if(this._resizeListenerId){a.deregister(this._resizeListenerId);this._resizeListenerId=null;}if(this.isOpen()&&(this.getModal()||this.getAutoClose())){this._removeFocusEventListeners();}this._$(false,true).off("keydown",this._F6NavigationHandler);};
P.prototype.onresize=function(e){if(this.eOpenState!=n.CLOSED&&this._oBlindLayer){var i=this;setTimeout(function(){i._updateBlindLayer();},0);}};
P.prototype._updateBlindLayer=function(){if(this.eOpenState!=n.CLOSED&&this._oBlindLayer){this._oBlindLayer.update(this._$(false,true));}};
P.prototype.isInPopup=function(T){var $=this.getParentPopup(T);return $&&$.length>0;};
P.prototype.getParentPopup=function(T){var e=T?T:this;var $=q(e instanceof E?e.getDomRef():e);return $.closest("[data-sap-ui-popup]");};
P.prototype.getParentPopupId=function(T){var $=this.getParentPopup(T);return $.attr("data-sap-ui-popup");};
P.prototype.addChildToPopup=function(e,i){var j="sap.ui.core.Popup.addFocusableContent-"+e;sap.ui.getCore().getEventBus().publish("sap.ui",j,{id:i});};
P.prototype.removeChildFromPopup=function(e,i){var j="sap.ui.core.Popup.removeFocusableContent-"+e;sap.ui.getCore().getEventBus().publish("sap.ui",j,{id:i});};
P.prototype.closePopup=function(e){var i="sap.ui.core.Popup.closePopup-"+e;sap.ui.getCore().getEventBus().publish("sap.ui",i);};
P.prototype.increaseZIndex=function(e,i){var j="sap.ui.core.Popup.increaseZIndex-"+e;sap.ui.getCore().getEventBus().publish("sap.ui",j,{isFromParentPopup:i?i:false});};
P.prototype.focusTabChain=function(e){var S=e.event.target,N=e.that.getMetadata().getName(),i;if((!e.$FocusablesContent||!e.$FocusablesFooter)||(!e.$FocusablesContent.length&&!e.$FocusablesFooter.length)){return;}if(S.id===e.firstFocusable){L.debug("First dummy focus element was focused","",N);if(e.$FocusablesFooter.length>0){L.debug("Last footer element will be focused","",N);i=e.$FocusablesFooter[e.$FocusablesFooter.length-1];}else{L.debug("Last content element will be focused","",N);i=e.$FocusablesContent[e.$FocusablesContent.length-1];}}else if(S.id===e.lastFocusable){L.debug("Last dummy focus element was focues","",N);if(e.$FocusablesContent.length>0){L.debug("First content element will be focused","",N);i=e.$FocusablesContent[0];}else{L.debug("First footer element will be focused","",N);i=e.$FocusablesFooter[0];}}if(i){setTimeout(function(){var j=sap.ui.getCore().byId(i.id);if(j instanceof C){L.debug("Focus will be handled by "+j.getMetadata().getName(),"",N);}else{L.debug("oFocusDomRef will be focused","",N);}if(j){j.focus();}else if(i){i.focus();}return j?j.getId():i.id;},0);}};
P.prototype._setupUserSelection=function(){var $=this._$(false,true);P._markAsUserSelectable($,this._bModal||P.blStack.length>0);if(this._bModal){if(P.blStack.length>0){var l=P.blStack[P.blStack.length-1];var G=function(e){return e.popup.getId();};if(P.blStack.map(G).indexOf(this.getId())===-1){P._markAsNotUserSelectable(l.popup._$(false,true),true);}else if(l.popup.getId()!==this.getId()){P._markAsNotUserSelectable($,true);}}else{P._markAsNotUserSelectable(q("html"),true);P._markExternalContentAsUserSelectable(true);}}};
P.prototype._restoreUserSelection=function(){var $=this._$(false,true);P._markAsNotUserSelectable($,false);if(P.blStack.length>0){P._markAsUserSelectable(P.blStack[P.blStack.length-1].popup._$(false,true),true);}else{P._markAsUserSelectable(q("html"),false);P._markExternalContentAsNotUserSelectable(false);}};
P._clearSelection=function(){var S=document.getSelection();if(!S.isCollapsed){S.removeAllRanges();}};
P._markAsUserSelectable=function($,e){if(!(D.browser.msie||D.browser.edge)){$.removeClass("sapUiNotUserSelectable");if(e){$.addClass("sapUiUserSelectable");}}};
P._markAsNotUserSelectable=function($,e){if(!(D.browser.msie||D.browser.edge)){$.removeClass("sapUiUserSelectable");if(e){$.addClass("sapUiNotUserSelectable");}}};
var p=new Set(),t="[data-sap-ui-integration-popup-content]";p.add(t);
P.addExternalContent=function(S,e){if(!Array.isArray(S)){S=[S];}S.forEach(Set.prototype.add.bind(p));if(e){P.markExternalContentAsSelectable();}};
P.removeExternalContent=function(S,e){if(!Array.isArray(S)){S=[S];}if(e){P.markExternalContentAsNotSelectable();}S.forEach(function(i){if(i!==t){p.delete(i);}});};
P.markExternalContentAsSelectable=function(){P._clearSelection();if(P.blStack.length>0){P._markExternalContentAsUserSelectable(true);}};
P.markExternalContentAsNotSelectable=function(){P._clearSelection();if(P.blStack.length>0){P._markExternalContentAsNotUserSelectable(false);}};
P._getExternalContent=function(){var e=[];if(p.size>0){p.forEach(function(S){var $=q(S);if($.length>0){e.push($);}});}return e;};
P._markExternalContentAsUserSelectable=function(e){var i=P._getExternalContent();i.forEach(function($){P._markAsUserSelectable($,e);});};
P._markExternalContentAsNotUserSelectable=function(e){var i=P._getExternalContent();i.forEach(function($){P._markAsNotUserSelectable($,e);});};
return P;});
sap.ui.predefine('sap/ui/core/ScrollBar',['sap/ui/Device','./Control','./library',"./ScrollBarRenderer","sap/ui/performance/trace/Interaction","sap/base/Log","sap/ui/dom/containsOrEquals","sap/ui/events/jquery/EventSimulation","sap/ui/thirdparty/jquery"],function(D,C,l,S,I,L,c,E,q){"use strict";var a=l.ScrollBarAction;
var b=C.extend("sap.ui.core.ScrollBar",{metadata:{library:"sap.ui.core",properties:{vertical:{type:"boolean",group:"Behavior",defaultValue:true},scrollPosition:{type:"int",group:"Behavior",defaultValue:null},size:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},contentSize:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},steps:{type:"int",group:"Dimension",defaultValue:null}},events:{scroll:{parameters:{action:{type:"sap.ui.core.ScrollBarAction"},forward:{type:"boolean"},newScrollPos:{type:"int"},oldScrollPos:{type:"int"}}}}}});
b.prototype.init=function(){this._$ScrollDomRef=null;this._iOldScrollPos=0;this._iOldStep=0;this._bScrollPosIsChecked=false;this._bRTL=sap.ui.getCore().getConfiguration().getRTL();this._bSuppressScroll=false;this._iMaxContentDivSize=1000000;if(E.touchEventMode==="ON"){sap.ui.requireSync("sap/ui/thirdparty/zyngascroll");this._iLastTouchScrollerPosition=null;this._iTouchStepTreshold=24;this._bSkipTouchHandling=false;this._oTouchScroller=new window.Scroller(q.proxy(this._handleTouchScroll,this),{bouncing:false});}};
b.prototype.onBeforeRendering=function(){this.$("sb").off("scroll",this.onscroll);};
b.prototype.onAfterRendering=function(){this._iSteps=this.getSteps();var s=this.getContentSize();this._bStepMode=!s;var i=this.getSize();if(i.endsWith("px")){i=i.substr(0,i.length-2);}else{i=this.getVertical()?this.$().height():this.$().width();}var d=null;var $=this.$("ffsize");if(D.browser.firefox){d=$.outerHeight();if(d===0){d=window.getComputedStyle(q("body").get(0))["font-size"];if(d.endsWith("px")){d=d.substr(0,d.length-2);}d=parseInt(d);}}$.remove();if(D.browser.webkit){if(!document.width){d=Math.round(40/(window.outerWidth/q(document).width()));}else{d=Math.round(40/(document.width/q(document).width()));}}if(this.getVertical()){if(D.browser.firefox){this._iFactor=d;}else if(D.browser.webkit){this._iFactor=d;}else{this._iFactor=Math.floor(i*0.125);}this._iFactorPage=D.browser.firefox?i-d:Math.floor(i*0.875);}else{if(D.browser.firefox){this._iFactor=10;this._iFactorPage=Math.floor(i*0.8);}else if(D.browser.webkit){this._iFactor=d;this._iFactorPage=Math.floor(i*0.875);}else{this._iFactor=7;this._iFactorPage=i-14;}}this._$ScrollDomRef=this.$("sb");if(this._bStepMode){if(this.getVertical()){var e=this._iSteps*this._iFactor;if(e>this._iMaxContentDivSize){this._iFactor=this._iFactor/(e/this._iMaxContentDivSize);}var f=this._$ScrollDomRef.height()+Math.ceil(this._iSteps*this._iFactor);this._$ScrollDomRef.find("div").height(f);}else{var f=this._$ScrollDomRef.width()+this._iSteps*this._iFactor;this._$ScrollDomRef.find("div").width(f);}}this.setCheckedScrollPosition(this.getScrollPosition()?this.getScrollPosition():0,true);this._$ScrollDomRef.on("scroll",q.proxy(this.onscroll,this));if(E.touchEventMode==="ON"){this._bSkipTouchHandling=true;var o={width:0,height:0};o[this.getVertical()?"height":"width"]=this._bStepMode?(this.getSteps()*this._iTouchStepTreshold):parseInt(this.getContentSize());this._oTouchScroller.setDimensions(0,0,o.width,o.height);var g=this._$ScrollDomRef.get(0);if(g){var r=g.getBoundingClientRect();this._oTouchScroller.setPosition(r.left+g.clientLeft,r.top+g.clientTop);this._bSkipTouchHandling=false;}}};
b.prototype.onmousewheel=function(e){if(this.$().is(":visible")){var o=e.originalEvent;var w=o.detail?o.detail:o.wheelDelta*(-1)/40;var f=w>0?true:false;if(c(this._$ScrollDomRef[0],e.target)){this._doScroll(a.MouseWheel,f);}else{this._bMouseWheel=true;var p=null;if(this._bStepMode){p=w+this._iOldStep;}else{p=w*this._iFactor+this._iOldScrollPos;}this.setCheckedScrollPosition(p,true);}e.preventDefault();e.stopPropagation();return false;}};
b.prototype.ontouchstart=function(e){var t=e.touches;var f=t[0];if(f&&f.target&&f.target.tagName.match(/input|textarea|select/i)){return;}if(this._oTouchScroller){this._oTouchScroller.doTouchStart(t,e.timeStamp);}if(t.length==1){e.preventDefault();}};
b.prototype.ontouchmove=function(e){if(this._oTouchScroller){this._oTouchScroller.doTouchMove(e.touches,e.timeStamp,e.scale);}};
b.prototype.ontouchend=function(e){if(this._oTouchScroller){this._oTouchScroller.doTouchEnd(e.timeStamp);}};
b.prototype.ontouchcancel=function(e){if(this._oTouchScroller){this._oTouchScroller.doTouchEnd(e.timeStamp);}};
b.prototype.onscroll=function(e){if(this._bSuppressScroll){this._bSuppressScroll=false;e.preventDefault();e.stopPropagation();return false;}var s=null;if(this._$ScrollDomRef){if(this.getVertical()){s=Math.round(this._$ScrollDomRef.scrollTop());}else{s=Math.round(this._$ScrollDomRef.scrollLeft());if(D.browser.firefox&&this._bRTL){s=Math.abs(s);}else if(D.browser.webkit&&this._bRTL){var o=this._$ScrollDomRef.get(0);s=o.scrollWidth-o.clientWidth-o.scrollLeft;}}}var d=s-this._iOldScrollPos;var f=d>0?true:false;if(d<0){d=d*(-1);}var g=a.Drag;if(d==this._iFactor){g=a.Step;}else if(d==this._iFactorPage){g=a.Page;}else if(this._bMouseWheel){g=a.MouseWheel;}if(this._bLargeDataScrolling&&g===a.Drag){this._eAction=g;this._bForward=f;if(D.browser.msie){if(this._scrollTimeout){window.clearTimeout(this._scrollTimeout);}this._scrollTimeout=window.setTimeout(this._onScrollTimeout.bind(this),300);}}else{this._doScroll(g,f);}e.preventDefault();e.stopPropagation();return false;};
b.prototype._onScrollTimeout=function(){this._scrollTimeout=undefined;this._doScroll(this._eAction,this._bForward);this._eAction=undefined;this._bForward=undefined;this._bTouchScroll=undefined;};
b.prototype.onmouseup=function(){if(this._bLargeDataScrolling&&(this._eAction||this._bForward||this._bTouchScroll)&&!D.browser.msie){this._doScroll(this._eAction,this._bForward);this._eAction=undefined;this._bForward=undefined;this._bTouchScroll=undefined;}};
b.prototype.ontouchend=b.prototype.onmouseup;
b.prototype._handleTouchScroll=function(i,t,z){if(this._bSkipTouchHandling){return;}var v=this.getVertical()?t:i;var p;if(this._bStepMode){p=Math.max(Math.round(v/this._iTouchStepTreshold),0);}else{p=Math.round(v);}if(this._iLastTouchScrollerPosition!==p){this._iLastTouchScrollerPosition=p;this.setCheckedScrollPosition(p,true);if(this._bLargeDataScrolling){this._bTouchScroll=true;}else{this.fireScroll();}}};
b.prototype.unbind=function(o){if(o){this._$OwnerDomRef=q(o);if(this.getVertical()){this._$OwnerDomRef.off(D.browser.firefox?"DOMMouseScroll":"mousewheel",this.onmousewheel);}if(E.touchEventMode==="ON"){this._$OwnerDomRef.off(this._getTouchEventType("touchstart"),q.proxy(this.ontouchstart,this));this._$OwnerDomRef.off(this._getTouchEventType("touchmove"),q.proxy(this.ontouchmove,this));this._$OwnerDomRef.off(this._getTouchEventType("touchend"),q.proxy(this.ontouchend,this));this._$OwnerDomRef.off(this._getTouchEventType("touchcancel"),q.proxy(this.ontouchcancel,this));}}};
b.prototype.bind=function(o){if(o){this._$OwnerDomRef=q(o);if(this.getVertical()){this._$OwnerDomRef.on(D.browser.firefox?"DOMMouseScroll":"mousewheel",q.proxy(this.onmousewheel,this));}if(E.touchEventMode==="ON"){this._$OwnerDomRef.on(this._getTouchEventType("touchstart"),q.proxy(this.ontouchstart,this));this._$OwnerDomRef.on(this._getTouchEventType("touchmove"),q.proxy(this.ontouchmove,this));this._$OwnerDomRef.on(this._getTouchEventType("touchend"),q.proxy(this.ontouchend,this));this._$OwnerDomRef.on(this._getTouchEventType("touchcancel"),q.proxy(this.ontouchcancel,this));}}};
b.prototype._getTouchEventType=function(t){return E.touchEventMode==="SIM"?("sap"+t):t;};
b.prototype.pageUp=function(){this._doScroll(a.Page,false);};
b.prototype.pageDown=function(){this._doScroll(a.Page,true);};
b.prototype.setScrollPosition=function(s){if(this._$ScrollDomRef){this.setCheckedScrollPosition(s,true);}else{this.setProperty("scrollPosition",s);}return this;};
b.prototype.setCheckedScrollPosition=function(s,d){var i=Math.max(s,0);if(this._bStepMode===undefined){this._bStepMode=!this.getContentSize();}var e=i;if(this._bStepMode){i=Math.min(i,this.getSteps());e=i*this._iFactor;}i=Math.round(i);this._bSuppressScroll=!d;this.setProperty("scrollPosition",i,true);if(this.getVertical()){this._$ScrollDomRef.scrollTop(e);}else{if(D.browser.firefox&&this._bRTL){this._$ScrollDomRef.scrollLeft(-e);}else if(D.browser.webkit&&this._bRTL){var o=this._$ScrollDomRef.get(0);this._$ScrollDomRef.scrollLeft(o.scrollWidth-o.clientWidth-e);}else{this._$ScrollDomRef.scrollLeft(e);}}if(E.touchEventMode==="ON"){var v=i;if(this._bStepMode){v=Math.round(i*this._iTouchStepTreshold);}this._oTouchScroller.__scrollTop=this.getVertical()?v:0;this._oTouchScroller.__scrollLeft=this.getVertical()?0:v;}};
b.prototype.setContentSize=function(s){this.setProperty("contentSize",s,true);this._bStepMode=false;var $=this.$("sbcnt");if($){if(this.getVertical()){$.height(s);}else{$.width(s);}}return this;};
b.prototype._doScroll=function(A,f){var s=null;if(this._$ScrollDomRef){if(this.getVertical()){s=Math.round(this._$ScrollDomRef.scrollTop());}else{s=Math.round(this._$ScrollDomRef.scrollLeft());if(D.browser.firefox&&this._bRTL){s=Math.abs(s);}else if(D.browser.webkit&&this._bRTL){var o=this._$ScrollDomRef.get(0);s=o.scrollWidth-o.clientWidth-o.scrollLeft;}}}if(this._bStepMode){var i=Math.round(s/this._iFactor);var O=this._iOldStep;if(O!==i){this.setCheckedScrollPosition(i,false);L.debug("-----STEPMODE-----: New Step: "+i+" --- Old Step: "+O+" --- Scroll Pos in px: "+s+" --- Action: "+A+" --- Direction is forward: "+f);this.fireScroll({action:A,forward:f,newScrollPos:i,oldScrollPos:O});this._iOldStep=i;}}else{s=Math.round(s);this.setProperty("scrollPosition",s,true);L.debug("-----PIXELMODE-----: New ScrollPos: "+s+" --- Old ScrollPos: "+this._iOldScrollPos+" --- Action: "+A+" --- Direction is forward: "+f);this.fireScroll({action:A,forward:f,newScrollPos:s,oldScrollPos:this._iOldScrollPos});}if(Math.round(this._iFactor)==this._iFactor||!D.browser.msie){this._bSuppressScroll=false;}this._iOldScrollPos=s;this._bMouseWheel=false;I.notifyScrollEvent({type:A});};
b.prototype.onThemeChanged=function(){this.rerender();};
b.prototype.getNativeScrollPosition=function(){if(this._$ScrollDomRef){if(this.getVertical()){return Math.round(this._$ScrollDomRef.scrollTop());}else{return Math.round(this._$ScrollDomRef.scrollLeft());}}return 0;};
b.prototype.setNativeScrollPosition=function(n){var s=Math.round(n);if(this._$ScrollDomRef){if(this.getVertical()){this._$ScrollDomRef.scrollTop(s);}else{this._$ScrollDomRef.scrollLeft(s);}}};
return b;});
sap.ui.predefine('sap/ui/core/ScrollBarRenderer',['sap/ui/Device',"sap/ui/dom/getScrollbarSize"],function(D,g){"use strict";var S={apiVersion:2};
S.render=function(r,s){var R=sap.ui.getCore().getConfiguration().getRTL();r.openStart("div",s);r.class("sapUiScrollBar");var a;if(D.support.touch){a="sapUiScrollBarTouch";r.class(a);}var v=s.getVertical();var b=s.getSize();var c=s.getContentSize();var B=g(a);var w=B.width;var h=B.height;if(D.browser.edge){if(!w){w="15";}if(!h){h="15";}}if(v){r.style("overflow","hidden");r.style("width",w+"px");r.style("height",b);r.openEnd();r.openStart("div",s.getId()+"-sb");r.style("width",(w*2)+"px");r.style("height","100%");r.style("overflow-y","scroll");r.style("overflow-x","hidden");if(R){r.style("margin-right","-"+w+"px");}else{r.style("margin-left","-"+w+"px");}r.openEnd();r.openStart("div",s.getId()+"-sbcnt");r.style("width",w+"px");r.style("height",c);r.openEnd();r.close("div");r.close("div");r.openStart("div");r.openEnd();r.openStart("span",s.getId()+"-ffsize");r.style("position","absolute");r.style("top","-9000px");r.style("left","-9000px");r.style("visibility","hidden");r.style("line-height","normal");r.openEnd();r.text("FF Size");r.close("span");r.close("div");}else{r.style("overflow","hidden");r.style("height",h+"px");r.style("width",b);r.openEnd();r.openStart("div",s.getId()+"-sb");r.style("height",(h*2)+"px");r.style("margin-top","-"+h+"px");r.style("overflow-x","scroll");r.style("overflow-y","hidden");r.openEnd();r.openStart("div",s.getId()+"-sbcnt");r.style("height",h+"px");r.style("width",c);r.openEnd();r.close("div");r.close("div");}r.close("div");};
return S;},true);
sap.ui.predefine('sap/ui/core/SeparatorItem',['./Item','./library'],function(I,l){"use strict";
var S=I.extend("sap.ui.core.SeparatorItem",{metadata:{library:"sap.ui.core"}});
return S;});
sap.ui.predefine('sap/ui/core/Shortcut',["sap/ui/core/util/ShortcutHelper",'sap/base/assert','sap/ui/dom/jquery/control'],function(S,a,q){"use strict";var b={register:function(s,v,c){if(!s){throw new Error("Shortcut.register: oScopeControl must be given.");}if(typeof c!=="function"){throw new Error("Shortcut.register: a function fnCallback must be given.");}var n=S.getNormalizedShortcutSpec(v);S.validateKeyCombination(n);var e=S.findShortcut(s,n);if(e){throw new Error("Same shortcut is already registered on this element");}function w(){var f=document.activeElement,o=document.createElement("span"),g=sap.ui.getCore().getStaticAreaRef();o.setAttribute("tabindex",0);o.setAttribute("id","sap-ui-shortcut-focus");o.style.position="absolute";o.style.top="50%";o.style.bottom="50%";o.style.left="50%";o.style.right="50%";g.appendChild(o);o.focus();f.focus();g.removeChild(o);c.apply(null,arguments);}var d={};d["onkeydown"]=S.handleKeydown.bind(null,n,v,w);s.addEventDelegate(d);var D=s.data("sap.ui.core.Shortcut");if(!D){D=[];s.data("sap.ui.core.Shortcut",D);}D.push({shortcutSpec:n,platformIndependentShortcutString:S.getNormalizedShortcutString(n),delegate:d});},isRegistered:function(s,v){a(s,"Shortcut.isRegistered: oScopeControl must be given.");var n=S.getNormalizedShortcutSpec(v);return!!S.findShortcut(s,n);},unregister:function(s,v){a(s,"Shortcut.unregister: oScopeControl must be given.");var n=S.getNormalizedShortcutSpec(v);var o=S.findShortcut(s,n);if(o){s.removeEventDelegate(o.delegate);var d=s.data("sap.ui.core.Shortcut");var i=d.indexOf(o);d.splice(i,1);return true;}return false;}};return b;});
sap.ui.predefine('sap/ui/core/ShortcutHint',["sap/base/Log","sap/ui/core/Core","sap/ui/core/CommandExecution"],function(L,C,a){"use strict";var S=function(c,o){this.oControl=c;this.oConfig=o;};
S.prototype._getShortcutText=function(){var t;if(this.oConfig.commandName){t=this._getShortcutHintFromCommandExecution(this.oControl,this.oConfig.commandName);}else if(this.oConfig.message){t=this.oConfig.message;}else if(this.oConfig.messageBundleKey){t=this._getShortcutHintFromMessageBundle(this.oControl,this.oConfig.messageBundleKey);}return t;};
S.prototype._getShortcutHintFromCommandExecution=function(c,s){try{return a.find(c,s)._getCommandInfo().shortcut;}catch(e){L.error("Error on retrieving command shortcut. Command "+s+" was not found!");return;}};
S.prototype._getShortcutHintFromMessageBundle=function(c,m){var r=C.getLibraryResourceBundle(c.getMetadata().getLibraryName());return r.getText(m);};
return S;});
sap.ui.predefine('sap/ui/core/ShortcutHintsMixin',["sap/ui/base/EventProvider","./Element","./ShortcutHint","./Popup","./InvisibleText","sap/ui/dom/containsOrEquals","sap/ui/events/checkMouseEnterOrLeave"],function(E,a,S,P,I,c,b){"use strict";var d=function(C){this.sControlId=C.getId();this._hintConfigs=[];};
d.init=function(C){C._shortcutHintsMixin=new d(C);};
d.addConfig=function(C,o,i){if(/sap-ui-xx-noshortcuthints=true/.test(document.location.search)){return;}var M=C._shortcutHintsMixin;if(!M){d.init(C);M=C._shortcutHintsMixin;}M._hintConfigs.push(o);M.initHint(o,i);};
d.hideAll=function(){var C;for(var s in h.mControls){C=a.registry.get(s);if(C){C._shortcutHintsMixin.hideShortcutHint();}}};
d.isDOMIDRegistered=function(D){return h.mDOMNodes[D]&&!!h.mDOMNodes[D].length;};
d.isControlRegistered=function(C){return!!h.mControls[C];};
d.prototype._attachToEvents=function(){var C;if(!d.isControlRegistered(this.sControlId)){C=a.registry.get(this.sControlId);C.addEventDelegate(H,this);}};
d.prototype.register=function(D,C,o){this._attachToEvents();if(!d.isControlRegistered(this.sControlId)){var i=a.registry.get(this.sControlId);i._originalExit=i.exit;i.exit=function(){if(i._originalExit){i._originalExit.apply(i,arguments);}this.deregister();}.bind(this);}h.mControls[this.sControlId]=true;if(!h.mDOMNodes[D]){h.mDOMNodes[D]=[];}h.mDOMNodes[D].push(new S(o,C));};
d.prototype.deregister=function(){var n=this.getRegisteredShortcutInfos(),i;delete h.mControls[this.sControlId];for(i=0;i<n.length;i++){delete h.mDOMNodes[n[i].id];}};
d.prototype.initHint=function(C,o){var i=this._getShortcutHintInfo(C);if(i.message){this.register(i.id,{message:i.message},o);}else if(i.messageBundleKey){this.register(i.id,{messageBundleKey:i.messageBundleKey},o);}else if(i.event){var n=E.getEventList(o)[i.event],A=[];if(n){A=n.reduce(function(r,L){if(L.fFunction&&L.fFunction._sapui_commandName){r.push(L.fFunction._sapui_commandName);}return r;},[]);}if(A.length){this.register(i.id,{commandName:A[0]},o);}else{o.attachEvent("EventHandlerChange",function(p){var F=p.getParameter("func");if(p.getParameter("type")==="listenerAttached"&&F&&F._sapui_commandName&&p.getParameter("EventId")===i.event){this.register(i.id,{commandName:F._sapui_commandName},o);}},this);}}};
d.prototype._getShortcutHintInfos=function(){return this._hintConfigs.map(this._getShortcutHintInfo,this);};
d.prototype._getShortcutHintInfo=function(o){var i;if(o.domrefid){i=o.domrefid;}else if(o.domrefid_suffix){i=this.sControlId+o.domrefid_suffix;}else{i=this.sControlId;}return{id:i,event:o.event,position:o.position,messageBundleKey:o.messageBundleKey,message:o.message,addAccessibilityLabel:o.addAccessibilityLabel};};
d.prototype.getRegisteredShortcutInfos=function(){return this._getShortcutHintInfos().filter(function(i){return d.isDOMIDRegistered(i.id);},this);};
d.prototype.showShortcutHint=function(o){var t,p=o[0].position||"0 8",M=P.Dock.CenterTop,O=P.Dock.CenterBottom,i=e(),s=o[0].ref,n=_(o[0].id),T;if(!k(s)||!j(s)){return;}T=this._getControlTooltips();if(T[o[0].id]){n=T[o[0].id].tooltip+" ("+n+")";}if(!i){i=f(n);}i.oContent.children[0].textContent=n;if(!i.isOpen()){i.open(1000,M,O,s,p,"flipfit",function(q){i.oContent.style.visibility="hidden";if(t){clearTimeout(t);}t=setTimeout(function(){if(!k(s)||!j(s)){return;}i.oContent.style.visibility="visible";},1000);i._applyPosition(i._oLastPosition);});}};
d.prototype.hideShortcutHint=function(){var p=e();if(p&&p.isOpen()){p.close();}};
d.prototype._findShortcutOptionsForRef=function(n){var o,p=this.getRegisteredShortcutInfos(),i,r=[];for(i=0;i<p.length;i++){o=p[i];o.ref=document.getElementById(o.id);if(c(o.ref,n)){r.push(o);}}return r;};
d.prototype._getControlTooltips=function(){var i=this.getRegisteredShortcutInfos(),C=a.registry.get(this.sControlId);return i.reduce(function(r,o){var t=C._getTitleAttribute&&C._getTitleAttribute(o.id);if(!t){t=C.getTooltip();}if(t){r[o.id]={tooltip:t};}return r;},{});};
d.prototype._updateShortcutHintAccLabel=function(o){var i,s,C;if(!o.addAccessibilityLabel){return;}i=g();s=i.getId();i.setText(_(o.id));C=a.registry.get(this.sControlId);if(i.getText()){if(C.getAriaDescribedBy().indexOf(s)===-1){C.addAriaDescribedBy(s);}}else{C.removeAriaDescribedBy(s);}};
var h=Object.create(null);h.mControls={};h.mDOMNodes={};var H={"onfocusin":function(o){var s=this._findShortcutOptionsForRef(o.target);if(!s.length){return;}d.hideAll();this._updateShortcutHintAccLabel(s[0]);this.showShortcutHint(s);},"onfocusout":function(o){var s=this._findShortcutOptionsForRef(o.target);if(!s.length){return;}this.hideShortcutHint();},"onmouseover":function(o){var s=this._findShortcutOptionsForRef(o.target),D;if(!s.length){return;}D=s[0].ref;if(!m(D)){return;}if(b(o,D)){d.hideAll();this.showShortcutHint(s);}},"onmouseout":function(o){var s=this._findShortcutOptionsForRef(o.target);if(!s.length){return;}if(b(o,s[0].ref)){if(c(s[0].ref,document.activeElement)){return;}this.hideShortcutHint();}},"onAfterRendering":function(){var n=this.getRegisteredShortcutInfos(),o,D;for(var i=0;i<n.length;i++){D=n[i].id;o=document.getElementById(D);o.setAttribute("aria-keyshortcuts",_(D));}}};
function _(D){var i=h.mDOMNodes[D];if(!i||!i.length){return;}return i.map(function(o){return o._getShortcutText();}).join(", ");}
function g(){if(!d._invisibleText){d._invisibleText=new I();d._invisibleText.toStatic();}return d._invisibleText;}
function e(){return d._popup;}
function f(t){var p,C,T;C=document.createElement("span");C.classList.add("sapUiHintContainer");T=document.createElement("div");T.classList.add("sapUiHintText");T.textContent=t;C.appendChild(T);p=new P(C,false,false,false);p.setAnimations(function($,D,i){setTimeout(i,D);},function($,D,i){i();});d._popup=p;return p;}
function j(D){var r;if(!D){return false;}r=D.getBoundingClientRect();return(r.top>=0&&r.left>=0&&r.bottom<=(window.innerHeight||document.documentElement.clientHeight)&&r.right<=(window.innerWidth||document.documentElement.clientWidth));}
function k(i){return i.offsetWidth>0||i.offsetHeight>0||i.getClientRects().length>0;}
function l(i){var t=i.tabIndex;return t!=null&&t>=0&&(i.getAttribute("disabled")==null||i.getAttribute("tabindex"));}
function m(i){return i.nodeType==1&&k(i)&&l(i);}
return d;});
sap.ui.predefine('sap/ui/core/StashedControlSupport',['sap/ui/core/Element',"sap/base/Log","sap/base/assert"],function(E,L,a){"use strict";var S={},s={};
S.mixInto=function(c){a(!c.prototype.unstash,"StashedControlSupport: fnClass already has method 'unstash', sideeffects possible",c.getMetadata().getName());if(c.getMetadata().isA("sap.ui.core.Fragment")||c.getMetadata().isA("sap.ui.core.mvc.View")){throw new Error("Stashing is not supported for sap.ui.coreFragment or sap.ui.core.mvc.View");}m(c);};
function m(c){c.prototype.unstash=function(){if(this.isStashed()){var o=u(this);o.stashed=false;return o;}return this;};c.prototype.isStashed=function(){return!!s[this.getId()];};var C=c.prototype.clone;c.prototype.clone=function(){if(this.isStashed()){throw new Error("A stashed control cannot be cloned, id: '"+this.getId()+"'.");}return C.apply(this,arguments);};var d=c.prototype.destroy;c.prototype.destroy=function(){delete s[this.getId()];d.apply(this,arguments);};}
function u(w){var W;var i;var t;var o=s[w.getId()];W=w.getParent();if(W){t=W.getMetadata().getAggregation(w.sParentAggregationName);i=t.indexOf(W,w);t.remove(W,w);}w.destroy();var C=sap.ui.require("sap/ui/core/Component");var O=C&&C.getOwnerComponentFor(W);var b;var f=o.fnCreate;if(O){b=O.runAsOwner(f);}else{b=f();}if(i>=0){b.forEach(function(c){t.insert(W,c,i);});}delete s[w.getId()];return b[0];}
function g(A,p){var b=[];for(var i in s){var P=sap.ui.getCore().byId(s[i].wrapperId);var I=A?P:i;var o=P&&P.getParent();if(!p||(o&&o.getId()===p)){b.push(I);}}return b;}
S.getStashedControlIds=function(p){return g(false,p);};
S.getStashedControls=function(p){return g(true,p);};
S.createStashedControl=function(b){var o={wrapperId:b.wrapperId,fnCreate:b.fnCreate};s[b.wrapperId]=o;return o;};
return S;});
sap.ui.predefine('sap/ui/core/Title',['./Element','./library'],function(E,l){"use strict";var T=l.TitleLevel;
var a=E.extend("sap.ui.core.Title",{metadata:{library:"sap.ui.core",properties:{text:{type:"string",group:"Appearance",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},level:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:T.Auto},emphasized:{type:"boolean",group:"Appearance",defaultValue:false}}}});
return a;});
sap.ui.predefine('sap/ui/core/TooltipBase',['./Control','./Popup','./library',"sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/control"],function(C,P,l,K,q){"use strict";var O=l.OpenState;
var T=C.extend("sap.ui.core.TooltipBase",{
metadata:{"abstract":true,library:"sap.ui.core",properties:{text:{type:"string",group:"Misc",defaultValue:""},openDuration:{type:"int",group:"Behavior",defaultValue:200},closeDuration:{type:"int",group:"Behavior",defaultValue:200},myPosition:{type:"sap.ui.core.Dock",group:"Behavior",defaultValue:'begin top'},atPosition:{type:"sap.ui.core.Dock",group:"Behavior",defaultValue:'begin bottom'},offset:{type:"string",group:"Behavior",defaultValue:'10 3'},collision:{type:"sap.ui.core.Collision",group:"Behavior",defaultValue:'flip'},openDelay:{type:"int",group:"Misc",defaultValue:500},closeDelay:{type:"int",group:"Misc",defaultValue:100}},events:{closed:{}}},
renderer:null
});
T.prototype._getPopup=function(){var p=new P();p.setShadow(true);T.prototype._getPopup=function(){return p;};return p;};
T.prototype.onfocusin=function(e){var s=q(e.target).control(0);if(s!=null){var d=s.getFocusDomRef();this.sStoredTooltip=null;if(d.title&&d.title!=""){this.sStoredTooltip=d.title;d.title="";}var p=this._getPopup();if(!(p.isOpen()&&p.getContent()==this)){sap.ui.getCore().getRenderManager().render(this,sap.ui.getCore().getStaticAreaRef(),true);}var v=d.getAttribute("aria-describedby");var i=this.getId()+"-title "+this.getId()+"-txt";if(v==null||v==""){d.setAttribute("aria-describedby",i);}else if(v.indexOf(i)==-1){d.setAttribute("aria-describedby",v+" "+i);}}};
T.prototype.onfocusout=function(e){var s=q(e.target).control(0);if(s!=null){var d=s.getFocusDomRef();if(this.sStoredTooltip){d.title=this.sStoredTooltip;}var v=d.getAttribute("aria-describedby");var i=this.getId()+"-title "+this.getId()+"-txt";if(v&&v.indexOf(i)>=0){if(v.trim()==i){d.removeAttribute("aria-describedby");}else{v=v.replace(i,"");d.setAttribute("aria-describedby",v);}}}if(T.sOpenTimeout){clearTimeout(T.sOpenTimeout);T.sOpenTimeout=undefined;}this.sCloseNowTimeout=setTimeout(this["closePopup"].bind(this),this.getCloseDelay());};
T.prototype.isStandardTooltip=function(t){return typeof t==="string"&&!!t.trim();};
T.prototype.onmouseover=function(e){var E=q(e.target).control(0),c=q(e.currentTarget).control(0),L=q(e.relatedTarget).control(0);if(!E){return;}if(E===this){if(this.sCloseNowTimeout){clearTimeout(this.sCloseNowTimeout);this.sCloseNowTimeout=null;}e.stopPropagation();e.preventDefault();return;}if(c===E||!this.isStandardTooltip(E.getTooltip())){if(this.sCloseNowTimeout){clearTimeout(this.sCloseNowTimeout);this.sCloseNowTimeout=null;e.stopPropagation();e.preventDefault();}}if(L){if(L.getParent()){if(L.getParent()===c&&c===E){var o=L.getTooltip();if(!this.isStandardTooltip(o)&&(!o||!(o instanceof T))){if(this.sCloseNowTimeout){clearTimeout(this.sCloseNowTimeout);this.sCloseNowTimeout=null;e.stopPropagation();e.preventDefault();}}}}}if(this._currentControl===E||!this.isStandardTooltip(E.getTooltip())){this.removeStandardTooltips();if(T.sOpenTimeout){clearTimeout(T.sOpenTimeout);}T.sOpenTimeout=setTimeout(this["openPopup"].bind(this,this._currentControl),this.getOpenDelay());e.stopPropagation();e.preventDefault();}};
T.prototype.onmouseout=function(e){if(T.sOpenTimeout){clearTimeout(T.sOpenTimeout);T.sOpenTimeout=undefined;}if(!this.sCloseNowTimeout){this.sCloseNowTimeout=setTimeout(this["closePopup"].bind(this),this.getCloseDelay());}this.restoreStandardTooltips();e.stopPropagation();e.preventDefault();};
T.prototype.closePopup=function(){var p=this._getPopup();if(this.sCloseNowTimeout){clearTimeout(this.sCloseNowTimeout);}this.sCloseNowTimeout=undefined;p.attachClosed(this.handleClosed,this);p.close();this.restoreStandardTooltips();};
T.prototype.handleClosed=function(){this._getPopup().detachClosed(this.handleClosed,this);this.fireClosed();};
T.prototype.openPopup=function(s){if(!this.getVisible()){return;}if(s.getTooltip()!=null){if(this.sCloseNowTimeout){clearTimeout(this.sCloseNowTimeout);this.sCloseNowTimeout=null;return;}var p=this._getPopup();if(p.isOpen()&&p.getContent()==this){return;}sap.ui.getCore().getRenderManager().render(this,sap.ui.getCore().getStaticAreaRef(),true);var d=s.getDomRef();p.setContent(this);p.setPosition(this.getMyPosition(),this.getAtPosition(),d,this.getOffset(),this.getCollision());p.setDurations(this.getOpenDuration(),this.getCloseDuration());p.open();this.removeStandardTooltips();}};
T.prototype.removeStandardTooltips=function(){var d=this._currentControl.getDomRef();if(!this.aStoredTooltips){this.aStoredTooltips=[];}else{return;}var t="";while(d&&!(d===document)){t=d.title;if(t){this.aStoredTooltips.push({domref:d,tooltip:t});d.title="";}d=d.parentNode;}if(this._currentControl.getTooltipDomRefs){var D=this._currentControl.getTooltipDomRefs();for(var i=0;i<D.length;i++){d=D[i];if(d){t=d.title;if(t){this.aStoredTooltips.push({domref:d,tooltip:t});d.title="";}}}}};
T.prototype.restoreStandardTooltips=function(){var p=this._getPopup();var e=p.getOpenState();if(e===O.OPEN||e===O.OPENING){return;}if(T.sOpenTimeout){return;}if(this.aStoredTooltips){for(var i=0;i<this.aStoredTooltips.length;i++){var d=this.aStoredTooltips[i].domref;d.title=this.aStoredTooltips[i].tooltip;}}this.aStoredTooltips=null;};
T.prototype._setParent=T.prototype.setParent;
T.prototype.setParent=function(p,a){var _=this._getPopup();if(_&&_.isOpen()){this.closePopup();}this._setParent.apply(this,arguments);};
T.prototype.onkeydown=function(e){if(e.ctrlKey&&e.which==K.I){var E=q(e.target).control(0);if(E!=null){if(this._currentControl===E||!this.isStandardTooltip(E.getTooltip())){this.removeStandardTooltips();this.openPopup(this._currentControl);e.preventDefault();e.stopPropagation();}}}else if(e.which==K.ESCAPE){if(T.sOpenTimeout){clearTimeout(T.sOpenTimeout);T.sOpenTimeout=undefined;}var w=this.oPopup&&this.oPopup.isOpen();this.closePopup();if(w){e.preventDefault();e.stopPropagation();}}};
T.prototype._closeOrPreventOpen=function(){var p=this._getPopup();if(p.isOpen()){this.closePopup();}else if(T.sOpenTimeout){clearTimeout(T.sOpenTimeout);T.sOpenTimeout=undefined;}};
return T;});
sap.ui.predefine('sap/ui/core/UIComponent',['../base/ManagedObject','./Component','./library','./UIComponentMetadata','./mvc/Controller','./mvc/View',"sap/base/util/ObjectPath","sap/base/Log"],function(M,C,l,U,a,V,O,L){"use strict";var b=l.mvc.ViewType;
var c=C.extend("sap.ui.core.UIComponent",{
constructor:function(i,s){var d=false;try{if(typeof i!=="string"){s=i;i=undefined;}if(s&&s.hasOwnProperty("_routerHashChanger")){this._oRouterHashChanger=s._routerHashChanger;delete s._routerHashChanger;}if(s&&s.hasOwnProperty("_propagateTitle")){this._bRoutingPropagateTitle=s._propagateTitle;delete s._propagateTitle;}C.apply(this,arguments);d=true;}finally{if(!d){this._destroyCreatedInstances();}}},
metadata:{"abstract":true,rootView:null,publicMethods:["render"],aggregations:{"rootControl":{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},designtime:"sap/ui/core/designtime/UIComponent.designtime",routing:{}}
},U);
c._fnOnInstanceInitialized=null;c._fnOnInstanceDestroy=null;
c.prototype.init=function(){var t=this;var p={};if(this.getAutoPrefixId()){p.id=function(i){return t.createId(i);};}var r=this._getManifestEntry("/sap.ui5/routing",true)||{},R=r.config||{},v=r.routes;if(v){var d=sap.ui.requireSync("sap/ui/core/routing/Router");var f=g(this._getRouterClassName()||d);this._oRouter=new f(v,R,this,r.targets,this._oRouterHashChanger);this._oTargets=this._oRouter.getTargets();this._oViews=this._oRouter.getViews();}else if(r.targets){var T=sap.ui.requireSync("sap/ui/core/routing/Targets");var e=sap.ui.requireSync("sap/ui/core/routing/Views");this._oViews=new e({component:this});var h=g(R.targetsClass||T);this._oTargets=new h({targets:r.targets,config:R,views:this._oViews});}this.runAsOwner(function(){M.runWithPreprocessors(function(){t.setAggregation("rootControl",t.createContent());},p);});var o=this.getRootControl();if(o instanceof V){if(R.targetParent===undefined){R.targetParent=o.getId();}if(this._oTargets){this._oTargets._setRootViewId(o.getId());}}if(typeof c._fnOnInstanceInitialized==="function"){c._fnOnInstanceInitialized(this);}};
function g(r){var f;if(typeof r==="string"){f=O.get(r);if(!f){L.error("The specified class for router or targets '"+r+"' is undefined.",this);}}else{f=r;}return f;}
c.prototype.destroy=function(){if(typeof c._fnOnInstanceDestroy==="function"){c._fnOnInstanceDestroy(this);}this._destroyCreatedInstances();C.prototype.destroy.apply(this,arguments);};
c.prototype._destroyCreatedInstances=function(){if(this._oRouter){this._oRouter.destroy();delete this._oRouter;}else{if(this._oTargets){this._oTargets.destroy();this._oTargets=null;}if(this._oViews){this._oViews.destroy();this._oViews=null;}}};
c.getRouterFor=function(o){var v=o;if(v instanceof a){v=v.getView();}if(v instanceof V){var d=C.getOwnerComponentFor(v);if(d){return d.getRouter();}else{return undefined;}}};
c.prototype.getRouter=function(){return this._oRouter;};
c.prototype.hasNativeRouter=function(){return this._oRouter===this.getRouter();};
c.prototype.getTargets=function(){return this._oTargets;};
c.prototype.getAutoPrefixId=function(){return!!this.getManifestObject().getEntry("/sap.ui5/autoPrefixId");};
c.prototype.byId=function(i){return sap.ui.getCore().byId(this.createId(i));};
c.prototype.createId=function(i){if(!this.isPrefixedId(i)){i=this.getId()+"---"+i;}return i;};
c.prototype.getLocalId=function(i){var p=this.getId()+"---";return(i&&i.indexOf(p)===0)?i.slice(p.length):null;};
c.prototype.isPrefixedId=function(i){return!!(i&&i.indexOf(this.getId()+"---")===0);};
c.prototype.createContent=function(){var r=this._getManifestEntry("/sap.ui5/rootView",true);if(r&&typeof r==="string"){return V._legacyCreate({viewName:r,type:b.XML});}else if(r&&typeof r==="object"){if(r.id){r.id=this.createId(r.id);}if(r.async&&r.type===b.XML){r.processingMode="sequential";}return V._legacyCreate(r);}else if(r){throw new Error("Configuration option 'rootView' of component '"+this.getMetadata().getName()+"' is invalid! 'rootView' must be type of string or object!");}return null;};
c.prototype.getRootControl=function(){return this.getAggregation("rootControl");};
c.prototype.render=function(r){var o=this.getRootControl();if(o&&r){r.renderControl(o);}};
c.prototype.getUIArea=function(){return(this.oContainer?this.oContainer.getUIArea():null);};
c.prototype.getEventingParent=function(){return this.getUIArea();};
c.prototype.setContainer=function(o){this.oContainer=o;if(o){this._applyContextualSettings(o._getContextualSettings());}else{this._oContextualSettings=M._defaultContextualSettings;if(!this._bIsBeingDestroyed){setTimeout(function(){if(!this.oContainer){this._propagateContextualSettings();}}.bind(this),0);}}return this;};
c.prototype.onBeforeRendering=function(){};
c.prototype.onAfterRendering=function(){};
c.prototype._getRouterClassName=function(){var r=this._getManifestEntry("/sap.ui5/routing",true)||{},R=r.config||{};return R.routerClass;};
return c;});
sap.ui.predefine('sap/ui/core/UIComponentMetadata',['./ComponentMetadata','./library'],function(C,l){"use strict";var V=l.mvc.ViewType;var U=function(c,o){C.apply(this,arguments);};U.prototype=Object.create(C.prototype);U.prototype.constructor=U;
U.preprocessClassInfo=function(c){if(c&&typeof c.metadata==="string"){c.metadata={_src:c.metadata};}return c;};
U.prototype.getRootView=function(d){return this.getManifestEntry("/sap.ui5/rootView",!d);};
U.prototype.getRoutingConfig=function(d){return this.getManifestEntry("/sap.ui5/routing/config",!d);};
U.prototype.getRoutes=function(d){return this.getManifestEntry("/sap.ui5/routing/routes",!d);};
U.prototype._convertLegacyMetadata=function(s,m){C.prototype._convertLegacyMetadata.call(this,s,m);var u=m["sap.ui5"];var r=u["rootView"]||s["rootView"];if(r){u["rootView"]=r;}var R=u["routing"]||s["routing"];if(R){u["routing"]=R;}if(u["rootView"]&&typeof u["rootView"]==="string"){u["rootView"]={viewName:u["rootView"],type:V.XML};}};
return U;},true);
sap.ui.predefine('sap/ui/core/ValueStateSupport',['./Element','./library',"sap/base/assert"],function(E,l,a){"use strict";var V=l.ValueState;var b={};var t=null;var e=function(){if(!t){t={};var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.core");t[V.Error]=r.getText("VALUE_STATE_ERROR");t[V.Warning]=r.getText("VALUE_STATE_WARNING");t[V.Success]=r.getText("VALUE_STATE_SUCCESS");t[V.Information]=r.getText("VALUE_STATE_INFORMATION");}};
b.enrichTooltip=function(o,T){a(o instanceof E,"oElement must be an Element");if(!T&&o.getTooltip()){return undefined;}var s=b.getAdditionalText(o);if(s){return(T?T+" - ":"")+s;}return T;};
b.getAdditionalText=function(v){var s=null;if(v&&v.getValueState){s=v.getValueState();}else if(V[v]){s=v;}if(s&&(s!=V.None)){e();return t[s];}return null;};
b.formatValueState=function(s){switch(s){case 1:return V.Warning;case 2:return V.Success;case 3:return V.Error;case 4:return V.Information;default:return V.None;}};
return b;},true);
sap.ui.predefine('sap/ui/core/VariantLayoutData',['./LayoutData','./library'],function(L,l){"use strict";
var V=L.extend("sap.ui.core.VariantLayoutData",{metadata:{library:"sap.ui.core",aggregations:{multipleLayoutData:{type:"sap.ui.core.LayoutData",multiple:true,singularName:"multipleLayoutData"}}}});
return V;});
sap.ui.predefine('sap/ui/core/XMLComposite',['sap/ui/core/Control','sap/ui/core/XMLCompositeMetadata','sap/ui/model/base/ManagedObjectModel','sap/ui/model/json/JSONModel','sap/ui/core/Fragment','sap/ui/base/ManagedObject','sap/ui/base/DataType','sap/ui/model/resource/ResourceModel','sap/base/Log','sap/ui/performance/Measurement'],function(C,X,M,J,F,a,D,R,L,b){"use strict";var x="sap.ui.core.XMLComposite";
var c=C.extend("sap.ui.core.XMLComposite",{
metadata:{interfaces:["sap.ui.core.IDScope"],properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%',invalidate:true},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null,invalidate:true},displayBlock:{type:"boolean",group:"Appearance",defaultValue:true,invalidate:true}},aggregations:{_content:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden",invalidate:true}}},
constructor:function(){this._bIsCreating=true;C.apply(this,arguments);delete this._bIsCreating;},
renderer:{apiVersion:2,render:function(r,o){L.debug("Start rendering '"+o.sId,x);b.start(o.getId()+"---renderControl","Rendering of "+o.getMetadata().getName(),["rendering","control"]);r.openStart("div",o);r.accessibilityState(o);if(!o.getDisplayBlock()&&(o.getWidth()!=="100%"||o.getHeight()!=="100%")){r.style("display","inline-block");}r.style("height",o.getHeight());r.style("width",o.getWidth());r.openEnd();var d=o._renderingContent?o._renderingContent():o._getCompositeAggregation();if(d){r.renderControl(d);}r.close("div");b.end(o.getId()+"---renderControl");L.debug("Stop rendering '"+o.sId,x);}}
},X);
c.prototype.byId=function(i){return sap.ui.getCore().byId(F.createId(this.getId(),i));};
c.prototype._getManagedObjectModel=function(){if(!this._oManagedObjectModel){this._oManagedObjectModel=new M(this);}return this._oManagedObjectModel;};
c.prototype.getSuppressInvalidateAggregation=function(n,s){var m=this.getMetadata(),A=m.getAggregation(n)||m.getAllPrivateAggregations()[n];if(!A){return true;}s=m._suppressInvalidate(A,s);return s;};
c.prototype.setProperty=function(n,v,s){var m=this.getMetadata(),p=m.getManagedProperty(n);if(!p){return this;}s=m._suppressInvalidate(p,s);return C.prototype.setProperty.apply(this,[n,v,s]);};
c.prototype.setAggregation=function(n,o,s){return C.prototype.setAggregation.apply(this,[n,o,this.getSuppressInvalidateAggregation(n,s)]);};
c.prototype.addAggregation=function(n,o,s){return C.prototype.addAggregation.apply(this,[n,o,this.getSuppressInvalidateAggregation(n,s)]);};
c.prototype.insertAggregation=function(n,o,i,s){return C.prototype.insertAggregation.apply(this,[n,o,i,this.getSuppressInvalidateAggregation(n,s)]);};
c.prototype.removeAggregation=function(n,o,s){return C.prototype.removeAggregation.apply(this,[n,o,this.getSuppressInvalidateAggregation(n,s)]);};
c.prototype.removeAllAggregation=function(n,s){return C.prototype.removeAllAggregation.apply(this,[n,this.getSuppressInvalidateAggregation(n,s)]);};
c.prototype.destroyAggregation=function(n,s){return C.prototype.destroyAggregation.apply(this,[n,this.getSuppressInvalidateAggregation(n,s)]);};
c.prototype.updateAggregation=function(n,s){var A=this.getMetadata().getAggregation(n);if(A&&A.type==="TemplateMetadataContext"){this.invalidate();return;}C.prototype.updateAggregation.apply(this,arguments);};
c.prototype.setVisible=function(v){this.setProperty("visible",v);if(this.getParent()){this.getParent().invalidate();}return this;};
c.prototype._destroyCompositeAggregation=function(){var o=this._getCompositeAggregation();if(o){o.destroy("KeepDom");}return this;};
c.prototype.updateBindings=function(){if(this._bIsCreating){return;}var r=C.prototype.updateBindings.apply(this,arguments);for(var n in this.mBindingInfos){var A=this.getMetadata().getAggregation(n);if(A&&A.multiple&&!A._doesNotRequireFactory&&this.isBound(n)&&!this.getBinding(n)){this[A._sDestructor]();}}return r;};
c.prototype._getCompositeAggregation=function(){var s=this.getMetadata().getCompositeAggregationName();return this.getAggregation(s);};
c.prototype._setCompositeAggregation=function(n){var s=this.getMetadata().getCompositeAggregationName();this._destroyCompositeAggregation();if(!this._oManagedObjectModel){this._getManagedObjectModel();}if(Array.isArray(n)){this.setAggregation(s,null);return;}if(n){if(!n.enhanceAccessibilityState){n.enhanceAccessibilityState=function(e,A){this.enhanceAccessibilityState(e,A);}.bind(this);}n.bindObject("$"+this.alias+">/");n.setModel(this._oManagedObjectModel,"$"+this.alias);if(this.bUsesI18n){var r=this._getResourceModel();if(r){n.setModel(r,"$"+this.alias+".i18n");}}}this.setAggregation(s,n);};
c.mResourceModels={};
c.getLibraryResourceModel=function(l){var o=c.mResourceModels[l];if(!o){o=new R({bundleName:l+".messagebundle",async:true});c.mResourceModels[l]=o;}return o;};
c.prototype._getResourceModel=function(){if(this.resourceModel){return this.resourceModel;}if(this.messageBundle){this.resourceModel=new R({bundleName:this.messageBundle,async:true});return this.resourceModel;}else{this.sLibraryName=this.sLibraryName||this.getMetadata().getLibraryName();if(this.sLibraryName){return c.getLibraryResourceModel(this.sLibraryName);}}};
c.prototype.getResourceBundle=function(){var r=this._getResourceModel();return r?r.getResourceBundle():null;};
c.prototype.destroy=function(){C.prototype.destroy.apply(this,arguments);if(this.resourceModel){this.resourceModel.destroy();}if(this._oManagedObjectModel){this._oManagedObjectModel.destroy();}};
c.prototype._initCompositeSupport=function(s){var m=this.getMetadata(),f=m._fragment,A=m.getCompositeAggregationName();this._destroyCompositeAggregation();if(s&&A&&s[A]){var n=s[A];if(n.localName==="FragmentDefinition"){f=n;delete s[A];}}var d=f?(new XMLSerializer()).serializeToString(f):undefined;this.bUsesI18n=d?(d.indexOf("$"+this.alias+".i18n")!=-1):true;this._setCompositeAggregation(sap.ui.xmlfragment({sId:this.getId(),fragmentContent:f,oController:this}));this._bIsInitialized=true;};
c.prototype.enhanceAccessibilityState=function(e,A){var p=this.getParent();if(p&&p.enhanceAccessibilityState){return p.enhanceAccessibilityState(this,A);}return A;};
c.prototype.getFocusDomRef=function(){var o=this._renderingContent?this._renderingContent():this._getCompositeAggregation();return o.getFocusDomRef();};
c.prototype.getFocusInfo=function(){var o=this._renderingContent?this._renderingContent():this._getCompositeAggregation();return o.getFocusInfo();};
c.prototype.getIdForLabel=function(){var o=this._renderingContent?this._renderingContent():this._getCompositeAggregation();return o.getIdForLabel();};
return c;});
sap.ui.predefine('sap/ui/core/XMLCompositeMetadata',['sap/ui/core/ElementMetadata','sap/ui/core/XMLTemplateProcessor',"sap/base/Log"],function(E,X,L){"use strict";var f={};var a=function(c,C){this.InvalidationMode={Render:true,None:false};if(!C.hasOwnProperty("renderer")){C.renderer="sap.ui.core.XMLCompositeRenderer";}if(!C.hasOwnProperty("alias")){C.alias="this";}E.apply(this,arguments);var b=this._bAbstract;if(!b){if(!C.fragment&&c!=="sap.ui.core.XMLComposite"){C.fragment=c;C.fragmentUnspecified=true;}if(!this._fragment&&C.fragment){try{if(!this._fragment){if(C.fragmentContent){if(typeof C.fragmentContent==="string"){var p=new DOMParser();C.fragmentContent=p.parseFromString(C.fragmentContent,"text/xml").documentElement;if(C.fragmentContent&&C.fragmentContent.getElementsByTagName("parsererror").length){var m=C.fragmentContent.getElementsByTagName("parsererror")[0].innerText;throw new Error("There was an error parsing the XML fragment for XMLComposite '"+c+"'. The following message may contain hints to find the problem: "+m);}}this._fragment=C.fragmentContent;}else{this._fragment=this._loadFragment(C.fragment,"control");}}}catch(e){if(!C.fragmentUnspecified||e.message.startsWith("There was an error parsing")){throw(e);}else{L.warning("Implicitly inferred fragment xml "+C.fragment+" not found. "+c+" is not abstract!");}}}}this._sCompositeAggregation=C.metadata?C.metadata.compositeAggregation||null:null;this._createPrivateAggregationAccessors();this._applyAggregationSettings();};a.prototype=Object.create(E.prototype);a.prototype.constructor=a;a.uid=E.uid;
a.extend=function(s){for(var k in s){a[k]=s[k];}return a;};
a.prototype.getCompositeAggregationName=function(){return this._sCompositeAggregation||"_content";};
a.prototype.getFragment=function(){if(this._fragment){return this._fragment.cloneNode(true);}};
a.prototype._applyAggregationSettings=function(){var A=this.getAllAggregations();for(var n in A){if(A[n].type==="TemplateMetadataContext"){this.getAggregation(n)._doesNotRequireFactory=true;}}};
a.prototype._createPrivateAggregationAccessors=function(){var p=this.getAllPrivateAggregations(),b=this.getClass().prototype,g=function(c,d){if(!b[c]){b[c]=d;}};for(var n in p){p[n].generate(g);}};
a.prototype._suppressInvalidate=function(m,s){if(s){return true;}if(!m.appData){m.appData={};m.appData.invalidate=this.InvalidationMode.None;}if(m&&m.appData&&m.appData.invalidate===this.InvalidationMode.Render){return false;}return true;};
a.prototype.getMandatoryAggregations=function(){if(!this._mMandatoryAggregations){var A=this.getAllAggregations(),m={};for(var n in A){if(A[n].type==="TemplateMetadataContext"&&A[n].appData.mandatory){m[n]=A[n];}}this._mMandatoryAggregations=m;}return this._mMandatoryAggregations;};
a.prototype._loadFragment=function(F,e){var s=e+"$"+F;if(!f[s]){f[s]=X.loadTemplate(F,e);}return f[s];};
return a;},true);
sap.ui.predefine('sap/ui/core/XMLTemplateProcessor',['sap/ui/thirdparty/jquery','sap/ui/base/DataType','sap/ui/base/ManagedObject','sap/ui/core/CustomData','./mvc/View','./mvc/EventHandlerResolver','./ExtensionPoint','./StashedControlSupport','sap/ui/base/SyncPromise','sap/base/Log','sap/base/util/ObjectPath','sap/base/util/values','sap/base/assert','sap/base/security/encodeXML','sap/base/util/LoaderExtensions','sap/base/util/JSTokenizer','sap/base/util/isEmptyObject'],function(q,D,M,C,V,E,a,S,b,L,O,v,c,d,f,J,g){"use strict";
function h(e,i,N,j,R){var B=M.bindingParser(i,j,true,false,false,false,R);if(B&&typeof B==="object"){return B;}var p=i=B||i;var y=D.getType(e);if(y){if(y instanceof D){p=y.parseValue(i,{context:j,locals:R});if(!y.isValid(p)){L.error("Value '"+i+"' is not valid for type '"+y.getName()+"'.");}}}else{throw new Error("Property "+N+" has unknown type "+e);}return typeof p==="string"?M.bindingParser.escape(p):p;}
function l(e){return e.localName||e.baseName||e.nodeName;}
var X="http://www.w3.org/1999/xhtml";var k="http://www.w3.org/2000/svg";var m="sap.ui.core";var n="http://schemas.sap.com/sapui5/extension/sap.ui.core.CustomData/1";var o="http://schemas.sap.com/sapui5/extension/sap.ui.core.support.Support.info/1";var r="http://schemas.sap.com/sapui5/extension/sap.ui.core.xmlcomposite/1";var I="http://schemas.sap.com/sapui5/extension/sap.ui.core.Internal/1";var P="http://schemas.sap.com/sapui5/preprocessorextension/";
function s(A,e){function i(p,y,z,B){var F,G,H=[];for(F=p.firstChild;F;F=F.nextSibling){G=e(p,y,z,F,false,B);if(G){H.push(G.unwrap());}}return b.resolve(H);}function j(p,y,z,B){var F,G=Promise.resolve(),H=[B];for(F=p.firstChild;F;F=F.nextSibling){G=G.then(e.bind(null,p,y,z,F,false,B));H.push(G);}return Promise.all(H);}return A?j:i;}
var t={};
t.loadTemplate=function(e,i){var R=e.replace(/\./g,"/")+("."+(i||"view")+".xml");return f.loadResource(R).documentElement;};
t.loadTemplatePromise=function(e,i){var R=e.replace(/\./g,"/")+("."+(i||"view")+".xml");return f.loadResource(R,{async:true}).then(function(j){return j.documentElement;});};
t.parseViewAttributes=function(e,j,p){var A=j.getMetadata().getAllProperties();for(var i=0;i<e.attributes.length;i++){var y=e.attributes[i];if(y.name==='controllerName'){j._controllerName=y.value;}else if(y.name==='resourceBundleName'){j._resourceBundleName=y.value;}else if(y.name==='resourceBundleUrl'){j._resourceBundleUrl=y.value;}else if(y.name==='resourceBundleLocale'){j._resourceBundleLocale=y.value;}else if(y.name==='resourceBundleAlias'){j._resourceBundleAlias=y.value;}else if(y.name==='class'){j.addStyleClass(y.value);}else if(!p[y.name]&&A[y.name]){p[y.name]=h(A[y.name].type,y.value,y.name,j._oContainingView.oController);}}};
t.enrichTemplateIds=function(e,i){t.enrichTemplateIdsPromise(e,i,false);return e;};
t.enrichTemplateIdsPromise=function(e,i,A){return x(e,i,true,A).then(function(){return e;});};
t.parseTemplate=function(e,i){return t.parseTemplatePromise(e,i,false).unwrap();};
t.parseTemplatePromise=function(i,j,A,y){return x(i,j,false,A,y).then(function(){var p=b.resolve();var z=arguments;if(j.isA("sap.ui.core.mvc.View")&&j._epInfo&&j._epInfo.all.length>0){p=T(A,j,{"content":j._epInfo.all});}return p.then(function(){if(Array.isArray(z[0])){z[0]=z[0].filter(function(e){return!e._isExtensionPoint;});}return z[0];});});};
function u(R){var e,i=/^[a-zA-Z_$][a-zA-Z0-9_$]*$/;if(!R||typeof R!=="object"){e="core:require in XMLView can't be parsed to a valid object";}else{Object.keys(R).some(function(K){if(!i.test(K)){e="core:require in XMLView contains invalid identifier: '"+K+"'";return true;}if(!R[K]||typeof R[K]!=="string"){e="core:require in XMLView contains invalide value '"+R[K]+"'under key '"+K+"'";return true;}});}return e;}
function w(j,A){var p=j.getAttributeNS(m,"require"),R,y,z;if(p){try{R=J.parseJS(p);}catch(e){L.error("Require attribute can't be parsed on Node: ",j.nodeName);throw e;}z=u(R);if(z){throw new Error(z+" on Node: "+j.nodeName);}if(!g(R)){y={};if(A){return new Promise(function(B,F){var G=Object.keys(R).reduce(function(i,K){y[K]=sap.ui.require(R[K]);return i&&y[K]!==undefined;},true);if(G){B(y);return;}sap.ui.require(v(R),function(){var H=arguments;Object.keys(R).forEach(function(K,i){y[K]=H[i];});B(y);},F);});}else{Object.keys(R).forEach(function(K){y[K]=sap.ui.requireSync(R[K]);});return b.resolve(y);}}}}
function T(A,e,i){var j=b.resolve();if(!g(i)){var y=[];var R;if(A){j=new Promise(function(p){R=p;});}Object.keys(i).forEach(function(z){var B=i[z];B.forEach(function(F){F.targetControl=e;var G=sap.ui.require(F.providerClass);if(G){y.push(G.applyExtensionPoint(F));}else{var p=new Promise(function(H,K){sap.ui.require([F.providerClass],function(N){H(N);},K);}).then(function(H){return H.applyExtensionPoint(F);});y.push(p);}});});if(A){Promise.all(y).then(R);}}return j;}
function x(p,y,z,A,B){var R=[],F=w(p,A)||b.resolve();A=A&&y._sProcessingMode==="sequential";L.debug("XML processing mode is "+(A?"sequential":"default"),"","XMLTemplateProcessor");var G=sap.ui.getCore().getConfiguration().getDesignMode();if(G){y._sapui_declarativeSourceInfo={xmlNode:p,xmlRootNode:y._oContainingView===y?p:y._oContainingView._sapui_declarativeSourceInfo.xmlRootNode};}var H=y.sViewName||y._sFragmentName;if(!H){var K=y;var N=0;while(++N<1000&&K&&K!==K._oContainingView){K=K._oContainingView;}H=K.sViewName;}if(y.isSubView()){Z(p,true,false,F);}else{if(p.localName==="View"&&p.namespaceURI!=="sap.ui.core.mvc"){L.warning("XMLView root node must have the 'sap.ui.core.mvc' namespace, not '"+p.namespaceURI+"'"+(H?" (View name: "+H+")":""));}$(p,false,false,F);}var i=0;function Q(){for(;i<R.length;i++){var e=R[i];if(e&&typeof e.then==='function'){return e.then(U).then(Q);}}return R;}function U(e){var j=[i,1].concat(e);Array.prototype.splice.apply(R,j);}return F.then(Q);function W(e){return e;}function Y(e){return y._oContainingView.createId(e);}function Z(p,e,j,f1){if(p.nodeType===1){var g1=l(p);if(p.namespaceURI===X||p.namespaceURI===k){R.push("<"+g1+" ");var h1=false;for(var i=0;i<p.attributes.length;i++){var i1=p.attributes[i];var j1=i1.value;if(i1.name==="id"){h1=true;j1=d1(y,p);}R.push(i1.name+"=\""+d(j1)+"\" ");}if(e===true){R.push("data-sap-ui-preserve"+"=\""+y.getId()+"\" ");if(!h1){R.push("id"+"=\""+y.getId()+"\" ");}}R.push(">");var k1=p;if(window.HTMLTemplateElement&&p instanceof HTMLTemplateElement&&p.content instanceof DocumentFragment){k1=p.content;}$(k1,false,false,f1);R.push("</"+g1+">");}else if(g1==="FragmentDefinition"&&p.namespaceURI===m){$(p,false,true,f1);}else{F=F.then(function(){return b1(p,f1).then(function(n1){for(var i=0;i<n1.length;i++){var o1=n1[i];if(y.getMetadata().hasAggregation("content")){y._epInfo=y._epInfo||{contentControlsCount:0,last:null,all:[]};if(o1._isExtensionPoint){o1.index=y._epInfo.contentControlsCount;o1.targetControl=y;o1.aggregationName="content";if(y._epInfo.last){y._epInfo.last._nextSibling=o1;}y._epInfo.last=o1;y._epInfo.all.push(o1);}else{y._epInfo.contentControlsCount++;y.addAggregation("content",o1);}}else if(y.getMetadata().hasAssociation(("content"))){y.addAssociation("content",o1);}}return n1;});});R.push(F);}}else if(p.nodeType===3&&!j){var l1=p.textContent||p.text,m1=l(p.parentNode);if(l1){if(m1!="style"){l1=d(l1);}R.push(l1);}}}function $(p,e,j,f1){var g1=p.childNodes;for(var i=0;i<g1.length;i++){Z(g1[i],e,j,f1);}}function _(e,j){var f1;var g1=sap.ui.getCore().getLoadedLibraries();q.each(g1,function(k1,l1){if(e===l1.namespace||e===l1.name){f1=l1.name+"."+((l1.tagNames&&l1.tagNames[j])||j);}});f1=f1||e+"."+j;function h1(j1){if(!j1){L.error("Control '"+f1+"' did not return a class definition from sap.ui.define.","","XMLTemplateProcessor");j1=O.get(f1);}if(!j1){L.error("Can't find object class '"+f1+"' for XML-view","","XMLTemplateProcessor");}return j1;}var i1=f1.replace(/\./g,"/");var j1=sap.ui.require(i1);if(!j1){if(A){return new Promise(function(k1,l1){sap.ui.require([i1],function(j1){j1=h1(j1);k1(j1);},l1);});}else{j1=sap.ui.requireSync(i1);j1=h1(j1);}}return j1;}function a1(e,j){if(e.namespaceURI===X||e.namespaceURI===k){var id=e.attributes['id']?e.attributes['id'].textContent||e.attributes['id'].text:null;if(z){return t.enrichTemplateIdsPromise(e,y,A).then(function(){return[];});}else{var f1=function(h1){var i1={id:id?d1(y,e,id):undefined,xmlNode:e,containingView:y._oContainingView,processingMode:y._sProcessingMode};if(y.fnScopedRunWithOwner){return y.fnScopedRunWithOwner(function(){return new h1(i1);});}return new h1(i1);};if(A){return new Promise(function(h1,i1){sap.ui.require(["sap/ui/core/mvc/XMLView"],function(g1){h1([f1(g1)]);},i1);});}else{var g1=sap.ui.requireSync("sap/ui/core/mvc/XMLView");return b.resolve([f1(g1)]);}}}else{return b1(e,j);}}function b1(e,j){if(l(e)==="ExtensionPoint"&&e.namespaceURI===m){if(z){return b.resolve([]);}else{var f1=y instanceof V?y._oContainingView:y;var g1=a._factory.bind(null,f1,e.getAttribute("name"),function(){var i1=b.resolve();var j1=[];var k1=e.childNodes;for(var i=0;i<k1.length;i++){var l1=k1[i];if(l1.nodeType===1){i1=i1.then(a1.bind(null,l1,j));j1.push(i1);}}return b.all(j1).then(function(m1){var n1=[];m1.forEach(function(o1){n1=n1.concat(o1);});return n1;});});return b.resolve(y.fnScopedRunWithOwner?y.fnScopedRunWithOwner(g1):g1());}}else{var h1=_(e.namespaceURI,l(e));if(h1&&typeof h1.then==='function'){return h1.then(function(i1){return c1(e,i1,j);});}else{return c1(e,h1,j);}}}function c1(f1,g1,h1){var ns=f1.namespaceURI,j1={},k1={},l1="",m1=[],n1=null,o1=null,p1=f1.getAttribute("stashed")==="true";if(!z){f1.removeAttribute("stashed");}if(!g1){return b.resolve([]);}var q1=g1.getMetadata();var r1=q1.getAllSettings();var s1=w(f1,A);if(s1){h1=b.all([h1,s1]).then(function(e){return Object.assign({},e[0],e[1]);});}h1=h1.then(function(j){if(g(j)){j=null;}if(!z){for(var i=0;i<f1.attributes.length;i++){var i1=f1.attributes[i],x1=i1.name,y1,z1=r1[x1],A1=i1.value;if(x1==="id"){j1[x1]=d1(y,f1,A1);}else if(x1==="class"){l1+=A1;}else if(x1==="viewName"){j1[x1]=A1;}else if(x1==="fragmentName"){j1[x1]=A1;j1['containingView']=y._oContainingView;}else if((x1==="binding"&&!z1)||x1==='objectBindings'){if(!p1){var B1=M.bindingParser(A1,y._oContainingView.oController);if(B1){j1.objectBindings=j1.objectBindings||{};j1.objectBindings[B1.model||undefined]=B1;}}}else if(x1==='metadataContexts'){if(!p1){var C1=null;try{C1=t._calculatedModelMapping(A1,y._oContainingView.oController,true);}catch(e){L.error(y+":"+e.message);}if(C1){j1.metadataContexts=C1;if(t._preprocessMetadataContexts){t._preprocessMetadataContexts(g1.getMetadata().getName(),j1,y._oContainingView.oController);}}}}else if(x1.indexOf(":")>-1){y1=i1.namespaceURI;if(y1===n){var D1=l(i1);m1.push(new C({key:D1,value:h("any",A1,D1,y._oContainingView.oController)}));}else if(y1===o){o1=A1;}else if(y1&&y1.startsWith(P)){L.debug(y+": XMLView parser ignored preprocessor attribute '"+x1+"' (value: '"+A1+"')");}else if(y1===m||y1===I||x1.startsWith("xmlns:")){}else{if(!n1){n1={};}if(!n1.hasOwnProperty(i1.namespaceURI)){n1[i1.namespaceURI]={};}n1[i1.namespaceURI][l(i1)]=i1.nodeValue;L.debug(y+": XMLView parser encountered unknown attribute '"+x1+"' (value: '"+A1+"') with unknown namespace, stored as sap-ui-custom-settings of customData");}}else if(z1&&z1._iKind===0){j1[x1]=h(z1.type,A1,x1,y._oContainingView.oController,j);}else if(z1&&z1._iKind===1&&z1.altTypes){if(!p1){j1[x1]=h(z1.altTypes[0],A1,x1,y._oContainingView.oController,j);}}else if(z1&&z1._iKind===2){if(!p1){var B1=M.bindingParser(A1,y._oContainingView.oController,false,false,false,false,j);if(B1){j1[x1]=B1;}else{L.error(y+": aggregations with cardinality 0..n only allow binding paths as attribute value (wrong value: "+x1+"='"+A1+"')");}}}else if(z1&&z1._iKind===3){if(!p1){j1[x1]=Y(A1);}}else if(z1&&z1._iKind===4){if(!p1){j1[x1]=A1.split(/[\s,]+/g).filter(W).map(Y);}}else if(z1&&z1._iKind===5){if(!p1){var E1=[];E.parse(A1).forEach(function(F1){var G1=E.resolveEventHandler(F1,y._oContainingView.oController,j);if(G1){E1.push(G1);}else{L.warning(y+": event handler function \""+F1+"\" is not a function or does not exist in the controller.");}});if(E1.length){j1[x1]=E1;}}}else if(z1&&z1._iKind===-1){if(V.prototype.isPrototypeOf(g1.prototype)&&x1=="async"){j1[x1]=h(z1.type,A1,x1,y._oContainingView.oController,j);}else{L.warning(y+": setting '"+x1+"' for class "+q1.getName()+" (value:'"+A1+"') is not supported");}}else{c(x1==='xmlns',y+": encountered unknown setting '"+x1+"' for class "+q1.getName()+" (value:'"+A1+"')");if(t._supportInfo){t._supportInfo({context:f1,env:{caller:"createRegularControls",error:true,info:"unknown setting '"+x1+"' for class "+q1.getName()}});}}}if(n1){m1.push(new C({key:"sap-ui-custom-settings",value:n1}));}if(m1.length>0){j1.customData=m1;}}return j;});var t1=s(A,u1);function u1(f1,v1,w1,e,i1,h1){var x1,y1;if(e.nodeType===1){if(e.namespaceURI===r){j1[l(e)]=e.querySelector("*");return;}x1=e.namespaceURI===ns&&w1&&w1[l(e)];if(x1){return t1(e,x1,false,h1);}else if(v1){if(!i1&&e.getAttribute("stashed")==="true"&&!z){var z1=e;e=e.cloneNode();z1.removeAttribute("stashed");y1=function(){var j=d1(y,e);S.createStashedControl({wrapperId:j,fnCreate:function(){var B1=A;A=false;try{return u1(f1,v1,w1,z1,true,h1).unwrap();}finally{A=B1;}}});};if(y.fnScopedRunWithOwner){y.fnScopedRunWithOwner(y1);}else{y1();}e.setAttribute("visible","false");}return a1(e,h1).then(function(B1){for(var j=0;j<B1.length;j++){var C1=B1[j];var D1=v1.name;if(C1._isExtensionPoint){if(!j1[D1]){j1[D1]=[];}var E1=k1[D1];if(!E1){E1=k1[D1]=[];}C1.index=j1[D1].length;C1.aggregationName=D1;var F1=E1[E1.length-1];if(F1){F1._nextSibling=C1;}E1.push(C1);}else if(v1.multiple){if(!j1[D1]){j1[D1]=[];}if(typeof j1[D1].path==="string"){c(!j1[D1].template,"list bindings support only a single template object");j1[D1].template=C1;}else{j1[D1].push(C1);}}else{c(!j1[D1],"multiple aggregates defined for aggregation with cardinality 0..1");j1[D1]=C1;}}return B1;});}else if(l(f1)!=="FragmentDefinition"||f1.namespaceURI!==m){throw new Error("Cannot add direct child without default aggregation defined for control "+q1.getElementName());}}else if(e.nodeType===3){var A1=e.textContent||e.text;if(A1&&A1.trim()){throw new Error("Cannot add text nodes as direct child of an aggregation. For adding text to an aggregation, a surrounding html tag is needed: "+A1.trim());}}}var v1=q1.getDefaultAggregation();var w1=q1.getAllAggregations();return t1(f1,v1,w1,h1).then(function(){var e;var j=b.resolve();var i1=b.resolve();if(z&&f1.hasAttribute("id")){e1(y,f1);}else if(!z){if(g1.getMetadata().isA("sap.ui.core.Fragment")&&f1.getAttribute("type")!=="JS"&&y._sProcessingMode==="sequential"){j1.processingMode="sequential";}if(V.prototype.isPrototypeOf(g1.prototype)&&typeof g1._sType==="string"){var x1=function(){if(g1.getMetadata().isA("sap.ui.core.mvc.XMLView")&&y._sProcessingMode==="sequential"){j1.processingMode="sequential";}return V._legacyCreate(j1,undefined,g1._sType);};if(y.fnScopedRunWithOwner){e=y.fnScopedRunWithOwner(x1);}else{e=x1();}}else if(g1.getMetadata().isA("sap.ui.core.Fragment")&&A&&["XML","JS","HTML"].indexOf(j1.type)>-1){var y1="sap/ui/core/Fragment";var z1=sap.ui.require(y1);j1.name=j1.name||j1.fragmentName;if(z1){i1=z1.load(j1);}else{i1=new Promise(function(B1,C1){sap.ui.require([y1],function(z1){z1.load(j1).then(function(D1){B1(D1);});},C1);});}}else{var A1=function(){var B1;if(y.fnScopedRunWithOwner){B1=y.fnScopedRunWithOwner(function(){var B1=new g1(j1);return B1;});}else{B1=new g1(j1);}j=T(A,B1,k1);return B1;};if(B&&B.fnRunWithPreprocessor){e=B.fnRunWithPreprocessor(A1);}else{e=A1();}}}return i1.then(function(B1){return B1||e;}).then(function(B1){if(l1&&B1.addStyleClass){B1.addStyleClass(l1);}if(!B1){B1=[];}else if(!Array.isArray(B1)){B1=[B1];}if(t._supportInfo&&B1){for(var i=0,C1=B1.length;i<C1;i++){var D1=B1[i];if(D1&&D1.getId()){var E1=t._supportInfo({context:f1,env:{caller:"createRegularControls",nodeid:f1.getAttribute("id"),controlid:D1.getId()}}),F1=o1?o1+",":"";F1+=E1;t._supportInfo.addSupportInfo(D1.getId(),F1);}}}if(G){B1.forEach(function(D1){if(q1.getCompositeAggregationName){var G1=f1.getElementsByTagName(D1.getMetadata().getCompositeAggregationName());for(var i=0;i<G1.length;i++){f1.removeChild(G1[0]);}}D1._sapui_declarativeSourceInfo={xmlNode:f1,xmlRootNode:y._sapui_declarativeSourceInfo.xmlRootNode,fragmentName:q1.getName()==='sap.ui.core.Fragment'?j1['fragmentName']:null};});}return j.then(function(){return B1;});});});}function d1(y,p,e){if(p.getAttributeNS(I,"id")){return p.getAttribute("id");}else{return Y(e?e:p.getAttribute("id"));}}function e1(y,p){p.setAttribute("id",Y(p.getAttribute("id")));p.setAttributeNS(I,"id",true);}}
t._preprocessMetadataContexts=null;
t._calculatedModelMapping=function(B,e,A){var j,p={},y=M.bindingParser(B,e);function z(F){if(F.length%2===0){throw new Error("The last entry is no binding");}for(var i=1;i<=F.length;i=i+2){if(typeof F[i-1]=='string'){throw new Error("Binding expected not a string");}if(F[i]){if((typeof F[i]!='string')||(F[i]!=",")){throw new Error("Missing delimiter ','");}}}}if(y){if(!y.formatter){j=y;y={parts:[j]};}else{z(y.formatter.textFragments);}for(var i=0;i<y.parts.length;i++){j=y.parts[i];p[j.model]=p[j.model]||(A?[]:null);if(Array.isArray(p[j.model])){p[j.model].push(j);}else{p[j.model]=j;}}}return p;};
return t;},true);
sap.ui.predefine('sap/ui/core/cache/CacheManager',['./LRUPersistentCache','./CacheManagerNOP','sap/ui/Device',"sap/base/Log","sap/ui/performance/Measurement",'sap/ui/performance/trace/Interaction'],function(L,C,D,a,M,I){"use strict";var b={_instance:null,_getInstance:function(){var p,o=d("_getInstance"),t=this;p=new Promise(function(r,e){var f;a.debug("Cache Manager: Initialization...");if(!b._instance){f=t._findImplementation();M.start(c,"CM",S);f.init().then(g,e);M.end(c,"CM");}else{g(b._instance);}function g(h){b._instance=h;o.endAsync();a.debug("Cache Manager initialized with implementation ["+b._instance.name+"], resolving _getInstance promise");r(h);}});o.endSync();return p;},_findImplementation:function(){if(i()&&this._isSupportedEnvironment()){return L;}else{a.warning("UI5 Cache Manager is switched off");return C;}},set:function(k,v){var p,o=d("set",k);a.debug("Cache Manager: Setting value of type["+typeof v+"] with key ["+k+"]");p=this._callInstanceMethod("set",arguments).then(function e(){a.debug("Cache Manager: Setting key ["+k+"] completed successfully");o.endAsync();},function(e){a.error("Cache Manager: Setting key ["+k+"] failed. Error:"+e);o.endAsync();throw e;});o.endSync();return p;},get:function(k){var p,f=I.notifyAsyncStep(),o=d("get",k);a.debug("Cache Manager: Getting key ["+k+"]");p=this._callInstanceMethod("get",arguments).then(function e(v){a.debug("Cache Manager: Getting key ["+k+"] done");o.endAsync();return v;},function(e){a.debug("Cache Manager: Getting key ["+k+"] failed. Error: "+e);o.endAsync();throw e;}).finally(f);o.endSync();return p;},has:function(k){var p,o=d("has",k);a.debug("Cache Manager: has key ["+k+"] called");p=this._callInstanceMethod("has",arguments).then(function e(r){o.endAsync();a.debug("Cache Manager: has key ["+k+"] returned "+r);return r;});o.endSync();return p;},del:function(k){var p,o=d("del",k);a.debug("Cache Manager: del called.");p=this._callInstanceMethod("del",arguments).then(function e(){a.debug("Cache Manager: del completed successfully.");o.endAsync();},function(e){a.debug("Cache Manager: del failed. Error: "+e);o.endAsync();throw e;});o.endSync();return p;},reset:function(){var p,o=d("reset");a.debug("Cache Manager: Reset called.");p=this._callInstanceMethod("reset",arguments).then(function e(){a.debug("Cache Manager: Reset completed successfully.");o.endAsync();},function(e){a.debug("Cache Manager: Reset failed. Error: "+e);o.endAsync();throw e;});o.endSync();return p;},_switchOff:function(){var t=this;return Promise.resolve().then(function(){s(t);sap.ui.getCore().getConfiguration().setUI5CacheOn(false);});},_switchOn:function(){var t=this;return Promise.resolve().then(function(){var o=sap.ui.getCore().getConfiguration();if(!o.isUI5CacheOn()){s(t);sap.ui.getCore().getConfiguration().setUI5CacheOn(true);}return Promise.resolve();});},_callInstanceMethod:function(e,A){var p,f="[sync ] _callInstanceMethod";M.start(f,"CM",S);if(this._instance){a.debug("Cache Manager: calling instance...");return this._instance[e].apply(this._instance,A);}a.debug("Cache Manager: getting instance...");p=this._getInstance().then(function h(g){return g[e].apply(g,A);});M.end(f);return p;},_isSupportedEnvironment:function(){var e=[];if(this._bSupportedEnvironment==undefined){e.push({system:D.system.SYSTEMTYPE.DESKTOP,browserName:D.browser.BROWSER.CHROME,browserVersion:49});e.push({system:D.system.SYSTEMTYPE.DESKTOP,browserName:D.browser.BROWSER.INTERNET_EXPLORER,browserVersion:11});e.push({system:D.system.SYSTEMTYPE.DESKTOP,browserName:D.browser.BROWSER.EDGE,browserVersion:80});e.push({system:D.system.SYSTEMTYPE.DESKTOP,browserName:D.browser.BROWSER.SAFARI,browserVersion:13});e.push({system:D.system.SYSTEMTYPE.TABLET,browserName:D.browser.BROWSER.SAFARI,browserVersion:13});e.push({system:D.system.SYSTEMTYPE.PHONE,browserName:D.browser.BROWSER.SAFARI,browserVersion:13});e.push({system:D.system.SYSTEMTYPE.TABLET,os:D.os.OS.ANDROID,browserName:D.browser.BROWSER.CHROME,browserVersion:80});e.push({system:D.system.SYSTEMTYPE.PHONE,os:D.os.OS.ANDROID,browserName:D.browser.BROWSER.CHROME,browserVersion:80});this._bSupportedEnvironment=e.some(function(o){var f=D.system[o.system],g=o.os?o.os===D.os.name:true,h=o.browserName===D.browser.name,j=D.browser.version>=o.browserVersion;try{return f&&g&&h&&j&&window.indexedDB;}catch(k){return false;}});}return this._bSupportedEnvironment;}};var S="CacheManager",c="[sync ] _initImplementation",m=0;
function i(){return sap.ui.getCore().getConfiguration().isUI5CacheOn();}
function s(e){if(e._instance){e._instance._destroy();e._instance=null;}}
function d(o,k){m++;var e="[async]  "+o+"["+k+"]- #"+(m),f="[sync ]  "+o+"["+k+"]- #"+(m);M.start(e,"CM",[S,o]);M.start(f,"CM",[S,o]);return{sMeasureAsync:e,sMeasureSync:f,endAsync:function(){M.end(this.sMeasureAsync);},endSync:function(){M.end(this.sMeasureSync);}};}
return b;});
sap.ui.predefine('sap/ui/core/cache/CacheManagerNOP',[],function(){"use strict";var C={name:"CacheManagerNOP",set:function(){return Promise.resolve();},get:function(){return Promise.resolve(undefined);},has:function(){return Promise.resolve(false);},del:function(){return Promise.resolve();},reset:function(){return Promise.resolve();},init:function(){return Promise.resolve(this);},_db:{close:function(){}},_getCount:function(){return Promise.resolve(0);},_destroy:function(){}};return C;});
sap.ui.predefine('sap/ui/core/date/Buddhist',['./UniversalDate','../CalendarType','./_Calendars'],function(U,C,_){"use strict";
var B=U.extend("sap.ui.core.date.Buddhist",{constructor:function(){var A=arguments;if(A.length>1){A=b(A);}this.oDate=this.createDate(Date,A);this.sCalendarType=C.Buddhist;}});
B.UTC=function(){var A=b(arguments);return Date.UTC.apply(Date,A);};
B.now=function(){return Date.now();};
function t(g){var e=U.getEraStartDate(C.Buddhist,0).year,y=g.year-e+1;if(g.year<1941&&g.month<3){y-=1;}if(g.year===null){y=undefined;}return{year:y,month:g.month,day:g.day};}
function a(o){var e=U.getEraStartDate(C.Buddhist,0).year,y=o.year+e-1;if(y<1941&&o.month<3){y+=1;}if(o.year===null){y=undefined;}return{year:y,month:o.month,day:o.day};}
function b(A){var o,g;o={year:A[0],month:A[1],day:A[2]!==undefined?A[2]:1};g=a(o);A[0]=g.year;return A;}
B.prototype._getBuddhist=function(){var g={year:this.oDate.getFullYear(),month:this.oDate.getMonth(),day:this.oDate.getDate()};return t(g);};
B.prototype._setBuddhist=function(o){var g=a(o);return this.oDate.setFullYear(g.year,g.month,g.day);};
B.prototype._getUTCBuddhist=function(){var g={year:this.oDate.getUTCFullYear(),month:this.oDate.getUTCMonth(),day:this.oDate.getUTCDate()};return t(g);};
B.prototype._setUTCBuddhist=function(o){var g=a(o);return this.oDate.setUTCFullYear(g.year,g.month,g.day);};
B.prototype.getYear=function(){return this._getBuddhist().year;};
B.prototype.getFullYear=function(){return this._getBuddhist().year;};
B.prototype.getUTCFullYear=function(){return this._getUTCBuddhist().year;};
B.prototype.setYear=function(y){var o=this._getBuddhist();o.year=y;return this._setBuddhist(o);};
B.prototype.setFullYear=function(y,m,d){var o=this._getBuddhist();o.year=y;if(m!==undefined){o.month=m;}if(d!==undefined){o.day=d;}return this._setBuddhist(o);};
B.prototype.setUTCFullYear=function(y,m,d){var o=this._getUTCBuddhist();o.year=y;if(m!==undefined){o.month=m;}if(d!==undefined){o.day=d;}return this._setUTCBuddhist(o);};
B.prototype.getWeek=function(){return U.getWeekByDate(this.sCalendarType,this.oDate.getFullYear(),this.getMonth(),this.getDate());};
B.prototype.getUTCWeek=function(){return U.getWeekByDate(this.sCalendarType,this.oDate.getUTCFullYear(),this.getUTCMonth(),this.getUTCDate());};
_.set(C.Buddhist,B);return B;});
sap.ui.predefine('sap/ui/core/date/Gregorian',['./UniversalDate','../CalendarType','./_Calendars'],function(U,C,_){"use strict";
var G=U.extend("sap.ui.core.date.Gregorian",{constructor:function(){this.oDate=this.createDate(Date,arguments);this.sCalendarType=C.Gregorian;}});
G.UTC=function(){return Date.UTC.apply(Date,arguments);};
G.now=function(){return Date.now();};
_.set(C.Gregorian,G);return G;});
sap.ui.predefine('sap/ui/core/date/Islamic',['./UniversalDate','../CalendarType','sap/base/Log','./_Calendars'],function(U,C,L,_){"use strict";
var I=U.extend("sap.ui.core.date.Islamic",{constructor:function(){var a=arguments;if(a.length>1){a=f(a);}this.oDate=this.createDate(Date,a);this.sCalendarType=C.Islamic;}});
I.UTC=function(){var a=f(arguments);return Date.UTC.apply(Date,a);};
I.now=function(){return Date.now();};
var B=1400,G=1721425.5,c=1948439.5,d=-42521587200000,O=86400000;var o=null;var s=["A","B"];
function t(a){var b=a.year,l=a.month,n=a.day,q,r,u,M,D,v,J;v=0;if((l+1)>2){v=j(b)?-1:-2;}J=(G-1)+(365*(b-1))+Math.floor((b-1)/4)+(-Math.floor((b-1)/100))+Math.floor((b-1)/400)+Math.floor((((367*(l+1))-362)/12)+v+n);J=Math.floor(J)+0.5;D=J-c;M=Math.floor(D/29.530588853);if(M<0){q=Math.floor(M/12)+1;r=M%12;if(r<0){r+=12;}u=D-m(q,r)+1;}else{M++;while(g(M)>D){M--;}q=Math.floor(M/12)+1;r=M%12;u=(D-g(12*(q-1)+r))+1;}return{day:u,month:r,year:q};}
function e(a){var b=a.year,l=a.month,n=a.day,M=b<1?m(b,l):g(12*(b-1)+l),J=n+M+c-1,q=Math.floor(J-0.5)+0.5,D=q-G,Q=Math.floor(D/146097),r=h(D,146097),u=Math.floor(r/36524),v=h(r,36524),w=Math.floor(v/1461),x=h(v,1461),y=Math.floor(x/365),Y=(Q*400)+(u*100)+(w*4)+y,z,A,E,F,H,K,N,P;if(!(u==4||y==4)){Y++;}E=G+(365*(Y-1))+Math.floor((Y-1)/4)-(Math.floor((Y-1)/100))+Math.floor((Y-1)/400);F=q-E;H=(G-1)+(365*(Y-1))+Math.floor((Y-1)/4)-(Math.floor((Y-1)/100))+Math.floor((Y-1)/400)+Math.floor((739/12)+((j(Y)?-1:-2))+1);N=0;if(q<H){N=0;}else{N=j(Y)?1:2;}z=Math.floor((((F+N)*12)+373)/367);K=(G-1)+(365*(Y-1))+Math.floor((Y-1)/4)-(Math.floor((Y-1)/100))+Math.floor((Y-1)/400);P=0;if(z>2){P=j(Y)?-1:-2;}K+=Math.floor((((367*z)-362)/12)+P+1);A=(q-K)+1;return{day:A,month:z-1,year:Y};}
function f(a){var b=Array.prototype.slice.call(a),l,n;l={year:a[0],month:a[1],day:a[2]!==undefined?a[2]:1};n=e(l);b[0]=n.year;b[1]=n.month;b[2]=n.day;return b;}
function i(){var D,a;o={};D=sap.ui.getCore().getConfiguration().getFormatSettings().getLegacyDateFormat();D=k(D)?D:"A";a=sap.ui.getCore().getConfiguration().getFormatSettings().getLegacyDateCalendarCustomizing();a=a||[];if(!a.length){L.warning("No calendar customizations.");return;}a.forEach(function(E){if(E.dateFormat===D){var b=p(E.gregDate);var l=new Date(Date.UTC(b.year,b.month-1,b.day));var M=l.getTime();var n=(M-d)/O;b=p(E.islamicMonthStart);var q=(b.year-1)*12+b.month-1;o[q]=n;}});L.info("Working with date format: ["+D+"] and customization: "+JSON.stringify(a));}
function p(D){return{year:parseInt(D.substr(0,4)),month:parseInt(D.substr(4,2)),day:parseInt(D.substr(6,2))};}
function g(a){if(!o){i();}var b=o[a];if(!b){var y=Math.floor(a/12)+1;var l=a%12;b=m(y,l);}return b;}
function m(y,a){return Math.ceil(29.5*a)+(y-1)*354+Math.floor((3+11*y)/30.0);}
function h(a,b){return a-(b*Math.floor(a/b));}
function j(y){return!(y%400)||(!(y%4)&&!!(y%100));}
function k(a){return s.indexOf(a)!==-1;}
I.prototype._getIslamic=function(){return t({day:this.oDate.getDate(),month:this.oDate.getMonth(),year:this.oDate.getFullYear()});};
I.prototype._setIslamic=function(a){var b=e(a);return this.oDate.setFullYear(b.year,b.month,b.day);};
I.prototype._getUTCIslamic=function(){return t({day:this.oDate.getUTCDate(),month:this.oDate.getUTCMonth(),year:this.oDate.getUTCFullYear()});};
I.prototype._setUTCIslamic=function(a){var b=e(a);return this.oDate.setUTCFullYear(b.year,b.month,b.day);};
I.prototype.getDate=function(D){return this._getIslamic().day;};
I.prototype.getMonth=function(){return this._getIslamic().month;};
I.prototype.getYear=function(){return this._getIslamic().year-B;};
I.prototype.getFullYear=function(){return this._getIslamic().year;};
I.prototype.setDate=function(D){var a=this._getIslamic();a.day=D;return this._setIslamic(a);};
I.prototype.setMonth=function(M,D){var a=this._getIslamic();a.month=M;if(D!==undefined){a.day=D;}return this._setIslamic(a);};
I.prototype.setYear=function(y){var a=this._getIslamic();a.year=y+B;return this._setIslamic(a);};
I.prototype.setFullYear=function(y,M,D){var a=this._getIslamic();a.year=y;if(M!==undefined){a.month=M;}if(D!==undefined){a.day=D;}return this._setIslamic(a);};
I.prototype.getUTCDate=function(D){return this._getUTCIslamic().day;};
I.prototype.getUTCMonth=function(){return this._getUTCIslamic().month;};
I.prototype.getUTCFullYear=function(){return this._getUTCIslamic().year;};
I.prototype.setUTCDate=function(D){var a=this._getUTCIslamic();a.day=D;return this._setUTCIslamic(a);};
I.prototype.setUTCMonth=function(M,D){var a=this._getUTCIslamic();a.month=M;if(D!==undefined){a.day=D;}return this._setUTCIslamic(a);};
I.prototype.setUTCFullYear=function(y,M,D){var a=this._getUTCIslamic();a.year=y;if(M!==undefined){a.month=M;}if(D!==undefined){a.day=D;}return this._setUTCIslamic(a);};
_.set(C.Islamic,I);return I;});
sap.ui.predefine('sap/ui/core/date/Japanese',['./UniversalDate','../CalendarType','./_Calendars'],function(U,C,_){"use strict";
var J=U.extend("sap.ui.core.date.Japanese",{constructor:function(){var A=arguments;if(A.length>1){A=b(A);}this.oDate=this.createDate(Date,A);this.sCalendarType=C.Japanese;}});
J.UTC=function(){var A=b(arguments);return Date.UTC.apply(Date,A);};
J.now=function(){return Date.now();};
function t(g){var e=U.getEraByDate(C.Japanese,g.year,g.month,g.day),E=U.getEraStartDate(C.Japanese,e).year;return{era:e,year:g.year-E+1,month:g.month,day:g.day};}
function a(j){var e=U.getEraStartDate(C.Japanese,j.era).year;return{year:e+j.year-1,month:j.month,day:j.day};}
function b(A){var j,g,e,y=A[0];if(typeof y=="number"){if(y>=100){return A;}else{e=U.getCurrentEra(C.Japanese);y=[e,y];}}else if(!Array.isArray(y)){y=[];}j={era:y[0],year:y[1],month:A[1],day:A[2]!==undefined?A[2]:1};g=a(j);A[0]=g.year;return A;}
J.prototype._getJapanese=function(){var g={year:this.oDate.getFullYear(),month:this.oDate.getMonth(),day:this.oDate.getDate()};return t(g);};
J.prototype._setJapanese=function(j){var g=a(j);return this.oDate.setFullYear(g.year,g.month,g.day);};
J.prototype._getUTCJapanese=function(){var g={year:this.oDate.getUTCFullYear(),month:this.oDate.getUTCMonth(),day:this.oDate.getUTCDate()};return t(g);};
J.prototype._setUTCJapanese=function(j){var g=a(j);return this.oDate.setUTCFullYear(g.year,g.month,g.day);};
J.prototype.getYear=function(){return this._getJapanese().year;};
J.prototype.getFullYear=function(){return this._getJapanese().year;};
J.prototype.getEra=function(){return this._getJapanese().era;};
J.prototype.getUTCFullYear=function(){return this._getUTCJapanese().year;};
J.prototype.getUTCEra=function(){return this._getUTCJapanese().era;};
J.prototype.setYear=function(y){var j=this._getJapanese();j.year=y;return this._setJapanese(j);};
J.prototype.setFullYear=function(y,m,d){var j=this._getJapanese();j.year=y;if(m!==undefined){j.month=m;}if(d!==undefined){j.day=d;}return this._setJapanese(j);};
J.prototype.setEra=function(e,y,m,d){var E=U.getEraStartDate(C.Japanese,e),j=t(E);if(y!==undefined){j.year=y;}if(m!==undefined){j.month=m;}if(d!==undefined){j.day=d;}return this._setJapanese(j);};
J.prototype.setUTCFullYear=function(y,m,d){var j=this._getUTCJapanese();j.year=y;if(m!==undefined){j.month=m;}if(d!==undefined){j.day=d;}return this._setUTCJapanese(j);};
J.prototype.setUTCEra=function(e,y,m,d){var E=U.getEraStartDate(C.Japanese,e),j=t(E);if(y!==undefined){j.year=y;}if(m!==undefined){j.month=m;}if(d!==undefined){j.day=d;}return this._setUTCJapanese(j);};
J.prototype.getWeek=function(){return U.getWeekByDate(this.sCalendarType,this.oDate.getFullYear(),this.getMonth(),this.getDate());};
J.prototype.getUTCWeek=function(){return U.getWeekByDate(this.sCalendarType,this.oDate.getUTCFullYear(),this.getUTCMonth(),this.getUTCDate());};
_.set(C.Japanese,J);return J;});
sap.ui.predefine('sap/ui/core/date/Persian',['./UniversalDate','../CalendarType','./_Calendars'],function(U,C,_){"use strict";
var P=U.extend("sap.ui.core.date.Persian",{constructor:function(){var a=arguments;if(a.length>1){a=e(a);}this.oDate=this.createDate(Date,a);this.sCalendarType=C.Persian;}});
P.UTC=function(){var a=e(arguments);return Date.UTC.apply(Date,a);};
P.now=function(){return Date.now();};
var B=1300;
function t(G){var j=l(G.year,G.month+1,G.day);return h(j);}
function c(a){var j=g(a.year,a.month+1,a.day);return m(j);}
function e(a){var G=Array.prototype.slice.call(a),b,d;if(typeof a[0]!=="number"||typeof a[1]!=="number"||(a[2]!==undefined&&typeof a[2]!="number")){G[0]=NaN;G[1]=NaN;G[2]=NaN;return G;}b={year:a[0],month:a[1],day:a[2]!==undefined?a[2]:1};d=c(b);G[0]=d.year;G[1]=d.month;G[2]=d.day;return G;}
function f(j){var b=[-61,9,38,199,426,686,756,818,1111,1181,1210,1635,2060,2097,2192,2262,2324,2394,2456,3178],a=b.length,d=j+621,k=-14,q=b[0],r,s,u,v,w,n,i;for(i=1;i<a;i+=1){r=b[i];s=r-q;if(j<r){break;}k=k+o(s,33)*8+o(p(s,33),4);q=r;}n=j-q;k=k+o(n,33)*8+o(p(n,33)+3,4);if(p(s,33)===4&&s-n===4){k+=1;}v=o(d,4)-o((o(d,100)+1)*3,4)-150;w=20+k-v;if(s-n<6){n=n-s+o(s+4,33)*33;}u=p(p(n+1,33)-1,4);if(u===-1){u=4;}return{leap:u,gy:d,march:w};}
function g(j,a,b){while(a<1){a+=12;j--;}while(a>12){a-=12;j++;}var r=f(j);return l(r.gy,3,r.march)+(a-1)*31-o(a,7)*(a-7)+b-1;}
function h(j){var a=m(j).year,b=a-621,r=f(b),d=l(a,3,r.march),i,n,k;k=j-d;if(k>=0){if(k<=185){n=1+o(k,31);i=p(k,31)+1;return{year:b,month:n-1,day:i};}else{k-=186;}}else{b-=1;k+=179;if(r.leap===1){k+=1;}}n=7+o(k,30);i=p(k,30)+1;return{year:b,month:n-1,day:i};}
function l(a,b,i){var d=o((a+o(b-8,6)+100100)*1461,4)+o(153*p(b+9,12)+2,5)+i-34840408;d=d-o(o(a+100100+o(b-8,6),100)*3,4)+752;return d;}
function m(a){var j,i,b,d,k;j=4*a+139361631;j=j+o(o(4*a+183187720,146097)*3,4)*4-3908;i=o(p(j,1461),4)*5+308;b=o(p(i,153),5)+1;d=p(o(i,153),12)+1;k=o(j,1461)-100100+o(8-d,6);return{year:k,month:d-1,day:b};}
function o(a,b){return~~(a/b);}
function p(a,b){return a-~~(a/b)*b;}
P.prototype._getPersian=function(){return t({day:this.oDate.getDate(),month:this.oDate.getMonth(),year:this.oDate.getFullYear()});};
P.prototype._setPersian=function(a){var G=c(a);return this.oDate.setFullYear(G.year,G.month,G.day);};
P.prototype._getUTCPersian=function(){return t({day:this.oDate.getUTCDate(),month:this.oDate.getUTCMonth(),year:this.oDate.getUTCFullYear()});};
P.prototype._setUTCPersian=function(a){var G=c(a);return this.oDate.setUTCFullYear(G.year,G.month,G.day);};
P.prototype.getDate=function(d){return this._getPersian().day;};
P.prototype.getMonth=function(){return this._getPersian().month;};
P.prototype.getYear=function(){return this._getPersian().year-B;};
P.prototype.getFullYear=function(){return this._getPersian().year;};
P.prototype.setDate=function(d){var a=this._getPersian();a.day=d;return this._setPersian(a);};
P.prototype.setMonth=function(M,d){var a=this._getPersian();a.month=M;if(d!==undefined){a.day=d;}return this._setPersian(a);};
P.prototype.setYear=function(y){var a=this._getPersian();a.year=y+B;return this._setPersian(a);};
P.prototype.setFullYear=function(y,M,d){var a=this._getPersian();a.year=y;if(M!==undefined){a.month=M;}if(d!==undefined){a.day=d;}return this._setPersian(a);};
P.prototype.getUTCDate=function(d){return this._getUTCPersian().day;};
P.prototype.getUTCMonth=function(){return this._getUTCPersian().month;};
P.prototype.getUTCFullYear=function(){return this._getUTCPersian().year;};
P.prototype.setUTCDate=function(d){var a=this._getUTCPersian();a.day=d;return this._setUTCPersian(a);};
P.prototype.setUTCMonth=function(M,d){var a=this._getUTCPersian();a.month=M;if(d!==undefined){a.day=d;}return this._setUTCPersian(a);};
P.prototype.setUTCFullYear=function(y,M,d){var a=this._getUTCPersian();a.year=y;if(M!==undefined){a.month=M;}if(d!==undefined){a.day=d;}return this._setUTCPersian(a);};
_.set(C.Persian,P);return P;});
sap.ui.predefine('sap/ui/core/date/UniversalDate',['sap/ui/base/Object','sap/ui/core/LocaleData','./_Calendars'],function(B,L,_){"use strict";
var U=B.extend("sap.ui.core.date.UniversalDate",{constructor:function(){var b=U.getClass();return this.createDate(b,arguments);}});
U.UTC=function(){var b=U.getClass();return b.UTC.apply(b,arguments);};
U.now=function(){return Date.now();};
U.prototype.createDate=function(b,A){switch(A.length){case 0:return new b();case 1:return new b(A[0]instanceof Date?A[0].getTime():A[0]);case 2:return new b(A[0],A[1]);case 3:return new b(A[0],A[1],A[2]);case 4:return new b(A[0],A[1],A[2],A[3]);case 5:return new b(A[0],A[1],A[2],A[3],A[4]);case 6:return new b(A[0],A[1],A[2],A[3],A[4],A[5]);case 7:return new b(A[0],A[1],A[2],A[3],A[4],A[5],A[6]);}};
U.getInstance=function(d,C){var b,i;if(d instanceof U){d=d.getJSDate();}else if(!d){d=new Date();}if(!C){C=sap.ui.getCore().getConfiguration().getCalendarType();}b=U.getClass(C);i=Object.create(b.prototype);i.oDate=d;i.sCalendarType=C;return i;};
U.getClass=function(C){if(!C){C=sap.ui.getCore().getConfiguration().getCalendarType();}return _.get(C);};
["getDate","getMonth","getFullYear","getYear","getDay","getHours","getMinutes","getSeconds","getMilliseconds","getUTCDate","getUTCMonth","getUTCFullYear","getUTCDay","getUTCHours","getUTCMinutes","getUTCSeconds","getUTCMilliseconds","getTime","valueOf","getTimezoneOffset","toString","toDateString","setDate","setFullYear","setYear","setMonth","setHours","setMinutes","setSeconds","setMilliseconds","setUTCDate","setUTCFullYear","setUTCMonth","setUTCHours","setUTCMinutes","setUTCSeconds","setUTCMilliseconds"].forEach(function(n){U.prototype[n]=function(){return this.oDate[n].apply(this.oDate,arguments);};});
U.prototype.getJSDate=function(){return this.oDate;};
U.prototype.getCalendarType=function(){return this.sCalendarType;};
U.prototype.getEra=function(){return U.getEraByDate(this.sCalendarType,this.oDate.getFullYear(),this.oDate.getMonth(),this.oDate.getDate());};
U.prototype.setEra=function(E){};
U.prototype.getUTCEra=function(){return U.getEraByDate(this.sCalendarType,this.oDate.getUTCFullYear(),this.oDate.getUTCMonth(),this.oDate.getUTCDate());};
U.prototype.setUTCEra=function(E){};
U.prototype.getWeek=function(){return U.getWeekByDate(this.sCalendarType,this.getFullYear(),this.getMonth(),this.getDate());};
U.prototype.setWeek=function(w){var d=U.getFirstDateOfWeek(this.sCalendarType,w.year||this.getFullYear(),w.week);this.setFullYear(d.year,d.month,d.day);};
U.prototype.getUTCWeek=function(){return U.getWeekByDate(this.sCalendarType,this.getUTCFullYear(),this.getUTCMonth(),this.getUTCDate());};
U.prototype.setUTCWeek=function(w){var d=U.getFirstDateOfWeek(this.sCalendarType,w.year||this.getFullYear(),w.week);this.setUTCFullYear(d.year,d.month,d.day);};
U.prototype.getQuarter=function(){return Math.floor((this.getMonth()/3));};
U.prototype.getUTCQuarter=function(){return Math.floor((this.getUTCMonth()/3));};
U.prototype.getDayPeriod=function(){if(this.getHours()<12){return 0;}else{return 1;}};
U.prototype.getUTCDayPeriod=function(){if(this.getUTCHours()<12){return 0;}else{return 1;}};
U.prototype.getTimezoneShort=function(){if(this.oDate.getTimezoneShort){return this.oDate.getTimezoneShort();}};
U.prototype.getTimezoneLong=function(){if(this.oDate.getTimezoneLong){return this.oDate.getTimezoneLong();}};
var m=7*24*60*60*1000;
U.getWeekByDate=function(C,y,M,d){var l=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale(),b=this.getClass(C),f=g(b,y),D=new b(b.UTC(y,M,d)),w,i,n,o,N;if(l.getRegion()==="US"){w=c(f,D);}else{i=y-1;n=y+1;o=g(b,i);N=g(b,n);if(D>=N){y=n;w=0;}else if(D<f){y=i;w=c(o,D);}else{w=c(f,D);}}return{year:y,week:w};};
U.getFirstDateOfWeek=function(C,y,w){var l=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale(),b=this.getClass(C),f=g(b,y),d=new b(f.valueOf()+w*m);if(l.getRegion()==="US"&&w===0&&f.getUTCFullYear()<y){return{year:y,month:0,day:1};}return{year:d.getUTCFullYear(),month:d.getUTCMonth(),day:d.getUTCDate()};};
function g(b,y){var l=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale(),o=L.getInstance(l),M=o.getMinimalDaysInFirstWeek(),f=o.getFirstDayOfWeek(),F=new b(b.UTC(y,0,1)),d=7;while(F.getUTCDay()!==f){F.setUTCDate(F.getUTCDate()-1);d--;}if(d<M){F.setUTCDate(F.getUTCDate()+7);}return F;}
function c(f,t){return Math.floor((t.valueOf()-f.valueOf())/m);}
var e={};
U.getEraByDate=function(C,y,M,d){var E=a(C),t=new Date(0).setUTCFullYear(y,M,d),o;for(var i=E.length-1;i>=0;i--){o=E[i];if(!o){continue;}if(o._start&&t>=o._startInfo.timestamp){return i;}if(o._end&&t<o._endInfo.timestamp){return i;}}};
U.getCurrentEra=function(C){var n=new Date();return this.getEraByDate(C,n.getFullYear(),n.getMonth(),n.getDate());};
U.getEraStartDate=function(C,E){var b=a(C),o=b[E]||b[0];if(o._start){return o._startInfo;}};
function a(C){var l=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale(),o=L.getInstance(l),E=e[C];if(!E){var E=o.getEraDates(C);if(!E[0]){E[0]={_start:"1-1-1"};}for(var i=0;i<E.length;i++){var b=E[i];if(!b){continue;}if(b._start){b._startInfo=p(b._start);}if(b._end){b._endInfo=p(b._end);}}e[C]=E;}return E;}
function p(d){var P=d.split("-"),y,M,D;if(P[0]==""){y=-parseInt(P[1]);M=parseInt(P[2])-1;D=parseInt(P[3]);}else{y=parseInt(P[0]);M=parseInt(P[1])-1;D=parseInt(P[2]);}return{timestamp:new Date(0).setUTCFullYear(y,M,D),year:y,month:M,day:D};}
return U;});
sap.ui.predefine('sap/ui/core/date/UniversalDateUtils',['sap/ui/core/date/UniversalDate','sap/ui/core/Locale','sap/ui/core/LocaleData','sap/base/assert'],function(U,L,a,b){"use strict";
function c(u){b(u instanceof U,"method accepts only instances of UniversalDate");return u.createDate(u.constructor,[u.getJSDate()]);}
var d={};
d.getRange=function(D,u,B,e){if(e===undefined){e=true;}if(isNaN(D)){throw new TypeError("duration is NaN, but is "+D);}D=Math.trunc(D);var s=d.resetStartTime(B==undefined?null:B),E;if(e){switch(u){case"DAY":break;case"WEEK":s=d.getWeekStartDate(s);break;case"MONTH":s=d.getMonthStartDate(s);break;case"QUARTER":s=d.getQuarterStartDate(s);break;case"YEAR":s=d.getYearStartDate(s);break;default:throw new TypeError("invalid unit "+u);}}switch(u){case"DAY":if(D>0){s.setDate(s.getDate()+1);}E=c(s);D=D==0?1:D;E.setDate(s.getDate()+D);break;case"WEEK":if(D>0){s.setDate(s.getDate()+7);}E=c(s);D=D==0?1:D;E.setDate(s.getDate()+(D*7));break;case"MONTH":if(D>0){s.setMonth(s.getMonth()+1);}E=c(s);D=D==0?1:D;E.setMonth(s.getMonth()+D);break;case"QUARTER":if(D>0){s.setMonth(s.getMonth()+3);}E=c(s);D=D==0?1:D;E.setMonth(s.getMonth()+(D*3));break;case"YEAR":if(D>0){s.setFullYear(s.getFullYear()+1);}E=c(s);D=D==0?1:D;E.setFullYear(s.getFullYear()+D);break;default:throw new TypeError("invalid unit "+u);}if(E.getTime()<s.getTime()){E=[s,s=E][0];}E.setDate(E.getDate()-1);return[d.resetStartTime(s),d.resetEndTime(E)];};
d.getWeekStartDate=function(u,l){var o=l?new L(l):sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale(),e=a.getInstance(o),f=e.getFirstDayOfWeek();u=u?c(u):c(d.createNewUniversalDate());u.setDate(u.getDate()-u.getDay()+f);return d.resetStartTime(u);};
d.getMonthStartDate=function(u){u=u?c(u):c(d.createNewUniversalDate());u.setDate(1);return d.resetStartTime(u);};
d.getQuarterStartDate=function(u){u=u?c(u):c(d.createNewUniversalDate());u.setMonth(3*Math.floor(u.getMonth()/3));u.setDate(1);return d.resetStartTime(u);};
d.getYearStartDate=function(u){u=u?c(u):c(d.createNewUniversalDate());u.setMonth(0);u.setDate(1);return d.resetStartTime(u);};
d.resetStartTime=function(u){u=u?c(u):c(d.createNewUniversalDate());u.setHours(0,0,0,0);return u;};
d.resetEndTime=function(u){u=u?c(u):c(d.createNewUniversalDate());u.setHours(23,59,59,999);return u;};
d.createNewUniversalDate=function(){return new U();};
d.ranges={lastDays:function(D){return d.getRange(-D,"DAY");},yesterday:function(){return d.getRange(-1,"DAY");},today:function(){return d.getRange(0,"DAY");},tomorrow:function(){return d.getRange(1,"DAY");},nextDays:function(D){return d.getRange(D,"DAY");},lastWeeks:function(w){return d.getRange(-w,"WEEK");},lastWeek:function(){return d.getRange(-1,"WEEK");},currentWeek:function(){return d.getRange(0,"WEEK");},nextWeek:function(){return d.getRange(1,"WEEK");},nextWeeks:function(w){return d.getRange(w,"WEEK");},lastMonths:function(m){return d.getRange(-m,"MONTH");},lastMonth:function(){return d.getRange(-1,"MONTH");},currentMonth:function(){return d.getRange(0,"MONTH");},nextMonth:function(){return d.getRange(1,"MONTH");},nextMonths:function(m){return d.getRange(m,"MONTH");},lastQuarters:function(q){return d.getRange(-q,"QUARTER");},lastQuarter:function(){return d.getRange(-1,"QUARTER");},currentQuarter:function(){return d.getRange(0,"QUARTER");},nextQuarter:function(){return d.getRange(1,"QUARTER");},nextQuarters:function(q){return d.getRange(q,"QUARTER");},quarter:function(q){if(q<=2){return d.getRange(q-1,"QUARTER",d.getYearStartDate());}else{var r=d.getRange(q-2,"QUARTER",d.getYearStartDate());var s=r[1];s.setMilliseconds(1000);return d.getRange(0,"QUARTER",s);}},lastYears:function(y){return d.getRange(-y,"YEAR");},lastYear:function(){return d.getRange(-1,"YEAR");},currentYear:function(){return d.getRange(0,"YEAR");},nextYear:function(){return d.getRange(1,"YEAR");},nextYears:function(y){return d.getRange(y,"YEAR");},yearToDate:function(){var t=d.createNewUniversalDate();return[d.getYearStartDate(t),d.resetEndTime(t)];}};return d;});
sap.ui.predefine('sap/ui/core/date/_Calendars',[],function(){"use strict";var r=new Map();var _={get:function(c){if(!r.has(c)){sap.ui.requireSync("sap/ui/core/date/"+c);}return r.get(c);},set:function(c,C){r.set(c,C);}};return _;});
sap.ui.predefine('sap/ui/core/delegate/ItemNavigation',['sap/ui/base/EventProvider',"sap/base/assert","sap/base/Log","sap/ui/dom/containsOrEquals","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/Selectors"],function(E,a,L,c,K,q){"use strict";
var I=E.extend("sap.ui.core.delegate.ItemNavigation",{constructor:function(d,i,n){E.apply(this);this.oDomRef=null;if(d){this.setRootDomRef(d);}this.aItemDomRefs=[];if(i){this.setItemDomRefs(i);}this.iTabIndex=-1;this.iActiveTabIndex=!!n?-1:0;this.iFocusedIndex=-1;this.iSelectedIndex=-1;this.bCycling=true;this.bTableMode=false;this.iPageSize=-1;this._bMouseDownHappened=false;this.oDisabledModifiers={sapend:["alt","shift"],saphome:["alt","shift"]};}});
I.Events={BeforeFocus:"BeforeFocus",AfterFocus:"AfterFocus",BorderReached:"BorderReached",FocusAgain:"FocusAgain",FocusLeave:"FocusLeave"};
I.prototype.setDisabledModifiers=function(d){this.oDisabledModifiers=d;return this;};
I.prototype.getDisabledModifiers=function(d){return this.oDisabledModifiers;};
I.prototype.hasDisabledModifier=function(e){var d=this.oDisabledModifiers[e.type.replace("modifiers","")];if(Array.isArray(d)){for(var i=0;i<d.length;i++){if(e[d[i]+"Key"]){return true;}}}return false;};
I.prototype.setRootDomRef=function(d){this.oDomRef=d;if(!q(this.oDomRef).data("sap.INItem")){if(this.iFocusedIndex>=0){q(this.oDomRef).attr("tabindex",this.iTabIndex);}else{q(this.oDomRef).attr("tabindex",this.iActiveTabIndex);}}q(this.oDomRef).data("sap.INRoot",this);return this;};
I.prototype.getRootDomRef=function(){return this.oDomRef;};
I.prototype.getItemDomRefs=function(){return this.aItemDomRefs;};
I.prototype.setItemDomRefs=function(b){a(typeof b==="object"&&typeof b.length==="number","aItemDomRefs must be an array of DOM elements");this.aItemDomRefs=b;if(this.iFocusedIndex>-1){var d=b.length;if(this.iFocusedIndex>d-1){this.iFocusedIndex=d-1;}var A=document.activeElement;if(A&&A!=this.aItemDomRefs[this.iFocusedIndex]){for(var i=0;i<d;i++){if(A==this.aItemDomRefs[i]){this.iFocusedIndex=i;break;}}}}for(var i=0;i<this.aItemDomRefs.length;i++){if(this.aItemDomRefs[i]){var $=q(this.aItemDomRefs[i]);if(i==this.iFocusedIndex&&!$.data("sap.INRoot")){$.attr("tabindex",this.iActiveTabIndex);}else if($.attr("tabindex")=="0"){$.attr("tabindex",-1);}$.data("sap.INItem",true);$.data("sap.InNavArea",true);if($.data("sap.INRoot")&&i!=this.iFocusedIndex){$.data("sap.INRoot").setNestedItemsTabindex();}}}return this;};
I.prototype.setItemsTabindex=function(){for(var i=0;i<this.aItemDomRefs.length;i++){if(this.aItemDomRefs[i]){var $=q(this.aItemDomRefs[i]);if($.is(":sapFocusable")){if(i==this.iFocusedIndex&&!$.data("sap.INRoot")){$.attr("tabindex",this.iActiveTabIndex);}else{$.attr("tabindex",-1);}}}}return this;};
I.prototype.setNestedItemsTabindex=function(){if(q(this.oDomRef).data("sap.INItem")){for(var i=0;i<this.aItemDomRefs.length;i++){if(this.aItemDomRefs[i]&&q(this.aItemDomRefs[i]).attr("tabindex")=="0"){q(this.aItemDomRefs[i]).attr("tabindex",-1);}}}return this;};
I.prototype.destroy=function(){if(this.oDomRef){q(this.oDomRef).removeData("sap.INRoot");this.oDomRef=null;}if(this.aItemDomRefs){for(var i=0;i<this.aItemDomRefs.length;i++){if(this.aItemDomRefs[i]){q(this.aItemDomRefs[i]).removeData("sap.INItem");q(this.aItemDomRefs[i]).removeData("sap.InNavArea");}}this.aItemDomRefs=null;}this._bItemTabIndex=undefined;this.iFocusedIndex=-1;};
I.prototype.setCycling=function(C){this.bCycling=C;return this;};
I.prototype.setTableMode=function(t,T){this.bTableMode=t;if(this.oConfiguration===undefined){this.oConfiguration=sap.ui.getCore().getConfiguration();}this.bTableList=t?T:false;return this;};
I.prototype.setPageSize=function(p){this.iPageSize=p;return this;};
I.prototype.setSelectedIndex=function(i){this.iSelectedIndex=i;return this;};
I.prototype.setColumns=function(C,n){this.iColumns=C;this.bNoColumnChange=n;return this;};
I.prototype.setHomeEndColumnMode=function(s,C){this._bStayInRow=s;this._bCtrlEnabled=C;return this;};
I.prototype.focusItem=function(i,e){L.info("FocusItem: "+i+" iFocusedIndex: "+this.iFocusedIndex,"focusItem","ItemNavigation");if(i==this.iFocusedIndex&&this.aItemDomRefs[this.iFocusedIndex]==document.activeElement){this.fireEvent(I.Events.FocusAgain,{index:i,event:e});return;}if(!this.aItemDomRefs[i]||!q(this.aItemDomRefs[i]).is(":sapFocusable")){if(this.bTableMode){var C=i%this.iColumns;var o=i;if(e&&e.keyCode==K.ARROW_RIGHT){if(C<this.iColumns-1){i+=this.oConfiguration.getRTL()?-1:1;}}else if(e&&e.keyCode==K.ARROW_LEFT){if(C>1){i-=this.oConfiguration.getRTL()?-1:1;}}else{if(C>1){i-=1;}}if(i!=o){this.focusItem(i,e);}}return;}this.fireEvent(I.Events.BeforeFocus,{index:i,event:e});this.setFocusedIndex(i);this.bISetFocus=true;if(e&&q(this.aItemDomRefs[this.iFocusedIndex]).data("sap.INRoot")){var b=q(this.aItemDomRefs[this.iFocusedIndex]).data("sap.INRoot");b._sFocusEvent=e.type;}L.info("Set Focus on ID: "+this.aItemDomRefs[this.iFocusedIndex].id,"focusItem","ItemNavigation");this.aItemDomRefs[this.iFocusedIndex].focus();this.fireEvent(I.Events.AfterFocus,{index:i,event:e});};
I.prototype.setFocusedIndex=function(i){var $;if(this.aItemDomRefs.length<0){this.iFocusedIndex=-1;return this;}if(i<0){i=0;}if(i>this.aItemDomRefs.length-1){i=this.aItemDomRefs.length-1;}q(this.oDomRef).attr("tabindex",this.iTabIndex);if(this.iFocusedIndex!==-1&&this.aItemDomRefs.length>this.iFocusedIndex){q(this.aItemDomRefs[this.iFocusedIndex]).attr("tabindex",-1);$=q(this.aItemDomRefs[this.iFocusedIndex]);if($.data("sap.INRoot")&&i!=this.iFocusedIndex){q($.data("sap.INRoot").aItemDomRefs[$.data("sap.INRoot").iFocusedIndex]).attr("tabindex",-1);}}this.iFocusedIndex=i;var f=this.aItemDomRefs[this.iFocusedIndex];$=q(this.aItemDomRefs[this.iFocusedIndex]);if(!$.data("sap.INRoot")){q(f).attr("tabindex",this.iActiveTabIndex);}return this;};
I.prototype.getFocusedDomRef=function(){return this.aItemDomRefs[this.iFocusedIndex];};
I.prototype.getFocusedIndex=function(){return this.iFocusedIndex;};
I.prototype.onfocusin=function(e){var s=e.target;var i=0;if(s==this.oDomRef){if(!this._bItemTabIndex){this.setItemsTabindex();this._bItemTabIndex=true;}if(this._bMouseDownHappened){return;}var b;if(q(this.oDomRef).data("sap.INItem")&&this._sFocusEvent&&!q(this.oDomRef).data("sap.InNavArea")){switch(this._sFocusEvent){case"sapnext":b=0;break;case"sapprevious":b=this.aItemDomRefs.length-1;break;default:if(this.iSelectedIndex!=-1){b=this.iSelectedIndex;}else if(this.iFocusedIndex!=-1){b=this.iFocusedIndex;}else{b=0;}break;}this._sFocusEvent=undefined;}else{if(this.iSelectedIndex!=-1){b=this.iSelectedIndex;}else if(this.iFocusedIndex!=-1){b=this.iFocusedIndex;}else{b=0;}}this.focusItem(b,e);if(this.iFocusedIndex==-1){for(i=b+1;i<this.aItemDomRefs.length;i++){this.focusItem(i,e);if(this.iFocusedIndex==i){break;}}if(this.iFocusedIndex==-1&&b>0){for(i=b-1;i>=0;i--){this.focusItem(i,e);if(this.iFocusedIndex==i){break;}}}}e.preventDefault();e.stopPropagation();}else if(!this.bISetFocus){if(this.aItemDomRefs&&e.target!=this.aItemDomRefs[this.iFocusedIndex]){for(i=0;i<this.aItemDomRefs.length;i++){if(e.target==this.aItemDomRefs[i]){this.focusItem(i,e);break;}}}else{this.fireEvent(I.Events.AfterFocus,{index:this.iFocusedIndex,event:e});}}this.bISetFocus=false;};
I.prototype.onsapfocusleave=function(e){if(!e.relatedControlId||!c(this.oDomRef,sap.ui.getCore().byId(e.relatedControlId).getFocusDomRef())){var i;if(this.iSelectedIndex!=-1){i=this.iSelectedIndex;}else if(this.iFocusedIndex!=-1){i=this.iFocusedIndex;}else{i=0;}this.setFocusedIndex(i);var d;if(q(this.oDomRef).data("sap.INItem")){var p;d=q(this.oDomRef);while(!p){d=d.parent();if(d.data("sap.INRoot")){p=d.get(0);}}if(!e.relatedControlId||c(p,sap.ui.getCore().byId(e.relatedControlId).getFocusDomRef())){q(this.aItemDomRefs[this.iFocusedIndex]).attr("tabindex",-1);}}d=q(this.oDomRef);if(d.data("sap.InNavArea")===false){d.data("sap.InNavArea",true);}this.fireEvent(I.Events.FocusLeave,{index:i,event:e});}};
I.prototype.onmousedown=function(e){var s=e.target;var b=function(d,o){var f=false;var C=q(d);while(!C.is(":sapFocusable")&&C.get(0)!=o){C=C.parent();}if(C.get(0)!=o){f=true;}return f;};if(c(this.oDomRef,s)){for(var i=0;i<this.aItemDomRefs.length;i++){var o=this.aItemDomRefs[i];if(c(o,s)){if(!this.bTableMode){this.focusItem(i,e);}else{if(o===s||!b(s,o)){this.focusItem(i,e);}}return;}}if(s==this.oDomRef){this._bMouseDownHappened=true;var t=this;window.setTimeout(function(){t._bMouseDownHappened=false;},20);}}};
I.prototype.onsapnext=function(e){if(!c(this.oDomRef,e.target)){return;}if(q(this.oDomRef).data("sap.InNavArea")){return;}if(this.bTableMode&&this.aItemDomRefs.indexOf(e.target)===-1){return;}var i=this.iFocusedIndex,f=true,b=false;if(i>-1){if(this.bTableMode){var r=this.aItemDomRefs.length/this.iColumns,R=Math.floor(i/this.iColumns),C=i%this.iColumns;if(e.keyCode==K.ARROW_DOWN){if(R<r-1){i+=this.iColumns;}}else{if(C<this.iColumns-1){i+=1;}}}else{do{if(this.iColumns>1&&e.keyCode==K.ARROW_DOWN){if((i+this.iColumns)>=this.aItemDomRefs.length){if(!this.bNoColumnChange){if((i%this.iColumns)<(this.iColumns-1)){i=(i%this.iColumns)+1;}else if(this.bCycling){i=0;}}else{i=this.iFocusedIndex;b=true;}}else{i=i+this.iColumns;}}else{if(i==this.aItemDomRefs.length-1){if(q(this.oDomRef).data("sap.INItem")){return;}else if(this.bCycling){i=0;}else{i=this.iFocusedIndex;b=true;}}else{i++;}}if(i===this.iFocusedIndex){if(f){f=false;}else{throw new Error("ItemNavigation has no visible/existing items and is hence unable to select the next one");}}}while(!this.aItemDomRefs[i]||!q(this.aItemDomRefs[i]).is(":sapFocusable"));}this.focusItem(i,e);if(b){this.fireEvent(I.Events.BorderReached,{index:i,event:e});}e.preventDefault();e.stopPropagation();}};
I.prototype.onsapnextmodifiers=function(e){if(this.hasDisabledModifier(e)){return;}this.onsapnext(e);};
I.prototype.onsapprevious=function(e){if(!c(this.oDomRef,e.target)){return;}if(q(this.oDomRef).data("sap.InNavArea")){return;}if(this.bTableMode&&this.aItemDomRefs.indexOf(e.target)===-1){return;}var i=this.iFocusedIndex,f=true,b=false;var C=0;if(i>-1){if(this.bTableMode){var r=Math.floor(i/this.iColumns);C=i%this.iColumns;if(e.keyCode==K.ARROW_UP){if(r>0){i-=this.iColumns;}}else{if(C>0){i-=1;}}}else{do{if(this.iColumns>1&&e.keyCode==K.ARROW_UP){if((i-this.iColumns)<0){if(!this.bNoColumnChange){C=0;if((i%this.iColumns)>0){C=(i%this.iColumns)-1;}else if(this.bCycling){C=Math.min(this.iColumns-1,this.aItemDomRefs.length-1);}if(i===0&&C===0){i=0;}else{var R=Math.ceil(this.aItemDomRefs.length/this.iColumns);i=C+((R-1)*this.iColumns);if(i>=this.aItemDomRefs.length){i=i-this.iColumns;}}}else{i=this.iFocusedIndex;b=true;}}else{i=i-this.iColumns;}}else{if(i==0){if(q(this.oDomRef).data("sap.INItem")){return;}else if(this.bCycling){i=this.aItemDomRefs.length-1;}else{i=this.iFocusedIndex;b=true;}}else{i--;}}if(i==this.iFocusedIndex){if(f){f=false;}else{throw new Error("ItemNavigation has no visible/existing items and is hence unable to select the previous one");}}}while(!this.aItemDomRefs[i]||!q(this.aItemDomRefs[i]).is(":sapFocusable"));}this.focusItem(i,e);if(b){this.fireEvent(I.Events.BorderReached,{index:i,event:e});}e.preventDefault();e.stopPropagation();}};
I.prototype.onsappreviousmodifiers=function(e){if(this.hasDisabledModifier(e)){return;}this.onsapprevious(e);};
I.prototype.onsappageup=function(e){if(!c(this.oDomRef,e.target)){return;}if(this.bTableMode&&this.aItemDomRefs.indexOf(e.target)===-1){return;}var i=0;var b=false;if(this.iPageSize>0){i=this.iFocusedIndex;if(i>-1){i=i-this.iPageSize;while(i>0&&!q(this.aItemDomRefs[i]).is(":sapFocusable")){i--;}if(i<0){if(!this.bNoColumnChange){i=0;}else{i=this.iFocusedIndex;b=true;}}this.focusItem(i,e);}}else if(this.bTableMode){i=this.iFocusedIndex%this.iColumns;this.focusItem(i,e);}if(b){this.fireEvent(I.Events.BorderReached,{index:i,event:e});}e.preventDefault();e.stopPropagation();};
I.prototype.onsappagedown=function(e){if(!c(this.oDomRef,e.target)){return;}if(this.bTableMode&&this.aItemDomRefs.indexOf(e.target)===-1){return;}var i=0;var b=false;if(this.iPageSize>0){i=this.iFocusedIndex;if(i>-1){i=i+this.iPageSize;while(i<this.aItemDomRefs.length-1&&!q(this.aItemDomRefs[i]).is(":sapFocusable")){i++;}if(i>this.aItemDomRefs.length-1){if(!this.bNoColumnChange){i=this.aItemDomRefs.length-1;}else{i=this.iFocusedIndex;b=true;}}this.focusItem(i,e);}}else if(this.bTableMode){var r=this.aItemDomRefs.length/this.iColumns,C=this.iFocusedIndex%this.iColumns;i=(r-1)*this.iColumns+C;this.focusItem(i,e);}if(b){this.fireEvent(I.Events.BorderReached,{index:i,event:e});}e.preventDefault();e.stopPropagation();};
I.prototype.onsaphome=function(e){if(!c(this.oDomRef,e.target)){return;}if(this.bTableMode&&this.aItemDomRefs.indexOf(e.target)===-1){return;}var i=0;var r=0;if(this.bTableMode){if(!this.bTableList&&!(e.metaKey||e.ctrlKey)){r=Math.floor(this.iFocusedIndex/this.iColumns);i=r*this.iColumns;}}else{if(!!(e.metaKey||e.ctrlKey)&&!this._bCtrlEnabled){return;}if(this._bStayInRow&&!(this._bCtrlEnabled&&(e.metaKey||e.ctrlKey))&&this.iColumns>0){r=Math.floor(this.iFocusedIndex/this.iColumns);i=r*this.iColumns;}else{while(!this.aItemDomRefs[i]||!q(this.aItemDomRefs[i]).is(":sapFocusable")){i++;if(i==this.aItemDomRefs.length){return;}}}}this.focusItem(i,e);e.preventDefault();e.stopPropagation();};
I.prototype.onsaphomemodifiers=function(e){if(this.hasDisabledModifier(e)){return;}this.onsaphome(e);};
I.prototype.onsapend=function(e){if(!c(this.oDomRef,e.target)){return;}if(this.bTableMode&&this.aItemDomRefs.indexOf(e.target)===-1){return;}var i=this.aItemDomRefs.length-1;var r=0;if(this.bTableMode){if(!this.bTableList&&!(e.metaKey||e.ctrlKey)){r=Math.floor(this.iFocusedIndex/this.iColumns);i=r*this.iColumns+this.iColumns-1;}}else{if(!!(e.metaKey||e.ctrlKey)&&!this._bCtrlEnabled){return;}if(this._bStayInRow&&!(this._bCtrlEnabled&&(e.metaKey||e.ctrlKey))&&this.iColumns>0){r=Math.floor(this.iFocusedIndex/this.iColumns);i=(r+1)*this.iColumns-1;if(i>=this.aItemDomRefs.length){i=this.aItemDomRefs.length-1;}}else{while(!this.aItemDomRefs[i]||!q(this.aItemDomRefs[i]).is(":sapFocusable")){i--;if(i<0){return;}}}}this.focusItem(i,e);e.preventDefault();e.stopPropagation();};
I.prototype.onsapendmodifiers=function(e){if(this.hasDisabledModifier(e)){return;}this.onsapend(e);};
I.prototype.setTabIndex0=function(){this.iTabIndex=0;this.iActiveTabIndex=0;};
I.prototype.onkeyup=function(e){if(e.keyCode==K.F2){var d=q(this.oDomRef);if(d.data("sap.InNavArea")){d.data("sap.InNavArea",false);}else if(d.data("sap.InNavArea")===false){d.data("sap.InNavArea",true);}e.preventDefault();e.stopPropagation();}};
return I;});
sap.ui.predefine('sap/ui/core/delegate/ScrollEnablement',['sap/ui/Device','sap/ui/base/Object','sap/ui/core/IntervalTrigger','sap/ui/core/ResizeHandler',"sap/ui/thirdparty/jquery","sap/ui/events/KeyCodes"],function(D,B,I,R,q,K){"use strict";
var S=B.extend("sap.ui.core.delegate.ScrollEnablement",{
constructor:function(c,s,C){B.apply(this);this._oControl=c;this._oControl.addDelegate(this);this._sContentId=s;this._sContainerId=C.scrollContainerId;this._bHorizontal=!!C.horizontal;this._bVertical=!!C.vertical;this._scrollX=0;this._scrollY=0;this._scrollCoef=0.9;this._iLastMaxScrollTop=0;i(this);if(this._init){this._init.apply(this,arguments);}},
setHorizontal:function(h){this._bHorizontal=!!h;this._setOverflow&&this._setOverflow();},
setVertical:function(v){this._bVertical=!!v;this._setOverflow&&this._setOverflow();},
getHorizontal:function(){return this._bHorizontal;},
getVertical:function(){return this._bVertical;},
setBounce:function(b){},
setPullDown:function(c){this._oPullDown=c;return this;},
setGrowingList:function(s,a,o){this._fnScrollLoadCallback=s;this._sScrollLoadDirection=a;this.onOverflowChange(o);return this;},
onOverflowChange:function(c){this._fnOverflowChangeCallback=c;if(!this._fnOverflowChangeCallback){this._deregisterOverflowMonitor();}},
setIconTabBar:function(o,s,f){this._oIconTabBar=o;this._fnScrollEndCallback=q.proxy(s,o);this._fnScrollStartCallback=q.proxy(f,o);return this;},
scrollTo:function(x,y,t,s){this._scrollX=x;this._scrollY=y;this._scrollTo(x,y,t,s);return this;},
getChildPosition:function(e){var E=e instanceof q?e:q(e),o=E.position(),O=E.offsetParent(),a;while(!O.is(this._$Container)){a=O.position();o.top+=a.top;o.left+=a.left;O=O.offsetParent();}return o;},
scrollToElement:function(e,t,o){o=o||[0,0];if(!this._$Container[0].contains(e)||e.style.display==="none"||e.offsetParent.nodeName.toUpperCase()==="HTML"){return this;}var E=q(e),s=this.getChildPosition(E),l=this.getScrollLeft()+s.left+o[0],T=this.getScrollTop()+s.top+o[1];if(this._bFlipX){l=this.getScrollLeft()-(s.left-this._$Container.width())-E.width();}this._scrollTo(l,T,t);return this;},
destroy:function(){if(this._exit){this._exit();}if(this._oControl){this._oControl.removeDelegate(this);this._oControl=undefined;}},
refresh:function(){if(this._refresh){this._refresh();}},
_useDefaultScroll:function(t){return t.isContentEditable;},
onkeydown:function(e){if(this._useDefaultScroll(e.target)){return;}var c=this._$Container[0];if(e.altKey&&this.getHorizontal()){switch(e.keyCode){case K.PAGE_UP:this._customScrollTo(this._scrollX-c.clientWidth,this._scrollY,e);break;case K.PAGE_DOWN:this._customScrollTo(this._scrollX+c.clientWidth,this._scrollY,e);break;}}if(e.ctrlKey){switch(e.keyCode){case K.ARROW_UP:if(this.getVertical()){this._customScrollTo(this._scrollX,this._scrollY-c.clientHeight*this._scrollCoef,e);}break;case K.ARROW_DOWN:if(this.getVertical()){this._customScrollTo(this._scrollX,this._scrollY+c.clientHeight*this._scrollCoef,e);}break;case K.ARROW_LEFT:if(this.getHorizontal()){this._customScrollTo(this._scrollX-c.clientWidth,this._scrollY,e);}break;case K.ARROW_RIGHT:if(this.getHorizontal()){this._customScrollTo(this._scrollX+c.clientWidth,this._scrollY,e);}break;case K.HOME:if(this.getHorizontal()){this._customScrollTo(0,this._scrollY,e);}if(this.getVertical()){this._customScrollTo(this._scrollX,0,e);}break;case K.END:var l=c.scrollWidth-c.clientWidth;var t=c.scrollHeight-c.clientHeight;if(!this.getHorizontal()){t=this._scrollY;}if(!this.getVertical()){l=this._scrollX;}this._customScrollTo(l,t,e);break;}}},
_customScrollTo:function(l,t,e){var N=e.target.nodeName;if(N!="INPUT"&&N!="TEXTAREA"){e.preventDefault();e.setMarked();this._scrollTo(l,t);}}
});
var n={getScrollTop:function(){return this._scrollY||0;},getScrollLeft:function(){return this._scrollX||0;},getScrollHeight:function(){var c=this._$Container;return(c&&c[0])?c[0].scrollHeight:0;},getMaxScrollTop:function(){var c=this._$Container;return(c&&c[0])?c[0].scrollHeight-c[0].clientHeight:-1;},getContainerDomRef:function(){return this._$Container&&this._$Container[0];},_cleanup:function(){if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}this._deregisterOverflowMonitor();},_setOverflow:function(){var c=this._$Container;if(!c||!c[0]){return;}if(D.os.ios){c.css("overflow-x",this._bHorizontal&&!this._bDragScroll?"scroll":"hidden").css("overflow-y",this._bVertical&&!this._bDragScroll?"scroll":"hidden").css("-webkit-overflow-scrolling","touch");}else{c.css("overflow-x",this._bHorizontal&&!this._bDragScroll?"auto":"hidden").css("overflow-y",this._bVertical&&!this._bDragScroll?"auto":"hidden");}},_refresh:function(){var c=this._$Container;if(!(c&&c.length)){return;}if(this._oPullDown&&this._oPullDown._bTouchMode){var d=this._oPullDown.getDomRef();if(d){d.style.marginTop=this._oPullDown._iState==2?"":"-"+d.offsetHeight+"px";}}if(c.scrollTop()!=this._scrollY){c.scrollTop(this._scrollY);}if(!(this._oPullDown&&this._oPullDown._bTouchMode)&&!this._fnScrollLoadCallback&&!D.browser.msie){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}},_onScroll:function(){var c=this._$Container,s=c.scrollTop(),v=s-this._scrollY;this._scrollX=c.scrollLeft();this._scrollY=s;if(this._fnScrollLoadCallback){if(this._sScrollLoadDirection=="Upwards"){if(v<0&&s<10){this._fnScrollLoadCallback();}}else if(v>=0&&c[0].scrollHeight-s-c[0].clientHeight<100){this._fnScrollLoadCallback();}}if(this._oIconTabBar&&this._fnScrollEndCallback){this._fnScrollEndCallback();}},_onStart:function(e){var c=this._$Container[0];if(!c){return;}this._bDoDrag=this._bDragScroll;var p=e.touches?e.touches[0]:e;this._iX=p.pageX;this._iY=p.pageY;this._bPullDown=false;this._iDirection="";},_onTouchMove:function(e){var c=this._$Container[0];var p=e.touches?e.touches[0]:e;var d=p.pageX-this._iX;var a=p.pageY-this._iY;if(this._iDirection==""){if(d!=0||a!=0){this._iDirection=Math.abs(a)>Math.abs(d)?"v":"h";}if(this._oPullDown&&this._oPullDown._bTouchMode&&this._iDirection=="v"&&c.scrollTop<=1){if(a>Math.abs(d)){this._bPullDown=true;}}}if(this._bPullDown===true){var b=this._oPullDown.getDomRef();var t=e.touches[0].pageY-this._iY-b.offsetHeight;if(t>20){t=20;}b.style.marginTop=t+"px";this._oPullDown.doPull(t);e.preventDefault();this._bDoDrag=false;}if(this._bDoDrag){var s=c.scrollLeft,f=c.scrollTop;if(this._bHorizontal){if(this._bFlipX){c.scrollLeft=s-this._iX+p.pageX;}else{c.scrollLeft=s+this._iX-p.pageX;}}if(this._bVertical){c.scrollTop=f+this._iY-p.pageY;}if((c.scrollLeft!=s)||(c.scrollTop!=f)){e.setMarked&&e.setMarked();e.preventDefault();}this._iX=p.pageX;this._iY=p.pageY;return;}},_onEnd:function(e){if(this._oPullDown&&this._oPullDown._bTouchMode){this._oPullDown.doScrollEnd();this._refresh();}if(this._bDragScroll&&this._iDirection){e.setMarked&&e.setMarked();}},_onMouseDown:function(e){if(this._bDragScroll&&e.button==0){this._bScrolling=true;this._onStart(e);}},_onMouseMove:function(E){if(this._bScrolling){var e=E.originalEvent||E;var b=e.buttons||e.which;if(b==1||E.pressure){var c=this._$Container[0];if(this._bHorizontal){if(this._bFlipX){c.scrollLeft=c.scrollLeft-this._iX+E.pageX;}else{c.scrollLeft=c.scrollLeft+this._iX-E.pageX;}}if(this._bVertical){c.scrollTop=c.scrollTop+this._iY-E.pageY;}this._iX=E.pageX;this._iY=E.pageY;}}},_onMouseUp:function(){if(this._bScrolling){this._bScrolling=false;this._onEnd();}},onBeforeRendering:function(){if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}this._deregisterOverflowMonitor();var c=this._$Container;if(c){if(c.height()>0){this._scrollX=c.scrollLeft();this._scrollY=c.scrollTop();}c.off();}},_checkOverflowChange:function(e){var m=this.getMaxScrollTop(),o=m>0&&this._iLastMaxScrollTop===0,u=m===0&&this._iLastMaxScrollTop>0,O=o||u;if(O){this._fnOverflowChangeCallback(o,m);}this._iLastMaxScrollTop=m;},_registerOverflowMonitor:function(){this._fnOverflowChangeCallback&&I.addListener(this._checkOverflowChange,this);},_deregisterOverflowMonitor:function(){I.removeListener(this._checkOverflowChange,this);},onAfterRendering:function(){var c=this._$Container=this._sContainerId?q(document.getElementById(this._sContainerId)):q(document.getElementById(this._sContentId)).parent();var _=q.proxy(this._refresh,this);var e=c.is(":visible");this._setOverflow();if(this._scrollX!==0||this._scrollY!==0){this._scrollTo(this._scrollX,this._scrollY);}this._refresh();if(!e||D.browser.msie||this._oPullDown||this._fnScrollLoadCallback){this._sResizeListenerId=R.register(c[0],_);}if(this._fnOverflowChangeCallback){this._iOverflowTimer&&window.cancelAnimationFrame(this._iOverflowTimer);this._iOverflowTimer=window.requestAnimationFrame(this._registerOverflowMonitor.bind(this));}c.on("scroll",this._onScroll.bind(this));var C=c[0];function a(E,l){E.split(" ").forEach(function(s){C&&C.addEventListener(s,l);});}function o(E){return E.pointerType=="touch"?this._onStart(E):this._onMouseDown(E);}function b(E){return E.pointerType=="touch"?this._onTouchMove(E):this._onMouseMove(E);}function d(E){return E.pointerType=="touch"?this._onEnd(E):this._onMouseUp(E);}if(D.support.pointer&&D.system.desktop){if(this._bDragScroll){a("pointerdown",o.bind(this));a("pointermove",b.bind(this));a("pointerup pointercancel pointerleave",d.bind(this));}}else if(D.support.touch){if(this._bDragScroll||this._oPullDown&&this._oPullDown._bTouchMode){c.on("touchcancel touchend",this._onEnd.bind(this)).on("touchstart",this._onStart.bind(this)).on("touchmove",this._onTouchMove.bind(this));}}else if(this._bDragScroll){c.on("mouseup mouseleave",this._onMouseUp.bind(this)).on("mousedown",this._onMouseDown.bind(this)).on("mousemove",this._onMouseMove.bind(this));}},_readActualScrollPosition:function(){if(this._$Container.width()>0){this._scrollX=this._$Container.scrollLeft();}if(this._$Container.height()>0){this._scrollY=this._$Container.scrollTop();}},_scrollTo:function(x,y,t,s){if(this._$Container.length>0){if(t>0){this._$Container.finish().animate({scrollTop:y,scrollLeft:x},t,q.proxy(function(){this._readActualScrollPosition();s&&s();},this));}else{this._$Container.scrollTop(y);this._$Container.scrollLeft(x);this._readActualScrollPosition();s&&s();}}}};
function i(s){var d={_init:function(c,a,C){if(q.event&&q.event.special&&q.event.special.swipe&&q.event.special.swipe.scrollSupressionThreshold<120){q.event.special.swipe.scrollSupressionThreshold=120;}Object.assign(this,n);if(C.nonTouchScrolling===true){this._bDragScroll=true;}if(sap.ui.getCore().getConfiguration().getRTL()){this._scrollX=9999;if(D.browser.msie||D.browser.edge){this._bFlipX=true;}}},_exit:function(){if(this._cleanup){this._cleanup();}}};Object.assign(s,d);}
return S;});
sap.ui.predefine('sap/ui/core/dnd/DragAndDrop',["sap/ui/Device","../UIArea",'sap/base/util/extend',"sap/ui/thirdparty/jquery","sap/ui/dom/jquery/control"],function(D,U,e,q){"use strict";var a={},d=null,o=null,v=null,V=[],b=[],c=null,$,f,g,C,t,l={},h;
function j(i,S){if(!i){return;}if(i.addStyleClass){i.addStyleClass(S);}else{i.$().addClass(S);}}
function r(i,S){if(!i){return;}if(i.removeStyleClass){i.removeStyleClass(S);}else{i.$().removeClass(S);}}
function k(i,F){var G=q(i.target).control(0,true);if(!G){return;}var N=q.Event(null,i);N.type=F;G.getUIArea()._handleEvent(N);}
function m(i){return!i.disabled&&/^(input|textarea)$/.test(i.localName);}
function s(d,i){if(D.browser.msie||!d||!d.getDragGhost){return;}var F=d.getDragGhost();if(!F){return;}if(!g){g=q('<div class="sapUiDnDGhostContainer"></div>');q(document.body).append(g);}g.append(F);window.setTimeout(function(){g.empty();},0);var O=i.originalEvent;O.dataTransfer.setDragImage(F,O.offsetX,O.offsetY);}
function n(i){var F={},I,G=i.originalEvent.dataTransfer,H=function(T,J){if(G&&T=="text"||(D.browser!="msie"&&D.browser!="edge")){G.setData(T,J);}};return{setData:function(K,J){J=""+J;F[K]=J;H(K,J);},getData:function(K){return F[K];},setTextData:function(J){J=""+J;F["text/plain"]=J;F["text"]=J;H("text/plain",J);H("text",J);},getTextData:function(){return F["text/plain"];},setComplexData:function(K,J){F[K]=J;},getComplexData:function(K){return F[K];},getIndicator:function(){return $&&$[0];},setIndicatorConfig:function(J){I=J;},getIndicatorConfig:function(J){return I;},getDragControl:function(){return d;},getDropControl:function(){return v;},setDropControl:function(J){v=J;},getDropInfo:function(){return b[0]||null;},getDropPosition:function(){return C;}};}
function p(i){d=o=v=c=null;C="";V=[];b=[];}
function u(){if($){return $;}if(!D.browser.msie){f=q("<div class='sapUiDnDIndicatorWrapper'></div>");}$=q("<div class='sapUiDnDIndicator'></div>");if(!f){q(sap.ui.getCore().getStaticAreaRef()).append($);}else{q(sap.ui.getCore().getStaticAreaRef()).append(f);$.appendTo(f);}return $;}
function w(){if($){$.removeAttr("style").hide();l={};}}
function x(i,F,G,H){if(!F){return;}var I=i.dragSession&&i.dragSession.getIndicatorConfig(),J=F.getBoundingClientRect(),P=window.pageYOffset,K=window.pageXOffset,L=u(),R,S={},M={top:J.top+P,bottom:J.bottom+P,left:J.left+K,right:J.right+K,width:J.width,height:J.height};if(!G||G=="On"){R="On";H="";}else if(H=="Horizontal"){var N=i.pageX-M.left;S.height=M.height;S.top=M.top;if(G=="Between"){S.width="";if(N<M.width*0.5){R="Before";S.left=M.left;}else{R="After";S.left=M.right;}}else if(G=="OnOrBetween"){if(N<M.width*0.25){R="Before";S.left=M.left;S.width="";}else if(N>M.width*0.75){R="After";S.left=M.right;S.width="";}else{R="On";}}if(R!="On"&&sap.ui.getCore().getConfiguration().getRTL()){R=(R=="After")?"Before":"After";}}else{var O=i.pageY-M.top;S.width=M.width;S.left=M.left;if(G=="Between"){S.height="";if(O<M.height*0.5){R="Before";S.top=M.top;}else{R="After";S.top=M.bottom;}}else if(G=="OnOrBetween"){if(O<M.height*0.25){R="Before";S.top=M.top;S.height="";}else if(O>M.height*0.75){R="After";S.top=M.bottom;S.height="";}else{R="On";}}}if(I&&I.display=="none"){return R;}if(R=="On"){S.top=M.top;S.left=M.left;S.width=M.width;S.height=M.height;G=R;}else{G="Between";}if(l.top!=S.top||l.left!=S.left||l.width!=S.width||l.height!=S.height){L.attr("data-drop-layout",H);L.attr("data-drop-position",G);L.css(e(S,I)).show();l=S;}return R;}
function y(i){var P=i.getParent(),S=(i.getDragDropConfig)?i.getDragDropConfig():[],F=(P&&P.getDragDropConfig)?P.getDragDropConfig():[];return S.concat(F);}
function z(d){var i=y(d);return i.filter(function(F){return F.isDraggable(d);});}
function A(o,i,F){var G=y(o);i=i||[];return G.filter(function(H){return!H.isA("sap.ui.core.dnd.IDragInfo");}).concat(i).filter(function(H){if(!H.isDroppable(o,F)){return false;}var I=H.getGroupName();if(!I){return true;}return i.some(function(J){return J.getGroupName()==I;});});}
function B(i,F){i.preventDefault();var G=F.getDropEffect().toLowerCase();i.originalEvent.dataTransfer.dropEffect=G;}
function E(i,F,v){var T=F.getTargetAggregation();if(!T){return x(i,v.getDomRef());}var G;if(i.getMark("DragWithin")==T){G=v.getDomRefForSetting(T);}G=G||v.getDomRef();return x(i,G,F.getDropPosition(true),F.getDropLayout(true));}
a.preprocessEvent=function(i){if(c&&i.type.indexOf("dr")==0){i.dragSession=c;}var F="onbefore"+i.type;if(a[F]){a[F](i);}};
a.postprocessEvent=function(i){var F="onafter"+i.type;if(a[F]){a[F](i);}};
a.onbeforemousedown=function(i){if((D.browser.msie||D.browser.firefox||D.browser.edge)&&m(i.target)){h=q(i.target).closest("[data-sap-ui-draggable=true]").prop("draggable",false)[0];}};
a.onbeforemouseup=function(i){if(h){h.draggable=true;h=null;}};
a.onbeforedragstart=function(i){if(!i.target.draggable){return;}if(m(document.activeElement)){i.target.getAttribute("data-sap-ui-draggable")&&i.preventDefault();return;}d=q(i.target).control(0,true);if(!d){return;}V=z(d);if(!V.length){return;}if(D.browser.firefox&&i.originalEvent.dataTransfer.types.length===0){i.originalEvent.dataTransfer.setData("ui5/dummyDataForFirefox","data");}i.dragSession=c=n(i);};
a.onafterdragstart=function(i){if(!V.length||i.isDefaultPrevented()){p();return;}V=i.isMarked("NonDraggable")?[]:V.filter(function(F){return F.fireDragStart(i);});if(!V.length){i.preventDefault();p();return;}s(d,i);j(d,"sapUiDnDDragging");q("html").addClass("sapUiDnDNoScrolling");};
a.onbeforedragenter=function(F){var G=q(F.target).control(0,true);if(G&&o===G){F.setMark("DragWithin","SameControl");}else{t=Date.now();o=G;}var H=[];v=G;for(var i=0;i<20&&v;i++,v=v.getParent()){H=A(v,V,F);if(H.length){break;}}if(F.getMark("DragWithin")!="SameControl"){b=H;if(c){c.setIndicatorConfig(null);}}if(!b.length){v=null;}else if(!c){F.dragSession=c=n(F);}};
a.onafterdragenter=function(i){if(!v||i.isMarked("NonDroppable")){b=[];}else if(i.getMark("DragWithin")!="SameControl"){b=b.filter(function(G){return G.fireDragEnter(i);});}var F=b[0];if(!F||F.getDropEffect()=="None"){w();C="";}else{B(i,F);C=E(i,F,v);}};
a.onbeforedragover=function(i){var F=Date.now();if(F-t>=1000){k(i,"longdragover");t=F;}};
a.onafterdragover=function(i){var F=b[0];if(!F||F.getDropEffect()=="None"){return;}b.forEach(function(G){G.fireDragOver(i);});B(i,F);if(F&&F.getDropPosition(true)=="On"){return;}C=E(i,F,v);};
a.onbeforedrop=function(i){if(b.length){i.preventDefault();}};
a.onafterdrop=function(i){b.forEach(function(F){F.fireDrop(i);});this.iDragEndTimer=window.requestAnimationFrame(this.onafterdragend.bind(this,i));};
a.onafterdragend=function(i){this.iDragEndTimer=window.cancelAnimationFrame(this.iDragEndTimer);V.forEach(function(F){F.fireDragEnd(i);});r(d,"sapUiDnDDragging");q("html").removeClass("sapUiDnDNoScrolling");w();p();};
U.addEventPreprocessor(a.preprocessEvent);U.addEventPostprocessor(a.postprocessEvent);return a;},true);
sap.ui.predefine('sap/ui/core/dnd/DragDropBase',['../Element','../library','sap/base/Log','./DragAndDrop'],function(E,l,L){"use strict";
var D=E.extend("sap.ui.core.dnd.DragDropBase",{metadata:{"abstract":true,library:"sap.ui.core",properties:{groupName:{type:"string",defaultValue:null,invalidate:false},enabled:{type:"boolean",defaultValue:true}}}});
D.prototype.bIgnoreMetadataCheck=false;
D.prototype.isDraggable=function(c){return false;};
D.prototype.isDroppable=function(c,e){return false;};
D.prototype.checkMetadata=function(c,a,r){if(this.bIgnoreMetadataCheck){return true;}var m=c.getMetadata().getDragDropInfo(a);if(!m[r]){L.warning((a?a+" aggregation of ":"")+c+" is not configured to be "+r);return false;}return true;};
D.prototype.setEnabled=function(e){return this.setProperty("enabled",e,!this.isA("sap.ui.core.dnd.IDragInfo"));};
D.prototype.setProperty=function(p,v,s){s=s||(this.getMetadata().getProperty(p).appData||{}).invalidate===false;return E.prototype.setProperty.call(this,p,v,s);};
return D;});
sap.ui.predefine('sap/ui/core/dnd/DragDropInfo',["./DragInfo","./DropInfo","sap/ui/Device","sap/base/Log"],function(D,a,b,L){"use strict";
var c=a.extend("sap.ui.core.dnd.DragDropInfo",{metadata:{library:"sap.ui.core",interfaces:["sap.ui.core.dnd.IDragInfo","sap.ui.core.dnd.IDropInfo"],properties:{sourceAggregation:{type:"string",defaultValue:null}},associations:{targetElement:{type:"sap.ui.core.Element",multiple:false}},events:{dragStart:{allowPreventDefault:true},dragEnd:{}}}});
c.prototype.isDraggable=D.prototype.isDraggable;c.prototype.fireDragEnd=D.prototype.fireDragEnd;
c.prototype.fireDragStart=function(e){if(b.browser.msie){e.originalEvent.dataTransfer.effectAllowed=this.getDropEffect().toLowerCase();}return D.prototype.fireDragStart.apply(this,arguments);};
c.prototype.getDropTarget=function(){var t=this.getTargetElement();if(t){return sap.ui.getCore().byId(t);}return this.getParent();};
c.prototype.setGroupName=function(){L.error("groupName property must not be set on "+this);return this;};
return c;});
sap.ui.predefine('sap/ui/core/dnd/DragInfo',["./DragDropBase"],function(D){"use strict";
var a=D.extend("sap.ui.core.dnd.DragInfo",{metadata:{library:"sap.ui.core",interfaces:["sap.ui.core.dnd.IDragInfo"],properties:{sourceAggregation:{type:"string",defaultValue:null}},events:{dragStart:{allowPreventDefault:true},dragEnd:{}}}});
a.prototype.isDraggable=function(c){if(!this.getEnabled()){return false;}var d=this.getParent();if(!d){return false;}var s=this.getSourceAggregation();if(!this.checkMetadata(d,s,"draggable")){return false;}if(d===c&&!s){return true;}if(c.getParent()===d&&s===c.sParentAggregationName){return true;}return false;};
a.prototype.fireDragStart=function(e){if(!e||!e.dragSession){return;}var d=e.dragSession;return this.fireEvent("dragStart",{dragSession:d,browserEvent:e.originalEvent,target:d.getDragControl()},true);};
a.prototype.fireDragEnd=function(e){if(!e||!e.dragSession){return;}var d=e.dragSession;return this.fireEvent("dragEnd",{dragSession:d,browserEvent:e.originalEvent,target:d.getDragControl()});};
return a;});
sap.ui.predefine('sap/ui/core/dnd/DropInfo',["./DragDropBase"],function(D){"use strict";
var a=D.extend("sap.ui.core.dnd.DropInfo",{metadata:{library:"sap.ui.core",interfaces:["sap.ui.core.dnd.IDropInfo"],properties:{targetAggregation:{type:"string",defaultValue:null,invalidate:false},dropEffect:{type:"sap.ui.core.dnd.DropEffect",defaultValue:"Move",invalidate:false},dropPosition:{type:"sap.ui.core.dnd.DropPosition",defaultValue:"On",invalidate:false},dropLayout:{type:"sap.ui.core.dnd.DropLayout",defaultValue:"Default",invalidate:false}},events:{dragEnter:{allowPreventDefault:true},dragOver:{},drop:{}}}});
a.prototype.getDropTarget=function(){return this.getParent();};
a.prototype.isDroppable=function(c,e){this.sTemporaryDropPosition="";if(!this.getEnabled()){return false;}var d=this.getDropTarget();if(!d){return false;}var t=this.getTargetAggregation();if(!this.checkMetadata(d,t,"droppable")){return false;}var t=this.getTargetAggregation();if(d===c&&!t){return true;}if(c.getParent()===d&&t===c.sParentAggregationName){return true;}if(e&&t&&d===c){var A=c.getDomRefForSetting(t);if(A&&A!=e.target&&A.contains(e.target)){e.setMark("DragWithin",t);this.sTemporaryDropPosition="On";return true;}}return false;};
a.prototype.getDropPosition=function(c){if(c&&this.sTemporaryDropPosition){return this.sTemporaryDropPosition;}return this.getProperty("dropPosition");};
a.prototype.getDropLayout=function(d){var s=this.getProperty("dropLayout");if(!d||s!="Default"){return s;}return this.getDropTarget().getMetadata().getDragDropInfo(this.getTargetAggregation()).layout;};
a.prototype.fireDragEnter=function(e){if(!e||!e.dragSession){return;}var d=e.dragSession;return this.fireEvent("dragEnter",{dragSession:e.dragSession,browserEvent:e.originalEvent,target:d.getDropControl()},true);};
a.prototype.fireDragOver=function(e){if(!e||!e.dragSession){return;}var d=e.dragSession;return this.fireEvent("dragOver",{dragSession:e.dragSession,browserEvent:e.originalEvent,target:d.getDropControl(),dropPosition:d.getDropPosition()});};
a.prototype.fireDrop=function(e){if(!e||!e.dragSession){return;}var d=e.dragSession;this.fireEvent("drop",{dragSession:e.dragSession,browserEvent:e.originalEvent,dropPosition:d.getDropPosition(),draggedControl:d.getDragControl(),droppedControl:d.getDropControl()});};
return a;});
sap.ui.predefine('sap/ui/core/format/DateFormat',['sap/ui/core/CalendarType','sap/ui/core/Locale','sap/ui/core/LocaleData','sap/ui/core/date/UniversalDate',"sap/base/util/deepEqual","sap/base/strings/formatMessage","sap/base/Log","sap/base/util/extend"],function(C,L,a,U,d,f,b,e){"use strict";var D=function(){throw new Error();};var c={};D.oDateInfo={oDefaultFormatOptions:{style:"medium",relativeScale:"day",relativeStyle:"wide"},aFallbackFormatOptions:[{style:"short"},{style:"medium"},{pattern:"yyyy-MM-dd"},{pattern:"yyyyMMdd",strictParsing:true}],bShortFallbackFormatOptions:true,bPatternFallbackWithoutDelimiter:true,getPattern:function(o,s,i){return o.getDatePattern(s,i);},oRequiredParts:{"text":true,"year":true,"weekYear":true,"month":true,"day":true},aRelativeScales:["year","month","week","day"],aRelativeParseScales:["year","quarter","month","week","day","hour","minute","second"],aIntervalCompareFields:["Era","FullYear","Quarter","Month","Week","Date"]};D.oDateTimeInfo={oDefaultFormatOptions:{style:"medium",relativeScale:"auto",relativeStyle:"wide"},aFallbackFormatOptions:[{style:"short"},{style:"medium"},{pattern:"yyyy-MM-dd'T'HH:mm:ss"},{pattern:"yyyyMMdd HHmmss"}],getPattern:function(o,s,i){var S=s.indexOf("/");if(S>0){return o.getCombinedDateTimePattern(s.substr(0,S),s.substr(S+1),i);}else{return o.getCombinedDateTimePattern(s,s,i);}},oRequiredParts:{"text":true,"year":true,"weekYear":true,"month":true,"day":true,"hour0_23":true,"hour1_24":true,"hour0_11":true,"hour1_12":true},aRelativeScales:["year","month","week","day","hour","minute","second"],aRelativeParseScales:["year","quarter","month","week","day","hour","minute","second"],aIntervalCompareFields:["Era","FullYear","Quarter","Month","Week","Date","DayPeriod","Hours","Minutes","Seconds"]};D.oTimeInfo={oDefaultFormatOptions:{style:"medium",relativeScale:"auto",relativeStyle:"wide"},aFallbackFormatOptions:[{style:"short"},{style:"medium"},{pattern:"HH:mm:ss"},{pattern:"HHmmss"}],getPattern:function(o,s,i){return o.getTimePattern(s,i);},oRequiredParts:{"text":true,"hour0_23":true,"hour1_24":true,"hour0_11":true,"hour1_12":true},aRelativeScales:["hour","minute","second"],aRelativeParseScales:["year","quarter","month","week","day","hour","minute","second"],aIntervalCompareFields:["DayPeriod","Hours","Minutes","Seconds"]};
D.getInstance=function(o,i){return this.getDateInstance(o,i);};
D.getDateInstance=function(o,i){return this.createInstance(o,i,this.oDateInfo);};
D.getDateTimeInstance=function(o,i){return this.createInstance(o,i,this.oDateTimeInfo);};
D.getTimeInstance=function(o,i){return this.createInstance(o,i,this.oTimeInfo);};
function g(o){var P=o.oLocaleData.getIntervalPattern("",o.oFormatOptions.calendarType);P=P.replace(/[^\{\}01 ]/,"-");return P.replace(/\{(0|1)\}/g,o.oFormatOptions.pattern);}
D.createInstance=function(o,i,I){var j=Object.create(this.prototype);if(o instanceof L){i=o;o=undefined;}if(!i){i=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();}j.oLocale=i;j.oLocaleData=a.getInstance(i);j.oFormatOptions=e({},I.oDefaultFormatOptions,o);if(!j.oFormatOptions.calendarType){j.oFormatOptions.calendarType=sap.ui.getCore().getConfiguration().getCalendarType();}if(!j.oFormatOptions.pattern){if(j.oFormatOptions.format){j.oFormatOptions.pattern=j.oLocaleData.getCustomDateTimePattern(j.oFormatOptions.format,j.oFormatOptions.calendarType);}else{j.oFormatOptions.pattern=I.getPattern(j.oLocaleData,j.oFormatOptions.style,j.oFormatOptions.calendarType);}}if(j.oFormatOptions.interval){if(j.oFormatOptions.format){j.intervalPatterns=j.oLocaleData.getCustomIntervalPattern(j.oFormatOptions.format,null,j.oFormatOptions.calendarType);if(typeof j.intervalPatterns==="string"){j.intervalPatterns=[j.intervalPatterns];}j.intervalPatterns.push(j.oLocaleData.getCustomDateTimePattern(j.oFormatOptions.format,j.oFormatOptions.calendarType));}else{j.intervalPatterns=[j.oLocaleData.getCombinedIntervalPattern(j.oFormatOptions.pattern,j.oFormatOptions.calendarType),j.oFormatOptions.pattern];}var s=g(j);j.intervalPatterns.push(s);}if(!j.oFormatOptions.fallback){if(!I.oFallbackFormats){I.oFallbackFormats={};}var n=i.toString(),q=j.oFormatOptions.calendarType,K=n+"-"+q,P,t;if(j.oFormatOptions.pattern&&I.bPatternFallbackWithoutDelimiter){K=K+"-"+j.oFormatOptions.pattern;}if(j.oFormatOptions.interval){K=K+"-"+"interval";}var u=I.oFallbackFormats[K]?Object.assign({},I.oFallbackFormats[K]):undefined;if(!u){t=I.aFallbackFormatOptions;if(I.bShortFallbackFormatOptions){P=I.getPattern(j.oLocaleData,"short");t=t.concat(D._createFallbackOptionsWithoutDelimiter(P));}if(j.oFormatOptions.pattern&&I.bPatternFallbackWithoutDelimiter){t=D._createFallbackOptionsWithoutDelimiter(j.oFormatOptions.pattern).concat(t);}u=D._createFallbackFormat(t,q,i,I,j.oFormatOptions.interval);}j.aFallbackFormats=u;}j.oRequiredParts=I.oRequiredParts;j.aRelativeScales=I.aRelativeScales;j.aRelativeParseScales=I.aRelativeParseScales;j.aIntervalCompareFields=I.aIntervalCompareFields;j.init();return j;};
D.prototype.init=function(){var s=this.oFormatOptions.calendarType;this.aMonthsAbbrev=this.oLocaleData.getMonths("abbreviated",s);this.aMonthsWide=this.oLocaleData.getMonths("wide",s);this.aMonthsNarrow=this.oLocaleData.getMonths("narrow",s);this.aMonthsAbbrevSt=this.oLocaleData.getMonthsStandAlone("abbreviated",s);this.aMonthsWideSt=this.oLocaleData.getMonthsStandAlone("wide",s);this.aMonthsNarrowSt=this.oLocaleData.getMonthsStandAlone("narrow",s);this.aDaysAbbrev=this.oLocaleData.getDays("abbreviated",s);this.aDaysWide=this.oLocaleData.getDays("wide",s);this.aDaysNarrow=this.oLocaleData.getDays("narrow",s);this.aDaysShort=this.oLocaleData.getDays("short",s);this.aDaysAbbrevSt=this.oLocaleData.getDaysStandAlone("abbreviated",s);this.aDaysWideSt=this.oLocaleData.getDaysStandAlone("wide",s);this.aDaysNarrowSt=this.oLocaleData.getDaysStandAlone("narrow",s);this.aDaysShortSt=this.oLocaleData.getDaysStandAlone("short",s);this.aQuartersAbbrev=this.oLocaleData.getQuarters("abbreviated",s);this.aQuartersWide=this.oLocaleData.getQuarters("wide",s);this.aQuartersNarrow=this.oLocaleData.getQuarters("narrow",s);this.aQuartersAbbrevSt=this.oLocaleData.getQuartersStandAlone("abbreviated",s);this.aQuartersWideSt=this.oLocaleData.getQuartersStandAlone("wide",s);this.aQuartersNarrowSt=this.oLocaleData.getQuartersStandAlone("narrow",s);this.aErasNarrow=this.oLocaleData.getEras("narrow",s);this.aErasAbbrev=this.oLocaleData.getEras("abbreviated",s);this.aErasWide=this.oLocaleData.getEras("wide",s);this.aDayPeriods=this.oLocaleData.getDayPeriods("abbreviated",s);this.aFormatArray=this.parseCldrDatePattern(this.oFormatOptions.pattern);this.sAllowedCharacters=this.getAllowedCharacters(this.aFormatArray);};
D._createFallbackFormat=function(i,s,o,I,j){return i.map(function(O){var n=Object.assign({},O);if(j){n.interval=true;}n.calendarType=s;n.fallback=true;var q=D.createInstance(n,o,I);q.bIsFallback=true;return q;});};
D._createFallbackOptionsWithoutDelimiter=function(B){var i=/[^dMyGU]/g,o={regex:/d+/g,replace:"dd"},M={regex:/M+/g,replace:"MM"},y={regex:/[yU]+/g,replace:["yyyy","yy"]};B=B.replace(i,"");B=B.replace(o.regex,o.replace);B=B.replace(M.regex,M.replace);return y.replace.map(function(R){return{pattern:B.replace(y.regex,R),strictParsing:true};});};
var p={isNumber:function(i){return i>=48&&i<=57;},findNumbers:function(v,M){var i=0;while(i<M&&this.isNumber(v.charCodeAt(i))){i++;}if(typeof v!=="string"){v=v.toString();}return v.substr(0,i);},findEntry:function(v,i){var n=-1,M=0;for(var j=0;j<i.length;j++){if(i[j]&&i[j].length>M&&v.indexOf(i[j])===0){n=j;M=i[j].length;}}return{index:n,value:n===-1?null:i[n]};},parseTZ:function(v,i){var j=0;var t=v.charAt(0)=="+"?-1:1;var P;j++;P=this.findNumbers(v.substr(j),2);var T=parseInt(P);j+=2;if(i){j++;}P=this.findNumbers(v.substr(j),2);var n=0;if(P){j+=2;n=parseInt(P);}return{length:j,tzDiff:(n+60*T)*t};},checkValid:function(t,P,o){if(t in o.oRequiredParts&&P){return false;}}};D.prototype.oSymbols={"":{name:"text",format:function(o,i,u,j){return o.value;},parse:function(v,P,o,i){var s;var V=true;var j=0;var n=0;var q="\u002d\u007E\u2010\u2011\u2012\u2013\u2014\ufe58\ufe63\uff0d\uFF5E";for(;n<P.value.length;n++){s=P.value.charAt(n);if(s===" "){while(v.charAt(j)===" "){j++;}}else if(q.includes(s)){if(!q.includes(v.charAt(j))){V=false;}j++;}else{if(v.charAt(j)!==s){V=false;}j++;}if(!V){break;}}if(V){return{length:j};}else{var t=false;if(i.index<i.formatArray.length-1){t=(i.formatArray[i.index+1].type in o.oRequiredParts);}return{valid:p.checkValid(P.type,t,o)};}}},"G":{name:"era",format:function(o,i,u,j){var E=u?i.getUTCEra():i.getEra();if(o.digits<=3){return j.aErasAbbrev[E];}else if(o.digits===4){return j.aErasWide[E];}else{return j.aErasNarrow[E];}},parse:function(v,P,o,j){var E=[o.aErasWide,o.aErasAbbrev,o.aErasNarrow];for(var i=0;i<E.length;i++){var V=E[i];var n=p.findEntry(v,V);if(n.index!==-1){return{era:n.index,length:n.value.length};}}return{era:o.aErasWide.length-1,valid:p.checkValid(P.type,true,o)};}},"y":{name:"year",format:function(o,i,u,j){var y=u?i.getUTCFullYear():i.getFullYear();var Y=String(y);var s=j.oFormatOptions.calendarType;if(o.digits==2&&Y.length>2){Y=Y.substr(Y.length-2);}if(s!=C.Japanese&&o.digits==1&&y<100){Y=Y.padStart(4,"0");}return Y.padStart(o.digits,"0");},parse:function(v,P,o,i){var s=o.oFormatOptions.calendarType;var j;if(P.digits==1){j=p.findNumbers(v,4);}else if(P.digits==2){j=p.findNumbers(v,2);}else{j=p.findNumbers(v,P.digits);}var y=parseInt(j);if(s!=C.Japanese&&j.length<=2){var n=U.getInstance(new Date(),s),q=n.getFullYear(),t=Math.floor(q/100),Y=t*100+y-q;if(Y<-70){y+=(t+1)*100;}else if(Y<30){y+=t*100;}else{y+=(t-1)*100;}}return{length:j.length,valid:p.checkValid(P.type,j==="",o),year:y};}},"Y":{name:"weekYear",format:function(o,i,u,j){var w=u?i.getUTCWeek():i.getWeek();var W=w.year;var s=String(W);var n=j.oFormatOptions.calendarType;if(o.digits==2&&s.length>2){s=s.substr(s.length-2);}if(n!=C.Japanese&&o.digits==1&&W<100){s=s.padStart(4,"0");}return s.padStart(o.digits,"0");},parse:function(v,P,o,i){var s=o.oFormatOptions.calendarType;var j;if(P.digits==1){j=p.findNumbers(v,4);}else if(P.digits==2){j=p.findNumbers(v,2);}else{j=p.findNumbers(v,P.digits);}var y=parseInt(j);var w;if(s!=C.Japanese&&j.length<=2){var n=U.getInstance(new Date(),s),q=n.getFullYear(),t=Math.floor(q/100),Y=t*100+w-q;if(Y<-70){w+=(t+1)*100;}else if(Y<30){w+=t*100;}else{w+=(t-1)*100;}}return{length:j.length,valid:p.checkValid(P.type,j==="",o),year:y,weekYear:w};}},"M":{name:"month",format:function(o,i,u,j){var M=u?i.getUTCMonth():i.getMonth();if(o.digits==3){return j.aMonthsAbbrev[M];}else if(o.digits==4){return j.aMonthsWide[M];}else if(o.digits>4){return j.aMonthsNarrow[M];}else{return String(M+1).padStart(o.digits,"0");}},parse:function(v,P,o,j){var M=[o.aMonthsWide,o.aMonthsWideSt,o.aMonthsAbbrev,o.aMonthsAbbrevSt,o.aMonthsNarrow,o.aMonthsNarrowSt];var V;var n;var s;if(P.digits<3){s=p.findNumbers(v,Math.max(P.digits,2));V=p.checkValid(P.type,s==="",o);n=parseInt(s)-1;if(j.strict&&(n>11||n<0)){V=false;}}else{for(var i=0;i<M.length;i++){var q=M[i];var t=p.findEntry(v,q);if(t.index!==-1){return{month:t.index,length:t.value.length};}}V=p.checkValid(P.type,true,o);}return{month:n,length:s?s.length:0,valid:V};}},"L":{name:"monthStandalone",format:function(o,i,u,j){var M=u?i.getUTCMonth():i.getMonth();if(o.digits==3){return j.aMonthsAbbrevSt[M];}else if(o.digits==4){return j.aMonthsWideSt[M];}else if(o.digits>4){return j.aMonthsNarrowSt[M];}else{return String(M+1).padStart(o.digits,"0");}},parse:function(v,P,o,j){var M=[o.aMonthsWide,o.aMonthsWideSt,o.aMonthsAbbrev,o.aMonthsAbbrevSt,o.aMonthsNarrow,o.aMonthsNarrowSt];var V;var n;var s;if(P.digits<3){s=p.findNumbers(v,Math.max(P.digits,2));V=p.checkValid(P.type,s==="",o);n=parseInt(s)-1;if(j.strict&&(n>11||n<0)){V=false;}}else{for(var i=0;i<M.length;i++){var q=M[i];var t=p.findEntry(v,q);if(t.index!==-1){return{month:t.index,length:t.value.length};}}V=p.checkValid(P.type,true,o);}return{month:n,length:s?s.length:0,valid:V};}},"w":{name:"weekInYear",format:function(o,i,u,j){var w=u?i.getUTCWeek():i.getWeek();var W=w.week;var s=String(W+1);if(o.digits<3){s=s.padStart(o.digits,"0");}else{s=j.oLocaleData.getCalendarWeek(o.digits===3?"narrow":"wide",s.padStart(2,"0"));}return s;},parse:function(v,P,o,i){var V;var s;var w;var j=0;if(P.digits<3){s=p.findNumbers(v,2);j=s.length;w=parseInt(s)-1;V=p.checkValid(P.type,!s,o);}else{s=o.oLocaleData.getCalendarWeek(P.digits===3?"narrow":"wide");s=s.replace("{0}","[0-9]+");var n=new RegExp(s),R=n.exec(v);if(R){j=R[0].length;w=parseInt(R[0])-1;}else{V=p.checkValid(P.type,true,o);}}return{length:j,valid:V,week:w};}},"W":{name:"weekInMonth",format:function(o,i,u,j){return"";},parse:function(){return{};}},"D":{name:"dayInYear",format:function(o,i,u,j){},parse:function(){return{};}},"d":{name:"day",format:function(o,i,u,j){var n=u?i.getUTCDate():i.getDate();return String(n).padStart(o.digits,"0");},parse:function(v,P,o,i){var s=p.findNumbers(v,Math.max(P.digits,2));var V=p.checkValid(P.type,s==="",o);var j=parseInt(s);if(i.strict&&(j>31||j<1)){V=false;}return{day:j,length:s.length,valid:V};}},"Q":{name:"quarter",format:function(o,i,u,j){var q=u?i.getUTCQuarter():i.getQuarter();if(o.digits==3){return j.aQuartersAbbrev[q];}else if(o.digits==4){return j.aQuartersWide[q];}else if(o.digits>4){return j.aQuartersNarrow[q];}else{return String(q+1).padStart(o.digits,"0");}},parse:function(v,P,o,j){var V;var q;var s;var Q=[o.aQuartersWide,o.aQuartersWideSt,o.aQuartersAbbrev,o.aQuartersAbbrevSt,o.aQuartersNarrow,o.aQuartersNarrowSt];if(P.digits<3){s=p.findNumbers(v,Math.max(P.digits,2));V=p.checkValid(P.type,s==="",o);q=parseInt(s)-1;if(j.strict&&q>3){V=false;}}else{for(var i=0;i<Q.length;i++){var n=Q[i];var t=p.findEntry(v,n);if(t.index!==-1){return{quarter:t.index,length:t.value.length};}}V=p.checkValid(P.type,true,o);}return{length:s?s.length:0,quarter:q,valid:V};}},"q":{name:"quarterStandalone",format:function(o,i,u,j){var q=u?i.getUTCQuarter():i.getQuarter();if(o.digits==3){return j.aQuartersAbbrevSt[q];}else if(o.digits==4){return j.aQuartersWideSt[q];}else if(o.digits>4){return j.aQuartersNarrowSt[q];}else{return String(q+1).padStart(o.digits,"0");}},parse:function(v,P,o,j){var V;var q;var s;var Q=[o.aQuartersWide,o.aQuartersWideSt,o.aQuartersAbbrev,o.aQuartersAbbrevSt,o.aQuartersNarrow,o.aQuartersNarrowSt];if(P.digits<3){s=p.findNumbers(v,Math.max(P.digits,2));V=p.checkValid(P.type,s==="",o);q=parseInt(s)-1;if(j.strict&&q>3){V=false;}}else{for(var i=0;i<Q.length;i++){var n=Q[i];var t=p.findEntry(v,n);if(t.index!==-1){return{quarter:t.index,length:t.value.length};}}V=p.checkValid(P.type,true,o);}return{length:s?s.length:0,quarter:q,valid:V};}},"F":{name:"dayOfWeekInMonth",format:function(o,i,u,j){return"";},parse:function(){return{};}},"E":{name:"dayNameInWeek",format:function(o,i,u,j){var n=u?i.getUTCDay():i.getDay();if(o.digits<4){return j.aDaysAbbrev[n];}else if(o.digits==4){return j.aDaysWide[n];}else if(o.digits==5){return j.aDaysNarrow[n];}else{return j.aDaysShort[n];}},parse:function(v,P,o,j){var n=[o.aDaysWide,o.aDaysWideSt,o.aDaysAbbrev,o.aDaysAbbrevSt,o.aDaysShort,o.aDaysShortSt,o.aDaysNarrow,o.aDaysNarrowSt];for(var i=0;i<n.length;i++){var V=n[i];var q=p.findEntry(v,V);if(q.index!==-1){return{dayOfWeek:q.index,length:q.value.length};}}}},"c":{name:"dayNameInWeekStandalone",format:function(o,i,u,j){var n=u?i.getUTCDay():i.getDay();if(o.digits<4){return j.aDaysAbbrevSt[n];}else if(o.digits==4){return j.aDaysWideSt[n];}else if(o.digits==5){return j.aDaysNarrowSt[n];}else{return j.aDaysShortSt[n];}},parse:function(v,P,o,j){var n=[o.aDaysWide,o.aDaysWideSt,o.aDaysAbbrev,o.aDaysAbbrevSt,o.aDaysShort,o.aDaysShortSt,o.aDaysNarrow,o.aDaysNarrowSt];for(var i=0;i<n.length;i++){var V=n[i];var q=p.findEntry(v,V);if(q.index!==-1){return{day:q.index,length:q.value.length};}}}},"u":{name:"dayNumberOfWeek",format:function(o,i,u,j){var n=u?i.getUTCDay():i.getDay();return j._adaptDayOfWeek(n);},parse:function(v,P,o,i){var s=p.findNumbers(v,P.digits);return{dayNumberOfWeek:parseInt(s),length:s.length};}},"a":{name:"amPmMarker",format:function(o,i,u,j){var n=u?i.getUTCDayPeriod():i.getDayPeriod();return j.aDayPeriods[n];},parse:function(v,P,o,i){var j;var n;var A=o.aDayPeriods[0],s=o.aDayPeriods[1];var q=/[aApP](?:\.)?[mM](?:\.)?/;var M=v.match(q);var V=(M&&M.index===0);if(V){v=M[0].replace(/\./g,"").toLowerCase()+v.substring(M[0].length);A=A.replace(/\./g,"").toLowerCase();s=s.replace(/\./g,"").toLowerCase();}if(v.indexOf(A)===0){j=false;n=(V?M[0].length:A.length);}else if(v.indexOf(s)===0){j=true;n=(V?M[0].length:s.length);}return{pm:j,length:n};}},"H":{name:"hour0_23",format:function(o,i,u,j){var H=u?i.getUTCHours():i.getHours();return String(H).padStart(o.digits,"0");},parse:function(v,P,o,i){var V;var s=p.findNumbers(v,Math.max(P.digits,2));var H=parseInt(s);V=p.checkValid(P.type,s==="",o);if(i.strict&&H>23){V=false;}return{hour:H,length:s.length,valid:V};}},"k":{name:"hour1_24",format:function(o,i,u,j){var H=u?i.getUTCHours():i.getHours();var s=(H===0?"24":String(H));return s.padStart(o.digits,"0");},parse:function(v,P,o,i){var V;var s=p.findNumbers(v,Math.max(P.digits,2));var H=parseInt(s);V=p.checkValid(P.type,s==="",o);if(H==24){H=0;}if(i.strict&&H>23){V=false;}return{hour:H,length:s.length,valid:V};}},"K":{name:"hour0_11",format:function(o,i,u,j){var H=u?i.getUTCHours():i.getHours();var s=String(H>11?H-12:H);return s.padStart(o.digits,"0");},parse:function(v,P,o,i){var V;var s=p.findNumbers(v,Math.max(P.digits,2));var H=parseInt(s);V=p.checkValid(P.type,s==="",o);if(i.strict&&H>11){V=false;}return{hour:H,length:s.length,valid:V};}},"h":{name:"hour1_12",format:function(o,i,u,j){var H=u?i.getUTCHours():i.getHours();var s;if(H>12){s=String(H-12);}else if(H==0){s="12";}else{s=String(H);}return s.padStart(o.digits,"0");},parse:function(v,P,o,i){var j=i.dateValue.pm;var s=p.findNumbers(v,Math.max(P.digits,2));var H=parseInt(s);var V=p.checkValid(P.type,s==="",o);if(H==12){H=0;j=(j===undefined)?true:j;}if(i.strict&&H>11){V=false;}return{hour:H,length:s.length,pm:j,valid:V};}},"m":{name:"minute",format:function(o,i,u,j){var M=u?i.getUTCMinutes():i.getMinutes();return String(M).padStart(o.digits,"0");},parse:function(v,P,o,i){var V;var s=p.findNumbers(v,Math.max(P.digits,2));var M=parseInt(s);V=p.checkValid(P.type,s==="",o);if(i.strict&&M>59){V=false;}return{length:s.length,minute:M,valid:V};}},"s":{name:"second",format:function(o,i,u,j){var s=u?i.getUTCSeconds():i.getSeconds();return String(s).padStart(o.digits,"0");},parse:function(v,P,o,i){var V;var s=p.findNumbers(v,Math.max(P.digits,2));var S=parseInt(s);V=p.checkValid(P.type,s==="",o);if(i.strict&&S>59){V=false;}return{length:s.length,second:S,valid:V};}},"S":{name:"fractionalsecond",format:function(o,i,u,j){var M=u?i.getUTCMilliseconds():i.getMilliseconds();var s=String(M);var n=s.padStart(3,"0");n=n.substr(0,o.digits);n=n.padEnd(o.digits,"0");return n;},parse:function(v,P,o,i){var s=p.findNumbers(v,P.digits);var j=s.length;s=s.substr(0,3);s=s.padEnd(3,"0");var M=parseInt(s);return{length:j,millisecond:M};}},"z":{name:"timezoneGeneral",format:function(o,i,u,j){if(o.digits>3&&i.getTimezoneLong&&i.getTimezoneLong()){return i.getTimezoneLong();}else if(i.getTimezoneShort&&i.getTimezoneShort()){return i.getTimezoneShort();}var t="GMT";var T=Math.abs(i.getTimezoneOffset());var P=i.getTimezoneOffset()>0;var H=Math.floor(T/60);var M=T%60;if(!u&&T!=0){t+=(P?"-":"+");t+=String(H).padStart(2,"0");t+=":";t+=String(M).padStart(2,"0");}else{t+="Z";}return t;},parse:function(v,P,o,i){var j=0;var t;var T=v.substring(0,3);if(T==="GMT"||T==="UTC"){j=3;}else if(v.substring(0,2)==="UT"){j=2;}else if(v.charAt(0)==="Z"){j=1;t=0;}else{return{error:"cannot be parsed correcly by sap.ui.core.format.DateFormat: The given timezone is not supported!"};}if(v.charAt(0)!=="Z"){var n=p.parseTZ(v.substr(j),true);j+=n.length;t=n.tzDiff;}return{length:j,tzDiff:t};}},"Z":{name:"timezoneRFC822",format:function(o,i,u,j){var t=Math.abs(i.getTimezoneOffset());var P=i.getTimezoneOffset()>0;var H=Math.floor(t/60);var M=t%60;var T="";if(!u){T+=(P?"-":"+");T+=String(H).padStart(2,"0");T+=String(M).padStart(2,"0");}return T;},parse:function(v,P,o,i){return p.parseTZ(v,false);}},"X":{name:"timezoneISO8601",format:function(o,i,u,j){var t=Math.abs(i.getTimezoneOffset());var P=i.getTimezoneOffset()>0;var H=Math.floor(t/60);var M=t%60;var T="";if(!u&&t!=0){T+=(P?"-":"+");T+=String(H).padStart(2,"0");if(o.digits>1||M>0){if(o.digits===3||o.digits===5){T+=":";}T+=String(M).padStart(2,"0");}}else{T+="Z";}return T;},parse:function(v,P,o,i){if(v.charAt(0)==="Z"){return{length:1,tzDiff:0};}else{return p.parseTZ(v,P.digits===3||P.digits===5);}}}};
D.prototype._format=function(j,u){if(this.oFormatOptions.relative){var R=this.formatRelative(j,u,this.oFormatOptions.relativeRange);if(R){return R;}}var s=this.oFormatOptions.calendarType;var o=U.getInstance(j,s);var B=[],P,n,S;for(var i=0;i<this.aFormatArray.length;i++){P=this.aFormatArray[i];S=P.symbol||"";B.push(this.oSymbols[S].format(P,o,u,this));}n=B.join("");if(sap.ui.getCore().getConfiguration().getOriginInfo()){n=new String(n);n.originInfo={source:"Common Locale Data Repository",locale:this.oLocale.toString(),style:this.oFormatOptions.style,pattern:this.oFormatOptions.pattern};}return n;};
D.prototype.format=function(j,u){var s=this.oFormatOptions.calendarType,R;if(u===undefined){u=this.oFormatOptions.UTC;}if(Array.isArray(j)){if(!this.oFormatOptions.interval){b.error("Non-interval DateFormat can't format more than one date instance.");return"";}if(j.length!==2){b.error("Interval DateFormat can only format with 2 date instances but "+j.length+" is given.");return"";}if(this.oFormatOptions.singleIntervalValue){if(j[0]===null){b.error("First date instance which is passed to the interval DateFormat shouldn't be null.");return"";}if(j[1]===null){R=this._format(j[0],u);}}if(R===undefined){var v=j.every(function(J){return J&&!isNaN(J.getTime());});if(!v){b.error("At least one date instance which is passed to the interval DateFormat isn't valid.");return"";}R=this._formatInterval(j,u);}}else{if(!j||isNaN(j.getTime())){b.error("The given date instance isn't valid.");return"";}if(this.oFormatOptions.interval){b.error("Interval DateFormat expects an array with two dates for the first argument but only one date is given.");return"";}R=this._format(j,u);}if(s==C.Japanese&&this.oLocale.getLanguage()==="ja"){R=R.replace(/(^|[^\d])1年/g,"$1元年");}return R;};
D.prototype._formatInterval=function(j,u){var s=this.oFormatOptions.calendarType;var o=U.getInstance(j[0],s);var t=U.getInstance(j[1],s);var n;var P;var S;var B=[];var q;var v=[];var w=this._getGreatestDiffField([o,t],u);if(!w){return this._format(j[0],u);}if(this.oFormatOptions.format){q=this.oLocaleData.getCustomIntervalPattern(this.oFormatOptions.format,w,s);}else{q=this.oLocaleData.getCombinedIntervalPattern(this.oFormatOptions.pattern,s);}v=this.parseCldrDatePattern(q);n=o;for(var i=0;i<v.length;i++){P=v[i];S=P.symbol||"";if(P.repeat){n=t;}B.push(this.oSymbols[S].format(P,n,u,this));}return B.join("");};
var F={Era:"Era",FullYear:"Year",Quarter:"Quarter",Month:"Month",Week:"Week",Date:"Day",DayPeriod:"DayPeriod",Hours:"Hour",Minutes:"Minute",Seconds:"Second"};
D.prototype._getGreatestDiffField=function(i,u){var j=false,n={};this.aIntervalCompareFields.forEach(function(s){var G="get"+(u?"UTC":""),M=G+s,o=F[s],v=i[0][M].apply(i[0]),t=i[1][M].apply(i[1]);if(!d(v,t)){j=true;n[o]=true;}});if(j){return n;}return null;};
D.prototype._parse=function(v,j,u,s){var I=0,P,S,R;var o={valid:true};var n={formatArray:j,dateValue:o,strict:s};for(var i=0;i<j.length;i++){S=v.substr(I);P=j[i];n.index=i;R=this.oSymbols[P.symbol||""].parse(S,P,this,n)||{};o=e(o,R);if(R.valid===false){break;}I+=R.length||0;}o.index=I;if(o.pm){o.hour+=12;}if(o.dayNumberOfWeek===undefined&&o.dayOfWeek!==undefined){o.dayNumberOfWeek=this._adaptDayOfWeek(o.dayOfWeek);}if(o.quarter!==undefined&&o.month===undefined&&o.day===undefined){o.month=3*o.quarter;o.day=1;}return o;};
D.prototype._parseInterval=function(v,s,u,S){var j,R,o;this.intervalPatterns.some(function(P){var n=this.parseCldrDatePattern(P);R=undefined;for(var i=0;i<n.length;i++){if(n[i].repeat){R=i;break;}}if(R===undefined){o=this._parse(v,n,u,S);if(o.index===0||o.index<v.length){o.valid=false;}if(o.valid===false){return;}j=[o,o];return true;}else{j=[];o=this._parse(v,n.slice(0,R),u,S);if(o.valid===false){return;}j.push(o);var q=o.index;o=this._parse(v.substring(q),n.slice(R),u,S);if(o.index===0||o.index+q<v.length){o.valid=false;}if(o.valid===false){return;}j.push(o);return true;}}.bind(this));return j;};
var h=function(o,s,u,S){var i,y=typeof o.year==="number"?o.year:1970;if(o.valid){if(u||o.tzDiff!==undefined){i=U.getInstance(new Date(0),s);i.setUTCEra(o.era||U.getCurrentEra(s));i.setUTCFullYear(y);i.setUTCMonth(o.month||0);i.setUTCDate(o.day||1);i.setUTCHours(o.hour||0);i.setUTCMinutes(o.minute||0);i.setUTCSeconds(o.second||0);i.setUTCMilliseconds(o.millisecond||0);if(S&&(o.day||1)!==i.getUTCDate()){o.valid=false;i=undefined;}else{if(o.tzDiff){i.setUTCMinutes((o.minute||0)+o.tzDiff);}if(o.week!==undefined&&(o.month===undefined||o.day===undefined)){i.setUTCWeek({year:o.weekYear||o.year,week:o.week});if(o.dayNumberOfWeek!==undefined){i.setUTCDate(i.getUTCDate()+o.dayNumberOfWeek-1);}}}}else{i=U.getInstance(new Date(1970,0,1,0,0,0),s);i.setEra(o.era||U.getCurrentEra(s));i.setFullYear(y);i.setMonth(o.month||0);i.setDate(o.day||1);i.setHours(o.hour||0);i.setMinutes(o.minute||0);i.setSeconds(o.second||0);i.setMilliseconds(o.millisecond||0);if(S&&(o.day||1)!==i.getDate()){o.valid=false;i=undefined;}else if(o.week!==undefined&&(o.month===undefined||o.day===undefined)){i.setWeek({year:o.weekYear||o.year,week:o.week});if(o.dayNumberOfWeek!==undefined){i.setDate(i.getDate()+o.dayNumberOfWeek-1);}}}if(o.valid){i=i.getJSDate();return i;}}return null;};
function m(o,i){if(o===i){return o;}var M={};Object.keys(o).forEach(function(K){M[K]=o[K];});Object.keys(i).forEach(function(K){if(!M.hasOwnProperty(K)){M[K]=i[K];}});return M;}
function k(s,E){if(s.getTime()>E.getTime()){return false;}return true;}
D.prototype.parse=function(v,u,s){v=v==null?"":String(v).trim();var o;var i=this.oFormatOptions.calendarType;if(u===undefined){u=this.oFormatOptions.UTC;}if(s===undefined){s=this.oFormatOptions.strictParsing;}if(i==C.Japanese&&this.oLocale.getLanguage()==="ja"){v=v.replace(/元年/g,"1年");}if(!this.oFormatOptions.interval){var j=this.parseRelative(v,u);if(j){return j;}o=this._parse(v,this.aFormatArray,u,s);if(o.index===0||o.index<v.length){o.valid=false;}j=h(o,i,u,s);if(j){return j;}}else{var n=this._parseInterval(v,i,u,s);var J,q;if(n&&n.length==2){var t=m(n[0],n[1]);var w=m(n[1],n[0]);J=h(t,i,u,s);q=h(w,i,u,s);if(J&&q){if(this.oFormatOptions.singleIntervalValue&&J.getTime()===q.getTime()){return[J,null];}var V=k(J,q);if(s&&!V){b.error("StrictParsing: Invalid date range. The given end date is before the start date.");return[null,null];}return[J,q];}}}if(!this.bIsFallback){var x;this.aFallbackFormats.every(function(y){x=y.parse(v,u,s);if(Array.isArray(x)){return!(x[0]&&x[1]);}else{return!x;}});return x;}if(!this.oFormatOptions.interval){return null;}else{return[null,null];}};
D.prototype.parseCldrDatePattern=function(P){if(c[P]){return c[P];}var j=[],i,q=false,o=null,s="",n="",A={},I=false;for(i=0;i<P.length;i++){var t=P.charAt(i),N,u,v;if(q){if(t=="'"){u=P.charAt(i-1);v=P.charAt(i-2);N=P.charAt(i+1);if(u=="'"&&v!="'"){q=false;}else if(N=="'"){i+=1;}else{q=false;continue;}}if(s=="text"){o.value+=t;}else{o={type:"text",value:t};j.push(o);s="text";}}else{if(t=="'"){q=true;}else if(this.oSymbols[t]){n=this.oSymbols[t].name;if(s==n){o.digits++;}else{o={type:n,symbol:t,digits:1};j.push(o);s=n;if(!I){if(A[n]){o.repeat=true;I=true;}else{A[n]=true;}}}}else{if(s=="text"){o.value+=t;}else{o={type:"text",value:t};j.push(o);s="text";}}}}c[P]=j;return j;};
D.prototype.parseRelative=function(v,u){var P,E,j,R,V;if(!v){return null;}P=this.oLocaleData.getRelativePatterns(this.aRelativeParseScales,this.oFormatOptions.relativeStyle);for(var i=0;i<P.length;i++){E=P[i];j=new RegExp("^\\s*"+E.pattern.replace(/\{0\}/,"(\\d+)")+"\\s*$","i");R=j.exec(v);if(R){if(E.value!==undefined){return n(E.value,E.scale);}else{V=parseInt(R[1]);return n(V*E.sign,E.scale);}}}function n(o,s){var t,T=new Date(),J;if(u){t=T.getTime();}else{t=Date.UTC(T.getFullYear(),T.getMonth(),T.getDate(),T.getHours(),T.getMinutes(),T.getSeconds(),T.getMilliseconds());}J=new Date(t);switch(s){case"second":J.setUTCSeconds(J.getUTCSeconds()+o);break;case"minute":J.setUTCMinutes(J.getUTCMinutes()+o);break;case"hour":J.setUTCHours(J.getUTCHours()+o);break;case"day":J.setUTCDate(J.getUTCDate()+o);break;case"week":J.setUTCDate(J.getUTCDate()+o*7);break;case"month":J.setUTCMonth(J.getUTCMonth()+o);break;case"quarter":J.setUTCMonth(J.getUTCMonth()+o*3);break;case"year":J.setUTCFullYear(J.getUTCFullYear()+o);break;}if(u){return J;}else{return new Date(J.getUTCFullYear(),J.getUTCMonth(),J.getUTCDate(),J.getUTCHours(),J.getUTCMinutes(),J.getUTCSeconds(),J.getUTCMilliseconds());}}};
D.prototype.formatRelative=function(j,u,R){var t=new Date(),o,s=this.oFormatOptions.relativeScale||"day",i,P,n;n=(j.getTime()-t.getTime())/1000;if(this.oFormatOptions.relativeScale=="auto"){s=this._getScale(n,this.aRelativeScales);}if(!R){R=this._mRanges[s];}if(s=="year"||s=="month"||s=="day"){t=new Date(Date.UTC(t.getFullYear(),t.getMonth(),t.getDate()));o=new Date(0);if(u){o.setUTCFullYear(j.getUTCFullYear(),j.getUTCMonth(),j.getUTCDate());}else{o.setUTCFullYear(j.getFullYear(),j.getMonth(),j.getDate());}j=o;}i=this._getDifference(s,[t,j]);if(this.oFormatOptions.relativeScale!="auto"&&(i<R[0]||i>R[1])){return null;}P=this.oLocaleData.getRelativePattern(s,i,n>0,this.oFormatOptions.relativeStyle);return f(P,[Math.abs(i)]);};
D.prototype._mRanges={second:[-60,60],minute:[-60,60],hour:[-24,24],day:[-6,6],week:[-4,4],month:[-12,12],year:[-10,10]};D.prototype._mScales={second:1,minute:60,hour:3600,day:86400,week:604800,month:2592000,quarter:7776000,year:31536000};
D.prototype._getScale=function(j,s){var S,t;j=Math.abs(j);for(var i=0;i<s.length;i++){t=s[i];if(j>=this._mScales[t]){S=t;break;}}if(!S){S=s[s.length-1];}return S;};
function l(o,s){var j=["FullYear","Month","Date","Hours","Minutes","Seconds","Milliseconds"],M;var n=new Date(o.getTime());for(var i=s;i<j.length;i++){M="set"+j[s];n[M].apply(n,[0]);}return n;}
var r={year:function(o,t){return t.getFullYear()-o.getFullYear();},month:function(o,t){return t.getMonth()-o.getMonth()+(this.year(o,t)*12);},week:function(o,t,i){var j=i._adaptDayOfWeek(o.getDay());var T=i._adaptDayOfWeek(t.getDay());o=l(o,3);t=l(t,3);return(t.getTime()-o.getTime()-(T-j)*i._mScales.day*1000)/(i._mScales.week*1000);},day:function(o,t,i){o=l(o,3);t=l(t,3);return(t.getTime()-o.getTime())/(i._mScales.day*1000);},hour:function(o,t,i){o=l(o,4);t=l(t,4);return(t.getTime()-o.getTime())/(i._mScales.hour*1000);},minute:function(o,t,i){o=l(o,5);t=l(t,5);return(t.getTime()-o.getTime())/(i._mScales.minute*1000);},second:function(o,t,i){o=l(o,6);t=l(t,6);return(t.getTime()-o.getTime())/(i._mScales.second*1000);}};
D.prototype._adaptDayOfWeek=function(i){var j=a.getInstance(sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale()).getFirstDayOfWeek();var n=i-(j-1);if(n<=0){n+=7;}return n;};
D.prototype._getDifference=function(s,i){var o=i[0];var t=i[1];return Math.round(r[s](o,t,this));};
D.prototype.getAllowedCharacters=function(j){if(this.oFormatOptions.relative){return"";}var A="";var n=false;var o=false;var P;for(var i=0;i<j.length;i++){P=j[i];switch(P.type){case"text":if(A.indexOf(P.value)<0){A+=P.value;}break;case"day":case"year":case"weekYear":case"dayNumberOfWeek":case"weekInYear":case"hour0_23":case"hour1_24":case"hour0_11":case"hour1_12":case"minute":case"second":case"fractionalsecond":if(!n){A+="0123456789";n=true;}break;case"month":case"monthStandalone":if(P.digits<3){if(!n){A+="0123456789";n=true;}}else{o=true;}break;default:o=true;break;}}if(o){A="";}return A;};
return D;},true);
sap.ui.predefine('sap/ui/core/format/FileSizeFormat',['sap/ui/base/Object','sap/ui/core/Locale','sap/ui/core/LocaleData','sap/ui/core/format/NumberFormat'],function(B,L,a,N){"use strict";var _=[{binaryFactor:1,decimalFactor:1,decimalUnit:"Byte",binaryUnit:"Byte"},{binaryFactor:1,decimalFactor:1,decimalUnit:"Bytes",binaryUnit:"Bytes"},{binaryFactor:Math.pow(2,10),decimalFactor:1e3,decimalUnit:"Kilobyte",binaryUnit:"Kibibyte"},{binaryFactor:Math.pow(2,20),decimalFactor:1e6,decimalUnit:"Megabyte",binaryUnit:"Mebibyte"},{binaryFactor:Math.pow(2,30),decimalFactor:1e9,decimalUnit:"Gigabyte",binaryUnit:"Gibibyte"},{binaryFactor:Math.pow(2,40),decimalFactor:1e12,decimalUnit:"Terabyte",binaryUnit:"Tebibyte"},{binaryFactor:Math.pow(2,50),decimalFactor:1e15,decimalUnit:"Petabyte",binaryUnit:"Pebibyte"},{binaryFactor:Math.pow(2,60),decimalFactor:1e18,decimalUnit:"Exabyte",binaryUnit:"Exbibyte"},{binaryFactor:Math.pow(2,70),decimalFactor:1e21,decimalUnit:"Zettabyte",binaryUnit:"Zebibyte"},{binaryFactor:Math.pow(2,80),decimalFactor:1e24,decimalUnit:"Yottabyte",binaryUnit:"Yobibyte"}];
var F=B.extend("sap.ui.core.format.FileSizeFormat",{constructor:function(f){throw new Error();}});
F.getInstance=function(f,l){return this.createInstance(f,l);};
F.createInstance=function(f,l){var o=Object.create(this.prototype);if(f instanceof L){l=f;f=undefined;}if(!l){l=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();}o.oLocale=l;o.oLocaleData=a.getInstance(l);o.oNumberFormat=N.getFloatInstance(f,l);o.oBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.core",l.toString());o.bBinary=f?!!f.binaryFilesize:false;return o;};
F.prototype.format=function(v){var V=null,o;if(typeof v=="string"){try{if(/^\s*[\+-]?0[xX]/.test(v)){V=parseInt(v,16);}else{V=parseFloat(v,10);}}catch(e){}}else if(typeof v=="number"){V=v;}if(V===null){return"NaN";}o=V;var u=c(V,this.bBinary),s=this.oNumberFormat.format(V/u.factor);if(!u.noSecondRounding){V=this.oNumberFormat.parse(s);if((this.bBinary&&Math.abs(V)>=1024)||(!this.bBinary&&Math.abs(V)>=1000)){u=c(V*u.factor,this.bBinary);s=this.oNumberFormat.format(o/u.factor);}}return this.oBundle.getText("FileSize."+u.unit,s);};
F.prototype.parse=function(v){var u,b,V,e;if(!v){return NaN;}for(var i=0;i<_.length;i++){u=_[i];b=d(this.oBundle,u.decimalUnit,v);if(b){e=false;break;}else{b=d(this.oBundle,u.binaryUnit,v);if(b){e=true;break;}}}if(!b){b=v;e=false;u=_[0];}V=this.oNumberFormat.parse(b);return V*(e?u.binaryFactor:u.decimalFactor);};
function c(f,e){var b=Math.abs(f),u,g;for(var i=_.length-1;i>=2;i--){u=_[i];g=e?u.binaryFactor:u.decimalFactor;if(b>=g){return{factor:g,unit:e?u.binaryUnit:u.decimalUnit,noSecondRounding:(i==_.length-1)};}}return{factor:1,unit:_[b>=2?1:0].decimalUnit};}
function d(b,u,v){var p=b.getText("FileSize."+u),e;if(p.startsWith("{0}")){e=p.substr(3,p.length);if((typeof e=="string"&&e!=""?v.toLowerCase().endsWith(e.toLowerCase()):false)){return v.substr(0,v.length-e.length);}}else if(p.endsWith("{0}")){e=p.substr(0,p.length-3);if((typeof e=="string"&&e!=""?v.toLowerCase().startsWith(e.toLowerCase()):false)){return v.substr(e.length,v.length);}}else{e=p.split("{0}");if(e.length==2&&((typeof e[0]=="string"&&e[0]!=""?v.toLowerCase().startsWith(e[0].toLowerCase()):false))&&((typeof e[1]=="string"&&e[1]!=""?v.toLowerCase().endsWith(e[1].toLowerCase()):false))){return v.substr(e[0].length,v.length-e[1].length);}}return null;}
return F;});
sap.ui.predefine('sap/ui/core/format/ListFormat',['sap/ui/core/Locale','sap/ui/core/LocaleData',"sap/base/Log","sap/base/util/extend","sap/base/util/isEmptyObject"],function(L,a,b,e,c){"use strict";var d=function(){throw new Error();};d.oDefaultListFormat={type:"standard",style:"wide"};
d.getInstance=function(f,l){return this.createInstance(f,l);};
d.createInstance=function(f,l){var F=Object.create(this.prototype);if(f instanceof L){l=f;f=undefined;}if(!l){l=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();}F.oLocale=l;F.oLocaleData=a.getInstance(l);F.oOriginalFormatOptions=e({},this.oDefaultListFormat,f);return F;};
d.prototype.format=function(l){if(!Array.isArray(l)){b.error("ListFormat can only format with an array given.");return"";}var o=this.oOriginalFormatOptions,m,p,v,s,M,E,V=[].concat(l),S,f;m=this.oLocaleData.getListFormat(o.type,o.style);if(c(m)){b.error("No list pattern exists for the provided format options (type, style).");return"";}function r(V,p){var R=V[0];for(var i=1;i<V.length;i++){R=p.replace("{0}",R);R=R.replace("{1}",V[i]);}return R;}if(m[V.length]){p=m[V.length];for(var i=0;i<V.length;i++){p=p.replace('{'+i+'}',V[i]);}v=p;}else if(V.length<2){v=V.toString();}else{S=V.shift();E=V.pop();f=V;s=m.start.replace("{0}",S);E=m.end.replace("{1}",E);M=r(f,m.middle);v=s.replace("{1}",E.replace("{0}",M));}return v;};
d.prototype.parse=function(v){if(typeof v!=='string'){b.error("ListFormat can only parse a String.");return[];}var r=[],s=[],m=[],E=[],f=[],o=this.oOriginalFormatOptions,l,g=/\{[01]\}/g,h,S,i,j,k;if(!o){o=d.oDefaultListFormat;}l=this.oLocaleData.getListFormat(o.type,o.style);if(c(l)){b.error("No list pattern exists for the provided format options (type, style).");return[];}i=l.start.replace(g,"");j=l.middle.replace(g,"");k=l.end.replace(g,"");s=v.split(i);r=r.concat(s.shift());E=s.join(i).split(k);h=E.pop();m=E.join(k).split(j);r=r.concat(m);r.push(h);if(s.length<1||m.length<1||E.length<1){S=l["2"].replace(g,"");f=v.split(S);if(f.length===2){return f;}if(v){return[v];}else{return[];}}return r;};
return d;});
sap.ui.predefine('sap/ui/core/format/NumberFormat',['sap/ui/base/Object','sap/ui/core/Locale','sap/ui/core/LocaleData','sap/base/Log','sap/base/assert','sap/base/util/extend'],function(B,L,a,b,c,e){"use strict";
var N=B.extend("sap.ui.core.format.NumberFormat",{constructor:function(F){throw new Error();}});
var r=/0+(\.0+)?/;var d=/^0+$/;var n={INTEGER:"integer",FLOAT:"float",CURRENCY:"currency",UNIT:"unit",PERCENT:"percent"};var R={FLOOR:"floor",CEILING:"ceiling",TOWARDS_ZERO:"towards_zero",AWAY_FROM_ZERO:"away_from_zero",HALF_FLOOR:"half_floor",HALF_CEILING:"half_ceiling",HALF_TOWARDS_ZERO:"half_towards_zero",HALF_AWAY_FROM_ZERO:"half_away_from_zero"};var m={};m[R.FLOOR]=Math.floor;m[R.CEILING]=Math.ceil;m[R.TOWARDS_ZERO]=function(i){return i>0?Math.floor(i):Math.ceil(i);};m[R.AWAY_FROM_ZERO]=function(i){return i>0?Math.ceil(i):Math.floor(i);};m[R.HALF_TOWARDS_ZERO]=function(i){return i>0?Math.ceil(i-0.5):Math.floor(i+0.5);};m[R.HALF_AWAY_FROM_ZERO]=function(i){return i>0?Math.floor(i+0.5):Math.ceil(i-0.5);};m[R.HALF_FLOOR]=function(i){return Math.ceil(i-0.5);};m[R.HALF_CEILING]=Math.round;N.RoundingMode=R;N.oDefaultIntegerFormat={minIntegerDigits:1,maxIntegerDigits:99,minFractionDigits:0,maxFractionDigits:0,groupingEnabled:false,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:true,type:n.INTEGER,showMeasure:false,style:"standard",parseAsString:false,roundingMode:N.RoundingMode.TOWARDS_ZERO,emptyString:NaN,showScale:true};N.oDefaultFloatFormat={minIntegerDigits:1,maxIntegerDigits:99,minFractionDigits:0,maxFractionDigits:99,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:false,type:n.FLOAT,showMeasure:false,style:"standard",parseAsString:false,roundingMode:N.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true};N.oDefaultPercentFormat={minIntegerDigits:1,maxIntegerDigits:99,minFractionDigits:0,maxFractionDigits:99,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",percentSign:"%",isInteger:false,type:n.PERCENT,showMeasure:false,style:"standard",parseAsString:false,roundingMode:N.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true};N.oDefaultCurrencyFormat={minIntegerDigits:1,maxIntegerDigits:99,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:false,type:n.CURRENCY,showMeasure:true,currencyCode:true,currencyContext:'standard',style:"standard",customCurrencies:undefined,parseAsString:false,roundingMode:N.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true,ignorePrecision:true};N.oDefaultUnitFormat={minIntegerDigits:1,maxIntegerDigits:99,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:false,type:n.UNIT,showMeasure:true,style:"standard",customUnits:undefined,allowedUnits:undefined,parseAsString:false,roundingMode:N.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true};
N.getInstance=function(F,i){return this.getFloatInstance(F,i);};
N.getFloatInstance=function(F,i){var v=this.createInstance(F,i),w=this.getLocaleFormatOptions(v.oLocaleData,n.FLOAT);v.oFormatOptions=e({},this.oDefaultFloatFormat,w,F);return v;};
N.getIntegerInstance=function(F,i){var v=this.createInstance(F,i),w=this.getLocaleFormatOptions(v.oLocaleData,n.INTEGER);v.oFormatOptions=e({},this.oDefaultIntegerFormat,w,F);return v;};
N.getCurrencyInstance=function(F,i){var v=this.createInstance(F,i);var C=F&&F.currencyContext;var S=s(F);if(S){C=C||this.oDefaultCurrencyFormat.style;C="sap-"+C;}var w=this.getLocaleFormatOptions(v.oLocaleData,n.CURRENCY,C);v.oFormatOptions=e({},this.oDefaultCurrencyFormat,w,F);v.oFormatOptions.trailingCurrencyCode=S;v._defineCustomCurrencySymbols();return v;};
N.getUnitInstance=function(F,i){var v=this.createInstance(F,i),w=this.getLocaleFormatOptions(v.oLocaleData,n.UNIT);v.oFormatOptions=e({},this.oDefaultUnitFormat,w,F);return v;};
N.getPercentInstance=function(F,i){var v=this.createInstance(F,i),w=this.getLocaleFormatOptions(v.oLocaleData,n.PERCENT);v.oFormatOptions=e({},this.oDefaultPercentFormat,w,F);return v;};
N.createInstance=function(F,i){var v=Object.create(this.prototype),P;if(F instanceof L){i=F;F=undefined;}if(!i){i=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();}v.oLocale=i;v.oLocaleData=a.getInstance(i);v.oOriginalFormatOptions=F;if(F){if(F.pattern){P=this.parseNumberPattern(F.pattern);Object.keys(P).forEach(function(w){F[w]=P[w];});}if(F.emptyString!==undefined){c(F.emptyString===""||F.emptyString===0||F.emptyString===null||F.emptyString!==F.emptyString,"The format option 'emptyString' must be either 0, null or NaN");}}return v;};
N.getDefaultUnitPattern=function(S){return"{0} "+S;};
N.getLocaleFormatOptions=function(i,T,C){var v,w;switch(T){case n.PERCENT:w=i.getPercentPattern();break;case n.CURRENCY:w=i.getCurrencyPattern(C);break;case n.UNIT:w=i.getDecimalPattern();break;default:w=i.getDecimalPattern();}v=this.parseNumberPattern(w);v.plusSign=i.getNumberSymbol("plusSign");v.minusSign=i.getNumberSymbol("minusSign");v.decimalSeparator=i.getNumberSymbol("decimal");v.groupingSeparator=i.getNumberSymbol("group");v.percentSign=i.getNumberSymbol("percentSign");v.pattern=w;switch(T){case n.UNIT:case n.FLOAT:case n.PERCENT:v.minFractionDigits=0;v.maxFractionDigits=99;break;case n.INTEGER:v.minFractionDigits=0;v.maxFractionDigits=0;v.groupingEnabled=false;break;case n.CURRENCY:v.minFractionDigits=undefined;v.maxFractionDigits=undefined;break;}return v;};
N.parseNumberPattern=function(F){var M=0,v=0,w=0,G=false,x=0,y=0,S=F.indexOf(";"),z={Integer:0,Fraction:1},A=z.Integer;if(S!==-1){F=F.substring(0,S);}for(var i=0;i<F.length;i++){var C=F[i];switch(C){case",":if(G){x=y;y=0;}G=true;break;case".":A=z.Fraction;break;case"0":if(A===z.Integer){M++;if(G){y++;}}else{v++;w++;}break;case"#":if(A===z.Integer){if(G){y++;}}else{w++;}break;}}if(!x){x=y;y=0;}return{minIntegerDigits:M,minFractionDigits:v,maxFractionDigits:w,groupingEnabled:G,groupingSize:x,groupingBaseSize:y};};
N.prototype._defineCustomCurrencySymbols=function(){var O=this.oFormatOptions;var C=this.oLocaleData.getCurrencySymbols();var F=function(S,i){var U=[];var v;for(var K in S){v=S[K];if(U.indexOf(v)===-1){U.push(v);}else if(v!==undefined){i[v]=true;b.error("Symbol '"+v+"' is defined multiple times in custom currencies.",undefined,"NumberFormat");}}};if(O.customCurrencies&&typeof O.customCurrencies==="object"){this.mKnownCurrencySymbols={};this.mKnownCurrencyCodes={};Object.keys(O.customCurrencies).forEach(function(K){if(O.customCurrencies[K].symbol){this.mKnownCurrencySymbols[K]=O.customCurrencies[K].symbol;}else{var i=O.customCurrencies[K].isoCode;if(i){this.mKnownCurrencySymbols[K]=C[i];}}this.mKnownCurrencyCodes[K]=K;}.bind(this));}else{this.mKnownCurrencySymbols=C;this.mKnownCurrencyCodes=this.oLocaleData.getCustomCurrencyCodes();}this.mDuplicatedSymbols={};F(this.mKnownCurrencySymbols,this.mDuplicatedSymbols);};
N.prototype.format=function(v,M){if(Array.isArray(v)){M=v[1];v=v[0];}var i="",F="",G="",w="",x="",P="",y=0,z=0,A=0,C=0,D=v<0,E=-1,O=Object.assign({},this.oFormatOptions),H=this.oOriginalFormatOptions,I=O.type===n.CURRENCY&&M==="INR"&&this.oLocale.getLanguage()==="en"&&this.oLocale.getRegion()==="IN",J,S,K,Q,U,T;if(v===O.emptyString||(isNaN(v)&&isNaN(O.emptyString))){return"";}if(M&&O.customCurrencies&&!O.customCurrencies[M]){b.error("Currency '"+M+"' is unknown.");return"";}if(O.type===n.UNIT){if(O.customUnits&&typeof O.customUnits==="object"){U=O.customUnits[M];}else{T=this.oLocaleData.getUnitFromMapping(M)||M;U=this.oLocaleData.getUnitFormat(T);}O.decimals=(U&&(typeof U.decimals==="number"&&U.decimals>=0))?U.decimals:O.decimals;O.precision=(U&&(typeof U.precision==="number"&&U.precision>=0))?U.precision:O.precision;}if(O.type==n.CURRENCY){if(O.customCurrencies&&O.customCurrencies[M]){O.decimals=O.customCurrencies[M].decimals!==undefined?O.customCurrencies[M].decimals:O.decimals;}}if(O.decimals!==undefined){O.minFractionDigits=O.decimals;O.maxFractionDigits=O.decimals;}if(O.shortLimit===undefined||Math.abs(v)>=O.shortLimit){K=O.shortRefNumber===undefined?v:O.shortRefNumber;S=g(K,O,this.oLocaleData,I);if(S&&S.formatString!="0"){v=v/S.magnitude;if(O.shortDecimals!==undefined){O.minFractionDigits=O.shortDecimals;O.maxFractionDigits=O.shortDecimals;}else{if(H.minFractionDigits===undefined&&H.maxFractionDigits===undefined&&H.decimals===undefined&&H.precision===undefined&&H.pattern===undefined){O.precision=2;O.minFractionDigits=0;O.maxFractionDigits=99;}if(H.maxFractionDigits===undefined&&H.decimals===undefined){O.maxFractionDigits=99;}}O.roundingMode=N.RoundingMode.HALF_AWAY_FROM_ZERO;}}if((S||!O.ignorePrecision)&&O.precision!==undefined){O.maxFractionDigits=Math.min(O.maxFractionDigits,o(v,O.precision));O.minFractionDigits=Math.min(O.minFractionDigits,O.maxFractionDigits);}if(O.type==n.PERCENT){v=N._shiftDecimalPoint(v,2);}if(O.type==n.CURRENCY){var V=this.oLocaleData.getCurrencyDigits(M);if(O.customCurrencies&&O.customCurrencies[M]&&O.customCurrencies[M].decimals!==undefined){V=O.customCurrencies[M].decimals;}if(O.maxFractionDigits===undefined){O.maxFractionDigits=V;}if(O.minFractionDigits===undefined){O.minFractionDigits=V;}}if(typeof v==="number"){v=l(v,O.maxFractionDigits,O.roundingMode);}if(v==0){D=false;}x=this.convertToDecimal(v);if(x=="NaN"){return x;}if(D){x=x.substr(1);}E=x.indexOf(".");if(E>-1){i=x.substr(0,E);F=x.substr(E+1);}else{i=x;}if(i.length<O.minIntegerDigits){i=i.padStart(O.minIntegerDigits,"0");}else if(i.length>O.maxIntegerDigits){i="".padStart(O.maxIntegerDigits,"?");}if(F.length<O.minFractionDigits){F=F.padEnd(O.minFractionDigits,"0");}else if(F.length>O.maxFractionDigits){F=F.substr(0,O.maxFractionDigits);}z=i.length;if(O.groupingEnabled){if(I){var W=[3,2,2],X,Y=0;y=i.length;while(y>0){X=W[Y%3];y-=X;if(Y>0){G=O.groupingSeparator+G;}if(y<0){X+=y;y=0;}G=i.substr(y,X)+G;Y++;}}else{A=O.groupingSize;C=O.groupingBaseSize||A;y=Math.max(z-C,0)%A||A;G=i.substr(0,y);while(z-y>=C){G+=O.groupingSeparator;G+=i.substr(y,A);y+=A;}G+=i.substr(y);}}else{G=i;}if(D){w=O.minusSign;}w+=G;if(F){w+=O.decimalSeparator+F;}if(S&&S.formatString&&O.showScale&&O.type!==n.CURRENCY){Q=this.oLocaleData.getPluralCategory(i+"."+F);S.formatString=this.oLocaleData.getDecimalFormat(O.style,S.key,Q);w=S.formatString.replace(S.valueSubString,w);w=w.replace(/'.'/g,".");}if(O.type===n.CURRENCY){P=O.pattern;if(S&&S.formatString&&O.showScale){var Z;if(O.trailingCurrencyCode){Z="sap-short";}else{Z="short";}Q=this.oLocaleData.getPluralCategory(i+"."+F);if(I){P=h(Z,S.key,Q);}else{P=this.oLocaleData.getCurrencyFormat(Z,S.key,Q);}P=P.replace(/'.'/g,".");}J=P.split(";");if(J.length===2){P=D?J[1]:J[0];if(D){w=w.substring(O.minusSign.length);}}if(!O.currencyCode){var $;if(O.customCurrencies&&typeof O.customCurrencies==="object"){$=this.mKnownCurrencySymbols[M];}else{$=this.oLocaleData.getCurrencySymbol(M);}if($&&$!==M){M=$;}}w=this._composeCurrencyResult(P,w,M,{showMeasure:O.showMeasure,negative:D,minusSign:O.minusSign});}if(O.type===n.PERCENT){P=O.pattern;w=P.replace(/[0#.,]+/,w);w=w.replace(/%/,O.percentSign);}if(O.showMeasure&&O.type===n.UNIT){Q=this.oLocaleData.getPluralCategory(i+"."+F);c(Q,"Cannot find plural category for "+(i+"."+F));var _=!O.allowedUnits||O.allowedUnits.indexOf(M)>=0;if(!_){c(_,"The given unit '"+M+"' is not part of the allowed unit types: ["+O.allowedUnits.join(",")+"].");return"";}if(U){P=U["unitPattern-count-"+Q];if(!P){P=U["unitPattern-count-other"];}c(P,"Cannot find pattern 'unitPattern-count-"+Q+"' in '"+M+"'");if(!P){return"";}w=P.replace("{0}",w);}else if(!O.unitOptional){c(U,"Unit '"+M+"' is unknown");return"";}}if(sap.ui.getCore().getConfiguration().getOriginInfo()){w=new String(w);w.originInfo={source:"Common Locale Data Repository",locale:this.oLocale.toString()};}return w;};
N.prototype._composeCurrencyResult=function(P,F,M,O){var i=O.minusSign;P=P.replace(/[0#.,]+/,F);if(O.showMeasure&&M){var v="\u00a4",w={"[:digit:]":/\d/,"[:^S:]":/[^\$\xA2-\xA5\u058F\u060B\u09F2\u09F3\u09FB\u0AF1\u0BF9\u0E3F\u17DB\u20A0-\u20BD\uA838\uFDFC\uFE69\uFF04\uFFE0\uFFE1\uFFE5\uFFE6]/},x=P.indexOf(v),y=x<P.length/2?"after":"before",S=this.oLocaleData.getCurrencySpacing(y),C=(y==="after"?M.charAt(M.length-1):M.charAt(0)),z,A=w[S.currencyMatch],D=w[S.surroundingMatch],I;P=P.replace(v,M);z=(y==="after"?P.charAt(x+M.length):P.charAt(x-1));if(A&&A.test(C)&&D&&D.test(z)){if(y==="after"){I=x+M.length;}else{I=x;}P=P.slice(0,I)+S.insertBetween+P.slice(I);}else if(O.negative&&y==="after"){i="\ufeff"+O.minusSign;}}else{P=P.replace(/\s*\u00a4\s*/,"");}if(O.negative){P=P.replace(/-/,i);}return P;};
N.prototype.parse=function(v){var O=this.oFormatOptions,P=O.plusSign+this.oLocaleData.getLenientNumberSymbols("plusSign"),M=O.minusSign+this.oLocaleData.getLenientNumberSymbols("minusSign"),w=q(P+M),G=q(O.groupingSeparator),D=q(O.decimalSeparator),x="^\\s*(["+w+"]?(?:[0-9"+G+"]+|[0-9"+G+"]*"+D+"[0-9]*)(?:[eE][+-][0-9]+)?)\\s*$",y="^\\s*(["+w+"]?[0-9"+G+"]+)\\s*$",z=new RegExp(G,"g"),A=new RegExp(D,"g"),C=this.oLocaleData.getNumberSymbol("percentSign"),I=O.type===n.CURRENCY&&this.oLocale.getLanguage()==="en"&&this.oLocale.getRegion()==="IN",E,F,H,J,K=0,S,Q;if(v===""){Q=O.emptyString;if(O.parseAsString&&(O.emptyString===0||isNaN(O.emptyString))){Q=O.emptyString+"";}if(O.type===n.CURRENCY||O.type===n.UNIT){return[Q,undefined];}else{return Q;}}J=O.type===n.PERCENT?O.pattern:this.oLocaleData.getPercentPattern();if(J.charAt(0)==="%"){x=x.slice(0,1)+"%?"+x.slice(1);}else if(J.charAt(J.length-1)==="%"){x=x.slice(0,x.length-1)+"%?"+x.slice(x.length-1);}var U;if(O.type===n.UNIT){var T;if(O.customUnits&&typeof O.customUnits==="object"){T=O.customUnits;}else{T=this.oLocaleData.getUnitFormats();}c(T,"Unit patterns cannot be loaded");if(O.allowedUnits){var V={};for(var i=0;i<O.allowedUnits.length;i++){var W=O.allowedUnits[i];V[W]=T[W];}T=V;}var X=p(T,v);var Y=false;U=X.cldrCode;if(U.length===1){H=U[0];}else if(U.length===0){if((O.unitOptional||!O.showMeasure)&&typeof v==="string"){X.numberValue=v;}else{c(U.length===1,"Cannot find unit for input: '"+(v)+"'");return null;}}else{c(U.length===1,"Ambiguous unit ["+U.join(", ")+"] for input: '"+(v)+"'");H=undefined;Y=true;}if(O.strictParsing){if((H&&!O.showMeasure)||Y){return null;}}v=X.numberValue||v;}var Z;if(O.type===n.CURRENCY){Z=u({value:v,currencySymbols:this.mKnownCurrencySymbols,customCurrencyCodes:this.mKnownCurrencyCodes,duplicatedSymbols:this.mDuplicatedSymbols,customCurrenciesAvailable:!!O.customCurrencies});if(!Z){return null;}if(O.strictParsing){if((O.showMeasure&&!Z.currencyCode)||Z.duplicatedSymbolFound){return null;}}v=Z.numberValue;H=Z.currencyCode;if((O.customCurrencies&&H===null)||(!O.showMeasure&&H)){return null;}}if(typeof v==="string"||v instanceof String){v=v.replace(/[\u202a\u200e\u202c\u202b\u200f]/g,"");v=v.replace(/\s/g,"");}S=f(v,this.oLocaleData,I);if(S){v=S.number;}var $=j(v);if(O.isInteger&&!S&&!$){E=new RegExp(y);}else{E=new RegExp(x);}if(!E.test(v)){return O.type===n.CURRENCY||O.type===n.UNIT?null:NaN;}v=v.replace(z,"");var _=v.length;for(var a1=0;a1<_;a1++){var b1=v[a1];if(P.includes(b1)){v=v.replace(b1,"+");break;}else if(M.includes(b1)){v=v.replace(b1,"-");break;}}v=v.replace(/^\+/,"");if(S){v=v.replace(A,".");v=N._shiftDecimalPoint(v,Math.round(Math.log(S.factor)/Math.LN10));}if(O.isInteger){var c1;if($){v=v.replace(A,".");c1=k(v);if(c1===undefined){return NaN;}}else{c1=parseInt(v);}K=O.parseAsString?v:c1;}else{v=v.replace(A,".");if(v.indexOf(C)!==-1){F=true;v=v.replace(C,"");}K=O.parseAsString?v:parseFloat(v);if(F){K=N._shiftDecimalPoint(K,-2);}}if(O.parseAsString){K=N._shiftDecimalPoint(v,0);}if(O.type===n.CURRENCY||O.type===n.UNIT){return[K,H];}return K;};
N.prototype.convertToDecimal=function(v){var V=""+v,w,x,D,F,E,P;if(V.indexOf("e")==-1&&V.indexOf("E")==-1){return V;}var y=V.match(/^([+-]?)((\d+)(?:\.(\d+))?)[eE]([+-]?\d+)$/);w=y[1]=="-";x=y[2].replace(/\./g,"");D=y[3]?y[3].length:0;F=y[4]?y[4].length:0;E=parseInt(y[5]);if(E>0){if(E<F){P=D+E;V=x.substr(0,P)+"."+x.substr(P);}else{V=x;E-=F;for(var i=0;i<E;i++){V+="0";}}}else{if(-E<D){P=D+E;V=x.substr(0,P)+"."+x.substr(P);}else{V=x;E+=D;for(var i=0;i>E;i--){V="0"+V;}V="0."+V;}}if(w){V="-"+V;}return V;};
N.prototype.getScale=function(){if((this.oFormatOptions.style!=="short"&&this.oFormatOptions.style!=="long")||this.oFormatOptions.shortRefNumber===undefined){return;}var S=g(this.oFormatOptions.shortRefNumber,this.oFormatOptions,this.oLocaleData),i;if(S&&S.formatString){i=S.formatString.replace(r,"").replace(/'.'/g,".").trim();if(i){return i;}}};
N._shiftDecimalPoint=function(v,S){if(typeof S!=="number"){return NaN;}var M="";var E=v.toString().toLowerCase().split("e");if(typeof v==="number"){S=E[1]?(+E[1]+S):S;return+(E[0]+"e"+S);}else if(typeof v==="string"){if(parseFloat(v)===0&&S>=0){return d.test(v)?"0":v;}var F=E[0].charAt(0);M=F==="-"?F:"";if(M){E[0]=E[0].slice(1);}v=E[0];var D=v.indexOf("."),A,i,w;if(D===-1){v=v+".";D=v.length-1;}if(E[1]){D+=(+E[1]);}A=D+S;if(A<=0){v=v.padStart(v.length-A+1,'0');A=1;}else if(A>=v.length-1){v=v.padEnd(A+1,'0');A=v.length-1;}v=v.replace(".","");i=v.substring(0,A);w=v.substring(A);i=i.replace(/^(-?)0+(\d)/,"$1$2");return M+i+(w?("."+w):"");}else{return null;}};
function g(v,O,w,I){var S,K,x,C,y=O.style,P=O.precision!==undefined?O.precision:2;if(y!="short"&&y!="long"){return undefined;}for(var i=0;i<15;i++){K=Math.pow(10,i);if(l(Math.abs(v)/K,P-1)<10){break;}}x=K.toString();if(O.type===n.CURRENCY){if(O.trailingCurrencyCode){y="sap-short";}if(I){C=h(y,x,"other",true);}else{C=w.getCurrencyFormat(y,x,"other");}}else{C=w.getDecimalFormat(y,x,"other");}if(!C||C=="0"){return undefined;}else{S={};S.key=x;S.formatString=C;var z=C.match(r);if(z){S.valueSubString=z[0];var A=S.valueSubString.indexOf(".");if(A==-1){S.decimals=0;S.magnitude=K*Math.pow(10,1-S.valueSubString.length);}else{S.decimals=S.valueSubString.length-A-1;S.magnitude=K*Math.pow(10,1-A);}}else{return undefined;}}return S;}
function f(v,w,I){var x,F=1,K=10,P=w.getPluralCategories(),C,y={number:undefined,factor:F},G=function(A,K,S,D){if(D){C=h(S,K.toString(),A,true);}else{C=w.getDecimalFormat(S,K.toString(),A);}if(C){C=C.replace(/[\s\u00a0\u200F]/g,"");C=C.replace(/'.'/g,".");var E=C.match(r);if(E){var V=E[0];var U=C.replace(V,"");if(!U){return;}var H=v.indexOf(U);if(H>=0){x=v.replace(U,"");x=x.replace(/\u200F/g,"");F=K;F*=Math.pow(10,1-V.length);if(y.number===undefined||x.length<y.number.length){y.number=x;y.factor=F;}}}}};["long","short"].forEach(function(S){K=10;while(K<1e15){for(var i=0;i<P.length;i++){var z=P[i];G(z,K,S);}K=K*10;}});if(I&&!x){K=10;while(K<1e15){for(var i=0;i<P.length;i++){var z=P[i];G(z,K,"short",true);}K=K*10;}}if(!x){return;}return y;}
function s(F){var S=sap.ui.getCore().getConfiguration().getFormatSettings().getTrailingCurrencyCode();if(F){if(F.trailingCurrencyCode!==undefined){S=F.trailingCurrencyCode;}if(F.pattern){S=false;}if(F.currencyCode===false){S=false;}}return S;}
function h(S,K,P,D){var F,C={"short":{"1000-one":"\xa40000","1000-other":"\xa40000","10000-one":"\xa400000","10000-other":"\xa400000","100000-one":"\xa40 Lk","100000-other":"\xa40 Lk","1000000-one":"\xa400 Lk","1000000-other":"\xa400 Lk","10000000-one":"\xa40 Cr","10000000-other":"\xa40 Cr","100000000-one":"\xa400 Cr","100000000-other":"\xa400 Cr","1000000000-one":"\xa4000 Cr","1000000000-other":"\xa4000 Cr","10000000000-one":"\xa40000 Cr","10000000000-other":"\xa40000 Cr","100000000000-one":"\xa400000 Cr","100000000000-other":"\xa400000 Cr","1000000000000-one":"\xa40 Lk Cr","1000000000000-other":"\xa40 Lk Cr","10000000000000-one":"\xa400 Lk Cr","10000000000000-other":"\xa400 Lk Cr","100000000000000-one":"\xa40 Cr Cr","100000000000000-other":"\xa40 Cr Cr"},"sap-short":{"1000-one":"0000\xa0\xa4","1000-other":"0000\xa0\xa4","10000-one":"00000\xa0\xa4","10000-other":"00000\xa0\xa4","100000-one":"0 Lk\xa0\xa4","100000-other":"0 Lk\xa0\xa4","1000000-one":"00 Lk\xa0\xa4","1000000-other":"00 Lk\xa0\xa4","10000000-one":"0 Cr\xa0\xa4","10000000-other":"0 Cr\xa0\xa4","100000000-one":"00 Cr\xa0\xa4","100000000-other":"00 Cr\xa0\xa4","1000000000-one":"000 Cr\xa0\xa4","1000000000-other":"000 Cr\xa0\xa4","10000000000-one":"0000 Cr\xa0\xa4","10000000000-other":"0000 Cr\xa0\xa4","100000000000-one":"00000 Cr\xa0\xa4","100000000000-other":"00000 Cr\xa0\xa4","1000000000000-one":"0 Lk Cr\xa0\xa4","1000000000000-other":"0 Lk Cr\xa0\xa4","10000000000000-one":"00 Lk Cr\xa0\xa4","10000000000000-other":"00 Lk Cr\xa0\xa4","100000000000000-one":"0 Cr Cr\xa0\xa4","100000000000000-other":"0 Cr Cr\xa0\xa4"}},i={"short":{"1000-one":"0000","1000-other":"0000","10000-one":"00000","10000-other":"00000","100000-one":"0 Lk","100000-other":"0 Lk","1000000-one":"00 Lk","1000000-other":"00 Lk","10000000-one":"0 Cr","10000000-other":"0 Cr","100000000-one":"00 Cr","100000000-other":"00 Cr","1000000000-one":"000 Cr","1000000000-other":"000 Cr","10000000000-one":"0000 Cr","10000000000-other":"0000 Cr","100000000000-one":"00000 Cr","100000000000-other":"00000 Cr","1000000000000-one":"0 Lk Cr","1000000000000-other":"0 Lk Cr","10000000000000-one":"00 Lk Cr","10000000000000-other":"00 Lk Cr","100000000000000-one":"0 Cr Cr","100000000000000-other":"0 Cr Cr"}};i["sap-short"]=i["short"];var T=D?i:C;var v=T[S];if(!v){v=T["short"];}if(P!=="one"){P="other";}F=v[K+"-"+P];return F;}
function j(v){return v.indexOf("e")>0||v.indexOf("E")>0;}
function k(v){var i=N._shiftDecimalPoint(v,0);if(i.indexOf(".")>0&&!d.test(i.split(".")[1])){return undefined;}var F=parseFloat(i);var w=""+F;if(j(w)){w=N._shiftDecimalPoint(w,0);}var I=parseInt(w);if(I!==F){return undefined;}return I;}
function l(v,M,i){if(typeof v!=="number"){return NaN;}i=i||N.RoundingMode.HALF_AWAY_FROM_ZERO;M=parseInt(M);if(typeof i==="function"){v=i(v,M);}else{if(!M){return m[i](v);}v=N._shiftDecimalPoint(m[i](N._shiftDecimalPoint(v,M)),-M);}return v;}
function q(i){return i.replace(/([.?*+^$[\]\\(){}|-])/g,"\\$1");}
function o(v,P){var i=Math.floor(Math.log(Math.abs(v))/Math.LN10);return Math.max(0,P-i-1);}
function p(U,v){var i={numberValue:undefined,cldrCode:[]};if(typeof v!=="string"){return i;}var w=Number.POSITIVE_INFINITY;var x,K;for(x in U){for(K in U[x]){if(K.indexOf("unitPattern")===0){var y=U[x][K];var z=y.indexOf("{0}");var C=z>-1;if(C){var P=y.substring(0,z);var A=y.substring(z+"{0}".length);var M=v.startsWith(P)&&v.endsWith(A);var D=M&&v.substring(P.length,v.length-A.length);if(D){if(D.length<w){w=D.length;i.numberValue=D;i.cldrCode=[x];}else if(D.length===w&&i.cldrCode.indexOf(x)===-1){i.cldrCode.push(x);}}}else if(y===v){i.cldrCode=[x];var E;if(K.endsWith("-zero")){E="0";}else if(K.endsWith("-one")){E="1";}else if(K.endsWith("-two")){E="2";}i.numberValue=E;return i;}}}}return i;}
function t(v,C){var S="",i,w;for(var x in C){w=C[x];if(v.indexOf(w)>=0&&S.length<w.length){S=w;i=x;}}return{symbol:S,code:i};}
function u(C){var v=C.value;var M=t(v,C.currencySymbols);if(!M.code){M=t(v,C.customCurrencyCodes);if(!M.code&&!C.customCurrenciesAvailable){var i=v.match(/(^[A-Z]{3}|[A-Z]{3}$)/);M.code=i&&i[0];}}if(M.code){var w=M.code.length-1;var x=M.code.charAt(w);var D;var y=/[\-\s]+/;if(/\d$/.test(x)){if(v.startsWith(M.code)){D=w+1;if(!y.test(v.charAt(D))){return undefined;}}}else if(/^\d/.test(M.code)){if(v.endsWith(M.code)){D=v.indexOf(M.code)-1;if(!y.test(v.charAt(D))){return undefined;}}}v=v.replace(M.symbol||M.code,"");}var z=false;if(C.duplicatedSymbols&&C.duplicatedSymbols[M.symbol]){M.code=undefined;z=true;b.error("The parsed currency symbol '"+M.symbol+"' is defined multiple "+"times in custom currencies.Therefore the result is not distinct.");}return{numberValue:v,currencyCode:M.code||undefined,duplicatedSymbolFound:z};}
return N;});
sap.ui.predefine('sap/ui/core/hyphenation/HyphenationTestingWords',[],function(){"use strict";var t={"bg":"непротивоконституционствувателствувайте","ca":"Psiconeuroimmunoendocrinologia","hr":"prijestolonasljednikovičičinima","cs":"nejnezdevětadevadesáteronásobitelnějšími","da":"Gedebukkebensoverogundergeneralkrigskommandersergenten","nl":"meervoudigepersoonlijkheidsstoornissen","en-us":"pneumonoultramicroscopicsilicovolcanoconiosis","et":"Sünnipäevanädalalõpupeopärastlõunaväsimus","fi":"kolmivaihekilowattituntimittari","fr":"hippopotomonstrosesquippedaliophobie","de":"Kindercarnavalsoptochtvoorbereidingswerkzaamhedenplan","el-monoton":"ηλεκτροεγκεφαλογράφημα","hi":"किंकर्तव्यविमूढ़","hu":"Megszentségteleníthetetlenségeskedéseitekért","it":"hippopotomonstrosesquippedaliofobia","lt":"nebeprisikiškiakopūstlapiaujančiuosiuose","nb-no":"supercalifragilisticexpialidocious","pl":"dziewięćdziesięciokilkuletniemu","pt":"pneumoultramicroscopicossilicovulcanoconiose","ru":"превысокомногорассмотрительствующий","sr":"Семпаравиливичинаверсаламилитипиковски","sl":"Dialektičnomaterialističen","es":"Electroencefalografistas","sv":"Realisationsvinstbeskattning","th":"ตัวอย่างข้อความที่จะใช้ในการยืนยันการถ่ายโอน","tr":"Muvaffakiyetsizleştiricileştiriveremeyebileceklerimizdenmişsinizcesine","uk":"Нікотинамідаденіндинуклеотидфосфат"};return t;});
sap.ui.predefine('sap/ui/core/message/MessageMixin',["sap/ui/core/library","sap/base/Log","sap/ui/core/LabelEnablement"],function(l,L,a){"use strict";var V=l.ValueState;var M=function(){this.refreshDataState=r;this.fnDestroy=this.destroy;this.destroy=d;};
function r(n,D){if(D.getChanges().messages&&this.getBinding(n)&&this.getBinding(n).isA("sap.ui.model.PropertyBinding")){var m=D.getMessages();var b=a.getReferencingLabels(this);var s=b[0];var f=false;m.forEach(function(c){if(b&&b.length>0){var e=sap.ui.getCore().byId(s);if(e.getMetadata().isInstanceOf("sap.ui.core.Label")&&e.getText&&c.getAdditionalText()!==e.getText()){c.setAdditionalText(e.getText());f=true;}else{L.warning("sap.ui.core.message.Message: Can't create labelText."+"Label with id "+s+" is no valid sap.ui.core.Label.",this);}}if(c.getControlId()!==this.getId()){c.addControlId(this.getId());f=true;}}.bind(this));var o=sap.ui.getCore().getMessageManager().getMessageModel();o.checkUpdate(f,true);if(m&&m.length>0){var c=m[0];if(V[c.type]){this.setValueState(c.type);this.setValueStateText(c.message);}}else{this.setValueState(V.None);this.setValueStateText('');}}}
function d(){var c=this.getId();function b(o){o.removeControlId(c);}for(var n in this.mBindingInfos){var B=this.mBindingInfos[n];if(B.binding){var D=B.binding.getDataState();var m=D.getMessages();m.forEach(b);}}this.fnDestroy.apply(this,arguments);}
return M;},true);
sap.ui.predefine('sap/ui/core/message/MessageParser',["sap/ui/base/Object","sap/base/Log"],function(O,L){"use strict";
var M=O.extend("sap.ui.core.message.MessageParser",{
metadata:{publicMethods:["parse","setProcessor"]},
constructor:function(){this._processor=null;}
});
M.prototype.setProcessor=function(p){this._processor=p;return this;};
M.prototype.getProcessor=function(){return this._processor;};
M.prototype.parse=function(r){L.error("MessageParser: parse-method must be implemented in the specific parser class. Messages "+"have been ignored.");};
return M;});
sap.ui.predefine('sap/ui/core/mvc/Controller',['sap/base/util/ObjectPath','sap/base/util/extend','sap/ui/base/EventProvider','sap/ui/base/ManagedObject','sap/ui/core/mvc/ControllerMetadata','sap/ui/core/mvc/ControllerExtension','sap/ui/core/mvc/OverrideExecution',"sap/base/Log","sap/ui/thirdparty/jquery"],function(O,e,E,M,C,a,b,L,q){"use strict";var r={};var m={};
var c=E.extend("sap.ui.core.mvc.Controller",{
metadata:{stereotype:"controller",methods:{"byId":{"public":true,"final":true},"getView":{"public":true,"final":true},"getInterface":{"public":false,"final":true},"onInit":{"public":false,"final":false,"overrideExecution":b.After},"onExit":{"public":false,"final":false,"overrideExecution":b.Before},"onBeforeRendering":{"public":false,"final":false,"overrideExecution":b.Before},"onAfterRendering":{"public":false,"final":false,"overrideExecution":b.After}}},
constructor:function(n){var t=null;if(typeof(n)=="string"){if(!r[n]){L.warning("Do not call sap.ui.core.mvc.Controller constructor for non typed scenario!");}t=r[n];}E.apply(this,arguments);if(t){e(this,r[n]);}if(this.extension){throw new Error("The keyword 'extension' cannot be used as a member of a controller");}this["_sapui_Extensions"]={};c.extendByMember(this,false);this._sapui_isExtended=false;},
_isExtended:function(){return this._sapui_isExtended;},
getInterface:function(){var i={};var o=this.getMetadata();var p=o.getAllPublicMethods();p.forEach(function(s){var F=this[s];if(typeof F==='function'){i[s]=function(){var t=F.apply(this,arguments);return(t instanceof c)?t.getInterface():t;}.bind(this);}}.bind(this));this.getInterface=function(){return i;};return i;}
},C);
function d(o,i,l){var n=i.getMetadata().getName();var p=o.getMetadata();var s=o["_sapui_Extensions"];var I=o.getInterface();var t=a.getMetadata().getLifecycleConfiguration();var u={namespace:n,extension:i,reloadNeeded:false};i._setController(I);if(i.getMetadata().hasOverrides()){var v,w,x,y,z=i.getMetadata().getOverrides(),S=i.getMetadata().getStaticOverrides();for(y in S){x=i.getMetadata();if(!x.isMethodFinal(y)){a.overrideMethod(y,i,S,i,x.getOverrideExecution(y));}else{L.error("Method '"+y+"' of extension '"+n+"' is flagged final and cannot be overridden by calling 'override'");}}for(y in z){if(y!=='extension'){if(y in i.base){L.debug("Overriding  member '"+y+"' of original controller.");var A=z[y];var B=o[y];if(typeof B=="object"&&typeof A=="object"){w=s[y];x=w.extension.getMetadata();for(v in A){if(!x.isMethodFinal(v)){a.overrideMethod(v,B,A,i,x.getOverrideExecution(v));}else{L.error("Method '"+v+"' of extension '"+w.namespace+"' is flagged final and cannot be overridden by extension '"+n+"'");}}}else if(!p.isMethodFinal(y)){a.overrideMethod(y,o,z,i,p.getOverrideExecution(y));}else{L.error("Method '"+y+"' of controller '"+o.getMetadata().getName()+"' is flagged final and cannot be overridden by extension '"+n+"'");}}else if(y in t){a.overrideMethod(y,o,z,i,p.getOverrideExecution(y));}else{L.error("Method '"+y+"' does not exist in controller "+o.getMetadata().getName()+" and cannot be overridden");}}u.reloadNeeded=true;}if(z&&z.extension){for(var D in z.extension){x=s[D].extension.getMetadata();var F=O.create(D,o.extension);var G=s[D].extension;var H=z.extension[D];for(v in H){if(!x.isMethodFinal(v)){a.overrideMethod(v,F,H,i,x.getOverrideExecution(v));a.overrideMethod(v,G,H,i,x.getOverrideExecution(v));}else{L.error("Method '"+v+"' of extension '"+D+"' is flagged final and cannot be overridden by extension '"+n+"'");}}}}}var J=i.getInterface();if(l){s[l]=u;u.location=l;o[l]=J;I[l]=J;}else{s[n]=u;u.location="extension."+n;O.set("extension."+n,J,o);O.set("extension."+n,J,I);}}
function f(o,i,l){if(i instanceof a){d(o,i,l);}else if(i.getMetadata&&i.getMetadata().getStereotype()=="controllerextension"){var n=new i();d(o,n,l);}else{var p=a.getMetadata().getLifecycleConfiguration();for(var s in i){if(s in p){a.overrideMethod(s,o,i,o,p[s].overrideExecution);}else{a.overrideMethod(s,o,i);}}}}
function g(n,A){if(!n){throw new Error("Controller name ('sName' parameter) is required");}var s=n.replace(/\./g,"/")+".controller",i=l(sap.ui.require(s));function l(i){if(i){return i;}else if(r[n]){return c;}else{return O.get(n);}}if(A){return new Promise(function(o,p){if(!i){sap.ui.require([s],function(i){o(l(i));},p);}else{o(i);}});}else if(!i){i=sap.ui.requireSync(s);return l(i);}else{return i;}}
function h(o,A){var p=c._sExtensionProvider.replace(/\./g,"/"),P=m[p];if(A){return new Promise(function(l,n){if(p){if(P){l(P);}else{sap.ui.require([p],function(i){P=new i();m[p]=P;l(P);},n);}}else{l();}});}else if(p){if(P){return P;}else{var i=sap.ui.requireSync(p);P=new i();m[p]=P;return P;}}}
function j(i,n){var o;if(r[n]){o=new i(n);}else{o=new i();}if(!o){throw new Error("Controller "+n+" couldn't be instantiated");}return o;}
c.extendByMember=function(o,A){var s;for(s in o){if(o[s]&&o[s].getMetadata&&o[s].getMetadata().getStereotype()=="controllerextension"){o[s]=new o[s]();}}for(s in o){if(o[s]&&o[s].getMetadata&&o[s].getMetadata().getStereotype()=="controllerextension"){f(o,o[s],s);}}if(A){return Promise.resolve(o);}else{return o;}};
c.extendByCustomizing=function(o,n,A){var p=sap.ui.require('sap/ui/core/CustomizingConfiguration');if(!p){return A?Promise.resolve(o):o;}function s(z,o){return g(z,A).then(function(t){t=r[z]||t;if(t!==undefined){if(t.getMetadata&&t.getMetadata().isA("sap.ui.core.mvc.Controller")){L.warning("Attempt to load Extension Controller "+z+" was not successful","Controller extension should be a plain object.",null,function(){return{type:"ControllerExtension",name:z};});}else{f(o,t);}return o;}},function(B){L.error("Attempt to load Extension Controller "+z+" was not successful - is the Controller correctly defined in its file?");});}var t,u=[],v,w=A?Promise.resolve(o):o,x=p.getControllerExtension(n,M._sOwnerId);if(x){v=typeof x==="string"?x:x.controllerName;u=x.controllerNames||[];if(v){u.unshift(v);}}for(var i=0,l=u.length;i<l;i++){var y=u[i];if(typeof y==="string"){L.info("Customizing: Controller '"+n+"' is now extended by '"+y+"'");if(A){w=w.then(s.bind(null,y,o));}else{if(!r[y]&&!sap.ui.require(y)){g(y);}if((t=r[y])!==undefined){f(o,t);}else{L.error("Attempt to load Extension Controller "+y+" was not successful - is the Controller correctly defined in its file?",null,function(){return{type:"ControllerExtension",name:y};});}}}}return w;};
c.extendByProvider=function(o,n,s,A){if(!c._sExtensionProvider){return A?Promise.resolve(o):o;}L.info("Customizing: Controller '"+n+"' is now extended by Controller Extension Provider '"+c._sExtensionProvider+"'");var p,t;if(A){return h(o,A).then(function(t){return t.getControllerExtensions(n,s,A);}).then(function(u){if(u&&u.length){for(var i=0,l=u.length;i<l;i++){f(o,u[i]);}}return o;},function(u){L.error("Controller Extension Provider: Error '"+u+"' thrown in "+c._sExtensionProvider+"; extension provider ignored.");return o;});}else{t=h(o,A);p=t.getControllerExtensions(n,s,A);if(p&&Array.isArray(p)){for(var i=0,l=p.length;i<l;i++){f(o,p[i]);}}else{L.error("Controller Extension Provider: Error in ExtensionProvider.getControllerExtensions: "+c._sExtensionProvider+" - no valid extensions returned");}}return o;};
c.create=function(o){return k(o.name,undefined,true);};
sap.ui.controller=function(n,o,A){if(A){L.info("Do not use deprecated factory function 'sap.ui.controller("+n+")'. Use 'sap.ui.core.mvc.Controller.create(...)' instead.","sap.ui.controller",null,function(){return{type:"sap.ui.controller",name:n};});}else{L.warning("Do not use synchronous controller creation for controller '"+n+"'! Use the new asynchronous factory 'sap.ui.core.mvc.Controller.create(...)' instead.","sap.ui.controller",null,function(){return{type:"sap.ui.controller",name:n};});}return k.apply(this,arguments);};
function k(n,o,A){var i,l,s=M._sOwnerId;if(typeof o==="boolean"){o=undefined;}if(!o){if(A){return g(n,A).then(function(l){return j(l,n);}).then(function(i){return c.extendByCustomizing(i,n,A);}).then(function(i){return c.extendByProvider(i,n,s,A);}).then(function(i){i._sapui_isExtended=true;return i;});}else{l=g(n,A);i=j(l,n);i=c.extendByCustomizing(i,n,A);i=c.extendByProvider(i,n,s,A);i._sapui_isExtended=true;}return i;}else{r[n]=o;L.info("For defining controllers use Controller.extend instead");}}
c.prototype.getPublicMethods=function(){var p={},o=this.getMetadata(),i=o.getAllMethods(),l=o.getLifecycleConfiguration();Object.keys(i).forEach(function(s){if(o.isMethodPublic(s)){p[s]=i[s];p[s].reloadNeeded=!!(s in l);}});delete p.extension;var n=this["_sapui_Extensions"];Object.keys(n).forEach(function(N){var s=n[N];var t=s.extension.getInterface();var A=s.extension.getMetadata().getAllMethods();Object.keys(t).forEach(function(u){delete p[s.location];var v=e({},A[u],{reloadNeeded:s.reloadNeeded});p[s.location+"."+u]=v;});});return p;};
c.prototype.destroy=function(){Object.keys(this["_sapui_Extensions"]).forEach(function(o){O.set(o.location,null,this);}.bind(this));delete this["_sapui_Extensions"];delete this["_sapui_Interface"];E.prototype.destroy.apply(this,arguments);};
c.prototype.getView=function(){return this.oView;};
c.prototype.byId=function(i){return this.oView?this.oView.byId(i):undefined;};
c.prototype.createId=function(i){return this.oView?this.oView.createId(i):undefined;};
c.prototype.getOwnerComponent=function(){var i=sap.ui.requireSync("sap/ui/core/Component");return i.getOwnerComponentFor(this.getView());};
c.prototype.connectToView=function(v){this.oView=v;if(this.onInit){v.attachAfterInit(this.onInit,this);}if(this.onExit){v.attachBeforeExit(this.onExit,this);}if(this.onAfterRendering){v.attachAfterRendering(this.onAfterRendering,this);}if(this.onBeforeRendering){v.attachBeforeRendering(this.onBeforeRendering,this);}};
c._sExtensionProvider=null;
c.registerExtensionProvider=function(s){c._sExtensionProvider=s;};
return c;});
sap.ui.predefine('sap/ui/core/mvc/ControllerExtension',['sap/ui/base/Object','sap/ui/base/Metadata','sap/ui/core/mvc/ControllerMetadata','sap/ui/core/mvc/OverrideExecution','sap/base/util/uid',"sap/base/Log"],function(B,M,C,O,u,L){"use strict";
var a=B.extend("sap.ui.core.mvc.ControllerExtension",{
metadata:{stereotype:"controllerextension",methods:{"byId":{"public":true,"final":true},"getView":{"public":true,"final":true},"getInterface":{"public":false,"final":true}}},
_setController:function(c){this.base=c;},
byId:function(i){var n=this.getMetadata().getNamespace();i=n+"."+i;return this.base?this.base.byId(i):undefined;},
getView:function(){return this.base.getView();},
getInterface:function(){var m={};var o=this.getMetadata();var p=o.getAllPublicMethods();p.forEach(function(s){var f=this[s];if(typeof f==='function'){m[s]=function(){var t=f.apply(this,arguments);return(t instanceof a)?t.getInterface():t;}.bind(this);}}.bind(this));this.getInterface=function(){return m;};return m;}
},C);
a.override=function(e){var c=M.createClass(this,"anonymousExtension~"+u(),{},C);c.getMetadata()._staticOverride=e;c.getMetadata()._override=this.getMetadata()._override;return c;};
a.overrideMethod=function(m,o,c,b,s){var f=o[m];var d=c[m];s=s||O.Instead;function w(e){(function(d,f,b,e){o[m]=function(){if(e){d.apply(b,arguments);return f.apply(o,arguments);}else{f.apply(o,arguments);return d.apply(b,arguments);}};})(d,f,b,e);}if(typeof d==='function'&&b){d=d.bind(b);}switch(s){case O.Before:if(f&&typeof f==="function"){w(true);}else if(typeof d==="function"){o[m]=d;}else{L.error("Controller extension failed: lifecycleMethod '"+m+"', is not a function");}break;case O.After:if(f&&typeof f==="function"){w(false);}else if(typeof d==="function"){o[m]=d;}else{L.error("Controller extension failed: lifecycleMethod '"+m+"', is not a function");}break;case O.Instead:default:if(m in o){L.debug("Overriding  member '"+m+"' of extension "+this.getMetadata().getName());if(!this.getMetadata().isMethodFinal(m)){o[m]=d;}else{L.error("Error in ControllerExtension.override: Method '"+m+"' of extension '"+this.getMetadata().getName()+"' is flagged final and cannot be overridden!");}}else{o[m]=d;}break;}};
return a;});
sap.ui.predefine('sap/ui/core/mvc/ControllerMetadata',['sap/ui/base/Metadata','sap/base/util/merge','sap/ui/core/mvc/OverrideExecution',"sap/base/Log"],function(M,a,O,L){"use strict";var C=function(c,o){M.apply(this,arguments);if(this.isA("sap.ui.core.mvc.ControllerExtension")&&this.getParent().getClass().override){this.getClass().override=this.getParent().getClass().override;}};C.prototype=Object.create(M.prototype);C.prototype.constructor=C;
C.prototype.applySettings=function(c){if(c.override){this._override=c.override;delete c.override;}M.prototype.applySettings.call(this,c);var s=c.metadata;this._defaultLifecycleMethodMetadata={"onInit":{"public":true,"final":false,"overrideExecution":O.After},"onExit":{"public":true,"final":false,"overrideExecution":O.Before},"onBeforeRendering":{"public":true,"final":false,"overrideExecution":O.Before},"onAfterRendering":{"public":true,"final":false,"overrideExecution":O.After}};var i=this.isA("sap.ui.core.mvc.ControllerExtension");var r=/^_/;var e=this._oParent.isA("sap.ui.core.mvc.Controller");var d=c.metadata&&c.metadata.methods?true:false;if(!i){if(e&&!d){r=/^_|^on|^init$|^exit$/;}if(e&&d){a(s.methods,this._defaultLifecycleMethodMetadata);}}if(i||d){this._aPublicMethods=[];}this._mMethods=s.methods||{};for(var n in c){if(n!=="metadata"&&n!=="constructor"){if(!n.match(r)){if(e&&this._oParent&&this._oParent.isMethodFinal(n)){L.error("Method: '"+n+"' of controller '"+this._oParent.getName()+"' is final and cannot be overridden by controller '"+this.getName()+"'");delete this._oClass.prototype[n];}if(!(n in this._mMethods)&&typeof c[n]==='function'){if(!(c[n].getMetadata&&c[n].getMetadata().isA("sap.ui.core.mvc.ControllerExtension"))){this._mMethods[n]={"public":true,"final":false};}}}}}for(var m in this._mMethods){if(this.isMethodPublic(m)){this._aPublicMethods.push(m);}}};
C.prototype.afterApplySettings=function(){M.prototype.afterApplySettings.call(this);var i=this.isA("sap.ui.core.mvc.ControllerExtension");if(this._oParent){var p=this._oParent._mMethods?this._oParent._mMethods:{};for(var m in p){if(this._mMethods[m]&&!i){var P=this._mMethods[m].public;this._mMethods[m]=a({},p[m]);if(P!==undefined){this._mMethods[m].public=P;}if(!this.isMethodPublic(m)&&this._mMethods[m].public!==p[m].public){this._aAllPublicMethods.splice(this._aAllPublicMethods.indexOf(m),1);}}else{this._mMethods[m]=p[m];}}}if(this._oParent&&this._oParent.isA("sap.ui.core.mvc.ControllerExtension")){this._bFinal=true;}};
C.prototype.getNamespace=function(){var i=this._sClassName.indexOf("anonymousExtension~")==0;var n=i?this._oParent._sClassName:this._sClassName;return n.substr(0,n.lastIndexOf("."));};
C.prototype.isMethodFinal=function(m){var o=this._mMethods[m];return o&&o.final;};
C.prototype.isMethodPublic=function(m){var o=this._mMethods[m];return o&&o.public;};
C.prototype.getAllMethods=function(){return this._mMethods;};
C.prototype.getOverrideExecution=function(m){var o=this._mMethods[m];var s=O.Instead;if(o){s=o.overrideExecution;}return s;};
C.prototype.getOverrides=function(){return this._override;};
C.prototype.getStaticOverrides=function(){return this._staticOverride;};
C.prototype.hasOverrides=function(){return!!this._override||!!this._staticOverride;};
C.prototype.getLifecycleConfiguration=function(){return this._defaultLifecycleMethodMetadata;};
return C;});
sap.ui.predefine('sap/ui/core/mvc/EventHandlerResolver',["sap/ui/base/BindingParser","sap/ui/core/CommandExecution","sap/ui/model/BindingMode","sap/ui/model/CompositeBinding","sap/ui/model/json/JSONModel","sap/ui/model/base/ManagedObjectModel","sap/base/util/JSTokenizer","sap/base/util/ObjectPath","sap/base/util/resolveReference","sap/base/Log"],function(B,C,a,b,J,M,c,O,r,L){"use strict";var E={resolveEventHandler:function(n,o,l){var h,s,f;n=n.trim();if(sap.ui.getCore().getConfiguration().getControllerCodeDeactivated()){h=function(){};}else{if(n.startsWith("cmd:")){var d=n.substr(4);h=function(e){var j=C.find(e.getSource(),d);if(j){j.trigger();}else{L.error("Handler '"+n+"' could not be resolved. No CommandExecution defined for command: "+d);}};h._sapui_commandName=d;}else{s=n.indexOf("(");f=n;if(s>0){f=n.substring(0,s).trim();}else if(s===0){throw new Error("Event handler name starts with a bracket, must start with a function name "+"(or with a dot followed by controller-local function name): "+n);}h=r(f,Object.assign({".":o},l),{preferDotContext:f.indexOf(".")===-1,bindContext:false});}if(h&&s>0){var i=n.lastIndexOf(")");if(i>s){if(n.substring(s).indexOf("{=")>-1){L.warning("It looks like an event handler parameter contains a binding expression ({=...}). This is not allowed and will cause an error later on "+"because the entire event handler is already considered an expression: "+n);}h=(function(f,o){return function(j){var p,S,k=n;if(n.indexOf("$parameters")>-1){p=new J(j.mParameters);}if(n.indexOf("$source")>-1){S=new M(j.getSource());}var m={"$controller":o,$event:j};if(f.indexOf(".")>0){var G=f.split(".")[0];m[G]=window[G];}else if(f.indexOf(".")===-1){if(o&&o[f]){k="$controller."+k;}else if(window[f]){m[f]=window[f];}}Object.assign(m,l);var q=B.parseExpression(k.replace(/^\./,"$controller."),0,{oContext:o},m);if(q.result){try{g(q.result,j.getSource(),o,p,S);}catch(e){e.message="Error when evaluating event handler '"+n+"': "+e.message;throw e;}}if(p){p.destroy();}if(S){S.destroy();}};})(f,o);}else{L.error("Syntax error in event handler '"+n+"': arguments must be enclosed in a pair of brackets");}}}if(typeof h==="function"){h._sapui_handlerName=n;return[h,o];}L.warning("Event handler name '"+n+"' could not be resolved to an event handler function");},parse:function e(v){v=v.trim();var t=new c();var R=[];var s="";var p=0;t.init(v,0);for(;;){var S=t.next();if(S==='"'||S==="'"){var d=t.getIndex();t.string();s+=v.slice(d,t.getIndex());S=t.getCh();}if(!S){break;}switch(S){case"(":p++;break;case")":p--;break;}if(S===";"&&p===0){R.push(s.trim());s="";}else{s+=S;}}if(s){R.push(s.trim());}return R;}};
function g(o,e,d,p,s){var t,P;o.mode=a.OneWay;if(!o.parts){o.parts=[];o.parts[0]={path:o.path,targetType:o.targetType,type:o.type,suspended:o.suspended,formatOptions:o.formatOptions,constraints:o.constraints,model:o.model,mode:o.mode};delete o.path;delete o.targetType;delete o.mode;delete o.model;}for(var i=0;i<o.parts.length;i++){P=o.parts[i];if(typeof P=="string"){P={path:P};o.parts[i]=P;}if(!P.path&&P.parts){throw new Error("Bindings in event handler parameters cannot use parts. Just use one single path.");}var S=P.path.indexOf(">");if(S>0){P.model=P.path.substr(0,S);P.path=P.path.substr(S+1);}}var f,h,j,k=[];o.parts.forEach(function(P){var m;if(P.model==="$parameters"){m=p;h=p.createBindingContext("/");}else if(P.model==="$source"){m=s;h=s.createBindingContext("/");}else{m=e.getModel(P.model);h=e.getBindingContext(P.model);}t=P.type;if(typeof t=="string"){f=O.get(t);if(typeof f!=="function"){throw new Error("Cannot find type \""+t+"\" used for binding \""+P.path+"\"!");}t=new f(P.formatOptions,P.constraints);}j=m.bindProperty(P.path,h,o.parameters);j.setType(t,P.targetType||"any");j.setFormatter(P.formatter);j.setBindingMode(a.OneTime);k.push(j);});if(k.length>1||(o.formatter&&o.formatter.textFragments)){t=o.type;if(typeof t=="string"){f=O.get(t);t=new f(o.formatOptions,o.constraints);}j=new b(k,o.useRawValues,o.useInternalValues);j.setType(t,P.targetType||"any");j.setBindingMode(a.OneTime);}else{j=k[0];}j.setFormatter(o.formatter);j.initialize();return j.getExternalValue();}
return E;});
sap.ui.predefine('sap/ui/core/mvc/HTMLView',['sap/ui/thirdparty/jquery','./View','./HTMLViewRenderer','sap/base/util/merge','sap/ui/base/ManagedObject','sap/ui/core/DeclarativeSupport','sap/ui/core/library','sap/ui/model/resource/ResourceModel','sap/base/util/LoaderExtensions'],function(q,V,H,m,M,D,l,R,L){"use strict";var a=l.mvc.ViewType;
var b=V.extend("sap.ui.core.mvc.HTMLView",{metadata:{library:"sap.ui.core"}});
b.create=function(o){var p=m({},o);p.type=a.HTML;return V.create(p);};
sap.ui.htmlview=function(i,v){return sap.ui.view(i,v,a.HTML);};
b._sType=a.HTML;b.asyncSupport=true;b._mTemplates={};b._mAllowedSettings={"viewName":true,"controller":true,"viewContent":true,"definition":true,"controllerName":true,"resourceBundleName":true,"resourceBundleUrl":true,"resourceBundleLocale":true,"resourceBundleAlias":true};
b._getTemplate=function(t,o){var u=this._getViewUrl(t);var h=this._mTemplates[u];if(!h){h=this._loadTemplate(t,o);if(o&&o.async){var c=this;return h.then(function(_){c._mTemplates[u]=_;return Promise.resolve(_);});}else{this._mTemplates[u]=h;}}return o.async?Promise.resolve(h):h;};
b.prototype.getControllerName=function(){return this._controllerName;};
b._getViewUrl=function(t){return sap.ui.require.toUrl(t.replace(/\./g,"/"))+".view.html";};
b._loadTemplate=function(t,o){var r=t.replace(/\./g,"/")+".view.html";return L.loadResource(r,o);};
b.prototype.initViewSettings=function(s){if(!s){throw new Error("mSettings must be given");}if(s.viewName&&s.viewContent){throw new Error("View name and view content are given. There is no point in doing this, so please decide.");}else if(!s.viewName&&!s.viewContent){throw new Error("Neither view name nor view content is given. One of them is required.");}var t=this;function I(){t._oTemplate=document.createElement("div");if(typeof h==="string"){t._oTemplate.innerHTML=h;}else{var n=h;var f=document.createDocumentFragment();for(var i=0;i<n.length;i++){f.appendChild(n.item(i));}t._oTemplate.appendChild(f);}var o=t._oTemplate.getElementsByTagName("template")[0];var p=t.getMetadata().getAllProperties();if(o){q.each(o.attributes,function(d,A){var N=D.convertAttributeToSettingName(A.name,t.getId());var v=A.value;var P=p[N];if(!s[N]){if(P){s[N]=D.convertValueToType(D.getPropertyDataType(P),v);}else if(b._mAllowedSettings[N]){s[N]=v;}}});t._oTemplate=o;}if(t._oTemplate.content){var f=t._oTemplate.content;t._oTemplate=document.createElement("div");t._oTemplate.appendChild(f);}if(s.controllerName){t._controllerName=s.controllerName;}if((s.resourceBundleName||s.resourceBundleUrl)&&(!s.models||!s.models[s.resourceBundleAlias])){var c=new R({bundleName:s.resourceBundleName,bundleUrl:s.resourceBundleUrl,bundleLocale:s.resourceBundleLocale,async:s.async});var B=c.getResourceBundle();if(B instanceof Promise){return B.then(function(){t.setModel(c,s.resourceBundleAlias);});}t.setModel(c,s.resourceBundleAlias);}}var h=s.viewContent;if(!h){h=b._getTemplate(s.viewName,{async:s.async});}if(s.async){return h.then(function(_){h=_;return I();});}I();};
b.prototype.onControllerConnected=function(c){var t=this;M.runWithPreprocessors(function(){D.compile(t._oTemplate,t);},{settings:this._fnSettingsPreprocessor});};
b.prototype.exit=function(){this._oTemplate=null;V.prototype.exit.call(this);if(this._connectedControls){for(var i=0;i<this._connectedControls.length;i++){this._connectedControls[i].destroy();}this._connectedControls=null;}};
b.prototype.connectControl=function(c){this._connectedControls=this._connectedControls||[];this._connectedControls.push(c);};
return b;});
sap.ui.predefine('sap/ui/core/mvc/HTMLViewRenderer',['./ViewRenderer'],function(V){"use strict";var H={apiVersion:1};
H.render=function(r,c){r.openStart("div",c);r.class("sapUiView");r.class("sapUiHTMLView");V.addDisplayClass(r,c);r.style("width",c.getWidth());r.style("height",c.getHeight());r.openEnd();if(c._oTemplate){var h=c._oTemplate.innerHTML;var a=c.getContent();var d=[];var b=function(c){var t=H._getHTML(r,c,h);if(t){h=t;}else{d.push(c);}};if(a){if(Array.isArray(a)){for(var i=0;i<a.length;i++){b(a[i]);}}else if(a){b(a);}}r.unsafeHtml(h);for(var i=0;i<d.length;i++){r.renderControl(d[i]);}}r.close("div");};
H._getHTML=function(r,c,h){var i=c.getId();h=h.replace(/(<div)/gi,"\n$1");var a=new RegExp('<div.*?data-sap-ui-id="'+i+'".*?></div>',"gi");var m=a.exec(h);if(m){h=h.replace(m[0],r.getHTML(c));return h;}else{return"";}};
return H;},true);
sap.ui.predefine('sap/ui/core/mvc/JSONView',['sap/ui/thirdparty/jquery','./View','./JSONViewRenderer','./EventHandlerResolver','sap/base/util/merge','sap/ui/base/ManagedObject','sap/ui/core/library','sap/ui/model/resource/ResourceModel','sap/base/Log','sap/base/util/LoaderExtensions'],function(q,V,J,E,m,M,l,R,L,a){"use strict";var b=l.mvc.ViewType;
var c=V.extend("sap.ui.core.mvc.JSONView",{metadata:{library:"sap.ui.core"}});
c.create=function(o){var p=m({},o);for(var O in p){if(O==='preprocessors'){delete p['preprocessors'];L.warning("JSView.create does not support the option preprocessors!");}}p.type=b.JSON;return V.create(p);};
sap.ui.jsonview=function(i,v){return sap.ui.view(i,v,b.JSON);};
c._sType=b.JSON;c.asyncSupport=true;
c.prototype.initViewSettings=function(s){if(!s){throw new Error("mSettings must be given");}if(s.viewName&&s.viewContent){throw new Error("View name and view content are given. There is no point in doing this, so please decide.");}else if(!s.viewName&&!s.viewContent){throw new Error("Neither view name nor view content is given. One of them is required.");}var t=this;var i=function(){if((t._oJSONView.resourceBundleName||t._oJSONView.resourceBundleUrl)&&(!s.models||!s.models[t._oJSONView.resourceBundleAlias])){var o=new R({bundleName:t._oJSONView.resourceBundleName,bundleUrl:t._oJSONView.resourceBundleUrl,async:s.async});var B=o.getResourceBundle();if(B instanceof Promise){return B.then(function(){t.setModel(o,t._oJSONView.resourceBundleAlias);});}t.setModel(o,t._oJSONView.resourceBundleAlias);}};if(s.viewName){if(s.async){return this._loadTemplate(s.viewName,{async:true}).then(i);}else{this._loadTemplate(s.viewName);i();}}else if(s.viewContent){this.mProperties["viewContent"]=s.viewContent;if(typeof s.viewContent==="string"){this._oJSONView=JSON.parse(s.viewContent);if(!this._oJSONView){throw new Error("error when parsing viewContent: "+s.viewContent);}}else if(typeof s.viewContent==="object"){this._oJSONView=s.viewContent;}else{throw new Error("viewContent must be a JSON string or object, but is a "+(typeof s.viewContent));}if(s.async){return Promise.resolve().then(i);}else{i();}}};
c.prototype.onControllerConnected=function(C){var t=this;M.runWithPreprocessors(function(){t.applySettings({content:t._oJSONView.content},C);},{id:function(i){return t.createId(i);},settings:function(s){var o=this.getMetadata(),v=o.getJSONKeys(),k,d,K;for(k in s){if((K=v[k])!==undefined){d=s[k];switch(K._iKind){case 3:if(typeof d==="string"){s[k]=t.createId(d);}break;case 5:if(typeof d==="string"){s[k]=E.resolveEventHandler(d,C);}break;}}}}});};
c.prototype._loadTemplate=function(t,o){var r=t.replace(/\./g,"/")+".view.json";if(!o||!o.async){this._oJSONView=a.loadResource(r);}else{var d=this;return a.loadResource(r,o).then(function(j){d._oJSONView=j;});}};
c.prototype.getControllerName=function(){return this._oJSONView.controllerName;};
return c;});
sap.ui.predefine('sap/ui/core/mvc/JSONViewRenderer',['./ViewRenderer','sap/ui/core/Control'],function(V,C){"use strict";var J={apiVersion:2};
J.render=function(r,c){r.openStart("div",c);r.class("sapUiView");r.class("sapUiJSONView");V.addDisplayClass(r,c);r.style("width",c.getWidth());r.style("height",c.getHeight());r.openEnd();c.getContent().forEach(r.renderControl,r);r.close("div");};
return J;},true);
sap.ui.predefine('sap/ui/core/mvc/JSView',['./View','./JSViewRenderer','sap/base/util/extend','sap/base/util/merge','sap/ui/base/ManagedObject','sap/ui/core/library','sap/base/Log'],function(V,J,m,e,M,l,L){"use strict";
var a=V.extend("sap.ui.core.mvc.JSView",{metadata:{library:"sap.ui.core"}});
var r={};a.asyncSupport=true;var b=l.mvc.ViewType;
a.create=function(o){var p=m({},o);for(var O in p){if(O==='definition'||O==='preprocessors'){delete p[O];L.warning("JSView.create does not support the options definition or preprocessor!");}}p.type=b.JS;return V.create(p);};
sap.ui.jsview=function(i,c,A){var f=function(s){L[s]("Do not use deprecated view factory functions. "+"Use the static create function on the specific view module instead: [XML|JS|HTML|JSON]View.create().","sap.ui.view",null,function(){return{type:"sap.ui.view",name:i||(c&&c.name)};});};if(c&&c.async){f("info");}else{f("warning");}return v.apply(this,arguments);};
function v(i,c,A){var s={},o;if(c&&typeof(c)=="string"){s.viewName=c;if(typeof arguments[2]=="boolean"){s.async=A;}else if(typeof arguments[2]=="object"){s.controller=arguments[2];s.async=!!arguments[3];}o=new a(i,s);return o;}else if(c&&typeof(c)=="object"){r[i]=c;sap.ui.loader._.declareModule(i.replace(/\./g,"/")+".view.js");L.info("For defining views use JSView.extend instead.");}else if(arguments.length==1&&typeof i=="string"||arguments.length==2&&typeof arguments[0]=="string"&&typeof arguments[1]=="boolean"){s.viewName=arguments[0];s.async=!!arguments[1];o=s.id?new a(s.id,s):new a(s);return o;}else{throw new Error("Wrong arguments ('"+i+"', '"+c+"')! Either call sap.ui.jsview([sId,] sViewName) to instantiate a View or sap.ui.jsview(sViewName, oViewImpl) to define a View type.");}}
a.prototype.initViewSettings=function(s){var p;if(!r[s.viewName]){var c=s.viewName.replace(/\./g,"/")+".view";if(s.async){p=new Promise(function(d,f){sap.ui.require([c],d,f);});}else{sap.ui.requireSync(c);}}if(s.async){return Promise.resolve(p).then(function(){e(this,r[s.viewName]);}.bind(this));}e(this,r[s.viewName]);};
a.prototype.onControllerConnected=function(c){M.runWithPreprocessors(function(){this.applySettings({content:this.createContent(c)});},{id:this.getAutoPrefixId()?this.createId.bind(this):undefined,settings:this._fnSettingsPreprocessor},this);};
a.prototype.getAutoPrefixId=function(){return false;};
return a;});
sap.ui.predefine('sap/ui/core/mvc/JSViewRenderer',['./ViewRenderer'],function(V){"use strict";var J={apiVersion:2};
J.render=function(r,c){r.openStart("div",c);r.class("sapUiView");r.class("sapUiJSView");V.addDisplayClass(r,c);r.style("width",c.getWidth());r.style("height",c.getHeight());r.openEnd();c.getContent().forEach(r.renderControl,r);r.close("div");};
return J;},true);
sap.ui.predefine('sap/ui/core/mvc/OverrideExecution',function(){"use strict";var O={After:"After",Before:"Before",Instead:"Instead"};return O;},true);
sap.ui.predefine('sap/ui/core/mvc/TemplateView',['sap/ui/core/library','./View',"./TemplateViewRenderer","sap/base/Log"],function(l,V,T,L){"use strict";var a=l.mvc.ViewType;
var b=V.extend("sap.ui.core.mvc.TemplateView",{metadata:{library:"sap.ui.core"}});
(function(){
sap.ui.templateview=function(i,v){L.warning("sap.ui.core.mvc.TemplateView is deprecated. Use XMLView or JSView instead.");return sap.ui.view(i,v,a.Template);};
b._sType=a.Template;
b.prototype.getControllerName=function(){return this._sControllerName;};
b._getViewUrl=function(t){return sap.ui.require.toUrl(t.replace(/\./g,"/"))+".view.tmpl";};
b.prototype.initViewSettings=function(s){if(!s){throw new Error("mSettings must be given");}if(!s.viewName){throw new Error("No view name is given.");}this._oTemplate=sap.ui.template({id:this.getId(),src:b._getViewUrl(s.viewName)});this._sControllerName=this._oTemplate._sControllerName;this._oTemplate=this._oTemplate.createControl(undefined,undefined,this);this.addContent(this._oTemplate);};
}());return b;});
sap.ui.predefine('sap/ui/core/mvc/TemplateViewRenderer',['./ViewRenderer'],function(V){"use strict";var T={apiVersion:2};
T.render=function(r,c){r.openStart("div",c);r.class("sapUiView");r.class("sapUiTmplView");V.addDisplayClass(r,c);r.style("width",c.getWidth());r.style("height",c.getHeight());r.openEnd();r.renderControl(c._oTemplate);r.close("div");};
return T;},true);
sap.ui.predefine('sap/ui/core/mvc/View',['sap/ui/base/ManagedObject','sap/ui/core/Control','sap/ui/core/mvc/Controller','sap/base/util/merge','sap/ui/core/library',"./ViewRenderer","sap/base/assert","sap/base/Log","sap/base/util/extend"],function(M,C,a,m,b,V,c,L,d){"use strict";var f=b.mvc.ViewType;
var g=C.extend("sap.ui.core.mvc.View",{metadata:{interfaces:["sap.ui.core.IDScope"],library:"sap.ui.core",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},viewName:{type:"string",group:"Misc",defaultValue:null},displayBlock:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}},events:{afterInit:{},beforeExit:{},afterRendering:{},beforeRendering:{}},specialSettings:{controller:'sap.ui.core.mvc.Controller',controllerName:'string',preprocessors:'Object',resourceBundleName:'string',resourceBundleUrl:'sap.ui.core.URI',resourceBundleLocale:'string',resourceBundleAlias:'string',type:'string',definition:'any',viewContent:{type:'any',deprecated:true},viewData:'any',async:{type:"boolean",defaultValue:false}},designtime:"sap/ui/core/designtime/mvc/View.designtime"}});
g._mPreprocessors={};
function h(P){P._settings={};for(var e in P){if(e.indexOf("_")!==0){P._settings[e]=P[e];}}}
function k(P,A){var e;if(typeof P.preprocessor==="string"){var i=P.preprocessor.replace(/\./g,"/");if(A){return new Promise(function(j,l){sap.ui.require([i],function(e){j(e);},l);});}else{return sap.ui.requireSync(i);}}else if(typeof P.preprocessor==="function"&&!P.preprocessor.process){e={process:P.preprocessor};}else{e=P.preprocessor;}if(A){return Promise.resolve(e);}else{return e;}}
function n(e,T){var j=this.mPreprocessors[T]||[],G=[],i,l,O,P=[];if(g._mPreprocessors[e]&&g._mPreprocessors[e][T]){G=g._mPreprocessors[e][T].map(function(x){return Object.assign({},x);});}for(i=0,l=G.length;i<l;i++){if(G[i]._onDemand){O=G[i];}else{P.push(G[i]);}}for(i=0,l=j.length;i<l;i++){var I=!j[i].preprocessor;if(I&&O){P.unshift(d(j[i],O));}else if(!I){P.push(j[i]);}}return P;}
function o(e,S){var i=e.getMetadata().getClass();function j(P){P.preprocessor=k(P,S.async);}e.mPreprocessors=Object.assign({},S.preprocessors);for(var _ in i.PreprocessorType){var T=i.PreprocessorType[_];if(e.mPreprocessors[T]&&!Array.isArray(e.mPreprocessors[T])){e.mPreprocessors[T]=[e.mPreprocessors[T]];}else if(!e.mPreprocessors[T]){e.mPreprocessors[T]=[];}e.mPreprocessors[T].forEach(h);e.mPreprocessors[T]=n.call(e,i._sType,T);e.mPreprocessors[T].forEach(j);}}
function p(e){e.oAsyncState={};e.oAsyncState.promise=null;}
var q=function(T,S){if(!sap.ui.getCore().getConfiguration().getControllerCodeDeactivated()){var e=S.controller,N=e&&typeof e.getMetadata==="function"&&e.getMetadata().getName(),A=S.async;if(!e&&T.getControllerName){var i=T.getControllerName();if(i){var j=sap.ui.require('sap/ui/core/CustomizingConfiguration');var l=j&&j.getControllerReplacement(i,M._sOwnerId);if(l){i=typeof l==="string"?l:l.controllerName;}if(A){e=a.create({name:i});}else{e=sap.ui.controller(i,true);}}}else if(e){var O=M._sOwnerId;if(!e._isExtended()){if(A){e=a.extendByCustomizing(e,N,A).then(function(e){return a.extendByProvider(e,N,O,A);});}else{e=a.extendByCustomizing(e,N,A);e=a.extendByProvider(e,N,O,A);}}else if(A){e=Promise.resolve(e);}}if(e){var x=function(e){T.oController=e;e.oView=T;};if(A){if(!T.oAsyncState){throw new Error("The view "+T.sViewName+" runs in sync mode and therefore cannot use async controller extensions!");}return e.then(x);}else{x(e);}}}else{sap.ui.controller("sap.ui.core.mvc.EmptyControllerImpl",{"_sap.ui.core.mvc.EmptyControllerImpl":true});T.oController=sap.ui.controller("sap.ui.core.mvc.EmptyControllerImpl");}};
g.prototype._initCompositeSupport=function(S){c(!S.preprocessors||this.getMetadata().getName().indexOf("XMLView"),"Preprocessors only available for XMLView");this.oViewData=S.viewData;this.sViewName=S.viewName;var i=this;o(this,S);if(S.async){p(this);}var j=sap.ui.require('sap/ui/core/CustomizingConfiguration');if(j&&j.hasCustomProperties(this.sViewName,this)){this._fnSettingsPreprocessor=function(S){var I=this.getId();if(j&&I){if(i.isPrefixedId(I)){I=I.substring((i.getId()+"--").length);}var e=j.getCustomProperties(i.sViewName,I,i);if(e){S=d(S,e);}}};}var P=function(e,l){c(typeof e==="function","fn must be a function");var x=sap.ui.require("sap/ui/core/Component");var O=x&&x.getOwnerComponentFor(i);if(O){if(l){i.fnScopedRunWithOwner=i.fnScopedRunWithOwner||function(y){return O.runAsOwner(y);};}return O.runAsOwner(e);}return e();};var A=function(e){if(e.oController&&e.oController.connectToView){return e.oController.connectToView(e);}};var F=function(){if(i.onControllerConnected){return i.onControllerConnected(i.oController);}};if(this.initViewSettings){if(S.async){this.oAsyncState.promise=this.initViewSettings(S).then(function(){return P(q.bind(null,i,S),true);}).then(function(){return P(F,true);}).then(function(){return A(i);}).then(function(){return i.runPreprocessor("controls",i,false);}).then(function(){return P(i.fireAfterInit.bind(i),true);}).then(function(){return i;}).catch(function(e){this.deregister();throw e;}.bind(this));}else{this.initViewSettings(S);q(this,S);F();A(this);this.runPreprocessor("controls",this,true);this.fireAfterInit();}}};
g.prototype.getController=function(){return this.oController;};
g.prototype.byId=function(i){return sap.ui.getCore().byId(this.createId(i));};
g.prototype.createId=function(i){if(!this.isPrefixedId(i)){i=this.getId()+"--"+i;}return i;};
g.prototype.getLocalId=function(i){var P=this.getId()+"--";return(i&&i.indexOf(P)===0)?i.slice(P.length):null;};
g.prototype.isPrefixedId=function(i){return!!(i&&i.indexOf(this.getId()+"--")===0);};
g.prototype.getViewData=function(){return this.oViewData;};
function r(){this.oAsyncState=null;}
g.prototype.exit=function(){this.fireBeforeExit();delete this.oController;delete this.oPreprocessorInfo;if(this.oAsyncState){var D=r.bind(this);this.oAsyncState.promise.then(D,D);}};
g.prototype.onAfterRendering=function(){this.fireAfterRendering();};
g.prototype.onBeforeRendering=function(){this.fireBeforeRendering();};
g.prototype.clone=function(i,l){var S={},K,e;for(K in this.mProperties&&!(this.isBound&&this.isBound(K))){if(this.mProperties.hasOwnProperty(K)){S[K]=this.mProperties[K];}}e=C.prototype.clone.call(this,i,l,{cloneChildren:false,cloneBindings:true});var E,x,j;for(E in e.mEventRegistry){x=e.mEventRegistry[E];for(j=x.length-1;j>=0;j--){if(x[j].oListener===this.getController()){x[j]={oListener:e.getController(),fFunction:x[j].fFunction,oData:x[j].oData};}}}e.applySettings(S);return e;};
g.prototype.getPreprocessors=function(){return this.mPreprocessors;};
g.prototype.getPreprocessorInfo=function(S){if(!this.oPreprocessorInfo){this.oPreprocessorInfo={name:this.sViewName,componentId:this._sOwnerId,id:this.getId(),caller:this+" ("+this.sViewName+")",sync:!!S};}if(g._supportInfo){this.oPreprocessorInfo._supportInfo=g._supportInfo;}return this.oPreprocessorInfo;};
g.prototype.runPreprocessor=function(T,S,e){var j=this.getPreprocessorInfo(e),P=this.mPreprocessors&&this.mPreprocessors[T]||[],x,A,y;if(!e){A=function(j,z){return function(S){return z.preprocessor.then(function(B){return B.process(S,j,z._settings);});};};y=Promise.resolve(S);}for(var i=0,l=P.length;i<l;i++){if(e&&P[i]._syncSupport===true){x=P[i].preprocessor.process;S=x(S,j,P[i]._settings);}else if(!e){y=y.then(A(j,P[i]));}else{L.debug("Async \""+T+"\"-preprocessor was skipped in sync view execution for "+this.getMetadata().getClass()._sType+"View",this.getId());}}return e?S:y;};
function s(T,e){if(!g._mPreprocessors[e]){g._mPreprocessors[e]={};}if(!g._mPreprocessors[e][T]){g._mPreprocessors[e][T]=[];}}
function t(e,i,T){g._mPreprocessors[i][T].forEach(function(P){if(P._onDemand){L.error("Registration for \""+T+"\" failed, only one on-demand-preprocessor allowed",e.getMetadata().getName());return false;}});return true;}
g.registerPreprocessor=function(T,P,e,S,O,i){if(typeof O!=="boolean"){i=O;O=false;}if(P){s(T,e);if(O&&!t(this,e,T)){return;}g._mPreprocessors[e][T].push({preprocessor:P,_onDemand:O,_syncSupport:S,_settings:i});L.debug("Registered "+(O?"on-demand-":"")+"preprocessor for \""+T+"\""+(S?" with syncSupport":""),this.getMetadata().getName());}else{L.error("Registration for \""+T+"\" failed, no preprocessor specified",this.getMetadata().getName());}};
g.prototype.hasPreprocessor=function(T){return!!this.mPreprocessors[T].length;};
g.create=function(O){var P=m({},O);P.async=true;P.viewContent=P.definition;var e=sap.ui.require("sap/ui/core/Component");var i;if(e&&M._sOwnerId){i=e.get(M._sOwnerId);}function w(){return v(P.id,P,P.type).loaded();}return new Promise(function(j,l){var x=u(P);sap.ui.require([x],function(y){j(y);},l);}).then(function(j){if(j.getMetadata().isA("sap.ui.core.mvc.XMLView")){P.processingMode="sequential";}if(i){return i.runAsOwner(w);}else{return w();}});};
g._legacyCreate=v;
sap.ui.view=function(i,e,T){var l=function(j){var N="";if(typeof i=="object"){N=i.viewName;}N=N||(e&&e.name);L[j]("Do not use deprecated view factory functions ("+N+"). "+"Use the static create function on the view module instead: [XML|JS|HTML|JSON|]View.create().","sap.ui.view",null,function(){return{type:"sap.ui.view",name:N};});};if(e&&e.async){l("info");}else{l("warning");}return v(i,e,T);};
function v(i,e,T){var j=null,l={};if(typeof i==="object"||typeof i==="string"&&e===undefined){e=i;i=undefined;}if(e){if(typeof e==="string"){l.viewName=e;}else{l=e;}}c(!l.async||typeof l.async==="boolean","sap.ui.view factory: Special setting async has to be of the type 'boolean'!");if(i){l.id=i;}if(T){l.type=T;}var x=sap.ui.require('sap/ui/core/CustomizingConfiguration');if(x){var y=x.getViewReplacement(l.viewName,M._sOwnerId);if(y){L.info("Customizing: View replacement for view '"+l.viewName+"' found and applied: "+y.viewName+" (type: "+y.type+")");d(l,y);}else{L.debug("Customizing: no View replacement found for view '"+l.viewName+"'.");}}var z=u(l);j=w(z,l);return j;}
function u(e){var i;if(!e.type){throw new Error("No view type specified.");}else if(e.type===f.JS){i='sap/ui/core/mvc/JSView';}else if(e.type===f.JSON){i='sap/ui/core/mvc/JSONView';}else if(e.type===f.XML){i='sap/ui/core/mvc/XMLView';}else if(e.type===f.HTML){i='sap/ui/core/mvc/HTMLView';}else if(e.type===f.Template){i='sap/ui/core/mvc/TemplateView';}else{throw new Error("Unknown view type "+e.type+" specified.");}return i;}
function w(e,i){var j=sap.ui.require(e);if(!j){j=sap.ui.requireSync(e);if(i.async){L.warning("sap.ui.view was called without requiring the according view class.");}}return new j(i);}
g.prototype.loaded=function(){if(this.oAsyncState&&this.oAsyncState.promise){return this.oAsyncState.promise;}else{return Promise.resolve(this);}};
return g;});
sap.ui.predefine('sap/ui/core/mvc/ViewRenderer',function(){"use strict";var V={};
V.addDisplayClass=function(r,c){if(c.getDisplayBlock()||(c.getWidth()==="100%"&&c.getHeight()==="100%")){r.class("sapUiViewDisplayBlock");}};
return V;},true);
sap.ui.predefine('sap/ui/core/mvc/XMLView',['sap/ui/thirdparty/jquery','./View',"./XMLViewRenderer","sap/base/util/deepExtend",'sap/ui/base/ManagedObject','sap/ui/core/XMLTemplateProcessor','sap/ui/core/library','sap/ui/core/Control','sap/ui/core/RenderManager','sap/ui/core/cache/CacheManager','sap/ui/model/resource/ResourceModel','sap/ui/util/XMLHelper','sap/base/strings/hash','sap/base/Log','sap/base/util/LoaderExtensions',"sap/ui/performance/trace/Interaction"],function(q,V,X,d,M,a,l,C,R,b,c,f,h,L,g,I){"use strict";var j=R.RenderPrefixes,k=l.mvc.ViewType,x="XMLViewCacheError",n={};
var m=V.extend("sap.ui.core.mvc.XMLView",{metadata:{library:"sap.ui.core",specialSettings:{containingView:{type:'sap.ui.core.mvc.XMLView',visibility:'hidden'},xmlNode:{type:'Element',visibility:'hidden'},cache:'Object',processingMode:{type:"string",visibility:"hidden"}},designtime:"sap/ui/core/designtime/mvc/XMLView.designtime"}});
sap.ui.xmlview=function(i,e){return sap.ui.view(i,e,k.XML);};
m.create=function(o){var P=d({},o);P.viewContent=P.definition;P.async=true;P.type=k.XML;P.processingMode=P.processingMode||"sequential";return V.create(P);};
m._sType=k.XML;m.asyncSupport=true;m._bUseCache=sap.ui.getCore().getConfiguration().getViewCache()&&b._isSupportedEnvironment();
function v(e){if(e.parseError.errorCode!==0){var P=e.parseError;throw new Error("The following problem occurred: XML parse Error for "+P.url+" code: "+P.errorCode+" reason: "+P.reason+" src: "+P.srcText+" line: "+P.line+" linepos: "+P.linepos+" filepos: "+P.filepos);}}
function p(o,S){if(!S){throw new Error("mSettings must be given");}else if(S.viewName&&S.viewContent){throw new Error("View name and view content are given. There is no point in doing this, so please decide.");}else if((S.viewName||S.viewContent)&&S.xmlNode){throw new Error("View name/content AND an XML node are given. There is no point in doing this, so please decide.");}else if(!(S.viewName||S.viewContent)&&!S.xmlNode){throw new Error("Neither view name/content nor an XML node is given. One of them is required.");}else if(S.cache&&!(S.cache.keys&&S.cache.keys.length)){throw new Error("No cache keys provided. At least one is required.");}}
function r(o,S){o.mProperties["viewContent"]=S.viewContent;var e=f.parse(S.viewContent);v(e);return e.documentElement;}
function s(o,S){if((o._resourceBundleName||o._resourceBundleUrl)&&(!S.models||!S.models[o._resourceBundleAlias])){var e=new c({bundleName:o._resourceBundleName,bundleUrl:o._resourceBundleUrl,bundleLocale:o._resourceBundleLocale,async:S.async});var i=e.getResourceBundle();if(i instanceof Promise){return i.then(function(){o.setModel(e,o._resourceBundleAlias);});}o.setModel(e,o._resourceBundleAlias);}}
function t(o){o.oAfterRenderingNotifier=new G();o.oAfterRenderingNotifier.addDelegate({onAfterRendering:function(){o.onAfterRenderingBeforeChildren();}});}
function u(S){var e=sap.ui.require("sap/ui/core/Component"),o;while(S&&e){var i=e.getOwnerComponentFor(S);if(i){S=o=i;}else{if(S instanceof e){o=S;}S=S.getParent&&S.getParent();}}return o;}
function w(o,e){var i=u(o),H=i?JSON.stringify(i.getManifest()):null,J=[];J=J.concat(A(o,i),D(),B(o),e.keys);return z(o,J).then(function(K){return{key:K+"("+h(H||"")+")",componentManifest:H,additionalData:e.additionalData};});}
function y(K){return K;}
function z(o,i){return Promise.all(i).then(function(K){K=K.filter(function(H){return H!==n;});if(K.every(y)){return K.join('_');}else{var e=new Error("Provided cache keys may not be empty or undefined.");e.name=x;return Promise.reject(e);}});}
function A(o,e){var i=e&&e.getMetadata().getName();return[i||window.location.host+window.location.pathname,o.getId(),sap.ui.getCore().getConfiguration().getLanguageTag()].concat(e&&e.getActiveTerminologies()||[]);}
function B(e){var P=e.getPreprocessors(),i=e.getPreprocessorInfo(false),H=[];function J(o){H.push(o.preprocessor.then(function(K){if(K.getCacheKey){return K.getCacheKey(i);}else{return n;}}));}for(var T in P){P[T].forEach(J);}return H;}
function D(){return sap.ui.getVersionInfo({async:true}).then(function(i){var T="";if(!i.libraries){T=sap.ui.buildinfo.buildtime;}else{i.libraries.forEach(function(o){T+=o.buildTimestamp;});}return T;}).catch(function(e){L.warning("sap.ui.getVersionInfo could not be retrieved","sap.ui.core.mvc.XMLView");L.debug(e);return"";});}
function E(e,i){var K=e.key;delete e.key;e.xml=f.serialize(i);return b.set(K,e);}
function F(e){return b.get(e.key).then(function(i){if(i&&i.componentManifest==e.componentManifest){i.xml=f.parse(i.xml,"application/xml").documentElement;if(i.additionalData){d(e.additionalData,i.additionalData);}return i;}});}
m.prototype.initViewSettings=function(S){var e=this,_;function i(P){e._xContent=P;if(V._supportInfo){V._supportInfo({context:e._xContent,env:{caller:"view",viewinfo:d({},e),settings:d({},S||{}),type:"xmlview"}});}if(!e.isSubView()){var Q={};a.parseViewAttributes(P,e,Q);if(!S.async){Object.assign(S,Q);}else{e.applySettings(Q);}}else{delete S.controller;}var T=s(e,S);if(T instanceof Promise){return T.then(function(){t(e);});}t(e);}function o(P,Q){if(e.hasPreprocessor("viewxml")){return a.enrichTemplateIdsPromise(P,e,Q).then(function(){return e.runPreprocessor("viewxml",P,!Q);});}return P;}function H(P){var Q=I.notifyAsyncStep("VIEW PREPROCESSING");return e.runPreprocessor("xml",P).then(function(P){return o(P,true);}).finally(Q);}function J(O){return g.loadResource(O,{async:true}).then(function(P){return P.documentElement;});}function K(O,P){return J(O).then(H).then(function(Q){if(P){E(P,Q);}return Q;});}function N(O,P){return w(e,P).then(function(Q){return F(Q).then(function(T){if(!T){return K(O,Q);}else{return T.xml;}});}).catch(function(Q){if(Q.name===x){L.debug(Q.message,Q.name,"sap.ui.core.mvc.XMLView");L.debug("Processing the View without caching.","sap.ui.core.mvc.XMLView");return K(O);}else{return Promise.reject(Q);}});}this._oContainingView=S.containingView||this;this._sProcessingMode=S.processingMode;if(this.oAsyncState){this.oAsyncState.suppressPreserve=true;}p(this,S);if(S.viewName){var O=S.viewName.replace(/\./g,"/")+".view.xml";if(S.async){if(S.cache&&m._bUseCache){return N(O,S.cache).then(i);}else{return J(O).then(H).then(i);}}else{_=g.loadResource(O).documentElement;}}else if(S.viewContent){if(S.viewContent.nodeType===window.Node.DOCUMENT_NODE){_=S.viewContent.documentElement;}else{_=r(this,S);}}else if(S.xmlNode){_=S.xmlNode;}if(S.async){return H(_).then(i);}else{_=this.runPreprocessor("xml",_,true);_=o(_,false);if(_&&typeof _.getResult==='function'){if(_.isRejected()){throw _.getResult();}_=_.getResult();}i(_);}};
m.prototype.onBeforeRendering=function(){var o=this.getDomRef();if(o&&!R.isPreservedContent(o)){R.preserveContent(o,true);}V.prototype.onBeforeRendering.apply(this,arguments);};
m.prototype.exit=function(){if(this.oAfterRenderingNotifier){this.oAfterRenderingNotifier.destroy();}V.prototype.exit.apply(this,arguments);};
m.prototype.onControllerConnected=function(o){var e=this;function i(J){return M.runWithPreprocessors(J,{settings:e._fnSettingsPreprocessor});}if(!this.oAsyncState){this._aParsedContent=i(a.parseTemplate.bind(null,this._xContent,this));}else{var H=I.notifyAsyncStep("VIEW PROCESSING");return a.parseTemplatePromise(this._xContent,this,true,{fnRunWithPreprocessor:i}).then(function(P){e._aParsedContent=P;delete e.oAsyncState.suppressPreserve;}).finally(H);}};
m.prototype.getControllerName=function(){return this._controllerName;};
m.prototype.isSubView=function(){return this._oContainingView!=this;};
m.prototype.onAfterRenderingBeforeChildren=function(){if(this._$oldContent.length!==0){var e=this.getAggregation("content");if(e){for(var i=0;i<e.length;i++){var N=document.getElementById(j.Temporary+e[i].getId())||e[i].getDomRef()||document.getElementById(j.Invisible+e[i].getId());if(N){q(document.getElementById(j.Dummy+e[i].getId())).replaceWith(N);}}}q(document.getElementById(j.Temporary+this.getId())).replaceWith(this._$oldContent);}this._$oldContent=undefined;};
m.prototype._onChildRerenderedEmpty=function(o,e){q(e).replaceWith('<div id="'+j.Dummy+o.getId()+'" class="sapUiHidden"></div>');return true;};
m.registerPreprocessor=function(T,P,S,o,e){T=T.toUpperCase();if(m.PreprocessorType[T]){V.registerPreprocessor(m.PreprocessorType[T],P,this.getMetadata().getClass()._sType,S,o,e);}else{L.error("Preprocessor could not be registered due to unknown sType \""+T+"\"",this.getMetadata().getName());}};
m.PreprocessorType={XML:"xml",VIEWXML:"viewxml",CONTROLS:"controls"};
var G=C.extend("sap.ui.core.mvc.XMLAfterRenderingNotifier",{
metadata:{library:"sap.ui.core"},
renderer:{apiVersion:2,render:function(o,e){o.text("");}}
});
m.registerPreprocessor("xml","sap.ui.core.util.XMLPreprocessor",true,true);return m;});
sap.ui.predefine('sap/ui/core/mvc/XMLViewRenderer',['./ViewRenderer','../RenderManager',"sap/ui/thirdparty/jquery"],function(V,R,q){"use strict";var P=R.RenderPrefixes.Dummy,a=R.RenderPrefixes.Invisible,b=R.RenderPrefixes.Temporary;var X={apiVersion:1};
X.render=function(r,c){var $=c._$oldContent=R.findPreservedContent(c.getId());if($.length===0){var s=c.isSubView();if(!s){r.openStart("div",c);r.class("sapUiView");r.class("sapUiXMLView");V.addDisplayClass(r,c);if(!c.oAsyncState||!c.oAsyncState.suppressPreserve){r.attr("data-sap-ui-preserve",c.getId());}r.style("width",c.getWidth());r.style("height",c.getHeight());r.openEnd();}if(c._aParsedContent){for(var i=0;i<c._aParsedContent.length;i++){var f=c._aParsedContent[i];if(f&&typeof(f)==="string"){r.write(f);}else{r.renderControl(f);if(!f.bOutput){r.openStart("div",P+f.getId());r.class("sapUiHidden");r.openEnd();}}}}if(!s){r.close("div");}}else{r.renderControl(c.oAfterRenderingNotifier);r.openStart("div",b+c.getId());r.class("sapUiHidden");r.openEnd();for(var i=0;i<c._aParsedContent.length;i++){var f=c._aParsedContent[i];if(typeof(f)!=="string"){r.renderControl(f);var F=f.getId(),d=q(document.getElementById(F));if(d.length==0){d=q(document.getElementById(a+F));}if(!R.isPreservedContent(d[0])){d.replaceWith('<div id="'+P+F+'" class="sapUiHidden"></div>');}}}r.close("div");}};
return X;},true);
sap.ui.predefine('sap/ui/core/plugin/TemplatingSupport',['sap/ui/core/Core','sap/ui/core/tmpl/Template',"sap/base/Log"],function(C,T,L){"use strict";var a=function(){};
a.prototype.startPlugin=function(c,o){L.info("Starting TemplatingSupport plugin.");this.oCore=c;sap.ui.template();};
a.prototype.stopPlugin=function(){L.info("Stopping TemplatingSupport plugin.");this.oCore=null;};
(function(){var t=new a();sap.ui.getCore().registerPlugin(t);}());return a;},true);
sap.ui.predefine('sap/ui/core/postmessage/Bus',["sap/ui/core/EventBus","sap/base/util/includes","sap/base/util/isPlainObject","sap/base/Log"],function(E,i,a,L){"use strict";var I;var s='______UI5______';
var P=E.extend("sap.ui.core.postmessage.Bus",{constructor:function(){if(I){return I;}I=this;E.apply(this,arguments);this._aAcceptedOrigins=[window.location.origin];this._aDeclinedOrigins=[];this._oPendingProcess=null;this._aEventQueue=[];this._receiver=this._receiver.bind(this);window.addEventListener('message',this._receiver);}});
P.event={CONNECT:'______CONNECT______',READY:'______READY______',ACCEPTED:'______ACCEPTED______',DECLINED:'______DECLINED______'};
P.prototype.destroy=function(){window.removeEventListener('message',this._receiver);this._aEventQueue=[];E.prototype.destroy.apply(this,arguments);I=undefined;this.bIsDestroyed=true;};
P.getInstance=function(){if(!I){I=new P();}return I;};
P.prototype.publish=function(p){var t=p.target;var o=p.origin;var c=p.channelId;var e=p.eventId;var d=p.data;if(e===P.event.READY){if(!t){if(window.opener&&window.opener!==window){t=window.opener;}else if(window.parent!==window){t=window.parent;}else{return;}}if(!o){o='*';}}if((typeof window==="undefined")||!(t!=null&&t===t.window)||t===window){throw TypeError("Target must be a window object and has to differ from current window");}if(typeof o!=="string"){throw TypeError("Origin must be a string");}if(typeof c!=="string"){throw TypeError("ChannelId must be a string");}if(typeof e!=="string"){throw TypeError("EventId must be a string");}if(!i([P.event.READY,P.event.ACCEPTED,P.event.DECLINED],e)&&o!=='*'&&!i(this._aAcceptedOrigins,o)){this._aAcceptedOrigins.push(o);}var m={origin:o,channelId:c,eventId:e,data:d};m[s]=true;t.postMessage(m,o);};
P.prototype._callListener=function(c,l,C,e,d){c.call(l,d);};
P.prototype._getText=function(k,p){return sap.ui.getCore().getLibraryResourceBundle(true).then(function(l){return l.getText(k,p);});};
P.prototype._receiver=function(e){var d=e.data;if(!a(d)||!d.hasOwnProperty(s)){return;}if(this._oPendingProcess){this._aEventQueue.push(e);}else{this._oPendingProcess=this._processEvent(e);}};
P.prototype._processEvent=function(e){return new Promise(function(r,R){var d=e.data;var o=e.origin;if(i(this._aDeclinedOrigins,o)){r();return;}switch(d.eventId){case P.event.CONNECT:{if(typeof d.data!=="string"){this.publish({target:e.source,origin:e.origin,channelId:d.channelId,eventId:P.event.DECLINED});r();}else if(i(this._aAcceptedOrigins,o)){this.publish({target:e.source,origin:e.origin,channelId:d.channelId,eventId:P.event.ACCEPTED});r();}else{sap.ui.require(["sap/ui/core/postmessage/confirmationDialog"],function(c){this._getText('PostMessage.Message',[d.data,o]).then(function(t){return c(t);}).then(function(){this.addAcceptedOrigin(o);this.publish({target:e.source,origin:e.origin,channelId:d.channelId,eventId:P.event.ACCEPTED});}.bind(this),function(){this.addDeclinedOrigin(o);this.publish({target:e.source,origin:e.origin,channelId:d.channelId,eventId:P.event.DECLINED});}.bind(this)).then(r);}.bind(this),R);}break;}case P.event.ACCEPTED:case P.event.DECLINED:case P.event.READY:{e.data.data=undefined;this._emitMessage(e);r();break;}default:{if(i(this._aAcceptedOrigins,o)){this._emitMessage(e);}r();}}}.bind(this)).catch(function(v){var m;var d;if(typeof v==='string'){m=v;}else if(v instanceof Error){m=v.message;d=v.stack;}else{m='Some unexpected error happened during post message processing';}L.error(m,d,'sap.ui.core.postmessage.Bus');}).then(function(){this._oPendingProcess=(this._aEventQueue.length>0?this._processEvent(this._aEventQueue.shift()):null);}.bind(this));};
P.prototype._emitMessage=function(e){var c=e.data.channelId;var b=e.data.eventId;E.prototype.publish.call(this,c,b,{originalEvent:e,channelId:c,eventId:b,source:e.source,origin:e.origin,data:e.data.data});};
P.prototype.getAcceptedOrigins=function(){return this._aAcceptedOrigins.slice();};
P.prototype.setAcceptedOrigins=function(o){if(!Array.isArray(o)){throw new TypeError('Expected an array, but got '+typeof o);}this._aAcceptedOrigins=o.slice();};
P.prototype.addAcceptedOrigin=function(o){if(typeof o!=='string'){throw new TypeError('Expected a string, but got '+typeof o);}if(!i(this._aAcceptedOrigins,o)){this._aAcceptedOrigins.push(o);}};
P.prototype.resetAcceptedOrigins=function(){this.setAcceptedOrigins([]);};
P.prototype.getDeclinedOrigins=function(){return this._aDeclinedOrigins.slice();};
P.prototype.setDeclinedOrigins=function(o){if(!Array.isArray(o)){throw new TypeError('Expected an array, but got '+typeof o);}this._aDeclinedOrigins=o.slice();};
P.prototype.addDeclinedOrigin=function(o){if(typeof o!=='string'){throw new TypeError('Expected a string, but got '+typeof o);}if(!i(this._aDeclinedOrigins,o)){this._aDeclinedOrigins.push(o);}};
P.prototype.resetDeclinedOrigins=function(){this.setDeclinedOrigins([]);};
return P;});
sap.ui.predefine('sap/ui/core/postmessage/confirmationDialog',function(){"use strict";return function(m){return new Promise(function(r,R){var M=sap.ui.getCore().getLoadedLibraries().hasOwnProperty('sap.m');if(M){sap.ui.require(['sap/m/MessageBox'],function(a){a.confirm(m,{actions:[a.Action.YES,a.Action.NO],onClose:function(A){if(A===a.Action.YES){r();}else{R();}}});},R);}else{var c=window.confirm(m);if(c){r();}else{R();}}});};});
sap.ui.predefine('sap/ui/core/routing/HashChanger',["./HashChangerBase","./RouterHashChanger",'sap/ui/thirdparty/hasher',"sap/base/Log","sap/base/util/ObjectPath"],function(H,R,h,L,O){"use strict";
var a=H.extend("sap.ui.core.routing.HashChanger",{constructor:function(){H.apply(this);}});
a.prototype.init=function(){if(this._initialized){L.info("this HashChanger instance has already been initialized.");return false;}this._initialized=true;h.changed.add(this.fireHashChanged,this);if(!h.isActive()){h.initialized.addOnce(this.fireHashChanged,this);h.init();}else{this.fireHashChanged(h.getHash());}return this._initialized;};
a.prototype.fireHashChanged=function(n,o){this.fireEvent("hashChanged",{newHash:n,oldHash:o});};
a.prototype.createRouterHashChanger=function(){if(!this._oRouterHashChanger){this._oRouterHashChanger=new R({parent:this});this._registerListenerToRelevantEvents();this._oRouterHashChanger.attachEvent("hashSet",this._onHashModified,this);this._oRouterHashChanger.attachEvent("hashReplaced",this._onHashModified,this);}return this._oRouterHashChanger;};
a.prototype._registerListenerToRelevantEvents=function(){if(!this._mEventListeners){this._mEventListeners={};this.getRelevantEventsInfo().forEach(function(e){var E=e.name,l=this._onHashChangedForRouterHashChanger.bind(this,e);this._mEventListeners[E]=l;this.attachEvent(E,l,this);}.bind(this));}};
a.prototype._deregisterListenerFromRelevantEvents=function(){if(this._mEventListeners){var e=Object.keys(this._mEventListeners);e.forEach(function(E){this.detachEvent(E,this._mEventListeners[E],this);}.bind(this));delete this._mEventListeners;}};
a.prototype._onHashChangedForRouterHashChanger=function(e,E){if(this._oRouterHashChanger){var p=e.paramMapping||{},P=p["newHash"]||"newHash",n=E.getParameter(P)||"",o=this._parseHash(n);this._oRouterHashChanger.fireHashChanged(o.hash,o.subHashMap,!!e.updateHashOnly);}};
a.prototype._onHashModified=function(e){var E=e.getId(),b=[e.getParameter("hash")],k=[e.getParameter("key")],n=e.getParameter("nestedHashInfo"),d=e.getParameter("deletePrefix")||[];if(Array.isArray(n)){n.forEach(function(o){b.push(o.hash);k.push(o.key);if(Array.isArray(o.deletePrefix)){o.deletePrefix.forEach(function(D){if(d.indexOf(D)===-1){d.push(D);}});}});}if(E==="hashSet"){this._setSubHash(k,b,d);}else{this._replaceSubHash(k,b,d);}};
a.prototype._setSubHash=function(k,s,c){var b=this._reconstructHash(k,s,c);this.setHash(b);};
a.prototype._replaceSubHash=function(k,s,c){var b=this._reconstructHash(k,s,c);this.replaceHash(b);};
a.prototype._reconstructHash=function(k,v,d){var p=this.getHash().split("&/"),t=p.shift();k.forEach(function(K,b){if(d){d=d.filter(function(D){return D!==K;});}var V=v[b];if(K===undefined){t=V+"";}else{var f=p.some(function(P,i,p){if(P.startsWith(K)){if(V){p[i]=K+"/"+V;}else{d.push(K);}return true;}});if(!f){p.push(K+"/"+V);}}});if(d&&d.length>0){p=p.filter(function(P){return!d.some(function(s){return P.startsWith(s);});});}p.unshift(t);return p.join("&/");};
a.prototype._parseHash=function(s){var p=s.split("&/");return{hash:p.shift(),subHashMap:p.reduce(function(m,P){var S=P.indexOf("/");m[P.substring(0,S)]=P.substring(S+1);return m;},{})};};
a.prototype.setHash=function(s){H.prototype.setHash.apply(this,arguments);h.setHash(s);};
a.prototype.replaceHash=function(s){H.prototype.replaceHash.apply(this,arguments);h.replaceHash(s);};
a.prototype.getHash=function(){return h.getHash();};
a.prototype.getRelevantEventsInfo=function(){return[{name:"hashChanged",paramMapping:{fullHash:"newHash"}}];};
a.prototype.destroy=function(){if(this._oRouterHashChanger){this._deregisterListenerFromRelevantEvents();this._oRouterHashChanger.destroy();this._oRouterHashChanger=undefined;}delete this._initialized;h.changed.remove(this.fireHashChanged,this);H.prototype.destroy.apply(this,arguments);};
a.prototype.deregisterRouterHashChanger=function(){this._deregisterListenerFromRelevantEvents();delete this._oRouterHashChanger;};
(function(){var _=null;
a.getInstance=function(){if(!_){_=new a();}return _;};
function e(o){var E,b,n;for(E in _.mEventRegistry){if(_.mEventRegistry.hasOwnProperty(E)){b=_.mEventRegistry[E];n=o.mEventRegistry[E];if(n){o.mEventRegistry[E]=b.concat(n);}else{o.mEventRegistry[E]=b;}}}}
a.replaceHashChanger=function(o){if(_&&o){var g=O.get("sap.ui.core.routing.History.getInstance"),b;if(g){b=g();b._setHashChanger(o);}if(_._oRouterHashChanger){_._oRouterHashChanger.detachEvent("hashSet",_._onHashModified,_);_._oRouterHashChanger.detachEvent("hashReplaced",_._onHashModified,_);_._deregisterListenerFromRelevantEvents();o._oRouterHashChanger=_._oRouterHashChanger;o._oRouterHashChanger.parent=o;delete _._oRouterHashChanger;o._oRouterHashChanger.attachEvent("hashSet",o._onHashModified,o);o._oRouterHashChanger.attachEvent("hashReplaced",o._onHashModified,o);o._registerListenerToRelevantEvents();}e(o);_.destroy();}_=o;};
}());return a;});
sap.ui.predefine('sap/ui/core/routing/HashChangerBase',['sap/ui/base/EventProvider'],function(E){"use strict";
var H=E.extend("sap.ui.core.routing.HashChangerBase",{
metadata:{"abstract":true,publicMethods:["getHash","setHash","replaceHash"]},
constructor:function(){E.apply(this);}
});
H.M_EVENTS={"HashChanged":"hashChanged","HashSet":"hashSet","HashReplaced":"hashReplaced"};
H.prototype.setHash=function(h){this.fireEvent("hashSet",{sHash:h,hash:h});};
H.prototype.replaceHash=function(h){this.fireEvent("hashReplaced",{sHash:h,hash:h});};
return H;});
sap.ui.predefine('sap/ui/core/routing/History',['sap/ui/core/library','./HashChanger',"sap/base/Log","sap/ui/thirdparty/URI","sap/ui/Device","sap/base/util/ObjectPath"],function(l,H,L,U,D,O){"use strict";var a=l.routing.HistoryDirection;var b="Direction_Unchanged";var c=function(h){this._iHistoryLength=window.history.length;this.aHistory=[];this._bIsInitial=true;if(c._bUsePushState){var s=window.history.state===null?{}:window.history.state,d=window.location.hash;d=d.replace(/^#/,"");if(typeof s==="object"){c._aStateHistory.push(d);s.sap={};s.sap.history=c._aStateHistory;window.history.replaceState(s,window.document.title);}else{L.debug("Unable to determine HistoryDirection as history.state is already set: "+window.history.state,"sap.ui.core.routing.History");}}if(!h){L.error("sap.ui.core.routing.History constructor was called and it did not get a hashChanger as parameter");}this._setHashChanger(h);this._reset();};c._aStateHistory=[];c._bUsePushState=!D.browser.msie&&(window.self===window.top);
c.prototype.getHistoryStateOffset=function(){if(!c._bUsePushState){return undefined;}var s=O.get("history.state.sap.history");if(!Array.isArray(s)){return undefined;}return s.length-c._aStateHistory.length;};
c.prototype.destroy=function(){this._unRegisterHashChanger();};
c.prototype.getDirection=function(n){if(n!==undefined&&this._bIsInitial){return undefined;}if(n===undefined){return this._sCurrentDirection;}return this._getDirection(n);};
c.prototype.getPreviousHash=function(){return this.aHistory[this.iHistoryPosition-1];};
c.prototype._setHashChanger=function(h){if(this._oHashChanger){this._unRegisterHashChanger();}this._oHashChanger=h;this._mEventListeners={};h.getRelevantEventsInfo().forEach(function(e){var E=e.name,p=e.paramMapping||{},f=this._onHashChange.bind(this,p);this._mEventListeners[E]=f;this._oHashChanger.attachEvent(E,f,this);}.bind(this));this._oHashChanger.attachEvent("hashReplaced",this._hashReplaced,this);this._oHashChanger.attachEvent("hashSet",this._hashSet,this);};
c.prototype._unRegisterHashChanger=function(){if(this._mEventListeners){var e=Object.keys(this._mEventListeners);e.forEach(function(E){this._oHashChanger.detachEvent(E,this._mEventListeners[E],this);}.bind(this));delete this._mEventListeners;}this._oHashChanger.detachEvent("hashReplaced",this._hashReplaced,this);this._oHashChanger.detachEvent("hashSet",this._hashSet,this);this._oHashChanger=null;};
c.prototype._reset=function(){this.aHistory.length=0;this.iHistoryPosition=0;this._bUnknown=true;this.aHistory[0]=this._oHashChanger.getHash();};
c.prototype._getDirection=function(n,h,C){if(C&&this._oNextHash&&this._oNextHash.sHash===n){return a.NewEntry;}if(h){return a.NewEntry;}if(this._bUnknown){return a.Unknown;}if(this.aHistory[this.iHistoryPosition+1]===n&&this.aHistory[this.iHistoryPosition-1]===n){return a.Unknown;}if(this.aHistory[this.iHistoryPosition-1]===n){return a.Backwards;}if(this.aHistory[this.iHistoryPosition+1]===n){return a.Forwards;}return a.Unknown;};
c.prototype._getDirectionWithState=function(h){var s=window.history.state===null?{}:window.history.state,B,d;if(typeof s==="object"){if(s.sap===undefined){c._aStateHistory.push(h);s.sap={};s.sap.history=c._aStateHistory;history.replaceState(s,document.title);d=a.NewEntry;}else{B=s.sap.history.every(function(u,e){return u===c._aStateHistory[e];});if(B&&s.sap.history.length===c._aStateHistory.length){d=b;}else{d=B?a.Backwards:a.Forwards;c._aStateHistory=s.sap.history;}}}else{L.debug("Unable to determine HistoryDirection as history.state is already set: "+window.history.state,"sap.ui.core.routing.History");}return d;};
c.prototype._onHashChange=function(p,e){var n=p.newHash||"newHash",o=p.oldHash||"oldHash",f=p.fullHash||"fullHash";this._hashChange(e.getParameter(n),e.getParameter(o),e.getParameter(f));};
c.prototype._hashChange=function(n,o,f){var d=window.history.length,s;if(this._oNextHash&&this._oNextHash.bWasReplaced&&this._oNextHash.sHash===n){this.aHistory[this.iHistoryPosition]=n;if(f!==undefined&&c._bUsePushState&&this===c.getInstance()){c._aStateHistory[c._aStateHistory.length-1]=f;window.history.replaceState({sap:{history:c._aStateHistory}},window.document.title);}this._oNextHash=null;if(!this._bIsInitial){this._sCurrentDirection=a.Unknown;}return;}this._bIsInitial=false;if(f!==undefined&&c._bUsePushState&&this===c.getInstance()){s=this._getDirectionWithState(f);}if(s===b){return;}if(!s){s=this._getDirection(n,this._iHistoryLength<window.history.length,true);}this._sCurrentDirection=s;this._iHistoryLength=d;if(this._oNextHash){this._oNextHash=null;}if(s===a.Unknown){this._reset();return;}this._bUnknown=false;if(s===a.NewEntry){if(this.iHistoryPosition+1<this.aHistory.length){this.aHistory=this.aHistory.slice(0,this.iHistoryPosition+1);}this.aHistory.push(n);this.iHistoryPosition+=1;return;}if(s===a.Forwards){this.iHistoryPosition++;return;}if(s===a.Backwards){this.iHistoryPosition--;}};
c.prototype._hashSet=function(e){this._hashChangedByApp(e.getParameter("sHash"),false);};
c.prototype._hashReplaced=function(e){this._hashChangedByApp(e.getParameter("sHash"),true);};
c.prototype._hashChangedByApp=function(n,w){this._oNextHash={sHash:n,bWasReplaced:w};};
var i=new c(H.getInstance());
c.getInstance=function(){return i;};
return c;},true);
sap.ui.predefine('sap/ui/core/routing/Route',['sap/ui/base/EventProvider','sap/ui/core/routing/Target','sap/ui/core/routing/async/Route','sap/ui/core/routing/sync/Route','sap/ui/core/Component',"sap/base/Log","sap/base/assert","sap/base/util/deepExtend"],function(E,T,a,s,C,L,b,d){"use strict";
var R=E.extend("sap.ui.core.routing.Route",{
metadata:{publicMethods:["getURL","getPattern"]},
constructor:function(r,c,p){E.apply(this,arguments);this._validateConfig(c);this._aPattern=[];this._aRoutes=[];this._oParent=p;this._oConfig=c;this._oRouter=r;var t=this,v=c.pattern,S,e,o,f,g=r._isAsync();f=g?a:s;for(var h in f){this[h]=f[h];}if(!Array.isArray(v)){v=[v];}if(c.parent){var j=this._getParentRoute(c.parent);if(!j){L.error("No parent route with '"+c.parent+"' could be found",this);}else if(j._aPattern.length>1){L.error("Routes with multiple patterns cannot be used as parent for nested routes",this);return;}else{this._oNestingParent=j;v.forEach(function(l,i){var n=j._aPattern[0];n=n.charAt(n.length)==="/"?n:n+"/";v[i]=n+l;});}}if(Array.isArray(c.subroutes)){S=c.subroutes;c.subroutes={};S.forEach(function(i){c.subroutes[i.name]=i;});}if(!c.target){var k=this._convertToTargetOptions(c);k._async=g;this._oTarget=new T(k,r._oViews,p&&p._oTarget);this._oTarget._bUseRawViewId=true;}if(c.subroutes){for(e in c.subroutes){o=c.subroutes[e];if(o.name===undefined){o.name=e;}r.addRoute(o,t);}}if(c.pattern===undefined){return;}v.forEach(function(i,I){t._aPattern[I]=i;t._aRoutes[I]=r._oRouter.addRoute(i);t._checkRoute(t._aRoutes[I]);t._aRoutes[I].greedy=c.greedy;t._aRoutes[I].matched.add(function(){var A={};Array.from(arguments).forEach(function(l,m){A[t._aRoutes[I]._paramsIds[m]]=l;});t._routeMatched(A,true);});t._aRoutes[I].switched.add(function(){t._routeSwitched();});});},
_checkRoute:function(r){var p=r._paramsIds;if(Array.isArray(p)){var D=p.filter(function(P){return P.charAt(0)==="?";}).filter(function(P){return p.indexOf(P.substring(1))>-1;}).map(function(P){return P.substring(1);});if(D.length>0){throw Error("The config of route '"+this._oConfig.name+"' contains standard parameter and query parameter with the same name: '"+D+"'. The name of the routing parameters and query parameter have to differentiate.");}}},
_routeSwitched:function(){this._suspend();this.fireEvent("switched",{name:this._oConfig.name});},
_suspend:function(){if(this._oRouter._oTargets){this._oRouter._oTargets.suspend(this._oConfig.target);if(this._oConfig.dynamicTarget){this._oRouter._oTargets.suspend(this._oConfig.dynamicTarget);delete this._oConfig.dynamicTarget;}}},
destroy:function(){E.prototype.destroy.apply(this);this._aPattern=null;this._aRoutes=null;this._oParent=null;this._oConfig=null;this.bIsDestroyed=true;return this;},
getURL:function(p){return this._aRoutes[0].interpolate(p||{});},
_alignTargetsConfig:function(t){if(!t){return[];}if(!Array.isArray(t)){return(typeof t==="string")?[{name:t}]:[t];}return t.map(function(v){if(typeof v==="string"){v={name:v};}return v;});},
_changeHashWithComponentTargets:function(c,p){var t=this._alignTargetsConfig(this._oConfig.target),o=this._oRouter._oTargets,e,l;if(t&&t.length>0&&o){e=o.getTarget(t);if(!Array.isArray(e)){e=[e];}}else{e=[];}var f=this;l=e.map(function(g,i){if(g._oOptions.type==="Component"){var h=g._load({prefix:t[i].prefix,propagateTitle:t[i].hasOwnProperty("propagateTitle")?t[i].propagateTitle:f._oRouter._oConfig.propagateTitle});return h.then(function(j){var r=j.getRouter(),H=r&&r.getHashChanger(),k=c&&c[t[i].name],m=k&&k.route,n=r&&r.getRoute(m),q;if(k){if(n){q=r._getLastMatchedRouteName()!==m;H.setHash(n.getURL(k.parameters),p||!q);return n._changeHashWithComponentTargets(k.componentTargetInfo,p||q);}else{L.error("Can not navigate to route with name '"+m+"' because the route does not exist in component with id '"+j.getId()+"'");}}});}});return Promise.all(l);},
getPattern:function(){return this._aPattern[0];},
match:function(h){return this._aRoutes.some(function(r){return r.match(h);});},
attachMatched:function(D,f,l){return this.attachEvent("matched",D,f,l);},
detachMatched:function(f,l){return this.detachEvent("matched",f,l);},
attachBeforeMatched:function(D,f,l){return this.attachEvent("beforeMatched",D,f,l);},
detachBeforeMatched:function(f,l){return this.detachEvent("beforeMatched",f,l);},
fireBeforeMatched:function(p){this.fireEvent("beforeMatched",p);return this;},
attachPatternMatched:function(D,f,l){return this.attachEvent("patternMatched",D,f,l);},
detachPatternMatched:function(f,l){return this.detachEvent("patternMatched",f,l);},
_validateConfig:function(c){if(!c.name){L.error("A name has to be specified for every route",this);}if(c.viewName){L.error("The 'viewName' option shouldn't be used in Route. please use 'view' instead",this);}},
_convertToTargetOptions:function(o){return d({},o,{rootView:o.targetParent,controlId:o.targetControl,controlAggregation:o.targetAggregation,clearControlAggregation:o.clearTarget,viewName:o.view,viewType:o.viewType,viewId:o.viewId});},
_getParentRoute:function(p){var P=p.split(":");if(P.length===1||(P.length===2&&!P[0])){return this._oRouter.getRoute(P[P.length-1]);}else{b(this._oRouter._oOwner,"No owner component for "+this._oRouter._oOwner.getId());var o=C.getOwnerComponentFor(this._oRouter._oOwner);while(o){if(o.getMetadata().getName()===P[0]){var r=o.getRouter();return r.getRoute(P[1]);}o=C.getOwnerComponentFor(o);}return null;}},
getPatternArguments:function(h){return this._aRoutes[0].extrapolate(h);}
});
R.M_EVENTS={BeforeMatched:"beforeMatched",Matched:"matched",PatternMatched:"patternMatched"};return R;});
sap.ui.predefine('sap/ui/core/routing/Router',['sap/ui/core/library','sap/ui/base/EventProvider','./HashChanger','./Route','./Views','./Targets','./History','sap/ui/thirdparty/crossroads',"sap/base/util/UriParameters","sap/base/util/deepEqual","sap/base/util/isEmptyObject","sap/base/Log","sap/ui/thirdparty/jquery","./RouterHashChanger","sap/ui/core/Component"],function(l,E,H,R,V,T,a,c,U,d,b,L,q,e,C){"use strict";var r={};
var f=E.extend("sap.ui.core.routing.Router",{
constructor:function(o,i,O,t,j){E.apply(this);this._oConfig=i||{};this._oRouter=c.create();this._oRouter.ignoreState=true;this._oRoutes={};this._oOwner=O;function k(){if(U.fromQuery(window.location.search).get("sap-ui-xx-asyncRouting")==="true"){L.warning("Activation of async view loading in routing via url parameter is only temporarily supported and may be removed soon","Router");return true;}return false;}this._oConfig._async=this._oConfig.async;if(this._oConfig._async===undefined){this._oConfig._async=k();}this._oViews=new V({component:O,async:this._oConfig._async});if(t){this._oTargets=this._createTargets(this._oConfig,t);this._oTargets._setRouter(this);this._oTargets.attachDisplay(function(s){var I=s.getParameter("routeRelevant");if(this.isInitialized()&&!this._bMatchingProcessStarted){var u=this.getHashChanger();if(u instanceof e&&!I){u.resetHash();}}},this);}var m=this,n;if(!o){o={};}if(Array.isArray(o)){n=o;o={};n.forEach(function(s){o[s.name]=s;});}q.each(o,function(s,u){if(u.name===undefined){u.name=s;}m.addRoute(u);});this._oRouter.bypassed.add(q.proxy(this._onBypassed,this));if(!j){j=H.getInstance().createRouterHashChanger();}this.setHashChanger(j);var p=this._getParentRouter();if(p){this.attachTitleChanged(function(s){if(this._oOwner&&!this._oOwner._bRoutingPropagateTitle){return;}var P=s.getParameters(),N,F;if(p._fnTitleChangedFiredOnChild){p._fnTitleChangedFiredOnChild(P);}else{N=P.nestedHistory.slice();N.unshift({ownerComponentId:p._oOwner.getId(),history:p.getTitleHistory()});F={propagated:true,title:P.title,history:P.history,nestedHistory:N};p.fireTitleChanged(F);}});}},
addRoute:function(o,p){if(!o.name){L.error("A name has to be specified for every route",this);}if(this._oRoutes[o.name]){L.error("Route with name "+o.name+" already exists",this);}this._oRoutes[o.name]=this._createRoute(this,o,p);},
parse:function(n){if(this._oRouter){this._oRouter.parse(n);}else{L.warning("This router has been destroyed while the hash changed. No routing events where fired by the destroyed instance.",this);}},
initialize:function(i){var t=this,s;if(this._bIsInitialized){L.warning("Router is already initialized.",this);return this;}this._bIsInitialized=true;this._bLastHashReplaced=false;this._bHashChangedAfterTitleChange=false;this.fnHashChanged=function(k){t.parse(k.getParameter("newHash"));t._bHashChangedAfterTitleChange=true;};if(!this.oHashChanger){L.error("navTo of the router is called before the router is initialized. If you want to replace the current hash before you initialize the router you may use getUrl and use replaceHash of the Hashchanger.",this);return this;}if(this._oTargets){var o=this._oRoutes[this._oConfig.homeRoute];this._oTargets.attachTitleChanged(this._forwardTitleChanged,this);this._aHistory=[];var j=o&&h(this._oOwner,o);if(j){this._aHistory.push(j);}}this.oHashChanger.init();s=this.oHashChanger.getHash();this.oHashChanger.attachEvent("hashChanged",this.fnHashChanged);if(!i&&s!==e.InvalidHash){this.parse(s);}return this;},
_forwardTitleChanged:function(o){var p=o.getParameters();var i={title:p.title};var j=this._oRoutes[this._oConfig.homeRoute];if(j&&g(p.name,j._oConfig.name)){i.isHome=true;}this.fireTitleChanged(i);},
stop:function(){if(!this._bIsInitialized){L.warning("Router is not initialized. But it got stopped",this);}if(this.fnHashChanged){this.oHashChanger.detachEvent("hashChanged",this.fnHashChanged);}if(this.fnHashReplaced){this.oHashChanger.detachEvent("hashReplaced",this.fnHashReplaced);}if(this._oTargets){this._oTargets.detachTitleChanged(this._forwardTitleChanged,this);this._oTargets._oLastTitleTarget={};}if(this._oMatchedRoute){this._oMatchedRoute._routeSwitched();this._oMatchedRoute=null;}this._bIsInitialized=false;delete this._oPreviousTitleChangedRoute;return this;},
isStopped:function(){return this._bIsInitialized===false;},
isInitialized:function(){return this._bIsInitialized===true;},
getHashChanger:function(){return this.oHashChanger;},
setHashChanger:function(o){if(this.oHashChanger){L.warning("The Router already has a HashChanger set and this call is ignored");}else{this.oHashChanger=o;}return this;},
destroy:function(){if(this.bIsDestroyed){return this;}E.prototype.destroy.apply(this);if(this._oViews){this._oViews.destroy();this._oViews=null;}if(!this._bIsInitialized){L.info("Router is not initialized, but got destroyed.",this);}if(this.fnHashChanged){this.oHashChanger.detachEvent("hashChanged",this.fnHashChanged);}if(this.fnHashReplaced){this.oHashChanger.detachEvent("hashReplaced",this.fnHashReplaced);}this._oRouter.removeAllRoutes();this._oRouter=null;q.each(this._oRoutes,function(i,o){o.destroy();});this._oRoutes=null;this._oConfig=null;if(this._oTargets){this._oTargets.destroy();this._oTargets=null;}delete this._bIsInitialized;this.bIsDestroyed=true;return this;},
getURL:function(n,p){var o=this.getRoute(n);if(o){return o.getURL(p);}else{L.warning("Route with name "+n+" does not exist",this);}},
match:function(s){return Object.keys(this._oRoutes).some(function(i){return this._oRoutes[i].match(s);}.bind(this));},
getRouteByHash:function(s){for(var i in this._oRoutes){if(this._oRoutes.hasOwnProperty(i)){var o=this.getRoute(i);if(o.match(s)){return o;}}}},
getRouteInfoByHash:function(s){var o=this.getRouteByHash(s);if(!o){return undefined;}return{name:o._oConfig.name,arguments:o.getPatternArguments(s)};},
getRoute:function(n){return this._oRoutes[n];},
getViews:function(){return this._oViews;},
_createTargets:function(o,t){return new T({views:this._oViews,config:o,targets:t});},
_createRoute:function(o,i,p){return new R(o,i,p);},
getView:function(v,s,i){L.warning("Deprecated API Router#getView called - use Router#getViews instead.",this);var o=this._oViews._getViewWithGlobalId({viewName:v,type:s,id:i});this.fireViewCreated({view:o,viewName:v,type:s});return o;},
setView:function(v,o){this._oViews.setView(v,o);return this;},
_getParentRouter:function(){var p=this._oOwner&&C.getOwnerComponentFor(this._oOwner);return p&&p.getRouter();},
navTo:function(n,p,o,i){var t=this,j=this._getLastMatchedRouteName()!==n,k=this.getRoute(n),m,s;if(!k){L.warning("Route with name "+n+" does not exist",this);return this;}if(typeof o==="boolean"){i=o;}if(p===undefined){p={};}if(o&&!b(o)){if(!this._oConfig._async){L.error("navTo with component target info is only supported with async router",this);return this;}m=k._changeHashWithComponentTargets(o,j);}s=k.getURL(p);if(i){t._bLastHashReplaced=true;t.oHashChanger.replaceHash(s,m,!j);}else{t.oHashChanger.setHash(s,m,!j);}return this;},
_getLastMatchedRouteName:function(){return this._oMatchedRoute&&this._oMatchedRoute._oConfig.name;},
getTargets:function(){return this._oTargets;},
getTarget:function(n){return this._oTargets.getTarget(n);},
attachRouteMatched:function(D,F,o){this.attachEvent("routeMatched",D,F,o);return this;},
detachRouteMatched:function(F,o){this.detachEvent("routeMatched",F,o);return this;},
fireRouteMatched:function(p){this.fireEvent("routeMatched",p);if(f._interceptRouteMatched){f._interceptRouteMatched(this._oConfig.controlId,this);}return this;},
attachBeforeRouteMatched:function(D,F,o){this.attachEvent("beforeRouteMatched",D,F,o);return this;},
detachBeforeRouteMatched:function(F,o){this.detachEvent("beforeRouteMatched",F,o);return this;},
fireBeforeRouteMatched:function(p){this.fireEvent("beforeRouteMatched",p);return this;},
attachViewCreated:function(D,F,o){this.attachEvent("viewCreated",D,F,o);return this;},
detachViewCreated:function(F,o){this.detachEvent("viewCreated",F,o);return this;},
fireViewCreated:function(p){this.fireEvent("viewCreated",p);return this;},
attachRoutePatternMatched:function(D,F,o){this.attachEvent("routePatternMatched",D,F,o);return this;},
detachRoutePatternMatched:function(F,o){this.detachEvent("routePatternMatched",F,o);return this;},
fireRoutePatternMatched:function(p){this.fireEvent("routePatternMatched",p);return this;},
attachBypassed:function(D,F,o){return this.attachEvent(f.M_EVENTS.BYPASSED,D,F,o);},
detachBypassed:function(F,o){return this.detachEvent(f.M_EVENTS.BYPASSED,F,o);},
fireBypassed:function(p){return this.fireEvent(f.M_EVENTS.BYPASSED,p);},
attachTitleChanged:function(D,F,o){this.attachEvent(f.M_EVENTS.TITLE_CHANGED,D,F,o);return this;},
detachTitleChanged:function(F,o){return this.detachEvent(f.M_EVENTS.TITLE_CHANGED,F,o);},
fireTitleChanged:function(p){if(this.isStopped()){return this;}var I=!this._pWaitForTitleChangedOnChild;if(!p.propagated){p.propagated=false;var D=a.getInstance().getDirection(),s=this.getHashChanger().getHash(),j=l.routing.HistoryDirection,o=this._aHistory[this._aHistory.length-1],n;if(D===j.Backwards&&o&&!o.isHome){if(o&&o.title!==p.title){this._aHistory.pop();}}else if(o&&o.hash==s){o.title=p.title;this._aHistory.some(function(k,i,m){if(i<m.length-1&&d(k,o)){return m.splice(i,1);}});}else{if(this._bLastHashReplaced){this._aHistory.pop();}n={hash:s,title:p.title};this._aHistory.some(function(k,i,m){if(d(k,n)){return m.splice(i,1);}});this._aHistory.push(n);}p.history=this._aHistory.slice(0,-1);p.nestedHistory=[{history:this.getTitleHistory(),ownerComponentId:this._oOwner&&this._oOwner.getId()}];this._bLastHashReplaced=false;this._oPreviousTitleChangedRoute=this._oMatchedRoute;this._bFireTitleChanged=false;if(this._pWaitForTitleChangedOnChild){this._pWaitForTitleChangedOnChild.then(function(i){p.title=i.title;p.propagated=true;Array.prototype.push.apply(p.nestedHistory,i.nestedHistory);this._stopWaitingTitleChangedFromChild();this.fireEvent(f.M_EVENTS.TITLE_CHANGED,p);}.bind(this));}}if(I){if(this._bMatchingProcessStarted&&this._isAsync()){this.attachEventOnce("routeMatched",function(){this.fireEvent(f.M_EVENTS.TITLE_CHANGED,p);},this);}else{this.fireEvent(f.M_EVENTS.TITLE_CHANGED,p);}}return this;},
getTitleHistory:function(){return this._aHistory||[];},
_waitForTitleChangedOn:function(n){if(this._bFireTitleChanged){this._pWaitForTitleChangedOnChild=new Promise(function(i){this._fnTitleChangedFiredOnChild=i;}.bind(this));}},
_stopWaitingTitleChangedFromChild:function(){delete this._pWaitForTitleChangedOnChild;delete this._fnTitleChangedFiredOnChild;},
register:function(n){r[n]=this;return this;},
_onBypassed:function(s){var F=function(){this.fireBypassed({hash:s});}.bind(this);if(this._oConfig.bypassed){var o=this._oTargets.display(this._oConfig.bypassed.target,{hash:s});if(o instanceof Promise){o.then(F);return;}}F();},
_isAsync:function(){return this._oConfig._async;},
metadata:{publicMethods:["initialize","getURL","register","getRoute"]}
});
function g(s,i){return i&&i.indexOf(s)>-1;}
function h(o,i){var s=i.getPattern(),A=o&&o.getManifestEntry("sap.app/title");if(s===""||(s!==undefined&&!/({.*})+/.test(s))){return{hash:s,isHome:true,title:A};}else{L.error("Routes with dynamic parts cannot be resolved as home route.");}}
f.M_EVENTS={BEFORE_ROUTE_MATCHED:"beforeRouteMatched",ROUTE_MATCHED:"routeMatched",ROUTE_PATTERN_MATCHED:"routePatternMatched",VIEW_CREATED:"viewCreated",BYPASSED:"bypassed",TITLE_CHANGED:"titleChanged"};f._interceptRouteMatched=undefined;
f.getRouter=function(n){return r[n];};
return f;});
sap.ui.predefine('sap/ui/core/routing/RouterHashChanger',['./HashChangerBase',"sap/base/Log"],function(H,L){"use strict";
var R=H.extend("sap.ui.core.routing.RouterHashChanger",{constructor:function(s){if(!s||!s.parent){throw new Error("sap.ui.core.routing.RouterHashChanger can't be instantiated without a parent");}this.parent=s.parent;this.hash=s.hash||"";this.subHashMap=s.subHashMap;this.key=s.key||"";H.apply(this);}});
R.InvalidHash=Object.create(null);
R.prototype.init=function(){this.parent.init();};
R.prototype._generatePrefixedKey=function(k){return this.key?(this.key+"-"+k):k;};
R.prototype.createSubHashChanger=function(k){this.children=this.children||{};var p=this._generatePrefixedKey(k);if(this.children[p]){return this.children[p];}var c=new R({key:p,parent:this,subHashMap:this.subHashMap,hash:(this.subHashMap&&this.subHashMap[p])||""});c.attachEvent("hashSet",this._onChildHashChanged.bind(this,p));c.attachEvent("hashReplaced",this._onChildHashChanged.bind(this,p));this.children[p]=c;return c;};
R.prototype.fireHashChanged=function(h,s,u){var k,o=this.hash;this.hash=h;this.subHashMap=s;if(!u&&h!==o){this.fireEvent("hashChanged",{newHash:h,oldHash:o});}if(this.children){k=Object.keys(this.children);k.forEach(function(c){var C=(s[c]===undefined?"":s[c]);this.children[c].fireHashChanged(C,s,u);}.bind(this));}};
R.prototype._onChildHashChanged=function(k,e){var c=e.getParameter("key")||k,h=e.getParameter("hash"),n=e.getParameter("nestedHashInfo"),d=e.getParameter("deletePrefix");if(this._bCollectMode){this._collectHash(c,h,d);}else{this.fireEvent(e.getId(),{hash:h,key:c,nestedHashInfo:n,deletePrefix:d});}};
R.prototype._collectHash=function(k,h,d){this._aCollectedHashInfo=this._aCollectedHashInfo||[];this._aCollectedHashInfo.push({key:k,hash:h,deletePrefix:d});};
R.prototype._hasRouterAttached=function(){return this.hasListeners("hashChanged");};
R.prototype._collectActiveDescendantPrefix=function(){if(this.children){var k=Object.keys(this.children);return k.reduce(function(p,K){var c=this.children[K];if(c._hasRouterAttached()){p.push(K);Array.prototype.push.apply(p,c._collectActiveDescendantPrefix());}return p;}.bind(this),[]);}else{return[];}};
R.prototype.getHash=function(){if(this._isUnderCollectMode()){return R.InvalidHash;}else{return this.hash;}};
R.prototype.resetHash=function(){this.hash=undefined;return this;};
R.prototype.setHash=function(h,p,s){if(!(p instanceof Promise)){s=p;p=null;}return this._modifyHash(h,p,s);};
R.prototype.replaceHash=function(h,p,s){if(!(p instanceof Promise)){s=p;p=null;}return this._modifyHash(h,p,s,true);};
R.prototype._modifyHash=function(h,p,s,r){var a,e=r?"hashReplaced":"hashSet",t=this;if(!s){a=this._collectActiveDescendantPrefix();}if(p){this._bCollectMode=true;return p.then(function(){t.fireEvent(e,{hash:h,nestedHashInfo:t._aCollectedHashInfo,deletePrefix:a});t._aCollectedHashInfo=null;t._bCollectMode=false;});}else{this.fireEvent(e,{hash:h,deletePrefix:a});}};
R.prototype._isUnderCollectMode=function(){return this.parent instanceof R&&this.parent._isInCollectMode();};
R.prototype._isInCollectMode=function(){return this._bCollectMode||(this.parent instanceof R&&this.parent._isInCollectMode());};
R.prototype.destroy=function(){this.parent.deregisterRouterHashChanger(this);if(this.children){Object.keys(this.children).forEach(function(k){var c=this.children[k];c.destroy();}.bind(this));delete this.children;}delete this.hash;delete this.subHashMap;delete this.parent;delete this.key;H.prototype.destroy.apply(this,arguments);};
R.prototype.deregisterRouterHashChanger=function(r){if(this.children){Object.keys(this.children).some(function(k){var c=this.children[k];if(c===r){delete this.children[k];return true;}}.bind(this));}};
return R;});
sap.ui.predefine('sap/ui/core/routing/Target',['sap/ui/core/Control','sap/ui/base/EventProvider','sap/ui/core/mvc/View','sap/ui/core/routing/async/Target','sap/ui/core/routing/sync/Target',"sap/base/util/UriParameters","sap/base/Log"],function(C,E,V,a,s,U,L){"use strict";
var T=E.extend("sap.ui.core.routing.Target",{
constructor:function(o,c){var e;function d(){if(U.fromQuery(window.location.search).get("sap-ui-xx-asyncRouting")==="true"){L.warning("Activation of async view loading in routing via url parameter is only temporarily supported and may be removed soon","Target");return true;}return false;}if(o._async===undefined){o._async=d();}if(o.type==="Component"&&!o._async){e="sap.ui.core.routing.Target doesn't support loading component in synchronous mode, please switch routing to async";L.error(e);throw new Error(e);}this._updateOptions(o);this._oCache=c;E.apply(this,arguments);if(this._oOptions.title){this._oTitleProvider=new b({target:this});}var f=this._oOptions._async?a:s;for(var g in f){this[g]=f[g];}this._bIsDisplayed=false;this._bIsLoaded=false;},
destroy:function(){this._oParent=null;this._oOptions=null;this._oCache=null;if(this._oTitleProvider){this._oTitleProvider.destroy();}this._oTitleProvider=null;E.prototype.destroy.apply(this,arguments);this.bIsDestroyed=true;return this;},
attachDisplay:function(d,f,l){return this.attachEvent(this.M_EVENTS.DISPLAY,d,f,l);},
detachDisplay:function(f,l){return this.detachEvent(this.M_EVENTS.DISPLAY,f,l);},
fireDisplay:function(p){var t=this._oTitleProvider&&this._oTitleProvider.getTitle();if(t){this.fireTitleChanged({name:this._oOptions._name,title:t});}this._bIsDisplayed=true;return this.fireEvent(this.M_EVENTS.DISPLAY,p);},
attachTitleChanged:function(d,f,l){var h=this.hasListeners("titleChanged"),t=this._oTitleProvider&&this._oTitleProvider.getTitle();this.attachEvent(this.M_EVENTS.TITLE_CHANGED,d,f,l);if(!h&&t&&this._bIsDisplayed){this.fireTitleChanged({name:this._oOptions._name,title:t});}return this;},
detachTitleChanged:function(f,l){return this.detachEvent(this.M_EVENTS.TITLE_CHANGED,f,l);},
fireTitleChanged:function(p){return this.fireEvent(this.M_EVENTS.TITLE_CHANGED,p);},
_getEffectiveObjectName:function(n){var p=this._oOptions.path;if(p){n=p+"."+n;}return n;},
_updateOptions:function(o){if(o.viewName){if(o.name){o._name=o.name;}o.type="View";o.name=o.viewName;if(o.viewPath){o.path=o.viewPath;}if(o.viewId){o.id=o.viewId;}}this._oOptions=o;},
_bindTitleInTitleProvider:function(v){if(this._oTitleProvider&&v instanceof V){this._oTitleProvider.applySettings({title:this._oOptions.title},v.getController());}},
_addTitleProviderAsDependent:function(v){if(!this._oTitleProvider){return;}var o=this._oTitleProvider.getParent();if(o){o.removeDependent(this._oTitleProvider);}if(v instanceof V){v.addDependent(this._oTitleProvider);}},
_beforePlacingViewIntoContainer:function(A){},
M_EVENTS:{DISPLAY:"display",TITLE_CHANGED:"titleChanged"}
});
var b=C.extend("sap.ui.core.routing.Target.TitleProvider",{
metadata:{library:"sap.ui.core",properties:{title:{type:"string",group:"Data",defaultValue:null}}},
constructor:function(S){this._oTarget=S.target;delete S.target;C.prototype.constructor.call(this,S);},
setTitle:function(t){this.setProperty("title",t,true);if(this._oTarget._bIsDisplayed&&t){this._oTarget.fireTitleChanged({name:this._oTarget._oOptions._name,title:t});}}
});
return T;});
sap.ui.predefine('sap/ui/core/routing/TargetCache',['sap/ui/base/EventProvider','sap/ui/core/routing/async/TargetCache','sap/ui/core/routing/sync/TargetCache',"sap/base/assert","sap/base/Log"],function(E,a,s,b,L){"use strict";
var T=E.extend("sap.ui.core.routing.TargetCache",{
constructor:function(o){if(!o){o={};}this._oCache={view:{},component:{}};this._oComponent=o.component;if(this._oComponent){b(this._oComponent.isA("sap.ui.core.UIComponent"),this+' - the component passed to the constructor needs to be an instance of UIComponent');}E.apply(this,arguments);this.async=o.async;if(this.async===undefined){this.async=true;}var C=this.async?a:s;for(var f in C){this[f]=C[f];}},
metadata:{publicMethods:["get","set"]},
get:function(o,t){var O;try{if(t==="Component"&&!this.async){L.error("sap.ui.core.routing.Target doesn't support loading component in synchronous mode, please switch routing to async");throw new Error("sap.ui.core.routing.Target doesn't support loading component in synchronous mode, please switch routing to async");}if(!o){L.error("the oOptions parameter of getObject is mandatory",this);throw new Error("the oOptions parameter of getObject is mandatory");}O=this._get(o,t);}catch(e){return Promise.reject(e);}if(O instanceof Promise){return O;}else if(O.isA("sap.ui.core.mvc.View")){return O.loaded();}else{return Promise.resolve(O);}},
set:function(n,t,o){var i;this._checkName(n,t);b(t==="View"||t==="Component","sType must be either 'View' or 'Component'");i=this._oCache[t.toLowerCase()][n];if(!i){i=this._oCache[t.toLowerCase()][n]={};}i[undefined]=o;return this;},
destroy:function(){E.prototype.destroy.apply(this);if(this.bIsDestroyed){return this;}function d(o){if(o&&o.destroy){o.destroy();}}Object.keys(this._oCache).forEach(function(t){var o=this._oCache[t];Object.keys(o).forEach(function(k){var i=o[k];Object.keys(i).forEach(function(I){var O=i[I];if(O instanceof Promise){O.then(d);}else{d(O);}});});}.bind(this));this._oCache=undefined;this.bIsDestroyed=true;return this;},
attachCreated:function(d,f,l){return this.attachEvent("created",d,f,l);},
detachCreated:function(f,l){return this.detachEvent("created",f,l);},
fireCreated:function(p){return this.fireEvent("created",p);},
_get:function(o,t,g,i){var O;switch(t){case"View":O=this._getView(o,g);break;case"Component":O=this._getComponent(o,g,i);break;default:throw Error("The given sType: "+t+" isn't supported by TargetCache.getObject");}return O;},
_getView:function(o,g){if(!g){o=this._createId(o);}return this._getViewWithGlobalId(o);},
_getComponent:function(o,g,i){if(!g){o=this._createId(o);}return this._getComponentWithGlobalId(o,i);},
_createId:function(o){if(this._oComponent&&o.id){o=Object.assign({},o,{id:this._oComponent.createId(o.id)});}return o;},
_checkName:function(n,t){if(!n){var m="A name for the "+t.toLowerCase()+" has to be defined";L.error(m,this);throw Error(m);}}
});
return T;});
sap.ui.predefine('sap/ui/core/routing/Targets',['sap/ui/base/EventProvider','./Target','./async/Targets','./sync/Targets',"sap/base/util/UriParameters","sap/base/Log","sap/base/util/deepExtend"],function(E,T,a,s,U,L,d){"use strict";
var b=E.extend("sap.ui.core.routing.Targets",{
constructor:function(o){var t,c;E.apply(this);this._mTargets={};this._oLastTitleTarget={};this._oConfig=o.config;this._oCache=o.cache||o.views;if(!this._oConfig){this._oConfig={_async:false};}function e(){if(U.fromQuery(window.location.search).get("sap-ui-xx-asyncRouting")==="true"){L.warning("Activation of async view loading in routing via url parameter is only temporarily supported and may be removed soon","Targets");return true;}return false;}if(this._oConfig._async===undefined){this._oConfig._async=(this._oConfig.async===undefined)?e():this._oConfig.async;}var f=this._oConfig._async?a:s;for(var g in f){this[g]=f[g];}for(t in o.targets){if(o.targets.hasOwnProperty(t)){this._createTarget(t,o.targets[t]);}}for(c in this._mTargets){if(this._mTargets.hasOwnProperty(c)){this._addParentTo(this._mTargets[c]);}}},
_setRouter:function(r){if(!this._oRouter){this._oRouter=r;}else{L.warning("The Targets is already connected with a router and this call of _setRouter is ignored");}return this;},
destroy:function(){var t;E.prototype.destroy.apply(this);for(t in this._mTargets){if(this._mTargets.hasOwnProperty(t)){this._mTargets[t].destroy();}}this._mTargets=null;this._oCache=null;this._oConfig=null;this.bIsDestroyed=true;return this;},
getViews:function(){return this._oCache;},
getCache:function(){return this._oCache;},
getTarget:function(n,S){var t=this,c=this._alignTargetsInfo(n),e;e=c.reduce(function(A,C){var o=t._mTargets[C.name];if(o){A.push(o);}else if(!S){L.error("The target you tried to get \""+C.name+"\" does not exist!",t);}return A;},[]);return e.length<=1?e[0]:e;},
addTarget:function(n,t){var o=this.getTarget(n,true),c;if(o){L.error("Target with name "+n+" already exists",this);}else{c=this._createTarget(n,t);this._addParentTo(c);}return this;},
suspend:function(t){var c=this._alignTargetsInfo(t);c.forEach(function(o){var e=o.name;var f=this.getTarget(e);if(f){f.suspend();}}.bind(this));return this;},
attachDisplay:function(D,f,l){return this.attachEvent(this.M_EVENTS.DISPLAY,D,f,l);},
detachDisplay:function(f,l){return this.detachEvent(this.M_EVENTS.DISPLAY,f,l);},
fireDisplay:function(p){return this.fireEvent(this.M_EVENTS.DISPLAY,p);},
attachTitleChanged:function(D,f,l){this.attachEvent(this.M_EVENTS.TITLE_CHANGED,D,f,l);return this;},
detachTitleChanged:function(f,l){return this.detachEvent(this.M_EVENTS.TITLE_CHANGED,f,l);},
fireTitleChanged:function(p){if(this._oLastTitleTarget.name!==p.name||this._oLastTitleTarget.title!==p.title){this._oLastTitleTarget.name=p.name;this._oLastTitleTarget.title=p.title;this.fireEvent(this.M_EVENTS.TITLE_CHANGED,p);}return this;},
M_EVENTS:{DISPLAY:"display",TITLE_CHANGED:"titleChanged"},
_alignTargetsInfo:function(t){if(t===undefined){return[];}if(!Array.isArray(t)){return(typeof t==="object")?[t]:[{name:t}];}return t.map(function(v){if(typeof v!=="object"){v={name:v};}return v;});},
_createTarget:function(n,t){var o,O;O=d({_name:n},this._oConfig,t);o=this._constructTarget(O);o.attachDisplay(function(e){var p=e.getParameters();this.fireDisplay({name:n,view:p.view,object:p.object,control:p.control,config:p.config,data:p.data,routeRelevant:p.routeRelevant});},this);this._mTargets[n]=o;return o;},
_addParentTo:function(t){var p,P=t._oOptions.parent;if(!P){return;}p=this._mTargets[P];if(!p){L.error("The target '"+t._oOptions._name+" has a parent '"+P+"' defined, but it was not found in the other targets",this);return;}t._oParent=p;},
_constructTarget:function(o,p){return new T(o,this._oCache,p);},
_setRootViewId:function(i){var t,o;for(t in this._mTargets){if(this._mTargets.hasOwnProperty(t)){o=this._mTargets[t]._oOptions;if(o.rootView===undefined){o.rootView=i;}}}},
_getTitleTargetName:function(t,p){var o,c;if(p){t=[p];}t=this._alignTargetsInfo(t);t.some(function(e){o=this.getTarget(e);while(o&&!o._oOptions.title){o=o._oParent;}if(o){c=o._oOptions._name;return true;}}.bind(this));return c;},
_forwardTitleChanged:function(e){this.fireTitleChanged({name:e.getParameter("name"),title:e.getParameter("title")});},
_attachTitleChanged:function(t,c){var o,C;C=this._getTitleTargetName(t,c);if(C){o=this.getTarget(C);}if(this._oLastDisplayedTitleTarget){this._oLastDisplayedTitleTarget.detachTitleChanged(this._forwardTitleChanged,this);this._oLastDisplayedTitleTarget._bIsDisplayed=false;}if(o){o.attachTitleChanged({name:o._oOptions._name},this._forwardTitleChanged,this);this._oLastDisplayedTitleTarget=o;}else if(c){L.error("The target with the name \""+c+"\" where the titleChanged event should be fired does not exist!",this);}}
});
return b;});
sap.ui.predefine('sap/ui/core/routing/Views',["./TargetCache","sap/base/util/UriParameters","sap/base/Log"],function(T,U,L){"use strict";
var V=T.extend("sap.ui.core.routing.Views",{
metadata:{publicMethods:["getView","setView"]},
constructor:function(o){if(!o){o={};}function c(){if(U.fromQuery(window.location.search).get("sap-ui-xx-asyncRouting")==="true"){L.warning("Activation of async view loading in routing via url parameter is only temporarily supported and may be removed soon","TargetCache");return true;}return false;}if(o.async===undefined){o.async=c();}T.apply(this,[o]);},
getView:function(o){return this.get(o,"View");},
setView:function(v,o){return this.set(v,"View",o);},
fireCreated:function(p){if(p){p.view=p.object;p.viewOptions=p.options;}return this.fireEvent("created",p);}
});
return V;});
sap.ui.predefine('sap/ui/core/routing/async/Route',['sap/ui/Device',"sap/base/Log","sap/base/util/extend","sap/ui/core/Component"],function(D,L,e,C){"use strict";return{_routeMatched:function(a,s,n){var r=this._oRouter,t,T,c,E,v=null,o=null,i,b,d,A,f=this;r._stopWaitingTitleChangedFromChild();r._oMatchedRoute=this;r._bMatchingProcessStarted=true;c=e({},r._oConfig,this._oConfig);T=r.getTargets();var g;if(T){g=T._getTitleTargetName(c.target,c.titleTarget);if(g&&r._oPreviousTitleChangedRoute!==this){r._bFireTitleChanged=true;if((r._oOwner&&r._oOwner._bRoutingPropagateTitle)){var p=C.getOwnerComponentFor(r._oOwner);var P=p&&p.getRouter();if(P){P._waitForTitleChangedOn(r);}}}else{r._bFireTitleChanged=false;}if(this._oConfig.target){A=T._alignTargetsInfo(this._oConfig.target);A.forEach(function(t){t.propagateTitle=t.hasOwnProperty("propagateTitle")?t.propagateTitle:r._oConfig.propagateTitle;t.routeRelevant=true;});}}else{A=this._oConfig.target;}if(!s||s===true){i=true;s=Promise.resolve();}if(this._oParent){s=this._oParent._routeMatched(a,s);}else if(this._oNestingParent){this._oNestingParent._routeMatched(a,s,this);}b=Object.assign({},a);b.routeConfig=c;E={name:c.name,arguments:a,config:c};if(n){E.nestedRoute=n;}this.fireBeforeMatched(E);r.fireBeforeRouteMatched(E);if(this._oTarget){t=this._oTarget;t._updateOptions(this._convertToTargetOptions(c));s=t._place(s);if(this._oRouter._oTargetHandler&&this._oRouter._oTargetHandler._chainNavigation){d=s;s=this._oRouter._oTargetHandler._chainNavigation(function(){return d;});}}else{if(D.browser.msie||D.browser.edge){d=s;s=new Promise(function(h,j){setTimeout(function(){if(r._oTargets){var k=r._oTargets._display(A,b,f._oConfig.titleTarget,d);k.then(h,j);}else{h();}},0);});}else{s=r._oTargets._display(A,b,this._oConfig.titleTarget,s);}}return s.then(function(R){r._bMatchingProcessStarted=false;var h,V,j;if(Array.isArray(R)){h=R;R=h[0];}R=R||{};v=R.view;o=R.control;E.view=v;E.targetControl=o;if(h){V=[];j=[];h.forEach(function(R){V.push(R.view);j.push(R.control);});E.views=V;E.targetControls=j;}if(c.callback){c.callback(this,a,c,o,v);}this.fireEvent("matched",E);r.fireRouteMatched(E);if(i){L.info("The route named '"+c.name+"' did match with its pattern",this);this.fireEvent("patternMatched",E);r.fireRoutePatternMatched(E);}return R;}.bind(this));}};});
sap.ui.predefine('sap/ui/core/routing/async/Target',["sap/base/Log","sap/ui/core/ComponentContainer","sap/ui/core/library"],function(L,C,c){"use strict";var a=c.ComponentLifecycle;return{display:function(d){var s=Promise.resolve();return this._display(d,s);},_display:function(d,s,t){if(this._oParent){s=this._oParent._display(d,s,t);}return this._place(d,s,t);},suspend:function(){if(this._oParent){this._oParent.suspend();}if(this._isLoaded()){var o=this._get(),r;if(o.isA("sap.ui.core.UIComponent")&&(r=o.getRouter())&&o.hasNativeRouter()){r.stop();}}else{L.warning("The target with name '"+this._oOptions._name+"' can't be suspended because it's being loaded or not loaded yet");}return this;},_isLoaded:function(){return this._bIsLoaded;},_get:function(t){var n=this._getEffectiveObjectName(this._oOptions.name),o=this._oOptions,b;switch(o.type){case"View":b={name:n,type:o.viewType,id:o.id,async:true};break;case"Component":b={id:o.id};if(o.usage){b.usage=o.usage;}else{b.name=n;}b=Object.assign({},o.options||{},b);break;default:throw new Error("The given type "+o.type+" isn't support by sap.ui.core.routing.Target");}return this._oCache._get(b,o.type,this._bUseRawViewId,t);},_load:function(t){var o=this._get(t),p;if(!(o instanceof Promise)){if(o.isA("sap.ui.core.mvc.View")){p=o.loaded();}else{p=Promise.resolve(o);}}else{p=o;}return p.then(function(o){this._bIsLoaded=true;return o;}.bind(this));},_place:function(d,s,t){if(d instanceof Promise){t=s;s=d;d=undefined;}var o=this._oOptions,b=this,O,e,p,i=true,r,f;if((o.name||o.usage)&&o.type){f=new Promise(function(g){r=g;});p=this._load(t).then(function(O){if(O.isA("sap.ui.core.UIComponent")){var R=O.getRouter();if(R&&O.hasNativeRouter()){var h=R.getHashChanger().getHash();var g=R.getRouteByHash(h);if(!R._oConfig.async){throw new Error("The router of component '"+O.getId()+"' which is loaded via the target '"+b._oOptions._name+"' is defined as synchronous which is not supported using as a nested component.");}if(R._oOwner){R._oOwner._bRoutingPropagateTitle=t.propagateTitle;}if(g&&g._oConfig.target){i=false;R.attachRouteMatched(r);}if(R.isStopped()){R.initialize();}}}if(i){r();}return O;});s=s.then(function(P){return p.then(function(O){return{object:O,parentInfo:P||{}};});}).then(function(v){var V=b._isValid(v.parentInfo),g,R;O=v.object;if(O.isA("sap.ui.core.UIComponent")){R=O.getRootControl();if(R&&R.isA("sap.ui.core.mvc.View")){g=R;}}else{g=O;}b._bindTitleInTitleProvider(g);b._addTitleProviderAsDependent(g);if(V!==true){e=V;return b._refuseInvalidTarget(o._name,e);}var h=v.parentInfo.view,j=v.parentInfo.control,k=Promise.resolve(j);if(h&&h.isA("sap.ui.core.ComponentContainer")){h=h.getComponentInstance().getRootControl();}if(!h&&o.rootView){h=sap.ui.getCore().byId(o.rootView);if(!h){e="Did not find the root view with the id "+o.rootView;return b._refuseInvalidTarget(o._name,e);}}if(o.controlId){if(h&&h.isA("sap.ui.core.mvc.View")){k=h.loaded().then(function(l){return l.byId(o.controlId);});}k=k.then(function(l){if(!l){l=sap.ui.getCore().byId(o.controlId);}if(!l){e="Control with ID "+o.controlId+" could not be found";return b._refuseInvalidTarget(o._name,e);}else{return l;}});}return k;}).then(function(g){var h,j,k;if(O.isA("sap.ui.core.UIComponent")){h=O;j=h.getId()+"-container";O=sap.ui.getCore().byId(j);if(!O){var l=Object.assign({component:h,height:"100%",width:"100%",lifecycle:a.Application},o.containerOptions);O=new C(j,l);k=h.destroy;h.destroy=function(){if(k){k.apply(this);}O.destroy();};}}b._beforePlacingViewIntoContainer({container:g,view:O,data:d});var A=g.getMetadata().getJSONKeys()[o.controlAggregation];if(!A){e="Control "+o.controlId+" does not have an aggregation called "+o.controlAggregation;return b._refuseInvalidTarget(o._name,e);}if(o.clearControlAggregation===true){g[A._sRemoveAllMutator]();}L.info("Did place the "+o.type.toLowerCase()+" target '"+(o.name?b._getEffectiveObjectName(o.name):o.usage)+"' with the id '"+O.getId()+"' into the aggregation '"+o.controlAggregation+"' of a control with the id '"+g.getId()+"'",b);g[A._sMutator](O);return{name:o._name,view:O,control:g};});}else{s=s.then(function(){return{name:o._name};});}return Promise.all([s,f]).then(function(g){var h=g[0].control;var O=g[0].view;if(h&&O){b.fireDisplay({view:O.isA("sap.ui.core.mvc.View")?O:undefined,object:O,control:h,config:b._oOptions,data:d,routeRelevant:b._routeRelevant});}return g[0];});},_isValid:function(p){var o=this._oOptions,b=p&&p.control,h=(b||o.controlId),i=true,l="";if(!h){l="The target "+o._name+" has no controlId set and no parent so the target cannot be displayed.";i=false;}if(!o.controlAggregation){l="The target "+o._name+" has a control id or a parent but no 'controlAggregation' was set, so the target could not be displayed.";i=false;}if(l){L.error(l,this);}return i||l;},_refuseInvalidTarget:function(n,m){return Promise.reject(new Error(m+" - Target: "+n));}};});
sap.ui.predefine('sap/ui/core/routing/async/TargetCache',["sap/ui/core/mvc/View","sap/ui/core/Component","sap/ui/core/routing/HashChanger","sap/ui/core/library"],function(V,C,H,l){"use strict";var a=l.mvc.ViewType;return{_getObjectWithGlobalId:function(o,t,T){var b=this,p,n,i,O=this._oComponent,w=[];T=T||{};function c(){switch(t){case"View":o.viewName=o.name;delete o.name;if(o.type===a.XML&&!o.processingMode){o.processingMode="sequential";}return V._legacyCreate(o);case"Component":o.settings=o.settings||{};o.settings._propagateTitle=T.propagateTitle;var r=b._createRouterHashChanger(T.prefix);if(r){o.settings._routerHashChanger=r;}if(o.usage){return O.createComponent(o);}else{return C.create(o);}break;default:}}function d(e){if(b._oCache){w.forEach(function(I){i[I]=e;});if(T.afterCreate){T.afterCreate(e);}b.fireCreated({object:e,type:t,options:o});}return e;}if(o.async===undefined){o.async=true;}n=o.usage||o.name;this._checkName(n,t);i=this._oCache[t.toLowerCase()][n];p=i&&i[o.id];if(p){return p;}if(O){p=O.runAsOwner(c);}else{p=c();}if(p instanceof Promise){p=p.then(d);}else{p.loaded().then(d);}if(!i){i=this._oCache[t.toLowerCase()][n]={};i[undefined]=p;w.push(undefined);}if(o.id!==undefined){i[o.id]=p;w.push(o.id);}return p;},_getViewWithGlobalId:function(o){if(o&&!o.name){o.name=o.viewName;}return this._getObjectWithGlobalId(o,"View");},_getComponentWithGlobalId:function(o,t){return this._getObjectWithGlobalId(o,"Component",t);},_createRouterHashChanger:function(p){var r;var R=this._oComponent&&this._oComponent.getRouter();if(R){r=R.getHashChanger();if(r&&p){r=r.createSubHashChanger(p);}}return r||H.getInstance().createRouterHashChanger();}};});
sap.ui.predefine('sap/ui/core/routing/async/Targets',["sap/base/Log"],function(L){"use strict";return{display:function(t,d,T){var s=Promise.resolve();return this._display(t,d,T,s);},_display:function(t,d,T,s){var a=this,v=[];if(!Array.isArray(t)){t=[t];}this._attachTitleChanged(t,T);return this._alignTargetsInfo(t).reduce(function(p,o){var b={prefix:o.prefix,propagateTitle:o.propagateTitle||false};return a._displaySingleTarget(o,d,p,b).then(function(V){V=V||{};V.targetInfo=o;v.push(V);});},s).then(function(){return v;});},_addDynamicTargetToRoute:function(t){if(this._oRouter){var r=this._oRouter._getLastMatchedRouteName();var R,s;if(r){R=this._oRouter.getRoute(r);if(R&&R._oConfig&&R._oConfig.target){s=this._alignTargetsInfo(R._oConfig.target).some(function(c){return c.name===t.name;});if(!s){R._oConfig.dynamicTarget=R._oConfig.dynamicTarget||[];R._oConfig.dynamicTarget.push(t);}}}}},_displaySingleTarget:function(t,d,s,T){var n=t.name,o=this.getTarget(n);if(o!==undefined){o._routeRelevant=t.routeRelevant||false;if(t.routeRelevant){this._addDynamicTargetToRoute(t);}return o._display(d,s,T);}else{var e="The target with the name \""+n+"\" does not exist!";L.error(e,this);return Promise.resolve({name:n,error:e});}}};});
sap.ui.predefine('sap/ui/core/routing/sync/Route',["sap/base/Log","sap/base/util/extend"],function(L,e){"use strict";return{_routeMatched:function(a,i,n){var r=this._oRouter,p,P,t,c,E,v=null,T=null,o,C,V,b,d;r._oMatchedRoute=this;r._bMatchingProcessStarted=true;if(this._oParent){p=this._oParent._routeMatched(a);}else if(this._oNestingParent){this._oNestingParent._routeMatched(a,false,this);}c=e({},r._oConfig,this._oConfig);o=Object.assign({},a);o.routeConfig=c;E={name:c.name,arguments:a,config:c};if(n){E.nestedRoute=n;}this.fireBeforeMatched(E);r.fireBeforeRouteMatched(E);if(this._oTarget){t=this._oTarget;t._updateOptions(this._convertToTargetOptions(c));if(t._isValid(p,false)){P=t._place(p);}P=P||{};v=P.oTargetParent;T=P.oTargetControl;E.view=v;E.targetControl=T;}else{V=[];b=[];C=function(f){V.push(f.getParameter("view"));b.push(f.getParameter("control"));};if(Array.isArray(this._oConfig.target)){d=this._oConfig.target;}else{d=[this._oConfig.target];}d.forEach(function(s){var t=r._oTargets.getTarget(s);if(t){t.attachEventOnce("display",C);}});r._oTargets._display(this._oConfig.target,o,this._oConfig.titleTarget);E.view=V[0];E.targetControl=b[0];E.views=V;E.targetControls=b;}r._bMatchingProcessStarted=false;if(c.callback){c.callback(this,a,c,T,v);}this.fireEvent("matched",E);r.fireRouteMatched(E);if(i){L.info("The route named '"+c.name+"' did match with its pattern",this);this.fireEvent("patternMatched",E);r.fireRoutePatternMatched(E);}return P;}};});
sap.ui.predefine('sap/ui/core/routing/sync/Target',["sap/base/Log"],function(L){"use strict";return{display:function(d){var p;if(this._oParent){p=this._oParent.display(d);}return this._place(p,d);},suspend:function(){return this;},_place:function(p,d){var o=this._oOptions;p=p||{};var v,c=p.oTargetControl,V=p.oTargetParent;if(!this._isValid(p,true)){return undefined;}if(!V&&o.rootView){V=sap.ui.getCore().byId(o.rootView);if(!V){L.error("Did not find the root view with the id "+o.rootView,this);return undefined;}}if(o.controlId){if(V){c=V.byId(o.controlId);}if(!c){c=sap.ui.getCore().byId(o.controlId);}if(!c){L.error("Control with ID "+o.controlId+" could not be found",this);return undefined;}}var a=c.getMetadata().getJSONKeys()[o.controlAggregation];if(!a){L.error("Control "+o.controlId+" does not have an aggregation called "+o.controlAggregation,this);return undefined;}var s=this._getEffectiveObjectName(o.viewName);var b={name:s,type:o.viewType,id:o.viewId};v=this._oCache._get(b,"View",this._bUseRawViewId);this._beforePlacingViewIntoContainer({container:c,view:v,data:d});this._bindTitleInTitleProvider(v);this._addTitleProviderAsDependent(v);if(o.clearControlAggregation===true){c[a._sRemoveAllMutator]();}L.info("Did place the view '"+s+"' with the id '"+v.getId()+"' into the aggregation '"+o.controlAggregation+"' of a control with the id '"+c.getId()+"'",this);c[a._sMutator](v);this.fireDisplay({view:v,control:c,config:this._oOptions,data:d});return{oTargetParent:v,oTargetControl:c};},_isValid:function(p,l){var o=this._oOptions,c=p&&p.oTargetControl,h=(c||o.controlId),i=true,s="";if(!h){s="The target "+o._name+" has no controlId set and no parent so the target cannot be displayed.";i=false;}if(!o.controlAggregation){s="The target "+o._name+" has a control id or a parent but no 'controlAggregation' was set, so the target could not be displayed.";i=false;}if(!o.viewName){s="The target "+o._name+" no viewName defined.";i=false;}if(l&&s){L.error(s,this);}return i;}};});
sap.ui.predefine('sap/ui/core/routing/sync/TargetCache',["sap/base/Log","sap/ui/core/mvc/View"],function(L,V){"use strict";return{_getObjectWithGlobalId:function(o){function c(){o.viewName=o.name;delete o.name;return V._legacyCreate(o);}var v,s=o.name,i;this._checkName(s,"View");i=this._oCache.view[s];v=i&&i[o.id];if(v){return v;}if(this._oComponent){v=this._oComponent.runAsOwner(c);}else{v=c();}i=this._oCache.view[s];if(!i){i=this._oCache.view[s]={};i[undefined]=v;}if(o.id!==undefined){i[o.id]=v;}this.fireCreated({object:v,type:"View",options:o});return v;},_getViewWithGlobalId:function(o){if(o&&!o.name){o.name=o.viewName;}return this._getObjectWithGlobalId(o);}};});
sap.ui.predefine('sap/ui/core/routing/sync/Targets',["sap/base/Log"],function(L){"use strict";return{display:function(t,d,T){this._display(t,d,T);},_display:function(t,d,T){var a=this;this._attachTitleChanged(t,T);if(Array.isArray(t)){t.forEach(function(s){a._displaySingleTarget(s,d);});}else{this._displaySingleTarget(t,d);}return this;},_displaySingleTarget:function(n,d){var t=this.getTarget(n);if(t!==undefined){t.display(d);}else{L.error("The target with the name \""+n+"\" does not exist!",this);}}};});
sap.ui.predefine('sap/ui/core/search/OpenSearchProvider',['sap/ui/core/library','./SearchProvider',"sap/base/Log","sap/base/security/encodeURL","sap/ui/thirdparty/jquery"],function(l,S,L,e,q){"use strict";
var O=S.extend("sap.ui.core.search.OpenSearchProvider",{metadata:{library:"sap.ui.core",properties:{suggestUrl:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},suggestType:{type:"string",group:"Misc",defaultValue:'json'}}}});
O.prototype.suggest=function(v,c){var u=this.getSuggestUrl();if(!u){return;}u=u.replace("{searchTerms}",e(v));var t=this.getSuggestType();var s;if(t&&t.toLowerCase()==="xml"){t="xml";s=function(d){var x=q(d);var i=x.find("Text");var a=[];i.each(function(){a.push(q(this).text());});c(v,a);};}else{t="json";s=function(d){c(v,d[1]);};}q.ajax({url:u,dataType:t,success:s,error:function(X,a,b){L.fatal("The following problem occurred: "+a,X.responseText+","+X.status);}});};
return O;});
sap.ui.predefine('sap/ui/core/search/SearchProvider',['sap/ui/core/Element','sap/ui/core/library',"sap/base/Log"],function(E,l,L){"use strict";
var S=E.extend("sap.ui.core.search.SearchProvider",{metadata:{"abstract":true,library:"sap.ui.core",properties:{icon:{type:"string",group:"Misc",defaultValue:null}}}});
S.prototype.suggest=function(v,c){L.warning("sap.ui.core.search.SearchProvider is the abstract base class for all SearchProviders. Do not create instances of this class, but use a concrete sub class instead.");};
return S;});
sap.ui.predefine('sap/ui/core/service/Service',['sap/ui/base/Object',"sap/base/assert","sap/base/Log"],function(B,a,L){"use strict";
var S=B.extend("sap.ui.core.service.Service",{
metadata:{"abstract":true,"library":"sap.ui.core"},
constructor:function(s){B.apply(this);if(s){a(typeof s.scopeObject==="object","The service context requires a scope object!");a(typeof s.scopeType==="string","The service context requires a scope type!");}this._oServiceContext=s;if(typeof this.init==="function"){this.init();}}
});
S.create=function(s){var A=function A(o){for(var m in s){if(!m.match(/^(metadata|constructor|getContext|destroy)$/)){this[m]=s[m];}else{L.warning("The member "+m+" is not allowed for anonymous service declaration and will be ignored!");}}S.apply(this,arguments);};A.prototype=Object.create(S.prototype);return A;};
S.prototype.getInterface=function(){var p=Object.create(null);for(var m in this){if(!m.match(/^_|^metadata$|^constructor$|^getInterface$|^destroy$|^init$|^exit$|^getContext$/)&&typeof this[m]==="function"){p[m]=this[m].bind(this);}}this.getInterface=function(){return p;};return p;};
S.prototype.getContext=function(){return this._oServiceContext;};
S.prototype.destroy=function(){if(typeof this.exit==="function"){this.exit();}B.prototype.destroy.apply(this,arguments);delete this._oServiceContext;};
return S;});
sap.ui.predefine('sap/ui/core/service/ServiceFactory',['sap/ui/base/Object','sap/ui/core/service/Service',"sap/base/assert"],function(B,S,a){"use strict";
var b=B.extend("sap.ui.core.service.ServiceFactory",{
metadata:{"library":"sap.ui.core"},
constructor:function(s){B.apply(this);var f=typeof s==="object"?S.create(s):s;a(!f||f&&typeof f==="function","The service constructor either should be undefined or a constructor function!");this._fnService=f;}
});
b.prototype.destroy=function(){B.prototype.destroy.apply(this,arguments);delete this._fnService;};
b.prototype.createInstance=function(s){if(typeof this._fnService==="function"){return Promise.resolve(new this._fnService(s));}else{return Promise.reject(new Error("Usage of sap.ui.core.service.ServiceFactory requires a service constructor function to create a new service instance or to override the createInstance function!"));}};
return b;});
sap.ui.predefine('sap/ui/core/service/ServiceFactoryRegistry',['./ServiceFactory',"sap/base/assert"],function(S,a){"use strict";var s=Object.create(null);var b=Object.create(null);
b.register=function(c,o){a(c,"sServiceFactoryName must not be empty, null or undefined");a(o instanceof S,"oServiceFactory must be an instance of sap.ui.core.service.ServiceFactory");s[c]=o;return this;};
b.unregister=function(c){a(c,"sServiceFactoryName must not be empty, null or undefined");delete s[c];return this;};
b.get=function(c){return s[c];};
return b;},true);
sap.ui.predefine('sap/ui/core/syncStyleClass',['sap/ui/thirdparty/jquery','sap/ui/base/Object','sap/base/assert'],function(q,B,a){"use strict";var s=function(S,v,d){if(!S){return d;}if(B.isA(v,'sap.ui.core.Control')){v=v.$();}else if(typeof v==="string"){v=q(document.getElementById(v));}else if(!(v instanceof q)){a(false,'sap/ui/core/syncStyleClass(): vSource must be a jQuery object or a Control or a string');return d;}var c=!!v.closest("."+S).length;if(d instanceof q){d.toggleClass(S,c);}else if(B.isA(d,'sap.ui.core.Control')){d.toggleStyleClass(S,c);}else{a(false,'sap/ui/core/syncStyleClass(): vDestination must be a jQuery object or a Control');}return d;};return s;});
sap.ui.predefine('sap/ui/core/theming/Parameters',['sap/ui/thirdparty/URI','../Element','sap/base/util/UriParameters','sap/base/Log','sap/base/util/extend','sap/ui/core/ThemeCheck','sap/ui/thirdparty/jquery'],function(U,E,a,L,e,T,q){"use strict";var c=window["sap-ui-config"]||{};var s=0;if(c['xx-nosync']==='warn'||/(?:\?|&)sap-ui-xx-nosync=(?:warn)/.exec(window.location.search)){s=1;}if(c['xx-nosync']===true||c['xx-nosync']==='true'||/(?:\?|&)sap-ui-xx-nosync=(?:x|X|true)/.exec(window.location.search)){s=2;}var P={};var p=null;var t=null;var b=[];var r=/url[\s]*\('?"?([^\'")]*)'?"?\)/;var u=a.fromQuery(window.location.search).get("sap-ui-xx-no-inline-theming-parameters")!=="true";
function d(){p=null;}
function f(i,j){var M=r.exec(i);if(M){var k=new U(M[1]);if(k.is("relative")){var N=k.absoluteTo(j).normalize().toString();i="url('"+N+"')";}}return i;}
function m(C,N,i){for(var j in N){if(typeof C[j]==="undefined"){C[j]=f(N[j],i);}}return C;}
function g(N,i){if(typeof N["default"]!=="object"){N={"default":N,"scopes":{}};}p=p||{};p["default"]=p["default"]||{};p["scopes"]=p["scopes"]||{};m(p["default"],N["default"],i);if(typeof N["scopes"]==="object"){for(var S in N["scopes"]){p["scopes"][S]=p["scopes"][S]||{};m(p["scopes"][S],N["scopes"][S],i);}}}
function h(C){q("link[id^=sap-ui-theme-]").each(function(){C(this.getAttribute("id"));});}
function l(i){var k=document.getElementById(i);if(!k){L.warning("Could not find stylesheet element with ID",i,"sap.ui.core.theming.Parameters");return;}var S=k.href;var x=new U(S).filename("").query("").toString();var y=T.checkStyle(i);if(!y){L.warning("Parameters have been requested but theme is not applied, yet.","sap.ui.core.theming.Parameters");}if(y&&u){var $=q(k);var D=$.css("background-image");var z=/\(["']?data:text\/plain;utf-8,(.*?)['"]?\)$/i.exec(D);if(z&&z.length>=2){var A=z[1];if(A.charAt(0)!=="{"&&A.charAt(A.length-1)!=="}"){try{A=decodeURIComponent(A);}catch(B){L.warning("Could not decode theme parameters URI from "+S);}}try{var C=JSON.parse(A);g(C,x);return;}catch(B){L.warning("Could not parse theme parameters from "+S+". Loading library-parameters.json as fallback solution.");}}}var F=S.replace(/\/(?:css_variables|library)([^\/.]*)\.(?:css|less)($|[?#])/,function(j,G,H){return"/library-parameters.json"+(H?H:"");});if(s===2){L.error("[nosync] Loading library-parameters.json ignored",F,"sap.ui.core.theming.Parameters");return;}else if(s===1){L.error("[nosync] Loading library-parameters.json with sync XHR",F,"sap.ui.core.theming.Parameters");}q.ajax({url:F,dataType:'json',async:false,success:function(G,H,I){if(Array.isArray(G)){for(var j=0;j<G.length;j++){var C=G[j];g(C,x);}}else{g(G,x);}},error:function(j,G,H){L.error("Could not load theme parameters from: "+F,H);}});}
function n(){if(!p){g({},"");t=sap.ui.getCore().getConfiguration().getTheme();h(l);}return p;}
function o(){b.forEach(l);b=[];}
P._addLibraryTheme=function(i){if(p){b.push("sap-ui-theme-"+i);}};
function v(O){var i=n();if(O.scopeName){i=i["scopes"][O.scopeName];}else{i=i["default"];}var j=i[O.parameterName];if(typeof j==="undefined"&&typeof O.parameterName==="string"){var I=O.parameterName.indexOf(":");if(I!==-1){O.parameterName=O.parameterName.substr(I+1);}j=i[O.parameterName];}if(O.loadPendingParameters&&typeof j==="undefined"){o();j=v({parameterName:O.parameterName,scopeName:O.scopeName,loadPendingParameters:false});}return j;}
function w(j,S){for(var i=0;i<S.length;i++){var C=S[i];for(var k=0;k<C.length;k++){var x=C[k];var y=v({parameterName:j,scopeName:x});if(y){return y;}}}return v({parameterName:j});}
P._getScopes=function(A){if(A&&!p){return;}var i=n();var S=Object.keys(i["scopes"]);return S;};
P.getActiveScopesFor=function(i){var S=[];if(i instanceof E){var j=i.getDomRef();o();var k=this._getScopes();if(j){var N=function(x){var y=j.classList;return y&&y.contains(x);};while(j){var F=k.filter(N);if(F.length>0){S.push(F);}j=j.parentNode;}}else{var C=function(x){return typeof i.hasStyleClass==="function"&&i.hasStyleClass(x);};while(i){var F=k.filter(C);if(F.length>0){S.push(F);}i=typeof i.getParent==="function"&&i.getParent();}}}return S;};
P.get=function(N,k){var x;if(!sap.ui.getCore().isInitialized()){L.warning("Called sap.ui.core.theming.Parameters.get() before core has been initialized. "+"This could lead to bad performance and sync XHR as inline parameters might not be available, yet. "+"Consider using the API only when required, e.g. onBeforeRendering.");}if(arguments.length===0){o();var y=n();return Object.assign({},y["default"]);}if(!N){return undefined;}if(k instanceof E){o();var S=this.getActiveScopesFor(k);if(typeof N==="string"){return w(N,S);}else if(Array.isArray(N)){var z={};for(var j=0;j<N.length;j++){var A=N[j];z[A]=w(A,S);}return z;}}else{if(typeof N==="string"){x=v({parameterName:N,loadPendingParameters:true});return x;}else if(Array.isArray(N)){var z={};for(var i=0;i<N.length;i++){var A=N[i];z[A]=P.get(A);}return z;}}};
P._setOrLoadParameters=function(i){p={"default":{},"scopes":{}};t=sap.ui.getCore().getConfiguration().getTheme();h(function(I){var j=I.substr(13);if(i[j]){e(p["default"],i[j]);}else{l(I);}});};
P.reset=function(){var O=arguments[0]===true;if(!O||sap.ui.getCore().getConfiguration().getTheme()!==t){d();}};
P._getThemeImage=function(i,F){i=i||"sapUiGlobalLogo";var j=P.get(i);if(j){var k=r.exec(j);if(k){j=k[1];}else if(j==="''"||j==="none"){j=null;}}if(!!F&&!j){return sap.ui.resource('sap.ui.core','themes/base/img/1x1.gif');}return j;};
return P;},true);
sap.ui.predefine('sap/ui/core/tmpl/DOMAttribute',['sap/ui/core/Element','sap/ui/core/library'],function(E,l){"use strict";
var D=E.extend("sap.ui.core.tmpl.DOMAttribute",{metadata:{library:"sap.ui.core",properties:{name:{type:"string",group:"Data",defaultValue:null},value:{type:"string",group:"Data",defaultValue:null}}}});
D.prototype.setValue=function(v){this.setProperty("value",v,true);var p=this.getParent(),$=p&&p.$();if($&&$.length>0){$.attr(this.getName(),this.getProperty("value"));}return this;};
return D;});
sap.ui.predefine('sap/ui/core/tmpl/DOMElement',['sap/ui/core/Control','sap/ui/core/library','./DOMAttribute',"./DOMElementRenderer","sap/base/Log","sap/ui/thirdparty/jquery"],function(C,l,D,a,L,q){"use strict";
var b=C.extend("sap.ui.core.tmpl.DOMElement",{metadata:{library:"sap.ui.core",properties:{text:{type:"string",group:"Appearance",defaultValue:null},tag:{type:"string",group:"Behavior",defaultValue:'span'}},defaultAggregation:"attributes",aggregations:{attributes:{type:"sap.ui.core.tmpl.DOMAttribute",multiple:true,singularName:"attribute"},elements:{type:"sap.ui.core.tmpl.DOMElement",multiple:true,singularName:"element"}}}});
b.prototype.applySettings=function(s){var m=this.getMetadata(),j=m.getJSONKeys();if(s){if(!s["attributes"]){var A=s["attributes"]=[];q.each(s,function(k,v){if(k!=="id"&&!j[k]&&typeof v==="string"){A.push(new D({name:k,value:v}));delete s[k];}});}else{L.warning("DOMElement#"+this.getId()+": custom attributes in settings will be ignored since attributes are provided!");}}C.prototype.applySettings.apply(this,arguments);};
b.prototype.exit=b.prototype.onBeforeRendering=function(){var t=this.getTag().toLowerCase();if(t==="input"||t==="textarea"||t==="select"){this.$().off("change");}};
b.prototype.onAfterRendering=function(){var t=this.getTag().toLowerCase();if(t==="input"||t==="textarea"||t==="select"){this.$().on("change",q.proxy(this.oninputchange,this));}};
b.prototype.oninputchange=function(e){var t=this.getTag().toLowerCase();if(t==="input"){var v=this.$().val();this.getAttributes().forEach(function(A){if(A.getName().toLowerCase()==="value"){A.setValue(v);}});}else if(t==="textarea"){var T=this.$().val();this.setText(T);}else if(t==="select"){var T="";this.$().find("select option:selected").each(function(){T+=q(this).text()+" ";});this.setText(T);}};
b.prototype.attr=function(k,v){var A=this.getAttributes(),o;A.forEach(function(V){var n=V.getName();if(n.toLowerCase()===k){o=V;return false;}});if(v===undefined){return o&&o.getValue();}else{if(o){if(v===null){this.removeAttribute(o);}else{o.setValue(v);}}else{if(v!==null){this.addAttribute(new D({name:k,value:v}));}}return this;}};
b.prototype.removeAttr=function(k){this.attr(k,null);return this;};
b.prototype.setText=function(t){this.setProperty("text",t,true);var $=this.$();if($.length>0){var T=this.getTag().toLowerCase();if(T==="textarea"){$.val(this.getProperty("text"));}else{$.text(this.getProperty("text"));}}return this;};
return b;});
sap.ui.predefine('sap/ui/core/tmpl/DOMElementRenderer',["sap/base/Log","sap/base/security/encodeXML"],function(L,e){"use strict";var D={apiVersion:2};var r=/^(?:area|base|br|col|embed|hr|img|input|link|meta|param|source|track|wbr)$/i;
D.render=function(R,E){var s=e(E.getTag()),i=r.test(s);if(i){R.voidStart(s,E);}else{R.openStart(s,E);}E.getAttributes().forEach(function(A){var n=A.getName().toLowerCase();if(n==="class"){var c=A.getValue().split(" ");c.forEach(function(C){var C=C.trim();if(C){R.class(C);}});}else if(n==="style"){var S=A.getValue().split(";");S.forEach(function(b){var I=b.indexOf(":");if(I!=-1){var k=b.substring(0,I).trim();var v=b.substring(I+1).trim();R.style(e(k),v);}});}else if(A.getName()){R.attr(e(A.getName()),A.getValue());}else{L.error("Attributes must have a non-empty name");}});if(i){R.voidEnd();}else{R.openEnd();}var a=E.getElements(),h=!!E.getText()||a.length>0;if(h){if(i){L.error("Void element '"+s+"' is rendered with children");}if(E.getText()){R.text(E.getText());}a.forEach(function(I,c){R.renderControl(c);});}if(!i){R.close(s);}};
return D;},true);
sap.ui.predefine('sap/ui/core/tmpl/HandlebarsTemplate',['sap/ui/core/Core','./Template','./TemplateControl','sap/ui/thirdparty/handlebars','sap/ui/base/ManagedObject','sap/base/util/ObjectPath',"sap/base/security/encodeXML","sap/ui/thirdparty/jquery","sap/base/util/isEmptyObject"],function(C,T,a,H,M,O,e,q,b){"use strict";
var c=T.extend("sap.ui.core.tmpl.HandlebarsTemplate",{
metadata:{library:"sap.ui.core"},
constructor:function(i,s){T.apply(this,arguments);}
});
T.registerType("text/x-handlebars-template","sap.ui.core.tmpl.HandlebarsTemplate");
function d(h){for(var k in h){h[k]=h[k].replace("&gt;",">").replace("&lt;","<").replace("&quot;","\"").replace("&amp;","&");}}
function f(p,P){var r=/^((\w+)>)?(.*)/,g=r.exec(p),s=g[2],h=r.exec(P),i=h[2];var g=r.exec(p);if(P&&s==i){return P+g[3];}else{return p;}}
c.RENDER_HELPERS=(function(){var E=H.helpers["each"],w=H.helpers["with"],I=H.helpers["if"],u=H.helpers["unless"],r=sap.ui.getCore().createRenderManager();r.renderControl=function(o){this.writeControlData(o);this.writeClasses(o);this.writeStyles(o);};var h={"each":function(g,o){o=o||g;if(!o.hash.path){return E.apply(this,arguments);}else{d(o.hash);var R=o.data.renderManager,i=o.data.rootControl,p=o.data.path,P=o.data.parentControl,s=f(o.hash.path,p),j=i.bindList(s),k=[],l;if(o.data){l=H.createFrame(o.data);}if(j){for(var K in j){if(l){l.renderManager=R;l.rootControl=i;l.path=s+"/"+K+"/";l.parentControl=P;}k.push(o.fn({},{data:l}));}}if(!P){return new H.SafeString(k.join(""));}}},"with":function(g,o){o=o||g;if(!o.hash.path){return w.apply(this,arguments);}},"if":function(g,o){o=o||g;if(!o.hash.path){return I.apply(this,arguments);}else{d(o.hash);var R=o.data.rootControl,p=o.data.path,P=f(o.hash.path,p);if(P){var v=R.bindProp(P);if(v){return o.fn(this);}else{return o.inverse(this);}}}},"unless":function(g,o){o=o||g;if(!o.hash.path){return u.apply(this,arguments);}else{d(o.hash);var R=o.data.rootControl,p=o.data.path,P=f(o.hash.path,p);if(P){var v=R.bindProp(P);if(!v){return o.fn(this);}else{return o.inverse(this);}}}},"text":function(g,o){o=o||g;d(o.hash);var R=o.data.rootControl,p=o.data.path,P=f(o.hash.path,p);if(P){var v=R.bindProp(P);return v&&new H.SafeString(e(v));}else{throw new Error("The expression \"text\" requires the option \"path\"!");}},"element":function(g,o){o=o||g;d(o.hash);var R=o.data.renderManager,i=o.data.rootControl,j=i.createDOMElement(o.hash,o.data.path),p=o.data.parentElement;if(o.fn){o.fn({},{data:{renderManager:R,rootControl:i,parentElement:j}});}if(p){p.addElement(j);return;}return new H.SafeString(R.getHTML(j));},"control":function(g,o){o=o||g;d(o.hash);var R=o.data.renderManager,j=o.data.control;if(j){return new H.SafeString(R.getHTML(j));}var k=o.data.rootControl,p=o.data.path,P=o.data.children,t=o.hash["sap-ui-type"],m=O.get(t||""),n=m&&m.getMetadata(),D=o.hash["sap-ui-default-aggregation"]||n&&n.getDefaultAggregationName(),v=o.data.view;if(!m){throw new Error("Control of type "+t+" cannot be found.");}var s={};if(o.fn){o.fn({},{data:{rootControl:k,path:p,children:s,defaultAggregation:D,view:v}});}var S=Object.assign({},o.hash),x;for(var K in S){if(K==="sap-ui-class"&&typeof S[K]==="string"){x=S["sap-ui-class"]&&S["sap-ui-class"].split(" ");delete S[K];}else if(s[K]){delete S[K];}}var N=k.createControl(S,o.data.path,!!P,v);if(x&&x.length>0){x.forEach(N.addStyleClass.bind(N));}if(!b(s)){S=o.hash;var A=n.getAllAggregations();for(var y in s){var z=s[y];for(var i=0,l=z.length;i<l;i++){var B=z[i],F=A[y],G=F&&F.multiple;if(typeof S[y]==="string"){var J=M.bindingParser(S[y],v&&v.getController());J.template=B;N.bindAggregation(y,J);}else{if(G){N.addAggregation(y,B);}else{N.setAggregation(y,B);}}}}}if(P){var y=o.hash["sap-ui-aggregation"]||o.data.defaultAggregation;P[y]=P[y]||[];P[y].push(N);return;}return new H.SafeString(R.getHTML(N));},"property":function(g,o){o=o||g;d(o.hash);var R=o.data.rootControl,m=R.getMetadata(),p=o.hash.name,G=m.getProperty(p)._sGetter;return R[G]();},"aggregation":function(g,o){o=o||g;d(o.hash);if(o.data.children){var A=o.hash.name;if(o.fn){var D=Object.assign({},o.data,{defaultAggregation:A});o.fn({},{data:D});}}else{var R=o.data.renderManager,j=o.data.rootControl,m=j.getMetadata(),A=o.hash.name,G=m.getAggregation(A)._sGetter,k=[];var n=j[G]();if(n){for(var i=0,l=n.length;i<l;i++){if(o.fn){k.push(o.fn({},{data:{renderManager:R,rootControl:j,control:n[i]}}));}else{k.push(R.getHTML(n[i]));}}}return new H.SafeString(k.join(""));}},"event":function(g,o){o=o||g;},"controlData":function(g,o){o=o||g;var R=o.data.rootControl;return new H.SafeString(r.getHTML(R));}};return h;}());
c.prototype.createMetadata=function(){var t=this.getContent(),g=this._fnTemplate=this._fnTemplate||H.compile(t);var m={},j=a.getMetadata().getAllSettings(),p=a.getMetadata().getAllPrivateAggregations();var h={"property":function(i,o){o=o||i;d(o.hash);var n=o.hash.name;if(n&&n!=="id"&&!j[n]){m.properties=m.properties||{};m.properties[n]=Object.assign({},{type:"string"},o.hash);}else{throw new Error("The property name \""+n+"\" is reserved.");}},"aggregation":function(i,o){o=o||i;d(o.hash);var n=o.hash.name;if(n&&!j[n]&&!p[n]){o.hash.multiple=o.hash.multiple=="true";m.aggregations=m.aggregations||{};m.aggregations[n]=Object.assign({},o.hash);}else{throw new Error("The aggregation name \""+n+"\" is reserved.");}},"event":function(i,o){o=o||i;},"controlData":function(i,o){o=o||i;m._hasControlData=true;}};["each","if","unless","with"].forEach(function(v){h[v]=function(){};});g({},{helpers:h});return m;};
c.prototype.createRenderer=function(v){var t=this.getContent(),g=this._fnTemplate=this._fnTemplate||H.compile(t);var r=function(h,o){var s=g(o.getContext()||{},{data:{renderManager:h,rootControl:o,view:v},helpers:c.RENDER_HELPERS});h.write(s);};return r;};
return c;});
sap.ui.predefine('sap/ui/core/tmpl/Template',['sap/ui/base/ManagedObject','sap/ui/base/BindingParser','sap/ui/core/Control','sap/ui/core/RenderManager','sap/base/util/ObjectPath','sap/base/Log','sap/base/assert','sap/ui/thirdparty/jquery'],function(M,B,C,R,O,L,a,q){"use strict";
var T=M.extend("sap.ui.core.tmpl.Template",{
constructor:function(i,s){M.apply(this,arguments);},
metadata:{stereotype:"template","abstract":true,library:"sap.ui.core",properties:{"content":{type:"string",group:"Data",defaultValue:null}},publicMethods:["declareControl","createControl","placeAt","createMetadata","createRenderer"]}
});
var t={};
T.prototype.register=function(){var i=this.getId(),o=t[i],m;if(o&&this!==o){m="adding template with duplicate id '"+i+"'";L.error(m);throw new Error("Error: "+m);}t[i]=this;};
T.prototype.deregister=function(){delete t[this.getId()];};
T.byId=function(i){return t[i];};
T.prototype.getInterface=function(){return this;};
T._mSupportedTypes={};
T.registerType=function(s,c){T._mSupportedTypes[s]=c;};
T.unregisterType=function(s){delete T._mSupportedTypes[s];};
T.parsePath=function(p){var m,s=p.indexOf(">");if(s>0){m=p.substr(0,s);p=p.substr(s+1);}return{path:p,model:m};};
T.prototype.init=function(s,S){if(this.getMetadata().getName()==="sap.ui.core.tmpl.Template"){throw new Error("The class 'sap.ui.core.tmpl.Template' is abstract and must not be instantiated!");}if(M.bindingParser===B.complexParser){T.prototype.extractBindingInfo=function(v,i,S){M.bindingParser=B.simpleParser;var r=C.prototype.extractBindingInfo.apply(this,arguments);M.bindingParser=B.complexParser;return r;};}};
T.prototype.declareControl=function(c){a(!!c,"A fully qualified name must be specified!");if(c){var m=this.createMetadata(),r=this.createRenderer(),b=this;var d=sap.ui.requireSync('sap/ui/core/tmpl/TemplateControl');d.extend(c,{metadata:m,init:function(){d.prototype.init.apply(this,arguments);this.setTemplate(b);},renderer:{renderTemplate:r,hasControlData:m._hasControlData}});return O.get(c||"");}};
T.prototype.createControl=function(i,c,v){var b=sap.ui.requireSync('sap/ui/core/tmpl/TemplateControl');var o=new b({id:i,template:this,context:c});o.setTemplateRenderer(this.createRenderer(v));return o;};
T.prototype.placeAt=function(r,c,p,i){if(typeof c==="string"||typeof c==="number"){p=c;c=undefined;}var I;if(!(r instanceof C)&&i){var $=typeof r==="string"?q(document.getElementById(r)):q(r);if($.length>0){I=$.attr("id");r=$.get(0);var s=$.attr("data-context");c=c||s&&JSON.parse(s);R.markInlineTemplate($);}}var o=this.createControl(I,c);o.placeAt(r,p);return o;};
T.prototype.createMetadata=function(){L.error("The function createMetadata is an abstract function which needs to be implemented by subclasses.");};
T.prototype.createRenderer=function(){L.error("The function createRenderer is an abstract function which needs to be implemented by subclasses.");};
sap.ui.template=function(o){var l=function(n){L.warning("The usage of Template Views is deprecated since 1.56. Please make use of the asynchronous create functions of the different view classes, e.g. XMLView.create()","Deprecation",null,function(){return{type:"sap.ui.template",name:n};});};if(!o){var b=[];q.each(T._mSupportedTypes,function(s,j){q("script[type='"+s+"'], [data-type='"+s+"']").each(function(n,E){b.push(sap.ui.template({id:E.id,domref:E,type:s,_class:j}));});});return b;}else{if(typeof o==="string"){return sap.ui.template({id:o});}else if(o&&o.tagName&&o.nodeName&&o.ownerDocument&&o.nodeType===1){return sap.ui.template({id:o.id,domref:o});}o=q.extend({type:T.DEFAULT_TEMPLATE},o);l(o.id);var i,s,c,d,e=false,f=typeof o.src==="string",I=false;if(f){q.ajax({url:o.src,dataType:"text",async:false,success:function(n){i=o.id;s=o.type;c=o.control;d=n;var r=/^<!--\sUI5:Template\stype=([a-z\/\-]*)\s(?:controller=([A-Za-z.]*)\s)?-->/,p=d.match(r);if(p){s=p[1];if(p.length==3){e=p[2];}d=d.substr(p[0].length);}},error:function(){throw new Error("The template could not be loaded from "+o.src+"!");}});}else{var E=o.domref||((o.id?window.document.getElementById(o.id):null)),$=q(E);I=false;i=o.id||E&&E.id;s=$.attr("type")||o.type;c=$.attr("data-control")||o.control;if(i){var g=sap.ui.getCore().getTemplate(i);if(!g instanceof T){throw new Error("Object for id \""+i+"\" is no sap.ui.core.tmpl.Template!");}else{if(g){return g;}}}if($.length===0){throw new Error("DOM element for the Template with the id \""+i+"\" not found!");}d=$.html();var h=E.tagName.toLowerCase();if(h!=="script"){I=$.parents("body").length===1;}}var j=o._class;if(!j){j=T._mSupportedTypes[s];if(!j){throw new Error("The type \""+s+"\" is not supported.");}}var k=sap.ui.requireSync(j.replace(/\./g,"/"));k=k||O.get(j||"");var m=new k({id:i,content:d});if(c){m.declareControl(c);}if(e){m._sControllerName=e;}if(I){m.placeAt(i,o.context,undefined,true);}return m;}};
T.DEFAULT_TEMPLATE="text/x-handlebars-template";T.registerType(T.DEFAULT_TEMPLATE,"sap.ui.core.tmpl.HandlebarsTemplate");return T;});
sap.ui.predefine('sap/ui/core/tmpl/TemplateControl',['sap/ui/core/Control','sap/ui/core/DeclarativeSupport','sap/ui/core/library','sap/ui/core/UIArea','./DOMElement','./Template',"./TemplateControlRenderer","sap/base/strings/capitalize","sap/base/strings/hyphenate","sap/base/Log","sap/ui/thirdparty/jquery"],function(C,D,l,U,a,T,b,c,h,L,q){"use strict";
var d=C.extend("sap.ui.core.tmpl.TemplateControl",{metadata:{library:"sap.ui.core",properties:{context:{type:"object",group:"Data",defaultValue:null}},aggregations:{controls:{type:"sap.ui.core.Control",multiple:true,singularName:"control",visibility:"hidden"}},associations:{template:{type:"sap.ui.core.tmpl.Template",multiple:false}},events:{afterRendering:{},beforeRendering:{}}}});
d.prototype.init=function(){this._aBindingInfos=[];};
d.prototype.isInline=function(){var i=false,p=this.getParent();if(p instanceof U&&q(p.getRootNode()).attr("id")===this.getId()){i=true;}return i;};
d.prototype.placeAt=function(r,p){var i=this.isInline();var $=this.$(),u=this.getUIArea();C.prototype.placeAt.apply(this,arguments);if(i&&$.length===1){$.remove();u.destroyContent();}};
d.prototype.getTemplateRenderer=function(){return this.fnRenderer;};
d.prototype.setTemplateRenderer=function(r){this.fnRenderer=r;return this;};
d.prototype._cleanup=function(){this.destroyAggregation("controls");this._aBindingInfos.forEach(function(B){var o=B.binding;if(o){o.detachChange(B.changeHandler);o.destroy();}});this._aBindingInfos=[];};
d.prototype._compile=function(){var t=sap.ui.getCore().byId(this.getTemplate()),e=t&&t.getDeclarativeSupport();if(e){var f=this;setTimeout(function(){D.compile(f.getDomRef());});}};
d.prototype.exit=function(){this._cleanup();};
d.prototype.onBeforeRendering=function(){this.fireBeforeRendering();this._cleanup();};
d.prototype.onAfterRendering=function(){this.fireAfterRendering();};
d.prototype.clone=function(){var o=C.prototype.clone.apply(this,arguments);o.fnRenderer=this.fnRenderer;return o;};
d.prototype.updateBindings=function(u,m){C.prototype.updateBindings.apply(this,arguments);if(this.getDomRef()){this.invalidate();}};
d.prototype.bind=function(p,t){var P=T.parsePath(p),m=this.getModel(P.model),p=P.path,M=t?"bind"+c(t):"bindProperty",B=m&&m[M](p),o={binding:B,path:P.path,model:P.model};if(B){o.changeHandler=function(){L.debug("TemplateControl#"+this.getId()+": "+t+" binding changed for path \""+p+"\"");this.invalidate();}.bind(this);B.attachChange(o.changeHandler);}this._aBindingInfos.push(o);return B;};
d.prototype.calculatePath=function(p,t){var B=this.getBindingContext(),s=B&&B.getPath();if(p&&s&&!p.startsWith("/")){if(!s.endsWith("/")){s+="/";}p=s+p;}return p;};
d.prototype.bindProp=function(p){var B=this.bind(this.calculatePath(p),"property");return B&&B.getExternalValue();};
d.prototype.bindList=function(p){var B=this.bind(this.calculatePath(p),"list"),m=B&&B.getModel(),p=B&&B.getPath();return B&&m.getProperty(p);};
d.prototype.createDOMElement=function(s,p,e){var E=new a(s);if(p){E.bindObject(p);}if(!e){this.addAggregation("controls",E);}return E;};
d.prototype.createControl=function(s,p,e,v){var H={};q.each(s,function(k,V){H["data-"+h(k)]=V;});var $=q("<div></div>",H);var o=D._createControl($.get(0),v);if(p){o.bindObject(p);}if(!e){this.addAggregation("controls",o);}return o;};
return d;});
sap.ui.predefine('sap/ui/core/tmpl/TemplateControlRenderer',function(){"use strict";var T={apiVersion:1};
T.render=function(r,c){var s=c.isInline()||this.hasControlData;if(!s){r.openStart("div",c).openEnd();}var R=this.renderTemplate||c.getTemplateRenderer();if(R){R.apply(this,arguments);}if(!s){r.close("div");}};
return T;},true);
sap.ui.predefine('sap/ui/core/util/AsyncHintsHelper',[],function(){'use strict';var A={};
A.modifyUrls=function(a,u){function _(o,U){if(U===undefined){delete o.url;}}[a.components,a.libs].forEach(function(i){if(Array.isArray(i)){i.forEach(function(v){if(typeof v!=="object"){return;}if(typeof v.url==="string"){v.url=u(v.url);_(v,v.url);}else if(typeof v.url==="object"&&typeof v.url.url==="string"){v.url.url=u(v.url.url);_(v,v.url.url);}});}});return a;};
return A;});
sap.ui.predefine('sap/ui/core/util/DraftEnabledMockServer',["sap/ui/core/util/MockServer","sap/ui/thirdparty/jquery","sap/base/util/isEmptyObject","jquery.sap.sjax"],function(M,q,a){"use strict";return{_oDraftMetadata:{},_oConstants:{COM_SAP_VOCABULARIES_COMMON_V1_DRAFTROOT:"com.sap.vocabularies.Common.v1.DraftRoot",COM_SAP_VOCABULARIES_COMMON_V1_DRAFTNODE:"com.sap.vocabularies.Common.v1.DraftNode",COM_SAP_VOCABULARIES_COMMON_V1_SEMANTICKEY:"com.sap.vocabularies.Common.v1.SemanticKey",EMPTY_GUID:"00000000-0000-0000-0000-000000000000",SIBLINGENTITY_NAVIGATION:"SiblingEntity",DRAFT_ADMINISTRATIVE_DATA:"DraftAdministrativeData",DRAFT_ADMINISTRATIVE_DATA_UUID:"DraftAdministrativeDataUUID",ACTIVATION_ACTION:"ActivationAction",EDIT_ACTION:"EditAction",VALIDATE_ACTION:"ValidationFunction",PREPARE_ACTION:"PreparationAction"},handleDraft:function(A,m){var n=function(b){var N=b.getParameter("oEntity");N.IsActiveEntity=false;N.HasActiveEntity=false;N.HasDraftEntity=false;};var d=function(b){var x=b.getParameter("oXhr");var c=q.sap.sjax({url:x.url,dataType:"json"}).data.d;for(var i=0;i<this._oDraftMetadata.draftNodes.length;i++){for(var f in this._mEntitySets[this._oDraftMetadata.draftRootName].navprops){if(this._mEntitySets[this._oDraftMetadata.draftRootName].navprops[f].to.entitySet===this._oDraftMetadata.draftNodes[i]){var r=q.sap.sjax({url:c[f].__deferred.uri,dataType:"json"});if(r.data&&r.data.d&&r.data.d.results){var N;for(var j=0;j<r.data.d.results.length;j++){N=r.data.d.results[j];q.sap.sjax({url:N.__metadata.uri,type:"DELETE"});}}}}}};if(A&&A.EntityContainer){var e=A.EntityContainer[Object.keys(A.EntityContainer)[0]];for(var E in e){var o=e[E];if(o[this._oConstants.COM_SAP_VOCABULARIES_COMMON_V1_DRAFTROOT]){this._oDraftMetadata.draftRootName=E;this._oDraftMetadata.annotations=A;this._oDraftMetadata.mockServerRootUri=m.getRootUri();if(o[this._oConstants.COM_SAP_VOCABULARIES_COMMON_V1_DRAFTROOT][this._oConstants.ACTIVATION_ACTION]){this._oDraftMetadata.draftRootActivationName=o[this._oConstants.COM_SAP_VOCABULARIES_COMMON_V1_DRAFTROOT][this._oConstants.ACTIVATION_ACTION].String;}if(this._oDraftMetadata.draftRootActivationName){this._oDraftMetadata.draftRootActivationName=this._oDraftMetadata.draftRootActivationName.substring(this._oDraftMetadata.draftRootActivationName.lastIndexOf("/")+1);}this._oDraftMetadata.draftRootEditName=o[this._oConstants.COM_SAP_VOCABULARIES_COMMON_V1_DRAFTROOT][this._oConstants.EDIT_ACTION];this._oDraftMetadata.draftRootEditName=this._oDraftMetadata.draftRootEditName?this._oDraftMetadata.draftRootEditName.String:undefined;if(this._oDraftMetadata.draftRootEditName){this._oDraftMetadata.draftRootEditName=this._oDraftMetadata.draftRootEditName.substring(this._oDraftMetadata.draftRootEditName.lastIndexOf("/")+1);}this._oDraftMetadata.draftRootValidationName=o[this._oConstants.COM_SAP_VOCABULARIES_COMMON_V1_DRAFTROOT][this._oConstants.VALIDATE_ACTION];this._oDraftMetadata.draftRootValidationName=this._oDraftMetadata.draftRootValidationName?this._oDraftMetadata.draftRootValidationName.String:undefined;if(this._oDraftMetadata.draftRootValidationName){this._oDraftMetadata.draftRootValidationName=this._oDraftMetadata.draftRootValidationName.substring(this._oDraftMetadata.draftRootValidationName.lastIndexOf("/")+1);}this._oDraftMetadata.draftRootPreparationtionName=o[this._oConstants.COM_SAP_VOCABULARIES_COMMON_V1_DRAFTROOT][this._oConstants.PREPARE_ACTION];this._oDraftMetadata.draftRootPreparationtionName=this._oDraftMetadata.draftRootPreparationtionName?this._oDraftMetadata.draftRootPreparationtionName.String:undefined;if(this._oDraftMetadata.draftRootPreparationtionName){this._oDraftMetadata.draftRootPreparationtionName=this._oDraftMetadata.draftRootPreparationtionName.substring(this._oDraftMetadata.draftRootPreparationtionName.lastIndexOf("/")+1);}q.extend(m,this);m.attachAfter(M.HTTPMETHOD.POST,n,this._oDraftMetadata.draftRootName);m.attachBefore(M.HTTPMETHOD.DELETE,d,this._oDraftMetadata.draftRootName);m.attachAfter(M.HTTPMETHOD.GET,this._fnDraftAdministrativeData,this._oDraftMetadata.draftRootName);}}}},_calcSemanticKeys:function(e,E){var s=[];for(var b in this._oDraftMetadata.annotations){if(b.lastIndexOf(E[e].type)>-1){s=this._oDraftMetadata.annotations[b][this._oConstants.COM_SAP_VOCABULARIES_COMMON_V1_SEMANTICKEY]||[];break;}}var S=[];var c;for(var i=0;i<s.length;i++){c=s[i];for(var k in c){S.push(c[k]);}}return S;},_prepareDraftMetadata:function(e){var t=this;this._oDraftMetadata.draftNodes=[];this._oDraftMetadata.draftRootKey=e[this._oDraftMetadata.draftRootName].keys.filter(function(x){return t._calcSemanticKeys(t._oDraftMetadata.draftRootName,e).indexOf(x)<0;})[0];var A=t._oDraftMetadata.annotations;var E=A.EntityContainer[Object.keys(A.EntityContainer)[0]];for(var s in E){var o=E[s];if(o[t._oConstants.COM_SAP_VOCABULARIES_COMMON_V1_DRAFTNODE]){this._oDraftMetadata.draftNodes.push(s);}}for(var j=0;j<this._oDraftMetadata.draftNodes.length;j++){this.attachAfter(M.HTTPMETHOD.GET,this._fnDraftAdministrativeData,this._oDraftMetadata.draftNodes[j]);}},_fnDraftAdministrativeData:function(e){var E={};var d=e.getParameter("oFilteredData");if(!d){E=e.getParameter("oEntry");if(E.IsActiveEntity&&!E.HasDraftEntity){E[this._oConstants.DRAFT_ADMINISTRATIVE_DATA]=null;}}else{if(d.results){d=d.results;}else{if(a(d)){d=null;return;}}for(var i=0;i<d.length;i++){E=d[i];if(E.IsActiveEntity&&!E.HasDraftEntity){E[this._oConstants.DRAFT_ADMINISTRATIVE_DATA]=null;}}}},_handleDraftArtifacts:function(e){var t=this;var m=this._oMockdata;var d=m[this._oDraftMetadata.draftRootName];var g=function(c,C){return c.filter(function(x){return C.indexOf(x)<0;})[0];};if(d.length===100){for(var i=0;i<d.length;i++){var E=d[i];if(i<25){E.IsActiveEntity=true;E.HasActiveEntity=false;E.HasDraftEntity=false;E[this._oDraftMetadata.draftRootKey]=this._oConstants.EMPTY_GUID;if(E[this._oConstants.DRAFT_ADMINISTRATIVE_DATA_UUID]){E[this._oConstants.DRAFT_ADMINISTRATIVE_DATA_UUID]=null;}var D=[];var s=[];for(var j=0;j<this._oDraftMetadata.draftNodes.length;j++){s=this._calcSemanticKeys(this._oDraftMetadata.draftNodes[j],e);D=m[this._oDraftMetadata.draftNodes[j]];var o=e[this._oDraftMetadata.draftRootName];for(var n in o.navprops){var N=o.navprops[n];if(N.to.entitySet===this._oDraftMetadata.draftNodes[j]){var p=N.from.propRef.length;for(var k=0;k<p;k++){D[i][N.to.propRef[k]]=E[N.from.propRef[k]];}}}D[i].IsActiveEntity=true;D[i].HasActiveEntity=false;D[i].HasDraftEntity=false;D[i][this._oDraftMetadata.draftRootKey]=this._oConstants.EMPTY_GUID;if(D[i][this._oConstants.DRAFT_ADMINISTRATIVE_DATA_UUID]){D[i][this._oConstants.DRAFT_ADMINISTRATIVE_DATA_UUID]=null;}var b=g(e[this._oDraftMetadata.draftNodes[j]].keys,s);D[i][b]=this._oConstants.EMPTY_GUID;}}else if(i<50){E.IsActiveEntity=false;E.HasActiveEntity=false;E.HasDraftEntity=false;D=[];s=[];for(var j=0;j<this._oDraftMetadata.draftNodes.length;j++){s=this._calcSemanticKeys(this._oDraftMetadata.draftNodes[j],e);D=m[this._oDraftMetadata.draftNodes[j]];var o=e[this._oDraftMetadata.draftRootName];for(var n in o.navprops){var N=o.navprops[n];if(N.to.entitySet===this._oDraftMetadata.draftNodes[j]){var p=N.from.propRef.length;for(var k=0;k<p;k++){D[i][N.to.propRef[k]]=E[N.from.propRef[k]];}}}D[i].IsActiveEntity=false;D[i].HasActiveEntity=false;D[i].HasDraftEntity=false;b=g(e[this._oDraftMetadata.draftNodes[j]].keys,s);}}else if(i<75){var S=q.extend(true,{},E);E.IsActiveEntity=true;E.HasActiveEntity=false;E.HasDraftEntity=true;E[this._oDraftMetadata.draftRootKey]=this._oConstants.EMPTY_GUID;D=[];s=[];for(var j=0;j<this._oDraftMetadata.draftNodes.length;j++){s=this._calcSemanticKeys(this._oDraftMetadata.draftNodes[j],e);D=m[this._oDraftMetadata.draftNodes[j]];var o=e[this._oDraftMetadata.draftRootName];for(var n in o.navprops){var N=o.navprops[n];if(N.to.entitySet===this._oDraftMetadata.draftNodes[j]){var p=N.from.propRef.length;for(var k=0;k<p;k++){D[i][N.to.propRef[k]]=E[N.from.propRef[k]];}}}D[i].IsActiveEntity=true;D[i].HasActiveEntity=false;D[i].HasDraftEntity=true;b=g(e[this._oDraftMetadata.draftNodes[j]].keys,s);D[i][b]=this._oConstants.EMPTY_GUID;}S.IsActiveEntity=false;S.HasActiveEntity=true;S.HasDraftEntity=false;d[i+25]=S;}}}var r=this._getRootUri();q.each(e,function(c,o){q.each(m[c],function(I,f){f.__metadata=f.__metadata||{};f.__metadata.uri=r+c+"("+t._createKeysString(o,f)+")";f.__metadata.type=o.schema+"."+o.type;q.each(o.navprops,function(K){f[K]={__deferred:{uri:r+c+"("+t._createKeysString(o,f)+")/"+K}};});});});},_activate:function(e){var r;var g=function(c,C){return c.filter(function(x){return C.indexOf(x)<0;})[0];};for(var i=0;i<this._oDraftMetadata.draftNodes.length;i++){for(var n in this._mEntitySets[this._oDraftMetadata.draftRootName].navprops){if(this._mEntitySets[this._oDraftMetadata.draftRootName].navprops[n].to.entitySet===this._oDraftMetadata.draftNodes[i]){r=q.sap.sjax({url:e[n].__deferred.uri,dataType:"json"});if(r.success&&r.data&&r.data.d&&r.data.d.results){var N;for(var j=0;j<r.data.d.results.length;j++){N=r.data.d.results[j];N.IsActiveEntity=true;N.HasActiveEntity=false;N.HasDraftEntity=false;N[this._oDraftMetadata.draftRootKey]=this._oConstants.EMPTY_GUID;var s=this._calcSemanticKeys(this._oDraftMetadata.draftNodes[i],this._mEntitySets);var d=g(this._mEntitySets[this._oDraftMetadata.draftNodes[i]].keys,s);N[d]=this._oConstants.EMPTY_GUID;q.sap.sjax({url:N.__metadata.uri,type:"PATCH",data:JSON.stringify(N)});}}}}}e.IsActiveEntity=true;e.HasActiveEntity=false;e.HasDraftEntity=false;e[this._oDraftMetadata.draftRootKey]=this._oConstants.EMPTY_GUID;q.sap.sjax({url:e.__metadata.uri,type:"PATCH",data:JSON.stringify(e)});return e;},setRequests:function(r){var t=this;r.push({method:"POST",path:new RegExp(t._oDraftMetadata.draftRootActivationName),response:function(x){var R=JSON.parse(x.requestBody);var f=[];for(var p in R){f.push(p+" eq "+R[p]);}var o=q.sap.sjax({url:t._oDraftMetadata.mockServerRootUri+t._oDraftMetadata.draftRootName+"?$filter="+f.join(" and "),dataType:"json"});if(!o.success||!o.data.d.results[0]){x.respond(404);}var e=o.data.d.results[0];if(e.IsActiveEntity){x.respond(400);}if(e.HasActiveEntity){var s=e.SiblingEntity.__deferred.uri;o=q.sap.sjax({url:s,dataType:"json"});if(o.success&&o.data&&o.data.d.__metadata){var S=o.data.d;o=q.sap.sjax({url:S.__metadata.uri,type:"DELETE"});}}e=t._activate(e);x.respondJSON(200,{},JSON.stringify({d:e}));return true;}});if(t._oDraftMetadata.draftRootEditName){r.push({method:"POST",path:new RegExp(t._oDraftMetadata.draftRootEditName+"(\\?(.*))?"),response:function(x,u){var f=[];var R=JSON.parse(x.requestBody);if(R&&!a(R)){for(var p in R){f.push(p+" eq "+R[p]);}}else{var U=decodeURIComponent(u).replace("?","&").split("&");for(var b in U){var P=U[b];var c=new RegExp("(.*)=(.*)");var d;if(P){d=c.exec(P);f.push(d[1]+" eq "+d[2]);}}}var o=q.sap.sjax({url:t._oDraftMetadata.mockServerRootUri+t._oDraftMetadata.draftRootName+"?$filter="+f.join(" and "),dataType:"json"});if(!o.success||!o.data.d.results[0]){x.respond(404);}var e=o.data.d.results[0];if(!e.IsActiveEntity||e.HasDraftEntity){x.respond(400);}var D=q.extend(true,{},e);D.IsActiveEntity=false;D.HasActiveEntity=true;D.HasDraftEntity=false;D[t._oDraftMetadata.draftRootKey]=t._generatePropertyValue(t._oDraftMetadata.draftRootKey,"Guid");var s=t._getRootUri();var E=t._mEntitySets[t._oDraftMetadata.draftRootName];D.__metadata=D.__metadata||{};D.__metadata.uri=s+t._oDraftMetadata.draftRootName+"("+t._createKeysString(E,D)+")";D.__metadata.type=E.schema+"."+E.type;q.each(E.navprops,function(k){D[k]={__deferred:{uri:s+t._oDraftMetadata.draftRootName+"("+t._createKeysString(E,D)+")/"+k}};});t._oMockdata[t._oDraftMetadata.draftRootName].push(D);o=q.sap.sjax({url:e.__metadata.uri,type:"PATCH",data:JSON.stringify({HasDraftEntity:true})});x.respondJSON(200,{},JSON.stringify({d:D}));return true;}});}if(t._oDraftMetadata.draftRootValidationName){r.push({method:"GET",path:new RegExp(t._oDraftMetadata.draftRootValidationName+"(\\?(.*))?"),response:function(x,u){var v=t._oDraftMetadata.draftRootValidationName;t.fireEvent(M.HTTPMETHOD.GET+v+":before",{oXhr:x,sUrlParams:u});t.fireEvent(M.HTTPMETHOD.GET+":before",{oXhr:x,sUrlParams:u});var R={d:{}};R.d[v]={"__metadata":{"type":"ValidationResult"},"IsValid":true};t.fireEvent(M.HTTPMETHOD.GET+v+":after",{oXhr:x,oResult:R});t.fireEvent(M.HTTPMETHOD.GET+":after",{oXhr:x,oResult:R});x.respondJSON(200,{},JSON.stringify(R));return true;}});}if(t._oDraftMetadata.draftRootPreparationtionName){r.push({method:"POST",path:new RegExp(t._oDraftMetadata.draftRootPreparationtionName),response:function(x){t.fireEvent(M.HTTPMETHOD.POST+t._oDraftMetadata.draftRootPreparationtionName+":before",{oXhr:x});t.fireEvent(M.HTTPMETHOD.POST+":before",{oXhr:x});var R=JSON.parse(x.requestBody);var f=[];for(var p in R){f.push(p+" eq "+R[p]);}var o=q.sap.sjax({url:t._oDraftMetadata.mockServerRootUri+t._oDraftMetadata.draftRootName+"?$filter="+f.join(" and "),dataType:"json"});if(!o.success||!o.data.d.results[0]){x.respond(404);}var e=o.data.d.results[0];t.fireEvent(M.HTTPMETHOD.POST+t._oDraftMetadata.draftRootPreparationtionName+":after",{oXhr:x,oEntry:e});t.fireEvent(M.HTTPMETHOD.POST+":after",{oXhr:x,oEntry:e});x.respondJSON(200,{},JSON.stringify({d:e}));return true;}});}M.prototype.setRequests.apply(this,[r]);},_generateMockdata:function(e,b){M.prototype._generateMockdata.apply(this,[e,b]);this._handleDraftArtifacts(e);},_loadMockdata:function(e,b){M.prototype._loadMockdata.apply(this,[e,b]);this._handleDraftArtifacts(e);},_resolveNavigation:function(e,f,n,E){var b=M.prototype._resolveNavigation.apply(this,[e,f,n,E]);if(n===this._oConstants.SIBLINGENTITY_NAVIGATION){if(E&&E.IsActiveEntity){b.splice(0,1);}else{b.length>1?b.splice(1,1):b.splice(0,1);}}else if(n===this._oConstants.DRAFT_ADMINISTRATIVE_DATA){if(E){if(E.IsActiveEntity&&!E.HasDraftEntity){b[0]=null;}}else{b[0]=null;}}return b;},_findEntitySets:function(m){var e=M.prototype._findEntitySets.apply(this,[m]);this._prepareDraftMetadata(e);return e;},getEntitySetData:function(e){var E=M.prototype.getEntitySetData.apply(this,[e]);var g=function(){return E;};if(e===this._oDraftMetadata.draftRootName){this._fnDraftAdministrativeData({getParameter:g});return E;}for(var j=0;j<this._oDraftMetadata.draftNodes.length;j++){if(e===this._oDraftMetadata.draftNodes[j]){this._fnDraftAdministrativeData({getParameter:g});return E;}}return E;}};},true);
sap.ui.predefine('sap/ui/core/util/Export',['sap/ui/core/Control','./ExportColumn','./ExportRow','./ExportType','./File',"sap/base/Log"],function(C,E,a,b,F,L){'use strict';
function w(f,o){if(f){return function(){return f.apply(o,arguments);};}else{return f;}}
function p(m){L.warning("Usage of deprecated jQuery Promise method: '"+m+"'. "+"Please use the standard Promise methods 'then' / 'catch' instead!","","sap.ui.core.util.Export");}
function c(P,o){var O=new Promise(P);o=o||O;var r=false,R=false;O.then(function(v){r=true;return v;},function(e){R=true;throw e;});var m={then:O.then,"catch":O["catch"]};function f(e){e.then=function(s,g){var A=[w(s,o),w(g,o)];return f(m.then.apply(e,A),o);};e["catch"]=function(g){var A=[w(g,o)];return f(m["catch"].apply(e,A),o);};[{jq:"done",es6:"then"},{jq:"fail",es6:"catch"},{jq:"always",es6:"then"}].forEach(function(g){e[g.jq]=function(){p(g.jq);var h=null;Array.prototype.concat.apply([],arguments).forEach(function(i){var W=w(i,o);var j=function(v){W.apply(this,arguments);return v;};var A=[j];if(g.jq==="always"){A.push(j);}if(!h){h=m[g.es6].apply(e,A);}else{h=h[g.es6].apply(h,A);}});return f(h,o);};});e.pipe=function(D,g){p("pipe");return e.then(D,g);};e.state=function(){p("state");if(r){return"resolved";}else if(R){return"rejected";}else{return"pending";}};return e;}return f(O);}
var d=C.extend('sap.ui.core.util.Export',{
metadata:{publicMethods:["generate","saveFile"],library:"sap.ui.core",aggregations:{exportType:{type:'sap.ui.core.util.ExportType',multiple:false},columns:{type:'sap.ui.core.util.ExportColumn',multiple:true,bindable:'bindable'},rows:{type:'sap.ui.core.util.ExportRow',multiple:true,bindable:'bindable'},_template:{type:'sap.ui.core.util.ExportRow',multiple:false,visibility:'hidden'}}},
renderer:null
});
d.getMetadata().getAggregation("rows")._doesNotRequireFactory=true;
d.prototype.init=function(){this._oPromise=null;this._fnResolvePromise=null;this._oRowBindingArgs=null;};
d.prototype.exit=function(){delete this._oPromise;delete this._fnResolvePromise;delete this._oRowBindingArgs;};
d.prototype._createRowTemplate=function(){var t=new a(this.getId()+"-row"),e=this.getColumns();for(var i=0,l=e.length;i<l;i++){var o=e[i].getTemplate();if(o){t.addCell(o.clone("col"+i));}}return t;};
d.prototype.bindAggregation=function(n,B){if(n==='rows'){this._oRowBindingArgs=arguments;return this;}return C.prototype.bindAggregation.apply(this,arguments);};
d.prototype.updateRows=function(r){if(r==='change'&&this._fnResolvePromise){var s=this.getExportType()._generate(this);this.destroyAggregation('_template');this.unbindAggregation('rows');this._fnResolvePromise(s);this._oPromise=null;this._fnResolvePromise=null;}};
d.prototype.generate=function(){var t=this;if(!this._oPromise){this._oPromise=c(function(r,e){t._fnResolvePromise=r;if(!t.hasModel()){e("Generate is not possible beause no model was set.");}else{var T=t._createRowTemplate();t.setAggregation('_template',T,true);C.prototype.bindAggregation.apply(t,t._oRowBindingArgs);if(t.getBinding("rows")){t.getBinding("rows").getContexts(0,t.getBinding("rows").getLength());}}},this);}return this._oPromise;};
d.prototype.saveFile=function(f){return this.generate().then(function(s){var e=this.getExportType();F.save(s,f||"data",e.getFileExtension(),e.getMimeType(),e.getCharset(),e.getByteOrderMark());});};
return d;});
sap.ui.predefine('sap/ui/core/util/ExportCell',['sap/ui/core/Element'],function(E){'use strict';
var a=E.extend('sap.ui.core.util.ExportCell',{metadata:{library:"sap.ui.core",properties:{content:'string'}}});
return a;});
sap.ui.predefine('sap/ui/core/util/ExportColumn',['sap/ui/base/ManagedObject','./ExportCell'],function(M,E){'use strict';
var a=M.extend("sap.ui.core.util.ExportColumn",{metadata:{library:"sap.ui.core",properties:{name:"string"},aggregations:{template:{type:"sap.ui.core.util.ExportCell",multiple:false}}}});
return a;});
sap.ui.predefine('sap/ui/core/util/ExportRow',['sap/ui/base/ManagedObject','./ExportCell'],function(M,E){'use strict';
var a=M.extend("sap.ui.core.util.ExportRow",{metadata:{library:"sap.ui.core",aggregations:{cells:{type:"sap.ui.core.util.ExportCell",multiple:true}}}});
return a;});
sap.ui.predefine('sap/ui/core/util/ExportType',['sap/ui/base/ManagedObject'],function(M){'use strict';
var E=M.extend('sap.ui.core.util.ExportType',{metadata:{library:"sap.ui.core",properties:{fileExtension:'string',mimeType:'string',charset:'string',byteOrderMark:{type:'boolean',defaultValue:undefined}}}});
E.prototype.init=function(){this._oExport=null;};
E.prototype._generate=function(e){this._oExport=e;var c=this.generate();this._oExport=null;return c;};
E.prototype.generate=function(){return'';};
E.prototype.getColumnCount=function(){if(this._oExport){return this._oExport.getColumns().length;}return 0;};
E.prototype.getRowCount=function(){if(this._oExport&&this._oExport.getBinding("rows")){return this._oExport.getBinding("rows").getLength();}return 0;};
E.prototype.columnGenerator=function(){var i=0,c=this._oExport.getColumns(),C=c.length;return{next:function(){if(i<C){var I=i;i++;return{value:{index:I,name:c[I].getName()},done:false};}else{return{value:undefined,done:true};}}};};
E.prototype.cellGenerator=function(){var i=0,r=this._oExport.getAggregation('_template'),c=r.getCells(),C=c.length;return{next:function(){if(i<C){var I=i;i++;var m={};c[I].getCustomData().forEach(function(o){m[o.getKey()]=o.getValue();});return{value:{index:I,content:c[I].getContent(),customData:m},done:false};}else{return{value:undefined,done:true};}}};};
E.prototype.rowGenerator=function(){var t=this,i=0,e=this._oExport,b=e.getBinding("rows"),B=e.getBindingInfo("rows"),c=b.getContexts(0,b.getLength()),C=c.length,r=e.getAggregation('_template');return{next:function(){if(i<C){var I=i;i++;r.setBindingContext(c[I],B.model);return{value:{index:I,cells:t.cellGenerator()},done:false};}else{return{value:undefined,done:true};}}};};
return E;});
sap.ui.predefine('sap/ui/core/util/ExportTypeCSV',['./ExportType'],function(E){'use strict';var r=/[\r\n"\t;,]/;var a=/^[=\+\-@](?![\d.,]+(?:e[\+-]?\d+)?$)/i;
var C=E.extend('sap.ui.core.util.ExportTypeCSV',{metadata:{library:"sap.ui.core",properties:{separatorChar:{type:'string',defaultValue:','}}}});
C.MAX_CELL_LENGTH=32760;
C.prototype.setSeparatorChar=function(s){var s=this.validateProperty('separatorChar',s);if(s.length>1){throw new Error("Value of property \"separatorChar\" needs to be exactly one character or empty. "+"\""+s+"\" is "+s.length+" characters long.");}return this.setProperty('separatorChar',s);};
C.prototype.init=function(){this.setProperty('fileExtension','csv',true);this.setProperty('mimeType','text/csv',true);this.setProperty('charset','utf-8',true);};
C.prototype.escapeContent=function(v){if(!v){return v;}if(v.length>C.MAX_CELL_LENGTH){v=v.slice(0,C.MAX_CELL_LENGTH);}if(a.test(v)){v="'"+v;}var c=v.indexOf(this.getSeparatorChar())>-1;if(c||r.test(v)){v=v.replace(/"/g,'""');v='"'+v+'"';}return v;};
C.prototype.generate=function(){var b=[];this.generateColumns(b);this.generateRows(b);return b.join('\r\n');};
C.prototype.generateColumns=function(b){var c=[],o=this.columnGenerator(),d;while(!(d=o.next()).done){c.push(this.escapeContent(d.value.name));}b.push(c.join(this.getSeparatorChar()));};
C.prototype.generateRows=function(b){var R=this.rowGenerator(),o;while(!(o=R.next()).done){var c=[];var d=o.value.cells,e;while(!(e=d.next()).done){c.push(this.escapeContent(e.value.content));}b.push(c.join(this.getSeparatorChar()));}};
return C;});
sap.ui.predefine('sap/ui/core/util/File',["sap/ui/thirdparty/jquery"],function(q){'use strict';var F={save:function(d,f,s,m,c,b){var a=f+'.'+s;if(typeof b==='undefined'&&c==='utf-8'&&s==='csv'){b=true;}if(b===true&&c==='utf-8'){d='\ufeff'+d;}if(window.Blob){var t='data:'+m;if(c){t+=';charset='+c;}var B=new window.Blob([d],{type:t});if(window.navigator.msSaveOrOpenBlob){window.navigator.msSaveOrOpenBlob(B,a);}else{var u=window.URL||window.webkitURL;var e=u.createObjectURL(B);var l=window.document.createElement('a');if('download'in l){var $=q(document.body);var g=q(l).attr({download:a,href:e,style:'display:none'});$.append(g);g.get(0).click();g.remove();}else{d=encodeURI(d);var w=window.open(t+","+d);if(!w){throw new Error("Could not download the file, please deactivate your pop-up blocker.");}}}}}};return F;},true);
sap.ui.predefine('sap/ui/core/util/LibraryInfo',['sap/ui/base/Object',"sap/base/Log","sap/base/util/Version","sap/ui/thirdparty/jquery"],function(B,L,V,q){"use strict";
var a=B.extend("sap.ui.core.util.LibraryInfo",{
constructor:function(){B.apply(this);this._oLibInfos={};},
destroy:function(){B.prototype.destroy.apply(this,arguments);this._oLibInfos={};},
getInterface:function(){return this;}
});
a.prototype._loadLibraryMetadata=function(l,c){l=l.replace(/\//g,".");if(this._oLibInfos[l]){setTimeout(c.bind(window,this._oLibInfos[l]),0);return;}var t=this,u,s,p=/themelib_(.*)/i.exec(l);if(!p){s=".library";u=sap.ui.require.toUrl(l.replace(/\./g,"/"))+"/";}else{s=".theme";u=sap.ui.require.toUrl("sap/ui/core/themes/"+p[1]+"/");}q.ajax({url:u+s,dataType:"xml",error:function(x,b,e){L.error("failed to load library details from '"+u+s+": "+b+", "+e);t._oLibInfos[l]={name:l,data:null,url:u};c(t._oLibInfos[l]);},success:function(d,S,x){t._oLibInfos[l]={name:l,data:d,url:u};c(t._oLibInfos[l]);}});};
a.prototype._getLibraryInfo=function(l,c){this._loadLibraryMetadata(l,function(d){var r={libs:[],library:d.name,libraryUrl:d.url};if(d.data){var $=q(d.data);r.vendor=$.find("vendor").text();r.copyright=$.find("copyright").text();r.version=$.find("version").text();r.documentation=$.find("documentation").text();r.releasenotes=$.find("releasenotes").attr("url");r.componentInfo=a.prototype._getLibraryComponentInfo($);}c(r);});};
a.prototype._getThirdPartyInfo=function(l,c){this._loadLibraryMetadata(l,function(d){var r={libs:[],library:d.name,libraryUrl:d.url};if(d.data){var $=q(d.data).find("appData").find("thirdparty").children();$.each(function(i,o){if(o.nodeName==="lib"){var b=q(o);var e=b.children("license");r.libs.push({displayName:b.attr("displayName"),homepage:b.attr("homepage"),license:{url:e.attr("url"),type:e.attr("type"),file:d.url+e.attr("file")}});}});}c(r);});};
a.prototype._getDocuIndex=function(l,c){this._loadLibraryMetadata(l,function(d){var b=d.name,f=d.url,r={"docu":{},library:b,libraryUrl:f};if(!d.data){c(r);return;}var D=q(d.data).find("appData").find("documentation");var u=D.attr("indexUrl");if(!u){c(r);return;}if(D.attr("resolve")=="lib"){u=d.url+u;}q.ajax({url:u,dataType:"json",error:function(x,s,e){L.error("failed to load library docu from '"+u+"': "+s+", "+e);c(r);},success:function(d,s,x){d.library=b;d.libraryUrl=f;c(d);}});});};
a.prototype._getReleaseNotes=function(l,v,c){this._loadLibraryMetadata(l,function(d){if(!d.data){c({});return;}var i=(v.split(".").length===3)&&!(/-SNAPSHOT/.test(v));var o=V(v);var m=o.getMajor();var M=o.getMinor();var p=o.getPatch();var D=q(d.data).find("appData").find("releasenotes");var u=D.attr("url");if(!u){L.warning("failed to load release notes for library "+l);c({});return;}if(o.getSuffix()==="-SNAPSHOT"){if(M%2!=0){M=(M+1);p=0;}v=m+"."+M+"."+p;}var b=window.location.href,r=/\/\d.\d{1,2}.\d{1,2}\//;if(D.attr("resolve")=="lib"){if(r.test(b)||i===false){u=d.url+u;}else{u="{major}.{minor}.{patch}/"+d.url+u;}}u=u.replace(/\{major\}/g,m);u=u.replace(/\{minor\}/g,M);u=u.replace(/\{patch\}/g,p);q.ajax({url:u,dataType:"json",error:function(x,s,e){if(s==="parsererror"){L.error("failed to parse release notes for library '"+l+", "+e);}else{L.warning("failed to load release notes for library '"+l+", "+e);}c({});},success:function(d,s,x){c(d,v);}});});};
a.prototype._getLibraryComponentInfo=function(d){var A={};var c=[];var D="";d.find("ownership > component").each(function(b,C){if(C.childElementCount===0){D=C.textContent;}else{var v=C.getElementsByTagName("name");if(v&&v.length>0){v=v[0].textContent;var e=C.getElementsByTagName("module");if(v&&e&&e.length>0){var m=[];for(var i=0;i<e.length;i++){var M=e[i].textContent.replace(/\//g,".");if(M){m.push(M);}}if(m.length>0){c.push({"component":v,"modules":m});}}}}});A["defaultComponent"]=D;if(c&&c.length>0){A["specialCases"]=c;}return A;};
a.prototype._getActualComponent=function(c,m){function b(m,p){m=m.toLowerCase();p=p.toLowerCase();return(m===p||p.match(/\*$/)&&m.indexOf(p.slice(0,-1))===0||p.match(/\.\*$/)&&m===p.slice(0,-2));}if(m){for(var k in c){if(!c[k]){L.error("No library information deployed for "+k);continue;}var C;if(m.indexOf(k)===0){C=c[k].defaultComponent;}var s=c[k].specialCases;if(s){for(var i=0;i<s.length;i++){var S=s[i].modules;for(var j=0;j<S.length;j++){if(b(m,S[j])){C=s[i].component;}}}}if(C){return C;}}}};
a.prototype._getDefaultComponent=function(l){return l&&l.componentInfo&&l.componentInfo.defaultComponent;};
return a;});
sap.ui.predefine('sap/ui/core/util/MockServer',['jquery.sap.global','sap/ui/Device','sap/ui/base/ManagedObject','sap/ui/thirdparty/sinon','sap/base/Log','sap/base/util/isEmptyObject','jquery.sap.sjax'],function(q,D,M,d,L,f){"use strict";if(D.browser.msie){if(window.sinon.log){sap.ui.requireSync("sap/ui/thirdparty/sinon-ie");}if(!window.FormData){window.FormData=function(){};}}
var g=M.extend("sap.ui.core.util.MockServer",{
constructor:function(i,s,S){M.apply(this,arguments);g._aServers.push(this);},
metadata:{library:"sap.ui.core",properties:{rootUri:"string",recordRequests:{type:"boolean",defaultValue:true},requests:{type:"object[]",defaultValue:[]}}},
_oServer:null,
_aFilter:null,
_oMockdata:null,
_oMetadata:null,
_sMetadataUrl:null,
_sMockdataBaseUrl:null,
_mEntitySets:null,
_oErrorMessages:{INVALID_SYSTEM_QUERY_OPTION_VALUE:"Invalid system query options value",IS_NOT_A_VALID_SYSTEM_QUERY_OPTION:"## is not a valid system query option",URI_VIOLATING_CONSTRUCTION_RULES:"The URI is violating the construction rules defined in the Data Services specification",UNSUPPORTED_FORMAT_VALUE:"Unsupported format value. Only json format is supported",MALFORMED_SYNTAX:"The Data Services Request could not be understood due to malformed syntax",RESOURCE_NOT_FOUND:"Resource not found",INVALID_SORTORDER_DETECTED:"Invalid sortorder ## detected",PROPERTY_NOT_FOUND:"Property ## not found",INVALID_FILTER_QUERY_STATEMENT:"Invalid filter query statement",INVALID_FILTER_OPERATOR:"Invalid $filter operator ##",RESOURCE_NOT_FOUND_FOR_SEGMENT:"Resource not found for the segment ##",MALFORMED_URI_LITERAL_SYNTAX_IN_KEY:"Malformed URI literal syntax in key ##",INVALID_KEY_NAME:"Invalid key name in key predicate. Expected name is ##",INVALID_KEY_PREDICATE_QUANTITY:"Invalid key predicate. The quantity of provided keys does not match the expected value",INVALID_KEY_TYPE:"Invalid key predicate. The key literal for key property ## does not match its type."},
_oRandomSeed:{}
});
g.prototype._getPseudoRandomNumber=function(t){if(!this._oRandomSeed){this._oRandomSeed={};}if(!this._oRandomSeed.hasOwnProperty(t)){this._oRandomSeed[t]=0;}this._oRandomSeed[t]=(this._oRandomSeed[t]+11)*25214903917%281474976710655;return this._oRandomSeed[t]/281474976710655;};
g.prototype._resetPseudoRandomNumberGenerator=function(){this._oRandomSeed={};};
g.prototype.start=function(){this._oServer=g._getInstance();this._aFilters=[];var r=this.getRequests();var t=this;r.forEach(function(R){var a;if(t.getRecordRequests()===false&&R.response){a=function(){R.response.apply(this,arguments);t._oServer.requests=[];};}else{a=R.response;}t._addRequestHandler(R.method,R.path,a);});};
g.prototype.stop=function(){if(this.isStarted()){this._removeAllRequestHandlers();this._removeAllFilters();this._oServer=null;}};
g.prototype.attachBefore=function(H,c,e){e=e?e:"";this.attachEvent(H+e+":before",c);};
g.prototype.attachAfter=function(H,c,e){e=e?e:"";this.attachEvent(H+e+":after",c);};
g.prototype.detachBefore=function(H,c,e){e=e?e:"";this.detachEvent(H+e+":before",c);};
g.prototype.detachAfter=function(H,c,e){e=e?e:"";this.detachEvent(H+e+":after",c);};
g.prototype.isStarted=function(){return!!this._oServer;};
g.prototype.getEntitySetData=function(e){var t=this;var c;if(this._oMockdata&&this._oMockdata.hasOwnProperty(e)){c=q.extend(true,[],t._oMockdata[e]);}else{L.error("Unrecognized EntitySet name: "+e);}return c;};
g.prototype.setEntitySetData=function(e,a){if(this._oMockdata&&this._oMockdata.hasOwnProperty(e)){this._oMockdata[e]=a;}else{L.error("Unrecognized EntitySet name: "+e);}};
g.prototype._applyQueryOnCollection=function(F,Q,e,u){var a=Q.split('=');var o=a[1];if(o===""){return;}if(o.lastIndexOf(',')===o.length-1){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.URI_VIOLATING_CONSTRUCTION_RULES);}switch(a[0]){case"$top":if(!(new RegExp(/^\d+$/).test(o))){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.INVALID_SYSTEM_QUERY_OPTION_VALUE);}F.results=F.results.slice(0,o);break;case"$skip":if(!(new RegExp(/^\d+$/).test(o))){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.INVALID_SYSTEM_QUERY_OPTION_VALUE);}F.results=F.results.slice(o,F.results.length);break;case"$orderby":F.results=this._getOdataQueryOrderby(F.results,o,e);break;case"$filter":F.results=this._recursiveOdataQueryFilter(F.results,o);break;case"search-focus":break;case"search":var s="";for(var i=0;i<u.length;i++){if(u[i].indexOf("search-focus")!=-1){s=u[i].split('=')[1];break;}}F.results=this._recursiveOdataQuerySearch(F.results,o,s,e);break;case"$select":F.results=this._getOdataQuerySelect(F.results,o,e);break;case"$inlinecount":var c=this._getOdataInlineCount(F.results,o);if(c){F.__count=c;}break;case"$expand":F.results=this._getOdataQueryExpand(F.results,o,e);break;case"$format":F.results=this._getOdataQueryFormat(F.results,o);break;default:this._logAndThrowMockServerCustomError(400,this._oErrorMessages.IS_NOT_A_VALID_SYSTEM_QUERY_OPTION,a[0]);}};
g.prototype._applyQueryOnEntry=function(e,Q,E){var a=Q.split('=');var o=a[1];if(o===""){return;}if(o.lastIndexOf(',')===o.length-1){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.URI_VIOLATING_CONSTRUCTION_RULES);}switch(a[0]){case"$filter":return this._recursiveOdataQueryFilter([e],o)[0];case"$select":return this._getOdataQuerySelect([e],o,E)[0];case"$expand":return this._getOdataQueryExpand([e],o,E)[0];case"$format":return this._getOdataQueryFormat([e],o);default:this._logAndThrowMockServerCustomError(400,this._oErrorMessages.IS_NOT_A_VALID_SYSTEM_QUERY_OPTION,a[0]);}};
g.prototype._getOdataQueryOrderby=function(c,o,e){var p=o.split(',');var t=this;q.each(p,function(i,P){p[i]=t._trim(P);});var C=function m(a,b){for(var i=0;i<p.length;i++){var s=p[i].split(' ');var S=1;if(s.length>1){switch(s[1]){case'asc':S=1;break;case'desc':S=-1;break;default:t._logAndThrowMockServerCustomError(400,t._oErrorMessages.INVALID_SORTORDER_DETECTED,s[1]);}}var P,j;var k=s[0].indexOf("/");if(k!==-1){P=s[0].substring(k+1);j=s[0].substring(0,k);if(!a[j].hasOwnProperty(P)){var E=false;var T=[];if(j){var l=t._mEntitySets[e].navprops[j].to.entitySet;T=t._mEntityTypes[t._mEntitySets[l].type].properties;for(var i=0;i<T.length;i++){if(T[i].name===P){E=true;break;}}}if(!E){t._logAndThrowMockServerCustomError(400,t._oErrorMessages.PROPERTY_NOT_FOUND,P);}}if(a[j][P]<b[j][P]){return-1*S;}if(a[j][P]>b[j][P]){return 1*S;}}else{P=s[0];if(!a.hasOwnProperty(P)){t._logAndThrowMockServerCustomError(400,t._oErrorMessages.PROPERTY_NOT_FOUND,P);}if(a[P]<b[P]){return-1*S;}if(a[P]>b[P]){return 1*S;}}}return 0;};return c.sort(C);};
g.prototype._arrayUnique=function(b){var a=b.concat();for(var i=0;i<a.length;++i){for(var j=i+1;j<a.length;++j){if(a[i]===a[j]){a.splice(j--,1);}}}return a;};
g.prototype._getBracketIndices=function(s){var S=[];var r=false;var i,e=0;for(var c=0;c<s.length;c++){if(s[c]==='('){if(/[substringof|endswith|startswith]$/.test(s.substring(0,c))){r=true;}else{S.push(s[c]);if(i===undefined){i=c;}}}else if(s[c]===')'){if(!r){S.pop();e=c;if(S.length===0){return{start:i,end:e};}}else{r=false;}}}return{start:i,end:e};};
g.prototype._recursiveOdataQueryFilter=function(a,o){var I=this._getBracketIndices(o);if(I.start===0&&I.end===o.length-1){o=this._trim(o.substring(I.start+1,I.end));return this._recursiveOdataQueryFilter(a,o);}var r=/([^substringof|endswith|startswith]|^)\((.*)\)/,s,p;var O;if(r.test(o)){var b=o.substring(I.start,I.end+1);var c=new RegExp("(.*) +(or|and) +("+this._trim(this._escapeStringForRegExp(b))+".*)");if(I.start===0){c=new RegExp("("+this._trim(this._escapeStringForRegExp(b))+") +(or|and) +(.*)");}var e=c.exec(o);if(e===null){return this._getOdataQueryFilter(a,this._trim(o));}var E=e[1];O=e[2];var j=e[3];var S=this._recursiveOdataQueryFilter(a,E);if(O==="or"){s=this._recursiveOdataQueryFilter(a,j);return this._arrayUnique(S.concat(s));}if(O==="and"){return this._recursiveOdataQueryFilter(S,j);}}else{p=o.split(/ +and | or +/);if(p.length===1){if(o.match(/ +and | or +/)){throw new Error("400");}return this._getOdataQueryFilter(a,this._trim(o));}var R=this._recursiveOdataQueryFilter(a,p[0]);var k;for(var i=1;i<p.length;i++){k=new RegExp(this._trim(this._escapeStringForRegExp(p[i-1]))+" +(and|or) +"+this._trim(this._escapeStringForRegExp(p[i])));O=k.exec(o)[1];if(O==="or"){s=this._recursiveOdataQueryFilter(a,p[i]);R=this._arrayUnique(R.concat(s));}if(O==="and"){R=this._recursiveOdataQueryFilter(R,p[i]);}}return R;}};
g.prototype._getOdataQueryFilter=function(a,o){if(a.length===0){return a;}var r=new RegExp("(.*) (eq|ne|gt|lt|le|ge) (.*)");var b=new RegExp("(endswith|startswith|substringof)\\((.*)");var O=null;var c=r.exec(o);if(c){O=c[2];}else{c=b.exec(o);if(c){O=c[1];}else{this._logAndThrowMockServerCustomError(400,this._oErrorMessages.INVALID_FILTER_QUERY_STATEMENT);}}var t=this;var G=function(v,V,p,s){var c,e,P;if(!v){c=r.exec(o);e=t._trim(c[V+1]);P=t._trim(c[p+1]);}else{var i=new RegExp("(substringof|startswith|endswith)\\(([^\\)]*),(.*)\\)");c=i.exec(o);e=t._trim(c[V+2]);P=t._trim(c[p+2]);}if(/^\(.+\)$/.test(e)){e=e.replace(/^\(|\)$/g,"");}var T=e[e.length-1];if(T==="M"||T==="m"||T==="L"||T==="f"){e=e.substring(0,e.length-1);}if(e.indexOf("datetime")===0){e=t._getJsonDate(e);}else if(e.indexOf("guid")===0){e=e.substring(5,e.length-1);}else if(e==="true"){e=true;}else if(e==="false"){e=false;}else if(t._isValidNumber(e)){e=parseFloat(e);}else if((e.charAt(0)==="'")&&(e.charAt(e.length-1)==="'")){e=e.substr(1,e.length-2);}var C=P.indexOf("/");if(C!==-1){var j=P.substring(C+1);var k=P.substring(0,C);if(a[0][k]){if(!a[0][k].hasOwnProperty(j)){var E=t._oErrorMessages.PROPERTY_NOT_FOUND.replace("##","'"+j+"'");L.error("MockServer: navigation property '"+k+"' was not expanded, so "+E);return a;}}else{t._logAndThrowMockServerCustomError(400,t._oErrorMessages.PROPERTY_NOT_FOUND,P);}return s(P,e,k,j);}else{if(!a[0].hasOwnProperty(P)){t._logAndThrowMockServerCustomError(400,t._oErrorMessages.PROPERTY_NOT_FOUND,P);}return s(P,e);}};switch(O){case"substringof":return G(true,0,1,function(p,v,C,P){return a.filter(function(m){if(C&&P){return(typeof m[C][P]==="string"&&m[C][P].indexOf(v)!==-1);}return(typeof m[p]==="string"&&m[p].indexOf(v)!==-1);});});case"startswith":return G(true,1,0,function(p,v,C,P){return a.filter(function(m){if(C&&P){return(typeof m[C][P]==="string"&&m[C][P].indexOf(v)===0);}return(typeof m[p]==="string"&&m[p].indexOf(v)===0);});});case"endswith":return G(true,1,0,function(p,v,C,P){return a.filter(function(m){if(C&&P){return(typeof m[C][P]==="string"&&m[C][P].indexOf(v)===(m[C][P].length-v.length));}return(typeof m[p]==="string"&&m[p].indexOf(v)===(m[p].length-v.length));});});case"eq":return G(false,2,0,function(p,v,C,P){return a.filter(function(m){if(C&&P){return(m[C][P]===v);}return(m[p]===v);});});case"ne":return G(false,2,0,function(p,v,C,P){return a.filter(function(m){if(C&&P){return(m[C][P]!==v);}return(m[p]!==v);});});case"gt":return G(false,2,0,function(p,v,C,P){return a.filter(function(m){if(C&&P){return(m[C][P]>v);}return(m[p]>v);});});case"lt":return G(false,2,0,function(p,v,C,P){return a.filter(function(m){if(C&&P){return(m[C][P]<v);}return(m[p]<v);});});case"ge":return G(false,2,0,function(p,v,C,P){return a.filter(function(m){if(C&&P){return(m[C][P]>=v);}return(m[p]>=v);});});case"le":return G(false,2,0,function(p,v,C,P){return a.filter(function(m){if(C&&P){return(m[C][P]<=v);}return(m[p]<=v);});});default:this._logAndThrowMockServerCustomError(400,t._oErrorMessages.INVALID_FILTER_OPERATOR,O);}};
g.prototype._recursiveOdataQuerySearch=function(a,o,O,e){var F="";if(O==""||O==undefined){for(var i=0;i<this._mEntitySets[e].keys.length;i++){if(i!=0){F=F+" or ";}F=F+"startswith("+this._mEntitySets[e].keys[i]+",'"+o+"')";}}else{F="substringof('"+o+"',"+O+")";}return this._recursiveOdataQueryFilter(a,F);};
g.prototype._getOdataQuerySelect=function(a,o,e){var t=this;var p,c;var P=o.split(',');var s=[];var b;var k=a[0]?a[0][P[0].split('/')[0]]:null;if(!(k!=null&&k.results&&k.results.length>0)){var C=function(P,l,b,n){var r={};q.each(P,function(i,j){var u=j.indexOf("/");if(u!==-1){p=j.substring(u+1);c=j.substring(0,u);if(r[c]){r[c].push(p);}else{r[c]=[p];}}});q.each(Object.keys(r),function(i,j){if(!b[j]){b[j]={};}b[j]=C(r[j],l[j],b[j],j);});if(l.results){var F=[];q.each(l.results,function(i,R){var u={};q.each(P,function(j,v){u[v]=R[v];});F.push(u);});if(b){b.results=F;}}else{if(l["__metadata"]){b["__metadata"]=l["__metadata"];}q.each(P,function(i,j){var u=j.indexOf("/");if(u===-1){if(l&&!l.hasOwnProperty(j)){var E=false;var T=[];if(n){var v=t._mEntitySets[e].navprops[n].to.entitySet;T=t._mEntityTypes[t._mEntitySets[v].type].properties;for(var i=0;i<T.length;i++){if(T[i].name===j){E=true;break;}}}if(!E){t._logAndThrowMockServerCustomError(404,t._oErrorMessages.RESOURCE_NOT_FOUND_FOR_SEGMENT,j);}}b[j]=l[j];}});}return b;};if(P.indexOf("*")!==-1){return a;}q.each(P,function(i,j){P[i]=t._trim(j);});q.each(a,function(i,j){b={};s.push(C(P,j,b));});}else{var m=function(i,j,l){var r={};l=l||'';if(typeof i!=='object'){return i;}if(typeof i.slice==='function'){return i.map(function(n,u){return m(n,j,l);});}if(i.__metadata!==undefined&&l.length===0){r.__metadata=i.__metadata;}j.filter(function(n){return(n+'/').indexOf(l)===0;}).forEach(function(n,_,u){var v=n.substr(l.length).split('/')[0];if(i[v]!==undefined){r[v]=m(i[v],u,l+v+'/');}});if(i.results!==undefined){r.results=m(i.results,j,l);}return r;};s=m(a,P);}return s;};
g.prototype._getOdataInlineCount=function(a,o){var p=o.split(',');if(p.length!==1||(p[0]!=='none'&&p[0]!=='allpages')){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.INVALID_SYSTEM_QUERY_OPTION_VALUE);}if(p[0]==='none'){return;}return a.length;};
g.prototype._getOdataQueryFormat=function(a,o){if(o!=='json'){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.UNSUPPORTED_FORMAT_VALUE);}return a;};
g.prototype._getOdataQueryExpand=function(a,o,e){var t=this;var n=o.split(',');q.each(n,function(i,p){n[i]=t._trim(p);});var E=t._mEntitySets[e].navprops;q.each(a,function(i,r){q.each(n,function(i,N){var b=N.split("/");var s=b[0];if(!r[s]){t._logAndThrowMockServerCustomError(404,t._oErrorMessages.RESOURCE_NOT_FOUND_FOR_SEGMENT,s);}var c=r[s].results||r[s];if(!c||!!c.__deferred){c=q.extend(true,[],t._resolveNavigation(e,r,s,r));}else if(!Array.isArray(c)){c=[c];}if(!!c&&b.length>1){var R=b.splice(1,b.length).join("/");c=t._getOdataQueryExpand(c,R,E[s].to.entitySet);}if(E[s].to.multiplicity==="*"){r[s]={results:c};}else{r[s]=c[0]?c[0]:{};}});});return a;};
g.prototype._refreshData=function(){var m=this._loadMetadata(this._sMetadataString);if(!m){return;}this._mEntitySets=this._findEntitySets(this._oMetadata);this._mEntityTypes=this._findEntityTypes(this._oMetadata);if(!this._sMockdataBaseUrl){this._generateMockdata(this._mEntitySets,this._oMetadata);}else{if(!this._sMockdataBaseUrl.endsWith("/")&&!this._sMockdataBaseUrl.endsWith(".json")){this._sMockdataBaseUrl+="/";}this._loadMockdata(this._mEntitySets,this._sMockdataBaseUrl);}};
g.prototype._getRootUri=function(){var u=this.getRootUri();u=u&&/([^?#]*)([?#].*)?/.exec(u)[1];return u;};
g.prototype._loadMetadata=function(m){var m;m=m.trim();if(m.substring(0,1)!=="<"){m=q.sap.sjax({url:m,dataType:"text"}).data;if(!m){L.error("MockServer: The metadata for url \""+m+"\" could not be found!");}}this._sMetadata=m;try{this._oMetadata=q.parseXML(m);}catch(e){L.error("MockServer: Invalid metadata XML! Reason: "+e);}return this._oMetadata;};
g.prototype._findEntitySets=function(m){var e={};var p=q(m).find("Principal");var o=q(m).find("Dependent");q(m).find("EntitySet").each(function(i,E){var $=q(E);var a=/((.*)\.)?(.*)/.exec($.attr("EntityType"));e[$.attr("Name")]={"name":$.attr("Name"),"schema":a[2],"type":a[3],"keys":[],"keysType":{},"navprops":{}};});var r=function(R,a,A,F){var E=q(A).find("End[Role='"+R+"']").attr("EntitySet");var s=q(a).find("End[Role='"+R+"']").attr("Multiplicity");var P=[];var c=q(a).find("ReferentialConstraint > [Role='"+R+"']");if(c&&c.length>0){q(c[0]).children("PropertyRef").each(function(i,j){P.push(q(j).attr("Name"));});}else{var b=(F)?p:o;q(b).each(function(i,j){if(R===(q(j).attr("Role"))){q(j).children("PropertyRef").each(function(i,k){P.push(q(k).attr("Name"));});return false;}});}return{"role":R,"entitySet":E,"propRef":P,"multiplicity":s};};q.each(e,function(E,a){var $=q(m).find("EntityType[Name='"+a.type+"']");var k=q($).find("PropertyRef");q.each(k,function(i,P){var K=q(P).attr("Name");a.keys.push(K);a.keysType[K]=q($).find("Property[Name='"+K+"']").attr("Type");});var n=q(m).find("EntityType[Name='"+a.type+"'] NavigationProperty");q.each(n,function(i,N){var b=q(N);var R=b.attr("Relationship").split(".");var A=q(m).find("AssociationSet[Association = '"+R.join(".")+"']");var s=R.pop();var c=q(m).find("Association[Name = '"+s+"']");a.navprops[b.attr("Name")]={"name":b.attr("Name"),"from":r(b.attr("FromRole"),c,A,true),"to":r(b.attr("ToRole"),c,A,false)};});});return e;};
g.prototype._findEntityTypes=function(m){var e={};q(m).find("EntityType").each(function(i,E){var $=q(E);e[$.attr("Name")]={"name":$.attr("Name"),"properties":[],"keys":[]};$.find("Property").each(function(i,p){var P=q(p);var t=P.attr("Type");e[$.attr("Name")].properties.push({"schema":t.substring(0,t.lastIndexOf(".")),"type":t.substring(t.lastIndexOf(".")+1),"name":P.attr("Name"),"precision":P.attr("Precision"),"scale":P.attr("Scale")});});$.find("PropertyRef").each(function(i,k){var K=q(k);var p=K.attr("Name");e[$.attr("Name")].keys.push(p);});});return e;};
g.prototype._findComplexTypes=function(m){var c={};q(m).find("ComplexType").each(function(i,C){var $=q(C);c[$.attr("Name")]={"name":$.attr("Name"),"properties":[]};$.find("Property").each(function(i,p){var P=q(p);var t=P.attr("Type");c[$.attr("Name")].properties.push({"schema":t.substring(0,t.lastIndexOf(".")),"type":t.substring(t.lastIndexOf(".")+1),"name":P.attr("Name"),"precision":P.attr("Precision"),"scale":P.attr("Scale")});});});return c;};
g.prototype._createKeysString=function(e,E){var t=this;var k="";if(E){q.each(e.keys,function(i,K){if(k){k+=",";}var o=E[K];if(e.keysType[K]==="Edm.String"){o=encodeURIComponent("'"+o+"'");}else if(e.keysType[K]==="Edm.DateTime"){o=t._getDateTime(o);o=encodeURIComponent(o);}else if(e.keysType[K]==="Edm.Guid"){o="guid'"+o+"'";}if(e.keys.length===1){k+=o;return k;}k+=K+"="+o;});}return k;};
g.prototype._loadMockdata=function(e,b){var t=this,m={};this._oMockdata={};var l=function(u,o){var r=q.sap.sjax({url:u,dataType:"json"});if(r.success){if(r.data.d){if(r.data.d.results){m[o.name]=r.data.d.results;}else{L.error("The mock data format for entity set \""+o.name+"\" invalid");}}else{if(Array.isArray(r.data)){m[o.name]=r.data;}else{L.error("The mock data for entity set \""+o.name+"\" could not be loaded due to wrong format!");return false;}}return true;}else{if(r.status==="parsererror"){L.error("The mock data for entity set \""+o.name+"\" could not be loaded due to a parsing error!");}return false;}};if(b.endsWith(".json")){var r=q.sap.sjax({url:b,dataType:"json"});if(r.success){m=r.data;}else{L.warning("The mock data for all the entity types could not be found at \""+b+"\"!");}}else{var E={};if(t._aEntitySetsNames&&t._aEntitySetsNames.length>0){var s;for(var i=0;i<t._aEntitySetsNames.length;i++){s=t._aEntitySetsNames[i];if(e[s]){E[s]=e[s];}}}else{E=e;}q.each(E,function(a,o){if(!m[o.type]||!m[o.name]){var c=b+o.name+".json";if(!l(c,o)){L.warning("The mock data for entity set \""+o.name+"\" could not be found at \""+b+"\"!");var j=b+o.type+".json";if(!l(j,o)){L.warning("The mock data for entity type \""+o.type+"\" could not be found at \""+b+"\"!");if(t._bGenerateMissingMockData){var k={};k[o.name]=o;m[o.type]=t._generateODataMockdataForEntitySet(k,t._oMetadata)[o.name];}}}}});}q.each(e,function(a,o){t._oMockdata[a]=[];if(m[o.name]){q.each(m[o.name],function(I,c){t._oMockdata[a].push(q.extend(true,{},c));});}else if(m[o.type]){q.each(m[o.type],function(I,c){t._oMockdata[a].push(q.extend(true,{},c));});}});q.each(e,function(a,o){if(t._oMockdata[a].length>0){t._enhanceWithMetadata(o,t._oMockdata[a]);}});return this._oMockdata;};
g.prototype._enhanceWithMetadata=function(e,m){if(m){var t=this,r=this._getRootUri(),E=e&&e.name;q.each(m,function(i,o){o.__metadata=o.__metadata||{};o.__metadata.id=r+E+"("+t._createKeysString(e,o)+")";o.__metadata.type=e.schema+"."+e.type;o.__metadata.uri=r+E+"("+t._createKeysString(e,o)+")";q.each(e.navprops,function(k,n){if(o[k]&&!f(o[k])&&!o[k]["__deferred"]){t._oMockdata[n.to.entitySet]=t._oMockdata[n.to.entitySet].concat(o[k]);}o[k]={__deferred:{uri:r+E+"("+t._createKeysString(e,o)+")/"+k}};});});}};
g.prototype._isRequestedKeysValid=function(e,r){if(r.length===1){var s=r[0].split('=');if(this._trim(s[0])!==e.keys[0]){r=[e.keys[0]+"="+r[0]];}}for(var i=0;i<r.length;i++){var k=this._trim(r[i].substring(0,r[i].indexOf('=')));var R=this._trim(r[i].substring(r[i].indexOf('=')+1));var F=R.charAt(0);var l=R.charAt(R.length-1);if(e.keysType[k]==="Edm.String"){if(F!=="'"||l!=="'"){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.MALFORMED_URI_LITERAL_SYNTAX_IN_KEY,k);}}else if(e.keysType[k]==="Edm.DateTime"){if(F==="'"||l!=="'"){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.MALFORMED_URI_LITERAL_SYNTAX_IN_KEY,k);}}else if(e.keysType[k]==="Edm.Guid"){if(F==="'"||l!=="'"){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.MALFORMED_URI_LITERAL_SYNTAX_IN_KEY,k);}}else if(e.keysType[k]==="Edm.Binary"){if(!(new RegExp("(binary|X)'[A-Fa-f0-9][A-Fa-f0-9]*'").test(R))){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.MALFORMED_URI_LITERAL_SYNTAX_IN_KEY,k);}}else{if((F==="'"&&l!=="'")||(l==="'"&&F!=="'")){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.MALFORMED_URI_LITERAL_SYNTAX_IN_KEY,k);}}var K=e.keys.join(",");if(e.keys.indexOf(k)===-1){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.INVALID_KEY_NAME,K);}}};
g.prototype._parseKeys=function(k,e){var r={};var p=k.split(",");var K,s,P;for(var i=0;i<p.length;i++){P=p[i].split("=");if(P.length===1&&e.keys.length===1){K=e.keys[0];s=P[0];}else{if(P.length===2){K=P[0];s=P[1];}}r[K]=s;switch(e.keysType[K]){case"Edm.String":r[K]=r[K].replace(/^\'|\'$/g,"");break;case"Edm.Int16":case"Edm.Int32":case"Edm.Int64":case"Edm.Decimal":case"Edm.Byte":case"Edm.Double":case"Edm.Single":case"Edm.SByte":r[K]=parseFloat(r[K]);break;case"Edm.Guid":r[K]=r[K].replace(/^guid\'|\'$/g,"");break;case"Edm.Boolean":case"Edm.Binary":case"Edm.DateTimeOffset":default:r[K]=r[K];}}return r;};
g.prototype._generatePropertyValue=function(k,t,C,i){var I=i;if(!I){I=Math.floor(this._getPseudoRandomNumber("String")*10000)+101;}switch(t){case"String":return k+" "+I;case"DateTime":var a=new Date();a.setFullYear(2000+Math.floor(this._getPseudoRandomNumber("DateTime")*20));a.setDate(Math.floor(this._getPseudoRandomNumber("DateTime")*30));a.setMonth(Math.floor(this._getPseudoRandomNumber("DateTime")*12));a.setMilliseconds(0);return"/Date("+a.getTime()+")/";case"Int16":case"Int32":case"Int64":return Math.floor(this._getPseudoRandomNumber("Int")*10000);case"Decimal":return Math.floor(this._getPseudoRandomNumber("Decimal")*1000000)/100;case"Boolean":return this._getPseudoRandomNumber("Boolean")<0.5;case"Byte":return Math.floor(this._getPseudoRandomNumber("Byte")*10);case"Double":return this._getPseudoRandomNumber("Double")*10;case"Single":return this._getPseudoRandomNumber("Single")*1000000000;case"SByte":return Math.floor(this._getPseudoRandomNumber("SByte")*10);case"Time":return"PT"+Math.floor(this._getPseudoRandomNumber("Time")*23)+"H"+Math.floor(this._getPseudoRandomNumber("Time")*59)+"M"+Math.floor(this._getPseudoRandomNumber("Time")*59)+"S";case"Guid":return'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g,function(c){var r=this._getPseudoRandomNumber("Guid")*16|0,v=c==='x'?r:(r&0x3|0x8);return v.toString(16);}.bind(this));case"Binary":var n=Math.floor(-2147483648+this._getPseudoRandomNumber("Binary")*4294967295),m="";for(var b=0,e=n;b<32;b++,m+=String(e>>>31),e<<=1);return m;case"DateTimeOffset":var a=new Date();a.setFullYear(2000+Math.floor(this._getPseudoRandomNumber("DateTimeOffset")*20));a.setDate(Math.floor(this._getPseudoRandomNumber("DateTimeOffset")*30));a.setMonth(Math.floor(this._getPseudoRandomNumber("DateTimeOffset")*12));a.setMilliseconds(0);return"/Date("+a.getTime()+"+0000)/";default:return this._generateDataFromEntity(C[t],I,C);}};
g.prototype._isFalseyValue=function(k,K,s){switch(s){case"Edm.String":return k==="";case"Edm.Boolean":return k===false;case"Edm.Int16":case"Edm.Int32":case"Edm.Int64":case"Edm.Decimal":case"Edm.Byte":case"Edm.Double":case"Edm.Single":case"Edm.SByte":return k===0||isNaN(k);default:return false;}};
g.prototype._completeKey=function(e,k,E){if(E){for(var i=0;i<e.keys.length;i++){var K=e.keys[i];if(k[K]!==undefined&&k[K]!==null){if(!E[K]){switch(e.keysType[K]){case"Edm.DateTime":E[K]=this._getJsonDate(k[K]);break;case"Edm.Guid":E[K]=k[K].replace(/^guid\'|\'$/g,"");break;default:E[K]=k[K];}}}else{if(!E[K]){E[K]=this._generatePropertyValue(K,e.keysType[K].substring(e.keysType[K].lastIndexOf('.')+1));}}}}};
g.prototype._generateDataFromEntity=function(e,I,c){var E={};if(!e){return E;}for(var i=0;i<e.properties.length;i++){var p=e.properties[i];E[p.name]=this._generatePropertyValue(p.name,p.type,c,I);}return E;};
g.prototype._generateDataFromEntitySet=function(e,E,c){var o=E[e.type];var m=[];for(var i=0;i<100;i++){m.push(this._generateDataFromEntity(o,i+1,c));}return m;};
g.prototype._generateMockdata=function(e,m){var t=this;var o={};var r=this._getRootUri();q.each(e,function(E,a){var b={};b[a.name]=a;o[E]=t._generateODataMockdataForEntitySet(b,m)[E];});q.each(e,function(E,a){for(var n in a.navprops){var N=a.navprops[n];var p=N.from.propRef.length;for(var j=0;j<p;j++){for(var i=0;i<o[E].length;i++){var b=o[E][i];o[N.to.entitySet][i][N.to.propRef[j]]=b[N.from.propRef[j]];}}}q.each(o[E],function(I,c){c.__metadata={uri:r+E+"("+t._createKeysString(a,c)+")",type:a.schema+"."+a.type};q.each(a.navprops,function(k,N){c[k]={__deferred:{uri:r+E+"("+t._createKeysString(a,c)+")/"+k}};});});});this._oMockdata=o;};
g.prototype._generateODataMockdataForEntitySet=function(e,m){var t=this,o={};var E=this._findEntityTypes(m);var c=this._findComplexTypes(m);q.each(e,function(s,a){o[s]=t._generateDataFromEntitySet(a,E,c);});return o;};
g.prototype._resolveNavigation=function(e,F,n){var E=this._mEntitySets[e];var N=E.navprops[n];if(!N){this._logAndThrowMockServerCustomError(404,this._oErrorMessages.RESOURCE_NOT_FOUND);}var a=[];var p=N.from.propRef.length;if(p===0){if(N.to.multiplicity==="*"){return this._oMockdata[N.to.entitySet];}else{a.push(this._oMockdata[N.to.entitySet][0]);return a;}}q.each(this._oMockdata[N.to.entitySet],function(I,t){var b=true;for(var i=0;i<p;i++){if(F[N.from.propRef[i]]!==t[N.to.propRef[i]]){b=false;break;}}if(b){a.push(t);}});return a;};
g.prototype.simulate=function(s,v){var t=this;this._sMetadataString=s;if(!v||typeof v==="string"){this._sMockdataBaseUrl=v;}else{this._sMockdataBaseUrl=v.sMockdataBaseUrl;this._bGenerateMissingMockData=v.bGenerateMissingMockData;this._aEntitySetsNames=v.aEntitySetsNames;}var o=this._loadMetadata(this._sMetadataString);if(!o){return;}if(this._sMetadata){var a=sap.ui.requireSync("sap/ui/core/util/MockServerAnnotationsHandler");var A=a.parse(this._oMetadata,this._sMetadata);var b=sap.ui.requireSync("sap/ui/core/util/DraftEnabledMockServer");b.handleDraft(A,this);}this._resetPseudoRandomNumberGenerator();this._refreshData();var H=function(x,m){if(x.requestHeaders["x-csrf-token"]==="Fetch"){m["X-CSRF-Token"]="42424242424242424242424242424242";}};var G=function(e,k){k=decodeURIComponent(k);var F;var E=t._mEntitySets[e];var K=E.keys;var j=k.split(',');if(j.length!==K.length){t._logAndThrowMockServerCustomError(400,t._oErrorMessages.INVALID_KEY_PREDICATE_QUANTITY);}t._isRequestedKeysValid(E,j);if(j.length===1&&!j[0].split('=')[1]){j=[K[0]+"="+j[0]];}q.each(t._oMockdata[e],function(I,m){for(var i=0;i<j.length;i++){var n=j[i].split('=');var p=t._trim(n[0]);if(!K||K.indexOf(p)===-1){return true;}var N=t._trim(n[1]);var O=m[p];switch(E.keysType[p]){case"Edm.String":N=N.replace(/^\'|\'$/g,'');break;case"Edm.Time":case"Edm.DateTime":O=t._getDateTime(O);break;case"Edm.Int16":case"Edm.Int32":case"Edm.Decimal":case"Edm.Byte":case"Edm.Double":case"Edm.Single":case"Edm.SByte":if(!t._isValidNumber(N)){return false;}N=parseFloat(N);break;case"Edm.Guid":N=N.replace(/^guid\'|\'$/g,'');break;case"Edm.Boolean":if(["true","false"].indexOf(N)===-1){t._logAndThrowMockServerCustomError(400,t._oErrorMessages.INVALID_KEY_TYPE,p);}N=N==="true";break;case"Edm.Binary":case"Edm.DateTimeOffset":default:N=N;}if(O!==N){return true;}}F={index:I,entry:m};return false;});return F;};var r=function(e,k,u){var S=e.name;var n;if(u){n=e.navprops[u];}if(n){S=n.to.entitySet;}return S;};var c=function(u){var U=[];var S=function(V){var j=V.indexOf("'");var n=V.indexOf("\"");if(j===-1&&n===-1){return null;}else{if(j>-1&&n===-1){return"appost";}if(n>-1&&j===-1){return"doublequotes";}if(j>-1&&n>-1&&j<n){return"appost";}if(j>-1&&n>-1&&n<j){return"doublequotes";}}};var e=function(p,P,n,w){var x=p[n];var j=n+1;while(j<p.length&&p[j].indexOf(w)===-1){x=x+"&"+p[j];j++;}x=x+"&"+p[j];P.push(x);n=j;return n;};for(var i=0;i<u.length;i++){if(!S(u[i])){U.push(u[i]);}if(S(u[i])==="appost"){var k=u[i].indexOf("'");if(u[i].indexOf("'",k+1)===-1){i=e(u,U,i,"'");}else{U.push(u[i]);}}if(S(u[i])==="doublequotes"){var m=u[i].indexOf("\"");if(u[i].indexOf("\"",m+1)===-1){i=e(u,U,i,"\"");}else{U.push(u[i]);}}}return U;};var l=function(x,T,k,u){k=k?decodeURIComponent(k):k;var e=JSON.parse(x.requestBody);if(e){var K={};if(k){K=t._parseKeys(k,t._mEntitySets[T]);}t._completeKey(t._mEntitySets[T],K,e);t._enhanceWithMetadata(t._mEntitySets[T],[e]);return e;}return null;};var R=[];R.push({method:"GET",path:new RegExp("\\$metadata([?#].*)?"),response:function(x){sap.ui.requireSync("jquery.sap.xml");L.debug("MockServer: incoming request for url: "+x.url);var m={"Content-Type":"application/xml;charset=utf-8"};H(x,m);x.respond(200,m,t._sMetadata);L.debug("MockServer: response sent with: 200, "+t._sMetadata);return true;}});R.push({method:"HEAD",path:new RegExp("$"),response:function(x){L.debug("MockServer: incoming request for url: "+x.url);var m={"Content-Type":"application/json;charset=utf-8"};H(x,m);x.respond(200,m);L.debug("MockServer: response sent with: 200");return true;}});R.push({method:"GET",path:new RegExp("$"),response:function(x){L.debug("MockServer: incoming request for url: "+x.url);var m={"Content-Type":"application/json;charset=utf-8"};H(x,m);var e=[];q.each(t._mEntitySets,function(E,j){e.push(E);});var i={EntitySets:e};x.respond(200,m,JSON.stringify({d:i}));L.debug("MockServer: response sent with: 200, "+JSON.stringify({d:i}));return true;}});R.push({method:"POST",path:new RegExp("\\$batch([?#].*)?"),response:function(x){L.debug("MockServer: incoming request for url: "+x.url);var e=function(c1){switch(c1.statusCode){case 200:return"200 OK";case 201:return"201 Created";case 204:return"204 No Content";case 400:return"400 Bad Request";case 401:return"401 Unauthorized";case 403:return"403 Forbidden";case 404:return"404 Not Found";case 405:return"405 Method Not Allowed";case 409:return"409 Conflict";case 412:return"412 Precondition Failed";case 415:return"415 Unsupported Media Type";case 500:return"500 Internal Server Error";case 501:return"501 Not Implemented";case 503:return"503 Service Unavailable";default:return c1.statusCode+" "+c1.status;}};var B=function(c1,d1){var e1;if(c1.success){e1=JSON.stringify(c1.data)||"";}else{e1=c1.errorResponse;}d1=d1||"application/json";if(c1.responseHeaders){return"HTTP/1.1 "+e(c1)+"\r\n"+c1.responseHeaders+"dataserviceversion: 2.0\r\n\r\n"+e1+"\r\n";}else{return"HTTP/1.1 "+e(c1)+"\r\nContent-Type: "+d1+"\r\nContent-Length: "+e1.length+"\r\ndataserviceversion: 2.0\r\n\r\n"+e1+"\r\n";}};var C=function(c1,W,d1,Q,X){var e1;var f1=function(h1,i1,j1){e1={success:true,data:h1,status:i1,statusCode:j1&&j1.status,responseHeaders:j1&&j1.getAllResponseHeaders()};};var g1=function(h1,i1,j1){e1={success:false,data:undefined,status:i1,error:j1,statusCode:h1.status,errorResponse:h1.responseText,responseHeaders:h1&&h1.getAllResponseHeaders()};};q.ajax({type:d1,async:false,url:c1,headers:X,data:W,dataType:"json",success:f1,error:g1});if(e1.statusCode===400||e1.statusCode===404){var a1=B(e1);throw new Error(a1);}Q.push(B(e1));};var n=function(c1,z){var d1;var e1;var f1=function(h1,i1,j1){d1={success:true,data:h1,status:i1,statusCode:j1&&j1.status,responseHeaders:j1&&j1.getAllResponseHeaders()};};var g1=function(h1,i1,j1){d1={success:false,data:undefined,status:i1,error:j1,statusCode:h1.status,errorResponse:h1.responseText,responseHeaders:h1&&h1.getAllResponseHeaders()};};q.ajax({async:false,url:c1,dataType:"json",success:f1,error:g1});var e1;if(c1.indexOf('$count')!==-1){e1=B(d1,"text/plain");}else{e1=B(d1);}z.push("\r\nContent-Type: application/http\r\n"+"Content-Length: "+e1.length+"\r\n"+"content-transfer-encoding: binary\r\n\r\n"+e1);};var p=function(V){var X={};V.split("HTTP/1.1")[1].split("{")[0].split("\n").forEach(function(c1){if(c1.indexOf(":")!==-1){var d1=c1.split(":");X[d1[0].trim()]=d1[1].trim();}});delete X["Content-Length"];return X;};var u=x.requestBody;var w=new RegExp("--batch_[a-z0-9-]*");var y=w.exec(u)[0];if(!!y){var z=[];var E=u.split(y);var S=x.url.split("$")[0];var F=new RegExp("PUT (.*) HTTP");var I=new RegExp("MERGE (.*) HTTP");var J=new RegExp("POST (.*) HTTP");var K=new RegExp("DELETE (.*) HTTP");var N=new RegExp("GET (.*) HTTP");for(var i=1;i<E.length-1;i++){var O=E[i];if(N.test(O)&&O.indexOf("multipart/mixed")===-1){if(F.test(O)||J.test(O)||K.test(O)){x.respond(400,null,"The Data Services Request could not be understood due to malformed syntax");L.debug("MockServer: response sent with: 400");return true;}n(S+N.exec(O)[1],z);}else{var P=q.extend(true,{},t._oMockdata);var Q=[];var T=O.substring(O.indexOf("boundary=")+9,O.indexOf("\r\n\r\n"));var U=O.split("--"+T);try{for(var j=1;j<U.length-1;j++){var V=U[j];var W;if(N.test(V)){t._oMockdata=P;x.respond(400,null,"The Data Services Request could not be understood due to malformed syntax");L.debug("MockServer: response sent with: 400");return;}else{var W=V.substring(V.indexOf("{"),V.lastIndexOf("}")+1),X=p(V),Y,Z;if(F.test(V)){Z="PUT";Y=F.exec(V)[1];}else if(I.test(V)){Z="MERGE";Y=I.exec(V)[1];}else if(J.test(V)){Z="POST";Y=J.exec(V)[1];}else if(K.test(V)){Z="DELETE";W=undefined;Y=K.exec(V)[1];}C(S+Y,W,Z,Q,X);}}var $="\r\nContent-Type: multipart/mixed; boundary=ejjeeffe1\r\n\r\n--ejjeeffe1";for(var k=0;k<Q.length;k++){$+="\r\nContent-Type: application/http\r\n"+"Content-Length: "+Q[k].length+"\r\n"+"content-transfer-encoding: binary\r\n\r\n"+Q[k]+"--ejjeeffe1";}$+="--\r\n";z.push($);}catch(_){t._oMockdata=P;var a1="\r\nContent-Type: application/http\r\n"+"Content-Length: "+_.message.length+"\r\n"+"content-transfer-encoding: binary\r\n\r\n"+_.message;z.push(a1);}}}var b1="--ejjeeffe0";for(var m=0;m<z.length;m++){b1+=z[m]+"--ejjeeffe0";}b1+="--";var X={'Content-Type':"multipart/mixed; boundary=ejjeeffe0"};H(x,X);x.respond(202,X,b1);L.debug("MockServer: response sent with: 202, "+b1);}else{x.respond(202);}return true;}});q.each(this._mEntitySets,function(E,i){R.push({method:"GET",path:new RegExp("("+E+")/\\$count/?(.*)?"),response:function(x,E,u){L.debug("MockServer: incoming request for url: "+x.url);t.fireEvent(g.HTTPMETHOD.GET+E+":before",{oXhr:x,sUrlParams:u});t.fireEvent(g.HTTPMETHOD.GET+":before",{oXhr:x,sUrlParams:u});var m={"Content-Type":"text/plain;charset=utf-8"};H(x,m);try{var j=t._oMockdata[E];if(j){var F={results:q.extend(true,[],j)};if(u){var U=decodeURIComponent(u).replace("?","&").split("&");U=c(U);if(U.length>1){U=t._orderQueryOptions(U);}q.each(U,function(I,Q){t._applyQueryOnCollection(F,Q,E,U);});}t.fireEvent(g.HTTPMETHOD.GET+E+":after",{oXhr:x,oFilteredData:F});t.fireEvent(g.HTTPMETHOD.GET+":after",{oXhr:x,oFilteredData:F});x.respond(200,m,""+F.results.length);L.debug("MockServer: response sent with: 200, "+F.results.length);}else{t._logAndThrowMockServerCustomError(404,t._oErrorMessages.RESOURCE_NOT_FOUND);}}catch(e){if(e.error){x.respond(e.error.code,m,JSON.stringify(e));}else{L.error("MockServer: request failed due to invalid system query options value!");x.respond(parseInt(e.message||e.number));}}return true;}});R.push({method:"GET",path:new RegExp("("+E+")/?(\\?(.*))?"),response:function(x,E,u){L.debug("MockServer: incoming request for url: "+x.url);t.fireEvent(g.HTTPMETHOD.GET+E+":before",{oXhr:x,sUrlParams:u});t.fireEvent(g.HTTPMETHOD.GET+":before",{oXhr:x,sUrlParams:u});var m={"Content-Type":"application/json;charset=utf-8"};H(x,m);try{var j=t._oMockdata[E];if(j){var F={results:q.extend(true,[],j)};if(u){var U=decodeURIComponent(u).replace("?","&").split("&");U=c(U);if(U.length>1){U=t._orderQueryOptions(U);}q.each(U,function(I,Q){t._applyQueryOnCollection(F,Q,E,U);});}t.fireEvent(g.HTTPMETHOD.GET+E+":after",{oXhr:x,oFilteredData:F});t.fireEvent(g.HTTPMETHOD.GET+":after",{oXhr:x,oFilteredData:F});x.respond(200,m,JSON.stringify({d:F}));L.debug("MockServer: response sent with: 200, "+JSON.stringify({d:F}));}else{t._logAndThrowMockServerCustomError(404,t._oErrorMessages.RESOURCE_NOT_FOUND);}}catch(e){if(e.error){x.respond(e.error.code,m,JSON.stringify(e));}else{L.debug("MockServer: response sent with: "+parseInt(e.message||e.number));x.respond(parseInt(e.message||e.number));}}return true;}});R.push({method:"GET",path:new RegExp("("+E+")\\(([^/\\?#]+)\\)/?(\\?(.*))?"),response:function(x,E,k,u){L.debug("MockServer: incoming request for url: "+x.url);t.fireEvent(g.HTTPMETHOD.GET+E+":before",{oXhr:x,sKeys:k,sUrlParams:u});t.fireEvent(g.HTTPMETHOD.GET+":before",{oXhr:x,sKeys:k,sUrlParams:u});var m={"Content-Type":"application/json;charset=utf-8"};try{var j=q.extend(true,{},G(E,k));if(!f(j)){if(u){var U=decodeURIComponent(u).replace("?","&").split("&");U=c(U);if(U.length>1){U=t._orderQueryOptions(U);}q.each(U,function(I,Q){j.entry=t._applyQueryOnEntry(j.entry,Q,E);});}t.fireEvent(g.HTTPMETHOD.GET+E+":after",{oXhr:x,oEntry:j.entry});t.fireEvent(g.HTTPMETHOD.GET+":after",{oXhr:x,oEntry:j.entry});x.respond(200,m,JSON.stringify({d:j.entry}));L.debug("MockServer: response sent with: 200, "+JSON.stringify({d:j.entry}));}else{t._logAndThrowMockServerCustomError(404,t._oErrorMessages.RESOURCE_NOT_FOUND);}}catch(e){if(e.error){x.respond(e.error.code,m,JSON.stringify(e));}else{L.debug("MockServer: response sent with: "+parseInt(e.message||e.number));x.respond(parseInt(e.message||e.number));}}return true;}});q.each(i.navprops,function(n,N){R.push({method:"GET",path:new RegExp("("+E+")\\(([^/\\?#]+)\\)/("+n+")/\\$count/?(.*)?"),response:function(x,E,k,j,u){L.debug("MockServer: incoming request for url: "+x.url);t.fireEvent(g.HTTPMETHOD.GET+E+":before",{oXhr:x,sKeys:k,sNavProp:j,sUrlParams:u});t.fireEvent(g.HTTPMETHOD.GET+":before",{oXhr:x,sKeys:k,sNavProp:j,sUrlParams:u});var m={"Content-Type":"text/plain;charset=utf-8"};H(x,m);try{var p=G(E,k);if(p){var w,F={};w=t._resolveNavigation(E,p.entry,j);var y=t._mEntitySets[E].navprops[j].to.multiplicity;if(y==="*"){F={results:q.extend(true,[],w)};}else{F=q.extend(true,{},w[0]);}if(w&&w.length!==0){if(u){var U=decodeURIComponent(u).replace("?","&").split("&");U=c(U);if(U.length>1){U=t._orderQueryOptions(U);}if(y==="*"){q.each(U,function(I,Q){t._applyQueryOnCollection(F,Q,t._mEntitySets[E].navprops[j].to.entitySet,U);});}else{q.each(U,function(I,Q){F=t._applyQueryOnEntry(F,Q,t._mEntitySets[E].navprops[j].to.entitySet);});}}}t.fireEvent(g.HTTPMETHOD.GET+E+":after",{oXhr:x,oFilteredData:F});t.fireEvent(g.HTTPMETHOD.GET+":after",{oXhr:x,oFilteredData:F});F.results=F.results||[];x.respond(200,m,""+F.results.length);L.debug("MockServer: response sent with: 200, "+F.results.length);}else{t._logAndThrowMockServerCustomError(404,t._oErrorMessages.RESOURCE_NOT_FOUND);}}catch(e){if(e.error){x.respond(e.error.code,m,JSON.stringify(e));}else{L.debug("MockServer: response sent with: "+parseInt(e.message||e.number));x.respond(parseInt(e.message||e.number));}}return true;}});R.push({method:"GET",path:new RegExp("("+E+")\\(([^/\\?#]+)\\)/("+n+")/?(\\?(.*))?"),response:function(x,E,k,j,u){L.debug("MockServer: incoming request for url: "+x.url);t.fireEvent(g.HTTPMETHOD.GET+E+":before",{oXhr:x,sKeys:k,sNavProp:j,sUrlParams:u});t.fireEvent(g.HTTPMETHOD.GET+":before",{oXhr:x,sKeys:k,sNavProp:j,sUrlParams:u});var m={"Content-Type":"application/json;charset=utf-8"};H(x,m);try{var p=G(E,k);if(p){var w,F={};w=t._resolveNavigation(E,p.entry,j,p.entry);var y=t._mEntitySets[E].navprops[j].to.multiplicity;if(y==="*"){F={results:q.extend(true,[],w)};}else{F=q.extend(true,{},w[0]);}if(w&&w.length!==0){if(u){var U=decodeURIComponent(u).replace("?","&").split("&");U=c(U);if(U.length>1){U=t._orderQueryOptions(U);}if(y==="*"){q.each(U,function(I,Q){t._applyQueryOnCollection(F,Q,t._mEntitySets[E].navprops[j].to.entitySet,U);});}else{q.each(U,function(I,Q){F=t._applyQueryOnEntry(F,Q,t._mEntitySets[E].navprops[j].to.entitySet);});}}}t.fireEvent(g.HTTPMETHOD.GET+E+":after",{oXhr:x,oFilteredData:F});t.fireEvent(g.HTTPMETHOD.GET+":after",{oXhr:x,oFilteredData:F});x.respond(200,m,JSON.stringify({d:F}));L.debug("MockServer: response sent with: 200, "+JSON.stringify({d:F}));}else{t._logAndThrowMockServerCustomError(404,t._oErrorMessages.RESOURCE_NOT_FOUND);}}catch(e){if(e.error){x.respond(e.error.code,m,JSON.stringify(e));}else{x.respond(parseInt(e.message||e.number));L.debug("MockServer: response sent with: "+parseInt(e.message||e.number));}}return true;}});});R.push({method:"POST",path:new RegExp("("+E+")(\\(([^/\\?#]+)\\)/?(.*)?)?"),response:function(x,E,j,k,n){var m=false;if(x.requestHeaders["x-http-method"]==="MERGE"){m=true;}L.debug("MockServer: incoming create request for url: "+x.url);t.fireEvent(g.HTTPMETHOD.POST+E+":before",{oXhr:x,sKeys:k,sNavName:n});t.fireEvent(g.HTTPMETHOD.POST+":before",{oXhr:x,sKeys:k,sNavName:n});var p=null;var u=null;var w=405;try{if(k&&!k.split('=')[1]){k=t._mEntitySets[E].keys[0]+"="+k;}var T=r(i,decodeURIComponent(k),n);if(T){var y=l(x,T,k,n);if(y){u={"Content-Type":"application/json;charset=utf-8"};t.fireEvent(g.HTTPMETHOD.POST+E+":after",{oXhr:x,oEntity:y});t.fireEvent(g.HTTPMETHOD.POST+":after",{oXhr:x,oEntity:y});if(m){var z=G(E,k);if(z){q.extend(t._oMockdata[E][z.index],y);}w=204;}else{var U=t._getRootUri()+T+"("+t._createKeysString(t._mEntitySets[T],y)+")";p=JSON.stringify({d:y,uri:U});t._oMockdata[T]=t._oMockdata[T].concat([y]);w=201;}}}x.respond(w,u,p);L.debug("MockServer: response sent with: "+w+", "+p);}catch(e){if(e.error){var B={"Content-Type":"text/plain;charset=utf-8"};x.respond(e.error.code,B,JSON.stringify(e));}else{x.respond(parseInt(e.message||e.number));L.debug("MockServer: response sent with: "+parseInt(e.message||e.number));}}return true;}});R.push({method:"PUT",path:new RegExp("("+E+")\\(([^/\\?#]+)\\)/?(.*)?"),response:function(x,E,k,n){L.debug("MockServer: incoming update request for url: "+x.url);t.fireEvent(g.HTTPMETHOD.PUT+E+":before",{oXhr:x,sKeys:k,sNavName:n});t.fireEvent(g.HTTPMETHOD.PUT+":before",{oXhr:x,sKeys:k,sNavName:n});var j=405;var m=null;var p=null;try{var T=r(i,decodeURIComponent(k),n);if(T){var u=l(x,T,k,n);if(u){p={"Content-Type":"application/json;charset=utf-8"};t.fireEvent(g.HTTPMETHOD.PUT+E+":after",{oXhr:x,oEntity:u});t.fireEvent(g.HTTPMETHOD.PUT+":after",{oXhr:x,oEntity:u});var w=G(E,k);if(w){t._oMockdata[E][w.index]=u;}j=204;}}x.respond(j,p,m);L.debug("MockServer: response sent with: "+j+", "+m);}catch(e){if(e.error){var y={"Content-Type":"text/plain;charset=utf-8"};x.respond(e.error.code,y,JSON.stringify(e));}else{x.respond(parseInt(e.message||e.number));L.debug("MockServer: response sent with: "+parseInt(e.message||e.number));}}return true;}});R.push({method:"MERGE",path:new RegExp("("+E+")\\(([^/\\?#]+)\\)/?(.*)?"),response:function(x,E,k,n){L.debug("MockServer: incoming merge update request for url: "+x.url);t.fireEvent(g.HTTPMETHOD.MERGE+E+":before",{oXhr:x,sKeys:k,sNavName:n});t.fireEvent(g.HTTPMETHOD.MERGE+":before",{oXhr:x,sKeys:k,sNavName:n});var j=405;var m=null;var p=null;try{var T=r(i,decodeURIComponent(k),n);if(T){var u=l(x,T,k,n);if(u){p={"Content-Type":"application/json;charset=utf-8"};t.fireEvent(g.HTTPMETHOD.MERGE+E+":after",{oXhr:x,oEntity:u});t.fireEvent(g.HTTPMETHOD.MERGE+":after",{oXhr:x,oEntity:u});var w=G(E,k);if(w){q.extend(t._oMockdata[E][w.index],u);}j=204;}}x.respond(j,p,m);L.debug("MockServer: response sent with: "+j+", "+m);}catch(e){if(e.error){var y={"Content-Type":"text/plain;charset=utf-8"};x.respond(e.error.code,y,JSON.stringify(e));}else{x.respond(parseInt(e.message||e.number));L.debug("MockServer: response sent with: "+parseInt(e.message||e.number));}}return true;}});R.push({method:"PATCH",path:new RegExp("("+E+")\\(([^/\\?#]+)\\)/?(.*)?"),response:function(x,E,k,n){L.debug("MockServer: incoming patch update request for url: "+x.url);t.fireEvent(g.HTTPMETHOD.PATCH+E+":before",{oXhr:x,sKeys:k,sNavName:n});t.fireEvent(g.HTTPMETHOD.PATCH+":before",{oXhr:x,sKeys:k,sNavName:n});var j=405;var m=null;var p=null;try{var T=r(i,decodeURIComponent(k),n);if(T){var u=l(x,T,k,n);if(u){p={"Content-Type":"application/json;charset=utf-8"};t.fireEvent(g.HTTPMETHOD.PATCH+E+":after",{oXhr:x,oEntity:u});t.fireEvent(g.HTTPMETHOD.PATCH+":after",{oXhr:x,oEntity:u});var w=G(E,k);if(w){q.extend(t._oMockdata[E][w.index],u);}j=204;}}x.respond(j,p,m);L.debug("MockServer: response sent with: "+j+", "+m);}catch(e){if(e.error){var y={"Content-Type":"text/plain;charset=utf-8"};x.respond(e.error.code,y,JSON.stringify(e));}else{x.respond(parseInt(e.message||e.number));L.debug("MockServer: response sent with: "+parseInt(e.message||e.number));}}return true;}});R.push({method:"DELETE",path:new RegExp("("+E+")\\(([^/\\?#]+)\\)/?(.*)?"),response:function(x,E,k,u){L.debug("MockServer: incoming delete request for url: "+x.url);t.fireEvent(g.HTTPMETHOD.DELETE+E+":before",{oXhr:x});t.fireEvent(g.HTTPMETHOD.DELETE+":before",{oXhr:x});var j=204;try{var m=G(E,k);if(m){t._oMockdata[E].splice(m.index,1);}else{j=400;}t.fireEvent(g.HTTPMETHOD.DELETE+E+":after",{oXhr:x});t.fireEvent(g.HTTPMETHOD.DELETE+":after",{oXhr:x});x.respond(j,null,null);L.debug("MockServer: response sent with: "+j);}catch(e){if(e.error){var n={"Content-Type":"text/plain;charset=utf-8"};x.respond(e.error.code,n,JSON.stringify(e));}else{x.respond(parseInt(e.message||e.number));L.debug("MockServer: response sent with: "+parseInt(e.message||e.number));}}return true;}});});this.setRequests(R);};
g.prototype._orderQueryOptions=function(u){var F,i,s,t,o,S,e,a,b,c,O=[];var j=this;q.each(u,function(I,Q){var k=u.indexOf(Q);switch(Q.split('=')[0]){case"$top":t=k;break;case"$skip":s=k;break;case"$orderby":o=k;break;case"$expand":e=k;break;case"$filter":F=k;break;case"$select":S=k;break;case"$inlinecount":i=k;break;case"$format":a=k;break;case"search-focus":c=k;break;case"search":b=k;break;default:if(Q.split('=')[0].indexOf('$')===0){j._logAndThrowMockServerCustomError(400,j._oErrorMessages.IS_NOT_A_VALID_SYSTEM_QUERY_OPTION,Q.split('=')[0]);}}});if(e>=0){O.push(u[e]);}if(F>=0){O.push(u[F]);}if(c>=0){O.push(u[c]);}if(b>=0){O.push(u[b]);}if(i>=0){O.push(u[i]);}if(o>=0){O.push(u[o]);}if(s>=0){O.push(u[s]);}if(t>=0){O.push(u[t]);}if(S>=0){O.push(u[S]);}if(a>=0){O.push(u[a]);}return O;};
g.prototype._removeAllRequestHandlers=function(){var r=this.getRequests();var l=r.length;for(var i=0;i<l;i++){g._removeResponse(r[i].response);}};
g.prototype._removeAllFilters=function(){for(var i=0;i<this._aFilters.length;i++){g._removeFilter(this._aFilters[i]);}this._aFilters=null;};
g.prototype._addRequestHandler=function(m,p,r){m=m?m.toUpperCase():m;if(typeof m!=="string"){throw new Error("Error in request configuration: value of 'method' has to be a string");}if(!(typeof p==="string"||p instanceof RegExp)){throw new Error("Error in request configuration: value of 'path' has to be a string or a regular expression");}if(typeof r!=="function"){throw new Error("Error in request configuration: value of 'response' has to be a function");}var u=this._getRootUri();u=u&&new RegExp(this._escapeStringForRegExp(u));if(p&&!(p instanceof RegExp)){p=new RegExp(this._createRegExpPattern(p));}var R=this._createRegExp(u?u.source+p.source:p.source);this._addFilter(this._createFilter(m,R));this._oServer.respondWith(m,R,r);L.debug("MockServer: adding "+m+" request handler for pattern "+R);};
g.prototype._createRegExp=function(p){return new RegExp("^"+p+"$");};
g.prototype._createRegExpPattern=function(p){return p.replace(/:([\w\d]+)/g,"([^\/]+)");};
g.prototype._escapeStringForRegExp=function(s){return s.replace(/[\\\/\[\]\{\}\(\)\-\*\+\?\.\^\$\|]/g,"\\$&");};
g.prototype._trim=function(s){return s&&s.replace(/^\s+|\s+$/g,"");};
g.prototype._isValidNumber=function(s){return!isNaN(parseFloat(s))&&isFinite(s);};
g.prototype._getDateTime=function(s){if(!s){return;}return"datetime'"+new Date(Number(s.replace("/Date(",'').replace(")/",''))).toJSON().substring(0,19)+"'";};
g.prototype._getJsonDate=function(S){if(!S){return;}var n=function(s){var a=q.map(s.slice(0,-5).split(/\D/),function(i){return parseInt(i)||0;});a[1]-=1;a=new Date(Date.UTC.apply(Date,a));var o=s.slice(-5);var b=parseInt(o)/100;if(o.slice(0,1)==="+"){b*=-1;}a.setHours(a.getHours()+b);return a.getTime();};if(S.indexOf("datetimeoffset")>-1){return"/Date("+n(S.substring("datetimeoffset'".length,S.length-1))+")/";}else{return"/Date("+n(S.substring("datetime'".length,S.length-1))+")/";}};
g.prototype._addFilter=function(F){this._aFilters.push(F);g._addFilter(F);};
g.prototype._createFilter=function(r,R){return function(m,u,a,U,p){return r===m&&R.test(u);};};
g.prototype._logAndThrowMockServerCustomError=function(e,E,p){if(E.indexOf('##')>-1&&p){E=E.replace("##","'"+p+"'");}L.error("MockServer: "+E);throw{error:{code:e,message:{lang:"en",value:E}}};};
g.prototype.destroy=function(s){M.prototype.destroy.apply(this,arguments);this.stop();var S=g._aServers;var i=S.indexOf(this);S.splice(i,1);};
g._aFilters=[];g._oServer=null;g._aServers=[];
g._getInstance=function(){if(!this._oServer){this._oServer=window.sinon.fakeServer.create();this._oServer.autoRespond=true;}return this._oServer;};
g.config=function(c){var s=this._getInstance();s.autoRespond=c.autoRespond===false?false:true;s.autoRespondAfter=c.autoRespondAfter||0;s.fakeHTTPMethods=c.fakeHTTPMethods||false;};
g.respond=function(){this._getInstance().respond();};
g.startAll=function(){for(var i=0;i<this._aServers.length;i++){this._aServers[i].start();}};
g.stopAll=function(){for(var i=0;i<this._aServers.length;i++){this._aServers[i].stop();}this._getInstance().restore();this._oServer=null;};
g.destroyAll=function(){this.stopAll();for(var i=0;i<this._aServers.length;i++){this._aServers[i].destroy();}};
g.HTTPMETHOD={GET:"GET",POST:"POST",DELETE:"DELETE",PUT:"PUT",MERGE:"MERGE",PATCH:"PATCH"};
g._addFilter=function(F){this._aFilters.push(F);};
g._removeFilter=function(F){this._aFilters.splice(this._aFilters.indexOf(F),1);};
g._removeResponse=function(r){var R=this._oServer.responses;var l=R.length;for(var i=0;i<l;i++){if(R[i].response===r){R.splice(i,1);return true;}}return false;};
window.sinon.FakeXMLHttpRequest.useFilters=true;window.sinon.FakeXMLHttpRequest.addFilter(function(m,u,a,U,p){var F=g._aFilters;for(var i=0;i<F.length;i++){var b=F[i];if(b(m,u,a,U,p)){return false;}}return true;});var h=function(F){if(/.*\.json$/i.test(F)){return"JSON";}if(/.*\.xml$/i.test(F)){return"XML";}if(/.*metadata$/i.test(F)){return"XML";}return null;};
window.sinon.FakeXMLHttpRequest.prototype.respondFile=function(s,H,F){var r=q.sap.sjax({url:F,dataType:"text"});if(!r.success){throw new Error("Could not load file from: "+F);}var o=r.data;var m=h(F);if(this["respond"+m]){this["respond"+m](s,H,o);}else{this.respond(s,H,o);}};
window.sinon.FakeXMLHttpRequest.prototype.respondJSON=function(s,H,j){H=H||{};H["Content-Type"]=H["Content-Type"]||"application/json";this.respond(s,H,typeof j==="string"?j:JSON.stringify(j));};
window.sinon.FakeXMLHttpRequest.prototype.respondXML=function(s,H,x){H=H||{};H["Content-Type"]=H["Content-Type"]||"application/xml";this.respond(s,H,x);};
return g;});
sap.ui.predefine('sap/ui/core/util/MockServerAnnotationsHandler',['sap/ui/core/util/MockServer','sap/ui/model/odata/ODataModel'],function(M,O){"use strict";return{parse:function(m,s){if(!this._index){this._index=0;}var u="/annotationhandler"+this._index++ +"/";var o=new M({rootUri:u,requests:[{method:"GET",path:new RegExp("\\$metadata"),response:function(x){x.respond(200,{"Content-Type":"application/xml;charset=utf-8"},s);}}]});o.start();var a={annotationURI:[u+"$metadata"],json:true};var b=new O(u,a);var A=b.getServiceAnnotations();o.destroy();return A;}};},true);
sap.ui.predefine('sap/ui/core/util/PasteHelper',["sap/ui/core/Core","sap/ui/model/ParseException","sap/ui/model/ValidateException","sap/base/Log"],function(C,P,V,L){"use strict";var a={};
a.getPastedDataAs2DArray=function(e){var c=e.clipboardData;if(!c){c=window.clipboardData;}var r=/sapui5Placeholder4MultiLine/g;var p=r.source;var b=/""/g;var d,D,R,f=[];if(c){d=c.getData('Text');var g=[];var m=false;var h=d.indexOf("\""),k=-1;var l,n;while(h>-1){n=d.charAt(h-1);if((h===0)||(n==='\n')||(n==='\t')||(n==='\r')){k=d.indexOf("\"",h+1);if(k>-1){l=d.charAt(k+1);while((k>-1)&&(l==='\"')){k=d.indexOf("\"",k+2);l=d.charAt(k+1);}if((l==='\n')||(l==='\t')||(l==='')||(l==='\r')){var M=d.substring(h+1,k);d=d.replace("\""+M+"\"",p);M=M.replace(b,"\"");g.push(M);h=d.indexOf("\"",h+p.length+1);m=true;}}}if(!m){h=d.indexOf("\"",h+1);}m=false;}D=d.split(/\r\n|\r|\n/);var j=0;var G=function(){return g[j++];};for(var i=0;i<D.length;i++){R=D[i];if(g.length>0){R=R.replace(r,G);}if(R.length||i<D.length-1){f.push(R.split("\t"));}}}return f;};
a.parse=function(d,c){var r={parsedData:null,errors:null};if(!d){throw new Error("Parameter aData is not specified");}if(c){for(var i=0;i<c.length;i++){var o=c[i];if(o.ignore){continue;}if(o.property){if(o.type){var t=o.type;if(t.isA&&t.isA("sap.ui.model.SimpleType")){o.typeInstance=t;}else{throw new Error("Data type "+o.type+" is not an instance of any data type");}}else if(o.customParseFunction==undefined){throw new Error("Missing ColumnInfo.type or custom type parse function for column "+(i+1)+". Check the application calling PasteHelper.parse(aData, aColumnInfo) and specify the missing type in the parameter aColumnInfo.");}}else{throw new Error("Missing ColumnInfo.property for column "+(i+1)+". Check the application calling PasteHelper.parse(aData, aColumnInfo) and specify the missing property in the parameter aColumnInfo.");}}}else{throw new Error("Missing parameter aColumnInfo");}var e=[],R=[],b=C.getLibraryResourceBundle();var p=function(g,t){return t.parseValue(g,"string");};var v=function(g,t){return t.validateValue(g);};for(var i=0;i<d.length;i++){var f=d[i];var s=a._parseRow(f,c,i,p,v,b,e);R.push(s);}return Promise.all(R).then(function(g){if(e.length>0){r.parsedData=null;r.errors=e;}else{if(g){r.parsedData=g;}r.errors=null;}return r;});};
a._parseRow=function(r,c,R,p,v,b,e){var d=[],o={};for(var i=0;(i<c.length)&&(i<r.length);i++){var f=c[i];if(f.ignore){continue;}var s=r[i];if(!f.typeInstance){p=f.customParseFunction;v=function(){};}var S=a._parseCell(i,s,f,R,p,v,b,o,e);d.push(S);}return Promise.all(d).then(function(){return o;});};
a._parseCell=function(i,c,o,r,p,v,b,O,e){return Promise.resolve(c).then(function(d){return p(d,o.typeInstance);}).then(function(d){return Promise.all([d,v(d,o.typeInstance)]);}).then(function(R){O[o.property]=R[0];}).catch(function(E){if(E instanceof P||E instanceof V){var d={row:r+1,column:i+1,property:o.property,value:c,type:o.type,message:b.getText("PasteHelper.ErrorMessage",[c,r+1,i+1])+" "+E.message+"\n"};e.push(d);c=null;}else{L.error(E);}});};
return a;});
sap.ui.predefine('sap/ui/core/util/ResponsivePaddingsEnablement',["sap/ui/core/library","sap/base/Log",'sap/ui/core/ResizeHandler',"sap/ui/thirdparty/jquery"],function(l,L,R,q){"use strict";var B={S:599,M:1023,L:1439};var M={S:"sapUi-Std-PaddingS",M:"sapUi-Std-PaddingM",L:"sapUi-Std-PaddingL",XL:"sapUi-Std-PaddingXL"};var a=function(s){if(!this.isA||!this.isA("sap.ui.core.Control")){L.error("Responsive Paddings enablement could be applied over controls only");return;}this._initResponsivePaddingsEnablement=function(){this.addEventDelegate({onAfterRendering:b,onBeforeRendering:o},this);};function o(){c(this);}function b(){var S=e(this,s);if(S.length){window.requestAnimationFrame(function(){_(this);}.bind(this));}}function _(C){d(C);if(!C.__iResponsivePaddingsResizeHandlerId__){C.__iResponsivePaddingsResizeHandlerId__=R.register(C,d.bind(C,C));}}function c(C){if(C.__iResponsivePaddingsResizeHandlerId__){R.deregister(C.__iResponsivePaddingsResizeHandlerId__);C.__iResponsivePaddingsResizeHandlerId__=null;}}function d(C,E){var r=e(C,s);var $=f(C,r);var w=E?E.size.width:C.$().width();g($);h($,w);}function e(C,s){var S=i(s);S=S.filter(function(j){return C.hasStyleClass(j);});if(!S.length){return[];}S=S.map(function(j){return j.split("--")[1];});S=S.map(function(A){return s[A];}).filter(function(j){return j;});return S;}function f(C,S){var $=q();S.forEach(function(j){if(j.suffix){$=$.add(C.$(j.suffix));}if(j.selector){$=$.add(C.$().find(j.selector).first());}});return $;}function g($){var C=Object.keys(M).map(function(k){return M[k];});$.each(function(j,k){var m=q(k).control(0);if(k===m.getDomRef()){C.forEach(m.removeStyleClass.bind(m));}else{q(k).removeClass(C.join(" "));}});}function h($,w){var k;switch(true){case w<=B.S:k="S";break;case w<=B.M&&w>B.S:k="M";break;case w<=B.L&&w>B.M:k="L";break;default:k="XL";break;}$.each(function(j,m){var C=q(m).control(0);if(m===C.getDomRef()){C.addStyleClass(M[k]);}else{q(m).addClass(M[k]);}});}function i(s){return Object.keys(s).map(function(k){return"sapUiResponsivePadding--"+k;});}};return a;});
sap.ui.predefine('sap/ui/core/util/ShortcutHelper',['sap/ui/Device','sap/ui/events/jquery/EventExtension'],function(D){"use strict";var k={plus:"+",space:" "};var d=1.1;var s=d.toLocaleString().substring(1,2);var E={Win:"Meta",Scroll:"ScrollLock",Spacebar:" ",Down:"ArrowDown",Left:"ArrowLeft",Right:"ArrowRight",Up:"ArrowUp",Del:"Delete",Apps:"ContextMenu",Esc:"Escape",Multiply:"*",Decimal:s,OS:"Meta"};var m={"ctrl+l":"jump to address bar","ctrl+n":"new window, cannot be registered in Chrome","ctrl+shift+n":"new incognito window, cannot be registered in Chrome","ctrl+alt+shift+p":"UI5 Technical Info","ctrl+q":"quit Chrome in Mac","ctrl+alt+shift+s":"UI5 Support Popup","ctrl+t":"new tab, cannot be registered in Chrome","ctrl+shift+t":"reopen last tab, cannot be registered in Chrome","ctrl+w":"close tab, cannot be registered in Chrome","ctrl+shift+w":"close window, cannot be registered in Chrome","ctrl+0":"reset zoom","ctrl+-":"zoom out","ctrl++":"zoom in","ctrl+shift+=":"cannot be handled","tab":"TAB-based keyboard navigation","shift+tab":"TAB-based keyboard navigation","ctrl+tab":"cycling through tabs, cannot be registered in Chrome","ctrl+shift+tab":"cycling through tabs, cannot be registered in Chrome","ctrl+alt+delete":"nice try","ctrl+pageup":"cycling through tabs, cannot be registered in Chrome","ctrl+pagedown":"cycling through tabs, cannot be registered in Chrome","ctrl+alt+left":"cannot be handled in IE","ctrl+alt+right":"cannot be handled in IE","ctrl+f1":"always opens help menu in IE","ctrl+f4":"always closes tab in IE","f6":"F6-based group navigation","f11":"fullscreen, cannot be registered in Chrome","f12":"browser dev tools"};var l=false;document.addEventListener('keydown',function(e){try{if(e.keyCode===18){l=(typeof e.location!=="number"||e.location===1);return;}}catch(a){}});var S={findShortcut:function(o,n){var r=o.data("sap.ui.core.Shortcut");if(!r){return;}var M=r.filter(function(a){var b=a.shortcutSpec.key===n.key&&a.shortcutSpec.ctrlKey===n.ctrlKey&&a.shortcutSpec.altKey===n.altKey&&a.shortcutSpec.shiftKey===n.shiftKey&&a.shortcutSpec.metaKey===n.metaKey;return b;});return M[0];},getNormalizedShortcutSpec:function(v){var n;if(typeof v==="string"){n=S.parseShortcut(v);}else{var a=v.key;var V=/^([a-z0-9\.,\-\*\/= +]|Tab|Enter|Backspace|Home|Delete|End|Pageup|Pagedown|ArrowUp|ArrowDown|ArrowLeft|ArrowRight|Escape|F[1-9]|F1[0-2])$/i.test(a);if(!V){throw new Error("Shortcut key '"+a+"' is not a valid shortcut key. It must match /^([a-z0-9\.,\-\*\/= +]|Tab|Enter|Backspace|Home|Delete|End|Pageup|Pagedown|ArrowUp|ArrowDown|ArrowLeft|ArrowRight|Escape|F[1-9]|F1[0-2])$/i");}n={key:S.translateRegisteredKeyToStandard(a).toLowerCase(),ctrlKey:D.os.macintosh?false:!!v.ctrl,ctrlRequested:v.ctrl,altKey:!!v.alt,shiftKey:!!v.shift,metaKey:D.os.macintosh?!!v.ctrl:false};}return n;},parseShortcut:function(a){this.validateShortcutString(a);var p=a.toLowerCase().split("+");return{key:S.translateRegisteredKeyToStandard(p.pop()),ctrlKey:D.os.macintosh?false:p.indexOf("ctrl")>-1,ctrlRequested:p.indexOf("ctrl")>-1,altKey:p.indexOf("alt")>-1,shiftKey:p.indexOf("shift")>-1,metaKey:D.os.macintosh?p.indexOf("ctrl")>-1:false};},translateRegisteredKeyToStandard:function(K){return k.hasOwnProperty(K)?k[K]:K;},validateShortcutString:function(a){var v=/^((Ctrl|Shift|Alt)\+){0,3}([a-z0-9\.,\-\*\/=]|Plus|Tab|Space|Enter|Backspace|Home|Delete|End|Pageup|Pagedown|Escape|ArrowUp|ArrowDown|ArrowLeft|ArrowRight|F[1-9]|F1[0-2])$/i.test(a);if(!v){throw new Error("Shortcut '"+a+"' is not a valid shortcut string. It must be a '+'-separated list of modifier keys and the actual key, like 'Ctrl+Alt+S'. Or more generally, it must match the expression /^((Ctrl|Shift|Alt)\+){0,3}([a-z0-9\.,\-\*\/=]|Plus|Tab|Space|Enter|Backspace|Home|Delete|End|Pageup|Pagedown|ArrowUp|ArrowDown|ArrowLeft|ArrowRight|Escape|F[1-9]|F1[0-2])$/i.");}},validateKeyCombination:function(n){var N=n.ctrlRequested?"ctrl+":"";N+=n.altKey?"alt+":"";N+=n.shiftKey?"shift+":"";N+=n.key;if(m[N]){throw new Error("Registering the shortcut '"+N+"' is not allowed ("+m[N]+").");}if([".",",","-","+","=","*","/"].indexOf(n.key)>-1&&N.indexOf("shift")>-1){throw new Error("Registering the shortcut '"+N+"' is not allowed because the 'Shift' modifier changes the meaning of the "+n.key+" key on many keyboards.");}},getNormalizedShortcutString:function(n){var N=n.ctrlRequested?"ctrl+":"";N+=n.altKey?"alt+":"";N+=n.shiftKey?"shift+":"";N+=n.key;return N;},shortcutMayBeUsedHere:function(o,a){var t=a.tagName.toLowerCase();if((t==="input"||t==="textarea")&&o.key.includes("arrow")){return false;}return true;},handleKeydown:function(o,O,c,e){if(e.key==="Control"||e.key==="Shift"||e.key==="Alt"||e.key==="AltGraph"||e.key==="Meta"){return;}if(e.isMarked()){return;}if(e.altKey&&!l){return;}var a=E.hasOwnProperty(e.key)?E[e.key]:e.key;a=a.toLowerCase();if(a!==o.key||e.ctrlKey!==o.ctrlKey||e.altKey!==o.altKey||e.shiftKey!==o.shiftKey||e.metaKey!==o.metaKey){return;}if(!S.shortcutMayBeUsedHere(o,e.target||e.srcElement)){return;}e.preventDefault();e.setMarked();e.stopPropagation();var b={registeredShortcut:O,originalBrowserEvent:e.originalEvent||e};c(b);}};return S;});
sap.ui.predefine('sap/ui/core/util/XMLPreprocessor',["sap/base/Log","sap/base/util/deepExtend","sap/base/util/JSTokenizer","sap/base/util/ObjectPath","sap/ui/base/BindingParser","sap/ui/base/ManagedObject","sap/ui/base/SyncPromise","sap/ui/core/XMLTemplateProcessor","sap/ui/model/BindingMode","sap/ui/model/CompositeBinding","sap/ui/model/Context","sap/ui/performance/Measurement"],function(L,d,J,O,B,M,S,X,a,C,b,c){"use strict";var N="http://schemas.sap.com/sapui5/extension/sap.ui.core.template/1",x="sap.ui.core.util.XMLPreprocessor",p=[x],P=x+"/getResolvedBinding",s=x+"/insertFragment",f=x+".process",o=S.resolve(),g=S.resolve(true),t=Object.prototype.toString,v={},W=M.extend("sap.ui.core.util._with",{metadata:{library:"sap.ui.core",properties:{any:"any"},aggregations:{child:{multiple:false,type:"sap.ui.core.util._with"}}},updateProperty:function(){this.setAny(this.mBindingInfos.any.binding.getExternalValue());}}),R=W.extend("sap.ui.core.util._repeat",{metadata:{library:"sap.ui.core",aggregations:{list:{multiple:true,type:"n/a",_doesNotRequireFactory:true}}},updateList:function(){}});
function h(w,e,i,n){function q(u){if(!n){n=w.getBinding("any");if(n instanceof C){n=n.getBindings();if(i!==undefined){n=n[i];}}}return Array.isArray(n)?n[u]:n;}function r(u){return u instanceof b?u.getPath():u.getModel().resolve(u.getPath(),u.getContext());}return{getInterface:function(u,y){var z,A,D;if(typeof u==="string"){y=u;u=undefined;}q();if(Array.isArray(n)){if(u>=0&&u<n.length){A=n[u];}else{throw new Error("Invalid index of part: "+u);}}else if(u!==undefined){throw new Error("Not the root formatter of a composite binding");}else if(y){A=n;}else{throw new Error("Missing path");}if(y){D=A.getModel();if(y.charAt(0)!=='/'){z=A instanceof b?A:D.createBindingContext(A.getPath(),A.getContext());}A=D.createBindingContext(y,z);if(!A){throw new Error("Model could not create binding context synchronously: "+D);}}return h(null,e,undefined,A);},getModel:function(u){var y=q(u);return y&&y.getModel();},getPath:function(u){var y=q(u);return y&&r(y);},getSetting:function(u){if(u==="bindingContexts"||u==="models"){throw new Error("Illegal argument: "+u);}return e[u];}};}
function j(w,n,q,r,A){var V=false;function u(I,i){var F=I.formatter,y,z=I.model;if(I.path&&I.path.indexOf(">")>0){z=I.path.slice(0,I.path.indexOf(">"));}y=w.getModel(z);if(F&&F.requiresIContext===true){F=I.formatter=F.bind(null,h(w,q,i));}if(F&&A&&(y&&y.$$valueAsPromise||i===undefined&&V)){I.formatter=function(){var D=this;return S.all(arguments).then(function(E){return F.apply(D,E);});};I.formatter.textFragments=F.textFragments;}I.mode=a.OneTime;I.parameters=I.parameters||{};I.parameters.scope=r;if(A&&y&&y.$$valueAsPromise){V=I.parameters.$$valueAsPromise=true;}}try{if(n.parts){n.parts.forEach(u);}u(n);w.bindProperty("any",n);return w.getBinding("any")?S.resolve(w.getAny()):null;}catch(e){return S.reject(e);}finally{w.unbindProperty("any",true);}}
function k(e,n){var i=-1;function q(F){if(F){return e[i];}i+=1;if(i<e.length){return n(e[i],i,e).then(q);}}return e.length?q():o;}
function l(e){var A,q=e.attributes,T="<"+e.nodeName,i,n;for(i=0,n=q.length;i<n;i+=1){A=q.item(i);T+=" "+A.name+'="'+A.value+'"';}return T+(e.childNodes.length?">":"/>");}
function m(e,i){return i.visitNode(e);}
return{plugIn:function(V,n,e){var i=v[n];if(V!==null&&typeof V!=="function"||V===m){throw new Error("Invalid visitor: "+V);}if(!n||n===N||n==="sap.ui.core"||n.indexOf(" ")>=0){throw new Error("Invalid namespace: "+n);}L.debug("Plug-in visitor for namespace '"+n+"', local name '"+e+"'",V,x);if(e){n=n+" "+e;i=v[n]||i;}v[n]=V;return i||m;},visitNodeWrapper:m,process:function(r,V,q){var u=V.caller,D=L.isLoggable(L.Level.DEBUG,x),w=D,y=V.name,F={},z,A=0,E={},G=V._supportInfo,H=L.isLoggable(L.Level.WARNING,x);function I(i){return{find:function(n,p1){try{return S.resolve(k(n,p1));}catch(e){return S.reject(e);}},getContext:function(e){var n,p1,q1;e=e||"";if(e[0]==="{"){throw new Error("Must be a simple path, not a binding: "+e);}n=B.simpleParser("{"+e+"}");p1=i.getModel(n.model);if(!p1){throw new Error("Unknown model '"+n.model+"': "+e);}q1=p1.resolve(n.path,i.getBindingContext(n.model));if(!q1){throw new Error("Cannot resolve path: "+e);}return p1.createBindingContext(q1);},getResult:function(e,n){return $(e,n,i,true);},getSettings:function(){return q;},getViewInfo:function(){return d({},V);},insertFragment:function(e,n){return _(e,n,i);},visitAttribute:function(e,n){return k1(e,n,i);},visitAttributes:function(e){return l1(e,i);},visitChildNodes:function(n){return m1(n,i);},visitNode:function(n){try{return n1(n,i);}catch(e){return S.reject(e);}},"with":function(e,n){var p1,q1=false,z,r1=new W();if(!n){i.setChild(r1);}for(z in e){p1=e[z];q1=true;r1.setModel(p1.getModel(),z);r1.bindObject({model:z,path:p1.getPath()});}return q1||n?I(r1):this;}};}function K(e){if(D){L.debug(Y()+Array.prototype.slice.call(arguments,1).join(" "),e&&l(e),x);}}function Q(e){if(D){L.debug(Y()+"Finished","</"+e.nodeName+">",x);}}function T(e,i){e=e+l(i);L.error(e,u,x);throw new Error(u+": "+e);}function U(e){var p1,q1=Array.prototype.filter.call(e.childNodes,s1),i,n,r1=false;function s1(u1){return u1.nodeType===1;}function t1(u1,v1){return u1.namespaceURI===N&&u1.localName===v1;}if(!q1.length||!t1(q1[0],"then")){return null;}for(i=1,n=q1.length;i<n;i+=1){p1=q1[i];if(r1){T("Expected </"+e.prefix+":if>, but instead saw ",p1);}if(t1(p1,"else")){r1=true;}else if(!t1(p1,"elseif")){T("Expected <"+e.prefix+":elseif> or <"+e.prefix+":else>, but instead saw ",q1[i]);}}return q1;}function Y(){return(A<10?"[ ":"[")+A+"] ";}function Z(z){return z&&z.charAt(0)==="."?O.get(z.slice(1),E):O.get(z||"",E)||O.get(z||"");}function $(i,n,p1,q1,r1){var s1,t1;c.average(P,"",p);try{s1=B.complexParser(i,E,q1,true,true,true)||i;}catch(e){return S.reject(e);}if(s1.functionsNotFound){if(q1){o1(n,'Function name(s)',s1.functionsNotFound.join(", "),'not found');}c.end(P);return null;}if(typeof s1==="object"){t1=j(p1,s1,q,E,!V.sync);if(q1&&!t1){o1(n,'Binding not ready');}else if(V.sync&&t1&&t1.isPending()){T("Async formatter in sync view in "+i+" of ",n);}}else{t1=S.resolve(s1);if(r1){r1();}}c.end(P);return t1;}function _(e,i,n){var p1,q1=V.sync?X.loadTemplate:X.loadTemplatePromise,r1=y;n.$mFragmentContexts=n.$mFragmentContexts||{};if(n.$mFragmentContexts[e]){T("Cyclic reference to fragment '"+e+"' ",i);}A++;K(i,"fragmentName =",e);n.$mFragmentContexts[e]=true;y=e;c.average(s,"",p);p1=F[e];if(!p1){F[e]=p1=S.resolve(q1(e,"fragment"));}return p1.then(function(s1){s1=i.ownerDocument.importNode(s1,true);c.end(s);return c1(s1).then(function(){if(s1.namespaceURI==="sap.ui.core"&&s1.localName==="FragmentDefinition"){return a1(s1,n,i);}i.parentNode.insertBefore(s1,i);return n1(s1,n);});}).then(function(){i.parentNode.removeChild(i);y=r1;n.$mFragmentContexts[e]=false;Q(i);A-=1;});}function a1(e,i,n){return m1(e,i).then(function(){var p1;n=n||e;while((p1=e.firstChild)){n.parentNode.insertBefore(p1,n);}});}function b1(e,i){var n=o1.bind(null,e,'Constant test condition'),p1=$(e.getAttribute("test"),e,i,true,n)||S.resolve(false);return p1.catch(function(ex){o1(e,'Error in formatter:',ex);}).then(function(q1){var r1=!!q1&&q1!=="false";if(D){if(typeof q1==="string"){q1=JSON.stringify(q1);}else if(q1===undefined){q1="undefined";}else if(Array.isArray(q1)){q1="[object Array]";}K(e,"test ==",q1,"-->",r1);}return r1;});}function c1(e){var n={},p1=e.getAttributeNodeNS(N,"require"),q1,r1;function s1(){return new S(function(i,t1){var u1=r1.map(sap.ui.require);if(u1.every(Boolean)){i(u1);}else{sap.ui.require(r1,function(){i(arguments);},t1);}}).then(function(t1){Object.keys(n).forEach(function(u1,i){E[u1]=t1[i];});});}if(p1&&p1.value){q1=p1.value;e.removeAttributeNode(p1);if(q1[0]==="{"){n=J.parseJS(q1);r1=Object.keys(n).map(function(i){return n[i];});return s1();}r1=q1.split(" ").map(function(i){return i.replace(/\./g,"/");});if(!V.sync){return s1();}r1.forEach(sap.ui.requireSync);}return o;}function d1(e,i,n){var p1=$(i.value,e,n,false);if(!p1){K(e,'Binding not ready for attribute',i.name);return o;}return p1.then(function(q1){if(q1===undefined){K(e,"Removed attribute",i.name);e.removeAttributeNode(i);}else if(q1!==i.value){switch(typeof q1){case"boolean":case"number":case"string":K(e,i.name,"=",q1);i.value=q1;break;default:K(e,"Ignoring",t.call(q1),"value for attribute",i.name);}}},function(q1){K(e,"Error in formatter of attribute",i.name,q1);});}function e1(e,i){var z=e.getAttribute("name"),n,p1,q1=e.getAttribute("value");if(z&&z[0]==="."){z=z.slice(1);}if(!z||z.includes(".")){T("Missing proper relative name in ",e);}n=Z(q1);if(!n){T("Invalid value in ",e);}p1=E[z];E[z]=n;return a1(e,i).then(function(){e.parentNode.removeChild(e);E[z]=p1;});}function f1(e,i){var n=e.getAttribute("name"),p1=$(n,e,i,true);if(!p1){return g;}return p1.then(function(z){var q1=sap.ui.require("sap/ui/core/CustomizingConfiguration"),r1;if(z!==n){K(e,"name =",z);}if(q1){r1=q1.getViewExtension(y,z,V.componentId);if(r1&&r1.className==="sap.ui.core.Fragment"&&r1.type==="XML"){return _(r1.fragmentName,e,i);}}return true;},function(ex){o1(e,'Error in formatter:',ex);return true;});}function g1(e,i){var n=e.getAttribute("fragmentName"),p1=$(n,e,i,true);if(!p1){return o;}return p1.then(function(n){var q1=E;E=Object.create(E);return _(n,e,i).then(function(){E=q1;});},function(ex){o1(e,'Error in formatter:',ex);});}function h1(i,e){A++;return k(U(i)||[i],function(n){if(n.localName==="else"){return g;}if(n.localName==="then"){n=i;}return b1(n,e);}).then(function(n){return(n?a1(n,e,i):o).then(function(){i.parentNode.removeChild(i);Q(i);A-=1;});});}function i1(e,n){var p1=e.getAttribute("list")||"",q1=B.complexParser(p1,E,false,true,true,true),r1,s1,t1,u1,v1,w1=e.getAttribute("var");if(w1===""){T("Missing variable name for ",e);}if(!q1){T("Missing binding for ",e);}if(q1.functionsNotFound){o1(e,'Function name(s)',q1.functionsNotFound.join(", "),'not found');}u1=new R();n.setChild(u1);q1.mode=a.OneTime;u1.bindAggregation("list",q1);s1=u1.getBinding("list");u1.unbindAggregation("list",true);t1=q1.model;if(!s1){T("Missing model '"+t1+"' in ",e);}s1.enableExtendedChangeDetection();r1=s1.getContexts(q1.startIndex,q1.length||Infinity);if(!V.sync&&r1.dataRequested){v1=new S(function(i){s1.attachEventOnce("change",i);}).then(function(){return s1.getContexts(q1.startIndex,q1.length);});}else{v1=S.resolve(r1);}w1=w1||t1;u1.setModel(s1.getModel(),w1);A++;K(e,"Starting");return v1.then(function(r1){return k(r1,function(x1,i){var y1=(i===r1.length-1)?e:e.cloneNode(true);u1.setBindingContext(x1,w1);K(e,w1,"=",x1.getPath());return a1(y1,u1,e);}).then(function(){Q(e);A-=1;e.parentNode.removeChild(e);});});}function j1(e,i){var n,p1,q1,r1,s1=e.getAttribute("helper"),t1,u1=e.getAttribute("path"),v1,w1,x1=e.getAttribute("var");if(x1===""){T("Missing variable name for ",e);}q1=new W();i.setChild(q1);n=B.simpleParser("{"+u1+"}");x1=x1||n.model;if(s1||x1){p1=i.getModel(n.model);if(!p1){T("Missing model '"+n.model+"' in ",e);}w1=p1.resolve(n.path,i.getBindingContext(n.model));if(!w1){T("Cannot resolve path for ",e);}t1=p1.createBindingContext(w1);if(s1){r1=Z(s1);if(typeof r1!=="function"){T("Cannot resolve helper for ",e);}t1=r1(t1);}v1=S.resolve(t1);if(V.sync&&v1.isPending()){T("Async helper in sync view in ",e);}v1=v1.then(function(t1){if(t1 instanceof b){p1=t1.getModel();w1=t1.getPath();}else if(t1!==undefined){if(typeof t1!=="string"||t1===""){T("Illegal helper result '"+t1+"' in ",e);}w1=t1;}q1.setModel(p1,x1);q1.bindObject({model:x1,path:w1});});}else{w1=u1;q1.bindObject(w1);v1=o;}return v1.then(function(){A++;K(e,x1,"=",w1);if(q1.getBindingContext(x1)===i.getBindingContext(x1)){o1(e,'Set unchanged path:',w1);q1=i;}return a1(e,q1).then(function(){e.parentNode.removeChild(e);Q(e);A-=1;});});}function k1(e,i,n){if(G){G({context:undefined,env:{caller:"visitAttribute",before:{name:i.name,value:i.value}}});}return d1(e,i,n).then(function(){if(G){G({context:undefined,env:{caller:"visitAttribute",after:{name:i.name,value:i.value}}});}});}function l1(e,i){function n(p1,q1){return p1.name.localeCompare(q1.name);}return k(Array.prototype.slice.apply(e.attributes).sort(n),function(p1){return k1(e,p1,i);});}function m1(n,e){return k(Array.prototype.slice.apply(n.childNodes),function(i){return n1(i,e);});}function n1(n,e){var i;function p1(){return l1(n,e).then(function(){return m1(n,e);}).then(function(){if(G){G({context:n,env:{caller:"visitNode",after:{name:n.tagName}}});}});}if(n.nodeType!==1){return o;}if(G){G({context:n,env:{caller:"visitNode",before:{name:n.tagName}}});}if(n.namespaceURI===N){switch(n.localName){case"alias":return e1(n,e);case"if":return h1(n,e);case"repeat":return i1(n,e);case"with":return j1(n,e);default:T("Unexpected tag ",n);}}else if(n.namespaceURI==="sap.ui.core"){switch(n.localName){case"ExtensionPoint":return f1(n,e).then(function(q1){if(q1){return p1();}});case"Fragment":if(n.getAttribute("type")==="XML"){return g1(n,e);}break;}}else{i=v[n.namespaceURI+" "+n.localName]||v[n.namespaceURI];if(i){A++;K(n,"Calling visitor");return i(n,I(e)).then(function(q1){if(q1!==undefined){T("Unexpected return value from visitor for ",n);}Q(n);A-=1;});}}return p1();}function o1(e){if(H){if(!w){w=true;L.warning("Warning(s) during processing of "+u,null,x);}L.warning(Y()+Array.prototype.slice.call(arguments,1).join(" "),e&&l(e),x);}}c.average(f,"",p);q=q||{};if(D){K(undefined,"Start processing",u);if(q.bindingContexts instanceof b){K(undefined,"undefined =",q.bindingContexts);}else{for(z in q.bindingContexts){K(undefined,z,"=",q.bindingContexts[z]);}}}if(G){G({context:r,env:{caller:"view",viewinfo:d({},V),settings:d({},q),clone:r.cloneNode(true),type:"template"}});}return c1(r).then(function(){return n1(r,new W({models:q.models,bindingContexts:q.bindingContexts}));}).then(function(){K(undefined,"Finished processing",u);c.end(f);return r;}).unwrap();}};},true);
sap.ui.predefine('sap/ui/core/util/reflection/BaseTreeModifier',["sap/ui/base/ManagedObject","sap/ui/base/ManagedObjectMetadata","sap/base/util/ObjectPath","sap/ui/util/XMLHelper","sap/ui/core/XMLTemplateProcessor","sap/ui/core/util/XMLPreprocessor","sap/base/util/isPlainObject","sap/base/Log"],function(M,a,O,X,b,c,d,L){"use strict";return{bySelector:function(s,A,v){var C;if(s&&s.name){v=v||this.bySelector(s.viewSelector,A);var e=this.getExtensionPointInfo(s.name,v);return e?e.parent:undefined;}C=this.getControlIdBySelector(s,A);return this._byId(C,v);},getControlIdBySelector:function(s,A){if(!s){return undefined;}if(typeof s==="string"){s={id:s};}var C=s.id;if(s.idIsLocal){if(A){C=A.createId(C);}else{throw new Error("App Component instance needed to get a control's ID from selector");}}return C;},getSelector:function(C,A,m){var s=C;if(typeof s!=="string"){s=(C)?this.getId(C):undefined;}else if(!A){throw new Error("App Component instance needed to get a selector from string ID");}if(m&&(m.id||m.idIsLocal)){throw new Error("A selector of control with the ID '"+s+"' was requested, "+"but core properties were overwritten by the additionally passed information.");}var v=this.checkControlId(s,A);if(!v){throw new Error("Generated ID attribute found - to offer flexibility a stable control ID is needed to assign the changes to, but for this control the ID was generated by SAPUI5 "+s);}var S=Object.assign({},m,{id:"",idIsLocal:false});if(this.hasLocalIdSuffix(s,A)){var l=A.getLocalId(s);S.id=l;S.idIsLocal=true;}else{S.id=s;}return S;},checkControlId:function(C,A){var s=C instanceof M?C.getId():C;var i=a.isGeneratedId(s);return!i||this.hasLocalIdSuffix(C,A);},hasLocalIdSuffix:function(C,A){var s=(C instanceof M)?C.getId():C;if(!A){L.error("Determination of a local ID suffix failed due to missing app component for "+s);return false;}return!!A.getLocalId(s);},_checkAndPrefixIdsInFragment:function(f,I){var p=X.getParseError(f);if(p.errorCode!==0){throw new Error(f.parseError.reason);}var C=f.documentElement;var r=[],e=[];if(C.localName==="FragmentDefinition"){r=this._getElementNodeChildren(C);}else{r=[C];}e=[].concat(r);function o(g){e.push(g);}for(var i=0,n=r.length;i<n;i++){this._traverseXmlTree(o,r[i]);}for(var j=0,m=e.length;j<m;j++){if(e[j].getAttribute("id")){e[j].setAttribute("id",I+"."+e[j].getAttribute("id"));}else{throw new Error("At least one control does not have a stable ID");}}return C;},_getElementNodeChildren:function(N){var C=[];var e=N.childNodes;for(var i=0,n=e.length;i<n;i++){if(e[i].nodeType===1){C.push(e[i]);}}return C;},_isInstanceOf:function(e,t){var i=O.get(t);if(typeof i==="function"){return e instanceof i;}else{return false;}},_hasInterface:function(e,i){var I=e.getMetadata().getInterfaces();return I.indexOf(i)!==-1;},_getControlMetadataInXml:function(C){var s=this._getControlTypeInXml(C);jQuery.sap.require(s);var e=O.get(s);return e.getMetadata();},getControlMetadata:function(C){},getLibraryName:function(C){var m=this.getControlMetadata(C);return m.getLibraryName();},_getControlTypeInXml:function(C){var s=C.namespaceURI;s=s?s+".":"";s+=C.localName;return s;},_traverseXmlTree:function(C,r){function e(p,o,i){var A;if(!i){var m=this._getControlMetadataInXml(o);A=m.getAllAggregations();}var f=this._getElementNodeChildren(o);f.forEach(function(g){var I=A&&A[g.localName];e.call(this,o,g,I);if(!I){C(g);}}.bind(this));}e.call(this,r,r,false);},_getSerializedValue:function(p){if(this._isSerializable(p)&&typeof p!=="string"){return JSON.stringify(p);}return p;},_isSerializable:function(p){return d(p)||Array.isArray(p)||Object(p)!==p;},_escapeCurlyBracketsInString:function(p){return typeof p==="string"?p.replace(/({|})/g,"\\$&"):p;},_templateFragment:function(f,p){return Promise.resolve(c.process(b.loadTemplate(f,"fragment"),{name:f},p));},getPropertyBindingOrProperty:function(C,p){return this.getPropertyBinding(C,p)||this.getProperty(C,p);},setPropertyBindingOrProperty:function(C,p,B){var i=B&&(B.path||B.parts);var I=B&&typeof B==="string"&&B.substring(0,1)==="{"&&B.slice(-1)==="}";var o=i||I?"setPropertyBinding":"setProperty";this[o](C,p,B);},setVisible:function(C,v){},getVisible:function(C){},setStashed:function(C,s){},getStashed:function(C){},bindProperty:function(C,p,B){},unbindProperty:function(C,p){},bindAggregation:function(C,A,B){},unbindAggregation:function(C,A){},setProperty:function(C,p,P){},getProperty:function(C,p){},isPropertyInitial:function(C,p){},setPropertyBinding:function(C,p,P){},getPropertyBinding:function(C,p){},createAndAddCustomData:function(C,s,v,A){},createControl:function(C,A,v,s,S,e){},applySettings:function(C,s){},_byId:function(i,v){},getId:function(C){},getParent:function(C){},getControlType:function(C){},setAssociation:function(p,n,i){},getAssociation:function(p,n){},getAllAggregations:function(C){},getAggregation:function(p,n){},insertAggregation:function(p,A,o,i,v){},removeAggregation:function(p,A,o){},removeAllAggregation:function(p,A){},getBindingTemplate:function(C,A){},updateAggregation:function(p,A){},findIndexInParentAggregation:function(C){},getParentAggregationName:function(C,p){},validateType:function(C,A,p,f,i){},instantiateFragment:function(f,n,v){},templateControlFragment:function(f,p,v){},destroy:function(C){},getChangeHandlerModulePath:function(C){return this._getFlexCustomData(C,"flexibility");},_getFlexCustomData:function(C){},getFlexDelegate:function(C){var D;var s=this._getFlexCustomData(C,"delegate");if(typeof s==="string"){try{D=JSON.parse(s);if(D.payload===undefined){D.payload={};}}catch(e){L.error("Flex Delegate for control "+this.getId(C)+" is malformed",e.message);}}return D;},attachEvent:function(o,e,f,D){},detachEvent:function(o,e,f){},getExtensionPointInfo:function(e,v){}};});
sap.ui.predefine('sap/ui/core/util/reflection/JsControlTreeModifier',["sap/ui/base/BindingParser","./BaseTreeModifier","./XmlTreeModifier","sap/base/util/ObjectPath","sap/ui/util/XMLHelper","sap/base/util/merge","sap/ui/core/Fragment"],function(B,a,X,O,b,m,F){"use strict";var J={targets:"jsControlTree",setVisible:function(c,v){if(c.setVisible){this.unbindProperty(c,"visible");c.setVisible(v);}else{throw new Error("Provided control instance has no setVisible method");}},getVisible:function(c){if(c.getVisible){return c.getVisible();}else{throw new Error("Provided control instance has no getVisible method");}},setStashed:function(c,s){s=!!s;if(c.unstash){if(c.isStashed()===true&&s===false){c=c.unstash();}if(c.setVisible){this.setVisible(c,!s);}return c;}else{throw new Error("Provided control instance has no unstash method");}},getStashed:function(c){if(c.isStashed){return c.isStashed()?c.isStashed():!this.getVisible(c);}throw new Error("Provided control instance has no isStashed method");},bindProperty:function(c,p,v){c.bindProperty(p,v);},unbindProperty:function(c,p){if(c){c.unbindProperty(p,true);}},setProperty:function(c,p,P){var M=c.getMetadata().getPropertyLikeSetting(p);var o;var e;this.unbindProperty(c,p);try{o=B.complexParser(P,undefined,true);}catch(d){e=true;}if(M){if(this._isSerializable(P)){if(o&&typeof o==="object"||e){P=this._escapeCurlyBracketsInString(P);}var s=M._sMutator;c[s](P);}else{throw new TypeError("Value cannot be stringified","sap.ui.core.util.reflection.JsControlTreeModifier");}}},getProperty:function(c,p){var M=c.getMetadata().getPropertyLikeSetting(p);if(M){var P=M._sGetter;return c[P]();}},isPropertyInitial:function(c,p){return c.isPropertyInitial(p);},setPropertyBinding:function(c,p,P){this.unbindProperty(c,p);var s={};s[p]=P;c.applySettings(s);},getPropertyBinding:function(c,p){return c.getBindingInfo(p);},createAndAddCustomData:function(c,C,v,A){var o=this.createControl("sap.ui.core.CustomData",A);this.setProperty(o,"key",C);this.setProperty(o,"value",v);this.insertAggregation(c,"customData",o,0);},createControl:function(c,A,v,s,S,d){var e;if(this.bySelector(s,A)){e="Can't create a control with duplicated ID "+(s.id||s);if(d){return Promise.reject(e);}throw new Error(e);}if(d){return new Promise(function(r,R){sap.ui.require([c.replace(/\./g,"/")],function(C){var i=this.getControlIdBySelector(s,A);r(new C(i,S));}.bind(this),function(){R(new Error("Required control '"+c+"' couldn't be created asynchronously"));});}.bind(this));}var C=O.get(c);if(!C){throw new Error("Can't create a control because the matching class object has not yet been loaded. Please preload the '"+c+"' module");}var i=this.getControlIdBySelector(s,A);return new C(i,S);},applySettings:function(c,s){c.applySettings(s);},_byId:function(i){return sap.ui.getCore().byId(i);},getId:function(c){return c.getId();},getParent:function(c){return c.getParent&&c.getParent();},getControlMetadata:function(c){return c&&c.getMetadata();},getControlType:function(c){return c&&c.getMetadata().getName();},setAssociation:function(p,n,i){var M=p.getMetadata().getAssociation(n);M.set(p,i);},getAssociation:function(p,n){var M=p.getMetadata().getAssociation(n);return M.get(p);},getAllAggregations:function(p){return p.getMetadata().getAllAggregations();},getAggregation:function(p,n){var A=this.findAggregation(p,n);if(A){return p[A._sGetter]();}},insertAggregation:function(p,n,o,i){if(n==="customData"){p.insertAggregation(n,o,i,true);}else{var A=this.findAggregation(p,n);if(A){if(A.multiple){var I=i||0;p[A._sInsertMutator](o,I);}else{p[A._sMutator](o);}}}},removeAggregation:function(c,n,o){if(n==="customData"){c.removeAggregation(n,o,true);}else{var A=this.findAggregation(c,n);if(A){c[A._sRemoveMutator](o);}}},removeAllAggregation:function(c,n){if(n==="customData"){c.removeAllAggregation(n,true);}else{var A=this.findAggregation(c,n);if(A){c[A._sRemoveAllMutator]();}}},getBindingTemplate:function(c,A){var o=c.getBindingInfo(A);return o&&o.template;},updateAggregation:function(c,A){var o=this.findAggregation(c,A);if(o){c[o._sDestructor]();c.updateAggregation(A);}},findIndexInParentAggregation:function(c){var p=this.getParent(c),C;if(!p){return-1;}C=this.getAggregation(p,this.getParentAggregationName(c));if(Array.isArray(C)){return C.indexOf(c);}else{return 0;}},getParentAggregationName:function(c){return c.sParentAggregationName;},findAggregation:function(c,A){if(c){if(c.getMetadata){var M=c.getMetadata();var o=M.getAllAggregations();if(o){return o[A];}}}},validateType:function(c,A,p,f){var t=A.type;if(A.multiple===false&&this.getAggregation(p,A.name)&&this.getAggregation(p,A.name).length>0){return false;}return this._isInstanceOf(c,t)||this._hasInterface(c,t);},instantiateFragment:function(f,n,v){var o=b.parse(f);o=this._checkAndPrefixIdsInFragment(o,n);var N;var i=v&&v.getId();var c=v.getController();N=sap.ui.xmlfragment({fragmentContent:o,sId:i},c);if(!Array.isArray(N)){N=[N];}return N;},templateControlFragment:function(f,p,v){return a._templateFragment(f,p).then(function(o){var c=(v&&v.getController())||undefined;return F.load({definition:o,controller:c});});},destroy:function(c,s){c.destroy(s);},_getFlexCustomData:function(c,t){var C=typeof c==="object"&&typeof c.data==="function"&&c.data("sap-ui-custom-settings");return O.get(["sap.ui.fl",t],C);},attachEvent:function(o,e,f,d){var c=O.get(f);if(typeof c!=="function"){throw new Error("Can't attach event because the event handler function is not found or not a function.");}o.attachEvent(e,d,c);},detachEvent:function(o,e,f){var c=O.get(f);if(typeof c!=="function"){throw new Error("Can't attach event because the event handler function is not found or not a function.");}o.detachEvent(e,c);},bindAggregation:function(c,A,o){c.bindAggregation(A,o);},unbindAggregation:function(c,A){c.unbindAggregation(A);},getExtensionPointInfo:function(e,v){var V=(v._xContent)?v._xContent:v;var E=X.getExtensionPointInfo(e,V);if(E){E.index--;E.parent=E.parent&&this._byId(v.createId(E.parent.getAttribute("id")));E.defaultContent=E.defaultContent.map(function(n){var i=v.createId(n.getAttribute("id"));return this._byId(i);}.bind(this)).filter(function(c){return!!c;});}return E;}};return m({},a,J);},true);
sap.ui.predefine('sap/ui/core/util/reflection/XmlTreeModifier',["./BaseTreeModifier","sap/ui/base/ManagedObject","sap/ui/base/DataType","sap/base/util/merge","sap/ui/util/XMLHelper","sap/ui/core/mvc/EventHandlerResolver","sap/base/util/includes","sap/base/util/ObjectPath","sap/base/util/isPlainObject","sap/ui/core/Fragment"],function(B,M,D,m,X,E,a,O,b){"use strict";var C="http://schemas.sap.com/sapui5/extension/sap.ui.core.CustomData/1";var c=m({},B,{targets:"xmlTree",setVisible:function(o,v){if(v){o.removeAttribute("visible");}else{o.setAttribute("visible",v);}},getVisible:function(o){return c.getProperty(o,"visible");},setStashed:function(o,s){if(!s){o.removeAttribute("stashed");}else{o.setAttribute("stashed",s);}c.setVisible(o,!s);},getStashed:function(o){return c.getProperty(o,"stashed")||!c.getProperty(o,"visible");},bindProperty:function(o,p,v){o.setAttribute(p,"{"+v+"}");},unbindProperty:function(o,p){o.removeAttribute(p);},_setProperty:function(o,p,P,e){var v=c._getSerializedValue(P);if(e){v=c._escapeCurlyBracketsInString(v);}o.setAttribute(p,v);},setProperty:function(o,p,P){c._setProperty(o,p,P,true);},getProperty:function(o,p){var P=o.getAttribute(p);var d=c.getControlMetadata(o).getProperty(p);if(d){var t=d.getType();if(p==="value"&&c.getControlType(o)==="sap.ui.core.CustomData"&&c.getProperty(o,"key")==="sap-ui-custom-settings"){t=D.getType("object");}if(P===null){P=d.getDefaultValue()||t.getDefaultValue();}else{var u=M.bindingParser(P,undefined,true);if(b(u)){if(u.path||u.parts){P=undefined;}else{P=u;}}else{P=t.parseValue(u||P);}}}return P;},isPropertyInitial:function(o,p){var P=o.getAttribute(p);return(P==null);},setPropertyBinding:function(o,p,P){if(typeof P!=="string"){throw new Error("For XML, only strings are supported to be set as property binding.");}o.setAttribute(p,P);},getPropertyBinding:function(o,p){var P=o.getAttribute(p);if(P){var u=M.bindingParser(P,undefined,true);if(u&&(u.path||u.parts)){return u;}}},createAndAddCustomData:function(o,s,v){o.setAttributeNS(C,"custom.data.via.modifier:"+s,c._escapeCurlyBracketsInString(v));},createControl:function(s,A,v,S,d,e){var i,l,o;if(!c.bySelector(S,A,v)){var f=s.split('.');var n="";if(f.length>1){l=f.pop();n=f.join('.');}var N=v.ownerDocument.createElementNS(n,l);i=c.getControlIdBySelector(S,A);if(i){N.setAttribute("id",i);}if(d){c.applySettings(N,d);}return e?Promise.resolve(N):N;}else{o=new Error("Can't create a control with duplicated ID "+i);if(e){return Promise.reject(o);}throw o;}},applySettings:function(o,s){var d=c.getControlMetadata(o);var e=d.getJSONKeys();Object.keys(s).forEach(function(k){var K=e[k];var v=s[k];switch(K._iKind){case 0:c._setProperty(o,k,v,false);break;case 3:c.setAssociation(o,k,v);break;default:throw new Error("Unsupported in applySettings on XMLTreeModifier: "+k);}});},_byId:function(i,v){if(v){if(v.ownerDocument&&v.ownerDocument.getElementById&&v.ownerDocument.getElementById(i)){return v.ownerDocument.getElementById(i);}else{return v.querySelector("[id='"+i+"']");}}},getId:function(o){return o.getAttribute("id");},getParent:function(o){var p=o.parentNode;if(!c.getId(p)&&!c._isExtensionPoint(p)){p=p.parentNode;}return p;},_getLocalName:function(x){return x.localName||x.baseName||x.nodeName;},getControlType:function(o){return c._getControlTypeInXml(o);},setAssociation:function(p,n,i){if(typeof i!=="string"){i=c.getId(i);}p.setAttribute(n,i);},getAssociation:function(p,n){return p.getAttribute(n);},getAllAggregations:function(o){var d=c.getControlMetadata(o);return d.getAllAggregations();},getAggregation:function(p,n){var A=c._findAggregationNode(p,n);var s=c._isSingleValueAggregation(p,n);var d=[];if(A){d=c._getControlsInAggregation(p,A);}else if(c._isAltTypeAggregation(p,n)&&s){d.push(c.getProperty(p,n));}if(n==="customData"){var e;var N=Array.prototype.slice.call(p.attributes).reduce(function(f,g){var l=c._getLocalName(g);if(g.namespaceURI===C){var o=p.ownerDocument.createElementNS("sap.ui.core","CustomData");o.setAttribute("key",l);o.setAttribute("value",g.value);f.push(o);}else if(g.namespaceURI&&g.name.indexOf("xmlns:")!==0){if(!e){e={};}if(!e.hasOwnProperty(g.namespaceURI)){e[g.namespaceURI]={};}e[g.namespaceURI][l]=g.nodeValue;}return f;},[]);d=d.concat(N);if(e){var o=p.ownerDocument.createElementNS("sap.ui.core","CustomData");o.setAttribute("key","sap-ui-custom-settings");c.setProperty(o,"value",e);d.push(o);}}return s?d[0]:d;},insertAggregation:function(p,n,o,i,v){var A=c._findAggregationNode(p,n);if(!A){var N=p.namespaceURI;A=c.createControl(N+"."+n,undefined,v);p.appendChild(A);}if(i>=A.childElementCount){A.appendChild(o);}else{var r=c._getControlsInAggregation(p,A)[i];A.insertBefore(o,r);}},removeAggregation:function(p,n,o){var A=c._findAggregationNode(p,n);A.removeChild(o);},removeAllAggregation:function(o,n){var A=c._findAggregationNode(o,n);if(o===A){var d=c._getControlsInAggregation(o,o);d.forEach(function(e){o.removeChild(e);});}else{o.removeChild(A);}},_findAggregationNode:function(p,n){var A;var d=c._children(p);for(var i=0;i<d.length;i++){var N=d[i];if(N.localName===n){A=N;break;}}if(!A&&c._isDefaultAggregation(p,n)){A=p;}return A;},_isDefaultAggregation:function(p,A){var o=c.getControlMetadata(p);var d=o.getDefaultAggregation();return d&&A===d.name;},_isNotNamedAggregationNode:function(p,o){var A=c.getAllAggregations(p);var d=A[o.localName];return p.namespaceURI!==o.namespaceURI||!d;},_isSingleValueAggregation:function(p,A){var d=c.getAllAggregations(p);var o=d[A];return!o.multiple;},_isAltTypeAggregation:function(p,A){var o=c.getControlMetadata(p);var d=o.getAllAggregations()[A];return!!d.altTypes;},_isExtensionPoint:function(o){return c._getControlTypeInXml(o)==="sap.ui.core.ExtensionPoint";},getControlMetadata:function(o){return c._getControlMetadataInXml(o);},_getControlsInAggregation:function(p,A){var d=Array.prototype.slice.call(c._children(A));return d.filter(c._isNotNamedAggregationNode.bind(this,p));},_children:function(p){if(p.children){return p.children;}else{var d=[];for(var i=0;i<p.childNodes.length;i++){var n=p.childNodes[i];if(n.nodeType===n.ELEMENT_NODE){d.push(n);}}return d;}},getBindingTemplate:function(o,A){var d=c._findAggregationNode(o,A);if(d){var e=c._children(d);if(e.length===1){return e[0];}}},updateAggregation:function(o,A){},findIndexInParentAggregation:function(o){var p,A,d;p=c.getParent(o);if(!p){return-1;}A=c.getParentAggregationName(o,p);d=c.getAggregation(p,A);if(Array.isArray(d)){d=d.filter(function(o){if(c._isExtensionPoint(o)){return true;}return!c.getProperty(o,"stashed");});return d.indexOf(o);}else{return 0;}},getParentAggregationName:function(o,p){var n,A;if(!p.isSameNode(o.parentNode)){n=false;}else{n=c._isNotNamedAggregationNode(p,o);}if(n){A=c.getControlMetadata(p).getDefaultAggregationName();}else{A=c._getLocalName(o.parentNode);}return A;},findAggregation:function(o,A){var d=c.getControlMetadata(o);var e=d.getAllAggregations();if(e){return e[A];}},validateType:function(o,A,p,f,i){var t=A.type;if(A.multiple===false&&c.getAggregation(p,A.name)&&c.getAggregation(p,A.name).length>0){return false;}var d=sap.ui.xmlfragment({fragmentContent:f});if(!Array.isArray(d)){d=[d];}var r=c._isInstanceOf(d[i],t)||c._hasInterface(d[i],t);d.forEach(function(F){F.destroy();});return r;},instantiateFragment:function(f,n,v){var d;var F=X.parse(f);F=c._checkAndPrefixIdsInFragment(F,n);if(F.localName==="FragmentDefinition"){d=c._getElementNodeChildren(F);}else{d=[F];}d.forEach(function(N){if(c._byId(N.getAttribute("id"),v)){throw Error("The following ID is already in the view: "+N.getAttribute("id"));}});return d;},templateControlFragment:function(f,p){return B._templateFragment(f,p).then(function(F){return c._children(F);});},destroy:function(o){var p=o.parentNode;if(p){p.removeChild(o);}},_getFlexCustomData:function(o,t){if(!o){return undefined;}return o.getAttributeNS("sap.ui.fl",t);},attachEvent:function(n,e,f,d){if(typeof O.get(f)!=="function"){throw new Error("Can't attach event because the event handler function is not found or not a function.");}var v=c.getProperty(n,e)||"";var g=E.parse(v);var s=f;var p=["$event"];if(d){p.push(JSON.stringify(d));}s+="("+p.join(",")+")";if(!a(g,s)){g.push(s);}n.setAttribute(e,g.join(";"));},detachEvent:function(n,e,f){if(typeof O.get(f)!=="function"){throw new Error("Can't attach event because the event handler function is not found or not a function.");}var v=c.getProperty(n,e)||"";var d=E.parse(v);var i=d.findIndex(function(s){return s.includes(f);});if(i>-1){d.splice(i,1);}if(d.length){n.setAttribute(e,d.join(";"));}else{n.removeAttribute(e);}},bindAggregation:function(n,A,v,V){c.bindProperty(n,A,v.path);c.insertAggregation(n,A,v.template,0,V);},unbindAggregation:function(n,A){if(n.hasAttribute(A)){n.removeAttribute(A);c.removeAllAggregation(n,A);}},getExtensionPointInfo:function(e,v){if(v&&e){var d=Array.prototype.slice.call(v.getElementsByTagNameNS("sap.ui.core","ExtensionPoint"));var f=d.filter(function(h){return h.getAttribute("name")===e;});var o=(f.length===1)?f[0]:undefined;if(o){var p=c.getParent(o);var g={parent:p,aggregationName:c.getParentAggregationName(o,p),index:c.findIndexInParentAggregation(o)+1,defaultContent:Array.prototype.slice.call(c._children(o))};return g;}}}});return c;},true);
sap.ui.predefine('sap/ui/core/util/serializer/HTMLViewSerializer',['sap/ui/base/EventProvider','./Serializer','./delegate/HTML','sap/ui/thirdparty/vkbeautify'],function(E,S,H,v){"use strict";
var a=E.extend("sap.ui.core.util.serializer.HTMLViewSerializer",{constructor:function(V,w,g,G){E.apply(this);this._oView=V;this._oWindow=w;this._fnGetControlId=g;this._fnGetEventHandlerName=G;}});
a.prototype.serialize=function(){var t=this;var s=function(C){return C instanceof this._oWindow.sap.ui.core.mvc.View&&C!==t._oView;};var c=new S(this._oView,new H(this._fnGetControlId,this._fnGetEventHandlerName),true,this._oWindow,s);var r=c.serialize();var V=[];V.push('<template');if(this._oView.getControllerName&&this._oView.getControllerName()){V.push(' data-controller-name="'+this._oView.getControllerName()+'"');}V.push(" >");V.push(r);V.push("</template>");return v.xml(V.join(""));};
return a;});
sap.ui.predefine('sap/ui/core/util/serializer/Serializer',['sap/ui/base/EventProvider',"sap/base/assert"],function(E,a){"use strict";
var S=E.extend("sap.ui.core.util.serializer.Serializer",{constructor:function(r,s,b,w,f,c){E.apply(this);this._oRootControl=r;this._delegate=s;this._bSkipRoot=!!b;this._oWindow=w||window;this._fnSkipAggregations=f;this._fnSkipElement=c;}});
S.prototype.serialize=function(){return this._serializeRecursive(this._oRootControl,0);};
S.prototype._serializeRecursive=function(c,l,A,b){a(typeof c!=="undefined","The control must not be undefined");var C=[];var w=(!this._bSkipRoot||l!==0);if(w){var s=this._delegate.start(c,A,b);var m=this._delegate.middle(c,A,b);C.push(s+m);}var d=c.getMetadata().getAllAggregations();if(d){for(var n in d){if(this._fnSkipAggregations&&this._fnSkipAggregations(c,n)){continue;}var e=[];var o=d[n];var v=c[o._sGetter]();if(c.getBindingPath(n)&&c.getBindingInfo(n).template){e.push(c.getBindingInfo(n).template);}else if(v&&v.length){for(var i=0;i<v.length;i++){var O=v[i];if(this._isObjectSerializable(O)){e.push(O);}}}else if(this._isObjectSerializable(v)){e.push(v);}if(e.length>0){if(w){C.push(this._delegate.startAggregation(c,n));}var f=this._isDefaultAggregation(c,n);for(var j=0;j<e.length;j++){C.push(this._serializeRecursive(e[j],l+1,n,f));}if(w){C.push(this._delegate.endAggregation(c,n));}}}}if(w){var g=this._delegate.end(c,A,b);C.push(g);}return C.join("");};
S.prototype._isObjectSerializable=function(o){return o instanceof this._oWindow.sap.ui.core.Element&&!(this._fnSkipElement&&this._fnSkipElement(o));};
S.prototype._isDefaultAggregation=function(c,A){return c.getMetadata().getDefaultAggregationName()===A;};
return S;});
sap.ui.predefine('sap/ui/core/util/serializer/ViewSerializer',['sap/ui/base/EventProvider','./HTMLViewSerializer','./XMLViewSerializer',"sap/base/assert"],function(E,H,X,a){"use strict";
var V=E.extend("sap.ui.core.util.serializer.ViewSerializer",{constructor:function(r,w,d){E.apply(this);this._oRootControl=r;this._oWindow=w||window;this._mViews={};this._sDefaultXmlNamespace=d;}});
V.prototype.serializeToXML=function(){return this.serialize("XML");};
V.prototype.serializeToHTML=function(){return this.serialize("HTML");};
V.prototype.serialize=function(c){this._mViews={};this._sConvertToViewType=c||undefined;return this._serializeRecursive(this._oRootControl);};
V.prototype._getViewType=function(v){if(!this._sConvertToViewType){if(v instanceof this._oWindow.sap.ui.core.mvc.HTMLView){return"HTML";}else if(v instanceof this._oWindow.sap.ui.core.mvc.XMLView){return"XML";}}return this._sConvertToViewType;};
V.prototype._serializeRecursive=function(c){a(typeof c!=="undefined","The control must not be undefined");if(c instanceof this._oWindow.sap.ui.core.mvc.View){var v=this._getViewSerializer(c,this._getViewType(c));if(v){var o=c.getViewName()||c.getControllerName();if(!this._mViews[o]){this._mViews[o]=v.serialize(this._getViewType(c));}}}if(c.getMetadata().getClass()===this._oWindow.sap.ui.core.UIArea){var C=c.getContent();for(var i=0;i<C.length;i++){this._serializeRecursive(C[i]);}}else if(c.getMetadata().getClass()===this._oWindow.sap.ui.core.ComponentContainer){this._serializeRecursive(c.getComponentInstance().getRootControl());}else{var A=c.getMetadata().getAllAggregations();if(A){for(var n in A){var b=A[n];var d=c[b._sGetter]();if(d&&d.length){for(var i=0;i<d.length;i++){var O=d[i];if(O instanceof this._oWindow.sap.ui.core.Element){this._serializeRecursive(O);}}}else if(d instanceof this._oWindow.sap.ui.core.Element){this._serializeRecursive(d);}}}}return this._mViews;};
V.prototype._getViewSerializer=function(v,t){var g=function(e){if(e.fFunction&&e.fFunction._sapui_handlerName){var h=e.fFunction._sapui_handlerName;var c=v.getController();if(c[h]||sap.ui.getCore().getConfiguration().getControllerCodeDeactivated()){return h;}}};var G=function(c){if(c._sapui_controlId){return c._sapui_controlId;}return c.getId().replace(v.createId(""),"");};if(t==="HTML"){return new H(v,this._oWindow,G,g);}else if(t==="XML"){return new X(v,this._oWindow,this._sDefaultXmlNamespace,G,g);}else{var t=(v)?v.constructor:"?";throw Error("View type '"+t+"' is not supported for conversion. Only HTML and XML is supported");}};
return V;});
sap.ui.predefine('sap/ui/core/util/serializer/XMLViewSerializer',['sap/ui/base/EventProvider','./Serializer','./delegate/XML','sap/ui/thirdparty/vkbeautify'],function(E,S,X,v){"use strict";
var a=E.extend("sap.ui.core.util.serializer.XMLViewSerializer",{constructor:function(V,w,d,g,G){E.apply(this);this._oView=V;this._oWindow=w;this._sDefaultNamespace=d;this._fnGetControlId=g;this._fnGetEventHandlerName=G;}});
a.prototype.serialize=function(){var p=[];var m=function(C,P){if(!P){var T=(C)?C.constructor:"?";throw Error("Controls with empty package are currently not supported by the XML serializer: "+T);}if(p.indexOf(P)===-1){p.push(P);}};var t=this;var s=function(C){return C instanceof this._oWindow.sap.ui.core.mvc.View&&C!==t._oView;};var c=new S(this._oView,new X(this._sDefaultNamespace,this._fnGetControlId,this._fnGetEventHandlerName,m),true,this._oWindow,s);var r=c.serialize();var V=[];V.push('<sap.ui.core.mvc:View');if(this._oView.getControllerName&&this._oView.getControllerName()){V.push(' controllerName="'+this._oView.getControllerName()+'"');}if(p.indexOf('sap.ui.core.mvc')===-1){p.push('sap.ui.core.mvc');}for(var i=0;i<p.length;i++){if(this._sDefaultNamespace&&this._sDefaultNamespace===p[i]){V.push(' xmlns="'+p[i]+'"');}else{V.push(' xmlns:'+p[i]+'="'+p[i]+'"');}}V.push(" >");V.push(r);V.push("</sap.ui.core.mvc:View>");return v.xml(V.join(""));};
return a;});
sap.ui.predefine('sap/ui/core/util/serializer/delegate/Delegate',['sap/ui/base/EventProvider'],function(E){"use strict";
var D=E.extend("sap.ui.core.util.serializer.delegate.Delegate",{constructor:function(){E.apply(this);}});
D.prototype.start=function(c,a,i){return"";};
D.prototype.middle=function(c,a,i){return"";};
D.prototype.end=function(c,a,i){return"";};
D.prototype.startAggregation=function(c,a){return"";};
D.prototype.endAggregation=function(c,a){return"";};
return D;});
sap.ui.predefine('sap/ui/core/util/serializer/delegate/HTML',['./Delegate',"sap/base/strings/hyphenate","sap/base/util/deepEqual"],function(D,h,d){"use strict";
var H=D.extend("sap.ui.core.util.serializer.delegate.HTML",{constructor:function(g,G){D.apply(this);this._fnGetControlId=g;this._fnGetEventHandlerName=G;}});
H.prototype.startAggregation=function(c,a){return'<div data-sap-ui-aggregation="'+a+'">';};
H.prototype.endAggregation=function(c,a){return'</div>';};
H.prototype.start=function(c,a,i){return"<div";};
H.prototype.middle=function(c,a,b){var e=[];var I=(this._fnGetControlId)?this._fnGetControlId(c):c.getId();if(I.indexOf("__")!==0){e.push(this._createAttribute("id",I));}e.push(this._createAttribute("data-sap-ui-type",c.getMetadata()._sClassName));if(c.aCustomStyleClasses){var C=c.aCustomStyleClasses;var f=[];for(var i=0;i<C.length;i++){var s=C[i];if(!s.startsWith("sapM")&&!s.startsWith("sapUi")){f.push(s);}}if(f.length>0){e.push(this._createAttribute("class",f.join(" ")));}}if(this._fnGetEventHandlerName){var E=c.getMetadata().getAllEvents();for(var g in E){if(c.hasListeners(g)){var j=c.mEventRegistry[g];for(var i=0;i<j.length;i++){var k=this._fnGetEventHandlerName(j[i]);if(k){e.push(this._createAttribute("data-"+this._createHtmlAttributeName(g),k));break;}}}}}var A=c.getMetadata().getAllAssociations();this._createAttributes(e,c,A,function(n,v){if(A[n].multiple){return v.join(" ");}return v;},function(n,v){return(v!==null&&typeof v!==undefined&&v!=="");});var p=c.getMetadata().getAllProperties();var o=c.getMetadata().getPropertyDefaults();this._createAttributes(e,c,p,null,function(n,v){return!d(v,o[n]);});var l=c.getMetadata().getAllAggregations();this._createAttributes(e,c,l,null,function(n,v){if(!c.getBindingInfo(n)&&(!v||(typeof v!=="string"))){return false;}return true;});e.push('>');return e.join('');};
H.prototype.end=function(c,a,i){return"</div>";};
H.prototype._createAttributes=function(a,c,o,g,v){for(var n in o){var p=o[n];var G=p._sGetter;if(c[G]){var V=c[G]();V=g?g(n,V):V;if(!c.getBindingInfo(n)){if(!v||v(n,V)){a.push(this._createAttribute("data-"+this._createHtmlAttributeName(n),V));}}else{a.push(this._createDataBindingAttribute(c,n,V));}}}};
H.prototype._createDataBindingAttribute=function(c,n,v){var b=c.getBindingInfo(n);var B=null;var p=v;if(!b.bindingString){if(b.binding){var C=b.binding.getMetadata().getName();if(C==="sap.ui.model.PropertyBinding"||C==="sap.ui.model.resource.ResourcePropertyBinding"){B=b.binding.getValue();}}if(b.parts){b=b.parts[0];}var m=b.model;if(B===v||B===null){p="{"+(m?(m+">"+b.path):b.path)+"}";}}else{p=b.bindingString;}return this._createAttribute("data-"+this._createHtmlAttributeName(n),p);};
H.prototype._createAttribute=function(a,v){return' '+a+'="'+v+'"';};
H.prototype._createHtmlAttributeName=function(n){return h(n);};
return H;});
sap.ui.predefine('sap/ui/core/util/serializer/delegate/XML',['./Delegate',"sap/base/util/deepEqual","sap/base/security/encodeXML","sap/ui/thirdparty/jquery"],function(D,d,e,q){"use strict";
var X=D.extend("sap.ui.core.util.serializer.delegate.XML",{constructor:function(s,g,G,m){D.apply(this);this._sDefaultNamespace=s;this._fnGetControlId=g;this._fnMemorizePackage=m;this._fnGetEventHandlerName=G;}});
X.prototype.startAggregation=function(c,a){return'<'+this._createAggregationName(c,a)+'>';};
X.prototype.endAggregation=function(c,a){return'</'+this._createAggregationName(c,a)+'>';};
X.prototype.start=function(c,a,i){return"<"+this._createTagName(c);};
X.prototype.end=function(c,a,i){return"</"+this._createTagName(c)+">";};
X.prototype.middle=function(c,a,b){var x=[];var I=(this._fnGetControlId)?this._fnGetControlId(c):c.getId();if(I.indexOf("__")!==0){x.push(this._createAttribute("id",I));}if(c.aCustomStyleClasses){var C=c.aCustomStyleClasses;var f=[];for(var i=0;i<C.length;i++){var s=C[i];if(!s.startsWith("sapM")&&!s.startsWith("sapUi")){f.push(s);}}if(f.length>0){x.push(this._createAttribute("class",f.join(" ")));}}if(this._fnGetEventHandlerName){var E=c.getMetadata().getAllEvents();for(var g in E){if(c.hasListeners(g)){var h=c.mEventRegistry[g];for(var i=0;i<h.length;i++){var H=this._fnGetEventHandlerName(h[i]);if(H){x.push(this._createAttribute(g,H));break;}}}}}var A=c.getMetadata().getAllAssociations();this._createAttributes(x,c,A,function(n,v){if(A[n].multiple){return v.join(" ");}return v;},function(n,v){return(v!==null&&typeof v!==undefined&&v!=="");});var p=c.getMetadata().getAllProperties();var o=c.getMetadata().getPropertyDefaults();this._createAttributes(x,c,p,null,function(n,v){return!d(v,o[n]);});var j=c.getMetadata().getAllAggregations();this._createAttributes(x,c,j,null,function(n,v){if(!c.getBindingInfo(n)&&(!v||(typeof v!=="string"))){return false;}return true;});x.push('>');return x.join('');};
X.prototype._createAttributes=function(x,c,o,g,v){for(var n in o){var p=o[n];var G=p._sGetter;if(c[G]){var V=c[G]();V=g?g(n,V):V;if(!c.getBindingInfo(n)){if(!v||v(n,V)){x.push(this._createAttribute(n,V));}}else{x.push(this._createDataBindingAttribute(c,n,V));}}}};
X.prototype._createDataBindingAttribute=function(c,n,v){var b=c.getBindingInfo(n);var B=null;var p=v;if(!b.bindingString){if(b.binding){var C=b.binding.getMetadata().getName();if(C==="sap.ui.model.PropertyBinding"||C==="sap.ui.model.resource.ResourcePropertyBinding"){B=b.binding.getValue();}}if(b.parts){b=b.parts[0];}var m=b.model;if(B===v||B===null){p="{"+(m?(m+">"+b.path):b.path)+"}";}}else{p=b.bindingString;}return this._createAttribute(n,p);};
X.prototype._createAttribute=function(a,v){var E=(typeof v==="string"||v instanceof String)?e(v):v;return' '+a+'="'+E+'"';};
X.prototype._createTagName=function(c){var C=c.getMetadata()._sClassName;var l=C.lastIndexOf(".");var s=(l===-1)?C:C.substring(l+1);var p=(l===-1)?C:C.substring(0,l);if(this._fnMemorizePackage){this._fnMemorizePackage(c,p);}return this._createNamespace(p,s);};
X.prototype._createAggregationName=function(c,a){var C=c.getMetadata()._sClassName;var l=C.lastIndexOf(".");var p=(l===-1)?C:C.substring(0,l);return this._createNamespace(p,a);};
X.prototype._createNamespace=function(n,N){if(this._sDefaultNamespace&&this._sDefaultNamespace===n){return N;}else{return n+":"+N;}};
return X;});
sap.ui.predefine('sap/ui/core/ws/ReadyState',function(){"use strict";var R={CONNECTING:0,OPEN:1,CLOSING:2,CLOSED:3};return R;},true);
sap.ui.predefine('sap/ui/core/ws/SapPcpWebSocket',['./WebSocket',"sap/base/Log"],function(W,L){"use strict";
var S=W.extend("sap.ui.core.ws.SapPcpWebSocket",{constructor:function(u,p){W.apply(this,arguments);}});
S.SUPPORTED_PROTOCOLS={v10:"v10.pcp.sap.com"};S._deserializeRegexp=/((?:[^:\\]|(?:\\.))+):((?:[^:\\\n]|(?:\\.))*)/;S._SEPARATOR="\n\n";S._MESSAGE="MESSAGE";
S.prototype._onopen=function(){var s=false;if(this.getProtocol()===""){s=true;}else{for(var p in S.SUPPORTED_PROTOCOLS){if(S.SUPPORTED_PROTOCOLS.hasOwnProperty(p)){if(S.SUPPORTED_PROTOCOLS[p]===this.getProtocol()){s=true;break;}}}}if(s){this.fireOpen();}else{L.error("Unsupported protocol '"+this.getProtocol()+"' selected by the server. "+"Connection will be closed.");this.close("Unsupported protocol selected by the server");}};
S.prototype._onmessage=function(m){var s=-1,e={};if(typeof m.data==="string"){s=m.data.indexOf(S._SEPARATOR);}if(s!==-1){e.pcpFields=this._extractPcpFields(m.data.substring(0,s));e.data=m.data.substr(s+S._SEPARATOR.length);}else{L.warning("Invalid PCP message received: "+m.data);e.pcpFields={};e.data=m.data;}this.fireMessage(e);};
S.prototype._extractPcpFields=function(h){var f=h.split("\n"),l=[],p={};for(var i=0;i<f.length;i++){l=f[i].match(S._deserializeRegexp);if(l&&l.length===3){p[this._unescape(l[1])]=this._unescape(l[2]);}}return p;};
S.prototype._unescape=function(e){var p=e.split("\u0008"),u="";for(var i=0;i<p.length;i++){p[i]=p[i].replace(/\\\\/g,"\u0008").replace(/\\:/g,':').replace(/\\n/g,'\n').replace(/\u0008/g,"\\");}u=p.join("\u0008");return u;};
S.prototype._serializePcpFields=function(p,m,P){var s="",f="",a="";if(m==='string'){a='text';}else if(m==='blob'||m==='arraybuffer'){a='binary';}if(p&&typeof p==='object'){for(f in p){if(p.hasOwnProperty(f)&&f.indexOf('pcp-')!==0){s+=this._escape(f)+":"+this._escape(String(p[f]))+"\n";}}}return"pcp-action:"+P+"\npcp-body-type:"+a+"\n"+s+"\n";};
S.prototype._escape=function(u){return u.replace(/\\/g,'\\\\').replace(/:/g,'\\:').replace(/\n/g,'\\n');};
S.prototype.send=function(m,p){var M=typeof m,P="";P=this._serializePcpFields(p,M,S._MESSAGE);W.prototype.send.call(this,P+m);return this;};
return S;});
sap.ui.predefine('sap/ui/core/ws/WebSocket',['sap/ui/Device','sap/ui/base/EventProvider','./ReadyState','sap/ui/thirdparty/URI',"sap/base/Log","sap/ui/thirdparty/jquery"],function(D,E,R,U,L,q){"use strict";
var W=E.extend("sap.ui.core.ws.WebSocket",{
constructor:function(u,p){E.apply(this);if(!D.support.websocket){throw new Error("Browser does not support WebSockets.");}if(typeof(u)!=="string"){throw new Error("sUrl must be a string.");}if(typeof(p)!=='undefined'&&!Array.isArray(p)&&typeof(p)!=='string'){throw new Error("aProtocols must be a string, array of strings or undefined.");}this._openConnection(u,p);},
metadata:{publicMethods:["send","close","getReadyState","getProtocol"]}
});
W.prototype.getInterface=function(){return this;};
W.M_EVENTS={Open:"open",Close:"close",Error:"error",Message:"message"};
W.prototype.attachOpen=function(d,f,l){this.attachEvent("open",d,f,l);return this;};
W.prototype.detachOpen=function(f,l){this.detachEvent("open",f,l);return this;};
W.prototype.fireOpen=function(p){this.fireEvent("open",p);return this;};
W.prototype.attachClose=function(d,f,l){this.attachEvent("close",d,f,l);return this;};
W.prototype.detachClose=function(f,l){this.detachEvent("close",f,l);return this;};
W.prototype.fireClose=function(p){this.fireEvent("close",p);return this;};
W.prototype.attachError=function(d,f,l){this.attachEvent("error",d,f,l);return this;};
W.prototype.detachError=function(f,l){this.detachEvent("error",f,l);return this;};
W.prototype.fireError=function(p){this.fireEvent("error",p);return this;};
W.prototype.attachMessage=function(d,f,l){this.attachEvent("message",d,f,l);return this;};
W.prototype.detachMessage=function(f,l){this.detachEvent("message",f,l);return this;};
W.prototype.fireMessage=function(p){this.fireEvent("message",p);return this;};
W.prototype._resolveFullUrl=function(u){var o=new U(u);var b=new U(document.baseURI);b.search('');b.protocol(b.protocol()==='https'?'wss':'ws');o=o.absoluteTo(b);return o.toString();};
W.prototype._openConnection=function(u,p){var u=this._resolveFullUrl(u);this._oWs=(typeof(p)==='undefined')?new window.WebSocket(u):new window.WebSocket(u,p);this._oWs.onopen=q.proxy(this._onopen,this);this._oWs.onclose=q.proxy(this._onclose,this);this._oWs.onmessage=q.proxy(this._onmessage,this);this._oWs.onerror=q.proxy(this._onerror,this);};
W.prototype._onopen=function(){this.fireOpen();};
W.prototype._onclose=function(c){this.fireClose({code:c.code,reason:c.reason,wasClean:c.wasClean});};
W.prototype._onerror=function(e){this.fireError();};
W.prototype._onmessage=function(m){this.fireMessage({data:m.data});};
W.prototype.send=function(m){if(this.getReadyState()===R.OPEN){this._oWs.send(m);}else if(this.getReadyState()===R.CONNECTING){this.attachEventOnce("open",function(e){this._oWs.send(m);});}else{L.warning("Unable to send WebSocket message. "+"Connection is already closed or closing. message: "+m);}return this;};
W.prototype.close=function(c,r){if(typeof(c)==='string'){r=c;c=undefined;}c=(typeof(c)==='undefined')?1000:c;r=(typeof(r)==='undefined')?"":r;if(this.getReadyState()===R.OPEN){this._oWs.close(c,r);}else if(this.getReadyState()===R.CONNECTING){this.attachEventOnce("open",function(e){this._oWs.close(c,r);});}else{var t='';switch(this.getReadyState()){case R.CLOSED:t="Connection is already closed.";break;case R.CLOSING:t="Connection is already closing.";break;}L.warning("Unable to close WebSocket connection. "+t);}return this;};
W.prototype.getReadyState=function(){return this._oWs.readyState;};
W.prototype.getProtocol=function(){return this._oWs.protocol;};
return W;});
sap.ui.predefine('sap/ui/dom/denormalizeScrollBeginRTL',["sap/ui/Device","sap/ui/util/_FeatureDetection"],function(D,_){"use strict";var d;if(_.initialScrollPositionIsZero()){if(_.canScrollToNegative()){d=function(n,o){return-n;};}else{d=function(n,o){return n;};}}else{d=function(n,o){return o.scrollWidth-o.clientWidth-n;};}var f=function(n,o){if(o){return d(n,o);}};return f;});
sap.ui.predefine('sap/ui/dom/denormalizeScrollLeftRTL',["sap/ui/Device","sap/ui/util/_FeatureDetection"],function(D,_){"use strict";var d;if(_.initialScrollPositionIsZero()){if(_.canScrollToNegative()){d=function(n,o){return o.clientWidth+n-o.scrollWidth;};}else{d=function(n,o){return o.scrollWidth-o.clientWidth-n;};}}else{d=function(n,o){return n;};}var f=function(n,o){if(o){return d(n,o);}};return f;});
sap.ui.predefine('sap/ui/dom/getFirstEditableInput',["sap/ui/thirdparty/jquery","sap/ui/dom/isHidden"],function(q,i){"use strict";
function f(c){return q(c).find('input, textarea').not('input[readonly],textarea[readonly],input[type=hidden],input[type=button],input[type=submit],input[type=reset],input[type=image],button').filter(':enabled:visible:first')[0];}
function g(c){if(!c||i(c)){return null;}return f(c);}
return g;});
sap.ui.predefine('sap/ui/dom/getOwnerWindow',[],function(){"use strict";var g=function o(d){if(d.ownerDocument.parentWindow){return d.ownerDocument.parentWindow;}return d.ownerDocument.defaultView;};return g;});
sap.ui.predefine('sap/ui/dom/isHidden',["sap/ui/thirdparty/jquery"],function(q){"use strict";
function i(e){return(e.offsetWidth<=0&&e.offsetHeight<=0)||q.css(e,'visibility')==='hidden';}
return i;});
sap.ui.predefine('sap/ui/dom/jquery/Aria',['sap/ui/thirdparty/jquery'],function(q){"use strict";
function a(A,v,p){var s=this.attr(A);if(!s){return this.attr(A,v);}var b=s.split(" ");if(b.indexOf(v)==-1){p?b.unshift(v):b.push(v);this.attr(A,b.join(" "));}return this;}
function r(A,v){var s=this.attr(A)||"",b=s.split(" "),i=b.indexOf(v);if(i==-1){return this;}b.splice(i,1);if(b.length){this.attr(A,b.join(" "));}else{this.removeAttr(A);}return this;}
q.fn.addAriaLabelledBy=function(i,p){return a.call(this,"aria-labelledby",i,p);};
q.fn.removeAriaLabelledBy=function(i){return r.call(this,"aria-labelledby",i);};
q.fn.addAriaDescribedBy=function(i,p){return a.call(this,"aria-describedby",i,p);};
q.fn.removeAriaDescribedBy=function(i){return r.call(this,"aria-describedby",i);};
return q;});
sap.ui.predefine('sap/ui/dom/jquery/Focusable',["sap/ui/thirdparty/jquery","sap/ui/dom/jquery/hasTabIndex","sap/ui/dom/isHidden"],function(q,d,i){"use strict";
function f(c,F){var C=F?c.firstChild:c.lastChild,o;while(C){if(C.nodeType==1&&!i(C)){if(q(C).hasTabIndex()){return C;}o=f(C,F);if(o){return o;}}C=F?C.nextSibling:C.previousSibling;}return null;}
q.fn.firstFocusableDomRef=function(){var c=this.get(0);if(!c||i(c)){return null;}return f(c,true);};
q.fn.lastFocusableDomRef=function(){var c=this.get(0);if(!c||i(c)){return null;}return f(c,false);};
return q;});
sap.ui.predefine('sap/ui/dom/jquery/Selection',["sap/ui/thirdparty/jquery"],function(q){"use strict";
q.fn.disableSelection=function(){return this.on(("onselectstart"in document.createElement("div")?"selectstart":"mousedown")+".ui-disableSelection",function(e){e.preventDefault();});};
q.fn.enableSelection=function(){return this.off(".ui-disableSelection");};
return q;});
sap.ui.predefine('sap/ui/dom/jquery/cursorPos',['sap/ui/thirdparty/jquery'],function(q){"use strict";var c=function a(p){var l=arguments.length,t,T;t=this.prop("tagName");T=this.prop("type");if(this.length===1&&((t=="INPUT"&&(T=="text"||T=="password"||T=="search"))||t=="TEXTAREA")){var d=this.get(0);if(l>0){if(typeof(d.selectionStart)=="number"){d.focus();d.selectionStart=p;d.selectionEnd=p;}return this;}else{if(typeof(d.selectionStart)=="number"){return d.selectionStart;}return-1;}}else{return this;}};q.fn.cursorPos=c;return q;});
sap.ui.predefine('sap/ui/dom/jquery/getSelectedText',['sap/ui/thirdparty/jquery'],function(q){"use strict";var g=function(){var d=this.get(0);try{if(typeof d.selectionStart==="number"){return d.value.substring(d.selectionStart,d.selectionEnd);}}catch(e){}return"";};q.fn.getSelectedText=g;return q;});
sap.ui.predefine('sap/ui/dom/jquery/hasTabIndex',["sap/ui/thirdparty/jquery"],function(q){"use strict";var h=function(e){var t=q.prop(e,"tabIndex");return t!=null&&t>=0&&(!q.attr(e,"disabled")||q.attr(e,"tabindex"));};
q.fn.hasTabIndex=function(){return h(this.get(0));};
return q;});
sap.ui.predefine('sap/ui/dom/jquery/parentByAttribute',['sap/ui/thirdparty/jquery'],function(q){"use strict";var p=function b(a,v){if(this.length>0){if(v){return this.first().parents("["+a+"='"+v+"']").get(0);}else{return this.first().parents("["+a+"]").get(0);}}};q.fn.parentByAttribute=p;return q;});
sap.ui.predefine('sap/ui/dom/jquery/rect',["sap/ui/thirdparty/jquery","sap/ui/dom/getOwnerWindow"],function(q,d){"use strict";var r=function a(){var D=this.get(0);if(D){if(D.getBoundingClientRect){var c=D.getBoundingClientRect();var R={top:c.top,left:c.left,width:c.right-c.left,height:c.bottom-c.top};var w=d(D);R.left+=q(w).scrollLeft();R.top+=q(w).scrollTop();return R;}else{return{top:10,left:10,width:D.offsetWidth,height:D.offsetHeight};}}return null;};q.fn.rect=r;return q;});
sap.ui.predefine('sap/ui/dom/jquery/rectContains',["sap/ui/thirdparty/jquery","sap/base/assert","sap/ui/dom/jquery/rect"],function(q,a){"use strict";var r=function b(p,P){a(!isNaN(p),"iPosX must be a number");a(!isNaN(P),"iPosY must be a number");var R=this.rect();if(R){return p>=R.left&&p<=R.left+R.width&&P>=R.top&&P<=R.top+R.height;}return false;};q.fn.rectContains=r;return q;});
sap.ui.predefine('sap/ui/dom/jquery/scrollLeftRTL',["sap/ui/Device","sap/ui/dom/denormalizeScrollLeftRTL","sap/ui/util/_FeatureDetection","sap/ui/thirdparty/jquery"],function(D,d,_,q){"use strict";var s;if(_.initialScrollPositionIsZero()){if(_.canScrollToNegative()){s=function(o){return o.scrollWidth+o.scrollLeft-o.clientWidth;};}else{s=function(o){return o.scrollWidth-o.scrollLeft-o.clientWidth;};}}else{s=function(o){return o.scrollLeft;};}var S=function(p){var o=this.get(0);if(o){if(p===undefined){return s(o);}else{o.scrollLeft=d(p,o);return this;}}};q.fn.scrollLeftRTL=S;return q;});
sap.ui.predefine('sap/ui/dom/jquery/scrollRightRTL',["sap/ui/Device","sap/ui/util/_FeatureDetection","sap/ui/thirdparty/jquery"],function(D,_,q){"use strict";var s;if(_.initialScrollPositionIsZero()){if(_.canScrollToNegative()){s=function(d){return(-d.scrollLeft);};}else{s=function(d){return d.scrollLeft;};}}else{s=function(d){return d.scrollWidth-d.scrollLeft-d.clientWidth;};}var S=function(){var d=this.get(0);if(d){return s(d);}};q.fn.scrollRightRTL=S;return q;});
sap.ui.predefine('sap/ui/dom/jquery/selectText',['sap/ui/thirdparty/jquery'],function(q){"use strict";var s=function a(S,E){var d=this.get(0);try{if(typeof(d.selectionStart)==="number"){d.setSelectionRange(S>0?S:0,E);}}catch(e){}return this;};q.fn.selectText=s;return q;});
sap.ui.predefine('sap/ui/dom/units/Rem',['sap/base/assert'],function(a){"use strict";
function g(){var r=document.documentElement;if(!r){return 16;}return parseFloat(window.getComputedStyle(r).getPropertyValue("font-size"));}
var R={fromPx:function(p){a(((typeof p==="string")&&(p!=="")&&!isNaN(parseFloat(p))&&(typeof parseFloat(p)==="number"))||((typeof p==="number")&&!isNaN(p)),'Rem.fromPx: either the "vPx" parameter must be an integer, or a string e.g.: "16px"');return parseFloat(p)/g();},toPx:function(r){a(((typeof r==="string")&&(r!=="")&&!isNaN(parseFloat(r))&&(typeof parseFloat(r)==="number"))||((typeof r==="number")&&!isNaN(r)),'Rem.toPx: either the "vRem" parameter must be an integer, or a string e.g.: "1rem"');return parseFloat(r)*g();}};return R;});
sap.ui.predefine('sap/ui/events/isMouseEventDelayed',["sap/ui/Device"],function(D){"use strict";var i=function(n){n=n||navigator;return!!(D.browser.mobile&&!((D.os.ios&&D.os.version>=8&&D.browser.safari&&!D.browser.webview)||(D.browser.chrome&&!/SAMSUNG/.test(n.userAgent)&&D.browser.version>=32)));};return i;});
sap.ui.predefine('sap/ui/events/isSpecialKey',function(){"use strict";var i=function(e){function a(e){var k=e.key;return(k==='Shift')||(k==='Control')||(k==='Alt')||(k==='AltGraph')||(k==='CapsLock')||(k==='NumLock');}function b(e){var k=e.key;return(k==='ArrowLeft')||(k==='ArrowUp')||(k==='ArrowRight')||(k==='ArrowDown')||(k==='Left')||(k==='Up')||(k==='Right')||(k==='Down');}var k=e.key,s=a(e)||b(e)||k==='PageUp'||k==='PageDown'||k==='End'||k==='Home'||k==='PrintScreen'||k==='Insert'||k==='Del'||k==='Delete'||k==='F1'||k==='F2'||k==='F3'||k==='F4'||k==='F5'||k==='F6'||k==='F7'||k==='F8'||k==='F9'||k==='F10'||k==='F11'||k==='F12'||k==='Pause'||k==='Backspace'||k==='Tab'||k==='Enter'||k==='Escape'||k==='Esc'||k==='ScrollLock'||k==='Scroll';switch(e.type){case"keydown":case"keyup":case"keypress":return s;default:return false;}};return i;});
sap.ui.predefine('sap/ui/model/ClientTreeBindingAdapter',['sap/ui/model/TreeBinding','sap/ui/model/ClientTreeBinding','./TreeBindingAdapter','sap/ui/model/ChangeReason',"sap/base/assert","sap/base/Log"],function(T,C,a,b,c,L){"use strict";var d=function(){if(!(this instanceof T)||this._bIsAdapted){return;}a.apply(this);for(var f in d.prototype){if(d.prototype.hasOwnProperty(f)){this[f]=d.prototype[f];}}this._invalidTree=true;this.setNumberOfExpandedLevels(this.mParameters.numberOfExpandedLevels||0);};
d.prototype.setNumberOfExpandedLevels=function(n){this._iNumberOfExpandedLevels=parseInt(n);};
d.prototype.getNumberOfExpandedLevels=function(){return this._iNumberOfExpandedLevels;};
d.prototype.nodeHasChildren=function(n){c(n,"TreeBindingAdapter.nodeHasChildren: No node given!");if(!n){return false;}else if(n.isArtificial){return true;}else{return C.prototype.hasChildren.call(this,n.context);}};
d.prototype.resetData=function(o,p){var r=C.prototype.resetData.call(this,o,p);this._aRowIndexMap=[];this._oRootNode=undefined;this._iPageSize=0;this._iThreshold=0;if(!p||p.reason!==b.Sort){this.clearSelection();this._createTreeState(true);}return r;};
d.prototype._calculateGroupID=function(n){var B=this.getPath();var g;if(n.context){var s=n.context.getPath();if(B!="/"){var m=s.match(B+"(.*)");if(m!=null&&m[1]){g=m[1];}else{L.warning("CTBA: BindingPath/ContextPath matching problem!");}}if(!g){g=s;}if(g.startsWith("/")){g=g.substring(1,g.length);}var p;if(!n.parent){p=this._calculateGroupID({context:n.context._parentContext||null});}else{p=n.parent.groupID;}g=p+g.replace(/\//g,"_")+"/";}else if(n.context===null){g="/";}return g;};
d.prototype.expand=function(){this._buildTree();a.prototype.expand.apply(this,arguments);};
d.prototype.collapse=function(){this._buildTree();a.prototype.collapse.apply(this,arguments);};
d.prototype._buildTree=function(s,l){if(this._invalidTree){s=s||0;l=l||this.getRootContexts().length;this._invalidTree=false;this._aRowIndexMap=[];a.prototype._buildTree.call(this,s,l);}};
d.prototype.findNode=function(){this._buildTree();return a.prototype.findNode.apply(this,arguments);};
d.prototype.setSelectedIndex=function(){this._buildTree();return a.prototype.setSelectedIndex.apply(this,arguments);};
d.prototype.setSelectionInterval=function(){this._buildTree();return a.prototype.setSelectionInterval.apply(this,arguments);};
d.prototype.addSelectionInterval=function(){this._buildTree();a.prototype.addSelectionInterval.apply(this,arguments);};
d.prototype.removeSelectionInterval=function(){this._buildTree();a.prototype.removeSelectionInterval.apply(this,arguments);};
d.prototype.clearSelection=function(){this._buildTree();a.prototype.clearSelection.apply(this,arguments);};
d.prototype.selectAll=function(){this._buildTree();a.prototype.selectAll.apply(this,arguments);};
d.prototype._calculateRequestLength=function(m,s){return m;};
d.prototype.getLength=function(){this._buildTree();return a.prototype.getLength.apply(this,arguments);};
d.prototype._fireChange=function(){this._invalidTree=true;this.constructor.prototype._fireChange.apply(this,arguments);};
return d;},true);
sap.ui.predefine('sap/ui/model/MetaModel',['./Model'],function(M){"use strict";
var a=M.extend("sap.ui.model.MetaModel",{constructor:function(){M.apply(this,arguments);}});
a.prototype.createBindingContext=function(p,c,P,C){if(typeof c=="function"){C=c;c=null;}if(typeof P=="function"){C=P;P=null;}var s=this.resolve(p,c),n=(s==undefined)?undefined:this.getContext(s?s:"/");if(!n){n=null;}if(C){C(n);}return n;};
a.prototype.destroyBindingContext=function(c){};
return a;});
sap.ui.predefine('sap/ui/model/SelectionModel',['sap/ui/base/EventProvider',"sap/base/assert"],function(E,c){"use strict";
var S=E.extend("sap.ui.model.SelectionModel",{constructor:function(s){E.apply(this);this.iSelectionMode=s||S.SINGLE_SELECTION;this.aSelectedIndices=[];this.iLeadIndex=-1;this.fnSort=function(a,b){return a-b;};this.fnSortReverse=function(a,b){return b-a;};}});
S.SINGLE_SELECTION=0;S.MULTI_SELECTION=1;
S.prototype.getSelectionMode=function(){return this.iSelectionMode;};
S.prototype.setSelectionMode=function(s){this.iSelectionMode=s||S.SINGLE_SELECTION;};
S.prototype.isSelectedIndex=function(i){return this.aSelectedIndices.indexOf(i)!==-1;};
S.prototype.getLeadSelectedIndex=function(){return this.iLeadIndex;};
S.prototype.setLeadSelectedIndex=function(l){c(typeof l==="number","iLeadIndex must be an integer");this.setSelectionInterval(l,l);return this;};
S.prototype.getMinSelectionIndex=function(){if(this.aSelectedIndices.length>0){var i=this.aSelectedIndices.sort(this.fnSort);return i[0];}else{return-1;}};
S.prototype.getMaxSelectionIndex=function(){if(this.aSelectedIndices.length>0){var i=this.aSelectedIndices.sort(this.fnSortReverse);return i[0];}else{return-1;}};
S.prototype.getSelectedIndices=function(){var i=this.aSelectedIndices.sort(this.fnSort);return i;};
S.prototype.setSelectionInterval=function(f,t){c(typeof f==="number","iFromIndex must be an integer");c(typeof t==="number","iToIndex must be an integer");if(this.iSelectionMode===S.SINGLE_SELECTION){f=t;}var F=Math.min(f,t);var T=Math.max(f,t);var o=this.aSelectedIndices.slice();var l={};var C=[];for(var i=0;i<o.length;i++){l[o[i]]=true;if(o[i]<f||o[i]>t){C.push(o[i]);}}var s=[];for(var I=F;I<=T;I++){s.push(I);if(!l[I]){C.push(I);}}this._update(s,t,C);return this;};
S.prototype.addSelectionInterval=function(f,t){c(typeof f==="number","iFromIndex must be an integer");c(typeof t==="number","iToIndex must be an integer");if(this.iSelectionMode===S.SINGLE_SELECTION){return this.setSelectionInterval(f,t);}var F=Math.min(f,t);var T=Math.max(f,t);var C=[];var s=this.aSelectedIndices;for(var i=F;i<=T;i++){if(s.indexOf(i)===-1){s.push(i);C.push(i);}}this._update(s,T,C);return this;};
S.prototype.moveSelectionInterval=function(s,m){c(typeof s==="number","iFromIndex must be an integer");c(typeof m==="number","iToIndex must be an integer");var C=[];var a=this.aSelectedIndices;var l=this.iLeadIndex;for(var i=0;i<a.length;i++){var I=a[i];if(I>=s){C.push(a[i]);a[i]+=m;C.push(a[i]);if(I===this.iLeadIndex){l+=m;}}}this._update(a,l,C);return this;};
S.prototype.removeSelectionInterval=function(f,t){c(typeof f==="number","iFromIndex must be an integer");c(typeof t==="number","iToIndex must be an integer");if(this.iSelectionMode===S.SINGLE_SELECTION){f=t;}var F=Math.min(f,t);var T=Math.max(f,t);var C=[];var s=this.aSelectedIndices;var l=this.iLeadIndex;for(var i=F;i<=T;i++){var I=s.indexOf(i);if(I>-1){s.splice(I,1);C.push(i);}if(i===this.iLeadIndex){l=-1;}}this._update(s,l,C);return this;};
S.prototype.sliceSelectionInterval=function(f,t){c(typeof f==="number","iFromIndex must be an integer");c(typeof t==="number","iToIndex must be an integer");var F=Math.min(f,t);var T=Math.max(f,t);var C=[];var r=[];var o=this.aSelectedIndices.slice(0);var s=this.aSelectedIndices;var l=this.iLeadIndex;var R=T-F+1;for(var I=T;I>=F;I--){var a=s.indexOf(I);if(a>-1){s.splice(a,1);r.push(I);}if(I===this.iLeadIndex){l=-1;}}for(var I=0;I<s.length;I++){var O=s[I];if(O>=F){var n=s[I]-R;if(O===l){l=n;}s[I]=n;if(o.indexOf(n)===-1){C.push(n);}}}for(var i=0;i<r.length;i++){var I=o[o.length-1-i];if(C.indexOf(I)===-1){C.push(I);}}for(var i=0;i<r.length;i++){if(s.indexOf(r[i])===-1&&C.indexOf(r[i])===-1){C.push(r[i]);}}this._update(s,l,C);return this;};
S.prototype.clearSelection=function(){if(this.aSelectedIndices.length>0||this.iLeadIndex!==-1){this._update([],-1,this.aSelectedIndices.slice());}return this;};
S.prototype.attachSelectionChanged=function(d,f,l){this.attachEvent("selectionChanged",d,f,l);return this;};
S.prototype.detachSelectionChanged=function(f,l){this.detachEvent("selectionChanged",f,l);return this;};
S.prototype.fireSelectionChanged=function(p){this.fireEvent("selectionChanged",p);return this;};
S.prototype._update=function(s,l,C,b){var p={rowIndices:C&&C.sort(this.fnSort),selectAll:b};this.aSelectedIndices=s;p.oldIndex=this.iLeadIndex;if(this.iLeadIndex!==l){this.iLeadIndex=l;p.leadIndex=this.iLeadIndex;}if(C.length>0||typeof p.leadIndex!=="undefined"){this.fireSelectionChanged(p);}};
S.prototype.selectAll=function(t){c(typeof t==="number","iToIndex must be an integer");var o=this.aSelectedIndices.slice();var l={};var C=[];var s=[];var i=0;for(i=0;i<o.length;i++){l[o[i]]=true;if(o[i]>t){C.push(o[i]);}}for(i=0;i<=t;i++){s.push(i);if(!l[i]){C.push(i);}}this._update(s,0,C,true);return this;};
return S;});
sap.ui.predefine('sap/ui/model/TreeAutoExpandMode',[],function(){"use strict";var T={Sequential:"Sequential",Bundled:"Bundled"};return T;},true);
sap.ui.predefine('sap/ui/model/TreeBindingAdapter',['sap/ui/model/TreeBinding','sap/ui/model/TreeAutoExpandMode','sap/ui/model/ChangeReason','sap/ui/model/TreeBindingUtils',"sap/base/assert","sap/base/Log","sap/base/util/each","sap/base/util/isEmptyObject"],function(T,c,C,d,e,L,f,g){"use strict";var h=function(){if(!(this instanceof T)||this._bIsAdapted){return;}for(var a in h.prototype){if(h.prototype.hasOwnProperty(a)){this[a]=h.prototype[a];}}this.mParameters=this.mParameters||{};this._aRowIndexMap=[];this._iThreshold=0;this._iPageSize=0;this.setAutoExpandMode(this.mParameters.autoExpandMode||c.Sequential);if(this.mParameters.collapseRecursive===undefined){this.bCollapseRecursive=true;}else{this.bCollapseRecursive=!!this.mParameters.collapseRecursive;}this._createTreeState();this._bIsAdapted=true;};
h.prototype.getCurrentTreeState=function(){var D=";";var E={};for(var G in this._mTreeState.expanded){E[G]=true;}var m={};for(var G in this._mTreeState.collapsed){m[G]=true;}var s={};for(var G in this._mTreeState.selected){s[G]=true;}return{_getExpandedList:function(){return Object.keys(E).join(D);},_getCollapsedList:function(){return Object.keys(m).join(D);},_getSelectedList:function(){return Object.keys(s).join(D);},_isExpanded:function(G){return!!E[G];},_isCollapsed:function(G){return!!m[G];},_remove:function(G){delete E[G];delete m[G];delete s[G];}};};
h.prototype.setTreeState=function(t){this._oInitialTreeState=t;};
h.prototype.setAutoExpandMode=function(a){this._autoExpandMode=a;};
h.prototype.getLength=function(){if(!this._oRootNode){return 0;}return this._oRootNode.magnitude;};
h.prototype.getContextByIndex=function(i){if(this.isInitial()){return;}var n=this.findNode(i);return n?n.context:undefined;};
h.prototype.getNodeByIndex=function(i){if(this.isInitial()){return;}if(i>=this.getLength()){return undefined;}return this.findNode(i);};
h.prototype.findNode=function(p){if(this.isInitial()){return;}var P=typeof p;var F;var s=[];if(P==="number"){F=this._aRowIndexMap[p];if(!F){var i=-1;this._match(this._oRootNode,s,1,function(n){if(i===p){return true;}i+=1;});F=s[0];}}return F;};
h.prototype._createTreeState=function(r){if(!this._mTreeState||r){this._mTreeState={expanded:{},collapsed:{},selected:{},deselected:{}};}};
h.prototype._updateTreeState=function(p){p=p||{};var t=p.expanded?this._mTreeState.expanded:this._mTreeState.collapsed;var s=p.expanded?this._mTreeState.collapsed:this._mTreeState.expanded;var n=this._getNodeState(p.groupID);if(!n){n=p.fallbackNodeState||this._createNodeState({groupID:p.groupID,expanded:p.expanded,sum:p.sum});}delete s[p.groupID];t[p.groupID]=n;n.expanded=p.expanded;return n;};
h.prototype._createNodeState=function(p){if(!p.groupID){e(false,"To create a node state a group ID is mandatory!");return;}var i;var I;if(this._oInitialTreeState){i=this._oInitialTreeState._isExpanded(p.groupID);I=this._oInitialTreeState._isCollapsed(p.groupID);this._oInitialTreeState._remove(p.groupID);}var b=p.expanded||i||false;var a=p.selected||false;var n={groupID:p.groupID,expanded:b,sections:p.sections||[{startIndex:0,length:this._iPageSize}],sum:p.sum||false,selected:a};if(i||I){this._updateTreeState({groupID:p.groupID,fallbackNodeState:n,expanded:i,collapsed:I});}return n;};
h.prototype._getNodeState=function(G){var E=this._mTreeState.expanded[G];var o=this._mTreeState.collapsed[G];var s=this._mTreeState.selected[G];var D=this._mTreeState.deselected[G];return E||o||s||D;};
h.prototype._updateNodeSections=function(G,n){var N=this._getNodeState(G);if(!N){e(false,"No Node State for Group ID '"+G+"' found!");return;}else if(!n){e(false,"No Section given!");return;}else if(n.length<=0){e(false,"The length of the given section must be positive greater than 0.");return;}else if(n.startIndex<0){e(false,"The sections start index must be greater/equal to 0.");return;}N.sections=d.mergeSections(N.sections,n);return N.sections;};
h.prototype._increaseSections=function(){var I=function(n){if(!n){return;}var m=this._getMaxGroupSize(n);var N=n.nodeState;if(m===undefined){var a=[];for(var i=0;i<N.sections.length;i++){var o=N.sections[i];o.length=Math.max(o.length,this._iPageSize);a=d.mergeSections(a,o);}N.sections=a;}};this._map(this._oRootNode,I);};
h.prototype._getMaxGroupSize=function(n){var m=0;if(n.isArtificial){var i=this.oModel.isList(this.sPath,this.getContext());if(this.bDisplayRootNode&&!i&&!this._bRootMissing){m=1;}else{m=this._getGroupSize(n)||0;}}else{m=this.nodeHasChildren(n)?this._getGroupSize(n):0;}return m;};
h.prototype.getContexts=function(s,l,t,r){if(this.isInitial()){return[];}if(!l){l=this.oModel.iSizeLimit;}if(!t){t=0;}if(l>this._iPageSize){this._iPageSize=l;this._increaseSections();}this._iThreshold=Math.max(this._iThreshold,t);this._aRowIndexMap=[];this._buildTree(s,l);var n=[];if(this._oRootNode){n=this._retrieveNodeSection(this._oRootNode,s,l);}this._updateRowIndexMap(n,s);var a=[];var m;for(var i=0;i<n.length;i++){var N=n[i];if(!N.context){m=m||{};var p=N.parent;m[p.groupID]=p;this._updateNodeSections(p.groupID,{startIndex:N.positionInParent,length:1});}a.push(N.context);}if(m){var b=this;f(m,function(G,N){N.magnitude=0;N.numberOfTotals=0;b._loadChildContexts(N);});a=[];for(var j=0;j<n.length;j++){var N=n[j];a.push(N.context);}}if(r){return n;}else{return a;}};
h.prototype.getNodes=function(s,l,t){return this.getContexts(s,l,t,true);};
h.prototype._updateRowIndexMap=function(n,s){this._aRowIndexMap=[];for(var i=0;i<n.length;i++){this._aRowIndexMap[s+i]=n[i];}};
h.prototype._retrieveNodeSection=function(n,s,l){var N=-1;var a=[];this._match(this._oRootNode,[],l,function(n,p,P){if(!n||!n.isArtificial){N++;}if(N>=s&&N<s+l){if(!n){n=this._createNode({parent:P,positionInParent:p});P.children[p]=n;}a.push(n);return true;}});return a;};
h.prototype._buildTree=function(s,l){this._oRootNode=undefined;var r=null;var R=this._calculateGroupID({context:r,parent:null});var o=this._getNodeState(R);if(!o){var o=this._createNodeState({groupID:R,sum:true,sections:[{startIndex:s,length:l}]});this._updateTreeState({groupID:o.groupID,fallbackNodeState:o,expanded:true});}this._oRootNode=this._createNode({context:r,parent:null,level:this.bDisplayRootNode&&!(r===null)?0:-1,nodeState:o,isLeaf:false,autoExpand:this.getNumberOfExpandedLevels()+1});this._oRootNode.isArtificial=true;if(this._mTreeState.expanded[this._oRootNode.groupID]){this._loadChildContexts(this._oRootNode);}};
h.prototype._calculateRequestLength=function(m,s){var r;if(!m){r=s.length;}else{r=Math.max(Math.min(s.length,m-s.startIndex),0);}return r;};
h.prototype._loadChildContexts=function(n){var N=n.nodeState;var m=this._getMaxGroupSize(n);if(m>0){if(!n.children[m-1]){n.children[m-1]=undefined;}N.leafCount=m;}if(this.bClientOperation){N.sections=[{startIndex:0,length:m}];}for(var i=0;i<N.sections.length;i++){var o=N.sections[i];var r=this._calculateRequestLength(m,o);if(n.autoExpand>=0&&this._autoExpandMode===c.Bundled){r=Math.max(0,m);}var a;if(n.isArtificial){a=this.getRootContexts(o.startIndex,r,this._iThreshold);}else{a=this.nodeHasChildren(n)?this.getNodeContexts(n.context,o.startIndex,r,this._iThreshold):[];}for(var j=0;j<a.length;j++){var b=a[j];if(!b){continue;}var k=j+o.startIndex;var l=n.children[k];var u={context:a[j],parent:n,level:n.level+1,positionInParent:k,autoExpand:Math.max(n.autoExpand-1,-1)};if(l){l.context=u.context;l.parent=u.parent;l.level=u.level;l.positionInParent=u.positionInParent;l.magnitude=0;l.numberOfTotals=0;l.autoExpand=u.autoExpand;var G;if(b){G=this._calculateGroupID(l);}l.groupID=G;}else{l=this._createNode(u);}l.nodeState=this._getNodeState(l.groupID);if(!l.nodeState){l.nodeState=this._createNodeState({groupID:l.groupID,expanded:false});}l.nodeState.parentGroupID=n.groupID;l.isLeaf=!this.nodeHasChildren(l);n.children[k]=l;if(l.isLeaf){n.numberOfLeafs+=1;}if(l.parent.nodeState.selectAllMode&&!this._mTreeState.deselected[l.groupID]){this.setNodeSelection(l.nodeState,true);}if((l.autoExpand>0||l.nodeState.expanded)&&this.isGrouped()){if(!this._mTreeState.collapsed[l.groupID]&&!l.isLeaf){this._updateTreeState({groupID:l.nodeState.groupID,fallbackNodeState:l.nodeState,expanded:true});this._loadChildContexts(l);}n.magnitude+=Math.max(l.magnitude||0,0);n.numberOfLeafs+=l.numberOfLeafs;}}}n.magnitude+=Math.max(m||0,0);};
h.prototype.isGrouped=function(){return true;};
h.prototype._calculateGroupID=function(n){L.error("TreeBindingAdapter#_calculateGroupID: Not implemented. Needs to be implemented in respective sub-classes.");};
h.prototype._createNode=function(p){p=p||{};var o=p.context;var l=p.level||0;var n={context:o,level:l,children:p.children||[],parent:p.parent,nodeState:p.nodeState,isLeaf:p.isLeaf||false,positionInParent:p.positionInParent,magnitude:p.magnitude||0,numberOfTotals:p.numberOfTotals||0,numberOfLeafs:p.numberOfLeafs||0,autoExpand:p.autoExpand||0,absoluteNodeIndex:p.absoluteNodeIndex||0,totalNumberOfLeafs:0};if(o!==undefined){n.groupID=this._calculateGroupID(n);}return n;};
h.prototype.expand=function(i,s){var n=this.findNode(i);if(!n){e(false,"No node found for index "+i);return;}this._updateTreeState({groupID:n.nodeState.groupID,fallbackNodeState:n.nodeState,expanded:true});if(!s){this._fireChange({reason:C.Expand});}};
h.prototype.expandToLevel=function(l){this._mTreeState.collapsed={};this.setNumberOfExpandedLevels(l);this._fireChange({reason:C.Expand});};
h.prototype.isExpanded=function(i){var n=this.findNode(i);return n&&n.nodeState?n.nodeState.expanded:false;};
h.prototype.collapse=function(p,s){var n;var t=this;if(typeof p==="object"){n=p;}else if(typeof p==="number"){var N=this.findNode(p);if(!N){e(false,"No node found for index "+p);return;}n=N.nodeState;}this._updateTreeState({groupID:n.groupID,fallbackNodeState:n,expanded:false});n.selectAllMode=false;if(this.bCollapseRecursive){var G=n.groupID;f(this._mTreeState.expanded,function(b,o){if(typeof G=="string"&&G.length>0&&b.startsWith(G)){t._updateTreeState({groupID:b,expanded:false});}});var D=[];f(this._mTreeState.selected,function(b,o){if(typeof G=="string"&&G.length>0&&b.startsWith(G)&&b!==G){o.selectAllMode=false;t.setNodeSelection(o,false);D.push(b);}});if(D.length){var a={rowIndices:[]};var i=-1;this._map(this._oRootNode,function(N){if(!N||!N.isArtificial){i++;}if(N&&D.indexOf(N.groupID)!==-1){if(N.groupID===this._sLeadSelectionGroupID){a.oldIndex=i;a.leadIndex=-1;}a.rowIndices.push(i);}});this._publishSelectionChanges(a);}}if(!s){this._fireChange({reason:C.Collapse});}};
h.prototype.collapseToLevel=function(l){if(!l||l<0){l=0;}var t=this;f(this._mTreeState.expanded,function(G,n){var N=t._getGroupIdLevel(G)-1;if(N===l){t.collapse(n,true);}});this._fireChange({reason:C.Collapse});};
h.prototype._map=function(n,m){m.call(this,n);if(!n){return;}for(var i=0;i<n.children.length;i++){var o=n.children[i];this._map(o,m);}if(this._afterMapHook){this._afterMapHook(n,m);}};
h.prototype._match=function(n,r,m,M,p,P){if(r.length===m){return true;}var N=M.call(this,n,p,P);if(N){r.push(n);}if(!n){return false;}for(var i=0;i<n.children.length;i++){var o=n.children[i];var b=this._match(o,r,m,M,i,n);if(b){return true;}}return this._afterMatchHook?this._afterMatchHook(n,r,m,M,p,P):false;};
h.prototype.toggleIndex=function(i){var n=this.findNode(i);if(!n){e(false,"There is no node at index "+i+".");return;}if(n.nodeState.expanded){this.collapse(i);}else{this.expand(i);}};
h.prototype._getGroupIdLevel=function(G){if(G==null){L.warning("assertion failed: no need to determine level of group ID = null");return-1;}return G.split("/").length-2;};
h.prototype._getGroupSize=function(n){return this.getChildCount(n.context);};
h.prototype.setNodeSelection=function(n,i){if(!n.groupID){e(false,"NodeState must have a group ID!");return;}n.selected=i;if(i){this._mTreeState.selected[n.groupID]=n;delete this._mTreeState.deselected[n.groupID];}else{delete this._mTreeState.selected[n.groupID];this._mTreeState.deselected[n.groupID]=n;}};
h.prototype.isIndexSelected=function(r){var n=this.getNodeByIndex(r);return n&&n.nodeState?n.nodeState.selected:false;};
h.prototype.isIndexSelectable=function(r){var n=this.getNodeByIndex(r);return this._isNodeSelectable(n);};
h.prototype._isNodeSelectable=function(n){return!!n&&!n.isArtificial;};
h.prototype.setSelectedIndex=function(r){var n=this.findNode(r);if(n&&this._isNodeSelectable(n)){var o=this._clearSelection();var i=o.rowIndices.indexOf(r);if(i>=0){o.rowIndices.splice(i,1);}else{o.rowIndices.push(r);}o.leadGroupID=n.groupID;o.leadIndex=r;this.setNodeSelection(n.nodeState,true);this._publishSelectionChanges(o);}else{L.warning("TreeBindingAdapter: The selection was ignored. Please make sure to only select rows, for which data has been fetched to the client. For AnalyticalTables, some rows might not be selectable at all.");}};
h.prototype.getSelectedIndex=function(){if(!this._sLeadSelectionGroupID||g(this._mTreeState.selected)){return-1;}var n=-1;var a=false;var m=function(N){if(!N||!N.isArtificial){n++;}if(N){if(N.groupID===this._sLeadSelectionGroupID){a=true;return true;}}};this._match(this._oRootNode,[],1,m);if(a){return n;}return-1;};
h.prototype.getSelectedIndices=function(){var r=[];var t=this;if(g(this._mTreeState.selected)){return r;}var n=Object.keys(this._mTreeState.selected).length;var N=-1;var m=function(o){if(!o||!o.isArtificial){N++;}if(o){if(o.nodeState&&o.nodeState.selected&&!o.isArtificial){r.push(N);t._aRowIndexMap[N]=o;return true;}}};this._match(this._oRootNode,[],n,m);return r;};
h.prototype.getSelectedNodesCount=function(){var s;if(this._oRootNode&&this._oRootNode.nodeState.selectAllMode){var G,v,p,o;var a,V=[];if(this.filterInfo&&this.oCombinedFilter){for(var i=this.filterInfo.aFilteredContexts.length-1;i>=0;i--){a=this.filterInfo.aFilteredContexts[i];V.push(this._calculateGroupID({context:a}));}}v=0;for(G in this._mTreeState.expanded){if(!this.oCombinedFilter||V.indexOf(G)!==-1){o=this._mTreeState.expanded[G];if(!o.selectAllMode&&o.leafCount!==undefined){v+=o.leafCount;}}}for(G in this._mTreeState.selected){if(!this.oCombinedFilter||V.indexOf(G)!==-1){o=this._mTreeState.selected[G];p=this._mTreeState.expanded[o.parentGroupID];if(p&&!p.selectAllMode){v--;}}}for(G in this._mTreeState.deselected){if(!this.oCombinedFilter||V.indexOf(G)!==-1){o=this._mTreeState.deselected[G];p=this._mTreeState.expanded[o.parentGroupID];if(p&&p.selectAllMode){v++;}}}s=this._getSelectableNodesCount(this._oRootNode)-v;}else{s=Object.keys(this._mTreeState.selected).length;}return s;};
h.prototype._getSelectableNodesCount=function(n){if(n){return n.magnitude;}else{return 0;}};
h.prototype.getSelectedContexts=function(){var r=[];var t=this;if(g(this._mTreeState.selected)){return r;}var n=Object.keys(this._mTreeState.selected).length;var N=-1;var m=function(o){if(!o||!o.isArtificial){N++;}if(o){if(o.nodeState&&o.nodeState.selected&&!o.isArtificial){r.push(o.context);t._aRowIndexMap[N]=o;return true;}}};this._match(this._oRootNode,[],n,m);return r;};
h.prototype.setSelectionInterval=function(F,t){var m=this._clearSelection();var s=this._setSelectionInterval(F,t,true);var I={};var r=[];for(var i=0;i<m.rowIndices.length;i++){var a=m.rowIndices[i];I[a]=true;}for(i=0;i<s.rowIndices.length;i++){a=s.rowIndices[i];if(I[a]){delete I[a];}else{I[a]=true;}}for(a in I){if(I[a]){r.push(parseInt(a));}}this._publishSelectionChanges({rowIndices:r,oldIndex:m.oldIndex,leadIndex:s.leadIndex,leadGroupID:s.leadGroupID});};
h.prototype._setSelectionInterval=function(F,t,s){var n=Math.min(F,t);var N=Math.max(F,t);var a=[];var b=[];var i=Math.abs(N-n)+1;var o;var j=-1;var m=function(k){if(!k||!k.isArtificial){j++;}if(k){if(j>=n&&j<=N){if(this._isNodeSelectable(k)){if(k.nodeState.selected!==!!s){b.push(j);}if(k.groupID===this._sLeadSelectionGroupID){o=j;}this.setNodeSelection(k.nodeState,!!s);}return true;}}};this._match(this._oRootNode,a,i,m);var p={rowIndices:b,oldIndex:o,leadIndex:o&&!s?-1:undefined};if(a.length>0&&s){var l=a[a.length-1];p.leadGroupID=l.groupID;p.leadIndex=N;}return p;};
h.prototype.addSelectionInterval=function(F,t){var p=this._setSelectionInterval(F,t,true);this._publishSelectionChanges(p);};
h.prototype.removeSelectionInterval=function(F,t){var p=this._setSelectionInterval(F,t,false);this._publishSelectionChanges(p);};
h.prototype.selectAll=function(){this._mTreeState.deselected={};var p={rowIndices:[],oldIndex:-1,selectAll:true};var n=-1;this._map(this._oRootNode,function(N){if(!N||!N.isArtificial){n++;}if(N){if(N.groupID===this._sLeadSelectionGroupID){p.oldIndex=n;}if(this._isNodeSelectable(N)){if(N.nodeState.selected!==true){p.rowIndices.push(n);}this.setNodeSelection(N.nodeState,true);p.leadGroupID=N.groupID;p.leadIndex=n;}if(N.nodeState.expanded){N.nodeState.selectAllMode=true;}}});this._publishSelectionChanges(p);};
h.prototype._clearSelection=function(){var n=-1;var o=-1;var m;var a=[];if(this._oRootNode&&!this._oRootNode.nodeState.selectAllMode){m=0;for(var G in this._mTreeState.selected){if(G){m++;}}}var M=function(N){if(!N||!N.isArtificial){n++;}if(N){N.nodeState.selectAllMode=false;if(this._mTreeState.selected[N.groupID]){if(!N.isArtificial){a.push(n);}this.setNodeSelection(N.nodeState,false);if(N.groupID===this._sLeadSelectionGroupID){o=n;}return true;}}};this._match(this._oRootNode,[],m,M);if(this._oRootNode&&this._oRootNode.nodeState&&this._oRootNode.isArtificial){this._oRootNode.nodeState.selectAllMode=false;}return{rowIndices:a,oldIndex:o,leadIndex:-1};};
h.prototype.clearSelection=function(s){var o=this._clearSelection();if(!s){this._publishSelectionChanges(o);}};
h.prototype._publishSelectionChanges=function(p){p.oldIndex=p.oldIndex||this.getSelectedIndex();p.rowIndices.sort(function(a,b){return a-b;});if(p.leadIndex>=0&&p.leadGroupID){this._sLeadSelectionGroupID=p.leadGroupID;}else if(p.leadIndex===-1){this._sLeadSelectionGroupID=undefined;}else{p.leadIndex=p.oldIndex;}if(p.rowIndices.length>0||(p.leadIndex!=undefined&&p.leadIndex!==-1)){this.fireSelectionChanged(p);}};
h.prototype.setCollapseRecursive=function(b){this.bCollapseRecursive=!!b;};
h.prototype.getCollapseRecursive=function(){return this.bCollapseRecursive;};
h.prototype.attachSelectionChanged=function(D,F,l){this.attachEvent("selectionChanged",D,F,l);return this;};
h.prototype.detachSelectionChanged=function(F,l){this.detachEvent("selectionChanged",F,l);return this;};
h.prototype.fireSelectionChanged=function(p){this.fireEvent("selectionChanged",p);return this;};
return h;},true);
sap.ui.predefine('sap/ui/model/TreeBindingCompatibilityAdapter',["sap/base/util/each"],function(e){"use strict";var T=function(b,t){var a=t;Object.assign(b,{_init:function(E){this._bExpandFirstLevel=E;this.mContextInfo={};this._initContexts();if(E&&!this._bFirstLevelExpanded){this._expandFirstLevel();}},_initContexts:function(s){this.aContexts=this.getRootContexts(0,Number.MAX_VALUE);for(var i=0,l=this.aContexts.length;i<l;i++){var o=this._getContextInfo(this.aContexts[i]);this._setContextInfo({oContext:this.aContexts[i],iLevel:0,bExpanded:o?o.bExpanded:false});}if(this._bExpandFirstLevel&&!this._bFirstLevelExpanded){this._expandFirstLevel(s);}},_expandFirstLevel:function(s){var a=this;if(this.aContexts&&this.aContexts.length>0){e(this.aContexts.slice(),function(i,c){if(!s){a._loadChildContexts(c);}a._getContextInfo(c).bExpanded=true;});this._bFirstLevelExpanded=true;}},_fnFireFilter:b._fireFilter,_fireFilter:function(){this._fnFireFilter.apply(this,arguments);this._initContexts(true);this._restoreContexts(this.aContexts);},_fnFireChange:b._fireChange,_fireChange:function(){this._fnFireChange.apply(this,arguments);this._initContexts(true);this._restoreContexts(this.aContexts);},_restoreContexts:function(c){var a=this;var n=[];e(c.slice(),function(i,C){var o=a._getContextInfo(C);if(o&&o.bExpanded){n.push.apply(n,a._loadChildContexts(C));}});if(n.length>0){this._restoreContexts(n);}},_loadChildContexts:function(c){var C=this._getContextInfo(c);var I=(this.aContexts?this.aContexts.indexOf(c):-1);var n=this.getNodeContexts(c,0,Number.MAX_VALUE);for(var i=0,l=n.length;i<l;i++){this.aContexts.splice(I+i+1,0,n[i]);var o=this._getContextInfo(n[i]);this._setContextInfo({oParentContext:c,oContext:n[i],iLevel:C.iLevel+1,bExpanded:o?o.bExpanded:false});}return n;},_getContextInfo:function(c){return c?this.mContextInfo[c.getPath()]:undefined;},_setContextInfo:function(d){if(d&&d.oContext){this.mContextInfo[d.oContext.getPath()]=d;}},getLength:function(){return this.aContexts?this.aContexts.length:0;},getContexts:function(s,l){return this.aContexts.slice(s,s+l);},getNodes:function(s,l){var c=this.getContexts(s,s+l);var n=[];for(var i=0;i<c.length;i++){var C=this._getContextInfo(c[i])||{};var o=c[i];n.push({context:o,level:C.iLevel,parent:C.oParentContext,nodeState:{expanded:C.bExpanded,collapsed:!C.bExpanded,selected:false}});}return n;},hasChildren:function(){return true;},nodeHasChildren:function(){return true;},getContextByIndex:function(r){return this.aContexts[r];},getLevel:function(c){var C=this._getContextInfo(c);return C?C.iLevel:-1;},isExpanded:function(r){var c=this.getContextByIndex(r);var C=this._getContextInfo(c);return C?C.bExpanded:false;},expandContext:function(c){var C=this._getContextInfo(c);if(C&&!C.bExpanded){this.storeSelection();this._loadChildContexts(c);C.bExpanded=true;this._fireChange();this.restoreSelection();}},expand:function(r){this.expandContext(this.getContextByIndex(r));},collapseContext:function(c,s){var C=this._getContextInfo(c);if(C&&C.bExpanded){this.storeSelection();for(var i=this.aContexts.length-1;i>0;i--){if(this._getContextInfo(this.aContexts[i]).oParentContext===c){this.aContexts.splice(i,1);}}C.bExpanded=false;if(!s){this._fireChange();}this.restoreSelection();}},collapse:function(r){this.collapseContext(this.getContextByIndex(r));},collapseToLevel:function(l){if(!l||l<0){l=0;}var c=this.aContexts.slice();for(var i=c.length-1;i>=0;i--){var C=this.getLevel(c[i]);if(C!=-1&&C>=l){this.collapseContext(c[i],true);}}this._fireChange();},toggleContext:function(c){var C=this._getContextInfo(c);if(C){if(C.bExpanded){this.collapseContext(c);}else{this.expandContext(c);}}},toggleIndex:function(r){this.toggleContext(this.getContextByIndex(r));},storeSelection:function(){var s=a.getSelectedIndices();var S=[];e(s,function(i,v){S.push(a.getContextByIndex(v));});this._aSelectedContexts=S;},restoreSelection:function(){a.clearSelection();var _=this._aSelectedContexts;e(this.aContexts,function(i,c){if(((_?_.indexOf(c):-1))>=0){a.addSelectionInterval(i,i);}});this._aSelectedContexts=undefined;},attachSelectionChanged:function(){return undefined;},detachSelectionChanged:function(){},clearSelection:function(){a._oSelection.clearSelection();},attachSort:function(){},detachSort:function(){}});b._init(t.getExpandFirstLevel());};return T;},true);
sap.ui.predefine('sap/ui/model/TreeBindingUtils',function(){"use strict";var T=function(){};
T.mergeSections=function(s,n){var N=[];for(var i=0;i<s.length;i++){var c=s[i];var C=c.startIndex+c.length;var a=n.startIndex+n.length;if(n.startIndex<=C&&a>=C&&n.startIndex>=c.startIndex){n.startIndex=c.startIndex;n.length=a-c.startIndex;}else if(n.startIndex<=c.startIndex&&a>=c.startIndex&&a<=C){n.length=C-n.startIndex;}else if(n.startIndex>=c.startIndex&&a<=C){n.startIndex=c.startIndex;n.length=c.length;}else if(a<c.startIndex||n.startIndex>C){N.push(c);}}N.push(n);return N;};
T._determineRequestDelta=function(n,p){var N=n.iSkip+n.iTop;var P=p.iSkip+p.iTop;if(n.iSkip===p.iSkip&&n.iTop===p.iTop){return false;}else if(n.iSkip<p.iSkip&&N>p.iSkip&&N<=P){n.iTop=p.iSkip-n.iSkip;if(n.iThreshold){n.iTop=n.iTop+n.iThreshold;n.iSkip=Math.max(0,n.iSkip-n.iThreshold);n.iThreshold=0;}}else if(n.iSkip<P&&N>P&&n.iSkip>=p.iSkip){n.iSkip=P;n.iTop=N-n.iSkip;if(n.iThreshold){n.iTop+=n.iThreshold;n.iThreshold=0;}}else if(n.iSkip>=p.iSkip&&N<=P){return false;}else if(n.iSkip<=p.iSkip&&N>=P){p.oRequestHandle.abort();}else if(N<=p.iSkip||n.iSkip>=P){}};
return T;});
sap.ui.predefine('sap/ui/model/analytics/AnalyticalBinding',['sap/ui/model/TreeBinding','sap/ui/model/ChangeReason','sap/ui/model/Filter','sap/ui/model/FilterOperator','sap/ui/model/FilterProcessor','sap/ui/model/FilterType','sap/ui/model/Sorter','sap/ui/model/odata/CountMode','sap/ui/model/TreeAutoExpandMode','./odata4analytics','./BatchResponseCollector','./AnalyticalVersionInfo','sap/base/util/isEmptyObject','sap/base/util/uid','sap/ui/thirdparty/jquery','sap/base/Log'],function(T,C,F,a,b,c,S,d,f,t,B,A,u,v,Q,L){"use strict";var w="sap.ui.model.analytics.AnalyticalBinding",x=L.getLogger(w);
function y(o){var e=new t.QueryResultRequest(o.oAnalyticalQueryResult),g,s,h,i,j,m,n,p,k=o.mParameters.select.split(","),l=E(k,o.sPath);e.setAggregationLevel(o.aMaxAggregationLevel);e.setMeasures(o.aMeasureName);Object.keys(o.oDimensionDetailsSet).forEach(function(q){h=o.oDimensionDetailsSet[q];e.includeDimensionKeyTextAttributes(q,true,h.textPropertyName!==undefined,h.aAttributeName);});Object.keys(o.oMeasureDetailsSet).forEach(function(M){m=o.oMeasureDetailsSet[M];e.includeMeasureRawFormattedValueUnit(M,m.rawValuePropertyName!==undefined,m.formattedValuePropertyName!==undefined,m.unitPropertyName!==undefined);});s=e.getURIQueryOptionValue("$select");if(s){g=s.split(",");for(i=0,n=g.length;i<n;i++){p=g[i];j=k.indexOf(p);if(j<0){x.warning("Ignored the 'select' binding parameter, because"+" it does not contain the property '"+p+"'",o.sPath);l=true;}else{k.splice(j,1);}}}for(i=0,n=k.length;i<n;i++){p=k[i];h=o.oAnalyticalQueryResult.findDimensionByPropertyName(p);if(h&&o.oDimensionDetailsSet[h.getName()]===undefined){D(o.sPath,p,h);l=true;}m=o.oAnalyticalQueryResult.findMeasureByPropertyName(p);if(m&&o.oMeasureDetailsSet[m.getName()]===undefined){D(o.sPath,p,m);l=true;}}return l?[]:k;}
function D(p,s,o){var e=o instanceof sap.ui.model.analytics.odata4analytics.Dimension?"dimension":"measure";if(o.getName()===s){x.warning("Ignored the 'select' binding parameter, because it contains"+" the "+e+" property '"+s+"' which is not contained in the analytical info (see updateAnalyticalInfo)",p);}else{x.warning("Ignored the 'select' binding parameter, because the property '"+s+"' is associated with the "+e+" property '"+o.getName()+"' which is not contained in the analytical"+" info (see updateAnalyticalInfo)",p);}}
function E(s,p){var e,g=false,i,n;for(i=0,n=s.length;i<n;i++){s[i]=s[i].trim();}for(i=s.length-1;i>=0;i--){e=s[i];if(s.indexOf(e)!==i){x.warning("Ignored the 'select' binding parameter, because it"+" contains the property '"+e+"' multiple times",p);s.splice(i,1);g=true;}}return g;}
var G=T.extend("sap.ui.model.analytics.AnalyticalBinding",{constructor:function(m,p,o,s,e,P){T.call(this,m,p,o,e,P);this.aAdditionalSelects=[];this.sEntitySetName=(P&&P.entitySet)?P.entitySet:undefined;this.bArtificalRootContext=false;this.aApplicationFilter=this._convertDeprecatedFilterObjects(e);this.aControlFilter=undefined;this.aSorter=s?s:[];this.aMaxAggregationLevel=[];this.aAggregationLevel=[];this.oPendingRequests={};this.oPendingRequestHandle=[];this.oGroupedRequests={};this.bUseBatchRequests=(P&&P.useBatchRequests===true)?true:false;this.bProvideTotalSize=(P&&P.provideTotalResultSize===false)?false:true;this.bProvideGrandTotals=(P&&P.provideGrandTotals===false)?false:true;this.bReloadSingleUnitMeasures=(P&&P.reloadSingleUnitMeasures===false)?false:true;this.bUseAcceleratedAutoExpand=(P&&P.useAcceleratedAutoExpand===false)?false:true;this.bNoPaging=(P&&P.noPaging===true)?true:false;this.iTotalSize=-1;this.mServiceKey={};this.mServiceLength={};this.mServiceFinalLength={};this.mKeyIndex={};this.mFinalLength=this.mServiceFinalLength;this.mLength={};this.mMultiUnitKey={};this.aMultiUnitLoadFactor={};this.bNeedsUpdate=false;this.bApplySortersToGroups=true;this.sLastAutoExpandMode=undefined;this.mEntityKey={};this.sCustomParams=this.oModel.createCustomParams({custom:this.mParameters.custom});this.oAnalyticalQueryResult=null;this.aAnalyticalInfo=[];this.mAnalyticalInfoByProperty={};this.aBatchRequestQueue=[];if(P&&P.countMode==d.None){x.fatal("requested count mode is ignored; OData requests will include $inlinecout options");}else if(P&&(P.countMode==d.Request||P.countMode==d.Both)){x.warning("default count mode is ignored; OData requests will include $inlinecout options");}else if(this.oModel.sDefaultCountMode==d.Request){x.warning("default count mode is ignored; OData requests will include $inlinecout options");}this.iModelVersion=A.getVersion(this.oModel);if(this.iModelVersion===null){x.error("The AnalyticalBinding does not support Models other than sap.ui.model.odata.ODataModel version 1 or 2.");return;}this.aAllDimensionSortedByName=null;this.aInitialAnalyticalInfo=(P==undefined?[]:P.analyticalInfo);this.bInitial=true;}});
function H(o,e){return function(){if(!o.__supportUID){o.__supportUID=v();}return{type:w,analyticalError:e,analyticalBindingId:o.__supportUID};};}
G.prototype.setContext=function(o){var r;if(this.oContext!==o){this.oContext=o;if(!this.isRelative()){return;}this.oDataState=null;this.bApplySortersToGroups=true;this.iTotalSize=-1;this._abortAllPendingRequests();r=this.oModel.resolve(this.sPath,this.oContext);if(r){this.resetData();this._initialize();this._fireChange({reason:C.Context});}else{this.bInitial=true;}}};
G.prototype.initialize=function(){if(this.oModel.oMetadata&&this.oModel.oMetadata.isLoaded()&&this.isInitial()){var i=this.isRelative();if(!i||(i&&this.oContext)){this._initialize();}this._fireRefresh({reason:C.Refresh});}return this;};
G.prototype._initialize=function(){if(this.oModel.oMetadata&&this.oModel.oMetadata.isLoaded()){this.bInitial=false;this.oAnalyticalQueryResult=this.oModel.getAnalyticalExtensions().findQueryResultByName(this._getEntitySet());if(!this.oAnalyticalQueryResult){throw("Error in AnalyticalBinding - The QueryResult '"+this._getEntitySet()+"' could not be retrieved. Please check your service definition.");}this.updateAnalyticalInfo(this.aInitialAnalyticalInfo);this.aAllDimensionSortedByName=this.oAnalyticalQueryResult.getAllDimensionNames().concat([]).sort();this._fireRefresh({reason:C.Refresh});}};
G.prototype.getRootContexts=function(p){if(this.isInitial()){return[];}var i=(p&&p.numberOfExpandedLevels?p.numberOfExpandedLevels+1:1);var r=null;var R=this._getRequestId(G._requestType.groupMembersQuery,{groupId:null});if(this.bArtificalRootContext&&!this._cleanupGroupingForCompletedRequest(R)){return r;}r=this._getContextsForParentContext(null);if(r.length==1){return r;}if(i<=1){if(i==1){this._considerRequestGrouping([R,this._getRequestId(G._requestType.groupMembersQuery,{groupId:"/"})]);this.getNodeContexts(this.getModel().getContext("/"),{startIndex:p.startIndex,length:p.length,threshold:p.threshold,level:0,numberOfExpandedLevels:0});}}else{var e=this._prepareGroupMembersAutoExpansionRequestIds("/",p.numberOfExpandedLevels);e.push(R);this._considerRequestGrouping(e);this.getNodeContexts(this.getModel().getContext("/"),{startIndex:p.startIndex,length:p.length,threshold:p.threshold,level:0,numberOfExpandedLevels:p.numberOfExpandedLevels});}if(r.length>1){x.fatal("assertion failed: grand total represented by a single entry");}return r;};
G.prototype.getNodeContexts=function(o,p){if(this.isInitial()){return[];}var s,l,i,e,n,g;if(typeof p=="object"){s=p.startIndex;l=p.length;i=p.threshold;e=p.level;n=p.numberOfExpandedLevels;g=p.supressRequest;}else{s=arguments[1];l=arguments[2];i=arguments[3];e=arguments[4];n=arguments[5];g=arguments[6];}var h=this._getContextsForParentContext(o,s,l,i,e,n,g);return h;};
G.prototype.ContextsAvailabilityStatus={ALL:2,SOME:1,NONE:0};
G.prototype.hasAvailableNodeContexts=function(o,l){var g=this._getGroupIdFromContext(o,l);if(this._getKeys(g)!=undefined){if(this.mFinalLength[g]==true){return G.prototype.ContextsAvailabilityStatus.ALL;}else{return G.prototype.ContextsAvailabilityStatus.SOME;}}else{return G.prototype.ContextsAvailabilityStatus.NONE;}};
G.prototype.getGroupSize=function(o,l){if(o===undefined){return 0;}var g=this._getGroupIdFromContext(o,l);return this.mFinalLength[g]?this.mLength[g]:-1;};
G.prototype.getTotalSize=function(){if(!this.bProvideTotalSize){x.fatal("total size of result explicitly turned off, but getter invoked");}return+this.iTotalSize;};
G.prototype.hasChildren=function(o,p){if(o===undefined){return false;}if(o==null){return true;}var i=p.level;if(i==0){return true;}if(this.aAggregationLevel.length<i){return false;}return this.aMaxAggregationLevel.indexOf(this.aAggregationLevel[i-1])<this.aMaxAggregationLevel.length-1;};
G.prototype.hasMeasures=function(){var h=false;for(var p in this.oMeasureDetailsSet){if(this.oMeasureDetailsSet.hasOwnProperty(p)){h=true;break;}}return h;};
G.prototype.getDimensionDetails=function(){return this.oDimensionDetailsSet;};
G.prototype.getMeasureDetails=function(){return this.oMeasureDetailsSet;};
G.prototype.providesGrandTotal=function(){return this.bProvideGrandTotals;};
G.prototype.getProperty=function(p){if(this.isInitial()){return{};}return this.oAnalyticalQueryResult.getEntityType().findPropertyByName(p);};
G.prototype.getFilterablePropertyNames=function(){if(this.isInitial()){return[];}return this.oAnalyticalQueryResult.getEntityType().getFilterablePropertyNames();};
G.prototype.getSortablePropertyNames=function(){if(this.isInitial()){return[];}return this.oAnalyticalQueryResult.getEntityType().getSortablePropertyNames();};
G.prototype.getPropertyLabel=function(p){if(this.isInitial()){return"";}return this.oAnalyticalQueryResult.getEntityType().getLabelOfProperty(p);};
G.prototype.getPropertyHeading=function(p){if(this.isInitial()){return"";}return this.oAnalyticalQueryResult.getEntityType().getHeadingOfProperty(p);};
G.prototype.getPropertyQuickInfo=function(p){if(this.isInitial()){return"";}return this.oAnalyticalQueryResult.getEntityType().getQuickInfoOfProperty(p);};
G.prototype.isMeasure=function(p){return this.aMeasureName&&this.aMeasureName.indexOf(p)!==-1;};
G.prototype.filter=function(e,s){if(!e){e=[];}if(e instanceof F){e=[e];}e=this._convertDeprecatedFilterObjects(e);if(s==c.Application){this.aApplicationFilter=e;}else{this.aControlFilter=e;}this.iTotalSize=-1;this._abortAllPendingRequests();this.resetData();this.bApplySortersToGroups=true;this._fireRefresh({reason:C.Filter});return this;};
G.prototype.getFilterInfo=function(i){var o=b.combineFilters(this.aControlFilter,this.aApplicationFilter);if(o){return o.getAST(i);}return null;};
G.prototype.sort=function(s){if(s instanceof S){s=[s];}this.aSorter=s?s:[];this._abortAllPendingRequests();this.resetData(undefined,{reason:C.Sort});this._fireRefresh({reason:C.Sort});return this;};
G.prototype.getGroupName=function(o,l){if(o===undefined){return"";}var g=this.aAggregationLevel[l-1],e=this.oAnalyticalQueryResult.findDimensionByPropertyName(g),V=this.mAnalyticalInfoByProperty[g]&&this.mAnalyticalInfoByProperty[g].formatter,p=o.getProperty(g),s,h,i,j,k,m,n,q;if(e&&this.oDimensionDetailsSet[g].textPropertyName){k=e.getTextProperty();}if(k){m=k.name;q=this.mAnalyticalInfoByProperty[m]&&this.mAnalyticalInfoByProperty[m].formatter;n=o.getProperty(m);s=V?V(p,n):p;h=q?q(n,p):n;}else{s=V?V(p):p;}j=e.getLabelText&&e.getLabelText();i=(j?j+': ':'')+s;if(h){i+=' - '+h;}return i;};
G.prototype.updateAnalyticalInfo=function(e,g){var h,o,k,l,m=this;function n(N){var O=N.level,R=N.name;l=l||k.getAllHierarchyPropertyNames();l.forEach(function(V){var W=m.oAnalyticalQueryResult.findDimensionByPropertyName(V).getHierarchy(),X=null,Y=W.getNodeIDProperty().name,Z;if(Y===R){X=p(W);}else{Z=W.getNodeExternalKeyProperty();if(Z&&Z.name===R){X=p(W);X.nodeExternalKeyName=R;}else{Z=k.getTextPropertyOfProperty(Y);if(Z&&Z.name===R){X=p(W);X.nodeTextName=R;}}}if(X&&"level"in N){if(typeof O==="number"){if("level"in X&&X.level!==O){throw new Error("Multiple different level filter for hierarchy '"+Y+"' defined");}X.level=O;X.grouped=!!N.grouped;}else{throw new Error("The level of '"+Y+"' has to be an integer value");}}});}function p(N){var O=N.getNodeIDProperty().name,R,V=m.mHierarchyDetailsByName[O];if(!V){R=N.getNodeLevelProperty();V={dimensionName:N.getNodeValueProperty().name,nodeIDName:O,nodeLevelName:R&&R.name};m.mHierarchyDetailsByName[O]=V;}return V;}if(!this.oModel.oMetadata||!this.oModel.oMetadata.isLoaded()||this.isInitial()){this.aInitialAnalyticalInfo=e;return;}h=t.helper.deepEqual(this._aLastChangedAnalyticalInfo,e,function(N){m.mAnalyticalInfoByProperty[N.name].formatter=N.formatter;});if(h){this._aLastChangedAnalyticalInfo=[];for(var j=0;j<e.length;j++){this._aLastChangedAnalyticalInfo[j]=Q.extend({},e[j]);}}if(h<2){if(g||h){setTimeout(function(){this._fireChange({reason:C.Change});}.bind(this),0);}return;}var P=this.oDimensionDetailsSet||{},q=this.oMeasureDetailsSet||{};this.mAnalyticalInfoByProperty={};this.aMaxAggregationLevel=[];this.aAggregationLevel=[];this.aMeasureName=[];if(this.iAnalyticalInfoVersionNumber==undefined){this.iAnalyticalInfoVersionNumber=1;}else if(this.iAnalyticalInfoVersionNumber>999){this.iAnalyticalInfoVersionNumber=1;}else{this.iAnalyticalInfoVersionNumber=this.iAnalyticalInfoVersionNumber+1;}this.oMeasureDetailsSet={};this.oDimensionDetailsSet={};this.aAdditionalSelects=[];this.mHierarchyDetailsByName={};k=this.oAnalyticalQueryResult.getEntityType();for(var i=0;i<e.length;i++){var r=this.oAnalyticalQueryResult.findDimensionByPropertyName(e[i].name);if(r&&(e[i].inResult==true||e[i].visible==true)){e[i].dimensionPropertyName=r.getName();o=this.oDimensionDetailsSet[r.getName()];if(!o){o={};o.name=r.getName();o.aAttributeName=[];o.grouped=false;this.oDimensionDetailsSet[r.getName()]=o;this.aMaxAggregationLevel.push(o.name);if(e[i].grouped==true){this.aAggregationLevel.push(o.name);}}if(e[i].grouped==true){if(!this.getSortablePropertyNames()||this.getSortablePropertyNames().indexOf(r.getName())==-1){x.fatal("property "+r.getName()+" must be sortable in order to be used as grouped dimension");}o.grouped=true;}if(r.getName()==e[i].name){o.keyPropertyName=e[i].name;}var s=r.getTextProperty();if(s&&s.name==e[i].name){o.textPropertyName=e[i].name;}if(r.findAttributeByName(e[i].name)){o.aAttributeName.push(e[i].name);}o.analyticalInfo=e[i];}var M=this.oAnalyticalQueryResult.findMeasureByPropertyName(e[i].name);if(M&&(e[i].inResult==true||e[i].visible==true)){e[i].measurePropertyName=M.getName();var z=this.oMeasureDetailsSet[M.getName()];if(!z){z={};z.name=M.getName();this.oMeasureDetailsSet[M.getName()]=z;this.aMeasureName.push(z.name);}if(M.getRawValueProperty().name==e[i].name){z.rawValuePropertyName=e[i].name;}var I=M.getFormattedValueProperty();if(I&&I.name==e[i].name){z.formattedValuePropertyName=e[i].name;}z.analyticalInfo=e[i];}if(!r&&!M){n(e[i]);}this.mAnalyticalInfoByProperty[e[i].name]=e[i];}Object.keys(this.mHierarchyDetailsByName).forEach(function(N){var O=m.mHierarchyDetailsByName[N];if(!("level"in O)){delete m.mHierarchyDetailsByName[N];if(x.isLoggable(L.Level.INFO)){x.info("No level specified for hierarchy node '"+N+"'; ignoring hierarchy","");}}else if(!m.oDimensionDetailsSet[N]){m.oDimensionDetailsSet[N]={aAttributeName:[],grouped:O.grouped,isHierarchyDimension:true,name:N};m.aMaxAggregationLevel.push(N);if(O.grouped){m.aAggregationLevel.push(N);}}});for(var J in this.oMeasureDetailsSet){var U=this.oAnalyticalQueryResult.findMeasureByName(J).getUnitProperty();if(U){this.oMeasureDetailsSet[J].unitPropertyName=U.name;}}var K=Object.keys(P).sort().join(";")!==Object.keys(this.oDimensionDetailsSet).sort().join(";");if(K){this.iTotalSize=-1;}if(K||Object.keys(q).sort().join(";")!==Object.keys(this.oMeasureDetailsSet).sort().join(";")){this.bApplySortersToGroups=true;}this.aAnalyticalInfo=e;this.resetData();this.bNeedsUpdate=false;if(this.mParameters.select){this.aAdditionalSelects=y(this);}if(g){this._fireChange({reason:C.Change});}};
G.prototype.getAnalyticalInfoForColumn=function(s){return this.mAnalyticalInfoByProperty[s];};
G.prototype.loadGroups=function(g){var e=[];for(var s in g){e.push(s);this._resetData(s);var h=g[s];for(var i=0;i<h.length;i++){var o=h[i];this._getContextsForParentGroupId(s,o.startIndex,o.length,o.threshold);}var r=[];for(var j=-1,k;(k=e[++j])!==undefined;){r.push(this._getRequestId(G._requestType.groupMembersQuery,{groupId:k}));}this._considerRequestGrouping(r);}};
G.prototype.getAnalyticalQueryResult=function(){return this.oAnalyticalQueryResult;};
G._requestType={groupMembersQuery:1,totalSizeQuery:2,groupMembersAutoExpansionQuery:3,levelMembersQuery:4,reloadMeasuresQuery:5};G._artificialRootContextGroupId="artificialRootContext";
G._addHierarchyLevelFilters=function(e,o){e.forEach(function(g){o.removeConditions(g.propertyName);o.addCondition(g.propertyName,a.EQ,g.level);});};
G.prototype._getContextsForParentContext=function(p,s,l,i,e,n,g){if(p===undefined){return[];}if(p&&p.getPath()=="/"+G._artificialRootContextGroupId){p=this.getModel().getContext("/");}var P=this._getGroupIdFromContext(p,e);return this._getContextsForParentGroupId(P,s,l,i,n,g);};
G.prototype._getContextsForParentGroupId=function(p,s,l,e,n,g){if(p===undefined){return[];}if(!s){s=0;}if(!l){l=this.oModel.iSizeLimit;}if(this.mFinalLength[p]&&this.mLength[p]<s+l){l=this.mLength[p]-s;if(l<0){x.fatal("invalid start index greater than total group length passed");}}if(!e){e=0;}if(!n){n=0;}if(p==null){if(n>0){x.fatal("invalid request to determine nodes of root context");return null;}}else{if(this._getGroupIdLevel(p)>=this.aAggregationLevel.length&&n>0){x.fatal("invalid request to determine nodes of context with group ID "+p);return null;}if(this._getGroupIdLevel(p)+n>this.aAggregationLevel.length){n=this.aAggregationLevel.length-this._getGroupIdLevel(p)-1;}}var h=[],k,o,m,q;var r=p==null?0:this._getGroupIdLevel(p)+1;if(!this.aMultiUnitLoadFactor[r]){this.aMultiUnitLoadFactor[r]=1;}var z=n>0&&p!=null;if(z){var M=this._getGroupIdLevel(p);var I=M+n;var J=true;if(!g){m=this._calculateRequiredGroupExpansion(p,I,s,l+e);J=m.groupId_Missing==null;J=J||m.groupId_Missing.length<p.length||m.groupId_Missing.substring(0,p.length)!=p;}if(J){h=this._getLoadedContextsForGroup(p,s,l);}else{q=l+e;}k=!J;q=Math.ceil(q*this.aMultiUnitLoadFactor[r]);}else{h=this._getLoadedContextsForGroup(p,s,l,g);k=false;if(!g){if(this._oWatermark&&p===this._oWatermark.groupID){e=10000;}o=this._calculateRequiredGroupSection(p,s,l,e);var P=o.length>0&&l<o.length;k=(h.length!=l&&!(this.mFinalLength[p]&&h.length>=this.mLength[p]-s))||P;o.length=Math.ceil(o.length*this.aMultiUnitLoadFactor[r]);}}if(!k){this._cleanupGroupingForCompletedRequest(this._getRequestId(G._requestType.groupMembersQuery,{groupId:p}));}var K=false;if(this.oModel.getServiceMetadata()){if(k){var N=this.bProvideTotalSize&&this.iTotalSize==-1&&!this._isRequestPending(this._getRequestId(G._requestType.totalSizeQuery));K=true;var O;if(this.bUseBatchRequests){if(z){O=this._prepareGroupMembersAutoExpansionRequestIds(p,n);for(var i=-1,R;(R=O[++i])!==undefined;){if(this._isRequestPending(R)){K=false;break;}}if(K){this.aBatchRequestQueue.push([G._requestType.groupMembersAutoExpansionQuery,p,m,q,n]);}}else{K=o.length&&!this._isRequestPending(this._getRequestId(G._requestType.groupMembersQuery,{groupId:p}));if(K){this.aBatchRequestQueue.push([G._requestType.groupMembersQuery,p,o.startIndex,o.length]);O=[this._getRequestId(G._requestType.groupMembersQuery,{groupId:p})];}}if(K&&N){O.push(this._getRequestId(G._requestType.totalSizeQuery));this._considerRequestGrouping(O);this.aBatchRequestQueue.push([G._requestType.totalSizeQuery]);}if(K){if(p==null){this._abortAllPendingRequests();}Promise.resolve().then(G.prototype._processRequestQueue.bind(this));}}else{var U;if(z){O=this._prepareGroupMembersAutoExpansionRequestIds(p,n);for(var j=-1,V;(V=O[++j])!==undefined;){if(this._isRequestPending(V)){K=false;break;}}if(K){U=this._prepareGroupMembersAutoExpansionQueryRequest(G._requestType.groupMembersAutoExpansionQuery,p,m,q,n);}}else{K=o.length&&!this._isRequestPending(this._getRequestId(G._requestType.groupMembersQuery,{groupId:p}));if(K){U=this._prepareGroupMembersQueryRequest(G._requestType.groupMembersQuery,p,o.startIndex,o.length);O=[U.sRequestId];}}if(K){if(p==null){this._abortAllPendingRequests();}this._executeQueryRequest(U);if(N&&!U.bIsFlatListRequest){O.push(this._getRequestId(G._requestType.totalSizeQuery));this._considerRequestGrouping(O);this._executeQueryRequest(this._prepareTotalSizeQueryRequest(G._requestType.totalSizeQuery));}}}}}return h;};
G.prototype._getHierarchyLevelFiltersAndAddRecursiveHierarchy=function(o,g){var h,e=[],i=this;if(g===null){return e;}h=Object.keys(this.mHierarchyDetailsByName);if(h.length>0&&g!=="/"){x.error("Hierarchy cannot be requested for members of a group",g);return e;}h.forEach(function(s){var j=i.mHierarchyDetailsByName[s];o.addRecursiveHierarchy(j.dimensionName,!!j.nodeExternalKeyName,!!j.nodeTextName);e.push({propertyName:j.nodeLevelName,level:j.level});});return e;};
G.prototype._getNonHierarchyDimensions=function(e){var g=this;return e.filter(function(s){return!g.oDimensionDetailsSet[s].isHierarchyDimension;});};
G.prototype._processRequestQueue=function(r){if(r===undefined||r===null){r=this.aBatchRequestQueue||[];}if(r.length==0){return;}var R=[];var e=false;var i,o,g;for(i=-1;(g=r[++i])!==undefined;){if(g[0]==G._requestType.groupMembersQuery){o=G.prototype._prepareGroupMembersQueryRequest.apply(this,g);e=e||o.bIsFlatListRequest;R.push(o);}}for(i=-1;(g=r[++i])!==undefined;){o=null;switch(g[0]){case G._requestType.groupMembersQuery:continue;case G._requestType.totalSizeQuery:if(!e){o=G.prototype._prepareTotalSizeQueryRequest.apply(this,g);R.push(o);}break;case G._requestType.groupMembersAutoExpansionQuery:o=G.prototype._prepareGroupMembersAutoExpansionQueryRequest.apply(this,g);for(var j=-1,l;(l=o.aGroupMembersAutoExpansionRequestDetails[++j])!==undefined;){R.push(l);}break;case G._requestType.reloadMeasuresQuery:{var h=g[1];for(var k=-1,m;(m=h[++k])!==undefined;){R.push(m);}break;}default:x.fatal("unhandled request type "+r[i][0]);continue;}}if(R.length>1){this._executeBatchRequest(R);}else{this._executeQueryRequest(R[0]);}if(r===this.aBatchRequestQueue){this.aBatchRequestQueue=[];}};
G.prototype._prepareGroupMembersQueryRequest=function(r,g,s,e){var h=[],m=[],o;var p=new t.QueryResultRequest(this.oAnalyticalQueryResult);p.setResourcePath(this._getResourcePath());p.getSortExpression().clear();var q=0,z=-1;if(g){h=this._getGroupIdComponents(g);q=z=h.length;var U=0;for(var j=0,I=0;j<q;I++){if(this.oDimensionDetailsSet[this.aMaxAggregationLevel[I]].grouped==false){++U;}else{++j;}}q=z=q+U;if(this.aMaxAggregationLevel.length>0){while(this.oDimensionDetailsSet[this.aMaxAggregationLevel[z]].grouped==false){if(++z==this.aMaxAggregationLevel.length){break;}}}}var J=z>=this.aMaxAggregationLevel.length-1;o=this._getHierarchyLevelFiltersAndAddRecursiveHierarchy(p,g);var K=this.aMaxAggregationLevel.slice(0,z+1);var M=this._getNonHierarchyDimensions(K);p.setAggregationLevel(M);for(var i=0;i<M.length;i++){var N=this.oDimensionDetailsSet[M[i]];var O=(N.textPropertyName!=undefined);p.includeDimensionKeyTextAttributes(N.name,true,O,N.aAttributeName);if(N.grouped){m.push({sPath:M[i],bDescending:false});}}var P=p.getFilterExpression();P.clear();if(this.aApplicationFilter){P.addUI5FilterConditions(this.aApplicationFilter);}if(this.aControlFilter){P.addUI5FilterConditions(this.aControlFilter);}if(q>=1){for(var k=0,l=h.length;k<l;k++){P.removeConditions(this.aAggregationLevel[k]);P.addCondition(this.aAggregationLevel[k],a.EQ,h[k]);}}G._addHierarchyLevelFilters(o,P);var R;var V;var W;var X;var Y=[];if(g!=null||this.bProvideGrandTotals||(this._canApplySortersToGroups()&&this.aSorter.length>0)){p.setMeasures(this.aMeasureName);for(var Z in this.oMeasureDetailsSet){X=this.oMeasureDetailsSet[Z];if(!J&&this.mAnalyticalInfoByProperty[Z].total==false){R=false;V=false;W=false;}else{R=(X.rawValuePropertyName!=undefined);V=(X.formattedValuePropertyName!=undefined);W=(X.unitPropertyName!=undefined);if(W){if(Y.indexOf(X.unitPropertyName)==-1){Y.push(X.unitPropertyName);}}}p.includeMeasureRawFormattedValueUnit(X.name,R,V,W);}for(var n in M){var $;if(($=Y.indexOf(M[n]))!=-1){Y.splice($,1);}}}if(g){this._addSorters(p.getSortExpression(),m);}if(e==0){x.fatal("unhandled case: load 0 entities of sub group");}var _=this._getKeyIndexMapping(g,s);if(!this.bNoPaging){p.setResultPageBoundaries(_.iServiceKeyIndex+1,_.iServiceKeyIndex+e);}p.setRequestOptions(null,!this.mFinalLength[g]);return{iRequestType:r,sRequestId:this._getRequestId(G._requestType.groupMembersQuery,{groupId:g}),oAnalyticalQueryRequest:p,sGroupId:g,aSelectedUnitPropertyName:Y,aAggregationLevel:K,bIsFlatListRequest:J&&q==0,bIsLeafGroupsRequest:J,iStartIndex:s,iLength:e,oKeyIndexMapping:_};};
G.prototype._prepareTotalSizeQueryRequest=function(r){var h;var o=new t.QueryResultRequest(this.oAnalyticalQueryResult);o.setResourcePath(this._getResourcePath());h=this._getHierarchyLevelFiltersAndAddRecursiveHierarchy(o,"/");o.setAggregationLevel(this._getNonHierarchyDimensions(this.aMaxAggregationLevel));o.setMeasures([]);var e=o.getFilterExpression();e.clear();if(this.aApplicationFilter){e.addUI5FilterConditions(this.aApplicationFilter);}if(this.aControlFilter){e.addUI5FilterConditions(this.aControlFilter);}G._addHierarchyLevelFilters(h,e);o.setRequestOptions(null,null,true);o.setRequestOptions(null,true);return{iRequestType:r,sRequestId:this._getRequestId(G._requestType.totalSizeQuery),oAnalyticalQueryRequest:o};};
G.prototype._prepareGroupMembersAutoExpansionQueryRequest=function(r,g,o,e,n){var h=this;var p=function(o,s){var J=[];if(o.groupId_Missing==null){x.fatal("missing group Id not present");return J;}var z=h._getGroupIdComponents(o.groupId_Missing);var I=z.length;if(I>s){x.fatal("the given group ID is too deep for requested level for auto expansion");return J;}var k=[];for(var i=0;i<I;i++){var l=h.aAggregationLevel[i];var Z=z[i];var $=h._getFilterOperatorMatchingPropertySortOrder(l);k[i]=new F(l,$,Z);}var _=null;if(o.startIndex_Missing>0){var a1=h._getKey(o.groupId_Missing,o.startIndex_Missing-1);var b1=h.oModel.getObject("/"+a1);var c1=h.aAggregationLevel[I];var d1=b1[c1];_=new F(c1,h._getFilterOperatorMatchingPropertySortOrder(c1,false),d1);}for(var M=0;M<s;M++){var e1=[];var f1=Math.min(I,M+1);for(var g1=0;g1<f1;g1++){var h1=[];var i1=Math.min(I,g1+1);var j1=o.startIndex_Missing>0;for(var k1=0;k1<i1;k1++){var l1=new F("x",a.EQ,"x");l1=Q.extend(true,l1,k[k1]);if(i1>1&&k1<i1-1){l1.sOperator=a.EQ;}if(k1==I-1&&M>I-1&&!j1){if(l1.sOperator==a.GT){l1.sOperator=a.GE;}else{l1.sOperator=a.LE;}}h1.push(l1);}if(h1.length>0){e1.push(new F(h1,true));if(M>I-1&&g1==I-1&&j1){var m1=[];for(var j=0;j<h1.length;j++){var n1=new F("x",a.EQ,"x");n1=Q.extend(true,n1,h1[j]);m1.push(n1);}m1[I-1].sOperator=a.EQ;m1.push(_);e1.push(new F(m1,true));break;}}}if(e1.length>0){J[M]=new F(e1,false);}else{J[M]=null;}}return J;};var m=function(r,g,M,Z,N,e,$,_){var a1;var b1=new t.QueryResultRequest(h.oAnalyticalQueryResult);b1.setResourcePath(h._getResourcePath());b1.getSortExpression().clear();var c1=0,d1=-1;c1=d1=M-1;var e1=0;for(var i=0,f1=0;i<c1;f1++){if(h.oDimensionDetailsSet[h.aMaxAggregationLevel[f1]].grouped==false){++e1;}else{++i;}}c1=d1=c1+e1;if(h.aMaxAggregationLevel.length>0){while(h.aMaxAggregationLevel[d1]&&h.oDimensionDetailsSet[h.aMaxAggregationLevel[d1]].grouped==false){if(++d1==h.aMaxAggregationLevel.length){break;}}}var g1=d1>=h.aMaxAggregationLevel.length-1;a1=h._getHierarchyLevelFiltersAndAddRecursiveHierarchy(b1,g);var h1=h.aMaxAggregationLevel.slice(0,d1+1);b1.setAggregationLevel(h1);for(var l=0;l<h1.length;l++){var i1=h.oDimensionDetailsSet[h1[l]];var j1=(i1.textPropertyName!=undefined);b1.includeDimensionKeyTextAttributes(i1.name,true,j1,i1.aAttributeName);if(i1.grouped){b1.getSortExpression().addSorter(h1[l],t.SortOrder.Ascending);}}var k1=b1.getFilterExpression();k1.clear();if(h.aApplicationFilter){k1.addUI5FilterConditions(h.aApplicationFilter);}if(h.aControlFilter){k1.addUI5FilterConditions(h.aControlFilter);}if(Z){k1.addUI5FilterConditions([Z]);}G._addHierarchyLevelFilters(a1,k1);var l1;var m1;var n1;var o1;var p1=[];b1.setMeasures(h.aMeasureName);for(var q1 in h.oMeasureDetailsSet){o1=h.oMeasureDetailsSet[q1];if(!g1&&h.mAnalyticalInfoByProperty[q1].total==false){l1=false;m1=false;n1=false;}else{l1=(o1.rawValuePropertyName!=undefined);m1=(o1.formattedValuePropertyName!=undefined);n1=(o1.unitPropertyName!=undefined);if(n1){if(p1.indexOf(o1.unitPropertyName)==-1){p1.push(o1.unitPropertyName);}}}b1.includeMeasureRawFormattedValueUnit(o1.name,l1,m1,n1);}for(var j in h1){var r1;if((r1=p1.indexOf(h1[j]))!=-1){p1.splice(r1,1);}}var s1=b1.getSortExpression();for(var k=0;k<h.aSorter.length;k++){if(h.aSorter[k]){s1.addSorter(h.aSorter[k].sPath,h.aSorter[k].bDescending?t.SortOrder.Descending:t.SortOrder.Ascending);}}if(e==0){x.fatal("unhandled case: load 0 entities of sub group");}var t1=N;if(!_){t1=0;}else{var u1=0;for(var v1 in h.mServiceKey){if(v1.split("/").length===M+1){u1+=h.mServiceKey[v1].length;}}t1=Math.max(t1,u1);}if(!h.bNoPaging){b1.setResultPageBoundaries(t1+1,t1+e);}return{iRequestType:r,sRequestId:null,oAnalyticalQueryRequest:b1,iLevel:M,aSelectedUnitPropertyName:p1,aAggregationLevel:h1,bIsFlatListRequest:g1,bIsLeafGroupsRequest:g1,iStartIndex:N,iLength:e,bAvoidLengthUpdate:$};};var q=[];var R=[];if(!o){x.fatal("no first missing group member specified");}var s=this._getGroupIdLevel(g)+n+1;var z=h._getGroupIdComponents(o.groupId_Missing);var I=z.length;var J=p(o,s);var K;for(var M=1;M<=s;M++){var N;if(M>=I+2){N=0;K=undefined;}else if(M==I+1){N=o.startIndex_Missing;K=o.groupId_Missing;}else if(I>0){if(M==I){K=o.groupId_Missing;}else{K=this._getGroupIdAncestors(o.groupId_Missing,-(I-M))[0];}var O=this._getGroupIdAncestors(o.groupId_Missing,-(I-M+1))[0];if(!O){x.fatal("failed to determine group id at parent level; group ID = "+g+", level = "+M);}N=this._findKeyIndex(O,this.mEntityKey[K]);if(N==-1){x.fatal("failed to determine position of value "+K+" in group "+O);}K=O;N++;}var P=e>M?Math.ceil((e-M)/(s-M+1)):e;var U=J[M-1];if(this.bUseAcceleratedAutoExpand){var V=m(G._requestType.levelMembersQuery,g,M,U,N,P,false,U==null?true:false);V.sGroupId_Missing_AtLevel=K;V.sRequestId=this._getRequestId(G._requestType.levelMembersQuery,{groupId:g,level:M});q.push(V);R.push(V.sRequestId);}else if(U&&U.aFilters.length>0){if(!U._bMultiFilter||U.bAnd){x.fatal("level filter in wrong shape; cannot break it up");}for(var i=0;i<U.aFilters.length;i++){var W=U.aFilters[i];var X=m(G._requestType.levelMembersQuery,g,M,W,N,P,false,U==null?true:false);X.sGroupId_Missing_AtLevel=K;X.sRequestId=this._getRequestId(G._requestType.levelMembersQuery,{groupId:g,level:M,tupleIndex:i});q.push(X);R.push(X.sRequestId);}}else{var Y=m(G._requestType.levelMembersQuery,g,M,null,N,P,false,U==null?true:false);Y.sGroupId_Missing_AtLevel=K;Y.sRequestId=this._getRequestId(G._requestType.levelMembersQuery,{groupId:g,level:M});q.push(Y);R.push(Y.sRequestId);}}return{iRequestType:r,aRequestId:R,aGroupMembersAutoExpansionRequestDetails:q,sGroupId:g,iLength:e};};
G.prototype._prepareReloadMeasurePropertiesQueryRequest=function(r,g,m){var o=new t.QueryResultRequest(this.oAnalyticalQueryResult);o.setResourcePath(this._getResourcePath());o.getSortExpression().clear();var e=g.aAggregationLevel;o.setAggregationLevel(e);var I=g.bIsLeafGroupsRequest;var h=o.getFilterExpression();h.clear();if(this.aApplicationFilter){h.addUI5FilterConditions(this.aApplicationFilter);}if(this.aControlFilter){h.addUI5FilterConditions(this.aControlFilter);}var k=[];for(var i=0;i<e.length;i++){var l=new F(e[i],a.EQ,m.oEntry[e[i]]);k.push(l);}h.addUI5FilterConditions(k);var n;var p;var q;var M;var s=[];o.setMeasures(m.aReloadMeasurePropertyName);for(var z in this.oMeasureDetailsSet){M=this.oMeasureDetailsSet[z];if(!m.aReloadMeasurePropertyName||m.aReloadMeasurePropertyName.indexOf(M.name)==-1){continue;}if(!I&&this.mAnalyticalInfoByProperty[z].total==false){n=false;p=false;q=false;}else{n=(M.rawValuePropertyName!=undefined);p=(M.formattedValuePropertyName!=undefined);q=(M.unitPropertyName!=undefined);if(q){if(s.indexOf(M.unitPropertyName)==-1){s.push(M.unitPropertyName);}}}o.includeMeasureRawFormattedValueUnit(M.name,n,p,q);}for(var j in e){var J;if((J=s.indexOf(e[j]))!=-1){s.splice(J,1);}}return{iRequestType:r,sRequestId:this._getRequestId(G._requestType.reloadMeasuresQuery,{multiUnitEntryKey:this.oModel.getKey(m.oEntry)}),oAnalyticalQueryRequest:o,aSelectedUnitPropertyName:s,aAggregationLevel:e,oMultiUnitRepresentative:m};};
G.prototype._prepareGroupMembersAutoExpansionRequestIds=function(g,n){var m=this._getGroupIdLevel(g)+1;var i=m+n;var r=[];for(var l=m;l<=i;l++){r.push(this._getRequestId(G._requestType.levelMembersQuery,{groupId:g,level:l}));}return r;};
G.prototype._getQueryODataRequestOptions=function(o,g,p){var i;p=p||{};try{o.getFilterExpression().checkValidity();}catch(e){x.fatal("filter expression is not valid",e.toString());return undefined;}var s=o.getURIQueryOptionValue("$select");var h=o.getURIQueryOptionValue("$filter");var O=o.getURIQueryOptionValue("$orderby");var j=o.getURIQueryOptionValue("$skip");var k=o.getURIQueryOptionValue("$top");var I=o.getURIQueryOptionValue("$inlinecount");if(g&&this.aAdditionalSelects.length>0){s=(s?s.split(","):[]).concat(this.aAdditionalSelects).join(",");}if(this.mParameters&&this.mParameters["filter"]){if(h===null){h=this.mParameters["filter"];}else{h+="and ("+this.mParameters["filter"]+")";}}var P=[];if(s!==null){P.push("$select="+s);}if(h!==null){P.push("$filter="+h);}if(O!==null){P.push("$orderby="+O);}if(j!==null){P.push("$skip="+j);}if(k!==null){P.push("$top="+k);}if(I!==null){P.push("$inlinecount="+I);}if(p.encode===true){for(i=0;i<P.length;i++){P[i]=P[i].replace(/\ /g,"%20");}}return P;};
G.prototype._executeBatchRequest=function(r){var e=this.iAnalyticalInfoVersionNumber,R,g=this;var h=[],l=[];function m(){g.fireDataReceived({__simulateAsyncAnalyticalBinding:true});}var o=new B();function s(j,k){o.success(k);}function n(j,k){o.error(k||j);}this.bNeedsUpdate=true;for(var p=0;p<r.length;p++){var q=r[p];if(q.aAggregationLevel&&q.aAggregationLevel.length>0){this.bNeedsUpdate=false;}}for(var i=-1,z;(z=r[++i])!==undefined;){var I=z.oAnalyticalQueryRequest,J=z.sGroupId;if(I.getURIQueryOptionValue("$select")==null){this.fireDataRequested({__simulateAsyncAnalyticalBinding:true});J=null;this.mServiceLength[J]=this.mLength[J]=1;this.mServiceFinalLength[J]=true;this._setServiceKey(this._getKeyIndexMapping(J,0),G._artificialRootContextGroupId);setTimeout(m);this.bArtificalRootContext=true;continue;}var P=I.getURIToQueryResultEntries();if(!this.oContext&&P[0]!=="/"){P="/"+P;}if(!this._isRequestPending(z.sRequestId)){this._registerNewRequest(z.sRequestId);if(this.iModelVersion===A.V1){h.push(this.oModel.createBatchOperation(P.replace(/\ /g,"%20"),"GET"));}else if(this.iModelVersion===A.V2){var U=this._getQueryODataRequestOptions(I,z.bIsLeafGroupsRequest,{encode:true});if(this.sCustomParams){U.push(this.sCustomParams);}var K=this.oModel.read(P.replace(/\ /g,"%20"),{success:s,error:n,context:this.oContext,urlParameters:U});h.push(K);}l.push(z);}}if(h.length>0){x.debug("AnalyticalBinding: executing batch request with "+l.length+" operations");var M;R=this._getIdForNewRequestHandle();this.fireDataRequested();if(this.iModelVersion===A.V1){this.oModel.addBatchReadOperations(h);M=this.oModel.submitBatch(N,O,true,true);this.oModel.fireRequestSent({url:this.oModel.sServiceUrl+"/$batch",type:"POST",async:true,info:"",infoObject:{}});}else{M={abort:function(){for(var j=0;j<h.length;j++){h[j].abort();}}};o.setup({executedRequests:l,binding:this,success:N,error:O});}this._registerNewRequestHandle(R,M);}function N(V,W){g._deregisterHandleOfCompletedRequest(R);if(l.length!=V.__batchResponses.length){x.fatal("assertion failed: received "+V.__batchResponses.length+" responses for "+l.length+" read operations in the batch request");}if(e!=g.iAnalyticalInfoVersionNumber){for(var j=0;j<l.length;j++){var X=l[j].sRequestId;if(X!==undefined){g._deregisterCompletedRequest(X);g._cleanupGroupingForCompletedRequest(X);}}g.fireDataReceived({data:[]});return;}var Y=0;for(var k=0;k<V.__batchResponses.length;k++){if(V.__batchResponses[k].data!=undefined){if(V.__batchResponses[k].data.results.length==0){Y++;}switch(l[k].iRequestType){case G._requestType.groupMembersQuery:g._processGroupMembersQueryResponse(l[k],V.__batchResponses[k].data);break;case G._requestType.totalSizeQuery:g._processTotalSizeQueryResponse(l[k],V.__batchResponses[k].data);break;case G._requestType.levelMembersQuery:g._processLevelMembersQueryResponse(l[k],V.__batchResponses[k].data);break;case G._requestType.reloadMeasuresQuery:g._processReloadMeasurePropertiesQueryResponse(l[k],V.__batchResponses[k].data);break;default:x.fatal("invalid request type "+l[k].iRequestType);continue;}}g._deregisterCompletedRequest(l[k].sRequestId);g._cleanupGroupingForCompletedRequest(l[k].sRequestId);}if(g.mParameters&&g.mParameters.numberOfExpandedLevels>0){if(Y==V.__batchResponses.length){g.mLength["/"]=0;g.mFinalLength["/"]=true;}}var Z=true;var $;g.fireDataReceived({data:V});var _={};if(g.iModelVersion===A.V1){$=g.oModel._getBatchErrors(V);if($.length>0){Z=false;_=g.oModel._handleError($[0]);}g.oModel.fireRequestCompleted({url:W.requestUri,type:"POST",async:true,info:"",infoObject:{},success:Z,errorobject:Z?{}:_});if(Z){g.oModel.checkUpdate();}}}function O(k){if(k&&k.statusText!="abort"){g._deregisterHandleOfCompletedRequest(R);for(var j=-1,V;(V=l[++j])!==undefined;){g._deregisterCompletedRequest(V.sRequestId);g._cleanupGroupingForCompletedRequest(V.sRequestId);}}if(e!=g.iAnalyticalInfoVersionNumber){return;}var W=k;if(g.iModelVersion===A.V1){W=g.oModel._handleError(k);}g.oModel.fireRequestCompleted({url:"",type:"POST",async:true,info:"",infoObject:{},success:false,errorobject:W});if(g.iModelVersion===A.V1){g.oModel.fireRequestFailed(W);}g.fireDataReceived();}};
G.prototype._executeQueryRequest=function(r){if(r.iRequestType==G._requestType.groupMembersAutoExpansionQuery){for(var i=-1,o;(o=r.aGroupMembersAutoExpansionRequestDetails[++i])!==undefined;){this._executeQueryRequest(o);}return;}var e=this.iAnalyticalInfoVersionNumber;var g=r.oAnalyticalQueryRequest,s=r.sGroupId;var p=g.getURIToQueryResultEntitySet();var P=this._getQueryODataRequestOptions(g,r.bIsLeafGroupsRequest);if(!P){return;}var h=this;if(g.getURIQueryOptionValue("$select")==null){this.fireDataRequested({__simulateAsyncAnalyticalBinding:true});s=null;this.mServiceLength[s]=this.mLength[s]=1;this.mServiceFinalLength[s]=true;this._setServiceKey(this._getKeyIndexMapping(s,0),G._artificialRootContextGroupId);this.bNeedsUpdate=true;setTimeout(function(){if(h._cleanupGroupingForCompletedRequest(r.sRequestId)){h.fireDataReceived({__simulateAsyncAnalyticalBinding:true});}});this.bArtificalRootContext=true;return;}this._registerNewRequest(r.sRequestId);this.fireDataRequested();for(var j=0;j<P.length;j++){P[j]=P[j].replace(/\ /g,"%20");}x.debug("AnalyticalBinding: executing query request");var R=this._getIdForNewRequestHandle();if(this.iModelVersion===A.V1){this.oModel._loadData(p,P,l,n,false,U,m);}else{if(this.sCustomParams){P.push(this.sCustomParams);}var k=this.oModel.read(p.replace(/ /g,"%20"),{success:l,error:n,context:this.oContext,urlParameters:P});h._registerNewRequestHandle(R,k);}function l(q){h._deregisterHandleOfCompletedRequest(R);if(e!=h.iAnalyticalInfoVersionNumber){h._deregisterCompletedRequest(r.sRequestId);return;}switch(r.iRequestType){case G._requestType.groupMembersQuery:h._processGroupMembersQueryResponse(r,q);break;case G._requestType.totalSizeQuery:h._processTotalSizeQueryResponse(r,q);break;case G._requestType.levelMembersQuery:h._processLevelMembersQueryResponse(r,q);break;case G._requestType.reloadMeasuresQuery:h._processReloadMeasurePropertiesQueryResponse(r,q);break;default:x.fatal("invalid request type "+r.iRequestType);break;}h._deregisterCompletedRequest(r.sRequestId);if(h.iModelVersion===A.V2){m(q);}}function m(q){if(e!=h.iAnalyticalInfoVersionNumber){return;}if(h._cleanupGroupingForCompletedRequest(r.sRequestId)){h.fireDataReceived({data:q});}}function n(q){if(q&&q.statusText=="abort"){h.fireDataReceived();return;}h._deregisterHandleOfCompletedRequest(R);h._deregisterCompletedRequest(r.sRequestId);h._cleanupGroupingForCompletedRequest(r.sRequestId);if(e!=h.iAnalyticalInfoVersionNumber){return;}h.fireDataReceived();}function U(k){h._registerNewRequestHandle(R,k);}};
G.prototype._abortAllPendingRequests=function(){this._abortAllPendingRequestsByHandle();this._clearAllPendingRequests();};
G.prototype._processGroupMembersQueryResponse=function(R,e){var s,n=R.sGroupId,z=this.aSorter.length>0,I=R.aSelectedUnitPropertyName,J=R.aAggregationLevel,K=R.oKeyIndexMapping.iIndex,M=R.oKeyIndexMapping.iServiceKeyIndex,N=R.iLength,O=R.oKeyIndexMapping,P=n==null?0:this._getGroupIdLevel(n)+1,U=(I.length>0),V,W,X,Y=0,Z,$,_=[];var a1=e.results.length;if(n===null&&a1>1&&this._canApplySortersToGroups()){this._warnNoSortingOfGroups(z?"binding is refreshed":undefined);if(z){setTimeout(this.refresh.bind(this),0);return;}}var b1=this._getServiceKeys(n,O.iIndex-1);V=undefined;if(b1&&b1.length>0){for(var i=0,c1=b1.length;i<c1;i++){e.results[i-c1]=this.oModel.getObject("/"+b1[i]);}var d1=e.results[-b1.length];V="";for(var j=0;j<J.length;j++){V+=d1[J[j]]+"|";}}Z=b1&&b1.length==1;for(var h=0;h<a1;h++){var e1=e.results[h];if(U){W="";for(var g=0;g<J.length;g++){W+=e1[J[g]]+"|";}if(V==W){this._warnNoSortingOfGroups();if(X===undefined){if(h==0){X=-b1.length;O.iServiceKeyIndex-=b1.length-1;}else{X=h-1;}}var f1=-1,g1=e.results[h-1];for(var k=0;k<I.length;k++){if(g1[I[k]]!=e1[I[k]]){f1=k;break;}}if(f1==-1){x.fatal("assertion failed: no deviating units found for result entries "+(h-1)+" and "+h,null,null,H(this,"NO_DEVIATING_UNITS"));}}if((V!=W||h==a1-1)&&X!==undefined){var h1=[];for(var l=X;l<h;l++){h1.push(e.results[l]);}if(V==W){h1.push(e.results[h]);}var i1=[];for(var m=0;m<I.length;m++){var j1=I[m];for(var o=1;o<h1.length;o++){if(h1[o-1][j1]!=h1[o][j1]){i1.push(j1);break;}}}var k1=this._createMultiUnitRepresentativeEntry(n,e.results[X],I,i1,R.bIsFlatListRequest);if(k1.aReloadMeasurePropertyName.length>0){$=this._prepareReloadMeasurePropertiesQueryRequest(G._requestType.reloadMeasuresQuery,R,k1);if($.oAnalyticalQueryRequest&&$.oAnalyticalQueryRequest.getURIQueryOptionValue("$select")!=null){_.push($);}}var l1=this._setAdjacentMultiUnitKeys(O,k1,h1);var m1;if(k1.bIsNewEntry){m1=h1.length-1;}else{m1=l1;}if(Z){Z=false;}if(m1<0){x.fatal("assertion failed: iDiscardedEntriesCount must be non-negative");}Y+=m1;var n1=this.oModel._getKey(k1.oEntry);var o1=this.oModel.getContext('/'+n1);this._getGroupIdFromContext(o1,P);this.mEntityKey[s]=n1;X=undefined;if(V!=W){Z=this._setServiceKey(O,this.oModel._getKey(e1));}}else if(V!=W){Z=this._setServiceKey(O,this.oModel._getKey(e1));}V=W;}else{this._setServiceKey(O,this.oModel._getKey(e1));}if(!R.bIsLeafGroupsRequest){var p1=this._getKey(n,O.iIndex-1);s=this._getGroupIdFromContext(this.oModel.getContext('/'+p1),P);this.mEntityKey[s]=p1;}}var q1=[];if(this.bReloadSingleUnitMeasures&&_.length>0){if(this.bUseBatchRequests){this.aBatchRequestQueue.push([G._requestType.reloadMeasuresQuery,_]);Promise.resolve().then(G.prototype._processRequestQueue.bind(this));}else{for(var q=0;q<_.length;q++){var r1=_[q];this._executeQueryRequest(r1);}}for(var p=0;p<_.length;p++){var s1=_[p];q1.push(s1.sRequestId);}this._considerRequestGrouping(q1);}if(b1&&b1.length>0){for(var r=0,t1=b1.length;r<t1;r++){delete e.results[r-t1];}}if(U){Y+=this._mergeLoadedKeyIndexWithSubsequentIndexes(O,J,I,R.bIsFlatListRequest);}if(!R.bAvoidLengthUpdate){var u1=false;if(e.__count){this.mServiceLength[n]=parseInt(e.__count);this.mLength[n]=this.mServiceLength[n]-Y;this.mFinalLength[n]=true;if(R.bIsFlatListRequest){this.iTotalSize=e.__count;}u1=true;}if(!(n in this.mServiceLength)||this.mServiceLength[n]<M+a1){this.mServiceLength[n]=M+a1;this.mLength[n]=K+a1-Y;this.mFinalLength[n]=false;}if(a1<N||N===undefined){this.mServiceLength[n]=M+a1;this.mLength[n]=K+O.iIndex-K;this.mFinalLength[n]=true;u1=true;}if(a1==0){this.mLength[n]=this.mServiceLength[n]=0;this.mFinalLength[n]=true;u1=true;}if(!u1&&this.mLength[n]!==undefined&&Y>0){this.mLength[n]-=Y;}}this.bNeedsUpdate=true;if(Y>0){if(e.results.length-Y>0){this.aMultiUnitLoadFactor[J.length]=e.results.length/(e.results.length-Y);}if(this.aMultiUnitLoadFactor[J.length]<1.5){this.aMultiUnitLoadFactor[J.length]=2;}}x.info("MultiUnit Situation in Group ("+n+"), discarded: "+Y+", load-factor is now: "+this.aMultiUnitLoadFactor[J.length]);};
G.prototype._processTotalSizeQueryResponse=function(r,o){if(o.__count==undefined){x.fatal("missing entity count in query result");return;}this.iTotalSize=o.__count;};
G.prototype._processLevelMembersQueryResponse=function(r,o){var e=this;var p,P;var g=function(h,I){var l={iRequestType:G._requestType.groupMembersQuery,sRequestId:e._getRequestId(G._requestType.groupMembersQuery,{groupId:p}),oAnalyticalQueryRequest:r.oAnalyticalQueryRequest,sGroupId:p,aSelectedUnitPropertyName:r.aSelectedUnitPropertyName,aAggregationLevel:r.aAggregationLevel,bIsFlatListRequest:r.bIsFlatListRequest,bIsLeafGroupsRequest:r.bIsLeafGroupsRequest,iStartIndex:h?r.iStartIndex:0,iLength:r.iLength,bAvoidLengthUpdate:r.bAvoidLengthUpdate};if(h&&r.iStartIndex>0&&(r.sGroupId_Missing_AtLevel!=l.sGroupId||e._getKeys(l.sGroupId)===undefined)){var s=e._getParentGroupId(l.sGroupId);var m=e._findKeyIndex(s,e.mEntityKey[l.sGroupId]);if(m<0){x.fatal("assertion failed: failed to determine position of "+l.sGroupId+" in group "+s);}else if(!m){e.mFinalLength[r.sGroupId_Missing_AtLevel]=true;}else if(e._getKey(s,m-1)!==undefined){var n=e._getKey(s,m-1);var q=e._getGroupIdFromContext(e.oModel.getContext('/'+n),e._getGroupIdLevel(l.sGroupId));e.mFinalLength[q]=true;l.iStartIndex=0;}}if(I){l.iLength=P.length;}l.oKeyIndexMapping=e._getKeyIndexMapping(l.sGroupId,l.iStartIndex);var z=Q.extend(true,{},o);z.results=P;e._processGroupMembersQueryResponse(l,z);};if(o.results.length==0){return;}p=this._getGroupIdFromContext(this.oModel.getContext("/"+this.oModel._getKey(o.results[0])),r.iLevel-1);P=[];var h=true;for(var i=0;i<o.results.length;i++){var j=o.results[i];var k=this.oModel.getContext("/"+this.oModel._getKey(o.results[i]));var s=this._getGroupIdFromContext(k,r.iLevel-1);if(p==s){P.push(j);if(i<o.results.length-1){continue;}}g(h,o.results.length==r.iLength&&i==o.results.length-1);h=false;if(p!=s){P=[j];}p=s;}if(o.results.length>1&&P.length==1){g(h,o.results.length==r.iLength);}};
G.prototype._processReloadMeasurePropertiesQueryResponse=function(r,o){var m=r.oMultiUnitRepresentative;var M=this.oModel.getKey(m.oEntry);if(o.results.length!=1){x.fatal("assertion failed: more than one entity for reloaded measure properties of entity with key "+M);return;}var R=o.results[0];var e=this.oModel.getObject("/"+M);if(!e){x.fatal("assertion failed: no entity found with key "+M);return;}var g=m.aReloadMeasurePropertyName;for(var i=0;i<g.length;i++){e[g[i]]=R[g[i]];}};
G.prototype._getLoadedContextsForGroup=function(g,s,l,e){var h=[],o,i,k=this._getKeys(g),K;if(!k){return h;}if(!s){s=0;}if(!l){l=this.oModel.iSizeLimit;if(this.mFinalLength[g]){l=this.mLength[g];}}if(e){i=s||0;K=k(i);while(K){o=this.oModel.getContext('/'+K);h.push(o);i++;K=k(i);}return h;}for(i=s;i<s+l;i++){K=k(i);if(!K){break;}o=this.oModel.getContext('/'+K);h.push(o);}return h;};
G.prototype._calculateRequiredGroupSection=function(g,s,l,i){var e=this._getKeys(g);if(s>=i){s-=i;l+=i;}else{l+=s;s=0;}l+=i;if(this.mFinalLength[g]&&s+l>this.mLength[g]){l=this.mLength[g]-s;}if(e){while(l&&e(s)){s+=1;l-=1;}while(l&&e(s+l-1)){l-=1;}}return{startIndex:s,length:l};};
G.prototype._calculateRequiredGroupExpansion=function(g,e,s,l){var n={groupId_Missing:null,length_Missing:0};var h=this;var j=function(g,e,s,l){var k=h._getGroupIdLevel(g);if(k==e){var I=h._getLoadedContextsForGroup(g,s,l);var J=s+I.length-1;if(I.length>=l){return n;}else if(h.mFinalLength[g]){if(I.length>=h.mLength[g]){return{groupId_Missing:null,length_Missing:l-I.length};}else{return{groupId_Missing:g,startIndex_Missing:J+1,length_Missing:l-I.length};}}else{return{groupId_Missing:g,startIndex_Missing:J+1,length_Missing:l-I.length};}}var K=h._getLoadedContextsForGroup(g,s,l);var m=l,M=s+K.length-1;for(var i=-1,N;(N=K[++i])!==undefined;){m--;var p=j(h._getGroupIdFromContext(N,k+1),e,0,m);if(p.groupId_Missing==null){if(p.length_Missing==0){return p;}else{m=p.length_Missing;}}else{return p;}if(m==0){break;}}if(h.mFinalLength[g]||m==0){return{groupId_Missing:null,length_Missing:m};}else{return{groupId_Missing:g,startIndex_Missing:M+1,length_Missing:m};}};var k=this._getGroupIdLevel(g);if(k==e+1){g=this._getParentGroupId(g);--k;}if(g==null||k>e){return n;}var m=l,o=s;while(g!=null){var p=j(g,e,o,m);if(p.groupId_Missing!=null){return p;}else if(p.length_Missing==0){return p;}else{var q=false;while(!q){var P=this._getParentGroupId(g);if(P==null){g=P;--k;break;}var r=this.mEntityKey[g];if(!r){return n;}var z=this._findKeyIndex(P,r);if(z==-1){return n;}if(z==this._getKeyCount(P)-1){if(this.mFinalLength[P]){g=P;--k;continue;}else{return{groupId_Missing:P,startIndex_Missing:z+1,length_Missing:m};}}else{r=this._getKey(P,z+1);g=this._getGroupIdFromContext(this.oModel.getContext('/'+r),k);q=true;}}o=0;m=p.length_Missing;}}return{groupId_Missing:null,length_Missing:m};};
G.prototype._getResourcePath=function(){return this.isRelative()?this.oModel.resolve(this.sPath,this.getContext()):this.sPath;};
G.prototype._getEntitySet=function(){var e=this.sEntitySetName;if(!e){e=this.sPath.split("/")[1];if(e.indexOf("(")!=-1){e=e.split("(")[0]+"Results";}}return e;};
G.prototype._getEffectiveSortOrder=function(p){for(var i=0;i<this.aSorter.length;i++){if(this.aSorter[i]&&this.aSorter[i].sPath==p){return this.aSorter[i].bDescending?t.SortOrder.Descending:t.SortOrder.Ascending;}}return null;};
G.prototype._getFilterOperatorMatchingPropertySortOrder=function(p,W){var s;switch(this._getEffectiveSortOrder(p)){case t.SortOrder.Ascending:if(W){s=a.GE;}else{s=a.GT;}break;case t.SortOrder.Descending:if(W){s=a.LE;}else{s=a.LT;}break;default:s=a.GT;}return s;};
G.prototype._convertDeprecatedFilterObjects=function(e){if(!e){return e;}var O=sap.ui.require("sap/ui/model/odata/Filter");if(typeof O==='function'){for(var i=0,l=e.length;i<l;i++){if(e[i]instanceof O){e[i]=e[i].convert();}}}return e;};
G.prototype._getGroupIdFromContext=function(o,l){if(!o){return null;}var g="/";var s=null;if(l>this.aAggregationLevel.length){x.fatal("assertion failed: aggregation level deeper than number of current aggregation levels");}for(var i=0;i<l;i++){s=o.getProperty(this.aAggregationLevel[i]);if(s!=null){if(s.__edmType==="Edm.Time"){s=s.ms;}g+=encodeURIComponent(s)+"/";}else{g+="@/";}}return g;};
G.prototype._getGroupIdLevel=function(g){if(g==null){x.fatal("assertion failed: no need to determine level of group ID = null");return-1;}return g.split("/").length-2;};
G.prototype._getGroupIdComponents=function(g){if(g==null){return null;}var e=g.split("/");var h=[];for(var i=1;i<e.length-1;i++){if(e[i]=="@"){h[i-1]=null;}else{h[i-1]=decodeURIComponent(e[i]);}}return h;};
G.prototype._getGroupIdAncestors=function(g,n){if(!n){return[];}if(g==null){x.fatal("group ID null does not have ancestors");return[];}if(g=="/"){if(Math.abs(n)==1){return[null];}else{x.fatal("invalid level count "+n+" for ancestors of groupId "+g);return[];}}var e=g.split("/");var h=[],s="";var k=0,l=e.length-3;if(n>0){if(n-1>l){x.fatal("invalid level count "+n+" for ancestors of groupId "+g);}else{l=n-1;}}else if(-(n+1)>l){x.fatal("invalid level count "+n+" for ancestors of groupId "+g);}else{k=l+1+n;for(var i=0;i<k;i++){s+=e[i]+"/";}}for(var j=k;j<=l;j++){s+=e[j]+"/";h.push(s);}return h;};
G.prototype._getParentGroupId=function(g){return this._getGroupIdAncestors(g,-1)[0];};
G.prototype._removeDuplicatesFromStringArray=function(e){var o={};for(var i=0;i<e.length;i++){o[e[i]]=true;}var U=[];for(var s in o){U.push(s);}return U;};
G.prototype._getIdForNewRequestHandle=function(){if(this.oPendingRequestHandle===undefined){this.oPendingRequestHandle=[];}for(var i=0;i<this.oPendingRequestHandle.length;i++){if(this.oPendingRequestHandle[i]===undefined){return i;}}this.oPendingRequestHandle[this.oPendingRequestHandle.length]=undefined;return this.oPendingRequestHandle.length-1;};
G.prototype._registerNewRequestHandle=function(r,R){if(this.oPendingRequestHandle[r]!==undefined){x.fatal("request handle ID already in use");}this.oPendingRequestHandle[r]=R;};
G.prototype._deregisterHandleOfCompletedRequest=function(r){if(u(this.oPendingRequestHandle)){x.warning("No request handles to be cleared. Previous abort/resetData?");return;}if(this.oPendingRequestHandle[r]===undefined){x.fatal("no handle found for this request ID");}this.oPendingRequestHandle[r]=undefined;};
G.prototype._abortAllPendingRequestsByHandle=function(){for(var i=0;i<this.oPendingRequestHandle.length;i++){if(this.oPendingRequestHandle[i]){if(this.oPendingRequestHandle[i]!==undefined){this.oPendingRequestHandle[i].abort();}}}this.oPendingRequestHandle=[];};
G.prototype._getRequestId=function(r,p){switch(r){case G._requestType.groupMembersQuery:if(p.groupId===undefined){x.fatal("missing group ID");}return G._requestType.groupMembersQuery+(p.groupId==null?"":p.groupId);case G._requestType.levelMembersQuery:if(p.level===undefined){x.fatal("missing level");}if(p.groupId===undefined){x.fatal("missing groupId");}return""+G._requestType.levelMembersQuery+p.level+(p.tupleIndex?"-"+p.tupleIndex:"");case G._requestType.totalSizeQuery:return G._requestType.totalSizeQuery;case G._requestType.reloadMeasuresQuery:if(!p.multiUnitEntryKey){x.fatal("missing multi unit entry key");}return G._requestType.reloadMeasuresQuery+p.multiUnitEntryKey;default:x.fatal("invalid request type "+r);return-1;}};
G.prototype._registerNewRequest=function(r){if(r==undefined||r==""){x.fatal("missing request ID");return;}if(!this.oPendingRequests[r]){this.oPendingRequests[r]=1;}else{++this.oPendingRequests[r];}};
G.prototype._considerRequestGrouping=function(r){for(var i=-1,R;(R=r[++i])!==undefined;){if(this.oGroupedRequests[R]===undefined){this.oGroupedRequests[R]={};}var g=this.oGroupedRequests[R];for(var j=0;j<r.length;j++){g[r[j]]=true;}}};
G.prototype._isRequestPending=function(r){return this.oPendingRequests[r]!=undefined&&this.oPendingRequests[r]>0;};
G.prototype._deregisterCompletedRequest=function(r){if(u(this.oPendingRequests)){x.warning("There are no pending requests which could be set to 'completed'.");return;}if(!this.oPendingRequests[r]){x.fatal("assertion failed: there is no pending request ID "+r);}if(this.oPendingRequests[r]==1){delete this.oPendingRequests[r];}else{--this.oPendingRequests[r];}};
G.prototype._cleanupGroupingForCompletedRequest=function(r){if(this._isRequestPending(r)){return false;}var g=true;if(this.oGroupedRequests[r]!=undefined){for(var o in this.oGroupedRequests[r]){if(this.oPendingRequests[o]){g=false;break;}}}if(g){var R=this.oGroupedRequests[r];delete this.oGroupedRequests[r];for(var O in R){if(O!=r){this._cleanupGroupingForCompletedRequest(O);}}}return g;};
G.prototype._getKeyIndexMapping=function(g,s){var i,l,e,k=this.mKeyIndex[g],K={sGroupId:g,iIndex:s,iServiceKeyIndex:s},h=this.mServiceKey[g];if(k!==undefined){if(k[s]!==undefined){K.iServiceKeyIndex=k[s]==="ZERO"?0:Math.abs(k[s]);return K;}l=s;if(l>0){while(--l>0){if(k[l]!==undefined){break;}}}if(l==0){e=0;}else{if(k[l]>=0){e=k[l];}else if(k[l+1]===undefined){e=-k[l];while(h[e+1]!==undefined){++e;}}else{e=Math.abs(k[l+1])-1;}if(h[e]===undefined){x.fatal("assertion failed: no service key at iLastOccupiedServiceKeyIndex = "+e);}}i=s-l;K.iServiceKeyIndex=e+i;}return K;};
G.prototype._moveKeyIndexMapping=function(k,i){return this._getKeyIndexMapping(k.sGroupId,k.iIndex+i);};
G.prototype._getKey=function(g,i){var s=this.mKeyIndex[g][i];if(s===undefined){return undefined;}if(s>=0){return this.mServiceKey[g][s];}if(this.mMultiUnitKey[g]===undefined){x.fatal("assertion failed: missing expected multi currency key for group with ID "+g);return null;}var k=this.mMultiUnitKey[g][i];if(k===undefined){x.fatal("assertion failed: missing expected multi currency key for group with ID "+g+" at pos "+i);return null;}return k;};
G.prototype._getKeys=function(g){if(this.mKeyIndex[g]===undefined){return undefined;}var e=this;return function(i){return e._getKey(g,i);};};
G.prototype._getServiceKeys=function(g,I){var k=this.mKeyIndex[g];if(k===undefined){return undefined;}var s=this.mServiceKey[g],e=k[I];if(e===undefined){return undefined;}if(e>=0){return[s[e]];}var h=[];if(k[I+1]===undefined){e=k[I]=="ZERO"?0:-k[I];while(s[e]!==undefined){h.push(s[e++]);}}else{e=k[I]=="ZERO"?0:-k[I];for(var i=e,n=Math.abs(k[I+1]);i<n;i++){h.push(s[i]);}}return h;};
G.prototype._getKeyCount=function(g){if(this.mKeyIndex[g]===undefined){return undefined;}return this.mKeyIndex[g].length;};
G.prototype._findKeyIndex=function(g,k){var K=this.mKeyIndex[g];var s=this.mServiceKey[g];var m=this.mMultiUnitKey[g];for(var i=0;i<this.mLength[g];i++){if(K[i]<0||K[i]==="ZERO"){if(m[i]==k){return i;}}else if(s[K[i]]==k){return i;}}return-1;};
G.prototype._setServiceKey=function(k,s){if(!this.mServiceKey[k.sGroupId]){this.mServiceKey[k.sGroupId]=[];}if(!this.mKeyIndex[k.sGroupId]){this.mKeyIndex[k.sGroupId]=[];}var n=this.mServiceKey[k.sGroupId][k.iServiceKeyIndex]===undefined;this.mServiceKey[k.sGroupId][k.iServiceKeyIndex++]=s;this.mKeyIndex[k.sGroupId][k.iIndex++]=k.iServiceKeyIndex-1;return n;};
G.prototype._setAdjacentMultiUnitKeys=function(k,m,M){if(!this.mServiceKey[k.sGroupId]){this.mServiceKey[k.sGroupId]=[];}if(!this.mKeyIndex[k.sGroupId]){this.mKeyIndex[k.sGroupId]=[];}if(!this.mMultiUnitKey[k.sGroupId]){this.mMultiUnitKey[k.sGroupId]=[];}--k.iIndex;--k.iServiceKeyIndex;this.mMultiUnitKey[k.sGroupId][k.iIndex]=this.oModel._getKey(m.oEntry);this.mKeyIndex[k.sGroupId][k.iIndex++]=k.iServiceKeyIndex>0?-k.iServiceKeyIndex:"ZERO";var n=0;for(var i=0;i<M.length;i++){if(!this.mServiceKey[k.sGroupId][k.iServiceKeyIndex]){++n;}this.mServiceKey[k.sGroupId][k.iServiceKeyIndex++]=this.oModel._getKey(M[i]);}return n;};
G.prototype._mergeLoadedKeyIndexWithSubsequentIndexes=function(k,e,s,I){var K=this.mKeyIndex[k.sGroupId],g=this.mServiceKey[k.sGroupId],m=this.mMultiUnitKey[k.sGroupId],h=0,n=k.iServiceKeyIndex,j=k.iIndex;var M,o;if(K===undefined){return h;}var N=false;var p=g[n-1],l=g[n];if(l===undefined){return h;}if(p===undefined){x.fatal("assertion failed: missing expected entry before given key index");return h;}var P=this.oModel.getObject("/"+p);var q=this.oModel.getObject("/"+l);var r="",z="";for(var i=0;i<e.length;i++){r+=P[e[i]]+"|";z+=q[e[i]]+"|";}N=r==z;var J=j;if(J>=this.mLength[k.sGroupId]){x.fatal("assertion failed: service key exists,but no corresponding key index found");return h;}while(K[J]===undefined||Math.abs(K[J])<n){++J;}if(N){if(Math.abs(K[J])==n&&K[J]<0){if(J>j){if(K[j-1]<0){m[J]=undefined;K.splice(j,J-j+1);m.splice(j,J-j+1);}else{K[j-1]=-K[j-1];m[j-1]=m[J];m[J]=undefined;K.splice(j,J-j+1);m.splice(j,J-j+1);h=1;}}}else if(Math.abs(K[J])>n){var O=J-1;if(K[O]>0){M=this._createMultiUnitRepresentativeEntry(k.sGroupId,P,s,undefined,I);o=this.oModel._getKey(M.oEntry);K[O]=-K[O];m[O]=o;if(O>j){K.splice(j,O-j);m.splice(j,O-j);}if(M.bIsNewEntry){h=1;}else{h=0;}}else if(K[j-1]<0){if(J>j){m[O]=undefined;K.splice(j,O-j+1);m.splice(j,O-j+1);}}else{K[j-1]=-K[j-1];m[j-1]=m[O];m[O]=undefined;K.splice(j,O-j+1);m.splice(j,O-j+1);}}else if(K[J]==n){if(J>j){if(K[j-1]<0){K.splice(j,J-j+1);m.splice(j,J-j+1);h=1;}else{M=this._createMultiUnitRepresentativeEntry(k.sGroupId,P,s,undefined,I);o=this.oModel._getKey(M.oEntry);if(!M.bIsNewEntry){x.fatal("assertion failed: multi-unit entry already existed before");}K[j-1]=-K[j-1];m[j-1]=o;K.splice(j,J-j+1);m.splice(j,J-j+1);h=1;}}}else{x.fatal("assertion failed: uncovered case detected");return h;}}else if(K[J]>n){x.fatal("unstable query result for group ID "+k.sGroupId+": entries have been removed or added. Complete reload required");}else if(J-j>0){K.splice(j,J-j);m.splice(j,J-j);}return h;};
G.prototype._createMultiUnitRepresentativeEntry=function(g,r,s,e,i){var m=Q.extend(true,{},r);var R=[];for(var M in this.oMeasureDetailsSet){var o=this.oMeasureDetailsSet[M];if(!i&&!this.mAnalyticalInfoByProperty[M].total){if(o.rawValuePropertyName!=undefined){m[o.rawValuePropertyName]=undefined;}if(o.formattedValuePropertyName!=undefined){m[o.formattedValuePropertyName]=undefined;}}else{if(o.rawValuePropertyName!=undefined){m[o.rawValuePropertyName]=null;}if(o.formattedValuePropertyName!=undefined){m[o.formattedValuePropertyName]="*";}}if(e){if(!o.unitPropertyName||e.indexOf(o.unitPropertyName)==-1){R.push(o.rawValuePropertyName);}}}for(var k=0;k<s.length;k++){if(e.indexOf(s[k])!=-1){m[s[k]]="*";}}var h="";for(var l=0;l<this.aAllDimensionSortedByName.length;l++){var j=m[this.aAllDimensionSortedByName[l]];var n=j===""?'""':j;n=n===undefined?"":n;h+=(encodeURIComponent(n)+",");}h+="-multiple-units-not-dereferencable";var p;if(this.mMultiUnitKey[g]&&(p=this.mMultiUnitKey[g].indexOf(h))!=-1){return{oEntry:this.oModel.getObject("/"+h),bIsNewEntry:false,iIndex:p,aReloadMeasurePropertyName:R};}m.__metadata.uri=h;delete m.__metadata["self"];delete m.__metadata["self_link_extensions"];m["^~volatile"]=true;this.oModel._importData(m,{},{});var q=this.oModel._getKey(m);this.oModel.getContext('/'+q)["_volatile"]=true;return{oEntry:m,bIsNewEntry:true,aReloadMeasurePropertyName:R};};
G.prototype._clearAllPendingRequests=function(){this.oPendingRequests={};this.oGroupedRequests={};};
G.prototype.resetData=function(o){var g=o?o.getPath():undefined;this._resetData(g);};
G.prototype._resetData=function(g){if(g){delete this.mServiceKey[g];delete this.mServiceLength[g];delete this.mServiceFinalLength[g];delete this.mKeyIndex[g];delete this.mLength[g];delete this.mMultiUnitKey[g];delete this.mEntityKey[g];}else{this.mServiceKey={};this.mServiceLength={};this.mServiceFinalLength={};this.mFinalLength=this.mServiceFinalLength;this.mKeyIndex={};this.mLength={};this.mMultiUnitKey={};this.mEntityKey={};}};
G.prototype.refresh=function(e){G.prototype._refresh.apply(this,arguments);};
G.prototype._refresh=function(e,m,g){var h=false;if(!e){if(g){var r=this.oModel.resolve(this.sPath,this.oContext);var o=this.oModel.oMetadata._getEntityTypeByPath(r);if(o&&(o.entityType in g)){h=true;}}if(m&&!h){Q.each(this.mServiceKey,function(i,n){Q.each(n,function(i,k){if(k in m){h=true;return false;}});if(h){return false;}});}if(!m&&!g){h=true;}}if(e||h){this.iTotalSize=-1;this._abortAllPendingRequests();this.resetData();this.bNeedsUpdate=false;this._fireRefresh({reason:C.Refresh});}};
G.prototype.checkUpdate=function(e,m){var g=false;if(!e){if(this.bNeedsUpdate||!m){g=true;}else{Q.each(this.mServiceKey,function(i,n){Q.each(n,function(i,k){if(k in m){g=true;return false;}});if(g){return false;}});}}if(e||g){this.bNeedsUpdate=false;this._fireChange({reason:C.Change});}};
G.prototype.getDownloadUrl=function(s){var e,p,z;var o=new t.QueryResultRequest(this.oAnalyticalQueryResult);o.setResourcePath(this._getResourcePath());var g=[];var h=[];for(var n in this.oDimensionDetailsSet){g.push(n);}o.setAggregationLevel(g);for(var q in this.oDimensionDetailsSet){var r=this.oDimensionDetailsSet[q];var I=(r.textPropertyName!=undefined);o.includeDimensionKeyTextAttributes(r.name,true,I,r.aAttributeName);}for(var M in this.oMeasureDetailsSet){h.push(M);}o.setMeasures(h);for(var J in this.oMeasureDetailsSet){var K=this.oMeasureDetailsSet[J];var N=(K.rawValuePropertyName!=undefined);var O=(K.formattedValuePropertyName!=undefined);var P=(K.unitPropertyName!=undefined);o.includeMeasureRawFormattedValueUnit(K.name,N,O,P);}var R=o.getSortExpression();R.clear();for(var i=0;i<this.aSorter.length;i++){if(this.aSorter[i]){R.addSorter(this.aSorter[i].sPath,this.aSorter[i].bDescending?t.SortOrder.Descending:t.SortOrder.Ascending);}}var U=o.getFilterExpression();U.clear();if(this.aApplicationFilter){U.addUI5FilterConditions(this.aApplicationFilter);}if(this.aControlFilter){U.addUI5FilterConditions(this.aControlFilter);}var V=o.getURIToQueryResultEntitySet();var W=this._getQueryODataRequestOptions(o,true);if(!W){return undefined;}var X=[];for(var k=0,m=this.aAnalyticalInfo.length;k<m;k++){var Y=this.aAnalyticalInfo[k];if((Y.visible||Y.inResult)&&Y.name!==""&&Y.name!==X[X.length-1]){X.push(Y.name);if(this.oMeasureDetailsSet[Y.name]!=undefined&&this.oMeasureDetailsSet[Y.name].unitPropertyName!=undefined){X.push(this.oMeasureDetailsSet[Y.name].unitPropertyName);}}}for(var j=0,l=W.length;j<l;j++){if(/^\$select/i.test(W[j])){if(this.mParameters.select){e=W[j].slice(8).split(",");for(z=0;z<e.length;z++){p=e[z];if(X.indexOf(p)===-1){X.push(p);}}}W[j]="$select="+X.join(",");break;}}if(s){W.splice(0,0,"$format="+encodeURIComponent(s));}if(this.sCustomParams){W.push(this.sCustomParams);}if(V){return this.oModel._createRequestUrl(V,null,W).replace(/ /g,"%20");}};
G.prototype._addSorters=function(s,g){var e=this._canApplySortersToGroups()?[].concat(this.aSorter).concat(g):[].concat(g).concat(this.aSorter);e.forEach(function(o){s.addSorter(o.sPath,o.bDescending?t.SortOrder.Descending:t.SortOrder.Ascending);});};
G.prototype._canApplySortersToGroups=function(){var s=this._autoExpandMode;if(this.bApplySortersToGroups){if(this.aSorter.length>0){if(s!==this.sLastAutoExpandMode&&s!==f.Sequential){x.warning("Applying sorters to groups is only possible with auto"+" expand mode 'Sequential'; current mode is: "+s,this.sPath);}this.sLastAutoExpandMode=s;}return s===f.Sequential;}return false;};
G.prototype._warnNoSortingOfGroups=function(s){var m;if(this.bApplySortersToGroups){m="Detected a multi-unit case, so sorting is only possible on leaves";if(s){m+="; "+s;}x.warning(m,this.sPath);}this.bApplySortersToGroups=false;};
G.Logger=x;return G;});
sap.ui.predefine('sap/ui/model/analytics/AnalyticalTreeBindingAdapter',['sap/ui/model/TreeBinding','./AnalyticalBinding','sap/ui/model/TreeAutoExpandMode','sap/ui/model/ChangeReason','sap/ui/model/odata/ODataTreeBindingAdapter','sap/ui/model/TreeBindingAdapter','sap/ui/model/TreeBindingUtils',"sap/base/assert","sap/base/Log","sap/ui/thirdparty/jquery"],function(T,A,a,C,O,b,c,d,L,q){"use strict";var e=function(){if(!(this instanceof T)||this._bIsAdapted){return;}O.apply(this);for(var f in e.prototype){if(e.prototype.hasOwnProperty(f)){this[f]=e.prototype[f];}}this.setAutoExpandMode(this.mParameters.autoExpandMode||a.Bundled);},s="sap.ui.model.analytics.AnalyticalTreeBindingAdapter";
e.prototype.getGrandTotalContext=function(){if(this._oRootNode){return this._oRootNode.context;}};
e.prototype.getGrandTotalNode=function(){if(this._oRootNode){return this._oRootNode;}};
e.prototype.getGrandTotalContextInfo=function(){return this._oRootNode;};
e.prototype.getLength=function(){if(!this._oRootNode){return 0;}if(this._oRootNode&&this._oWatermark&&this._isRunningInAutoExpand(a.Bundled)){if(this._oWatermark.groupID===this._oRootNode.groupID){return this._oRootNode.magnitude+this._oRootNode.numberOfTotals;}return this._oWatermark.absoluteNodeIndex+this._oRootNode.numberOfTotals+1;}return this._oRootNode.magnitude+this._oRootNode.numberOfTotals;};
e.prototype.getContextByIndex=function(i){if(this._oRootNode&&i===(this.getLength()-1)&&this.providesGrandTotal()&&this.hasTotaledMeasures()){return this._oRootNode.context;}var n=this.findNode(i);if(!n||!n.context){n={context:this.getContexts(i,1,0)[0]};}return n?n.context:undefined;};
e.prototype.getNodeByIndex=function(i){if(i===(this.getLength()-1)&&this.providesGrandTotal()&&this.hasTotaledMeasures()){return this._oRootNode;}if(i>=this.getLength()){return undefined;}return this.findNode(i);};
e.prototype._isNodeSelectable=function(n){if(!n){return false;}return n.isLeaf&&!n.isArtificial;};
e.prototype.getContexts=function(S,l,t,r){if(!l){l=this.oModel.iSizeLimit;}if(!t){t=0;}this._iPageSize=l;this._iThreshold=Math.max(this._iThreshold,t);this._aRowIndexMap=[];this._buildTree(S,l);var n=[];if(this._oRootNode){n=this._retrieveNodeSection(this._oRootNode,S,l);}this._updateRowIndexMap(n,S);var f=[];var m;for(var i=0;i<n.length;i++){var N=n[i];if(this._isRunningInAutoExpand(a.Bundled)&&this._oWatermark){if(N.groupID===this._oWatermark.groupID||(this._oWatermark.groupID===this._oRootNode.groupID&&(S+i+1)==this.getLength()-1)){this._autoExpandPaging();}}if(!N.context){m=m||{};var p=N.parent;m[p.groupID]=p;this._updateNodeSections(p.groupID,{startIndex:N.positionInParent,length:1});}f.push(N.context);}if(m){var g=this;q.each(m,function(G,N){N.magnitude=0;N.numberOfTotals=0;g._loadChildContexts(N,{absoluteNodeIndex:N.absoluteNodeIndex});});f=[];for(var j=0;j<n.length;j++){var N=n[j];f.push(N.context);}}if(r){return n;}else{return f;}};
e.prototype._autoExpandPaging=function(){d(this._oWatermark,"No watermark was set!");d(this._isRunningInAutoExpand(a.Bundled),"Optimised AutoExpand Paging can only be used with TreeAutoExpandMode.Bundled!");var f=this.getNodeContexts(this._oWatermark.context,{startIndex:this._oWatermark.startIndex,length:this._iPageSize,threshold:this._iThreshold,level:this._oWatermark.level,numberOfExpandedLevels:this._oWatermark.autoExpand});return f;};
e.prototype._afterMatchHook=function(n,r,m,M,p,P){if(n.sumNode&&n!==this._oRootNode){if(r.length===m){return true;}var N=M.call(this,n.sumNode,n.sumNode.positionInParent,P);if(N){r.push(n.sumNode);}}};
e.prototype._afterMapHook=function(n,m){if(n.sumNode&&n!==this._oRootNode){m.call(this,n.sumNode);}};
e.prototype._createSumNode=function(n){var f;if(this.bProvideGrandTotals&&!this.mParameters.sumOnTop&&this.hasTotaledMeasures()&&n.children.length>1){f=this._createNode({parent:n.parent,positionInParent:n.children.length,context:n.context,level:n.level});f.nodeState=this._createNodeState({groupID:f.groupID,sum:true,expanded:false});}return f;};
e.prototype._buildTree=function(S,l){this._oRootNode=undefined;this._oWatermark=undefined;var n=this.mParameters&&this.getNumberOfExpandedLevels();var r=this.getRootContexts({startIndex:0,length:this._iPageSize,threshold:this._iThreshold,numberOfExpandedLevels:this._autoExpandMode===a.Bundled?n:undefined});var R;if(r==null){L.warning("AnalyticalTreeBindingAdapter: No Dimensions given. An artificial rootContext has be created. Please check your Table/Service definition for dimension columns!");}else{R=r[0];}if(!R){return;}var o=this._getNodeState("/");if(!o){o=this._updateTreeState({groupID:"/",expanded:true,sum:true});this._updateNodeSections("/",{startIndex:0,length:l});}this._oRootNode=this._createNode({context:R,parent:null,level:0,nodeState:o,isLeaf:false,autoExpand:n,absoluteNodeIndex:-1});this._oRootNode.isArtificial=true;this._loadChildContexts(this._oRootNode,{absoluteNodeIndex:-1});};
e.prototype._loadChildContexts=function(n,r){var N=n.nodeState;var m=this.getGroupSize(n.context,n.level);if(m>=0){if(!n.children[m-1]){n.children[m-1]=undefined;}if(n.level===this.aAggregationLevel.length){N.leafCount=m;}n.sumNode=this._createSumNode(n);}for(var i=0;i<N.sections.length;i++){var o=N.sections[i];if(o.startIndex>n.children.length){continue;}var R;if(m===-1){R=o.length;}else{R=Math.min(o.length,m-o.startIndex);}var S=false;if(n.autoExpand>=0&&this._isRunningInAutoExpand(a.Bundled)){S=true;R=Math.max(0,m);}var f=this.getNodeContexts(n.context,{startIndex:o.startIndex,length:R,threshold:S?0:this._iThreshold,level:n.level,supressRequest:S});for(var j=0;j<f.length;j++){var g=f[j];var h=j+o.startIndex;var k=n.children[h];var u={context:f[j],parent:n,level:n.level+1,positionInParent:h,autoExpand:Math.max(n.autoExpand-1,-1),absoluteNodeIndex:(++r.absoluteNodeIndex)};if(k){k.context=u.context;k.parent=u.parent;k.level=u.level;k.positionInParent=u.positionInParent;k.magnitude=0;k.numberOfTotals=0;k.totalNumberOfLeafs=0;k.autoExpand=u.autoExpand;k.absoluteNodeIndex=u.absoluteNodeIndex;var G;if(g){G=this._calculateGroupID(k);}k.groupID=G;}else{k=this._createNode(u);}k.nodeState=this._getNodeState(k.groupID);if(!k.nodeState){k.nodeState=this._createNodeState({groupID:k.groupID,expanded:false});}k.nodeState.parentGroupID=n.groupID;k.isLeaf=!this.nodeHasChildren(k);n.children[h]=k;if(k.isLeaf){n.numberOfLeafs+=1;}if(k.parent.nodeState.selectAllMode&&!this._mTreeState.deselected[k.groupID]&&k.isLeaf){this.setNodeSelection(k.nodeState,true);}if((k.autoExpand>=0||k.nodeState.expanded)&&this.isGrouped()){if(!this._mTreeState.collapsed[k.groupID]){if(k.autoExpand>=0&&k.parent.nodeState.selectAllMode&&!this._mTreeState.deselected[k.groupID]){if(k.nodeState.selectAllMode===undefined){k.nodeState.selectAllMode=true;}}this._updateTreeState({groupID:k.nodeState.groupID,fallbackNodeState:k.nodeState,expanded:true});this._loadChildContexts(k,r);}n.magnitude+=k.magnitude;n.numberOfTotals+=k.numberOfTotals;n.numberOfLeafs+=k.numberOfLeafs;}if(k&&k.isLeaf){n.totalNumberOfLeafs=m;}else{n.totalNumberOfLeafs+=k.totalNumberOfLeafs;}}}m=this._isRunningInAutoExpand(a.Bundled)?n.children.length:m;n.magnitude+=Math.max(m||0,0);if(!m&&!this._isRunningInAutoExpand(a.Bundled)){L.warning("AnalyticalTreeBindingAdapter: iMaxGroupSize("+m+") is undefined for node '"+n.groupID+"'!");}if(n.sumNode||(n===this._oRootNode&&this.providesGrandTotal()&&this.hasTotaledMeasures())){n.numberOfTotals+=1;}if(this._isRunningInAutoExpand(a.Bundled)&&n.autoExpand!=-1){if(!this._oWatermark&&!n.isLeaf&&!this.mFinalLength[n.groupID]){this._oWatermark={groupID:n.groupID,context:n.context,absoluteNodeIndex:n.absoluteNodeIndex,startIndex:n.children.length,level:n.level,autoExpand:n.autoExpand};}}};
e.prototype._calculateGroupID=function(n){var g;var m=this.aAggregationLevel.length;if(!this.isGrouped()&&n&&n.positionInParent){g="/"+n.positionInParent+"/";}else{if(n.level>m){g=this._getGroupIdFromContext(n.context,m);d(n.positionInParent!=undefined,"If the node level is greater than the number of grouped columns, the position of the node to its parent must be defined!");g+=n.positionInParent+"/";}else{g=this._getGroupIdFromContext(n.context,n.level);}}return g;};
e.prototype.collapse=function(p){var n,N;if(typeof p==="object"){n=p;}else if(typeof p==="number"){N=this.findNode(p);d(N&&N.nodeState,"AnalyticalTreeBindingAdapter.collapse("+p+"): No node found!");if(!N){return;}n=N.nodeState;}this._updateTreeState({groupID:n.groupID,expanded:false});n.selectAllMode=false;var f=false;if(this.bCollapseRecursive||this._isRunningInAutoExpand(a.Bundled)){var g=n.groupID;if(this._isRunningInAutoExpand(a.Bundled)&&this._oWatermark&&(typeof g=="string"&&g.length>0&&this._oWatermark.groupID.startsWith(g))){if(N&&N.parent){this._oWatermark={groupID:N.parent.groupID,context:N.parent.context,absoluteNodeIndex:N.parent.absoluteNodeIndex,startIndex:N.positionInParent+1,level:N.parent.level,autoExpand:N.parent.autoExpand};}this._autoExpandPaging();f=true;}var t=this;q.each(this._mTreeState.expanded,function(G,o){if(typeof g=="string"&&g.length>0&&G.startsWith(g)){t._updateTreeState({groupID:G,expanded:false});}});var D=[];q.each(this._mTreeState.selected,function(G,o){if(typeof g=="string"&&g.length>0&&G.startsWith(g)){o.selectAllMode=false;t.setNodeSelection(o,false);D.push(G);}});if(D.length){var h={rowIndices:[]};var i=0;this._map(this._oRootNode,function(N){if(!N||!N.isArtificial){i++;}if(N&&D.indexOf(N.groupID)!==-1){if(N.groupID===this._sLeadSelectionGroupID){h.oldIndex=i;h.leadIndex=-1;}h.rowIndices.push(i);}});this._publishSelectionChanges(h);}}if(!f){this._fireChange({reason:C.Collapse});}};
e.prototype.collapseToLevel=function(l){this.setNumberOfExpandedLevels(l,true);b.prototype.collapseToLevel.call(this,l);};
e.prototype.nodeHasChildren=function(n){d(n,"AnalyticalTreeBindingAdapter.nodeHasChildren: No node given!");if(!n||!n.parent||n.nodeState.sum){return false;}else if(n.isArtificial){return true;}else{return A.prototype.hasChildren.call(this,n.context,{level:n.level});}};
e.prototype.resetData=function(o,p){var r=A.prototype.resetData.call(this,o,p);this._aRowIndexMap=[];this._oRootNode=undefined;this._oWatermark=undefined;this._iPageSize=0;this._iThreshold=0;if(!p||p.reason!==C.Sort){this.clearSelection();this._createTreeState(true);}return r;};
e.prototype.hasTotaledMeasures=function(){var h=false;q.each(this.getMeasureDetails()||[],function(i,m){if(m.analyticalInfo.total){h=true;return false;}});return h;};
e.prototype.isGrouped=function(){return(this.aAggregationLevel.length>0);};
e.prototype._isRunningInAutoExpand=function(f){if(this.getNumberOfExpandedLevels()>0&&this._autoExpandMode===f){return true;}else{return false;}};
e.prototype.setNumberOfExpandedLevels=function(l,S){var n;l=l||0;if(l<0){L.warning("Number of expanded levels was set to 0. Negative values are prohibited",this,s);l=0;}n=this.aAggregationLevel.length;if(l>n){L.warning("Number of expanded levels was reduced from "+l+" to "+n+" which is the number of grouped dimensions",this,s);l=n;}if(!S){this.resetData();}this.mParameters.numberOfExpandedLevels=l;};
e.prototype.getNumberOfExpandedLevels=function(){return this.mParameters.numberOfExpandedLevels;};
e.prototype._getSelectableNodesCount=function(n){if(n){return n.totalNumberOfLeafs;}else{return 0;}};
return e;},true);
sap.ui.predefine('sap/ui/model/analytics/AnalyticalVersionInfo',["sap/base/Log"],function(L){"use strict";var A={NONE:null,V1:1,V2:2,getVersion:function(o){var v;var O;if(o&&o.getMetadata){O=o.getMetadata().getName();}switch(O){case"sap.ui.model.odata.ODataModel":v=this.V1;break;case"sap.ui.model.odata.v2.ODataModel":v=this.V2;break;default:v=this.NONE;L.info("AnalyticalVersionInfo.getVersion(...) - The given object is no instance of ODataModel V1 or V2!");break;}return v;}};return A;},true);
sap.ui.predefine('sap/ui/model/analytics/BatchResponseCollector',function(){"use strict";
function B(p){if(p){this.setup(p);}}
B.TYPE_SUCCESS="success";B.TYPE_ERROR="error";
B.prototype.setup=function(p){this.iRequestCollectionCount=0;this.aCollectedSuccesses=[];this.aCollectedErrors=[];this.aExecutedRequestDetails=p.executedRequests;this.oAnalyticalBinding=p.binding;this.fnSuccessHandler=p.success;this.fnErrorHandler=p.error;};
B.prototype.success=function(r){this.collect(r,B.TYPE_SUCCESS);};
B.prototype.error=function(r){this.collect(r,B.TYPE_ERROR);};
B.prototype.collect=function(r,R){this.iRequestCollectionCount++;if(R===B.TYPE_SUCCESS){this.aCollectedSuccesses.push(r);}else{this.aCollectedErrors.push(r);}var o=(this.aCollectedSuccesses.length+this.aCollectedErrors.length);if(o===this.aExecutedRequestDetails.length){if((this.aCollectedSuccesses.length===o)&&this.aCollectedErrors.length===0){this.fnSuccessHandler.call(window,{__batchResponses:this.aCollectedSuccesses},{requestUri:this.oAnalyticalBinding.oModel.sServiceUrl+"/$batch"});}else{this.fnErrorHandler.call(window,this.aCollectedErrors[0]||{});}}};
return B;},true);
sap.ui.predefine('sap/ui/model/analytics/ODataModelAdapter',['./AnalyticalBinding',"./AnalyticalTreeBindingAdapter",'./odata4analytics','./AnalyticalVersionInfo',"sap/base/Log"],function(A,a,o,b,L){"use strict";var O=function(){var m=b.getVersion(this);if(m===b.NONE||this.getAnalyticalExtensions){return;}this._mPreadapterFunctions={bindList:this.bindList,bindTree:this.bindTree};for(var f in O.prototype){if(O.prototype.hasOwnProperty(f)){this[f]=O.prototype[f];}}if(m===b.V1&&this.isCountSupported()){L.info("ODataModelAdapter: switched ODataModel to use inlinecount (mandatory for the AnalyticalBinding)");this.setCountSupported(false);}};
O.prototype.bindList=function(p,c,s,f,P){if(P&&P.analyticalInfo){var B=new A(this,p,c,s,f,P);a.apply(B);return B;}else{return this._mPreadapterFunctions.bindList.apply(this,arguments);}};
O.prototype.bindTree=function(p,c,f,P){if(P&&P.analyticalInfo){var B=new A(this,p,c,[],f,P);return B;}else{return this._mPreadapterFunctions.bindTree.apply(this,arguments);}};
O.prototype.getAnalyticalExtensions=function(){if(this.oOData4SAPAnalyticsModel!=undefined&&this.oOData4SAPAnalyticsModel!=null){return this.oOData4SAPAnalyticsModel;}var m=b.getVersion(this);if(m===b.V2&&!(this.oMetadata&&this.oMetadata.isLoaded())){throw"Failed to get the analytical extensions. The metadata have not been loaded by the model yet."+"Register for the 'metadataLoaded' event of the ODataModel(v2) to know when the analytical extensions can be retrieved.";}var s=null;if(arguments.length==1){var c=arguments[0];var r=jQuery.sap.syncGetText(c);if(r.success){s=r.data;}}try{this.oOData4SAPAnalyticsModel=new o.Model(new o.Model.ReferenceByModel(this),{sAnnotationJSONDoc:s});}catch(e){throw"Failed to instantiate analytical extensions for given OData model: "+e.message;}return this.oOData4SAPAnalyticsModel;};
O.prototype.setAnalyticalExtensions=function(c){this.oOData4SAPAnalyticsModel=c;};
return O;},true);
sap.ui.predefine('sap/ui/model/analytics/odata4analytics',['sap/ui/model/Filter','sap/ui/model/FilterOperator','sap/ui/model/Sorter','./AnalyticalVersionInfo',"sap/base/security/encodeURL"],function(F,c,S,A,e){"use strict";var o=o||{},d=/^\d+$/;o.constants={};o.constants["SAP_NAMESPACE"]="http://www.sap.com/Protocols/SAPData";o.constants["VERSION"]="0.7";o.helper={deepEqual:function(O,N,f){var a,b,r=0,i,n;if(!O||O.length!==N.length){return 2;}if(O!==N){for(i=0,n=O.length;i<n;i+=1){b=O[i];a=N[i];if(b.grouped!==a.grouped||b.inResult!==a.inResult||b.level!==a.level||b.name!==a.name||b.total!==a.total||b.visible!==a.visible){return 2;}if(b.formatter!==a.formatter){r=1;if(f){f(a);}}}}return r;},tokenizeNametoLabelText:function(n){var l="";l=n.replace(/^P_(.*)/,"$1");l=l.replace(/([^A-Z0-9_]+)([A-Z0-9_])/g,"$1 $2");l=l.replace(/([A-Z0-9_]{2,})([A-Z0-9_])([^A-Z0-9_]+)/g,"$1 $2$3");l=l.replace(/(.*) _E$/,"$1");l=l.replace(/(.*) _(.*)/g,"$1 $2");return l;}};
o.Model=function(m,p){this._init(m,p);};
o.Model.ReferenceByURI=function(u){return{sServiceURI:u};};
o.Model.ReferenceByModel=function(m){return{oModel:m};};
o.Model.ReferenceWithWorkaround=function(m,w){return{oModelReference:m,aWorkaroundID:w};};
o.Model.prototype={_init:function(m,p){if(typeof p=="string"){throw"Deprecated second argument: Adjust your invocation by passing an object with a property sAnnotationJSONDoc as a second argument instead";}this._mParameter=p;var t=this;this._oActivatedWorkarounds={};if(m&&m.aWorkaroundID){for(var i=-1,I;(I=m.aWorkaroundID[++i])!==undefined;){this._oActivatedWorkarounds[I]=true;}m=m.oModelReference;}if(!m||(!m.sServiceURI&&!m.oModel)){throw"Usage with oModelReference being an instance of Model.ReferenceByURI or Model.ReferenceByModel";}if(m.oModel){this._oModel=m.oModel;this._iVersion=A.getVersion(this._oModel);a();}else if(p&&p.modelVersion===A.V2){var V=sap.ui.requireSync("sap/ui/model/odata/v2/ODataModel");this._oModel=new V(m.sServiceURI);this._iVersion=A.V2;a();}else{var O=sap.ui.requireSync("sap/ui/model/odata/ODataModel");this._oModel=new O(m.sServiceURI);this._iVersion=A.V1;a();}if(this._oModel.getServiceMetadata()&&this._oModel.getServiceMetadata().dataServices==undefined){throw"Model could not be loaded";}function a(){if(!t._oModel.getServiceMetadata()){t._oModel.attachMetadataLoaded(b);}else{b();}}function b(){if(t.bIsInitialized){return;}t.bIsInitialized=true;if(p&&p.sAnnotationJSONDoc){t.mergeV2Annotations(p.sAnnotationJSONDoc);}t._interpreteMetadata(t._oModel.getServiceMetadata().dataServices);}},_interpreteMetadata:function(M){this._oQueryResultSet={};this._oParameterizationSet={};this._oEntityTypeSet={};this._oEntitySetSet={};this._oEntityTypeNameToEntitySetMap={};var a=this._oModel.getServiceMetadata().dataServices.schema[0];for(var j=-1,C;(C=a.entityContainer[++j])!==undefined;){if(C.isDefaultEntityContainer=="true"){this._oDefaultEntityContainer=C;break;}}var E=a.entityType;var q=[],P=[],u=[];for(var k=-1,T;(T=E[++k])!==undefined;){var b=false;if(T.extensions!=undefined){for(var l=-1,f;(f=T.extensions[++l])!==undefined;){if(f.namespace==o.constants.SAP_NAMESPACE&&f.name=="semantics"){b=true;switch(f.value){case"aggregate":q.push(T);break;case"parameters":P.push(T);break;default:u.push(T);}}if(b){continue;}}if(!b){u.push(T);}}else{u.push(T);}}for(var m=-1,g;(g=u[++m])!==undefined;){var h=new o.EntityType(this._oModel.getServiceMetadata(),a,g);this._oEntityTypeSet[h.getQName()]=h;var i=this._getEntitySetsOfType(a,h.getQName());if(i.length==0){throw"Invalid consumption model: No entity set for entity type "+h.getQName()+" found";}if(i.length>1){throw"Unsupported consumption model: More than one entity set for entity type "+h.getQName()+" found";}var v=new o.EntitySet(this._oModel.getServiceMetadata(),a,i[0][0],i[0][1],h);this._oEntitySetSet[v.getQName()]=v;this._oEntityTypeNameToEntitySetMap[h.getQName()]=v;}var w={};for(var n=-1,x;(x=P[++n])!==undefined;){var y=new o.EntityType(this._oModel.getServiceMetadata(),a,x);this._oEntityTypeSet[y.getQName()]=y;var z=this._getEntitySetsOfType(a,y.getQName());if(z.length==0){throw"Invalid consumption model: No entity set for parameter entity type "+y.getQName()+" found";}if(z.length>1){throw"Unsupported consumption model: More than one entity set for parameter entity type "+y.getQName()+" found";}var B=new o.EntitySet(this._oModel.getServiceMetadata(),a,z[0][0],z[0][1],y);this._oEntitySetSet[B.getQName()]=B;this._oEntityTypeNameToEntitySetMap[y.getQName()]=B;var D=new o.Parameterization(y,B);this._oParameterizationSet[D.getName()]=D;w[y.getQName()]=D;var G=y.getQName();if(a.association!=undefined){for(var p=-1,H;(H=a.association[++p])!==undefined;){if(H.referentialConstraint==undefined){continue;}var I=null;if(H.end[0].type==G&&H.end[0].multiplicity=="*"&&H.end[1].multiplicity=="1"){I=H.end[1].type;}else if(H.end[1].type==G&&H.end[1].multiplicity=="*"&&H.end[0].multiplicity=="1"){I=H.end[0].type;}if(!I){continue;}if(H.referentialConstraint.dependent.propertyRef.length!=1){continue;}var J=D.findParameterByName(H.referentialConstraint.dependent.propertyRef[0].name);if(J==null){continue;}var V=this._oEntityTypeSet[I];var K=this._oEntityTypeNameToEntitySetMap[I];J.setValueSetEntity(V,K);}}}for(var r=-1,L;(L=q[++r])!==undefined;){var N=new o.EntityType(this._oModel.getServiceMetadata(),a,L);this._oEntityTypeSet[N.getQName()]=N;var Q=N.getQName();var O=null;var R=null;if(a.association!=undefined){for(var s=-1,U;(U=a.association[++s])!==undefined;){var W=null;if(U.end[0].type==Q){W=U.end[1].type;}else if(U.end[1].type==Q){W=U.end[0].type;}else{continue;}var X=null;X=w[W];if(X!=null){if(O!=null){throw"LIMITATION: Unable to handle multiple parameter entity types of query entity "+N.name;}else{O=X;R=U;}}}}var Y=this._getEntitySetsOfType(a,N.getQName());if(Y.length!=1){throw"Invalid consumption model: There must be exactly one entity set for an entity type annotated with aggregating semantics";}var Z=new o.EntitySet(this._oModel.getServiceMetadata(),a,Y[0][0],Y[0][1],N);this._oEntitySetSet[Z.getQName()]=Z;this._oEntityTypeNameToEntitySetMap[N.getQName()]=Z;var $=new o.QueryResult(this,N,Z,O);this._oQueryResultSet[$.getName()]=$;if(O){O.setTargetQueryResult($,R);}if(a.association!=undefined){for(var t=-1,_;(_=a.association[++t])!==undefined;){if(_.referentialConstraint==undefined){continue;}var a1=null;if(_.end[0].type==Q&&_.end[0].multiplicity=="*"&&_.end[1].multiplicity=="1"){a1=_.end[1].type;}else if(_.end[1].type==Q&&_.end[1].multiplicity=="*"&&_.end[0].multiplicity=="1"){a1=_.end[0].type;}if(!a1){continue;}if(_.referentialConstraint.dependent.propertyRef.length!=1){continue;}var b1=$.findDimensionByName(_.referentialConstraint.dependent.propertyRef[0].name);if(b1==null){continue;}var c1=this._oEntityTypeNameToEntitySetMap[a1];b1.setMembersEntitySet(c1);}}}},oUI5ODataModelAnnotatableObject:{objectName:"schema",keyPropName:"namespace",extensions:true,aSubObject:[{objectName:"entityType",keyPropName:"name",extensions:true,aSubObject:[{objectName:"property",keyPropName:"name",aSubObject:[],extensions:true}]},{objectName:"entityContainer",keyPropName:"name",extensions:false,aSubObject:[{objectName:"entitySet",keyPropName:"name",extensions:true,aSubObject:[]}]}]},mergeV2Annotations:function(a){var b=null;try{b=JSON.parse(a);}catch(f){return;}var m;try{m=this._oModel.getServiceMetadata().dataServices;}catch(f){return;}for(var p in b){if(!(this.oUI5ODataModelAnnotatableObject.objectName==p)){continue;}if(!(b[p]instanceof Array)){continue;}this.mergeV2AnnotationLevel(m[this.oUI5ODataModelAnnotatableObject.objectName],b[this.oUI5ODataModelAnnotatableObject.objectName],this.oUI5ODataModelAnnotatableObject);break;}return;},mergeV2AnnotationLevel:function(M,a,u){for(var i=-1,b;(b=a[++i])!==undefined;){for(var j=-1,f;(f=M[++j])!==undefined;){if(!(b[u.keyPropName]==f[u.keyPropName])){continue;}if(b["extensions"]!=undefined){if(f["extensions"]==undefined){f["extensions"]=[];}for(var l=-1,g;(g=b["extensions"][++l])!==undefined;){var h=false;for(var m=-1,n;(n=f["extensions"][++m])!==undefined;){if(g.name==n.name&&g.namespace==n.namespace){n.value=g.value;h=true;break;}}if(!h){f["extensions"].push(g);}}}for(var k=-1,U;(U=u.aSubObject[++k])!==undefined;){for(var p in b){if(!(U.objectName==p)){continue;}if(!(b[U.objectName]instanceof Array)){continue;}if((f[U.objectName]==undefined)||(!(f[U.objectName]instanceof Array))){continue;}this.mergeV2AnnotationLevel(f[U.objectName],b[U.objectName],U);break;}}}}return;},findQueryResultByName:function(n){var q=this._oQueryResultSet[n];if(!q&&this._oDefaultEntityContainer){var Q=this._oDefaultEntityContainer.name+"."+n;q=this._oQueryResultSet[Q];}return q;},getAllQueryResultNames:function(){if(this._aQueryResultNames){return this._aQueryResultNames;}this._aQueryResultNames=new Array(0);for(var n in this._oQueryResultSet){this._aQueryResultNames.push(this._oQueryResultSet[n].getName());}return this._aQueryResultNames;},getAllQueryResults:function(){return this._oQueryResultSet;},getODataModel:function(){return this._oModel;},_getEntitySetsOfType:function(s,q){var E=[];for(var i=-1,a;(a=s.entityContainer[++i])!==undefined;){for(var j=-1,b;(b=a.entitySet[++j])!==undefined;){if(b.entityType==q){E.push([a,b]);}}}return E;},_mParameter:null,_oModel:null,_oDefaultEntityContainer:null,_aQueryResultNames:null,_oQueryResultSet:null,_oParameterizationSet:null,_oEntityTypeSet:null,_oEntitySetSet:null,_oEntityTypeNameToEntitySetMap:null,_oActivatedWorkarounds:null};
o.QueryResult=function(m,E,a,p){this._init(m,E,a,p);};
o.QueryResult.prototype={_init:function(m,E,a,p,b){this._oModel=m;this._oEntityType=E;this._oEntitySet=a;this._oParameterization=p;this._oDimensionSet={};this._oMeasureSet={};var P=E.getTypeDescription().property;var f={};for(var i=-1,g;(g=P[++i])!==undefined;){if(g.extensions==undefined){continue;}for(var j=-1,h;(h=g.extensions[++j])!==undefined;){if(!h.namespace==o.constants.SAP_NAMESPACE){continue;}switch(h.name){case"aggregation-role":switch(h.value){case"dimension":{var D=new o.Dimension(this,g);this._oDimensionSet[D.getName()]=D;break;}case"measure":{var M=new o.Measure(this,g);this._oMeasureSet[M.getName()]=M;break;}case"totaled-properties-list":this._oTotaledPropertyListProperty=g;break;default:}break;case"attribute-for":{var k=new o.DimensionAttribute(this,g);var K=k.getKeyProperty();f[K.name]=k;break;}default:}}}for(var s in f){var l=f[s];l.getDimension().addAttribute(l);}if(m._oActivatedWorkarounds.IdentifyTextPropertiesByName){var n=[];for(var q in this._oDimensionSet){var r=this._oDimensionSet[q];if(!r.getTextProperty()){var T=null;T=E.findPropertyByName(q+"Name");if(!T){T=E.findPropertyByName(q+"Text");}if(!T){T=E.findPropertyByName(q+"Desc");}if(!T){T=E.findPropertyByName(q+"Description");}if(T){r.setTextProperty(T);n.push(T.name);}}}for(var t=-1,u;(u=n[++t])!==undefined;){delete this._oDimensionSet[u];}}},getName:function(){return this.getEntitySet().getQName();},getParameterization:function(){return this._oParameterization;},getAllDimensionNames:function(){if(this._aDimensionNames){return this._aDimensionNames;}this._aDimensionNames=[];for(var n in this._oDimensionSet){this._aDimensionNames.push(this._oDimensionSet[n].getName());}return this._aDimensionNames;},getAllDimensions:function(){return this._oDimensionSet;},getAllMeasureNames:function(){if(this._aMeasureNames){return this._aMeasureNames;}this._aMeasureNames=[];for(var n in this._oMeasureSet){this._aMeasureNames.push(this._oMeasureSet[n].getName());}return this._aMeasureNames;},getAllMeasures:function(){return this._oMeasureSet;},findDimensionByName:function(n){return this._oDimensionSet[n];},findDimensionByPropertyName:function(n){if(this._oDimensionSet[n]){return this._oDimensionSet[n];}for(var D in this._oDimensionSet){var a=this._oDimensionSet[D];var t=a.getTextProperty();if(t&&t.name==n){return a;}if(a.findAttributeByName(n)){return a;}}return null;},getTotaledPropertiesListProperty:function(){return this._oTotaledPropertyListProperty;},findMeasureByName:function(n){return this._oMeasureSet[n];},findMeasureByPropertyName:function(n){if(this._oMeasureSet[n]){return this._oMeasureSet[n];}for(var m in this._oMeasureSet){var M=this._oMeasureSet[m];var f=M.getFormattedValueProperty();if(f&&f.name==n){return M;}}return null;},getModel:function(){return this._oModel;},getEntityType:function(){return this._oEntityType;},getEntitySet:function(){return this._oEntitySet;},_oModel:null,_oEntityType:null,_oEntitySet:null,_oParameterization:null,_aDimensionNames:null,_oDimensionSet:null,_aMeasureNames:null,_oMeasureSet:null,_oTotaledPropertyListProperty:null};
o.Parameterization=function(E,a){this._init(E,a);};
o.Parameterization.prototype={_init:function(E,a){this._oEntityType=E;this._oEntitySet=a;this._oParameterSet={};var p=E.getTypeDescription().property;for(var i=-1,P;(P=p[++i])!==undefined;){if(P.extensions==undefined){continue;}for(var j=-1,b;(b=P.extensions[++j])!==undefined;){if(!b.namespace==o.constants.SAP_NAMESPACE){continue;}switch(b.name){case"parameter":{var f=new o.Parameter(this,P);this._oParameterSet[f.getName()]=f;break;}default:}}}},setTargetQueryResult:function(q,a){this._oQueryResult=q;var Q=this._oEntityType.getSchema().namespace+"."+a.name;var n=this._oEntityType.getTypeDescription().navigationProperty;if(!n){throw"Invalid consumption model: Parameters entity type lacks navigation property for association to query result entity type";}for(var i=-1,N;(N=n[++i])!==undefined;){if(N.relationship==Q){this._oNavPropToQueryResult=N.name;}}if(!this._oNavPropToQueryResult){throw"Invalid consumption model: Parameters entity type lacks navigation property for association to query result entity type";}},getTargetQueryResult:function(){if(!this._oQueryResult){throw"No target query result set";}return this._oQueryResult;},getName:function(){return this.getEntitySet().getQName();},getAllParameterNames:function(){if(this._aParameterNames){return this._aParameterNames;}this._aParameterNames=[];for(var n in this._oParameterSet){this._aParameterNames.push(this._oParameterSet[n].getName());}return this._aParameterNames;},getAllParameters:function(){return this._oParameterSet;},findParameterByName:function(n){return this._oParameterSet[n];},getNavigationPropertyToQueryResult:function(){return this._oNavPropToQueryResult;},getEntityType:function(){return this._oEntityType;},getEntitySet:function(){return this._oEntitySet;},_oEntityType:null,_oEntitySet:null,_oQueryResult:null,_oNavPropToQueryResult:null,_aParameterNames:null,_oParameterSet:null};
o.Parameter=function(p,P){this._init(p,P);};
o.Parameter.prototype={_init:function(p,P){this._oParameterization=p;this._oProperty=P;var E=p.getEntityType();if(P.extensions!=undefined){for(var i=-1,a;(a=P.extensions[++i])!==undefined;){if(!a.namespace==o.constants.SAP_NAMESPACE){continue;}switch(a.name){case"parameter":switch(a.value){case"mandatory":this._bRequired=true;break;case"optional":this._bRequired=false;break;default:throw"Invalid annotation value for parameter property";}break;case"label":this._sLabelText=a.value;break;case"text":this._oTextProperty=E.findPropertyByName(a.value);break;case"upper-boundary":this._bIntervalBoundaryParameter=true;this._oUpperIntervalBoundaryParameterProperty=E.findPropertyByName(a.value);break;case"lower-boundary":this._bIntervalBoundaryParameter=true;this._oLowerIntervalBoundaryParameterProperty=E.findPropertyByName(a.value);break;default:}}}if(!this._sLabelText){this._sLabelText="";}},setValueSetEntity:function(E,a){this._oValueSetEntityType=E;this._oValueSetEntitySet=a;},getTextProperty:function(){return this._oTextProperty;},getLabelText:function(){if(!this._sLabelText&&this._oParameterization._oQueryResult._oModel._oActivatedWorkarounds.CreateLabelsFromTechnicalNames){this._sLabelText=o.helper.tokenizeNametoLabelText(this.getName());}return this._sLabelText;},isOptional:function(){return(!this._bRequired);},isIntervalBoundary:function(){return this._bIntervalBoundaryParameter;},isLowerIntervalBoundary:function(){return(this._oUpperIntervalBoundaryParameterProperty?true:false);},getPeerIntervalBoundaryParameter:function(){var p=null;if(this._oLowerIntervalBoundaryParameterProperty){p=this._oLowerIntervalBoundaryParameterProperty.name;}else{p=this._oUpperIntervalBoundaryParameterProperty.name;}if(!p){throw"Parameter is not an interval boundary";}return this._oParameterization.findParameterByName(p);},isValueSetAvailable:function(){return(this._oValueSetEntityType?true:false);},getName:function(){return this._oProperty.name;},getProperty:function(){return this._oProperty;},getContainingParameterization:function(){return this._oParameterization;},getURIToValueEntitySet:function(s){var u=null;u=(s?s:"")+"/"+this._oValueSetEntitySet.getQName();return u;},_oParameterization:null,_oProperty:null,_sLabelText:null,_oTextProperty:null,_bRequired:false,_bIntervalBoundaryParameter:false,_oLowerIntervalBoundaryParameterProperty:null,_oUpperIntervalBoundaryParameterProperty:null,_oValueSetEntityType:null,_oValueSetEntitySet:null};
o.Dimension=function(q,p){this._init(q,p);};
o.Dimension.prototype={_init:function(q,p){this._oQueryResult=q;this._oProperty=p;this._oAttributeSet={};},setMembersEntitySet:function(E){this._oMembersEntitySet=E;},getName:function(){return this._oProperty.name;},getKeyProperty:function(){return this._oProperty;},getTextProperty:function(){if(!this._oTextProperty){this._oTextProperty=this._oQueryResult.getEntityType().getTextPropertyOfProperty(this.getName());}return this._oTextProperty;},setTextProperty:function(t){this._oTextProperty=t;},getLabelText:function(){if(!this._sLabelText){this._sLabelText=this._oQueryResult.getEntityType().getLabelOfProperty(this.getName());}if(!this._sLabelText&&this._oQueryResult._oModel._oActivatedWorkarounds.CreateLabelsFromTechnicalNames){this._sLabelText=o.helper.tokenizeNametoLabelText(this.getName());}return(this._sLabelText==null?"":this._sLabelText);},getSuperOrdinateDimension:function(){if(!this._sSuperOrdinateDimension){var s=this._oQueryResult.getEntityType().getSuperOrdinatePropertyOfProperty(this.getName());if(s){this._sSuperOrdinateDimension=this._oQueryResult.findDimensionByName(s.name);}}return this._sSuperOrdinateDimension;},getHierarchy:function(){if(!this._oHierarchy){this._oHierarchy=this._oQueryResult.getEntityType().getHierarchy(this._oProperty.name);}return this._oHierarchy;},getAllAttributeNames:function(){if(this._aAttributeNames){return this._aAttributeNames;}this._aAttributeNames=[];for(var n in this._oAttributeSet){this._aAttributeNames.push(this._oAttributeSet[n].getName());}return this._aAttributeNames;},getAllAttributes:function(){return this._oAttributeSet;},findAttributeByName:function(n){return this._oAttributeSet[n];},addAttribute:function(D){this._oAttributeSet[D.getName()]=D;},getContainingQueryResult:function(){return this._oQueryResult;},hasMasterData:function(){return this._oMembersEntitySet!=null?true:false;},getMasterDataEntitySet:function(){return this._oMembersEntitySet;},_oQueryResult:null,_oProperty:null,_oTextProperty:null,_sLabelText:null,_sSuperOrdinateDimension:null,_aAttributeNames:null,_oAttributeSet:null,_oMembersEntitySet:null,_oHierarchy:null};
o.DimensionAttribute=function(q,p){this._init(q,p);};
o.DimensionAttribute.prototype={_init:function(q,p){this._oQueryResult=q;this._oProperty=p;if(p.extensions!=undefined){for(var i=-1,E;(E=p.extensions[++i])!==undefined;){if(!E.namespace==o.constants.SAP_NAMESPACE){continue;}switch(E.name){case"attribute-for":this._sDimensionName=E.value;break;case"label":this._sLabelText=E.value;break;case"text":this._oTextProperty=q.getEntityType().findPropertyByName(E.value);break;default:}}}},getName:function(){return this._oProperty.name;},getKeyProperty:function(){return this._oProperty;},getTextProperty:function(){return this._oTextProperty;},getLabelText:function(){if(!this._sLabelText&&this._oQueryResult._oModel._oActivatedWorkarounds.CreateLabelsFromTechnicalNames){this._sLabelText=o.helper.tokenizeNametoLabelText(this.getName());}return this._sLabelText;},getDimension:function(){return this._oQueryResult.findDimensionByName(this._sDimensionName);},_oQueryResult:null,_oProperty:null,_oTextProperty:null,_sLabelText:null,_sDimensionName:null};
o.Measure=function(q,p){this._init(q,p);};
o.Measure.prototype={_init:function(q,p){this._oQueryResult=q;this._oProperty=p;if(p.extensions!=undefined){for(var i=-1,E;(E=p.extensions[++i])!==undefined;){if(!E.namespace==o.constants.SAP_NAMESPACE){continue;}switch(E.name){case"label":this._sLabelText=E.value;break;case"text":this._oTextProperty=q.getEntityType().findPropertyByName(E.value);break;case"unit":this._oUnitProperty=q.getEntityType().findPropertyByName(E.value);break;default:}}}if(!this._sLabelText){this._sLabelText="";}},getName:function(){return this._oProperty.name;},getRawValueProperty:function(){return this._oProperty;},getFormattedValueProperty:function(){return this._oTextProperty;},getUnitProperty:function(){return this._oUnitProperty;},getLabelText:function(){if(!this._sLabelText&&this._oQueryResult._oModel._oActivatedWorkarounds.CreateLabelsFromTechnicalNames){this._sLabelText=o.helper.tokenizeNametoLabelText(this.getName());}return this._sLabelText;},isUpdatable:function(){if(this._bIsUpdatable!=null){return this._bIsUpdatable;}var u=this._oQueryResult.getEntitySet().getUpdatablePropertyNameSet();return(u[this.getName()]!=undefined);},_oQueryResult:null,_oProperty:null,_oTextProperty:null,_sLabelText:null,_oUnitProperty:null,_bIsUpdatable:null};
o.EntitySet=function(m,s,C,E,a){this._init(m,s,C,E,a);};
o.EntitySet.prototype={_init:function(m,s,C,E,a){this._oEntityType=a;this._oEntitySet=E;this._oContainer=C;this._oSchema=s;this._oModel=m;if(s.entityContainer.length>1){this._sQName=C.name+"."+E.name;}else{this._sQName=E.name;}},getQName:function(){return this._sQName;},getSetDescription:function(){return this._oEntitySet;},getEntityType:function(){return this._oEntityType;},getSchema:function(){return this._oSchema;},getModel:function(){return this._oModel;},getUpdatablePropertyNameSet:function(){if(this._oUpdatablePropertyNames){return this._oUpdatablePropertyNames;}this._oUpdatablePropertyNames={};var s=true;if(this._oEntitySet.extensions!=undefined){for(var j=-1,E;(E=this._oEntitySet.extensions[++j])!==undefined;){if(E.namespace==o.constants.SAP_NAMESPACE&&E.name=="updatable"){if(E.value=="false"){s=false;break;}}}}if(!s){return this._oUpdatablePropertyNames;}var p=this._oEntityType.getTypeDescription().property;for(var i=-1,P;(P=p[++i])!==undefined;){var b=true;if(P.extensions==undefined){continue;}for(var k=-1,a;(a=P.extensions[++k])!==undefined;){if(a.namespace!=o.constants.SAP_NAMESPACE){continue;}if(a.name=="updatable"){if(a.value=="false"){b=false;break;}}}if(b){this._oUpdatablePropertyNames[P.name]=true;}}return this._oUpdatablePropertyNames;},_oEntityType:null,_oEntitySet:null,_oContainer:null,_oSchema:null,_oModel:null,_sQName:null,_oUpdatablePropertyNames:null};
o.EntityType=function(m,s,E){this._init(m,s,E);};
o.EntityType.propertyFilterRestriction={SINGLE_VALUE:"single-value",MULTI_VALUE:"multi-value",INTERVAL:"interval"};o.EntityType.prototype={_init:function(m,s,E){this._oEntityType=E;this._oSchema=s;this._oModel=m;this._aKeyProperties=[];this._oPropertySet={};this._aFilterablePropertyNames=[];this._aSortablePropertyNames=[];this._aRequiredFilterPropertyNames=[];this._oPropertyFilterRestrictionSet={};this._oPropertyHeadingsSet={};this._oPropertyQuickInfosSet={};this._sQName=s.namespace+"."+E.name;var r={};function g(K){var R=r[K];if(!R){R=r[K]={};}return R;}for(var i=-1,p;(p=E.key.propertyRef[++i])!==undefined;){this._aKeyProperties.push(p.name);}for(var k=-1,P;(P=E.property[++k])!==undefined;){this._oPropertySet[P.name]=P;this._aFilterablePropertyNames.push(P.name);this._aSortablePropertyNames.push(P.name);if(P.extensions==undefined){continue;}for(var j=-1,a;(a=P.extensions[++j])!==undefined;){if(a.namespace!==o.constants.SAP_NAMESPACE){continue;}switch(a.name){case"filterable":if(a.value=="false"){this._aFilterablePropertyNames.pop(P.name);}break;case"sortable":if(a.value=="false"){this._aSortablePropertyNames.pop(P.name);}break;case"required-in-filter":if(a.value=="true"){this._aRequiredFilterPropertyNames.push(P.name);}break;case"filter-restriction":if(a.value==o.EntityType.propertyFilterRestriction.SINGLE_VALUE||a.value==o.EntityType.propertyFilterRestriction.MULTI_VALUE||a.value==o.EntityType.propertyFilterRestriction.INTERVAL){this._oPropertyFilterRestrictionSet[P.name]=a.value;}break;case"hierarchy-node-external-key-for":g(a.value).externalKeyProperty=P;break;case"hierarchy-node-for":g(P.name).dimensionName=a.value;break;case"hierarchy-parent-node-for":case"hierarchy-parent-nod":g(a.value).parentNodeIDProperty=P;break;case"hierarchy-level-for":g(a.value).levelProperty=P;break;case"hierarchy-drill-state-for":case"hierarchy-drill-stat":g(a.value).drillStateProperty=P;break;default:}}}this._oRecursiveHierarchySet={};for(var h in r){var H=r[h];var b=this._oPropertySet[h];var D=this._oPropertySet[H.dimensionName];if(D==null){D=b;}this._oRecursiveHierarchySet[D.name]=new o.RecursiveHierarchy(E,b,H.parentNodeIDProperty,H.levelProperty,D,H.externalKeyProperty);}},getProperties:function(){return this._oPropertySet;},findPropertyByName:function(p){return this._oPropertySet[p];},getKeyProperties:function(){return this._aKeyProperties;},getLabelOfProperty:function(p){var P=this._oPropertySet[p];if(P==null){throw"no such property with name "+p;}if(P.extensions!=undefined){for(var i=-1,E;(E=P.extensions[++i])!==undefined;){if(!E.namespace==o.constants.SAP_NAMESPACE){continue;}if(E.name=="label"){return E.value;}}}return null;},getHeadingOfProperty:function(p){var P=this._oPropertySet[p];if(P==null){throw"no such property with name "+p;}var s=null;if(P.extensions!=undefined){for(var i=-1,E;(E=P.extensions[++i])!==undefined;){if(!E.namespace==o.constants.SAP_NAMESPACE){continue;}if(E.name=="heading"){return E.value;}if(E.name=="label"){s=E.value;}}}return s;},getQuickInfoOfProperty:function(p){var P=this._oPropertySet[p];if(P==null){throw"no such property with name "+p;}var s=null;if(P.extensions!=undefined){for(var i=-1,E;(E=P.extensions[++i])!==undefined;){if(!E.namespace==o.constants.SAP_NAMESPACE){continue;}if(E.name=="quickinfo"){return E.value;}if(E.name=="label"){s=E.value;}}}return s;},getTextPropertyOfProperty:function(p){var P=this._oPropertySet[p];if(P==null){throw"no such property with name "+p;}if(P.extensions!=undefined){for(var i=-1,E;(E=P.extensions[++i])!==undefined;){if(E.name=="text"){return this.findPropertyByName(E.value);}}}return null;},getSuperOrdinatePropertyOfProperty:function(p){var P=this._oPropertySet[p];if(P==null){throw"no such property with name "+p;}if(P.extensions!=undefined){for(var i=-1,E;(E=P.extensions[++i])!==undefined;){if(E.name=="super-ordinate"){return this.findPropertyByName(E.value);}}}return null;},getFilterablePropertyNames:function(){return this._aFilterablePropertyNames;},getSortablePropertyNames:function(){return this._aSortablePropertyNames;},getRequiredFilterPropertyNames:function(){return this._aRequiredFilterPropertyNames;},getPropertiesWithFilterRestrictions:function(){return this._oPropertyFilterRestrictionSet;},getAllHierarchyPropertyNames:function(){if(this._aHierarchyPropertyNames){return this._aHierarchyPropertyNames;}this._aHierarchyPropertyNames=[];for(var n in this._oRecursiveHierarchySet){this._aHierarchyPropertyNames.push(this._oRecursiveHierarchySet[n].getNodeValueProperty().name);}return this._aHierarchyPropertyNames;},getHierarchy:function(n){if(this._oRecursiveHierarchySet[n]==undefined){return null;}return this._oRecursiveHierarchySet[n];},getQName:function(){return this._sQName;},getTypeDescription:function(){return this._oEntityType;},getSchema:function(){return this._oSchema;},getModel:function(){return this._oModel;},_oEntityType:null,_oSchema:null,_oModel:null,_sQName:null,_aKeyProperties:null,_oPropertySet:null,_aFilterablePropertyNames:null,_aRequiredFilterPropertyNames:null,_oPropertyFilterRestrictionSet:null,_aHierarchyPropertyNames:null,_oRecursiveHierarchySet:null};
o.RecursiveHierarchy=function(E,n,p,N,a,b){this._init(E,n,p,N,a,b);};
o.RecursiveHierarchy.prototype={_init:function(E,n,p,N,a,b){this._oEntityType=E;this._oNodeIDProperty=n;this._oParentNodeIDProperty=p;this._oNodeLevelProperty=N;this._oNodeValueProperty=a;this._oNodeExternalKeyProperty=b;},isRecursiveHierarchy:function(){return true;},isLeveledHierarchy:function(){return false;},getNodeExternalKeyProperty:function(){return this._oNodeExternalKeyProperty;},getNodeIDProperty:function(){return this._oNodeIDProperty;},getParentNodeIDProperty:function(){return this._oParentNodeIDProperty;},getNodeLevelProperty:function(){return this._oNodeLevelProperty;},getNodeValueProperty:function(){return this._oNodeValueProperty;},_oEntityType:null,_oNodeIDProperty:null,_oParentNodeIDProperty:null,_oNodeLevelProperty:null,_oNodeValueProperty:null,_oNodeExternalKeyProperty:null};
o.FilterExpression=function(m,s,E){this._init(m,s,E);};
o.FilterExpression.prototype={_init:function(m,s,E){this._oEntityType=E;this._oSchema=s;this._oModel=m;this._aConditionUI5Filter=[];this._aUI5FilterArray=[];},_renderPropertyFilterValue:function(f,p){if(p==="Edm.Time"&&d.test(f)){f={ms:parseInt(f),__edmType:"Edm.Time"};}return e(this._oModel.getODataModel().formatValue(f,p));},clear:function(){this._aConditionUI5Filter=[];this._aUI5FilterArray=[];},_addCondition:function(p,O,v,V){for(var i=-1,u;(u=this._aConditionUI5Filter[++i])!==undefined;){if(u.sPath==p&&u.sOperator==O&&u.oValue1==v&&u.oValue2==V){return;}}this._aConditionUI5Filter.push(new F(p,O,v,V));},_addUI5FilterArray:function(u){this._aUI5FilterArray.push(u);},addCondition:function(p,O,v,V){var P=this._oEntityType.findPropertyByName(p);if(P==null){throw"Cannot add filter condition for unknown property name "+p;}var f=this._oEntityType.getFilterablePropertyNames();if(((f?Array.prototype.indexOf.call(f,p):-1))===-1){throw"Cannot add filter condition for not filterable property name "+p;}this._addCondition(p,O,v,V);return this;},removeConditions:function(p){var P=this._oEntityType.findPropertyByName(p);if(P==null){throw"Cannot remove filter conditions for unknown property name "+p;}for(var i=0;i<this._aConditionUI5Filter.length;i++){var u=this._aConditionUI5Filter[i];if(u.sPath==p){this._aConditionUI5Filter.splice(i--,1);}}return this;},addSetCondition:function(p,v){var P=this._oEntityType.findPropertyByName(p);if(P==null){throw"Cannot add filter condition for unknown property name "+p;}var f=this._oEntityType.getFilterablePropertyNames();if(((f?Array.prototype.indexOf.call(f,p):-1))===-1){throw"Cannot add filter condition for not filterable property name "+p;}for(var i=-1,V;(V=v[++i])!==undefined;){this._addCondition(p,c.EQ,V);}return this;},addUI5FilterConditions:function(u){if(!Array.isArray(u)){throw"Argument is not an array";}if(u.length==0){return this;}var h=false;for(var i=0;i<u.length;i++){if(u[i].aFilters!=undefined){h=true;break;}}if(h){this._addUI5FilterArray(u);}else{for(var j=0;j<u.length;j++){this.addCondition(u[j].sPath,u[j].sOperator,u[j].oValue1,u[j].oValue2);}}return this;},getExpressionAsUI5FilterArray:function(){var f=this._aConditionUI5Filter.concat([]);for(var i=-1,a;(a=this._aUI5FilterArray[++i])!==undefined;){for(var j=-1,b;(b=a[++j])!==undefined;){f.push(b);}}return f;},getPropertiesReferencedByUI5FilterArray:function(u,r){for(var i=-1,U;(U=u[++i])!==undefined;){if(U.aFilters!=undefined){this.getPropertiesReferencedByUI5FilterArray(U.aFilters,r);}else{if(r[U.sPath]==undefined){r[U.sPath]=[];}r[U.sPath].push(U);}}},getReferencedProperties:function(){var r={};for(var i=-1,u;(u=this._aConditionUI5Filter[++i])!==undefined;){if(r[u.sPath]==undefined){r[u.sPath]=[];}r[u.sPath].push(u);}for(var j=-1,U;(U=this._aUI5FilterArray[++j])!==undefined;){this.getPropertiesReferencedByUI5FilterArray(U,r);}return r;},renderUI5Filter:function(u){var f=null,p=this._oEntityType.findPropertyByName(u.sPath);if(p==null){throw"Cannot add filter condition for unknown property name "+u.sPath;}switch(u.sOperator){case c.BT:f="("+u.sPath+" ge "+this._renderPropertyFilterValue(u.oValue1,p.type)+" and "+u.sPath+" le "+this._renderPropertyFilterValue(u.oValue2,p.type)+")";break;case c.NB:f="("+u.sPath+" lt "+this._renderPropertyFilterValue(u.oValue1,p.type)+" or "+u.sPath+" gt "+this._renderPropertyFilterValue(u.oValue2,p.type)+")";break;case c.Contains:case c.NotContains:f=(u.sOperator[0]==="N"?"not ":"")+"substringof("+this._renderPropertyFilterValue(u.oValue1,"Edm.String")+","+u.sPath+")";break;case c.StartsWith:case c.EndsWith:case c.NotStartsWith:case c.NotEndsWith:f=u.sOperator.toLowerCase().replace("not","not ")+"("+u.sPath+","+this._renderPropertyFilterValue(u.oValue1,"Edm.String")+")";break;default:f=u.sPath+" "+u.sOperator.toLowerCase()+" "+this._renderPropertyFilterValue(u.oValue1,p.type);}return f;},renderUI5MultiFilter:function(u){var U=[];var O="";var l=u.bAnd==true?" and ":" or ";for(var i=-1,a;(a=u.aFilters[++i])!==undefined;){if(a.aFilters!=undefined){U.push(a);continue;}O+=(O==""?"":l)+"("+this.renderUI5Filter(a)+")";}if(U.length>0){for(var j=-1,m;(m=U[++j])!==undefined;){O+=(O==""?"":l)+"("+this.renderUI5MultiFilter(m)+")";}}return O;},renderUI5FilterArray:function(u){if(u.length==0){return"";}var O="";u.sort(function(a,b){if(a.sPath==b.sPath){return 0;}if(a.sPath>b.sPath){return 1;}else{return-1;}});var p=u[0].sPath;var s="";var n=[],U=[];for(var i=-1,f;(f=u[++i])!==undefined;){if(f.aFilters!=undefined){U.push(f);continue;}if(p!=f.sPath){if(s!=""){O+=(O==""?"":" and ")+"("+s+")";}s="";if(n.length>0){for(var j=-1,N;(N=n[++j])!==undefined;){s+=(s==""?"":" and ")+this.renderUI5Filter(N);}O+=(O==""?"":" and ")+"("+s+")";s="";}p=f.sPath;n=[];}if(f.sOperator==c.NE){n.push(f);continue;}s+=(s==""?"":" or ")+this.renderUI5Filter(f);}if(s!=""){O+=(O==""?"":" and ")+"("+s+")";}if(n.length>0){s="";for(var k=-1,g;(g=n[++k])!==undefined;){s+=(s==""?"":" and ")+this.renderUI5Filter(g);}O+=(O==""?"":" and ")+"("+s+")";}if(U.length>0){for(var l=-1,m;(m=U[++l])!==undefined;){O+=(O==""?"":" and ")+"("+this.renderUI5MultiFilter(m)+")";}}return O;},getURIFilterOptionValue:function(){var O=this.renderUI5FilterArray(this._aConditionUI5Filter);for(var i=-1,u;(u=this._aUI5FilterArray[++i])!==undefined;){O+=(O==""?"":" and ")+"("+this.renderUI5FilterArray(u)+")";}return O;},checkValidity:function(){var r=this._oEntityType.getRequiredFilterPropertyNames();var p=this.getReferencedProperties();for(var i=-1,P;(P=r[++i])!==undefined;){if(p[P]==undefined){throw"filter expression does not contain required property "+P;}}var a=this._oEntityType.getPropertiesWithFilterRestrictions();for(var s in a){var f=a[s];if(f==o.EntityType.propertyFilterRestriction.SINGLE_VALUE){if(p[s]!=undefined){if(p[s].length>1){var t=p[s][0].oValue1;for(var j=0;j<p[s].length;j++){if(p[s][j].oValue1!=t||p[s][j].sOperator!=c.EQ){throw"filter expression may use "+s+" only with a single EQ condition";}}}}}}return true;},getEntityType:function(){return this._oEntityType;},getSchema:function(){return this._oSchema;},getModel:function(){return this._oModel;},_oEntityType:null,_oSchema:null,_oModel:null,_aFilterCondition:null};o.SortOrder={Ascending:"asc",Descending:"desc"};
o.SortExpression=function(m,s,E){this._init(m,s,E);};
o.SortExpression.prototype={_init:function(m,s,E){this._oEntityType=E;this._oSchema=s;this._oModel=m;this._aSortCondition=[];},_containsSorter:function(p){var r=null;for(var i=-1,C;(C=this._aSortCondition[++i])!==undefined;){if(C.property.name===p){r={sorter:C,index:i};break;}}return r;},_removeFromArray:function(a,f,t){var r=a.slice((t||f)+1||a.length);a.length=f<0?a.length+f:f;return a.push.apply(a,r);},clear:function(){this._aSortCondition=[];},addSorter:function(p,s){var P=this._oEntityType.findPropertyByName(p);if(P==null){throw"Cannot add sort condition for unknown property name "+p;}var E=this._containsSorter(p);if(E!=null){E.sorter.order=s;return this;}var a=this._oEntityType.getSortablePropertyNames();if(((a?Array.prototype.indexOf.call(a,p):-1))===-1){throw"Cannot add sort condition for not sortable property name "+p;}this._aSortCondition.push({property:P,order:s});return this;},removeSorter:function(p){if(!p){return;}var s=this._containsSorter(p);if(s){this._removeFromArray(this._aSortCondition,s.index);}},getExpressionsAsUI5SorterArray:function(){var s=[];for(var i=-1,C;(C=this._aSortCondition[++i])!==undefined;){s.push(new S(C.property.name,C.order==o.SortOrder.Descending));}return s;},getExpressionAsUI5Sorter:function(){var s=this.getExpressionsAsUI5SorterArray();if(s.length==0){return null;}else{return s[0];}},getURIOrderByOptionValue:function(s){if(this._aSortCondition.length==0){return"";}var O="";for(var i=-1,C;(C=this._aSortCondition[++i])!==undefined;){if(!s[C.property.name]){continue;}O+=(O==""?"":",")+C.property.name+" "+C.order;}return O;},getEntityType:function(){return this._oEntityType;},getSchema:function(){return this._oSchema;},getModel:function(){return this._oModel;},_oEntityType:null,_oSchema:null,_oModel:null,_aSortCondition:null};
o.ParameterizationRequest=function(p){this._init(p);};
o.ParameterizationRequest.prototype={_init:function(p){if(!p){throw"No parameterization given";}this._oParameterization=p;this._oParameterValueAssignment=[];},_renderParameterKeyValue:function(k,p){return e(this._oParameterization.getTargetQueryResult().getModel().getODataModel().formatValue(k,p));},getParameterization:function(){return this._oParameterization;},setParameterValue:function(p,v,t){var P=this._oParameterization.findParameterByName(p);if(!P){throw"Invalid parameter name "+p;}if(t!=null){if(!P.isIntervalBoundary()){throw"Range value cannot be applied to parameter "+p+" accepting only single values";}if(!P.isLowerIntervalBoundary()){throw"Range value given, but parameter "+p+" does not hold the lower boundary";}}if(!P.isIntervalBoundary()){if(v==null){delete this._oParameterValueAssignment[p];}else{this._oParameterValueAssignment[p]=v;}}else{if(v==null&&t!=null){throw"Parameter "+p+": An upper boundary cannot be given without the lower boundary";}if(v==null){delete this._oParameterValueAssignment[p];t=null;}else{this._oParameterValueAssignment[p]=v;}var u=P.getPeerIntervalBoundaryParameter();if(t==null){t=v;}if(v==null){delete this._oParameterValueAssignment[u.getName()];}else{this._oParameterValueAssignment[u.getName()]=t;}}return;},getURIToParameterizationEntitySet:function(s){return(s?s:"")+"/"+this._oParameterization.getEntitySet().getQName();},getURIToParameterizationEntry:function(s){var D=this._oParameterization.getAllParameters();for(var a in D){if(this._oParameterValueAssignment[a]==undefined){throw"Parameter "+a+" has no value assigned";}}var k="",f=true;for(var p in this._oParameterValueAssignment){k+=(f?"":",")+p+"="+this._renderParameterKeyValue(this._oParameterValueAssignment[p],D[p].getProperty().type);f=false;}return(s?s:"")+"/"+this._oParameterization.getEntitySet().getQName()+"("+k+")";},_oParameterization:null,_oParameterValueAssignment:null};
o.QueryResultRequest=function(q,p){this._init(q,p);};
o.QueryResultRequest.prototype={_init:function(q,p){this._oQueryResult=q;this._oParameterizationRequest=p;this._oAggregationLevel={};this._oDimensionHierarchies={};this._oMeasures={};this._bIncludeEntityKey=false;this._oFilterExpression=null;this._oSortExpression=null;this._oSelectedPropertyNames=null;},addRecursiveHierarchy:function(h,i,I){var D;if(!h){return;}D=this._oQueryResult.findDimensionByName(h);if(!D){throw new Error("'"+h+"' is not a dimension property");}if(!D.getHierarchy()){throw new Error("Dimension '"+h+"' does not have a hierarchy");}this._oSelectedPropertyNames=null;this._oDimensionHierarchies[h]={externalKey:i,id:true,text:I};},setParameterizationRequest:function(p){this._oParameterizationRequest=p;},setResourcePath:function(r){this._sResourcePath=r;if(this._sResourcePath.indexOf("/")!=0){throw"Missing leading / (slash) for resource path";}if(this._oQueryResult.getParameterization()){var l=r.lastIndexOf("/");if(l==-1){throw"Missing navigation from parameter entity set to query result in resource path";}var n=r.substring(l+1);if(n!=this._oQueryResult.getParameterization().getNavigationPropertyToQueryResult()){throw"Invalid navigation property from parameter entity set to query result in resource path";}}},getParameterizationRequest:function(){return this._oParameterizationRequest;},getQueryResult:function(){return this._oQueryResult;},setAggregationLevel:function(D){this._oAggregationLevel={};if(!D){D=this._oQueryResult.getAllDimensionNames();}this.addToAggregationLevel(D);this._oSelectedPropertyNames=null;},addToAggregationLevel:function(D){if(!D){return;}this._oSelectedPropertyNames=null;for(var i=-1,s;(s=D[++i])!==undefined;){if(!this._oQueryResult.findDimensionByName(s)){throw s+" is not a valid dimension name";}this._oAggregationLevel[s]={key:true,text:false,attributes:null};}},removeFromAggregationLevel:function(D){if(!D){return;}this._oSelectedPropertyNames=null;for(var i=-1,s;(s=D[++i])!==undefined;){if(!this._oQueryResult.findDimensionByName(s)){throw s+" is not a valid dimension name";}if(this._oAggregationLevel[s]!=undefined){delete this._oAggregationLevel[s];this.getSortExpression().removeSorter(s);}}},getAggregationLevel:function(){var D=[];for(var s in this._oAggregationLevel){D.push(s);}return D;},getAggregationLevelDetails:function(D){if(this._oAggregationLevel[D]==undefined){throw"Aggregation level does not include dimension "+D;}return this._oAggregationLevel[D];},setMeasures:function(m){if(!m){m=this._oQueryResult.getAllMeasureNames();}this._oSelectedPropertyNames=null;this._oMeasures={};for(var i=-1,M;(M=m[++i])!==undefined;){if(!this._oQueryResult.findMeasureByName(M)){throw M+" is not a valid measure name";}this._oMeasures[M]={value:true,text:false,unit:false};}},getMeasureNames:function(){var m=[];for(var M in this._oMeasures){m.push(M);}return m;},includeDimensionKeyTextAttributes:function(D,I,b,a){this._oSelectedPropertyNames=null;var f=[];if(D){if(this._oAggregationLevel[D]==undefined){throw D+" is not included in the aggregation level";}f.push(D);}else{for(var n in this._oAggregationLevel){f.push(n);}a=null;}for(var i=-1,s;(s=f[++i])!==undefined;){if(I!=null){this._oAggregationLevel[s].key=I;}if(b!=null){this._oAggregationLevel[s].text=b;}if(a!=null){this._oAggregationLevel[s].attributes=a;}}},includeMeasureRawFormattedValueUnit:function(m,I,b,a){this._oSelectedPropertyNames=null;var M=[];if(m){if(this._oMeasures[m]==undefined){throw m+" is not part of the query result";}M.push(m);}else{for(var n in this._oMeasures){M.push(n);}}for(var i=-1,s;(s=M[++i])!==undefined;){if(I!=null){this._oMeasures[s].value=I;}if(b!=null){this._oMeasures[s].text=b;}if(a!=null){this._oMeasures[s].unit=a;}}},getFilterExpression:function(){if(this._oFilterExpression==null){var E=this._oQueryResult.getEntityType();this._oFilterExpression=new o.FilterExpression(this._oQueryResult.getModel(),E.getSchema(),E);}return this._oFilterExpression;},setFilterExpression:function(f){this._oFilterExpression=f;},getSortExpression:function(){if(this._oSortExpression==null){var E=this._oQueryResult.getEntityType();this._oSortExpression=new o.SortExpression(E.getModel(),E.getSchema(),E);}return this._oSortExpression;},setSortExpression:function(s){this._oSortExpression=s;},setRequestOptions:function(i,I,r){if(i!=null){this._bIncludeEntityKey=i;}if(I!=null){this._bIncludeCount=I;}if(r!=null){this._bReturnNoEntities=r;}},setResultPageBoundaries:function(s,a){if(s!=null&&typeof s!=="number"){throw"Start value must be null or numeric";}if(a!==null&&typeof a!=="number"){throw"End value must be null or numeric";}if(s==null){s=1;}if(s<1||s>(a==null?s:a)){throw"Invalid values for requested page boundaries";}this._iSkipRequestOption=(s>1)?s-1:null;this._iTopRequestOption=(a!=null)?(a-s+1):null;},getResultPageBoundaries:function(){var E=null;if(this._iTopRequestOption!=null){if(this._iSkipRequestOption==null){E=1;}else{E=this._iSkipRequestOption+this._iTopRequestOption;}}return{start:(this._iSkipRequestOption==null)?1:this._iSkipRequestOption,end:E};},getURIToQueryResultEntitySet:function(s){var u=null;if(this._sResourcePath!=null){u=(s?s:"")+this._sResourcePath;}else if(this._oQueryResult.getParameterization()){if(!this._oParameterizationRequest){throw"Missing parameterization request";}else{u=this._oParameterizationRequest.getURIToParameterizationEntry(s)+"/"+this._oQueryResult.getParameterization().getNavigationPropertyToQueryResult();}}else{u=(s?s:"")+"/"+this._oQueryResult.getEntitySet().getQName();}return u;},getURIOrderByOptionValue:function(){var a,C,O=null,s=this._oSortExpression?this._oSortExpression._aSortCondition:[],i,n=s.length;if(n){a=this._oQueryResult.getAllMeasureNames();for(i=0;i<n;i+=1){C=s[i];if(!this._oSelectedPropertyNames[C.property.name]&&a.indexOf(C.property.name)<0){continue;}O=(O?O+",":"")+C.property.name+" "+C.order;}}return O;},getURIQueryOptionValue:function(q){var n,Q=null,s,t=this;function a(p){var P;if(!p){return;}P=typeof p==="string"?p:p.name;if(!t._oSelectedPropertyNames[P]){s+=(s==""?"":",")+P;t._oSelectedPropertyNames[P]=true;}}switch(q){case"$select":{s="";this._oSelectedPropertyNames={};for(n in this._oAggregationLevel){var D=this._oQueryResult.findDimensionByName(n);var b=this._oAggregationLevel[n];if(b.key==true){a(D.getKeyProperty());}if(b.text==true){a(D.getTextProperty());}if(b.attributes){for(var i=-1,f;(f=b.attributes[++i])!==undefined;){a(D.findAttributeByName(f).getName());}}}for(n in this._oMeasures){var m=this._oQueryResult.findMeasureByName(n);var M=this._oMeasures[n];if(M.value==true){a(m.getRawValueProperty());}if(M.text==true){a(m.getFormattedValueProperty());}if(M.unit==true){a(m.getUnitProperty());}}for(n in this._oDimensionHierarchies){var h=this._oQueryResult.findDimensionByName(n).getHierarchy();var H=this._oDimensionHierarchies[n];if(H.id){a(h.getNodeIDProperty());}if(H.externalKey){a(h.getNodeExternalKeyProperty());}if(H.text){a(this._oQueryResult.getEntityType().getTextPropertyOfProperty(h.getNodeIDProperty().name));}}if(this._bIncludeEntityKey){var k=this._oQueryResult.getEntityType().getTypeDescription().key.propertyRef;for(var j=-1,K;(K=k[++j])!==undefined;){s+=(s==""?"":",")+K.name;}}Q=(s?s:null);break;}case"$filter":{var g=null;if(this._oFilterExpression){g=this._oFilterExpression.getURIFilterOptionValue();}Q=(g?g:null);break;}case"$orderby":{Q=this.getURIOrderByOptionValue();break;}case"$top":{Q=null;if(this._bReturnNoEntities){Q=0;}else if(this._iTopRequestOption!==null){Q=this._iTopRequestOption;}break;}case"$skip":{Q=null;if(!this._bReturnNoEntities){Q=this._iSkipRequestOption;}break;}case"$inlinecount":{Q=(this._bIncludeCount==true?"allpages":null);break;}default:break;}return Q;},getURIToQueryResultEntries:function(s,r){if(!r){r=this.getURIToQueryResultEntitySet(s);}this.getFilterExpression().checkValidity();var a=this.getURIQueryOptionValue("$select");var f=this.getURIQueryOptionValue("$filter");var b=this.getURIQueryOptionValue("$orderby");var t=this.getURIQueryOptionValue("$top");var g=this.getURIQueryOptionValue("$skip");var i=this.getURIQueryOptionValue("$inlinecount");var u=r;var q=false;if(a!==null){u+="?$select="+a;q=true;}if(this._oFilterExpression&&f!==null){if(!q){u+="?";q=true;}else{u+="&";}u+="$filter="+f;}if(this._oSortExpression&&b!==null){if(!q){u+="?";q=true;}else{u+="&";}u+="$orderby="+b;}if((this._iTopRequestOption||this._bReturnNoEntities)&&t!==null){if(!q){u+="?";q=true;}else{u+="&";}u+="$top="+t;}if(this._iSkipRequestOption&&g!==null){if(!q){u+="?";q=true;}else{u+="&";}u+="$skip="+g;}if(this._bIncludeCount&&i!==null){if(!q){u+="?";q=true;}else{u+="&";}u+="$inlinecount="+i;}return u;},_oQueryResult:null,_oParameterizationRequest:null,_sResourcePath:null,_oAggregationLevel:null,_oDimensionHierarchies:null,_oMeasures:null,_bIncludeEntityKey:null,_bIncludeCount:null,_bReturnNoEntities:null,_oFilterExpression:null,_oSortExpression:null,_iSkipRequestOption:null,_iTopRequestOption:null};
o.ParameterValueSetRequest=function(p){this._init(p);};
o.ParameterValueSetRequest.prototype={_init:function(p){this._oParameter=p;this._oValueSetResult={};this._oFilterExpression=null;this._oSortExpression=null;},includeParameterText:function(i){if(i!=null){this._oValueSetResult.text=i;}},getFilterExpression:function(){if(this._oFilterExpression==null){var E=this._oParameter.getContainingParameterization().getEntityType();var m=this._oParameter.getContainingParameterization().getTargetQueryResult().getModel();this._oFilterExpression=new o.FilterExpression(m,E.getSchema(),E);}return this._oFilterExpression;},setFilterExpression:function(f){this._oFilterExpression=f;},getSortExpression:function(){if(this._oSortExpression==null){var E=this._oParameter.getContainingParameterization().getEntityType();this._oSortExpression=new o.SortExpression(E.getModel(),E.getSchema(),E);}return this._oSortExpression;},setSortExpression:function(s){this._oSortExpression=s;},getURIQueryOptionValue:function(q){var Q=null;switch(q){case"$select":{var s="";s+=(s==""?"":",")+this._oParameter.getProperty().name;if(this._oValueSetResult.text==true&&this._oParameter.getTextProperty()){s+=(s==""?"":",")+this._oParameter.getTextProperty().name;}Q=(s?s:null);break;}case"$filter":{var f=null;if(this._oFilterExpression){f=this._oFilterExpression.getURIFilterOptionValue();}Q=(f?f:null);break;}case"$orderby":{var a=null;if(this._oSortExpression){a=this._oSortExpression.getURIOrderByOptionValue();}Q=(a?a:null);break;}default:break;}return Q;},getURIToParameterValueSetEntries:function(s){var r=null;r=(s?s:"")+"/"+this._oParameter.getContainingParameterization().getEntitySet().getQName();this.getFilterExpression().checkValidity();var a=this.getURIQueryOptionValue("$select");var f=this.getURIQueryOptionValue("$filter");var b=this.getURIQueryOptionValue("$orderby");var u=r;var q=false;if(a){u+="?$select="+a;q=true;}if(this._oFilterExpression&&f){if(!q){u+="?";q=true;}else{u+="&";}u+="$filter="+f;}if(this._oSortExpression&&b){if(!q){u+="?";q=true;}else{u+="&";}u+="$orderby="+b;}return u;},_oParameter:null,_oFilterExpression:null,_oSortExpression:null,_oValueSetResult:null};
o.DimensionMemberSetRequest=function(D,p,u){this._init(D,p,u);};
o.DimensionMemberSetRequest.prototype={_init:function(D,p,u){this._oDimension=D;this._oParameterizationRequest=p;this._bUseMasterData=u;this._oValueSetResult={};this._oFilterExpression=null;this._oSortExpression=null;if(this._oParameterizationRequest!=null&&this._bUseMasterData==true){throw"LIMITATION: parameterized master data entity sets are not yet implemented";}if(this._bUseMasterData){this._oEntitySet=this._oDimension.getMasterDataEntitySet();}else{this._oEntitySet=this._oDimension.getContainingQueryResult().getEntitySet();if(this._oDimension.getContainingQueryResult().getParameterization()&&!this._oParameterizationRequest){throw"Missing parameterization request";}}},setParameterizationRequest:function(p){this._oParameterizationRequest=p;},includeDimensionTextAttributes:function(i,I){this._oValueSetResult.text={text:false,attributes:false};if(i==true){this._oValueSetResult.text=true;}if(I==true){this._oValueSetResult.attributes=true;}},getFilterExpression:function(){if(this._oFilterExpression==null){var E=this._oEntitySet.getEntityType();var m=this._oDimension.getContainingQueryResult().getModel();this._oFilterExpression=new o.FilterExpression(m,E.getSchema(),E);}return this._oFilterExpression;},setFilterExpression:function(f){this._oFilterExpression=f;},getSortExpression:function(){if(this._oSortExpression==null){this._oSortExpression=new o.SortExpression(this._oEntityType.getModel(),this._oEntityType.getSchema(),this._oEntityType);}return this._oSortExpression;},setSortExpression:function(s){this._oSortExpression=s;},setRequestOptions:function(i){if(i!=null){this._bIncludeCount=i;}},setResultPageBoundaries:function(s,a){if(s!=null&&typeof s!=="number"){throw"Start value must be null or numeric";}if(a!==null&&typeof a!=="number"){throw"End value must be null or numeric";}if(s==null){s=1;}if(s<1||s>(a==null?s:a)){throw"Invalid values for requested page boundaries";}this._iSkipRequestOption=(s>1)?s-1:null;this._iTopRequestOption=(a!=null)?(a-s+1):null;},getResultPageBoundaries:function(){var E=null;if(this._iTopRequestOption!=null){if(this._iSkipRequestOption==null){E=1;}else{E=this._iSkipRequestOption+this._iTopRequestOption;}}return{start:(this._iSkipRequestOption==null)?1:this._iSkipRequestOption,end:E};},getURIQueryOptionValue:function(q){var Q=null;switch(q){case"$select":{var s="";var E=this._oEntitySet.getEntityType();var K=E.getKeyProperties();var a=[];if(this._bUseMasterData){for(var i=-1,b;(b=K[++i])!==undefined;){s+=(s==""?"":",")+b;var f=E.getTextPropertyOfProperty(b);if(f){if(this._oValueSetResult.text==true){s+=","+f.name;}a.push(f.name);}}}else{s+=(s==""?"":",")+this._oDimension.getKeyProperty().name;if(this._oValueSetResult.text==true&&this._oDimension.getTextProperty()){s+=(s==""?"":",")+this._oDimension.getTextProperty().name;}}if(this._oValueSetResult.attributes){if(this._bUseMasterData){var g=E.getProperties();for(var p in g){var I=false;for(var j=-1,h;(h=K[++j])!==undefined;){if(p==h){I=true;break;}}if(I){continue;}for(var k=-1,m;(m=a[++k])!==undefined;){if(p==m){I=true;break;}}if(!I){s+=","+p;}}}else{var n=this._oDimension.getAllAttributeNames();for(var l=-1,r;(r=n[++l])!==undefined;){s+=(s==""?"":",")+this._oDimension.findAttributeByName(r).getName();}}}Q=(s?s:null);break;}case"$filter":{var t=null;if(this._oFilterExpression){t=this._oFilterExpression.getURIFilterOptionValue();}Q=(t?t:null);break;}case"$orderby":{var u=null;if(this._oSortExpression){u=this._oSortExpression.getURIOrderByOptionValue();}Q=(u?u:null);break;}case"$top":{if(this._iTopRequestOption!==null){Q=this._iTopRequestOption;}break;}case"$skip":{Q=this._iSkipRequestOption;break;}case"$inlinecount":{Q=(this._bIncludeCount==true?"allpages":null);break;}default:break;}return Q;},getURIToDimensionMemberEntitySet:function(s){var r=null;if(!this._bUseMasterData&&this._oParameterizationRequest){r=this._oParameterizationRequest.getURIToParameterizationEntry(s)+"/"+this._oDimension.getContainingQueryResult().getParameterization().getNavigationPropertyToQueryResult();}else{r=(s?s:"")+"/"+this._oEntitySet.getQName();}return r;},getURIToDimensionMemberEntries:function(s){var r=this.getURIToDimensionMemberEntitySet(s);this.getFilterExpression().checkValidity();var a=this.getURIQueryOptionValue("$select");var f=this.getURIQueryOptionValue("$filter");var b=this.getURIQueryOptionValue("$orderby");var t=this.getURIQueryOptionValue("$top");var g=this.getURIQueryOptionValue("$skip");var i=this.getURIQueryOptionValue("$inlinecount");var u=r;var q=false;if(a){u+="?$select="+a;q=true;}if(this._oFilterExpression&&f){if(!q){u+="?";q=true;}else{u+="&";}u+="$filter="+f;}if(this._oSortExpression&&b){if(!q){u+="?";q=true;}else{u+="&";}u+="$orderby="+b;}if(this._iTopRequestOption&&t){if(!q){u+="?";q=true;}else{u+="&";}u+="$top="+t;}if(this._iSkipRequestOption&&g){if(!q){u+="?";q=true;}else{u+="&";}u+="$skip="+g;}if(this._bIncludeCount&&i){if(!q){u+="?";q=true;}else{u+="&";}u+="$inlinecount="+i;}return u;},_oDimension:null,_oParameterizationRequest:null,_oEntitySet:null,_bUseMasterData:false,_oFilterExpression:null,_oSortExpression:null,_oValueSetResult:null,_bIncludeCount:null,_iSkipRequestOption:0,_iTopRequestOption:null};return o;},true);
sap.ui.predefine('sap/ui/model/json/JSONListBinding',['sap/ui/model/ChangeReason','sap/ui/model/ClientListBinding',"sap/base/util/deepEqual","sap/base/Log","sap/ui/thirdparty/jquery"],function(C,a,d,L,q){"use strict";
var J=a.extend("sap.ui.model.json.JSONListBinding");
J.prototype.getContexts=function(s,l){this.iLastStartIndex=s;this.iLastLength=l;if(!s){s=0;}if(!l){l=Math.min(this.iLength,this.oModel.iSizeLimit);}var c=this._getContexts(s,l),b=[];if(this.bUseExtendedChangeDetection){try{for(var i=0;i<c.length;i++){b.push(this.getContextData(c[i]));}if(this.aLastContextData&&s<this.iLastEndIndex){c.diff=this.diffData(this.aLastContextData,b);}this.iLastEndIndex=s+l;this.aLastContexts=c.slice(0);this.aLastContextData=b.slice(0);}catch(e){this.bUseExtendedChangeDetection=false;L.warning("JSONListBinding: Extended change detection has been disabled as JSON data could not be serialized.");}}return c;};
J.prototype.getCurrentContexts=function(){if(this.bUseExtendedChangeDetection){return this.aLastContexts||[];}else{return this.getContexts(this.iLastStartIndex,this.iLastLength);}};
J.prototype.updateIndices=function(){var i;this.aIndices=[];if(Array.isArray(this.oList)){for(i=0;i<this.oList.length;i++){this.aIndices.push(i);}}else{for(i in this.oList){this.aIndices.push(i);}}};
J.prototype.update=function(){var l=this.oModel._getObject(this.sPath,this.oContext);if(l){if(Array.isArray(l)){if(this.bUseExtendedChangeDetection){this.oList=q.extend(true,[],l);}else{this.oList=l.slice(0);}}else{this.oList=q.extend(this.bUseExtendedChangeDetection,{},l);}this.updateIndices();this.applyFilter();this.applySort();this.iLength=this._getLength();}else{this.oList=[];this.aIndices=[];this.iLength=0;}};
J.prototype.checkUpdate=function(f){if(this.bSuspended&&!this.bIgnoreSuspend&&!f){return;}if(!this.bUseExtendedChangeDetection){var l=this.oModel._getObject(this.sPath,this.oContext)||[];if(!d(this.oList,l)||f){this.update();this._fireChange({reason:C.Change});}}else{var c=false;var t=this;var l=this.oModel._getObject(this.sPath,this.oContext)||[];if(this.oList.length!=l.length){c=true;}if(!d(this.oList,l)){this.update();}var b=this._getContexts(this.iLastStartIndex,this.iLastLength);if(this.aLastContexts){if(this.aLastContexts.length!=b.length){c=true;}else{q.each(this.aLastContextData,function(i,o){var e=t.getContextData(b[i]);if(e!==o){c=true;return false;}});}}else{c=true;}if(c||f){this._fireChange({reason:C.Change});}}};
return J;});
sap.ui.predefine('sap/ui/model/json/JSONModel',['sap/ui/model/ClientModel','sap/ui/model/Context','./JSONListBinding','./JSONPropertyBinding','./JSONTreeBinding',"sap/base/Log","sap/ui/thirdparty/jquery","sap/base/util/isPlainObject"],function(C,a,J,b,c,L,q,d){"use strict";
var f=C.extend("sap.ui.model.json.JSONModel",{
constructor:function(D,o){this.pSequentialImportCompleted=Promise.resolve();C.apply(this,arguments);this.bObserve=o;if(D&&typeof D=="object"){this.setData(D);}},
metadata:{publicMethods:["setJSON","getJSON"]}
});
f.prototype.setData=function(D,m){if(m){this.oData=q.extend(true,Array.isArray(this.oData)?[]:{},this.oData,D);}else{this.oData=D;}if(this.bObserve){this.observeData();}this.checkUpdate();};
f.prototype.observeData=function(){var t=this;function e(v){return function(){return v;};}function g(O,n){return function(v){o(v,O,n);t.checkUpdate();};}function h(O,n,v){if(typeof v=="function"){O[n]=v;}else{Object.defineProperty(O,n,{get:e(v),set:g(O,n)});}}function o(O,p,n){if(Array.isArray(O)){for(var i=0;i<O.length;i++){o(O[i],O,i);}}else if(d(O)){for(var i in O){o(O[i],O,i);}}if(p){h(p,n,O);}}o(this.oData);};
f.prototype.setJSON=function(j,m){var o;try{o=JSON.parse(j+"");this.setData(o,m);}catch(e){L.fatal("The following problem occurred: JSON parse Error: "+e);this.fireParseError({url:"",errorCode:-1,reason:"",srcText:e,line:-1,linepos:-1,filepos:-1});}};
f.prototype.getJSON=function(){return JSON.stringify(this.oData);};
f.prototype.loadData=function(u,p,A,t,m,e,h){var g;A=(A!==false);t=t||"GET";e=e===undefined?this.bCache:e;this.fireRequestSent({url:u,type:t,async:A,headers:h,info:"cache="+e+";bMerge="+m,infoObject:{cache:e,merge:m}});var s=function(D){if(!D){L.fatal("The following problem occurred: No data was retrieved by service: "+u);}this.setData(D,m);this.fireRequestCompleted({url:u,type:t,async:A,headers:h,info:"cache="+e+";bMerge="+m,infoObject:{cache:e,merge:m},success:true});}.bind(this);var E=function(P,T){var M=T||P.textStatus;var P=A?P.request:P;var S=P.status;var j=P.statusText;var r=P.responseText;var o={message:M,statusCode:S,statusText:j,responseText:r};L.fatal("The following problem occurred: "+M,r+","+S+","+j);this.fireRequestCompleted({url:u,type:t,async:A,headers:h,info:"cache="+e+";bMerge="+m,infoObject:{cache:e,merge:m},success:false,errorobject:o});this.fireRequestFailed(o);if(A){return Promise.reject(o);}}.bind(this);var _=function(s,E){this._ajax({url:u,async:A,dataType:'json',cache:e,data:p,headers:h,type:t,success:s,error:E});}.bind(this);if(A){g=new Promise(function(r,j){var R=function(x,T,o){j({request:x,textStatus:T,error:o});};_(r,R);});var i=this.pSequentialImportCompleted.then(function(){return g.then(s,E);});this.pSequentialImportCompleted=i.catch(function(o){L.error("Loading of data failed: "+o.stack);});return i;}else{_(s,E);}};
f.prototype.dataLoaded=function(){return this.pSequentialImportCompleted;};
f.prototype.bindProperty=function(p,o,P){var B=new b(this,p,o,P);return B;};
f.prototype.bindList=function(p,o,s,F,P){var B=new J(this,p,o,s,F,P);return B;};
f.prototype.bindTree=function(p,o,F,P,s){var B=new c(this,p,o,F,P,s);return B;};
f.prototype.setProperty=function(p,v,o,A){var r=this.resolve(p,o),l,O,P;if(!r){return false;}if(r=="/"){this.setData(v);return true;}l=r.lastIndexOf("/");O=r.substring(0,l||1);P=r.substr(l+1);var e=this._getObject(O);if(e){e[P]=v;this.checkUpdate(false,A);return true;}return false;};
f.prototype.getProperty=function(p,o){return this._getObject(p,o);};
f.prototype._getObject=function(p,o){var n=this.isLegacySyntax()?this.oData:null;if(o instanceof a){n=this._getObject(o.getPath());}else if(o!=null){n=o;}if(!p){return n;}var P=p.split("/"),i=0;if(!P[0]){n=this.oData;i++;}while(n&&P[i]){n=n[P[i]];i++;}return n;};
f.prototype.isList=function(p,o){var A=this.resolve(p,o);return Array.isArray(this._getObject(A));};
f.prototype._setMetaModel=function(m){this._oMetaModel=m;};
f.prototype.getMetaModel=function(){return this._oMetaModel;};
return f;});
sap.ui.predefine('sap/ui/model/json/JSONPropertyBinding',['sap/ui/model/ChangeReason','sap/ui/model/ClientPropertyBinding',"sap/base/util/deepEqual"],function(C,a,d){"use strict";
var J=a.extend("sap.ui.model.json.JSONPropertyBinding");
J.prototype.setValue=function(v){if(this.bSuspended){return;}if(!d(this.oValue,v)){if(this.oModel.setProperty(this.sPath,v,this.oContext,true)){this.oValue=v;this.getDataState().setValue(this.oValue);this.oModel.firePropertyChange({reason:C.Binding,path:this.sPath,context:this.oContext,value:v});}}};
J.prototype.checkUpdate=function(f){if(this.bSuspended&&!f){return;}var v=this._getValue();if(!d(v,this.oValue)||f){this.oValue=v;this.getDataState().setValue(this.oValue);this.checkDataState();this._fireChange({reason:C.Change});}};
return J;});
sap.ui.predefine('sap/ui/model/json/JSONTreeBinding',['sap/ui/model/ClientTreeBinding'],function(C){"use strict";
var J=C.extend("sap.ui.model.json.JSONTreeBinding");
J.prototype._saveSubContext=function(n,c,s,N){if(n&&typeof n=="object"){var o=this.oModel.getContext(s+N);if(this.oCombinedFilter&&!this.bIsFiltering){if(this.filterInfo.aFilteredContexts&&this.filterInfo.aFilteredContexts.indexOf(o)!=-1){c.push(o);}}else{c.push(o);}}};
return J;});
sap.ui.predefine('sap/ui/model/odata/AnnotationHelper',["./_AnnotationHelperBasics","./_AnnotationHelperExpression","sap/base/Log","sap/ui/base/BindingParser"],function(B,E,L,a){'use strict';
function c(f,b){if(!b){return f;}function d(){return f.call(this,b.apply(this,arguments));}return d;}
var A={createPropertySetting:function(p,r){var m=false,P;p=p.slice();p.forEach(function(v,i){switch(typeof v){case"boolean":case"number":case"undefined":m=true;break;case"string":P=a.complexParser(v,null,true,true);if(P!==undefined){if(P.functionsNotFound){throw new Error("Function name(s) "+P.functionsNotFound.join(", ")+" not found");}p[i]=v=P;}case"object":if(!v||typeof v!=="object"||!("path"in v)){m=true;}break;default:throw new Error("Unsupported part: "+v);}});P={formatter:r,parts:p};if(m){a.mergeParts(P);}if(P.parts.length===0){P=P.formatter&&P.formatter();if(typeof P==="string"){P=a.complexParser.escape(P);}}else if(P.parts.length===1){r=P.formatter;P=P.parts[0];if(r){P.formatter=c(r,P.formatter);}}return P;},format:function(i,r){if(arguments.length===1){r=i.getObject("");}return E.getExpression(i,r,true);},getNavigationPath:function(i,r){if(arguments.length===1){r=i.getObject("");}var R=B.followPath(i,r);return R?"{"+R.navigationProperties.join("/")+"}":"";},gotoEntitySet:function(C){var e,s,r=C.getObject(),R;if(typeof r==="string"){e=r;}else{R=B.followPath(C,r);e=R&&R.associationSetEnd&&R.associationSetEnd.entitySet;}if(e){s=C.getModel().getODataEntitySet(e,true);}if(!s){L.warning(C.getPath()+": found '"+e+"' which is not a name of an entity set",undefined,"sap.ui.model.odata.AnnotationHelper");}return s;},gotoEntityType:function(C){var e=C.getProperty(""),r=C.getModel().getODataEntityType(e,true);if(!r){L.warning(C.getPath()+": found '"+e+"' which is not a name of an entity type",undefined,"sap.ui.model.odata.AnnotationHelper");}return r;},gotoFunctionImport:function(C){var f=C.getProperty("String"),r=C.getModel().getODataFunctionImport(f,true);if(!r){L.warning(C.getPath()+": found '"+f+"' which is not a name of a function import",undefined,"sap.ui.model.odata.AnnotationHelper");}return r;},isMultiple:function(i,r){if(arguments.length===1){r=i.getObject("");}var R=B.followPath(i,r);if(R){if(R.navigationAfterMultiple){throw new Error('Association end with multiplicity "*" is not the last one: '+r.AnnotationPath);}return String(R.isMultiple);}return"";},resolvePath:function(C){var r=B.followPath(C,C.getObject());if(!r){L.warning(C.getPath()+": Path could not be resolved ",undefined,"sap.ui.model.odata.AnnotationHelper");}return r?r.resolvedPath:undefined;},simplePath:function(i,r){if(arguments.length===1){r=i.getObject("");}return E.getExpression(i,r,false);}};A.format.requiresIContext=true;A.getNavigationPath.requiresIContext=true;A.isMultiple.requiresIContext=true;A.simplePath.requiresIContext=true;return A;},true);
sap.ui.predefine('sap/ui/model/odata/AnnotationParser',["sap/base/assert","sap/base/Log","sap/base/util/isEmptyObject","sap/ui/Device","sap/ui/thirdparty/jquery"],function(a,L,b,D,q){"use strict";var A={EnumMember:true,Path:true,PropertyPath:true,NavigationPropertyPath:true,AnnotationPath:true};var t={Binary:true,Bool:true,Date:true,DateTimeOffset:true,Decimal:true,Duration:true,Float:true,Guid:true,Int:true,String:true,TimeOfDay:true,LabelElementReference:true,EnumMember:true,Path:true,PropertyPath:true,NavigationPropertyPath:true,AnnotationPath:true};var M={And:true,Or:true,Eq:true,Ne:true,Gt:true,Ge:true,Lt:true,Le:true,If:true,Collection:true};
function g(o){return o.getAttribute("Qualifier")||o.parentNode.nodeName==="Annotations"&&o.parentNode.getAttribute("Qualifier");}
var c={merge:function(T,s){var d,e;var S=["annotationsAtArrays","propertyAnnotations","EntityContainer","annotationReferences"];for(d in s){if(S.indexOf(d)!==-1){continue;}c._mergeAnnotation(d,s,T);}for(var i=1;i<S.length;++i){var f=S[i];T[f]=T[f]||{};for(d in s[f]){for(e in s[f][d]){T[f][d]=T[f][d]||{};c._mergeAnnotation(e,s[f][d],T[f][d]);}}}if(s.annotationsAtArrays){T.annotationsAtArrays=(T.annotationsAtArrays||[]).concat(s.annotationsAtArrays);}},_mergeAnnotation:function(n,m,T){if(Array.isArray(m[n])){T[n]=m[n].slice(0);}else{T[n]=T[n]||{};for(var k in m[n]){T[n][k]=m[n][k];}}},parse:function(m,x,s){try{c._parserData={};c._oXPath=c.getXPath();return c._parse(m,x,s);}finally{delete c._parserData;delete c._oXPath;}},_parse:function(m,x,s){var d={},e,f,h,T,l,n,p,r,u,v,w,y,z,B,C,E,F,G,H,I,J,i,K,N=[];c._parserData.metadataInstance=m;c._parserData.serviceMetadata=m.getServiceMetadata();c._parserData.xmlDocument=c._oXPath.setNameSpace(x);c._parserData.schema={};c._parserData.aliases={};c._parserData.url=s?s:"metadata document";c._parserData.annotationsAtArrays=N;e=c._oXPath.selectNodes("//d:Schema",c._parserData.xmlDocument);for(i=0;i<e.length;i+=1){f=c._oXPath.nextNode(e,i);c._parserData.schema.Alias=f.getAttribute("Alias");c._parserData.schema.Namespace=f.getAttribute("Namespace");}var O={};var P=c._parseReferences(O);if(P){d.annotationReferences=O;d.aliasDefinitions=c._parserData.aliases;}h=c._oXPath.selectNodes("//d:Term",c._parserData.xmlDocument);if(h.length>0){T={};for(K=0;K<h.length;K+=1){l=c._oXPath.nextNode(h,K);n=c.replaceWithAlias(l.getAttribute("Type"));T["@"+c._parserData.schema.Alias+"."+l.getAttribute("Name")]=n;}d.termDefinitions=T;}c._parserData.metadataProperties=c.getAllPropertiesMetadata(c._parserData.serviceMetadata);if(c._parserData.metadataProperties.extensions){d.propertyExtensions=c._parserData.metadataProperties.extensions;}p=c._oXPath.selectNodes("//d:Annotations ",c._parserData.xmlDocument);for(K=0;K<p.length;K+=1){r=c._oXPath.nextNode(p,K);if(r.hasChildNodes()===false){continue;}u=r.getAttribute("Target");v=u.split(".")[0];if(v&&c._parserData.aliases[v]){u=u.replace(new RegExp(v,""),c._parserData.aliases[v]);}w=u;y=null;var Q=null;if(u.indexOf("/")>0){w=u.split("/")[0];var S=c._parserData.serviceMetadata.dataServices&&c._parserData.serviceMetadata.dataServices.schema&&c._parserData.serviceMetadata.dataServices.schema.length;if(S){for(var j=c._parserData.serviceMetadata.dataServices.schema.length-1;j>=0;j--){var R=c._parserData.serviceMetadata.dataServices.schema[j];if(R.entityContainer){var U=w.split('.');for(var k=R.entityContainer.length-1;k>=0;k--){if(R.entityContainer[k].name===U[U.length-1]){Q=u.replace(w+"/","");break;}}}}}if(!Q){y=u.replace(w+"/","");}}if(y){if(!d.propertyAnnotations){d.propertyAnnotations={};}if(!d.propertyAnnotations[w]){d.propertyAnnotations[w]={};}if(!d.propertyAnnotations[w][y]){d.propertyAnnotations[w][y]={};}z=c._oXPath.selectNodes("./d:Annotation",r);for(var V=0;V<z.length;V+=1){B=c._oXPath.nextNode(z,V);C=c.replaceWithAlias(B.getAttribute("Term"));var W=g(B);if(W){C+="#"+W;}if(B.hasChildNodes()===false){var o={};c.enrichFromPropertyValueAttributes(o,B);if(b(o)){o.Bool="true";}d.propertyAnnotations[w][y][C]=o;}else{d.propertyAnnotations[w][y][C]=c.getPropertyValue(B);}}}else{var X;if(Q){if(!d["EntityContainer"]){d["EntityContainer"]={};}if(!d["EntityContainer"][w]){d["EntityContainer"][w]={};}X=d["EntityContainer"][w];}else{if(!d[w]){d[w]={};}X=d[w];}E=w.replace(c._parserData.aliases[v],v);z=c._oXPath.selectNodes("./d:Annotation",r);for(var Y=0;Y<z.length;Y+=1){B=c._oXPath.nextNode(z,Y);var Z=X;if(Q){if(!X[Q]){X[Q]={};}Z=X[Q];}c._parseAnnotation(w,B,Z);}F=c._oXPath.selectNodes("//d:Annotations[contains(@Target, '"+E+"')]//d:PropertyValue[contains(@Path, '/')]//@Path",c._parserData.xmlDocument);for(i=0;i<F.length;i+=1){G=c._oXPath.nextNode(F,i);H=G.value;if(d.propertyAnnotations){if(d.propertyAnnotations[w]){if(d.propertyAnnotations[w][H]){continue;}}}I=H.split('/');if(c.findNavProperty(w,I[0])){if(!d.expand){d.expand={};}if(!d.expand[w]){d.expand[w]={};}d.expand[w][I[0]]=I[0];}}J=c._oXPath.selectNodes("//d:Annotations[contains(@Target, '"+E+"')]//d:Path[contains(., '/')]",c._parserData.xmlDocument);for(i=0;i<J.length;i+=1){G=c._oXPath.nextNode(J,i);H=c._oXPath.getNodeText(G);if(d.propertyAnnotations&&d.propertyAnnotations[w]&&d.propertyAnnotations[w][H]){continue;}if(!d.expand){d.expand={};}if(!d.expand[w]){d.expand[w]={};}I=H.split('/');if(c.findNavProperty(w,I[0])){if(!d.expand){d.expand={};}if(!d.expand[w]){d.expand[w]={};}d.expand[w][I[0]]=I[0];}}}}if(N.length){d.annotationsAtArrays=N.map(function($){return c.backupAnnotationAtArray($,d);});}return d;},backupAnnotationAtArray:function(e,m){var Q,s=[];function i(){return Array.prototype.filter.call(e.parentNode.childNodes,function(n){return n.nodeType===1;}).indexOf(e);}while(e.nodeName!=="Annotations"){switch(e.nodeName){case"Annotation":Q=g(e);s.unshift(e.getAttribute("Term")+(Q?"#"+Q:""));break;case"Collection":break;case"PropertyValue":s.unshift(e.getAttribute("Property"));break;case"Record":if(e.parentNode.nodeName==="Collection"){s.unshift(i());}break;default:if(e.parentNode.nodeName==="Apply"){s.unshift("Value");s.unshift(i());s.unshift("Parameters");}else{s.unshift(e.nodeName);}break;}e=e.parentNode;}s.unshift(e.getAttribute("Target"));s=s.map(function(S){return typeof S==="string"?c.replaceWithAlias(S):S;});c.syncAnnotationsAtArrays(m,s,true);return s;},restoreAnnotationsAtArrays:function(m){if(m.annotationsAtArrays){m.annotationsAtArrays.forEach(function(s){c.syncAnnotationsAtArrays(m,s);});}},syncAnnotationsAtArrays:function(m,s,w){var i,n=s.length-2,d=s[n+1],p=m,P=s[n],S=P+"@"+d;for(i=0;i<n;i+=1){p=p&&p[s[i]];}if(p&&Array.isArray(p[P])){if(!(S in p)){p[S]=p[P][d];}if(!(d in p[P])){p[P][d]=p[S];}}else if(w){L.warning("Wrong path to annotation at array",s,"sap.ui.model.odata.AnnotationParser");}},_parseAnnotation:function(s,o,d){var Q=g(o);var T=c.replaceWithAlias(o.getAttribute("Term"));if(Q){T+="#"+Q;}var v=c.getPropertyValue(o,s);v=c.setEdmTypes(v,c._parserData.metadataProperties.types,s,c._parserData.schema);d[T]=v;if(Array.isArray(d)){c._parserData.annotationsAtArrays.push(o);}},_parseReferences:function(m){var f=false;var n,i;var x=c._oXPath;var s="//edmx:Reference/edmx:Include[@Namespace and @Alias]";var o=x.selectNodes(s,c._parserData.xmlDocument);for(i=0;i<o.length;++i){f=true;n=x.nextNode(o,i);c._parserData.aliases[n.getAttribute("Alias")]=n.getAttribute("Namespace");}var r="//edmx:Reference[@Uri]/edmx:IncludeAnnotations[@TermNamespace]";var R=x.selectNodes(r,c._parserData.xmlDocument);for(i=0;i<R.length;++i){f=true;n=x.nextNode(R,i);var T=n.getAttribute("TermNamespace");var d=n.getAttribute("TargetNamespace");var e=n.parentNode.getAttribute("Uri");if(d){if(!m[d]){m[d]={};}m[d][T]=e;}else{m[T]=e;}}return f;},getAllPropertiesMetadata:function(o){var d={},P={},e={},f=false,n,E,C,h={},r={},s={},u=false,v,w,x,T,y,R={types:P};if(!o.dataServices.schema){return R;}for(var i=o.dataServices.schema.length-1;i>=0;i-=1){d=o.dataServices.schema[i];if(d.entityType){n=d.namespace;E=d.entityType;C=d.complexType;for(var j=0;j<E.length;j+=1){h=E[j];s={};r={};if(h.property){for(var k=0;k<h.property.length;k+=1){v=h.property[k];if(v.type.substring(0,n.length)===n){if(C){for(var l=0;l<C.length;l+=1){if(C[l].name===v.type.substring(n.length+1)){if(C[l].property){for(var m=0;m<C[l].property.length;m+=1){w=C[l].property[m];r[C[l].name+"/"+w.name]=w.type;}}}}}}else{x=v.name;T=v.type;if(v.extensions){for(var p=0;p<v.extensions.length;p+=1){y=v.extensions[p];if((y.name==="display-format")&&(y.value==="Date")){T="Edm.Date";}else{u=true;if(!s[x]){s[x]={};}if(y.namespace&&!s[x][y.namespace]){s[x][y.namespace]={};}s[x][y.namespace][y.name]=y.value;}}}r[x]=T;}}}if(!P[n+"."+h.name]){P[n+"."+h.name]={};}P[n+"."+h.name]=r;if(u){if(!e[n+"."+h.name]){f=true;}e[n+"."+h.name]={};e[n+"."+h.name]=s;}}}}if(f){R={types:P,extensions:e};}return R;},setEdmTypes:function(p,P,T,s){function d(e){var o,E='';if(p[e]){o=p[e];if(o.Value&&o.Value.Path){E=c.getEdmType(o.Value.Path,P,T,s);if(E){p[e].EdmType=E;}}else if(o.Path){E=c.getEdmType(o.Path,P,T,s);if(E){p[e].EdmType=E;}}else if(o.Facets){p[e].Facets=c.setEdmTypes(o.Facets,P,T,s);}else if(o.Data){p[e].Data=c.setEdmTypes(o.Data,P,T,s);}else if(e==="Data"){p.Data=c.setEdmTypes(o,P,T,s);}else if(o.Value&&o.Value.Apply){p[e].Value.Apply.Parameters=c.setEdmTypes(o.Value.Apply.Parameters,P,T,s);}else if(o.Value&&o.Type&&(o.Type==="Path")){E=c.getEdmType(o.Value,P,T,s);if(E){p[e].EdmType=E;}}}}if(Array.isArray(p)){for(var v=0;v<p.length;v+=1){d(v);}}else{for(var V in p){d(V);}}return p;},getEdmType:function(p,P,T,s){var i=p.indexOf("/");if(i>-1){var d=p.substr(0,i);var n=c.findNavProperty(T,d);if(n){var m=c._parserData.metadataInstance._getEntityTypeByNavPropertyObject(n);if(m){T=m.entityType;p=p.substr(i+1);}}}if((p.charAt(0)==="@")&&(p.indexOf(s.Alias)===1)){p=p.slice(s.Alias.length+2);}if(p.indexOf("/")>=0){if(P[p.slice(0,p.indexOf("/"))]){T=p.slice(0,p.indexOf("/"));p=p.slice(p.indexOf("/")+1);}}return P[T]&&P[T][p];},enrichFromPropertyValueAttributes:function(m,n){var I={"Property":true,"Qualifier":true,"Term":true,"xmlns":true};for(var i=0;i<n.attributes.length;i+=1){var N=n.attributes[i].name;if(!I[N]&&(N.indexOf("xmlns:")!==0)){var v=n.attributes[i].value;if(N==="EnumMember"&&v.indexOf(" ")>-1){var V=v.split(" ");m[N]=V.map(c.replaceWithAlias).join(" ");}else{m[N]=c.replaceWithAlias(v);}}}return m;},_getRecordValues:function(n){var N=[];var x=c._oXPath;for(var i=0;i<n.length;++i){var o=x.nextNode(n,i);var v=c.getPropertyValues(o);var T=o.getAttribute("Type");if(T){v["RecordType"]=c.replaceWithAlias(T);}N.push(v);}return N;},_getTextValues:function(n){var N=[];var x=c._oXPath;for(var i=0;i<n.length;i+=1){var o=x.nextNode(n,i);var v={};var T=x.getNodeText(o);v[o.nodeName]=c._parserData.aliases?c.replaceWithAlias(T):T;N.push(v);}return N;},_getTextValue:function(n){var x=c._oXPath;var v="";if(n.nodeName in A){v=c.replaceWithAlias(x.getNodeText(n));}else{v=x.getNodeText(n);}if(n.nodeName!=="String"){v=v.trim();}return v;},getPropertyValue:function(d,s){var i;var x=c._oXPath;var p=d.nodeName==="Collection"?[]:{};if(d.hasChildNodes()){var r=x.selectNodes("./d:Record",d);var R=c._getRecordValues(r);var C=x.selectNodes("./d:Collection/d:Record | ./d:Collection/d:If/d:Record",d);var e=c._getRecordValues(C);var P=R.concat(e);if(P.length>0){if(C.length===0&&r.length>0){p=P[0];}else{p=P;}}else{var o=x.selectNodes("./d:Collection/d:AnnotationPath | ./d:Collection/d:NavigationPropertyPath | ./d:Collection/d:PropertyPath",d);if(o.length>0){p=c._getTextValues(o);}else{var f=x.selectNodes("./d:*[not(local-name() = \"Annotation\")]",d);if(f.length>0){for(i=0;i<f.length;i++){var h=x.nextNode(f,i);var v;var n=h.nodeName;var j=h.parentNode.nodeName;if(n==="Apply"){v=c.getApplyFunctions(h);}else{v=c.getPropertyValue(h);}if(M[j]){if(!Array.isArray(p)){p=[];}var V={};V[n]=v;p.push(V);}else if(n==="Collection"){p=v;}else{if(p[n]){L.warning("Annotation contained multiple "+n+" values. Only the last "+"one will be stored: "+x.getPath(h));}p[n]=v;}}c.enrichFromPropertyValueAttributes(p,d);}else if(d.nodeName in t){p=c._getTextValue(d);}else{c.enrichFromPropertyValueAttributes(p,d);}}}var N=x.selectNodes("./d:Annotation",d);if(N.length>0){for(i=0;i<N.length;i++){var k=x.nextNode(N,i);c._parseAnnotation(s,k,p);}}}else if(d.nodeName in t){p=c._getTextValue(d);}else if(d.nodeName.toLowerCase()==="null"){p=null;}else{c.enrichFromPropertyValueAttributes(p,d);}return p;},getPropertyValues:function(p){var P={},i;var x=c._oXPath;var o=x.selectNodes("./d:Annotation",p);var d=x.selectNodes("./d:PropertyValue",p);function e(p,w,N){var l,m=p;while(m.nodeName!=="Annotation"){m=m.parentNode;}l=m.parentNode;return(w+" '"+N+"' is defined twice; "+"Source = "+c._parserData.url+", Annotation Target = "+l.getAttribute("Target")+", Term = "+m.getAttribute("Term"));}if(o.length===0&&d.length===0){P=c.getPropertyValue(p);}else{for(i=0;i<o.length;i++){var f=x.nextNode(o,i);var T=c.replaceWithAlias(f.getAttribute("Term"));a(!P[T],function(){return e(p,"Annotation",T);});P[T]=c.getPropertyValue(f);}for(i=0;i<d.length;i++){var h=x.nextNode(d,i);var s=h.getAttribute("Property");a(!P[s],function(){return e(p,"Property",s);});P[s]=c.getPropertyValue(h);var j=x.selectNodes("./d:Apply",h);for(var n=0;n<j.length;n+=1){var k=x.nextNode(j,n);P[s]={};P[s]['Apply']=c.getApplyFunctions(k);}}}return P;},getApplyFunctions:function(d){var x=c._oXPath;var m={Name:d.getAttribute('Function'),Parameters:[]};var p=x.selectNodes("./d:*",d);for(var i=0;i<p.length;i+=1){var P=x.nextNode(p,i);var e={Type:P.nodeName};if(P.nodeName==="Apply"){e.Value=c.getApplyFunctions(P);}else if(P.nodeName==="LabeledElement"){e.Value=c.getPropertyValue(P);e.Name=e.Value.Name;delete e.Value.Name;}else if(M[P.nodeName]){e.Value=c.getPropertyValue(P);}else{e.Value=x.getNodeText(P);}m.Parameters.push(e);}return m;},findNavProperty:function(e,p){var m=c._parserData.serviceMetadata;for(var i=m.dataServices.schema.length-1;i>=0;i-=1){var o=m.dataServices.schema[i];if(o.entityType){var n=o.namespace+".";var E=o.entityType;for(var k=E.length-1;k>=0;k-=1){if(n+E[k].name===e&&E[k].navigationProperty){for(var j=0;j<E[k].navigationProperty.length;j+=1){if(E[k].navigationProperty[j].name===p){return E[k].navigationProperty[j];}}}}}}return null;},replaceWithAlias:function(v,r){if(r===undefined){r=1;}for(var s in c._parserData.aliases){if(v.indexOf(s+".")>=0&&v.indexOf("."+s+".")<0){v=v.replace(s+".",c._parserData.aliases[s]+".");r--;if(r===0){return v;}}}return v;},getXPath:function(){var x={};var p=c._parserData;if(D.browser.msie){x={setNameSpace:function(o){o.setProperty("SelectionNamespaces",'xmlns:edmx="http://docs.oasis-open.org/odata/ns/edmx" xmlns:d="http://docs.oasis-open.org/odata/ns/edm"');o.setProperty("SelectionLanguage","XPath");return o;},selectNodes:function(x,i){return i.selectNodes(x);},nextNode:function(n){return n.nextNode();},getNodeText:function(n){return n.text;}};}else{x={setNameSpace:function(o){return o;},nsResolver:function(d){var n={"edmx":"http://docs.oasis-open.org/odata/ns/edmx","d":"http://docs.oasis-open.org/odata/ns/edm"};return n[d]||null;},selectNodes:function(P,i){var d=p.xmlDocument.evaluate(P,i,this.nsResolver,7,null);d.length=d.snapshotLength;return d;},nextNode:function(n,i){return n.snapshotItem(i);},getNodeText:function(n){return n.textContent;}};}x.getPath=function(n){var P="";var I="getAttribute"in n?n.getAttribute("id"):"";var T=n.tagName?n.tagName:"";if(I){P='id("'+I+'")';}else if(n instanceof Document){P="/";}else if(T.toLowerCase()==="body"){P=T;}else if(n.parentNode){var d=1;for(var i=0;i<n.parentNode.childNodes.length;++i){if(n.parentNode.childNodes[i]===n){P=x.getPath(n.parentNode)+"/"+T+"["+d+"]";break;}else if(n.parentNode.childNodes[i].nodeType===1&&n.parentNode.childNodes[i].tagName===T){++d;}}}else{L.error("Wrong Input node - cannot find XPath to it: "+T);}return P;};return x;}};return c;});
sap.ui.predefine('sap/ui/model/odata/CountMode',function(){"use strict";var C={Request:"Request",Inline:"Inline",InlineRepeat:"InlineRepeat",Both:"Both",None:"None"};return C;},true);
sap.ui.predefine('sap/ui/model/odata/Filter',['sap/ui/base/Object','sap/ui/model/Filter','sap/ui/model/FilterOperator'],function(B,F,a){"use strict";
var O=B.extend("sap.ui.model.odata.Filter",{
constructor:function(p,v,A){if(typeof p==="object"){var f=p;p=f.path;v=f.values;A=f.and;}this.sPath=p;this.aValues=v;this.bAND=A==undefined?true:A;},
convert:function(){var f=[];for(var i=0,l=this.aValues&&this.aValues.length||0;i<l;i++){f.push(new F({path:this.sPath,operator:this.aValues[i].operator,value1:this.aValues[i].value1,value2:this.aValues[i].value2}));}if(f.length>1){var o=new F({filters:f,and:this.bAND});return o;}else{return f[0];}}
});
return O;});
sap.ui.predefine('sap/ui/model/odata/MessageScope',function(){"use strict";var M={RequestedObjects:"RequestedObjects",BusinessObject:"BusinessObject"};return M;},true);
sap.ui.predefine('sap/ui/model/odata/ODataAnnotations',["./AnnotationParser","sap/base/assert","sap/base/Log","sap/base/util/isEmptyObject","sap/ui/Device","sap/ui/base/EventProvider","sap/ui/thirdparty/jquery"],function(A,a,L,b,D,E,q){"use strict";
var O=E.extend("sap.ui.model.odata.ODataAnnotations",{
constructor:function(o){E.apply(this,arguments);if(arguments.length!==1){if(typeof arguments[2]==="object"){o=arguments[2];}o.urls=arguments[0];o.metadata=arguments[1];}this.oMetadata=o.metadata;this.oAnnotations=o.annotationData?o.annotationData:{};this.bLoaded=false;this.bAsync=o&&o.async;this.xPath=null;this.oError=null;this.bValidXML=true;this.oRequestHandles=[];this.oLoadEvent=null;this.oFailedEvent=null;this.mCustomHeaders=o.headers?q.extend({},o.headers):{};if(o.urls){this.addUrl(o.urls);if(!this.bAsync){a(!b(this.oMetadata),"Metadata must be available for synchronous annotation loading");if(this.oError){L.error("OData annotations could not be loaded: "+this.oError.message);}}}},
metadata:{publicMethods:["parse","getAnnotationsData","attachFailed","detachFailed","attachLoaded","detachLoaded"]}
});
O.prototype.getAnnotationsData=function(){return this.oAnnotations;};
O.prototype.isLoaded=function(){return this.bLoaded;};
O.prototype.isFailed=function(){return this.oError!==null;};
O.prototype.fireLoaded=function(p){this.fireEvent("loaded",p);return this;};
O.prototype.attachLoaded=function(d,f,l){this.attachEvent("loaded",d,f,l);return this;};
O.prototype.detachLoaded=function(f,l){this.detachEvent("loaded",f,l);return this;};
O.prototype.fireFailed=function(p){this.fireEvent("failed",p);return this;};
O.prototype.attachFailed=function(d,f,l){this.attachEvent("failed",d,f,l);return this;};
O.prototype.detachFailed=function(f,l){this.detachEvent("failed",f,l);return this;};
O.prototype.setHeaders=function(h){this.mCustomHeaders=q.extend({},h);};
O.prototype._createXMLDocument=function(x,X){var o=null;if(typeof x==="string"){X=x;x=null;}if(D.browser.msie){o=new ActiveXObject("Microsoft.XMLDOM");o.preserveWhiteSpace=true;if(X.indexOf(" xmlns:xml=")>-1){X=X.replace(' xmlns:xml="http://www.w3.org/XML/1998/namespace"',"").replace(" xmlns:xml='http://www.w3.org/XML/1998/namespace'","");}o.loadXML(X);}else if(x){o=x;}else if(window.DOMParser){o=new DOMParser().parseFromString(X,'application/xml');}else{L.fatal("The browser does not support XML parsing. Annotations are not available.");}return o;};
O.prototype._documentHasErrors=function(x){return(x.getElementsByTagName("parsererror").length>0||(x.parseError&&x.parseError.errorCode!==0));};
O.prototype._mergeAnnotationData=function(m,s){if(!this.oAnnotations){this.oAnnotations={};}A.merge(this.oAnnotations,m);this.bLoaded=true;if(!s){this.fireLoaded({annotations:m});}};
O.prototype.setXML=function(x,X,o){var d={success:function(){},error:function(){},fireEvents:false};o=q.extend({},d,o);var c=this._createXMLDocument(x,X);var p=function(c){var r={xmlDoc:c};var e=A.parse(this.oMetadata,c);if(e){r.annotations=e;o.success(r);this._mergeAnnotationData(e,!o.fireEvents);}else{o.error(r);if(o.fireEvents){this.fireFailed(r);}}}.bind(this,c);if(this._documentHasErrors(c)){o.error({xmlDoc:c});return false;}else{var m=this.oMetadata.getServiceMetadata();if(!m||b(m)){this.oMetadata.attachLoaded(p);}else{p();}return true;}};
O.prototype.addUrl=function(u){var t=this;var U=u;if(Array.isArray(u)&&u.length==0){return Promise.resolve({annotations:this.oAnnotations});}if(!Array.isArray(u)){U=[u];}return new Promise(function(r,R){var l=0;var m={annotations:null,success:[],fail:[]};var f=function(d){l++;if(d.type==="success"){m.success.push(d);}else{m.fail.push(d);}if(l===U.length){m.annotations=t.oAnnotations;if(m.success.length>0){var s={annotations:t.oAnnotations,results:m};t.fireLoaded(s);}if(m.success.length<U.length){var e=new Error("At least one annotation failed to load/parse/merge");e.annotations=m.annotations;e.success=m.success;e.fail=m.fail;R(e);}else{r(m);}}};var i=0;if(t.bAsync){var p=Promise.resolve();for(i=0;i<U.length;++i){var c=t._loadFromUrl.bind(t,U[i]);p=p.then(c,c).then(f,f);}}else{for(i=0;i<U.length;++i){t._loadFromUrl(U[i]).then(f,f);}}});};
O.prototype._loadFromUrl=function(u){var t=this;return new Promise(function(r,R){var m={url:u,async:t.bAsync,headers:q.extend({},t.mCustomHeaders,{"Accept-Language":sap.ui.getCore().getConfiguration().getLanguageTag()})};var o;var f=function(j,S){if(o&&o.bSuppressErrorHandlerCall){return;}t.oError={type:"fail",url:u,message:S,statusCode:j.status,statusText:j.statusText,responseText:j.responseText};if(t.bAsync){t.oFailedEvent=setTimeout(t.fireFailed.bind(t,t.oError),0);}else{t.fireFailed(t.oError);}R(t.oError);};var s=function(d,S,j){t.setXML(j.responseXML,j.responseText,{success:function(c){r({type:"success",url:u,message:S,statusCode:j.status,statusText:j.statusText,responseText:j.responseText});},error:function(c){f(j,"Malformed XML document");},url:u});};q.ajax(m).done(s).fail(f);});};
O.prototype.destroy=function(){for(var i=0;i<this.oRequestHandles.length;++i){if(this.oRequestHandles[i]){this.oRequestHandles[i].bSuppressErrorHandlerCall=true;this.oRequestHandles[i].abort();this.oRequestHandles[i]=null;}}E.prototype.destroy.apply(this,arguments);if(this.oLoadEvent){clearTimeout(this.oLoadEvent);}if(this.oFailedEvent){clearTimeout(this.oFailedEvent);}};
return O;});
sap.ui.predefine('sap/ui/model/odata/ODataContextBinding',['sap/ui/model/ContextBinding','sap/ui/model/ChangeReason'],function(C,a){"use strict";
var O=C.extend("sap.ui.model.odata.ODataContextBinding",{constructor:function(m,p,c,P,e){C.call(this,m,p,c,P,e);}});
O.prototype.initialize=function(){var t=this,r=this.oModel.resolve(this.sPath,this.oContext),d=this.oModel._getObject(this.sPath,this.oContext),R=this.oModel._isReloadNeeded(r,d,this.mParameters);if(this.oModel.oMetadata.isLoaded()){if(r&&R){this.fireDataRequested();}this.oModel.createBindingContext(this.sPath,this.oContext,this.mParameters,function(c){t.oElementContext=c;t._fireChange({reason:a.Context});if(r&&R){t.fireDataReceived();}},R);}};
O.prototype.refresh=function(f,c){var t=this,k,s,b=false,r=this.oModel.resolve(this.sPath,this.oContext);if(c){s=this.oModel._getObject(this.sPath,this.oContext);if(s){k=this.oModel._getKey(s);if(k in c){b=true;}}}else{b=true;}if(f||b){if(r){this.fireDataRequested();}this.oModel.createBindingContext(this.sPath,this.oContext,this.mParameters,function(o){if(t.oElementContext===o){if(f){t._fireChange({reason:a.Context});}}else{t.oElementContext=o;t._fireChange({reason:a.Context});}if(r){t.fireDataReceived();}},true);}};
O.prototype.setContext=function(c){var t=this,r,d,R;if(this.oContext!==c&&this.isRelative()){this.oContext=c;r=this.oModel.resolve(this.sPath,this.oContext);d=this.oModel._getObject(this.sPath,this.oContext);R=this.oModel._isReloadNeeded(r,d,this.mParameters);if(r&&R){this.fireDataRequested();}this.oModel.createBindingContext(this.sPath,this.oContext,this.mParameters,function(c){t.oElementContext=c;t._fireChange({reason:a.Context});if(r&&R){t.fireDataReceived();}},R);}};
return O;});
sap.ui.predefine('sap/ui/model/odata/ODataListBinding',['sap/ui/model/ChangeReason','sap/ui/model/Filter','sap/ui/model/odata/Filter','sap/ui/model/FilterType','sap/ui/model/FilterProcessor','sap/ui/model/ListBinding','sap/ui/model/Sorter','./ODataUtils','./CountMode','sap/base/util/deepEqual','sap/base/util/merge','sap/base/Log','sap/base/assert','sap/ui/thirdparty/jquery'],function(C,F,O,a,b,L,S,c,d,e,m,f,g,q){"use strict";
var h=L.extend("sap.ui.model.odata.ODataListBinding",{constructor:function(M,p,o,s,i,P){L.apply(this,arguments);this.sFilterParams=null;this.sSortParams=null;this.sRangeParams=null;this.sCustomParams=this.oModel.createCustomParams(this.mParameters);this.iStartIndex=0;this.bPendingChange=false;this.aKeys=[];this.bInitial=true;this.sCountMode=(P&&P.countMode)||this.oModel.sDefaultCountMode;this.bRefresh=false;this.bNeedsUpdate=false;this.bDataAvailable=false;this.bIgnoreSuspend=false;this.oCombinedFilter=null;this.oModel.checkFilterOperation(this.aApplicationFilters);if(!this.oModel.getServiceMetadata()){var t=this,j=function(E){t.bInitial=false;t._initSortersFilters();t.oModel.detachMetadataLoaded(j);};this.oModel.attachMetadataLoaded(this,j);}else{this.bInitial=false;this._initSortersFilters();}var r=this.oModel._getObject(this.sPath,this.oContext);this.aExpandRefs=r;if(Array.isArray(r)&&!s&&!i){this.aKeys=r;this.iLength=r.length;this.bLengthFinal=true;this.bDataAvailable=true;}else if(r===null&&this.oModel.resolve(this.sPath,this.oContext)){this.aKeys=[];this.iLength=0;this.bLengthFinal=true;this.bDataAvailable=true;}else{if(this.oModel.getServiceMetadata()){this.resetData();}}}});
h.prototype.getContexts=function(s,l,t){if(this.bInitial){return[];}this.iLastLength=l;this.iLastStartIndex=s;this.iLastThreshold=t;if(!s){s=0;}if(!l){l=this.oModel.iSizeLimit;if(this.bLengthFinal&&this.iLength<l){l=this.iLength;}}if(!t){t=0;}var j=true,k=this._getContexts(s,l),o={},n;n=this.calculateSection(s,l,t,k);j=k.length!=l&&!(this.bLengthFinal&&k.length>=this.iLength-s);if(this.oModel.getServiceMetadata()){if(!this.bPendingRequest&&n.length>0&&(j||l<n.length)){this.loadData(n.startIndex,n.length);k.dataRequested=true;}}if(this.bRefresh){if(this.bLengthFinal&&this.iLength==0){this.loadData(n.startIndex,n.length,true);k.dataRequested=true;}this.bRefresh=false;}else{for(var i=0;i<k.length;i++){o[k[i].getPath()]=k[i].getObject();}if(this.bUseExtendedChangeDetection){if(this.aLastContexts&&s<this.iLastEndIndex){var p=this;var D=q.sap.arrayDiff(this.aLastContexts,k,function(r,N){return e(r&&p.oLastContextData&&p.oLastContextData[r.getPath()],N&&o&&o[N.getPath()]);},true);k.diff=D;}}this.iLastEndIndex=s+l;this.aLastContexts=k.slice(0);this.oLastContextData=m({},o);}return k;};
h.prototype.getCurrentContexts=function(){return this.aLastContexts||[];};
h.prototype._getContexts=function(s,l){var j=[],o,k;if(!s){s=0;}if(!l){l=this.oModel.iSizeLimit;if(this.bLengthFinal&&this.iLength<l){l=this.iLength;}}for(var i=s;i<s+l;i++){k=this.aKeys[i];if(!k){break;}o=this.oModel.getContext('/'+k);j.push(o);}return j;};
h.prototype.calculateSection=function(s,l,t,k){var n,o,p,P,r,u={},K;o=s;n=0;for(var i=s;i>=Math.max(s-t,0);i--){K=this.aKeys[i];if(!K){P=i+1;break;}}for(var j=s+l;j<s+l+t;j++){K=this.aKeys[j];if(!K){p=j;break;}}r=s-P;if(P&&s>t&&r<t){if(k.length!=l){o=s-t;}else{o=P-t;}n=t;}o=Math.max(o,0);if(o==s){o+=k.length;}if(k.length!=l){n+=l-k.length;}r=p-s-l;if(r==0){n+=t;}if(p&&r<t&&r>0){if(o>s){o=p;n+=t;}}if(this.bLengthFinal&&this.iLength<(n+o)){n=this.iLength-o;}u.startIndex=o;u.length=n;return u;};
h.prototype.setContext=function(o){if(this.oContext!=o){this.oContext=o;if(this.isRelative()){this._initSortersFilters();if(!this.bInitial){var r=this.oModel._getObject(this.sPath,this.oContext);this.aExpandRefs=r;if(Array.isArray(r)&&!this.aSorters.length>0&&!this.aFilters.length>0){this.aKeys=r;this.iLength=r.length;this.bLengthFinal=true;this._fireChange({reason:C.Context});}else if(!this.oModel.resolve(this.sPath,this.oContext)||r===null){this.aKeys=[];this.iLength=0;this.bLengthFinal=true;this._fireChange({reason:C.Context});}else{this.refresh();}}}}};
h.prototype.getDownloadUrl=function(s){var p=[],P;if(s){p.push("$format="+encodeURIComponent(s));}if(this.sSortParams){p.push(this.sSortParams);}if(this.sFilterParams){p.push(this.sFilterParams);}if(this.sCustomParams){p.push(this.sCustomParams);}P=this.oModel.resolve(this.sPath,this.oContext);if(P){return this.oModel._createRequestUrl(P,null,p);}};
h.prototype.loadData=function(s,l,p){var t=this,I=false;if(s||l){this.sRangeParams="$skip="+s+"&$top="+l;this.iStartIndex=s;}else{s=this.iStartIndex;}var P=[];if(this.sRangeParams){P.push(this.sRangeParams);}if(this.sSortParams){P.push(this.sSortParams);}if(this.sFilterParams){P.push(this.sFilterParams);}if(this.sCustomParams){P.push(this.sCustomParams);}if(!this.bLengthFinal&&(this.sCountMode==d.Inline||this.sCountMode==d.Both)){P.push("$inlinecount=allpages");I=true;}function j(D){q.each(D.results,function(i,r){t.aKeys[s+i]=t.oModel._getKey(r);});if(I&&D.__count){t.iLength=parseInt(D.__count);t.bLengthFinal=true;}if(t.iLength<s+D.results.length){t.iLength=s+D.results.length;t.bLengthFinal=false;}if(D.results.length<l||l===undefined){t.iLength=s+D.results.length;t.bLengthFinal=true;}if(s==0&&D.results.length==0){t.iLength=0;t.bLengthFinal=true;}t.oRequestHandle=null;t.bPendingRequest=false;t.bNeedsUpdate=true;t.bIgnoreSuspend=true;}function k(D){t.fireDataReceived({data:D});}function E(i,A){t.oRequestHandle=null;t.bPendingRequest=false;if(!A){t.aKeys=[];t.iLength=0;t.bLengthFinal=true;t.bDataAvailable=true;t._fireChange({reason:C.Change});}t.fireDataReceived();}function u(H){t.oRequestHandle=H;}var n=this.sPath,o=this.oContext;if(this.isRelative()){n=this.oModel.resolve(n,o);}if(n){if(p){var U=this.oModel._createRequestUrl(n,null,P);this.fireDataRequested();this.oModel.fireRequestSent({url:U,method:"GET",async:true});setTimeout(function(){t.bNeedsUpdate=true;t.checkUpdate();t.oModel.fireRequestCompleted({url:U,method:"GET",async:true,success:true});t.fireDataReceived({data:{}});},0);}else{this.bPendingRequest=true;this.fireDataRequested();this.oModel._loadData(n,P,j,E,false,u,k);}}};
h.prototype.getLength=function(){if(this.bLengthFinal||this.iLength==0){return this.iLength;}else{var A=this.iLastThreshold||this.iLastLength||10;return this.iLength+A;}};
h.prototype.isLengthFinal=function(){return this.bLengthFinal;};
h.prototype._getLength=function(){var t=this;var p=[];if(this.sFilterParams){p.push(this.sFilterParams);}if(this.mParameters&&this.mParameters.custom){var o={custom:{}};q.each(this.mParameters.custom,function(s,v){o.custom[s]=v;});p.push(this.oModel.createCustomParams(o));}function _(D){t.iLength=parseInt(D);t.bLengthFinal=true;}function i(E){var s="Request for $count failed: "+E.message;if(E.response){s+=", "+E.response.statusCode+", "+E.response.statusText+", "+E.response.body;}f.warning(s);}var P=this.oModel.resolve(this.sPath,this.oContext);if(P){var u=this.oModel._createRequestUrl(P+"/$count",null,p);var r=this.oModel._createRequest(u,"GET",false);r.headers["Accept"]="text/plain, */*;q=0.5";this.oModel._request(r,_,i,undefined,undefined,this.oModel.getServiceMetadata());}};
h.prototype.refresh=function(j,k,E){var l=false;if(!j){if(E){var r=this.oModel.resolve(this.sPath,this.oContext);var o=this.oModel.oMetadata._getEntityTypeByPath(r);if(o&&(o.entityType in E)){l=true;}}if(k&&!l){q.each(this.aKeys,function(i,K){if(K in k){l=true;return false;}});}if(!k&&!E){l=true;}}if(j||l){this.abortPendingRequest();this.resetData();this._fireRefresh({reason:C.Refresh});}};
h.prototype._fireRefresh=function(p){if(this.oModel.resolve(this.sPath,this.oContext)){this.bRefresh=true;this.fireEvent("refresh",p);}};
h.prototype.initialize=function(){if(this.oModel.oMetadata.isLoaded()){if(this.bDataAvailable){this._fireChange({reason:C.Change});}else{this._fireRefresh({reason:C.Refresh});}}};
h.prototype.checkUpdate=function(j,k){var l=this.sChangeReason?this.sChangeReason:C.Change,n=false,o,p,t=this,r,R;if(this.bSuspended&&!this.bIgnoreSuspend){return;}if(!j&&!this.bNeedsUpdate){r=this.oModel._getObject(this.sPath,this.oContext);R=Array.isArray(r)&&!e(r,this.aExpandRefs);this.aExpandRefs=r;if(R){if(this.aSorters.length>0||this.aFilters.length>0){this.refresh();return;}else{this.aKeys=r;this.iLength=r.length;this.bLengthFinal=true;n=true;}}else if(k){q.each(this.aKeys,function(i,K){if(K in k){n=true;return false;}});}else{n=true;}if(n&&this.aLastContexts){n=false;var s=this._getContexts(this.iLastStartIndex,this.iLastLength,this.iLastThreshold);if(this.aLastContexts.length!=s.length){n=true;}else{q.each(this.aLastContexts,function(i,u){o=t.oLastContextData[u.getPath()];p=s[i].getObject();if(!e(o,p,true)){n=true;return false;}});}}}if(j||n||this.bNeedsUpdate){this.bNeedsUpdate=false;this._fireChange({reason:l});}this.sChangeReason=undefined;this.bIgnoreSuspend=false;};
h.prototype.resetData=function(){this.aKeys=[];this.iLength=0;this.bLengthFinal=false;this.sChangeReason=undefined;this.bDataAvailable=false;if(this.oModel.isCountSupported()&&(this.sCountMode==d.Request||this.sCountMode==d.Both)){this._getLength();}};
h.prototype.abortPendingRequest=function(){if(this.oRequestHandle){this.oRequestHandle.abort();this.oRequestHandle=null;this.bPendingRequest=false;}};
h.prototype.sort=function(s,r){var i=false;if(!s){s=[];}if(s instanceof S){s=[s];}this.aSorters=s;this.createSortParams(s);if(!this.bInitial){this.aKeys=[];this.abortPendingRequest();this.sChangeReason=C.Sort;this._fireRefresh({reason:this.sChangeReason});this._fireSort({sorter:s});i=true;}if(r){return i;}else{return this;}};
h.prototype.createSortParams=function(s){this.sSortParams=c.createSortParams(s);};
h.prototype.filter=function(i,s,r){var j=false;if(!i){i=[];}if(i instanceof F){i=[i];}this.oModel.checkFilterOperation(i);if(s==a.Application){this.aApplicationFilters=i;}else{this.aFilters=i;}if(!i||!Array.isArray(i)||i.length==0){this.aFilters=[];}if(!this.aApplicationFilters||!Array.isArray(this.aApplicationFilters)||this.aApplicationFilters.length===0){this.aApplicationFilters=[];}this.convertFilters();this.oCombinedFilter=b.combineFilters(this.aFilters,this.aApplicationFilters);this.createFilterParams(this.oCombinedFilter);if(!this.bInitial){this.resetData();this.abortPendingRequest();this.sChangeReason=C.Filter;this._fireRefresh({reason:this.sChangeReason});if(s==a.Application){this._fireFilter({filters:this.aApplicationFilters});}else{this._fireFilter({filters:this.aFilters});}j=true;}if(r){return j;}else{return this;}};
h.prototype.convertFilters=function(){this.aFilters=this.aFilters.map(function(o){return o instanceof O?o.convert():o;});this.aApplicationFilters=this.aApplicationFilters.map(function(o){return o instanceof O?o.convert():o;});};
h.prototype.createFilterParams=function(o){this.sFilterParams=c.createFilterParams(o,this.oModel.oMetadata,this.oEntityType);};
h.prototype._initSortersFilters=function(){var r=this.oModel.resolve(this.sPath,this.oContext);if(!r){return;}this.oEntityType=this._getEntityType();this.convertFilters();this.oCombinedFilter=b.combineFilters(this.aFilters,this.aApplicationFilters);this.createSortParams(this.aSorters);this.createFilterParams(this.oCombinedFilter);};
h.prototype._getEntityType=function(){var r=this.oModel.resolve(this.sPath,this.oContext);if(r){var E=this.oModel.oMetadata._getEntityTypeByPath(r);g(E,"EntityType for path "+r+" could not be found!");return E;}return undefined;};
h.prototype.resume=function(){this.bIgnoreSuspend=false;L.prototype.resume.apply(this,arguments);};
return h;});
sap.ui.predefine('sap/ui/model/odata/ODataMessageParser',["sap/ui/model/odata/ODataMetadata","sap/ui/model/odata/ODataUtils","sap/ui/core/library","sap/ui/thirdparty/URI","sap/ui/core/message/MessageParser","sap/ui/core/message/Message","sap/base/Log","sap/ui/thirdparty/jquery"],function(O,a,c,U,M,b,L,q){"use strict";var C="sap.ui.model.odata.ODataMessageParser",r=/^\/+|\/$/g,d=c.MessageType,s={"error":d.Error,"info":d.Information,"success":d.Success,"warning":d.Warning};
var e=M.extend("sap.ui.model.odata.ODataMessageParser",{
metadata:{publicMethods:["parse","setProcessor","getHeaderField","setHeaderField"]},
constructor:function(S,m,p){M.apply(this);this._serviceUrl=f(this._parseUrl(S).url);this._metadata=m;this._headerField="sap-message";this._lastMessages=[];this._bPersistTechnicalMessages=p;}
});
e.prototype.getHeaderField=function(){return this._headerField;};
e.prototype.setHeaderField=function(F){this._headerField=F;return this;};
e.prototype.parse=function(R,o,G,m,i){var k,n;if(o.method==="GET"&&String(R.statusCode)==="204"){return;}k=[];n={request:o,response:R,url:o?o.requestUri:R.requestUri};if(R.statusCode>=200&&R.statusCode<300){this._parseHeader(k,R,n);}else if(R.statusCode>=400&&R.statusCode<600){this._parseBody(k,R,n);}else{L.warning("No rule to parse OData response with status "+R.statusCode+" for messages");}this._propagateMessages(k,n,G,m,!i);};
e.prototype._getAffectedTargets=function(m,R,G,i){var A=Object.assign({"":true},G,i),E,k=this._parseUrl(R.url).url;if(R.request&&R.request.key&&R.request.created){A[R.request.key]=true;}if(k.startsWith(this._serviceUrl)){k=k.slice(this._serviceUrl.length+1);}E=this._metadata._getEntitySetByPath(k);if(E){A[E.name]=true;}m.forEach(function(o){o.getTargets().forEach(function(t){var p,S,T;if(!t){return;}T=t.replace(r,"");A[T]=true;S=T.lastIndexOf("/");if(S>0){p=T.slice(0,S);A[p]=true;}});});return A;};
e.prototype._propagateMessages=function(m,R,G,i,S){var A,D=R.request.deepPath,k=[],n,p=D&&R.request.updateAggregatedMessages,t=R.request.headers&&R.request.headers["sap-messages"]==="transientOnly",o=[],u=O._returnsCollection(R.request.functionMetadata),v,w,x;function y(z,T){return T.some(function(B){return A[B];})||p&&z.aFullTargets.some(function(F){if(u){return n.some(function(K){var B=K.slice(K.indexOf("("));return F.startsWith(D+B);});}else{return F.startsWith(D);}});}G=G||{};if(t){k=this._lastMessages;v=m.some(function(z){return!z.getPersistent()&&!z.getTechnical();});if(v){L.error("Unexpected non-persistent message in response, but requested only "+"transition messages",undefined,C);}}else{A=this._getAffectedTargets(m,R,G,i);n=Object.keys(G);w=R.response.statusCode;x=(w>=200&&w<300);this._lastMessages.forEach(function(z){var T=z.getTargets().map(function(B){B=B.replace(r,"");var P=B.lastIndexOf(")/");if(P>0){B=B.substr(0,P+1);}return B;});if(x||S){if(!z.getPersistent()&&y(z,T)){o.push(z);}else{k.push(z);}}else if(!z.getPersistent()&&z.getTechnical()&&y(z,T)){o.push(z);}else{k.push(z);}});}this.getProcessor().fireMessageChange({oldMessages:o,newMessages:m});this._lastMessages=k.concat(m);};
e.prototype._createMessage=function(m,R,i){var p=m.target&&m.target.indexOf("/#TRANSIENT#")===0||m.transient||m.transition||i&&this._bPersistTechnicalMessages,t,T=typeof m.message==="object"?m.message.value:m.message,k=m["@sap.severity"]||m.severity;m.transition=!!p;t=this._createTargets(m,R,i);return new b({code:m.code||"",description:m.description,descriptionUrl:m.longtext_url||"",fullTarget:t.aDeepPaths,message:T,persistent:!!p,processor:this._processor,target:t.aTargets,technical:i,technicalDetails:{headers:R.response.headers,statusCode:R.response.statusCode},type:s[k]||k});};
e._isResponseForCreate=function(R){var o=R.request,i=R.response;if(o.method==="POST"&&i.statusCode==201&&i.headers["location"]){return true;}if(o.key&&o.created&&i.statusCode>=400){return false;}};
e.prototype._createTarget=function(o,R,i,k){var m,n,D,p,P,t,u,v,w,x=R.request,y=R.response;if(o===undefined&&(!i&&x.headers["sap-message-scope"]==="BusinessObject"||i&&k)){return{deepPath:"",target:""};}o=o||"";o=o.startsWith("/#TRANSIENT#")?o.slice(12):o;if(o[0]!=="/"){n=e._isResponseForCreate(R);D=x.deepPath||"";if(n===true){w=y.headers["location"];}else if(n===false){w=x.key;}else{w=R.url;}v=this._parseUrl(w);u=v.url;p=u.indexOf(this._serviceUrl);if(p>-1){t=u.slice(p+this._serviceUrl.length);}else{t="/"+u;}if(!n&&x.functionMetadata){t=x.functionTarget;}if(t.slice(t.lastIndexOf("/")).indexOf("(")>-1||!this._metadata._isCollection(t)){D=o?D+"/"+o:D;o=o?t+"/"+o:t;}else{D=D+o;o=t+o;}}m=this._processor.resolve(o,undefined,true);while(m&&m.lastIndexOf("/")>0&&m!==P){P=m;m=this._processor.resolve(m,undefined,true)||P;}o=m||o;return{deepPath:this._metadata._ge