/*
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/Device','sap/ui/base/ManagedObject','sap/ui/thirdparty/sinon','sap/base/Log','sap/base/util/isEmptyObject','jquery.sap.sjax'],function(q,D,M,d,L,f){"use strict";if(D.browser.msie){if(window.sinon.log){sap.ui.requireSync("sap/ui/thirdparty/sinon-ie");}if(!window.FormData){window.FormData=function(){};}}var g=M.extend("sap.ui.core.util.MockServer",{constructor:function(i,s,S){M.apply(this,arguments);g._aServers.push(this);},metadata:{library:"sap.ui.core",properties:{rootUri:"string",recordRequests:{type:"boolean",defaultValue:true},requests:{type:"object[]",defaultValue:[]}}},_oServer:null,_aFilter:null,_oMockdata:null,_oMetadata:null,_sMetadataUrl:null,_sMockdataBaseUrl:null,_mEntitySets:null,_oErrorMessages:{INVALID_SYSTEM_QUERY_OPTION_VALUE:"Invalid system query options value",IS_NOT_A_VALID_SYSTEM_QUERY_OPTION:"## is not a valid system query option",URI_VIOLATING_CONSTRUCTION_RULES:"The URI is violating the construction rules defined in the Data Services specification",UNSUPPORTED_FORMAT_VALUE:"Unsupported format value. Only json format is supported",MALFORMED_SYNTAX:"The Data Services Request could not be understood due to malformed syntax",RESOURCE_NOT_FOUND:"Resource not found",INVALID_SORTORDER_DETECTED:"Invalid sortorder ## detected",PROPERTY_NOT_FOUND:"Property ## not found",INVALID_FILTER_QUERY_STATEMENT:"Invalid filter query statement",INVALID_FILTER_OPERATOR:"Invalid $filter operator ##",RESOURCE_NOT_FOUND_FOR_SEGMENT:"Resource not found for the segment ##",MALFORMED_URI_LITERAL_SYNTAX_IN_KEY:"Malformed URI literal syntax in key ##",INVALID_KEY_NAME:"Invalid key name in key predicate. Expected name is ##",INVALID_KEY_PREDICATE_QUANTITY:"Invalid key predicate. The quantity of provided keys does not match the expected value",INVALID_KEY_TYPE:"Invalid key predicate. The key literal for key property ## does not match its type."},_oRandomSeed:{}});g.prototype._getPseudoRandomNumber=function(t){if(!this._oRandomSeed){this._oRandomSeed={};}if(!this._oRandomSeed.hasOwnProperty(t)){this._oRandomSeed[t]=0;}this._oRandomSeed[t]=(this._oRandomSeed[t]+11)*25214903917%281474976710655;return this._oRandomSeed[t]/281474976710655;};g.prototype._resetPseudoRandomNumberGenerator=function(){this._oRandomSeed={};};g.prototype.start=function(){this._oServer=g._getInstance();this._aFilters=[];var r=this.getRequests();var t=this;r.forEach(function(R){var a;if(t.getRecordRequests()===false&&R.response){a=function(){R.response.apply(this,arguments);t._oServer.requests=[];};}else{a=R.response;}t._addRequestHandler(R.method,R.path,a);});};g.prototype.stop=function(){if(this.isStarted()){this._removeAllRequestHandlers();this._removeAllFilters();this._oServer=null;}};g.prototype.attachBefore=function(H,c,e){e=e?e:"";this.attachEvent(H+e+":before",c);};g.prototype.attachAfter=function(H,c,e){e=e?e:"";this.attachEvent(H+e+":after",c);};g.prototype.detachBefore=function(H,c,e){e=e?e:"";this.detachEvent(H+e+":before",c);};g.prototype.detachAfter=function(H,c,e){e=e?e:"";this.detachEvent(H+e+":after",c);};g.prototype.isStarted=function(){return!!this._oServer;};g.prototype.getEntitySetData=function(e){var t=this;var c;if(this._oMockdata&&this._oMockdata.hasOwnProperty(e)){c=q.extend(true,[],t._oMockdata[e]);}else{L.error("Unrecognized EntitySet name: "+e);}return c;};g.prototype.setEntitySetData=function(e,a){if(this._oMockdata&&this._oMockdata.hasOwnProperty(e)){this._oMockdata[e]=a;}else{L.error("Unrecognized EntitySet name: "+e);}};g.prototype._applyQueryOnCollection=function(F,Q,e,u){var a=Q.split('=');var o=a[1];if(o===""){return;}if(o.lastIndexOf(',')===o.length-1){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.URI_VIOLATING_CONSTRUCTION_RULES);}switch(a[0]){case"$top":if(!(new RegExp(/^\d+$/).test(o))){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.INVALID_SYSTEM_QUERY_OPTION_VALUE);}F.results=F.results.slice(0,o);break;case"$skip":if(!(new RegExp(/^\d+$/).test(o))){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.INVALID_SYSTEM_QUERY_OPTION_VALUE);}F.results=F.results.slice(o,F.results.length);break;case"$orderby":F.results=this._getOdataQueryOrderby(F.results,o,e);break;case"$filter":F.results=this._recursiveOdataQueryFilter(F.results,o);break;case"search-focus":break;case"search":var s="";for(var i=0;i<u.length;i++){if(u[i].indexOf("search-focus")!=-1){s=u[i].split('=')[1];break;}}F.results=this._recursiveOdataQuerySearch(F.results,o,s,e);break;case"$select":F.results=this._getOdataQuerySelect(F.results,o,e);break;case"$inlinecount":var c=this._getOdataInlineCount(F.results,o);if(c){F.__count=c;}break;case"$expand":F.results=this._getOdataQueryExpand(F.results,o,e);break;case"$format":F.results=this._getOdataQueryFormat(F.results,o);break;default:this._logAndThrowMockServerCustomError(400,this._oErrorMessages.IS_NOT_A_VALID_SYSTEM_QUERY_OPTION,a[0]);}};g.prototype._applyQueryOnEntry=function(e,Q,E){var a=Q.split('=');var o=a[1];if(o===""){return;}if(o.lastIndexOf(',')===o.length-1){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.URI_VIOLATING_CONSTRUCTION_RULES);}switch(a[0]){case"$filter":return this._recursiveOdataQueryFilter([e],o)[0];case"$select":return this._getOdataQuerySelect([e],o,E)[0];case"$expand":return this._getOdataQueryExpand([e],o,E)[0];case"$format":return this._getOdataQueryFormat([e],o);default:this._logAndThrowMockServerCustomError(400,this._oErrorMessages.IS_NOT_A_VALID_SYSTEM_QUERY_OPTION,a[0]);}};g.prototype._getOdataQueryOrderby=function(c,o,e){var p=o.split(',');var t=this;q.each(p,function(i,P){p[i]=t._trim(P);});var C=function m(a,b){for(var i=0;i<p.length;i++){var s=p[i].split(' ');var S=1;if(s.length>1){switch(s[1]){case'asc':S=1;break;case'desc':S=-1;break;default:t._logAndThrowMockServerCustomError(400,t._oErrorMessages.INVALID_SORTORDER_DETECTED,s[1]);}}var P,j;var k=s[0].indexOf("/");if(k!==-1){P=s[0].substring(k+1);j=s[0].substring(0,k);if(!a[j].hasOwnProperty(P)){var E=false;var T=[];if(j){var l=t._mEntitySets[e].navprops[j].to.entitySet;T=t._mEntityTypes[t._mEntitySets[l].type].properties;for(var i=0;i<T.length;i++){if(T[i].name===P){E=true;break;}}}if(!E){t._logAndThrowMockServerCustomError(400,t._oErrorMessages.PROPERTY_NOT_FOUND,P);}}if(a[j][P]<b[j][P]){return-1*S;}if(a[j][P]>b[j][P]){return 1*S;}}else{P=s[0];if(!a.hasOwnProperty(P)){t._logAndThrowMockServerCustomError(400,t._oErrorMessages.PROPERTY_NOT_FOUND,P);}if(a[P]<b[P]){return-1*S;}if(a[P]>b[P]){return 1*S;}}}return 0;};return c.sort(C);};g.prototype._arrayUnique=function(b){var a=b.concat();for(var i=0;i<a.length;++i){for(var j=i+1;j<a.length;++j){if(a[i]===a[j]){a.splice(j--,1);}}}return a;};g.prototype._getBracketIndices=function(s){var S=[];var r=false;var i,e=0;for(var c=0;c<s.length;c++){if(s[c]==='('){if(/[substringof|endswith|startswith]$/.test(s.substring(0,c))){r=true;}else{S.push(s[c]);if(i===undefined){i=c;}}}else if(s[c]===')'){if(!r){S.pop();e=c;if(S.length===0){return{start:i,end:e};}}else{r=false;}}}return{start:i,end:e};};g.prototype._recursiveOdataQueryFilter=function(a,o){var I=this._getBracketIndices(o);if(I.start===0&&I.end===o.length-1){o=this._trim(o.substring(I.start+1,I.end));return this._recursiveOdataQueryFilter(a,o);}var r=/([^substringof|endswith|startswith]|^)\((.*)\)/,s,p;var O;if(r.test(o)){var b=o.substring(I.start,I.end+1);var c=new RegExp("(.*) +(or|and) +("+this._trim(this._escapeStringForRegExp(b))+".*)");if(I.start===0){c=new RegExp("("+this._trim(this._escapeStringForRegExp(b))+") +(or|and) +(.*)");}var e=c.exec(o);if(e===null){return this._getOdataQueryFilter(a,this._trim(o));}var E=e[1];O=e[2];var j=e[3];var S=this._recursiveOdataQueryFilter(a,E);if(O==="or"){s=this._recursiveOdataQueryFilter(a,j);return this._arrayUnique(S.concat(s));}if(O==="and"){return this._recursiveOdataQueryFilter(S,j);}}else{p=o.split(/ +and | or +/);if(p.length===1){if(o.match(/ +and | or +/)){throw new Error("400");}return this._getOdataQueryFilter(a,this._trim(o));}var R=this._recursiveOdataQueryFilter(a,p[0]);var k;for(var i=1;i<p.length;i++){k=new RegExp(this._trim(this._escapeStringForRegExp(p[i-1]))+" +(and|or) +"+this._trim(this._escapeStringForRegExp(p[i])));O=k.exec(o)[1];if(O==="or"){s=this._recursiveOdataQueryFilter(a,p[i]);R=this._arrayUnique(R.concat(s));}if(O==="and"){R=this._recursiveOdataQueryFilter(R,p[i]);}}return R;}};g.prototype._getOdataQueryFilter=function(a,o){if(a.length===0){return a;}var r=new RegExp("(.*) (eq|ne|gt|lt|le|ge) (.*)");var b=new RegExp("(endswith|startswith|substringof)\\((.*)");var O=null;var c=r.exec(o);if(c){O=c[2];}else{c=b.exec(o);if(c){O=c[1];}else{this._logAndThrowMockServerCustomError(400,this._oErrorMessages.INVALID_FILTER_QUERY_STATEMENT);}}var t=this;var G=function(v,V,p,s){var c,e,P;if(!v){c=r.exec(o);e=t._trim(c[V+1]);P=t._trim(c[p+1]);}else{var i=new RegExp("(substringof|startswith|endswith)\\(([^\\)]*),(.*)\\)");c=i.exec(o);e=t._trim(c[V+2]);P=t._trim(c[p+2]);}if(/^\(.+\)$/.test(e)){e=e.replace(/^\(|\)$/g,"");}var T=e[e.length-1];if(T==="M"||T==="m"||T==="L"||T==="f"){e=e.substring(0,e.length-1);}if(e.indexOf("datetime")===0){e=t._getJsonDate(e);}else if(e.indexOf("guid")===0){e=e.substring(5,e.length-1);}else if(e==="true"){e=true;}else if(e==="false"){e=false;}else if(t._isValidNumber(e)){e=parseFloat(e);}else if((e.charAt(0)==="'")&&(e.charAt(e.length-1)==="'")){e=e.substr(1,e.length-2);}var C=P.indexOf("/");if(C!==-1){var j=P.substring(C+1);var k=P.substring(0,C);if(a[0][k]){if(!a[0][k].hasOwnProperty(j)){var E=t._oErrorMessages.PROPERTY_NOT_FOUND.replace("##","'"+j+"'");L.error("MockServer: navigation property '"+k+"' was not expanded, so "+E);return a;}}else{t._logAndThrowMockServerCustomError(400,t._oErrorMessages.PROPERTY_NOT_FOUND,P);}return s(P,e,k,j);}else{if(!a[0].hasOwnProperty(P)){t._logAndThrowMockServerCustomError(400,t._oErrorMessages.PROPERTY_NOT_FOUND,P);}return s(P,e);}};switch(O){case"substringof":return G(true,0,1,function(p,v,C,P){return a.filter(function(m){if(C&&P){return(typeof m[C][P]==="string"&&m[C][P].indexOf(v)!==-1);}return(typeof m[p]==="string"&&m[p].indexOf(v)!==-1);});});case"startswith":return G(true,1,0,function(p,v,C,P){return a.filter(function(m){if(C&&P){return(typeof m[C][P]==="string"&&m[C][P].indexOf(v)===0);}return(typeof m[p]==="string"&&m[p].indexOf(v)===0);});});case"endswith":return G(true,1,0,function(p,v,C,P){return a.filter(function(m){if(C&&P){return(typeof m[C][P]==="string"&&m[C][P].indexOf(v)===(m[C][P].length-v.length));}return(typeof m[p]==="string"&&m[p].indexOf(v)===(m[p].length-v.length));});});case"eq":return G(false,2,0,function(p,v,C,P){return a.filter(function(m){if(C&&P){return(m[C][P]===v);}return(m[p]===v);});});case"ne":return G(false,2,0,function(p,v,C,P){return a.filter(function(m){if(C&&P){return(m[C][P]!==v);}return(m[p]!==v);});});case"gt":return G(false,2,0,function(p,v,C,P){return a.filter(function(m){if(C&&P){return(m[C][P]>v);}return(m[p]>v);});});case"lt":return G(false,2,0,function(p,v,C,P){return a.filter(function(m){if(C&&P){return(m[C][P]<v);}return(m[p]<v);});});case"ge":return G(false,2,0,function(p,v,C,P){return a.filter(function(m){if(C&&P){return(m[C][P]>=v);}return(m[p]>=v);});});case"le":return G(false,2,0,function(p,v,C,P){return a.filter(function(m){if(C&&P){return(m[C][P]<=v);}return(m[p]<=v);});});default:this._logAndThrowMockServerCustomError(400,t._oErrorMessages.INVALID_FILTER_OPERATOR,O);}};g.prototype._recursiveOdataQuerySearch=function(a,o,O,e){var F="";if(O==""||O==undefined){for(var i=0;i<this._mEntitySets[e].keys.length;i++){if(i!=0){F=F+" or ";}F=F+"startswith("+this._mEntitySets[e].keys[i]+",'"+o+"')";}}else{F="substringof('"+o+"',"+O+")";}return this._recursiveOdataQueryFilter(a,F);};g.prototype._getOdataQuerySelect=function(a,o,e){var t=this;var p,c;var P=o.split(',');var s=[];var b;var k=a[0]?a[0][P[0].split('/')[0]]:null;if(!(k!=null&&k.results&&k.results.length>0)){var C=function(P,l,b,n){var r={};q.each(P,function(i,j){var u=j.indexOf("/");if(u!==-1){p=j.substring(u+1);c=j.substring(0,u);if(r[c]){r[c].push(p);}else{r[c]=[p];}}});q.each(Object.keys(r),function(i,j){if(!b[j]){b[j]={};}b[j]=C(r[j],l[j],b[j],j);});if(l.results){var F=[];q.each(l.results,function(i,R){var u={};q.each(P,function(j,v){u[v]=R[v];});F.push(u);});if(b){b.results=F;}}else{if(l["__metadata"]){b["__metadata"]=l["__metadata"];}q.each(P,function(i,j){var u=j.indexOf("/");if(u===-1){if(l&&!l.hasOwnProperty(j)){var E=false;var T=[];if(n){var v=t._mEntitySets[e].navprops[n].to.entitySet;T=t._mEntityTypes[t._mEntitySets[v].type].properties;for(var i=0;i<T.length;i++){if(T[i].name===j){E=true;break;}}}if(!E){t._logAndThrowMockServerCustomError(404,t._oErrorMessages.RESOURCE_NOT_FOUND_FOR_SEGMENT,j);}}b[j]=l[j];}});}return b;};if(P.indexOf("*")!==-1){return a;}q.each(P,function(i,j){P[i]=t._trim(j);});q.each(a,function(i,j){b={};s.push(C(P,j,b));});}else{var m=function(i,j,l){var r={};l=l||'';if(typeof i!=='object'){return i;}if(typeof i.slice==='function'){return i.map(function(n,u){return m(n,j,l);});}if(i.__metadata!==undefined&&l.length===0){r.__metadata=i.__metadata;}j.filter(function(n){return(n+'/').indexOf(l)===0;}).forEach(function(n,_,u){var v=n.substr(l.length).split('/')[0];if(i[v]!==undefined){r[v]=m(i[v],u,l+v+'/');}});if(i.results!==undefined){r.results=m(i.results,j,l);}return r;};s=m(a,P);}return s;};g.prototype._getOdataInlineCount=function(a,o){var p=o.split(',');if(p.length!==1||(p[0]!=='none'&&p[0]!=='allpages')){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.INVALID_SYSTEM_QUERY_OPTION_VALUE);}if(p[0]==='none'){return;}return a.length;};g.prototype._getOdataQueryFormat=function(a,o){if(o!=='json'){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.UNSUPPORTED_FORMAT_VALUE);}return a;};g.prototype._getOdataQueryExpand=function(a,o,e){var t=this;var n=o.split(',');q.each(n,function(i,p){n[i]=t._trim(p);});var E=t._mEntitySets[e].navprops;q.each(a,function(i,r){q.each(n,function(i,N){var b=N.split("/");var s=b[0];if(!r[s]){t._logAndThrowMockServerCustomError(404,t._oErrorMessages.RESOURCE_NOT_FOUND_FOR_SEGMENT,s);}var c=r[s].results||r[s];if(!c||!!c.__deferred){c=q.extend(true,[],t._resolveNavigation(e,r,s,r));}else if(!Array.isArray(c)){c=[c];}if(!!c&&b.length>1){var R=b.splice(1,b.length).join("/");c=t._getOdataQueryExpand(c,R,E[s].to.entitySet);}if(E[s].to.multiplicity==="*"){r[s]={results:c};}else{r[s]=c[0]?c[0]:{};}});});return a;};g.prototype._refreshData=function(){var m=this._loadMetadata(this._sMetadataString);if(!m){return;}this._mEntitySets=this._findEntitySets(this._oMetadata);this._mEntityTypes=this._findEntityTypes(this._oMetadata);if(!this._sMockdataBaseUrl){this._generateMockdata(this._mEntitySets,this._oMetadata);}else{if(!this._sMockdataBaseUrl.endsWith("/")&&!this._sMockdataBaseUrl.endsWith(".json")){this._sMockdataBaseUrl+="/";}this._loadMockdata(this._mEntitySets,this._sMockdataBaseUrl);}};g.prototype._getRootUri=function(){var u=this.getRootUri();u=u&&/([^?#]*)([?#].*)?/.exec(u)[1];return u;};g.prototype._loadMetadata=function(m){var m;m=m.trim();if(m.substring(0,1)!=="<"){m=q.sap.sjax({url:m,dataType:"text"}).data;if(!m){L.error("MockServer: The metadata for url \""+m+"\" could not be found!");}}this._sMetadata=m;try{this._oMetadata=q.parseXML(m);}catch(e){L.error("MockServer: Invalid metadata XML! Reason: "+e);}return this._oMetadata;};g.prototype._findEntitySets=function(m){var e={};var p=q(m).find("Principal");var o=q(m).find("Dependent");q(m).find("EntitySet").each(function(i,E){var $=q(E);var a=/((.*)\.)?(.*)/.exec($.attr("EntityType"));e[$.attr("Name")]={"name":$.attr("Name"),"schema":a[2],"type":a[3],"keys":[],"keysType":{},"navprops":{}};});var r=function(R,a,A,F){var E=q(A).find("End[Role='"+R+"']").attr("EntitySet");var s=q(a).find("End[Role='"+R+"']").attr("Multiplicity");var P=[];var c=q(a).find("ReferentialConstraint > [Role='"+R+"']");if(c&&c.length>0){q(c[0]).children("PropertyRef").each(function(i,j){P.push(q(j).attr("Name"));});}else{var b=(F)?p:o;q(b).each(function(i,j){if(R===(q(j).attr("Role"))){q(j).children("PropertyRef").each(function(i,k){P.push(q(k).attr("Name"));});return false;}});}return{"role":R,"entitySet":E,"propRef":P,"multiplicity":s};};q.each(e,function(E,a){var $=q(m).find("EntityType[Name='"+a.type+"']");var k=q($).find("PropertyRef");q.each(k,function(i,P){var K=q(P).attr("Name");a.keys.push(K);a.keysType[K]=q($).find("Property[Name='"+K+"']").attr("Type");});var n=q(m).find("EntityType[Name='"+a.type+"'] NavigationProperty");q.each(n,function(i,N){var b=q(N);var R=b.attr("Relationship").split(".");var A=q(m).find("AssociationSet[Association = '"+R.join(".")+"']");var s=R.pop();var c=q(m).find("Association[Name = '"+s+"']");a.navprops[b.attr("Name")]={"name":b.attr("Name"),"from":r(b.attr("FromRole"),c,A,true),"to":r(b.attr("ToRole"),c,A,false)};});});return e;};g.prototype._findEntityTypes=function(m){var e={};q(m).find("EntityType").each(function(i,E){var $=q(E);e[$.attr("Name")]={"name":$.attr("Name"),"properties":[],"keys":[]};$.find("Property").each(function(i,p){var P=q(p);var t=P.attr("Type");e[$.attr("Name")].properties.push({"schema":t.substring(0,t.lastIndexOf(".")),"type":t.substring(t.lastIndexOf(".")+1),"name":P.attr("Name"),"precision":P.attr("Precision"),"scale":P.attr("Scale")});});$.find("PropertyRef").each(function(i,k){var K=q(k);var p=K.attr("Name");e[$.attr("Name")].keys.push(p);});});return e;};g.prototype._findComplexTypes=function(m){var c={};q(m).find("ComplexType").each(function(i,C){var $=q(C);c[$.attr("Name")]={"name":$.attr("Name"),"properties":[]};$.find("Property").each(function(i,p){var P=q(p);var t=P.attr("Type");c[$.attr("Name")].properties.push({"schema":t.substring(0,t.lastIndexOf(".")),"type":t.substring(t.lastIndexOf(".")+1),"name":P.attr("Name"),"precision":P.attr("Precision"),"scale":P.attr("Scale")});});});return c;};g.prototype._createKeysString=function(e,E){var t=this;var k="";if(E){q.each(e.keys,function(i,K){if(k){k+=",";}var o=E[K];if(e.keysType[K]==="Edm.String"){o=encodeURIComponent("'"+o+"'");}else if(e.keysType[K]==="Edm.DateTime"){o=t._getDateTime(o);o=encodeURIComponent(o);}else if(e.keysType[K]==="Edm.Guid"){o="guid'"+o+"'";}if(e.keys.length===1){k+=o;return k;}k+=K+"="+o;});}return k;};g.prototype._loadMockdata=function(e,b){var t=this,m={};this._oMockdata={};var l=function(u,o){var r=q.sap.sjax({url:u,dataType:"json"});if(r.success){if(r.data.d){if(r.data.d.results){m[o.name]=r.data.d.results;}else{L.error("The mock data format for entity set \""+o.name+"\" invalid");}}else{if(Array.isArray(r.data)){m[o.name]=r.data;}else{L.error("The mock data for entity set \""+o.name+"\" could not be loaded due to wrong format!");return false;}}return true;}else{if(r.status==="parsererror"){L.error("The mock data for entity set \""+o.name+"\" could not be loaded due to a parsing error!");}return false;}};if(b.endsWith(".json")){var r=q.sap.sjax({url:b,dataType:"json"});if(r.success){m=r.data;}else{L.warning("The mock data for all the entity types could not be found at \""+b+"\"!");}}else{var E={};if(t._aEntitySetsNames&&t._aEntitySetsNames.length>0){var s;for(var i=0;i<t._aEntitySetsNames.length;i++){s=t._aEntitySetsNames[i];if(e[s]){E[s]=e[s];}}}else{E=e;}q.each(E,function(a,o){if(!m[o.type]||!m[o.name]){var c=b+o.name+".json";if(!l(c,o)){L.warning("The mock data for entity set \""+o.name+"\" could not be found at \""+b+"\"!");var j=b+o.type+".json";if(!l(j,o)){L.warning("The mock data for entity type \""+o.type+"\" could not be found at \""+b+"\"!");if(t._bGenerateMissingMockData){var k={};k[o.name]=o;m[o.type]=t._generateODataMockdataForEntitySet(k,t._oMetadata)[o.name];}}}}});}q.each(e,function(a,o){t._oMockdata[a]=[];if(m[o.name]){q.each(m[o.name],function(I,c){t._oMockdata[a].push(q.extend(true,{},c));});}else if(m[o.type]){q.each(m[o.type],function(I,c){t._oMockdata[a].push(q.extend(true,{},c));});}});q.each(e,function(a,o){if(t._oMockdata[a].length>0){t._enhanceWithMetadata(o,t._oMockdata[a]);}});return this._oMockdata;};g.prototype._enhanceWithMetadata=function(e,m){if(m){var t=this,r=this._getRootUri(),E=e&&e.name;q.each(m,function(i,o){o.__metadata=o.__metadata||{};o.__metadata.id=r+E+"("+t._createKeysString(e,o)+")";o.__metadata.type=e.schema+"."+e.type;o.__metadata.uri=r+E+"("+t._createKeysString(e,o)+")";q.each(e.navprops,function(k,n){if(o[k]&&!f(o[k])&&!o[k]["__deferred"]){t._oMockdata[n.to.entitySet]=t._oMockdata[n.to.entitySet].concat(o[k]);}o[k]={__deferred:{uri:r+E+"("+t._createKeysString(e,o)+")/"+k}};});});}};g.prototype._isRequestedKeysValid=function(e,r){if(r.length===1){var s=r[0].split('=');if(this._trim(s[0])!==e.keys[0]){r=[e.keys[0]+"="+r[0]];}}for(var i=0;i<r.length;i++){var k=this._trim(r[i].substring(0,r[i].indexOf('=')));var R=this._trim(r[i].substring(r[i].indexOf('=')+1));var F=R.charAt(0);var l=R.charAt(R.length-1);if(e.keysType[k]==="Edm.String"){if(F!=="'"||l!=="'"){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.MALFORMED_URI_LITERAL_SYNTAX_IN_KEY,k);}}else if(e.keysType[k]==="Edm.DateTime"){if(F==="'"||l!=="'"){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.MALFORMED_URI_LITERAL_SYNTAX_IN_KEY,k);}}else if(e.keysType[k]==="Edm.Guid"){if(F==="'"||l!=="'"){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.MALFORMED_URI_LITERAL_SYNTAX_IN_KEY,k);}}else if(e.keysType[k]==="Edm.Binary"){if(!(new RegExp("(binary|X)'[A-Fa-f0-9][A-Fa-f0-9]*'").test(R))){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.MALFORMED_URI_LITERAL_SYNTAX_IN_KEY,k);}}else{if((F==="'"&&l!=="'")||(l==="'"&&F!=="'")){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.MALFORMED_URI_LITERAL_SYNTAX_IN_KEY,k);}}var K=e.keys.join(",");if(e.keys.indexOf(k)===-1){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.INVALID_KEY_NAME,K);}}};g.prototype._parseKeys=function(k,e){var r={};var p=k.split(",");var K,s,P;for(var i=0;i<p.length;i++){P=p[i].split("=");if(P.length===1&&e.keys.length===1){K=e.keys[0];s=P[0];}else{if(P.length===2){K=P[0];s=P[1];}}r[K]=s;switch(e.keysType[K]){case"Edm.String":r[K]=r[K].replace(/^\'|\'$/g,"");break;case"Edm.Int16":case"Edm.Int32":case"Edm.Int64":case"Edm.Decimal":case"Edm.Byte":case"Edm.Double":case"Edm.Single":case"Edm.SByte":r[K]=parseFloat(r[K]);break;case"Edm.Guid":r[K]=r[K].replace(/^guid\'|\'$/g,"");break;case"Edm.Boolean":case"Edm.Binary":case"Edm.DateTimeOffset":default:r[K]=r[K];}}return r;};g.prototype._generatePropertyValue=function(k,t,C,i){var I=i;if(!I){I=Math.floor(this._getPseudoRandomNumber("String")*10000)+101;}switch(t){case"String":return k+" "+I;case"DateTime":var a=new Date();a.setFullYear(2000+Math.floor(this._getPseudoRandomNumber("DateTime")*20));a.setDate(Math.floor(this._getPseudoRandomNumber("DateTime")*30));a.setMonth(Math.floor(this._getPseudoRandomNumber("DateTime")*12));a.setMilliseconds(0);return"/Date("+a.getTime()+")/";case"Int16":case"Int32":case"Int64":return Math.floor(this._getPseudoRandomNumber("Int")*10000);case"Decimal":return Math.floor(this._getPseudoRandomNumber("Decimal")*1000000)/100;case"Boolean":return this._getPseudoRandomNumber("Boolean")<0.5;case"Byte":return Math.floor(this._getPseudoRandomNumber("Byte")*10);case"Double":return this._getPseudoRandomNumber("Double")*10;case"Single":return this._getPseudoRandomNumber("Single")*1000000000;case"SByte":return Math.floor(this._getPseudoRandomNumber("SByte")*10);case"Time":return"PT"+Math.floor(this._getPseudoRandomNumber("Time")*23)+"H"+Math.floor(this._getPseudoRandomNumber("Time")*59)+"M"+Math.floor(this._getPseudoRandomNumber("Time")*59)+"S";case"Guid":return'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g,function(c){var r=this._getPseudoRandomNumber("Guid")*16|0,v=c==='x'?r:(r&0x3|0x8);return v.toString(16);}.bind(this));case"Binary":var n=Math.floor(-2147483648+this._getPseudoRandomNumber("Binary")*4294967295),m="";for(var b=0,e=n;b<32;b++,m+=String(e>>>31),e<<=1);return m;case"DateTimeOffset":var a=new Date();a.setFullYear(2000+Math.floor(this._getPseudoRandomNumber("DateTimeOffset")*20));a.setDate(Math.floor(this._getPseudoRandomNumber("DateTimeOffset")*30));a.setMonth(Math.floor(this._getPseudoRandomNumber("DateTimeOffset")*12));a.setMilliseconds(0);return"/Date("+a.getTime()+"+0000)/";default:return this._generateDataFromEntity(C[t],I,C);}};g.prototype._isFalseyValue=function(k,K,s){switch(s){case"Edm.String":return k==="";case"Edm.Boolean":return k===false;case"Edm.Int16":case"Edm.Int32":case"Edm.Int64":case"Edm.Decimal":case"Edm.Byte":case"Edm.Double":case"Edm.Single":case"Edm.SByte":return k===0||isNaN(k);default:return false;}};g.prototype._completeKey=function(e,k,E){if(E){for(var i=0;i<e.keys.length;i++){var K=e.keys[i];if(k[K]!==undefined&&k[K]!==null){if(!E[K]){switch(e.keysType[K]){case"Edm.DateTime":E[K]=this._getJsonDate(k[K]);break;case"Edm.Guid":E[K]=k[K].replace(/^guid\'|\'$/g,"");break;default:E[K]=k[K];}}}else{if(!E[K]){E[K]=this._generatePropertyValue(K,e.keysType[K].substring(e.keysType[K].lastIndexOf('.')+1));}}}}};g.prototype._generateDataFromEntity=function(e,I,c){var E={};if(!e){return E;}for(var i=0;i<e.properties.length;i++){var p=e.properties[i];E[p.name]=this._generatePropertyValue(p.name,p.type,c,I);}return E;};g.prototype._generateDataFromEntitySet=function(e,E,c){var o=E[e.type];var m=[];for(var i=0;i<100;i++){m.push(this._generateDataFromEntity(o,i+1,c));}return m;};g.prototype._generateMockdata=function(e,m){var t=this;var o={};var r=this._getRootUri();q.each(e,function(E,a){var b={};b[a.name]=a;o[E]=t._generateODataMockdataForEntitySet(b,m)[E];});q.each(e,function(E,a){for(var n in a.navprops){var N=a.navprops[n];var p=N.from.propRef.length;for(var j=0;j<p;j++){for(var i=0;i<o[E].length;i++){var b=o[E][i];o[N.to.entitySet][i][N.to.propRef[j]]=b[N.from.propRef[j]];}}}q.each(o[E],function(I,c){c.__metadata={uri:r+E+"("+t._createKeysString(a,c)+")",type:a.schema+"."+a.type};q.each(a.navprops,function(k,N){c[k]={__deferred:{uri:r+E+"("+t._createKeysString(a,c)+")/"+k}};});});});this._oMockdata=o;};g.prototype._generateODataMockdataForEntitySet=function(e,m){var t=this,o={};var E=this._findEntityTypes(m);var c=this._findComplexTypes(m);q.each(e,function(s,a){o[s]=t._generateDataFromEntitySet(a,E,c);});return o;};g.prototype._resolveNavigation=function(e,F,n){var E=this._mEntitySets[e];var N=E.navprops[n];if(!N){this._logAndThrowMockServerCustomError(404,this._oErrorMessages.RESOURCE_NOT_FOUND);}var a=[];var p=N.from.propRef.length;if(p===0){if(N.to.multiplicity==="*"){return this._oMockdata[N.to.entitySet];}else{a.push(this._oMockdata[N.to.entitySet][0]);return a;}}q.each(this._oMockdata[N.to.entitySet],function(I,t){var b=true;for(var i=0;i<p;i++){if(F[N.from.propRef[i]]!==t[N.to.propRef[i]]){b=false;break;}}if(b){a.push(t);}});return a;};g.prototype.simulate=function(s,v){var t=this;this._sMetadataString=s;if(!v||typeof v==="string"){this._sMockdataBaseUrl=v;}else{this._sMockdataBaseUrl=v.sMockdataBaseUrl;this._bGenerateMissingMockData=v.bGenerateMissingMockData;this._aEntitySetsNames=v.aEntitySetsNames;}var o=this._loadMetadata(this._sMetadataString);if(!o){return;}if(this._sMetadata){var a=sap.ui.requireSync("sap/ui/core/util/MockServerAnnotationsHandler");var A=a.parse(this._oMetadata,this._sMetadata);var b=sap.ui.requireSync("sap/ui/core/util/DraftEnabledMockServer");b.handleDraft(A,this);}this._resetPseudoRandomNumberGenerator();this._refreshData();var H=function(x,m){if(x.requestHeaders["x-csrf-token"]==="Fetch"){m["X-CSRF-Token"]="42424242424242424242424242424242";}};var G=function(e,k){k=decodeURIComponent(k);var F;var E=t._mEntitySets[e];var K=E.keys;var j=k.split(',');if(j.length!==K.length){t._logAndThrowMockServerCustomError(400,t._oErrorMessages.INVALID_KEY_PREDICATE_QUANTITY);}t._isRequestedKeysValid(E,j);if(j.length===1&&!j[0].split('=')[1]){j=[K[0]+"="+j[0]];}q.each(t._oMockdata[e],function(I,m){for(var i=0;i<j.length;i++){var n=j[i].split('=');var p=t._trim(n[0]);if(!K||K.indexOf(p)===-1){return true;}var N=t._trim(n[1]);var O=m[p];switch(E.keysType[p]){case"Edm.String":N=N.replace(/^\'|\'$/g,'');break;case"Edm.Time":case"Edm.DateTime":O=t._getDateTime(O);break;case"Edm.Int16":case"Edm.Int32":case"Edm.Decimal":case"Edm.Byte":case"Edm.Double":case"Edm.Single":case"Edm.SByte":if(!t._isValidNumber(N)){return false;}N=parseFloat(N);break;case"Edm.Guid":N=N.replace(/^guid\'|\'$/g,'');break;case"Edm.Boolean":if(["true","false"].indexOf(N)===-1){t._logAndThrowMockServerCustomError(400,t._oErrorMessages.INVALID_KEY_TYPE,p);}N=N==="true";break;case"Edm.Binary":case"Edm.DateTimeOffset":default:N=N;}if(O!==N){return true;}}F={index:I,entry:m};return false;});return F;};var r=function(e,k,u){var S=e.name;var n;if(u){n=e.navprops[u];}if(n){S=n.to.entitySet;}return S;};var c=function(u){var U=[];var S=function(V){var j=V.indexOf("'");var n=V.indexOf("\"");if(j===-1&&n===-1){return null;}else{if(j>-1&&n===-1){return"appost";}if(n>-1&&j===-1){return"doublequotes";}if(j>-1&&n>-1&&j<n){return"appost";}if(j>-1&&n>-1&&n<j){return"doublequotes";}}};var e=function(p,P,n,w){var x=p[n];var j=n+1;while(j<p.length&&p[j].indexOf(w)===-1){x=x+"&"+p[j];j++;}x=x+"&"+p[j];P.push(x);n=j;return n;};for(var i=0;i<u.length;i++){if(!S(u[i])){U.push(u[i]);}if(S(u[i])==="appost"){var k=u[i].indexOf("'");if(u[i].indexOf("'",k+1)===-1){i=e(u,U,i,"'");}else{U.push(u[i]);}}if(S(u[i])==="doublequotes"){var m=u[i].indexOf("\"");if(u[i].indexOf("\"",m+1)===-1){i=e(u,U,i,"\"");}else{U.push(u[i]);}}}return U;};var l=function(x,T,k,u){k=k?decodeURIComponent(k):k;var e=JSON.parse(x.requestBody);if(e){var K={};if(k){K=t._parseKeys(k,t._mEntitySets[T]);}t._completeKey(t._mEntitySets[T],K,e);t._enhanceWithMetadata(t._mEntitySets[T],[e]);return e;}return null;};var R=[];R.push({method:"GET",path:new RegExp("\\$metadata([?#].*)?"),response:function(x){sap.ui.requireSync("jquery.sap.xml");L.debug("MockServer: incoming request for url: "+x.url);var m={"Content-Type":"application/xml;charset=utf-8"};H(x,m);x.respond(200,m,t._sMetadata);L.debug("MockServer: response sent with: 200, "+t._sMetadata);return true;}});R.push({method:"HEAD",path:new RegExp("$"),response:function(x){L.debug("MockServer: incoming request for url: "+x.url);var m={"Content-Type":"application/json;charset=utf-8"};H(x,m);x.respond(200,m);L.debug("MockServer: response sent with: 200");return true;}});R.push({method:"GET",path:new RegExp("$"),response:function(x){L.debug("MockServer: incoming request for url: "+x.url);var m={"Content-Type":"application/json;charset=utf-8"};H(x,m);var e=[];q.each(t._mEntitySets,function(E,j){e.push(E);});var i={EntitySets:e};x.respond(200,m,JSON.stringify({d:i}));L.debug("MockServer: response sent with: 200, "+JSON.stringify({d:i}));return true;}});R.push({method:"POST",path:new RegExp("\\$batch([?#].*)?"),response:function(x){L.debug("MockServer: incoming request for url: "+x.url);var e=function(c1){switch(c1.statusCode){case 200:return"200 OK";case 201:return"201 Created";case 204:return"204 No Content";case 400:return"400 Bad Request";case 401:return"401 Unauthorized";case 403:return"403 Forbidden";case 404:return"404 Not Found";case 405:return"405 Method Not Allowed";case 409:return"409 Conflict";case 412:return"412 Precondition Failed";case 415:return"415 Unsupported Media Type";case 500:return"500 Internal Server Error";case 501:return"501 Not Implemented";case 503:return"503 Service Unavailable";default:return c1.statusCode+" "+c1.status;}};var B=function(c1,d1){var e1;if(c1.success){e1=JSON.stringify(c1.data)||"";}else{e1=c1.errorResponse;}d1=d1||"application/json";if(c1.responseHeaders){return"HTTP/1.1 "+e(c1)+"\r\n"+c1.responseHeaders+"dataserviceversion: 2.0\r\n\r\n"+e1+"\r\n";}else{return"HTTP/1.1 "+e(c1)+"\r\nContent-Type: "+d1+"\r\nContent-Length: "+e1.length+"\r\ndataserviceversion: 2.0\r\n\r\n"+e1+"\r\n";}};var C=function(c1,W,d1,Q,X){var e1;var f1=function(h1,i1,j1){e1={success:true,data:h1,status:i1,statusCode:j1&&j1.status,responseHeaders:j1&&j1.getAllResponseHeaders()};};var g1=function(h1,i1,j1){e1={success:false,data:undefined,status:i1,error:j1,statusCode:h1.status,errorResponse:h1.responseText,responseHeaders:h1&&h1.getAllResponseHeaders()};};q.ajax({type:d1,async:false,url:c1,headers:X,data:W,dataType:"json",success:f1,error:g1});if(e1.statusCode===400||e1.statusCode===404){var a1=B(e1);throw new Error(a1);}Q.push(B(e1));};var n=function(c1,z){var d1;var e1;var f1=function(h1,i1,j1){d1={success:true,data:h1,status:i1,statusCode:j1&&j1.status,responseHeaders:j1&&j1.getAllResponseHeaders()};};var g1=function(h1,i1,j1){d1={success:false,data:undefined,status:i1,error:j1,statusCode:h1.status,errorResponse:h1.responseText,responseHeaders:h1&&h1.getAllResponseHeaders()};};q.ajax({async:false,url:c1,dataType:"json",success:f1,error:g1});var e1;if(c1.indexOf('$count')!==-1){e1=B(d1,"text/plain");}else{e1=B(d1);}z.push("\r\nContent-Type: application/http\r\n"+"Content-Length: "+e1.length+"\r\n"+"content-transfer-encoding: binary\r\n\r\n"+e1);};var p=function(V){var X={};V.split("HTTP/1.1")[1].split("{")[0].split("\n").forEach(function(c1){if(c1.indexOf(":")!==-1){var d1=c1.split(":");X[d1[0].trim()]=d1[1].trim();}});delete X["Content-Length"];return X;};var u=x.requestBody;var w=new RegExp("--batch_[a-z0-9-]*");var y=w.exec(u)[0];if(!!y){var z=[];var E=u.split(y);var S=x.url.split("$")[0];var F=new RegExp("PUT (.*) HTTP");var I=new RegExp("MERGE (.*) HTTP");var J=new RegExp("POST (.*) HTTP");var K=new RegExp("DELETE (.*) HTTP");var N=new RegExp("GET (.*) HTTP");for(var i=1;i<E.length-1;i++){var O=E[i];if(N.test(O)&&O.indexOf("multipart/mixed")===-1){if(F.test(O)||J.test(O)||K.test(O)){x.respond(400,null,"The Data Services Request could not be understood due to malformed syntax");L.debug("MockServer: response sent with: 400");return true;}n(S+N.exec(O)[1],z);}else{var P=q.extend(true,{},t._oMockdata);var Q=[];var T=O.substring(O.indexOf("boundary=")+9,O.indexOf("\r\n\r\n"));var U=O.split("--"+T);try{for(var j=1;j<U.length-1;j++){var V=U[j];var W;if(N.test(V)){t._oMockdata=P;x.respond(400,null,"The Data Services Request could not be understood due to malformed syntax");L.debug("MockServer: response sent with: 400");return;}else{var W=V.substring(V.indexOf("{"),V.lastIndexOf("}")+1),X=p(V),Y,Z;if(F.test(V)){Z="PUT";Y=F.exec(V)[1];}else if(I.test(V)){Z="MERGE";Y=I.exec(V)[1];}else if(J.test(V)){Z="POST";Y=J.exec(V)[1];}else if(K.test(V)){Z="DELETE";W=undefined;Y=K.exec(V)[1];}C(S+Y,W,Z,Q,X);}}var $="\r\nContent-Type: multipart/mixed; boundary=ejjeeffe1\r\n\r\n--ejjeeffe1";for(var k=0;k<Q.length;k++){$+="\r\nContent-Type: application/http\r\n"+"Content-Length: "+Q[k].length+"\r\n"+"content-transfer-encoding: binary\r\n\r\n"+Q[k]+"--ejjeeffe1";}$+="--\r\n";z.push($);}catch(_){t._oMockdata=P;var a1="\r\nContent-Type: application/http\r\n"+"Content-Length: "+_.message.length+"\r\n"+"content-transfer-encoding: binary\r\n\r\n"+_.message;z.push(a1);}}}var b1="--ejjeeffe0";for(var m=0;m<z.length;m++){b1+=z[m]+"--ejjeeffe0";}b1+="--";var X={'Content-Type':"multipart/mixed; boundary=ejjeeffe0"};H(x,X);x.respond(202,X,b1);L.debug("MockServer: response sent with: 202, "+b1);}else{x.respond(202);}return true;}});q.each(this._mEntitySets,function(E,i){R.push({method:"GET",path:new RegExp("("+E+")/\\$count/?(.*)?"),response:function(x,E,u){L.debug("MockServer: incoming request for url: "+x.url);t.fireEvent(g.HTTPMETHOD.GET+E+":before",{oXhr:x,sUrlParams:u});t.fireEvent(g.HTTPMETHOD.GET+":before",{oXhr:x,sUrlParams:u});var m={"Content-Type":"text/plain;charset=utf-8"};H(x,m);try{var j=t._oMockdata[E];if(j){var F={results:q.extend(true,[],j)};if(u){var U=decodeURIComponent(u).replace("?","&").split("&");U=c(U);if(U.length>1){U=t._orderQueryOptions(U);}q.each(U,function(I,Q){t._applyQueryOnCollection(F,Q,E,U);});}t.fireEvent(g.HTTPMETHOD.GET+E+":after",{oXhr:x,oFilteredData:F});t.fireEvent(g.HTTPMETHOD.GET+":after",{oXhr:x,oFilteredData:F});x.respond(200,m,""+F.results.length);L.debug("MockServer: response sent with: 200, "+F.results.length);}else{t._logAndThrowMockServerCustomError(404,t._oErrorMessages.RESOURCE_NOT_FOUND);}}catch(e){if(e.error){x.respond(e.error.code,m,JSON.stringify(e));}else{L.error("MockServer: request failed due to invalid system query options value!");x.respond(parseInt(e.message||e.number));}}return true;}});R.push({method:"GET",path:new RegExp("("+E+")/?(\\?(.*))?"),response:function(x,E,u){L.debug("MockServer: incoming request for url: "+x.url);t.fireEvent(g.HTTPMETHOD.GET+E+":before",{oXhr:x,sUrlParams:u});t.fireEvent(g.HTTPMETHOD.GET+":before",{oXhr:x,sUrlParams:u});var m={"Content-Type":"application/json;charset=utf-8"};H(x,m);try{var j=t._oMockdata[E];if(j){var F={results:q.extend(true,[],j)};if(u){var U=decodeURIComponent(u).replace("?","&").split("&");U=c(U);if(U.length>1){U=t._orderQueryOptions(U);}q.each(U,function(I,Q){t._applyQueryOnCollection(F,Q,E,U);});}t.fireEvent(g.HTTPMETHOD.GET+E+":after",{oXhr:x,oFilteredData:F});t.fireEvent(g.HTTPMETHOD.GET+":after",{oXhr:x,oFilteredData:F});x.respond(200,m,JSON.stringify({d:F}));L.debug("MockServer: response sent with: 200, "+JSON.stringify({d:F}));}else{t._logAndThrowMockServerCustomError(404,t._oErrorMessages.RESOURCE_NOT_FOUND);}}catch(e){if(e.error){x.respond(e.error.code,m,JSON.stringify(e));}else{L.debug("MockServer: response sent with: "+parseInt(e.message||e.number));x.respond(parseInt(e.message||e.number));}}return true;}});R.push({method:"GET",path:new RegExp("("+E+")\\(([^/\\?#]+)\\)/?(\\?(.*))?"),response:function(x,E,k,u){L.debug("MockServer: incoming request for url: "+x.url);t.fireEvent(g.HTTPMETHOD.GET+E+":before",{oXhr:x,sKeys:k,sUrlParams:u});t.fireEvent(g.HTTPMETHOD.GET+":before",{oXhr:x,sKeys:k,sUrlParams:u});var m={"Content-Type":"application/json;charset=utf-8"};try{var j=q.extend(true,{},G(E,k));if(!f(j)){if(u){var U=decodeURIComponent(u).replace("?","&").split("&");U=c(U);if(U.length>1){U=t._orderQueryOptions(U);}q.each(U,function(I,Q){j.entry=t._applyQueryOnEntry(j.entry,Q,E);});}t.fireEvent(g.HTTPMETHOD.GET+E+":after",{oXhr:x,oEntry:j.entry});t.fireEvent(g.HTTPMETHOD.GET+":after",{oXhr:x,oEntry:j.entry});x.respond(200,m,JSON.stringify({d:j.entry}));L.debug("MockServer: response sent with: 200, "+JSON.stringify({d:j.entry}));}else{t._logAndThrowMockServerCustomError(404,t._oErrorMessages.RESOURCE_NOT_FOUND);}}catch(e){if(e.error){x.respond(e.error.code,m,JSON.stringify(e));}else{L.debug("MockServer: response sent with: "+parseInt(e.message||e.number));x.respond(parseInt(e.message||e.number));}}return true;}});q.each(i.navprops,function(n,N){R.push({method:"GET",path:new RegExp("("+E+")\\(([^/\\?#]+)\\)/("+n+")/\\$count/?(.*)?"),response:function(x,E,k,j,u){L.debug("MockServer: incoming request for url: "+x.url);t.fireEvent(g.HTTPMETHOD.GET+E+":before",{oXhr:x,sKeys:k,sNavProp:j,sUrlParams:u});t.fireEvent(g.HTTPMETHOD.GET+":before",{oXhr:x,sKeys:k,sNavProp:j,sUrlParams:u});var m={"Content-Type":"text/plain;charset=utf-8"};H(x,m);try{var p=G(E,k);if(p){var w,F={};w=t._resolveNavigation(E,p.entry,j);var y=t._mEntitySets[E].navprops[j].to.multiplicity;if(y==="*"){F={results:q.extend(true,[],w)};}else{F=q.extend(true,{},w[0]);}if(w&&w.length!==0){if(u){var U=decodeURIComponent(u).replace("?","&").split("&");U=c(U);if(U.length>1){U=t._orderQueryOptions(U);}if(y==="*"){q.each(U,function(I,Q){t._applyQueryOnCollection(F,Q,t._mEntitySets[E].navprops[j].to.entitySet,U);});}else{q.each(U,function(I,Q){F=t._applyQueryOnEntry(F,Q,t._mEntitySets[E].navprops[j].to.entitySet);});}}}t.fireEvent(g.HTTPMETHOD.GET+E+":after",{oXhr:x,oFilteredData:F});t.fireEvent(g.HTTPMETHOD.GET+":after",{oXhr:x,oFilteredData:F});F.results=F.results||[];x.respond(200,m,""+F.results.length);L.debug("MockServer: response sent with: 200, "+F.results.length);}else{t._logAndThrowMockServerCustomError(404,t._oErrorMessages.RESOURCE_NOT_FOUND);}}catch(e){if(e.error){x.respond(e.error.code,m,JSON.stringify(e));}else{L.debug("MockServer: response sent with: "+parseInt(e.message||e.number));x.respond(parseInt(e.message||e.number));}}return true;}});R.push({method:"GET",path:new RegExp("("+E+")\\(([^/\\?#]+)\\)/("+n+")/?(\\?(.*))?"),response:function(x,E,k,j,u){L.debug("MockServer: incoming request for url: "+x.url);t.fireEvent(g.HTTPMETHOD.GET+E+":before",{oXhr:x,sKeys:k,sNavProp:j,sUrlParams:u});t.fireEvent(g.HTTPMETHOD.GET+":before",{oXhr:x,sKeys:k,sNavProp:j,sUrlParams:u});var m={"Content-Type":"application/json;charset=utf-8"};H(x,m);try{var p=G(E,k);if(p){var w,F={};w=t._resolveNavigation(E,p.entry,j,p.entry);var y=t._mEntitySets[E].navprops[j].to.multiplicity;if(y==="*"){F={results:q.extend(true,[],w)};}else{F=q.extend(true,{},w[0]);}if(w&&w.length!==0){if(u){var U=decodeURIComponent(u).replace("?","&").split("&");U=c(U);if(U.length>1){U=t._orderQueryOptions(U);}if(y==="*"){q.each(U,function(I,Q){t._applyQueryOnCollection(F,Q,t._mEntitySets[E].navprops[j].to.entitySet,U);});}else{q.each(U,function(I,Q){F=t._applyQueryOnEntry(F,Q,t._mEntitySets[E].navprops[j].to.entitySet);});}}}t.fireEvent(g.HTTPMETHOD.GET+E+":after",{oXhr:x,oFilteredData:F});t.fireEvent(g.HTTPMETHOD.GET+":after",{oXhr:x,oFilteredData:F});x.respond(200,m,JSON.stringify({d:F}));L.debug("MockServer: response sent with: 200, "+JSON.stringify({d:F}));}else{t._logAndThrowMockServerCustomError(404,t._oErrorMessages.RESOURCE_NOT_FOUND);}}catch(e){if(e.error){x.respond(e.error.code,m,JSON.stringify(e));}else{x.respond(parseInt(e.message||e.number));L.debug("MockServer: response sent with: "+parseInt(e.message||e.number));}}return true;}});});R.push({method:"POST",path:new RegExp("("+E+")(\\(([^/\\?#]+)\\)/?(.*)?)?"),response:function(x,E,j,k,n){var m=false;if(x.requestHeaders["x-http-method"]==="MERGE"){m=true;}L.debug("MockServer: incoming create request for url: "+x.url);t.fireEvent(g.HTTPMETHOD.POST+E+":before",{oXhr:x,sKeys:k,sNavName:n});t.fireEvent(g.HTTPMETHOD.POST+":before",{oXhr:x,sKeys:k,sNavName:n});var p=null;var u=null;var w=405;try{if(k&&!k.split('=')[1]){k=t._mEntitySets[E].keys[0]+"="+k;}var T=r(i,decodeURIComponent(k),n);if(T){var y=l(x,T,k,n);if(y){u={"Content-Type":"application/json;charset=utf-8"};t.fireEvent(g.HTTPMETHOD.POST+E+":after",{oXhr:x,oEntity:y});t.fireEvent(g.HTTPMETHOD.POST+":after",{oXhr:x,oEntity:y});if(m){var z=G(E,k);if(z){q.extend(t._oMockdata[E][z.index],y);}w=204;}else{var U=t._getRootUri()+T+"("+t._createKeysString(t._mEntitySets[T],y)+")";p=JSON.stringify({d:y,uri:U});t._oMockdata[T]=t._oMockdata[T].concat([y]);w=201;}}}x.respond(w,u,p);L.debug("MockServer: response sent with: "+w+", "+p);}catch(e){if(e.error){var B={"Content-Type":"text/plain;charset=utf-8"};x.respond(e.error.code,B,JSON.stringify(e));}else{x.respond(parseInt(e.message||e.number));L.debug("MockServer: response sent with: "+parseInt(e.message||e.number));}}return true;}});R.push({method:"PUT",path:new RegExp("("+E+")\\(([^/\\?#]+)\\)/?(.*)?"),response:function(x,E,k,n){L.debug("MockServer: incoming update request for url: "+x.url);t.fireEvent(g.HTTPMETHOD.PUT+E+":before",{oXhr:x,sKeys:k,sNavName:n});t.fireEvent(g.HTTPMETHOD.PUT+":before",{oXhr:x,sKeys:k,sNavName:n});var j=405;var m=null;var p=null;try{var T=r(i,decodeURIComponent(k),n);if(T){var u=l(x,T,k,n);if(u){p={"Content-Type":"application/json;charset=utf-8"};t.fireEvent(g.HTTPMETHOD.PUT+E+":after",{oXhr:x,oEntity:u});t.fireEvent(g.HTTPMETHOD.PUT+":after",{oXhr:x,oEntity:u});var w=G(E,k);if(w){t._oMockdata[E][w.index]=u;}j=204;}}x.respond(j,p,m);L.debug("MockServer: response sent with: "+j+", "+m);}catch(e){if(e.error){var y={"Content-Type":"text/plain;charset=utf-8"};x.respond(e.error.code,y,JSON.stringify(e));}else{x.respond(parseInt(e.message||e.number));L.debug("MockServer: response sent with: "+parseInt(e.message||e.number));}}return true;}});R.push({method:"MERGE",path:new RegExp("("+E+")\\(([^/\\?#]+)\\)/?(.*)?"),response:function(x,E,k,n){L.debug("MockServer: incoming merge update request for url: "+x.url);t.fireEvent(g.HTTPMETHOD.MERGE+E+":before",{oXhr:x,sKeys:k,sNavName:n});t.fireEvent(g.HTTPMETHOD.MERGE+":before",{oXhr:x,sKeys:k,sNavName:n});var j=405;var m=null;var p=null;try{var T=r(i,decodeURIComponent(k),n);if(T){var u=l(x,T,k,n);if(u){p={"Content-Type":"application/json;charset=utf-8"};t.fireEvent(g.HTTPMETHOD.MERGE+E+":after",{oXhr:x,oEntity:u});t.fireEvent(g.HTTPMETHOD.MERGE+":after",{oXhr:x,oEntity:u});var w=G(E,k);if(w){q.extend(t._oMockdata[E][w.index],u);}j=204;}}x.respond(j,p,m);L.debug("MockServer: response sent with: "+j+", "+m);}catch(e){if(e.error){var y={"Content-Type":"text/plain;charset=utf-8"};x.respond(e.error.code,y,JSON.stringify(e));}else{x.respond(parseInt(e.message||e.number));L.debug("MockServer: response sent with: "+parseInt(e.message||e.number));}}return true;}});R.push({method:"PATCH",path:new RegExp("("+E+")\\(([^/\\?#]+)\\)/?(.*)?"),response:function(x,E,k,n){L.debug("MockServer: incoming patch update request for url: "+x.url);t.fireEvent(g.HTTPMETHOD.PATCH+E+":before",{oXhr:x,sKeys:k,sNavName:n});t.fireEvent(g.HTTPMETHOD.PATCH+":before",{oXhr:x,sKeys:k,sNavName:n});var j=405;var m=null;var p=null;try{var T=r(i,decodeURIComponent(k),n);if(T){var u=l(x,T,k,n);if(u){p={"Content-Type":"application/json;charset=utf-8"};t.fireEvent(g.HTTPMETHOD.PATCH+E+":after",{oXhr:x,oEntity:u});t.fireEvent(g.HTTPMETHOD.PATCH+":after",{oXhr:x,oEntity:u});var w=G(E,k);if(w){q.extend(t._oMockdata[E][w.index],u);}j=204;}}x.respond(j,p,m);L.debug("MockServer: response sent with: "+j+", "+m);}catch(e){if(e.error){var y={"Content-Type":"text/plain;charset=utf-8"};x.respond(e.error.code,y,JSON.stringify(e));}else{x.respond(parseInt(e.message||e.number));L.debug("MockServer: response sent with: "+parseInt(e.message||e.number));}}return true;}});R.push({method:"DELETE",path:new RegExp("("+E+")\\(([^/\\?#]+)\\)/?(.*)?"),response:function(x,E,k,u){L.debug("MockServer: incoming delete request for url: "+x.url);t.fireEvent(g.HTTPMETHOD.DELETE+E+":before",{oXhr:x});t.fireEvent(g.HTTPMETHOD.DELETE+":before",{oXhr:x});var j=204;try{var m=G(E,k);if(m){t._oMockdata[E].splice(m.index,1);}else{j=400;}t.fireEvent(g.HTTPMETHOD.DELETE+E+":after",{oXhr:x});t.fireEvent(g.HTTPMETHOD.DELETE+":after",{oXhr:x});x.respond(j,null,null);L.debug("MockServer: response sent with: "+j);}catch(e){if(e.error){var n={"Content-Type":"text/plain;charset=utf-8"};x.respond(e.error.code,n,JSON.stringify(e));}else{x.respond(parseInt(e.message||e.number));L.debug("MockServer: response sent with: "+parseInt(e.message||e.number));}}return true;}});});this.setRequests(R);};g.prototype._orderQueryOptions=function(u){var F,i,s,t,o,S,e,a,b,c,O=[];var j=this;q.each(u,function(I,Q){var k=u.indexOf(Q);switch(Q.split('=')[0]){case"$top":t=k;break;case"$skip":s=k;break;case"$orderby":o=k;break;case"$expand":e=k;break;case"$filter":F=k;break;case"$select":S=k;break;case"$inlinecount":i=k;break;case"$format":a=k;break;case"search-focus":c=k;break;case"search":b=k;break;default:if(Q.split('=')[0].indexOf('$')===0){j._logAndThrowMockServerCustomError(400,j._oErrorMessages.IS_NOT_A_VALID_SYSTEM_QUERY_OPTION,Q.split('=')[0]);}}});if(e>=0){O.push(u[e]);}if(F>=0){O.push(u[F]);}if(c>=0){O.push(u[c]);}if(b>=0){O.push(u[b]);}if(i>=0){O.push(u[i]);}if(o>=0){O.push(u[o]);}if(s>=0){O.push(u[s]);}if(t>=0){O.push(u[t]);}if(S>=0){O.push(u[S]);}if(a>=0){O.push(u[a]);}return O;};g.prototype._removeAllRequestHandlers=function(){var r=this.getRequests();var l=r.length;for(var i=0;i<l;i++){g._removeResponse(r[i].response);}};g.prototype._removeAllFilters=function(){for(var i=0;i<this._aFilters.length;i++){g._removeFilter(this._aFilters[i]);}this._aFilters=null;};g.prototype._addRequestHandler=function(m,p,r){m=m?m.toUpperCase():m;if(typeof m!=="string"){throw new Error("Error in request configuration: value of 'method' has to be a string");}if(!(typeof p==="string"||p instanceof RegExp)){throw new Error("Error in request configuration: value of 'path' has to be a string or a regular expression");}if(typeof r!=="function"){throw new Error("Error in request configuration: value of 'response' has to be a function");}var u=this._getRootUri();u=u&&new RegExp(this._escapeStringForRegExp(u));if(p&&!(p instanceof RegExp)){p=new RegExp(this._createRegExpPattern(p));}var R=this._createRegExp(u?u.source+p.source:p.source);this._addFilter(this._createFilter(m,R));this._oServer.respondWith(m,R,r);L.debug("MockServer: adding "+m+" request handler for pattern "+R);};g.prototype._createRegExp=function(p){return new RegExp("^"+p+"$");};g.prototype._createRegExpPattern=function(p){return p.replace(/:([\w\d]+)/g,"([^\/]+)");};g.prototype._escapeStringForRegExp=function(s){return s.replace(/[\\\/\[\]\{\}\(\)\-\*\+\?\.\^\$\|]/g,"\\$&");};g.prototype._trim=function(s){return s&&s.replace(/^\s+|\s+$/g,"");};g.prototype._isValidNumber=function(s){return!isNaN(parseFloat(s))&&isFinite(s);};g.prototype._getDateTime=function(s){if(!s){return;}return"datetime'"+new Date(Number(s.replace("/Date(",'').replace(")/",''))).toJSON().substring(0,19)+"'";};g.prototype._getJsonDate=function(S){if(!S){return;}var n=function(s){var a=q.map(s.slice(0,-5).split(/\D/),function(i){return parseInt(i)||0;});a[1]-=1;a=new Date(Date.UTC.apply(Date,a));var o=s.slice(-5);var b=parseInt(o)/100;if(o.slice(0,1)==="+"){b*=-1;}a.setHours(a.getHours()+b);return a.getTime();};if(S.indexOf("datetimeoffset")>-1){return"/Date("+n(S.substring("datetimeoffset'".length,S.length-1))+")/";}else{return"/Date("+n(S.substring("datetime'".length,S.length-1))+")/";}};g.prototype._addFilter=function(F){this._aFilters.push(F);g._addFilter(F);};g.prototype._createFilter=function(r,R){return function(m,u,a,U,p){return r===m&&R.test(u);};};g.prototype._logAndThrowMockServerCustomError=function(e,E,p){if(E.indexOf('##')>-1&&p){E=E.replace("##","'"+p+"'");}L.error("MockServer: "+E);throw{error:{code:e,message:{lang:"en",value:E}}};};g.prototype.destroy=function(s){M.prototype.destroy.apply(this,arguments);this.stop();var S=g._aServers;var i=S.indexOf(this);S.splice(i,1);};g._aFilters=[];g._oServer=null;g._aServers=[];g._getInstance=function(){if(!this._oServer){this._oServer=window.sinon.fakeServer.create();this._oServer.autoRespond=true;}return this._oServer;};g.config=function(c){var s=this._getInstance();s.autoRespond=c.autoRespond===false?false:true;s.autoRespondAfter=c.autoRespondAfter||0;s.fakeHTTPMethods=c.fakeHTTPMethods||false;};g.respond=function(){this._getInstance().respond();};g.startAll=function(){for(var i=0;i<this._aServers.length;i++){this._aServers[i].start();}};g.stopAll=function(){for(var i=0;i<this._aServers.length;i++){this._aServers[i].stop();}this._getInstance().restore();this._oServer=null;};g.destroyAll=function(){this.stopAll();for(var i=0;i<this._aServers.length;i++){this._aServers[i].destroy();}};g.HTTPMETHOD={GET:"GET",POST:"POST",DELETE:"DELETE",PUT:"PUT",MERGE:"MERGE",PATCH:"PATCH"};g._addFilter=function(F){this._aFilters.push(F);};g._removeFilter=function(F){this._aFilters.splice(this._aFilters.indexOf(F),1);};g._removeResponse=function(r){var R=this._oServer.responses;var l=R.length;for(var i=0;i<l;i++){if(R[i].response===r){R.splice(i,1);return true;}}return false;};window.sinon.FakeXMLHttpRequest.useFilters=true;window.sinon.FakeXMLHttpRequest.addFilter(function(m,u,a,U,p){var F=g._aFilters;for(var i=0;i<F.length;i++){var b=F[i];if(b(m,u,a,U,p)){return false;}}return true;});var h=function(F){if(/.*\.json$/i.test(F)){return"JSON";}if(/.*\.xml$/i.test(F)){return"XML";}if(/.*metadata$/i.test(F)){return"XML";}return null;};window.sinon.FakeXMLHttpRequest.prototype.respondFile=function(s,H,F){var r=q.sap.sjax({url:F,dataType:"text"});if(!r.success){throw new Error("Could not load file from: "+F);}var o=r.data;var m=h(F);if(this["respond"+m]){this["respond"+m](s,H,o);}else{this.respond(s,H,o);}};window.sinon.FakeXMLHttpRequest.prototype.respondJSON=function(s,H,j){H=H||{};H["Content-Type"]=H["Content-Type"]||"application/json";this.respond(s,H,typeof j==="string"?j:JSON.stringify(j));};window.sinon.FakeXMLHttpRequest.prototype.respondXML=function(s,H,x){H=H||{};H["Content-Type"]=H["Content-Type"]||"application/xml";this.respond(s,H,x);};return g;});
