/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Control','sap/m/Button','sap/m/SearchField','sap/m/library','sap/ui/core/Core',"sap/ui/model/json/JSONModel"],function(C,B,S,m,a,J){"use strict";var b=C.extend("sap.ui.documentation.Search",{metadata:{library:"sap.ui.documentation",properties:{isOpen:{type:"boolean",group:"Appearance",defaultValue:false},width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null}},aggregations:{_openingButton:{type:"sap.m.Button",multiple:false},_closingButton:{type:"sap.m.Button",multiple:false},_searchField:{type:"sap.m.SearchField",multiple:false},suggestionItems:{type:"sap.m.SuggestionItem",multiple:true,singularName:"suggestionItem",forwarding:{getter:"_lazyLoadSearchField",aggregation:"suggestionItems"}}},events:{toggle:{isOpen:{type:"boolean"}},search:{parameters:{query:{type:"string"},suggestionItem:{type:"sap.m.SuggestionItem"},refreshButtonPressed:{type:"boolean"},clearButtonPressed:{type:"boolean"}}},suggest:{parameters:{suggestValue:{type:"string"}}}}},renderer:{apiVersion:2,render:function(r,c){var w=c.getWidth(),o,d,s;r.openStart("div",c);r.style("width",w);r.class("sapUiDocumentationSearch");r.openEnd();if(c.getIsOpen()){s=c._lazyLoadSearchField(true);d=c._lazyLoadClosingButton(true);r.renderControl(s);r.renderControl(d);}else{o=c._lazyLoadOpeningButton(true);r.renderControl(o);}r.close("div");}}});b.prototype.onAfterRendering=function(){if(this.getIsOpen()){this._maximizeSearchField();}};b.prototype._maximizeSearchField=function(){return this._resizeSearchField("100%");};b.prototype._minimizeSearchField=function(){return this._resizeSearchField("10%");};b.prototype.suggest=function(){this._lazyLoadSearchField().suggest();};b.prototype.attachSuggest=function(){S.prototype.attachSuggest.apply(this._lazyLoadSearchField(),arguments);return this;};b.prototype._resizeSearchField=function(w){return new Promise(function(r,c){var $=this.$("searchField");if(!$.length){c();}if($.css("max-width")===w){r();}$.one("webkitTransitionEnd otransitionend oTransitionEnd msTransitionEnd transitionend",function(){r();});$.css("max-width",w);}.bind(this));};b.prototype._toggleOpen=function(o){this.setIsOpen(o);this.fireToggle({isOpen:o});};b.prototype._lazyLoadOpeningButton=function(s){if(!this.getAggregation("_openingButton")){var o=new B(this.getId()+"-openingBtn",{icon:"sap-icon://search",type:m.ButtonType.Transparent,press:function(){this._toggleOpen(true);}.bind(this)});o.addStyleClass("sdkHeaderSearchButton");this.setAggregation("_openingButton",o,s);}return this.getAggregation("_openingButton");};b.prototype._lazyLoadClosingButton=function(s){if(!this.getAggregation("_closingButton")){var o=new B(this.getId()+"-closingBtn",{text:a.getLibraryResourceBundle("sap.ui.documentation").getText("APP_SEARCH_FIELD_CLOSE"),type:m.ButtonType.Transparent,press:function(){this._minimizeSearchField().then(function(){this._toggleOpen(false);}.bind(this));}.bind(this)});this.setAggregation("_closingButton",o,s);}return this.getAggregation("_closingButton");};b.prototype._lazyLoadSearchField=function(s){if(!this.getAggregation("_searchField")){var o=new S(this.getId()+"-searchField",{showSearchButton:true,enableSuggestions:true,search:function(e){var p=e.getParameters();p.id=this.getId();this.fireSearch(p);}.bind(this)});o.addStyleClass("sdkHeaderSearchField");this.setAggregation("_searchField",o,s);}return this.getAggregation("_searchField");};return b;});
