//@ui5-bundle sap/ui/documentation/library-preload.js
/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/documentation/BorrowedList',['sap/ui/core/Control'],function(C){"use strict";return C.extend("sap.ui.documentation.BorrowedList",{metadata:{library:"sap.ui.documentation",properties:{list:{type:"array"}}},renderer:{apiVersion:2,render:function(r,c){var l=c.getList(),I,L,i;r.openStart("div",c);r.openEnd();for(i=0,L=l.length;i<L;i++){I=l[i];r.openStart("a");r.attr("href",I.link).attr("role","link").attr("tabindex","0").class("sapMLnk").class("sapMLnkMaxWidth").class("sapUiTinyMargin").openEnd().text(I.name).close("a");}r.close("div");}}});});
sap.ui.predefine('sap/ui/documentation/DemokitTreeItem',["sap/m/TreeItemBase","./DemokitTreeItemRenderer"],function(T){"use strict";return T.extend("sap.ui.documentation.DemokitTreeItem",{metadata:{library:"sap.ui.documentation",properties:{title:{type:"string",defaultValue:""},deprecated:{type:"boolean",defaultValue:false},target:{type:"string",defaultValue:""},encodeTarget:{type:"boolean",defaultValue:false},section:{type:"string",defaultValue:"#"},entityType:{type:"string",defaultValue:""}}},setDeprecated:function(d){return this.setProperty("deprecated",!!d);},getHref:function(){return this.getSection()+'/'+(this.getEncodeTarget()?encodeURIComponent(this.getTarget()):this.getTarget());},_getPadding:T.prototype.getLevel});});
sap.ui.predefine('sap/ui/documentation/DemokitTreeItemRenderer',['sap/m/TreeItemBaseRenderer','sap/ui/core/Core','sap/ui/core/Renderer'],function(T,C,R){"use strict";var D=R.extend(T);D.apiVersion=2;
D.renderEntityType=function(r,c){var t=c.getEntityType(),s=t?t[0].toUpperCase():"";if(!t){return;}r.openStart('span').class("sapUiDemoKitTreeItemIcon").class("sapUiDemoKitTreeItem"+s).openEnd().text(s).close('span');};
D.renderTooltip=function(r,c){var t=c.getEntityType(),s=c.getTarget();if(t&&s){r.attr("title",t+" "+s);}};
D.renderLIContent=function(r,c){var o;this.renderEntityType(r,c);r.openStart('a').attr("href",c.getHref()).openEnd();r.openStart('span').class("sapDemokitTreeItemTitle").class("sapUiTinyMarginEnd").openEnd().text(c.getTitle()).close('span');r.close('a');if(c.getDeprecated()){o=C.getLibraryResourceBundle("sap.ui.documentation");r.openStart('span').class("sapDemokitTreeItemLabel").openEnd().text(o.getText("API_MASTER_DEPRECATED")).close('span');}};
return D;},true);
sap.ui.predefine('sap/ui/documentation/JSDocText',['sap/ui/core/Control',"sap/base/security/sanitizeHTML"],function(C,s){"use strict";return C.extend("sap.ui.documentation.JSDocText",{metadata:{library:"sap.ui.documentation",properties:{text:{type:"string",defaultValue:""},sanitizeContent:{type:"boolean",group:"Misc",defaultValue:true}}},renderer:{apiVersion:2,render:function(r,c){var t=c.getText();if(c.getSanitizeContent()){t=s(t);}r.openStart("div",c);r.class("sapUiJSD");r.openEnd();r.unsafeHtml(t);r.close("div");}}});});
sap.ui.predefine('sap/ui/documentation/LightTable',['sap/ui/core/Control'],function(C){"use strict";return C.extend("sap.ui.documentation.LightTable",{metadata:{library:"sap.ui.documentation",properties:{columnTitles:{type:"string[]"},columnCount:{type:"int"}},defaultAggregation:"rows",aggregations:{rows:{type:"sap.ui.documentation.Row",multiple:true}}},renderer:{apiVersion:2,render:function(r,c){var R=c.getRows(),b,d=c.getColumnTitles(),l,a,L,i;r.openStart("div",c);r.class("sapUiDocLightTable");r.class("columns-"+c.getColumnCount());r.openEnd();r.openStart("div").class("head").openEnd();for(i=0,L=d.length;i<L;i++){r.openStart("div").class("cell").openEnd();r.text(d[i]).close("div");}r.close("div");for(i=0,L=R.length;i<L;i++){r.openStart("div").class("row").openEnd();b=R[i].getContent();for(a=0,l=b.length;a<l;a++){r.openStart("div").class("cell").openEnd();if(a>0){r.openStart("div").class("inTitle").openEnd().text(d[a]+":").close("div");}r.renderControl(b[a]);r.close("div");}r.close("div");}r.close("div");}}});});
sap.ui.predefine('sap/ui/documentation/ObjectPageSubSection',['sap/ui/core/Control','sap/uxap/ObjectPageSubSection'],function(C,O){"use strict";
var S=O.extend("sap.ui.documentation.ObjectPageSubSection",{
metadata:{library:"sap.ui.documentation"},
renderer:"sap.uxap.ObjectPageSubSectionRenderer"
});
var a=C.extend("sap.ui.documentation.Container",{
metadata:{library:"sap.ui.documentation",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}}},
renderer:{apiVersion:2,render:function(r,c){var b=c.getContent(),l,i;r.openStart("div").openEnd();for(i=0,l=b.length;i<l;i++){r.renderControl(b[i]);}r.close("div");}}
});
S.prototype._getGrid=function(){if(!this.getAggregation("_grid")){this.setAggregation("_grid",new a({id:this.getId()+"-innerGrid"}),true);}return this.getAggregation("_grid");};
return S;});
sap.ui.predefine('sap/ui/documentation/ParamText',['sap/ui/core/Control','sap/ui/Device'],function(C,D){"use strict";
var P=C.extend("sap.ui.documentation.ParamText",{
metadata:{library:"sap.ui.documentation",properties:{text:{type:"string",defaultValue:""},phoneText:{type:"string",defaultValue:""},depth:{type:"int",defaultValue:0},optional:{type:"boolean",defaultValue:false},defaultFlag:{type:"boolean",defaultValue:false},deprecated:{type:"boolean",defaultValue:false},experimental:{type:"boolean",defaultValue:false},href:{type:"sap.ui.core.URI"}},events:{press:{}}},
_getText:function(){var p=this.getPhoneText();return D.system.phone&&p?p:this.getText();},
renderer:{apiVersion:2,render:function(r,c){var h=c.getHref();if(h){r.openStart("a",c).attr("href",h).class("sapMLnk");}else{r.openStart("div",c);}r.class("depth-"+c.getDepth()).class("sapUiParamText").openEnd();r.text(c._getText());if(c.getOptional()){r.text("?");}if(c.getDefaultFlag()){r.openStart("span").class("parameterDefault").openEnd().text("(default)").close("span");}if(h){r.close("a").openStart("div").class("sapUiParamText").openEnd();}if(c.getDeprecated()){r.openStart("div").class("deprecated").openEnd();r.icon('sap-icon://message-error');r.openStart("span").class("deprecatedText").openEnd().text("Deprecated").close("span");r.close("div");}if(c.getExperimental()){r.openStart("div").class("experimental").openEnd();r.icon('sap-icon://message-warning');r.openStart("span").class("experimentalText").openEnd().text("Experimental").close("span");r.close("div");}r.close("div");}}
});
P.prototype._handlePress=function(e){this.firePress({});};
if(D.support.touch){P.prototype.ontap=P.prototype._handlePress;}else{P.prototype.onclick=P.prototype._handlePress;}return P;});
sap.ui.predefine('sap/ui/documentation/Row',['sap/ui/core/Element'],function(E){"use strict";return E.extend("sap.ui.documentation.Row",{metadata:{library:"sap.ui.documentation",properties:{visible:{type:"boolean"}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true}}}});});
sap.ui.predefine('sap/ui/documentation/Search',['sap/ui/core/Control','sap/m/Button','sap/m/SearchField','sap/m/library','sap/ui/core/Core',"sap/ui/model/json/JSONModel"],function(C,B,S,m,a,J){"use strict";
var b=C.extend("sap.ui.documentation.Search",{
metadata:{library:"sap.ui.documentation",properties:{isOpen:{type:"boolean",group:"Appearance",defaultValue:false},width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null}},aggregations:{_openingButton:{type:"sap.m.Button",multiple:false},_closingButton:{type:"sap.m.Button",multiple:false},_searchField:{type:"sap.m.SearchField",multiple:false},suggestionItems:{type:"sap.m.SuggestionItem",multiple:true,singularName:"suggestionItem",forwarding:{getter:"_lazyLoadSearchField",aggregation:"suggestionItems"}}},events:{toggle:{isOpen:{type:"boolean"}},search:{parameters:{query:{type:"string"},suggestionItem:{type:"sap.m.SuggestionItem"},refreshButtonPressed:{type:"boolean"},clearButtonPressed:{type:"boolean"}}},suggest:{parameters:{suggestValue:{type:"string"}}}}},
renderer:{apiVersion:2,render:function(r,c){var w=c.getWidth(),o,d,s;r.openStart("div",c);r.style("width",w);r.class("sapUiDocumentationSearch");r.openEnd();if(c.getIsOpen()){s=c._lazyLoadSearchField(true);d=c._lazyLoadClosingButton(true);r.renderControl(s);r.renderControl(d);}else{o=c._lazyLoadOpeningButton(true);r.renderControl(o);}r.close("div");}}
});
b.prototype.onAfterRendering=function(){if(this.getIsOpen()){this._maximizeSearchField();}};
b.prototype._maximizeSearchField=function(){return this._resizeSearchField("100%");};
b.prototype._minimizeSearchField=function(){return this._resizeSearchField("10%");};
b.prototype.suggest=function(){this._lazyLoadSearchField().suggest();};
b.prototype.attachSuggest=function(){S.prototype.attachSuggest.apply(this._lazyLoadSearchField(),arguments);return this;};
b.prototype._resizeSearchField=function(w){return new Promise(function(r,c){var $=this.$("searchField");if(!$.length){c();}if($.css("max-width")===w){r();}$.one("webkitTransitionEnd otransitionend oTransitionEnd msTransitionEnd transitionend",function(){r();});$.css("max-width",w);}.bind(this));};
b.prototype._toggleOpen=function(o){this.setIsOpen(o);this.fireToggle({isOpen:o});};
b.prototype._lazyLoadOpeningButton=function(s){if(!this.getAggregation("_openingButton")){var o=new B(this.getId()+"-openingBtn",{icon:"sap-icon://search",type:m.ButtonType.Transparent,press:function(){this._toggleOpen(true);}.bind(this)});o.addStyleClass("sdkHeaderSearchButton");this.setAggregation("_openingButton",o,s);}return this.getAggregation("_openingButton");};
b.prototype._lazyLoadClosingButton=function(s){if(!this.getAggregation("_closingButton")){var o=new B(this.getId()+"-closingBtn",{text:a.getLibraryResourceBundle("sap.ui.documentation").getText("APP_SEARCH_FIELD_CLOSE"),type:m.ButtonType.Transparent,press:function(){this._minimizeSearchField().then(function(){this._toggleOpen(false);}.bind(this));}.bind(this)});this.setAggregation("_closingButton",o,s);}return this.getAggregation("_closingButton");};
b.prototype._lazyLoadSearchField=function(s){if(!this.getAggregation("_searchField")){var o=new S(this.getId()+"-searchField",{showSearchButton:true,enableSuggestions:true,search:function(e){var p=e.getParameters();p.id=this.getId();this.fireSearch(p);}.bind(this)});o.addStyleClass("sdkHeaderSearchField");this.setAggregation("_searchField",o,s);}return this.getAggregation("_searchField");};
return b;});
sap.ui.predefine('sap/ui/documentation/TitleLink',['sap/ui/core/library','sap/ui/Device','sap/m/Toolbar','sap/m/Title'],function(c,D,T,a){"use strict";var b=c.TextAlign;var d=c.TitleLevel;
var e=a.extend("sap.ui.documentation.TitleLink",{
metadata:{library:"sap.ui.documentation",properties:{target:{type:"string",group:"Behavior",defaultValue:null},href:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},filter:{type:"string",group:"Data",defaultValue:""},wrap:{type:"boolean",group:"Behavior",defaultValue:true}},events:{press:{allowPreventDefault:true}}},
init:function(){if(D.support.touch){this.ontap=this._handlePress;}else{this.onclick=this._handlePress;}this.ontouchstart=function(E){if(this.getHref()){E.setMarked();}};},
onsapspace:function(E){this._handlePress(E);if(this.getHref()&&!E.isDefaultPrevented()){E.preventDefault();E.setMarked();var C=document.createEvent('MouseEvents');C.initEvent('click',false,true);this.getDomRef().dispatchEvent(C);}},
_handlePress:function(E){E.setMarked();if(!this.firePress()||!this.getHref()){E.preventDefault();}},
setHref:function(u){this.setProperty("href",u,true);u=this.getProperty("href");this.$().attr("href",u);return this;},
setTarget:function(t){this.setProperty("target",t,true);if(!t){this.$().removeAttr("target");}else{this.$().attr("target",t);}return this;},
renderer:{apiVersion:2,render:function(r,t){var A=t._getTitle(),l=(A?A.getLevel():t.getLevel())||c.TitleLevel.Auto,f=l==d.Auto,s=f?"div":l;r.openStart(s.toLowerCase(),t).class("sapUiDocTitleLink").class("sapMTitle").class("sapMTitleStyle"+(t.getTitleStyle()||c.TitleLevel.Auto)).class("sapUiSelectable");if(t.getWrap()){r.class("wrap");}else{r.class("sapMTitleNoWrap");}var w=t.getWidth();if(!w){r.class("sapMTitleMaxWidth");}else{r.style("width",w);}var g=t.getTextAlign();if(g&&g!=b.Initial){r.class("sapMTitleAlign"+g);}if(t.getParent().isA("sap.m.Toolbar")){r.class("sapMTitleTB");}var h=A?A.getTooltip_AsString():t.getTooltip_AsString();if(h){r.attr("title",h);}if(f){r.attr("role","heading");}r.openEnd();r.openStart("a").class("sapMLnk");if(t.getText()){r.attr("tabindex","0");}else{r.attr("tabindex","-1");}r.attr("href",t.getHref());if(t.getTarget()){r.attr("target",t.getTarget());}r.openEnd();r.openStart("span",t.getId()+"-inner").openEnd().text(A?A.getText():t.getText());r.close("span").close("a").close(s.toLowerCase());}}
});
return e;});
sap.ui.predefine('sap/ui/documentation/WebPageTitleUtil',['sap/ui/core/Element'],function(E){"use strict";
var W=E.extend("sap.ui.documentation.WebPageTitleUtil",{metadata:{properties:{title:{type:"string",defaultValue:''}}}});
W.prototype.setTitle=function(t){if(t){document.title=t;this.setProperty("title",t,true);}return this;};
return W;});
sap.ui.predefine('sap/ui/documentation/library',["sap/ui/thirdparty/jquery",'sap/ui/core/util/LibraryInfo',"sap/base/Log",'sap/ui/core/library','sap/m/library'],function(q,L,a){'use strict';sap.ui.getCore().initLibrary({name:'sap.ui.documentation',version:'1.84.0',dependencies:['sap.ui.core','sap.m'],types:[],interfaces:[],controls:["sap.ui.documentation.BorrowedList","sap.ui.documentation.DemokitTreeItem","sap.ui.documentation.JSDocText","sap.ui.documentation.LightTable","sap.ui.documentation.ObjectPageSubSection","sap.ui.documentation.ParamText","sap.ui.documentation.Search","sap.ui.documentation.TitleLink"],elements:["sap.ui.documentation.Row","sap.ui.documentation.WebPageTitleUtil"]});var t=sap.ui.documentation;var _;
t._getLicense=function(){var u="./LICENSE.txt";return q.ajax({url:u,dataType:"text"});};
t._getAppInfo=function(c){var u=sap.ui.resource("","sap-ui-version.json");q.ajax({url:u,dataType:"json",error:function(x,s,e){a.error("failed to load library list from '"+u+"': "+s+", "+e);c(null);},success:function(A,s,x){if(!A){a.error("failed to load library list from '"+u+"': "+s+", Data: "+A);c(null);return;}c(A);}});};
t._getLibraryInfoSingleton=function(){if(!_){_=new L();}return _;};
t._loadAllLibInfo=function(A,I,r,c){if(typeof r==="function"){c=r;r=undefined;}var l=t._getLibraryInfoSingleton();var f=I=="_getLibraryInfoAndReleaseNotes";if(f){I="_getLibraryInfo";}t._getAppInfo(function(o){if(!(o&&o.libraries)){c(null,null);return;}var b=0,d=o.libraries,e=d.length,g={},h={},j=[],k,m;for(var i=0;i<e;i++){k=d[i].name;m=d[i].version;j.push(k);h[k]=m;l[I](k,function(E){var D=function(){b++;if(b==e){c(j,g,o);}};g[E.library]=E;if(!g[E.library].version){g[E.library].version=h[E.library];}if(f){l._getReleaseNotes(E.library,r,function(R){g[E.library].relnotes=R;D();});}else{D();}});}});};
return t;});
sap.ui.predefine('sap/ui/documentation/sdk/Component',["sap/ui/thirdparty/jquery","sap/ui/core/UIComponent","sap/ui/Device","sap/ui/documentation/sdk/model/models","sap/ui/documentation/sdk/controller/ErrorHandler","sap/ui/model/json/JSONModel","sap/ui/documentation/sdk/controller/util/ConfigUtil","sap/base/util/Version","sap/ui/documentation/sdk/util/Resources","sap/base/Log","sap/ui/documentation/sdk/util/DocumentationRouter","sap/m/ColumnListItem"],function(q,U,D,m,E,J,C,V,R,L){"use strict";return U.extend("sap.ui.documentation.sdk.Component",{metadata:{manifest:"json",includes:["css/style.css"]},init:function(){this._oErrorHandler=new E(this);this.setModel(m.createDeviceModel(),"device");this.setModel(new J(),"libsData");this.setModel(new J(),"versionData");U.prototype.init.apply(this,arguments);this.loadVersionInfo();this.getRouter().initialize();},destroy:function(){this._oErrorHandler.destroy();this._oConfigUtil.destroy();this._oConfigUtil=null;U.prototype.destroy.apply(this,arguments);},getContentDensityClass:function(){if(this._sContentDensityClass===undefined){if(q(document.body).hasClass("sapUiSizeCozy")||q(document.body).hasClass("sapUiSizeCompact")){this._sContentDensityClass="";}this._sContentDensityClass="sapUiSizeCompact";}return this._sContentDensityClass;},getConfigUtil:function(){if(!this._oConfigUtil){this._oConfigUtil=new C(this);}return this._oConfigUtil;},loadVersionInfo:function(){if(!this._oVersionInfoPromise){var t=this;this._oVersionInfoPromise=new Promise(function(r,a){var u=R.getResourceOriginPath('./resources/sap-ui-version.json');q.ajax({url:u,dataType:"json",error:function(x,s,e){L.error("failed to load '"+u+"': "+s+", "+e);a(e);},success:function(d){t._bindVersionModel(d);r(d);}});});}return this._oVersionInfoPromise;},_bindVersionModel:function(v){var o,s,O,a,i;this.aAllowedMembers=["public","protected"];if(!v){return;}o=V(v.version);a=o.getSuffix();s=/-SNAPSHOT$/i.test(a);O=v.gav&&/openui5/i.test(v.gav);if(/internal/i.test(v.name)){i=true;this.aAllowedMembers.push("restricted");}this.getModel("versionData").setData({versionGav:v.gav,versionName:v.name,version:[o.getMajor(),o.getMinor(),o.getPatch()].join("."),fullVersion:v.version,openUi5Version:sap.ui.version,isOpenUI5:O,isSnapshotVersion:s,isDevVersion:s,isBetaVersion:!O&&!s&&/-beta$/i.test(a),isInternal:!!i,libraries:v.libraries,allowedMembers:this.aAllowedMembers});}});});
sap.ui.predefine('sap/ui/documentation/sdk/blocks/IndexEntry',['sap/uxap/BlockBase',"sap/ui/documentation/sdk/model/formatter"],function(B,f){"use strict";
var a=B.extend("sap.ui.documentation.sdk.blocks.IndexEntry",{
metadata:{views:{Collapsed:{viewName:"sap.ui.documentation.sdk.blocks.IndexEntry",type:"XML"},Expanded:{viewName:"sap.ui.documentation.sdk.blocks.IndexEntry",type:"XML"}}},
formatText:function(){return f.formatIndexByVersionEntry.apply(f,arguments);}
});
return a;});
sap.ui.predefine('sap/ui/documentation/sdk/controller/ApiDetail.controller',["sap/ui/documentation/sdk/controller/BaseController","sap/ui/model/json/JSONModel","sap/ui/core/CustomData","sap/ui/documentation/sdk/controller/util/ControlsInfo","sap/ui/documentation/sdk/util/ToggleFullScreenHandler","sap/ui/documentation/sdk/controller/util/APIInfo","sap/ui/documentation/sdk/model/formatter","sap/ui/core/mvc/XMLView","sap/ui/core/library","sap/base/Log"],function(B,J,C,c,T,A,f,X,d,L){"use strict";return B.extend("sap.ui.documentation.sdk.controller.ApiDetail",{NOT_AVAILABLE:'N/A',NOT_FOUND:'Not found',onInit:function(){this.getRouter().getRoute("apiSpecialRoute").attachPatternMatched(this._onTopicMatched,this);this._oModel=new J();this._oModel.setSizeLimit(10000);this._oContainerPage=this.getView().byId("apiDetailPageContainer");},_onTopicMatched:function(e){var a,o;a=this.getRouter()._decodeSpecialRouteArguments(e);o=this.getOwnerComponent();if(this._sTopicid===a.id){return;}this._sTopicid=a.id;this._sEntityType=a.entityType;this._sEntityId=a.entityId;if(this._oView&&!this._oView.bIsDestroyed){this._oView.destroy();this._oContainerPage.setBusy(true);}o.loadVersionInfo().then(function(){this._aAllowedMembers=this.getModel("versionData").getProperty("/allowedMembers");}.bind(this)).then(A.getIndexJsonPromise).then(this._processApiIndexAndLoadApiJson.bind(this)).then(this._findEntityInApiJsonData.bind(this)).then(this._addMissingNodesToControlData.bind(this)).then(this._buildBorrowedModel.bind(this)).then(this._createModelAndSubView.bind(this)).then(this._initSubView.bind(this)).catch(function(r){if(r===this.NOT_FOUND){this._oContainerPage.setBusy(false);this.getRouter().myNavToWithoutHash("sap.ui.documentation.sdk.view.NotFound","XML",false);}else if(typeof r==="string"){L.error(r);}else if(r.name){L.error(r.name,r.message);}else if(r.message){L.error(r.message);}}.bind(this));},_initSubView:function(v){var o=v.getController();if(v.data("topicid")!==this._sTopicid){v.destroy();return;}this._oView=v;this._oContainerPage.addContent(v);this._oContainerPage.setBusy(false);o.initiate({sTopicId:this._sTopicid,oModel:this._oModel,aApiIndex:this._aApiIndex,aAllowedMembers:this._aAllowedMembers,oEntityData:this._oEntityData,sEntityType:this._sEntityType,sEntityId:this._sEntityId,oOwnerComponent:this.getOwnerComponent(),oContainerView:this.getView(),oContainerController:this});},_createModelAndSubView:function(b){this._oControlData.borrowed=b;this._bindData(this._sTopicid);return X.create({height:"100%",customData:new C({key:"topicid",value:this._sTopicid}),viewName:"sap.ui.documentation.sdk.view.SubApiDetail",async:true,preprocessors:{xml:{models:{data:this._oModel}}}});},_buildBorrowedModel:function(o){this._oControlData=o;return this.buildBorrowedModel(o);},_addMissingNodesToControlData:function(o){var l,n,N,s,e;if(this._oEntityData.kind==="namespace"){e=Array.isArray(this._oEntityData.nodes)&&this._oEntityData.nodes;l=Array.isArray(o.nodes)&&o.nodes;if(e&&l&&e.length>l.length){l.sort(this._compareStringsCaseInsensitive);e.forEach(function(a,i){n=a.name;s=l[i]&&l[i].name;if(n!==s){N={};N.name=n;N.description="";N.href="api/"+n;if(a.deprecated){N.deprecated=true;}l.splice(i,0,N);}});}}return o;},_compareStringsCaseInsensitive:function(a,b){var l=a.name.toLowerCase(),e=b.name.toLowerCase();if(l<e){return-1;}if(l>e){return 1;}return 0;},_filterEntityByVisibilityInApiJsonData:function(l){var v=this.getModel("versionData"),i=v.getProperty("/isInternal");if(!i){l=(l||[]).filter(function(n){return!n.hasOwnProperty('visibility')||n.visibility!=='restricted';});}return l;},_findEntityInApiJsonData:function(l){var o,a,i;for(i=0,a=l.length;i<a;i++){o=l[i];if(o.name===this._sTopicid){if(o.visibility===undefined||this._aAllowedMembers.indexOf(o.visibility)>=0){return o;}else{return Promise.reject(this.NOT_FOUND);}}}return Promise.reject(this.NOT_FOUND);},_processApiIndexAndLoadApiJson:function(D){var e,m,t=this._sTopicid;this._aApiIndex=D;function b(a){return a.some(function(o){var F=o.name===t;if(!F&&o.nodes){return b(o.nodes);}else if(F){e=o;return true;}return false;});}b(D);if(e){this._oEntityData=e;if(e.deprecated||e.bAllContentDeprecated){m=this.getOwnerComponent().getConfigUtil().getMasterView("apiId").getController();m.selectDeprecatedSymbol(this._sTopicid);}e.nodes=this._filterEntityByVisibilityInApiJsonData(e.nodes);return A.getLibraryElementsJSONPromise(e.lib).then(function(D){return Promise.resolve(D);});}return Promise.reject(this.NOT_FOUND);},_bindData:function(t){var o=this._oControlData,m,u,s=function(a,b){if(a.name>b.name){return 1;}else if(a.name<b.name){return-1;}return 0;};u=o['ui5-metadata'];o.hasProperties=false;o.hasOwnMethods=false;o.hasControlProperties=false;o.hasAssociations=false;o.hasAggregations=false;o.hasSpecialSettings=false;o.hasAnnotations=false;var i=function(e){return(this._aAllowedMembers.indexOf(e.visibility)>=0);}.bind(this);var F=function(e){e.name&&(e.name=f.apiRefEntityName(e.name));e.code&&(e.code=f.apiRefEntityName(e.code));if(e.name){var p=e.name.replace(/[$#/]/g,".");e.placeholderId=p+"_method";e.subPlaceholderId=p+"__method";}return e;};if(o.borrowed.properties.length){u.properties=(u.properties||[]).concat(o.borrowed.properties).sort(s);}if(o.borrowed.aggregations.length){u.aggregations=(u.aggregations||[]).concat(o.borrowed.aggregations).sort(s);}if(o.borrowed.associations.length){u.associations=(u.associations||[]).concat(o.borrowed.associations).sort(s);}if(o.properties){o.properties=this.transformElements(o.properties,i,F);o.hasProperties=!!o.properties.length;}if(o.methods){o.methods=this.transformElements(o.methods,i,F);o.hasOwnMethods=!!o.methods.length;}if(u){o.dnd=u.dnd;if(u.properties){u.properties=this.transformElements(u.properties,i);o.hasControlProperties=!!u.properties.length;}if(u.associations){u.associations=this.transformElements(u.associations,i);o.hasAssociations=!!u.associations.length;}if(u.aggregations){u.aggregations=this.transformElements(u.aggregations,i);o.hasAggregations=!!u.aggregations.length;o.hasAggregationAltTypes=u.aggregations.some(function(e){return!!e.altTypes;});}if(u.specialSettings){u.specialSettings=this.transformElements(u.specialSettings,i);o.hasSpecialSettings=!!u.specialSettings.length;}o.hasAnnotations=!!(u.annotations&&u.annotations.length);}o.hasChildren=!!o.nodes;o.hasConstructor=o.hasOwnProperty("constructor")&&!!o.constructor;o.hasOwnEvents=!!o.events;o.hasEvents=!!(o.hasOwnEvents||(o.borrowed&&o.borrowed.events.length>0));o.hasMethods=!!(o.hasOwnMethods||(o.borrowed&&o.borrowed.methods.length>0));if(o.implements&&o.implements.length){o.implementsParsed=o.implements.map(function(a,b,e){var D=a.split("."),g=D[D.length-1];return{href:a,name:g};});o.hasImplementsData=true;}else{o.hasImplementsData=false;}o.isFunction=o.kind==="function";o.isClass=o.kind==="class";o.isNamespace=o.kind==="namespace";o.isDerived=!!o.extends;o.extendsText=o.extends||this.NOT_AVAILABLE;o.sinceText=o.since||this.NOT_AVAILABLE;o.module=o.module||this.NOT_AVAILABLE;this._oModel.setData(o);if(this.extHookbindData){this.extHookbindData(t,m);}},buildBorrowedModel:function(b){var e,g,h,j,k,s,l,m,M,p,P,n,q,r,t,I,R=[],S;if(!b){return Promise.resolve({events:[],methods:[],properties:[],aggregations:[],associations:[]});}l={methods:[],events:[],properties:[],aggregations:[],associations:[]};s=b.extends;var v=function(i){return this._aAllowedMembers.indexOf(i.visibility)!==-1;}.bind(this);m=b.methods||[];M=m.map(function(o){return o.name;});p=b["ui5-metadata"]&&b["ui5-metadata"].properties||[];P=p.map(function(o){return o.name;});n=b["ui5-metadata"]&&b["ui5-metadata"].aggregations||[];q=n.map(function(a){return a.name;});r=b["ui5-metadata"]&&b["ui5-metadata"].associations||[];t=r.map(function(a){return a.name;});var O=function(i){return M.indexOf(i.name)===-1;};var u=function(i){return P.indexOf(i.name)===-1&&!i.borrowedFrom&&!l.properties.some(function(o){return o.name===i.name;});};var w=function(i){return q.indexOf(i.name)===-1&&!i.borrowedFrom;};var x=function(i){return t.indexOf(i.name)===-1&&!i.borrowedFrom;};function y(a,i){return a.some(function(o){var F=o.name===i;if(!F&&o.nodes){return y(o.nodes,i);}else if(F){S=o;return true;}return false;});}I=[s];while(s){y(this._aApiIndex,s);if(S){s=S.extends;if(s){I.push(s);}if(R.indexOf(S.lib)===-1){R.push(S.lib);}}else{s=false;break;}}var z=R.map(function(a){return A.getLibraryElementsJSONPromise(a);});return Promise.all(z).then(function(a){var o=[],D;a.forEach(function(i){o=o.concat(i);});I.forEach(function(s){var E,i=o.length;while(i--){if(o[i].name===s){E=o[i];break;}}var F=function(K){return{name:K.name,link:"api/"+s+"#methods/"+K.name};};var G=function(K){return{name:K.name,link:"api/"+s+"#events/"+K.name};};var H=function(K){return Object.assign({},K,{borrowedFrom:s});};if(E){D=E["ui5-metadata"]||[];e=(E.methods||[]).filter(v).filter(O).map(F);if(e.length){l.methods.push({name:s,methods:e});}g=(E.events||[]).filter(v).map(G);if(g.length){l.events.push({name:s,events:g});}h=(D.properties||[]).filter(v).filter(u).map(H);if(h.length){l.properties=l.properties.concat(h);}j=(D.aggregations||[]).filter(v).filter(w).map(H);if(j.length){l.aggregations=l.aggregations.concat(j);}k=(D.associations||[]).filter(v).filter(x).map(H);if(k.length){l.associations=l.associations.concat(k);}}});return l;});},transformElements:function(e,F,a){var i,l=e.length,n=[],E;for(i=0;i<l;i++){E=e[i];if(F&&!F(E)){continue;}if(a){a(E);}n.push(E);}return n;}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/ApiDetailIndexDeprecatedExperimental.controller',["sap/ui/thirdparty/jquery","sap/ui/documentation/sdk/controller/BaseController","sap/ui/model/json/JSONModel","sap/ui/documentation/sdk/controller/util/JSDocUtil","sap/ui/documentation/sdk/controller/util/APIInfo","sap/ui/documentation/sdk/model/formatter"],function(q,B,J,a,A,g){"use strict";return B.extend("sap.ui.documentation.sdk.controller.ApiDetailIndexDeprecatedExperimental",{formatter:g,onInit:function(){var r=this.getRouter();this._oModel=new J();this._oModel.setSizeLimit(10000);this.setModel(this._oModel);r.getRoute("deprecated").attachPatternMatched(this._onTopicMatched,this);r.getRoute("experimental").attachPatternMatched(this._onTopicMatched,this);r.getRoute("since").attachPatternMatched(this._onTopicMatched,this);this._hasMatched=false;this._aVisitedTabs=[];},_onTopicMatched:function(e){var r=e.getParameter("name"),d={experimental:A.getExperimentalPromise,deprecated:A.getDeprecatedPromise,since:A.getSincePromise}[r],p;if(this._hasMatched){return;}this._hasMatched=true;this._aAllowedMembers=this.getModel("versionData").getProperty("/allowedMembers");p=this.getView().byId("objectPage");d().then(function(D){D=this._filterVisibleElements(D);this._oModel.setData(D);p.addEventDelegate({"onAfterRendering":this._prettify.bind(this)});if(p.getUseIconTabBar()){p.attachNavigate(this._attachPrettifyTab.bind(this));}}.bind(this));},_attachPrettifyTab:function(e){var s=e.getParameter("subSection"),i=s.getId(),b;if(this._aVisitedTabs.indexOf(i)<0){b=s.getBlocks();b.forEach(function(o){o.addEventDelegate({"onAfterRendering":this._prettify.bind(this)});}.bind(this));this._aVisitedTabs.push(i);}},_filterVisibleElements:function(d){var f={};Object.keys(d).forEach(function(v){var V=d[v];V.apis=V.apis.filter(function(e){return this._aAllowedMembers.indexOf(e.visibility)>-1;}.bind(this));if(V.apis.length>0){f[v]=V;}}.bind(this));return f;},_prettify:function(){q('pre').addClass('prettyprint');window.prettyPrint();},_modifyLinks:function(e){var i=e.getSource().getItems(),l=i.length,I;while(l--){I=i[l];if(I._getLinkSender){var c=I.getCustomData(),C=c[0].getValue(),E=c[1].getValue(),s=c[2].getValue(),h;if(c[3].getValue()){E=C+"."+E;}h="api/"+C;if(s!=="class"){h+="/"+s+"/"+E;}I._getLinkSender().setHref(h);}}}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/ApiDetailInitial.controller',["sap/ui/Device","sap/ui/documentation/sdk/controller/BaseController"],function(D,B){"use strict";return B.extend("sap.ui.documentation.sdk.controller.ApiDetailInitial",{onInit:function(){B.prototype.onInit.call(this);this._onOrientationChange({landscape:D.orientation.landscape});},onBeforeRendering:function(){this._deregisterOrientationChange();},onAfterRendering:function(){this._registerOrientationChange();},onExit:function(){this._deregisterOrientationChange();}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/ApiMaster.controller',["sap/ui/Device","sap/ui/documentation/sdk/controller/MasterTreeBaseController","sap/m/library","sap/base/Log","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/documentation/sdk/controller/util/APIInfo","sap/ui/model/json/JSONModel","sap/ui/documentation/sdk/controller/util/Highlighter"],function(D,M,m,L,F,a,A,J,H){"use strict";var S=m.SplitAppMode;return M.extend("sap.ui.documentation.sdk.controller.ApiMaster",{onInit:function(){var c=this.getOwnerComponent();this._oRouter=this.getRouter();this._oRouter.getRoute("api").attachPatternMatched(this._onMatched,this);this._oRouter.getRoute("apiSpecialRoute").attachPatternMatched(this._onTopicMatched,this);this._oRouter.getRoute("deprecated").attachPatternMatched(this._onTopicMatched,this);this._oRouter.getRoute("experimental").attachPatternMatched(this._onTopicMatched,this);this._oRouter.getRoute("since").attachPatternMatched(this._onTopicMatched,this);this._oTreeModel=new J();this._oTreeModel.setSizeLimit(10000);this.setModel(this._oTreeModel,"treeData");this._bIncludeDeprecated=false;this._oTree=this.byId("tree");this._oDataLoadedPromise=c.loadVersionInfo().then(function(){this._aAllowedMembers=c.aAllowedMembers;}.bind(this)).then(A.getIndexJsonPromise).then(this._bindTreeModel.bind(this)).then(function(){this.buildAndApplyFilters();this._initTreeUtil("name","nodes");}.bind(this));},onAfterRendering:function(){if(!this.highlighter){this.highlighter=new H(this._oTree.getDomRef(),{useExternalStyles:false,shouldBeObserved:true,isCaseSensitive:false});}},onExit:function(){this.highlighter.destroy();},_bindTreeModel:function(t){var f=function(n,b){return n.filter(function(N){if(N.hasOwnProperty('nodes')){N.nodes=f(N.nodes,b);}return!N.hasOwnProperty('visibility')||b.indexOf(N.visibility.toLowerCase())>=0;});};if(t.length>0){t.push({isSelected:false,name:"experimental",displayName:"Experimental APIs",bAllContentDeprecated:false,visibility:"public"},{isSelected:false,name:"deprecated",displayName:"Deprecated APIs",bAllContentDeprecated:false,visibility:"public"},{isSelected:false,name:"since",displayName:"Index by Version",bAllContentDeprecated:false,visibility:"public"});}t=f(t,this._aAllowedMembers);this._oTreeModel.setData(t,false);},selectDeprecatedSymbol:function(t){this._bIncludeDeprecated=true;this.byId("includeDeprecated").setSelected(true);this.buildAndApplyFilters();this._expandTreeToNode(t,this.getModel("treeData"));},_onTopicMatched:function(b){var t=decodeURIComponent(b.getParameter("arguments").id)||b.getParameter("name"),s;if(b.getParameter("name")==="apiSpecialRoute"){s=this._oRouter._decodeSpecialRouteArguments(b);t=s.id;}try{this.showMasterSide();}catch(e){L.error(e);}this._oDataLoadedPromise.then(function(){this._expandTreeToNode(t,this._oTreeModel);}.bind(this));},_onMatched:function(){var s=this.getView().getParent().getParent(),b=this._oTree.getSelectedItem();b&&b.setSelected(false);this._oDataLoadedPromise.then(function(){this._oTree.collapseAll().expand(0);}.bind(this));s.setMode(S.ShowHideMode);if(D.system.desktop){setTimeout(function(){this.getView().byId("searchField").getFocusDomRef().focus();}.bind(this),0);}},onNodeSelect:function(e){this._oRouter.navTo("apiId",{id:e.getParameter("listItem").getTarget()},false);},onTreeFilter:function(){M.prototype.onTreeFilter.apply(this,arguments);if(this.highlighter){this.highlighter.highlight(this._sFilter);}return this;},buildAndApplyFilters:function(){var f=[];if(!this._bIncludeDeprecated){f.push(new F({path:"bAllContentDeprecated",operator:a.EQ,value1:false}));}if(this._sFilter){f.push(new F({and:false,filters:[new F({path:"name",operator:a.Contains,value1:this._sFilter}),new F({path:"name",operator:a.Contains,value1:this._sFilter.replace(/\s/g,'')})]}));}this._oTree.getBinding("items").filter(new F({and:true,filters:f}));return!!this._sFilter;},onIncludeDeprecatedItemsChange:function(e){this._bIncludeDeprecated=e.getParameter("selected");this.buildAndApplyFilters();}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/App.controller',["sap/ui/thirdparty/jquery","sap/ui/documentation/sdk/controller/BaseController","sap/ui/documentation/sdk/controller/util/SearchUtil","sap/ui/core/mvc/Controller","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/model/json/JSONModel","sap/ui/core/ResizeHandler","sap/ui/Device","sap/ui/core/Fragment","sap/ui/core/Locale","sap/ui/core/LocaleData","sap/base/util/UriParameters","sap/ui/documentation/library","sap/ui/core/IconPool","sap/m/MessageBox","sap/m/library","sap/base/Log","sap/base/util/Version","sap/ui/core/syncStyleClass","sap/ui/documentation/WebPageTitleUtil","sap/ui/core/Core","sap/ui/documentation/sdk/model/formatter"],function(q,B,S,C,F,c,J,R,D,d,L,e,U,f,I,M,m,g,V,s,W,h,k){"use strict";var n=m.SplitAppMode;var o="Demo Kit - SAPUI5 SDK";var p={home:"Home - "+o,topic:"Documentation - "+o,api:"API Reference - "+o,controls:"Samples - "+o,demoapps:"Demo Apps - "+o,tools:"Tools - "+o};var r=m.URLHelper,N="/neo-app.json",A="about",t="feedback",u="change_version",v="settings",w="cookie_preferences",x="en",y="language";var T={sap_belize:{iMobileHeight:"5rem",iDesktopHeight:"3rem"},sap_fiori_3:{iMobileHeight:"4.75rem",iDesktopHeight:"2.75rem"}};return B.extend("sap.ui.documentation.sdk.controller.App",{formatter:k,onInit:function(){B.prototype.onInit.call(this);var a=new J({busy:false,delay:0,bPhoneSize:false,bShowVersionSwitchInHeader:false,bShowVersionSwitchInMenu:false,bLandscape:D.orientation.landscape,bHasMaster:false,bSearchMode:false,bHideTopicSection:!!window['sap-ui-documentation-hideTopicSection'],bHideApiSection:!!window['sap-ui-documentation-hideApiSection'],sAboutInfoSAPUI5:"Looking for the Demo Kit for a specific SAPUI5 version? "+"Check at <a href = 'https://sapui5.hana.ondemand.com/versionoverview.html'>https://sapui5.hana.ondemand.com/versionoverview.html</a> "+"which versions are available. "+"You can view the version-specific Demo Kit by adding the version number to the URL, e.g. "+"<a href='https://sapui5.hana.ondemand.com/1.52.4/'>https://sapui5.hana.ondemand.com/1.52.4/</a>",sAboutInfoOpenUI5:"Looking for the Demo Kit for a specific OpenUI5 version? "+"Check at <a href = 'https://openui5.hana.ondemand.com/versionoverview.html'>https://openui5.hana.ondemand.com/versionoverview.html</a> "+"which versions are available. "+"You can view the version-specific Demo Kit by adding the version number to the URL, e.g. "+"<a href='https://openui5.hana.ondemand.com/1.52.4/'>https://openui5.hana.ondemand.com/1.52.4/</a>",oThemeScrollContainerHeight:T[this.extractThemeSettings()]});this.MENU_LINKS_MAP={"legal":"https://www.sap.com/corporate/en/legal/impressum.html","privacy":"https://www.sap.com/corporate/en/legal/privacy.html","terms_of_use":"https://www.sap.com/corporate/en/legal/terms-of-use.html","copyright":"https://www.sap.com/corporate/en/legal/copyright.html","trademark":"https://www.sap.com/corporate/en/legal/trademark.html","disclaimer":"https://help.sap.com/viewer/disclaimer","license":"LICENSE.txt"};this.getOwnerComponent().loadVersionInfo().then(function(){if(this.getModel("versionData").getProperty("/isOpenUI5")){this.MENU_LINKS_MAP["Terms of Use"]="TermsOfUse.txt";}}.bind(this));this.FEEDBACK_SERVICE_URL="https://feedback-sapuisofiaprod.hana.ondemand.com:443/api/v2/apps/5bb7d7ff-bab9-477a-a4c7-309fa84dc652/posts";this._oSupportedLangModel=new J({"langs":this._prepareSupportedLangModelData()});this.setModel(this._oSupportedLangModel,"supportedLanguages");this._oView=this.getView();this.setModel(a,"appView");this.setModel(new J({inspectorHomeLink:"topic/b24e72443eb34d0fb7bf6940f2d697eb",supportAssistantHomeLink:"topic/57ccd7d7103640e3a187ed55e1d2c163",demoAppsHomeLink:"topic/a3ab54ecf7ac493b91904beb2095d208",iconExplorerHomeLink:"topic/21ea0ea94614480d9a910b2e93431291"}),"newWindowLinks");this.oHeader=this._oView.byId("headerToolbar");this.oRouter=this.getRouter();this._selectHeader=this._oView.byId("selectHeader");this._tabHeader=this._oView.byId("tabHeader");this._oWebPageTitleUtil=new W();this._oConfigUtil=this.getOwnerComponent().getConfigUtil();this._oCookieNames=this._oConfigUtil.COOKIE_NAMES;R.register(this.oHeader,this.onHeaderResize.bind(this));this.oRouter.attachRouteMatched(this.onRouteChange.bind(this));this.oRouter.attachBypassed(this.onRouteNotFound.bind(this));this._registerFeedbackRatingIcons();this._requestVersionInfo();this.byId("splitApp").attachEvent("afterMasterClose",function(E){a.setProperty("/bIsShownMaster",false);},this);this.bus=h.getEventBus();this.bus.subscribe("themeChanged","onDemoKitThemeChanged",this.onDemoKitThemeChanged,this);this._createConfigurationBasedOnURIInput();if(this._oConfigUtil.getCookieValue(this._oCookieNames.ALLOW_REQUIRED_COOKIES)==="1"&&this._aConfiguration.length>0){this._applyCookiesConfiguration(this._aConfiguration);}else{this._applyDefaultConfiguration(this._aConfiguration);}},onBeforeRendering:function(){D.orientation.detachHandler(this._onOrientationChange,this);},onAfterRendering:function(){q(document.body).addClass(this.getOwnerComponent().getContentDensityClass());D.orientation.attachHandler(this._onOrientationChange,this);if(this._oConfigUtil.getCookieValue(this._oCookieNames.APPROVAL_REQUESTED)!=="1"){this.cookieSettingsDialogOpen();}},onExit:function(){D.orientation.detachHandler(this._onOrientationChange,this);},onRouteChange:function(E){if(!this.oRouter.getRoute(E.getParameter("name"))._oConfig.target){return;}var a=E.getParameter("name"),b=this.oRouter.getRoute(a)._oConfig.target[0]+"Tab",i=this._oView.byId(b),K=i?i.getKey():"home",j=this.getModel("appView"),P=j.getProperty("/bPhoneSize"),l=j.getProperty("/bSearchMode"),z=D.system.phone,H=this.getOwnerComponent().getConfigUtil().hasMasterView(a),G,O;this._setHeaderSelectedKey(K);this._oWebPageTitleUtil.setTitle(p[K]);j.setProperty("/bHasMaster",H);if(P&&!l){this._selectHeader.setVisible(true);}if(z&&H){G=this.getOwnerComponent().getConfigUtil().getMasterView(a);O=G&&G.getId();j.setProperty("/sMasterViewId",O);}this.byId("splitApp").hideMaster();j.setProperty("/bIsShownMaster",false);},onRouteNotFound:function(){this.getRouter().myNavToWithoutHash("sap.ui.documentation.sdk.view.NotFound","XML",false);return;},toggleMaster:function(E){var P=E.getParameter("pressed"),b=D.system.phone,a=this.byId("splitApp"),i=a.getMode()===n.ShowHideMode,j=a.getMode()===n.HideMode,l=this.getModel("appView").getProperty("/sMasterViewId"),z;if(!b&&(i||j)){z=(P)?a.showMaster:a.hideMaster;z.call(a);return;}if(b){if(P){a.to(l);}else{a.backDetail();}}},navigateToSection:function(E){var K=E.getParameter("key"),i;if(!K){i=E.getParameter("selectedItem");i&&(K=i.getKey());}E.preventDefault();if(K&&K!=="home"){this.getRouter().navTo(K,{});}else{this.getRouter().navTo("welcome",{});this._setHeaderSelectedKey("home");}},handleMenuItemClick:function(E){var a=E.getParameter("item").getKey(),b=this.MENU_LINKS_MAP[a];if(a===A){this.aboutDialogOpen();}else if(a===t){this.feedbackDialogOpen();}else if(a===v){this.settingsDialogOpen();}else if(a===w){this.cookieSettingsDialogOpen(true);}else if(a===u){this.onChangeVersionButtonPress();}else if(b){r.redirect(b,true);}},_createConfigurationBasedOnURIInput:function(){var a=U.fromQuery(window.location.search);this._aConfiguration=[];if(!(a.has('sap-ui-language')||a.has('sap-language'))){this._aConfiguration.push(y);}},_applyDefaultConfiguration:function(){this._aConfiguration.forEach(function(a){if(a===y){h.getConfiguration().setLanguage(x);}},this);this._oSupportedLangModel.setProperty("/selectedLang",h.getConfiguration().getLanguage());},_applyCookiesConfiguration:function(){var a,b,i;for(i=0;i<this._aConfiguration.length;i++){b=this._aConfiguration[i];a=this._oConfigUtil.getCookieValue(b);if(a!==""){if(b===y){this._setSelectedLanguage(a);}this._aConfiguration.splice(i,1);i--;}}if(this._aConfiguration.length>0){this._applyDefaultConfiguration();}},_prepareSupportedLangModelData:function(){return h.getConfiguration().getLanguagesDeliveredWithCore().reduce(function(a,l){var b;if(typeof l==="string"&&l.length>0){switch(l){case"iw":b=new e(new L("he")).getLanguages()["he"];break;case"zh_TW":b=new e(new L(l)).getLanguages()["zh_Hant"];break;case"zh_CN":b=new e(new L(l)).getLanguages()["zh_Hans"];break;default:b=new e(new L(l)).getLanguages()[l];}a.push({"text":typeof b==='string'?b.charAt(0).toUpperCase()+b.substring(1):"Unknown","key":l});}return a;},[]);},_setSelectedLanguage:function(l){this._oSupportedLangModel.setProperty("/selectedLang",l);h.getConfiguration().setLanguage(l);if(this._oConfigUtil.getCookieValue(this._oCookieNames.ALLOW_REQUIRED_COOKIES)==="1"){this._oConfigUtil.setCookie(y,l);}},_getSelectedLanguage:function(){return this._oSupportedLangModel.getProperty("/selectedLang");},settingsDialogOpen:function(){if(!this._oSettingsDialog){d.load({name:"sap.ui.documentation.sdk.view.globalSettingsDialog",controller:this}).then(function(a){this._oView.addDependent(a);this._oSettingsDialog=a;h.byId("LanguageSelect").setSelectedKey(this._getSelectedLanguage());this._oSettingsDialog.open();}.bind(this));}else{this._oSettingsDialog.open();}},cookieSettingsDialogOpen:function(){if(this._oCookieSettingsController){this._oCookieSettingsController.openCookieSettingsDialog(this._oConfigUtil,this.getView());return;}C.create({name:"sap.ui.documentation.sdk.controller.CookieSettingsDialog"}).then(function(a){this._oCookieSettingsController=a;a.openCookieSettingsDialog(this._oConfigUtil,this.getView());}.bind(this));},handleCloseAppSettings:function(){this._oSettingsDialog.close();},handleSaveAppSettings:function(){var l=h.byId('LanguageSelect').getSelectedKey();this._oSettingsDialog.close();this._applyAppConfiguration(l);},_applyAppConfiguration:function(l){this._setSelectedLanguage(l);},aboutDialogOpen:function(){if(!this._oAboutDialog){this._oAboutDialog=new sap.ui.xmlfragment("aboutDialogFragment","sap.ui.documentation.sdk.view.AboutDialog",this);this._oView.addDependent(this._oAboutDialog);}else{this._oAboutDialog.getContent()[0].backToTop();}this._oAboutDialog.open();},aboutDialogClose:function(E){this._oAboutDialog.close();},onAboutVersionDetails:function(E){var a=this.getModel("appView"),b=a.getData(),j=this;f._loadAllLibInfo("","_getLibraryInfo","",function(H,K){var O={};var P=f._getLibraryInfoSingleton();for(var i=0,l=H.length;i<l;i++){H[i]=K[H[i]];H[i].libDefaultComponent=P._getDefaultComponent(H[i]);}O.libs=H;b.oVersionInfo=O;a.setData(b);j.setModel(a,"appView");});var z=d.byId("aboutDialogFragment","aboutNavCon"),G=d.byId("aboutDialogFragment","aboutDetail");z.to(G);},onAboutThirdParty:function(E){var l=this.getModel("appView"),z=l.getData(),G=this;f._loadAllLibInfo("","_getThirdPartyInfo",function(O,P){if(!O){return;}var Q={};Q.thirdparty=[];for(var j=0;j<O.length;j++){var X=P[O[j]];for(var i=0;i<X.libs.length;i++){var Y=X.libs[i];Y._lib=O[j];Q.thirdparty.push(Y);}}Q.thirdparty.sort(function(a,b){var Z=(a.displayName||"").toUpperCase();var $=(b.displayName||"").toUpperCase();if(Z>$){return 1;}else if(Z<$){return-1;}else{return 0;}});z.oThirdPartyInfo=Q;l.setData(z);G.setModel(l,"appView");});var H=d.byId("aboutDialogFragment","aboutNavCon"),K=d.byId("aboutDialogFragment","aboutThirdParty");H.to(K);},onReleaseDialogOpen:function(E){var l=f._getLibraryInfoSingleton(),a=E.getSource().data("version"),b=E.getSource().data("library"),i=new J(),j=new J(),z=this;if(!this._oReleaseDialog){this._oReleaseDialog=new sap.ui.xmlfragment("releaseDialogFragment","sap.ui.documentation.sdk.view.ReleaseDialog",this);this._oView.addDependent(this._oReleaseDialog);}if(!this._oNotesView){this._oNotesView=sap.ui.view({id:"notesView",viewName:"sap.ui.documentation.sdk.view.ReleaseNotesView",type:"Template"});this._oNotesView.setModel(i);}l._getReleaseNotes(b,a,function(G,a){var H={};if(G&&G[a]&&G[a].notes&&G[a].notes.length>0){z._oNotesView.getModel().setData(G);z._oNotesView.bindObject("/"+a);}else{H.noData=true;}H.library=b;j.setData(H);});this._oReleaseDialog.setModel(j);this._oReleaseDialog.addContent(this._oNotesView);this._oReleaseDialog.open();},onReleaseDialogClose:function(E){this._oReleaseDialog.close();},onAboutNavBack:function(E){var a=d.byId("aboutDialogFragment","aboutNavCon");a.back();},onChangeVersionButtonPress:function(){this.getVersionSwitchDialog().open();},onCloseVersionDialog:function(){this.getVersionSwitchDialog().close();},onChangeVersionDialogSearch:function(E){var a=E.getParameter("newValue"),b=new F("version",c.Contains,a),i=h.byId("versionList").getBinding("items");i.filter([b]);},onLogoIconPress:function(){this.oRouter.navTo("welcome",{});},onVersionItemPress:function(E){var a=E.getParameter("listItem"),b=a.getCustomData()[0];if(b&&b.getKey()==="path"){window.location.href=b.getValue();}},getVersionSwitchDialog:function(){if(!this._oChangeVersionDialog){this._createVersionDialog();}return this._oChangeVersionDialog;},versionSwitchCustomComparator:function(G,a){return V(G).compareTo(V(a));},_updateVersionSwitchVisibility:function(){var a=this.getModel("appView"),P=a.getProperty("/bPhoneSize");a.setProperty("/bShowVersionSwitchInHeader",!P&&!!this._aNeoAppVersions);a.setProperty("/bShowVersionSwitchInMenu",P&&!!this._aNeoAppVersions);},_createVersionDialog:function(){this._oChangeVersionDialog=new sap.ui.xmlfragment("sap.ui.documentation.sdk.view.ChangeVersionDialog",this);this._oChangeVersionDialog.setModel(this._buildVersionDialogModel());this._oView.addDependent(this._oChangeVersionDialog);},_buildVersionDialogModel:function(){var a=new J();a.setSizeLimit(1000);a.setData(this._aNeoAppVersions);return a;},feedbackDialogOpen:function(){var a=this;var b;if(!this._oFeedbackDialog){b=this.getModel("i18n").getResourceBundle();this._oFeedbackDialog=new sap.ui.xmlfragment("feedbackDialogFragment","sap.ui.documentation.sdk.view.FeedbackDialog",this);this._oView.addDependent(this._oFeedbackDialog);this._oFeedbackDialog.textInput=d.byId("feedbackDialogFragment","feedbackInput");this._oFeedbackDialog.contextCheckBox=d.byId("feedbackDialogFragment","pageContext");this._oFeedbackDialog.contextData=d.byId("feedbackDialogFragment","contextData");this._oFeedbackDialog.ratingStatus=d.byId("feedbackDialogFragment","ratingStatus");this._oFeedbackDialog.ratingStatus.value=0;this._oFeedbackDialog.sendButton=d.byId("feedbackDialogFragment","sendButton");this._oFeedbackDialog.ratingBar=[{button:d.byId("feedbackDialogFragment","excellent"),status:"Excellent",displayStatus:b.getText("FEEDBACK_DIALOG_STATUS_EXCELLENT")},{button:d.byId("feedbackDialogFragment","good"),status:"Good",displayStatus:b.getText("FEEDBACK_DIALOG_STATUS_GOOD")},{button:d.byId("feedbackDialogFragment","average"),status:"Average",displayStatus:b.getText("FEEDBACK_DIALOG_STATUS_AVERAGE")},{button:d.byId("feedbackDialogFragment","poor"),status:"Poor",displayStatus:b.getText("FEEDBACK_DIALOG_STATUS_POOR")},{button:d.byId("feedbackDialogFragment","veryPoor"),status:"Very Poor",displayStatus:b.getText("FEEDBACK_DIALOG_STATUS_VERY_POOR")}];this._oFeedbackDialog.reset=function(){this.sendButton.setEnabled(false);this.textInput.setValue("");this.contextCheckBox.setSelected(true);this.ratingStatus.setText("");this.ratingStatus.setState("None");this.ratingStatus.value=0;this.contextData.setVisible(false);this.ratingBar.forEach(function(i){if(i.button.getPressed()){i.button.setPressed(false);}});};this._oFeedbackDialog.updateContextData=function(){var i=a._getUI5Version(),j=a._getUI5Distribution();if(this.contextCheckBox.getSelected()){this.contextData.setValue("Location: "+a._getCurrentPageRelativeURL()+"\n"+j+" Version: "+i);}else{this.contextData.setValue(j+" Version: "+i);}};this._oFeedbackDialog.updateContextData();}this._oFeedbackDialog.updateContextData();if(!this._oFeedbackDialog.isOpen()){s("sapUiSizeCompact",this.getView(),this._oFeedbackDialog);this._oFeedbackDialog.open();}},onFeedbackDialogSend:function(){var a={},b=this.getModel("i18n").getResourceBundle();if(this._oFeedbackDialog.contextCheckBox.getSelected()){a={"texts":{"t1":this._oFeedbackDialog.textInput.getValue()},"ratings":{"r1":{"value":this._oFeedbackDialog.ratingStatus.value}},"context":{"page":this._getCurrentPageRelativeURL(),"attr1":this._getUI5Distribution()+":"+sap.ui.version}};}else{a={"texts":{"t1":this._oFeedbackDialog.textInput.getValue()},"ratings":{"r1":{"value":this._oFeedbackDialog.ratingStatus.value}},"context":{"attr1":this._getUI5Distribution()+":"+sap.ui.version}};}this._oFeedbackDialog.setBusyIndicatorDelay(0);this._oFeedbackDialog.setBusy(true);q.ajax({url:this.FEEDBACK_SERVICE_URL,type:"POST",contentType:"application/json",data:JSON.stringify(a)}).done(function(){M.success(b.getText("FEEDBACK_DIALOG_TEXT_SUCCESS"),{title:b.getText("FEEDBACK_DIALOG_TITLE_SUCCESS")});this._oFeedbackDialog.reset();this._oFeedbackDialog.close();this._oFeedbackDialog.setBusy(false);}.bind(this)).fail(function(i,j,E){var l=E;M.error(b.getText("FEEDBACK_DIALOG_TEXT_ERROR")+l,{title:b.getText("FEEDBACK_DIALOG_TITLE_ERROR")});this._oFeedbackDialog.setBusy(false);}.bind(this));},onFeedbackDialogCancel:function(){this._oFeedbackDialog.reset();this._oFeedbackDialog.close();},onShowHideContextData:function(){this._oFeedbackDialog.contextData.setVisible(!this._oFeedbackDialog.contextData.getVisible());},onContextSelect:function(){this._oFeedbackDialog.updateContextData();},onPressRatingButton:function(E){var a=this;var P=E.getSource();a._oFeedbackDialog.ratingBar.forEach(function(i){if(P!==i.button){i.button.setPressed(false);}else{if(!i.button.getPressed()){b("None","",0);}else{switch(i.status){case"Excellent":b("Success",i.displayStatus,5);break;case"Good":b("Success",i.displayStatus,4);break;case"Average":b("None",i.displayStatus,3);break;case"Poor":b("Warning",i.displayStatus,2);break;case"Very Poor":b("Error",i.displayStatus,1);}}}});function b(i,j,l){a._oFeedbackDialog.ratingStatus.setState(i);a._oFeedbackDialog.ratingStatus.setText(j);a._oFeedbackDialog.ratingStatus.value=l;if(l){a._oFeedbackDialog.sendButton.setEnabled(true);}else{a._oFeedbackDialog.sendButton.setEnabled(false);}}},onSearch:function(E){var Q=encodeURIComponent(E.getParameter("query"));if(!Q){return;}this.getRouter().navTo("search",{searchParam:Q},false);},onHeaderResize:function(E){var i=E.size.width,P=D.system.phone||i<D.media._predefinedRangeSets[D.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0],a=this.getModel("appView"),b=a.getProperty("/bSearchMode");if(P!==a.getProperty("/bPhoneSize")){a.setProperty("/bPhoneSize",P);this._updateVersionSwitchVisibility();this._tabHeader.setVisible(!P);this._selectHeader.setVisible(P);}if(b){this._selectHeader.setVisible(false);}},_onOrientationChange:function(){this.getModel("appView").setProperty("/bLandscape",D.orientation.landscape);},onToggleSearchMode:function(E){var b=E.getParameter("isOpen"),a=this.getModel("appView"),P=a.getProperty("/bPhoneSize");a.setProperty("/bSearchMode",b);if(b){S.init();setTimeout(function(){this._oView.byId("searchControl").getAggregation("_searchField").getFocusDomRef().focus();}.bind(this),0);if(P){this._selectHeader.setVisible(false);}}else if(P){this._selectHeader.setVisible(true);}},_registerFeedbackRatingIcons:function(){I.addIcon("icon-face-very-bad","FeedbackRatingFaces",{fontFamily:"FeedbackRatingFaces",content:"E086",suppressMirroring:true});I.addIcon("icon-face-bad","FeedbackRatingFaces",{fontFamily:"FeedbackRatingFaces",content:"E087",suppressMirroring:true});I.addIcon("icon-face-neutral","FeedbackRatingFaces",{fontFamily:"FeedbackRatingFaces",content:"E089",suppressMirroring:true});I.addIcon("icon-face-happy","FeedbackRatingFaces",{fontFamily:"FeedbackRatingFaces",content:"E08B",suppressMirroring:true});I.addIcon("icon-face-very-happy","FeedbackRatingFaces",{fontFamily:"FeedbackRatingFaces",content:"E08C",suppressMirroring:true});},_requestVersionInfo:function(){Promise.resolve(q.ajax(N)).then(function(a){var b=this.getModel("versionData"),i=b.getProperty("/isInternal"),j=b.getProperty("/isSnapshotVersion");if(!(a&&a.routes)){g.warning("No versions were found");return;}a.routes.pop();this._aNeoAppVersions=a.routes;if(!i&&!j){this._aNeoAppVersions=this._aNeoAppVersions.filter(function(l){return l.target.version.indexOf("-beta")===-1;});}this._aNeoAppVersions=this._aNeoAppVersions.map(function(l){var z=V(l.target.version),E={};E.patchVersion=z.getPatch();E.groupTitle=z.getMajor()+"."+z.getMinor();E.version=z.toString();E.path=l.path;return E;});this._updateVersionSwitchVisibility();}.bind(this),function(){g.warning("No neo-app.json was detected");});},onDemoKitThemeChanged:function(){this.getModel("appView").setProperty("/oThemeScrollContainerHeight",T[this.extractThemeSettings()]);},extractThemeSettings:function(){return h.getConfiguration().getTheme()==="sap_fiori_3"?"sap_fiori_3":"sap_belize";},_getUI5Version:function(){return this.getModel("versionData").getProperty("/version");},_getUI5VersionGav:function(){return this.getModel("versionData").getProperty("/versionGav");},_getUI5Distribution:function(){var a=this._getUI5VersionGav();var b="SAPUI5";if(a&&/openui5/i.test(a)){b="OpenUI5";}return b;},_getCurrentPageRelativeURL:function(){var a=window.location;return a.pathname+a.hash+a.search;},_setHeaderSelectedKey:function(K){this._selectHeader.setSelectedKey(K);this._tabHeader.setSelectedKey(K);}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/BaseController',["sap/ui/documentation/library","sap/ui/core/Fragment","sap/ui/core/mvc/Controller","sap/ui/core/routing/History","sap/ui/model/resource/ResourceModel","sap/ui/Device","sap/m/library","sap/ui/documentation/sdk/controller/util/APIInfo","sap/base/strings/formatMessage"],function(l,F,C,H,R,D,m,A,f){"use strict";var S=m.SplitAppMode;return C.extend("sap.ui.documentation.sdk.controller.BaseController",{_oCore:sap.ui.getCore(),formatMessage:f,onInit:function(){var M=new R({bundleName:"sap.ui.documentation.messagebundle"});this.setModel(M,"i18n");if(D.system.phone||D.system.tablet){this.getOwnerComponent().loadVersionInfo();}},hideMasterSide:function(){var s=this.getSplitApp();s.setMode(S.HideMode);},showMasterSide:function(){var s=this.getSplitApp();s.setMode(S.ShowHideMode);},getSplitApp:function(){return this.getView().getParent().getParent();},getRouter:function(){return this.getOwnerComponent().getRouter();},getModel:function(n){return this.getView().getModel(n);},setModel:function(M,n){return this.getView().setModel(M,n);},getConfig:function(){return this.getOwnerComponent().getMetadata().getConfig();},onNavBack:function(e){var p=H.getInstance().getPreviousHash();if(p!==undefined){if(p.indexOf("search/")===0){this.getRouter().navTo("search",{searchParam:p.split("/")[1]},false);}else{history.go(-1);}}else{var c=window.location.hash;if(c.indexOf("#/topic/")==0){this.getRouter().navTo("topic",{},true);}else if(c.indexOf("#/api/")==0){this.getRouter().navTo("api",{},true);}}},searchResultsButtonVisibilitySwitch:function(b){var p=H.getInstance().getPreviousHash();if(p&&p.indexOf("search/")===0){b.setVisible(true);}else{b.setVisible(false);}},getRootView:function(){var c=this.getOwnerComponent();return c.byId(c.getManifestEntry("/sap.ui5/rootView").id);},onDisclaimerLinkPress:function(e){var s=e.getSource?e.getSource():e.target;if(!this.oDisclaimerPopover){F.load({name:"sap.ui.documentation.sdk.view.LegalDisclaimerPopover"}).then(function(p){this.getView().addDependent(p);this.oDisclaimerPopover=p;p.openBy(s);}.bind(this));return;}else if(this.oDisclaimerPopover.isOpen()){this.oDisclaimerPopover.close();}this.oDisclaimerPopover.openBy(s);},_getControlComponent:function(c,o){var L=o.libComponentInfos,a=l._getLibraryInfoSingleton();return a._getActualComponent(L,c);},_onOrientationChange:function(e){var i=this.byId("phoneImage");if(D.system.phone&&i){i.toggleStyleClass("phoneHeaderImageLandscape",e.landscape);}},_registerOrientationChange:function(){D.orientation.attachHandler(this._onOrientationChange,this);},_deregisterOrientationChange:function(){D.orientation.detachHandler(this._onOrientationChange,this);},handleLandingImageLoad:function(){this.getView().byId("landingImageHeadline").setVisible(true);},getAPIReferenceCheckPromise:function(c){return A.getIndexJsonPromise().then(function(d){function b(a){return a.some(function(o){var e=o.name===c;if(!e&&o.nodes){return b(o.nodes);}return e;});}return b(d);});}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/Code.controller',["sap/ui/thirdparty/jquery","sap/ui/documentation/sdk/controller/SampleBaseController","sap/ui/documentation/sdk/controller/util/ControlsInfo","sap/ui/documentation/sdk/model/formatter","sap/ui/model/json/JSONModel","sap/base/util/merge"],function(q,S,C,f,J,m){"use strict";return S.extend("sap.ui.documentation.sdk.controller.Code",{onInit:function(){S.prototype.onInit.call(this);this.oModel=new J();this.getView().setModel(this.oModel);this.router=this.getRouter();this.router.getRoute("code").attachPatternMatched(this.onRouteMatched,this);this.router.getRoute("codeFile").attachPatternMatched(this.onRouteMatched,this);this._aFilesAvailable=[];this._bFirstLoad=true;},onRouteMatched:function(e){var a=e.getParameter("arguments");this.showMasterSide();this._sId=a.sampleId;this._sEntityId=a.entityId;this._sFileName=f.routeParamsToFilePath(a);C.loadData().then(this._loadCode.bind(this));},_loadCode:function(d){var F=this._sFileName,s=d.samples[this._sId],p=[];if(!s||(s.contexts&&!s.contexts[this._sEntityId])){this.router.myNavToWithoutHash("sap.ui.documentation.sdk.view.NotFound","XML",false);return;}if(!this._oData||s.id!==this._oData.id){var c='sampleComp-'+this._sId;var a=this._sId;var o=sap.ui.component(c);if(!o){o=sap.ui.getCore().createComponent({id:c,name:a});}var M=o.getMetadata();var b=(M)?M.getConfig():null;this._oData={id:s.id,title:"Code: "+s.name,name:s.name,stretch:b.sample?b.sample.stretch:false,files:[],iframe:b.sample.iframe,fileName:F,includeInDownload:b.sample.additionalDownloadFiles};if(b&&b.sample&&b.sample.files){var r=sap.ui.require.toUrl((s.id).replace(/\./g,"/"));for(var i=0;i<b.sample.files.length;i++){var e=b.sample.files[i];p.push(this._updateFileContent(r,e));this._oData.files.push({name:e});this._aFilesAvailable.push(e);}}}else{this._oData.fileName=F;}this.getAPIReferenceCheckPromise(this._sEntityId).then(function(h){this.getView().byId("apiRefButton").setVisible(h);}.bind(this));this.oModel.setData(this._oData);if(F===undefined){F=this._getInitialFileName();}if(this._aFilesAvailable.indexOf(F)===-1){this.router.myNavToWithoutHash("sap.ui.documentation.sdk.view.NotFound","XML",false);return;}Promise.all(p).then(function(){this._updateCodeEditor(F);}.bind(this));this._getTabHeader().setSelectedKey(F);var g=this.byId("page");g.scrollTo(0);},_updateFileContent:function(r,F){return this.fetchSourceFile(r+"/"+F).then(function(c){this._oData.files.some(function(o){if(o.name===F){o.raw=c;o.code=this._convertCodeToHtml(c);return true;}},this);this.oModel.setData(this._oData);}.bind(this));},onAPIRefPress:function(){this.getRouter().navTo("apiId",{id:this._sEntityId});},onNavBack:function(){this.router.navTo("sample",{sampleId:this._sId,entityId:this._sEntityId});},_convertCodeToHtml:function(c){c=c.toString();c=c.replace(/^function.+{/,"");c=c.replace(/}[!}]*$/,"");c=c.replace(/^[\n\s\S]*\/\/\s*CODESNIP_START\n/,"");c=c.replace(/\/\/\s*CODESNIP_END[\n\s\S]*$/,"");c=c.replace(/\t/g,"  ");return c;},handleTabSelectEvent:function(e){var F=e.getParameter("selectedKey"),r=m(f.filePathToRouteParams(F),{entityId:this._sEntityId,sampleId:this._sId});this._bFirstLoad=false;this.router.navTo("codeFile",r,false);},_updateCodeEditor:function(F){var c=this._getCodeEditor(),a=c.getInternalEditorInstance(),A=a.renderer;c.setValue(this._getCode(F));c.setType(this._getFileType(F));a.gotoLine(0,0,false);if(this._bFirstLoad){setTimeout(function(){A.onResize();},0);}},_getCode:function(F){var a=this.getModel().getData().files,c="";a.forEach(function(o){if(o.name===F){c=o.raw;return true;}});return c;},_getFileType:function(F){var s=F.split('.').pop();return s==="js"?"javascript":s;},_getInitialFileName:function(){return(this._oData&&this._oData.files&&this._oData.files.length>0&&this._oData.files[0].name)||null;},_getCodeEditor:function(){if(!this.oCodeEditor){this.oCodeEditor=this.byId("codeEditor");}return this.oCodeEditor;},_getTabHeader:function(){if(!this.oTabHeader){this.oTabHeader=this.byId("tabHeader");}return this.oTabHeader;}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/Controls.controller',["sap/ui/documentation/sdk/controller/BaseController","sap/ui/Device"],function(B,D){"use strict";return B.extend("sap.ui.documentation.sdk.controller.Controls",{onInit:function(){B.prototype.onInit.call(this);this._onOrientationChange({landscape:D.orientation.landscape});},onBeforeRendering:function(){this._deregisterOrientationChange();},onAfterRendering:function(){this._registerOrientationChange();},onExit:function(){this._deregisterOrientationChange();},onPress:function(e){var f=e.oSource.getFilter(),s=this.getOwnerComponent().byId("controlsMaster").byId("searchField");s.setValue(f).fireLiveChange({newValue:f});setTimeout(function(){this.getSplitApp().showMaster();}.bind(this),0);}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/ControlsMaster.controller',["jquery.sap.global","sap/ui/Device","sap/ui/documentation/sdk/controller/BaseController","sap/ui/model/json/JSONModel","sap/ui/documentation/sdk/controller/util/ControlsInfo","sap/m/GroupHeaderListItem","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/model/Sorter","sap/base/util/Version","sap/ui/thirdparty/jquery","sap/base/util/UriParameters","sap/ui/util/Storage","sap/ui/core/Core","sap/ui/documentation/sdk/controller/util/Highlighter"],function(q,D,B,J,C,G,F,a,S,V,Q,U,b,c,H){"use strict";var d="cozy",e="compact",f="condensed";return B.extend("sap.ui.documentation.sdk.controller.ControlsMaster",{_oStorage:new b(b.Type.local),_sStorageKey:"UI5_EXPLORED_LIST_SETTINGS_FROM_1_48",_oViewSettings:{densityMode:e,themeActive:"sap_fiori_3",rtl:false},_oDefaultSettings:{densityMode:e,themeActive:"sap_fiori_3",rtl:false},_oListSettings:{filter:{},groupProperty:"category",groupDescending:false,version:V(sap.ui.version).getMajor()+"."+V(sap.ui.version).getMinor()},_mGroupFunctions:{"name":function(o){var k=o.getProperty("name").charAt(0);return{key:k,text:k};},"namespace":true,"category":true,"since":true,"formFactors":true},_sFilterValue:"",onInit:function(){this._oList=this.byId("exploredMasterList");var E,o,g,O=function(h){this._oView.getModel().setData({entityCount:h.entityCount,entities:h.entities});this.getModel("filter").setData(h.filter);this._toggleListItem(this._getItemToSelect(),true);}.bind(this);this._oRouter=this.getRouter();this._bNavToEntityViaList=false;this._oView=this.getView();C.loadData().then(O);E=new J();E.setSizeLimit(100000);this._oView.setModel(E);o=new J({listMode:(D.system.phone)?"None":"SingleSelectMaster",listItemType:(D.system.phone)?"Active":"Inactive"});o.setDefaultBindingMode("OneWay");this._oView.setModel(o,"viewModel");g=new J();g.setSizeLimit(100000);this.setModel(g,"filter");this._vsFilterBar=this._oView.byId("vsFilterBar");this._vsFilterLabel=this._oView.byId("vsFilterLabel");this._oRouter.getRoute("listFilter").attachPatternMatched(this._onFilterMatched,this);this._oRouter.getRoute("group").attachPatternMatched(this._onGroupMatched,this);this._oRouter.getRoute("entity").attachPatternMatched(this._onEntityMatched,this);this._oRouter.getRoute("sample").attachPatternMatched(this._onSampleMatched,this);this._oRouter.getRoute("code").attachPatternMatched(this._onSampleMatched,this);this._oRouter.getRoute("codeFile").attachPatternMatched(this._onSampleMatched,this);this._oRouter.getRoute("controls").attachPatternMatched(this._onControlsMatched,this);this._oRouter.getRoute("controlsMaster").attachPatternMatched(this._onControlsMasterMatched,this);this.LIST_SCROLL_DURATION=0;this._iDomRenderingDelay=0;this._getList().addEventDelegate({onAfterRendering:function(){setTimeout(this._scrollToSelectedListItem.bind(this),this._iDomRenderingDelay);}},this);this._oCore.attachThemeChanged(this._scrollToSelectedListItem,this);this._oCore.attachLocalizationChanged(this._onLocalizationChange,this);this._oView.addEventDelegate({onBeforeFirstShow:this.onBeforeFirstShow.bind(this)});this._oComponent=this.getOwnerComponent();this._oRootView=this.getRootView();switch(this._oComponent.getContentDensityClass()){case"sapUiSizeCompact":this._oViewSettings.densityMode=e;break;case"sapUiSizeCondensed":this._oViewSettings.densityMode=f;break;default:this._oViewSettings.densityMode=d;}this._oViewSettings.rtl=this._oCore.getConfiguration().getRTL();this._oDefaultSettings.densityMode=this._oViewSettings.densityMode;this._oDefaultSettings.rtl=this._oViewSettings.rtl;this._initListSettings();this.bus=c.getEventBus();},onAfterRendering:function(){if(!this.highlighter){this.highlighter=new H(this._oList.getDomRef(),{shouldBeObserved:true});}},_viewSettingsResetOnNavigation:function(E){var r=E.getParameter("name");if(["group","entity","sample","code","code_file","controls","controlsMaster","listFilter"].indexOf(r)===-1){this._applyAppConfiguration(this._oDefaultSettings.themeActive,this._oDefaultSettings.densityMode,this._oDefaultSettings.rtl);this.getRouter().detachBeforeRouteMatched(this._viewSettingsResetOnNavigation,this);}},_initListSettings:function(){var j=this._oStorage.get(this._sStorageKey);if(j){this._oListSettings=JSON.parse(j);}},_toggleContentDensityClasses:function(o,s){switch(s){case e:o.toggleClass("sapUiSizeCompact",true).toggleClass("sapUiSizeCozy",false).toggleClass("sapUiSizeCondensed",false);break;case f:o.toggleClass("sapUiSizeCondensed",true).toggleClass("sapUiSizeCozy",false).toggleClass("sapUiSizeCompact",true);break;default:o.toggleClass("sapUiSizeCozy",true).toggleClass("sapUiSizeCondensed",false).toggleClass("sapUiSizeCompact",false);}},_applyAppConfiguration:function(t,s,r){var o,g,$,R,T,h;if(this._oViewSettings.densityMode!==s){this._toggleContentDensityClasses(Q(document.body),s);this._oViewSettings.densityMode=s;h=true;}if(this._oViewSettings.rtl!==r){this._oCore.getConfiguration().setRTL(r);this._oViewSettings.rtl=r;R=true;}if(this._oViewSettings.themeActive!==t){this._oCore.applyTheme(t);this._oViewSettings.themeActive=t;T=true;this.bus.publish("themeChanged","onDemoKitThemeChanged",{sThemeActive:t});}else if(h){this._oCore.notifyContentDensityChanged();}if(R||h||T){$=Q("#sampleFrame");if($.length>0){o=$[0].contentWindow;if(o){g=o.sap.ui.getCore();if(h){this._toggleContentDensityClasses(o.jQuery('body'),s);}if(R){g.getConfiguration().setRTL(r);}if(T){g.applyTheme(t);}else if(h){g.notifyContentDensityChanged();}}}}},_onGroupMatched:function(g){this._onMatched('#/group/',g);},_onEntityMatched:function(g){this._onMatched('#/entity/',g);},_onSampleMatched:function(g){this._onMatched('#/sample/',g);},_onMatched:function(n,E){var o=this._getList().getModel(),s=E.getParameter("arguments").entityId;this.showMasterSide();this._topicId=n+s;this._entityId=s;o.refresh();this._updateListSelection();},_onControlsMasterMatched:function(g){this.showMasterSide();if(!D.system.phone){this.getRouter().navTo("controls");}},_onFilterMatched:function(E){var s=E.getParameter("arguments").value,o;if(s){s=decodeURI(s);o=this.byId("searchField");o.setValue(s).fireLiveChange({newValue:s});setTimeout(function(){this.getSplitApp().showMaster();}.bind(this),0);if(D.system.phone){this.getRouter().navTo("controlsMaster",{});}}this._onControlsMatched(E);},_onControlsMatched:function(){this.showMasterSide();this._resetListSelection();if(D.system.desktop){setTimeout(function(){this.getView().byId("searchField").getFocusDomRef().focus();}.bind(this),0);}},_onLocalizationChange:function(E){this._iDomRenderingDelay=3000;setTimeout(function(){this._iDomRenderingDelay=0;}.bind(this),this._iDomRenderingDelay);},onNavToEntity:function(E){var i=E.getParameter("listItem"),I=(i)?i:E.getSource(),p=I.getBindingContext().getPath(),o=this.getView().getModel().getProperty(p);this._bNavToEntityViaList=true;this.getRouter().navTo("entity",{id:o.id,part:"samples"});},getGroupHeader:function(g){return new G({title:g.key,upperCase:false});},_updateListSelection:function(){var i=this._getItemToSelect();if(!i){return;}this._toggleListItem(i,true);if(!this._bNavToEntityViaList){setTimeout(this._scrollToSelectedListItem.bind(this),0);}this._bNavToEntityViaList=false;},_resetListSelection:function(){var s=this._getList().getSelectedItem();if(s){this._toggleListItem(s,false);setTimeout(this._scrollPageTo.bind(this,0,0),0);}},_toggleListItem:function(i,s){this._getList().setSelectedItem(i,s,false);},_scrollToSelectedListItem:function(){var i=this._getList().getSelectedItem();if(i){this._getPage().scrollToElement(i,this.LIST_SCROLL_DURATION);}},_scrollPageTo:function(p,i){this._getPage().scrollTo(p,i);},_getItemToSelect:function(){var l=this._getList(),E=l.getModel(),o,i,I,L=this._entityId,g=null;l.getItems().forEach(function(h){i=h.getBindingContext();if(i){I=i.getPath();o=E.getProperty(I);if(o.id===L){g=h;return false;}}});return g;},_getPage:function(){if(!this.oPage){this.oPage=this.byId("exploredMasterPage");}return this.oPage;},_getList:function(){if(!this.oList){this.oList=this.byId("exploredMasterList");}return this.oList;},onBeforeFirstShow:function(){this._updateView();},onExit:function(){this._oCore.detachThemeChanged(this._scrollToSelectedListItem,this);this._oCore.detachLocalizationChanged(this._onLocalizationChange,this);this.highlighter.destroy();},onConfirmViewSettings:function(E){var g=E.getParameter("groupItem");this._oListSettings.filter=E.getParameter("filterCompoundKeys");this._oListSettings.groupProperty=g?g.getKey():null;this._oListSettings.groupDescending=E.getParameter("groupDescending");this._oStorage.put(this._sStorageKey,JSON.stringify(this._oListSettings));this._updateView();},handleListSettings:function(){if(!this._oVSDialog){this._oVSDialog=sap.ui.xmlfragment(this.getView().getId(),"sap.ui.documentation.sdk.view.viewSettingsDialog",this);this.getView().addDependent(this._oVSDialog);}this._oVSDialog.setSelectedFilterCompoundKeys(this._oListSettings.filter);this._oVSDialog.setSelectedGroupItem(this._oListSettings.groupProperty);this._oVSDialog.setGroupDescending(this._oListSettings.groupDescending);this._oVSDialog.open();},handleListFilter:function(E){this._sFilterValue=E.getParameter("newValue").trim();if(this.highlighter){this.highlighter.highlight(this._sFilterValue);}this._updateView();},_updateListBinding:function(){var o,s,g=[],h=[],i=false,j=false,l=this._oView.byId("exploredMasterList"),k=l.getBinding("items");i=true;g.push(new F("searchTags",a.Contains,this._sFilterValue));Q.each(this._oListSettings.filter,function(p,v){var P=[];Q.each(v,function(K,m){var O=(p==="formFactors")?a.Contains:a.EQ;P.push(new F(p,O,K));});i=true;g.push(new F(P,false));});if(i&&g.length===0){k.filter(g,"Application");}else if(i&&g.length>0){o=new F(g,true);k.filter(o,"Application");}if(this._oListSettings.groupProperty&&this._oListSettings.groupProperty!==this._sCurrentGroup){j=true;}else if(this._oListSettings.groupProperty&&this._oListSettings.groupDescending!==this._bCurrentlyGroupedDescending){j=true;}if(j){s=new S(this._oListSettings.groupProperty,this._oListSettings.groupDescending,this._mGroupFunctions[this._oListSettings.groupProperty]);h.push(s);h.push(new S("name",false));k.sort(h);}this._sCurrentGroup=this._oListSettings.groupProperty;this._bCurrentlyGroupedDescending=this._oListSettings.groupDescending;this._bIsViewUpdatedAtLeastOnce=true;},_updateView:function(){this._updateFilterBarDisplay();this._updateListBinding();},_updateFilterBarDisplay:function(){var g=[];Q.each(this._oListSettings.filter,function(p,v){g=g.concat(Object.keys(v));});if(g.length>0){this._vsFilterBar.setVisible(true);this._vsFilterLabel.setText(g.join(", "));}else{this._vsFilterBar.setVisible(false);}},handleSettings:function(){if(!this._oSettingsDialog){this._oSettingsDialog=new sap.ui.xmlfragment("sap.ui.documentation.sdk.view.appSettingsDialog",this);this._oView.addDependent(this._oSettingsDialog);}setTimeout(function(){var A=this._oCore.getConfiguration(),t=this._oCore.byId("ThemeSelect"),u=U.fromQuery(window.location.search).get("sap-theme"),g=this._oViewSettings.densityMode;t.setSelectedKey(u?u:A.getTheme());this._oCore.byId("RTLSwitch").setState(A.getRTL());this._oCore.byId("DensityModeSwitch").setSelectedKey(g);this._oSettingsDialog.open();}.bind(this),0);},handleCloseAppSettings:function(){this._oSettingsDialog.close();},handleSaveAppSettings:function(){var g,s=this._oCore.byId('DensityModeSwitch').getSelectedKey(),t=this._oCore.byId('ThemeSelect').getSelectedKey(),r=this._oCore.byId('RTLSwitch').getState();this._oSettingsDialog.close();if(!this._oBusyDialog){q.sap.require("sap.m.BusyDialog");g=sap.ui.require("sap/m/BusyDialog");this._oBusyDialog=new g();this.getView().addDependent(this._oBusyDialog);}this._oBusyDialog.open();setTimeout(function(){this._oBusyDialog.close();}.bind(this),1000);this._applyAppConfiguration(t,s,r);this.getRouter().attachBeforeRouteMatched(this._viewSettingsResetOnNavigation,this);}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/CookieSettingsDialog.controller',["sap/ui/documentation/sdk/controller/BaseController","	sap/ui/documentation/sdk/model/formatter","sap/m/library","sap/ui/model/json/JSONModel","sap/ui/core/Fragment","sap/ui/core/Core"],function(B,g,m,J,F,C){"use strict";return B.extend("sap.ui.documentation.sdk.controller.CookieSettingsDialog",{formatter:g,constructor:function(){this._oConfigUtil=null;this._oRootView=null;this._oModel=new J({showCookieDetails:false,allowShowHideCookieDetails:true});},openCookieSettingsDialog:function(c,r){if(this._oCookieSettingsDialog){this._oCookieSettingsDialog.open();}else{this._initData(c,r);F.load({name:"sap.ui.documentation.sdk.view.CookieSettingsDialog",controller:this}).then(this._initDialog.bind(this)).then(function(d){this._oCookieSettingsDialog=d;this._oCookieSettingsDialog.open();}.bind(this));}},_initDialog:function(d){var i;d.setModel(this._oModel,"cookieData");this._oRootView.addDependent(d);d.attachBeforeOpen(function(){i=this._bAlreadyRequestedCookiesApproval;this._oModel.setProperty("/showCookieDetails",i);this._oCookieSettingsDialog.toggleStyleClass("cookiesDetailedView",i);this._oModel.setProperty("/allowShowHideCookieDetails",!i);},this);d.attachAfterOpen(function(){C.byId("btnSetPreferences").$().focus();});if(!this._bAlreadyRequestedCookiesApproval){d.attachEventOnce("afterClose",function(){this._bAlreadyRequestedCookiesApproval=true;this._oConfigUtil.setCookie(this._oConfigUtil.COOKIE_NAMES.APPROVAL_REQUESTED,"1");},this);}return d;},onAcceptAllCookies:function(){this._saveCookiePreference(this._oCookieNames.ALLOW_REQUIRED_COOKIES,true);this._saveCookiePreference(this._oCookieNames.ALLOW_USAGE_TRACKING,true);this._oCookieSettingsDialog.close();},onRejectAllCookies:function(){this._saveCookiePreference(this._oCookieNames.ALLOW_REQUIRED_COOKIES,false);this._saveCookiePreference(this._oCookieNames.ALLOW_USAGE_TRACKING,false);this._oCookieSettingsDialog.close();},onSaveCookies:function(){var h=C.byId("requiredCookiesSwitch").getState(),H=C.byId("functionalCookiesSwitch").getState();this._saveCookiePreference(this._oCookieNames.ALLOW_REQUIRED_COOKIES,h);this._saveCookiePreference(this._oCookieNames.ALLOW_USAGE_TRACKING,H);this._oCookieSettingsDialog.close();},showCookieDetails:function(){this._oModel.setProperty("/showCookieDetails",true);this._oCookieSettingsDialog.addStyleClass("cookiesDetailedView");this._focusButton(C.byId("btnSavePreferences"));},hideCookieDetails:function(){this._oModel.setProperty("/showCookieDetails",false);this._oCookieSettingsDialog.removeStyleClass("cookiesDetailedView");this._focusButton(C.byId("btnSetPreferences"));},onCancelEditCookies:function(){this._oCookieSettingsDialog.close();C.byId("requiredCookiesSwitch").setState(this._oConfigUtil.getCookieValue(this._oCookieNames.ALLOW_REQUIRED_COOKIES)==="1");C.byId("functionalCookiesSwitch").setState(this._oConfigUtil.getCookieValue(this._oCookieNames.ALLOW_USAGE_TRACKING)==="1");},_saveCookiePreference:function(c,e){var v=e?"1":"0";if((c===this._oCookieNames.ALLOW_USAGE_TRACKING)&&e&&this._oConfigUtil.getCookieValue(this._oCookieNames.ALLOW_USAGE_TRACKING)!=="1"){this._oConfigUtil.enableUsageTracking();}this._oConfigUtil.setCookie(c,v);this._oModel.setProperty("/"+c,v);},_initData:function(c,r){this._oConfigUtil=c;this._oRootView=r;this._oCookieNames=this._oConfigUtil.COOKIE_NAMES;this._bAlreadyRequestedCookiesApproval=this._oConfigUtil.getCookieValue(this._oCookieNames.APPROVAL_REQUESTED)==="1";this._setInitialCookieValues();},_setInitialCookieValues:function(){var d={};if(!this._bAlreadyRequestedCookiesApproval){d[this._oCookieNames.ALLOW_REQUIRED_COOKIES]="1";d[this._oCookieNames.ALLOW_USAGE_TRACKING]="1";}else{d[this._oCookieNames.ALLOW_REQUIRED_COOKIES]=this._oConfigUtil.getCookieValue(this._oCookieNames.ALLOW_REQUIRED_COOKIES);d[this._oCookieNames.ALLOW_USAGE_TRACKING]=this._oConfigUtil.getCookieValue(this._oCookieNames.ALLOW_USAGE_TRACKING);}this._oModel.setData(d,true);},_focusButton:function(b){if(b.$().length){b.$().focus();return;}b.addEventDelegate({"onAfterRendering":function(){b.$().focus();b.removeEventDelegate(this);}});}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/Downloads.controller',["sap/ui/documentation/sdk/controller/BaseController"],function(B){"use strict";return B.extend("sap.ui.documentation.sdk.controller.Downloads",{onInit:function(){this.getRouter().getRoute("downloads").attachPatternMatched(this._onMatched,this);},_onMatched:function(){this.hideMasterSide();}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/Entity.controller',["sap/ui/model/json/JSONModel","sap/ui/documentation/sdk/controller/BaseController","sap/ui/documentation/sdk/controller/util/ControlsInfo","sap/ui/documentation/sdk/controller/util/EntityInfo","sap/ui/documentation/sdk/controller/util/APIInfo","sap/ui/documentation/sdk/util/ToggleFullScreenHandler","sap/ui/documentation/sdk/controller/util/JSDocUtil","sap/m/Label","sap/m/Link","sap/m/Text","sap/m/HBox","sap/m/ObjectAttribute"],function(J,B,C,E,A,T,a,L,b,c,H,O){"use strict";return B.extend("sap.ui.documentation.sdk.controller.Entity",{onInit:function(){this.router=this.getRouter();this.router.getRoute("entity").attachPatternMatched(this.onRouteMatched,this);this._oObjectPage=this.byId("ObjectPageLayout");this.getView().setModel(new J());},onTypeLinkPress:function(e){var t=e.getSource().data("type");this.getRouter().navTo("entity",{id:t},false);},onAPIRefPress:function(e){var s=e.getSource().data("name");this.getRouter().navTo("apiId",{id:s},false);},onTabSelect:function(e){var t=e.getParameter("key");this.router.navTo("entity",{id:this._sId,part:t},true);},onNavToSample:function(e){var p=e.getSource().getBindingContext().getPath(),s=this.getView().getModel().getProperty(p);this.router.navTo("sample",{entityId:this._sNewId,sampleId:s.id});},_wrapInSpanTag:function(t){var f=a.formatTextBlock(t,{linkFormatter:function(s,t){var r="entity",d,m,p;t=t||s;if(s.match("://")){return'<a target="_blank" href="'+s+'">'+t+'</a>';}s=s.trim().replace(/\.prototype\./g,"#");p=s.indexOf("#");if(p===0){return"<code>"+s.slice(1)+"</code>";}else if(p>0){s=s.slice(0,p);}m=s.match(/^topic:(\w{32})$/);if(m){s=m[1];r="topic";}d=s.split('/');if(d.length>1&&["methods","events"].indexOf(d[1].toLowerCase())!==-1){r="api";}return'<a class="jsdoclink" href="'+r+'/'+s+'">'+t+'</a>';}});return'<span class="sapUiJSD">'+f+'</span>';},_TAB_KEYS:["samples","about"],_loadSample:function(o){var n=this._sNewId;var f=o.entities.filter(function(g){return g.id===n;});var e=f.length?f[0]:undefined;function u(){if(this._TAB_KEYS.indexOf(this._sNewTab)===-1){this._sNewTab="samples";}if(!d.show[this._sNewTab]){this._sNewTab="samples";}this._switchPageTab();setTimeout(function(){this._oObjectPage.setBusy(false);}.bind(this),0);}var d,v=this.getView();if(this._sId!==n){E.getEntityDocuAsync(n,e&&e.library).then(function(D){if(!e&&!D){this.router.myNavToWithoutHash("sap.ui.documentation.sdk.view.NotFound","XML",false);return;}d=this._getViewData(n,D,e,o);this.getAPIReferenceCheckPromise(d.name).then(function(h){d.bHasAPIReference=h;this._buildHeaderLayout(d);}.bind(this));v.getModel().setData(d,false);this._sId=n;u.call(this);}.bind(this));}else{d=this.getView().getModel().getData();u.call(this);}},onRouteMatched:function(e){this._oObjectPage.setBusy(true);this._sNewId=e.getParameter("arguments").id;this._sNewTab=e.getParameter("arguments").sectionTab;C.loadData().then(function(d){this._loadSample(d);}.bind(this));this.searchResultsButtonVisibilitySwitch(this.byId("entityBackToSearch"));},onToggleFullScreen:function(e){T.updateMode(e,this.getView(),this);},_getViewData:function(i,d,e,o){var D=this._convertEntityInfo(i,d,o),s=false,S=0;D.show.introLink=false;if(e){if(!D.shortDescription&&e.description){D.shortDescription=e.description;}if(!D.baseName){D.baseName=e.name;}if(e.docuLink){D.show.introLink=true;D.docuLink=e.docuLink.replace("docs/guide","topic").replace(/\.html$/,"");D.docuLinkText=D.baseName;}s=e.samples.length>0;S=e.samples.length;}D.show.samples=s;D.count.samples=S;D.entity=e;if(d){if(d.docuLink){D.show.introLink=true;D.docuLink="topic/"+d.docuLink;D.docuLinkText=d.docuLinkText;}D.uxGuidelinesLink=d.uxGuidelinesLink;D.uxGuidelinesLinkText=d.uxGuidelinesLinkText;}return D;},_convertEntityInfo:function(i,d,o){var D={name:i,deprecated:(d)?this._formatDeprecated(d.deprecation):null,deprecatedMark:(d)?this._createDeprecatedMark(d.deprecation):null,baseType:(d)?this._formatType(d.baseType):null,baseTypeText:(d)?this._formatTypeText(d.baseType):"-",baseTypeNav:(d)?this._formatTypeNav(d.baseType):null,shortDescription:(d)?this._formatDeprecatedDescription(d.deprecation):null,description:(d)?this._wrapInSpanTag(d.doc):null,docuLink:null,docuLinkText:null,uxGuidelinesLink:null,uxGuidelinesLinkText:null,values:d?d.values:[],show:{baseType:(d)?!!d.baseType:false,about:!!d,values:false,introActive:false},count:{samples:0},appComponent:this._getControlComponent(i,o)};if(!d){return D;}D.show.values=Array.isArray(D.values)&&D.values.length>0;return D;},_formatDeprecated:function(d){return(d&&d.length>0)?"true":"false";},_formatDeprecatedDescription:function(d){return(d&&d.length>0)?(this._createDeprecatedMark(d)+": "+d):null;},_formatType:function(t){if(!t){return null;}else{return t.replace("[]","");}},_formatTypeText:function(t){if(!t){return null;}else{t=t.replace("sap.ui.core.","");var i=t.lastIndexOf(".");return(i!==-1)?t.substr(i+1):t;}},_createDeprecatedMark:function(d){var r=this.getModel("i18n").getResourceBundle();return(d)?r.getText("ENTITY_DEPRECATED"):"";},_switchPageTab:function(){var s=this.byId(this._sNewTab);if(!s){return;}if(this._oObjectPage){this._oObjectPage.attachEvent("onAfterRenderingDOMReady",function(){this._oObjectPage.setSelectedSection(s.getId());},this);}},_getHeaderLayoutUtil:function(){var r;if(!this._oHeaderLayoutUtil){var _=function(t,s){return new O({title:t,text:s}).addStyleClass("sapUiTinyMarginBottom");},d=function(o){return new b(o||{});},e=function(o){return new c(o||{});},f=function(o){return new L(o||{});},g=function(o,h){var i=new H(o||{});if(h){i.addStyleClass("sapUiDocumentationHeaderNavLinks sapUiTinyMarginBottom");}return i;};r=this.getModel("i18n").getResourceBundle();this._oHeaderLayoutUtil={_getApiReferenceBlock:function(D){return g({items:[f({design:"Bold",text:r.getText("ENITITY_API")}),d({emphasized:true,text:D.name,href:"api/"+D.name})]},true);},_getDocumentationBlock:function(D){return g({items:[f({design:"Bold",text:r.getText("ENTITY_DOCUMENTATION")}),d({emphasized:true,text:D.docuLinkText,href:D.docuLink})]},true);},_getUXGuidelinesBlock:function(D){return g({items:[f({design:"Bold",text:r.getText("ENTITY_UX")}),d({emphasized:true,text:D.uxGuidelinesLinkText,href:D.uxGuidelinesLink,target:"_blank"})]},true);},_getExtendsBlock:function(D){return g({items:[f({text:r.getText("ENTITY_EXTENDS")}),d({text:D.baseTypeText,href:"entity/"+D.baseType,visible:!!D.baseTypeNav}),e({text:"N/A",visible:!D.baseTypeNav||!D.baseType})]},true);},_getApplicationComponentBlock:function(D){return _(r.getText("ENTITY_COMPONENT"),D.appComponent);},_getAvailableSinceBlock:function(D){return _(r.getText("ENTITY_SINCE"),D.entity.since);},_getCategoryBlock:function(D){return _(r.getText("ENTITY_CATEGORY"),D.entity.category);},_getContentDensityBlock:function(D){return _(r.getText("ENTITY_DENSITY"),D.entity.formFactors);}};}return this._oHeaderLayoutUtil;},backToSearch:function(){this.onNavBack();},_buildHeaderLayout:function(d){var F=0,S=1,e=2,f=3,h=[[],[],[]],o=this._getHeaderLayoutUtil(),g=[{creator:"_getApiReferenceBlock",exists:d.bHasAPIReference},{creator:"_getDocumentationBlock",exists:d.show.introLink},{creator:"_getUXGuidelinesBlock",exists:!!d.uxGuidelinesLink},{creator:"_getExtendsBlock",exists:true},{creator:"_getApplicationComponentBlock",exists:true},{creator:"_getAvailableSinceBlock",exists:true},{creator:"_getCategoryBlock",exists:true},{creator:"_getContentDensityBlock",exists:true}],i=function(){var j=0,I,G=function(j){if(j<=f){return F;}else if(j<=f*2){return S;}return e;};g.forEach(function(k){var l;if(k.exists){l=o[k.creator].call(this,d);I=G(++j);h[I].push(l);}},this);}.bind(this);i();h.forEach(function(j,I){var v=this.byId("headerColumn"+I);v.removeAllContent();if(j.length>0){v.setVisible(true);j.forEach(v.addContent,v);}},this);},_baseTypes:["sap.ui.core.any","sap.ui.core.object","sap.ui.core.function","sap.ui.core.number","sap.ui.core.float","sap.ui.core.int","sap.ui.core.boolean","sap.ui.core.string","sap.ui.core.URI","sap.ui.core.ID","sap.ui.core.void","sap.ui.core.CSSSize","any","object","function","float","int","boolean","string"],_formatTypeNav:function(t){return this._baseTypes.indexOf(t)===-1;}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/ErrorHandler',["sap/ui/base/Object","sap/m/MessageBox"],function(U,M){"use strict";return U.extend("sap.ui.documentation.sdk.controller.ErrorHandler",{constructor:function(c){this._oComponent=c;this._oModel=c.getModel();this._bMessageOpen=false;this._sErrorText="Sorry, a technical error occurred! Please try again later.";},_showMetadataError:function(d){M.error(this._sErrorText,{id:"metadataErrorMessageBox",details:d,styleClass:this._oComponent.getContentDensityClass(),actions:[M.Action.RETRY,M.Action.CLOSE],onClose:function(a){if(a===M.Action.RETRY){this._oModel.refreshMetadata();}}.bind(this)});},_showServiceError:function(d){if(this._bMessageOpen){return;}this._bMessageOpen=true;M.error(this._sErrorText,{id:"serviceErrorMessageBox",details:d,styleClass:this._oComponent.getContentDensityClass(),actions:[M.Action.CLOSE],onClose:function(){this._bMessageOpen=false;}.bind(this)});}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/Group.controller',["sap/ui/documentation/sdk/controller/BaseController"],function(B){"use strict";return B.extend("sap.ui.documentation.sdk.controller.Group",{onInit:function(){this.getRouter().getRoute("group").attachPatternMatched(this._onGroupMatched,this);},_onGroupMatched:function(e){this._id=e.getParameter("arguments").id;}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/LiveEditor.controller',["sap/ui/documentation/sdk/controller/BaseController","sap/m/library","sap/ui/model/json/JSONModel","sap/ui/thirdparty/URI","sap/uxap/ThrottledTaskHelper"],function(B,m,J,U,T){"use strict";var S={HTML:"index.html",XML:"App.view.xml",INDEX_JS:"index.js",CONTROLLER_JS:"App.controller.js"},a="HelloWorld",g=function(f){return a+"/"+f;},b={};b[S.HTML]="text";b[S.XML]="xml";b[S.INDEX_JS]="javascript";b[S.CONTROLLER_JS]="javascript";return B.extend("sap.ui.documentation.sdk.controller.LiveEditor",{onInit:function(){this._oSrcFileContent={};this._oViewModel=new J({autoPreview:true,selectedFileName:S.XML,selectedFileType:b[S.XML],selectedFileContent:""});this.getView().setModel(this._oViewModel,"viewModel");new J(sap.ui.require.toUrl('sap/ui/documentation/sdk/model/LiveEditorData.json')).attachRequestCompleted(function(e){var d=e.getSource().getData(),c=new U(sap.ui.require.toUrl("sap-ui-core.js"),document.baseURI).href();if(d[S.HTML]){d[S.HTML]=d[S.HTML].replace(/&sol;/g,"/").replace("resources/sap-ui-core.js",c);}this._oSrcFileContent=d;this.showFileInEditor(S.XML);}.bind(this));this.getView().byId("resultBox").addEventDelegate({onAfterRendering:this.requestExecuteCurrentSrc.bind(this)});this._bSuppressRemoveOnce=false;this._bSuppressInsertOnce=false;this._oThrottledTask=null;},onSrcLiveChange:function(e){var t=e.getParameter("value"),A=e.getParameter("editorEvent").action,s;if((this._bSuppressRemoveOnce===true)&&(A==="remove")){this._bSuppressRemoveOnce=false;return;}if((this._bSuppressInsertOnce===true)&&(A==="insert")){this._bSuppressInsertOnce=false;return;}s=this._oViewModel.getProperty("/selectedFileName");this._oSrcFileContent[s]=t;if(this._oViewModel.getProperty("/autoPreview")){this.requestExecuteCurrentSrc();}},requestExecuteCurrentSrc:function(){this._getExecuteSrcThrottledTask().reSchedule(false,{}).catch(function(r){});},createFrame:function(){var f=document.createElement("iframe");f.id="outputWindow";f.width="100%";f.className="editorOutputWindow";f.src=sap.ui.require.toUrl('sap/ui/documentation/sdk/util/liveEditorOutput.html');f.sandbox="allow-forms allow-modals allow-pointer-lock allow-popups allow-scripts";return f;},onFileSwitch:function(e){var s=e.getParameter("selectedKey");this._bSuppressRemoveOnce=true;this._bSuppressInsertOnce=true;this.showFileInEditor(s);},showFileInEditor:function(s){this._oViewModel.setProperty("/selectedFileContent",this._oSrcFileContent[s]);this._oViewModel.setProperty("/selectedFileType",b[s]);},_getDataToPost:function(){var M={},i=g(S.INDEX_JS).slice(0,-3),n,N;Object.keys(S).forEach(function(k){N=S[k];n=g(N);M[n]=this._oSrcFileContent[N];},this);return{src:M,moduleNameToRequire:i};},_getExecuteSrcThrottledTask:function(){var e;if(!this._oThrottledTask){e=function(){var f=this.getView().byId('outputWindowWrapper').getDomRef(),F;if(f){while(f.firstChild){f.removeChild(f.firstChild);}F=this.createFrame();F.onload=function(){if(F.contentWindow){F.contentWindow.postMessage(this._getDataToPost(),"*");F.onload=null;}}.bind(this);f.appendChild(F);}};this._oThrottledTask=new T(e,500,this);}return this._oThrottledTask;}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/MasterTreeBaseController',["sap/ui/thirdparty/jquery","./BaseController","./util/TreeUtil","sap/ui/model/Filter","sap/ui/model/FilterOperator"],function(q,B,T,F,a){"use strict";var b=300;
var M=B.extend("sap.ui.documentation.sdk.controller.MasterTreeBaseController",{
_initTreeUtil:function(n,d){this._oTreeUtil=new T(n,d);},
_expandTreeToNode:function(t,m){var o=this.byId("tree"),d=m.getData();var e=this._oTreeUtil.getPathToNode(t,d);var l;e.forEach(function(i){var I=this._findTreeItem(i);if(I){o.getBinding("items").expand(o.indexOfItem(I));l=I;}},this);if(l){l.setSelected(true);this.oSelectedItem={sTopicId:t,oModel:m};setTimeout(function(){if(l.getDomRef()&&!c(l.getDomRef())){this._scrollTreeItemIntoView(l);}}.bind(this),0);}},
_findTreeItem:function(I){var o=this.byId("tree").getItems();for(var i=0;i<o.length;i++){if(o[i].getTarget()===I){return o[i];}}return null;},
_scrollTreeItemIntoView:function(i){var p=this.byId("page");p.scrollToElement(i.getDomRef(),b);},
onTreeFilter:function(e){this._sFilter=e.getParameter("newValue").trim();if(this._filterTimeout){clearTimeout(this._filterTimeout);}this._filterTimeout=setTimeout(function(){if(this.buildAndApplyFilters()){this._expandAllNodes();}else{this._collapseAllNodes();if(this.oSelectedItem){this._expandTreeToNode(this.oSelectedItem.sTopicId,this.oSelectedItem.oModel);}}this._filterTimeout=null;}.bind(this),250);},
buildAndApplyFilters:function(){var o=this.byId("tree").getBinding("items");if(this._sFilter){o.filter(new F({path:"name",operator:a.Contains,value1:this._sFilter}));return true;}else{o.filter();return false;}},
_expandAllNodes:function(){this.byId("tree").expandToLevel(10);},
_collapseAllNodes:function(){this.byId("tree").collapseAll();},
_clearSelection:function(){var i=this.byId("tree").getItems();if(i.length){i[0].setSelected(false);}},
onTreeExpandAll:function(e){this._expandAllNodes();},
onTreeCollapseAll:function(e){this._collapseAllNodes();}
});
function c(d){var r=d.getBoundingClientRect();return(r.top>=0&&r.left>=0&&r.bottom<=q(document).height()&&r.right<=q(document).width());}
return M;});
sap.ui.predefine('sap/ui/documentation/sdk/controller/NotFound.controller',["./BaseController"],function(B){"use strict";return B.extend("sap.ui.documentation.sdk.controller.NotFound",{});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/ReleaseNotes.controller',["sap/ui/thirdparty/jquery","sap/ui/documentation/sdk/controller/BaseController","sap/ui/model/json/JSONModel","sap/ui/documentation/library","sap/base/util/Version","sap/base/Log"],function(q,B,J,l,V,L){"use strict";var n="neo-app.json",s="resources/sap-ui-version.json";return B.extend("sap.ui.documentation.sdk.controller.ReleaseNotes",{onInit:function(){this._oView=this.getView();this._requestResources();this._resourceAvailabilityHandler();this._oModel=new J();this._oVersionModel=new J();this._oView.setModel(this._oModel);this._oView.setModel(this._oVersionModel,"select");l._getAppInfo(this._processAppInfo.bind(this));},_processAppInfo:function(a){var v,m,M,b,o;if(!(a)){return;}v=V(a.version);m=v.getMajor();M=v.getMinor();if(v.getSuffix()!==""){if(M%2!==0){M=(M+1);}}b=m+"."+M;this._updateVersionInformation(b);o={items:[]};while(M>=28){b=m+"."+M;o.items.push({key:b,value:b});M=M-(M<=60?2:1);}this._oVersionModel.setData(o);},_processLibInfo:function(c,o){var r,R=[],d=c.length,p,i;p=function(v,e){r+=e.notes.length;c[i].versions.push({version:v,notes:e.notes});c[i].versions.sort(function(a,b){return V(b.version).compareTo(a.version);});};for(i=0;i<d;i++){c[i]=o[c[i]];c[i].versions=[];if(c[i].relnotes){r=0;q.each(c[i].relnotes,p);if(r>0){R.push(c[i]);}}}this._oModel.setData({libs:R});this._hideBusyIndicator();},_requestResources:function(){this._oNeoAppJsonPromise=q.ajax(n);this._oSapUiVersionJsonPromise=q.ajax(s);},_resourceAvailabilityHandler:function(){q.when(this._oNeoAppJsonPromise,this._oSapUiVersionJsonPromise).then(function(N,S){this._oNeoAppVersions=N[0].routes;this._sSapUiVersion=S[0].version;this._oView.byId("VersionSelect").setVisible(true);}.bind(this),function(){L.warning("No neo-app.json was detected");});},_compareUI5Versions:function(v,a){var o=V(v),b=V(a);return(o.getMajor()+"."+o.getMinor())===(b.getMajor()+"."+b.getMinor());},_updateLastReleasedVersion:function(v){if(this._compareUI5Versions(v,this._sSapUiVersion)&&parseFloat(this._sLastReleasedVersion)>parseFloat(this._sSapUiVersion)){this._sLastReleasedVersion=this._sSapUiVersion;}},_getLastVersionFromNeoAppJson:function(S){var a=this._oNeoAppVersions?this._oNeoAppVersions.length:0,v,i;for(i=0;i<a;i++){v=this._oNeoAppVersions[i].target.version;if(this._compareUI5Versions(v,S)){return v;}}},handleVersionChange:function(e){var i=e.getParameter("selectedItem"),S=i.getKey();this._updateVersionInformation(S);},_updateVersionInformation:function(S){var v;this._sLastReleasedVersion=this._getLastVersionFromNeoAppJson(S);this._updateLastReleasedVersion(S);v=this._sLastReleasedVersion?this._sLastReleasedVersion:S;this._showBusyIndicator();l._loadAllLibInfo("","_getLibraryInfoAndReleaseNotes",v,this._processLibInfo.bind(this));},_showBusyIndicator:function(){this.byId("releaseNotesObjectPage").setBusy(true);},_hideBusyIndicator:function(){this.byId("releaseNotesObjectPage").setBusy(false);}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/Sample.controller',["sap/ui/thirdparty/jquery","sap/ui/documentation/sdk/controller/SampleBaseController","sap/ui/model/json/JSONModel","sap/ui/core/Component","sap/ui/core/ComponentContainer","sap/ui/documentation/sdk/controller/util/ControlsInfo","sap/ui/documentation/sdk/util/ToggleFullScreenHandler","sap/m/Text","sap/ui/core/HTML","sap/m/library","sap/base/Log","sap/ui/core/Fragment"],function(q,S,J,C,a,b,T,c,H,m,L,F){"use strict";var U=m.URLHelper;return S.extend("sap.ui.documentation.sdk.controller.Sample",{onInit:function(){S.prototype.onInit.call(this);this.getRouter().getRoute("sample").attachPatternMatched(this._onSampleMatched,this);this.oModel=new J({showNavButton:true,showNewTab:false,rtaLoaded:false});this._sId=null;this._sEntityId=null;Promise.all([sap.ui.getCore().loadLibrary("sap.ui.fl",{async:true}),sap.ui.getCore().loadLibrary("sap.ui.rta",{async:true})]).then(this._loadRTA.bind(this));this.getView().setModel(this.oModel);},_onSampleMatched:function(e){this._sId=e.getParameter("arguments").sampleId;this._sEntityId=e.getParameter("arguments").entityId;this.byId("page").setBusy(true);this.getModel("appView").setProperty("/bHasMaster",false);b.loadData().then(this._loadSample.bind(this));},_loadSample:function(d){var p=this.byId("page"),M=this.oModel.getData(),s=d.samples[this._sId],o,e;if(!s){setTimeout(function(){p.setBusy(false);},0);this.getRouter().myNavToWithoutHash("sap.ui.documentation.sdk.view.NotFound","XML",false);return;}this.entityId=this._sEntityId?this._sEntityId:s.entityId;M.sEntityId=this.entityId;if(s.previousSampleId||s.nextSampleId){M.previousSampleId=s.previousSampleId;M.nextSampleId=s.nextSampleId;}if(s.contexts){o=s.contexts[this.entityId];if(o){M.previousSampleId=o.previousSampleId;M.nextSampleId=o.nextSampleId;}else{this.getRouter().myNavToWithoutHash("sap.ui.documentation.sdk.view.NotFound","XML",false);return;}}M.title="Sample: "+s.name;try{e=this._createComponent();}catch(f){p.removeAllContent();p.addContent(new c({text:"Error while loading the sample: "+f}));setTimeout(function(){p.setBusy(false);},0);return;}this.getOwnerComponent()._oCurrentOpenedSample=e?e:undefined;var g=(this._oComp.getMetadata())?this._oComp.getMetadata().getConfig():null;var h=g&&g.sample||{};M.showNewTab=!!h.iframe;M.id=s.id;M.name=s.name;M.details=s.details;M.description=s.description;if(h){M.stretch=h.stretch;M.includeInDownload=h.additionalDownloadFiles;if(h.files){var r=sap.ui.require.toUrl((s.id).replace(/\./g,"/"));M.files=[];for(var i=0;i<h.files.length;i++){var j=h.files[i];M.files.push({name:j});this._updateFileContent(r,j);}}if(h.iframe){e=this._createIframe(e,h.iframe);}else{this.sIFrameUrl=null;}}M.iframe=h.iframe;var k=!!h.stretch;var l=k?"100%":null;p.setEnableScrolling(!k);if(e.setHeight){e.setHeight(l);}p.removeAllContent();p.addContent(e);p.scrollTo(0);this.getAPIReferenceCheckPromise(s.entityId).then(function(n){this.getView().byId("apiRefButton").setVisible(n);}.bind(this));this.oModel.setData(M);setTimeout(function(){p.setBusy(false);},0);},_updateFileContent:function(r,f){this.fetchSourceFile(r+"/"+f).then(function(v){var d=this.oModel.getProperty("/files");d.some(function(o){if(o.name===f){o.raw=v;return true;}});this.oModel.setProperty("/files",d);}.bind(this));},onAPIRefPress:function(){this.getRouter().navTo("apiId",{id:this.entityId});},onNewTab:function(){U.redirect(this.sIFrameUrl,true);},onPreviousSample:function(e){this.getRouter().navTo("sample",{entityId:this.entityId,sampleId:this.oModel.getProperty("/previousSampleId")});},onNextSample:function(e){this.getRouter().navTo("sample",{entityId:this.entityId,sampleId:this.oModel.getProperty("/nextSampleId")});},onInfoSample:function(e){var B=e.getSource();if(!this._oPopover){F.load({name:"sap.ui.documentation.sdk.view.samplesInfo",controller:this}).then(function(p){this.getView().addDependent(p);this._oPopover=p;this._oPopover.openBy(B);}.bind(this));}else{this._oPopover.openBy(B);}},_resolveIframePath:function(s,I){var d=I.split("/"),i;for(i=0;i<d.length-1;i++){if(d[i]==".."){s=s.substring(0,s.lastIndexOf("."));}else{s+="."+d[i];}}return s;},_createIframe:function(i,I){var s=this._sId,d="",r=/\/([^\/]*)$/,e=/\..+$/,f,g,h;if(typeof I==="string"){d=this._resolveIframePath(s,I);f=r.exec(I);g=(f&&f.length>1?f[1]:I);h=e.exec(g)[0];var j=g.replace(e,"");this.sIFrameUrl=sap.ui.require.toUrl((d+"/"+j).replace(/\./g,"/"))+h||".html";}else{L.error("no iframe source was provided");return;}if(!this._oHtmlControl){this._oHtmlControl=new H({id:"sampleFrame",content:'<iframe src="'+this.sIFrameUrl+'" id="sampleFrame" frameBorder="0"></iframe>'}).addEventDelegate({onAfterRendering:function(){if(!this._oHtmlControl._jQueryHTMLControlLoadEventAttached){this._oHtmlControl.$().on("load",function(){var o=this._oHtmlControl.$()[0].contentWindow,k=o.sap.ui.getCore();o.sap.ui.getCore().attachInit(function(){var l=q(document.body).hasClass("sapUiSizeCompact");k.applyTheme(this._oCore.getConfiguration().getTheme());k.getConfiguration().setRTL(this._oCore.getConfiguration().getRTL());o.jQuery('body').toggleClass("sapUiSizeCompact",l).toggleClass("sapUiSizeCozy",!l);k.notifyContentDensityChanged();}.bind(this));}.bind(this));this._oHtmlControl._jQueryHTMLControlLoadEventAttached=true;}}.bind(this)});}else{this._oHtmlControl.getDomRef().src=this.sIFrameUrl;}return this._oHtmlControl;},_createComponent:function(){var s='sampleComp-'+this._sId;var d=this._sId;var M=this.getOwnerComponent();this._oComp=sap.ui.component(s);if(this._oComp){this._oComp.destroy();}return M.runAsOwner(function(){this._oComp=sap.ui.getCore().createComponent({id:s,name:d});return new a({component:this._oComp});}.bind(this));},onNavBack:function(e){this.getRouter().navTo("entity",{id:this.entityId});},onNavToCode:function(e){this.getRouter().navTo("code",{entityId:this.entityId,sampleId:this._sId},false);},onToggleFullScreen:function(e){T.updateMode(e,this.getView(),this);},_oRTA:null,_loadRTA:function(){sap.ui.require(["sap/ui/fl/Utils","sap/ui/fl/FakeLrepConnectorLocalStorage","sap/ui/core/util/reflection/JsControlTreeModifier"],function(d,e,f){var M=this.oModel.getData();f.checkControlId=function(){return true;};d.checkControlId=function(){return true;};e.enableFakeConnector({"isProductiveSystem":true});M.rtaLoaded=true;this.oModel.setData(M);this.getRouter().attachRouteMatched(function(){if(this._oRTA){this._oRTA.destroy();this._oRTA=null;}},this);}.bind(this));},onToggleAdaptationMode:function(e){sap.ui.require(["sap/ui/rta/RuntimeAuthoring"],function(R){if(!this._oRTA){this._oRTA=new R({rootControl:this.byId("page").getContent()[0],flexSettings:{developerMode:false}});this._oRTA.attachStop(function(){this._oRTA.destroy();delete this._oRTA;}.bind(this));this._oRTA.start();}}.bind(this));}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/SearchPage.controller',["sap/ui/thirdparty/jquery","sap/ui/documentation/sdk/controller/BaseController","sap/ui/documentation/sdk/controller/util/SearchUtil","sap/ui/documentation/sdk/controller/util/Highlighter","sap/ui/model/json/JSONModel","sap/m/GroupHeaderListItem","sap/base/Log"],function(q,B,S,H,J,G,L){"use strict";var A={"properties":"controlProperties","fields":"properties","aggregations":"aggregations","associations":"associations","events":"events","specialSettings":"specialsettings","annotations":"annotations","methods":"methods"},a={"properties":"property","fields":"field","aggregations":"aggregation","associations":"association","events":"event","specialSettings":"specialsetting","annotations":"annotation","methods":"method"};return B.extend("sap.ui.documentation.sdk.controller.SearchPage",{onInit:function(){this.setModel(new J());this.bindListResults();this.getRouter().getRoute("search").attachPatternMatched(this._onTopicMatched,this);},bindListResults:function(){this.dataObject={data:[]};this.getModel().setData(this.dataObject);},onAfterRendering:function(){var c={useExternalStyles:false,shouldBeObserved:true,isCaseSensitive:false};if(!this.highlighter){this.highlighter=new H(this.getView().getDomRef(),c);}},onExit:function(){this.highlighter.destroy();},_onTopicMatched:function(b){var Q=decodeURIComponent(b.getParameter("arguments").searchParam),l=this.byId("allList");this.dataObject.searchTerm=Q;this._modelRefresh();try{this.hideMasterSide();}catch(e){L.error(e);}l.setBusy(true);S.search(Q).then(function(r){this.processResult(r,Q);l.setBusy(false);}.bind(this));},processResult:function(d,Q){this.dataObject.data=[];this.dataObject.dataAPI=[];this.dataObject.dataDoc=[];this.dataObject.dataExplored=[];this.dataObject.AllLength=0;this.dataObject.APILength=0;this.dataObject.DocLength=0;this.dataObject.ExploredLength=0;if(d&&d.success){if(d.totalHits==0){q(".sapUiRrNoData").html("No matches found.");}else{for(var i=0;i<d.matches.length;i++){var m=d.matches[i],D=m.doc;D.modifiedStr=D.modified+"";var M=D.modifiedStr.substring(0,4)+"/"+D.modifiedStr.substring(4,6)+"/"+D.modifiedStr.substring(6,8)+", "+D.modifiedStr.substring(8,10)+":"+D.modifiedStr.substring(10),t=D.title,s=D.summary,n=D.path,b=false,c;if(D.category==="topics"){n=n.substring(0,n.lastIndexOf(".html"));b=true;c="Documentation";this.dataObject.dataDoc.push({index:this.dataObject.DocLength,title:t?t:"Untitled",path:n,summary:s||"",score:D.score,modified:M,category:c});this.dataObject.DocLength++;}else if(D.category==="entity"){b=true;c="Samples";this.dataObject.dataExplored.push({index:this.dataObject.ExploredLength,title:t?t+" (samples)":"Untitled",path:n,summary:s||"",score:D.score,modified:M,category:c});this.dataObject.ExploredLength++;}else if(D.category==='apiref'){n=this._formatApiRefURL(m);t=this._formatApiRefTitle(m);s=this._formatApiRefSummary(m);b=true;c="API Reference";this.dataObject.dataAPI.push({index:this.dataObject.APILength,title:t,path:n,summary:s||"",score:D.score,modified:M,category:c});this.dataObject.APILength++;}if(b){this.dataObject.data.push({index:i,title:t?t:"Untitled",path:n,summary:s||"",score:D.score,modified:M,category:c});this.dataObject.AllLength++;}}}}else{q(".sapUiRrNoData").html("Search failed, please retry ...");}this._modelRefresh();this.highlighter.highlight(Q);},_formatApiRefURL:function(m){var e=m.matchedDocField,E=m.doc.title,s=A[e],u;u="api/"+E;if(s){u+="#"+s;}if(e==="methods"){u+="/"+m.matchedDocWord;}return u;},_formatApiRefTitle:function(m){var d=m.doc,M=a[m.matchedDocField],s=m.matchedDocWord;if(M&&s){return s+" ("+M+")";}if(d.kind){return d.title+" ("+d.kind+")";}return d.title;},_formatApiRefSummary:function(m){var d=m.doc,M=a[m.matchedDocField],s=m.matchedDocWord,b=M&&s;if(b){return d.title;}return d.summary;},formatTableTitle:function(p,v,i){var V=i>0?"1 - "+v:"0";return this.formatMessage(p,V,i);},_modifyLinks:function(){var v=this.getView(),i=[].concat(v.byId("allList").getItems(),v.byId("apiList").getItems(),v.byId("documentationList").getItems(),v.byId("samplesList").getItems()),l=i.length,I;while(l--){I=i[l];if(I._getLinkSender){I._getLinkSender().setHref(I.getCustomData()[0].getValue());}}},_modelRefresh:function(){this.getModel().refresh();this._modifyLinks();},getGroupHeader:function(g){return new G({title:g.key,upperCase:false});},categoryAPIFormatter:function(c){return c==="API Reference";},categoryDocFormatter:function(c){return c==="Documentation";},categoryExploredFormatter:function(c){return c==="Samples";},onAllLoadMore:function(e){this.dataObject.visibleAllLength=e.getParameter("actual");this._modelRefresh();},onAPILoadMore:function(e){this.dataObject.visibleAPILength=e.getParameter("actual");this._modelRefresh();},onDocLoadMore:function(e){this.dataObject.visibleDocLength=e.getParameter("actual");this._modelRefresh();},onExploredLoadMore:function(e){this.dataObject.visibleExploredLength=e.getParameter("actual");this._modelRefresh();}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/SubApiDetail.controller',["sap/ui/thirdparty/jquery","sap/ui/documentation/sdk/controller/BaseController","sap/ui/model/json/JSONModel","sap/ui/documentation/sdk/controller/util/ControlsInfo","sap/ui/documentation/sdk/util/ToggleFullScreenHandler","sap/ui/documentation/sdk/controller/util/APIInfo","sap/ui/documentation/sdk/model/formatter","sap/m/Image","sap/m/Label","sap/m/Link","sap/m/Text","sap/m/HBox","sap/m/ObjectAttribute","sap/m/Popover","sap/m/library"],function(q,B,J,C,T,A,f,I,L,a,b,H,O,P,l){"use strict";var F=l.FlexWrap;return B.extend("sap.ui.documentation.sdk.controller.SubApiDetail",{NOT_AVAILABLE:'N/A',SECTION_MAP:{"properties":"controlProperties","fields":"properties","special settings":"specialsettings"},formatter:f,onInit:function(){this._objectPage=this.byId("apiDetailObjectPage");},initiate:function(r){var h,c,d,o=function(i){return!i.borrowedFrom;};this._sTopicId=r.sTopicId;this._oModel=r.oModel;this._oControlData=this._oModel.getData();this._aApiIndex=r.aApiIndex;this._aAllowedMembers=r.aAllowedMembers;this._sEntityType=r.sEntityType;this._sEntityId=r.sEntityId!=="undefined"?r.sEntityId:undefined;this._oEntityData=r.oEntityData;this._oContainerController=r.oContainerController;this._oContainerView=r.oContainerView;this.getOwnerComponent=function(){return r.oOwnerComponent;};this._oRouter=this.getRouter();this._allProperties=this._oModel.getProperty("/ui5-metadata/properties");this._allAggregations=this._oModel.getProperty("/ui5-metadata/aggregations");this._allAssociations=this._oModel.getProperty("/ui5-metadata/associations");if(this._allProperties){this._selfProperties=this._allProperties.filter(o);h=this._selfProperties.length>0;this._oModel.setProperty("/bShowBorrowedProps",!h);this._oModel.setProperty("/bHasSelfProps",h);this._oModel.setProperty("/bHasBorrowedProps",this._allProperties.length>this._selfProperties.length);this._oModel.setProperty("/ui5-metadata/properties",h?this._selfProperties:this._allProperties);}if(this._allAggregations){this._selfAggregations=this._allAggregations.filter(o);c=this._selfAggregations.length>0;this._oModel.setProperty("/bShowBorrowedAggr",!c);this._oModel.setProperty("/bHasSelfAggr",c);this._oModel.setProperty("/bHasBorrowedAggr",this._allAggregations.length>this._selfAggregations.length);this._oModel.setProperty("/ui5-metadata/aggregations",c?this._selfAggregations:this._allAggregations);}if(this._allAssociations){this._selfAssociations=this._allAssociations.filter(o);d=this._selfAssociations.length>0;this._oModel.setProperty("/bShowBorrowedAssoc",!d);this._oModel.setProperty("/bHasSelfAssoc",d);this._oModel.setProperty("/bHasBorrowedAssoc",this._allAssociations.length>this._selfAssociations.length);this._oModel.setProperty("/ui5-metadata/associations",d?this._selfAssociations:this._allAssociations);}this.setModel(this._oModel);this._oEntityData.appComponent=this._oControlData.component||this.NOT_AVAILABLE;this._oEntityData.hasSample=this._oControlData.hasSample;this._oEntityData.sample=this._oControlData.hasSample?this._sTopicId:this.NOT_AVAILABLE;this._buildHeaderLayout(this._oControlData,this._oEntityData);setTimeout(function(){this._prettify();this._objectPage.attachEvent("subSectionEnteredViewPort",function(){if(this._sPrettyPrintDelayedCallID){clearTimeout(this._sPrettyPrintDelayedCallID);}this._sPrettyPrintDelayedCallID=setTimeout(function(){var $=q('.sapUxAPObjectPageContainer .APIDetailMethodsSection pre:not(.prettyprint)',this._objectPage.$());if($.length>0){$.addClass('prettyprint');window.prettyPrint();}}.bind(this),200);},this);setTimeout(function(){if(this._sEntityType){this._scrollToEntity(this._sEntityType,this._sEntityId);}setTimeout(function(){this._objectPage.attachEvent("_sectionChange",function(e){var s=e.getParameter("section"),S=e.getParameter("subSection");if(this._oNavigatingTo){if(this._oNavigatingTo===S){this._oNavigatingTo=null;}return;}this._modifyURL(s,S,false);},this);this._objectPage.attachEvent("navigate",function(e){var s=e.getParameter("section"),S=e.getParameter("subSection");this._oNavigatingTo=S;this._modifyURL(s,S,true);},this);}.bind(this),500);}.bind(this),1000);}.bind(this),0);this.searchResultsButtonVisibilitySwitch(this.byId("apiDetailBackToSearch"));},onAfterRendering:function(){this.getView().attachBrowserEvent("click",this.onJSDocLinkClick,this);},onExit:function(){this.getView().detachBrowserEvent("click",this.onJSDocLinkClick,this);},onToggleFullScreen:function(e){T.updateMode(e,this._oContainerView,this._oContainerController);},onBorrowedPropCheckboxClick:function(e){var c=e.getParameter("selected");this._oModel.setProperty("/bShowBorrowedProps",c);this._oModel.setProperty("/ui5-metadata/properties",c?this._allProperties:this._selfProperties);},onBorrowedAggrCheckboxClick:function(e){var c=e.getParameter("selected");this._oModel.setProperty("/bShowBorrowedAggr",c);this._oModel.setProperty("/ui5-metadata/aggregations",c?this._allAggregations:this._selfAggregations);},onBorrowedAssocCheckboxClick:function(e){var c=e.getParameter("selected");this._oModel.setProperty("/bShowBorrowedAssoc",c);this._oModel.setProperty("/ui5-metadata/associations",c?this._allAssociations:this._selfAssociations);},onJSDocLinkClick:function(e){var c=e.target.classList,j=c.contains("jsdoclink"),E=c.contains("sapUISDKExternalLink"),s=decodeURIComponent(e.target.getAttribute("data-target")),d;if(!j&&!E){return;}if(E){this.onDisclaimerLinkPress(e);return;}if(c.contains("scrollToMethod")){d="methods";}else if(c.contains("scrollToEvent")){d="events";}else{return;}this._scrollToEntity(d,s);},_modifyURL:function(s,S,c){var d=s.getTitle().toLowerCase(),e=(S&&S.getTitle()!=='Overview')?S.getTitle():'';if(Object.keys(this.SECTION_MAP).indexOf(d)>=0){d=this.SECTION_MAP[d];}this._oRouter.navToChangeUrlOnly({id:this._sTopicId,entityType:d,entityId:e},c);},_prettify:function(){q('.sapUxAPObjectPageContainer pre',this._objectPage.$()).addClass('prettyprint');window.prettyPrint();},scrollToMethod:function(e){this._scrollToEntity("methods",e.getSource().getText());},scrollToEvent:function(e){this._scrollToEntity("events",e.getSource().getText());},scrollToAnnotation:function(e){this._scrollToEntity("annotations",e.getSource().getText());},_scrollToEntity:function(s,S){var c,d,o;if(!s){return;}s=s.toLowerCase();o=this.byId(s);if(!o){return;}if(S){S=S.toLowerCase();d=o.getSubSections();c=d.filter(function(e){return e.getTitle().toLowerCase()===S;});if(c.length){this._objectPage.scrollToSection(c[0].getId(),250);}}else{this._objectPage.scrollToSection(o.getId(),250);}},_scrollContentToTop:function(){if(this._objectPage&&this._objectPage.$().length>0){this._objectPage.getScrollDelegate().scrollTo(0,0);}},_getHeaderLayoutUtil:function(){if(!this._oHeaderLayoutUtil){var _=function(t,s){return new O({title:t,text:s}).addStyleClass("sapUiTinyMarginBottom");},c=function(o){return new a(o||{});},d=function(o){return new b(o||{});},e=function(o){return new L(o||{});},g=function(o,h){var i=new H(o||{});if(h){i.addStyleClass("sapUiDocumentationHeaderNavLinks sapUiTinyMarginBottom");}return i;};this._oHeaderLayoutUtil={_getControlSampleBlock:function(o,E){return g({items:[e({design:"Bold",text:"Control Sample:"}),c({emphasized:true,text:E.sample,visible:!!E.hasSample,href:"entity/"+o.name}),d({text:E.sample,visible:!E.hasSample})]},true);},_getDocumentationBlock:function(o,E){return g({items:[e({design:"Bold",text:"Documentation:"}),c({emphasized:true,text:o.docuLinkText,href:"topic/"+o.docuLink})]},true);},_getUXGuidelinesBlock:function(o){return g({items:[e({design:"Bold",text:"UX Guidelines:"}),c({emphasized:true,text:o.uxGuidelinesLinkText,href:o.uxGuidelinesLink,target:"_blank"}),new I({src:"./resources/sap/ui/documentation/sdk/images/link-sap.png",tooltip:"Information published on SAP site",press:this.onDisclaimerLinkPress})]},true);},_getExtendsBlock:function(o,E){return g({items:[e({text:"Extends:"}),c({text:o.extendsText,href:"api/"+o.extendsText,visible:o.isDerived}),d({text:o.extendsText,visible:!o.isDerived})]},true);},_getSubclassesBlock:function(o,E){var s=E.extendedBy||E.implementedBy,S;this._aSubClasses=s;if(s.length===1){S=c({text:s[0],href:"api/"+s[0]});}else{S=c({text:o.isClass?"View subclasses":"View implementations",press:this._openSubclassesImplementationsPopover.bind(this)});}return g({items:[e({text:o.isClass?"Known direct subclasses:":"Known direct implementations:"}),S]},true);},_getImplementsBlock:function(o,E){var i=[e({text:"Implements:"})];o.implementsParsed.forEach(function(h){i.push(c({text:h.name,href:"api/"+h.href}));});return g({items:i,wrap:F.Wrap},true).addStyleClass("sapUiDocumentationCommaList");},_getModuleBlock:function(o,E){return _("Module",o.module);},_getLibraryBlock:function(o,E){return _("Library",E.lib);},_getVisibilityBlock:function(o,E){return _("Visibility",o.visibility);},_getAvailableSinceBlock:function(o,E){return _("Available since",o.sinceText);},_getApplicationComponentBlock:function(o,E){return _("Application Component",E.appComponent);}};}return this._oHeaderLayoutUtil;},_openSubclassesImplementationsPopover:function(e){var p=this._aSubClasses.map(function(E){return new a({text:E,href:"api/"+E}).addStyleClass("sapUiTinyMarginBottom sapUiTinyMarginEnd");}),o=this._getSubClassesAndImplementationsPopover(p);o.openBy(e.getSource());},_getSubClassesAndImplementationsPopover:function(c){var p=this._getPopover();if(p.getContent().length>0){p.destroyContent();}(c||[]).forEach(p.addContent,p);return p;},_getPopover:function(){if(!this._oPopover){this._oPopover=new P({placement:"Bottom",showHeader:false}).addStyleClass("sapUiDocumentationSubclassesPopover");}return this._oPopover;},_buildHeaderLayout:function(c,e){var d=0,S=1,g=2,E=3,h=[[],[],[]],o=this._getHeaderLayoutUtil(),s=e.extendedBy||e.implementedBy||[],i=[{creator:"_getControlSampleBlock",exists:c.isClass||c.isNamespace},{creator:"_getDocumentationBlock",exists:c.docuLink!==undefined},{creator:"_getUXGuidelinesBlock",exists:c.uxGuidelinesLink!==undefined},{creator:"_getExtendsBlock",exists:c.isClass},{creator:"_getSubclassesBlock",exists:s.length>0},{creator:"_getImplementsBlock",exists:c.hasImplementsData},{creator:"_getModuleBlock",exists:true},{creator:"_getLibraryBlock",exists:c.kind==="namespace"&&e.lib},{creator:"_getVisibilityBlock",exists:c.visibility},{creator:"_getAvailableSinceBlock",exists:true},{creator:"_getApplicationComponentBlock",exists:true}],j=function(){var k=0,m,G=function(k){if(k<=E){return d;}else if(k<=E*2){return S;}return g;};i.forEach(function(n){var p;if(n.exists){p=o[n.creator].call(this,c,e);m=G(++k);h[m].push(p);}},this);}.bind(this);j();h.forEach(function(k,m){var v=this.byId("headerColumn"+m);v.removeAllContent();if(k.length>0){v.setVisible(true);k.forEach(v.addContent,v);}},this);},onAnnotationsLinkPress:function(){this._scrollToEntity("annotations","Summary");},backToSearch:function(){this.onNavBack();}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/TermsOfUse.controller',["sap/ui/documentation/sdk/controller/BaseController"],function(B){"use strict";return B.extend("sap.ui.documentation.sdk.controller.TermsOfUse",{onInit:function(){this.oRouter=this.getRouter();this.oRouter.getRoute("termsOfUse").attachPatternMatched(this._onTopicMatched,this);},_onTopicMatched:function(e){jQuery.ajax({url:"./TermsOfUse.txt",dataType:"text"}).done(function(t){this.getView().byId("termsOfUseText").setText(t);}.bind(this)).fail(function(){this.oRouter.myNavToWithoutHash("sap.ui.documentation.sdk.view.NotFound","XML",false);}.bind(this));}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/Tools.controller',["sap/ui/Device","sap/ui/documentation/sdk/controller/BaseController","sap/base/Log","sap/ui/documentation/sdk/model/formatter"],function(D,B,L,f){"use strict";return B.extend("sap.ui.documentation.sdk.controller.Tools",{formatter:f,onInit:function(){B.prototype.onInit.call(this);this._onOrientationChange({landscape:D.orientation.landscape});this.getRouter().getRoute("tools").attachPatternMatched(this._onMatched,this);},onBeforeRendering:function(){this._deregisterOrientationChange();},onAfterRendering:function(){this._registerOrientationChange();},onExit:function(){this._deregisterOrientationChange();},_onMatched:function(){try{this.hideMasterSide();}catch(e){L.error(e);}}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/TopicDetail.controller',["jquery.sap.global","sap/ui/core/ResizeHandler","sap/ui/documentation/sdk/controller/BaseController","sap/ui/model/json/JSONModel","sap/ui/documentation/sdk/controller/util/XML2JSONUtils","sap/ui/Device","sap/ui/documentation/sdk/util/ToggleFullScreenHandler","sap/ui/documentation/sdk/util/Resources","sap/ui/documentation/sdk/controller/util/ResponsiveImageMap","sap/ui/core/HTML","sap/base/Log","sap/m/LightBox","sap/m/LightBoxItem","./util/DataTableHelper","./util/DataTable"],function(q,R,B,J,X,D,T,a,b,H,L,c,d,e,f){"use strict";var G="https://sap.github.io/openui5-docs/#/",g={SPECIAL_CHARS:/[\\\/:*\?"<>|]/g,SPACES:/\s+/g};return B.extend("sap.ui.documentation.sdk.controller.TopicDetail",{onInit:function(){var h,C;this.oPage=this.byId("topicDetailPage");this.oPage.addStyleClass('docuPage');this.oHtml=this.byId("staticContent");this.aWaitingDatatables=[];this.aResponsiveImageMaps=[];this.oLayout=this.byId("staticContentLayout");this.oHtml.attachEvent("afterRendering",this._onHtmlRendered.bind(this));this._oConfig=C=this.getConfig();this.oMatchedTopicDataTablesConfig={};if(!window.prettyPrint){q.sap.require("sap.ui.documentation.sdk.thirdparty.google-code-prettify.prettify");}q.sap.includeStyleSheet("resources/sap/ui/thirdparty/jqueryui/themes/base/jquery.ui.all.css");q.sap.includeStyleSheet("resources/sap/ui/documentation/sdk/thirdparty/DataTables/DataTables-1.10.15/css/dataTables.jqueryui.css");q.sap.includeStyleSheet("resources/sap/ui/documentation/sdk/thirdparty/DataTables/Buttons-1.4.0/css/buttons.jqueryui.css");q.sap.includeScript({url:"resources/sap/ui/documentation/sdk/thirdparty/DataTables/DataTables-1.10.15/js/jquery.dataTables.js"}).then(function(){return q.sap.includeScript({url:"resources/sap/ui/documentation/sdk/thirdparty/DataTables/DataTables-1.10.15/js/dataTables.jqueryui.js"});}).then(function(){return q.sap.includeScript({url:"resources/sap/ui/documentation/sdk/thirdparty/DataTables/Buttons-1.4.0/js/dataTables.buttons.js"});}).then(function(){return q.sap.includeScript({url:"resources/sap/ui/documentation/sdk/thirdparty/DataTables/Buttons-1.4.0/js/buttons.jqueryui.js"});}).then(function(){return q.sap.includeScript({url:"resources/sap/ui/documentation/sdk/thirdparty/DataTables/Buttons-1.4.0/js/buttons.html5.js"});}).then(function(){return q.sap.includeScript({url:"resources/sap/ui/documentation/sdk/thirdparty/DataTables/Buttons-1.4.0/js/buttons.colVis.js"});}).then(function(){h=a.getResourceOriginPath(C.docuPath+'dataTablesConfig.json');return q.ajax({url:h});}).then(function(i){this.oDataTablesConfig=i;this.bDataTablesPluginLoaded=true;this._getDataTableHelper().addMiddlewares();if(this.aWaitingDatatables.length>0){this.aWaitingDatatables.forEach(function(t){this._enableDataTable(t);},this);this.aWaitingDatatables=[];}}.bind(this));this.getRouter().getRoute("topicId").attachPatternMatched(this._onTopicMatched,this);this.getRouter().getRoute("subTopicId").attachPatternMatched(this._onTopicMatched,this);this.jsonDefModel=new J();this.getView().setModel(this.jsonDefModel);},onBeforeRendering:function(){var v=this.getView().getDomRef();if(v&&this.fnOnPageClickListener){v.removeEventListener('click',this.fnOnPageClickListener);}R.deregister(this._onResize.bind(this));D.orientation.detachHandler(this._onOrientationChange,this);},onAfterRendering:function(){var v=this.getView().getDomRef();this.fnOnPageClickListener=this._onPageClick.bind(this);if(v){v.addEventListener('click',this.fnOnPageClickListener);}R.register(this.getView().getDomRef(),this._onResize.bind(this));D.orientation.attachHandler(this._onOrientationChange,this);},onExit:function(){R.deregister(this._onResize.bind(this));D.orientation.detachHandler(this._onOrientationChange,this);},_onResize:function(){this.aResponsiveImageMaps.forEach(function(i){i.resize();});},_onPageClick:function(E){var t=E.target,C=t.classList,h=C.contains('collapsible-icon'),i=C.contains('lightbox-img'),s;if(i){this._onThumbnailClicked(t);}if(h){s=t.parentNode;s.classList.toggle("expanded");}},_onThumbnailClicked:function(t){var l=this._getLightBox(),o=l.getImageContent()[0],s=t.getAttribute('src'),h=t.getAttribute('title'),A=t.getAttribute('alt');o.setImageSrc(s);o.setTitle(h);o.setAlt(A);l.open();},_getLightBox:function(){if(!this._oLightBox){this._oLightBox=new c({imageContent:new d()});}return this._oLightBox;},_getDataTableHelper:function(){return e.getInstance();},_onHtmlResourceLoaded:function(h){var j;if(!h){setTimeout(function(){this.getRouter().myNavToWithoutHash("sap.ui.documentation.sdk.view.NotFound","XML",false);}.bind(this),0);return;}j=X.XML2JSON(h,this._oConfig);j.bIsPhone=D.system.phone;j.topicURL=this.sTopicURL;if(j.shortdesc){j.shortdesc=j.shortdesc.trim().replace(/(\r\n|\n|\r)/gm,' ');}this.jsonDefModel.setData(j);this.oHtml.setContent(j.html);this.oLayout.invalidate();this._scrollContentToTop();setTimeout(window.prettyPrint,0);this.searchResultsButtonVisibilitySwitch(this.byId("topicDetailBackToSearch"));},_onTopicMatched:function(h){var i=h.getParameter("arguments").id,u=i.split("#"),t=u[0],s=u[1];this.sTopicId=t;this.sSubTopicId=s;this.sTopicURL=a.getResourceOriginPath(this._oConfig.docuPath+t+(t.match(/\.html/)?"":".html"));this.sSubTopicId=h.getParameter("arguments").subId||s;q.ajax(this.sTopicURL).done(this._onHtmlResourceLoaded.bind(this)).fail(L.err);},_onHtmlRendered:function(){this._getDataTableHelper().destroyDatatables();var s,i=this.oPage.$().find('#d4h5-main-container .imagemap'),h=this.oPage.$().find('#d4h5-main-container table.datatable'),o=this.oLayout.getDomRef();this._fixExternalLinks(o);this._computeColumnGroupValues(o);if(this.sSubTopicId){s=document.getElementById(this.sSubTopicId);if(s){s.scrollIntoView(true);}}this.aResponsiveImageMaps=[];if(h.length){h.each(function(j,t){if(this.bDataTablesPluginLoaded){this._enableDataTable(t);}else{this.aWaitingDatatables.push(t);}}.bind(this));}i.each(function(j,k){this._enableImageMap(k);}.bind(this));},_enableImageMap:function(i){var n,s,r=/<img[^>]+src="([^">]+)/g;if(i.complete){this._addResponsiveImageMap(i);}else{n=new Image();n.onload=function(){this._addResponsiveImageMap(i);}.bind(this);s=r.exec(i.innerHTML);if(s){n.src=s&&s[1];}}},_enableDataTable:function(t){var s=t.id,C=this._getDataTableConfig(s),o;if(C){o=new f().init(s,t,C);this._getDataTableHelper().addDatatable(o);}},_getDataTableConfig:function(t){var o=this.oDataTablesConfig[this.sSubTopicId]||this.oDataTablesConfig[this.sTopicId]||{};return o[t];},_addResponsiveImageMap:function(h){this.aResponsiveImageMaps.push(new b(h.querySelector('map'),h.querySelector('img')));},_fixExternalLinks:function(E){var l=E.querySelectorAll("a.external-link"),i,o,h,s="http://help.sap.com/disclaimer?site=";for(i=0;i<l.length;i++){o=l[i];h=o.getAttribute("href");o.setAttribute("href",s+h);this._addIconToExternalUrl(o,h);}},_computeColumnGroupValues:function(E){var s,w,S,p,C,o=E.querySelectorAll("colgroup");o=[].slice.call(o);o.forEach(function(h){s=0;S=[];C=[].slice.call(h.children);C.forEach(function(i,j){w=parseInt(i.getAttribute('width'));S[j]=w;s+=w;});C.forEach(function(i,j){p=(S[j]/s)*100;i.setAttribute('width',p+"%");});});},_addIconToExternalUrl:function(h,s){var S=/^https?:\/\/(?:www.)?[\w.]*(?:sap|hana\.ondemand|sapfioritrial)\.com/.test(s),t='Information published on '+(S?'':'non ')+'SAP site',n=new Image(),i=S?'link-sap':'link-external';n.onload=function(){h.appendChild(n);};n.src='./resources/sap/ui/documentation/sdk/images/'+i+'.png';n.setAttribute("title",t);n.className="sapUISDKExternalLink";},_scrollContentToTop:function(){if(this.oPage&&this.oPage.$().length>0){this.oPage.getScrollDelegate().scrollTo(0,1);}},_formatHTML:function(h){return'<div>'+h+'</div>';},backToSearch:function(t){this.onNavBack();},onToggleFullScreen:function(E){T.updateMode(E,this.getView(),this);},onEditGitHubPress:function(E){var u=this.jsonDefModel.getProperty("/topicURL"),t=this.jsonDefModel.getProperty("/topictitle1"),s=this._formatToGitHubUrl(u,t);window.open(s,"_blank");},_formatToGitHubUrl:function(u,t){var s=t.trim().replace(g.SPECIAL_CHARS,"").replace(g.SPACES,"_");s+="_";s+=u.split("/").pop().substring(0,7);s+=".md";return G+s;}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/TopicDetailInitial.controller',["sap/ui/documentation/sdk/controller/BaseController","sap/ui/Device","sap/ui/thirdparty/jquery"],function(B,D,q){"use strict";var G="https://github.com/SAP/openui5-docs";return B.extend("sap.ui.documentation.sdk.controller.TopicDetailInitial",{onInit:function(){B.prototype.onInit.call(this);this._onOrientationChange({landscape:D.orientation.landscape});this.handleDocumentationDisclaimer();},handleDocumentationDisclaimer:function(){q.ajax(this.getConfig().docuPath+"disclaimer.json",{dataType:"json"}).then(function(d){var v=this.getView();if(d.showDisclaimer&&d.message){v.byId("disclaimerBlock").setVisible(true);v.byId("disclaimerMessage").setText(d.message);}}.bind(this),function(){});},onBeforeRendering:function(){this._deregisterOrientationChange();},onAfterRendering:function(){this._registerOrientationChange();},onExit:function(){this._deregisterOrientationChange();},onDownloadButtonPress:function(){window.open(this._determineFileLocation(),"_blank");},onGitHubButtonPress:function(){window.open(G,"_blank");},_determineFileLocation:function(){var v=this.getModel("versionData"),i=v.getProperty('/isDevVersion'),I=v.getProperty('/isOpenUI5');if(I){return'https://help.sap.com/OpenUI5_PDF/OpenUI5.pdf';}return i?'https://help.sap.com/DRAFT/SAPUI5_Internal_PDF/SAPUI5_Internal.pdf':'https://help.sap.com/SAPUI5_PDF/SAPUI5.pdf';}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/TopicMaster.controller',["sap/ui/Device","sap/ui/documentation/sdk/controller/MasterTreeBaseController","sap/ui/model/json/JSONModel","sap/m/library","sap/base/Log","sap/ui/documentation/sdk/controller/util/Highlighter","sap/ui/documentation/sdk/util/Resources"],function(D,M,J,m,L,H,R){"use strict";var S=m.SplitAppMode;return M.extend("sap.ui.documentation.sdk.controller.TopicMaster",{onInit:function(){this._oTree=this.byId("tree");var o=new J();o.setSizeLimit(10000);this.getView().setModel(o);this.getRouter().getRoute("topic").attachPatternMatched(this._onMatched,this);this.getRouter().getRoute("topicId").attachPatternMatched(this._onTopicMatched,this);this.getRouter().getRoute("subTopicId").attachPatternMatched(this._onTopicMatched,this);this._oIndexPromise=this._getDocuIndexPromise().then(function(d){d=this._addSearchMetadata(d,"");o.setData(d);this._initTreeUtil("key","links");}.bind(this)).catch(function(){this.getRouter().myNavToWithoutHash("sap.ui.documentation.sdk.view.NotFound","XML",false);}.bind(this));},_onTopicMatched:function(a){try{this.showMasterSide();}catch(e){L.error(e);}this._topicId=a.getParameter("arguments").id.split("/")[0];this._oIndexPromise.then(function(){this._expandTreeToNode(this._preProcessTopicID(this._topicId),this.getModel());}.bind(this));},onAfterRendering:function(){if(!this.highlighter){this.highlighter=new H(this._oTree.getDomRef(),{shouldBeObserved:true});}},onExit:function(){this.highlighter.destroy();},onTreeFilter:function(){M.prototype.onTreeFilter.apply(this,arguments);if(this.highlighter){this.highlighter.highlight(this._sFilter);}return this;},_onMatched:function(){this.getView().getParent().getParent().setMode(S.ShowHideMode);this._collapseAllNodes();this._clearSelection();if(D.system.desktop){setTimeout(function(){this.getView().byId("searchField").getFocusDomRef().focus();}.bind(this),0);}},_getDocuIndexPromise:function(){return new Promise(function(r,a){jQuery.ajax({async:true,url:R.getResourceOriginPath(this.getConfig().docuPath+"index.json"),dataType:'json',success:function(d){r(d);},error:function(e){a(e);}});}.bind(this));},_addSearchMetadata:function(d,p){for(var i=0;i<d.length;i++){d[i].name=p?p+" "+d[i].text:d[i].text;if(d[i].links){d[i].links=this._addSearchMetadata(d[i].links,d[i].name);}}return d;},onNodeSelect:function(e){this.getRouter().navTo("topicId",{id:e.getParameter("listItem").getTarget()},false);},_preProcessTopicID:function(t){if(!t||(typeof t!=="string")){return t;}return t.replace(/\.html$/,"");}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/Welcome.controller',["sap/ui/documentation/sdk/controller/BaseController","sap/ui/Device","sap/ui/model/json/JSONModel","sap/ui/model/resource/ResourceModel","sap/base/Log"],function(B,D,J,R,L){"use strict";return B.extend("sap.ui.documentation.sdk.controller.Welcome",{onInit:function(){this.getRouter().getRoute("welcome").attachPatternMatched(this._onMatched,this);sap.ui.getVersionInfo({async:true}).then(function(v){var m=new J({isOpenUI5:v&&v.gav&&/openui5/i.test(v.gav)});this.getView().setModel(m,"welcomeView");}.bind(this));this._onOrientationChange({landscape:D.orientation.landscape});},onBeforeRendering:function(){this._deregisterOrientationChange();},onAfterRendering:function(){this._registerOrientationChange();},onExit:function(){this._deregisterOrientationChange();},navigateToDetails:function(e){var h=e.oSource.getHref()||e.oSource.getTarget();h=h.replace("#/","").split('/');var p=h[0];var a=h[1];e.preventDefault();this.getRouter().navTo(p,{id:a},true);},onGetStarted:function(){this.getRouter().parse("topic/8b49fc198bf04b2d9800fc37fecbb218");},onDownloadButtonPress:function(e){var i=this.getView().getModel("welcomeView").getProperty("/isOpenUI5"),u=i?"http://openui5.org/download.html":"https://tools.hana.ondemand.com/#sapui5";window.open(u,"_blank");},_onMatched:function(){try{this.hideMasterSide();}catch(e){L.error(e);}}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/config/datatable',[],function(){"use strict";return{getPreset:function(){return{"dom":'<"fg-toolbar ui-toolbar ui-widget-header ui-helper-clearfix ui-corner-tl ui-corner-tr"<"searchWrapper"f>l<"pagingWrapper"p>t>'+'t'+'<"fg-toolbar ui-toolbar ui-widget-header ui-helper-clearfix ui-corner-bl ui-corner-br"ip>',"buttons":[{extend:'colvis'}],"lengthMenu":[[10,25,50,100,-1],[10,25,50,100,"All"]],"sapTableId":"","language":{"buttons":{"colvis":"Show/hide columns"}}};}};});
sap.ui.predefine('sap/ui/documentation/sdk/controller/util/APIInfo',["sap/ui/thirdparty/jquery","sap/base/Log","sap/ui/documentation/sdk/util/Resources"],function(q,L,R){"use strict";var t;var l={};
function g(){if(l["index"]){return Promise.resolve(l["index"]);}return new Promise(function(r,e){q.ajax({async:true,url:R.getResourceOriginPath("/docs/api/api-index.json"),dataType:'json',success:function(v){var f=v.symbols||[];l["index"]=f;r(f);},error:function(){q.ajax({async:true,url:R.getResourceOriginPath("../../../../../../docs/api/api-index.json"),dataType:'json',success:function(v){var f=v.symbols||[];l["index"]=f;r(f);},error:function(){L.error("failed to load api-index.json");l["index"]=[];r([]);}});}});});}
function a(){if(l["deprecated"]){return Promise.resolve(l["deprecated"]);}return new Promise(function(r,e){q.ajax({async:true,url:R.getResourceOriginPath("/docs/api/api-index-deprecated.json"),dataType:'json',success:function(v){l["deprecated"]=v;r(v);},error:function(){e();}});});}
function b(){if(l["experimental"]){return Promise.resolve(l["experimental"]);}return new Promise(function(r,e){q.ajax({async:true,url:R.getResourceOriginPath("/docs/api/api-index-experimental.json"),dataType:'json',success:function(v){l["experimental"]=v;r(v);},error:function(){e();}});});}
function c(){if(l["since"]){return Promise.resolve(l["since"]);}return new Promise(function(r,e){q.ajax({async:true,url:R.getResourceOriginPath("/docs/api/api-index-since.json"),dataType:'json',success:function(v){l["since"]=v;r(v);},error:function(){e();}});});}
function d(e){if(!e){return Promise.resolve([]);}if(l[e]){return Promise.resolve(l[e]);}return new Promise(function(r){q.ajax({async:true,url:R.getResourceOriginPath(t+e.replace(/\./g,'/')+'/designtime/apiref/api.json'),dataType:'json',success:function(v){var f=v.symbols||[];l[e]=f;r(f);},error:function(f){L.error("failed to load api.json for: "+e);l[e]=[];r([]);}});});}
function s(r){r=r==null?sap.ui.require.toUrl("")+"/"+'../test-resources/':r;if(r.slice(-1)!='/'){r+='/';}t=r;}
s();return{_setRoot:s,getIndexJsonPromise:g,getDeprecatedPromise:a,getExperimentalPromise:b,getSincePromise:c,getLibraryElementsJSONPromise:d};});
sap.ui.predefine('sap/ui/documentation/sdk/controller/util/ConfigUtil',["sap/ui/base/Object","sap/base/strings/capitalize"],function(B,c){"use strict";return B.extend("sap.ui.documentation.sdk.controller.util.ConfigUtil",{"COOKIE_NAMES":{"APPROVAL_REQUESTED":"dk_approval_requested","ALLOW_REQUIRED_COOKIES":"dk_allow_required_cookies","ALLOW_USAGE_TRACKING":"dk_allow_usage_tracking"},constructor:function(C){this._oComponent=C;},hasMasterView:function(r){var R=this._getRouteConfig(r),i=R&&R.target.length===2;return!!i;},getMasterView:function(r){var m=this._getMasterTargetName(r),t=this._getTargetConfig(m),v=t.viewName;v="sap.ui.documentation.sdk.view."+c(v,0);return this._oComponent.getRouter().getView(v,"XML");},setCookie:function(C,v){var e,d=new Date();d.setTime(d.getTime()+(356*24*60*60*1000));e="expires="+d.toUTCString();document.cookie=C+"="+v+";"+e+";path=/";},getCookieValue:function(C){var a=document.cookie.split(';'),s;C=C+"=";for(var i=0;i<a.length;i++){s=a[i].trim();if(s.indexOf(C)===0){return s.substring(C.length,s.length);}}return"";},enableUsageTracking:function(){window["swa"]&&window["swa"].enable();},_getMasterTargetName:function(r){var R=this._getRouteConfig(r),i=R&&R.target.length===2,m=i&&R.target[0];return m;},_getRouteConfig:function(r){var C=this._getSapUI5ConfigEntry(),R=C.routing.routes,a=jQuery.grep(R,function(o){return o.name===r;}),o=a.length&&a[0];return o;},_getSapUI5ConfigEntry:function(){return this._oComponent.getMetadata().getManifestObject().getEntry("sap.ui5");},_getTargetConfig:function(t){return this._getSapUI5ConfigEntry().routing.targets[t];},destroy:function(){this._oComponent=null;return B.prototype.destroy.apply(this,arguments);}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/util/ControlsInfo',["sap/ui/thirdparty/jquery",'sap/ui/documentation/library',"sap/base/Log"],function(q,l,L){"use strict";var p;var C={loadData:function(){if(!p){p=new Promise(function(r,a){l._loadAllLibInfo("","_getDocuIndex",function(b,d){var D=C._getIndices(b,d,function(){r(D);});});});}return p;},_getIndices:function(a,d,c){var b=["Action","Application","Container","Display","Chart","Mini Chart","Layout","List","Pattern","Popup","Tile","User Input","Testing","Theming","Tutorial","Routing","Data Binding","Data Visualization","Map","Utility"];var e=["namespace","since","category"];var f={namespace:{},since:{},category:{},formFactors:{"Independent":true,"Condensed":true,"Compact":true,"Cozy":true}};var F={"-":"Independent","S":"Condensed","SM":"Condensed, Compact","SL":"Condensed, Cozy","SML":"Condensed, Compact, Cozy","M":"Compact","ML":"Compact, Cozy","L":"Cozy"};var g={};g={};g.entityCount=0;g.entities=[];g.filter={};g.samples={};q.each(d,function(i,D){if(!D.explored){return;}else if(!D.explored.samplesRef){L.error("explored: cannot register lib '"+D.library+"'. missing 'explored.samplesRef'");return;}else if(Array.isArray(D.explored.samplesRef)&&D.explored.samplesRef.length!==D.explored.samplesRef.filter(function(I){return I.namespace&&I.ref;}).length){L.error("explored: cannot register lib '"+D.library+"'. missing 'explored.samplesRef.namespace' or 'explored.samplesRef.ref' in one or more of the configured namespaces");return;}else if(!Array.isArray(D.explored.samplesRef)&&!D.explored.samplesRef.namespace){L.error("explored: cannot register lib '"+D.library+"'. missing 'explored.samplesRef.namespace'");return;}else if(!Array.isArray(D.explored.samplesRef)&&!D.explored.samplesRef.ref){L.error("explored: cannot register lib '"+D.library+"'. missing 'explored.samplesRef.ref'");return;}else if(!D.explored.entities){L.error("explored: cannot register lib '"+D.library+"'. missing 'explored.entities'");return;}else{L.info("explored: now reading lib '"+D.library+"'");}if(Array.isArray(D.explored.samplesRef)){D.explored.samplesRef.forEach(function(I){(function(){var j={};j[I.namespace.replace(/\./g,"/")]=""+I.ref||".";sap.ui.loader.config({paths:j});}());});}else{(function(){var j={};j[D.explored.samplesRef.namespace.replace(/\./g,"/")]=""+D.explored.samplesRef.ref||".";sap.ui.loader.config({paths:j});}());}q.each(D.explored.samples,function(i,s){if(!s.id){L.error("explored: cannot register sample '?'. missing 'id'");}else if(!s.name){L.error("explored: cannot register sample '"+s.id+"'. missing 'name'");}else{g.samples[s.id]=s;}});q.each(D.explored.entities,function(j,E){if(!E.id){L.error("explored: cannot register entity '?'. missing 'id'");return;}if(D.explored.entitiesDefaults){q.each(D.explored.entitiesDefaults,function(k,v){if(!E.hasOwnProperty(k)){E[k]=v;}});}var I=E.id.lastIndexOf(".");var n=(I!==-1)?E.id.substring(0,I):E.id;E.namespace=n;if(!E.name){L.error("explored: cannot register entity '"+E.id+"'. missing 'name'");return;}if(b.indexOf(E.category)===-1){L.error("explored: cannot register entity '"+E.id+"'. category '"+E.category+"' is not allowed");return;}if(!E.formFactors){L.error("explored: cannot register entity '"+E.id+"'. missing 'formFactors'");return;}if(!F[E.formFactors]){L.error("explored: cannot register entity '"+E.id+"'. formFactors '"+E.formFactors+"' is not allowed");return;}E.formFactors=F[E.formFactors];var A=false;q.each(e,function(i,s){if(!E[s]){L.error("explored: cannot register entity '"+E.id+"'. missing '"+s+"'");A=true;return false;}});if(A){return;}q.each(e,function(i,s){f[s][E[s]]=true;});E.library=D.library;g.entities.push(E);});});q.each(g.entities,function(n,E){var i=0,s,k;E.searchTags=E.name+" "+E.name.replace(/\s/g,"")+" "+E.category;if(E.samples){E.samples.forEach(function(j){var r=g.samples[j];if(r){E.searchTags+=" "+r.name;E.searchTags+=" "+r.description;}});}if(E.samples&&!(E.samples instanceof Array)){E.samples=[];L.error("explored: cannot register samples for entity '"+E.id+"'. 'samples' is not an array");return;}if(!E.samples){E.samples=[];}if(E.samplesAsSteps){if(!(E.samplesAsSteps instanceof Array)){L.error("explored: cannot register samples for entity '"+E.id+"'. 'samplesAsSteps' is not an array");return;}k=function(N){if(N.toString().length===1){return"0"+N;}return N;};for(;i<E.samplesAsSteps.length;i++){s={"id":E.id+"."+k(i+1),"name":E.name+" - Step "+(i+1)+" - "+E.samplesAsSteps[i]};if(i>0){s.previousSampleId=E.id+"."+k(i);}if(i<E.samplesAsSteps.length-1){s.nextSampleId=E.id+"."+k(i+2);}s.entityId=E.id;E.samples.push(s);g.samples[s.id]=s;E.searchTags+=" "+s.name;}}else{var S=[],m;q.each(E.samples,function(j,I){var r=g.samples[I];if(!r){L.warning("explored: cannot register sample '"+I+"' for '"+E.id+"'. not found in the available docu indizes");}else{r.entityId=E.id;if(!r.contexts){r.contexts={};}if(!r.contexts[r.entityId]){r.contexts[r.entityId]={};}r.contexts[r.entityId].previousSampleId=(m?m.id:undefined);if(m){m.contexts[r.entityId].nextSampleId=r.id;}m=r;S.push(r);E.searchTags+=" "+r.name;}});E.samples=S;}E.sampleCount=E.samples.length;});g.entityCount=g.entities.length;q.each(f,function(s,j){g.filter[s]=[];q.each(j,function(k,v){g.filter[s].push({id:k});});});var o=l._getLibraryInfoSingleton();var h={};var P=[];for(var i=0;i<a.length;i++){P.push(new Promise(function(r){var j=function(k){h[k.library]=k.componentInfo;r();};o._getLibraryInfo(a[i],j);}));}Promise.all(P).then(function(){c&&c();});g.libComponentInfos=h;g.groups=this.getGroups(g.entities);return g;},findGroup:function(g,n){var a;for(var i=0;i<g.length;i++){a=g[i];if(a.name==n){return a;}}},getGroups:function(e){var g=[],a,b,s,c,i,j;for(i=0;i<e.length;i++){a=e[i];a.key='#/entity/'+a.id;s=a.samples;for(j=0;j<s.length;j++){c=s[j];c.key='#/sample/'+c.id+"/preview";}b=this.findGroup(g,a.category);if(!b){b={name:a.category,key:'#/group/'+a.category,controls:[a]};g.push(b);}else{b.controls.push(a);}}return g;}};return C;},true);
sap.ui.predefine('sap/ui/documentation/sdk/controller/util/DataTable',["jquery.sap.global","sap/m/Input","sap/m/library","../config/datatable","./datatable/filters/DataTableFilterDropDown","./datatable/filters/DataTableFilterRange","sap/ui/documentation/sdk/controller/util/Highlighter"],function($,I,m,d,D,a,H){"use strict";var b=m.InputType;
function c(){this.oColumns=[];this.oChangedFilters=[];this.aShownRows=[];this.API=null;}
c.DEFAULT_SORTING="0,asc";c.FILTER_CLASS_WRAPPER="sapUiDocumentationDatatableFilterWrapper";c.FILTER_TYPES={REGEX:"REGEX",NORMAL:"NORMAL",NUMBER:"NUMBER",SELECT:"SELECT",CELL_RANGE:"CELL_RANGE",NUMBER_RANGE:"NUMBER_RANGE"};
c.prototype.destroy=function(){this.oColumns.forEach(function(C){if(C.highlighter){C.highlighter.destroy();C.highlighter=null;}C.aControls.forEach(function(o){o.destroy();});C.aControls=[];});this.oColumns=[];this.API.destroy();};
c.prototype.get=function(p){return this.oConfig[p];};
c.prototype.init=function(i,t,C){this.sId=i;this.oDomTable=t;this.oConfig=this.getConfig(i,C);var A=$(t).DataTable(Object.assign(this.oConfig,this.getLifeCycleMethods(i,C)));A.on('draw',function(){if(this.get("highlight")){var T=A.search();if(T||this.oChangedFilters.length){this.oColumns.forEach(function(o,e){var f=this.oChangedFilters[e]&&this.oChangedFilters[e].value,g=Array.isArray(f);if(g){f=f.reduce(function(r,h,e){if(h.value){r+=" "+h.text;}return r;},"");}if(f&&!(typeof f==="object")){if(T){T+=" "+f;}else{T=f;}}this.highlight(e,T);},this);}else{this.highlight(null,"");}}}.bind(this));A.buttons().container().insertBefore('#'+i+'_length');A.on('column-visibility.dt',function(e,s,f,v){this.onColumnVisibilityChange(f,v);}.bind(this));this.oConfig.columns.forEach(function(p,e){this.onColumnVisibilityChange(e,p.visible);},this);return this;};
c.prototype.highlight=function(C,t){if(C===null){this.oColumns.forEach(function(o){o.highlighter.highlight(t);});return;}this.oColumns[C].highlighter.highlight(t);};
c.prototype.onColumnVisibilityChange=function(i,v){var f=this.oColumns[i]&&this.oColumns[i].filterHeader,C=this.oDomTable.querySelector("colgroup"),o;if(C){o=C.children[i];if(o){o.classList.toggle("hidden",!v);}}if(f){f.toggle(v);}};
c.prototype.handleSearch=function(s,o,e,r,f){var E,g,C,h,S=[],j;this.oChangedFilters.forEach(function(k,l){E=o[l];C=k.value;h=k.control;if(C===""){return;}switch(true){case h.hasStyleClass(c.FILTER_TYPES.NORMAL):case h.hasStyleClass(c.FILTER_TYPES.ALPHA_NUMERIC):case h.hasStyleClass(c.FILTER_TYPES.NUMBER):j=E.toLowerCase().indexOf(C.toLowerCase())>-1;break;case h.hasStyleClass(c.FILTER_TYPES.REGEX):break;case h.hasStyleClass(c.FILTER_TYPES.NUMBER_RANGE):var n=C.from!==""?C.from:Number.MIN_SAFE_INTEGER,p=C.to!==""?C.to:Number.MAX_SAFE_INTEGER,q=parseFloat(E)||0;j=(isNaN(n)&&isNaN(p))||(isNaN(n)&&q<=p)||(n<=q&&isNaN(p))||(n<=q&&q<=p);break;case h.hasStyleClass(c.FILTER_TYPES.CELL_RANGE):var t=E.split("-"),u=parseFloat(C);j=t[0]<=u&&t[1]>=u;break;case h.hasStyleClass(c.FILTER_TYPES.SELECT):var v=C.some(function(i){return i.value;});j=!v||(C.findIndex(function(w){g=s.aoData[e].anCells[l].querySelectorAll("li");var x=[];if(g.length){for(var i=0;i<g.length;i++){x[i]=g[i].textContent;}}else{x.push(E);}return w.value&&(x.indexOf(w.text)>-1);},this)>-1);break;default:j=true;}S.push(j);},this);return S.indexOf(false)<0;};
c.prototype.getConfig=function(i,C){var o=[],n=JSON.parse(JSON.stringify(d.getPreset()));n.sapTableId=i;n.columnDefs=[];if(C){n.save=C['save']!==false;n.searching=C['search']!==false;n.highlight=C['highlight']!==false;if(C['excel_export']){n.buttons.push('csv');}if(C['paginate']){n.pageLength=C['paginate']>0?C['paginate']:-1;}n.columns=C.columns.map(function(e,f){var r={visible:true};r.visible=e.visible!==false;if(e.sort){var s=n.columnDefs.find(function(s){return s.type===e.sort;});if(s){s.targets.push(f);}else{n.columnDefs.push({type:e.sort,targets:[f]});}}return r;});C['initial_sort']=C['initial_sort']||c.DEFAULT_SORTING;if(C['initial_sort']!=='none'){o=C['initial_sort'].split(';');o=o.map(function(e){return e.split(',');});}n.order=o;}return n;};
c.prototype.onFilterChange=function(C,o){this.oChangedFilters[C]={control:o.control,value:o.value};this.API.columns(C).draw();};
c.prototype.getSelectOptions=function(C){var o=[];this.API.columns(C).data().unique().sort()[0].forEach(function(O){var e;if(o.indexOf(O)>-1){return;}try{e=$(O);}catch(f){e=null;}if(e&&e.length>0){e.find('li').each(function(i,O){if(o.indexOf(O.textContent)<0){o.push(O.textContent);}});}else{o.push(O);}});return o;};
c.prototype.getLifeCycleMethods=function(i,C){var t=this;return{initComplete:function(){t.API=this.api();var T=$('#'+i+' thead'),n=$('<tr/>'),f,h,e=0;this.api().columns().every(function(){var l=e,g=C.columns[e],o=[],F,j=g.filter==="select";f=$('<th/>');f.addClass(c.FILTER_CLASS_WRAPPER);t.oColumns[e]={};t.oColumns[e].aControls=[];t.oColumns[e].filterHeader=f;if(t.get("highlight")){h=new H([].slice.call(this.nodes()),{useExternalStyles:false,shouldBeObserved:true,isCaseSensitive:false});t.oColumns[e].highlighter=h;}if(j){o=t.getSelectOptions(e);}F=c.getFilterByType(g.filter,o);if(F.control){t.oColumns[e].aControls.push(F.control);F.control.attachEvent(F.event,function(E){t.onFilterChange(l,{value:E.getParameter("value"),control:F.control});});F.control.placeAt(f);}n.append(f);e++;});T.append(n);}};};
c.getFilterByType=function(t,o){var C,e="liveChange";switch(t){case'number-range':C=new a({from:new I({type:b.Number,placeholder:"From"}),to:new I({type:b.Number,placeholder:"To"})}).addStyleClass(c.FILTER_TYPES.NUMBER_RANGE);break;case'select':e="change";C=new D({options:o}).addStyleClass(c.FILTER_TYPES.SELECT);break;case'none':C='';break;default:var f=c.FILTER_TYPES.NORMAL,i=b.Text;if(t==='regex'){f=c.FILTER_TYPES.REGEX;}else if(t==='cell-range'){f=c.FILTER_TYPES.CELL_RANGE;i=b.Number;}else if(t==='number'){f=c.FILTER_TYPES.NUMBER;i=b.Number;}C=new I({type:i,placeholder:"Filter"}).addStyleClass(f);}return{control:C,event:e};};
return c;});
sap.ui.predefine('sap/ui/documentation/sdk/controller/util/DataTableHelper',["jquery.sap.global"],function($){"use strict";
function s(a,b){var r=new RegExp("^([a-zA-Z]*)(.*)"),m=r.exec(a),M=r.exec(b),f=m[1],F=M[1];if(f>F){return 1;}if(f<F){return-1;}return parseInt(m[2])-parseInt(M[2]);}
function D(){this.aDataTables=[];}
D.prototype.addDatatable=function(d){this.aDataTables.push(d);};
D.prototype.destroyDatatables=function(){this.aDataTables.forEach(function(d){d.destroy();});this.aDataTables=[];};
D.prototype.addMiddlewares=function(){$.fn.dataTable.ext.search.push(function(a,d,i,r,b){var S=true,o=this.aDataTables.find(function(o){return o.sId===a.sTableId;});if(o){S=o.handleSearch(a,d,i,r,b);}return S;}.bind(this));$.extend($.fn.dataTableExt.oSort,{"alpha-numeric-asc":function(a,b){return s(a,b);},"alpha-numeric-desc":function(a,b){return s(b,a);}});};
function c(){var i=null;return{getInstance:function(){if(!i){i=new D();}return i;}};}
return c();});
sap.ui.predefine('sap/ui/documentation/sdk/controller/util/EntityInfo',['./APIInfo',"sap/base/util/ObjectPath"],function(A,O){"use strict";
function f(e){var v=sap.ui.getVersionInfo(),l,L,i;if(v&&Array.isArray(v.libraries)){L=v.libraries.length;for(i=0;i<L;i++){l=v.libraries[i];if(e===l.name||e.indexOf(l.name+".")===0){return l.name;}}}return"sap.ui.core";}
function g(e,l){var E;if(!l){var c=O.get(e||"");if(c&&c.getMetadata){var m=c.getMetadata();if(m.getLibraryName){l=m.getLibraryName();}else{l="sap.ui.core";}}else{l=f(e);}}return A.getLibraryElementsJSONPromise(l).then(function(o){var a;for(var i=0,L=o.length;i<L;i++){if(o[i].name===e){a=o[i];break;}}if(a){E={baseType:a.extends,deprecation:a.deprecatedText?a.deprecatedText:null,doc:a.description,module:a.module,name:a.name,since:a.since,values:a.properties,uxGuidelinesLink:a.uxGuidelinesLink,uxGuidelinesLinkText:a.uxGuidelinesLinkText,docuLink:a.docuLink,docuLinkText:a.docuLinkText};}return E;});}
return{getEntityDocuAsync:function(e,l){return g(e,l);}};},true);
sap.ui.predefine('sap/ui/documentation/sdk/controller/util/Highlighter',[],function(){"use strict";var H={};H.CURRENTLY_HIGHLIGHTED_DOM_REFS=[];H.MUTATION_OBSERVER=window.MutationObserver||window.WebKitMutationObserver||window.MozMutationObserver;var c=function c(d,C){this._bIsCaseSensitive=!!C.isCaseSensitive;this._aPreviouslyHighlightedNodes=[];this._aPreviouslyOriginalNodes=[];this._aOldTerms=[];this._aRegExTerms=[];this._bUseExternalStyles=!!C.useExternalStyles;this._oObserver=null;if(Array.isArray(d)){this._oDomRef=d;}else{this._oDomRef=[d];}this._oDomRef.forEach(this.validate,this);if(C.shouldBeObserved){this._addMutationObserver();}};
c.prototype.validate=function(d){if(H.CURRENTLY_HIGHLIGHTED_DOM_REFS.indexOf(d)===-1){H.CURRENTLY_HIGHLIGHTED_DOM_REFS.forEach(function(D){if(this._bIsDomNodeDescendant(d,D)){throw new Error("Desired DOM Ref is parent of DOM Ref which is being highlighted.");}else if(this._bIsDomNodeDescendant(D,d)){throw new Error("Desired DOM Ref is child of DOM Ref which is being highlighted.");}},this);H.CURRENTLY_HIGHLIGHTED_DOM_REFS.push(d);}else{throw new Error("Highlighter instance is already created for this DOM Reference");}};
c.prototype.highlight=function(t){var T;if(!t){this._restorePreviouslyHighlightedNodes();this._aRegExTerms=[];this._aOldTerms=[];return;}T=this._formatTerms(t);if(!T||!T.length||this._isNewTermsSameAsOld(T)){return;}this._aOldTerms=T;this._cacheRegExTerms();if(this._aPreviouslyHighlightedNodes&&this._aPreviouslyHighlightedNodes.length>0){this._restorePreviouslyHighlightedNodes();}this._toggleMutationObserver(false);this._oDomRef.forEach(function(d){this._highlightSubTree(d);},this);this._toggleMutationObserver(true);};
c.prototype._cacheRegExTerms=function(){var r;this._aRegExTerms=[];this._aOldTerms.forEach(function(t){t=this._escapeRegExp(t);r=this._bIsCaseSensitive?new RegExp(t,"g"):new RegExp(t,"gi");this._aRegExTerms.push(r);},this);};
c.prototype._escapeRegExp=function(t){return t.replace(/[-[\]{}()*+?.,\\^$|#\s]/g,'\\$&');};
c.prototype._isNewTermsSameAsOld=function(t){var o=this._aOldTerms.length,i;if(o!==t.length){return false;}for(i=0;i<o;i++){if(this._aOldTerms[i]!==t[i]){return false;}}return true;};
c.prototype._highlightSubTree=function(r){var n,i;for(i=0;i<r.childNodes.length;i++){n=r.childNodes[i];this._processNode(n);}};
c.prototype._processNode=function(n){var t,r,i,j,m,C,o,b,a;if(n.nodeName==="IFRAME"){this._highlightSubTree(n.contentDocument.body);return;}if(n.nodeType===document.ELEMENT_NODE){this._highlightSubTree(n);}else if(n.nodeType===document.TEXT_NODE){t=n.data;m=Object.create(null);b=[];for(i=0;i<this._aRegExTerms.length;i++){r=this._aRegExTerms[i];while((o=r.exec(t))!==null){a=o["index"];if(b.indexOf(a)===-1){C=o["0"];m[a]=C;for(j=a;j<a+C.length;j++){b.push(j);}}}}if(Object.keys(m).length!==0){t=this._highlightTerms(m,t);this._replaceNode(n,t);}}};
c.prototype._formatTerms=function(t){var T=t&&t.replace(/\s+/g,' ').trim().split(" "),u;u=T.reduce(function(a,b){if(a.indexOf(b)===-1){a.push(b);}return a;},[]);return u.sort(function(a,b){return b.length-a.length;});};
c.prototype._replaceNode=function(n,h){var w;if(n.parentNode){w=document.createElement('span');w.innerHTML=h;n.parentNode.replaceChild(w,n);this._aPreviouslyHighlightedNodes.push(w);this._aPreviouslyOriginalNodes.push(n);}};
c.prototype._restorePreviouslyHighlightedNodes=function(){var m,o;this._toggleMutationObserver(false);for(var i=0;i<this._aPreviouslyHighlightedNodes.length;i++){m=this._aPreviouslyHighlightedNodes[i];o=this._aPreviouslyOriginalNodes[i];if(m.parentNode){m.parentNode.replaceChild(o,m);}}this._aPreviouslyHighlightedNodes=[];this._aPreviouslyOriginalNodes=[];this._toggleMutationObserver(true);};
c.prototype._highlightTerms=function(m,t){var o=this._bUseExternalStyles?'<span class="highlightedText">':'<span class="defaultHighlightedText">',C='</span>',s,u,i=0,I;for(I in m){u=+I+(i*(o.length+C.length));s=m[I];t=t.substring(0,u)+o+s+C+t.substring(u+s.length);i++;}return t;};
c.prototype._addMutationObserver=function(){this._instantiateMutationObserver();this._toggleMutationObserver(true);};
c.prototype._removeMutationObserver=function(){this._toggleMutationObserver(false);this._oObserver=null;this._oDomRef=[];};
c.prototype._toggleMutationObserver=function(C){if(C){this._oDomRef.forEach(function(d){this._oObserver.observe(d,this.oObserverConfig);},this);}else{this._oObserver.disconnect();}};
c.prototype._bIsDomNodeDescendant=function(p,C){return p.contains(C);};
c.prototype._instantiateMutationObserver=function(){this.oObserverConfig={attributes:false,childList:true,characterData:true,subtree:true};this._oObserver=new H.MUTATION_OBSERVER(this._onMutationDetectionCallback.bind(this));};
c.prototype._onMutationDetectionCallback=function(m){var a,n;this._toggleMutationObserver(false);m.forEach(function(M){if(M.type==='childList'){a=M.addedNodes;for(var i=0;i<a.length;i++){n=a[i];this._processNode(n);}}else if(M.type==='characterData'){this._processNode(M.target);}},this);this._toggleMutationObserver(true);};
c.prototype.destroy=function(){this._removeMutationObserver();};
return c;});
sap.ui.predefine('sap/ui/documentation/sdk/controller/util/JSDocUtil',["sap/base/strings/escapeRegExp"],function(e){"use strict";
function d(t,a){return"<code>"+(a||t)+"</code>";}
function f(s,o){o=o||{};var b=o.beforeParagraph==null?'<p>':o.beforeParagraph;var a=o.afterParagraph==null?'</p>':o.afterParagraph;var c=o.beforeFirstParagraph==null?b:o.beforeFirstParagraph;var g=o.afterLastParagraph==null?a:o.afterLastParagraph;var l=typeof o.linkFormatter==='function'?o.linkFormatter:d;var r=/(<pre>)|(<\/pre>)|(<h[\d+]>)|(<\/h[\d+]>)|\{@link\s+([^}\s]+)(?:\s+([^\}]*))?\}|((?:\r\n|\r|\n)[ \t]*(?:\r\n|\r|\n))/gi;var i=false;s=s||'';l=l||d;s=c+s.replace(r,function(m,p,h,j,k,n,q,t){if(p){i=true;}else if(h){i=false;}else if(j){if(!i){return a+m;}}else if(k){if(!i){return m+b;}}else if(t){if(!i){return a+b;}}else if(n){if(!i){return l(n,q);}}return m;})+g;s=s.replace(new RegExp(e(b)+"\s*"+e(a),"g"),"");return s;}
return{formatTextBlock:f};});
sap.ui.predefine('sap/ui/documentation/sdk/controller/util/ResponsiveImageMap',["./overlay/Overlay","./Tooltip"],function(O,T){"use strict";var a=30;var R=function(m,i){this.oImg=i;this.oOverlay=new O(this.oImg.parentNode);this.oToolTip=new T(this.oImg.parentNode);this.iOriginalWidth=i.naturalWidth;this.areas=Array.prototype.map.call(m.getElementsByTagName('area'),function(A){A.addEventListener("mouseenter",this.onmouseenter.bind(this));A.addEventListener("mouseleave",this.onmouseleave.bind(this));return{element:A,originalCoords:A.getAttribute('originalCoords').split(',')};},this);this.resize();};
R.prototype.resize=function(){var n,r=this.oImg.offsetWidth/this.iOriginalWidth;this.areas.forEach(function(A){n=[];A.originalCoords.forEach(function(o){n.push(Math.round(o*r));});A.element.coords=n.join(',');});return true;};
R.prototype.onmouseenter=function(e){var c=e.target.coords,s=e.target.getAttribute("shape"),r=this.oImg.getBoundingClientRect();this.sTitle=e.target.getAttribute('title');e.target.setAttribute('title','');this.oOverlay.setShape(s,c);this.oOverlay.show();if(this.sTitle){this.oToolTip.setText(this.sTitle);this.oToolTip.setPosition({top:(e.clientY-r.top)-(this.oToolTip.getBounds().offsetHeight+a),left:(e.clientX-r.left)-(this.oToolTip.getBounds().offsetWidth/2)});this.oToolTip.show();}};
R.prototype.onmouseleave=function(e){e.target.setAttribute('title',this.sTitle);this.oOverlay.hide();this.oToolTip.hide();};
return R;});
sap.ui.predefine('sap/ui/documentation/sdk/controller/util/SearchUtil',["sap/ui/Device"],function(D){"use strict";var W={URL:sap.ui.require.toUrl("sap/ui/documentation/sdk/controller/util/IndexWorker.js"),COMMANDS:{INIT:"fetch",SEARCH:"search"},RESPONSE_FIELDS:{DONE:"bDone",SEARCH_RESULT:"oSearchResult"}},i,w;
function a(){if(!i){i=new Promise(function(r,b){w=new window.Worker(W.URL);w.addEventListener('message',function(e){var d=e.data;r(d&&d[W.RESPONSE_FIELDS.DONE]===true);},false);w.postMessage({"cmd":W.COMMANDS.INIT,"bIsMsieBrowser":!!D.browser.msie});});}return i;}
function s(q){return new Promise(function(r,b){a().then(function(){w.addEventListener('message',function(e){var d=e.data;r(d&&d[W.RESPONSE_FIELDS.SEARCH_RESULT]);},false);w.postMessage({"cmd":W.COMMANDS.SEARCH,"sQuery":q});});});}
return{init:a,search:s};});
sap.ui.predefine('sap/ui/documentation/sdk/controller/util/Tooltip',[],function(){"use strict";
function T(p){this.oContainer=document.createElement('div');this.oContainer.classList.add("area-tooltip");if(p){this.attachTo(p);}}
T.prototype.attachTo=function(p){this.oParent=p;this.oParent.appendChild(this.oContainer);};
T.prototype.setText=function(t){this.oContainer.innerText=t;};
T.prototype.getBounds=function(){return{offsetHeight:this.oContainer.offsetHeight,offsetWidth:this.oContainer.offsetWidth};};
T.prototype.setPosition=function(p){this.oContainer.style.top=p.top+'px';this.oContainer.style.left=p.left+'px';};
T.prototype.show=function(){this.oContainer.style.opacity="1";};
T.prototype.hide=function(){this.oContainer.style.opacity="0";};
return T;});
sap.ui.predefine('sap/ui/documentation/sdk/controller/util/TreeUtil',[],function(){"use strict";var T=function(n,c){this.nodeIdField=n;this.childrenField=c;};
T.prototype.getPathToNode=function(n,t){var s=[];this._walkTree(n,t,s);return s;};
T.prototype._walkTree=function(n,t,s){var f=this._findLeaf(t,n);if(f){s.push(n);return true;}for(var i=0;i<t.length;i++){if(t[i][this.childrenField]){s.push(t[i][this.nodeIdField]);if(this._walkTree(n,t[i][this.childrenField],s)){return true;}s.pop();}}};
T.prototype._findLeaf=function(t,n){for(var i=0;i<t.length;i++){if(t[i][this.nodeIdField]===n){return t[i];}}return null;};
return T;});
sap.ui.predefine('sap/ui/documentation/sdk/controller/util/XML2JSONUtils',["sap/ui/thirdparty/jquery"],function(q){"use strict";
function b(a,c){var d=x(a,c);var s=["topictitle1","shortdesc"];var p=function(g,h){var X=h||d;var n=X.getElementsByClassName(g);if(n.length===0){return'';}var i=q("<div></div>").html(r(n[0].innerHTML)).text();return n&&n.length>0&&("innerHTML"in n[0])&&i||'';};var r=function(t){return t.replace(/<[^>]*>/g," ").replace(/\s{2,}/g,' ');};var f=function(g){var h=g.querySelectorAll("img");for(var i=0;i<h.length;i++){if(h[i].classList.contains('link-external')){h[i].setAttribute("src","./resources/sap/ui/documentation/sdk/images/link-external.png");continue;}h[i].setAttribute("src",c.docuPath+h[i].getAttribute("src"));}return g.innerHTML;};var e=function(){var w=d,g=w.querySelectorAll("script, .topictitle1, .shortdesc, #local-navigation, header, #footer-container, nav.mobile-nav, #breadcrumb-container, #content-toolbar"),h,i;for(var i=0;i<g.length;i++){h=g[i].parentElement;h.removeChild(g[i]);}f(w);j['html']=w.innerHTML;};var j={};s.forEach(function(g,i){j[g]=p(g);});e();return j;}
function x(a,c){var d=q.parseHTML(a);var m=c.topicHtmlMainDivId;for(var i=0;i<d.length;i++){if(d[i].getAttribute&&d[i].getAttribute("id")===m){var n='<div id ="'+m+'">'+d[i].innerHTML+'</div>';d[i].innerHTML=n;return d[i];}}}
return{DomXml2JSON:b,XML2DOM:x,XML2JSON:b};});
sap.ui.predefine('sap/ui/documentation/sdk/controller/util/datatable/filters/DataTableFilterDropDown',["jquery.sap.global",'sap/ui/core/Control','./DataTableFilterDropDownRenderer'],function($,C,D){"use strict";
var a=C.extend("sap.ui.documentation.sdk.DataTableFilterDropDown",{
metadata:{properties:{checked:{type:"array",defaultValue:[]},options:{type:"array",defaultValue:[]},expanded:{type:"boolean",defaultValue:false,visibility:"hidden"}}},
renderer:D
});
a.M_EVENTS={CHANGE:'change'};
a.isCheckbox=function(t){return t.tagName.toLowerCase()==='input'&&t.type==='checkbox';};
a.prototype.setAll=function(v){var c=this.getChecked();for(var i=0;i<c.length;i++){c[i].value=v;this.optionsList.find('input[index='+i+']').prop('checked',v);}this.setChecked(c,true);};
a.prototype.init=function(){this.setChecked([]);};
a.prototype.onBeforeRendering=function(){var c=this.getChecked(),o;if(c.length===0){o=this.getOptions();for(var i=0;i<o.length;i++){c[i]={text:o[i],value:false};}this.setChecked(c,true);}this.detachEvents();};
a.prototype.onAfterRendering=function(){this.cacheElements();this.attachEvents();};
a.prototype.cacheElements=function(){this.filterBtn=this.$('filterBtn');this.optionsList=this.$('optionsList');};
a.prototype.detachEvents=function(){if(this.filterBtn){this.filterBtn.off('click');}if(this.optionsList){this.optionsList.off('click');}};
a.prototype.attachEvents=function(){this.filterBtn.on('click',function(){this.setProperty("expanded",!this.getProperty("expanded"));}.bind(this));this.optionsList.on('click',this.onClick.bind(this));};
a.prototype.onsapfocusleave=function(e){this.setProperty("expanded",false);};
a.prototype.onClick=function(e){var i,c=this.getChecked(),t=e.target,I=a.isCheckbox(t),s=t.classList.contains("selectAll"),S=t.classList.contains("clearFilter"),b=I||s||S;if(I){i=t.getAttribute('index');c[i].value=e.target.checked;this.setProperty("checked",c,true);}else if(s){this.setAll(true,false);}else if(S){this.setAll(false,false);}if(b){this.fireEvent('change',{value:c});}};
a.prototype.getDefaultOptions=function(e){return[{text:"Clear Filter",key:"clearFilter"},{text:"Select All",key:"selectAll"}];};
return a;});
sap.ui.predefine('sap/ui/documentation/sdk/controller/util/datatable/filters/DataTableFilterDropDownRenderer',[],function(){"use strict";var D={apiVersion:2};
D.render=function(r,c){r.openStart("div",c);r.class("selectWrapper");r.openEnd();r.openStart("a",c.getId()+"-filterBtn");r.class("filterBtn");r.attr("tabindex",0);r.openEnd();r.text('Filter');r.close('a');r.openStart("ul",c.getId()+"-optionsList");if(!c.getProperty("expanded")){r.style("display","none");}r.openEnd();this.renderDefaultOptions(r,c);this.renderOptions(r,c);r.close("ul");r.close("div");};
D.renderOptions=function(r,c){var o=c.getOptions(),C=c.getChecked();o.forEach(function(O,i){r.openStart("li");r.openEnd("li");r.voidStart("input");if(C[i].value){r.attr("checked","true");}r.attr("type","checkbox");r.attr("index",i);r.voidEnd();r.text(O);r.close("li");});};
D.renderDefaultOptions=function(r,c){c.getDefaultOptions().forEach(function(o){r.openStart("li");r.openEnd("li");r.openStart("a");r.attr("tabindex",0);r.class(o.key);r.openEnd();r.text(o.text);r.close("a");r.close("li");});};
return D;},true);
sap.ui.predefine('sap/ui/documentation/sdk/controller/util/datatable/filters/DataTableFilterRange',["jquery.sap.global",'sap/ui/core/Control','./DataTableFilterRangeRenderer'],function($,C,D){"use strict";
var a=C.extend("sap.ui.documentation.sdk.DataTableFilterRange",{
metadata:{aggregations:{from:{type:"sap.m.Input",multiple:false},to:{type:"sap.m.Input",multiple:false}}},
renderer:D
});
a.M_EVENTS={LIVECHANGE:'liveChange'};
a.prototype.onBeforeRendering=function(){this.attachEvents();};
a.prototype.attachEvents=function(){var v,f,t;if(!this.bEventsAttached){this.bEventsAttached=true;f=this.getAggregation("from");t=this.getAggregation("to");[f,t].forEach(function(c){c.attachLiveChange(function(){v={from:f.getValue(),to:t.getValue()};this.fireEvent("liveChange",{value:v});},this);},this);}};
return a;});
sap.ui.predefine('sap/ui/documentation/sdk/controller/util/datatable/filters/DataTableFilterRangeRenderer',[],function(){"use strict";var D={apiVersion:2};
D.render=function(r,c){var f=c.getAggregation("from"),t=c.getAggregation("to");r.openStart("div",c);r.openEnd();if(f){r.renderControl(f);}if(t){r.renderControl(t);}r.close("div");};
return D;},true);
sap.ui.predefine('sap/ui/documentation/sdk/controller/util/overlay/Overlay',["sap/base/Log","./shapes/ShapeFactory"],function(L,S){"use strict";var a="http://www.w3.org/2000/svg";
function c(C){var s=document.createElementNS(a,'svg'),w=C.getBoundingClientRect().width,h=C.getBoundingClientRect().height;s.setAttribute('height',w);s.setAttribute('width',h);s.setAttribute('class','overlay');C.appendChild(s);return s;}
function O(C){this.oContainer=c(C);this.oShapes={};this.sCurrentShapeType='';}
O.prototype.setShape=function(s,C){var o=this.oShapes[s];if(!o){o=S.create(s,C);this.oShapes[s]=o;this.oContainer.appendChild(o.oContainer);}else{o.setPosition(C);}this.sCurrentShapeType=s;};
O.prototype.getCurrentShape=function(){return this.oShapes[this.sCurrentShapeType];};
O.prototype.show=function(){var s=this.getCurrentShape();if(s){s.show();}};
O.prototype.hide=function(){var s=this.getCurrentShape();if(s){s.hide();}};
return O;});
sap.ui.predefine('sap/ui/documentation/sdk/controller/util/overlay/shapes/Circle',["./Shape"],function(S){"use strict";var C=S.extend();
C.prototype.setPosition=function(c){var a=c.split(","),p={cx:a[0],cy:a[1],r:a[2]};this.oContainer.setAttribute("cx",p.cx);this.oContainer.setAttribute("cy",p.cy);this.oContainer.setAttribute("r",p.r);};
return C;});
sap.ui.predefine('sap/ui/documentation/sdk/controller/util/overlay/shapes/Polygon',["./Shape"],function(S){"use strict";var P=S.extend();
P.prototype.setPosition=function(c){this.oContainer.setAttribute("points",c);};
return P;});
sap.ui.predefine('sap/ui/documentation/sdk/controller/util/overlay/shapes/Rect',["./Shape"],function(S){"use strict";var R=S.extend();
R.prototype.setPosition=function(c){var C=c.split(","),p={x:C[0],y:C[1],width:C[2]-C[0],height:C[3]-C[1]};this.oContainer.setAttribute("x",p.x);this.oContainer.setAttribute("y",p.y);this.oContainer.setAttribute("width",p.width);this.oContainer.setAttribute("height",p.height);};
return R;});
sap.ui.predefine('sap/ui/documentation/sdk/controller/util/overlay/shapes/Shape',[],function(){"use strict";
function S(){this.oContainer=null;}
S.extend=function(){var c=function(){};c.prototype=new S();c.prototype.constructor=c;return c;};
S.prototype.createShape=function(s,a){this.oContainer=document.createElementNS(s,a);this.oContainer.classList.add('shape');this.oContainer.classList.add(a);return this;};
S.prototype.setPosition=function(c){};
S.prototype.show=function(){this.oContainer.style.opacity='1';};
S.prototype.hide=function(){this.oContainer.style.opacity='0';};
return S;});
sap.ui.predefine('sap/ui/documentation/sdk/controller/util/overlay/shapes/ShapeFactory',["./Rect","./Polygon","./Circle"],function(R,P,C){"use strict";var S="http://www.w3.org/2000/svg";
function c(s){switch(s){case'rect':return new R().createShape(S,s);case'poly':return new P().createShape(S,"polygon");case'circle':return new C().createShape(S,s);default:}}
return{create:c};});
sap.ui.predefine('sap/ui/documentation/sdk/model/formatter',["sap/ui/documentation/sdk/controller/util/JSDocUtil"],function(J){"use strict";var R=/^p\d+$/;return{crossLink:function(l){if(l[0]==="#"){l=document.location.href.substring(0,document.location.href.search("demoapps\.html"))+l;}return l;},libraryLink:function(n){if(n&&n.search("sap\\.")===0){return this.formatter.crossLink("#docs/api/symbols/"+n+".html");}else{return"";}},libraryLinkEnabled:function(n){return!!this.formatter.libraryLink.bind(this)(n);},categoryName:function(c){var r=this.getModel("i18n").getResourceBundle();c=c.toUpperCase();return r.getText("DEMO_APPS_CATEGORY_"+c);},apiRefEntityName:function(o){if(o){return o.replace("module:","");}},apiRefAggregationAltTypes:function(a){return a&&a.join(", ");},formatVersionTitle:function(p,t){if(t){return this.formatMessage(p,t);}return this.getModel("i18n").getResourceBundle().getText("API_DETAIL_NA_VERSION");},formatSenderLink:function(c,e,E){if(E==="methods"){return c+"#"+e;}if(E==="events"){return c+"#events:"+e;}if(E==="class"){return c;}return"";},formatIndexByVersionEntry:function(c,e,E,s,t){var T=this.formatSenderLink(c,e,E),h=this.formatApiHref(c,e,E,s),d=this.formatLinks(t);return'<a href="'+h+'" class="sapMLnk sapMLnkMaxWidth">'+T+'</a>'+d;},formatApiHref:function(c,e,E,s){var h;if(s){e=c+"."+e;}h="api/"+c;if(E!=="class"){h+="/"+E+"/"+e;}return h;},formatLinks:function(t){return J.formatTextBlock(t,{linkFormatter:function(a,b){var h;if(a.match("://")){return'<a target="_blank" href="'+a+'">'+(b||a)+'</a>';}a=a.trim().replace(/\.prototype\./g,"#");h=a.indexOf("#");b=b||a;if(h<0){var l=a.lastIndexOf("."),c=a.substring(0,l),m=a.substring(l+1),d=m;if(d){if(d.static===true){a=c+'/methods/'+c+'.'+m;}else{a=c+'/methods/'+m;}}}if(h===0){return"<code>"+a.slice(1)+"</code>";}if(h>0){a=a.slice(0,h)+'/methods/'+a.slice(h+1);}return"<a class=\"jsdoclink\" href=\"api/"+a+"\" target=\"_self\">"+b+"</a>";}});},filePathToRouteParams:function(f){var F,r={};if(!f){return{};}F=f.split("/");F.forEach(function(p,i){r["p"+ ++i]=p;});return r;},routeParamsToFilePath:function(r){var k=Object.keys(r),I,f,F=[];for(var i=0;i<k.length;i++){I=R.test(k[i]);f=I&&r[k[i]];if(f){F.push(f);}if(I&&!f){break;}}if(F.length){return F.join("/");}},formatHttpHrefForNewWindow:function(h){if(window['sap-ui-documentation-static']&&!/^https?:\/\//.test(h)){h="#/"+h;}return h;},formatCookieValue:function(v){if(v==="1"){return true;}if(v==="0"){return false;}return v;}};});
sap.ui.predefine('sap/ui/documentation/sdk/model/libraryData',["sap/ui/thirdparty/jquery",'sap/ui/documentation/library',"sap/base/Log"],function(q,l,L){"use strict";
function c(d,s,b){var e=[];if(q.isPlainObject(d.links)){e=Object.keys(d.links).map(function(k){return{name:k,ref:d.links[k]};});}var A={lib:d.namespace||b,name:d.text,icon:d.icon,desc:d.desc,config:d.config,teaser:d.teaser,category:d.category,ref:(d.resolve==="lib"?s:"")+d.ref+"?sap-ui-theme=sap_fiori_3",links:e};return A;}
function a(b,d){var C=["Showcase","Tutorial","Template","RTA","Misc"];var D={};C.forEach(function(s){D[s]=[];});var o={demoApps:[],demoAppsByCategory:[]};for(var i=0;i<b.length;i++){var e=d[b[i]].demo;if(!e){continue;}if(e.links&&e.links.length>0){for(var j=0;j<e.links.length;j++){var f=c(e.links[j],d[b[i]].libraryUrl,e.text);o.demoApps.push(f);if(C.indexOf(f.category)<0){L.warning("Demo app category \""+f.category+"\" not found, correcting demo app \""+f.name+"\" to \"Misc\"");f.category="Misc";}if(e.links[j].category!=="Tool"){D[f.category].push(f);}}}}Object.keys(D).forEach(function(k){if(D[k].length===0){return;}var r=[];var g=r.push([]);var h=0;for(var i=0;i<D[k].length;i++){h++;if(D[k][i].teaser){h++;}if(h>4){g=r.push([]);h=0;}r[g-1].push(D[k][i]);}o.demoAppsByCategory.push({categoryId:k,rows:r});});return o;}
return{fillJSONModel:function(m){function h(b,d){m.setProperty("/bFooterVisible",true);if(!b){return;}var M=m.getData();m.setData(q.extend(M,a(b,d)));}m.setProperty("/bFooterVisible",false);l._loadAllLibInfo("","_getDocuIndex",h);}};});
sap.ui.predefine('sap/ui/documentation/sdk/model/models',["sap/ui/model/json/JSONModel","sap/ui/Device"],function(J,D){"use strict";return{createDeviceModel:function(){var m=new J(D);m.setDefaultBindingMode("OneWay");return m;}};});
sap.ui.predefine('sap/ui/documentation/sdk/model/sourceFileDownloader',["sap/ui/thirdparty/jquery"],function(q){"use strict";var c={};return function(u){return new Promise(function(r){var s=function(a){c[u]=a;r(a);};var e=function(){r({errorMessage:"FIle not found: '"+u+"'"});};if(!(u in c)){q.ajax(u,{dataType:"text",success:s,error:e});}else{r(c[u]);}});};});
sap.ui.predefine('sap/ui/documentation/sdk/util/DocumentationRouter',['sap/m/routing/Router','sap/ui/core/routing/History','sap/ui/thirdparty/hasher',"sap/ui/documentation/sdk/controller/util/ControlsInfo"],function(R,H,a,C){"use strict";a.raw=true;
var D=R.extend("sap.ui.documentation.sdk.util.DocumentationRouter",{
constructor:function(){R.prototype.constructor.apply(this,arguments);this._URLSeparator=window['sap-ui-documentation-static']?"%23":"#";this.getRoute("entitySamplesLegacyRoute").attachPatternMatched(this._onOldEntityRouteMatched,this);this.getRoute("entityAboutLegacyRoute").attachPatternMatched(this._onOldEntityRouteMatched,this);this.getRoute("entityPropertiesLegacyRoute").attachPatternMatched({entityType:"controlProperties"},this._forwardToAPIRef,this);this.getRoute("entityAggregationsLegacyRoute").attachPatternMatched({entityType:"aggregations"},this._forwardToAPIRef,this);this.getRoute("entityAssociationsLegacyRoute").attachPatternMatched({entityType:"associations"},this._forwardToAPIRef,this);this.getRoute("entityEventsLegacyRoute").attachPatternMatched({entityType:"events"},this._forwardToAPIRef,this);this.getRoute("entityMethodsLegacyRoute").attachPatternMatched({entityType:"methods"},this._forwardToAPIRef,this);this.getRoute("topicIdLegacyRoute").attachPatternMatched(this._onOldTopicRouteMatched,this);this.getRoute("apiIdLegacyRoute").attachPatternMatched(this._onOldApiRouteMatched,this);this.getRoute("sampleLegacyRoute").attachPatternMatched({routeName:"sample"},this._onOldSampleRouteMatched,this);this.getRoute("codeLegacyRoute").attachPatternMatched({routeName:"code"},this._onOldSampleRouteMatched,this);this.getRoute("codeFileLegacyRoute").attachPatternMatched({routeName:"codeFile"},this._onOldSampleRouteMatched,this);this.getRoute("ReleaseNotesLegacyRoute").attachPatternMatched(function(){this.navTo("releaseNotes");},this);},
_onOldEntityRouteMatched:function(e){this.navTo("entity",{id:e.getParameter("arguments").id},true);},
_forwardToAPIRef:function(e,d){d||(d={});d['id']=e.getParameter("arguments").id;this.navTo("apiId",d);},
_onOldSampleRouteMatched:function(e,E){var A=e.getParameter("arguments"),s=A.id;C.loadData().then(function(d){var S=d.samples[s],n;if(!S){this.myNavToWithoutHash("sap.ui.documentation.sdk.view.NotFound","XML",false);}n={entityId:S.contexts?Object.keys(S.contexts)[0]:S.entityId,sampleId:s};if(E.routeName==="codeFile"){n['fileName']=decodeURIComponent(A.fileName);}this.navTo(E.routeName,n,true);}.bind(this));},
_onOldTopicRouteMatched:function(e){this.navTo("topicId",{id:e.getParameter("arguments").id.replace(/.html$/,"")},true);},
_onOldApiRouteMatched:function(e){var E,s,S,I=e.getParameter("arguments").id;if(I){S=I.split("#");if(S.length===2){I=S[0];E=S[1];S=E.split(":");if(S.length===2){E=S[0];s=S[1];}}I=I.replace(/.html$/,"");if(E==='event'){E="events";}}this.navTo("apiId",{id:I,entityType:E,entityId:s},true);},
myNavBack:function(r,d){var h=H.getInstance();var p=h.getPreviousHash();if(p!==undefined){window.history.go(-1);}else{var c=true;this.navTo(r,d,c);}},
myNavToWithoutHash:function(v,c,m,d){var o=this._getOwnerComponent(),r=o.byId(o.getManifestEntry("/sap.ui5/rootView").id);r.loaded().then(function(r){var A=r.byId("splitApp"),V=this.getView(v,c);A.addPage(V,m);A.toDetail(V.getId(),"show",d);}.bind(this));},
_getOwnerComponent:function(){return this._oOwner;},
_destroySampleComponent:function(){var c=this._getOwnerComponent()._oCurrentOpenedSample;if(c){c.destroy();c=null;}}
});
D.prototype.linkClickHandler=function(e){if(e.defaultPrevented){e.preventDefault();return;}var E=e.target,A,p,c=e.ctrlKey||e.metaKey,t;if(!E){return;}if(E.classList.contains('sap-doc')){return;}if(E.classList.contains("scrollToMethod")||E.classList.contains("scrollToEvent")||E.classList.contains("scrollToAnnotation")){if(e.preventDefault){e.preventDefault();}return;}if(c){return;}A=g(E);t=b(A);p=/^blob:/.test(t)||/^https?:\/\//.test(t)||/^test-resources\//.test(t)||/^resources\//.test(t);if(t&&!p){if(e.preventDefault){e.preventDefault();}if(t==="#"){t="";}if(window['sap-ui-documentation-static']&&this.shouldConvertHash(t)){t=t.replace("#","%23");}this.parse(t);if(window['sap-ui-documentation-static']){window.history.pushState({},undefined,"#/"+t);}else{window.history.pushState({},undefined,t);}}};
D.prototype.mouseDownClickHandler=function(e){var p=e.buttons,t=e.target,A=g(t),c=e.ctrlKey||e.metaKey,T;if(A){if(A.classList.contains('sap-doc')){return;}T=b(A);}if(!T||/^https?:\/\//.test(T)||T.endsWith(".html")){return;}if(p===2||p===4||(c&&p===1)){T=this.convertToStaticFormat(T);A.setAttribute("href",T);}};
D.prototype.popstateHandler=function(){var s=!!window['sap-ui-documentation-static'],r=s?location.hash.replace(/^[#/]/,""):this._processPath(location.pathname);this.parse(r);};
D.prototype.attachGlobalLinkHandler=function(){if(!this._bGlobalHandlerAttached){document.body.addEventListener("click",this.linkClickHandler.bind(this));window['sap-ui-documentation-static']&&document.body.addEventListener("mousedown",this.mouseDownClickHandler.bind(this),true);this._bGlobalHandlerAttached=true;}};
D.prototype.attachPopstateHandler=function(){if(!this._bPopstateHandlerAttached){window.addEventListener('popstate',this.popstateHandler.bind(this));this._bPopstateHandlerAttached=true;}};
D.prototype._decodeSpecialRouteArguments=function(e){var A=e.getParameters().arguments,E=[],m,M=[],t;if(A.p1===undefined){if(A.id.indexOf(this._URLSeparator)>-1){t=A.id.split(this._URLSeparator);A.id=t[0];A.p1=t[1];}return{id:decodeURIComponent(A.id),entityId:undefined,entityType:A.p1};}if(/^module:\S+$/.test(A.id)){Object.keys(A).forEach(function(k){var s=A[k],t;if(!s){return;}if(!m&&s.indexOf(this._URLSeparator)!==-1){t=s.split(this._URLSeparator);E.push(t[0]);m=t[1];return;}if(!m){E.push(s);}else{M.push(s);}}.bind(this));return{id:E.join("/"),entityId:M.length?M.join("/"):undefined,entityType:m};}if(A.id.indexOf(this._URLSeparator)!==-1){t=A.id.split(this._URLSeparator);A.p2=A.p1;A.id=t[0];A.p1=t[1];}return{id:decodeURIComponent(A.id),entityType:A.p1,entityId:A.p2?decodeURIComponent(A.p2):undefined};};
D.prototype.navTo=function(n,p,r){var P;var s=r?"replaceState":"pushState";this._destroySampleComponent();if(n==="apiId"){if(p.id){p.id=encodeURIComponent(p.id);}if(p.entityId){p.entityId=encodeURIComponent(p.entityId);}}P=this.getURL(n,p);if(n==="apiId"){P=P.replace(/#$/,"");P=decodeURIComponent(P);}this.parse(P);if(window['sap-ui-documentation-static']){window.history[s]({},undefined,"#/"+P.replace("#",this._URLSeparator));}else{window.history[s]({},undefined,P);}return this;};
if(!window['sap-ui-documentation-static']){D.prototype._processPath=function(p){var B=document.querySelector("base[href]"),s=B?B.getAttribute("href"):"",c=s.slice(0,s.length-1),h=location.hash,t;if(p.startsWith(s)){p=p.replace(s,"");}else if(p.startsWith(c)){p=p.replace(c,"");}if(h){if(!p&&h.indexOf("module%3A")!==-1){t=h.split("/");h="#"+t[1]+"/"+decodeURIComponent(t[2])+(t[3]?"#"+t[3]:"")+(!t[3]?"/":"")+(t[4]?"/"+decodeURIComponent(t[4]):"");}p+=(p?"#":"")+h.slice(1);}return p;};D.prototype.initialize=function(){var p=this._processPath(location.pathname);this.stop();this.parse(p);this.attachPopstateHandler();this.attachGlobalLinkHandler();return this;};D.prototype.navToChangeUrlOnly=function(p,h){var P;if(p.id){p.id=encodeURIComponent(p.id);}if(p.entityId){p.entityId=encodeURIComponent(p.entityId);}P=this.getURL("apiId",p);P=decodeURIComponent(P);if(h){window.history.pushState({},undefined,P);}else{window.history.replaceState({},undefined,P);}return this;};}else{D.prototype.initialize=function(){R.prototype.initialize.apply(this,arguments);this.attachPopstateHandler();this.attachGlobalLinkHandler();return this;};D.prototype.navToChangeUrlOnly=function(p,h){var P;if(p.id){p.id=encodeURIComponent(p.id);}if(p.entityId){p.entityId=encodeURIComponent(p.entityId);}P=this.getURL("apiId",p);P=decodeURIComponent(P);P=P.replace("#",this._URLSeparator);this.stop();hasher.stop();if(h){hasher.setHash(P);}else{hasher.replaceHash(P);}hasher.init();this.initialize(true);};}
D.prototype.shouldConvertHash=function(t){return this.getRoute("apiId").match(t)||this.getRoute("apiSpecialRoute").match(t);};
D.prototype.convertToStaticFormat=function(h){var l=window.location,n=h;if(this.shouldConvertHash(h)){n=h.replace("#","%23");}n=l.origin+l.pathname+"#/"+n;return n;};
function g(A,m){var I=i(A),d=0;m||(m=3);while(!I&&d++<m){A=A.parentElement;I=i(A);}return A;}
function i(A){if(A&&A.nodeName==="A"&&A.getAttribute("target")!=="_blank"){return true;}return false;}
function b(A){return A.getAttribute("href");}
return D;});
sap.ui.predefine('sap/ui/documentation/sdk/util/Resources',['sap/ui/thirdparty/URI'],function(U){"use strict";var R={getResourceOriginPath:function(p){var c,o,u=U(p);if(u&&u.is("absolute")){return p;}c=window['sap-ui-documentation-config'];o=(c&&c.demoKitResourceOrigin)||'.';return o+this._formatPath(p);},_formatPath:function(p){p=p.replace(/^\.\//,'/');if(!p.match(/^\//)){p="/"+p;}return p;}};return R;},true);
sap.ui.predefine('sap/ui/documentation/sdk/util/ToggleFullScreenHandler',[],function(){"use strict";var T={updateMode:function(e,v,c){var s=(this._getSplitApp(c).getMode()==="ShowHideMode");if(s){this._getSplitApp(c).setMode('HideMode');}else{this._getSplitApp(c).setMode('ShowHideMode');}this.updateControl(e.getSource(),v,s,c);},_getSplitApp:function(c){if(!this._oSplitApp){this._oSplitApp=c.getSplitApp();}return this._oSplitApp;},updateControl:function(b,v,f,c){if(arguments.length===2){f=!(this._getSplitApp(c).getMode()==="ShowHideMode");}if(!f){b.setTooltip("Show this sample in full screen mode");b.setIcon('sap-icon://full-screen');}else{b.setTooltip("Show this sample in the detail view of a split container.");b.setIcon('sap-icon://exit-full-screen');}},cleanUp:function(){this._oSplitApp=null;}};return T;},true);
sap.ui.predefine('sap/ui/documentation/sdk/controller/DemoApps.controller',["sap/ui/thirdparty/jquery","sap/ui/documentation/sdk/controller/BaseController","sap/ui/model/resource/ResourceModel","sap/ui/Device","sap/ui/model/json/JSONModel","sap/ui/documentation/sdk/model/sourceFileDownloader","sap/ui/documentation/sdk/model/formatter","sap/m/MessageBox","sap/m/MessageToast","sap/ui/model/Filter","sap/ui/model/FilterOperator",'sap/ui/documentation/sdk/model/libraryData',"sap/base/Log"],function(q,B,R,D,J,s,f,M,a,F,b,l,L){"use strict";return B.extend("sap.ui.documentation.sdk.controller.DemoApps",{formatter:f,onInit:function(){var m=new J(),o=new R({bundleName:"sap.ui.documentation.messagebundle"});l.fillJSONModel(m);this.setModel(m);this.getView().setModel(o,"i18n");this.getRouter().getRoute("demoapps").attachPatternMatched(this._onMatched,this);sap.ui.getVersionInfo({async:true}).then(function(v){var V=new J({isOpenUI5:v&&v.gav&&/openui5/i.test(v.gav)});this.getView().setModel(V,"appView");}.bind(this));this._onOrientationChange({landscape:D.orientation.landscape});this._onResize({name:(D.resize.width<=600?"Phone":"NoPhone")});},onBeforeRendering:function(){this._deregisterOrientationChange();},onAfterRendering:function(){this._registerOrientationChange();this._registerResize();},onExit:function(){this._deregisterOrientationChange();this._deregisterResize();},_registerOrientationChange:function(){D.orientation.attachHandler(this._onOrientationChange,this);},_deregisterOrientationChange:function(){D.orientation.detachHandler(this._onOrientationChange,this);},_registerResize:function(){D.media.attachHandler(this._onResize,this);},_deregisterResize:function(){D.media.detachHandler(this._onResize,this);},_onOrientationChange:function(e){this.byId("phoneImage").toggleStyleClass("phoneHeaderImageLandscape",e.landscape);},_onResize:function(e){this.byId("phoneImage").setVisible(e.name==="Phone");this.byId("desktopImage").setVisible(e.name!=="Phone");this.byId("phoneImage").toggleStyleClass("phoneHeaderImageDesktop",e.name==="Phone");},_onMatched:function(){try{this.hideMasterSide();}catch(e){L.error(e);}},onDownloadButtonPress:function(e){var d=this.byId("downloadDialog");this._oDownloadButton=e.getSource();d.getBinding("items").filter([]);d.open();d._oDialog.setContentHeight("");},onReadMoreButtonPress:function(){var c=f.formatHttpHrefForNewWindow(this.getModel("newWindowLinks").getProperty("/demoAppsHomeLink"));window.open(c,"_blank");},onSearch:function(e){e.getParameters().itemsBinding.filter([new F("name",b.Contains,e.getParameters().value)]);},onDownloadPress:function(e){var S=e.getParameters().selectedItem,o=S?S:e.getSource().getParent();this._oDownloadButton.setBusy(true);sap.ui.require(["sap/ui/core/util/File","sap/ui/thirdparty/jszip"],function(c,d){var z=new d();q.getJSON(o.data("config"),function(C){var g=C.files,p=[],h=[];g.forEach(function(j){var P=s(C.cwd+j);P.then(function(k){if(k.errorMessage){h.push(k.errorMessage);}else{if(!j.startsWith("../")){z.file(j,k,{base64:false,binary:true});}}});p.push(P);});
// add generic license and notice file
var i=s(sap.ui.require.toUrl("sap/ui/documentation/sdk/tmpl/LICENSE.txt"));i.then(function(j){z.file("LICENSE.txt",j,{base64:false,binary:true});});p.push(i);var n=s(sap.ui.require.toUrl("sap/ui/documentation/sdk/tmpl/NOTICE.txt"));n.then(function(j){z.file("NOTICE.txt",j,{base64:false,binary:true});});p.push(n);Promise.all(p).then(function(){if(h.length){var j=h.reduce(function(E,m){return E+m+"\n";},"Could not locate the following download files:\n");this._handleError(j);}this._oDownloadButton.setBusy(false);a.show("Downloading for app \""+o.getLabel()+"\" has been started");var k=z.generate({type:"blob"});this._createArchive(c,k,o.getLabel());}.bind(this));}.bind(this));}.bind(this));},createDemoAppCell:function(i,o){var c;if(o.getObject().teaser){try{sap.ui.loader.config({paths:{"test-resources":"test-resources"}});var r=sap.ui.require.toUrl(o.getObject().teaser);var t=sap.ui.xmlfragment(i,r);c=sap.ui.xmlfragment(i,"sap.ui.documentation.sdk.view.BlockLayoutTeaserCell",this);c.getContent()[0].addContent(t);sap.ui.loader.config({paths:{"test-resources":null}});t.addEventDelegate({"onAfterRendering":function(){this.getParent().getDomRef().childNodes[1].setAttribute("aria-hidden","true");}.bind(t)});}catch(e){L.warning("Teaser for demo app \""+o.getObject().name+"\" could not be loaded: "+e);c=sap.ui.xmlfragment(i,"sap.ui.documentation.sdk.view.BlockLayoutCell",this);}}else{c=sap.ui.xmlfragment(i,"sap.ui.documentation.sdk.view.BlockLayoutCell",this);}c.setBindingContext(o);return c;},_createArchive:function(c,C,d){c.save(C,d,"zip","application/zip");},_handleError:function(e){M.error(e);},handleLandingImageLoad:function(){this.byId("landingImageHeadline").setVisible(true);}});});
/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/documentation/sdk/controller/License.controller',["sap/ui/documentation/sdk/controller/BaseController","sap/ui/documentation/library"],function(B,l){"use strict";return B.extend("sap.ui.documentation.sdk.controller.License",{onInit:function(){this.getRouter().getRoute("license").attachPatternMatched(this._onTopicMatched,this);},_onTopicMatched:function(e){
// Get the LICENSE.txt file and display it. In case of error redirect to NotFound view.
l._getLicense().done(function(L){if(L!==""){this.getView().byId("licenseText").setText(L);}else{this.getRouter().myNavToWithoutHash("sap.ui.documentation.sdk.view.NotFound","XML",false);}}.bind(this)).fail(function(){this.getRouter().myNavToWithoutHash("sap.ui.documentation.sdk.view.NotFound","XML",false);}.bind(this));}});});
/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/documentation/sdk/controller/SampleBaseController',["sap/ui/documentation/sdk/controller/BaseController","sap/ui/thirdparty/URI","sap/base/Log"],function(B,U,L){"use strict";var T=sap.ui.require.toUrl("sap/ui/documentation/sdk/tmpl"),M=sap.ui.require.toUrl("sap/ui/demo/mock");var A={_fetchPromises:{},fetch:function(u){if(!(u in this._fetchPromises)){this._fetchPromises[u]=this._fetch(u);}return this._fetchPromises[u];},_fetch:function(u){return new Promise(function(r,a){var R,s,b=this._getExpectedResponseType(u);function h(e){s=e.type==="load"&&(R.status===200||R.status===0);if(!s){a(new Error("could not fetch '"+u+"': "+R.status));return;}r(A._readResponse(R));}R=new XMLHttpRequest();R.open("GET",u,true);R.responseType=b;R.onload=R.onerror=h;R.send();}.bind(this));},_readResponse:function(r){var R=r.responseType,o=(R==="text")?r.responseText:r.response;if(R==="arraybuffer"){try{o=new Uint8Array(o);}catch(e){}}return o;},_getExpectedResponseType:function(r){if(r.match(/.+(.vds|.pdf)$/i)){return"arraybuffer";}return"text";}};return B.extend("sap.ui.documentation.sdk.controller.SampleBaseController",{_aMockFiles:["products.json","supplier.json","img.json"],fetchSourceFile:function(u){return A.fetch(u).catch(function(e){L.warning(e);return"File not loaded";});},onDownload:function(){sap.ui.require(["sap/ui/thirdparty/jszip","sap/ui/core/util/File"],function(J,F){var z=new J(),r=sap.ui.require.toUrl((this._sId).replace(/\./g,"/")),d=this.oModel.getData(),e=d.includeInDownload||[],h,p=[],a=function(R){var m=[];for(var j=0;j<this._aMockFiles.length;j++){var s=this._aMockFiles[j];if((typeof R==="string")&&R.indexOf(s)>-1){m.push(this._addFileToZip({name:"mockdata/"+s,url:M+"/"+s,formatter:this._formatMockFile},z));}}return Promise.all(m);};for(var i=0;i<d.files.length;i++){var f=d.files[i],u=r+"/"+f.name,c=f.name&&(f.name===d.iframe||f.name.split(".").pop()==="html");p.push(this._addFileToZip({name:f.name,url:u,formatter:c?this._changeIframeBootstrapToCloud:undefined},z));p.push(this.fetchSourceFile(u).then(a.bind(this)));}if(!d.iframe){h=d.files.some(function(f){return f.name==="manifest.json";});p.push(this._addFileToZip({name:"Component.js",url:r+"/"+"Component.js"},z));p.push(this._addFileToZip({name:"index.html",url:T+"/"+(h?"indexevo.html.tmpl":"index.html.tmpl"),formatter:function(I){return this._changeIframeBootstrapToCloud(this._formatIndexHtmlFile(I,d));}.bind(this)},z));if(!h){p.push(this._addFileToZip({name:"index.js",url:T+"/"+"index.js.tmpl",formatter:function(I){return this._changeIframeBootstrapToCloud(this._formatIndexJsFile(I,d));}.bind(this)},z));}}e.forEach(function(s){p.push(this._addFileToZip({name:s,url:r+"/"+s},z));});
// add generic license and notice file
p.push(this._addFileToZip({name:"LICENSE.txt",url:T+"/"+"LICENSE.txt"},z));p.push(this._addFileToZip({name:"NOTICE.txt",url:T+"/"+"NOTICE.txt"},z));Promise.all(p).then(function(){var C=z.generate({type:"blob"});this._openGeneratedFile(C,this._sId);}.bind(this));}.bind(this));},_openGeneratedFile:function(c,i){sap.ui.require(["sap/ui/core/util/File"],function(F){F.save(c,i,"zip","application/zip");});},_addFileToZip:function(f,z){var F=f.name,u=f.url,a=f.formatter;return this.fetchSourceFile(u).then(function(r){if(a){r=a(r);}z.file(F,r);});},_formatIndexHtmlFile:function(f,d){return f.replace(/{{TITLE}}/g,d.name).replace(/{{SAMPLE_ID}}/g,d.id);},_formatIndexJsFile:function(f,d){return f.replace(/{{TITLE}}/g,d.name).replace(/{{SAMPLE_ID}}/g,d.id).replace(/{{HEIGHT}}/g,d.stretch?'height : "100%", ':"").replace(/{{SCROLLING}}/g,!d.stretch);},_formatMockFile:function(m){var w="test-resources/sap/ui/documentation/sdk/images/",c="https://openui5.hana.ondemand.com/test-resources/sap/ui/documentation/sdk/images/",r=new RegExp(w,"g");return m.replace(r,c);},_changeIframeBootstrapToCloud:function(r){var a=/src=(?:"[^"]*\/sap-ui-core\.js"|'[^']*\/sap-ui-core\.js')/,c=new U(document.baseURI).search(""),R=new U(sap.ui.require.toUrl("")+"/sap-ui-core.js"),b=R.absoluteTo(c).toString();return r.replace(a,'src="'+b+'"');}});});
sap.ui.require.preload({
	"sap/ui/documentation/manifest.json":'{"_version":"1.21.0","sap.app":{"id":"sap.ui.documentation","type":"library","embeds":["sdk"],"applicationVersion":{"version":"1.84.0"},"title":"SAPUI5 library for the Demokit 2.0.","description":"SAPUI5 library for the Demokit 2.0.","resources":"resources.json","offline":true,"openSourceComponents":[{"name":"esprima","packagedWithMySelf":true,"version":"0.0.0"},{"name":"google-code-prettify","packagedWithMySelf":true,"version":"0.0.0"},{"name":"elasticlunr","packagedWithMySelf":true,"version":"0.0.0"}]},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_belize","sap_belize_hcb","sap_belize_hcw","sap_belize_plus","sap_fiori_3","sap_fiori_3_dark","sap_fiori_3_hcb","sap_fiori_3_hcw"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.84","libs":{"sap.ui.core":{"minVersion":"1.84.0"},"sap.ui.layout":{"minVersion":"1.84.0"},"sap.m":{"minVersion":"1.84.0"}}},"library":{"i18n":{"bundleUrl":"messagebundle.properties","supportedLocales":["","ar","bg","ca","cs","da","de","el","en","en-GB","en-US-sappsd","en-US-saptrc","es","et","fi","fr","hi","hr","hu","it","iw","ja","kk","ko","lt","lv","ms","nl","no","pl","pt","rigi","ro","ru","sh","sk","sl","sv","th","tr","uk","vi","zh-CN","zh-TW"]},"content":{"controls":["sap.ui.documentation.BorrowedList","sap.ui.documentation.DemokitTreeItem","sap.ui.documentation.JSDocText","sap.ui.documentation.LightTable","sap.ui.documentation.ObjectPageSubSection","sap.ui.documentation.ParamText","sap.ui.documentation.Search","sap.ui.documentation.TitleLink"],"elements":["sap.ui.documentation.Row","sap.ui.documentation.WebPageTitleUtil"],"types":[],"interfaces":[]}}}}',
	"sap/ui/documentation/sdk/blocks/IndexEntry.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.blocks.IndexEntry" xmlns:mvc="sap.ui.core.mvc" xmlns="sap.uxap" xmlns:m="sap.m" xmlns:custom="sap.ui.documentation" xmlns:app="http://schemas.sap.com/sapui5/extension/sap.ui.core.CustomData/1"><m:List items="{path:\'apis\',templateShareable:false}" showSeparators="Inner" class="sapUxAPObjectPageSubSectionAlignContent" width="auto"><m:items><m:CustomListItem class="indexEntry"><custom:JSDocText text="{parts:[{path:\'control\'},{path:\'entityName\'},{path:\'type\'},{path:\'static\'},{path:\'text\'}],formatter:\'.formatText\'}" app:control="{control}" app:entity="{entityName}" app:type="{type}" app:static="{static}" app:text="{text}"/></m:CustomListItem></m:items></m:List></mvc:View>',
	"sap/ui/documentation/sdk/manifest.json":'{"_version":"1.12.0","sap.app":{"id":"sap.ui.documentation.sdk","type":"application","title":"OpenUI5 SDK - Demo Kit","applicationVersion":{"version":"1.0.0"}},"sap.ui":{"technology":"UI5","icons":{"icon":"sap-icon://detail-view","favIcon":"","phone":"","phone@2":"","tablet":"","tablet@2":""},"deviceTypes":{"desktop":true,"tablet":true,"phone":true}},"sap.ui5":{"rootView":{"viewName":"sap.ui.documentation.sdk.view.App","type":"XML","async":true,"id":"app"},"dependencies":{"minUI5Version":"1.46.0","libs":{"sap.ui.core":{"minVersion":"1.46.0"},"sap.m":{"minVersion":"1.46.0"},"sap.ui.layout":{"minVersion":"1.46.0"},"sap.f":{"minVersion":"1.46.0"},"sap.uxap":{"minVersion":"1.46.0"},"sap.tnt":{"minVersion":"1.46.0"},"sap.ui.codeeditor":{"minVersion":"1.46.0"}}},"contentDensities":{"compact":true,"cozy":true},"config":{"docuPath":"./docs/topics/","exploredURI":"./","topicHtmlMainDivId":"d4h5-main-container"},"routing":{"config":{"routerClass":"sap.ui.documentation.sdk.util.DocumentationRouter","viewType":"XML","viewPath":"sap.ui.documentation.sdk.view","controlId":"splitApp","controlAggregation":"detailPages","bypassed":{"target":["welcome"]},"async":true,"clearTarget":false},"routes":[{"pattern":"","name":"welcome","target":["welcome"]},{"pattern":"controlsMaster","name":"controlsMaster","target":["controlsMaster"]},{"pattern":"controls","name":"controls","target":["controlsMaster","controls"]},{"pattern":"controls/filter/{value}","name":"listFilter","target":["controlsMaster","controls"]},{"pattern":"group/{id}","name":"group","target":["controlsMaster","group"]},{"pattern":"entity/{id}/samples","name":"entitySamplesLegacyRoute"},{"pattern":"entity/{id}/about","name":"entityAboutLegacyRoute"},{"pattern":"entity/{id}/properties","name":"entityPropertiesLegacyRoute"},{"pattern":"entity/{id}/aggregations","name":"entityAggregationsLegacyRoute"},{"pattern":"entity/{id}/associations","name":"entityAssociationsLegacyRoute"},{"pattern":"entity/{id}/events","name":"entityEventsLegacyRoute"},{"pattern":"entity/{id}/methods","name":"entityMethodsLegacyRoute"},{"pattern":"topic/a6a78b7e104348b4bb94fb8bcf003480","name":"ReleaseNotesLegacyRoute"},{"pattern":"entity/{id}/:sectionTab:","name":"entity","target":["controlsMaster","entity"]},{"pattern":"sample/{id}/preview","name":"sampleLegacyRoute"},{"pattern":"sample/{id}/code","name":"codeLegacyRoute"},{"pattern":"sample/{id}/code/{fileName}","name":"codeFileLegacyRoute"},{"pattern":"entity/{entityId}/sample/{sampleId}","name":"sample","target":["controlsMaster","sample"]},{"pattern":"entity/{entityId}/sample/{sampleId}/code","name":"code","target":["controlsMaster","code"]},{"pattern":"entity/{entityId}/sample/{sampleId}/code/:p1:/:p2:/:p3:/:p4:/:p5:/:p6:/:p7:/:p8:/:p9:/:p10:/:p11:/:p12:/:p13:/:p14:/:p15:","name":"codeFile","target":["controlsMaster","code"]},{"pattern":"downloads","name":"downloads","target":["downloads"]},{"pattern":"api","name":"api","target":["apiMaster","apiDetailInitial"]},{"pattern":"api/deprecated","name":"deprecated","target":["apiMaster","apiDetailDeprecated"]},{"pattern":"api/experimental","name":"experimental","target":["apiMaster","apiDetailExperimental"]},{"pattern":"api/since","name":"since","target":["apiMaster","apiDetailSince"]},{"pattern":"api/{id}/:p1:/:p2:/:p3:/:p4:/:p5:/:p6:/:p7:/:p8:/:p9:/:p10:/:p11:/:p12:/:p13:/:p14:/:p15:","name":"apiSpecialRoute","target":["apiMaster","apiDetail"]},{"pattern":"api/{id}#:entityType:/:entityId:","name":"apiId","target":["apiMaster","apiDetail"]},{"pattern":"topic","name":"topic","target":["topicMaster","topicDetailInitial"]},{"pattern":"topic/{id}","name":"topicId","target":["topicMaster","topicDetail"]},{"pattern":"topic/{id}/{subId}","name":"subTopicId","target":["topicMaster","topicDetail"]},{"pattern":"demoapps","name":"demoapps","target":["demoApps"]},{"pattern":"tools","name":"tools","target":["tools"]},{"pattern":"search/{searchParam}","name":"search","target":["searchPage"]},{"pattern":"releasenotes.html","name":"releaseNotes","target":["topicMaster","releaseNotes"]},{"pattern":"versioninfo.html","name":"versionInfo","target":["topicMaster","versionInfo"]},{"pattern":"LICENSE.txt","name":"license","target":["license"]},{"pattern":"TermsOfUse.txt","name":"termsOfUse","target":["termsOfUse"]},{"pattern":"docs/guide/{id}","name":"topicIdLegacyRoute"},{"pattern":"docs/api/symbols/{id}","name":"apiIdLegacyRoute"}],"targets":{"empty":{"viewName":"Empty","viewLevel":1,"viewId":"empty","controlAggregation":"masterPages"},"welcome":{"viewName":"Welcome","viewLevel":2,"viewId":"welcome"},"controls":{"viewName":"Controls","viewLevel":2,"viewId":"controls"},"controlsMaster":{"viewName":"ControlsMaster","viewLevel":1,"viewId":"controlsMaster","controlAggregation":"masterPages"},"group":{"viewName":"Group","viewLevel":2,"viewId":"group"},"entity":{"viewName":"Entity","viewLevel":2,"viewId":"entity"},"sample":{"viewName":"Sample","viewLevel":2,"viewId":"sample"},"code":{"viewName":"Code","viewLevel":2,"viewId":"code","transition":"flip"},"downloads":{"viewName":"Downloads","viewLevel":2,"viewId":"downloads"},"apiMaster":{"viewName":"ApiMaster","viewLevel":1,"viewId":"apiMaster","controlAggregation":"masterPages"},"demoApps":{"viewName":"DemoApps","viewLevel":2,"viewId":"demoApps"},"tools":{"viewName":"Tools","viewLevel":2,"viewId":"tools"},"apiDetailInitial":{"viewName":"ApiDetailInitial","viewId":"apiDetailInitial","viewLevel":2},"apiDetail":{"viewName":"ApiDetail","viewId":"apiDetail","viewLevel":2},"apiDetailDeprecated":{"viewName":"ApiDetailDeprecated","viewId":"apiDetailDeprecated","viewLevel":2},"apiDetailExperimental":{"viewName":"ApiDetailExperimental","viewId":"apiDetailExperimental","viewLevel":2},"apiDetailSince":{"viewName":"ApiDetailSince","viewId":"apiDetailSince","viewLevel":2},"topicMaster":{"viewName":"TopicMaster","viewLevel":1,"viewId":"topicMaster","controlAggregation":"masterPages"},"topicDetailInitial":{"viewName":"TopicDetailInitial","viewId":"topicDetailInitial","viewLevel":2},"topicDetail":{"viewName":"TopicDetail","viewId":"topicDetail","viewLevel":2},"searchPage":{"viewName":"SearchPage","viewId":"searchPage","viewLevel":2,"controlAggregation":"detailPages"},"notFound":{"viewName":"NotFound","viewId":"notFound"},"releaseNotes":{"viewName":"ReleaseNotes","viewLevel":2,"viewId":"releaseNotes","controlAggregation":"detailPages"},"license":{"viewName":"License","viewLevel":2,"viewId":"releaseNotes","controlAggregation":"detailPages"},"termsOfUse":{"viewName":"TermsOfUse","viewLevel":2,"viewId":"termsOfUse","controlAggregation":"detailPages"},"versionInfo":{"viewName":"VersionInfo","viewLevel":2,"viewId":"versionInfo","controlAggregation":"detailPages"}}}}}',
	"sap/ui/documentation/sdk/view/AboutDialog.fragment.xml":'<core:FragmentDefinition xmlns="sap.m" xmlns:l="sap.ui.layout" xmlns:f="sap.ui.layout.form" xmlns:core="sap.ui.core" xmlns:custom="sap.ui.documentation"><Dialog id="aboutDialog" resizable="true" draggable="true" title="{i18n&gt;ABOUT_DIALOG_TITLE}" contentWidth="42rem" contentHeight="50rem" showHeader="false" stretch="{appView&gt;/bPhoneSize}" class="aboutDialog"><NavContainer id="aboutNavCon"><Page id="aboutMaster" title="{i18n&gt;ABOUT_DIALOG_TITLE}"><VBox class="sapUiSmallMargin"><Image id="aboutLogoSAP" src="./resources/sap/ui/documentation/sdk/images/Logo_B_SAPUI5_H.png" densityAware="false" width="100%" class="sapUiSmallMarginBottom" visible="{=!${versionData&gt;/isOpenUI5}}"/><Image id="aboutLogoUI5" src="./resources/sap/ui/documentation/sdk/images/Logo_B_OpenUI5_H.png" densityAware="false" width="100%" class="sapUiSmallMarginBottom" visible="{versionData&gt;/isOpenUI5}"/><Text text="{i18n&gt;ABOUT_DIALOG_TEXT_1}" class="sapMTitleStyleH2 sapUiSmallMarginBottom"/><Text text="{i18n&gt;ABOUT_DIALOG_TEXT_2}" class="sapUiMediumMarginBottom" visible="{=!${versionData&gt;/isOpenUI5}}"/><Text text="{i18n&gt;ABOUT_DIALOG_TEXT_3}" visible="{versionData&gt;/isOpenUI5}"/><custom:JSDocText class="sapUiMediumMarginBottom" visible="{versionData&gt;/isOpenUI5}" text="Licensed under the Apache License, Version 2.0 – see &lt;a href=\'LICENSE.txt\' target=\'_blank\' class=\'sapMLnk sapMLnkMaxWidth aboutLink\'&gt;LICENSE.txt&lt;/a&gt;"/><Text text="{parts:[\'i18n&gt;ABOUT_DIALOG_TEXT_4\',\'versionData&gt;/versionName\',\'versionData&gt;/fullVersion\'],formatter:\'.formatMessage\'}" class="sapMTitleStyleH4 sapUiSmallMarginBottom"/><Text text="{parts:[\'i18n&gt;ABOUT_DIALOG_TEXT_5\',\'versionData&gt;/openUi5Version\'],formatter:\'.formatMessage\'}" class="sapMTitleStyleH5 sapUiSmallMarginBottom" visible="{=!${versionData&gt;/isOpenUI5}}"/><Text text="{i18n&gt;ABOUT_DIALOG_TEXT_6}"/><custom:JSDocText class="sapUiTinyMarginBottom" text="(a full change log for all libraries can be found &lt;a href=\'releasenotes.html\' target=\'_blank\' class=\'sapMLnk sapMLnkMaxWidth aboutLink\'&gt;here&lt;/a&gt;)."/><Link text="{i18n&gt;ABOUT_DIALOG_LINK_1}" press="onAboutVersionDetails" class="sapUiSmallMarginBottom"/><Text text="{i18n&gt;ABOUT_DIALOG_TEXT_7}" class="sapUiTinyMarginBottom" visible="{=!${versionData&gt;/isOpenUI5}}"/><Link text="{i18n&gt;ABOUT_DIALOG_TEXT_8}" press="onAboutThirdParty" class="sapUiSmallMarginBottom" visible="{=!${versionData&gt;/isOpenUI5}}"/><MessageStrip showIcon="true" text="{= ${versionData&gt;/isOpenUI5} ? ${appView&gt;/sAboutInfoOpenUI5} : ${appView&gt;/sAboutInfoSAPUI5}}" class="sapUiSmallMarginBottom" enableFormattedText="true"/></VBox></Page><Page id="aboutDetail" showNavButton="true" navButtonPress="onAboutNavBack" title="{i18n&gt;ABOUT_DIALOG_VERSION_TITLE}"><l:VerticalLayout class="sapUiSmallMargin" content="{path:\'appView&gt;/oVersionInfo/libs\'}"><f:Form width="100%" editable="false"><f:title><core:Title text="{appView&gt;library}"/></f:title><f:layout><f:ResponsiveGridLayout/></f:layout><f:formContainers><f:FormContainer><f:formElements><f:FormElement label="{i18n&gt;ABOUT_DIALOG_VERSION}"><f:fields><Text text="{appView&gt;version}" class="sapUiSmallMarginBottom"/></f:fields></f:FormElement><f:FormElement label="{i18n&gt;ABOUT_DIALOG_DESCRIPTION}"><f:fields><Text text="{appView&gt;documentation}" class="sapUiSmallMarginBottom"/></f:fields></f:FormElement><f:FormElement label="{i18n&gt;ABOUT_DIALOG_CHANGE_LOG}" visible="{=!!${appView&gt;releasenotes}}"><f:fields><Link text="{i18n&gt;ABOUT_DIALOG_CHANGE_LOG_LINK}" press="onReleaseDialogOpen" class="sapUiSmallMarginBottom"><customData><core:CustomData key="library" value="{appView&gt;library}"/><core:CustomData key="version" value="{versionData&gt;/version}"/></customData></Link></f:fields></f:FormElement><f:FormElement label="{i18n&gt;ABOUT_DIALOG_COMPONENT}" visible="{=!!${appView&gt;libDefaultComponent}}"><f:fields><Text text="{appView&gt;libDefaultComponent}" class="sapUiSmallMarginBottom"/></f:fields></f:FormElement></f:formElements></f:FormContainer></f:formContainers></f:Form></l:VerticalLayout></Page><Page id="aboutThirdParty" showNavButton="true" navButtonPress="onAboutNavBack" title="{i18n&gt;ABOUT_DIALOG_THIRD_PARTY}"><l:VerticalLayout class="sapUiSmallMargin" content="{path:\'appView&gt;/oThirdPartyInfo/thirdparty\'}"><f:Form width="100%" editable="false"><f:title><core:Title text="{appView&gt;displayName}"/></f:title><f:layout><f:GridLayout/></f:layout><f:formContainers><f:FormContainer><f:formElements><f:FormElement><f:fields><Link text="Web Site" target="_blank" href="{appView&gt;homepage}" class="sapUiSmallMarginBottom"/><Link text="License Conditions" target="_blank" href="{appView&gt;license/url}" class="sapUiSmallMarginBottom"/></f:fields></f:FormElement><f:FormElement><f:fields><Link text="Licensed by SAP under \'{appView&gt;license/type}\'" target="_blank" href="{appView&gt;license/file}" class="sapUiSmallMarginBottom"/></f:fields></f:FormElement></f:formElements></f:FormContainer></f:formContainers></f:Form></l:VerticalLayout></Page></NavContainer><beginButton><Button id="aboutDialogCloseButton" text="{i18n&gt;ABOUT_DIALOG_CLOSE_BTN}" press="aboutDialogClose"/></beginButton></Dialog></core:FragmentDefinition>',
	"sap/ui/documentation/sdk/view/ApiDetail.view.xml":'<mvc:View xmlns="sap.m" xmlns:mvc="sap.ui.core.mvc" controllerName="sap.ui.documentation.sdk.controller.ApiDetail"><Page id="apiDetailPageContainer" showHeader="false" showSubHeader="false" showFooter="false" busyIndicatorDelay="0" busy="true" class="apiDetailPage"/></mvc:View>',
	"sap/ui/documentation/sdk/view/ApiDetailDeprecated.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.ApiDetailIndexDeprecatedExperimental" xmlns="sap.uxap" xmlns:m="sap.m" xmlns:mvc="sap.ui.core.mvc" xmlns:app="http://schemas.sap.com/sapui5/extension/sap.ui.core.CustomData/1"><ObjectPageLayout id="objectPage" upperCaseAnchorBar="false" sections="{/}"><headerTitle><ObjectPageHeader objectTitle="{i18n&gt;API_DETAIL_DEPRECATED_TITLE}"/></headerTitle><headerContent><m:MessageStrip text="{i18n&gt;API_DETAIL_DEPRECATED_WARNING}" type="Error" class="specialListsMessageStrip" showIcon="true"/></headerContent><ObjectPageSection titleUppercase="false" title="{parts:[\'i18n&gt;API_DETAIL_AS_OF_VERSION\',\'name\'],formatter:\'.formatter.formatVersionTitle\'}"><ObjectPageSubSection><m:List items="{path:\'apis\',templateShareable:false}" updateFinished="._modifyLinks" showSeparators="Inner" class="sapUxAPObjectPageSubSectionAlignContent" width="auto"><m:items><m:FeedListItem showIcon="false" sender="{parts:[{path:\'control\'},{path:\'entityName\'},{path:\'type\'}],formatter:\'.formatter.formatSenderLink\'}" text="{path:\'text\',formatter:\'.formatter.formatLinks\'}" class="specialListFeedItem" app:control="{control}" app:entity="{entityName}" app:type="{type}" app:static="{static}"/></m:items></m:List></ObjectPageSubSection></ObjectPageSection></ObjectPageLayout></mvc:View>',
	"sap/ui/documentation/sdk/view/ApiDetailExperimental.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.ApiDetailIndexDeprecatedExperimental" xmlns="sap.uxap" xmlns:m="sap.m" xmlns:mvc="sap.ui.core.mvc" xmlns:app="http://schemas.sap.com/sapui5/extension/sap.ui.core.CustomData/1"><ObjectPageLayout id="objectPage" upperCaseAnchorBar="false" sections="{/}"><headerTitle><ObjectPageHeader objectTitle="{i18n&gt;API_DETAIL_EXPERIMENTAL_TITLE}"/></headerTitle><headerContent><m:MessageStrip enableFormattedText="true" text="Experimental features are not part of the officially delivered scope that SAP is going to guarantee for future releases – means experimental Features may be changed by SAP at any time for any reason without notice. The Experimental features are NOT FOR PRODUCTION USE. You may not demonstrate, test, examine, evaluate or otherwise use the Experimental Features in a live operating environment or with data that has not been sufficiently backed up. The purpose of Experimental features is to get feedback at an early point of time allowing customers/partners to influence the future product accordingly. Please use the SDN Developer Center &lt;a target=\'_blank\' href=\'https://www.sap.com/developer/topics/ui5.html\'&gt;https://www.sap.com/developer/topics/ui5.html&lt;/a&gt; to provide feedback accepting that Intellectual Property rights of the contributions or derivative works shall remain the exclusive property of SAP. For general information about Experimental features, please check the Compatibility Rules" type="Warning" showIcon="true" class="specialListsMessageStrip"/></headerContent><ObjectPageSection titleUppercase="false" title="{parts:[\'i18n&gt;API_DETAIL_AS_OF_VERSION\',\'name\'],formatter:\'.formatter.formatVersionTitle\'}"><ObjectPageSubSection><m:List items="{path:\'apis\',templateShareable:false}" updateFinished="._modifyLinks" showSeparators="Inner" class="sapUxAPObjectPageSubSectionAlignContent" width="auto"><m:items><m:FeedListItem showIcon="false" sender="{parts:[{path:\'control\'},{path:\'entityName\'},{path:\'type\'}],formatter:\'.formatter.formatSenderLink\'}" text="{path:\'text\',formatter:\'.formatter.formatLinks\'}" class="specialListFeedItem" app:control="{control}" app:entity="{entityName}" app:type="{type}" app:static="{static}"/></m:items></m:List></ObjectPageSubSection></ObjectPageSection></ObjectPageLayout></mvc:View>',
	"sap/ui/documentation/sdk/view/ApiDetailInitial.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.ApiDetailInitial" xmlns="sap.m" xmlns:mvc="sap.ui.core.mvc" xmlns:l="sap.ui.layout" xmlns:core="sap.ui.core" xmlns:custom="sap.ui.documentation"><Page showHeader="false" class="sapUiDemoApps"><landmarkInfo><PageAccessibleLandmarkInfo contentRole="Main" contentLabel="API Reference"/></landmarkInfo><Panel accessibleRole="Region" class="sapUiNoContentPadding" backgroundDesign="Transparent"><l:BlockLayout><l:BlockLayoutRow><l:BlockLayoutCell class="sapUiNoContentPadding sapUiDemokitLandingImageCell sapUiNoContentPadding"><Image id="phoneImage" src="./resources/sap/ui/documentation/sdk/images/API_ref_S_cropped_1.jpg" width="100%" densityAware="false" class="landingImage" load="handleLandingImageLoad" visible="{device&gt;/system/phone}"/><Image src="./resources/sap/ui/documentation/sdk/images/API_ref_M_and_L_cropped_1.jpg" width="100%" class="landingImage" densityAware="false" load="handleLandingImageLoad" visible="{=!${device&gt;/system/phone}}"/><Text id="landingImageHeadline" class="sapUiDocumentationApiHeaderText sapUiDocumentationApiHeaderTitleText" text="API Reference" width="100%" textAlign="Left"/></l:BlockLayoutCell></l:BlockLayoutRow></l:BlockLayout></Panel><Panel accessibleRole="Region" backgroundDesign="Transparent" class="sapUiNoContentPadding"><headerToolbar><Toolbar class="headlineCell"><Title width="100%" text="Featured Namespaces" level="H1" titleStyle="H1" class="sapUiMediumMarginTopBottom"/></Toolbar></headerToolbar><l:BlockLayout><l:BlockLayoutRow><l:BlockLayoutCell width="2" class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeA"><l:VerticalLayout width="100%"><custom:TitleLink level="H1" titleStyle="H1" text="Main Controls" href="api/sap.m"/><Text text="Responsive controls for touch-enabled devices and desktop browsers" class="sapUiSmallMarginBottom"/><Label text="Namespace: sap.m"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeB"><l:VerticalLayout width="100%"><custom:TitleLink level="H1" titleStyle="H1" text="Layout" href="api/sap.ui.layout.form.Form"/><Label text="Namespace: sap.ui.layout"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeD"><l:VerticalLayout width="100%"><custom:TitleLink level="H1" titleStyle="H1" text="Tables" href="api/sap.ui.table"/><Text text="Tables for desktop-type scenarios" class="sapUiSmallMarginBottom"/><Label text="Namespace: sap.ui.table"/></l:VerticalLayout></l:BlockLayoutCell></l:BlockLayoutRow><l:BlockLayoutRow><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeC"><l:VerticalLayout width="100%"><custom:TitleLink level="H1" titleStyle="H1" text="SAP Fiori" href="api/sap.f"/><Text text="Controls specialized for SAP Fiori applications" class="sapUiSmallMarginBottom"/><Label text="Namespace: sap.f"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeB"><l:VerticalLayout width="100%"><custom:TitleLink level="H1" titleStyle="H1" text="SAP Fiori for Tools" href="api/sap.tnt"/><Text text="Controls specialized for administrative applications" class="sapUiSmallMarginBottom"/><Label text="Namespace: sap.tnt"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeA" width="2"><l:VerticalLayout width="100%"><custom:TitleLink level="H1" titleStyle="H1" text="UI5 Core Runtime" href="api/sap.ui.core"/><Text text="Boots the core framework and makes it available for the application via method sap.ui.getCore()" class="sapUiSmallMarginBottom"/><Label text="Namespace: sap.ui.core"/></l:VerticalLayout></l:BlockLayoutCell></l:BlockLayoutRow><l:BlockLayoutRow><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeD" width="2"><l:VerticalLayout width="100%"><custom:TitleLink level="H1" titleStyle="H1" text="Object Page" href="api/sap.uxap"/><Text text="Controls for displaying, creating and editing objects" class="sapUiSmallMarginBottom"/><Label text="Namespace: sap.uxap"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeB" width="2"><l:VerticalLayout width="100%"><custom:TitleLink level="H1" titleStyle="H1" text="Models" href="api/sap.ui.model"/><Text text="Data binding utilities" class="sapUiSmallMarginBottom"/><Label text="Namespace: sap.ui.model"/></l:VerticalLayout></l:BlockLayoutCell></l:BlockLayoutRow><l:BlockLayoutRow visible="{= !${versionData&gt;/isOpenUI5}}"><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeA" width="2"><l:VerticalLayout width="100%"><custom:TitleLink level="H1" titleStyle="H1" text="Smart Controls" href="api/sap.ui.comp"/><Text text="Metadata-driven controls" class="sapUiSmallMarginBottom"/><Label text="Namespace: sap.ui.comp"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeC"><l:VerticalLayout width="100%"><custom:TitleLink level="H1" titleStyle="H1" text="Micro Charts" href="api/sap.suite.ui.microchart"/><Text text="Lightweight diagrams" class="sapUiSmallMarginBottom"/><Label text="Namespace: sap.suite.ui.microchart"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeD"><l:VerticalLayout width="100%"><custom:TitleLink level="H1" titleStyle="H1" text="Charts" href="api/sap.viz"/><Text text="Data visualization" class="sapUiSmallMarginBottom"/><Label text="Namespace: sap.viz"/></l:VerticalLayout></l:BlockLayoutCell></l:BlockLayoutRow></l:BlockLayout></Panel><l:BlockLayout><l:BlockLayoutRow><core:Fragment id="footerFragment" fragmentName="sap.ui.documentation.sdk.view.Footer" type="XML"/></l:BlockLayoutRow></l:BlockLayout></Page></mvc:View>',
	"sap/ui/documentation/sdk/view/ApiDetailSince.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.ApiDetailIndexDeprecatedExperimental" xmlns="sap.uxap" xmlns:m="sap.m" xmlns:mvc="sap.ui.core.mvc" xmlns:custom="sap.ui.documentation" xmlns:blocks="sap.ui.documentation.sdk.blocks" xmlns:app="http://schemas.sap.com/sapui5/extension/sap.ui.core.CustomData/1"><ObjectPageLayout id="objectPage" enableLazyLoading="true" showAnchorBarPopover="true" upperCaseAnchorBar="false" useIconTabBar="true" sections="{/}"><headerTitle><ObjectPageHeader objectTitle="{i18n&gt;API_DETAIL_SINCE_TITLE}"/></headerTitle><ObjectPageSection titleUppercase="false" title="{parts:[\'i18n&gt;API_DETAIL_AS_OF_VERSION\',\'name\'],formatter:\'.formatMessage\'}"><ObjectPageSubSection><blocks:IndexEntry/></ObjectPageSubSection></ObjectPageSection></ObjectPageLayout></mvc:View>',
	"sap/ui/documentation/sdk/view/ApiMaster.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.ApiMaster" xmlns:mvc="sap.ui.core.mvc" xmlns="sap.m" xmlns:custom="sap.ui.documentation" class="sapContrast sapContrastPlus"><Page id="page" enableScrolling="true" showFooter="false" navButtonPress="onNavBack" showNavButton="false" class="sapUiDocumentationMasterPage"><customHeader><Toolbar width="100%"><SearchField id="searchField" placeholder="{i18n&gt;API_MASTER_PLACEHOLDER}" liveChange="onTreeFilter" class="sapUiDocumentationFilterField"/><Button id="expandAllButton" icon="sap-icon://expand-all" press="onTreeExpandAll" tooltip="{i18n&gt;API_MASTER_EXPAND_BTN_TOOLTIP}"/><Button id="collapseAllButton" icon="sap-icon://collapse-all" press="onTreeCollapseAll" tooltip="{i18n&gt;API_MASTER_COLLAPSE_BTN_TOOLTIP}"/></Toolbar></customHeader><subHeader><Toolbar><CheckBox id="includeDeprecated" text="{i18n&gt;API_MASTER_DEPRECATED_CB}" class="sapUiNoMarginBegin" select="onIncludeDeprecatedItemsChange"/></Toolbar></subHeader><content><Tree id="tree" mode="SingleSelectMaster" noDataText="{i18n&gt;API_MASTER_NO_DATA_TEXT}" selectionChange="onNodeSelect" items="{treeData&gt;/}"><custom:DemokitTreeItem title="{treeData&gt;displayName}" target="{treeData&gt;name}" entityType="{treeData&gt;kind}" section="api" class="sapDemokitTreeItem" deprecated="{treeData&gt;deprecated}"/></Tree></content></Page></mvc:View>',
	"sap/ui/documentation/sdk/view/App.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.App" xmlns="sap.m" xmlns:tnt="sap.tnt" xmlns:core="sap.ui.core" xmlns:mvc="sap.ui.core.mvc" xmlns:custom="sap.ui.documentation" displayBlock="true" busy="{appView&gt;/busy}" busyIndicatorDelay="{appView&gt;/delay}"><Page showHeader="false" enableScrolling="false" showNavButton="false" class="sapUiDemokit"><content><tnt:ToolHeader id="headerToolbar"><ToggleButton icon="sap-icon://menu2" type="Transparent" visible="{= ${appView&gt;/bHasMaster} &amp;&amp; !${appView&gt;/bPhoneSize} &amp;&amp; !${appView&gt;/bLandscape} &amp;&amp; !${appView&gt;/bSearchMode} }" press="toggleMaster" pressed="{appView&gt;/bIsShownMaster}"><layoutData><OverflowToolbarLayoutData priority="NeverOverflow"/></layoutData></ToggleButton><Image id="sap_logo" src="./resources/sap/ui/documentation/sdk/images/logo_ui5.png" densityAware="false" height="2rem" alt="UI5 logo" decorative="false" class="sapLogo" press="onLogoIconPress"/><core:ExtensionPoint name="customStartLinks"/><Select id="selectHeader" class="sapUiDocumentationSelect menuSelect" visible="{=${appView&gt;/bPhoneSize}}" change="navigateToSection" autoAdjustWidth="true"><items><core:Item text="{i18n&gt;APP_TABHEADER_ITEM_HOME}" key="home"/><core:Item text="{i18n&gt;APP_TABHEADER_ITEM_DOCUMENTATION}" key="topic"/><core:Item text="{i18n&gt;APP_TABHEADER_ITEM_API_REFERENCE}" key="api"/><core:Item text="{i18n&gt;APP_TABHEADER_ITEM_SAMPLES}" key="controls"/><core:Item text="{i18n&gt;APP_TABHEADER_ITEM_DEMO_APPS}" key="demoapps"/><core:Item text="{i18n&gt;APP_TABHEADER_ITEM_TOOLS}" key="tools"/></items><layoutData><OverflowToolbarLayoutData priority="NeverOverflow" shrinkable="true"/></layoutData></Select><IconTabHeader id="tabHeader" selectedKey="home" backgroundDesign="Transparent" mode="Inline" select="navigateToSection" visible="{=!${appView&gt;/bPhoneSize}}"><layoutData><OverflowToolbarLayoutData priority="NeverOverflow" shrinkable="true"/></layoutData><items><IconTabFilter id="welcomeTab" text="{i18n&gt;APP_TABHEADER_ITEM_HOME}" key="home" visible="{=${appView&gt;/bPhoneSize}}"/><IconTabFilter id="topicMasterTab" text="{i18n&gt;APP_TABHEADER_ITEM_DOCUMENTATION}" key="topic" visible="{= !${appView&gt;/bHideTopicSection}}"/><IconTabFilter id="apiMasterTab" text="{i18n&gt;APP_TABHEADER_ITEM_API_REFERENCE}" key="api" visible="{= !${appView&gt;/bHideApiSection}}"/><IconTabFilter id="controlsMasterTab" text="{i18n&gt;APP_TABHEADER_ITEM_SAMPLES}" key="controls"/><IconTabFilter id="demoAppsTab" text="{i18n&gt;APP_TABHEADER_ITEM_DEMO_APPS}" key="demoapps"/><IconTabFilter id="toolsTab" text="{i18n&gt;APP_TABHEADER_ITEM_TOOLS}" key="tools"/></items></IconTabHeader><ObjectStatus text="{= ${versionData&gt;/isBetaVersion} ? ${i18n&gt;APP_VERSION_BETA_VERSION} : ${i18n&gt;APP_VERSION_VERSION}} {versionData&gt;/version} {= ${versionData&gt;/isBetaVersion} ? ${i18n&gt;APP_VERSION_NOT_PRODUCTIVE} : ${versionData&gt;/isDevVersion} ? ${i18n&gt;APP_VERSION_IN_PROGRESS} : \'\'}" state="{= ${versionData&gt;/isBetaVersion} ? \'Error\' : ${versionData&gt;/isDevVersion} ? \'Warning\' : \'None\'}" visible="{=!${appView&gt;/bPhoneSize}}"/><Button id="changeVersionButton" press="onChangeVersionButtonPress" type="Transparent" text="{i18n&gt;APP_CHANGE_VERSION_BTN}" visible="{appView&gt;/bShowVersionSwitchInHeader}"><layoutData><OverflowToolbarLayoutData priority="NeverOverflow"/></layoutData></Button><custom:Search id="searchControl" toggle="onToggleSearchMode" search="onSearch" width="{= (${appView&gt;/bPhoneSize} &amp;&amp; ${appView&gt;/bSearchMode}) ? \'100%\' : \'\'}"/><Button id="feedBackDialogButton" tooltip="{i18n&gt;APP_FEEDBACK_BTN_TOOLTIP}" press="feedbackDialogOpen" icon="sap-icon://comment" type="Transparent" visible="{=!${appView&gt;/bPhoneSize} &amp;&amp; !${appView&gt;/bSearchMode}}"><layoutData><OverflowToolbarLayoutData priority="NeverOverflow"/></layoutData></Button><MenuButton tooltip="{i18n&gt;APP_INFORMATION_BTN_TOOLTIP}" id="aboutMenuButton" icon="sap-icon://hint" type="Transparent" visible="{=!${appView&gt;/bSearchMode}}"><layoutData><OverflowToolbarLayoutData priority="NeverOverflow"/></layoutData><menu><Menu id="aboutMenu" class="sapContrast sapContrastPlus" itemSelected="handleMenuItemClick"><items><MenuItem text="{= ${versionData&gt;/isBetaVersion} ? ${i18n&gt;APP_VERSION_BETA_VERSION} : ${i18n&gt;APP_VERSION_VERSION}} {versionData&gt;/version} {=${versionData&gt;/isDevVersion} ? ${i18n&gt;APP_VERSION_IN_PROGRESS} : \'\'}" visible="{appView&gt;/bPhoneSize}"/><MenuItem key="change_version" text="{i18n&gt;APP_CHANGE_VERSION_BTN}" visible="{appView&gt;/bShowVersionSwitchInMenu}"/><MenuItem key="feedback" text="{i18n&gt;APP_INFORMATION_BTN_FEEDBACK}" visible="{appView&gt;/bPhoneSize}"/><MenuItem key="about" id="aboutMenuItem" text="{i18n&gt;APP_INFORMATION_BTN_ABOUT}"/><MenuItem key="legal" text="{i18n&gt;APP_INFORMATION_BTN_LEGAL}"/><MenuItem key="privacy" text="{i18n&gt;APP_INFORMATION_BTN_PRIVACY}"/><MenuItem key="terms_of_use" text="{i18n&gt;APP_INFORMATION_BTN_TERMS_OF_USE}" visible="{=!${versionData&gt;/isOpenUI5}}"><items><MenuItem key="terms_of_use" text="{i18n&gt;APP_INFORMATION_BTN_TERMS_OF_USE}"/><MenuItem key="copyright" text="{i18n&gt;APP_INFORMATION_BTN_COPYRIGHT}"/><MenuItem key="trademark" text="{i18n&gt;APP_INFORMATION_BTN_TRADEMARK}"/><MenuItem key="disclaimer" text="{i18n&gt;APP_INFORMATION_BTN_DISCLAIMER}"/></items></MenuItem><MenuItem text="{i18n&gt;APP_INFORMATION_BTN_LICENSE}" key="license" visible="{versionData&gt;/isOpenUI5}"/><MenuItem text="{i18n&gt;APP_INFORMATION_BTN_TERMS_OF_USE}" key="terms_of_use" visible="{versionData&gt;/isOpenUI5}"/><MenuItem text="{i18n&gt;APP_SETTINGS_DIALOG_LANGUAGE}" key="settings"/><MenuItem text="{i18n&gt;APP_SETTINGS_DIALOG_COOKIE_PREFERENCES}" key="cookie_preferences"/></items></Menu></menu></MenuButton><core:ExtensionPoint name="customLinks"/></tnt:ToolHeader><Bar visible="{= ${appView&gt;/bPhoneSize} &amp;&amp; ${appView&gt;/bHasMaster}}" class="sapContrast sapContrastPlus"><contentLeft><ToggleButton icon="sap-icon://menu2" type="Transparent" press="toggleMaster" pressed="{appView&gt;/bIsShownMaster}"><layoutData><OverflowToolbarLayoutData priority="NeverOverflow"/></layoutData></ToggleButton></contentLeft></Bar><core:ExtensionPoint name="customControls"/><ScrollContainer id="contentId" width="100%" height="{= ${appView&gt;/bPhoneSize} &amp;&amp; ${appView&gt;/bHasMaster} ?      \'calc(100% - \' + ${appView&gt;/oThemeScrollContainerHeight/iMobileHeight} + \')\' :       \'calc(100% - \' + ${appView&gt;/oThemeScrollContainerHeight/iDesktopHeight} + \')\'}" horizontal="false" vertical="false"><SplitApp id="splitApp" mode="HideMode" class="sapUiDocumentationSplitApp" defaultTransitionNameDetail="show" defaultTransitionNameMaster="fade"/></ScrollContainer></content><footer><core:ExtensionPoint name="footer"/></footer></Page></mvc:View>',
	"sap/ui/documentation/sdk/view/BlockLayoutCell.fragment.xml":'<core:FragmentDefinition xmlns="sap.m" xmlns:core="sap.ui.core" xmlns:l="sap.ui.layout" xmlns:custom="sap.ui.documentation"><l:BlockLayoutCell width="2"><l:VerticalLayout width="100%"><core:Icon src="sap-icon://{icon}" size="2rem" color="Default"/><custom:TitleLink level="H1" titleStyle="H1" text="{name}" href="{ref}" target="_blank" class="sapUiTinyMarginTop"/><Text text="{desc}" class="sapUiTinyMarginBottom"/><l:VerticalLayout content="{links}" class="sapUiTinyMarginBottom" visible="{= ${links}.length === 0 ? false : true }"><Link href="{path:\'ref\',formatter:\'.formatter.crossLink\'}" target="_blank" text="{name}"/></l:VerticalLayout><l:HorizontalLayout><Label design="Bold" text="{i18n&gt;DEMO_APPS_LIBRARY}" class="sapUiTinyMarginEnd"/><Link text="{lib}" href="{path:\'lib\',formatter:\'.formatter.libraryLink\'}" target="_blank" enabled="{path:\'lib\',formatter:\'.formatter.libraryLinkEnabled\'}" emphasized="true"/></l:HorizontalLayout></l:VerticalLayout></l:BlockLayoutCell></core:FragmentDefinition>',
	"sap/ui/documentation/sdk/view/BlockLayoutTeaserCell.fragment.xml":'<core:FragmentDefinition xmlns="sap.m" xmlns:core="sap.ui.core" xmlns:l="sap.ui.layout" xmlns:custom="sap.ui.documentation"><l:BlockLayoutCell width="4"><l:Grid hSpacing="0" defaultSpan="L6 M12 S12"><l:VerticalLayout class="sapUiTinyMarginEnd" width="100%"><core:Icon src="sap-icon://{icon}" size="2rem" color="Default"/><custom:TitleLink level="H1" titleStyle="H1" text="{name}" href="{ref}" target="_blank" class="sapUiTinyMarginTop"/><Text text="{desc}" class="sapUiTinyMarginBottom"/><l:VerticalLayout content="{links}" class="sapUiTinyMarginBottom" visible="{= ${links}.length === 0 ? false : true }"><Link href="{path:\'ref\',formatter:\'.formatter.crossLink\'}" target="_blank" text="{name}"/></l:VerticalLayout><l:HorizontalLayout><Label design="Bold" text="{i18n&gt;DEMO_APPS_LIBRARY}" class="sapUiTinyMarginEnd"/><Link text="sap.m" href="{path:\'lib\',formatter:\'.formatter.libraryLink\'}" target="_blank" enabled="{path:\'lib\',formatter:\'.formatter.libraryLinkEnabled\'}" emphasized="true"/></l:HorizontalLayout></l:VerticalLayout></l:Grid></l:BlockLayoutCell></core:FragmentDefinition>',
	"sap/ui/documentation/sdk/view/ChangeVersionDialog.fragment.xml":'<core:FragmentDefinition xmlns="sap.m" xmlns:core="sap.ui.core"><Dialog title="{i18n&gt;CHANGE_VERSION_DIALOG_TITLE}" contentHeight="400px" stretch="{appView&gt;/bPhoneSize}"><endButton><Button text="{i18n&gt;CHANGE_VERSION_DIALOG_CLOSE_BTN}" press="onCloseVersionDialog"/></endButton><subHeader><Bar><contentMiddle><SearchField liveChange="onChangeVersionDialogSearch" showSearchButton="false"/></contentMiddle></Bar></subHeader><List id="versionList" itemPress="onVersionItemPress" items="{path:\'/\',sorter:[{path:\'groupTitle\',descending:true,group:true,comparator:\'.versionSwitchCustomComparator\'},{path:\'patchVersion\',descending:true}]}"><StandardListItem title="{path:\'version\'}" type="Active"><customData><core:CustomData key="path" value="{path:\'path\'}"/></customData></StandardListItem></List></Dialog></core:FragmentDefinition>',
	"sap/ui/documentation/sdk/view/Code.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.Code" xmlns:mvc="sap.ui.core.mvc" xmlns:core="sap.ui.core" xmlns:l="sap.ui.layout" xmlns="sap.m" xmlns:ce="sap.ui.codeeditor" height="100%"><Page id="page" showHeader="false" showNavButton="true" navButtonPress="onNavBack" title="{/title}" icon="img/144_iPad_Retina_Web_Clip.png" enableScrolling="false"><landmarkInfo><PageAccessibleLandmarkInfo rootRole="Region" rootLabel="Details" headerRole="Region" headerLabel="Header" contentRole="Main" contentLabel="Content"/></landmarkInfo><subHeader><Bar id="header" class="sapContrast sapContrastPlus"><contentLeft><Button type="Back" press="onNavBack" tooltip="{i18n&gt;CODE_BACK_BTN_TOOLTIP}"/></contentLeft><contentMiddle><Title text="{/title}"/></contentMiddle><contentRight><Button id="apiRefButton" text="{i18n&gt;CODE_API_REFERENCE}" type="Emphasized" press="onAPIRefPress" visible="false"/><Button class="sapUiHideOnPhone" text="{i18n&gt;CODE_DOWNLOAD_BTN}" icon="sap-icon://download" press="onDownload"/><Button class="sapUiVisibleOnlyOnPhone" icon="sap-icon://download" press="onDownload"/></contentRight></Bar></subHeader><content><l:FixFlex><l:fixContent><IconTabHeader id="tabHeader" mode="Inline" items="{/files}" select="handleTabSelectEvent" selectedKey="{/fileName}"><items><IconTabFilter key="{name}" text="{name}"/></items></IconTabHeader></l:fixContent><l:flexContent><ce:CodeEditor id="codeEditor" editable="false"/></l:flexContent></l:FixFlex></content></Page></mvc:View>',
	"sap/ui/documentation/sdk/view/Controls.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.Controls" xmlns:mvc="sap.ui.core.mvc" xmlns="sap.m" xmlns:l="sap.ui.layout" xmlns:core="sap.ui.core" xmlns:custom="sap.ui.documentation"><Page showHeader="false" class="sapUiDemoApps"><landmarkInfo><PageAccessibleLandmarkInfo contentRole="Main" contentLabel="Samples"/></landmarkInfo><Panel accessibleRole="Region" class="sapUiNoContentPadding" backgroundDesign="Transparent"><l:BlockLayout><l:BlockLayoutRow><l:BlockLayoutCell class="sapUiNoContentPadding sapUiDemokitLandingImageCell sapUiNoContentPadding"><Image id="phoneImage" src="./resources/sap/ui/documentation/sdk/images/Explored_S_cropped_1.jpg" width="100%" densityAware="false" class="welcomeImage" load="handleLandingImageLoad" visible="{device&gt;/system/phone}"/><Image src="./resources/sap/ui/documentation/sdk/images/Explored_M_and_L_cropped_1.jpg" width="100%" densityAware="false" class="welcomeImage" load="handleLandingImageLoad" visible="{=!${device&gt;/system/phone}}"/><l:VerticalLayout id="landingImageHeadline" visible="false" width="100%"><Text class="sapUiDocumentationExploredHeaderText sapUiDocumentationExploredHeaderTitleText" text="{i18n&gt;CONTROLS_PAGE_TITLE}" width="100%" textAlign="Left"/><Text class="sapUiDocumentationExploredHeaderText sapUiDocumentationExploredSubText" text="{i18n&gt;CONTROLS_PAGE_DESC}" width="100%" textAlign="Left"/></l:VerticalLayout></l:BlockLayoutCell></l:BlockLayoutRow></l:BlockLayout></Panel><Panel accessibleRole="Region" backgroundDesign="Transparent" class="sapUiNoContentPadding"><headerToolbar><Toolbar class="headlineCell"><Title width="100%" text="{i18n&gt;CONTROLS_FEATURED_CONTROLS}" level="H1" titleStyle="H1" class="sapUiMediumMarginTopBottom"/></Toolbar></headerToolbar><l:BlockLayout><l:BlockLayoutRow><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeA"><l:VerticalLayout><core:Icon src="sap-icon://edit" color="Default" size="2rem" class="sapUiTinyMarginBottom"/><custom:TitleLink press="onPress" href="controls/filter/Input" filter="Input" text="Input" titleStyle="H2"/><Text text="{i18n&gt;CONTROLS_TEXT_1}"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeB"><l:VerticalLayout><core:Icon src="sap-icon://list" color="Default" size="2rem" class="sapUiTinyMarginBottom"/><custom:TitleLink press="onPress" href="controls/filter/List" filter="List" text="Lists" titleStyle="H2"/><Text text="{i18n&gt;CONTROLS_TEXT_2}"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeC"><l:VerticalLayout><core:Icon src="sap-icon://table-view" color="Default" size="2rem" class="sapUiTinyMarginBottom"/><custom:TitleLink press="onPress" href="controls/filter/Table" filter="Table" text="Tables" titleStyle="H2"/><Text text="{i18n&gt;CONTROLS_TEXT_3}"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeA"><l:VerticalLayout><core:Icon src="sap-icon://popup-window" color="Default" size="2rem" class="sapUiTinyMarginBottom"/><custom:TitleLink press="onPress" href="controls/filter/Popup" filter="Popup" text="Pop-Ups" titleStyle="H2"/><Text text="{i18n&gt;CONTROLS_TEXT_4}"/></l:VerticalLayout></l:BlockLayoutCell></l:BlockLayoutRow><l:BlockLayoutRow><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeB"><l:VerticalLayout><core:Icon src="sap-icon://grid" color="Default" size="2rem" class="sapUiTinyMarginBottom"/><custom:TitleLink press="onPress" href="controls/filter/Tile" filter="Tile" text="Tiles" titleStyle="H2"/><Text text="{i18n&gt;CONTROLS_TEXT_5}"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeD"><l:VerticalLayout><core:Icon src="sap-icon://message-popup" color="Default" size="2rem" class="sapUiTinyMarginBottom"/><custom:TitleLink press="onPress" href="controls/filter/Message" filter="Message" text="Messages" titleStyle="H2"/><Text text="{i18n&gt;CONTROLS_TEXT_6}"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeA"><l:VerticalLayout><core:Icon src="sap-icon://header" color="Default" size="2rem" class="sapUiTinyMarginBottom"/><custom:TitleLink press="onPress" href="controls/filter/Bar" filter="Bar" text="Bars" titleStyle="H2"/><Text text="{i18n&gt;CONTROLS_TEXT_7}"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeC"><l:VerticalLayout><core:Icon src="sap-icon://tree" color="Default" size="2rem" class="sapUiTinyMarginBottom"/><custom:TitleLink press="onPress" href="controls/filter/Tree" filter="Tree" text="Trees" titleStyle="H2"/><Text text="{i18n&gt;CONTROLS_TEXT_8}"/></l:VerticalLayout></l:BlockLayoutCell></l:BlockLayoutRow><l:BlockLayoutRow visible="{= !${versionData&gt;/isOpenUI5}}"><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeD"><l:VerticalLayout><core:Icon src="sap-icon://lightbulb" color="Default" size="2rem" class="sapUiTinyMarginBottom"/><custom:TitleLink press="onPress" href="controls/filter/Smart" filter="Smart" text="Smart Controls" titleStyle="H2"/><Text text="{i18n&gt;CONTROLS_TEXT_9}"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeA"><l:VerticalLayout><core:Icon src="sap-icon://map-2" color="Default" size="2rem" class="sapUiTinyMarginBottom"/><custom:TitleLink press="onPress" href="controls/filter/Map" filter="Map" text="Maps" titleStyle="H2"/><Text text="{i18n&gt;CONTROLS_TEXT_10}"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeC"><l:VerticalLayout><core:Icon src="sap-icon://filter-analytics" color="Default" size="2rem" class="sapUiTinyMarginBottom"/><custom:TitleLink press="onPress" href="controls/filter/Chart" filter="Chart" text="Charts" titleStyle="H2"/><Text text="{i18n&gt;CONTROLS_TEXT_11}"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeD"><l:VerticalLayout><core:Icon src="sap-icon://process" color="Default" size="2rem" class="sapUiTinyMarginBottom"/><custom:TitleLink press="onPress" href="controls/filter/Process" filter="Process" text="Processes" titleStyle="H2"/><Text text="{i18n&gt;CONTROLS_TEXT_12}"/></l:VerticalLayout></l:BlockLayoutCell></l:BlockLayoutRow></l:BlockLayout></Panel><Panel accessibleRole="Region" backgroundDesign="Transparent" class="sapUiNoContentPadding"><headerToolbar><Toolbar class="headlineCell"><Title width="100%" text="{i18n&gt;CONTROLS_LAYOUT_PAGES}" level="H1" titleStyle="H1" class="sapUiMediumMarginTopBottom"/></Toolbar></headerToolbar><l:BlockLayout><l:BlockLayoutRow><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeA"><l:VerticalLayout><core:Icon src="sap-icon://write-new" color="Default" size="2rem" class="sapUiTinyMarginBottom"/><custom:TitleLink press="onPress" href="controls/filter/Object Page" filter="Object Page" text="Object Page" titleStyle="H2"/><Text text="{i18n&gt;CONTROLS_TEXT_13}"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeB"><l:VerticalLayout><core:Icon src="sap-icon://chart-table-view" color="Default" size="2rem" class="sapUiTinyMarginBottom"/><custom:TitleLink press="onPress" href="controls/filter/Dynamic Page" filter="Dynamic Page" text="Dynamic Page" titleStyle="H2"/><Text text="{i18n&gt;CONTROLS_TEXT_14}" class="sapUiTinyMarginBottom"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeC"><l:VerticalLayout><core:Icon src="sap-icon://screen-split-three" color="Default" size="2rem" class="sapUiTinyMarginBottom"/><custom:TitleLink press="onPress" href="controls/filter/Flexible Column Layout" filter="Flexible Column Layout" text="Flexible Column Layout" titleStyle="H2"/><Text text="{i18n&gt;CONTROLS_TEXT_15}"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeD"><l:VerticalLayout><core:Icon src="sap-icon://screen-split-one" color="Default" size="2rem" class="sapUiTinyMarginBottom"/><custom:TitleLink press="onPress" href="controls/filter/Split App" filter="Split App" text="Split App" titleStyle="H2"/><Text text="{i18n&gt;CONTROLS_TEXT_16}" class="sapUiTinyMarginBottom"/></l:VerticalLayout></l:BlockLayoutCell></l:BlockLayoutRow></l:BlockLayout></Panel><l:BlockLayout><l:BlockLayoutRow><core:Fragment id="footerFragment" fragmentName="sap.ui.documentation.sdk.view.Footer" type="XML"/></l:BlockLayoutRow></l:BlockLayout></Page></mvc:View>',
	"sap/ui/documentation/sdk/view/ControlsMaster.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.ControlsMaster" xmlns:mvc="sap.ui.core.mvc" xmlns="sap.m" class="sapContrast sapContrastPlus"><Page id="exploredMasterPage" showFooter="false" navButtonPress="onNavBack" showNavButton="false" class="sapUiDocumentationMasterPage"><customHeader><Toolbar width="100%"><SearchField id="searchField" placeholder="{i18n&gt;CONTROLS_MASTER_FILTER_PLACERHOLDER}" liveChange="handleListFilter" class="sapUiDocumentationFilterField"/><Button id="listFilterSettings" icon="sap-icon://drop-down-list" press="handleListSettings" tooltip="{i18n&gt;CONTROLS_MASTER_FILTER_BTN_TOOLTIP}"/><Button id="sampleSettings" icon="sap-icon://action-settings" press="handleSettings"/></Toolbar></customHeader><content><List id="exploredMasterList" mode="{viewModel&gt;/listMode}" selectionChange="onNavToEntity" noDataText="{i18n&gt;CONTROLS_MASTER_NO_DATA_TEXT}" items="{path:\'/entities\',groupHeaderFactory:\'.getGroupHeader\',sorter:[{path:\'category\',descending:false,group:true},{path:\'name\',descending:false}]}"><infoToolbar><Toolbar id="vsFilterBar" active="true" visible="false" press="handleListSettings"><Label id="vsFilterLabel"/></Toolbar></infoToolbar><items><StandardListItem title="{name}" counter="{sampleCount}" type="{viewModel&gt;/listItemType}" press="onNavToEntity"/></items></List></content></Page></mvc:View>',
	"sap/ui/documentation/sdk/view/CookieSettingsDialog.fragment.xml":'<core:FragmentDefinition xmlns="sap.m" xmlns:core="sap.ui.core" xmlns:html="http://www.w3.org/1999/xhtml"><Dialog title="{i18n&gt;COOKIE_SETTINGS_DIALOG_TITLE}"><content><html:div class="cookieSettingsContainer sapUiSmallMargin">\n\t\t\t\t<Text text="{i18n&gt;COOKIE_SETTINGS_DIALOG_SUMMARY}" visible="{=! ${cookieData&gt;/showCookieDetails} }"/>\n\n\t\t\t\t<List visible="{cookieData&gt;/showCookieDetails}"><CustomListItem class="cookieSetting"><Title text="{i18n&gt;COOKIE_SETTINGS_DIALOG_REQUIRED_COOKIES_TITLE}"/><Text class="cookieSummaryText" text="{i18n&gt;COOKIE_SETTINGS_DIALOG_REQUIRED_COOKIES_SUMMARY}"/><Panel headerText="{i18n&gt;COOKIE_SETTINGS_DIALOG_FUNCTIONAL_COOKIES_MORE_INFO}" expandable="true" class="sapUiTinyMarginTop"><Text text="{i18n&gt;COOKIE_SETTINGS_DIALOG_REQUIRED_COOKIES_TEXT}"/></Panel><Switch id="requiredCookiesSwitch" class="cookieStateSwitch" state="{path:\'cookieData&gt;/dk_allow_required_cookies\',type:\'sap.ui.model.type.Boolean\',formatter:\'.formatter.formatCookieValue\'}"/></CustomListItem><CustomListItem class="cookieSetting sapUiSmallMarginTop"><Title text="{i18n&gt;COOKIE_SETTINGS_DIALOG_FUNCTIONAL_COOKIES_TITLE}"/><Text class="cookieSummaryText" text="{i18n&gt;COOKIE_SETTINGS_DIALOG_FUNCTIONAL_COOKIES_SUMMARY}"/><Panel headerText="{i18n&gt;COOKIE_SETTINGS_DIALOG_FUNCTIONAL_COOKIES_MORE_INFO}" expandable="true" class="sapUiTinyMarginTop"><Text text="{i18n&gt;COOKIE_SETTINGS_DIALOG_FUNCTIONAL_COOKIES_TEXT}"/></Panel><Switch id="functionalCookiesSwitch" class="cookieStateSwitch" state="{path:\'cookieData&gt;/dk_allow_usage_tracking\',type:\'sap.ui.model.type.Boolean\',formatter:\'.formatter.formatCookieValue\'}"/></CustomListItem></List>\n\t\t\t</html:div></content><buttons><Button text="{i18n&gt;COOKIE_SETTINGS_DIALOG_FUNCTIONAL_COOKIES_ACCEPT_ALL}" type="Emphasized" press="onAcceptAllCookies" visible="{=! ${cookieData&gt;/showCookieDetails} }"><layoutData><OverflowToolbarLayoutData priority="NeverOverflow"/></layoutData></Button><Button text="{i18n&gt;COOKIE_SETTINGS_DIALOG_FUNCTIONAL_COOKIES_SET_PREFERENCES}" id="btnSetPreferences" type="Ghost" press="showCookieDetails" visible="{=! ${cookieData&gt;/showCookieDetails} }"/><Button text="{i18n&gt;COOKIE_SETTINGS_DIALOG_FUNCTIONAL_COOKIES_REJECT_ALL}" press="onRejectAllCookies" visible="{=! ${cookieData&gt;/showCookieDetails} }"><layoutData><OverflowToolbarLayoutData priority="NeverOverflow"/></layoutData></Button><Button text="{i18n&gt;COOKIE_SETTINGS_DIALOG_FUNCTIONAL_COOKIES_SAVE_PREFERENCES}" id="btnSavePreferences" type="Emphasized" press="onSaveCookies" visible="{cookieData&gt;/showCookieDetails}"/><Button text="{i18n&gt;COOKIE_SETTINGS_DIALOG_CANCEL_BTN}" press="onCancelEditCookies" visible="{= ${cookieData&gt;/showCookieDetails} &amp;&amp; !${cookieData&gt;/allowShowHideCookieDetails}}"/><Button text="{i18n&gt;COOKIE_SETTINGS_DIALOG_CANCEL_BTN}" press="hideCookieDetails" visible="{= ${cookieData&gt;/showCookieDetails} &amp;&amp; ${cookieData&gt;/allowShowHideCookieDetails}}"/></buttons></Dialog></core:FragmentDefinition>',
	"sap/ui/documentation/sdk/view/DemoApps.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.DemoApps" xmlns="sap.m" xmlns:core="sap.ui.core" xmlns:mvc="sap.ui.core.mvc" xmlns:l="sap.ui.layout"><Page id="demoAppsPage" showSubHeader="false" showFooter="false" showHeader="false" class="sapUiDemoApps"><landmarkInfo><PageAccessibleLandmarkInfo headerRole="Region" headerLabel="Demo Apps" contentRole="Main" contentLabel="Demo Apps by Category"/></landmarkInfo><content><ScrollContainer vertical="true" width="100%" height="100%"><Panel id="rootPage" accessibleRole="Region" class="sapUiNoContentPadding"><l:BlockLayout id="headerLayout" background="Light"><l:BlockLayoutRow><l:BlockLayoutCell class="sapUiDemokitLandingImageCell sapUiNoContentPadding"><Image id="phoneImage" src="./resources/sap/ui/documentation/sdk/images/DemoApps_S_cropped.png" alt="{i18n&gt;DEMO_APPS_IMAGE_PHONE}" width="100%" class="welcomeImage" load=".handleLandingImageLoad" visible="{device&gt;/system/phone}" densityAware="false"/><Image id="desktopImage" class="desktopImage welcomeImage" src="./resources/sap/ui/documentation/sdk/images/DemoApps_M_and_L_cropped.png" alt="{i18n&gt;DEMO_APPS_IMAGE_DESKTOP}" densityAware="false" load=".handleLandingImageLoad" visible="{=!${device&gt;/system/phone}}" width="100%"/><l:Grid id="landingImageHeadline" width="100%" visible="false" class="headerGrid" hSpacing="0" defaultSpan="L6 M6 S12"><l:VerticalLayout width="100%" class="sapUiTinyMarginTop sapUiTinyMarginEnd"><Text class="headerText" text="{i18n&gt;DEMO_APPS_TEXT}" width="100%" textAlign="Left"/><l:HorizontalLayout><Button class="actionButton headerButton" id="download" text="{i18n&gt;DEMO_APPS_DOWNLOAD_BTN}" type="Emphasized" press=".onDownloadButtonPress"/><Button class="actionButton headerButton sapContrast sapContrastPlus sapUiSmallMarginBegin" id="readMoreButton" text="{i18n&gt;DEMO_APPS_READ_MORE_BTN}" press=".onReadMoreButtonPress"/></l:HorizontalLayout></l:VerticalLayout></l:Grid></l:BlockLayoutCell></l:BlockLayoutRow></l:BlockLayout></Panel><l:VerticalLayout content="{/demoAppsByCategory}" width="100%"><Panel accessibleRole="Region" backgroundDesign="Transparent" class="sapUiNoContentPadding"><headerToolbar><Toolbar class="headlineCell"><Title text="{path:\'categoryId\',formatter:\'.formatter.categoryName\'}" level="H1" titleStyle="H1" class="sapUiMediumMarginTopBottom"/></Toolbar></headerToolbar><l:BlockLayout content="{path:\'rows\',templateShareable:false}" background="Light"><l:BlockLayoutRow content="{path:\'\',factory:\'.createDemoAppCell\'}"/></l:BlockLayout></Panel></l:VerticalLayout><l:BlockLayout id="demoAppsFooter" visible="{/bFooterVisible}"><l:BlockLayoutRow><core:Fragment id="footerFragment" fragmentName="sap.ui.documentation.sdk.view.Footer" type="XML"/></l:BlockLayoutRow></l:BlockLayout></ScrollContainer></content><dependents><SelectDialog id="downloadDialog" items="{/demoApps}" title="{i18n&gt;DEMO_APPS_DOWNLOAD_DIALOG_TITLE}" liveChange=".onSearch" growing="false" confirm=".onDownloadPress"><InputListItem visible="{= !!${config} }" label="{name}" type="Active"><customData><core:CustomData key="config" value="{config}"/></customData><Button text="{i18n&gt;DEMO_APPS_DOWNLOAD_BTN}" type="Emphasized" press=".onDownloadPress"/></InputListItem></SelectDialog></dependents></Page></mvc:View>',
	"sap/ui/documentation/sdk/view/Downloads.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.Downloads" xmlns:mvc="sap.ui.core.mvc" xmlns="sap.m"><Label text="{i18n&gt;DOWNLOADS_TEXT}"/></mvc:View>',
	"sap/ui/documentation/sdk/view/Empty.view.xml":'<mvc:View xmlns:mvc="sap.ui.core.mvc" xmlns="sap.m"><Label text="Empty"/></mvc:View>',
	"sap/ui/documentation/sdk/view/Entity.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.Entity" xmlns:mvc="sap.ui.core.mvc" xmlns:core="sap.ui.core" xmlns:m="sap.m" xmlns:l="sap.ui.layout" xmlns="sap.uxap" xmlns:html="http://www.w3.org/1999/xhtml"><ObjectPageLayout id="ObjectPageLayout" useIconTabBar="true" selectedSection="samples" upperCaseAnchorBar="false" busyIndicatorDelay="0"><headerTitle><ObjectPageHeader id="entityHeader" objectTitle="{/name}"><actions><ObjectPageHeaderActionButton id="entityBackToSearch" text="{i18n&gt;ENTITY_BACK_BTN}" hideIcon="true" hideText="false" press="backToSearch" visible="false"/><ObjectPageHeaderActionButton id="toggleFullScreenBtn" visible="{device&gt;/system/desktop}" icon="sap-icon://full-screen" tooltip="{i18n&gt;ENTITY_FULLSCREEN_TOOLTIP}" press="onToggleFullScreen"/></actions></ObjectPageHeader></headerTitle><headerContent><l:Grid defaultSpan="L4 M6 S12" class="sapUiNoMargin" hSpacing="0"><l:VerticalLayout width="98%" id="headerColumn0"/><l:VerticalLayout width="100%" id="headerColumn1" visible="false"/><l:VerticalLayout width="100%" id="headerColumn2" visible="false"/></l:Grid></headerContent><sections><ObjectPageSection id="about" title="{i18n&gt;ENTITY_ABOUT}"><subSections><ObjectPageSubSection><l:VerticalLayout><core:HTML content="{/description}"/><l:VerticalLayout visible="{/show/introLink}"><m:Text text="{/shortDescription}"/></l:VerticalLayout></l:VerticalLayout></ObjectPageSubSection></subSections></ObjectPageSection><ObjectPageSection id="samples" title="{parts:[\'i18n&gt;ENTITY_SAMPLES\',\'/count/samples\'],formatter:\'.formatMessage\'}" visible="{= ${/count/samples} &gt; 0 }"><subSections><ObjectPageSubSection><m:VBox><m:MessageStrip class="sapUiSmallMarginBottom sapUiSmallNegativeMarginBeginEnd" text="{/deprecatedMark}" type="Error" visible="{= ${/deprecated} === \'true\'}"/><m:Table class="myTable sapUxAPObjectPageSubSectionAlignContent" width="auto" id="table" items="{/entity/samples}" fixedLayout="false" showSeparators="Inner"><m:columns><m:Column><m:Label text="{i18n&gt;ENTITY_TABLE_NAME}"/></m:Column><m:Column minScreenWidth="Tablet"><m:Label text="{i18n&gt;ENTITY_TABLE_DESCRIPTION}"/></m:Column></m:columns><m:items><m:ColumnListItem type="Navigation" press="onNavToSample" vAlign="Middle"><m:cells><m:Text text="{name}" class="entitySampleName" wrapping="false"/><m:FormattedText htmlText="{= ${path: \'description\'} ? ${path: \'description\'} : \'\'}"/></m:cells></m:ColumnListItem></m:items></m:Table></m:VBox></ObjectPageSubSection></subSections></ObjectPageSection></sections></ObjectPageLayout></mvc:View>',
	"sap/ui/documentation/sdk/view/FeedbackDialog.fragment.xml":'<core:FragmentDefinition xmlns="sap.m" xmlns:core="sap.ui.core" xmlns:html="http://www.w3.org/1999/xhtml"><Dialog title="{i18n&gt;FEEDBACK_DIALOG_TITLE}" class="sapUiContentPadding" id="feedbackDialog" resizable="true" draggable="true" contentHeight="35rem" contentWidth="32rem" stretch="{appView&gt;/bPhoneSize}" showHeader="true"><content><VBox><HBox justifyContent="SpaceBetween"><items><Label text="{i18n&gt;FEEDBACK_DIALOG_OVERALL}" design="Bold" class="sapMFontMediumSize" required="true"/><ObjectStatus id="ratingStatus" text="" state="None" class="sapMFontMediumSize"/></items></HBox><HBox id="feedbackButtons"><items><ToggleButton id="excellent" width="100%" press="onPressRatingButton" icon="sap-icon://FeedbackRatingFaces/icon-face-very-happy" class="rateButton"><layoutData><FlexItemData growFactor="1"/></layoutData></ToggleButton><ToggleButton id="good" width="100%" press="onPressRatingButton" icon="sap-icon://FeedbackRatingFaces/icon-face-happy" class="rateButton"><layoutData><FlexItemData growFactor="1"/></layoutData></ToggleButton><ToggleButton id="average" width="100%" press="onPressRatingButton" icon="sap-icon://FeedbackRatingFaces/icon-face-neutral" class="rateButton"><layoutData><FlexItemData growFactor="1"/></layoutData></ToggleButton><ToggleButton id="poor" width="100%" press="onPressRatingButton" icon="sap-icon://FeedbackRatingFaces/icon-face-bad" class="rateButton"><layoutData><FlexItemData growFactor="1"/></layoutData></ToggleButton><ToggleButton id="veryPoor" width="100%" press="onPressRatingButton" icon="sap-icon://FeedbackRatingFaces/icon-face-very-bad" class="rateButton"><layoutData><FlexItemData growFactor="1"/></layoutData></ToggleButton></items></HBox><Label text="{i18n&gt;FEEDBACK_DIALOG_MESSAGE}" design="Bold" class="sapUiTinyMarginTop"/><TextArea id="feedbackInput" width="100%" placeholder="{i18n&gt;FEEDBACK_DIALOG_MESSAGE_PLACEHOLDER}" rows="7" class="sapMFontMediumSize sapUiFeedbackDialogTextArea"/><CheckBox id="pageContext" text="{i18n&gt;FEEDBACK_DIALOG_RELATED}" selected="true" class="sapMFontMediumSize contextCheckBoxAlign" select="onContextSelect"/><FormattedText class="sapMLabel sapUiFeedbackDialogNoteLabel sapUiTinyMarginBottom" htmlText="&lt;strong&gt;Note:&lt;/strong&gt; If you want to report a bug,    {= ${versionData&gt;/isOpenUI5} ?    \' you can open a GitHub issue &lt;a href=&quot;https://github.com/SAP/openui5/issues/new&quot;&gt;here.&lt;/a&gt;\' :    ${versionData&gt;/isSnapshotVersion} ?    \' please open a BCP ticket on CA-UI5-CTR component.\' :    \' you can report an Incident &lt;a href=&quot;https://launchpad.support.sap.com/#incident/solution&quot;&gt;here.&lt;/a&gt;\'    }    This way we will be able to get back to you in case we have follow-up questions."/><FormattedText class="sapMLabel sapUiFeedbackDialogNoteLabel sapUiTinyMarginBottom" visible="{= ${versionData&gt;/isOpenUI5}}" htmlText="You can contribute directly to the &lt;a href=&quot;https://github.com/SAP/openui5-docs&quot; target=&quot;_blank&quot;&gt;OpenUI5 Documentation&lt;/a&gt; on GitHub."/><Link text="{i18n&gt;FEEDBACK_DIALOG_SHOW_DATA}" class="sapMFontMediumSize sapUiTinyMarginBottom" press="onShowHideContextData"/><TextArea id="contextData" width="100%" value="Details/ descriptive text..." visible="false" editable="false" rows="3" class="sapUiBaseText sapMFontMediumSize sapUiTinyMarginBottom sapUiNoMarginTop"/><MessageStrip text="{i18n&gt;FEEDBACK_DIALOG_DISCLAIMER}" type="Information" showIcon="true"/></VBox></content><beginButton><Button id="sendButton" text="{i18n&gt;FEEDBACK_DIALOG_BTN_SEND}" press="onFeedbackDialogSend" enabled="false" type="Emphasized"/></beginButton><endButton><Button id="cancelButton" text="{i18n&gt;FEEDBACK_DIALOG_BTN_CANCEL}" press="onFeedbackDialogCancel"/></endButton></Dialog></core:FragmentDefinition>',
	"sap/ui/documentation/sdk/view/Footer.fragment.xml":'<core:FragmentDefinition xmlns="sap.m" xmlns:l="sap.ui.layout" xmlns:core="sap.ui.core"><l:BlockLayoutCell class="demokitInitialPagesColorPatternFContrast sapUiDocumentationFooter"><FlexBox alignItems="{= ${device&gt;/system/phone} ? \'Start\' : \'Center\' }" justifyContent="SpaceBetween" direction="{= ${device&gt;/system/phone} ? \'Column\' : \'Row\' }" width="100%"><items><Image src="./resources/sap/ui/documentation/sdk/images/logo_sap.png" densityAware="false" width="3rem" height="1.5rem"/><FlexBox direction="{= ${device&gt;/system/phone} ? \'Column\' : \'Row\' }" class="sapUiTinyMarginTop"><items><Link class="demokitInitialPagesBrightLink sapUiLargeMarginEnd sapUiTinyMarginBottom" text="{i18n&gt;FOOTER_LEGAL_DISCOLURE}" href="https://www.sap.com/corporate/en/legal/impressum.html" target="_blank"/><Link class="demokitInitialPagesBrightLink sapUiLargeMarginEnd sapUiTinyMarginBottom" text="{i18n&gt;FOOTER_PRIVACY}" href="https://www.sap.com/corporate/en/legal/privacy.html" target="_blank"/><Link class="demokitInitialPagesBrightLink" text="{i18n&gt;FOOTER_TERMS}" href="https://www.sap.com/corporate/en/legal/terms-of-use.html" visible="{=!${versionData&gt;/isOpenUI5}}" target="_blank"/><Link class="demokitInitialPagesBrightLink sapUiTinyMarginBottom sapUiLargeMarginEnd" text="{i18n&gt;FOOTER_LICENSE}" href="LICENSE.txt" visible="{versionData&gt;/isOpenUI5}" target="_blank"/><Link class="demokitInitialPagesBrightLink" text="{i18n&gt;FOOTER_TERMS}" href="TermsOfUse.txt" visible="{versionData&gt;/isOpenUI5}" target="_blank"/></items></FlexBox></items></FlexBox></l:BlockLayoutCell></core:FragmentDefinition>',
	"sap/ui/documentation/sdk/view/Group.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.Group" xmlns="sap.uxap" xmlns:m="sap.m" xmlns:mvc="sap.ui.core.mvc" xmlns:core="sap.ui.core" xmlns:layout="sap.ui.layout" xmlns:controls="sap.ui.documentation"><m:Page id="controlsDetailPage" navButtonPress="onNavBack" showHeader="{device&gt;/orientation/portrait}" showSubHeader="false" showFooter="false" showNavButton="{device&gt;/system/phone}" busy="{detailView&gt;/busy}" busyIndicatorDelay="{detailView&gt;/delay}"><m:content/></m:Page></mvc:View>',
	"sap/ui/documentation/sdk/view/LegalDisclaimerPopover.fragment.xml":'<core:FragmentDefinition xmlns="sap.m" xmlns:core="sap.ui.core"><ResponsivePopover placement="Auto" title="{i18n&gt;LEGAL_DISCLAIMER_TITLE}" horizontalScrolling="false" contentWidth="30%" class="sapUiContentPadding"><Label text="{i18n&gt;LEGAL_DISCLAIMER_LABEL_1}" design="Bold"/><Image src="./resources/sap/ui/documentation/sdk/images/link-external.png" tooltip="{i18n&gt;LEGAL_DISCLAIMER_EXTERNAL_TOOLTIP}" width="1.25rem" class="sapUiTinyMarginBegin"/><Text text="{i18n&gt;LEGAL_DISCLAIMER_TEXT_1}"/><Text text="{i18n&gt;LEGAL_DISCLAIMER_TEXT_2}"/><Text text="{i18n&gt;LEGAL_DISCLAIMER_TEXT_3}"/><Label text="{i18n&gt;LEGAL_DISCLAIMER_LABEL_2}" design="Bold" class="sapUiTinyMarginTop"/><Image src="./resources/sap/ui/documentation/sdk/images/link-sap.png" tooltip="{i18n&gt;LEGAL_DISCLAIMER_INTERNAL_TOOLTIP}" width="1.25rem" class="sapUiTinyMarginBegin"/><Text text="{i18n&gt;LEGAL_DISCLAIMER_TEXT_4}"/></ResponsivePopover></core:FragmentDefinition>',
	"sap/ui/documentation/sdk/view/License.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.License" id="license" height="100%" xmlns:mvc="sap.ui.core.mvc" xmlns="sap.m"><Page height="100%" showHeader="false" showSubHeader="false"><Text id="licenseText" renderWhitespace="true" class="sapUiTinyMarginBegin"/></Page></mvc:View>',
	"sap/ui/documentation/sdk/view/LiveEditor.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.LiveEditor" xmlns="sap.m" xmlns:l="sap.ui.layout" xmlns:core="sap.ui.core" xmlns:mvc="sap.ui.core.mvc" xmlns:custom="sap.ui.documentation" xmlns:editor="sap.ui.codeeditor" xmlns:html="http://www.w3.org/1999/xhtml" class="liveEditor"><html:div class="editorWrapper">\n        <html:div>\n            <Title text="{i18n&gt;LIVE_EDITOR_TITLE}"/>\n            <IconTabHeader selectedKey="{viewModel&gt;/selectedFileName}" select="onFileSwitch"><items><IconTabFilter text="App.view.xml" key="App.view.xml"/><IconTabFilter text="App.controller.js" key="App.controller.js"/><IconTabFilter text="index.js" key="index.js"/><IconTabFilter text="index.html" key="index.html"/></items></IconTabHeader>\n            <html:div class="editorSrcWindow">\n                <editor:CodeEditor id="srcEditor" editable="{= ${viewModel&gt;/selectedFileType} !== \'text\' }" value="{viewModel&gt;/selectedFileContent}" type="{viewModel&gt;/selectedFileType}" liveChange="onSrcLiveChange"/>\n            </html:div>\n        </html:div>\n\n        <VBox id="resultBox"><Title text="{i18n&gt;LIVE_EDITOR_RESULT}"/><Toolbar style="Clear" class="editorToolbar"><Button text="{i18n&gt;LIVE_EDITOR_PREVIEW_BTN}" press="requestExecuteCurrentSrc" enabled="{= !${viewModel&gt;/autoPreview}}"/><CheckBox text="{i18n&gt;LIVE_EDITOR_LIVE_PREVIEW_TEXT}" selected="{viewModel&gt;/autoPreview}"/></Toolbar><core:HTML id="outputWindowWrapper" content="&lt;div&gt; &lt;/div&gt;"/></VBox>\n    </html:div></mvc:View>',
	"sap/ui/documentation/sdk/view/NotFound.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.NotFound" xmlns:mvc="sap.ui.core.mvc" xmlns="sap.m"><MessagePage id="page" title="{i18n&gt;NOT_FOUND_TITLE}" text="{i18n&gt;NOT_FOULD_TEXT}" icon="sap-icon://document" description="" showNavButton="{device&gt;/system/phone}" navButtonPress="onNavBack"/></mvc:View>',
	"sap/ui/documentation/sdk/view/ReleaseDialog.fragment.xml":'<core:FragmentDefinition xmlns="sap.m" xmlns:l="sap.ui.layout" xmlns:core="sap.ui.core"><Dialog id="releaseDialog" resizable="true" draggable="true" title="{parts:[\'i18n&gt;RELEASE_DIALOG_TITLE\',\'/library\'],formatter:\'.formatMessage\'}" contentWidth="40%" contentHeight="40%" stretch="{appView&gt;/bPhoneSize}"><Text text="{i18n&gt;RELEASE_DIALOG_NO_DATA_TEXT}" class="sapUiSmallMargin" visible="{/noDataMessage}"/><beginButton><Button text="{i18n&gt;RELEASE_DIALOG_CLOSE_BTN}" press="onReleaseDialogClose"/></beginButton></Dialog></core:FragmentDefinition>',
	"sap/ui/documentation/sdk/view/ReleaseNotes.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.ReleaseNotes" xmlns:core="sap.ui.core" xmlns:mvc="sap.ui.core.mvc" xmlns="sap.uxap" xmlns:layout="sap.ui.layout" xmlns:m="sap.m" xmlns:html="http://www.w3.org/1999/xhtml" height="100%"><ObjectPageLayout id="releaseNotesObjectPage" busy="true" enableLazyLoading="false" showTitleInHeaderContent="false" sections="{/libs}" upperCaseAnchorBar="false"><headerTitle><ObjectPageHeader objectTitle="{i18n&gt;RELEASE_NOTES_TITLE}"/></headerTitle><headerContent><layout:VerticalLayout><html:div class="sapUiCustomTitleText">\n\t\t\t\t\t\t\tThis log includes the library notes for the libraries listed below.\n\t\t\t\t\t\t\tThe change log for old version which are not patched anymore can be reviewed\n\t\t\t\t\t\t\t<m:Link text="here" href="docs/guide/relnotes/ReleaseNotes.html"/>.\n\t\t\t\t\t\t</html:div><m:Select id="VersionSelect" items="{select&gt;/items}" change="handleVersionChange" visible="false"><core:Item text="{select&gt;value}" key="{select&gt;key}"/></m:Select></layout:VerticalLayout></headerContent><sections><ObjectPageSection title="{library}" titleUppercase="false"><ObjectPageSubSection titleUppercase="false"><layout:VerticalLayout content="{path:\'versions\',templateShareable:false}" width="100%"><m:Panel headerText="{version}" content="{path:\'notes\',templateShareable:false}" expandable="true" expanded="true" class="sapUxAPObjectPageSubSectionAlignContent" width="auto"><m:Text width="100%" text="[{type}] {text}"/></m:Panel></layout:VerticalLayout></ObjectPageSubSection></ObjectPageSection></sections></ObjectPageLayout></mvc:View>',
	"sap/ui/documentation/sdk/view/Sample.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.Sample" xmlns="sap.m" xmlns:mvc="sap.ui.core.mvc" xmlns:core="sap.ui.core" xmlns:layout="sap.ui.layout" xmlns:controls="sap.ui.documentation"><Page id="page" showHeader="false" showNavButton="true" navButtonPress="onNavBack" busyIndicatorDelay="0"><landmarkInfo><PageAccessibleLandmarkInfo rootRole="Region" rootLabel="Details" headerRole="Region" headerLabel="Header" contentRole="Main" contentLabel="Content"/></landmarkInfo><subHeader><Bar id="header" class="sapContrast sapContrastPlus"><contentLeft><Button type="Back" press="onNavBack" tooltip="{i18n&gt;SAMPLE_BACK_BTN_TOOLTIP}" enabled="{= ${/disableNavBack} === undefined }"/></contentLeft><contentMiddle><Title level="H1" text="{/title}" tooltip="{/title}"/></contentMiddle><contentRight><Button id="infoSample" visible="{=${/details} !== undefined || ${/description} !== undefined}" icon="sap-icon://hint" tooltip="{i18n&gt;SAMPLE_INFO_TOOLTIP}" press="onInfoSample"/><Button id="apiRefButton" text="{i18n&gt;SAMPLE_API_REFERENCE_BTN}" type="Emphasized" press="onAPIRefPress" visible="false"/><Button id="prevSample" icon="sap-icon://navigation-up-arrow" class="sapUiHideOnPhone" tooltip="{i18n&gt;SAMPLE_PREV_BTN_TOOLTIP}" enabled="{= ${/previousSampleId} !== undefined }" press="onPreviousSample"/><Button id="nextSample" icon="sap-icon://navigation-down-arrow" class="sapUiHideOnPhone" tooltip="{i18n&gt;SAMPLE_NEXT_BTN_TOOLTIP}" enabled="{= ${/nextSampleId} !== undefined }" press="onNextSample"/><Button id="toggleFullScreenBtn" icon="sap-icon://full-screen" visible="{:= ${device&gt;/system/desktop} ||           ( ${device&gt;/system/tablet} &amp;&amp;           ${device&gt;/orientation/landscape} ) }" tooltip="{i18n&gt;SAMPLE_FULLSCREEN_BTN_TOOLTIP}" press="onToggleFullScreen"/><Button id="toggleRTA" icon="sap-icon://wrench" class="sapUiHideOnPhone" tooltip="{i18n&gt;SAMPLE_ADAPT_BTN_TOOLTIP}" press="onToggleAdaptationMode" visible="{= !${/iframe} &amp;&amp; ${/rtaLoaded}}"/><Button id="code" icon="sap-icon://syntax" tooltip="{i18n&gt;SAMPLE_CODE_BTN_TOOLTIP}" press="onNavToCode"/><Button visible="{/showNewTab}" id="newTab" tooltip="{i18n&gt;SAMPLE_NEW_TAB_BTN_TOOLTIP}" icon="sap-icon://inspect" press="onNewTab"/><Button class="sapUiHideOnPhone" text="{i18n&gt;SAMPLE_DOWNLOAD_BTN_TOOLTIP}" icon="sap-icon://download" press="onDownload"/><Button class="sapUiVisibleOnlyOnPhone" icon="sap-icon://download" press="onDownload"/></contentRight></Bar></subHeader></Page></mvc:View>',
	"sap/ui/documentation/sdk/view/SearchPage.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.SearchPage" xmlns="sap.m" xmlns:op="sap.uxap" xmlns:mvc="sap.ui.core.mvc" xmlns:app="http://schemas.sap.com/sapui5/extension/sap.ui.core.CustomData/1"><op:ObjectPageLayout id="searchPage" useIconTabBar="true" alwaysShowContentHeader="true" upperCaseAnchorBar="false"><op:headerTitle><op:ObjectPageHeader id="searchTitle" objectTitle="{parts:[\'i18n&gt;SEARCH_PAGE_TITLE\',\'/searchTerm\'],formatter:\'.formatMessage\'}"/></op:headerTitle><op:headerContent><ObjectAttribute title="" text="{i18n&gt;SEARCH_PAGE_DESCRIPTION}"/></op:headerContent><op:sections><op:ObjectPageSection id="allSummaryTitle" title="{parts:[\'i18n&gt;SEARCH_PAGE_ALL_SECTION_TITLE\',\'/AllLength\'],formatter:\'.formatMessage\'}"><op:subSections><op:ObjectPageSubSection><op:blocks><VBox class="sapUxAPObjectPageSubSectionAlignContent" width="auto"><OverflowToolbar design="Transparent" height="3rem"><Title text="{parts:[\'i18n&gt;SEARCH_PAGE_ALL_SECTION_TABLE_TITLE\',\'/visibleAllLength\',\'/AllLength\'],formatter:\'.formatTableTitle\'}"/></OverflowToolbar><List id="allList" growing="true" growingThreshold="25" updateFinished="onAllLoadMore" items="{path:\'/data\',groupHeaderFactory:\'.getGroupHeader\'}"><FeedListItem sender="{title}" text="{summary}" showIcon="false" app:path="{path}"/></List></VBox></op:blocks></op:ObjectPageSubSection></op:subSections></op:ObjectPageSection><op:ObjectPageSection title="{parts:[\'i18n&gt;SEARCH_PAGE_API_SECTION_TITLE\',\'/APILength\'],formatter:\'.formatMessage\'}" visible="{=!!${/APILength}}"><op:subSections><op:ObjectPageSubSection><op:blocks><VBox class="sapUxAPObjectPageSubSectionAlignContent" width="auto"><OverflowToolbar design="Transparent" height="3rem"><Title text="{parts:[\'i18n&gt;SEARCH_PAGE_API_SECTION_TABLE_TITLE\',\'/visibleAPILength\',\'/APILength\'],formatter:\'.formatTableTitle\'}"/></OverflowToolbar><List id="apiList" growing="true" growingThreshold="25" updateFinished="onAPILoadMore" items="{path:\'/dataAPI\'}"><FeedListItem visible="{path:\'category\',formatter:\'.categoryAPIFormatter\'}" sender="{title}" text="{summary}" showIcon="false" app:path="{path}"/></List></VBox></op:blocks></op:ObjectPageSubSection></op:subSections></op:ObjectPageSection><op:ObjectPageSection title="{parts:[\'i18n&gt;SEARCH_PAGE_DOCUMENTATION_SECTION_TITLE\',\'/DocLength\'],formatter:\'.formatMessage\'}" visible="{=!!${/DocLength}}"><op:subSections><op:ObjectPageSubSection><op:blocks><VBox class="sapUxAPObjectPageSubSectionAlignContent" width="auto"><OverflowToolbar design="Transparent" height="3rem"><Title text="{parts:[\'i18n&gt;SEARCH_PAGE_DOCUMENTATION_SECTION_TABLE_TITLE\',\'/visibleDocLength\',\'/DocLength\'],formatter:\'.formatTableTitle\'}"/></OverflowToolbar><List id="documentationList" growing="true" growingThreshold="25" updateFinished="onDocLoadMore" items="{path:\'/dataDoc\'}"><FeedListItem visible="{path:\'category\',formatter:\'.categoryDocFormatter\'}" sender="{title}" text="{summary}" showIcon="false" app:path="{path}"/></List></VBox></op:blocks></op:ObjectPageSubSection></op:subSections></op:ObjectPageSection><op:ObjectPageSection title="{parts:[\'i18n&gt;SEARCH_PAGE_SAMPLES_SECTION_TITLE\',\'/ExploredLength\'],formatter:\'.formatMessage\'}" visible="{=!!${/ExploredLength}}"><op:subSections><op:ObjectPageSubSection><op:blocks><VBox class="sapUxAPObjectPageSubSectionAlignContent" width="auto"><OverflowToolbar design="Transparent" height="3rem"><Title text="{parts:[\'i18n&gt;SEARCH_PAGE_SAMPLES_SECTION_TABLE_TITLE\',\'/visibleExploredLength\',\'/ExploredLength\'],formatter:\'.formatTableTitle\'}"/></OverflowToolbar><List id="samplesList" growing="true" growingThreshold="25" updateFinished="onExploredLoadMore" items="{path:\'/dataExplored\'}"><FeedListItem visible="{path:\'category\',formatter:\'.categoryExploredFormatter\'}" sender="{title}" text="{summary}" showIcon="false" app:path="{path}"/></List></VBox></op:blocks></op:ObjectPageSubSection></op:subSections></op:ObjectPageSection></op:sections></op:ObjectPageLayout></mvc:View>',
	"sap/ui/documentation/sdk/view/SubApiDetail.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.SubApiDetail" xmlns="sap.uxap" xmlns:m="sap.m" xmlns:core="sap.ui.core" xmlns:mvc="sap.ui.core.mvc" xmlns:layout="sap.ui.layout" xmlns:custom="sap.ui.documentation" xmlns:template="http://schemas.sap.com/sapui5/extension/sap.ui.core.template/1"><m:Page id="apiDetailPage" showHeader="false" showSubHeader="false" showFooter="false" class="apiDetailPage"><m:content><ObjectPageLayout id="apiDetailObjectPage" enableLazyLoading="true" showAnchorBarPopover="true" upperCaseAnchorBar="false" busyIndicatorDelay="0"><headerTitle><ObjectPageHeader id="title" objectTitle="{/title}" objectSubtitle="{/subTitle}"><actions><ObjectPageHeaderActionButton id="apiDetailBackToSearch" text="Back to search results" hideIcon="true" hideText="false" press="backToSearch" visible="false"/><ObjectPageHeaderActionButton id="toggleFullScreenBtn" visible="{device&gt;/system/desktop}" icon="sap-icon://full-screen" tooltip="Show this sample in full screen mode" press="onToggleFullScreen"/></actions></ObjectPageHeader><core:ExtensionPoint name="customTitle"/></headerTitle><headerContent><layout:Grid defaultSpan="L4 M6 S12" class="sapUiNoMargin" hSpacing="0"><layout:VerticalLayout width="98%" id="headerColumn0"/><layout:VerticalLayout width="100%" id="headerColumn1" visible="false"/><layout:VerticalLayout width="100%" id="headerColumn2" visible="false"/></layout:Grid></headerContent><sections><ObjectPageSection id="overview" title="Overview" titleUppercase="false"><subSections><custom:ObjectPageSubSection><custom:blocks><layout:VerticalLayout width="100%"><template:if test="{=${data&gt;/deprecatedText} !== undefined}"><m:MessageStrip text="{/deprecatedText}" type="Error" showIcon="true" showCloseButton="false" enableFormattedText="true" class="sapUiSmallMarginBottom sapUiSmallMarginTop"/></template:if><custom:JSDocText sanitizeContent="false" text="{/description}"/><template:if test="{=${data&gt;/dnd/draggable} === true}"><m:MessageStrip text="This control can be a drag source." type="Information" showIcon="true" showCloseButton="false" class="sapUiSmallMarginBottom sapUiSmallMarginTop"/></template:if><template:if test="{=${data&gt;/dnd/droppable} === true}"><m:MessageStrip text="This control can be a drop target." type="Information" showIcon="true" showCloseButton="false" class="sapUiSmallMarginBottom sapUiSmallMarginTop"/></template:if><template:if test="{data&gt;/hasAnnotations}"><layout:HorizontalLayout class="sapUiTinyMarginTop sapUiDocumentationAnnotationsText"><m:Text text="A detailed description of the OData annotations handled by this control is available"/><m:Link text="here" press="onAnnotationsLinkPress"/><m:Text text="."/></layout:HorizontalLayout><layout:HorizontalLayout class="sapUiDocumentationAnnotationsText"><m:Label text="Annotation Limitations:" design="Bold"/><m:Text text="Qualifier support for entity types is limited for this control."/></layout:HorizontalLayout></template:if><template:if test="{=${data&gt;/experimental} !== undefined}"><m:MessageStrip text="Experimental API since version {/experimental/since} {/experimental/text}" type="Warning" showIcon="true" showCloseButton="false" enableFormattedText="true" class="sapUiSmallMarginBottom"/></template:if><template:if test="{= !!${data&gt;/parameters} }"><custom:LightTable rows="{path:\'/parameters\'}" columnTitles="Param,Type,Default Value,Description" columnCount="4" class="sapUiDocumentationParamsTable"><custom:Row><custom:ParamText text="{name}" phoneText="{phoneName}" depth="{depth}" optional="{optional}"/><m:Text text="{type}" wrapping="false"/><m:Text text="{defaultValue}" wrapping="false"/><custom:JSDocText sanitizeContent="false" text="{description}"/></custom:Row></custom:LightTable></template:if><template:if test="{= ${data&gt;/returnValue} !== undefined}"><custom:LightTable columnCount="2" columnTitles="Returns,Description" class="sapUiDocumentation2ColumnsEqualTable"><custom:Row><m:Text text="{path:\'data&gt;/returnValue/type\',formatter:\'sap.ui.base.ManagedObject.escapeSettingsValue\'}" wrapping="false"/><custom:JSDocText sanitizeContent="false" text="{path:\'data&gt;/returnValue/description\',formatter:\'sap.ui.base.ManagedObject.escapeSettingsValue\'}"/></custom:Row></custom:LightTable></template:if><template:if test="{data&gt;/hasChildren}"><custom:LightTable rows="{path:\'/nodes\'}" columnTitles="Namespaces &amp; Classes,Description" columnCount="2" class="sapUiSmallMarginTop"><custom:Row><custom:ParamText text="{name}" href="{href}" deprecated="{deprecated}"/><custom:JSDocText sanitizeContent="false" text="{description}"/></custom:Row></custom:LightTable></template:if><template:if test="{data&gt;/isFunction}"><template:repeat list="{data&gt;/examples}" var="example"><custom:JSDocText sanitizeContent="false" text="{path:\'example&gt;data\',formatter:\'sap.ui.base.ManagedObject.escapeSettingsValue\'}"/></template:repeat></template:if></layout:VerticalLayout></custom:blocks></custom:ObjectPageSubSection></subSections></ObjectPageSection><template:if test="{data&gt;/hasProperties}"><ObjectPageSection id="properties" title="Fields" titleUppercase="false"><subSections><custom:ObjectPageSubSection><custom:blocks><custom:LightTable rows="{path:\'/properties\'}" columnCount="3" columnTitles="Name,Type,Description" class="sapUiSmallMarginTop"><custom:Row><custom:ParamText class="sapUiDocumentationParamBold" text="{name}" deprecated="{= ${deprecated} !== undefined }"/><m:Link text="{type}" href="{href}" enabled="{= !!${linkEnabled} }"/><layout:VerticalLayout><custom:JSDocText sanitizeContent="false" text="{description}"/><m:MessageStrip visible="{=${deprecated} !== undefined}" text="Deprecated as of version {deprecated/since}" type="Error" showIcon="true" showCloseButton="false" enableFormattedText="true" class="sapUiTinyMarginBottom sapUiTinyMarginTop"/><m:MessageStrip visible="{=${experimental} !== undefined}" text="Experimental API since {experimental/since} {experimental/text}" type="Warning" showIcon="true" showCloseButton="false" enableFormattedText="true" class="sapUiTinyMarginBottom sapUiTinyMarginTop"/><m:ObjectStatus text="Visibility: {visibility}" state="{= ${visibility} === \'public\' ? \'Success\' : \'Warning\'}"/><m:ObjectStatus visible="{=${since} !== undefined}" text="Since: {since}"/></layout:VerticalLayout></custom:Row></custom:LightTable></custom:blocks></custom:ObjectPageSubSection></subSections></ObjectPageSection></template:if><template:if test="{data&gt;/hasConstructor}"><ObjectPageSection id="constructor" title="Constructor" titleUppercase="false"><subSections><custom:ObjectPageSubSection><custom:blocks><layout:VerticalLayout width="100%"><custom:JSDocText sanitizeContent="false" text="{/constructor/description}"/><layout:VerticalLayout visible="{= ${/constructor/examples} !== undefined}" content="{path:\'/constructor/examples\',templateShareable:false}"><custom:JSDocText sanitizeContent="false" text="{data}"/></layout:VerticalLayout><custom:JSDocText sanitizeContent="false" text="{/constructor/codeExample}"/><template:if test="{= !!${data&gt;/constructor/parameters} }"><custom:LightTable rows="{path:\'/constructor/parameters\'}" columnTitles="Param,Type,Default Value,Description" columnCount="4" class="sapUiDocumentationParamsTable"><custom:Row><custom:ParamText text="{name}" phoneText="{phoneName}" depth="{depth}" optional="{optional}"/><layout:VerticalLayout content="{path:\'types\',templateShareable:false}" width="100%"><m:Link text="{name}" href="api/{name}" enabled="{= !!${linkEnabled} }"/></layout:VerticalLayout><m:Text text="{defaultValue}" wrapping="false"/><custom:JSDocText sanitizeContent="false" text="{description}"/></custom:Row></custom:LightTable></template:if><template:if test="{= ${data&gt;/constructor/throws} !== undefined}"><custom:LightTable rows="{path:\'/constructor/throws\',templateShareable:false}" columnTitles="Throws,Desktop" columnCount="2" class="sapUiDocumentation2ColumnsEqualTable"><custom:Row><m:Link text="{type}" href="api/{type}" enabled="{= !!${linkEnabled} }"/><custom:JSDocText sanitizeContent="false" text="{description}"/></custom:Row></custom:LightTable></template:if></layout:VerticalLayout></custom:blocks></custom:ObjectPageSubSection></subSections></ObjectPageSection></template:if><template:if test="{data&gt;/hasControlProperties}"><ObjectPageSection id="controlproperties" title="Properties" titleUppercase="false"><subSections><custom:ObjectPageSubSection><custom:blocks><m:CheckBox text="Show borrowed properties" visible="{/bHasBorrowedProps}" displayOnly="{=!${/bHasSelfProps}}" selected="{=${/bShowBorrowedProps}}" select="onBorrowedPropCheckboxClick"/><custom:LightTable rows="{path:\'/ui5-metadata/properties\'}" columnTitles="Name,Type,Default Value,Description" columnCount="4" class="sapUiSmallMarginTop"><custom:Row><custom:ParamText class="sapUiDocumentationParamBold" text="{name}"/><m:Link text="{type}" href="api/{= ${type}.replace(\'[]\', \'\') }" enabled="{= !!${linkEnabled} }"/><m:Text text="{defaultValue}"/><layout:VerticalLayout width="100%"><custom:JSDocText sanitizeContent="false" text="{description}"/><m:ObjectStatus text="Visibility: {visibility}" state="{= ${visibility} === \'public\' ? \'Success\' : \'Warning\'}"/><m:MessageStrip visible="{=${deprecatedText} !== undefined}" text="{deprecatedText}" type="Error" showIcon="true" showCloseButton="false" enableFormattedText="true" class="sapUiTinyMarginBottom sapUiTinyMarginTop"/><m:MessageStrip visible="{=${experimental} !== undefined}" text="Experimental API since {experimental/since} {experimental/text}" type="Warning" showIcon="true" showCloseButton="false" enableFormattedText="true" class="sapUiTinyMarginBottom sapUiTinyMarginTop"/><m:FormattedText visible="{=${borrowedFrom} !== undefined}" htmlText="Borrowed from: &lt;a style=\'vertical-align:initial\' target=\'_self\' href=\'api/{borrowedFrom}\' &gt;{borrowedFrom}&lt;/a&gt;"/></layout:VerticalLayout></custom:Row></custom:LightTable></custom:blocks></custom:ObjectPageSubSection></subSections></ObjectPageSection></template:if><template:if test="{data&gt;/hasAggregations}"><ObjectPageSection id="aggregations" title="Aggregations" titleUppercase="false"><subSections><custom:ObjectPageSubSection><custom:blocks><m:CheckBox text="Show borrowed aggregations" visible="{/bHasBorrowedAggr}" displayOnly="{=!${/bHasSelfAggr}}" selected="{/bShowBorrowedAggr}" select="onBorrowedAggrCheckboxClick"/><custom:LightTable rows="{path:\'/ui5-metadata/aggregations\'}" columnTitles="{= ${data&gt;/hasAggregationAltTypes} ? \'Name,Cardinality,Type,Alt types,Description\' : \'Name,Cardinality,Type,Description\'}" columnCount="{= ${data&gt;/hasAggregationAltTypes} ? 5 : 4}" class="sapUiSmallMarginTop"><custom:Row visible="{= ${visibility} === \'public\'}"><custom:ParamText text="{name}" defaultFlag="{= ${/ui5-metadata/defaultAggregation} === ${path: \'name\'} }"/><m:Text text="{cardinality}" wrapping="false"/><m:Link text="{type}" href="api/{type}" enabled="{= !!${linkEnabled} }"/><template:if test="{data&gt;/hasAggregationAltTypes}"><m:Text text="{path:\'altTypes\',formatter:\'.formatter.apiRefAggregationAltTypes\'}"/></template:if><layout:VerticalLayout width="100%"><custom:JSDocText sanitizeContent="false" text="{description}"/><m:MessageStrip visible="{=${deprecated} !== undefined}" text="Deprecated as of version {deprecated/since}" type="Error" showIcon="true" showCloseButton="false" enableFormattedText="true" class="sapUiTinyMarginBottom sapUiTinyMarginTop"/><m:MessageStrip visible="{=${experimental} !== undefined}" text="Experimental API since {experimental/since} {experimental/text}" type="Warning" showIcon="true" showCloseButton="false" enableFormattedText="true" class="sapUiTinyMarginBottom sapUiTinyMarginTop"/><m:MessageStrip visible="{=${dnd/draggable} === true}" text="This aggregation can be a drag source." type="Information" showIcon="true" showCloseButton="false" class="sapUiSmallMarginBottom sapUiSmallMarginTop"/><m:MessageStrip visible="{=${dnd/droppable} === true}" text="This aggregation can be a drop target." type="Information" showIcon="true" showCloseButton="false" class="sapUiSmallMarginBottom sapUiSmallMarginTop"/><m:FormattedText visible="{=${borrowedFrom} !== undefined}" htmlText="Borrowed from: &lt;a style=\'vertical-align:initial\' target=\'_self\' href=\'api/{borrowedFrom}\' &gt;{borrowedFrom}&lt;/a&gt;"/></layout:VerticalLayout></custom:Row></custom:LightTable></custom:blocks></custom:ObjectPageSubSection></subSections></ObjectPageSection></template:if><template:if test="{data&gt;/hasAssociations}"><ObjectPageSection id="associations" title="Associations" titleUppercase="false"><subSections><custom:ObjectPageSubSection><custom:blocks><m:CheckBox text="Show borrowed associations" visible="{/bHasBorrowedAssoc}" displayOnly="{=!${/bHasSelfAssoc}}" selected="{/bShowBorrowedAssoc}" select="onBorrowedAssocCheckboxClick"/><custom:LightTable rows="{path:\'/ui5-metadata/associations\'}" columnCount="4" columnTitles="Name,Cardinality,Type,Description" class="sapUiSmallMarginTop"><custom:Row visible="{visibility === \'public\'}"><custom:ParamText class="sapUiDocumentationParamBold" text="{name}"/><m:Text text="{cardinality}" wrapping="false"/><m:Link text="{type}" href="api/{type}" enabled="{= !!${linkEnabled} }"/><layout:VerticalLayout width="100%"><custom:JSDocText sanitizeContent="false" text="{description}"/><m:MessageStrip visible="{=${deprecated} !== undefined}" text="Deprecated as of version {deprecated/since}" type="Error" showIcon="true" showCloseButton="false" enableFormattedText="true" class="sapUiTinyMarginBottom sapUiTinyMarginTop"/><m:MessageStrip visible="{=${experimental} !== undefined}" text="Experimental API since {experimental/since} {experimental/text}" type="Warning" showIcon="true" showCloseButton="false" enableFormattedText="true" class="sapUiTinyMarginBottom sapUiTinyMarginTop"/><m:FormattedText visible="{=${borrowedFrom} !== undefined}" htmlText="Borrowed from: &lt;a style=\'vertical-align:initial\' target=\'_self\' href=\'api/{borrowedFrom}\' &gt;{borrowedFrom}&lt;/a&gt;"/></layout:VerticalLayout></custom:Row></custom:LightTable></custom:blocks></custom:ObjectPageSubSection></subSections></ObjectPageSection></template:if><template:if test="{data&gt;/hasEvents}"><ObjectPageSection id="events" title="Events" titleUppercase="false"><subSections><custom:ObjectPageSubSection title="{= ${data&gt;/hasEvents} &amp;&amp; !${data&gt;/hasOwnEvents} ? \'Events\' : \'Summary\'}"><custom:blocks><layout:VerticalLayout width="100%"><template:if test="{data&gt;/hasOwnEvents}"><custom:LightTable columnCount="2" columnTitles="Event,Description"><template:repeat list="{data&gt;/events}" var="event"><custom:Row><custom:ParamText text="{event&gt;name}" href="api/{data&gt;/name}#events/{event&gt;name}" deprecated="{= ${event&gt;deprecated} !== undefined }" class="scrollToEvent jsdoclink"><custom:customData><core:CustomData writeToDom="true" key="target" value="{event&gt;name}"/></custom:customData></custom:ParamText><custom:JSDocText sanitizeContent="false" text="{path:\'event&gt;description\',formatter:\'sap.ui.base.ManagedObject.escapeSettingsValue\'}"/></custom:Row></template:repeat></custom:LightTable></template:if><template:if test="{= ${data&gt;/borrowed/events/}.length &gt; 0 }"><m:Title text="Borrowed from:" class="sapUiSmallMarginTop sapUiDocumentationBorrowedTitle"/><layout:VerticalLayout width="100%" content="{path:\'/borrowed/events/\',templateShareable:false}"><m:Panel class="borrowedListPanel" expandable="true" expanded="true" headerText="{name}" width="100%"><custom:BorrowedList list="{events}"/></m:Panel></layout:VerticalLayout></template:if></layout:VerticalLayout></custom:blocks></custom:ObjectPageSubSection><template:repeat list="{data&gt;/events}" var="event"><custom:ObjectPageSubSection title="{event&gt;name}"><custom:blocks><layout:VerticalLayout width="100%"><custom:JSDocText sanitizeContent="false" text="{path:\'event&gt;description\',formatter:\'sap.ui.base.ManagedObject.escapeSettingsValue\'}"/><m:ObjectStatus text="Visibility: {event&gt;visibility}" state="{= ${event&gt;visibility} === \'public\' ? \'Success\' : \'Warning\'}" class="sapUiSmallMarginBottom"/><template:if test="{=${event&gt;deprecated} !== undefined}"><m:MessageStrip text="{event&gt;deprecatedText}" type="Error" showIcon="true" showCloseButton="false" enableFormattedText="true" class="sapUiSmallMarginBottom"/></template:if><template:if test="{=${event&gt;experimental} !== undefined}"><m:MessageStrip text="Experimental API since {event&gt;experimental/since} {event&gt;experimental/text}" type="Warning" showIcon="true" enableFormattedText="true" class="sapUiSmallMarginBottom"/></template:if><template:if test="{= !!${event&gt;parameters} &amp;&amp; ${event&gt;parameters}.length &gt; 0}"><custom:LightTable columnTitles="Param,Type,Description" columnCount="3"><template:repeat list="{event&gt;parameters}" var="parameter"><custom:Row><custom:ParamText text="{parameter&gt;name}" phoneText="{parameter&gt;phoneName}" depth="{parameter&gt;depth}" optional="{parameter&gt;optional}"/><m:Link text="{parameter&gt;type}" href="api/{parameter&gt;type}" enabled="{= !!${parameter&gt;linkEnabled} }"/><layout:VerticalLayout><custom:JSDocText sanitizeContent="false" text="{path:\'parameter&gt;description\',formatter:\'sap.ui.base.ManagedObject.escapeSettingsValue\'}"/><m:MessageStrip visible="{=${parameter&gt;deprecated} !== undefined}" text="{parameter&gt;deprecatedText}" type="Error" showIcon="true" showCloseButton="false" enableFormattedText="true" class="sapUiTinyMarginBottom sapUiTinyMarginTop"/></layout:VerticalLayout></custom:Row></template:repeat></custom:LightTable></template:if></layout:VerticalLayout></custom:blocks></custom:ObjectPageSubSection></template:repeat></subSections></ObjectPageSection></template:if><template:if test="{data&gt;/hasMethods}"><ObjectPageSection id="methods" title="Methods" titleUppercase="false" class="APIDetailMethodsSection"><subSections><custom:ObjectPageSubSection title="{= ${data&gt;/hasMethods} &amp;&amp; !${data&gt;/hasOwnMethods} ? \'Methods\' : \'Summary\'}"><custom:blocks><layout:VerticalLayout width="100%"><template:if test="{data&gt;/hasOwnMethods}"><custom:LightTable columnCount="2" columnTitles="Method,Description"><template:repeat list="{data&gt;/methods}" var="method"><custom:Row><custom:ParamText text="{method&gt;name}" href="{method&gt;href}" deprecated="{= ${method&gt;deprecated} !== undefined }" experimental="{= ${method&gt;experimental} !== undefined }" class="scrollToMethod jsdoclink"><custom:customData><core:CustomData writeToDom="true" key="target" value="{method&gt;name}"/></custom:customData></custom:ParamText><custom:JSDocText sanitizeContent="false" text="{path:\'method&gt;description\',formatter:\'sap.ui.base.ManagedObject.escapeSettingsValue\'}"/></custom:Row></template:repeat></custom:LightTable></template:if><template:if test="{= ${data&gt;/borrowed/methods/}.length &gt; 0 }"><m:Title text="Borrowed from:" class="sapUiSmallMarginTop sapUiDocumentationBorrowedTitle"/><layout:VerticalLayout width="100%" content="{path:\'/borrowed/methods/\',templateShareable:false}"><m:Panel class="borrowedListPanel" expandable="true" expanded="true" headerText="{name}" width="100%"><custom:BorrowedList list="{methods}"/></m:Panel></layout:VerticalLayout></template:if></layout:VerticalLayout></custom:blocks></custom:ObjectPageSubSection><template:repeat list="{data&gt;/methods}" var="method"><custom:ObjectPageSubSection title="{method&gt;name}" id="{method&gt;placeholderId}"><custom:blocks><ObjectPageLazyLoader stashed="true" id="{method&gt;subPlaceholderId}"><layout:VerticalLayout width="100%"><custom:JSDocText sanitizeContent="false" text="{path:\'method&gt;description\',formatter:\'sap.ui.base.ManagedObject.escapeSettingsValue\'}"/><layout:VerticalLayout visible="{= ${method&gt;examples} !== undefined}" width="100%"><template:repeat list="{method&gt;examples}" var="example"><custom:JSDocText sanitizeContent="false" text="{path:\'example&gt;data\',formatter:\'sap.ui.base.ManagedObject.escapeSettingsValue\'}"/></template:repeat></layout:VerticalLayout><layout:HorizontalLayout class="sapUiTinyMarginBottom"><m:ObjectStatus text="Visibility: {method&gt;visibility}" state="{= ${method&gt;visibility} === \'public\' ? \'Success\' : \'Warning\'}" class="sapUiTinyMarginEnd"/><m:ObjectStatus visible="{=${method&gt;since} !== undefined}" text="Since: {method&gt;since}"/></layout:HorizontalLayout><template:if test="{=${method&gt;deprecated} !== undefined}"><m:MessageStrip text="{method&gt;deprecatedText}" type="Error" showIcon="true" showCloseButton="false" enableFormattedText="true" class="sapUiSmallMarginBottom"/></template:if><template:if test="{=${method&gt;experimental} !== undefined}"><m:MessageStrip text="Experimental API since {method&gt;experimental/since} {method&gt;experimental/text}" type="Warning" showIcon="true" showCloseButton="false" enableFormattedText="true" class="sapUiSmallMarginBottom"/></template:if><custom:JSDocText text="{method&gt;code}"/><template:if test="{= !!${method&gt;parameters} &amp;&amp; ${method&gt;parameters}.length &gt; 0}"><custom:LightTable columnCount="4" columnTitles="Param,Type,Default Value,Description" class="sapUiDocumentationParamsTable"><template:repeat list="{method&gt;parameters}" var="parameter"><custom:Row><custom:ParamText text="{parameter&gt;name}" phoneText="{parameter&gt;phoneName}" depth="{parameter&gt;depth}" optional="{parameter&gt;optional}"/><layout:VerticalLayout class="sapUiDocumentationOrList" width="100%"><template:repeat list="{parameter&gt;types}" var="type"><template:if test="{= !!${type&gt;linkEnabled} }"><template:then><m:Link text="{path:\'type&gt;value\',formatter:\'sap.ui.base.ManagedObject.escapeSettingsValue\'}" href="{type&gt;href}" enabled="true"/></template:then><template:else><m:Link text="{path:\'type&gt;value\',formatter:\'sap.ui.base.ManagedObject.escapeSettingsValue\'}" enabled="false"/></template:else></template:if></template:repeat></layout:VerticalLayout><m:Text text="{parameter&gt;defaultValue}" wrapping="false"/><custom:JSDocText sanitizeContent="false" text="{path:\'parameter&gt;description\',formatter:\'sap.ui.base.ManagedObject.escapeSettingsValue\'}"/></custom:Row></template:repeat></custom:LightTable></template:if><template:if test="{= ${method&gt;returnValue} !== undefined}"><custom:LightTable columnCount="2" columnTitles="Returns,Description" class="sapUiDocumentation2ColumnsEqualTable"><custom:Row><layout:VerticalLayout class="sapUiDocumentationOrList" width="100%"><template:repeat list="{method&gt;returnValue/types}" var="rtype"><m:Link text="{rtype&gt;value}" href="{rtype&gt;href}" enabled="{= !!${rtype&gt;linkEnabled} }"/></template:repeat></layout:VerticalLayout><custom:JSDocText sanitizeContent="false" text="{path:\'method&gt;returnValue/description\',formatter:\'sap.ui.base.ManagedObject.escapeSettingsValue\'}"/></custom:Row></custom:LightTable></template:if><template:if test="{= ${method&gt;throws} !== undefined}"><custom:LightTable columnTitles="Throws,Description" columnCount="2" class="sapUiDocumentation2ColumnsEqualTable"><template:repeat list="{method&gt;throws}" var="throws"><custom:Row><m:Link text="{throws&gt;type}" href="api/{throws&gt;type}" enabled="{= !!${throws&gt;linkEnabled} }"/><custom:JSDocText sanitizeContent="false" text="{path:\'throws&gt;description\',formatter:\'sap.ui.base.ManagedObject.escapeSettingsValue\'}"/></custom:Row></template:repeat></custom:LightTable></template:if></layout:VerticalLayout></ObjectPageLazyLoader></custom:blocks></custom:ObjectPageSubSection></template:repeat></subSections></ObjectPageSection></template:if><template:if test="{data&gt;/hasSpecialSettings}"><ObjectPageSection id="specialsettings" title="Special Settings" titleUppercase="false"><subSections><custom:ObjectPageSubSection><custom:blocks><custom:LightTable rows="{path:\'/ui5-metadata/specialSettings\'}" columnCount="3" columnTitles="Name,Type,Description" class="sapUiSmallMarginTop sapUiDocumentationSpecialSettingsTable"><custom:Row><custom:ParamText class="sapUiDocumentationParamBold" text="{name}"/><m:Link text="{type}" href="api/{type}" enabled="{= !!${linkEnabled} }"/><custom:JSDocText sanitizeContent="false" text="{description}"/></custom:Row></custom:LightTable></custom:blocks></custom:ObjectPageSubSection></subSections></ObjectPageSection></template:if><template:if test="{data&gt;/hasAnnotations}"><ObjectPageSection id="annotations" title="Annotations" titleUppercase="false"><subSections><custom:ObjectPageSubSection title="Summary"><custom:blocks><custom:LightTable columnCount="2" columnTitles="Annotation,Description"><template:repeat list="{data&gt;/ui5-metadata/annotations}" var="annotation"><custom:Row><m:Link text="{= ${annotation&gt;annotation} !== \'undefined\' ? ${annotation&gt;annotation} : \'(\' + ${annotation&gt;namespaceText} + \')\' }" class="scrollToAnnotation jsdoclink" wrapping="false"><m:customData><core:CustomData writeToDom="true" key="target" value="{= ${annotation&gt;annotation} !== \'undefined\' ? ${annotation&gt;annotation} : ${annotation&gt;namespaceText} }"/></m:customData></m:Link><custom:JSDocText sanitizeContent="false" text="{path:\'annotation&gt;description\',formatter:\'sap.ui.base.ManagedObject.escapeSettingsValue\'}"/></custom:Row></template:repeat></custom:LightTable></custom:blocks></custom:ObjectPageSubSection><template:repeat list="{data&gt;/ui5-metadata/annotations}" var="annotation"><custom:ObjectPageSubSection title="{= ${annotation&gt;annotation} !== \'undefined\' ? ${annotation&gt;annotation} : \'(\' + ${annotation&gt;namespaceText} + \')\' }"><custom:blocks><layout:VerticalLayout width="100%"><custom:JSDocText sanitizeContent="false" text="{path:\'annotation&gt;description\',formatter:\'sap.ui.base.ManagedObject.escapeSettingsValue\'}"/><custom:LightTable columnTitles="Namespace,Target Type,Applies To" columnCount="3"><custom:Row><custom:JSDocText sanitizeContent="false" text="{annotation&gt;namespace}"/><custom:JSDocText sanitizeContent="false" text="{annotation&gt;target}"/><custom:JSDocText sanitizeContent="false" text="{annotation&gt;appliesTo}"/></custom:Row></custom:LightTable></layout:VerticalLayout></custom:blocks></custom:ObjectPageSubSection></template:repeat></subSections></ObjectPageSection></template:if><core:ExtensionPoint name="customSections"/></sections></ObjectPageLayout></m:content></m:Page></mvc:View>',
	"sap/ui/documentation/sdk/view/TermsOfUse.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.TermsOfUse" id="termsOfUse" height="100%" xmlns:mvc="sap.ui.core.mvc" xmlns="sap.m"><Page showHeader="false" showSubHeader="false"><Text id="termsOfUseText" renderWhitespace="true" class="sapUiTinyMarginBegin"/></Page></mvc:View>',
	"sap/ui/documentation/sdk/view/Tools.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.Tools" xmlns="sap.m" xmlns:f="sap.f" xmlns:mvc="sap.ui.core.mvc" xmlns:l="sap.ui.layout" xmlns:core="sap.ui.core" xmlns:custom="sap.ui.documentation" xmlns:html="http://www.w3.org/1999/xhtml"><Page showHeader="false" class="sapUiNoContentPadding sapUiDemoApps"><landmarkInfo><PageAccessibleLandmarkInfo contentRole="Main" contentLabel="Tools"/></landmarkInfo><Panel accessibleRole="Region" class="sapUiNoContentPadding" backgroundDesign="Transparent"><l:BlockLayout><l:BlockLayoutRow><l:BlockLayoutCell class="sapUiNoContentPadding sapUiDemokitLandingImageCell toolsImageCell"><Image id="phoneImage" src="./resources/sap/ui/documentation/sdk/images/Tools_S_cropped.png" width="100%" densityAware="false" class="landingImage" load="handleLandingImageLoad" visible="{device&gt;/system/phone}"/><Image src="./resources/sap/ui/documentation/sdk/images/Tools_M_and_L_cropped.png" width="100%" class="landingImage" densityAware="false" load="handleLandingImageLoad" visible="{=!${device&gt;/system/phone}}"/><Text id="landingImageHeadline" visible="false" class="sapUiDocumentationToolsHeaderText" text="Tools" width="100%" textAlign="Left"/></l:BlockLayoutCell></l:BlockLayoutRow></l:BlockLayout></Panel><l:Grid defaultSpan="XL3 L4 M4 S12" class="toolpageResponsiveMargins"><f:Card height="25rem"><f:layoutData><l:GridData spanM="6" spanL="6" spanXL="4"/></f:layoutData><f:content><VBox justifyContent="SpaceBetween"><VBox class="sapUiSmallMargin toolspageCardInfo"><html:div class="sapUIDisclaimerLink sapUiSmallMarginBottom">\n\t\t\t\t\t\t\t\t<custom:TitleLink level="H1" titleStyle="H1" text="UI Theme Designer" href="https://themedesigner-themedesigner.dispatcher.hanatrial.ondemand.com/index.html" target="_blank"/>\n\t\t\t\t\t\t\t\t<Image src="./resources/sap/ui/documentation/sdk/images/link-sap.png" tooltip="{i18n&gt;LEGAL_DISCLAIMER_INTERNAL_TOOLTIP}" width="1.25rem" press="onDisclaimerLinkPress"/>\n\t\t\t\t\t\t\t</html:div><Text class="sapUiSmallMarginBottom" text="{i18n&gt;TOOLS_CARD_2_TEXT}"/><HBox wrap="Wrap"><html:div class="sapUIDisclaimerLink sapUiMediumMarginEnd">\n\t\t\t\t\t\t\t\t\t<Link text="{i18n&gt;TOOLS_VIEW_DOC}" target="_blank" href="https://help.sap.com/viewer/09f6818d8e064537973102d6289e2aca/Cloud/en-US"/>\n\t\t\t\t\t\t\t\t\t<Image src="./resources/sap/ui/documentation/sdk/images/link-sap.png" tooltip="{i18n&gt;LEGAL_DISCLAIMER_INTERNAL_TOOLTIP}" width="1.25rem" press="onDisclaimerLinkPress"/>\n\t\t\t\t\t\t\t\t</html:div><html:div class="sapUIDisclaimerLink">\n\t\t\t\t\t\t\t\t\t<Link text="{i18n&gt;TOOLS_CARD_2_LINK_1}" target="_blank" href="https://www.sap.com/community/topics/ui-theme-designer.html"/>\n\t\t\t\t\t\t\t\t\t<Image src="./resources/sap/ui/documentation/sdk/images/link-sap.png" tooltip="{i18n&gt;LEGAL_DISCLAIMER_INTERNAL_TOOLTIP}" width="1.25rem" press="onDisclaimerLinkPress"/>\n\t\t\t\t\t\t\t\t</html:div></HBox></VBox><Image src="./resources/sap/ui/documentation/sdk/images/tools/ThemeDesigner.png" class="toolsPageImage" alt="{i18n&gt;TOOLS_CARD_2_IMG_ALT}"/></VBox></f:content></f:Card><f:Card height="25rem"><f:layoutData><l:GridData spanM="6" spanL="6" spanXL="4"/></f:layoutData><f:content><VBox justifyContent="SpaceBetween"><VBox class="sapUiSmallMargin toolspageCardInfo"><html:div class="sapUIDisclaimerLink sapUiSmallMarginBottom">\n\t\t\t\t\t\t\t\t<custom:TitleLink level="H1" titleStyle="H1" text="Business Application Studio" href="http://www.sap.com/appstudio" target="_blank"/>\n\t\t\t\t\t\t\t\t<Image src="./resources/sap/ui/documentation/sdk/images/link-sap.png" tooltip="{i18n&gt;LEGAL_DISCLAIMER_INTERNAL_TOOLTIP}" width="1.25rem" press="onDisclaimerLinkPress"/>\n\t\t\t\t\t\t\t</html:div><Text class="sapUiSmallMarginBottom" text="{i18n&gt;TOOLS_CARD_9_TEXT}"/><HBox wrap="Wrap"><html:div class="sapUIDisclaimerLink sapUiMediumMarginEnd">\n\t\t\t\t\t\t\t\t\t<Link text="{i18n&gt;TOOLS_VIEW_DOC}" target="_blank" href="https://help.sap.com/viewer/product/SAP%20Business%20Application%20Studio/Cloud/en-US"/>\n\t\t\t\t\t\t\t\t\t<Image src="./resources/sap/ui/documentation/sdk/images/link-sap.png" tooltip="{i18n&gt;LEGAL_DISCLAIMER_INTERNAL_TOOLTIP}" width="1.25rem" press="onDisclaimerLinkPress"/>\n\t\t\t\t\t\t\t\t</html:div></HBox></VBox><Image src="./resources/sap/ui/documentation/sdk/images/tools/BusinessApplicationStudio.jpg" class="toolsPageImage" alt="{i18n&gt;TOOLS_CARD_9_IMG_ALT}"/></VBox></f:content></f:Card><f:Card class="threeColumnLayoutCard"><f:layoutData><l:GridData spanXL="4"/></f:layoutData><f:content><VBox justifyContent="SpaceBetween"><VBox class="sapUiSmallMargin toolspageCardInfo"><html:div class="sapUIDisclaimerLink sapUiSmallMarginBottom">\n\t\t\t\t\t\t\t\t<custom:TitleLink level="H1" titleStyle="H1" text="UI5 Tooling" href="https://github.com/SAP/ui5-tooling" target="_blank"/>\n\t\t\t\t\t\t\t\t<Image src="./resources/sap/ui/documentation/sdk/images/link-external.png" tooltip="{i18n&gt;LEGAL_DISCLAIMER_EXTERNAL_TOOLTIP}" width="1.25rem" press="onDisclaimerLinkPress"/>\n\t\t\t\t\t\t\t</html:div><Text class="sapUiSmallMarginBottom" text="{i18n&gt;TOOLS_CARD_3_TEXT}"/><HBox wrap="Wrap"><html:div class="sapUIDisclaimerLink sapUiMediumMarginEnd">\n\t\t\t\t\t\t\t\t\t<Link text="{i18n&gt;TOOLS_CARD_3_LINK_1}" target="_blank" href="https://github.com/SAP/ui5-tooling#ui5-build-and-development-tooling"/>\n\t\t\t\t\t\t\t\t\t<Image src="./resources/sap/ui/documentation/sdk/images/link-external.png" tooltip="{i18n&gt;LEGAL_DISCLAIMER_EXTERNAL_TOOLTIP}" width="1.25rem" press="onDisclaimerLinkPress"/>\n\t\t\t\t\t\t\t\t</html:div><html:div class="sapUIDisclaimerLink">\n\t\t\t\t\t\t\t\t\t<Link text="{i18n&gt;TOOLS_CARD_3_LINK_2}" target="_blank" href="https://github.com/SAP/ui5-cli#cli-usage"/>\n\t\t\t\t\t\t\t\t\t<Image src="./resources/sap/ui/documentation/sdk/images/link-external.png" tooltip="{i18n&gt;LEGAL_DISCLAIMER_EXTERNAL_TOOLTIP}" width="1.25rem" press="onDisclaimerLinkPress"/>\n\t\t\t\t\t\t\t\t</html:div></HBox></VBox><Image src="./resources/sap/ui/documentation/sdk/images/tools/UI5EvoTooling.png" class="toolsPageImage" alt="{i18n&gt;TOOLS_CARD_3_IMG_ALT}"/></VBox></f:content></f:Card><f:Card class="threeColumnLayoutCard"><f:content><VBox justifyContent="SpaceBetween"><VBox class="sapUiSmallMargin toolspageCardInfo"><html:div class="sapUIDisclaimerLink sapUiSmallMarginBottom">\n\t\t\t\t\t\t\t\t<custom:TitleLink level="H1" titleStyle="H1" text="UI5 Inspector" href="https://chrome.google.com/webstore/detail/ui5-inspector/bebecogbafbighhaildooiibipcnbngo?hl=en" target="_blank"/>\n\t\t\t\t\t\t\t\t<Image src="./resources/sap/ui/documentation/sdk/images/link-external.png" tooltip="{i18n&gt;LEGAL_DISCLAIMER_EXTERNAL_TOOLTIP}" width="1.25rem" press="onDisclaimerLinkPress"/>\n\t\t\t\t\t\t\t</html:div><Text class="sapUiSmallMarginBottom" text="{i18n&gt;TOOLS_CARD_4_TEXT}"/><HBox wrap="Wrap"><Link text="{i18n&gt;TOOLS_VIEW_DOC}" class="sapUiMediumMarginEnd" target="_blank" href="{path:\'newWindowLinks&gt;/inspectorHomeLink\',formatter:\'.formatter.formatHttpHrefForNewWindow\'}"/><html:div class="sapUIDisclaimerLink">\n\t\t\t\t\t\t\t\t\t<Link text="{i18n&gt;TOOLS_CARD_4_LINK_1}" target="_blank" href="https://github.com/SAP/ui5-inspector"/>\n\t\t\t\t\t\t\t\t\t<Image src="./resources/sap/ui/documentation/sdk/images/link-external.png" tooltip="{i18n&gt;LEGAL_DISCLAIMER_EXTERNAL_TOOLTIP}" width="1.25rem" press="onDisclaimerLinkPress"/>\n\t\t\t\t\t\t\t\t</html:div></HBox></VBox><Image src="./resources/sap/ui/documentation/sdk/images/tools/UI5Inspector.png" class="toolsPageImage" alt="{i18n&gt;TOOLS_CARD_4_IMG_ALT}"/></VBox></f:content></f:Card><f:Card class="threeColumnLayoutCard"><f:content><VBox justifyContent="SpaceBetween"><VBox class="sapUiSmallMargin toolspageCardInfo"><custom:TitleLink level="H1" titleStyle="H1" text="Card Explorer" href="test-resources/sap/ui/integration/demokit/cardExplorer/index.html" target="_blank" class="sapUiSmallMarginBottom"/><Text class="sapUiSmallMarginBottom" text="{i18n&gt;TOOLS_CARD_5_TEXT}"/><HBox wrap="Wrap"><Link text="{i18n&gt;TOOLS_VIEW_DOC}" target="_blank" href="test-resources/sap/ui/integration/demokit/cardExplorer/webapp/index.html" class="sapUiMediumMarginEnd"/><Link text="{i18n&gt;TOOLS_CARD_5_LINK_1}" target="_blank" href="test-resources/sap/ui/integration/demokit/cardExplorer/webapp/index.html#/explore/list"/></HBox></VBox><Image src="./resources/sap/ui/documentation/sdk/images/tools/CardExplorer.png" class="toolsPageImage"/></VBox></f:content></f:Card><f:Card height="25rem"><f:layoutData><l:GridData spanM="6" spanL="6"/></f:layoutData><f:content><VBox justifyContent="SpaceBetween"><VBox class="sapUiSmallMargin toolspageCardInfo"><custom:TitleLink level="H1" titleStyle="H1" text="Support Assistant" class="sapUiSmallMarginBottom" href="{path:\'newWindowLinks&gt;/supportAssistantHomeLink\',formatter:\'.formatter.formatHttpHrefForNewWindow\'}" target="_blank"/><Text class="sapUiSmallMarginBottom" text="{i18n&gt;TOOLS_CARD_6_TEXT}"/><HBox wrap="Wrap"><Link text="{i18n&gt;TOOLS_VIEW_DOC}" target="_blank" href="{path:\'newWindowLinks&gt;/supportAssistantHomeLink\',formatter:\'.formatter.formatHttpHrefForNewWindow\'}"/></HBox></VBox><Image src="./resources/sap/ui/documentation/sdk/images/tools/SupportAssistant.png" class="toolsPageImage" alt="{i18n&gt;TOOLS_CARD_6_IMG_ALT}"/></VBox></f:content></f:Card><f:Card height="25rem"><f:layoutData><l:GridData spanM="6" spanL="6"/></f:layoutData><f:content><VBox justifyContent="SpaceBetween"><VBox class="sapUiSmallMargin toolspageCardInfo"><custom:TitleLink level="H1" titleStyle="H1" text="Icon Explorer" href="test-resources/sap/m/demokit/iconExplorer/webapp/index.html" target="_blank" class="sapUiSmallMarginBottom"/><Text class="sapUiSmallMarginBottom" text="{i18n&gt;TOOLS_CARD_7_TEXT}"/><HBox wrap="Wrap"><Link text="{i18n&gt;TOOLS_VIEW_DOC}" target="_blank" href="{path:\'newWindowLinks&gt;/iconExplorerHomeLink\',formatter:\'.formatter.formatHttpHrefForNewWindow\'}" class="sapUiMediumMarginEnd"/><Link text="{i18n&gt;TOOLS_CARD_7_LINK_1}" target="_blank" href="test-resources/sap/m/demokit/iconExplorer/webapp/test/integration/opaTests1.qunit.html" class="sapUiMediumMarginEnd"/><Link text="{i18n&gt;TOOLS_CARD_7_LINK_2}" target="_blank" href="test-resources/sap/m/demokit/iconExplorer/webapp/test/unit/unitTests.qunit.html"/></HBox></VBox><Image src="./resources/sap/ui/documentation/sdk/images/tools/IconExplorer.png" class="toolsPageImage" alt="{i18n&gt;TOOLS_CARD_7_IMG_ALT}"/></VBox></f:content></f:Card><f:Card class="threeColumnLayoutCard"><f:layoutData><l:GridData spanXL="4"/></f:layoutData><f:content><VBox justifyContent="SpaceBetween"><VBox class="sapUiSmallMargin toolspageCardInfo"><html:div class="sapUIDisclaimerLink sapUiSmallMarginBottom">\n\t\t\t\t\t\t\t\t<custom:TitleLink level="H1" titleStyle="H1" text="SAP Web IDE" href="https://sdk-sapwebide.dispatcher.hana.ondemand.com/index.html" target="_blank"/>\n\t\t\t\t\t\t\t\t<Image src="./resources/sap/ui/documentation/sdk/images/link-sap.png" tooltip="{i18n&gt;LEGAL_DISCLAIMER_INTERNAL_TOOLTIP}" width="1.25rem" press="onDisclaimerLinkPress"/>\n\t\t\t\t\t\t\t</html:div><Text class="sapUiSmallMarginBottom" text="{i18n&gt;TOOLS_CARD_1_TEXT}"/><HBox wrap="Wrap"><html:div class="sapUIDisclaimerLink sapUiMediumMarginEnd">\n\t\t\t\t\t\t\t\t\t<Link text="{i18n&gt;TOOLS_VIEW_DOC}" target="_blank" href="https://help.sap.com/viewer/825270ffffe74d9f988a0f0066ad59f0/CF/en-US"/>\n\t\t\t\t\t\t\t\t\t<Image src="./resources/sap/ui/documentation/sdk/images/link-sap.png" tooltip="{i18n&gt;LEGAL_DISCLAIMER_INTERNAL_TOOLTIP}" width="1.25rem" press="onDisclaimerLinkPress"/>\n\t\t\t\t\t\t\t\t</html:div><html:div class="sapUIDisclaimerLink">\n\t\t\t\t\t\t\t\t\t<Link text="{i18n&gt;TOOLS_CARD_1_LINK_1}" target="_blank" href="https://sdk-sapwebide.dispatcher.hana.ondemand.com/index.html"/>\n\t\t\t\t\t\t\t\t\t<Image src="./resources/sap/ui/documentation/sdk/images/link-sap.png" tooltip="{i18n&gt;LEGAL_DISCLAIMER_INTERNAL_TOOLTIP}" width="1.25rem" press="onDisclaimerLinkPress"/>\n\t\t\t\t\t\t\t\t</html:div></HBox></VBox><Image src="./resources/sap/ui/documentation/sdk/images/tools/WebIDE.png" class="toolsPageImage" alt="{i18n&gt;TOOLS_CARD_1_IMG_ALT}"/></VBox></f:content></f:Card><f:Card class="threeColumnLayoutCard"><f:layoutData><l:GridData spanXL="4"/></f:layoutData><f:content><VBox justifyContent="SpaceBetween"><VBox class="sapUiSmallMargin toolspageCardInfo"><custom:TitleLink level="H1" titleStyle="H1" text="Theme Parameter Toolbox" class="sapUiSmallMarginBottom" href="test-resources/sap/m/demokit/theming/webapp/index.html" target="_blank"/><Text class="sapUiSmallMarginBottom" text="{i18n&gt;TOOLS_CARD_8_TEXT}"/></VBox><Image src="./resources/sap/ui/documentation/sdk/images/tools/ThemeParameterToolbox.png" class="toolsPageImage" alt="{i18n&gt;TOOLS_CARD_8_IMG_ALT}"/></VBox></f:content></f:Card><f:Card class="threeColumnLayoutCard"><f:layoutData><l:GridData spanXL="4"/></f:layoutData><f:content><VBox justifyContent="SpaceBetween"><VBox class="sapUiSmallMargin toolspageCardInfo"><html:div class="sapUIDisclaimerLink sapUiSmallMarginBottom">\n\t\t\t\t\t\t\t\t<custom:TitleLink level="H1" titleStyle="H1" text="UI5 Web Components" href="https://sap.github.io/ui5-webcomponents/" target="_blank"/>\n\t\t\t\t\t\t\t\t<Image src="./resources/sap/ui/documentation/sdk/images/link-sap.png" tooltip="{i18n&gt;LEGAL_DISCLAIMER_INTERNAL_TOOLTIP}" width="1.25rem" press="onDisclaimerLinkPress"/>\n\t\t\t\t\t\t\t</html:div><Text class="sapUiSmallMarginBottom" text="{i18n&gt;TOOLS_CARD_10_TEXT}"/><HBox wrap="Wrap"><html:div class="sapUIDisclaimerLink sapUiMediumMarginEnd">\n\t\t\t\t\t\t\t\t\t<Link text="{i18n&gt;TOOLS_CARD_10_LINK_1}" target="_blank" href="https://sap.github.io/ui5-webcomponents/playground"/>\n\t\t\t\t\t\t\t\t\t<Image src="./resources/sap/ui/documentation/sdk/images/link-sap.png" tooltip="{i18n&gt;LEGAL_DISCLAIMER_INTERNAL_TOOLTIP}" width="1.25rem" press="onDisclaimerLinkPress"/>\n\t\t\t\t\t\t\t\t</html:div><html:div class="sapUIDisclaimerLink">\n\t\t\t\t\t\t\t\t\t<Link text="{i18n&gt;TOOLS_CARD_10_LINK_2}" target="_blank" href="https://github.com/SAP/ui5-webcomponents"/>\n\t\t\t\t\t\t\t\t\t<Image src="./resources/sap/ui/documentation/sdk/images/link-sap.png" tooltip="{i18n&gt;LEGAL_DISCLAIMER_INTERNAL_TOOLTIP}" width="1.25rem" press="onDisclaimerLinkPress"/>\n\t\t\t\t\t\t\t\t</html:div></HBox></VBox><Image src="./resources/sap/ui/documentation/sdk/images/tools/UI5WebComponents.png" class="toolsPageImage" alt="{i18n&gt;TOOLS_CARD_10_IMG_ALT}"/></VBox></f:content></f:Card></l:Grid><l:BlockLayout><l:BlockLayoutRow><core:Fragment id="footerFragment" fragmentName="sap.ui.documentation.sdk.view.Footer" type="XML"/></l:BlockLayoutRow></l:BlockLayout></Page></mvc:View>',
	"sap/ui/documentation/sdk/view/TopicDetail.view.xml":'<mvc:View height="100%" controllerName="sap.ui.documentation.sdk.controller.TopicDetail" id="sap.ui.documentation.sdk.controller.TopicDetail" xmlns="sap.f" xmlns:m="sap.m" xmlns:l="sap.ui.layout" xmlns:mvc="sap.ui.core.mvc" xmlns:core="sap.ui.core"><DynamicPage id="topicDetailPage" preserveHeaderStateOnScroll="true" toggleHeaderOnTitleClick="{=${/bIsPhone} ? true : false}" fitContent="true"><title><DynamicPageTitle class="sapUiDocumentationDynamicPageTitle"><heading><m:Text text="{/topictitle1}" class="sapUiDocumentationTopicTitle" wrapping="true"/></heading><actions><m:Button id="topicDetailBackToSearch" text="{i18n&gt;TOPIC_DETAIL_BACK_BTN}" type="Transparent" press="backToSearch" visible="false"/><m:Button visible="{= ${versionData&gt;/isOpenUI5}}" icon="sap-icon://edit" type="Transparent" text="{i18n&gt;TOPIC_DETAIL_EDIT_GITHUB}" tooltip="{i18n&gt;TOPIC_DETAIL_EDIT_GITHUB_TOOLTIP}" press="onEditGitHubPress"/><m:Button visible="{device&gt;/system/desktop}" icon="sap-icon://full-screen" type="Transparent" tooltip="{i18n&gt;TOPIC_DETAIL_FULLSCREEN_TOOLTIP}" press="onToggleFullScreen"/></actions></DynamicPageTitle></title><header><DynamicPageHeader pinnable="fale"><content><m:Text text="{/shortdesc}"/></content></DynamicPageHeader></header><content><l:HorizontalLayout id="staticContentLayout" class="topicWrapper"><core:HTML id="staticContent" preferDOM="false"/></l:HorizontalLayout></content></DynamicPage></mvc:View>',
	"sap/ui/documentation/sdk/view/TopicDetailInitial.view.xml":'<mvc:View height="100%" width="100%" controllerName="sap.ui.documentation.sdk.controller.TopicDetailInitial" xmlns="sap.m" xmlns:l="sap.ui.layout" xmlns:mvc="sap.ui.core.mvc" xmlns:core="sap.ui.core" xmlns:custom="sap.ui.documentation"><Page id="topicDetailPage" showHeader="false" class="sapUiNoContentPadding sapUiDemoApps"><landmarkInfo><PageAccessibleLandmarkInfo contentRole="Main" contentLabel="Documentation"/></landmarkInfo><Panel accessibleRole="Region" class="sapUiNoContentPadding" backgroundDesign="Transparent"><l:BlockLayout><l:BlockLayoutRow><l:BlockLayoutCell class="sapUiNoContentPadding sapUiDemokitLandingImageCell sapUiNoContentPadding"><Image id="phoneImage" src="./resources/sap/ui/documentation/sdk/images/Docu_S_cropped_1.jpg" width="100%" densityAware="false" class="landingImage" load="handleLandingImageLoad" visible="{device&gt;/system/phone}"/><Image src="./resources/sap/ui/documentation/sdk/images/Docu_M_and_L_cropped_1.jpg" width="100%" densityAware="false" class="landingImage" load="handleLandingImageLoad" visible="{=!${device&gt;/system/phone}}"/><l:VerticalLayout id="landingImageHeadline" class="sapUiDocumentationDocumentationHeading" visible="false" width="100%"><Text text="{i18n&gt;TOPIC_DETAIL_INIT_DOCUMENTATION}" width="100%" textAlign="Left"/><l:HorizontalLayout><Button class="actionButton" text="{i18n&gt;TOPIC_DETAIL_INIT_DOWNLOAD_BTN}" type="Emphasized" press="onDownloadButtonPress"/><Button class="actionButton sapUiSmallMarginBegin" visible="{= ${versionData&gt;/isOpenUI5}}" text="GitHub" type="Emphasized" press="onGitHubButtonPress"/></l:HorizontalLayout></l:VerticalLayout></l:BlockLayoutCell></l:BlockLayoutRow></l:BlockLayout></Panel><Panel accessibleRole="Region" class="sapUiNoContentPadding" backgroundDesign="Transparent"><l:BlockLayout><l:BlockLayoutRow id="disclaimerBlock" visible="false"><l:BlockLayoutCell backgroundColorSet="ColorSet9" backgroundColorShade="ShadeA"><MessageStrip id="disclaimerMessage" showIcon="true"/></l:BlockLayoutCell></l:BlockLayoutRow><l:BlockLayoutRow class="sapUiContentPadding"><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeA"><l:VerticalLayout width="100%"><custom:TitleLink width="100%" text="{i18n&gt;TOPIC_DETAIL_INIT_BLOCK_1_TITLE}" href="topic/99ac68a5b1c3416ab5c84c99fefa250d" titleStyle="H1"/><Text text="{i18n&gt;TOPIC_DETAIL_INIT_BLOCK_1_TEXT}"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeB"><l:VerticalLayout width="100%"><custom:TitleLink width="100%" text="{i18n&gt;TOPIC_DETAIL_INIT_BLOCK_2_TITLE}" href="topic/167193ced54c41c3961d7df3479d7bbe" titleStyle="H1"/><Text text="{i18n&gt;TOPIC_DETAIL_INIT_BLOCK_2_TEXT}"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell width="2" class="largeCell" backgroundColorSet="ColorSet6" backgroundColorShade="ShadeF"><l:VerticalLayout width="100%"><custom:TitleLink width="100%" text="{i18n&gt;TOPIC_DETAIL_INIT_BLOCK_3_TITLE}" href="topic/8b49fc198bf04b2d9800fc37fecbb218" class="demokitInitialPagesWhiteText" titleStyle="H1"/><Text text="{i18n&gt;TOPIC_DETAIL_INIT_BLOCK_3_TEXT}" class="demokitInitialPagesWhiteText"/></l:VerticalLayout></l:BlockLayoutCell></l:BlockLayoutRow><l:BlockLayoutRow><l:BlockLayoutCell width="2" class="largeCell" backgroundColorSet="ColorSet6" backgroundColorShade="ShadeE"><l:VerticalLayout width="100%"><custom:TitleLink width="100%" text="{i18n&gt;TOPIC_DETAIL_INIT_BLOCK_4_TITLE}" href="topic/23cfd955f58142389fa7c9097e11559c" class="demokitInitialPagesWhiteText" titleStyle="H1"/><Text text="{i18n&gt;TOPIC_DETAIL_INIT_BLOCK_4_TEXT}" class="demokitInitialPagesWhiteText"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeB"><l:VerticalLayout width="100%"><custom:TitleLink width="100%" text="{i18n&gt;TOPIC_DETAIL_INIT_BLOCK_5_TITLE}" href="topic/a264a9abf98d4caabbf9b027bc1005d8" titleStyle="H1"/><Text text="{i18n&gt;TOPIC_DETAIL_INIT_BLOCK_5_TEXT}"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeA"><l:VerticalLayout width="100%"><custom:TitleLink width="100%" text="{i18n&gt;TOPIC_DETAIL_INIT_BLOCK_6_TITLE}" href="topic/8dcab0011d274051808f959800cabf9f" titleStyle="H1"/><Text text="{i18n&gt;TOPIC_DETAIL_INIT_BLOCK_6_TEXT}"/></l:VerticalLayout></l:BlockLayoutCell></l:BlockLayoutRow><l:BlockLayoutRow><l:BlockLayoutCell class="largeCell demokitInitialPagesColorPatternA" backgroundColorSet="ColorSet9" backgroundColorShade="ShadeA" visible="{=!${versionData&gt;/isOpenUI5}}"><l:VerticalLayout width="100%"><custom:TitleLink width="100%" text="SAP Fiori Elements" href="topic/03265b0408e2432c9571d6b3feb6b1fd" titleStyle="H1"/><Text text="{i18n&gt;TOPIC_DETAIL_INIT_BLOCK_7_TEXT}"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="largeCell demokitInitialPagesColorPatternC" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeB" visible="{=!${versionData&gt;/isOpenUI5}}"><l:VerticalLayout width="100%"><custom:TitleLink width="100%" text="{i18n&gt;TOPIC_DETAIL_INIT_BLOCK_8_TITLE}" href="topic/1c457c53595a6655e10000000a423f68" titleStyle="H1"/><Text text="{i18n&gt;TOPIC_DETAIL_INIT_BLOCK_8_TEXT}"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet6" backgroundColorShade="ShadeF"><l:VerticalLayout width="100%"><custom:TitleLink width="100%" text="{i18n&gt;TOPIC_DETAIL_INIT_BLOCK_9_TITLE}" href="topic/ec699e0817fb46a0817b0fa276a249f8" class="demokitInitialPagesWhiteText" titleStyle="H1"/><Text text="{i18n&gt;TOPIC_DETAIL_INIT_BLOCK_9_TEXT}" class="demokitInitialPagesWhiteText"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="largeCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeC"><l:VerticalLayout width="100%"><custom:TitleLink width="100%" text="{i18n&gt;TOPIC_DETAIL_INIT_BLOCK_10_TITLE}" href="topic/3ec6808ff0f34a75a9f40748cf9989b9" titleStyle="H1"/><Text text="{i18n&gt;TOPIC_DETAIL_INIT_BLOCK_10_TEXT}"/></l:VerticalLayout></l:BlockLayoutCell></l:BlockLayoutRow></l:BlockLayout></Panel><l:BlockLayout><l:BlockLayoutRow><core:Fragment id="footerFragment" fragmentName="sap.ui.documentation.sdk.view.Footer" type="XML"/></l:BlockLayoutRow></l:BlockLayout></Page></mvc:View>',
	"sap/ui/documentation/sdk/view/TopicMaster.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.TopicMaster" xmlns:mvc="sap.ui.core.mvc" xmlns="sap.m" xmlns:custom="sap.ui.documentation" class="sapContrast sapContrastPlus"><Page id="page" enableScrolling="true" showFooter="false" navButtonPress="onNavBack" showNavButton="false" class="sapUiDocumentationMasterPage"><customHeader><Toolbar width="100%"><SearchField id="searchField" placeholder="{i18n&gt;TOPIC_MASTER_FILTER_PLACEHOLDER}" liveChange="onTreeFilter" class="sapUiDocumentationFilterField"/><Button icon="sap-icon://expand-all" press="onTreeExpandAll" tooltip="{i18n&gt;TOPIC_MASTER_EXPAND_TOOLTIP}"/><Button icon="sap-icon://collapse-all" press="onTreeCollapseAll" tooltip="{i18n&gt;TOPIC_MASTER_COLAPSE_TOOLTIP}"/></Toolbar></customHeader><content><Tree id="tree" mode="SingleSelectMaster" selectionChange="onNodeSelect" noDataText="{i18n&gt;TOPIC_MASTER_NO_DATA_TEXT}" items="{path:\'/\'}"><custom:DemokitTreeItem title="{text}" target="{key}" section="topic" selected="{isSelected}"/></Tree></content></Page></mvc:View>',
	"sap/ui/documentation/sdk/view/VersionInfo.view.xml":'<mvc:View id="versionInfo" height="100%" xmlns:mvc="sap.ui.core.mvc" xmlns:core="sap.ui.core"><core:HTML id="testHTML" preferDOM="false" content="&lt;div style=&quot;height:100%; overflow-x:auto;&quot;&gt;&lt;iframe style=&quot;width:100%;height:99%;&quot; name=&quot;content&quot; src=&quot;versioninfo.html&quot; frameborder=&quot;0&quot;&quot;&gt;&lt;/iframe&gt;&lt;/div&gt;"/></mvc:View>',
	"sap/ui/documentation/sdk/view/Welcome.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.Welcome" xmlns="sap.m" xmlns:l="sap.ui.layout" xmlns:core="sap.ui.core" xmlns:mvc="sap.ui.core.mvc" xmlns:custom="sap.ui.documentation" xmlns:html="http://www.w3.org/1999/xhtml"><Page showHeader="false" class="sapUiHomePage"><landmarkInfo><PageAccessibleLandmarkInfo contentRole="Main" contentLabel="Get Started with UI5"/></landmarkInfo><Panel accessibleRole="Region" class="sapUiNoContentPadding" backgroundDesign="Transparent"><l:BlockLayout><l:BlockLayoutRow><l:BlockLayoutCell class="sapUiNoContentPadding sapUiDemokitLandingImageCell welcomeImageCell"><Image id="phoneImage" src="./resources/sap/ui/documentation/sdk/images/Home_S_cropped_1.jpg" width="100%" class="welcomeImage" densityAware="false" load="handleLandingImageLoad" visible="{device&gt;/system/phone}"/><Image src="./resources/sap/ui/documentation/sdk/images/Home_M_and_L_cropped_1.jpg" width="100%" densityAware="false" class="welcomeImage" load="handleLandingImageLoad" visible="{=!${device&gt;/system/phone}}"/><l:VerticalLayout id="landingImageHeadline" visible="false" width="100%" class="welcomeImageTextLayout"><Text class="welcomeImageTextHeadline" text="{i18n&gt;WELCOME_BLOCK_1_TEXT_1}" width="100%" textAlign="Center"/><l:HorizontalLayout><Button text="{i18n&gt;WELCOME_BLOCK_1_START_BTN}" type="Emphasized" press="onGetStarted" class="actionButton"/><Button class="actionButton sapContrast sapContrastPlus sapUiSmallMarginBegin" visible="{=${welcomeView&gt;/isOpenUI5} !== undefined}" id="readMoreButton" text="{i18n&gt;WELCOME_BLOCK_1_DOWNLOAD_BTN}" press="onDownloadButtonPress"/></l:HorizontalLayout></l:VerticalLayout></l:BlockLayoutCell></l:BlockLayoutRow></l:BlockLayout></Panel><Panel accessibleRole="Region" backgroundDesign="Transparent" class="sapUiNoContentPadding"><headerToolbar><Toolbar class="headlineCell"><Title width="100%" text="{i18n&gt;WELCOME_KEY_FEATURES}" level="H1" titleStyle="H1" class="sapUiMediumMarginTopBottom"/></Toolbar></headerToolbar><l:BlockLayout><l:BlockLayoutRow><l:BlockLayoutCell backgroundColorSet="ColorSet11" backgroundColorShade="ShadeF"><l:Grid defaultSpan="L6 M12 S12" hSpacing="0" vSpacing="0"><l:VerticalLayout width="100%"><custom:TitleLink href="topic/50eadaac8d2e49ee8996dc2b560cb76b" text="{i18n&gt;WELCOME_BLOCK_2_TITLE}" titleStyle="H2" class="demokitInitialPagesWhiteText sapUiSmallMarginBottom"/><Text text="{i18n&gt;WELCOME_BLOCK_2_TEXT}" class="demokitInitialPagesWhiteText"/></l:VerticalLayout><Image src="./resources/sap/ui/documentation/sdk/images/Fiori_guidelines_image.png" alt="{i18n&gt;WELCOME_BLOCK_2_IMG_ALT}" densityAware="false" width="100%"><layoutData><l:GridData span="L6 M12 S12"/></layoutData></Image></l:Grid></l:BlockLayoutCell><l:BlockLayoutCell backgroundColorSet="ColorSet11" backgroundColorShade="ShadeD"><l:VerticalLayout width="100%"><custom:TitleLink text="{i18n&gt;WELCOME_BLOCK_3_TITLE}" href="topic/ec699e0817fb46a0817b0fa276a249f8" class="sapUiSmallMarginBottom" titleStyle="H2"/><Text text="{i18n&gt;WELCOME_BLOCK_3_TEXT_1}" class="sapUiSmallMarginBottom"/><HBox><core:Icon src="sap-icon://accept" size="0.875rem" color="Default" class="sapUiTinyMarginBegin sapUiSmallMarginEnd"/><Text text="{i18n&gt;WELCOME_BLOCK_3_TEXT_2}"/></HBox><HBox><core:Icon src="sap-icon://accept" size="0.875rem" color="Default" class="sapUiTinyMarginBegin sapUiSmallMarginEnd"/><Text text="{i18n&gt;WELCOME_BLOCK_3_TEXT_3}"/></HBox><HBox><core:Icon src="sap-icon://accept" size="0.875rem" color="Default" class="sapUiTinyMarginBegin sapUiSmallMarginEnd"/><Text text="{i18n&gt;WELCOME_BLOCK_3_TEXT_4}"/></HBox><HBox><core:Icon src="sap-icon://accept" size="0.875rem" color="Default" class="sapUiTinyMarginBegin sapUiSmallMarginEnd"/><Text text="{i18n&gt;WELCOME_BLOCK_3_TEXT_5}"/></HBox></l:VerticalLayout></l:BlockLayoutCell></l:BlockLayoutRow><l:BlockLayoutRow><l:BlockLayoutCell backgroundColorSet="ColorSet11" backgroundColorShade="ShadeB"><l:VerticalLayout width="100%"><custom:TitleLink href="topic/23cfd955f58142389fa7c9097e11559c" text="{i18n&gt;WELCOME_BLOCK_4_TITLE}" class="sapUiSmallMarginBottom" titleStyle="H2"/><Text text="{i18n&gt;WELCOME_BLOCK_4_TEXT_1}" class="sapUiSmallMarginBottom"/><HBox><core:Icon src="sap-icon://accept" size="0.875rem" color="Default" class="sapUiTinyMarginBegin sapUiSmallMarginEnd"/><Text text="{i18n&gt;WELCOME_BLOCK_4_TEXT_2}"/></HBox><HBox><core:Icon src="sap-icon://accept" size="0.875rem" color="Default" class="sapUiTinyMarginBegin sapUiSmallMarginEnd"/><Text text="{i18n&gt;WELCOME_BLOCK_4_TEXT_3}"/></HBox><HBox><core:Icon src="sap-icon://accept" size="0.875rem" color="Default" class="sapUiTinyMarginBegin sapUiSmallMarginEnd"/><Text text="{i18n&gt;WELCOME_BLOCK_4_TEXT_4}"/></HBox></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell backgroundColorSet="ColorSet11" backgroundColorShade="ShadeA"><l:Grid defaultSpan="L6 M12 S12" hSpacing="0" vSpacing="0"><l:VerticalLayout width="100%"><html:div class="sapUIDisclaimerLink sapUiSmallMarginBottom">\n\t\t\t\t\t\t\t\t\t<custom:TitleLink href="https://experience.sap.com/fiori-design/" text="{i18n&gt;WELCOME_BLOCK_5_TITLE}" titleStyle="H2" target="_blank"/>\n\t\t\t\t\t\t\t\t\t<Image src="./resources/sap/ui/documentation/sdk/images/sap.png" tooltip="{i18n&gt;LEGAL_DISCLAIMER_EXTERNAL_TOOLTIP}" width="1.25rem" press="onDisclaimerLinkPress"/>\n\t\t\t\t\t\t\t\t</html:div><Text text="{i18n&gt;WELCOME_BLOCK_5_TEXT}" class="sapUiSmallMarginBottom"/></l:VerticalLayout><Image src="./resources/sap/ui/documentation/sdk/images/Fiori_design_examples.png" alt="{i18n&gt;WELCOME_BLOCK_5_IMG_ALT}" densityAware="false" width="100%"><layoutData><l:GridData span="L6 M12 S12"/></layoutData></Image></l:Grid></l:BlockLayoutCell></l:BlockLayoutRow></l:BlockLayout></Panel><Panel visible="{=! (${device&gt;/system/phone} || ${device&gt;/browser/msie}) }" accessibleRole="Region" backgroundDesign="Transparent" class="sapUiNoContentPadding"><headerToolbar><Toolbar class="headlineCell"><Title width="100%" text="{i18n&gt;WELCOME_START_CODING}" level="H1" titleStyle="H1" class="sapUiMediumMarginTopBottom"/></Toolbar></headerToolbar><l:BlockLayout><l:BlockLayoutRow><l:BlockLayoutCell class="welcomeBlock" backgroundColorSet="ColorSet6" backgroundColorShade="ShadeC" width="1"><custom:TitleLink href="topic/8b49fc198bf04b2d9800fc37fecbb218" text="{i18n&gt;WELCOME_BLOCK_6_TITLE}" titleStyle="H2"/><Text class="sapUiMediumMarginTop" text="{i18n&gt;WELCOME_BLOCK_6_TEXT_1}"/><Text class="sapUiSmallMarginTop" text="{i18n&gt;WELCOME_BLOCK_6_TEXT_2}"/></l:BlockLayoutCell><l:BlockLayoutCell backgroundColorSet="ColorSet6" backgroundColorShade="ShadeC"><l:layoutData><l:BlockLayoutCellData sSize="1" mSize="2" lSize="3" xlSize="3"/></l:layoutData><mvc:XMLView viewName="sap.ui.documentation.sdk.view.LiveEditor"/></l:BlockLayoutCell></l:BlockLayoutRow></l:BlockLayout></Panel><Panel accessibleRole="Region" backgroundDesign="Transparent" class="sapUiNoContentPadding"><headerToolbar><Toolbar class="headlineCell"><Title width="100%" text="{i18n&gt;WELCOME_BLOCK_7_TITLE}" level="H1" titleStyle="H1" class="sapUiMediumMarginTopBottom"/></Toolbar></headerToolbar><l:BlockLayout><l:BlockLayoutRow><l:BlockLayoutCell backgroundColorSet="ColorSet11" backgroundColorShade="ShadeA"><l:VerticalLayout width="100%"><custom:TitleLink href="topic/28fcd55b04654977b63dacbee0552712" text="{i18n&gt;WELCOME_BLOCK_7_TITLE}" class="sapUiSmallMarginBottom" titleStyle="H2"/><Text text="{i18n&gt;WELCOME_BLOCK_7_TEXT_1}" class="sapUiSmallMarginBottom"/><Text text="{i18n&gt;WELCOME_BLOCK_7_TEXT_2}"/></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell backgroundColorSet="ColorSet11" backgroundColorShade="ShadeA"><HBox alignItems="Center" justifyContent="Center" width="100%" height="100%"><Image src="./resources/sap/ui/documentation/sdk/images/Evolution_demokit_illustration_single.png" densityAware="false" class="sapUiTinyMarginBeginEnd" width="100%" alt="{i18n&gt;WELCOME_BLOCK_7_ALT}"><layoutData><FlexItemData maxWidth="37.5rem"/></layoutData></Image></HBox></l:BlockLayoutCell></l:BlockLayoutRow></l:BlockLayout></Panel><Panel accessibleRole="Region" backgroundDesign="Transparent" class="sapUiNoContentPadding"><headerToolbar><Toolbar class="headlineCell"><Title width="100%" text="{i18n&gt;WELCOME_CHOOSE_SCENARIO}" level="H1" titleStyle="H1" class="sapUiMediumMarginTopBottom"/></Toolbar></headerToolbar><l:BlockLayout><l:BlockLayoutRow><l:BlockLayoutCell backgroundColorSet="ColorSet11" backgroundColorShade="ShadeD"><l:VerticalLayout width="100%"><html:div class="sapUIDisclaimerLink sapUiSmallMarginBottom">\n\t\t\t\t\t\t\t\t<custom:TitleLink href="https://www.sap.com/developer/tutorials/hcp-create-trial-account.html" text="{i18n&gt;WELCOME_BLOCK_8_TITLE}" titleStyle="H2" target="_blank"/>\n\t\t\t\t\t\t\t\t<Image src="./resources/sap/ui/documentation/sdk/images/link-sap.png" tooltip="{i18n&gt;LEGAL_DISCLAIMER_INTERNAL_TOOLTIP}" width="1.25rem" press="onDisclaimerLinkPress"/>\n\t\t\t\t\t\t\t</html:div><Text text="{i18n&gt;WELCOME_BLOCK_8_TEXT_1}" class="sapUiSmallMarginBottom"/><HBox><core:Icon src="sap-icon://accept" size="0.875rem" color="Default" class="sapUiTinyMarginBegin sapUiSmallMarginEnd"/><Text text="{i18n&gt;WELCOME_BLOCK_8_TEXT_2}"/></HBox><HBox class="sapUiSmallMarginBottom"><core:Icon src="sap-icon://accept" size="0.875rem" color="Default" class="sapUiTinyMarginBegin sapUiSmallMarginEnd"/><Text text="{i18n&gt;WELCOME_BLOCK_8_TEXT_3}"/></HBox></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell backgroundColorSet="ColorSet11" backgroundColorShade="ShadeB"><l:VerticalLayout width="100%"><html:div class="sapUIDisclaimerLink sapUiSmallMarginBottom">\n\t\t\t\t\t\t\t\t<custom:TitleLink href="https://sapui5.hana.ondemand.com/#/topic/91f346786f4d1014b6dd926db0e91070" target="_blank" text="{i18n&gt;WELCOME_BLOCK_9_TITLE}" titleStyle="H2"/>\n\t\t\t\t\t\t\t\t<Image src="./resources/sap/ui/documentation/sdk/images/link-sap.png" tooltip="{i18n&gt;LEGAL_DISCLAIMER_INTERNAL_TOOLTIP}" width="1.25rem" press="onDisclaimerLinkPress"/>\n\t\t\t\t\t\t\t</html:div><Text text="{i18n&gt;WELCOME_BLOCK_9_TEXT_1}" class="sapUiSmallMarginBottom"/><HBox><core:Icon src="sap-icon://accept" size="0.875rem" color="Default" class="sapUiTinyMarginBegin sapUiSmallMarginEnd"/><Text text="{i18n&gt;WELCOME_BLOCK_9_TEXT_2}"/></HBox><HBox class="sapUiSmallMarginBottom"><core:Icon src="sap-icon://accept" size="0.875rem" color="Default" class="sapUiTinyMarginBegin sapUiSmallMarginEnd"/><Text text="{i18n&gt;WELCOME_BLOCK_9_TEXT_3}"/></HBox></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell backgroundColorSet="ColorSet11" backgroundColorShade="ShadeA"><l:VerticalLayout width="100%"><html:div class="sapUIDisclaimerLink sapUiSmallMarginBottom">\n\t\t\t\t\t\t\t\t<custom:TitleLink href="http://openui5.org" text="{i18n&gt;WELCOME_BLOCK_10_TITLE}" target="_blank" titleStyle="H2"/>\n\t\t\t\t\t\t\t\t<Image src="./resources/sap/ui/documentation/sdk/images/link-sap.png" tooltip="{i18n&gt;LEGAL_DISCLAIMER_INTERNAL_TOOLTIP}" width="1.25rem" press="onDisclaimerLinkPress"/>\n\t\t\t\t\t\t\t</html:div><Text text="{i18n&gt;WELCOME_BLOCK_10_TEXT_1}" class="sapUiSmallMarginBottom"/><HBox><core:Icon src="sap-icon://accept" size="0.875rem" color="Default" class="sapUiTinyMarginBegin sapUiSmallMarginEnd"/><Text text="{i18n&gt;WELCOME_BLOCK_10_TEXT_2}"/></HBox><HBox class="sapUiSmallMarginBottom"><core:Icon src="sap-icon://accept" size="0.875rem" color="Default" class="sapUiTinyMarginBegin sapUiSmallMarginEnd"/><Text text="{i18n&gt;WELCOME_BLOCK_10_TEXT_3}"/></HBox></l:VerticalLayout></l:BlockLayoutCell><l:BlockLayoutCell backgroundColorSet="ColorSet11" backgroundColorShade="ShadeC"><l:VerticalLayout width="100%"><custom:TitleLink href="topic/2d3eb2f322ea4a82983c1c62a33ec4ae" text="{i18n&gt;WELCOME_BLOCK_11_TITLE}" titleStyle="H2" class="sapUiSmallMarginBottom"/><Text text="{i18n&gt;WELCOME_BLOCK_11_TEXT_1}" class="sapUiSmallMarginBottom"/><HBox><core:Icon src="sap-icon://accept" size="0.875rem" color="Default" class="sapUiTinyMarginBegin sapUiSmallMarginEnd"/><Text text="{i18n&gt;WELCOME_BLOCK_11_TEXT_2}"/></HBox><HBox class="sapUiSmallMarginBottom"><core:Icon src="sap-icon://accept" size="0.875rem" color="Default" class="sapUiTinyMarginBegin sapUiSmallMarginEnd"/><Text text="{i18n&gt;WELCOME_BLOCK_11_TEXT_3}"/></HBox></l:VerticalLayout></l:BlockLayoutCell></l:BlockLayoutRow></l:BlockLayout></Panel><Panel accessibleRole="Region" backgroundDesign="Transparent" class="sapUiNoContentPadding"><headerToolbar><Toolbar class="headlineCell"><Title width="100%" text="{i18n&gt;WELCOME_JOIN_COMMUNITY}" level="H1" titleStyle="H1" class="sapUiMediumMarginTopBottom"/></Toolbar></headerToolbar><l:BlockLayout><l:BlockLayoutRow><l:BlockLayoutCell class="sapUiBlockCenteredCell communityLinkCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeA"><l:HorizontalLayout><core:Icon src="sap-icon://collaborate" size="2.5rem" color="Default"/><custom:TitleLink href="https://community.sap.com/topics/ui5" target="_blank" text="{i18n&gt;WELCOME_BLOCK_12_TITLE}" titleStyle="H2" wrap="false" class="sapUiSmallMargin sapUiNoMarginBottom sapUiNoMarginEnd"/><Image src="./resources/sap/ui/documentation/sdk/images/link-sap.png" tooltip="{i18n&gt;LEGAL_DISCLAIMER_INTERNAL_TOOLTIP}" width="1.25rem" class="sapUiDisclaimerCommunityLink" press="onDisclaimerLinkPress"/></l:HorizontalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="sapUiBlockCenteredCell communityLinkCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeB"><l:HorizontalLayout><Image src="./resources/sap/ui/documentation/sdk/images/logo_stackoverflow.png" width="2.5rem" densityAware="false" class="sapUiTinyMarginTop"/><custom:TitleLink href="http://stackoverflow.com/search?q=sapui5" target="_blank" text="StackOverflow" titleStyle="H2" wrap="false" class="sapUiSmallMargin sapUiNoMarginBottom sapUiNoMarginEnd"/><Image src="./resources/sap/ui/documentation/sdk/images/link-external.png" tooltip="{i18n&gt;LEGAL_DISCLAIMER_EXTERNAL_TOOLTIP}" width="1.25rem" class="sapUiDisclaimerCommunityLink" press="onDisclaimerLinkPress"/></l:HorizontalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="sapUiBlockCenteredCell communityLinkCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeC"><l:HorizontalLayout><Image src="./resources/sap/ui/documentation/sdk/images/logo_youtube.png" width="2.5rem" densityAware="false" class="sapUiTinyMarginTop"/><custom:TitleLink href="https://youtube.com/openui5videos" target="_blank" text="YouTube" titleStyle="H2" wrap="false" class="sapUiSmallMargin sapUiNoMarginBottom sapUiNoMarginEnd"/><Image src="./resources/sap/ui/documentation/sdk/images/link-external.png" tooltip="{i18n&gt;LEGAL_DISCLAIMER_EXTERNAL_TOOLTIP}" width="1.25rem" class="sapUiDisclaimerCommunityLink" press="onDisclaimerLinkPress"/></l:HorizontalLayout></l:BlockLayoutCell><l:BlockLayoutCell class="sapUiBlockCenteredCell communityLinkCell" backgroundColorSet="ColorSet11" backgroundColorShade="ShadeD"><l:HorizontalLayout><Image src="./resources/sap/ui/documentation/sdk/images/logo_twitter.png" width="2.5rem" densityAware="false" class="sapUiTinyMarginTop"/><custom:TitleLink href="https://twitter.com/@openui5" target="_blank" text="Twitter" titleStyle="H2" wrap="false" class="sapUiSmallMargin sapUiNoMarginBottom sapUiNoMarginEnd"/><Image src="./resources/sap/ui/documentation/sdk/images/link-external.png" tooltip="{i18n&gt;LEGAL_DISCLAIMER_EXTERNAL_TOOLTIP}" width="1.25rem" class="sapUiDisclaimerCommunityLink" press="onDisclaimerLinkPress"/></l:HorizontalLayout></l:BlockLayoutCell></l:BlockLayoutRow></l:BlockLayout></Panel><l:BlockLayout><l:BlockLayoutRow><core:Fragment id="footerFragment" fragmentName="sap.ui.documentation.sdk.view.Footer" type="XML"/></l:BlockLayoutRow></l:BlockLayout></Page></mvc:View>',
	"sap/ui/documentation/sdk/view/appSettingsDialog.fragment.xml":'<core:FragmentDefinition xmlns="sap.m" xmlns:l="sap.ui.layout" xmlns:core="sap.ui.core"><Dialog title="{i18n&gt;APP_SETTINGS_DIALOG_TITLE}" class="sapUiPopupWithPadding" contentWidth="350px" id="AppSettingsDialog"><content><VBox class="sapUiTinyMarginTop"><Label text="{i18n&gt;APP_SETTINGS_DIALOG_THEME}" design="Standard" labelFor="ThemeSelect"/><Select id="ThemeSelect" width="100%" class="sapUiSmallMarginBottom"><core:Item key="sap_fiori_3" text="Quartz Light"/><core:Item key="sap_fiori_3_dark" text="Quartz Dark"/><core:Item key="sap_belize" text="Belize"/><core:Item key="sap_belize_plus" text="Belize Deep"/><core:Item key="sap_fiori_3_hcb" text="High Contrast Black"/><core:Item key="sap_fiori_3_hcw" text="High Contrast White"/></Select><Label text="{i18n&gt;APP_SETTINGS_DIALOG_DENSITY}" design="Standard" labelFor="CompactModeSwitch"/><Select id="DensityModeSwitch" width="100%"><core:Item text="Cozy" key="cozy"/><core:Item text="Compact" key="compact"/><core:Item text="Condensed" key="condensed"/></Select><Link text="{i18n&gt;APP_SETTINGS_DIALOG_READ_MORE}" href="topic/e54f729da8e3405fae5e4fe8ae7784c1" target="_blank" class="sapUiTinyMarginTop"/><HBox class="sapUiTinyMarginTop" alignItems="Center" justifyContent="SpaceBetween"><Label text="{i18n&gt;APP_SETTINGS_DIALOG_RTL}" design="Standard" labelFor="RTLSwitch"/><Switch id="RTLSwitch" state="false"/></HBox></VBox></content><beginButton><Button text="{i18n&gt;APP_SETTINGS_DIALOG_OK_BTN}" press="handleSaveAppSettings" type="Emphasized"/></beginButton><endButton><Button text="{i18n&gt;APP_SETTINGS_DIALOG_CANCEL_BTN}" press="handleCloseAppSettings"/></endButton></Dialog></core:FragmentDefinition>',
	"sap/ui/documentation/sdk/view/globalSettingsDialog.fragment.xml":'<core:FragmentDefinition xmlns="sap.m" xmlns:core="sap.ui.core"><Dialog title="{i18n&gt;APP_SETTINGS_DIALOG_TITLE}" class="sapUiPopupWithPadding" contentWidth="350px" id="GlobalSettingsDialog"><content><VBox class="sapUiTinyMarginTop"><MessageStrip class="sapUiTinyMarginBottom" showIcon="true" text="{i18n&gt;APP_SETTINGS_DIALOG_LANGUAGE_INFO}"/><Label text="{i18n&gt;APP_SETTINGS_DIALOG_LANGUAGE}" labelFor="LanguageSelect"/><Select id="LanguageSelect" width="100%" class="sapUiSmallMarginBottom" items="{path:\'supportedLanguages&gt;/langs\'}"><core:Item key="{supportedLanguages&gt;key}" text="{supportedLanguages&gt;text}"/></Select></VBox></content><beginButton><Button text="{i18n&gt;APP_SETTINGS_DIALOG_OK_BTN}" press="handleSaveAppSettings" type="Emphasized"/></beginButton><endButton><Button text="{i18n&gt;APP_SETTINGS_DIALOG_CANCEL_BTN}" press="handleCloseAppSettings"/></endButton></Dialog></core:FragmentDefinition>',
	"sap/ui/documentation/sdk/view/samplesInfo.fragment.xml":'<core:FragmentDefinition xmlns="sap.m" xmlns:core="sap.ui.core" xmlns:l="sap.ui.layout"><Popover title="{i18n&gt;SAMPLE_INFO_TOOLTIP}" placement="Bottom"><content><l:VerticalLayout><l:content><FormattedText visible="{=${/description} !== undefined}" htmlText="{/description}" class="sapUiTinyMargin"/><FormattedText visible="{=${/details} !== undefined}" htmlText="{/details}" class="sapUiTinyMargin"/></l:content></l:VerticalLayout></content></Popover></core:FragmentDefinition>',
	"sap/ui/documentation/sdk/view/viewSettingsDialog.fragment.xml":'<core:FragmentDefinition xmlns="sap.m" xmlns:core="sap.ui.core"><ViewSettingsDialog id="viewSettingsDialog" confirm="onConfirmViewSettings"><groupItems><ViewSettingsItem text="{i18n&gt;VIEW_SETTINGS_DIALOG_ITEM_1}" key="name" selected="true"/><ViewSettingsItem text="{i18n&gt;VIEW_SETTINGS_DIALOG_ITEM_2}" key="category"/><ViewSettingsItem text="{i18n&gt;VIEW_SETTINGS_DIALOG_ITEM_3}" key="formFactors"/><ViewSettingsItem text="{i18n&gt;VIEW_SETTINGS_DIALOG_ITEM_4}" key="namespace"/><ViewSettingsItem text="{i18n&gt;VIEW_SETTINGS_DIALOG_ITEM_5}" key="since"/></groupItems><filterItems><ViewSettingsFilterItem text="{i18n&gt;VIEW_SETTINGS_DIALOG_ITEM_2}" key="category" id="categoryFilter" items="{path:\'filter&gt;/category\',sorter:{path:\'id\',descending:false}}"><items><ViewSettingsItem text="{filter&gt;id}" key="{filter&gt;id}"/></items></ViewSettingsFilterItem><ViewSettingsFilterItem text="{i18n&gt;VIEW_SETTINGS_DIALOG_ITEM_3}" key="formFactors" items="{path:\'filter&gt;/formFactors\',sorter:{path:\'id\',descending:false}}"><items><ViewSettingsItem text="{filter&gt;id}" key="{filter&gt;id}"/></items></ViewSettingsFilterItem><ViewSettingsFilterItem text="{i18n&gt;VIEW_SETTINGS_DIALOG_ITEM_4}" key="namespace" items="{path:\'filter&gt;/namespace\',sorter:{path:\'id\',descending:false}}"><items><ViewSettingsItem text="{filter&gt;id}" key="{filter&gt;id}"/></items></ViewSettingsFilterItem><ViewSettingsFilterItem text="{i18n&gt;VIEW_SETTINGS_DIALOG_ITEM_5}" key="since" items="{path:\'filter&gt;/since\',sorter:{path:\'id\',descending:false}}"><items><ViewSettingsItem text="{filter&gt;id}" key="{filter&gt;id}"/></items></ViewSettingsFilterItem></filterItems></ViewSettingsDialog></core:FragmentDefinition>',
/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
	"sap/ui/documentation/sdk/controller/util/IndexWorker.js":function(){(function(){"use strict";var U={SEARCH_INDEX:"../../../../../../../searchindex.json",SEARCH_LIB:"../../thirdparty/elasticlunr.js",PROMISE_POLYFIL_LIB:"../../../../../../sap/ui/thirdparty/es6-promise.js"};if(!self.Promise){importScripts(U.PROMISE_POLYFIL_LIB);}importScripts(U.SEARCH_LIB);var W={COMMANDS:{INIT:"fetch",SEARCH:"search"},RESPONSE_FIELDS:{DONE:"bDone",SEARCH_RESULT:"oSearchResult"}},M=["properties","aggregations","associations","events","methods","specialSettings","annotations"],I=M.concat(["title","contents","paramTypes"]),A=["get","set","add","insert","remove","destroy","indexOf","attach","detach"],a=new RegExp("[a-zA-Z]+"),O=" ",o={},b=false;self.addEventListener('message',function(E){var D=E.data,C=D&&D.cmd;if(C===W.COMMANDS.INIT){b=E.data.bIsMsieBrowser;f().then(function(){var r={};r[W.RESPONSE_FIELDS.DONE]=true;self.postMessage(r);});}else if(C===W.COMMANDS.SEARCH){s(E.data.sQuery).then(function(i){var r={};r[W.RESPONSE_FIELDS.SEARCH_RESULT]=i;self.postMessage(r);});}},false);
function f(){return new Promise(function(r,i){var j=o["index"],k;if(j){r(j);return;}var l=new XMLHttpRequest(),m=function(E){k=E.target.response||E.target.responseText;if(typeof k!=='object'){k=JSON.parse(k);}k=d(k);c();j=lunr.Index.load(k.lunr);o["index"]=j;o["docs"]=k.docs;r(j);};if(!b){l.responseType='json';}l.addEventListener("load",m,false);l.open("get",U.SEARCH_INDEX);l.send();});}
function s(q){q=p(q);return new Promise(function(r,i){f().then(function(j){var k,l=new S();function m(F,n,R){var t=j.search(n,e(F));l.add(t,n,F,R);}m("title",q);M.forEach(function(F){lunr.tokenizer(q).forEach(function(n){m(F,n,true);});});m("paramTypes",q);m("contents",q);k=l.getAll();r({success:!!(k.length),totalHits:k.length,matches:k});});});}
function p(q){var j;for(var i=0;i<A.length;i++){var P=A[i];if(q.indexOf(P)===0){j=q.substring(P.length);}}if(j&&a.test(j)){q+=O+j;}return q;}
function c(){var i=lunr.tokenizer;var r=/[-./#_,;\(\)=><|]/g;lunr.tokenizer=function(j){return i.call(lunr,j).reduce(function(k,t){if(r.test(t)){t=t.replace(r," ");k.push.apply(k,t.toLowerCase().split(/ +/));}else{k.push(t.toLowerCase());}return k;},[]);};Object.keys(i).forEach(function(k){lunr.tokenizer[k]=i[k];});}
function d(j){function k(F){var i=j.lunr.index[F].tfValues;i[0]=NaN;j.lunr.index[F].tfValues=undefined;function m(C){var D=[];C.split(",").forEach(function(r){var P=r.split(":"),K=parseInt(P[0]),u=P[1];while(u.length>0){D.push(u.slice(0,K));u=u.slice(K);}});return D;}function n(N){var D=N.docs,C=0;if(D===undefined){N.docs={};}else{Object.keys(D).forEach(function(r){if(typeof D[r]==='number'){D[r]={tf:i[D[r]]};}if(r.indexOf(':')>=0){var u=m(r);u.forEach(function(v){D[v]=D[r];C++;});D[r]=undefined;}else{C++;}});}if(N.df===undefined){N.df=C;}}function q(N){n(N);Object.keys(N).forEach(function(K){if(K!=='docs'&&K!=='df'){var v=N[K];var L=K.length;if(L>1){while(--L>0){var T={};T[K.charAt(L)]=v;v=T;}N[K.charAt(0)]=v;N[K]=undefined;}q(v);}});}q(j.lunr.index[F].root);}function t(n,P){for(var i in n){P.apply(n,[i,n[i]]);if(n[i]!==null&&typeof(n[i])=="object"){t(n[i],P);}}}function l(K,v){if(v===undefined){delete this[K];}}I.forEach(function(F){k(F);});t(j,l);return j;}
var S=function(){var D=o["docs"];if(!D){throw new Error("docs are required");}this._oDocs=D;this._oCollectedResults={};};
S.prototype.add=function(r,q,m,R){r.forEach(function(i){this._mergeResultWithDocInfo(i,q,m,R);this._oCollectedResults[this._getResultId(i)]=i;}.bind(this));return this;};
S.prototype.getAll=function(){return h(this._oCollectedResults);};
S.prototype._mergeResultWithDocInfo=function(r,q,D,R){var i=this._oDocs[r.ref];r.doc=i;r.matchedDocField=D;if(R){r.matchedDocWord=g(i[D],q);}};
S.prototype._getResultId=function(r){var D=r.ref,i=r.matchedDocWord||"";return D+"/"+i;};
function g(w,t){if(w){var i=function(k){return k.toLowerCase().indexOf(t.toLowerCase())===0;};var m=w.split(" ");var j=m.filter(i);if(j.length){return j[0];}}return null;}
function e(F){var C={fields:{},expand:true};C.fields[F]={};return C;}
function h(i){var k=Object.keys(i),v=[];k.forEach(function(K){v.push(i[K]);});return v;}
})();
},
	"sap/ui/documentation/sdk/util/LiveEditorOutput.js":function(){(function(){"use strict";window.addEventListener("message",function(e){if(e.origin!==(window.location.protocol+"//"+window.location.host)){return;}var d=e.data;if(!d||!d.src||!d.moduleNameToRequire){return;}a();p(d);});
function p(d){sap.ui.require.preload(d.src);sap.ui.require([d.moduleNameToRequire]);}
function a(){window.addEventListener("error",function(e){e.preventDefault();var E=document.createElement("span");E.innerText=e.message;E.style.cssText="position:absolute; top:1rem; left:1rem";if(!document.body){document.write("<span></span>");}document.body.appendChild(E);});window.addEventListener("unhandledrejection",function(e){e.preventDefault();var E=document.createElement("span");E.innerText=e.reason&&e.reason.message;E.style.cssText="position:absolute; top:1rem; left:1rem";if(!document.body){document.write("<span></span>");}document.body.appendChild(E);});}
})();
}
},"sap/ui/documentation/library-preload"
);
//# sourceMappingURL=library-preload.js.map