/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/documentation/sdk/controller/BaseController","sap/ui/documentation/sdk/controller/util/SearchUtil","sap/ui/core/mvc/Controller","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/model/json/JSONModel","sap/ui/core/ResizeHandler","sap/ui/Device","sap/ui/core/Fragment","sap/ui/core/Locale","sap/ui/core/LocaleData","sap/base/util/UriParameters","sap/ui/documentation/library","sap/ui/core/IconPool","sap/m/MessageBox","sap/m/library","sap/base/Log","sap/base/util/Version","sap/ui/core/syncStyleClass","sap/ui/documentation/WebPageTitleUtil","sap/ui/core/Core","sap/ui/documentation/sdk/model/formatter"],function(q,B,S,C,F,c,J,R,D,d,L,e,U,f,I,M,m,g,V,s,W,h,k){"use strict";var n=m.SplitAppMode;var o="Demo Kit - SAPUI5 SDK";var p={home:"Home - "+o,topic:"Documentation - "+o,api:"API Reference - "+o,controls:"Samples - "+o,demoapps:"Demo Apps - "+o,tools:"Tools - "+o};var r=m.URLHelper,N="/neo-app.json",A="about",t="feedback",u="change_version",v="settings",w="cookie_preferences",x="en",y="language";var T={sap_belize:{iMobileHeight:"5rem",iDesktopHeight:"3rem"},sap_fiori_3:{iMobileHeight:"4.75rem",iDesktopHeight:"2.75rem"}};return B.extend("sap.ui.documentation.sdk.controller.App",{formatter:k,onInit:function(){B.prototype.onInit.call(this);var a=new J({busy:false,delay:0,bPhoneSize:false,bShowVersionSwitchInHeader:false,bShowVersionSwitchInMenu:false,bLandscape:D.orientation.landscape,bHasMaster:false,bSearchMode:false,bHideTopicSection:!!window['sap-ui-documentation-hideTopicSection'],bHideApiSection:!!window['sap-ui-documentation-hideApiSection'],sAboutInfoSAPUI5:"Looking for the Demo Kit for a specific SAPUI5 version? "+"Check at <a href = 'https://sapui5.hana.ondemand.com/versionoverview.html'>https://sapui5.hana.ondemand.com/versionoverview.html</a> "+"which versions are available. "+"You can view the version-specific Demo Kit by adding the version number to the URL, e.g. "+"<a href='https://sapui5.hana.ondemand.com/1.52.4/'>https://sapui5.hana.ondemand.com/1.52.4/</a>",sAboutInfoOpenUI5:"Looking for the Demo Kit for a specific OpenUI5 version? "+"Check at <a href = 'https://openui5.hana.ondemand.com/versionoverview.html'>https://openui5.hana.ondemand.com/versionoverview.html</a> "+"which versions are available. "+"You can view the version-specific Demo Kit by adding the version number to the URL, e.g. "+"<a href='https://openui5.hana.ondemand.com/1.52.4/'>https://openui5.hana.ondemand.com/1.52.4/</a>",oThemeScrollContainerHeight:T[this.extractThemeSettings()]});this.MENU_LINKS_MAP={"legal":"https://www.sap.com/corporate/en/legal/impressum.html","privacy":"https://www.sap.com/corporate/en/legal/privacy.html","terms_of_use":"https://www.sap.com/corporate/en/legal/terms-of-use.html","copyright":"https://www.sap.com/corporate/en/legal/copyright.html","trademark":"https://www.sap.com/corporate/en/legal/trademark.html","disclaimer":"https://help.sap.com/viewer/disclaimer","license":"LICENSE.txt"};this.getOwnerComponent().loadVersionInfo().then(function(){if(this.getModel("versionData").getProperty("/isOpenUI5")){this.MENU_LINKS_MAP["Terms of Use"]="TermsOfUse.txt";}}.bind(this));this.FEEDBACK_SERVICE_URL="https://feedback-sapuisofiaprod.hana.ondemand.com:443/api/v2/apps/5bb7d7ff-bab9-477a-a4c7-309fa84dc652/posts";this._oSupportedLangModel=new J({"langs":this._prepareSupportedLangModelData()});this.setModel(this._oSupportedLangModel,"supportedLanguages");this._oView=this.getView();this.setModel(a,"appView");this.setModel(new J({inspectorHomeLink:"topic/b24e72443eb34d0fb7bf6940f2d697eb",supportAssistantHomeLink:"topic/57ccd7d7103640e3a187ed55e1d2c163",demoAppsHomeLink:"topic/a3ab54ecf7ac493b91904beb2095d208",iconExplorerHomeLink:"topic/21ea0ea94614480d9a910b2e93431291"}),"newWindowLinks");this.oHeader=this._oView.byId("headerToolbar");this.oRouter=this.getRouter();this._selectHeader=this._oView.byId("selectHeader");this._tabHeader=this._oView.byId("tabHeader");this._oWebPageTitleUtil=new W();this._oConfigUtil=this.getOwnerComponent().getConfigUtil();this._oCookieNames=this._oConfigUtil.COOKIE_NAMES;R.register(this.oHeader,this.onHeaderResize.bind(this));this.oRouter.attachRouteMatched(this.onRouteChange.bind(this));this.oRouter.attachBypassed(this.onRouteNotFound.bind(this));this._registerFeedbackRatingIcons();this._requestVersionInfo();this.byId("splitApp").attachEvent("afterMasterClose",function(E){a.setProperty("/bIsShownMaster",false);},this);this.bus=h.getEventBus();this.bus.subscribe("themeChanged","onDemoKitThemeChanged",this.onDemoKitThemeChanged,this);this._createConfigurationBasedOnURIInput();if(this._oConfigUtil.getCookieValue(this._oCookieNames.ALLOW_REQUIRED_COOKIES)==="1"&&this._aConfiguration.length>0){this._applyCookiesConfiguration(this._aConfiguration);}else{this._applyDefaultConfiguration(this._aConfiguration);}},onBeforeRendering:function(){D.orientation.detachHandler(this._onOrientationChange,this);},onAfterRendering:function(){q(document.body).addClass(this.getOwnerComponent().getContentDensityClass());D.orientation.attachHandler(this._onOrientationChange,this);if(this._oConfigUtil.getCookieValue(this._oCookieNames.APPROVAL_REQUESTED)!=="1"){this.cookieSettingsDialogOpen();}},onExit:function(){D.orientation.detachHandler(this._onOrientationChange,this);},onRouteChange:function(E){if(!this.oRouter.getRoute(E.getParameter("name"))._oConfig.target){return;}var a=E.getParameter("name"),b=this.oRouter.getRoute(a)._oConfig.target[0]+"Tab",i=this._oView.byId(b),K=i?i.getKey():"home",j=this.getModel("appView"),P=j.getProperty("/bPhoneSize"),l=j.getProperty("/bSearchMode"),z=D.system.phone,H=this.getOwnerComponent().getConfigUtil().hasMasterView(a),G,O;this._setHeaderSelectedKey(K);this._oWebPageTitleUtil.setTitle(p[K]);j.setProperty("/bHasMaster",H);if(P&&!l){this._selectHeader.setVisible(true);}if(z&&H){G=this.getOwnerComponent().getConfigUtil().getMasterView(a);O=G&&G.getId();j.setProperty("/sMasterViewId",O);}this.byId("splitApp").hideMaster();j.setProperty("/bIsShownMaster",false);},onRouteNotFound:function(){this.getRouter().myNavToWithoutHash("sap.ui.documentation.sdk.view.NotFound","XML",false);return;},toggleMaster:function(E){var P=E.getParameter("pressed"),b=D.system.phone,a=this.byId("splitApp"),i=a.getMode()===n.ShowHideMode,j=a.getMode()===n.HideMode,l=this.getModel("appView").getProperty("/sMasterViewId"),z;if(!b&&(i||j)){z=(P)?a.showMaster:a.hideMaster;z.call(a);return;}if(b){if(P){a.to(l);}else{a.backDetail();}}},navigateToSection:function(E){var K=E.getParameter("key"),i;if(!K){i=E.getParameter("selectedItem");i&&(K=i.getKey());}E.preventDefault();if(K&&K!=="home"){this.getRouter().navTo(K,{});}else{this.getRouter().navTo("welcome",{});this._setHeaderSelectedKey("home");}},handleMenuItemClick:function(E){var a=E.getParameter("item").getKey(),b=this.MENU_LINKS_MAP[a];if(a===A){this.aboutDialogOpen();}else if(a===t){this.feedbackDialogOpen();}else if(a===v){this.settingsDialogOpen();}else if(a===w){this.cookieSettingsDialogOpen(true);}else if(a===u){this.onChangeVersionButtonPress();}else if(b){r.redirect(b,true);}},_createConfigurationBasedOnURIInput:function(){var a=U.fromQuery(window.location.search);this._aConfiguration=[];if(!(a.has('sap-ui-language')||a.has('sap-language'))){this._aConfiguration.push(y);}},_applyDefaultConfiguration:function(){this._aConfiguration.forEach(function(a){if(a===y){h.getConfiguration().setLanguage(x);}},this);this._oSupportedLangModel.setProperty("/selectedLang",h.getConfiguration().getLanguage());},_applyCookiesConfiguration:function(){var a,b,i;for(i=0;i<this._aConfiguration.length;i++){b=this._aConfiguration[i];a=this._oConfigUtil.getCookieValue(b);if(a!==""){if(b===y){this._setSelectedLanguage(a);}this._aConfiguration.splice(i,1);i--;}}if(this._aConfiguration.length>0){this._applyDefaultConfiguration();}},_prepareSupportedLangModelData:function(){return h.getConfiguration().getLanguagesDeliveredWithCore().reduce(function(a,l){var b;if(typeof l==="string"&&l.length>0){switch(l){case"iw":b=new e(new L("he")).getLanguages()["he"];break;case"zh_TW":b=new e(new L(l)).getLanguages()["zh_Hant"];break;case"zh_CN":b=new e(new L(l)).getLanguages()["zh_Hans"];break;default:b=new e(new L(l)).getLanguages()[l];}a.push({"text":typeof b==='string'?b.charAt(0).toUpperCase()+b.substring(1):"Unknown","key":l});}return a;},[]);},_setSelectedLanguage:function(l){this._oSupportedLangModel.setProperty("/selectedLang",l);h.getConfiguration().setLanguage(l);if(this._oConfigUtil.getCookieValue(this._oCookieNames.ALLOW_REQUIRED_COOKIES)==="1"){this._oConfigUtil.setCookie(y,l);}},_getSelectedLanguage:function(){return this._oSupportedLangModel.getProperty("/selectedLang");},settingsDialogOpen:function(){if(!this._oSettingsDialog){d.load({name:"sap.ui.documentation.sdk.view.globalSettingsDialog",controller:this}).then(function(a){this._oView.addDependent(a);this._oSettingsDialog=a;h.byId("LanguageSelect").setSelectedKey(this._getSelectedLanguage());this._oSettingsDialog.open();}.bind(this));}else{this._oSettingsDialog.open();}},cookieSettingsDialogOpen:function(){if(this._oCookieSettingsController){this._oCookieSettingsController.openCookieSettingsDialog(this._oConfigUtil,this.getView());return;}C.create({name:"sap.ui.documentation.sdk.controller.CookieSettingsDialog"}).then(function(a){this._oCookieSettingsController=a;a.openCookieSettingsDialog(this._oConfigUtil,this.getView());}.bind(this));},handleCloseAppSettings:function(){this._oSettingsDialog.close();},handleSaveAppSettings:function(){var l=h.byId('LanguageSelect').getSelectedKey();this._oSettingsDialog.close();this._applyAppConfiguration(l);},_applyAppConfiguration:function(l){this._setSelectedLanguage(l);},aboutDialogOpen:function(){if(!this._oAboutDialog){this._oAboutDialog=new sap.ui.xmlfragment("aboutDialogFragment","sap.ui.documentation.sdk.view.AboutDialog",this);this._oView.addDependent(this._oAboutDialog);}else{this._oAboutDialog.getContent()[0].backToTop();}this._oAboutDialog.open();},aboutDialogClose:function(E){this._oAboutDialog.close();},onAboutVersionDetails:function(E){var a=this.getModel("appView"),b=a.getData(),j=this;f._loadAllLibInfo("","_getLibraryInfo","",function(H,K){var O={};var P=f._getLibraryInfoSingleton();for(var i=0,l=H.length;i<l;i++){H[i]=K[H[i]];H[i].libDefaultComponent=P._getDefaultComponent(H[i]);}O.libs=H;b.oVersionInfo=O;a.setData(b);j.setModel(a,"appView");});var z=d.byId("aboutDialogFragment","aboutNavCon"),G=d.byId("aboutDialogFragment","aboutDetail");z.to(G);},onAboutThirdParty:function(E){var l=this.getModel("appView"),z=l.getData(),G=this;f._loadAllLibInfo("","_getThirdPartyInfo",function(O,P){if(!O){return;}var Q={};Q.thirdparty=[];for(var j=0;j<O.length;j++){var X=P[O[j]];for(var i=0;i<X.libs.length;i++){var Y=X.libs[i];Y._lib=O[j];Q.thirdparty.push(Y);}}Q.thirdparty.sort(function(a,b){var Z=(a.displayName||"").toUpperCase();var $=(b.displayName||"").toUpperCase();if(Z>$){return 1;}else if(Z<$){return-1;}else{return 0;}});z.oThirdPartyInfo=Q;l.setData(z);G.setModel(l,"appView");});var H=d.byId("aboutDialogFragment","aboutNavCon"),K=d.byId("aboutDialogFragment","aboutThirdParty");H.to(K);},onReleaseDialogOpen:function(E){var l=f._getLibraryInfoSingleton(),a=E.getSource().data("version"),b=E.getSource().data("library"),i=new J(),j=new J(),z=this;if(!this._oReleaseDialog){this._oReleaseDialog=new sap.ui.xmlfragment("releaseDialogFragment","sap.ui.documentation.sdk.view.ReleaseDialog",this);this._oView.addDependent(this._oReleaseDialog);}if(!this._oNotesView){this._oNotesView=sap.ui.view({id:"notesView",viewName:"sap.ui.documentation.sdk.view.ReleaseNotesView",type:"Template"});this._oNotesView.setModel(i);}l._getReleaseNotes(b,a,function(G,a){var H={};if(G&&G[a]&&G[a].notes&&G[a].notes.length>0){z._oNotesView.getModel().setData(G);z._oNotesView.bindObject("/"+a);}else{H.noData=true;}H.library=b;j.setData(H);});this._oReleaseDialog.setModel(j);this._oReleaseDialog.addContent(this._oNotesView);this._oReleaseDialog.open();},onReleaseDialogClose:function(E){this._oReleaseDialog.close();},onAboutNavBack:function(E){var a=d.byId("aboutDialogFragment","aboutNavCon");a.back();},onChangeVersionButtonPress:function(){this.getVersionSwitchDialog().open();},onCloseVersionDialog:function(){this.getVersionSwitchDialog().close();},onChangeVersionDialogSearch:function(E){var a=E.getParameter("newValue"),b=new F("version",c.Contains,a),i=h.byId("versionList").getBinding("items");i.filter([b]);},onLogoIconPress:function(){this.oRouter.navTo("welcome",{});},onVersionItemPress:function(E){var a=E.getParameter("listItem"),b=a.getCustomData()[0];if(b&&b.getKey()==="path"){window.location.href=b.getValue();}},getVersionSwitchDialog:function(){if(!this._oChangeVersionDialog){this._createVersionDialog();}return this._oChangeVersionDialog;},versionSwitchCustomComparator:function(G,a){return V(G).compareTo(V(a));},_updateVersionSwitchVisibility:function(){var a=this.getModel("appView"),P=a.getProperty("/bPhoneSize");a.setProperty("/bShowVersionSwitchInHeader",!P&&!!this._aNeoAppVersions);a.setProperty("/bShowVersionSwitchInMenu",P&&!!this._aNeoAppVersions);},_createVersionDialog:function(){this._oChangeVersionDialog=new sap.ui.xmlfragment("sap.ui.documentation.sdk.view.ChangeVersionDialog",this);this._oChangeVersionDialog.setModel(this._buildVersionDialogModel());this._oView.addDependent(this._oChangeVersionDialog);},_buildVersionDialogModel:function(){var a=new J();a.setSizeLimit(1000);a.setData(this._aNeoAppVersions);return a;},feedbackDialogOpen:function(){var a=this;var b;if(!this._oFeedbackDialog){b=this.getModel("i18n").getResourceBundle();this._oFeedbackDialog=new sap.ui.xmlfragment("feedbackDialogFragment","sap.ui.documentation.sdk.view.FeedbackDialog",this);this._oView.addDependent(this._oFeedbackDialog);this._oFeedbackDialog.textInput=d.byId("feedbackDialogFragment","feedbackInput");this._oFeedbackDialog.contextCheckBox=d.byId("feedbackDialogFragment","pageContext");this._oFeedbackDialog.contextData=d.byId("feedbackDialogFragment","contextData");this._oFeedbackDialog.ratingStatus=d.byId("feedbackDialogFragment","ratingStatus");this._oFeedbackDialog.ratingStatus.value=0;this._oFeedbackDialog.sendButton=d.byId("feedbackDialogFragment","sendButton");this._oFeedbackDialog.ratingBar=[{button:d.byId("feedbackDialogFragment","excellent"),status:"Excellent",displayStatus:b.getText("FEEDBACK_DIALOG_STATUS_EXCELLENT")},{button:d.byId("feedbackDialogFragment","good"),status:"Good",displayStatus:b.getText("FEEDBACK_DIALOG_STATUS_GOOD")},{button:d.byId("feedbackDialogFragment","average"),status:"Average",displayStatus:b.getText("FEEDBACK_DIALOG_STATUS_AVERAGE")},{button:d.byId("feedbackDialogFragment","poor"),status:"Poor",displayStatus:b.getText("FEEDBACK_DIALOG_STATUS_POOR")},{button:d.byId("feedbackDialogFragment","veryPoor"),status:"Very Poor",displayStatus:b.getText("FEEDBACK_DIALOG_STATUS_VERY_POOR")}];this._oFeedbackDialog.reset=function(){this.sendButton.setEnabled(false);this.textInput.setValue("");this.contextCheckBox.setSelected(true);this.ratingStatus.setText("");this.ratingStatus.setState("None");this.ratingStatus.value=0;this.contextData.setVisible(false);this.ratingBar.forEach(function(i){if(i.button.getPressed()){i.button.setPressed(false);}});};this._oFeedbackDialog.updateContextData=function(){var i=a._getUI5Version(),j=a._getUI5Distribution();if(this.contextCheckBox.getSelected()){this.contextData.setValue("Location: "+a._getCurrentPageRelativeURL()+"\n"+j+" Version: "+i);}else{this.contextData.setValue(j+" Version: "+i);}};this._oFeedbackDialog.updateContextData();}this._oFeedbackDialog.updateContextData();if(!this._oFeedbackDialog.isOpen()){s("sapUiSizeCompact",this.getView(),this._oFeedbackDialog);this._oFeedbackDialog.open();}},onFeedbackDialogSend:function(){var a={},b=this.getModel("i18n").getResourceBundle();if(this._oFeedbackDialog.contextCheckBox.getSelected()){a={"texts":{"t1":this._oFeedbackDialog.textInput.getValue()},"ratings":{"r1":{"value":this._oFeedbackDialog.ratingStatus.value}},"context":{"page":this._getCurrentPageRelativeURL(),"attr1":this._getUI5Distribution()+":"+sap.ui.version}};}else{a={"texts":{"t1":this._oFeedbackDialog.textInput.getValue()},"ratings":{"r1":{"value":this._oFeedbackDialog.ratingStatus.value}},"context":{"attr1":this._getUI5Distribution()+":"+sap.ui.version}};}this._oFeedbackDialog.setBusyIndicatorDelay(0);this._oFeedbackDialog.setBusy(true);q.ajax({url:this.FEEDBACK_SERVICE_URL,type:"POST",contentType:"application/json",data:JSON.stringify(a)}).done(function(){M.success(b.getText("FEEDBACK_DIALOG_TEXT_SUCCESS"),{title:b.getText("FEEDBACK_DIALOG_TITLE_SUCCESS")});this._oFeedbackDialog.reset();this._oFeedbackDialog.close();this._oFeedbackDialog.setBusy(false);}.bind(this)).fail(function(i,j,E){var l=E;M.error(b.getText("FEEDBACK_DIALOG_TEXT_ERROR")+l,{title:b.getText("FEEDBACK_DIALOG_TITLE_ERROR")});this._oFeedbackDialog.setBusy(false);}.bind(this));},onFeedbackDialogCancel:function(){this._oFeedbackDialog.reset();this._oFeedbackDialog.close();},onShowHideContextData:function(){this._oFeedbackDialog.contextData.setVisible(!this._oFeedbackDialog.contextData.getVisible());},onContextSelect:function(){this._oFeedbackDialog.updateContextData();},onPressRatingButton:function(E){var a=this;var P=E.getSource();a._oFeedbackDialog.ratingBar.forEach(function(i){if(P!==i.button){i.button.setPressed(false);}else{if(!i.button.getPressed()){b("None","",0);}else{switch(i.status){case"Excellent":b("Success",i.displayStatus,5);break;case"Good":b("Success",i.displayStatus,4);break;case"Average":b("None",i.displayStatus,3);break;case"Poor":b("Warning",i.displayStatus,2);break;case"Very Poor":b("Error",i.displayStatus,1);}}}});function b(i,j,l){a._oFeedbackDialog.ratingStatus.setState(i);a._oFeedbackDialog.ratingStatus.setText(j);a._oFeedbackDialog.ratingStatus.value=l;if(l){a._oFeedbackDialog.sendButton.setEnabled(true);}else{a._oFeedbackDialog.sendButton.setEnabled(false);}}},onSearch:function(E){var Q=encodeURIComponent(E.getParameter("query"));if(!Q){return;}this.getRouter().navTo("search",{searchParam:Q},false);},onHeaderResize:function(E){var i=E.size.width,P=D.system.phone||i<D.media._predefinedRangeSets[D.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0],a=this.getModel("appView"),b=a.getProperty("/bSearchMode");if(P!==a.getProperty("/bPhoneSize")){a.setProperty("/bPhoneSize",P);this._updateVersionSwitchVisibility();this._tabHeader.setVisible(!P);this._selectHeader.setVisible(P);}if(b){this._selectHeader.setVisible(false);}},_onOrientationChange:function(){this.getModel("appView").setProperty("/bLandscape",D.orientation.landscape);},onToggleSearchMode:function(E){var b=E.getParameter("isOpen"),a=this.getModel("appView"),P=a.getProperty("/bPhoneSize");a.setProperty("/bSearchMode",b);if(b){S.init();setTimeout(function(){this._oView.byId("searchControl").getAggregation("_searchField").getFocusDomRef().focus();}.bind(this),0);if(P){this._selectHeader.setVisible(false);}}else if(P){this._selectHeader.setVisible(true);}},_registerFeedbackRatingIcons:function(){I.addIcon("icon-face-very-bad","FeedbackRatingFaces",{fontFamily:"FeedbackRatingFaces",content:"E086",suppressMirroring:true});I.addIcon("icon-face-bad","FeedbackRatingFaces",{fontFamily:"FeedbackRatingFaces",content:"E087",suppressMirroring:true});I.addIcon("icon-face-neutral","FeedbackRatingFaces",{fontFamily:"FeedbackRatingFaces",content:"E089",suppressMirroring:true});I.addIcon("icon-face-happy","FeedbackRatingFaces",{fontFamily:"FeedbackRatingFaces",content:"E08B",suppressMirroring:true});I.addIcon("icon-face-very-happy","FeedbackRatingFaces",{fontFamily:"FeedbackRatingFaces",content:"E08C",suppressMirroring:true});},_requestVersionInfo:function(){Promise.resolve(q.ajax(N)).then(function(a){var b=this.getModel("versionData"),i=b.getProperty("/isInternal"),j=b.getProperty("/isSnapshotVersion");if(!(a&&a.routes)){g.warning("No versions were found");return;}a.routes.pop();this._aNeoAppVersions=a.routes;if(!i&&!j){this._aNeoAppVersions=this._aNeoAppVersions.filter(function(l){return l.target.version.indexOf("-beta")===-1;});}this._aNeoAppVersions=this._aNeoAppVersions.map(function(l){var z=V(l.target.version),E={};E.patchVersion=z.getPatch();E.groupTitle=z.getMajor()+"."+z.getMinor();E.version=z.toString();E.path=l.path;return E;});this._updateVersionSwitchVisibility();}.bind(this),function(){g.warning("No neo-app.json was detected");});},onDemoKitThemeChanged:function(){this.getModel("appView").setProperty("/oThemeScrollContainerHeight",T[this.extractThemeSettings()]);},extractThemeSettings:function(){return h.getConfiguration().getTheme()==="sap_fiori_3"?"sap_fiori_3":"sap_belize";},_getUI5Version:function(){return this.getModel("versionData").getProperty("/version");},_getUI5VersionGav:function(){return this.getModel("versionData").getProperty("/versionGav");},_getUI5Distribution:function(){var a=this._getUI5VersionGav();var b="SAPUI5";if(a&&/openui5/i.test(a)){b="OpenUI5";}return b;},_getCurrentPageRelativeURL:function(){var a=window.location;return a.pathname+a.hash+a.search;},_setHeaderSelectedKey:function(K){this._selectHeader.setSelectedKey(K);this._tabHeader.setSelectedKey(K);}});});
