/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/model/json/JSONModel","sap/ui/documentation/sdk/controller/BaseController","sap/ui/documentation/sdk/controller/util/ControlsInfo","sap/ui/documentation/sdk/controller/util/EntityInfo","sap/ui/documentation/sdk/controller/util/APIInfo","sap/ui/documentation/sdk/util/ToggleFullScreenHandler","sap/ui/documentation/sdk/controller/util/JSDocUtil","sap/m/Label","sap/m/Link","sap/m/Text","sap/m/HBox","sap/m/ObjectAttribute"],function(J,B,C,E,A,T,a,L,b,c,H,O){"use strict";return B.extend("sap.ui.documentation.sdk.controller.Entity",{onInit:function(){this.router=this.getRouter();this.router.getRoute("entity").attachPatternMatched(this.onRouteMatched,this);this._oObjectPage=this.byId("ObjectPageLayout");this.getView().setModel(new J());},onTypeLinkPress:function(e){var t=e.getSource().data("type");this.getRouter().navTo("entity",{id:t},false);},onAPIRefPress:function(e){var s=e.getSource().data("name");this.getRouter().navTo("apiId",{id:s},false);},onTabSelect:function(e){var t=e.getParameter("key");this.router.navTo("entity",{id:this._sId,part:t},true);},onNavToSample:function(e){var p=e.getSource().getBindingContext().getPath(),s=this.getView().getModel().getProperty(p);this.router.navTo("sample",{entityId:this._sNewId,sampleId:s.id});},_wrapInSpanTag:function(t){var f=a.formatTextBlock(t,{linkFormatter:function(s,t){var r="entity",d,m,p;t=t||s;if(s.match("://")){return'<a target="_blank" href="'+s+'">'+t+'</a>';}s=s.trim().replace(/\.prototype\./g,"#");p=s.indexOf("#");if(p===0){return"<code>"+s.slice(1)+"</code>";}else if(p>0){s=s.slice(0,p);}m=s.match(/^topic:(\w{32})$/);if(m){s=m[1];r="topic";}d=s.split('/');if(d.length>1&&["methods","events"].indexOf(d[1].toLowerCase())!==-1){r="api";}return'<a class="jsdoclink" href="'+r+'/'+s+'">'+t+'</a>';}});return'<span class="sapUiJSD">'+f+'</span>';},_TAB_KEYS:["samples","about"],_loadSample:function(o){var n=this._sNewId;var f=o.entities.filter(function(g){return g.id===n;});var e=f.length?f[0]:undefined;function u(){if(this._TAB_KEYS.indexOf(this._sNewTab)===-1){this._sNewTab="samples";}if(!d.show[this._sNewTab]){this._sNewTab="samples";}this._switchPageTab();setTimeout(function(){this._oObjectPage.setBusy(false);}.bind(this),0);}var d,v=this.getView();if(this._sId!==n){E.getEntityDocuAsync(n,e&&e.library).then(function(D){if(!e&&!D){this.router.myNavToWithoutHash("sap.ui.documentation.sdk.view.NotFound","XML",false);return;}d=this._getViewData(n,D,e,o);this.getAPIReferenceCheckPromise(d.name).then(function(h){d.bHasAPIReference=h;this._buildHeaderLayout(d);}.bind(this));v.getModel().setData(d,false);this._sId=n;u.call(this);}.bind(this));}else{d=this.getView().getModel().getData();u.call(this);}},onRouteMatched:function(e){this._oObjectPage.setBusy(true);this._sNewId=e.getParameter("arguments").id;this._sNewTab=e.getParameter("arguments").sectionTab;C.loadData().then(function(d){this._loadSample(d);}.bind(this));this.searchResultsButtonVisibilitySwitch(this.byId("entityBackToSearch"));},onToggleFullScreen:function(e){T.updateMode(e,this.getView(),this);},_getViewData:function(i,d,e,o){var D=this._convertEntityInfo(i,d,o),s=false,S=0;D.show.introLink=false;if(e){if(!D.shortDescription&&e.description){D.shortDescription=e.description;}if(!D.baseName){D.baseName=e.name;}if(e.docuLink){D.show.introLink=true;D.docuLink=e.docuLink.replace("docs/guide","topic").replace(/\.html$/,"");D.docuLinkText=D.baseName;}s=e.samples.length>0;S=e.samples.length;}D.show.samples=s;D.count.samples=S;D.entity=e;if(d){if(d.docuLink){D.show.introLink=true;D.docuLink="topic/"+d.docuLink;D.docuLinkText=d.docuLinkText;}D.uxGuidelinesLink=d.uxGuidelinesLink;D.uxGuidelinesLinkText=d.uxGuidelinesLinkText;}return D;},_convertEntityInfo:function(i,d,o){var D={name:i,deprecated:(d)?this._formatDeprecated(d.deprecation):null,deprecatedMark:(d)?this._createDeprecatedMark(d.deprecation):null,baseType:(d)?this._formatType(d.baseType):null,baseTypeText:(d)?this._formatTypeText(d.baseType):"-",baseTypeNav:(d)?this._formatTypeNav(d.baseType):null,shortDescription:(d)?this._formatDeprecatedDescription(d.deprecation):null,description:(d)?this._wrapInSpanTag(d.doc):null,docuLink:null,docuLinkText:null,uxGuidelinesLink:null,uxGuidelinesLinkText:null,values:d?d.values:[],show:{baseType:(d)?!!d.baseType:false,about:!!d,values:false,introActive:false},count:{samples:0},appComponent:this._getControlComponent(i,o)};if(!d){return D;}D.show.values=Array.isArray(D.values)&&D.values.length>0;return D;},_formatDeprecated:function(d){return(d&&d.length>0)?"true":"false";},_formatDeprecatedDescription:function(d){return(d&&d.length>0)?(this._createDeprecatedMark(d)+": "+d):null;},_formatType:function(t){if(!t){return null;}else{return t.replace("[]","");}},_formatTypeText:function(t){if(!t){return null;}else{t=t.replace("sap.ui.core.","");var i=t.lastIndexOf(".");return(i!==-1)?t.substr(i+1):t;}},_createDeprecatedMark:function(d){var r=this.getModel("i18n").getResourceBundle();return(d)?r.getText("ENTITY_DEPRECATED"):"";},_switchPageTab:function(){var s=this.byId(this._sNewTab);if(!s){return;}if(this._oObjectPage){this._oObjectPage.attachEvent("onAfterRenderingDOMReady",function(){this._oObjectPage.setSelectedSection(s.getId());},this);}},_getHeaderLayoutUtil:function(){var r;if(!this._oHeaderLayoutUtil){var _=function(t,s){return new O({title:t,text:s}).addStyleClass("sapUiTinyMarginBottom");},d=function(o){return new b(o||{});},e=function(o){return new c(o||{});},f=function(o){return new L(o||{});},g=function(o,h){var i=new H(o||{});if(h){i.addStyleClass("sapUiDocumentationHeaderNavLinks sapUiTinyMarginBottom");}return i;};r=this.getModel("i18n").getResourceBundle();this._oHeaderLayoutUtil={_getApiReferenceBlock:function(D){return g({items:[f({design:"Bold",text:r.getText("ENITITY_API")}),d({emphasized:true,text:D.name,href:"api/"+D.name})]},true);},_getDocumentationBlock:function(D){return g({items:[f({design:"Bold",text:r.getText("ENTITY_DOCUMENTATION")}),d({emphasized:true,text:D.docuLinkText,href:D.docuLink})]},true);},_getUXGuidelinesBlock:function(D){return g({items:[f({design:"Bold",text:r.getText("ENTITY_UX")}),d({emphasized:true,text:D.uxGuidelinesLinkText,href:D.uxGuidelinesLink,target:"_blank"})]},true);},_getExtendsBlock:function(D){return g({items:[f({text:r.getText("ENTITY_EXTENDS")}),d({text:D.baseTypeText,href:"entity/"+D.baseType,visible:!!D.baseTypeNav}),e({text:"N/A",visible:!D.baseTypeNav||!D.baseType})]},true);},_getApplicationComponentBlock:function(D){return _(r.getText("ENTITY_COMPONENT"),D.appComponent);},_getAvailableSinceBlock:function(D){return _(r.getText("ENTITY_SINCE"),D.entity.since);},_getCategoryBlock:function(D){return _(r.getText("ENTITY_CATEGORY"),D.entity.category);},_getContentDensityBlock:function(D){return _(r.getText("ENTITY_DENSITY"),D.entity.formFactors);}};}return this._oHeaderLayoutUtil;},backToSearch:function(){this.onNavBack();},_buildHeaderLayout:function(d){var F=0,S=1,e=2,f=3,h=[[],[],[]],o=this._getHeaderLayoutUtil(),g=[{creator:"_getApiReferenceBlock",exists:d.bHasAPIReference},{creator:"_getDocumentationBlock",exists:d.show.introLink},{creator:"_getUXGuidelinesBlock",exists:!!d.uxGuidelinesLink},{creator:"_getExtendsBlock",exists:true},{creator:"_getApplicationComponentBlock",exists:true},{creator:"_getAvailableSinceBlock",exists:true},{creator:"_getCategoryBlock",exists:true},{creator:"_getContentDensityBlock",exists:true}],i=function(){var j=0,I,G=function(j){if(j<=f){return F;}else if(j<=f*2){return S;}return e;};g.forEach(function(k){var l;if(k.exists){l=o[k.creator].call(this,d);I=G(++j);h[I].push(l);}},this);}.bind(this);i();h.forEach(function(j,I){var v=this.byId("headerColumn"+I);v.removeAllContent();if(j.length>0){v.setVisible(true);j.forEach(v.addContent,v);}},this);},_baseTypes:["sap.ui.core.any","sap.ui.core.object","sap.ui.core.function","sap.ui.core.number","sap.ui.core.float","sap.ui.core.int","sap.ui.core.boolean","sap.ui.core.string","sap.ui.core.URI","sap.ui.core.ID","sap.ui.core.void","sap.ui.core.CSSSize","any","object","function","float","int","boolean","string"],_formatTypeNav:function(t){return this._baseTypes.indexOf(t)===-1;}});});
