/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/m/Input","sap/m/library","../config/datatable","./datatable/filters/DataTableFilterDropDown","./datatable/filters/DataTableFilterRange","sap/ui/documentation/sdk/controller/util/Highlighter"],function($,I,m,d,D,a,H){"use strict";var b=m.InputType;function c(){this.oColumns=[];this.oChangedFilters=[];this.aShownRows=[];this.API=null;}c.DEFAULT_SORTING="0,asc";c.FILTER_CLASS_WRAPPER="sapUiDocumentationDatatableFilterWrapper";c.FILTER_TYPES={REGEX:"REGEX",NORMAL:"NORMAL",NUMBER:"NUMBER",SELECT:"SELECT",CELL_RANGE:"CELL_RANGE",NUMBER_RANGE:"NUMBER_RANGE"};c.prototype.destroy=function(){this.oColumns.forEach(function(C){if(C.highlighter){C.highlighter.destroy();C.highlighter=null;}C.aControls.forEach(function(o){o.destroy();});C.aControls=[];});this.oColumns=[];this.API.destroy();};c.prototype.get=function(p){return this.oConfig[p];};c.prototype.init=function(i,t,C){this.sId=i;this.oDomTable=t;this.oConfig=this.getConfig(i,C);var A=$(t).DataTable(Object.assign(this.oConfig,this.getLifeCycleMethods(i,C)));A.on('draw',function(){if(this.get("highlight")){var T=A.search();if(T||this.oChangedFilters.length){this.oColumns.forEach(function(o,e){var f=this.oChangedFilters[e]&&this.oChangedFilters[e].value,g=Array.isArray(f);if(g){f=f.reduce(function(r,h,e){if(h.value){r+=" "+h.text;}return r;},"");}if(f&&!(typeof f==="object")){if(T){T+=" "+f;}else{T=f;}}this.highlight(e,T);},this);}else{this.highlight(null,"");}}}.bind(this));A.buttons().container().insertBefore('#'+i+'_length');A.on('column-visibility.dt',function(e,s,f,v){this.onColumnVisibilityChange(f,v);}.bind(this));this.oConfig.columns.forEach(function(p,e){this.onColumnVisibilityChange(e,p.visible);},this);return this;};c.prototype.highlight=function(C,t){if(C===null){this.oColumns.forEach(function(o){o.highlighter.highlight(t);});return;}this.oColumns[C].highlighter.highlight(t);};c.prototype.onColumnVisibilityChange=function(i,v){var f=this.oColumns[i]&&this.oColumns[i].filterHeader,C=this.oDomTable.querySelector("colgroup"),o;if(C){o=C.children[i];if(o){o.classList.toggle("hidden",!v);}}if(f){f.toggle(v);}};c.prototype.handleSearch=function(s,o,e,r,f){var E,g,C,h,S=[],j;this.oChangedFilters.forEach(function(k,l){E=o[l];C=k.value;h=k.control;if(C===""){return;}switch(true){case h.hasStyleClass(c.FILTER_TYPES.NORMAL):case h.hasStyleClass(c.FILTER_TYPES.ALPHA_NUMERIC):case h.hasStyleClass(c.FILTER_TYPES.NUMBER):j=E.toLowerCase().indexOf(C.toLowerCase())>-1;break;case h.hasStyleClass(c.FILTER_TYPES.REGEX):break;case h.hasStyleClass(c.FILTER_TYPES.NUMBER_RANGE):var n=C.from!==""?C.from:Number.MIN_SAFE_INTEGER,p=C.to!==""?C.to:Number.MAX_SAFE_INTEGER,q=parseFloat(E)||0;j=(isNaN(n)&&isNaN(p))||(isNaN(n)&&q<=p)||(n<=q&&isNaN(p))||(n<=q&&q<=p);break;case h.hasStyleClass(c.FILTER_TYPES.CELL_RANGE):var t=E.split("-"),u=parseFloat(C);j=t[0]<=u&&t[1]>=u;break;case h.hasStyleClass(c.FILTER_TYPES.SELECT):var v=C.some(function(i){return i.value;});j=!v||(C.findIndex(function(w){g=s.aoData[e].anCells[l].querySelectorAll("li");var x=[];if(g.length){for(var i=0;i<g.length;i++){x[i]=g[i].textContent;}}else{x.push(E);}return w.value&&(x.indexOf(w.text)>-1);},this)>-1);break;default:j=true;}S.push(j);},this);return S.indexOf(false)<0;};c.prototype.getConfig=function(i,C){var o=[],n=JSON.parse(JSON.stringify(d.getPreset()));n.sapTableId=i;n.columnDefs=[];if(C){n.save=C['save']!==false;n.searching=C['search']!==false;n.highlight=C['highlight']!==false;if(C['excel_export']){n.buttons.push('csv');}if(C['paginate']){n.pageLength=C['paginate']>0?C['paginate']:-1;}n.columns=C.columns.map(function(e,f){var r={visible:true};r.visible=e.visible!==false;if(e.sort){var s=n.columnDefs.find(function(s){return s.type===e.sort;});if(s){s.targets.push(f);}else{n.columnDefs.push({type:e.sort,targets:[f]});}}return r;});C['initial_sort']=C['initial_sort']||c.DEFAULT_SORTING;if(C['initial_sort']!=='none'){o=C['initial_sort'].split(';');o=o.map(function(e){return e.split(',');});}n.order=o;}return n;};c.prototype.onFilterChange=function(C,o){this.oChangedFilters[C]={control:o.control,value:o.value};this.API.columns(C).draw();};c.prototype.getSelectOptions=function(C){var o=[];this.API.columns(C).data().unique().sort()[0].forEach(function(O){var e;if(o.indexOf(O)>-1){return;}try{e=$(O);}catch(f){e=null;}if(e&&e.length>0){e.find('li').each(function(i,O){if(o.indexOf(O.textContent)<0){o.push(O.textContent);}});}else{o.push(O);}});return o;};c.prototype.getLifeCycleMethods=function(i,C){var t=this;return{initComplete:function(){t.API=this.api();var T=$('#'+i+' thead'),n=$('<tr/>'),f,h,e=0;this.api().columns().every(function(){var l=e,g=C.columns[e],o=[],F,j=g.filter==="select";f=$('<th/>');f.addClass(c.FILTER_CLASS_WRAPPER);t.oColumns[e]={};t.oColumns[e].aControls=[];t.oColumns[e].filterHeader=f;if(t.get("highlight")){h=new H([].slice.call(this.nodes()),{useExternalStyles:false,shouldBeObserved:true,isCaseSensitive:false});t.oColumns[e].highlighter=h;}if(j){o=t.getSelectOptions(e);}F=c.getFilterByType(g.filter,o);if(F.control){t.oColumns[e].aControls.push(F.control);F.control.attachEvent(F.event,function(E){t.onFilterChange(l,{value:E.getParameter("value"),control:F.control});});F.control.placeAt(f);}n.append(f);e++;});T.append(n);}};};c.getFilterByType=function(t,o){var C,e="liveChange";switch(t){case'number-range':C=new a({from:new I({type:b.Number,placeholder:"From"}),to:new I({type:b.Number,placeholder:"To"})}).addStyleClass(c.FILTER_TYPES.NUMBER_RANGE);break;case'select':e="change";C=new D({options:o}).addStyleClass(c.FILTER_TYPES.SELECT);break;case'none':C='';break;default:var f=c.FILTER_TYPES.NORMAL,i=b.Text;if(t==='regex'){f=c.FILTER_TYPES.REGEX;}else if(t==='cell-range'){f=c.FILTER_TYPES.CELL_RANGE;i=b.Number;}else if(t==='number'){f=c.FILTER_TYPES.NUMBER;i=b.Number;}C=new I({type:i,placeholder:"Filter"}).addStyleClass(f);}return{control:C,event:e};};return c;});
