/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/ManagedObject","sap/ui/dt/ElementOverlay","sap/ui/dt/AggregationOverlay","sap/ui/dt/OverlayRegistry","sap/ui/dt/SelectionManager","sap/ui/dt/ElementDesignTimeMetadata","sap/ui/dt/AggregationDesignTimeMetadata","sap/ui/dt/ElementUtil","sap/ui/dt/Overlay","sap/ui/dt/OverlayUtil","sap/ui/dt/MetadataPropagationUtil","sap/ui/dt/Util","sap/ui/dt/TaskManager","sap/ui/dt/TaskRunner","sap/base/Log","sap/base/util/isPlainObject","sap/base/util/merge","sap/ui/dt/SelectionMode","sap/base/util/includes","sap/ui/dt/DesignTimeStatus","sap/base/util/restricted/_curry"],function(M,E,A,O,S,a,b,c,d,e,f,U,T,g,L,i,m,h,j,D,_){"use strict";var k=M.extend("sap.ui.dt.DesignTime",{metadata:{library:"sap.ui.dt",properties:{designTimeMetadata:{type:"object"},enabled:{type:"boolean",defaultValue:true},scope:{type:"string",defaultValue:"default"}},associations:{rootElements:{type:"sap.ui.core.Element",multiple:true}},aggregations:{plugins:{type:"sap.ui.dt.Plugin",multiple:true}},events:{addRootElement:{parameters:{element:{type:"sap.ui.core.Element"}}},addPlugin:{parameters:{plugin:{type:"sap.ui.dt.Plugin"}}},enabledChanged:{parameters:{value:{type:"boolean"}}},elementOverlayCreated:{parameters:{elementOverlay:{type:"sap.ui.dt.ElementOverlay"}}},elementOverlayDestroyed:{parameters:{elementOverlay:{type:"sap.ui.dt.ElementOverlay"}}},elementOverlayAdded:{parameters:{id:{type:"string"},targetIndex:{type:"integer"},targetId:{type:"string"},targetAggregation:{type:"string"}}},elementOverlayMoved:{parameters:{id:{type:"string"},targetIndex:{type:"integer"},targetId:{type:"string"},targetAggregation:{type:"string"}}},elementOverlayEditableChanged:{parameters:{id:{type:"string"},elementId:{type:"string"},editable:{type:"boolean"}}},elementPropertyChanged:{parameters:{id:{type:"string"},name:{type:"string"},oldValue:{type:"any"},value:{type:"any"}}},syncing:{},synced:{},syncFailed:{}}},constructor:function(){this._sStatus=D.SYNCED;this._mPendingOverlays={};this._oTaskManager=new T({complete:function(o){if(o.getSource().isEmpty()){this._registerElementOverlays();if(this._oTaskManager.isEmpty()&&this._sStatus!==D.SYNCED){this._sStatus=D.SYNCED;setTimeout(function(){if(this._sStatus===D.SYNCED){this.fireSynced();}}.bind(this),0);}}}.bind(this),add:function(o){if(o.getSource().count()===1){this._sStatus=D.SYNCING;this.fireSyncing();}}.bind(this)});this._oTaskRunner=new g({taskManager:this._oTaskManager,taskType:"applyStyles"}).run();this._oSelectionManager=new S();this._aOverlaysCreatedInLastBatch=[];M.apply(this,arguments);this.getRootElements().forEach(this._createOverlaysForRootElement,this);this.attachEvent("addRootElement",function(o){this._createOverlaysForRootElement(o.getParameter('element'));},this);this.getPlugins().forEach(function(p){p.attachEvent("processingStatusChange",this._onProcessingStatusChange,this);},this);this.attachEvent("addPlugin",function(o){var p=o.getParameter('plugin');p.attachEvent("processingStatusChange",this._onProcessingStatusChange,this);},this);this.attachEvent("enabledChanged",function(o){var v=o.getParameter('value');var $=d.getOverlayContainer();$[v?'show':'hide']();this.getRootElements().forEach(function(r){var R=O.getOverlay(r);R.setVisible(v);if(v){this._oTaskManager.add({type:"applyStyles",callbackFn:R.applyStyles.bind(R,true),overlayId:R.getId()});}}.bind(this));},this);}});k.prototype._onProcessingStatusChange=function(o){if(o.getParameter("processing")){this._oTaskManager.add({type:"pluginInProcess",plugin:o.getSource().getMetadata().getName()});}else{this._oTaskManager.completeBy({type:"pluginInProcess",plugin:o.getSource().getMetadata().getName()});}};k.prototype._onApplyStylesRequired=function(o){var p=o.getParameters();var l=o.getSource();this._oTaskManager.add({type:"applyStyles",callbackFn:l.applyStyles.bind(l,p.bForceScrollbarSync),overlayId:l.getId()},"overlayId");};k.prototype._removeOverlayFromSyncingBatch=function(o){var I=this._aOverlaysCreatedInLastBatch.indexOf(o);if(I!==-1){this._aOverlaysCreatedInLastBatch.splice(I,1);}};k.prototype._registerElementOverlays=function(){var l=this._aOverlaysCreatedInLastBatch.slice();if(!l.length){return;}var t=this._oTaskManager.add({type:"registerElementOverlays"});var p=this.getPlugins();l.forEach(function(o){O.register(o);o.attachBeforeDestroy(function(n){O.deregister(n.getSource());});});l.forEach(function(o){p.forEach(function(P){try{P.callElementOverlayRegistrationMethods(o);}catch(v){var n=U.propagateError(v,"DesignTime#_registerElementOverlays",U.printf('registerElementOverlay() method of the plugin {0} has failed for overlay with id="{1}" (element id="{2}")',P.getMetadata().getName(),o.getId(),o.getElement().getId()));L.error(U.errorToString(n));}});},this);l.forEach(function(o){try{this.fireElementOverlayCreated({elementOverlay:o});}catch(v){var n=U.propagateError(v,"DesignTime#_registerElementOverlays",U.printf('One of the listeners of elementOverlayCreated event failed while precessing the overlay with id="{0}" for element with id="{1}"',o.getId(),o.getElement().getId()));L.error(U.errorToString(n));}},this);this._aOverlaysCreatedInLastBatch=[];this._oTaskManager.complete(t);};k.prototype.exit=function(){this._bDestroyPending=true;this.getPlugins().forEach(function(p){p.destroy();});this._oSelectionManager.destroy();this._oTaskManager.destroy();this._destroyAllOverlays();this._aOverlaysCreatedInLastBatch=[];delete this._bDestroyPending;};k.prototype.getSelection=function(){return this.getSelectionManager().get();};k.prototype.getSelectionManager=function(){return this._oSelectionManager;};k.prototype.getPlugins=function(){return this.getAggregation("plugins")||[];};k.prototype.getBusyPlugins=function(){return this.getPlugins().filter(function(p){return p.isBusy();});};k.prototype.addPlugin=function(p){this.addAggregation("plugins",p);this.fireAddPlugin({plugin:p});p.setDesignTime(this);return this;};k.prototype.insertPlugin=function(p,I){this.insertAggregation("plugins",p,I);this.fireAddPlugin({plugin:p});p.setDesignTime(this);return this;};k.prototype.removePlugin=function(p){this.getPlugins().forEach(function(C){if(C===p){p.setDesignTime(null);p.detachEvent("processingStatusChange",this._onProcessingStatusChange,this);}}.bind(this));this.removeAggregation("plugins",p);return this;};k.prototype.removeAllPlugins=function(){this.getPlugins().forEach(function(p){p.setDesignTime(null);p.detachEvent("processingStatusChange",this._onProcessingStatusChange,this);}.bind(this));this.removeAllAggregation("plugins");return this;};k.prototype.getRootElements=function(){return(this.getAssociation("rootElements")||[]).map(function(s){return c.getElementInstance(s);});};k.prototype.getDesignTimeMetadataFor=function(o){var C;if(typeof o==='string'){C=o;L.error('sap.ui.dt.DesignTime#getDesignTimeMetadataFor / Function getDesignTimeMetadataFor() should be called with element instance');}else{C=o.getMetadata().getName();}return(this.getDesignTimeMetadata()||{})[C];};k.prototype.addRootElement=function(r){this.addAssociation("rootElements",r);this.fireAddRootElement({element:r});};k.prototype._createOverlaysForRootElement=function(r){var t=this._oTaskManager.add({type:"createOverlay",element:r,root:true});this.createOverlay({element:c.getElementInstance(r),root:true,visible:this.getEnabled()}).then(function(o){d.getOverlayContainer().append(o.render());this._oTaskManager.add({type:"applyStyles",callbackFn:o.applyStyles.bind(o),overlayId:o.getId()},"overlayId");this._oTaskManager.complete(t);return o;}.bind(this),function(v){var o=U.propagateError(v,"DesignTime#_createOverlaysForRootElement",U.printf('Root element with id = "{0}" initialization is failed',r.getId()));L.error(U.errorToString(o));this._oTaskManager.cancel(t);this.fireSyncFailed({error:o});}.bind(this));};k.prototype.removeRootElement=function(r){this.removeAssociation("rootElements",r);this._destroyOverlaysForElement(c.getElementInstance(r));return this;};k.prototype.removeAllRootElement=function(){this.removeAssociation("rootElements");this._destroyAllOverlays();return this;};k.prototype.getElementOverlays=function(){var l=[];this._iterateRootElements(function(r){l=l.concat(this._getAllElementOverlaysIn(r));},this);return l;};k.prototype.createOverlay=function(v){var p=Object.assign({},i(v)?v:{element:v});var t=this._oTaskManager.add({type:'createOverlay'});if(!p.element||!c.isElementValid(p.element)){this._oTaskManager.cancel(t);return this._rejectCreateOverlay(p.element);}var s=p.element.getId();var o=O.getOverlay(s);if(o){this._oTaskManager.complete(t);return Promise.resolve(o);}else if(s in this._mPendingOverlays){this._oTaskManager.complete(t);return this._mPendingOverlays[s];}if(typeof p.root==="undefined"){p.root=true;}this._mPendingOverlays[s]=this._createElementOverlay(p).then(function(o){return this._createChildren(o,p.parentMetadata).then(function(){this.attachEventOnce("synced",function(){delete this._mPendingOverlays[s];},this);if(this.bIsDestroyed){o.detachEvent('destroyed',this._onElementOverlayDestroyed,this);o.destroy();this._oTaskManager.cancel(t);return Promise.reject(U.createError("DesignTime#createOverlay","while creating overlay, DesignTime instance has been destroyed"));}else if(o.bIsDestroyed){this._oTaskManager.cancel(t);return Promise.reject(U.createError("DesignTime#createOverlay","while creating children overlays, its parent overlay has been destroyed"));}this._aOverlaysCreatedInLastBatch.push(o);this._oTaskManager.complete(t);return o;}.bind(this));}.bind(this)).catch(function(l){var n=U.propagateError(l,'DesignTime#createOverlay',U.printf("Failed attempt to create overlay for '{0}'",s));delete this._mPendingOverlays[s];this._oTaskManager.cancel(t);return Promise.reject(n);}.bind(this));return this._mPendingOverlays[s];};k.prototype._rejectCreateOverlay=function(o){var r;if(!o){r="Cannot create overlay — no element is specified.";}else if(o.bIsDestroyed){r="Cannot create overlay — the element is already destroyed.";}else if(o instanceof M&&!c.isElementInTemplate(o)){r="Element is in a bound aggregation, but not found in the binding template. Skipping overlay creation for element with id='"+o.getId()+"'. Please report to CA-UI5-FL-RTA component.";}else{r=U.printf("Cannot create overlay without a valid element. Expected a descendant of sap.ui.core.Element or sap.ui.core.Component, but {0} was given",U.getObjectType(o));}return Promise.reject(U.createError("DesignTime#createOverlay",r));};k.prototype._createElementOverlay=function(p){var o=p.element;function l(P){return new E(P);}return new Promise(function(r,R){l({element:o,isRoot:p.root,visible:typeof p.visible!=="boolean"||p.visible,metadataScope:this.getScope(),designTimeMetadata:(this.getDesignTimeMetadataFor(o)instanceof a?this.getDesignTimeMetadataFor(o):_(function(n,P,o,q){q=m({},q,n);this._mMetadataOriginal=q;if(P){q=f.propagateMetadataToElementOverlay(q,P,o);}return q;})(this.getDesignTimeMetadataFor(o),p.parentMetadata,o)),init:function(n){var q=n.getSource();r(n.getSource());q.attachEvent('destroyed',this._onElementOverlayDestroyed,this);q.attachEvent('elementDestroyed',this._onElementDestroyed,this);q.attachEvent('selectionChange',this._onElementOverlaySelectionChange,this);q.attachEvent('elementModified',this._onElementModified,this);q.attachEvent('editableChange',this._onEditableChanged,this);q.attachEvent('applyStylesRequired',this._onApplyStylesRequired,this);}.bind(this),initFailed:function(s,n){var q=n.getSource();var t=U.propagateError(n.getParameter('error'),'DesignTime#_createElementOverlay',U.printf("Can't create overlay properly (id='{0}') for '{1}'",q.getId(),s));q.detachEvent('destroyed',this._onElementOverlayDestroyed,this);q.detachEvent('elementDestroyed',this._onElementDestroyed,this);q.detachEvent('applyStylesRequired',this._onApplyStylesRequired,this);q.destroy();R(t);}.bind(this,o.getId())});}.bind(this));};k.prototype._createChildren=function(o,p){return Promise.all(o.getAggregationNames().map(function(s){var l=o.getElement();var n=l.getMetadata().getName();var q=f.propagateMetadataToAggregationOverlay(o.getDesignTimeMetadata().getAggregation(s),l,p);var r=new A({aggregationName:s,element:l,designTimeMetadata:new b({data:q}),init:function(t){var r=t.getSource();r.attachEvent('destroyed',this._onAggregationOverlayDestroyed,this);r.attachEvent('applyStylesRequired',this._onApplyStylesRequired,this);}.bind(this),beforeDestroy:function(t){var r=t.getSource();O.deregister(r);r.detachEvent('applyStylesRequired',this._onApplyStylesRequired,this);}.bind(this)});O.register(r);return Promise.all(c[r.isAssociation()?'getAssociationInstances':'getAggregation'](l,s).map(function(P,l){return this.createOverlay({element:l,root:false,parentMetadata:q}).catch(function(t){var u=this._enrichChildCreationError(t,l,P,s);L[u.severity](u.message);return u.errorObject;}.bind(this));}.bind(this,n))).then(function(C){C.map(function(t){if(t instanceof E&&!t.bIsDestroyed){r.addChild(t,true);}},this);return r;}.bind(this));},this)).then(function(l){l.forEach(function(n){if(o.bIsDestroyed){n.destroy();}else{o.addChild(n,true);}});});};k.prototype._enrichChildCreationError=function(o,l,p,s){var n="error";var q=U.errorToString(o);if(o.message.includes("Cannot create overlay without a valid element")){n="warning";o=U.createError("DesignTime#_createChildren",U.printf(["Child element in aggregation '{0}' of {1} must be a descendant of sap.ui.core.Element or ","sap.ui.core.Component, but {2} was give. Consider ignoring the aggregation '{0}' ","in the .designtime configuration of the control."].join(''),s,p,U.getObjectType(l)));q=o.toString();}else if(o.message.startsWith("Element is in a bound aggregation")){n="error";q=o.toString();}return{errorObject:o,severity:n,message:q};};k.prototype._destroyOverlaysForElement=function(o){var l=O.getOverlay(o);if(l){l.destroy();}};k.prototype._destroyAllOverlays=function(){this._iterateRootElements(function(r){this._destroyOverlaysForElement(r);},this);};k.prototype._onElementOverlayDestroyed=function(o){if(this._bDestroyPending){return;}var l=o.getSource();var s=l.getAssociation('element');if(s in this._mPendingOverlays){this._removeOverlayFromSyncingBatch(l);delete this._mPendingOverlays[s];return;}if(!O.hasOverlays()){d.destroyMutationObserver();d.removeOverlayContainer();}if(l.isSelected()){this.getSelectionManager().remove(l);}this.fireElementOverlayDestroyed({elementOverlay:l});};k.prototype._onElementDestroyed=function(o){var s=o.getParameter("targetId");this.removeRootElement(s);};k.prototype._onAggregationOverlayDestroyed=function(){if(!O.hasOverlays()){d.removeOverlayContainer();}};k.prototype._onElementOverlaySelectionChange=function(o){var l=o.getSource();var s=o.getParameter("selected");if(s){if(this.getSelectionManager().getSelectionMode()===h.Multi){this.getSelectionManager().add(l);}else{this.getSelectionManager().set(l);}if(!j(this.getSelectionManager().get(),l)){l.setSelected(false);}}else{this.getSelectionManager().remove(l);}};k.prototype._onElementModified=function(o){var p=m({},o.getParameters());var l=o.getSource();p.type=!p.type?o.getId():p.type;switch(p.type){case"addOrSetAggregation":case"insertAggregation":this._onAddAggregation(p.value,p.target,p.name);break;case"setParent":setTimeout(function(){if(!this.bIsDestroyed){this._checkIfOverlayShouldBeDestroyed(p.target);}}.bind(this),0);break;case"propertyChanged":p.id=o.getSource().getId();delete p.type;delete p.target;if(this.getStatus()===D.SYNCING){this.attachEventOnce("synced",p,function(){if(!l.bIsDestroyed){this.fireElementPropertyChanged(arguments[1]);}},this);}else{this.fireElementPropertyChanged(p);}break;}};k.prototype._onEditableChanged=function(o){var p=m({},o.getParameters());var l=o.getSource();p.id=l.getId();if(this.getStatus()===D.SYNCING){this.attachEventOnce("synced",p,function(){if(!l.bIsDestroyed){this.fireElementOverlayEditableChanged(arguments[1]);}},this);}else{this.fireElementOverlayEditableChanged(p);}};k.prototype._onAddAggregation=function(o,p,s){if(c.isElementValid(o)){var P=O.getOverlay(p);var l=P&&P.getAggregationOverlay(s);if(!l){var n;var q=function(r){var t=r.getParameter('elementOverlay');if(t.getElement().getId()===p.getId()){var l=t.getAggregationOverlay(s);this.detachSynced(n,this);this.detachElementOverlayCreated(q,this);this._addAggregation(o,l);}};n=function(){var P=O.getOverlay(p);var l=P&&P.getAggregationOverlay(s);this.detachSynced(n,this);this.detachElementOverlayCreated(q,this);this._addAggregation(o,l);};this.attachElementOverlayCreated(q,this);this.attachSynced(n,this);}else{return this._addAggregation(o,l);}}};k.prototype._addAggregation=function(o,p){var l=O.getOverlay(o);if(!l&&p&&p.getElement()){var t=this._oTaskManager.add({type:'createChildOverlay',element:o});this.createOverlay({element:o,root:false,parentMetadata:p.getDesignTimeMetadata().getData()}).then(function(l){var I=p.insertChild(null,l);if(I===true){this._oTaskManager.add({type:"applyStyles",callbackFn:l.applyStyles.bind(l),overlayId:l.getId()},"overlayId");var n=p.indexOfAggregation('children',l);this.attachEventOnce("synced",l,function(){if(!l.bIsDestroyed){this.fireElementOverlayAdded({id:l.getId(),targetIndex:n,targetId:p.getId(),targetAggregation:p.getAggregationName()});}},this);}this._oTaskManager.complete(t);}.bind(this)).catch(function(s,n,v){this._oTaskManager.cancel(t);var q=U.propagateError(v,"DesignTime#_onAddAggregation",U.printf("Failed to add new element overlay (elementId='{0}') into aggregation overlay (id='{1}')",s,n));if(!o.bIsDestroyed&&!p.bIsDestroyed){L.error(U.errorToString(q));}}.bind(this,o.getId(),p.getId()));}else{if(l&&!this._isElementInRootElements(l)&&l.isRoot()){l.setIsRoot(false);}if(p){p.insertChild(null,l);}else{L.error("No parentAggregationOverlay exists during addAggregation");return;}l.setDesignTimeMetadata(f.propagateMetadataToElementOverlay(l._mMetadataOriginal,p.getDesignTimeMetadata().getData(),o));this.fireElementOverlayMoved({id:l.getId(),targetIndex:p.indexOfAggregation('children',l),targetId:p.getId(),targetAggregation:p.getAggregationName()});}};k.prototype._checkIfOverlayShouldBeDestroyed=function(o){var l=O.getOverlay(o);if(!o.bIsDestroyed&&l&&(!this._isElementInRootElements(o)||o.sParentAggregationName==="dependents")){l.destroy();}};k.prototype._isElementInRootElements=function(o){var F=false;this._iterateRootElements(function(r){if(c.hasAncestor(o,r)){F=true;return false;}});return F;};k.prototype._iterateRootElements=function(s,o){var r=this.getRootElements();r.forEach(function(R){var l=c.getElementInstance(R);s.call(o||this,l);},this);};k.prototype._getAllElementOverlaysIn=function(o){var l=[];var n=O.getOverlay(o);if(n){e.iterateOverlayElementTree(n,function(C){if(C.getDesignTimeMetadata()){l.push(C);}});}return l;};k.prototype.setEnabled=function(v){v=!!v;if(this.getEnabled()!==v){this.setProperty('enabled',v);this.fireEnabledChanged({value:v});}};k.prototype.getStatus=function(){return this._sStatus;};return k;});
