//@ui5-bundle sap/ui/fl/library-preload.js
/*
 * ! OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/fl/ControlPersonalizationAPI',["sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/Layer","sap/ui/fl/Utils","sap/ui/fl/LayerUtils","sap/ui/fl/registry/ChangeRegistry","sap/ui/fl/FlexControllerFactory","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/core/Element","sap/ui/base/ManagedObject","sap/base/util/includes","sap/ui/fl/variants/VariantManagement","sap/ui/fl/apply/_internal/controlVariants/URLHandler","sap/ui/core/Component","sap/base/Log","sap/ui/thirdparty/jquery"],function(F,L,U,a,C,b,J,E,M,i,V,c,d,e,q){"use strict";var f={_determineParameters:function(o,I,u){var A=U.getAppComponentForControl(o);var g=b.createForControl(A);var r=A.getRootControl();var p={rootControl:r,flexController:g};if(!I){var v;var h;var j;p.variantModel=A.getModel(U.VARIANT_MODEL_NAME);p.variantManagement={};if(!u){v=q.makeArray(p.rootControl.$().find(".sapUiFlVarMngmt"));}if(u||v.length===0){v=q.makeArray(q(sap.ui.getCore().getStaticAreaRef()).find(".sapUiFlVarMngmt"));}v.map(function(k){h=sap.ui.getCore().byId(k.id);if(h.getMetadata().getName()==="sap.ui.fl.variants.VariantManagement"){j=h.getFor();j.forEach(function(s){p.variantManagement[s]=p.variantModel.getLocalId(k.id,A);});}});}return p;},_getVariantManagement:function(o,p){p=p||this._determineParameters(o);var g=function(o){if(!p.variantManagement[o.getId()]&&o.getParent()&&o.getId()!==p.rootControl.getId()){return g(o.getParent());}else if(!o.getParent()||o.getId()===p.rootControl.getId()){return p.variantManagement[o.getId()]||"";}return p.variantManagement[o.getId()];};return g(o);},clearVariantParameterInURL:function(o){var u;var A=U.getAppComponentForControl(o);var v=A instanceof d?A.getModel(U.VARIANT_MODEL_NAME):undefined;if(!v){e.warning("Variant model could not be found on the provided control");}if(o instanceof V){var s=v.getLocalId(o.getId(),A);var m=c.removeURLParameterForVariantManagement({model:v,vmReference:s});u=m.parameters;}c.update({parameters:u||[],updateURL:true,updateHashEntry:!!v,model:v||{},silent:!v});},activateVariant:function(v,s){return Promise.resolve().then(function(){var o;if(typeof v==='string'||v instanceof String){o=d.get(v);if(!(o instanceof d)){o=sap.ui.getCore().byId(v);if(!(o instanceof E)){throw new Error("No valid component or control found for the provided ID");}}}else if(v instanceof d||v instanceof E){o=v;}var A=U.getAppComponentForControl(o);if(!A){throw new Error("A valid variant management control or component (instance or ID) should be passed as parameter");}var g=A.getModel(U.VARIANT_MODEL_NAME);if(!g){throw new Error("No variant management model found for the passed control or application component");}var h=g.getVariantManagementReference(s).variantManagementReference;if(!h){throw new Error("A valid control or component, and a valid variant/ID combination are required");}return g.waitForVMControlInit(h).then(function(){return g.updateCurrentVariant(h,s,A);});})["catch"](function(o){e.error(o);return Promise.reject(o);});},_checkChangeSpecificData:function(o,l){if(!o.changeSpecificData){return Promise.reject(new Error("No changeSpecificData available"));}if(!o.changeSpecificData.changeType){return Promise.reject(new Error("No valid changeType"));}if(!(o.selectorControl instanceof E)){return Promise.reject(new Error("No valid selectorControl"));}var s=o.selectorControl.getMetadata().getName();var g=C.getInstance();return g.getChangeHandler(o.changeSpecificData.changeType,s,o.selectorControl,J,l);},addPersonalizationChanges:function(p){var A=[];var s=[];var l=a.getCurrentLayer(true);var P=[];function g(o,m){return f._checkChangeSpecificData(o,l).then(function(){p.params=f._determineParameters(o.selectorControl,p.ignoreVariantManagement,p.useStaticArea);if(!p.ignoreVariantManagement){if(!o.changeSpecificData.variantReference){var v=f._getVariantManagement(o.selectorControl,p.params);if(v){var j=p.params.variantModel.oData[v].currentVariant;o.changeSpecificData.variantReference=j;}}}else{delete o.changeSpecificData.variantReference;}return p.params.flexController.addChange(Object.assign(m,o.changeSpecificData),o.selectorControl);}).then(function(j){o.changeInstance=j;A.push(o);}).catch(function(j){return Promise.reject({change:o,message:j.message});});}function h(o){return p.params.flexController.applyChange(o.changeInstance,o.selectorControl).then(function(){s.push(o.changeInstance);}).catch(function(j){return Promise.reject({change:o,message:j.message});});}p.controlChanges.forEach(function(o){var m={};Object.assign(m,{developerMode:false,layer:l});P.push(g.bind(undefined,o,m));});return U.execPromiseQueueSequentially(P).then(function(){P=[];A.forEach(function(o){P.push(h.bind(undefined,o));});return U.execPromiseQueueSequentially(P);}).then(function(){return s;});},isPersonalized:function(g,h){if(!g||g.length===0){return this._reject("At least one control ID has to be provided as a parameter");}var A=g[0].appComponent||U.getAppComponentForControl(g[0]);if(!A){return this._reject("App Component could not be determined");}var I=g.map(function(j){return j.id||j.getId();});var o=b.createForControl(A);return o.getComponentChanges({currentLayer:L.USER,includeCtrlVariants:true}).then(function(j){return j.filter(this._filterBySelectors.bind(this,A,I)).filter(this._filterByChangeType.bind(this,h)).some(this._ifValidFileType);}.bind(this));},_reject:function(m){e.error(m);return Promise.reject(m);},_filterBySelectors:function(A,I,o){var s=o.getSelector();var g=J.getControlIdBySelector(s,A);return i(I,g);},_filterByChangeType:function(g,o){return(Array.isArray(g)&&g.length>0)?i(g,o.getChangeType()):true;},_ifValidFileType:function(o){return o.getFileType()==="change";},resetChanges:function(g,h){if(!g||g.length===0){return this._reject("At least one control ID has to be provided as a parameter");}var A=g[0].appComponent||U.getAppComponentForControl(g[0]);if(!A){return this._reject("App Component could not be determined");}var s=g.map(function(v){var j=v.id||v.getId();var l=A.getLocalId(j);return l||j;});var o=b.createForControl(A);return o.resetChanges(L.USER,undefined,A,s,h);},saveChanges:function(g,m){if(!(m instanceof M)){var s="A valid sap.ui.base.ManagedObject instance is required as a parameter";e.error(s);return Promise.reject(s);}var p=f._determineParameters(m);var A=U.getAppComponentForControl(m);var v=Object.keys(p.variantManagement).reduce(function(r,h){return r.concat([p.variantManagement[h]]);},[]);return p.flexController.saveSequenceOfDirtyChanges(g,A).then(function(r){p.variantModel.checkDirtyStateForControlModels(v);return r;});},hasVariantManagement:function(o){try{return!!this._getVariantManagement(o);}catch(g){e.error(g.message);return false;}}};return f;},true);
sap.ui.predefine('sap/ui/fl/FakeLrepConnectorLocalStorage',["sap/ui/fl/FakeLrepConnector","sap/ui/fl/write/_internal/connectors/LocalStorageConnector"],function(F,L){"use strict";return{enableFakeConnector:function(p){var j=p?p.sInitialComponentJsonPath:undefined;F.setFlexibilityServicesAndClearCache("LocalStorageConnector",j);},disableFakeConnector:function(){F.disableFakeConnector();},forTesting:{spyWrite:function(s,a){return F.forTesting.spyMethod(s,a,L,"write");},getNumberOfChanges:function(r){return F.forTesting.getNumberOfChanges(L,r);},synchronous:{clearAll:function(){F.forTesting.synchronous.clearAll(window.localStorage);},store:function(k,i){F.forTesting.synchronous.store(window.localStorage,k,i);}}}};},true);
sap.ui.predefine('sap/ui/fl/FakeLrepConnectorSessionStorage',["sap/ui/fl/FakeLrepConnector","sap/ui/fl/write/_internal/connectors/SessionStorageConnector"],function(F,S){"use strict";return{enableFakeConnector:function(p){var j=p?p.sInitialComponentJsonPath:undefined;F.setFlexibilityServicesAndClearCache("SessionStorageConnector",j);},disableFakeConnector:function(){F.disableFakeConnector();},forTesting:{spyWrite:function(s,a){return F.forTesting.spyMethod(s,a,S,"write");},getNumberOfChanges:function(r){return F.forTesting.getNumberOfChanges(S,r);},clear:function(p){return F.forTesting.clear(S,p);},setStorage:function(n){F.forTesting.setStorage(S,n);},synchronous:{clearAll:function(){F.forTesting.synchronous.clearAll(window.sessionStorage);},getNumberOfChanges:function(r){return F.forTesting.synchronous.getNumberOfChanges(S.storage,r);}}}};},true);
sap.ui.predefine('sap/ui/fl/FakeLrepLocalStorage',["sap/ui/fl/FakeLrepConnectorLocalStorage"],function(F){"use strict";return{deleteChanges:function(){return F.forTesting.synchronous.clearAll();}};},true);
sap.ui.predefine('sap/ui/fl/Layer',[],function(){"use strict";return{USER:"USER",CUSTOMER:"CUSTOMER",CUSTOMER_BASE:"CUSTOMER_BASE",PARTNER:"PARTNER",VENDOR:"VENDOR",BASE:"BASE"};});
sap.ui.predefine('sap/ui/fl/apply/_internal/ChangesController',["sap/ui/fl/FlexControllerFactory","sap/ui/fl/Utils"],function(O,F){"use strict";var C={getFlexControllerInstance:function(s){if(typeof s==="string"){return O.create(s);}var m=s.appComponent||s;return O.createForControl(m);},getDescriptorFlexControllerInstance:function(s){if(typeof s.appId==="string"){return O.create(s.appId);}var a=s.appComponent||s;var A=F.getAppDescriptorComponentObjectForControl(a);return O.create(A.name);},getAppComponentForSelector:function(s){if(typeof s.appId==="string"){return s;}return s.appComponent||F.getAppComponentForControl(s);}};return C;},true);
sap.ui.predefine('sap/ui/fl/apply/_internal/appVariant/DescriptorChangeTypes',[],function(){"use strict";return{getChangeTypes:function(){return["appdescr_ovp_addNewCard","appdescr_ovp_removeCard","appdescr_ovp_changeCard","appdescr_app_addNewInbound","appdescr_app_changeInbound","appdescr_app_removeInbound","appdescr_app_removeAllInboundsExceptOne","appdescr_app_addNewOutbound","appdescr_app_changeOutbound","appdescr_app_removeOutbound","appdescr_app_addNewDataSource","appdescr_app_changeDataSource","appdescr_app_removeDataSource","appdescr_app_addAnnotationsToOData","appdescr_app_addTechnicalAttributes","appdescr_app_removeTechnicalAttributes","appdescr_app_setTitle","appdescr_app_setSubTitle","appdescr_app_setShortTitle","appdescr_app_setDescription","appdescr_app_setInfo","appdescr_app_setDestination","appdescr_app_setKeywords","appdescr_app_setAch","appdescr_app_addCdsViews","appdescr_app_removeCdsViews","appdescr_flp_setConfig","appdescr_ui5_addNewModel","appdescr_ui5_addNewModelEnhanceWith","appdescr_ui5_removeModel","appdescr_ui5_replaceComponentUsage","appdescr_ui5_setMinUI5Version","appdescr_smb_addNamespace","appdescr_smb_changeNamespace","appdescr_ui_generic_app_setMainPage","appdescr_ui_setIcon","appdescr_ui_setDeviceTypes","appdescr_ui5_addLibraries","appdescr_ui5_setFlexExtensionPointEnabled","appdescr_url_setUri","appdescr_fiori_setRegistrationIds","appdescr_card","appdescr_card_designtime"];},getCondensableChangeTypes:function(){return["appdescr_app_setTitle","appdescr_app_setInfo","appdescr_app_setShortTitle","appdescr_app_setSubTitle","appdescr_app_setDescription","appdescr_app_setDestination","appdescr_app_setKeywords","appdescr_app_setAch","appdescr_ui_setIcon","appdescr_ui_setDeviceTypes","appdescr_ui_setIcon","appdescr_ui_setDeviceTypes","appdescr_fiori_setRegistrationIds","appdescr_smb_changeNamespace"];}};});
sap.ui.predefine('sap/ui/fl/apply/_internal/changes/Applier',["sap/base/Log","sap/ui/core/Element","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/apply/_internal/changes/FlexCustomData","sap/ui/fl/apply/_internal/changes/Utils","sap/ui/fl/apply/_internal/flexState/changes/DependencyHandler","sap/ui/fl/Utils"],function(L,E,J,F,U,D,a){"use strict";var l=new a.FakePromise();
function _(C,p){var s=C.getSelector&&C.getSelector();if(!s||(!s.id&&!s.name)){throw Error("No selector in change found or no selector ID.");}var o=p.modifier.bySelector(s,p.appComponent,p.view);if(!o){throw Error("A flexibility change tries to change a nonexistent control.");}var h=C.getDependentControlSelectorList();h.forEach(function(i){var j=p.modifier.bySelector(i,p.appComponent,p.view);if(!j){throw Error("A dependent selector control of the flexibility change is not available.");}});return o;}
function b(C,o,m,h,p){var x=f(p);var i=U.getControlIfTemplateAffected(o,C,p);var I=F.hasChangeApplyFinishedCustomData(i.control,o,p.modifier);var j=o.isApplyProcessFinished();if(j&&!I){if(!x){var k=U.checkIfDependencyIsStillValid.bind(null,p.appComponent,p.modifier,m);m=h._oChangePersistence.copyDependenciesFromInitialChangesMap(o,k,p.appComponent);}o.setInitialApplyState();}else if(!j&&I){o.markFinished();}return m;}
function c(C,p){var s;if(f(p)&&C.getDefinition().jsOnly){s="Change cannot be applied in XML. Retrying in JS.";}if(s){C.setInitialApplyState();throw Error(s);}}
function d(C,m,i,p){if(i instanceof E){m.control=i;}if(m.control){p.modifier.updateAggregation(m.originalControl,C.getContent().boundAggregation);}F.addAppliedCustomData(m.control,C,p,f(p));var r={success:true};C.markFinished(r);return r;}
function e(o,C,m,p){var x=f(p);var r={success:false,error:o};var s=C.getId();var h="Change ''{0}'' could not be applied.";var i=o instanceof Error;var j=F.getCustomDataIdentifier(false,i,x);switch(j){case F.notApplicableChangesCustomDataKey:a.formatAndLogMessage("info",[h,o.message],[s]);break;case F.failedChangesCustomDataKeyXml:a.formatAndLogMessage("warning",[h,"Merge error detected while processing the XML tree."],[s],o.stack);break;case F.failedChangesCustomDataKeyJs:a.formatAndLogMessage("error",[h,"Merge error detected while processing the JS control tree."],[s],o.stack);break;}F.addFailedCustomData(m.control,C,p,j);if(x){C.setInitialApplyState();}else{C.markFinished(r);}return r;}
function f(p){return p.modifier.targets==="xmlTree";}
function g(o,C){var h=C.getDefinition();var s=h.changeType;var t=h.selector.id;var i=h.namespace+h.fileName+"."+h.fileType;var w="A flexibility change could not be applied.";w+="\nThe displayed UI might not be displayed as intedend.";if(o.message){w+="\n   occurred error message: '"+o.message+"'";}w+="\n   type of change: '"+s+"'";w+="\n   LRep location of the change: "+i;w+="\n   id of targeted control: '"+t+"'.";L.warning(w,undefined,"sap.ui.fl.apply._internal.changes.Applier");}
var A={addPreConditionForInitialChangeApplying:function(p){l=l.then(function(){return p;});},applyChangeOnControl:function(C,o,p){var m=U.getControlIfTemplateAffected(C,o,p);return U.getChangeHandler(C,m,p).then(function(h){c(C,p);return h;}).then(function(h){if(C.hasApplyProcessStarted()){return C.addPromiseForApplyProcessing().then(function(r){C.markFinished();return r;});}else if(!C.isApplyProcessFinished()){return new a.FakePromise().then(function(){C.startApplying();return h.applyChange(C,m.control,p);}).then(function(i){return d(C,m,i,p);}).catch(function(i){return e(i,C,m,p);});}var r={success:true};C.markFinished(r);return r;}).catch(function(h){return{success:false,error:h};});},applyAllChangesForControl:function(G,o,h,C){var m=G();var s=C.getId();var i=m.mChanges[s]||[];i.forEach(function(j){if(!j.isApplyProcessFinished()&&!j._ignoreOnce){j.setQueuedForApply();}});l=l.then(function(C){var p=[];var s=C.getId();var i=m.mChanges[s]||[];var P={modifier:J,appComponent:o,view:a.getViewForControl(C)};var j;if(m.mControlsWithDependencies[s]){D.removeControlsDependencies(m,s);j=true;}i.forEach(function(k){m=b(C,k,m,h,P);if(k._ignoreOnce){delete k._ignoreOnce;}else if(k.isApplyProcessFinished()){D.resolveDependenciesForChange(m,k.getId(),s);}else if(!m.mDependencies[k.getId()]){p.push(function(){return A.applyChangeOnControl(k,C,P).then(function(){D.resolveDependenciesForChange(m,k.getId(),s);});});}else{var n=A.applyChangeOnControl.bind(A,k,C,P);D.addChangeApplyCallbackToDependency(m,k.getId(),n);}});if(i.length||j){return a.execPromiseQueueSequentially(p).then(function(){return D.processDependentQueue(m,o,s);});}}.bind(null,C));return l;},applyAllChangesForXMLView:function(p,C){if(!Array.isArray(C)){var s="No list of changes was passed for processing the flexibility on view: "+p.view+".";L.error(s,undefined,"sap.ui.fl.apply._internal.changes.Applier");C=[];}return C.reduce(function(P,o){return P.then(function(){var h=_(o,p);o.setQueuedForApply();b(h,o,undefined,undefined,p);if(!o.isApplyProcessFinished()){return A.applyChangeOnControl(o,h,p);}return{success:true};}).then(function(r){if(!r.success){throw Error(r.error);}}).catch(function(h){g(h,o);});},new a.FakePromise()).then(function(){return p.view;});}};return A;},true);
sap.ui.predefine('sap/ui/fl/apply/_internal/changes/Reverter',["sap/base/Log","sap/ui/fl/apply/_internal/changes/FlexCustomData","sap/ui/fl/apply/_internal/changes/Utils","sap/ui/fl/Utils"],function(L,F,U,a){"use strict";
function _(c){if(!c.isApplyProcessFinished()&&c.hasApplyProcessStarted()){return c.addPromiseForApplyProcessing().then(function(r){if(r&&r.error){c.markRevertFinished(r.error);throw Error(r.error);}});}}
var R={revertChangeOnControl:function(c,C,p){var m=U.getControlIfTemplateAffected(c,C,p);var o;return U.getChangeHandler(c,m,p).then(function(r){o=r;}).then(_.bind(null,c)).then(function(){if(c.isApplyProcessFinished()){if(!c.hasRevertData()){c.setRevertData(F.getParsedRevertDataFromCustomData(C,c,p.modifier));}c.startReverting();return o.revertChange(c,m.control,p);}throw Error("Change was never applied");}).then(function(){m.control=p.modifier.bySelector(c.getSelector(),p.appComponent,p.view);if(m.bTemplateAffected){p.modifier.updateAggregation(m.control,c.getContent().boundAggregation);}c.markRevertFinished();return m.control;}).catch(function(e){var E="Change could not be reverted: "+e.message;L.error(E);c.markRevertFinished(E);return false;});},revertMultipleChanges:function(c,p){var P=[];c.forEach(function(C){C.setQueuedForRevert();P.push(function(){var s=C.getSelector&&C.getSelector();var o=p.modifier.bySelector(s,p.appComponent);if(!o){L.warning("A flexibility change tries to revert changes on a nonexistent control with id "+s.id);return new a.FakePromise();}var r={modifier:p.modifier,appComponent:p.appComponent,view:a.getViewForControl(o)};return R.revertChangeOnControl(C,o,r).then(function(v){F.destroyAppliedCustomData(v||o,C,p.modifier);return!!v;}).then(function(S){if(S){p.flexController._oChangePersistence._deleteChangeInMap(C);}});});});return a.execPromiseQueueSequentially(P);}};return R;},true);
sap.ui.predefine('sap/ui/fl/apply/_internal/changes/Utils',["sap/ui/fl/apply/_internal/changes/FlexCustomData","sap/ui/fl/Utils","sap/ui/fl/registry/ChangeHandlerRegistration","sap/ui/fl/registry/ChangeRegistry"],function(F,a,C,b){"use strict";var U={getControlIfTemplateAffected:function(c,o,p){var m=p.modifier;var d=c.getDefinition();var e={originalControl:o};var O=d.dependentSelector&&d.dependentSelector.originalSelector;if(c.getContent().boundAggregation&&O){e.control=m.bySelector(O,p.appComponent,p.view);e.controlType=m.getControlType(e.control);e.bTemplateAffected=true;}else{e.control=o;e.controlType=m.getControlType(o);e.bTemplateAffected=false;}return e;},getChangeHandler:function(c,m,p){var l=p.modifier.getLibraryName(m.control);var w=new a.FakePromise();if(C.isChangeHandlerRegistrationInProgress(l)){w=C.waitForChangeHandlerRegistration(l);}return w.then(function(){var s=c.getChangeType();var L=c.getLayer();var o=b.getInstance();o.initSettings();return o.getChangeHandler(s,m.controlType,m.control,p.modifier,L);});},checkIfDependencyIsStillValid:function(A,m,c,s){var o=a.getChangeFromChangesMap(c.mChanges,s);var d=m.bySelector(o.getSelector(),A);if(F.hasChangeApplyFinishedCustomData(d,o,m)||o.hasApplyProcessStarted()){return false;}return true;}};return U;});
sap.ui.predefine('sap/ui/fl/apply/_internal/connectors/ObjectStorageConnector',["sap/ui/fl/apply/_internal/connectors/ObjectStorageUtils","sap/ui/fl/initial/_internal/StorageUtils"],function(O,S){"use strict";
function l(p){var f=[];return O.forEachObjectInStorage(p,function(F){f.push(F.changeDefinition);}).then(function(){return f;});}
var a={oStorage:undefined,layers:["ALL"],loadFlexData:function(p){return l({storage:this.oStorage,reference:p.reference}).then(function(f){var g=S.getGroupedFlexObjects(f);return S.filterAndSortResponses(g);});}};a.storage=a.oStorage;return a;});
sap.ui.predefine('sap/ui/fl/apply/_internal/connectors/ObjectStorageUtils',[],function(){"use strict";var F="sap.ui.fl";return{forEachObjectInStorage:function(p,P){var r=p.storage.getItems&&p.storage.getItems()||p.storage;return Promise.resolve(r).then(function(r){var a=Object.keys(r).map(function(k){var i=k.includes(F);if(!i){return;}var s=r[k];var f=p.storage._itemsStoredAsObjects?s:JSON.parse(s);var S=true;if(p.reference){S=f.reference===p.reference||f.reference+".Component"===p.reference;}var b=true;if(p.layer){b=f.layer===p.layer;}if(!S||!b){return;}return P({changeDefinition:f,key:k});});return Promise.all(a);});},getAllFlexObjects:function(p){var f=[];return this.forEachObjectInStorage(p,function(m){f.push(m);}).then(function(){return f;});},createFlexKey:function(i){if(i){return F+"."+i;}},createFlexObjectKey:function(f){return this.createFlexKey(f.fileName);}};});
sap.ui.predefine('sap/ui/fl/apply/_internal/controlVariants/URLHandler',["sap/ui/core/Component","sap/ui/fl/Utils","sap/base/Log","sap/base/util/merge","sap/base/util/ObjectPath","sap/base/util/isEmptyObject","sap/ui/base/ManagedObjectObserver","sap/ui/thirdparty/hasher","sap/base/util/includes","sap/ui/fl/apply/_internal/controlVariants/Utils","sap/ui/fl/apply/_internal/flexState/controlVariants/VariantManagementState"],function(C,U,L,m,O,i,M,h,a,V,b){"use strict";var _={};
function c(n,o){var A=[];return n.reduce(function(r,v){var l=o.getVariantManagementReference(v).variantManagementReference;if(l){if(a(A,l)){r.updateRequired=true;return r;}A.push(l);}if(l&&o.oData[l].currentVariant!==v){r.updateRequired=true;if(o.oData[l].currentVariant!==o.oData[l].defaultVariant){r.parameters.push(o.oData[l].currentVariant);}}else{r.parameters.push(v);}return r;},{updateRequired:false,parameters:[]});}
function d(p,o){var r=O.get(["params",V.VARIANT_TECHNICAL_PARAMETER],p);if(r){var u=c(r,o);if(u.updateRequired){k.update({updateURL:!o._bDesignTimeMode,parameters:u.parameters,updateHashEntry:true,model:o});}}}
function e(o,S,n){try{var N=S[1].parseShellHash(n);d(N,o);}catch(E){L.error(E.message);}return S[0].NavigationFilterStatus.Continue;}
function f(o){U.ifUShellContainerThen(function(S){if(!_[o.sFlexReference]){_[o.sFlexReference]=e.bind(null,o,S);S[0].registerNavigationFilter(_[o.sFlexReference]);}},["ShellNavigation","URLParsing"]);}
function g(o){U.ifUShellContainerThen(function(S){if(_[o.sFlexReference]){S[0].unregisterNavigationFilter(_[o.sFlexReference]);delete _[o.sFlexReference];}},["ShellNavigation"]);}
function s(p){var P=U.getParsedURLHash(V.VARIANT_TECHNICAL_PARAMETER);if(P.params){var t=U.getTechnicalParametersForComponent(p.model.oAppComponent);if(!t){L.warning("Component instance not provided, so technical parameters in component data and browser history remain unchanged");}if(p.parameters.length===0){delete P.params[V.VARIANT_TECHNICAL_PARAMETER];t&&delete t[V.VARIANT_TECHNICAL_PARAMETER];}else{P.params[V.VARIANT_TECHNICAL_PARAMETER]=p.parameters;t&&(t[V.VARIANT_TECHNICAL_PARAMETER]=p.parameters);}var u=U.getUshellContainer();if(p.silent){h.changed.active=false;h.replaceHash(u.getService("URLParsing").constructShellHash(P));h.changed.active=true;}else{var o=u.getService("CrossApplicationNavigation");o.toExternal({target:{semanticObject:P.semanticObject,action:P.action,context:P.contextRaw},params:P.params,appSpecificRoute:P.appSpecificRoute,writeHistory:false});}}}
function j(p){var r={index:-1};var u=U.getParsedURLHash().params;if(u){r.parameters=[];if(p.model._bDesignTimeMode){u[V.VARIANT_TECHNICAL_PARAMETER]=k.getStoredHashParams(p);}if(Array.isArray(u[V.VARIANT_TECHNICAL_PARAMETER])){u[V.VARIANT_TECHNICAL_PARAMETER]=u[V.VARIANT_TECHNICAL_PARAMETER].map(decodeURIComponent);u[V.VARIANT_TECHNICAL_PARAMETER].some(function(P,I){var v=b.getVariant({vmReference:p.vmReference,vReference:P,reference:p.model.oChangePersistence.getComponentName()});if(v){r.index=I;return true;}});}}return m(r,u&&u[V.VARIANT_TECHNICAL_PARAMETER]&&{parameters:u[V.VARIANT_TECHNICAL_PARAMETER]});}
var k={variantTechnicalParameterName:"sap-ui-fl-control-variant-id",initialize:function(p){var P=U.getParsedURLHash();var l=P.params&&P.params[V.VARIANT_TECHNICAL_PARAMETER];k.attachHandlers(p);k.update({model:p.model,parameters:l,updateHashEntry:Array.isArray(l)&&l.length>0});d(P,p.model);},updateVariantInURL:function(p){var u=k.removeURLParameterForVariantManagement(p);if(!u.parameters){return;}var P=u.parameters||[];var I=u.index;var l=p.newVReference===p.model.oData[p.vmReference].defaultVariant;if(!l){if(I===-1){P=P.concat([p.newVReference]);}else{P=P.slice(0,I).concat([p.newVReference],P.slice(I));}}if(!l||I>-1){k.update({parameters:P,updateURL:!p.model._bDesignTimeMode,updateHashEntry:true,model:p.model});}},removeURLParameterForVariantManagement:function(p){var v=j(p);if(v.index>-1){v.parameters.splice(v.index,1);}return v;},attachHandlers:function(p){function o(){return p.model._oVariantSwitchPromise.then(function(){p.model._oHashData.controlPropertyObservers.forEach(function(l){l.destroy();});g(p.model);p.model.resetMap().then(p.model.destroy.bind(p.model));p.model.oComponentDestroyObserver.unobserve(p.model.oAppComponent,{destroy:true});p.model.oComponentDestroyObserver.destroy();});}f(p.model);if(!p.model.oComponentDestroyObserver&&p.model.oAppComponent instanceof C){p.model.oComponentDestroyObserver=new M(o.bind(null));p.model.oComponentDestroyObserver.observe(p.model.oAppComponent,{destroy:true});}},registerControl:function(p){if(p.updateURL){p.model._oHashData.variantControlIds.push(p.vmReference);}},update:function(p){if(!p.model._oHashData){p.model._oHashData={hashParams:[],controlPropertyObservers:[],variantControlIds:[]};}if(!p||!Array.isArray(p.parameters)){L.info("Variant URL parameters could not be updated since invalid parameters were received");return;}if(p.updateURL){s(p);}if(p.updateHashEntry&&!i(p.model)){p.model._oHashData.hashParams=p.parameters;}},getStoredHashParams:function(p){return Array.prototype.slice.call(p.model._oHashData.hashParams);},handleModelContextChange:function(p){var l="modelContextChange";function n(E,P){var v=P.model.getVariantManagementReferenceForControl(E.getSource());var q=P.model._oHashData.variantControlIds;var I=q.indexOf(v);if(I>-1){q.slice(I).forEach(function(r){if(j({vmReference:r,model:p.model}).index===-1){P.model.switchToDefaultForVariantManagement(r);}});}}var o=new M(function(E){if(E.current===true&&E.old===false){E.object.attachEvent(l,{model:p.model},n);}else if(E.current===false&&E.old===true){E.object.detachEvent(l,n);}});o.observe(p.vmControl,{properties:["resetOnContextChange"]});p.model._oHashData.controlPropertyObservers.push(o);if(p.vmControl.getResetOnContextChange()!==false){p.vmControl.attachEvent(l,{model:p.model},n);}},clearAllVariantURLParameters:function(p){k.update({updateURL:true,parameters:[],updateHashEntry:false,model:p.model});}};return k;},true);
sap.ui.predefine('sap/ui/fl/apply/_internal/controlVariants/Utils',["sap/base/util/includes","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/Variant"],function(i,J,V){"use strict";
function g(A,c){if(!c){return undefined;}if(A.indexOf(c.getId())>-1){return c.getId();}return g(A,c.getParent());}
var a={DEFAULT_AUTHOR:"SAP",VARIANT_TECHNICAL_PARAMETER:"sap-ui-fl-control-variant-id",compareVariants:function(v,o){if(v.content.content.title.toLowerCase()<o.content.content.title.toLowerCase()){return-1;}else if(v.content.content.title.toLowerCase()>o.content.content.title.toLowerCase()){return 1;}return 0;},getIndexToSortVariant:function(v,o){var s=v.length;v.some(function(e,b){if(a.compareVariants(o,e)<0){s=b;return true;}});return s;},createVariant:function(p){var v;var o;var s=p.variantSpecificData.content.variantManagementReference;if(s){var b=J.checkControlId(s,p.model.oAppComponent);if(!b){throw new Error("Generated ID attribute found - to offer flexibility a stable VariantManagement ID is needed to assign the changes to, but for this VariantManagement control the ID was generated by SAPUI5 "+s);}}p.variantSpecificData.content.reference=p.model.sFlexReference;p.variantSpecificData.content.packageName="$TMP";o=V.createInitialFileContent(p.variantSpecificData);v=new V(o);return v;},getRelevantVariantManagementControlId:function(c,v){var A={};var b=v.reduce(function(C,d){var o=sap.ui.getCore().byId(d);var f=o.getFor();f.forEach(function(e){A[e]=d;});return C.concat(f);},[]);var s=g(b,c);return A[s];}};return a;});
sap.ui.predefine('sap/ui/fl/apply/_internal/flexState/FlexState',["sap/base/util/merge","sap/base/util/ObjectPath","sap/ui/core/Component","sap/ui/fl/initial/_internal/StorageUtils","sap/ui/fl/apply/_internal/flexState/Loader","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/apply/_internal/flexState/prepareAppDescriptorMap","sap/ui/fl/apply/_internal/flexState/prepareChangesMap","sap/ui/fl/apply/_internal/flexState/prepareVariantsMap","sap/ui/fl/apply/_internal/flexState/prepareCompVariantsMap","sap/ui/fl/LayerUtils","sap/ui/fl/Utils","sap/base/Log"],function(m,O,C,S,L,M,p,a,b,c,d,U,e){"use strict";var F={};var _={};var f={};var g={};var h={appDescriptorMap:p,changesMap:a,variantsMap:b,compVariantsMap:c};
function u(P){var A=C.get(P.componentId);_[P.reference].componentData=A?A.getComponentData():P.componentData;}
function i(P){var A=C.get(P.componentId);P.componentData=P.componentData||A.getComponentData()||{};P.manifest=P.manifest||P.rawManifest||A.getManifestObject();P.reference=P.reference||M.getFlexReference(P);}
function j(R,A){if(!_[R]){throw new Error("State is not yet initialized");}if(!_[R].preparedMaps[A]){var P={unfilteredStorageResponse:_[R].unfilteredStorageResponse,storageResponse:_[R].storageResponse,componentId:_[R].componentId,componentData:_[R].componentData};_[R].preparedMaps[A]=F._callPrepareFunction(A,P);}return _[R].preparedMaps[A];}
function k(R){return j(R,"appDescriptorMap");}
function l(R){return j(R,"changesMap");}
function n(R){return j(R,"variantsMap");}
function o(R){return j(R,"compVariantsMap");}
function q(P){if(P.reference.endsWith(".Component")){var A=P.reference.split(".");A.pop();var R=A.join(".");_[R]=m({},{storageResponse:{changes:S.getEmptyFlexDataResponse()},unfilteredStorageResponse:{changes:S.getEmptyFlexDataResponse()},preparedMaps:{},componentId:P.componentId,partialFlexState:P.partialFlexState});g[R]=g[P.reference];}}
function r(R){var A=m({},R);var B=A.changes;var D=["changes","variants","variantChanges","variantDependentControlChanges","variantManagementChanges"];if(d.isLayerFilteringRequired()){D.forEach(function(T){B[T]=d.filterChangeDefinitionsByMaxLayer(B[T]);});}return A;}
function s(P){g[P.reference]=L.loadFlexData(P).then(function(R){_[P.reference]=m({},{unfilteredStorageResponse:R,preparedMaps:{},componentId:P.componentId,componentData:P.componentData,partialFlexState:P.partialFlexState});q(P);t(P.reference);return R;});return g[P.reference];}
function t(R){U.ifUShellContainerThen(function(A){f[R]=w.bind(null,R);A[0].registerNavigationFilter(f[R]);},["ShellNavigation"]);}
function v(R){U.ifUShellContainerThen(function(A){if(f[R]){A[0].unregisterNavigationFilter(f[R]);delete f[R];}},["ShellNavigation"]);}
function w(R,N,A){return U.ifUShellContainerThen(function(B){try{var D=d.getMaxLayerTechnicalParameter(N);var P=d.getMaxLayerTechnicalParameter(A);if(D!==P){F.clearFilteredResponse(R);}}catch(E){e.error(E.message);}return B[0].NavigationFilterStatus.Continue;},["ShellNavigation"]);}
function x(R){_[R].preparedMaps={};}
function y(I){var A=_[I.reference];if(A.partialFlexState===true&&I.partialFlexState!==true){A.partialFlexState=false;I.partialFlexData=m({},A.unfilteredStorageResponse.changes);I.reInitialize=true;}return I;}
function z(I){var A=_[I.reference].componentId;if(!I.reInitialize&&A!==I.componentId){I.reInitialize=true;}return I;}
F.initialize=function(P){return Promise.resolve(P).then(function(I){i(I);var A=I.reference;if(g[A]){return g[A].then(y.bind(null,I)).then(z).then(function(E){return E.reInitialize?s(E):_[A].unfilteredStorageResponse;});}return s(I);}).then(function(P,R){if(!_[P.reference].storageResponse){_[P.reference].storageResponse=r(R);u(P);F.getVariantsState(P.reference);}}.bind(null,P));};
F.clearAndInitialize=function(P){i(P);var V=!!O.get(["preparedMaps","variantsMap"],_[P.reference]);F.clearState(P.reference);F.clearState(U.normalizeReference(P.reference));return F.initialize(P).then(function(V,R){if(V){return F.getVariantsState(R);}}.bind(null,V,P.reference));};
F.clearState=function(R){if(R){v(R);delete _[R];delete g[R];}else{Object.keys(_).forEach(function(R){v(R);});_={};g={};}};
F.clearFilteredResponse=function(R){if(_[R]){x(R);delete _[R].storageResponse;}};
F.getUIChanges=function(R){return l(R).changes;};
F.getAppDescriptorChanges=function(R){return k(R).appDescriptorChanges;};
F.getVariantsState=function(R){return n(R);};
F.getUI2Personalization=function(R){return _[R].unfilteredStorageResponse.changes.ui2personalization;};
F.getCompVariantsMap=function(R){return o(R).map;};
F.getCompEntitiesByIdMap=function(R){return o(R).byId;};
F._callPrepareFunction=function(A,P){return h[A](P);};
F.getStorageResponse=function(R){if(g[R]){return g[R].then(function(){return _[R].unfilteredStorageResponse;});}};
F.getFlexObjectsFromStorageResponse=function(R){return _[R]&&_[R].unfilteredStorageResponse.changes;};
return F;},true);
sap.ui.predefine('sap/ui/fl/apply/_internal/flexState/Loader',["sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/initial/_internal/Storage","sap/ui/fl/Utils"],function(M,A,U){"use strict";
function _(f){return{changes:f,cacheKey:f.cacheKey};}
return{loadFlexData:function(p){var c=M.getBaseComponentNameFromManifest(p.manifest);if(p.partialFlexData){return A.completeFlexData({reference:p.reference,componentName:c,partialFlexData:p.partialFlexData}).then(_);}return A.loadFlexData({reference:p.reference,componentName:c,cacheKey:M.getCacheKeyFromAsyncHints(p.asyncHints),siteId:U.getSiteIdByComponentData(p.componentData),appDescriptor:p.manifest.getRawJson?p.manifest.getRawJson():p.manifest,version:p.version}).then(_);}};});
sap.ui.predefine('sap/ui/fl/apply/_internal/flexState/UI2Personalization/UI2PersonalizationState',["sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/write/_internal/connectors/LrepConnector"],function(F,L){"use strict";var U={};
U.getPersonalization=function(r,c,i){var u=F.getUI2Personalization(r);if(!u||!u[c]){return i?undefined:[];}if(!i){return u[c];}return u[c].filter(function(e){return e.itemName===i;})[0];};
U.setPersonalization=function(p){if(!p||!p.reference||!p.containerKey||!p.itemName||!p.content){return Promise.reject("not all mandatory properties were provided for the storage of the personalization");}return L.ui2Personalization.create({flexObjects:p}).then(function(P){var o=F.getUI2Personalization(P.response.reference);o[P.response.containerKey]=o[P.response.containerKey]||[];o[P.response.containerKey].push(P.response);});};
U.deletePersonalization=function(r,c,i){if(!r||!c||!i){return Promise.reject("not all mandatory properties were provided for the storage of the personalization");}return L.ui2Personalization.remove({reference:r,containerKey:c,itemName:i}).then(function(){var I=U.getPersonalization(r,c);var t=U.getPersonalization(r,c,i);var n=I.indexOf(t);I.splice(n,1);});};
return U;});
sap.ui.predefine('sap/ui/fl/apply/_internal/flexState/changes/DependencyHandler',["sap/base/util/includes","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/Utils"],function(i,J,U){"use strict";var P="sap.ui.fl:PendingChange";var D={};
function g(s,A){return J.getControlIdBySelector(s,A);}
function c(C){return{changeObject:C,dependencies:[],controlsDependencies:[],dependentIds:[]};}
function a(s,C,o){d(o,C,s);b(o,C);}
function b(C,o){if(!i(C.aChanges,o)){C.aChanges.push(o);}}
function d(C,o,s){if(!C.mChanges[s]){C.mChanges[s]=[];}if(!i(C.mChanges[s],o)){C.mChanges[s].push(o);}}
function e(C,A,o){var s=C.getSelector();if(s){if(s.id){a(g(s,A),C,o);}else{b(o,C);}}return o.aChanges;}
function f(E,o){return E.some(function(p){return(p.id===o.id&&p.idIsLocal===o.idIsLocal);});}
function h(t,o,E,C,A,p,q){var r=E.getDependentSelectorList();o.some(function(s){if(f(r,s)){var u=g(s,A);var I=C&&p.indexOf(t)<p.indexOf(E);if(I){l(E,t,u,q,true);}else{l(t,E,u,q);}return true;}});}
function j(t,A,C,o){if(t.isValidForDependencyMap()){var p=t.getDependentSelectorList();k(t,p,A,o);var I=C.indexOf(t);var q=I<(C.length-1);var O=C.slice();O.splice(I,1);O.reverse().forEach(function(E){if(E.isValidForDependencyMap()){h(t,p,E,q,A,C,o);}});}}
function k(o,p,A,C){if(p.length){var q=p.map(function(s){return g(s,A);});if(!C.mDependencies[o.getId()]){C.mDependencies[o.getId()]=c(o);}C.mDependencies[o.getId()].controlsDependencies=q;q.forEach(function(I){C.mControlsWithDependencies[I]=C.mControlsWithDependencies[I]||[];C.mControlsWithDependencies[I].push(o.getId());});}}
function l(o,C,s,p,I){if(m(o,C,s,p,I)){p.mDependencies[o.getId()].dependencies.push(C.getId());if(!i(p.mDependencies[o.getId()].dependentIds,s)){p.mDependencies[o.getId()].dependentIds.push(s);}if(!p.mDependentChangesOnMe[C.getId()]){p.mDependentChangesOnMe[C.getId()]=[];}p.mDependentChangesOnMe[C.getId()].push(o.getId());}}
function m(o,C,s,p,I){var S=!I&&i(p.mDependencies[o.getId()].dependentIds,s);var q=false;if(p.mDependentChangesOnMe[C.getId()]){p.mDependentChangesOnMe[C.getId()].some(function(r){q=i(p.mDependencies[o.getId()].dependencies,r);return q;});}return!S&&!q;}
function n(C,s){var o=[];var p=[];var q=[];if(C.dependencyRemovedInLastBatch[s]){C.dependencyRemovedInLastBatch[s].forEach(function(r){var t=C.mDependencies[r];if(t&&t.dependencies.length===0&&!(t.controlsDependencies&&t.controlsDependencies.length)){p.push(r);o.push(t.changeObject.getId());if(t[P]){q.push(function(){return t[P]();});}}});}return U.execPromiseQueueSequentially(q).then(function(o,p,s){delete C.dependencyRemovedInLastBatch[s];p.forEach(function(r){delete C.mDependencies[r];});o.forEach(function(r){D.resolveDependenciesForChange(C,r,s);});return!!o.length;}.bind(undefined,o,p,s));}
D.createEmptyDependencyMap=function(){return{aChanges:[],mChanges:{},mDependencies:{},mDependentChangesOnMe:{},mControlsWithDependencies:{},dependencyRemovedInLastBatch:{}};};
D.addChangeAndUpdateDependencies=function(C,A,o){var p=e(C,A,o);j(C,A,p,o);};
D.addRuntimeChangeAndUpdateDependencies=function(C,A,o,I){var p=e(C,A,o);j(C,A,p,I);};
D.processDependentQueue=function(C,A,s){return n(C,s).then(function(s,o){if(o){return D.processDependentQueue(C,A,s);}}.bind(undefined,s));};
D.addChangeApplyCallbackToDependency=function(C,s,o){C.mDependencies[s][P]=o;};
D.removeControlsDependencies=function(C,s){var o=C.mControlsWithDependencies[s];if(o){o.forEach(function(p){var q=C.mDependencies[p];if(q&&q.controlsDependencies&&q.controlsDependencies.length){var I=q.controlsDependencies.indexOf(s);if(I>-1){q.controlsDependencies.splice(I,1);delete C.mControlsWithDependencies[s];C.dependencyRemovedInLastBatch[s]=C.dependencyRemovedInLastBatch[s]||[];if(!i(C.dependencyRemovedInLastBatch[s],p)){C.dependencyRemovedInLastBatch[s].push(p);}}}});delete C.mControlsWithDependencies[s];}};
D.resolveDependenciesForChange=function(C,s,o){var p=C.mDependentChangesOnMe[s];if(p){p.forEach(function(K){var q=C.mDependencies[K];var I=q?q.dependencies.indexOf(s):-1;if(I>-1){q.dependencies.splice(I,1);C.dependencyRemovedInLastBatch[o]=C.dependencyRemovedInLastBatch[o]||[];if(!i(C.dependencyRemovedInLastBatch[o],K)){C.dependencyRemovedInLastBatch[o].push(K);}}});delete C.mDependentChangesOnMe[s];}};
D.removeChangeFromMap=function(C,s){Object.keys(C.mChanges).some(function(o){var p=C.mChanges[o];var q=p.map(function(E){return E.getId();}).indexOf(s);if(q!==-1){p.splice(q,1);return true;}});var I=C.aChanges.map(function(E){return E.getId();}).indexOf(s);if(I!==-1){C.aChanges.splice(I,1);}};
D.removeChangeFromDependencies=function(C,s,o){D.resolveDependenciesForChange(C,s,o);delete C.mDependencies[s];};
D.checkForOpenDependenciesForControl=function(C,s,A){return Object.keys(C.mDependencies).some(function(K){return C.mDependencies[K].changeObject.getDependentSelectorList().some(function(o){return J.getControlIdBySelector(o,A)===s;});});};
return D;});
sap.ui.predefine('sap/ui/fl/apply/_internal/flexState/changes/ExtensionPointState',["sap/ui/fl/ChangePersistenceFactory","sap/base/Log"],function(C,L){"use strict";var E={};
function i(c,p,o){if(o.getSelector().name!==p.extensionPointName){return false;}return c.changesHavingCorrectViewPrefix(p,o);}
E.getChangesForExtensionPoint=function(c,p){if(!p.extensionPointName){L.error("Missing name from extension point info!");return Promise.resolve([]);}return c.getChangesForComponent().then(function(a){return a.filter(i.bind(this,c,p));});};
E.enhanceExtensionPointChanges=function(p,e){p.extensionPointName=e.name;var c=C.getChangePersistenceForControl(e.targetControl);return E.getChangesForExtensionPoint(c,p).then(function(a){a.forEach(function(o){if(o.isInInitialState()){o.setExtensionPointInfo(e);var s=o.getSelector();s.id=e.targetControl.getId();s.idIsLocal=false;o.setSelector(s);if(c.isChangeMapCreated()){c._addChangeAndUpdateDependencies(p.appComponent,o);}}});return a;});};
return E;},true);
sap.ui.predefine('sap/ui/fl/apply/_internal/flexState/controlVariants/Switcher',["sap/base/util/includes","sap/base/util/restricted/_pick","sap/ui/fl/apply/_internal/flexState/controlVariants/VariantManagementState","sap/ui/fl/apply/_internal/changes/Reverter"],function(i,_,V,R){"use strict";
function a(p){var c=V.getControlChangesForVariant(Object.assign(_(p,["vmReference","variantsMap","reference"]),{changeInstance:true,vReference:p.currentVReference}));var n=V.getControlChangesForVariant(Object.assign(_(p,["vmReference","variantsMap","reference"]),{changeInstance:true,vReference:p.newVReference}));var m=Object.keys(p.changesMap).reduce(function(b,d){return b.concat(p.changesMap[d]);},[]);var C=m.map(function(o){return o.getId();});var f=c.reduce(function(F,o){var M=C.indexOf(o.getId());if(M>-1){F=F.concat(m[M]);}return F;},[]);var r=[];if(n.length>0){r=f.slice();f.some(function(o){if(n[0]&&o.getId()===n[0].getId()){n.shift();r.shift();}else{return true;}});}else{r=f;}var s={changesToBeReverted:r.reverse(),changesToBeApplied:n};return s;}
var S={switchVariant:function(p){return Promise.resolve().then(function(){p.changesMap=p.flexController._oChangePersistence.getChangesMapForComponent().mChanges;p.variantsMap=V.getContent(p.reference);var c=a(p);return R.revertMultipleChanges(c.changesToBeReverted,p).then(p.flexController.applyVariantChanges.bind(p.flexController,c.changesToBeApplied,p.appComponent)).then(V.setCurrentVariant.bind(null,p));});}};return S;},true);
sap.ui.predefine('sap/ui/fl/apply/_internal/flexState/controlVariants/VariantManagementState',["sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/Variant","sap/ui/fl/Change","sap/ui/fl/Utils","sap/base/util/ObjectPath","sap/base/util/includes","sap/base/util/restricted/_omit","sap/base/Log","sap/ui/fl/LayerUtils","sap/ui/fl/apply/_internal/flexState/FlexState","sap/base/util/restricted/_pick","sap/ui/fl/apply/_internal/controlVariants/Utils","sap/base/util/isEmptyObject"],function(J,V,C,U,O,i,_,L,a,F,b,c,d){"use strict";var e={};
function f(p){var r=[];if(p.variantData.content.variantReference){r=e.getControlChangesForVariant(Object.assign(p,{vReference:p.variantData.content.variantReference,changeInstance:true}));return r.filter(function(R){return a.compareAgainstCurrentLayer(R.getDefinition().layer,p.variantData.content.layer)===-1;});}return r;}
function g(p){var v=e.getContent(p.reference);var m=O.get([p.vmReference,"variants"],v);return m||[];}
function h(v,o,A){var s=o.changeType;if(!v){v={};}if(!v[s]){v[s]=[];}if(A){v[s].push(o);return true;}return v[s].some(function(E,I){if(E.fileName===o.fileName){v[s].splice(I,1);return true;}});}
function j(o,m){var s=l(o);m[s].push(o);}
function k(o,m){var s=l(o);var n=-1;m[s].some(function(E,I){if(E.fileName===o.fileName){n=I;return true;}});if(n>-1){m[s].splice(n,1);}}
function l(o){switch(o.fileType){case"change":return"variantDependentControlChanges";case"ctrl_variant":return"variants";case"ctrl_variant_change":return"variantChanges";case"ctrl_variant_management_change":return"variantManagementChanges";default:}}
e.getContent=function(r){return F.getVariantsState(r);};
e.resetContent=function(r){F.clearFilteredResponse(r);};
e.getControlChangesForVariant=function(p){var r=[];var v=e.getVariant(p);if(v){r=v.controlChanges;if(p.changeInstance){r=r.map(function(o,m){var n;if(!o.getDefinition){n=new C(o);v.controlChanges.splice(m,1,n);}else{n=o;}return n;});}}return r;};
e.getVariantChangesForVariant=function(p){var v=e.getVariant(p);return v&&v.variantChanges||{};};
e.getVariant=function(p){var v;var o=e.getContent(p.reference);p.vReference=p.vReference||o[p.vmReference].defaultVariant;var m=g(p);m.some(function(n){if(n.content.fileName===p.vReference){v=n;return true;}});return v;};
e.getCurrentVariantReference=function(p){var v=e.getContent(p.reference);var o=v[p.vmReference];return o.currentVariant||o.defaultVariant;};
e.getVariantManagementReferences=function(r){var v=e.getContent(r);return Object.keys(v);};
e.addVariantToVariantManagement=function(p){var v=e.getContent(p.reference);var m=v[p.vmReference].variants.slice().splice(1);var I=c.getIndexToSortVariant(m,p.variantData);if(p.variantData.content.variantReference){var r=f(p);p.variantData.controlChanges=r.concat(p.variantData.controlChanges);}v[p.vmReference].variants.splice(I+1,0,p.variantData);return I+1;};
e.removeVariantFromVariantManagement=function(p){var I;var v=e.getContent(p.reference);var m=v[p.vmReference].variants.some(function(o,n){var q=new V(o);if(q.getId()===p.variant.getId()){I=n;return true;}});if(m){v[p.vmReference].variants.splice(I,1);}return I;};
e.setVariantData=function(p){var v=e.getContent(p.reference);var m=v[p.vmReference].variants;var o=m[p.previousIndex];Object.keys(p.variantData).forEach(function(P){if(o.content.content[P]){o.content.content[P]=p.variantData[P];}});if(o.content.fileName!==p.vmReference){m.splice(p.previousIndex,1);var s=c.getIndexToSortVariant(m.slice(1),o);m.splice(s+1,0,o);return s+1;}m.splice(p.previousIndex,1,o);return p.previousIndex;};
e.addChangeToVariant=function(p){var E=e.getControlChangesForVariant(Object.assign(p,{changeInstance:true}));var m=E.map(function(o){return o.getDefinition().fileName;});if(!i(m,p.change.getDefinition().fileName)){var v=e.getVariant(p);v.controlChanges=E.concat([p.change]);return true;}return false;};
e.removeChangeFromVariant=function(p){var m=e.getControlChangesForVariant(Object.assign(p,{changeInstance:true}));var v=e.getVariant(p);var n=false;if(v){v.controlChanges=m.filter(function(o){if(!n&&o.getId()===p.change.getId()){n=true;return false;}return true;});}return n;};
e.getInitialChanges=function(p){var v=e.getContent(p.reference);return Object.keys(v).reduce(function(I,s){if((p.vmReference&&p.vmReference===s)||!p.vmReference){var m=v[s].currentVariant?"currentVariant":"defaultVariant";var A={vmReference:s,vReference:v[s][m],reference:p.reference,changeInstance:p.changeInstance};return I.concat(e.getControlChangesForVariant(Object.assign({},p,A)));}return I;},[]);};
e.fillVariantModel=function(p){var v=e.getContent(p.reference);return Object.keys(v).reduce(function(o,s){o[s]={defaultVariant:v[s].defaultVariant,variants:[]};if(v[s].currentVariant){o[s].currentVariant=v[s].currentVariant;}g(Object.assign(p,{vmReference:s})).forEach(function(m,n){o[s].variants[n]=JSON.parse(JSON.stringify({key:m.content.fileName,title:m.content.content.title,layer:m.content.layer,favorite:m.content.content.favorite,executeOnSelect:m.content.content.executeOnSelect,visible:m.content.content.visible,author:O.get("content.support.user",m)}));});return o;},{});};
e.updateChangesForVariantManagementInMap=function(p){var v=e.getContent(p.reference);var o=v[p.vmReference];if(p.changeContent.fileType==="ctrl_variant_change"){o.variants.some(function(m){if(m.content.fileName===p.changeContent.selector.id){h(m.variantChanges,p.changeContent,p.add);}});}else if(p.changeContent.fileType==="ctrl_variant_management_change"){h(o.variantManagementChanges,p.changeContent,p.add);}};
e.setCurrentVariant=function(p){var v=e.getContent(p.reference);if(O.get([p.vmReference],v)){v[p.vmReference].currentVariant=p.newVReference;}};
e.updateVariantsState=function(p){var v=e.getContent(p.reference);if(d(v)){L.error("Variant state is not initialized yet");return;}var o=F.getFlexObjectsFromStorageResponse(p.reference);if(p.changeToBeAddedOrDeleted){switch(p.changeToBeAddedOrDeleted.getPendingAction()){case"NEW":j(p.changeToBeAddedOrDeleted.getDefinition(),o);break;case"DELETE":k(p.changeToBeAddedOrDeleted.getDefinition(),o);break;default:}}};
e.waitForInitialVariantChanges=function(p){var m=e.getInitialChanges({vmReference:p.vmReference,reference:p.reference,changeInstance:true});var s=m.reduce(function(o,q){if(U.indexOfObject(o,q.getSelector())===-1){o.push(q.getSelector());}return o;},[]);var n=[];s.map(function(S){var o=J.bySelector(S,p.appComponent);if(o){n.push(o);}});return p.flexController.waitForChangesToBeApplied(n);};
return e;},true);
sap.ui.predefine('sap/ui/fl/apply/_internal/flexState/prepareAppDescriptorMap',["sap/ui/fl/Change"],function(C){"use strict";return function(p){var c=p.storageResponse.changes.appDescriptorChanges||[];var a=c.map(function(o){return new C(o);});return{appDescriptorChanges:a};};});
sap.ui.predefine('sap/ui/fl/apply/_internal/flexState/prepareChangesMap',["sap/ui/fl/Change"],function(C){"use strict";return function(p){var c=p.storageResponse.changes.changes;var a=c.map(function(o){return new C(o);});return{changes:a};};});
sap.ui.predefine('sap/ui/fl/apply/_internal/flexState/prepareCompVariantsMap',["sap/base/util/ObjectPath","sap/base/util/isEmptyObject","sap/ui/fl/Change"],function(O,i,C){"use strict";
function g(m,k){m[k]=m[k]||{variants:[],changes:[],defaultVariant:undefined,standardVariant:undefined};return m[k];}
function b(c,s,B,m){var f=c[s].map(function(o){var a=new C(o);a.setState(C.states.PERSISTED);return a;});f.forEach(function(F){B[F.getId()]=F;var p=F.getSelector().persistencyKey;switch(s){case"defaultVariants":g(m,p)["defaultVariant"]=F;break;case"standardVariants":g(m,p)["standardVariant"]=F;break;default:g(m,p)[s].push(F);}});}
return function(p){var B={};var c={};c._getOrCreate=g.bind(undefined,c);if(p.storageResponse.changes.comp){["variants","changes","defaultVariants","standardVariants"].forEach(function(s){b(p.storageResponse.changes.comp,s,B,c);});}return{map:c,byId:B};};});
sap.ui.predefine('sap/ui/fl/apply/_internal/flexState/prepareVariantsMap',["sap/ui/fl/Utils","sap/base/util/ObjectPath","sap/base/Log","sap/ui/fl/Change","sap/base/util/includes","sap/ui/fl/apply/_internal/controlVariants/Utils","sap/base/util/isEmptyObject","sap/base/util/each","sap/base/util/values","sap/base/util/merge","sap/ui/core/Component","sap/ui/fl/LayerUtils"],function(U,O,L,C,i,V,a,e,v,m,b,c){"use strict";
function d(A,B){var D=m({},A);B.forEach(function(E){D[E.fileName]={content:E,controlChanges:[],variantChanges:{}};});return D;}
function f(A,B){var D=m({},A);B.forEach(function(E){D[E.variantReference]=D[E.variantReference]||t(E.variantReference);D[E.variantReference].controlChanges.push(E);});return D;}
function g(A,B){var D=m({},A);B.forEach(function(E){D[E.selector.id]=D[E.selector.id]||t(E.selector.id);var F=D[E.selector.id].variantChanges[E.changeType]||[];F.push(E);D[E.selector.id].variantChanges[E.changeType]=F;});return D;}
function h(A){var B=m({},A);v(A).forEach(function(D){var S=O.get("variantChanges.setVisible",D);if(S&&S.length>0){var E=x(S);if(!E.getContent().visible&&E.getContent().createdByReset){delete B[D.content.fileName];}}});return B;}
function r(A){var B=m({},A);v(B).forEach(function(D){var E=D.content.variantReference;var R;if(E){R=k(B,E,D.content.variantManagementReference);}D.controlChanges=j(R,D.content.layer).concat(D.controlChanges);});return B;}
function j(R,A){if(!R){return[];}return v(m({},R.controlChanges)).filter(function(B){return c.compareAgainstCurrentLayer(B.layer,A)===-1;});}
function k(A,B,D){var R=A[B];if(!R&&B===D){R=t(B);A[B]=R;}return R;}
function l(S){var A={};A=d(A,S.variants);A=f(A,S.variantDependentControlChanges);A=g(A,S.variantChanges);A=h(A);A=r(A);return A;}
function n(){return{variantManagementChanges:{},variants:[]};}
function o(R,A,T){var B=m({},R);v(A).forEach(function(D){var E=D.content.variantManagementReference;if(!B[E]){B[E]=n();}D=z(D);D=w(D);if(!B[E].currentVariant&&D.content.content.visible&&i(T,D.content.fileName)){B[E].currentVariant=D.content.fileName;}B[E].defaultVariant=E;var S=V.getIndexToSortVariant(B[E].variants,D);B[E].variants.splice(S,0,D);});return B;}
function p(R,A){var B=m({},R);A.forEach(function(D){var E=D.selector.id;if(!B[E]){B[E]=n();}var F=D.changeType;if(!B[E].variantManagementChanges[F]){B[E].variantManagementChanges[F]=[];}B[E].variantManagementChanges[F].push(D);B[E]=u(B[E]);});return B;}
function q(R){var A=m({},R);e(A,function(B,D){var S=D.variants.findIndex(function(F){return F.content.fileName===B;});var E;if(S===-1){E=t(B);}else{E=D.variants[S];D.variants.splice(S,1);}D.variants.unshift(E);});return A;}
function s(A,B,T){var R={};R=o(R,A,T);R=p(R,B);R=q(R);return R;}
function t(A){var R=sap.ui.getCore().getLibraryResourceBundle("sap.ui.fl");return{content:{fileName:A,variantManagementReference:A,content:{title:R.getText("STANDARD_VARIANT_TITLE"),favorite:true,visible:true},support:{user:V.DEFAULT_AUTHOR}},variantChanges:{},controlChanges:[]};}
function u(A){var B=m({},A);var D=B.variantManagementChanges;var E;if(!a(D)){E=x(D["setDefault"]);if(E){B.defaultVariant=E.getContent().defaultVariant;}}return B;}
function w(A){var B=m({},A);var D=B.variantChanges;var E;e(D,function(F,G){switch(F){case"setTitle":E=x(G);if(E){B.content.content.title=E.getText("title");}break;case"setFavorite":E=x(G);if(E){B.content.content.favorite=E.getContent().favorite;}break;case"setExecuteOnSelect":E=x(G);if(E){B.content.content.executeOnSelect=E.getContent().executeOnSelect;}break;case"setVisible":E=x(G);if(E){B.content.content.visible=E.getContent().visible;}break;default:L.error("No valid changes on variant "+B.content.content.title+" available");}});return B;}
function x(A){if(A.length>0){return new C(A[A.length-1]);}return false;}
function y(T){return sap.ui.getCore().getLibraryResourceBundle("sap.ui.fl").getText(T);}
function z(A){var B=m({},A);if(B.content.fileName===B.content.variantManagementReference){if(!O.get("content.support.user",B)){var S={support:{user:V.DEFAULT_AUTHOR}};m(B.content,S);}}if(!B.content.content.favorite){B.content.content.favorite=true;}if(!B.content.content.visible){B.content.content.visible=true;}if(!B.content.content.executeOnSelect){B.content.content.executeOnSelect=false;}var T=B.content.content.title.match(/.i18n>(\w+)./);if(T){B.content.content.title=y(T[1]);}return B;}
return function(P){if(a(P)||!O.get("storageResponse.changes.variants",P)){return{};}var T=O.get(["technicalParameters",V.VARIANT_TECHNICAL_PARAMETER],P.componentData)||[];var A=l(P.storageResponse.changes);A=s(A,P.storageResponse.changes.variantManagementChanges,T);return A;};});
sap.ui.predefine('sap/ui/fl/apply/api/ControlVariantApplyAPI',["sap/base/Log","sap/ui/fl/ControlPersonalizationAPI","sap/ui/fl/Utils"],function(L,O,U){"use strict";var C={clearVariantParameterInURL:function(p){O.clearVariantParameterInURL(p.control);},activateVariant:function(p){return O.activateVariant(p.element,p.variantReference);},attachVariantApplied:function(p){var c=p.selector.id&&sap.ui.getCore().byId(p.selector.id)||p.selector;var a=U.getAppComponentForControl(c);var v=a.getModel(U.VARIANT_MODEL_NAME);v.attachVariantApplied({vmControlId:p.vmControlId,control:c,callback:p.callback,callAfterInitialVariant:p.callAfterInitialVariant});},detachVariantApplied:function(p){var c=p.selector.id&&sap.ui.getCore().byId(p.selector.id)||p.selector;var a=U.getAppComponentForControl(c);var v=a.getModel(U.VARIANT_MODEL_NAME);v.detachVariantApplied(p.vmControlId,c.getId());}};return C;},true);
sap.ui.predefine('sap/ui/fl/apply/api/DelegateMediatorAPI',["sap/ui/fl/apply/_internal/DelegateMediator"],function(D){"use strict";var a={registerDefaultDelegate:function(p){D.registerDefaultDelegate(p);},getDelegateForControl:function(p){return D.getDelegateForControl(p.control,p.modifier,p.modelType,p.supportsDefault);},getKnownDefaultDelegateLibraries:function(){return D.getKnownDefaultDelegateLibraries();}};return a;},false);
sap.ui.predefine('sap/ui/fl/apply/api/FlexRuntimeInfoAPI',["sap/ui/fl/ControlPersonalizationAPI","sap/ui/fl/Utils","sap/ui/fl/apply/_internal/ChangesController"],function(O,U,C){"use strict";var F={isPersonalized:function(p){return O.isPersonalized(p.selectors,p.changeTypes);},waitForChanges:function(p){var f=p.element||p.selectors[0];var w=p.element||p.selectors;return C.getFlexControllerInstance(f).waitForChangesToBeApplied(w);},isFlexSupported:function(p){return!!U.getAppComponentForControl(p.element);},hasVariantManagement:function(p){return O.hasVariantManagement(p.element);}};return F;},true);
sap.ui.predefine('sap/ui/fl/apply/api/SmartVariantManagementApplyAPI',["sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/apply/_internal/ChangesController","sap/ui/fl/Change","sap/ui/fl/registry/Settings","sap/ui/fl/Utils","sap/ui/fl/LayerUtils"],function(F,M,C,a,S,U,L){"use strict";
function g(o){return o&&o.getPersistencyKey&&o.getPersistencyKey();}
function b(o){var r=M.getFlexReferenceForControl(o);var p=g(o);var m=F.getCompVariantsMap(r);return m._getOrCreate(p);}
var c={getCompEntities:function(p){var r=M.getFlexReferenceForControl(p.control);return F.initialize({reference:r,componentData:{},manifest:U.getAppDescriptor(p.control),componentId:U.getAppComponentForControl(p.control).getId()}).then(b.bind(undefined,p.control));},loadChanges:function(p){return c.getCompEntities(p).then(function(o){return o.variants.concat(o.changes);});},getEntityById:function(p){var r=M.getFlexReferenceForControl(p.control);return F.getCompEntitiesByIdMap(r)[p.id];},isVariantSharingEnabled:function(){return S.getInstance().then(function(i){return i.isVariantSharingEnabled();});},isApplicationVariant:function(p){var o=p.control;if(U.isApplicationVariant(o)){return true;}var d=U.getComponentForControl(o);if(d&&d.getAppComponent){d=d.getAppComponent();if(d){return true;}}return false;},isVendorLayer:function(){return L.isVendorLayer();},isVariantDownport:function(){return c.isVendorLayer()&&U.isHotfixMode();},getDefaultVariantId:function(p){var o=b(p.control).defaultVariant;return o?o.getContent().defaultVariantName:"";},getExecuteOnSelect:function(p){var o=b(p.control).standardVariant;return o?o.getContent().executeOnSelect:null;},getChangeById:function(p){return c.getEntityById(p);},_getChangeMap:function(o){var r=M.getFlexReferenceForControl(o);var p=g(o);var m=F.getCompEntitiesByIdMap(r);var d={};Object.keys(m).forEach(function(i){if(m[i].getSelector&&m[i].getSelector().persistencyKey===p&&m[i].getFileType()==="change"){d[i]=m[i];}});return d;}};return c;},true);
sap.ui.predefine('sap/ui/fl/apply/api/UI2PersonalizationApplyAPI',["sap/ui/fl/apply/_internal/flexState/UI2Personalization/UI2PersonalizationState","sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/apply/_internal/ChangesController"],function(U,F,C){"use strict";var a={load:function(p){var f=C.getFlexControllerInstance(p.selector);p.reference=f.getComponentName();if(!p.reference||!p.containerKey){return Promise.reject(new Error("not all mandatory properties were provided for the loading of the personalization"));}return F.initialize({componentId:p.selector.getId()}).then(function(){return U.getPersonalization(p.reference,p.containerKey,p.itemName);});}};return a;},true);
sap.ui.predefine('sap/ui/fl/initial/_internal/Storage',["sap/ui/fl/initial/_internal/StorageUtils","sap/ui/fl/Utils","sap/ui/fl/LayerUtils","sap/ui/fl/initial/_internal/StorageResultMerger","sap/ui/fl/initial/_internal/storageResultDisassemble"],function(S,F,L,a,s){"use strict";
function _(C,o,p){if(o.layers&&(o.layers[0]==="ALL"||o.layers.indexOf("CUSTOMER")!==-1)){var v=F.getUrlParameter(sap.ui.fl.Versions.UrlParameter);if(p.version!==undefined){C.version=p.version;}else{C.version=v?parseInt(v):"";}}else{delete C.version;}return C;}
function b(p,C){var h=C.map(function(o){var i=Object.assign({},p,{url:o.url,path:o.path});i=_(i,o,p);return o.loadConnectorModule.loadFlexData(i).then(function(r){return r||S.getEmptyFlexDataResponse();}).catch(S.logAndResolveDefault.bind(undefined,S.getEmptyFlexDataResponse(),o,"loadFlexData"));});return Promise.all(h);}
function c(r){var h=[];r.forEach(function(R){if(Array.isArray(R)){h=h.concat(R);}else{h.push(R);}});return h;}
function d(r){return r.map(function(R){return s(R);});}
function e(r){return Promise.resolve(r).then(c).then(d).then(c).then(a.merge);}
function f(p){return S.getStaticFileConnector().then(b.bind(this,p));}
var g={};
g.completeFlexData=function(p){if(!p||!p.reference){return Promise.reject("No reference was provided");}return Promise.all([f(p),p.partialFlexData]).then(e);};
g.loadFlexData=function(p){if(!p||!p.reference){return Promise.reject("No reference was provided");}return S.getLoadConnectors().then(b.bind(this,p)).then(e);};
return g;},true);
sap.ui.predefine('sap/ui/fl/initial/_internal/StorageResultMerger',["sap/base/util/merge","sap/base/util/ObjectPath"],function(m,O){"use strict";var s={};
function c(r,p){var f=r.reduce(function(f,R){if(O.get(p,R)){return f.concat(O.get(p,R));}return f;},[]);var F=[];return f.filter(function(o){var b=o.fileName;var d=F.indexOf(b)!==-1;if(d){return false;}F.push(b);return true;});}
function a(r){return r.reduce(function(u,R){return m({},u,R.ui2personalization);},{});}
function _(r){return r.reduce(function(C,R){return R.cacheKey?C+=R.cacheKey:C;},"")||null;}
s.merge=function(r){return{appDescriptorChanges:c(r,"appDescriptorChanges"),changes:c(r,"changes"),ui2personalization:a(r),comp:{variants:c(r,"comp.variants"),changes:c(r,"comp.changes"),defaultVariants:c(r,"comp.defaultVariants"),standardVariants:c(r,"comp.standardVariants")},variants:c(r,"variants"),variantChanges:c(r,"variantChanges"),variantDependentControlChanges:c(r,"variantDependentControlChanges"),variantManagementChanges:c(r,"variantManagementChanges"),cacheKey:_(r)};};
return s;});
sap.ui.predefine('sap/ui/fl/initial/_internal/StorageUtils',["sap/base/security/encodeURLParameters","sap/base/Log","sap/ui/fl/Layer","sap/ui/fl/LayerUtils","sap/base/util/isEmptyObject"],function(e,L,c,d,i){"use strict";var C={load:{LrepConnector:"sap/ui/fl/initial/_internal/connectors/LrepConnector",NeoLrepConnector:"sap/ui/fl/initial/_internal/connectors/NeoLrepConnector",PersonalizationConnector:"sap/ui/fl/initial/_internal/connectors/PersonalizationConnector",KeyUserConnector:"sap/ui/fl/initial/_internal/connectors/KeyUserConnector",StaticFileConnector:"sap/ui/fl/initial/_internal/connectors/StaticFileConnector",ObjectStorageConnector:"sap/ui/fl/apply/_internal/connectors/ObjectStorageConnector",JsObjectConnector:"sap/ui/fl/write/_internal/connectors/JsObjectConnector",ObjectPathConnector:"sap/ui/fl/write/_internal/connectors/ObjectPathConnector",LocalStorageConnector:"sap/ui/fl/write/_internal/connectors/LocalStorageConnector",SessionStorageConnector:"sap/ui/fl/write/_internal/connectors/SessionStorageConnector"},write:{LrepConnector:"sap/ui/fl/write/_internal/connectors/LrepConnector",NeoLrepConnector:"sap/ui/fl/write/_internal/connectors/NeoLrepConnector",PersonalizationConnector:"sap/ui/fl/write/_internal/connectors/PersonalizationConnector",KeyUserConnector:"sap/ui/fl/write/_internal/connectors/KeyUserConnector",StaticFileConnector:"sap/ui/fl/write/_internal/connectors/StaticFileConnector",JsObjectConnector:"sap/ui/fl/write/_internal/connectors/JsObjectConnector",ObjectPathConnector:"sap/ui/fl/write/_internal/connectors/ObjectPathConnector",LocalStorageConnector:"sap/ui/fl/write/_internal/connectors/LocalStorageConnector",SessionStorageConnector:"sap/ui/fl/write/_internal/connectors/SessionStorageConnector"}};var I="sap/ui/fl/initial/_internal/connectors/";var S={connector:"StaticFileConnector"};
function _(l,v){return l.filter(function(a){return v.indexOf(a)!==-1||v[0]==="ALL";});}
function s(r){function b(o,a){return new Date(o.creation)-new Date(a.creation);}["changes","variantChanges","variants","variantDependentControlChanges","variantManagementChanges"].forEach(function(a){r[a]=r[a].sort(b);});return r;}
function f(n,l,m){return m.map(function(a){var b=a.connector;var h;if(!a.loadConnector&&!a.applyConnector&&!a.loadConnector){h=l?C.load[b]:C.write[b];}else if(l){h=a.loadConnector||a.applyConnector;}else{h=a.writeConnector||"sap/ui/fl/write/connectors/BaseConnector";}return h;});}
function g(n,l,m){var a=f(n,l,m);return new Promise(function(r){sap.ui.require(a,function(){Array.from(arguments).forEach(function(o,b){if(!m[b].layers){m[b].layers=o.layers;}else{m[b].layers=_(m[b].layers,o.layers);}if(l){m[b].loadConnectorModule=o;}else{m[b].writeConnectorModule=o;}});r(m);});});}
return{getConnectors:function(n,l){var a=sap.ui.getCore().getConfiguration().getFlexibilityServices();var m=[];if(l){m=[S];}m=m.concat(a);return g(n,l,m);},getLoadConnectors:function(){return this.getConnectors(I,true);},getStaticFileConnector:function(){return g(I,true,[S]);},logAndResolveDefault:function(r,o,F,E){L.error("Connector ("+o.connector+") failed call '"+F+"': "+E+"\nApplication startup continues without data from this storage.");return r;},filterAndSortResponses:function(G){var r=[];Object.keys(G).forEach(function(l){r.push(G[l]);});r=r.filter(function(R){return R.changes.length>0||R.variants.length>0||R.variantChanges.length>0||R.variantManagementChanges.length>0||R.variantDependentControlChanges.length>0||R.comp.variants.length>0||R.comp.changes.length>0||R.comp.defaultVariants.length>0||R.comp.standardVariants.length>0;});r.sort(function(a,b){return a.index-b.index;});return r;},getGroupedFlexObjects:function(F){var G={};Object.keys(c).forEach(function(l){G[l]=this.getEmptyFlexDataResponse();G[l].index=d.getLayerIndex(l);}.bind(this));F.forEach(function(o){var l=o.layer;if(o.fileType==="ctrl_variant"&&o.variantManagementReference){G[l].variants.push(o);}else if(o.fileType==="ctrl_variant_change"){G[l].variantChanges.push(o);}else if(o.fileType==="ctrl_variant_management_change"){G[l].variantManagementChanges.push(o);}else if(o.fileType==="variant"){G[l].comp.variants.push(o);}else if(o.fileType==="change"){if(o.variantReference){G[l].variantDependentControlChanges.push(o);}else{switch(o.changeType){case"addFavorite":case"removeFavorite":G[l].comp.changes.push(o);break;case"defaultVariant":G[l].comp.defaultVariants.push(o);break;case"standardVariant":G[l].comp.standardVariants.push(o);break;default:G[l].changes.push(o);}}}});Object.keys(G).forEach(function(l){s(G[l]);});return G;},getEmptyFlexDataResponse:function(){return Object.assign({},{appDescriptorChanges:[],changes:[],comp:{variants:[],changes:[],defaultVariants:[],standardVariants:[]},variants:[],variantChanges:[],variantDependentControlChanges:[],variantManagementChanges:[],ui2personalization:{}});},isStorageResponseFilled:function(r){return Object.keys(r||{}).some(function(k){if(Array.isArray(r[k])){return r[k].length!==0;}return!i(r[k]);});},addLanguageInfo:function(p){if(!p){p={};}p["sap-language"]=sap.ui.getCore().getConfiguration().getLanguage();}};});
sap.ui.predefine('sap/ui/fl/initial/_internal/connectors/BackendConnector',["sap/ui/fl/initial/_internal/connectors/Utils","sap/base/util/restricted/_pick"],function(I,_){"use strict";return{xsrfToken:undefined,settings:undefined,loadFlexData:function(p){var P=_(p,["version"]);if(this.isLanguageInfoRequired){I.addLanguageInfo(P);}var d=I.getUrl(this.ROUTES.DATA,p,P);return I.sendRequest(d,"GET",{xsrfToken:this.xsrfToken}).then(function(r){var R=r.response;if(r.xsrfToken){this.xsrfToken=r.xsrfToken;}if(r.etag){R.cacheKey=r.etag;}R.changes=R.changes.concat(R.compVariants||[]);if(R.settings){this.settings=R.settings;}return R;}.bind(this));}};});
sap.ui.predefine('sap/ui/fl/initial/_internal/connectors/KeyUserConnector',["sap/base/util/merge","sap/ui/fl/initial/_internal/connectors/BackendConnector","sap/ui/fl/Layer"],function(m,B,L){"use strict";var P="/flex/keyuser";var A="/v1";var K=m({},B,{layers:[L.CUSTOMER],ROUTES:{DATA:P+A+"/data/"},isLanguageInfoRequired:true});return K;});
sap.ui.predefine('sap/ui/fl/initial/_internal/connectors/LrepConnector',["sap/ui/fl/initial/_internal/connectors/Utils","sap/ui/fl/Utils","sap/ui/dom/includeScript"],function(U,F,i){"use strict";var R={DATA:"/flex/data/",MODULES:"/flex/modules/"};return{layers:["ALL"],xsrfToken:undefined,settings:undefined,_loadModules:function(f){return new Promise(function(r,a){i(f,undefined,r,a);});},_addClientInfo:function(p){var c=F.getUrlParameter("sap-client");if(!p&&c){p={};}if(c){p["sap-client"]=c;}},loadFlexData:function(p){if(p.cacheKey==="<NO CHANGES>"){return Promise.resolve();}var P={};this._addClientInfo(P);U.addLanguageInfo(P);var a;if(p.appDescriptor&&p.appDescriptor["sap.app"]){a=p.appDescriptor["sap.app"].id;}var d=U.getUrl(R.DATA,p,P);return U.sendRequest(d,"GET",{xsrfToken:this.xsrfToken,siteId:p.siteId,sAppDescriptorId:a}).then(function(r){var o=r.response;if(r.xsrfToken){this.xsrfToken=r.xsrfToken;}if(r.etag){o.cacheKey=r.etag;}else if(p.cacheKey){o.cacheKey=p.cacheKey;}o.changes=o.changes.concat(o.compVariants||[]);if(o.settings){this.settings=o.settings;}if(!o.loadModules){return o;}var m=U.getUrl(R.MODULES,p,P);return this._loadModules(m).then(function(){return o;});}.bind(this));}};});
sap.ui.predefine('sap/ui/fl/initial/_internal/connectors/NeoLrepConnector',["sap/base/util/merge","sap/ui/fl/initial/_internal/connectors/LrepConnector"],function(m,L){"use strict";return m({},L,{});});
sap.ui.predefine('sap/ui/fl/initial/_internal/connectors/PersonalizationConnector',["sap/base/util/merge","sap/ui/fl/initial/_internal/connectors/BackendConnector","sap/ui/fl/Layer"],function(m,B,L){"use strict";var P="/flex/personalization";var A="/v1";var a=m({},B,{layers:[L.USER],ROUTES:{DATA:P+A+"/data/"}});return a;});
sap.ui.predefine('sap/ui/fl/initial/_internal/connectors/StaticFileConnector',["sap/base/Log","sap/base/util/LoaderExtensions"],function(L,a){"use strict";
function _(r,b){var B=r.replace(/\./g,"/")+"/changes/"+b+".json";var c=!!sap.ui.loader._.getModuleState(B);var C=sap.ui.getCore().getConfiguration();if(c||C.getDebug()||C.getComponentPreload()==="off"){try{return a.loadResource(B);}catch(e){if(e.name.includes("SyntaxError")){L.error(e);}L.warning("flexibility did not find a "+b+".json for the application: "+r);}}}
return{loadFlexData:function(p){var c=p.componentName;if(!c){c=p.reference.replace(/.Component/g,"");}var f=_(c,"flexibility-bundle");if(f){f.changes=f.changes.concat(f.compVariants);delete f.compVariants;return Promise.resolve(f);}var C=_(c,"changes-bundle");if(C){return Promise.resolve({changes:C});}return Promise.resolve();}};});
sap.ui.predefine('sap/ui/fl/initial/_internal/connectors/Utils',["sap/base/security/encodeURLParameters"],function(a){"use strict";var T=0;var _=function(r,u){var e=new Error(r.statusText);e.status=r.status;e.userMessage=u;return e;};var b=function(t){return sap.ui.getCore().getLibraryResourceBundle("sap.ui.fl").getText(t);};return{addLanguageInfo:function(p){if(!p){p={};}p["sap-language"]=sap.ui.getCore().getConfiguration().getLanguage();},getUrl:function(r,p,P){if(!r||!p.url){throw new Error("Not all necessary parameters were passed");}var u=p.url+r;if(p.cacheKey){u+="~"+p.cacheKey+"~/";}if(p.reference){u+=p.reference;}else if(p.fileName){u+=p.fileName;}if(P){Object.keys(P).forEach(function(k){if(P[k]===undefined){delete P[k];}});var q=a(P);if(q.length>0){u+="?"+q;}}return u;},sendRequest:function(u,m,p){m=m||"GET";m=m.toUpperCase();return new Promise(function(r,c){var x=new XMLHttpRequest();x.open(m,u);x.timeout=T;if((m==="GET"||m==="HEAD")&&(!p||!p.xsrfToken)){x.setRequestHeader("X-CSRF-Token","fetch");}if((m==="POST"||m==="PUT"||m==="DELETE")&&p&&p.xsrfToken){x.setRequestHeader("X-CSRF-Token",p.xsrfToken);}if(p&&p.contentType){x.setRequestHeader("Content-Type",p.contentType);}if(p&&p.siteId){x.setRequestHeader("X-LRep-Site-Id",p.siteId);}if(p&&p.sAppDescriptorId){x.setRequestHeader("X-LRep-AppDescriptor-Id",p.sAppDescriptorId);}if(p&&p.dataType){x.responseType=p.dataType;}x.onload=function(){if(x.status>=200&&x.status<400){try{var R={};if(x.status!==204){if(!x.response&&x.responseText){x.response=x.responseText;}if(x.response){R.response=typeof x.response==="string"?JSON.parse(x.response):x.response;}}R.status=x.status;if(x.getResponseHeader("X-CSRF-Token")){R.xsrfToken=x.getResponseHeader("X-CSRF-Token");}if(x.getResponseHeader("Etag")){R.etag=x.getResponseHeader("Etag");}r(R);}catch(E){E.userMessage=b("MSG_LOADING_SERVER_RESPONSE_ERROR");c(E);}}else{var s="";try{var o=JSON.parse(x.response);if(Array.isArray(o.messages)&&o.messages.length){s=o.messages.reduce(function(C,d){return C.concat(d.severity==="Error"?d.text+"\n":"");},s);}}catch(e){}c(_(x,s));}};x.ontimeout=function(){c(_(x,b("MSG_CONNECTION_TIMEOUT_ERROR")));};x.onerror=function(){c(_(x,b("MSG_NETWORK_ERROR")));};if(p&&p.payload){x.send(p.payload);}else{x.send();}});}};});
sap.ui.predefine('sap/ui/fl/initial/_internal/storageResultDisassemble',["sap/ui/fl/initial/_internal/StorageUtils","sap/base/util/merge","sap/base/util/isEmptyObject"],function(S,m,i){"use strict";
function _(f,c){if(c.content.fileName!==c.content.variantManagementReference){f.push(c.content);}c.controlChanges.forEach(function(o){f.push(o);});for(var C in c.variantChanges){f=f.concat(c.variantChanges[C]);}return f;}
function a(c){var I=true;if(c){Object.keys(c).some(function(k){if(c[k].length){I=false;return true;}});}return I;}
return function(r){var f;if(!i(r.variantSection)){f=r.changes||[];for(var v in r.variantSection){var V=r.variantSection[v];for(var c in V.variantManagementChanges){f=f.concat(V.variantManagementChanges[c]);}f=V.variants.reduce(_,f);}var g=S.getGroupedFlexObjects(f);var d=S.filterAndSortResponses(g);delete r.changes;delete r.variantSection;m(d[0]||{},r);return d;}if(a(r.comp)){f=r.changes||[];r.comp={variants:[],changes:[],defaultVariants:[],standardVariants:[]};f.slice().reverse().forEach(function(F,n,A){var M=false;if(F.fileType==="variant"){r.comp.variants.unshift(F);M=true;}else{switch(F.changeType){case"addFavorite":case"removeFavorite":r.comp.changes.unshift(F);M=true;break;case"defaultVariant":r.comp.defaultVariants.unshift(F);M=true;break;case"standardVariant":r.comp.standardVariants.unshift(F);M=true;break;default:break;}}if(M){var b=A.length-1-n;r.changes.splice(b,1);}});}return[r];};});
sap.ui.predefine('sap/ui/fl/requireAsync',[],function(){"use strict";return function(m){return new Promise(function(r,R){sap.ui.require([m],function(M){r(M);},function(e){R(e);});});};});
sap.ui.predefine('sap/ui/fl/variants/VariantManagement',["sap/ui/model/Context","sap/ui/model/PropertyBinding","sap/ui/model/json/JSONModel","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/Device","sap/ui/core/InvisibleText","sap/ui/core/Control","sap/ui/core/Icon","sap/ui/layout/HorizontalLayout","sap/ui/layout/Grid","sap/m/SearchField","sap/m/RadioButton","sap/m/ColumnListItem","sap/m/Column","sap/m/Text","sap/m/Bar","sap/m/Table","sap/m/Page","sap/m/Toolbar","sap/m/ToolbarSpacer","sap/m/Button","sap/m/ToggleButton","sap/m/CheckBox","sap/m/Dialog","sap/m/Input","sap/m/Label","sap/m/Title","sap/m/ResponsivePopover","sap/m/SelectList","sap/m/ObjectIdentifier","sap/m/OverflowToolbar","sap/m/OverflowToolbarLayoutData","sap/m/VBox","sap/ui/events/KeyCodes","sap/ui/core/library","sap/m/library","sap/ui/fl/Utils"],function(C,P,J,F,a,D,I,b,c,H,G,S,R,d,f,T,B,g,h,i,j,k,l,m,n,o,L,p,q,r,O,s,t,V,K,u,v,w){"use strict";var x=v.OverflowToolbarPriority;var y=v.ButtonType;var z=v.PlacementType;var A=v.PopinDisplay;var E=v.ScreenSize;var M=u.ValueState;var N=u.TextAlign;
var Q=b.extend("sap.ui.fl.variants.VariantManagement",{
metadata:{interfaces:["sap.m.IOverflowToolbarContent"],library:"sap.ui.fl",designtime:"sap/ui/fl/designtime/variants/VariantManagement.designtime",properties:{showSetAsDefault:{type:"boolean",group:"Misc",defaultValue:true},manualVariantKey:{type:"boolean",group:"Misc",defaultValue:false},inErrorState:{type:"boolean",group:"Misc",defaultValue:false},editable:{type:"boolean",group:"Misc",defaultValue:true},modelName:{type:"string",group:"Misc",defaultValue:null},updateVariantInURL:{type:"boolean",group:"Misc",defaultValue:false},resetOnContextChange:{type:"boolean",group:"Misc",defaultValue:true},executeOnSelectionForStandardDefault:{type:"boolean",group:"Misc",defaultValue:false}},associations:{"for":{type:"sap.ui.core.Control",multiple:true}},events:{save:{parameters:{name:{type:"string"},overwrite:{type:"boolean"},key:{type:"string"},execute:{type:"boolean"},def:{type:"boolean"}}},manage:{},initialized:{},select:{parameters:{key:{type:"string"}}}}},
renderer:{apiVersion:2,render:function(e,U){e.openStart("div",U).class("sapUiFlVarMngmt").attr("title",U._oRb.getText("VARIANT_MANAGEMENT_TRIGGER_TT")).openEnd();e.renderControl(U.oVariantLayout);e.close("div");}}
});
Q.INNER_MODEL_NAME="$sapUiFlVariants";Q.MAX_NAME_LEN=100;Q.COLUMN_FAV_IDX=0;Q.COLUMN_NAME_IDX=1;
Q.prototype.init=function(){this._sModelName=w.VARIANT_MODEL_NAME;this.attachModelContextChange(this._setModel,this);this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.fl");this._createInnerModel();this.oVariantInvisibleText=new I();this.oVariantText=new p(this.getId()+"-text",{text:{path:'currentVariant',model:this._sModelName,formatter:function(U){var W="";if(U){W=this.getSelectedVariantText(U);this._setInvisibleText(W,this.getModified());}return W;}.bind(this)}});this.oVariantText.addStyleClass("sapUiFlVarMngmtClickable");this.oVariantText.addStyleClass("sapUiFlVarMngmtTitle");if(D.system.phone){this.oVariantText.addStyleClass("sapUiFlVarMngmtTextPhoneMaxWidth");}else{this.oVariantText.addStyleClass("sapUiFlVarMngmtTextMaxWidth");}var e=new L(this.getId()+"-modified",{text:"*",visible:{path:"modified",model:this._sModelName,formatter:function(U){var W=this.getCurrentVariantKey();if(W){this._setInvisibleText(this.getSelectedVariantText(W),U);}return((U===null)||(U===undefined))?false:U;}.bind(this)}});e.setVisible(false);e.addStyleClass("sapUiFlVarMngmtModified");e.addStyleClass("sapUiFlVarMngmtClickable");e.addStyleClass("sapMTitleStyleH4");this.oVariantPopoverTrigger=new l(this.getId()+"-trigger",{icon:"sap-icon://slim-arrow-down",type:y.Transparent,tooltip:this._oRb.getText("VARIANT_MANAGEMENT_TRIGGER_TT"),press:function(){this._oCtrlRef=this.oVariantPopoverTrigger;}.bind(this)});this.oVariantPopoverTrigger.addAriaLabelledBy(this.oVariantInvisibleText);this.oVariantPopoverTrigger.addStyleClass("sapUiFlVarMngmtTriggerBtn");this.oVariantPopoverTrigger.addStyleClass("sapMTitleStyleH4");this.oVariantLayout=new H({content:[this.oVariantText,e,this.oVariantPopoverTrigger]});this.oVariantLayout.addStyleClass("sapUiFlVarMngmtLayout");e.setVisible(false);this.oVariantInvisibleText.toStatic();this.addDependent(this.oVariantLayout);};
Q.prototype.getOverflowToolbarConfig=function(){var e={canOverflow:false,invalidationEvents:["save","manage","select"]};return e;};
Q.prototype.getTitle=function(){return this.oVariantText;};
Q.prototype._setInvisibleText=function(e,U){var W;if(e){if(U){W="VARIANT_MANAGEMENT_SEL_VARIANT_MOD";}else{W="VARIANT_MANAGEMENT_SEL_VARIANT";}this.oVariantInvisibleText.setText(this._oRb.getText(W,[e]));}};
Q.prototype._createInnerModel=function(){var e=new J({showExecuteOnSelection:false,showSetAsDefault:true,editable:true,popoverTitle:this._oRb.getText("VARIANT_MANAGEMENT_VARIANTS")});this.setModel(e,Q.INNER_MODEL_NAME);this._bindProperties();};
Q.prototype._bindProperties=function(){this.bindProperty("showSetAsDefault",{path:"/showSetAsDefault",model:Q.INNER_MODEL_NAME});this.bindProperty("editable",{path:"/editable",model:Q.INNER_MODEL_NAME});};
Q.prototype._getShowExecuteOnSelection=function(){var e=this.getModel(Q.INNER_MODEL_NAME);if(e){return e.getProperty("/showExecuteOnSelection");}return false;};
Q.prototype._setShowExecuteOnSelection=function(e){var U=this.getModel(Q.INNER_MODEL_NAME);if(U){U.setProperty("/showExecuteOnSelection",e);}};
Q.prototype.setExecuteOnSelection=function(e){var U=this.getModel(this._sModelName);if(U&&this.oContext){U.setProperty(this.oContext+"/executeOnSelection",e);}};
Q.prototype.getOriginalDefaultVariantKey=function(){var e=this.getModel(this._sModelName);if(e&&this.oContext){return e.getProperty(this.oContext+"/originalDefaultVariant");}return null;};
Q.prototype.setDefaultVariantKey=function(e){var U=this.getModel(this._sModelName);if(U&&this.oContext){U.setProperty(this.oContext+"/defaultVariant",e);}};
Q.prototype.getDefaultVariantKey=function(){var e=this.getModel(this._sModelName);if(e&&this.oContext){return e.getProperty(this.oContext+"/defaultVariant");}return null;};
Q.prototype.setCurrentVariantKey=function(e){var U=this.getModel(this._sModelName);if(U&&this.oContext){U.setProperty(this.oContext+"/currentVariant",e);}return this;};
Q.prototype.getCurrentVariantKey=function(){var e=this.getModel(this._sModelName);if(e&&this.oContext){return e.getProperty(this.oContext+"/currentVariant");}return null;};
Q.prototype._assignPopoverTitle=function(){var e;var U;var W=this.getModel(this._sModelName);if(W&&this.oContext){e=W.getProperty(this.oContext+"/popoverTitle");}if(e!==undefined){U=this.getModel(Q.INNER_MODEL_NAME);if(U){U.setProperty("/popoverTitle",e);}}};
Q.prototype.getVariants=function(){return this._getItems();};
Q.prototype.setModified=function(e){var U=this.getModel(this._sModelName);if(U&&this.oContext){U.setProperty(this.oContext+"/modified",e);}};
Q.prototype.getModified=function(){var e=this.getModel(this._sModelName);if(e&&this.oContext){return e.getProperty(this.oContext+"/modified");}return false;};
Q.prototype.getSelectedVariantText=function(e){var U=this._getItemByKey(e);if(U){return U.title;}return"";};
Q.prototype.getStandardVariantKey=function(){var e=this._getItems();if(e&&e[0]){return e[0].key;}return null;};
Q.prototype.getShowFavorites=function(){var e=this.getModel(this._sModelName);if(e&&this.oContext){return e.getProperty(this.oContext+"/showFavorites");}return false;};
Q.prototype._clearDeletedItems=function(){this._aDeletedItems=[];};
Q.prototype._addDeletedItem=function(e){this._aDeletedItems.push(e);};
Q.prototype._getDeletedItems=function(){return this._aDeletedItems;};
Q.prototype._getItems=function(){var e=[];if(this.oContext&&this.oContext.getObject()){e=this.oContext.getObject().variants.filter(function(U){if(!U.hasOwnProperty("visible")){return true;}return U.visible;});}return e;};
Q.prototype._getItemByKey=function(e){var U=null;var W=this._getItems();W.some(function(X){if(X.key===e){U=X;}return(U!==null);});return U;};
Q.prototype._rebindControl=function(){this.oVariantText.unbindProperty("text");this.oVariantText.bindProperty("text",{path:'currentVariant',model:this._sModelName,formatter:function(e){var U=this.getSelectedVariantText(e);return U;}.bind(this)});this.oVariantText.unbindProperty("visible");this.oVariantText.bindProperty("visible",{path:"modified",model:this._sModelName,formatter:function(e){return(e===null||e===undefined)?false:e;}});};
Q.prototype.setModelName=function(e){if(this.getModelName()){this.oContext=null;}this.setProperty("modelName",e);this._sModelName=e;this._rebindControl();return this;};
Q.prototype._setBindingContext=function(){var e;var U;if(!this.oContext){e=this.getModel(this._sModelName);if(e){U=this._getLocalId(e);if(U){this.oContext=new C(e,"/"+U);this.setBindingContext(this.oContext,this._sModelName);if(!this.getModelName()&&e.registerToModel){e.registerToModel(this);}this._assignPopoverTitle();this._registerPropertyChanges(e);this.fireInitialized();}}}};
Q.prototype._getLocalId=function(e){if(this.getModelName()&&(this._sModelName!==w.VARIANT_MODEL_NAME)){return this.getId();}return e.getVariantManagementReferenceForControl(this);};
Q.prototype._setModel=function(){this._setBindingContext();};
Q.prototype._registerPropertyChanges=function(e){var U=new P(e,this.oContext+"/showExecuteOnSelection");U.attachChange(function(W){if(W&&W.oSource&&W.oSource.oModel&&W.oSource.sPath){var X=W.oSource.oModel.getProperty(W.oSource.sPath);if(X!==undefined){this._setShowExecuteOnSelection(X);}}}.bind(this));U=new P(e,this.oContext+"/variantsEditable");U.attachChange(function(W){if(W&&W.oSource&&W.oSource.oModel&&W.oSource.sPath){var X;var Y=W.oSource.oModel.getProperty(W.oSource.sPath);X=this.getModel(Q.INNER_MODEL_NAME);if(X&&(Y!==undefined)){X.setProperty("/editable",Y);}}}.bind(this));};
Q.prototype.handleOpenCloseVariantPopover=function(){if(!this.bPopoverOpen){this._openVariantList();}else if(this.oVariantPopOver&&this.oVariantPopOver.isOpen()){this.oVariantPopOver.close();}else if(this.getInErrorState()&&this.oErrorVariantPopOver&&this.oErrorVariantPopOver.isOpen()){this.oErrorVariantPopOver.close();}};
Q.prototype.getFocusDomRef=function(){if(this.oVariantPopoverTrigger){return this.oVariantPopoverTrigger.getFocusDomRef();}};
Q.prototype.onclick=function(){if(this.oVariantPopoverTrigger&&!this.bPopoverOpen){this.oVariantPopoverTrigger.focus();}this.handleOpenCloseVariantPopover();};
Q.prototype.onkeyup=function(e){if(e.which===K.F4||e.which===K.SPACE||e.altKey===true&&e.which===K.ARROW_UP||e.altKey===true&&e.which===K.ARROW_DOWN){this._openVariantList();}};
Q.prototype.onAfterRendering=function(){this.oVariantText.$().off("mouseover").on("mouseover",function(){this.oVariantPopoverTrigger.addStyleClass("sapUiFlVarMngmtTriggerBtnHover");}.bind(this));this.oVariantText.$().off("mouseout").on("mouseout",function(){this.oVariantPopoverTrigger.removeStyleClass("sapUiFlVarMngmtTriggerBtnHover");}.bind(this));};
Q.prototype._openInErrorState=function(){var U;if(!this.oErrorVariantPopOver){U=new V({fitContainer:true,alignItems:sap.m.FlexAlignItems.Center,items:[new c({size:"4rem",color:"lightgray",src:"sap-icon://message-error"}),new p({titleStyle:sap.ui.core.TitleLevel.H2,text:this._oRb.getText("VARIANT_MANAGEMENT_ERROR_TEXT1")}),new T({textAlign:sap.ui.core.TextAlign.Center,text:this._oRb.getText("VARIANT_MANAGEMENT_ERROR_TEXT2")})]});U.addStyleClass("sapUiFlVarMngmtErrorPopover");this.oErrorVariantPopOver=new q(this.getId()+"-errorpopover",{title:{path:"/popoverTitle",model:Q.INNER_MODEL_NAME},contentWidth:"400px",placement:z.VerticalPreferredBottom,content:[new h(this.getId()+"-errorselpage",{showSubHeader:false,showNavButton:false,showHeader:false,content:[U]})],afterOpen:function(){this.bPopoverOpen=true;}.bind(this),afterClose:function(){if(this.bPopoverOpen){setTimeout(function(){this.bPopoverOpen=false;}.bind(this),200);}}.bind(this),contentHeight:"300px"});this.oErrorVariantPopOver.attachBrowserEvent("keyup",function(e){if(e.which===32){this.oErrorVariantPopOver.close();}}.bind(this));}if(this.bPopoverOpen){return;}this.oErrorVariantPopOver.openBy(this.oVariantLayout);};
Q.prototype._createVariantList=function(){if(this.oVariantPopOver){return;}this.oVariantManageBtn=new k(this.getId()+"-manage",{text:this._oRb.getText("VARIANT_MANAGEMENT_MANAGE"),enabled:true,press:function(){this._openManagementDialog();}.bind(this),layoutData:new t({priority:x.Low})});this.oVariantSaveBtn=new k(this.getId()+"-mainsave",{text:this._oRb.getText("VARIANT_MANAGEMENT_SAVE"),press:function(){this._handleVariantSave();}.bind(this),visible:{path:"modified",model:this._sModelName,formatter:function(U){return U;}},type:y.Emphasized,layoutData:new t({priority:x.Low})});this.oVariantSaveAsBtn=new k(this.getId()+"-saveas",{text:this._oRb.getText("VARIANT_MANAGEMENT_SAVEAS"),press:function(){this._openSaveAsDialog();}.bind(this),layoutData:new t({priority:x.Low})});this._oVariantList=new r(this.getId()+"-list",{selectedKey:{path:"currentVariant",model:this._sModelName},itemPress:function(U){var W=null;if(U&&U.getParameters()){var X=U.getParameters().item;if(X){W=X.getKey();}}if(W){this.setCurrentVariantKey(W);this.fireEvent("select",{key:W});this.oVariantPopOver.close();}}.bind(this)});this._oVariantList.setNoDataText(this._oRb.getText("VARIANT_MANAGEMENT_NODATA"));var e=new sap.ui.core.Item({key:'{'+this._sModelName+">key}",text:'{'+this._sModelName+">title}"});this._oVariantList.bindAggregation("items",{path:"variants",model:this._sModelName,template:e});this._oSearchField=new S(this.getId()+"-search");this._oSearchField.attachLiveChange(function(U){this._triggerSearch(U,this._oVariantList);}.bind(this));this.oVariantSelectionPage=new h(this.getId()+"-selpage",{subHeader:new i({content:[this._oSearchField]}),content:[this._oVariantList],footer:new s({content:[new j(this.getId()+"-spacer"),this.oVariantSaveBtn,this.oVariantSaveAsBtn,this.oVariantManageBtn]}),showNavButton:false,showHeader:false,showFooter:{path:"/editable",model:Q.INNER_MODEL_NAME}});this.oVariantPopOver=new q(this.getId()+"-popover",{title:{path:"/popoverTitle",model:Q.INNER_MODEL_NAME},titleAlignment:"Auto",contentWidth:"400px",placement:z.VerticalPreferredBottom,content:[this.oVariantSelectionPage],afterOpen:function(){this.bPopoverOpen=true;this.oVariantPopoverTrigger.setPressed(true);}.bind(this),afterClose:function(){this.oVariantPopoverTrigger.setPressed(false);if(this.bPopoverOpen){setTimeout(function(){this.bPopoverOpen=false;}.bind(this),200);}}.bind(this),contentHeight:"300px"});this.oVariantPopOver.addStyleClass("sapUiFlVarMngmtPopover");if(this.oVariantLayout.$().closest(".sapUiSizeCompact").length>0){this.oVariantPopOver.addStyleClass("sapUiSizeCompact");}this.addDependent(this.oVariantPopOver);};
Q.prototype.showSaveButton=function(e){if(e===false){this.oVariantSaveAsBtn.setType(y.Emphasized);this.oVariantSaveBtn.setVisible(false);}else{this.oVariantSaveAsBtn.setType(y.Default);this.oVariantSaveBtn.setVisible(true);}};
Q.prototype._openVariantList=function(){var e;if(this.getInErrorState()){this._openInErrorState();return;}if(this.bPopoverOpen){return;}if(!this.oContext){return;}this._createVariantList();this._oSearchField.setValue("");this._oVariantList.getBinding("items").filter(this._getFilters());this.oVariantSelectionPage.setShowSubHeader(this._oVariantList.getItems().length>9);this.showSaveButton(false);if(this.getModified()){e=this._getItemByKey(this.getCurrentVariantKey());if(e&&e.change){this.showSaveButton(true);}}var U=this._oCtrlRef?this._oCtrlRef:this.oVariantLayout;this._oCtrlRef=null;this.oVariantPopOver.openBy(U);};
Q.prototype._triggerSearch=function(e,U){if(!e){return;}var W=e.getParameters();if(!W){return;}var X=W.newValue?W.newValue:"";var Y=new F({path:"title",operator:a.Contains,value1:X});U.getBinding("items").filter(this._getFilters(Y));};
Q.prototype._createSaveAsDialog=function(){if(!this.oSaveAsDialog){this.oInputName=new o(this.getId()+"-name",{liveChange:function(){this._checkVariantNameConstraints(this.oInputName);}.bind(this)});var e=new L(this.getId()+"-namelabel",{text:this._oRb.getText("VARIANT_MANAGEMENT_NAME")});e.setLabelFor(this.oInputName);e.addStyleClass("sapUiFlVarMngmtSaveDialogLabel");this.oDefault=new m(this.getId()+"-default",{text:this._oRb.getText("VARIANT_MANAGEMENT_SETASDEFAULT"),visible:{path:"/showSetAsDefault",model:Q.INNER_MODEL_NAME},width:"100%"});this.oExecuteOnSelect=new m(this.getId()+"-execute",{text:this._oRb.getText("VARIANT_MANAGEMENT_EXECUTEONSELECT"),visible:{path:"/showExecuteOnSelection",model:Q.INNER_MODEL_NAME},width:"100%"});this.oInputManualKey=new o(this.getId()+"-key",{liveChange:function(){this._checkVariantNameConstraints(this.oInputManualKey);}.bind(this)});this.oLabelKey=new L(this.getId()+"-keylabel",{text:this._oRb.getText("VARIANT_MANAGEMENT_KEY"),required:true});this.oLabelKey.setLabelFor(this.oInputManualKey);this.oSaveSave=new k(this.getId()+"-variantsave",{text:this._oRb.getText("VARIANT_MANAGEMENT_SAVE"),type:y.Emphasized,press:function(){if(!this._bSaveOngoing){this._checkVariantNameConstraints(this.oInputName);if(this.oInputName.getValueState()==="Error"){return;}this._bSaveOngoing=true;this._bSaveCanceled=false;this._handleVariantSaveAs(this.oInputName.getValue());}}.bind(this),enabled:true});var U=new G({defaultSpan:"L12 M12 S12"});if(this.getShowSetAsDefault()){U.addContent(this.oDefault);}if(this._getShowExecuteOnSelection()){U.addContent(this.oExecuteOnSelect);}this.oSaveAsDialog=new n(this.getId()+"-savedialog",{title:this._oRb.getText("VARIANT_MANAGEMENT_SAVEDIALOG"),afterClose:function(){this._bSaveOngoing=false;}.bind(this),beginButton:this.oSaveSave,endButton:new k(this.getId()+"-variantcancel",{text:this._oRb.getText("VARIANT_MANAGEMENT_CANCEL"),press:function(){this._bSaveCanceled=true;this.oSaveAsDialog.close();}.bind(this)}),content:[e,this.oInputName,this.oLabelKey,this.oInputManualKey,U],stretch:D.system.phone});this.oSaveAsDialog.addStyleClass("sapUiPopupWithPadding");this.oSaveAsDialog.addStyleClass("sapUiFlVarMngmtSaveDialog");if(this.oVariantLayout.$().closest(".sapUiSizeCompact").length>0){this.oSaveAsDialog.addStyleClass("sapUiSizeCompact");}this.addDependent(this.oSaveAsDialog);}};
Q.prototype._openSaveAsDialog=function(){this._createSaveAsDialog();this.oInputName.setValue(this.getSelectedVariantText(this.getCurrentVariantKey()));this.oInputName.setEnabled(true);this.oInputName.setValueState(M.None);this.oInputName.setValueStateText(null);this.oDefault.setSelected(false);this.oExecuteOnSelect.setSelected(false);if(this.oVariantPopOver){this.oVariantPopOver.close();}if(this.getManualVariantKey()){this.oInputManualKey.setVisible(true);this.oInputManualKey.setEnabled(true);this.oInputManualKey.setValueState(M.None);this.oInputManualKey.setValueStateText(null);this.oLabelKey.setVisible(true);}else{this.oInputManualKey.setVisible(false);this.oLabelKey.setVisible(false);}this.oSaveAsDialog.open();};
Q.prototype._handleVariantSaveAs=function(e){var U=null;var W=e.trim();var X=this.oInputManualKey.getValue().trim();if(W===""){this.oInputName.setValueState(M.Error);this.oInputName.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_ERROR_EMPTY"));return;}if(this.getManualVariantKey()){if(X===""){this.oInputManualKey.setValueState(M.Error);this.oInputManualKey.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_ERROR_EMPTY"));return;}U=X;}if(this.oSaveAsDialog){this.oSaveAsDialog.close();}if(this.oDefault.getSelected()){this.setDefaultVariantKey(U);}this.setModified(false);this.fireSave({key:U,name:W,overwrite:false,def:this.oDefault.getSelected(),execute:this.oExecuteOnSelect.getSelected()});};
Q.prototype._handleVariantSave=function(){var e=this._getItemByKey(this.getCurrentVariantKey());var U=false;if(this.getDefaultVariantKey()===e.key){U=true;}if(this.oVariantPopOver){this.oVariantPopOver.close();}this.fireSave({name:e.title,overwrite:true,key:e.key,def:U});this.setModified(false);};
Q.prototype.openManagementDialog=function(e,U){if(e&&this.oManagementDialog){this.oManagementDialog.destroy();this.oManagementDialog=undefined;}this._openManagementDialog(U);};
Q.prototype._triggerSearchInManageDialog=function(e,U){if(!e){return;}var W=e.getParameters();if(!W){return;}var X=W.newValue?W.newValue:"";var Y=[this._getVisibleFilter(),new F({filters:[new F({path:"title",operator:a.Contains,value1:X}),new F({path:"author",operator:a.Contains,value1:X})],and:false})];U.getBinding("items").filter(Y);this._bDeleteOccured=true;};
Q.prototype.getManageDialog=function(){return this.oManagementDialog;};
Q.prototype._createManagementDialog=function(){if(!this.oManagementDialog||this.oManagementDialog.bIsDestroyed){this.oManagementTable=new g(this.getId()+"-managementTable",{growing:true,columns:[new f({width:"3rem",visible:{path:"showFavorites",model:this._sModelName}}),new f({header:new T({text:this._oRb.getText("VARIANT_MANAGEMENT_NAME")}),width:"14rem"}),new f({header:new T({text:this._oRb.getText("VARIANT_MANAGEMENT_DEFAULT"),wrappingType:"Hyphenated"}),width:"4rem",demandPopin:true,popinDisplay:A.Inline,minScreenWidth:E.Tablet,visible:{path:"/showSetAsDefault",model:Q.INNER_MODEL_NAME}}),new f({header:new T({text:this._oRb.getText("VARIANT_MANAGEMENT_EXECUTEONSELECT"),wrappingType:"Hyphenated"}),width:"6rem",hAlign:N.Center,demandPopin:true,popinDisplay:A.Inline,minScreenWidth:"800px",visible:{path:"/showExecuteOnSelection",model:Q.INNER_MODEL_NAME}}),new f({header:new T({text:this._oRb.getText("VARIANT_MANAGEMENT_AUTHOR")}),width:"8rem",demandPopin:true,popinDisplay:A.Inline,minScreenWidth:"900px"}),new f({width:"2rem",hAlign:N.Center}),new f({visible:false})]});this.oManagementSave=new k(this.getId()+"-managementsave",{text:this._oRb.getText("VARIANT_MANAGEMENT_OK"),enabled:true,type:y.Emphasized,press:function(){this._handleManageSavePressed();}.bind(this)});this.oManagementCancel=new k(this.getId()+"-managementcancel",{text:this._oRb.getText("VARIANT_MANAGEMENT_CANCEL"),press:function(){this._resumeManagementTableBinding();this.oManagementDialog.close();this._handleManageCancelPressed();}.bind(this)});this.oManagementDialog=new n(this.getId()+"-managementdialog",{contentWidth:"40%",resizable:true,draggable:true,title:this._oRb.getText("VARIANT_MANAGEMENT_MANAGEDIALOG"),beginButton:this.oManagementSave,endButton:this.oManagementCancel,content:[this.oManagementTable],stretch:D.system.phone});this.oManagementDialog.isPopupAdaptationAllowed=function(){return false;};this._oSearchFieldOnMgmtDialog=new S();this._oSearchFieldOnMgmtDialog.attachLiveChange(function(U){this._triggerSearchInManageDialog(U,this.oManagementTable);}.bind(this));var e=new B(this.getId()+"-mgmHeaderSearch",{contentMiddle:[this._oSearchFieldOnMgmtDialog]});this.oManagementDialog.setSubHeader(e);if(this.oVariantLayout.$().closest(".sapUiSizeCompact").length>0){this.oManagementDialog.addStyleClass("sapUiSizeCompact");}this.addDependent(this.oManagementDialog);this.oManagementTable.bindAggregation("items",{path:"variants",model:this._sModelName,factory:this._templateFactoryManagementDialog.bind(this),filters:this._getVisibleFilter()});this._bDeleteOccured=false;}};
Q.prototype._setFavoriteIcon=function(e,U){if(e){e.setSrc(U?"sap-icon://favorite":"sap-icon://unfavorite");e.setTooltip(this._oRb.getText(U?"VARIANT_MANAGEMENT_FAV_DEL_TOOLTIP":"VARIANT_MANAGEMENT_FAV_ADD_TOOLTIP"));e.setAlt(this._oRb.getText(U?"VARIANT_MANAGEMENT_FAV_DEL_ACC":"VARIANT_MANAGEMENT_FAV_ADD_ACC"));}};
Q.prototype._templateFactoryManagementDialog=function(e,U){var W=null;var X;var Y;var Z;var $=U.getObject();if(!$){return undefined;}var _=function(h1){this._checkVariantNameConstraints(h1.oSource,h1.oSource.getBindingContext(this._sModelName).getObject().key);}.bind(this);var a1=function(h1){this._handleManageTitleChanged(h1.oSource.getBindingContext(this._sModelName).getObject());}.bind(this);var b1=function(h1){if(h1.getParameters().selected===true){this._handleManageDefaultVariantChange(h1.oSource,h1.oSource.getBindingContext(this._sModelName).getObject());}}.bind(this);var c1=function(h1){this._handleManageExecuteOnSelectionChanged(h1.oSource.getBindingContext(this._sModelName).getObject());}.bind(this);var d1=function(h1){this._handleManageDeletePressed(h1.oSource.getBindingContext(this._sModelName).getObject());var i1=h1.oSource.getParent();if(i1){i1.setVisible(false);}this._reCheckVariantNameConstraints();}.bind(this);var e1=function(h1){this._handleManageFavoriteChanged(h1.oSource,h1.oSource.getBindingContext(this._sModelName).getObject());}.bind(this);if($.rename){Z=new o({liveChange:_,change:a1,value:'{'+this._sModelName+">title}"});}else{Z=new O({title:'{'+this._sModelName+">title}"});if(W){Z.setTooltip(W);}}X=new k({icon:"sap-icon://sys-cancel",enabled:true,type:y.Transparent,press:d1,tooltip:this._oRb.getText("VARIANT_MANAGEMENT_DELETE"),visible:$.remove});this._assignColumnInfoForDeleteButton(X);Y=this.oContext.getPath();var f1=new c({src:{path:"favorite",model:this._sModelName,formatter:function(h1){return h1?"sap-icon://favorite":"sap-icon://unfavorite";}},tooltip:{path:'favorite',model:this._sModelName,formatter:function(h1){return this._oRb.getText(h1?"VARIANT_MANAGEMENT_FAV_DEL_TOOLTIP":"VARIANT_MANAGEMENT_FAV_ADD_TOOLTIP");}.bind(this)},press:e1});f1.addStyleClass("sapUiFlVarMngmtFavColor");var g1=new d({cells:[f1,Z,new R({groupName:this.getId(),select:b1,selected:{path:Y+"/defaultVariant",model:this._sModelName,formatter:function(h1){return $.key===h1;}}}),new m({select:c1,selected:'{'+this._sModelName+">executeOnSelect}"}),new T({text:'{'+this._sModelName+">author}",textAlign:"Begin"}),X,new T({text:'{'+this._sModelName+">key}"})]});return g1;};
Q.prototype._openManagementDialog=function(e){this._createManagementDialog();if(this.oVariantPopOver){this.oVariantPopOver.close();}this._suspendManagementTableBinding();this._clearDeletedItems();this._oSearchFieldOnMgmtDialog.setValue("");if(this._bDeleteOccured){this._bDeleteOccured=false;this.oManagementTable.bindAggregation("items",{path:"variants",model:this._sModelName,factory:this._templateFactoryManagementDialog.bind(this),filters:this._getVisibleFilter()});}if(e){this.oManagementDialog.addStyleClass(e);}this.oManagementDialog.open();};
Q.prototype._assignColumnInfoForDeleteButton=function(e){if(!this._oInvisibleDeleteColumnName){this._oInvisibleDeleteColumnName=new I({text:this._oRb.getText("VARIANT_MANAGEMENT_ACTION_COLUMN")});this.oManagementDialog.addContent(this._oInvisibleDeleteColumnName);}if(this._oInvisibleDeleteColumnName){e.addAriaLabelledBy(this._oInvisibleDeleteColumnName);}};
Q.prototype._handleManageDefaultVariantChange=function(e,U){var W=U.key;if(this.getShowFavorites()&&!U.favorite&&e){U.favorite=true;this._setFavoriteIcon(e.getParent().getCells()[Q.COLUMN_FAV_IDX],true);}this.setDefaultVariantKey(W);};
Q.prototype._handleManageCancelPressed=function(){var e;var U;this._getDeletedItems().forEach(function(W){W.visible=true;});this._getItems().forEach(function(W){W.title=W.originalTitle;W.favorite=W.originalFavorite;W.executeOnSelection=W.originalExecuteOnSelection;});e=this.getOriginalDefaultVariantKey();if(e!==this.getDefaultVariantKey()){this.setDefaultVariantKey(e);}U=this.getModel(this._sModelName);if(U){U.checkUpdate();}};
Q.prototype._handleManageFavoriteChanged=function(e,U){if((this.getDefaultVariantKey()===U.key)&&U.favorite){return;}U.favorite=!U.favorite;this._setFavoriteIcon(e,U.favorite);};
Q.prototype._getRowForKey=function(e){var U=null;if(this.oManagementTable){this.oManagementTable.getItems().some(function(W){if(e===W.getCells()[0].getBindingContext(this._sModelName).getObject().key){U=W;}return U!==null;}.bind(this));}return U;};
Q.prototype._handleManageDeletePressed=function(e){var U;var W=e.key;if(this.oManagementTable.getItems().length===1){return;}e.visible=false;this._addDeletedItem(e);if((W===this.getDefaultVariantKey())){this.setDefaultVariantKey(this.getStandardVariantKey());if(this.getShowFavorites()){var X=this._getItemByKey(this.getStandardVariantKey());if(X&&!X.favorite){var Y=this._getRowForKey(this.getStandardVariantKey());if(Y){X.favorite=true;this._setFavoriteIcon(Y.getCells()[Q.COLUMN_FAV_IDX],true);}}}}U=this.getModel(this._sModelName);if(U){U.checkUpdate();}this.oManagementCancel.focus();};
Q.prototype._handleManageExecuteOnSelectionChanged=function(){};
Q.prototype._handleManageTitleChanged=function(){};
Q.prototype._handleManageSavePressed=function(){if(this._anyInErrorState(this.oManagementTable)){return;}this._getDeletedItems().some(function(e){if(e.key===this.getCurrentVariantKey()){var U=this.getStandardVariantKey();this.setModified(false);this.setCurrentVariantKey(U);this.fireEvent("select",{key:U});return true;}return false;}.bind(this));this.fireManage();this._resumeManagementTableBinding();this.oManagementDialog.close();};
Q.prototype._resumeManagementTableBinding=function(){if(this.oManagementTable){var e=this.oManagementTable.getBinding("items");if(e){e.resume();}}};
Q.prototype._suspendManagementTableBinding=function(){if(this.oManagementTable){var e=this.oManagementTable.getBinding("items");if(e){e.suspend();}}};
Q.prototype._anyInErrorState=function(e){var U;var W;var X=false;if(e){U=e.getItems();U.some(function(Y){W=Y.getCells()[Q.COLUMN_NAME_IDX];if(W&&W.getValueState&&(W.getValueState()===M.Error)){X=true;}return X;});}return X;};
Q.prototype._getFilters=function(e){var U=[];if(e){U.push(e);}U.push(this._getVisibleFilter());if(this.getShowFavorites()){U.push(this._getFilterFavorites());}return U;};
Q.prototype._getVisibleFilter=function(){return new F({path:"visible",operator:a.EQ,value1:true});};
Q.prototype._getFilterFavorites=function(){return new F({path:"favorite",operator:a.EQ,value1:true});};
Q.prototype._verifyVariantNameConstraints=function(e,U){if(!e){return;}var W=e.getValue();W=W.trim();if(!this._checkIsDuplicate(W,U)){if(W===""){e.setValueState(M.Error);e.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_ERROR_EMPTY"));}else if(W.indexOf('{')>-1){e.setValueState(M.Error);e.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_NOT_ALLOWED_CHAR",["{"]));}else if(W.length>Q.MAX_NAME_LEN){e.setValueState(M.Error);e.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_MAX_LEN",[Q.MAX_NAME_LEN]));}else{e.setValueState(M.None);e.setValueStateText(null);}}else{e.setValueState(M.Error);e.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_ERROR_DUPLICATE"));}};
Q.prototype._checkVariantNameConstraints=function(e,U){this._verifyVariantNameConstraints(e,U);if(this.oManagementDialog&&this.oManagementDialog.isOpen()){this._reCheckVariantNameConstraints();}};
Q.prototype._reCheckVariantNameConstraints=function(){var e;var U=false;if(this.oManagementTable){e=this.oManagementTable.getItems();e.some(function(W){var X=W.getBindingContext(this._sModelName).getObject();if(X&&X.visible){var Y=W.getCells()[Q.COLUMN_NAME_IDX];if(Y&&Y.getValueState&&(Y.getValueState()===M.Error)){this._verifyVariantNameConstraints(Y,X.key);if(Y.getValueState()===M.Error){U=true;}}}return U;}.bind(this));}return U;};
Q.prototype._checkIsDuplicate=function(e,U){if(this.oManagementDialog&&this.oManagementDialog.isOpen()){return this._checkIsDuplicateInManageTable(e,U);}return this._checkIsDuplicateInModel(e,U);};
Q.prototype._checkIsDuplicateInModel=function(e,U){var W=false;var X=this._getItems();var Y=e.toLowerCase();X.some(function(Z){if(Z.title.toLowerCase()===Y){if(U&&(U===Z.key)){return false;}W=true;}return W;});return W;};
Q.prototype._checkIsDuplicateInManageTable=function(e,U){var W;var X=false;var Y=e.toLowerCase();if(this.oManagementTable){W=this.oManagementTable.getItems();W.some(function(Z){var $;var _=Z.getBindingContext(this._sModelName).getObject();if(_&&_.visible){var a1=Z.getCells()[Q.COLUMN_NAME_IDX];if(a1&&(_.key!==U)){if(a1.isA("sap.m.Input")){$=a1.getValue().toLowerCase();}else{$=a1.getTitle().toLowerCase();}if($===Y){X=true;}}return X;}}.bind(this));}return X;};
Q.prototype.exit=function(){var e;if(this.oVariantInvisibleText){this.oVariantInvisibleText.destroy(true);this.oVariantInvisibleText=undefined;}if(this.oDefault&&!this.oDefault._bIsBeingDestroyed){this.oDefault.destroy();}this.oDefault=undefined;if(this.oExecuteOnSelect&&!this.oExecuteOnSelect._bIsBeingDestroyed){this.oExecuteOnSelect.destroy();}this.oExecuteOnSelect=undefined;this._oRb=undefined;this.oContext=undefined;this._oVariantList=undefined;this.oVariantSelectionPage=undefined;this.oVariantLayout=undefined;this.oVariantText=undefined;this.oVariantPopoverTrigger=undefined;this._oSearchField=undefined;this._oSearchFieldOnMgmtDialog=undefined;e=this.getModel(Q.INNER_MODEL_NAME);if(e){e.destroy();}};
return Q;});
sap.ui.predefine('sap/ui/fl/variants/VariantModel',["sap/base/util/restricted/_omit","sap/base/util/each","sap/base/util/includes","sap/base/util/isEmptyObject","sap/base/util/merge","sap/base/util/ObjectPath","sap/base/Log","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/core/BusyIndicator","sap/ui/fl/apply/_internal/changes/Reverter","sap/ui/fl/apply/_internal/controlVariants/URLHandler","sap/ui/fl/apply/_internal/flexState/controlVariants/Switcher","sap/ui/fl/apply/_internal/flexState/controlVariants/VariantManagementState","sap/ui/fl/apply/_internal/controlVariants/Utils","sap/ui/fl/changeHandler/Base","sap/ui/fl/Change","sap/ui/fl/Layer","sap/ui/fl/LayerUtils","sap/ui/fl/Utils","sap/ui/model/json/JSONModel"],function(_,e,i,a,m,O,L,J,B,R,U,S,V,b,c,C,d,f,g,h){"use strict";
function j(E,P){return n(function(t,v){var M=v.model;var u=v.vmReference;var x=false;var T=t.key;var y=t.key;return Promise.resolve().then(function(){if(O.get([u,"currentVariant"],M.oData)&&M.oData[u].currentVariant!==M.oData[u].originalCurrentVariant){y=M.oData[u].originalCurrentVariant;x=true;return M.updateCurrentVariant(u,T,M.oAppComponent,true);}}).then(function(){if(O.get([u,"modified"],M.oData)===true){var z=V.getControlChangesForVariant({reference:M.sFlexReference,vmReference:u,vReference:y,changeInstance:true});return k({changes:z,vmReference:u,vReference:y,revert:!x,model:M}).then(function(){M.oData[u].originalCurrentVariant=T;M.oData[u].modified=false;M.checkUpdate(true);});}}).then(function(){if(!x){M._callVariantSwitchListeners(u,M.oData[u].currentVariant);}});}.bind(null,E.getParameters(),P),P.model,P.vmReference);}
function k(P){var v=P.model._getDirtyChangesFromVariantChanges(P.changes);return Promise.resolve().then(function(){if(P.revert){return R.revertMultipleChanges(v,{appComponent:P.model.oAppComponent,modifier:J,flexController:P.model.oFlexController});}}).then(function(){v.forEach(function(t){V.removeChangeFromVariant({reference:P.model.sFlexReference,change:t,vmReference:P.vmReference,vReference:P.vReference});P.model.oFlexController.deleteChange(t,P.model.oAppComponent);});});}
function l(M,v,t){if(t||M.oData[v]){M.oData[v].variantBusy=t;}M.checkUpdate();}
function n(t,M,v){M._oVariantSwitchPromise=M._oVariantSwitchPromise.catch(function(){}).then(l.bind(null,M,v,true)).then(t).then(l.bind(null,M,v,false)).catch(function(E){l(M,v,false);throw E;});M.oFlexController.setVariantSwitchPromise(M._oVariantSwitchPromise);return M._oVariantSwitchPromise;}
function r(P){return S.switchVariant(P).then(function(){delete this.oData[P.vmReference];}.bind(this)).catch(function(E){L.warning(E.message);});}
function s(P){return S.switchVariant(P).then(function(){this.oData[P.vmReference].originalCurrentVariant=P.newVReference;this.oData[P.vmReference].currentVariant=P.newVReference;if(this.oData[P.vmReference].updateVariantInURL){U.updateVariantInURL({vmReference:P.vmReference,newVReference:P.newVReference,model:this});}this._callVariantSwitchListeners(P.vmReference,P.newVReference);this.checkUpdate();}.bind(this));}
function o(v,t,D){if((v.layer===f.getCurrentLayer(!D))&&(v.key!==t)){return true;}return false;}
function w(t){return new Promise(function(u){if(t.getDomRef()){u();}else{t.addEventDelegate({onAfterRendering:function(){u();}});}});}
var p=h.extend("sap.ui.fl.variants.VariantModel",{constructor:function(D,F,A,t){this.pSequentialImportCompleted=Promise.resolve();h.apply(this,arguments);this.bObserve=t;if(!F){F=sap.ui.requireSync("sap/ui/fl/FlexControllerFactory").createForControl(A);}this.oFlexController=F;this.oChangePersistence=this.oFlexController._oChangePersistence;this.sFlexReference=this.oChangePersistence.getComponentName();this.oAppComponent=A;this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.fl");this._oVariantSwitchPromise=Promise.resolve();this._oVariantAppliedListeners={};if(a(D)){try{D=V.fillVariantModel({reference:this.sFlexReference});}catch(E){L.error("Variants Map was not found: "+E.message);}}if(D&&typeof D==="object"){Object.keys(D).forEach(function(K){D[K].variants.forEach(function(v){if(!D[K].currentVariant&&(v.key===D[K].defaultVariant)){D[K].currentVariant=v.key;}v.originalTitle=v.title;v.originalFavorite=v.favorite;v.originalExecuteOnSelect=v.executeOnSelect;v.originalVisible=v.visible;});D[K].originalCurrentVariant=D[K].currentVariant;D[K].originalDefaultVariant=D[K].defaultVariant;});this.setData(D);}U.initialize({model:this});}});
p.prototype.updateCurrentVariant=function(v,N,A,I){var P={vmReference:v,currentVReference:this.oData[v].originalCurrentVariant,newVReference:N,flexController:this.oFlexController,appComponent:A||this.oAppComponent,modifier:J,reference:this.sFlexReference};if(I){return s.call(this,P);}return n(s.bind(this,P),this,v);};
p.prototype.getCurrentVariantReference=function(v){return this.oData[v].currentVariant;};
p.prototype.getVariantManagementReference=function(v){var t="";var I=-1;Object.keys(this.oData).some(function(K){return this.oData[K].variants.some(function(u,x){if(u.key===v){t=K;I=x;return true;}});}.bind(this));return{variantManagementReference:t,variantIndex:I};};
p.prototype.getVariant=function(v,t){return V.getVariant({reference:this.sFlexReference,vmReference:t||this.getVariantManagementReference(v).variantManagementReference,vReference:v});};
p.prototype.getVariantProperty=function(v,P){return this.getVariant(v).content.content[P];};
function q(v){var t=V.getVariantChangesForVariant({vmReference:v,reference:this.sFlexReference});var u=this.oData[v].currentVariant;var D=this.oData[v].defaultVariant;if(this.oData[v]._executeOnSelectionForStandardDefault&&u===D&&u===v&&!t.setExecuteOnSelect){var x=V.getVariant({reference:this.sFlexReference,vmReference:v,vReference:v});x.content.content.executeOnSelect=true;this.oData[v].variants[0].originalExecuteOnSelect=true;this.oData[v].variants[0].executeOnSelect=true;return true;}}
p.prototype.attachVariantApplied=function(P){var v=this.getVariantManagementReferenceForControl(sap.ui.getCore().byId(P.vmControlId));return this.waitForVMControlInit(v).then(function(v,P){if(!this._oVariantAppliedListeners[v]){this._oVariantAppliedListeners[v]={};}var I=q.call(this,v);if(P.callAfterInitialVariant||I){var t={appComponent:this.oAppComponent,reference:this.sFlexReference,vmReference:v,flexController:this.oFlexController};V.waitForInitialVariantChanges(t).then(function(){var u=V.getCurrentVariantReference({vmReference:v,reference:this.sFlexReference});this._callVariantSwitchListeners(v,u,P.callback);}.bind(this));}return w(P.control).then(function(){if(b.getRelevantVariantManagementControlId(P.control,this.getVariantManagementControlIds())===P.vmControlId){this.oData[v].showExecuteOnSelection=true;this.checkUpdate(true);this._oVariantAppliedListeners[v][P.control.getId()]=P.callback;}else{L.error("Error in attachVariantApplied: The passed VariantManagement ID does not match the responsible VariantManagement control");}}.bind(this));}.bind(this,v,P));};
p.prototype._callVariantSwitchListeners=function(v,N,t){if(this._oVariantAppliedListeners[v]){var u;this.oData[v].variants.some(function(x){if(x.key===N){u=x;return true;}});if(t){t(u);}else{e(this._oVariantAppliedListeners[v],function(x,t){t(u);});}}};
p.prototype.detachVariantApplied=function(v,t){var u=this.getVariantManagementReferenceForControl(sap.ui.getCore().byId(v));if(this._oVariantAppliedListeners[u]){delete this._oVariantAppliedListeners[u][t];}};
p.prototype.addChange=function(t){var v=t.getVariantReference();var u=this.getVariantManagementReference(v).variantManagementReference;this.oData[u].modified=!!this.oData[u].variantsEditable;this.checkUpdate(true);return V.addChangeToVariant({reference:this.sFlexReference,change:t,vmReference:u,vReference:v});};
p.prototype.removeChange=function(t){var v=t.getVariantReference();var u=this.getVariantManagementReference(v).variantManagementReference;return V.removeChangeFromVariant({reference:this.sFlexReference,change:t,vmReference:u,vReference:v});};
p.prototype._getVariantTitleCount=function(N,v){var D=this.getData();return D[v].variants.reduce(function(t,u){if(N.toLowerCase()===u.title.toLowerCase()&&u.visible){t++;}return t;},0);};
p.prototype._duplicateVariant=function(P){var N=P.newVariantReference;var t=P.sourceVariantReference;var v=P.variantManagementReference;var u=this.getVariant(t);var x=V.getControlChangesForVariant({vmReference:v,vReference:t,changeInstance:true,reference:this.sFlexReference}).map(function(E){return E.getDefinition();});var D={content:{},controlChanges:x,variantChanges:{}};var y=f.compareAgainstCurrentLayer(u.content.layer,!this._bDesignTimeMode?d.USER:"");Object.keys(u.content).forEach(function(K){if(K==="fileName"){D.content[K]=N;}else if(K==="variantReference"){if(y===0){D.content[K]=u.content["variantReference"];}else if(y===-1){D.content[K]=t;}}else if(K==="content"){D.content[K]=JSON.parse(JSON.stringify(u.content[K]));D.content.content.title=P.title;}else{D.content[K]=u.content[K];}});D.content["layer"]=P.layer;x=D.controlChanges.slice();var z={};var A;D.controlChanges=x.reduce(function(E,F){if(f.compareAgainstCurrentLayer(F.layer,!this._bDesignTimeMode?d.USER:"")===0){z=m({},F);z.variantReference=D.content.fileName;if(!z.support){z.support={};}z.support.sourceChangeFileName=F.fileName;z.packageName="$TMP";A=C.createInitialFileContent(z);E.push(new C(A));}return E;}.bind(this),[]);return D;};
p.prototype.copyVariant=function(P){var D=this._duplicateVariant(P);var v={key:D.content.fileName,layer:P.layer,title:D.content.content.title,originalTitle:D.content.content.title,originalExecuteOnSelect:D.content.content.executeOnSelect,executeOnSelect:false,favorite:true,originalFavorite:true,rename:true,change:true,remove:true,visible:true,originalVisible:true};var t=b.createVariant({model:this,variantSpecificData:D});var u=[];[t].concat(t.getControlChanges()).forEach(function(x){u.push(this.oChangePersistence.addDirtyChange(x));}.bind(this));var I=V.addVariantToVariantManagement({variantData:m({},t.getDefinitionWithChanges(),{content:{content:{visible:v.visible,favorite:v.favorite}}}),reference:this.sFlexReference,vmReference:P.variantManagementReference});this.oData[P.variantManagementReference].variants.splice(I,0,v);return this.updateCurrentVariant(P.variantManagementReference,t.getId(),P.appComponent,true).then(function(){return u;});};
p.prototype.removeVariant=function(P){var t=this.oChangePersistence.getDirtyChanges().filter(function(u){return(u.getVariantReference&&u.getVariantReference()===P.variant.getId())||u.getId()===P.variant.getId();});return this.updateCurrentVariant(P.variantManagementReference,P.sourceVariantReference,P.component).then(function(){var I=V.removeVariantFromVariantManagement({reference:this.sFlexReference,variant:P.variant,vmReference:P.variantManagementReference});this.oData[P.variantManagementReference].variants.splice(I,1);this.checkUpdate();t.forEach(function(u){this.oChangePersistence.deleteChange(u);}.bind(this));}.bind(this));};
p.prototype.collectModelChanges=function(v,t){var D=this.getData()[v];var M=D.variants;var u=[];var P={};M.forEach(function(x){if(x.originalTitle!==x.title){P={variantReference:x.key,changeType:"setTitle",title:x.title,originalTitle:x.originalTitle,layer:t};u.push(P);}if(x.originalFavorite!==x.favorite){P={variantReference:x.key,changeType:"setFavorite",favorite:x.favorite,originalFavorite:x.originalFavorite,layer:t};u.push(P);}if(x.originalExecuteOnSelect!==x.executeOnSelect){P={variantReference:x.key,changeType:"setExecuteOnSelect",executeOnSelect:x.executeOnSelect,originalExecuteOnSelect:x.originalExecuteOnSelect,layer:t};u.push(P);}if(!x.visible&&x.originalVisible){P={variantReference:x.key,changeType:"setVisible",visible:false,layer:t};u.push(P);}});if(D.originalDefaultVariant!==D.defaultVariant){P={variantManagementReference:v,changeType:"setDefault",defaultVariant:D.defaultVariant,originalDefaultVariant:D.originalDefaultVariant,layer:t};u.push(P);}return u;};
p.prototype.manageVariants=function(v,t,u,x){return new Promise(function(y){v.attachEventOnce("manage",{resolve:y,variantManagementReference:t,layer:u},this.fnManageClickRta,this);v.openManagementDialog(true,x);}.bind(this));};
p.prototype.setVariantProperties=function(v,P,A){var t=-1;var u;var x=null;var D=this.getData();if(P.variantReference){t=this.getVariantManagementReference(P.variantReference).variantIndex;u=D[v].variants[t];}var N={};var y={};switch(P.changeType){case"setTitle":y.title=P.title;u.title=P.title;u.originalTitle=u.title;break;case"setFavorite":y.favorite=P.favorite;u.favorite=P.favorite;u.originalFavorite=u.favorite;break;case"setExecuteOnSelect":y.executeOnSelect=P.executeOnSelect;if(u){u.executeOnSelect=P.executeOnSelect;u.originalExecuteOnSelect=u.executeOnSelect;}break;case"setVisible":y.visible=P.visible;y.createdByReset=false;u.visible=P.visible;u.originalVisible=u.visible;break;case"setDefault":y.defaultVariant=P.defaultVariant;D[v].defaultVariant=P.defaultVariant;D[v].originalDefaultVariant=D[v].defaultVariant;var H=U.getStoredHashParams({model:this});if(H){if(D[v].defaultVariant!==D[v].currentVariant&&H.indexOf(D[v].currentVariant)===-1){U.update({parameters:H.concat(D[v].currentVariant),updateURL:!this._bDesignTimeMode,updateHashEntry:true,model:this});}else if(D[v].defaultVariant===D[v].currentVariant&&H.indexOf(D[v].currentVariant)>-1){H.splice(H.indexOf(D[v].currentVariant),1);U.update({parameters:H,updateURL:!this._bDesignTimeMode,updateHashEntry:true,model:this});}}if(!A&&D[v].currentVariant!==P.defaultVariant){this.updateCurrentVariant(v,P.defaultVariant,P.appComponent);}break;default:break;}var z=V.getContent(this.sFlexReference);if(t>-1){var E=V.setVariantData({variantData:y,vmReference:v,previousIndex:t,reference:this.sFlexReference});D[v].variants.splice(t,1);D[v].variants.splice(E,0,u);}else if(z[v]){z[v].defaultVariant=P.defaultVariant;}var F={vmReference:v,add:A,reference:this.sFlexReference};if(A===true){N.changeType=P.changeType;N.layer=P.layer;if(P.changeType==="setDefault"){N.fileType="ctrl_variant_management_change";N.selector=J.getSelector(v,P.appComponent);}else{if(P.changeType==="setTitle"){c.setTextInChange(N,"title",P.title,"XFLD");}N.fileType="ctrl_variant_change";N.selector=J.getSelector(P.variantReference,P.appComponent);}x=this.oFlexController.createBaseChange(N,P.appComponent);x.setContent(y);F.changeContent=x.getDefinition();V.updateChangesForVariantManagementInMap(F);this.oChangePersistence.addDirtyChange(x);}else if(P.change){F.changeContent=P.change.getDefinition();V.updateChangesForVariantManagementInMap(F);this.oChangePersistence.deleteChange(P.change);}this.setData(D);this.checkUpdate(true);return x;};
p.prototype._ensureStandardVariantExists=function(v){var D=this.getData();var t=D[v]||{};var u=_(t,["initPromise"]);if(!D[v]||a(u)){D[v]=m(t,{currentVariant:v,originalCurrentVariant:v,defaultVariant:v,originalDefaultVariant:v,variants:[{key:v,title:this._oResourceBundle.getText("STANDARD_VARIANT_TITLE"),originalTitle:this._oResourceBundle.getText("STANDARD_VARIANT_ORIGINAL_TITLE"),favorite:true,originalFavorite:true,executeOnSelect:false,originalExecuteOnSelect:false,visible:true,originalVisible:true,author:b.DEFAULT_AUTHOR}]});this.setData(D);var x={};x[v]={defaultVariant:v,variantManagementChanges:{},variants:[{content:{fileName:v,fileType:"ctrl_variant",variantManagementReference:v,variantReference:"",support:{user:b.DEFAULT_AUTHOR},content:{title:this._oResourceBundle.getText("STANDARD_VARIANT_TITLE"),favorite:true,visible:true,executeOnSelect:false}},controlChanges:[],variantChanges:{}}]};try{var y=V.getContent(this.sFlexReference);m(y,x);}catch(E){L.error("Variants Map was not found: "+E.message);}}};
p.prototype.setModelPropertiesForControl=function(v,D,t){this.oData[v].modified=false;this.oData[v].showFavorites=true;var u=this._bDesignTimeMode;if(u!==D){this._bDesignTimeMode=D;if(D){U.clearAllVariantURLParameters({model:this});}else if(u){U.update({parameters:U.getStoredHashParams({model:this}),updateURL:true,updateHashEntry:false,model:this});}}if(!(typeof this.fnManageClick==="function"&&typeof this.fnManageClickRta==="function")){this._initializeManageVariantsEvents();}t.detachManage(this.fnManageClick,this);if(D){this.oData[v].variantsEditable=false;this.oData[v].variants.forEach(function(x){x.rename=true;x.change=true;x.remove=o(x,v,D);});}else if(this.oData[v]._isEditable){t.attachManage({variantManagementReference:v},this.fnManageClick,this);this.oData[v].variantsEditable=true;this.oData[v].variants.forEach(function(x){x.remove=o(x,v,D);if(x.layer===f.getCurrentLayer(true)){x.rename=true;x.change=true;}else{x.rename=false;x.change=false;}});}else{this.oData[v].variantsEditable=false;this.oData[v].variants.forEach(function(x){x.remove=false;x.rename=false;x.change=false;});}};
p.prototype._initializeManageVariantsEvents=function(){this.fnManageClickRta=function(E,D){var t=this.collectModelChanges(D.variantManagementReference,D.layer);D.resolve(t);};this.fnManageClick=function(E,D){if(!this.oFlexController||!V.getContent(this.sFlexReference)){return;}var t=this.collectModelChanges(D.variantManagementReference,f.getCurrentLayer(true));var u=[];t.forEach(function(v){v.appComponent=this.oAppComponent;u.push(this.setVariantProperties(D.variantManagementReference,v,true));}.bind(this));this.oChangePersistence.saveDirtyChanges(this.oAppComponent,false,u);};};
p.prototype._handleSave=function(E){var v=E.getSource();var A=g.getAppComponentForControl(v);var t=this.getLocalId(v.getId(),A);return n(function(u,A,P){var x=P.def;var y=P.execute;var z=this.getCurrentVariantReference(u);var D=V.getControlChangesForVariant({reference:this.sFlexReference,vmReference:u,vReference:z,changeInstance:true});if(P["overwrite"]){return this.oFlexController.saveSequenceOfDirtyChanges(this._getDirtyChangesFromVariantChanges(D),A).then(function(G){this.checkDirtyStateForControlModels([u]);return G;}.bind(this));}var N=g.createDefaultFileName();var F={variantManagementReference:u,appComponent:A,layer:f.getCurrentLayer(true),title:P["name"],sourceVariantReference:z,newVariantReference:N};return this.copyVariant(F).then(function(G){if(x){var H={changeType:"setDefault",defaultVariant:N,originalDefaultVariant:this.oData[u].defaultVariant,appComponent:A,layer:f.getCurrentLayer(true),variantManagementReference:u};var I=this.setVariantProperties(u,H,true);G.push(I);}if(y){var K={changeType:"setExecuteOnSelect",executeOnSelect:true,variantReference:N,appComponent:A,layer:f.getCurrentLayer(true),variantManagementReference:u};var M=this.setVariantProperties(u,K,true);G.push(M);}this.oData[u].modified=false;this.checkUpdate(true);return k({changes:D,vmReference:u,vReference:z,model:this}).then(this.oFlexController.saveSequenceOfDirtyChanges.bind(this.oFlexController,G,A)).then(function(Q){if(Q){var T=Q.response[0];this.oData[u].variants.forEach(function(W){if(W.key===T.fileName){W.author=T.support.user;}});}}.bind(this));}.bind(this));}.bind(this,t,A,E.getParameters()),this,t);};
p.prototype.getLocalId=function(I,A){return J.getSelector(I,A).id;};
p.prototype.getVariantManagementReferenceForControl=function(v){var t=v.getId();var A=g.getAppComponentForControl(v);return(A&&A.getLocalId(t))||t;};
p.prototype.switchToDefaultForVariantManagement=function(v){if(this.oData[v].currentVariant!==this.oData[v].defaultVariant){B.show(200);this.updateCurrentVariant(v,this.oData[v].defaultVariant).then(function(){B.hide();});}};
p.prototype.switchToDefaultForVariant=function(v){Object.keys(this.oData).forEach(function(t){if(!v||this.oData[t].currentVariant===v){this.switchToDefaultForVariantManagement(t);}}.bind(this));};
p.prototype.registerToModel=function(v){var t=this.getVariantManagementReferenceForControl(v);this._ensureStandardVariantExists(t);this.oData[t]._isEditable=v.getEditable();this.oData[t]._executeOnSelectionForStandardDefault=v.getExecuteOnSelectionForStandardDefault();this.oData[t].showExecuteOnSelection=false;v.attachEvent("select",{vmReference:t,model:this},j);v.attachSave(this._handleSave,this);this.setModelPropertiesForControl(t,false,v);var u=v.getUpdateVariantInURL();this.oData[t].updateVariantInURL=u;U.registerControl({vmReference:t,updateURL:!!u,model:this});U.handleModelContextChange({model:this,vmControl:v});if(this.oData[t].initPromise){this.oData[t].initPromise.resolveFunction();delete this.oData[t].initPromise;}this.oData[t].init=true;};
p.prototype.waitForVMControlInit=function(v){if(!this.oData[v]){this.oData[v]={};}else if(this.oData[v].init){return Promise.resolve();}this.oData[v].initPromise={};this.oData[v].initPromise.promise=new Promise(function(t){this.oData[v].initPromise.resolveFunction=t;}.bind(this));return this.oData[v].initPromise.promise;};
p.prototype._getDirtyChangesFromVariantChanges=function(t){var u=t.map(function(v){return v.getDefinition().fileName;});return this.oChangePersistence.getDirtyChanges().filter(function(v){return i(u,v.getId());});};
p.prototype.checkDirtyStateForControlModels=function(v){v.forEach(function(t){var u=this.oData[t];if(u.modified===true){var x=this.getCurrentVariantReference(t);var y=V.getControlChangesForVariant({reference:this.sFlexReference,vmReference:t,vReference:x,changeInstance:true});var D=this._getDirtyChangesFromVariantChanges(y);if(D.length===0){u.modified=false;}}}.bind(this));this.checkUpdate(true);};
p.prototype.getCurrentControlVariantIds=function(){return Object.keys(this.oData||{}).reduce(function(t,v){return t.concat([this.oData[v].currentVariant]);}.bind(this),[]);};
p.prototype.getVariantManagementControlIds=function(){var v;return Object.keys(this.oData||{}).reduce(function(t,u){if(this.oAppComponent.byId(u)){v=this.oAppComponent.createId(u);}else{v=u;}t.push(v);return t;}.bind(this),[]);};
p.prototype.resetMap=function(){var v=Object.keys(this.oData);v.forEach(function(t){var P={vmReference:t,currentVReference:this.oData[t].currentVariant||this.oData[t].defaultVariant,newVReference:true,appComponent:this.oAppComponent,flexController:this.oFlexController,modifier:J,reference:this.sFlexReference};return n(r.bind(this,P),this,t);}.bind(this));return this._oVariantSwitchPromise.then(function(){V.resetContent(this.sFlexReference);U.initialize({model:this});U.update({parameters:[],updateHashEntry:true,model:this});}.bind(this));};
return p;},true);
sap.ui.predefine('sap/ui/fl/write/_internal/SaveAs',["sap/ui/fl/write/_internal/appVariant/AppVariantFactory","sap/ui/fl/apply/_internal/appVariant/DescriptorChangeTypes","sap/ui/fl/write/_internal/appVariant/AppVariantInlineChangeFactory","sap/ui/fl/apply/_internal/ChangesController","sap/ui/fl/Utils","sap/base/Log","sap/ui/fl/Layer","sap/base/util/includes","sap/base/util/merge","sap/base/util/restricted/_omit","sap/ui/fl/registry/Settings"],function(A,D,a,C,U,L,b,i,m,_,S){"use strict";
function c(P){return S.getInstance().then(function(s){if(!P.package&&(P.layer===b.VENDOR||(P.layer===b.CUSTOMER_BASE&&!s.isAtoEnabled()))){return Promise.reject("Package must be provided or is valid");}if(P.isForSmartBusiness&&(P.package!=='$TMP'&&P.package!=='')&&!P.transport&&!s.isAtoEnabled()){return Promise.reject("Transport must be provided");}if(P.isForSmartBusiness&&P.transport||(P.package==="$TMP")){return Promise.resolve({packageName:P.package,transport:P.transport});}return Promise.resolve({packageName:"",transport:""});});}
function d(q,t){var T=t.transport?q.setTransportRequest(t.transport):Promise.resolve();return T.then(function(){if(t.packageName){return q.setPackage(t.packageName);}return Promise.resolve();});}
function e(q){var I=[];q.forEach(function(r){var s=r.getDefinition();var t={changeType:s.changeType,content:s.content};if(s.texts){t.texts=s.texts;}I.push(a.createNew(t));});return Promise.all(I);}
function f(q,r){var P={reference:r.getId()};var s=U.createNamespace(P,"changes");q.setNamespace(s);q.setComponent(r.getId());}
function g(q,r){var s=[];q.forEach(function(I){I.replaceHostingIdForTextKey(r.getId(),r.getReference(),I.getContent(),I.getTexts());s.push(r.addDescriptorInlineChange(I));});return Promise.all(s);}
function h(s){var q=C.getDescriptorFlexControllerInstance(s)._oChangePersistence;if(q){var r=q.getDirtyChanges();r=r.slice();return r;}return[];}
function j(s){var F=C.getFlexControllerInstance(s)._oChangePersistence;if(F){var u=F.getDirtyChanges();u=u.slice();return u;}return[];}
function k(s){var F=C.getFlexControllerInstance(s)._oChangePersistence;var q=C.getDescriptorFlexControllerInstance(s)._oChangePersistence;return F===q;}
function l(s,q,r){var t=[];if(q){h(s).forEach(function(u){if(i(D.getChangeTypes(),u.getDefinition().changeType)){t.push(u);}else{f(u,r);}});}else{j(s).forEach(function(u){f(u,r);});t=h(s);}return t;}
function n(s){h(s).forEach(function(q){if(i(D.getChangeTypes(),q.getChangeType())){C.getDescriptorFlexControllerInstance(s)._oChangePersistence.deleteChange(q);}});}
function o(q,P){if(!q){throw new Error("App variant with ID: "+P.id+"does not exist");}P.package=q.getPackage();P.layer=q.getDefinition().layer;return c(P).then(function(t){return d(q,t);}).then(function(){return q;});}
var p={saveAs:function(P){var q;var r;var s=false;return A.prepareCreate(P).then(function(t){q=m({},t);return c(P);}).then(function(t){return d(q,t);}).then(function(){s=k(P.selector);var t=l(P.selector,s,q);return e(t);}).then(function(t){return g(t,q);}).then(function(){return q.submit().catch(function(E){E.messageKey="MSG_SAVE_APP_VARIANT_FAILED";throw E;});}).then(function(R){r=m({},R);if(s){n(P.selector);}var F=C.getFlexControllerInstance(P.selector);var u=j(P.selector);if(u.length){return F.saveAll(C.getAppComponentForSelector(P.selector),true).catch(function(E){if(s){n(P.selector);}return this.deleteAppVariant({id:P.id}).then(function(){E.messageKey="MSG_COPY_UNSAVED_CHANGES_FAILED";throw E;});}.bind(this));}return Promise.resolve();}.bind(this)).then(function(){if(!s){n(P.selector);}return r;}).catch(function(E){if(h(P.selector).length){n(P.selector);}L.error("the app variant could not be created.",E.message||E);throw E;});},updateAppVariant:function(P){var q;var r;return A.prepareUpdate(_(P,"selector")).catch(function(E){E.messageKey="MSG_LOAD_APP_VARIANT_FAILED";throw E;}).then(function(s){if(!s){throw new Error("App variant with ID: "+P.id+"does not exist");}q=m({},s);P.package=q.getPackage();P.layer=q.getDefinition().layer;return c(P);}).then(function(t){return d(q,t);}).then(function(){var s=[];h(P.selector).forEach(function(t){if(i(D.getChangeTypes(),t.getDefinition().changeType)){s.push(t);}});return e(s);}).then(function(s){return g(s,q);}).then(function(){return q.submit().catch(function(E){if(P.isForSmartBusiness){n(P.selector);throw E;}E.messageKey="MSG_UPDATE_APP_VARIANT_FAILED";throw E;});}).then(function(R){r=m({},R);n(P.selector);return r;}).catch(function(E){if(h(P.selector).length){n(P.selector);}L.error("the app variant could not be updated.",E.message||E);throw E;});},deleteAppVariant:function(P){return A.prepareDelete(_(P,"selector")).catch(function(E){E.messageKey="MSG_LOAD_APP_VARIANT_FAILED";throw E;}).then(function(q){return((P.isForSmartBusiness)?Promise.resolve(q):o(q,P));}).then(function(q){return q.submit().catch(function(E){if(E==="cancel"){return Promise.reject("cancel");}E.messageKey="MSG_DELETE_APP_VARIANT_FAILED";throw E;});}).catch(function(E){if(E==="cancel"){return Promise.reject("cancel");}L.error("the app variant could not be deleted.",E.message||E);throw E;});}};return p;},true);
sap.ui.predefine('sap/ui/fl/write/_internal/Storage',["sap/ui/fl/initial/_internal/StorageUtils","sap/ui/fl/write/_internal/StorageFeaturesMerger","sap/base/util/ObjectPath"],function(S,a,O){"use strict";var W="sap/ui/fl/write/_internal/connectors/";
function _(){return S.getConnectors(W,false);}
function f(l,C){var F=C.filter(function(o){return o.layers.indexOf("ALL")!==-1||o.layers.indexOf(l)!==-1;});if(F.length===1){return F[0];}if(F.length===0){throw new Error("No Connector configuration could be found to write into layer: "+l);}if(F.length>1){throw new Error("sap.ui.core.Configuration 'flexibilityServices' has a misconfiguration: Multiple Connector configurations were found to write into layer: "+l);}}
function b(C){var h=C.map(function(o){return o.writeConnectorModule.loadFeatures({url:o.url}).then(function(F){return{features:F,layers:o.layers};}).catch(S.logAndResolveDefault.bind(null,{features:{},layers:o.layers},o,"loadFeatures"));});return Promise.all(h);}
function c(l){if(!l){return Promise.reject("No layer was provided");}return _().then(f.bind(this,l));}
function d(p){if(p.draft){return new Promise(function(r,h){sap.ui.require(["sap/ui/fl/write/api/FeaturesAPI"],function(F){F.isVersioningEnabled(p.layer).then(function(D){if(D){r();}else{h("Draft is not supported for the given layer: "+p.layer);}});});});}return Promise.resolve();}
function e(A,p){return d(p).then(c.bind(undefined,p.layer)).then(function(C){p.url=C.url;var o=O.get(A,C.writeConnectorModule);return o.call(C.writeConnectorModule,p);});}
var g={};
g.write=function(p){return e("write",p);};
g.remove=function(p){return e("remove",p);};
g.update=function(p){return e("update",p);};
g.reset=function(p){return e("reset",p);};
g.getFlexInfo=function(p){return e("getFlexInfo",p);};
g.loadFeatures=function(){return _().then(b).then(a.mergeResults);};
g.publish=function(p){return e("publish",p);};
g.versions={load:function(p){return _().then(e.bind(undefined,"versions.load",p));},activate:function(p){return _().then(e.bind(undefined,"versions.activate",p));},discardDraft:function(p){return _().then(e.bind(undefined,"versions.discardDraft",p));}};return g;},true);
sap.ui.predefine('sap/ui/fl/write/_internal/StorageFeaturesMerger',["sap/base/util/merge"],function(m){"use strict";var D={isKeyUser:false,isVariantSharingEnabled:false,isAtoAvailable:false,isAtoEnabled:false,versioning:{},isProductiveSystem:true,isZeroDowntimeUpgradeRunning:false,system:"",client:""};
function _(r){var v={};var V=!!r.features.isVersioningEnabled;r.layers.forEach(function(l){v[l]=V;});return v;}
return{mergeResults:function(r){var R=D;r.forEach(function(o){Object.keys(o.features).forEach(function(k){if(k!=="isVersioningEnabled"){R[k]=o.features[k];}});R.versioning=m(R.versioning,_(o));});return R;}};});
sap.ui.predefine('sap/ui/fl/write/_internal/Versions',["sap/ui/fl/registry/Settings","sap/ui/fl/ChangePersistenceFactory","sap/ui/fl/write/_internal/Storage","sap/base/util/UriParameters","sap/ui/model/json/JSONModel","sap/ui/fl/Utils","sap/ui/model/BindingMode"],function(S,C,a,U,J,b,B){"use strict";var _={};var M=9;var c=M+1;
function d(p,v,h){var i=g(h);var n=sap.ui.fl.Versions.Original;h.forEach(function(o){if(o.version===sap.ui.fl.Versions.Draft){o.type="draft";}else if(n===sap.ui.fl.Versions.Original){o.type="active";n=o.version;}else{o.type="inactive";}});var P=b.getParameter(sap.ui.fl.Versions.UrlParameter);var j;if(P){j=parseInt(P);}else if(h.length>0){j=h[0].version;}else{j=sap.ui.fl.Versions.Original;}var m=new J({versioningEnabled:v,versions:h,activeVersion:n,backendDraft:i,dirtyChanges:false,draftAvailable:i,activateEnabled:i,persistedVersion:j,displayedVersion:j});m.setDefaultBindingMode(B.OneWay);m.setSizeLimit(M);m.setDirtyChanges=function(D){m.setProperty("/dirtyChanges",D);m.updateDraftVersion();m.updateBindings(true);};m.updateDraftVersion=function(){var h=m.getProperty("/versions");var v=m.getProperty("/versioningEnabled");var D=m.getProperty("/dirtyChanges");var i=m.getProperty("/backendDraft");var k=v&&(D||i);m.setProperty("/draftAvailable",k);var l=D?sap.ui.fl.Versions.Draft:m.getProperty("/persistedVersion");m.setProperty("/displayedVersion",l);if(!g(h)&&k){h.splice(0,0,{version:sap.ui.fl.Versions.Draft,type:"draft"});}if(g(h)&&!k){h.shift();m.setProperty("/displayedVersion",m.getProperty("/persistedVersion"));}var A=m.getProperty("/displayedVersion")!==m.getProperty("/activeVersion");m.setProperty("/activateEnabled",A);};return m;}
function e(p,D){var h=[];var i=D.changePersistences;i.forEach(function(o){h=o.getDirtyChanges().concat();h.forEach(function(j){o.deleteChange(j,true);});});return h.length>0;}
function f(p){var D={dirtyChangesExist:false,changePersistences:[]};if(p.reference){var o=C.getChangePersistenceForComponent(p.reference);if(o.getDirtyChanges().length>0){D.dirtyChangesExist=true;D.changePersistences.push(o);}}if(p.nonNormalizedReference){var h=C.getChangePersistenceForComponent(p.nonNormalizedReference);if(h.getDirtyChanges().length>0){D.dirtyChangesExist=true;D.changePersistences.push(h);}}return D;}
function g(v){return v.some(function(o){return o.version===sap.ui.fl.Versions.Draft;});}
var V={};
V.initialize=function(p){var r=p.reference;var l=p.layer;p.limit=c;return S.getInstance().then(function(s){var v=s.isVersioningEnabled(l);var h=v?a.versions.load(p):Promise.resolve([]);return h.then(function(i){_[r]=_[r]||{};_[r][l]=_[r][l]||{};_[r][l]=d(p,v,i);return _[r][l];});});};
V.getVersionsModel=function(p){var r=p.reference;var l=p.layer;if(!_[r]||!_[r][l]){throw Error("Versions Model for reference '"+r+"' and layer '"+l+"' were not initialized.");}var D=f(p);if(D.dirtyChangesExist){_[r][l].updateDraftVersion(p);}return _[r][l];};
V.clearInstances=function(){_={};};
V.onAllChangesSaved=function(p){p.reference=b.normalizeReference(p.reference);var m=V.getVersionsModel(p);var v=m.getProperty("/versioningEnabled");var D=m.getProperty("/dirtyChanges");m.setProperty("/dirtyChanges",true);m.setProperty("/backendDraft",v&&D);m.updateDraftVersion();};
V.activate=function(p){var m=V.getVersionsModel(p);var v=m.getProperty("/versions");var D=g(v);var s=m.getProperty("/displayedVersion");var A=m.getProperty("/activeVersion");var n=m.getProperty("/persistedVersion");if(s===A){return Promise.reject("Version is already active");}p.version=s;var h=[];if(m.getProperty("/dirtyChanges")){var o=f(p);var i=o.changePersistences;h=i.map(function(j){return j.saveDirtyChanges(p.appComponent,false,undefined,n);});}return Promise.all(h).then(a.versions.activate.bind(undefined,p)).then(function(j){v.forEach(function(k){k.type="inactive";});j.type="active";if(D){v.shift();}v.splice(0,0,j);m.setProperty("/backendDraft",false);m.setProperty("/dirtyChanges",false);m.setProperty("/draftAvailable",false);m.setProperty("/activateEnabled",false);m.setProperty("/activeVersion",j.version);m.setProperty("/displayedVersion",j.version);m.setProperty("/persistedVersion",j.version);m.updateBindings(true);});};
V.discardDraft=function(p){var m=V.getVersionsModel(p);var v=m.getProperty("/versions");var D=f(p);var h=m.getProperty("/backendDraft");var o=h?a.versions.discardDraft(p):Promise.resolve();return o.then(function(){v.shift();m.setProperty("/backendDraft",false);m.setProperty("/dirtyChanges",false);m.setProperty("/draftAvailable",false);m.setProperty("/activateEnabled",false);m.setProperty("/displayedVersion",m.getProperty("/persistedVersion"));m.updateBindings(true);var i=e(p,D);return{backendChangesDiscarded:h,dirtyChangesDiscarded:i};});};
return V;});
sap.ui.predefine('sap/ui/fl/write/_internal/appVariant/AppVariant',["sap/ui/thirdparty/jquery","sap/ui/base/ManagedObject","sap/ui/fl/descriptorRelated/internal/Utils","sap/ui/fl/write/_internal/connectors/LrepConnector","sap/base/util/merge","sap/base/Log"],function(q,M,U,L,m,a){"use strict";
var A=M.extend("sap.ui.fl.write._internal.appVariant.AppVariant",{
constructor:function(p){M.apply(this);if(!q.isPlainObject(p)){a.error("Constructor : sap.ui.fl.write._internal.appVariant.AppVariant: mPropertyBag is not defined");}this._oDefinition=p;return this;},
metadata:{library:"sap.ui.fl",properties:{mode:{type:"string"}}}
});
A.modes={NEW:"NEW",EXISTING:"EXISTING",DELETION:"DELETION"};
A.prototype._isValidMode=function(s){var b=false;Object.keys(A.modes).some(function(k){if(A.modes[k]===s){b=true;}});return b;};
A.prototype.setMode=function(s){if(this._isValidMode(s)){this.setProperty("mode",s);}else{throw new Error("Provide a correct operation mode");}};
A.prototype.setTransportRequest=function(t){try{U.checkTransportRequest(t);}catch(e){return Promise.reject(e);}this._oDefinition.transport=t;return Promise.resolve();};
A.prototype.setReference=function(r){if(r===undefined||typeof r!=="string"){throw new Error("No parameter sReference of type string provided");}this._oDefinition.reference=r;};
A.prototype.setPackage=function(p){try{U.checkPackage(p);}catch(e){return Promise.reject(e);}this._oDefinition.packageName=p;return Promise.resolve();};
A.prototype.getDefinition=function(){return this._oDefinition;};
A.prototype.getId=function(){return this._oDefinition.id;};
A.prototype.getNamespace=function(){return this._oDefinition.namespace||U.getNameAndNameSpace(this._oDefinition.id,this._oDefinition.reference).namespace;};
A.prototype.getFileName=function(){return this._oDefinition.fileName||U.getNameAndNameSpace(this._oDefinition.id,this._oDefinition.reference).fileName;};
A.prototype.getReference=function(){return this._oDefinition.reference;};
A.prototype.getPackage=function(){return this._oDefinition.packageName;};
A.prototype.getVersion=function(){return this._oDefinition.version;};
A.prototype.getTransportRequest=function(){return this._oDefinition.transport;};
A.prototype.getJson=function(){return m({},this._getMap());};
A.prototype._getMap=function(){var b={};switch(this.getMode()){case A.modes.NEW:b={fileName:this.getFileName(),fileType:"appdescr_variant",namespace:this.getNamespace(),layer:this._oDefinition.layer,packageName:this._oDefinition.packageName?this._oDefinition.packageName:"",reference:this._oDefinition.reference,id:this._oDefinition.id,content:this._oDefinition.content||[]};if(this._oDefinition.referenceVersion){b.referenceVersion=this._oDefinition.referenceVersion;}if(this._oDefinition.version){b.version=this._oDefinition.version;}break;case A.modes.EXISTING:b={fileName:this._oDefinition.fileName,fileType:this._oDefinition.fileType,namespace:this._oDefinition.namespace,layer:this._oDefinition.layer,packageName:this._oDefinition.packageName,reference:this._oDefinition.reference,id:this._oDefinition.id,content:this._oDefinition.content};if(this._oDefinition.referenceVersion){b.referenceVersion=this._oDefinition.referenceVersion;}if(this._oDefinition.version){b.version=this._oDefinition.version;}break;case A.modes.DELETION:b={id:this._oDefinition.id};break;default:}return b;};
A.prototype.addDescriptorInlineChange=function(d){return new Promise(function(r){var s=function(_,i){if(_["setHostingIdForTextKey"]){_.setHostingIdForTextKey(i);}};s(d,this.getId());this._oDefinition.content.push(d.getMap());r(null);}.bind(this));};
A.prototype.submit=function(){var b=this._getMap();var p={flexObject:{},appVariant:this};if(this._oDefinition.transport){p.transport=this._oDefinition.transport;}if(this._oDefinition.skipIam){p.skipIam=this._oDefinition.skipIam;}if(this._oDefinition.isForSmartBusiness){p.isForSmartBusiness=this._oDefinition.isForSmartBusiness;}if(b.layer){p.layer=b.layer;}p.url="/sap/bc/lrep";var B;switch(this.getMode()){case A.modes.NEW:Object.assign(p.flexObject,b);B=L.appVariant.create(p);break;case A.modes.EXISTING:p.reference=b.id;Object.assign(p.flexObject,b);B=L.appVariant.update(p);break;case A.modes.DELETION:p.reference=b.id;B=L.appVariant.remove(p);break;default:return Promise.reject("Please provide a valid operation.");}return B.then(function(r){return r;});};
return A;},true);
sap.ui.predefine('sap/ui/fl/write/_internal/appVariant/AppVariantInlineChange',["sap/ui/thirdparty/jquery","sap/ui/base/ManagedObject","sap/ui/fl/descriptorRelated/internal/Utils","sap/base/Log"],function(q,M,U,L){"use strict";
var A=M.extend("sap.ui.fl.write._internal.appVariant.AppVariantInlineChange",{
metadata:{library:"sap.ui.fl"},
constructor:function(p){M.apply(this);if(!q.isPlainObject(p)){L.error("Constructor : sap.ui.fl.write._internal.appVariant.AppVariantInlineChange: mPropertyBag is not defined");}U.checkTexts(p.texts);this._oDefinition=p;return this;}
});
A.prototype._getChangeType=function(){return this._oDefinition.changeType;};
A.prototype.getMap=function(){return this._oDefinition;};
A.prototype.getContent=function(){return this._oDefinition.content;};
A.prototype.getTexts=function(){return this._oDefinition.texts;};
A.prototype.getHostingIdSuffix=function(){return this._sHostingIdSuffix;};
A.prototype.setHostingIdSuffix=function(h){this._sHostingIdSuffix=h;};
A.prototype.replaceHostingIdForTextKey=function(n,o,c,t){var C=JSON.stringify(c);if(t){Object.keys(t).forEach(function(T){var s;if(T.indexOf(o)===0){s=n+T.substring(o.length);this._oDefinition.texts[s]=this._oDefinition.texts[T];delete this._oDefinition.texts[T];C=C.split("{{"+T+"}}").join("{{"+s+"}}");}},this);this._oDefinition.content=JSON.parse(C);}};
A.prototype.setHostingIdForTextKey=function(h){if(this.getHostingIdSuffix()){var t=h+this.getHostingIdSuffix();if(this._oDefinition.texts){this._oDefinition.texts[t]=this._oDefinition.texts[""];delete this._oDefinition.texts[""];}}};
return A;},true);
sap.ui.predefine('sap/ui/fl/write/_internal/connectors/BackendConnector',["sap/base/util/merge","sap/ui/fl/write/connectors/BaseConnector","sap/ui/fl/initial/_internal/connectors/BackendConnector","sap/ui/fl/initial/_internal/connectors/Utils","sap/ui/fl/write/_internal/connectors/Utils","sap/base/util/restricted/_pick"],function(m,B,I,a,W,_){"use strict";
function b(p){var P={};if(p.parentVersion!==undefined){P.parentVersion=p.parentVersion;}if(this.isLanguageInfoRequired){a.addLanguageInfo(P);}var w=a.getUrl(this.ROUTES.CHANGES,p,P);delete p.fileName;delete P["sap-language"];var t=a.getUrl(this.ROUTES.TOKEN,p,P);var r=W.getRequestOptions(this.initialConnector,t,p.flexObjects||p.flexObject,"application/json; charset=utf-8","json");return W.sendRequest(w,p.method,r);}
function c(p){p.fileName=p.flexObject.fileName;return b.call(this,p);}
var d=m({},B,{xsrfToken:null,reset:function(p){var P=["reference","generator"];var e=_(p,P);if(p.selectorIds){e.selector=p.selectorIds;}if(p.changeTypes){e.changeType=p.changeTypes;}delete p.reference;var r=a.getUrl(this.ROUTES.CHANGES,p,e);var t=a.getUrl(this.ROUTES.TOKEN,p);var R=W.getRequestOptions(this.initialConnector,t);return W.sendRequest(r,"DELETE",R);},write:function(p){p.method="POST";return b.call(this,p).then(function(r){if(r.response&&!Array.isArray(r.response)){r.response=[r.response];}return r;});},update:function(p){p.method="PUT";return c.call(this,p);},remove:function(p){var P={namespace:p.flexObject.namespace};p.fileName=p.flexObject.fileName;var D=a.getUrl(this.ROUTES.CHANGES,p,P);delete p.fileName;var t=a.getUrl(this.ROUTES.TOKEN,p);var r=W.getRequestOptions(this.initialConnector,t,undefined,"application/json; charset=utf-8","json");return W.sendRequest(D,"DELETE",r);},loadFeatures:function(p){if(this.initialConnector.settings){return Promise.resolve({response:this.initialConnector.settings});}var f=a.getUrl(this.ROUTES.SETTINGS,p);return a.sendRequest(f).then(function(r){return r.response;});}});d.initialConnector=I;return d;},true);
sap.ui.predefine('sap/ui/fl/write/_internal/connectors/JsObjectConnector',["sap/base/util/merge","sap/ui/fl/write/api/connectors/ObjectStorageConnector"],function(m,O){"use strict";var M={_itemsStoredAsObjects:true,_items:{},setItem:function(k,v){M._items[k]=v;},removeItem:function(k){delete M._items[k];},clear:function(){M._items={};},getItem:function(k){return M._items[k];},getItems:function(){return M._items;}};var J=m({},O,{storage:M});return J;},true);
sap.ui.predefine('sap/ui/fl/write/_internal/connectors/KeyUserConnector',["sap/base/util/merge","sap/ui/fl/write/_internal/connectors/BackendConnector","sap/ui/fl/initial/_internal/connectors/KeyUserConnector","sap/ui/fl/initial/_internal/connectors/Utils","sap/ui/fl/write/_internal/connectors/Utils"],function(m,B,I,a,W){"use strict";var P="/flex/keyuser";var A="/v1";
function _(p){p.initialConnector=I;p.xsrfToken=I.xsrfToken;p.tokenUrl=K.ROUTES.TOKEN;}
function b(p){var o={title:p.title};p.payload=JSON.stringify(o);p.dataType="json";p.contentType="application/json; charset=utf-8";}
function r(v){v.version=v.versionNumber;delete v.versionNumber;return v;}
var K=m({},B,{layers:I.layers,ROUTES:{CHANGES:P+A+"/changes/",SETTINGS:P+A+"/settings",TOKEN:P+A+"/settings",VERSIONS:{GET:P+A+"/versions/",ACTIVATE:P+A+"/versions/activate/",DISCARD:P+A+"/versions/draft/"}},isLanguageInfoRequired:true});K.versions={load:function(p){_(p);var c={};a.addLanguageInfo(c);c.limit=p.limit;var v=a.getUrl(K.ROUTES.VERSIONS.GET,p,c);return a.sendRequest(v,"GET",p).then(function(R){return R.response.map(function(V){return r(V);});});},activate:function(p){_(p);b(p);var c={version:p.version};a.addLanguageInfo(c);var v=a.getUrl(K.ROUTES.VERSIONS.ACTIVATE,p,c);return W.sendRequest(v,"POST",p).then(function(R){var V=R.response;return r(V);});},discardDraft:function(p){_(p);var v=a.getUrl(K.ROUTES.VERSIONS.DISCARD,p);return W.sendRequest(v,"DELETE",p);}};K.initialConnector=I;return K;},true);
sap.ui.predefine('sap/ui/fl/write/_internal/connectors/LocalStorageConnector',["sap/base/util/merge","sap/ui/fl/write/api/connectors/ObjectStorageConnector"],function(m,O){"use strict";var L=m({},O,{storage:window.localStorage});return L;},true);
sap.ui.predefine('sap/ui/fl/write/_internal/connectors/LrepConnector',["sap/base/util/merge","sap/ui/fl/write/connectors/BaseConnector","sap/ui/fl/initial/_internal/connectors/LrepConnector","sap/ui/fl/initial/_internal/connectors/Utils","sap/ui/fl/write/_internal/connectors/Utils","sap/ui/fl/write/_internal/transport/TransportSelection","sap/ui/fl/registry/Settings","sap/ui/fl/Layer","sap/ui/fl/LayerUtils","sap/ui/fl/Utils","sap/ui/fl/Change","sap/ui/core/Component","sap/ui/core/BusyIndicator","sap/base/Log","sap/m/MessageBox","sap/base/util/restricted/_pick"],function(m,B,I,a,W,T,S,L,b,U,C,c,d,e,M,_){"use strict";var R={FLEX_INFO:"/flex/info/",PUBLISH:"/actions/make_changes_transportable/",CHANGES:"/changes/",VARIANTS:"/variants/",SETTINGS:"/flex/settings",TOKEN:"/actions/getcsrftoken/",APPVARIANTS:"/appdescr_variants/",APPVARIANTS_OVERVIEW:"/app_variant_overview/",UI2PERSONALIZATION:"/ui2personalization/"};var f=function(p){var r;if(p.isLegacyVariant){r=R.VARIANTS;}else if(p.isAppVariant){r=R.APPVARIANTS;}else{r=R.CHANGES;}var P=p.transport?{changelist:p.transport}:{};if(p.skipIam){P.skipIam=p.skipIam;}a.addLanguageInfo(P);I._addClientInfo(P);if(p.flexObject&&!p.isAppVariant){p.fileName=p.flexObject.fileName;}var w=a.getUrl(r,p,P);delete p.reference;delete p.fileName;var t=a.getUrl(R.TOKEN,p);var o=W.getRequestOptions(I,t,p.flexObjects||p.flexObject,"application/json; charset=utf-8","json");return W.sendRequest(w,p.method,o);};var g=function(A){var p=A.getDefinition().layer===L.VENDOR?A.getPackage():"";return new C({fileName:A.getDefinition().fileName,fileType:A.getDefinition().fileType,packageName:p,namespace:A.getNamespace()});};var h=function(p){var t;if(p.transport){t=Promise.resolve({transport:p.transport});}else if(p.isForSmartBusiness){return Promise.resolve();}else{var o=g(p.appVariant);t=new T().openTransportSelection(o);}return t.then(function(i){if(i==="cancel"){return Promise.reject("cancel");}if(i&&i.transport!==undefined){return i.transport;}return Promise.reject(new Error("Transport information could not be determined"));});};return m({},B,{initialConnector:I,layers:I.layers,reset:function(p){d.show(0);var i=[];var t=Promise.resolve();if(p.layer!==L.USER){i=p.changes;t=S.getInstance().then(function(s){if(!s.isProductiveSystem()){return new T().setTransports(i,c.get(p.reference)).then(function(){i.some(function(o){if(o.getRequest()){p.changelist=o.getRequest();return true;}return false;});});}});}return t.then(function(){d.show(0);var P=["reference","layer","changelist","generator"];var j=_(p,P);I._addClientInfo(j);if(p.selectorIds){j.selector=p.selectorIds;}if(p.changeTypes){j.changeType=p.changeTypes;}delete p.reference;var r=a.getUrl(R.CHANGES,p,j);var s=a.getUrl(R.TOKEN,p);var o=W.getRequestOptions(I,s);return W.sendRequest(r,"DELETE",o).then(function(k){if(k&&k.response){k.response.forEach(function(l){l.fileName=l.name;delete l.name;});}d.hide();return k;}).catch(function(E){d.hide();return Promise.reject(E);});});},publish:function(p){var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.fl");var H=function(E){d.hide();var s=r.getText("MSG_TRANSPORT_ERROR",E?[E.message||E]:undefined);var i=r.getText("HEADER_TRANSPORT_ERROR");e.error("transport error"+E);M.show(s,{icon:M.Icon.ERROR,title:i,styleClass:p.transportDialogSettings.styleClass});return"Error";};var t=new T();return t.openTransportSelection(null,p.transportDialogSettings.rootControl,p.transportDialogSettings.styleClass).then(function(o){if(t.checkTransportInfo(o)){d.show(0);var i={reference:p.reference,layer:p.layer};return t._prepareChangesForTransport(o,p.localChanges,p.appVariantDescriptors,i).then(function(){d.hide();if(o.transport==="ATO_NOTIFICATION"){return r.getText("MSG_ATO_NOTIFICATION");}return r.getText("MSG_TRANSPORT_SUCCESS");});}return"Cancel";})['catch'](H);},getFlexInfo:function(p){var P=["layer"];var i=_(p,P);I._addClientInfo(i);var D=a.getUrl(R.FLEX_INFO,p,i);return a.sendRequest(D).then(function(r){return r.response;});},loadFeatures:function(p){if(I.settings){I.settings.isVersioningEnabled=false;return Promise.resolve(I.settings);}var P={};I._addClientInfo(P);var F=a.getUrl(R.SETTINGS,p,P);return a.sendRequest(F).then(function(r){r.response.isVersioningEnabled=false;return r.response;});},write:function(p){p.method="POST";return f(p);},update:function(p){if(p.flexObject.fileType==="variant"){p.isLegacyVariant=true;}p.method="PUT";return f(p);},remove:function(p){var P={namespace:p.flexObject.namespace,layer:p.flexObject.layer};if(p.transport){P.changelist=p.transport;}I._addClientInfo(P);p.fileName=p.flexObject.fileName;var r=p.flexObject.fileType==="variant"?R.VARIANTS:R.CHANGES;var D=a.getUrl(r,p,P);D=decodeURIComponent(D);delete p.fileName;var t=a.getUrl(R.TOKEN,p);var o=W.getRequestOptions(I,t,undefined,"application/json; charset=utf-8","json");return W.sendRequest(D,"DELETE",o);},appVariant:{getManifest:function(p){var A=p.appVarUrl;var r=W.getRequestOptions(I,undefined,undefined,"application/json; charset=utf-8","json");return W.sendRequest(A,"GET",r);},load:function(p){var A=a.getUrl(R.APPVARIANTS,p);var r=W.getRequestOptions(I,undefined,undefined,"application/json; charset=utf-8","json");return W.sendRequest(A,"GET",r);},create:function(p){p.method="POST";p.isAppVariant=true;return f(p);},assignCatalogs:function(p){var P={};P.action=p.action;delete p.action;P.assignFromAppId=p.assignFromAppId;delete p.assignFromAppId;var s=a.getUrl(R.APPVARIANTS,p,P);delete p.reference;var t=a.getUrl(R.TOKEN,p);var r=W.getRequestOptions(I,t,undefined,"application/json; charset=utf-8","json");return W.sendRequest(s,"POST",r);},unassignCatalogs:function(p){var P={};P.action=p.action;delete p.action;var s=a.getUrl(R.APPVARIANTS,p,P);delete p.reference;var t=a.getUrl(R.TOKEN,p);var r=W.getRequestOptions(I,t,undefined,"application/json; charset=utf-8","json");return W.sendRequest(s,"POST",r);},update:function(p){return h(p).then(function(t){if(t){p.transport=t;}delete p.isForSmartBusiness;p.method="PUT";p.isAppVariant=true;return f(p);});},remove:function(p){return h(p).then(function(t){var P={};if(t){P.changelist=t;}delete p.isForSmartBusiness;var D=a.getUrl(R.APPVARIANTS,p,P);delete p.reference;var s=a.getUrl(R.TOKEN,p);var r=W.getRequestOptions(I,s,undefined,"application/json; charset=utf-8","json");return W.sendRequest(D,"DELETE",r);});},list:function(p){var P={};P.layer=p.layer;P["sap.app/id"]=p.reference;delete p.layer;delete p.reference;var A=a.getUrl(R.APPVARIANTS_OVERVIEW,p,P);var r=W.getRequestOptions(I,undefined,undefined,"application/json; charset=utf-8","json");return W.sendRequest(A,"GET",r);}},ui2Personalization:{create:function(p){p.initialConnector=this.initialConnector;var P=U.getLrepUrl();var r=W.getRequestOptions(I,P+R.TOKEN,p.flexObjects||p.flexObject,"application/json; charset=utf-8","json");var u=P+R.UI2PERSONALIZATION;return W.sendRequest(u,"PUT",r);},remove:function(p){p.initialConnector=this.initialConnector;var u=a.getUrl(R.UI2PERSONALIZATION,{url:U.getLrepUrl()},{reference:p.reference,containerkey:p.containerKey,itemname:p.itemName});return W.sendRequest(u,"DELETE");}}});},true);
sap.ui.predefine('sap/ui/fl/write/_internal/connectors/NeoLrepConnector',["sap/base/util/merge","sap/ui/fl/write/_internal/connectors/LrepConnector","sap/ui/fl/initial/_internal/connectors/NeoLrepConnector"],function(m,L,I){"use strict";return m({},L,{initialConnector:I,layers:I.layers});},true);
sap.ui.predefine('sap/ui/fl/write/_internal/connectors/ObjectPathConnector',["sap/base/util/merge","sap/ui/fl/write/connectors/BaseConnector","sap/ui/fl/initial/_internal/StorageUtils","sap/base/util/LoaderExtensions"],function(m,B,S,L){"use strict";var j;return m({},B,{layers:[],setJsonPath:function(i){j=i;},loadFlexData:function(p){var P=j||p.path;if(P){return L.loadResource({dataType:"json",url:P,async:true}).then(function(r){return Object.assign(S.getEmptyFlexDataResponse(),r);});}return Promise.resolve();},loadFeatures:function(p){var P=j||p.path;if(P){return L.loadResource({dataType:"json",url:P,async:true}).then(function(f,r){r.componentClassName=f;return r.settings||{};}.bind(null,p.flexReference));}return Promise.resolve({});}});},true);
sap.ui.predefine('sap/ui/fl/write/_internal/connectors/ObjectStorageConnector',["sap/base/util/merge","sap/ui/fl/write/api/connectors/ObjectStorageConnector"],function(m,P){"use strict";var O=m({},P,{oStorage:undefined});O.storage=O.oStorage;return O;});
sap.ui.predefine('sap/ui/fl/write/_internal/connectors/PersonalizationConnector',["sap/base/util/merge","sap/ui/fl/write/_internal/connectors/BackendConnector","sap/ui/fl/initial/_internal/connectors/PersonalizationConnector"],function(m,B,I){"use strict";var P="/flex/personalization";var A="/v1";var F={isProductiveSystem:true};var a=m({},B,{layers:I.layers,ROUTES:{CHANGES:P+A+"/changes/",TOKEN:P+A+"/actions/getcsrftoken"},loadFeatures:function(){return Promise.resolve(F);}});a.initialConnector=I;return a;},true);
sap.ui.predefine('sap/ui/fl/write/_internal/connectors/SessionStorageConnector',["sap/base/util/merge","sap/ui/fl/write/api/connectors/ObjectStorageConnector"],function(m,O){"use strict";var S=m({},O,{storage:window.sessionStorage});return S;});
sap.ui.predefine('sap/ui/fl/write/_internal/connectors/Utils',["sap/ui/fl/initial/_internal/connectors/Utils"],function(U){"use strict";
function u(p){return U.sendRequest(p.tokenUrl,"HEAD").then(function(r){if(r&&r.xsrfToken){if(p.initialConnector){p.initialConnector.xsrfToken=r.xsrfToken;}p.xsrfToken=r.xsrfToken;return p;}});}
function a(p,s,m){return u(p).then(U.sendRequest.bind(undefined,s,m));}
function b(s,t,k){if(!t[k]){t[k]=s[k];return;}if(Array.isArray(t[k])){t[k]=t[k].concat(s[k]);return;}if(typeof t[k]==='object'){Object.keys(s[k]).forEach(function(i){b(s[k],t[k],i);});}t[k]=s[k];}
return{getRequestOptions:function(i,t,f,c,d){var o={xsrfToken:i.xsrfToken,tokenUrl:t,initialConnector:i};if(f){o.payload=JSON.stringify(f);}if(c){o.contentType=c;}if(d){o.dataType=d;}return o;},sendRequest:function(s,m,p){if(!p.initialConnector||(!p.initialConnector.xsrfToken&&!(m==='GET')&&!(m==='HEAD'))){return a(p,s,m);}return U.sendRequest(s,m,p).then(function(r){return r;}).catch(function(f){if(f.status===403){return a(p,s,m);}throw f;});},mergeResults:function(r){var R={};r.forEach(function(o){Object.keys(o).forEach(function(k){b(o,R,k);});});return R;}};});
sap.ui.predefine('sap/ui/fl/write/_internal/flexState/FlexObjectState',["sap/base/util/restricted/_omit","sap/base/Log","sap/ui/fl/Layer","sap/ui/fl/LayerUtils","sap/ui/fl/Utils","sap/ui/fl/Change","sap/ui/fl/ChangePersistenceFactory","sap/ui/fl/write/_internal/flexState/compVariants/CompVariantState","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/apply/_internal/ChangesController"],function(_,L,a,b,U,C,c,d,M,F,e){"use strict";var f={};
function i(p){p.reference=M.getFlexReferenceForControl(p.selector);return F.initialize({componentId:U.getAppComponentForControl(p.selector).getId(),reference:p.reference,componentData:{},manifest:{}});}
function g(p){var m=F.getCompEntitiesByIdMap(p.reference);return Object.keys(m).map(function(k){return m[k];});}
function h(p){if(!p.reference){var A=e.getAppComponentForSelector(p.selector);p.reference=M.getFlexReferenceForControl(A);}return c.getChangePersistenceForComponent(p.reference);}
function j(p){var o=h(p);return o.getChangesForComponent(_(p,["invalidateCache","selector"]),p.invalidateCache);}
f.getFlexObjects=function(p){return i(p).then(function(){var k=g(p);var l=j(p);return Promise.all([k,l]).then(function(E){return E[0].concat(E[1]);});});};
return f;});
sap.ui.predefine('sap/ui/fl/write/_internal/flexState/compVariants/CompVariantState',["sap/ui/fl/Layer","sap/ui/fl/Change","sap/ui/fl/Utils","sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/write/_internal/Storage"],function(L,C,U,F,S){"use strict";
function g(o){switch(o.fileType){case"change":case"variant":return"changes";case"comp_variant_change":return"compVariantChanges";default:}}
function a(p,o){var i=p.changeToBeAddedOrDeleted.getDefinition();var s=g(i);o[s].push(i);var I=i.fileName;var m=F.getCompEntitiesByIdMap(p.reference);m[I]=i;}
function d(p,o){var i=p.changeToBeAddedOrDeleted.getDefinition();var s=g(i);var l=-1;o[s].some(function(E,I){if(E.fileName===i.fileName){l=I;return true;}});if(l>-1){o[s].splice(l,1);}var m=F.getCompEntitiesByIdMap(p.reference);delete m[i.fileName];}
function c(p,o,s){var m=F.getCompVariantsMap(p.reference)._getOrCreate(p.persistencyKey);if(!m[s]){var i={fileName:U.createDefaultFileName(s),fileType:"change",changeType:s,layer:L.USER,reference:p.reference,selector:{persistencyKey:p.persistencyKey},support:{generator:p.generator||"CompVariantState."+s,sapui5Version:sap.ui.version}};if(p.compositeCommand){i.support.generator.compositeCommand=p.compositeCommand;}var l=new C(i);m[s]=l;F.getCompEntitiesByIdMap(p.reference)[l.getId()]=l;}m[s].setContent(o);return m[s];}
function r(o,l){for(var i=0;i<o.length;i++){if((o[i].fileName||o[i].getFileName())===l.fileName){o.splice(i,1);break;}}}
function b(m,o){if(o.isVariant()){return m.variants;}switch(o.getChangeType()){case"defaultVariant":return m.defaultVariants;case"standardVariant":return m.standardVariants;default:return m.changes;}}
function w(o,s){return S.write({flexObjects:[o.getDefinition()],layer:o.getLayer(),transport:o.getRequest(),isLegacyVariant:o.isVariant()}).then(function(i){if(i&&i.response&&i.response[0]){o.setResponse(i.response[0]);}else{o.setState(C.states.PERSISTED);}return s;}).then(function(s){b(s.changes.comp,o).push(o.getDefinition());return o.getDefinition();});}
function u(o,l){for(var i=0;i<o.length;i++){if(o[i].fileName===l.fileName){o.splice(i,1,l);break;}}}
function e(o,s){return S.update({flexObject:o.getDefinition(),layer:o.getLayer(),transport:o.getRequest()}).then(function(i){if(i&&i.response){o.setResponse(i.response);}else{o.setState(C.states.PERSISTED);}return s;}).then(function(s){var O=b(s.changes.comp,o);u(O,o.getDefinition());return o.getDefinition();});}
function f(o,m,i,s){return S.remove({flexObject:o.getDefinition(),layer:o.getLayer(),transport:o.getRequest()}).then(function(){delete m[o.getId()];if(o.getChangeType()==="standardVariant"){i.standardVariant=undefined;}else if(o.getChangeType()==="defaultVariant"){i.defaultVariant=undefined;}else{r(b(i,o),o.getDefinition());}return s;}).then(function(s){r(b(s.changes.comp,o),o.getDefinition());return o.getDefinition();});}
function n(o){return o&&(o.getPendingAction()==="NEW"||o.getPendingAction()==="UPDATE"||o.getPendingAction()==="DELETE");}
function h(m){return m.variants.concat(m.changes).concat(m.defaultVariant).concat(m.standardVariant);}
function j(o){var i={};if(typeof(o.texts)==="object"){Object.keys(o.texts).forEach(function(l){i[l]={value:o.texts[l],type:"XFLD"};});}return i;}
var k={};
k.setDefault=function(p){var o={defaultVariantName:p.defaultVariantId};return c(p,o,"defaultVariant");};
k.setExecuteOnSelect=function(p){var o={executeOnSelect:p.executeOnSelect};return c(p,o,"standardVariant");};
k.add=function(p){if(!p){return undefined;}var o=p.changeSpecificData;var i={changeType:o.type,service:o.ODataService,content:o.content,reference:p.reference,isVariant:o.isVariant,packageName:o.packageName,isUserDependent:o.isUserDependent,selector:{persistencyKey:p.persistencyKey},texts:j(o)};var l=C.createInitialFileContent(i);var m=new C(l);var q=F.getCompVariantsMap(p.reference);var M=q._getOrCreate(p.persistencyKey);b(M,m).push(m);var I=m.getId();var s=F.getCompEntitiesByIdMap(p.reference);s[I]=m;return I;};
k.updateState=function(p){var o=F.getFlexObjectsFromStorageResponse(p.reference);if(p.changeToBeAddedOrDeleted){switch(p.changeToBeAddedOrDeleted.getPendingAction()){case"NEW":a(p,o);break;case"DELETE":d(p,o);break;default:break;}}};
k.persist=function(p){var R=p.reference;var P=p.persistencyKey;var m=F.getCompVariantsMap(R);var i=m._getOrCreate(P);var l=F.getCompEntitiesByIdMap(R);var s=F.getStorageResponse(R);var o=h(i).filter(n).map(function(q){switch(q.getPendingAction()){case"NEW":return w(q,s);case"UPDATE":return e(q,s);case"DELETE":return f(q,l,i,s);default:break;}});return Promise.all(o);};
return k;});
sap.ui.predefine('sap/ui/fl/write/api/AppVariantWriteAPI',["sap/ui/fl/apply/_internal/ChangesController","sap/ui/fl/write/_internal/SaveAs","sap/ui/fl/write/_internal/connectors/LrepConnector"],function(C,S,L){"use strict";var _=function(f,p){if(!p.layer){return Promise.reject("Layer must be provided");}var F=C.getDescriptorFlexControllerInstance(p.selector);p.reference=F.getComponentName();p.url="/sap/bc/lrep";return L.appVariant[f](p);};var A={saveAs:function(p){if(!p.layer){return Promise.reject("Layer must be provided");}if(!p.id){return Promise.reject("App variant ID must be provided");}var f=C.getDescriptorFlexControllerInstance(p.selector);p.reference=f.getComponentName();return S.saveAs(p);},deleteAppVariant:function(p){if(!p.layer){return Promise.reject("Layer must be provided");}var f=C.getDescriptorFlexControllerInstance(p.selector);p.id=f.getComponentName();return S.deleteAppVariant(p);},listAllAppVariants:function(p){if(!p.layer){return Promise.reject("Layer must be provided");}return _("list",p);},getManifest:function(p){if(!p.layer){return Promise.reject("Layer must be provided");}if(!p.appVarUrl){return Promise.reject("appVarUrl must be provided");}return L.appVariant.getManifest(p);},assignCatalogs:function(p){if(!p.layer){return Promise.reject("Layer must be provided");}if(!p.assignFromAppId){return Promise.reject("assignFromAppId must be provided");}if(!p.action){return Promise.reject("action must be provided");}return _("assignCatalogs",p);},unassignCatalogs:function(p){if(!p.layer){return Promise.reject("Layer must be provided");}if(!p.action){return Promise.reject("action must be provided");}return _("unassignCatalogs",p);}};return A;},true);
sap.ui.predefine('sap/ui/fl/write/api/ChangesWriteAPI',["sap/ui/fl/apply/_internal/changes/Applier","sap/ui/fl/apply/_internal/changes/Reverter","sap/ui/fl/apply/_internal/ChangesController","sap/ui/fl/apply/_internal/appVariant/DescriptorChangeTypes","sap/ui/fl/write/_internal/appVariant/AppVariantInlineChangeFactory","sap/ui/fl/descriptorRelated/api/DescriptorChangeFactory","sap/base/Log","sap/ui/core/Component","sap/ui/core/Element","sap/ui/core/util/reflection/JsControlTreeModifier","sap/base/util/includes","sap/base/util/restricted/_omit"],function(A,R,C,D,a,b,L,c,E,J,i,_){"use strict";var d={create:function(p){var f;if(i(D.getChangeTypes(),p.changeSpecificData.changeType)){f=C.getDescriptorFlexControllerInstance(p.selector);var r=f.getComponentName();var l;if(p.changeSpecificData.layer){l=p.changeSpecificData.layer;delete p.changeSpecificData.layer;}var I={changeType:p.changeSpecificData.changeType,content:p.changeSpecificData.content};if(p.changeSpecificData.texts){I.texts=p.changeSpecificData.texts;}return a.createDescriptorInlineChange(I).then(function(o){return new b().createNew(r,o,l,p.selector);}).catch(function(e){L.error("the change could not be created.",e.message);throw e;});}if(p.selector.name&&p.selector.view){f=C.getFlexControllerInstance(p.selector.view);}else{f=C.getFlexControllerInstance(p.selector);}if(p.selector instanceof c){return f.createBaseChange(p.changeSpecificData,p.selector);}if(p.selector.name&&p.selector.view){return f.createChangeWithExtensionPointSelector(p.changeSpecificData,p.selector);}return f.createChangeWithControlSelector(p.changeSpecificData,p.selector);},apply:function(p){if(!p.element instanceof E){return Promise.reject("Please provide an Element");}var f=C.getFlexControllerInstance(p.element);p.appComponent=C.getAppComponentForSelector(p.element);if(!p.modifier){p.modifier=J;}return A.applyChangeOnControl(p.change,p.element,_(p,["element","change"])).then(function(r){var e=f.checkForOpenDependenciesForControl(p.change.getSelector(),p.appComponent);if(e){return d.revert({change:p.change,element:p.element}).then(function(){throw Error("The following Change cannot be applied because of a dependency: "+p.change.getId());});}return r;});},revert:function(p){var o;if(p.element instanceof E){o=C.getAppComponentForSelector(p.element);}var r={modifier:J,appComponent:o};return R.revertChangeOnControl(p.change,p.element,r);}};return d;},true);
sap.ui.predefine('sap/ui/fl/write/api/ControlPersonalizationWriteAPI',["sap/ui/fl/ControlPersonalizationAPI","sap/ui/fl/FlexControllerFactory","sap/ui/fl/Layer","sap/ui/fl/Utils"],function(O,F,L,U){"use strict";var C={add:function(p){p.changes.forEach(function(P){P.selectorControl=P.selectorElement;});p.controlChanges=p.changes;return O.addPersonalizationChanges(p);},reset:function(p){p.selectors=p.selectors||[];return O.resetChanges(p.selectors,p.changeTypes);},restore:function(p){if(!p||!p.selector){return Promise.reject("No selector was provided");}var a=U.getAppComponentForControl(p.selector);if(!a){return Promise.reject("App Component could not be determined");}var f=F.createForControl(a);return f.removeDirtyChanges(L.USER,a,p.selector,p.generator,p.changeTypes);},save:function(p){var a=p.selector.appComponent||U.getAppComponentForControl(p.selector);return O.saveChanges(p.changes,a);},buildSelectorFromElementIdAndType:function(p){var a=U.getAppComponentForControl(p.element);if(!a||!p.elementId||!p.elementType){throw new Error("Not enough information given to build selector.");}return{elementId:p.elementId,elementType:p.elementType,appComponent:a,id:p.elementId,controlType:p.elementType};}};return C;},true);
sap.ui.predefine('sap/ui/fl/write/api/ExtensionPointRegistryAPI',["sap/ui/fl/write/_internal/extensionPoint/Registry"],function(E){"use strict";var a={getExtensionPointInfo:function(p){return E.getExtensionPointInfo(p.name,p.view);},getExtensionPointInfoByParentId:function(p){return E.getExtensionPointInfoByParentId(p.parentId);}};return a;},true);
sap.ui.predefine('sap/ui/fl/write/api/FeaturesAPI',["sap/ui/fl/registry/Settings","sap/ui/fl/Utils","sap/ui/fl/Layer"],function(S,F,L){"use strict";var a={isPublishAvailable:function(){return S.getInstance().then(function(s){return!s.isProductiveSystem();});},isSaveAsAvailable:function(l){return S.getInstance().then(function(s){if(s.isAppVariantSaveAsEnabled()&&l===L.CUSTOMER&&!!sap.ushell_abap){return true;}return false;});},isKeyUser:function(){return S.getInstance().then(function(s){return s.isKeyUser();});},isVersioningEnabled:function(l){return S.getInstance().then(function(s){return s.isVersioningEnabled(l);});}};return a;});
sap.ui.predefine('sap/ui/fl/write/api/PersistenceWriteAPI',["sap/base/util/includes","sap/base/util/restricted/_omit","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/apply/_internal/changes/FlexCustomData","sap/ui/fl/apply/_internal/ChangesController","sap/ui/fl/apply/_internal/appVariant/DescriptorChangeTypes","sap/ui/fl/write/_internal/condenser/Condenser","sap/ui/fl/write/api/FeaturesAPI","sap/base/Log","sap/ui/fl/Layer","sap/ui/fl/LayerUtils","sap/ui/fl/write/_internal/flexState/FlexObjectState"],function(i,_,J,F,C,D,a,b,L,c,d,e){"use strict";
function f(o){return(o._getMap&&i(D.getChangeTypes(),o._getMap().changeType))||(o.getChangeType&&i(D.getChangeTypes(),o.getChangeType()));}
function h(p){p.includeCtrlVariants=true;p.invalidateCache=false;return P._getUIChanges(p).then(function(j){return j.length>0;});}
function g(p){p.includeCtrlVariants=true;p.invalidateCache=false;return P._getUIChanges(p).then(function(j){return j.some(function(o){var s=o.getPackage();return s==="$TMP"||s==="";});});}
var P={hasHigherLayerChanges:function(p){p.upToLayer=p.upToLayer||d.getCurrentLayer(false);return e.getFlexObjects(p).then(function(j){return j.filter(function(o){return d.isOverLayer(o.getLayer(),p.upToLayer);});}).then(function(j){return j.length>0;});},save:function(p){var o=C.getFlexControllerInstance(p.selector);var j=C.getDescriptorFlexControllerInstance(p.selector);p.invalidateCache=true;var A=C.getAppComponentForSelector(p.selector);p.componentId=A.getId();return o.saveAll(A,p.skipUpdateCache,p.draft,A).then(j.saveAll.bind(j,A,p.skipUpdateCache,p.draft)).then(P._getUIChanges.bind(null,_(p,"skipUpdateCache")));},getResetAndPublishInfo:function(p){return Promise.all([h(p),g(p),b.isPublishAvailable()]).then(function(r){var o={isResetEnabled:r[0],isPublishEnabled:r[1]};var j=r[2];var I=!(p.layer===c.USER)&&(!o.isResetEnabled||(j&&!o.isPublishEnabled));if(I){return C.getFlexControllerInstance(p.selector).getResetAndPublishInfo(p).then(function(R){o.isResetEnabled=o.isResetEnabled||R.isResetEnabled;o.isPublishEnabled=o.isPublishEnabled||R.isPublishEnabled;return o;}).catch(function(E){L.error("Sending request to flex/info route failed: "+E.message);return o;});}return o;});},reset:function(p){var A=C.getAppComponentForSelector(p.selector);var o=C.getFlexControllerInstance(A);var j=[p.layer,p.generator,A,p.selectorIds,p.changeTypes];return o.resetChanges.apply(o,j);},publish:function(p){p.styleClass=p.styleClass||"";var A=C.getAppComponentForSelector(p.selector);return C.getFlexControllerInstance(A)._oChangePersistence.transportAllUIChanges({},p.styleClass,p.layer,p.appVariantDescriptors);},add:function(p){if(f(p.change)){return p.change.store();}var A=C.getAppComponentForSelector(p.selector);return C.getFlexControllerInstance(A).addPreparedChange(p.change,A);},remove:function(p){if(!p.selector){throw new Error("An invalid selector was passed so change could not be removed with id: "+p.change.getId());}var A=C.getAppComponentForSelector(p.selector);if(!A){throw new Error("Invalid application component for selector, change could not be removed with id: "+p.change.getId());}if(f(p.change)){var o=C.getDescriptorFlexControllerInstance(A);o.deleteChange(p.change,A);return;}var E=J.bySelector(p.change.getSelector(),A);var j=C.getFlexControllerInstance(A);if(E){F.destroyAppliedCustomData(E,p.change,J);}j.deleteChange(p.change,A);},_condense:function(p){return Promise.resolve().then(function(){if(!p.selector){throw Error("An invalid selector was passed");}var A=C.getAppComponentForSelector(p.selector);if(!A){throw Error("Invalid application component for selector");}if(!p.changes||p.changes&&!Array.isArray(p.changes)){throw Error("Invalid array of changes");}return a.condense(A,p.changes);});},_getUIChanges:function(p){if(p.layer){p.currentLayer=p.layer;}return e.getFlexObjects(p);}};return P;});
sap.ui.predefine('sap/ui/fl/write/api/ReloadInfoAPI',["sap/ui/fl/LayerUtils","sap/ui/fl/Layer","sap/ui/fl/Utils","sap/ui/fl/write/api/VersionsAPI","sap/ui/fl/write/api/FeaturesAPI","sap/ui/fl/write/api/PersistenceWriteAPI","sap/base/util/UriParameters"],function(L,a,U,V,F,P){"use strict";
function i(r){return F.isVersioningEnabled(r.layer).then(function(v){return v&&V.isDraftAvailable({selector:r.selector,layer:r.layer});});}
function b(r){var u=r.layer===a.USER;if(u){return Promise.resolve(false);}return P.hasHigherLayerChanges({selector:r.selector,ignoreMaxLayerParameter:r.ignoreMaxLayerParameter,upToLayer:r.layer});}
var R={getReloadReasonsForStart:function(r){var u=R.hasMaxLayerParameterWithValue({value:r.layer});var c=!!U.getParameter(sap.ui.fl.Versions.UrlParameter);return Promise.all([(!u)?b(r):false,(!c)?i(r):false]).then(function(d){r.hasHigherLayerChanges=d[0];r.hasDraftChanges=d[1];return r;});},hasVersionParameterWithValue:function(p){return U.hasParameterAndValue(sap.ui.fl.Versions.UrlParameter,p.value);},hasMaxLayerParameterWithValue:function(p){var s=L.FL_MAX_LAYER_PARAM;return U.hasParameterAndValue(s,p.value);},handleUrlParametersForStandalone:function(r){if(r.hasHigherLayerChanges){r.parameters=U.handleUrlParameters(r.parameters,L.FL_MAX_LAYER_PARAM,r.layer);}var v=new RegExp("\&*"+sap.ui.fl.Versions.UrlParameter+"=-?\\d*\&?","g");r.parameters=r.parameters.replace(v,"");if(r.hasDraftChanges){r.parameters=U.handleUrlParameters(r.parameters,sap.ui.fl.Versions.UrlParameter,sap.ui.fl.Versions.Draft);}if(r.versionSwitch){r.parameters=U.handleUrlParameters(r.parameters,sap.ui.fl.Versions.UrlParameter,r.version);}if(r.parameters==="?"){r.parameters="";}return r.parameters;},handleParametersOnStart:function(r){var p=U.getParsedURLHash();p.params=p.params||{};if(r.hasHigherLayerChanges){p.params[L.FL_MAX_LAYER_PARAM]=[r.layer];}if(r.hasDraftChanges){p.params[sap.ui.fl.Versions.UrlParameter]=[sap.ui.fl.Versions.Draft];}return p;},initialDraftGotActivated:function(r){if(r.versioningEnabled){var u=this.hasVersionParameterWithValue({value:sap.ui.fl.Versions.Draft.toString()});return!V.isDraftAvailable(r)&&u;}return false;},getReloadMethod:function(r){var o={NOT_NEEDED:"NO_RELOAD",RELOAD_PAGE:"HARD_RELOAD",VIA_HASH:"CROSS_APP_NAVIGATION"};r.reloadMethod=o.NOT_NEEDED;r.hasDraft=r.hasDirtyDraftChanges||R.hasVersionParameterWithValue({value:sap.ui.fl.Versions.Draft.toString()});if(r.activeVersion>sap.ui.fl.Versions.Original){r.activeVersionNotSelected=r.activeVersion&&!R.hasVersionParameterWithValue({value:r.activeVersion.toString()});}r.hasHigherLayerChanges=R.hasMaxLayerParameterWithValue({value:r.layer});r.initialDraftGotActivated=R.initialDraftGotActivated(r);if(r.initialDraftGotActivated){r.hasDraft=false;}if(r.changesNeedReload||r.hasDraft||r.hasHigherLayerChanges||r.initialDraftGotActivated||r.activeVersionNotSelected){r.reloadMethod=o.RELOAD_PAGE;if(!r.changesNeedReload&&U.getUshellContainer()){r.reloadMethod=o.VIA_HASH;}}return r;}};return R;});
sap.ui.predefine('sap/ui/fl/write/api/SmartBusinessWriteAPI',["sap/ui/fl/write/_internal/appVariant/AppVariantFactory","sap/ui/fl/write/api/PersistenceWriteAPI","sap/ui/fl/write/api/ChangesWriteAPI","sap/ui/fl/apply/_internal/ChangesController","sap/ui/fl/write/_internal/SaveAs","sap/ui/fl/write/_internal/connectors/LrepConnector","sap/ui/fl/registry/Settings"],function(A,P,C,a,S,L,b){"use strict";
function _(s,p){return b.getInstance().then(function(o){if(o.isAtoEnabled()){p.skipIam=true;p.transport="ATO_NOTIFICATION";}return S[s](p);});}
function c(p){if(!p.appId){return Promise.reject("App Variant ID must be provided");}p.selector={appId:p.appId};var D=a.getDescriptorFlexControllerInstance(p.selector);p.id=D.getComponentName();p.isForSmartBusiness=true;}
var d={create:function(p){if(!p.layer){return Promise.reject("Layer must be provided");}if(!p.selector||!p.selector.appId){return Promise.reject("selector.appId must be provided");}if(!p.id){return Promise.reject("App variant ID must be provided");}var f=a.getDescriptorFlexControllerInstance(p.selector);p.reference=f.getComponentName();p.isForSmartBusiness=true;return _("saveAs",p);},update:function(p){c(p);return _("updateAppVariant",p);},remove:function(p){c(p);return _("deleteAppVariant",p);},getDesignTimeVariant:function(p){if(!p.id){return Promise.reject("App Variant ID must be provided");}return A.load(p);},getRunTimeVariant:function(p){if(!p.appId){return Promise.reject("Reference App ID must be provided");}if(!p.id){return Promise.reject("App Variant ID must be provided");}var s="/sap/bc/lrep/content/apps/"+p.appId+"/appVariants/"+p.id+"/manifest.appdescr_variant";return L.appVariant.getManifest({appVarUrl:s});},createDescriptorInlineChanges:function(p){if(!p.appId){return Promise.reject("appId must be provided");}if(!p.changeSpecificData){return Promise.reject("changeSpecificData must be provided");}p.selector={appId:p.appId};return C.create(p);},add:function(p){if(!p.appId){return Promise.reject("appId must be provided");}if(!p.change){return Promise.reject("Change instance must be provided");}p.selector={appId:p.appId};return P.add(p);}};return d;});
sap.ui.predefine('sap/ui/fl/write/api/SmartVariantManagementWriteAPI',["sap/ui/fl/write/_internal/flexState/compVariants/CompVariantState","sap/ui/fl/write/_internal/transport/TransportSelection","sap/ui/fl/registry/Settings","sap/ui/fl/apply/_internal/flexState/ManifestUtils"],function(C,T,S,M){"use strict";
function g(c){return c&&c.getPersistencyKey&&c.getPersistencyKey();}
function s(p,f){p.persistencyKey=g(p.control);if(!p.reference){p.reference=M.getFlexReferenceForControl(p.control);}return f(p);}
var a={add:function(p){return s(p,C.add);},save:function(p){return s(p,C.persist);},setDefaultVariantId:function(p){return s(p,C.setDefault);},setExecuteOnSelect:function(p){return s(p,C.setExecuteOnSelect);},isVariantSharingEnabled:function(){return S.getInstance().then(function(i){return i.isVariantSharingEnabled();});},_getTransportSelection:function(){return new T();}};return a;},true);
sap.ui.predefine('sap/ui/fl/write/api/UI2PersonalizationWriteAPI',["sap/ui/fl/apply/_internal/flexState/UI2Personalization/UI2PersonalizationState","sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/apply/_internal/ChangesController","sap/base/util/restricted/_omit"],function(U,F,C,_){"use strict";var a={create:function(p){var f=C.getFlexControllerInstance(p.selector);p.reference=f.getComponentName();if(!p.reference||!p.containerKey||!p.itemName||!p.content||!p.category||!p.containerCategory){return Promise.reject(new Error("not all mandatory properties were provided for the storage of the personalization"));}return F.initialize({componentId:p.selector.getId()}).then(function(){return U.setPersonalization(_(p,["selector"]));});},deletePersonalization:function(p){var f=C.getFlexControllerInstance(p.selector);p.reference=f.getComponentName();if(!p.reference||!p.containerKey||!p.itemName){return Promise.reject(new Error("not all mandatory properties were provided for the deletion of the personalization"));}return F.initialize({componentId:p.selector.getId()}).then(function(){return U.deletePersonalization(p.reference,p.containerKey,p.itemName);});}};return a;},true);
sap.ui.predefine('sap/ui/fl/write/api/VersionsAPI',["sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/write/_internal/Versions","sap/ui/fl/Utils","sap/ui/fl/apply/_internal/flexState/ManifestUtils"],function(F,V,U,M){"use strict";
function g(A){var r;if(A){var m=A.getManifest();r=M.getFlexReference({manifest:m,componentData:A.getComponentData()});}if(!r){throw Error("The application ID could not be determined");}return r;}
function a(p){if(!p.selector){throw Error("No selector was provided");}if(!p.layer){throw Error("No layer was provided");}var A=U.getAppComponentForControl(p.selector);return V.getVersionsModel({reference:U.normalizeReference(g(A)),layer:p.layer});}
var b={};
b.initialize=function(p){if(!p.selector){return Promise.reject("No selector was provided");}if(!p.layer){return Promise.reject("No layer was provided");}var A=U.getAppComponentForControl(p.selector);return V.initialize({reference:U.normalizeReference(g(A)),layer:p.layer});};
b.isDraftAvailable=function(p){var m=a(p);var v=m.getProperty("/versions");var d=v.find(function(o){return o.version===sap.ui.fl.Versions.Draft;});return!!d;};
b.isOldVersionDisplayed=function(p){var m=a(p);var d=m.getProperty("/displayedVersion");var c=m.getProperty("/activeVersion");return d!==sap.ui.fl.Versions.Draft&&d!==c;};
b.loadDraftForApplication=function(p){p.version=sap.ui.fl.Versions.Draft;return b.loadVersionForApplication(p);};
b.loadVersionForApplication=function(p){if(!p.selector){return Promise.reject("No selector was provided");}if(!p.layer){return Promise.reject("No layer was provided");}if(p.version===undefined){var m=a(p);if(m){p.version=m.getProperty("/activeVersion");}}var A=U.getAppComponentForControl(p.selector);return Promise.resolve().then(g.bind(undefined,A)).then(function(r){return F.clearAndInitialize({componentId:A.getId(),reference:r,version:p.version});});};
b.activate=function(p){if(!p.selector){return Promise.reject("No selector was provided");}if(!p.layer){return Promise.reject("No layer was provided");}if(!p.title){return Promise.reject("No version title was provided");}var A=U.getAppComponentForControl(p.selector);return Promise.resolve().then(g.bind(undefined,A)).then(function(r){return V.activate({nonNormalizedReference:r,reference:U.normalizeReference(r),layer:p.layer,title:p.title,appComponent:A});});};
b.discardDraft=function(p){if(!p.selector){return Promise.reject("No selector was provided");}if(!p.layer){return Promise.reject("No layer was provided");}var A=U.getAppComponentForControl(p.selector);return Promise.resolve().then(g.bind(undefined,A)).then(function(r){return V.discardDraft({nonNormalizedReference:r,reference:U.normalizeReference(r),layer:p.layer}).then(function(d){if(d.backendChangesDiscarded){F.clearAndInitialize({componentId:A.getId(),reference:r});}return d;});});};
return b;});
sap.ui.predefine('sap/ui/fl/write/api/connectors/FileListBaseConnector',["sap/ui/fl/initial/_internal/StorageUtils","sap/base/util/LoaderExtensions"],function(S,L){"use strict";return{getFileList:function(){return Promise.reject("not implemented");},layers:[],loadFlexData:function(p){return this.getFileList(p.reference).then(function(f){return Promise.all(f.map(function(u){return L.loadResource({dataType:"json",url:u,async:true});})).then(function(F){var g=S.getGroupedFlexObjects(F);return S.filterAndSortResponses(g);});});}};});
sap.ui.predefine('sap/ui/fl/write/api/connectors/ObjectStorageConnector',["sap/base/util/merge","sap/ui/fl/write/connectors/BaseConnector","sap/ui/fl/initial/_internal/StorageUtils","sap/ui/fl/apply/_internal/connectors/ObjectStorageUtils"],function(m,B,S,O){"use strict";
function l(p){var f=[];return O.forEachObjectInStorage(p,function(F){f.push(F.changeDefinition);}).then(function(){return f;});}
function s(p,c){var d=true;if(p.selectorIds){if(c.selector){d=p.selectorIds.indexOf(c.selector.id)>-1;}else{d=false;}}if(d&&p.changeTypes){d=p.changeTypes.indexOf(c.changeType)>-1;}return d;}
function a(f,c){if(!f.creation){var n=Date.now()+c;f.creation=new Date(n).toISOString();}return f;}
var b=m({},B,{storage:undefined,layers:["ALL"],loadFlexData:function(p){return l({storage:this.storage,reference:p.reference}).then(function(f){var g=S.getGroupedFlexObjects(f);return S.filterAndSortResponses(g);});},write:function(p){var P=p.flexObjects.map(function(f,i){var k=O.createFlexObjectKey(f);f=a(f,++i);var F=this.storage._itemsStoredAsObjects?f:JSON.stringify(f);return this.storage.setItem(k,F);}.bind(this));return Promise.all(P).then(function(){});},update:function(p){var f=p.flexObject;var k=O.createFlexObjectKey(p.flexObject);var F=this.storage._itemsStoredAsObjects?f:JSON.stringify(f);var v=this.storage.setItem(k,F);return Promise.resolve(v);},reset:function(p){return O.forEachObjectInStorage({storage:this.storage,reference:p.reference,layer:p.layer},function(f){if(s(p,f.changeDefinition)){return Promise.resolve(this.storage.removeItem(f.key)).then(function(){return{fileName:f.changeDefinition&&f.changeDefinition.fileName};});}}.bind(this)).then(function(r){return{response:r.filter(function(c){return!!c;})};});},remove:function(p){var k=O.createFlexObjectKey(p.flexObject);this.storage.removeItem(k);var r=this.storage.removeItem(k);return Promise.resolve(r);},loadFeatures:function(){return Promise.resolve({isKeyUser:true,isVariantSharingEnabled:true});},getFlexInfo:function(p){p.storage=this.storage;return O.getAllFlexObjects(p).then(function(f){return{isResetEnabled:f.length>0};});}});return b;});
sap.ui.predefine('sap/ui/fl/write/connectors/BaseConnector',[],function(){"use strict";var B={layers:[],write:function(){return Promise.reject("write is not implemented");},update:function(){return Promise.reject("write is not implemented");},remove:function(){return Promise.reject("remove is not implemented");},reset:function(){return Promise.reject("reset is not implemented");},publish:function(){return Promise.reject("publish is not implemented");},getFlexInfo:function(){return Promise.resolve({});},loadFeatures:function(){return Promise.reject("loadFeatures is not implemented");},versions:{load:function(){return Promise.reject("versions.load is not implemented");},activate:function(){return Promise.reject("versions.activate is not implemented");},discardDraft:function(){return Promise.reject("versions.discardDraft is not implemented");}}};return B;},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/fl/Cache',["sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/Utils","sap/base/Log"],function(F,U,L){"use strict";var C=function(){};
function _(c){return F.getFlexObjectsFromStorageResponse(c).changes;}
function a(c,s){if(!s){return c;}return c===C.NOTAG?c.replace(/>$/,''.concat('-',s,'>')):c.concat('-',s);}
function b(c){return c.replace(/(^W\/|")/g,'');}
C.NOTAG="<NoTag>";
C.clearEntries=function(){F.clearState();};
C.getChangesFillingCache=function(c,p,i){var P=Promise.resolve();if(i){P=F.clearAndInitialize(p);}return P.then(function(){return F.getStorageResponse(c.name);}).catch(function(){return{};});};
C.getCacheKey=function(c,A){if(!c||!c.name||!A){L.warning("Not all parameters were passed to determine a flexibility cache key.");return Promise.resolve(C.NOTAG);}return this.getChangesFillingCache(c).then(function(w){if(w&&w.cacheKey){return b(w.cacheKey);}return C.NOTAG;}).then(function(s){var v=A.getModel(U.VARIANT_MODEL_NAME);var d=v?v.getCurrentControlVariantIds():[];return a(s,d.join("-"));});};
C.addChange=function(c,o){var d=_(c.name);if(!d){return;}d.push(o);};
C.updateChange=function(c,o){var d=_(c.name);if(!d){return;}for(var i=0;i<d.length;i++){if(d[i].fileName===o.fileName){d.splice(i,1,o);break;}}};
C.deleteChange=function(c,o){var d=_(c.name);if(!d){return;}for(var i=0;i<d.length;i++){if(d[i].fileName===o.fileName){d.splice(i,1);break;}}};
C.removeChanges=function(c,d){var e=F.getFlexObjectsFromStorageResponse(c.name);e.changes=e.changes.filter(function(o){return d.indexOf(o.fileName)===-1;});var v=F.getVariantsState(c.name);Object.keys(v).forEach(function(i){v[i].variants.forEach(function(V){V.controlChanges=V.controlChanges.filter(function(o){return d.indexOf(o.getFileName())===-1;});});});};
return C;},true);
sap.ui.predefine('sap/ui/fl/Change',["sap/ui/thirdparty/jquery","sap/ui/base/ManagedObject","sap/ui/fl/Layer","sap/ui/fl/Utils","sap/ui/fl/LayerUtils","sap/ui/fl/registry/Settings","sap/base/Log","sap/ui/fl/apply/_internal/appVariant/DescriptorChangeTypes","sap/base/util/includes"],function(q,M,L,U,a,S,b,D,i){"use strict";
var C=M.extend("sap.ui.fl.Change",{
constructor:function(f){M.apply(this);if(!q.isPlainObject(f)){b.error("Constructor : sap.ui.fl.Change : oFile is not defined");}this._oDefinition=f;this._sRequest='';this._bUserDependent=(f.layer===L.USER);this._vRevertData=null;this._aUndoOperations=null;this._oExtensionPointInfo=null;this.setState(C.states.NEW);this.setInitialApplyState();this._oChangeProcessingPromises={};},
metadata:{properties:{state:{type:"string"},applyState:{type:"int"}}}
});
C.states={NEW:"NEW",PERSISTED:"NONE",DELETED:"DELETE",DIRTY:"UPDATE"};C.applyState={INITIAL:0,APPLYING:1,APPLY_FINISHED:2,REVERTING:3,REVERT_FINISHED:4};C.operations={APPLY:0,REVERT:1};
C.prototype.setState=function(s){if(this._isValidState(s)){this.setProperty("state",s);}return this;};
C.prototype.setQueuedForRevert=function(){this._aQueuedProcesses.unshift(C.operations.REVERT);};
C.prototype.isQueuedForRevert=function(){return this._aQueuedProcesses.indexOf(C.operations.REVERT)>-1;};
C.prototype.setQueuedForApply=function(){this._aQueuedProcesses.unshift(C.operations.APPLY);};
C.prototype.isQueuedForApply=function(){return this._aQueuedProcesses.indexOf(C.operations.APPLY)>-1;};
C.prototype.setInitialApplyState=function(){this._aQueuedProcesses=[];delete this._ignoreOnce;this.setApplyState(C.applyState.INITIAL);};
C.prototype.isInInitialState=function(){return(this._aQueuedProcesses.length===0)&&(this.getApplyState()===C.applyState.INITIAL);};
C.prototype.isValidForDependencyMap=function(){return this._oDefinition.selector&&this._oDefinition.selector.id;};
C.prototype.startApplying=function(){this.setApplyState(C.applyState.APPLYING);};
C.prototype.markFinished=function(r){this._aQueuedProcesses.pop();this._resolveChangeProcessingPromiseWithError(C.operations.APPLY,r);this.setApplyState(C.applyState.APPLY_FINISHED);};
C.prototype.startReverting=function(){this.setApplyState(C.applyState.REVERTING);};
C.prototype.markRevertFinished=function(r){this._aQueuedProcesses.pop();this._resolveChangeProcessingPromiseWithError(C.operations.REVERT,r);this.setApplyState(C.applyState.REVERT_FINISHED);};
C.prototype.hasApplyProcessStarted=function(){return this.getApplyState()===C.applyState.APPLYING;};
C.prototype.isApplyProcessFinished=function(){return this.getApplyState()===C.applyState.APPLY_FINISHED;};
C.prototype.hasRevertProcessStarted=function(){return this.getApplyState()===C.applyState.REVERTING;};
C.prototype.isRevertProcessFinished=function(){return this.getApplyState()===C.applyState.REVERT_FINISHED;};
C.prototype.isCurrentProcessFinished=function(){return this._aQueuedProcesses.length===0;};
C.prototype.addChangeProcessingPromise=function(k){if(!this._oChangeProcessingPromises[k]){this._oChangeProcessingPromises[k]={};this._oChangeProcessingPromises[k].promise=new Promise(function(r){this._oChangeProcessingPromises[k].resolveFunction={resolve:r};}.bind(this));}return this._oChangeProcessingPromises[k].promise;};
C.prototype.addChangeProcessingPromises=function(){var r=[];this._aQueuedProcesses.forEach(function(p){r.push(this.addChangeProcessingPromise(p));},this);return r;};
C.prototype.addPromiseForApplyProcessing=function(){return this.addChangeProcessingPromise(C.operations.APPLY);};
C.prototype._resolveChangeProcessingPromiseWithError=function(k,r){if(this._oChangeProcessingPromises[k]){this._oChangeProcessingPromises[k].resolveFunction.resolve(r);delete this._oChangeProcessingPromises[k];}};
C.prototype._isValidState=function(s){var c=false;Object.keys(C.states).some(function(k){if(C.states[k]===s){c=true;}return c;});if(!c){return false;}if((this.getState()===C.states.NEW)&&(s===C.states.DIRTY)){return false;}return true;};
C.prototype.isValid=function(){var I=true;if(typeof(this._oDefinition)!=="object"){I=false;}if(!this._oDefinition.fileType){I=false;}if(!this._oDefinition.fileName){I=false;}if(!this._oDefinition.changeType){I=false;}if(!this._oDefinition.layer){I=false;}if(!this._oDefinition.originalLanguage){I=false;}return I;};
C.prototype.isVariant=function(){return this._oDefinition.fileType==="variant";};
C.prototype.getChangeType=function(){if(this._oDefinition){return this._oDefinition.changeType;}};
C.prototype.getFileName=function(){if(this._oDefinition){return this._oDefinition.fileName;}};
C.prototype.getFileType=function(){if(this._oDefinition){return this._oDefinition.fileType;}};
C.prototype.getOriginalLanguage=function(){if(this._oDefinition&&this._oDefinition.originalLanguage){return this._oDefinition.originalLanguage;}return"";};
C.prototype.getPackage=function(){return this._oDefinition.packageName;};
C.prototype.getNamespace=function(){return this._oDefinition.namespace;};
C.prototype.setNamespace=function(n){this._oDefinition.namespace=n;};
C.prototype.getModuleName=function(){return this._oDefinition.moduleName;};
C.prototype.setModuleName=function(m){this._oDefinition.moduleName=m;};
C.prototype.getProjectId=function(){return this._oDefinition.projectId;};
C.prototype.setProjectId=function(p){this._oDefinition.projectId=p;};
C.prototype.getId=function(){return this._oDefinition.fileName;};
C.prototype.getContent=function(){return this._oDefinition.content;};
C.prototype.setContent=function(c){this._oDefinition.content=c;this.setState(C.states.DIRTY);};
C.prototype.getVariantReference=function(){return this._oDefinition.variantReference||"";};
C.prototype.setVariantReference=function(v){this._oDefinition.variantReference=v;this.setState(C.states.DIRTY);};
C.prototype.getSelector=function(){return this._oDefinition.selector;};
C.prototype.setSelector=function(s){this._oDefinition.selector=s;};
C.prototype.getSourceSystem=function(){return this._oDefinition.sourceSystem;};
C.prototype.getSourceClient=function(){return this._oDefinition.sourceClient;};
C.prototype.getOwnerId=function(){return this._oDefinition.support?this._oDefinition.support.user:"";};
C.prototype.getText=function(t){if(typeof(t)!=="string"){b.error("sap.ui.fl.Change.getTexts : sTextId is not defined");}if(this._oDefinition.texts){if(this._oDefinition.texts[t]){return this._oDefinition.texts[t].value;}}return"";};
C.prototype.getTexts=function(){return this._oDefinition.texts;};
C.prototype.setText=function(t,n){if(typeof(t)!=="string"){b.error("sap.ui.fl.Change.setTexts : sTextId is not defined");return;}if(this._oDefinition.texts){if(this._oDefinition.texts[t]){this._oDefinition.texts[t].value=n;this.setState(C.states.DIRTY);}}};
C.prototype.isReadOnly=function(){return this._isReadOnlyDueToLayer()||this._isReadOnlyWhenNotKeyUser()||this.isChangeFromOtherSystem();};
C.prototype._isReadOnlyWhenNotKeyUser=function(){if(this.isUserDependent()){return false;}var r=this.getDefinition().reference;if(!r){return true;}var s=S.getInstanceOrUndef();if(!s){return true;}return!s.isKeyUser();};
C.prototype.isLabelReadOnly=function(){if(this._isReadOnlyDueToLayer()){return true;}return this._isReadOnlyDueToOriginalLanguage();};
C.prototype._isReadOnlyDueToLayer=function(){var c;c=a.getCurrentLayer(this._bUserDependent);return(this._oDefinition.layer!==c);};
C.prototype.isChangeFromOtherSystem=function(){var s=this.getSourceSystem();var c=this.getSourceClient();if(!s||!c){return false;}var o=S.getInstanceOrUndef();if(!o){return true;}var d=o.getSystem();var e=o.getClient();if(!d||!e){return false;}return(s!==d||c!==e);};
C.prototype._isReadOnlyDueToOriginalLanguage=function(){var c;var o;o=this.getOriginalLanguage();if(!o){return false;}c=U.getCurrentLanguage();return(c!==o);};
C.prototype.markForDeletion=function(){this.setState(C.states.DELETED);};
C.prototype.setRequest=function(r){if(typeof(r)!=="string"){b.error("sap.ui.fl.Change.setRequest : sRequest is not defined");}this._sRequest=r;};
C.prototype.getRequest=function(){return this._sRequest;};
C.prototype.getLayer=function(){return this._oDefinition.layer;};
C.prototype.getComponent=function(){return this._oDefinition.reference;};
C.prototype.setComponent=function(c){this._oDefinition.reference=c;};
C.prototype.getCreation=function(){return this._oDefinition.creation;};
C.prototype.isUserDependent=function(){return(this._bUserDependent);};
C.prototype.getPendingAction=function(){return this.getState();};
C.prototype.getDefinition=function(){return this._oDefinition;};
C.prototype.setResponse=function(r){var R=JSON.stringify(r);if(R){this._oDefinition=JSON.parse(R);this.setState(C.states.PERSISTED);}};
C.prototype.getFullFileIdentifier=function(){var l=this.getLayer();var n=this.getNamespace();var f=this.getDefinition().fileName;var F=this.getDefinition().fileType;return l+"/"+n+"/"+f+"."+F;};
C.prototype.addDependentControl=function(c,A,p,m){if(!c){throw new Error("Parameter vControl is mandatory");}if(!A){throw new Error("Parameter sAlias is mandatory");}if(!p){throw new Error("Parameter mPropertyBag is mandatory");}if(!this._oDefinition.dependentSelector){this._oDefinition.dependentSelector={};}if(this._oDefinition.dependentSelector[A]){throw new Error("Alias '"+A+"' already exists in the change.");}var o=p.modifier;var d=p.appComponent;if(Array.isArray(c)){var s=[];c.forEach(function(e){s.push(o.getSelector(e,d,m));});this._oDefinition.dependentSelector[A]=s;}else{this._oDefinition.dependentSelector[A]=o.getSelector(c,d,m);}delete this._aDependentSelectorList;};
C.prototype.getDependentControl=function(A,p){var d=[];var o;if(!A){throw new Error("Parameter sAlias is mandatory");}if(!p){throw new Error("Parameter mPropertyBag is mandatory");}var m=p.modifier;var c=p.appComponent;if(!this._oDefinition.dependentSelector){return undefined;}o=this._oDefinition.dependentSelector[A];if(Array.isArray(o)){o.forEach(function(s){d.push(m.bySelector(s,c,p.view));});return d;}return m.bySelector(o,c,p.view);};
C.prototype.getDependentSelectorList=function(){var t=this;var d=[this.getSelector()];if(!this._aDependentSelectorList){if(this._oDefinition.dependentSelector){Object.keys(this._oDefinition.dependentSelector).forEach(function(A){var c=t._oDefinition.dependentSelector[A];if(!Array.isArray(c)){c=[c];}c.forEach(function(o){if(o&&U.indexOfObject(d,o)===-1){d.push(o);}});});}this._aDependentSelectorList=d;}return this._aDependentSelectorList;};
C.prototype.getDependentControlSelectorList=function(){var d=this.getDependentSelectorList().concat();if(d.length>0){var s=this.getSelector();var I=U.indexOfObject(d,s);if(I>-1){d.splice(I,1);}}return d;};
C.prototype.getRevertData=function(){return this._vRevertData;};
C.prototype.hasRevertData=function(){return this._vRevertData!==null;};
C.prototype.setRevertData=function(d){this._vRevertData=d;};
C.prototype.resetRevertData=function(){this.setRevertData(null);};
C.prototype.getUndoOperations=function(){return this._aUndoOperations;};
C.prototype.setUndoOperations=function(d){this._aUndoOperations=d;};
C.prototype.getExtensionPointInfo=function(){return this._oExtensionPointInfo;};
C.prototype.setExtensionPointInfo=function(e){this._oExtensionPointInfo=e;};
C.prototype.resetUndoOperations=function(){this.setUndoOperations(null);};
C.createInitialFileContent=function(p){if(!p){p={};}var f;if(p.fileType){f=p.fileType;}else{f=p.isVariant?"variant":"change";}var n={fileName:p.id||U.createDefaultFileName(p.changeType),fileType:f,changeType:p.changeType||"",moduleName:p.moduleName||"",reference:p.reference||"",packageName:p.packageName||"",content:p.content||{},selector:p.selector||{id:""},layer:p.layer||a.getCurrentLayer(p.isUserDependent),texts:p.texts||{},namespace:p.namespace||U.createNamespace(p,"changes"),projectId:p.projectId||(p.reference&&p.reference.replace(".Component",""))||"",creation:"",originalLanguage:U.getCurrentLanguage(),support:{generator:p.generator||"Change.createInitialFileContent",service:p.service||"",user:"",sapui5Version:sap.ui.version,sourceChangeFileName:p.support&&p.support.sourceChangeFileName||"",compositeCommand:p.support&&p.support.compositeCommand||"",command:p.command||""},oDataInformation:p.oDataInformation||{},dependentSelector:p.dependentSelector||{},jsOnly:p.jsOnly||false,variantReference:p.variantReference||"",appDescriptorChange:i(D.getChangeTypes(),p.changeType)};return n;};
return C;},true);
sap.ui.predefine('sap/ui/fl/ChangePersistence',["sap/ui/fl/apply/_internal/flexState/changes/DependencyHandler","sap/ui/fl/initial/_internal/StorageUtils","sap/ui/fl/Change","sap/ui/fl/Layer","sap/ui/fl/Variant","sap/ui/fl/Utils","sap/ui/fl/LayerUtils","sap/ui/fl/Cache","sap/ui/fl/apply/_internal/changes/Applier","sap/ui/fl/write/_internal/Storage","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/core/Component","sap/ui/model/json/JSONModel","sap/ui/performance/Measurement","sap/ui/thirdparty/jquery","sap/base/util/includes","sap/base/util/merge","sap/base/util/UriParameters","sap/base/Log","sap/ui/fl/apply/_internal/flexState/controlVariants/VariantManagementState","sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/write/_internal/flexState/compVariants/CompVariantState","sap/ui/fl/write/_internal/condenser/Condenser"],function(D,S,C,L,V,U,a,b,A,c,J,d,e,M,q,i,m,f,g,h,F,j,k){"use strict";var l=function(p){this._mComponent=p;this._mChanges=D.createEmptyDependencyMap();this._bChangesMapCreated=false;this._mChangesInitial=m({},this._mChanges);if(!this._mComponent||!this._mComponent.name){g.error("The Control does not belong to an SAPUI5 component. Personalization and changes for this control might not work as expected.");throw new Error("Missing component name.");}this._aDirtyChanges=[];this._oMessagebundle=undefined;this._mChangesEntries={};this._bHasChangesOverMaxLayer=false;this.HIGHER_LAYER_CHANGES_EXIST="higher_layer_changes_exist";};
function r(v,p){return v.controlChanges.some(function(t,u){if(t.fileName===p.getDefinition().fileName){v.controlChanges.splice(u,1,p);return true;}});}
function n(p,t){var u;if(t instanceof C){u=t;this._mChangesEntries[u.getFileName()]=u;}else{if(!this._mChangesEntries[t.fileName]){this._mChangesEntries[t.fileName]=new C(t);}u=this._mChangesEntries[t.fileName];u.setState(C.states.PERSISTED);var v=u.getVariantReference();if(v){var w=h.getVariant({vReference:v,reference:this._mComponent.name});if(w){r(w,u);}}}return u;}
l.prototype.getComponentName=function(){return this._mComponent.name;};
l.prototype.getCacheKey=function(p){return b.getCacheKey(this._mComponent,p);};
l.prototype._preconditionsFulfilled=function(p){var t=p instanceof C?p.getDefinition():p;function _(){if((t.fileType==="ctrl_variant")||(t.fileType==="ctrl_variant_change")||(t.fileType==="ctrl_variant_management_change")){return t.variantManagementReference||t.variantReference||(t.selector&&t.selector.id);}}return t.fileType==="change"||_();};
l.prototype.getChangesForComponent=function(p,I){return b.getChangesFillingCache(this._mComponent,p,I).then(function(p,w){var t=m({},w);var u=p&&p.component&&U.getAppComponentForControl(p.component);var H=S.isStorageResponseFilled(t.changes);if(!H){return[];}var v=t.changes.changes;if(!this._oMessagebundle&&t.messagebundle&&u){if(!u.getModel("i18nFlexVendor")){if(v.some(function(K){return K.layer===L.VENDOR;})){this._oMessagebundle=t.messagebundle;var x=new e(this._oMessagebundle);u.setModel(x,"i18nFlexVendor");}}}var y=p&&p.currentLayer;var z=!(p&&p.ignoreMaxLayerParameter);var B=function(){return true;};if(y){B=this._filterChangeForCurrentLayer.bind(this,y);v=v.filter(B);}else if(a.isLayerFilteringRequired()&&z){B=this._filterChangeForMaxLayer.bind(this);v=v.filter(B);}else if(this._bHasChangesOverMaxLayer&&!z){this._bHasChangesOverMaxLayer=false;return this.HIGHER_LAYER_CHANGES_EXIST;}var E=t.changes&&p&&p.includeCtrlVariants;var G=this._getAllCtrlVariantChanges(t,E,B);v=v.concat(G);return this._checkAndGetChangeInstances(v,t);}.bind(this,p));};
l.prototype._checkAndGetChangeInstances=function(p,t){return p.filter(this._preconditionsFulfilled).map(n.bind(this,t));};
l.prototype._filterChangeForMaxLayer=function(p){if(a.isOverMaxLayer(this._getLayerFromChangeOrChangeContent(p))){if(!this._bHasChangesOverMaxLayer){this._bHasChangesOverMaxLayer=true;}return false;}return true;};
l.prototype._filterChangeForCurrentLayer=function(p,t){return p===this._getLayerFromChangeOrChangeContent(t);};
l.prototype._getLayerFromChangeOrChangeContent=function(p){var t;if(p instanceof V||p instanceof C){t=p.getLayer();}else{t=p.layer;}return t;};
l.prototype._getAllCtrlVariantChanges=function(p,I,t){if(!I){return h.getInitialChanges({reference:this._mComponent.name});}return["variants","variantChanges","variantDependentControlChanges","variantManagementChanges"].reduce(function(R,v){if(p.changes[v]){return R.concat(p.changes[v]);}return R;},[]).filter(t);};
l.prototype.loadChangesMapForComponent=function(p){return this.getChangesForComponent({component:p}).then(t.bind(this));function t(u){M.start("fl.createDependencyMap","Measurement of creating initial dependency map");this._mChanges=D.createEmptyDependencyMap();u.forEach(this._addChangeAndUpdateDependencies.bind(this,p));this._mChangesInitial=m({},this._mChanges);M.end("fl.createDependencyMap","Measurement of creating initial dependency map");this._bChangesMapCreated=true;return this.getChangesMapForComponent.bind(this);}};
l.prototype.checkForOpenDependenciesForControl=function(p,t){return D.checkForOpenDependenciesForControl(this._mChanges,J.getControlIdBySelector(p,t),t);};
l.prototype.copyDependenciesFromInitialChangesMap=function(p,t,u){var I=m({},this._mChangesInitial.mDependencies);var v=I[p.getId()];if(v){var N=[];v.dependencies.forEach(function(y){if(t(y)){this._mChanges.mDependentChangesOnMe[y]=this._mChanges.mDependentChangesOnMe[y]||[];this._mChanges.mDependentChangesOnMe[y].push(p.getId());N.push(y);}}.bind(this));var w;var x=[];v.controlsDependencies.forEach(function(y){if(!J.bySelector(y,u)){w=J.getControlIdBySelector(y,u);x.push(y);this._mChanges.mControlsWithDependencies[w]=this._mChanges.mControlsWithDependencies[w]||[];if(!i(this._mChanges.mControlsWithDependencies[w],p.getId())){this._mChanges.mControlsWithDependencies[w].push(p.getId());}}}.bind(this));v.dependencies=N;v.controlsDependencies=x;if(N.length||x.length){this._mChanges.mDependencies[p.getId()]=v;}}return this._mChanges;};
l.prototype._addChangeAndUpdateDependencies=function(p,t){t.setInitialApplyState();D.addChangeAndUpdateDependencies(t,p,this._mChanges);};
l.prototype._addRunTimeCreatedChangeAndUpdateDependencies=function(p,t){D.addRuntimeChangeAndUpdateDependencies(t,p,this._mChanges,this._mChangesInitial);};
l.prototype.getChangesMapForComponent=function(){return this._mChanges;};
l.prototype.isChangeMapCreated=function(){return this._bChangesMapCreated;};
l.prototype.changesHavingCorrectViewPrefix=function(p,t){var u=p.modifier;var v=p.appComponent;var w=t.getSelector();if(!w||!p){return false;}if(w.viewSelector){var x=u.getControlIdBySelector(w.viewSelector,v);return x===p.viewId;}var y=w.id;if(y){var z;if(t.getSelector().idIsLocal){if(v){z=v.getLocalId(p.viewId);}}else{z=p.viewId;}var I=0;var B;do{I=y.indexOf("--",I);B=y.slice(0,I);I++;}while(B!==z&&I>0);return B===z;}return false;};
l.prototype.getChangesForView=function(p){return this.getChangesForComponent(p).then(function(t){return t.filter(this.changesHavingCorrectViewPrefix.bind(this,p));}.bind(this));};
l.prototype.addChange=function(v,p){var t=this.addDirtyChange(v);this._addRunTimeCreatedChangeAndUpdateDependencies(p,t);this._addPropagationListener(p);return t;};
l.prototype.addDirtyChange=function(v){var N;if(v instanceof C||v instanceof V){N=v;}else{N=new C(v);}if(this._aDirtyChanges.indexOf(N)===-1){this._aDirtyChanges.push(N);}return N;};
l.prototype._addPropagationListener=function(p){var t=U.getAppComponentForControl(p);if(t instanceof d){var u=function(P){return!P._bIsSapUiFlFlexControllerApplyChangesOnControl;};var N=t.getPropagationListeners().every(u);if(N){var v=sap.ui.require("sap/ui/fl/FlexControllerFactory");var w=v.create(this.getComponentName());var P=A.applyAllChangesForControl.bind(A,this.getChangesMapForComponent.bind(this),t,w);P._bIsSapUiFlFlexControllerApplyChangesOnControl=true;t.addPropagationListener(P);}}};
l.prototype._deleteNotSavedChanges=function(p,t){p.filter(function(u){return!t.some(function(v){return u.getId()===v.getId();});}).forEach(function(u){this.deleteChange(u,true);}.bind(this));};
function s(p,t){var u=false;if(!p||t.length<2){return false;}var v=t.map(function(y){return y.getLayer();});var w=v.filter(function(y,I,v){return v.indexOf(y)===I;});if(w.length>1){return false;}if(w[0]==="CUSTOMER"||w[0]==="USER"){u=true;}var x=f.fromURL(window.location.href);if(x.has("sap-ui-xx-condense-changes")){u=x.get("sap-ui-xx-condense-changes")==="true";}return u;}
l.prototype.saveDirtyChanges=function(p,t,u,v){u=u||this._aDirtyChanges;var w=u.slice(0);var R=this._getRequests(u);var P=this._getPendingActions(u);if(P.length===1&&R.length===1&&P[0]==="NEW"){var x=Promise.resolve(w);if(s(p,w)){x=k.condense(p,w);}return x.then(function(y){if(y.length){var z=R[0];var B=this._prepareDirtyChanges(y);return c.write({layer:B[0].layer,flexObjects:B,transport:z,isLegacyVariant:false,parentVersion:v}).then(function(E){this._massUpdateCacheAndDirtyState(y,t);this._deleteNotSavedChanges(u,y);return E;}.bind(this));}this._deleteNotSavedChanges(u,y);}.bind(this));}return this.saveSequenceOfDirtyChanges(w,t,v);};
l.prototype.saveSequenceOfDirtyChanges=function(p,t,u){var v;if(u){var N=p.filter(function(w){return w.getPendingAction()==="NEW";});v=[].concat(N).shift();}return p.reduce(function(P,w){return P.then(this._performSingleSaveAction(w,v,u)).then(this._updateCacheAndDirtyState.bind(this,w,t));}.bind(this),Promise.resolve());};
l.prototype._performSingleSaveAction=function(p,t,u){return function(){if(p.getPendingAction()==="NEW"){if(u!==undefined){u=p===t?u:sap.ui.fl.Versions.Draft;}return c.write({layer:p.getLayer(),flexObjects:[p.getDefinition()],transport:p.getRequest(),parentVersion:u});}if(p.getPendingAction()==="DELETE"){return c.remove({flexObject:p.getDefinition(),layer:p.getLayer(),transport:p.getRequest()});}};};
l.prototype._updateCacheAndDirtyState=function(p,t){if(!t){if(U.isChangeRelatedToVariants(p)){h.updateVariantsState({reference:this._mComponent.name,changeToBeAddedOrDeleted:p});}else if(U.isChangeRelatedToCompVariant(p)){j.updateState({reference:this._mComponent.name,changeToBeAddedOrDeleted:p});}else if(p.getPendingAction()==="NEW"){b.addChange(this._mComponent,p.getDefinition());}else if(p.getPendingAction()==="DELETE"){b.deleteChange(this._mComponent,p.getDefinition());}}this._aDirtyChanges=this._aDirtyChanges.filter(function(E){return p.getId()!==E.getId();});};
l.prototype._massUpdateCacheAndDirtyState=function(p,t){p.forEach(function(u){this._updateCacheAndDirtyState(u,t);},this);};
l.prototype._getRequests=function(p){var R=[];p.forEach(function(t){var u=t.getRequest();if(R.indexOf(u)===-1){R.push(u);}});return R;};
l.prototype._getPendingActions=function(p){var P=[];p.forEach(function(t){var u=t.getPendingAction();if(P.indexOf(u)===-1){P.push(u);}});return P;};
l.prototype._prepareDirtyChanges=function(p){var t=[];p.forEach(function(u){t.push(u.getDefinition());});return t;};
l.prototype.getDirtyChanges=function(){return this._aDirtyChanges;};
l.prototype.deleteChange=function(p,R){var t=this._aDirtyChanges.indexOf(p);if(t>-1){if(p.getPendingAction()==="DELETE"){return;}this._aDirtyChanges.splice(t,1);this._deleteChangeInMap(p,R);return;}p.markForDeletion();this.addDirtyChange(p);this._deleteChangeInMap(p,R);};
l.prototype._deleteChangeInMap=function(p,R){var t=p.getId();D.removeChangeFromMap(this._mChanges,t);D.removeChangeFromDependencies(R?this._mChangesInitial:this._mChanges,t);};
function o(p,O){return(O.getRequest()==="$TMP"||O.getRequest()==="")&&O.getLayer()===p;}
l.prototype.transportAllUIChanges=function(R,p,t,u){return Promise.all([this.getChangesForComponent({currentLayer:t,includeCtrlVariants:true}),F.getCompEntitiesByIdMap(this.getComponentName())]).then(function(v){var w=v[0];var x=v[1];var y=[];for(var z in x){y.push(x[z]);}w=w.concat(y.filter(o.bind(this,t)));return c.publish({transportDialogSettings:{rootControl:R,styleClass:p},layer:t,reference:this.getComponentName(),localChanges:w,appVariantDescriptors:u});}.bind(this));};
l.prototype._getChangesFromMapByNames=function(N){return this._mChanges.aChanges.filter(function(p){return N.indexOf(p.getFileName())!==-1;});};
l.prototype.removeDirtyChanges=function(p,t,u,G,v){if(!u){g.error("The selectorId must be provided");return Promise.reject("The selectorId must be provided");}var w=this._aDirtyChanges;var x=w.filter(function(y){var z=true;if(y.getLayer()!==p){return false;}if(G&&y.getDefinition().support.generator!==G){return false;}var B=y.getSelector();z=u.getId()===J.getControlIdBySelector(B,t);if(v){z=z&&v.indexOf(y.getChangeType())!==-1;}return z;});x.forEach(function(y){var z=w.indexOf(y);w.splice(z,1);});return Promise.resolve(x);};
l.prototype.resetChanges=function(p,G,t,u){var v=t&&t.length>0;var w=u&&u.length>0;if(!G&&!v&&!w){g.error("Of the generator, selector IDs and change types parameters at least one has to filled");return Promise.reject("Of the generator, selector IDs and change types parameters at least one has to filled");}return this.getChangesForComponent({currentLayer:p,includeCtrlVariants:true}).then(function(x){var P={reference:this.getComponentName(),layer:p,changes:x};if(G){P.generator=G;}if(v){P.selectorIds=t;}if(w){P.changeTypes=u;}return c.reset(P);}.bind(this)).then(function(R){var x=[];if(t||u){var N=[];if(R&&R.response&&R.response.length>0){R.response.forEach(function(y){N.push(y.fileName);});}b.removeChanges(this._mComponent,N);x=this._getChangesFromMapByNames(N);}return x;}.bind(this));};
l.prototype.getResetAndPublishInfo=function(p){return c.getFlexInfo(p);};
return l;},true);
sap.ui.predefine('sap/ui/fl/ChangePersistenceFactory',["sap/ui/core/Component","sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/ChangePersistence","sap/ui/fl/Utils"],function(C,F,a,U){"use strict";var b={};b._instanceCache={};
b.getChangePersistenceForComponent=function(c){var o=b._instanceCache[c];if(!o){var d={name:c};o=new a(d);b._instanceCache[c]=o;}return o;};
b.getChangePersistenceForControl=function(c){var s;s=U.getComponentClassName(c);return b.getChangePersistenceForComponent(s);};
b.registerLoadComponentEventHandler=function(){C._fnLoadComponentCallback=this._onLoadComponent.bind(this);};
b._onLoadComponent=function(c,m){if(!U.isApplication(m)||!c.id){return;}F.initialize({componentData:c.componentData||(c.settings&&c.settings.componentData),asyncHints:c.asyncHints,manifest:m,componentId:c.id});};
return b;},true);
sap.ui.predefine('sap/ui/fl/EventHistory',function(){"use strict";var E=function(){};E._aEventIds=["ControlForPersonalizationRendered"];E._aUnsubscribedEventIds=[];E._oHistory={};
E.start=function(){E._aEventIds.forEach(function(e){if(E._aUnsubscribedEventIds.indexOf(e)===-1){sap.ui.getCore().getEventBus().subscribe("sap.ui",e,E.saveEvent);E._oHistory[e]=[];}});};
E.saveEvent=function(c,e,p){var o={channelId:c,eventId:e,parameters:p.getId()};if(E._oHistory[e]){var b=E._oHistory[e].some(function(O){return(O.channelId===o.channelId&&O.eventId===o.eventId&&O.parameters===o.parameters);});if(!b){E._oHistory[e].push(o);}}};
E.getHistoryAndStop=function(e){sap.ui.getCore().getEventBus().unsubscribe("sap.ui",e,E.saveEvent);E._addUnsubscribedEvent(e);return E._oHistory[e]||[];};
E._addUnsubscribedEvent=function(e){if(E._aUnsubscribedEventIds.indexOf(e)===-1){E._aUnsubscribedEventIds.push(e);}};
return E;},true);
sap.ui.predefine('sap/ui/fl/FakeLrepConnector',["sap/ui/Device","sap/ui/fl/write/_internal/connectors/ObjectPathConnector","sap/ui/fl/apply/_internal/connectors/ObjectStorageUtils"],function(D,O,a){"use strict";var F={};var b="sap.ui.fl";F.prototype={};
F.enableFakeConnector=function(i){this.setFlexibilityServicesAndClearCache("LocalStorageConnector",i);};
F.setFlexibilityServicesAndClearCache=function(s,i){this._oFlexibilityServices=sap.ui.getCore().getConfiguration().getFlexibilityServices();var c=[];if(i){O.setJsonPath(i);c.push({connector:"ObjectPathConnector"});}c.push({connector:s});sap.ui.getCore().getConfiguration().setFlexibilityServices(c);sap.ui.requireSync("sap/ui/fl/Cache").clearEntries();};
F.disableFakeConnector=function(){F.prototype={};sap.ui.requireSync("sap/ui/fl/Cache").clearEntries();if(this._oFlexibilityServices){sap.ui.getCore().getConfiguration().setFlexibilityServices(this._oFlexibilityServices);delete this._oFlexibilityServices;}};
F.forTesting={getNumberOfChanges:function(c,r){return c.loadFlexData({reference:r}).then(function(R){return R.reduce(function(n,o){return n+o.changes.length;},0);});},spyMethod:function(s,c,C,m){var S=s.spy(C,m);return function(n,i){i=i||0;var N=S.getCall(i).args[0].flexObjects.length;c.equal(N,n,m+" was called "+n+" times");};},clear:function(c,p){sap.ui.requireSync("sap/ui/fl/Cache").clearEntries();return c.reset(p);},setStorage:function(c,n){c.storage=n;},synchronous:{clearAll:function(s){var r=function(k){var I=k.includes(b);if(!I){return;}s.removeItem(k);};if(D.browser.msie){var S=s.length;for(var i=S-1;i>=0;i--){var k=s.key(i);r(k);}}else{Object.keys(s).map(r);}},store:function(s,k,i){var f=a.createFlexKey(k);var I=JSON.stringify(i);s.setItem(f,I);},getNumberOfChanges:function(s,r){var c=0;Object.keys(s).map(function(k){var i=k.includes(b);if(!i){return;}var f=JSON.parse(s.getItem(k));if(f.reference===r||f.reference+".Component"===r){c++;}});return c;}}};return F;},true);
sap.ui.predefine('sap/ui/fl/FlexController',["sap/ui/fl/registry/ChangeRegistry","sap/ui/fl/Utils","sap/ui/fl/Layer","sap/ui/fl/LayerUtils","sap/ui/fl/Change","sap/ui/fl/ChangePersistenceFactory","sap/ui/fl/write/_internal/Versions","sap/ui/fl/apply/_internal/flexState/controlVariants/VariantManagementState","sap/ui/fl/apply/_internal/changes/Applier","sap/ui/fl/apply/_internal/changes/Reverter","sap/ui/fl/apply/_internal/controlVariants/URLHandler","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/core/util/reflection/XmlTreeModifier","sap/ui/core/Component","sap/base/Log"],function(C,U,L,a,b,c,V,d,A,R,e,J,X,f,g){"use strict";
function r(o,i){return Promise.resolve().then(function(){if(i.length!==0){return R.revertMultipleChanges(i,{appComponent:o,modifier:J,flexController:this});}}.bind(this)).then(function(){if(o){var m=o.getModel(U.VARIANT_MODEL_NAME);if(m){i.forEach(function(k){var v=k.getVariantReference();if(v){m.removeChange(k);}});e.update({parameters:[],updateURL:true,updateHashEntry:true,model:m});}}return i;});}
var F=function(s){this._oChangePersistence=undefined;this._sComponentName=s||"";if(this._sComponentName){this._createChangePersistence();}};
F.prototype.getComponentName=function(){return this._sComponentName;};
F.prototype.setVariantSwitchPromise=function(p){this._oVariantSwitchPromise=p;};
F.prototype.waitForVariantSwitch=function(){if(!this._oVariantSwitchPromise){this._oVariantSwitchPromise=Promise.resolve();}return this._oVariantSwitchPromise;};
F.prototype.createBaseChange=function(o,i){var k;var l;if(!i){throw new Error("No application component found. To offer flexibility a valid relation to its owning component must be present.");}o.reference=this.getComponentName();o.packageName="$TMP";k=b.createInitialFileContent(o);l=new b(k);if(o.variantReference){l.setVariantReference(o.variantReference);}return l;};
F.prototype._createChange=function(o,i,k){var s=k&&(k.controlType||U.getControlType(k));var l=this.createBaseChange(o,i);return this._getChangeHandler(l,s,k,J).then(function(m){if(m){m.completeChangeContent(l,o,{modifier:J,appComponent:i});}else{throw new Error("Change handler could not be retrieved for change "+JSON.stringify(o)+".");}return l;}).catch(function(E){return Promise.reject(E);});};
F.prototype.createChangeWithExtensionPointSelector=function(o,E){return Promise.resolve().then(function(){if(!E){throw new Error("A flexibility change on extension point cannot be created without a valid extension point reference.");}var v=E.view;var i=U.getAppComponentForControl(v);o.selector={name:E.name,viewSelector:J.getSelector(v.getId(),i)};return i;}).then(function(i){return this._createChange(o,i);}.bind(this));};
F.prototype.createChangeWithControlSelector=function(o,i){var k;return new U.FakePromise().then(function(){if(!i){throw new Error("A flexibility change cannot be created without a targeted control.");}var s=i.id||i.getId();if(!o.selector){o.selector={};}k=i.appComponent||U.getAppComponentForControl(i);if(!k){throw new Error("No application component found. To offer flexibility, the control with the ID '"+s+"' has to have a valid relation to its owning application component.");}Object.assign(o.selector,J.getSelector(s,k));return k;}).then(function(k){return this._createChange(o,k,i);}.bind(this));};
F.prototype.addChange=function(o,i){return this.createChangeWithControlSelector(o,i).then(function(k){var l=U.getAppComponentForControl(i);k._ignoreOnce=true;this.addPreparedChange(k,l);k.setQueuedForApply();return k;}.bind(this));};
F.prototype.addPreparedChange=function(o,i){if(o.getVariantReference()){var m=i.getModel(U.VARIANT_MODEL_NAME);m.addChange(o);}this._oChangePersistence.addChange(o,i);return o;};
F.prototype.deleteChange=function(o,i){this._oChangePersistence.deleteChange(o);if(o.getVariantReference()){i.getModel(U.VARIANT_MODEL_NAME).removeChange(o);}};
F.prototype.applyChange=function(o,i){var p={modifier:J,appComponent:U.getAppComponentForControl(i),view:U.getViewForControl(i)};return A.applyChangeOnControl(o,i,p).then(function(k){if(!k.success){var E=k.error||new Error("The change could not be applied.");this._oChangePersistence.deleteChange(o,true);throw E;}return o;}.bind(this));};
function h(o,D,m,k,l){var p=j(o,k);if(!p){return[];}l.push(o);var s=o.getId();var q=D[s]&&D[s].dependencies||[];for(var i=0,n=q.length;i<n;i++){var t=U.getChangeFromChangesMap(m,q[i]);p=h(t,D,m,k,l);if(p.length===0){l=[];break;}delete D[s];}return l;}
function j(o,i){var s=o.getDependentControlSelectorList();s.push(o.getSelector());return!s.some(function(S){return!J.bySelector(S,i);});}
F.prototype.waitForChangesToBeApplied=function(s){var S;if(Array.isArray(s)){S=s;}else{S=[s];}var p=S.map(function(v){return this._waitForChangesToBeApplied(v);}.bind(this));return Promise.all(p).then(function(){return undefined;});};
F.prototype._waitForChangesToBeApplied=function(s){var o=s.id&&sap.ui.getCore().byId(s.id)||s;var m=this._oChangePersistence.getChangesMapForComponent();var p=[];var D=Object.assign({},m.mDependencies);var i=m.mChanges;var k=i[o.getId()]||[];var n=k.filter(function(t){return!t.isCurrentProcessFinished();},this);var l=s.appComponent||U.getAppComponentForControl(o);var q=[];n.forEach(function(t){var u=h(t,D,m.mChanges,l,[]);u.forEach(function(v){if(q.indexOf(v)===-1){q.push(v);}});});q.forEach(function(t){p=p.concat(t.addChangeProcessingPromises());},this);p.push(this.waitForVariantSwitch());return Promise.all(p);};
F.prototype.saveAll=function(o,s,D){var n=D?V.getVersionsModel({reference:U.normalizeReference(this._sComponentName),layer:L.CUSTOMER}).getProperty("/persistedVersion"):undefined;return this._oChangePersistence.saveDirtyChanges(o,s,undefined,n).then(function(i){if(D&&i&&i.response){var v=i.response;if(Array.isArray(v)){v=v[0];}V.onAllChangesSaved({reference:v.reference,layer:v.layer});}return i;});};
F.prototype.processXmlView=function(v,p){var o=f.get(p.componentId);var i=U.getAppComponentForControl(o);p.appComponent=i;p.modifier=X;p.view=v;return this._oChangePersistence.getChangesForView(p).then(A.applyAllChangesForXMLView.bind(A,p)).catch(this._handlePromiseChainError.bind(this,p.view));};
F.prototype._handlePromiseChainError=function(v,E){g.error("Error processing view "+E+".");return v;};
F.prototype._getChangeHandler=function(o,s,i,m){var k=o.getChangeType();var l=o.getLayer();return this._getChangeRegistry().getChangeHandler(k,s,i,m,l);};
F.prototype._getChangeRegistry=function(){var i=C.getInstance();i.initSettings();return i;};
F.prototype.getComponentChanges=function(p,i){return this._oChangePersistence.getChangesForComponent(p,i);};
F.prototype.checkForOpenDependenciesForControl=function(s,o){return this._oChangePersistence.checkForOpenDependenciesForControl(s,o);};
F.prototype._createChangePersistence=function(){this._oChangePersistence=c.getChangePersistenceForComponent(this.getComponentName());return this._oChangePersistence;};
F.prototype.resetChanges=function(l,G,o,s,i){return this._oChangePersistence.resetChanges(l,G,s,i).then(r.bind(this,o));};
F.prototype.removeDirtyChanges=function(l,o,i,G,k){return this._oChangePersistence.removeDirtyChanges(l,o,i,G,k).then(r.bind(this,o));};
F.prototype.discardChanges=function(i,D){var s=a.getCurrentLayer(!!D);var I=0;var l;var o;l=i.length;while(I<i.length){o=i[I];if(o&&o.getLayer&&o.getLayer()===s){this._oChangePersistence.deleteChange(o);}if(l===i.length){I++;}else{l=i.length;}}return this._oChangePersistence.saveDirtyChanges();};
F.prototype.applyVariantChanges=function(i,o){var k;return i.reduce(function(p,l){return p.then(function(){var P={modifier:J,appComponent:o};this._oChangePersistence._addRunTimeCreatedChangeAndUpdateDependencies(o,l);k=P.modifier.bySelector(l.getSelector(),o);if(k){return A.applyChangeOnControl(l,k,P);}g.error("A flexibility change tries to change a nonexistent control.");}.bind(this));}.bind(this),new U.FakePromise());};
F.prototype.saveSequenceOfDirtyChanges=function(D,o){return this._oChangePersistence.saveDirtyChanges(o,false,D);};
F.prototype.getResetAndPublishInfo=function(p){p.reference=this._sComponentName;return this._oChangePersistence.getResetAndPublishInfo(p);};
return F;},true);
sap.ui.predefine('sap/ui/fl/FlexControllerFactory',["sap/ui/fl/FlexController","sap/ui/fl/Utils","sap/ui/fl/Layer","sap/ui/fl/apply/_internal/changes/Applier","sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/variants/VariantModel","sap/base/Log","sap/ui/performance/Measurement"],function(F,U,L,A,a,V,b,M){"use strict";var c={};c._instanceCache={};c._componentInstantiationPromises={};
c.create=function(C){var f=c._instanceCache[C];if(!f){f=new F(C);c._instanceCache[C]=f;}return f;};
c.createForControl=function(C){try{var o=U.getAppComponentForControl(C);var s=U.getComponentClassName(o||C);return c.create(s);}catch(e){b.error(e.message,undefined,"sap.ui.fl.FlexControllerFactory");}};
function d(r,C){if(U.getUshellContainer()){return Promise.resolve(r);}var R=window.sessionStorage.getItem("sap.ui.rta.restart."+L.CUSTOMER);if(R){var s=U.getComponentClassName(C);if(R!==s&&R!=="true"){b.error("an application component was started "+"which does not match the component for which the restart was triggered:\n"+"Triggering component: "+R+"\n"+"Started component: "+s);return Promise.resolve(r);}window.sessionStorage.removeItem("sap.ui.rta.restart."+L.CUSTOMER);return new Promise(function(e){sap.ui.getCore().loadLibrary("sap.ui.rta",{async:true}).then(function(){sap.ui.require(["sap/ui/rta/api/startKeyUserAdaptation"],function(f){f({rootControl:C});e(r);});});});}return Promise.resolve(r);}
c.getChangesAndPropagate=function(C,v){if(U.isApplicationComponent(C)){var s=C.getId();c._componentInstantiationPromises[s]=a.initialize({componentId:s,asyncHints:v.asyncHints}).then(_.bind(this,C));return c._componentInstantiationPromises[s];}else if(U.isEmbeddedComponent(C)){var o=U.getAppComponentForControl(C);if(o&&U.isApplicationComponent(o)){var i=Promise.resolve();if(c._componentInstantiationPromises[o.getId()]){i=c._componentInstantiationPromises[o.getId()];}return i.then(function(){var e=o.getModel(U.VARIANT_MODEL_NAME);if(!e){return _(o);}return e;}).then(function(e){C.setModel(e,U.VARIANT_MODEL_NAME);});}return Promise.resolve();}};
function _(o){var m=o.getManifestObject();var f=c.createForControl(o,m);return f._oChangePersistence.loadChangesMapForComponent(o).then(function(g){var p=A.applyAllChangesForControl.bind(A,g,o,f);p._bIsSapUiFlFlexControllerApplyChangesOnControl=true;o.addPropagationListener(p);var v=new V({},f,o);o.setModel(v,U.VARIANT_MODEL_NAME);M.end("flexProcessing");return v;}).then(function(r){return d(r,o);});}
return c;},true);
sap.ui.predefine('sap/ui/fl/LayerUtils',["sap/base/util/UriParameters","sap/ui/thirdparty/hasher","sap/ui/fl/Layer","sap/ui/fl/Utils"],function(U,h,L,a){"use strict";var l=[L.BASE,L.VENDOR,L.PARTNER,L.CUSTOMER_BASE,L.CUSTOMER,L.USER];var m={};l.forEach(function(s,i){m[s]=i;});var b={_mLayersIndex:m,_sTopLayer:l[l.length-1],FL_MAX_LAYER_PARAM:"sap-ui-fl-max-layer",isValidLayer:function(s){return Object.keys(L).some(function(e){return e===s;});},isVendorLayer:function(){return this.getCurrentLayer(false)===L.VENDOR;},isCustomerDependentLayer:function(s){return([L.CUSTOMER,L.CUSTOMER_BASE].indexOf(s)>-1);},doesCurrentLayerRequirePackage:function(){var c=this.getCurrentLayer(false);return(c===L.VENDOR)||(c===L.PARTNER)||(c===L.CUSTOMER_BASE);},getMaxLayer:function(){var p=b.getMaxLayerTechnicalParameter(h.getHash());return p||b.getUrlParameter(this.FL_MAX_LAYER_PARAM)||b._sTopLayer;},getLayerIndex:function(s){return this._mLayersIndex[s];},isOverMaxLayer:function(s){return this.isOverLayer(s,this.getMaxLayer());},isOverLayer:function(o,c){return this.getLayerIndex(o)>this.getLayerIndex(c);},compareAgainstCurrentLayer:function(s,c){var C=c||b.getCurrentLayer(false);if((this.getLayerIndex(C)>this.getLayerIndex(s))||!s){return-1;}else if(this.getLayerIndex(C)===this.getLayerIndex(s)){return 0;}return 1;},isLayerFilteringRequired:function(){return!(this._sTopLayer===this.getMaxLayer());},getCurrentLayer:function(i){if(i){return L.USER;}var s=this.getUrlParameter("sap-ui-layer")||"";s=s.toUpperCase();return s||L.CUSTOMER;},filterChangeDefinitionsByMaxLayer:function(c){return c.filter(function(C){if(C.layer&&b.isOverMaxLayer(C.layer)){return false;}return true;});},getUrlParameter:function(p){return U.fromQuery(window.location.search).get(p);},getMaxLayerTechnicalParameter:function(H){return a.ifUShellContainerThen(function(s){var p=s[0].parseShellHash(H)||{};if(p.params&&p.params.hasOwnProperty(this.FL_MAX_LAYER_PARAM)){return p.params[this.FL_MAX_LAYER_PARAM][0];}}.bind(this),["URLParsing"]);}};return b;},true);
sap.ui.predefine('sap/ui/fl/PreprocessorImpl',["sap/ui/core/Component","sap/ui/fl/Utils","sap/ui/fl/ChangePersistenceFactory","sap/base/Log"],function(C,U,a,L){'use strict';
function i(c){return c.getChangeType()==="codeExt";}
function b(c,o){var s=o.getSelector().controllerName;return c===s;}
var P=function(){};
P.prototype.getControllerExtensions=function(c,s,A){if(A){if(!s){L.warning("No component ID for determining the anchor of the code extensions was passed.");return Promise.resolve([]);}var o=C.get(s);var d=U.getAppComponentForControl(o);if(!U.isApplication(d.getManifestObject())){return Promise.resolve([]);}var f=U.getComponentClassName(d);var e=a.getChangePersistenceForComponent(f);return e.getChangesForComponent().then(function(g){var E=g.filter(function(h){return i(h)&&b(c,h);}).map(function(h){return h.getModuleName();});return P.getExtensionModules(E);});}L.warning("Synchronous extensions are not supported by sap.ui.fl.PreprocessorImpl");return[];};
P.getExtensionModules=function(c){if(c.length===0){return Promise.resolve([]);}return new Promise(function(r){sap.ui.require(c,function(){var m=Array.prototype.slice.call(arguments);r(m);},function(e){L.error("Code Extension not found",e.message);r([]);});});};
return P;},true);
sap.ui.predefine('sap/ui/fl/RegistrationDelegator',["sap/ui/fl/FlexControllerFactory","sap/ui/core/Component","sap/ui/fl/registry/ChangeHandlerRegistration","sap/ui/fl/ChangePersistenceFactory","sap/ui/core/mvc/Controller","sap/ui/core/mvc/XMLView","sap/ui/core/ExtensionPoint","sap/ui/fl/EventHistory","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/apply/_internal/changes/descriptor/Preprocessor","sap/ui/fl/PreprocessorImpl","sap/ui/fl/XmlPreprocessorImpl"],function(F,C,a,b,M,X,E,c,d,P){"use strict";var R={};
function _(){C._fnOnInstanceCreated=F.getChangesAndPropagate;}
function e(){a.getChangeHandlersOfLoadedLibsAndRegisterOnNewLoadedLibs();}
function f(){C._fnLoadComponentCallback=b._onLoadComponent.bind(b);}
function g(){M.registerExtensionProvider("sap.ui.fl.PreprocessorImpl");}
function h(){if(X.registerPreprocessor){X.registerPreprocessor("viewxml","sap.ui.fl.XmlPreprocessorImpl",true);}}
function i(){c.start();}
function j(){C._fnPreprocessManifest=P.preprocessManifest;}
function k(v){if(d.isFlexExtensionPointHandlingEnabled(v)){return"sap/ui/fl/apply/_internal/extensionPoint/Processor";}if(sap.ui.getCore().getConfiguration().getDesignMode()){return"sap/ui/fl/write/_internal/extensionPoint/Processor";}return undefined;}
function l(){E.registerExtensionProvider(k);}
R.registerAll=function(){i();e();f();g();_();h();j();l();};
return R;},true);
sap.ui.predefine('sap/ui/fl/Utils',["sap/ui/thirdparty/jquery","sap/ui/core/Component","sap/ui/core/util/reflection/BaseTreeModifier","sap/ui/thirdparty/hasher","sap/base/Log","sap/base/util/UriParameters","sap/base/util/uid","sap/base/strings/formatMessage","sap/ui/base/ManagedObject","sap/ui/core/mvc/View"],function(q,C,B,h,L,U,u,f,M,V){"use strict";
function a(c){if(c.length>0&&c.indexOf(".Component")<0){c+=".Component";}return c;}
var b={APP_ID_AT_DESIGN_TIME:"${pro"+"ject.art"+"ifactId}",VARIANT_MODEL_NAME:"$FlexVariants",formatAndLogMessage:function(l,m,v,c){var s=m.join(' ');s=f(s,v);L[l](s,c||"");},getXSRFTokenFromControl:function(c){var m;if(!c){return"";}if(c&&typeof c.getModel==="function"){m=c.getModel();return b._getXSRFTokenFromModel(m);}return"";},_getXSRFTokenFromModel:function(m){var H;if(!m){return"";}if(typeof m.getHeaders==="function"){H=m.getHeaders();if(H){return H["x-csrf-token"];}}return"";},getComponentClassName:function(c){var A;if(c){A=this.getAppComponentForControl(c);if(A){var v=this._getComponentStartUpParameter(A,"sap-app-id");if(v){return v;}if(A.getManifestEntry("sap.ui5")&&A.getManifestEntry("sap.ui5").appVariantId){return A.getManifestEntry("sap.ui5").appVariantId;}}}return b.getComponentName(A);},isVariantByStartupParameter:function(c){if(c){var A=this.getAppComponentForControl(c);if(A){return!!this._getComponentStartUpParameter(A,"sap-app-id");}}return false;},getAppComponentClassNameForComponent:function(c){return b.getComponentClassName(c);},getAppDescriptor:function(c){var m=null;var o=null;var d=null;if(c){o=this.getAppComponentForControl(c);if(o&&o.getMetadata){d=o.getMetadata();if(d&&d.getManifest){m=d.getManifest();}}}return m;},getSiteId:function(c){var s=null;var A=null;if(c){A=this.getAppComponentForControl(c);if(A){s=this._getComponentStartUpParameter(A,"hcpApplicationId");}}return s;},getSiteIdByComponentData:function(c){return this._getStartUpParameter(c,"hcpApplicationId");},isBinding:function(p){var i=false;if(p&&typeof p==="string"&&p.substring(0,1)==="{"&&p.slice(-1)==="}"){i=true;}return i;},isApplicationVariant:function(c){var F=b.getComponentClassName(c);var A=b.getAppComponentForControl(c);var s=b.getComponentName(A);return F!==s;},isChangeRelatedToVariants:function(c){return c.getFileType()==="ctrl_variant_change"||c.getFileType()==="ctrl_variant_management_change"||c.getFileType()==="ctrl_variant"||c.getVariantReference();},isChangeRelatedToCompVariant:function(F){return F.getFileType()==="variant"||!!F.getSelector().persistencyKey;},_getComponentStartUpParameter:function(c,p){var s=null;if(p){if(c&&c.getComponentData){s=this._getStartUpParameter(c.getComponentData(),p);}}return s;},_getStartUpParameter:function(c,p){if(c&&c.startupParameters&&p){if(Array.isArray(c.startupParameters[p])){return c.startupParameters[p][0];}}},getComponentName:function(c){var s="";if(c){s=c.getMetadata().getName();}return a(s);},_getComponent:function(c){var o;if(c){o=C.get(c);}return o;},_getComponentIdForControl:function(c){var s=b._getOwnerIdForControl(c);if(!s){if(c&&typeof c.getParent==="function"){var p=c.getParent();if(p){return b._getComponentIdForControl(p);}}}return s||"";},getComponentForControl:function(c){return b._getComponentForControl(c);},getAppComponentForControl:function(c){var o=c instanceof C?c:this._getComponentForControl(c);return this._getAppComponentForComponent(o);},getAppDescriptorComponentObjectForControl:function(c){var A=this.getAppComponentForControl(c);var m=A.getManifest();return{name:this.getAppIdFromManifest(m)};},_getComponentForControl:function(c){var o=null;var s=null;if(c){s=b._getComponentIdForControl(c);if(s){o=b._getComponent(s);}}return o;},_getAppComponentForComponent:function(c){var s=null;if(c&&c.getAppComponent&&c.getAppComponent()instanceof C){return c.getAppComponent();}if(c&&c.oComponentData&&c.oComponentData.appComponent){return c.oComponentData.appComponent;}if(c&&c.getManifestEntry){s=c.getManifestEntry("sap.app");}else{return c;}if(s&&s.type&&s.type!=="application"){if(c instanceof C){c=this._getComponentForControl(c);}return this.getAppComponentForControl(c);}return c;},getViewForControl:function(c){return b.getFirstAncestorOfControlWithControlType(c,sap.ui.core.mvc.View);},getFirstAncestorOfControlWithControlType:function(c,d){if(c instanceof d){return c;}if(c&&typeof c.getParent==="function"){c=c.getParent();return b.getFirstAncestorOfControlWithControlType(c,d);}},hasControlAncestorWithId:function(c,A){var o;if(c===A){return true;}o=sap.ui.getCore().byId(c);while(o){if(o.getId()===A){return true;}if(typeof o.getParent==="function"){o=o.getParent();}else{return false;}}return false;},_isView:function(c){return c instanceof V;},_getOwnerIdForControl:function(c){return C.getOwnerIdFor(c);},getClient:function(){var o;var c;o=this._getUriParameters();c=o.get("sap-client");return c||undefined;},_getUriParameters:function(){return U.fromQuery(window.location.search);},isHotfixMode:function(){var o;var i;o=this._getUriParameters();i=o.get("hotfix");return(i==="true");},convertBrowserLanguageToISO639_1:function(s){if(!s||typeof s!=="string"){return"";}var n=s.indexOf("-");if((n<0)&&(s.length<=2)){return s.toUpperCase();}if(n>0&&n<=2){return s.substring(0,n).toUpperCase();}return"";},getLrepUrl:function(){var F=sap.ui.getCore().getConfiguration().getFlexibilityServices();var l=F.find(function(s){return s.connector==="LrepConnector";});return l?l.url:"";},getCurrentLanguage:function(){var l=sap.ui.getCore().getConfiguration().getLanguage();return b.convertBrowserLanguageToISO639_1(l);},getControlType:function(c){var m;if(c&&typeof c.getMetadata==="function"){m=c.getMetadata();if(m&&typeof m.getElementName==="function"){return m.getElementName();}}},asciiToString:function(c){var d=c.split(",");var p="";q.each(d,function(i,e){p+=String.fromCharCode(e);});return p;},stringToAscii:function(s){var c="";for(var i=0;i<s.length;i++){c+=s.charCodeAt(i)+",";}c=c.substring(0,c.length-1);return c;},checkControlId:function(c,A){if(!A){c=c instanceof M?c:sap.ui.getCore().byId(c);A=b.getAppComponentForControl(c);}return B.checkControlId(c,A);},hasLocalIdSuffix:B.hasLocalIdSuffix,_getAllUrlParameters:function(){return window.location.search.substring(1);},getTechnicalParametersForComponent:function(c){return c&&c.getComponentData&&c.getComponentData()&&c.getComponentData().technicalParameters;},getParsedURLHash:function(){return b.ifUShellContainerThen(function(s){var p=s[0].parseShellHash(h.getHash());return p||{};},["URLParsing"])||{};},ifUShellContainerThen:function(c,s){var o=b.getUshellContainer();if(o){var S=s.map(function(d){return o.getService(d);});return c(S);}},isDebugEnabled:function(){var o=this._getUriParameters();var d=o.get("sap-ui-debug")||"";if(sap.ui.getCore().getConfiguration().getDebug()||d==="true"){return true;}var D=d.split(",");return D.indexOf("sap/ui/fl")!==-1||D.indexOf("sap/ui/fl/")!==-1;},getUrlParameter:function(p){return U.fromQuery(window.location.search).get(p);},getUshellContainer:function(){return sap.ushell&&sap.ushell.Container;},createDefaultFileName:function(n){var F=u().replace(/-/g,"_");if(n){F+='_'+n;}return F;},createNamespace:function(p,s){var r=p.reference.replace('.Component','');var n='apps/'+r+"/"+s+"/";return n;},buildLrepRootNamespace:function(s,S,p){var r="apps/";var e=new Error("Error in sap.ui.fl.Utils#buildLrepRootNamespace: ");if(!s){e.message+="for every scenario you need a base ID";throw e;}switch(S){case sap.ui.fl.Scenario.VersionedAppVariant:if(!p){e.message+="in a versioned app variant scenario you additionally need a project ID";throw e;}r+=s+"/appVariants/"+p+"/";break;case sap.ui.fl.Scenario.AppVariant:if(!p){e.message+="in an app variant scenario you additionally need a project ID";throw e;}r+=s+"/appVariants/"+p+"/";break;case sap.ui.fl.Scenario.AdaptationProject:if(!p){e.message+="in a adaptation project scenario you additionally need a project ID";throw e;}r+=s+"/adapt/"+p+"/";break;case sap.ui.fl.Scenario.FioriElementsFromScratch:case sap.ui.fl.Scenario.UiAdaptation:default:r+=s+"/";}return r;},_getComponentTypeFromManifest:function(m){return m&&m.getEntry&&m.getEntry("sap.app")&&m.getEntry("sap.app").type;},_getComponentTypeFromRawManifest:function(m){return m&&m["sap.app"]&&m["sap.app"].type;},isApplication:function(m,i){var c=i?b._getComponentTypeFromRawManifest(m):b._getComponentTypeFromManifest(m);return c==="application";},isApplicationComponent:function(c){return c instanceof C&&b.isApplication(c.getManifestObject());},isEmbeddedComponent:function(c){return c instanceof C&&b._getComponentTypeFromManifest(c.getManifestObject())==="component";},getFlexReference:function(m){if(m){if(m.getEntry("sap.ui5")){if(m.getEntry("sap.ui5").appVariantId){return m.getEntry("sap.ui5").appVariantId;}if(m.getEntry("sap.ui5").componentName){return a(m.getEntry("sap.ui5").componentName);}}if(m.getEntry("sap.app")&&m.getEntry("sap.app").id){return a(b.getAppIdFromManifest(m));}}L.warning("No Manifest received.");return"";},getAppIdFromManifest:function(m){if(m){var s=(m.getEntry)?m.getEntry("sap.app"):m["sap.app"];var A=s&&s.id;if(A===b.APP_ID_AT_DESIGN_TIME&&m.getComponentName){A=m.getComponentName();}return A;}throw new Error("No Manifest received, descriptor changes are not possible");},getODataServiceUriFromManifest:function(m){var s="";if(m){var S=(m.getEntry)?m.getEntry("sap.app"):m["sap.app"];if(S&&S.dataSources&&S.dataSources.mainService&&S.dataSources.mainService.uri){s=S.dataSources.mainService.uri;}}else{L.warning("No Manifest received.");}return s;},indexOfObject:function(A,o){var O=-1;A.some(function(c,i){var k;var K;if(!c){k=[];}else{k=Object.keys(c);}if(!o){K=[];}else{K=Object.keys(o);}var s=k.length===K.length;var d=s&&!k.some(function(e){return c[e]!==o[e];});if(d){O=i;}return d;});return O;},execPromiseQueueSequentially:function(p,t,A){if(p.length===0){if(A){return Promise.resolve();}return new b.FakePromise();}var P=p.shift();if(typeof P==="function"){try{var r=P();}catch(e){r=Promise.reject(e);}return r.then(function(){if(!A&&r instanceof Promise){A=true;}}).catch(function(e){var E="Error during execPromiseQueueSequentially processing occured";E+=e?": "+e.message:"";L.error(E);if(t){throw new Error(E);}}).then(function(){return this.execPromiseQueueSequentially(p,t,A);}.bind(this));}L.error("Changes could not be applied, promise not wrapped inside function.");return this.execPromiseQueueSequentially(p,t,A);},FakePromise:function(i,e,I){b.FakePromise.fakePromiseIdentifier="sap.ui.fl.Utils.FakePromise";this.vValue=i;this.vError=e;this.bContinueWithFakePromise=arguments.length<3||(I===b.FakePromise.fakePromiseIdentifier);var r=function(p,c){try{var R=c(p,b.FakePromise.fakePromiseIdentifier);if(R instanceof Promise||R instanceof b.FakePromise){return R;}return new b.FakePromise(R);}catch(E){var v=E;return new b.FakePromise(undefined,v);}};b.FakePromise.prototype.then=function(c){if(!this.bContinueWithFakePromise){return Promise.resolve(c(this.vValue));}if(!this.vError){return r(this.vValue,c);}return this;};b.FakePromise.prototype.catch=function(c){if(!this.bContinueWithFakePromise){return Promise.reject(c(this.vError));}if(this.vError){return r(this.vError,c);}return this;};if(this.vValue instanceof Promise||this.vValue instanceof b.FakePromise){return this.vValue;}},getChangeFromChangesMap:function(c,s){var r;Object.keys(c).forEach(function(d){c[d].some(function(o){if(o.getId()===s){r=o;return true;}});});return r;},requireAsync:function(m){return new Promise(function(r,R){sap.ui.require([m],function(o){r(o);},function(e){R(e);});});},normalizeReference:function(r){return r.replace(/(.Component)$/g,"");},handleUrlParameters:function(p,P,s){if(this.hasParameterAndValue(P,s)){if(p.startsWith("?")){p=p.substr(1,p.length);}var F=p.split("&").filter(function(c){return c!==P+"="+s;});p="";if(F.length>0){p="?"+F.toString();}}else{p+=(p.length>0?'&':'?')+P+"="+s;}return p;},hasParameterAndValue:function(p,P){return this.getParameter(p)===P;},getParameter:function(p){var o=this.getUshellContainer();if(o){var P=this.getParsedURLHash();return P.params&&P.params[p]&&P.params[p][0];}var c=U.fromQuery(document.location.search);if(!c){return false;}return c.get(p);}};return b;},true);
sap.ui.predefine('sap/ui/fl/Variant',["sap/ui/thirdparty/jquery","sap/ui/base/ManagedObject","sap/ui/fl/Layer","sap/ui/fl/Utils","sap/ui/fl/LayerUtils","sap/ui/fl/registry/Settings","sap/base/util/merge","sap/base/Log"],function(q,M,L,U,a,S,m,b){"use strict";
var V=M.extend("sap.ui.fl.Variant",{
constructor:function(f){M.apply(this);if(!q.isPlainObject(f)){b.error("Constructor : sap.ui.fl.Variant : oFile is not defined");}this._oDefinition=f;this._oOriginDefinition=m({},f);this._sRequest='';this._bUserDependent=(f.content.layer===L.USER);this._vRevertData=null;this.setState(V.states.NEW);},
metadata:{properties:{state:{type:"string"}}}
});
V.states={NEW:"NEW",PERSISTED:"NONE",DELETED:"DELETE",DIRTY:"UPDATE"};V.events={markForDeletion:"markForDeletion"};
V.prototype.setState=function(s){if(this._isValidState(s)){this.setProperty("state",s);}return this;};
V.prototype._isValidState=function(s){var c=false;Object.keys(V.states).some(function(k){if(V.states[k]===s){c=true;}return c;});if(!c){return false;}if((this.getState()===V.states.NEW)&&(s===V.states.DIRTY)){return false;}return true;};
V.prototype.isValid=function(){var i=true;if(typeof(this._oDefinition)!=="object"){i=false;}if(!this._oDefinition.content.fileType||this._oDefinition.content.fileType!=="ctrl_variant"){i=false;}if(!this._oDefinition.content.fileName){i=false;}if(!this._oDefinition.content.content.title){i=false;}if(!this._oDefinition.content.variantManagementReference){i=false;}if(!this._oDefinition.content.layer){i=false;}if(!this._oDefinition.content.originalLanguage){i=false;}return i;};
V.prototype.isVariant=function(){return true;};
V.prototype.getDefinitionWithChanges=function(){return this._oDefinition;};
V.prototype.getTitle=function(){if(this._oDefinition){return this._oDefinition.content.content.title;}};
V.prototype.getFileType=function(){if(this._oDefinition){return this._oDefinition.content.fileType;}};
V.prototype.getControlChanges=function(){return this._oDefinition.controlChanges;};
V.prototype.getOriginalLanguage=function(){if(this._oDefinition&&this._oDefinition.content.originalLanguage){return this._oDefinition.content.originalLanguage;}return"";};
V.prototype.getPackage=function(){return this._oDefinition.content.packageName;};
V.prototype.getNamespace=function(){return this._oDefinition.content.namespace;};
V.prototype.setNamespace=function(n){this._oDefinition.content.namespace=n;};
V.prototype.getId=function(){return this._oDefinition.content.fileName;};
V.prototype.getContent=function(){return this._oDefinition.content.content;};
V.prototype.setContent=function(c){this._oDefinition.content.content=c;this.setState(V.states.DIRTY);};
V.prototype.getVariantManagementReference=function(){return this._oDefinition.content.variantManagementReference;};
V.prototype.getVariantReference=function(){return this._oDefinition.content.variantReference;};
V.prototype.getOwnerId=function(){return this._oDefinition.content.support?this._oDefinition.content.support.user:"";};
V.prototype.getText=function(t){if(typeof(t)!=="string"){b.error("sap.ui.fl.Variant.getTexts : sTextId is not defined");}if(this._oDefinition.content.texts){if(this._oDefinition.content.texts[t]){return this._oDefinition.content.texts[t].value;}}return"";};
V.prototype.setText=function(t,n){if(typeof(t)!=="string"){b.error("sap.ui.fl.Variant.setTexts : sTextId is not defined");return;}if(this._oDefinition.content.texts){if(this._oDefinition.content.texts[t]){this._oDefinition.content.texts[t].value=n;this.setState(V.states.DIRTY);}}};
V.prototype.isReadOnly=function(){return this._isReadOnlyDueToLayer()||this._isReadOnlyWhenNotKeyUser();};
V.prototype._isReadOnlyWhenNotKeyUser=function(){if(this.isUserDependent()){return false;}var r=this.getDefinition().reference;if(!r){return true;}var s=S.getInstanceOrUndef();if(!s){return true;}return!s.isKeyUser();};
V.prototype._isReadOnlyDueToLayer=function(){var c;c=a.getCurrentLayer(this._bUserDependent);return(this._oDefinition.content.layer!==c);};
V.prototype._isReadOnlyDueToOriginalLanguage=function(){var c;var o;o=this.getOriginalLanguage();if(!o){return false;}c=U.getCurrentLanguage();return(c!==o);};
V.prototype.markForDeletion=function(){this.setState(V.states.DELETED);};
V.prototype.setRequest=function(r){if(typeof(r)!=="string"){b.error("sap.ui.fl.Variant.setRequest : sRequest is not defined");}this._sRequest=r;};
V.prototype.getRequest=function(){return this._sRequest;};
V.prototype.getLayer=function(){return this._oDefinition.content.layer;};
V.prototype.getComponent=function(){return this._oDefinition.content.reference;};
V.prototype.setComponent=function(c){this._oDefinition.content.reference=c;};
V.prototype.getCreation=function(){return this._oDefinition.content.creation;};
V.prototype.isUserDependent=function(){return(this._bUserDependent);};
V.prototype.getPendingAction=function(){return this.getState();};
V.prototype.getDefinition=function(){return this._oDefinition.content;};
V.prototype.setResponse=function(r){var R=JSON.stringify(r);if(R){this._oDefinition=JSON.parse(R);this._oOriginDefinition=JSON.parse(R);this.setState(V.states.PERSISTED);}};
V.prototype.getFullFileIdentifier=function(){var l=this.getLayer();var n=this.getNamespace();var f=this.getDefinition().content.fileName;var F=this.getDefinition().content.fileType;return l+"/"+n+"/"+f+"."+F;};
V.prototype.getRevertData=function(){return this._vRevertData;};
V.prototype.setRevertData=function(d){this._vRevertData=d;};
V.prototype.resetRevertData=function(){this.setRevertData(null);};
V.createInitialFileContent=function(p){if(!p){p={};}var f=p.content.fileName||U.createDefaultFileName();var n=p.content.namespace||U.createNamespace(p.content,"variants");var N={content:{fileName:f,fileType:"ctrl_variant",variantManagementReference:p.content.variantManagementReference,variantReference:p.content.variantReference||"",reference:p.content.reference||"",packageName:p.content.packageName||"",content:{title:p.content.content.title||""},self:n+f+"."+"ctrl_variant",layer:p.content.layer||a.getCurrentLayer(p.isUserDependent),texts:p.content.texts||{},namespace:n,creation:"",originalLanguage:U.getCurrentLanguage(),conditions:{},support:{generator:p.generator||"Change.createInitialFileContent",service:p.service||"",user:"",sapui5Version:sap.ui.version}},controlChanges:p.controlChanges||[],variantChanges:{}};return N;};
return V;},true);
sap.ui.predefine('sap/ui/fl/XmlPreprocessorImpl',["sap/ui/core/Component","sap/ui/fl/FlexControllerFactory","sap/ui/fl/Utils","sap/ui/fl/ChangePersistenceFactory","sap/base/Log"],function(C,F,U,a,L){"use strict";var X=function(){};
X.process=function(v,p){try{if(!p||p.sync){L.warning("Flexibility feature for applying changes on an XML view is only available for "+"asynchronous views; merge is be done later on the JS controls.");return(v);}p.viewId=p.id;var c=C.get(p.componentId);if(!c){L.warning("View is generated without a component. Flexibility features are not possible.");return Promise.resolve(v);}var A=U.getAppComponentForControl(c);if(!U.isApplication(A.getManifestObject())){return Promise.resolve(v);}var f=U.getComponentClassName(A);var o=F.create(f);return o.processXmlView(v,p).then(function(){L.debug("flex processing view "+p.id+" finished");return v;}).catch(function(){L.warning("Error happens when getting flex cache key! flexibility XML view preprocessing is skipped. "+"The processing will be done later on the JS controls.");return Promise.resolve(v);});}catch(e){var E="view "+p.id+": "+e;L.info(E);return Promise.resolve(v);}};
X.getCacheKey=function(p){var c=C.get(p.componentId);var A=U.getAppComponentForControl(c);if(U.isVariantByStartupParameter(A)){return Promise.resolve();}var f=U.getComponentClassName(A);var o=a.getChangePersistenceForComponent(f);return o.getCacheKey(A);};
return X;},true);
sap.ui.predefine('sap/ui/fl/apply/_internal/DelegateMediator',["sap/base/Log","sap/ui/fl/Utils","sap/ui/core/util/reflection/JsControlTreeModifier"],function(L,f,J){"use strict";var D={};D._mDefaultDelegateItems={};
function g(c,m){if(!m&&c.getModel){var M=c.getModel();if(!M){return undefined;}m=M.getMetadata().getName();}var d=D._mDefaultDelegateItems[m];if(d){return{name:d.name,payload:{},modelType:m,requiredLibraries:d.requiredLibraries};}}
function l(m,c,d){if(!d){return Promise.resolve();}return f.requireAsync(d.name).then(function(o){d.instance=o;return d;}).catch(function(e){L.error("Failed to load the delegate for the control "+m.getId(c)+"\n"+e.message);});}
function v(c,m){return new Promise(function(r,a){if(!c){a(new Error("The control parameter is missing"));}if(!m){a(new Error("The modifier parameter is missing"));}if(!c){a(new Error("The input control should be available"));}if(m===J&&(!c.isA||!c.isA("sap.ui.base.ManagedObject"))){a(new Error("The input control should be a managed object"));}return r();});}
D.getKnownDefaultDelegateLibraries=function(){return["sap.ui.comp"];};
D.isDelegateRegistered=function(m){return!!D._mDefaultDelegateItems[m];};
D.registerDefaultDelegate=function(p){if(!(p.modelType&&p.delegate)){throw new Error("'modelType' and 'delegate' properties are required for registration!");}if(D.isDelegateRegistered(p.modelType)){throw new Error("modelType "+p.modelType+"is already defined!");}D._mDefaultDelegateItems[p.modelType]={name:p.delegate,requiredLibraries:p.requiredLibraries};};
D.getDelegateForControl=function(c,m,M,s){return v(c,m).then(function(){return m.getFlexDelegate(c);}).then(function(i){if(i){return i;}return s&&g(c,M);}).then(l.bind(this,m,c));};
D.clear=function(){D._mDefaultDelegateItems={};};
return D;},false);
sap.ui.predefine('sap/ui/fl/apply/_internal/changes/FlexCustomData',["sap/ui/core/CustomData"],function(){"use strict";var F={};F.appliedChangesCustomDataKey="sap.ui.fl.appliedChanges";F.failedChangesCustomDataKeyJs="sap.ui.fl.failedChanges.js";F.failedChangesCustomDataKeyXml="sap.ui.fl.failedChanges.xml";F.notApplicableChangesCustomDataKey="sap.ui.fl.notApplicableChanges";
F.getAppliedCustomDataValue=function(c,C,m){var a=g(c,m,this._getCustomDataKey(C,F.appliedChangesCustomDataKey));return a.customDataValue;};
F.getParsedRevertDataFromCustomData=function(c,C,m){var s=this.getAppliedCustomDataValue(c,C,m);return s&&JSON.parse(s);};
F.hasChangeApplyFinishedCustomData=function(c,C,m){var a=m.getAggregation(c,"customData")||[];var b=[this._getCustomDataKey(C,F.appliedChangesCustomDataKey),this._getCustomDataKey(C,F.failedChangesCustomDataKeyJs),this._getCustomDataKey(C,F.notApplicableChangesCustomDataKey)];return a.some(function(o){var k=m.getProperty(o,"key");if(b.indexOf(k)>-1){return!!m.getProperty(o,"value");}});};
F.addAppliedCustomData=function(c,C,p,s){var a;var b=this._getCustomDataKey(C,F.appliedChangesCustomDataKey);if(s){a=JSON.stringify(C.getRevertData());}else{a="true";}w(c,b,a,p);};
F.addFailedCustomData=function(c,C,p,i){var s=this._getCustomDataKey(C,i);w(c,s,"true",p);};
F.destroyAppliedCustomData=function(c,C,m){var k=this._getCustomDataKey(C,F.appliedChangesCustomDataKey);var a=g(c,m,k);if(a.customData){m.destroy(a.customData);}};
F.getCustomDataIdentifier=function(s,e,x){if(s){return F.appliedChangesCustomDataKey;}if(!e){return F.notApplicableChangesCustomDataKey;}if(x){return F.failedChangesCustomDataKeyXml;}return F.failedChangesCustomDataKeyJs;};
F._getCustomDataKey=function(c,i){return i+"."+c.getId();};
function w(c,k,v,p){var C=g(c,p.modifier,k);if(!C.customData){p.modifier.createAndAddCustomData(c,k,v,p.appComponent);}else{p.modifier.setProperty(C.customData,"value",v);}}
function g(c,m,C){var a=m.getAggregation(c,"customData")||[];var r={};a.some(function(o){var k=m.getProperty(o,"key");if(k===C){r.customData=o;r.customDataValue=m.getProperty(o,"value");return true;}});return r;}
return F;},true);
sap.ui.predefine('sap/ui/fl/apply/_internal/changes/descriptor/Applier',[],function(){"use strict";var A={applyChanges:function(m,a,s){var u=Object.assign({},m);return s.registry().then(function(R){a.forEach(function(c){try{var C=R[c.getChangeType()];u=C.applyChange(u,c);if(!C.skipPostprocessing&&c.getTexts()){u=s.processTexts(u,c.getTexts());}}catch(e){s.handleError(e);}});return u;});}};return A;},true);
sap.ui.predefine('sap/ui/fl/apply/_internal/changes/descriptor/ApplyStrategyFactory',["sap/ui/fl/requireAsync","sap/ui/fl/apply/_internal/changes/descriptor/ApplyUtil","sap/base/Log"],function(r,A,L){"use strict";var B={registry:function(){return r("sap/ui/fl/apply/_internal/changes/descriptor/RegistrationBuild");},handleError:function(e){throw e;},processTexts:function(m,c){if(typeof m["sap.app"].i18n==="string"){m["sap.app"].i18n={bundleUrl:m["sap.app"].i18n};}if(!m["sap.app"].i18n.enhanceWith){m["sap.app"].i18n.enhanceWith=[];}var b=A.formatBundleName(m["sap.app"].id,c.i18n);var d=m["sap.app"].i18n.enhanceWith.some(function(e){return e.bundleName===b;});if(!d){m["sap.app"].i18n.enhanceWith.push({bundleName:b});}return m;}};var R={registry:function(){return r("sap/ui/fl/apply/_internal/changes/descriptor/Registration");},handleError:function(e){L.error(e);},processTexts:function(m,c){var M=JSON.stringify(m);Object.keys(c).forEach(function(t){if(c[t].value[""]){M=M.replace("{{"+t+"}}",c[t].value[""]);}else{L.error("Text change has to contain default language");}});return JSON.parse(M);}};var a={getBuildStrategy:function(){return Promise.resolve(B);},getRuntimeStrategy:function(){return Promise.resolve(R);}};return a;},true);
sap.ui.predefine('sap/ui/fl/apply/_internal/changes/descriptor/ApplyUtil',["sap/ui/thirdparty/URI"],function(U){"use strict";var A={formatBundleName:function(i,b){if(b.startsWith("/")){throw Error("Absolute paths are not supported");}var n=new U(i+"/"+b).normalize().path();return n.replace(/\//g,".").replace("..",".").replace(/.properties$/g,"");}};return A;},true);
sap.ui.predefine('sap/ui/fl/apply/_internal/changes/descriptor/Preprocessor',["sap/ui/fl/apply/_internal/changes/descriptor/Applier","sap/ui/fl/apply/_internal/changes/descriptor/ApplyStrategyFactory","sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/performance/Measurement","sap/ui/fl/Utils"],function(A,a,F,M,b,U){"use strict";var P={preprocessManifest:function(m,c){if(!U.isApplication(m,true)||!c.id){return Promise.resolve(m);}b.start("flexStateInitialize","Initialization of flex state",["sap.ui.fl"]);var C=c.componentData||{};var r=M.getFlexReference({manifest:m,componentData:C});if(!M.getChangeManifestFromAsyncHints(c.asyncHints)){F.initialize({componentData:C,asyncHints:c.asyncHints,rawManifest:m,componentId:c.id,reference:r,partialFlexState:true}).then(b.end.bind(undefined,"flexStateInitialize"));return Promise.resolve(m);}return F.initialize({componentData:C,asyncHints:c.asyncHints,rawManifest:m,componentId:c.id,reference:r,partialFlexState:true}).then(function(){b.end("flexStateInitialize");b.start("flexAppDescriptorMerger","Client side app descriptor merger",["sap.ui.fl"]);return a.getRuntimeStrategy();}).then(function(R){var d=F.getAppDescriptorChanges(r);return A.applyChanges(m,d,R);}).then(function(m){b.end("flexAppDescriptorMerger");return m;});}};return P;},true);
sap.ui.predefine('sap/ui/fl/apply/_internal/changes/descriptor/Registration',["sap/ui/fl/apply/_internal/changes/descriptor/ui5/AddLibrary","sap/ui/fl/apply/_internal/changes/descriptor/app/SetTitle"],function(A,S){"use strict";var R={appdescr_ui5_addLibraries:A,appdescr_app_setTitle:S};return R;},true);
sap.ui.predefine('sap/ui/fl/apply/_internal/changes/descriptor/RegistrationBuild',["sap/ui/fl/apply/_internal/changes/descriptor/Registration","sap/ui/fl/apply/_internal/changes/descriptor/app/ChangeDataSource","sap/ui/fl/apply/_internal/changes/descriptor/ui5/AddNewModelEnhanceWith","sap/ui/fl/apply/_internal/changes/descriptor/ui5/SetMinUI5Version","sap/ui/fl/apply/_internal/changes/descriptor/fiori/SetRegistrationIds","sap/ui/fl/apply/_internal/changes/descriptor/ui5/SetFlexExtensionPointEnabled"],function(R,C,A,S,a,b){"use strict";var c={appdescr_app_changeDataSource:C,appdescr_ui5_addNewModelEnhanceWith:A,appdescr_ui5_setMinUI5Version:S,appdescr_fiori_setRegistrationIds:a,appdescr_ui5_setFlexExtensionPointEnabled:b};var d=Object.assign({},R);return Object.assign(d,c);},true);
sap.ui.predefine('sap/ui/fl/apply/_internal/changes/descriptor/app/ChangeDataSource',["sap/base/util/ObjectPath"],function(O){"use strict";var C={applyChange:function(m,c){if(m["sap.app"].dataSources){var o=c.getContent();var d=m["sap.app"].dataSources[o.dataSourceId];if(d){var e=o.entityPropertyChange;if(Array.isArray(e)||e.operation!=="UPDATE"){throw new Error("Only operation == 'UPDATE' and entityPropertyChanges of type object are supported.");}var p=e.propertyPath.split("/");O.set(p,e.propertyValue,d);}}else{throw Error("No sap.app/dataSource found in manifest.json");}return m;}};return C;},true);
sap.ui.predefine('sap/ui/fl/apply/_internal/changes/descriptor/app/SetTitle',[],function(){"use strict";var S={applyChange:function(m){m["sap.app"].title="{{"+m["sap.app"].id+"_sap.app.title}}";return m;}};return S;},true);
sap.ui.predefine('sap/ui/fl/apply/_internal/changes/descriptor/fiori/SetRegistrationIds',["sap/base/util/ObjectPath"],function(O){"use strict";var S={applyChange:function(m,c){O.set(["sap.fiori","registrationIds"],c.getContent().registrationIds,m);return m;}};return S;},true);
sap.ui.predefine('sap/ui/fl/apply/_internal/changes/descriptor/ui5/AddLibrary',["sap/base/util/Version"],function(V){"use strict";
function _(m,c){var u={};if(c.minVersion){var M=new V(m.minVersion);u.minVersion=M.compareTo(c.minVersion)>=0?m.minVersion:c.minVersion;}if(c.lazy){u.lazy=m.lazy===c.lazy===true;}return u;}
var A={applyChange:function(m,c){if(!m["sap.ui5"]["dependencies"]["libs"]){m["sap.ui5"]["dependencies"]["libs"]={};}var M=m["sap.ui5"]["dependencies"]["libs"];var C=c.getContent().libraries;Object.keys(C).forEach(function(l){if(M[l]){M[l]=_(M[l],C[l]);}else{M[l]=C[l];}});return m;}};return A;},true);
sap.ui.predefine('sap/ui/fl/apply/_internal/changes/descriptor/ui5/AddNewModelEnhanceWith',["sap/ui/fl/apply/_internal/changes/descriptor/ApplyUtil","sap/base/util/ObjectPath"],function(A,O){"use strict";var a={applyChange:function(m,c){var M=c.getContent().modelId;var i=A.formatBundleName(m["sap.app"].id,c.getTexts().i18n);var o=m["sap.ui5"].models[M];if(o){if(o.type&&o.type==="sap.ui.model.resource.ResourceModel"){if(!(o.settings&&o.settings.enhanceWith)){O.set("settings.enhanceWith",[],o);}var e=o.settings.enhanceWith;e.push({bundleName:i});}}return m;},skipPostprocessing:true};return a;},true);
sap.ui.predefine('sap/ui/fl/apply/_internal/changes/descriptor/ui5/SetFlexExtensionPointEnabled',["sap/base/util/ObjectPath"],function(O){"use strict";var S={applyChange:function(m,c){if(!c.getContent().flexExtensionPointEnabled){throw new Error("No flexExtensionPointEnabled in change content provided");}O.set(["sap.ui5","flexExtensionPointEnabled"],c.getContent().flexExtensionPointEnabled,m);return m;}};return S;},true);
sap.ui.predefine('sap/ui/fl/apply/_internal/changes/descriptor/ui5/SetMinUI5Version',["sap/base/util/Version"],function(V){"use strict";var S={applyChange:function(m,c){var C=new V(m["sap.ui5"].dependencies.minUI5Version);if(C.compareTo(c.getContent().minUI5Version)<=0){m["sap.ui5"].dependencies.minUI5Version=c.getContent().minUI5Version;}return m;}};return S;},true);
sap.ui.predefine('sap/ui/fl/apply/_internal/extensionPoint/Processor',["sap/ui/fl/apply/_internal/changes/Applier","sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/apply/_internal/flexState/changes/ExtensionPointState","sap/ui/fl/Utils","sap/ui/core/util/reflection/JsControlTreeModifier","sap/base/util/merge"],function(A,F,E,U,J,m){"use strict";var P={oExtensionPointRegistry:undefined,oRegistryPromise:Promise.resolve(),registerExtensionPoint:function(e){P.oRegistryPromise=P.oRegistryPromise.then(function(){return new Promise(function(r,a){if(P.oExtensionPointRegistry){P.oExtensionPointRegistry.registerExtensionPoint(e);return r();}else if(sap.ui.getCore().getConfiguration().getDesignMode()){sap.ui.require(["sap/ui/fl/write/_internal/extensionPoint/Registry"],function(b){P.oExtensionPointRegistry=b;b.registerExtensionPoint(e);r();},function(o){a(o);});}else{r();}});});return P.oRegistryPromise;},createDefaultContent:function(e,c){if(c.length===0){return e.createDefault().then(function(C){C.forEach(function(n,i){J.insertAggregation(e.targetControl,e.aggregationName,n,e.index+i,e.view);});e.ready(C);return C;});}return Promise.resolve([]);},addDefaultContentToExtensionPointInfo:function(e,c){e.defaultContent=e.defaultContent.concat(c);},applyExtensionPoint:function(e){var a=U.getAppComponentForControl(e.targetControl);var p={};var b=m({defaultContent:[]},e);p.appComponent=a;p.modifier=J;p.viewId=e.view.getId();p.componentId=a.getId();var o=P.registerExtensionPoint(b).then(F.initialize.bind(F,p)).then(E.enhanceExtensionPointChanges.bind(E,p,b)).then(P.createDefaultContent.bind(this,e)).then(P.addDefaultContentToExtensionPointInfo.bind(this,b));A.addPreConditionForInitialChangeApplying(o);return o;}};return P;});
sap.ui.predefine('sap/ui/fl/apply/_internal/flexState/ManifestUtils',["sap/ui/fl/Utils"],function(U){"use strict";
function a(c){if(c&&c.indexOf(".Component")<0){c+=".Component";}return c;}
function g(A){var f;A.requests.some(function(o){if(o.name==="sap.ui.fl.changes"){f=o;}});return f;}
var M={getFlexReferenceForControl:function(c){var A=U.getAppComponentForControl(c);return M.getFlexReference({manifest:A.getManifest(),componentData:A.getComponentData()});},getFlexReference:function(p){var m=p.manifest;var c=p.componentData||{};if(c.startupParameters){if(Array.isArray(c.startupParameters["sap-app-id"])){return c.startupParameters["sap-app-id"][0];}}var s=m.getEntry?m.getEntry("sap.ui5"):m["sap.ui5"];if(s){if(s.appVariantId){return s.appVariantId;}if(s.componentName){return a(s.componentName);}}return a(U.getAppIdFromManifest(m));},getCacheKeyFromAsyncHints:function(A){if(A&&A.requests&&Array.isArray(A.requests)){var f=g(A);if(f){return f.cachebusterToken||"<NO CHANGES>";}}},getChangeManifestFromAsyncHints:function(A){if(A&&A.requests&&Array.isArray(A.requests)){var f=g(A);if(f){return false;}}return true;},getBaseComponentNameFromManifest:function(m){var s=m.getEntry?m.getEntry("sap.ui5"):m["sap.ui5"];return s&&s.componentName||U.getAppIdFromManifest(m);},isFlexExtensionPointHandlingEnabled:function(v){var A=U.getAppComponentForControl(v);return!!(A&&A.getManifestEntry("sap.ui5")&&A.getManifestEntry("sap.ui5").flexExtensionPointEnabled);}};return M;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/AddIFrame',["sap/ui/fl/changeHandler/common/revertAddedControls","sap/ui/fl/changeHandler/common/getTargetAggregationIndex","sap/ui/fl/changeHandler/common/createIFrame"],function(r,g,c){"use strict";var A={};
A.applyChange=function(C,o,p){var m=p.modifier;var a=C.getDefinition();var v=p.view;var s=a.content.targetAggregation;var b=m.findAggregation(o,s);if(!b){throw new Error("The given Aggregation is not available in the given control: "+m.getId(o));}var i=g(C,o,p);var I=c(C,p,a.content.selector);m.insertAggregation(o,s,I,i,v);C.setRevertData([m.getId(I)]);};
A.revertChange=r;
A.completeChangeContent=function(C,s,p){var o=C.getDefinition();var m=p.modifier;var a=p.appComponent;["targetAggregation","baseId","url"].forEach(function(R){if(!Object.prototype.hasOwnProperty.call(s.content,R)){throw new Error("Attribute missing from the change specific content '"+R+"'");}});o.content=Object.assign(o.content||{},s.content);o.content.selector=m.getSelector(o.content.baseId,a);};
A.getChangeVisualizationInfo=function(C){return{affectedControls:[C.getContent().selector]};};
return A;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/AddXML',["sap/ui/fl/changeHandler/BaseAddXml"],function(B){"use strict";var A={};
A.applyChange=function(c,C,p){var o=c.getDefinition();var m={aggregationName:o.content.targetAggregation,index:o.content.index};B.applyChange(c,C,p,m);return true;};
A.revertChange=B.revertChange;
A.completeChangeContent=function(c,s){var C=c.getDefinition();if(!C.content){C.content={};}if(s.targetAggregation){C.content.targetAggregation=s.targetAggregation;}else{B._throwMissingAttributeError("targetAggregation");}if(s.index!==undefined){C.content.index=s.index;}else{B._throwMissingAttributeError("index");}B.completeChangeContent(c,s,C);};
return A;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/AddXMLAtExtensionPoint',["sap/ui/fl/changeHandler/BaseAddXml"],function(B){"use strict";var A={};
A.applyChange=function(c,C,p){var v=p.view;var m=p.modifier;var s=c.getDefinition().selector;var e=(c.getExtensionPointInfo&&c.getExtensionPointInfo())||m.getExtensionPointInfo(s.name,v);if(!e){throw new Error("AddXMLAtExtensionPoint-Error: Either no Extension-Point found by name '"+(s&&s.name)+"' or multiple Extension-Points available with the given name in the view (view.id='"+(v&&m.getId(v))+"'). Multiple Extension-points with the same name in one view are not supported!");}(e.defaultContent||[]).forEach(function(a){if(a){m.destroy(a);}});e.defaultContent=[];var n=B.applyChange(c,C,p,e);if(e.ready){e.ready(n);}return true;};
A.revertChange=B.revertChange;
A.completeChangeContent=function(c,s){B.completeChangeContent(c,s);};
return A;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/Base',["sap/base/util/LoaderExtensions"],function(L){"use strict";var B={setTextInChange:function(c,k,t,T){if(!c.texts){c.texts={};}if(!c.texts[k]){c.texts[k]={};}c.texts[k].value=t;c.texts[k].type=T;},instantiateFragment:function(c,p){var m=c.getModuleName();if(!m){throw new Error("The module name of the fragment is not set. This should happen in the backend");}var M=p.modifier;var v=p.view;var f=L.loadResource(m,{dataType:"text"});var n=c.getProjectId();try{return M.instantiateFragment(f,n,v);}catch(e){throw new Error("The following XML Fragment could not be instantiated: "+f+" Reason: "+e.message);}},markAsNotApplicable:function(n,a){var r={message:n};if(!a){throw r;}return Promise.reject(r);}};return B;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/BaseAddViaDelegate',["sap/ui/fl/changeHandler/Base","sap/ui/fl/apply/api/DelegateMediatorAPI","sap/base/util/merge","sap/base/util/ObjectPath"],function(B,D,m,O){"use strict";
function i(f){return typeof f==="function";}
function g(c){if(c.modelType){return c.modelType;}else if(c.oDataServiceVersion){return"sap.ui.model.odata.v2.ODataModel";}}
var a={createAddViaDelegateChangeHandler:function(A){function b(n){return n+A.fieldSuffix;}function s(C){if(i(A.skipCreateLabel)){return!!A.skipCreateLabel({changeDefinition:C});}return!!A.skipCreateLabel;}function c(C){if(i(A.skipCreateLayout)){return!!A.skipCreateLayout({changeDefinition:C});}return!!A.skipCreateLayout;}function d(C,f,o){var h=m({},f);h.fieldSelector.id=b(h.fieldSelector.id);return o.createControlForProperty(h).then(function(S){if(s(C)){return S;}var n=f.modifier.getId(S.control);f.labelFor=n;return o.createLabel(f).then(function(l){return{label:l,control:S.control,valueHelp:S.valueHelp};});});}function e(C,f,p){var h=m({aggregationName:A.aggregationName,payload:f.payload||{}},p);var o=f.instance;return Promise.resolve().then(function(){if(i(o.createLayout)&&!c(C)){return o.createLayout(h);}}).then(function(l){if(O.get("control",l)){l.layoutControl=true;return l;}return d(C,h,o);});}return{applyChange:function(C,o,p){var f=C.getDefinition();var h=p.appComponent;var j=f.content;var F=j.newFieldSelector;var k={appComponent:p.appComponent,view:p.view,fieldSelector:F,bindingPath:j.bindingPath,modifier:p.modifier,element:o};if(p.modifier.bySelector(F,h)){return B.markAsNotApplicable("Control to be created already exists:"+(F.id||F),true);}var r={newFieldSelector:F};C.setRevertData(r);var M=g(j);return D.getDelegateForControl({control:o,modifier:p.modifier,modelType:M,supportsDefault:A.supportsDefault}).then(function(l){return e(f,l,k);}).then(function(I){var l=m({},{control:o,innerControls:I,change:C},p);A.addProperty(l);if(I.valueHelp){var v=p.modifier.getSelector(p.modifier.getId(I.valueHelp),h);r.valueHelpSelector=v;}});},revertChange:function(C,o,p){var f=p.appComponent;var M=p.modifier;var F=C.getRevertData().newFieldSelector;var v=C.getRevertData().valueHelpSelector;var n=M.bySelector(F,f);var P=C.getDependentControl(A.parentAlias,p)||o;M.removeAggregation(P,A.aggregationName,n);M.destroy(n);if(v){var V=M.bySelector(v,f);M.removeAggregation(P,"dependents",V);M.destroy(V);}var h=m({},{control:o,change:C},p);if(i(A.revertAdditionalControls)){A.revertAdditionalControls(h);}C.resetRevertData();return true;},completeChangeContent:function(C,S,p){var o=p.appComponent;var f=C.getDefinition();if(!f.content){f.content={};}if(S.parentId){if(i(A.mapParentIdIntoChange)){A.mapParentIdIntoChange(C,S,p);}else{C.addDependentControl(S.parentId,A.parentAlias,p);}}else{throw new Error("mSpecificChangeInfo.parentId attribute required");}if(S.bindingPath){f.content.bindingPath=S.bindingPath;}else{throw new Error("mSpecificChangeInfo.bindingPath attribute required");}if(S.newControlId){f.content.newFieldSelector=p.modifier.getSelector(S.newControlId,o);}else{throw new Error("mSpecificChangeInfo.newControlId attribute required");}if(S.index===undefined){throw new Error("mSpecificChangeInfo.targetIndex attribute required");}else{f.content.newFieldIndex=S.index;}if(S.oDataServiceVersion){f.content.oDataServiceVersion=S.oDataServiceVersion;}if(S.modelType&&A.supportsDefault){f.content.modelType=S.modelType;}},getChangeVisualizationInfo:function(C){var r=C.getRevertData();if(r){return{affectedControls:[r.labelSelector]};}return{affectedControls:[C.getContent().newFieldSelector]};}};}};return a;});
sap.ui.predefine('sap/ui/fl/changeHandler/BaseAddXml',["sap/ui/fl/changeHandler/Base","sap/base/util/LoaderExtensions","sap/ui/fl/changeHandler/common/revertAddedControls"],function(B,L,r){"use strict";var a={};
a.applyChange=function(c,C,p,m){var n=B.instantiateFragment(c,p);var M=p.modifier;var v=p.view;var A=m.aggregationName;var o=M.findAggregation(C,A);if(!o){a._destroyArrayOfControls(n);throw new Error("The given Aggregation is not available in the given control: "+M.getId(C));}var s=c.getModuleName();var f=L.loadResource(s,{dataType:"text"});var i=m.index;var R=[];n.forEach(function(N,I){if(!M.validateType(N,o,C,f,I)){a._destroyArrayOfControls(n);throw new Error("The content of the xml fragment does not match the type of the targetAggregation: "+o.type);}});n.forEach(function(N,I){M.insertAggregation(C,A,N,i+I,v);R.push({id:M.getId(N),aggregationName:A});});c.setRevertData(R);return n;};
a.revertChange=r;
a._throwMissingAttributeError=function(A){throw new Error("Attribute missing from the change specific content'"+A+"'");};
a._destroyArrayOfControls=function(c){c.forEach(function(C){if(C.destroy){C.destroy();}});};
a.completeChangeContent=function(c,s,C){if(!C){C=c.getDefinition();if(!C.content){C.content={};}}if(s.fragmentPath){C.content.fragmentPath=s.fragmentPath;}else{a._throwMissingAttributeError("fragmentPath");}var m=C.reference.replace(/\.Component/g,"").replace(/\./g,"/");m+="/changes/";m+=C.content.fragmentPath;c.setModuleName(m);};
return a;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/BaseRename',["sap/ui/fl/changeHandler/Base","sap/base/Log"],function(B,L){"use strict";var a={createRenameChangeHandler:function(r){r.changePropertyName=r.changePropertyName||"newText";return{applyChange:function(c,C,p){var m=p.modifier;var P=r.propertyName;var o=c.getDefinition();var t=o.texts[r.changePropertyName];var v=t.value;if(o.texts&&t&&typeof(v)==="string"){c.setRevertData(m.getPropertyBindingOrProperty(C,P));m.setPropertyBindingOrProperty(C,P,v);return true;}L.error("Change does not contain sufficient information to be applied: ["+o.layer+"]"+o.namespace+"/"+o.fileName+"."+o.fileType);},revertChange:function(c,C,p){var m=p.modifier;var P=r.propertyName;var o=c.getRevertData();if(o||o===""){m.setPropertyBindingOrProperty(C,P,o);c.resetRevertData();return true;}L.error("Change doesn't contain sufficient information to be reverted. Most Likely the Change didn't go through applyChange.");},completeChangeContent:function(c,s,p){var C=c.getDefinition();var b=r.changePropertyName;var t=r.translationTextType;var o=p.modifier.bySelector(c.getSelector(),p.appComponent);C.content.originalControlType=p.modifier.getControlType(o);if(typeof(s.value)==="string"){B.setTextInChange(C,b,s.value,t);}else{throw new Error("oSpecificChangeInfo.value attribute required");}},getCondenserInfo:function(c){return{affectedControl:c.getSelector(),classification:sap.ui.fl.condenser.Classification.LastOneWins,uniqueKey:r.propertyName||r.changePropertyName};}};}};return a;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/BaseTreeModifier',["sap/ui/core/util/reflection/BaseTreeModifier"],function(B){"use strict";return B;});
sap.ui.predefine('sap/ui/fl/changeHandler/HideControl',["sap/base/Log"],function(L){"use strict";var P="visible";var H={};
H.applyChange=function(c,C,p){c.setRevertData({originalValue:p.modifier.getVisible(C)});p.modifier.setVisible(C,false);return true;};
H.revertChange=function(c,C,p){var r=c.getRevertData();if(r){p.modifier.setVisible(C,r.originalValue);c.resetRevertData();}else{L.error("Attempt to revert an unapplied change.");return false;}return true;};
H.completeChangeContent=function(){};
H.getCondenserInfo=function(c){return{affectedControl:c.getSelector(),classification:sap.ui.fl.condenser.Classification.Reverse,uniqueKey:P};};
return H;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/JsControlTreeModifier',["sap/ui/core/util/reflection/JsControlTreeModifier"],function(J){"use strict";return J;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/MoveControls',["sap/base/Log"],function(L){"use strict";var M={};M.SOURCE_ALIAS="source";M.TARGET_ALIAS="target";M.MOVED_ELEMENTS_ALIAS="movedElements";
M._checkConditions=function(c,m,v,a){if(!c){throw new Error("No change instance");}var C=c.getContent();if(!C||!C.movedElements||C.movedElements.length===0){throw new Error("Change format invalid");}if(!C.source||!C.source.selector){throw new Error("No source supplied for move");}if(!C.target||!C.target.selector){throw new Error("No target supplied for move");}if(!m.bySelector(C.source.selector,a,v)){throw new Error("Move source parent not found");}if(!m.bySelector(C.target.selector,a,v)){throw new Error("Move target parent not found");}if(!C.source.selector.aggregation){throw new Error("No source aggregation supplied for move");}if(!C.target.selector.aggregation){throw new Error("No target aggregation supplied for move");}};
M._getElementControlOrThrowError=function(m,o,a,v){if(!m.selector&&!m.id){throw new Error("Change format invalid - moveElements element has no id attribute");}if(typeof m.targetIndex!=="number"){throw new Error("Missing targetIndex for element with id '"+m.selector.id+"' in movedElements supplied");}var c=o.bySelector(m.selector||m.id,a,v);if(!c){throw new Error("Control to move was not found. Id: '"+m.selector.id+"'");}return c;};
M._checkCompleteChangeContentConditions=function(s){if(!s.movedElements){throw new Error("mSpecificChangeInfo.movedElements attribute required");}if(s.movedElements.length===0){throw new Error("MovedElements array is empty");}s.movedElements.forEach(function(e){if(!e.id){throw new Error("MovedControls element has no id attribute");}if(typeof(e.sourceIndex)!=="number"){throw new Error("SourceIndex attribute at MovedElements element is no number");}if(typeof(e.targetIndex)!=="number"){throw new Error("TargetIndex attribute at MovedElements element is no number");}});};
M._getSpecificChangeInfo=function(m,s,a){delete s.source.publicAggregation;delete s.target.publicAggregation;var S=s.source.parent||m.bySelector(s.source.id,a);var t=s.target.parent||m.bySelector(s.target.id,a);var b=s.source.aggregation;var T=s.target.aggregation;var A={aggregation:s.source.aggregation,type:m.getControlType(S)};var c={aggregation:s.target.aggregation,type:m.getControlType(t)};var d={source:{id:S.getId(),aggregation:b,type:A.type,selector:m.getSelector(s.source.id,a,A)},target:{id:t.getId(),aggregation:T,type:c.type,selector:m.getSelector(s.target.id,a,c)},movedElements:s.movedElements};return d;};
M.applyChange=function(c,r,p){var m=p.modifier;var v=p.view;var a=p.appComponent;this._checkConditions(c,m,v,a);var C=c.getContent();var s=p.sourceAggregation||C.source.selector.aggregation;var t=p.targetAggregation||C.target.selector.aggregation;var S=m.bySelector(C.source.selector,a,v);var T=m.bySelector(C.target.selector,a,v);var R=[];C.movedElements.forEach(function(b){var o=this._getElementControlOrThrowError(b,m,a,v);var i=m.findIndexInParentAggregation(o);var I=b.targetIndex;if(i>-1){if(i===I){i=b.sourceIndex;}else{s=p.sourceAggregation||m.getParentAggregationName(o,S);S=m.getParent(o);}R.unshift({index:i,aggregation:s,sourceParent:m.getSelector(S,a)});}m.removeAggregation(S,s,o);m.insertAggregation(T,t,o,I,v);},this);c.setRevertData(R);return true;};
M.revertChange=function(c,r,p){var m=p.modifier;var v=p.view;var a=p.appComponent;this._checkConditions(c,m,v,a);var C=c.getContent();var s=m.bySelector(C.source.selector,a,v);var S=C.source.selector.aggregation;var t=m.bySelector(C.target.selector,a,v);var T=C.target.selector.aggregation;var R=c.getRevertData();c.getContent().movedElements.reverse();C.movedElements.forEach(function(b,e){var o=this._getElementControlOrThrowError(b,m,a,v);if(!o){L.warning("Element to move not found");return;}var i=b.sourceIndex;if(R){var d=R[e];S=d.aggregation;i=d.index;s=m.bySelector(d.sourceParent,a,v);}m.removeAggregation(t,T,o);m.insertAggregation(s,S,o,i,v);},this);c.resetRevertData();return true;};
M.completeChangeContent=function(c,s,p){this._checkCompleteChangeContentConditions(s);var m=p.modifier;var a=p.appComponent;var C=c.getDefinition();s=this._getSpecificChangeInfo(m,s,a);C.content={movedElements:[],source:{selector:s.source.selector},target:{selector:s.target.selector}};s.movedElements.forEach(function(e){var E=e.element||m.bySelector(e.id,a);C.content.movedElements.push({selector:m.getSelector(E,a),sourceIndex:e.sourceIndex,targetIndex:e.targetIndex});});c.addDependentControl(s.source.id,M.SOURCE_ALIAS,p);c.addDependentControl(s.target.id,M.TARGET_ALIAS,p);c.addDependentControl(s.movedElements.map(function(e){return e.id;}),M.MOVED_ELEMENTS_ALIAS,p);};
M.getCondenserInfo=function(c){var C=c.getContent();var r=c.getRevertData()[0];return{affectedControl:C.movedElements[0].selector,classification:sap.ui.fl.condenser.Classification.Move,sourceContainer:r.sourceParent,targetContainer:C.target.selector,sourceIndex:r.index,sourceAggregation:r.aggregation,targetAggregation:C.target.selector.aggregation,setTargetIndex:function(c,n){c.getContent().movedElements[0].targetIndex=n;},getTargetIndex:function(c){return c.getContent().movedElements[0].targetIndex;}};};
M.getChangeVisualizationInfo=function(c){var C=c.getContent();return{affectedControls:[C.movedElements[0].selector],dependentControls:[C.source.selector]};};
return M;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/MoveElements',["sap/base/Log"],function(L){"use strict";var M={};M.CHANGE_TYPE="moveElements";
M.applyChange=function(c,s,p){function a(c,m,v,A){if(!c){throw new Error("No change instance");}var C=c.getContent();if(!C||!C.movedElements||C.movedElements.length===0){throw new Error("Change format invalid");}if(!c.getSelector().aggregation){throw new Error("No source aggregation supplied via selector for move");}if(!C.target||!C.target.selector){throw new Error("No target supplied for move");}if(!m.bySelector(C.target.selector,A,v)){throw new Error("Move target parent not found");}if(!C.target.selector.aggregation){throw new Error("No target aggregation supplied for move");}}function g(b,m,A,v){if(!b.selector&&!b.id){throw new Error("Change format invalid - moveElements element has no id attribute");}if(typeof b.targetIndex!=="number"){throw new Error("Missing targetIndex for element with id '"+b.selector.id+"' in movedElements supplied");}return m.bySelector(b.selector||b.id,A,v);}var m=p.modifier;var v=p.view;var A=p.appComponent;a(c,m,v,A);var C=c.getContent();var t=m.bySelector(C.target.selector,A,v);var S=c.getSelector().aggregation;var T=C.target.selector.aggregation;C.movedElements.forEach(function(b){var o=g(b,m,A,v);if(!o){L.warning("Element to move not found");return;}m.removeAggregation(s,S,o);m.insertAggregation(t,T,o,b.targetIndex,v);});return true;};
M.completeChangeContent=function(){throw new Error('Using deprecated change handler. Please consider of using \'MoveControls\' instead');};
M.getSpecificChangeInfo=function(m,s){var S=s.source.parent||m.bySelector(s.source.id);var t=s.target.parent||m.bySelector(s.target.id);var a=s.source.aggregation;var T=s.target.aggregation;var b={source:{id:S.getId(),aggregation:a,type:m.getControlType(S)},target:{id:t.getId(),aggregation:T,type:m.getControlType(t)},movedElements:s.movedElements};return b;};
return M;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/PropertyBindingChange',["sap/base/Log"],function(L){"use strict";var P={};
P.applyChange=function(c,C,p){var d=c.getDefinition();var s=d.content.property;var v=d.content.newBinding;var m=p.modifier;var o=m.getPropertyBindingOrProperty(C,s);c.setRevertData({originalValue:o});m.setPropertyBinding(C,s,v);};
P.revertChange=function(c,C,p){var r=c.getRevertData();if(r){var d=c.getDefinition();var s=d.content.property;var v=r.originalValue;var m=p.modifier;m.setPropertyBindingOrProperty(C,s,v);c.resetRevertData();}else{L.error("Attempt to revert an unapplied change.");return false;}return true;};
P.completeChangeContent=function(c,s){var C=c.getDefinition();if(!s.content){throw new Error("oSpecificChangeInfo attribute required");}C.content=s.content;};
P.getCondenserInfo=function(c){return{affectedControl:c.getSelector(),classification:sap.ui.fl.condenser.Classification.LastOneWins,uniqueKey:c.getContent().property};};
return P;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/PropertyChange',["sap/ui/thirdparty/jquery","sap/ui/fl/Utils","sap/base/Log"],function(q,F,L){"use strict";var P={};
function i(p){return F.isBinding(p)||q.isPlainObject(p);}
function c(C,p,v,m){try{if(i(v)){m.setPropertyBinding(C,p,v);}else{m.setProperty(C,p,v);}}catch(e){throw new Error("Applying property changes failed: "+e);}}
P.applyChange=function(C,o,p){var d=C.getDefinition();var s=d.content.property;var v=d.content.newValue;var m=p.modifier;C.setRevertData({originalValue:m.getPropertyBindingOrProperty(o,s)});c(o,s,v,m);};
P.revertChange=function(C,o,p){var r=C.getRevertData();if(r){var d=C.getDefinition();var s=d.content.property;var v=r.originalValue;var m=p.modifier;c(o,s,v,m);C.resetRevertData();}else{L.error("Attempt to revert an unapplied change.");return false;}return true;};
P.completeChangeContent=function(C,s){var o=C.getDefinition();if(!s.content){throw new Error("oSpecificChangeInfo attribute required");}o.content=s.content;};
P.getCondenserInfo=function(C){return{affectedControl:C.getSelector(),classification:sap.ui.fl.condenser.Classification.LastOneWins,uniqueKey:C.getContent().property};};
return P;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/StashControl',["sap/base/Log"],function(L){"use strict";var S={};
S.applyChange=function(c,C,p){var s=p.modifier.getStashed(C);var o=p.modifier.findIndexInParentAggregation(C);this.setChangeRevertData(c,s,o);p.modifier.setStashed(C,true);return true;};
S.revertChange=function(c,C,p){var r=c.getRevertData();if(r){var u=p.modifier.setStashed(C,r.originalValue,p.appComponent);if(u){var U=p.modifier.findIndexInParentAggregation((u));if(U!==r.originalIndex){var P=p.modifier.getParent(u);var a=p.modifier.getParentAggregationName(u);p.modifier.removeAggregation(P,a,u);p.modifier.insertAggregation(P,a,u,r.originalIndex);}}c.resetRevertData();}else{L.error("Attempt to revert an unapplied change.");return false;}return true;};
S.completeChangeContent=function(){};
S.setChangeRevertData=function(c,v,o){c.setRevertData({originalValue:v,originalIndex:o});};
S.getCondenserInfo=function(c){return{affectedControl:c.getSelector(),classification:sap.ui.fl.condenser.Classification.Reverse,uniqueKey:"stashed"};};
return S;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/UnhideControl',["sap/base/Log"],function(L){"use strict";var P="visible";var U={};
U.applyChange=function(c,C,p){c.setRevertData({originalValue:p.modifier.getProperty(C,P)});p.modifier.setVisible(C,true);return true;};
U.revertChange=function(c,C,p){var r=c.getRevertData();if(r){p.modifier.setVisible(C,r.originalValue);c.resetRevertData();}else{L.error("Attempt to revert an unapplied change.");return false;}return true;};
U.completeChangeContent=function(){};
U.getCondenserInfo=function(c){return{affectedControl:c.getSelector(),classification:sap.ui.fl.condenser.Classification.Reverse,uniqueKey:P};};
return U;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/UnstashControl',["sap/base/Log"],function(L){"use strict";var U={};
U.applyChange=function(c,C,p){var m=c.getContent();var M=p.modifier;var s=false;c.setRevertData({originalValue:p.modifier.getStashed(C)});var u=M.setStashed(C,s,p.appComponent)||C;if(m.parentAggregationName){var t=m.parentAggregationName;var T=M.getParent(u);M.removeAggregation(T,t,u);M.insertAggregation(T,t,u,m.index,p.view);}return u;};
U.revertChange=function(c,C,p){var r=c.getRevertData();if(r){p.modifier.setStashed(C,r.originalValue);c.resetRevertData();}else{L.error("Attempt to revert an unapplied change.");return false;}return true;};
U.completeChangeContent=function(c,s){var C=c.getDefinition();if(s.content){C.content=s.content;}};
U.getCondenserInfo=function(c){return{affectedControl:c.getSelector(),classification:sap.ui.fl.condenser.Classification.Reverse,uniqueKey:"stashed"};};
return U;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/UpdateIFrame',["sap/base/util/extend"],function(e){"use strict";var U={};var u=["width","height","url"];
function g(m,i){var s={};u.forEach(function(p){var v=m.getProperty(i,p);if(v!==undefined){s[p]=v;}});return s;}
function a(m,i,s){var f=e({_settings:s},s);m.applySettings(i,f);}
U.applyChange=function(c,C,p){var m=p.modifier;var o=c.getDefinition();var b=m.getControlMetadata(C);if(b.getName()!=="sap.ui.fl.util.IFrame"){throw new Error("UpdateIFrame only for sap.ui.fl.util.IFrame");}c.setRevertData({originalSettings:g(m,C)});a(m,C,o.settings);};
U.revertChange=function(c,C,p){var r=c.getRevertData();if(r){a(p.modifier,C,r.originalSettings);c.resetRevertData();}else{throw new Error("Attempt to revert an unapplied change.");}};
U.completeChangeContent=function(c,s){var C=c.getDefinition();if(!s.content||!Object.keys(s.content).some(function(p){return u.indexOf(p)!==-1;})){throw new Error("oSpecificChangeInfo attribute required");}C.settings=s.content;};
return U;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/XmlTreeModifier',["sap/ui/core/util/reflection/XmlTreeModifier"],function(X){"use strict";return X;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/common/createIFrame',["sap/ui/fl/util/IFrame"],function(){"use strict";return function(c,p,s){var m=p.modifier;var C=c.getDefinition();var v=p.view;var o=p.appComponent;var i={_settings:{}};["url","width","height"].forEach(function(a){var V=C.content[a];i[a]=V;i._settings[a]=V;});var I=m.createControl("sap.ui.fl.util.IFrame",o,v,s,i,false);return I;};});
sap.ui.predefine('sap/ui/fl/changeHandler/common/getTargetAggregationIndex',[],function(){"use strict";return function(c,C,p){var m=p.modifier;var o=c.getDefinition();var a=o.content.targetAggregation;var i=o.content.index;if(i===undefined){var A=m.getAggregation(C,a);i=A.length;}return i;};});
sap.ui.predefine('sap/ui/fl/changeHandler/common/revertAddedControls',["sap/ui/fl/Utils"],function(U){"use strict";return function(c,C,p){var m=p.modifier;var o=c.getDefinition();var a=o.content.targetAggregation;var v=p.view||U.getViewForControl(C);var A=p.appComponent;var r=c.getRevertData()||[];var b=r.map(function(R){var s;if(typeof R==="string"){s=R;}else{s=R.id;a=a||R.aggregationName;}return m.bySelector(s,A,v)||v&&v.createId&&m.bySelector(v.createId(s));});b.forEach(function(d){m.removeAggregation(C,a,d);if(d.destroy){d.destroy();}});c.resetRevertData();return true;};});
sap.ui.predefine('sap/ui/fl/codeExt/CodeExtManager',["sap/ui/fl/write/_internal/Storage","sap/ui/fl/Change"],function(S,C){"use strict";var a;a={createOrUpdateCodeExtChange:function(p,o){if(!p.content||!p.content.codeRef){throw new Error("no code reference passed for the code extension change");}if(!p.selector||!p.selector.id){throw new Error("no controller name passed for the code extension change");}if(!p.reference){throw new Error("no reference passed for the code extension change");}p.changeType=p.changeType||"codeExt";var c=C.createInitialFileContent(p);return S.write({layer:c.layer,transport:o.transportId,flexObjects:[c]});},createCodeExtChanges:function(c,o){c=c||[];if(c.length===0){return Promise.resolve();}var p=[];c.forEach(function(b){b.changeType=b.changeType||"codeExt";b.packageName=o.packageName;b.content={codeRef:o.codeRef};p.push(C.createInitialFileContent(b));});return S.write({layer:p[0].layer,transport:o.transportId,flexObjects:p});},deleteCodeExtChange:function(c,o){if(c.changeType!=="codeExt"||c.fileType!=="change"){throw new Error("the change is not of type 'code extension'");}if(!c.fileName){throw new Error("the extension does not contains a file name");}if(c.namespace===undefined){throw new Error("the extension does not contains a namespace");}return S.remove({layer:c.layer,transport:o.transportId,flexObject:c});}};return a;},true);
sap.ui.predefine('sap/ui/fl/descriptorRelated/api/DescriptorChangeFactory',["sap/ui/fl/ChangePersistenceFactory","sap/ui/fl/Change","sap/ui/fl/Utils","sap/base/util/merge"],function(C,a,F,b){"use strict";var D=function(m,i){this._mChangeFile=m;this._mChangeFile.packageName='';this._oInlineChange=i;};
D.prototype.submit=function(){this.store();var o=this._getChangePersistence(this._mChangeFile.reference);return o.saveDirtyChanges();};
D.prototype.store=function(){var s=this._mChangeFile.reference;var o=this._getChangePersistence(s);var d=this._getChangeToSubmit();o.addChange(d);return d;};
D.prototype._getChangePersistence=function(s){return C.getChangePersistenceForComponent(s);};
D.prototype._getChangeToSubmit=function(){var o=new a(this._getMap());return o;};
D.prototype._getMap=function(){var i=this._oInlineChange.getMap();this._mChangeFile.content=i.content;this._mChangeFile.texts=i.texts;return this._mChangeFile;};
D.prototype.getJson=function(){return b({},this._getMap());};
var c=function(){};
c.prototype.createNew=function(r,i,l,A,t){var s=function(_,I){if(_["setHostingIdForTextKey"]){_.setHostingIdForTextKey(I);}};s(i,r);var p={};p.changeType=i._getChangeType();p.componentName=r;p.reference=r;p.generator=t;p.layer=l||'CUSTOMER';var m=a.createInitialFileContent(p);return Promise.resolve(new D(m,i));};
return c;},true);
sap.ui.predefine('sap/ui/fl/descriptorRelated/api/DescriptorInlineChangeFactory',["sap/ui/fl/write/_internal/appVariant/AppVariantInlineChangeFactory","sap/ui/fl/apply/_internal/appVariant/DescriptorChangeTypes","sap/base/util/merge"],function(A,D,m){"use strict";
function _(c,p,t){var P=m({},{changeType:c},{content:p});if(t){P.texts=t;}return P;}
var a={};
a.getDescriptorChangeTypes=function(){return D.getChangeTypes();};
a.getCondensableDescriptorChangeTypes=function(){return D.getCondensableChangeTypes();};
a.createNew=function(c,p,t){var P=_(c,p,t);return A.createNew(P);};
a.createDescriptorInlineChange=function(d,p,t){var P=_(d,p,t);return A.createDescriptorInlineChange(P);};
a.create_ovp_addNewCard=function(p,t){var P=_("appdescr_ovp_addNewCard",p,t);return A.create_ovp_addNewCard(P);};
a.create_ovp_removeCard=function(p){var P=_("appdescr_ovp_removeCard",p);return A.create_ovp_removeCard(P);};
a.create_ovp_changeCard=function(p,t){var P=_("appdescr_ovp_changeCard",p,t);return A.create_ovp_changeCard(P);};
a.create_app_addNewInbound=function(p,t){var P=_("appdescr_app_addNewInbound",p,t);return A.create_app_addNewInbound(P);};
a.create_app_removeInbound=function(p){var P=_("appdescr_app_removeInbound",p);return A.create_app_removeInbound(P);};
a.create_app_removeAllInboundsExceptOne=function(p){var P=_("appdescr_app_removeAllInboundsExceptOne",p);return A.create_app_removeAllInboundsExceptOne(P);};
a.create_app_changeInbound=function(p,t){var P=_("appdescr_app_changeInbound",p,t);return A.create_app_changeInbound(P);};
a.create_app_addNewOutbound=function(p){var P=_("appdescr_app_addNewOutbound",p);return A.create_app_addNewOutbound(P);};
a.create_app_removeOutbound=function(p){var P=_("appdescr_app_removeOutbound",p);return A.create_app_removeOutbound(P);};
a.create_app_changeOutbound=function(p){var P=_("appdescr_app_changeOutbound",p);return A.create_app_changeOutbound(P);};
a.create_app_addNewDataSource=function(p){var P=_("appdescr_app_addNewDataSource",p);return A.create_app_addNewDataSource(P);};
a.create_app_removeDataSource=function(p){var P=_("appdescr_app_removeDataSource",p);return A.create_app_removeDataSource(P);};
a.create_app_changeDataSource=function(p){var P=_("appdescr_app_changeDataSource",p);return A.create_app_changeDataSource(P);};
var T={BEGINNING:"BEGINNING",END:"END"};
a.create_app_addAnnotationsToOData=function(p){var P=_("appdescr_app_addAnnotationsToOData",p);return A.create_app_addAnnotationsToOData(P);};
a.create_app_setTitle=function(p,t){if(!t){t={"":p};p={};}var P=_("appdescr_app_setTitle",p,t);return A.create_app_setTitle(P);};
a.create_app_setSubTitle=function(p,t){if(!t){t={"":p};p={};}var P=_("appdescr_app_setSubTitle",p,t);return A.create_app_setSubTitle(P);};
a.create_app_setShortTitle=function(p,t){if(!t){t={"":p};p={};}var P=_("appdescr_app_setShortTitle",p,t);return A.create_app_setShortTitle(P);};
a.create_app_setDescription=function(p,t){if(!t){t={"":p};p={};}var P=_("appdescr_app_setDescription",p,t);return A.create_app_setDescription(P);};
a.create_app_setInfo=function(p,t){if(!t){t={"":p};p={};}var P=_("appdescr_app_setInfo",p,t);return A.create_app_setInfo(P);};
a.create_app_setAch=function(p){var P=_("appdescr_app_setAch",p);return A.create_app_setAch(P);};
a.create_app_setDestination=function(p){var P=_("appdescr_app_setDestination",p);return A.create_app_setDestination(P);};
a.create_app_setKeywords=function(p,t){var P=_("appdescr_app_setKeywords",p,t);return A.create_app_setKeywords(P);};
a.create_app_addTechnicalAttributes=function(p){var P=_("appdescr_app_addTechnicalAttributes",p);return A.create_app_addTechnicalAttributes(P);};
a.create_app_removeTechnicalAttributes=function(p){var P=_("appdescr_app_removeTechnicalAttributes",p);return A.create_app_removeTechnicalAttributes(P);};
a.create_app_addCdsViews=function(p){var P=_("appdescr_app_addCdsViews",p);return A.create_app_addCdsViews(P);};
a.create_app_removeCdsViews=function(p){var P=_("appdescr_app_removeCdsViews",p);return A.create_app_removeCdsViews(P);};
a.create_flp_setConfig=function(p){var P=_("appdescr_flp_setConfig",p);return A.create_flp_setConfig(P);};
a.create_ui5_addNewModel=function(p){var P=_("appdescr_ui5_addNewModel",p);return A.create_ui5_addNewModel(P);};
a.create_ui5_removeModel=function(p){var P=_("appdescr_ui5_removeModel",p);return A.create_ui5_removeModel(P);};
a.create_ui5_addNewModelEnhanceWith=function(p,t){var P=_("appdescr_ui5_addNewModelEnhanceWith",p,t);return A.create_ui5_addNewModelEnhanceWith(P);};
a.create_ui5_replaceComponentUsage=function(p){var P=_("appdescr_ui5_replaceComponentUsage",p);return A.create_ui5_replaceComponentUsage(P);};
a.create_ui5_addLibraries=function(p){var P=_("appdescr_ui5_addLibraries",p);return A.create_ui5_addLibraries(P);};
a.create_ui5_setMinUI5Version=function(p){var P=_("appdescr_ui5_setMinUI5Version",p);return A.create_ui5_setMinUI5Version(P);};
a.create_smb_addNamespace=function(p){var P=_("appdescr_smb_addNamespace",p);return A.create_smb_addNamespace(P);};
a.create_smb_changeNamespace=function(p){var P=_("appdescr_smb_changeNamespace",p);return A.create_smb_changeNamespace(P);};
a.create_ui_generic_app_setMainPage=function(p,t){var P=_("appdescr_ui_generic_app_setMainPage",p,t);return A.create_ui_generic_app_setMainPage(P);};
a.create_ui_setIcon=function(p){var P=_("appdescr_ui_setIcon",p);return A.create_ui_setIcon(P);};
a.create_ui_setDeviceTypes=function(p){var P=_("appdescr_ui_setDeviceTypes",p);return A.create_ui_setDeviceTypes(P);};
a.create_url_setUri=function(p){var P=_("appdescr_url_setUri",p);return A.create_url_setUri(P);};
a.create_fiori_setRegistrationIds=function(p){var P=_("appdescr_fiori_setRegistrationIds",p);return A.create_fiori_setRegistrationIds(P);};
a.create_ui5_setFlexExtensionPointEnabled=function(p){var P=_("appdescr_ui5_setFlexExtensionPointEnabled",p);return A.create_ui5_setFlexExtensionPointEnabled(P);};
return a;},true);
sap.ui.predefine('sap/ui/fl/descriptorRelated/api/DescriptorVariantFactory',["sap/ui/fl/write/_internal/appVariant/AppVariantFactory"],function(A){"use strict";var D={};
D.createNew=function(p){return D.createAppVariant(p);};
D.createAppVariant=function(p){return A.prepareCreate(p);};
D.createForExisting=function(i){return A.prepareUpdate({id:i});};
D.createDeletion=function(i){return A.prepareDelete({id:i});};
return D;},true);
sap.ui.predefine('sap/ui/fl/descriptorRelated/internal/Utils',[],function(){"use strict";var U=function(){};
U.prototype.getNameAndNameSpace=function(i,r){return{fileName:"manifest",namespace:"apps/"+r+"/appVariants/"+i+"/"};};
U.prototype.checkEntityPropertyChange=function(p){this.checkParameterAndType(p,"entityPropertyChange","object");if(p.entityPropertyChange instanceof Array){for(var i=0;i<p.entityPropertyChange.length;i++){var c=p.entityPropertyChange[i];this.checkEntityPropertyChangeContent(c);}}else if(p.entityPropertyChange instanceof Object){this.checkEntityPropertyChangeContent(p.entityPropertyChange);}};
U.prototype.checkEntityPropertyChangeContent=function(c){this.checkParameterAndType(c,"propertyPath","string");this.checkParameterAndType(c,"operation","string");if(['INSERT','UPDATE','UPSERT','DELETE'].indexOf(c.operation)===-1){throw new Error("Parameter \"entityPropertyChange.operation\" needs to be one of 'INSERT', 'UPDATE', 'UPSERT', 'DELETE'");}if(c.propertyValue===undefined&&c.operation!=='DELETE'){throw new Error("No parameter \"entityPropertyChange.propertyValue\" provided");}};
U.prototype.checkParameterAndType=function(p,P,t){if(t==="array"){if(p===undefined||p[P]===undefined||!Array.isArray(p[P])){throw new Error("No parameter \""+P+"\" of type "+t+" provided");}}else if(p===undefined||p[P]===undefined||typeof p[P]!==t){throw new Error("No parameter \""+P+"\" of type "+t+" provided");}};
U.prototype.checkTexts=function(t){if(t!==undefined&&typeof t!=="object"){throw new Error("Wrong format for provided \"texts\" parameter");}};
U.prototype.checkTransportRequest=function(t){if(!/^[A-Z0-9]{1,20}$/.test(t)&&t!=='ATO_NOTIFICATION'){throw new Error("Wrong format for provided \"sTransportRequest\" parameter");}};
U.prototype.checkPackage=function(p){if(!/^[A-Z0-9/_]{1,30}$/.test(p)&&p!=="$TMP"){throw new Error("Wrong format for provided \"sPackage\" parameter");}};
return new U();},true);
sap.ui.predefine('sap/ui/fl/fieldExt/Access',["sap/ui/util/Storage","sap/ui/fl/Utils","sap/base/security/encodeURLParameters","sap/ui/thirdparty/jquery"],function(S,U,a,q){"use strict";var A={};A._mServiceType={v2:"v2",v4:"v4"};A._sODataV4ResourcePathPrefix="sap/opu/odata4/";A._sStorageKey="sap.ui.fl.fieldExt.Access";A._iValidityPeriod=1*7*24*60*60*1000;
A.getBusinessContexts=function(s,e,E){var m=this._getEntityInfo(e,E);var b=this._parseServiceUri(s);var B=this._buildBusinessContextRetrievalUri(b,m);var p=this._executeAjaxCall(B,b,m);return p;};
A.isServiceOutdated=function(s){if(!this._isSystemInfoAvailable()){return false;}var m=this._getServiceItem(this._createServiceItem(s));if(m){if(this._isServiceExpired(m)){this.setServiceValid(s);return false;}return true;}return false;};
A.setServiceValid=function(s){if(this._isSystemInfoAvailable()){var d=this._getDataFromLocalStorage();delete d[this._createServiceItem(s).serviceKey];this._setDataToLocalStorage(d);}};
A.setServiceInvalid=function(s){if(this._isSystemInfoAvailable()){var d=this._getDataFromLocalStorage();var i=this._createServiceItem(s);d[i.serviceKey]=i;this._setDataToLocalStorage(d);}};
A._getEntityInfo=function(e,E){var o={entityTypeName:e||"",entitySetName:E||""};if(((o.entitySetName.length===0)&&(o.entityTypeName.length===0))||(!(o.entitySetName.length===0)&&!(o.entityTypeName.length===0))){throw new Error("sap.ui.fl.fieldExt.Access._getEntityInfo()"+"Inconsistent input parameters EntityType: "+o.entityTypeName+" EntitySet: "+o.entitySetName);}return o;};
A._parseServiceUri=function(s){if(s.toLowerCase().indexOf(this._sODataV4ResourcePathPrefix)!==-1){return this._parseV4ServiceUri(s);}return this._parseV2ServiceUri(s);};
A._parseV2ServiceUri=function(s){var r=/.*sap\/opu\/odata\/([^\/]+)\/([^\/]+)/i;var R=/([^;]+);v=(\d{1,4})/i;var o="sap/opu/odata";var b;if(s.toLowerCase().indexOf(o)!==-1){var c=s.match(r);if(!c||c.length!==3){throw new Error("sap.ui.fl.fieldExt.Access._parseV2ServiceUri: Malformed service URI (Invalid service name)");}if(c[1].toLowerCase()!=="sap"){b="/"+c[1]+"/"+c[2];}else{b=c[2];}}else{if(s.length>0&&s.lastIndexOf("/")+1===s.length){s=s.substring(0,s.length-1);}b=s.substring(s.lastIndexOf("/")+1);}if(b.indexOf(";v=")!==-1){var v=b.match(R);if(!v||v.length!==3){throw new Error("sap.ui.fl.fieldExt.Access._parseV2ServiceUri: Malformed service URI (Invalid version)");}return{serviceName:v[1],serviceVersion:v[2],serviceType:this._mServiceType.v2};}return{serviceName:b,serviceVersion:"0001",serviceType:this._mServiceType.v2};};
A._parseV4ServiceUri=function(s){var r=/^\/?sap\/opu\/odata4((?:\/[^/]+){5})(\/[^/]+){1}(\/.*)?/i;var b=s.match(r);if(!b||b.length!==4){throw new Error("sap.ui.fl.fieldExt.Access._parseV4ServiceUri: Malformed service URI");}var n=b[1].split("/");n.splice(0,3);var R=/(\d{1,4})/i;var v=b[2].match(R);return{serviceName:n.join("/"),serviceVersion:v[1],serviceType:this._mServiceType.v4};};
A._buildBusinessContextRetrievalUri=function(s,e){var b="/sap/opu/odata/SAP/APS_CUSTOM_FIELD_MAINTENANCE_SRV/";if(s.serviceType===this._mServiceType.v4){var r=this._sODataV4ResourcePathPrefix+s.serviceName+"/"+s.serviceVersion;b+="GetBusinessContextsByResourcePath?"+a({ResourcePath:"'"+r+"'"});}else{b+="GetBusinessContextsByEntityType?"+"ServiceName=\'"+s.serviceName+"\'"+"&ServiceVersion=\'"+s.serviceVersion+"\'";}b+="&EntitySetName=\'"+e.entitySetName+"\'"+"&EntityTypeName=\'"+e.entityTypeName+"\'"+"&$format=json";return b;};
A._executeAjaxCall=function(b,s,e){var t=this;var m=this._getAjaxSettings();var d=q.Deferred();var r={BusinessContexts:[],ServiceName:s.serviceName,ServiceVersion:s.serviceVersion};q.ajax(b,m).done(function(c){r.BusinessContexts=t._extractBusinessContexts(c);d.resolve(r);}).fail(function(j){if(j.status===404&&s.serviceType===t._mServiceType.v4){d.resolve(r);}else{var E=t._getMessagesFromXHR(j);var o={errorOccured:true,errorMessages:E,serviceName:s.serviceName,serviceVersion:s.serviceVersion,entityType:e.entityTypeName,entitySet:e.entitySetName};d.reject(o);}});return d.promise();};
A._getAjaxSettings=function(){var s={type:"GET",async:true,dataType:"json"};return s;};
A._extractBusinessContexts=function(d){var r=null;var b=[];if(d&&d.d){r=d.d.results;}if(r!==null&&r.length>0){for(var i=0;i<r.length;i++){if(r[i].BusinessContext!==null){b.push({BusinessContext:r[i].BusinessContext,BusinessContextDescription:r[i].BusinessContextDescription});}}}return b;};
A._getMessagesFromXHR=function(x){var m=[];try{var E=JSON.parse(x.responseText);if(E&&E.error&&E.error.message&&E.error.message.value&&E.error.message.value!==''){m.push({severity:"error",text:E.error.message.value});}else{m.push({severity:"error",text:x.responseText});}}catch(e){}return m;};
A._getCurrentTime=function(){return Date.now();};
A._isServiceExpired=function(s){return s.expirationDate<=this._getCurrentTime();};
A._getLocalStorage=function(){return new S(S.Type.local);};
A.isLocalStorageAvailable=function(){return this._getLocalStorage()&&this._getLocalStorage().isSupported();};
A._getServiceItem=function(s){return this._getDataFromLocalStorage()[s.serviceKey]||null;};
A._createServiceItem=function(s){var e=this._getCurrentTime()+this._iValidityPeriod;var m=this._getSystemInfo();var p=this._extractServiceInfo(s);return{serviceKey:m.getName()+m.getClient()+p.serviceName+p.serviceVersion,expirationDate:e};};
A._extractServiceInfo=function(s){if(typeof s==="string"){return this._parseServiceUri(s);}return s;};
A._isSystemInfoAvailable=function(){var u=U.getUshellContainer();return u&&u.getLogonSystem;};
A._getSystemInfo=function(){var u=U.getUshellContainer();return u&&u.getLogonSystem();};
A._setDataToLocalStorage=function(d){if(this.isLocalStorageAvailable()){this._getLocalStorage().put(A._sStorageKey,JSON.stringify(d));}};
A._getDataFromLocalStorage=function(){if(!this.isLocalStorageAvailable()){return{};}var s=this._getLocalStorage().get(A._sStorageKey);if(!s){return{};}return JSON.parse(s);};
return A;},true);
sap.ui.predefine('sap/ui/fl/library',["sap/ui/fl/RegistrationDelegator","sap/ui/fl/Utils","sap/ui/fl/Layer","sap/ui/core/library","sap/m/library"],function(R,U,L){"use strict";sap.ui.getCore().initLibrary({name:"sap.ui.fl",version:"1.84.0",controls:["sap.ui.fl.variants.VariantManagement","sap.ui.fl.util.IFrame"],dependencies:["sap.ui.core","sap.m"],designtime:"sap/ui/fl/designtime/library.designtime",extensions:{flChangeHandlers:{"sap.ui.fl.util.IFrame":"sap/ui/fl/util/IFrame"},"sap.ui.support":{diagnosticPlugins:["sap/ui/fl/support/Flexibility"],publicRules:true}}});sap.ui.fl.Scenario={AppVariant:"APP_VARIANT",VersionedAppVariant:"VERSIONED_APP_VARIANT",AdaptationProject:"ADAPTATION_PROJECT",FioriElementsFromScratch:"FE_FROM_SCRATCH",UiAdaptation:"UI_ADAPTATION"};sap.ui.fl.Versions={Original:-1,Draft:0,UrlParameter:"sap-ui-fl-version"};sap.ui.fl.condenser={Classification:{LastOneWins:"lastOneWins",Reverse:"reverse",Move:"move",Create:"create",Destroy:"destroy"}};R.registerAll();
function _(){var u=U.getUshellContainer();if(u){return u.getLogonSystem().isTrial();}return false;}
if(_()){sap.ui.getCore().getConfiguration().setFlexibilityServices([{connector:"LrepConnector",url:"/sap/bc/lrep",layers:[]},{connector:"LocalStorageConnector",layers:[L.CUSTOMER,L.USER]}]);}return sap.ui.fl;});
sap.ui.predefine('sap/ui/fl/registry/ChangeHandlerRegistration',["sap/ui/fl/registry/ChangeRegistry","sap/ui/thirdparty/jquery"],function(C,q){"use strict";var a={_mRegistrationPromises:{},_addRegistrationPromise:function(k,p){this._mRegistrationPromises[k]=p;p.then(function(){delete this._mRegistrationPromises[k];}.bind(this));p.catch(function(e){delete this._mRegistrationPromises[k];return Promise.reject(e);}.bind(this));},waitForChangeHandlerRegistration:function(k){return this._mRegistrationPromises[k]||Promise.resolve();},isChangeHandlerRegistrationInProgress:function(k){return!!this._mRegistrationPromises[k];},getChangeHandlersOfLoadedLibsAndRegisterOnNewLoadedLibs:function(){var c=sap.ui.getCore();var A=c.getLoadedLibraries();var p=[];q.each(A,function(l,L){if(L.extensions&&L.extensions.flChangeHandlers){p.push(this._registerFlexChangeHandlers(L.extensions.flChangeHandlers));}}.bind(this));c.attachLibraryChanged(this._handleLibraryRegistrationAfterFlexLibraryIsLoaded.bind(this));return Promise.all(p);},_registerFlexChangeHandlers:function(f){if(f){var c=C.getInstance();return c.registerControlsForChanges(f);}return Promise.resolve();},_handleLibraryRegistrationAfterFlexLibraryIsLoaded:function(l){if(l.getParameter("operation")==="add"){var L=l.getParameter("metadata");var o=L.sName;if(L&&L.extensions&&L.extensions.flChangeHandlers){var f=L.extensions.flChangeHandlers;var r=this._registerFlexChangeHandlers(f);this._addRegistrationPromise(o,r);return r;}}return Promise.resolve();}};return a;},true);
sap.ui.predefine('sap/ui/fl/registry/ChangeRegistry',["sap/ui/fl/Utils","sap/ui/thirdparty/jquery","sap/ui/fl/registry/ChangeRegistryItem","sap/ui/fl/registry/ChangeTypeMetadata","sap/ui/fl/registry/Settings","sap/ui/fl/changeHandler/HideControl","sap/ui/fl/changeHandler/MoveElements","sap/ui/fl/changeHandler/MoveControls","sap/ui/fl/changeHandler/PropertyChange","sap/ui/fl/changeHandler/PropertyBindingChange","sap/ui/fl/changeHandler/UnhideControl","sap/ui/fl/changeHandler/StashControl","sap/ui/fl/changeHandler/UnstashControl","sap/ui/fl/changeHandler/AddXML","sap/ui/fl/changeHandler/AddXMLAtExtensionPoint","sap/ui/fl/requireAsync","sap/base/Log"],function(U,q,C,a,S,H,M,b,P,c,d,e,f,A,g,r,L){"use strict";var h=function(){this._registeredItems={};this.initSettings();this.initDeveloperModeChangeHandlers();};h._instance=undefined;h.prototype._oDefaultActiveChangeHandlers={};h.prototype._oDefaultChangeHandlers={hideControl:H,moveElements:M,moveControls:b,unhideControl:d,stashControl:e,unstashControl:f};h.prototype._mDeveloperModeChangeHandlers={propertyChange:{changeHandler:P},propertyBindingChange:{changeHandler:c},addXML:{changeHandler:A},addXMLAtExtensionPoint:{changeHandler:g}};
h.prototype.initDeveloperModeChangeHandlers=function(){Object.keys(this._mDeveloperModeChangeHandlers).forEach(function(s){var o=this._mDeveloperModeChangeHandlers[s].changeHandler;var l=this._oSettings.getDeveloperModeLayerPermissions();var i={changeType:s,changeHandler:o,layers:l};var j=this._createChangeRegistryItemForSimpleChange("defaultActiveForAllControls",i);this._oDefaultActiveChangeHandlers[s]=j;}.bind(this));};
h.getInstance=function(){if(!h._instance){h._instance=new h();}return h._instance;};
h.prototype.hasRegisteredChangeHandlersForControl=function(s){var i=Object.keys(this._registeredItems);return i.indexOf(s)!==-1;};
h.prototype.hasChangeHandlerForControlAndChange=function(s,i){if(!this.hasRegisteredChangeHandlersForControl(s)){return false;}var R=this._registeredItems[s];var j=Object.keys(R);return j.indexOf(i)!==-1;};
h.prototype.registerControlsForChanges=function(m){var p=[];q.each(m,function(s,v){var i={};if(Array.isArray(v)){v.forEach(function(o){i[o.changeType]=o.changeHandler;});}else{i=v;}p.push(this._registerChangeHandlersForControl(s,i));}.bind(this));return Promise.all(p);};
h.prototype._registerChangeHandlersForControl=function(s,o){var p=Promise.resolve(o);var i="ChangeRegistry._registerChangeHandlersForControl.skip_next_then";if(typeof o==="string"){p=r(o+".flexibility").catch(function(E){L.error("Flexibility change handler registration failed.\nControlType: "+s+"\n"+E.message);return Promise.resolve(i);});}return p.then(function(R){if(R!==i){q.each(R,function(j,k){var l=this._getChangeHandlerEntry(j,k);var m={changeType:j,changeHandler:l.changeHandler,layers:l.layers};this.registerControlForSimpleChange(s,m);}.bind(this));}}.bind(this));};
h.prototype._getInstanceSpecificChangeRegistryItem=function(s,o,m){var i=m&&m.getChangeHandlerModulePath(o);if(typeof i!=="string"){return new U.FakePromise(undefined);}return r(i).then(function(j){var v=j[s];if(!v){return undefined;}var k=this._getChangeHandlerEntry(s,v);var l={changeType:s,changeHandler:k.changeHandler,layers:k.layers};var n=m.getControlType(o);var p=this._createChangeRegistryItemForSimpleChange(n,l);return p;}.bind(this)).catch(function(E){L.error("Flexibility registration for control "+m.getId(o)+" failed to load module "+i+"\n"+E.message);return undefined;});};
h.prototype._getChangeHandlerEntry=function(s,v){var R={};var D=Object.keys(this._mDeveloperModeChangeHandlers);if(!v||!v.changeHandler){R.changeHandler=v;}else{R=v;}if(R.changeHandler==="default"){R.changeHandler=this._oDefaultChangeHandlers[s];}else if(D.indexOf(s)>-1){throw Error("You can't use a custom change handler for the following Developer Mode change types: "+D.toString()+". Please use 'default' instead.");}return R;};
h.prototype.getChangeHandler=function(s,i,o,m,l){return this._getInstanceSpecificChangeRegistryItem(s,o,m).then(function(j){var k=j||this._getRegistryItem(i,s);if(!k){throw Error("No Change handler registered for the Control and Change type");}if(!this._isRegistryItemValidForLayer(k,l)){throw Error("Change type "+s+" not enabled for layer "+l);}return k.getChangeTypeMetadata().getChangeHandler();}.bind(this));};
h.prototype.registerControlForSimpleChange=function(s,o){var i;if(!s){return;}if(!o||!o.changeType||!o.changeHandler){return;}i=this._createChangeRegistryItemForSimpleChange(s,o);if(i){this.addRegistryItem(i);}};
h.prototype._createChangeRegistryItemForSimpleChange=function(s,o){var p;var i;var j;var l;l=Object.assign({},this._oSettings.getDefaultLayerPermissions());var k=o.layers;if(k){Object.keys(k).forEach(function(m){if(l[m]===undefined){throw Error("The Layer '"+m+"' is not supported. Please only use supported layers");}l[m]=k[m];});}p={name:o.changeType,changeHandler:o.changeHandler,layers:l};i=new a(p);p={changeTypeMetadata:i,controlType:s};j=new C(p);return j;};
h.prototype.addRegistryItem=function(R){var s;var i;if(!R){return;}s=R.getChangeTypeName();i=R.getControlType();this._registeredItems[i]=this._registeredItems[i]||{};this._registeredItems[i][s]=R;};
h.prototype.removeRegistryItem=function(p){if(!p.changeTypeName&&!p.controlType){L.error("sap.ui.fl.registry.ChangeRegistry: ChangeType and/or ControlType required");return;}if(p.controlType&&p.changeTypeName){if(this._registeredItems[p.controlType]){if(Object.keys(this._registeredItems[p.controlType]).length===1){delete this._registeredItems[p.controlType];}else{delete this._registeredItems[p.controlType][p.changeTypeName];}}}else if(p.controlType){if(this._registeredItems[p.controlType]){delete this._registeredItems[p.controlType];}}else if(p.changeTypeName){for(var i in this._registeredItems){var j=this._registeredItems[i];delete j[p.changeTypeName];}}};
h.prototype._getRegistryItem=function(s,i){var o=this._registeredItems[s];if(o){var j=o[i];if(j){return j;}}var D=this._oDefaultActiveChangeHandlers[i];if(D){return D;}};
h.prototype.initSettings=function(){this._oSettings=S.getInstanceOrUndef();if(!this._oSettings){this._oSettings=new S({});}};
h.prototype._isRegistryItemValidForLayer=function(R,l){var o=R.getChangeTypeMetadata().getLayers();return!!o[l];};
h.prototype.getDragInfo=function(s){var i=this._registeredItems[s];if(i){return i.getDragInfo();}return null;};
return h;},true);
sap.ui.predefine('sap/ui/fl/registry/ChangeRegistryItem',["sap/base/Log"],function(L){"use strict";var C=function(p){if(!p.changeTypeMetadata){L.error("sap.ui.fl.registry.ChangeRegistryItem: ChangeTypeMetadata required");}if(!p.controlType){L.error("sap.ui.fl.registry.ChangeRegistryItem: ControlType required");}this._changeTypeMetadata=p.changeTypeMetadata;this._controlType=p.controlType;if(p.permittedRoles){this._permittedRoles=p.permittedRoles;}if(p.dragTargets){this._dragTargets=p.dragTargets;}};C.prototype._changeTypeMetadata=undefined;C.prototype._controlType=undefined;C.prototype._permittedRoles={};C.prototype._dragTargets=[];
C.prototype.getChangeTypeMetadata=function(){return this._changeTypeMetadata;};
C.prototype.getChangeTypeName=function(){return this._changeTypeMetadata.getName();};
C.prototype.getControlType=function(){return this._controlType;};
C.prototype.getPermittedRoles=function(){return this._permittedRoles;};
C.prototype.getDragTargets=function(){return this._dragTargets;};
return C;},true);
sap.ui.predefine('sap/ui/fl/registry/ChangeTypeMetadata',["sap/base/Log","sap/ui/fl/Utils","sap/ui/fl/requireAsync"],function(L,U,r){"use strict";var C=function(p){if(!p.name){L.error("sap.ui.fl.registry.ChangeType: Name required");}if(!p.changeHandler){L.error("sap.ui.fl.registry.ChangeType: ChangeHandler required");}this._name=p.name;this._changeHandler=p.changeHandler;this._layers=p.layers;if(p.labelKey){this._labelKey=p.labelKey;}if(p.tooltipKey){this._tooltipKey=p.tooltipKey;}if(p.iconKey){this._iconKey=p.iconKey;}if(p.sortIndex){this._sortIndex=p.sortIndex;}};C.prototype._name="";C.prototype._changeHandler="";C.prototype._layers=[];C.prototype._sortIndex=0;C.prototype._labelKey="";C.prototype._tooltipKey="";C.prototype._iconKey="";
C.prototype.getName=function(){return this._name;};
C.prototype.getChangeHandler=function(){var p=new U.FakePromise();if(typeof this._changeHandler==="string"){p=r(this._changeHandler.replace(/\./g,"/")).then(function(c){this._changeHandler=c;}.bind(this));}return p.then(function(){if(!this._changeHandler||typeof this._changeHandler.completeChangeContent!=="function"||typeof this._changeHandler.applyChange!=="function"||typeof this._changeHandler.revertChange!=="function"){return Promise.reject(new Error("The ChangeHandler is either not available or does not fulfill all needed requirements"));}return this._changeHandler;}.bind(this));};
C.prototype.getLayers=function(){return this._layers;};
C.prototype.getLabel=function(){return this._labelKey;};
C.prototype.getTooltip=function(){return this._tooltipKey;};
C.prototype.getIcon=function(){return this._iconKey;};
C.prototype.getSortIndex=function(){return this._sortIndex;};
return C;},true);
sap.ui.predefine('sap/ui/fl/registry/Settings',["sap/ui/fl/write/_internal/Storage","sap/base/Log"],function(S,L){"use strict";var a=function(s){if(!s){throw new Error("no flex settings provided");}if(!s.defaultLayerPermissions){s.defaultLayerPermissions={VENDOR:true,CUSTOMER_BASE:true,CUSTOMER:true,USER:false};}if(!s.developerModeLayerPermissions){s.developerModeLayerPermissions={VENDOR:true,CUSTOMER_BASE:true,CUSTOMER:false,USER:false};}if(s.isVariantSharingEnabled===undefined){s.isVariantSharingEnabled=true;}this._oSettings=s;};
a.attachEvent=function(e,c){a._oEventProvider.attachEvent(e,c);};
a.detachEvent=function(e,c){a._oEventProvider.detachEvent(e,c);};
a.getInstance=function(){if(a._instance){return Promise.resolve(a._instance);}if(a._oLoadSettingsPromise){return a._oLoadSettingsPromise;}return a._loadSettings();};
a._loadSettings=function(){var l=S.loadFeatures().then(function(s){if(!s){L.error("The request for flexibility settings failed; A default response is generated and returned to consuming APIs");s={isKeyUser:false,isVariantSharingEnabled:false,isAtoAvailable:false,isAtoEnabled:false,isAppVariantSaveAsEnabled:false,isProductiveSystem:true,versioning:{},_bFlexChangeMode:false,_bFlexibilityAdaptationButtonAllowed:false};}return a._storeInstance(s);});a._oLoadSettingsPromise=l;return l;};
a._storeInstance=function(s){if(!a._instance){a._instance=new a(s);}return a._instance;};
a.getInstanceOrUndef=function(){var s;if(a._instance){s=a._instance;}return s;};
a.prototype._getBooleanProperty=function(p){return this._oSettings[p]||false;};
a.prototype.isKeyUser=function(){return this._getBooleanProperty("isKeyUser");};
a.prototype.isAppVariantSaveAsEnabled=function(){return this._getBooleanProperty("isAppVariantSaveAsEnabled");};
a.prototype.isVersioningEnabled=function(l){return!!(this._oSettings.versioning[l]||this._oSettings.versioning["ALL"]);};
a.prototype.isModelS=function(){return this._getBooleanProperty("isAtoAvailable");};
a.prototype.isAtoEnabled=function(){return this._getBooleanProperty("isAtoEnabled");};
a.prototype.isAtoAvailable=function(){return this._getBooleanProperty("isAtoAvailable");};
a.prototype.isProductiveSystem=function(){return this._getBooleanProperty("isProductiveSystem");};
a.prototype.isVariantSharingEnabled=function(){return this._getBooleanProperty("isVariantSharingEnabled");};
a.prototype.getSystem=function(){return this._oSettings.system;};
a.prototype.getClient=function(){return this._oSettings.client;};
a.prototype.getDefaultLayerPermissions=function(){return this._oSettings.defaultLayerPermissions;};
a.prototype.getDeveloperModeLayerPermissions=function(){return this._oSettings.developerModeLayerPermissions;};
return a;},true);
sap.ui.predefine('sap/ui/fl/registry/SimpleChanges',["sap/ui/fl/changeHandler/HideControl","sap/ui/fl/changeHandler/UnhideControl","sap/ui/fl/changeHandler/StashControl","sap/ui/fl/changeHandler/UnstashControl","sap/ui/fl/changeHandler/MoveElements","sap/ui/fl/changeHandler/MoveControls","sap/ui/fl/changeHandler/PropertyChange","sap/ui/fl/changeHandler/PropertyBindingChange"],function(H,U,S,a,M,b,P,c){"use strict";var d={hideControl:{changeType:"hideControl",changeHandler:H},unhideControl:{changeType:"unhideControl",changeHandler:U},stashControl:{changeType:"stashControl",changeHandler:S},unstashControl:{changeType:"unstashControl",changeHandler:a},moveElements:{changeType:"moveElements",changeHandler:M},moveControls:{changeType:"moveControls",changeHandler:b},propertyChange:{changeType:"propertyChange",changeHandler:P},propertyBindingChange:{changeType:"propertyBindingChange",changeHandler:c}};return d;},true);
sap.ui.predefine('sap/ui/fl/transport/TransportDialog',["sap/ui/fl/write/_internal/transport/TransportDialog"],function(I){"use strict";
var T=I.extend("sap.ui.fl.transport.TransportDialog");
return T;});
sap.ui.predefine('sap/ui/fl/transport/TransportSelection',["sap/ui/fl/write/_internal/transport/TransportSelection"],function(T){"use strict";return T;},true);
sap.ui.predefine('sap/ui/fl/util/IFrame.flexibility',["sap/ui/fl/changeHandler/UpdateIFrame"],function(U){"use strict";return{updateIFrame:U,hideControl:"default"};});
sap.ui.predefine('sap/ui/fl/util/IFrame',["../library","sap/ui/core/Control","sap/ui/model/json/JSONModel","./getContainerUserInfo","sap/base/util/extend","sap/ui/core/library","./IFrameRenderer"],function(l,C,J,g,e){"use strict";
function u(v){if(v.parts&&v.formatter){return v.formatter.apply(null,v.parts.map(function(p){if(p.model){return"{"+p.model+">"+p.path+"}";}return"{"+p.path+"}";}));}return v;}
var I=C.extend("sap.ui.fl.util.IFrame",{
metadata:{library:"sap.ui.fl",properties:{url:{type:"sap.ui.core.URI",group:"Misc",defaultValue:""},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:"100%"},height:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:"100%"},title:{type:"string",group:"Misc",defaultValue:undefined},_settings:{type:"object",group:"Data",defaultValue:null}},designtime:"sap/ui/fl/designtime/util/IFrame.designtime"},
init:function(){if(C.prototype.init){C.prototype.init.apply(this,arguments);}this._oUserModel=new J(g());this.setModel(this._oUserModel,"$user");},
applySettings:function(s){C.prototype.applySettings.apply(this,arguments);if(s){var m=this.getProperty("_settings")||{};if(s._settings){e(m,s._settings);}else{Object.keys(s).filter(function(p){return!!s[p];}).forEach(function(p){m[p]=u(s[p]);});}this.setProperty("_settings",m);}},
exit:function(){if(this._oUserModel){this._oUserModel.destroy();delete this._oUserModel;}}
});
return I;});
sap.ui.predefine('sap/ui/fl/util/IFrameRenderer',[],function(){"use strict";
function _(r,d,v){if(v!==""||v.toLowerCase()==="auto"){r.style(d,v);}}
var I={apiVersion:2};
I.render=function(r,i){r.openStart("iframe",i);_(r,"width",i.getWidth());_(r,"height",i.getHeight());r.style("display","block");r.style("border","none");r.attr("src",i.getUrl());var t=i.getTitle();if(t){r.attr("title",t);}r.openEnd();r.close("iframe");};
return I;},true);
sap.ui.predefine('sap/ui/fl/util/ManagedObjectModel',["sap/ui/core/Element","sap/ui/model/base/ManagedObjectModel"],function(E,M){"use strict";
function c(n){return n.charAt(0).toUpperCase()+n.slice(1);}
var a=E.extend("sap.ui.fl.util.ManagedObjectModel",{
metadata:{library:"sap.ui.fl",properties:{data:{type:"object"},name:{type:"string",defaultValue:"$sap.ui.fl.ManagedObjectModel"}},associations:{object:{type:"sap.ui.core.Element"}}},
constructor:function(){E.apply(this,arguments);this._oManagedObjectModel=new M(sap.ui.getCore().byId(this.getObject()),this.getData());["data","name","object"].forEach(function(n){this["set"+c(n)]=function(){throw new Error("sap.ui.fl.util.ManagedObjectModel: Can't change the value of `"+n+"` after the object is initialized. Please recreate the object with correct values in the constructor.");};},this);}
});
a.prototype.setParent=function(n){var o=this.getParent();if(o){o.setModel(null,this.getName());}if(n){n.setModel(this._oManagedObjectModel,this.getName());}E.prototype.setParent.apply(this,arguments);};
a.prototype.exit=function(){this._oManagedObjectModel.destroy();};
return a;},true);
sap.ui.predefine('sap/ui/fl/util/getContainerUserInfo',["sap/ui/fl/Utils","sap/base/Log"],function(U,L){"use strict";
function e(v){if(!v){return"";}return v;}
return function(){return U.ifUShellContainerThen(function(s){var u=s[0];if(!u){return{};}var o=u.getUser();if(!o){return{};}try{var E=e(o.getEmail());var d;if(E){d=e(/@(.*)/.exec(E)[1]);}else{d="";}return{fullName:e(o.getFullName()),firstName:e(o.getFirstName()),lastName:e(o.getLastName()),email:E,domain:d};}catch(a){L.error("Unexpected exception when reading shell user info: "+a.toString());}},["UserInfo"])||{};};});
sap.ui.predefine('sap/ui/fl/write/_internal/appVariant/AppVariantFactory',["sap/ui/fl/write/_internal/appVariant/AppVariant","sap/ui/thirdparty/jquery","sap/ui/fl/descriptorRelated/internal/Utils","sap/ui/fl/write/_internal/connectors/LrepConnector","sap/base/util/merge"],function(A,q,U,L,m){"use strict";
function _(p){if(!p.url){p.url="/sap/bc/lrep";}return L.appVariant.load(p);}
var a={};
a.load=function(p){if(p.id===undefined||typeof p.id!=="string"){throw new Error("Parameter "+p.id+" must be provided of type string");}return _({reference:p.id}).then(function(r){var o=r.response;if(!q.isPlainObject(o)){o=JSON.parse(o);}p=m({},p,o);return new A(p);});};
a.prepareCreate=function(p){try{U.checkParameterAndType(p,"reference","string");U.checkParameterAndType(p,"id","string");if(p.version){U.checkParameterAndType(p,"version","string");}if(!p.layer){p.layer='CUSTOMER';}else{U.checkParameterAndType(p,"layer","string");}if(p.skipIam){U.checkParameterAndType(p,"skipIam","boolean");}if(p.transport){U.checkTransportRequest(p.transport);}if(p.package){U.checkPackage(p.package);}}catch(e){return Promise.reject(e);}p.content=[];var o=new A(p);o.setMode("NEW");return Promise.resolve(o);};
a.prepareUpdate=function(p){return a.load(p).then(function(o){o.setMode("EXISTING");return o;});};
a.prepareDelete=function(p){return((p.isForSmartBusiness)?Promise.resolve(new A(p)):a.load(p)).then(function(o){o.setMode("DELETION");return o;});};
return a;},true);
sap.ui.predefine('sap/ui/fl/write/_internal/appVariant/AppVariantInlineChangeFactory',["sap/ui/fl/descriptorRelated/internal/Utils","sap/ui/fl/write/_internal/appVariant/AppVariantInlineChange"],function(U,A){"use strict";
function _(p){if(!p.texts){p.texts={"":p.content};p.content={};}}
function a(p){var o=new A(p);return Promise.resolve(o);}
var b={};
b.createNew=function(p){var o=new A(p);return Promise.resolve(o);};
b.createDescriptorInlineChange=function(p){var t=p.changeType.replace("appdescr","create");return this[t](p);};
b.create_ovp_addNewCard=function(p){U.checkParameterAndType(p.content,"card","object");return a(p);};
b.create_ovp_removeCard=function(p){U.checkParameterAndType(p.content,"cardId","string");return a(p);};
b.create_ovp_changeCard=function(p){U.checkParameterAndType(p.content,"cardId","string");U.checkEntityPropertyChange(p.content);return a(p);};
b.create_app_addNewInbound=function(p){U.checkParameterAndType(p.content,"inbound","object");return a(p);};
b.create_app_removeInbound=function(p){U.checkParameterAndType(p.content,"inboundId","string");return a(p);};
b.create_app_removeAllInboundsExceptOne=function(p){U.checkParameterAndType(p.content,"inboundId","string");return a(p);};
b.create_app_changeInbound=function(p){U.checkParameterAndType(p.content,"inboundId","string");U.checkEntityPropertyChange(p.content);return a(p);};
b.create_app_addNewOutbound=function(p){U.checkParameterAndType(p.content,"outbound","object");return a(p);};
b.create_app_removeOutbound=function(p){U.checkParameterAndType(p.content,"outboundId","string");return a(p);};
b.create_app_changeOutbound=function(p){U.checkParameterAndType(p.content,"outboundId","string");U.checkEntityPropertyChange(p.content);return a(p);};
b.create_app_addNewDataSource=function(p){U.checkParameterAndType(p.content,"dataSource","object");return a(p);};
b.create_app_removeDataSource=function(p){U.checkParameterAndType(p.content,"dataSourceId","string");return a(p);};
b.create_app_changeDataSource=function(p){U.checkParameterAndType(p.content,"dataSourceId","string");U.checkEntityPropertyChange(p.content);return a(p);};
var T={BEGINNING:"BEGINNING",END:"END"};
b.create_app_addAnnotationsToOData=function(p){U.checkParameterAndType(p.content,"dataSourceId","string");U.checkParameterAndType(p.content,"annotations","array");U.checkParameterAndType(p.content,"dataSource","object");return a(p);};
b.create_app_setTitle=function(p){_(p);return a(p).then(function(d){d.setHostingIdSuffix("_sap.app.title");return d;});};
b.create_app_setSubTitle=function(p){_(p);return a(p).then(function(d){d.setHostingIdSuffix("_sap.app.subTitle");return d;});};
b.create_app_setShortTitle=function(p){_(p);return a(p).then(function(d){d.setHostingIdSuffix("_sap.app.shortTitle");return d;});};
b.create_app_setDescription=function(p){_(p);return a(p).then(function(d){d.setHostingIdSuffix("_sap.app.description");return d;});};
b.create_app_setInfo=function(p){_(p);return a(p).then(function(d){d.setHostingIdSuffix("_sap.app.info");return d;});};
b.create_app_setAch=function(p){U.checkParameterAndType(p.content,"ach","string");return a(p);};
b.create_app_setDestination=function(p){U.checkParameterAndType(p.content,"destination","object");return a(p);};
b.create_app_setKeywords=function(p){U.checkParameterAndType(p.content,"keywords","array");return a(p);};
b.create_app_addTechnicalAttributes=function(p){U.checkParameterAndType(p.content,"technicalAttributes","array");return a(p);};
b.create_app_removeTechnicalAttributes=function(p){U.checkParameterAndType(p.content,"technicalAttributes","array");return a(p);};
b.create_app_addCdsViews=function(p){U.checkParameterAndType(p.content,"cdsViews","array");return a(p);};
b.create_app_removeCdsViews=function(p){U.checkParameterAndType(p.content,"cdsViews","array");return a(p);};
b.create_flp_setConfig=function(p){U.checkParameterAndType(p.content,"config","object");return a(p);};
b.create_ui5_addNewModel=function(p){U.checkParameterAndType(p.content,"model","object");return a(p);};
b.create_ui5_removeModel=function(p){U.checkParameterAndType(p.content,"modelId","string");return a(p);};
b.create_ui5_addNewModelEnhanceWith=function(p){U.checkParameterAndType(p.content,"modelId","string");return a(p);};
b.create_ui5_replaceComponentUsage=function(p){U.checkParameterAndType(p.content,"componentUsageId","string");U.checkParameterAndType(p.content,"componentUsage","object");return a(p);};
b.create_ui5_addLibraries=function(p){U.checkParameterAndType(p.content,"libraries","object");return a(p);};
b.create_ui5_setMinUI5Version=function(p){U.checkParameterAndType(p.content,"minUI5Version","string");return a(p);};
b.create_smb_addNamespace=function(p){U.checkParameterAndType(p.content,"smartBusinessApp","object");return a(p);};
b.create_smb_changeNamespace=function(p){U.checkParameterAndType(p.content,"smartBusinessApp","object");return a(p);};
b.create_ui_generic_app_setMainPage=function(p){U.checkParameterAndType(p.content,"page","object");return a(p);};
b.create_ui_setIcon=function(p){U.checkParameterAndType(p.content,"icon","string");return a(p);};
b.create_ui_setDeviceTypes=function(p){U.checkParameterAndType(p.content,"deviceTypes","object");return a(p);};
b.create_url_setUri=function(p){U.checkParameterAndType(p.content,"uri","string");return a(p);};
b.create_fiori_setRegistrationIds=function(p){U.checkParameterAndType(p.content,"registrationIds","array");return a(p);};
b.create_ui5_setFlexExtensionPointEnabled=function(p){U.checkParameterAndType(p.content,"flexExtensionPointEnabled","boolean");U.checkParameterAndType(p,"changeType","string");return a(p);};
return b;},true);
sap.ui.predefine('sap/ui/fl/write/_internal/condenser/Condenser',["sap/base/util/each","sap/base/util/isPlainObject","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/core/Core","sap/ui/fl/apply/_internal/changes/Utils","sap/ui/fl/write/_internal/condenser/classifications/LastOneWins","sap/ui/fl/write/_internal/condenser/classifications/Reverse","sap/ui/fl/write/_internal/condenser/UIReconstruction","sap/ui/fl/write/_internal/condenser/Utils","sap/ui/fl/Change","sap/ui/fl/Utils","sap/ui/performance/Measurement"],function(e,i,J,C,c,L,R,U,d,f,F,M){"use strict";var g={};var h="unclassified";var N={lastOneWins:L,reverse:R};
function j(S,a){return a.classification===sap.ui.fl.condenser.Classification.Create&&S[sap.ui.fl.condenser.Classification.Move];}
function k(S,a){return a.classification===sap.ui.fl.condenser.Classification.Move&&S[sap.ui.fl.condenser.Classification.Destroy];}
function l(a,b){return b.classification===sap.ui.fl.condenser.Classification.Create&&a[sap.ui.fl.condenser.Classification.Destroy];}
function m(a,b,A,B){if(!k(a,A)&&!l(a,A)){var D=A.classification;if(!a[D]){A.change=B;a[D]=[A];}}if(j(a,A)||l(a,A)){delete a[sap.ui.fl.condenser.Classification.Move];delete a[sap.ui.fl.condenser.Classification.Destroy];}U.addChange(b,A);}
function n(T,a,I,b,A){if(!T[b.type]){T[b.type]={};}var B=T[b.type];if(b.type===d.NOT_INDEX_RELEVANT){if(!B[b.classification]){B[b.classification]={};}var P=B[b.classification];N[b.classification].addToChangesMap(P,b.uniqueKey,A);}else{I.push(A);m(B,a,b,A);}}
function o(T,K,a){if(!T[K]){T[K]=[];}T[K].push(a);}
function p(a,b){var A=J.getControlIdBySelector(b.getSelector(),a);var B=C.byId(A);if(B){var P={modifier:J,appComponent:a,view:F.getViewForControl(B)};var D=c.getControlIfTemplateAffected(b,B,P);return Promise.resolve(c.getChangeHandler(b,D,P)).then(function(E){if(E&&typeof E.getCondenserInfo==="function"){return E.getCondenserInfo(b);}});}return Promise.resolve();}
function q(a,b,A,B){var D=b!==undefined?b.affectedControl:J.getControlIdBySelector(A.getSelector(),B);if(!a[D]){a[D]={};}return a[D];}
function r(a,b,A,I,B){return B.reduce(function(P,D){return P.then(s.bind(this,a,b,A,I,D));}.bind(this),Promise.resolve());}
function s(a,b,A,I,B){return p(a,B).then(function(D){u(D,a);var T=q(b,D,B,a);if(D!==undefined){t(D);n(T,A,I,D,B);}else{o(T,h,B);b[h]=true;}});}
function t(a){if(N[a.classification]){a.type=d.NOT_INDEX_RELEVANT;}else{a.type=d.INDEX_RELEVANT;}}
function u(a,A){["affectedControl","sourceContainer","targetContainer"].forEach(function(P){if(a&&a[P]){a[P]=J.getControlIdBySelector(a[P],A);}});}
function v(O,a){e(O,function(K,S){if(N[K]&&N[K].getChangesFromMap){N[K].getChangesFromMap(O,K).forEach(function(b){a.push(b);});}else if(i(S)){return v(S,a);}else if(Array.isArray(S)){S.forEach(function(b){if(b instanceof f){a.push(b);}else{a.push(b.change);}});}});return a;}
function w(a){return v(a,[]);}
function x(a,b){e(a,function(K,S){if(i(S)){x(S,b);}else if(Array.isArray(S)){S.forEach(function(O){if(!(O instanceof f)){b.push(O);}});}});return b;}
function y(A,B){B.sort(function(a,b){return A.indexOf(a)-A.indexOf(b);});}
function z(a,I){var b=a.map(function(A){return A.getId();});I.forEach(function(A){if(b.indexOf(A.getId())===-1){a.push(A);}});}
g.condense=function(a,b){M.start("Condenser_overall","Condenser overall - CondenserClass",["sap.ui.fl","Condenser"]);var A={};var B={};var D=[];var E=[];var G=[];b.slice(0).reverse().forEach(function(H){if(H instanceof f&&H.isApplyProcessFinished()){G.push(H);}else{E.push(H);}});M.start("Condenser_defineMaps","defining of maps - CondenserClass",["sap.ui.fl","Condenser"]);return r(a,A,B,D,G).then(function(){M.end("Condenser_defineMaps");var H=A[h];if(!H){U.compareAndUpdate(A,B);}var I=w(A);if(H){z(I,D);}I=I.concat(E);y(b,I);if(!H){M.start("Condenser_handleIndexRelatedChanges","handle index related changes - CondenserClass",["sap.ui.fl","Condenser"]);var K=x(A,[]);M.start("Condenser_sort","sort index related changes - CondenserClass",["sap.ui.fl","Condenser"]);var O=U.sortIndexRelatedChanges(B,K);M.end("Condenser_sort");U.swapChanges(O,I);M.end("Condenser_handleIndexRelatedChanges");}M.end("Condenser_overall");return I;});};
return g;});
sap.ui.predefine('sap/ui/fl/write/_internal/condenser/UIReconstruction',["sap/base/util/restricted/_isEqual","sap/base/util/each","sap/ui/fl/write/_internal/condenser/classifications/Create","sap/ui/fl/write/_internal/condenser/classifications/Destroy","sap/ui/fl/write/_internal/condenser/classifications/Move","sap/ui/fl/write/_internal/condenser/Utils"],function(_,e,C,D,M,U){"use strict";var d={};var I={create:C,destroy:D,move:M};
function f(a,c){e(a,function(O,b){e(b,function(r,t){c(b,O,t,r);});});}
function s(E,O,N){E.splice(N,0,E.splice(O,1)[0]);}
function g(a,c){var b={};f(a,function(r,t,v,A){var T=v[U.TARGET_UI];T.forEach(function(w){c.forEach(function(x){if(w===x.affectedControl){if(!b[t]){b[t]={};}var y=b[t];if(!y[A]){y[A]=[];}var z=y[A];z.push(x);}});});});return b;}
function h(c){return!c.some(function(E){return E.classification!==sap.ui.fl.condenser.Classification.Create;});}
function i(E){return!E.some(function(v){return U.isUnknown(v);});}
function j(c){return c.getTargetIndex(c.change);}
function k(c){c.sort(function(a,b){var r=j(a);var N=j(b);return r-N;});}
function l(E){return!E.some(function(v){return!U.isUnknown(v);});}
function m(a,c){var b=c.targetContainer;var A=c.affectedControl;var t=c.getTargetIndex(c.change);var r=a[b][c.targetAggregation];U.extendArrayWithPlaceholders(r,undefined,t);var S=r.indexOf(A);s(r,S,t);}
function n(a,b){var c;if(a.length<b.length){c=b.slice(a.length);if(!l(c)){return false;}b=b.slice(0,a.length);}else if(a.length>b.length){c=a.slice(b.length,a.length);if(!l(c)){return false;}a=a.slice(0,b.length);}return _(a,b);}
function o(c,a,b,t,r){var v={};r.forEach(function(w){var c=w.targetContainer;if(!v[c]){v[c]={};}var x=v[c];if(!x[a]){x[a]=U.initializeArrayWithPlaceholders(0,b.length-1);}I[w.classification].simulate(x[a],w,b);});r.forEach(function(w){if(w.classification===sap.ui.fl.condenser.Classification.Move){m(v,w);}});var S=v[c][a];if(n(t,S)){return true;}return false;}
function u(r,a){f(a,function(b,c,t){t[U.TARGET_UI].forEach(function(T,v){if(!U.isUnknown(T)){var w=r[T];var S=w[U.INDEX_RELEVANT];e(S,function(x,y){if(x!==sap.ui.fl.condenser.Classification.Destroy){y.forEach(function(z){z.setTargetIndex(z.change,v);});}});}});});}
function p(r,a){f(a,function(b,c,t,K){var v=t[U.INITIAL_UI];var T=t[U.TARGET_UI];if(n(v,T)){T.forEach(function(w){var x=r[w];if(x!==undefined){delete x[U.INDEX_RELEVANT];}});delete b[K];}});}
function q(r,a){f(a,function(b,c,t){var v=t[U.INITIAL_UI];var T=t[U.TARGET_UI];v.forEach(function(w,x){var y=r[w];if(!y||!y[U.INDEX_RELEVANT]){var P=U.PLACEHOLDER+x;var z=T.indexOf(w);if(z>=0){T[z]=P;}}});});}
d.swapChanges=function(S,a){var b=S.map(function(c){return a.indexOf(c);}).sort();S.forEach(function(c){a[b.shift()]=c;});};
d.sortIndexRelatedChanges=function(a,c){var S=[];var b=g(a,c);f(b,function(A,r,c,t){var T=a[r][t][U.TARGET_UI];var v=a[r][t][U.INITIAL_UI];if(i(T)||h(c)){k(c);}else if(!o(r,t,v,T,c)){var w=false;var x=c.length;while(x!==0&&!w){var O=0;var N=1;while(N<c.length&&!w){s(c,O,N);w=o(r,t,v,T,c);O++;N++;}x--;}}c.forEach(function(y){S=S.concat(y.change);});});return S;};
d.addChange=function(a,c){I[c.classification].addToReconstructionMap(a,c);};
d.compareAndUpdate=function(r,a){p(r,a);q(r,a);u(r,a);};
return d;});
sap.ui.predefine('sap/ui/fl/write/_internal/condenser/Utils',["sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/core/Core"],function(J,C){"use strict";var U={};U.TARGET_UI="targetUI";U.INITIAL_UI="initialUI";U.PLACEHOLDER="X";U.INDEX_RELEVANT="indexRelevant";U.NOT_INDEX_RELEVANT="notIndexRelevant";
function g(s,t){return(Math.max(s,t)||0)+1;}
U.getInitialUIContainerElementIds=function(u,c,a,b){if(!u[c]){u[c]={};}var m=u[c];if(!m[a]){m[a]={};}var d=m[a];if(!d[U.TARGET_UI]){d[U.TARGET_UI]=b;}if(!d[U.INITIAL_UI]){d[U.INITIAL_UI]=b.slice(0);}return d[U.INITIAL_UI];};
U.getContainerElementIds=function(c,a){var o=C.byId(c);var b=J.getAggregation(o,a);return b.map(function(e){return e.getId();});};
U.initializeArrayWithPlaceholders=function(t,s){var l=g(s,t);return Array(l).fill(U.PLACEHOLDER).map(function(p,i){return p+i;});};
U.extendArrayWithPlaceholders=function(e,s,t){var l=g(s,t);if(e.length<l){var u;for(var i=e.length;i<=l;i++){u=U.PLACEHOLDER+(e.length);e.splice(e.length,0,u);}}};
U.extendElementsArray=function(e,s,t,a){U.extendArrayWithPlaceholders(e,s,t);var c=e.indexOf(a);var u=e.indexOf(U.PLACEHOLDER+s);if(c!==s&&s!==undefined){if(c>=0){U.shiftElement(e,c,s);}else if(u>-1){e[u]=a;}else if(U.isUnknown(e[s])){e[s]=a;}}};
U.shiftElement=function(e,o,n){e.splice(n,0,e.splice(o,1)[0]);};
U.isUnknown=function(v){if(v!==undefined&&v.indexOf(U.PLACEHOLDER)===0){var r=v.slice(1,v.length);var p=parseInt(r);if(isNaN(p)){return false;}return true;}return false;};
return U;});
sap.ui.predefine('sap/ui/fl/write/_internal/condenser/classifications/Create',["sap/ui/core/Core","sap/ui/fl/write/_internal/condenser/Utils"],function(C,a){"use strict";return{addToReconstructionMap:function(u,c){var A=C.byId(c.affectedControl);var s=A&&A.sParentAggregationName||c.targetAggregation;var t=a.getContainerElementIds(c.targetContainer,s);var b=a.getInitialUIContainerElementIds(u,c.targetContainer,c.targetAggregation,t);var i=b.indexOf(c.affectedControl);if(i>-1){b.splice(i,1);}},simulate:function(c,o){c.splice(o.getTargetIndex(o.change),0,o.affectedControl);}};});
sap.ui.predefine('sap/ui/fl/write/_internal/condenser/classifications/Destroy',["sap/ui/fl/write/_internal/condenser/Utils"],function(C){"use strict";return{addToReconstructionMap:function(u,c){var t=C.getContainerElementIds(c.targetContainer,c.targetAggregation);var a=C.getInitialUIContainerElementIds(u,c.targetContainer,c.targetAggregation,t);if(a.length-1<c.sourceIndex){while(a.length-1<c.sourceIndex){var i=a.length;a.splice(a.length,0,C.PLACEHOLDER+i);}a[c.sourceIndex]=c.affectedControl;}else{a.splice(c.sourceIndex,0,c.affectedControl);}},simulate:function(c,o,i){var I=c.indexOf(o.affectedControl);if(I===-1){var u=C.PLACEHOLDER+i.indexOf(o.affectedControl);I=c.indexOf(u);}if(I>-1){c.splice(I,1);}}};});
sap.ui.predefine('sap/ui/fl/write/_internal/condenser/classifications/LastOneWins',[],function(){"use strict";return{addToChangesMap:function(p,u,c){if(!p[u]){p[u]=[c];}}};});
sap.ui.predefine('sap/ui/fl/write/_internal/condenser/classifications/Move',["sap/ui/fl/write/_internal/condenser/Utils"],function(C){"use strict";return{addToReconstructionMap:function(u,c){var s=C.getContainerElementIds(c.sourceContainer,c.sourceAggregation);var t=C.getContainerElementIds(c.targetContainer,c.targetAggregation);var a;var T;if(c.targetContainer===c.sourceContainer&&c.targetAggregation===c.sourceAggregation){a=C.getInitialUIContainerElementIds(u,c.targetContainer,c.targetAggregation,t);T=a.indexOf(c.affectedControl);C.shiftElement(a,T,c.sourceIndex);}else{a=C.getInitialUIContainerElementIds(u,c.targetContainer,c.targetAggregation,t);T=a.indexOf(c.affectedControl);a.splice(T,1);a=C.getInitialUIContainerElementIds(u,c.sourceContainer,c.sourceAggregation,s);a.splice(c.sourceIndex,0,c.affectedControl);}},simulate:function(c,o,i){var a=o.affectedControl;var s=i.indexOf(a);C.extendElementsArray(c,s,undefined,a);}};});
sap.ui.predefine('sap/ui/fl/write/_internal/condenser/classifications/Reverse',["sap/base/util/each"],function(e){"use strict";return{addToChangesMap:function(p,u,c){if(!p[u]){p[u]=[];}p[u].push(c);},getChangesFromMap:function(o,u){var c=[];e(o[u],function(k,r){r.reverse();var C;r.forEach(function(a){if(C&&C.getChangeType()!==a.getChangeType()){C=null;}else{C=a;}});if(C){c.push(C);}});return c;}};});
sap.ui.predefine('sap/ui/fl/write/_internal/extensionPoint/Processor',["sap/ui/fl/apply/_internal/extensionPoint/Processor","sap/base/util/merge"],function(A,m){"use strict";var P={applyExtensionPoint:function(e){var E=m({defaultContent:[]},e);return A.registerExtensionPoint(E).then(A.createDefaultContent.bind(this,e,[])).then(A.addDefaultContentToExtensionPointInfo.bind(this,E));}};return P;});
sap.ui.predefine('sap/ui/fl/write/_internal/extensionPoint/Registry',["sap/ui/base/ManagedObjectObserver","sap/ui/core/util/reflection/JsControlTreeModifier"],function(M,J){"use strict";var E={};var o={};var e=[];var m={};
function a(f){var p=f.object.getId();e[p].forEach(function(g){delete m[g.view.getId()][g.name];});delete o[p];delete e[p];}
function b(f){var p=f.object.getId();e[p].forEach(function(g){var A=g.aggregationName;if(A===f.name){var C=J.getAggregation(f.object,A).map(function(h){return h.getId();});if(f.mutation==="insert"){if(C.indexOf(f.child.getId())<g.index){g.index++;}}else if(g.aggregation.indexOf(f.child.getId())<g.index){g.index--;}g.aggregation=C;}});}
function c(f){if(f.type==="destroy"){a(f);}else{b(f);}}
function s(p,A){var P=p.getId();if(!o[P]){var O=new M(c.bind(this));O.observe(p,{aggregations:[A],destroy:true});o[P]={observer:O,aggregations:[A]};}else{var i=o[P].observer.isObserved(p,{aggregations:[A]});if(!i){o[P].aggregations.push(A);o[P].observer.observe(p,{aggregations:o[P].aggregations,destroy:true});}}}
function d(p,A,f){var v=f.view.getId();var g=J.getAggregation(p,A);var C=[].concat(g||[]).map(function(h){return h.getId();});var P=p.getId();if(!e[P]){e[P]=[];}if(!m[v]){m[v]={};}f.aggregation=C;e[P].push(f);m[v][f.name]=f;}
E.registerExtensionPoint=function(f){var p=f.targetControl;var A=f.aggregationName;s(p,A);d(p,A,f);};
E.getExtensionPointInfo=function(f,v){return m[v.getId()]&&m[v.getId()][f];};
E.getExtensionPointInfoByParentId=function(p){return e[p]||[];};
E.clear=function(){Object.keys(o).forEach(function(p){o[p].observer.disconnect();o[p].observer.destroy();});o={};e=[];m={};};
return E;},true);
sap.ui.predefine('sap/ui/fl/write/_internal/transport/TransportDialog',["sap/m/List","sap/m/InputListItem","sap/m/Button","sap/m/ComboBox","sap/m/Dialog","sap/m/Input","sap/m/MessageToast","sap/ui/core/ListItem","sap/ui/fl/write/_internal/transport/Transports"],function(L,I,B,C,D,a,M,b,T){"use strict";
var c=D.extend("sap.ui.fl.write._internal.transport.TransportDialog",{
metadata:{library:"sap.ui.fl",properties:{pkg:{type:"string",group:"Misc",defaultValue:null},transports:{type:"any",group:"Misc",defaultValue:null},lrepObject:{type:"any",group:"Misc",defaultValue:null},hidePackage:{type:"boolean",group:"Misc",defaultValue:null}},events:{ok:{},cancel:{}}},
renderer:{}
});
c.prototype.init=function(){D.prototype.init.apply(this);this._oResources=sap.ui.getCore().getLibraryResourceBundle("sap.ui.fl");this.setTitle(this._oResources.getText("TRANSPORT_DIALOG_TITLE"));this._oPackageLabel=null;this._oPackage=this._createPackageField();this._oTransport=this._createTransportCombo();this.addContent(this._createContentList());this._createButtons();this.setEscapeHandler(function(p){this.fireCancel();p.resolve();}.bind(this));};
c.prototype._createContentList=function(){this._oPackageListItem=new I({label:this._oResources.getText("TRANSPORT_DIALOG_PACKAGE"),content:[this._oPackage]});this._oTransportListItem=new I({label:this._oResources.getText("TRANSPORT_DIALOG_TRANSPORT"),content:[this._oTransport]});return new L({items:[this._oPackageListItem,this._oTransportListItem]});};
c.prototype._createButtons=function(){var t=this;this.addButton(new B({text:this._oResources.getText("TRANSPORT_DIALOG_LOCAL_OBJECT"),tooltip:this._oResources.getText("TRANSPORT_DIALOG_LOCAL_OBJECT"),press:function(){t._onLocal();}}));this.addButton(new B({text:this._oResources.getText("TRANSPORT_DIALOG_OK"),tooltip:this._oResources.getText("TRANSPORT_DIALOG_OK"),enabled:false,press:function(){t._onOkay();}}));this.addButton(new B({text:this._oResources.getText("TRANSPORT_DIALOG_CANCEL"),tooltip:this._oResources.getText("TRANSPORT_DIALOG_CANCEL"),press:function(){t.fireCancel();t.close();t.destroy();}}));};
c.prototype._onLocal=function(){this.fireOk({selectedTransport:"",selectedPackage:this.getPkg()||"$TMP",dialog:true});this.close();this.destroy();};
c.prototype._onOkay=function(){var t=this._oTransport.getSelectedKey();if(this._checkOkay(t)){this.fireOk({selectedTransport:t,selectedPackage:this.getPkg()||this._oPackage.getValue(),dialog:true});this.close();this.destroy();}else{this.getButtons()[1].setEnabled(false);this._oTransport.setValueState(sap.ui.core.ValueState.Error);this._oTransport.setValueStateText(this.getTitle());}};
c.prototype._checkOkay=function(t){if(t){return true;}return false;};
c.prototype._createTransportCombo=function(){var t=this;return new C({showSecondaryValues:true,enabled:false,tooltip:this._oResources.getText("TRANSPORT_DIALOG_TRANSPORT_TT"),width:"100%",selectionChange:function(){if(t._oPackageListItem.getVisible()&&!t._oPackage.getValue()){return;}t.getButtons()[1].setEnabled(true);t._oTransport.setValueState(sap.ui.core.ValueState.None);},change:function(e){var f=function(i){if((i&&e.mParameters.newValue!==i.getText())||!i){return true;}return false;};if(e&&e.mParameters&&e.mParameters.newValue){if(f(t._oTransport.getSelectedItem())){t.getButtons()[1].setEnabled(false);t._oTransport.setValueState(sap.ui.core.ValueState.Error);t._oTransport.setValueStateText(t._oResources.getText("TRANSPORT_DIALOG_TRANSPORT_TT"));}}}});};
c.prototype._createPackageField=function(){var t=this;return new a({tooltip:this._oResources.getText("TRANSPORT_DIALOG_PACKAGE_TT"),width:"100%",change:function(){var p;var o;o=t._createObjectInfo();p=T.getTransports(o);p.then(function(r){t._onPackageChangeSuccess(r);},function(r){t._onPackageChangeError(r);});},liveChange:function(e){if(e.mParameters.liveValue&&e.mParameters.liveValue.length>3){t._oTransport.setEnabled(true);}}});};
c.prototype._createObjectInfo=function(){var o;var r={"package":this._oPackage.getValue()||""};o=this.getProperty("lrepObject");if(o){if(o.name){r.name=o.name;}if(o.type){r.type=o.type;}if(o.namespace){r.namespace=o.namespace;}}return r;};
c.prototype._onPackageChangeSuccess=function(t){if(t){if(t.localonly){this._oTransport.setEnabled(false);this.getButtons()[1].setEnabled(true);}else if(t.transports&&t.transports.length>0){this._oTransport.setEnabled(true);this._setTransports(t);}else if(t.errorCode){this.getButtons()[1].setEnabled(false);this._oPackage.setValueState(sap.ui.core.ValueState.Error);this._oPackage.setValueStateText(this._oResources.getText("TRANSPORT_DIALOG_"+t.errorCode));this._setTransports(t);}else{M.show(this._oResources.getText("TRANSPORT_DIALOG_NO_TRANSPORTS"));}}};
c.prototype._setTransports=function(t){var l;var d;l=this._hasLock(t.transports);if(l){d=[l];}else{d=t.transports;}this.setTransports(d);if(d&&d.length===1){this._oTransport.setValue(d[0].description,true);this.getButtons()[1].setEnabled(true);}if(!d||d.length===0){this._oTransport.setSelectedKey(null);this._oTransport.setValueState(sap.ui.core.ValueState.None);this.getButtons()[1].setEnabled(false);}};
c.prototype._onPackageChangeError=function(r){M.show(r);this.setTransports([]);};
c.prototype._hasLock=function(t){var o;var l=t.length;while(l--){o=t[l];if(o.locked){return o;}}return null;};
c.prototype.setPkg=function(p){if(p&&!this.getProperty("pkg")){this.setProperty("pkg",p);this._oPackage.setValue(p);this._oPackage.setEnabled(false);this._oTransport.setEnabled(true);this.setTitle(this._oResources.getText("TRANSPORT_DIALOG_TITLE_SIMPLE"));this.getButtons()[0].setVisible(false);}return this;};
c.prototype.setTransports=function(s){var i;var l=0;var o;if(s){this.setProperty("transports",s);this._oTransport.removeAllItems();l=s.length;for(i=0;i<l;i++){o=s[i];this._oTransport.addItem(new b({key:o.transportId,text:o.transportId,additionalText:o.description}));}if(l===1){this._oTransport.setSelectedKey(s[0].transportId);this.getButtons()[1].setEnabled(true);}if(l>0){this._oTransport.setEnabled(true);}}return this;};
c.prototype.setLrepObject=function(o){if(o&&!this.getProperty("lrepObject")){this.setProperty("lrepObject",o);}return this;};
c.prototype.setHidePackage=function(h){this.setProperty("hidePackage",h);this._oPackageListItem.setVisible(!h);if(h){this.getButtons()[0].setEnabled(h);this.setTitle(this._oResources.getText("TRANSPORT_DIALOG_TITLE_SIMPLE"));}return this;};
return c;},true);
sap.ui.predefine('sap/ui/fl/write/_internal/transport/TransportSelection',["sap/ui/fl/Utils","sap/ui/fl/LayerUtils","sap/ui/fl/Layer","sap/ui/fl/write/_internal/transport/Transports","sap/ui/fl/write/_internal/transport/TransportDialog","sap/ui/fl/registry/Settings","sap/ui/core/BusyIndicator"],function(F,L,a,T,b,c,B){"use strict";var d=function(){};
d.prototype.selectTransport=function(o,O,e,C,f,s){if(!F.getLrepUrl()){O(this._createEventObject(o,{transportId:""}));return;}var r=function(o,O,e,C,s,A){T.getTransports(o).then(function(g){if(this._checkDialog(g,A)){this._openDialog({hidePackage:!L.doesCurrentLayerRequirePackage(),pkg:o.package,transports:g.transports,lrepObject:this._toLREPObject(o)},O,e,C,s);}else{var t=(!g.localonly&&A)?{transportId:"ATO_NOTIFICATION"}:this._getTransport(g);O(this._createEventObject(o,t));}}.bind(this),function(R){e(R);});};var l=L.getCurrentLayer(false);if(l&&((l===a.CUSTOMER)||(l===a.CUSTOMER_BASE))){c.getInstance().then(function(S){if(S.isAtoEnabled()){if(!(o&&o.name&&o.namespace&&o.type)){var t={transportId:"ATO_NOTIFICATION"};O(this._createEventObject(o,t));}else{r.apply(this,[o,O,e,C,s,true]);}}else{r.apply(this,[o,O,e,C,s,false]);}}.bind(this));}else{r.apply(this,[o,O,e,C,s,false]);}};
d.prototype._createEventObject=function(o,t){return{mParameters:{selectedTransport:t.transportId,selectedPackage:o["package"],dialog:false},getParameters:function(){return this.mParameters;},getParameter:function(n){return this.mParameters[n];}};};
d.prototype._toLREPObject=function(o){var O={};if(o.namespace){O.namespace=o.namespace;}if(o.name){O.name=o.name;}if(o.type){O.type=o.type;}return O;};
d.prototype._openDialog=function(C,o,e,f,s){var D=new b(C);D.attachOk(o);D.attachCancel(e);D.addStyleClass(s);if(f){D.addStyleClass("sapUiSizeCompact");}else{D.removeStyleClass("sapUiSizeCompact");}D.open();B.hide();return D;};
d.prototype._getTransport=function(t){var o;if(!t.localonly){o=this._hasLock(t.transports);}else{o={transportId:""};}return o;};
d.prototype._checkDialog=function(t,A){if(t){if(t.localonly||this._hasLock(t.transports)||(!t.localonly&&A)){return false;}}return true;};
d.prototype._hasLock=function(t){var l=t.length;while(l--){var o=t[l];if(o.locked){return o;}}return false;};
d.prototype.setTransports=function(C,o){var i=C.length-1;var t=this;var s=function(C,i,o,e,f){if(i>=0){var g=C[i];if(f===true){if(g.getDefinition().packageName!=="$TMP"){g.setRequest(e);}i--;return s(C,i,o,e,f);}if(g.getDefinition().packageName!=="$TMP"){return t.openTransportSelection(g,o).then(function(h){if(h==="cancel"){return Promise.reject("cancel");}g.setRequest(h.transport);if(h.fromDialog===true){e=h.transport;f=true;}i--;return s(C,i,o,e,f);},function(){return null;});}i--;return s(C,i,o,e,f);}return Promise.resolve();};return s(C,i,o);};
d.prototype.openTransportSelection=function(C,o,s){var t=this;return new Promise(function(r,e){var O=function(R){if(R&&R.getParameters){var g=R.getParameters().selectedTransport;var p=R.getParameters().selectedPackage;var h=R.getParameters().dialog;var i={transport:g,packageName:p,fromDialog:h};r(i);}else{r({});}};var E=function(g){if(g.sId==='cancel'){r(g.sId);}else{e(g);}};var f={};if(C){f["package"]=C.getPackage();f.namespace=C.getNamespace();f.name=C.getId();f.type=C.getDefinition().fileType;}t.selectTransport(f,O,E,false,o,s);});};
d.prototype.checkTransportInfo=function(t){return t&&t.transport&&t.packageName!=="$TMP";};
d.prototype._prepareChangesForTransport=function(t,A,e,C){var f=T.convertToChangeTransportData(A,e);var o={};o.package=t.packageName;o.transportId=t.transport;o.changeIds=f;o.reference=C.reference;o.layer=C.layer;return T.makeChangesTransportable(o).then(function(){A.forEach(function(g){if(g.getPackage()==='$TMP'){var D=g.getDefinition();D.packageName=t.packageName;g.setResponse(D);}});});};
return d;},true);
sap.ui.predefine('sap/ui/fl/write/_internal/transport/Transports',["sap/ui/fl/initial/_internal/connectors/LrepConnector","sap/ui/fl/Utils","sap/ui/fl/initial/_internal/connectors/Utils","sap/ui/fl/write/_internal/connectors/Utils"],function(A,F,I,W){"use strict";var R={ACTION_GET_TRANSPORTS:"/actions/gettransports/",ACTION_MAKE_CHANGE_TRANSPORTABLE:"/actions/make_changes_transportable/",ACTION_GET_TOKEN:"/actions/getcsrftoken/"};return{getTransports:function(p){if(F.getClient()){p["sap-client"]=F.getClient();}var g=I.getUrl(R.ACTION_GET_TRANSPORTS,{url:F.getLrepUrl()},p);g=decodeURIComponent(g);return I.sendRequest(g,"GET").then(function(r){if(r.response){if(!r.response.localonly){r.response.localonly=false;}if(!r.response.errorCode){r.response.errorCode="";}return Promise.resolve(r.response);}return Promise.reject('response is empty');});},makeChangesTransportable:function(p){if(!p.transportId){return Promise.reject(new Error("no transportId provided as attribute of mParameters"));}if(!p.changeIds){return Promise.reject(new Error("no changeIds provided as attribute of mParameters"));}if(!p.reference){return Promise.reject(new Error("no reference provided as attribute of mParameters"));}var u=F.getClient()?{"sap-client":F.getClient()}:{};var m=I.getUrl(R.ACTION_MAKE_CHANGE_TRANSPORTABLE,{url:F.getLrepUrl()},u);var t=I.getUrl(R.ACTION_GET_TOKEN,{url:F.getLrepUrl()});var r=W.getRequestOptions(A,t,p,"application/json; charset=utf-8","json");return W.sendRequest(m,"POST",r);},convertToChangeTransportData:function(l,a){var t=[];var i;if(a&&a.length){for(i=0;i<a.length;i++){var o=a[i];var p={};p.namespace=o.getNamespace();p.fileName=o.getDefinition().fileName;p.fileType=o.getDefinition().fileType;t.push(p);}}var b=l.length;for(i=0;i<b;i++){var c=l[i];var d={};d.namespace=c.getNamespace();d.fileName=c.getId();d.fileType=c.getDefinition().fileType;t.push(d);}return t;}};},true);
sap.ui.require.preload({
	"sap/ui/fl/manifest.json":'{"_version":"1.21.0","sap.app":{"id":"sap.ui.fl","type":"library","embeds":["support/apps/contentbrowser","support/apps/uiFlexibilityDiagnostics"],"applicationVersion":{"version":"1.84.0"},"title":"SAPUI5 library with sap.ui.fl controls.","description":"SAPUI5 library with sap.ui.fl controls.","ach":"CA-UI5-FL","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.84","libs":{"sap.ui.core":{"minVersion":"1.84.0"},"sap.m":{"minVersion":"1.84.0"}}},"library":{"i18n":{"bundleUrl":"messagebundle.properties","supportedLocales":["","ar","bg","ca","cs","da","de","el","en","en-GB","en-US-sappsd","en-US-saptrc","es","es-MX","et","fi","fr","hi","hr","hu","it","iw","ja","kk","ko","lt","lv","ms","nl","no","pl","pt","rigi","ro","ru","sh","sk","sl","sv","th","tr","uk","vi","zh-CN","zh-TW"]},"content":{"controls":["sap.ui.fl.variants.VariantManagement","sap.ui.fl.util.IFrame"]}}}}'
},"sap/ui/fl/library-preload"
);
//# sourceMappingURL=library-preload.js.map