/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/integration/library","sap/ui/core/library","sap/ui/dom/includeScript","sap/ui/integration/cards/BaseContent","sap/ui/integration/thirdparty/adaptivecards","sap/ui/integration/thirdparty/adaptivecards-templating","sap/ui/integration/thirdparty/markdown-it","sap/ui/integration/cards/adaptivecards/elements/UI5InputText","sap/ui/integration/cards/adaptivecards/elements/UI5InputNumber","sap/ui/integration/cards/adaptivecards/elements/UI5InputChoiceSet","sap/ui/integration/cards/adaptivecards/elements/UI5InputTime","sap/ui/integration/cards/adaptivecards/elements/UI5InputDate","sap/ui/integration/cards/adaptivecards/elements/UI5InputToggle","sap/ui/integration/cards/adaptivecards/overwrites/ActionRender","sap/ui/integration/cards/adaptivecards/elements/hostConfig","sap/m/VBox","sap/m/MessageStrip","sap/ui/core/HTML","sap/ui/core/Core","sap/ui/model/json/JSONModel","sap/base/Log","sap/ui/integration/util/LoadingProvider","sap/ui/Device"],function(l,c,i,B,A,a,M,U,b,d,e,f,g,h,H,V,j,k,C,J,L,m,D){"use strict";var n=c.MessageType;var o=B.extend("sap.ui.integration.cards.AdaptiveContent",{metadata:{library:"sap.ui.integration"},renderer:{apiVersion:2,render:function(r,p){var P=B.getMetadata().getRenderer();return P.render.apply(this,arguments);}}});o.prototype.init=function(){this.setComponentsReady(false);this._bAdaptiveCardElementsReady=false;this._setupCardContent();this._setupAdaptiveCardDependency();this._loadDependencies();this._oLoadingProvider=new m();};o.prototype.onAfterRendering=function(){this._renderMSCardContent(this._oCardTemplate||this._oCardConfig);};o.prototype._setupCardContent=function(){var p=new j(this.getId()+"-message",{showCloseButton:true,visible:false}),q=new k(this.getId()+"content",{preferDOM:false,content:"<div>&nbsp;</div>"});p.addStyleClass("sapUiTinyMargin");this.setAggregation("_content",new V({items:[p,q]}));};o.prototype.setConfiguration=function(p){this._oCardConfig=p;if(p&&p.request&&p.request.url){this._loadManifestFromUrl(p.request.url);return;}this._handleMarkDown();this._setupMSCardContent();};o.prototype.getConfiguration=function(){return this._oCardConfig;};o.prototype._handleMarkDown=function(){var t=this;A.AdaptiveCard.onProcessMarkdown=function(T,r){var p=t.getParent(),E=p&&p.getManifestEntry("/sap.card/configuration/enableMarkdown");if(E){r.outputHtml=new M().render(T);r.didProcess=true;return r;}};};o.prototype._loadManifestFromUrl=function(u){var p=new J(),t=this;p.loadData(u).then(function(){t._oCardConfig=Object.assign(t._oCardConfig,p.getData());}).then(function(){t._handleMarkDown();t._setupMSCardContent();}).then(function(){p.destroy();p=null;}).catch(function(){L.error("No JSON file found on this URL. Please provide a correct path to the JSON-serialized card object model file.");});};o.prototype._setupAdaptiveCardDependency=function(){this.adaptiveCardInstance=new A.AdaptiveCard();this._doMSCardsOverwrites();this._adjustHostConfig();this._handleActions();this._replaceElements();this._isRtl();};o.prototype._doMSCardsOverwrites=function(){A.Action.prototype.render=h;};o.prototype._adjustHostConfig=function(){this.adaptiveCardInstance.hostConfig=new A.HostConfig(H);};o.prototype._isRtl=function(){this.adaptiveCardInstance.isRtl=function(){return C.getConfiguration().getRTL();};};o.prototype._handleActions=function(){this.adaptiveCardInstance.onExecuteAction=function(p){var t,P,q;if(p instanceof A.OpenUrlAction){P={url:p.url};t=l.CardActionType.Navigation;}else if(p instanceof A.SubmitAction){P={data:p.data};t=l.CardActionType.Submit;}else{return;}q=this.getActions();if(q){q.fireAction(this,t,P);}}.bind(this);};o.prototype.onActionSubmitStart=function(F){this.getParent().setBusy(true);};o.prototype.onActionSubmitEnd=function(r,E){var R=C.getLibraryResourceBundle("sap.ui.integration"),s=E?R.getText("CARDS_ADAPTIVE_ACTION_SUBMIT_ERROR"):R.getText("CARDS_ADAPTIVE_ACTION_SUBMIT_SUCCESS"),p=E?n.Error:n.Success;this.showMessage(s,p);this.getParent().setBusy(false);};o.prototype.showMessage=function(s,t){var p=this.getAggregation("_content").getItems()[0];p.applySettings({"type":t,"text":s,"visible":true});};o.prototype._replaceElements=function(){A.AdaptiveCard.elementTypeRegistry.unregisterType("Input.Text");A.AdaptiveCard.elementTypeRegistry.registerType("Input.Text",function(){return new U();});A.AdaptiveCard.elementTypeRegistry.unregisterType("Input.Number");A.AdaptiveCard.elementTypeRegistry.registerType("Input.Number",function(){return new b();});A.AdaptiveCard.elementTypeRegistry.unregisterType("Input.ChoiceSet");A.AdaptiveCard.elementTypeRegistry.registerType("Input.ChoiceSet",function(){return new d();});A.AdaptiveCard.elementTypeRegistry.unregisterType("Input.Time");A.AdaptiveCard.elementTypeRegistry.registerType("Input.Time",function(){return new e();});A.AdaptiveCard.elementTypeRegistry.unregisterType("Input.Date");A.AdaptiveCard.elementTypeRegistry.registerType("Input.Date",function(){return new f();});A.AdaptiveCard.elementTypeRegistry.unregisterType("Input.Toggle");A.AdaptiveCard.elementTypeRegistry.registerType("Input.Toggle",function(){return new g();});};o.prototype.setCardDataProvider=function(p){this._oCardDataProvider=p;};o.prototype._setupMSCardContent=function(){var p=this._oCardConfig,q,r=this._oCardDataProvider;if(!this.adaptiveCardInstance||!p){return;}q=p.$data||p.data;if(!q&&!r){this._oCardTemplate=null;this._renderMSCardContent(p);return;}if(p.$data){q={"json":q};}this._setDataConfiguration(q);};o.prototype.onDataChanged=function(){var p=this.getBindingContext().getPath(),q=this.getModel().getProperty(p);this._oCardTemplate=this._setTemplating(this._oCardConfig,q);this._oLoadingProvider.setLoading(false);this.invalidate();};o.prototype._renderMSCardContent=function(p){var q=this.getAggregation("_content").getItems()[1].$(),I=!!this.isLoading();this.setBusy(I);this.getAggregation("_content").toggleStyleClass("sapFCardContentHidden",I);if(this.adaptiveCardInstance&&p&&q.length){this.adaptiveCardInstance.parse(p);q.html(this.adaptiveCardInstance.render());this._bAdaptiveCardElementsReady=true;this._fireCardReadyEvent();if(this.adaptiveCardInstance.renderedElement){this.adaptiveCardInstance.renderedElement.tabIndex=-1;}}};o.prototype._fireCardReadyEvent=function(){if(this._bAdaptiveCardElementsReady&&this.getComponentsReady()){this._bReady=true;this.fireEvent("_ready");}};o.prototype._setTemplating=function(t,p){var q=new a.Template(t),r=new a.EvaluationContext();r.$root=p;return q.expand(r);};o.prototype._loadDependencies=function(){if(this.getComponentsReady()){L.debug("WebComponents were already loaded");this._fireCardReadyEvent();return;}if(window.customElements){window.customElements.whenDefined("ui5-button").then(function(){if(!this.getComponentsReady()){this.setComponentsReady(true);this._fireCardReadyEvent();}}.bind(this));}setTimeout(function(){if(this.getComponentsReady()){L.debug("WebComponents were already loaded");return;}i({id:"webcomponents-loader",url:sap.ui.require.toUrl("sap/ui/integration/thirdparty/webcomponents/webcomponentsjs/webcomponents-loader.js")});}.bind(this));document.addEventListener("WebComponentsReady",function(){if(this.getComponentsReady()){L.debug("WebComponents were already loaded");return;}if(D.browser.edge||D.browser.msie){i({id:"webcomponents-bundle-es5",url:sap.ui.require.toUrl("sap/ui/integration/thirdparty/webcomponents/bundle.es5.js")});}else{i({id:"webcomponents-bundle",attributes:{type:"module"},url:sap.ui.require.toUrl("sap/ui/integration/thirdparty/webcomponents/bundle.esm.js")});}this.setComponentsReady(true);this._fireCardReadyEvent();}.bind(this));};o.prototype.setComponentsReady=function(v){this._bComponentsReady=v;return this;};o.prototype.getComponentsReady=function(){return!!this._bComponentsReady;};return o;});
