/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./CalendarContentRenderer",'sap/ui/core/ResizeHandler',"sap/ui/integration/library","sap/ui/integration/cards/BaseContent","sap/ui/integration/util/BindingHelper","sap/ui/integration/util/BindingResolver","sap/f/CalendarInCard","sap/f/PlanningCalendarInCardLegend","sap/m/library","sap/m/Button","sap/m/FlexBox",'sap/ui/core/format/DateFormat',"sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/unified/CalendarAppointment","sap/ui/unified/DateTypeRange","sap/ui/core/date/UniversalDate","sap/ui/unified/CalendarLegendItem"],function(C,R,l,B,a,b,c,P,L,d,F,D,e,f,g,h,U,j){"use strict";var A=l.AreaType;var k=B.extend("sap.ui.integration.cards.CalendarContent",{renderer:C,metadata:{library:"sap.ui.integration",properties:{visibleAppointmentsCount:{type:"int",group:"Data",defaultValue:2},noAppointmentsText:{type:"string",group:"Misc",defaultValue:null}},aggregations:{appointments:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"appointment"}}}});k.prototype._createCardContent=function(){this._oCalendar=new c(this.getId()+"-navigation",{select:function(E){var s=E.getSource().getSelectedDates()[0].getStartDate();this._setParameters(E,E.getParameter("startDate"));this._refreshVisibleAppointments(s);this.invalidate();}.bind(this)});this._oLegend=new P(this.getId()+"-legend",{columnWidth:"7.5rem",standardItems:[]});this._oContent=new F(this.getId()+"-wrapper",{items:[this._oCalendar,this._oLegend]});this.setAggregation("_content",this._oContent);this._oFormatAria=D.getDateTimeInstance({pattern:"EEEE dd/MM/YYYY 'at' "+_.call(this).getTimePattern("medium")});};k.prototype.init=function(){this._aVisibleAppointments=[];B.prototype.init.apply(this,arguments);this._createCardContent();this.fireEvent("_actionContentReady");};k.prototype.exit=function(){if(this._sTwoColumnsResizeListener){R.deregister(this._sTwoColumnsResizeListener);this._sTwoColumnsResizeListener=undefined;}B.prototype.exit.apply(this,arguments);if(this._oAppointmentTemplate){this._oAppointmentTemplate.destroy();this._oAppointmentTemplate=null;}if(this._oSpecialDateTemplate){this._oSpecialDateTemplate.destroy();this._oSpecialDateTemplate=null;}if(this._oCalendarLegendItemTemplate){this._oCalendarLegendItemTemplate.destroy();this._oCalendarLegendItemTemplate=null;}if(this._oAppointmentLegendItemTemplate){this._oAppointmentLegendItemTemplate.destroy();this._oAppointmentLegendItemTemplate=null;}if(this._oActions){this._oActions.destroy();this._oActions=null;}};k.prototype.onDataChanged=function(){this._setParameters();};k.prototype.onBeforeRendering=function(){var i=this._oCalendar.getSelectedDates().length?this._oCalendar.getSelectedDates()[0].getStartDate():this._oCalendar.getStartDate();this._refreshVisibleAppointments(i);this.getModel("parameters").setProperty("/visibleItems",this._iVisibleItems);this.getModel("parameters").setProperty("/allItems",this._iAllItems);};k.prototype.onAfterRendering=function(){B.prototype.onAfterRendering.call(this,arguments);if(!this._sTwoColumnsResizeListener){this._sTwoColumnsResizeListener=R.register(this,this.resizeHandler);this.resizeHandler({control:this,target:this.getDomRef()});}};k.prototype.resizeHandler=function(E){E.control.toggleStyleClass("sapMPCInCardTwoColumns",E.target.getBoundingClientRect().width>576);};k.prototype.setConfiguration=function(o){B.prototype.setConfiguration.apply(this,arguments);if(!o){return this;}if(o.item){this._addItem(o.item);}if(o.specialDate){this._addSpecialDate(o.specialDate);}if(o.legendItem){this._addLegendItem(o.legendItem);}if(o.date){this._addDate(o.date);}if(o.maxItems){this._addMaxItems(o.maxItems);}if(o.maxLegendItems){this._addMaxLegendItems(o.maxLegendItems);}if(o.noItemsText){this._addNoItemsText(o.noItemsText);}if(o.moreItems&&o.moreItems.actions){this._oActions.setAreaType(A.Content);this._oActions.attach(o.moreItems,this._getMoreButton());}return this;};k.prototype._setParameters=function(E,o){var i=this.getConfiguration&&this.getConfiguration(),I=i&&i.item&&i.item.path,n,s,p,M,q;if(o){n=o;}else if(this._oCalendar.getSelectedDates().length){n=this._oCalendar.getSelectedDates()[0].getStartDate();}else{n=this._oCalendar.getStartDate();}s=new Date(n.getFullYear(),n.getMonth(),n.getDate());p=new Date(n.getFullYear(),n.getMonth(),n.getDate());p.setDate(p.getDate()+1);q=I?this.getModel().getProperty(I).filter(function(r){var S=new Date(r.start).getTime(),t=new Date(r.end).getTime();if((S>=s.getTime()&&S<p.getTime())||(t>=s.getTime()&&t<p.getTime())||(S<=s.getTime()&&t>p.getTime())){return r;}}):[];this._iAllItems=q.length;if(i&&typeof i.maxItems==="object"){M=i&&this.getConfiguration().maxItems&&"/"+this.getConfiguration().maxItems.binding.getPath();this._iMaxItems=this.getModel().getProperty(M);}else{this._iMaxItems=i&&this.getConfiguration().maxItems;}this._iVisibleItems=Math.min(this._iMaxItems,this._iAllItems);if(this.getModel("parameters")){this.getModel("parameters").setProperty("/visibleItems",this._iVisibleItems);this.getModel("parameters").setProperty("/allItems",this._iAllItems);}};k.prototype._refreshVisibleAppointments=function(s){this._aVisibleAppointments=this._calculateVisibleAppointments(this.getAppointments(),s);};k.prototype._calculateVisibleAppointments=function(i,s){var I=this._isAppointmentInSelectedDate(s);var t=function(o,n){var E=o.getEndDate(),N=new Date();if(s.getDate()===N.getDate()&&s.getMonth()===N.getMonth()&&s.getFullYear()===N.getFullYear()){return this._iAllItems-n<this._iVisibleItems||E.getTime()>N.getTime();}return true;};var r=i.filter(I,this).sort(this._sortByStartHourCB).filter(t,this).slice(0,this._iVisibleItems);return r;};k.prototype._sortByStartHourCB=function(o,i){return o.getStartDate().getTime()-i.getStartDate().getTime()||i.getEndDate().getTime()-o.getEndDate().getTime();};k.prototype._isAppointmentInSelectedDate=function(s){return function(o){var i=o.getStartDate().getTime(),n=o.getEndDate().getTime(),S=s.getTime(),p=U.getInstance(new Date(s.getTime())),q,r,t,E;p.setDate(p.getDate()+1);q=p.getTime();r=i<S&&n>q;t=i>=S&&i<q;E=n>S&&n<=q;return r||t||E;};};k.prototype._getVisibleAppointments=function(){return this._aVisibleAppointments;};k.prototype.formatDate=function(t){var o=D.getDateTimeInstance({pattern:"yyyy-MM-dd'T'HH:mm:ss.SSSXXX"}).parse(t);if(!o){o=D.getInstance({pattern:"yyyy-MM-dd"}).parse(t);}return o;};k.prototype._addItem=function(i){var n={title:i.template.title,text:i.template.text,type:i.template.type},o;if(i.template.startDate){n.startDate=a.formattedProperty(i.template.startDate,this.formatDate);}if(i.template.endDate){n.endDate=a.formattedProperty(i.template.endDate,this.formatDate);}if(i.template.icon&&i.template.icon.src){n.icon=a.formattedProperty(i.template.icon.src,function(v){return this._oIconFormatter.formatSrc(v,this._sAppId);}.bind(this));}this._oAppointmentTemplate=new g(n);o={path:i.path,template:this._oAppointmentTemplate};this._bindAggregationToControl("appointments",this,o);};k.prototype._addSpecialDate=function(s){var S=s.template,o;if(S.startDate){S.startDate=a.formattedProperty(S.startDate,this.formatDate);}if(S.endDate){S.endDate=a.formattedProperty(S.endDate,this.formatDate);}this._oSpecialDateTemplate=new h(S);o={path:s.path,template:this._oSpecialDateTemplate};this._bindAggregationToControl("specialDates",this._oCalendar,o);};k.prototype._addLegendItem=function(i){var n={text:i.template.text,type:i.template.type},o={text:i.template.text,type:i.template.type},p,q;this._oCalendarLegendItemTemplate=new j(n);p={path:i.path,template:this._oCalendarLegendItemTemplate,filters:new e({path:"category",operator:f.Contains,value1:"calendar"})};this._bindAggregationToControl("items",this._oLegend,p);this._oAppointmentLegendItemTemplate=new j(o);q={path:i.path,template:this._oAppointmentLegendItemTemplate,filters:new e({path:"category",operator:f.Contains,value1:"appointment"})};this._bindAggregationToControl("appointmentItems",this._oLegend,q);};k.prototype._addDate=function(t){if(b.isBindingInfo(t)){if(!t){return;}var o=new h();o.bindProperty("startDate",a.formattedProperty(t,this.formatDate));this._oCalendar.addSelectedDate(o);}else{this._oCalendar.addSelectedDate(new h({startDate:this.formatDate(t)}));}};k.prototype._addMaxItems=function(M){if(b.isBindingInfo(M)){M&&this.bindProperty("visibleAppointmentsCount",M);}else{this.setVisibleAppointmentsCount(M);}};k.prototype._addMaxLegendItems=function(M){if(b.isBindingInfo(M)){M&&this._oLegend.bindProperty("visibleLegendItemsCount",M);}else{this._oLegend.setVisibleLegendItemsCount(M);}};k.prototype._addNoItemsText=function(n){if(b.isBindingInfo(n)){n&&this.bindProperty("noAppointmentsText",n);}else{this.setNoAppointmentsText(n);}};k.prototype._getMoreButton=function(){if(!this._oMoreAppsButton){this._oMoreAppsButton=new d({text:"More"});}return this._oMoreAppsButton;};k.prototype._bNeedForMoreButton=function(){return this._iAllItems>this.getVisibleAppointmentsCount();};k.prototype._getCurrentAppointment=function(){var n=this._getVisibleAppointments(),N=new Date(),o,s,E,i,S=this._oCalendar.getSelectedDates().length?this._oCalendar.getSelectedDates()[0].getStartDate():this._oCalendar.getStartDate();if(S.getDate()===N.getDate()&&S.getMonth()===N.getMonth()&&S.getFullYear()===N.getFullYear()){for(i=n.length-1;i>=0;i--){o=n[i];s=o.getStartDate().getTime();E=o.getEndDate().getTime();if(N.getTime()>s&&N.getTime()<E){return o;}}}};function _(){if(!this._oLocaleData){var s=m.call(this);var o=new sap.ui.core.Locale(s);this._oLocaleData=sap.ui.core.LocaleData.getInstance(o);}return this._oLocaleData;}function m(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;}return k;});
