/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./BaseListContent","./ListContentRenderer","sap/m/library","sap/m/List","sap/ui/integration/library","sap/ui/integration/util/BindingHelper","sap/ui/integration/controls/Microchart","sap/ui/integration/controls/MicrochartLegend","sap/ui/integration/controls/ListContentItem"],function(B,L,l,a,b,c,M,d,e){"use strict";var A=b.AreaType;var f=l.AvatarSize;var g=l.AvatarColor;var h=B.extend("sap.ui.integration.cards.ListContent",{metadata:{aggregations:{_legend:{multiple:false,visibility:"hidden"}}},renderer:L});h.prototype.init=function(){B.prototype.init.apply(this,arguments);var o=this._getList();var t=this;this.setAggregation("_content",o);o.attachUpdateFinished(function(){if(t._iVisibleItems){var I=o.getItems();for(var i=t._iVisibleItems+1;i<I.length;i++){I[i].setVisible(false);}}});this._oItemTemplate=new e({iconDensityAware:false});};h.prototype.exit=function(){B.prototype.exit.apply(this,arguments);if(this._oItemTemplate){this._oItemTemplate.destroy();this._oItemTemplate=null;}};h.prototype.loadDependencies=function(C){if(!C||!C.item||!C.item.chart){return Promise.resolve();}return M.loadDependencies();};h.prototype.destroyPlaceholder=function(){var o=this.getAggregation("_legend");if(o){o.removeStyleClass("sapFCardContentHidden");}B.prototype.destroyPlaceholder.apply(this,arguments);};h.prototype.setConfiguration=function(C){B.prototype.setConfiguration.apply(this,arguments);if(!C){return this;}if(C.items){this._setStaticItems(C.items);return this;}if(C.item){this._setItem(C.item);}return this;};h.prototype.onDataChanged=function(){this._checkHiddenNavigationItems(this.getConfiguration().item);};h.prototype._getList=function(){if(this._bIsBeingDestroyed){return null;}if(!this._oList){this._oList=new a({id:this.getId()+"-list",growing:false,showNoData:false,showSeparators:"None"});}return this._oList;};h.prototype._setItem=function(i){var s={iconDensityAware:false,title:i.title&&(i.title.value||i.title),description:i.description&&(i.description.value||i.description),highlight:i.highlight,info:i.info&&i.info.value,infoState:i.info&&i.info.state};if(i.icon){s.icon=c.formattedProperty(i.icon.src,function(v){return this._oIconFormatter.formatSrc(v,this._sAppId);}.bind(this));s.iconAlt=i.icon.alt;s.iconDisplayShape=i.icon.shape;s.iconInitials=i.icon.text;if(s.title&&s.description){s.iconSize=f.S;}else{s.iconSize=f.XS;}s.iconSize=i.icon.size||s.iconSize;s.iconBackgroundColor=i.icon.backgroundColor||(i.icon.text?undefined:g.Transparent);}if(i.chart){s.microchart=this._createChartAndAddLegend(i.chart);}this._oItemTemplate=new e(s);this._oActions.setAreaType(A.ContentItem);this._oActions.attach(i,this);var o={template:this._oItemTemplate};this._filterHiddenNavigationItems(i,o);this._bindAggregationToControl("items",this._getList(),o);};h.prototype._createChartAndAddLegend=function(C){var o=M.create(C);this.destroyAggregation("_legend");if(C.type==="StackedBar"){var i=new d({chart:o.getChart()});i.initItemsTitles(C.bars,this.getBindingContext().getPath());this.setAggregation("_legend",i);}return o;};h.prototype._setStaticItems=function(i){var o=this._getList();i.forEach(function(I){var j=new e({iconDensityAware:false,title:I.title?I.title:"",description:I.description?I.description:"",icon:I.icon?I.icon:"",infoState:I.infoState?I.infoState:"None",info:I.info?I.info:"",highlight:I.highlight?I.highlight:"None"});if(I.action){j.setType("Navigation");if(I.action.url){j.attachPress(function(){window.open(I.action.url,I.target||"_blank");});}}o.addItem(j);});this.fireEvent("_actionContentReady");};h.prototype.getInnerList=function(){return this._getList();};return h;});
