/*!
* OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.define(["sap/ui/integration/library","sap/ui/integration/cards/BaseContent","sap/m/library","sap/m/HBox","sap/m/VBox","sap/m/Text","sap/m/Title","sap/m/Avatar","sap/m/Link","sap/m/Label","sap/ui/core/ResizeHandler","sap/ui/layout/AlignedFlowLayout","sap/ui/dom/units/Rem","sap/ui/integration/util/BindingHelper"],function(l,B,L,H,V,T,a,A,b,c,R,d,e,f){"use strict";var g=l.AreaType;var h=L.AvatarSize;var i=L.AvatarColor;var O=B.extend("sap.ui.integration.cards.ObjectContent",{metadata:{library:"sap.ui.integration"},renderer:{}});O.prototype._getRootContainer=function(){if(this._bIsBeingDestroyed){return null;}var o=this.getAggregation("_content");if(!o){o=new d();this.setAggregation("_content",o);}this._sResizeListenerId=R.register(o,this.onAlignedFlowLayoutResize.bind(this));o.addEventDelegate({"onAfterRendering":function(){this.getContent().forEach(function(E){if(!E.getVisible()){document.getElementById("sap-ui-invisible-"+E.getId()).parentElement.classList.add("sapFCardInvisibleContent");}});}},o);return o;};O.prototype.onAlignedFlowLayoutResize=function(E){if(E&&(E.size.width===E.oldSize.width)&&!E.control){return;}var C=E.control,m=C.getMinItemWidth(),n=C.getContent().length,M;if(m.lastIndexOf("rem")!==-1){M=e.toPx(m);}else if(m.lastIndexOf("px")!==-1){M=parseFloat(m);}var j=Math.floor(E.size.width/M);if(j>n){j=n;}if(this._iColsOld===j){return;}this._iColsOld=j;var k=j-1,r=Math.ceil(n/j);C.getContent().forEach(function(I,o){I.addStyleClass("sapFCardObjectSpaceBetweenGroup");if(k===o&&k<n){I.removeStyleClass("sapFCardObjectSpaceBetweenGroup");k+=j;}if(o+1>(r-1)*j){I.addStyleClass("sapFCardObjectGroupLastInColumn");}else{I.removeStyleClass("sapFCardObjectGroupLastInColumn");}});};O.prototype.exit=function(){B.prototype.exit.apply(this,arguments);if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId="";}};O.prototype.setConfiguration=function(C){B.prototype.setConfiguration.apply(this,arguments);if(!C){return this;}if(C.groups){this._addGroups(C);}return this;};O.prototype._addGroups=function(C){var o=this._getRootContainer();var G=C.groups||[];G.forEach(function(j){var k=new V({visible:j.visible}).addStyleClass("sapFCardObjectGroup");var t=new a({text:j.title}).addStyleClass("sapFCardObjectItemTitle");k.addItem(t);j.items.forEach(function(I){var m,v=I.label,n=I.value,p,q,r=[];if(v){v=f.formattedProperty(v,function(y){return y&&y[y.length-1]===":"?y:y+=":";});p=new c({text:v,visible:I.visible}).addStyleClass("sapFCardObjectItemLabel");}if(n){switch(I.type){case'link':m=new b({href:I.url||n,text:n,target:I.target||'_blank',visible:f.reuse(I.visible)});break;case'email':if(I.value){r.push(I.value);}if(I.emailSubject){r.push(I.emailSubject);}q=f.formattedProperty(r,function(y,E){if(E){return"mailto:"+y+"?subject="+E;}else{return"mailto:"+y;}});m=new b({href:q,text:n,visible:f.reuse(I.visible)});break;case'phone':q=f.formattedProperty(n,function(y){return"tel:"+y;});m=new b({href:q,text:n,visible:f.reuse(I.visible)});break;default:m=new T({text:n,visible:f.reuse(I.visible)});break;}}if(m){m.addStyleClass("sapFCardObjectItemText");}if(I.icon){var s=f.formattedProperty(I.icon.src,function(y){return this._oIconFormatter.formatSrc(y,this._sAppId);}.bind(this));var u=new A({displaySize:I.icon.size||h.XS,src:s,initials:I.icon.text,displayShape:I.icon.shape,tooltip:I.icon.alt,backgroundColor:I.icon.backgroundColor||(I.icon.text?undefined:i.Transparent)}).addStyleClass("sapFCardObjectItemAvatar sapFCardObjectItemLabel sapFCardIcon");var w=new V({items:[p,m]});var x=new H({visible:I.visible,items:[u,w]});k.addItem(x);}else{k.addItem(p);k.addItem(m);}},this);o.addContent(k);},this);this._oActions.setAreaType(g.Content);this._oActions.attach(C,this);};return O;});
