/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./BaseListContent","./TableContentRenderer","sap/ui/integration/library","sap/m/Table","sap/m/Column","sap/m/ColumnListItem","sap/m/Text","sap/m/Link","sap/m/ProgressIndicator","sap/m/ObjectIdentifier","sap/m/ObjectStatus","sap/m/Avatar","sap/ui/core/library","sap/m/library","sap/ui/integration/util/BindingResolver","sap/ui/integration/util/BindingHelper"],function(B,T,l,R,C,a,b,L,P,O,c,A,d,m,e,f){"use strict";var g=m.AvatarSize;var h=m.AvatarColor;var V=d.VerticalAlign;var i=m.ListSeparators;var k=m.ListType;var n=l.AreaType;var o=B.extend("sap.ui.integration.cards.TableContent",{metadata:{library:"sap.ui.integration"},renderer:T});o.prototype.exit=function(){B.prototype.exit.apply(this,arguments);if(this._oItemTemplate){this._oItemTemplate.destroy();this._oItemTemplate=null;}};o.prototype._getTable=function(){if(this._bIsBeingDestroyed){return null;}var t=this.getAggregation("_content");if(!t){t=new R({id:this.getId()+"-Table",showSeparators:i.None});this.setAggregation("_content",t);}return t;};o.prototype.setConfiguration=function(j){B.prototype.setConfiguration.apply(this,arguments);if(!j){return this;}if(j.rows&&j.columns){this._setStaticColumns(j.rows,j.columns);return this;}if(j.row&&j.row.columns){this._setColumns(j.row);}return this;};o.prototype.onDataChanged=function(){this._checkHiddenNavigationItems(this.getConfiguration().row);};o.prototype._setColumns=function(r){var j=[],t=this._getTable(),p=r.columns;p.forEach(function(s){t.addColumn(new C({header:new b({text:s.title}),width:s.width,hAlign:s.hAlign,visible:s.visible}));j.push(this._createCell(s));}.bind(this));this._oItemTemplate=new a({cells:j,vAlign:V.Middle});this._oActions.setAreaType(n.ContentItem);this._oActions.attach(r,this);var q={template:this._oItemTemplate};this._filterHiddenNavigationItems(r,q);this._bindAggregationToControl("items",t,q);};o.prototype._setStaticColumns=function(r,p){var t=this._getTable();p.forEach(function(j){t.addColumn(new C({header:new b({text:j.title}),width:j.width,hAlign:j.hAlign}));});r.forEach(function(q){var I=new a({vAlign:V.Middle});if(q.cells&&Array.isArray(q.cells)){for(var j=0;j<q.cells.length;j++){I.addCell(this._createCell(q.cells[j]));}}if(q.actions&&Array.isArray(q.actions)){var s=q.actions[0];if(s.type===k.Navigation){I.setType(k.Navigation);}if(s.url){I.attachPress(function(){window.open(s.url,s.target||"_blank");});}}t.addItem(I);}.bind(this));this.fireEvent("_actionContentReady");};o.prototype._createCell=function(j){if(j.url){return new L({text:j.value,href:j.url,target:j.target||"_blank"});}if(j.identifier){var t;if(j.identifier.url){t=f.formattedProperty(j.identifier.url,function(v){if(typeof v==="string"){return true;}return false;});}var I=new O({title:j.value,titleActive:t});if(j.identifier.url){I.attachTitlePress(function(E){var S=E.getSource(),p=S.getBindingContext(),q,u,r;if(p){q=p.getPath();}u=e.resolveValue(j.identifier.url,S,q);r=e.resolveValue(j.identifier.target,S,q);if(u){window.open(u,r||"_blank");}});}return I;}if(j.state){return new c({text:j.value,state:j.state});}if(j.value){return new b({text:j.value});}if(j.icon){var s=f.formattedProperty(j.icon.src,function(v){return this._oIconFormatter.formatSrc(v,this._sAppId);}.bind(this));return new A({src:s,displayShape:j.icon.shape,displaySize:j.icon.size||g.XS,tooltip:j.icon.alt,initials:j.icon.text,backgroundColor:j.icon.backgroundColor||(j.icon.text?undefined:h.Transparent)}).addStyleClass("sapFCardIcon");}if(j.progressIndicator){return new P({percentValue:j.progressIndicator.percent,displayValue:j.progressIndicator.text,state:j.progressIndicator.state});}};o.prototype.getInnerList=function(){return this._getTable();};return o;});
