//@ui5-bundle sap/ui/integration/designtime/library-preload.designtime.js
/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/BaseEditor',["sap/ui/integration/designtime/baseEditor/util/createPromise","sap/ui/integration/designtime/baseEditor/propertyEditor/PropertyEditorFactory","sap/ui/integration/designtime/baseEditor/validator/ValidatorRegistry","sap/ui/integration/designtime/baseEditor/PropertyEditors","sap/ui/integration/designtime/baseEditor/util/binding/resolveBinding","sap/ui/integration/designtime/baseEditor/util/binding/ObjectBinding","sap/ui/integration/designtime/baseEditor/util/hasTag","sap/ui/integration/designtime/baseEditor/util/cleanupDesigntimeMetadata","sap/ui/core/Control","sap/ui/model/resource/ResourceModel","sap/base/util/ObjectPath","sap/base/util/each","sap/base/util/deepClone","sap/base/util/deepEqual","sap/base/util/values","sap/base/util/includes","sap/base/util/isPlainObject","sap/base/util/isEmptyObject","sap/base/util/restricted/_intersection","sap/base/util/restricted/_mergeWith","sap/base/util/restricted/_merge","sap/base/util/restricted/_omit","sap/base/util/restricted/_union","sap/base/util/restricted/_isNil","sap/base/util/restricted/_castArray","sap/ui/model/json/JSONModel","sap/base/i18n/ResourceBundle","sap/base/Log","sap/ui/integration/designtime/baseEditor/util/unset"],function(c,P,V,a,r,O,h,b,C,R,d,f,g,i,v,j,k,l,_,m,n,o,p,q,s,J,t,L,u){"use strict";var w="customProperty--";
var B=C.extend("sap.ui.integration.designtime.baseEditor.BaseEditor",{
metadata:{library:"sap.ui.integration",properties:{"json":{type:"object"},"config":{type:"object",defaultValue:{"i18n":["sap/ui/integration/designtime/baseEditor/i18n/i18n.properties"]}},"designtimeMetadata":{type:"object"},"layout":{type:"string",defaultValue:"list"}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true}},events:{jsonChange:{parameters:{json:{type:"object"}}},designtimeMetadataChange:{parameters:{designtimeMetadata:{type:"object"}}},configChange:{parameters:{config:{type:"object"}}},propertyEditorsReady:{parameters:{propertyEditors:{type:"array"}}}}},
constructor:function(){this._oSetConfigPromise=Promise.resolve();this._mObservableConfig={};this._mPropertyEditors={};this._aCancelHandlers=[];this._oDataModel=this._createModel();this._oDesigntimeMetadataModel=this._createModel();this._bInitFinished=false;this._bValidatorsReady=false;this._setReady(false);C.prototype.constructor.apply(this,arguments);this._oDataModel.setData(this._prepareData(this.getJson()));this.attachJsonChange(function(e){var A=e.getParameter("json");this._oDataModel.setData(this._prepareData(A));this._checkReady();},this);},
renderer:function(e,A){var D=A.getContent();e.openStart("div",A);e.openEnd();if(D.length){D.forEach(function(E){e.renderControl(E);});}else{A.getPropertyEditorsSync().forEach(function(E){e.renderControl(E);});}e.close("div");}
});
B.prototype.init=function(){};
B.prototype.exit=function(){this._reset();this._oDataModel.destroy();this._oDesigntimeMetadataModel.destroy();};
B.prototype._prepareData=function(e){var A=g(e);f(this._mObservableConfig,function(D,E){var F=E.path;if(F[0]==="/"){F=F.substr(1);}if(typeof d.get(F.split("/"),A)==="undefined"&&typeof E.defaultValue!=="undefined"){d.set(F.split("/"),g(E.defaultValue),A);}});return A;};
B.prototype.setJson=function(A){var D;if(typeof A==="string"){try{D=JSON.parse(A);}catch(e){L.error("sap.ui.integration.designtime.baseEditor.BaseEditor: invalid JSON string is specified");}}else if(k(A)){D=n({},A);}else{L.error("sap.ui.integration.designtime.baseEditor.BaseEditor: unsupported data type specified in setJson()");}if(D&&JSON.stringify(this.getProperty("json"))!==JSON.stringify(D)){this.setProperty("json",D);this.fireJsonChange({json:D});}};
B.prototype.setPreventInitialization=function(e){this._bPreventInitialization=e;};
B.prototype.setConfig=function(e,I){this._bIsDefaultConfig=I;e=e||{};this._oSetConfigPromise=this._oSetConfigPromise.then(this._registerPropertyEditorTypes.bind(this,e.propertyEditors)).then(this._setConfig.bind(this,e,I));return this._oSetConfigPromise;};
B.prototype._registerPropertyEditorTypes=function(e){P.deregisterAllTypes();return P.registerTypes(e||{});};
B.prototype._setConfig=function(e,I,A){this._initValidators(e.validators||{});var T={propertyEditors:{},properties:{}};var N=x(T,e);if(this._oSpecificConfig){N=I?this._oSpecificConfig:z(N,this._oSpecificConfig,A);}N.i18n=p(N.i18n&&s(N.i18n),this.getMetadata().getProperty("config").getDefaultValue().i18n);this.setProperty("config",N,false);this.fireConfigChange({config:g(N)});if(!this._bPreventInitialization){this._initialize();}};
B.prototype.addConfig=function(e,I){this._bIsDefaultConfig=I;this._oSetConfigPromise=this._oSetConfigPromise.then(function(){e=x(this.getConfig(),e);return e.propertyEditors;}.bind(this)).then(this._registerPropertyEditorTypes).then(function(A){this._setConfig(e,I,A);}.bind(this));return this._oSetConfigPromise;};
function x(T,e){var A=n({},T,e);A.i18n=[].concat(T.i18n||[],e.i18n||[]);return A;}
B.prototype._addSpecificConfig=function(S){var e;this._oSetConfigPromise=this._oSetConfigPromise.then(function(){this._oSpecificConfig=S;e=n({},this.getConfig());e.propertyEditors=y(e,S);return e.propertyEditors;}.bind(this)).then(this._registerPropertyEditorTypes).then(function(A){this._setConfig(e,this._bIsDefaultConfig,A);}.bind(this));return this._oSetConfigPromise;};
function y(e,S){var A={};var D=e.propertyEditors||{};var E=S.propertyEditors||{};p(Object.keys(D),Object.keys(E)).forEach(function(F){A[F]=E[F]||D[F];});return A;}
function z(e,S,A){e.i18n=p(e.i18n,S.i18n);var N=Object.assign({},e,o(S,["properties","i18n","propertyEditors"]),o(e,["properties","i18n","propertyEditors"]));N.properties={};f(e.properties,function(D,E){var F=e.propertyEditors[E.type]&&e.propertyEditors[E.type].split("/").join(".");var G=F&&A[F].configMetadata;if(G&&S.properties[D]){f(E,function(K,T){var H;var M=G[K]&&G[K].mergeStrategy;if(M){if(M==="mostRestrictiveWins"){var I=G[K].mostRestrictiveValue||false;if(T===I){H=I;}else{H=S.properties[D][K];}}else if(M==="intersection"){H=_(T,S.properties[D][K]);}}else{H=T;}N.properties[D]=N.properties[D]||{};N.properties[D][K]=H;});}});return N;}
B.prototype.setDesigntimeMetadata=function(D,I){var N=g(D);if(!i(N,this.getDesigntimeMetadata())){this.setProperty("designtimeMetadata",N);this._oDesigntimeMetadataModel.setData(N);if(!I){this.fireDesigntimeMetadataChange({designtimeMetadata:this._formatExportedDesigntimeMetadata(N)});}}};
B.prototype._formatExportedDesigntimeMetadata=function(M){var F={};var e=function(A,D){Object.keys(A).forEach(function(K){var E=A[K];if(K==="__value"){F[D.join("/")]=E;}else if(k(E)){e(E,[].concat(D,K));}});};e(M||{},[]);return F;};
B.prototype._initValidators=function(e){V.deregisterAllValidators();V.registerValidators(e);V.ready().then(function(){this._bValidatorsReady=true;this._checkReady();}.bind(this));};
B.prototype._reset=function(){this._bInitFinished=false;this._setReady(false);this._aCancelHandlers.forEach(function(e){e();});if(this._oI18nModel){this._oI18nModel.destroy();delete this._oI18nModel;}if(this._oConfigObserver){this._oConfigObserver.destroy();}f(this._mPropertyEditors,function(e,A){A.forEach(function(D){this.deregisterPropertyEditor(D,e);},this);}.bind(this));if(this._oRootWrapper){this._oRootWrapper.destroy();}};
B.prototype._initialize=function(){this._reset();var e=this.getConfig();if(typeof this.getProperty("json")==="undefined"){this.attachEventOnce("jsonChange",this._initialize);return;}if(e){this._oConfigObserver=new O();this._loadI18nBundles(e.i18n).then(function(A){this._oI18nModel=this._createI18nModel(A);this.setModel(this._oI18nModel,"i18n");this._oConfigObserver.addToIgnore(["template","itemLabel"]);this._oConfigObserver.setModel(this._oDataModel);this._oConfigObserver.setModel(this._oDesigntimeMetadataModel,"designtimeMetadata");this._oConfigObserver.setModel(this._oI18nModel,"i18n");var D=this._getContextPath();if(D){this._oConfigObserver.setModel(this._oDataModel,"context");this._oConfigObserver.setBindingContext(this._oDataModel.getContext(D),"context");}var E=r(e.properties,{"i18n":this._oI18nModel});this._mObservableConfig=Object.assign(this._mObservableConfig,this._prepareConfig(E));this._oConfigObserver.setObject(this._mObservableConfig);this._oConfigObserver.attachChange(this._onConfigChange,this);var F=this.getContent();if(F.length===0||F.length===1&&F[0]===this._oRootWrapper){this.removeAllContent();this._createEditors(this._oConfigObserver.getObject());}this._bInitFinished=true;this._checkReady();}.bind(this));}};
B.prototype._onConfigChange=function(e){var A=e.getParameter("changes").reduce(function(E,F){var G=g(F);G.path=G.path.split("/");G.propertyKey=G.path.shift();if(!E[G.propertyKey]){E[G.propertyKey]=[];}E[G.propertyKey].push(G);return E;},{});var D=Object.keys(A).reduce(function(E,F){var G=(this.getPropertyEditorsByNameSync(F)||[]).map(function(H){return{editor:H,propertyName:F};});E=E.concat(G);return E;}.bind(this),[]);var I=D.filter(function(E){return!this._oRootWrapper||!j(this._oRootWrapper._aEditorWrappers,E.editor);}.bind(this));I.forEach(function(E){var F=E.propertyName;var G=e.getSource().getObject();var H=o(g(G[F]),"value");var K=false;var N=A[F]||[];N.forEach(function(Q){if(Q.path[0]==="value"){E.editor.setValue(Q.value);}else{d.set(Q.path,Q.value,H);K=true;}});if(K){E.editor.setConfig(H);}});if(I.length<D.length){var M=g(this._oRootWrapper.getConfig()).map(function(E){var F=A[E.__propertyName]||[];F.forEach(function(G){d.set(G.path,G.value,E);});return E;});this._oRootWrapper.setConfig(M);}};
B.prototype._createModel=function(){var M=new J();M.setDefaultBindingMode("OneWay");return M;};
B.prototype._loadI18nBundles=function(e){return this._createPromise(function(A,D){Promise.all(e.map(function(I){return new Promise(function(A,E){t.create({url:sap.ui.require.toUrl(I),async:true}).then(A,E);});})).then(A,D);});};
B.prototype._createI18nModel=function(e){var A=e.slice();var I=new R({bundle:A.shift()});I.setDefaultBindingMode("OneWay");A.forEach(function(D){I.enhance(D);});return I;};
B.prototype._prepareConfig=function(e){var A={};f(e,function(K,D){A[K]=Object.assign({},this._preparePropertyConfig(D),{__propertyName:K});}.bind(this));return A;};
B.prototype._preparePropertyConfig=function(e){var A=this._getContextPath();if(A&&!A.endsWith("/")){A=A+"/";}var D=e.path;if(!D.startsWith("/")&&A){D=A+D;}return Object.assign({},e,{path:D,value:"{"+D+"}",designtime:"{designtimeMetadata>"+D+"}"});};
B.prototype._createEditors=function(e){var A=d.get(["layout",this.getLayout()],this.getConfig());if(k(A)||Array.isArray(A)){A=r(A,{"i18n":this._oI18nModel});}this._oRootWrapper=new a({config:v(e),layout:this.getLayout(),layoutConfig:A});this.addContent(this._oRootWrapper);return(Promise.all(v(this._mPropertyEditors).reduce(function(D,E){return D.concat(E);},[]).map(function(D){return D.ready();})).then(this._checkReady.bind(this)));};
B.prototype._getRegistrationKey=function(e,K){if(typeof K!=="string"){if(e.isA("sap.ui.integration.designtime.baseEditor.PropertyEditor")&&!e.getConfig()&&!e.getBindingInfo("config")&&e.getPropertyName()){K=e.getPropertyName();}else{K=w+e.getId();}}return K;};
B.prototype._addCustomProperty=function(K,e){var A=Object.assign({},this._mObservableConfig);A[K]=this._preparePropertyConfig(e);this._mObservableConfig=A;this._oConfigObserver.setObject(A);};
B.prototype._removeCustomProperty=function(K){var e=o(this._mObservableConfig,K);this._mObservableConfig=e;this._oConfigObserver.setObject(e);};
B.prototype.registerPropertyEditor=function(e,K){K=this._getRegistrationKey(e,K);var A=Array.isArray(this._mPropertyEditors[K])?this._mPropertyEditors[K]:[];this._mPropertyEditors[K]=A.concat(e);if(K.startsWith(w)){this._addCustomProperty(K,e.getConfig());}var D=d.get([K],this._oConfigObserver.getObject()).value;e.setValue(D);e.attachValueChange(this._onValueChange,this);e.attachDesigntimeMetadataChange(this._onDesigntimeMetadataChange,this);e.attachReady(this._checkReady,this);};
B.prototype.deregisterPropertyEditor=function(e,K){K=this._getRegistrationKey(e,K);var A=this._mPropertyEditors[K];if(K.startsWith(w)){this._removeCustomProperty(K);}e.detachValueChange(this._onValueChange,this);e.detachDesigntimeMetadataChange(this._onDesigntimeMetadataChange,this);if(Array.isArray(A)){this._mPropertyEditors[K]=A.filter(function(I){return e!==I;});if(this._mPropertyEditors[K].length===0){delete this._mPropertyEditors[K];}}};
B.prototype._setReady=function(e){var A=this._bIsReady;this._bIsReady=e;if(A!==true&&e===true){this.firePropertyEditorsReady({propertyEditors:this.getPropertyEditorsSync()});}};
B.prototype._checkReady=function(){var e=this.getContent().filter(function(E){return(E.isA("sap.ui.integration.designtime.baseEditor.PropertyEditors")||E.isA("sap.ui.integration.designtime.baseEditor.propertyEditor.BasePropertyEditor"));});e.forEach(function(E){if(!sap.ui.base.EventProvider.hasListener(E,"ready",this._checkReady,this)){E.attachReady(this._checkReady,this);}},this);var A=[].concat(e,this.getPropertyEditorsSync());var I=(this._bInitFinished&&this._bValidatorsReady&&A.every(function(E){return E.isReady();}));this._setReady(I);};
B.prototype.isReady=function(){return this._bIsReady;};
B.prototype.ready=function(){return new Promise(function(e){if(this.isReady()){e();}else{this.attachEventOnce("propertyEditorsReady",e);}}.bind(this));};
B.prototype._createPromise=function(e){var A=c(e);this._aCancelHandlers.push(A.cancel);var D=function(E,F){this._aCancelHandlers=this._aCancelHandlers.filter(function(e){return e!==E;});return F;}.bind(this,A.cancel);return A.promise.then(D,D);};
B.prototype.getPropertyConfigByName=function(e){return o(d.get([e],this._oConfigObserver.getObject()),"value");};
B.prototype.getPropertyEditorsByName=function(e){return new Promise(function(A){if(!this._mPropertyEditors||Object.keys(this._mPropertyEditors).length===0){this.attachEventOnce("propertyEditorsReady",A);}else{A();}}.bind(this)).then(function(){return this.getPropertyEditorsByNameSync(e);}.bind(this));};
B.prototype.getPropertyEditorsByNameSync=function(e){var A=this._mPropertyEditors[e];return Array.isArray(A)&&A.slice()||null;};
B.prototype.getPropertyEditorsByTag=function(T){return new Promise(function(e){if(!this._mPropertyEditors||Object.keys(this._mPropertyEditors).length===0){this.attachEventOnce("propertyEditorsReady",e);}else{e();}}.bind(this)).then(function(){return this.getPropertyEditorsByTagSync(T);}.bind(this));};
B.prototype.getConfigsByTag=function(T){var e=this.getConfig().properties;return Object.keys(e).filter(function(A){return h(e[A],T);}).map(function(A){return e[A];});};
B.prototype.getPropertyEditorsByTagSync=function(T){return this.getPropertyEditorsSync().filter(function(e){return h(e.getConfig(),T);});};
B.prototype.getPropertyEditorsSync=function(){return v(this._mPropertyEditors).reduce(function(e,A){return e.concat(A);},[]).sort(function(e,A){return parseInt(e.getId().match(/\d+$/))-parseInt(A.getId().match(/\d+$/));});};
B.prototype.getJson=function(){return n({},this.getProperty("json"));};
B.prototype.getDesigntimeMetadata=function(){return n({},this.getProperty("designtimeMetadata"));};
B.prototype._getContextPath=function(){var e=this.getConfig();var A=e&&e.context||null;if(A&&A[0]!=="/"){A="/"+A;}return A;};
B.prototype._onValueChange=function(e){var A=e.getSource();var D=e.getParameter("path");var E=this.getJson()||{};var F=e.getParameter("value");if(D[0]==="/"){D=D.substr(1);}else{throw new Error("BaseEditor._onValueChange: unknown relative path - '"+D+"'");}var G=D.split("/");d.set(G,F,E);if(typeof F==="undefined"||i(F,A.getRuntimeConfig().defaultValue)||Array.isArray(F)&&F.length===0||k(F)&&l(F)){u(E,G);}this.setJson(E);};
B.prototype._onDesigntimeMetadataChange=function(e){var A=e.getParameter("path");var D=this.getDesigntimeMetadata()||{};var E=e.getParameter("value");if(A[0]==="/"){A=A.substr(1);}else{throw new Error("BaseEditor._onDesigntimeMetadataChange: unknown relative path - '"+A+"'");}var F=A.split("/");d.set(F,E,D);b(D);this.setDesigntimeMetadata(D);};
return B;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/PropertyEditor',["sap/ui/core/Control","sap/ui/integration/designtime/baseEditor/util/findClosestInstance","sap/ui/integration/designtime/baseEditor/util/createPromise","sap/ui/integration/designtime/baseEditor/util/escapeParameter","sap/ui/integration/designtime/baseEditor/propertyEditor/PropertyEditorFactory","sap/base/util/restricted/_merge","sap/base/util/restricted/_omit","sap/base/util/deepEqual","sap/base/util/deepClone"],function(C,f,c,e,P,_,a,d,b){"use strict";var g="config";var h="propertyName";
var i=C.extend("sap.ui.integration.designtime.baseEditor.PropertyEditor",{
metadata:{library:"sap.ui.integration",interfaces:["sap.ui.core.IFormContent"],properties:{propertyName:{type:"string"},renderLabel:{type:"boolean"},value:{type:"any"},config:{type:"object"}},aggregations:{propertyEditor:{type:"sap.ui.integration.designtime.baseEditor.propertyEditor.BasePropertyEditor",multiple:false,visibility:"hidden"}},associations:{editor:{type:"sap.ui.integration.designtime.baseEditor.BaseEditor",multiple:false}},events:{editorChange:{parameters:{previousEditor:{type:"sap.ui.integration.designtime.baseEditor.BaseEditor"},editor:{type:"sap.ui.integration.designtime.baseEditor.BaseEditor"}}},propertyEditorChange:{parameters:{previousPropertyEditor:{type:"sap.ui.integration.designtime.baseEditor.propertyEditor.BasePropertyEditor"},propertyEditor:{type:"sap.ui.integration.designtime.baseEditor.propertyEditor.BasePropertyEditor"}}},configChange:{parameters:{previousConfig:{type:"object"},config:{type:"object"}}},propertyNameChange:{parameters:{previousPropertyName:{type:"string"},propertyName:{type:"string"}}},ready:{},beforeValueChange:{parameters:{path:{type:"string"},value:{type:"any"},nextValue:{type:"any"}}},valueChange:{parameters:{path:{type:"string"},value:{type:"any"},previousValue:{type:"any"}}},designtimeMetadataChange:{parameters:{path:{type:"string"},value:{type:"any"},previousValue:{type:"any"}}},init:{}}},
_bEditorAutoDetect:false,
_sCreatedBy:null,
constructor:function(){C.prototype.constructor.apply(this,e(arguments,function(v,p){return(p==="config"&&P.hasType(v.type));}));if(!this.getEditor()){this._bEditorAutoDetect=true;}this._propagationListener=this._propagationListener.bind(this);this.attachEditorChange(function(E){if(this._sCreatedBy){this._removePropertyEditor(E.getParameter("previousEditor"));}this._initPropertyEditor();});this.attachConfigChange(function(E){var p=E.getParameter("previousConfig");var o=E.getParameter("config");var n=this.getAggregation("propertyEditor");if(this._fnCancelInit||!n||!p||!o||p.type!==o.type||p.path!==o.path){this._removePropertyEditor(this.getEditor());this._initPropertyEditor();}else{n.setConfig(o);}});this.attachPropertyNameChange(function(){if(this._sCreatedBy===h){this._removePropertyEditor(this.getEditor());}if(this._sCreatedBy!==g){this._initPropertyEditor();}});this._initPropertyEditor();},
renderer:function(r,o){r.openStart("div",o);r.addStyle("display","inline-block");r.addStyle("width","100%");r.openEnd();r.renderControl(o.getAggregation("propertyEditor"));r.close("div");}
});
i.prototype.init=function(){Promise.resolve().then(function(){this.fireInit();}.bind(this));};
i.prototype.getEditor=function(){return sap.ui.getCore().byId(this.getAssociation("editor"));};
i.prototype.setConfig=function(m){var p=this.getConfig();var n=m&&_({},{designtime:undefined},m);if(!d(p,n)){this.setProperty("config",n);this.fireConfigChange({previousConfig:p,config:n});}};
i.prototype.setPropertyName=function(p){var s=this.getPropertyName();if(s!==p){this.setProperty("propertyName",p);this.firePropertyNameChange({previousPropertyName:s,propertyName:p});}};
i.prototype.setEditor=function(E){var p=this.getEditor();var o=typeof E==="string"?sap.ui.getCore().byId(E):E;if(p!==o){this.setAssociation("editor",E);var o=this.getEditor();this.fireEditorChange({previousEditor:p,editor:o});}};
i.prototype.destroy=function(){this._removePropertyEditor(this.getEditor());C.prototype.destroy.apply(this,arguments);};
i.prototype._cleanupCancelledInit=function(p){p.destroy();};
i.prototype._removePropertyEditor=function(E){var p=this.getAggregation("propertyEditor");if(this._fnCancelInit){this._fnCancelInit().then(this._cleanupCancelledInit);delete this._fnCancelInit;}if(p){this.setAggregation("propertyEditor",null);p.detachReady(this._onPropertyEditorReady,this);p.destroy();this._sCreatedBy=null;this.firePropertyEditorChange({propertyEditor:null});}if(E&&this._mConfig&&this._isAbsolutePath(this._mConfig.path)){E.deregisterPropertyEditor(this,this._mConfig.__propertyName);}};
i.prototype.isReady=function(){var n=this.getAggregation("propertyEditor");return n&&n.isReady()||false;};
i.prototype.ready=function(){return new Promise(function(r){var j=function(n){n.ready().then(r);};var n=this.getAggregation("propertyEditor");if(n){j(n);}else{var w=function(E){var n=E.getParameter("propertyEditor");if(n){this.detachPropertyEditorChange(w,this);j(n);}};this.attachPropertyEditorChange(w,this);}}.bind(this));};
i.prototype._onPropertyEditorReady=function(){this.fireReady();};
i.prototype._initPropertyEditor=function(){if(!this.getEditor()){return;}if(this.getConfig()||(!this.getBindingInfo("config")&&this.getPropertyName()&&this.getEditor())){if(this._fnCancelInit){this._fnCancelInit().then(this._cleanupCancelledInit);delete this._fnCancelInit;}this._mConfig=this.getConfig()||this.getEditor().getPropertyConfigByName(this.getPropertyName());var s=this.getConfig()?g:h;var p=c(function(r,R){P.create(this._mConfig.type).then(r).catch(R);}.bind(this));this._fnCancelInit=p.cancel;if(this._isAbsolutePath(this._mConfig.path)){this.getEditor().registerPropertyEditor(this,this._mConfig.__propertyName);}p.promise.then(function(o){o.setModel(this.getEditor().getModel("i18n"),"i18n");o.setConfig(a(_({},this._mConfig),"__propertyName"));o.attachBeforeValueChange(function(E){this.fireBeforeValueChange(a(E.getParameters(),"id"));},this);o.attachValueChange(function(E){this.setValue(E.getParameter("value"));this.fireValueChange(a(E.getParameters(),"id"));},this);o.attachDesigntimeMetadataChange(function(E){this.fireDesigntimeMetadataChange(a(E.getParameters(),"id"));},this);o.setValue(this.getValue(),true);this._sCreatedBy=s;this.setAggregation("propertyEditor",o);var r=this.getRenderLabel();if(r!==undefined){o.setRenderLabel(r);}o.attachReady(this._onPropertyEditorReady,this);if(o.isReady()){this.fireReady();}this.firePropertyEditorChange({propertyEditor:o});delete this._fnCancelInit;}.bind(this));}};
i.prototype._isAbsolutePath=function(p){return p&&p.startsWith("/");};
i.prototype._propagationListener=function(){var E=f(this.getParent(),"sap.ui.integration.designtime.baseEditor.BaseEditor");if(E){this.setEditor(E);this.removePropagationListener(this._propagationListener);}};
i.prototype.setParent=function(p){C.prototype.setParent.apply(this,arguments);if(this._bEditorAutoDetect){var E=f(p,"sap.ui.integration.designtime.baseEditor.BaseEditor");if(E){this.setEditor(E);}else{this.addPropagationListener(this._propagationListener);}}};
i.prototype.setRenderLabel=function(r){this.setProperty("renderLabel",r);var n=this.getAggregation("propertyEditor");if(n){n.setRenderLabel(r);}};
i.prototype.getContent=function(){var n=this.getAggregation("propertyEditor");return n&&n.getContent();};
i.prototype.setValue=function(v){this.setProperty("value",v);var n=this.getAggregation("propertyEditor");if(n){n.setValue(v,true);}};
i.prototype.getRuntimeConfig=function(){return this._mConfig;};
i.prototype.enhanceAccessibilityState=function(E,A){var p=this.getParent();if(p&&p.enhanceAccessibilityState){p.enhanceAccessibilityState(this,A);}return A;};
i.prototype.getFocusDomRef=function(){var n=this.getAggregation("propertyEditor");if(n){return n.getFocusDomRef();}};
i.prototype.getIdForLabel=function(){var n=this.getAggregation("propertyEditor");if(n){return n.getIdForLabel();}};
return i;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/PropertyEditors',["sap/ui/core/Control","sap/ui/integration/designtime/baseEditor/util/findClosestInstance","sap/ui/integration/designtime/baseEditor/util/createPromise","sap/ui/integration/designtime/baseEditor/util/isTemplate","sap/ui/integration/designtime/baseEditor/util/StylesheetManager","sap/base/util/restricted/_intersection","sap/base/util/restricted/_omit","sap/base/util/deepEqual","sap/base/util/deepClone","sap/ui/core/Fragment","sap/ui/model/json/JSONModel","sap/ui/base/ManagedObjectObserver"],function(C,f,c,i,S,_,a,d,b,F,J,M){"use strict";var e="config";var g="tags";var l={"list":{module:"sap/ui/integration/designtime/baseEditor/layout/Form",defaultConfig:{responsiveGridLayout:{labelSpanXL:12,labelSpanL:12,labelSpanM:12,labelSpanS:12,adjustLabelSpan:false,columnsXL:1,columnsL:1,columnsM:1,singleContainerFullSize:false}}},"form":{module:"sap/ui/integration/designtime/baseEditor/layout/Form",defaultConfig:{}}};
var P=C.extend("sap.ui.integration.designtime.baseEditor.PropertyEditors",{
metadata:{library:"sap.ui.integration",properties:{tags:{type:"string"},renderLabels:{type:"boolean"},config:{type:"array"},layout:{type:"string",defaultValue:"list"},layoutConfig:{type:"object"}},aggregations:{content:{type:"sap.ui.core.Control",multiple:false}},associations:{editor:{type:"sap.ui.integration.designtime.baseEditor.BaseEditor",multiple:false},propertyEditors:{type:"sap.ui.integration.designtime.baseEditor.PropertyEditor",visibility:"hidden"}},events:{editorChange:{parameters:{previousEditor:{type:"sap.ui.integration.designtime.baseEditor.BaseEditor"},editor:{type:"sap.ui.integration.designtime.baseEditor.BaseEditor"}}},propertyEditorsChange:{parameters:{previousPropertyEditors:{type:"sap.ui.integration.designtime.baseEditor.PropertyEditor"},propertyEditors:{type:"sap.ui.integration.designtime.baseEditor.PropertyEditor"}}},init:{},configChange:{parameters:{previousConfig:{type:"array"},config:{type:"array"}}},tagsChange:{parameters:{previousTags:{type:"string"},tags:{type:"string"}}},ready:{},layoutChange:{parameters:{previousLayout:{type:"string"},layout:{type:"string"}}},layoutConfigChange:{parameters:{previousLayoutConfig:{type:"object"},layoutConfig:{type:"object"}}}}},
_bEditorAutoDetect:false,
_sCreatedBy:null,
_bLayoutReady:false,
constructor:function(){this._iExpectedWrapperCount=0;this._setReady(false);this._aEditorWrappers=[];this._bInitFinished=false;C.prototype.constructor.apply(this,arguments);var m=new J();this.setModel(m);if(!this.getEditor()){this._bEditorAutoDetect=true;}this._propagationListener=this._propagationListener.bind(this);this.attachEditorChange(function(){if(this._sCreatedBy){this._removePropertyEditors();}this._initPropertyEditors();});this.attachConfigChange(function(E){var p=E.getParameter("previousConfig");var h=E.getParameter("config");if(this._fnCancelInit||this._sCreatedBy===g||!Array.isArray(p)||!Array.isArray(h)||p.length!==h.length){this._removePropertyEditors();this._initPropertyEditors();}else if(this._sCreatedBy){this._evaluateViewRecreation(p,h);}});this.attachTagsChange(function(){if(this._sCreatedBy===g){this._removePropertyEditors();}if(this._sCreatedBy!==e){this._initPropertyEditors();}});if(this.getMetadata().getProperty("layout").getDefaultValue()===this.getLayout()){this._initLayout(this.getLayout());}},
renderer:function(r,o){r.openStart("div",o);r.openEnd();r.renderControl(o.getContent());r.close("div");}
});
P.prototype.init=function(){this.attachLayoutChange(function(E){var p=E.getParameter("previousLayout");this._removeStylesheet(this._getLayoutPath(p));var L=E.getParameter("layout");this._initLayout(L);},this);this.attachLayoutConfigChange(function(){if(this._sCreatedBy){this._removePropertyEditors();}this._initPropertyEditors();},this);Promise.resolve().then(function(){this._bInitFinished=true;this.fireInit();}.bind(this));};
P.prototype.destroy=function(){this._bInitFinished=false;this._setReady(false);if(this._fnCancelLayoutLoading){this._fnCancelLayoutLoading();}this._removeStylesheet(this._getLayoutPath(this.getLayout()));C.prototype.destroy.apply(this,arguments);};
P.prototype._loadFragment=function(s){return F.load({name:s,controller:this});};
P.prototype._loadModule=function(s){return new Promise(function(r,R){sap.ui.require([s],r,R);});};
P.prototype._loadStylesheet=function(s){this._bCssRequested=true;return S.add(s);};
P.prototype._removeStylesheet=function(s){if(this._bCssRequested){S.remove(s);delete this._bCssRequested;}};
P.prototype.getEditor=function(){return sap.ui.getCore().byId(this.getAssociation("editor"));};
P.prototype.setConfig=function(m){var p=this.getConfig();if(!Array.isArray(p)||!Array.isArray(m)||JSON.stringify(p)!==JSON.stringify(m)){var n=b(m);this.setProperty("config",n);this.fireConfigChange({previousConfig:p,config:n});}};
P.prototype.setTags=function(t){var p=this.getTags();var r=t;if(typeof t==="string"){r=t.split(",").sort().join(",");}if(p!==r){this.setProperty("tags",r);this.fireTagsChange({previousTags:p,tags:r});}};
P.prototype.setEditor=function(E){var p=this.getEditor();var o=typeof E==="string"?sap.ui.getCore().byId(E):E;if(p!==o){this.setAssociation("editor",E);var o=this.getEditor();this.fireEditorChange({previousEditor:p,editor:o});}};
P.prototype._removePropertyEditors=function(){var p=this.removeAllAssociation("propertyEditors").map(function(s){return sap.ui.getCore().byId(s);});this._iExpectedWrapperCount=0;this.getModel().setData({});this._sCreatedBy=null;if(p.length){this.firePropertyEditorsChange({previousPropertyEditors:p,propertyEditors:[]});}};
P.prototype._initPropertyEditors=function(){if(this.getEditor()&&(this.getConfig()||(!this.getBindingInfo("config")&&this.getTags()))&&this._bLayoutReady){var E=this.getEditor();var h;if(this.getConfig()){h=this.getConfig();this._sCreatedBy=e;}else{var t=this.getTags().split(",");h=E.getConfigsByTag(t);this._sCreatedBy=g;}var p=(this._getPropertyEditors()||[]).slice();this._updateViewModel(h);this.ready().then(function(){this.firePropertyEditorsChange({previousPropertyEditors:p,propertyEditors:(this._getPropertyEditors()||[]).slice()});}.bind(this));}this._checkReadyState();};
P.prototype._propagationListener=function(){var E=f(this.getParent(),"sap.ui.integration.designtime.baseEditor.BaseEditor");if(E){this.setEditor(E);this.removePropagationListener(this._propagationListener);}};
P.prototype.setParent=function(p){C.prototype.setParent.apply(this,arguments);if(this._bEditorAutoDetect){var E=f(p,"sap.ui.integration.designtime.baseEditor.BaseEditor");if(E){this.setEditor(E);}else{this.addPropagationListener(this._propagationListener);}}};
P.prototype.setLayout=function(L){var p=this.getLayout();if(p!==L){this.setProperty("layout",L);this.fireLayoutChange({previousLayout:p,layout:L});}};
P.prototype.setLayoutConfig=function(L){var p=this.getLayoutConfig();if(!d(p,L)){this.setProperty("layoutConfig",L);this.fireLayoutConfigChange({previousLayoutConfig:p,layoutConfig:L});}};
P.prototype._getLayoutConfig=function(){var L=this.getLayoutConfig();var r=this.getRenderLabels();var R;if(typeof r==="boolean"){R={renderLabels:r};}var D=l[this.getLayout()]&&l[this.getLayout()].defaultConfig||{};return Object.assign({},D,L,R);};
P.prototype._getLayoutPath=function(L){return l.hasOwnProperty(L)?l[L].module:L;};
P.prototype._initLayout=function(L){this.destroyContent();var p=this._getLayoutPath(L);this._bLayoutReady=false;if(this._sCreatedBy){this._removePropertyEditors();}if(this._fnCancelLayoutLoading){this._fnCancelLayoutLoading();}var m=c(function(r,R){this._loadStylesheet(p);Promise.all([this._loadFragment(p),this._loadModule(p)]).then(r,R);}.bind(this));m.promise.then(function(r){delete this._fnCancelLayoutLoading;var o=r[0];var h=r[1];this._prepareData=h.prepareData;this._aUpdateDependencies=h.updateDependencies||[];this.setContent(o);this._bLayoutReady=true;this._initPropertyEditors();}.bind(this));this._fnCancelLayoutLoading=m.cancel;};
P.prototype._evaluateViewRecreation=function(p,h){var r=this._getPropertyEditors()||[];if(p.length!==h.length||h.length!==r.length||h.some(function(o,I){return this._aUpdateDependencies.some(function(D){return p[I][D]!==o[D];});}.bind(this))){this._updateViewModel(h);}else{r.map(function(o,I){var j=h[I];o.setConfig(a(b(j),"value"));if(j.hasOwnProperty("value")){o.setValue(j.value);}});}};
P.prototype._updateViewModel=function(h){var D=this._prepareData(h,this._getLayoutConfig());this._iExpectedWrapperCount=D.count;if(this._iExpectedWrapperCount>0){this._checkReadyState();}this.getModel().setData(D);};
P.prototype.ready=function(){return new Promise(function(r){if(this.isReady()){r();}else{this.attachEventOnce("ready",r);}}.bind(this));};
P.prototype.isReady=function(){return!!this._bIsReady;};
P.prototype._setReady=function(r){var p=this._bIsReady;this._bIsReady=r;if(p!==true&&r===true){this.fireReady();}};
P.prototype._checkReadyState=function(){if(this._mWrapperReadyCheck){this._mWrapperReadyCheck.cancel();}if(!this._bInitFinished){this._setReady(false);return;}if(!this._bLayoutReady){this._setReady(false);return;}if(this._iExpectedWrapperCount===0){this._setReady(true);return;}if(this._iExpectedWrapperCount===this._aEditorWrappers.length){if(this._aEditorWrappers.every(function(w){return w.isReady();})){this._setReady(true);}else{this._setReady(false);this._mWrapperReadyCheck=c(function(r){Promise.all(this._aEditorWrappers.map(function(w){return w.ready();})).then(r);}.bind(this));this._mWrapperReadyCheck.promise.then(function(){this._setReady(true);delete this._mWrapperReadyCheck;}.bind(this));}}else{this._setReady(false);}};
P.prototype.wrapperInit=function(E){var w=E.getSource();if(i(w,this)){return;}if(!w.getEditor()){w.setEditor(this.getEditor());}this._aEditorWrappers.push(w);this.addAssociation("propertyEditors",w);w.attachReady(function(){this._setReady(false);this._checkReadyState();}.bind(this));if(!this._oWrapperObserver){this._oWrapperObserver=new M(function(m){this._aEditorWrappers=this._aEditorWrappers.filter(function(o){return o!==m.object;});this.removeAssociation("propertyEditors",m.object);}.bind(this));}this._oWrapperObserver.observe(w,{destroy:true});this._checkReadyState();};
P.prototype._getPropertyEditors=function(){var p=(this.getAssociation("propertyEditors")||[]).map(function(I){return sap.ui.getCore().byId(I);});return p.length&&p||null;};
return P;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/layout/Form',["sap/ui/integration/designtime/baseEditor/util/hasTag","sap/base/util/restricted/_omit"],function(h,_){"use strict";var d={labelSpanXL:4,labelSpanL:4,labelSpanM:4,labelSpanS:12,adjustLabelSpan:false,columnsXL:1,columnsL:1,columnsM:1,singleContainerFullSize:false};
function c(P){return{label:P.label,value:P.value,config:_(P,["label","value"])};}
function g(C,t){var r=[];var i=0;while(i<C.length){var m=C[i];if(h(m,t)){r.push(m);C.splice(i,1);}else{i++;}}return r;}
function a(C,P){var i=C.findIndex(function(m){return m.__propertyName===P;});if(i>-1){return C.splice(i,1)[0];}}
function b(C){return C.some(function(G){return typeof G.config.visible==="boolean"?G.config.visible:true;});}
function p(P,l){l=l||{};var C=P.slice();var G=l.groups||[];var r=l.responsiveGridLayout||d;var R=l.renderLabels!==false;var v={responsiveGridLayout:r};if(!R){C=C.map(function(m){return _(m,"label");});}if(G.length>0){v.groups=G.map(function(m){var i=[];m.items.forEach(function(I){switch(I.type){case"tag":i=i.concat(g(C,I.value).map(function(f){return c(f);}));break;case"propertyName":var e=a(C,I.value);if(e){i=i.concat(c(e));}break;}});return{label:m.label,items:i,visible:b(i)};});}else{var i=C.splice(0,C.length).map(c);v.groups=[{items:i,visible:b(i)}];}v.groups=v.groups.filter(function(m){return m.items.length>0;});v.count=P.length-C.length;return v;}
return{prepareData:p,updateDependencies:["visible","tags"]};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor',["sap/ui/core/Control","./../util/isTemplate","sap/ui/model/json/JSONModel","sap/m/Label","sap/ui/core/Fragment","sap/base/util/restricted/_omit","sap/ui/base/ManagedObjectObserver","sap/ui/integration/designtime/baseEditor/propertyEditor/PropertyEditorFactory","sap/ui/integration/designtime/baseEditor/util/createPromise","sap/base/util/restricted/_CancelablePromise","sap/base/util/deepClone","sap/base/util/deepEqual","sap/base/util/isPlainObject","sap/base/util/values","sap/base/util/each","sap/ui/integration/designtime/baseEditor/validator/ValidatorRegistry","sap/ui/integration/designtime/baseEditor/util/BaseDefaultValidatorModules","sap/ui/integration/designtime/baseEditor/util/cleanupDesigntimeMetadata"],function(C,i,J,L,F,_,M,P,c,a,d,b,e,v,f,V,B,g){"use strict";
var h=C.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.BasePropertyEditor",{
metadata:{library:"sap.ui.integration",interfaces:["sap.ui.core.IFormContent"],properties:{"renderLabel":{type:"boolean",defaultValue:true},"value":{type:"any"},"config":{type:"object"}},aggregations:{"_label":{type:"sap.m.Label",visibility:"hidden",multiple:false},"content":{type:"sap.ui.core.Control",multiple:false}},events:{beforeValueChange:{parameters:{path:{type:"string"},value:{type:"any"},nextValue:{type:"any"}}},valueChange:{parameters:{path:{type:"string"},value:{type:"any"},previousValue:{type:"any"}}},designtimeMetadataChange:{parameters:{path:{type:"string"},value:{type:"any"},previousValue:{type:"any"}}},configChange:{parameters:{previousConfig:{type:"object"},config:{type:"object"}}},fragmentChange:{parameters:{previousFragment:{type:"string"},fragment:{type:"string"}}},ready:{},init:{}}},
xmlFragment:null,
_currentXmlFragment:null,
_bFragmentReady:false,
constructor:function(){this._iExpectedWrapperCount=0;this._currentXmlFragment=this.xmlFragment;C.prototype.constructor.apply(this,arguments);this._oDefaultModel=new J({value:this.getValue(),config:this.getConfig(),displayValue:this._formatValue(this.getValue())});this._oDefaultModel.setDefaultBindingMode("OneWay");this.setBindingContext(this._oDefaultModel.getContext("/"));this.setModel(this._oDefaultModel);this.bindProperty("visible","config/visible");this._setReady(false);this._aEditorWrappers=[];this._bInitFinished=false;this.attachBeforeValueChange(function(E){this._iExpectedWrapperCount=this.getExpectedWrapperCount(E.getParameter("nextValue"));},this);this.attachValueChange(function(E){var m=E.getParameter("value");this._oDefaultModel.setData(Object.assign({},this._oDefaultModel.getData(),{value:m,displayValue:this._formatValue(m)}));this._checkReadyState();},this);this.attachConfigChange(function(E){var p=E.getParameter("previousConfig");var m=E.getParameter("config");if(p&&m&&!b(p.validators,m.validators)){this._validate(this.getValue());}this._oDefaultModel.setData(Object.assign({},this._oDefaultModel.getData(),{config:m}));},this);this.asyncInit().then(function(){this._bInitFinished=true;this.fireInit();this._checkReadyState();}.bind(this));if(this.getFragment()){this._initFragment(this.getFragment());}},
renderer:function(r,p){r.openStart("div",p);r.addStyle("display","inline-block");r.addStyle("width","100%");r.openEnd();if(p.getRenderLabel()&&p.getLabel()){r.openStart("div");r.openEnd();r.renderControl(p.getLabel());r.close("div");}r.renderControl(p.getContent());r.close("div");}
});
h.prototype.init=function(){this.attachFragmentChange(function(E){if(this.getContent()){this.getContent().destroy();}var s=E.getParameter("fragment");this._initFragment(s);},this);};
h.prototype.asyncInit=function(){return Promise.resolve();};
h.prototype.onFragmentReady=function(){};
h.prototype.setValue=function(m,s){var n=this.getValue();var p=this.getConfig()||{};var N=m;if(typeof N==="undefined"&&typeof p.defaultValue!=="undefined"){N=d(p.defaultValue);}this._validate(N,function(r){if((r||s)&&!b(N,n)){this.fireBeforeValueChange({path:p.path,value:n,nextValue:N});this.setProperty("value",N);this.fireValueChange({path:p.path,previousValue:n,value:N});}}.bind(this));};
h.prototype.setDesigntimeMetadata=function(m){var n=this.getDesigntimeMetadata();var N=m;g(N);var p=this.getConfig();if(!b(n,N)){this.fireDesigntimeMetadataChange({path:p.path,previousValue:n,value:N});}};
h.prototype.getDesigntimeMetadata=function(){return(this.getConfig()||{}).designtime||{};};
h.prototype.setDesigntimeMetadataValue=function(m){this.setDesigntimeMetadata(Object.assign({},this.getConfig().designtime,{__value:m}));};
h.prototype.getNestedDesigntimeMetadata=function(K){var D=(this.getConfig()||{}).designtime||{};return D[K];};
h.prototype.getNestedDesigntimeMetadataValue=function(K){return(this.getNestedDesigntimeMetadata(K)||{}).__value||{};};
h.prototype.getDesigntimeMetadataValue=function(){var D=(this.getConfig()||{}).designtime||{};return D.__value||{};};
h.prototype._getValidators=function(){var p=this.getConfig().validators||{};return v(Object.assign({},this.getDefaultValidators(),p)).filter(function(m){return m.isEnabled!==false;});};
h.prototype.getDefaultValidators=function(){return{};};
h.prototype._validate=function(m,n){var E=[];var p=this._getValidators();p=p.map(function(r){var s=V.hasValidator(r.type)?V.getValidator(r.type):this.getDefaultValidatorModules()[r.type];if(!s){throw new Error("Unknown validator: "+r.type);}var t={};var u=r.errorMessage||s.errorMessage;var w=[];var x=u;if(e(u)){w=u.placeholders(r.config);x=u.message;}Object.keys(r.config||{}).forEach(function(y){var z=r.config[y];if(typeof z==="function"){z=z(this);}t[y]=z;}.bind(this));return{validator:s,config:t,errorMessage:this.getI18nProperty(x,w),type:r.type};}.bind(this));var q=function(){var r=E.length===0;this.setInputState(!r,E[0]);if(typeof n==="function"){n(r);}}.bind(this);p.forEach(function(r){if(!r.validator.validate(m,r.config)){E.push(r.errorMessage);}});q();};
h.prototype.setInputState=function(H,E){this._sErrorMessage=E;if(this.isReady()){this._setInputState();}};
h.prototype._setInputState=function(){var I=this.getContent();if(!I||!I.setValueState){return;}var E=this._sErrorMessage;if(E){I.setValueState("Error");I.setValueStateText(E);}else{I.setValueState("None");}};
h.prototype.getDefaultValidatorModules=function(){return B;};
h.prototype._formatValue=function(m){return this.formatValue(d(m));};
h.prototype.formatValue=function(m){return m;};
h.prototype.getExpectedWrapperCount=function(){return 0;};
h.prototype._checkReadyState=function(){if(this._mWrapperReadyCheck){this._mWrapperReadyCheck.cancel();}if(!this._bInitFinished){this._setReady(false);return;}if(!this._bFragmentReady){this._setReady(false);return;}if(this._iExpectedWrapperCount===0){this._setReady(true);return;}if(this._iExpectedWrapperCount===this._aEditorWrappers.length){if(this._aEditorWrappers.every(function(w){return w.isReady();})){this._setReady(true);}else{this._setReady(false);this._mWrapperReadyCheck=c(function(r){Promise.all(this._aEditorWrappers.map(function(w){return w.ready();})).then(r);}.bind(this));this._mWrapperReadyCheck.promise.then(function(){this._setReady(true);delete this._mWrapperReadyCheck;}.bind(this));}}else{this._setReady(false);}};
h.prototype.wrapperInit=function(E){if(!this._oWrapperObserver){this._oWrapperObserver=new M(function(m){var O=m.object;switch(m.type){case'destroy':this._aEditorWrappers=this._aEditorWrappers.filter(function(n){return n!==O;});this._checkReadyState();break;case'parent':k(O).forEach(function(w){if(!i(w,this)){this._registerWrapper(w);}else{o(this._oWrapperObserver,w);}}.bind(this));this._oWrapperObserver.unobserve(O);break;default:return;}}.bind(this));}var w=E.getSource();if(i(w,this)){o(this._oWrapperObserver,w);return;}this._registerWrapper(w);};
function o(w,W){var r=j(W);if(!w.isObserved(r,{parent:true})){w.observe(r,{parent:true});}}
function j(E){var p=E.getParent();return p?j(p):E;}
function k(E){return l(E)?[E]:E.findAggregatedObjects(true,function(E){return l(E);});}
function l(E){return E.isA("sap.ui.integration.designtime.baseEditor.PropertyEditors")||E.isA("sap.ui.integration.designtime.baseEditor.PropertyEditor");}
h.prototype._registerWrapper=function(w){this._aEditorWrappers.push(w);w.attachReady(function(E){this._setReady(false);this._checkReadyState();}.bind(this));if(w.isA("sap.ui.integration.designtime.baseEditor.PropertyEditor")){w.attachPropertyEditorChange(function(E){var p=E.getParameter("propertyEditor");if(!p){this._setReady(false);}},this);}this._oWrapperObserver.observe(w,{destroy:true});this._checkReadyState();};
h.prototype._setReady=function(r){var p=this._bIsReady;this._bIsReady=r;if(p!==true&&r===true){this.fireReady();}};
h.prototype.isReady=function(){return!!this._bIsReady;};
h.prototype.ready=function(){return new Promise(function(r){if(this.isReady()){r();}else{this.attachEventOnce("ready",r);}}.bind(this));};
h.prototype.setFragment=function(s,G){if(this._currentXmlFragment!==s){var p=this._currentXmlFragment;this._currentXmlFragment=s;if(typeof G==='function'){this.getExpectedWrapperCount=G;}this.fireFragmentChange({previousFragment:p,fragment:s});}};
h.prototype.getFragment=function(){return this._currentXmlFragment;};
h.prototype._initFragment=function(s){this._setReady(false);this._bFragmentReady=false;if(this._oFragmentPromise){this._oFragmentPromise.cancel();}var m=new a(function(r,R,n){n.shouldReject=false;this._loadFragment(s).then(r,R);}.bind(this));this._oFragmentPromise=m;return m.then(function(n){if(m.isCanceled){n.destroy();return;}this._bFragmentReady=true;this.setContent(n);this.onFragmentReady();this._setInputState();this._checkReadyState();}.bind(this));};
h.prototype._loadFragment=function(s){return F.load({name:s,controller:this});};
h.prototype.clone=function(){this.destroyContent();return C.prototype.clone.apply(this,arguments);};
h.prototype.exit=function(){this._oDefaultModel.destroy();if(this._oConfigBinding){this._oConfigBinding.destroy();}if(this._oWrapperObserver){this._oWrapperObserver.destroy();}if(this._oFragmentPromise){this._oFragmentPromise.cancel();}};
h.configMetadata={visible:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"}};
h.prototype.setConfig=function(m){var p=this.getConfig();var D={};var n=P.getType(this.getMetadata().getName()).configMetadata;f(n,function(s,q){D[s]=q.defaultValue;});var N=Object.assign({},D,m);N=this.onBeforeConfigChange(N);if(!b(p,N)){this.setProperty("config",N);this.fireConfigChange({previousConfig:p,config:N});}};
h.prototype.onBeforeConfigChange=function(m){return m;};
h.prototype.getI18nProperty=function(n,p){if(this.getModel("i18n")){return this.getModel("i18n").getResourceBundle().getText(n,p);}return n;};
h.prototype.getLabel=function(){var m=this.getAggregation("_label");if(!m){m=new L({text:"{config/label}",design:"Bold"});this.setAggregation("_label",m);}return m;};
h.prototype.enhanceAccessibilityState=function(E,A){var p=this.getParent();if(p&&p.enhanceAccessibilityState){p.enhanceAccessibilityState(this,A);}return A;};
h.prototype.getFocusDomRef=function(){var m=this.getContent();if(m&&m.isA("sap.ui.core.IFormContent")){return m.getFocusDomRef();}};
h.prototype.getIdForLabel=function(){var m=this.getContent();if(m&&m.isA("sap.ui.core.IFormContent")){return m.getIdForLabel();}};
return h;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/propertyEditor/PropertyEditorFactory',["sap/base/util/includes","sap/base/util/values"],function(i,v){"use strict";var P={};var l={};var p={};
P.registerTypes=function(t){Object.keys(t).forEach(function(s){if(!l[s]){l[s]=new Promise(function(r,a){sap.ui.require([t[s]],r,a);}).then(function(o){p[o.getMetadata().getName()]=o;return o;});}});return Promise.all(v(l)).then(function(){return p;});};
P.deregisterType=function(t){if(l[t]){delete l[t];}};
P.deregisterAllTypes=function(){l={};};
P.create=function(s){return new Promise(function(r,a){if(!s){return a("No editor type was specified in the property configuration.");}if(!l[s]){return a("Editor type was not registered");}l[s].then(function(b){return r(new b());}).catch(function(e){return a(e);});});};
P.getType=function(t){return p[t];};
P.getTypes=function(){return Object.assign({},l);};
P.hasType=function(s){return i(Object.keys(P.getTypes()),s);};
return P;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/propertyEditor/arrayEditor/ArrayEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/base/util/deepClone","sap/base/util/deepEqual","sap/base/util/ObjectPath","sap/ui/model/json/JSONModel","sap/base/util/restricted/_merge","sap/ui/integration/designtime/baseEditor/util/binding/resolveBinding","sap/ui/integration/designtime/baseEditor/util/unset","sap/base/util/restricted/_isNil","sap/base/strings/formatMessage","sap/base/util/isEmptyObject"],function(B,d,a,O,J,_,r,u,b,f,i){"use strict";
var A=B.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.arrayEditor.ArrayEditor",{
xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.arrayEditor.ArrayEditor",
metadata:{library:"sap.ui.integration",properties:{value:{type:"any"}}},
renderer:B.getMetadata().getRenderer().render
});
A.configMetadata=Object.assign({},B.configMetadata,{allowAddAndRemove:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},allowSorting:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},collapsibleItems:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},showItemLabel:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},template:{defaultValue:{}}});
A.prototype.init=function(){B.prototype.init.apply(this,arguments);this._itemsModel=new J();this._itemsModel.setDefaultBindingMode("OneWay");this.setModel(this._itemsModel,"itemsModel");};
A.prototype.setValue=function(v){v=Array.isArray(v)?v:[];B.prototype.setValue.call(this,v);this._handleValueChange(this.getValue());};
A.prototype._handleValueChange=function(v){var c=this.getConfig();var I=[];v.forEach(function(V,e){var o=d(V);var D=this.getNestedDesigntimeMetadata(e);var m={itemLabel:c.itemLabel||this.getI18nProperty("BASE_EDITOR.ARRAY.ITEM_LABEL"),index:e,total:v.length,properties:Object.keys(c.template).map(function(k){var t=c.template[k];var P=e+"/"+t.path;var g=O.get(P.split("/"),v);if(typeof g==="undefined"){O.set(t.path.split('/'),d(t.defaultValue),o);}return _({},t,{path:P,value:g,designtime:(D||{})[k]});},this)};var p=new J(o);m.properties=r(m.properties,{"":p},{"":p.getContext("/")},["template","value","itemLabel"]);m.itemLabel=r({itemLabel:m.itemLabel},{"":p},{"":p.getContext("/")}).itemLabel||f(this.getI18nProperty("BASE_EDITOR.ARRAY.NEW_ITEM_LABEL"),[c.addItemLabel||this.getI18nProperty("BASE_EDITOR.ARRAY.ITEM_LABEL")]);p.destroy();I.push(m);},this);this._itemsModel.setData(I);};
A.prototype.onBeforeConfigChange=function(c){if(!c.collapsibleItems){this.setFragment("sap.ui.integration.designtime.baseEditor.propertyEditor.arrayEditor.ArrayEditorPlain");}return c;};
A.prototype.getExpectedWrapperCount=function(v){return v.length;};
A.prototype._removeItem=function(e){var I=e.getSource().data("index");var v=(this.getValue()||[]).slice();v.splice(I,1);this.setValue(v);};
A.prototype._addItem=function(){var c=this.getConfig();var v=(this.getValue()||[]).slice();var D={};Object.keys(c.template).forEach(function(k){var p=c.template[k];if(p.type==="array"){D[k]=[];}});v.push(D);this.setValue(v);};
A.prototype._moveUp=function(e){var I=e.getSource().data("index");if(I>0){var v=this.getValue().slice();var R=v.splice(I,1)[0];v.splice(I-1,0,R);this.setValue(v);}};
A.prototype._moveDown=function(e){var I=e.getSource().data("index");var v=this.getValue().slice();if(I<v.length-1){var R=v.splice(I,1)[0];v.splice(I+1,0,R);this.setValue(v);}};
A.prototype._propertyEditorsChange=function(e){e.getParameter("previousPropertyEditors").forEach(function(p){p.detachValueChange(this._onPropertyValueChange,this);p.detachDesigntimeMetadataChange(this._onDesigntimeMetadataChange,this);},this);e.getParameter("propertyEditors").forEach(function(p){p.attachValueChange(this._onPropertyValueChange,this);p.attachDesigntimeMetadataChange(this._onDesigntimeMetadataChange,this);},this);};
A.prototype._onPropertyValueChange=function(e){var p=e.getSource();var E=d(this.getValue()||[]);var P=e.getParameter("path");var c=P.split("/");var v=e.getParameter("value");O.set(c,v,E);if(typeof v==="undefined"||a(v,p.getConfig().defaultValue)){u(E,c,c.length-2);}this.setValue(E);};
A.prototype._onDesigntimeMetadataChange=function(e){var n={};O.set(e.getParameter("path").split("/"),e.getParameter("value"),n);this.setDesigntimeMetadata(_({},this.getDesigntimeMetadata(),n));this.setValue(this.getValue());};
A.prototype._isNewItem=function(m){return(m&&m.properties||[]).every(function(o){var v=o.value;return b(v)||Array.isArray(v)&&v.length===0||i(v);});};
A.prototype.formatAddItemText=function(s,I,F){return f(s,[I||F]);};
return A;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/propertyEditor/booleanEditor/BooleanEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/integration/designtime/baseEditor/util/isValidBindingString"],function(B,i){"use strict";
var a=B.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.booleanEditor.BooleanEditor",{
xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.booleanEditor.BooleanEditor",
metadata:{library:"sap.ui.integration"},
renderer:B.getMetadata().getRenderer().render
});
a.prototype.getDefaultValidators=function(){var c=this.getConfig();return Object.assign({},B.prototype.getDefaultValidators.call(this),{isValidBinding:{type:"isValidBinding",isEnabled:c.allowBindings},notABinding:{type:"notABinding",isEnabled:!c.allowBindings},isBoolean:{type:"isBoolean"}});};
a.prototype._onChange=function(){var c=this.getContent();var v=c.getSelectedKey()||c.getValue();if(v==="false"){v=false;}else if(v==="true"){v=true;}this.setValue(v);};
a.configMetadata=Object.assign({},B.configMetadata,{allowBindings:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"}});return a;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/propertyEditor/dateEditor/DateEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/core/format/DateFormat"],function(B,D){"use strict";
var a=B.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.dateEditor.DateEditor",{
xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.dateEditor.DateEditor",
metadata:{library:"sap.ui.integration"},
renderer:B.getMetadata().getRenderer().render
});
a.prototype.getDefaultValidators=function(){var c=this.getConfig();return Object.assign({},B.prototype.getDefaultValidators.call(this),{isValidBinding:{type:"isValidBinding",isEnabled:c.allowBindings},notABinding:{type:"notABinding",isEnabled:!c.allowBindings},isDate:{type:"isDate"}});};
a.prototype.formatValue=function(v){var d=new Date(v);if(!this._isValidDate(d)){return v;}return this.getFormatterInstance().format(d);};
a.configMetadata=Object.assign({},B.configMetadata,{allowBindings:{defaultValue:true}});
a.prototype.onFragmentReady=function(){var d=this.getContent();d.onkeypress=function(e){if(!e.charCode||e.metaKey||e.ctrlKey){return;}};};
a.prototype._onChange=function(e){var v=e.getParameter("newValue");var p=this._parse(v);this.setValue(p);};
a.prototype._parse=function(v){if(v===""){return undefined;}var p=new Date(v);return this._isValidDate(p)?p.toISOString():v;};
a.prototype._isValidDate=function(d){return d&&!isNaN(d.getTime());};
a.prototype.getFormatterInstance=function(){return D.getDateInstance();};
return a;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/propertyEditor/dateTimeEditor/DateTimeEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/integration/designtime/baseEditor/propertyEditor/dateEditor/DateEditor","sap/ui/core/format/DateFormat"],function(B,D,a){"use strict";
var b=D.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.dateTimeEditor.DateTimeEditor",{
xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.dateTimeEditor.DateTimeEditor",
metadata:{library:"sap.ui.integration"},
renderer:B.getMetadata().getRenderer().render
});
b.prototype.getFormatterInstance=function(){return a.getDateTimeInstance();};
b.configMetadata=Object.assign({},D.configMetadata);return b;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/propertyEditor/enumStringEditor/EnumStringEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/integration/designtime/baseEditor/util/isValidBindingString"],function(B,i){"use strict";
var E=B.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.enumStringEditor.EnumStringEditor",{
xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.enumStringEditor.EnumStringEditor",
metadata:{library:"sap.ui.integration"},
renderer:B.getMetadata().getRenderer().render
});
E.configMetadata=Object.assign({},B.configMetadata,{allowBindings:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},allowCustomValues:{defaultValue:false,mergeStrategy:"mostRestrictiveWins",mostRestrictiveValue:true}});
E.prototype.getDefaultValidators=function(){var c=this.getConfig();return Object.assign({},B.prototype.getDefaultValidators.call(this),{isValidBinding:{type:"isValidBinding",isEnabled:c.allowBindings},notABinding:{type:"notABinding",isEnabled:!c.allowBindings},isSelectedKey:{type:"isSelectedKey",config:{keys:function(p){return p.getConfig().enum;}},isEnabled:!c.allowCustomValues}});};
E.prototype._onChange=function(){var c=this.getContent();var s=c.getSelectedKey();var v=c.getValue();this.setValue(s||v);};
return E;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/propertyEditor/iconEditor/IconEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/core/ListItem","sap/ui/core/Fragment","sap/ui/model/json/JSONModel","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/core/IconPool","sap/ui/base/BindingParser","sap/ui/integration/designtime/baseEditor/util/isValidBindingString","./IsInIconPool.validator"],function(B,L,F,J,a,b,I,c,i,d){"use strict";var o=null;
var e=B.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.iconEditor.IconEditor",{
xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.iconEditor.IconEditor",
metadata:{library:"sap.ui.integration"},
renderer:B.getMetadata().getRenderer().render
});
e.configMetadata=Object.assign({},B.configMetadata);
e.prototype.onFragmentReady=function(){var f=this.getContent();this._oIconModel=this._getIconModel();f.setModel(this._oIconModel,"icons");f.bindAggregation("suggestionItems","icons>/",new L({text:"{icons>path}",additionalText:"{icons>name}"}));};
e.prototype._getIconModel=function(){if(!o){o=new J(I.getIconNames().map(function(n){return{name:n,path:"sap-icon://"+n};}));}return o;};
e.prototype._onChange=function(E){var s=E.getParameter("value");this.setValue(s);};
e.prototype._onSuggestionItemSelected=function(E){this.setValue(E.getParameter("selectedItem").getText());};
e.prototype._getDefaultSearchValue=function(s){try{var p=c.complexParser(s);return p?"":s;}catch(E){return s;}};
e.prototype._handleValueHelp=function(E){var v=E.getSource().getValue();if(!this._oDialog){return F.load({name:"sap.ui.integration.designtime.baseEditor.propertyEditor.iconEditor.IconEditorDialog",controller:this}).then(function(D){this._oDialog=D;this.addDependent(this._oDialog);this._oDialog.setModel(this._oIconModel);this._filter(v);this._oDialog.open(this._getDefaultSearchValue(v));return this._oDialog;}.bind(this));}else{this._filter(v);this._oDialog.open(this._getDefaultSearchValue(v));return Promise.resolve(this._oDialog);}};
e.prototype.handleSearch=function(E){var v=E.getParameter("value");this._filter(v);};
e.prototype._filter=function(v){var f=new a("path",b.Contains,v);var g=this._oDialog.getBinding("items");g.filter([f]);};
e.prototype.handleClose=function(E){var s=E.getParameter("selectedItem");if(s){this.setValue(s.getIcon());}E.getSource().getBinding("items").filter([]);};
e.prototype.getDefaultValidators=function(){return Object.assign({},B.prototype.getDefaultValidators.call(this),{isValidBinding:{type:"isValidBinding"},isInIconPool:{type:"isInIconPool"}});};
e.prototype.getDefaultValidatorModules=function(){return Object.assign({},B.prototype.getDefaultValidatorModules.apply(this,arguments),{isInIconPool:d});};
return e;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/propertyEditor/iconEditor/IsInIconPool.validator',["sap/ui/integration/designtime/baseEditor/validator/IsValidBinding","sap/base/util/restricted/_isNil","sap/ui/core/IconPool"],function(I,_,a){"use strict";return{async:false,errorMessage:"BASE_EDITOR.VALIDATOR.NOT_AN_ICON",validate:function(v){return _(v)||(typeof v==="string"&&a.isIconURI(v)&&!!a.getIconInfo(v))||I.validate(v,{allowPlainStrings:false});}};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/propertyEditor/integerEditor/IntegerEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/integration/designtime/baseEditor/propertyEditor/numberEditor/NumberEditor","sap/ui/core/format/NumberFormat"],function(B,N,a){"use strict";
var I=N.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.integerEditor.IntegerEditor",{
invalidInputError:"BASE_EDITOR.INTEGER.INVALID_BINDING_OR_INTEGER",
metadata:{library:"sap.ui.integration"},
renderer:B.getMetadata().getRenderer().render
});
I.prototype.getDefaultValidators=function(){return Object.assign({},B.prototype.getDefaultValidators.call(this),{isInteger:{type:"isInteger"}});};
I.configMetadata=Object.assign({},N.configMetadata);
I.prototype.validateNumber=function(v){return N.prototype.validateNumber.call(this,v)&&Number.isInteger(v);};
I.prototype.getFormatterInstance=function(){return a.getIntegerInstance();};
return I;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/propertyEditor/jsonEditor/JsonEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/core/Fragment"],function(B,F){"use strict";
var J=B.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.jsonEditor.JsonEditor",{
xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.jsonEditor.JsonEditor",
metadata:{library:"sap.ui.integration"},
_onLiveChange:function(){var i=this.getContent();var j=this._parseJson(i.getValue());if(j instanceof Error){i.setValueState("Error");i.setValueStateText("Error: "+j);}else{i.setValueState("None");this.setValue(j);}},
_parseJson:function(j){try{var p=JSON.parse(j);return p;}catch(e){return e;}},
_openJsonEditor:function(){if(!this._oDialog){return F.load({name:"sap.ui.integration.designtime.baseEditor.propertyEditor.jsonEditor.JsonEditorDialog",controller:this}).then(function(d){this._oDialog=d;this._oErrorMsg=this._oDialog.getContent()[0];this._oEditor=this._oDialog.getContent()[1];this._oEditor.getInternalEditorInstance().getSession().on("changeAnnotation",this.onShowError.bind(this));this._oDialog.attachAfterOpen(function(){this._oEditor.getInternalEditorInstance().focus();this._oEditor.getInternalEditorInstance().navigateFileEnd();},this);this.addDependent(this._oDialog);this._openDialog();return this._oDialog;}.bind(this));}else{this._openDialog();return Promise.resolve(this._oDialog);}},
_openDialog:function(){var i=this.getContent().getValue();try{var c=JSON.stringify(JSON.parse(i),0,"\t");this._oEditor.setValue(c);}catch(e){this._oEditor.setValue(i);}this._oDialog.open();},
onClose:function(){this._oCode=null;this._oDialog.close();},
onBeautify:function(){try{var b=JSON.stringify(JSON.parse(this._oEditor.getValue()),0,"\t");this._oEditor.setValue(b);}finally{return;}},
onLiveChange:function(e){try{this._oCode=JSON.parse(e.getParameter("value"));this._oDialog.getBeginButton().setEnabled(true);}catch(a){this._oDialog.getBeginButton().setEnabled(false);}},
onShowError:function(){var e=(this._oEditor.getInternalEditorInstance().getSession().getAnnotations()||[]).map(function(E){return"Line "+String(E.row)+": "+E.text;}).join("\n");this._oErrorMsg.setText(e);this._oErrorMsg.setVisible(!!e);},
onSave:function(){var i=this.getContent();if(this._oCode){this.setValue(this._oCode);i.setValueState("None");i.setValue(JSON.stringify(this._oCode));}this._oDialog.close();},
renderer:B.getMetadata().getRenderer().render
});
J.configMetadata=Object.assign({},B.configMetadata);return J;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/propertyEditor/listEditor/ListEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/integration/designtime/baseEditor/validator/IsValidBinding"],function(B,I){"use strict";
var L=B.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.listEditor.ListEditor",{
xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.listEditor.ListEditor",
metadata:{library:"sap.ui.integration"},
renderer:B.getMetadata().getRenderer().render
});
L.prototype.onFragmentReady=function(){this.attachValueChange(function(){this.getContent().setValue("");}.bind(this));};
L.prototype.getDefaultValidators=function(){return Object.assign({},B.prototype.getDefaultValidators.call(this),{isUniqueList:{type:"isUniqueList"},isStringList:{type:"isStringList"}});};
L.configMetadata=Object.assign({},B.configMetadata);
L.prototype._onTokenUpdate=function(e){this._setTokens(e.getParameter("addedTokens").map(function(t){return t.getText();}),e.getParameter("removedTokens").map(function(t){return t.getText();}));};
L.prototype._onTokenSubmission=function(e){this._setTokens([e.getParameter("value")],[]);};
L.prototype._onLiveChange=function(e){var v=e.getParameter("newValue");this._validateInput(v);};
L.prototype._setTokens=function(a,r){var v=(this.getValue()||[]).filter(function(t){return r.indexOf(t)<0;});var n=v.concat(a);this.setValue(n);};
L.prototype._validateInput=function(t){this.setInputState(!I.validate(t),this.getI18nProperty(I.errorMessage));};
return L;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/propertyEditor/mapEditor/MapEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/base/util/deepClone","sap/base/util/deepEqual","sap/ui/model/json/JSONModel","sap/base/util/restricted/_merge","sap/base/util/restricted/_omit","sap/base/util/isPlainObject","sap/base/util/includes"],function(B,d,c,J,_,e,i,f){"use strict";var S={"string":"BASE_EDITOR.MAP.TYPES.STRING","boolean":"BASE_EDITOR.MAP.TYPES.BOOLEAN","number":"BASE_EDITOR.MAP.TYPES.NUMBER","integer":"BASE_EDITOR.MAP.TYPES.INTEGER","date":"BASE_EDITOR.MAP.TYPES.DATE","datetime":"BASE_EDITOR.MAP.TYPES.DATETIME"};
var M=B.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.mapEditor.MapEditor",{
xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.mapEditor.MapEditor",
metadata:{library:"sap.ui.integration"},
init:function(){B.prototype.init.apply(this,arguments);this._itemsModel=new J();this._itemsModel.setDefaultBindingMode("OneWay");this.setModel(this._itemsModel,"itemsModel");this._supportedTypesModel=new J();this._supportedTypesModel.setDefaultBindingMode("OneWay");this.setModel(this._supportedTypesModel,"supportedTypes");this.attachModelContextChange(function(){if(this.getModel("i18n")){var r=this.getModel("i18n").getResourceBundle();this._aSupportedTypes=Object.keys(S).map(function(k){return{key:k,label:r.getText(S[k])};});this._setSupportedTypesModel();}},this);this.attachConfigChange(this._setSupportedTypesModel,this);this._mTypes={};},
setValue:function(v){v=i(v)?v:{};var p=this._getPositions(v);this.setDesigntimeMetadata(_({},this.getDesigntimeMetadata(),Object.keys(p).reduce(function(n,k){n[k]={__value:{position:p[k]}};return n;},{})));B.prototype.setValue.call(this,v);var I=this._processValue(v);I=I.sort(function(V,o){return p[V.key]-p[o.key];}).map(function(o,a){o.index=a;o.total=I.length;return o;});this._itemsModel.setData(I);},
_processValue:function(v){return Object.keys(v).map(function(k){var F=this._prepareInputValue(v[k],k);this._mTypes[k]=F.type;var I={key:k,value:F,designtime:this.getNestedDesigntimeMetadata(k)};return this.getConfig().includeInvalidEntries||this._isValidItem(I,d(v[k]))?I:undefined;},this).filter(Boolean);},
_getPositions:function(v){var k=Object.keys(v);var E=k.map(function(K){var a=this.getNestedDesigntimeMetadataValue(K).position;return a>=0?a:-1;}.bind(this));var n=E.reduce(function(a,b){return Math.max(a,b);},-1);var p={};E.forEach(function(a,b){p[k[b]]=a>=0?a:++n;});return p;},
_prepareInputValue:function(v,k){var F=this.processInputValue(d(v),k);if(!F.type){F.type=this._mTypes[k]||this._getDefaultType(F.value);}return F;},
_isValidItem:function(I){var t=I.value.type;return t&&f(this._getAllowedTypes(),t);},
_getDefaultType:function(v){var a=this._getAllowedTypes();var t=typeof v;var C=f(a,t)?t:undefined;if(!C&&f(a,"string")){C="string";}return C;},
_getAllowedTypes:function(){return(this.getConfig()||M.configMetadata).allowedTypes;},
_setSupportedTypesModel:function(){var a=this._getAllowedTypes();this._supportedTypesModel.setData(this._aSupportedTypes.filter(function(s){return f(a,s.key);}));},
formatItemConfig:function(C){var k=C.key;var t=C.value.type;var v=C.value.value;if(t==="boolean"){v=C.value.value!==false;}var D=(C.designtime||{}).__value;var o=this.getConfig();return[{label:this.getI18nProperty("BASE_EDITOR.MAP.KEY"),path:"key",value:k,type:"string",enabled:o.allowKeyChange,itemKey:k,allowBindings:false,validators:[{type:"isUniqueKey",config:{keys:function(){return Object.keys(this.getValue());}.bind(this),currentKey:function(p){return p.getValue();}}}]},{label:this.getI18nProperty("BASE_EDITOR.MAP.TYPE"),path:"type",value:t,type:"select",items:this._getAllowedTypes().map(function(k){return{key:k,title:this.getI18nProperty(S[k])};}.bind(this)),visible:o.allowTypeChange,itemKey:k,allowBindings:false},{label:this.getI18nProperty("BASE_EDITOR.MAP.VALUE"),path:"value",value:v,type:t,itemKey:k,designtime:(D||{}).value}];},
getExpectedWrapperCount:function(v){return this._processValue(v).length;},
processInputValue:function(v){return{value:v};},
processOutputValue:function(v){return v.value;},
_onRemoveElement:function(E){var k=E.getSource().getBindingContext("itemsModel").getObject().key;var v=this.getValue();this.setValue(e(v,k));var n=d(this.getDesigntimeMetadata());delete n[k];this.setDesigntimeMetadata(n);},
_onAddElement:function(){var p=_({},this.getValue());var k=this._getUniqueKey(p);p[k]=this.processOutputValue(this._getItemTemplate());this.setValue(p);},
_moveUp:function(E){var I=E.getSource().data("index");if(I>0){var v=this._itemsModel.getData();this._swapPositions(v[I].key,v[I-1].key);}},
_moveDown:function(E){var I=E.getSource().data("index");var v=this._itemsModel.getData();if(I<v.length-1){this._swapPositions(v[I].key,v[I+1].key);}},
_swapPositions:function(k,K){var n={};n[k]={__value:{position:this.getNestedDesigntimeMetadataValue(K).position}};n[K]={__value:{position:this.getNestedDesigntimeMetadataValue(k).position}};this.setDesigntimeMetadata(_({},this.getDesigntimeMetadata(),n));this.setValue(this.getValue());},
_getItemTemplate:function(){return{value:"",type:"string"};},
_isNewItem:function(I){return c(I.value,this._prepareInputValue(this.processOutputValue(this._getItemTemplate())));},
_getUniqueKey:function(p){var k="key";var I=0;while(p.hasOwnProperty(k)){k="key"+ ++I;}return k;},
_propertyEditorsChange:function(E){var p=E.getParameter("previousPropertyEditors");var P=E.getParameter("propertyEditors");if(Array.isArray(p)){p.forEach(function(o){o.detachValueChange(this._onItemChange,this);o.detachDesigntimeMetadataChange(this._onDesigntimeValueChange,this);},this);}if(Array.isArray(P)){P.forEach(function(o){o.attachValueChange(this._onItemChange,this);o.attachDesigntimeMetadataChange(this._onDesigntimeValueChange,this);},this);}},
_onItemChange:function(E){var k=E.getSource().getConfig().itemKey;var C=E.getParameter("path");var h=this.getItemChangeHandlers()[C];if(typeof h!=='function'){h=this._onFieldChange;}h.call(this,k,E);},
_onDesigntimeValueChange:function(E){var k=E.getSource().getConfig().itemKey;var C=E.getParameter("path");if(C!=="value"){return;}this._onDesigntimeChange(k,E);},
_onDesigntimeChange:function(k,E){var D=_({},this.getConfig().designtime);var n={__value:{}};n.__value[E.getParameter("path")]=E.getParameter("value");D[k]=_({},D[k],n);this.setDesigntimeMetadata(D);this.setValue(this.getValue());},
getItemChangeHandlers:function(){return{"key":this._onKeyChange,"type":this._onTypeChange};},
_onKeyChange:function(o,E){if(E.getParameter("previousValue")===undefined){return;}var a=_({},this.getValue());var n=E.getParameter("value");if(n!==o){var N={};Object.keys(a).forEach(function(I){var s=I===o?n:I;N[s]=a[I];});this._mTypes[n]=this._mTypes[o];delete this._mTypes[o];this.setValue(N);var D=_({},this.getConfig().designtime);if(D.hasOwnProperty(o)){D[n]=D[o];delete D[o];this.setDesigntimeMetadata(D);}}},
_onTypeChange:function(k,E){if(E.getParameter("previousValue")===undefined){return;}var o=_({},this.getValue());var n=E.getParameter("value");var I=this.processInputValue(o[k]);I.type=n;o[k]=this.processOutputValue(I);this._mTypes[k]=n;this.setValue(o);},
_onFieldChange:function(k,E){var o=_({},this.getValue());var p=E.getParameter("path");var v=E.getParameter("value");var I=this.processInputValue(o[k]);I[p]=v;o[k]=this.processOutputValue(I);this.setValue(o);},
renderer:B.getMetadata().getRenderer().render
});
M.configMetadata=Object.assign({},B.configMetadata,{allowKeyChange:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},allowTypeChange:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},allowAddAndRemove:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},allowedTypes:{defaultValue:["string"],mergeStrategy:"intersection"},allowSorting:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},includeInvalidEntries:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"}});return M;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/propertyEditor/numberEditor/NumberEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/integration/designtime/baseEditor/util/isValidBindingString","sap/base/util/restricted/_isNil","sap/ui/core/format/NumberFormat"],function(B,i,_,N){"use strict";
var a=B.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.numberEditor.NumberEditor",{
xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.numberEditor.NumberEditor",
metadata:{library:"sap.ui.integration"},
invalidInputError:"BASE_EDITOR.NUMBER.INVALID_BINDING_OR_NUMBER",
renderer:B.getMetadata().getRenderer().render
});
a.prototype.getDefaultValidators=function(){return Object.assign({},B.prototype.getDefaultValidators.call(this),{isNumber:{type:"isNumber"}});};
a.configMetadata=Object.assign({},B.configMetadata);
a.prototype.formatValue=function(v){if(_(v)||i(v,false)){return v;}var n=parseFloat(v);if(!this.validateNumber(n)){return v;}return this.getFormatterInstance().format(n);};
a.prototype._onLiveChange=function(e){var n=this._parseLocalized(e.getParameter("newValue"));B.prototype.setValue.call(this,n);};
a.prototype.validateNumber=function(v){return!isNaN(v);};
a.prototype.getFormatterInstance=function(){return N.getFloatInstance();};
a.prototype._parseLocalized=function(v){if(!v||i(v,false)){return v;}var n=this.getFormatterInstance().parse(v);return n;};
return a;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/propertyEditor/selectEditor/SelectEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/integration/designtime/baseEditor/util/isValidBindingString"],function(B,i){"use strict";
var S=B.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.selectEditor.SelectEditor",{
xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.selectEditor.SelectEditor",
metadata:{library:"sap.ui.integration"},
renderer:B.getMetadata().getRenderer().render
});
S.configMetadata=Object.assign({},B.configMetadata,{allowBindings:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},allowCustomValues:{defaultValue:false,mergeStrategy:"mostRestrictiveWins",mostRestrictiveValue:true}});
S.prototype.getDefaultValidators=function(){var c=this.getConfig();return Object.assign({},B.prototype.getDefaultValidators.call(this),{isValidBinding:{type:"isValidBinding",isEnabled:c.allowBindings},notABinding:{type:"notABinding",isEnabled:!c.allowBindings},isSelectedKey:{type:"isSelectedKey",config:{keys:function(p){return p.getConfig().items.map(function(I){return I.key;});}},isEnabled:!c.allowCustomValues}});};
S.prototype._onChange=function(){var c=this.getContent();var s=c.getSelectedKey();var v=c.getValue();this.setValue(s||v);};
S.prototype._getItemTitle=function(v){var I=this.getConfig()&&this.getConfig().items||[];var s=I.find(function(o){return o.key===v;});return(s||{}).title||v;};
return S;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/propertyEditor/stringEditor/StringEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/base/util/restricted/_isNil","sap/base/util/isPlainObject"],function(B,_,i){"use strict";
var S=B.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.stringEditor.StringEditor",{
xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.stringEditor.StringEditor",
metadata:{library:"sap.ui.integration"},
renderer:B.getMetadata().getRenderer().render
});
S.configMetadata=Object.assign({},B.configMetadata,{enabled:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},allowBindings:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"}});
S.prototype.getDefaultValidators=function(){var c=this.getConfig();return Object.assign({},B.prototype.getDefaultValidators.call(this),{isValidBinding:{type:"isValidBinding",isEnabled:c.allowBindings},notABinding:{type:"notABinding",isEnabled:!c.allowBindings},maxLength:{type:"maxLength",isEnabled:typeof c.maxLength==="number",config:{maxLength:c.maxLength}}});};
S.prototype.setValue=function(v){if(!_(v)&&!i(v)){arguments[0]=v.toString();}B.prototype.setValue.apply(this,arguments);};
S.prototype._onLiveChange=function(){var I=this.getContent();this.setValue(I.getValue());};
return S;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/util/BaseDefaultValidatorModules',["sap/ui/integration/designtime/baseEditor/validator/NotABinding","sap/ui/integration/designtime/baseEditor/validator/IsValidBinding","sap/ui/integration/designtime/baseEditor/validator/IsSelectedKey","sap/ui/integration/designtime/baseEditor/validator/IsUniqueKey","sap/ui/integration/designtime/baseEditor/validator/IsNumber","sap/ui/integration/designtime/baseEditor/validator/IsInteger","sap/ui/integration/designtime/baseEditor/validator/IsBoolean","sap/ui/integration/designtime/baseEditor/validator/IsDate","sap/ui/integration/designtime/baseEditor/validator/IsStringList","sap/ui/integration/designtime/baseEditor/validator/IsUniqueList","sap/ui/integration/designtime/baseEditor/validator/MaxLength","sap/ui/integration/designtime/baseEditor/validator/IsPatternMatch"],function(N,I,a,b,c,d,e,f,g,h,M,i){"use strict";return{"notABinding":N,"isValidBinding":I,"isSelectedKey":a,"isUniqueKey":b,"isNumber":c,"isInteger":d,"isBoolean":e,"isDate":f,"isUniqueList":h,"isStringList":g,"maxLength":M,"pattern":i};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/util/StylesheetManager',["sap/ui/dom/includeStylesheet","sap/base/util/uid"],function(i,u){"use strict";var S="SUCCESS";var a="FAIL";var b="PENDING";var s={};
function l(F){var C={id:u(),status:b,counter:1};var p=new Promise(function(r,R){i(F,C.id,r,R);}).then(function(){var C=s[F];if(C.counter===0){d(F);}else{f(F,S);}}).catch(function(){f(F,a);return Promise.reject("File not found or some other network issue happened.");});C.promise=p;s=Object.assign({},s);s[F]=C;return C.promise;}
function d(F){var m=Object.assign({},s);var C=m[F];var E=document.getElementById(C.id);if(E&&E.parentNode){E.parentNode.removeChild(E);}delete m[F];s=m;}
function c(F){var D={};D[F]=Object.assign({},s[F]);D[F].counter++;s=Object.assign({},s,D);return s[F];}
function e(F){var D={};D[F]=Object.assign({},s[F]);D[F].counter--;s=Object.assign({},s,D);return s[F];}
function f(F,h){var D={};D[F]=Object.assign({},s[F]);D[F].status=h;s=Object.assign({},s,D);return s[F];}
function g(m){return sap.ui.require.toUrl(m)+".css";}
return{add:function(m){var F=g(m);var h=s[F];if(h){c(F);return h.promise;}return l(F);},remove:function(m){var F=g(m);var C=s[F];if(C){var U=e(F);if(U.counter===0&&U.status===S){d(F);}}}};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/util/binding/ObjectBinding',["sap/ui/base/ManagedObject","sap/base/util/deepClone","sap/base/util/ObjectPath","sap/base/util/isPlainObject","sap/ui/base/BindingParser","sap/base/util/includes","sap/base/util/deepEqual"],function(M,d,O,i,B,a,b){"use strict";
var c=M.extend("sap.ui.integration.designtime.baseEditor.util.ObjectBinding",{
metadata:{library:"sap.ui.integration",properties:{object:{type:"object"},_value:{type:"any",hidden:true}},events:{change:{parameters:{path:{type:"string"},value:{type:"any"}}}}},
_originalObject:null
});
c.prototype.init=function(){this._aIgnoreList=[];this._oModelMap={};};
c.prototype.exit=function(){this._cleanup();};
c.prototype.setObject=function(o){this._setOriginalObject(o);this._init();return this;};
c.prototype._setObject=function(o){var C=d(o,50);return this.setProperty("object",C);};
c.prototype._setOriginalObject=function(o){this._originalObject=d(o,50);};
c.prototype._getOriginalObject=function(){return this._originalObject;};
c.prototype.setModel=function(m,n){var e=false;var E=Object.keys(this.oModels||{}).find(function(s){if(this.oModels[s]===m){e=true;return true;}return false;}.bind(this));this._oModelMap[n]=e?this._oModelMap[E]:n;var r=M.prototype.setModel.apply(this,arguments);this._init();return r;};
c.prototype.setBindingContext=function(){var r=M.prototype.setBindingContext.apply(this,arguments);this._init();return r;};
c.prototype._init=function(){this._cleanup();var o=this._getOriginalObject();if(o){this._setObject(o);this._createPropertyBindings(o);}};
c.prototype._cleanup=function(){if(this._mSimpleBindings){Object.keys(this._mSimpleBindings).forEach(function(k){var o=this._mSimpleBindings[k].binding;o.getModel().removeBinding(o);o.destroy();}.bind(this));}this._mSimpleBindings={};};
c.prototype._createPropertyBindings=function(o,p){Object.keys(o).filter(function(k){return!this.isIgnored(k);},this).forEach(function(k){var C=p?p+"/"+k:k;if(typeof o[k]==="string"){var e=B.complexParser(o[k]);if(e){if(e.parts){if(!e.parts.find(function(P){return!this.getModel(P.model);}.bind(this))){e.parts.forEach(function(P){this._createSimpleBinding(P,C,e);}.bind(this));}else{return;}}else if(this.getModel(e.model)){this._createSimpleBinding(e,C,e);}else{return;}this._updateValue([{path:C,bindingInfo:e}]);}}else if(o[k]&&(i(o[k])||Array.isArray(o[k]))){this._createPropertyBindings(o[k],C);}},this);};
c.prototype._updateValue=function(v){var C=[];v.forEach(function(u){var o=this.getObject();var p=u.path.split("/");var k=p.pop();if(p.length){o=O.get(p,o);}this.bindProperty("_value",d(u.bindingInfo));var V=d(this.getProperty("_value"));this.unbindProperty("_value");if(V!==o[k]&&(k!=="value"||!(o.value===undefined&&b(V,o.defaultValue)))){o[k]=V;C.push({path:u.path,value:V});}}.bind(this));if(C.length){this.fireChange({changes:C});}};
c.prototype._createSimpleBinding=function(s,C,o){var e=this.getBindingContext(s.model);var m=this._oModelMap[s.model];var f=this.oModels[s.model];var A=f.resolve(s.path,e);var h=m+">"+A;var g=this._mSimpleBindings[h];if(!g){g=this.getModel(s.model).bindProperty(s.path,e);this._mSimpleBindings[h]={binding:g,properties:[]};g.attachChange(function(){this._updateValue(this._mSimpleBindings[h].properties);}.bind(this));}this._mSimpleBindings[h].properties.push({path:C,bindingInfo:o});return g;};
c.prototype.addToIgnore=function(k){this._aIgnoreList=this._aIgnoreList.concat(k);this._init();};
c.prototype.removeFromIgnore=function(k){this._aIgnoreList=this._aIgnoreList.filter(function(I){return I!==k;});this._init();};
c.prototype.isIgnored=function(k){return a(this._aIgnoreList,k);};
return c;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/util/binding/resolveBinding',["sap/ui/integration/designtime/baseEditor/util/binding/ObjectBinding"],function(O){"use strict";return function(j,m,c,i){var o=new O();c=c||{};i=i||[];i.forEach(function(p){o.addToIgnore(p);});Object.keys(m).forEach(function(k){o.setModel(m[k],k===""?undefined:k);});Object.keys(c).forEach(function(k){o.setBindingContext(c[k],k===""?undefined:k);});o.setObject(j);var r=o.getObject();o.destroy();return r;};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/util/cleanupDesigntimeMetadata',["sap/base/util/restricted/_isNil","sap/base/util/each","sap/base/util/isPlainObject","sap/base/util/isEmptyObject"],function(_,e,i,a){"use strict";
function c(o){e(o,function(k,v){if(i(v)){c(v);}if(_(v)||Array.isArray(v)&&v.length===0||i(v)&&a(v)){delete o[k];}});}
return c;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/util/createPromise',function(){"use strict";return function(f){var c=false;var C;var a;var b;var p=new Promise(function(r,R){f(function(){if(!c){r.apply(this,arguments);}else if(a){a.apply(this,arguments);}},function(){if(!c){R.apply(this,arguments);}else if(b){b.apply(this,arguments);}});});return{promise:p,cancel:function(){c=true;if(!C){C=new Promise(function(r,R){a=r;b=R;});}return C;}};};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/util/escapeParameter',["sap/base/util/isPlainObject","sap/base/util/each"],function(i,e){"use strict";return function(a,v){v=v||function(){return true;};var A=Array.from(a);var s=typeof A[0]!=="string"&&A[0]!==undefined?0:1;if(i(A[s])){var S=Object.assign({},A[s]);e(S,function(k,V){if(i(V)&&v(V,k)){S[k]=Object.assign({},V,{ui5object:true});}});A[s]=S;}return A;};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/util/findClosestInstance',function(){"use strict";return function(c,C){function f(c){if(c){if(c.isA(C)){return c;}else{return f(c.getParent());}}}return f(c);};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/util/hasTag',["sap/base/util/restricted/_intersection"],function(_){"use strict";return function h(c,t){var T=[].concat(t);return(Array.isArray(c.tags)&&_(T,c.tags).length===T.length);};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/util/isTemplate',function(){"use strict";
function i(c,a){var p=c.sParentAggregationName;var P=c.getParent();if(a&&P===a){return false;}if(P&&p){var b=P.getBindingInfo(p);if(b&&c instanceof b.template.getMetadata().getClass()){return false;}else{return i(P,a);}}return true;}
return i;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/util/isValidBindingString',["sap/ui/base/BindingParser"],function(B){"use strict";
function i(I,a){var p;try{var e=I.replace(/{{([^{]*)}}/g,function(f,s){if(i(s)){return"${}";}throw"Invalid binding string";});p=B.complexParser(e);}catch(E){return false;}return a!==false?true:!!p;}
return i;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/util/unset',["sap/base/util/ObjectPath","sap/base/util/isPlainObject","sap/base/util/isEmptyObject"],function(O,i,a){"use strict";
function u(o,p,m){var c=p.slice(0,-1);var C=c.length>0?O.get(c,o):o;var k=p[p.length-1];if(Array.isArray(C)){C.splice(k,1);}else{delete C[k];}return(c.length>0&&!(m<=0)&&((Array.isArray(C)&&C.length===0)||(i(C)&&a(C)))?u(o,c,m?m-1:undefined):o);}
return u;});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/validator/IsBoolean',["sap/ui/integration/designtime/baseEditor/validator/IsValidBinding","sap/base/util/restricted/_isNil"],function(I,_){"use strict";return{async:false,errorMessage:"BASE_EDITOR.VALIDATOR.NOT_A_BOOLEAN",validate:function(v){return _(v)||typeof v==="boolean"||I.validate(v,{allowPlainStrings:false});}};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/validator/IsDate',["sap/ui/integration/designtime/baseEditor/validator/IsValidBinding"],function(I){"use strict";return{async:false,errorMessage:"BASE_EDITOR.VALIDATOR.INVALID_DATE",validate:function(d){var D=new Date(d);return d===undefined||I.validate(d,{allowPlainStrings:false})||(D&&!isNaN(new Date(D).getTime()));}};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/validator/IsInteger',["sap/ui/integration/designtime/baseEditor/validator/IsValidBinding"],function(I){"use strict";return{async:false,errorMessage:"BASE_EDITOR.VALIDATOR.NOT_AN_INTEGER",validate:function(v){return v===undefined||I.validate(v,{allowPlainStrings:false})||(!isNaN(v)&&Number.isInteger(v));}};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/validator/IsNumber',["sap/ui/integration/designtime/baseEditor/validator/IsValidBinding"],function(I){"use strict";return{async:false,errorMessage:"BASE_EDITOR.VALIDATOR.NOT_A_NUMBER",validate:function(v){return v===undefined||I.validate(v,{allowPlainStrings:false})||!isNaN(v);}};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/validator/IsPatternMatch',["sap/ui/integration/designtime/baseEditor/validator/IsValidBinding"],function(I){"use strict";return{async:false,errorMessage:"BASE_EDITOR.VALIDATOR.FAILED_PATTERN_TEST",validate:function(v,c){var m=c.modifiers||"";var r=new RegExp(c.pattern,m);var e=c.exactMatch!==false;if(v===undefined){return true;}var i;if(e){var M=v.match(r);i=M&&v===M[0];}else{i=r.test(v);}return i||I.validate(v,{allowPlainStrings:false});}};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/validator/IsSelectedKey',["sap/ui/integration/designtime/baseEditor/validator/IsValidBinding"],function(I){"use strict";return{async:false,errorMessage:"BASE_EDITOR.VALIDATOR.FORBIDDEN_CUSTOM_VALUE",validate:function(v,c){return v===undefined||(c.keys||[]).includes(v)||I.validate(v,{allowPlainStrings:false});}};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/validator/IsStringList',["sap/ui/integration/designtime/baseEditor/validator/IsValidBinding"],function(I){"use strict";return{async:false,errorMessage:I.errorMessage,validate:function(v){return v===undefined||v.every(function(i){return I.validate(i);});}};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/validator/IsUniqueKey',["sap/base/util/includes"],function(i){"use strict";return{async:false,errorMessage:"BASE_EDITOR.VALIDATOR.DUPLICATE_KEY",validate:function(v,c){return(c.currentKey===undefined||!i(c.keys,v)||v===undefined||v===c.currentKey);}};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/validator/IsUniqueList',["sap/base/util/restricted/_uniq"],function(_){"use strict";return{async:false,errorMessage:"BASE_EDITOR.VALIDATOR.DUPLICATE_ENTRY",validate:function(v){return v===undefined||v.length===_(v).length;}};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/validator/IsValidBinding',["sap/ui/integration/designtime/baseEditor/util/isValidBindingString"],function(i){"use strict";return{async:false,errorMessage:"BASE_EDITOR.VALIDATOR.INVALID_BINDING",validate:function(v,c){var a=(c||{}).allowPlainStrings!==false;return v===undefined||v===""||i(v.toString(),a);}};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/validator/MaxLength',["sap/ui/integration/designtime/baseEditor/validator/IsValidBinding","sap/base/util/restricted/_isNil"],function(I,_){"use strict";return{async:false,errorMessage:{message:"BASE_EDITOR.VALIDATOR.MAX_LENGTH",placeholders:function(c){return[c.maxLength];}},validate:function(v,c){return _(v)||(typeof v==="string"&&v.length<=c.maxLength)||I.validate(v,{allowPlainStrings:false});}};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/validator/NotABinding',["sap/ui/integration/designtime/baseEditor/util/isValidBindingString"],function(i){"use strict";return{async:false,errorMessage:"BASE_EDITOR.VALIDATOR.FORBIDDEN_BINDING",validate:function(v){return!i(v,false);}};});
sap.ui.predefine('sap/ui/integration/designtime/baseEditor/validator/ValidatorRegistry',["sap/base/util/includes","sap/base/util/values","sap/base/util/restricted/_CancelablePromise"],function(i,v,_){"use strict";var V={};var o={};var l={};
V.registerValidators=function(n){Object.keys(n).forEach(function(N){if(!this.hasValidator(N)){l[N]=new _(function(r,a,b){b(function(){delete l[N];});b.shouldReject=false;sap.ui.require([n[N]],r,a);});l[N].then(function(a){o[N]=a;delete l[N];});}}.bind(this));};
V.ready=function(){return Promise.all(v(l));};
V.deregisterValidator=function(n){if(o[n]){delete o[n];}if(l[n]){l[n].cancel();}};
V.deregisterAllValidators=function(){Object.keys(l).forEach(function(n){this.deregisterValidator(n);}.bind(this));o={};};
V.getValidator=function(n){var a=o[n];if(!a){throw new Error("Validator "+n+" was not registered.");}return a;};
V.hasValidator=function(n){return i(Object.keys(o),n);};
V.isRegistered=function(n){return i(Object.keys(l),n);};
return V;});
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/BASEditor',["sap/base/util/restricted/_CancelablePromise","sap/base/util/restricted/_isEqual","sap/base/util/restricted/_omit","sap/base/util/merge","sap/base/util/deepClone","sap/base/util/ObjectPath","./CardEditor","sap/ui/integration/designtime/baseEditor/BaseEditor","sap/ui/integration/Designtime","sap/ui/integration/util/CardMerger","sap/base/util/LoaderExtensions","sap/base/Log"],function(C,_,a,m,d,O,b,B,D,c,L,e){"use strict";var f="";f=L.loadResource("sap/ui/integration/designtime/cardEditor/ConfigurationTemplate.js",{dataType:"text",failOnError:false,async:false});
var g=b.extend("sap.ui.integration.designtime.cardEditor.BASEditor",{
metadata:{library:"sap.ui.integration",events:{configurationChange:{},createConfiguration:{},error:{}}},
renderer:b.getMetadata().getRenderer()
});
g.prototype.getManifest=function(){return this._oCurrent.manifest;};
g.prototype.getConfigurationClass=function(){return this._oCurrent.configurationclass;};
g.prototype.getConfiguration=function(){return this._oCurrent.configuration;};
g.prototype.getConfigurationString=function(){return this._oCurrent.configurationstring;};
g.prototype._generateDesigntimeJSConfig=function(){var M=this._formatExportedDesigntimeMetadata(this.getDesigntimeMetadata());var J=this.getJson();if(this._eventTimeout){clearTimeout(this._eventTimeout);this._eventTimeout=null;}var k=m({},this._oDesigntimeJSConfig);this._eventTimeout=setTimeout(function(){var N={};var I=[];var l;if(J){var p=O.get(["sap.card","configuration","parameters"],J);if(!p){this._oCurrent={configuration:this._cleanConfig(this._oDesigntimeJSConfig),manifest:this._cleanJson(),configurationclass:this._fnDesigntime};this.fireConfigurationChange(this._oCurrent);return;}var q=Object.keys(p);for(var n in k.form.items){l=m({},k.form.items[n]);if(!p[n]){delete k.form.items[n];continue;}var r=q.indexOf(n);if(r>-1){q.splice(r,1);}var v;if(k.form.items[n].visualization){v=k.form.items[n].visualization;}k.form.items[n]=m(l,p[n]);if(v){k.form.items[n].visualization=v;v=null;}}if(q.length>0){for(var i=0;i<q.length;i++){var s=q[i];var u=p[s];k.form.items[s]={manifestpath:"/sap.card/configuration/parameters/"+s+"/value",type:u.type,label:u.label,translatable:false,editable:u.editable,visible:u.visible};}p[s]=m(k.form.items[s],p[s]);}}if(M){var p=O.get(["sap.card","configuration","parameters"],J);if(k){for(var n in M){var w=M[n];var K=n.substring(n.lastIndexOf("/")+1);if(!n.startsWith("sap.card/configuration/parameters")){continue;}var x=k.form.items[K];var v;if(x.visualization){v=x.visualization;}l=m(x||{},p[K]);l.label=w.hasOwnProperty("label")&&w.label;l.position=w.hasOwnProperty("position")&&w.position;if(l.editable==="false"){l.editable=false;}else if(l.editable==="true"){l.editable=false;}if(l.visible==="false"){l.visible=false;}else if(l.visible==="true"){l.visible=false;}if(v){l.visualization=v;v=null;}l.__key=K;I[l.position]=l;}for(var i=0;i<I.length;i++){l=I[i];if(!l){continue;}N[l.__key]=l;delete l.__key;delete l.position;}k.form.items=N;}}this._oDesigntimeJSConfig=k;this._fnDesigntime=function(o){return new D(o);}.bind(this,this._oDesigntimeJSConfig);this._oCurrent={configuration:this._cleanConfig(this._oDesigntimeJSConfig),manifest:this._cleanJson(),configurationclass:this._fnDesigntime,configurationstring:this._cleanConfig(this._oDesigntimeJSConfig,true)};this.fireConfigurationChange(this._oCurrent);}.bind(this),500);};
g.prototype.init=function(){b.prototype.init.apply(this,arguments);this._oCurrent={configuration:null,manifest:null,configurationclass:null};};
g.prototype._applyDefaultValue=function(i){if(i.value===undefined||i.value===null){switch(i.type){case"boolean":i.value=i.defaultValue||false;break;case"integer":case"number":i.value=i.defaultValue||0;break;case"string[]":i.value=i.defaultValue||[];break;default:i.value=i.defaultValue||"";}}};
g.prototype._cleanJson=function(J){J=J||this.getJson();var s=j(O.get(["sap.card","designtime"],J)||"");if(!s){O.set(["sap.card","designtime"],"dt/configuration",J);}J=d(J);var p=O.get(["sap.card","configuration","parameters"],J);for(var n in p){var P=p[n];if(P&&P.manifestpath&&!P.manifestpath.startsWith("/sap.card/configuration/parameters")){delete p[n];continue;}p[n]={value:p[n].value};}if(this._i18n){O.set(["sap.app","i18n"],this._i18n,J);}return J;};
g.prototype._cleanConfig=function(o,S){var o=m({},o);for(var n in o.form.items){var i=o.form.items[n];delete i.value;if(i.visualization&&i.visualization.type&&typeof i.visualization.type==="function"){if(i.visualization.type.getMetadata&&i.visualization.type.getMetadata()){var k=i.visualization.type.getMetadata().getName().replace(/\./g,"/");if(S){var I=k.lastIndexOf("/");k=I>0?k.substring(I+1):k;i.visualization.type="$$"+k+"$$";}else{i.visualization.type=i.visualization.type.getMetadata().getName().replace(/\./g,"/");}}}}if(S){var l=JSON.stringify(o,null,"\t");l=l.replace(/\"\$\$([a-zA-Z]*)\$\$\"/g,function(s){return s.substring(3,s.length-3);});return l;}return o;};
g.prototype._generateMetadataFromJSConfig=function(){var M={};if(this._oDesigntimeJSConfig){var I=this._oDesigntimeJSConfig.form.items;var i=0;for(var n in I){var p="sap.card/configuration/parameters/"+n,P=p.split("/"),o;M[p]=m({},I[n]);o=M[p];o.position=i++;if(o.visualization){o.visualization=1;}if(!o.manifestpath.startsWith("/sap.card/configuration/parameters/")||!O.get(P,this._oInitialJson)){O.set(P,o,this._oInitialJson);}O.set(P,o,this._oInitialJson);if(!o.hasOwnProperty("type")){this.fireError({"name":"Designtime Error","detail":{"message":"Type of parameter "+n+" not exist"}});}else if(o.type===""){this.fireError({"name":"Designtime Error","detail":{"message":"Type of parameter "+n+" is Invalid"}});}if(!o.hasOwnProperty("value")){var k=o.manifestpath.substring(1).split("/"),v=O.get(k,this._oInitialJson);if(v!==undefined){o.value=v;}else{this._applyDefaultValue(o);}}else{this._applyDefaultValue(o);}if(O.get(P,this._oInitialJson)){if(O.get(P,this._oInitialJson).value===undefined){O.get(P,this._oInitialJson).value=o.value;}}}}return M;};
g.prototype.setJson=function(J){if(!this._i18n){this._i18n=O.get(["sap.app","i18n"],J);}B.prototype.setJson.apply(this,arguments);if(!this.__generateDesigntimeJSConfigAttached){this.attachDesigntimeMetadataChange(this._generateDesigntimeJSConfig.bind(this));this.attachJsonChange(this._generateDesigntimeJSConfig.bind(this));this.__generateDesigntimeJSConfigAttached=true;}var J=this.getJson();var s=O.get(["sap.app","id"],J);if(this._bDesigntimeInit&&this._bCardId!==s){if(this._oDesigntimePromise){this._oDesigntimePromise.cancel();}delete this._bCardId;delete this._bDesigntimeInit;}if(!this._bDesigntimeInit){this.setPreventInitialization(true);this._bCardId=s;var T;var i=j(O.get(["sap.card","designtime"],J)||"");if(!i){var k=f;O.set(["sap.card","designtime"],"dt/configuration",J);T="sap/ui/integration/designtime/cardEditor/ConfigurationTemplate";this.fireCreateConfiguration({file:"dt/configuration.js",content:k,manifest:this._cleanJson(J)});return;}var l=j(this.getBaseUrl()||"");if(l&&i){var p={};var S=j(l);var n=t(i);var q=S+"/"+n;var N=s.replace(/\./g,"/")+"/"+n;p[N]=q;p[N+"js"]=q.substring(0,q.lastIndexOf("/"));var F=q.replace(p[N+"js"]+"/","");sap.ui.loader.config({paths:p});var r=this;this._oDesigntimePromise=new C(function(R){var u=N+"js"+"/"+F+".js";if(T){u=T+".js";}sap.ui.loader._.loadJSResourceAsync(u).then(function(o){if(!o){}else if(o){var v=new o();r._oDesigntimeJSConfig=v.getSettings();r._fnDesigntime=o;var M=r._generateMetadataFromJSConfig(r._oDesigntimeJSConfig);o=v.getMetadata().getClass();R(M);}}).catch(function(o){e.error(o);r.fireError({"name":"Designtime Error","detail":o});});});this._oDesigntimePromise.then(function(M){this.setPreventInitialization(false);var o=M;o=c.mergeCardDesigntimeMetadata(o,this.getDesigntimeChanges());this._oInitialDesigntimeMetadata=o;this.setDesigntimeMetadata(h(o),true);this._bDesigntimeInit=true;}.bind(this));}else{this.setPreventInitialization(false);}}};
g.prototype.getConfigurationTemplate=function(){return f;};
function h(F){var o={};Object.keys(F).forEach(function(p){O.set(p.split("/"),{__value:d(F[p])},o);});return o;}
function j(p){return p.trim().replace(/\/*$/,"");}
function t(p){return p.replace(/^\.\//,"");}
return g;});
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/CardEditor',["sap/base/util/restricted/_CancelablePromise","sap/base/util/restricted/_isEqual","sap/base/util/restricted/_omit","sap/base/util/restricted/_castArray","sap/base/util/deepEqual","sap/base/util/each","sap/base/util/merge","sap/base/util/deepClone","sap/base/util/ObjectPath","sap/base/util/isEmptyObject","sap/ui/integration/designtime/baseEditor/BaseEditor","sap/ui/integration/util/CardMerger","sap/ui/thirdparty/jquery","./config/index"],function(C,_,a,b,d,e,m,c,O,i,B,f,q,D){"use strict";
var g=B.extend("sap.ui.integration.designtime.cardEditor.CardEditor",{
metadata:{library:"sap.ui.integration",properties:{layout:{type:"string",defaultValue:"form"},designtimeChanges:{type:"array",defaultValue:[]},baseUrl:{type:"sap.ui.core.URI",defaultValue:null},"config":{type:"object",defaultValue:{"i18n":[].concat(B.getMetadata().getProperty("config").getDefaultValue().i18n,"sap/ui/integration/designtime/cardEditor/i18n/i18n.properties")}}}},
constructor:function(p){p=p||{};B.prototype.constructor.apply(this,arguments);this.setPreventInitialization(true);if(!p["config"]){this.addConfig(D,true);}},
renderer:B.getMetadata().getRenderer()
});
function h(o,n,N,K,v){if(!o[n]){o[n]={};}if(!o[n][N]){o[n][N]={};}o[n][N][K]=v;}
function j(J,I){var n="sap.card";var o=O.get([n,"configuration"],J);var p=O.get([n,"configuration"],I);if(d(o,p)){return undefined;}var r={};e(o,function(u,v){e(v,function(N,S){if(!p[u][N]){r[u]=r[u]||{};r[u][N]=S;}else{e(S,function(K,V){if(p[u][N][K]!==V){h(r,u,N,K,V);}});}});});return{configuration:r};}
g.prototype.init=function(){B.prototype.init.apply(this,arguments);this.attachJsonChange(function(E){if(!this._oInitialJson){this._oInitialJson=E.getParameter("json");}},this);};
g.prototype.setJson=function(){B.prototype.setJson.apply(this,arguments);var J=this.getJson();var n=O.get(["sap.app","id"],J);if(this._bDesigntimeInit&&this._bCardId!==n){if(this._oDesigntimePromise){this._oDesigntimePromise.cancel();}delete this._bCardId;delete this._bDesigntimeInit;}if(!this._bDesigntimeInit){this.setPreventInitialization(true);this._bDesigntimeInit=true;this._bCardId=n;var o=s(O.get(["sap.card","designtime"],J)||"");var p=s(this.getBaseUrl()||"");if(p&&o){var P={};var S=s(p);var r=t(o);var u=S+"/"+r;var N=n.replace(/\./g,"/")+"/"+r;P[N]=u;sap.ui.loader.config({paths:P});var E=N+"/editor.config";var I=N+"/i18n/i18n.properties";var v=u+"/metadata.json";this._oDesigntimePromise=new C(function(R){Promise.all([new Promise(function(w){sap.ui.require([E],w,function(){w({});});}),new Promise(function(w){q.getJSON(v).done(w).fail(function(){w({});});})]).then(R);});this._oDesigntimePromise.then(function(w){this.setPreventInitialization(false);var x=w[1];x=f.mergeCardDesigntimeMetadata(x,this.getDesigntimeChanges());this._oInitialDesigntimeMetadata=x;this.setDesigntimeMetadata(k(x),true);var y=w[0];if(i(y)){this.addConfig({"i18n":I});}else{y=m({},y);y.i18n=y.i18n?b(y.i18n):[];y.i18n.push(I);this._addSpecificConfig(y);}}.bind(this));}else{this.setPreventInitialization(false);this.addConfig({});}}};
g.prototype.setDesigntimeChanges=function(n){if(this._oInitialDesigntimeMetadata){throw Error("Designtime Changes can only be set initially");}this.setProperty("designtimeChanges",n);};
function k(F){var o={};Object.keys(F).forEach(function(p){O.set(p.split("/"),{__value:c(F[p])},o);});return o;}
function s(p){return p.trim().replace(/\/*$/,"");}
function t(p){return p.replace(/^\.\//,"");}
g.prototype.getChanges=function(p){return Promise.all([this.getDeltaChangeDefinition(p).catch(function(){return;}),this.getDesigntimeChangeDefinition(p).catch(function(){return;})]).then(function(n){if(n[0]===undefined&&n[1]===undefined){return Promise.reject("No changes");}return{runtimeChange:n[0],designtimeChange:n[1]};});};
function l(p){return new Promise(function(r){sap.ui.require(["sap/ui/fl/Change"],function(n){var o=n.createInitialFileContent(p);o.creation=new Date().toISOString();r(o);});});}
g.prototype.getDesigntimeChangeDefinition=function(p){var n=[];var o=Object.assign({},this._oInitialDesigntimeMetadata);var N=this._formatExportedDesigntimeMetadata(this.getDesigntimeMetadata());e(N,function(K,v){if(o.hasOwnProperty(K)){if(!_(o[K],v)){n.push({propertyPath:K,operation:"UPDATE",propertyValue:v});}delete o[K];}else{n.push({propertyPath:K,operation:"INSERT",propertyValue:v});}});e(o,function(K){n.push({propertyPath:K,operation:"DELETE"});});if(!n.length){return Promise.reject("No Change");}this._oInitialDesigntimeMetadata=N;var r=this.getJson();var P=m({},a(p,["oldValue","newValue"]));P.content={entityPropertyChange:n};P.changeType="appdescr_card_designtime";P.generator="CardEditor";P.selector={};P.reference=O.get(["sap.app","id"],r);return l(P);};
g.prototype.getDeltaChangeDefinition=function(p){var o=this.getJson();var P=m({},p);P.content=j(o,this._oInitialJson);if(!P.content){return Promise.reject("No Change");}this._oInitialJson=o;P.changeType="appdescr_card";P.generator="CardEditor";P.selector={};P.reference=O.get(["sap.app","id"],o);return l(P);};
return g;});
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/ConfigurationTemplate',["sap/ui/integration/Designtime"],function(D){"use strict";return function(){return new D({form:{items:{}},preview:{modes:"Abstract"}});};});
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/PropertyEditor',["sap/ui/integration/designtime/baseEditor/PropertyEditor"],function(P){"use strict";return P;});
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/PropertyEditors',["sap/ui/integration/designtime/baseEditor/PropertyEditors"],function(P){"use strict";return P;});
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/config/generateActionConfig',["sap/base/util/restricted/_merge"],function(_){"use strict";return function(c){return _({},{"label":"{i18n>CARD_EDITOR.ACTIONS}","type":"array","itemLabel":"{type}","addItemLabel":"{i18n>CARD_EDITOR.ACTION}","template":{"enabled":{"label":"{i18n>CARD_EDITOR.ACTION.ENABLED}","type":"boolean","defaultValue":true,"path":"enabled"},"type":{"label":"{i18n>CARD_EDITOR.LABEL.TYPE}","type":"select","items":[{"key":"Navigation"}],"path":"type","visible":"{= !!${enabled}}"},"service":{"label":"{i18n>CARD_EDITOR.ACTION.SERVICE}","type":"string","path":"service","visible":false},"parameters":{"label":"{i18n>CARD_EDITOR.PARAMETERS}","type":"map","allowedTypes":["string","number","boolean"],"path":"parameters","visible":"{= !!${enabled}}"},"url":{"label":"{i18n>CARD_EDITOR.LABEL.URL}","type":"string","path":"url","visible":"{= !!${enabled} && ${type} === 'Navigation'}"},"target":{"label":"{i18n>CARD_EDITOR.TARGET}","type":"select","items":[{"key":"_blank","description":"{i18n>CARD_EDITOR.TARGET.BLANK}"},{"key":"_self","description":"{i18n>CARD_EDITOR.TARGET.SELF}"}],"defaultValue":"_blank","path":"target","visible":"{= !!${enabled} && ${type} === 'Navigation' && !!${url}}"}}},c);};});
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/propertyEditor/complexMapEditor/ComplexMapEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/base/util/restricted/_omit","sap/base/util/restricted/_merge","sap/base/util/deepClone"],function(B,_,a,d){"use strict";
var C=B.extend("sap.ui.integration.designtime.cardEditor.propertyEditor.complexMapEditor.ComplexMapEditor",{
xmlFragment:"sap.ui.integration.designtime.cardEditor.propertyEditor.complexMapEditor.ComplexMapEditor",
metadata:{library:"sap.ui.integration"},
renderer:B.getMetadata().getRenderer().render
});
C.configMetadata=Object.assign({},B.configMetadata,{allowKeyChange:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},allowAddAndRemove:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},keyLabel:{defaultValue:"{i18n>CARD_EDITOR.COMPLEX_MAP.KEY}"}});
C.prototype.getExpectedWrapperCount=function(){return 1;};
C.prototype.onFragmentReady=function(){this._oNestedArrayEditor=this.getContent();this._oNestedArrayEditor.attachValueChange(function(e){var p=e.getParameter("previousValue")||[];var v=d(e.getParameter("value")||[]);var n={};var D=this.getDesigntimeProperties();v=v.map(function(V,i){if(typeof V.key==="undefined"){var k="key";var b=0;var c=function(E){return E.key===k;};while(v.some(c)){k="key"+ ++b;}V.key=k;}var o={};D.forEach(function(P){o[P]=d(V[P]);});n[V.key]={__value:o};return _(V,D);});var N=this._processOutputValue(v);p.forEach(function(P){var o=P.key;if(o!==undefined&&!N.hasOwnProperty(o)){n[o]=null;}});this.setValue(N);this.setDesigntimeMetadata(a({},this.getConfig().designtime,n));},this);};
C.prototype._processInputValue=function(v){var D=this.getDesigntimeProperties();if(!v){v={};}var f=Object.keys(v).map(function(k){var F=d(v[k]);F.key=k;var o=this.getNestedDesigntimeMetadataValue(k);D.forEach(function(p){F[p]=o[p];});return F;}.bind(this));return f;};
C.prototype.getDesigntimeProperties=function(){return[];};
C.prototype.onBeforeConfigChange=function(c){var t={};if(c["allowKeyChange"]){t={key:{label:c["keyLabel"],type:"string",path:"key",validators:{uniqueKey:{type:"isUniqueKey",config:{keys:function(){return Object.keys(this.getValue());}.bind(this),currentKey:function(p){return p.getValue();}}}}}};}var A=a({},{template:t,allowSorting:false},c,{type:"array",path:""});this._oDefaultModel.setData(Object.assign({},this._oDefaultModel.getData(),{nestedConfig:A}));return c;};
C.prototype.setValue=function(v){var f=this._processInputValue(v);this._oDefaultModel.setData(Object.assign({},this._oDefaultModel.getData(),{nestedValue:f}));B.prototype.setValue.call(this,v);};
C.prototype._processOutputValue=function(v){var f={};v.forEach(function(V){f[V.key]=_(V,"key");});return f;};
return C;});
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/propertyEditor/destinationsEditor/DestinationsEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/integration/designtime/cardEditor/propertyEditor/complexMapEditor/ComplexMapEditor","sap/base/util/restricted/_merge"],function(B,C,_){"use strict";
var D=C.extend("sap.ui.integration.designtime.cardEditor.propertyEditor.destinationsEditor.DestinationsEditor",{
metadata:{library:"sap.ui.integration"},
renderer:B.getMetadata().getRenderer().render
});
D.configMetadata=Object.assign({},C.configMetadata,{allowedValues:{defaultValue:[],mergeStrategy:"intersection"}});
D.prototype.getDesigntimeProperties=function(){return[].concat(C.prototype.getDesigntimeProperties.call(this),["label"]);};
D.prototype.onBeforeConfigChange=function(c){var o={};if(c["allowKeyChange"]){o={template:{label:{label:this.getI18nProperty("CARD_EDITOR.LABEL"),type:"string",path:"label"},name:{label:this.getI18nProperty("CARD_EDITOR.DESTINATION.NAME"),type:"select",path:"name",items:(c["allowedValues"]||[]).map(function(k){return{key:k};}),allowCustomValues:true,allowBindings:false},defaultUrl:{label:this.getI18nProperty("CARD_EDITOR.DESTINATION.DEFAULT_URL"),type:"string",path:"defaultUrl"}}};}else{o={collapsibleItems:false,showItemLabel:false,template:{name:{label:"{= ${label} || ${key}}",type:"select",path:"name",items:(c["allowedValues"]||[]).map(function(k){return{key:k};}),allowCustomValues:false,allowBindings:false}}};}var a=_({},o,c);return C.prototype.onBeforeConfigChange.call(this,a);};
return D;});
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/propertyEditor/iconEditor/IconEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/integration/designtime/baseEditor/util/isValidBindingString","sap/ui/core/Fragment",'sap/ui/unified/ColorPickerPopover','sap/ui/unified/library',"sap/ui/model/json/JSONModel","sap/base/util/deepClone","sap/base/util/isPlainObject","sap/base/util/isEmptyObject","sap/base/util/restricted/_omit","sap/ui/core/IconPool"],function(B,i,F,C,U,J,d,a,b,_,I){"use strict";
var c=B.extend("sap.ui.integration.designtime.cardEditor.propertyEditor.iconEditor.IconEditor",{
xmlFragment:"sap.ui.integration.designtime.cardEditor.propertyEditor.iconEditor.IconEditor",
renderer:B.getMetadata().getRenderer().render
});
var o={config:{type:"simpleicon"},key:"src"};var t={config:{type:"string",maxLength:2,validators:{isAlphabetic:{type:"pattern",config:{pattern:"^[A-Za-z]*$"},errorMessage:"CARD_EDITOR.VALIDATOR.NOT_AN_ALPHABETIC"}}},key:"text"};var p={config:{type:"string"},key:"src"};var D={type:"icon",src:"",shape:"Circle",alt:"",text:"",backgroundColor:"",color:""};var e=U.ColorPickerMode;var f=U.ColorPickerDisplayMode;
c.prototype.init=function(){this._oIconModel=new J(d(D));this._oIconModel.setDefaultBindingMode("OneWay");this.setModel(this._oIconModel,"icon");this._oConfigsModel=new J({selectConfig:{type:"select",items:[],allowBindings:false},valueConfig:o});this._oConfigsModel.setDefaultBindingMode("OneWay");this.setModel(this._oConfigsModel,"configs");this._oSettingsModel=new J({shapes:[],altVisible:true,backgroundColorVisible:false,colorVisible:false});this._oSettingsModel.setDefaultBindingMode("OneWay");this.setModel(this._oSettingsModel,"settings");this.attachModelContextChange(function(){if(this.getModel("i18n")){var h=d(this._oConfigsModel.getData());h.selectConfig.items=[{"key":"icon","title":this.getI18nProperty("BASE_EDITOR.ICON.TYPE_ICON")},{"key":"text","title":this.getI18nProperty("BASE_EDITOR.ICON.SETTINGS_DIALOG_TEXT_LABEL")},{"key":"picture","title":this.getI18nProperty("BASE_EDITOR.ICON.TYPE_PICTURE")}];this._oConfigsModel.setData(h);var j=d(this._oSettingsModel.getData());j.shapes=[{key:"Square",text:this.getI18nProperty("BASE_EDITOR.ICON.SETTINGS_DIALOG_SHAPE_SQUARE")},{key:"Circle",text:this.getI18nProperty("BASE_EDITOR.ICON.SETTINGS_DIALOG_SHAPE_CIRCLE")}];this._oSettingsModel.setData(j);}},this);};
c.prototype.getExpectedWrapperCount=function(){return 2;};
c.prototype.setValue=function(v){var n=b(v)?undefined:v;B.prototype.setValue.call(this,n);this._oIconModel.setData(Object.assign({},this._oIconModel.getData(),v,{type:this.getDesigntimeMetadataValue().type||g(v)}));};
function g(v){if(a(v)){if(v.src){if(v.backgroundColor||v.color||(I.isIconURI(v.src)&&!!I.getIconInfo(v.src))||i(v.src,false)){return"icon";}else{return"picture";}}else if(v.text){return"text";}}return D.type;}
c.prototype._prepareValue=function(k,h){return h[k];};
c.prototype._onTypeChange=function(E){var h;var T=E.getSource().getValue();switch(T){case"icon":h=o;this._oSettingsModel.setProperty("/altVisible",true);break;case"text":h=t;this._oSettingsModel.setProperty("/altVisible",false);break;case"picture":h=p;this._oSettingsModel.setProperty("/altVisible",true);break;}this._oConfigsModel.setData(Object.assign({},this._oConfigsModel.getData(),{valueConfig:h}));this.setDesigntimeMetadataValue({type:T});this.setValue(this._processOutputValue(this._oIconModel.getData()));};
c.prototype._updateValue=function(E){var k=this._oConfigsModel.getData().valueConfig.key;var n={};n[k]=E.getSource().getValue();var N=Object.assign({},this._oIconModel.getData(),n);this.setValue(this._processOutputValue(N));};
c.prototype._handleSettings=function(){this._oOldData=d(this.getModel("icon").getData());if(!this._oSettingsDialog){return F.load({name:"sap.ui.integration.designtime.cardEditor.propertyEditor.iconEditor.IconEditorSettingsDialog",controller:this}).then(function(h){this._oDialogModel=new J(this._oOldData);this._oSettingsDialog=h;this._oSettingsDialog.setModel(this._oDialogModel,"data");this.addDependent(this._oSettingsDialog);this._oSettingsDialog.open();return this._oSettingsDialog;}.bind(this));}else{this._oSettingsDialog.open();this._oDialogModel.setData(this._oOldData);return Promise.resolve(this._oSettingsDialog);}};
c.prototype._onSettingsSave=function(){this._oSettingsDialog.close();this.setValue(this._processOutputValue(this._oDialogModel.getData()));};
c.prototype._onSettingsCancel=function(){this._oSettingsDialog.close();};
c.prototype._processOutputValue=function(v){var T=this.getDesigntimeMetadataValue().type;var O=["type"];Object.keys(v).forEach(function(k){if(!v[k]||v[k]===D[k]){O.push(k);}});switch(T){case"icon":O.push("text");if(!v["src"]){O.push("shape","alt","backgroundColor","color");}break;case"picture":O.push("text","backgroundColor","color");if(!v["src"]){O.push("shape","alt");}break;case"text":O.push("src","alt");if(!v["text"]){O.push("shape","backgroundColor","color");}break;}return _(v,O);};
c.prototype._openColorPickerPopup=function(E){this._inputId=E.getSource().getId();if(!this.oColorPickerSimplifiedPopover){this.oColorPickerSimplifiedPopover=new C("oColorPickerSimpplifiedPopover",{colorString:"blue",displayMode:f.Simplified,mode:e.HSL,change:this._handleColorPickerChange.bind(this)});}this.oColorPickerSimplifiedPopover.openBy(E.getSource());};
c.prototype._handleColorPickerChange=function(E){var h=sap.ui.getCore().byId(this._inputId);h.setValue(E.getParameter("hex"));h.setValueState("None");this._inputId="";};
c.prototype.getFocusDomRef=function(){var h=this.getContent();if(h){return this.getContent().getItems()[0].getContent()[0].getFocusDomRef();}};
c.prototype.getIdForLabel=function(){var h=this.getContent();if(h){return this.getContent().getItems()[0].getContent()[0].getIdForLabel();}};
return c;});
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/propertyEditor/parametersEditor/ParametersEditor',["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/integration/designtime/baseEditor/propertyEditor/mapEditor/MapEditor","sap/base/util/includes","sap/base/util/restricted/_merge"],function(B,M,i,_){"use strict";
var P=M.extend("sap.ui.integration.designtime.cardEditor.propertyEditor.parametersEditor.ParametersEditor",{
metadata:{library:"sap.ui.integration"},
renderer:B.getMetadata().getRenderer().render
});
P.configMetadata=Object.assign({},M.configMetadata,{allowLabelChange:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"}});
P.prototype.formatItemConfig=function(c){var m=M.prototype.formatItemConfig.apply(this,arguments);var k=c.key;var v=c.value.visible!==false;var e=c.value.editable!==false;var d=c.value.description||"";var t=c.value.translatable||false;var a=c.value.allowSettings||true;var A=c.value.allowDynamicValues||true;var I=this.getNestedDesigntimeMetadataValue(k);var l=I.label;m.push({label:this.getI18nProperty("CARD_EDITOR.LABEL"),path:"label",value:l,placeholder:l?undefined:k,type:"string",enabled:this.getConfig().allowLabelChange,itemKey:k},{label:"Description",path:"description",value:d,allowBindings:true,type:"string",itemKey:k},{label:"Visible in Configuration",path:"visible",value:v,allowBindings:true,type:"boolean",itemKey:k},{label:"Editable in Configuration",path:"editable",allowBindings:true,value:e,enabled:true,type:"boolean",itemKey:k},{label:"Translatable in Configuration",path:"translatable",value:t,enabled:true,type:"boolean",itemKey:k},{label:"Allow Dynamic Values in Configuration",path:"allowDynamicValues",allowBindings:true,enabled:true,value:A,type:"boolean",itemKey:k},{label:"Allow Settings in Configuration",path:"allowSettings",allowBindings:true,value:a,type:"boolean",itemKey:k});return m;};
P.prototype.processInputValue=function(v){return v;};
P.prototype.processOutputValue=function(v){return v;};
P.prototype._configItemsFormatter=function(I){return Array.isArray(I)?I.map(function(o){var a=this.getNestedDesigntimeMetadataValue(o.key);var c=_({},o.value,a);if(!c.label){c.label=o.key;}c.itemKey=o.key;c.path="value";c.designtime=this.getNestedDesigntimeMetadata(o.key);return c;}.bind(this)):[];};
P.prototype.getItemChangeHandlers=function(){return Object.assign({},M.prototype.getItemChangeHandlers.apply(this,arguments),{label:this._onDesigntimeChange});};
P.prototype.onBeforeConfigChange=function(c){if(!c.allowTypeChange&&!c.allowKeyChange){this.setFragment("sap.ui.integration.designtime.cardEditor.propertyEditor.parametersEditor.ParametersConfigurationEditor",function(){return 1;});}return c;};
P.prototype._isValidItem=function(I,o){var t=o.type;var v=o.value;var a=this._getAllowedTypes();return(t&&i(a,t)||typeof v==="string"&&i(a,"string"));};
return P;});
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/util/CommonPatterns',function(){"use strict";return{email:new RegExp(/^(?:(?:(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*")(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*"))*@(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\])(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\]))+|(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*")*\<(?:@(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\])(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\]))+(?:,@(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\])(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\]))+)*:)?(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*")(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*"))*@(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\])(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\]))+\>)|(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*")*:(?:(?:(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*")(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*"))*@(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\])(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\]))+|(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*")*\<(?:@(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\])(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\]))+(?:,@(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\])(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\]))+)*:)?(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*")(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*"))*@(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\])(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\]))+\>)(?:,\s*(?:(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*")(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*"))*@(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\])(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\]))+|(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*")*\<(?:@(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\])(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\]))+(?:,@(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\])(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\]))+)*:)?(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*")(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|"(?:[^\"\r\\]|\\.)*"))*@(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\])(?:\.(?:[^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031-][^()<>@,;:\\".\[\]!~*'&=$?\/ \000-\031]*(?:$|(?=[\["()<>@,;:\\".\[\]]))|\[(?:[^\[\]\r\\]|\\.)*\]))+\>))*)?;\s*)$/).source};});
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/validator/IsPatternMatchList',["sap/ui/integration/designtime/baseEditor/validator/IsPatternMatch"],function(I){"use strict";return{async:false,errorMessage:"BASE_EDITOR.VALIDATOR.FAILED_PATTERN_TEST",validate:function(v,c){return(v||[]).every(function(V){return I.validate(V,c);});}};});
sap.ui.predefine('sap/ui/integration/designtime/editor/CardEditor',["sap/ui/core/Control","sap/ui/core/Core","sap/base/util/deepClone","sap/base/util/merge","sap/ui/integration/widgets/Card","sap/ui/integration/Designtime","sap/ui/model/json/JSONModel","sap/ui/integration/util/CardMerger","sap/m/Label","sap/m/Title","sap/ui/core/Icon","sap/m/ResponsivePopover","sap/m/Text","sap/base/Log","sap/ui/core/Popup","sap/base/i18n/ResourceBundle","sap/ui/thirdparty/URI","sap/ui/dom/includeStylesheet","sap/base/util/LoaderExtensions","sap/ui/core/theming/Parameters"],function(C,b,d,m,c,D,J,e,L,T,I,R,f,g,P,h,U,k,l,p){"use strict";
function q(s){if(s&&s.nodeType!==1){return 0;}var z=parseInt(window.getComputedStyle(s).getPropertyValue('z-index'));if(isNaN(z)){return q(s.parentNode);}return z+1;}
var r=/\{\{(?!parameters.)(?!destinations.)([^\}\}]+)\}\}/g,t=5000,u=b.getLibraryResourceBundle("sap.ui.integration");
var v=C.extend("sap.ui.integration.designtime.editor.CardEditor",{
metadata:{library:"sap.ui.integration",properties:{card:{type:"any",defaultValue:null},mode:{type:"string",defaultValue:"admin"},language:{type:"string",defaultValue:""},allowDynamicValues:{type:"boolean",defaultValue:false},allowSettings:{type:"boolean",defaultValue:false},designtime:{type:"object"}},aggregations:{_formContent:{type:"sap.ui.core.Control",multiple:true,visibility:"hidden"},_preview:{type:"sap.ui.integration.designtime.editor.CardPreview",multiple:false,visibility:"hidden"}},events:{ready:{}}},
renderer:function(o,a){o.openStart("div");a.getMode()==="translation"?o.addClass("sapUiIntegrationCardEditorTranslation"):o.addClass("sapUiIntegrationCardEditorPreview");o.addClass("sapUiIntegrationCardEditor");o.writeClasses();o.writeElementData(a);o.openEnd();if(a.isReady()){o.openStart("div");o.addClass("sapUiIntegrationCardEditorForm");if(a.getMode()!=="translation"){o.addClass("settingsButtonSpace");}o.writeClasses();o.openEnd();var j=a.getAggregation("_formContent");if(j){var n,s=0;for(var i=0;i<j.length;i++){var x=j[i];if(x.isA("sap.m.Label")){n=x;continue;}o.openStart("div");o.addClass("sapUiIntegrationCardEditorItem");if(a.getMode()==="translation"){o.addClass("language");}if(x._cols===1){o.addClass("sapUiIntegrationCardEditorItemCol"+(++s));}else{s=0;}o.writeClasses();o.openEnd();if(x.isA("sap.m.Title")){o.renderControl(x);}else{if(n){var y=n.getDependents()&&n.getDependents()[0];o.openStart("div");o.addClass("sapUiIntegrationCardEditorItemLabel");if(y&&a.getMode()!=="translation"){o.addClass("description");}o.openEnd();o.renderControl(n);if(y){o.renderControl(y);}o.close("div");}o.renderControl(x);}o.close("div");n=null;s=s==2?0:s;}}o.close("div");var z=a.getAggregation("_preview");z&&o.renderControl(z);}o.close("div");}
});
v.prototype.init=function(){this._ready=false;this._aFieldReadyPromise=[];this._oResourceBundle=u;this._appliedLayerManifestChanges=[];this._currentLayerManifestChanges={};this._mDestinationDataProviders={};};
v.prototype.isReady=function(){return this._ready;};
function w(o,s,a,i){i=i||"";a=a||[];if(typeof o==="object"){if(!o[s]){for(var n in o){w(o[n],s,a,i+"/"+n);}}else{if(o.type){a.push({path:o.pathvalue||i.substring(1),value:o.pathvalue||"{context>"+i.substring(1)+"/value}",object:o});}else{a.push({path:i.substring(1),object:o});for(var n in o){w(o[n],s,a,i+"/"+n);}}}}return a;}
v.prototype._filterManifestChangesByLayer=function(M){var a=[],o={":layer":e.layers[this.getMode()]},i=e.layers[this.getMode()];M.manifestChanges.forEach(function(j){var n=j.hasOwnProperty(":layer")?j[":layer"]:1000;if(n<i){a.push(j);}else if(n===i){o=j;}});M.manifestChanges=a;this._currentLayerManifestChanges=o;};
v.prototype.setCard=function(a,s){this._ready=false;if(a===this.getProperty("card")){return this;}if(this._oEditorCard){this._oEditorCard.destroy();}if(this._oDesigntimeInstance){this._oDesigntimeInstance.destroy();}this.setProperty("card",a,s);Promise.resolve().then(function(){this._initCard(a);}.bind(this));return this;};
v.prototype.setLanguage=function(V,s){if(!V||typeof V!=="string"){return this;}this._language=V.replace("-","_");this.setProperty("language",V,s);if(!v._languages[this._language]){this._language=this._language.split("_")[0];}if(!v._languages[this._language]){g.warning("The language: "+V+" is currently unknown, some UI controls might show "+V+" instead of the language name.");}return this;};
v.prototype.onAfterRendering=function(){if(this.getDomRef()){this._iZIndex=q(this.getDomRef());P.setInitialZIndex(this._iZIndex);}};
v.prototype._getOriginalManifestJson=function(){try{return this._oEditorCard._oCardManifest._oManifest.getRawJson();}catch(a){return{};}};
v.prototype._initCard=function(a){if(typeof a==="string"){try{a=JSON.parse(a);}catch(i){var j=b.byId(a);if(!j){var n=document.getElementById(a);if(n&&n.tagName&&n.tagName==="ui-integration-card"){j=n._getControl();}}a=j;}}if(a&&a.isA&&a.isA("sap.ui.integration.widgets.Card")){a={manifest:a.getManifest(),manifestChanges:a.getManifestChanges(),host:a.getHost(),baseUrl:a.getBaseUrl()};}if(typeof a==="object"){var o=e.layers[this.getMode()];if(a.manifestChanges){this._filterManifestChangesByLayer(a);}this._oEditorCard=new c(a);var s=this;this._oEditorCard._prepareToApplyManifestSettings=function(){c.prototype._prepareToApplyManifestSettings.apply(this,arguments);if(!s._oEditorCard._isManifestReady){return;}if(s._manifestModel){return;}s._appliedLayerManifestChanges=a.manifestChanges;var M=s._oEditorCard.getManifestEntry("/");var _=m({},M);s._oProviderCard=s._oEditorCard;s._oProviderCard._editorManifest=M;s._beforeManifestModel=new J(_);if(o<e.layers["translation"]&&s._currentLayerManifestChanges){M=e.mergeCardDelta(M,[s._currentLayerManifestChanges]);}s._manifestModel=new J(M);s._originalManifestModel=new J(s._getOriginalManifestJson());s._initInternal();if(!s._oEditorCard.getModel("i18n")){s._oEditorCard._loadDefaultTranslations();}s.setModel(s._oEditorCard.getModel("i18n"),"i18n");s._createContextModel();};this._oEditorCard.onBeforeRendering();}};
v.prototype._initInternal=function(){var s=this._oEditorCard.getManifestEntry("/sap.card/designtime"),o=this._manifestModel.getProperty("/sap.card/configuration"),a,i=this.getDesigntime();if(i){if(typeof i==="function"){a=new Promise(function(j,n){var x=new i();this._applyDesigntimeDefaults(x.getSettings());j(x);}.bind(this));}else if(typeof i==="object"){a=new Promise(function(j,n){sap.ui.require(["sap/ui/integration/Designtime"],function(D){var A=D.extend("test.Designtime");A.prototype.create=function(){return i;};var x=new A();this._applyDesigntimeDefaults(x.getSettings());j(x);}.bind(this));}.bind(this));}}else if(s){a=this._oEditorCard.loadDesigntime().then(function(j){this._applyDesigntimeDefaults(j.getSettings());return j;}.bind(this));}else{a=Promise.resolve(this._createParameterDesigntime(o));}a.then(function(j){this._oDesigntimeInstance=j;if(this.getMode()==="admin"||this.getMode()==="all"){this._addDestinationSettings(o,this._oDesigntimeInstance);}this._settingsModel=new J(this._oDesigntimeInstance.getSettings());this.setModel(this._settingsModel,"currentSettings");this.setModel(this._settingsModel,"items");this._applyDesigntimeLayers();this._requireFields().then(function(){this._startEditor();}.bind(this));}.bind(this));};
v.prototype.getCurrentSettings=function(){var s=this._settingsModel.getProperty("/"),a={},N;if(s&&s.form&&s.form.items){for(var n in s.form.items){var i=s.form.items[n];if(i.editable&&i.visible){if(this.getMode()!=="translation"){if(i.translatable&&!i._changed&&i._translatedDefaultPlaceholder&&!this._currentLayerManifestChanges[i.manifestPath]){continue;}else{a[i.manifestpath]=i.value;}}else if(i.translatable&&i.value){a[i.manifestpath]=i.value;}if(i._next&&(this.getAllowSettings())){if(i._next.editable===false){N=N||{};N[i._settingspath+"/editable"]=false;}if(i._next.visible===false){N=N||{};N[i._settingspath+"/visible"]=false;}if(typeof i._next.allowDynamicValues==="boolean"&&this.getAllowDynamicValues()){N=N||{};N[i._settingspath+"/allowDynamicValues"]=i._next.allowDynamicValues;}}}}}a[":layer"]=e.layers[this.getMode()];a[":errors"]=this.checkCurrentSettings()[":errors"];if(N){a[":designtime"]=N;}return a;};
v.prototype.checkCurrentSettings=function(){var s=this._settingsModel.getProperty("/"),a={};if(s&&s.form&&s.form.items){for(var n in s.form.items){var i=s.form.items[n];if(i.editable){if((i.isValid||i.required)&&!(this.getMode()==="translation"&&i.translatable)){if(i.isValid){a[i.manifestpath]=i.isValid(i);}a[i.manifestpath]=true;var j=i.value;var o=i.type;if(o==="string"&&j===""){a[i.manifestpath]=j;}if((o==="date"||o==="datetime")&&isNaN(Date.parse(j))){a[i.manifestpath]=j;}if(o==="integer"){if(isNaN(parseInt(j))){a[i.manifestpath]=j;}else if(j<i.min||j>i.max){a[i.manifestpath]=j;}}if(o==="number"){if(isNaN(parseFloat(j))){a[i.manifestpath]=j;}else if(j<i.min||j>i.max){a[i.manifestpath]=j;}}}}}a[":layer"]=e.layers[this.getMode()];}a[":errors"]=Object.values(a).indexOf(false)>-1;return a;};
v.prototype._createContextModel=function(){var H=this._oEditorCard.getHostInstance(),i=new J({}),F=new J([]);this.setModel(i,"context");this.setModel(F,"contextflat");F._getPathObject=function(s){var a=this.getData().filter(function(o){if(o.path===s){return true;}});return a.length?a[0]:null;};F._getValueObject=function(V){var a=this.getData()||[];a=a.filter(function(o){if(o.value===V||o.object.value===V){return true;}});return a.length?a[0]:null;};var j=new Promise(function(a,n){if(H&&H.getContext){var o=false;setTimeout(function(){if(o){return;}g.error("Card Editor context could not be determined with "+t+".");o=true;a({});},t);H.getContext().then(function(s){if(o){g.error("Card Editor context returned after more than "+t+". Context is ignored.");}o=true;a(s||{});});}else{a({});}});j.then(function(o){var a={};a["empty"]=v._contextEntries.empty;for(var n in o){a[n]=o[n];}a["card.internal"]=v._contextEntries.cardinternal;i.setData(a);F.setData(w(a,"label"));});i.getProperty=function(s,o){var a=this.resolve(s,o);if(a.endsWith("/value")){this._mValues=this._mValues||{};if(this._mValues.hasOwnProperty(a)){return this._mValues[a];}this._mValues[a]=undefined;H.getContextValue(a.substring(1)).then(function(V){this._mValues[a]=V;this.checkUpdate();}.bind(this));return undefined;}else{return J.prototype.getProperty.apply(this,arguments);}};};
v.fieldMap={"string":"sap/ui/integration/designtime/editor/fields/StringField","integer":"sap/ui/integration/designtime/editor/fields/IntegerField","number":"sap/ui/integration/designtime/editor/fields/NumberField","boolean":"sap/ui/integration/designtime/editor/fields/BooleanField","date":"sap/ui/integration/designtime/editor/fields/DateField","datetime":"sap/ui/integration/designtime/editor/fields/DateTimeField","string[]":"sap/ui/integration/designtime/editor/fields/ListField","destination":"sap/ui/integration/designtime/editor/fields/DestinationField"};v.Fields=null;
v.prototype._requireFields=function(){if(v.Fields){return Promise.resolve();}return new Promise(function(a){sap.ui.require(Object.values(v.fieldMap),function(){v.Fields={};for(var n in v.fieldMap){v.Fields[n]=arguments[Object.keys(v.fieldMap).indexOf(n)];}a();});});};
v.prototype._createLabel=function(o){var a=new L({text:o.label,required:o.required&&o.editable||false,visible:o.visible,objectBindings:{currentSettings:{path:"currentSettings>"+o._settingspath},items:{path:"items>/form/items"}}});a._cols=o.cols||2;if(o.description){var i=new I({src:"sap-icon://message-information",color:"Marker",size:"12px",useIconTooltip:false,visible:this.getMode()!=="translation"});i.addStyleClass("sapUiIntegrationCardEditorDescriptionIcon");a.addDependent(i);i.onmouseover=function(){this._getPopover().getContent()[0].setText(o.description);this._getPopover().openBy(i);}.bind(this);i.onmouseout=function(){this._getPopover().close();}.bind(this);}return a;};
v.prototype._getPopover=function(){if(this._oPopover){return this._oPopover;}var o=new f({text:""});o.addStyleClass("sapUiTinyMargin sapUiIntegrationCardEditorDescriptionText");this._oPopover=new R({showHeader:false,content:[o]});this._oPopover.addStyleClass("sapUiIntegrationCardEditorPopover");return this._oPopover;};
v.prototype._updateProviderCard=function(a){if(this._ready){var M=this._oProviderCard._editorManifest;if(a.length===0){return;}for(var i=0;i<a.length;i++){var o=a[i];o.config._cancel=true;}delete M["sap.card"].header;delete M["sap.card"].content;delete M["sap.card"].data;M["sap.card"].type="List";var j=this._oProviderCard;this._oProviderCard=new c({manifest:M,baseUrl:this._oProviderCard.getBaseUrl(),host:this._oProviderCard.getHost()});this._oProviderCard.setManifestChanges([this.getCurrentSettings()]);this._oProviderCard._editorManifest=M;var n=this;this._oProviderCard._fillFiltersModel=function(){if(!n._oProviderCard._oDataProviderFactory){return;}n._bIgnoreUpdates=true;for(var i=0;i<a.length;i++){var o=a[i];o.config._cancel=false;n._addValueListModel(o.config,o.field,true);}n._bIgnoreUpdates=false;};this._oProviderCard.setVisible(false);this._oProviderCard.onBeforeRendering();if(j&&j!==this._oEditorCard){j.destroy();}}};
v.prototype._createField=function(o){var F=new v.Fields[o.type]({configuration:o,mode:this.getMode(),host:this._oEditorCard.getHostInstance(),objectBindings:{currentSettings:{path:"currentSettings>"+o._settingspath},items:{path:"items>/form/items"}},visible:o.visible});this._aFieldReadyPromise.push(F._readyPromise);var B=this._settingsModel.bindProperty(o._settingspath+"/value");B.attachChange(function(){if(!this._bIgnoreUpdates){o._changed=true;if(o._dependentFields&&o._dependentFields.length>0){this._updateProviderCard(o._dependentFields);}this._updatePreview();}}.bind(this));this._addValueListModel(o,F);F._cols=o.cols||2;return F;};
v.prototype._addValueListModel=function(o,F,a){if(o.values&&o.values.data&&this._oProviderCard&&this._oProviderCard._oDataProviderFactory){var V=new J({}),j=this._oProviderCard._oDataProviderFactory.create(o.values.data).getData();this._settingsModel.setProperty(o._settingspath+"/_loading",true);j.then(function(B){if(o._cancel){o._values=[];return;}o._values=B;V.setData(B);V.checkUpdate(true);this._settingsModel.setProperty(o._settingspath+"/_loading",false);}.bind(this)).catch(function(){o._values={};V.setData({});V.checkUpdate(true);this._settingsModel.setProperty(o._settingspath+"/_loading",false);}.bind(this));F.setModel(V,undefined);F.bindObject({path:o.values.data.path||"/"});if(!a){var s=JSON.stringify(o.values.data);if(s){var n=/parameters\.([^\}\}]+)|destinations\.([^\}\}]+)/g,x=s.match(n);if(x){for(var i=0;i<x.length;i++){var y=x[i].indexOf("parameters.")===0?"/value":"/name",z="/sap.card/configuration/"+x[i].replace(".","/")+y,A=this._mItemsByPaths[z];if(A){A._dependentFields=A._dependentFields||[];A._dependentFields.push({field:F,config:o});}}}}}}};
v.prototype._addItem=function(o){var M=this.getMode();if(this.getAllowDynamicValues()===false){o.allowDynamicValues=false;}if(this.getAllowSettings()===false){o.allowSettings=false;}o._beforeValue=this._beforeManifestModel.getProperty(o.manifestpath);o.__cols=o.cols||2;if(o.visible===false||(!o.translatable&&M==="translation")){return;}if(o.type==="group"){var a=new T({text:o.label,visible:o.visible,objectBindings:{currentSettings:{path:"currentSettings>"+o._settingspath},items:{path:"items>/form/items"}}});this.addAggregation("_formContent",a);a._cols=o.cols||2;return;}if(M==="translation"){if(typeof o.value==="string"&&o.value.indexOf("{")===0){return;}o._language={value:o.value};o.cols=1;var i=d(o,10);i._settingspath+="/_language";i.editable=false;i.required=false;if(!i.value){i.value="-";}this.addAggregation("_formContent",this._createLabel(i));this.addAggregation("_formContent",this._createField(i));o.value=o._translatedDefaultValue||"";o.editable=o.visible=o.translatable;if(this._currentLayerManifestChanges){o.value=this._currentLayerManifestChanges[o.manifestpath]||o.value;}o.label=o._translatedLabel||"";o.required=false;}this.addAggregation("_formContent",this._createLabel(o));var F=this._createField(o);this.addAggregation("_formContent",F);o.cols=o.__cols;delete o.__cols;};
v.prototype._getCurrentLanguageSpecificText=function(K){var s=this._language;if(this._oTranslationBundle){var a=this._oTranslationBundle.getText(K);if(a===K){return"";}return a;}if(!s){return"";}var i=this._oEditorCard.getManifestEntry("/sap.app/i18n");if(!i){return"";}if(typeof i==="string"){var o=new U(i);this._oTranslationBundle=new h(o,s,false,false,[s],"",true);return this._getCurrentLanguageSpecificText(K);}};
v.prototype._startEditor=function(){var s=this._settingsModel.getProperty("/");if(s.form&&s.form.items){if(this.getMode()==="translation"){this._addItem({type:"group",cols:1,translatable:true,label:u.getText("CARDEDITOR_ORIGINALLANG")});this._addItem({type:"group",cols:1,translatable:true,label:v._languages[this._language]||this.getLanguage()});}this._mItemsByPaths={};for(var n in s.form.items){var i=s.form.items[n];if(i.manifestpath){this._mItemsByPaths[i.manifestpath]=i;}if(i){i.label=i.label||n;if(i.type==="string"){var a=this._getManifestDefaultValue(i.manifestpath),j=i.defaultValue;if(this._isValueWithHandlebarsTranslation(a)){i.translatable=true;i._translatedDefaultValue=this._getCurrentLanguageSpecificText(a.substring(2,a.length-2));i._translatedDefaultPlaceholder=a;}else if(j&&j.startsWith("{i18n>")){i.translatable=true;i._translatedDefaultPlaceholder=j;i.value=this._currentLayerManifestChanges[i.manifestpath]||this.getModel("i18n").getResourceBundle().getText(j.substring(6,j.length-1));if(this.getMode()==="translation"){i._translatedDefaultValue=this._getCurrentLanguageSpecificText(j.substring(6,j.length-1));}}if(this.getMode()==="translation"){if(this._isValueWithHandlebarsTranslation(i.label)){i._translatedLabel=this._getCurrentLanguageSpecificText(i.label.substring(2,i.label.length-2),true);}else if(i.label&&i.label.startsWith("{i18n>")){i._translatedLabel=this._getCurrentLanguageSpecificText(i.label.substring(6,i.label.length-1),true);}}}i._changed=false;}}}for(var n in s.form.items){var i=s.form.items[n];this._addItem(i);}if(this.getMode()!=="translation"){this._initPreview().then(function(){Promise.all(this._aFieldReadyPromise).then(function(){this._ready=true;this.fireReady();}.bind(this));}.bind(this));}else{Promise.all(this._aFieldReadyPromise).then(function(){this._ready=true;this.fireReady();}.bind(this));}};
v.prototype.destroy=function(){if(this._oEditorCard){this._oEditorCard.destroy();}if(this._oPopover){this._oPopover.destroy();}if(this._oDesigntimeInstance){this._oDesigntimeInstance.destroy();}this._manifestModel=null;this._originalManifestModel=null;this._settingsModel=null;C.prototype.destroy.apply(this,arguments);};
v.prototype._initPreview=function(){return new Promise(function(a,i){sap.ui.require(["sap/ui/integration/designtime/editor/CardPreview"],function(j){var o=new j({settings:this._oDesigntimeInstance.getSettings(),card:this._oEditorCard});this.setAggregation("_preview",o);a();}.bind(this));}.bind(this));};
v.prototype._updatePreview=function(){var o=this.getAggregation("_preview");if(o){o.update();}};
v.prototype._applyDesigntimeDefaults=function(s){s=s||{};s.form=s.form||{};s.form.items=s.form.items||{};s.preview=s.preview||{modes:"Abstract"};var i=s.form.items||s.form.items;for(var n in i){var o=i[n];if(o.manifestpath){o.value=this._manifestModel.getProperty(o.manifestpath);}if(o.visible===undefined||o.visible===null){o.visible=true;}if(typeof o.translatable!=="boolean"){o.translatable=false;}if(o.editable===undefined||o.editable===null){o.editable=true;}if(!o.label){o.label=n;}if(!o.type||o.type==="enum"){o.type="string";}if(o.value===undefined||o.value===null){switch(o.type){case"boolean":o.value=o.defaultValue||false;break;case"integer":case"number":o.value=o.defaultValue||0;break;case"string[]":o.value=o.defaultValue||[];break;default:o.value=o.defaultValue||"";}}if(o.type==="group"){if(o.visible===undefined||o.value===null){o.visible=true;}}o._settingspath="/form/items/"+n;}};
v.prototype._applyDesigntimeLayers=function(s){if(this._appliedLayerManifestChanges&&Array.isArray(this._appliedLayerManifestChanges)){for(var i=0;i<this._appliedLayerManifestChanges.length;i++){var o=this._appliedLayerManifestChanges[i][":designtime"];if(o){var K=Object.keys(o);for(var j=0;j<K.length;j++){this._settingsModel.setProperty(K[j],o[K[j]]);}}}}if(this._currentLayerManifestChanges){var o=this._currentLayerManifestChanges[":designtime"];if(o){var K=Object.keys(o);for(var j=0;j<K.length;j++){var a=K[j],n=a.substring(0,a.lastIndexOf("/")+1)+"_next";if(!this._settingsModel.getProperty(n)){this._settingsModel.setProperty(n,{});}var n=a.substring(0,a.lastIndexOf("/")+1)+"_next",x=a.substring(a.lastIndexOf("/")+1);this._settingsModel.setProperty(n+"/"+x,o[K[j]]);}}}};
v.prototype._createParameterDesigntime=function(o){var s={},B="/sap.card/configuration/parameters/",M=this.getMode();if(o&&o.parameters){s.form=s.form||{};s.form.items=s.form.items||{};var i=s.form.items;Object.keys(o.parameters).forEach(function(n){i[n]=m({manifestpath:B+n+"/value",editable:(M!=="translation"),_settingspath:"/form/items/"+n},o.parameters[n]);var a=i[n];if(!a.type){a.type="string";}if(!a.hasOwnProperty("visible")){a.visible=true;}});}return new D(s);};
v.prototype._addDestinationSettings=function(o){var s=this._oDesigntimeInstance.getSettings(),B="/sap.card/configuration/destinations/";s.form=s.form||{};s.form.items=s.form.items||{};if(s&&o&&o.destinations){if(!s.form.items["destination.group"]){s.form.items["destination.group"]={label:u.getText("CARDEDITOR_DESTINATIONS")||"Destinations",type:"group",visible:true};}var i=s.form.items;Object.keys(o.destinations).forEach(function(n){var _=[{}],H=this._oEditorCard.getHostInstance();i[n+".destinaton"]=m({manifestpath:B+n+"/name",visible:true,type:"destination",editable:true,allowDynamicValues:false,allowSettings:false,value:o.destinations[n].name,defaultValue:o.destinations[n].defaultUrl,_settingspath:"/form/items/"+[n+".destinaton"],_values:_,_destinationName:n},o.destinations[n]);if(typeof i[n+".destinaton"].label==="undefined"){i[n+".destinaton"].label=n;}if(H){i[n+".destinaton"]._loading=true;this._oEditorCard.getHostInstance().getDestinations().then(function(n,a){i[n+".destinaton"]._values=_.concat(a);i[n+".destinaton"]._loading=false;this._settingsModel.checkUpdate(true);i[n+".destinaton"].value=o.destinations[n].name;}.bind(this,n));}}.bind(this));}};
v.prototype._getManifestDefaultValue=function(s){return this._originalManifestModel.getProperty(s);};
v.prototype._isValueWithHandlebarsTranslation=function(V){if(typeof V==="string"){return!!V.match(r);}return false;};
v._contextEntries={empty:{label:u.getText("CARDEDITOR_CONTEXT_EMPTY_VAL"),type:"string",description:u.getText("CARDEDITOR_CONTEXT_EMPTY_DESC"),placeholder:"",value:""},cardinternal:{label:u.getText("CARDEDITOR_CONTEXT_CARD_INTERNAL_VAL"),todayIso:{type:"string",label:u.getText("CARDEDITOR_CONTEXT_CARD_TODAY_VAL"),description:u.getText("CARDEDITOR_CONTEXT_CARD_TODAY_DESC"),tags:[],placeholder:u.getText("CARDEDITOR_CONTEXT_CARD_TODAY_VAL"),customize:["format.dataTime"],value:"{{parameters.TODAY_ISO}}"},nowIso:{type:"string",label:u.getText("CARDEDITOR_CONTEXT_CARD_NOW_VAL"),description:u.getText("CARDEDITOR_CONTEXT_CARD_NOW_DESC"),tags:[],placeholder:u.getText("CARDEDITOR_CONTEXT_CARD_NOW_VAL"),customize:["dateFormatters"],value:"{{parameters.NOW_ISO}}"},currentLanguage:{type:"string",label:u.getText("CARDEDITOR_CONTEXT_CARD_LANG_VAL"),description:u.getText("CARDEDITOR_CONTEXT_CARD_LANG_VAL"),tags:["technical"],customize:["languageFormatters"],placeholder:u.getText("CARDEDITOR_CONTEXT_CARD_LANG_VAL"),value:"{{parameters.LOCALE}}"}}};v._languages={};
v._appendThemeVars=function(){var o=document.getElementById("sap-ui-integration-editor-style");if(o&&o.parentNode){o.parentNode.removeChild(o);}var V=["sapUiButtonHoverBackground","sapUiBaseBG","sapUiContentLabelColor","sapUiTileSeparatorColor","sapUiHighlight","sapUiListSelectionBackgroundColor","sapUiChartScrollbarBorderColor"],s=document.createElement("style");s.setAttribute("id","sap-ui-integration-editor-style");for(var i=0;i<V.length;i++){V[i]="--"+V[i]+":"+p.get(V[i]);}s.innerHTML=".sapUiIntegrationCardEditor, .sapUiIntegrationFieldSettings, .sapUiIntegrationIconSelectList {"+V.join(";")+"}";document.body.appendChild(s);};
v.init=function(){this.init=function(){};v._appendThemeVars();b.attachThemeChanged(function(){v._appendThemeVars();});var s=sap.ui.require.toUrl("sap.ui.integration.designtime.editor.css.CardEditor".replace(/\./g,"/")+".css");k(s);l.loadResource("sap/ui/integration/designtime/editor/languages.json",{dataType:"json",failOnError:false,async:true}).then(function(o){v._languages=o;});};
v.init();return v;});
sap.ui.predefine('sap/ui/integration/designtime/editor/CardPreview',["sap/ui/core/Control","sap/m/HBox","sap/m/Image","sap/m/ToggleButton","sap/ui/integration/widgets/Card","sap/ui/core/Core","sap/ui/dom/includeStylesheet","sap/ui/integration/util/CardMerger"],function(C,H,I,T,a,c,i,d){"use strict";
var e=C.extend("sap.ui.integration.designtime.editor.CardPreview",{
metadata:{properties:{settings:{type:"any"},card:{type:"object"}},aggregations:{cardPreview:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}}},
renderer:function(r,o){if(o._getCurrentMode()==="None"){r.openStart("div",o);r.openEnd();return;}r.openStart("div",o);r.addClass("sapUiIntegrationDTPreview");if(f()){r.addClass("sapUiIntegrationDTPreviewDark");}r.writeClasses();r.openEnd();r.openStart("div");r.addClass("before");r.writeAttribute("tabindex","0");r.writeAttributeEscaped("id",o.getId()+"-before");r.addStyle("z-index",o.getParent()._iZIndex+1);r.writeStyles();r.openEnd();r.close("div");r.renderControl(o._getCardPreview());r.openStart("div");r.writeAttribute("tabindex","0");r.writeAttributeEscaped("id",o.getId()+"-after");r.openEnd();r.close("div");if(o._getModes().indexOf("Live")>-1&&o._getModes().indexOf("Abstract")>-1){r.renderControl(o._getModeToggleButton());}}
});
e.prototype.init=function(){this._oResourceBundle=c.getLibraryResourceBundle("sap.ui.integration");c.attachThemeChanged(function(){if(this.getDomRef()){if(f()){this.getDomRef().classList.add("sapUiIntegrationDTPreviewDark");}else{this.getDomRef().classList.remove("sapUiIntegrationDTPreviewDark");}}else{this.update();}}.bind(this));};
e.prototype.destroy=function(){if(this._oModeToggleButton){this._oModeToggleButton.destroy();}if(this._oCardPreview){this._oCardPreview.destroy();}if(this._oImagePlaceholder){this._oImagePlaceholder.destroy();}if(this._oCardPlaceholder){this._oCardPlaceholder.destroy();}C.prototype.destroy.apply(this,arguments);};
e.prototype._getCardPreview=function(){var p=null;if(this._getCurrentMode()==="Abstract"){if(this.getSettings().preview.src){p=this._getImagePlaceholder();}else{p=this._getCardPlaceholderPreview();}}else if(this._getCurrentMode()==="Live"){p=this._getCardRealPreview();}if(p){this.setAggregation("cardPreview",p);if(!this.getSettings().preview||this.getSettings().preview.scaled!==false){p.addStyleClass("sapUiIntegrationDTPreviewScale");}else{p.addStyleClass("sapUiIntegrationDTPreviewNoScale");}}return p;};
e.prototype._getCardPlaceholderPreview=function(){var o=this.getCard(),p;function _(s,x){return o.getManifestEntry(s)?x||"{bound}":null;}var h=null;if(o.getManifestEntry("/sap.card/header")){var t=o.getManifestEntry("/sap.card/header/type");if(t&&t.toUpperCase()==="NUMERIC"){h={"title":_("/sap.card/header/title"),"type":"Numeric","subTitle":_("/sap.card/header/subTitle"),"unitOfMeasurement":_("/sap.card/header/unitOfMeasurement"),"mainIndicator":_("/sap.card/header/mainIndicator",{"number":"{bound}","unit":"{bound}","trend":"{bound}","state":"{bound}"}),"details":_("/sap.card/header/details"),"sideIndicators":[_("/sap.card/header/sideIndicators/0",{"title":"Deviation","number":"{bound}","unit":"{bound}"}),_("/sap.card/header/sideIndicators/1",{"title":"Target","number":"{bound}","unit":"{bound}"})]};}else{h={"title":_("/sap.card/header/title"),"subTitle":_("/sap.card/header/subTitle"),"status":_("/sap.card/header/status"),"icon":_("/sap.card/header/icon",{"src":"{bound}"})};}}var b=this.getParent().getCurrentSettings();p={"sap.app":{"type":"card","id":o.getManifestEntry("/sap.app/id")+".abstractPreview"},"sap.card":{"type":o.getManifestEntry("/sap.card/type")==="List"?"List":"Component","header":h,"content":{"maxItems":Math.min(b["/sap.card/content/maxItems"]||6,6),"item":{"title":{"value":_("/sap.card/content/item/value")},"icon":_("/sap.card/content/item/icon",{"src":"{bound}"}),"description":_("/sap.card/content/item/description"),"info":{"value":_("/sap.card/content/item/info")}}}}};if(!this._oCardPlaceholder){this._oCardPlaceholder=new a();this._oCardPlaceholder._setPreviewMode(true);}this._oCardPlaceholder.setManifest(p);this._oCardPlaceholder.refresh();return this._oCardPlaceholder;};
e.prototype.getTransformContentInfo=function(){return{transformStyle:"scale3d(0.4, 0.4, 1)",transformFactor:0.4,transformOriginStyle:"0 0",widthStyle:"500px",heightStyle:"600px",zIndex:this.getParent()._iZIndex};};
e.prototype._getCardRealPreview=function(){if(!this._oCardPreview){this._oCardPreview=new a();this._oCardPreview.setBaseUrl(this.getCard().getBaseUrl());}this._initalChanges=this._initalChanges||this._oCardPreview.getManifestChanges()||[];var b=this._initalChanges.concat([this.getParent().getCurrentSettings()]);this._oCardPreview.setManifestChanges(b);this._oCardPreview.setManifest(this.getCard().getManifestEntry("/"));this._oCardPreview.refresh();this._oCardPreview.editor=this._oCardPreview.editor||{};this._oCardPreview.preview=this._oCardPreview.editor.preview=this;return this._oCardPreview;};
e.prototype._getImagePlaceholder=function(){var s=this.getSettings();if(s.preview.src){if(!this._oImagePlaceholder){var h=new H();h.addStyleClass("sapFCard");h.setWidth("500px");var b=this.getCard().getBaseUrl();if(!b&&typeof this.getCard().getManifest()==="string"){b=this.getCard().getManifest();b=b.substring(0,b.lastIndexOf("/")+1);}var g=b+"/"+s.preview.src;var o=new I({src:g});o.addStyleClass("sapUiIntegrationDTPreviewImg");o.setWidth("500px");o.setHeight("600px");h.addItem(o);this._oImagePlaceholder=h;}}return this._oImagePlaceholder;};
e.prototype._getModes=function(){var s=this.getSettings();s.preview=s.preview||{};s.preview.modes=s.preview.modes||"Abstract";return s.preview.modes;};
e.prototype._getCurrentMode=function(){var m=this._getModes();if(!this._currentMode){switch(m){case"AbstractLive":case"Abstract":this._currentMode="Abstract";break;case"LiveAbstract":case"Live":this._currentMode="Live";break;default:this._currentMode="None";}}return this._currentMode;};
e.prototype._toggleCurrentMode=function(){var m=this._getModes();if(m.indexOf("Live")>-1&&m.indexOf("Abstract")>-1){this._currentMode=this._getCurrentMode()==="Abstract"?"Live":"Abstract";}};
e.prototype._getModeToggleButton=function(){var b=c.getLibraryResourceBundle("sap.ui.integration");if(!this._oModeToggleButton){this._oModeToggleButton=new T();this._oModeToggleButton.setTooltip();this._oModeToggleButton.addStyleClass("sapUiIntegrationDTPreviewButton");this._oModeToggleButton.attachPress(function(){this._toggleCurrentMode();this.update();}.bind(this));}var t=this._oModeToggleButton,g=this._getCurrentMode();if(g==="None"){t.setVisible(false);}if(g==="Abstract"){t.setIcon("sap-icon://media-play");t.setPressed(false);t.setTooltip(b.getText("CARDEDITOR_PREVIEW_BTN_LIVEPREVIEW"));}else if(g==="Live"){t.setIcon("sap-icon://media-pause");t.setPressed(true);t.setTooltip(b.getText("CARDEDITOR_PREVIEW_BTN_SAMPLEPREVIEW"));}return this._oModeToggleButton;};
e.prototype.update=function(){this.invalidate();};
function f(h){h=h||window.getComputedStyle(document.body).backgroundColor;var m=/rgb\((\d+).*?(\d+).*?(\d+)\)/.exec(h);if(!m){return false;}var r=parseInt(m[1]),g=parseInt(m[2]),b=parseInt(m[3]),y=(r*299+g*587+b*114)/1000;return(y<=128);}
e.prototype.onsaptabnext=function(E){if(E.target===this.getDomRef("before")){this.getDomRef("after").focus();}};
e.prototype.onsaptabprevious=function(E){if(E.target===this.getDomRef("after")){this.getDomRef("before").focus();}};
e.init=function(){var s=sap.ui.require.toUrl("sap.ui.integration.designtime.editor.css.CardPreview".replace(/\./g,"/")+".css");i(s);this.init=function(){};};
e.init();return e;});
sap.ui.predefine('sap/ui/integration/designtime/editor/fields/BaseField',["sap/ui/core/Control","sap/m/Button","sap/m/MultiInput","./Settings","sap/m/Token","sap/ui/core/Core"],function(C,B,M,S,T,a){"use strict";var r=a.getLibraryResourceBundle("sap.ui.integration"),b="sap/ui/integration/designtime/editor/fields/viz";
var c=C.extend("sap.ui.integration.designtime.editor.fields.Base",{
metadata:{properties:{configuration:{type:"object"},specialButton:{type:"object"},mode:{type:"string"},host:{type:"object"},visible:{type:"boolean",defaultValue:true}},aggregations:{_field:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_settingsButton:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_dynamicField:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{afterInit:{}}},
renderer:function(R,o){var f=o.getAggregation("_field"),s=o.getAggregation("_settingsButton"),d=o._getDynamicField();R.openStart("div");R.addClass("sapUiIntegrationCardEditorItemField");if(f&&f.getWidth&&!s){}if(!o.getVisible()){R.addStyle("display","none");}R.writeClasses();R.writeStyles();R.writeElementData(o);R.openEnd();if(o.getVisible()){R.openStart("span");R.writeClasses();R.openEnd();R.openStart("span");R.addClass("sapUiIntegrationCardEditorEditor");if(o._hasDynamicValue()){R.addStyle("width","1px");R.addStyle("opacity","0");}R.writeStyles();R.writeClasses();R.openEnd();R.renderControl(f);R.close("span");R.close("span");if(s||o._hasDynamicValue()){R.openStart("span");R.addClass("sapUiIntegrationCardEditorSettings");R.writeClasses();R.openEnd();R.openStart("span");R.addClass("sapUiIntegrationCardEditorSettingsField");if(o._hasDynamicValue()){R.addStyle("width","calc(100% - 2.5rem)");R.addStyle("opacity","1");}R.writeClasses();R.writeStyles();R.openEnd();R.renderControl(d);R.close("span");R.openStart("span");R.addClass("sapUiIntegrationCardEditorSettingsButton");R.writeClasses();R.openEnd();R.renderControl(s);R.close("span");R.close("span");}}R.close("div");}
});
c.prototype.init=function(){this._readyPromise=new Promise(function(d){this._fieldResolver=d;}.bind(this));};
c.prototype.setConfiguration=function(o,s){if(o!==this.getConfiguration()){this.setProperty("configuration",o,s);if(o){Promise.resolve().then(function(){this.initEditor(o);}.bind(this));}}return this;};
c.prototype.initEditor=function(o){var d;this.initVisualization&&this.initVisualization(o);if(this._visualization.editor){d=this._visualization.editor;}else if(this._visualization.type){if(typeof this._visualization.type==="string"){if(this._visualization.type.indexOf("/")===-1){this._visualization.type=b+"/"+this._visualization.type;this._visualization.settings=this._visualization.settings||{value:"{currentSettings>value}",editable:"{currentSettings>editable}"};}sap.ui.require([this._visualization.type],function(f){this._visualization.type=f;this.initEditor(o);}.bind(this));return;}d=new this._visualization.type(this._visualization.settings||{});}if(d instanceof C){this.setAggregation("_field",d);}var m=this.getMode();o.allowSettings=o.allowSettings||o.allowSettings!==false&&m==="admin";o.allowDynamicValues=o.allowDynamicValues||o.allowDynamicValues!==false;o._changeDynamicValues=o.visible&&o.editable&&(o.allowDynamicValues||o.allowSettings)&&m!=="translation";if(o._changeDynamicValues){this._addSettingsButton();}this._applySettings(o);};
c.prototype.initVisualization=function(){};
c.prototype._hasDynamicValue=function(){var v=this._getCurrentProperty("value");var d=typeof v==="string"&&(v.indexOf("{context>")===0||v.indexOf("{{parameters")===0);this._setCurrentProperty("_hasDynamicValue",d);return d;};
c.prototype._hasSettings=function(){var o=this.getConfiguration();if(o._next){o._hasSettings=(o._next.editable===false||o._next.visible===false||o._next.allowDynamicValues===false);}else{o._hasSettings=false;}return o._hasSettings;};
c.prototype._getDynamicField=function(){var f=this.getAggregation("_dynamicField");if(!f){var f=new M({showValueHelp:false});this.setAggregation("_dynamicField",f);}return f;};
c.prototype._hideDynamicField=function(){var d=this._getDynamicField(),f=this.getAggregation("_field");if(d.getDomRef()){var s=d.getDomRef().parentNode.style;s.width="1px";s.opacity=0;s=f.getDomRef().parentNode.style;f.getDomRef().style.visibility="visible";s.width="calc(100% - 2.5rem)";s.opacity=1;}};
c.prototype._showDynamicField=function(){var d=this._getDynamicField(),f=this.getAggregation("_field");if(d.getDomRef()){var s=d.getDomRef().parentNode.style;s.width="calc(100% - 2.5rem)";s.opacity=1;s=f.getDomRef().parentNode.style;f.getDomRef().style.visibility="hidden";s.width="1px";s.opacity=0;}};
c.prototype._getSettingsPanel=function(){if(!this._oSettingsPanel){this._oSettingsPanel=new S();}return this._oSettingsPanel;};
c.prototype._openSettingsDialog=function(d){var s=this._getSettingsPanel();window.setTimeout(function(){s.setConfiguration(this.getConfiguration());s.open(this.getAggregation("_settingsButton"),this.getAggregation("_settingsButton"),this.getParent().getAggregation("_preview"),this.getHost(),this,this._applySettings.bind(this),this._cancelSettings.bind(this));}.bind(this),d||600);};
c.prototype._addSettingsButton=function(){this._getDynamicField();this.setAggregation("_settingsButton",new B({icon:"{= ${currentSettings>_hasDynamicValue} ? 'sap-icon://display-more' : 'sap-icon://enter-more'}",type:"Transparent",tooltip:r.getText("CARDEDITOR_FIELD_MORE_SETTINGS"),press:function(){this._openSettingsDialog(200);}.bind(this)}));};
c.prototype._setCurrentProperty=function(p,v){if(this._getCurrentProperty(p)!==v){this.getModel("currentSettings").setProperty(p,v,this.getBindingContext("currentSettings"));}};
c.prototype._getCurrentProperty=function(p){return this.getModel("currentSettings").getProperty(p,this.getBindingContext("currentSettings"));};
c.prototype._applySettings=function(d){var D=this._getDynamicField(),o=this.getModel("contextflat")._getValueObject(d.value);D.removeAllTokens();if(!this._getCurrentProperty("_changeDynamicValues")){D.setEnabled(false);}if(o&&o.path!=="empty"){if(o.object.value&&o.object.value.indexOf("{{")==0){this._setCurrentProperty("value",o.object.value);}else{this._setCurrentProperty("value",o.value);}D.addToken(new T({text:o.object.label,"delete":function(){this._setCurrentProperty("value","");if(!this._hasDynamicValue()){this._hideDynamicField();}this._applyButtonStyles();window.setTimeout(function(){this.getAggregation("_field").focus();}.bind(this),100);}.bind(this)}));}else{this._setCurrentProperty("value",d.value);this._hideDynamicField();}this._setCurrentProperty("_next",d._next);this._applyButtonStyles();if(!this._hasDynamicValue()){this._hideDynamicField();}else{this._showDynamicField();}this._fieldResolver&&this._fieldResolver();this._fieldResolver=null;};
c.prototype._cancelSettings=function(){this._applyButtonStyles();if(!this._hasDynamicValue()){this._hideDynamicField();}};
c.prototype._applyButtonStyles=function(){if(!this._hasDynamicValue()){this.removeStyleClass("dynamicvalue");}else{this.addStyleClass("dynamicvalue");}if(!this._hasSettings()){this.removeStyleClass("settings");}else{this.addStyleClass("settings");}};
return c;});
sap.ui.predefine('sap/ui/integration/designtime/editor/fields/BooleanField',["sap/ui/integration/designtime/editor/fields/BaseField","sap/m/CheckBox"],function(B,C){"use strict";
var a=B.extend("sap.ui.integration.designtime.editor.fields.BooleanField",{renderer:B.getMetadata().getRenderer()});
a.prototype.initVisualization=function(c){var v=c.visualization;if(!v){v={type:C,settings:{selected:{path:'currentSettings>value'},editable:{path:'currentSettings>editable'}}};c.withLabel=true;}this._visualization=v;};
return a;});
sap.ui.predefine('sap/ui/integration/designtime/editor/fields/DateField',["sap/ui/integration/designtime/editor/fields/BaseField","sap/m/DatePicker"],function(B,D){"use strict";
var a=B.extend("sap.ui.integration.designtime.editor.fields.DateField",{renderer:B.getMetadata().getRenderer()});
a.prototype.initVisualization=function(c){var V=c.visualization;if(!V){V={type:D,settings:{dateValue:{path:'currentSettings>value',formatter:function(v){return new Date(v);}},editable:{path:'currentSettings>editable'},valueFormat:"YYYY-MM-dd",width:"16rem",change:function(e){if(e.getParameters().valid){var s=e.getSource();s.getBinding("dateValue").setRawValue(s.getValue());s.getBinding("dateValue").checkUpdate();}else{var s=e.getSource();s.getBinding("dateValue").setRawValue("");}}}};}this._visualization=V;};
return a;});
sap.ui.predefine('sap/ui/integration/designtime/editor/fields/DateTimeField',["sap/ui/integration/designtime/editor/fields/BaseField","sap/m/DateTimePicker"],function(B,D){"use strict";
var a=B.extend("sap.ui.integration.designtime.editor.fields.DateTimeField",{renderer:B.getMetadata().getRenderer()});
a.prototype.initVisualization=function(c){var V=c.visualization;if(!V){V={type:D,settings:{dateValue:{path:'currentSettings>value',formatter:function(v){return new Date(v);}},editable:{path:'currentSettings>editable'},width:"16rem",change:function(e){if(e.getParameters().valid){var s=e.getSource();s.getBinding("dateValue").setRawValue(s.getDateValue().toISOString());s.getBinding("dateValue").checkUpdate();}else{var s=e.getSource();s.getBinding("dateValue").setRawValue("");s.getBinding("dateValue").checkUpdate(true);}}}};}this._visualization=V;};
return a;});
sap.ui.predefine('sap/ui/integration/designtime/editor/fields/DestinationField',["sap/ui/integration/designtime/editor/fields/BaseField","sap/m/Select","sap/ui/core/ListItem"],function(B,S,L){"use strict";
var D=B.extend("sap.ui.integration.designtime.editor.fields.DestinationField",{renderer:B.getMetadata().getRenderer()});
D.prototype.initVisualization=function(c){var v=c.visualization;if(!v){v={type:S,settings:{busy:{path:'currentSettings>_loading'},selectedKey:{path:'currentSettings>value'},width:"100%",items:{path:"currentSettings>_values",template:new L({text:"{currentSettings>name}",key:"{currentSettings>name}"})}}};}this._visualization=v;};
return D;});
sap.ui.predefine('sap/ui/integration/designtime/editor/fields/IntegerField',["sap/ui/integration/designtime/editor/fields/BaseField","sap/m/Input","sap/ui/model/type/Integer"],function(B,I,a){"use strict";
var b=B.extend("sap.ui.integration.designtime.editor.fields.IntegerField",{renderer:B.getMetadata().getRenderer()});
b.prototype.initVisualization=function(c){var v=c.visualization;if(!v){v={type:I,settings:{value:{path:'currentSettings>value',type:new a()},editable:{path:'currentSettings>editable'},type:"Number"}};}this._visualization=v;};
return b;});
sap.ui.predefine('sap/ui/integration/designtime/editor/fields/ListField',["sap/ui/integration/designtime/editor/fields/BaseField","sap/m/Input","sap/m/Text","sap/m/MultiComboBox","sap/ui/core/ListItem"],function(B,I,T,M,L){"use strict";
var b=B.extend("sap.ui.integration.designtime.editor.fields.ListField",{renderer:B.getMetadata().getRenderer()});
b.prototype.initVisualization=function(c){var v=c.visualization;if(!v){if(c.editable){if(c.values){var i=new L(c.values.item);v={type:M,settings:{selectedKeys:{path:'currentSettings>value'},editable:{path:'currentSettings>editable'},showSecondaryValues:true,width:"100%",items:{path:"",template:i}}};}else{v={type:I,settings:{value:{path:'currentSettings>value',formatter:function(a){a=a||[];return a.join(",");}},change:function(e){var s=e.getSource();s.getBinding("value").setRawValue(s.getValue().split(","));},editable:c.editable,placeholder:c.placeholder}};}}else{v={type:T,settings:{text:{path:'currentSettings>value'},wrapping:false}};}}this._visualization=v;};
return b;});
sap.ui.predefine('sap/ui/integration/designtime/editor/fields/NumberField',["sap/ui/integration/designtime/editor/fields/BaseField","sap/m/Input","sap/ui/model/type/Float"],function(B,I,F){"use strict";
var N=B.extend("sap.ui.integration.designtime.editor.fields.NumberField",{renderer:B.getMetadata().getRenderer()});
N.prototype.initVisualization=function(c){var v=c.visualization;if(!v){v={type:I,settings:{value:{path:'currentSettings>value',type:new F()},editable:{path:'currentSettings>editable'},type:"Number"}};}this._visualization=v;};
return N;});
sap.ui.predefine('sap/ui/integration/designtime/editor/fields/Settings',["sap/ui/core/Control","sap/m/ResponsivePopover","sap/ui/model/json/JSONModel","sap/m/Button","sap/m/SegmentedButton","sap/m/SegmentedButtonItem","sap/m/VBox","sap/m/HBox","sap/m/Select","sap/ui/core/ListItem","sap/m/Label","sap/m/Text","sap/m/Title","sap/m/CheckBox","sap/m/Menu","sap/m/MenuItem","sap/m/Input","sap/ui/integration/util/ParameterMap","sap/base/util/merge","sap/ui/core/Core"],function(C,P,J,B,S,b,V,H,c,L,d,T,e,f,M,g,I,h,m,j){"use strict";
var k=C.extend("sap.ui.integration.designtime.editor.fields.Settings",{
metadata:{},
renderer:function(){}
});
k.prototype.setConfiguration=function(o){this._originalConfig=o;o=m({},o);var a=new J(o);this.setModel(a,"currentSettings");this.bindElement({path:"currentSettings>/"});};
k.prototype.open=function(o,a,i,n,v,e1,f1){this.addDependent(z);this.oHost=n;this.fnApply=e1;this.fnCancel=f1;this._oOpener=v;p=true;o.addDependent(this);q=this;this.getModel("currentSettings").checkUpdate(true,true);b1(r.getText("CARDEDITOR_SELECT_FROM_LIST"),[]);if(a){z.setContentWidth((i.getDomRef().offsetWidth+30)+"px");z.setContentHeight((i.getDomRef().offsetHeight-80)+"px");z.setPlacement("Right");u.setValue(o._label);z.openBy(o);}else{z.open();}l=this.getModel("currentSettings");if(l.getProperty("/_hasDynamicValue")){E();}else if(l.getProperty("/_hasSettings")){A();}else if(l.getProperty("/allowDynamicValues")){E();}else if(l.getProperty("/allowSettings")){A();}};
var r=j.getLibraryResourceBundle("sap.ui.integration"),l,p,q=null,D,s,t,u,w,x,y,F;
k.prototype._applyCurrentSettings=function(){this.fnApply(l.getData());};
k.prototype._cancelCurrentSettings=function(){this.fnCancel(this._originalConfig);};
k.prototype.destroy=function(){this.removeDependent(z);return C.prototype.destroy.apply(this,arguments);};
var z=new P({showArrow:true,contentWidth:"400px",showHeader:false,horizontalScrolling:false,modal:false,endButton:new B({text:r.getText("CARDEDITOR_MORE_CANCEL"),press:function(){z.close();}}),beginButton:new B({text:r.getText("CARDEDITOR_MORE_OK"),type:"Emphasized",press:function(){q._applyCurrentSettings();p=false;z.close();}}),afterClose:function(){if(p){q._cancelCurrentSettings();}p=true;}});z.attachAfterOpen(function(){var o=this.getDomRef().querySelector("footer"),a=U.getDomRef();if(a.nextSibling!==o){o.parentNode.insertBefore(a,o);o.style.marginTop="0rem";a.style.display="flex";}var i=W.getDomRef(),n=o.querySelector("button").parentNode;if(i){n.insertBefore(i,n.firstChild);}window.requestAnimationFrame(function(){z.getDomRef()&&(z.getDomRef().style.opacity="1");});});
function A(){s.setVisible(true);D.setVisible(false);G.setSelectedKey("settings");var o=U.getDomRef();window.requestAnimationFrame(function(){o&&(o.style.opacity="0");});}
function E(){s.setVisible(false);D.setVisible(true);G.setSelectedKey("dynamic");var a=q.getModel("contextflat"),o=a._getValueObject(l.getProperty("/value"));if(o&&o.object.label){u.setValue(o.object.label);b1(o.object.description,o.object.tags);if(o.path==="empty"){u.setValue(o.object.label);}d1(o);}var i=U.getDomRef();window.requestAnimationFrame(function(){i&&(i.style.opacity="1");});}
z.addStyleClass("sapUiIntegrationFieldSettings");var G=new S({width:"100%",visible:"{= ${currentSettings>allowDynamicValues} && ${currentSettings>allowSettings}}"});var K=new b({text:r.getText("CARDEDITOR_MORE_DYNAMICVALUES"),key:"dynamic",icon:"{= ${currentSettings>_hasDynamicValue} ? 'sap-icon://display-more' : 'sap-icon://enter-more'}",width:"50%",press:E});K.addStyleClass("dynbtn sel");var N=new b({text:r.getText("CARDEDITOR_MORE_SETTINGS"),key:"settings",icon:"sap-icon://action-settings",width:"50%",press:A});N.addStyleClass("setbtn");G.addItem(K);G.addItem(N);var O=new T({text:r.getText("CARDEDITOR_MORE_DYNAMICVALUES"),visible:"{= ${currentSettings>allowDynamicValues} && !${currentSettings>allowSettings}}"});O.addStyleClass("sapUiTinyMagin");var Q=new T({text:r.getText("CARDEDITOR_MORE_SETTINGS"),visible:"{= !${currentSettings>allowDynamicValues} && ${currentSettings>allowSettings}}"});Q.addStyleClass("sapUiTinyMagin");var R=new H({width:"100%",items:[G,O,Q]});R.addStyleClass("headertitle");var U=new V({width:"100%",items:[new T({text:r.getText("CARDEDITOR_ACTUAL_VALUE")}),new I({value:{path:"currentSettings>_currentContextValue"},editable:false})]});U.addStyleClass("currentval");var W=new B({type:"Transparent",text:r.getText("CARDEDITOR_MORE_RESET"),enabled:"{= ${currentSettings>_next/visible} === false || ${currentSettings>_next/editable} === false || ${currentSettings>_next/allowDynamicValues} === false || ${currentSettings>_beforeValue} !== ${currentSettings>value}}",tooltip:r.getText("CARDEDITOR_MORE_SETTINGS_P_ADMIN_RESET"),press:function(){Y("visible",true);Y("editable",true);Y("allowDynamicValues",true);l.setProperty("/value",l.getProperty("/_beforeValue"));z.getBeginButton().firePress();}});W.addStyleClass("resetbutton");var X=new V({width:"100%",items:[R,U,W]});X.addStyleClass("tabs");z.setCustomHeader(X);
function Y(a,v){if(!l.getProperty("/_next")){l.setProperty("/_next",{});}l.setProperty("/_next/"+a,v);}
function Z(o,v){var a=[];for(var n in o){if(o[n]&&o[n].label){var e1=new g({text:o[n].label});e1.__data=o[n];o[n].pathvalue=(v+"/"+n).substring(1);a.push(e1);var f1=Z(o[n],v+"/"+n);for(var i=0;i<f1.length;i++){e1.addItem(f1[i]);}}}return a;}
function $(){D=new V({visible:true});s=new V({visible:false});D.addStyleClass("sapUiSmallMargin");u=new I({width:"100%",showValueHelp:true,valueHelpOnly:true,valueHelpRequest:function(){if(w){w.destroy();}w=new M({});x=Z(D.getModel("context").getData(),"");for(var i=0;i<x.length;i++){w.addItem(x[i]);}w.attachItemSelected(function(a){var n=a.getParameter("item").__data;b1(n.description||"",n.tags||[]);u.setValue(n.placeholder||n.label);var e1=q.getModel("contextflat");d1(e1._getPathObject(n.pathvalue));});u.addDependent(w);w.addStyleClass("sapUiIntegrationFieldSettingsMenu");w.openBy(u,false,null,null,"1 0");}});u.addStyleClass("selectvariable");var v=new V({items:[new d({text:"Select a dynamic value"}),u]});D.addItem(v);t=new T({text:"",maxLines:6,renderWhitespace:true});v=new V({width:"100%",items:[t]});t.addStyleClass("description");D.addItem(v);if(_.length===-1){y=new c({width:"100%",enabled:true,change:function(){F.setText(y.getSelectedItem()._data.description);}});v=new V({visible:false,items:[new d({text:"Customize the value..."}),y]});D.addItem(v);F=new T({text:"",maxLines:4,renderWhitespace:true});F.addStyleClass("description");v=new V({width:"100%",items:[F]});D.addItem(v);D.getItems()[2].getItems()[0].addStyleClass("sapUiTinyMarginTop");}D.getItems()[0].getItems()[0].addStyleClass("sapUiTinyMarginTop");s.addStyleClass("sapUiSmallMargin");s.addItem(new H({items:[new e({text:r.getText("CARDEDITOR_MORE_SETTINGS_P_ADMIN")}),new B({type:"Transparent",tooltip:r.getText("CARDEDITOR_MORE_SETTINGS_P_ADMIN_RESET"),enabled:"{= ${currentSettings>_next/visible} === false || ${currentSettings>_next/editable} === false || ${currentSettings>_next/allowDynamicValues} === false}",icon:"sap-icon://reset",visible:false,press:function(){s.getItems()[1].getItems()[1].focus();Y("visible",true);Y("editable",true);Y("allowDynamicValues",true);}})]}));s.addItem(new H({items:[new d({text:r.getText("CARDEDITOR_MORE_SETTINGS_P_ADMIN_VISIBLE")}),new f({selected:"{= ${currentSettings>_next/visible} !== false}",select:function(a){Y("visible",a.getParameter("selected"));}})]}));s.addItem(new H({items:[new d({text:r.getText("CARDEDITOR_MORE_SETTINGS_P_ADMIN_EDIT")}),new f({selected:"{= ${currentSettings>_next/editable} !== false}",enabled:"{= ${currentSettings>_next/visible} !== false}",select:function(a){Y("editable",a.getParameter("selected"));}})]}));s.addItem(new H({visible:"{= ${currentSettings>allowDynamicValues}!== false}",items:[new d({text:r.getText("CARDEDITOR_MORE_SETTINGS_P_ADMIN_DYN")}),new f({selected:"{= ${currentSettings>_next/allowDynamicValues} !== false}",enabled:"{= ${currentSettings>_next/visible} !== false && ${currentSettings>_next/editable} !== false}",select:function(a){Y("allowDynamicValues",a.getParameter("selected"));}})]}));var o=s.getItems();o[0].addStyleClass("stitle");o[1].addStyleClass("cbrow");o[2].addStyleClass("cbrow");o[3].addStyleClass("cbrow");z.addContent(D);z.addContent(s);}
var _=[{formatMethod:"format.DateTime",sourceTypes:["datetime","date"],label:"Relative date/datetime text of the value",description:"Should be applied to dynamic values of type date or datetime or string values that represent a datetime in the format 'yyyy-MM-ddZhh:mm:ss'",example:"4 weeks ago",syntax:"handlebars",binding:"{= format.dateTime('__|VALUE|__',{relative:true})}"},{formatMethod:"format.DateTime",sourceTypes:["datetime","date"],label:"Short date/datetime text of the value",description:"Should be applied to dynamic values of type date, date-time or text values that represent a datetime in the format 'yyyy-MM-ddZhh:mm:ss.sss'",example:"9/18/20, 2:09 PM",binding:"{= format.dateTime('__|VALUE|__',{style:'short'})}"},{formatMethod:"format.DateTime",sourceTypes:["datetime","date"],label:"Medium date/datetime text of the value",description:"Should be applied to dynamic values of type date, date-time or text values that represent a datetime in the format 'yyyy-MM-ddThh:mm:ss.sssZ'",example:"Sep 18, 2020, 2:09:04 PM",binding:"{= format.dateTime('__|VALUE|__',{style:'medium'})}"},{formatMethod:"format.DateTime",sourceTypes:["datetime","date"],label:"Long date, date-time text of the value",description:"Should be applied to dynamic values of type date or date-time or string values that represent a datetime in the format 'yyyy-MM-ddThh:mm:ss.sssZ'",example:"Sep 18, 2020, 2:09:04 PM",binding:"{= format.dateTime('__|VALUE|__',{style:'long'})}"}];
function a1(a,n){a=a||[];y.removeAllItems();var o=[];y.addItem(new L({text:"No customizing needed",key:""}));for(var i=0;i<_.length;i++){var v=_[i],e1=new L({text:v.label,key:"key"+i});e1._data=v;if(v.sourceTypes.indexOf(n)>-1||a.indexOf(v.formatMethod)>-1){y.addItem(e1);}else{o.push(e1);}}for(var i=0;i<o.length;i++){y.addItem(o[i]);}}
$();
function b1(a,i){i=i||[];if(i.indexOf("technical")>-1){a=a+"\n"+r.getText("CARDEDITOR_MORE_DYNAMICVALUES_TECHHINT");}t.setText(a);}
function c1(o){if(_.length===-1){if(!o){y.removeAllItems();y.addItem(new L({text:"No customizing available for this value"}));F.setText("");y.setEnabled(false);}else{a1(o.customize,o.type);y.setEnabled(true);}}}
function d1(o){if(o){l.setProperty("/_hasDynamicValue",true);var a=o.value;l.setProperty("/value",a);l.setProperty("/_contextpath",o.path);if(o.object&&o.object.value&&o.object.value.indexOf("{{")===0){l.setProperty("/_currentContextValue",h.processPredefinedParameter(o.object.value));c1(o.object);}else{if(o.path==="empty"){l.setProperty("/value","");l.setProperty("/_currentContextValue","");l.setProperty("/_hasDynamicValue",false);c1();}else{c1(o.object);if(o.object&&o.object.hasOwnProperty("value")){l.setProperty("/_currentContextValue",o.object.value);}else{q.oHost.getContextValue(o.path+"/value").then(function(v){if(v===null){l.setProperty("/_currentContextValue","(not available)");}else{l.setProperty("/_currentContextValue",v);}o.object&&(o.object.value=v);});}}}}}
k._private=function(){return{oPopover:z,oSegmentedButton:G,oSettingsButton:N,oDynamicPanel:D,oSettingsPanel:s,oCurrentModel:l,updateCurrentValue:d1,oCurrentInstance:q,oDynamicValueField:u,getMenuItems:function(){return x;},getMenu:function(){return w;}};};
return k;});
sap.ui.predefine('sap/ui/integration/designtime/editor/fields/StringField',["sap/ui/integration/designtime/editor/fields/BaseField","sap/m/Input","sap/m/Text","sap/m/Select","sap/m/ComboBox","sap/ui/core/ListItem","./viz/IconSelect"],function(B,I,T,S,C,L,a){"use strict";
var b=B.extend("sap.ui.integration.designtime.editor.fields.StringField",{renderer:B.getMetadata().getRenderer()});
b.prototype.initVisualization=function(c){var v=c.visualization;if(!v){if(c.editable){if(c.enum){var i=new L({key:{path:"currentSettings>"},text:{path:"currentSettings>"}});v={type:S,settings:{selectedKey:{path:'currentSettings>value'},editable:c.editable,showSecondaryValues:false,width:"100%",items:{path:"currentSettings>enum",template:i}}};}else if(c.values){var i=new L(c.values.item);v={type:S,settings:{busy:{path:'currentSettings>_loading'},selectedKey:{path:'currentSettings>value'},editable:c.editable,showSecondaryValues:true,width:"100%",items:{path:"",template:i}}};}else{v={type:I,settings:{value:{path:'currentSettings>value'},editable:c.editable,placeholder:c.placeholder}};}}else{if(this.getMode()==="translation"){v={type:T,settings:{text:{path:'currentSettings>value'},wrapping:false}};}else{v={type:I,settings:{value:{path:'currentSettings>value'},editable:false}};}}}this._visualization=v;};
return b;});
sap.ui.predefine('sap/ui/integration/designtime/editor/fields/viz/ColorSelect',["sap/ui/core/Control","sap/m/ColorPalettePopover","sap/m/Button","sap/ui/core/Core","sap/base/util/merge","sap/ui/core/theming/Parameters"],function(C,a,B,b,m,P){"use strict";
var c=C.extend("sap.ui.integration.designtime.editor.fields.viz.ColorSelect",{
metadata:{properties:{enumValue:{type:"string",defaultValue:""},colorValue:{type:"string",defaultValue:""},editable:{type:"boolean",defaultValue:true},colorEnum:{type:"string",defaultValue:"sap.m.AvatarColor"},background:{type:"boolean",defaultValue:true},allowCustomColors:{type:"boolean",defaultValue:false}},aggregations:{_colorpalette:{type:"sap.m.ColorPalettePopover",multiple:false,visibility:"hidden"},_button:{type:"sap.m.Button",multiple:false,visibility:"hidden"}}},
renderer:function(r,f){var g=f.getAggregation("_button");r.openStart("div");r.addClass("sapUiIntegrationColorSelect");r.writeClasses();r.writeStyles();r.writeElementData(f);r.openEnd();r.renderControl(g);r.close("div");}
});
var e={};
function s(){e={"sap.m.AvatarColor":{"Accent1":P.get("sapUiAccent1"),"Accent2":P.get("sapUiAccent2"),"Accent3":P.get("sapUiAccent3"),"Accent4":P.get("sapUiAccent4"),"Accent5":P.get("sapUiAccent5"),"Accent6":P.get("sapUiAccent6"),"Accent7":P.get("sapUiAccent7"),"Accent8":P.get("sapUiAccent8"),"Accent9":P.get("sapUiAccent9"),"Accent10":P.get("sapUiAccent10"),"TileIcon":P.get("sapUiTileIconColor"),"Transparent":"transparent","Placeholder":P.get("sapUiContentImagePlaceholderBackground")}};}
s();b.attachThemeChanged(s);var o,d=new a("oColorPalettePopoverFull",{colorSelect:function(E){var f=E.getParameter("value"),g=e[o.getColorEnum()],i=Object.values(g).indexOf(f);o.setEnumValue(Object.keys(g)[i]);o.setColorValue(f);o._colorValue=f;}});
c.prototype.init=function(){this._oButton=new B({icon:"sap-icon://color-fill",press:function(){this._openPalette();}.bind(this)});this._colorValue="transparent";this.setAggregation("_button",this._oButton);};
c.prototype.onBeforeRendering=function(){if(!this._oStyle){this._oStyle=document.createElement("style");this._oStyle.innerHTML="#"+this.getId()+" .sapUiIcon::before { color: "+this._colorValue+" !important}";document.body.appendChild(this._oStyle);}var r=this._oStyle.sheet.rules[0];if(!this._colorValue||this._colorValue==="transparent"){r.style.opacity="0.5";r.style.color="transparent";r.style.backgroundSize="10px 10px";r.style.backgroundPosition="0px 0px, 0px 10px, 10px -10px, -10px 10px";r.style.border="1px dashed #808080";r.style.padding="0px 0px";r.style.backgroundImage="linear-gradient(45deg, #ddd 25%, transparent 25%), linear-gradient(-45deg, #ddd 25%, transparent 25%), linear-gradient(45deg, transparent 75%, #ddd 75%), linear-gradient(-45deg, transparent 75%, #ddd 75%)";}else{r.style.textShadow="unset";r.style.opacity="unset";r.style.backgroundSize="unset";r.style.backgroundPosition="unset";r.style.border="unset";r.style.padding="unset";r.style.backgroundImage="unset";r.style.color=this._colorValue;}};
c.prototype._openPalette=function(){o=this;d.setShowDefaultColorButton(true);d.setShowMoreColorsButton(false);d.setDefaultColor("");var E=e[this.getColorEnum()];if(E){var f=[];for(var n in E){f.push(E[n]);}d.setColors(f);}d.openBy(this._oButton);};
c.prototype.setEnumValue=function(v){this.setProperty("enumValue",v,true);this._colorValue=e[this.getColorEnum()][v];this.rerender();};
c.prototype.bindProperty=function(p,f){C.prototype.bindProperty.apply(this,arguments);if(p==="editable"){var g=m({},f);this._oButton.bindProperty("enabled",g);}return this;};
return c;});
sap.ui.predefine('sap/ui/integration/designtime/editor/fields/viz/IconSelect',["sap/ui/core/Control","sap/m/Select","sap/ui/core/ListItem","sap/ui/model/json/JSONModel","sap/ui/core/IconPool","sap/base/util/merge","sap/ui/core/Core","sap/base/util/deepClone"],function(C,S,L,J,I,m,c,d){"use strict";var r=c.getLibraryResourceBundle("sap.ui.integration"),D;
var e=C.extend("sap.ui.integration.designtime.editor.fields.viz.IconSelect",{
metadata:{properties:{value:{type:"string",defaultValue:"sap-icon://accept"},editable:{type:"boolean",defaultValue:true},allowFile:{type:"boolean",defaultValue:true},allowNone:{type:"boolean",defaultValue:true}},aggregations:{_select:{type:"sap.m.Select",multiple:false,visibility:"hidden"}}},
renderer:function(R,o){var s=o.getAggregation("_select");R.openStart("div");R.addClass("sapUiIntegrationIconSelect");if(s&&o.getWidth){R.addStyle("width",s.getWidth());}R.writeClasses();R.writeStyles();R.writeElementData(o);R.openEnd();R.renderControl(s);R.close("div");}
});
e.prototype._initIconModel=function(){var i=I.getIconNames();i=i.sort(function(a,b){return a.toLowerCase().localeCompare(b.toLowerCase());});var f=[];if(!D){i.filter(function(s){var t=I.getIconInfo(s).text||("-"+s).replace(/-(.)/ig,function(M,a){return" "+a.toUpperCase();}).substring(1);f.push({icon:"sap-icon://"+s,key:"sap-icon://"+s,text:t,tooltip:t,enabled:true});});f=[{icon:"",text:r.getText("CARDEDITOR_ICON_NONE"),tooltip:"",key:"empty",enabled:true},{icon:"sap-icon://upload",text:r.getText("CARDEDITOR_ICON_CHOOSE"),tooltip:"",key:"file",enabled:true},{icon:"sap-icon://download",text:r.getText("CARDEDITOR_ICON_SELECTED"),tooltip:"",key:"selected",enabled:false}].concat(f);D=d(f);}else{f=d(D);}this._oIconModel=new J(f);this._oIconModel.setSizeLimit(f.length);};
e.prototype.init=function(){if(!this._oIconModel){this._initIconModel();}var i=new L({icon:"{iconlist>icon}",text:"{iconlist>text}",tooltip:"{iconlist>tooltip}",key:"{iconlist>key}",enabled:"{iconlist>enabled}"});this._oFileUpload=document.createElement("INPUT");this._oFileUpload.type="file";this._oFileUpload.accept=".png,.jpg,.jpeg,.svg";this._boundFileUploadChange=this._fileUploadChange.bind(this);this._oFileUpload.addEventListener("change",this._boundFileUploadChange);this._oSelect=new S({width:"100%",items:{path:"iconlist>/",template:i},change:function(E){var s=E.getSource(),a=E.getSource().getSelectedKey();if(a==="file"){s._customImage=null;this._oFileUpload.click();this._boundFocusBack=this._focusBack.bind(this);s.getDomRef("hiddenSelect").addEventListener("focus",this._boundFocusBack);}else{this.setValue(a);}}.bind(this)});this._oSelect.setModel(this._oIconModel,"iconlist");var o=this._oSelect.open;this._oSelect.open=function(){o&&o.apply(this,arguments);this.getPicker().addStyleClass("sapUiIntegrationIconSelectList");this.getPicker().setContentHeight("400px");};this._oSelect.addDelegate({onAfterRendering:function(){var a=this._oSelect.getDomRef("labelIcon");if(a){var s=this._oSelect._customImage;if(s){a.style.backgroundImage="url('"+s+"')";a.classList.add("sapMSelectListItemIconCustom");}else{a.style.backgroundImage="unset";a.classList.remove("sapMSelectListItemIconCustom");}}}.bind(this)});this._oSelect.addDelegate({onsappageup:function(){if(this._oSelect.isOpen()){var s=this._oSelect.getSelectedIndex();this._oSelect.setSelectedIndex(s-50);}}.bind(this),onsappagedown:function(){if(this._oSelect.isOpen()){var s=this._oSelect.getSelectedIndex();if(s<3){this._oSelect.setSelectedIndex(29);}else{this._oSelect.setSelectedIndex(s+50);}}}.bind(this),onsapup:function(){if(this._oSelect.isOpen()){var a=this.getAllowFile();var A=this.getAllowNone();var f=this._oIconModel.getProperty("/2/enabled");var s=this._oSelect.getSelectedIndex();if(s>11+2){this._oSelect.setSelectedIndex(s-11);}else if(s>=3){if(A&&!a){this._oSelect.setSelectedIndex(0);}else if(f){this._oSelect.setSelectedIndex(2);}else{this._oSelect.setSelectedIndex(3);}}}}.bind(this),onsapdown:function(){if(this._oSelect.isOpen()){var s=this._oSelect.getSelectedIndex();if(s>1){this._oSelect.setSelectedIndex(s+11);}}}.bind(this),onsapleft:function(){if(this._oSelect.isOpen()){this._oSelect.onsapup.apply(this._oSelect,arguments);}}.bind(this),onsapright:function(){if(this._oSelect.isOpen()){this._oSelect.onsapdown.apply(this._oSelect,arguments);}}.bind(this)},true);this.setAggregation("_select",this._oSelect);};
e.prototype._fileUploadChange=function(){var f=new window.FileReader();f.onload=function(){this.setValue(f.result);this._oSelect.invalidate();}.bind(this);if(this._oFileUpload.files.length===1){f.readAsDataURL(this._oFileUpload.files[0]);}};
e.prototype._focusBack=function(){this._oSelect.getDomRef("hiddenSelect").removeEventListener("focus",this._boundFocusBack);setTimeout(function(){this.setValue(this.getValue());}.bind(this),150);};
e.prototype.bindProperty=function(p,b){C.prototype.bindProperty.apply(this,arguments);if(p==="editable"){var s=m({},b);this._oSelect.bindProperty("editable",s);}return this;};
e.prototype.setValue=function(v){this.setProperty("value",v,true);if(v.indexOf("data:image/")===0){this._oSelect._customImage=v;this._oIconModel.setProperty("/2/enabled",true);this._oSelect.setSelectedKey("selected");}else{this._oSelect._customImage=null;this._oIconModel.setProperty("/2/enabled",false);this._oSelect.setSelectedKey(v);}this._oSelect.invalidate();return this;};
e.prototype.setAllowFile=function(v){this.setProperty("allowFile",v,true);v=this.getAllowFile();this._oIconModel.setProperty("/1/enabled",v);return this;};
e.prototype.setAllowNone=function(v){this.setProperty("allowNone",v,true);v=this.getAllowNone();this._oIconModel.setProperty("/0/enabled",v);return this;};
return e;});
sap.ui.predefine('sap/ui/integration/designtime/editor/fields/viz/ShapeSelect',["sap/ui/core/Control","sap/m/SegmentedButton","sap/m/SegmentedButtonItem","sap/ui/core/Core","sap/base/util/merge","sap/ui/core/theming/Parameters"],function(C,S,a,b,m,P){"use strict";
var c=C.extend("sap.ui.integration.designtime.editor.fields.viz.ShapeSelect",{
metadata:{properties:{value:{type:"string",defaultValue:"Circle"},editable:{type:"boolean",defaultValue:true}},aggregations:{_segmentedbutton:{type:"sap.m.SegmentedButton",multiple:false,visibility:"hidden"}}},
renderer:function(r,o){var s=o.getAggregation("_segmentedbutton");r.openStart("div");r.addClass("sapUiIntegrationShapeSelect");r.writeClasses();r.writeStyles();r.writeElementData(o);r.openEnd();r.renderControl(s);r.close("div");}
});
c.prototype.init=function(){this._oSegmentedButton=new S({items:[new a({icon:"sap-icon://circle-task",key:"Circle"}),new a({icon:"sap-icon://border",key:"Square"})]});this.setAggregation("_segmentedbutton",this._oSegmentedButton);};
c.prototype.bindProperty=function(p,B){C.prototype.bindProperty.apply(this,arguments);if(p==="editable"){var s=m({},B);this._oSegmentedButton.bindProperty("enabled",s);}if(p==="value"){var s=m({},B);this._oSegmentedButton.bindProperty("selectedKey",s);}return this;};
return c;});
/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 *
 * @function
 * @private
 * @experimental
 */
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/config/generateDataConfig',function(){"use strict";return function(t,r,a){var d={"DataRequestUrl":{"tags":t.concat(["data"]),"label":"{i18n>CARD_EDITOR.DATA.REQUEST.URL}","type":"string","defaultValue":"","path":r+"data/request/url"},"DataRequestMode":{"tags":t.concat(["data"]),"label":"{i18n>CARD_EDITOR.DATA.REQUEST.MODE}","type":"select","items":[{"key":"no-cors"},{"key":"same-origin"},{"key":"cors"}],"defaultValue":"cors","path":r+"data/request/mode","visible":"{= !!${context>"+r+"data/request/url} }"},"DataRequestMethod":{"tags":t.concat(["data"]),"label":"{i18n>CARD_EDITOR.DATA.REQUEST.METHOD}","type":"select","items":[{"key":"GET"},{"key":"POST"}],"defaultValue":"GET","path":r+"data/request/method","visible":"{= !!${context>"+r+"data/request/url} }"},"DataRequestParameters":{"tags":t.concat(["data"]),"label":"{i18n>CARD_EDITOR.DATA.REQUEST.PARAMETERS}","type":"map","path":r+"data/request/parameters","visible":"{= !!${context>"+r+"data/request/url} }"},"DataRequestHeaders":{"tags":t.concat(["data"]),"label":"{i18n>CARD_EDITOR.DATA.REQUEST.HEADERS}","type":"map","path":r+"data/request/headers","visible":"{= !!${context>"+r+"data/request/url} }"},"DataRequestWithCredentials":{"tags":t.concat(["data"]),"label":"{i18n>CARD_EDITOR.DATA.REQUEST.WITHCREDENTIALS}","type":"boolean","defaultValue":false,"path":r+"data/request/withCredentials","visible":"{= !!${context>"+r+"data/request/url} }"},"DataJson":{"tags":t.concat(["data"]),"label":"{i18n>CARD_EDITOR.DATA.JSON}","type":"json","path":r+"data/json","visible":"{= !${context>"+r+"data/request/url} }"},"DataPath":{"tags":t.concat(["data"]),"label":"{i18n>CARD_EDITOR.DATA.PATH}","type":"string","path":r+"data/path","validators":{"dataPathPattern":{"type":"pattern","config":{"pattern":"^[a-zA-Z0-9_\\.\\-/|\\@\\#]*$"}}}},"DataServiceName":{"tags":t.concat(["data"]),"label":"{i18n>CARD_EDITOR.DATA.SERVICE.NAME}","type":"string","path":r+"data/service/name","visible":false},"DataServiceParameters":{"tags":t.concat(["data"]),"label":"{i18n>CARD_EDITOR.DATA.SERVICE.PARAMETERS}","type":"map","path":r+"data/service/parameters","visible":false},"DataUpdateInterval":{"tags":t.concat(["data"]),"label":"{i18n>CARD_EDITOR.DATA.UPDATEINTERVAL}","type":"number","path":r+"data/updateInterval"}};var g={};Object.keys(d).forEach(function(k){g[a+k]=d[k];});return g;};});
/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 *
 * @private
 * @experimental
 */
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/config/AppConfig',function(){"use strict";return{"appId":{"tags":["app"],"label":"{i18n>CARD_EDITOR.APP.ID}","type":"string","maxLength":70,"path":"/sap.app/id"},"appVersion":{"tags":["app"],"label":"{i18n>CARD_EDITOR.APP.VERSION}","type":"string","path":"/sap.app/applicationVersion/version"},"appTitle":{"tags":["app"],"label":"{i18n>CARD_EDITOR.TITLE}","type":"string","path":"/sap.app/title"},"appSubTitle":{"tags":["app"],"label":"{i18n>CARD_EDITOR.SUBTITLE}","type":"string","path":"/sap.app/subTitle"},"appShortTitle":{"tags":["app"],"label":"{i18n>CARD_EDITOR.APP.SHORTTITLE}","type":"string","path":"/sap.app/shortTitle"},"appInfo":{"tags":["app"],"label":"{i18n>CARD_EDITOR.APP.INFO}","type":"string","path":"/sap.app/info"},"appIcon":{"tags":["app"],"label":"{i18n>CARD_EDITOR.ICON}","type":"simpleicon","path":"/sap.ui/icons/icon"},"appDescription":{"tags":["app"],"label":"{i18n>CARD_EDITOR.APP.DESCRIPTION}","type":"string","path":"/sap.app/description"},"appI18n":{"tags":["app"],"label":"{i18n>CARD_EDITOR.APP.I18N}","type":"string","path":"/sap.app/i18n","defaultValue":"i18n/i18n.properties"},"appTagKeywords":{"tags":["app"],"label":"{i18n>CARD_EDITOR.APP.TAGS.KEYWORDS}","type":"list","path":"/sap.app/tags/keywords"},"appTagTechnicalAttributes":{"tags":["app"],"label":"{i18n>CARD_EDITOR.APP.TAGS.TECHNICALATTRIBUTES}","type":"list","path":"/sap.app/tags/technicalAttributes","validators":{"technicalAttributesPattern":{"type":"patternList","config":{"pattern":"^[A-Z0-9_\\-\\/]+$"}}}},"appDataSources":{"label":"{i18n>CARD_EDITOR.APP.DATASOURCES}","type":"complexMap","itemLabel":"{key}","addItemLabel":"{i18n>CARD_EDITOR.APP.DATASOURCE}","path":"/sap.app/dataSources","template":{"key":{"label":"{i18n>CARD_EDITOR.APP.DATASOURCES.KEY}","type":"string","path":"key","validators":{"keyPattern":{"type":"pattern","config":{"pattern":"^[a-zA-Z0-9_\\.\\-]*$"}}}},"uri":{"label":"{i18n>CARD_EDITOR.APP.DATASOURCES.URI}","type":"string","path":"uri"},"type":{"label":"{i18n>CARD_EDITOR.LABEL.TYPE}","type":"select","items":[{"key":"OData"},{"key":"ODataAnnotation"},{"key":"INA"},{"key":"XML"},{"key":"JSON"},{"key":"FHIR"}],"defaultValue":"OData","path":"type"},"odataVersion":{"label":"{i18n>CARD_EDITOR.APP.DATASOURCES.SETTINGS.ODATAVERSION}","type":"select","items":[{"key":"2.0"},{"key":"4.0"}],"defaultValue":"2.0","path":"settings/odataVersion","visible":"{= ${type} === 'OData' || ${type} === 'ODataAnnotation'}"},"localUri":{"label":"{i18n>CARD_EDITOR.APP.DATASOURCES.SETTINGS.LOCALURI}","type":"string","path":"settings/localUri","visible":"{= ${type} === 'OData' || ${type} === 'ODataAnnotation'}"},"annotations":{"label":"{i18n>CARD_EDITOR.APP.DATASOURCES.SETTINGS.ANNOTATIONS}","type":"list","path":"settings/annotations","visible":"{= ${type} === 'OData' || ${type} === 'ODataAnnotation'}"},"maxAge":{"label":"{i18n>CARD_EDITOR.APP.DATASOURCES.SETTINGS.MAXAGE}","type":"number","path":"settings/maxAge"}}},"mobile":{"tags":["app"],"label":"{i18n>CARD_EDITOR.APP.MOBILE}","type":"boolean","defaultValue":"","path":"/sap.platform.mobilecards/compatible"}};});
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/config/HeaderConfig',["sap/ui/integration/designtime/cardEditor/config/generateActionConfig"],function(g){"use strict";return{"headerType":{"tags":["header"],"label":"{i18n>CARD_EDITOR.HEADERTYPE}","path":"header/type","type":"select","items":[{"key":"Default","title":"{i18n>CARD_EDITOR.HEADERTYPE.DEFAULT}"},{"key":"Numeric","title":"{i18n>CARD_EDITOR.HEADERTYPE.NUMERIC}"}],"defaultValue":"Default"},"headerPosition":{"tags":["header"],"label":"{i18n>CARD_EDITOR.HEADERPOSITION}","path":"headerPosition","type":"select","items":[{"key":"Top","title":"{i18n>CARD_EDITOR.HEADERPOSITION.TOP}"},{"key":"Bottom","title":"{i18n>CARD_EDITOR.HEADERPOSITION.BOTTOM}"}],"defaultValue":"Top"},"title":{"tags":["header"],"label":"{i18n>CARD_EDITOR.TITLE}","type":"string","path":"header/title"},"subTitle":{"tags":["header"],"label":"{i18n>CARD_EDITOR.SUBTITLE}","type":"string","path":"header/subTitle"},"actions":g({"tags":["header"],"path":"header/actions","maxItems":1}),"statusText":{"tags":["header","defaultHeader"],"label":"{i18n>CARD_EDITOR.STATUS}","type":"string","path":"header/status/text"},"icon":{"tags":["header","defaultHeader"],"label":"{i18n>CARD_EDITOR.ICON}","type":"icon","path":"header/icon","visible":"{= ${context>header/type} !== 'Numeric' }"},"unitOfMeasurement":{"tags":["header","numericHeader"],"label":"{i18n>CARD_EDITOR.UOM}","type":"string","path":"header/unitOfMeasurement","visible":"{= ${context>header/type} === 'Numeric' }"},"mainIndicatorNumber":{"tags":["header","numericHeader","mainIndicator"],"label":"{i18n>CARD_EDITOR.NUMBER}","type":"number","path":"header/mainIndicator/number","visible":"{= ${context>header/type} === 'Numeric' }"},"mainIndicatorUnit":{"tags":["header","numericHeader","mainIndicator"],"label":"{i18n>CARD_EDITOR.MAIN_INDICATOR.UNIT}","type":"string","path":"header/mainIndicator/unit","visible":"{= ${context>header/type} === 'Numeric' }"},"mainIndicatorTrend":{"tags":["header","numericHeader","mainIndicator"],"label":"{i18n>CARD_EDITOR.MAIN_INDICATOR.TREND}","type":"select","items":[{"key":"Down","title":"{i18n>CARD_EDITOR.MAIN_INDICATOR.TREND.DOWN}"},{"key":"None","title":"{i18n>CARD_EDITOR.MAIN_INDICATOR.TREND.NONE}"},{"key":"Up","title":"{i18n>CARD_EDITOR.MAIN_INDICATOR.TREND.UP}"}],"allowBinding":true,"path":"header/mainIndicator/trend","visible":"{= ${context>header/type} === 'Numeric' }"},"mainIndicatorState":{"tags":["header","numericHeader","mainIndicator"],"label":"{i18n>CARD_EDITOR.MAIN_INDICATOR.STATE}","type":"select","items":[{"key":"Critical","title":"{i18n>CARD_EDITOR.MAIN_INDICATOR.STATE.CRITICAL}"},{"key":"Error","title":"{i18n>CARD_EDITOR.MAIN_INDICATOR.STATE.ERROR}"},{"key":"Good","title":"{i18n>CARD_EDITOR.MAIN_INDICATOR.STATE.GOOD}"},{"key":"Neutral","title":"{i18n>CARD_EDITOR.MAIN_INDICATOR.STATE.NEUTRAL}"}],"allowBinding":true,"path":"header/mainIndicator/state","visible":"{= ${context>header/type} === 'Numeric' }"},"details":{"tags":["header","numericHeader"],"label":"{i18n>CARD_EDITOR.DETAILS}","type":"string","path":"header/details","visible":"{= ${context>header/type} === 'Numeric' }"},"sideIndicators":{"tags":["header","numericHeader"],"label":"{i18n>CARD_EDITOR.SIDE_INDICATORS}","path":"header/sideIndicators","type":"array","itemLabel":"{title}","addItemLabel":"{i18n>CARD_EDITOR.SIDE_INDICATOR}","template":{"title":{"label":"{i18n>CARD_EDITOR.TITLE}","type":"string","path":"title"},"number":{"label":"{i18n>CARD_EDITOR.NUMBER}","type":"number","path":"number"},"unit":{"label":"{i18n>CARD_EDITOR.SIDE_INDICATOR.UNIT}","type":"string","path":"unit"}},"maxItems":2,"visible":"{= ${context>header/type} === 'Numeric' }"}};});
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/config/ListCardConfig',["sap/ui/integration/designtime/cardEditor/config/generateActionConfig"],function(g){"use strict";return{"listMaxItems":{"tags":["content"],"label":"{i18n>CARD_EDITOR.MAXITEMS}","type":"integer","path":"content/maxItems","visible":"{= ${context>type} === 'List' }"},"listItemTitle":{"tags":["content","listItem"],"label":"{i18n>CARD_EDITOR.TITLE}","type":"string","path":"content/item/title","visible":"{= ${context>type} === 'List' }"},"listItemDescription":{"tags":["content","listItem"],"label":"{i18n>CARD_EDITOR.LIST_ITEM.DESCRIPTION}","type":"string","path":"content/item/description","visible":"{= ${context>type} === 'List' }"},"listItemInfoValue":{"tags":["content","listItem"],"label":"{i18n>CARD_EDITOR.LIST_ITEM.INFO.VALUE}","type":"string","path":"content/item/info/value","visible":"{= ${context>type} === 'List' }"},"listItemInfoState":{"tags":["content","listItem"],"label":"{i18n>CARD_EDITOR.LIST_ITEM.INFO.STATE}","type":"select","items":[{"key":"Success","title":"{i18n>CARD_EDITOR.STATE.SUCCESS}"},{"key":"Error","title":"{i18n>CARD_EDITOR.STATE.ERROR}"},{"key":"Warning","title":"{i18n>CARD_EDITOR.STATE.WARNING}"},{"key":"None","title":"{i18n>CARD_EDITOR.STATE.NONE}"},{"key":"Information","title":"{i18n>CARD_EDITOR.STATE.INFORMATION}"}],"defaultValue":"None","path":"content/item/info/state","visible":"{= ${context>type} === 'List' }"},"listItemHighlight":{"tags":["content","listItem"],"label":"{i18n>CARD_EDITOR.LIST_ITEM.HIGHLIGHT}","type":"select","items":[{"key":"Success","title":"{i18n>CARD_EDITOR.STATE.SUCCESS}"},{"key":"Error","title":"{i18n>CARD_EDITOR.STATE.ERROR}"},{"key":"Warning","title":"{i18n>CARD_EDITOR.STATE.WARNING}"},{"key":"None","title":"{i18n>CARD_EDITOR.STATE.NONE}"},{"key":"Information","title":"{i18n>CARD_EDITOR.STATE.INFORMATION}"}],"defaultValue":"None","path":"content/item/highlight","visible":"{= ${context>type} === 'List' }"},"listItemIcon":{"tags":["content","listItem"],"label":"{i18n>CARD_EDITOR.LIST_ITEM.ICON}","type":"simpleicon","path":"content/item/icon/src","visible":"{= ${context>type} === 'List' }"},"listItemActions":g({"tags":["content","listItem"],"path":"content/item/actions","maxItems":1,"visible":"{= ${context>type} === 'List' }"})};});
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/config/ObjectCardConfig',["sap/ui/integration/designtime/cardEditor/config/generateActionConfig","sap/ui/integration/designtime/cardEditor/util/CommonPatterns"],function(g,C){"use strict";return{"objectGroups":{"tags":["content"],"label":"{i18n>CARD_EDITOR.OBJECT.GROUPS}","type":"array","path":"content/groups","itemLabel":"{title}","addItemLabel":"{i18n>CARD_EDITOR.OBJECT.GROUP}","template":{"title":{"label":"{i18n>CARD_EDITOR.TITLE}","type":"string","path":"title"},"items":{"tags":["content","objectGroup"],"label":"{i18n>CARD_EDITOR.OBJECT.GROUP.ITEMS}","type":"array","path":"items","itemLabel":"{label}","addItemLabel":"{i18n>CARD_EDITOR.OBJECT.GROUP.ITEM}","template":{"icon":{"tags":["content","objectGroupItem"],"label":"{i18n>CARD_EDITOR.ICON}","type":"icon","path":"icon"},"label":{"tags":["content","objectGroupItem"],"label":"{i18n>CARD_EDITOR.LABEL}","type":"string","path":"label"},"value":{"tags":["content","objectGroupItem"],"label":"{i18n>CARD_EDITOR.OBJECT.GROUP.ITEM.VALUE}","type":"string","path":"value","validators":{"emailPattern":{"type":"pattern","config":{"pattern":C.email,"modifiers":"i"},"errorMessage":"CARD_EDITOR.VALIDATOR.INVALID_EMAIL","isEnabled":"{= ${type} === 'email'}"}}},"type":{"tags":["content","objectGroupItem"],"label":"{i18n>CARD_EDITOR.LABEL.TYPE}","type":"select","items":[{"key":"phone","title":"{i18n>CARD_EDITOR.OBJECT.GROUP.TYPE.PHONE}"},{"key":"email","title":"{i18n>CARD_EDITOR.OBJECT.GROUP.TYPE.EMAIL}"},{"key":"link","title":"{i18n>CARD_EDITOR.OBJECT.GROUP.TYPE.LINK}"},{"key":"text","title":"{i18n>CARD_EDITOR.OBJECT.GROUP.TYPE.TEXT}"}],"defaultValue":"text","path":"type"},"url":{"tags":["content","objectGroupItem"],"label":"{i18n>CARD_EDITOR.LABEL.URL}","type":"string","path":"url","visible":"{= ${type} === 'link'}"},"target":{"tags":["content","objectGroupItem"],"label":"{i18n>CARD_EDITOR.TARGET}","type":"select","items":[{"key":"_blank","description":"{i18n>CARD_EDITOR.TARGET.BLANK}"},{"key":"_self","description":"{i18n>CARD_EDITOR.TARGET.SELF}"}],"defaultValue":"_blank","path":"target","visible":"{= ${type} === 'link' && !!${url}}"},"emailSubject":{"tags":["content","objectGroupItem"],"label":"{i18n>CARD_EDITOR.OBJECT.GROUP.ITEM.EMAILSUBJECT}","type":"string","path":"emailSubject","visible":"{= ${type} === 'email'}"}}}},"visible":"{= ${context>type} === 'Object' }"},"objectActions":g({"tags":["content"],"path":"content/actions","maxItems":1,"visible":"{= ${context>type} === 'Object' }"})};});
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/config/TableCardConfig',["sap/ui/integration/designtime/cardEditor/config/generateActionConfig"],function(g){"use strict";return{"tableMaxItems":{"tags":["content"],"label":"{i18n>CARD_EDITOR.MAXITEMS}","type":"integer","path":"content/maxItems","visible":"{= ${context>type} === 'Table' }"},"tableRowColumns":{"tags":["content","tableRow"],"label":"{i18n>CARD_EDITOR.TABLE.ROW.COLUMNS}","type":"array","path":"content/row/columns","itemLabel":"{title}","addItemLabel":"{i18n>CARD_EDITOR.TABLE.ROW.COLUMN}","template":{"title":{"tags":["content","tableRowColumn"],"label":"{i18n>CARD_EDITOR.TITLE}","type":"string","path":"title"},"width":{"tags":["content","tableRowColumn"],"label":"{i18n>CARD_EDITOR.TABLE.ROW.COLUMN.WIDTH}","type":"string","path":"width"},"value":{"tags":["content","tableRowColumn"],"label":"{i18n>CARD_EDITOR.TABLE.ROW.COLUMN.VALUE}","type":"string","path":"value"},"icon":{"tags":["content","tableRowColumn"],"label":"{i18n>CARD_EDITOR.ICON}","type":"icon","path":"icon","visible":false},"state":{"tags":["content","tableRowColumn"],"label":"{i18n>CARD_EDITOR.TABLE.ROW.COLUMN.STATE}","type":"select","items":[{"key":"Success","title":"{i18n>CARD_EDITOR.STATE.SUCCESS}"},{"key":"Error","title":"{i18n>CARD_EDITOR.STATE.ERROR}"},{"key":"Warning","title":"{i18n>CARD_EDITOR.STATE.WARNING}"},{"key":"None","title":"{i18n>CARD_EDITOR.STATE.NONE}"},{"key":"Information","title":"{i18n>CARD_EDITOR.STATE.INFORMATION}"}],"defaultValue":"None","path":"state"},"url":{"tags":["content","tableRowColumn"],"label":"{i18n>CARD_EDITOR.LABEL.URL}","type":"string","path":"url"},"target":{"tags":["content","tableRowColumn"],"label":"{i18n>CARD_EDITOR.TARGET}","type":"select","items":[{"key":"_blank","description":"{i18n>CARD_EDITOR.TARGET.BLANK}"},{"key":"_self","description":"{i18n>CARD_EDITOR.TARGET.SELF}"}],"defaultValue":"_blank","path":"target","visible":"{= !!${url}}"},"identifier":{"tags":["content","tableRowColumn"],"label":"{i18n>CARD_EDITOR.TABLE.ROW.COLUMN.IDENTIFIER}","type":"boolean","defaultValue":false,"path":"identifier"},"progressIndicatorState":{"tags":["content","tableRowColumn"],"label":"{i18n>CARD_EDITOR.TABLE.ROW.COLUMN.PROGRESSINDICATOR.STATE}","type":"select","items":[{"key":"Success","title":"{i18n>CARD_EDITOR.STATE.SUCCESS}"},{"key":"Error","title":"{i18n>CARD_EDITOR.STATE.ERROR}"},{"key":"Warning","title":"{i18n>CARD_EDITOR.STATE.WARNING}"},{"key":"None","title":"{i18n>CARD_EDITOR.STATE.NONE}"},{"key":"Information","title":"{i18n>CARD_EDITOR.STATE.INFORMATION}"}],"defaultValue":"None","path":"progressIndicator/state"},"progressIndicatorPercent":{"tags":["content","tableRowColumn"],"label":"{i18n>CARD_EDITOR.TABLE.ROW.COLUMN.PROGRESSINDICATOR.PERCENT}","type":"number","path":"progressIndicator/percent"},"progressIndicatorText":{"tags":["content","tableRowColumn"],"label":"{i18n>CARD_EDITOR.TABLE.ROW.COLUMN.PROGRESSINDICATOR.TEXT}","type":"string","path":"progressIndicator/text"}},"visible":"{= ${context>type} === 'Table' }"},"tableRowActions":g({"tags":["content","tableRow"],"path":"content/row/actions","maxItems":1,"visible":"{= ${context>type} === 'Table' }"})};});
sap.ui.predefine('sap/ui/integration/designtime/cardEditor/config/index',["sap/ui/integration/designtime/cardEditor/config/AppConfig","sap/ui/integration/designtime/cardEditor/config/HeaderConfig","sap/ui/integration/designtime/cardEditor/config/ListCardConfig","sap/ui/integration/designtime/cardEditor/config/ObjectCardConfig","sap/ui/integration/designtime/cardEditor/config/TableCardConfig","sap/ui/integration/designtime/cardEditor/config/generateDataConfig"],function(A,H,L,O,T,g){"use strict";return{"context":"sap.card","layout":{"form":{"groups":[{"label":"{i18n>CARD_EDITOR.GROUP.METADATA}","items":[{type:"tag",value:"app"}]},{"label":"{i18n>CARD_EDITOR.GROUP.GENERALCONFIGURATION}","items":[{type:"tag",value:"general"}]},{"label":"{i18n>CARD_EDITOR.GROUP.DATA}","items":[{type:"propertyName",value:"appDataSources"},{type:"tag",value:["data","general-data"]}]},{"label":"{i18n>CARD_EDITOR.GROUP.DATAHEADER}","items":[{type:"tag",value:["data","header"]}]},{"label":"{i18n>CARD_EDITOR.GROUP.DATACONTENT}","items":[{type:"tag",value:["data","content"]}]},{"label":"{i18n>CARD_EDITOR.GROUP.HEADER}","items":[{type:"tag",value:"header"}]},{"label":"{i18n>CARD_EDITOR.GROUP.CONTENT}","items":[{type:"tag",value:"content"}]}]}},"properties":Object.assign({},A,{"type":{"tags":["general"],"label":"{i18n>CARD_EDITOR.TYPE}","type":"select","items":sap.ui.version.includes('SNAPSHOT')&&!window.location.host.includes("openui5nightly")?[{"key":"List"},{"key":"Analytical"},{"key":"Table"},{"key":"Object"},{"key":"Timeline"},{"key":"Component"},{"key":"Calendar"},{"key":"AdaptiveCard"}]:[{"key":"List"},{"key":"Table"},{"key":"Object"}],"path":"type"},"parameters":{"tags":["general"],"label":"{i18n>CARD_EDITOR.PARAMETERS}","path":"configuration/parameters","type":"parameters","allowedTypes":["string","number","boolean","integer","date","datetime"]},"destinations":{"tags":["general"],"label":"{i18n>CARD_EDITOR.DESTINATIONS}","itemLabel":"{key}","addItemLabel":"{i18n>CARD_EDITOR.DESTINATION}","path":"configuration/destinations","type":"destinations"}},H,L,O,T,g(["general-data"],"","card"),g(["header"],"header/","header"),g(["content"],"content/","content")),"propertyEditors":{"enum":"sap/ui/integration/designtime/baseEditor/propertyEditor/enumStringEditor/EnumStringEditor","select":"sap/ui/integration/designtime/baseEditor/propertyEditor/selectEditor/SelectEditor","string":"sap/ui/integration/designtime/baseEditor/propertyEditor/stringEditor/StringEditor","simpleicon":"sap/ui/integration/designtime/baseEditor/propertyEditor/iconEditor/IconEditor","array":"sap/ui/integration/designtime/baseEditor/propertyEditor/arrayEditor/ArrayEditor","parameters":"sap/ui/integration/designtime/cardEditor/propertyEditor/parametersEditor/ParametersEditor","boolean":"sap/ui/integration/designtime/baseEditor/propertyEditor/booleanEditor/BooleanEditor","number":"sap/ui/integration/designtime/baseEditor/propertyEditor/numberEditor/NumberEditor","integer":"sap/ui/integration/designtime/baseEditor/propertyEditor/integerEditor/IntegerEditor","json":"sap/ui/integration/designtime/baseEditor/propertyEditor/jsonEditor/JsonEditor","map":"sap/ui/integration/designtime/baseEditor/propertyEditor/mapEditor/MapEditor","list":"sap/ui/integration/designtime/baseEditor/propertyEditor/listEditor/ListEditor","datetime":"sap/ui/integration/designtime/baseEditor/propertyEditor/dateTimeEditor/DateTimeEditor","date":"sap/ui/integration/designtime/baseEditor/propertyEditor/dateEditor/DateEditor","icon":"sap/ui/integration/designtime/cardEditor/propertyEditor/iconEditor/IconEditor","complexMap":"sap/ui/integration/designtime/cardEditor/propertyEditor/complexMapEditor/ComplexMapEditor","destinations":"sap/ui/integration/designtime/cardEditor/propertyEditor/destinationsEditor/DestinationsEditor"},"validators":{"patternList":"sap/ui/integration/designtime/cardEditor/validator/IsPatternMatchList"},"i18n":"sap/ui/integration/designtime/cardEditor/i18n/i18n.properties"};});
//# sourceMappingURL=library-preload.designtime.js.map