/**
 * MIT License
 *
 * Copyright (c) 2017 Microsoft
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
(function w(r,f){if(typeof exports==='object'&&typeof module==='object')module.exports=f();else if(typeof sap.ui.define==='function')sap.ui.define([],f);else if(typeof exports==='object')exports["AdaptiveCards"]=f();else r["AdaptiveCards"]=f();})(window,function(){return(function(m){var i={};function _(a){if(i[a]){return i[a].exports;}var b=i[a]={i:a,l:false,exports:{}};m[a].call(b.exports,b,b.exports,_);b.l=true;return b.exports;}_.m=m;_.c=i;_.d=function(e,n,g){if(!_.o(e,n)){Object.defineProperty(e,n,{enumerable:true,get:g});}};_.r=function(e){if(typeof Symbol!=='undefined'&&Symbol.toStringTag){Object.defineProperty(e,Symbol.toStringTag,{value:'Module'});}Object.defineProperty(e,'__esModule',{value:true});};_.t=function(v,a){if(a&1)v=_(v);if(a&8)return v;if((a&4)&&typeof v==='object'&&v&&v.__esModule)return v;var n=Object.create(null);_.r(n);Object.defineProperty(n,'default',{enumerable:true,value:v});if(a&2&&typeof v!='string')for(var k in v)_.d(n,k,function(k){return v[k];}.bind(null,k));return n;};_.n=function(a){var g=a&&a.__esModule?function b(){return a['default'];}:function b(){return a;};_.d(g,'a',g);return g;};_.o=function(o,p){return Object.prototype.hasOwnProperty.call(o,p);};_.p="";return _(_.s="./src/adaptivecards.ts");})({"./src/adaptivecards.ts":(function(a,e,_){"use strict";function b(m){for(var p in m)if(!e.hasOwnProperty(p))e[p]=m[p];}Object.defineProperty(e,"__esModule",{value:true});
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
b(_("./src/card-elements.ts"));b(_("./src/enums.ts"));b(_("./src/host-config.ts"));b(_("./src/shared.ts"));b(_("./src/utils.ts"));}),"./src/card-elements.ts":(function(m,a,_){"use strict";var c=(this&&this.__extends)||(function(){var e=function(d,b){e=Object.setPrototypeOf||({__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b;})||function(d,b){for(var p in b)if(b.hasOwnProperty(p))d[p]=b[p];};return e(d,b);};return function(d,b){e(d,b);function i(){this.constructor=d;}d.prototype=b===null?Object.create(b):(i.prototype=b.prototype,new i());};})();Object.defineProperty(a,"__esModule",{value:true});
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
var E=_("./src/enums.ts");var S=_("./src/shared.ts");var U=_("./src/utils.ts");var H=_("./src/host-config.ts");var T=_("./src/text-formatters.ts");function f(b,d){if(b){b["setCollection"](d);}}function g(b,d){if(d){for(var i=0;i<d.length;i++){if(b.getJsonTypeName()===d[i]){return false;}}}return true;}var I;(function(I){I[I["UnknownType"]=0]="UnknownType";I[I["ForbiddenType"]=1]="ForbiddenType";})(I||(I={}));function h(p,b,d,e,i,y1,z1){var A1=null;if(b&&typeof b==="object"){var B1=false;var C1=U.getStringValue(b["type"]);if(d&&d.indexOf(C1)>=0){q1(y1(C1,I.ForbiddenType),z1);}else{A1=i(C1);if(!A1){B1=e;q1(y1(C1,I.UnknownType),z1);}else{A1.setParent(p);A1.parse(b,z1);B1=A1.shouldFallback()&&e;}if(B1){var D1=b["fallback"];if(!D1){p.setShouldFallback(true);}if(typeof D1==="string"&&D1.toLowerCase()==="drop"){A1=null;}else if(typeof D1==="object"){A1=h(p,D1,d,true,i,y1,z1);}}}}return A1;}function j(p,b,d,e,i){return h(p,b,d,e,function(y1){return v1.actionTypeRegistry.createInstance(y1);},function(y1,z1){if(z1==I.UnknownType){return{error:E.ValidationError.UnknownActionType,message:"Unknown action type: "+y1+". Fallback will be used if present."};}else{return{error:E.ValidationError.ActionTypeNotAllowed,message:"Action type "+y1+" is not allowed in this context."};}},i);}a.createActionInstance=j;function k(p,b,d,e){return h(p,b,[],d,function(i){return v1.elementTypeRegistry.createInstance(i);},function(i,y1){if(y1==I.UnknownType){return{error:E.ValidationError.UnknownElementType,message:"Unknown element type: "+i+". Fallback will be used if present."};}else{return{error:E.ValidationError.ElementTypeNotAllowed,message:"Element type "+i+" is not allowed in this context."};}},e);}a.createElementInstance=k;var l=(function(){function l(){this._rawProperties={};}l.prototype.parse=function(b,e){this._rawProperties=v1.enableFullJsonRoundTrip?b:{};};l.prototype.toJSON=function(){var b;if(v1.enableFullJsonRoundTrip&&this._rawProperties&&typeof this._rawProperties==="object"){b=this._rawProperties;}else{b={};}return b;};l.prototype.setCustomProperty=function(b,d){var e=(typeof d==="string"&&U.isNullOrEmpty(d))||d===undefined||d===null;if(e){delete this._rawProperties[b];}else{this._rawProperties[b]=d;}};l.prototype.getCustomProperty=function(b){return this._rawProperties[b];};return l;}());a.SerializableObject=l;var V=(function(){function V(b){this.cardObject=b;this.errors=[];}return V;}());a.ValidationFailure=V;var n=(function(){function n(){this.allIds={};this.failures=[];}n.prototype.getFailureIndex=function(b){for(var i=0;i<this.failures.length;i++){if(this.failures[i].cardObject===b){return i;}}return-1;};n.prototype.addFailure=function(b,e){var i=this.getFailureIndex(b);var d;if(i<0){d=new V(b);this.failures.push(d);}else{d=this.failures[i];}d.errors.push(e);};return n;}());a.ValidationResults=n;var C=(function(b){c(C,b);function C(){return b!==null&&b.apply(this,arguments)||this;}C.prototype.internalValidateProperties=function(d){if(!U.isNullOrEmpty(this.id)){if(d.allIds.hasOwnProperty(this.id)){if(d.allIds[this.id]==1){d.addFailure(this,{error:E.ValidationError.DuplicateId,message:"Duplicate Id: "+this.id});}d.allIds[this.id]+=1;}else{d.allIds[this.id]=1;}}};C.prototype.parse=function(d,e){b.prototype.parse.call(this,d,e);this.id=U.getStringValue(d["id"]);};C.prototype.toJSON=function(){var d=b.prototype.toJSON.call(this);U.setProperty(d,"type",this.getJsonTypeName());U.setProperty(d,"id",this.id);return d;};C.prototype.validateProperties=function(){var d=new n();this.internalValidateProperties(d);return d;};return C;}(l));a.CardObject=C;var o=(function(b){c(o,b);function o(){var d=b!==null&&b.apply(this,arguments)||this;d._shouldFallback=false;d._lang=undefined;d._hostConfig=null;d._parent=null;d._renderedElement=null;d._separatorElement=null;d._isVisible=true;d._truncatedDueToOverflow=false;d._defaultRenderedElementDisplayMode=null;d._padding=null;d.requires=new H.HostCapabilities();d.horizontalAlignment=null;d.spacing=E.Spacing.Default;d.separator=false;d.customCssSelector=null;d.height="auto";d.minPixelHeight=null;return d;}o.prototype.internalRenderSeparator=function(){var d=U.renderSeparation(this.hostConfig,{spacing:this.hostConfig.getEffectiveSpacing(this.spacing),lineThickness:this.separator?this.hostConfig.separator.lineThickness:null,lineColor:this.separator?this.hostConfig.separator.lineColor:null},this.separatorOrientation);if(v1.alwaysBleedSeparators&&d&&this.separatorOrientation==E.Orientation.Horizontal){var p=this.getParentContainer();if(p&&p.getEffectivePadding()){var e=this.hostConfig.paddingDefinitionToSpacingDefinition(p.getEffectivePadding());d.style.marginLeft="-"+e.left+"px";d.style.marginRight="-"+e.right+"px";}}return d;};o.prototype.updateRenderedElementVisibility=function(){var d=this.isDesignMode()||this.isVisible?this._defaultRenderedElementDisplayMode:"none";if(this._renderedElement){this._renderedElement.style.display=d;}if(this._separatorElement){if(this.parent&&this.parent.isFirstElement(this)){this._separatorElement.style.display="none";}else{this._separatorElement.style.display=d;}}};o.prototype.hideElementDueToOverflow=function(){if(this._renderedElement&&this.isVisible){this._renderedElement.style.visibility='hidden';this.isVisible=false;n1(this,false);}};o.prototype.showElementHiddenDueToOverflow=function(){if(this._renderedElement&&!this.isVisible){this._renderedElement.style.visibility=null;this.isVisible=true;n1(this,false);}};o.prototype.handleOverflow=function(d){if(this.isVisible||this.isHiddenDueToOverflow()){var e=this.truncateOverflow(d);this._truncatedDueToOverflow=e||this._truncatedDueToOverflow;if(!e){this.hideElementDueToOverflow();}else if(e&&!this.isVisible){this.showElementHiddenDueToOverflow();}}};o.prototype.resetOverflow=function(){var d=false;if(this._truncatedDueToOverflow){this.undoOverflowTruncation();this._truncatedDueToOverflow=false;d=true;}if(this.isHiddenDueToOverflow){this.showElementHiddenDueToOverflow();}return d;};o.prototype.createPlaceholderElement=function(){var e=document.createElement("div");e.style.border="1px dashed #DDDDDD";e.style.padding="4px";e.style.minHeight="32px";e.style.fontSize="10px";e.innerText="Empty "+this.getJsonTypeName();return e;};o.prototype.adjustRenderedElementSize=function(d){if(this.height==="auto"){d.style.flex="0 0 auto";}else{d.style.flex="1 1 auto";}if(this.minPixelHeight){d.style.minHeight=this.minPixelHeight+"px";}};o.prototype.overrideInternalRender=function(){return this.internalRender();};o.prototype.applyPadding=function(){if(this.separatorElement){if(v1.alwaysBleedSeparators&&this.separatorOrientation==E.Orientation.Horizontal&&!this.isBleeding()){var p=new S.PaddingDefinition();this.getImmediateSurroundingPadding(p);var d=this.hostConfig.paddingDefinitionToSpacingDefinition(p);this.separatorElement.style.marginLeft="-"+d.left+"px";this.separatorElement.style.marginRight="-"+d.right+"px";}else{this.separatorElement.style.marginRight="0";this.separatorElement.style.marginLeft="0";}}};o.prototype.truncateOverflow=function(d){return false;};o.prototype.undoOverflowTruncation=function(){};o.prototype.getDefaultPadding=function(){return new S.PaddingDefinition();};o.prototype.getHasBackground=function(){return false;};o.prototype.getPadding=function(){return this._padding;};o.prototype.setPadding=function(d){this._padding=d;};Object.defineProperty(o.prototype,"supportsMinHeight",{get:function(){return false;},enumerable:true,configurable:true});Object.defineProperty(o.prototype,"useDefaultSizing",{get:function(){return true;},enumerable:true,configurable:true});Object.defineProperty(o.prototype,"allowCustomPadding",{get:function(){return true;},enumerable:true,configurable:true});Object.defineProperty(o.prototype,"separatorOrientation",{get:function(){return E.Orientation.Horizontal;},enumerable:true,configurable:true});Object.defineProperty(o.prototype,"defaultStyle",{get:function(){return E.ContainerStyle.Default;},enumerable:true,configurable:true});o.prototype.asString=function(){return"";};o.prototype.isBleeding=function(){return false;};o.prototype.toJSON=function(){var d=b.prototype.toJSON.call(this);U.setProperty(d,"isVisible",this.isVisible,true);if(this.horizontalAlignment!==null){U.setEnumProperty(E.HorizontalAlignment,d,"horizontalAlignment",this.horizontalAlignment);}U.setEnumProperty(E.Spacing,d,"spacing",this.spacing,E.Spacing.Default);U.setProperty(d,"separator",this.separator,false);U.setProperty(d,"height",this.height,"auto");if(this.supportsMinHeight){U.setProperty(d,"minHeight",typeof this.minPixelHeight==="number"&&!isNaN(this.minPixelHeight)?this.minPixelHeight+"px":undefined);}return d;};o.prototype.setParent=function(d){this._parent=d;};o.prototype.getEffectiveStyle=function(){if(this.parent){return this.parent.getEffectiveStyle();}return this.defaultStyle;};o.prototype.getForbiddenElementTypes=function(){return null;};o.prototype.getForbiddenActionTypes=function(){return null;};o.prototype.getImmediateSurroundingPadding=function(d,p,e,i,y1){if(p===void 0){p=true;}if(e===void 0){e=true;}if(i===void 0){i=true;}if(y1===void 0){y1=true;}if(this.parent){var z1=p&&this.parent.isTopElement(this);var A1=e&&this.parent.isRightMostElement(this);var B1=i&&this.parent.isBottomElement(this);var C1=y1&&this.parent.isLeftMostElement(this);var D1=this.parent.getEffectivePadding();if(D1){if(z1&&D1.top!=E.Spacing.None){d.top=D1.top;z1=false;}if(A1&&D1.right!=E.Spacing.None){d.right=D1.right;A1=false;}if(B1&&D1.bottom!=E.Spacing.None){d.bottom=D1.bottom;B1=false;}if(C1&&D1.left!=E.Spacing.None){d.left=D1.left;C1=false;}}if(z1||A1||B1||C1){this.parent.getImmediateSurroundingPadding(d,z1,A1,B1,C1);}}};o.prototype.parse=function(d,e){b.prototype.parse.call(this,d,e);o1(this,d,e);this.requires.parse(d["requires"],e);this.isVisible=U.getBoolValue(d["isVisible"],this.isVisible);this.horizontalAlignment=U.getEnumValue(E.HorizontalAlignment,d["horizontalAlignment"],this.horizontalAlignment);this.spacing=U.getEnumValue(E.Spacing,d["spacing"],E.Spacing.Default);this.separator=U.getBoolValue(d["separator"],this.separator);var i=d["separation"];if(i!==undefined){if(i==="none"){this.spacing=E.Spacing.None;this.separator=false;}else if(i==="strong"){this.spacing=E.Spacing.Large;this.separator=true;}else if(i==="default"){this.spacing=E.Spacing.Default;this.separator=false;}q1({error:E.ValidationError.Deprecated,message:"The \"separation\" property is deprecated and will be removed. Use the \"spacing\" and \"separator\" properties instead."},e);}var p=d["height"];if(p==="auto"||p==="stretch"){this.height=p;}if(this.supportsMinHeight){var y1=d["minHeight"];if(y1&&typeof y1==="string"){var z1=false;try{var A1=S.SizeAndUnit.parse(y1,true);if(A1.unit==E.SizeUnit.Pixel){this.minPixelHeight=A1.physicalSize;z1=true;}}catch(_a){}if(!z1){q1({error:E.ValidationError.InvalidPropertyValue,message:"Invalid \"minHeight\" value: "+y1},e);}}}else{this.minPixelHeight=null;}};o.prototype.getActionCount=function(){return 0;};o.prototype.getActionAt=function(i){throw new Error("Index out of range.");};o.prototype.remove=function(){if(this.parent&&this.parent instanceof u){return this.parent.removeItem(this);}return false;};o.prototype.render=function(){this._renderedElement=this.overrideInternalRender();this._separatorElement=this.internalRenderSeparator();if(this._renderedElement){if(this.customCssSelector){this._renderedElement.classList.add(this.customCssSelector);}this._renderedElement.style.boxSizing="border-box";this._defaultRenderedElementDisplayMode=this._renderedElement.style.display;this.adjustRenderedElementSize(this._renderedElement);this.updateLayout(false);}else if(this.isDesignMode()){this._renderedElement=this.createPlaceholderElement();}return this._renderedElement;};o.prototype.updateLayout=function(p){if(p===void 0){p=true;}this.updateRenderedElementVisibility();this.applyPadding();};o.prototype.indexOf=function(d){return-1;};o.prototype.isDesignMode=function(){var d=this.getRootElement();return d instanceof v1&&d.designMode;};o.prototype.isRendered=function(){return this._renderedElement&&this._renderedElement.offsetHeight>0;};o.prototype.isFirstElement=function(e){return true;};o.prototype.isLastElement=function(e){return true;};o.prototype.isAtTheVeryLeft=function(){return this.parent?this.parent.isLeftMostElement(this)&&this.parent.isAtTheVeryLeft():true;};o.prototype.isAtTheVeryRight=function(){return this.parent?this.parent.isRightMostElement(this)&&this.parent.isAtTheVeryRight():true;};o.prototype.isAtTheVeryTop=function(){return this.parent?this.parent.isFirstElement(this)&&this.parent.isAtTheVeryTop():true;};o.prototype.isAtTheVeryBottom=function(){return this.parent?this.parent.isLastElement(this)&&this.parent.isAtTheVeryBottom():true;};o.prototype.isBleedingAtTop=function(){return false;};o.prototype.isBleedingAtBottom=function(){return false;};o.prototype.isLeftMostElement=function(e){return true;};o.prototype.isRightMostElement=function(e){return true;};o.prototype.isTopElement=function(e){return this.isFirstElement(e);};o.prototype.isBottomElement=function(e){return this.isLastElement(e);};o.prototype.isHiddenDueToOverflow=function(){return this._renderedElement&&this._renderedElement.style.visibility=='hidden';};o.prototype.getRootElement=function(){var d=this;while(d.parent){d=d.parent;}return d;};o.prototype.getParentContainer=function(){var d=this.parent;while(d){if(d instanceof f1){return d;}d=d.parent;}return null;};o.prototype.getAllInputs=function(){return[];};o.prototype.getResourceInformation=function(){return[];};o.prototype.getElementById=function(i){return this.id===i?this:null;};o.prototype.getActionById=function(i){return null;};o.prototype.shouldFallback=function(){return this._shouldFallback||!this.requires.areAllMet(this.hostConfig.hostCapabilities);};o.prototype.setShouldFallback=function(d){this._shouldFallback=d;};o.prototype.getEffectivePadding=function(){var p=this.getPadding();return(p&&this.allowCustomPadding)?p:this.getDefaultPadding();};Object.defineProperty(o.prototype,"lang",{get:function(){if(this._lang){return this._lang;}else{if(this.parent){return this.parent.lang;}else{return undefined;}}},set:function(d){if(d&&d!=""){var e=/^[a-z]{2,3}$/ig;var i=e.exec(d);if(!i){throw new Error("Invalid language identifier: "+d);}}this._lang=d;},enumerable:true,configurable:true});Object.defineProperty(o.prototype,"hostConfig",{get:function(){if(this._hostConfig){return this._hostConfig;}else{if(this.parent){return this.parent.hostConfig;}else{return x1;}}},set:function(d){this._hostConfig=d;},enumerable:true,configurable:true});Object.defineProperty(o.prototype,"index",{get:function(){if(this.parent){return this.parent.indexOf(this);}else{return 0;}},enumerable:true,configurable:true});Object.defineProperty(o.prototype,"isInteractive",{get:function(){return false;},enumerable:true,configurable:true});Object.defineProperty(o.prototype,"isStandalone",{get:function(){return true;},enumerable:true,configurable:true});Object.defineProperty(o.prototype,"isInline",{get:function(){return false;},enumerable:true,configurable:true});Object.defineProperty(o.prototype,"parent",{get:function(){return this._parent;},enumerable:true,configurable:true});Object.defineProperty(o.prototype,"isVisible",{get:function(){return this._isVisible;},set:function(d){if(v1.useAdvancedCardBottomTruncation&&!d){this.undoOverflowTruncation();}if(this._isVisible!=d){this._isVisible=d;this.updateRenderedElementVisibility();if(this._renderedElement){n1(this);}}},enumerable:true,configurable:true});Object.defineProperty(o.prototype,"hasVisibleSeparator",{get:function(){if(this.parent&&this.separatorElement){return!this.parent.isFirstElement(this)&&(this.isVisible||this.isDesignMode());}else{return false;}},enumerable:true,configurable:true});Object.defineProperty(o.prototype,"renderedElement",{get:function(){return this._renderedElement;},enumerable:true,configurable:true});Object.defineProperty(o.prototype,"separatorElement",{get:function(){return this._separatorElement;},enumerable:true,configurable:true});return o;}(C));a.CardElement=o;var B=(function(b){c(B,b);function B(){var d=b!==null&&b.apply(this,arguments)||this;d._selectAction=null;d.size=E.TextSize.Default;d.weight=E.TextWeight.Default;d.color=E.TextColor.Default;d.isSubtle=false;d.fontType=null;return d;}B.prototype.getEffectiveStyleDefinition=function(){return this.hostConfig.containerStyles.getStyleByName(this.getEffectiveStyle());};B.prototype.getFontSize=function(d){switch(this.size){case E.TextSize.Small:return d.fontSizes.small;case E.TextSize.Medium:return d.fontSizes.medium;case E.TextSize.Large:return d.fontSizes.large;case E.TextSize.ExtraLarge:return d.fontSizes.extraLarge;default:return d.fontSizes.default;}};B.prototype.getColorDefinition=function(d,e){switch(e){case E.TextColor.Accent:return d.accent;case E.TextColor.Dark:return d.dark;case E.TextColor.Light:return d.light;case E.TextColor.Good:return d.good;case E.TextColor.Warning:return d.warning;case E.TextColor.Attention:return d.attention;default:return d.default;}};B.prototype.setText=function(d){this._text=d;};B.prototype.asString=function(){return this.text;};B.prototype.toJSON=function(){var d=b.prototype.toJSON.call(this);U.setEnumProperty(E.TextSize,d,"size",this.size,E.TextSize.Default);U.setEnumProperty(E.TextWeight,d,"weight",this.weight,E.TextWeight.Default);U.setEnumProperty(E.TextColor,d,"color",this.color,E.TextColor.Default);U.setProperty(d,"text",this.text);U.setProperty(d,"isSubtle",this.isSubtle,false);U.setEnumProperty(E.FontType,d,"fontType",this.fontType,E.FontType.Default);return d;};B.prototype.applyStylesTo=function(d){var e=this.hostConfig.getFontTypeDefinition(this.fontType);if(e.fontFamily){d.style.fontFamily=e.fontFamily;}var i;switch(this.size){case E.TextSize.Small:i=e.fontSizes.small;break;case E.TextSize.Medium:i=e.fontSizes.medium;break;case E.TextSize.Large:i=e.fontSizes.large;break;case E.TextSize.ExtraLarge:i=e.fontSizes.extraLarge;break;default:i=e.fontSizes.default;break;}d.style.fontSize=i+"px";var p=this.getColorDefinition(this.getEffectiveStyleDefinition().foregroundColors,this.effectiveColor);d.style.color=U.stringToCssColor(this.isSubtle?p.subtle:p.default);var y1;switch(this.weight){case E.TextWeight.Lighter:y1=e.fontWeights.lighter;break;case E.TextWeight.Bolder:y1=e.fontWeights.bolder;break;default:y1=e.fontWeights.default;break;}d.style.fontWeight=y1.toString();};B.prototype.parse=function(d,e){b.prototype.parse.call(this,d,e);this.text=U.getStringValue(d["text"]);var i=U.getStringValue(d["size"]);if(i&&i.toLowerCase()==="normal"){this.size=E.TextSize.Default;q1({error:E.ValidationError.Deprecated,message:"The TextBlock.size value \"normal\" is deprecated and will be removed. Use \"default\" instead."},e);}else{this.size=U.getEnumValue(E.TextSize,i,this.size);}var p=U.getStringValue(d["weight"]);if(p&&p.toLowerCase()==="normal"){this.weight=E.TextWeight.Default;q1({error:E.ValidationError.Deprecated,message:"The TextBlock.weight value \"normal\" is deprecated and will be removed. Use \"default\" instead."},e);}else{this.weight=U.getEnumValue(E.TextWeight,p,this.weight);}this.color=U.getEnumValue(E.TextColor,d["color"],this.color);this.isSubtle=U.getBoolValue(d["isSubtle"],this.isSubtle);this.fontType=U.getEnumValue(E.FontType,d["fontType"],this.fontType);};Object.defineProperty(B.prototype,"effectiveColor",{get:function(){return this.color?this.color:E.TextColor.Default;},enumerable:true,configurable:true});Object.defineProperty(B.prototype,"text",{get:function(){return this._text;},set:function(d){this.setText(d);},enumerable:true,configurable:true});Object.defineProperty(B.prototype,"selectAction",{get:function(){return this._selectAction;},set:function(d){this._selectAction=d;if(this._selectAction){this._selectAction.setParent(this);}},enumerable:true,configurable:true});return B;}(o));a.BaseTextBlock=B;var q=(function(b){c(q,b);function q(){var d=b!==null&&b.apply(this,arguments)||this;d._processedText=null;d._treatAsPlainText=true;d.wrap=false;d.useMarkdown=true;return d;}q.prototype.restoreOriginalContent=function(){var d=this.maxLines?(this._computedLineHeight*this.maxLines)+'px':null;this.renderedElement.style.maxHeight=d;this.renderedElement.innerHTML=this._originalInnerHtml;};q.prototype.truncateIfSupported=function(d){var e=this.renderedElement.children;var i=!e.length;var p=i||e.length==1&&e[0].tagName.toLowerCase()=='p';if(p){var y1=i?this.renderedElement:e[0];U.truncate(y1,d,this._computedLineHeight);return true;}return false;};q.prototype.setText=function(d){b.prototype.setText.call(this,d);this._processedText=null;};q.prototype.getRenderedDomElementType=function(){return"div";};q.prototype.internalRender=function(){var d=this;this._processedText=null;if(!U.isNullOrEmpty(this.text)){var p=this.hostConfig;var y1=document.createElement(this.getRenderedDomElementType());y1.classList.add(p.makeCssClassName("ac-textBlock"));y1.style.overflow="hidden";this.applyStylesTo(y1);if(this.selectAction){y1.onclick=function(e){e.preventDefault();e.cancelBubble=true;d.selectAction.execute();};if(p.supportsInteractivity){y1.tabIndex=0;y1.setAttribute("role","button");y1.setAttribute("aria-label",this.selectAction.title);y1.classList.add(p.makeCssClassName("ac-selectable"));}}if(!this._processedText){this._treatAsPlainText=true;var z1=T.formatText(this.lang,this.text);if(this.useMarkdown){if(v1.allowMarkForTextHighlighting){z1=z1.replace(/<mark>/g,"===").replace(/<\/mark>/g,"/==");}var A1=v1.applyMarkdown(z1);if(A1.didProcess&&A1.outputHtml){this._processedText=A1.outputHtml;this._treatAsPlainText=false;if(v1.allowMarkForTextHighlighting){var B1="";var C1=this.getEffectiveStyleDefinition();if(C1.highlightBackgroundColor){B1+="background-color: "+C1.highlightBackgroundColor+";";}if(C1.highlightForegroundColor){B1+="color: "+C1.highlightForegroundColor+";";}if(!U.isNullOrEmpty(B1)){B1='style="'+B1+'"';}this._processedText=this._processedText.replace(/===/g,"<mark "+B1+">").replace(/\/==/g,"</mark>");}}else{this._processedText=z1;this._treatAsPlainText=true;}}else{this._processedText=z1;this._treatAsPlainText=true;}}if(this._treatAsPlainText){y1.innerText=this._processedText;}else{y1.innerHTML=this._processedText;}if(y1.firstElementChild instanceof HTMLElement){var D1=y1.firstElementChild;D1.style.marginTop="0px";D1.style.width="100%";if(!this.wrap){D1.style.overflow="hidden";D1.style.textOverflow="ellipsis";}}if(y1.lastElementChild instanceof HTMLElement){y1.lastElementChild.style.marginBottom="0px";}var E1=y1.getElementsByTagName("a");for(var i=0;i<E1.length;i++){var F1=E1[i];F1.classList.add(p.makeCssClassName("ac-anchor"));F1.target="_blank";F1.onclick=function(e){if(j1(d,e.target)){e.preventDefault();e.cancelBubble=true;}};}if(this.wrap){y1.style.wordWrap="break-word";if(this.maxLines>0){y1.style.maxHeight=(this._computedLineHeight*this.maxLines)+"px";y1.style.overflow="hidden";}}else{y1.style.whiteSpace="nowrap";y1.style.textOverflow="ellipsis";}if(v1.useAdvancedTextBlockTruncation||v1.useAdvancedCardBottomTruncation){this._originalInnerHtml=y1.innerHTML;}return y1;}else{return null;}};q.prototype.truncateOverflow=function(d){if(d>=this._computedLineHeight){return this.truncateIfSupported(d);}return false;};q.prototype.undoOverflowTruncation=function(){this.restoreOriginalContent();if(v1.useAdvancedTextBlockTruncation&&this.maxLines){var d=this._computedLineHeight*this.maxLines;this.truncateIfSupported(d);}};q.prototype.toJSON=function(){var d=b.prototype.toJSON.call(this);U.setProperty(d,"wrap",this.wrap,false);U.setNumberProperty(d,"maxLines",this.maxLines);return d;};q.prototype.applyStylesTo=function(d){b.prototype.applyStylesTo.call(this,d);var p=this.getParentContainer();var i=p?p.isRtl():false;switch(this.horizontalAlignment){case E.HorizontalAlignment.Center:d.style.textAlign="center";break;case E.HorizontalAlignment.Right:d.style.textAlign=i?"left":"right";break;default:d.style.textAlign=i?"right":"left";break;}var e=this.hostConfig.lineHeights;if(e){switch(this.size){case E.TextSize.Small:this._computedLineHeight=e.small;break;case E.TextSize.Medium:this._computedLineHeight=e.medium;break;case E.TextSize.Large:this._computedLineHeight=e.large;break;case E.TextSize.ExtraLarge:this._computedLineHeight=e.extraLarge;break;default:this._computedLineHeight=e.default;break;}}else{this._computedLineHeight=this.getFontSize(this.hostConfig.getFontTypeDefinition(this.fontType))*1.33;}d.style.lineHeight=this._computedLineHeight+"px";};q.prototype.parse=function(d,e){b.prototype.parse.call(this,d,e);this.wrap=U.getBoolValue(d["wrap"],this.wrap);this.maxLines=U.getNumberValue(d["maxLines"]);};q.prototype.getJsonTypeName=function(){return"TextBlock";};q.prototype.updateLayout=function(p){if(p===void 0){p=false;}b.prototype.updateLayout.call(this,p);if(v1.useAdvancedTextBlockTruncation&&this.maxLines&&this.isRendered()){this.restoreOriginalContent();this.truncateIfSupported(this._computedLineHeight*this.maxLines);}};return q;}(B));a.TextBlock=q;var L=(function(b){c(L,b);function L(){return b!==null&&b.apply(this,arguments)||this;}L.prototype.getRenderedDomElementType=function(){return"label";};L.prototype.internalRender=function(){var d=b.prototype.internalRender.call(this);if(!U.isNullOrEmpty(this.forElementId)){d.htmlFor=this.forElementId;}return d;};return L;}(q));var r=(function(b){c(r,b);function r(){var d=b!==null&&b.apply(this,arguments)||this;d.italic=false;d.strikethrough=false;d.highlight=false;return d;}r.prototype.internalRender=function(){var d=this;if(!U.isNullOrEmpty(this.text)){var i=this.hostConfig;var p=T.formatText(this.lang,this.text);var y1=document.createElement("span");y1.classList.add(i.makeCssClassName("ac-textRun"));this.applyStylesTo(y1);if(this.selectAction&&i.supportsInteractivity){var z1=document.createElement("a");z1.classList.add(i.makeCssClassName("ac-anchor"));z1.href=this.selectAction.getHref();z1.target="_blank";z1.onclick=function(e){e.preventDefault();e.cancelBubble=true;d.selectAction.execute();};z1.innerText=p;y1.appendChild(z1);}else{y1.innerText=p;}return y1;}else{return null;}};r.prototype.applyStylesTo=function(d){b.prototype.applyStylesTo.call(this,d);if(this.italic){d.style.fontStyle="italic";}if(this.strikethrough){d.style.textDecoration="line-through";}if(this.highlight){var e=this.getColorDefinition(this.getEffectiveStyleDefinition().foregroundColors,this.effectiveColor);d.style.backgroundColor=U.stringToCssColor(this.isSubtle?e.highlightColors.subtle:e.highlightColors.default);}};r.prototype.toJSON=function(){var d=b.prototype.toJSON.call(this);U.setProperty(d,"italic",this.italic,false);U.setProperty(d,"strikethrough",this.strikethrough,false);U.setProperty(d,"highlight",this.highlight,false);if(this.selectAction){U.setProperty(d,"selectAction",this.selectAction.toJSON());}return d;};r.prototype.parse=function(d,e){b.prototype.parse.call(this,d,e);this.italic=U.getBoolValue(d["italic"],this.italic);this.strikethrough=U.getBoolValue(d["strikethrough"],this.strikethrough);this.highlight=U.getBoolValue(d["highlight"],this.highlight);this.selectAction=j(this,d["selectAction"],[a1.JsonTypeName],!this.isDesignMode(),e);};r.prototype.getJsonTypeName=function(){return"TextRun";};Object.defineProperty(r.prototype,"isStandalone",{get:function(){return false;},enumerable:true,configurable:true});Object.defineProperty(r.prototype,"isInline",{get:function(){return true;},enumerable:true,configurable:true});return r;}(B));a.TextRun=r;var R=(function(b){c(R,b);function R(){var d=b!==null&&b.apply(this,arguments)||this;d._inlines=[];return d;}R.prototype.internalAddInline=function(i,d){if(d===void 0){d=false;}if(!i.isInline){throw new Error("RichTextBlock.addInline: the specified card element cannot be used as a RichTextBlock inline.");}var e=i.parent==null||d;if(!e&&i.parent!=this){throw new Error("RichTextBlock.addInline: the specified inline already belongs to another RichTextBlock.");}else{i.setParent(this);this._inlines.push(i);}};R.prototype.internalRender=function(){if(this._inlines.length>0){var e=document.createElement("div");e.className=this.hostConfig.makeCssClassName("ac-richTextBlock");var p=this.getParentContainer();var i=p?p.isRtl():false;switch(this.horizontalAlignment){case E.HorizontalAlignment.Center:e.style.textAlign="center";break;case E.HorizontalAlignment.Right:e.style.textAlign=i?"left":"right";break;default:e.style.textAlign=i?"right":"left";break;}for(var d=0,_a=this._inlines;d<_a.length;d++){var y1=_a[d];e.appendChild(y1.render());}return e;}else{return null;}};R.prototype.asString=function(){var d="";for(var e=0,i=this._inlines;e<i.length;e++){var p=i[e];d+=p.asString();}return d;};R.prototype.parse=function(d,e){b.prototype.parse.call(this,d,e);this._inlines=[];if(Array.isArray(d["inlines"])){for(var i=0,p=d["inlines"];i<p.length;i++){var y1=p[i];var z1=void 0;if(typeof y1==="string"){var A1=new r();A1.text=y1;z1=A1;}else{z1=k(this,y1,false,e);}if(z1){this.internalAddInline(z1,true);}}}};R.prototype.toJSON=function(){var d=b.prototype.toJSON.call(this);if(this._inlines.length>0){var e=[];for(var i=0,p=this._inlines;i<p.length;i++){var y1=p[i];e.push(y1.toJSON());}U.setProperty(d,"inlines",e);}return d;};R.prototype.getJsonTypeName=function(){return"RichTextBlock";};R.prototype.getInlineCount=function(){return this._inlines.length;};R.prototype.getInlineAt=function(i){if(i>=0&&i<this._inlines.length){return this._inlines[i];}else{throw new Error("RichTextBlock.getInlineAt: Index out of range ("+i+")");}};R.prototype.addInline=function(i){this.internalAddInline(i);};R.prototype.removeInline=function(i){var d=this._inlines.indexOf(i);if(d>=0){this._inlines[d].setParent(null);this._inlines.splice(d,1);return true;}return false;};return R;}(o));a.RichTextBlock=R;var F=(function(b){c(F,b);function F(d,e){if(d===void 0){d=undefined;}if(e===void 0){e=undefined;}var i=b.call(this)||this;i.name=d;i.value=e;return i;}F.prototype.parse=function(d){b.prototype.parse.call(this,d);this.name=U.getStringValue(d["title"]);this.value=U.getStringValue(d["value"]);};F.prototype.toJSON=function(){var d=b.prototype.toJSON.call(this);U.setProperty(d,"title",this.name);U.setProperty(d,"value",this.value);return d;};return F;}(l));a.Fact=F;var s=(function(b){c(s,b);function s(){var d=b!==null&&b.apply(this,arguments)||this;d.facts=[];return d;}Object.defineProperty(s.prototype,"useDefaultSizing",{get:function(){return false;},enumerable:true,configurable:true});s.prototype.internalRender=function(){var e=null;var d=this.hostConfig;if(this.facts.length>0){e=document.createElement("table");e.style.borderWidth="0px";e.style.borderSpacing="0px";e.style.borderStyle="none";e.style.borderCollapse="collapse";e.style.display="block";e.style.overflow="hidden";e.classList.add(d.makeCssClassName("ac-factset"));for(var i=0;i<this.facts.length;i++){var p=document.createElement("tr");if(i>0){p.style.marginTop=d.factSet.spacing+"px";}var y1=document.createElement("td");y1.style.padding="0";y1.classList.add(d.makeCssClassName("ac-fact-title"));if(d.factSet.title.maxWidth){y1.style.maxWidth=d.factSet.title.maxWidth+"px";}y1.style.verticalAlign="top";var z1=new q();z1.setParent(this);z1.text=U.isNullOrEmpty(this.facts[i].name)?"Title":this.facts[i].name;z1.size=d.factSet.title.size;z1.color=d.factSet.title.color;z1.isSubtle=d.factSet.title.isSubtle;z1.weight=d.factSet.title.weight;z1.wrap=d.factSet.title.wrap;z1.spacing=E.Spacing.None;U.appendChild(y1,z1.render());U.appendChild(p,y1);y1=document.createElement("td");y1.style.width="10px";U.appendChild(p,y1);y1=document.createElement("td");y1.style.padding="0";y1.style.verticalAlign="top";y1.classList.add(d.makeCssClassName("ac-fact-value"));z1=new q();z1.setParent(this);z1.text=this.facts[i].value;z1.size=d.factSet.value.size;z1.color=d.factSet.value.color;z1.isSubtle=d.factSet.value.isSubtle;z1.weight=d.factSet.value.weight;z1.wrap=d.factSet.value.wrap;z1.spacing=E.Spacing.None;U.appendChild(y1,z1.render());U.appendChild(p,y1);U.appendChild(e,p);}}return e;};s.prototype.getJsonTypeName=function(){return"FactSet";};s.prototype.toJSON=function(){var d=b.prototype.toJSON.call(this);U.setArrayProperty(d,"facts",this.facts);return d;};s.prototype.parse=function(d,e){b.prototype.parse.call(this,d,e);this.facts=[];var i=d["facts"];if(Array.isArray(i)){for(var p=0,y1=i;p<y1.length;p++){var z1=y1[p];var A1=new F();A1.parse(z1);this.facts.push(A1);}}};return s;}(o));a.FactSet=s;var t=(function(b){c(t,b);function t(){var d=b!==null&&b.apply(this,arguments)||this;d.style=E.ImageStyle.Default;d.size=E.Size.Auto;d.pixelWidth=null;d.pixelHeight=null;d.altText="";return d;}t.prototype.parseDimension=function(d,e,i){if(e){if(typeof e==="string"){try{var p=S.SizeAndUnit.parse(e);if(p.unit==E.SizeUnit.Pixel){return p.physicalSize;}}catch(_a){}}q1({error:E.ValidationError.InvalidPropertyValue,message:"Invalid image "+d+": "+e},i);}return 0;};t.prototype.applySize=function(e){if(this.pixelWidth||this.pixelHeight){if(this.pixelWidth){e.style.width=this.pixelWidth+"px";}if(this.pixelHeight){e.style.height=this.pixelHeight+"px";}}else{switch(this.size){case E.Size.Stretch:e.style.width="100%";break;case E.Size.Auto:e.style.maxWidth="100%";break;case E.Size.Small:e.style.width=this.hostConfig.imageSizes.small+"px";break;case E.Size.Large:e.style.width=this.hostConfig.imageSizes.large+"px";break;case E.Size.Medium:e.style.width=this.hostConfig.imageSizes.medium+"px";break;}}};Object.defineProperty(t.prototype,"useDefaultSizing",{get:function(){return false;},enumerable:true,configurable:true});t.prototype.internalRender=function(){var d=this;var i=null;if(!U.isNullOrEmpty(this.url)){i=document.createElement("div");i.style.display="flex";i.style.alignItems="flex-start";i.onkeypress=function(e){if(d.selectAction&&(e.keyCode==13||e.keyCode==32)){e.preventDefault();e.cancelBubble=true;d.selectAction.execute();}};i.onclick=function(e){if(d.selectAction){e.preventDefault();e.cancelBubble=true;d.selectAction.execute();}};switch(this.horizontalAlignment){case E.HorizontalAlignment.Center:i.style.justifyContent="center";break;case E.HorizontalAlignment.Right:i.style.justifyContent="flex-end";break;default:i.style.justifyContent="flex-start";break;}var p=this.hostConfig;var y1=document.createElement("img");y1.onload=function(e){i1(d);};y1.onerror=function(e){var z1=d.getRootElement();d.renderedElement.innerHTML="";if(z1&&z1.designMode){var A1=document.createElement("div");A1.style.display="flex";A1.style.alignItems="center";A1.style.justifyContent="center";A1.style.backgroundColor="#EEEEEE";A1.style.color="black";A1.innerText=":-(";A1.style.padding="10px";d.applySize(A1);d.renderedElement.appendChild(A1);}i1(d);};y1.style.maxHeight="100%";y1.style.minWidth="0";y1.classList.add(p.makeCssClassName("ac-image"));if(this.selectAction!=null&&p.supportsInteractivity){y1.tabIndex=0;y1.setAttribute("role","button");y1.setAttribute("aria-label",this.selectAction.title);y1.classList.add(p.makeCssClassName("ac-selectable"));}this.applySize(y1);if(this.style===E.ImageStyle.Person){y1.style.borderRadius="50%";y1.style.backgroundPosition="50% 50%";y1.style.backgroundRepeat="no-repeat";}if(!U.isNullOrEmpty(this.backgroundColor)){y1.style.backgroundColor=U.stringToCssColor(this.backgroundColor);}y1.src=this.url;y1.alt=this.altText;i.appendChild(y1);}return i;};t.prototype.toJSON=function(){var d=b.prototype.toJSON.call(this);if(this._selectAction){U.setProperty(d,"selectAction",this._selectAction.toJSON());}U.setEnumProperty(E.ImageStyle,d,"style",this.style,E.ImageStyle.Default);U.setProperty(d,"backgroundColor",this.backgroundColor);U.setProperty(d,"url",this.url);U.setEnumProperty(E.Size,d,"size",this.size,E.Size.Auto);if(this.pixelWidth){U.setProperty(d,"width",this.pixelWidth+"px");}if(this.pixelHeight){U.setProperty(d,"height",this.pixelHeight+"px");}U.setProperty(d,"altText",this.altText);return d;};t.prototype.getJsonTypeName=function(){return"Image";};t.prototype.getActionById=function(i){var d=b.prototype.getActionById.call(this,i);if(!d&&this.selectAction){d=this.selectAction.getActionById(i);}return d;};t.prototype.parse=function(d,e){b.prototype.parse.call(this,d,e);this.url=U.getStringValue(d["url"]);this.backgroundColor=U.getStringValue(d["backgroundColor"]);var i=U.getStringValue(d["style"]);if(i&&i.toLowerCase()==="normal"){this.style=E.ImageStyle.Default;q1({error:E.ValidationError.Deprecated,message:"The Image.style value \"normal\" is deprecated and will be removed. Use \"default\" instead."},e);}else{this.style=U.getEnumValue(E.ImageStyle,i,this.style);}this.size=U.getEnumValue(E.Size,d["size"],this.size);this.altText=U.getStringValue(d["altText"]);if(d["pixelWidth"]&&typeof d["pixelWidth"]==="number"){this.pixelWidth=d["pixelWidth"];q1({error:E.ValidationError.Deprecated,message:"The pixelWidth property is deprecated and will be removed. Use the width property instead."},e);}if(d["pixelHeight"]&&typeof d["pixelHeight"]==="number"){this.pixelHeight=d["pixelHeight"];q1({error:E.ValidationError.Deprecated,message:"The pixelHeight property is deprecated and will be removed. Use the height property instead."},e);}var p=this.parseDimension("width",d["width"],e);if(p>0){this.pixelWidth=p;}p=this.parseDimension("height",d["height"],e);if(p>0){this.pixelHeight=p;}this.selectAction=j(this,d["selectAction"],[a1.JsonTypeName],!this.isDesignMode(),e);};t.prototype.getResourceInformation=function(){if(!U.isNullOrEmpty(this.url)){return[{url:this.url,mimeType:"image"}];}else{return[];}};Object.defineProperty(t.prototype,"selectAction",{get:function(){return this._selectAction;},set:function(d){this._selectAction=d;if(this._selectAction){this._selectAction.setParent(this);}},enumerable:true,configurable:true});return t;}(o));a.Image=t;var u=(function(b){c(u,b);function u(){var d=b!==null&&b.apply(this,arguments)||this;d._selectAction=null;d.allowVerticalOverflow=false;return d;}u.prototype.isElementAllowed=function(e,d){if(!this.hostConfig.supportsInteractivity&&e.isInteractive){return false;}if(d){for(var i=0,p=d;i<p.length;i++){var y1=p[i];if(e.getJsonTypeName()===y1){return false;}}}return true;};u.prototype.applyPadding=function(){b.prototype.applyPadding.call(this);if(!this.renderedElement){return;}var p=new S.SpacingDefinition();if(this.getEffectivePadding()){p=this.hostConfig.paddingDefinitionToSpacingDefinition(this.getEffectivePadding());}this.renderedElement.style.paddingTop=p.top+"px";this.renderedElement.style.paddingRight=p.right+"px";this.renderedElement.style.paddingBottom=p.bottom+"px";this.renderedElement.style.paddingLeft=p.left+"px";this.renderedElement.style.marginRight="0";this.renderedElement.style.marginLeft="0";};u.prototype.getSelectAction=function(){return this._selectAction;};u.prototype.setSelectAction=function(d){this._selectAction=d;if(this._selectAction){this._selectAction.setParent(this);}};Object.defineProperty(u.prototype,"isSelectable",{get:function(){return false;},enumerable:true,configurable:true});u.prototype.parse=function(d,e){b.prototype.parse.call(this,d,e);if(this.isSelectable){this._selectAction=j(this,d["selectAction"],[a1.JsonTypeName],!this.isDesignMode(),e);}};u.prototype.toJSON=function(){var d=b.prototype.toJSON.call(this);if(this._selectAction&&this.isSelectable){U.setProperty(d,"selectAction",this._selectAction.toJSON());}return d;};u.prototype.internalValidateProperties=function(d){b.prototype.internalValidateProperties.call(this,d);for(var i=0;i<this.getItemCount();i++){var e=this.getItemAt(i);if(!this.hostConfig.supportsInteractivity&&e.isInteractive){d.addFailure(this,{error:E.ValidationError.InteractivityNotAllowed,message:"Interactivity is not allowed."});}if(!this.isElementAllowed(e,this.getForbiddenElementTypes())){d.addFailure(this,{error:E.ValidationError.InteractivityNotAllowed,message:"Elements of type "+e.getJsonTypeName()+" are not allowed in this container."});}e.internalValidateProperties(d);}if(this._selectAction){this._selectAction.internalValidateProperties(d);}};u.prototype.render=function(){var d=this;var i=b.prototype.render.call(this);var p=this.hostConfig;if(this.allowVerticalOverflow){i.style.overflowX="hidden";i.style.overflowY="auto";}if(i&&this.isSelectable&&this._selectAction&&p.supportsInteractivity){i.classList.add(p.makeCssClassName("ac-selectable"));i.tabIndex=0;i.setAttribute("role","button");i.setAttribute("aria-label",this._selectAction.title);i.onclick=function(e){if(d._selectAction!=null){e.preventDefault();e.cancelBubble=true;d._selectAction.execute();}};i.onkeypress=function(e){if(d._selectAction!=null&&(e.keyCode==13||e.keyCode==32)){e.preventDefault();e.cancelBubble=true;d._selectAction.execute();}};}return i;};u.prototype.updateLayout=function(p){if(p===void 0){p=true;}b.prototype.updateLayout.call(this,p);if(p){for(var i=0;i<this.getItemCount();i++){this.getItemAt(i).updateLayout();}}};u.prototype.getAllInputs=function(){var d=[];for(var i=0;i<this.getItemCount();i++){d=d.concat(this.getItemAt(i).getAllInputs());}return d;};u.prototype.getResourceInformation=function(){var d=[];for(var i=0;i<this.getItemCount();i++){d=d.concat(this.getItemAt(i).getResourceInformation());}return d;};u.prototype.getElementById=function(d){var e=b.prototype.getElementById.call(this,d);if(!e){for(var i=0;i<this.getItemCount();i++){e=this.getItemAt(i).getElementById(d);if(e){break;}}}return e;};return u;}(o));a.CardElementContainer=u;var v=(function(b){c(v,b);function v(){var d=b!==null&&b.apply(this,arguments)||this;d._images=[];d.imageSize=E.Size.Medium;return d;}v.prototype.internalRender=function(){var e=null;if(this._images.length>0){e=document.createElement("div");e.style.display="flex";e.style.flexWrap="wrap";for(var i=0;i<this._images.length;i++){this._images[i].size=this.imageSize;var d=this._images[i].render();d.style.display="inline-flex";d.style.margin="0px";d.style.marginRight="10px";d.style.maxHeight=this.hostConfig.imageSet.maxImageHeight+"px";U.appendChild(e,d);}}return e;};v.prototype.getItemCount=function(){return this._images.length;};v.prototype.getItemAt=function(i){return this._images[i];};v.prototype.getFirstVisibleRenderedItem=function(){return this._images&&this._images.length>0?this._images[0]:null;};v.prototype.getLastVisibleRenderedItem=function(){return this._images&&this._images.length>0?this._images[this._images.length-1]:null;};v.prototype.removeItem=function(i){if(i instanceof t){var d=this._images.indexOf(i);if(d>=0){this._images.splice(d,1);i.setParent(null);this.updateLayout();return true;}}return false;};v.prototype.getJsonTypeName=function(){return"ImageSet";};v.prototype.toJSON=function(){var d=b.prototype.toJSON.call(this);U.setEnumProperty(E.Size,d,"imageSize",this.imageSize,E.Size.Medium);if(this._images.length>0){var i=[];for(var e=0,p=this._images;e<p.length;e++){var y1=p[e];i.push(y1.toJSON());}U.setProperty(d,"images",i);}return d;};v.prototype.parse=function(d,e){b.prototype.parse.call(this,d,e);this.imageSize=U.getEnumValue(E.Size,d["imageSize"],E.Size.Medium);if(d["images"]!=null){var p=d["images"];this._images=[];for(var i=0;i<p.length;i++){var y1=new t();y1.parse(p[i],e);this.addImage(y1);}}};v.prototype.addImage=function(i){if(!i.parent){this._images.push(i);i.setParent(this);}else{throw new Error("This image already belongs to another ImageSet");}};v.prototype.indexOf=function(d){return d instanceof t?this._images.indexOf(d):-1;};return v;}(u));a.ImageSet=v;var M=(function(b){c(M,b);function M(d,e){if(d===void 0){d=undefined;}if(e===void 0){e=undefined;}var i=b.call(this)||this;i.url=d;i.mimeType=e;return i;}M.prototype.parse=function(d,e){b.prototype.parse.call(this,d,e);this.mimeType=U.getStringValue(d["mimeType"]);this.url=U.getStringValue(d["url"]);};M.prototype.toJSON=function(){var d=b.prototype.toJSON.call(this);U.setProperty(d,"mimeType",this.mimeType);U.setProperty(d,"url",this.url);return d;};return M;}(l));a.MediaSource=M;var w=(function(b){c(w,b);function w(){var d=b!==null&&b.apply(this,arguments)||this;d.sources=[];return d;}w.prototype.getPosterUrl=function(){return this.poster?this.poster:this.hostConfig.media.defaultPoster;};w.prototype.processSources=function(){this._selectedSources=[];this._selectedMediaType=undefined;for(var d=0,e=this.sources;d<e.length;d++){var i=e[d];var p=i.mimeType?i.mimeType.split('/'):[];if(p.length==2){if(!this._selectedMediaType){var y1=w.supportedMediaTypes.indexOf(p[0]);if(y1>=0){this._selectedMediaType=w.supportedMediaTypes[y1];}}if(p[0]==this._selectedMediaType){this._selectedSources.push(i);}}}};w.prototype.renderPoster=function(){var d=this;var p=12;var i=15;var y1=document.createElement("div");y1.className=this.hostConfig.makeCssClassName("ac-media-poster");y1.setAttribute("role","contentinfo");y1.setAttribute("aria-label",this.altText?this.altText:"Media content");y1.style.position="relative";y1.style.display="flex";var z1=this.getPosterUrl();if(z1){var A1=document.createElement("img");A1.style.width="100%";A1.style.height="100%";A1.onerror=function(e){A1.parentNode.removeChild(A1);y1.classList.add("empty");y1.style.minHeight="150px";};A1.src=z1;y1.appendChild(A1);}else{y1.classList.add("empty");y1.style.minHeight="150px";}if(this.hostConfig.supportsInteractivity&&this._selectedSources.length>0){var B1=document.createElement("div");B1.setAttribute("role","button");B1.setAttribute("aria-label","Play media");B1.className=this.hostConfig.makeCssClassName("ac-media-playButton");B1.style.display="flex";B1.style.alignItems="center";B1.style.justifyContent="center";B1.onclick=function(e){if(d.hostConfig.media.allowInlinePlayback){e.preventDefault();e.cancelBubble=true;var E1=d.renderMediaPlayer();d.renderedElement.innerHTML="";d.renderedElement.appendChild(E1);E1.play();}else{if(w.onPlay){e.preventDefault();e.cancelBubble=true;w.onPlay(d);}}};var C1=document.createElement("div");C1.className=this.hostConfig.makeCssClassName("ac-media-playButton-arrow");C1.style.width=p+"px";C1.style.height=i+"px";C1.style.borderTopWidth=(i/2)+"px";C1.style.borderBottomWidth=(i/2)+"px";C1.style.borderLeftWidth=p+"px";C1.style.borderRightWidth="0";C1.style.borderStyle="solid";C1.style.borderTopColor="transparent";C1.style.borderRightColor="transparent";C1.style.borderBottomColor="transparent";C1.style.transform="translate("+(p/10)+"px,0px)";B1.appendChild(C1);var D1=document.createElement("div");D1.style.position="absolute";D1.style.left="0";D1.style.top="0";D1.style.width="100%";D1.style.height="100%";D1.style.display="flex";D1.style.justifyContent="center";D1.style.alignItems="center";D1.appendChild(B1);y1.appendChild(D1);}return y1;};w.prototype.renderMediaPlayer=function(){var d;if(this._selectedMediaType=="video"){var e=document.createElement("video");var p=this.getPosterUrl();if(p){e.poster=p;}d=e;}else{d=document.createElement("audio");}d.controls=true;d.preload="none";d.style.width="100%";for(var i=0,_a=this.sources;i<_a.length;i++){var y1=_a[i];var z1=document.createElement("source");z1.src=y1.url;z1.type=y1.mimeType;d.appendChild(z1);}return d;};w.prototype.internalRender=function(){var e=document.createElement("div");e.className=this.hostConfig.makeCssClassName("ac-media");this.processSources();e.appendChild(this.renderPoster());return e;};w.prototype.parse=function(d,e){b.prototype.parse.call(this,d,e);this.poster=U.getStringValue(d["poster"]);this.altText=U.getStringValue(d["altText"]);this.sources=[];if(Array.isArray(d["sources"])){for(var i=0,p=d["sources"];i<p.length;i++){var y1=p[i];var z1=new M();z1.parse(y1,e);this.sources.push(z1);}}};w.prototype.toJSON=function(){var d=b.prototype.toJSON.call(this);U.setProperty(d,"poster",this.poster);U.setProperty(d,"altText",this.altText);U.setArrayProperty(d,"sources",this.sources);return d;};w.prototype.getJsonTypeName=function(){return"Media";};w.prototype.getResourceInformation=function(){var d=[];var p=this.getPosterUrl();if(!U.isNullOrEmpty(p)){d.push({url:p,mimeType:"image"});}for(var e=0,i=this.sources;e<i.length;e++){var y1=i[e];if(!U.isNullOrEmpty(y1.url)){d.push({url:y1.url,mimeType:y1.mimeType});}}return d;};Object.defineProperty(w.prototype,"selectedMediaType",{get:function(){return this._selectedMediaType;},enumerable:true,configurable:true});w.supportedMediaTypes=["audio","video"];return w;}(o));a.Media=w;var x=(function(b){c(x,b);function x(){var d=b!==null&&b.apply(this,arguments)||this;d.necessity=E.InputValidationNecessity.Optional;d.errorMessage=undefined;return d;}x.prototype.parse=function(d){b.prototype.parse.call(this,d);this.necessity=U.getEnumValue(E.InputValidationNecessity,d["necessity"],this.necessity);this.errorMessage=U.getStringValue(d["errorMessage"]);};x.prototype.toJSON=function(){if(this.necessity!=E.InputValidationNecessity.Optional||!U.isNullOrEmpty(this.errorMessage)){var d=b.prototype.toJSON.call(this);U.setEnumProperty(E.InputValidationNecessity,d,"necessity",this.necessity,E.InputValidationNecessity.Optional);U.setProperty(d,"errorMessage",this.errorMessage);return d;}else{return null;}};return x;}(l));a.InputValidationOptions=x;var y=(function(b){c(y,b);function y(){var d=b!==null&&b.apply(this,arguments)||this;d.validation=new x();return d;}Object.defineProperty(y.prototype,"isNullable",{get:function(){return true;},enumerable:true,configurable:true});Object.defineProperty(y.prototype,"renderedInputControlElement",{get:function(){return this._renderedInputControlElement;},enumerable:true,configurable:true});Object.defineProperty(y.prototype,"inputControlContainerElement",{get:function(){return this._inputControlContainerElement;},enumerable:true,configurable:true});y.prototype.overrideInternalRender=function(){var d=this.hostConfig;this._outerContainerElement=document.createElement("div");this._outerContainerElement.style.display="flex";this._outerContainerElement.style.flexDirection="column";this._inputControlContainerElement=document.createElement("div");this._inputControlContainerElement.className=d.makeCssClassName("ac-input-container");this._inputControlContainerElement.style.display="flex";this._renderedInputControlElement=this.internalRender();this._renderedInputControlElement.style.minWidth="0px";if(v1.useBuiltInInputValidation&&this.isNullable&&this.validation.necessity==E.InputValidationNecessity.RequiredWithVisualCue){this._renderedInputControlElement.classList.add(d.makeCssClassName("ac-input-required"));}this._inputControlContainerElement.appendChild(this._renderedInputControlElement);this._outerContainerElement.appendChild(this._inputControlContainerElement);return this._outerContainerElement;};y.prototype.valueChanged=function(){this.resetValidationFailureCue();if(this.onValueChanged){this.onValueChanged(this);}m1(this);};y.prototype.resetValidationFailureCue=function(){if(v1.useBuiltInInputValidation&&this.renderedElement){this._renderedInputControlElement.classList.remove(this.hostConfig.makeCssClassName("ac-input-validation-failed"));if(this._errorMessageElement){this._outerContainerElement.removeChild(this._errorMessageElement);this._errorMessageElement=null;}}};y.prototype.showValidationErrorMessage=function(){if(this.renderedElement&&v1.useBuiltInInputValidation&&v1.displayInputValidationErrors&&!U.isNullOrEmpty(this.validation.errorMessage)){this._errorMessageElement=document.createElement("span");this._errorMessageElement.className=this.hostConfig.makeCssClassName("ac-input-validation-error-message");this._errorMessageElement.textContent=this.validation.errorMessage;this._outerContainerElement.appendChild(this._errorMessageElement);}};y.prototype.parseInputValue=function(d){return d;};y.prototype.toJSON=function(){var d=b.prototype.toJSON.call(this);U.setProperty(d,"title",this.title);U.setProperty(d,"value",this.renderedElement&&!U.isNullOrEmpty(this.value)?this.value:this.defaultValue);if(v1.useBuiltInInputValidation){U.setProperty(d,"validation",this.validation.toJSON());}return d;};y.prototype.internalValidateProperties=function(d){b.prototype.internalValidateProperties.call(this,d);if(U.isNullOrEmpty(this.id)){d.addFailure(this,{error:E.ValidationError.PropertyCantBeNull,message:"All inputs must have a unique Id"});}};y.prototype.validateValue=function(){if(v1.useBuiltInInputValidation){this.resetValidationFailureCue();var d=this.validation.necessity!=E.InputValidationNecessity.Optional?!U.isNullOrEmpty(this.value):true;if(!d&&this.renderedElement){this._renderedInputControlElement.classList.add(this.hostConfig.makeCssClassName("ac-input-validation-failed"));this.showValidationErrorMessage();}return d;}else{return true;}};y.prototype.parse=function(d,e){b.prototype.parse.call(this,d,e);this.id=U.getStringValue(d["id"]);this.defaultValue=U.getStringValue(d["value"]);if(v1.useBuiltInInputValidation){var i=d["validation"];if(i){this.validation.parse(i);}}};y.prototype.getAllInputs=function(){return[this];};Object.defineProperty(y.prototype,"defaultValue",{get:function(){return this._defaultValue;},set:function(d){this._defaultValue=this.parseInputValue(d);},enumerable:true,configurable:true});Object.defineProperty(y.prototype,"isInteractive",{get:function(){return true;},enumerable:true,configurable:true});return y;}(o));a.Input=y;var z=(function(b){c(z,b);function z(){var d=b!==null&&b.apply(this,arguments)||this;d.isMultiline=false;d.style=E.InputTextStyle.Text;return d;}z.prototype.internalRender=function(){var d=this;if(this.isMultiline){var i=document.createElement("textarea");i.className=this.hostConfig.makeCssClassName("ac-input","ac-textInput","ac-multiline");i.style.flex="1 1 auto";i.tabIndex=0;if(!U.isNullOrEmpty(this.placeholder)){i.placeholder=this.placeholder;i.setAttribute("aria-label",this.placeholder);}if(!U.isNullOrEmpty(this.defaultValue)){i.value=this.defaultValue;}if(this.maxLength&&this.maxLength>0){i.maxLength=this.maxLength;}i.oninput=function(){d.valueChanged();};i.onkeypress=function(e){if(e.keyCode==10&&d.inlineAction){d.inlineAction.execute();}};return i;}else{var p=document.createElement("input");p.type=E.InputTextStyle[this.style].toLowerCase();p.className=this.hostConfig.makeCssClassName("ac-input","ac-textInput");p.style.flex="1 1 auto";p.tabIndex=0;if(!U.isNullOrEmpty(this.placeholder)){p.placeholder=this.placeholder;p.setAttribute("aria-label",this.placeholder);}if(!U.isNullOrEmpty(this.defaultValue)){p.value=this.defaultValue;}if(this.maxLength&&this.maxLength>0){p.maxLength=this.maxLength;}p.oninput=function(){d.valueChanged();};p.onkeypress=function(e){if(e.keyCode==13&&d.inlineAction){d.inlineAction.execute();}};return p;}};z.prototype.overrideInternalRender=function(){var d=this;var i=b.prototype.overrideInternalRender.call(this);if(this.inlineAction){var p=document.createElement("button");p.className=this.hostConfig.makeCssClassName("ac-inlineActionButton");p.onclick=function(e){e.preventDefault();e.cancelBubble=true;d.inlineAction.execute();};if(!U.isNullOrEmpty(this.inlineAction.iconUrl)){p.classList.add("iconOnly");var y1=document.createElement("img");y1.style.height="100%";y1.style.display="none";y1.onload=function(){y1.style.removeProperty("display");};y1.onerror=function(){p.removeChild(y1);p.classList.remove("iconOnly");p.classList.add("textOnly");p.textContent=!U.isNullOrEmpty(d.inlineAction.title)?d.inlineAction.title:"Title";};y1.src=this.inlineAction.iconUrl;p.appendChild(y1);if(!U.isNullOrEmpty(this.inlineAction.title)){p.title=this.inlineAction.title;}}else{p.classList.add("textOnly");p.textContent=!U.isNullOrEmpty(this.inlineAction.title)?this.inlineAction.title:"Title";}p.style.marginLeft="8px";this.inputControlContainerElement.appendChild(p);}return i;};z.prototype.getJsonTypeName=function(){return"Input.Text";};z.prototype.getActionById=function(i){var d=b.prototype.getActionById.call(this,i);if(!d&&this.inlineAction){d=this.inlineAction.getActionById(i);}return d;};z.prototype.toJSON=function(){var d=b.prototype.toJSON.call(this);U.setProperty(d,"placeholder",this.placeholder);U.setNumberProperty(d,"maxLength",this.maxLength);U.setProperty(d,"isMultiline",this.isMultiline,false);U.setEnumProperty(E.InputTextStyle,d,"style",this.style,E.InputTextStyle.Text);if(this._inlineAction){U.setProperty(d,"inlineAction",this._inlineAction.toJSON());}return d;};z.prototype.parse=function(d,e){b.prototype.parse.call(this,d,e);this.maxLength=U.getNumberValue(d["maxLength"]);this.isMultiline=U.getBoolValue(d["isMultiline"],this.isMultiline);this.placeholder=U.getStringValue(d["placeholder"]);this.style=U.getEnumValue(E.InputTextStyle,d["style"],this.style);this.inlineAction=j(this,d["inlineAction"],[a1.JsonTypeName],!this.isDesignMode(),e);};Object.defineProperty(z.prototype,"inlineAction",{get:function(){return this._inlineAction;},set:function(d){this._inlineAction=d;if(this._inlineAction){this._inlineAction.setParent(this);}},enumerable:true,configurable:true});Object.defineProperty(z.prototype,"value",{get:function(){if(this.renderedInputControlElement){if(this.isMultiline){return this.renderedInputControlElement.value;}else{return this.renderedInputControlElement.value;}}else{return null;}},enumerable:true,configurable:true});return z;}(y));a.TextInput=z;var A=(function(b){c(A,b);function A(){var d=b!==null&&b.apply(this,arguments)||this;d.valueOn="true";d.valueOff="false";d.wrap=false;return d;}A.prototype.internalRender=function(){var d=this;var e=document.createElement("div");e.className=this.hostConfig.makeCssClassName("ac-input","ac-toggleInput");e.style.width="100%";e.style.display="flex";e.style.alignItems="center";this._checkboxInputElement=document.createElement("input");this._checkboxInputElement.id=U.generateUniqueId();this._checkboxInputElement.type="checkbox";this._checkboxInputElement.style.display="inline-block";this._checkboxInputElement.style.verticalAlign="middle";this._checkboxInputElement.style.margin="0";this._checkboxInputElement.style.flex="0 0 auto";this._checkboxInputElement.setAttribute("aria-label",this.title);this._checkboxInputElement.tabIndex=0;if(this.defaultValue==this.valueOn){this._checkboxInputElement.checked=true;}this._checkboxInputElement.onchange=function(){d.valueChanged();};U.appendChild(e,this._checkboxInputElement);if(!U.isNullOrEmpty(this.title)||this.isDesignMode()){var i=new L();i.setParent(this);i.forElementId=this._checkboxInputElement.id;i.hostConfig=this.hostConfig;i.text=U.isNullOrEmpty(this.title)?this.getJsonTypeName():this.title;i.useMarkdown=v1.useMarkdownInRadioButtonAndCheckbox;i.wrap=this.wrap;var p=i.render();p.style.display="inline-block";p.style.flex="1 1 auto";p.style.marginLeft="6px";p.style.verticalAlign="middle";var y1=document.createElement("div");y1.style.width="6px";U.appendChild(e,y1);U.appendChild(e,p);}return e;};Object.defineProperty(A.prototype,"isNullable",{get:function(){return false;},enumerable:true,configurable:true});A.prototype.getJsonTypeName=function(){return"Input.Toggle";};A.prototype.toJSON=function(){var d=b.prototype.toJSON.call(this);U.setProperty(d,"valueOn",this.valueOn,"true");U.setProperty(d,"valueOff",this.valueOff,"false");U.setProperty(d,"wrap",this.wrap);return d;};A.prototype.parse=function(d,e){b.prototype.parse.call(this,d,e);this.title=U.getStringValue(d["title"]);this.valueOn=U.getStringValue(d["valueOn"],this.valueOn);this.valueOff=U.getStringValue(d["valueOff"],this.valueOff);this.wrap=U.getBoolValue(d["wrap"],this.wrap);};Object.defineProperty(A.prototype,"value",{get:function(){if(this._checkboxInputElement){return this._checkboxInputElement.checked?this.valueOn:this.valueOff;}else{return null;}},enumerable:true,configurable:true});return A;}(y));a.ToggleInput=A;var D=(function(b){c(D,b);function D(d,e){if(d===void 0){d=undefined;}if(e===void 0){e=undefined;}var i=b.call(this)||this;i.title=d;i.value=e;return i;}D.prototype.parse=function(d){b.prototype.parse.call(this,d);this.title=U.getStringValue(d["title"],"");this.value=U.getStringValue(d["value"],"");};D.prototype.toJSON=function(){var d=b.prototype.toJSON.call(this);U.setProperty(d,"title",this.title);U.setProperty(d,"value",this.value);return d;};return D;}(l));a.Choice=D;var G=(function(b){c(G,b);function G(){var d=b!==null&&b.apply(this,arguments)||this;d.choices=[];d.isCompact=false;d.isMultiSelect=false;d.wrap=false;return d;}G.getUniqueCategoryName=function(){var d="__ac-category"+G.uniqueCategoryCounter;G.uniqueCategoryCounter++;return d;};G.prototype.internalRender=function(){var d=this;if(!this.isMultiSelect){if(this.isCompact){this._selectElement=document.createElement("select");this._selectElement.className=this.hostConfig.makeCssClassName("ac-input","ac-multichoiceInput","ac-choiceSetInput-compact");this._selectElement.style.width="100%";var e=document.createElement("option");e.selected=true;e.disabled=true;e.hidden=true;e.value="";if(this.placeholder){e.text=this.placeholder;}U.appendChild(this._selectElement,e);for(var i=0;i<this.choices.length;i++){var p=document.createElement("option");p.value=this.choices[i].value;p.text=this.choices[i].title;p.setAttribute("aria-label",this.choices[i].title);if(this.choices[i].value==this.defaultValue){p.selected=true;}U.appendChild(this._selectElement,p);}this._selectElement.onchange=function(){d.valueChanged();};return this._selectElement;}else{var y1=G.getUniqueCategoryName();var z1=document.createElement("div");z1.className=this.hostConfig.makeCssClassName("ac-input","ac-choiceSetInput-expanded");z1.style.width="100%";this._toggleInputs=[];for(var A1=0;A1<this.choices.length;A1++){var B1=document.createElement("input");B1.id=U.generateUniqueId();B1.type="radio";B1.style.margin="0";B1.style.display="inline-block";B1.style.verticalAlign="middle";B1.name=U.isNullOrEmpty(this.id)?y1:this.id;B1.value=this.choices[A1].value;B1.style.flex="0 0 auto";B1.setAttribute("aria-label",this.choices[A1].title);if(this.choices[A1].value==this.defaultValue){B1.checked=true;}B1.onchange=function(){d.valueChanged();};this._toggleInputs.push(B1);var C1=new L();C1.setParent(this);C1.forElementId=B1.id;C1.hostConfig=this.hostConfig;C1.text=U.isNullOrEmpty(this.choices[A1].title)?"Choice "+A1:this.choices[A1].title;C1.useMarkdown=v1.useMarkdownInRadioButtonAndCheckbox;C1.wrap=this.wrap;var D1=C1.render();D1.style.display="inline-block";D1.style.flex="1 1 auto";D1.style.marginLeft="6px";D1.style.verticalAlign="middle";var E1=document.createElement("div");E1.style.width="6px";var F1=document.createElement("div");F1.style.display="flex";F1.style.alignItems="center";U.appendChild(F1,B1);U.appendChild(F1,E1);U.appendChild(F1,D1);U.appendChild(z1,F1);}return z1;}}else{var G1=this.defaultValue?this.defaultValue.split(this.hostConfig.choiceSetInputValueSeparator):null;var z1=document.createElement("div");z1.className=this.hostConfig.makeCssClassName("ac-input","ac-choiceSetInput-multiSelect");z1.style.width="100%";this._toggleInputs=[];for(var H1=0;H1<this.choices.length;H1++){var I1=document.createElement("input");I1.id=U.generateUniqueId();I1.type="checkbox";I1.style.margin="0";I1.style.display="inline-block";I1.style.verticalAlign="middle";I1.value=this.choices[H1].value;I1.style.flex="0 0 auto";I1.setAttribute("aria-label",this.choices[H1].title);if(G1){if(G1.indexOf(this.choices[H1].value)>=0){I1.checked=true;}}I1.onchange=function(){d.valueChanged();};this._toggleInputs.push(I1);var C1=new L();C1.setParent(this);C1.forElementId=I1.id;C1.hostConfig=this.hostConfig;C1.text=U.isNullOrEmpty(this.choices[H1].title)?"Choice "+H1:this.choices[H1].title;C1.useMarkdown=v1.useMarkdownInRadioButtonAndCheckbox;C1.wrap=this.wrap;var D1=C1.render();D1.style.display="inline-block";D1.style.flex="1 1 auto";D1.style.marginLeft="6px";D1.style.verticalAlign="middle";var E1=document.createElement("div");E1.style.width="6px";var F1=document.createElement("div");F1.style.display="flex";F1.style.alignItems="center";U.appendChild(F1,I1);U.appendChild(F1,E1);U.appendChild(F1,D1);U.appendChild(z1,F1);}return z1;}};G.prototype.getJsonTypeName=function(){return"Input.ChoiceSet";};G.prototype.toJSON=function(){var d=b.prototype.toJSON.call(this);U.setProperty(d,"placeholder",this.placeholder);U.setArrayProperty(d,"choices",this.choices);U.setProperty(d,"style",this.isCompact?null:"expanded");U.setProperty(d,"isMultiSelect",this.isMultiSelect,false);U.setProperty(d,"wrap",this.wrap,false);return d;};G.prototype.internalValidateProperties=function(d){b.prototype.internalValidateProperties.call(this,d);if(this.choices.length==0){d.addFailure(this,{error:E.ValidationError.CollectionCantBeEmpty,message:"An Input.ChoiceSet must have at least one choice defined."});}for(var e=0,i=this.choices;e<i.length;e++){var p=i[e];if(!p.title||!p.value){d.addFailure(this,{error:E.ValidationError.PropertyCantBeNull,message:"All choices in an Input.ChoiceSet must have their title and value properties set."});}}};G.prototype.parse=function(d,e){b.prototype.parse.call(this,d,e);this.isCompact=!(d["style"]==="expanded");this.isMultiSelect=U.getBoolValue(d["isMultiSelect"],this.isMultiSelect);this.placeholder=U.getStringValue(d["placeholder"]);this.choices=[];if(Array.isArray(d["choices"])){for(var i=0,p=d["choices"];i<p.length;i++){var y1=p[i];var z1=new D();z1.parse(y1);this.choices.push(z1);}}this.wrap=U.getBoolValue(d["wrap"],this.wrap);};Object.defineProperty(G.prototype,"value",{get:function(){if(!this.isMultiSelect){if(this.isCompact){if(this._selectElement){return this._selectElement.selectedIndex>0?this._selectElement.value:null;}return null;}else{if(!this._toggleInputs||this._toggleInputs.length==0){return null;}for(var i=0;i<this._toggleInputs.length;i++){if(this._toggleInputs[i].checked){return this._toggleInputs[i].value;}}return null;}}else{if(!this._toggleInputs||this._toggleInputs.length==0){return null;}var d="";for(var i=0;i<this._toggleInputs.length;i++){if(this._toggleInputs[i].checked){if(d!=""){d+=this.hostConfig.choiceSetInputValueSeparator;}d+=this._toggleInputs[i].value;}}return d==""?null:d;}},enumerable:true,configurable:true});G.uniqueCategoryCounter=0;return G;}(y));a.ChoiceSetInput=G;var N=(function(b){c(N,b);function N(){return b!==null&&b.apply(this,arguments)||this;}N.prototype.internalRender=function(){var d=this;this._numberInputElement=document.createElement("input");this._numberInputElement.setAttribute("type","number");if(this.min){this._numberInputElement.setAttribute("min",this.min.toString());}if(this.max){this._numberInputElement.setAttribute("max",this.max.toString());}this._numberInputElement.className=this.hostConfig.makeCssClassName("ac-input","ac-numberInput");this._numberInputElement.style.width="100%";this._numberInputElement.tabIndex=0;if(!U.isNullOrEmpty(this.defaultValue)){this._numberInputElement.value=this.defaultValue;}if(!U.isNullOrEmpty(this.placeholder)){this._numberInputElement.placeholder=this.placeholder;this._numberInputElement.setAttribute("aria-label",this.placeholder);}this._numberInputElement.oninput=function(){d.valueChanged();};return this._numberInputElement;};N.prototype.getJsonTypeName=function(){return"Input.Number";};N.prototype.toJSON=function(){var d=b.prototype.toJSON.call(this);U.setProperty(d,"placeholder",this.placeholder);U.setNumberProperty(d,"min",this.min);U.setNumberProperty(d,"max",this.max);return d;};N.prototype.parse=function(d,e){b.prototype.parse.call(this,d,e);this.placeholder=U.getStringValue(d["placeholder"]);this.min=U.getNumberValue(d["min"]);this.max=U.getNumberValue(d["max"]);};Object.defineProperty(N.prototype,"min",{get:function(){return this._min;},set:function(d){this._min=d;},enumerable:true,configurable:true});Object.defineProperty(N.prototype,"max",{get:function(){return this._max;},set:function(d){this._max=d;},enumerable:true,configurable:true});Object.defineProperty(N.prototype,"value",{get:function(){return this._numberInputElement?this._numberInputElement.value:undefined;},enumerable:true,configurable:true});Object.defineProperty(N.prototype,"valueAsNumber",{get:function(){return this._numberInputElement?this._numberInputElement.valueAsNumber:undefined;},enumerable:true,configurable:true});return N;}(y));a.NumberInput=N;var J=(function(b){c(J,b);function J(){return b!==null&&b.apply(this,arguments)||this;}J.prototype.internalRender=function(){var d=this;this._dateInputElement=document.createElement("input");this._dateInputElement.setAttribute("type","date");this._dateInputElement.setAttribute("min",this.min);this._dateInputElement.setAttribute("max",this.max);this._dateInputElement.className=this.hostConfig.makeCssClassName("ac-input","ac-dateInput");this._dateInputElement.style.width="100%";this._dateInputElement.oninput=function(){d.valueChanged();};if(!U.isNullOrEmpty(this.defaultValue)){this._dateInputElement.value=this.defaultValue;}return this._dateInputElement;};J.prototype.getJsonTypeName=function(){return"Input.Date";};J.prototype.toJSON=function(){var d=b.prototype.toJSON.call(this);U.setProperty(d,"min",this.min);U.setProperty(d,"max",this.max);return d;};J.prototype.parse=function(d,e){b.prototype.parse.call(this,d,e);this.min=U.getStringValue(d["min"]);this.max=U.getStringValue(d["max"]);};Object.defineProperty(J.prototype,"min",{get:function(){return this._min;},set:function(d){this._min=this.parseInputValue(d);},enumerable:true,configurable:true});Object.defineProperty(J.prototype,"max",{get:function(){return this._max;},set:function(d){this._max=this.parseInputValue(d);},enumerable:true,configurable:true});Object.defineProperty(J.prototype,"value",{get:function(){return this._dateInputElement?this._dateInputElement.value:null;},enumerable:true,configurable:true});return J;}(y));a.DateInput=J;var K=(function(b){c(K,b);function K(){return b!==null&&b.apply(this,arguments)||this;}K.prototype.internalRender=function(){var d=this;this._timeInputElement=document.createElement("input");this._timeInputElement.setAttribute("type","time");this._timeInputElement.setAttribute("min",this.min);this._timeInputElement.setAttribute("max",this.max);this._timeInputElement.className=this.hostConfig.makeCssClassName("ac-input","ac-timeInput");this._timeInputElement.style.width="100%";this._timeInputElement.oninput=function(){d.valueChanged();};if(!U.isNullOrEmpty(this.defaultValue)){this._timeInputElement.value=this.defaultValue;}return this._timeInputElement;};K.prototype.parseInputValue=function(d){if(/^[0-9]{2}:[0-9]{2}$/.test(d)){return d;}else{return null;}};K.prototype.getJsonTypeName=function(){return"Input.Time";};K.prototype.toJSON=function(){var d=b.prototype.toJSON.call(this);U.setProperty(d,"min",this.min);U.setProperty(d,"max",this.max);return d;};K.prototype.parse=function(d,e){b.prototype.parse.call(this,d,e);this.min=U.getStringValue(d["min"]);this.max=U.getStringValue(d["max"]);};Object.defineProperty(K.prototype,"min",{get:function(){return this._min;},set:function(d){this._min=this.parseInputValue(d);},enumerable:true,configurable:true});Object.defineProperty(K.prototype,"max",{get:function(){return this._max;},set:function(d){this._max=this.parseInputValue(d);},enumerable:true,configurable:true});Object.defineProperty(K.prototype,"value",{get:function(){return this._timeInputElement?this._timeInputElement.value:null;},enumerable:true,configurable:true});return K;}(y));a.TimeInput=K;var O;(function(O){O[O["Normal"]=0]="Normal";O[O["Expanded"]=1]="Expanded";O[O["Subdued"]=2]="Subdued";})(O||(O={}));var P=(function(){function P(b,p){this._state=O.Normal;this.onClick=null;this.action=b;this._parentContainerStyle=p;}P.prototype.updateCssStyle=function(){var b,d;var e=this.action.parent.hostConfig;this.action.renderedElement.className=e.makeCssClassName("ac-pushButton");if(!U.isNullOrEmpty(this._parentContainerStyle)){this.action.renderedElement.classList.add("style-"+this._parentContainerStyle);}if(this.action instanceof a1){this.action.renderedElement.classList.add(e.makeCssClassName("expandable"));}this.action.renderedElement.classList.remove(e.makeCssClassName("expanded"));this.action.renderedElement.classList.remove(e.makeCssClassName("subdued"));switch(this._state){case O.Expanded:this.action.renderedElement.classList.add(e.makeCssClassName("expanded"));break;case O.Subdued:this.action.renderedElement.classList.add(e.makeCssClassName("subdued"));break;}if(!U.isNullOrEmpty(this.action.style)){if(this.action.style===E.ActionStyle.Positive){(b=this.action.renderedElement.classList).add.apply(b,e.makeCssClassNames("primary","style-positive"));}else{(d=this.action.renderedElement.classList).add.apply(d,e.makeCssClassNames("style-"+this.action.style.toLowerCase()));}}};P.prototype.render=function(){var b=this;this.action.render();this.action.renderedElement.onclick=function(e){e.preventDefault();e.cancelBubble=true;b.click();};this.updateCssStyle();};P.prototype.click=function(){if(this.onClick!=null){this.onClick(this);}};Object.defineProperty(P.prototype,"state",{get:function(){return this._state;},set:function(b){this._state=b;this.updateCssStyle();},enumerable:true,configurable:true});return P;}());var Q=(function(b){c(Q,b);function Q(){var d=b!==null&&b.apply(this,arguments)||this;d._shouldFallback=false;d._parent=null;d._actionCollection=null;d._renderedElement=null;d.requires=new H.HostCapabilities();d.style=E.ActionStyle.Default;return d;}Q.prototype.setCollection=function(d){this._actionCollection=d;};Q.prototype.addCssClasses=function(e){};Q.prototype.internalGetReferencedInputs=function(d){return{};};Q.prototype.internalPrepareForExecution=function(i){};Q.prototype.internalValidateInputs=function(d){var e=[];if(v1.useBuiltInInputValidation&&!this.ignoreInputValidation){for(var i=0,p=Object.keys(d);i<p.length;i++){var y1=p[i];var z1=d[y1];if(!z1.validateValue()){e.push(z1);}}}return e;};Q.prototype.getHref=function(){return"";};Q.prototype.toJSON=function(){var d=b.prototype.toJSON.call(this);U.setProperty(d,"type",this.getJsonTypeName());U.setProperty(d,"title",this.title);U.setProperty(d,"iconUrl",this.iconUrl);U.setProperty(d,"style",this.style,E.ActionStyle.Default);return d;};Q.prototype.render=function(d){if(d===void 0){d="ac-pushButton";}var e=this.parent.hostConfig;var i=document.createElement("button");this.addCssClasses(i);i.setAttribute("aria-label",this.title);i.type="button";i.style.display="flex";i.style.alignItems="center";i.style.justifyContent="center";var p=!U.isNullOrEmpty(this.title);var y1=document.createElement("div");y1.style.overflow="hidden";y1.style.textOverflow="ellipsis";if(!(e.actions.iconPlacement==E.ActionIconPlacement.AboveTitle||e.actions.allowTitleToWrap)){y1.style.whiteSpace="nowrap";}if(p){y1.innerText=this.title;}if(U.isNullOrEmpty(this.iconUrl)){i.classList.add("noIcon");i.appendChild(y1);}else{var z1=document.createElement("img");z1.src=this.iconUrl;z1.style.width=e.actions.iconSize+"px";z1.style.height=e.actions.iconSize+"px";z1.style.flex="0 0 auto";if(e.actions.iconPlacement==E.ActionIconPlacement.AboveTitle){i.classList.add("iconAbove");i.style.flexDirection="column";if(p){z1.style.marginBottom="4px";}}else{i.classList.add("iconLeft");if(p){z1.style.marginRight="4px";}}i.appendChild(z1);i.appendChild(y1);}this._renderedElement=i;};Q.prototype.setParent=function(d){this._parent=d;};Q.prototype.execute=function(){if(this.onExecute){this.onExecute(this);}k1(this);};Q.prototype.prepareForExecution=function(){var d=this.getReferencedInputs();if(this.internalValidateInputs(d).length>0){return false;}this.internalPrepareForExecution(d);return true;};;Q.prototype.parse=function(d,e){b.prototype.parse.call(this,d,e);p1(this,d,e);this.requires.parse(d["requires"],e);if(!d["title"]&&d["title"]!==""){q1({error:E.ValidationError.PropertyCantBeNull,message:"Actions should always have a title."},e);}this.title=U.getStringValue(d["title"]);this.iconUrl=U.getStringValue(d["iconUrl"]);this.style=U.getStringValue(d["style"],this.style);};Q.prototype.remove=function(){if(this._actionCollection){return this._actionCollection.removeAction(this);}return false;};Q.prototype.getAllInputs=function(){return[];};Q.prototype.getResourceInformation=function(){if(!U.isNullOrEmpty(this.iconUrl)){return[{url:this.iconUrl,mimeType:"image"}];}else{return[];}};Q.prototype.getActionById=function(i){if(this.id==i){return this;}};Q.prototype.getReferencedInputs=function(){return this.internalGetReferencedInputs(this.parent.getRootElement().getAllInputs());};Q.prototype.validateInputs=function(){return this.internalValidateInputs(this.getReferencedInputs());};Q.prototype.shouldFallback=function(){return this._shouldFallback||!this.requires.areAllMet(this.parent.hostConfig.hostCapabilities);};Object.defineProperty(Q.prototype,"isPrimary",{get:function(){return this.style==E.ActionStyle.Positive;},set:function(d){if(d){this.style=E.ActionStyle.Positive;}else{if(this.style==E.ActionStyle.Positive){this.style=E.ActionStyle.Default;}}},enumerable:true,configurable:true});Object.defineProperty(Q.prototype,"ignoreInputValidation",{get:function(){return true;},enumerable:true,configurable:true});Object.defineProperty(Q.prototype,"parent",{get:function(){return this._parent;},enumerable:true,configurable:true});Object.defineProperty(Q.prototype,"renderedElement",{get:function(){return this._renderedElement;},enumerable:true,configurable:true});return Q;}(C));a.Action=Q;var W=(function(b){c(W,b);function W(){var d=b!==null&&b.apply(this,arguments)||this;d._isPrepared=false;d._ignoreInputValidation=false;return d;}W.prototype.internalGetReferencedInputs=function(d){var e={};for(var i=0,p=d;i<p.length;i++){var y1=p[i];e[y1.id]=y1;}return e;};W.prototype.internalPrepareForExecution=function(i){if(this._originalData){this._processedData=JSON.parse(JSON.stringify(this._originalData));}else{this._processedData={};}for(var d=0,e=Object.keys(i);d<e.length;d++){var p=e[d];var y1=i[p];if(y1.value!=null){this._processedData[y1.id]=y1.value;}}this._isPrepared=true;};W.prototype.getJsonTypeName=function(){return W.JsonTypeName;};W.prototype.toJSON=function(){var d=b.prototype.toJSON.call(this);U.setProperty(d,"ignoreInputValidation",this.ignoreInputValidation,false);U.setProperty(d,"data",this._originalData);return d;};W.prototype.parse=function(d,e){b.prototype.parse.call(this,d,e);this._ignoreInputValidation=U.getBoolValue(d["ignoreInputValidation"],this._ignoreInputValidation);this.data=d["data"];};Object.defineProperty(W.prototype,"ignoreInputValidation",{get:function(){return this._ignoreInputValidation;},set:function(d){this._ignoreInputValidation=d;},enumerable:true,configurable:true});Object.defineProperty(W.prototype,"data",{get:function(){return this._isPrepared?this._processedData:this._originalData;},set:function(d){this._originalData=d;this._isPrepared=false;},enumerable:true,configurable:true});W.JsonTypeName="Action.Submit";return W;}(Q));a.SubmitAction=W;var X=(function(b){c(X,b);function X(){return b!==null&&b.apply(this,arguments)||this;}X.prototype.getJsonTypeName=function(){return X.JsonTypeName;};X.prototype.toJSON=function(){var d=b.prototype.toJSON.call(this);U.setProperty(d,"url",this.url);return d;};X.prototype.internalValidateProperties=function(d){b.prototype.internalValidateProperties.call(this,d);if(U.isNullOrEmpty(this.url)){d.addFailure(this,{error:E.ValidationError.PropertyCantBeNull,message:"An Action.OpenUrl must have its url property set."});}};X.prototype.parse=function(d,e){b.prototype.parse.call(this,d,e);this.url=U.getStringValue(d["url"]);};X.prototype.getHref=function(){return this.url;};X.JsonTypeName="Action.OpenUrl";return X;}(Q));a.OpenUrlAction=X;var Y=(function(b){c(Y,b);function Y(){var d=b!==null&&b.apply(this,arguments)||this;d.targetElements={};return d;}Y.prototype.getJsonTypeName=function(){return Y.JsonTypeName;};Y.prototype.execute=function(){for(var d=0,e=Object.keys(this.targetElements);d<e.length;d++){var i=e[d];var p=this.parent.getRootElement().getElementById(i);if(p){if(typeof this.targetElements[i]==="boolean"){p.isVisible=this.targetElements[i];}else{p.isVisible=!p.isVisible;}}}};Y.prototype.parse=function(d){b.prototype.parse.call(this,d);this.targetElements={};var e=d["targetElements"];if(e&&Array.isArray(e)){for(var i=0,p=e;i<p.length;i++){var y1=p[i];if(typeof y1==="string"){this.targetElements[y1]=undefined;}else if(typeof y1==="object"){var z1=y1["elementId"];if(z1&&typeof z1==="string"){this.targetElements[z1]=U.getBoolValue(y1["isVisible"],undefined);}}}}};Y.prototype.toJSON=function(){var d=b.prototype.toJSON.call(this);var e=[];for(var i=0,p=Object.keys(this.targetElements);i<p.length;i++){var id=p[i];if(typeof this.targetElements[id]==="boolean"){e.push({elementId:id,isVisible:this.targetElements[id]});}else{e.push(id);}}d["targetElements"]=e;return d;};Y.prototype.addTargetElement=function(e,i){if(i===void 0){i=undefined;}this.targetElements[e]=i;};Y.prototype.removeTargetElement=function(e){delete this.targetElements[e];};Y.JsonTypeName="Action.ToggleVisibility";return Y;}(Q));a.ToggleVisibilityAction=Y;var Z=(function(b){c(Z,b);function Z(d,e){if(d===void 0){d="";}if(e===void 0){e="";}var i=b.call(this)||this;i._value=new S.StringWithSubstitutions();i.name=d;i.value=e;return i;}Z.prototype.parse=function(d){b.prototype.parse.call(this,d);this.name=U.getStringValue(d["name"]);this.value=U.getStringValue(d["value"]);};Z.prototype.toJSON=function(){var d=b.prototype.toJSON.call(this);U.setProperty(d,"name",this.name);U.setProperty(d,"value",this._value.getOriginal());return d;};Z.prototype.getReferencedInputs=function(i,d){this._value.getReferencedInputs(i,d);};Z.prototype.prepareForExecution=function(i){this._value.substituteInputValues(i,S.ContentTypes.applicationXWwwFormUrlencoded);};Object.defineProperty(Z.prototype,"value",{get:function(){return this._value.get();},set:function(d){this._value.set(d);},enumerable:true,configurable:true});return Z;}(l));a.HttpHeader=Z;var $=(function(b){c($,b);function $(){var d=b!==null&&b.apply(this,arguments)||this;d._url=new S.StringWithSubstitutions();d._body=new S.StringWithSubstitutions();d._headers=[];d._ignoreInputValidation=false;return d;}$.prototype.internalGetReferencedInputs=function(d){var e={};this._url.getReferencedInputs(d,e);for(var i=0,p=this._headers;i<p.length;i++){var y1=p[i];y1.getReferencedInputs(d,e);}this._body.getReferencedInputs(d,e);return e;};$.prototype.internalPrepareForExecution=function(i){this._url.substituteInputValues(i,S.ContentTypes.applicationXWwwFormUrlencoded);var d=S.ContentTypes.applicationJson;for(var e=0,p=this._headers;e<p.length;e++){var y1=p[e];y1.prepareForExecution(i);if(y1.name&&y1.name.toLowerCase()=="content-type"){d=y1.value;}}this._body.substituteInputValues(i,d);};;$.prototype.getJsonTypeName=function(){return $.JsonTypeName;};$.prototype.toJSON=function(){var d=b.prototype.toJSON.call(this);U.setProperty(d,"method",this.method);U.setProperty(d,"url",this._url.getOriginal());U.setProperty(d,"body",this._body.getOriginal());U.setProperty(d,"ignoreInputValidation",this.ignoreInputValidation,false);U.setArrayProperty(d,"headers",this.headers);return d;};$.prototype.internalValidateProperties=function(d){b.prototype.internalValidateProperties.call(this,d);if(U.isNullOrEmpty(this.url)){d.addFailure(this,{error:E.ValidationError.PropertyCantBeNull,message:"An Action.Http must have its url property set."});}if(this.headers.length>0){for(var e=0,i=this.headers;e<i.length;e++){var p=i[e];if(!p.name){d.addFailure(this,{error:E.ValidationError.PropertyCantBeNull,message:"All headers of an Action.Http must have their name and value properties set."});}}}};$.prototype.parse=function(d,e){b.prototype.parse.call(this,d,e);this.url=U.getStringValue(d["url"]);this.method=U.getStringValue(d["method"]);this.body=U.getStringValue(d["body"]);this._ignoreInputValidation=U.getBoolValue(d["ignoreInputValidation"],this._ignoreInputValidation);this._headers=[];if(Array.isArray(d["headers"])){for(var i=0,p=d["headers"];i<p.length;i++){var y1=p[i];var z1=new Z();z1.parse(y1);this.headers.push(z1);}}};Object.defineProperty($.prototype,"ignoreInputValidation",{get:function(){return this._ignoreInputValidation;},set:function(d){this._ignoreInputValidation=d;},enumerable:true,configurable:true});Object.defineProperty($.prototype,"url",{get:function(){return this._url.get();},set:function(d){this._url.set(d);},enumerable:true,configurable:true});Object.defineProperty($.prototype,"body",{get:function(){return this._body.get();},set:function(d){this._body.set(d);},enumerable:true,configurable:true});Object.defineProperty($.prototype,"headers",{get:function(){return this._headers?this._headers:[];},set:function(d){this._headers=d;},enumerable:true,configurable:true});$.JsonTypeName="Action.Http";return $;}(Q));a.HttpAction=$;var a1=(function(b){c(a1,b);function a1(){var d=b!==null&&b.apply(this,arguments)||this;d.card=new w1();return d;}a1.prototype.addCssClasses=function(e){b.prototype.addCssClasses.call(this,e);e.classList.add(this.parent.hostConfig.makeCssClassName("expandable"));};a1.prototype.getJsonTypeName=function(){return a1.JsonTypeName;};a1.prototype.toJSON=function(){var d=b.prototype.toJSON.call(this);if(this.card){U.setProperty(d,"card",this.card.toJSON());}return d;};a1.prototype.internalValidateProperties=function(d){b.prototype.internalValidateProperties.call(this,d);this.card.internalValidateProperties(d);};a1.prototype.parse=function(d,e){b.prototype.parse.call(this,d,e);var i=d["card"];if(i){this.card.parse(i,e);}else{q1({error:E.ValidationError.PropertyCantBeNull,message:"An Action.ShowCard must have its \"card\" property set to a valid AdaptiveCard object."},e);}};a1.prototype.setParent=function(d){b.prototype.setParent.call(this,d);this.card.setParent(d);};a1.prototype.getAllInputs=function(){return this.card.getAllInputs();};a1.prototype.getResourceInformation=function(){return b.prototype.getResourceInformation.call(this).concat(this.card.getResourceInformation());};a1.prototype.getActionById=function(i){var d=b.prototype.getActionById.call(this,i);if(!d){d=this.card.getActionById(i);}return d;};a1.JsonTypeName="Action.ShowCard";return a1;}(Q));a.ShowCardAction=a1;var b1=(function(){function b1(b){this._expandedAction=null;this._renderedActionCount=0;this._actionCard=null;this.items=[];this.buttons=[];this._owner=b;}b1.prototype.refreshContainer=function(){this._actionCardContainer.innerHTML="";if(this._actionCard===null){this._actionCardContainer.style.marginTop="0px";return;}this._actionCardContainer.style.marginTop=this._renderedActionCount>0?this._owner.hostConfig.actions.showCard.inlineTopMargin+"px":"0px";var p=this._owner.getEffectivePadding();this._owner.getImmediateSurroundingPadding(p);var b=this._owner.hostConfig.paddingDefinitionToSpacingDefinition(p);if(this._actionCard!==null){this._actionCard.style.paddingLeft=b.left+"px";this._actionCard.style.paddingRight=b.right+"px";this._actionCard.style.marginLeft="-"+b.left+"px";this._actionCard.style.marginRight="-"+b.right+"px";if(b.bottom!=0&&!this._owner.isDesignMode()){this._actionCard.style.paddingBottom=b.bottom+"px";this._actionCard.style.marginBottom="-"+b.bottom+"px";}U.appendChild(this._actionCardContainer,this._actionCard);}};b1.prototype.layoutChanged=function(){this._owner.getRootElement().updateLayout();};b1.prototype.hideActionCard=function(){var p=this._expandedAction;this._expandedAction=null;this._actionCard=null;this.refreshContainer();if(p){this.layoutChanged();l1(p,false);}};b1.prototype.showActionCard=function(b,d,e){if(d===void 0){d=false;}if(e===void 0){e=true;}if(b.card==null){return;}b.card.suppressStyle=d;var i=b.card.render();this._actionCard=i;this._expandedAction=b;this.refreshContainer();if(e){this.layoutChanged();l1(b,true);}};b1.prototype.collapseExpandedAction=function(){for(var i=0;i<this.buttons.length;i++){this.buttons[i].state=O.Normal;}this.hideActionCard();};b1.prototype.expandShowCardAction=function(b,d){for(var i=0;i<this.buttons.length;i++){if(this.buttons[i].action!==b){this.buttons[i].state=O.Subdued;}else{this.buttons[i].state=O.Expanded;}}this.showActionCard(b,!(this._owner.isAtTheVeryLeft()&&this._owner.isAtTheVeryRight()),d);};b1.prototype.actionClicked=function(b){if(!(b.action instanceof a1)){for(var i=0;i<this.buttons.length;i++){this.buttons[i].state=O.Normal;}this.hideActionCard();b.action.execute();}else{if(this._owner.hostConfig.actions.showCard.actionMode===E.ShowCardActionMode.Popup){b.action.execute();}else if(b.action===this._expandedAction){this.collapseExpandedAction();}else{this.expandShowCardAction(b.action,true);}}};b1.prototype.getParentContainer=function(){if(this._owner instanceof f1){return this._owner;}else{return this._owner.getParentContainer();}};b1.prototype.findActionButton=function(b){for(var d=0,e=this.buttons;d<e.length;d++){var i=e[d];if(i.action==b){return i;}}return null;};b1.prototype.parse=function(b,e){this.clear();if(b&&b instanceof Array){for(var d=0,i=b;d<i.length;d++){var p=i[d];var y1=j(this._owner,p,[],!this._owner.isDesignMode(),e);if(y1){this.addAction(y1);}}}};b1.prototype.toJSON=function(){if(this.items.length>0){var b=[];for(var d=0,e=this.items;d<e.length;d++){var i=e[d];b.push(i.toJSON());}return b;}else{return null;}};b1.prototype.getActionById=function(b){var d=null;for(var i=0;i<this.items.length;i++){d=this.items[i].getActionById(b);if(d){break;}}return d;};b1.prototype.validateProperties=function(b){if(this._owner.hostConfig.actions.maxActions&&this.items.length>this._owner.hostConfig.actions.maxActions){b.addFailure(this._owner,{error:E.ValidationError.TooManyActions,message:"A maximum of "+this._owner.hostConfig.actions.maxActions+" actions are allowed."});}if(this.items.length>0&&!this._owner.hostConfig.supportsInteractivity){b.addFailure(this._owner,{error:E.ValidationError.InteractivityNotAllowed,message:"Interactivity is not allowed."});}for(var d=0,e=this.items;d<e.length;d++){var i=e[d];if(!g(i,this._owner.getForbiddenActionTypes())){b.addFailure(this._owner,{error:E.ValidationError.ActionTypeNotAllowed,message:"Actions of type "+i.getJsonTypeName()+" are not allowe."});}i.internalValidateProperties(b);}};b1.prototype.render=function(b,d){var e=this;var p=this._owner.hostConfig;if(!p.supportsInteractivity){return null;}var y1=document.createElement("div");var z1=p.actions.maxActions?Math.min(p.actions.maxActions,this.items.length):this.items.length;var A1=this._owner.getForbiddenActionTypes();this._actionCardContainer=document.createElement("div");this._renderedActionCount=0;if(p.actions.preExpandSingleShowCardAction&&z1==1&&this.items[0]instanceof a1&&g(this.items[0],A1)){this.showActionCard(this.items[0],true);this._renderedActionCount=1;}else{var B1=document.createElement("div");B1.className=p.makeCssClassName("ac-actionSet");B1.style.display="flex";if(b==E.Orientation.Horizontal){B1.style.flexDirection="row";if(this._owner.horizontalAlignment&&p.actions.actionAlignment!=E.ActionAlignment.Stretch){switch(this._owner.horizontalAlignment){case E.HorizontalAlignment.Center:B1.style.justifyContent="center";break;case E.HorizontalAlignment.Right:B1.style.justifyContent="flex-end";break;default:B1.style.justifyContent="flex-start";break;}}else{switch(p.actions.actionAlignment){case E.ActionAlignment.Center:B1.style.justifyContent="center";break;case E.ActionAlignment.Right:B1.style.justifyContent="flex-end";break;default:B1.style.justifyContent="flex-start";break;}}}else{B1.style.flexDirection="column";if(this._owner.horizontalAlignment&&p.actions.actionAlignment!=E.ActionAlignment.Stretch){switch(this._owner.horizontalAlignment){case E.HorizontalAlignment.Center:B1.style.alignItems="center";break;case E.HorizontalAlignment.Right:B1.style.alignItems="flex-end";break;default:B1.style.alignItems="flex-start";break;}}else{switch(p.actions.actionAlignment){case E.ActionAlignment.Center:B1.style.alignItems="center";break;case E.ActionAlignment.Right:B1.style.alignItems="flex-end";break;case E.ActionAlignment.Stretch:B1.style.alignItems="stretch";break;default:B1.style.alignItems="flex-start";break;}}}var C1=this.getParentContainer().getEffectiveStyle();for(var i=0;i<this.items.length;i++){if(g(this.items[i],A1)){var D1=this.findActionButton(this.items[i]);if(!D1){D1=new P(this.items[i],C1);D1.onClick=function(ab){e.actionClicked(ab);};this.buttons.push(D1);}D1.render();if(p.actions.actionsOrientation==E.Orientation.Horizontal&&p.actions.actionAlignment==E.ActionAlignment.Stretch){D1.action.renderedElement.style.flex="0 1 100%";}else{D1.action.renderedElement.style.flex="0 1 auto";}B1.appendChild(D1.action.renderedElement);this._renderedActionCount++;if(this._renderedActionCount>=p.actions.maxActions||i==this.items.length-1){break;}else if(p.actions.buttonSpacing>0){var E1=document.createElement("div");if(b===E.Orientation.Horizontal){E1.style.flex="0 0 auto";E1.style.width=p.actions.buttonSpacing+"px";}else{E1.style.height=p.actions.buttonSpacing+"px";}U.appendChild(B1,E1);}}}var F1=document.createElement("div");F1.style.overflow="hidden";F1.appendChild(B1);U.appendChild(y1,F1);}U.appendChild(y1,this._actionCardContainer);for(var i=0;i<this.buttons.length;i++){if(this.buttons[i].state==O.Expanded){this.expandShowCardAction(this.buttons[i].action,false);break;}}return this._renderedActionCount>0?y1:null;};b1.prototype.addAction=function(b){if(!b){throw new Error("The action parameter cannot be null.");}if((!b.parent||b.parent===this._owner)&&this.items.indexOf(b)<0){this.items.push(b);if(!b.parent){b.setParent(this._owner);}f(b,this);}else{throw new Error("The action already belongs to another element.");}};b1.prototype.removeAction=function(b){if(this.expandedAction&&this._expandedAction==b){this.collapseExpandedAction();}var d=this.items.indexOf(b);if(d>=0){this.items.splice(d,1);b.setParent(null);f(b,null);for(var i=0;i<this.buttons.length;i++){if(this.buttons[i].action==b){this.buttons.splice(i,1);break;}}return true;}return false;};b1.prototype.clear=function(){this.items=[];this.buttons=[];this._expandedAction=null;this._renderedActionCount=0;};b1.prototype.getAllInputs=function(){var b=[];for(var i=0;i<this.items.length;i++){var d=this.items[i];b=b.concat(d.getAllInputs());}return b;};b1.prototype.getResourceInformation=function(){var b=[];for(var i=0;i<this.items.length;i++){b=b.concat(this.items[i].getResourceInformation());}return b;};Object.defineProperty(b1.prototype,"renderedActionCount",{get:function(){return this._renderedActionCount;},enumerable:true,configurable:true});Object.defineProperty(b1.prototype,"expandedAction",{get:function(){return this._expandedAction;},enumerable:true,configurable:true});return b1;}());var c1=(function(b){c(c1,b);function c1(){var d=b.call(this)||this;d.orientation=null;d._actionCollection=new b1(d);return d;}c1.prototype.internalRender=function(){return this._actionCollection.render(this.orientation?this.orientation:this.hostConfig.actions.actionsOrientation,this.isDesignMode());};c1.prototype.toJSON=function(){var d=b.prototype.toJSON.call(this);U.setEnumProperty(E.Orientation,d,"orientation",this.orientation);U.setProperty(d,"actions",this._actionCollection.toJSON());return d;};c1.prototype.isBleedingAtBottom=function(){if(this._actionCollection.renderedActionCount==0){return b.prototype.isBleedingAtBottom.call(this);}else{if(this._actionCollection.items.length==1){return this._actionCollection.expandedAction!=null&&!this.hostConfig.actions.preExpandSingleShowCardAction;}else{return this._actionCollection.expandedAction!=null;}}};c1.prototype.getJsonTypeName=function(){return"ActionSet";};c1.prototype.getActionCount=function(){return this._actionCollection.items.length;};c1.prototype.getActionAt=function(i){if(i>=0&&i<this.getActionCount()){return this._actionCollection.items[i];}else{b.prototype.getActionAt.call(this,i);}};c1.prototype.internalValidateProperties=function(d){b.prototype.internalValidateProperties.call(this,d);this._actionCollection.validateProperties(d);};c1.prototype.parse=function(d,e){b.prototype.parse.call(this,d,e);var i=d["orientation"];if(i){this.orientation=U.getEnumValue(E.Orientation,i,E.Orientation.Horizontal);}this._actionCollection.parse(d["actions"],e);};c1.prototype.addAction=function(d){this._actionCollection.addAction(d);};c1.prototype.getAllInputs=function(){return this._actionCollection.getAllInputs();};c1.prototype.getResourceInformation=function(){return this._actionCollection.getResourceInformation();};Object.defineProperty(c1.prototype,"isInteractive",{get:function(){return true;},enumerable:true,configurable:true});return c1;}(o));a.ActionSet=c1;var d1=(function(b){c(d1,b);function d1(){var d=b!==null&&b.apply(this,arguments)||this;d._style=null;d._bleed=false;return d;}d1.prototype.applyBackground=function(){var d=this.hostConfig.containerStyles.getStyleByName(this.style,this.hostConfig.containerStyles.getStyleByName(this.defaultStyle));if(!U.isNullOrEmpty(d.backgroundColor)){this.renderedElement.style.backgroundColor=U.stringToCssColor(d.backgroundColor);}};d1.prototype.applyPadding=function(){b.prototype.applyPadding.call(this);if(!this.renderedElement){return;}var p=new S.SpacingDefinition();if(this.getEffectivePadding()){p=this.hostConfig.paddingDefinitionToSpacingDefinition(this.getEffectivePadding());}this.renderedElement.style.paddingTop=p.top+"px";this.renderedElement.style.paddingRight=p.right+"px";this.renderedElement.style.paddingBottom=p.bottom+"px";this.renderedElement.style.paddingLeft=p.left+"px";if(this.isBleeding()){var d=new S.PaddingDefinition();this.getImmediateSurroundingPadding(d);var e=this.hostConfig.paddingDefinitionToSpacingDefinition(d);this.renderedElement.style.marginRight="-"+e.right+"px";this.renderedElement.style.marginLeft="-"+e.left+"px";if(!this.isDesignMode()){this.renderedElement.style.marginTop="-"+e.top+"px";this.renderedElement.style.marginBottom="-"+e.bottom+"px";}if(this.separatorElement&&this.separatorOrientation==E.Orientation.Horizontal){this.separatorElement.style.marginLeft="-"+e.left+"px";this.separatorElement.style.marginRight="-"+e.right+"px";}}else{this.renderedElement.style.marginRight="0";this.renderedElement.style.marginLeft="0";this.renderedElement.style.marginTop="0";this.renderedElement.style.marginBottom="0";if(this.separatorElement){this.separatorElement.style.marginRight="0";this.separatorElement.style.marginLeft="0";}}};d1.prototype.getHasBackground=function(){var d=this.parent;while(d){var e=d instanceof f1?d.backgroundImage.isValid():false;if(d instanceof d1){if(this.hasExplicitStyle&&(d.getEffectiveStyle()!=this.getEffectiveStyle()||e)){return true;}}d=d.parent;}return false;};d1.prototype.getDefaultPadding=function(){return this.getHasBackground()?new S.PaddingDefinition(E.Spacing.Padding,E.Spacing.Padding,E.Spacing.Padding,E.Spacing.Padding):b.prototype.getDefaultPadding.call(this);};d1.prototype.getHasExpandedAction=function(){return false;};d1.prototype.getBleed=function(){return this._bleed;};d1.prototype.setBleed=function(d){this._bleed=d;};Object.defineProperty(d1.prototype,"renderedActionCount",{get:function(){return 0;},enumerable:true,configurable:true});Object.defineProperty(d1.prototype,"hasExplicitStyle",{get:function(){return this._style!=null;},enumerable:true,configurable:true});Object.defineProperty(d1.prototype,"allowCustomStyle",{get:function(){return true;},enumerable:true,configurable:true});Object.defineProperty(d1.prototype,"supportsMinHeight",{get:function(){return true;},enumerable:true,configurable:true});d1.prototype.isBleeding=function(){return(this.getHasBackground()||this.hostConfig.alwaysAllowBleed)&&this.getBleed();};d1.prototype.toJSON=function(){var d=b.prototype.toJSON.call(this);U.setProperty(d,"style",this.style);return d;};d1.prototype.internalValidateProperties=function(d){b.prototype.internalValidateProperties.call(this,d);if(this._style){var e=this.hostConfig.containerStyles.getStyleByName(this._style);if(!e){d.addFailure(this,{error:E.ValidationError.InvalidPropertyValue,message:"Unknown container style: "+this._style});}}};d1.prototype.parse=function(d,e){b.prototype.parse.call(this,d,e);this._style=U.getStringValue(d["style"]);};d1.prototype.render=function(){var d=b.prototype.render.call(this);if(d&&this.getHasBackground()){this.applyBackground();}return d;};d1.prototype.getEffectiveStyle=function(){var e=this.style;return e?e:b.prototype.getEffectiveStyle.call(this);};Object.defineProperty(d1.prototype,"style",{get:function(){if(this.allowCustomStyle){if(this._style&&this.hostConfig.containerStyles.getStyleByName(this._style)){return this._style;}}return null;},set:function(d){this._style=d;},enumerable:true,configurable:true});return d1;}(u));a.StylableCardElementContainer=d1;var e1=(function(b){c(e1,b);function e1(){var d=b!==null&&b.apply(this,arguments)||this;d.fillMode=e1.defaultFillMode;d.horizontalAlignment=e1.defaultHorizontalAlignment;d.verticalAlignment=e1.defaultVerticalAlignment;return d;}e1.prototype.reset=function(){this.url=undefined;this.fillMode=e1.defaultFillMode;this.horizontalAlignment=e1.defaultHorizontalAlignment;this.verticalAlignment=e1.defaultVerticalAlignment;};e1.prototype.parse=function(d,e){b.prototype.parse.call(this,d,e);this.url=U.getStringValue(d["url"]);this.fillMode=U.getEnumValue(E.FillMode,d["fillMode"],this.fillMode);this.horizontalAlignment=U.getEnumValue(E.HorizontalAlignment,d["horizontalAlignment"],this.horizontalAlignment);this.verticalAlignment=U.getEnumValue(E.VerticalAlignment,d["verticalAlignment"],this.verticalAlignment);};e1.prototype.toJSON=function(){if(!this.isValid()){return null;}if(this.fillMode==e1.defaultFillMode&&this.horizontalAlignment==e1.defaultHorizontalAlignment&&this.verticalAlignment==e1.defaultVerticalAlignment){return this.url;}else{var d=b.prototype.toJSON.call(this);U.setProperty(d,"url",this.url);U.setEnumProperty(E.FillMode,d,"fillMode",this.fillMode,e1.defaultFillMode);U.setEnumProperty(E.HorizontalAlignment,d,"horizontalAlignment",this.horizontalAlignment,e1.defaultHorizontalAlignment);U.setEnumProperty(E.VerticalAlignment,d,"verticalAlignment",this.verticalAlignment,e1.defaultVerticalAlignment);return d;}};e1.prototype.apply=function(e){if(this.url){e.style.backgroundImage="url('"+this.url+"')";switch(this.fillMode){case E.FillMode.Repeat:e.style.backgroundRepeat="repeat";break;case E.FillMode.RepeatHorizontally:e.style.backgroundRepeat="repeat-x";break;case E.FillMode.RepeatVertically:e.style.backgroundRepeat="repeat-y";break;case E.FillMode.Cover:default:e.style.backgroundRepeat="no-repeat";e.style.backgroundSize="cover";break;}switch(this.horizontalAlignment){case E.HorizontalAlignment.Center:e.style.backgroundPositionX="center";break;case E.HorizontalAlignment.Right:e.style.backgroundPositionX="right";break;}switch(this.verticalAlignment){case E.VerticalAlignment.Center:e.style.backgroundPositionY="center";break;case E.VerticalAlignment.Bottom:e.style.backgroundPositionY="bottom";break;}}};e1.prototype.isValid=function(){return!U.isNullOrEmpty(this.url);};e1.defaultFillMode=E.FillMode.Cover;e1.defaultHorizontalAlignment=E.HorizontalAlignment.Left;e1.defaultVerticalAlignment=E.VerticalAlignment.Top;return e1;}(l));a.BackgroundImage=e1;var f1=(function(b){c(f1,b);function f1(){var d=b!==null&&b.apply(this,arguments)||this;d._items=[];d._renderedItems=[];d.backgroundImage=new e1();d.verticalContentAlignment=E.VerticalAlignment.Top;d.rtl=null;return d;}f1.prototype.insertItemAt=function(i,d,e){if(!i.parent||e){if(i.isStandalone){if(d<0||d>=this._items.length){this._items.push(i);}else{this._items.splice(d,0,i);}i.setParent(this);}else{throw new Error("Elements of type "+i.getJsonTypeName()+" cannot be used as standalone elements.");}}else{throw new Error("The element already belongs to another container.");}};f1.prototype.supportsExcplitiHeight=function(){return true;};f1.prototype.getItemsCollectionPropertyName=function(){return"items";};f1.prototype.applyBackground=function(){if(this.backgroundImage.isValid()){this.backgroundImage.apply(this.renderedElement);}b.prototype.applyBackground.call(this);};f1.prototype.internalRender=function(){this._renderedItems=[];var d=this.hostConfig;var e=document.createElement("div");if(this.rtl!=null&&this.rtl){e.dir="rtl";}e.classList.add(d.makeCssClassName("ac-container"));e.style.display="flex";e.style.flexDirection="column";if(v1.useAdvancedCardBottomTruncation){e.style.minHeight='-webkit-min-content';}switch(this.verticalContentAlignment){case E.VerticalAlignment.Center:e.style.justifyContent="center";break;case E.VerticalAlignment.Bottom:e.style.justifyContent="flex-end";break;default:e.style.justifyContent="flex-start";break;}if(this._items.length>0){for(var i=0;i<this._items.length;i++){var p=this.isElementAllowed(this._items[i],this.getForbiddenElementTypes())?this._items[i].render():null;if(p){if(this._renderedItems.length>0&&this._items[i].separatorElement){this._items[i].separatorElement.style.flex="0 0 auto";U.appendChild(e,this._items[i].separatorElement);}U.appendChild(e,p);this._renderedItems.push(this._items[i]);}}}else{if(this.isDesignMode()){var y1=this.createPlaceholderElement();y1.style.width="100%";y1.style.height="100%";e.appendChild(y1);}}return e;};f1.prototype.truncateOverflow=function(d){var e=this.renderedElement.offsetTop+d+1;var i=function(z1){var A1=z1.renderedElement;if(A1){switch(U.getFitStatus(A1,e)){case E.ContainerFitStatus.FullyInContainer:var B1=z1['resetOverflow']();if(B1){i(z1);}break;case E.ContainerFitStatus.Overflowing:var C1=e-A1.offsetTop;z1['handleOverflow'](C1);break;case E.ContainerFitStatus.FullyOutOfContainer:z1['handleOverflow'](0);break;}}};for(var p=0,_a=this._items;p<_a.length;p++){var y1=_a[p];i(y1);}return true;};f1.prototype.undoOverflowTruncation=function(){for(var d=0,e=this._items;d<e.length;d++){var i=e[d];i['resetOverflow']();}};f1.prototype.getHasBackground=function(){return this.backgroundImage.isValid()||b.prototype.getHasBackground.call(this);};Object.defineProperty(f1.prototype,"isSelectable",{get:function(){return true;},enumerable:true,configurable:true});f1.prototype.toJSON=function(){var d=b.prototype.toJSON.call(this);U.setProperty(d,"backgroundImage",this.backgroundImage.toJSON());U.setEnumProperty(E.VerticalAlignment,d,"verticalContentAlignment",this.verticalContentAlignment,E.VerticalAlignment.Top);if(this._items.length>0){var e=[];for(var i=0,p=this._items;i<p.length;i++){var y1=p[i];e.push(y1.toJSON());}U.setProperty(d,this.getItemsCollectionPropertyName(),e);}U.setProperty(d,"bleed",this.bleed,false);return d;};f1.prototype.getItemCount=function(){return this._items.length;};f1.prototype.getItemAt=function(i){return this._items[i];};f1.prototype.getFirstVisibleRenderedItem=function(){if(this.renderedElement&&this._renderedItems&&this._renderedItems.length>0){for(var d=0,e=this._renderedItems;d<e.length;d++){var i=e[d];if(i.isVisible){return i;}};}return null;};f1.prototype.getLastVisibleRenderedItem=function(){if(this.renderedElement&&this._renderedItems&&this._renderedItems.length>0){for(var i=this._renderedItems.length-1;i>=0;i--){if(this._renderedItems[i].isVisible){return this._renderedItems[i];}}}return null;};f1.prototype.getJsonTypeName=function(){return"Container";};f1.prototype.isFirstElement=function(e){var d=this.isDesignMode();for(var i=0;i<this._items.length;i++){if(this._items[i].isVisible||d){return this._items[i]==e;}}return false;};f1.prototype.isLastElement=function(e){var d=this.isDesignMode();for(var i=this._items.length-1;i>=0;i--){if(this._items[i].isVisible||d){return this._items[i]==e;}}return false;};f1.prototype.isRtl=function(){if(this.rtl!=null){return this.rtl;}else{var p=this.getParentContainer();return p?p.isRtl():false;}};f1.prototype.isBleedingAtTop=function(){var d=this.getFirstVisibleRenderedItem();return this.isBleeding()||(d?d.isBleedingAtTop():false);};f1.prototype.isBleedingAtBottom=function(){var d=this.getLastVisibleRenderedItem();return this.isBleeding()||(d?d.isBleedingAtBottom()&&d.getEffectiveStyle()==this.getEffectiveStyle():false);};f1.prototype.parse=function(d,e){b.prototype.parse.call(this,d,e);this.setShouldFallback(false);this._items=[];this._renderedItems=[];this.backgroundImage.reset();var p=d["backgroundImage"];if(p){if(typeof p==="string"){this.backgroundImage.url=p;this.backgroundImage.fillMode=E.FillMode.Cover;}else if(typeof p==="object"){this.backgroundImage.parse(p,e);}}this.verticalContentAlignment=U.getEnumValue(E.VerticalAlignment,d["verticalContentAlignment"],this.verticalContentAlignment);if(d[this.getItemsCollectionPropertyName()]!=null){var y1=d[this.getItemsCollectionPropertyName()];this.clear();for(var i=0;i<y1.length;i++){var z1=k(this,y1[i],!this.isDesignMode(),e);if(z1){this.insertItemAt(z1,-1,true);}}}this.bleed=U.getBoolValue(d["bleed"],this.bleed);};f1.prototype.indexOf=function(d){return this._items.indexOf(d);};f1.prototype.addItem=function(i){this.insertItemAt(i,-1,false);};f1.prototype.insertItemBefore=function(i,d){this.insertItemAt(i,this._items.indexOf(d),false);};f1.prototype.insertItemAfter=function(i,d){this.insertItemAt(i,this._items.indexOf(d)+1,false);};f1.prototype.removeItem=function(i){var d=this._items.indexOf(i);if(d>=0){this._items.splice(d,1);i.setParent(null);this.updateLayout();return true;}return false;};f1.prototype.clear=function(){this._items=[];};f1.prototype.getResourceInformation=function(){var d=b.prototype.getResourceInformation.call(this);if(this.backgroundImage.isValid()){d.push({url:this.backgroundImage.url,mimeType:"image"});}return d;};f1.prototype.getActionById=function(d){var e=b.prototype.getActionById.call(this,d);if(!e){if(this.selectAction){e=this.selectAction.getActionById(d);}if(!e){for(var i=0;i<this._items.length;i++){e=this._items[i].getActionById(d);if(e){break;}}}}return e;};Object.defineProperty(f1.prototype,"padding",{get:function(){return this.getPadding();},set:function(d){this.setPadding(d);},enumerable:true,configurable:true});Object.defineProperty(f1.prototype,"selectAction",{get:function(){return this.getSelectAction();},set:function(d){this.setSelectAction(d);},enumerable:true,configurable:true});Object.defineProperty(f1.prototype,"bleed",{get:function(){return this.getBleed();},set:function(d){this.setBleed(d);},enumerable:true,configurable:true});return f1;}(d1));a.Container=f1;var g1=(function(b){c(g1,b);function g1(d){if(d===void 0){d="auto";}var e=b.call(this)||this;e._computedWeight=0;e.width="auto";e.width=d;return e;}g1.prototype.adjustRenderedElementSize=function(d){var e=20;if(this.isDesignMode()){d.style.minWidth="20px";d.style.minHeight=(!this.minPixelHeight?e:Math.max(this.minPixelHeight,e))+"px";}else{d.style.minWidth="0";if(this.minPixelHeight){d.style.minHeight=this.minPixelHeight+"px";}}if(this.width==="auto"){d.style.flex="0 1 auto";}else if(this.width==="stretch"){d.style.flex="1 1 50px";}else{var i=this.width;if(i.unit==E.SizeUnit.Pixel){d.style.flex="0 0 auto";d.style.width=i.physicalSize+"px";}else{d.style.flex="1 1 "+(this._computedWeight>0?this._computedWeight:i.physicalSize)+"%";}}};Object.defineProperty(g1.prototype,"separatorOrientation",{get:function(){return E.Orientation.Vertical;},enumerable:true,configurable:true});g1.prototype.getJsonTypeName=function(){return"Column";};g1.prototype.toJSON=function(){var d=b.prototype.toJSON.call(this);if(this.width instanceof S.SizeAndUnit){if(this.width.unit==E.SizeUnit.Pixel){U.setProperty(d,"width",this.width.physicalSize+"px");}else{U.setProperty(d,"width",this.width.physicalSize);}}else{U.setProperty(d,"width",this.width);}return d;};g1.prototype.parse=function(d,i){b.prototype.parse.call(this,d,i);var p=d["width"];if(p===undefined){p=d["size"];if(p!==undefined){q1({error:E.ValidationError.Deprecated,message:"The \"Column.size\" property is deprecated and will be removed. Use the \"Column.width\" property instead."},i);}}if(p){var y1=false;try{this.width=S.SizeAndUnit.parse(p);}catch(e){if(typeof p==="string"&&(p==="auto"||p==="stretch")){this.width=p;}else{y1=true;}}if(y1){q1({error:E.ValidationError.InvalidPropertyValue,message:"Invalid column width:"+p+" - defaulting to \"auto\""},i);}}};Object.defineProperty(g1.prototype,"hasVisibleSeparator",{get:function(){if(this.parent&&this.parent instanceof h1){return this.separatorElement&&!this.parent.isLeftMostElement(this);}else{return false;}},enumerable:true,configurable:true});Object.defineProperty(g1.prototype,"isStandalone",{get:function(){return false;},enumerable:true,configurable:true});return g1;}(f1));a.Column=g1;var h1=(function(b){c(h1,b);function h1(){var d=b!==null&&b.apply(this,arguments)||this;d._columns=[];return d;}h1.prototype.createColumnInstance=function(d,e){return h(this,d,[],!this.isDesignMode(),function(i){return!i||i==="Column"?new g1():null;},function(i,p){if(p==I.UnknownType){return{error:E.ValidationError.UnknownElementType,message:"Unknown element type: "+i+". Fallback will be used if present."};}else{return{error:E.ValidationError.ElementTypeNotAllowed,message:"Element type "+i+" isn't allowed in a ColumnSet."};}},e);};h1.prototype.internalRender=function(){this._renderedColumns=[];if(this._columns.length>0){var d=this.hostConfig;var e=document.createElement("div");e.className=d.makeCssClassName("ac-columnSet");e.style.display="flex";if(v1.useAdvancedCardBottomTruncation){e.style.minHeight='-webkit-min-content';}switch(this.horizontalAlignment){case E.HorizontalAlignment.Center:e.style.justifyContent="center";break;case E.HorizontalAlignment.Right:e.style.justifyContent="flex-end";break;default:e.style.justifyContent="flex-start";break;}var i=0;for(var p=0,_a=this._columns;p<_a.length;p++){var y1=_a[p];if(y1.width instanceof S.SizeAndUnit&&(y1.width.unit==E.SizeUnit.Weight)){i+=y1.width.physicalSize;}}for(var _b=0,_c=this._columns;_b<_c.length;_b++){var y1=_c[_b];if(y1.width instanceof S.SizeAndUnit&&y1.width.unit==E.SizeUnit.Weight&&i>0){var B1=100/i*y1.width.physicalSize;y1["_computedWeight"]=B1;}var C1=y1.render();if(C1){if(this._renderedColumns.length>0&&y1.separatorElement){y1.separatorElement.style.flex="0 0 auto";U.appendChild(e,y1.separatorElement);}U.appendChild(e,C1);this._renderedColumns.push(y1);}}return this._renderedColumns.length>0?e:null;}else{return null;}};h1.prototype.truncateOverflow=function(d){for(var e=0,i=this._columns;e<i.length;e++){var p=i[e];p['handleOverflow'](d);}return true;};h1.prototype.undoOverflowTruncation=function(){for(var d=0,e=this._columns;d<e.length;d++){var i=e[d];i['resetOverflow']();}};Object.defineProperty(h1.prototype,"isSelectable",{get:function(){return true;},enumerable:true,configurable:true});h1.prototype.toJSON=function(){var d=b.prototype.toJSON.call(this);if(this._columns.length>0){var e=[];for(var i=0,p=this._columns;i<p.length;i++){var y1=p[i];e.push(y1.toJSON());}U.setProperty(d,"columns",e);}U.setProperty(d,"bleed",this.bleed,false);return d;};h1.prototype.isFirstElement=function(e){for(var i=0;i<this._columns.length;i++){if(this._columns[i].isVisible){return this._columns[i]==e;}}return false;};h1.prototype.isBleedingAtTop=function(){if(this.isBleeding()){return true;}if(this._renderedColumns&&this._renderedColumns.length>0){for(var d=0,e=this._columns;d<e.length;d++){var i=e[d];if(i.isBleedingAtTop()){return true;}}}return false;};h1.prototype.isBleedingAtBottom=function(){if(this.isBleeding()){return true;}if(this._renderedColumns&&this._renderedColumns.length>0){for(var d=0,e=this._columns;d<e.length;d++){var i=e[d];if(i.isBleedingAtBottom()){return true;}}}return false;};h1.prototype.getCount=function(){return this._columns.length;};h1.prototype.getItemCount=function(){return this.getCount();};h1.prototype.getFirstVisibleRenderedItem=function(){if(this.renderedElement&&this._renderedColumns&&this._renderedColumns.length>0){return this._renderedColumns[0];}else{return null;}};h1.prototype.getLastVisibleRenderedItem=function(){if(this.renderedElement&&this._renderedColumns&&this._renderedColumns.length>0){return this._renderedColumns[this._renderedColumns.length-1];}else{return null;}};h1.prototype.getColumnAt=function(i){return this._columns[i];};h1.prototype.getItemAt=function(i){return this.getColumnAt(i);};h1.prototype.getJsonTypeName=function(){return"ColumnSet";};h1.prototype.parse=function(d,e){b.prototype.parse.call(this,d,e);if(d["columns"]!=null){var p=d["columns"];this._columns=[];for(var i=0;i<p.length;i++){var y1=this.createColumnInstance(p[i],e);this._columns.push(y1);}}this.bleed=U.getBoolValue(d["bleed"],this.bleed);};h1.prototype.internalValidateProperties=function(d){b.prototype.internalValidateProperties.call(this,d);var e=0;var i=0;for(var p=0,_a=this._columns;p<_a.length;p++){var y1=_a[p];if(typeof y1.width==="number"){e++;}else if(y1.width==="stretch"){i++;}}if(e>0&&i>0){d.addFailure(this,{error:E.ValidationError.Hint,message:"It is not recommended to use weighted and stretched columns in the same ColumnSet, because in such a situation stretched columns will always get the minimum amount of space."});}};h1.prototype.addColumn=function(d){if(!d.parent){this._columns.push(d);d.setParent(this);}else{throw new Error("This column already belongs to another ColumnSet.");}};h1.prototype.removeItem=function(i){if(i instanceof g1){var d=this._columns.indexOf(i);if(d>=0){this._columns.splice(d,1);i.setParent(null);this.updateLayout();return true;}}return false;};h1.prototype.indexOf=function(d){return d instanceof g1?this._columns.indexOf(d):-1;};h1.prototype.isLeftMostElement=function(e){return this._columns.indexOf(e)==0;};h1.prototype.isRightMostElement=function(e){return this._columns.indexOf(e)==this._columns.length-1;};h1.prototype.isTopElement=function(e){return this._columns.indexOf(e)>=0;};h1.prototype.isBottomElement=function(e){return this._columns.indexOf(e)>=0;};h1.prototype.getActionById=function(d){var e=null;for(var i=0;i<this._columns.length;i++){e=this._columns[i].getActionById(d);if(e){break;}}return e;};Object.defineProperty(h1.prototype,"bleed",{get:function(){return this.getBleed();},set:function(d){this.setBleed(d);},enumerable:true,configurable:true});Object.defineProperty(h1.prototype,"padding",{get:function(){return this.getPadding();},set:function(d){this.setPadding(d);},enumerable:true,configurable:true});Object.defineProperty(h1.prototype,"selectAction",{get:function(){return this.getSelectAction();},set:function(d){this.setSelectAction(d);},enumerable:true,configurable:true});return h1;}(d1));a.ColumnSet=h1;function i1(i){var b=i.getRootElement();var d=(b&&b.onImageLoaded)?b.onImageLoaded:v1.onImageLoaded;if(d){d(i);}}function j1(e,b){var d=e.getRootElement();var i=(d&&d.onAnchorClicked)?d.onAnchorClicked:v1.onAnchorClicked;return i!=null?i(e,b):false;}function k1(b){var d=b.parent.getRootElement();var e=(d&&d.onExecuteAction)?d.onExecuteAction:v1.onExecuteAction;if(e){if(b.prepareForExecution()){e(b);}}}function l1(b,i){var d=b.parent.getRootElement();var e=(d&&d.onInlineCardExpanded)?d.onInlineCardExpanded:v1.onInlineCardExpanded;if(e){e(b,i);}}function m1(i){var b=i.getRootElement();var d=(b&&b.onInputValueChanged)?b.onInputValueChanged:v1.onInputValueChanged;if(d){d(i);}}function n1(e,b){if(b===void 0){b=true;}var d=e.getRootElement();if(b){d.updateLayout();}var i=d;var p=(i&&i.onElementVisibilityChanged)?i.onElementVisibilityChanged:v1.onElementVisibilityChanged;if(p!=null){p(e);}}function o1(e,b,d){var i=e.getRootElement();var p=(i&&i.onParseElement)?i.onParseElement:v1.onParseElement;if(p!=null){p(e,b,d);}}function p1(b,d,e){var i=b.parent?b.parent.getRootElement():null;var p=(i&&i.onParseAction)?i.onParseAction:v1.onParseAction;if(p!=null){p(b,d,e);}}function q1(e,b){if(b){b.push(e);}if(v1.onParseError!=null){v1.onParseError(e);}}var r1=(function(b){c(r1,b);function r1(){var d=b.call(this)||this;d._actionCollection=new b1(d);return d;}r1.prototype.internalRender=function(){var e=b.prototype.internalRender.call(this);var d=this._actionCollection.render(this.hostConfig.actions.actionsOrientation,false);if(d){U.appendChild(e,U.renderSeparation(this.hostConfig,{spacing:this.hostConfig.getEffectiveSpacing(this.hostConfig.actions.spacing),lineThickness:null,lineColor:null},E.Orientation.Horizontal));U.appendChild(e,d);}if(this.renderIfEmpty){return e;}else{return e.children.length>0?e:null;}};r1.prototype.getHasExpandedAction=function(){if(this.renderedActionCount==0){return false;}else if(this.renderedActionCount==1){return this._actionCollection.expandedAction!=null&&!this.hostConfig.actions.preExpandSingleShowCardAction;}else{return this._actionCollection.expandedAction!=null;}};Object.defineProperty(r1.prototype,"renderedActionCount",{get:function(){return this._actionCollection.renderedActionCount;},enumerable:true,configurable:true});Object.defineProperty(r1.prototype,"renderIfEmpty",{get:function(){return false;},enumerable:true,configurable:true});r1.prototype.toJSON=function(){var d=b.prototype.toJSON.call(this);U.setProperty(d,"actions",this._actionCollection.toJSON());return d;};r1.prototype.getActionCount=function(){return this._actionCollection.items.length;};r1.prototype.getActionAt=function(i){if(i>=0&&i<this.getActionCount()){return this._actionCollection.items[i];}else{b.prototype.getActionAt.call(this,i);}};r1.prototype.getActionById=function(i){var d=this._actionCollection.getActionById(i);return d?d:b.prototype.getActionById.call(this,i);};r1.prototype.parse=function(d,e){b.prototype.parse.call(this,d,e);this._actionCollection.parse(d["actions"],e);};r1.prototype.internalValidateProperties=function(d){b.prototype.internalValidateProperties.call(this,d);if(this._actionCollection){this._actionCollection.validateProperties(d);}};r1.prototype.isLastElement=function(e){return b.prototype.isLastElement.call(this,e)&&this._actionCollection.items.length==0;};r1.prototype.addAction=function(d){this._actionCollection.addAction(d);};r1.prototype.clear=function(){b.prototype.clear.call(this);this._actionCollection.clear();};r1.prototype.getAllInputs=function(){return b.prototype.getAllInputs.call(this).concat(this._actionCollection.getAllInputs());};r1.prototype.getResourceInformation=function(){return b.prototype.getResourceInformation.call(this).concat(this._actionCollection.getResourceInformation());};r1.prototype.isBleedingAtBottom=function(){if(this._actionCollection.renderedActionCount==0){return b.prototype.isBleedingAtBottom.call(this);}else{if(this._actionCollection.items.length==1){return this._actionCollection.expandedAction!=null&&!this.hostConfig.actions.preExpandSingleShowCardAction;}else{return this._actionCollection.expandedAction!=null;}}};Object.defineProperty(r1.prototype,"isStandalone",{get:function(){return false;},enumerable:true,configurable:true});return r1;}(f1));a.ContainerWithActions=r1;var s1=(function(){function s1(){this._items=[];this.reset();}s1.prototype.findTypeRegistration=function(b){for(var i=0;i<this._items.length;i++){if(this._items[i].typeName===b){return this._items[i];}}return null;};s1.prototype.clear=function(){this._items=[];};s1.prototype.registerType=function(b,d){var e=this.findTypeRegistration(b);if(e!=null){e.createInstance=d;}else{e={typeName:b,createInstance:d};this._items.push(e);}};s1.prototype.unregisterType=function(b){for(var i=0;i<this._items.length;i++){if(this._items[i].typeName===b){this._items.splice(i,1);return;}}};s1.prototype.createInstance=function(b){var d=this.findTypeRegistration(b);return d?d.createInstance():null;};s1.prototype.getItemCount=function(){return this._items.length;};s1.prototype.getItemAt=function(i){return this._items[i];};return s1;}());a.TypeRegistry=s1;var t1=(function(b){c(t1,b);function t1(){return b!==null&&b.apply(this,arguments)||this;}t1.prototype.reset=function(){this.clear();this.registerType("Container",function(){return new f1();});this.registerType("TextBlock",function(){return new q();});this.registerType("RichTextBlock",function(){return new R();});this.registerType("TextRun",function(){return new r();});this.registerType("Image",function(){return new t();});this.registerType("ImageSet",function(){return new v();});this.registerType("Media",function(){return new w();});this.registerType("FactSet",function(){return new s();});this.registerType("ColumnSet",function(){return new h1();});this.registerType("ActionSet",function(){return new c1();});this.registerType("Input.Text",function(){return new z();});this.registerType("Input.Date",function(){return new J();});this.registerType("Input.Time",function(){return new K();});this.registerType("Input.Number",function(){return new N();});this.registerType("Input.ChoiceSet",function(){return new G();});this.registerType("Input.Toggle",function(){return new A();});};return t1;}(s1));a.ElementTypeRegistry=t1;var u1=(function(b){c(u1,b);function u1(){return b!==null&&b.apply(this,arguments)||this;}u1.prototype.reset=function(){this.clear();this.registerType(X.JsonTypeName,function(){return new X();});this.registerType(W.JsonTypeName,function(){return new W();});this.registerType(a1.JsonTypeName,function(){return new a1();});this.registerType(Y.JsonTypeName,function(){return new Y();});};return u1;}(s1));a.ActionTypeRegistry=u1;var v1=(function(b){c(v1,b);function v1(){var d=b!==null&&b.apply(this,arguments)||this;d._cardTypeName="AdaptiveCard";d._fallbackCard=null;d.onAnchorClicked=null;d.onExecuteAction=null;d.onElementVisibilityChanged=null;d.onImageLoaded=null;d.onInlineCardExpanded=null;d.onInputValueChanged=null;d.onParseElement=null;d.onParseAction=null;d.version=new H.Version(1,0);d.designMode=false;return d;}Object.defineProperty(v1,"processMarkdown",{get:function(){throw new Error("The processMarkdown event has been removed. Please update your code and set onProcessMarkdown instead.");},set:function(d){throw new Error("The processMarkdown event has been removed. Please update your code and set onProcessMarkdown instead.");},enumerable:true,configurable:true});v1.applyMarkdown=function(d){var e={didProcess:false};if(v1.onProcessMarkdown){v1.onProcessMarkdown(d,e);}else if(window["markdownit"]){e.outputHtml=window["markdownit"]().render(d);e.didProcess=true;}else{console.warn("Markdown processing isn't enabled. Please see https://www.npmjs.com/package/adaptivecards#supporting-markdown");}return e;};v1.prototype.isVersionSupported=function(){if(this.bypassVersionCheck){return true;}else{var d=!this.version||!this.version.isValid||(v1.currentVersion.major<this.version.major)||(v1.currentVersion.major==this.version.major&&v1.currentVersion.minor<this.version.minor);return!d;}};v1.prototype.getItemsCollectionPropertyName=function(){return"body";};v1.prototype.internalRender=function(){var d=b.prototype.internalRender.call(this);if(v1.useAdvancedCardBottomTruncation){d.style.minHeight=null;}return d;};v1.prototype.getHasBackground=function(){return true;};v1.prototype.getDefaultPadding=function(){return new S.PaddingDefinition(E.Spacing.Padding,E.Spacing.Padding,E.Spacing.Padding,E.Spacing.Padding);};Object.defineProperty(v1.prototype,"renderIfEmpty",{get:function(){return true;},enumerable:true,configurable:true});Object.defineProperty(v1.prototype,"bypassVersionCheck",{get:function(){return false;},enumerable:true,configurable:true});Object.defineProperty(v1.prototype,"allowCustomStyle",{get:function(){return this.hostConfig.adaptiveCard&&this.hostConfig.adaptiveCard.allowCustomStyle;},enumerable:true,configurable:true});Object.defineProperty(v1.prototype,"hasBackground",{get:function(){return true;},enumerable:true,configurable:true});v1.prototype.getJsonTypeName=function(){return"AdaptiveCard";};v1.prototype.toJSON=function(){var d=b.prototype.toJSON.call(this);U.setProperty(d,"$schema","http://adaptivecards.io/schemas/adaptive-card.json");if(!this.bypassVersionCheck&&this.version){U.setProperty(d,"version",this.version.toString());}U.setProperty(d,"fallbackText",this.fallbackText);U.setProperty(d,"lang",this.lang);U.setProperty(d,"speak",this.speak);return d;};v1.prototype.internalValidateProperties=function(d){b.prototype.internalValidateProperties.call(this,d);if(this._cardTypeName!="AdaptiveCard"){d.addFailure(this,{error:E.ValidationError.MissingCardType,message:"Invalid or missing card type. Make sure the card's type property is set to \"AdaptiveCard\"."});}if(!this.bypassVersionCheck&&!this.version){d.addFailure(this,{error:E.ValidationError.PropertyCantBeNull,message:"The version property must be specified."});}else if(!this.isVersionSupported()){d.addFailure(this,{error:E.ValidationError.UnsupportedCardVersion,message:"The specified card version ("+this.version+") is not supported. The maximum supported card version is "+v1.currentVersion});}};v1.prototype.parse=function(d,i){this._fallbackCard=null;this._cardTypeName=U.getStringValue(d["type"]);this.speak=U.getStringValue(d["speak"]);var p=U.getStringValue(d["lang"]);if(p&&typeof p==="string"){try{this.lang=p;}catch(e){q1({error:E.ValidationError.InvalidPropertyValue,message:e.message},i);}}this.version=H.Version.parse(d["version"],i);this.fallbackText=U.getStringValue(d["fallbackText"]);var y1=k(null,d["fallback"],!this.isDesignMode(),i);if(y1){this._fallbackCard=new v1();this._fallbackCard.addItem(y1);}b.prototype.parse.call(this,d,i);};v1.prototype.render=function(d){var e;if(this.shouldFallback()&&this._fallbackCard){this._fallbackCard.hostConfig=this.hostConfig;e=this._fallbackCard.render();}else{e=b.prototype.render.call(this);if(e){e.classList.add(this.hostConfig.makeCssClassName("ac-adaptiveCard"));e.tabIndex=0;if(!U.isNullOrEmpty(this.speak)){e.setAttribute("aria-label",this.speak);}}}if(d){d.appendChild(e);this.updateLayout();}return e;};v1.prototype.updateLayout=function(p){if(p===void 0){p=true;}b.prototype.updateLayout.call(this,p);if(v1.useAdvancedCardBottomTruncation&&this.isRendered()){var d=this.renderedElement;var e=this.hostConfig.getEffectiveSpacing(E.Spacing.Default);this['handleOverflow'](d.offsetHeight-e);}};v1.prototype.shouldFallback=function(){return b.prototype.shouldFallback.call(this)||!this.isVersionSupported();};Object.defineProperty(v1.prototype,"hasVisibleSeparator",{get:function(){return false;},enumerable:true,configurable:true});v1.currentVersion=new H.Version(1,2);v1.useAdvancedTextBlockTruncation=true;v1.useAdvancedCardBottomTruncation=false;v1.useMarkdownInRadioButtonAndCheckbox=true;v1.allowMarkForTextHighlighting=false;v1.alwaysBleedSeparators=false;v1.enableFullJsonRoundTrip=false;v1.useBuiltInInputValidation=true;v1.displayInputValidationErrors=true;v1.elementTypeRegistry=new t1();v1.actionTypeRegistry=new u1();v1.onAnchorClicked=null;v1.onExecuteAction=null;v1.onElementVisibilityChanged=null;v1.onImageLoaded=null;v1.onInlineCardExpanded=null;v1.onInputValueChanged=null;v1.onParseElement=null;v1.onParseAction=null;v1.onParseError=null;v1.onProcessMarkdown=null;return v1;}(r1));a.AdaptiveCard=v1;var w1=(function(b){c(w1,b);function w1(){var d=b!==null&&b.apply(this,arguments)||this;d.suppressStyle=false;return d;}w1.prototype.getDefaultPadding=function(){return new S.PaddingDefinition(this.suppressStyle?E.Spacing.None:E.Spacing.Padding,E.Spacing.Padding,this.suppressStyle?E.Spacing.None:E.Spacing.Padding,E.Spacing.Padding);};Object.defineProperty(w1.prototype,"bypassVersionCheck",{get:function(){return true;},enumerable:true,configurable:true});Object.defineProperty(w1.prototype,"defaultStyle",{get:function(){if(this.suppressStyle){return E.ContainerStyle.Default;}else{return this.hostConfig.actions.showCard.style?this.hostConfig.actions.showCard.style:E.ContainerStyle.Emphasis;}},enumerable:true,configurable:true});w1.prototype.render=function(d){var e=b.prototype.render.call(this,d);e.setAttribute("aria-live","polite");e.removeAttribute("tabindex");return e;};w1.prototype.getForbiddenActionTypes=function(){return[a1];};return w1;}(v1));var x1=new H.HostConfig({supportsInteractivity:true,spacing:{small:10,default:20,medium:30,large:40,extraLarge:50,padding:20},separator:{lineThickness:1,lineColor:"#EEEEEE"},fontTypes:{default:{fontFamily:"'Segoe UI', Tahoma, Geneva, Verdana, sans-serif",fontSizes:{small:12,default:14,medium:17,large:21,extraLarge:26},fontWeights:{lighter:200,default:400,bolder:600}},monospace:{fontFamily:"'Courier New', Courier, monospace",fontSizes:{small:12,default:14,medium:17,large:21,extraLarge:26},fontWeights:{lighter:200,default:400,bolder:600}}},imageSizes:{small:40,medium:80,large:160},containerStyles:{default:{backgroundColor:"#FFFFFF",foregroundColors:{default:{default:"#333333",subtle:"#EE333333"},dark:{default:"#000000",subtle:"#66000000"},light:{default:"#FFFFFF",subtle:"#33000000"},accent:{default:"#2E89FC",subtle:"#882E89FC"},attention:{default:"#cc3300",subtle:"#DDcc3300"},good:{default:"#54a254",subtle:"#DD54a254"},warning:{default:"#e69500",subtle:"#DDe69500"}}},emphasis:{backgroundColor:"#08000000",foregroundColors:{default:{default:"#333333",subtle:"#EE333333"},dark:{default:"#000000",subtle:"#66000000"},light:{default:"#FFFFFF",subtle:"#33000000"},accent:{default:"#2E89FC",subtle:"#882E89FC"},attention:{default:"#cc3300",subtle:"#DDcc3300"},good:{default:"#54a254",subtle:"#DD54a254"},warning:{default:"#e69500",subtle:"#DDe69500"}}},accent:{backgroundColor:"#C7DEF9",foregroundColors:{default:{default:"#333333",subtle:"#EE333333"},dark:{default:"#000000",subtle:"#66000000"},light:{default:"#FFFFFF",subtle:"#33000000"},accent:{default:"#2E89FC",subtle:"#882E89FC"},attention:{default:"#cc3300",subtle:"#DDcc3300"},good:{default:"#54a254",subtle:"#DD54a254"},warning:{default:"#e69500",subtle:"#DDe69500"}}},good:{backgroundColor:"#CCFFCC",foregroundColors:{default:{default:"#333333",subtle:"#EE333333"},dark:{default:"#000000",subtle:"#66000000"},light:{default:"#FFFFFF",subtle:"#33000000"},accent:{default:"#2E89FC",subtle:"#882E89FC"},attention:{default:"#cc3300",subtle:"#DDcc3300"},good:{default:"#54a254",subtle:"#DD54a254"},warning:{default:"#e69500",subtle:"#DDe69500"}}},attention:{backgroundColor:"#FFC5B2",foregroundColors:{default:{default:"#333333",subtle:"#EE333333"},dark:{default:"#000000",subtle:"#66000000"},light:{default:"#FFFFFF",subtle:"#33000000"},accent:{default:"#2E89FC",subtle:"#882E89FC"},attention:{default:"#cc3300",subtle:"#DDcc3300"},good:{default:"#54a254",subtle:"#DD54a254"},warning:{default:"#e69500",subtle:"#DDe69500"}}},warning:{backgroundColor:"#FFE2B2",foregroundColors:{default:{default:"#333333",subtle:"#EE333333"},dark:{default:"#000000",subtle:"#66000000"},light:{default:"#FFFFFF",subtle:"#33000000"},accent:{default:"#2E89FC",subtle:"#882E89FC"},attention:{default:"#cc3300",subtle:"#DDcc3300"},good:{default:"#54a254",subtle:"#DD54a254"},warning:{default:"#e69500",subtle:"#DDe69500"}}}},actions:{maxActions:5,spacing:E.Spacing.Default,buttonSpacing:10,showCard:{actionMode:E.ShowCardActionMode.Inline,inlineTopMargin:16},actionsOrientation:E.Orientation.Horizontal,actionAlignment:E.ActionAlignment.Left},adaptiveCard:{allowCustomStyle:false},imageSet:{imageSize:E.Size.Medium,maxImageHeight:100},factSet:{title:{color:E.TextColor.Default,size:E.TextSize.Default,isSubtle:false,weight:E.TextWeight.Bolder,wrap:true,maxWidth:150,},value:{color:E.TextColor.Default,size:E.TextSize.Default,isSubtle:false,weight:E.TextWeight.Default,wrap:true,},spacing:10}});}),"./src/enums.ts":(function(m,e,_){"use strict";
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
Object.defineProperty(e,"__esModule",{value:true});var A=(function(){function A(){}A.Default="default";A.Positive="positive";A.Destructive="destructive";return A;}());e.ActionStyle=A;var S;(function(S){S[S["Auto"]=0]="Auto";S[S["Stretch"]=1]="Stretch";S[S["Small"]=2]="Small";S[S["Medium"]=3]="Medium";S[S["Large"]=4]="Large";})(S=e.Size||(e.Size={}));var a;(function(a){a[a["Weight"]=0]="Weight";a[a["Pixel"]=1]="Pixel";})(a=e.SizeUnit||(e.SizeUnit={}));var T;(function(T){T[T["Small"]=0]="Small";T[T["Default"]=1]="Default";T[T["Medium"]=2]="Medium";T[T["Large"]=3]="Large";T[T["ExtraLarge"]=4]="ExtraLarge";})(T=e.TextSize||(e.TextSize={}));var b;(function(b){b[b["Lighter"]=0]="Lighter";b[b["Default"]=1]="Default";b[b["Bolder"]=2]="Bolder";})(b=e.TextWeight||(e.TextWeight={}));var F;(function(F){F[F["Default"]=0]="Default";F[F["Monospace"]=1]="Monospace";})(F=e.FontType||(e.FontType={}));var c;(function(c){c[c["None"]=0]="None";c[c["Small"]=1]="Small";c[c["Default"]=2]="Default";c[c["Medium"]=3]="Medium";c[c["Large"]=4]="Large";c[c["ExtraLarge"]=5]="ExtraLarge";c[c["Padding"]=6]="Padding";})(c=e.Spacing||(e.Spacing={}));var d;(function(d){d[d["Default"]=0]="Default";d[d["Dark"]=1]="Dark";d[d["Light"]=2]="Light";d[d["Accent"]=3]="Accent";d[d["Good"]=4]="Good";d[d["Warning"]=5]="Warning";d[d["Attention"]=6]="Attention";})(d=e.TextColor||(e.TextColor={}));var H;(function(H){H[H["Left"]=0]="Left";H[H["Center"]=1]="Center";H[H["Right"]=2]="Right";})(H=e.HorizontalAlignment||(e.HorizontalAlignment={}));var V;(function(V){V[V["Top"]=0]="Top";V[V["Center"]=1]="Center";V[V["Bottom"]=2]="Bottom";})(V=e.VerticalAlignment||(e.VerticalAlignment={}));var f;(function(f){f[f["Left"]=0]="Left";f[f["Center"]=1]="Center";f[f["Right"]=2]="Right";f[f["Stretch"]=3]="Stretch";})(f=e.ActionAlignment||(e.ActionAlignment={}));var I;(function(I){I[I["Default"]=0]="Default";I[I["Person"]=1]="Person";})(I=e.ImageStyle||(e.ImageStyle={}));var g;(function(g){g[g["Inline"]=0]="Inline";g[g["Popup"]=1]="Popup";})(g=e.ShowCardActionMode||(e.ShowCardActionMode={}));var O;(function(O){O[O["Horizontal"]=0]="Horizontal";O[O["Vertical"]=1]="Vertical";})(O=e.Orientation||(e.Orientation={}));var h;(function(h){h[h["Cover"]=0]="Cover";h[h["RepeatHorizontally"]=1]="RepeatHorizontally";h[h["RepeatVertically"]=2]="RepeatVertically";h[h["Repeat"]=3]="Repeat";})(h=e.FillMode||(e.FillMode={}));var i;(function(i){i[i["LeftOfTitle"]=0]="LeftOfTitle";i[i["AboveTitle"]=1]="AboveTitle";})(i=e.ActionIconPlacement||(e.ActionIconPlacement={}));var j;(function(j){j[j["Text"]=0]="Text";j[j["Tel"]=1]="Tel";j[j["Url"]=2]="Url";j[j["Email"]=3]="Email";})(j=e.InputTextStyle||(e.InputTextStyle={}));var k;(function(k){k[k["Optional"]=0]="Optional";k[k["Required"]=1]="Required";k[k["RequiredWithVisualCue"]=2]="RequiredWithVisualCue";})(k=e.InputValidationNecessity||(e.InputValidationNecessity={}));var C=(function(){function C(){}C.Default="default";C.Emphasis="emphasis";C.Accent="accent";C.Good="good";C.Attention="attention";C.Warning="warning";return C;}());e.ContainerStyle=C;var l;(function(l){l[l["Hint"]=0]="Hint";l[l["ActionTypeNotAllowed"]=1]="ActionTypeNotAllowed";l[l["CollectionCantBeEmpty"]=2]="CollectionCantBeEmpty";l[l["Deprecated"]=3]="Deprecated";l[l["ElementTypeNotAllowed"]=4]="ElementTypeNotAllowed";l[l["InteractivityNotAllowed"]=5]="InteractivityNotAllowed";l[l["InvalidPropertyValue"]=6]="InvalidPropertyValue";l[l["MissingCardType"]=7]="MissingCardType";l[l["PropertyCantBeNull"]=8]="PropertyCantBeNull";l[l["TooManyActions"]=9]="TooManyActions";l[l["UnknownActionType"]=10]="UnknownActionType";l[l["UnknownElementType"]=11]="UnknownElementType";l[l["UnsupportedCardVersion"]=12]="UnsupportedCardVersion";l[l["DuplicateId"]=13]="DuplicateId";})(l=e.ValidationError||(e.ValidationError={}));var n;(function(n){n[n["FullyInContainer"]=0]="FullyInContainer";n[n["Overflowing"]=1]="Overflowing";n[n["FullyOutOfContainer"]=2]="FullyOutOfContainer";})(n=e.ContainerFitStatus||(e.ContainerFitStatus={}));}),"./src/host-config.ts":(function(m,a,_){"use strict";var c=(this&&this.__extends)||(function(){var e=function(d,b){e=Object.setPrototypeOf||({__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b;})||function(d,b){for(var p in b)if(b.hasOwnProperty(p))d[p]=b[p];};return e(d,b);};return function(d,b){e(d,b);function p(){this.constructor=d;}d.prototype=b===null?Object.create(b):(p.prototype=b.prototype,new p());};})();Object.defineProperty(a,"__esModule",{value:true});
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
var E=_("./src/enums.ts");var U=_("./src/utils.ts");var S=_("./src/shared.ts");var C=(function(){function C(d,s){this.default="#000000";this.subtle="#666666";if(d){this.default=d;}if(s){this.subtle=s;}}C.prototype.parse=function(b){if(b){this.default=b["default"]||this.default;this.subtle=b["subtle"]||this.subtle;}};return C;}());a.ColorDefinition=C;var T=(function(b){c(T,b);function T(){var d=b!==null&&b.apply(this,arguments)||this;d.highlightColors=new C("#22000000","#11000000");return d;}T.prototype.parse=function(d){b.prototype.parse.call(this,d);if(d){this.highlightColors.parse(d["highlightColors"]);}};return T;}(C));a.TextColorDefinition=T;var A=(function(){function A(b){this.allowCustomStyle=false;if(b){this.allowCustomStyle=b["allowCustomStyle"]||this.allowCustomStyle;}}return A;}());a.AdaptiveCardConfig=A;var I=(function(){function I(b){this.imageSize=E.Size.Medium;this.maxImageHeight=100;if(b){this.imageSize=b["imageSize"]!=null?b["imageSize"]:this.imageSize;this.maxImageHeight=U.getNumberValue(b["maxImageHeight"],100);}}I.prototype.toJSON=function(){return{imageSize:E.Size[this.imageSize],maxImageHeight:this.maxImageHeight};};return I;}());a.ImageSetConfig=I;var M=(function(){function M(b){this.allowInlinePlayback=true;if(b){this.defaultPoster=b["defaultPoster"];this.allowInlinePlayback=b["allowInlinePlayback"]||this.allowInlinePlayback;}}M.prototype.toJSON=function(){return{defaultPoster:this.defaultPoster,allowInlinePlayback:this.allowInlinePlayback};};return M;}());a.MediaConfig=M;var F=(function(){function F(b){this.size=E.TextSize.Default;this.color=E.TextColor.Default;this.isSubtle=false;this.weight=E.TextWeight.Default;this.wrap=true;if(b){this.size=U.parseHostConfigEnum(E.TextSize,b["size"],E.TextSize.Default);this.color=U.parseHostConfigEnum(E.TextColor,b["color"],E.TextColor.Default);this.isSubtle=b["isSubtle"]||this.isSubtle;this.weight=U.parseHostConfigEnum(E.TextWeight,b["weight"],this.getDefaultWeight());this.wrap=b["wrap"]!=null?b["wrap"]:this.wrap;}};F.prototype.getDefaultWeight=function(){return E.TextWeight.Default;};F.prototype.toJSON=function(){return{size:E.TextSize[this.size],color:E.TextColor[this.color],isSubtle:this.isSubtle,weight:E.TextWeight[this.weight],wrap:this.wrap};};return F;}());a.FactTextDefinition=F;var f=(function(b){c(f,b);function f(d){var e=b.call(this,d)||this;e.maxWidth=150;e.weight=E.TextWeight.Bolder;if(d){e.maxWidth=d["maxWidth"]!=null?d["maxWidth"]:e.maxWidth;e.weight=U.parseHostConfigEnum(E.TextWeight,d["weight"],E.TextWeight.Bolder);}return e;}f.prototype.getDefaultWeight=function(){return E.TextWeight.Bolder;};return f;}(F));a.FactTitleDefinition=f;var g=(function(){function g(b){this.title=new f();this.value=new F();this.spacing=10;if(b){this.title=new f(b["title"]);this.value=new F(b["value"]);this.spacing=b.spacing&&b.spacing!=null?b.spacing&&b.spacing:this.spacing;}}return g;}());a.FactSetConfig=g;var h=(function(){function h(b){this.actionMode=E.ShowCardActionMode.Inline;this.inlineTopMargin=16;this.style=E.ContainerStyle.Emphasis;if(b){this.actionMode=U.parseHostConfigEnum(E.ShowCardActionMode,b["actionMode"],E.ShowCardActionMode.Inline);this.inlineTopMargin=b["inlineTopMargin"]!=null?b["inlineTopMargin"]:this.inlineTopMargin;this.style=b["style"]&&typeof b["style"]==="string"?b["style"]:E.ContainerStyle.Emphasis;}}h.prototype.toJSON=function(){return{actionMode:E.ShowCardActionMode[this.actionMode],inlineTopMargin:this.inlineTopMargin,style:this.style};};return h;}());a.ShowCardActionConfig=h;var i=(function(){function i(b){this.maxActions=5;this.spacing=E.Spacing.Default;this.buttonSpacing=20;this.showCard=new h();this.preExpandSingleShowCardAction=false;this.actionsOrientation=E.Orientation.Horizontal;this.actionAlignment=E.ActionAlignment.Left;this.iconPlacement=E.ActionIconPlacement.LeftOfTitle;this.allowTitleToWrap=false;this.iconSize=24;if(b){this.maxActions=b["maxActions"]!=null?b["maxActions"]:this.maxActions;this.spacing=U.parseHostConfigEnum(E.Spacing,b.spacing&&b.spacing,E.Spacing.Default);this.buttonSpacing=b["buttonSpacing"]!=null?b["buttonSpacing"]:this.buttonSpacing;this.showCard=new h(b["showCard"]);this.preExpandSingleShowCardAction=U.getBoolValue(b["preExpandSingleShowCardAction"],false);this.actionsOrientation=U.parseHostConfigEnum(E.Orientation,b["actionsOrientation"],E.Orientation.Horizontal);this.actionAlignment=U.parseHostConfigEnum(E.ActionAlignment,b["actionAlignment"],E.ActionAlignment.Left);this.iconPlacement=U.parseHostConfigEnum(E.ActionIconPlacement,b["iconPlacement"],E.ActionIconPlacement.LeftOfTitle);this.allowTitleToWrap=b["allowTitleToWrap"]!=null?b["allowTitleToWrap"]:this.allowTitleToWrap;try{var s=S.SizeAndUnit.parse(b["iconSize"]);if(s.unit==E.SizeUnit.Pixel){this.iconSize=s.physicalSize;}}catch(e){}}}i.prototype.toJSON=function(){return{maxActions:this.maxActions,spacing:E.Spacing[this.spacing],buttonSpacing:this.buttonSpacing,showCard:this.showCard,preExpandSingleShowCardAction:this.preExpandSingleShowCardAction,actionsOrientation:E.Orientation[this.actionsOrientation],actionAlignment:E.ActionAlignment[this.actionAlignment]};};return i;}());a.ActionsConfig=i;var j=(function(){function j(b){this.default=new T();this.dark=new T();this.light=new T();this.accent=new T();this.good=new T();this.warning=new T();this.attention=new T();this.parse(b);}j.prototype.parseSingleColor=function(b,p){if(b){this[p].parse(b[p]);}};j.prototype.parse=function(b){if(b){this.parseSingleColor(b,"default");this.parseSingleColor(b,"dark");this.parseSingleColor(b,"light");this.parseSingleColor(b,"accent");this.parseSingleColor(b,"good");this.parseSingleColor(b,"warning");this.parseSingleColor(b,"attention");}};return j;}());a.ColorSetDefinition=j;var k=(function(){function k(b){this.foregroundColors=new j({"default":{default:"#333333",subtle:"#EE333333"},"dark":{default:"#000000",subtle:"#66000000"},"light":{default:"#FFFFFF",subtle:"#33000000"},"accent":{default:"#2E89FC",subtle:"#882E89FC"},"good":{default:"#54A254",subtle:"#DD54A254"},"warning":{default:"#E69500",subtle:"#DDE69500"},"attention":{default:"#CC3300",subtle:"#DDCC3300"}});this.parse(b);}k.prototype.parse=function(b){if(b){this.backgroundColor=b["backgroundColor"];this.foregroundColors.parse(b["foregroundColors"]);this.highlightBackgroundColor=b["highlightBackgroundColor"];this.highlightForegroundColor=b["highlightForegroundColor"];}};Object.defineProperty(k.prototype,"isBuiltIn",{get:function(){return false;},enumerable:true,configurable:true});return k;}());a.ContainerStyleDefinition=k;var B=(function(b){c(B,b);function B(){return b!==null&&b.apply(this,arguments)||this;}Object.defineProperty(B.prototype,"isBuiltIn",{get:function(){return true;},enumerable:true,configurable:true});return B;}(k));var l=(function(){function l(b){this._allStyles={};this._allStyles[E.ContainerStyle.Default]=new B();this._allStyles[E.ContainerStyle.Emphasis]=new B();this._allStyles[E.ContainerStyle.Accent]=new B();this._allStyles[E.ContainerStyle.Good]=new B();this._allStyles[E.ContainerStyle.Attention]=new B();this._allStyles[E.ContainerStyle.Warning]=new B();if(b){this._allStyles[E.ContainerStyle.Default].parse(b[E.ContainerStyle.Default]);this._allStyles[E.ContainerStyle.Emphasis].parse(b[E.ContainerStyle.Emphasis]);this._allStyles[E.ContainerStyle.Accent].parse(b[E.ContainerStyle.Accent]);this._allStyles[E.ContainerStyle.Good].parse(b[E.ContainerStyle.Good]);this._allStyles[E.ContainerStyle.Attention].parse(b[E.ContainerStyle.Attention]);this._allStyles[E.ContainerStyle.Warning].parse(b[E.ContainerStyle.Warning]);var d=b["customStyles"];if(d&&Array.isArray(d)){for(var e=0,p=d;e<p.length;e++){var r=p[e];if(r){var s=r["name"];if(s&&typeof s==="string"){if(this._allStyles.hasOwnProperty(s)){this._allStyles[s].parse(r["style"]);}else{this._allStyles[s]=new k(r["style"]);}}}}}}}l.prototype.toJSON=function(){var b=this;var d=[];Object.keys(this._allStyles).forEach(function(e){if(!b._allStyles[e].isBuiltIn){d.push({name:e,style:b._allStyles[e]});}});var r={default:this.default,emphasis:this.emphasis};if(d.length>0){r.customStyles=d;}return r;};l.prototype.getStyleByName=function(b,d){if(d===void 0){d=null;}return this._allStyles.hasOwnProperty(b)?this._allStyles[b]:d;};Object.defineProperty(l.prototype,"default",{get:function(){return this._allStyles[E.ContainerStyle.Default];},enumerable:true,configurable:true});Object.defineProperty(l.prototype,"emphasis",{get:function(){return this._allStyles[E.ContainerStyle.Emphasis];},enumerable:true,configurable:true});return l;}());a.ContainerStyleSet=l;var V=(function(){function V(b,d,e){if(b===void 0){b=1;}if(d===void 0){d=1;}this._isValid=true;this._major=b;this._minor=d;this._label=e;}V.parse=function(v,e){if(!v){return null;}var r=new V();r._versionString=v;var b=/(\d+).(\d+)/gi;var d=b.exec(v);if(d!=null&&d.length==3){r._major=parseInt(d[1]);r._minor=parseInt(d[2]);}else{r._isValid=false;}if(!r._isValid&&e){e.push({error:E.ValidationError.InvalidPropertyValue,message:"Invalid version string: "+r._versionString});}return r;};V.prototype.toString=function(){return!this._isValid?this._versionString:this._major+"."+this._minor;};V.prototype.compareTo=function(b){if(!this.isValid||!b.isValid){throw new Error("Cannot compare invalid version.");}if(this.major>b.major){return 1;}else if(this.major<b.major){return-1;}else if(this.minor>b.minor){return 1;}else if(this.minor<b.minor){return-1;}return 0;};Object.defineProperty(V.prototype,"label",{get:function(){return this._label?this._label:this.toString();},enumerable:true,configurable:true});Object.defineProperty(V.prototype,"major",{get:function(){return this._major;},enumerable:true,configurable:true});Object.defineProperty(V.prototype,"minor",{get:function(){return this._minor;},enumerable:true,configurable:true});Object.defineProperty(V.prototype,"isValid",{get:function(){return this._isValid;},enumerable:true,configurable:true});return V;}());a.Version=V;var H=(function(){function H(){this.capabilities=null;}H.prototype.setCapability=function(b,v){if(!this.capabilities){this.capabilities={};}this.capabilities[b]=v;};H.prototype.parse=function(b,e){if(b){for(var d in b){var p=b[d];if(typeof p==="string"){if(p=="*"){this.setCapability(d,"*");}else{var v=V.parse(p,e);if(v.isValid){this.setCapability(d,v);}}}}}};H.prototype.hasCapability=function(b,v){if(this.capabilities&&this.capabilities.hasOwnProperty(b)){if(v=="*"||this.capabilities[b]=="*"){return true;}return v.compareTo(this.capabilities[b])<=0;}return false;};H.prototype.areAllMet=function(b){if(this.capabilities){for(var d in this.capabilities){if(!b.hasCapability(d,this.capabilities[d])){return false;}}}return true;};return H;}());a.HostCapabilities=H;var n=(function(){function n(b){this.fontFamily="Segoe UI,Segoe,Segoe WP,Helvetica Neue,Helvetica,sans-serif";this.fontSizes={small:12,default:14,medium:17,large:21,extraLarge:26};this.fontWeights={lighter:200,default:400,bolder:600};if(b){this.fontFamily=b;}}n.prototype.parse=function(b){this.fontFamily=b["fontFamily"]||this.fontFamily;this.fontSizes={small:b.fontSizes&&b.fontSizes["small"]||this.fontSizes.small,default:b.fontSizes&&b.fontSizes["default"]||this.fontSizes.default,medium:b.fontSizes&&b.fontSizes["medium"]||this.fontSizes.medium,large:b.fontSizes&&b.fontSizes["large"]||this.fontSizes.large,extraLarge:b.fontSizes&&b.fontSizes["extraLarge"]||this.fontSizes.extraLarge};this.fontWeights={lighter:b.fontWeights&&b.fontWeights["lighter"]||this.fontWeights.lighter,default:b.fontWeights&&b.fontWeights["default"]||this.fontWeights.default,bolder:b.fontWeights&&b.fontWeights["bolder"]||this.fontWeights.bolder};};n.monospace=new n("'Courier New', Courier, monospace");return n;}());a.FontTypeDefinition=n;var o=(function(){function o(b){this.default=new n();this.monospace=new n("'Courier New', Courier, monospace");if(b){this.default.parse(b["default"]);this.monospace.parse(b["monospace"]);}}o.prototype.getStyleDefinition=function(s){switch(s){case E.FontType.Monospace:return this.monospace;case E.FontType.Default:default:return this.default;}};return o;}());a.FontTypeSet=o;var q=(function(){function q(b){this.hostCapabilities=new H();this.choiceSetInputValueSeparator=",";this.supportsInteractivity=true;this.fontTypes=null;this.spacing={small:3,default:8,medium:20,large:30,extraLarge:40,padding:15};this.separator={lineThickness:1,lineColor:"#EEEEEE"};this.imageSizes={small:40,medium:80,large:160};this.containerStyles=new l();this.actions=new i();this.adaptiveCard=new A();this.imageSet=new I();this.media=new M();this.factSet=new g();this.cssClassNamePrefix=null;this.alwaysAllowBleed=false;if(b){if(typeof b==="string"||b instanceof String){b=JSON.parse(b);}this.choiceSetInputValueSeparator=(b&&typeof b["choiceSetInputValueSeparator"]==="string")?b["choiceSetInputValueSeparator"]:this.choiceSetInputValueSeparator;this.supportsInteractivity=(b&&typeof b["supportsInteractivity"]==="boolean")?b["supportsInteractivity"]:this.supportsInteractivity;this._legacyFontType=new n();this._legacyFontType.parse(b);if(b.fontTypes){this.fontTypes=new o(b.fontTypes);}if(b.lineHeights){this.lineHeights={small:b.lineHeights["small"],default:b.lineHeights["default"],medium:b.lineHeights["medium"],large:b.lineHeights["large"],extraLarge:b.lineHeights["extraLarge"]};};this.imageSizes={small:b.imageSizes&&b.imageSizes["small"]||this.imageSizes.small,medium:b.imageSizes&&b.imageSizes["medium"]||this.imageSizes.medium,large:b.imageSizes&&b.imageSizes["large"]||this.imageSizes.large,};this.containerStyles=new l(b["containerStyles"]);this.spacing={small:b.spacing&&b.spacing["small"]||this.spacing.small,default:b.spacing&&b.spacing["default"]||this.spacing.default,medium:b.spacing&&b.spacing["medium"]||this.spacing.medium,large:b.spacing&&b.spacing["large"]||this.spacing.large,extraLarge:b.spacing&&b.spacing["extraLarge"]||this.spacing.extraLarge,padding:b.spacing&&b.spacing["padding"]||this.spacing.padding};this.separator={lineThickness:b.separator&&b.separator["lineThickness"]||this.separator.lineThickness,lineColor:b.separator&&b.separator["lineColor"]||this.separator.lineColor};this.actions=new i(b.actions||this.actions);this.adaptiveCard=new A(b.adaptiveCard||this.adaptiveCard);this.imageSet=new I(b["imageSet"]);this.factSet=new g(b["factSet"]);}}q.prototype.getFontTypeDefinition=function(s){if(this.fontTypes){return this.fontTypes.getStyleDefinition(s);}else{return s==E.FontType.Monospace?n.monospace:this._legacyFontType;}};q.prototype.getEffectiveSpacing=function(s){switch(s){case E.Spacing.Small:return this.spacing.small;case E.Spacing.Default:return this.spacing.default;case E.Spacing.Medium:return this.spacing.medium;case E.Spacing.Large:return this.spacing.large;case E.Spacing.ExtraLarge:return this.spacing.extraLarge;case E.Spacing.Padding:return this.spacing.padding;default:return 0;}};q.prototype.paddingDefinitionToSpacingDefinition=function(p){return new S.SpacingDefinition(this.getEffectiveSpacing(p.top),this.getEffectiveSpacing(p.right),this.getEffectiveSpacing(p.bottom),this.getEffectiveSpacing(p.left));};q.prototype.makeCssClassNames=function(){var b=[];for(var d=0;d<arguments.length;d++){b[d]=arguments[d];}var r=[];for(var e=0,p=b;e<p.length;e++){var s=p[e];r.push((this.cssClassNamePrefix?this.cssClassNamePrefix+"-":"")+s);}return r;};q.prototype.makeCssClassName=function(){var b=[];for(var d=0;d<arguments.length;d++){b[d]=arguments[d];}var r=this.makeCssClassNames.apply(this,b).join(" ");return r?r:"";};Object.defineProperty(q.prototype,"fontFamily",{get:function(){return this._legacyFontType.fontFamily;},set:function(v){this._legacyFontType.fontFamily=v;},enumerable:true,configurable:true});Object.defineProperty(q.prototype,"fontSizes",{get:function(){return this._legacyFontType.fontSizes;},enumerable:true,configurable:true});Object.defineProperty(q.prototype,"fontWeights",{get:function(){return this._legacyFontType.fontWeights;},enumerable:true,configurable:true});return q;}());a.HostConfig=q;}),"./src/shared.ts":(function(m,e,_){"use strict";Object.defineProperty(e,"__esModule",{value:true});
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
var E=_("./src/enums.ts");e.ContentTypes={applicationJson:"application/json",applicationXWwwFormUrlencoded:"application/x-www-form-urlencoded"};var S=(function(){function S(){this._isProcessed=false;this._original=null;this._processed=null;}S.prototype.getReferencedInputs=function(i,r){if(!r){throw new Error("The referencedInputs parameter cannot be null.");}for(var c=0,d=i;c<d.length;c++){var f=d[c];var g=new RegExp("\\{{2}("+f.id+").value\\}{2}","gi").exec(this._original);if(g!=null){r[f.id]=f;}}};S.prototype.substituteInputValues=function(i,c){this._processed=this._original;var r=/\{{2}([a-z0-9_$@]+).value\}{2}/gi;var d;while((d=r.exec(this._original))!=null){var f=null;for(var g=0,h=Object.keys(i);g<h.length;g++){var k=h[g];if(k.toLowerCase()==d[1].toLowerCase()){f=i[k];break;}}if(f){var v="";if(f.value){v=f.value;}if(c===e.ContentTypes.applicationJson){v=JSON.stringify(v);v=v.slice(1,-1);}else if(c===e.ContentTypes.applicationXWwwFormUrlencoded){v=encodeURIComponent(v);}this._processed=this._processed.replace(d[0],v);}};this._isProcessed=true;};S.prototype.getOriginal=function(){return this._original;};S.prototype.get=function(){if(!this._isProcessed){return this._original;}else{return this._processed;}};S.prototype.set=function(v){this._original=v;this._isProcessed=false;};return S;}());e.StringWithSubstitutions=S;var a=(function(){function a(t,r,c,l){if(t===void 0){t=0;}if(r===void 0){r=0;}if(c===void 0){c=0;}if(l===void 0){l=0;}this.left=0;this.top=0;this.right=0;this.bottom=0;this.top=t;this.right=r;this.bottom=c;this.left=l;}return a;}());e.SpacingDefinition=a;var P=(function(){function P(t,r,c,l){if(t===void 0){t=E.Spacing.None;}if(r===void 0){r=E.Spacing.None;}if(c===void 0){c=E.Spacing.None;}if(l===void 0){l=E.Spacing.None;}this.top=E.Spacing.None;this.right=E.Spacing.None;this.bottom=E.Spacing.None;this.left=E.Spacing.None;this.top=t;this.right=r;this.bottom=c;this.left=l;}return P;}());e.PaddingDefinition=P;var b=(function(){function b(p,u){this.physicalSize=p;this.unit=u;}b.parse=function(i,r){if(r===void 0){r=false;}var c=new b(0,E.SizeUnit.Weight);var d=/^([0-9]+)(px|\*)?$/g;var f=d.exec(i);var g=r?3:2;if(f&&f.length>=g){c.physicalSize=parseInt(f[1]);if(f.length==3){if(f[2]=="px"){c.unit=E.SizeUnit.Pixel;}}return c;}throw new Error("Invalid size: "+i);};return b;}());e.SizeAndUnit=b;
/**
				 * Fast UUID generator, RFC4122 version 4 compliant.
				 * @author Jeff Ward (jcward.com).
				 * @license MIT license
				 * @link http://stackoverflow.com/questions/105034/how-to-create-a-guid-uuid-in-javascript/21963136#21963136
				 **/
var U=(function(){function U(){}U.generate=function(){var d=Math.random()*0xffffffff|0;var c=Math.random()*0xffffffff|0;var f=Math.random()*0xffffffff|0;var g=Math.random()*0xffffffff|0;return U.lut[d&0xff]+U.lut[d>>8&0xff]+U.lut[d>>16&0xff]+U.lut[d>>24&0xff]+'-'+U.lut[c&0xff]+U.lut[c>>8&0xff]+'-'+U.lut[c>>16&0x0f|0x40]+U.lut[c>>24&0xff]+'-'+U.lut[f&0x3f|0x80]+U.lut[f>>8&0xff]+'-'+U.lut[f>>16&0xff]+U.lut[f>>24&0xff]+U.lut[g&0xff]+U.lut[g>>8&0xff]+U.lut[g>>16&0xff]+U.lut[g>>24&0xff];};U.initialize=function(){for(var i=0;i<256;i++){U.lut[i]=(i<16?'0':'')+i.toString(16);}};U.lut=[];return U;}());e.UUID=U;U.initialize();}),"./src/text-formatters.ts":(function(m,e,_){"use strict";var a=(this&&this.__extends)||(function(){var c=function(d,b){c=Object.setPrototypeOf||({__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b;})||function(d,b){for(var p in b)if(b.hasOwnProperty(p))d[p]=b[p];};return c(d,b);};return function(d,b){c(d,b);function g(){this.constructor=d;}d.prototype=b===null?Object.create(b):(g.prototype=b.prototype,new g());};})();Object.defineProperty(e,"__esModule",{value:true});
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
var A=(function(){function A(r){this._regularExpression=r;}A.prototype.format=function(l,i){var b;var r=i;while((b=this._regularExpression.exec(i))!=null){r=r.replace(b[0],this.internalFormat(l,b));};return r;};return A;}());var D=(function(b){a(D,b);function D(){return b!==null&&b.apply(this,arguments)||this;}D.prototype.internalFormat=function(l,c){var d=new Date(Date.parse(c[1]));var g=c[2]!=undefined?c[2].toLowerCase():"compact";if(g!="compact"){return d.toLocaleDateString(l,{day:"numeric",weekday:g,month:g,year:"numeric"});}else{return d.toLocaleDateString();}};return D;}(A));var T=(function(b){a(T,b);function T(){return b!==null&&b.apply(this,arguments)||this;}T.prototype.internalFormat=function(l,c){var d=new Date(Date.parse(c[1]));return d.toLocaleTimeString(l,{hour:'numeric',minute:'2-digit'});};return T;}(A));function f(l,t){var b=[new D(/\{{2}DATE\((\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}(?:Z|(?:(?:-|\+)\d{2}:\d{2})))(?:, ?(COMPACT|LONG|SHORT))?\)\}{2}/g),new T(/\{{2}TIME\((\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}(?:Z|(?:(?:-|\+)\d{2}:\d{2})))\)\}{2}/g)];var r=t;for(var i=0;i<b.length;i++){r=b[i].format(l,r);}return r;}e.formatText=f;}),"./src/utils.ts":(function(m,e,_){"use strict";Object.defineProperty(e,"__esModule",{value:true});
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
var E=_("./src/enums.ts");var S=_("./src/shared.ts");function c(){return"__ac-"+S.UUID.generate();}e.generateUniqueId=c;function i(a){return a===undefined||a===null||a==="";}e.isNullOrEmpty=i;function d(a,b){if(b!=null&&b!=undefined){a.appendChild(b);}}e.appendChild=d;function f(a,b){if(b===void 0){b=undefined;}return typeof a==="string"?a.toString():b;}e.getStringValue=f;function h(a,b){if(b===void 0){b=undefined;}return typeof a==="number"?a:b;}e.getNumberValue=h;function j(a,b){if(typeof a==="boolean"){return a;}else if(typeof a==="string"){switch(a.toLowerCase()){case"true":return true;case"false":return false;default:return b;}}return b;}e.getBoolValue=j;function k(a,b,g){if(i(b)){return g;}for(var r in a){var y=parseInt(r,10)>=0;if(y){var z=a[r];if(z&&typeof z==="string"){if(z.toLowerCase()===b.toLowerCase()){return parseInt(r,10);}}}}return g;}e.getEnumValue=k;function s(a,b,g,r){if(r===void 0){r=undefined;}if(g===null||g===undefined||g===r){delete a[b];}else{a[b]=g;}}e.setProperty=s;function l(a,b,g,r){if(r===void 0){r=undefined;}if(g===null||g===undefined||g===r||isNaN(g)){delete a[b];}else{a[b]=g;}}e.setNumberProperty=l;function n(a,b,g,r,y){if(y===void 0){y=undefined;}var z=b[g];var A=z==undefined?true:a[z]!==undefined;if(r==y){if(A){delete b[g];}}else{if(r==undefined){if(A){delete b[g];}}else{b[g]=a[r];}}}e.setEnumProperty=n;function o(a,b,g){var r=[];if(g){for(var y=0,z=g;y<z.length;y++){var A=z[y];r.push(A.toJSON());}}if(r.length==0){if(a.hasOwnProperty(b)&&Array.isArray(a[b])){delete a[b];}}else{s(a,b,r);}}e.setArrayProperty=o;function p(a,b,g){if(typeof b==="string"){return k(a,b,g);}else if(typeof b==="number"){return b;}else{return g;}}e.parseHostConfigEnum=p;function q(a,b,g){if(b.spacing>0||b.lineThickness>0){var r=document.createElement("div");r.className=a.makeCssClassName("ac-"+(g==E.Orientation.Horizontal?"horizontal":"vertical")+"-separator");if(g==E.Orientation.Horizontal){if(b.lineThickness){r.style.paddingTop=(b.spacing/2)+"px";r.style.marginBottom=(b.spacing/2)+"px";r.style.borderBottom=b.lineThickness+"px solid "+t(b.lineColor);}else{r.style.height=b.spacing+"px";}}else{if(b.lineThickness){r.style.paddingLeft=(b.spacing/2)+"px";r.style.marginRight=(b.spacing/2)+"px";r.style.borderRight=b.lineThickness+"px solid "+t(b.lineColor);}else{r.style.width=b.spacing+"px";}}r.style.overflow="hidden";return r;}else{return null;}}e.renderSeparation=q;function t(y){var z=/#([0-9A-F]{2})([0-9A-F]{2})([0-9A-F]{2})([0-9A-F]{2})?/gi;var A=z.exec(y);if(A&&A[4]){var a=parseInt(A[1],16)/255;var r=parseInt(A[2],16);var g=parseInt(A[3],16);var b=parseInt(A[4],16);return"rgba("+r+","+g+","+b+","+a+")";}else{return y;}}e.stringToCssColor=t;function u(a,b,g){var r=function(){return b-a.scrollHeight>=-1.0;};if(r())return;var y=a.innerHTML;var z=function(G){a.innerHTML=y.substring(0,G)+'...';};var A=v(y);var B=0;var C=A.length;var D=0;while(B<C){var F=Math.floor((B+C)/2);z(A[F]);if(r()){D=A[F];B=F+1;}else{C=F;}}z(D);if(g&&b-a.scrollHeight>=g-1.0){var G=w(y,D);while(G<y.length){z(G);if(r()){D=G;G=w(y,G);}else{break;}}z(D);}}e.truncate=u;function v(a){var r=[];var b=w(a,-1);while(b<a.length){if(a[b]==' '){r.push(b);}b=w(a,b);}return r;}function w(a,b){b+=1;while(b<a.length&&a[b]=='<'){while(b<a.length&&a[b++]!='>');}return b;}function x(a,b){var g=a.offsetTop;var r=g+a.clientHeight;if(r<=b){return E.ContainerFitStatus.FullyInContainer;}else if(g<b){return E.ContainerFitStatus.Overflowing;}else{return E.ContainerFitStatus.FullyOutOfContainer;}}e.getFitStatus=x;})});});
