/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/Interface","sap/ui/thirdparty/jquery","sap/ui/core/Core","sap/ui/integration/util/Manifest","sap/ui/integration/util/ServiceManager","sap/base/Log","sap/base/util/merge","sap/base/util/deepEqual","sap/ui/integration/util/DataProviderFactory","sap/m/HBox","sap/ui/core/Icon","sap/m/Text","sap/ui/model/json/JSONModel","sap/ui/model/resource/ResourceModel","sap/ui/integration/util/ContextModel","sap/base/util/LoaderExtensions","sap/f/CardRenderer","sap/f/CardBase","sap/f/library","sap/ui/integration/library","sap/ui/integration/util/Destinations","sap/ui/integration/util/LoadingProvider","sap/ui/integration/util/HeaderFactory","sap/ui/integration/util/ContentFactory","sap/ui/integration/util/BindingHelper","sap/ui/integration/util/BindingResolver","sap/ui/integration/formatters/IconFormatter","sap/ui/integration/util/FilterBarFactory","sap/ui/integration/util/CardActions"],function(I,q,C,a,S,L,m,d,D,H,b,T,J,R,c,e,F,f,l,g,h,i,j,k,B,n,o,p,r){"use strict";var M={TYPE:"/sap.card/type",DATA:"/sap.card/data",HEADER:"/sap.card/header",HEADER_POSITION:"/sap.card/headerPosition",CONTENT:"/sap.card/content",SERVICES:"/sap.ui5/services",APP_TYPE:"/sap.app/type",PARAMS:"/sap.card/configuration/parameters",DESTINATIONS:"/sap.card/configuration/destinations",FILTERS:"/sap.card/configuration/filters"};var s=l.cards.HeaderPosition;var t=g.CardDataMode;var u=f.extend("sap.ui.integration.widgets.Card",{metadata:{library:"sap.ui.integration",properties:{manifest:{type:"any",defaultValue:""},parameters:{type:"object",defaultValue:null},dataMode:{type:"sap.ui.integration.CardDataMode",group:"Behavior",defaultValue:t.Active},baseUrl:{type:"sap.ui.core.URI",defaultValue:null},manifestChanges:{type:"object[]"}},aggregations:{_header:{type:"sap.f.cards.IHeader",multiple:false,visibility:"hidden"},_filterBar:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_content:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_extension:{type:"sap.ui.integration.Extension",multiple:false,visibility:"hidden"}},events:{action:{allowPreventDefault:true,parameters:{actionSource:{type:"sap.ui.core.Control"},manifestParameters:{type:"object"},parameters:{type:"object"},type:{type:"sap.ui.integration.CardActionType"}}},manifestReady:{parameters:{}}},associations:{host:{}}},renderer:F});u.prototype.init=function(){f.prototype.init.call(this);this.setModel(new J(),"parameters");this.setModel(new J(),"filters");this.setModel(new c(),"context");this._busyStates=new Map();this._oContentFactory=new k(this);this._oLimitedInterface=new I(this,["getParameters","getCombinedParameters","getManifestEntry","resolveDestination","request","showMessage","getBaseUrl","getTranslatedText","getModel","triggerAction"]);};u.prototype._initReadyState=function(){this._aReadyPromises=[];this._awaitEvent("_headerReady");this._awaitEvent("_filterBarReady");this._awaitEvent("_contentReady");this._awaitEvent("_cardReady");Promise.all(this._aReadyPromises).then(function(){this._bReady=true;this.fireEvent("_ready");}.bind(this));};u.prototype._clearReadyState=function(){this._bReady=false;this._aReadyPromises=[];};u.prototype.onBeforeRendering=function(){if(this.getDataMode()!==t.Active){return;}if(this._bApplyManifest||this._bApplyParameters){this._clearReadyState();this._initReadyState();}if(this._bApplyManifest){var v=this.getManifest();if(!v){this.destroyManifest();}else{this.createManifest(v,this.getBaseUrl());}}if(!this._bApplyManifest&&this._bApplyParameters){this._oCardManifest.processParameters(this._getContextAndRuntimeParams());this._applyManifestSettings();}this._bApplyManifest=false;this._bApplyParameters=false;};u.prototype.setManifest=function(v){this.setProperty("manifest",v);this._bApplyManifest=true;return this;};u.prototype.setManifestChanges=function(v){this.setProperty("manifestChanges",v);this._bApplyManifest=true;return this;};u.prototype.setParameters=function(v){this.setProperty("parameters",v);this._bApplyParameters=true;return this;};u.prototype.setParameter=function(K,v){var P=this.getParameters()||{};P[K]=v;this.setParameters(P);return this;};u.prototype.setHost=function(v){this.setAssociation("host",v);var w=this.getHostInstance();this.getModel("context").setHost(w);if(this._oDestinations){this._oDestinations.setHost(w);}return this;};u.prototype.createManifest=function(v,w){var O={};this._isManifestReady=false;if(typeof v==="string"){O.manifestUrl=v;v=null;}if(this._oCardManifest){this._oCardManifest.destroy();}this._oCardManifest=new a("sap.card",v,w,this.getManifestChanges());this._oCardManifest.load(O).then(function(){this._registerManifestModulePath();this._isManifestReady=true;this.fireManifestReady();return this._loadExtension();}.bind(this)).then(this._applyManifest.bind(this)).catch(this._applyManifest.bind(this));};u.prototype._loadExtension=function(){var E=this._oCardManifest.get("/sap.card/extension");if(!E){return null;}var v=this._oCardManifest.get("/sap.app/id").replace(/\./g,"/")+"/"+E;return new Promise(function(w,x){sap.ui.require([v],function(y){var z=new y();z._setCard(this,this._oLimitedInterface);this.setAggregation("_extension",z);B.addNamespace("extension",{formatters:z.getFormatters()});w();}.bind(this),function(y){L.error("Failed to load "+E+". Check if the path is correct.");x(y);});}.bind(this));};u.prototype._applyManifest=function(){var v=this._oCardManifest;if(v&&v.getResourceBundle()){this._enhanceI18nModel(v.getResourceBundle());}if(this._hasContextParams()){this._resolveContextParams().then(function(w){this._oContextParameters=w;this._applyManifestWithParams();}.bind(this));return;}this._applyManifestWithParams();};u.prototype._applyManifestWithParams=function(){var v=this._oCardManifest,P=this._getContextAndRuntimeParams();v.processParameters(P);this._prepareToApplyManifestSettings();this._applyManifestSettings();};u.prototype._loadDefaultTranslations=function(){if(this._defaultTranslationsLoaded){return;}var v=C.getLibraryResourceBundle("sap.ui.integration");this._enhanceI18nModel(v);this._defaultTranslationsLoaded=true;};u.prototype._enhanceI18nModel=function(v){var w=this.getModel("i18n");if(w){w.enhance(v);return;}w=new R({bundle:v});this.setModel(w,"i18n");};u.prototype._hasContextParams=function(){var v=this._oCardManifest.get(M.PARAMS),K,V;for(K in v){V=v[K].value;if(typeof V==="string"&&V.indexOf("{context>")!==-1){return true;}}return false;};u.prototype._resolveContextParams=function(){var v=this.getModel("context"),w=this._oCardManifest.get(M.PARAMS),x={},K,V;for(K in w){V=w[K].value;if(typeof V==="string"&&V.indexOf("{context>")!==-1){x[K]=V;}}n.resolveValue(x,this,"/");return v.waitForPendingProperties().then(function(){return n.resolveValue(x,this,"/");}.bind(this));};u.prototype._getContextAndRuntimeParams=function(){var v=this._oContextParameters||{},w=this.getParameters()||{};return m(v,w);};u.prototype._awaitEvent=function(E){this._aReadyPromises.push(new Promise(function(v){this.attachEventOnce(E,function(){v();});}.bind(this)));};u.prototype.isReady=function(){return this._bReady;};u.prototype.refresh=function(){if(this.getDataMode()===t.Active){this._clearReadyState();this._initReadyState();this.destroyManifest();this._bApplyManifest=true;this.invalidate();}};u.prototype._refreshActionsMenu=function(){var v=this.getCardHeader(),w=this.getHostInstance(),E=this.getAggregation("_extension"),A=[],x,y,z;if(!v){return;}x=v.getToolbar();if(x){if(w){A=A.concat(w.getActions()||[]);}if(E){A=A.concat(E.getActions()||[]);}if(d(A,x._aActions)){return;}}y=new j(this);z=y._createActionsToolbar();if(z){v.setToolbar(z);}};u.prototype.exit=function(){f.prototype.exit.call(this);this.destroyManifest();this._busyStates=null;this._oContentFactory=null;};u.prototype.destroyManifest=function(){if(this._oCardManifest){this._oCardManifest.destroy();this._oCardManifest=null;}if(this._oServiceManager){this._oServiceManager.destroy();this._oServiceManager=null;}if(this._oDataProviderFactory){this._oDataProviderFactory.destroy();this._oDataProviderFactory=null;this._oDataProvider=null;}if(this._oLoadingProvider){this._oLoadingProvider.destroy();this._oLoadingProvider=null;}if(this._oTemporaryContent){this._oTemporaryContent.destroy();this._oTemporaryContent=null;}if(this._oDestinations){this._oDestinations.destroy();this._oDestinations=null;}if(this._oIconFormatter){this._oIconFormatter.destroy();this._oIconFormatter=null;}this.destroyAggregation("_header");this.destroyAggregation("_filterBar");this.destroyAggregation("_content");this._aReadyPromises=null;this._busyStates.clear();this.getModel("filters").setData({});this._oContextParameters=null;};u.prototype._registerManifestModulePath=function(){if(!this._oCardManifest){return;}this._sAppId=this._oCardManifest.get("/sap.app/id");if(this._sAppId){e.registerResourcePath(this._sAppId.replace(/\./g,"/"),this._oCardManifest.getUrl());}else{L.error("Card sap.app/id entry in the manifest is mandatory");}};u.prototype.getManifest=function(){var v=this.getProperty("manifest");if(v&&typeof v==="object"){return q.extend(true,{},v);}return v;};u.prototype.getParameters=function(){var v=this.getProperty("parameters");if(v&&typeof v==="object"){return q.extend(true,{},v);}return v;};u.prototype.getCombinedParameters=function(){if(!this._isManifestReady){L.error("The manifest is not ready. Consider using the 'manifestReady' event.","sap.ui.integration.widgets.Card");return null;}var P=this._oCardManifest.getProcessedParameters(this._getContextAndRuntimeParams()),v={},K;for(K in P){v[K]=P[K].value;}return v;};u.prototype.getManifestEntry=function(P){if(!this._isManifestReady){L.error("The manifest is not ready. Consider using the 'manifestReady' event.","sap.ui.integration.widgets.Card");return null;}return this._oCardManifest.get(P);};u.prototype.getManifestWithMergedChanges=function(){if(!this._oCardManifest||!this._oCardManifest._oManifest){L.error("The manifest is not ready. Consider using the 'manifestReady' event.","sap.ui.integration.widgets.Card");return{};}return q.extend(true,{},this._oCardManifest._oManifest.getRawJson());};u.prototype.resolveDestination=function(K){return this._oDestinations.getUrl(K);};u.prototype.showMessage=function(v,w){var x=this.getCardContent();if(!x||!x.showMessage){L.error("The experimental feature 'showMessage' is currently available only for an Adaptive Card.");return;}x.showMessage(v,w);};u.prototype.getTranslatedText=function(K,A,v){var w=this.getModel("i18n"),x;if(!w){L.warning("There are no translations available. Either the i18n configuration is missing or the method is called too early.");return null;}x=w.getResourceBundle();return x.getText(K,A,v);};u.prototype._prepareToApplyManifestSettings=function(){var A=this._oCardManifest.get(M.APP_TYPE),E=this.getAggregation("_extension");if(A&&A!=="card"){L.error("sap.app/type entry in manifest is not 'card'");}if(this._oDataProviderFactory){this._oDataProviderFactory.destroy();}this._oDestinations=new h(this.getHostInstance(),this._oCardManifest.get(M.DESTINATIONS));this._oIconFormatter=new o(this._oDestinations);this._oDataProviderFactory=new D(this._oDestinations,E,this);this._oLoadingProvider=new i();if(E){E.onCardReady();}this._fillFiltersModel();};u.prototype._fillFiltersModel=function(){var v=this.getModel("filters"),w=this._oCardManifest.get(M.FILTERS);for(var K in w){v.setProperty("/"+K,{"value":w[K].value});}};u.prototype._applyManifestSettings=function(){this._applyServiceManifestSettings();this._applyFilterBarManifestSettings();this._applyDataManifestSettings();this._applyHeaderManifestSettings();this._applyContentManifestSettings();};u.prototype._applyDataManifestSettings=function(){var v=this._oCardManifest.get(M.DATA);if(!v){this.fireEvent("_cardReady");return;}this.bindObject(v.path||"/");if(this._oDataProvider){this._oDataProvider.destroy();}this._oDataProvider=this._oDataProviderFactory.create(v,this._oServiceManager);if(this._oDataProvider){this.setModel(new J());this._oDataProvider.attachDataRequested(function(){this.onDataRequested();}.bind(this));this._oDataProvider.attachDataChanged(function(E){this.getModel().setData(E.getParameter("data"));if(this._createContentPromise){this._createContentPromise.then(function(w){w.onDataChanged();});}this.onDataRequestComplete();}.bind(this));this._oDataProvider.attachError(function(E){this._handleError("Data service unavailable. "+E.getParameter("message"));this.onDataRequestComplete();}.bind(this));this._oDataProvider.triggerDataUpdate();}};u.prototype._handleCardLoading=function(){var v=this.getCardContent();if(v&&!v.hasStyleClass("sapFCardErrorContent")&&v._oLoadingPlaceholder){var w=v.getAggregation("_content");if(w){w.removeStyleClass("sapFCardContentHidden");}v._oLoadingPlaceholder.destroy();}if(this._oLoadingProvider){this._oLoadingProvider.removeHeaderPlaceholder(this.getCardHeader());}this._oLoadingProvider.setLoading(false);};u.prototype._applyServiceManifestSettings=function(){var v=this._oCardManifest.get(M.SERVICES);if(!v){return;}if(!this._oServiceManager){this._oServiceManager=new S(v,this);}};u.prototype.getCardHeader=function(){return this.getAggregation("_header");};u.prototype.getCardHeaderPosition=function(){if(!this._oCardManifest){return"Top";}return this._oCardManifest.get(M.HEADER_POSITION)||s.Top;};u.prototype.getCardContent=function(){return this.getAggregation("_content");};u.prototype._applyHeaderManifestSettings=function(){var v=this.createHeader();if(!v){this.fireEvent("_headerReady");return;}this.destroyAggregation("_header");this.setAggregation("_header",v);if(v.isReady()){this.fireEvent("_headerReady");}else{v.attachEvent("_ready",function(){this.fireEvent("_headerReady");}.bind(this));}};u.prototype._applyFilterBarManifestSettings=function(){var v=this.createFilterBar();if(!v){this.fireEvent("_filterBarReady");return;}v.attachEventOnce("_filterBarDataReady",function(){this.fireEvent("_filterBarReady");}.bind(this));this.destroyAggregation("_filterBar");this.setAggregation("_filterBar",v);};u.prototype.getHostInstance=function(){var v=this.getHost();if(!v){return null;}return C.byId(v);};u.prototype._applyContentManifestSettings=function(){var v=this._oCardManifest.get(M.TYPE),w=this.getContentManifest(),A=v+" "+this._oRb.getText("ARIA_ROLEDESCRIPTION_CARD");this._ariaText.setText(A);if(!w){this.fireEvent("_contentReady");return;}this._setTemporaryContent(v,w);if(this._bIsPreviewMode){this.fireEvent("_contentReady");return;}this._createContentPromise=this.createContent({cardType:v,contentManifest:w,serviceManager:this._oServiceManager,dataProviderFactory:this._oDataProviderFactory,iconFormatter:this._oIconFormatter,appId:this._sAppId}).then(function(x){this._setCardContent(x);return x;}.bind(this));this._createContentPromise.catch(function(E){if(E){this._handleError(E);}}.bind(this));};u.prototype.createHeader=function(){var v=this._oCardManifest.get(M.HEADER),w=new j(this);return w.create(v);};u.prototype.createFilterBar=function(){var v=this._oCardManifest.get(M.FILTERS),w=this.getModel("filters"),x=w.getProperty("/"),y=new p(this);return y.create(v,x);};u.prototype.getContentManifest=function(){var v=this._oCardManifest.get(M.TYPE),w=v&&v.toLowerCase()==="component",x=this._oCardManifest.get(M.CONTENT),y=!!x;if(y&&!v){L.error("Card type property is mandatory!");return null;}if(!y&&!w){return null;}if(!x&&w){x=this._oCardManifest.getJson();}return x;};u.prototype.createContent=function(v){v.cardManifest=this._oCardManifest;return this._oContentFactory.create(v);};u.prototype.onAfterRendering=function(){var v;if(this._oCardManifest&&this._oCardManifest.get(M.TYPE)){v=this._oCardManifest.get(M.TYPE).toLowerCase();}this.toggleStyleClass("sapFCardAnalytical",v==="analytical");};u.prototype._setCardContent=function(v){v.attachEvent("_error",function(E){this._handleError(E.getParameter("logMessage"),E.getParameter("displayMessage"));}.bind(this));var P=this.getAggregation("_content");if(P&&P!==this._oTemporaryContent){P.destroy();}this.setAggregation("_content",v);if(v.isReady()){this.fireEvent("_contentReady");}else{v.attachEvent("_ready",function(){this.fireEvent("_contentReady");}.bind(this));}};u.prototype._setTemporaryContent=function(v,w){var x=this._getTemporaryContent(v,w),P=this.getAggregation("_content");if(P&&P!==x){P.destroy();}this.setAggregation("_content",x);};u.prototype._handleError=function(v,w){L.error(v);this.fireEvent("_error",{message:v});var x="Unable to load the data.",E=w||x,P=this.getAggregation("_content");var y=new H({justifyContent:"Center",alignItems:"Center",items:[new b({src:"sap-icon://message-error",size:"1rem"}).addStyleClass("sapUiTinyMargin"),new T({text:E})]}).addStyleClass("sapFCardErrorContent");if(P&&!P.hasStyleClass("sapFCardErrorContent")){P.destroy();this.fireEvent("_contentReady");}y.addEventDelegate({onAfterRendering:function(){if(!this._oCardManifest){return;}var z=this._oCardManifest.get(M.TYPE),A=this._oCardManifest.get(M.CONTENT),G=this._oContentFactory.getClass(z).getMetadata().getRenderer().getMinHeight(A,y);if(this.getHeight()==="auto"){y.$().css({"min-height":G});}}},this);this.setAggregation("_content",y);};u.prototype._getTemporaryContent=function(v,w){if(!this._oTemporaryContent&&this._oLoadingProvider){this._oTemporaryContent=this._oLoadingProvider.createContentPlaceholder(w,v);this._oTemporaryContent.addEventDelegate({onAfterRendering:function(){if(!this._oCardManifest){return;}var x=this._oContentFactory.getClass(v).getMetadata().getRenderer().getMinHeight(w,this._oTemporaryContent);if(this.getHeight()==="auto"){this._oTemporaryContent.$().css({"min-height":x});}}},this);}return this._oTemporaryContent;};u.prototype.setDataMode=function(v){if(this._oDataProviderFactory&&v===t.Inactive){this._oDataProviderFactory.destroy();this._oDataProviderFactory=null;}this.setProperty("dataMode",v,true);if(this.getProperty("dataMode")===t.Active){this.refresh();}return this;};u.prototype.loadDesigntime=function(){if(this._oDesigntime){return Promise.resolve(this._oDesigntime);}if(!this._oCardManifest){return new Promise(function(v,w){this.attachManifestReady(function(){this.loadDesigntime().then(v,w);}.bind(this));}.bind(this));}var A=this._oCardManifest.get("/sap.app/id");if(!A){return Promise.reject("App id not maintained");}return new Promise(function(v,w){var x=this._oCardManifest.get("/sap.card/designtime"),y=this._oCardManifest.get("/sap.app/id").replace(/\./g,"/")+"/"+x;if(y){sap.ui.require([y],function(z){z=new z();z._readyPromise(this._oLimitedInterface,this).then(function(){this._oDesigntime=z;v(z);}.bind(this));}.bind(this),function(){w({error:y+" not found"});});}else{w();}}.bind(this));};u.prototype.isLoading=function(){return this._oLoadingProvider?this._oLoadingProvider.getLoadingState():false;};u.prototype.getFocusDomRef=function(){var v=this.getCardHeader();if(v&&v.getDomRef()){return v.getDomRef();}return this.getDomRef();};u.prototype.onDataRequested=function(){this._oLoadingProvider.createLoadingState(this._oDataProvider);};u.prototype.onDataRequestComplete=function(){this.fireEvent("_cardReady");this._handleCardLoading();this._oLoadingProvider.setLoading(false);};u.prototype.request=function(v){return this._oDataProviderFactory.create({request:v}).setAllowCustomDataType(true).getData();};u.prototype.triggerAction=function(A){r.fireAction({card:this,host:this.getHostInstance(),action:A,parameters:A.parameters,source:this});};u.prototype._setPreviewMode=function(v){this._bIsPreviewMode=v;if(v){this.addStyleClass("sapFCardPreview");}else{this.removeStyleClass("sapFCardPreview");}this._bApplyManifest=true;this.invalidate();};return u;});
