/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Core","sap/ui/mdc/Control","./chart/ChartSettings","sap/ui/base/SyncPromise","sap/ui/mdc/util/loadModules","./ChartRenderer","sap/ui/base/ManagedObjectObserver","sap/ui/model/json/JSONModel","sap/ui/mdc/library","sap/ui/model/base/ManagedObjectModel","sap/ui/model/Sorter","sap/base/Log","sap/base/util/deepEqual","sap/ui/Device","sap/ui/mdc/chart/ToolbarHandler","sap/ui/mdc/mixin/FilterIntegrationMixin"],function(C,a,b,S,l,c,M,J,d,e,f,L,g,D,T,F){"use strict";var h,m,n,o,p,q="sap.ui.mdc.IFilter";var r=a.extend("sap.ui.mdc.Chart",{metadata:{library:"sap.ui.mdc",interfaces:["sap.ui.mdc.IxState"],defaultAggregation:"items",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%",invalidate:true},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%",invalidate:true},delegate:{type:"object",group:"Data",defaultValue:{name:"sap/ui/mdc/ChartDelegate"}},header:{type:"string",group:"Misc",defaultValue:null},noDataText:{type:"string"},chartType:{type:"string",group:"Misc",defaultValue:"column"},selectionMode:{type:"string",group:"Misc",defaultValue:"MULTIPLE"},p13nMode:{type:"sap.ui.mdc.ChartP13nMode[]"},legendVisible:{type:"boolean",group:"Misc",defaultValue:true},vizProperties:{type:"object",group:"Misc"},_colorings:{type:"object",visibility:"_hidden",byValue:true},ignoreToolbarActions:{type:"sap.ui.mdc.ChartToolbarActionType[]",defaultValue:[]},minWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"240px",invalidate:true},minHeight:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"400px",invalidate:true},sortConditions:{type:"object"}},aggregations:{data:{multiple:true},items:{type:"sap.ui.mdc.chart.Item",multiple:true},actions:{type:"sap.ui.core.Control",multiple:true,forwarding:{idSuffix:"--toolbar",aggregation:"actions"}},_chart:{type:"sap.chart.Chart",multiple:false},_toolbar:{type:"sap.ui.mdc.ActionToolbar",multiple:false},_breadcrumbs:{type:"sap.m.Breadcrumbs",multiple:false},selectionDetailsActions:{type:"sap.ui.mdc.chart.SelectionDetailsActions",multiple:false}},associations:{filter:{type:q,multiple:false}},events:{selectionDetailsActionPressed:{parameters:{action:{type:"sap.ui.core.Item"},itemContexts:{type:"sap.ui.model.Context"},level:{type:"sap.m.SelectionDetailsActionLevel"}}},dataPointsSelected:{parameters:{dataContext:{type:"object"}}}}}});var _=function(v){if(!this.oChartPromise){return;}this.oChartPromise.then(function(i){if(this.bIsDestroyed){return;}v=v||this.getSelectionMode();i.setSelectionMode(v);if(v!=="NONE"){this._prepareSelection();}}.bind(this));};F.call(r.prototype);r.prototype.init=function(){this._oObserver=new M(this.update.bind(this));this._oAdaptationController=null;this._oObserver.observe(this,{aggregations:["items","_chart"],properties:["ignoreToolbarActions","p13nMode"]});this._oManagedObjectModel=new e(this);this.setModel(this._oManagedObjectModel,"$mdcChart");a.prototype.init.apply(this,arguments);var R=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");this.setProperty("adaptationConfig",{itemConfig:{changeOperations:{add:"addItem",remove:"removeItem",move:"moveItem"},containerSettings:{title:R.getText("chart.PERSONALIZATION_DIALOG_TITLE")},adaptationUI:"sap/ui/mdc/p13n/panels/ChartItemPanel",additionalDeltaAttributes:["role"]}});};r.prototype.initModules=function(i){this.initControlDelegate(i[0]);h=i[1];o=i[2];p=i[3];};function s(){return["sap/chart/Chart","sap/ui/mdc/chart/ChartTypeButton","sap/ui/mdc/chart/MeasureItem"];}r.prototype.applySettings=function(i,j){var A;if(i){A=i.actions;delete i.actions;}var k=(i&&i.delegate)||this.getDelegate();var v=k&&k.name;var w=[v].concat(s());this.oChartPromise=l(w).then(function y(x){this.initModules(x);if(this.bIsDestroyed){return S.reject();}return this.getControlDelegate().fetchProperties(this);}.bind(this)).then(function x(P){return this.retrieveAdaptationController().then(function(){return P;});}.bind(this)).then(function x(P){if(this.bIsDestroyed){return S.reject();}T.createToolbar(this,A);var I={};P.forEach(function(y){I[y.name]=y;});return this._createInnerChart(i,I);}.bind(this)).then(function x(I){this._createDrillBreadcrumbs();return I;}.bind(this)).catch(function x(E){if(E){L.error("The control could not be initialized.",E,this.getMetadata().getName());}}.bind(this));if(!i||i.selectionMode===undefined){_.apply(this);}return a.prototype.applySettings.apply(this,arguments);};r.prototype.bindAggregation=function(N,B,i){if(N=="data"){this.oDataInfo=B;var j=this.getAggregation("_chart");if(j&&this.bDelegateInitialized){this.getControlDelegate().rebindChart(this,B,i);}else if(this.oChartPromise){this.oChartPromise.then(function(j){this.getControlDelegate().rebindChart(this,B,i);}.bind(this));}return this;}return a.prototype.bindAggregation.apply(this,arguments);};r.prototype.getBindingInfo=function(N){if(N=="data"){return this.oDataInfo;}return a.prototype.getBindingInfo.apply(this,arguments);};r.prototype.setLegendVisible=function(v){this.setVizProperties({'legend':{'visible':v},'sizeLegend':{'visible':v}});return this.setProperty("legendVisible",v);};r.prototype._createInnerChart=function(k,I){k=k||{};var v={},w,V=[],x=[],y=[],z={};v.chartType='{$mdcChart>/chartType}';v.dimensions=[];v.measures=[];v.id=this.getId()+"--innerChart";v.height='100%';v.width='100%';v.vizProperties='{$mdcChart>/vizProperties}';k.items=k.items||[];function A(j){if(this&&this.getVizItemType()=="Dimension"){v.dimensions.push(j);}else{v.measures.push(j);}}function B(w,H){if(w.getCriticality()){H._addCriticality(w);}y.push(w.getKey());if(w.getAdditionalColoringMeasures){for(var j=0;j<w.getAdditionalColoringMeasures().length;j++){if(x.indexOf(w.getAdditionalColoringMeasures()[j])==-1){x.push(w.getAdditionalColoringMeasures()[j]);}}}}function E(){var K,j;for(var i=0;i<x.length;i++){K=x[i];if(y.indexOf(K)==-1){j=this.getControlDelegate().retrieveAggregationItem("items",I[K]);j=p.getVizItemSettings(j.settings);V.push(p.createVizChartItem(j).then(A));}}}for(var i=0;i<k.items.length;i++){w=k.items[i];B(w,this);if(I[w.getKey()]){z=this.getControlDelegate().retrieveAggregationItem("items",I[w.getKey()]).settings;}else{z=undefined;}V.push(w.toVizChartItem(z).then(A.bind(w)));}E();var G=function(j){this.fireDataPointsSelected({dataContext:j.getParameters()});};return Promise.all(V).then(function(){var j=new h(v);j.setVisibleDimensions([]);j.setVisibleMeasures([]);j.setInResultDimensions([]);j.attachSelectData(function(H){G.call(this,H);}.bind(this));j.attachDeselectData(function(H){G.call(this,H);}.bind(this));this._oObserver.observe(j,{bindings:["data"],aggregations:["dimensions","measures"]});this.setAggregation("_chart",j);return j;}.bind(this));};r.prototype.setSelectionMode=function(v){this.setProperty("selectionMode",v,true);v=this.getSelectionMode();_.call(this,v);return this;};r.prototype.addItem=function(i,j){var k=this.getAggregation("_chart");if(k){i.toChart(k);}else if(this.oChartPromise){this.oChartPromise.then(function(k){if(k){this.toChart(k);}}.bind(i));}this._oObserver.observe(i,{properties:["visible","inResult","role"]});return this.addAggregation("items",i,j);};r.prototype.insertItem=function(i,I,j){if(i.getCriticality()){this._addCriticality(i);}var k=this.getAggregation("_chart");if(k){i.toChart(k);}else if(this.oChartPromise){this.oChartPromise.then(function(k){if(k){this.toChart(k);}}.bind(i));}this._oObserver.observe(i,{properties:["visible","inResult","role"]});return this.insertAggregation("items",i,I,j);};r.prototype.removeItem=function(i,j){this._oObserver.unobserve(i);return this.removeAggregation("items",i,j);};r.prototype.exit=function(){a.prototype.exit.apply(this,arguments);this.oChartPromise=null;this._oSelectionHandlerPromise=null;var i=this.getAggregation("_chart");if(i){i.destroy();}};r.prototype.getItemsByKeys=function(I){var j=[],k=this.getItems();I.forEach(function(v){for(var i=k.length-1;i>=0;i--){if(k[i].getKey()==v){j.push(k[i]);break;}}});return j;};r.prototype._showDrillDown=function(){if(n){if(!this._oDrillDownPopover){n.createDrillDownPopover(this);}return n.showDrillDownPopover(this);}return new Promise(function(i,j){sap.ui.require(["sap/ui/mdc/chart/DrillStackHandler"],function(k){n=k;n.createDrillDownPopover(this);n.showDrillDownPopover(this).then(function(v){i(v);});}.bind(this));}.bind(this));};r.prototype._createDrillBreadcrumbs=function(){if(n){if(!this._oDrillBreadcrumbs){return n.createDrillBreadcrumbs(this);}return Promise.resolve(this._oDrillBreadcrumbs);}return new Promise(function(i,j){sap.ui.require(["sap/ui/mdc/chart/DrillStackHandler"],function(k){n=k;n.createDrillBreadcrumbs(this).then(function(v){i(v);});}.bind(this));}.bind(this));};r.prototype._getPropertyData=function(){return new Promise(function(i,j){if(!this.aFetchedProperties){return this.oChartPromise.then(function(){return this.getControlDelegate().fetchProperties(this);}.bind(this)).then(function(k){this.aFetchedProperties=k;i(k);}.bind(this));}else{i(this.aFetchedProperties);}}.bind(this));};r.prototype.getAvailableChartTypes=function(){var j=[];var k=this.getAggregation("_chart");if(k){var A=k.getAvailableChartTypes().available;if(j){var v=C.getLibraryResourceBundle("sap.chart.messages");for(var i=0;i<A.length;i++){var w=A[i].chart;j.push({key:w,icon:o.mMatchingIcon[w],text:v.getText("info/"+w),selected:(w==this.getChartType())});}}}return j;};r.prototype.getTypeInfo=function(){var i=this.getChartType(),j=C.getLibraryResourceBundle("sap.ui.mdc");var I={icon:o.mMatchingIcon[i],text:j.getText("chart.CHART_TYPE_TOOLTIP",[i])};return I;};r.prototype.getManagedObjectModel=function(){return this._oManagedObjectModel;};r.prototype.update=function(i){var j=this.getAggregation("_chart");if(j){this._update(j,i);}else if(this.oChartPromise){this.oChartPromise.then(function(j){if(j){this._update(j,i);}}.bind(this));}};r.prototype._update=function(j,k){var I=this.getItems(),v,w,V=[],x=[],y=[],z={};if(k.name==="ignoreToolbarActions"||k.name==="p13nMode"){T.updateToolbar(this);return;}if(k.name==="data"&&k.type==="binding"&&k.mutation==="prepare"&&k.object.isA("sap.chart.Chart")){k.bindingInfo.sorter=this._getSorters();}this._aInResultProperties=[];for(var i=0;i<I.length;i++){w=I[i];v=w.getVizItemType()=="Measure"?j.getMeasureByName(w.getKey()):j.getDimensionByName(w.getKey());if(!v){continue;}if(w.getVisible()){if(w.getVizItemType()=="Measure"){V.push(v.getName());if(w.getDataPoint()){z[v.getName()]=w.getDataPoint();}}else{x.push(v.getName());}this._aInResultProperties.push(v.getName());}if(w.getVizItemType()=="Dimension"){if(w.getInResult()){y.push(v.getName());this._aInResultProperties.push(v.getName());}}}var R=false;if(!g(x,j.getVisibleDimensions())){j.setVisibleDimensions(x);R=true;}if(!g(V,j.getVisibleMeasures())){j.setVisibleMeasures(V);R=true;}if(!g(y,j.getInResultDimensions())){j.setInResultDimensions(y);R=true;}if(R){this.rebind();this._updateSemanticalPattern(j,V,z);this._updateColoring(j,x,V);}if(n&&this.getAggregation("_breadcrumbs")){n._updateDrillBreadcrumbs(this,this.getAggregation("_breadcrumbs"));}};r.prototype._updateSemanticalPattern=function(i,v,j){for(var k=0;k<v.length;k++){var w=j[v[k]];if(w){if(w.targetValue||w.foreCastValue){var A=i.getMeasureByName(v[k]);A.setSemantics("actual");if(w.targetValue!=null){var R=i.getMeasureByName(w.targetValue);if(R){R.setSemantics("reference");}else{L.error("sap.ui.mdc.Chart: "+w.targetValue+" is not a valid measure");}}if(w.foreCastValue){var P=i.getMeasureByName(w.foreCastValue);if(P){P.setSemantics("projected");}else{L.error("sap.ui.comp.SmartChart: "+w.ForecastValue.Path+" is not a valid measure");}}A.setSemanticallyRelatedMeasures({referenceValueMeasure:w.targetValue,projectedValueMeasure:w.foreCastValue});}}}};r.prototype._updateColoring=function(i,v,V,j){var w=this.getProperty("_colorings"),k;if(w&&w.Criticality){var A;for(k=0;k<v.length;k++){if(w.Criticality.DimensionValues[v[k]]){A={coloring:"Criticality",parameters:{dimension:v[k]}};delete w.Criticality.MeasureValues;break;}}if(!A){delete w.Criticality.DimensionValues;for(var x in w.Criticality.MeasureValues){if(V.indexOf(x)==-1){delete w.Criticality.MeasureValues[x];}}A={coloring:"Criticality",parameters:{measure:V}};}if(A){i.setColorings(w);i.setActiveColoring(A);}}};r.prototype._prepareSelection=function(){if(m){m.prepareChart(this);}else{this._oSelectionHandlerPromise=l(["sap/ui/mdc/chart/SelectionHandler"]).then(function(i){m=i[0];if(this.bIsDestroyed){return;}m.prepareChart(this);}.bind(this));}};r.prototype._getSorters=function(){var i;var j=this.getSortConditions()?this.getSortConditions().sorters:[];j.forEach(function(k){if(this._aInResultProperties.indexOf(k.name)!=-1){var v=new f(k.name,k.descending);if(i){i.push(v);}else{i=[v];}}}.bind(this));return i;};r.prototype.rebind=function(){if(!this.bDelegateInitialized){return;}var B=this.oDataInfo,i=this.getControlDelegate();if(i){i.updateBindingInfo(this,B);}if(!this.isInnerChartBound()){return;}if(B){B.sorter=this._getSorters();B.binding.bHasAnalyticalInfo=true;}this.bindAggregation("data",B);this._updateInnerChartNoDataText();this._renderOverlay(false);};r.prototype.isInnerChartBound=function(){return this.getAggregation("_chart")?this.getAggregation("_chart").isBound("data"):false;};r.prototype._onFiltersChanged=function(E){if(this.isInnerChartBound()&&E.getParameter("conditionsBased")){this._renderOverlay(true);}};r.prototype._renderOverlay=function(i){if(this.getAggregation("_chart")){var $=this.getAggregation("_chart").$(),j=$.find(".sapUiMdcChartOverlay");if(i&&j.length===0){j=jQuery("<div>").addClass("sapUiOverlay sapUiMdcChartOverlay").css("z-index","1");$.append(j);}else if(!i){j.remove();}}};r.prototype.setNoDataText=function(N){this.setProperty("noDataText",N,true);this._updateInnerChartNoDataText();return this;};r.prototype._onFilterProvided=function(){this._updateInnerChartNoDataText();};r.prototype._updateInnerChartNoDataText=function(){var i=this.getAggregation("_chart");if(!i){return;}i.setCustomMessages({'NO_DATA':this._getNoDataText()});};r.prototype._getNoDataText=function(){var N=this.getNoDataText();if(N){return N;}var R=C.getLibraryResourceBundle("sap.ui.mdc");if(!this.isInnerChartBound()){if(this.getFilter()){return R.getText("chart.NO_DATA_WITH_FILTERBAR");}return R.getText("chart.NO_DATA");}return R.getText("chart.NO_RESULTS");};r.prototype._addCriticality=function(i){var j=this.getProperty("_colorings");j=j||{Criticality:{DimensionValues:{},MeasureValues:{}}};var k=i.getCriticality(),v={};if(i.getVizItemType()=="Dimension"){for(var K in k){v[K]={Values:k[K]};}j.Criticality.DimensionValues[i.getKey()]=v;}else{for(var K in k){v[K]=k[K];}j.Criticality.MeasureValues[i.getKey()]=v;}this.setProperty("_colorings",j);};r.prototype.getCollectionModel=function(){var B=this.getBindingInfo("data");return B?this.getModel(B.model):null;};r.prototype.getCollectionPath=function(){var B=this.getBindingInfo("data");return B?B.path:null;};r.prototype.done=function(){return this.oChartPromise;};r.prototype.initialized=function(){return this.oChartPromise;};var t=function(i){var P=[];if(i){i.getItems().forEach(function(j,I){P.push({name:j.getKey(),role:j.getRole()});});}return P;};var u=function(i){return i.getSortConditions()?i.getSortConditions().sorters:[];};r.prototype.isFilteringEnabled=function(){var P=this.getP13nMode()||[];return P.indexOf("Filter");};r.prototype.getCurrentState=function(){var i={};var P=this.getP13nMode();if(P){if(P.indexOf("Item")>-1){i.items=t(this);}if(P.indexOf("Sort")>-1){i.sorters=u(this);}}return i;};return r;},true);
