/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Control','sap/ui/base/ManagedObjectObserver','sap/base/util/merge','sap/base/util/deepEqual','sap/ui/mdc/condition/Condition','sap/ui/mdc/condition/FilterOperatorUtil','sap/ui/mdc/condition/Operator','sap/ui/mdc/enum/EditMode','sap/ui/mdc/enum/FieldDisplay','sap/ui/mdc/enum/BaseType','sap/ui/mdc/enum/ConditionValidated','sap/ui/mdc/Field','sap/ui/mdc/field/ListFieldHelp','sap/ui/model/base/ManagedObjectModel','sap/ui/model/json/JSONModel','sap/ui/model/resource/ResourceModel','sap/ui/model/type/String','sap/ui/core/InvisibleText','sap/ui/core/ListItem','sap/ui/layout/Grid','sap/ui/layout/GridData','sap/m/library','sap/m/ScrollContainer','sap/m/Button','sap/m/Panel'],function(C,M,m,d,a,F,O,E,b,B,c,e,L,f,J,R,S,I,g,G,h,l,j,k,P){"use strict";var o=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");sap.ui.getCore().attachLocalizationChanged(function(){o=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");});var n=l.ButtonType;var D=C.extend("sap.ui.mdc.field.DefineConditionPanel",{metadata:{library:"sap.ui.mdc",properties:{conditions:{type:"object[]",group:"Data",defaultValue:[],byValue:true},formatOptions:{type:"object",defaultValue:{}},label:{type:"string",defaultValue:""}},aggregations:{_content:{type:"sap.ui.core.Control",multiple:false}},events:{}},_oManagedObjectModel:null,renderer:{apiVersion:2,render:function(i,Z){i.openStart("section",Z);i.class("sapUiMdcDefineConditionPanel");i.openEnd();i.renderControl(Z.getAggregation("_content"));i.close("section");}},init:function(){sap.ui.getCore().getMessageManager().registerObject(this,true);C.prototype.init.apply(this,arguments);this._oManagedObjectModel=new f(this);this._oObserver=new M(_.bind(this));this._oObserver.observe(this,{properties:["conditions","formatOptions"]});z.call(this);this.setModel(this._oManagedObjectModel,"$this");this.setModel(this._oManagedObjectModel,"$condition");},exit:function(){sap.ui.getCore().getMessageManager().unregisterObject(this,true);this._oObserver.disconnect();this._oObserver=undefined;if(this._sConditionsTimer){clearTimeout(this._sConditionsTimer);this._sConditionsTimer=null;}if(this._oDefaultType){this._oDefaultType.destroy();delete this._oDefaultType;}this._oManagedObjectModel.destroy();delete this._oManagedObjectModel;},byId:function(i){return sap.ui.getCore().byId(this.getId()+"--"+i);},onBeforeRendering:function(){if(!this.getModel("$i18n")){this.setModel(new R({bundleName:"sap/ui/mdc/messagebundle",async:false}),"$i18n");}if(this.getConditions().length===0){this.updateDefineConditions();}},removeCondition:function(i){var Z=i.oSource;var $=Z.getBindingContext("$this").getObject();var a1=this.getConditions();var b1=F.indexOfCondition($,a1);a1.splice(b1,1);this.setProperty("conditions",a1,true);},addCondition:function(i){var Z=this.getConditions();var $=this.getFormatOptions();var a1=$.maxConditions;if(a1===-1||Z.length<a1){this.addDummyCondition(Z.length+1);if(this.getConditions().length===a1){this._bFocusLastCondition=true;}}},addDummyCondition:function(i){var Z=s.call(this);var $=u.call(this);var a1=w.call(this,$);var b1=F.getDefaultOperator(a1);var c1=Z.indexOf(b1.name)>=0?b1.name:Z[0];var d1=a.createCondition(c1,[null],undefined,undefined,c.NotValidated);F.updateConditionValues(d1);F.checkConditionsEmpty(d1,Z);var e1=this.getConditions();if(i!==undefined){e1.splice(i,0,d1);}else{e1.push(d1);}this.setProperty("conditions",e1,true);},updateDefineConditions:function(){var i=this.getConditions().filter(function(Z){return Z.validated!==c.Validated;});y.call(this,i,true,false);if(i.length===0){this.addDummyCondition();}},onChange:function(i){var Z=s.call(this);var $=this.getConditions();F.checkConditionsEmpty($,Z);F.updateConditionsValues($,Z);this.setProperty("conditions",$,true);},onSelectChange:function(i){var Z=i.getSource();var $=Z.getValue();var a1=Z._sOldKey;var b1=F.getOperator($);var c1=a1&&F.getOperator(a1);if(b1&&c1){var d1;var e1;var f1;var g1=false;if(!d(b1.valueTypes[0],c1.valueTypes[0])&&b1.valueTypes[0]!==O.ValueType.Static){d1=Z.getBindingContext("$this").getObject();e1=this.getConditions();f1=F.indexOfCondition(d1,e1);if(f1>=0){d1=e1[f1];if(d1.values.length>0&&d1.values[0]!==null){d1.values[0]=null;g1=true;}if(d1.values.length>1&&d1.values[1]!==null){d1.values[1]=null;g1=true;}}}if(!b1.valueTypes[1]&&c1.valueTypes[1]){if(!d1){d1=Z.getBindingContext("$this").getObject();e1=this.getConditions();f1=F.indexOfCondition(d1,e1);d1=e1[f1];}if(f1>=0){if(d1.values.length>1&&d1.values[1]){d1.values=d1.values.slice(0,1);g1=true;}}}if(g1){this.setProperty("conditions",e1,true);}}delete Z._sOldKey;},onPaste:function(Z){var $,a1=Z.srcControl;if(window.clipboardData){$=window.clipboardData.getData("Text");}else{$=Z.originalEvent.clipboardData.getData('text/plain');}var b1=$.split(/\r\n|\r|\n/g);if(b1&&b1.length>1){setTimeout(function(){var c1=s.call(this);var d1=u.call(this);var e1=w.call(this,d1);var f1=b1.length;var g1=this.getConditions();for(var i=0;i<f1;i++){if(b1[i]){var h1=b1[i];var i1=h1.split(/\t/g);var j1;if(i1.length==2&&i1[0]&&i1[1]){j1=F.getOperator("BT");}else{i1=[h1.trim()];j1=F.getDefaultOperator(e1);}h1=j1?j1.format(a.createCondition(j1.name,i1)):i1[0];if(j1){var k1=j1.getCondition(h1,d1,b.Value,true);if(k1){k1.validated=c.NotValidated;F.checkConditionsEmpty(k1,c1);g1.push(k1);}}}}this.setProperty("conditions",g1,true);if(a1.setDOMValue){a1.setDOMValue("");}}.bind(this),0);}}});function _(i){if(i.name==="value"){p.call(this,i.object,i.current,i.old);}if(i.name==="formatOptions"){var Z=this.getConditions();var $=i.current&&i.current.operators;var a1=i.old&&i.old.operators;var b1=false;if(!d($,a1)){b1=true;t.call(this);}var c1=i.current&&i.current.valueType&&i.current.valueType.getMetadata().getName();var d1=i.old&&i.old.valueType&&i.old.valueType.getMetadata().getName();if(c1!==d1&&Z.length>0){if(!b1){t.call(this);}this._bUpdateType=true;K.call(this);this._bUpdateType=false;y.call(this,Z,true,true);}}if(i.name==="conditions"){if(this._sConditionsTimer){clearTimeout(this._sConditionsTimer);this._sConditionsTimer=null;}this._sConditionsTimer=setTimeout(function(){this._sConditionsTimer=null;this.updateDefineConditions();K.call(this);}.bind(this),0);}}function p(Z,$,a1){Z._sOldKey=a1;var b1=0;if($&&a1){var c1=F.getOperator($);var d1=F.getOperator(a1);var e1=Z.getParent();var f1;b1=e1.indexOfContent(Z);if(c1.createControl||d1.createControl){f1=e1.getContent()[b1+2];if(f1&&f1.hasOwnProperty("_iValueIndex")&&f1._iValueIndex===0){f1.destroy();}f1=e1.getContent()[b1+2];if(f1&&f1.hasOwnProperty("_iValueIndex")&&f1._iValueIndex===1){f1.destroy();}}else{if(c1.valueTypes[0]!==d1.valueTypes[0]){f1=e1.getContent()[b1+2];if(f1&&f1.hasOwnProperty("_iValueIndex")&&f1._iValueIndex===0){f1.unbindProperty("value");}}if(c1.valueTypes[1]!==d1.valueTypes[1]&&d1.valueTypes[1]){f1=e1.getContent()[b1+3];if(f1&&f1.hasOwnProperty("_iValueIndex")&&f1._iValueIndex===1){f1.unbindProperty("value");}}}}if(!$){var g1=Z.getBindingContext("$this").getObject();if(g1){var h1=this.getConditions();b1=F.indexOfCondition(g1,h1);if(b1>=0){g1=h1[b1];g1.operator=a1;this.setProperty("conditions",h1,true);}}}var i1=this.oOperatorModel.getData();var j1;for(var i=0;i<i1.length;i++){var k1=i1[i];if(k1.key===$){j1=k1.additionalText;break;}}Z.setAdditionalValue(j1);this.onChange();}function q(i,Z,$,a1){var b1=F.getOperator(i.operator);if(!b1){return null;}var c1=r.call(this,b1.name,Z);var d1=this._oManagedObjectModel.getContext(a1.getPath()+"values/"+Z+"/");var e1;if(b1.createControl){e1=b1.createControl(c1,b1,"$this>",Z);}else{e1=new e($,{delegate:x.call(this),value:{path:"$this>",type:c1,mode:'TwoWay',targetType:'raw'},editMode:{path:"$condition>operator",formatter:Q},width:"100%"});}if(e1.getMetadata().hasProperty("placeholder")){if(Z===0){e1.bindProperty("placeholder",{path:"$condition>operator",formatter:W});}else{e1.bindProperty("placeholder",{path:"$condition>operator",formatter:X});}}e1._iValueIndex=Z;if(e1.attachChange){e1.attachChange(this.onChange.bind(this));}e1.onpaste=this.onPaste.bind(this);e1.setLayoutData(new h({span:{path:"$condition>",formatter:V.bind(this)}}));e1.setBindingContext(d1,"$this");e1.setBindingContext(a1,"$condition");return e1;}function r(i,Z){var $=u.call(this);var a1=F.getOperator(i);if(a1.valueTypes[Z]&&[O.ValueType.Self,O.ValueType.Static].indexOf(a1.valueTypes[Z])===-1){$=a1._createLocalType(a1.valueTypes[Z]);}var b1=false;if(a1.valueTypes[Z]===O.ValueType.Static){b1=true;$=v.call(this);}var c1=b1?B.String:w.call(this,$);var d1;var e1;var f1;var g1;switch(c1){case B.Boolean:if($.oConstraints&&$.oConstraints.hasOwnProperty("nullable")&&$.oConstraints.nullable===false){e1=sap.ui.require($.getMetadata().getName().replace(/\./g,"/"));f1=m({},$.oFormatOptions);g1=m($.oConstraints,{nullable:true});d1=new e1(f1,g1);}else{d1=$;}break;case B.Numeric:if($.oFormatOptions&&$.oFormatOptions.hasOwnProperty("emptyString")&&$.oFormatOptions.emptyString===null){d1=$;}else{e1=sap.ui.require($.getMetadata().getName().replace(/\./g,"/"));f1=m($.oFormatOptions,{emptyString:null});d1=new e1(f1,$.oConstraints);}break;case B.Date:case B.Time:case B.DateTime:d1=$;break;default:d1=$;break;}return d1;}function s(){var i=this.getFormatOptions();var Z=i&&i.operators;if(!Z||Z.length===0){Z=F.getOperatorsForType(B.String);}return Z;}function t(){if(!this.oOperatorModel){return;}var Z=u.call(this);var $=s.call(this);var a1=o.getText("valuehelp.INCLUDE");var b1=o.getText("valuehelp.EXCLUDE");var c1=[];for(var i=0;i<$.length;i++){var d1=$[i];var e1=F.getOperator(d1);if(!e1||(e1.showInSuggest!==undefined&&e1.showInSuggest==false)){continue;}var f1=e1.textKey||"operators."+e1.name+".longText";var g1=e1.getTypeText(f1,Z.getName().toLowerCase());if(g1===f1){g1=e1.longText;}var h1=e1.additionalInfo;if(h1===undefined){if(h1!==""&&e1.formatRange){h1=e1.formatRange(e1._getRange(undefined,Z),Z);}else{h1=e1.exclude?b1:a1;}}c1.push({key:e1.name,additionalText:g1,info:h1});}this.oOperatorModel.setData(c1);}function u(){var i=this.getFormatOptions();var Z=i&&i.valueType;if(!Z){Z=v.call(this);}return Z;}function v(){if(!this._oDefaultType){this._oDefaultType=new S();}return this._oDefaultType;}function w(i){var Z=i.getMetadata().getName();var $=i.oFormatOptions;var a1=i.oConstraints;var b1=this.getFormatOptions().delegate;var c1=this.getFormatOptions().payload;var d1=b1?b1.getTypeUtil(c1).getBaseType(Z,$,a1):B.String;if(d1===B.Unit){d1=B.Numeric;}return d1;}function x(){var i=this.getFormatOptions();var Z=i.delegateName||"sap/ui/mdc/field/FieldBaseDelegate";var $=i.payload;return{name:Z,payload:$};}function y(Z,$,a1){var b1=u.call(this);var c1=[];var i=0;for(i=0;i<Z.length;i++){var d1=Z[i];var e1=F.getOperator(d1.operator);if(e1&&e1.valueTypes[0]===O.ValueType.Static&&(d1.values.length===0||a1)){if(e1.getStaticText){var f1=e1.getStaticText(b1);if(d1.values.length>0){d1.values[0]=f1;}else{d1.values.push(f1);}c1.push(i);}}}if(c1.length>0){this.setProperty("conditions",Z,true);}}function z(){var i=new I(this.getId()+"--ivtOperator",{text:"{$i18n>valuehelp.DEFINECONDITIONS_OPERATORLABEL}"});var Z=new P({headerText:"{$this>/label}",expanded:true,height:"100%",backgroundDesign:"Transparent"}).addStyleClass("sapMdcDefineconditionPanel");Z.addDependent(new L(this.getId()+"--rowSelect-help",{items:{path:'om>/',templateShareable:false,template:new g({key:"{om>key}",text:"{om>additionalText}",additionalText:"{om>info}"})},filterList:false,useFirstMatch:true}));var $=new G(this.getId()+"--conditions",{width:"100%",hSpacing:0,vSpacing:0,containerQuery:true}).addStyleClass("sapUiMdcDefineConditionGrid");N.call(this,undefined,$,0,null,0);Z.addContent(i);Z.addContent($);var a1=new k(this.getId()+"--addBtn",{press:this.addCondition.bind(this),type:n.Default,text:"{$i18n>valuehelp.DEFINECONDITIONS_ADDCONDITION}",layoutData:new h({span:"XL2 L3 M3 S3",indent:"XL9 L8 M8 S7",linebreak:true,visibleS:{path:"$this>/conditions",formatter:A.bind(this)},visibleM:{path:"$this>/conditions",formatter:A.bind(this)},visibleL:{path:"$this>/conditions",formatter:A.bind(this)},visibleXL:{path:"$this>/conditions",formatter:A.bind(this)}})});$.addContent(a1);this.setAggregation("_content",Z);}function A(i){var Z=this.getFormatOptions();var $=Z.hasOwnProperty("maxConditions")?Z.maxConditions:-1;return $===-1||i.length<$;}function H(i){var Z=this.getFormatOptions();var $=Z.hasOwnProperty("maxConditions")?Z.maxConditions:-1;return $!==1;}function K(){var Z=this.getConditions();var $=this.byId("conditions");var a1;var b1=-1;var c1=0;for(var i=0;i<Z.length;i++){var d1=Z[i];if(d1.validated!==c.Validated){var e1=this._oManagedObjectModel.getContext("/conditions/"+i+"/");b1++;if(!this.oOperatorModel){this.oOperatorModel=new J();this.setModel(this.oOperatorModel,"om");t.call(this);}a1=$.getContent();if(a1[c1]&&a1[c1].isA("sap.ui.mdc.Field")){c1=Y.call(this,d1,$,c1,e1,b1);}else{c1=N.call(this,d1,$,c1,e1,b1);}}}a1=$.getContent();while(a1[c1]&&a1[c1]!==this.byId("addBtn")){a1[c1].destroy();c1++;}if(this._bFocusLastCondition){a1[0].focus();this._bFocusLastCondition=false;}}function N(Z,$,a1,b1,c1){var d1=this.getId()+"--"+c1;if(!this._oOperatorFieldType){this._oOperatorFieldType=new S({},{minLength:1});}var e1=new e(d1+"-operator",{value:{path:"$this>operator",type:this._oOperatorFieldType},width:"100%",display:"Description",fieldHelp:this.getId()+"--rowSelect-help",change:this.onSelectChange.bind(this),ariaLabelledBy:this.getId()+"--ivtOperator"}).setLayoutData(new h({span:{path:"$this>/conditions",formatter:U.bind(this)},linebreak:true})).setBindingContext(b1,"$this");this._oObserver.observe(e1,{properties:["value"]});$.insertContent(e1,a1);a1++;var f1=new k(d1+"--removeBtnSmall",{press:this.removeCondition.bind(this),type:n.Transparent,icon:"sap-icon://decline",tooltip:"{$i18n>valuehelp.DEFINECONDITIONS_REMOVECONDITION}"}).setLayoutData(new h({span:"XL1 L1 M1 S2",indent:{path:"$this>operator",formatter:T},visibleS:{path:"$this>/conditions",formatter:H.bind(this)},visibleM:false,visibleL:false,visibleXL:false})).setBindingContext(b1,"$this");$.insertContent(f1,a1);a1++;if(Z){for(var i=0;i<Z.values.length;i++){var g1=q.call(this,Z,i,d1+"-values"+i,b1);if(g1){$.insertContent(g1,a1);a1++;}}}var h1=new k(d1+"--removeBtnLarge",{press:this.removeCondition.bind(this),type:n.Transparent,icon:"sap-icon://decline",tooltip:"{$i18n>valuehelp.DEFINECONDITIONS_REMOVECONDITION}"}).setLayoutData(new h({span:"XL1 L1 M1 S1",indent:{path:"$this>operator",formatter:T},visibleS:false,visibleM:{path:"$this>/conditions",formatter:H.bind(this)},visibleL:{path:"$this>/conditions",formatter:H.bind(this)},visibleXL:{path:"$this>/conditions",formatter:H.bind(this)}})).setBindingContext(b1,"$this");$.insertContent(h1,a1);a1++;return a1;}function Q(i){if(!i){return E.Display;}var Z=F.getOperator(i);var $=false;if(Z&&Z.valueTypes[0]===O.ValueType.Static){$=true;}return $?E.Display:E.Editable;}function T(i){var Z=i&&F.getOperator(i);if(!Z||!Z.valueTypes[0]){return"XL8 L8 M8 S0";}else{return"";}}function U(i){var Z=this.getFormatOptions();var $=Z.hasOwnProperty("maxConditions")?Z.maxConditions:-1;var a1="XL3 L3 M3 ";if($===1){a1+="S12";}else{a1+="S10";}return a1;}function V(i){var Z=this.getFormatOptions();var $=Z.hasOwnProperty("maxConditions")?Z.maxConditions:-1;var a1=i&&F.getOperator(i.operator);var b1="";if(a1&&a1.valueTypes[1]){b1="XL4 L4 M4 ";}else{b1="XL8 L8 M8 ";}if($===1){b1+="S12";}else{b1+="S10";}return b1;}function W(i){var Z=i&&F.getOperator(i);if(Z&&Z.aLabels){return Z.aLabels[0];}else if(Z&&Z.valueTypes[1]){return o.getText("valuehelp.DEFINECONDITIONS_FROM");}else{return o.getText("valuehelp.DEFINECONDITIONS_VALUE");}}function X(i){var Z=i&&F.getOperator(i);if(Z&&Z.aLabels){return Z.aLabels[1];}else if(Z&&Z.valueTypes[1]){return o.getText("valuehelp.DEFINECONDITIONS_TO");}}function Y(Z,$,a1,b1,c1){var d1=this.getId()+"--"+c1;var e1=$.getContent();var f1;var g1=e1[a1];g1.setBindingContext(b1,"$this");a1++;var h1=e1[a1];h1.setBindingContext(b1,"$this");a1++;var i1;var j1=e1[a1];var k1;if(j1.hasOwnProperty("_iValueIndex")&&j1._iValueIndex===0){var l1=Q(Z.operator);if(Z.values.length>0||l1===E.Display){i1=this._oManagedObjectModel.getContext(b1.getPath()+"values/0/");j1.setBindingContext(i1,"$this");j1.setBindingContext(b1,"$condition");if(j1.getMetadata().hasProperty("value")&&(this._bUpdateType||!j1.getBindingInfo("value"))){f1=r.call(this,Z.operator,0);j1.bindProperty("value",{path:"$this>",type:f1});}a1++;k1=e1[a1];if(k1.hasOwnProperty("_iValueIndex")&&k1._iValueIndex===1){if(Z.values.length>1){i1=this._oManagedObjectModel.getContext(b1.getPath()+"values/1/");k1.setBindingContext(i1,"$this");if(k1.getMetadata().hasProperty("value")&&(this._bUpdateType||!k1.getBindingInfo("value"))){f1=r.call(this,Z.operator,1);k1.bindProperty("value",{path:"$this>",type:f1});}a1++;}else{k1.destroy();}}else if(Z.values.length>1){k1=q.call(this,Z,1,d1+"-values1",b1);if(k1){$.insertContent(k1,a1);a1++;}}}else{j1.destroy();k1=e1[a1+1];if(k1&&k1.hasOwnProperty("_iValueIndex")&&k1._iValueIndex===1){k1.destroy();}}}else if(Z.values.length>0){for(var i=0;i<Z.values.length;i++){var m1=q.call(this,Z,i,d1+"-values"+i,b1);if(m1){$.insertContent(m1,a1);a1++;}}}e1=$.getContent();var n1=e1[a1];n1.setBindingContext(b1,"$this");a1++;return a1;}return D;});
